require.config({"config": {
        "jsbuild":{"jquery/ui-modules/widgets/checkboxradio.js":"/*!\n * jQuery UI Checkboxradio 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Checkboxradio\n//>>group: Widgets\n//>>description: Enhances a form with multiple themeable checkboxes or radio buttons.\n//>>docs: http://api.jqueryui.com/checkboxradio/\n//>>demos: http://jqueryui.com/checkboxradio/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/button.css\n//>>css.structure: ../../themes/base/checkboxradio.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../form-reset-mixin\",\n\t\t\t\"../labels\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.checkboxradio\", [ $.ui.formResetMixin, {\n\tversion: \"1.13.1\",\n\toptions: {\n\t\tdisabled: null,\n\t\tlabel: null,\n\t\ticon: true,\n\t\tclasses: {\n\t\t\t\"ui-checkboxradio-label\": \"ui-corner-all\",\n\t\t\t\"ui-checkboxradio-icon\": \"ui-corner-all\"\n\t\t}\n\t},\n\n\t_getCreateOptions: function() {\n\t\tvar disabled, labels;\n\t\tvar that = this;\n\t\tvar options = this._super() || {};\n\n\t\t// We read the type here, because it makes more sense to throw a element type error first,\n\t\t// rather then the error for lack of a label. Often if its the wrong type, it\n\t\t// won't have a label (e.g. calling on a div, btn, etc)\n\t\tthis._readType();\n\n\t\tlabels = this.element.labels();\n\n\t\t// If there are multiple labels, use the last one\n\t\tthis.label = $( labels[ labels.length - 1 ] );\n\t\tif ( !this.label.length ) {\n\t\t\t$.error( \"No label found for checkboxradio widget\" );\n\t\t}\n\n\t\tthis.originalLabel = \"\";\n\n\t\t// We need to get the label text but this may also need to make sure it does not contain the\n\t\t// input itself.\n\t\tthis.label.contents().not( this.element[ 0 ] ).each( function() {\n\n\t\t\t// The label contents could be text, html, or a mix. We concat each element to get a\n\t\t\t// string representation of the label, without the input as part of it.\n\t\t\tthat.originalLabel += this.nodeType === 3 ? $( this ).text() : this.outerHTML;\n\t\t} );\n\n\t\t// Set the label option if we found label text\n\t\tif ( this.originalLabel ) {\n\t\t\toptions.label = this.originalLabel;\n\t\t}\n\n\t\tdisabled = this.element[ 0 ].disabled;\n\t\tif ( disabled != null ) {\n\t\t\toptions.disabled = disabled;\n\t\t}\n\t\treturn options;\n\t},\n\n\t_create: function() {\n\t\tvar checked = this.element[ 0 ].checked;\n\n\t\tthis._bindFormResetHandler();\n\n\t\tif ( this.options.disabled == null ) {\n\t\t\tthis.options.disabled = this.element[ 0 ].disabled;\n\t\t}\n\n\t\tthis._setOption( \"disabled\", this.options.disabled );\n\t\tthis._addClass( \"ui-checkboxradio\", \"ui-helper-hidden-accessible\" );\n\t\tthis._addClass( this.label, \"ui-checkboxradio-label\", \"ui-button ui-widget\" );\n\n\t\tif ( this.type === \"radio\" ) {\n\t\t\tthis._addClass( this.label, \"ui-checkboxradio-radio-label\" );\n\t\t}\n\n\t\tif ( this.options.label && this.options.label !== this.originalLabel ) {\n\t\t\tthis._updateLabel();\n\t\t} else if ( this.originalLabel ) {\n\t\t\tthis.options.label = this.originalLabel;\n\t\t}\n\n\t\tthis._enhance();\n\n\t\tif ( checked ) {\n\t\t\tthis._addClass( this.label, \"ui-checkboxradio-checked\", \"ui-state-active\" );\n\t\t}\n\n\t\tthis._on( {\n\t\t\tchange: \"_toggleClasses\",\n\t\t\tfocus: function() {\n\t\t\t\tthis._addClass( this.label, null, \"ui-state-focus ui-visual-focus\" );\n\t\t\t},\n\t\t\tblur: function() {\n\t\t\t\tthis._removeClass( this.label, null, \"ui-state-focus ui-visual-focus\" );\n\t\t\t}\n\t\t} );\n\t},\n\n\t_readType: function() {\n\t\tvar nodeName = this.element[ 0 ].nodeName.toLowerCase();\n\t\tthis.type = this.element[ 0 ].type;\n\t\tif ( nodeName !== \"input\" || !/radio|checkbox/.test( this.type ) ) {\n\t\t\t$.error( \"Can't create checkboxradio on element.nodeName=\" + nodeName +\n\t\t\t\t\" and element.type=\" + this.type );\n\t\t}\n\t},\n\n\t// Support jQuery Mobile enhanced option\n\t_enhance: function() {\n\t\tthis._updateIcon( this.element[ 0 ].checked );\n\t},\n\n\twidget: function() {\n\t\treturn this.label;\n\t},\n\n\t_getRadioGroup: function() {\n\t\tvar group;\n\t\tvar name = this.element[ 0 ].name;\n\t\tvar nameSelector = \"input[name='\" + $.escapeSelector( name ) + \"']\";\n\n\t\tif ( !name ) {\n\t\t\treturn $( [] );\n\t\t}\n\n\t\tif ( this.form.length ) {\n\t\t\tgroup = $( this.form[ 0 ].elements ).filter( nameSelector );\n\t\t} else {\n\n\t\t\t// Not inside a form, check all inputs that also are not inside a form\n\t\t\tgroup = $( nameSelector ).filter( function() {\n\t\t\t\treturn $( this )._form().length === 0;\n\t\t\t} );\n\t\t}\n\n\t\treturn group.not( this.element );\n\t},\n\n\t_toggleClasses: function() {\n\t\tvar checked = this.element[ 0 ].checked;\n\t\tthis._toggleClass( this.label, \"ui-checkboxradio-checked\", \"ui-state-active\", checked );\n\n\t\tif ( this.options.icon && this.type === \"checkbox\" ) {\n\t\t\tthis._toggleClass( this.icon, null, \"ui-icon-check ui-state-checked\", checked )\n\t\t\t\t._toggleClass( this.icon, null, \"ui-icon-blank\", !checked );\n\t\t}\n\n\t\tif ( this.type === \"radio\" ) {\n\t\t\tthis._getRadioGroup()\n\t\t\t\t.each( function() {\n\t\t\t\t\tvar instance = $( this ).checkboxradio( \"instance\" );\n\n\t\t\t\t\tif ( instance ) {\n\t\t\t\t\t\tinstance._removeClass( instance.label,\n\t\t\t\t\t\t\t\"ui-checkboxradio-checked\", \"ui-state-active\" );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t}\n\t},\n\n\t_destroy: function() {\n\t\tthis._unbindFormResetHandler();\n\n\t\tif ( this.icon ) {\n\t\t\tthis.icon.remove();\n\t\t\tthis.iconSpace.remove();\n\t\t}\n\t},\n\n\t_setOption: function( key, value ) {\n\n\t\t// We don't allow the value to be set to nothing\n\t\tif ( key === \"label\" && !value ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis._toggleClass( this.label, null, \"ui-state-disabled\", value );\n\t\t\tthis.element[ 0 ].disabled = value;\n\n\t\t\t// Don't refresh when setting disabled\n\t\t\treturn;\n\t\t}\n\t\tthis.refresh();\n\t},\n\n\t_updateIcon: function( checked ) {\n\t\tvar toAdd = \"ui-icon ui-icon-background \";\n\n\t\tif ( this.options.icon ) {\n\t\t\tif ( !this.icon ) {\n\t\t\t\tthis.icon = $( \"<span>\" );\n\t\t\t\tthis.iconSpace = $( \"<span> </span>\" );\n\t\t\t\tthis._addClass( this.iconSpace, \"ui-checkboxradio-icon-space\" );\n\t\t\t}\n\n\t\t\tif ( this.type === \"checkbox\" ) {\n\t\t\t\ttoAdd += checked ? \"ui-icon-check ui-state-checked\" : \"ui-icon-blank\";\n\t\t\t\tthis._removeClass( this.icon, null, checked ? \"ui-icon-blank\" : \"ui-icon-check\" );\n\t\t\t} else {\n\t\t\t\ttoAdd += \"ui-icon-blank\";\n\t\t\t}\n\t\t\tthis._addClass( this.icon, \"ui-checkboxradio-icon\", toAdd );\n\t\t\tif ( !checked ) {\n\t\t\t\tthis._removeClass( this.icon, null, \"ui-icon-check ui-state-checked\" );\n\t\t\t}\n\t\t\tthis.icon.prependTo( this.label ).after( this.iconSpace );\n\t\t} else if ( this.icon !== undefined ) {\n\t\t\tthis.icon.remove();\n\t\t\tthis.iconSpace.remove();\n\t\t\tdelete this.icon;\n\t\t}\n\t},\n\n\t_updateLabel: function() {\n\n\t\t// Remove the contents of the label ( minus the icon, icon space, and input )\n\t\tvar contents = this.label.contents().not( this.element[ 0 ] );\n\t\tif ( this.icon ) {\n\t\t\tcontents = contents.not( this.icon[ 0 ] );\n\t\t}\n\t\tif ( this.iconSpace ) {\n\t\t\tcontents = contents.not( this.iconSpace[ 0 ] );\n\t\t}\n\t\tcontents.remove();\n\n\t\tthis.label.append( this.options.label );\n\t},\n\n\trefresh: function() {\n\t\tvar checked = this.element[ 0 ].checked,\n\t\t\tisDisabled = this.element[ 0 ].disabled;\n\n\t\tthis._updateIcon( checked );\n\t\tthis._toggleClass( this.label, \"ui-checkboxradio-checked\", \"ui-state-active\", checked );\n\t\tif ( this.options.label !== null ) {\n\t\t\tthis._updateLabel();\n\t\t}\n\n\t\tif ( isDisabled !== this.options.disabled ) {\n\t\t\tthis._setOptions( { \"disabled\": isDisabled } );\n\t\t}\n\t}\n\n} ] );\n\nreturn $.ui.checkboxradio;\n\n} );\n","jquery/ui-modules/widgets/button.js":"/*!\n * jQuery UI Button 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Button\n//>>group: Widgets\n//>>description: Enhances a form with themeable buttons.\n//>>docs: http://api.jqueryui.com/button/\n//>>demos: http://jqueryui.com/button/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/button.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\n\t\t\t// These are only for backcompat\n\t\t\t// TODO: Remove after 1.12\n\t\t\t\"./controlgroup\",\n\t\t\t\"./checkboxradio\",\n\n\t\t\t\"../keycode\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.button\", {\n\tversion: \"1.13.1\",\n\tdefaultElement: \"<button>\",\n\toptions: {\n\t\tclasses: {\n\t\t\t\"ui-button\": \"ui-corner-all\"\n\t\t},\n\t\tdisabled: null,\n\t\ticon: null,\n\t\ticonPosition: \"beginning\",\n\t\tlabel: null,\n\t\tshowLabel: true\n\t},\n\n\t_getCreateOptions: function() {\n\t\tvar disabled,\n\n\t\t\t// This is to support cases like in jQuery Mobile where the base widget does have\n\t\t\t// an implementation of _getCreateOptions\n\t\t\toptions = this._super() || {};\n\n\t\tthis.isInput = this.element.is( \"input\" );\n\n\t\tdisabled = this.element[ 0 ].disabled;\n\t\tif ( disabled != null ) {\n\t\t\toptions.disabled = disabled;\n\t\t}\n\n\t\tthis.originalLabel = this.isInput ? this.element.val() : this.element.html();\n\t\tif ( this.originalLabel ) {\n\t\t\toptions.label = this.originalLabel;\n\t\t}\n\n\t\treturn options;\n\t},\n\n\t_create: function() {\n\t\tif ( !this.option.showLabel & !this.options.icon ) {\n\t\t\tthis.options.showLabel = true;\n\t\t}\n\n\t\t// We have to check the option again here even though we did in _getCreateOptions,\n\t\t// because null may have been passed on init which would override what was set in\n\t\t// _getCreateOptions\n\t\tif ( this.options.disabled == null ) {\n\t\t\tthis.options.disabled = this.element[ 0 ].disabled || false;\n\t\t}\n\n\t\tthis.hasTitle = !!this.element.attr( \"title\" );\n\n\t\t// Check to see if the label needs to be set or if its already correct\n\t\tif ( this.options.label && this.options.label !== this.originalLabel ) {\n\t\t\tif ( this.isInput ) {\n\t\t\t\tthis.element.val( this.options.label );\n\t\t\t} else {\n\t\t\t\tthis.element.html( this.options.label );\n\t\t\t}\n\t\t}\n\t\tthis._addClass( \"ui-button\", \"ui-widget\" );\n\t\tthis._setOption( \"disabled\", this.options.disabled );\n\t\tthis._enhance();\n\n\t\tif ( this.element.is( \"a\" ) ) {\n\t\t\tthis._on( {\n\t\t\t\t\"keyup\": function( event ) {\n\t\t\t\t\tif ( event.keyCode === $.ui.keyCode.SPACE ) {\n\t\t\t\t\t\tevent.preventDefault();\n\n\t\t\t\t\t\t// Support: PhantomJS <= 1.9, IE 8 Only\n\t\t\t\t\t\t// If a native click is available use it so we actually cause navigation\n\t\t\t\t\t\t// otherwise just trigger a click event\n\t\t\t\t\t\tif ( this.element[ 0 ].click ) {\n\t\t\t\t\t\t\tthis.element[ 0 ].click();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tthis.element.trigger( \"click\" );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} );\n\t\t}\n\t},\n\n\t_enhance: function() {\n\t\tif ( !this.element.is( \"button\" ) ) {\n\t\t\tthis.element.attr( \"role\", \"button\" );\n\t\t}\n\n\t\tif ( this.options.icon ) {\n\t\t\tthis._updateIcon( \"icon\", this.options.icon );\n\t\t\tthis._updateTooltip();\n\t\t}\n\t},\n\n\t_updateTooltip: function() {\n\t\tthis.title = this.element.attr( \"title\" );\n\n\t\tif ( !this.options.showLabel && !this.title ) {\n\t\t\tthis.element.attr( \"title\", this.options.label );\n\t\t}\n\t},\n\n\t_updateIcon: function( option, value ) {\n\t\tvar icon = option !== \"iconPosition\",\n\t\t\tposition = icon ? this.options.iconPosition : value,\n\t\t\tdisplayBlock = position === \"top\" || position === \"bottom\";\n\n\t\t// Create icon\n\t\tif ( !this.icon ) {\n\t\t\tthis.icon = $( \"<span>\" );\n\n\t\t\tthis._addClass( this.icon, \"ui-button-icon\", \"ui-icon\" );\n\n\t\t\tif ( !this.options.showLabel ) {\n\t\t\t\tthis._addClass( \"ui-button-icon-only\" );\n\t\t\t}\n\t\t} else if ( icon ) {\n\n\t\t\t// If we are updating the icon remove the old icon class\n\t\t\tthis._removeClass( this.icon, null, this.options.icon );\n\t\t}\n\n\t\t// If we are updating the icon add the new icon class\n\t\tif ( icon ) {\n\t\t\tthis._addClass( this.icon, null, value );\n\t\t}\n\n\t\tthis._attachIcon( position );\n\n\t\t// If the icon is on top or bottom we need to add the ui-widget-icon-block class and remove\n\t\t// the iconSpace if there is one.\n\t\tif ( displayBlock ) {\n\t\t\tthis._addClass( this.icon, null, \"ui-widget-icon-block\" );\n\t\t\tif ( this.iconSpace ) {\n\t\t\t\tthis.iconSpace.remove();\n\t\t\t}\n\t\t} else {\n\n\t\t\t// Position is beginning or end so remove the ui-widget-icon-block class and add the\n\t\t\t// space if it does not exist\n\t\t\tif ( !this.iconSpace ) {\n\t\t\t\tthis.iconSpace = $( \"<span> </span>\" );\n\t\t\t\tthis._addClass( this.iconSpace, \"ui-button-icon-space\" );\n\t\t\t}\n\t\t\tthis._removeClass( this.icon, null, \"ui-wiget-icon-block\" );\n\t\t\tthis._attachIconSpace( position );\n\t\t}\n\t},\n\n\t_destroy: function() {\n\t\tthis.element.removeAttr( \"role\" );\n\n\t\tif ( this.icon ) {\n\t\t\tthis.icon.remove();\n\t\t}\n\t\tif ( this.iconSpace ) {\n\t\t\tthis.iconSpace.remove();\n\t\t}\n\t\tif ( !this.hasTitle ) {\n\t\t\tthis.element.removeAttr( \"title\" );\n\t\t}\n\t},\n\n\t_attachIconSpace: function( iconPosition ) {\n\t\tthis.icon[ /^(?:end|bottom)/.test( iconPosition ) ? \"before\" : \"after\" ]( this.iconSpace );\n\t},\n\n\t_attachIcon: function( iconPosition ) {\n\t\tthis.element[ /^(?:end|bottom)/.test( iconPosition ) ? \"append\" : \"prepend\" ]( this.icon );\n\t},\n\n\t_setOptions: function( options ) {\n\t\tvar newShowLabel = options.showLabel === undefined ?\n\t\t\t\tthis.options.showLabel :\n\t\t\t\toptions.showLabel,\n\t\t\tnewIcon = options.icon === undefined ? this.options.icon : options.icon;\n\n\t\tif ( !newShowLabel && !newIcon ) {\n\t\t\toptions.showLabel = true;\n\t\t}\n\t\tthis._super( options );\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"icon\" ) {\n\t\t\tif ( value ) {\n\t\t\t\tthis._updateIcon( key, value );\n\t\t\t} else if ( this.icon ) {\n\t\t\t\tthis.icon.remove();\n\t\t\t\tif ( this.iconSpace ) {\n\t\t\t\t\tthis.iconSpace.remove();\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif ( key === \"iconPosition\" ) {\n\t\t\tthis._updateIcon( key, value );\n\t\t}\n\n\t\t// Make sure we can't end up with a button that has neither text nor icon\n\t\tif ( key === \"showLabel\" ) {\n\t\t\t\tthis._toggleClass( \"ui-button-icon-only\", null, !value );\n\t\t\t\tthis._updateTooltip();\n\t\t}\n\n\t\tif ( key === \"label\" ) {\n\t\t\tif ( this.isInput ) {\n\t\t\t\tthis.element.val( value );\n\t\t\t} else {\n\n\t\t\t\t// If there is an icon, append it, else nothing then append the value\n\t\t\t\t// this avoids removal of the icon when setting label text\n\t\t\t\tthis.element.html( value );\n\t\t\t\tif ( this.icon ) {\n\t\t\t\t\tthis._attachIcon( this.options.iconPosition );\n\t\t\t\t\tthis._attachIconSpace( this.options.iconPosition );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis._toggleClass( null, \"ui-state-disabled\", value );\n\t\t\tthis.element[ 0 ].disabled = value;\n\t\t\tif ( value ) {\n\t\t\t\tthis.element.trigger( \"blur\" );\n\t\t\t}\n\t\t}\n\t},\n\n\trefresh: function() {\n\n\t\t// Make sure to only check disabled if its an element that supports this otherwise\n\t\t// check for the disabled class to determine state\n\t\tvar isDisabled = this.element.is( \"input, button\" ) ?\n\t\t\tthis.element[ 0 ].disabled : this.element.hasClass( \"ui-button-disabled\" );\n\n\t\tif ( isDisabled !== this.options.disabled ) {\n\t\t\tthis._setOptions( { disabled: isDisabled } );\n\t\t}\n\n\t\tthis._updateTooltip();\n\t}\n} );\n\n// DEPRECATED\nif ( $.uiBackCompat !== false ) {\n\n\t// Text and Icons options\n\t$.widget( \"ui.button\", $.ui.button, {\n\t\toptions: {\n\t\t\ttext: true,\n\t\t\ticons: {\n\t\t\t\tprimary: null,\n\t\t\t\tsecondary: null\n\t\t\t}\n\t\t},\n\n\t\t_create: function() {\n\t\t\tif ( this.options.showLabel && !this.options.text ) {\n\t\t\t\tthis.options.showLabel = this.options.text;\n\t\t\t}\n\t\t\tif ( !this.options.showLabel && this.options.text ) {\n\t\t\t\tthis.options.text = this.options.showLabel;\n\t\t\t}\n\t\t\tif ( !this.options.icon && ( this.options.icons.primary ||\n\t\t\t\t\tthis.options.icons.secondary ) ) {\n\t\t\t\tif ( this.options.icons.primary ) {\n\t\t\t\t\tthis.options.icon = this.options.icons.primary;\n\t\t\t\t} else {\n\t\t\t\t\tthis.options.icon = this.options.icons.secondary;\n\t\t\t\t\tthis.options.iconPosition = \"end\";\n\t\t\t\t}\n\t\t\t} else if ( this.options.icon ) {\n\t\t\t\tthis.options.icons.primary = this.options.icon;\n\t\t\t}\n\t\t\tthis._super();\n\t\t},\n\n\t\t_setOption: function( key, value ) {\n\t\t\tif ( key === \"text\" ) {\n\t\t\t\tthis._super( \"showLabel\", value );\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tif ( key === \"showLabel\" ) {\n\t\t\t\tthis.options.text = value;\n\t\t\t}\n\t\t\tif ( key === \"icon\" ) {\n\t\t\t\tthis.options.icons.primary = value;\n\t\t\t}\n\t\t\tif ( key === \"icons\" ) {\n\t\t\t\tif ( value.primary ) {\n\t\t\t\t\tthis._super( \"icon\", value.primary );\n\t\t\t\t\tthis._super( \"iconPosition\", \"beginning\" );\n\t\t\t\t} else if ( value.secondary ) {\n\t\t\t\t\tthis._super( \"icon\", value.secondary );\n\t\t\t\t\tthis._super( \"iconPosition\", \"end\" );\n\t\t\t\t}\n\t\t\t}\n\t\t\tthis._superApply( arguments );\n\t\t}\n\t} );\n\n\t$.fn.button = ( function( orig ) {\n\t\treturn function( options ) {\n\t\t\tvar isMethodCall = typeof options === \"string\";\n\t\t\tvar args = Array.prototype.slice.call( arguments, 1 );\n\t\t\tvar returnValue = this;\n\n\t\t\tif ( isMethodCall ) {\n\n\t\t\t\t// If this is an empty collection, we need to have the instance method\n\t\t\t\t// return undefined instead of the jQuery instance\n\t\t\t\tif ( !this.length && options === \"instance\" ) {\n\t\t\t\t\treturnValue = undefined;\n\t\t\t\t} else {\n\t\t\t\t\tthis.each( function() {\n\t\t\t\t\t\tvar methodValue;\n\t\t\t\t\t\tvar type = $( this ).attr( \"type\" );\n\t\t\t\t\t\tvar name = type !== \"checkbox\" && type !== \"radio\" ?\n\t\t\t\t\t\t\t\"button\" :\n\t\t\t\t\t\t\t\"checkboxradio\";\n\t\t\t\t\t\tvar instance = $.data( this, \"ui-\" + name );\n\n\t\t\t\t\t\tif ( options === \"instance\" ) {\n\t\t\t\t\t\t\treturnValue = instance;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif ( !instance ) {\n\t\t\t\t\t\t\treturn $.error( \"cannot call methods on button\" +\n\t\t\t\t\t\t\t\t\" prior to initialization; \" +\n\t\t\t\t\t\t\t\t\"attempted to call method '\" + options + \"'\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif ( typeof instance[ options ] !== \"function\" ||\n\t\t\t\t\t\t\toptions.charAt( 0 ) === \"_\" ) {\n\t\t\t\t\t\t\treturn $.error( \"no such method '\" + options + \"' for button\" +\n\t\t\t\t\t\t\t\t\" widget instance\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tmethodValue = instance[ options ].apply( instance, args );\n\n\t\t\t\t\t\tif ( methodValue !== instance && methodValue !== undefined ) {\n\t\t\t\t\t\t\treturnValue = methodValue && methodValue.jquery ?\n\t\t\t\t\t\t\t\treturnValue.pushStack( methodValue.get() ) :\n\t\t\t\t\t\t\t\tmethodValue;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t} else {\n\n\t\t\t\t// Allow multiple hashes to be passed on init\n\t\t\t\tif ( args.length ) {\n\t\t\t\t\toptions = $.widget.extend.apply( null, [ options ].concat( args ) );\n\t\t\t\t}\n\n\t\t\t\tthis.each( function() {\n\t\t\t\t\tvar type = $( this ).attr( \"type\" );\n\t\t\t\t\tvar name = type !== \"checkbox\" && type !== \"radio\" ? \"button\" : \"checkboxradio\";\n\t\t\t\t\tvar instance = $.data( this, \"ui-\" + name );\n\n\t\t\t\t\tif ( instance ) {\n\t\t\t\t\t\tinstance.option( options || {} );\n\t\t\t\t\t\tif ( instance._init ) {\n\t\t\t\t\t\t\tinstance._init();\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif ( name === \"button\" ) {\n\t\t\t\t\t\t\torig.call( $( this ), options );\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t$( this ).checkboxradio( $.extend( { icon: false }, options ) );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\treturn returnValue;\n\t\t};\n\t} )( $.fn.button );\n\n\t$.fn.buttonset = function() {\n\t\tif ( !$.ui.controlgroup ) {\n\t\t\t$.error( \"Controlgroup widget missing\" );\n\t\t}\n\t\tif ( arguments[ 0 ] === \"option\" && arguments[ 1 ] === \"items\" && arguments[ 2 ] ) {\n\t\t\treturn this.controlgroup.apply( this,\n\t\t\t\t[ arguments[ 0 ], \"items.button\", arguments[ 2 ] ] );\n\t\t}\n\t\tif ( arguments[ 0 ] === \"option\" && arguments[ 1 ] === \"items\" ) {\n\t\t\treturn this.controlgroup.apply( this, [ arguments[ 0 ], \"items.button\" ] );\n\t\t}\n\t\tif ( typeof arguments[ 0 ] === \"object\" && arguments[ 0 ].items ) {\n\t\t\targuments[ 0 ].items = {\n\t\t\t\tbutton: arguments[ 0 ].items\n\t\t\t};\n\t\t}\n\t\treturn this.controlgroup.apply( this, arguments );\n\t};\n}\n\nreturn $.ui.button;\n\n} );\n","jquery/ui-modules/widgets/resizable.js":"/*!\n * jQuery UI Resizable 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Resizable\n//>>group: Interactions\n//>>description: Enables resize functionality for any element.\n//>>docs: http://api.jqueryui.com/resizable/\n//>>demos: http://jqueryui.com/resizable/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/resizable.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./mouse\",\n\t\t\t\"../disable-selection\",\n\t\t\t\"../plugin\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.resizable\", $.ui.mouse, {\n\tversion: \"1.13.1\",\n\twidgetEventPrefix: \"resize\",\n\toptions: {\n\t\talsoResize: false,\n\t\tanimate: false,\n\t\tanimateDuration: \"slow\",\n\t\tanimateEasing: \"swing\",\n\t\taspectRatio: false,\n\t\tautoHide: false,\n\t\tclasses: {\n\t\t\t\"ui-resizable-se\": \"ui-icon ui-icon-gripsmall-diagonal-se\"\n\t\t},\n\t\tcontainment: false,\n\t\tghost: false,\n\t\tgrid: false,\n\t\thandles: \"e,s,se\",\n\t\thelper: false,\n\t\tmaxHeight: null,\n\t\tmaxWidth: null,\n\t\tminHeight: 10,\n\t\tminWidth: 10,\n\n\t\t// See #7960\n\t\tzIndex: 90,\n\n\t\t// Callbacks\n\t\tresize: null,\n\t\tstart: null,\n\t\tstop: null\n\t},\n\n\t_num: function( value ) {\n\t\treturn parseFloat( value ) || 0;\n\t},\n\n\t_isNumber: function( value ) {\n\t\treturn !isNaN( parseFloat( value ) );\n\t},\n\n\t_hasScroll: function( el, a ) {\n\n\t\tif ( $( el ).css( \"overflow\" ) === \"hidden\" ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tvar scroll = ( a && a === \"left\" ) ? \"scrollLeft\" : \"scrollTop\",\n\t\t\thas = false;\n\n\t\tif ( el[ scroll ] > 0 ) {\n\t\t\treturn true;\n\t\t}\n\n\t\t// TODO: determine which cases actually cause this to happen\n\t\t// if the element doesn't have the scroll set, see if it's possible to\n\t\t// set the scroll\n\t\ttry {\n\t\t\tel[ scroll ] = 1;\n\t\t\thas = ( el[ scroll ] > 0 );\n\t\t\tel[ scroll ] = 0;\n\t\t} catch ( e ) {\n\n\t\t\t// `el` might be a string, then setting `scroll` will throw\n\t\t\t// an error in strict mode; ignore it.\n\t\t}\n\t\treturn has;\n\t},\n\n\t_create: function() {\n\n\t\tvar margins,\n\t\t\to = this.options,\n\t\t\tthat = this;\n\t\tthis._addClass( \"ui-resizable\" );\n\n\t\t$.extend( this, {\n\t\t\t_aspectRatio: !!( o.aspectRatio ),\n\t\t\taspectRatio: o.aspectRatio,\n\t\t\toriginalElement: this.element,\n\t\t\t_proportionallyResizeElements: [],\n\t\t\t_helper: o.helper || o.ghost || o.animate ? o.helper || \"ui-resizable-helper\" : null\n\t\t} );\n\n\t\t// Wrap the element if it cannot hold child nodes\n\t\tif ( this.element[ 0 ].nodeName.match( /^(canvas|textarea|input|select|button|img)$/i ) ) {\n\n\t\t\tthis.element.wrap(\n\t\t\t\t$( \"<div class='ui-wrapper'></div>\" ).css( {\n\t\t\t\t\toverflow: \"hidden\",\n\t\t\t\t\tposition: this.element.css( \"position\" ),\n\t\t\t\t\twidth: this.element.outerWidth(),\n\t\t\t\t\theight: this.element.outerHeight(),\n\t\t\t\t\ttop: this.element.css( \"top\" ),\n\t\t\t\t\tleft: this.element.css( \"left\" )\n\t\t\t\t} )\n\t\t\t);\n\n\t\t\tthis.element = this.element.parent().data(\n\t\t\t\t\"ui-resizable\", this.element.resizable( \"instance\" )\n\t\t\t);\n\n\t\t\tthis.elementIsWrapper = true;\n\n\t\t\tmargins = {\n\t\t\t\tmarginTop: this.originalElement.css( \"marginTop\" ),\n\t\t\t\tmarginRight: this.originalElement.css( \"marginRight\" ),\n\t\t\t\tmarginBottom: this.originalElement.css( \"marginBottom\" ),\n\t\t\t\tmarginLeft: this.originalElement.css( \"marginLeft\" )\n\t\t\t};\n\n\t\t\tthis.element.css( margins );\n\t\t\tthis.originalElement.css( \"margin\", 0 );\n\n\t\t\t// support: Safari\n\t\t\t// Prevent Safari textarea resize\n\t\t\tthis.originalResizeStyle = this.originalElement.css( \"resize\" );\n\t\t\tthis.originalElement.css( \"resize\", \"none\" );\n\n\t\t\tthis._proportionallyResizeElements.push( this.originalElement.css( {\n\t\t\t\tposition: \"static\",\n\t\t\t\tzoom: 1,\n\t\t\t\tdisplay: \"block\"\n\t\t\t} ) );\n\n\t\t\t// Support: IE9\n\t\t\t// avoid IE jump (hard set the margin)\n\t\t\tthis.originalElement.css( margins );\n\n\t\t\tthis._proportionallyResize();\n\t\t}\n\n\t\tthis._setupHandles();\n\n\t\tif ( o.autoHide ) {\n\t\t\t$( this.element )\n\t\t\t\t.on( \"mouseenter\", function() {\n\t\t\t\t\tif ( o.disabled ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tthat._removeClass( \"ui-resizable-autohide\" );\n\t\t\t\t\tthat._handles.show();\n\t\t\t\t} )\n\t\t\t\t.on( \"mouseleave\", function() {\n\t\t\t\t\tif ( o.disabled ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tif ( !that.resizing ) {\n\t\t\t\t\t\tthat._addClass( \"ui-resizable-autohide\" );\n\t\t\t\t\t\tthat._handles.hide();\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t}\n\n\t\tthis._mouseInit();\n\t},\n\n\t_destroy: function() {\n\n\t\tthis._mouseDestroy();\n\t\tthis._addedHandles.remove();\n\n\t\tvar wrapper,\n\t\t\t_destroy = function( exp ) {\n\t\t\t\t$( exp )\n\t\t\t\t\t.removeData( \"resizable\" )\n\t\t\t\t\t.removeData( \"ui-resizable\" )\n\t\t\t\t\t.off( \".resizable\" );\n\t\t\t};\n\n\t\t// TODO: Unwrap at same DOM position\n\t\tif ( this.elementIsWrapper ) {\n\t\t\t_destroy( this.element );\n\t\t\twrapper = this.element;\n\t\t\tthis.originalElement.css( {\n\t\t\t\tposition: wrapper.css( \"position\" ),\n\t\t\t\twidth: wrapper.outerWidth(),\n\t\t\t\theight: wrapper.outerHeight(),\n\t\t\t\ttop: wrapper.css( \"top\" ),\n\t\t\t\tleft: wrapper.css( \"left\" )\n\t\t\t} ).insertAfter( wrapper );\n\t\t\twrapper.remove();\n\t\t}\n\n\t\tthis.originalElement.css( \"resize\", this.originalResizeStyle );\n\t\t_destroy( this.originalElement );\n\n\t\treturn this;\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tthis._super( key, value );\n\n\t\tswitch ( key ) {\n\t\tcase \"handles\":\n\t\t\tthis._removeHandles();\n\t\t\tthis._setupHandles();\n\t\t\tbreak;\n\t\tcase \"aspectRatio\":\n\t\t\tthis._aspectRatio = !!value;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t},\n\n\t_setupHandles: function() {\n\t\tvar o = this.options, handle, i, n, hname, axis, that = this;\n\t\tthis.handles = o.handles ||\n\t\t\t( !$( \".ui-resizable-handle\", this.element ).length ?\n\t\t\t\t\"e,s,se\" : {\n\t\t\t\t\tn: \".ui-resizable-n\",\n\t\t\t\t\te: \".ui-resizable-e\",\n\t\t\t\t\ts: \".ui-resizable-s\",\n\t\t\t\t\tw: \".ui-resizable-w\",\n\t\t\t\t\tse: \".ui-resizable-se\",\n\t\t\t\t\tsw: \".ui-resizable-sw\",\n\t\t\t\t\tne: \".ui-resizable-ne\",\n\t\t\t\t\tnw: \".ui-resizable-nw\"\n\t\t\t\t} );\n\n\t\tthis._handles = $();\n\t\tthis._addedHandles = $();\n\t\tif ( this.handles.constructor === String ) {\n\n\t\t\tif ( this.handles === \"all\" ) {\n\t\t\t\tthis.handles = \"n,e,s,w,se,sw,ne,nw\";\n\t\t\t}\n\n\t\t\tn = this.handles.split( \",\" );\n\t\t\tthis.handles = {};\n\n\t\t\tfor ( i = 0; i < n.length; i++ ) {\n\n\t\t\t\thandle = String.prototype.trim.call( n[ i ] );\n\t\t\t\thname = \"ui-resizable-\" + handle;\n\t\t\t\taxis = $( \"<div>\" );\n\t\t\t\tthis._addClass( axis, \"ui-resizable-handle \" + hname );\n\n\t\t\t\taxis.css( { zIndex: o.zIndex } );\n\n\t\t\t\tthis.handles[ handle ] = \".ui-resizable-\" + handle;\n\t\t\t\tif ( !this.element.children( this.handles[ handle ] ).length ) {\n\t\t\t\t\tthis.element.append( axis );\n\t\t\t\t\tthis._addedHandles = this._addedHandles.add( axis );\n\t\t\t\t}\n\t\t\t}\n\n\t\t}\n\n\t\tthis._renderAxis = function( target ) {\n\n\t\t\tvar i, axis, padPos, padWrapper;\n\n\t\t\ttarget = target || this.element;\n\n\t\t\tfor ( i in this.handles ) {\n\n\t\t\t\tif ( this.handles[ i ].constructor === String ) {\n\t\t\t\t\tthis.handles[ i ] = this.element.children( this.handles[ i ] ).first().show();\n\t\t\t\t} else if ( this.handles[ i ].jquery || this.handles[ i ].nodeType ) {\n\t\t\t\t\tthis.handles[ i ] = $( this.handles[ i ] );\n\t\t\t\t\tthis._on( this.handles[ i ], { \"mousedown\": that._mouseDown } );\n\t\t\t\t}\n\n\t\t\t\tif ( this.elementIsWrapper &&\n\t\t\t\t\t\tthis.originalElement[ 0 ]\n\t\t\t\t\t\t\t.nodeName\n\t\t\t\t\t\t\t.match( /^(textarea|input|select|button)$/i ) ) {\n\t\t\t\t\taxis = $( this.handles[ i ], this.element );\n\n\t\t\t\t\tpadWrapper = /sw|ne|nw|se|n|s/.test( i ) ?\n\t\t\t\t\t\taxis.outerHeight() :\n\t\t\t\t\t\taxis.outerWidth();\n\n\t\t\t\t\tpadPos = [ \"padding\",\n\t\t\t\t\t\t/ne|nw|n/.test( i ) ? \"Top\" :\n\t\t\t\t\t\t/se|sw|s/.test( i ) ? \"Bottom\" :\n\t\t\t\t\t\t/^e$/.test( i ) ? \"Right\" : \"Left\" ].join( \"\" );\n\n\t\t\t\t\ttarget.css( padPos, padWrapper );\n\n\t\t\t\t\tthis._proportionallyResize();\n\t\t\t\t}\n\n\t\t\t\tthis._handles = this._handles.add( this.handles[ i ] );\n\t\t\t}\n\t\t};\n\n\t\t// TODO: make renderAxis a prototype function\n\t\tthis._renderAxis( this.element );\n\n\t\tthis._handles = this._handles.add( this.element.find( \".ui-resizable-handle\" ) );\n\t\tthis._handles.disableSelection();\n\n\t\tthis._handles.on( \"mouseover\", function() {\n\t\t\tif ( !that.resizing ) {\n\t\t\t\tif ( this.className ) {\n\t\t\t\t\taxis = this.className.match( /ui-resizable-(se|sw|ne|nw|n|e|s|w)/i );\n\t\t\t\t}\n\t\t\t\tthat.axis = axis && axis[ 1 ] ? axis[ 1 ] : \"se\";\n\t\t\t}\n\t\t} );\n\n\t\tif ( o.autoHide ) {\n\t\t\tthis._handles.hide();\n\t\t\tthis._addClass( \"ui-resizable-autohide\" );\n\t\t}\n\t},\n\n\t_removeHandles: function() {\n\t\tthis._addedHandles.remove();\n\t},\n\n\t_mouseCapture: function( event ) {\n\t\tvar i, handle,\n\t\t\tcapture = false;\n\n\t\tfor ( i in this.handles ) {\n\t\t\thandle = $( this.handles[ i ] )[ 0 ];\n\t\t\tif ( handle === event.target || $.contains( handle, event.target ) ) {\n\t\t\t\tcapture = true;\n\t\t\t}\n\t\t}\n\n\t\treturn !this.options.disabled && capture;\n\t},\n\n\t_mouseStart: function( event ) {\n\n\t\tvar curleft, curtop, cursor,\n\t\t\to = this.options,\n\t\t\tel = this.element;\n\n\t\tthis.resizing = true;\n\n\t\tthis._renderProxy();\n\n\t\tcurleft = this._num( this.helper.css( \"left\" ) );\n\t\tcurtop = this._num( this.helper.css( \"top\" ) );\n\n\t\tif ( o.containment ) {\n\t\t\tcurleft += $( o.containment ).scrollLeft() || 0;\n\t\t\tcurtop += $( o.containment ).scrollTop() || 0;\n\t\t}\n\n\t\tthis.offset = this.helper.offset();\n\t\tthis.position = { left: curleft, top: curtop };\n\n\t\tthis.size = this._helper ? {\n\t\t\t\twidth: this.helper.width(),\n\t\t\t\theight: this.helper.height()\n\t\t\t} : {\n\t\t\t\twidth: el.width(),\n\t\t\t\theight: el.height()\n\t\t\t};\n\n\t\tthis.originalSize = this._helper ? {\n\t\t\t\twidth: el.outerWidth(),\n\t\t\t\theight: el.outerHeight()\n\t\t\t} : {\n\t\t\t\twidth: el.width(),\n\t\t\t\theight: el.height()\n\t\t\t};\n\n\t\tthis.sizeDiff = {\n\t\t\twidth: el.outerWidth() - el.width(),\n\t\t\theight: el.outerHeight() - el.height()\n\t\t};\n\n\t\tthis.originalPosition = { left: curleft, top: curtop };\n\t\tthis.originalMousePosition = { left: event.pageX, top: event.pageY };\n\n\t\tthis.aspectRatio = ( typeof o.aspectRatio === \"number\" ) ?\n\t\t\to.aspectRatio :\n\t\t\t( ( this.originalSize.width / this.originalSize.height ) || 1 );\n\n\t\tcursor = $( \".ui-resizable-\" + this.axis ).css( \"cursor\" );\n\t\t$( \"body\" ).css( \"cursor\", cursor === \"auto\" ? this.axis + \"-resize\" : cursor );\n\n\t\tthis._addClass( \"ui-resizable-resizing\" );\n\t\tthis._propagate( \"start\", event );\n\t\treturn true;\n\t},\n\n\t_mouseDrag: function( event ) {\n\n\t\tvar data, props,\n\t\t\tsmp = this.originalMousePosition,\n\t\t\ta = this.axis,\n\t\t\tdx = ( event.pageX - smp.left ) || 0,\n\t\t\tdy = ( event.pageY - smp.top ) || 0,\n\t\t\ttrigger = this._change[ a ];\n\n\t\tthis._updatePrevProperties();\n\n\t\tif ( !trigger ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tdata = trigger.apply( this, [ event, dx, dy ] );\n\n\t\tthis._updateVirtualBoundaries( event.shiftKey );\n\t\tif ( this._aspectRatio || event.shiftKey ) {\n\t\t\tdata = this._updateRatio( data, event );\n\t\t}\n\n\t\tdata = this._respectSize( data, event );\n\n\t\tthis._updateCache( data );\n\n\t\tthis._propagate( \"resize\", event );\n\n\t\tprops = this._applyChanges();\n\n\t\tif ( !this._helper && this._proportionallyResizeElements.length ) {\n\t\t\tthis._proportionallyResize();\n\t\t}\n\n\t\tif ( !$.isEmptyObject( props ) ) {\n\t\t\tthis._updatePrevProperties();\n\t\t\tthis._trigger( \"resize\", event, this.ui() );\n\t\t\tthis._applyChanges();\n\t\t}\n\n\t\treturn false;\n\t},\n\n\t_mouseStop: function( event ) {\n\n\t\tthis.resizing = false;\n\t\tvar pr, ista, soffseth, soffsetw, s, left, top,\n\t\t\to = this.options, that = this;\n\n\t\tif ( this._helper ) {\n\n\t\t\tpr = this._proportionallyResizeElements;\n\t\t\tista = pr.length && ( /textarea/i ).test( pr[ 0 ].nodeName );\n\t\t\tsoffseth = ista && this._hasScroll( pr[ 0 ], \"left\" ) ? 0 : that.sizeDiff.height;\n\t\t\tsoffsetw = ista ? 0 : that.sizeDiff.width;\n\n\t\t\ts = {\n\t\t\t\twidth: ( that.helper.width()  - soffsetw ),\n\t\t\t\theight: ( that.helper.height() - soffseth )\n\t\t\t};\n\t\t\tleft = ( parseFloat( that.element.css( \"left\" ) ) +\n\t\t\t\t( that.position.left - that.originalPosition.left ) ) || null;\n\t\t\ttop = ( parseFloat( that.element.css( \"top\" ) ) +\n\t\t\t\t( that.position.top - that.originalPosition.top ) ) || null;\n\n\t\t\tif ( !o.animate ) {\n\t\t\t\tthis.element.css( $.extend( s, { top: top, left: left } ) );\n\t\t\t}\n\n\t\t\tthat.helper.height( that.size.height );\n\t\t\tthat.helper.width( that.size.width );\n\n\t\t\tif ( this._helper && !o.animate ) {\n\t\t\t\tthis._proportionallyResize();\n\t\t\t}\n\t\t}\n\n\t\t$( \"body\" ).css( \"cursor\", \"auto\" );\n\n\t\tthis._removeClass( \"ui-resizable-resizing\" );\n\n\t\tthis._propagate( \"stop\", event );\n\n\t\tif ( this._helper ) {\n\t\t\tthis.helper.remove();\n\t\t}\n\n\t\treturn false;\n\n\t},\n\n\t_updatePrevProperties: function() {\n\t\tthis.prevPosition = {\n\t\t\ttop: this.position.top,\n\t\t\tleft: this.position.left\n\t\t};\n\t\tthis.prevSize = {\n\t\t\twidth: this.size.width,\n\t\t\theight: this.size.height\n\t\t};\n\t},\n\n\t_applyChanges: function() {\n\t\tvar props = {};\n\n\t\tif ( this.position.top !== this.prevPosition.top ) {\n\t\t\tprops.top = this.position.top + \"px\";\n\t\t}\n\t\tif ( this.position.left !== this.prevPosition.left ) {\n\t\t\tprops.left = this.position.left + \"px\";\n\t\t}\n\t\tif ( this.size.width !== this.prevSize.width ) {\n\t\t\tprops.width = this.size.width + \"px\";\n\t\t}\n\t\tif ( this.size.height !== this.prevSize.height ) {\n\t\t\tprops.height = this.size.height + \"px\";\n\t\t}\n\n\t\tthis.helper.css( props );\n\n\t\treturn props;\n\t},\n\n\t_updateVirtualBoundaries: function( forceAspectRatio ) {\n\t\tvar pMinWidth, pMaxWidth, pMinHeight, pMaxHeight, b,\n\t\t\to = this.options;\n\n\t\tb = {\n\t\t\tminWidth: this._isNumber( o.minWidth ) ? o.minWidth : 0,\n\t\t\tmaxWidth: this._isNumber( o.maxWidth ) ? o.maxWidth : Infinity,\n\t\t\tminHeight: this._isNumber( o.minHeight ) ? o.minHeight : 0,\n\t\t\tmaxHeight: this._isNumber( o.maxHeight ) ? o.maxHeight : Infinity\n\t\t};\n\n\t\tif ( this._aspectRatio || forceAspectRatio ) {\n\t\t\tpMinWidth = b.minHeight * this.aspectRatio;\n\t\t\tpMinHeight = b.minWidth / this.aspectRatio;\n\t\t\tpMaxWidth = b.maxHeight * this.aspectRatio;\n\t\t\tpMaxHeight = b.maxWidth / this.aspectRatio;\n\n\t\t\tif ( pMinWidth > b.minWidth ) {\n\t\t\t\tb.minWidth = pMinWidth;\n\t\t\t}\n\t\t\tif ( pMinHeight > b.minHeight ) {\n\t\t\t\tb.minHeight = pMinHeight;\n\t\t\t}\n\t\t\tif ( pMaxWidth < b.maxWidth ) {\n\t\t\t\tb.maxWidth = pMaxWidth;\n\t\t\t}\n\t\t\tif ( pMaxHeight < b.maxHeight ) {\n\t\t\t\tb.maxHeight = pMaxHeight;\n\t\t\t}\n\t\t}\n\t\tthis._vBoundaries = b;\n\t},\n\n\t_updateCache: function( data ) {\n\t\tthis.offset = this.helper.offset();\n\t\tif ( this._isNumber( data.left ) ) {\n\t\t\tthis.position.left = data.left;\n\t\t}\n\t\tif ( this._isNumber( data.top ) ) {\n\t\t\tthis.position.top = data.top;\n\t\t}\n\t\tif ( this._isNumber( data.height ) ) {\n\t\t\tthis.size.height = data.height;\n\t\t}\n\t\tif ( this._isNumber( data.width ) ) {\n\t\t\tthis.size.width = data.width;\n\t\t}\n\t},\n\n\t_updateRatio: function( data ) {\n\n\t\tvar cpos = this.position,\n\t\t\tcsize = this.size,\n\t\t\ta = this.axis;\n\n\t\tif ( this._isNumber( data.height ) ) {\n\t\t\tdata.width = ( data.height * this.aspectRatio );\n\t\t} else if ( this._isNumber( data.width ) ) {\n\t\t\tdata.height = ( data.width / this.aspectRatio );\n\t\t}\n\n\t\tif ( a === \"sw\" ) {\n\t\t\tdata.left = cpos.left + ( csize.width - data.width );\n\t\t\tdata.top = null;\n\t\t}\n\t\tif ( a === \"nw\" ) {\n\t\t\tdata.top = cpos.top + ( csize.height - data.height );\n\t\t\tdata.left = cpos.left + ( csize.width - data.width );\n\t\t}\n\n\t\treturn data;\n\t},\n\n\t_respectSize: function( data ) {\n\n\t\tvar o = this._vBoundaries,\n\t\t\ta = this.axis,\n\t\t\tismaxw = this._isNumber( data.width ) && o.maxWidth && ( o.maxWidth < data.width ),\n\t\t\tismaxh = this._isNumber( data.height ) && o.maxHeight && ( o.maxHeight < data.height ),\n\t\t\tisminw = this._isNumber( data.width ) && o.minWidth && ( o.minWidth > data.width ),\n\t\t\tisminh = this._isNumber( data.height ) && o.minHeight && ( o.minHeight > data.height ),\n\t\t\tdw = this.originalPosition.left + this.originalSize.width,\n\t\t\tdh = this.originalPosition.top + this.originalSize.height,\n\t\t\tcw = /sw|nw|w/.test( a ), ch = /nw|ne|n/.test( a );\n\t\tif ( isminw ) {\n\t\t\tdata.width = o.minWidth;\n\t\t}\n\t\tif ( isminh ) {\n\t\t\tdata.height = o.minHeight;\n\t\t}\n\t\tif ( ismaxw ) {\n\t\t\tdata.width = o.maxWidth;\n\t\t}\n\t\tif ( ismaxh ) {\n\t\t\tdata.height = o.maxHeight;\n\t\t}\n\n\t\tif ( isminw && cw ) {\n\t\t\tdata.left = dw - o.minWidth;\n\t\t}\n\t\tif ( ismaxw && cw ) {\n\t\t\tdata.left = dw - o.maxWidth;\n\t\t}\n\t\tif ( isminh && ch ) {\n\t\t\tdata.top = dh - o.minHeight;\n\t\t}\n\t\tif ( ismaxh && ch ) {\n\t\t\tdata.top = dh - o.maxHeight;\n\t\t}\n\n\t\t// Fixing jump error on top/left - bug #2330\n\t\tif ( !data.width && !data.height && !data.left && data.top ) {\n\t\t\tdata.top = null;\n\t\t} else if ( !data.width && !data.height && !data.top && data.left ) {\n\t\t\tdata.left = null;\n\t\t}\n\n\t\treturn data;\n\t},\n\n\t_getPaddingPlusBorderDimensions: function( element ) {\n\t\tvar i = 0,\n\t\t\twidths = [],\n\t\t\tborders = [\n\t\t\t\telement.css( \"borderTopWidth\" ),\n\t\t\t\telement.css( \"borderRightWidth\" ),\n\t\t\t\telement.css( \"borderBottomWidth\" ),\n\t\t\t\telement.css( \"borderLeftWidth\" )\n\t\t\t],\n\t\t\tpaddings = [\n\t\t\t\telement.css( \"paddingTop\" ),\n\t\t\t\telement.css( \"paddingRight\" ),\n\t\t\t\telement.css( \"paddingBottom\" ),\n\t\t\t\telement.css( \"paddingLeft\" )\n\t\t\t];\n\n\t\tfor ( ; i < 4; i++ ) {\n\t\t\twidths[ i ] = ( parseFloat( borders[ i ] ) || 0 );\n\t\t\twidths[ i ] += ( parseFloat( paddings[ i ] ) || 0 );\n\t\t}\n\n\t\treturn {\n\t\t\theight: widths[ 0 ] + widths[ 2 ],\n\t\t\twidth: widths[ 1 ] + widths[ 3 ]\n\t\t};\n\t},\n\n\t_proportionallyResize: function() {\n\n\t\tif ( !this._proportionallyResizeElements.length ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar prel,\n\t\t\ti = 0,\n\t\t\telement = this.helper || this.element;\n\n\t\tfor ( ; i < this._proportionallyResizeElements.length; i++ ) {\n\n\t\t\tprel = this._proportionallyResizeElements[ i ];\n\n\t\t\t// TODO: Seems like a bug to cache this.outerDimensions\n\t\t\t// considering that we are in a loop.\n\t\t\tif ( !this.outerDimensions ) {\n\t\t\t\tthis.outerDimensions = this._getPaddingPlusBorderDimensions( prel );\n\t\t\t}\n\n\t\t\tprel.css( {\n\t\t\t\theight: ( element.height() - this.outerDimensions.height ) || 0,\n\t\t\t\twidth: ( element.width() - this.outerDimensions.width ) || 0\n\t\t\t} );\n\n\t\t}\n\n\t},\n\n\t_renderProxy: function() {\n\n\t\tvar el = this.element, o = this.options;\n\t\tthis.elementOffset = el.offset();\n\n\t\tif ( this._helper ) {\n\n\t\t\tthis.helper = this.helper || $( \"<div></div>\" ).css( { overflow: \"hidden\" } );\n\n\t\t\tthis._addClass( this.helper, this._helper );\n\t\t\tthis.helper.css( {\n\t\t\t\twidth: this.element.outerWidth(),\n\t\t\t\theight: this.element.outerHeight(),\n\t\t\t\tposition: \"absolute\",\n\t\t\t\tleft: this.elementOffset.left + \"px\",\n\t\t\t\ttop: this.elementOffset.top + \"px\",\n\t\t\t\tzIndex: ++o.zIndex //TODO: Don't modify option\n\t\t\t} );\n\n\t\t\tthis.helper\n\t\t\t\t.appendTo( \"body\" )\n\t\t\t\t.disableSelection();\n\n\t\t} else {\n\t\t\tthis.helper = this.element;\n\t\t}\n\n\t},\n\n\t_change: {\n\t\te: function( event, dx ) {\n\t\t\treturn { width: this.originalSize.width + dx };\n\t\t},\n\t\tw: function( event, dx ) {\n\t\t\tvar cs = this.originalSize, sp = this.originalPosition;\n\t\t\treturn { left: sp.left + dx, width: cs.width - dx };\n\t\t},\n\t\tn: function( event, dx, dy ) {\n\t\t\tvar cs = this.originalSize, sp = this.originalPosition;\n\t\t\treturn { top: sp.top + dy, height: cs.height - dy };\n\t\t},\n\t\ts: function( event, dx, dy ) {\n\t\t\treturn { height: this.originalSize.height + dy };\n\t\t},\n\t\tse: function( event, dx, dy ) {\n\t\t\treturn $.extend( this._change.s.apply( this, arguments ),\n\t\t\t\tthis._change.e.apply( this, [ event, dx, dy ] ) );\n\t\t},\n\t\tsw: function( event, dx, dy ) {\n\t\t\treturn $.extend( this._change.s.apply( this, arguments ),\n\t\t\t\tthis._change.w.apply( this, [ event, dx, dy ] ) );\n\t\t},\n\t\tne: function( event, dx, dy ) {\n\t\t\treturn $.extend( this._change.n.apply( this, arguments ),\n\t\t\t\tthis._change.e.apply( this, [ event, dx, dy ] ) );\n\t\t},\n\t\tnw: function( event, dx, dy ) {\n\t\t\treturn $.extend( this._change.n.apply( this, arguments ),\n\t\t\t\tthis._change.w.apply( this, [ event, dx, dy ] ) );\n\t\t}\n\t},\n\n\t_propagate: function( n, event ) {\n\t\t$.ui.plugin.call( this, n, [ event, this.ui() ] );\n\t\tif ( n !== \"resize\" ) {\n\t\t\tthis._trigger( n, event, this.ui() );\n\t\t}\n\t},\n\n\tplugins: {},\n\n\tui: function() {\n\t\treturn {\n\t\t\toriginalElement: this.originalElement,\n\t\t\telement: this.element,\n\t\t\thelper: this.helper,\n\t\t\tposition: this.position,\n\t\t\tsize: this.size,\n\t\t\toriginalSize: this.originalSize,\n\t\t\toriginalPosition: this.originalPosition\n\t\t};\n\t}\n\n} );\n\n/*\n * Resizable Extensions\n */\n\n$.ui.plugin.add( \"resizable\", \"animate\", {\n\n\tstop: function( event ) {\n\t\tvar that = $( this ).resizable( \"instance\" ),\n\t\t\to = that.options,\n\t\t\tpr = that._proportionallyResizeElements,\n\t\t\tista = pr.length && ( /textarea/i ).test( pr[ 0 ].nodeName ),\n\t\t\tsoffseth = ista && that._hasScroll( pr[ 0 ], \"left\" ) ? 0 : that.sizeDiff.height,\n\t\t\tsoffsetw = ista ? 0 : that.sizeDiff.width,\n\t\t\tstyle = {\n\t\t\t\twidth: ( that.size.width - soffsetw ),\n\t\t\t\theight: ( that.size.height - soffseth )\n\t\t\t},\n\t\t\tleft = ( parseFloat( that.element.css( \"left\" ) ) +\n\t\t\t\t( that.position.left - that.originalPosition.left ) ) || null,\n\t\t\ttop = ( parseFloat( that.element.css( \"top\" ) ) +\n\t\t\t\t( that.position.top - that.originalPosition.top ) ) || null;\n\n\t\tthat.element.animate(\n\t\t\t$.extend( style, top && left ? { top: top, left: left } : {} ), {\n\t\t\t\tduration: o.animateDuration,\n\t\t\t\teasing: o.animateEasing,\n\t\t\t\tstep: function() {\n\n\t\t\t\t\tvar data = {\n\t\t\t\t\t\twidth: parseFloat( that.element.css( \"width\" ) ),\n\t\t\t\t\t\theight: parseFloat( that.element.css( \"height\" ) ),\n\t\t\t\t\t\ttop: parseFloat( that.element.css( \"top\" ) ),\n\t\t\t\t\t\tleft: parseFloat( that.element.css( \"left\" ) )\n\t\t\t\t\t};\n\n\t\t\t\t\tif ( pr && pr.length ) {\n\t\t\t\t\t\t$( pr[ 0 ] ).css( { width: data.width, height: data.height } );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Propagating resize, and updating values for each animation step\n\t\t\t\t\tthat._updateCache( data );\n\t\t\t\t\tthat._propagate( \"resize\", event );\n\n\t\t\t\t}\n\t\t\t}\n\t\t);\n\t}\n\n} );\n\n$.ui.plugin.add( \"resizable\", \"containment\", {\n\n\tstart: function() {\n\t\tvar element, p, co, ch, cw, width, height,\n\t\t\tthat = $( this ).resizable( \"instance\" ),\n\t\t\to = that.options,\n\t\t\tel = that.element,\n\t\t\toc = o.containment,\n\t\t\tce = ( oc instanceof $ ) ?\n\t\t\t\toc.get( 0 ) :\n\t\t\t\t( /parent/.test( oc ) ) ? el.parent().get( 0 ) : oc;\n\n\t\tif ( !ce ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthat.containerElement = $( ce );\n\n\t\tif ( /document/.test( oc ) || oc === document ) {\n\t\t\tthat.containerOffset = {\n\t\t\t\tleft: 0,\n\t\t\t\ttop: 0\n\t\t\t};\n\t\t\tthat.containerPosition = {\n\t\t\t\tleft: 0,\n\t\t\t\ttop: 0\n\t\t\t};\n\n\t\t\tthat.parentData = {\n\t\t\t\telement: $( document ),\n\t\t\t\tleft: 0,\n\t\t\t\ttop: 0,\n\t\t\t\twidth: $( document ).width(),\n\t\t\t\theight: $( document ).height() || document.body.parentNode.scrollHeight\n\t\t\t};\n\t\t} else {\n\t\t\telement = $( ce );\n\t\t\tp = [];\n\t\t\t$( [ \"Top\", \"Right\", \"Left\", \"Bottom\" ] ).each( function( i, name ) {\n\t\t\t\tp[ i ] = that._num( element.css( \"padding\" + name ) );\n\t\t\t} );\n\n\t\t\tthat.containerOffset = element.offset();\n\t\t\tthat.containerPosition = element.position();\n\t\t\tthat.containerSize = {\n\t\t\t\theight: ( element.innerHeight() - p[ 3 ] ),\n\t\t\t\twidth: ( element.innerWidth() - p[ 1 ] )\n\t\t\t};\n\n\t\t\tco = that.containerOffset;\n\t\t\tch = that.containerSize.height;\n\t\t\tcw = that.containerSize.width;\n\t\t\twidth = ( that._hasScroll( ce, \"left\" ) ? ce.scrollWidth : cw );\n\t\t\theight = ( that._hasScroll( ce ) ? ce.scrollHeight : ch );\n\n\t\t\tthat.parentData = {\n\t\t\t\telement: ce,\n\t\t\t\tleft: co.left,\n\t\t\t\ttop: co.top,\n\t\t\t\twidth: width,\n\t\t\t\theight: height\n\t\t\t};\n\t\t}\n\t},\n\n\tresize: function( event ) {\n\t\tvar woset, hoset, isParent, isOffsetRelative,\n\t\t\tthat = $( this ).resizable( \"instance\" ),\n\t\t\to = that.options,\n\t\t\tco = that.containerOffset,\n\t\t\tcp = that.position,\n\t\t\tpRatio = that._aspectRatio || event.shiftKey,\n\t\t\tcop = {\n\t\t\t\ttop: 0,\n\t\t\t\tleft: 0\n\t\t\t},\n\t\t\tce = that.containerElement,\n\t\t\tcontinueResize = true;\n\n\t\tif ( ce[ 0 ] !== document && ( /static/ ).test( ce.css( \"position\" ) ) ) {\n\t\t\tcop = co;\n\t\t}\n\n\t\tif ( cp.left < ( that._helper ? co.left : 0 ) ) {\n\t\t\tthat.size.width = that.size.width +\n\t\t\t\t( that._helper ?\n\t\t\t\t\t( that.position.left - co.left ) :\n\t\t\t\t\t( that.position.left - cop.left ) );\n\n\t\t\tif ( pRatio ) {\n\t\t\t\tthat.size.height = that.size.width / that.aspectRatio;\n\t\t\t\tcontinueResize = false;\n\t\t\t}\n\t\t\tthat.position.left = o.helper ? co.left : 0;\n\t\t}\n\n\t\tif ( cp.top < ( that._helper ? co.top : 0 ) ) {\n\t\t\tthat.size.height = that.size.height +\n\t\t\t\t( that._helper ?\n\t\t\t\t\t( that.position.top - co.top ) :\n\t\t\t\t\tthat.position.top );\n\n\t\t\tif ( pRatio ) {\n\t\t\t\tthat.size.width = that.size.height * that.aspectRatio;\n\t\t\t\tcontinueResize = false;\n\t\t\t}\n\t\t\tthat.position.top = that._helper ? co.top : 0;\n\t\t}\n\n\t\tisParent = that.containerElement.get( 0 ) === that.element.parent().get( 0 );\n\t\tisOffsetRelative = /relative|absolute/.test( that.containerElement.css( \"position\" ) );\n\n\t\tif ( isParent && isOffsetRelative ) {\n\t\t\tthat.offset.left = that.parentData.left + that.position.left;\n\t\t\tthat.offset.top = that.parentData.top + that.position.top;\n\t\t} else {\n\t\t\tthat.offset.left = that.element.offset().left;\n\t\t\tthat.offset.top = that.element.offset().top;\n\t\t}\n\n\t\twoset = Math.abs( that.sizeDiff.width +\n\t\t\t( that._helper ?\n\t\t\t\tthat.offset.left - cop.left :\n\t\t\t\t( that.offset.left - co.left ) ) );\n\n\t\thoset = Math.abs( that.sizeDiff.height +\n\t\t\t( that._helper ?\n\t\t\t\tthat.offset.top - cop.top :\n\t\t\t\t( that.offset.top - co.top ) ) );\n\n\t\tif ( woset + that.size.width >= that.parentData.width ) {\n\t\t\tthat.size.width = that.parentData.width - woset;\n\t\t\tif ( pRatio ) {\n\t\t\t\tthat.size.height = that.size.width / that.aspectRatio;\n\t\t\t\tcontinueResize = false;\n\t\t\t}\n\t\t}\n\n\t\tif ( hoset + that.size.height >= that.parentData.height ) {\n\t\t\tthat.size.height = that.parentData.height - hoset;\n\t\t\tif ( pRatio ) {\n\t\t\t\tthat.size.width = that.size.height * that.aspectRatio;\n\t\t\t\tcontinueResize = false;\n\t\t\t}\n\t\t}\n\n\t\tif ( !continueResize ) {\n\t\t\tthat.position.left = that.prevPosition.left;\n\t\t\tthat.position.top = that.prevPosition.top;\n\t\t\tthat.size.width = that.prevSize.width;\n\t\t\tthat.size.height = that.prevSize.height;\n\t\t}\n\t},\n\n\tstop: function() {\n\t\tvar that = $( this ).resizable( \"instance\" ),\n\t\t\to = that.options,\n\t\t\tco = that.containerOffset,\n\t\t\tcop = that.containerPosition,\n\t\t\tce = that.containerElement,\n\t\t\thelper = $( that.helper ),\n\t\t\tho = helper.offset(),\n\t\t\tw = helper.outerWidth() - that.sizeDiff.width,\n\t\t\th = helper.outerHeight() - that.sizeDiff.height;\n\n\t\tif ( that._helper && !o.animate && ( /relative/ ).test( ce.css( \"position\" ) ) ) {\n\t\t\t$( this ).css( {\n\t\t\t\tleft: ho.left - cop.left - co.left,\n\t\t\t\twidth: w,\n\t\t\t\theight: h\n\t\t\t} );\n\t\t}\n\n\t\tif ( that._helper && !o.animate && ( /static/ ).test( ce.css( \"position\" ) ) ) {\n\t\t\t$( this ).css( {\n\t\t\t\tleft: ho.left - cop.left - co.left,\n\t\t\t\twidth: w,\n\t\t\t\theight: h\n\t\t\t} );\n\t\t}\n\t}\n} );\n\n$.ui.plugin.add( \"resizable\", \"alsoResize\", {\n\n\tstart: function() {\n\t\tvar that = $( this ).resizable( \"instance\" ),\n\t\t\to = that.options;\n\n\t\t$( o.alsoResize ).each( function() {\n\t\t\tvar el = $( this );\n\t\t\tel.data( \"ui-resizable-alsoresize\", {\n\t\t\t\twidth: parseFloat( el.width() ), height: parseFloat( el.height() ),\n\t\t\t\tleft: parseFloat( el.css( \"left\" ) ), top: parseFloat( el.css( \"top\" ) )\n\t\t\t} );\n\t\t} );\n\t},\n\n\tresize: function( event, ui ) {\n\t\tvar that = $( this ).resizable( \"instance\" ),\n\t\t\to = that.options,\n\t\t\tos = that.originalSize,\n\t\t\top = that.originalPosition,\n\t\t\tdelta = {\n\t\t\t\theight: ( that.size.height - os.height ) || 0,\n\t\t\t\twidth: ( that.size.width - os.width ) || 0,\n\t\t\t\ttop: ( that.position.top - op.top ) || 0,\n\t\t\t\tleft: ( that.position.left - op.left ) || 0\n\t\t\t};\n\n\t\t\t$( o.alsoResize ).each( function() {\n\t\t\t\tvar el = $( this ), start = $( this ).data( \"ui-resizable-alsoresize\" ), style = {},\n\t\t\t\t\tcss = el.parents( ui.originalElement[ 0 ] ).length ?\n\t\t\t\t\t\t\t[ \"width\", \"height\" ] :\n\t\t\t\t\t\t\t[ \"width\", \"height\", \"top\", \"left\" ];\n\n\t\t\t\t$.each( css, function( i, prop ) {\n\t\t\t\t\tvar sum = ( start[ prop ] || 0 ) + ( delta[ prop ] || 0 );\n\t\t\t\t\tif ( sum && sum >= 0 ) {\n\t\t\t\t\t\tstyle[ prop ] = sum || null;\n\t\t\t\t\t}\n\t\t\t\t} );\n\n\t\t\t\tel.css( style );\n\t\t\t} );\n\t},\n\n\tstop: function() {\n\t\t$( this ).removeData( \"ui-resizable-alsoresize\" );\n\t}\n} );\n\n$.ui.plugin.add( \"resizable\", \"ghost\", {\n\n\tstart: function() {\n\n\t\tvar that = $( this ).resizable( \"instance\" ), cs = that.size;\n\n\t\tthat.ghost = that.originalElement.clone();\n\t\tthat.ghost.css( {\n\t\t\topacity: 0.25,\n\t\t\tdisplay: \"block\",\n\t\t\tposition: \"relative\",\n\t\t\theight: cs.height,\n\t\t\twidth: cs.width,\n\t\t\tmargin: 0,\n\t\t\tleft: 0,\n\t\t\ttop: 0\n\t\t} );\n\n\t\tthat._addClass( that.ghost, \"ui-resizable-ghost\" );\n\n\t\t// DEPRECATED\n\t\t// TODO: remove after 1.12\n\t\tif ( $.uiBackCompat !== false && typeof that.options.ghost === \"string\" ) {\n\n\t\t\t// Ghost option\n\t\t\tthat.ghost.addClass( this.options.ghost );\n\t\t}\n\n\t\tthat.ghost.appendTo( that.helper );\n\n\t},\n\n\tresize: function() {\n\t\tvar that = $( this ).resizable( \"instance\" );\n\t\tif ( that.ghost ) {\n\t\t\tthat.ghost.css( {\n\t\t\t\tposition: \"relative\",\n\t\t\t\theight: that.size.height,\n\t\t\t\twidth: that.size.width\n\t\t\t} );\n\t\t}\n\t},\n\n\tstop: function() {\n\t\tvar that = $( this ).resizable( \"instance\" );\n\t\tif ( that.ghost && that.helper ) {\n\t\t\tthat.helper.get( 0 ).removeChild( that.ghost.get( 0 ) );\n\t\t}\n\t}\n\n} );\n\n$.ui.plugin.add( \"resizable\", \"grid\", {\n\n\tresize: function() {\n\t\tvar outerDimensions,\n\t\t\tthat = $( this ).resizable( \"instance\" ),\n\t\t\to = that.options,\n\t\t\tcs = that.size,\n\t\t\tos = that.originalSize,\n\t\t\top = that.originalPosition,\n\t\t\ta = that.axis,\n\t\t\tgrid = typeof o.grid === \"number\" ? [ o.grid, o.grid ] : o.grid,\n\t\t\tgridX = ( grid[ 0 ] || 1 ),\n\t\t\tgridY = ( grid[ 1 ] || 1 ),\n\t\t\tox = Math.round( ( cs.width - os.width ) / gridX ) * gridX,\n\t\t\toy = Math.round( ( cs.height - os.height ) / gridY ) * gridY,\n\t\t\tnewWidth = os.width + ox,\n\t\t\tnewHeight = os.height + oy,\n\t\t\tisMaxWidth = o.maxWidth && ( o.maxWidth < newWidth ),\n\t\t\tisMaxHeight = o.maxHeight && ( o.maxHeight < newHeight ),\n\t\t\tisMinWidth = o.minWidth && ( o.minWidth > newWidth ),\n\t\t\tisMinHeight = o.minHeight && ( o.minHeight > newHeight );\n\n\t\to.grid = grid;\n\n\t\tif ( isMinWidth ) {\n\t\t\tnewWidth += gridX;\n\t\t}\n\t\tif ( isMinHeight ) {\n\t\t\tnewHeight += gridY;\n\t\t}\n\t\tif ( isMaxWidth ) {\n\t\t\tnewWidth -= gridX;\n\t\t}\n\t\tif ( isMaxHeight ) {\n\t\t\tnewHeight -= gridY;\n\t\t}\n\n\t\tif ( /^(se|s|e)$/.test( a ) ) {\n\t\t\tthat.size.width = newWidth;\n\t\t\tthat.size.height = newHeight;\n\t\t} else if ( /^(ne)$/.test( a ) ) {\n\t\t\tthat.size.width = newWidth;\n\t\t\tthat.size.height = newHeight;\n\t\t\tthat.position.top = op.top - oy;\n\t\t} else if ( /^(sw)$/.test( a ) ) {\n\t\t\tthat.size.width = newWidth;\n\t\t\tthat.size.height = newHeight;\n\t\t\tthat.position.left = op.left - ox;\n\t\t} else {\n\t\t\tif ( newHeight - gridY <= 0 || newWidth - gridX <= 0 ) {\n\t\t\t\touterDimensions = that._getPaddingPlusBorderDimensions( this );\n\t\t\t}\n\n\t\t\tif ( newHeight - gridY > 0 ) {\n\t\t\t\tthat.size.height = newHeight;\n\t\t\t\tthat.position.top = op.top - oy;\n\t\t\t} else {\n\t\t\t\tnewHeight = gridY - outerDimensions.height;\n\t\t\t\tthat.size.height = newHeight;\n\t\t\t\tthat.position.top = op.top + os.height - newHeight;\n\t\t\t}\n\t\t\tif ( newWidth - gridX > 0 ) {\n\t\t\t\tthat.size.width = newWidth;\n\t\t\t\tthat.position.left = op.left - ox;\n\t\t\t} else {\n\t\t\t\tnewWidth = gridX - outerDimensions.width;\n\t\t\t\tthat.size.width = newWidth;\n\t\t\t\tthat.position.left = op.left + os.width - newWidth;\n\t\t\t}\n\t\t}\n\t}\n\n} );\n\nreturn $.ui.resizable;\n\n} );\n","jquery/ui-modules/widgets/dialog.js":"/*!\n * jQuery UI Dialog 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Dialog\n//>>group: Widgets\n//>>description: Displays customizable dialog windows.\n//>>docs: http://api.jqueryui.com/dialog/\n//>>demos: http://jqueryui.com/dialog/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/dialog.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./button\",\n\t\t\t\"./draggable\",\n\t\t\t\"./mouse\",\n\t\t\t\"./resizable\",\n\t\t\t\"../focusable\",\n\t\t\t\"../keycode\",\n\t\t\t\"../position\",\n\t\t\t\"../safe-active-element\",\n\t\t\t\"../safe-blur\",\n\t\t\t\"../tabbable\",\n\t\t\t\"../unique-id\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.dialog\", {\n\tversion: \"1.13.1\",\n\toptions: {\n\t\tappendTo: \"body\",\n\t\tautoOpen: true,\n\t\tbuttons: [],\n\t\tclasses: {\n\t\t\t\"ui-dialog\": \"ui-corner-all\",\n\t\t\t\"ui-dialog-titlebar\": \"ui-corner-all\"\n\t\t},\n\t\tcloseOnEscape: true,\n\t\tcloseText: \"Close\",\n\t\tdraggable: true,\n\t\thide: null,\n\t\theight: \"auto\",\n\t\tmaxHeight: null,\n\t\tmaxWidth: null,\n\t\tminHeight: 150,\n\t\tminWidth: 150,\n\t\tmodal: false,\n\t\tposition: {\n\t\t\tmy: \"center\",\n\t\t\tat: \"center\",\n\t\t\tof: window,\n\t\t\tcollision: \"fit\",\n\n\t\t\t// Ensure the titlebar is always visible\n\t\t\tusing: function( pos ) {\n\t\t\t\tvar topOffset = $( this ).css( pos ).offset().top;\n\t\t\t\tif ( topOffset < 0 ) {\n\t\t\t\t\t$( this ).css( \"top\", pos.top - topOffset );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\tresizable: true,\n\t\tshow: null,\n\t\ttitle: null,\n\t\twidth: 300,\n\n\t\t// Callbacks\n\t\tbeforeClose: null,\n\t\tclose: null,\n\t\tdrag: null,\n\t\tdragStart: null,\n\t\tdragStop: null,\n\t\tfocus: null,\n\t\topen: null,\n\t\tresize: null,\n\t\tresizeStart: null,\n\t\tresizeStop: null\n\t},\n\n\tsizeRelatedOptions: {\n\t\tbuttons: true,\n\t\theight: true,\n\t\tmaxHeight: true,\n\t\tmaxWidth: true,\n\t\tminHeight: true,\n\t\tminWidth: true,\n\t\twidth: true\n\t},\n\n\tresizableRelatedOptions: {\n\t\tmaxHeight: true,\n\t\tmaxWidth: true,\n\t\tminHeight: true,\n\t\tminWidth: true\n\t},\n\n\t_create: function() {\n\t\tthis.originalCss = {\n\t\t\tdisplay: this.element[ 0 ].style.display,\n\t\t\twidth: this.element[ 0 ].style.width,\n\t\t\tminHeight: this.element[ 0 ].style.minHeight,\n\t\t\tmaxHeight: this.element[ 0 ].style.maxHeight,\n\t\t\theight: this.element[ 0 ].style.height\n\t\t};\n\t\tthis.originalPosition = {\n\t\t\tparent: this.element.parent(),\n\t\t\tindex: this.element.parent().children().index( this.element )\n\t\t};\n\t\tthis.originalTitle = this.element.attr( \"title\" );\n\t\tif ( this.options.title == null && this.originalTitle != null ) {\n\t\t\tthis.options.title = this.originalTitle;\n\t\t}\n\n\t\t// Dialogs can't be disabled\n\t\tif ( this.options.disabled ) {\n\t\t\tthis.options.disabled = false;\n\t\t}\n\n\t\tthis._createWrapper();\n\n\t\tthis.element\n\t\t\t.show()\n\t\t\t.removeAttr( \"title\" )\n\t\t\t.appendTo( this.uiDialog );\n\n\t\tthis._addClass( \"ui-dialog-content\", \"ui-widget-content\" );\n\n\t\tthis._createTitlebar();\n\t\tthis._createButtonPane();\n\n\t\tif ( this.options.draggable && $.fn.draggable ) {\n\t\t\tthis._makeDraggable();\n\t\t}\n\t\tif ( this.options.resizable && $.fn.resizable ) {\n\t\t\tthis._makeResizable();\n\t\t}\n\n\t\tthis._isOpen = false;\n\n\t\tthis._trackFocus();\n\t},\n\n\t_init: function() {\n\t\tif ( this.options.autoOpen ) {\n\t\t\tthis.open();\n\t\t}\n\t},\n\n\t_appendTo: function() {\n\t\tvar element = this.options.appendTo;\n\t\tif ( element && ( element.jquery || element.nodeType ) ) {\n\t\t\treturn $( element );\n\t\t}\n\t\treturn this.document.find( element || \"body\" ).eq( 0 );\n\t},\n\n\t_destroy: function() {\n\t\tvar next,\n\t\t\toriginalPosition = this.originalPosition;\n\n\t\tthis._untrackInstance();\n\t\tthis._destroyOverlay();\n\n\t\tthis.element\n\t\t\t.removeUniqueId()\n\t\t\t.css( this.originalCss )\n\n\t\t\t// Without detaching first, the following becomes really slow\n\t\t\t.detach();\n\n\t\tthis.uiDialog.remove();\n\n\t\tif ( this.originalTitle ) {\n\t\t\tthis.element.attr( \"title\", this.originalTitle );\n\t\t}\n\n\t\tnext = originalPosition.parent.children().eq( originalPosition.index );\n\n\t\t// Don't try to place the dialog next to itself (#8613)\n\t\tif ( next.length && next[ 0 ] !== this.element[ 0 ] ) {\n\t\t\tnext.before( this.element );\n\t\t} else {\n\t\t\toriginalPosition.parent.append( this.element );\n\t\t}\n\t},\n\n\twidget: function() {\n\t\treturn this.uiDialog;\n\t},\n\n\tdisable: $.noop,\n\tenable: $.noop,\n\n\tclose: function( event ) {\n\t\tvar that = this;\n\n\t\tif ( !this._isOpen || this._trigger( \"beforeClose\", event ) === false ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis._isOpen = false;\n\t\tthis._focusedElement = null;\n\t\tthis._destroyOverlay();\n\t\tthis._untrackInstance();\n\n\t\tif ( !this.opener.filter( \":focusable\" ).trigger( \"focus\" ).length ) {\n\n\t\t\t// Hiding a focused element doesn't trigger blur in WebKit\n\t\t\t// so in case we have nothing to focus on, explicitly blur the active element\n\t\t\t// https://bugs.webkit.org/show_bug.cgi?id=47182\n\t\t\t$.ui.safeBlur( $.ui.safeActiveElement( this.document[ 0 ] ) );\n\t\t}\n\n\t\tthis._hide( this.uiDialog, this.options.hide, function() {\n\t\t\tthat._trigger( \"close\", event );\n\t\t} );\n\t},\n\n\tisOpen: function() {\n\t\treturn this._isOpen;\n\t},\n\n\tmoveToTop: function() {\n\t\tthis._moveToTop();\n\t},\n\n\t_moveToTop: function( event, silent ) {\n\t\tvar moved = false,\n\t\t\tzIndices = this.uiDialog.siblings( \".ui-front:visible\" ).map( function() {\n\t\t\t\treturn +$( this ).css( \"z-index\" );\n\t\t\t} ).get(),\n\t\t\tzIndexMax = Math.max.apply( null, zIndices );\n\n\t\tif ( zIndexMax >= +this.uiDialog.css( \"z-index\" ) ) {\n\t\t\tthis.uiDialog.css( \"z-index\", zIndexMax + 1 );\n\t\t\tmoved = true;\n\t\t}\n\n\t\tif ( moved && !silent ) {\n\t\t\tthis._trigger( \"focus\", event );\n\t\t}\n\t\treturn moved;\n\t},\n\n\topen: function() {\n\t\tvar that = this;\n\t\tif ( this._isOpen ) {\n\t\t\tif ( this._moveToTop() ) {\n\t\t\t\tthis._focusTabbable();\n\t\t\t}\n\t\t\treturn;\n\t\t}\n\n\t\tthis._isOpen = true;\n\t\tthis.opener = $( $.ui.safeActiveElement( this.document[ 0 ] ) );\n\n\t\tthis._size();\n\t\tthis._position();\n\t\tthis._createOverlay();\n\t\tthis._moveToTop( null, true );\n\n\t\t// Ensure the overlay is moved to the top with the dialog, but only when\n\t\t// opening. The overlay shouldn't move after the dialog is open so that\n\t\t// modeless dialogs opened after the modal dialog stack properly.\n\t\tif ( this.overlay ) {\n\t\t\tthis.overlay.css( \"z-index\", this.uiDialog.css( \"z-index\" ) - 1 );\n\t\t}\n\n\t\tthis._show( this.uiDialog, this.options.show, function() {\n\t\t\tthat._focusTabbable();\n\t\t\tthat._trigger( \"focus\" );\n\t\t} );\n\n\t\t// Track the dialog immediately upon opening in case a focus event\n\t\t// somehow occurs outside of the dialog before an element inside the\n\t\t// dialog is focused (#10152)\n\t\tthis._makeFocusTarget();\n\n\t\tthis._trigger( \"open\" );\n\t},\n\n\t_focusTabbable: function() {\n\n\t\t// Set focus to the first match:\n\t\t// 1. An element that was focused previously\n\t\t// 2. First element inside the dialog matching [autofocus]\n\t\t// 3. Tabbable element inside the content element\n\t\t// 4. Tabbable element inside the buttonpane\n\t\t// 5. The close button\n\t\t// 6. The dialog itself\n\t\tvar hasFocus = this._focusedElement;\n\t\tif ( !hasFocus ) {\n\t\t\thasFocus = this.element.find( \"[autofocus]\" );\n\t\t}\n\t\tif ( !hasFocus.length ) {\n\t\t\thasFocus = this.element.find( \":tabbable\" );\n\t\t}\n\t\tif ( !hasFocus.length ) {\n\t\t\thasFocus = this.uiDialogButtonPane.find( \":tabbable\" );\n\t\t}\n\t\tif ( !hasFocus.length ) {\n\t\t\thasFocus = this.uiDialogTitlebarClose.filter( \":tabbable\" );\n\t\t}\n\t\tif ( !hasFocus.length ) {\n\t\t\thasFocus = this.uiDialog;\n\t\t}\n\t\thasFocus.eq( 0 ).trigger( \"focus\" );\n\t},\n\n\t_restoreTabbableFocus: function() {\n\t\tvar activeElement = $.ui.safeActiveElement( this.document[ 0 ] ),\n\t\t\tisActive = this.uiDialog[ 0 ] === activeElement ||\n\t\t\t\t$.contains( this.uiDialog[ 0 ], activeElement );\n\t\tif ( !isActive ) {\n\t\t\tthis._focusTabbable();\n\t\t}\n\t},\n\n\t_keepFocus: function( event ) {\n\t\tevent.preventDefault();\n\t\tthis._restoreTabbableFocus();\n\n\t\t// support: IE\n\t\t// IE <= 8 doesn't prevent moving focus even with event.preventDefault()\n\t\t// so we check again later\n\t\tthis._delay( this._restoreTabbableFocus );\n\t},\n\n\t_createWrapper: function() {\n\t\tthis.uiDialog = $( \"<div>\" )\n\t\t\t.hide()\n\t\t\t.attr( {\n\n\t\t\t\t// Setting tabIndex makes the div focusable\n\t\t\t\ttabIndex: -1,\n\t\t\t\trole: \"dialog\"\n\t\t\t} )\n\t\t\t.appendTo( this._appendTo() );\n\n\t\tthis._addClass( this.uiDialog, \"ui-dialog\", \"ui-widget ui-widget-content ui-front\" );\n\t\tthis._on( this.uiDialog, {\n\t\t\tkeydown: function( event ) {\n\t\t\t\tif ( this.options.closeOnEscape && !event.isDefaultPrevented() && event.keyCode &&\n\t\t\t\t\t\tevent.keyCode === $.ui.keyCode.ESCAPE ) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tthis.close( event );\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Prevent tabbing out of dialogs\n\t\t\t\tif ( event.keyCode !== $.ui.keyCode.TAB || event.isDefaultPrevented() ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tvar tabbables = this.uiDialog.find( \":tabbable\" ),\n\t\t\t\t\tfirst = tabbables.first(),\n\t\t\t\t\tlast = tabbables.last();\n\n\t\t\t\tif ( ( event.target === last[ 0 ] || event.target === this.uiDialog[ 0 ] ) &&\n\t\t\t\t\t\t!event.shiftKey ) {\n\t\t\t\t\tthis._delay( function() {\n\t\t\t\t\t\tfirst.trigger( \"focus\" );\n\t\t\t\t\t} );\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t} else if ( ( event.target === first[ 0 ] ||\n\t\t\t\t\t\tevent.target === this.uiDialog[ 0 ] ) && event.shiftKey ) {\n\t\t\t\t\tthis._delay( function() {\n\t\t\t\t\t\tlast.trigger( \"focus\" );\n\t\t\t\t\t} );\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t}\n\t\t\t},\n\t\t\tmousedown: function( event ) {\n\t\t\t\tif ( this._moveToTop( event ) ) {\n\t\t\t\t\tthis._focusTabbable();\n\t\t\t\t}\n\t\t\t}\n\t\t} );\n\n\t\t// We assume that any existing aria-describedby attribute means\n\t\t// that the dialog content is marked up properly\n\t\t// otherwise we brute force the content as the description\n\t\tif ( !this.element.find( \"[aria-describedby]\" ).length ) {\n\t\t\tthis.uiDialog.attr( {\n\t\t\t\t\"aria-describedby\": this.element.uniqueId().attr( \"id\" )\n\t\t\t} );\n\t\t}\n\t},\n\n\t_createTitlebar: function() {\n\t\tvar uiDialogTitle;\n\n\t\tthis.uiDialogTitlebar = $( \"<div>\" );\n\t\tthis._addClass( this.uiDialogTitlebar,\n\t\t\t\"ui-dialog-titlebar\", \"ui-widget-header ui-helper-clearfix\" );\n\t\tthis._on( this.uiDialogTitlebar, {\n\t\t\tmousedown: function( event ) {\n\n\t\t\t\t// Don't prevent click on close button (#8838)\n\t\t\t\t// Focusing a dialog that is partially scrolled out of view\n\t\t\t\t// causes the browser to scroll it into view, preventing the click event\n\t\t\t\tif ( !$( event.target ).closest( \".ui-dialog-titlebar-close\" ) ) {\n\n\t\t\t\t\t// Dialog isn't getting focus when dragging (#8063)\n\t\t\t\t\tthis.uiDialog.trigger( \"focus\" );\n\t\t\t\t}\n\t\t\t}\n\t\t} );\n\n\t\t// Support: IE\n\t\t// Use type=\"button\" to prevent enter keypresses in textboxes from closing the\n\t\t// dialog in IE (#9312)\n\t\tthis.uiDialogTitlebarClose = $( \"<button type='button'></button>\" )\n\t\t\t.button( {\n\t\t\t\tlabel: $( \"<a>\" ).text( this.options.closeText ).html(),\n\t\t\t\ticon: \"ui-icon-closethick\",\n\t\t\t\tshowLabel: false\n\t\t\t} )\n\t\t\t.appendTo( this.uiDialogTitlebar );\n\n\t\tthis._addClass( this.uiDialogTitlebarClose, \"ui-dialog-titlebar-close\" );\n\t\tthis._on( this.uiDialogTitlebarClose, {\n\t\t\tclick: function( event ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t\tthis.close( event );\n\t\t\t}\n\t\t} );\n\n\t\tuiDialogTitle = $( \"<span>\" ).uniqueId().prependTo( this.uiDialogTitlebar );\n\t\tthis._addClass( uiDialogTitle, \"ui-dialog-title\" );\n\t\tthis._title( uiDialogTitle );\n\n\t\tthis.uiDialogTitlebar.prependTo( this.uiDialog );\n\n\t\tthis.uiDialog.attr( {\n\t\t\t\"aria-labelledby\": uiDialogTitle.attr( \"id\" )\n\t\t} );\n\t},\n\n\t_title: function( title ) {\n\t\tif ( this.options.title ) {\n\t\t\ttitle.text( this.options.title );\n\t\t} else {\n\t\t\ttitle.html( \"&#160;\" );\n\t\t}\n\t},\n\n\t_createButtonPane: function() {\n\t\tthis.uiDialogButtonPane = $( \"<div>\" );\n\t\tthis._addClass( this.uiDialogButtonPane, \"ui-dialog-buttonpane\",\n\t\t\t\"ui-widget-content ui-helper-clearfix\" );\n\n\t\tthis.uiButtonSet = $( \"<div>\" )\n\t\t\t.appendTo( this.uiDialogButtonPane );\n\t\tthis._addClass( this.uiButtonSet, \"ui-dialog-buttonset\" );\n\n\t\tthis._createButtons();\n\t},\n\n\t_createButtons: function() {\n\t\tvar that = this,\n\t\t\tbuttons = this.options.buttons;\n\n\t\t// If we already have a button pane, remove it\n\t\tthis.uiDialogButtonPane.remove();\n\t\tthis.uiButtonSet.empty();\n\n\t\tif ( $.isEmptyObject( buttons ) || ( Array.isArray( buttons ) && !buttons.length ) ) {\n\t\t\tthis._removeClass( this.uiDialog, \"ui-dialog-buttons\" );\n\t\t\treturn;\n\t\t}\n\n\t\t$.each( buttons, function( name, props ) {\n\t\t\tvar click, buttonOptions;\n\t\t\tprops = typeof props === \"function\" ?\n\t\t\t\t{ click: props, text: name } :\n\t\t\t\tprops;\n\n\t\t\t// Default to a non-submitting button\n\t\t\tprops = $.extend( { type: \"button\" }, props );\n\n\t\t\t// Change the context for the click callback to be the main element\n\t\t\tclick = props.click;\n\t\t\tbuttonOptions = {\n\t\t\t\ticon: props.icon,\n\t\t\t\ticonPosition: props.iconPosition,\n\t\t\t\tshowLabel: props.showLabel,\n\n\t\t\t\t// Deprecated options\n\t\t\t\ticons: props.icons,\n\t\t\t\ttext: props.text\n\t\t\t};\n\n\t\t\tdelete props.click;\n\t\t\tdelete props.icon;\n\t\t\tdelete props.iconPosition;\n\t\t\tdelete props.showLabel;\n\n\t\t\t// Deprecated options\n\t\t\tdelete props.icons;\n\t\t\tif ( typeof props.text === \"boolean\" ) {\n\t\t\t\tdelete props.text;\n\t\t\t}\n\n\t\t\t$( \"<button></button>\", props )\n\t\t\t\t.button( buttonOptions )\n\t\t\t\t.appendTo( that.uiButtonSet )\n\t\t\t\t.on( \"click\", function() {\n\t\t\t\t\tclick.apply( that.element[ 0 ], arguments );\n\t\t\t\t} );\n\t\t} );\n\t\tthis._addClass( this.uiDialog, \"ui-dialog-buttons\" );\n\t\tthis.uiDialogButtonPane.appendTo( this.uiDialog );\n\t},\n\n\t_makeDraggable: function() {\n\t\tvar that = this,\n\t\t\toptions = this.options;\n\n\t\tfunction filteredUi( ui ) {\n\t\t\treturn {\n\t\t\t\tposition: ui.position,\n\t\t\t\toffset: ui.offset\n\t\t\t};\n\t\t}\n\n\t\tthis.uiDialog.draggable( {\n\t\t\tcancel: \".ui-dialog-content, .ui-dialog-titlebar-close\",\n\t\t\thandle: \".ui-dialog-titlebar\",\n\t\t\tcontainment: \"document\",\n\t\t\tstart: function( event, ui ) {\n\t\t\t\tthat._addClass( $( this ), \"ui-dialog-dragging\" );\n\t\t\t\tthat._blockFrames();\n\t\t\t\tthat._trigger( \"dragStart\", event, filteredUi( ui ) );\n\t\t\t},\n\t\t\tdrag: function( event, ui ) {\n\t\t\t\tthat._trigger( \"drag\", event, filteredUi( ui ) );\n\t\t\t},\n\t\t\tstop: function( event, ui ) {\n\t\t\t\tvar left = ui.offset.left - that.document.scrollLeft(),\n\t\t\t\t\ttop = ui.offset.top - that.document.scrollTop();\n\n\t\t\t\toptions.position = {\n\t\t\t\t\tmy: \"left top\",\n\t\t\t\t\tat: \"left\" + ( left >= 0 ? \"+\" : \"\" ) + left + \" \" +\n\t\t\t\t\t\t\"top\" + ( top >= 0 ? \"+\" : \"\" ) + top,\n\t\t\t\t\tof: that.window\n\t\t\t\t};\n\t\t\t\tthat._removeClass( $( this ), \"ui-dialog-dragging\" );\n\t\t\t\tthat._unblockFrames();\n\t\t\t\tthat._trigger( \"dragStop\", event, filteredUi( ui ) );\n\t\t\t}\n\t\t} );\n\t},\n\n\t_makeResizable: function() {\n\t\tvar that = this,\n\t\t\toptions = this.options,\n\t\t\thandles = options.resizable,\n\n\t\t\t// .ui-resizable has position: relative defined in the stylesheet\n\t\t\t// but dialogs have to use absolute or fixed positioning\n\t\t\tposition = this.uiDialog.css( \"position\" ),\n\t\t\tresizeHandles = typeof handles === \"string\" ?\n\t\t\t\thandles :\n\t\t\t\t\"n,e,s,w,se,sw,ne,nw\";\n\n\t\tfunction filteredUi( ui ) {\n\t\t\treturn {\n\t\t\t\toriginalPosition: ui.originalPosition,\n\t\t\t\toriginalSize: ui.originalSize,\n\t\t\t\tposition: ui.position,\n\t\t\t\tsize: ui.size\n\t\t\t};\n\t\t}\n\n\t\tthis.uiDialog.resizable( {\n\t\t\tcancel: \".ui-dialog-content\",\n\t\t\tcontainment: \"document\",\n\t\t\talsoResize: this.element,\n\t\t\tmaxWidth: options.maxWidth,\n\t\t\tmaxHeight: options.maxHeight,\n\t\t\tminWidth: options.minWidth,\n\t\t\tminHeight: this._minHeight(),\n\t\t\thandles: resizeHandles,\n\t\t\tstart: function( event, ui ) {\n\t\t\t\tthat._addClass( $( this ), \"ui-dialog-resizing\" );\n\t\t\t\tthat._blockFrames();\n\t\t\t\tthat._trigger( \"resizeStart\", event, filteredUi( ui ) );\n\t\t\t},\n\t\t\tresize: function( event, ui ) {\n\t\t\t\tthat._trigger( \"resize\", event, filteredUi( ui ) );\n\t\t\t},\n\t\t\tstop: function( event, ui ) {\n\t\t\t\tvar offset = that.uiDialog.offset(),\n\t\t\t\t\tleft = offset.left - that.document.scrollLeft(),\n\t\t\t\t\ttop = offset.top - that.document.scrollTop();\n\n\t\t\t\toptions.height = that.uiDialog.height();\n\t\t\t\toptions.width = that.uiDialog.width();\n\t\t\t\toptions.position = {\n\t\t\t\t\tmy: \"left top\",\n\t\t\t\t\tat: \"left\" + ( left >= 0 ? \"+\" : \"\" ) + left + \" \" +\n\t\t\t\t\t\t\"top\" + ( top >= 0 ? \"+\" : \"\" ) + top,\n\t\t\t\t\tof: that.window\n\t\t\t\t};\n\t\t\t\tthat._removeClass( $( this ), \"ui-dialog-resizing\" );\n\t\t\t\tthat._unblockFrames();\n\t\t\t\tthat._trigger( \"resizeStop\", event, filteredUi( ui ) );\n\t\t\t}\n\t\t} )\n\t\t\t.css( \"position\", position );\n\t},\n\n\t_trackFocus: function() {\n\t\tthis._on( this.widget(), {\n\t\t\tfocusin: function( event ) {\n\t\t\t\tthis._makeFocusTarget();\n\t\t\t\tthis._focusedElement = $( event.target );\n\t\t\t}\n\t\t} );\n\t},\n\n\t_makeFocusTarget: function() {\n\t\tthis._untrackInstance();\n\t\tthis._trackingInstances().unshift( this );\n\t},\n\n\t_untrackInstance: function() {\n\t\tvar instances = this._trackingInstances(),\n\t\t\texists = $.inArray( this, instances );\n\t\tif ( exists !== -1 ) {\n\t\t\tinstances.splice( exists, 1 );\n\t\t}\n\t},\n\n\t_trackingInstances: function() {\n\t\tvar instances = this.document.data( \"ui-dialog-instances\" );\n\t\tif ( !instances ) {\n\t\t\tinstances = [];\n\t\t\tthis.document.data( \"ui-dialog-instances\", instances );\n\t\t}\n\t\treturn instances;\n\t},\n\n\t_minHeight: function() {\n\t\tvar options = this.options;\n\n\t\treturn options.height === \"auto\" ?\n\t\t\toptions.minHeight :\n\t\t\tMath.min( options.minHeight, options.height );\n\t},\n\n\t_position: function() {\n\n\t\t// Need to show the dialog to get the actual offset in the position plugin\n\t\tvar isVisible = this.uiDialog.is( \":visible\" );\n\t\tif ( !isVisible ) {\n\t\t\tthis.uiDialog.show();\n\t\t}\n\t\tthis.uiDialog.position( this.options.position );\n\t\tif ( !isVisible ) {\n\t\t\tthis.uiDialog.hide();\n\t\t}\n\t},\n\n\t_setOptions: function( options ) {\n\t\tvar that = this,\n\t\t\tresize = false,\n\t\t\tresizableOptions = {};\n\n\t\t$.each( options, function( key, value ) {\n\t\t\tthat._setOption( key, value );\n\n\t\t\tif ( key in that.sizeRelatedOptions ) {\n\t\t\t\tresize = true;\n\t\t\t}\n\t\t\tif ( key in that.resizableRelatedOptions ) {\n\t\t\t\tresizableOptions[ key ] = value;\n\t\t\t}\n\t\t} );\n\n\t\tif ( resize ) {\n\t\t\tthis._size();\n\t\t\tthis._position();\n\t\t}\n\t\tif ( this.uiDialog.is( \":data(ui-resizable)\" ) ) {\n\t\t\tthis.uiDialog.resizable( \"option\", resizableOptions );\n\t\t}\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tvar isDraggable, isResizable,\n\t\t\tuiDialog = this.uiDialog;\n\n\t\tif ( key === \"disabled\" ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\tif ( key === \"appendTo\" ) {\n\t\t\tthis.uiDialog.appendTo( this._appendTo() );\n\t\t}\n\n\t\tif ( key === \"buttons\" ) {\n\t\t\tthis._createButtons();\n\t\t}\n\n\t\tif ( key === \"closeText\" ) {\n\t\t\tthis.uiDialogTitlebarClose.button( {\n\n\t\t\t\t// Ensure that we always pass a string\n\t\t\t\tlabel: $( \"<a>\" ).text( \"\" + this.options.closeText ).html()\n\t\t\t} );\n\t\t}\n\n\t\tif ( key === \"draggable\" ) {\n\t\t\tisDraggable = uiDialog.is( \":data(ui-draggable)\" );\n\t\t\tif ( isDraggable && !value ) {\n\t\t\t\tuiDialog.draggable( \"destroy\" );\n\t\t\t}\n\n\t\t\tif ( !isDraggable && value ) {\n\t\t\t\tthis._makeDraggable();\n\t\t\t}\n\t\t}\n\n\t\tif ( key === \"position\" ) {\n\t\t\tthis._position();\n\t\t}\n\n\t\tif ( key === \"resizable\" ) {\n\n\t\t\t// currently resizable, becoming non-resizable\n\t\t\tisResizable = uiDialog.is( \":data(ui-resizable)\" );\n\t\t\tif ( isResizable && !value ) {\n\t\t\t\tuiDialog.resizable( \"destroy\" );\n\t\t\t}\n\n\t\t\t// Currently resizable, changing handles\n\t\t\tif ( isResizable && typeof value === \"string\" ) {\n\t\t\t\tuiDialog.resizable( \"option\", \"handles\", value );\n\t\t\t}\n\n\t\t\t// Currently non-resizable, becoming resizable\n\t\t\tif ( !isResizable && value !== false ) {\n\t\t\t\tthis._makeResizable();\n\t\t\t}\n\t\t}\n\n\t\tif ( key === \"title\" ) {\n\t\t\tthis._title( this.uiDialogTitlebar.find( \".ui-dialog-title\" ) );\n\t\t}\n\t},\n\n\t_size: function() {\n\n\t\t// If the user has resized the dialog, the .ui-dialog and .ui-dialog-content\n\t\t// divs will both have width and height set, so we need to reset them\n\t\tvar nonContentHeight, minContentHeight, maxContentHeight,\n\t\t\toptions = this.options;\n\n\t\t// Reset content sizing\n\t\tthis.element.show().css( {\n\t\t\twidth: \"auto\",\n\t\t\tminHeight: 0,\n\t\t\tmaxHeight: \"none\",\n\t\t\theight: 0\n\t\t} );\n\n\t\tif ( options.minWidth > options.width ) {\n\t\t\toptions.width = options.minWidth;\n\t\t}\n\n\t\t// Reset wrapper sizing\n\t\t// determine the height of all the non-content elements\n\t\tnonContentHeight = this.uiDialog.css( {\n\t\t\theight: \"auto\",\n\t\t\twidth: options.width\n\t\t} )\n\t\t\t.outerHeight();\n\t\tminContentHeight = Math.max( 0, options.minHeight - nonContentHeight );\n\t\tmaxContentHeight = typeof options.maxHeight === \"number\" ?\n\t\t\tMath.max( 0, options.maxHeight - nonContentHeight ) :\n\t\t\t\"none\";\n\n\t\tif ( options.height === \"auto\" ) {\n\t\t\tthis.element.css( {\n\t\t\t\tminHeight: minContentHeight,\n\t\t\t\tmaxHeight: maxContentHeight,\n\t\t\t\theight: \"auto\"\n\t\t\t} );\n\t\t} else {\n\t\t\tthis.element.height( Math.max( 0, options.height - nonContentHeight ) );\n\t\t}\n\n\t\tif ( this.uiDialog.is( \":data(ui-resizable)\" ) ) {\n\t\t\tthis.uiDialog.resizable( \"option\", \"minHeight\", this._minHeight() );\n\t\t}\n\t},\n\n\t_blockFrames: function() {\n\t\tthis.iframeBlocks = this.document.find( \"iframe\" ).map( function() {\n\t\t\tvar iframe = $( this );\n\n\t\t\treturn $( \"<div>\" )\n\t\t\t\t.css( {\n\t\t\t\t\tposition: \"absolute\",\n\t\t\t\t\twidth: iframe.outerWidth(),\n\t\t\t\t\theight: iframe.outerHeight()\n\t\t\t\t} )\n\t\t\t\t.appendTo( iframe.parent() )\n\t\t\t\t.offset( iframe.offset() )[ 0 ];\n\t\t} );\n\t},\n\n\t_unblockFrames: function() {\n\t\tif ( this.iframeBlocks ) {\n\t\t\tthis.iframeBlocks.remove();\n\t\t\tdelete this.iframeBlocks;\n\t\t}\n\t},\n\n\t_allowInteraction: function( event ) {\n\t\tif ( $( event.target ).closest( \".ui-dialog\" ).length ) {\n\t\t\treturn true;\n\t\t}\n\n\t\t// TODO: Remove hack when datepicker implements\n\t\t// the .ui-front logic (#8989)\n\t\treturn !!$( event.target ).closest( \".ui-datepicker\" ).length;\n\t},\n\n\t_createOverlay: function() {\n\t\tif ( !this.options.modal ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar jqMinor = $.fn.jquery.substring( 0, 4 );\n\n\t\t// We use a delay in case the overlay is created from an\n\t\t// event that we're going to be cancelling (#2804)\n\t\tvar isOpening = true;\n\t\tthis._delay( function() {\n\t\t\tisOpening = false;\n\t\t} );\n\n\t\tif ( !this.document.data( \"ui-dialog-overlays\" ) ) {\n\n\t\t\t// Prevent use of anchors and inputs\n\t\t\t// This doesn't use `_on()` because it is a shared event handler\n\t\t\t// across all open modal dialogs.\n\t\t\tthis.document.on( \"focusin.ui-dialog\", function( event ) {\n\t\t\t\tif ( isOpening ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tvar instance = this._trackingInstances()[ 0 ];\n\t\t\t\tif ( !instance._allowInteraction( event ) ) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tinstance._focusTabbable();\n\n\t\t\t\t\t// Support: jQuery >=3.4 <3.6 only\n\t\t\t\t\t// Focus re-triggering in jQuery 3.4/3.5 makes the original element\n\t\t\t\t\t// have its focus event propagated last, breaking the re-targeting.\n\t\t\t\t\t// Trigger focus in a delay in addition if needed to avoid the issue\n\t\t\t\t\t// See https://github.com/jquery/jquery/issues/4382\n\t\t\t\t\tif ( jqMinor === \"3.4.\" || jqMinor === \"3.5.\" ) {\n\t\t\t\t\t\tinstance._delay( instance._restoreTabbableFocus );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}.bind( this ) );\n\t\t}\n\n\t\tthis.overlay = $( \"<div>\" )\n\t\t\t.appendTo( this._appendTo() );\n\n\t\tthis._addClass( this.overlay, null, \"ui-widget-overlay ui-front\" );\n\t\tthis._on( this.overlay, {\n\t\t\tmousedown: \"_keepFocus\"\n\t\t} );\n\t\tthis.document.data( \"ui-dialog-overlays\",\n\t\t\t( this.document.data( \"ui-dialog-overlays\" ) || 0 ) + 1 );\n\t},\n\n\t_destroyOverlay: function() {\n\t\tif ( !this.options.modal ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( this.overlay ) {\n\t\t\tvar overlays = this.document.data( \"ui-dialog-overlays\" ) - 1;\n\n\t\t\tif ( !overlays ) {\n\t\t\t\tthis.document.off( \"focusin.ui-dialog\" );\n\t\t\t\tthis.document.removeData( \"ui-dialog-overlays\" );\n\t\t\t} else {\n\t\t\t\tthis.document.data( \"ui-dialog-overlays\", overlays );\n\t\t\t}\n\n\t\t\tthis.overlay.remove();\n\t\t\tthis.overlay = null;\n\t\t}\n\t}\n} );\n\n// DEPRECATED\n// TODO: switch return back to widget declaration at top of file when this is removed\nif ( $.uiBackCompat !== false ) {\n\n\t// Backcompat for dialogClass option\n\t$.widget( \"ui.dialog\", $.ui.dialog, {\n\t\toptions: {\n\t\t\tdialogClass: \"\"\n\t\t},\n\t\t_createWrapper: function() {\n\t\t\tthis._super();\n\t\t\tthis.uiDialog.addClass( this.options.dialogClass );\n\t\t},\n\t\t_setOption: function( key, value ) {\n\t\t\tif ( key === \"dialogClass\" ) {\n\t\t\t\tthis.uiDialog\n\t\t\t\t\t.removeClass( this.options.dialogClass )\n\t\t\t\t\t.addClass( value );\n\t\t\t}\n\t\t\tthis._superApply( arguments );\n\t\t}\n\t} );\n}\n\nreturn $.ui.dialog;\n\n} );\n","jquery/ui-modules/widgets/tabs.js":"/*!\n * jQuery UI Tabs 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Tabs\n//>>group: Widgets\n//>>description: Transforms a set of container elements into a tab structure.\n//>>docs: http://api.jqueryui.com/tabs/\n//>>demos: http://jqueryui.com/tabs/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/tabs.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../keycode\",\n\t\t\t\"../safe-active-element\",\n\t\t\t\"../unique-id\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.tabs\", {\n\tversion: \"1.13.1\",\n\tdelay: 300,\n\toptions: {\n\t\tactive: null,\n\t\tclasses: {\n\t\t\t\"ui-tabs\": \"ui-corner-all\",\n\t\t\t\"ui-tabs-nav\": \"ui-corner-all\",\n\t\t\t\"ui-tabs-panel\": \"ui-corner-bottom\",\n\t\t\t\"ui-tabs-tab\": \"ui-corner-top\"\n\t\t},\n\t\tcollapsible: false,\n\t\tevent: \"click\",\n\t\theightStyle: \"content\",\n\t\thide: null,\n\t\tshow: null,\n\n\t\t// Callbacks\n\t\tactivate: null,\n\t\tbeforeActivate: null,\n\t\tbeforeLoad: null,\n\t\tload: null\n\t},\n\n\t_isLocal: ( function() {\n\t\tvar rhash = /#.*$/;\n\n\t\treturn function( anchor ) {\n\t\t\tvar anchorUrl, locationUrl;\n\n\t\t\tanchorUrl = anchor.href.replace( rhash, \"\" );\n\t\t\tlocationUrl = location.href.replace( rhash, \"\" );\n\n\t\t\t// Decoding may throw an error if the URL isn't UTF-8 (#9518)\n\t\t\ttry {\n\t\t\t\tanchorUrl = decodeURIComponent( anchorUrl );\n\t\t\t} catch ( error ) {}\n\t\t\ttry {\n\t\t\t\tlocationUrl = decodeURIComponent( locationUrl );\n\t\t\t} catch ( error ) {}\n\n\t\t\treturn anchor.hash.length > 1 && anchorUrl === locationUrl;\n\t\t};\n\t} )(),\n\n\t_create: function() {\n\t\tvar that = this,\n\t\t\toptions = this.options;\n\n\t\tthis.running = false;\n\n\t\tthis._addClass( \"ui-tabs\", \"ui-widget ui-widget-content\" );\n\t\tthis._toggleClass( \"ui-tabs-collapsible\", null, options.collapsible );\n\n\t\tthis._processTabs();\n\t\toptions.active = this._initialActive();\n\n\t\t// Take disabling tabs via class attribute from HTML\n\t\t// into account and update option properly.\n\t\tif ( Array.isArray( options.disabled ) ) {\n\t\t\toptions.disabled = $.uniqueSort( options.disabled.concat(\n\t\t\t\t$.map( this.tabs.filter( \".ui-state-disabled\" ), function( li ) {\n\t\t\t\t\treturn that.tabs.index( li );\n\t\t\t\t} )\n\t\t\t) ).sort();\n\t\t}\n\n\t\t// Check for length avoids error when initializing empty list\n\t\tif ( this.options.active !== false && this.anchors.length ) {\n\t\t\tthis.active = this._findActive( options.active );\n\t\t} else {\n\t\t\tthis.active = $();\n\t\t}\n\n\t\tthis._refresh();\n\n\t\tif ( this.active.length ) {\n\t\t\tthis.load( options.active );\n\t\t}\n\t},\n\n\t_initialActive: function() {\n\t\tvar active = this.options.active,\n\t\t\tcollapsible = this.options.collapsible,\n\t\t\tlocationHash = location.hash.substring( 1 );\n\n\t\tif ( active === null ) {\n\n\t\t\t// check the fragment identifier in the URL\n\t\t\tif ( locationHash ) {\n\t\t\t\tthis.tabs.each( function( i, tab ) {\n\t\t\t\t\tif ( $( tab ).attr( \"aria-controls\" ) === locationHash ) {\n\t\t\t\t\t\tactive = i;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\t// Check for a tab marked active via a class\n\t\t\tif ( active === null ) {\n\t\t\t\tactive = this.tabs.index( this.tabs.filter( \".ui-tabs-active\" ) );\n\t\t\t}\n\n\t\t\t// No active tab, set to false\n\t\t\tif ( active === null || active === -1 ) {\n\t\t\t\tactive = this.tabs.length ? 0 : false;\n\t\t\t}\n\t\t}\n\n\t\t// Handle numbers: negative, out of range\n\t\tif ( active !== false ) {\n\t\t\tactive = this.tabs.index( this.tabs.eq( active ) );\n\t\t\tif ( active === -1 ) {\n\t\t\t\tactive = collapsible ? false : 0;\n\t\t\t}\n\t\t}\n\n\t\t// Don't allow collapsible: false and active: false\n\t\tif ( !collapsible && active === false && this.anchors.length ) {\n\t\t\tactive = 0;\n\t\t}\n\n\t\treturn active;\n\t},\n\n\t_getCreateEventData: function() {\n\t\treturn {\n\t\t\ttab: this.active,\n\t\t\tpanel: !this.active.length ? $() : this._getPanelForTab( this.active )\n\t\t};\n\t},\n\n\t_tabKeydown: function( event ) {\n\t\tvar focusedTab = $( $.ui.safeActiveElement( this.document[ 0 ] ) ).closest( \"li\" ),\n\t\t\tselectedIndex = this.tabs.index( focusedTab ),\n\t\t\tgoingForward = true;\n\n\t\tif ( this._handlePageNav( event ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tswitch ( event.keyCode ) {\n\t\tcase $.ui.keyCode.RIGHT:\n\t\tcase $.ui.keyCode.DOWN:\n\t\t\tselectedIndex++;\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.UP:\n\t\tcase $.ui.keyCode.LEFT:\n\t\t\tgoingForward = false;\n\t\t\tselectedIndex--;\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.END:\n\t\t\tselectedIndex = this.anchors.length - 1;\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.HOME:\n\t\t\tselectedIndex = 0;\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.SPACE:\n\n\t\t\t// Activate only, no collapsing\n\t\t\tevent.preventDefault();\n\t\t\tclearTimeout( this.activating );\n\t\t\tthis._activate( selectedIndex );\n\t\t\treturn;\n\t\tcase $.ui.keyCode.ENTER:\n\n\t\t\t// Toggle (cancel delayed activation, allow collapsing)\n\t\t\tevent.preventDefault();\n\t\t\tclearTimeout( this.activating );\n\n\t\t\t// Determine if we should collapse or activate\n\t\t\tthis._activate( selectedIndex === this.options.active ? false : selectedIndex );\n\t\t\treturn;\n\t\tdefault:\n\t\t\treturn;\n\t\t}\n\n\t\t// Focus the appropriate tab, based on which key was pressed\n\t\tevent.preventDefault();\n\t\tclearTimeout( this.activating );\n\t\tselectedIndex = this._focusNextTab( selectedIndex, goingForward );\n\n\t\t// Navigating with control/command key will prevent automatic activation\n\t\tif ( !event.ctrlKey && !event.metaKey ) {\n\n\t\t\t// Update aria-selected immediately so that AT think the tab is already selected.\n\t\t\t// Otherwise AT may confuse the user by stating that they need to activate the tab,\n\t\t\t// but the tab will already be activated by the time the announcement finishes.\n\t\t\tfocusedTab.attr( \"aria-selected\", \"false\" );\n\t\t\tthis.tabs.eq( selectedIndex ).attr( \"aria-selected\", \"true\" );\n\n\t\t\tthis.activating = this._delay( function() {\n\t\t\t\tthis.option( \"active\", selectedIndex );\n\t\t\t}, this.delay );\n\t\t}\n\t},\n\n\t_panelKeydown: function( event ) {\n\t\tif ( this._handlePageNav( event ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Ctrl+up moves focus to the current tab\n\t\tif ( event.ctrlKey && event.keyCode === $.ui.keyCode.UP ) {\n\t\t\tevent.preventDefault();\n\t\t\tthis.active.trigger( \"focus\" );\n\t\t}\n\t},\n\n\t// Alt+page up/down moves focus to the previous/next tab (and activates)\n\t_handlePageNav: function( event ) {\n\t\tif ( event.altKey && event.keyCode === $.ui.keyCode.PAGE_UP ) {\n\t\t\tthis._activate( this._focusNextTab( this.options.active - 1, false ) );\n\t\t\treturn true;\n\t\t}\n\t\tif ( event.altKey && event.keyCode === $.ui.keyCode.PAGE_DOWN ) {\n\t\t\tthis._activate( this._focusNextTab( this.options.active + 1, true ) );\n\t\t\treturn true;\n\t\t}\n\t},\n\n\t_findNextTab: function( index, goingForward ) {\n\t\tvar lastTabIndex = this.tabs.length - 1;\n\n\t\tfunction constrain() {\n\t\t\tif ( index > lastTabIndex ) {\n\t\t\t\tindex = 0;\n\t\t\t}\n\t\t\tif ( index < 0 ) {\n\t\t\t\tindex = lastTabIndex;\n\t\t\t}\n\t\t\treturn index;\n\t\t}\n\n\t\twhile ( $.inArray( constrain(), this.options.disabled ) !== -1 ) {\n\t\t\tindex = goingForward ? index + 1 : index - 1;\n\t\t}\n\n\t\treturn index;\n\t},\n\n\t_focusNextTab: function( index, goingForward ) {\n\t\tindex = this._findNextTab( index, goingForward );\n\t\tthis.tabs.eq( index ).trigger( \"focus\" );\n\t\treturn index;\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"active\" ) {\n\n\t\t\t// _activate() will handle invalid values and update this.options\n\t\t\tthis._activate( value );\n\t\t\treturn;\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\tif ( key === \"collapsible\" ) {\n\t\t\tthis._toggleClass( \"ui-tabs-collapsible\", null, value );\n\n\t\t\t// Setting collapsible: false while collapsed; open first panel\n\t\t\tif ( !value && this.options.active === false ) {\n\t\t\t\tthis._activate( 0 );\n\t\t\t}\n\t\t}\n\n\t\tif ( key === \"event\" ) {\n\t\t\tthis._setupEvents( value );\n\t\t}\n\n\t\tif ( key === \"heightStyle\" ) {\n\t\t\tthis._setupHeightStyle( value );\n\t\t}\n\t},\n\n\t_sanitizeSelector: function( hash ) {\n\t\treturn hash ? hash.replace( /[!\"$%&'()*+,.\\/:;<=>?@\\[\\]\\^`{|}~]/g, \"\\\\$&\" ) : \"\";\n\t},\n\n\trefresh: function() {\n\t\tvar options = this.options,\n\t\t\tlis = this.tablist.children( \":has(a[href])\" );\n\n\t\t// Get disabled tabs from class attribute from HTML\n\t\t// this will get converted to a boolean if needed in _refresh()\n\t\toptions.disabled = $.map( lis.filter( \".ui-state-disabled\" ), function( tab ) {\n\t\t\treturn lis.index( tab );\n\t\t} );\n\n\t\tthis._processTabs();\n\n\t\t// Was collapsed or no tabs\n\t\tif ( options.active === false || !this.anchors.length ) {\n\t\t\toptions.active = false;\n\t\t\tthis.active = $();\n\n\t\t// was active, but active tab is gone\n\t\t} else if ( this.active.length && !$.contains( this.tablist[ 0 ], this.active[ 0 ] ) ) {\n\n\t\t\t// all remaining tabs are disabled\n\t\t\tif ( this.tabs.length === options.disabled.length ) {\n\t\t\t\toptions.active = false;\n\t\t\t\tthis.active = $();\n\n\t\t\t// activate previous tab\n\t\t\t} else {\n\t\t\t\tthis._activate( this._findNextTab( Math.max( 0, options.active - 1 ), false ) );\n\t\t\t}\n\n\t\t// was active, active tab still exists\n\t\t} else {\n\n\t\t\t// make sure active index is correct\n\t\t\toptions.active = this.tabs.index( this.active );\n\t\t}\n\n\t\tthis._refresh();\n\t},\n\n\t_refresh: function() {\n\t\tthis._setOptionDisabled( this.options.disabled );\n\t\tthis._setupEvents( this.options.event );\n\t\tthis._setupHeightStyle( this.options.heightStyle );\n\n\t\tthis.tabs.not( this.active ).attr( {\n\t\t\t\"aria-selected\": \"false\",\n\t\t\t\"aria-expanded\": \"false\",\n\t\t\ttabIndex: -1\n\t\t} );\n\t\tthis.panels.not( this._getPanelForTab( this.active ) )\n\t\t\t.hide()\n\t\t\t.attr( {\n\t\t\t\t\"aria-hidden\": \"true\"\n\t\t\t} );\n\n\t\t// Make sure one tab is in the tab order\n\t\tif ( !this.active.length ) {\n\t\t\tthis.tabs.eq( 0 ).attr( \"tabIndex\", 0 );\n\t\t} else {\n\t\t\tthis.active\n\t\t\t\t.attr( {\n\t\t\t\t\t\"aria-selected\": \"true\",\n\t\t\t\t\t\"aria-expanded\": \"true\",\n\t\t\t\t\ttabIndex: 0\n\t\t\t\t} );\n\t\t\tthis._addClass( this.active, \"ui-tabs-active\", \"ui-state-active\" );\n\t\t\tthis._getPanelForTab( this.active )\n\t\t\t\t.show()\n\t\t\t\t.attr( {\n\t\t\t\t\t\"aria-hidden\": \"false\"\n\t\t\t\t} );\n\t\t}\n\t},\n\n\t_processTabs: function() {\n\t\tvar that = this,\n\t\t\tprevTabs = this.tabs,\n\t\t\tprevAnchors = this.anchors,\n\t\t\tprevPanels = this.panels;\n\n\t\tthis.tablist = this._getList().attr( \"role\", \"tablist\" );\n\t\tthis._addClass( this.tablist, \"ui-tabs-nav\",\n\t\t\t\"ui-helper-reset ui-helper-clearfix ui-widget-header\" );\n\n\t\t// Prevent users from focusing disabled tabs via click\n\t\tthis.tablist\n\t\t\t.on( \"mousedown\" + this.eventNamespace, \"> li\", function( event ) {\n\t\t\t\tif ( $( this ).is( \".ui-state-disabled\" ) ) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t}\n\t\t\t} )\n\n\t\t\t// Support: IE <9\n\t\t\t// Preventing the default action in mousedown doesn't prevent IE\n\t\t\t// from focusing the element, so if the anchor gets focused, blur.\n\t\t\t// We don't have to worry about focusing the previously focused\n\t\t\t// element since clicking on a non-focusable element should focus\n\t\t\t// the body anyway.\n\t\t\t.on( \"focus\" + this.eventNamespace, \".ui-tabs-anchor\", function() {\n\t\t\t\tif ( $( this ).closest( \"li\" ).is( \".ui-state-disabled\" ) ) {\n\t\t\t\t\tthis.blur();\n\t\t\t\t}\n\t\t\t} );\n\n\t\tthis.tabs = this.tablist.find( \"> li:has(a[href])\" )\n\t\t\t.attr( {\n\t\t\t\trole: \"tab\",\n\t\t\t\ttabIndex: -1\n\t\t\t} );\n\t\tthis._addClass( this.tabs, \"ui-tabs-tab\", \"ui-state-default\" );\n\n\t\tthis.anchors = this.tabs.map( function() {\n\t\t\treturn $( \"a\", this )[ 0 ];\n\t\t} )\n\t\t\t.attr( {\n\t\t\t\ttabIndex: -1\n\t\t\t} );\n\t\tthis._addClass( this.anchors, \"ui-tabs-anchor\" );\n\n\t\tthis.panels = $();\n\n\t\tthis.anchors.each( function( i, anchor ) {\n\t\t\tvar selector, panel, panelId,\n\t\t\t\tanchorId = $( anchor ).uniqueId().attr( \"id\" ),\n\t\t\t\ttab = $( anchor ).closest( \"li\" ),\n\t\t\t\toriginalAriaControls = tab.attr( \"aria-controls\" );\n\n\t\t\t// Inline tab\n\t\t\tif ( that._isLocal( anchor ) ) {\n\t\t\t\tselector = anchor.hash;\n\t\t\t\tpanelId = selector.substring( 1 );\n\t\t\t\tpanel = that.element.find( that._sanitizeSelector( selector ) );\n\n\t\t\t// remote tab\n\t\t\t} else {\n\n\t\t\t\t// If the tab doesn't already have aria-controls,\n\t\t\t\t// generate an id by using a throw-away element\n\t\t\t\tpanelId = tab.attr( \"aria-controls\" ) || $( {} ).uniqueId()[ 0 ].id;\n\t\t\t\tselector = \"#\" + panelId;\n\t\t\t\tpanel = that.element.find( selector );\n\t\t\t\tif ( !panel.length ) {\n\t\t\t\t\tpanel = that._createPanel( panelId );\n\t\t\t\t\tpanel.insertAfter( that.panels[ i - 1 ] || that.tablist );\n\t\t\t\t}\n\t\t\t\tpanel.attr( \"aria-live\", \"polite\" );\n\t\t\t}\n\n\t\t\tif ( panel.length ) {\n\t\t\t\tthat.panels = that.panels.add( panel );\n\t\t\t}\n\t\t\tif ( originalAriaControls ) {\n\t\t\t\ttab.data( \"ui-tabs-aria-controls\", originalAriaControls );\n\t\t\t}\n\t\t\ttab.attr( {\n\t\t\t\t\"aria-controls\": panelId,\n\t\t\t\t\"aria-labelledby\": anchorId\n\t\t\t} );\n\t\t\tpanel.attr( \"aria-labelledby\", anchorId );\n\t\t} );\n\n\t\tthis.panels.attr( \"role\", \"tabpanel\" );\n\t\tthis._addClass( this.panels, \"ui-tabs-panel\", \"ui-widget-content\" );\n\n\t\t// Avoid memory leaks (#10056)\n\t\tif ( prevTabs ) {\n\t\t\tthis._off( prevTabs.not( this.tabs ) );\n\t\t\tthis._off( prevAnchors.not( this.anchors ) );\n\t\t\tthis._off( prevPanels.not( this.panels ) );\n\t\t}\n\t},\n\n\t// Allow overriding how to find the list for rare usage scenarios (#7715)\n\t_getList: function() {\n\t\treturn this.tablist || this.element.find( \"ol, ul\" ).eq( 0 );\n\t},\n\n\t_createPanel: function( id ) {\n\t\treturn $( \"<div>\" )\n\t\t\t.attr( \"id\", id )\n\t\t\t.data( \"ui-tabs-destroy\", true );\n\t},\n\n\t_setOptionDisabled: function( disabled ) {\n\t\tvar currentItem, li, i;\n\n\t\tif ( Array.isArray( disabled ) ) {\n\t\t\tif ( !disabled.length ) {\n\t\t\t\tdisabled = false;\n\t\t\t} else if ( disabled.length === this.anchors.length ) {\n\t\t\t\tdisabled = true;\n\t\t\t}\n\t\t}\n\n\t\t// Disable tabs\n\t\tfor ( i = 0; ( li = this.tabs[ i ] ); i++ ) {\n\t\t\tcurrentItem = $( li );\n\t\t\tif ( disabled === true || $.inArray( i, disabled ) !== -1 ) {\n\t\t\t\tcurrentItem.attr( \"aria-disabled\", \"true\" );\n\t\t\t\tthis._addClass( currentItem, null, \"ui-state-disabled\" );\n\t\t\t} else {\n\t\t\t\tcurrentItem.removeAttr( \"aria-disabled\" );\n\t\t\t\tthis._removeClass( currentItem, null, \"ui-state-disabled\" );\n\t\t\t}\n\t\t}\n\n\t\tthis.options.disabled = disabled;\n\n\t\tthis._toggleClass( this.widget(), this.widgetFullName + \"-disabled\", null,\n\t\t\tdisabled === true );\n\t},\n\n\t_setupEvents: function( event ) {\n\t\tvar events = {};\n\t\tif ( event ) {\n\t\t\t$.each( event.split( \" \" ), function( index, eventName ) {\n\t\t\t\tevents[ eventName ] = \"_eventHandler\";\n\t\t\t} );\n\t\t}\n\n\t\tthis._off( this.anchors.add( this.tabs ).add( this.panels ) );\n\n\t\t// Always prevent the default action, even when disabled\n\t\tthis._on( true, this.anchors, {\n\t\t\tclick: function( event ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t}\n\t\t} );\n\t\tthis._on( this.anchors, events );\n\t\tthis._on( this.tabs, { keydown: \"_tabKeydown\" } );\n\t\tthis._on( this.panels, { keydown: \"_panelKeydown\" } );\n\n\t\tthis._focusable( this.tabs );\n\t\tthis._hoverable( this.tabs );\n\t},\n\n\t_setupHeightStyle: function( heightStyle ) {\n\t\tvar maxHeight,\n\t\t\tparent = this.element.parent();\n\n\t\tif ( heightStyle === \"fill\" ) {\n\t\t\tmaxHeight = parent.height();\n\t\t\tmaxHeight -= this.element.outerHeight() - this.element.height();\n\n\t\t\tthis.element.siblings( \":visible\" ).each( function() {\n\t\t\t\tvar elem = $( this ),\n\t\t\t\t\tposition = elem.css( \"position\" );\n\n\t\t\t\tif ( position === \"absolute\" || position === \"fixed\" ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tmaxHeight -= elem.outerHeight( true );\n\t\t\t} );\n\n\t\t\tthis.element.children().not( this.panels ).each( function() {\n\t\t\t\tmaxHeight -= $( this ).outerHeight( true );\n\t\t\t} );\n\n\t\t\tthis.panels.each( function() {\n\t\t\t\t$( this ).height( Math.max( 0, maxHeight -\n\t\t\t\t\t$( this ).innerHeight() + $( this ).height() ) );\n\t\t\t} )\n\t\t\t\t.css( \"overflow\", \"auto\" );\n\t\t} else if ( heightStyle === \"auto\" ) {\n\t\t\tmaxHeight = 0;\n\t\t\tthis.panels.each( function() {\n\t\t\t\tmaxHeight = Math.max( maxHeight, $( this ).height( \"\" ).height() );\n\t\t\t} ).height( maxHeight );\n\t\t}\n\t},\n\n\t_eventHandler: function( event ) {\n\t\tvar options = this.options,\n\t\t\tactive = this.active,\n\t\t\tanchor = $( event.currentTarget ),\n\t\t\ttab = anchor.closest( \"li\" ),\n\t\t\tclickedIsActive = tab[ 0 ] === active[ 0 ],\n\t\t\tcollapsing = clickedIsActive && options.collapsible,\n\t\t\ttoShow = collapsing ? $() : this._getPanelForTab( tab ),\n\t\t\ttoHide = !active.length ? $() : this._getPanelForTab( active ),\n\t\t\teventData = {\n\t\t\t\toldTab: active,\n\t\t\t\toldPanel: toHide,\n\t\t\t\tnewTab: collapsing ? $() : tab,\n\t\t\t\tnewPanel: toShow\n\t\t\t};\n\n\t\tevent.preventDefault();\n\n\t\tif ( tab.hasClass( \"ui-state-disabled\" ) ||\n\n\t\t\t\t// tab is already loading\n\t\t\t\ttab.hasClass( \"ui-tabs-loading\" ) ||\n\n\t\t\t\t// can't switch durning an animation\n\t\t\t\tthis.running ||\n\n\t\t\t\t// click on active header, but not collapsible\n\t\t\t\t( clickedIsActive && !options.collapsible ) ||\n\n\t\t\t\t// allow canceling activation\n\t\t\t\t( this._trigger( \"beforeActivate\", event, eventData ) === false ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\toptions.active = collapsing ? false : this.tabs.index( tab );\n\n\t\tthis.active = clickedIsActive ? $() : tab;\n\t\tif ( this.xhr ) {\n\t\t\tthis.xhr.abort();\n\t\t}\n\n\t\tif ( !toHide.length && !toShow.length ) {\n\t\t\t$.error( \"jQuery UI Tabs: Mismatching fragment identifier.\" );\n\t\t}\n\n\t\tif ( toShow.length ) {\n\t\t\tthis.load( this.tabs.index( tab ), event );\n\t\t}\n\t\tthis._toggle( event, eventData );\n\t},\n\n\t// Handles show/hide for selecting tabs\n\t_toggle: function( event, eventData ) {\n\t\tvar that = this,\n\t\t\ttoShow = eventData.newPanel,\n\t\t\ttoHide = eventData.oldPanel;\n\n\t\tthis.running = true;\n\n\t\tfunction complete() {\n\t\t\tthat.running = false;\n\t\t\tthat._trigger( \"activate\", event, eventData );\n\t\t}\n\n\t\tfunction show() {\n\t\t\tthat._addClass( eventData.newTab.closest( \"li\" ), \"ui-tabs-active\", \"ui-state-active\" );\n\n\t\t\tif ( toShow.length && that.options.show ) {\n\t\t\t\tthat._show( toShow, that.options.show, complete );\n\t\t\t} else {\n\t\t\t\ttoShow.show();\n\t\t\t\tcomplete();\n\t\t\t}\n\t\t}\n\n\t\t// Start out by hiding, then showing, then completing\n\t\tif ( toHide.length && this.options.hide ) {\n\t\t\tthis._hide( toHide, this.options.hide, function() {\n\t\t\t\tthat._removeClass( eventData.oldTab.closest( \"li\" ),\n\t\t\t\t\t\"ui-tabs-active\", \"ui-state-active\" );\n\t\t\t\tshow();\n\t\t\t} );\n\t\t} else {\n\t\t\tthis._removeClass( eventData.oldTab.closest( \"li\" ),\n\t\t\t\t\"ui-tabs-active\", \"ui-state-active\" );\n\t\t\ttoHide.hide();\n\t\t\tshow();\n\t\t}\n\n\t\ttoHide.attr( \"aria-hidden\", \"true\" );\n\t\teventData.oldTab.attr( {\n\t\t\t\"aria-selected\": \"false\",\n\t\t\t\"aria-expanded\": \"false\"\n\t\t} );\n\n\t\t// If we're switching tabs, remove the old tab from the tab order.\n\t\t// If we're opening from collapsed state, remove the previous tab from the tab order.\n\t\t// If we're collapsing, then keep the collapsing tab in the tab order.\n\t\tif ( toShow.length && toHide.length ) {\n\t\t\teventData.oldTab.attr( \"tabIndex\", -1 );\n\t\t} else if ( toShow.length ) {\n\t\t\tthis.tabs.filter( function() {\n\t\t\t\treturn $( this ).attr( \"tabIndex\" ) === 0;\n\t\t\t} )\n\t\t\t\t.attr( \"tabIndex\", -1 );\n\t\t}\n\n\t\ttoShow.attr( \"aria-hidden\", \"false\" );\n\t\teventData.newTab.attr( {\n\t\t\t\"aria-selected\": \"true\",\n\t\t\t\"aria-expanded\": \"true\",\n\t\t\ttabIndex: 0\n\t\t} );\n\t},\n\n\t_activate: function( index ) {\n\t\tvar anchor,\n\t\t\tactive = this._findActive( index );\n\n\t\t// Trying to activate the already active panel\n\t\tif ( active[ 0 ] === this.active[ 0 ] ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Trying to collapse, simulate a click on the current active header\n\t\tif ( !active.length ) {\n\t\t\tactive = this.active;\n\t\t}\n\n\t\tanchor = active.find( \".ui-tabs-anchor\" )[ 0 ];\n\t\tthis._eventHandler( {\n\t\t\ttarget: anchor,\n\t\t\tcurrentTarget: anchor,\n\t\t\tpreventDefault: $.noop\n\t\t} );\n\t},\n\n\t_findActive: function( index ) {\n\t\treturn index === false ? $() : this.tabs.eq( index );\n\t},\n\n\t_getIndex: function( index ) {\n\n\t\t// meta-function to give users option to provide a href string instead of a numerical index.\n\t\tif ( typeof index === \"string\" ) {\n\t\t\tindex = this.anchors.index( this.anchors.filter( \"[href$='\" +\n\t\t\t\t$.escapeSelector( index ) + \"']\" ) );\n\t\t}\n\n\t\treturn index;\n\t},\n\n\t_destroy: function() {\n\t\tif ( this.xhr ) {\n\t\t\tthis.xhr.abort();\n\t\t}\n\n\t\tthis.tablist\n\t\t\t.removeAttr( \"role\" )\n\t\t\t.off( this.eventNamespace );\n\n\t\tthis.anchors\n\t\t\t.removeAttr( \"role tabIndex\" )\n\t\t\t.removeUniqueId();\n\n\t\tthis.tabs.add( this.panels ).each( function() {\n\t\t\tif ( $.data( this, \"ui-tabs-destroy\" ) ) {\n\t\t\t\t$( this ).remove();\n\t\t\t} else {\n\t\t\t\t$( this ).removeAttr( \"role tabIndex \" +\n\t\t\t\t\t\"aria-live aria-busy aria-selected aria-labelledby aria-hidden aria-expanded\" );\n\t\t\t}\n\t\t} );\n\n\t\tthis.tabs.each( function() {\n\t\t\tvar li = $( this ),\n\t\t\t\tprev = li.data( \"ui-tabs-aria-controls\" );\n\t\t\tif ( prev ) {\n\t\t\t\tli\n\t\t\t\t\t.attr( \"aria-controls\", prev )\n\t\t\t\t\t.removeData( \"ui-tabs-aria-controls\" );\n\t\t\t} else {\n\t\t\t\tli.removeAttr( \"aria-controls\" );\n\t\t\t}\n\t\t} );\n\n\t\tthis.panels.show();\n\n\t\tif ( this.options.heightStyle !== \"content\" ) {\n\t\t\tthis.panels.css( \"height\", \"\" );\n\t\t}\n\t},\n\n\tenable: function( index ) {\n\t\tvar disabled = this.options.disabled;\n\t\tif ( disabled === false ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( index === undefined ) {\n\t\t\tdisabled = false;\n\t\t} else {\n\t\t\tindex = this._getIndex( index );\n\t\t\tif ( Array.isArray( disabled ) ) {\n\t\t\t\tdisabled = $.map( disabled, function( num ) {\n\t\t\t\t\treturn num !== index ? num : null;\n\t\t\t\t} );\n\t\t\t} else {\n\t\t\t\tdisabled = $.map( this.tabs, function( li, num ) {\n\t\t\t\t\treturn num !== index ? num : null;\n\t\t\t\t} );\n\t\t\t}\n\t\t}\n\t\tthis._setOptionDisabled( disabled );\n\t},\n\n\tdisable: function( index ) {\n\t\tvar disabled = this.options.disabled;\n\t\tif ( disabled === true ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( index === undefined ) {\n\t\t\tdisabled = true;\n\t\t} else {\n\t\t\tindex = this._getIndex( index );\n\t\t\tif ( $.inArray( index, disabled ) !== -1 ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tif ( Array.isArray( disabled ) ) {\n\t\t\t\tdisabled = $.merge( [ index ], disabled ).sort();\n\t\t\t} else {\n\t\t\t\tdisabled = [ index ];\n\t\t\t}\n\t\t}\n\t\tthis._setOptionDisabled( disabled );\n\t},\n\n\tload: function( index, event ) {\n\t\tindex = this._getIndex( index );\n\t\tvar that = this,\n\t\t\ttab = this.tabs.eq( index ),\n\t\t\tanchor = tab.find( \".ui-tabs-anchor\" ),\n\t\t\tpanel = this._getPanelForTab( tab ),\n\t\t\teventData = {\n\t\t\t\ttab: tab,\n\t\t\t\tpanel: panel\n\t\t\t},\n\t\t\tcomplete = function( jqXHR, status ) {\n\t\t\t\tif ( status === \"abort\" ) {\n\t\t\t\t\tthat.panels.stop( false, true );\n\t\t\t\t}\n\n\t\t\t\tthat._removeClass( tab, \"ui-tabs-loading\" );\n\t\t\t\tpanel.removeAttr( \"aria-busy\" );\n\n\t\t\t\tif ( jqXHR === that.xhr ) {\n\t\t\t\t\tdelete that.xhr;\n\t\t\t\t}\n\t\t\t};\n\n\t\t// Not remote\n\t\tif ( this._isLocal( anchor[ 0 ] ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.xhr = $.ajax( this._ajaxSettings( anchor, event, eventData ) );\n\n\t\t// Support: jQuery <1.8\n\t\t// jQuery <1.8 returns false if the request is canceled in beforeSend,\n\t\t// but as of 1.8, $.ajax() always returns a jqXHR object.\n\t\tif ( this.xhr && this.xhr.statusText !== \"canceled\" ) {\n\t\t\tthis._addClass( tab, \"ui-tabs-loading\" );\n\t\t\tpanel.attr( \"aria-busy\", \"true\" );\n\n\t\t\tthis.xhr\n\t\t\t\t.done( function( response, status, jqXHR ) {\n\n\t\t\t\t\t// support: jQuery <1.8\n\t\t\t\t\t// http://bugs.jquery.com/ticket/11778\n\t\t\t\t\tsetTimeout( function() {\n\t\t\t\t\t\tpanel.html( response );\n\t\t\t\t\t\tthat._trigger( \"load\", event, eventData );\n\n\t\t\t\t\t\tcomplete( jqXHR, status );\n\t\t\t\t\t}, 1 );\n\t\t\t\t} )\n\t\t\t\t.fail( function( jqXHR, status ) {\n\n\t\t\t\t\t// support: jQuery <1.8\n\t\t\t\t\t// http://bugs.jquery.com/ticket/11778\n\t\t\t\t\tsetTimeout( function() {\n\t\t\t\t\t\tcomplete( jqXHR, status );\n\t\t\t\t\t}, 1 );\n\t\t\t\t} );\n\t\t}\n\t},\n\n\t_ajaxSettings: function( anchor, event, eventData ) {\n\t\tvar that = this;\n\t\treturn {\n\n\t\t\t// Support: IE <11 only\n\t\t\t// Strip any hash that exists to prevent errors with the Ajax request\n\t\t\turl: anchor.attr( \"href\" ).replace( /#.*$/, \"\" ),\n\t\t\tbeforeSend: function( jqXHR, settings ) {\n\t\t\t\treturn that._trigger( \"beforeLoad\", event,\n\t\t\t\t\t$.extend( { jqXHR: jqXHR, ajaxSettings: settings }, eventData ) );\n\t\t\t}\n\t\t};\n\t},\n\n\t_getPanelForTab: function( tab ) {\n\t\tvar id = $( tab ).attr( \"aria-controls\" );\n\t\treturn this.element.find( this._sanitizeSelector( \"#\" + id ) );\n\t}\n} );\n\n// DEPRECATED\n// TODO: Switch return back to widget declaration at top of file when this is removed\nif ( $.uiBackCompat !== false ) {\n\n\t// Backcompat for ui-tab class (now ui-tabs-tab)\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\t_processTabs: function() {\n\t\t\tthis._superApply( arguments );\n\t\t\tthis._addClass( this.tabs, \"ui-tab\" );\n\t\t}\n\t} );\n}\n\nreturn $.ui.tabs;\n\n} );\n","jquery/ui-modules/widgets/mouse.js":"/*!\n * jQuery UI Mouse 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Mouse\n//>>group: Widgets\n//>>description: Abstracts mouse-based interactions to assist in creating certain widgets.\n//>>docs: http://api.jqueryui.com/mouse/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../ie\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nvar mouseHandled = false;\n$( document ).on( \"mouseup\", function() {\n\tmouseHandled = false;\n} );\n\nreturn $.widget( \"ui.mouse\", {\n\tversion: \"1.13.1\",\n\toptions: {\n\t\tcancel: \"input, textarea, button, select, option\",\n\t\tdistance: 1,\n\t\tdelay: 0\n\t},\n\t_mouseInit: function() {\n\t\tvar that = this;\n\n\t\tthis.element\n\t\t\t.on( \"mousedown.\" + this.widgetName, function( event ) {\n\t\t\t\treturn that._mouseDown( event );\n\t\t\t} )\n\t\t\t.on( \"click.\" + this.widgetName, function( event ) {\n\t\t\t\tif ( true === $.data( event.target, that.widgetName + \".preventClickEvent\" ) ) {\n\t\t\t\t\t$.removeData( event.target, that.widgetName + \".preventClickEvent\" );\n\t\t\t\t\tevent.stopImmediatePropagation();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t} );\n\n\t\tthis.started = false;\n\t},\n\n\t// TODO: make sure destroying one instance of mouse doesn't mess with\n\t// other instances of mouse\n\t_mouseDestroy: function() {\n\t\tthis.element.off( \".\" + this.widgetName );\n\t\tif ( this._mouseMoveDelegate ) {\n\t\t\tthis.document\n\t\t\t\t.off( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n\t\t\t\t.off( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n\t\t}\n\t},\n\n\t_mouseDown: function( event ) {\n\n\t\t// don't let more than one widget handle mouseStart\n\t\tif ( mouseHandled ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis._mouseMoved = false;\n\n\t\t// We may have missed mouseup (out of window)\n\t\tif ( this._mouseStarted ) {\n\t\t\tthis._mouseUp( event );\n\t\t}\n\n\t\tthis._mouseDownEvent = event;\n\n\t\tvar that = this,\n\t\t\tbtnIsLeft = ( event.which === 1 ),\n\n\t\t\t// event.target.nodeName works around a bug in IE 8 with\n\t\t\t// disabled inputs (#7620)\n\t\t\telIsCancel = ( typeof this.options.cancel === \"string\" && event.target.nodeName ?\n\t\t\t\t$( event.target ).closest( this.options.cancel ).length : false );\n\t\tif ( !btnIsLeft || elIsCancel || !this._mouseCapture( event ) ) {\n\t\t\treturn true;\n\t\t}\n\n\t\tthis.mouseDelayMet = !this.options.delay;\n\t\tif ( !this.mouseDelayMet ) {\n\t\t\tthis._mouseDelayTimer = setTimeout( function() {\n\t\t\t\tthat.mouseDelayMet = true;\n\t\t\t}, this.options.delay );\n\t\t}\n\n\t\tif ( this._mouseDistanceMet( event ) && this._mouseDelayMet( event ) ) {\n\t\t\tthis._mouseStarted = ( this._mouseStart( event ) !== false );\n\t\t\tif ( !this._mouseStarted ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\n\t\t// Click event may never have fired (Gecko & Opera)\n\t\tif ( true === $.data( event.target, this.widgetName + \".preventClickEvent\" ) ) {\n\t\t\t$.removeData( event.target, this.widgetName + \".preventClickEvent\" );\n\t\t}\n\n\t\t// These delegates are required to keep context\n\t\tthis._mouseMoveDelegate = function( event ) {\n\t\t\treturn that._mouseMove( event );\n\t\t};\n\t\tthis._mouseUpDelegate = function( event ) {\n\t\t\treturn that._mouseUp( event );\n\t\t};\n\n\t\tthis.document\n\t\t\t.on( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n\t\t\t.on( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n\n\t\tevent.preventDefault();\n\n\t\tmouseHandled = true;\n\t\treturn true;\n\t},\n\n\t_mouseMove: function( event ) {\n\n\t\t// Only check for mouseups outside the document if you've moved inside the document\n\t\t// at least once. This prevents the firing of mouseup in the case of IE<9, which will\n\t\t// fire a mousemove event if content is placed under the cursor. See #7778\n\t\t// Support: IE <9\n\t\tif ( this._mouseMoved ) {\n\n\t\t\t// IE mouseup check - mouseup happened when mouse was out of window\n\t\t\tif ( $.ui.ie && ( !document.documentMode || document.documentMode < 9 ) &&\n\t\t\t\t\t!event.button ) {\n\t\t\t\treturn this._mouseUp( event );\n\n\t\t\t// Iframe mouseup check - mouseup occurred in another document\n\t\t\t} else if ( !event.which ) {\n\n\t\t\t\t// Support: Safari <=8 - 9\n\t\t\t\t// Safari sets which to 0 if you press any of the following keys\n\t\t\t\t// during a drag (#14461)\n\t\t\t\tif ( event.originalEvent.altKey || event.originalEvent.ctrlKey ||\n\t\t\t\t\t\tevent.originalEvent.metaKey || event.originalEvent.shiftKey ) {\n\t\t\t\t\tthis.ignoreMissingWhich = true;\n\t\t\t\t} else if ( !this.ignoreMissingWhich ) {\n\t\t\t\t\treturn this._mouseUp( event );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif ( event.which || event.button ) {\n\t\t\tthis._mouseMoved = true;\n\t\t}\n\n\t\tif ( this._mouseStarted ) {\n\t\t\tthis._mouseDrag( event );\n\t\t\treturn event.preventDefault();\n\t\t}\n\n\t\tif ( this._mouseDistanceMet( event ) && this._mouseDelayMet( event ) ) {\n\t\t\tthis._mouseStarted =\n\t\t\t\t( this._mouseStart( this._mouseDownEvent, event ) !== false );\n\t\t\tif ( this._mouseStarted ) {\n\t\t\t\tthis._mouseDrag( event );\n\t\t\t} else {\n\t\t\t\tthis._mouseUp( event );\n\t\t\t}\n\t\t}\n\n\t\treturn !this._mouseStarted;\n\t},\n\n\t_mouseUp: function( event ) {\n\t\tthis.document\n\t\t\t.off( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n\t\t\t.off( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n\n\t\tif ( this._mouseStarted ) {\n\t\t\tthis._mouseStarted = false;\n\n\t\t\tif ( event.target === this._mouseDownEvent.target ) {\n\t\t\t\t$.data( event.target, this.widgetName + \".preventClickEvent\", true );\n\t\t\t}\n\n\t\t\tthis._mouseStop( event );\n\t\t}\n\n\t\tif ( this._mouseDelayTimer ) {\n\t\t\tclearTimeout( this._mouseDelayTimer );\n\t\t\tdelete this._mouseDelayTimer;\n\t\t}\n\n\t\tthis.ignoreMissingWhich = false;\n\t\tmouseHandled = false;\n\t\tevent.preventDefault();\n\t},\n\n\t_mouseDistanceMet: function( event ) {\n\t\treturn ( Math.max(\n\t\t\t\tMath.abs( this._mouseDownEvent.pageX - event.pageX ),\n\t\t\t\tMath.abs( this._mouseDownEvent.pageY - event.pageY )\n\t\t\t) >= this.options.distance\n\t\t);\n\t},\n\n\t_mouseDelayMet: function( /* event */ ) {\n\t\treturn this.mouseDelayMet;\n\t},\n\n\t// These are placeholder methods, to be overriden by extending plugin\n\t_mouseStart: function( /* event */ ) {},\n\t_mouseDrag: function( /* event */ ) {},\n\t_mouseStop: function( /* event */ ) {},\n\t_mouseCapture: function( /* event */ ) {\n\t\treturn true;\n\t}\n} );\n\n} );\n","jquery/ui-modules/widgets/autocomplete.js":"/*!\n * jQuery UI Autocomplete 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Autocomplete\n//>>group: Widgets\n//>>description: Lists suggested words as the user is typing.\n//>>docs: http://api.jqueryui.com/autocomplete/\n//>>demos: http://jqueryui.com/autocomplete/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/autocomplete.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./menu\",\n\t\t\t\"../keycode\",\n\t\t\t\"../position\",\n\t\t\t\"../safe-active-element\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.autocomplete\", {\n\tversion: \"1.13.1\",\n\tdefaultElement: \"<input>\",\n\toptions: {\n\t\tappendTo: null,\n\t\tautoFocus: false,\n\t\tdelay: 300,\n\t\tminLength: 1,\n\t\tposition: {\n\t\t\tmy: \"left top\",\n\t\t\tat: \"left bottom\",\n\t\t\tcollision: \"none\"\n\t\t},\n\t\tsource: null,\n\n\t\t// Callbacks\n\t\tchange: null,\n\t\tclose: null,\n\t\tfocus: null,\n\t\topen: null,\n\t\tresponse: null,\n\t\tsearch: null,\n\t\tselect: null\n\t},\n\n\trequestIndex: 0,\n\tpending: 0,\n\tliveRegionTimer: null,\n\n\t_create: function() {\n\n\t\t// Some browsers only repeat keydown events, not keypress events,\n\t\t// so we use the suppressKeyPress flag to determine if we've already\n\t\t// handled the keydown event. #7269\n\t\t// Unfortunately the code for & in keypress is the same as the up arrow,\n\t\t// so we use the suppressKeyPressRepeat flag to avoid handling keypress\n\t\t// events when we know the keydown event was used to modify the\n\t\t// search term. #7799\n\t\tvar suppressKeyPress, suppressKeyPressRepeat, suppressInput,\n\t\t\tnodeName = this.element[ 0 ].nodeName.toLowerCase(),\n\t\t\tisTextarea = nodeName === \"textarea\",\n\t\t\tisInput = nodeName === \"input\";\n\n\t\t// Textareas are always multi-line\n\t\t// Inputs are always single-line, even if inside a contentEditable element\n\t\t// IE also treats inputs as contentEditable\n\t\t// All other element types are determined by whether or not they're contentEditable\n\t\tthis.isMultiLine = isTextarea || !isInput && this._isContentEditable( this.element );\n\n\t\tthis.valueMethod = this.element[ isTextarea || isInput ? \"val\" : \"text\" ];\n\t\tthis.isNewMenu = true;\n\n\t\tthis._addClass( \"ui-autocomplete-input\" );\n\t\tthis.element.attr( \"autocomplete\", \"off\" );\n\n\t\tthis._on( this.element, {\n\t\t\tkeydown: function( event ) {\n\t\t\t\tif ( this.element.prop( \"readOnly\" ) ) {\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tsuppressInput = true;\n\t\t\t\t\tsuppressKeyPressRepeat = true;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tsuppressKeyPress = false;\n\t\t\t\tsuppressInput = false;\n\t\t\t\tsuppressKeyPressRepeat = false;\n\t\t\t\tvar keyCode = $.ui.keyCode;\n\t\t\t\tswitch ( event.keyCode ) {\n\t\t\t\tcase keyCode.PAGE_UP:\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tthis._move( \"previousPage\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.PAGE_DOWN:\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tthis._move( \"nextPage\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.UP:\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tthis._keyEvent( \"previous\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.DOWN:\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tthis._keyEvent( \"next\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.ENTER:\n\n\t\t\t\t\t// when menu is open and has focus\n\t\t\t\t\tif ( this.menu.active ) {\n\n\t\t\t\t\t\t// #6055 - Opera still allows the keypress to occur\n\t\t\t\t\t\t// which causes forms to submit\n\t\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\tthis.menu.select( event );\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.TAB:\n\t\t\t\t\tif ( this.menu.active ) {\n\t\t\t\t\t\tthis.menu.select( event );\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.ESCAPE:\n\t\t\t\t\tif ( this.menu.element.is( \":visible\" ) ) {\n\t\t\t\t\t\tif ( !this.isMultiLine ) {\n\t\t\t\t\t\t\tthis._value( this.term );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tthis.close( event );\n\n\t\t\t\t\t\t// Different browsers have different default behavior for escape\n\t\t\t\t\t\t// Single press can mean undo or clear\n\t\t\t\t\t\t// Double press in IE means clear the whole form\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tdefault:\n\t\t\t\t\tsuppressKeyPressRepeat = true;\n\n\t\t\t\t\t// search timeout should be triggered before the input value is changed\n\t\t\t\t\tthis._searchTimeout( event );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t},\n\t\t\tkeypress: function( event ) {\n\t\t\t\tif ( suppressKeyPress ) {\n\t\t\t\t\tsuppressKeyPress = false;\n\t\t\t\t\tif ( !this.isMultiLine || this.menu.element.is( \":visible\" ) ) {\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tif ( suppressKeyPressRepeat ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Replicate some key handlers to allow them to repeat in Firefox and Opera\n\t\t\t\tvar keyCode = $.ui.keyCode;\n\t\t\t\tswitch ( event.keyCode ) {\n\t\t\t\tcase keyCode.PAGE_UP:\n\t\t\t\t\tthis._move( \"previousPage\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.PAGE_DOWN:\n\t\t\t\t\tthis._move( \"nextPage\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.UP:\n\t\t\t\t\tthis._keyEvent( \"previous\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.DOWN:\n\t\t\t\t\tthis._keyEvent( \"next\", event );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t},\n\t\t\tinput: function( event ) {\n\t\t\t\tif ( suppressInput ) {\n\t\t\t\t\tsuppressInput = false;\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tthis._searchTimeout( event );\n\t\t\t},\n\t\t\tfocus: function() {\n\t\t\t\tthis.selectedItem = null;\n\t\t\t\tthis.previous = this._value();\n\t\t\t},\n\t\t\tblur: function( event ) {\n\t\t\t\tclearTimeout( this.searching );\n\t\t\t\tthis.close( event );\n\t\t\t\tthis._change( event );\n\t\t\t}\n\t\t} );\n\n\t\tthis._initSource();\n\t\tthis.menu = $( \"<ul>\" )\n\t\t\t.appendTo( this._appendTo() )\n\t\t\t.menu( {\n\n\t\t\t\t// disable ARIA support, the live region takes care of that\n\t\t\t\trole: null\n\t\t\t} )\n\t\t\t.hide()\n\n\t\t\t// Support: IE 11 only, Edge <= 14\n\t\t\t// For other browsers, we preventDefault() on the mousedown event\n\t\t\t// to keep the dropdown from taking focus from the input. This doesn't\n\t\t\t// work for IE/Edge, causing problems with selection and scrolling (#9638)\n\t\t\t// Happily, IE and Edge support an \"unselectable\" attribute that\n\t\t\t// prevents an element from receiving focus, exactly what we want here.\n\t\t\t.attr( {\n\t\t\t\t\"unselectable\": \"on\"\n\t\t\t} )\n\t\t\t.menu( \"instance\" );\n\n\t\tthis._addClass( this.menu.element, \"ui-autocomplete\", \"ui-front\" );\n\t\tthis._on( this.menu.element, {\n\t\t\tmousedown: function( event ) {\n\n\t\t\t\t// Prevent moving focus out of the text field\n\t\t\t\tevent.preventDefault();\n\t\t\t},\n\t\t\tmenufocus: function( event, ui ) {\n\t\t\t\tvar label, item;\n\n\t\t\t\t// support: Firefox\n\t\t\t\t// Prevent accidental activation of menu items in Firefox (#7024 #9118)\n\t\t\t\tif ( this.isNewMenu ) {\n\t\t\t\t\tthis.isNewMenu = false;\n\t\t\t\t\tif ( event.originalEvent && /^mouse/.test( event.originalEvent.type ) ) {\n\t\t\t\t\t\tthis.menu.blur();\n\n\t\t\t\t\t\tthis.document.one( \"mousemove\", function() {\n\t\t\t\t\t\t\t$( event.target ).trigger( event.originalEvent );\n\t\t\t\t\t\t} );\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\titem = ui.item.data( \"ui-autocomplete-item\" );\n\t\t\t\tif ( false !== this._trigger( \"focus\", event, { item: item } ) ) {\n\n\t\t\t\t\t// use value to match what will end up in the input, if it was a key event\n\t\t\t\t\tif ( event.originalEvent && /^key/.test( event.originalEvent.type ) ) {\n\t\t\t\t\t\tthis._value( item.value );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Announce the value in the liveRegion\n\t\t\t\tlabel = ui.item.attr( \"aria-label\" ) || item.value;\n\t\t\t\tif ( label && String.prototype.trim.call( label ).length ) {\n\t\t\t\t\tclearTimeout( this.liveRegionTimer );\n\t\t\t\t\tthis.liveRegionTimer = this._delay( function() {\n\t\t\t\t\t\tthis.liveRegion.html( $( \"<div>\" ).text( label ) );\n\t\t\t\t\t}, 100 );\n\t\t\t\t}\n\t\t\t},\n\t\t\tmenuselect: function( event, ui ) {\n\t\t\t\tvar item = ui.item.data( \"ui-autocomplete-item\" ),\n\t\t\t\t\tprevious = this.previous;\n\n\t\t\t\t// Only trigger when focus was lost (click on menu)\n\t\t\t\tif ( this.element[ 0 ] !== $.ui.safeActiveElement( this.document[ 0 ] ) ) {\n\t\t\t\t\tthis.element.trigger( \"focus\" );\n\t\t\t\t\tthis.previous = previous;\n\n\t\t\t\t\t// #6109 - IE triggers two focus events and the second\n\t\t\t\t\t// is asynchronous, so we need to reset the previous\n\t\t\t\t\t// term synchronously and asynchronously :-(\n\t\t\t\t\tthis._delay( function() {\n\t\t\t\t\t\tthis.previous = previous;\n\t\t\t\t\t\tthis.selectedItem = item;\n\t\t\t\t\t} );\n\t\t\t\t}\n\n\t\t\t\tif ( false !== this._trigger( \"select\", event, { item: item } ) ) {\n\t\t\t\t\tthis._value( item.value );\n\t\t\t\t}\n\n\t\t\t\t// reset the term after the select event\n\t\t\t\t// this allows custom select handling to work properly\n\t\t\t\tthis.term = this._value();\n\n\t\t\t\tthis.close( event );\n\t\t\t\tthis.selectedItem = item;\n\t\t\t}\n\t\t} );\n\n\t\tthis.liveRegion = $( \"<div>\", {\n\t\t\trole: \"status\",\n\t\t\t\"aria-live\": \"assertive\",\n\t\t\t\"aria-relevant\": \"additions\"\n\t\t} )\n\t\t\t.appendTo( this.document[ 0 ].body );\n\n\t\tthis._addClass( this.liveRegion, null, \"ui-helper-hidden-accessible\" );\n\n\t\t// Turning off autocomplete prevents the browser from remembering the\n\t\t// value when navigating through history, so we re-enable autocomplete\n\t\t// if the page is unloaded before the widget is destroyed. #7790\n\t\tthis._on( this.window, {\n\t\t\tbeforeunload: function() {\n\t\t\t\tthis.element.removeAttr( \"autocomplete\" );\n\t\t\t}\n\t\t} );\n\t},\n\n\t_destroy: function() {\n\t\tclearTimeout( this.searching );\n\t\tthis.element.removeAttr( \"autocomplete\" );\n\t\tthis.menu.element.remove();\n\t\tthis.liveRegion.remove();\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tthis._super( key, value );\n\t\tif ( key === \"source\" ) {\n\t\t\tthis._initSource();\n\t\t}\n\t\tif ( key === \"appendTo\" ) {\n\t\t\tthis.menu.element.appendTo( this._appendTo() );\n\t\t}\n\t\tif ( key === \"disabled\" && value && this.xhr ) {\n\t\t\tthis.xhr.abort();\n\t\t}\n\t},\n\n\t_isEventTargetInWidget: function( event ) {\n\t\tvar menuElement = this.menu.element[ 0 ];\n\n\t\treturn event.target === this.element[ 0 ] ||\n\t\t\tevent.target === menuElement ||\n\t\t\t$.contains( menuElement, event.target );\n\t},\n\n\t_closeOnClickOutside: function( event ) {\n\t\tif ( !this._isEventTargetInWidget( event ) ) {\n\t\t\tthis.close();\n\t\t}\n\t},\n\n\t_appendTo: function() {\n\t\tvar element = this.options.appendTo;\n\n\t\tif ( element ) {\n\t\t\telement = element.jquery || element.nodeType ?\n\t\t\t\t$( element ) :\n\t\t\t\tthis.document.find( element ).eq( 0 );\n\t\t}\n\n\t\tif ( !element || !element[ 0 ] ) {\n\t\t\telement = this.element.closest( \".ui-front, dialog\" );\n\t\t}\n\n\t\tif ( !element.length ) {\n\t\t\telement = this.document[ 0 ].body;\n\t\t}\n\n\t\treturn element;\n\t},\n\n\t_initSource: function() {\n\t\tvar array, url,\n\t\t\tthat = this;\n\t\tif ( Array.isArray( this.options.source ) ) {\n\t\t\tarray = this.options.source;\n\t\t\tthis.source = function( request, response ) {\n\t\t\t\tresponse( $.ui.autocomplete.filter( array, request.term ) );\n\t\t\t};\n\t\t} else if ( typeof this.options.source === \"string\" ) {\n\t\t\turl = this.options.source;\n\t\t\tthis.source = function( request, response ) {\n\t\t\t\tif ( that.xhr ) {\n\t\t\t\t\tthat.xhr.abort();\n\t\t\t\t}\n\t\t\t\tthat.xhr = $.ajax( {\n\t\t\t\t\turl: url,\n\t\t\t\t\tdata: request,\n\t\t\t\t\tdataType: \"json\",\n\t\t\t\t\tsuccess: function( data ) {\n\t\t\t\t\t\tresponse( data );\n\t\t\t\t\t},\n\t\t\t\t\terror: function() {\n\t\t\t\t\t\tresponse( [] );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t};\n\t\t} else {\n\t\t\tthis.source = this.options.source;\n\t\t}\n\t},\n\n\t_searchTimeout: function( event ) {\n\t\tclearTimeout( this.searching );\n\t\tthis.searching = this._delay( function() {\n\n\t\t\t// Search if the value has changed, or if the user retypes the same value (see #7434)\n\t\t\tvar equalValues = this.term === this._value(),\n\t\t\t\tmenuVisible = this.menu.element.is( \":visible\" ),\n\t\t\t\tmodifierKey = event.altKey || event.ctrlKey || event.metaKey || event.shiftKey;\n\n\t\t\tif ( !equalValues || ( equalValues && !menuVisible && !modifierKey ) ) {\n\t\t\t\tthis.selectedItem = null;\n\t\t\t\tthis.search( null, event );\n\t\t\t}\n\t\t}, this.options.delay );\n\t},\n\n\tsearch: function( value, event ) {\n\t\tvalue = value != null ? value : this._value();\n\n\t\t// Always save the actual value, not the one passed as an argument\n\t\tthis.term = this._value();\n\n\t\tif ( value.length < this.options.minLength ) {\n\t\t\treturn this.close( event );\n\t\t}\n\n\t\tif ( this._trigger( \"search\", event ) === false ) {\n\t\t\treturn;\n\t\t}\n\n\t\treturn this._search( value );\n\t},\n\n\t_search: function( value ) {\n\t\tthis.pending++;\n\t\tthis._addClass( \"ui-autocomplete-loading\" );\n\t\tthis.cancelSearch = false;\n\n\t\tthis.source( { term: value }, this._response() );\n\t},\n\n\t_response: function() {\n\t\tvar index = ++this.requestIndex;\n\n\t\treturn function( content ) {\n\t\t\tif ( index === this.requestIndex ) {\n\t\t\t\tthis.__response( content );\n\t\t\t}\n\n\t\t\tthis.pending--;\n\t\t\tif ( !this.pending ) {\n\t\t\t\tthis._removeClass( \"ui-autocomplete-loading\" );\n\t\t\t}\n\t\t}.bind( this );\n\t},\n\n\t__response: function( content ) {\n\t\tif ( content ) {\n\t\t\tcontent = this._normalize( content );\n\t\t}\n\t\tthis._trigger( \"response\", null, { content: content } );\n\t\tif ( !this.options.disabled && content && content.length && !this.cancelSearch ) {\n\t\t\tthis._suggest( content );\n\t\t\tthis._trigger( \"open\" );\n\t\t} else {\n\n\t\t\t// use ._close() instead of .close() so we don't cancel future searches\n\t\t\tthis._close();\n\t\t}\n\t},\n\n\tclose: function( event ) {\n\t\tthis.cancelSearch = true;\n\t\tthis._close( event );\n\t},\n\n\t_close: function( event ) {\n\n\t\t// Remove the handler that closes the menu on outside clicks\n\t\tthis._off( this.document, \"mousedown\" );\n\n\t\tif ( this.menu.element.is( \":visible\" ) ) {\n\t\t\tthis.menu.element.hide();\n\t\t\tthis.menu.blur();\n\t\t\tthis.isNewMenu = true;\n\t\t\tthis._trigger( \"close\", event );\n\t\t}\n\t},\n\n\t_change: function( event ) {\n\t\tif ( this.previous !== this._value() ) {\n\t\t\tthis._trigger( \"change\", event, { item: this.selectedItem } );\n\t\t}\n\t},\n\n\t_normalize: function( items ) {\n\n\t\t// assume all items have the right format when the first item is complete\n\t\tif ( items.length && items[ 0 ].label && items[ 0 ].value ) {\n\t\t\treturn items;\n\t\t}\n\t\treturn $.map( items, function( item ) {\n\t\t\tif ( typeof item === \"string\" ) {\n\t\t\t\treturn {\n\t\t\t\t\tlabel: item,\n\t\t\t\t\tvalue: item\n\t\t\t\t};\n\t\t\t}\n\t\t\treturn $.extend( {}, item, {\n\t\t\t\tlabel: item.label || item.value,\n\t\t\t\tvalue: item.value || item.label\n\t\t\t} );\n\t\t} );\n\t},\n\n\t_suggest: function( items ) {\n\t\tvar ul = this.menu.element.empty();\n\t\tthis._renderMenu( ul, items );\n\t\tthis.isNewMenu = true;\n\t\tthis.menu.refresh();\n\n\t\t// Size and position menu\n\t\tul.show();\n\t\tthis._resizeMenu();\n\t\tul.position( $.extend( {\n\t\t\tof: this.element\n\t\t}, this.options.position ) );\n\n\t\tif ( this.options.autoFocus ) {\n\t\t\tthis.menu.next();\n\t\t}\n\n\t\t// Listen for interactions outside of the widget (#6642)\n\t\tthis._on( this.document, {\n\t\t\tmousedown: \"_closeOnClickOutside\"\n\t\t} );\n\t},\n\n\t_resizeMenu: function() {\n\t\tvar ul = this.menu.element;\n\t\tul.outerWidth( Math.max(\n\n\t\t\t// Firefox wraps long text (possibly a rounding bug)\n\t\t\t// so we add 1px to avoid the wrapping (#7513)\n\t\t\tul.width( \"\" ).outerWidth() + 1,\n\t\t\tthis.element.outerWidth()\n\t\t) );\n\t},\n\n\t_renderMenu: function( ul, items ) {\n\t\tvar that = this;\n\t\t$.each( items, function( index, item ) {\n\t\t\tthat._renderItemData( ul, item );\n\t\t} );\n\t},\n\n\t_renderItemData: function( ul, item ) {\n\t\treturn this._renderItem( ul, item ).data( \"ui-autocomplete-item\", item );\n\t},\n\n\t_renderItem: function( ul, item ) {\n\t\treturn $( \"<li>\" )\n\t\t\t.append( $( \"<div>\" ).text( item.label ) )\n\t\t\t.appendTo( ul );\n\t},\n\n\t_move: function( direction, event ) {\n\t\tif ( !this.menu.element.is( \":visible\" ) ) {\n\t\t\tthis.search( null, event );\n\t\t\treturn;\n\t\t}\n\t\tif ( this.menu.isFirstItem() && /^previous/.test( direction ) ||\n\t\t\t\tthis.menu.isLastItem() && /^next/.test( direction ) ) {\n\n\t\t\tif ( !this.isMultiLine ) {\n\t\t\t\tthis._value( this.term );\n\t\t\t}\n\n\t\t\tthis.menu.blur();\n\t\t\treturn;\n\t\t}\n\t\tthis.menu[ direction ]( event );\n\t},\n\n\twidget: function() {\n\t\treturn this.menu.element;\n\t},\n\n\t_value: function() {\n\t\treturn this.valueMethod.apply( this.element, arguments );\n\t},\n\n\t_keyEvent: function( keyEvent, event ) {\n\t\tif ( !this.isMultiLine || this.menu.element.is( \":visible\" ) ) {\n\t\t\tthis._move( keyEvent, event );\n\n\t\t\t// Prevents moving cursor to beginning/end of the text field in some browsers\n\t\t\tevent.preventDefault();\n\t\t}\n\t},\n\n\t// Support: Chrome <=50\n\t// We should be able to just use this.element.prop( \"isContentEditable\" )\n\t// but hidden elements always report false in Chrome.\n\t// https://code.google.com/p/chromium/issues/detail?id=313082\n\t_isContentEditable: function( element ) {\n\t\tif ( !element.length ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tvar editable = element.prop( \"contentEditable\" );\n\n\t\tif ( editable === \"inherit\" ) {\n\t\t\treturn this._isContentEditable( element.parent() );\n\t\t}\n\n\t\treturn editable === \"true\";\n\t}\n} );\n\n$.extend( $.ui.autocomplete, {\n\tescapeRegex: function( value ) {\n\t\treturn value.replace( /[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, \"\\\\$&\" );\n\t},\n\tfilter: function( array, term ) {\n\t\tvar matcher = new RegExp( $.ui.autocomplete.escapeRegex( term ), \"i\" );\n\t\treturn $.grep( array, function( value ) {\n\t\t\treturn matcher.test( value.label || value.value || value );\n\t\t} );\n\t}\n} );\n\n// Live region extension, adding a `messages` option\n// NOTE: This is an experimental API. We are still investigating\n// a full solution for string manipulation and internationalization.\n$.widget( \"ui.autocomplete\", $.ui.autocomplete, {\n\toptions: {\n\t\tmessages: {\n\t\t\tnoResults: \"No search results.\",\n\t\t\tresults: function( amount ) {\n\t\t\t\treturn amount + ( amount > 1 ? \" results are\" : \" result is\" ) +\n\t\t\t\t\t\" available, use up and down arrow keys to navigate.\";\n\t\t\t}\n\t\t}\n\t},\n\n\t__response: function( content ) {\n\t\tvar message;\n\t\tthis._superApply( arguments );\n\t\tif ( this.options.disabled || this.cancelSearch ) {\n\t\t\treturn;\n\t\t}\n\t\tif ( content && content.length ) {\n\t\t\tmessage = this.options.messages.results( content.length );\n\t\t} else {\n\t\t\tmessage = this.options.messages.noResults;\n\t\t}\n\t\tclearTimeout( this.liveRegionTimer );\n\t\tthis.liveRegionTimer = this._delay( function() {\n\t\t\tthis.liveRegion.html( $( \"<div>\" ).text( message ) );\n\t\t}, 100 );\n\t}\n} );\n\nreturn $.ui.autocomplete;\n\n} );\n","jquery/ui-modules/widgets/selectable.js":"/*!\n * jQuery UI Selectable 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Selectable\n//>>group: Interactions\n//>>description: Allows groups of elements to be selected with the mouse.\n//>>docs: http://api.jqueryui.com/selectable/\n//>>demos: http://jqueryui.com/selectable/\n//>>css.structure: ../../themes/base/selectable.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./mouse\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.widget( \"ui.selectable\", $.ui.mouse, {\n\tversion: \"1.13.1\",\n\toptions: {\n\t\tappendTo: \"body\",\n\t\tautoRefresh: true,\n\t\tdistance: 0,\n\t\tfilter: \"*\",\n\t\ttolerance: \"touch\",\n\n\t\t// Callbacks\n\t\tselected: null,\n\t\tselecting: null,\n\t\tstart: null,\n\t\tstop: null,\n\t\tunselected: null,\n\t\tunselecting: null\n\t},\n\t_create: function() {\n\t\tvar that = this;\n\n\t\tthis._addClass( \"ui-selectable\" );\n\n\t\tthis.dragged = false;\n\n\t\t// Cache selectee children based on filter\n\t\tthis.refresh = function() {\n\t\t\tthat.elementPos = $( that.element[ 0 ] ).offset();\n\t\t\tthat.selectees = $( that.options.filter, that.element[ 0 ] );\n\t\t\tthat._addClass( that.selectees, \"ui-selectee\" );\n\t\t\tthat.selectees.each( function() {\n\t\t\t\tvar $this = $( this ),\n\t\t\t\t\tselecteeOffset = $this.offset(),\n\t\t\t\t\tpos = {\n\t\t\t\t\t\tleft: selecteeOffset.left - that.elementPos.left,\n\t\t\t\t\t\ttop: selecteeOffset.top - that.elementPos.top\n\t\t\t\t\t};\n\t\t\t\t$.data( this, \"selectable-item\", {\n\t\t\t\t\telement: this,\n\t\t\t\t\t$element: $this,\n\t\t\t\t\tleft: pos.left,\n\t\t\t\t\ttop: pos.top,\n\t\t\t\t\tright: pos.left + $this.outerWidth(),\n\t\t\t\t\tbottom: pos.top + $this.outerHeight(),\n\t\t\t\t\tstartselected: false,\n\t\t\t\t\tselected: $this.hasClass( \"ui-selected\" ),\n\t\t\t\t\tselecting: $this.hasClass( \"ui-selecting\" ),\n\t\t\t\t\tunselecting: $this.hasClass( \"ui-unselecting\" )\n\t\t\t\t} );\n\t\t\t} );\n\t\t};\n\t\tthis.refresh();\n\n\t\tthis._mouseInit();\n\n\t\tthis.helper = $( \"<div>\" );\n\t\tthis._addClass( this.helper, \"ui-selectable-helper\" );\n\t},\n\n\t_destroy: function() {\n\t\tthis.selectees.removeData( \"selectable-item\" );\n\t\tthis._mouseDestroy();\n\t},\n\n\t_mouseStart: function( event ) {\n\t\tvar that = this,\n\t\t\toptions = this.options;\n\n\t\tthis.opos = [ event.pageX, event.pageY ];\n\t\tthis.elementPos = $( this.element[ 0 ] ).offset();\n\n\t\tif ( this.options.disabled ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.selectees = $( options.filter, this.element[ 0 ] );\n\n\t\tthis._trigger( \"start\", event );\n\n\t\t$( options.appendTo ).append( this.helper );\n\n\t\t// position helper (lasso)\n\t\tthis.helper.css( {\n\t\t\t\"left\": event.pageX,\n\t\t\t\"top\": event.pageY,\n\t\t\t\"width\": 0,\n\t\t\t\"height\": 0\n\t\t} );\n\n\t\tif ( options.autoRefresh ) {\n\t\t\tthis.refresh();\n\t\t}\n\n\t\tthis.selectees.filter( \".ui-selected\" ).each( function() {\n\t\t\tvar selectee = $.data( this, \"selectable-item\" );\n\t\t\tselectee.startselected = true;\n\t\t\tif ( !event.metaKey && !event.ctrlKey ) {\n\t\t\t\tthat._removeClass( selectee.$element, \"ui-selected\" );\n\t\t\t\tselectee.selected = false;\n\t\t\t\tthat._addClass( selectee.$element, \"ui-unselecting\" );\n\t\t\t\tselectee.unselecting = true;\n\n\t\t\t\t// selectable UNSELECTING callback\n\t\t\t\tthat._trigger( \"unselecting\", event, {\n\t\t\t\t\tunselecting: selectee.element\n\t\t\t\t} );\n\t\t\t}\n\t\t} );\n\n\t\t$( event.target ).parents().addBack().each( function() {\n\t\t\tvar doSelect,\n\t\t\t\tselectee = $.data( this, \"selectable-item\" );\n\t\t\tif ( selectee ) {\n\t\t\t\tdoSelect = ( !event.metaKey && !event.ctrlKey ) ||\n\t\t\t\t\t!selectee.$element.hasClass( \"ui-selected\" );\n\t\t\t\tthat._removeClass( selectee.$element, doSelect ? \"ui-unselecting\" : \"ui-selected\" )\n\t\t\t\t\t._addClass( selectee.$element, doSelect ? \"ui-selecting\" : \"ui-unselecting\" );\n\t\t\t\tselectee.unselecting = !doSelect;\n\t\t\t\tselectee.selecting = doSelect;\n\t\t\t\tselectee.selected = doSelect;\n\n\t\t\t\t// selectable (UN)SELECTING callback\n\t\t\t\tif ( doSelect ) {\n\t\t\t\t\tthat._trigger( \"selecting\", event, {\n\t\t\t\t\t\tselecting: selectee.element\n\t\t\t\t\t} );\n\t\t\t\t} else {\n\t\t\t\t\tthat._trigger( \"unselecting\", event, {\n\t\t\t\t\t\tunselecting: selectee.element\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t}\n\t\t} );\n\n\t},\n\n\t_mouseDrag: function( event ) {\n\n\t\tthis.dragged = true;\n\n\t\tif ( this.options.disabled ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar tmp,\n\t\t\tthat = this,\n\t\t\toptions = this.options,\n\t\t\tx1 = this.opos[ 0 ],\n\t\t\ty1 = this.opos[ 1 ],\n\t\t\tx2 = event.pageX,\n\t\t\ty2 = event.pageY;\n\n\t\tif ( x1 > x2 ) {\n\t\t\ttmp = x2; x2 = x1; x1 = tmp;\n\t\t}\n\t\tif ( y1 > y2 ) {\n\t\t\ttmp = y2; y2 = y1; y1 = tmp;\n\t\t}\n\t\tthis.helper.css( { left: x1, top: y1, width: x2 - x1, height: y2 - y1 } );\n\n\t\tthis.selectees.each( function() {\n\t\t\tvar selectee = $.data( this, \"selectable-item\" ),\n\t\t\t\thit = false,\n\t\t\t\toffset = {};\n\n\t\t\t//prevent helper from being selected if appendTo: selectable\n\t\t\tif ( !selectee || selectee.element === that.element[ 0 ] ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\toffset.left   = selectee.left   + that.elementPos.left;\n\t\t\toffset.right  = selectee.right  + that.elementPos.left;\n\t\t\toffset.top    = selectee.top    + that.elementPos.top;\n\t\t\toffset.bottom = selectee.bottom + that.elementPos.top;\n\n\t\t\tif ( options.tolerance === \"touch\" ) {\n\t\t\t\thit = ( !( offset.left > x2 || offset.right < x1 || offset.top > y2 ||\n                    offset.bottom < y1 ) );\n\t\t\t} else if ( options.tolerance === \"fit\" ) {\n\t\t\t\thit = ( offset.left > x1 && offset.right < x2 && offset.top > y1 &&\n                    offset.bottom < y2 );\n\t\t\t}\n\n\t\t\tif ( hit ) {\n\n\t\t\t\t// SELECT\n\t\t\t\tif ( selectee.selected ) {\n\t\t\t\t\tthat._removeClass( selectee.$element, \"ui-selected\" );\n\t\t\t\t\tselectee.selected = false;\n\t\t\t\t}\n\t\t\t\tif ( selectee.unselecting ) {\n\t\t\t\t\tthat._removeClass( selectee.$element, \"ui-unselecting\" );\n\t\t\t\t\tselectee.unselecting = false;\n\t\t\t\t}\n\t\t\t\tif ( !selectee.selecting ) {\n\t\t\t\t\tthat._addClass( selectee.$element, \"ui-selecting\" );\n\t\t\t\t\tselectee.selecting = true;\n\n\t\t\t\t\t// selectable SELECTING callback\n\t\t\t\t\tthat._trigger( \"selecting\", event, {\n\t\t\t\t\t\tselecting: selectee.element\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t} else {\n\n\t\t\t\t// UNSELECT\n\t\t\t\tif ( selectee.selecting ) {\n\t\t\t\t\tif ( ( event.metaKey || event.ctrlKey ) && selectee.startselected ) {\n\t\t\t\t\t\tthat._removeClass( selectee.$element, \"ui-selecting\" );\n\t\t\t\t\t\tselectee.selecting = false;\n\t\t\t\t\t\tthat._addClass( selectee.$element, \"ui-selected\" );\n\t\t\t\t\t\tselectee.selected = true;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthat._removeClass( selectee.$element, \"ui-selecting\" );\n\t\t\t\t\t\tselectee.selecting = false;\n\t\t\t\t\t\tif ( selectee.startselected ) {\n\t\t\t\t\t\t\tthat._addClass( selectee.$element, \"ui-unselecting\" );\n\t\t\t\t\t\t\tselectee.unselecting = true;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// selectable UNSELECTING callback\n\t\t\t\t\t\tthat._trigger( \"unselecting\", event, {\n\t\t\t\t\t\t\tunselecting: selectee.element\n\t\t\t\t\t\t} );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif ( selectee.selected ) {\n\t\t\t\t\tif ( !event.metaKey && !event.ctrlKey && !selectee.startselected ) {\n\t\t\t\t\t\tthat._removeClass( selectee.$element, \"ui-selected\" );\n\t\t\t\t\t\tselectee.selected = false;\n\n\t\t\t\t\t\tthat._addClass( selectee.$element, \"ui-unselecting\" );\n\t\t\t\t\t\tselectee.unselecting = true;\n\n\t\t\t\t\t\t// selectable UNSELECTING callback\n\t\t\t\t\t\tthat._trigger( \"unselecting\", event, {\n\t\t\t\t\t\t\tunselecting: selectee.element\n\t\t\t\t\t\t} );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t} );\n\n\t\treturn false;\n\t},\n\n\t_mouseStop: function( event ) {\n\t\tvar that = this;\n\n\t\tthis.dragged = false;\n\n\t\t$( \".ui-unselecting\", this.element[ 0 ] ).each( function() {\n\t\t\tvar selectee = $.data( this, \"selectable-item\" );\n\t\t\tthat._removeClass( selectee.$element, \"ui-unselecting\" );\n\t\t\tselectee.unselecting = false;\n\t\t\tselectee.startselected = false;\n\t\t\tthat._trigger( \"unselected\", event, {\n\t\t\t\tunselected: selectee.element\n\t\t\t} );\n\t\t} );\n\t\t$( \".ui-selecting\", this.element[ 0 ] ).each( function() {\n\t\t\tvar selectee = $.data( this, \"selectable-item\" );\n\t\t\tthat._removeClass( selectee.$element, \"ui-selecting\" )\n\t\t\t\t._addClass( selectee.$element, \"ui-selected\" );\n\t\t\tselectee.selecting = false;\n\t\t\tselectee.selected = true;\n\t\t\tselectee.startselected = true;\n\t\t\tthat._trigger( \"selected\", event, {\n\t\t\t\tselected: selectee.element\n\t\t\t} );\n\t\t} );\n\t\tthis._trigger( \"stop\", event );\n\n\t\tthis.helper.remove();\n\n\t\treturn false;\n\t}\n\n} );\n\n} );\n","jquery/ui-modules/widgets/slider.js":"/*!\n * jQuery UI Slider 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Slider\n//>>group: Widgets\n//>>description: Displays a flexible slider with ranges and accessibility via keyboard.\n//>>docs: http://api.jqueryui.com/slider/\n//>>demos: http://jqueryui.com/slider/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/slider.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./mouse\",\n\t\t\t\"../keycode\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.widget( \"ui.slider\", $.ui.mouse, {\n\tversion: \"1.13.1\",\n\twidgetEventPrefix: \"slide\",\n\n\toptions: {\n\t\tanimate: false,\n\t\tclasses: {\n\t\t\t\"ui-slider\": \"ui-corner-all\",\n\t\t\t\"ui-slider-handle\": \"ui-corner-all\",\n\n\t\t\t// Note: ui-widget-header isn't the most fittingly semantic framework class for this\n\t\t\t// element, but worked best visually with a variety of themes\n\t\t\t\"ui-slider-range\": \"ui-corner-all ui-widget-header\"\n\t\t},\n\t\tdistance: 0,\n\t\tmax: 100,\n\t\tmin: 0,\n\t\torientation: \"horizontal\",\n\t\trange: false,\n\t\tstep: 1,\n\t\tvalue: 0,\n\t\tvalues: null,\n\n\t\t// Callbacks\n\t\tchange: null,\n\t\tslide: null,\n\t\tstart: null,\n\t\tstop: null\n\t},\n\n\t// Number of pages in a slider\n\t// (how many times can you page up/down to go through the whole range)\n\tnumPages: 5,\n\n\t_create: function() {\n\t\tthis._keySliding = false;\n\t\tthis._mouseSliding = false;\n\t\tthis._animateOff = true;\n\t\tthis._handleIndex = null;\n\t\tthis._detectOrientation();\n\t\tthis._mouseInit();\n\t\tthis._calculateNewMax();\n\n\t\tthis._addClass( \"ui-slider ui-slider-\" + this.orientation,\n\t\t\t\"ui-widget ui-widget-content\" );\n\n\t\tthis._refresh();\n\n\t\tthis._animateOff = false;\n\t},\n\n\t_refresh: function() {\n\t\tthis._createRange();\n\t\tthis._createHandles();\n\t\tthis._setupEvents();\n\t\tthis._refreshValue();\n\t},\n\n\t_createHandles: function() {\n\t\tvar i, handleCount,\n\t\t\toptions = this.options,\n\t\t\texistingHandles = this.element.find( \".ui-slider-handle\" ),\n\t\t\thandle = \"<span tabindex='0'></span>\",\n\t\t\thandles = [];\n\n\t\thandleCount = ( options.values && options.values.length ) || 1;\n\n\t\tif ( existingHandles.length > handleCount ) {\n\t\t\texistingHandles.slice( handleCount ).remove();\n\t\t\texistingHandles = existingHandles.slice( 0, handleCount );\n\t\t}\n\n\t\tfor ( i = existingHandles.length; i < handleCount; i++ ) {\n\t\t\thandles.push( handle );\n\t\t}\n\n\t\tthis.handles = existingHandles.add( $( handles.join( \"\" ) ).appendTo( this.element ) );\n\n\t\tthis._addClass( this.handles, \"ui-slider-handle\", \"ui-state-default\" );\n\n\t\tthis.handle = this.handles.eq( 0 );\n\n\t\tthis.handles.each( function( i ) {\n\t\t\t$( this )\n\t\t\t\t.data( \"ui-slider-handle-index\", i )\n\t\t\t\t.attr( \"tabIndex\", 0 );\n\t\t} );\n\t},\n\n\t_createRange: function() {\n\t\tvar options = this.options;\n\n\t\tif ( options.range ) {\n\t\t\tif ( options.range === true ) {\n\t\t\t\tif ( !options.values ) {\n\t\t\t\t\toptions.values = [ this._valueMin(), this._valueMin() ];\n\t\t\t\t} else if ( options.values.length && options.values.length !== 2 ) {\n\t\t\t\t\toptions.values = [ options.values[ 0 ], options.values[ 0 ] ];\n\t\t\t\t} else if ( Array.isArray( options.values ) ) {\n\t\t\t\t\toptions.values = options.values.slice( 0 );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( !this.range || !this.range.length ) {\n\t\t\t\tthis.range = $( \"<div>\" )\n\t\t\t\t\t.appendTo( this.element );\n\n\t\t\t\tthis._addClass( this.range, \"ui-slider-range\" );\n\t\t\t} else {\n\t\t\t\tthis._removeClass( this.range, \"ui-slider-range-min ui-slider-range-max\" );\n\n\t\t\t\t// Handle range switching from true to min/max\n\t\t\t\tthis.range.css( {\n\t\t\t\t\t\"left\": \"\",\n\t\t\t\t\t\"bottom\": \"\"\n\t\t\t\t} );\n\t\t\t}\n\t\t\tif ( options.range === \"min\" || options.range === \"max\" ) {\n\t\t\t\tthis._addClass( this.range, \"ui-slider-range-\" + options.range );\n\t\t\t}\n\t\t} else {\n\t\t\tif ( this.range ) {\n\t\t\t\tthis.range.remove();\n\t\t\t}\n\t\t\tthis.range = null;\n\t\t}\n\t},\n\n\t_setupEvents: function() {\n\t\tthis._off( this.handles );\n\t\tthis._on( this.handles, this._handleEvents );\n\t\tthis._hoverable( this.handles );\n\t\tthis._focusable( this.handles );\n\t},\n\n\t_destroy: function() {\n\t\tthis.handles.remove();\n\t\tif ( this.range ) {\n\t\t\tthis.range.remove();\n\t\t}\n\n\t\tthis._mouseDestroy();\n\t},\n\n\t_mouseCapture: function( event ) {\n\t\tvar position, normValue, distance, closestHandle, index, allowed, offset, mouseOverHandle,\n\t\t\tthat = this,\n\t\t\to = this.options;\n\n\t\tif ( o.disabled ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tthis.elementSize = {\n\t\t\twidth: this.element.outerWidth(),\n\t\t\theight: this.element.outerHeight()\n\t\t};\n\t\tthis.elementOffset = this.element.offset();\n\n\t\tposition = { x: event.pageX, y: event.pageY };\n\t\tnormValue = this._normValueFromMouse( position );\n\t\tdistance = this._valueMax() - this._valueMin() + 1;\n\t\tthis.handles.each( function( i ) {\n\t\t\tvar thisDistance = Math.abs( normValue - that.values( i ) );\n\t\t\tif ( ( distance > thisDistance ) ||\n\t\t\t\t( distance === thisDistance &&\n\t\t\t\t\t( i === that._lastChangedValue || that.values( i ) === o.min ) ) ) {\n\t\t\t\tdistance = thisDistance;\n\t\t\t\tclosestHandle = $( this );\n\t\t\t\tindex = i;\n\t\t\t}\n\t\t} );\n\n\t\tallowed = this._start( event, index );\n\t\tif ( allowed === false ) {\n\t\t\treturn false;\n\t\t}\n\t\tthis._mouseSliding = true;\n\n\t\tthis._handleIndex = index;\n\n\t\tthis._addClass( closestHandle, null, \"ui-state-active\" );\n\t\tclosestHandle.trigger( \"focus\" );\n\n\t\toffset = closestHandle.offset();\n\t\tmouseOverHandle = !$( event.target ).parents().addBack().is( \".ui-slider-handle\" );\n\t\tthis._clickOffset = mouseOverHandle ? { left: 0, top: 0 } : {\n\t\t\tleft: event.pageX - offset.left - ( closestHandle.width() / 2 ),\n\t\t\ttop: event.pageY - offset.top -\n\t\t\t\t( closestHandle.height() / 2 ) -\n\t\t\t\t( parseInt( closestHandle.css( \"borderTopWidth\" ), 10 ) || 0 ) -\n\t\t\t\t( parseInt( closestHandle.css( \"borderBottomWidth\" ), 10 ) || 0 ) +\n\t\t\t\t( parseInt( closestHandle.css( \"marginTop\" ), 10 ) || 0 )\n\t\t};\n\n\t\tif ( !this.handles.hasClass( \"ui-state-hover\" ) ) {\n\t\t\tthis._slide( event, index, normValue );\n\t\t}\n\t\tthis._animateOff = true;\n\t\treturn true;\n\t},\n\n\t_mouseStart: function() {\n\t\treturn true;\n\t},\n\n\t_mouseDrag: function( event ) {\n\t\tvar position = { x: event.pageX, y: event.pageY },\n\t\t\tnormValue = this._normValueFromMouse( position );\n\n\t\tthis._slide( event, this._handleIndex, normValue );\n\n\t\treturn false;\n\t},\n\n\t_mouseStop: function( event ) {\n\t\tthis._removeClass( this.handles, null, \"ui-state-active\" );\n\t\tthis._mouseSliding = false;\n\n\t\tthis._stop( event, this._handleIndex );\n\t\tthis._change( event, this._handleIndex );\n\n\t\tthis._handleIndex = null;\n\t\tthis._clickOffset = null;\n\t\tthis._animateOff = false;\n\n\t\treturn false;\n\t},\n\n\t_detectOrientation: function() {\n\t\tthis.orientation = ( this.options.orientation === \"vertical\" ) ? \"vertical\" : \"horizontal\";\n\t},\n\n\t_normValueFromMouse: function( position ) {\n\t\tvar pixelTotal,\n\t\t\tpixelMouse,\n\t\t\tpercentMouse,\n\t\t\tvalueTotal,\n\t\t\tvalueMouse;\n\n\t\tif ( this.orientation === \"horizontal\" ) {\n\t\t\tpixelTotal = this.elementSize.width;\n\t\t\tpixelMouse = position.x - this.elementOffset.left -\n\t\t\t\t( this._clickOffset ? this._clickOffset.left : 0 );\n\t\t} else {\n\t\t\tpixelTotal = this.elementSize.height;\n\t\t\tpixelMouse = position.y - this.elementOffset.top -\n\t\t\t\t( this._clickOffset ? this._clickOffset.top : 0 );\n\t\t}\n\n\t\tpercentMouse = ( pixelMouse / pixelTotal );\n\t\tif ( percentMouse > 1 ) {\n\t\t\tpercentMouse = 1;\n\t\t}\n\t\tif ( percentMouse < 0 ) {\n\t\t\tpercentMouse = 0;\n\t\t}\n\t\tif ( this.orientation === \"vertical\" ) {\n\t\t\tpercentMouse = 1 - percentMouse;\n\t\t}\n\n\t\tvalueTotal = this._valueMax() - this._valueMin();\n\t\tvalueMouse = this._valueMin() + percentMouse * valueTotal;\n\n\t\treturn this._trimAlignValue( valueMouse );\n\t},\n\n\t_uiHash: function( index, value, values ) {\n\t\tvar uiHash = {\n\t\t\thandle: this.handles[ index ],\n\t\t\thandleIndex: index,\n\t\t\tvalue: value !== undefined ? value : this.value()\n\t\t};\n\n\t\tif ( this._hasMultipleValues() ) {\n\t\t\tuiHash.value = value !== undefined ? value : this.values( index );\n\t\t\tuiHash.values = values || this.values();\n\t\t}\n\n\t\treturn uiHash;\n\t},\n\n\t_hasMultipleValues: function() {\n\t\treturn this.options.values && this.options.values.length;\n\t},\n\n\t_start: function( event, index ) {\n\t\treturn this._trigger( \"start\", event, this._uiHash( index ) );\n\t},\n\n\t_slide: function( event, index, newVal ) {\n\t\tvar allowed, otherVal,\n\t\t\tcurrentValue = this.value(),\n\t\t\tnewValues = this.values();\n\n\t\tif ( this._hasMultipleValues() ) {\n\t\t\totherVal = this.values( index ? 0 : 1 );\n\t\t\tcurrentValue = this.values( index );\n\n\t\t\tif ( this.options.values.length === 2 && this.options.range === true ) {\n\t\t\t\tnewVal =  index === 0 ? Math.min( otherVal, newVal ) : Math.max( otherVal, newVal );\n\t\t\t}\n\n\t\t\tnewValues[ index ] = newVal;\n\t\t}\n\n\t\tif ( newVal === currentValue ) {\n\t\t\treturn;\n\t\t}\n\n\t\tallowed = this._trigger( \"slide\", event, this._uiHash( index, newVal, newValues ) );\n\n\t\t// A slide can be canceled by returning false from the slide callback\n\t\tif ( allowed === false ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( this._hasMultipleValues() ) {\n\t\t\tthis.values( index, newVal );\n\t\t} else {\n\t\t\tthis.value( newVal );\n\t\t}\n\t},\n\n\t_stop: function( event, index ) {\n\t\tthis._trigger( \"stop\", event, this._uiHash( index ) );\n\t},\n\n\t_change: function( event, index ) {\n\t\tif ( !this._keySliding && !this._mouseSliding ) {\n\n\t\t\t//store the last changed value index for reference when handles overlap\n\t\t\tthis._lastChangedValue = index;\n\t\t\tthis._trigger( \"change\", event, this._uiHash( index ) );\n\t\t}\n\t},\n\n\tvalue: function( newValue ) {\n\t\tif ( arguments.length ) {\n\t\t\tthis.options.value = this._trimAlignValue( newValue );\n\t\t\tthis._refreshValue();\n\t\t\tthis._change( null, 0 );\n\t\t\treturn;\n\t\t}\n\n\t\treturn this._value();\n\t},\n\n\tvalues: function( index, newValue ) {\n\t\tvar vals,\n\t\t\tnewValues,\n\t\t\ti;\n\n\t\tif ( arguments.length > 1 ) {\n\t\t\tthis.options.values[ index ] = this._trimAlignValue( newValue );\n\t\t\tthis._refreshValue();\n\t\t\tthis._change( null, index );\n\t\t\treturn;\n\t\t}\n\n\t\tif ( arguments.length ) {\n\t\t\tif ( Array.isArray( arguments[ 0 ] ) ) {\n\t\t\t\tvals = this.options.values;\n\t\t\t\tnewValues = arguments[ 0 ];\n\t\t\t\tfor ( i = 0; i < vals.length; i += 1 ) {\n\t\t\t\t\tvals[ i ] = this._trimAlignValue( newValues[ i ] );\n\t\t\t\t\tthis._change( null, i );\n\t\t\t\t}\n\t\t\t\tthis._refreshValue();\n\t\t\t} else {\n\t\t\t\tif ( this._hasMultipleValues() ) {\n\t\t\t\t\treturn this._values( index );\n\t\t\t\t} else {\n\t\t\t\t\treturn this.value();\n\t\t\t\t}\n\t\t\t}\n\t\t} else {\n\t\t\treturn this._values();\n\t\t}\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tvar i,\n\t\t\tvalsLength = 0;\n\n\t\tif ( key === \"range\" && this.options.range === true ) {\n\t\t\tif ( value === \"min\" ) {\n\t\t\t\tthis.options.value = this._values( 0 );\n\t\t\t\tthis.options.values = null;\n\t\t\t} else if ( value === \"max\" ) {\n\t\t\t\tthis.options.value = this._values( this.options.values.length - 1 );\n\t\t\t\tthis.options.values = null;\n\t\t\t}\n\t\t}\n\n\t\tif ( Array.isArray( this.options.values ) ) {\n\t\t\tvalsLength = this.options.values.length;\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\tswitch ( key ) {\n\t\t\tcase \"orientation\":\n\t\t\t\tthis._detectOrientation();\n\t\t\t\tthis._removeClass( \"ui-slider-horizontal ui-slider-vertical\" )\n\t\t\t\t\t._addClass( \"ui-slider-\" + this.orientation );\n\t\t\t\tthis._refreshValue();\n\t\t\t\tif ( this.options.range ) {\n\t\t\t\t\tthis._refreshRange( value );\n\t\t\t\t}\n\n\t\t\t\t// Reset positioning from previous orientation\n\t\t\t\tthis.handles.css( value === \"horizontal\" ? \"bottom\" : \"left\", \"\" );\n\t\t\t\tbreak;\n\t\t\tcase \"value\":\n\t\t\t\tthis._animateOff = true;\n\t\t\t\tthis._refreshValue();\n\t\t\t\tthis._change( null, 0 );\n\t\t\t\tthis._animateOff = false;\n\t\t\t\tbreak;\n\t\t\tcase \"values\":\n\t\t\t\tthis._animateOff = true;\n\t\t\t\tthis._refreshValue();\n\n\t\t\t\t// Start from the last handle to prevent unreachable handles (#9046)\n\t\t\t\tfor ( i = valsLength - 1; i >= 0; i-- ) {\n\t\t\t\t\tthis._change( null, i );\n\t\t\t\t}\n\t\t\t\tthis._animateOff = false;\n\t\t\t\tbreak;\n\t\t\tcase \"step\":\n\t\t\tcase \"min\":\n\t\t\tcase \"max\":\n\t\t\t\tthis._animateOff = true;\n\t\t\t\tthis._calculateNewMax();\n\t\t\t\tthis._refreshValue();\n\t\t\t\tthis._animateOff = false;\n\t\t\t\tbreak;\n\t\t\tcase \"range\":\n\t\t\t\tthis._animateOff = true;\n\t\t\t\tthis._refresh();\n\t\t\t\tthis._animateOff = false;\n\t\t\t\tbreak;\n\t\t}\n\t},\n\n\t_setOptionDisabled: function( value ) {\n\t\tthis._super( value );\n\n\t\tthis._toggleClass( null, \"ui-state-disabled\", !!value );\n\t},\n\n\t//internal value getter\n\t// _value() returns value trimmed by min and max, aligned by step\n\t_value: function() {\n\t\tvar val = this.options.value;\n\t\tval = this._trimAlignValue( val );\n\n\t\treturn val;\n\t},\n\n\t//internal values getter\n\t// _values() returns array of values trimmed by min and max, aligned by step\n\t// _values( index ) returns single value trimmed by min and max, aligned by step\n\t_values: function( index ) {\n\t\tvar val,\n\t\t\tvals,\n\t\t\ti;\n\n\t\tif ( arguments.length ) {\n\t\t\tval = this.options.values[ index ];\n\t\t\tval = this._trimAlignValue( val );\n\n\t\t\treturn val;\n\t\t} else if ( this._hasMultipleValues() ) {\n\n\t\t\t// .slice() creates a copy of the array\n\t\t\t// this copy gets trimmed by min and max and then returned\n\t\t\tvals = this.options.values.slice();\n\t\t\tfor ( i = 0; i < vals.length; i += 1 ) {\n\t\t\t\tvals[ i ] = this._trimAlignValue( vals[ i ] );\n\t\t\t}\n\n\t\t\treturn vals;\n\t\t} else {\n\t\t\treturn [];\n\t\t}\n\t},\n\n\t// Returns the step-aligned value that val is closest to, between (inclusive) min and max\n\t_trimAlignValue: function( val ) {\n\t\tif ( val <= this._valueMin() ) {\n\t\t\treturn this._valueMin();\n\t\t}\n\t\tif ( val >= this._valueMax() ) {\n\t\t\treturn this._valueMax();\n\t\t}\n\t\tvar step = ( this.options.step > 0 ) ? this.options.step : 1,\n\t\t\tvalModStep = ( val - this._valueMin() ) % step,\n\t\t\talignValue = val - valModStep;\n\n\t\tif ( Math.abs( valModStep ) * 2 >= step ) {\n\t\t\talignValue += ( valModStep > 0 ) ? step : ( -step );\n\t\t}\n\n\t\t// Since JavaScript has problems with large floats, round\n\t\t// the final value to 5 digits after the decimal point (see #4124)\n\t\treturn parseFloat( alignValue.toFixed( 5 ) );\n\t},\n\n\t_calculateNewMax: function() {\n\t\tvar max = this.options.max,\n\t\t\tmin = this._valueMin(),\n\t\t\tstep = this.options.step,\n\t\t\taboveMin = Math.round( ( max - min ) / step ) * step;\n\t\tmax = aboveMin + min;\n\t\tif ( max > this.options.max ) {\n\n\t\t\t//If max is not divisible by step, rounding off may increase its value\n\t\t\tmax -= step;\n\t\t}\n\t\tthis.max = parseFloat( max.toFixed( this._precision() ) );\n\t},\n\n\t_precision: function() {\n\t\tvar precision = this._precisionOf( this.options.step );\n\t\tif ( this.options.min !== null ) {\n\t\t\tprecision = Math.max( precision, this._precisionOf( this.options.min ) );\n\t\t}\n\t\treturn precision;\n\t},\n\n\t_precisionOf: function( num ) {\n\t\tvar str = num.toString(),\n\t\t\tdecimal = str.indexOf( \".\" );\n\t\treturn decimal === -1 ? 0 : str.length - decimal - 1;\n\t},\n\n\t_valueMin: function() {\n\t\treturn this.options.min;\n\t},\n\n\t_valueMax: function() {\n\t\treturn this.max;\n\t},\n\n\t_refreshRange: function( orientation ) {\n\t\tif ( orientation === \"vertical\" ) {\n\t\t\tthis.range.css( { \"width\": \"\", \"left\": \"\" } );\n\t\t}\n\t\tif ( orientation === \"horizontal\" ) {\n\t\t\tthis.range.css( { \"height\": \"\", \"bottom\": \"\" } );\n\t\t}\n\t},\n\n\t_refreshValue: function() {\n\t\tvar lastValPercent, valPercent, value, valueMin, valueMax,\n\t\t\toRange = this.options.range,\n\t\t\to = this.options,\n\t\t\tthat = this,\n\t\t\tanimate = ( !this._animateOff ) ? o.animate : false,\n\t\t\t_set = {};\n\n\t\tif ( this._hasMultipleValues() ) {\n\t\t\tthis.handles.each( function( i ) {\n\t\t\t\tvalPercent = ( that.values( i ) - that._valueMin() ) / ( that._valueMax() -\n\t\t\t\t\tthat._valueMin() ) * 100;\n\t\t\t\t_set[ that.orientation === \"horizontal\" ? \"left\" : \"bottom\" ] = valPercent + \"%\";\n\t\t\t\t$( this ).stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( _set, o.animate );\n\t\t\t\tif ( that.options.range === true ) {\n\t\t\t\t\tif ( that.orientation === \"horizontal\" ) {\n\t\t\t\t\t\tif ( i === 0 ) {\n\t\t\t\t\t\t\tthat.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n\t\t\t\t\t\t\t\tleft: valPercent + \"%\"\n\t\t\t\t\t\t\t}, o.animate );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( i === 1 ) {\n\t\t\t\t\t\t\tthat.range[ animate ? \"animate\" : \"css\" ]( {\n\t\t\t\t\t\t\t\twidth: ( valPercent - lastValPercent ) + \"%\"\n\t\t\t\t\t\t\t}, {\n\t\t\t\t\t\t\t\tqueue: false,\n\t\t\t\t\t\t\t\tduration: o.animate\n\t\t\t\t\t\t\t} );\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif ( i === 0 ) {\n\t\t\t\t\t\t\tthat.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n\t\t\t\t\t\t\t\tbottom: ( valPercent ) + \"%\"\n\t\t\t\t\t\t\t}, o.animate );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( i === 1 ) {\n\t\t\t\t\t\t\tthat.range[ animate ? \"animate\" : \"css\" ]( {\n\t\t\t\t\t\t\t\theight: ( valPercent - lastValPercent ) + \"%\"\n\t\t\t\t\t\t\t}, {\n\t\t\t\t\t\t\t\tqueue: false,\n\t\t\t\t\t\t\t\tduration: o.animate\n\t\t\t\t\t\t\t} );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tlastValPercent = valPercent;\n\t\t\t} );\n\t\t} else {\n\t\t\tvalue = this.value();\n\t\t\tvalueMin = this._valueMin();\n\t\t\tvalueMax = this._valueMax();\n\t\t\tvalPercent = ( valueMax !== valueMin ) ?\n\t\t\t\t\t( value - valueMin ) / ( valueMax - valueMin ) * 100 :\n\t\t\t\t\t0;\n\t\t\t_set[ this.orientation === \"horizontal\" ? \"left\" : \"bottom\" ] = valPercent + \"%\";\n\t\t\tthis.handle.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( _set, o.animate );\n\n\t\t\tif ( oRange === \"min\" && this.orientation === \"horizontal\" ) {\n\t\t\t\tthis.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n\t\t\t\t\twidth: valPercent + \"%\"\n\t\t\t\t}, o.animate );\n\t\t\t}\n\t\t\tif ( oRange === \"max\" && this.orientation === \"horizontal\" ) {\n\t\t\t\tthis.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n\t\t\t\t\twidth: ( 100 - valPercent ) + \"%\"\n\t\t\t\t}, o.animate );\n\t\t\t}\n\t\t\tif ( oRange === \"min\" && this.orientation === \"vertical\" ) {\n\t\t\t\tthis.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n\t\t\t\t\theight: valPercent + \"%\"\n\t\t\t\t}, o.animate );\n\t\t\t}\n\t\t\tif ( oRange === \"max\" && this.orientation === \"vertical\" ) {\n\t\t\t\tthis.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n\t\t\t\t\theight: ( 100 - valPercent ) + \"%\"\n\t\t\t\t}, o.animate );\n\t\t\t}\n\t\t}\n\t},\n\n\t_handleEvents: {\n\t\tkeydown: function( event ) {\n\t\t\tvar allowed, curVal, newVal, step,\n\t\t\t\tindex = $( event.target ).data( \"ui-slider-handle-index\" );\n\n\t\t\tswitch ( event.keyCode ) {\n\t\t\t\tcase $.ui.keyCode.HOME:\n\t\t\t\tcase $.ui.keyCode.END:\n\t\t\t\tcase $.ui.keyCode.PAGE_UP:\n\t\t\t\tcase $.ui.keyCode.PAGE_DOWN:\n\t\t\t\tcase $.ui.keyCode.UP:\n\t\t\t\tcase $.ui.keyCode.RIGHT:\n\t\t\t\tcase $.ui.keyCode.DOWN:\n\t\t\t\tcase $.ui.keyCode.LEFT:\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tif ( !this._keySliding ) {\n\t\t\t\t\t\tthis._keySliding = true;\n\t\t\t\t\t\tthis._addClass( $( event.target ), null, \"ui-state-active\" );\n\t\t\t\t\t\tallowed = this._start( event, index );\n\t\t\t\t\t\tif ( allowed === false ) {\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\tstep = this.options.step;\n\t\t\tif ( this._hasMultipleValues() ) {\n\t\t\t\tcurVal = newVal = this.values( index );\n\t\t\t} else {\n\t\t\t\tcurVal = newVal = this.value();\n\t\t\t}\n\n\t\t\tswitch ( event.keyCode ) {\n\t\t\t\tcase $.ui.keyCode.HOME:\n\t\t\t\t\tnewVal = this._valueMin();\n\t\t\t\t\tbreak;\n\t\t\t\tcase $.ui.keyCode.END:\n\t\t\t\t\tnewVal = this._valueMax();\n\t\t\t\t\tbreak;\n\t\t\t\tcase $.ui.keyCode.PAGE_UP:\n\t\t\t\t\tnewVal = this._trimAlignValue(\n\t\t\t\t\t\tcurVal + ( ( this._valueMax() - this._valueMin() ) / this.numPages )\n\t\t\t\t\t);\n\t\t\t\t\tbreak;\n\t\t\t\tcase $.ui.keyCode.PAGE_DOWN:\n\t\t\t\t\tnewVal = this._trimAlignValue(\n\t\t\t\t\t\tcurVal - ( ( this._valueMax() - this._valueMin() ) / this.numPages ) );\n\t\t\t\t\tbreak;\n\t\t\t\tcase $.ui.keyCode.UP:\n\t\t\t\tcase $.ui.keyCode.RIGHT:\n\t\t\t\t\tif ( curVal === this._valueMax() ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tnewVal = this._trimAlignValue( curVal + step );\n\t\t\t\t\tbreak;\n\t\t\t\tcase $.ui.keyCode.DOWN:\n\t\t\t\tcase $.ui.keyCode.LEFT:\n\t\t\t\t\tif ( curVal === this._valueMin() ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tnewVal = this._trimAlignValue( curVal - step );\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\tthis._slide( event, index, newVal );\n\t\t},\n\t\tkeyup: function( event ) {\n\t\t\tvar index = $( event.target ).data( \"ui-slider-handle-index\" );\n\n\t\t\tif ( this._keySliding ) {\n\t\t\t\tthis._keySliding = false;\n\t\t\t\tthis._stop( event, index );\n\t\t\t\tthis._change( event, index );\n\t\t\t\tthis._removeClass( $( event.target ), null, \"ui-state-active\" );\n\t\t\t}\n\t\t}\n\t}\n} );\n\n} );\n","jquery/ui-modules/widgets/selectmenu.js":"/*!\n * jQuery UI Selectmenu 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Selectmenu\n//>>group: Widgets\n/* eslint-disable max-len */\n//>>description: Duplicates and extends the functionality of a native HTML select element, allowing it to be customizable in behavior and appearance far beyond the limitations of a native select.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/selectmenu/\n//>>demos: http://jqueryui.com/selectmenu/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/selectmenu.css, ../../themes/base/button.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./menu\",\n\t\t\t\"../form-reset-mixin\",\n\t\t\t\"../keycode\",\n\t\t\t\"../labels\",\n\t\t\t\"../position\",\n\t\t\t\"../unique-id\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.widget( \"ui.selectmenu\", [ $.ui.formResetMixin, {\n\tversion: \"1.13.1\",\n\tdefaultElement: \"<select>\",\n\toptions: {\n\t\tappendTo: null,\n\t\tclasses: {\n\t\t\t\"ui-selectmenu-button-open\": \"ui-corner-top\",\n\t\t\t\"ui-selectmenu-button-closed\": \"ui-corner-all\"\n\t\t},\n\t\tdisabled: null,\n\t\ticons: {\n\t\t\tbutton: \"ui-icon-triangle-1-s\"\n\t\t},\n\t\tposition: {\n\t\t\tmy: \"left top\",\n\t\t\tat: \"left bottom\",\n\t\t\tcollision: \"none\"\n\t\t},\n\t\twidth: false,\n\n\t\t// Callbacks\n\t\tchange: null,\n\t\tclose: null,\n\t\tfocus: null,\n\t\topen: null,\n\t\tselect: null\n\t},\n\n\t_create: function() {\n\t\tvar selectmenuId = this.element.uniqueId().attr( \"id\" );\n\t\tthis.ids = {\n\t\t\telement: selectmenuId,\n\t\t\tbutton: selectmenuId + \"-button\",\n\t\t\tmenu: selectmenuId + \"-menu\"\n\t\t};\n\n\t\tthis._drawButton();\n\t\tthis._drawMenu();\n\t\tthis._bindFormResetHandler();\n\n\t\tthis._rendered = false;\n\t\tthis.menuItems = $();\n\t},\n\n\t_drawButton: function() {\n\t\tvar icon,\n\t\t\tthat = this,\n\t\t\titem = this._parseOption(\n\t\t\t\tthis.element.find( \"option:selected\" ),\n\t\t\t\tthis.element[ 0 ].selectedIndex\n\t\t\t);\n\n\t\t// Associate existing label with the new button\n\t\tthis.labels = this.element.labels().attr( \"for\", this.ids.button );\n\t\tthis._on( this.labels, {\n\t\t\tclick: function( event ) {\n\t\t\t\tthis.button.trigger( \"focus\" );\n\t\t\t\tevent.preventDefault();\n\t\t\t}\n\t\t} );\n\n\t\t// Hide original select element\n\t\tthis.element.hide();\n\n\t\t// Create button\n\t\tthis.button = $( \"<span>\", {\n\t\t\ttabindex: this.options.disabled ? -1 : 0,\n\t\t\tid: this.ids.button,\n\t\t\trole: \"combobox\",\n\t\t\t\"aria-expanded\": \"false\",\n\t\t\t\"aria-autocomplete\": \"list\",\n\t\t\t\"aria-owns\": this.ids.menu,\n\t\t\t\"aria-haspopup\": \"true\",\n\t\t\ttitle: this.element.attr( \"title\" )\n\t\t} )\n\t\t\t.insertAfter( this.element );\n\n\t\tthis._addClass( this.button, \"ui-selectmenu-button ui-selectmenu-button-closed\",\n\t\t\t\"ui-button ui-widget\" );\n\n\t\ticon = $( \"<span>\" ).appendTo( this.button );\n\t\tthis._addClass( icon, \"ui-selectmenu-icon\", \"ui-icon \" + this.options.icons.button );\n\t\tthis.buttonItem = this._renderButtonItem( item )\n\t\t\t.appendTo( this.button );\n\n\t\tif ( this.options.width !== false ) {\n\t\t\tthis._resizeButton();\n\t\t}\n\n\t\tthis._on( this.button, this._buttonEvents );\n\t\tthis.button.one( \"focusin\", function() {\n\n\t\t\t// Delay rendering the menu items until the button receives focus.\n\t\t\t// The menu may have already been rendered via a programmatic open.\n\t\t\tif ( !that._rendered ) {\n\t\t\t\tthat._refreshMenu();\n\t\t\t}\n\t\t} );\n\t},\n\n\t_drawMenu: function() {\n\t\tvar that = this;\n\n\t\t// Create menu\n\t\tthis.menu = $( \"<ul>\", {\n\t\t\t\"aria-hidden\": \"true\",\n\t\t\t\"aria-labelledby\": this.ids.button,\n\t\t\tid: this.ids.menu\n\t\t} );\n\n\t\t// Wrap menu\n\t\tthis.menuWrap = $( \"<div>\" ).append( this.menu );\n\t\tthis._addClass( this.menuWrap, \"ui-selectmenu-menu\", \"ui-front\" );\n\t\tthis.menuWrap.appendTo( this._appendTo() );\n\n\t\t// Initialize menu widget\n\t\tthis.menuInstance = this.menu\n\t\t\t.menu( {\n\t\t\t\tclasses: {\n\t\t\t\t\t\"ui-menu\": \"ui-corner-bottom\"\n\t\t\t\t},\n\t\t\t\trole: \"listbox\",\n\t\t\t\tselect: function( event, ui ) {\n\t\t\t\t\tevent.preventDefault();\n\n\t\t\t\t\t// Support: IE8\n\t\t\t\t\t// If the item was selected via a click, the text selection\n\t\t\t\t\t// will be destroyed in IE\n\t\t\t\t\tthat._setSelection();\n\n\t\t\t\t\tthat._select( ui.item.data( \"ui-selectmenu-item\" ), event );\n\t\t\t\t},\n\t\t\t\tfocus: function( event, ui ) {\n\t\t\t\t\tvar item = ui.item.data( \"ui-selectmenu-item\" );\n\n\t\t\t\t\t// Prevent inital focus from firing and check if its a newly focused item\n\t\t\t\t\tif ( that.focusIndex != null && item.index !== that.focusIndex ) {\n\t\t\t\t\t\tthat._trigger( \"focus\", event, { item: item } );\n\t\t\t\t\t\tif ( !that.isOpen ) {\n\t\t\t\t\t\t\tthat._select( item, event );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tthat.focusIndex = item.index;\n\n\t\t\t\t\tthat.button.attr( \"aria-activedescendant\",\n\t\t\t\t\t\tthat.menuItems.eq( item.index ).attr( \"id\" ) );\n\t\t\t\t}\n\t\t\t} )\n\t\t\t.menu( \"instance\" );\n\n\t\t// Don't close the menu on mouseleave\n\t\tthis.menuInstance._off( this.menu, \"mouseleave\" );\n\n\t\t// Cancel the menu's collapseAll on document click\n\t\tthis.menuInstance._closeOnDocumentClick = function() {\n\t\t\treturn false;\n\t\t};\n\n\t\t// Selects often contain empty items, but never contain dividers\n\t\tthis.menuInstance._isDivider = function() {\n\t\t\treturn false;\n\t\t};\n\t},\n\n\trefresh: function() {\n\t\tthis._refreshMenu();\n\t\tthis.buttonItem.replaceWith(\n\t\t\tthis.buttonItem = this._renderButtonItem(\n\n\t\t\t\t// Fall back to an empty object in case there are no options\n\t\t\t\tthis._getSelectedItem().data( \"ui-selectmenu-item\" ) || {}\n\t\t\t)\n\t\t);\n\t\tif ( this.options.width === null ) {\n\t\t\tthis._resizeButton();\n\t\t}\n\t},\n\n\t_refreshMenu: function() {\n\t\tvar item,\n\t\t\toptions = this.element.find( \"option\" );\n\n\t\tthis.menu.empty();\n\n\t\tthis._parseOptions( options );\n\t\tthis._renderMenu( this.menu, this.items );\n\n\t\tthis.menuInstance.refresh();\n\t\tthis.menuItems = this.menu.find( \"li\" )\n\t\t\t.not( \".ui-selectmenu-optgroup\" )\n\t\t\t\t.find( \".ui-menu-item-wrapper\" );\n\n\t\tthis._rendered = true;\n\n\t\tif ( !options.length ) {\n\t\t\treturn;\n\t\t}\n\n\t\titem = this._getSelectedItem();\n\n\t\t// Update the menu to have the correct item focused\n\t\tthis.menuInstance.focus( null, item );\n\t\tthis._setAria( item.data( \"ui-selectmenu-item\" ) );\n\n\t\t// Set disabled state\n\t\tthis._setOption( \"disabled\", this.element.prop( \"disabled\" ) );\n\t},\n\n\topen: function( event ) {\n\t\tif ( this.options.disabled ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// If this is the first time the menu is being opened, render the items\n\t\tif ( !this._rendered ) {\n\t\t\tthis._refreshMenu();\n\t\t} else {\n\n\t\t\t// Menu clears focus on close, reset focus to selected item\n\t\t\tthis._removeClass( this.menu.find( \".ui-state-active\" ), null, \"ui-state-active\" );\n\t\t\tthis.menuInstance.focus( null, this._getSelectedItem() );\n\t\t}\n\n\t\t// If there are no options, don't open the menu\n\t\tif ( !this.menuItems.length ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.isOpen = true;\n\t\tthis._toggleAttr();\n\t\tthis._resizeMenu();\n\t\tthis._position();\n\n\t\tthis._on( this.document, this._documentClick );\n\n\t\tthis._trigger( \"open\", event );\n\t},\n\n\t_position: function() {\n\t\tthis.menuWrap.position( $.extend( { of: this.button }, this.options.position ) );\n\t},\n\n\tclose: function( event ) {\n\t\tif ( !this.isOpen ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.isOpen = false;\n\t\tthis._toggleAttr();\n\n\t\tthis.range = null;\n\t\tthis._off( this.document );\n\n\t\tthis._trigger( \"close\", event );\n\t},\n\n\twidget: function() {\n\t\treturn this.button;\n\t},\n\n\tmenuWidget: function() {\n\t\treturn this.menu;\n\t},\n\n\t_renderButtonItem: function( item ) {\n\t\tvar buttonItem = $( \"<span>\" );\n\n\t\tthis._setText( buttonItem, item.label );\n\t\tthis._addClass( buttonItem, \"ui-selectmenu-text\" );\n\n\t\treturn buttonItem;\n\t},\n\n\t_renderMenu: function( ul, items ) {\n\t\tvar that = this,\n\t\t\tcurrentOptgroup = \"\";\n\n\t\t$.each( items, function( index, item ) {\n\t\t\tvar li;\n\n\t\t\tif ( item.optgroup !== currentOptgroup ) {\n\t\t\t\tli = $( \"<li>\", {\n\t\t\t\t\ttext: item.optgroup\n\t\t\t\t} );\n\t\t\t\tthat._addClass( li, \"ui-selectmenu-optgroup\", \"ui-menu-divider\" +\n\t\t\t\t\t( item.element.parent( \"optgroup\" ).prop( \"disabled\" ) ?\n\t\t\t\t\t\t\" ui-state-disabled\" :\n\t\t\t\t\t\t\"\" ) );\n\n\t\t\t\tli.appendTo( ul );\n\n\t\t\t\tcurrentOptgroup = item.optgroup;\n\t\t\t}\n\n\t\t\tthat._renderItemData( ul, item );\n\t\t} );\n\t},\n\n\t_renderItemData: function( ul, item ) {\n\t\treturn this._renderItem( ul, item ).data( \"ui-selectmenu-item\", item );\n\t},\n\n\t_renderItem: function( ul, item ) {\n\t\tvar li = $( \"<li>\" ),\n\t\t\twrapper = $( \"<div>\", {\n\t\t\t\ttitle: item.element.attr( \"title\" )\n\t\t\t} );\n\n\t\tif ( item.disabled ) {\n\t\t\tthis._addClass( li, null, \"ui-state-disabled\" );\n\t\t}\n\t\tthis._setText( wrapper, item.label );\n\n\t\treturn li.append( wrapper ).appendTo( ul );\n\t},\n\n\t_setText: function( element, value ) {\n\t\tif ( value ) {\n\t\t\telement.text( value );\n\t\t} else {\n\t\t\telement.html( \"&#160;\" );\n\t\t}\n\t},\n\n\t_move: function( direction, event ) {\n\t\tvar item, next,\n\t\t\tfilter = \".ui-menu-item\";\n\n\t\tif ( this.isOpen ) {\n\t\t\titem = this.menuItems.eq( this.focusIndex ).parent( \"li\" );\n\t\t} else {\n\t\t\titem = this.menuItems.eq( this.element[ 0 ].selectedIndex ).parent( \"li\" );\n\t\t\tfilter += \":not(.ui-state-disabled)\";\n\t\t}\n\n\t\tif ( direction === \"first\" || direction === \"last\" ) {\n\t\t\tnext = item[ direction === \"first\" ? \"prevAll\" : \"nextAll\" ]( filter ).eq( -1 );\n\t\t} else {\n\t\t\tnext = item[ direction + \"All\" ]( filter ).eq( 0 );\n\t\t}\n\n\t\tif ( next.length ) {\n\t\t\tthis.menuInstance.focus( event, next );\n\t\t}\n\t},\n\n\t_getSelectedItem: function() {\n\t\treturn this.menuItems.eq( this.element[ 0 ].selectedIndex ).parent( \"li\" );\n\t},\n\n\t_toggle: function( event ) {\n\t\tthis[ this.isOpen ? \"close\" : \"open\" ]( event );\n\t},\n\n\t_setSelection: function() {\n\t\tvar selection;\n\n\t\tif ( !this.range ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( window.getSelection ) {\n\t\t\tselection = window.getSelection();\n\t\t\tselection.removeAllRanges();\n\t\t\tselection.addRange( this.range );\n\n\t\t// Support: IE8\n\t\t} else {\n\t\t\tthis.range.select();\n\t\t}\n\n\t\t// Support: IE\n\t\t// Setting the text selection kills the button focus in IE, but\n\t\t// restoring the focus doesn't kill the selection.\n\t\tthis.button.focus();\n\t},\n\n\t_documentClick: {\n\t\tmousedown: function( event ) {\n\t\t\tif ( !this.isOpen ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( !$( event.target ).closest( \".ui-selectmenu-menu, #\" +\n\t\t\t\t$.escapeSelector( this.ids.button ) ).length ) {\n\t\t\t\tthis.close( event );\n\t\t\t}\n\t\t}\n\t},\n\n\t_buttonEvents: {\n\n\t\t// Prevent text selection from being reset when interacting with the selectmenu (#10144)\n\t\tmousedown: function() {\n\t\t\tvar selection;\n\n\t\t\tif ( window.getSelection ) {\n\t\t\t\tselection = window.getSelection();\n\t\t\t\tif ( selection.rangeCount ) {\n\t\t\t\t\tthis.range = selection.getRangeAt( 0 );\n\t\t\t\t}\n\n\t\t\t// Support: IE8\n\t\t\t} else {\n\t\t\t\tthis.range = document.selection.createRange();\n\t\t\t}\n\t\t},\n\n\t\tclick: function( event ) {\n\t\t\tthis._setSelection();\n\t\t\tthis._toggle( event );\n\t\t},\n\n\t\tkeydown: function( event ) {\n\t\t\tvar preventDefault = true;\n\t\t\tswitch ( event.keyCode ) {\n\t\t\tcase $.ui.keyCode.TAB:\n\t\t\tcase $.ui.keyCode.ESCAPE:\n\t\t\t\tthis.close( event );\n\t\t\t\tpreventDefault = false;\n\t\t\t\tbreak;\n\t\t\tcase $.ui.keyCode.ENTER:\n\t\t\t\tif ( this.isOpen ) {\n\t\t\t\t\tthis._selectFocusedItem( event );\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase $.ui.keyCode.UP:\n\t\t\t\tif ( event.altKey ) {\n\t\t\t\t\tthis._toggle( event );\n\t\t\t\t} else {\n\t\t\t\t\tthis._move( \"prev\", event );\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase $.ui.keyCode.DOWN:\n\t\t\t\tif ( event.altKey ) {\n\t\t\t\t\tthis._toggle( event );\n\t\t\t\t} else {\n\t\t\t\t\tthis._move( \"next\", event );\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase $.ui.keyCode.SPACE:\n\t\t\t\tif ( this.isOpen ) {\n\t\t\t\t\tthis._selectFocusedItem( event );\n\t\t\t\t} else {\n\t\t\t\t\tthis._toggle( event );\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase $.ui.keyCode.LEFT:\n\t\t\t\tthis._move( \"prev\", event );\n\t\t\t\tbreak;\n\t\t\tcase $.ui.keyCode.RIGHT:\n\t\t\t\tthis._move( \"next\", event );\n\t\t\t\tbreak;\n\t\t\tcase $.ui.keyCode.HOME:\n\t\t\tcase $.ui.keyCode.PAGE_UP:\n\t\t\t\tthis._move( \"first\", event );\n\t\t\t\tbreak;\n\t\t\tcase $.ui.keyCode.END:\n\t\t\tcase $.ui.keyCode.PAGE_DOWN:\n\t\t\t\tthis._move( \"last\", event );\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tthis.menu.trigger( event );\n\t\t\t\tpreventDefault = false;\n\t\t\t}\n\n\t\t\tif ( preventDefault ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t}\n\t\t}\n\t},\n\n\t_selectFocusedItem: function( event ) {\n\t\tvar item = this.menuItems.eq( this.focusIndex ).parent( \"li\" );\n\t\tif ( !item.hasClass( \"ui-state-disabled\" ) ) {\n\t\t\tthis._select( item.data( \"ui-selectmenu-item\" ), event );\n\t\t}\n\t},\n\n\t_select: function( item, event ) {\n\t\tvar oldIndex = this.element[ 0 ].selectedIndex;\n\n\t\t// Change native select element\n\t\tthis.element[ 0 ].selectedIndex = item.index;\n\t\tthis.buttonItem.replaceWith( this.buttonItem = this._renderButtonItem( item ) );\n\t\tthis._setAria( item );\n\t\tthis._trigger( \"select\", event, { item: item } );\n\n\t\tif ( item.index !== oldIndex ) {\n\t\t\tthis._trigger( \"change\", event, { item: item } );\n\t\t}\n\n\t\tthis.close( event );\n\t},\n\n\t_setAria: function( item ) {\n\t\tvar id = this.menuItems.eq( item.index ).attr( \"id\" );\n\n\t\tthis.button.attr( {\n\t\t\t\"aria-labelledby\": id,\n\t\t\t\"aria-activedescendant\": id\n\t\t} );\n\t\tthis.menu.attr( \"aria-activedescendant\", id );\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"icons\" ) {\n\t\t\tvar icon = this.button.find( \"span.ui-icon\" );\n\t\t\tthis._removeClass( icon, null, this.options.icons.button )\n\t\t\t\t._addClass( icon, null, value.button );\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\tif ( key === \"appendTo\" ) {\n\t\t\tthis.menuWrap.appendTo( this._appendTo() );\n\t\t}\n\n\t\tif ( key === \"width\" ) {\n\t\t\tthis._resizeButton();\n\t\t}\n\t},\n\n\t_setOptionDisabled: function( value ) {\n\t\tthis._super( value );\n\n\t\tthis.menuInstance.option( \"disabled\", value );\n\t\tthis.button.attr( \"aria-disabled\", value );\n\t\tthis._toggleClass( this.button, null, \"ui-state-disabled\", value );\n\n\t\tthis.element.prop( \"disabled\", value );\n\t\tif ( value ) {\n\t\t\tthis.button.attr( \"tabindex\", -1 );\n\t\t\tthis.close();\n\t\t} else {\n\t\t\tthis.button.attr( \"tabindex\", 0 );\n\t\t}\n\t},\n\n\t_appendTo: function() {\n\t\tvar element = this.options.appendTo;\n\n\t\tif ( element ) {\n\t\t\telement = element.jquery || element.nodeType ?\n\t\t\t\t$( element ) :\n\t\t\t\tthis.document.find( element ).eq( 0 );\n\t\t}\n\n\t\tif ( !element || !element[ 0 ] ) {\n\t\t\telement = this.element.closest( \".ui-front, dialog\" );\n\t\t}\n\n\t\tif ( !element.length ) {\n\t\t\telement = this.document[ 0 ].body;\n\t\t}\n\n\t\treturn element;\n\t},\n\n\t_toggleAttr: function() {\n\t\tthis.button.attr( \"aria-expanded\", this.isOpen );\n\n\t\t// We can't use two _toggleClass() calls here, because we need to make sure\n\t\t// we always remove classes first and add them second, otherwise if both classes have the\n\t\t// same theme class, it will be removed after we add it.\n\t\tthis._removeClass( this.button, \"ui-selectmenu-button-\" +\n\t\t\t( this.isOpen ? \"closed\" : \"open\" ) )\n\t\t\t._addClass( this.button, \"ui-selectmenu-button-\" +\n\t\t\t\t( this.isOpen ? \"open\" : \"closed\" ) )\n\t\t\t._toggleClass( this.menuWrap, \"ui-selectmenu-open\", null, this.isOpen );\n\n\t\tthis.menu.attr( \"aria-hidden\", !this.isOpen );\n\t},\n\n\t_resizeButton: function() {\n\t\tvar width = this.options.width;\n\n\t\t// For `width: false`, just remove inline style and stop\n\t\tif ( width === false ) {\n\t\t\tthis.button.css( \"width\", \"\" );\n\t\t\treturn;\n\t\t}\n\n\t\t// For `width: null`, match the width of the original element\n\t\tif ( width === null ) {\n\t\t\twidth = this.element.show().outerWidth();\n\t\t\tthis.element.hide();\n\t\t}\n\n\t\tthis.button.outerWidth( width );\n\t},\n\n\t_resizeMenu: function() {\n\t\tthis.menu.outerWidth( Math.max(\n\t\t\tthis.button.outerWidth(),\n\n\t\t\t// Support: IE10\n\t\t\t// IE10 wraps long text (possibly a rounding bug)\n\t\t\t// so we add 1px to avoid the wrapping\n\t\t\tthis.menu.width( \"\" ).outerWidth() + 1\n\t\t) );\n\t},\n\n\t_getCreateOptions: function() {\n\t\tvar options = this._super();\n\n\t\toptions.disabled = this.element.prop( \"disabled\" );\n\n\t\treturn options;\n\t},\n\n\t_parseOptions: function( options ) {\n\t\tvar that = this,\n\t\t\tdata = [];\n\t\toptions.each( function( index, item ) {\n\t\t\tif ( item.hidden ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tdata.push( that._parseOption( $( item ), index ) );\n\t\t} );\n\t\tthis.items = data;\n\t},\n\n\t_parseOption: function( option, index ) {\n\t\tvar optgroup = option.parent( \"optgroup\" );\n\n\t\treturn {\n\t\t\telement: option,\n\t\t\tindex: index,\n\t\t\tvalue: option.val(),\n\t\t\tlabel: option.text(),\n\t\t\toptgroup: optgroup.attr( \"label\" ) || \"\",\n\t\t\tdisabled: optgroup.prop( \"disabled\" ) || option.prop( \"disabled\" )\n\t\t};\n\t},\n\n\t_destroy: function() {\n\t\tthis._unbindFormResetHandler();\n\t\tthis.menuWrap.remove();\n\t\tthis.button.remove();\n\t\tthis.element.show();\n\t\tthis.element.removeUniqueId();\n\t\tthis.labels.attr( \"for\", this.ids.element );\n\t}\n} ] );\n\n} );\n","jquery/ui-modules/widgets/menu.js":"/*!\n * jQuery UI Menu 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Menu\n//>>group: Widgets\n//>>description: Creates nestable menus.\n//>>docs: http://api.jqueryui.com/menu/\n//>>demos: http://jqueryui.com/menu/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/menu.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../keycode\",\n\t\t\t\"../position\",\n\t\t\t\"../safe-active-element\",\n\t\t\t\"../unique-id\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.widget( \"ui.menu\", {\n\tversion: \"1.13.1\",\n\tdefaultElement: \"<ul>\",\n\tdelay: 300,\n\toptions: {\n\t\ticons: {\n\t\t\tsubmenu: \"ui-icon-caret-1-e\"\n\t\t},\n\t\titems: \"> *\",\n\t\tmenus: \"ul\",\n\t\tposition: {\n\t\t\tmy: \"left top\",\n\t\t\tat: \"right top\"\n\t\t},\n\t\trole: \"menu\",\n\n\t\t// Callbacks\n\t\tblur: null,\n\t\tfocus: null,\n\t\tselect: null\n\t},\n\n\t_create: function() {\n\t\tthis.activeMenu = this.element;\n\n\t\t// Flag used to prevent firing of the click handler\n\t\t// as the event bubbles up through nested menus\n\t\tthis.mouseHandled = false;\n\t\tthis.lastMousePosition = { x: null, y: null };\n\t\tthis.element\n\t\t\t.uniqueId()\n\t\t\t.attr( {\n\t\t\t\trole: this.options.role,\n\t\t\t\ttabIndex: 0\n\t\t\t} );\n\n\t\tthis._addClass( \"ui-menu\", \"ui-widget ui-widget-content\" );\n\t\tthis._on( {\n\n\t\t\t// Prevent focus from sticking to links inside menu after clicking\n\t\t\t// them (focus should always stay on UL during navigation).\n\t\t\t\"mousedown .ui-menu-item\": function( event ) {\n\t\t\t\tevent.preventDefault();\n\n\t\t\t\tthis._activateItem( event );\n\t\t\t},\n\t\t\t\"click .ui-menu-item\": function( event ) {\n\t\t\t\tvar target = $( event.target );\n\t\t\t\tvar active = $( $.ui.safeActiveElement( this.document[ 0 ] ) );\n\t\t\t\tif ( !this.mouseHandled && target.not( \".ui-state-disabled\" ).length ) {\n\t\t\t\t\tthis.select( event );\n\n\t\t\t\t\t// Only set the mouseHandled flag if the event will bubble, see #9469.\n\t\t\t\t\tif ( !event.isPropagationStopped() ) {\n\t\t\t\t\t\tthis.mouseHandled = true;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Open submenu on click\n\t\t\t\t\tif ( target.has( \".ui-menu\" ).length ) {\n\t\t\t\t\t\tthis.expand( event );\n\t\t\t\t\t} else if ( !this.element.is( \":focus\" ) &&\n\t\t\t\t\t\t\tactive.closest( \".ui-menu\" ).length ) {\n\n\t\t\t\t\t\t// Redirect focus to the menu\n\t\t\t\t\t\tthis.element.trigger( \"focus\", [ true ] );\n\n\t\t\t\t\t\t// If the active item is on the top level, let it stay active.\n\t\t\t\t\t\t// Otherwise, blur the active item since it is no longer visible.\n\t\t\t\t\t\tif ( this.active && this.active.parents( \".ui-menu\" ).length === 1 ) {\n\t\t\t\t\t\t\tclearTimeout( this.timer );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\t\"mouseenter .ui-menu-item\": \"_activateItem\",\n\t\t\t\"mousemove .ui-menu-item\": \"_activateItem\",\n\t\t\tmouseleave: \"collapseAll\",\n\t\t\t\"mouseleave .ui-menu\": \"collapseAll\",\n\t\t\tfocus: function( event, keepActiveItem ) {\n\n\t\t\t\t// If there's already an active item, keep it active\n\t\t\t\t// If not, activate the first item\n\t\t\t\tvar item = this.active || this._menuItems().first();\n\n\t\t\t\tif ( !keepActiveItem ) {\n\t\t\t\t\tthis.focus( event, item );\n\t\t\t\t}\n\t\t\t},\n\t\t\tblur: function( event ) {\n\t\t\t\tthis._delay( function() {\n\t\t\t\t\tvar notContained = !$.contains(\n\t\t\t\t\t\tthis.element[ 0 ],\n\t\t\t\t\t\t$.ui.safeActiveElement( this.document[ 0 ] )\n\t\t\t\t\t);\n\t\t\t\t\tif ( notContained ) {\n\t\t\t\t\t\tthis.collapseAll( event );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t},\n\t\t\tkeydown: \"_keydown\"\n\t\t} );\n\n\t\tthis.refresh();\n\n\t\t// Clicks outside of a menu collapse any open menus\n\t\tthis._on( this.document, {\n\t\t\tclick: function( event ) {\n\t\t\t\tif ( this._closeOnDocumentClick( event ) ) {\n\t\t\t\t\tthis.collapseAll( event, true );\n\t\t\t\t}\n\n\t\t\t\t// Reset the mouseHandled flag\n\t\t\t\tthis.mouseHandled = false;\n\t\t\t}\n\t\t} );\n\t},\n\n\t_activateItem: function( event ) {\n\n\t\t// Ignore mouse events while typeahead is active, see #10458.\n\t\t// Prevents focusing the wrong item when typeahead causes a scroll while the mouse\n\t\t// is over an item in the menu\n\t\tif ( this.previousFilter ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// If the mouse didn't actually move, but the page was scrolled, ignore the event (#9356)\n\t\tif ( event.clientX === this.lastMousePosition.x &&\n\t\t\t\tevent.clientY === this.lastMousePosition.y ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.lastMousePosition = {\n\t\t\tx: event.clientX,\n\t\t\ty: event.clientY\n\t\t};\n\n\t\tvar actualTarget = $( event.target ).closest( \".ui-menu-item\" ),\n\t\t\ttarget = $( event.currentTarget );\n\n\t\t// Ignore bubbled events on parent items, see #11641\n\t\tif ( actualTarget[ 0 ] !== target[ 0 ] ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// If the item is already active, there's nothing to do\n\t\tif ( target.is( \".ui-state-active\" ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Remove ui-state-active class from siblings of the newly focused menu item\n\t\t// to avoid a jump caused by adjacent elements both having a class with a border\n\t\tthis._removeClass( target.siblings().children( \".ui-state-active\" ),\n\t\t\tnull, \"ui-state-active\" );\n\t\tthis.focus( event, target );\n\t},\n\n\t_destroy: function() {\n\t\tvar items = this.element.find( \".ui-menu-item\" )\n\t\t\t\t.removeAttr( \"role aria-disabled\" ),\n\t\t\tsubmenus = items.children( \".ui-menu-item-wrapper\" )\n\t\t\t\t.removeUniqueId()\n\t\t\t\t.removeAttr( \"tabIndex role aria-haspopup\" );\n\n\t\t// Destroy (sub)menus\n\t\tthis.element\n\t\t\t.removeAttr( \"aria-activedescendant\" )\n\t\t\t.find( \".ui-menu\" ).addBack()\n\t\t\t\t.removeAttr( \"role aria-labelledby aria-expanded aria-hidden aria-disabled \" +\n\t\t\t\t\t\"tabIndex\" )\n\t\t\t\t.removeUniqueId()\n\t\t\t\t.show();\n\n\t\tsubmenus.children().each( function() {\n\t\t\tvar elem = $( this );\n\t\t\tif ( elem.data( \"ui-menu-submenu-caret\" ) ) {\n\t\t\t\telem.remove();\n\t\t\t}\n\t\t} );\n\t},\n\n\t_keydown: function( event ) {\n\t\tvar match, prev, character, skip,\n\t\t\tpreventDefault = true;\n\n\t\tswitch ( event.keyCode ) {\n\t\tcase $.ui.keyCode.PAGE_UP:\n\t\t\tthis.previousPage( event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.PAGE_DOWN:\n\t\t\tthis.nextPage( event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.HOME:\n\t\t\tthis._move( \"first\", \"first\", event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.END:\n\t\t\tthis._move( \"last\", \"last\", event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.UP:\n\t\t\tthis.previous( event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.DOWN:\n\t\t\tthis.next( event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.LEFT:\n\t\t\tthis.collapse( event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.RIGHT:\n\t\t\tif ( this.active && !this.active.is( \".ui-state-disabled\" ) ) {\n\t\t\t\tthis.expand( event );\n\t\t\t}\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.ENTER:\n\t\tcase $.ui.keyCode.SPACE:\n\t\t\tthis._activate( event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.ESCAPE:\n\t\t\tthis.collapse( event );\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tpreventDefault = false;\n\t\t\tprev = this.previousFilter || \"\";\n\t\t\tskip = false;\n\n\t\t\t// Support number pad values\n\t\t\tcharacter = event.keyCode >= 96 && event.keyCode <= 105 ?\n\t\t\t\t( event.keyCode - 96 ).toString() : String.fromCharCode( event.keyCode );\n\n\t\t\tclearTimeout( this.filterTimer );\n\n\t\t\tif ( character === prev ) {\n\t\t\t\tskip = true;\n\t\t\t} else {\n\t\t\t\tcharacter = prev + character;\n\t\t\t}\n\n\t\t\tmatch = this._filterMenuItems( character );\n\t\t\tmatch = skip && match.index( this.active.next() ) !== -1 ?\n\t\t\t\tthis.active.nextAll( \".ui-menu-item\" ) :\n\t\t\t\tmatch;\n\n\t\t\t// If no matches on the current filter, reset to the last character pressed\n\t\t\t// to move down the menu to the first item that starts with that character\n\t\t\tif ( !match.length ) {\n\t\t\t\tcharacter = String.fromCharCode( event.keyCode );\n\t\t\t\tmatch = this._filterMenuItems( character );\n\t\t\t}\n\n\t\t\tif ( match.length ) {\n\t\t\t\tthis.focus( event, match );\n\t\t\t\tthis.previousFilter = character;\n\t\t\t\tthis.filterTimer = this._delay( function() {\n\t\t\t\t\tdelete this.previousFilter;\n\t\t\t\t}, 1000 );\n\t\t\t} else {\n\t\t\t\tdelete this.previousFilter;\n\t\t\t}\n\t\t}\n\n\t\tif ( preventDefault ) {\n\t\t\tevent.preventDefault();\n\t\t}\n\t},\n\n\t_activate: function( event ) {\n\t\tif ( this.active && !this.active.is( \".ui-state-disabled\" ) ) {\n\t\t\tif ( this.active.children( \"[aria-haspopup='true']\" ).length ) {\n\t\t\t\tthis.expand( event );\n\t\t\t} else {\n\t\t\t\tthis.select( event );\n\t\t\t}\n\t\t}\n\t},\n\n\trefresh: function() {\n\t\tvar menus, items, newSubmenus, newItems, newWrappers,\n\t\t\tthat = this,\n\t\t\ticon = this.options.icons.submenu,\n\t\t\tsubmenus = this.element.find( this.options.menus );\n\n\t\tthis._toggleClass( \"ui-menu-icons\", null, !!this.element.find( \".ui-icon\" ).length );\n\n\t\t// Initialize nested menus\n\t\tnewSubmenus = submenus.filter( \":not(.ui-menu)\" )\n\t\t\t.hide()\n\t\t\t.attr( {\n\t\t\t\trole: this.options.role,\n\t\t\t\t\"aria-hidden\": \"true\",\n\t\t\t\t\"aria-expanded\": \"false\"\n\t\t\t} )\n\t\t\t.each( function() {\n\t\t\t\tvar menu = $( this ),\n\t\t\t\t\titem = menu.prev(),\n\t\t\t\t\tsubmenuCaret = $( \"<span>\" ).data( \"ui-menu-submenu-caret\", true );\n\n\t\t\t\tthat._addClass( submenuCaret, \"ui-menu-icon\", \"ui-icon \" + icon );\n\t\t\t\titem\n\t\t\t\t\t.attr( \"aria-haspopup\", \"true\" )\n\t\t\t\t\t.prepend( submenuCaret );\n\t\t\t\tmenu.attr( \"aria-labelledby\", item.attr( \"id\" ) );\n\t\t\t} );\n\n\t\tthis._addClass( newSubmenus, \"ui-menu\", \"ui-widget ui-widget-content ui-front\" );\n\n\t\tmenus = submenus.add( this.element );\n\t\titems = menus.find( this.options.items );\n\n\t\t// Initialize menu-items containing spaces and/or dashes only as dividers\n\t\titems.not( \".ui-menu-item\" ).each( function() {\n\t\t\tvar item = $( this );\n\t\t\tif ( that._isDivider( item ) ) {\n\t\t\t\tthat._addClass( item, \"ui-menu-divider\", \"ui-widget-content\" );\n\t\t\t}\n\t\t} );\n\n\t\t// Don't refresh list items that are already adapted\n\t\tnewItems = items.not( \".ui-menu-item, .ui-menu-divider\" );\n\t\tnewWrappers = newItems.children()\n\t\t\t.not( \".ui-menu\" )\n\t\t\t\t.uniqueId()\n\t\t\t\t.attr( {\n\t\t\t\t\ttabIndex: -1,\n\t\t\t\t\trole: this._itemRole()\n\t\t\t\t} );\n\t\tthis._addClass( newItems, \"ui-menu-item\" )\n\t\t\t._addClass( newWrappers, \"ui-menu-item-wrapper\" );\n\n\t\t// Add aria-disabled attribute to any disabled menu item\n\t\titems.filter( \".ui-state-disabled\" ).attr( \"aria-disabled\", \"true\" );\n\n\t\t// If the active item has been removed, blur the menu\n\t\tif ( this.active && !$.contains( this.element[ 0 ], this.active[ 0 ] ) ) {\n\t\t\tthis.blur();\n\t\t}\n\t},\n\n\t_itemRole: function() {\n\t\treturn {\n\t\t\tmenu: \"menuitem\",\n\t\t\tlistbox: \"option\"\n\t\t}[ this.options.role ];\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"icons\" ) {\n\t\t\tvar icons = this.element.find( \".ui-menu-icon\" );\n\t\t\tthis._removeClass( icons, null, this.options.icons.submenu )\n\t\t\t\t._addClass( icons, null, value.submenu );\n\t\t}\n\t\tthis._super( key, value );\n\t},\n\n\t_setOptionDisabled: function( value ) {\n\t\tthis._super( value );\n\n\t\tthis.element.attr( \"aria-disabled\", String( value ) );\n\t\tthis._toggleClass( null, \"ui-state-disabled\", !!value );\n\t},\n\n\tfocus: function( event, item ) {\n\t\tvar nested, focused, activeParent;\n\t\tthis.blur( event, event && event.type === \"focus\" );\n\n\t\tthis._scrollIntoView( item );\n\n\t\tthis.active = item.first();\n\n\t\tfocused = this.active.children( \".ui-menu-item-wrapper\" );\n\t\tthis._addClass( focused, null, \"ui-state-active\" );\n\n\t\t// Only update aria-activedescendant if there's a role\n\t\t// otherwise we assume focus is managed elsewhere\n\t\tif ( this.options.role ) {\n\t\t\tthis.element.attr( \"aria-activedescendant\", focused.attr( \"id\" ) );\n\t\t}\n\n\t\t// Highlight active parent menu item, if any\n\t\tactiveParent = this.active\n\t\t\t.parent()\n\t\t\t\t.closest( \".ui-menu-item\" )\n\t\t\t\t\t.children( \".ui-menu-item-wrapper\" );\n\t\tthis._addClass( activeParent, null, \"ui-state-active\" );\n\n\t\tif ( event && event.type === \"keydown\" ) {\n\t\t\tthis._close();\n\t\t} else {\n\t\t\tthis.timer = this._delay( function() {\n\t\t\t\tthis._close();\n\t\t\t}, this.delay );\n\t\t}\n\n\t\tnested = item.children( \".ui-menu\" );\n\t\tif ( nested.length && event && ( /^mouse/.test( event.type ) ) ) {\n\t\t\tthis._startOpening( nested );\n\t\t}\n\t\tthis.activeMenu = item.parent();\n\n\t\tthis._trigger( \"focus\", event, { item: item } );\n\t},\n\n\t_scrollIntoView: function( item ) {\n\t\tvar borderTop, paddingTop, offset, scroll, elementHeight, itemHeight;\n\t\tif ( this._hasScroll() ) {\n\t\t\tborderTop = parseFloat( $.css( this.activeMenu[ 0 ], \"borderTopWidth\" ) ) || 0;\n\t\t\tpaddingTop = parseFloat( $.css( this.activeMenu[ 0 ], \"paddingTop\" ) ) || 0;\n\t\t\toffset = item.offset().top - this.activeMenu.offset().top - borderTop - paddingTop;\n\t\t\tscroll = this.activeMenu.scrollTop();\n\t\t\telementHeight = this.activeMenu.height();\n\t\t\titemHeight = item.outerHeight();\n\n\t\t\tif ( offset < 0 ) {\n\t\t\t\tthis.activeMenu.scrollTop( scroll + offset );\n\t\t\t} else if ( offset + itemHeight > elementHeight ) {\n\t\t\t\tthis.activeMenu.scrollTop( scroll + offset - elementHeight + itemHeight );\n\t\t\t}\n\t\t}\n\t},\n\n\tblur: function( event, fromFocus ) {\n\t\tif ( !fromFocus ) {\n\t\t\tclearTimeout( this.timer );\n\t\t}\n\n\t\tif ( !this.active ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis._removeClass( this.active.children( \".ui-menu-item-wrapper\" ),\n\t\t\tnull, \"ui-state-active\" );\n\n\t\tthis._trigger( \"blur\", event, { item: this.active } );\n\t\tthis.active = null;\n\t},\n\n\t_startOpening: function( submenu ) {\n\t\tclearTimeout( this.timer );\n\n\t\t// Don't open if already open fixes a Firefox bug that caused a .5 pixel\n\t\t// shift in the submenu position when mousing over the caret icon\n\t\tif ( submenu.attr( \"aria-hidden\" ) !== \"true\" ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.timer = this._delay( function() {\n\t\t\tthis._close();\n\t\t\tthis._open( submenu );\n\t\t}, this.delay );\n\t},\n\n\t_open: function( submenu ) {\n\t\tvar position = $.extend( {\n\t\t\tof: this.active\n\t\t}, this.options.position );\n\n\t\tclearTimeout( this.timer );\n\t\tthis.element.find( \".ui-menu\" ).not( submenu.parents( \".ui-menu\" ) )\n\t\t\t.hide()\n\t\t\t.attr( \"aria-hidden\", \"true\" );\n\n\t\tsubmenu\n\t\t\t.show()\n\t\t\t.removeAttr( \"aria-hidden\" )\n\t\t\t.attr( \"aria-expanded\", \"true\" )\n\t\t\t.position( position );\n\t},\n\n\tcollapseAll: function( event, all ) {\n\t\tclearTimeout( this.timer );\n\t\tthis.timer = this._delay( function() {\n\n\t\t\t// If we were passed an event, look for the submenu that contains the event\n\t\t\tvar currentMenu = all ? this.element :\n\t\t\t\t$( event && event.target ).closest( this.element.find( \".ui-menu\" ) );\n\n\t\t\t// If we found no valid submenu ancestor, use the main menu to close all\n\t\t\t// sub menus anyway\n\t\t\tif ( !currentMenu.length ) {\n\t\t\t\tcurrentMenu = this.element;\n\t\t\t}\n\n\t\t\tthis._close( currentMenu );\n\n\t\t\tthis.blur( event );\n\n\t\t\t// Work around active item staying active after menu is blurred\n\t\t\tthis._removeClass( currentMenu.find( \".ui-state-active\" ), null, \"ui-state-active\" );\n\n\t\t\tthis.activeMenu = currentMenu;\n\t\t}, all ? 0 : this.delay );\n\t},\n\n\t// With no arguments, closes the currently active menu - if nothing is active\n\t// it closes all menus.  If passed an argument, it will search for menus BELOW\n\t_close: function( startMenu ) {\n\t\tif ( !startMenu ) {\n\t\t\tstartMenu = this.active ? this.active.parent() : this.element;\n\t\t}\n\n\t\tstartMenu.find( \".ui-menu\" )\n\t\t\t.hide()\n\t\t\t.attr( \"aria-hidden\", \"true\" )\n\t\t\t.attr( \"aria-expanded\", \"false\" );\n\t},\n\n\t_closeOnDocumentClick: function( event ) {\n\t\treturn !$( event.target ).closest( \".ui-menu\" ).length;\n\t},\n\n\t_isDivider: function( item ) {\n\n\t\t// Match hyphen, em dash, en dash\n\t\treturn !/[^\\-\\u2014\\u2013\\s]/.test( item.text() );\n\t},\n\n\tcollapse: function( event ) {\n\t\tvar newItem = this.active &&\n\t\t\tthis.active.parent().closest( \".ui-menu-item\", this.element );\n\t\tif ( newItem && newItem.length ) {\n\t\t\tthis._close();\n\t\t\tthis.focus( event, newItem );\n\t\t}\n\t},\n\n\texpand: function( event ) {\n\t\tvar newItem = this.active && this._menuItems( this.active.children( \".ui-menu\" ) ).first();\n\n\t\tif ( newItem && newItem.length ) {\n\t\t\tthis._open( newItem.parent() );\n\n\t\t\t// Delay so Firefox will not hide activedescendant change in expanding submenu from AT\n\t\t\tthis._delay( function() {\n\t\t\t\tthis.focus( event, newItem );\n\t\t\t} );\n\t\t}\n\t},\n\n\tnext: function( event ) {\n\t\tthis._move( \"next\", \"first\", event );\n\t},\n\n\tprevious: function( event ) {\n\t\tthis._move( \"prev\", \"last\", event );\n\t},\n\n\tisFirstItem: function() {\n\t\treturn this.active && !this.active.prevAll( \".ui-menu-item\" ).length;\n\t},\n\n\tisLastItem: function() {\n\t\treturn this.active && !this.active.nextAll( \".ui-menu-item\" ).length;\n\t},\n\n\t_menuItems: function( menu ) {\n\t\treturn ( menu || this.element )\n\t\t\t.find( this.options.items )\n\t\t\t.filter( \".ui-menu-item\" );\n\t},\n\n\t_move: function( direction, filter, event ) {\n\t\tvar next;\n\t\tif ( this.active ) {\n\t\t\tif ( direction === \"first\" || direction === \"last\" ) {\n\t\t\t\tnext = this.active\n\t\t\t\t\t[ direction === \"first\" ? \"prevAll\" : \"nextAll\" ]( \".ui-menu-item\" )\n\t\t\t\t\t.last();\n\t\t\t} else {\n\t\t\t\tnext = this.active\n\t\t\t\t\t[ direction + \"All\" ]( \".ui-menu-item\" )\n\t\t\t\t\t.first();\n\t\t\t}\n\t\t}\n\t\tif ( !next || !next.length || !this.active ) {\n\t\t\tnext = this._menuItems( this.activeMenu )[ filter ]();\n\t\t}\n\n\t\tthis.focus( event, next );\n\t},\n\n\tnextPage: function( event ) {\n\t\tvar item, base, height;\n\n\t\tif ( !this.active ) {\n\t\t\tthis.next( event );\n\t\t\treturn;\n\t\t}\n\t\tif ( this.isLastItem() ) {\n\t\t\treturn;\n\t\t}\n\t\tif ( this._hasScroll() ) {\n\t\t\tbase = this.active.offset().top;\n\t\t\theight = this.element.innerHeight();\n\n\t\t\t// jQuery 3.2 doesn't include scrollbars in innerHeight, add it back.\n\t\t\tif ( $.fn.jquery.indexOf( \"3.2.\" ) === 0 ) {\n\t\t\t\theight += this.element[ 0 ].offsetHeight - this.element.outerHeight();\n\t\t\t}\n\n\t\t\tthis.active.nextAll( \".ui-menu-item\" ).each( function() {\n\t\t\t\titem = $( this );\n\t\t\t\treturn item.offset().top - base - height < 0;\n\t\t\t} );\n\n\t\t\tthis.focus( event, item );\n\t\t} else {\n\t\t\tthis.focus( event, this._menuItems( this.activeMenu )\n\t\t\t\t[ !this.active ? \"first\" : \"last\" ]() );\n\t\t}\n\t},\n\n\tpreviousPage: function( event ) {\n\t\tvar item, base, height;\n\t\tif ( !this.active ) {\n\t\t\tthis.next( event );\n\t\t\treturn;\n\t\t}\n\t\tif ( this.isFirstItem() ) {\n\t\t\treturn;\n\t\t}\n\t\tif ( this._hasScroll() ) {\n\t\t\tbase = this.active.offset().top;\n\t\t\theight = this.element.innerHeight();\n\n\t\t\t// jQuery 3.2 doesn't include scrollbars in innerHeight, add it back.\n\t\t\tif ( $.fn.jquery.indexOf( \"3.2.\" ) === 0 ) {\n\t\t\t\theight += this.element[ 0 ].offsetHeight - this.element.outerHeight();\n\t\t\t}\n\n\t\t\tthis.active.prevAll( \".ui-menu-item\" ).each( function() {\n\t\t\t\titem = $( this );\n\t\t\t\treturn item.offset().top - base + height > 0;\n\t\t\t} );\n\n\t\t\tthis.focus( event, item );\n\t\t} else {\n\t\t\tthis.focus( event, this._menuItems( this.activeMenu ).first() );\n\t\t}\n\t},\n\n\t_hasScroll: function() {\n\t\treturn this.element.outerHeight() < this.element.prop( \"scrollHeight\" );\n\t},\n\n\tselect: function( event ) {\n\n\t\t// TODO: It should never be possible to not have an active item at this\n\t\t// point, but the tests don't trigger mouseenter before click.\n\t\tthis.active = this.active || $( event.target ).closest( \".ui-menu-item\" );\n\t\tvar ui = { item: this.active };\n\t\tif ( !this.active.has( \".ui-menu\" ).length ) {\n\t\t\tthis.collapseAll( event, true );\n\t\t}\n\t\tthis._trigger( \"select\", event, ui );\n\t},\n\n\t_filterMenuItems: function( character ) {\n\t\tvar escapedCharacter = character.replace( /[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, \"\\\\$&\" ),\n\t\t\tregex = new RegExp( \"^\" + escapedCharacter, \"i\" );\n\n\t\treturn this.activeMenu\n\t\t\t.find( this.options.items )\n\n\t\t\t\t// Only match on items, not dividers or other content (#10571)\n\t\t\t\t.filter( \".ui-menu-item\" )\n\t\t\t\t\t.filter( function() {\n\t\t\t\t\t\treturn regex.test(\n\t\t\t\t\t\t\tString.prototype.trim.call(\n\t\t\t\t\t\t\t\t$( this ).children( \".ui-menu-item-wrapper\" ).text() ) );\n\t\t\t\t\t} );\n\t}\n} );\n\n} );\n","jquery/ui-modules/widgets/controlgroup.js":"/*!\n * jQuery UI Controlgroup 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Controlgroup\n//>>group: Widgets\n//>>description: Visually groups form control widgets\n//>>docs: http://api.jqueryui.com/controlgroup/\n//>>demos: http://jqueryui.com/controlgroup/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/controlgroup.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nvar controlgroupCornerRegex = /ui-corner-([a-z]){2,6}/g;\n\nreturn $.widget( \"ui.controlgroup\", {\n\tversion: \"1.13.1\",\n\tdefaultElement: \"<div>\",\n\toptions: {\n\t\tdirection: \"horizontal\",\n\t\tdisabled: null,\n\t\tonlyVisible: true,\n\t\titems: {\n\t\t\t\"button\": \"input[type=button], input[type=submit], input[type=reset], button, a\",\n\t\t\t\"controlgroupLabel\": \".ui-controlgroup-label\",\n\t\t\t\"checkboxradio\": \"input[type='checkbox'], input[type='radio']\",\n\t\t\t\"selectmenu\": \"select\",\n\t\t\t\"spinner\": \".ui-spinner-input\"\n\t\t}\n\t},\n\n\t_create: function() {\n\t\tthis._enhance();\n\t},\n\n\t// To support the enhanced option in jQuery Mobile, we isolate DOM manipulation\n\t_enhance: function() {\n\t\tthis.element.attr( \"role\", \"toolbar\" );\n\t\tthis.refresh();\n\t},\n\n\t_destroy: function() {\n\t\tthis._callChildMethod( \"destroy\" );\n\t\tthis.childWidgets.removeData( \"ui-controlgroup-data\" );\n\t\tthis.element.removeAttr( \"role\" );\n\t\tif ( this.options.items.controlgroupLabel ) {\n\t\t\tthis.element\n\t\t\t\t.find( this.options.items.controlgroupLabel )\n\t\t\t\t.find( \".ui-controlgroup-label-contents\" )\n\t\t\t\t.contents().unwrap();\n\t\t}\n\t},\n\n\t_initWidgets: function() {\n\t\tvar that = this,\n\t\t\tchildWidgets = [];\n\n\t\t// First we iterate over each of the items options\n\t\t$.each( this.options.items, function( widget, selector ) {\n\t\t\tvar labels;\n\t\t\tvar options = {};\n\n\t\t\t// Make sure the widget has a selector set\n\t\t\tif ( !selector ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( widget === \"controlgroupLabel\" ) {\n\t\t\t\tlabels = that.element.find( selector );\n\t\t\t\tlabels.each( function() {\n\t\t\t\t\tvar element = $( this );\n\n\t\t\t\t\tif ( element.children( \".ui-controlgroup-label-contents\" ).length ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\telement.contents()\n\t\t\t\t\t\t.wrapAll( \"<span class='ui-controlgroup-label-contents'></span>\" );\n\t\t\t\t} );\n\t\t\t\tthat._addClass( labels, null, \"ui-widget ui-widget-content ui-state-default\" );\n\t\t\t\tchildWidgets = childWidgets.concat( labels.get() );\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Make sure the widget actually exists\n\t\t\tif ( !$.fn[ widget ] ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// We assume everything is in the middle to start because we can't determine\n\t\t\t// first / last elements until all enhancments are done.\n\t\t\tif ( that[ \"_\" + widget + \"Options\" ] ) {\n\t\t\t\toptions = that[ \"_\" + widget + \"Options\" ]( \"middle\" );\n\t\t\t} else {\n\t\t\t\toptions = { classes: {} };\n\t\t\t}\n\n\t\t\t// Find instances of this widget inside controlgroup and init them\n\t\t\tthat.element\n\t\t\t\t.find( selector )\n\t\t\t\t.each( function() {\n\t\t\t\t\tvar element = $( this );\n\t\t\t\t\tvar instance = element[ widget ]( \"instance\" );\n\n\t\t\t\t\t// We need to clone the default options for this type of widget to avoid\n\t\t\t\t\t// polluting the variable options which has a wider scope than a single widget.\n\t\t\t\t\tvar instanceOptions = $.widget.extend( {}, options );\n\n\t\t\t\t\t// If the button is the child of a spinner ignore it\n\t\t\t\t\t// TODO: Find a more generic solution\n\t\t\t\t\tif ( widget === \"button\" && element.parent( \".ui-spinner\" ).length ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Create the widget if it doesn't exist\n\t\t\t\t\tif ( !instance ) {\n\t\t\t\t\t\tinstance = element[ widget ]()[ widget ]( \"instance\" );\n\t\t\t\t\t}\n\t\t\t\t\tif ( instance ) {\n\t\t\t\t\t\tinstanceOptions.classes =\n\t\t\t\t\t\t\tthat._resolveClassesValues( instanceOptions.classes, instance );\n\t\t\t\t\t}\n\t\t\t\t\telement[ widget ]( instanceOptions );\n\n\t\t\t\t\t// Store an instance of the controlgroup to be able to reference\n\t\t\t\t\t// from the outermost element for changing options and refresh\n\t\t\t\t\tvar widgetElement = element[ widget ]( \"widget\" );\n\t\t\t\t\t$.data( widgetElement[ 0 ], \"ui-controlgroup-data\",\n\t\t\t\t\t\tinstance ? instance : element[ widget ]( \"instance\" ) );\n\n\t\t\t\t\tchildWidgets.push( widgetElement[ 0 ] );\n\t\t\t\t} );\n\t\t} );\n\n\t\tthis.childWidgets = $( $.uniqueSort( childWidgets ) );\n\t\tthis._addClass( this.childWidgets, \"ui-controlgroup-item\" );\n\t},\n\n\t_callChildMethod: function( method ) {\n\t\tthis.childWidgets.each( function() {\n\t\t\tvar element = $( this ),\n\t\t\t\tdata = element.data( \"ui-controlgroup-data\" );\n\t\t\tif ( data && data[ method ] ) {\n\t\t\t\tdata[ method ]();\n\t\t\t}\n\t\t} );\n\t},\n\n\t_updateCornerClass: function( element, position ) {\n\t\tvar remove = \"ui-corner-top ui-corner-bottom ui-corner-left ui-corner-right ui-corner-all\";\n\t\tvar add = this._buildSimpleOptions( position, \"label\" ).classes.label;\n\n\t\tthis._removeClass( element, null, remove );\n\t\tthis._addClass( element, null, add );\n\t},\n\n\t_buildSimpleOptions: function( position, key ) {\n\t\tvar direction = this.options.direction === \"vertical\";\n\t\tvar result = {\n\t\t\tclasses: {}\n\t\t};\n\t\tresult.classes[ key ] = {\n\t\t\t\"middle\": \"\",\n\t\t\t\"first\": \"ui-corner-\" + ( direction ? \"top\" : \"left\" ),\n\t\t\t\"last\": \"ui-corner-\" + ( direction ? \"bottom\" : \"right\" ),\n\t\t\t\"only\": \"ui-corner-all\"\n\t\t}[ position ];\n\n\t\treturn result;\n\t},\n\n\t_spinnerOptions: function( position ) {\n\t\tvar options = this._buildSimpleOptions( position, \"ui-spinner\" );\n\n\t\toptions.classes[ \"ui-spinner-up\" ] = \"\";\n\t\toptions.classes[ \"ui-spinner-down\" ] = \"\";\n\n\t\treturn options;\n\t},\n\n\t_buttonOptions: function( position ) {\n\t\treturn this._buildSimpleOptions( position, \"ui-button\" );\n\t},\n\n\t_checkboxradioOptions: function( position ) {\n\t\treturn this._buildSimpleOptions( position, \"ui-checkboxradio-label\" );\n\t},\n\n\t_selectmenuOptions: function( position ) {\n\t\tvar direction = this.options.direction === \"vertical\";\n\t\treturn {\n\t\t\twidth: direction ? \"auto\" : false,\n\t\t\tclasses: {\n\t\t\t\tmiddle: {\n\t\t\t\t\t\"ui-selectmenu-button-open\": \"\",\n\t\t\t\t\t\"ui-selectmenu-button-closed\": \"\"\n\t\t\t\t},\n\t\t\t\tfirst: {\n\t\t\t\t\t\"ui-selectmenu-button-open\": \"ui-corner-\" + ( direction ? \"top\" : \"tl\" ),\n\t\t\t\t\t\"ui-selectmenu-button-closed\": \"ui-corner-\" + ( direction ? \"top\" : \"left\" )\n\t\t\t\t},\n\t\t\t\tlast: {\n\t\t\t\t\t\"ui-selectmenu-button-open\": direction ? \"\" : \"ui-corner-tr\",\n\t\t\t\t\t\"ui-selectmenu-button-closed\": \"ui-corner-\" + ( direction ? \"bottom\" : \"right\" )\n\t\t\t\t},\n\t\t\t\tonly: {\n\t\t\t\t\t\"ui-selectmenu-button-open\": \"ui-corner-top\",\n\t\t\t\t\t\"ui-selectmenu-button-closed\": \"ui-corner-all\"\n\t\t\t\t}\n\n\t\t\t}[ position ]\n\t\t};\n\t},\n\n\t_resolveClassesValues: function( classes, instance ) {\n\t\tvar result = {};\n\t\t$.each( classes, function( key ) {\n\t\t\tvar current = instance.options.classes[ key ] || \"\";\n\t\t\tcurrent = String.prototype.trim.call( current.replace( controlgroupCornerRegex, \"\" ) );\n\t\t\tresult[ key ] = ( current + \" \" + classes[ key ] ).replace( /\\s+/g, \" \" );\n\t\t} );\n\t\treturn result;\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"direction\" ) {\n\t\t\tthis._removeClass( \"ui-controlgroup-\" + this.options.direction );\n\t\t}\n\n\t\tthis._super( key, value );\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis._callChildMethod( value ? \"disable\" : \"enable\" );\n\t\t\treturn;\n\t\t}\n\n\t\tthis.refresh();\n\t},\n\n\trefresh: function() {\n\t\tvar children,\n\t\t\tthat = this;\n\n\t\tthis._addClass( \"ui-controlgroup ui-controlgroup-\" + this.options.direction );\n\n\t\tif ( this.options.direction === \"horizontal\" ) {\n\t\t\tthis._addClass( null, \"ui-helper-clearfix\" );\n\t\t}\n\t\tthis._initWidgets();\n\n\t\tchildren = this.childWidgets;\n\n\t\t// We filter here because we need to track all childWidgets not just the visible ones\n\t\tif ( this.options.onlyVisible ) {\n\t\t\tchildren = children.filter( \":visible\" );\n\t\t}\n\n\t\tif ( children.length ) {\n\n\t\t\t// We do this last because we need to make sure all enhancment is done\n\t\t\t// before determining first and last\n\t\t\t$.each( [ \"first\", \"last\" ], function( index, value ) {\n\t\t\t\tvar instance = children[ value ]().data( \"ui-controlgroup-data\" );\n\n\t\t\t\tif ( instance && that[ \"_\" + instance.widgetName + \"Options\" ] ) {\n\t\t\t\t\tvar options = that[ \"_\" + instance.widgetName + \"Options\" ](\n\t\t\t\t\t\tchildren.length === 1 ? \"only\" : value\n\t\t\t\t\t);\n\t\t\t\t\toptions.classes = that._resolveClassesValues( options.classes, instance );\n\t\t\t\t\tinstance.element[ instance.widgetName ]( options );\n\t\t\t\t} else {\n\t\t\t\t\tthat._updateCornerClass( children[ value ](), value );\n\t\t\t\t}\n\t\t\t} );\n\n\t\t\t// Finally call the refresh method on each of the child widgets.\n\t\t\tthis._callChildMethod( \"refresh\" );\n\t\t}\n\t}\n} );\n} );\n","jquery/ui-modules/widgets/droppable.js":"/*!\n * jQuery UI Droppable 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Droppable\n//>>group: Interactions\n//>>description: Enables drop targets for draggable elements.\n//>>docs: http://api.jqueryui.com/droppable/\n//>>demos: http://jqueryui.com/droppable/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./draggable\",\n\t\t\t\"./mouse\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.droppable\", {\n\tversion: \"1.13.1\",\n\twidgetEventPrefix: \"drop\",\n\toptions: {\n\t\taccept: \"*\",\n\t\taddClasses: true,\n\t\tgreedy: false,\n\t\tscope: \"default\",\n\t\ttolerance: \"intersect\",\n\n\t\t// Callbacks\n\t\tactivate: null,\n\t\tdeactivate: null,\n\t\tdrop: null,\n\t\tout: null,\n\t\tover: null\n\t},\n\t_create: function() {\n\n\t\tvar proportions,\n\t\t\to = this.options,\n\t\t\taccept = o.accept;\n\n\t\tthis.isover = false;\n\t\tthis.isout = true;\n\n\t\tthis.accept = typeof accept === \"function\" ? accept : function( d ) {\n\t\t\treturn d.is( accept );\n\t\t};\n\n\t\tthis.proportions = function( /* valueToWrite */ ) {\n\t\t\tif ( arguments.length ) {\n\n\t\t\t\t// Store the droppable's proportions\n\t\t\t\tproportions = arguments[ 0 ];\n\t\t\t} else {\n\n\t\t\t\t// Retrieve or derive the droppable's proportions\n\t\t\t\treturn proportions ?\n\t\t\t\t\tproportions :\n\t\t\t\t\tproportions = {\n\t\t\t\t\t\twidth: this.element[ 0 ].offsetWidth,\n\t\t\t\t\t\theight: this.element[ 0 ].offsetHeight\n\t\t\t\t\t};\n\t\t\t}\n\t\t};\n\n\t\tthis._addToManager( o.scope );\n\n\t\tif ( o.addClasses ) {\n\t\t\tthis._addClass( \"ui-droppable\" );\n\t\t}\n\n\t},\n\n\t_addToManager: function( scope ) {\n\n\t\t// Add the reference and positions to the manager\n\t\t$.ui.ddmanager.droppables[ scope ] = $.ui.ddmanager.droppables[ scope ] || [];\n\t\t$.ui.ddmanager.droppables[ scope ].push( this );\n\t},\n\n\t_splice: function( drop ) {\n\t\tvar i = 0;\n\t\tfor ( ; i < drop.length; i++ ) {\n\t\t\tif ( drop[ i ] === this ) {\n\t\t\t\tdrop.splice( i, 1 );\n\t\t\t}\n\t\t}\n\t},\n\n\t_destroy: function() {\n\t\tvar drop = $.ui.ddmanager.droppables[ this.options.scope ];\n\n\t\tthis._splice( drop );\n\t},\n\n\t_setOption: function( key, value ) {\n\n\t\tif ( key === \"accept\" ) {\n\t\t\tthis.accept = typeof value === \"function\" ? value : function( d ) {\n\t\t\t\treturn d.is( value );\n\t\t\t};\n\t\t} else if ( key === \"scope\" ) {\n\t\t\tvar drop = $.ui.ddmanager.droppables[ this.options.scope ];\n\n\t\t\tthis._splice( drop );\n\t\t\tthis._addToManager( value );\n\t\t}\n\n\t\tthis._super( key, value );\n\t},\n\n\t_activate: function( event ) {\n\t\tvar draggable = $.ui.ddmanager.current;\n\n\t\tthis._addActiveClass();\n\t\tif ( draggable ) {\n\t\t\tthis._trigger( \"activate\", event, this.ui( draggable ) );\n\t\t}\n\t},\n\n\t_deactivate: function( event ) {\n\t\tvar draggable = $.ui.ddmanager.current;\n\n\t\tthis._removeActiveClass();\n\t\tif ( draggable ) {\n\t\t\tthis._trigger( \"deactivate\", event, this.ui( draggable ) );\n\t\t}\n\t},\n\n\t_over: function( event ) {\n\n\t\tvar draggable = $.ui.ddmanager.current;\n\n\t\t// Bail if draggable and droppable are same element\n\t\tif ( !draggable || ( draggable.currentItem ||\n\t\t\t\tdraggable.element )[ 0 ] === this.element[ 0 ] ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( this.accept.call( this.element[ 0 ], ( draggable.currentItem ||\n\t\t\t\tdraggable.element ) ) ) {\n\t\t\tthis._addHoverClass();\n\t\t\tthis._trigger( \"over\", event, this.ui( draggable ) );\n\t\t}\n\n\t},\n\n\t_out: function( event ) {\n\n\t\tvar draggable = $.ui.ddmanager.current;\n\n\t\t// Bail if draggable and droppable are same element\n\t\tif ( !draggable || ( draggable.currentItem ||\n\t\t\t\tdraggable.element )[ 0 ] === this.element[ 0 ] ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( this.accept.call( this.element[ 0 ], ( draggable.currentItem ||\n\t\t\t\tdraggable.element ) ) ) {\n\t\t\tthis._removeHoverClass();\n\t\t\tthis._trigger( \"out\", event, this.ui( draggable ) );\n\t\t}\n\n\t},\n\n\t_drop: function( event, custom ) {\n\n\t\tvar draggable = custom || $.ui.ddmanager.current,\n\t\t\tchildrenIntersection = false;\n\n\t\t// Bail if draggable and droppable are same element\n\t\tif ( !draggable || ( draggable.currentItem ||\n\t\t\t\tdraggable.element )[ 0 ] === this.element[ 0 ] ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tthis.element\n\t\t\t.find( \":data(ui-droppable)\" )\n\t\t\t.not( \".ui-draggable-dragging\" )\n\t\t\t.each( function() {\n\t\t\t\tvar inst = $( this ).droppable( \"instance\" );\n\t\t\t\tif (\n\t\t\t\t\tinst.options.greedy &&\n\t\t\t\t\t!inst.options.disabled &&\n\t\t\t\t\tinst.options.scope === draggable.options.scope &&\n\t\t\t\t\tinst.accept.call(\n\t\t\t\t\t\tinst.element[ 0 ], ( draggable.currentItem || draggable.element )\n\t\t\t\t\t) &&\n\t\t\t\t\t$.ui.intersect(\n\t\t\t\t\t\tdraggable,\n\t\t\t\t\t\t$.extend( inst, { offset: inst.element.offset() } ),\n\t\t\t\t\t\tinst.options.tolerance, event\n\t\t\t\t\t)\n\t\t\t\t) {\n\t\t\t\t\tchildrenIntersection = true;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t} );\n\t\tif ( childrenIntersection ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tif ( this.accept.call( this.element[ 0 ],\n\t\t\t\t( draggable.currentItem || draggable.element ) ) ) {\n\t\t\tthis._removeActiveClass();\n\t\t\tthis._removeHoverClass();\n\n\t\t\tthis._trigger( \"drop\", event, this.ui( draggable ) );\n\t\t\treturn this.element;\n\t\t}\n\n\t\treturn false;\n\n\t},\n\n\tui: function( c ) {\n\t\treturn {\n\t\t\tdraggable: ( c.currentItem || c.element ),\n\t\t\thelper: c.helper,\n\t\t\tposition: c.position,\n\t\t\toffset: c.positionAbs\n\t\t};\n\t},\n\n\t// Extension points just to make backcompat sane and avoid duplicating logic\n\t// TODO: Remove in 1.14 along with call to it below\n\t_addHoverClass: function() {\n\t\tthis._addClass( \"ui-droppable-hover\" );\n\t},\n\n\t_removeHoverClass: function() {\n\t\tthis._removeClass( \"ui-droppable-hover\" );\n\t},\n\n\t_addActiveClass: function() {\n\t\tthis._addClass( \"ui-droppable-active\" );\n\t},\n\n\t_removeActiveClass: function() {\n\t\tthis._removeClass( \"ui-droppable-active\" );\n\t}\n} );\n\n$.ui.intersect = ( function() {\n\tfunction isOverAxis( x, reference, size ) {\n\t\treturn ( x >= reference ) && ( x < ( reference + size ) );\n\t}\n\n\treturn function( draggable, droppable, toleranceMode, event ) {\n\n\t\tif ( !droppable.offset ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tvar x1 = ( draggable.positionAbs ||\n\t\t\t\tdraggable.position.absolute ).left + draggable.margins.left,\n\t\t\ty1 = ( draggable.positionAbs ||\n\t\t\t\tdraggable.position.absolute ).top + draggable.margins.top,\n\t\t\tx2 = x1 + draggable.helperProportions.width,\n\t\t\ty2 = y1 + draggable.helperProportions.height,\n\t\t\tl = droppable.offset.left,\n\t\t\tt = droppable.offset.top,\n\t\t\tr = l + droppable.proportions().width,\n\t\t\tb = t + droppable.proportions().height;\n\n\t\tswitch ( toleranceMode ) {\n\t\tcase \"fit\":\n\t\t\treturn ( l <= x1 && x2 <= r && t <= y1 && y2 <= b );\n\t\tcase \"intersect\":\n\t\t\treturn ( l < x1 + ( draggable.helperProportions.width / 2 ) && // Right Half\n\t\t\t\tx2 - ( draggable.helperProportions.width / 2 ) < r && // Left Half\n\t\t\t\tt < y1 + ( draggable.helperProportions.height / 2 ) && // Bottom Half\n\t\t\t\ty2 - ( draggable.helperProportions.height / 2 ) < b ); // Top Half\n\t\tcase \"pointer\":\n\t\t\treturn isOverAxis( event.pageY, t, droppable.proportions().height ) &&\n\t\t\t\tisOverAxis( event.pageX, l, droppable.proportions().width );\n\t\tcase \"touch\":\n\t\t\treturn (\n\t\t\t\t( y1 >= t && y1 <= b ) || // Top edge touching\n\t\t\t\t( y2 >= t && y2 <= b ) || // Bottom edge touching\n\t\t\t\t( y1 < t && y2 > b ) // Surrounded vertically\n\t\t\t) && (\n\t\t\t\t( x1 >= l && x1 <= r ) || // Left edge touching\n\t\t\t\t( x2 >= l && x2 <= r ) || // Right edge touching\n\t\t\t\t( x1 < l && x2 > r ) // Surrounded horizontally\n\t\t\t);\n\t\tdefault:\n\t\t\treturn false;\n\t\t}\n\t};\n} )();\n\n/*\n\tThis manager tracks offsets of draggables and droppables\n*/\n$.ui.ddmanager = {\n\tcurrent: null,\n\tdroppables: { \"default\": [] },\n\tprepareOffsets: function( t, event ) {\n\n\t\tvar i, j,\n\t\t\tm = $.ui.ddmanager.droppables[ t.options.scope ] || [],\n\t\t\ttype = event ? event.type : null, // workaround for #2317\n\t\t\tlist = ( t.currentItem || t.element ).find( \":data(ui-droppable)\" ).addBack();\n\n\t\tdroppablesLoop: for ( i = 0; i < m.length; i++ ) {\n\n\t\t\t// No disabled and non-accepted\n\t\t\tif ( m[ i ].options.disabled || ( t && !m[ i ].accept.call( m[ i ].element[ 0 ],\n\t\t\t\t\t( t.currentItem || t.element ) ) ) ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\t// Filter out elements in the current dragged item\n\t\t\tfor ( j = 0; j < list.length; j++ ) {\n\t\t\t\tif ( list[ j ] === m[ i ].element[ 0 ] ) {\n\t\t\t\t\tm[ i ].proportions().height = 0;\n\t\t\t\t\tcontinue droppablesLoop;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tm[ i ].visible = m[ i ].element.css( \"display\" ) !== \"none\";\n\t\t\tif ( !m[ i ].visible ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\t// Activate the droppable if used directly from draggables\n\t\t\tif ( type === \"mousedown\" ) {\n\t\t\t\tm[ i ]._activate.call( m[ i ], event );\n\t\t\t}\n\n\t\t\tm[ i ].offset = m[ i ].element.offset();\n\t\t\tm[ i ].proportions( {\n\t\t\t\twidth: m[ i ].element[ 0 ].offsetWidth,\n\t\t\t\theight: m[ i ].element[ 0 ].offsetHeight\n\t\t\t} );\n\n\t\t}\n\n\t},\n\tdrop: function( draggable, event ) {\n\n\t\tvar dropped = false;\n\n\t\t// Create a copy of the droppables in case the list changes during the drop (#9116)\n\t\t$.each( ( $.ui.ddmanager.droppables[ draggable.options.scope ] || [] ).slice(), function() {\n\n\t\t\tif ( !this.options ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tif ( !this.options.disabled && this.visible &&\n\t\t\t\t\t$.ui.intersect( draggable, this, this.options.tolerance, event ) ) {\n\t\t\t\tdropped = this._drop.call( this, event ) || dropped;\n\t\t\t}\n\n\t\t\tif ( !this.options.disabled && this.visible && this.accept.call( this.element[ 0 ],\n\t\t\t\t\t( draggable.currentItem || draggable.element ) ) ) {\n\t\t\t\tthis.isout = true;\n\t\t\t\tthis.isover = false;\n\t\t\t\tthis._deactivate.call( this, event );\n\t\t\t}\n\n\t\t} );\n\t\treturn dropped;\n\n\t},\n\tdragStart: function( draggable, event ) {\n\n\t\t// Listen for scrolling so that if the dragging causes scrolling the position of the\n\t\t// droppables can be recalculated (see #5003)\n\t\tdraggable.element.parentsUntil( \"body\" ).on( \"scroll.droppable\", function() {\n\t\t\tif ( !draggable.options.refreshPositions ) {\n\t\t\t\t$.ui.ddmanager.prepareOffsets( draggable, event );\n\t\t\t}\n\t\t} );\n\t},\n\tdrag: function( draggable, event ) {\n\n\t\t// If you have a highly dynamic page, you might try this option. It renders positions\n\t\t// every time you move the mouse.\n\t\tif ( draggable.options.refreshPositions ) {\n\t\t\t$.ui.ddmanager.prepareOffsets( draggable, event );\n\t\t}\n\n\t\t// Run through all droppables and check their positions based on specific tolerance options\n\t\t$.each( $.ui.ddmanager.droppables[ draggable.options.scope ] || [], function() {\n\n\t\t\tif ( this.options.disabled || this.greedyChild || !this.visible ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tvar parentInstance, scope, parent,\n\t\t\t\tintersects = $.ui.intersect( draggable, this, this.options.tolerance, event ),\n\t\t\t\tc = !intersects && this.isover ?\n\t\t\t\t\t\"isout\" :\n\t\t\t\t\t( intersects && !this.isover ? \"isover\" : null );\n\t\t\tif ( !c ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( this.options.greedy ) {\n\n\t\t\t\t// find droppable parents with same scope\n\t\t\t\tscope = this.options.scope;\n\t\t\t\tparent = this.element.parents( \":data(ui-droppable)\" ).filter( function() {\n\t\t\t\t\treturn $( this ).droppable( \"instance\" ).options.scope === scope;\n\t\t\t\t} );\n\n\t\t\t\tif ( parent.length ) {\n\t\t\t\t\tparentInstance = $( parent[ 0 ] ).droppable( \"instance\" );\n\t\t\t\t\tparentInstance.greedyChild = ( c === \"isover\" );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// We just moved into a greedy child\n\t\t\tif ( parentInstance && c === \"isover\" ) {\n\t\t\t\tparentInstance.isover = false;\n\t\t\t\tparentInstance.isout = true;\n\t\t\t\tparentInstance._out.call( parentInstance, event );\n\t\t\t}\n\n\t\t\tthis[ c ] = true;\n\t\t\tthis[ c === \"isout\" ? \"isover\" : \"isout\" ] = false;\n\t\t\tthis[ c === \"isover\" ? \"_over\" : \"_out\" ].call( this, event );\n\n\t\t\t// We just moved out of a greedy child\n\t\t\tif ( parentInstance && c === \"isout\" ) {\n\t\t\t\tparentInstance.isout = false;\n\t\t\t\tparentInstance.isover = true;\n\t\t\t\tparentInstance._over.call( parentInstance, event );\n\t\t\t}\n\t\t} );\n\n\t},\n\tdragStop: function( draggable, event ) {\n\t\tdraggable.element.parentsUntil( \"body\" ).off( \"scroll.droppable\" );\n\n\t\t// Call prepareOffsets one final time since IE does not fire return scroll events when\n\t\t// overflow was caused by drag (see #5003)\n\t\tif ( !draggable.options.refreshPositions ) {\n\t\t\t$.ui.ddmanager.prepareOffsets( draggable, event );\n\t\t}\n\t}\n};\n\n// DEPRECATED\n// TODO: switch return back to widget declaration at top of file when this is removed\nif ( $.uiBackCompat !== false ) {\n\n\t// Backcompat for activeClass and hoverClass options\n\t$.widget( \"ui.droppable\", $.ui.droppable, {\n\t\toptions: {\n\t\t\thoverClass: false,\n\t\t\tactiveClass: false\n\t\t},\n\t\t_addActiveClass: function() {\n\t\t\tthis._super();\n\t\t\tif ( this.options.activeClass ) {\n\t\t\t\tthis.element.addClass( this.options.activeClass );\n\t\t\t}\n\t\t},\n\t\t_removeActiveClass: function() {\n\t\t\tthis._super();\n\t\t\tif ( this.options.activeClass ) {\n\t\t\t\tthis.element.removeClass( this.options.activeClass );\n\t\t\t}\n\t\t},\n\t\t_addHoverClass: function() {\n\t\t\tthis._super();\n\t\t\tif ( this.options.hoverClass ) {\n\t\t\t\tthis.element.addClass( this.options.hoverClass );\n\t\t\t}\n\t\t},\n\t\t_removeHoverClass: function() {\n\t\t\tthis._super();\n\t\t\tif ( this.options.hoverClass ) {\n\t\t\t\tthis.element.removeClass( this.options.hoverClass );\n\t\t\t}\n\t\t}\n\t} );\n}\n\nreturn $.ui.droppable;\n\n} );\n","jquery/ui-modules/widgets/sortable.js":"/*!\n * jQuery UI Sortable 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Sortable\n//>>group: Interactions\n//>>description: Enables items in a list to be sorted using the mouse.\n//>>docs: http://api.jqueryui.com/sortable/\n//>>demos: http://jqueryui.com/sortable/\n//>>css.structure: ../../themes/base/sortable.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./mouse\",\n\t\t\t\"../data\",\n\t\t\t\"../ie\",\n\t\t\t\"../scroll-parent\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.widget( \"ui.sortable\", $.ui.mouse, {\n\tversion: \"1.13.1\",\n\twidgetEventPrefix: \"sort\",\n\tready: false,\n\toptions: {\n\t\tappendTo: \"parent\",\n\t\taxis: false,\n\t\tconnectWith: false,\n\t\tcontainment: false,\n\t\tcursor: \"auto\",\n\t\tcursorAt: false,\n\t\tdropOnEmpty: true,\n\t\tforcePlaceholderSize: false,\n\t\tforceHelperSize: false,\n\t\tgrid: false,\n\t\thandle: false,\n\t\thelper: \"original\",\n\t\titems: \"> *\",\n\t\topacity: false,\n\t\tplaceholder: false,\n\t\trevert: false,\n\t\tscroll: true,\n\t\tscrollSensitivity: 20,\n\t\tscrollSpeed: 20,\n\t\tscope: \"default\",\n\t\ttolerance: \"intersect\",\n\t\tzIndex: 1000,\n\n\t\t// Callbacks\n\t\tactivate: null,\n\t\tbeforeStop: null,\n\t\tchange: null,\n\t\tdeactivate: null,\n\t\tout: null,\n\t\tover: null,\n\t\treceive: null,\n\t\tremove: null,\n\t\tsort: null,\n\t\tstart: null,\n\t\tstop: null,\n\t\tupdate: null\n\t},\n\n\t_isOverAxis: function( x, reference, size ) {\n\t\treturn ( x >= reference ) && ( x < ( reference + size ) );\n\t},\n\n\t_isFloating: function( item ) {\n\t\treturn ( /left|right/ ).test( item.css( \"float\" ) ) ||\n\t\t\t( /inline|table-cell/ ).test( item.css( \"display\" ) );\n\t},\n\n\t_create: function() {\n\t\tthis.containerCache = {};\n\t\tthis._addClass( \"ui-sortable\" );\n\n\t\t//Get the items\n\t\tthis.refresh();\n\n\t\t//Let's determine the parent's offset\n\t\tthis.offset = this.element.offset();\n\n\t\t//Initialize mouse events for interaction\n\t\tthis._mouseInit();\n\n\t\tthis._setHandleClassName();\n\n\t\t//We're ready to go\n\t\tthis.ready = true;\n\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tthis._super( key, value );\n\n\t\tif ( key === \"handle\" ) {\n\t\t\tthis._setHandleClassName();\n\t\t}\n\t},\n\n\t_setHandleClassName: function() {\n\t\tvar that = this;\n\t\tthis._removeClass( this.element.find( \".ui-sortable-handle\" ), \"ui-sortable-handle\" );\n\t\t$.each( this.items, function() {\n\t\t\tthat._addClass(\n\t\t\t\tthis.instance.options.handle ?\n\t\t\t\t\tthis.item.find( this.instance.options.handle ) :\n\t\t\t\t\tthis.item,\n\t\t\t\t\"ui-sortable-handle\"\n\t\t\t);\n\t\t} );\n\t},\n\n\t_destroy: function() {\n\t\tthis._mouseDestroy();\n\n\t\tfor ( var i = this.items.length - 1; i >= 0; i-- ) {\n\t\t\tthis.items[ i ].item.removeData( this.widgetName + \"-item\" );\n\t\t}\n\n\t\treturn this;\n\t},\n\n\t_mouseCapture: function( event, overrideHandle ) {\n\t\tvar currentItem = null,\n\t\t\tvalidHandle = false,\n\t\t\tthat = this;\n\n\t\tif ( this.reverting ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tif ( this.options.disabled || this.options.type === \"static\" ) {\n\t\t\treturn false;\n\t\t}\n\n\t\t//We have to refresh the items data once first\n\t\tthis._refreshItems( event );\n\n\t\t//Find out if the clicked node (or one of its parents) is a actual item in this.items\n\t\t$( event.target ).parents().each( function() {\n\t\t\tif ( $.data( this, that.widgetName + \"-item\" ) === that ) {\n\t\t\t\tcurrentItem = $( this );\n\t\t\t\treturn false;\n\t\t\t}\n\t\t} );\n\t\tif ( $.data( event.target, that.widgetName + \"-item\" ) === that ) {\n\t\t\tcurrentItem = $( event.target );\n\t\t}\n\n\t\tif ( !currentItem ) {\n\t\t\treturn false;\n\t\t}\n\t\tif ( this.options.handle && !overrideHandle ) {\n\t\t\t$( this.options.handle, currentItem ).find( \"*\" ).addBack().each( function() {\n\t\t\t\tif ( this === event.target ) {\n\t\t\t\t\tvalidHandle = true;\n\t\t\t\t}\n\t\t\t} );\n\t\t\tif ( !validHandle ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\n\t\tthis.currentItem = currentItem;\n\t\tthis._removeCurrentsFromItems();\n\t\treturn true;\n\n\t},\n\n\t_mouseStart: function( event, overrideHandle, noActivation ) {\n\n\t\tvar i, body,\n\t\t\to = this.options;\n\n\t\tthis.currentContainer = this;\n\n\t\t//We only need to call refreshPositions, because the refreshItems call has been moved to\n\t\t// mouseCapture\n\t\tthis.refreshPositions();\n\n\t\t//Prepare the dragged items parent\n\t\tthis.appendTo = $( o.appendTo !== \"parent\" ?\n\t\t\t\to.appendTo :\n\t\t\t\tthis.currentItem.parent() );\n\n\t\t//Create and append the visible helper\n\t\tthis.helper = this._createHelper( event );\n\n\t\t//Cache the helper size\n\t\tthis._cacheHelperProportions();\n\n\t\t/*\n\t\t * - Position generation -\n\t\t * This block generates everything position related - it's the core of draggables.\n\t\t */\n\n\t\t//Cache the margins of the original element\n\t\tthis._cacheMargins();\n\n\t\t//The element's absolute position on the page minus margins\n\t\tthis.offset = this.currentItem.offset();\n\t\tthis.offset = {\n\t\t\ttop: this.offset.top - this.margins.top,\n\t\t\tleft: this.offset.left - this.margins.left\n\t\t};\n\n\t\t$.extend( this.offset, {\n\t\t\tclick: { //Where the click happened, relative to the element\n\t\t\t\tleft: event.pageX - this.offset.left,\n\t\t\t\ttop: event.pageY - this.offset.top\n\t\t\t},\n\n\t\t\t// This is a relative to absolute position minus the actual position calculation -\n\t\t\t// only used for relative positioned helper\n\t\t\trelative: this._getRelativeOffset()\n\t\t} );\n\n\t\t// After we get the helper offset, but before we get the parent offset we can\n\t\t// change the helper's position to absolute\n\t\t// TODO: Still need to figure out a way to make relative sorting possible\n\t\tthis.helper.css( \"position\", \"absolute\" );\n\t\tthis.cssPosition = this.helper.css( \"position\" );\n\n\t\t//Adjust the mouse offset relative to the helper if \"cursorAt\" is supplied\n\t\tif ( o.cursorAt ) {\n\t\t\tthis._adjustOffsetFromHelper( o.cursorAt );\n\t\t}\n\n\t\t//Cache the former DOM position\n\t\tthis.domPosition = {\n\t\t\tprev: this.currentItem.prev()[ 0 ],\n\t\t\tparent: this.currentItem.parent()[ 0 ]\n\t\t};\n\n\t\t// If the helper is not the original, hide the original so it's not playing any role during\n\t\t// the drag, won't cause anything bad this way\n\t\tif ( this.helper[ 0 ] !== this.currentItem[ 0 ] ) {\n\t\t\tthis.currentItem.hide();\n\t\t}\n\n\t\t//Create the placeholder\n\t\tthis._createPlaceholder();\n\n\t\t//Get the next scrolling parent\n\t\tthis.scrollParent = this.placeholder.scrollParent();\n\n\t\t$.extend( this.offset, {\n\t\t\tparent: this._getParentOffset()\n\t\t} );\n\n\t\t//Set a containment if given in the options\n\t\tif ( o.containment ) {\n\t\t\tthis._setContainment();\n\t\t}\n\n\t\tif ( o.cursor && o.cursor !== \"auto\" ) { // cursor option\n\t\t\tbody = this.document.find( \"body\" );\n\n\t\t\t// Support: IE\n\t\t\tthis.storedCursor = body.css( \"cursor\" );\n\t\t\tbody.css( \"cursor\", o.cursor );\n\n\t\t\tthis.storedStylesheet =\n\t\t\t\t$( \"<style>*{ cursor: \" + o.cursor + \" !important; }</style>\" ).appendTo( body );\n\t\t}\n\n\t\t// We need to make sure to grab the zIndex before setting the\n\t\t// opacity, because setting the opacity to anything lower than 1\n\t\t// causes the zIndex to change from \"auto\" to 0.\n\t\tif ( o.zIndex ) { // zIndex option\n\t\t\tif ( this.helper.css( \"zIndex\" ) ) {\n\t\t\t\tthis._storedZIndex = this.helper.css( \"zIndex\" );\n\t\t\t}\n\t\t\tthis.helper.css( \"zIndex\", o.zIndex );\n\t\t}\n\n\t\tif ( o.opacity ) { // opacity option\n\t\t\tif ( this.helper.css( \"opacity\" ) ) {\n\t\t\t\tthis._storedOpacity = this.helper.css( \"opacity\" );\n\t\t\t}\n\t\t\tthis.helper.css( \"opacity\", o.opacity );\n\t\t}\n\n\t\t//Prepare scrolling\n\t\tif ( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n\t\t\t\tthis.scrollParent[ 0 ].tagName !== \"HTML\" ) {\n\t\t\tthis.overflowOffset = this.scrollParent.offset();\n\t\t}\n\n\t\t//Call callbacks\n\t\tthis._trigger( \"start\", event, this._uiHash() );\n\n\t\t//Recache the helper size\n\t\tif ( !this._preserveHelperProportions ) {\n\t\t\tthis._cacheHelperProportions();\n\t\t}\n\n\t\t//Post \"activate\" events to possible containers\n\t\tif ( !noActivation ) {\n\t\t\tfor ( i = this.containers.length - 1; i >= 0; i-- ) {\n\t\t\t\tthis.containers[ i ]._trigger( \"activate\", event, this._uiHash( this ) );\n\t\t\t}\n\t\t}\n\n\t\t//Prepare possible droppables\n\t\tif ( $.ui.ddmanager ) {\n\t\t\t$.ui.ddmanager.current = this;\n\t\t}\n\n\t\tif ( $.ui.ddmanager && !o.dropBehaviour ) {\n\t\t\t$.ui.ddmanager.prepareOffsets( this, event );\n\t\t}\n\n\t\tthis.dragging = true;\n\n\t\tthis._addClass( this.helper, \"ui-sortable-helper\" );\n\n\t\t//Move the helper, if needed\n\t\tif ( !this.helper.parent().is( this.appendTo ) ) {\n\t\t\tthis.helper.detach().appendTo( this.appendTo );\n\n\t\t\t//Update position\n\t\t\tthis.offset.parent = this._getParentOffset();\n\t\t}\n\n\t\t//Generate the original position\n\t\tthis.position = this.originalPosition = this._generatePosition( event );\n\t\tthis.originalPageX = event.pageX;\n\t\tthis.originalPageY = event.pageY;\n\t\tthis.lastPositionAbs = this.positionAbs = this._convertPositionTo( \"absolute\" );\n\n\t\tthis._mouseDrag( event );\n\n\t\treturn true;\n\n\t},\n\n\t_scroll: function( event ) {\n\t\tvar o = this.options,\n\t\t\tscrolled = false;\n\n\t\tif ( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n\t\t\t\tthis.scrollParent[ 0 ].tagName !== \"HTML\" ) {\n\n\t\t\tif ( ( this.overflowOffset.top + this.scrollParent[ 0 ].offsetHeight ) -\n\t\t\t\t\tevent.pageY < o.scrollSensitivity ) {\n\t\t\t\tthis.scrollParent[ 0 ].scrollTop =\n\t\t\t\t\tscrolled = this.scrollParent[ 0 ].scrollTop + o.scrollSpeed;\n\t\t\t} else if ( event.pageY - this.overflowOffset.top < o.scrollSensitivity ) {\n\t\t\t\tthis.scrollParent[ 0 ].scrollTop =\n\t\t\t\t\tscrolled = this.scrollParent[ 0 ].scrollTop - o.scrollSpeed;\n\t\t\t}\n\n\t\t\tif ( ( this.overflowOffset.left + this.scrollParent[ 0 ].offsetWidth ) -\n\t\t\t\t\tevent.pageX < o.scrollSensitivity ) {\n\t\t\t\tthis.scrollParent[ 0 ].scrollLeft = scrolled =\n\t\t\t\t\tthis.scrollParent[ 0 ].scrollLeft + o.scrollSpeed;\n\t\t\t} else if ( event.pageX - this.overflowOffset.left < o.scrollSensitivity ) {\n\t\t\t\tthis.scrollParent[ 0 ].scrollLeft = scrolled =\n\t\t\t\t\tthis.scrollParent[ 0 ].scrollLeft - o.scrollSpeed;\n\t\t\t}\n\n\t\t} else {\n\n\t\t\tif ( event.pageY - this.document.scrollTop() < o.scrollSensitivity ) {\n\t\t\t\tscrolled = this.document.scrollTop( this.document.scrollTop() - o.scrollSpeed );\n\t\t\t} else if ( this.window.height() - ( event.pageY - this.document.scrollTop() ) <\n\t\t\t\t\to.scrollSensitivity ) {\n\t\t\t\tscrolled = this.document.scrollTop( this.document.scrollTop() + o.scrollSpeed );\n\t\t\t}\n\n\t\t\tif ( event.pageX - this.document.scrollLeft() < o.scrollSensitivity ) {\n\t\t\t\tscrolled = this.document.scrollLeft(\n\t\t\t\t\tthis.document.scrollLeft() - o.scrollSpeed\n\t\t\t\t);\n\t\t\t} else if ( this.window.width() - ( event.pageX - this.document.scrollLeft() ) <\n\t\t\t\t\to.scrollSensitivity ) {\n\t\t\t\tscrolled = this.document.scrollLeft(\n\t\t\t\t\tthis.document.scrollLeft() + o.scrollSpeed\n\t\t\t\t);\n\t\t\t}\n\n\t\t}\n\n\t\treturn scrolled;\n\t},\n\n\t_mouseDrag: function( event ) {\n\t\tvar i, item, itemElement, intersection,\n\t\t\to = this.options;\n\n\t\t//Compute the helpers position\n\t\tthis.position = this._generatePosition( event );\n\t\tthis.positionAbs = this._convertPositionTo( \"absolute\" );\n\n\t\t//Set the helper position\n\t\tif ( !this.options.axis || this.options.axis !== \"y\" ) {\n\t\t\tthis.helper[ 0 ].style.left = this.position.left + \"px\";\n\t\t}\n\t\tif ( !this.options.axis || this.options.axis !== \"x\" ) {\n\t\t\tthis.helper[ 0 ].style.top = this.position.top + \"px\";\n\t\t}\n\n\t\t//Do scrolling\n\t\tif ( o.scroll ) {\n\t\t\tif ( this._scroll( event ) !== false ) {\n\n\t\t\t\t//Update item positions used in position checks\n\t\t\t\tthis._refreshItemPositions( true );\n\n\t\t\t\tif ( $.ui.ddmanager && !o.dropBehaviour ) {\n\t\t\t\t\t$.ui.ddmanager.prepareOffsets( this, event );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tthis.dragDirection = {\n\t\t\tvertical: this._getDragVerticalDirection(),\n\t\t\thorizontal: this._getDragHorizontalDirection()\n\t\t};\n\n\t\t//Rearrange\n\t\tfor ( i = this.items.length - 1; i >= 0; i-- ) {\n\n\t\t\t//Cache variables and intersection, continue if no intersection\n\t\t\titem = this.items[ i ];\n\t\t\titemElement = item.item[ 0 ];\n\t\t\tintersection = this._intersectsWithPointer( item );\n\t\t\tif ( !intersection ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\t// Only put the placeholder inside the current Container, skip all\n\t\t\t// items from other containers. This works because when moving\n\t\t\t// an item from one container to another the\n\t\t\t// currentContainer is switched before the placeholder is moved.\n\t\t\t//\n\t\t\t// Without this, moving items in \"sub-sortables\" can cause\n\t\t\t// the placeholder to jitter between the outer and inner container.\n\t\t\tif ( item.instance !== this.currentContainer ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\t// Cannot intersect with itself\n\t\t\t// no useless actions that have been done before\n\t\t\t// no action if the item moved is the parent of the item checked\n\t\t\tif ( itemElement !== this.currentItem[ 0 ] &&\n\t\t\t\tthis.placeholder[ intersection === 1 ?\n\t\t\t\t\"next\" : \"prev\" ]()[ 0 ] !== itemElement &&\n\t\t\t\t!$.contains( this.placeholder[ 0 ], itemElement ) &&\n\t\t\t\t( this.options.type === \"semi-dynamic\" ?\n\t\t\t\t\t!$.contains( this.element[ 0 ], itemElement ) :\n\t\t\t\t\ttrue\n\t\t\t\t)\n\t\t\t) {\n\n\t\t\t\tthis.direction = intersection === 1 ? \"down\" : \"up\";\n\n\t\t\t\tif ( this.options.tolerance === \"pointer\" ||\n\t\t\t\t\t\tthis._intersectsWithSides( item ) ) {\n\t\t\t\t\tthis._rearrange( event, item );\n\t\t\t\t} else {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tthis._trigger( \"change\", event, this._uiHash() );\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\n\t\t//Post events to containers\n\t\tthis._contactContainers( event );\n\n\t\t//Interconnect with droppables\n\t\tif ( $.ui.ddmanager ) {\n\t\t\t$.ui.ddmanager.drag( this, event );\n\t\t}\n\n\t\t//Call callbacks\n\t\tthis._trigger( \"sort\", event, this._uiHash() );\n\n\t\tthis.lastPositionAbs = this.positionAbs;\n\t\treturn false;\n\n\t},\n\n\t_mouseStop: function( event, noPropagation ) {\n\n\t\tif ( !event ) {\n\t\t\treturn;\n\t\t}\n\n\t\t//If we are using droppables, inform the manager about the drop\n\t\tif ( $.ui.ddmanager && !this.options.dropBehaviour ) {\n\t\t\t$.ui.ddmanager.drop( this, event );\n\t\t}\n\n\t\tif ( this.options.revert ) {\n\t\t\tvar that = this,\n\t\t\t\tcur = this.placeholder.offset(),\n\t\t\t\taxis = this.options.axis,\n\t\t\t\tanimation = {};\n\n\t\t\tif ( !axis || axis === \"x\" ) {\n\t\t\t\tanimation.left = cur.left - this.offset.parent.left - this.margins.left +\n\t\t\t\t\t( this.offsetParent[ 0 ] === this.document[ 0 ].body ?\n\t\t\t\t\t\t0 :\n\t\t\t\t\t\tthis.offsetParent[ 0 ].scrollLeft\n\t\t\t\t\t);\n\t\t\t}\n\t\t\tif ( !axis || axis === \"y\" ) {\n\t\t\t\tanimation.top = cur.top - this.offset.parent.top - this.margins.top +\n\t\t\t\t\t( this.offsetParent[ 0 ] === this.document[ 0 ].body ?\n\t\t\t\t\t\t0 :\n\t\t\t\t\t\tthis.offsetParent[ 0 ].scrollTop\n\t\t\t\t\t);\n\t\t\t}\n\t\t\tthis.reverting = true;\n\t\t\t$( this.helper ).animate(\n\t\t\t\tanimation,\n\t\t\t\tparseInt( this.options.revert, 10 ) || 500,\n\t\t\t\tfunction() {\n\t\t\t\t\tthat._clear( event );\n\t\t\t\t}\n\t\t\t);\n\t\t} else {\n\t\t\tthis._clear( event, noPropagation );\n\t\t}\n\n\t\treturn false;\n\n\t},\n\n\tcancel: function() {\n\n\t\tif ( this.dragging ) {\n\n\t\t\tthis._mouseUp( new $.Event( \"mouseup\", { target: null } ) );\n\n\t\t\tif ( this.options.helper === \"original\" ) {\n\t\t\t\tthis.currentItem.css( this._storedCSS );\n\t\t\t\tthis._removeClass( this.currentItem, \"ui-sortable-helper\" );\n\t\t\t} else {\n\t\t\t\tthis.currentItem.show();\n\t\t\t}\n\n\t\t\t//Post deactivating events to containers\n\t\t\tfor ( var i = this.containers.length - 1; i >= 0; i-- ) {\n\t\t\t\tthis.containers[ i ]._trigger( \"deactivate\", null, this._uiHash( this ) );\n\t\t\t\tif ( this.containers[ i ].containerCache.over ) {\n\t\t\t\t\tthis.containers[ i ]._trigger( \"out\", null, this._uiHash( this ) );\n\t\t\t\t\tthis.containers[ i ].containerCache.over = 0;\n\t\t\t\t}\n\t\t\t}\n\n\t\t}\n\n\t\tif ( this.placeholder ) {\n\n\t\t\t//$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately,\n\t\t\t// it unbinds ALL events from the original node!\n\t\t\tif ( this.placeholder[ 0 ].parentNode ) {\n\t\t\t\tthis.placeholder[ 0 ].parentNode.removeChild( this.placeholder[ 0 ] );\n\t\t\t}\n\t\t\tif ( this.options.helper !== \"original\" && this.helper &&\n\t\t\t\t\tthis.helper[ 0 ].parentNode ) {\n\t\t\t\tthis.helper.remove();\n\t\t\t}\n\n\t\t\t$.extend( this, {\n\t\t\t\thelper: null,\n\t\t\t\tdragging: false,\n\t\t\t\treverting: false,\n\t\t\t\t_noFinalSort: null\n\t\t\t} );\n\n\t\t\tif ( this.domPosition.prev ) {\n\t\t\t\t$( this.domPosition.prev ).after( this.currentItem );\n\t\t\t} else {\n\t\t\t\t$( this.domPosition.parent ).prepend( this.currentItem );\n\t\t\t}\n\t\t}\n\n\t\treturn this;\n\n\t},\n\n\tserialize: function( o ) {\n\n\t\tvar items = this._getItemsAsjQuery( o && o.connected ),\n\t\t\tstr = [];\n\t\to = o || {};\n\n\t\t$( items ).each( function() {\n\t\t\tvar res = ( $( o.item || this ).attr( o.attribute || \"id\" ) || \"\" )\n\t\t\t\t.match( o.expression || ( /(.+)[\\-=_](.+)/ ) );\n\t\t\tif ( res ) {\n\t\t\t\tstr.push(\n\t\t\t\t\t( o.key || res[ 1 ] + \"[]\" ) +\n\t\t\t\t\t\"=\" + ( o.key && o.expression ? res[ 1 ] : res[ 2 ] ) );\n\t\t\t}\n\t\t} );\n\n\t\tif ( !str.length && o.key ) {\n\t\t\tstr.push( o.key + \"=\" );\n\t\t}\n\n\t\treturn str.join( \"&\" );\n\n\t},\n\n\ttoArray: function( o ) {\n\n\t\tvar items = this._getItemsAsjQuery( o && o.connected ),\n\t\t\tret = [];\n\n\t\to = o || {};\n\n\t\titems.each( function() {\n\t\t\tret.push( $( o.item || this ).attr( o.attribute || \"id\" ) || \"\" );\n\t\t} );\n\t\treturn ret;\n\n\t},\n\n\t/* Be careful with the following core functions */\n\t_intersectsWith: function( item ) {\n\n\t\tvar x1 = this.positionAbs.left,\n\t\t\tx2 = x1 + this.helperProportions.width,\n\t\t\ty1 = this.positionAbs.top,\n\t\t\ty2 = y1 + this.helperProportions.height,\n\t\t\tl = item.left,\n\t\t\tr = l + item.width,\n\t\t\tt = item.top,\n\t\t\tb = t + item.height,\n\t\t\tdyClick = this.offset.click.top,\n\t\t\tdxClick = this.offset.click.left,\n\t\t\tisOverElementHeight = ( this.options.axis === \"x\" ) || ( ( y1 + dyClick ) > t &&\n\t\t\t\t( y1 + dyClick ) < b ),\n\t\t\tisOverElementWidth = ( this.options.axis === \"y\" ) || ( ( x1 + dxClick ) > l &&\n\t\t\t\t( x1 + dxClick ) < r ),\n\t\t\tisOverElement = isOverElementHeight && isOverElementWidth;\n\n\t\tif ( this.options.tolerance === \"pointer\" ||\n\t\t\tthis.options.forcePointerForContainers ||\n\t\t\t( this.options.tolerance !== \"pointer\" &&\n\t\t\t\tthis.helperProportions[ this.floating ? \"width\" : \"height\" ] >\n\t\t\t\titem[ this.floating ? \"width\" : \"height\" ] )\n\t\t) {\n\t\t\treturn isOverElement;\n\t\t} else {\n\n\t\t\treturn ( l < x1 + ( this.helperProportions.width / 2 ) && // Right Half\n\t\t\t\tx2 - ( this.helperProportions.width / 2 ) < r && // Left Half\n\t\t\t\tt < y1 + ( this.helperProportions.height / 2 ) && // Bottom Half\n\t\t\t\ty2 - ( this.helperProportions.height / 2 ) < b ); // Top Half\n\n\t\t}\n\t},\n\n\t_intersectsWithPointer: function( item ) {\n\t\tvar verticalDirection, horizontalDirection,\n\t\t\tisOverElementHeight = ( this.options.axis === \"x\" ) ||\n\t\t\t\tthis._isOverAxis(\n\t\t\t\t\tthis.positionAbs.top + this.offset.click.top, item.top, item.height ),\n\t\t\tisOverElementWidth = ( this.options.axis === \"y\" ) ||\n\t\t\t\tthis._isOverAxis(\n\t\t\t\t\tthis.positionAbs.left + this.offset.click.left, item.left, item.width ),\n\t\t\tisOverElement = isOverElementHeight && isOverElementWidth;\n\n\t\tif ( !isOverElement ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tverticalDirection = this.dragDirection.vertical;\n\t\thorizontalDirection = this.dragDirection.horizontal;\n\n\t\treturn this.floating ?\n\t\t\t( ( horizontalDirection === \"right\" || verticalDirection === \"down\" ) ? 2 : 1 ) :\n\t\t\t( verticalDirection && ( verticalDirection === \"down\" ? 2 : 1 ) );\n\n\t},\n\n\t_intersectsWithSides: function( item ) {\n\n\t\tvar isOverBottomHalf = this._isOverAxis( this.positionAbs.top +\n\t\t\t\tthis.offset.click.top, item.top + ( item.height / 2 ), item.height ),\n\t\t\tisOverRightHalf = this._isOverAxis( this.positionAbs.left +\n\t\t\t\tthis.offset.click.left, item.left + ( item.width / 2 ), item.width ),\n\t\t\tverticalDirection = this.dragDirection.vertical,\n\t\t\thorizontalDirection = this.dragDirection.horizontal;\n\n\t\tif ( this.floating && horizontalDirection ) {\n\t\t\treturn ( ( horizontalDirection === \"right\" && isOverRightHalf ) ||\n\t\t\t\t( horizontalDirection === \"left\" && !isOverRightHalf ) );\n\t\t} else {\n\t\t\treturn verticalDirection && ( ( verticalDirection === \"down\" && isOverBottomHalf ) ||\n\t\t\t\t( verticalDirection === \"up\" && !isOverBottomHalf ) );\n\t\t}\n\n\t},\n\n\t_getDragVerticalDirection: function() {\n\t\tvar delta = this.positionAbs.top - this.lastPositionAbs.top;\n\t\treturn delta !== 0 && ( delta > 0 ? \"down\" : \"up\" );\n\t},\n\n\t_getDragHorizontalDirection: function() {\n\t\tvar delta = this.positionAbs.left - this.lastPositionAbs.left;\n\t\treturn delta !== 0 && ( delta > 0 ? \"right\" : \"left\" );\n\t},\n\n\trefresh: function( event ) {\n\t\tthis._refreshItems( event );\n\t\tthis._setHandleClassName();\n\t\tthis.refreshPositions();\n\t\treturn this;\n\t},\n\n\t_connectWith: function() {\n\t\tvar options = this.options;\n\t\treturn options.connectWith.constructor === String ?\n\t\t\t[ options.connectWith ] :\n\t\t\toptions.connectWith;\n\t},\n\n\t_getItemsAsjQuery: function( connected ) {\n\n\t\tvar i, j, cur, inst,\n\t\t\titems = [],\n\t\t\tqueries = [],\n\t\t\tconnectWith = this._connectWith();\n\n\t\tif ( connectWith && connected ) {\n\t\t\tfor ( i = connectWith.length - 1; i >= 0; i-- ) {\n\t\t\t\tcur = $( connectWith[ i ], this.document[ 0 ] );\n\t\t\t\tfor ( j = cur.length - 1; j >= 0; j-- ) {\n\t\t\t\t\tinst = $.data( cur[ j ], this.widgetFullName );\n\t\t\t\t\tif ( inst && inst !== this && !inst.options.disabled ) {\n\t\t\t\t\t\tqueries.push( [ typeof inst.options.items === \"function\" ?\n\t\t\t\t\t\t\tinst.options.items.call( inst.element ) :\n\t\t\t\t\t\t\t$( inst.options.items, inst.element )\n\t\t\t\t\t\t\t\t.not( \".ui-sortable-helper\" )\n\t\t\t\t\t\t\t\t.not( \".ui-sortable-placeholder\" ), inst ] );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tqueries.push( [ typeof this.options.items === \"function\" ?\n\t\t\tthis.options.items\n\t\t\t\t.call( this.element, null, { options: this.options, item: this.currentItem } ) :\n\t\t\t$( this.options.items, this.element )\n\t\t\t\t.not( \".ui-sortable-helper\" )\n\t\t\t\t.not( \".ui-sortable-placeholder\" ), this ] );\n\n\t\tfunction addItems() {\n\t\t\titems.push( this );\n\t\t}\n\t\tfor ( i = queries.length - 1; i >= 0; i-- ) {\n\t\t\tqueries[ i ][ 0 ].each( addItems );\n\t\t}\n\n\t\treturn $( items );\n\n\t},\n\n\t_removeCurrentsFromItems: function() {\n\n\t\tvar list = this.currentItem.find( \":data(\" + this.widgetName + \"-item)\" );\n\n\t\tthis.items = $.grep( this.items, function( item ) {\n\t\t\tfor ( var j = 0; j < list.length; j++ ) {\n\t\t\t\tif ( list[ j ] === item.item[ 0 ] ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn true;\n\t\t} );\n\n\t},\n\n\t_refreshItems: function( event ) {\n\n\t\tthis.items = [];\n\t\tthis.containers = [ this ];\n\n\t\tvar i, j, cur, inst, targetData, _queries, item, queriesLength,\n\t\t\titems = this.items,\n\t\t\tqueries = [ [ typeof this.options.items === \"function\" ?\n\t\t\t\tthis.options.items.call( this.element[ 0 ], event, { item: this.currentItem } ) :\n\t\t\t\t$( this.options.items, this.element ), this ] ],\n\t\t\tconnectWith = this._connectWith();\n\n\t\t//Shouldn't be run the first time through due to massive slow-down\n\t\tif ( connectWith && this.ready ) {\n\t\t\tfor ( i = connectWith.length - 1; i >= 0; i-- ) {\n\t\t\t\tcur = $( connectWith[ i ], this.document[ 0 ] );\n\t\t\t\tfor ( j = cur.length - 1; j >= 0; j-- ) {\n\t\t\t\t\tinst = $.data( cur[ j ], this.widgetFullName );\n\t\t\t\t\tif ( inst && inst !== this && !inst.options.disabled ) {\n\t\t\t\t\t\tqueries.push( [ typeof inst.options.items === \"function\" ?\n\t\t\t\t\t\t\tinst.options.items\n\t\t\t\t\t\t\t\t.call( inst.element[ 0 ], event, { item: this.currentItem } ) :\n\t\t\t\t\t\t\t$( inst.options.items, inst.element ), inst ] );\n\t\t\t\t\t\tthis.containers.push( inst );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tfor ( i = queries.length - 1; i >= 0; i-- ) {\n\t\t\ttargetData = queries[ i ][ 1 ];\n\t\t\t_queries = queries[ i ][ 0 ];\n\n\t\t\tfor ( j = 0, queriesLength = _queries.length; j < queriesLength; j++ ) {\n\t\t\t\titem = $( _queries[ j ] );\n\n\t\t\t\t// Data for target checking (mouse manager)\n\t\t\t\titem.data( this.widgetName + \"-item\", targetData );\n\n\t\t\t\titems.push( {\n\t\t\t\t\titem: item,\n\t\t\t\t\tinstance: targetData,\n\t\t\t\t\twidth: 0, height: 0,\n\t\t\t\t\tleft: 0, top: 0\n\t\t\t\t} );\n\t\t\t}\n\t\t}\n\n\t},\n\n\t_refreshItemPositions: function( fast ) {\n\t\tvar i, item, t, p;\n\n\t\tfor ( i = this.items.length - 1; i >= 0; i-- ) {\n\t\t\titem = this.items[ i ];\n\n\t\t\t//We ignore calculating positions of all connected containers when we're not over them\n\t\t\tif ( this.currentContainer && item.instance !== this.currentContainer &&\n\t\t\t\t\titem.item[ 0 ] !== this.currentItem[ 0 ] ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tt = this.options.toleranceElement ?\n\t\t\t\t$( this.options.toleranceElement, item.item ) :\n\t\t\t\titem.item;\n\n\t\t\tif ( !fast ) {\n\t\t\t\titem.width = t.outerWidth();\n\t\t\t\titem.height = t.outerHeight();\n\t\t\t}\n\n\t\t\tp = t.offset();\n\t\t\titem.left = p.left;\n\t\t\titem.top = p.top;\n\t\t}\n\t},\n\n\trefreshPositions: function( fast ) {\n\n\t\t// Determine whether items are being displayed horizontally\n\t\tthis.floating = this.items.length ?\n\t\t\tthis.options.axis === \"x\" || this._isFloating( this.items[ 0 ].item ) :\n\t\t\tfalse;\n\n\t\t// This has to be redone because due to the item being moved out/into the offsetParent,\n\t\t// the offsetParent's position will change\n\t\tif ( this.offsetParent && this.helper ) {\n\t\t\tthis.offset.parent = this._getParentOffset();\n\t\t}\n\n\t\tthis._refreshItemPositions( fast );\n\n\t\tvar i, p;\n\n\t\tif ( this.options.custom && this.options.custom.refreshContainers ) {\n\t\t\tthis.options.custom.refreshContainers.call( this );\n\t\t} else {\n\t\t\tfor ( i = this.containers.length - 1; i >= 0; i-- ) {\n\t\t\t\tp = this.containers[ i ].element.offset();\n\t\t\t\tthis.containers[ i ].containerCache.left = p.left;\n\t\t\t\tthis.containers[ i ].containerCache.top = p.top;\n\t\t\t\tthis.containers[ i ].containerCache.width =\n\t\t\t\t\tthis.containers[ i ].element.outerWidth();\n\t\t\t\tthis.containers[ i ].containerCache.height =\n\t\t\t\t\tthis.containers[ i ].element.outerHeight();\n\t\t\t}\n\t\t}\n\n\t\treturn this;\n\t},\n\n\t_createPlaceholder: function( that ) {\n\t\tthat = that || this;\n\t\tvar className, nodeName,\n\t\t\to = that.options;\n\n\t\tif ( !o.placeholder || o.placeholder.constructor === String ) {\n\t\t\tclassName = o.placeholder;\n\t\t\tnodeName = that.currentItem[ 0 ].nodeName.toLowerCase();\n\t\t\to.placeholder = {\n\t\t\t\telement: function() {\n\n\t\t\t\t\tvar element = $( \"<\" + nodeName + \">\", that.document[ 0 ] );\n\n\t\t\t\t\tthat._addClass( element, \"ui-sortable-placeholder\",\n\t\t\t\t\t\t\tclassName || that.currentItem[ 0 ].className )\n\t\t\t\t\t\t._removeClass( element, \"ui-sortable-helper\" );\n\n\t\t\t\t\tif ( nodeName === \"tbody\" ) {\n\t\t\t\t\t\tthat._createTrPlaceholder(\n\t\t\t\t\t\t\tthat.currentItem.find( \"tr\" ).eq( 0 ),\n\t\t\t\t\t\t\t$( \"<tr>\", that.document[ 0 ] ).appendTo( element )\n\t\t\t\t\t\t);\n\t\t\t\t\t} else if ( nodeName === \"tr\" ) {\n\t\t\t\t\t\tthat._createTrPlaceholder( that.currentItem, element );\n\t\t\t\t\t} else if ( nodeName === \"img\" ) {\n\t\t\t\t\t\telement.attr( \"src\", that.currentItem.attr( \"src\" ) );\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( !className ) {\n\t\t\t\t\t\telement.css( \"visibility\", \"hidden\" );\n\t\t\t\t\t}\n\n\t\t\t\t\treturn element;\n\t\t\t\t},\n\t\t\t\tupdate: function( container, p ) {\n\n\t\t\t\t\t// 1. If a className is set as 'placeholder option, we don't force sizes -\n\t\t\t\t\t// the class is responsible for that\n\t\t\t\t\t// 2. The option 'forcePlaceholderSize can be enabled to force it even if a\n\t\t\t\t\t// class name is specified\n\t\t\t\t\tif ( className && !o.forcePlaceholderSize ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// If the element doesn't have a actual height or width by itself (without\n\t\t\t\t\t// styles coming from a stylesheet), it receives the inline height and width\n\t\t\t\t\t// from the dragged item. Or, if it's a tbody or tr, it's going to have a height\n\t\t\t\t\t// anyway since we're populating them with <td>s above, but they're unlikely to\n\t\t\t\t\t// be the correct height on their own if the row heights are dynamic, so we'll\n\t\t\t\t\t// always assign the height of the dragged item given forcePlaceholderSize\n\t\t\t\t\t// is true.\n\t\t\t\t\tif ( !p.height() || ( o.forcePlaceholderSize &&\n\t\t\t\t\t\t\t( nodeName === \"tbody\" || nodeName === \"tr\" ) ) ) {\n\t\t\t\t\t\tp.height(\n\t\t\t\t\t\t\tthat.currentItem.innerHeight() -\n\t\t\t\t\t\t\tparseInt( that.currentItem.css( \"paddingTop\" ) || 0, 10 ) -\n\t\t\t\t\t\t\tparseInt( that.currentItem.css( \"paddingBottom\" ) || 0, 10 ) );\n\t\t\t\t\t}\n\t\t\t\t\tif ( !p.width() ) {\n\t\t\t\t\t\tp.width(\n\t\t\t\t\t\t\tthat.currentItem.innerWidth() -\n\t\t\t\t\t\t\tparseInt( that.currentItem.css( \"paddingLeft\" ) || 0, 10 ) -\n\t\t\t\t\t\t\tparseInt( that.currentItem.css( \"paddingRight\" ) || 0, 10 ) );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\n\t\t//Create the placeholder\n\t\tthat.placeholder = $( o.placeholder.element.call( that.element, that.currentItem ) );\n\n\t\t//Append it after the actual current item\n\t\tthat.currentItem.after( that.placeholder );\n\n\t\t//Update the size of the placeholder (TODO: Logic to fuzzy, see line 316/317)\n\t\to.placeholder.update( that, that.placeholder );\n\n\t},\n\n\t_createTrPlaceholder: function( sourceTr, targetTr ) {\n\t\tvar that = this;\n\n\t\tsourceTr.children().each( function() {\n\t\t\t$( \"<td>&#160;</td>\", that.document[ 0 ] )\n\t\t\t\t.attr( \"colspan\", $( this ).attr( \"colspan\" ) || 1 )\n\t\t\t\t.appendTo( targetTr );\n\t\t} );\n\t},\n\n\t_contactContainers: function( event ) {\n\t\tvar i, j, dist, itemWithLeastDistance, posProperty, sizeProperty, cur, nearBottom,\n\t\t\tfloating, axis,\n\t\t\tinnermostContainer = null,\n\t\t\tinnermostIndex = null;\n\n\t\t// Get innermost container that intersects with item\n\t\tfor ( i = this.containers.length - 1; i >= 0; i-- ) {\n\n\t\t\t// Never consider a container that's located within the item itself\n\t\t\tif ( $.contains( this.currentItem[ 0 ], this.containers[ i ].element[ 0 ] ) ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tif ( this._intersectsWith( this.containers[ i ].containerCache ) ) {\n\n\t\t\t\t// If we've already found a container and it's more \"inner\" than this, then continue\n\t\t\t\tif ( innermostContainer &&\n\t\t\t\t\t\t$.contains(\n\t\t\t\t\t\t\tthis.containers[ i ].element[ 0 ],\n\t\t\t\t\t\t\tinnermostContainer.element[ 0 ] ) ) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\tinnermostContainer = this.containers[ i ];\n\t\t\t\tinnermostIndex = i;\n\n\t\t\t} else {\n\n\t\t\t\t// container doesn't intersect. trigger \"out\" event if necessary\n\t\t\t\tif ( this.containers[ i ].containerCache.over ) {\n\t\t\t\t\tthis.containers[ i ]._trigger( \"out\", event, this._uiHash( this ) );\n\t\t\t\t\tthis.containers[ i ].containerCache.over = 0;\n\t\t\t\t}\n\t\t\t}\n\n\t\t}\n\n\t\t// If no intersecting containers found, return\n\t\tif ( !innermostContainer ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Move the item into the container if it's not there already\n\t\tif ( this.containers.length === 1 ) {\n\t\t\tif ( !this.containers[ innermostIndex ].containerCache.over ) {\n\t\t\t\tthis.containers[ innermostIndex ]._trigger( \"over\", event, this._uiHash( this ) );\n\t\t\t\tthis.containers[ innermostIndex ].containerCache.over = 1;\n\t\t\t}\n\t\t} else {\n\n\t\t\t// When entering a new container, we will find the item with the least distance and\n\t\t\t// append our item near it\n\t\t\tdist = 10000;\n\t\t\titemWithLeastDistance = null;\n\t\t\tfloating = innermostContainer.floating || this._isFloating( this.currentItem );\n\t\t\tposProperty = floating ? \"left\" : \"top\";\n\t\t\tsizeProperty = floating ? \"width\" : \"height\";\n\t\t\taxis = floating ? \"pageX\" : \"pageY\";\n\n\t\t\tfor ( j = this.items.length - 1; j >= 0; j-- ) {\n\t\t\t\tif ( !$.contains(\n\t\t\t\t\t\tthis.containers[ innermostIndex ].element[ 0 ], this.items[ j ].item[ 0 ] )\n\t\t\t\t) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\t\t\t\tif ( this.items[ j ].item[ 0 ] === this.currentItem[ 0 ] ) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\tcur = this.items[ j ].item.offset()[ posProperty ];\n\t\t\t\tnearBottom = false;\n\t\t\t\tif ( event[ axis ] - cur > this.items[ j ][ sizeProperty ] / 2 ) {\n\t\t\t\t\tnearBottom = true;\n\t\t\t\t}\n\n\t\t\t\tif ( Math.abs( event[ axis ] - cur ) < dist ) {\n\t\t\t\t\tdist = Math.abs( event[ axis ] - cur );\n\t\t\t\t\titemWithLeastDistance = this.items[ j ];\n\t\t\t\t\tthis.direction = nearBottom ? \"up\" : \"down\";\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t//Check if dropOnEmpty is enabled\n\t\t\tif ( !itemWithLeastDistance && !this.options.dropOnEmpty ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( this.currentContainer === this.containers[ innermostIndex ] ) {\n\t\t\t\tif ( !this.currentContainer.containerCache.over ) {\n\t\t\t\t\tthis.containers[ innermostIndex ]._trigger( \"over\", event, this._uiHash() );\n\t\t\t\t\tthis.currentContainer.containerCache.over = 1;\n\t\t\t\t}\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( itemWithLeastDistance ) {\n\t\t\t\tthis._rearrange( event, itemWithLeastDistance, null, true );\n\t\t\t} else {\n\t\t\t\tthis._rearrange( event, null, this.containers[ innermostIndex ].element, true );\n\t\t\t}\n\t\t\tthis._trigger( \"change\", event, this._uiHash() );\n\t\t\tthis.containers[ innermostIndex ]._trigger( \"change\", event, this._uiHash( this ) );\n\t\t\tthis.currentContainer = this.containers[ innermostIndex ];\n\n\t\t\t//Update the placeholder\n\t\t\tthis.options.placeholder.update( this.currentContainer, this.placeholder );\n\n\t\t\t//Update scrollParent\n\t\t\tthis.scrollParent = this.placeholder.scrollParent();\n\n\t\t\t//Update overflowOffset\n\t\t\tif ( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n\t\t\t\t\tthis.scrollParent[ 0 ].tagName !== \"HTML\" ) {\n\t\t\t\tthis.overflowOffset = this.scrollParent.offset();\n\t\t\t}\n\n\t\t\tthis.containers[ innermostIndex ]._trigger( \"over\", event, this._uiHash( this ) );\n\t\t\tthis.containers[ innermostIndex ].containerCache.over = 1;\n\t\t}\n\n\t},\n\n\t_createHelper: function( event ) {\n\n\t\tvar o = this.options,\n\t\t\thelper = typeof o.helper === \"function\" ?\n\t\t\t\t$( o.helper.apply( this.element[ 0 ], [ event, this.currentItem ] ) ) :\n\t\t\t\t( o.helper === \"clone\" ? this.currentItem.clone() : this.currentItem );\n\n\t\t//Add the helper to the DOM if that didn't happen already\n\t\tif ( !helper.parents( \"body\" ).length ) {\n\t\t\tthis.appendTo[ 0 ].appendChild( helper[ 0 ] );\n\t\t}\n\n\t\tif ( helper[ 0 ] === this.currentItem[ 0 ] ) {\n\t\t\tthis._storedCSS = {\n\t\t\t\twidth: this.currentItem[ 0 ].style.width,\n\t\t\t\theight: this.currentItem[ 0 ].style.height,\n\t\t\t\tposition: this.currentItem.css( \"position\" ),\n\t\t\t\ttop: this.currentItem.css( \"top\" ),\n\t\t\t\tleft: this.currentItem.css( \"left\" )\n\t\t\t};\n\t\t}\n\n\t\tif ( !helper[ 0 ].style.width || o.forceHelperSize ) {\n\t\t\thelper.width( this.currentItem.width() );\n\t\t}\n\t\tif ( !helper[ 0 ].style.height || o.forceHelperSize ) {\n\t\t\thelper.height( this.currentItem.height() );\n\t\t}\n\n\t\treturn helper;\n\n\t},\n\n\t_adjustOffsetFromHelper: function( obj ) {\n\t\tif ( typeof obj === \"string\" ) {\n\t\t\tobj = obj.split( \" \" );\n\t\t}\n\t\tif ( Array.isArray( obj ) ) {\n\t\t\tobj = { left: +obj[ 0 ], top: +obj[ 1 ] || 0 };\n\t\t}\n\t\tif ( \"left\" in obj ) {\n\t\t\tthis.offset.click.left = obj.left + this.margins.left;\n\t\t}\n\t\tif ( \"right\" in obj ) {\n\t\t\tthis.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;\n\t\t}\n\t\tif ( \"top\" in obj ) {\n\t\t\tthis.offset.click.top = obj.top + this.margins.top;\n\t\t}\n\t\tif ( \"bottom\" in obj ) {\n\t\t\tthis.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;\n\t\t}\n\t},\n\n\t_getParentOffset: function() {\n\n\t\t//Get the offsetParent and cache its position\n\t\tthis.offsetParent = this.helper.offsetParent();\n\t\tvar po = this.offsetParent.offset();\n\n\t\t// This is a special case where we need to modify a offset calculated on start, since the\n\t\t// following happened:\n\t\t// 1. The position of the helper is absolute, so it's position is calculated based on the\n\t\t// next positioned parent\n\t\t// 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't\n\t\t// the document, which means that the scroll is included in the initial calculation of the\n\t\t// offset of the parent, and never recalculated upon drag\n\t\tif ( this.cssPosition === \"absolute\" && this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n\t\t\t\t$.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) {\n\t\t\tpo.left += this.scrollParent.scrollLeft();\n\t\t\tpo.top += this.scrollParent.scrollTop();\n\t\t}\n\n\t\t// This needs to be actually done for all browsers, since pageX/pageY includes this\n\t\t// information with an ugly IE fix\n\t\tif ( this.offsetParent[ 0 ] === this.document[ 0 ].body ||\n\t\t\t\t( this.offsetParent[ 0 ].tagName &&\n\t\t\t\tthis.offsetParent[ 0 ].tagName.toLowerCase() === \"html\" && $.ui.ie ) ) {\n\t\t\tpo = { top: 0, left: 0 };\n\t\t}\n\n\t\treturn {\n\t\t\ttop: po.top + ( parseInt( this.offsetParent.css( \"borderTopWidth\" ), 10 ) || 0 ),\n\t\t\tleft: po.left + ( parseInt( this.offsetParent.css( \"borderLeftWidth\" ), 10 ) || 0 )\n\t\t};\n\n\t},\n\n\t_getRelativeOffset: function() {\n\n\t\tif ( this.cssPosition === \"relative\" ) {\n\t\t\tvar p = this.currentItem.position();\n\t\t\treturn {\n\t\t\t\ttop: p.top - ( parseInt( this.helper.css( \"top\" ), 10 ) || 0 ) +\n\t\t\t\t\tthis.scrollParent.scrollTop(),\n\t\t\t\tleft: p.left - ( parseInt( this.helper.css( \"left\" ), 10 ) || 0 ) +\n\t\t\t\t\tthis.scrollParent.scrollLeft()\n\t\t\t};\n\t\t} else {\n\t\t\treturn { top: 0, left: 0 };\n\t\t}\n\n\t},\n\n\t_cacheMargins: function() {\n\t\tthis.margins = {\n\t\t\tleft: ( parseInt( this.currentItem.css( \"marginLeft\" ), 10 ) || 0 ),\n\t\t\ttop: ( parseInt( this.currentItem.css( \"marginTop\" ), 10 ) || 0 )\n\t\t};\n\t},\n\n\t_cacheHelperProportions: function() {\n\t\tthis.helperProportions = {\n\t\t\twidth: this.helper.outerWidth(),\n\t\t\theight: this.helper.outerHeight()\n\t\t};\n\t},\n\n\t_setContainment: function() {\n\n\t\tvar ce, co, over,\n\t\t\to = this.options;\n\t\tif ( o.containment === \"parent\" ) {\n\t\t\to.containment = this.helper[ 0 ].parentNode;\n\t\t}\n\t\tif ( o.containment === \"document\" || o.containment === \"window\" ) {\n\t\t\tthis.containment = [\n\t\t\t\t0 - this.offset.relative.left - this.offset.parent.left,\n\t\t\t\t0 - this.offset.relative.top - this.offset.parent.top,\n\t\t\t\to.containment === \"document\" ?\n\t\t\t\t\tthis.document.width() :\n\t\t\t\t\tthis.window.width() - this.helperProportions.width - this.margins.left,\n\t\t\t\t( o.containment === \"document\" ?\n\t\t\t\t\t( this.document.height() || document.body.parentNode.scrollHeight ) :\n\t\t\t\t\tthis.window.height() || this.document[ 0 ].body.parentNode.scrollHeight\n\t\t\t\t) - this.helperProportions.height - this.margins.top\n\t\t\t];\n\t\t}\n\n\t\tif ( !( /^(document|window|parent)$/ ).test( o.containment ) ) {\n\t\t\tce = $( o.containment )[ 0 ];\n\t\t\tco = $( o.containment ).offset();\n\t\t\tover = ( $( ce ).css( \"overflow\" ) !== \"hidden\" );\n\n\t\t\tthis.containment = [\n\t\t\t\tco.left + ( parseInt( $( ce ).css( \"borderLeftWidth\" ), 10 ) || 0 ) +\n\t\t\t\t\t( parseInt( $( ce ).css( \"paddingLeft\" ), 10 ) || 0 ) - this.margins.left,\n\t\t\t\tco.top + ( parseInt( $( ce ).css( \"borderTopWidth\" ), 10 ) || 0 ) +\n\t\t\t\t\t( parseInt( $( ce ).css( \"paddingTop\" ), 10 ) || 0 ) - this.margins.top,\n\t\t\t\tco.left + ( over ? Math.max( ce.scrollWidth, ce.offsetWidth ) : ce.offsetWidth ) -\n\t\t\t\t\t( parseInt( $( ce ).css( \"borderLeftWidth\" ), 10 ) || 0 ) -\n\t\t\t\t\t( parseInt( $( ce ).css( \"paddingRight\" ), 10 ) || 0 ) -\n\t\t\t\t\tthis.helperProportions.width - this.margins.left,\n\t\t\t\tco.top + ( over ? Math.max( ce.scrollHeight, ce.offsetHeight ) : ce.offsetHeight ) -\n\t\t\t\t\t( parseInt( $( ce ).css( \"borderTopWidth\" ), 10 ) || 0 ) -\n\t\t\t\t\t( parseInt( $( ce ).css( \"paddingBottom\" ), 10 ) || 0 ) -\n\t\t\t\t\tthis.helperProportions.height - this.margins.top\n\t\t\t];\n\t\t}\n\n\t},\n\n\t_convertPositionTo: function( d, pos ) {\n\n\t\tif ( !pos ) {\n\t\t\tpos = this.position;\n\t\t}\n\t\tvar mod = d === \"absolute\" ? 1 : -1,\n\t\t\tscroll = this.cssPosition === \"absolute\" &&\n\t\t\t\t!( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n\t\t\t\t$.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) ?\n\t\t\t\t\tthis.offsetParent :\n\t\t\t\t\tthis.scrollParent,\n\t\t\tscrollIsRootNode = ( /(html|body)/i ).test( scroll[ 0 ].tagName );\n\n\t\treturn {\n\t\t\ttop: (\n\n\t\t\t\t// The absolute mouse position\n\t\t\t\tpos.top\t+\n\n\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\tthis.offset.relative.top * mod +\n\n\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\tthis.offset.parent.top * mod -\n\t\t\t\t( ( this.cssPosition === \"fixed\" ?\n\t\t\t\t\t-this.scrollParent.scrollTop() :\n\t\t\t\t\t( scrollIsRootNode ? 0 : scroll.scrollTop() ) ) * mod )\n\t\t\t),\n\t\t\tleft: (\n\n\t\t\t\t// The absolute mouse position\n\t\t\t\tpos.left +\n\n\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\tthis.offset.relative.left * mod +\n\n\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\tthis.offset.parent.left * mod\t-\n\t\t\t\t( ( this.cssPosition === \"fixed\" ?\n\t\t\t\t\t-this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 :\n\t\t\t\t\tscroll.scrollLeft() ) * mod )\n\t\t\t)\n\t\t};\n\n\t},\n\n\t_generatePosition: function( event ) {\n\n\t\tvar top, left,\n\t\t\to = this.options,\n\t\t\tpageX = event.pageX,\n\t\t\tpageY = event.pageY,\n\t\t\tscroll = this.cssPosition === \"absolute\" &&\n\t\t\t\t!( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n\t\t\t\t$.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) ?\n\t\t\t\t\tthis.offsetParent :\n\t\t\t\t\tthis.scrollParent,\n\t\t\t\tscrollIsRootNode = ( /(html|body)/i ).test( scroll[ 0 ].tagName );\n\n\t\t// This is another very weird special case that only happens for relative elements:\n\t\t// 1. If the css position is relative\n\t\t// 2. and the scroll parent is the document or similar to the offset parent\n\t\t// we have to refresh the relative offset during the scroll so there are no jumps\n\t\tif ( this.cssPosition === \"relative\" && !( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n\t\t\t\tthis.scrollParent[ 0 ] !== this.offsetParent[ 0 ] ) ) {\n\t\t\tthis.offset.relative = this._getRelativeOffset();\n\t\t}\n\n\t\t/*\n\t\t * - Position constraining -\n\t\t * Constrain the position to a mix of grid, containment.\n\t\t */\n\n\t\tif ( this.originalPosition ) { //If we are not dragging yet, we won't check for options\n\n\t\t\tif ( this.containment ) {\n\t\t\t\tif ( event.pageX - this.offset.click.left < this.containment[ 0 ] ) {\n\t\t\t\t\tpageX = this.containment[ 0 ] + this.offset.click.left;\n\t\t\t\t}\n\t\t\t\tif ( event.pageY - this.offset.click.top < this.containment[ 1 ] ) {\n\t\t\t\t\tpageY = this.containment[ 1 ] + this.offset.click.top;\n\t\t\t\t}\n\t\t\t\tif ( event.pageX - this.offset.click.left > this.containment[ 2 ] ) {\n\t\t\t\t\tpageX = this.containment[ 2 ] + this.offset.click.left;\n\t\t\t\t}\n\t\t\t\tif ( event.pageY - this.offset.click.top > this.containment[ 3 ] ) {\n\t\t\t\t\tpageY = this.containment[ 3 ] + this.offset.click.top;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( o.grid ) {\n\t\t\t\ttop = this.originalPageY + Math.round( ( pageY - this.originalPageY ) /\n\t\t\t\t\to.grid[ 1 ] ) * o.grid[ 1 ];\n\t\t\t\tpageY = this.containment ?\n\t\t\t\t\t( ( top - this.offset.click.top >= this.containment[ 1 ] &&\n\t\t\t\t\t\ttop - this.offset.click.top <= this.containment[ 3 ] ) ?\n\t\t\t\t\t\t\ttop :\n\t\t\t\t\t\t\t( ( top - this.offset.click.top >= this.containment[ 1 ] ) ?\n\t\t\t\t\t\t\t\ttop - o.grid[ 1 ] : top + o.grid[ 1 ] ) ) :\n\t\t\t\t\t\t\t\ttop;\n\n\t\t\t\tleft = this.originalPageX + Math.round( ( pageX - this.originalPageX ) /\n\t\t\t\t\to.grid[ 0 ] ) * o.grid[ 0 ];\n\t\t\t\tpageX = this.containment ?\n\t\t\t\t\t( ( left - this.offset.click.left >= this.containment[ 0 ] &&\n\t\t\t\t\t\tleft - this.offset.click.left <= this.containment[ 2 ] ) ?\n\t\t\t\t\t\t\tleft :\n\t\t\t\t\t\t\t( ( left - this.offset.click.left >= this.containment[ 0 ] ) ?\n\t\t\t\t\t\t\t\tleft - o.grid[ 0 ] : left + o.grid[ 0 ] ) ) :\n\t\t\t\t\t\t\t\tleft;\n\t\t\t}\n\n\t\t}\n\n\t\treturn {\n\t\t\ttop: (\n\n\t\t\t\t// The absolute mouse position\n\t\t\t\tpageY -\n\n\t\t\t\t// Click offset (relative to the element)\n\t\t\t\tthis.offset.click.top -\n\n\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\tthis.offset.relative.top -\n\n\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\tthis.offset.parent.top +\n\t\t\t\t( ( this.cssPosition === \"fixed\" ?\n\t\t\t\t\t-this.scrollParent.scrollTop() :\n\t\t\t\t\t( scrollIsRootNode ? 0 : scroll.scrollTop() ) ) )\n\t\t\t),\n\t\t\tleft: (\n\n\t\t\t\t// The absolute mouse position\n\t\t\t\tpageX -\n\n\t\t\t\t// Click offset (relative to the element)\n\t\t\t\tthis.offset.click.left -\n\n\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\tthis.offset.relative.left -\n\n\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\tthis.offset.parent.left +\n\t\t\t\t( ( this.cssPosition === \"fixed\" ?\n\t\t\t\t\t-this.scrollParent.scrollLeft() :\n\t\t\t\t\tscrollIsRootNode ? 0 : scroll.scrollLeft() ) )\n\t\t\t)\n\t\t};\n\n\t},\n\n\t_rearrange: function( event, i, a, hardRefresh ) {\n\n\t\tif ( a ) {\n\t\t\ta[ 0 ].appendChild( this.placeholder[ 0 ] );\n\t\t} else {\n\t\t\ti.item[ 0 ].parentNode.insertBefore( this.placeholder[ 0 ],\n\t\t\t\t( this.direction === \"down\" ? i.item[ 0 ] : i.item[ 0 ].nextSibling ) );\n\t\t}\n\n\t\t//Various things done here to improve the performance:\n\t\t// 1. we create a setTimeout, that calls refreshPositions\n\t\t// 2. on the instance, we have a counter variable, that get's higher after every append\n\t\t// 3. on the local scope, we copy the counter variable, and check in the timeout,\n\t\t// if it's still the same\n\t\t// 4. this lets only the last addition to the timeout stack through\n\t\tthis.counter = this.counter ? ++this.counter : 1;\n\t\tvar counter = this.counter;\n\n\t\tthis._delay( function() {\n\t\t\tif ( counter === this.counter ) {\n\n\t\t\t\t//Precompute after each DOM insertion, NOT on mousemove\n\t\t\t\tthis.refreshPositions( !hardRefresh );\n\t\t\t}\n\t\t} );\n\n\t},\n\n\t_clear: function( event, noPropagation ) {\n\n\t\tthis.reverting = false;\n\n\t\t// We delay all events that have to be triggered to after the point where the placeholder\n\t\t// has been removed and everything else normalized again\n\t\tvar i,\n\t\t\tdelayedTriggers = [];\n\n\t\t// We first have to update the dom position of the actual currentItem\n\t\t// Note: don't do it if the current item is already removed (by a user), or it gets\n\t\t// reappended (see #4088)\n\t\tif ( !this._noFinalSort && this.currentItem.parent().length ) {\n\t\t\tthis.placeholder.before( this.currentItem );\n\t\t}\n\t\tthis._noFinalSort = null;\n\n\t\tif ( this.helper[ 0 ] === this.currentItem[ 0 ] ) {\n\t\t\tfor ( i in this._storedCSS ) {\n\t\t\t\tif ( this._storedCSS[ i ] === \"auto\" || this._storedCSS[ i ] === \"static\" ) {\n\t\t\t\t\tthis._storedCSS[ i ] = \"\";\n\t\t\t\t}\n\t\t\t}\n\t\t\tthis.currentItem.css( this._storedCSS );\n\t\t\tthis._removeClass( this.currentItem, \"ui-sortable-helper\" );\n\t\t} else {\n\t\t\tthis.currentItem.show();\n\t\t}\n\n\t\tif ( this.fromOutside && !noPropagation ) {\n\t\t\tdelayedTriggers.push( function( event ) {\n\t\t\t\tthis._trigger( \"receive\", event, this._uiHash( this.fromOutside ) );\n\t\t\t} );\n\t\t}\n\t\tif ( ( this.fromOutside ||\n\t\t\t\tthis.domPosition.prev !==\n\t\t\t\tthis.currentItem.prev().not( \".ui-sortable-helper\" )[ 0 ] ||\n\t\t\t\tthis.domPosition.parent !== this.currentItem.parent()[ 0 ] ) && !noPropagation ) {\n\n\t\t\t// Trigger update callback if the DOM position has changed\n\t\t\tdelayedTriggers.push( function( event ) {\n\t\t\t\tthis._trigger( \"update\", event, this._uiHash() );\n\t\t\t} );\n\t\t}\n\n\t\t// Check if the items Container has Changed and trigger appropriate\n\t\t// events.\n\t\tif ( this !== this.currentContainer ) {\n\t\t\tif ( !noPropagation ) {\n\t\t\t\tdelayedTriggers.push( function( event ) {\n\t\t\t\t\tthis._trigger( \"remove\", event, this._uiHash() );\n\t\t\t\t} );\n\t\t\t\tdelayedTriggers.push( ( function( c ) {\n\t\t\t\t\treturn function( event ) {\n\t\t\t\t\t\tc._trigger( \"receive\", event, this._uiHash( this ) );\n\t\t\t\t\t};\n\t\t\t\t} ).call( this, this.currentContainer ) );\n\t\t\t\tdelayedTriggers.push( ( function( c ) {\n\t\t\t\t\treturn function( event ) {\n\t\t\t\t\t\tc._trigger( \"update\", event, this._uiHash( this ) );\n\t\t\t\t\t};\n\t\t\t\t} ).call( this, this.currentContainer ) );\n\t\t\t}\n\t\t}\n\n\t\t//Post events to containers\n\t\tfunction delayEvent( type, instance, container ) {\n\t\t\treturn function( event ) {\n\t\t\t\tcontainer._trigger( type, event, instance._uiHash( instance ) );\n\t\t\t};\n\t\t}\n\t\tfor ( i = this.containers.length - 1; i >= 0; i-- ) {\n\t\t\tif ( !noPropagation ) {\n\t\t\t\tdelayedTriggers.push( delayEvent( \"deactivate\", this, this.containers[ i ] ) );\n\t\t\t}\n\t\t\tif ( this.containers[ i ].containerCache.over ) {\n\t\t\t\tdelayedTriggers.push( delayEvent( \"out\", this, this.containers[ i ] ) );\n\t\t\t\tthis.containers[ i ].containerCache.over = 0;\n\t\t\t}\n\t\t}\n\n\t\t//Do what was originally in plugins\n\t\tif ( this.storedCursor ) {\n\t\t\tthis.document.find( \"body\" ).css( \"cursor\", this.storedCursor );\n\t\t\tthis.storedStylesheet.remove();\n\t\t}\n\t\tif ( this._storedOpacity ) {\n\t\t\tthis.helper.css( \"opacity\", this._storedOpacity );\n\t\t}\n\t\tif ( this._storedZIndex ) {\n\t\t\tthis.helper.css( \"zIndex\", this._storedZIndex === \"auto\" ? \"\" : this._storedZIndex );\n\t\t}\n\n\t\tthis.dragging = false;\n\n\t\tif ( !noPropagation ) {\n\t\t\tthis._trigger( \"beforeStop\", event, this._uiHash() );\n\t\t}\n\n\t\t//$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately,\n\t\t// it unbinds ALL events from the original node!\n\t\tthis.placeholder[ 0 ].parentNode.removeChild( this.placeholder[ 0 ] );\n\n\t\tif ( !this.cancelHelperRemoval ) {\n\t\t\tif ( this.helper[ 0 ] !== this.currentItem[ 0 ] ) {\n\t\t\t\tthis.helper.remove();\n\t\t\t}\n\t\t\tthis.helper = null;\n\t\t}\n\n\t\tif ( !noPropagation ) {\n\t\t\tfor ( i = 0; i < delayedTriggers.length; i++ ) {\n\n\t\t\t\t// Trigger all delayed events\n\t\t\t\tdelayedTriggers[ i ].call( this, event );\n\t\t\t}\n\t\t\tthis._trigger( \"stop\", event, this._uiHash() );\n\t\t}\n\n\t\tthis.fromOutside = false;\n\t\treturn !this.cancelHelperRemoval;\n\n\t},\n\n\t_trigger: function() {\n\t\tif ( $.Widget.prototype._trigger.apply( this, arguments ) === false ) {\n\t\t\tthis.cancel();\n\t\t}\n\t},\n\n\t_uiHash: function( _inst ) {\n\t\tvar inst = _inst || this;\n\t\treturn {\n\t\t\thelper: inst.helper,\n\t\t\tplaceholder: inst.placeholder || $( [] ),\n\t\t\tposition: inst.position,\n\t\t\toriginalPosition: inst.originalPosition,\n\t\t\toffset: inst.positionAbs,\n\t\t\titem: inst.currentItem,\n\t\t\tsender: _inst ? _inst.element : null\n\t\t};\n\t}\n\n} );\n\n} );\n","jquery/ui-modules/widgets/draggable.js":"/*!\n * jQuery UI Draggable 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Draggable\n//>>group: Interactions\n//>>description: Enables dragging functionality for any element.\n//>>docs: http://api.jqueryui.com/draggable/\n//>>demos: http://jqueryui.com/draggable/\n//>>css.structure: ../../themes/base/draggable.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./mouse\",\n\t\t\t\"../data\",\n\t\t\t\"../plugin\",\n\t\t\t\"../safe-active-element\",\n\t\t\t\"../safe-blur\",\n\t\t\t\"../scroll-parent\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.draggable\", $.ui.mouse, {\n\tversion: \"1.13.1\",\n\twidgetEventPrefix: \"drag\",\n\toptions: {\n\t\taddClasses: true,\n\t\tappendTo: \"parent\",\n\t\taxis: false,\n\t\tconnectToSortable: false,\n\t\tcontainment: false,\n\t\tcursor: \"auto\",\n\t\tcursorAt: false,\n\t\tgrid: false,\n\t\thandle: false,\n\t\thelper: \"original\",\n\t\tiframeFix: false,\n\t\topacity: false,\n\t\trefreshPositions: false,\n\t\trevert: false,\n\t\trevertDuration: 500,\n\t\tscope: \"default\",\n\t\tscroll: true,\n\t\tscrollSensitivity: 20,\n\t\tscrollSpeed: 20,\n\t\tsnap: false,\n\t\tsnapMode: \"both\",\n\t\tsnapTolerance: 20,\n\t\tstack: false,\n\t\tzIndex: false,\n\n\t\t// Callbacks\n\t\tdrag: null,\n\t\tstart: null,\n\t\tstop: null\n\t},\n\t_create: function() {\n\n\t\tif ( this.options.helper === \"original\" ) {\n\t\t\tthis._setPositionRelative();\n\t\t}\n\t\tif ( this.options.addClasses ) {\n\t\t\tthis._addClass( \"ui-draggable\" );\n\t\t}\n\t\tthis._setHandleClassName();\n\n\t\tthis._mouseInit();\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tthis._super( key, value );\n\t\tif ( key === \"handle\" ) {\n\t\t\tthis._removeHandleClassName();\n\t\t\tthis._setHandleClassName();\n\t\t}\n\t},\n\n\t_destroy: function() {\n\t\tif ( ( this.helper || this.element ).is( \".ui-draggable-dragging\" ) ) {\n\t\t\tthis.destroyOnClear = true;\n\t\t\treturn;\n\t\t}\n\t\tthis._removeHandleClassName();\n\t\tthis._mouseDestroy();\n\t},\n\n\t_mouseCapture: function( event ) {\n\t\tvar o = this.options;\n\n\t\t// Among others, prevent a drag on a resizable-handle\n\t\tif ( this.helper || o.disabled ||\n\t\t\t\t$( event.target ).closest( \".ui-resizable-handle\" ).length > 0 ) {\n\t\t\treturn false;\n\t\t}\n\n\t\t//Quit if we're not on a valid handle\n\t\tthis.handle = this._getHandle( event );\n\t\tif ( !this.handle ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tthis._blurActiveElement( event );\n\n\t\tthis._blockFrames( o.iframeFix === true ? \"iframe\" : o.iframeFix );\n\n\t\treturn true;\n\n\t},\n\n\t_blockFrames: function( selector ) {\n\t\tthis.iframeBlocks = this.document.find( selector ).map( function() {\n\t\t\tvar iframe = $( this );\n\n\t\t\treturn $( \"<div>\" )\n\t\t\t\t.css( \"position\", \"absolute\" )\n\t\t\t\t.appendTo( iframe.parent() )\n\t\t\t\t.outerWidth( iframe.outerWidth() )\n\t\t\t\t.outerHeight( iframe.outerHeight() )\n\t\t\t\t.offset( iframe.offset() )[ 0 ];\n\t\t} );\n\t},\n\n\t_unblockFrames: function() {\n\t\tif ( this.iframeBlocks ) {\n\t\t\tthis.iframeBlocks.remove();\n\t\t\tdelete this.iframeBlocks;\n\t\t}\n\t},\n\n\t_blurActiveElement: function( event ) {\n\t\tvar activeElement = $.ui.safeActiveElement( this.document[ 0 ] ),\n\t\t\ttarget = $( event.target );\n\n\t\t// Don't blur if the event occurred on an element that is within\n\t\t// the currently focused element\n\t\t// See #10527, #12472\n\t\tif ( target.closest( activeElement ).length ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Blur any element that currently has focus, see #4261\n\t\t$.ui.safeBlur( activeElement );\n\t},\n\n\t_mouseStart: function( event ) {\n\n\t\tvar o = this.options;\n\n\t\t//Create and append the visible helper\n\t\tthis.helper = this._createHelper( event );\n\n\t\tthis._addClass( this.helper, \"ui-draggable-dragging\" );\n\n\t\t//Cache the helper size\n\t\tthis._cacheHelperProportions();\n\n\t\t//If ddmanager is used for droppables, set the global draggable\n\t\tif ( $.ui.ddmanager ) {\n\t\t\t$.ui.ddmanager.current = this;\n\t\t}\n\n\t\t/*\n\t\t * - Position generation -\n\t\t * This block generates everything position related - it's the core of draggables.\n\t\t */\n\n\t\t//Cache the margins of the original element\n\t\tthis._cacheMargins();\n\n\t\t//Store the helper's css position\n\t\tthis.cssPosition = this.helper.css( \"position\" );\n\t\tthis.scrollParent = this.helper.scrollParent( true );\n\t\tthis.offsetParent = this.helper.offsetParent();\n\t\tthis.hasFixedAncestor = this.helper.parents().filter( function() {\n\t\t\t\treturn $( this ).css( \"position\" ) === \"fixed\";\n\t\t\t} ).length > 0;\n\n\t\t//The element's absolute position on the page minus margins\n\t\tthis.positionAbs = this.element.offset();\n\t\tthis._refreshOffsets( event );\n\n\t\t//Generate the original position\n\t\tthis.originalPosition = this.position = this._generatePosition( event, false );\n\t\tthis.originalPageX = event.pageX;\n\t\tthis.originalPageY = event.pageY;\n\n\t\t//Adjust the mouse offset relative to the helper if \"cursorAt\" is supplied\n\t\tif ( o.cursorAt ) {\n\t\t\tthis._adjustOffsetFromHelper( o.cursorAt );\n\t\t}\n\n\t\t//Set a containment if given in the options\n\t\tthis._setContainment();\n\n\t\t//Trigger event + callbacks\n\t\tif ( this._trigger( \"start\", event ) === false ) {\n\t\t\tthis._clear();\n\t\t\treturn false;\n\t\t}\n\n\t\t//Recache the helper size\n\t\tthis._cacheHelperProportions();\n\n\t\t//Prepare the droppable offsets\n\t\tif ( $.ui.ddmanager && !o.dropBehaviour ) {\n\t\t\t$.ui.ddmanager.prepareOffsets( this, event );\n\t\t}\n\n\t\t// Execute the drag once - this causes the helper not to be visible before getting its\n\t\t// correct position\n\t\tthis._mouseDrag( event, true );\n\n\t\t// If the ddmanager is used for droppables, inform the manager that dragging has started\n\t\t// (see #5003)\n\t\tif ( $.ui.ddmanager ) {\n\t\t\t$.ui.ddmanager.dragStart( this, event );\n\t\t}\n\n\t\treturn true;\n\t},\n\n\t_refreshOffsets: function( event ) {\n\t\tthis.offset = {\n\t\t\ttop: this.positionAbs.top - this.margins.top,\n\t\t\tleft: this.positionAbs.left - this.margins.left,\n\t\t\tscroll: false,\n\t\t\tparent: this._getParentOffset(),\n\t\t\trelative: this._getRelativeOffset()\n\t\t};\n\n\t\tthis.offset.click = {\n\t\t\tleft: event.pageX - this.offset.left,\n\t\t\ttop: event.pageY - this.offset.top\n\t\t};\n\t},\n\n\t_mouseDrag: function( event, noPropagation ) {\n\n\t\t// reset any necessary cached properties (see #5009)\n\t\tif ( this.hasFixedAncestor ) {\n\t\t\tthis.offset.parent = this._getParentOffset();\n\t\t}\n\n\t\t//Compute the helpers position\n\t\tthis.position = this._generatePosition( event, true );\n\t\tthis.positionAbs = this._convertPositionTo( \"absolute\" );\n\n\t\t//Call plugins and callbacks and use the resulting position if something is returned\n\t\tif ( !noPropagation ) {\n\t\t\tvar ui = this._uiHash();\n\t\t\tif ( this._trigger( \"drag\", event, ui ) === false ) {\n\t\t\t\tthis._mouseUp( new $.Event( \"mouseup\", event ) );\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tthis.position = ui.position;\n\t\t}\n\n\t\tthis.helper[ 0 ].style.left = this.position.left + \"px\";\n\t\tthis.helper[ 0 ].style.top = this.position.top + \"px\";\n\n\t\tif ( $.ui.ddmanager ) {\n\t\t\t$.ui.ddmanager.drag( this, event );\n\t\t}\n\n\t\treturn false;\n\t},\n\n\t_mouseStop: function( event ) {\n\n\t\t//If we are using droppables, inform the manager about the drop\n\t\tvar that = this,\n\t\t\tdropped = false;\n\t\tif ( $.ui.ddmanager && !this.options.dropBehaviour ) {\n\t\t\tdropped = $.ui.ddmanager.drop( this, event );\n\t\t}\n\n\t\t//if a drop comes from outside (a sortable)\n\t\tif ( this.dropped ) {\n\t\t\tdropped = this.dropped;\n\t\t\tthis.dropped = false;\n\t\t}\n\n\t\tif ( ( this.options.revert === \"invalid\" && !dropped ) ||\n\t\t\t\t( this.options.revert === \"valid\" && dropped ) ||\n\t\t\t\tthis.options.revert === true || ( typeof this.options.revert === \"function\" &&\n\t\t\t\tthis.options.revert.call( this.element, dropped ) )\n\t\t) {\n\t\t\t$( this.helper ).animate(\n\t\t\t\tthis.originalPosition,\n\t\t\t\tparseInt( this.options.revertDuration, 10 ),\n\t\t\t\tfunction() {\n\t\t\t\t\tif ( that._trigger( \"stop\", event ) !== false ) {\n\t\t\t\t\t\tthat._clear();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t);\n\t\t} else {\n\t\t\tif ( this._trigger( \"stop\", event ) !== false ) {\n\t\t\t\tthis._clear();\n\t\t\t}\n\t\t}\n\n\t\treturn false;\n\t},\n\n\t_mouseUp: function( event ) {\n\t\tthis._unblockFrames();\n\n\t\t// If the ddmanager is used for droppables, inform the manager that dragging has stopped\n\t\t// (see #5003)\n\t\tif ( $.ui.ddmanager ) {\n\t\t\t$.ui.ddmanager.dragStop( this, event );\n\t\t}\n\n\t\t// Only need to focus if the event occurred on the draggable itself, see #10527\n\t\tif ( this.handleElement.is( event.target ) ) {\n\n\t\t\t// The interaction is over; whether or not the click resulted in a drag,\n\t\t\t// focus the element\n\t\t\tthis.element.trigger( \"focus\" );\n\t\t}\n\n\t\treturn $.ui.mouse.prototype._mouseUp.call( this, event );\n\t},\n\n\tcancel: function() {\n\n\t\tif ( this.helper.is( \".ui-draggable-dragging\" ) ) {\n\t\t\tthis._mouseUp( new $.Event( \"mouseup\", { target: this.element[ 0 ] } ) );\n\t\t} else {\n\t\t\tthis._clear();\n\t\t}\n\n\t\treturn this;\n\n\t},\n\n\t_getHandle: function( event ) {\n\t\treturn this.options.handle ?\n\t\t\t!!$( event.target ).closest( this.element.find( this.options.handle ) ).length :\n\t\t\ttrue;\n\t},\n\n\t_setHandleClassName: function() {\n\t\tthis.handleElement = this.options.handle ?\n\t\t\tthis.element.find( this.options.handle ) : this.element;\n\t\tthis._addClass( this.handleElement, \"ui-draggable-handle\" );\n\t},\n\n\t_removeHandleClassName: function() {\n\t\tthis._removeClass( this.handleElement, \"ui-draggable-handle\" );\n\t},\n\n\t_createHelper: function( event ) {\n\n\t\tvar o = this.options,\n\t\t\thelperIsFunction = typeof o.helper === \"function\",\n\t\t\thelper = helperIsFunction ?\n\t\t\t\t$( o.helper.apply( this.element[ 0 ], [ event ] ) ) :\n\t\t\t\t( o.helper === \"clone\" ?\n\t\t\t\t\tthis.element.clone().removeAttr( \"id\" ) :\n\t\t\t\t\tthis.element );\n\n\t\tif ( !helper.parents( \"body\" ).length ) {\n\t\t\thelper.appendTo( ( o.appendTo === \"parent\" ?\n\t\t\t\tthis.element[ 0 ].parentNode :\n\t\t\t\to.appendTo ) );\n\t\t}\n\n\t\t// Http://bugs.jqueryui.com/ticket/9446\n\t\t// a helper function can return the original element\n\t\t// which wouldn't have been set to relative in _create\n\t\tif ( helperIsFunction && helper[ 0 ] === this.element[ 0 ] ) {\n\t\t\tthis._setPositionRelative();\n\t\t}\n\n\t\tif ( helper[ 0 ] !== this.element[ 0 ] &&\n\t\t\t\t!( /(fixed|absolute)/ ).test( helper.css( \"position\" ) ) ) {\n\t\t\thelper.css( \"position\", \"absolute\" );\n\t\t}\n\n\t\treturn helper;\n\n\t},\n\n\t_setPositionRelative: function() {\n\t\tif ( !( /^(?:r|a|f)/ ).test( this.element.css( \"position\" ) ) ) {\n\t\t\tthis.element[ 0 ].style.position = \"relative\";\n\t\t}\n\t},\n\n\t_adjustOffsetFromHelper: function( obj ) {\n\t\tif ( typeof obj === \"string\" ) {\n\t\t\tobj = obj.split( \" \" );\n\t\t}\n\t\tif ( Array.isArray( obj ) ) {\n\t\t\tobj = { left: +obj[ 0 ], top: +obj[ 1 ] || 0 };\n\t\t}\n\t\tif ( \"left\" in obj ) {\n\t\t\tthis.offset.click.left = obj.left + this.margins.left;\n\t\t}\n\t\tif ( \"right\" in obj ) {\n\t\t\tthis.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;\n\t\t}\n\t\tif ( \"top\" in obj ) {\n\t\t\tthis.offset.click.top = obj.top + this.margins.top;\n\t\t}\n\t\tif ( \"bottom\" in obj ) {\n\t\t\tthis.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;\n\t\t}\n\t},\n\n\t_isRootNode: function( element ) {\n\t\treturn ( /(html|body)/i ).test( element.tagName ) || element === this.document[ 0 ];\n\t},\n\n\t_getParentOffset: function() {\n\n\t\t//Get the offsetParent and cache its position\n\t\tvar po = this.offsetParent.offset(),\n\t\t\tdocument = this.document[ 0 ];\n\n\t\t// This is a special case where we need to modify a offset calculated on start, since the\n\t\t// following happened:\n\t\t// 1. The position of the helper is absolute, so it's position is calculated based on the\n\t\t// next positioned parent\n\t\t// 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't\n\t\t// the document, which means that the scroll is included in the initial calculation of the\n\t\t// offset of the parent, and never recalculated upon drag\n\t\tif ( this.cssPosition === \"absolute\" && this.scrollParent[ 0 ] !== document &&\n\t\t\t\t$.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) {\n\t\t\tpo.left += this.scrollParent.scrollLeft();\n\t\t\tpo.top += this.scrollParent.scrollTop();\n\t\t}\n\n\t\tif ( this._isRootNode( this.offsetParent[ 0 ] ) ) {\n\t\t\tpo = { top: 0, left: 0 };\n\t\t}\n\n\t\treturn {\n\t\t\ttop: po.top + ( parseInt( this.offsetParent.css( \"borderTopWidth\" ), 10 ) || 0 ),\n\t\t\tleft: po.left + ( parseInt( this.offsetParent.css( \"borderLeftWidth\" ), 10 ) || 0 )\n\t\t};\n\n\t},\n\n\t_getRelativeOffset: function() {\n\t\tif ( this.cssPosition !== \"relative\" ) {\n\t\t\treturn { top: 0, left: 0 };\n\t\t}\n\n\t\tvar p = this.element.position(),\n\t\t\tscrollIsRootNode = this._isRootNode( this.scrollParent[ 0 ] );\n\n\t\treturn {\n\t\t\ttop: p.top - ( parseInt( this.helper.css( \"top\" ), 10 ) || 0 ) +\n\t\t\t\t( !scrollIsRootNode ? this.scrollParent.scrollTop() : 0 ),\n\t\t\tleft: p.left - ( parseInt( this.helper.css( \"left\" ), 10 ) || 0 ) +\n\t\t\t\t( !scrollIsRootNode ? this.scrollParent.scrollLeft() : 0 )\n\t\t};\n\n\t},\n\n\t_cacheMargins: function() {\n\t\tthis.margins = {\n\t\t\tleft: ( parseInt( this.element.css( \"marginLeft\" ), 10 ) || 0 ),\n\t\t\ttop: ( parseInt( this.element.css( \"marginTop\" ), 10 ) || 0 ),\n\t\t\tright: ( parseInt( this.element.css( \"marginRight\" ), 10 ) || 0 ),\n\t\t\tbottom: ( parseInt( this.element.css( \"marginBottom\" ), 10 ) || 0 )\n\t\t};\n\t},\n\n\t_cacheHelperProportions: function() {\n\t\tthis.helperProportions = {\n\t\t\twidth: this.helper.outerWidth(),\n\t\t\theight: this.helper.outerHeight()\n\t\t};\n\t},\n\n\t_setContainment: function() {\n\n\t\tvar isUserScrollable, c, ce,\n\t\t\to = this.options,\n\t\t\tdocument = this.document[ 0 ];\n\n\t\tthis.relativeContainer = null;\n\n\t\tif ( !o.containment ) {\n\t\t\tthis.containment = null;\n\t\t\treturn;\n\t\t}\n\n\t\tif ( o.containment === \"window\" ) {\n\t\t\tthis.containment = [\n\t\t\t\t$( window ).scrollLeft() - this.offset.relative.left - this.offset.parent.left,\n\t\t\t\t$( window ).scrollTop() - this.offset.relative.top - this.offset.parent.top,\n\t\t\t\t$( window ).scrollLeft() + $( window ).width() -\n\t\t\t\t\tthis.helperProportions.width - this.margins.left,\n\t\t\t\t$( window ).scrollTop() +\n\t\t\t\t\t( $( window ).height() || document.body.parentNode.scrollHeight ) -\n\t\t\t\t\tthis.helperProportions.height - this.margins.top\n\t\t\t];\n\t\t\treturn;\n\t\t}\n\n\t\tif ( o.containment === \"document\" ) {\n\t\t\tthis.containment = [\n\t\t\t\t0,\n\t\t\t\t0,\n\t\t\t\t$( document ).width() - this.helperProportions.width - this.margins.left,\n\t\t\t\t( $( document ).height() || document.body.parentNode.scrollHeight ) -\n\t\t\t\t\tthis.helperProportions.height - this.margins.top\n\t\t\t];\n\t\t\treturn;\n\t\t}\n\n\t\tif ( o.containment.constructor === Array ) {\n\t\t\tthis.containment = o.containment;\n\t\t\treturn;\n\t\t}\n\n\t\tif ( o.containment === \"parent\" ) {\n\t\t\to.containment = this.helper[ 0 ].parentNode;\n\t\t}\n\n\t\tc = $( o.containment );\n\t\tce = c[ 0 ];\n\n\t\tif ( !ce ) {\n\t\t\treturn;\n\t\t}\n\n\t\tisUserScrollable = /(scroll|auto)/.test( c.css( \"overflow\" ) );\n\n\t\tthis.containment = [\n\t\t\t( parseInt( c.css( \"borderLeftWidth\" ), 10 ) || 0 ) +\n\t\t\t\t( parseInt( c.css( \"paddingLeft\" ), 10 ) || 0 ),\n\t\t\t( parseInt( c.css( \"borderTopWidth\" ), 10 ) || 0 ) +\n\t\t\t\t( parseInt( c.css( \"paddingTop\" ), 10 ) || 0 ),\n\t\t\t( isUserScrollable ? Math.max( ce.scrollWidth, ce.offsetWidth ) : ce.offsetWidth ) -\n\t\t\t\t( parseInt( c.css( \"borderRightWidth\" ), 10 ) || 0 ) -\n\t\t\t\t( parseInt( c.css( \"paddingRight\" ), 10 ) || 0 ) -\n\t\t\t\tthis.helperProportions.width -\n\t\t\t\tthis.margins.left -\n\t\t\t\tthis.margins.right,\n\t\t\t( isUserScrollable ? Math.max( ce.scrollHeight, ce.offsetHeight ) : ce.offsetHeight ) -\n\t\t\t\t( parseInt( c.css( \"borderBottomWidth\" ), 10 ) || 0 ) -\n\t\t\t\t( parseInt( c.css( \"paddingBottom\" ), 10 ) || 0 ) -\n\t\t\t\tthis.helperProportions.height -\n\t\t\t\tthis.margins.top -\n\t\t\t\tthis.margins.bottom\n\t\t];\n\t\tthis.relativeContainer = c;\n\t},\n\n\t_convertPositionTo: function( d, pos ) {\n\n\t\tif ( !pos ) {\n\t\t\tpos = this.position;\n\t\t}\n\n\t\tvar mod = d === \"absolute\" ? 1 : -1,\n\t\t\tscrollIsRootNode = this._isRootNode( this.scrollParent[ 0 ] );\n\n\t\treturn {\n\t\t\ttop: (\n\n\t\t\t\t// The absolute mouse position\n\t\t\t\tpos.top\t+\n\n\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\tthis.offset.relative.top * mod +\n\n\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\tthis.offset.parent.top * mod -\n\t\t\t\t( ( this.cssPosition === \"fixed\" ?\n\t\t\t\t\t-this.offset.scroll.top :\n\t\t\t\t\t( scrollIsRootNode ? 0 : this.offset.scroll.top ) ) * mod )\n\t\t\t),\n\t\t\tleft: (\n\n\t\t\t\t// The absolute mouse position\n\t\t\t\tpos.left +\n\n\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\tthis.offset.relative.left * mod +\n\n\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\tthis.offset.parent.left * mod\t-\n\t\t\t\t( ( this.cssPosition === \"fixed\" ?\n\t\t\t\t\t-this.offset.scroll.left :\n\t\t\t\t\t( scrollIsRootNode ? 0 : this.offset.scroll.left ) ) * mod )\n\t\t\t)\n\t\t};\n\n\t},\n\n\t_generatePosition: function( event, constrainPosition ) {\n\n\t\tvar containment, co, top, left,\n\t\t\to = this.options,\n\t\t\tscrollIsRootNode = this._isRootNode( this.scrollParent[ 0 ] ),\n\t\t\tpageX = event.pageX,\n\t\t\tpageY = event.pageY;\n\n\t\t// Cache the scroll\n\t\tif ( !scrollIsRootNode || !this.offset.scroll ) {\n\t\t\tthis.offset.scroll = {\n\t\t\t\ttop: this.scrollParent.scrollTop(),\n\t\t\t\tleft: this.scrollParent.scrollLeft()\n\t\t\t};\n\t\t}\n\n\t\t/*\n\t\t * - Position constraining -\n\t\t * Constrain the position to a mix of grid, containment.\n\t\t */\n\n\t\t// If we are not dragging yet, we won't check for options\n\t\tif ( constrainPosition ) {\n\t\t\tif ( this.containment ) {\n\t\t\t\tif ( this.relativeContainer ) {\n\t\t\t\t\tco = this.relativeContainer.offset();\n\t\t\t\t\tcontainment = [\n\t\t\t\t\t\tthis.containment[ 0 ] + co.left,\n\t\t\t\t\t\tthis.containment[ 1 ] + co.top,\n\t\t\t\t\t\tthis.containment[ 2 ] + co.left,\n\t\t\t\t\t\tthis.containment[ 3 ] + co.top\n\t\t\t\t\t];\n\t\t\t\t} else {\n\t\t\t\t\tcontainment = this.containment;\n\t\t\t\t}\n\n\t\t\t\tif ( event.pageX - this.offset.click.left < containment[ 0 ] ) {\n\t\t\t\t\tpageX = containment[ 0 ] + this.offset.click.left;\n\t\t\t\t}\n\t\t\t\tif ( event.pageY - this.offset.click.top < containment[ 1 ] ) {\n\t\t\t\t\tpageY = containment[ 1 ] + this.offset.click.top;\n\t\t\t\t}\n\t\t\t\tif ( event.pageX - this.offset.click.left > containment[ 2 ] ) {\n\t\t\t\t\tpageX = containment[ 2 ] + this.offset.click.left;\n\t\t\t\t}\n\t\t\t\tif ( event.pageY - this.offset.click.top > containment[ 3 ] ) {\n\t\t\t\t\tpageY = containment[ 3 ] + this.offset.click.top;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( o.grid ) {\n\n\t\t\t\t//Check for grid elements set to 0 to prevent divide by 0 error causing invalid\n\t\t\t\t// argument errors in IE (see ticket #6950)\n\t\t\t\ttop = o.grid[ 1 ] ? this.originalPageY + Math.round( ( pageY -\n\t\t\t\t\tthis.originalPageY ) / o.grid[ 1 ] ) * o.grid[ 1 ] : this.originalPageY;\n\t\t\t\tpageY = containment ? ( ( top - this.offset.click.top >= containment[ 1 ] ||\n\t\t\t\t\ttop - this.offset.click.top > containment[ 3 ] ) ?\n\t\t\t\t\t\ttop :\n\t\t\t\t\t\t( ( top - this.offset.click.top >= containment[ 1 ] ) ?\n\t\t\t\t\t\t\ttop - o.grid[ 1 ] : top + o.grid[ 1 ] ) ) : top;\n\n\t\t\t\tleft = o.grid[ 0 ] ? this.originalPageX +\n\t\t\t\t\tMath.round( ( pageX - this.originalPageX ) / o.grid[ 0 ] ) * o.grid[ 0 ] :\n\t\t\t\t\tthis.originalPageX;\n\t\t\t\tpageX = containment ? ( ( left - this.offset.click.left >= containment[ 0 ] ||\n\t\t\t\t\tleft - this.offset.click.left > containment[ 2 ] ) ?\n\t\t\t\t\t\tleft :\n\t\t\t\t\t\t( ( left - this.offset.click.left >= containment[ 0 ] ) ?\n\t\t\t\t\t\t\tleft - o.grid[ 0 ] : left + o.grid[ 0 ] ) ) : left;\n\t\t\t}\n\n\t\t\tif ( o.axis === \"y\" ) {\n\t\t\t\tpageX = this.originalPageX;\n\t\t\t}\n\n\t\t\tif ( o.axis === \"x\" ) {\n\t\t\t\tpageY = this.originalPageY;\n\t\t\t}\n\t\t}\n\n\t\treturn {\n\t\t\ttop: (\n\n\t\t\t\t// The absolute mouse position\n\t\t\t\tpageY -\n\n\t\t\t\t// Click offset (relative to the element)\n\t\t\t\tthis.offset.click.top -\n\n\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\tthis.offset.relative.top -\n\n\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\tthis.offset.parent.top +\n\t\t\t\t( this.cssPosition === \"fixed\" ?\n\t\t\t\t\t-this.offset.scroll.top :\n\t\t\t\t\t( scrollIsRootNode ? 0 : this.offset.scroll.top ) )\n\t\t\t),\n\t\t\tleft: (\n\n\t\t\t\t// The absolute mouse position\n\t\t\t\tpageX -\n\n\t\t\t\t// Click offset (relative to the element)\n\t\t\t\tthis.offset.click.left -\n\n\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\tthis.offset.relative.left -\n\n\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\tthis.offset.parent.left +\n\t\t\t\t( this.cssPosition === \"fixed\" ?\n\t\t\t\t\t-this.offset.scroll.left :\n\t\t\t\t\t( scrollIsRootNode ? 0 : this.offset.scroll.left ) )\n\t\t\t)\n\t\t};\n\n\t},\n\n\t_clear: function() {\n\t\tthis._removeClass( this.helper, \"ui-draggable-dragging\" );\n\t\tif ( this.helper[ 0 ] !== this.element[ 0 ] && !this.cancelHelperRemoval ) {\n\t\t\tthis.helper.remove();\n\t\t}\n\t\tthis.helper = null;\n\t\tthis.cancelHelperRemoval = false;\n\t\tif ( this.destroyOnClear ) {\n\t\t\tthis.destroy();\n\t\t}\n\t},\n\n\t// From now on bulk stuff - mainly helpers\n\n\t_trigger: function( type, event, ui ) {\n\t\tui = ui || this._uiHash();\n\t\t$.ui.plugin.call( this, type, [ event, ui, this ], true );\n\n\t\t// Absolute position and offset (see #6884 ) have to be recalculated after plugins\n\t\tif ( /^(drag|start|stop)/.test( type ) ) {\n\t\t\tthis.positionAbs = this._convertPositionTo( \"absolute\" );\n\t\t\tui.offset = this.positionAbs;\n\t\t}\n\t\treturn $.Widget.prototype._trigger.call( this, type, event, ui );\n\t},\n\n\tplugins: {},\n\n\t_uiHash: function() {\n\t\treturn {\n\t\t\thelper: this.helper,\n\t\t\tposition: this.position,\n\t\t\toriginalPosition: this.originalPosition,\n\t\t\toffset: this.positionAbs\n\t\t};\n\t}\n\n} );\n\n$.ui.plugin.add( \"draggable\", \"connectToSortable\", {\n\tstart: function( event, ui, draggable ) {\n\t\tvar uiSortable = $.extend( {}, ui, {\n\t\t\titem: draggable.element\n\t\t} );\n\n\t\tdraggable.sortables = [];\n\t\t$( draggable.options.connectToSortable ).each( function() {\n\t\t\tvar sortable = $( this ).sortable( \"instance\" );\n\n\t\t\tif ( sortable && !sortable.options.disabled ) {\n\t\t\t\tdraggable.sortables.push( sortable );\n\n\t\t\t\t// RefreshPositions is called at drag start to refresh the containerCache\n\t\t\t\t// which is used in drag. This ensures it's initialized and synchronized\n\t\t\t\t// with any changes that might have happened on the page since initialization.\n\t\t\t\tsortable.refreshPositions();\n\t\t\t\tsortable._trigger( \"activate\", event, uiSortable );\n\t\t\t}\n\t\t} );\n\t},\n\tstop: function( event, ui, draggable ) {\n\t\tvar uiSortable = $.extend( {}, ui, {\n\t\t\titem: draggable.element\n\t\t} );\n\n\t\tdraggable.cancelHelperRemoval = false;\n\n\t\t$.each( draggable.sortables, function() {\n\t\t\tvar sortable = this;\n\n\t\t\tif ( sortable.isOver ) {\n\t\t\t\tsortable.isOver = 0;\n\n\t\t\t\t// Allow this sortable to handle removing the helper\n\t\t\t\tdraggable.cancelHelperRemoval = true;\n\t\t\t\tsortable.cancelHelperRemoval = false;\n\n\t\t\t\t// Use _storedCSS To restore properties in the sortable,\n\t\t\t\t// as this also handles revert (#9675) since the draggable\n\t\t\t\t// may have modified them in unexpected ways (#8809)\n\t\t\t\tsortable._storedCSS = {\n\t\t\t\t\tposition: sortable.placeholder.css( \"position\" ),\n\t\t\t\t\ttop: sortable.placeholder.css( \"top\" ),\n\t\t\t\t\tleft: sortable.placeholder.css( \"left\" )\n\t\t\t\t};\n\n\t\t\t\tsortable._mouseStop( event );\n\n\t\t\t\t// Once drag has ended, the sortable should return to using\n\t\t\t\t// its original helper, not the shared helper from draggable\n\t\t\t\tsortable.options.helper = sortable.options._helper;\n\t\t\t} else {\n\n\t\t\t\t// Prevent this Sortable from removing the helper.\n\t\t\t\t// However, don't set the draggable to remove the helper\n\t\t\t\t// either as another connected Sortable may yet handle the removal.\n\t\t\t\tsortable.cancelHelperRemoval = true;\n\n\t\t\t\tsortable._trigger( \"deactivate\", event, uiSortable );\n\t\t\t}\n\t\t} );\n\t},\n\tdrag: function( event, ui, draggable ) {\n\t\t$.each( draggable.sortables, function() {\n\t\t\tvar innermostIntersecting = false,\n\t\t\t\tsortable = this;\n\n\t\t\t// Copy over variables that sortable's _intersectsWith uses\n\t\t\tsortable.positionAbs = draggable.positionAbs;\n\t\t\tsortable.helperProportions = draggable.helperProportions;\n\t\t\tsortable.offset.click = draggable.offset.click;\n\n\t\t\tif ( sortable._intersectsWith( sortable.containerCache ) ) {\n\t\t\t\tinnermostIntersecting = true;\n\n\t\t\t\t$.each( draggable.sortables, function() {\n\n\t\t\t\t\t// Copy over variables that sortable's _intersectsWith uses\n\t\t\t\t\tthis.positionAbs = draggable.positionAbs;\n\t\t\t\t\tthis.helperProportions = draggable.helperProportions;\n\t\t\t\t\tthis.offset.click = draggable.offset.click;\n\n\t\t\t\t\tif ( this !== sortable &&\n\t\t\t\t\t\t\tthis._intersectsWith( this.containerCache ) &&\n\t\t\t\t\t\t\t$.contains( sortable.element[ 0 ], this.element[ 0 ] ) ) {\n\t\t\t\t\t\tinnermostIntersecting = false;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn innermostIntersecting;\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tif ( innermostIntersecting ) {\n\n\t\t\t\t// If it intersects, we use a little isOver variable and set it once,\n\t\t\t\t// so that the move-in stuff gets fired only once.\n\t\t\t\tif ( !sortable.isOver ) {\n\t\t\t\t\tsortable.isOver = 1;\n\n\t\t\t\t\t// Store draggable's parent in case we need to reappend to it later.\n\t\t\t\t\tdraggable._parent = ui.helper.parent();\n\n\t\t\t\t\tsortable.currentItem = ui.helper\n\t\t\t\t\t\t.appendTo( sortable.element )\n\t\t\t\t\t\t.data( \"ui-sortable-item\", true );\n\n\t\t\t\t\t// Store helper option to later restore it\n\t\t\t\t\tsortable.options._helper = sortable.options.helper;\n\n\t\t\t\t\tsortable.options.helper = function() {\n\t\t\t\t\t\treturn ui.helper[ 0 ];\n\t\t\t\t\t};\n\n\t\t\t\t\t// Fire the start events of the sortable with our passed browser event,\n\t\t\t\t\t// and our own helper (so it doesn't create a new one)\n\t\t\t\t\tevent.target = sortable.currentItem[ 0 ];\n\t\t\t\t\tsortable._mouseCapture( event, true );\n\t\t\t\t\tsortable._mouseStart( event, true, true );\n\n\t\t\t\t\t// Because the browser event is way off the new appended portlet,\n\t\t\t\t\t// modify necessary variables to reflect the changes\n\t\t\t\t\tsortable.offset.click.top = draggable.offset.click.top;\n\t\t\t\t\tsortable.offset.click.left = draggable.offset.click.left;\n\t\t\t\t\tsortable.offset.parent.left -= draggable.offset.parent.left -\n\t\t\t\t\t\tsortable.offset.parent.left;\n\t\t\t\t\tsortable.offset.parent.top -= draggable.offset.parent.top -\n\t\t\t\t\t\tsortable.offset.parent.top;\n\n\t\t\t\t\tdraggable._trigger( \"toSortable\", event );\n\n\t\t\t\t\t// Inform draggable that the helper is in a valid drop zone,\n\t\t\t\t\t// used solely in the revert option to handle \"valid/invalid\".\n\t\t\t\t\tdraggable.dropped = sortable.element;\n\n\t\t\t\t\t// Need to refreshPositions of all sortables in the case that\n\t\t\t\t\t// adding to one sortable changes the location of the other sortables (#9675)\n\t\t\t\t\t$.each( draggable.sortables, function() {\n\t\t\t\t\t\tthis.refreshPositions();\n\t\t\t\t\t} );\n\n\t\t\t\t\t// Hack so receive/update callbacks work (mostly)\n\t\t\t\t\tdraggable.currentItem = draggable.element;\n\t\t\t\t\tsortable.fromOutside = draggable;\n\t\t\t\t}\n\n\t\t\t\tif ( sortable.currentItem ) {\n\t\t\t\t\tsortable._mouseDrag( event );\n\n\t\t\t\t\t// Copy the sortable's position because the draggable's can potentially reflect\n\t\t\t\t\t// a relative position, while sortable is always absolute, which the dragged\n\t\t\t\t\t// element has now become. (#8809)\n\t\t\t\t\tui.position = sortable.position;\n\t\t\t\t}\n\t\t\t} else {\n\n\t\t\t\t// If it doesn't intersect with the sortable, and it intersected before,\n\t\t\t\t// we fake the drag stop of the sortable, but make sure it doesn't remove\n\t\t\t\t// the helper by using cancelHelperRemoval.\n\t\t\t\tif ( sortable.isOver ) {\n\n\t\t\t\t\tsortable.isOver = 0;\n\t\t\t\t\tsortable.cancelHelperRemoval = true;\n\n\t\t\t\t\t// Calling sortable's mouseStop would trigger a revert,\n\t\t\t\t\t// so revert must be temporarily false until after mouseStop is called.\n\t\t\t\t\tsortable.options._revert = sortable.options.revert;\n\t\t\t\t\tsortable.options.revert = false;\n\n\t\t\t\t\tsortable._trigger( \"out\", event, sortable._uiHash( sortable ) );\n\t\t\t\t\tsortable._mouseStop( event, true );\n\n\t\t\t\t\t// Restore sortable behaviors that were modfied\n\t\t\t\t\t// when the draggable entered the sortable area (#9481)\n\t\t\t\t\tsortable.options.revert = sortable.options._revert;\n\t\t\t\t\tsortable.options.helper = sortable.options._helper;\n\n\t\t\t\t\tif ( sortable.placeholder ) {\n\t\t\t\t\t\tsortable.placeholder.remove();\n\t\t\t\t\t}\n\n\t\t\t\t\t// Restore and recalculate the draggable's offset considering the sortable\n\t\t\t\t\t// may have modified them in unexpected ways. (#8809, #10669)\n\t\t\t\t\tui.helper.appendTo( draggable._parent );\n\t\t\t\t\tdraggable._refreshOffsets( event );\n\t\t\t\t\tui.position = draggable._generatePosition( event, true );\n\n\t\t\t\t\tdraggable._trigger( \"fromSortable\", event );\n\n\t\t\t\t\t// Inform draggable that the helper is no longer in a valid drop zone\n\t\t\t\t\tdraggable.dropped = false;\n\n\t\t\t\t\t// Need to refreshPositions of all sortables just in case removing\n\t\t\t\t\t// from one sortable changes the location of other sortables (#9675)\n\t\t\t\t\t$.each( draggable.sortables, function() {\n\t\t\t\t\t\tthis.refreshPositions();\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t}\n\t\t} );\n\t}\n} );\n\n$.ui.plugin.add( \"draggable\", \"cursor\", {\n\tstart: function( event, ui, instance ) {\n\t\tvar t = $( \"body\" ),\n\t\t\to = instance.options;\n\n\t\tif ( t.css( \"cursor\" ) ) {\n\t\t\to._cursor = t.css( \"cursor\" );\n\t\t}\n\t\tt.css( \"cursor\", o.cursor );\n\t},\n\tstop: function( event, ui, instance ) {\n\t\tvar o = instance.options;\n\t\tif ( o._cursor ) {\n\t\t\t$( \"body\" ).css( \"cursor\", o._cursor );\n\t\t}\n\t}\n} );\n\n$.ui.plugin.add( \"draggable\", \"opacity\", {\n\tstart: function( event, ui, instance ) {\n\t\tvar t = $( ui.helper ),\n\t\t\to = instance.options;\n\t\tif ( t.css( \"opacity\" ) ) {\n\t\t\to._opacity = t.css( \"opacity\" );\n\t\t}\n\t\tt.css( \"opacity\", o.opacity );\n\t},\n\tstop: function( event, ui, instance ) {\n\t\tvar o = instance.options;\n\t\tif ( o._opacity ) {\n\t\t\t$( ui.helper ).css( \"opacity\", o._opacity );\n\t\t}\n\t}\n} );\n\n$.ui.plugin.add( \"draggable\", \"scroll\", {\n\tstart: function( event, ui, i ) {\n\t\tif ( !i.scrollParentNotHidden ) {\n\t\t\ti.scrollParentNotHidden = i.helper.scrollParent( false );\n\t\t}\n\n\t\tif ( i.scrollParentNotHidden[ 0 ] !== i.document[ 0 ] &&\n\t\t\t\ti.scrollParentNotHidden[ 0 ].tagName !== \"HTML\" ) {\n\t\t\ti.overflowOffset = i.scrollParentNotHidden.offset();\n\t\t}\n\t},\n\tdrag: function( event, ui, i  ) {\n\n\t\tvar o = i.options,\n\t\t\tscrolled = false,\n\t\t\tscrollParent = i.scrollParentNotHidden[ 0 ],\n\t\t\tdocument = i.document[ 0 ];\n\n\t\tif ( scrollParent !== document && scrollParent.tagName !== \"HTML\" ) {\n\t\t\tif ( !o.axis || o.axis !== \"x\" ) {\n\t\t\t\tif ( ( i.overflowOffset.top + scrollParent.offsetHeight ) - event.pageY <\n\t\t\t\t\t\to.scrollSensitivity ) {\n\t\t\t\t\tscrollParent.scrollTop = scrolled = scrollParent.scrollTop + o.scrollSpeed;\n\t\t\t\t} else if ( event.pageY - i.overflowOffset.top < o.scrollSensitivity ) {\n\t\t\t\t\tscrollParent.scrollTop = scrolled = scrollParent.scrollTop - o.scrollSpeed;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( !o.axis || o.axis !== \"y\" ) {\n\t\t\t\tif ( ( i.overflowOffset.left + scrollParent.offsetWidth ) - event.pageX <\n\t\t\t\t\t\to.scrollSensitivity ) {\n\t\t\t\t\tscrollParent.scrollLeft = scrolled = scrollParent.scrollLeft + o.scrollSpeed;\n\t\t\t\t} else if ( event.pageX - i.overflowOffset.left < o.scrollSensitivity ) {\n\t\t\t\t\tscrollParent.scrollLeft = scrolled = scrollParent.scrollLeft - o.scrollSpeed;\n\t\t\t\t}\n\t\t\t}\n\n\t\t} else {\n\n\t\t\tif ( !o.axis || o.axis !== \"x\" ) {\n\t\t\t\tif ( event.pageY - $( document ).scrollTop() < o.scrollSensitivity ) {\n\t\t\t\t\tscrolled = $( document ).scrollTop( $( document ).scrollTop() - o.scrollSpeed );\n\t\t\t\t} else if ( $( window ).height() - ( event.pageY - $( document ).scrollTop() ) <\n\t\t\t\t\t\to.scrollSensitivity ) {\n\t\t\t\t\tscrolled = $( document ).scrollTop( $( document ).scrollTop() + o.scrollSpeed );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( !o.axis || o.axis !== \"y\" ) {\n\t\t\t\tif ( event.pageX - $( document ).scrollLeft() < o.scrollSensitivity ) {\n\t\t\t\t\tscrolled = $( document ).scrollLeft(\n\t\t\t\t\t\t$( document ).scrollLeft() - o.scrollSpeed\n\t\t\t\t\t);\n\t\t\t\t} else if ( $( window ).width() - ( event.pageX - $( document ).scrollLeft() ) <\n\t\t\t\t\t\to.scrollSensitivity ) {\n\t\t\t\t\tscrolled = $( document ).scrollLeft(\n\t\t\t\t\t\t$( document ).scrollLeft() + o.scrollSpeed\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t}\n\n\t\t}\n\n\t\tif ( scrolled !== false && $.ui.ddmanager && !o.dropBehaviour ) {\n\t\t\t$.ui.ddmanager.prepareOffsets( i, event );\n\t\t}\n\n\t}\n} );\n\n$.ui.plugin.add( \"draggable\", \"snap\", {\n\tstart: function( event, ui, i ) {\n\n\t\tvar o = i.options;\n\n\t\ti.snapElements = [];\n\n\t\t$( o.snap.constructor !== String ? ( o.snap.items || \":data(ui-draggable)\" ) : o.snap )\n\t\t\t.each( function() {\n\t\t\t\tvar $t = $( this ),\n\t\t\t\t\t$o = $t.offset();\n\t\t\t\tif ( this !== i.element[ 0 ] ) {\n\t\t\t\t\ti.snapElements.push( {\n\t\t\t\t\t\titem: this,\n\t\t\t\t\t\twidth: $t.outerWidth(), height: $t.outerHeight(),\n\t\t\t\t\t\ttop: $o.top, left: $o.left\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t} );\n\n\t},\n\tdrag: function( event, ui, inst ) {\n\n\t\tvar ts, bs, ls, rs, l, r, t, b, i, first,\n\t\t\to = inst.options,\n\t\t\td = o.snapTolerance,\n\t\t\tx1 = ui.offset.left, x2 = x1 + inst.helperProportions.width,\n\t\t\ty1 = ui.offset.top, y2 = y1 + inst.helperProportions.height;\n\n\t\tfor ( i = inst.snapElements.length - 1; i >= 0; i-- ) {\n\n\t\t\tl = inst.snapElements[ i ].left - inst.margins.left;\n\t\t\tr = l + inst.snapElements[ i ].width;\n\t\t\tt = inst.snapElements[ i ].top - inst.margins.top;\n\t\t\tb = t + inst.snapElements[ i ].height;\n\n\t\t\tif ( x2 < l - d || x1 > r + d || y2 < t - d || y1 > b + d ||\n\t\t\t\t\t!$.contains( inst.snapElements[ i ].item.ownerDocument,\n\t\t\t\t\tinst.snapElements[ i ].item ) ) {\n\t\t\t\tif ( inst.snapElements[ i ].snapping ) {\n\t\t\t\t\tif ( inst.options.snap.release ) {\n\t\t\t\t\t\tinst.options.snap.release.call(\n\t\t\t\t\t\t\tinst.element,\n\t\t\t\t\t\t\tevent,\n\t\t\t\t\t\t\t$.extend( inst._uiHash(), { snapItem: inst.snapElements[ i ].item } )\n\t\t\t\t\t\t);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tinst.snapElements[ i ].snapping = false;\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tif ( o.snapMode !== \"inner\" ) {\n\t\t\t\tts = Math.abs( t - y2 ) <= d;\n\t\t\t\tbs = Math.abs( b - y1 ) <= d;\n\t\t\t\tls = Math.abs( l - x2 ) <= d;\n\t\t\t\trs = Math.abs( r - x1 ) <= d;\n\t\t\t\tif ( ts ) {\n\t\t\t\t\tui.position.top = inst._convertPositionTo( \"relative\", {\n\t\t\t\t\t\ttop: t - inst.helperProportions.height,\n\t\t\t\t\t\tleft: 0\n\t\t\t\t\t} ).top;\n\t\t\t\t}\n\t\t\t\tif ( bs ) {\n\t\t\t\t\tui.position.top = inst._convertPositionTo( \"relative\", {\n\t\t\t\t\t\ttop: b,\n\t\t\t\t\t\tleft: 0\n\t\t\t\t\t} ).top;\n\t\t\t\t}\n\t\t\t\tif ( ls ) {\n\t\t\t\t\tui.position.left = inst._convertPositionTo( \"relative\", {\n\t\t\t\t\t\ttop: 0,\n\t\t\t\t\t\tleft: l - inst.helperProportions.width\n\t\t\t\t\t} ).left;\n\t\t\t\t}\n\t\t\t\tif ( rs ) {\n\t\t\t\t\tui.position.left = inst._convertPositionTo( \"relative\", {\n\t\t\t\t\t\ttop: 0,\n\t\t\t\t\t\tleft: r\n\t\t\t\t\t} ).left;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfirst = ( ts || bs || ls || rs );\n\n\t\t\tif ( o.snapMode !== \"outer\" ) {\n\t\t\t\tts = Math.abs( t - y1 ) <= d;\n\t\t\t\tbs = Math.abs( b - y2 ) <= d;\n\t\t\t\tls = Math.abs( l - x1 ) <= d;\n\t\t\t\trs = Math.abs( r - x2 ) <= d;\n\t\t\t\tif ( ts ) {\n\t\t\t\t\tui.position.top = inst._convertPositionTo( \"relative\", {\n\t\t\t\t\t\ttop: t,\n\t\t\t\t\t\tleft: 0\n\t\t\t\t\t} ).top;\n\t\t\t\t}\n\t\t\t\tif ( bs ) {\n\t\t\t\t\tui.position.top = inst._convertPositionTo( \"relative\", {\n\t\t\t\t\t\ttop: b - inst.helperProportions.height,\n\t\t\t\t\t\tleft: 0\n\t\t\t\t\t} ).top;\n\t\t\t\t}\n\t\t\t\tif ( ls ) {\n\t\t\t\t\tui.position.left = inst._convertPositionTo( \"relative\", {\n\t\t\t\t\t\ttop: 0,\n\t\t\t\t\t\tleft: l\n\t\t\t\t\t} ).left;\n\t\t\t\t}\n\t\t\t\tif ( rs ) {\n\t\t\t\t\tui.position.left = inst._convertPositionTo( \"relative\", {\n\t\t\t\t\t\ttop: 0,\n\t\t\t\t\t\tleft: r - inst.helperProportions.width\n\t\t\t\t\t} ).left;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( !inst.snapElements[ i ].snapping && ( ts || bs || ls || rs || first ) ) {\n\t\t\t\tif ( inst.options.snap.snap ) {\n\t\t\t\t\tinst.options.snap.snap.call(\n\t\t\t\t\t\tinst.element,\n\t\t\t\t\t\tevent,\n\t\t\t\t\t\t$.extend( inst._uiHash(), {\n\t\t\t\t\t\t\tsnapItem: inst.snapElements[ i ].item\n\t\t\t\t\t\t} ) );\n\t\t\t\t}\n\t\t\t}\n\t\t\tinst.snapElements[ i ].snapping = ( ts || bs || ls || rs || first );\n\n\t\t}\n\n\t}\n} );\n\n$.ui.plugin.add( \"draggable\", \"stack\", {\n\tstart: function( event, ui, instance ) {\n\t\tvar min,\n\t\t\to = instance.options,\n\t\t\tgroup = $.makeArray( $( o.stack ) ).sort( function( a, b ) {\n\t\t\t\treturn ( parseInt( $( a ).css( \"zIndex\" ), 10 ) || 0 ) -\n\t\t\t\t\t( parseInt( $( b ).css( \"zIndex\" ), 10 ) || 0 );\n\t\t\t} );\n\n\t\tif ( !group.length ) {\n\t\t\treturn;\n\t\t}\n\n\t\tmin = parseInt( $( group[ 0 ] ).css( \"zIndex\" ), 10 ) || 0;\n\t\t$( group ).each( function( i ) {\n\t\t\t$( this ).css( \"zIndex\", min + i );\n\t\t} );\n\t\tthis.css( \"zIndex\", ( min + group.length ) );\n\t}\n} );\n\n$.ui.plugin.add( \"draggable\", \"zIndex\", {\n\tstart: function( event, ui, instance ) {\n\t\tvar t = $( ui.helper ),\n\t\t\to = instance.options;\n\n\t\tif ( t.css( \"zIndex\" ) ) {\n\t\t\to._zIndex = t.css( \"zIndex\" );\n\t\t}\n\t\tt.css( \"zIndex\", o.zIndex );\n\t},\n\tstop: function( event, ui, instance ) {\n\t\tvar o = instance.options;\n\n\t\tif ( o._zIndex ) {\n\t\t\t$( ui.helper ).css( \"zIndex\", o._zIndex );\n\t\t}\n\t}\n} );\n\nreturn $.ui.draggable;\n\n} );\n","jquery/ui-modules/widgets/spinner.js":"/*!\n * jQuery UI Spinner 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Spinner\n//>>group: Widgets\n//>>description: Displays buttons to easily input numbers via the keyboard or mouse.\n//>>docs: http://api.jqueryui.com/spinner/\n//>>demos: http://jqueryui.com/spinner/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/spinner.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./button\",\n\t\t\t\"../version\",\n\t\t\t\"../keycode\",\n\t\t\t\"../safe-active-element\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nfunction spinnerModifier( fn ) {\n\treturn function() {\n\t\tvar previous = this.element.val();\n\t\tfn.apply( this, arguments );\n\t\tthis._refresh();\n\t\tif ( previous !== this.element.val() ) {\n\t\t\tthis._trigger( \"change\" );\n\t\t}\n\t};\n}\n\n$.widget( \"ui.spinner\", {\n\tversion: \"1.13.1\",\n\tdefaultElement: \"<input>\",\n\twidgetEventPrefix: \"spin\",\n\toptions: {\n\t\tclasses: {\n\t\t\t\"ui-spinner\": \"ui-corner-all\",\n\t\t\t\"ui-spinner-down\": \"ui-corner-br\",\n\t\t\t\"ui-spinner-up\": \"ui-corner-tr\"\n\t\t},\n\t\tculture: null,\n\t\ticons: {\n\t\t\tdown: \"ui-icon-triangle-1-s\",\n\t\t\tup: \"ui-icon-triangle-1-n\"\n\t\t},\n\t\tincremental: true,\n\t\tmax: null,\n\t\tmin: null,\n\t\tnumberFormat: null,\n\t\tpage: 10,\n\t\tstep: 1,\n\n\t\tchange: null,\n\t\tspin: null,\n\t\tstart: null,\n\t\tstop: null\n\t},\n\n\t_create: function() {\n\n\t\t// handle string values that need to be parsed\n\t\tthis._setOption( \"max\", this.options.max );\n\t\tthis._setOption( \"min\", this.options.min );\n\t\tthis._setOption( \"step\", this.options.step );\n\n\t\t// Only format if there is a value, prevents the field from being marked\n\t\t// as invalid in Firefox, see #9573.\n\t\tif ( this.value() !== \"\" ) {\n\n\t\t\t// Format the value, but don't constrain.\n\t\t\tthis._value( this.element.val(), true );\n\t\t}\n\n\t\tthis._draw();\n\t\tthis._on( this._events );\n\t\tthis._refresh();\n\n\t\t// Turning off autocomplete prevents the browser from remembering the\n\t\t// value when navigating through history, so we re-enable autocomplete\n\t\t// if the page is unloaded before the widget is destroyed. #7790\n\t\tthis._on( this.window, {\n\t\t\tbeforeunload: function() {\n\t\t\t\tthis.element.removeAttr( \"autocomplete\" );\n\t\t\t}\n\t\t} );\n\t},\n\n\t_getCreateOptions: function() {\n\t\tvar options = this._super();\n\t\tvar element = this.element;\n\n\t\t$.each( [ \"min\", \"max\", \"step\" ], function( i, option ) {\n\t\t\tvar value = element.attr( option );\n\t\t\tif ( value != null && value.length ) {\n\t\t\t\toptions[ option ] = value;\n\t\t\t}\n\t\t} );\n\n\t\treturn options;\n\t},\n\n\t_events: {\n\t\tkeydown: function( event ) {\n\t\t\tif ( this._start( event ) && this._keydown( event ) ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t}\n\t\t},\n\t\tkeyup: \"_stop\",\n\t\tfocus: function() {\n\t\t\tthis.previous = this.element.val();\n\t\t},\n\t\tblur: function( event ) {\n\t\t\tif ( this.cancelBlur ) {\n\t\t\t\tdelete this.cancelBlur;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tthis._stop();\n\t\t\tthis._refresh();\n\t\t\tif ( this.previous !== this.element.val() ) {\n\t\t\t\tthis._trigger( \"change\", event );\n\t\t\t}\n\t\t},\n\t\tmousewheel: function( event, delta ) {\n\t\t\tvar activeElement = $.ui.safeActiveElement( this.document[ 0 ] );\n\t\t\tvar isActive = this.element[ 0 ] === activeElement;\n\n\t\t\tif ( !isActive || !delta ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( !this.spinning && !this._start( event ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tthis._spin( ( delta > 0 ? 1 : -1 ) * this.options.step, event );\n\t\t\tclearTimeout( this.mousewheelTimer );\n\t\t\tthis.mousewheelTimer = this._delay( function() {\n\t\t\t\tif ( this.spinning ) {\n\t\t\t\t\tthis._stop( event );\n\t\t\t\t}\n\t\t\t}, 100 );\n\t\t\tevent.preventDefault();\n\t\t},\n\t\t\"mousedown .ui-spinner-button\": function( event ) {\n\t\t\tvar previous;\n\n\t\t\t// We never want the buttons to have focus; whenever the user is\n\t\t\t// interacting with the spinner, the focus should be on the input.\n\t\t\t// If the input is focused then this.previous is properly set from\n\t\t\t// when the input first received focus. If the input is not focused\n\t\t\t// then we need to set this.previous based on the value before spinning.\n\t\t\tprevious = this.element[ 0 ] === $.ui.safeActiveElement( this.document[ 0 ] ) ?\n\t\t\t\tthis.previous : this.element.val();\n\t\t\tfunction checkFocus() {\n\t\t\t\tvar isActive = this.element[ 0 ] === $.ui.safeActiveElement( this.document[ 0 ] );\n\t\t\t\tif ( !isActive ) {\n\t\t\t\t\tthis.element.trigger( \"focus\" );\n\t\t\t\t\tthis.previous = previous;\n\n\t\t\t\t\t// support: IE\n\t\t\t\t\t// IE sets focus asynchronously, so we need to check if focus\n\t\t\t\t\t// moved off of the input because the user clicked on the button.\n\t\t\t\t\tthis._delay( function() {\n\t\t\t\t\t\tthis.previous = previous;\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Ensure focus is on (or stays on) the text field\n\t\t\tevent.preventDefault();\n\t\t\tcheckFocus.call( this );\n\n\t\t\t// Support: IE\n\t\t\t// IE doesn't prevent moving focus even with event.preventDefault()\n\t\t\t// so we set a flag to know when we should ignore the blur event\n\t\t\t// and check (again) if focus moved off of the input.\n\t\t\tthis.cancelBlur = true;\n\t\t\tthis._delay( function() {\n\t\t\t\tdelete this.cancelBlur;\n\t\t\t\tcheckFocus.call( this );\n\t\t\t} );\n\n\t\t\tif ( this._start( event ) === false ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tthis._repeat( null, $( event.currentTarget )\n\t\t\t\t.hasClass( \"ui-spinner-up\" ) ? 1 : -1, event );\n\t\t},\n\t\t\"mouseup .ui-spinner-button\": \"_stop\",\n\t\t\"mouseenter .ui-spinner-button\": function( event ) {\n\n\t\t\t// button will add ui-state-active if mouse was down while mouseleave and kept down\n\t\t\tif ( !$( event.currentTarget ).hasClass( \"ui-state-active\" ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( this._start( event ) === false ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tthis._repeat( null, $( event.currentTarget )\n\t\t\t\t.hasClass( \"ui-spinner-up\" ) ? 1 : -1, event );\n\t\t},\n\n\t\t// TODO: do we really want to consider this a stop?\n\t\t// shouldn't we just stop the repeater and wait until mouseup before\n\t\t// we trigger the stop event?\n\t\t\"mouseleave .ui-spinner-button\": \"_stop\"\n\t},\n\n\t// Support mobile enhanced option and make backcompat more sane\n\t_enhance: function() {\n\t\tthis.uiSpinner = this.element\n\t\t\t.attr( \"autocomplete\", \"off\" )\n\t\t\t.wrap( \"<span>\" )\n\t\t\t.parent()\n\n\t\t\t\t// Add buttons\n\t\t\t\t.append(\n\t\t\t\t\t\"<a></a><a></a>\"\n\t\t\t\t);\n\t},\n\n\t_draw: function() {\n\t\tthis._enhance();\n\n\t\tthis._addClass( this.uiSpinner, \"ui-spinner\", \"ui-widget ui-widget-content\" );\n\t\tthis._addClass( \"ui-spinner-input\" );\n\n\t\tthis.element.attr( \"role\", \"spinbutton\" );\n\n\t\t// Button bindings\n\t\tthis.buttons = this.uiSpinner.children( \"a\" )\n\t\t\t.attr( \"tabIndex\", -1 )\n\t\t\t.attr( \"aria-hidden\", true )\n\t\t\t.button( {\n\t\t\t\tclasses: {\n\t\t\t\t\t\"ui-button\": \"\"\n\t\t\t\t}\n\t\t\t} );\n\n\t\t// TODO: Right now button does not support classes this is already updated in button PR\n\t\tthis._removeClass( this.buttons, \"ui-corner-all\" );\n\n\t\tthis._addClass( this.buttons.first(), \"ui-spinner-button ui-spinner-up\" );\n\t\tthis._addClass( this.buttons.last(), \"ui-spinner-button ui-spinner-down\" );\n\t\tthis.buttons.first().button( {\n\t\t\t\"icon\": this.options.icons.up,\n\t\t\t\"showLabel\": false\n\t\t} );\n\t\tthis.buttons.last().button( {\n\t\t\t\"icon\": this.options.icons.down,\n\t\t\t\"showLabel\": false\n\t\t} );\n\n\t\t// IE 6 doesn't understand height: 50% for the buttons\n\t\t// unless the wrapper has an explicit height\n\t\tif ( this.buttons.height() > Math.ceil( this.uiSpinner.height() * 0.5 ) &&\n\t\t\t\tthis.uiSpinner.height() > 0 ) {\n\t\t\tthis.uiSpinner.height( this.uiSpinner.height() );\n\t\t}\n\t},\n\n\t_keydown: function( event ) {\n\t\tvar options = this.options,\n\t\t\tkeyCode = $.ui.keyCode;\n\n\t\tswitch ( event.keyCode ) {\n\t\tcase keyCode.UP:\n\t\t\tthis._repeat( null, 1, event );\n\t\t\treturn true;\n\t\tcase keyCode.DOWN:\n\t\t\tthis._repeat( null, -1, event );\n\t\t\treturn true;\n\t\tcase keyCode.PAGE_UP:\n\t\t\tthis._repeat( null, options.page, event );\n\t\t\treturn true;\n\t\tcase keyCode.PAGE_DOWN:\n\t\t\tthis._repeat( null, -options.page, event );\n\t\t\treturn true;\n\t\t}\n\n\t\treturn false;\n\t},\n\n\t_start: function( event ) {\n\t\tif ( !this.spinning && this._trigger( \"start\", event ) === false ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tif ( !this.counter ) {\n\t\t\tthis.counter = 1;\n\t\t}\n\t\tthis.spinning = true;\n\t\treturn true;\n\t},\n\n\t_repeat: function( i, steps, event ) {\n\t\ti = i || 500;\n\n\t\tclearTimeout( this.timer );\n\t\tthis.timer = this._delay( function() {\n\t\t\tthis._repeat( 40, steps, event );\n\t\t}, i );\n\n\t\tthis._spin( steps * this.options.step, event );\n\t},\n\n\t_spin: function( step, event ) {\n\t\tvar value = this.value() || 0;\n\n\t\tif ( !this.counter ) {\n\t\t\tthis.counter = 1;\n\t\t}\n\n\t\tvalue = this._adjustValue( value + step * this._increment( this.counter ) );\n\n\t\tif ( !this.spinning || this._trigger( \"spin\", event, { value: value } ) !== false ) {\n\t\t\tthis._value( value );\n\t\t\tthis.counter++;\n\t\t}\n\t},\n\n\t_increment: function( i ) {\n\t\tvar incremental = this.options.incremental;\n\n\t\tif ( incremental ) {\n\t\t\treturn typeof incremental === \"function\" ?\n\t\t\t\tincremental( i ) :\n\t\t\t\tMath.floor( i * i * i / 50000 - i * i / 500 + 17 * i / 200 + 1 );\n\t\t}\n\n\t\treturn 1;\n\t},\n\n\t_precision: function() {\n\t\tvar precision = this._precisionOf( this.options.step );\n\t\tif ( this.options.min !== null ) {\n\t\t\tprecision = Math.max( precision, this._precisionOf( this.options.min ) );\n\t\t}\n\t\treturn precision;\n\t},\n\n\t_precisionOf: function( num ) {\n\t\tvar str = num.toString(),\n\t\t\tdecimal = str.indexOf( \".\" );\n\t\treturn decimal === -1 ? 0 : str.length - decimal - 1;\n\t},\n\n\t_adjustValue: function( value ) {\n\t\tvar base, aboveMin,\n\t\t\toptions = this.options;\n\n\t\t// Make sure we're at a valid step\n\t\t// - find out where we are relative to the base (min or 0)\n\t\tbase = options.min !== null ? options.min : 0;\n\t\taboveMin = value - base;\n\n\t\t// - round to the nearest step\n\t\taboveMin = Math.round( aboveMin / options.step ) * options.step;\n\n\t\t// - rounding is based on 0, so adjust back to our base\n\t\tvalue = base + aboveMin;\n\n\t\t// Fix precision from bad JS floating point math\n\t\tvalue = parseFloat( value.toFixed( this._precision() ) );\n\n\t\t// Clamp the value\n\t\tif ( options.max !== null && value > options.max ) {\n\t\t\treturn options.max;\n\t\t}\n\t\tif ( options.min !== null && value < options.min ) {\n\t\t\treturn options.min;\n\t\t}\n\n\t\treturn value;\n\t},\n\n\t_stop: function( event ) {\n\t\tif ( !this.spinning ) {\n\t\t\treturn;\n\t\t}\n\n\t\tclearTimeout( this.timer );\n\t\tclearTimeout( this.mousewheelTimer );\n\t\tthis.counter = 0;\n\t\tthis.spinning = false;\n\t\tthis._trigger( \"stop\", event );\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tvar prevValue, first, last;\n\n\t\tif ( key === \"culture\" || key === \"numberFormat\" ) {\n\t\t\tprevValue = this._parse( this.element.val() );\n\t\t\tthis.options[ key ] = value;\n\t\t\tthis.element.val( this._format( prevValue ) );\n\t\t\treturn;\n\t\t}\n\n\t\tif ( key === \"max\" || key === \"min\" || key === \"step\" ) {\n\t\t\tif ( typeof value === \"string\" ) {\n\t\t\t\tvalue = this._parse( value );\n\t\t\t}\n\t\t}\n\t\tif ( key === \"icons\" ) {\n\t\t\tfirst = this.buttons.first().find( \".ui-icon\" );\n\t\t\tthis._removeClass( first, null, this.options.icons.up );\n\t\t\tthis._addClass( first, null, value.up );\n\t\t\tlast = this.buttons.last().find( \".ui-icon\" );\n\t\t\tthis._removeClass( last, null, this.options.icons.down );\n\t\t\tthis._addClass( last, null, value.down );\n\t\t}\n\n\t\tthis._super( key, value );\n\t},\n\n\t_setOptionDisabled: function( value ) {\n\t\tthis._super( value );\n\n\t\tthis._toggleClass( this.uiSpinner, null, \"ui-state-disabled\", !!value );\n\t\tthis.element.prop( \"disabled\", !!value );\n\t\tthis.buttons.button( value ? \"disable\" : \"enable\" );\n\t},\n\n\t_setOptions: spinnerModifier( function( options ) {\n\t\tthis._super( options );\n\t} ),\n\n\t_parse: function( val ) {\n\t\tif ( typeof val === \"string\" && val !== \"\" ) {\n\t\t\tval = window.Globalize && this.options.numberFormat ?\n\t\t\t\tGlobalize.parseFloat( val, 10, this.options.culture ) : +val;\n\t\t}\n\t\treturn val === \"\" || isNaN( val ) ? null : val;\n\t},\n\n\t_format: function( value ) {\n\t\tif ( value === \"\" ) {\n\t\t\treturn \"\";\n\t\t}\n\t\treturn window.Globalize && this.options.numberFormat ?\n\t\t\tGlobalize.format( value, this.options.numberFormat, this.options.culture ) :\n\t\t\tvalue;\n\t},\n\n\t_refresh: function() {\n\t\tthis.element.attr( {\n\t\t\t\"aria-valuemin\": this.options.min,\n\t\t\t\"aria-valuemax\": this.options.max,\n\n\t\t\t// TODO: what should we do with values that can't be parsed?\n\t\t\t\"aria-valuenow\": this._parse( this.element.val() )\n\t\t} );\n\t},\n\n\tisValid: function() {\n\t\tvar value = this.value();\n\n\t\t// Null is invalid\n\t\tif ( value === null ) {\n\t\t\treturn false;\n\t\t}\n\n\t\t// If value gets adjusted, it's invalid\n\t\treturn value === this._adjustValue( value );\n\t},\n\n\t// Update the value without triggering change\n\t_value: function( value, allowAny ) {\n\t\tvar parsed;\n\t\tif ( value !== \"\" ) {\n\t\t\tparsed = this._parse( value );\n\t\t\tif ( parsed !== null ) {\n\t\t\t\tif ( !allowAny ) {\n\t\t\t\t\tparsed = this._adjustValue( parsed );\n\t\t\t\t}\n\t\t\t\tvalue = this._format( parsed );\n\t\t\t}\n\t\t}\n\t\tthis.element.val( value );\n\t\tthis._refresh();\n\t},\n\n\t_destroy: function() {\n\t\tthis.element\n\t\t\t.prop( \"disabled\", false )\n\t\t\t.removeAttr( \"autocomplete role aria-valuemin aria-valuemax aria-valuenow\" );\n\n\t\tthis.uiSpinner.replaceWith( this.element );\n\t},\n\n\tstepUp: spinnerModifier( function( steps ) {\n\t\tthis._stepUp( steps );\n\t} ),\n\t_stepUp: function( steps ) {\n\t\tif ( this._start() ) {\n\t\t\tthis._spin( ( steps || 1 ) * this.options.step );\n\t\t\tthis._stop();\n\t\t}\n\t},\n\n\tstepDown: spinnerModifier( function( steps ) {\n\t\tthis._stepDown( steps );\n\t} ),\n\t_stepDown: function( steps ) {\n\t\tif ( this._start() ) {\n\t\t\tthis._spin( ( steps || 1 ) * -this.options.step );\n\t\t\tthis._stop();\n\t\t}\n\t},\n\n\tpageUp: spinnerModifier( function( pages ) {\n\t\tthis._stepUp( ( pages || 1 ) * this.options.page );\n\t} ),\n\n\tpageDown: spinnerModifier( function( pages ) {\n\t\tthis._stepDown( ( pages || 1 ) * this.options.page );\n\t} ),\n\n\tvalue: function( newVal ) {\n\t\tif ( !arguments.length ) {\n\t\t\treturn this._parse( this.element.val() );\n\t\t}\n\t\tspinnerModifier( this._value ).call( this, newVal );\n\t},\n\n\twidget: function() {\n\t\treturn this.uiSpinner;\n\t}\n} );\n\n// DEPRECATED\n// TODO: switch return back to widget declaration at top of file when this is removed\nif ( $.uiBackCompat !== false ) {\n\n\t// Backcompat for spinner html extension points\n\t$.widget( \"ui.spinner\", $.ui.spinner, {\n\t\t_enhance: function() {\n\t\t\tthis.uiSpinner = this.element\n\t\t\t\t.attr( \"autocomplete\", \"off\" )\n\t\t\t\t.wrap( this._uiSpinnerHtml() )\n\t\t\t\t.parent()\n\n\t\t\t\t\t// Add buttons\n\t\t\t\t\t.append( this._buttonHtml() );\n\t\t},\n\t\t_uiSpinnerHtml: function() {\n\t\t\treturn \"<span>\";\n\t\t},\n\n\t\t_buttonHtml: function() {\n\t\t\treturn \"<a></a><a></a>\";\n\t\t}\n\t} );\n}\n\nreturn $.ui.spinner;\n\n} );\n","jquery/ui-modules/widgets/accordion.js":"/*!\n * jQuery UI Accordion 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Accordion\n//>>group: Widgets\n/* eslint-disable max-len */\n//>>description: Displays collapsible content panels for presenting information in a limited amount of space.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/accordion/\n//>>demos: http://jqueryui.com/accordion/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/accordion.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../keycode\",\n\t\t\t\"../unique-id\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.widget( \"ui.accordion\", {\n\tversion: \"1.13.1\",\n\toptions: {\n\t\tactive: 0,\n\t\tanimate: {},\n\t\tclasses: {\n\t\t\t\"ui-accordion-header\": \"ui-corner-top\",\n\t\t\t\"ui-accordion-header-collapsed\": \"ui-corner-all\",\n\t\t\t\"ui-accordion-content\": \"ui-corner-bottom\"\n\t\t},\n\t\tcollapsible: false,\n\t\tevent: \"click\",\n\t\theader: function( elem ) {\n\t\t\treturn elem.find( \"> li > :first-child\" ).add( elem.find( \"> :not(li)\" ).even() );\n\t\t},\n\t\theightStyle: \"auto\",\n\t\ticons: {\n\t\t\tactiveHeader: \"ui-icon-triangle-1-s\",\n\t\t\theader: \"ui-icon-triangle-1-e\"\n\t\t},\n\n\t\t// Callbacks\n\t\tactivate: null,\n\t\tbeforeActivate: null\n\t},\n\n\thideProps: {\n\t\tborderTopWidth: \"hide\",\n\t\tborderBottomWidth: \"hide\",\n\t\tpaddingTop: \"hide\",\n\t\tpaddingBottom: \"hide\",\n\t\theight: \"hide\"\n\t},\n\n\tshowProps: {\n\t\tborderTopWidth: \"show\",\n\t\tborderBottomWidth: \"show\",\n\t\tpaddingTop: \"show\",\n\t\tpaddingBottom: \"show\",\n\t\theight: \"show\"\n\t},\n\n\t_create: function() {\n\t\tvar options = this.options;\n\n\t\tthis.prevShow = this.prevHide = $();\n\t\tthis._addClass( \"ui-accordion\", \"ui-widget ui-helper-reset\" );\n\t\tthis.element.attr( \"role\", \"tablist\" );\n\n\t\t// Don't allow collapsible: false and active: false / null\n\t\tif ( !options.collapsible && ( options.active === false || options.active == null ) ) {\n\t\t\toptions.active = 0;\n\t\t}\n\n\t\tthis._processPanels();\n\n\t\t// handle negative values\n\t\tif ( options.active < 0 ) {\n\t\t\toptions.active += this.headers.length;\n\t\t}\n\t\tthis._refresh();\n\t},\n\n\t_getCreateEventData: function() {\n\t\treturn {\n\t\t\theader: this.active,\n\t\t\tpanel: !this.active.length ? $() : this.active.next()\n\t\t};\n\t},\n\n\t_createIcons: function() {\n\t\tvar icon, children,\n\t\t\ticons = this.options.icons;\n\n\t\tif ( icons ) {\n\t\t\ticon = $( \"<span>\" );\n\t\t\tthis._addClass( icon, \"ui-accordion-header-icon\", \"ui-icon \" + icons.header );\n\t\t\ticon.prependTo( this.headers );\n\t\t\tchildren = this.active.children( \".ui-accordion-header-icon\" );\n\t\t\tthis._removeClass( children, icons.header )\n\t\t\t\t._addClass( children, null, icons.activeHeader )\n\t\t\t\t._addClass( this.headers, \"ui-accordion-icons\" );\n\t\t}\n\t},\n\n\t_destroyIcons: function() {\n\t\tthis._removeClass( this.headers, \"ui-accordion-icons\" );\n\t\tthis.headers.children( \".ui-accordion-header-icon\" ).remove();\n\t},\n\n\t_destroy: function() {\n\t\tvar contents;\n\n\t\t// Clean up main element\n\t\tthis.element.removeAttr( \"role\" );\n\n\t\t// Clean up headers\n\t\tthis.headers\n\t\t\t.removeAttr( \"role aria-expanded aria-selected aria-controls tabIndex\" )\n\t\t\t.removeUniqueId();\n\n\t\tthis._destroyIcons();\n\n\t\t// Clean up content panels\n\t\tcontents = this.headers.next()\n\t\t\t.css( \"display\", \"\" )\n\t\t\t.removeAttr( \"role aria-hidden aria-labelledby\" )\n\t\t\t.removeUniqueId();\n\n\t\tif ( this.options.heightStyle !== \"content\" ) {\n\t\t\tcontents.css( \"height\", \"\" );\n\t\t}\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"active\" ) {\n\n\t\t\t// _activate() will handle invalid values and update this.options\n\t\t\tthis._activate( value );\n\t\t\treturn;\n\t\t}\n\n\t\tif ( key === \"event\" ) {\n\t\t\tif ( this.options.event ) {\n\t\t\t\tthis._off( this.headers, this.options.event );\n\t\t\t}\n\t\t\tthis._setupEvents( value );\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\t// Setting collapsible: false while collapsed; open first panel\n\t\tif ( key === \"collapsible\" && !value && this.options.active === false ) {\n\t\t\tthis._activate( 0 );\n\t\t}\n\n\t\tif ( key === \"icons\" ) {\n\t\t\tthis._destroyIcons();\n\t\t\tif ( value ) {\n\t\t\t\tthis._createIcons();\n\t\t\t}\n\t\t}\n\t},\n\n\t_setOptionDisabled: function( value ) {\n\t\tthis._super( value );\n\n\t\tthis.element.attr( \"aria-disabled\", value );\n\n\t\t// Support: IE8 Only\n\t\t// #5332 / #6059 - opacity doesn't cascade to positioned elements in IE\n\t\t// so we need to add the disabled class to the headers and panels\n\t\tthis._toggleClass( null, \"ui-state-disabled\", !!value );\n\t\tthis._toggleClass( this.headers.add( this.headers.next() ), null, \"ui-state-disabled\",\n\t\t\t!!value );\n\t},\n\n\t_keydown: function( event ) {\n\t\tif ( event.altKey || event.ctrlKey ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar keyCode = $.ui.keyCode,\n\t\t\tlength = this.headers.length,\n\t\t\tcurrentIndex = this.headers.index( event.target ),\n\t\t\ttoFocus = false;\n\n\t\tswitch ( event.keyCode ) {\n\t\tcase keyCode.RIGHT:\n\t\tcase keyCode.DOWN:\n\t\t\ttoFocus = this.headers[ ( currentIndex + 1 ) % length ];\n\t\t\tbreak;\n\t\tcase keyCode.LEFT:\n\t\tcase keyCode.UP:\n\t\t\ttoFocus = this.headers[ ( currentIndex - 1 + length ) % length ];\n\t\t\tbreak;\n\t\tcase keyCode.SPACE:\n\t\tcase keyCode.ENTER:\n\t\t\tthis._eventHandler( event );\n\t\t\tbreak;\n\t\tcase keyCode.HOME:\n\t\t\ttoFocus = this.headers[ 0 ];\n\t\t\tbreak;\n\t\tcase keyCode.END:\n\t\t\ttoFocus = this.headers[ length - 1 ];\n\t\t\tbreak;\n\t\t}\n\n\t\tif ( toFocus ) {\n\t\t\t$( event.target ).attr( \"tabIndex\", -1 );\n\t\t\t$( toFocus ).attr( \"tabIndex\", 0 );\n\t\t\t$( toFocus ).trigger( \"focus\" );\n\t\t\tevent.preventDefault();\n\t\t}\n\t},\n\n\t_panelKeyDown: function( event ) {\n\t\tif ( event.keyCode === $.ui.keyCode.UP && event.ctrlKey ) {\n\t\t\t$( event.currentTarget ).prev().trigger( \"focus\" );\n\t\t}\n\t},\n\n\trefresh: function() {\n\t\tvar options = this.options;\n\t\tthis._processPanels();\n\n\t\t// Was collapsed or no panel\n\t\tif ( ( options.active === false && options.collapsible === true ) ||\n\t\t\t\t!this.headers.length ) {\n\t\t\toptions.active = false;\n\t\t\tthis.active = $();\n\n\t\t// active false only when collapsible is true\n\t\t} else if ( options.active === false ) {\n\t\t\tthis._activate( 0 );\n\n\t\t// was active, but active panel is gone\n\t\t} else if ( this.active.length && !$.contains( this.element[ 0 ], this.active[ 0 ] ) ) {\n\n\t\t\t// all remaining panel are disabled\n\t\t\tif ( this.headers.length === this.headers.find( \".ui-state-disabled\" ).length ) {\n\t\t\t\toptions.active = false;\n\t\t\t\tthis.active = $();\n\n\t\t\t// activate previous panel\n\t\t\t} else {\n\t\t\t\tthis._activate( Math.max( 0, options.active - 1 ) );\n\t\t\t}\n\n\t\t// was active, active panel still exists\n\t\t} else {\n\n\t\t\t// make sure active index is correct\n\t\t\toptions.active = this.headers.index( this.active );\n\t\t}\n\n\t\tthis._destroyIcons();\n\n\t\tthis._refresh();\n\t},\n\n\t_processPanels: function() {\n\t\tvar prevHeaders = this.headers,\n\t\t\tprevPanels = this.panels;\n\n\t\tif ( typeof this.options.header === \"function\" ) {\n\t\t\tthis.headers = this.options.header( this.element );\n\t\t} else {\n\t\t\tthis.headers = this.element.find( this.options.header );\n\t\t}\n\t\tthis._addClass( this.headers, \"ui-accordion-header ui-accordion-header-collapsed\",\n\t\t\t\"ui-state-default\" );\n\n\t\tthis.panels = this.headers.next().filter( \":not(.ui-accordion-content-active)\" ).hide();\n\t\tthis._addClass( this.panels, \"ui-accordion-content\", \"ui-helper-reset ui-widget-content\" );\n\n\t\t// Avoid memory leaks (#10056)\n\t\tif ( prevPanels ) {\n\t\t\tthis._off( prevHeaders.not( this.headers ) );\n\t\t\tthis._off( prevPanels.not( this.panels ) );\n\t\t}\n\t},\n\n\t_refresh: function() {\n\t\tvar maxHeight,\n\t\t\toptions = this.options,\n\t\t\theightStyle = options.heightStyle,\n\t\t\tparent = this.element.parent();\n\n\t\tthis.active = this._findActive( options.active );\n\t\tthis._addClass( this.active, \"ui-accordion-header-active\", \"ui-state-active\" )\n\t\t\t._removeClass( this.active, \"ui-accordion-header-collapsed\" );\n\t\tthis._addClass( this.active.next(), \"ui-accordion-content-active\" );\n\t\tthis.active.next().show();\n\n\t\tthis.headers\n\t\t\t.attr( \"role\", \"tab\" )\n\t\t\t.each( function() {\n\t\t\t\tvar header = $( this ),\n\t\t\t\t\theaderId = header.uniqueId().attr( \"id\" ),\n\t\t\t\t\tpanel = header.next(),\n\t\t\t\t\tpanelId = panel.uniqueId().attr( \"id\" );\n\t\t\t\theader.attr( \"aria-controls\", panelId );\n\t\t\t\tpanel.attr( \"aria-labelledby\", headerId );\n\t\t\t} )\n\t\t\t.next()\n\t\t\t\t.attr( \"role\", \"tabpanel\" );\n\n\t\tthis.headers\n\t\t\t.not( this.active )\n\t\t\t\t.attr( {\n\t\t\t\t\t\"aria-selected\": \"false\",\n\t\t\t\t\t\"aria-expanded\": \"false\",\n\t\t\t\t\ttabIndex: -1\n\t\t\t\t} )\n\t\t\t\t.next()\n\t\t\t\t\t.attr( {\n\t\t\t\t\t\t\"aria-hidden\": \"true\"\n\t\t\t\t\t} )\n\t\t\t\t\t.hide();\n\n\t\t// Make sure at least one header is in the tab order\n\t\tif ( !this.active.length ) {\n\t\t\tthis.headers.eq( 0 ).attr( \"tabIndex\", 0 );\n\t\t} else {\n\t\t\tthis.active.attr( {\n\t\t\t\t\"aria-selected\": \"true\",\n\t\t\t\t\"aria-expanded\": \"true\",\n\t\t\t\ttabIndex: 0\n\t\t\t} )\n\t\t\t\t.next()\n\t\t\t\t\t.attr( {\n\t\t\t\t\t\t\"aria-hidden\": \"false\"\n\t\t\t\t\t} );\n\t\t}\n\n\t\tthis._createIcons();\n\n\t\tthis._setupEvents( options.event );\n\n\t\tif ( heightStyle === \"fill\" ) {\n\t\t\tmaxHeight = parent.height();\n\t\t\tthis.element.siblings( \":visible\" ).each( function() {\n\t\t\t\tvar elem = $( this ),\n\t\t\t\t\tposition = elem.css( \"position\" );\n\n\t\t\t\tif ( position === \"absolute\" || position === \"fixed\" ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tmaxHeight -= elem.outerHeight( true );\n\t\t\t} );\n\n\t\t\tthis.headers.each( function() {\n\t\t\t\tmaxHeight -= $( this ).outerHeight( true );\n\t\t\t} );\n\n\t\t\tthis.headers.next()\n\t\t\t\t.each( function() {\n\t\t\t\t\t$( this ).height( Math.max( 0, maxHeight -\n\t\t\t\t\t\t$( this ).innerHeight() + $( this ).height() ) );\n\t\t\t\t} )\n\t\t\t\t.css( \"overflow\", \"auto\" );\n\t\t} else if ( heightStyle === \"auto\" ) {\n\t\t\tmaxHeight = 0;\n\t\t\tthis.headers.next()\n\t\t\t\t.each( function() {\n\t\t\t\t\tvar isVisible = $( this ).is( \":visible\" );\n\t\t\t\t\tif ( !isVisible ) {\n\t\t\t\t\t\t$( this ).show();\n\t\t\t\t\t}\n\t\t\t\t\tmaxHeight = Math.max( maxHeight, $( this ).css( \"height\", \"\" ).height() );\n\t\t\t\t\tif ( !isVisible ) {\n\t\t\t\t\t\t$( this ).hide();\n\t\t\t\t\t}\n\t\t\t\t} )\n\t\t\t\t.height( maxHeight );\n\t\t}\n\t},\n\n\t_activate: function( index ) {\n\t\tvar active = this._findActive( index )[ 0 ];\n\n\t\t// Trying to activate the already active panel\n\t\tif ( active === this.active[ 0 ] ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Trying to collapse, simulate a click on the currently active header\n\t\tactive = active || this.active[ 0 ];\n\n\t\tthis._eventHandler( {\n\t\t\ttarget: active,\n\t\t\tcurrentTarget: active,\n\t\t\tpreventDefault: $.noop\n\t\t} );\n\t},\n\n\t_findActive: function( selector ) {\n\t\treturn typeof selector === \"number\" ? this.headers.eq( selector ) : $();\n\t},\n\n\t_setupEvents: function( event ) {\n\t\tvar events = {\n\t\t\tkeydown: \"_keydown\"\n\t\t};\n\t\tif ( event ) {\n\t\t\t$.each( event.split( \" \" ), function( index, eventName ) {\n\t\t\t\tevents[ eventName ] = \"_eventHandler\";\n\t\t\t} );\n\t\t}\n\n\t\tthis._off( this.headers.add( this.headers.next() ) );\n\t\tthis._on( this.headers, events );\n\t\tthis._on( this.headers.next(), { keydown: \"_panelKeyDown\" } );\n\t\tthis._hoverable( this.headers );\n\t\tthis._focusable( this.headers );\n\t},\n\n\t_eventHandler: function( event ) {\n\t\tvar activeChildren, clickedChildren,\n\t\t\toptions = this.options,\n\t\t\tactive = this.active,\n\t\t\tclicked = $( event.currentTarget ),\n\t\t\tclickedIsActive = clicked[ 0 ] === active[ 0 ],\n\t\t\tcollapsing = clickedIsActive && options.collapsible,\n\t\t\ttoShow = collapsing ? $() : clicked.next(),\n\t\t\ttoHide = active.next(),\n\t\t\teventData = {\n\t\t\t\toldHeader: active,\n\t\t\t\toldPanel: toHide,\n\t\t\t\tnewHeader: collapsing ? $() : clicked,\n\t\t\t\tnewPanel: toShow\n\t\t\t};\n\n\t\tevent.preventDefault();\n\n\t\tif (\n\n\t\t\t\t// click on active header, but not collapsible\n\t\t\t\t( clickedIsActive && !options.collapsible ) ||\n\n\t\t\t\t// allow canceling activation\n\t\t\t\t( this._trigger( \"beforeActivate\", event, eventData ) === false ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\toptions.active = collapsing ? false : this.headers.index( clicked );\n\n\t\t// When the call to ._toggle() comes after the class changes\n\t\t// it causes a very odd bug in IE 8 (see #6720)\n\t\tthis.active = clickedIsActive ? $() : clicked;\n\t\tthis._toggle( eventData );\n\n\t\t// Switch classes\n\t\t// corner classes on the previously active header stay after the animation\n\t\tthis._removeClass( active, \"ui-accordion-header-active\", \"ui-state-active\" );\n\t\tif ( options.icons ) {\n\t\t\tactiveChildren = active.children( \".ui-accordion-header-icon\" );\n\t\t\tthis._removeClass( activeChildren, null, options.icons.activeHeader )\n\t\t\t\t._addClass( activeChildren, null, options.icons.header );\n\t\t}\n\n\t\tif ( !clickedIsActive ) {\n\t\t\tthis._removeClass( clicked, \"ui-accordion-header-collapsed\" )\n\t\t\t\t._addClass( clicked, \"ui-accordion-header-active\", \"ui-state-active\" );\n\t\t\tif ( options.icons ) {\n\t\t\t\tclickedChildren = clicked.children( \".ui-accordion-header-icon\" );\n\t\t\t\tthis._removeClass( clickedChildren, null, options.icons.header )\n\t\t\t\t\t._addClass( clickedChildren, null, options.icons.activeHeader );\n\t\t\t}\n\n\t\t\tthis._addClass( clicked.next(), \"ui-accordion-content-active\" );\n\t\t}\n\t},\n\n\t_toggle: function( data ) {\n\t\tvar toShow = data.newPanel,\n\t\t\ttoHide = this.prevShow.length ? this.prevShow : data.oldPanel;\n\n\t\t// Handle activating a panel during the animation for another activation\n\t\tthis.prevShow.add( this.prevHide ).stop( true, true );\n\t\tthis.prevShow = toShow;\n\t\tthis.prevHide = toHide;\n\n\t\tif ( this.options.animate ) {\n\t\t\tthis._animate( toShow, toHide, data );\n\t\t} else {\n\t\t\ttoHide.hide();\n\t\t\ttoShow.show();\n\t\t\tthis._toggleComplete( data );\n\t\t}\n\n\t\ttoHide.attr( {\n\t\t\t\"aria-hidden\": \"true\"\n\t\t} );\n\t\ttoHide.prev().attr( {\n\t\t\t\"aria-selected\": \"false\",\n\t\t\t\"aria-expanded\": \"false\"\n\t\t} );\n\n\t\t// if we're switching panels, remove the old header from the tab order\n\t\t// if we're opening from collapsed state, remove the previous header from the tab order\n\t\t// if we're collapsing, then keep the collapsing header in the tab order\n\t\tif ( toShow.length && toHide.length ) {\n\t\t\ttoHide.prev().attr( {\n\t\t\t\t\"tabIndex\": -1,\n\t\t\t\t\"aria-expanded\": \"false\"\n\t\t\t} );\n\t\t} else if ( toShow.length ) {\n\t\t\tthis.headers.filter( function() {\n\t\t\t\treturn parseInt( $( this ).attr( \"tabIndex\" ), 10 ) === 0;\n\t\t\t} )\n\t\t\t\t.attr( \"tabIndex\", -1 );\n\t\t}\n\n\t\ttoShow\n\t\t\t.attr( \"aria-hidden\", \"false\" )\n\t\t\t.prev()\n\t\t\t\t.attr( {\n\t\t\t\t\t\"aria-selected\": \"true\",\n\t\t\t\t\t\"aria-expanded\": \"true\",\n\t\t\t\t\ttabIndex: 0\n\t\t\t\t} );\n\t},\n\n\t_animate: function( toShow, toHide, data ) {\n\t\tvar total, easing, duration,\n\t\t\tthat = this,\n\t\t\tadjust = 0,\n\t\t\tboxSizing = toShow.css( \"box-sizing\" ),\n\t\t\tdown = toShow.length &&\n\t\t\t\t( !toHide.length || ( toShow.index() < toHide.index() ) ),\n\t\t\tanimate = this.options.animate || {},\n\t\t\toptions = down && animate.down || animate,\n\t\t\tcomplete = function() {\n\t\t\t\tthat._toggleComplete( data );\n\t\t\t};\n\n\t\tif ( typeof options === \"number\" ) {\n\t\t\tduration = options;\n\t\t}\n\t\tif ( typeof options === \"string\" ) {\n\t\t\teasing = options;\n\t\t}\n\n\t\t// fall back from options to animation in case of partial down settings\n\t\teasing = easing || options.easing || animate.easing;\n\t\tduration = duration || options.duration || animate.duration;\n\n\t\tif ( !toHide.length ) {\n\t\t\treturn toShow.animate( this.showProps, duration, easing, complete );\n\t\t}\n\t\tif ( !toShow.length ) {\n\t\t\treturn toHide.animate( this.hideProps, duration, easing, complete );\n\t\t}\n\n\t\ttotal = toShow.show().outerHeight();\n\t\ttoHide.animate( this.hideProps, {\n\t\t\tduration: duration,\n\t\t\teasing: easing,\n\t\t\tstep: function( now, fx ) {\n\t\t\t\tfx.now = Math.round( now );\n\t\t\t}\n\t\t} );\n\t\ttoShow\n\t\t\t.hide()\n\t\t\t.animate( this.showProps, {\n\t\t\t\tduration: duration,\n\t\t\t\teasing: easing,\n\t\t\t\tcomplete: complete,\n\t\t\t\tstep: function( now, fx ) {\n\t\t\t\t\tfx.now = Math.round( now );\n\t\t\t\t\tif ( fx.prop !== \"height\" ) {\n\t\t\t\t\t\tif ( boxSizing === \"content-box\" ) {\n\t\t\t\t\t\t\tadjust += fx.now;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if ( that.options.heightStyle !== \"content\" ) {\n\t\t\t\t\t\tfx.now = Math.round( total - toHide.outerHeight() - adjust );\n\t\t\t\t\t\tadjust = 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} );\n\t},\n\n\t_toggleComplete: function( data ) {\n\t\tvar toHide = data.oldPanel,\n\t\t\tprev = toHide.prev();\n\n\t\tthis._removeClass( toHide, \"ui-accordion-content-active\" );\n\t\tthis._removeClass( prev, \"ui-accordion-header-active\" )\n\t\t\t._addClass( prev, \"ui-accordion-header-collapsed\" );\n\n\t\t// Work around for rendering bug in IE (#5421)\n\t\tif ( toHide.length ) {\n\t\t\ttoHide.parent()[ 0 ].className = toHide.parent()[ 0 ].className;\n\t\t}\n\t\tthis._trigger( \"activate\", null, data );\n\t}\n} );\n\n} );\n","jquery/ui-modules/widgets/tooltip.js":"/*!\n * jQuery UI Tooltip 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Tooltip\n//>>group: Widgets\n//>>description: Shows additional information for any element on hover or focus.\n//>>docs: http://api.jqueryui.com/tooltip/\n//>>demos: http://jqueryui.com/tooltip/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/tooltip.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../keycode\",\n\t\t\t\"../position\",\n\t\t\t\"../unique-id\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.tooltip\", {\n\tversion: \"1.13.1\",\n\toptions: {\n\t\tclasses: {\n\t\t\t\"ui-tooltip\": \"ui-corner-all ui-widget-shadow\"\n\t\t},\n\t\tcontent: function() {\n\t\t\tvar title = $( this ).attr( \"title\" );\n\n\t\t\t// Escape title, since we're going from an attribute to raw HTML\n\t\t\treturn $( \"<a>\" ).text( title ).html();\n\t\t},\n\t\thide: true,\n\n\t\t// Disabled elements have inconsistent behavior across browsers (#8661)\n\t\titems: \"[title]:not([disabled])\",\n\t\tposition: {\n\t\t\tmy: \"left top+15\",\n\t\t\tat: \"left bottom\",\n\t\t\tcollision: \"flipfit flip\"\n\t\t},\n\t\tshow: true,\n\t\ttrack: false,\n\n\t\t// Callbacks\n\t\tclose: null,\n\t\topen: null\n\t},\n\n\t_addDescribedBy: function( elem, id ) {\n\t\tvar describedby = ( elem.attr( \"aria-describedby\" ) || \"\" ).split( /\\s+/ );\n\t\tdescribedby.push( id );\n\t\telem\n\t\t\t.data( \"ui-tooltip-id\", id )\n\t\t\t.attr( \"aria-describedby\", String.prototype.trim.call( describedby.join( \" \" ) ) );\n\t},\n\n\t_removeDescribedBy: function( elem ) {\n\t\tvar id = elem.data( \"ui-tooltip-id\" ),\n\t\t\tdescribedby = ( elem.attr( \"aria-describedby\" ) || \"\" ).split( /\\s+/ ),\n\t\t\tindex = $.inArray( id, describedby );\n\n\t\tif ( index !== -1 ) {\n\t\t\tdescribedby.splice( index, 1 );\n\t\t}\n\n\t\telem.removeData( \"ui-tooltip-id\" );\n\t\tdescribedby = String.prototype.trim.call( describedby.join( \" \" ) );\n\t\tif ( describedby ) {\n\t\t\telem.attr( \"aria-describedby\", describedby );\n\t\t} else {\n\t\t\telem.removeAttr( \"aria-describedby\" );\n\t\t}\n\t},\n\n\t_create: function() {\n\t\tthis._on( {\n\t\t\tmouseover: \"open\",\n\t\t\tfocusin: \"open\"\n\t\t} );\n\n\t\t// IDs of generated tooltips, needed for destroy\n\t\tthis.tooltips = {};\n\n\t\t// IDs of parent tooltips where we removed the title attribute\n\t\tthis.parents = {};\n\n\t\t// Append the aria-live region so tooltips announce correctly\n\t\tthis.liveRegion = $( \"<div>\" )\n\t\t\t.attr( {\n\t\t\t\trole: \"log\",\n\t\t\t\t\"aria-live\": \"assertive\",\n\t\t\t\t\"aria-relevant\": \"additions\"\n\t\t\t} )\n\t\t\t.appendTo( this.document[ 0 ].body );\n\t\tthis._addClass( this.liveRegion, null, \"ui-helper-hidden-accessible\" );\n\n\t\tthis.disabledTitles = $( [] );\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tvar that = this;\n\n\t\tthis._super( key, value );\n\n\t\tif ( key === \"content\" ) {\n\t\t\t$.each( this.tooltips, function( id, tooltipData ) {\n\t\t\t\tthat._updateContent( tooltipData.element );\n\t\t\t} );\n\t\t}\n\t},\n\n\t_setOptionDisabled: function( value ) {\n\t\tthis[ value ? \"_disable\" : \"_enable\" ]();\n\t},\n\n\t_disable: function() {\n\t\tvar that = this;\n\n\t\t// Close open tooltips\n\t\t$.each( this.tooltips, function( id, tooltipData ) {\n\t\t\tvar event = $.Event( \"blur\" );\n\t\t\tevent.target = event.currentTarget = tooltipData.element[ 0 ];\n\t\t\tthat.close( event, true );\n\t\t} );\n\n\t\t// Remove title attributes to prevent native tooltips\n\t\tthis.disabledTitles = this.disabledTitles.add(\n\t\t\tthis.element.find( this.options.items ).addBack()\n\t\t\t\t.filter( function() {\n\t\t\t\t\tvar element = $( this );\n\t\t\t\t\tif ( element.is( \"[title]\" ) ) {\n\t\t\t\t\t\treturn element\n\t\t\t\t\t\t\t.data( \"ui-tooltip-title\", element.attr( \"title\" ) )\n\t\t\t\t\t\t\t.removeAttr( \"title\" );\n\t\t\t\t\t}\n\t\t\t\t} )\n\t\t);\n\t},\n\n\t_enable: function() {\n\n\t\t// restore title attributes\n\t\tthis.disabledTitles.each( function() {\n\t\t\tvar element = $( this );\n\t\t\tif ( element.data( \"ui-tooltip-title\" ) ) {\n\t\t\t\telement.attr( \"title\", element.data( \"ui-tooltip-title\" ) );\n\t\t\t}\n\t\t} );\n\t\tthis.disabledTitles = $( [] );\n\t},\n\n\topen: function( event ) {\n\t\tvar that = this,\n\t\t\ttarget = $( event ? event.target : this.element )\n\n\t\t\t\t// we need closest here due to mouseover bubbling,\n\t\t\t\t// but always pointing at the same event target\n\t\t\t\t.closest( this.options.items );\n\n\t\t// No element to show a tooltip for or the tooltip is already open\n\t\tif ( !target.length || target.data( \"ui-tooltip-id\" ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( target.attr( \"title\" ) ) {\n\t\t\ttarget.data( \"ui-tooltip-title\", target.attr( \"title\" ) );\n\t\t}\n\n\t\ttarget.data( \"ui-tooltip-open\", true );\n\n\t\t// Kill parent tooltips, custom or native, for hover\n\t\tif ( event && event.type === \"mouseover\" ) {\n\t\t\ttarget.parents().each( function() {\n\t\t\t\tvar parent = $( this ),\n\t\t\t\t\tblurEvent;\n\t\t\t\tif ( parent.data( \"ui-tooltip-open\" ) ) {\n\t\t\t\t\tblurEvent = $.Event( \"blur\" );\n\t\t\t\t\tblurEvent.target = blurEvent.currentTarget = this;\n\t\t\t\t\tthat.close( blurEvent, true );\n\t\t\t\t}\n\t\t\t\tif ( parent.attr( \"title\" ) ) {\n\t\t\t\t\tparent.uniqueId();\n\t\t\t\t\tthat.parents[ this.id ] = {\n\t\t\t\t\t\telement: this,\n\t\t\t\t\t\ttitle: parent.attr( \"title\" )\n\t\t\t\t\t};\n\t\t\t\t\tparent.attr( \"title\", \"\" );\n\t\t\t\t}\n\t\t\t} );\n\t\t}\n\n\t\tthis._registerCloseHandlers( event, target );\n\t\tthis._updateContent( target, event );\n\t},\n\n\t_updateContent: function( target, event ) {\n\t\tvar content,\n\t\t\tcontentOption = this.options.content,\n\t\t\tthat = this,\n\t\t\teventType = event ? event.type : null;\n\n\t\tif ( typeof contentOption === \"string\" || contentOption.nodeType ||\n\t\t\t\tcontentOption.jquery ) {\n\t\t\treturn this._open( event, target, contentOption );\n\t\t}\n\n\t\tcontent = contentOption.call( target[ 0 ], function( response ) {\n\n\t\t\t// IE may instantly serve a cached response for ajax requests\n\t\t\t// delay this call to _open so the other call to _open runs first\n\t\t\tthat._delay( function() {\n\n\t\t\t\t// Ignore async response if tooltip was closed already\n\t\t\t\tif ( !target.data( \"ui-tooltip-open\" ) ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// JQuery creates a special event for focusin when it doesn't\n\t\t\t\t// exist natively. To improve performance, the native event\n\t\t\t\t// object is reused and the type is changed. Therefore, we can't\n\t\t\t\t// rely on the type being correct after the event finished\n\t\t\t\t// bubbling, so we set it back to the previous value. (#8740)\n\t\t\t\tif ( event ) {\n\t\t\t\t\tevent.type = eventType;\n\t\t\t\t}\n\t\t\t\tthis._open( event, target, response );\n\t\t\t} );\n\t\t} );\n\t\tif ( content ) {\n\t\t\tthis._open( event, target, content );\n\t\t}\n\t},\n\n\t_open: function( event, target, content ) {\n\t\tvar tooltipData, tooltip, delayedShow, a11yContent,\n\t\t\tpositionOption = $.extend( {}, this.options.position );\n\n\t\tif ( !content ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Content can be updated multiple times. If the tooltip already\n\t\t// exists, then just update the content and bail.\n\t\ttooltipData = this._find( target );\n\t\tif ( tooltipData ) {\n\t\t\ttooltipData.tooltip.find( \".ui-tooltip-content\" ).html( content );\n\t\t\treturn;\n\t\t}\n\n\t\t// If we have a title, clear it to prevent the native tooltip\n\t\t// we have to check first to avoid defining a title if none exists\n\t\t// (we don't want to cause an element to start matching [title])\n\t\t//\n\t\t// We use removeAttr only for key events, to allow IE to export the correct\n\t\t// accessible attributes. For mouse events, set to empty string to avoid\n\t\t// native tooltip showing up (happens only when removing inside mouseover).\n\t\tif ( target.is( \"[title]\" ) ) {\n\t\t\tif ( event && event.type === \"mouseover\" ) {\n\t\t\t\ttarget.attr( \"title\", \"\" );\n\t\t\t} else {\n\t\t\t\ttarget.removeAttr( \"title\" );\n\t\t\t}\n\t\t}\n\n\t\ttooltipData = this._tooltip( target );\n\t\ttooltip = tooltipData.tooltip;\n\t\tthis._addDescribedBy( target, tooltip.attr( \"id\" ) );\n\t\ttooltip.find( \".ui-tooltip-content\" ).html( content );\n\n\t\t// Support: Voiceover on OS X, JAWS on IE <= 9\n\t\t// JAWS announces deletions even when aria-relevant=\"additions\"\n\t\t// Voiceover will sometimes re-read the entire log region's contents from the beginning\n\t\tthis.liveRegion.children().hide();\n\t\ta11yContent = $( \"<div>\" ).html( tooltip.find( \".ui-tooltip-content\" ).html() );\n\t\ta11yContent.removeAttr( \"name\" ).find( \"[name]\" ).removeAttr( \"name\" );\n\t\ta11yContent.removeAttr( \"id\" ).find( \"[id]\" ).removeAttr( \"id\" );\n\t\ta11yContent.appendTo( this.liveRegion );\n\n\t\tfunction position( event ) {\n\t\t\tpositionOption.of = event;\n\t\t\tif ( tooltip.is( \":hidden\" ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\ttooltip.position( positionOption );\n\t\t}\n\t\tif ( this.options.track && event && /^mouse/.test( event.type ) ) {\n\t\t\tthis._on( this.document, {\n\t\t\t\tmousemove: position\n\t\t\t} );\n\n\t\t\t// trigger once to override element-relative positioning\n\t\t\tposition( event );\n\t\t} else {\n\t\t\ttooltip.position( $.extend( {\n\t\t\t\tof: target\n\t\t\t}, this.options.position ) );\n\t\t}\n\n\t\ttooltip.hide();\n\n\t\tthis._show( tooltip, this.options.show );\n\n\t\t// Handle tracking tooltips that are shown with a delay (#8644). As soon\n\t\t// as the tooltip is visible, position the tooltip using the most recent\n\t\t// event.\n\t\t// Adds the check to add the timers only when both delay and track options are set (#14682)\n\t\tif ( this.options.track && this.options.show && this.options.show.delay ) {\n\t\t\tdelayedShow = this.delayedShow = setInterval( function() {\n\t\t\t\tif ( tooltip.is( \":visible\" ) ) {\n\t\t\t\t\tposition( positionOption.of );\n\t\t\t\t\tclearInterval( delayedShow );\n\t\t\t\t}\n\t\t\t}, 13 );\n\t\t}\n\n\t\tthis._trigger( \"open\", event, { tooltip: tooltip } );\n\t},\n\n\t_registerCloseHandlers: function( event, target ) {\n\t\tvar events = {\n\t\t\tkeyup: function( event ) {\n\t\t\t\tif ( event.keyCode === $.ui.keyCode.ESCAPE ) {\n\t\t\t\t\tvar fakeEvent = $.Event( event );\n\t\t\t\t\tfakeEvent.currentTarget = target[ 0 ];\n\t\t\t\t\tthis.close( fakeEvent, true );\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t// Only bind remove handler for delegated targets. Non-delegated\n\t\t// tooltips will handle this in destroy.\n\t\tif ( target[ 0 ] !== this.element[ 0 ] ) {\n\t\t\tevents.remove = function() {\n\t\t\t\tvar targetElement = this._find( target );\n\t\t\t\tif ( targetElement ) {\n\t\t\t\t\tthis._removeTooltip( targetElement.tooltip );\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\n\t\tif ( !event || event.type === \"mouseover\" ) {\n\t\t\tevents.mouseleave = \"close\";\n\t\t}\n\t\tif ( !event || event.type === \"focusin\" ) {\n\t\t\tevents.focusout = \"close\";\n\t\t}\n\t\tthis._on( true, target, events );\n\t},\n\n\tclose: function( event ) {\n\t\tvar tooltip,\n\t\t\tthat = this,\n\t\t\ttarget = $( event ? event.currentTarget : this.element ),\n\t\t\ttooltipData = this._find( target );\n\n\t\t// The tooltip may already be closed\n\t\tif ( !tooltipData ) {\n\n\t\t\t// We set ui-tooltip-open immediately upon open (in open()), but only set the\n\t\t\t// additional data once there's actually content to show (in _open()). So even if the\n\t\t\t// tooltip doesn't have full data, we always remove ui-tooltip-open in case we're in\n\t\t\t// the period between open() and _open().\n\t\t\ttarget.removeData( \"ui-tooltip-open\" );\n\t\t\treturn;\n\t\t}\n\n\t\ttooltip = tooltipData.tooltip;\n\n\t\t// Disabling closes the tooltip, so we need to track when we're closing\n\t\t// to avoid an infinite loop in case the tooltip becomes disabled on close\n\t\tif ( tooltipData.closing ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Clear the interval for delayed tracking tooltips\n\t\tclearInterval( this.delayedShow );\n\n\t\t// Only set title if we had one before (see comment in _open())\n\t\t// If the title attribute has changed since open(), don't restore\n\t\tif ( target.data( \"ui-tooltip-title\" ) && !target.attr( \"title\" ) ) {\n\t\t\ttarget.attr( \"title\", target.data( \"ui-tooltip-title\" ) );\n\t\t}\n\n\t\tthis._removeDescribedBy( target );\n\n\t\ttooltipData.hiding = true;\n\t\ttooltip.stop( true );\n\t\tthis._hide( tooltip, this.options.hide, function() {\n\t\t\tthat._removeTooltip( $( this ) );\n\t\t} );\n\n\t\ttarget.removeData( \"ui-tooltip-open\" );\n\t\tthis._off( target, \"mouseleave focusout keyup\" );\n\n\t\t// Remove 'remove' binding only on delegated targets\n\t\tif ( target[ 0 ] !== this.element[ 0 ] ) {\n\t\t\tthis._off( target, \"remove\" );\n\t\t}\n\t\tthis._off( this.document, \"mousemove\" );\n\n\t\tif ( event && event.type === \"mouseleave\" ) {\n\t\t\t$.each( this.parents, function( id, parent ) {\n\t\t\t\t$( parent.element ).attr( \"title\", parent.title );\n\t\t\t\tdelete that.parents[ id ];\n\t\t\t} );\n\t\t}\n\n\t\ttooltipData.closing = true;\n\t\tthis._trigger( \"close\", event, { tooltip: tooltip } );\n\t\tif ( !tooltipData.hiding ) {\n\t\t\ttooltipData.closing = false;\n\t\t}\n\t},\n\n\t_tooltip: function( element ) {\n\t\tvar tooltip = $( \"<div>\" ).attr( \"role\", \"tooltip\" ),\n\t\t\tcontent = $( \"<div>\" ).appendTo( tooltip ),\n\t\t\tid = tooltip.uniqueId().attr( \"id\" );\n\n\t\tthis._addClass( content, \"ui-tooltip-content\" );\n\t\tthis._addClass( tooltip, \"ui-tooltip\", \"ui-widget ui-widget-content\" );\n\n\t\ttooltip.appendTo( this._appendTo( element ) );\n\n\t\treturn this.tooltips[ id ] = {\n\t\t\telement: element,\n\t\t\ttooltip: tooltip\n\t\t};\n\t},\n\n\t_find: function( target ) {\n\t\tvar id = target.data( \"ui-tooltip-id\" );\n\t\treturn id ? this.tooltips[ id ] : null;\n\t},\n\n\t_removeTooltip: function( tooltip ) {\n\n\t\t// Clear the interval for delayed tracking tooltips\n\t\tclearInterval( this.delayedShow );\n\n\t\ttooltip.remove();\n\t\tdelete this.tooltips[ tooltip.attr( \"id\" ) ];\n\t},\n\n\t_appendTo: function( target ) {\n\t\tvar element = target.closest( \".ui-front, dialog\" );\n\n\t\tif ( !element.length ) {\n\t\t\telement = this.document[ 0 ].body;\n\t\t}\n\n\t\treturn element;\n\t},\n\n\t_destroy: function() {\n\t\tvar that = this;\n\n\t\t// Close open tooltips\n\t\t$.each( this.tooltips, function( id, tooltipData ) {\n\n\t\t\t// Delegate to close method to handle common cleanup\n\t\t\tvar event = $.Event( \"blur\" ),\n\t\t\t\telement = tooltipData.element;\n\t\t\tevent.target = event.currentTarget = element[ 0 ];\n\t\t\tthat.close( event, true );\n\n\t\t\t// Remove immediately; destroying an open tooltip doesn't use the\n\t\t\t// hide animation\n\t\t\t$( \"#\" + id ).remove();\n\n\t\t\t// Restore the title\n\t\t\tif ( element.data( \"ui-tooltip-title\" ) ) {\n\n\t\t\t\t// If the title attribute has changed since open(), don't restore\n\t\t\t\tif ( !element.attr( \"title\" ) ) {\n\t\t\t\t\telement.attr( \"title\", element.data( \"ui-tooltip-title\" ) );\n\t\t\t\t}\n\t\t\t\telement.removeData( \"ui-tooltip-title\" );\n\t\t\t}\n\t\t} );\n\t\tthis.liveRegion.remove();\n\t}\n} );\n\n// DEPRECATED\n// TODO: Switch return back to widget declaration at top of file when this is removed\nif ( $.uiBackCompat !== false ) {\n\n\t// Backcompat for tooltipClass option\n\t$.widget( \"ui.tooltip\", $.ui.tooltip, {\n\t\toptions: {\n\t\t\ttooltipClass: null\n\t\t},\n\t\t_tooltip: function() {\n\t\t\tvar tooltipData = this._superApply( arguments );\n\t\t\tif ( this.options.tooltipClass ) {\n\t\t\t\ttooltipData.tooltip.addClass( this.options.tooltipClass );\n\t\t\t}\n\t\t\treturn tooltipData;\n\t\t}\n\t} );\n}\n\nreturn $.ui.tooltip;\n\n} );\n","jquery/spectrum/tinycolor.js":"// TinyColor v1.4.2\n// https://github.com/bgrins/TinyColor\n// Brian Grinstead, MIT License\n\n(function(Math) {\n\n    var trimLeft = /^\\s+/,\n        trimRight = /\\s+$/,\n        tinyCounter = 0,\n        mathRound = Math.round,\n        mathMin = Math.min,\n        mathMax = Math.max,\n        mathRandom = Math.random;\n\n    function tinycolor (color, opts) {\n\n        color = (color) ? color : '';\n        opts = opts || { };\n\n        // If input is already a tinycolor, return itself\n        if (color instanceof tinycolor) {\n            return color;\n        }\n        // If we are called as a function, call using new instead\n        if (!(this instanceof tinycolor)) {\n            return new tinycolor(color, opts);\n        }\n\n        var rgb = inputToRGB(color);\n        this._originalInput = color,\n            this._r = rgb.r,\n            this._g = rgb.g,\n            this._b = rgb.b,\n            this._a = rgb.a,\n            this._roundA = mathRound(100*this._a) / 100,\n            this._format = opts.format || rgb.format;\n        this._gradientType = opts.gradientType;\n\n        // Don't let the range of [0,255] come back in [0,1].\n        // Potentially lose a little bit of precision here, but will fix issues where\n        // .5 gets interpreted as half of the total, instead of half of 1\n        // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n        if (this._r < 1) { this._r = mathRound(this._r); }\n        if (this._g < 1) { this._g = mathRound(this._g); }\n        if (this._b < 1) { this._b = mathRound(this._b); }\n\n        this._ok = rgb.ok;\n        this._tc_id = tinyCounter++;\n    }\n\n    tinycolor.prototype = {\n        isDark: function() {\n            return this.getBrightness() < 128;\n        },\n        isLight: function() {\n            return !this.isDark();\n        },\n        isValid: function() {\n            return this._ok;\n        },\n        getOriginalInput: function() {\n            return this._originalInput;\n        },\n        getFormat: function() {\n            return this._format;\n        },\n        getAlpha: function() {\n            return this._a;\n        },\n        getBrightness: function() {\n            //http://www.w3.org/TR/AERT#color-contrast\n            var rgb = this.toRgb();\n            return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n        },\n        getLuminance: function() {\n            //http://www.w3.org/TR/2008/REC-WCAG20-20081211/#relativeluminancedef\n            var rgb = this.toRgb();\n            var RsRGB, GsRGB, BsRGB, R, G, B;\n            RsRGB = rgb.r/255;\n            GsRGB = rgb.g/255;\n            BsRGB = rgb.b/255;\n\n            if (RsRGB <= 0.03928) {R = RsRGB / 12.92;} else {R = Math.pow(((RsRGB + 0.055) / 1.055), 2.4);}\n            if (GsRGB <= 0.03928) {G = GsRGB / 12.92;} else {G = Math.pow(((GsRGB + 0.055) / 1.055), 2.4);}\n            if (BsRGB <= 0.03928) {B = BsRGB / 12.92;} else {B = Math.pow(((BsRGB + 0.055) / 1.055), 2.4);}\n            return (0.2126 * R) + (0.7152 * G) + (0.0722 * B);\n        },\n        setAlpha: function(value) {\n            this._a = boundAlpha(value);\n            this._roundA = mathRound(100*this._a) / 100;\n            return this;\n        },\n        toHsv: function() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };\n        },\n        toHsvString: function() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);\n            return (this._a == 1) ?\n                \"hsv(\"  + h + \", \" + s + \"%, \" + v + \"%)\" :\n                \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \"+ this._roundA + \")\";\n        },\n        toHsl: function() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };\n        },\n        toHslString: function() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            var h = mathRound(hsl.h * 360), s = mathRound(hsl.s * 100), l = mathRound(hsl.l * 100);\n            return (this._a == 1) ?\n                \"hsl(\"  + h + \", \" + s + \"%, \" + l + \"%)\" :\n                \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \"+ this._roundA + \")\";\n        },\n        toHex: function(allow3Char) {\n            return rgbToHex(this._r, this._g, this._b, allow3Char);\n        },\n        toHexString: function(allow3Char) {\n            return '#' + this.toHex(allow3Char);\n        },\n        toHex8: function(allow4Char) {\n            return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);\n        },\n        toHex8String: function(allow4Char) {\n            return '#' + this.toHex8(allow4Char);\n        },\n        toRgb: function() {\n            return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };\n        },\n        toRgbString: function() {\n            return (this._a == 1) ?\n                \"rgb(\"  + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \")\" :\n                \"rgba(\" + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \", \" + this._roundA + \")\";\n        },\n        toPercentageRgb: function() {\n            return { r: mathRound(bound01(this._r, 255) * 100) + \"%\", g: mathRound(bound01(this._g, 255) * 100) + \"%\", b: mathRound(bound01(this._b, 255) * 100) + \"%\", a: this._a };\n        },\n        toPercentageRgbString: function() {\n            return (this._a == 1) ?\n                \"rgb(\"  + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%)\" :\n                \"rgba(\" + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n        },\n        toName: function() {\n            if (this._a === 0) {\n                return \"transparent\";\n            }\n\n            if (this._a < 1) {\n                return false;\n            }\n\n            return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n        },\n        toFilter: function(secondColor) {\n            var hex8String = '#' + rgbaToArgbHex(this._r, this._g, this._b, this._a);\n            var secondHex8String = hex8String;\n            var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n\n            if (secondColor) {\n                var s = tinycolor(secondColor);\n                secondHex8String = '#' + rgbaToArgbHex(s._r, s._g, s._b, s._a);\n            }\n\n            return \"progid:DXImageTransform.Microsoft.gradient(\"+gradientType+\"startColorstr=\"+hex8String+\",endColorstr=\"+secondHex8String+\")\";\n        },\n        toString: function(format) {\n            var formatSet = !!format;\n            format = format || this._format;\n\n            var formattedString = false;\n            var hasAlpha = this._a < 1 && this._a >= 0;\n            var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"hex4\" || format === \"hex8\" || format === \"name\");\n\n            if (needsAlphaFormat) {\n                // Special case for \"transparent\", all other non-alpha formats\n                // will return rgba when there is transparency.\n                if (format === \"name\" && this._a === 0) {\n                    return this.toName();\n                }\n                return this.toRgbString();\n            }\n            if (format === \"rgb\") {\n                formattedString = this.toRgbString();\n            }\n            if (format === \"prgb\") {\n                formattedString = this.toPercentageRgbString();\n            }\n            if (format === \"hex\" || format === \"hex6\") {\n                formattedString = this.toHexString();\n            }\n            if (format === \"hex3\") {\n                formattedString = this.toHexString(true);\n            }\n            if (format === \"hex4\") {\n                formattedString = this.toHex8String(true);\n            }\n            if (format === \"hex8\") {\n                formattedString = this.toHex8String();\n            }\n            if (format === \"name\") {\n                formattedString = this.toName();\n            }\n            if (format === \"hsl\") {\n                formattedString = this.toHslString();\n            }\n            if (format === \"hsv\") {\n                formattedString = this.toHsvString();\n            }\n\n            return formattedString || this.toHexString();\n        },\n        clone: function() {\n            return tinycolor(this.toString());\n        },\n\n        _applyModification: function(fn, args) {\n            var color = fn.apply(null, [this].concat([].slice.call(args)));\n            this._r = color._r;\n            this._g = color._g;\n            this._b = color._b;\n            this.setAlpha(color._a);\n            return this;\n        },\n        lighten: function() {\n            return this._applyModification(lighten, arguments);\n        },\n        brighten: function() {\n            return this._applyModification(brighten, arguments);\n        },\n        darken: function() {\n            return this._applyModification(darken, arguments);\n        },\n        desaturate: function() {\n            return this._applyModification(desaturate, arguments);\n        },\n        saturate: function() {\n            return this._applyModification(saturate, arguments);\n        },\n        greyscale: function() {\n            return this._applyModification(greyscale, arguments);\n        },\n        spin: function() {\n            return this._applyModification(spin, arguments);\n        },\n\n        _applyCombination: function(fn, args) {\n            return fn.apply(null, [this].concat([].slice.call(args)));\n        },\n        analogous: function() {\n            return this._applyCombination(analogous, arguments);\n        },\n        complement: function() {\n            return this._applyCombination(complement, arguments);\n        },\n        monochromatic: function() {\n            return this._applyCombination(monochromatic, arguments);\n        },\n        splitcomplement: function() {\n            return this._applyCombination(splitcomplement, arguments);\n        },\n        triad: function() {\n            return this._applyCombination(triad, arguments);\n        },\n        tetrad: function() {\n            return this._applyCombination(tetrad, arguments);\n        }\n    };\n\n// If input is an object, force 1 into \"1.0\" to handle ratios properly\n// String input requires \"1.0\" as input, so 1 will be treated as 1\n    tinycolor.fromRatio = function(color, opts) {\n        if (typeof color == \"object\") {\n            var newColor = {};\n            for (var i in color) {\n                if (color.hasOwnProperty(i)) {\n                    if (i === \"a\") {\n                        newColor[i] = color[i];\n                    }\n                    else {\n                        newColor[i] = convertToPercentage(color[i]);\n                    }\n                }\n            }\n            color = newColor;\n        }\n\n        return tinycolor(color, opts);\n    };\n\n// Given a string or object, convert that input to RGB\n// Possible string inputs:\n//\n//     \"red\"\n//     \"#f00\" or \"f00\"\n//     \"#ff0000\" or \"ff0000\"\n//     \"#ff000000\" or \"ff000000\"\n//     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n//     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n//     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n//     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n//     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n//     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n//     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n//\n    function inputToRGB(color) {\n\n        var rgb = { r: 0, g: 0, b: 0 };\n        var a = 1;\n        var s = null;\n        var v = null;\n        var l = null;\n        var ok = false;\n        var format = false;\n\n        if (typeof color == \"string\") {\n            color = stringInputToObject(color);\n        }\n\n        if (typeof color == \"object\") {\n            if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {\n                rgb = rgbToRgb(color.r, color.g, color.b);\n                ok = true;\n                format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n            }\n            else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {\n                s = convertToPercentage(color.s);\n                v = convertToPercentage(color.v);\n                rgb = hsvToRgb(color.h, s, v);\n                ok = true;\n                format = \"hsv\";\n            }\n            else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {\n                s = convertToPercentage(color.s);\n                l = convertToPercentage(color.l);\n                rgb = hslToRgb(color.h, s, l);\n                ok = true;\n                format = \"hsl\";\n            }\n\n            if (color.hasOwnProperty(\"a\")) {\n                a = color.a;\n            }\n        }\n\n        a = boundAlpha(a);\n\n        return {\n            ok: ok,\n            format: color.format || format,\n            r: mathMin(255, mathMax(rgb.r, 0)),\n            g: mathMin(255, mathMax(rgb.g, 0)),\n            b: mathMin(255, mathMax(rgb.b, 0)),\n            a: a\n        };\n    }\n\n\n// Conversion Functions\n// --------------------\n\n// `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n// <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n// `rgbToRgb`\n// Handle bounds / percentage checking to conform to CSS color spec\n// <http://www.w3.org/TR/css3-color/>\n// *Assumes:* r, g, b in [0, 255] or [0, 1]\n// *Returns:* { r, g, b } in [0, 255]\n    function rgbToRgb(r, g, b){\n        return {\n            r: bound01(r, 255) * 255,\n            g: bound01(g, 255) * 255,\n            b: bound01(b, 255) * 255\n        };\n    }\n\n// `rgbToHsl`\n// Converts an RGB color value to HSL.\n// *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n// *Returns:* { h, s, l } in [0,1]\n    function rgbToHsl(r, g, b) {\n\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n\n        var max = mathMax(r, g, b), min = mathMin(r, g, b);\n        var h, s, l = (max + min) / 2;\n\n        if(max == min) {\n            h = s = 0; // achromatic\n        }\n        else {\n            var d = max - min;\n            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n            switch(max) {\n                case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                case g: h = (b - r) / d + 2; break;\n                case b: h = (r - g) / d + 4; break;\n            }\n\n            h /= 6;\n        }\n\n        return { h: h, s: s, l: l };\n    }\n\n// `hslToRgb`\n// Converts an HSL color value to RGB.\n// *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n// *Returns:* { r, g, b } in the set [0, 255]\n    function hslToRgb(h, s, l) {\n        var r, g, b;\n\n        h = bound01(h, 360);\n        s = bound01(s, 100);\n        l = bound01(l, 100);\n\n        function hue2rgb(p, q, t) {\n            if(t < 0) t += 1;\n            if(t > 1) t -= 1;\n            if(t < 1/6) return p + (q - p) * 6 * t;\n            if(t < 1/2) return q;\n            if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n            return p;\n        }\n\n        if(s === 0) {\n            r = g = b = l; // achromatic\n        }\n        else {\n            var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n            var p = 2 * l - q;\n            r = hue2rgb(p, q, h + 1/3);\n            g = hue2rgb(p, q, h);\n            b = hue2rgb(p, q, h - 1/3);\n        }\n\n        return { r: r * 255, g: g * 255, b: b * 255 };\n    }\n\n// `rgbToHsv`\n// Converts an RGB color value to HSV\n// *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n// *Returns:* { h, s, v } in [0,1]\n    function rgbToHsv(r, g, b) {\n\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n\n        var max = mathMax(r, g, b), min = mathMin(r, g, b);\n        var h, s, v = max;\n\n        var d = max - min;\n        s = max === 0 ? 0 : d / max;\n\n        if(max == min) {\n            h = 0; // achromatic\n        }\n        else {\n            switch(max) {\n                case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                case g: h = (b - r) / d + 2; break;\n                case b: h = (r - g) / d + 4; break;\n            }\n            h /= 6;\n        }\n        return { h: h, s: s, v: v };\n    }\n\n// `hsvToRgb`\n// Converts an HSV color value to RGB.\n// *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n// *Returns:* { r, g, b } in the set [0, 255]\n    function hsvToRgb(h, s, v) {\n\n        h = bound01(h, 360) * 6;\n        s = bound01(s, 100);\n        v = bound01(v, 100);\n\n        var i = Math.floor(h),\n            f = h - i,\n            p = v * (1 - s),\n            q = v * (1 - f * s),\n            t = v * (1 - (1 - f) * s),\n            mod = i % 6,\n            r = [v, q, p, p, t, v][mod],\n            g = [t, v, v, q, p, p][mod],\n            b = [p, p, t, v, v, q][mod];\n\n        return { r: r * 255, g: g * 255, b: b * 255 };\n    }\n\n// `rgbToHex`\n// Converts an RGB color to hex\n// Assumes r, g, and b are contained in the set [0, 255]\n// Returns a 3 or 6 character hex\n    function rgbToHex(r, g, b, allow3Char) {\n\n        var hex = [\n            pad2(mathRound(r).toString(16)),\n            pad2(mathRound(g).toString(16)),\n            pad2(mathRound(b).toString(16))\n        ];\n\n        // Return a 3 character hex if possible\n        if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n        }\n\n        return hex.join(\"\");\n    }\n\n// `rgbaToHex`\n// Converts an RGBA color plus alpha transparency to hex\n// Assumes r, g, b are contained in the set [0, 255] and\n// a in [0, 1]. Returns a 4 or 8 character rgba hex\n    function rgbaToHex(r, g, b, a, allow4Char) {\n\n        var hex = [\n            pad2(mathRound(r).toString(16)),\n            pad2(mathRound(g).toString(16)),\n            pad2(mathRound(b).toString(16)),\n            pad2(convertDecimalToHex(a))\n        ];\n\n        // Return a 4 character hex if possible\n        if (allow4Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1) && hex[3].charAt(0) == hex[3].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);\n        }\n\n        return hex.join(\"\");\n    }\n\n// `rgbaToArgbHex`\n// Converts an RGBA color to an ARGB Hex8 string\n// Rarely used, but required for \"toFilter()\"\n    function rgbaToArgbHex(r, g, b, a) {\n\n        var hex = [\n            pad2(convertDecimalToHex(a)),\n            pad2(mathRound(r).toString(16)),\n            pad2(mathRound(g).toString(16)),\n            pad2(mathRound(b).toString(16))\n        ];\n\n        return hex.join(\"\");\n    }\n\n// `equals`\n// Can be called with any tinycolor input\n    tinycolor.equals = function (color1, color2) {\n        if (!color1 || !color2) { return false; }\n        return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n    };\n\n    tinycolor.random = function() {\n        return tinycolor.fromRatio({\n            r: mathRandom(),\n            g: mathRandom(),\n            b: mathRandom()\n        });\n    };\n\n\n// Modification Functions\n// ----------------------\n// Thanks to less.js for some of the basics here\n// <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n    function desaturate(color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.s -= amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n\n    function saturate(color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.s += amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n\n    function greyscale(color) {\n        return tinycolor(color).desaturate(100);\n    }\n\n    function lighten (color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.l += amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n\n    function brighten(color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var rgb = tinycolor(color).toRgb();\n        rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * - (amount / 100))));\n        rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * - (amount / 100))));\n        rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * - (amount / 100))));\n        return tinycolor(rgb);\n    }\n\n    function darken (color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.l -= amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n\n// Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n// Values outside of this range will be wrapped into this range.\n    function spin(color, amount) {\n        var hsl = tinycolor(color).toHsl();\n        var hue = (hsl.h + amount) % 360;\n        hsl.h = hue < 0 ? 360 + hue : hue;\n        return tinycolor(hsl);\n    }\n\n// Combination Functions\n// ---------------------\n// Thanks to jQuery xColor for some of the ideas behind these\n// <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n    function complement(color) {\n        var hsl = tinycolor(color).toHsl();\n        hsl.h = (hsl.h + 180) % 360;\n        return tinycolor(hsl);\n    }\n\n    function triad(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [\n            tinycolor(color),\n            tinycolor({ h: (h + 120) % 360, s: hsl.s, l: hsl.l }),\n            tinycolor({ h: (h + 240) % 360, s: hsl.s, l: hsl.l })\n        ];\n    }\n\n    function tetrad(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [\n            tinycolor(color),\n            tinycolor({ h: (h + 90) % 360, s: hsl.s, l: hsl.l }),\n            tinycolor({ h: (h + 180) % 360, s: hsl.s, l: hsl.l }),\n            tinycolor({ h: (h + 270) % 360, s: hsl.s, l: hsl.l })\n        ];\n    }\n\n    function splitcomplement(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [\n            tinycolor(color),\n            tinycolor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l}),\n            tinycolor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l})\n        ];\n    }\n\n    function analogous(color, results, slices) {\n        results = results || 6;\n        slices = slices || 30;\n\n        var hsl = tinycolor(color).toHsl();\n        var part = 360 / slices;\n        var ret = [tinycolor(color)];\n\n        for (hsl.h = ((hsl.h - (part * results >> 1)) + 720) % 360; --results; ) {\n            hsl.h = (hsl.h + part) % 360;\n            ret.push(tinycolor(hsl));\n        }\n        return ret;\n    }\n\n    function monochromatic(color, results) {\n        results = results || 6;\n        var hsv = tinycolor(color).toHsv();\n        var h = hsv.h, s = hsv.s, v = hsv.v;\n        var ret = [];\n        var modification = 1 / results;\n\n        while (results--) {\n            ret.push(tinycolor({ h: h, s: s, v: v}));\n            v = (v + modification) % 1;\n        }\n\n        return ret;\n    }\n\n// Utility Functions\n// ---------------------\n\n    tinycolor.mix = function(color1, color2, amount) {\n        amount = (amount === 0) ? 0 : (amount || 50);\n\n        var rgb1 = tinycolor(color1).toRgb();\n        var rgb2 = tinycolor(color2).toRgb();\n\n        var p = amount / 100;\n\n        var rgba = {\n            r: ((rgb2.r - rgb1.r) * p) + rgb1.r,\n            g: ((rgb2.g - rgb1.g) * p) + rgb1.g,\n            b: ((rgb2.b - rgb1.b) * p) + rgb1.b,\n            a: ((rgb2.a - rgb1.a) * p) + rgb1.a\n        };\n\n        return tinycolor(rgba);\n    };\n\n\n// Readability Functions\n// ---------------------\n// <http://www.w3.org/TR/2008/REC-WCAG20-20081211/#contrast-ratiodef (WCAG Version 2)\n\n// `contrast`\n// Analyze the 2 colors and returns the color contrast defined by (WCAG Version 2)\n    tinycolor.readability = function(color1, color2) {\n        var c1 = tinycolor(color1);\n        var c2 = tinycolor(color2);\n        return (Math.max(c1.getLuminance(),c2.getLuminance())+0.05) / (Math.min(c1.getLuminance(),c2.getLuminance())+0.05);\n    };\n\n// `isReadable`\n// Ensure that foreground and background color combinations meet WCAG2 guidelines.\n// The third argument is an optional Object.\n//      the 'level' property states 'AA' or 'AAA' - if missing or invalid, it defaults to 'AA';\n//      the 'size' property states 'large' or 'small' - if missing or invalid, it defaults to 'small'.\n// If the entire object is absent, isReadable defaults to {level:\"AA\",size:\"small\"}.\n\n// *Example*\n//    tinycolor.isReadable(\"#000\", \"#111\") => false\n//    tinycolor.isReadable(\"#000\", \"#111\",{level:\"AA\",size:\"large\"}) => false\n    tinycolor.isReadable = function(color1, color2, wcag2) {\n        var readability = tinycolor.readability(color1, color2);\n        var wcag2Parms, out;\n\n        out = false;\n\n        wcag2Parms = validateWCAG2Parms(wcag2);\n        switch (wcag2Parms.level + wcag2Parms.size) {\n            case \"AAsmall\":\n            case \"AAAlarge\":\n                out = readability >= 4.5;\n                break;\n            case \"AAlarge\":\n                out = readability >= 3;\n                break;\n            case \"AAAsmall\":\n                out = readability >= 7;\n                break;\n        }\n        return out;\n\n    };\n\n// `mostReadable`\n// Given a base color and a list of possible foreground or background\n// colors for that base, returns the most readable color.\n// Optionally returns Black or White if the most readable color is unreadable.\n// *Example*\n//    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:false}).toHexString(); // \"#112255\"\n//    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:true}).toHexString();  // \"#ffffff\"\n//    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"large\"}).toHexString(); // \"#faf3f3\"\n//    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"small\"}).toHexString(); // \"#ffffff\"\n    tinycolor.mostReadable = function(baseColor, colorList, args) {\n        var bestColor = null;\n        var bestScore = 0;\n        var readability;\n        var includeFallbackColors, level, size ;\n        args = args || {};\n        includeFallbackColors = args.includeFallbackColors ;\n        level = args.level;\n        size = args.size;\n\n        for (var i= 0; i < colorList.length ; i++) {\n            readability = tinycolor.readability(baseColor, colorList[i]);\n            if (readability > bestScore) {\n                bestScore = readability;\n                bestColor = tinycolor(colorList[i]);\n            }\n        }\n\n        if (tinycolor.isReadable(baseColor, bestColor, {\"level\":level,\"size\":size}) || !includeFallbackColors) {\n            return bestColor;\n        }\n        else {\n            args.includeFallbackColors=false;\n            return tinycolor.mostReadable(baseColor,[\"#fff\", \"#000\"],args);\n        }\n    };\n\n\n// Big List of Colors\n// ------------------\n// <http://www.w3.org/TR/css3-color/#svg-color>\n    var names = tinycolor.names = {\n        aliceblue: \"f0f8ff\",\n        antiquewhite: \"faebd7\",\n        aqua: \"0ff\",\n        aquamarine: \"7fffd4\",\n        azure: \"f0ffff\",\n        beige: \"f5f5dc\",\n        bisque: \"ffe4c4\",\n        black: \"000\",\n        blanchedalmond: \"ffebcd\",\n        blue: \"00f\",\n        blueviolet: \"8a2be2\",\n        brown: \"a52a2a\",\n        burlywood: \"deb887\",\n        burntsienna: \"ea7e5d\",\n        cadetblue: \"5f9ea0\",\n        chartreuse: \"7fff00\",\n        chocolate: \"d2691e\",\n        coral: \"ff7f50\",\n        cornflowerblue: \"6495ed\",\n        cornsilk: \"fff8dc\",\n        crimson: \"dc143c\",\n        cyan: \"0ff\",\n        darkblue: \"00008b\",\n        darkcyan: \"008b8b\",\n        darkgoldenrod: \"b8860b\",\n        darkgray: \"a9a9a9\",\n        darkgreen: \"006400\",\n        darkgrey: \"a9a9a9\",\n        darkkhaki: \"bdb76b\",\n        darkmagenta: \"8b008b\",\n        darkolivegreen: \"556b2f\",\n        darkorange: \"ff8c00\",\n        darkorchid: \"9932cc\",\n        darkred: \"8b0000\",\n        darksalmon: \"e9967a\",\n        darkseagreen: \"8fbc8f\",\n        darkslateblue: \"483d8b\",\n        darkslategray: \"2f4f4f\",\n        darkslategrey: \"2f4f4f\",\n        darkturquoise: \"00ced1\",\n        darkviolet: \"9400d3\",\n        deeppink: \"ff1493\",\n        deepskyblue: \"00bfff\",\n        dimgray: \"696969\",\n        dimgrey: \"696969\",\n        dodgerblue: \"1e90ff\",\n        firebrick: \"b22222\",\n        floralwhite: \"fffaf0\",\n        forestgreen: \"228b22\",\n        fuchsia: \"f0f\",\n        gainsboro: \"dcdcdc\",\n        ghostwhite: \"f8f8ff\",\n        gold: \"ffd700\",\n        goldenrod: \"daa520\",\n        gray: \"808080\",\n        green: \"008000\",\n        greenyellow: \"adff2f\",\n        grey: \"808080\",\n        honeydew: \"f0fff0\",\n        hotpink: \"ff69b4\",\n        indianred: \"cd5c5c\",\n        indigo: \"4b0082\",\n        ivory: \"fffff0\",\n        khaki: \"f0e68c\",\n        lavender: \"e6e6fa\",\n        lavenderblush: \"fff0f5\",\n        lawngreen: \"7cfc00\",\n        lemonchiffon: \"fffacd\",\n        lightblue: \"add8e6\",\n        lightcoral: \"f08080\",\n        lightcyan: \"e0ffff\",\n        lightgoldenrodyellow: \"fafad2\",\n        lightgray: \"d3d3d3\",\n        lightgreen: \"90ee90\",\n        lightgrey: \"d3d3d3\",\n        lightpink: \"ffb6c1\",\n        lightsalmon: \"ffa07a\",\n        lightseagreen: \"20b2aa\",\n        lightskyblue: \"87cefa\",\n        lightslategray: \"789\",\n        lightslategrey: \"789\",\n        lightsteelblue: \"b0c4de\",\n        lightyellow: \"ffffe0\",\n        lime: \"0f0\",\n        limegreen: \"32cd32\",\n        linen: \"faf0e6\",\n        magenta: \"f0f\",\n        maroon: \"800000\",\n        mediumaquamarine: \"66cdaa\",\n        mediumblue: \"0000cd\",\n        mediumorchid: \"ba55d3\",\n        mediumpurple: \"9370db\",\n        mediumseagreen: \"3cb371\",\n        mediumslateblue: \"7b68ee\",\n        mediumspringgreen: \"00fa9a\",\n        mediumturquoise: \"48d1cc\",\n        mediumvioletred: \"c71585\",\n        midnightblue: \"191970\",\n        mintcream: \"f5fffa\",\n        mistyrose: \"ffe4e1\",\n        moccasin: \"ffe4b5\",\n        navajowhite: \"ffdead\",\n        navy: \"000080\",\n        oldlace: \"fdf5e6\",\n        olive: \"808000\",\n        olivedrab: \"6b8e23\",\n        orange: \"ffa500\",\n        orangered: \"ff4500\",\n        orchid: \"da70d6\",\n        palegoldenrod: \"eee8aa\",\n        palegreen: \"98fb98\",\n        paleturquoise: \"afeeee\",\n        palevioletred: \"db7093\",\n        papayawhip: \"ffefd5\",\n        peachpuff: \"ffdab9\",\n        peru: \"cd853f\",\n        pink: \"ffc0cb\",\n        plum: \"dda0dd\",\n        powderblue: \"b0e0e6\",\n        purple: \"800080\",\n        rebeccapurple: \"663399\",\n        red: \"f00\",\n        rosybrown: \"bc8f8f\",\n        royalblue: \"4169e1\",\n        saddlebrown: \"8b4513\",\n        salmon: \"fa8072\",\n        sandybrown: \"f4a460\",\n        seagreen: \"2e8b57\",\n        seashell: \"fff5ee\",\n        sienna: \"a0522d\",\n        silver: \"c0c0c0\",\n        skyblue: \"87ceeb\",\n        slateblue: \"6a5acd\",\n        slategray: \"708090\",\n        slategrey: \"708090\",\n        snow: \"fffafa\",\n        springgreen: \"00ff7f\",\n        steelblue: \"4682b4\",\n        tan: \"d2b48c\",\n        teal: \"008080\",\n        thistle: \"d8bfd8\",\n        tomato: \"ff6347\",\n        turquoise: \"40e0d0\",\n        violet: \"ee82ee\",\n        wheat: \"f5deb3\",\n        white: \"fff\",\n        whitesmoke: \"f5f5f5\",\n        yellow: \"ff0\",\n        yellowgreen: \"9acd32\"\n    };\n\n// Make it easy to access colors via `hexNames[hex]`\n    var hexNames = tinycolor.hexNames = flip(names);\n\n\n// Utilities\n// ---------\n\n// `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n    function flip(o) {\n        var flipped = { };\n        for (var i in o) {\n            if (o.hasOwnProperty(i)) {\n                flipped[o[i]] = i;\n            }\n        }\n        return flipped;\n    }\n\n// Return a valid alpha value [0,1] with all invalid values being set to 1\n    function boundAlpha(a) {\n        a = parseFloat(a);\n\n        if (isNaN(a) || a < 0 || a > 1) {\n            a = 1;\n        }\n\n        return a;\n    }\n\n// Take input from [0, n] and return it as [0, 1]\n    function bound01(n, max) {\n        if (isOnePointZero(n)) { n = \"100%\"; }\n\n        var processPercent = isPercentage(n);\n        n = mathMin(max, mathMax(0, parseFloat(n)));\n\n        // Automatically convert percentage into number\n        if (processPercent) {\n            n = parseInt(n * max, 10) / 100;\n        }\n\n        // Handle floating point rounding errors\n        if ((Math.abs(n - max) < 0.000001)) {\n            return 1;\n        }\n\n        // Convert into [0, 1] range if it isn't already\n        return (n % max) / parseFloat(max);\n    }\n\n// Force a number between 0 and 1\n    function clamp01(val) {\n        return mathMin(1, mathMax(0, val));\n    }\n\n// Parse a base-16 hex value into a base-10 integer\n    function parseIntFromHex(val) {\n        return parseInt(val, 16);\n    }\n\n// Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n// <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n    function isOnePointZero(n) {\n        return typeof n == \"string\" && n.indexOf('.') != -1 && parseFloat(n) === 1;\n    }\n\n// Check to see if string passed in is a percentage\n    function isPercentage(n) {\n        return typeof n === \"string\" && n.indexOf('%') != -1;\n    }\n\n// Force a hex value to have 2 characters\n    function pad2(c) {\n        return c.length == 1 ? '0' + c : '' + c;\n    }\n\n// Replace a decimal with it's percentage value\n    function convertToPercentage(n) {\n        if (n <= 1) {\n            n = (n * 100) + \"%\";\n        }\n\n        return n;\n    }\n\n// Converts a decimal to a hex value\n    function convertDecimalToHex(d) {\n        return Math.round(parseFloat(d) * 255).toString(16);\n    }\n// Converts a hex value to a decimal\n    function convertHexToDecimal(h) {\n        return (parseIntFromHex(h) / 255);\n    }\n\n    var matchers = (function() {\n\n        // <http://www.w3.org/TR/css3-values/#integers>\n        var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n        // <http://www.w3.org/TR/css3-values/#number-value>\n        var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n        // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n        var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n        // Actual matching.\n        // Parentheses and commas are optional, but not required.\n        // Whitespace can take the place of commas or opening paren\n        var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n        var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n\n        return {\n            CSS_UNIT: new RegExp(CSS_UNIT),\n            rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n            rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n            hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n            hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n            hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n            hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n            hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n            hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n        };\n    })();\n\n// `isValidCSSUnit`\n// Take in a single string / number and check to see if it looks like a CSS unit\n// (see `matchers` above for definition).\n    function isValidCSSUnit(color) {\n        return !!matchers.CSS_UNIT.exec(color);\n    }\n\n// `stringInputToObject`\n// Permissive string parsing.  Take in a number of formats, and output an object\n// based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n    function stringInputToObject(color) {\n\n        color = color.replace(trimLeft,'').replace(trimRight, '').toLowerCase();\n        var named = false;\n        if (names[color]) {\n            color = names[color];\n            named = true;\n        }\n        else if (color == 'transparent') {\n            return { r: 0, g: 0, b: 0, a: 0, format: \"name\" };\n        }\n\n        // Try to match string input using regular expressions.\n        // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n        // Just return an object and let the conversion functions handle that.\n        // This way the result will be the same whether the tinycolor is initialized with string or object.\n        var match;\n        if ((match = matchers.rgb.exec(color))) {\n            return { r: match[1], g: match[2], b: match[3] };\n        }\n        if ((match = matchers.rgba.exec(color))) {\n            return { r: match[1], g: match[2], b: match[3], a: match[4] };\n        }\n        if ((match = matchers.hsl.exec(color))) {\n            return { h: match[1], s: match[2], l: match[3] };\n        }\n        if ((match = matchers.hsla.exec(color))) {\n            return { h: match[1], s: match[2], l: match[3], a: match[4] };\n        }\n        if ((match = matchers.hsv.exec(color))) {\n            return { h: match[1], s: match[2], v: match[3] };\n        }\n        if ((match = matchers.hsva.exec(color))) {\n            return { h: match[1], s: match[2], v: match[3], a: match[4] };\n        }\n        if ((match = matchers.hex8.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                a: convertHexToDecimal(match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if ((match = matchers.hex6.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n        if ((match = matchers.hex4.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1] + '' + match[1]),\n                g: parseIntFromHex(match[2] + '' + match[2]),\n                b: parseIntFromHex(match[3] + '' + match[3]),\n                a: convertHexToDecimal(match[4] + '' + match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if ((match = matchers.hex3.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1] + '' + match[1]),\n                g: parseIntFromHex(match[2] + '' + match[2]),\n                b: parseIntFromHex(match[3] + '' + match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n\n        return false;\n    }\n\n    function validateWCAG2Parms(parms) {\n        // return valid WCAG2 parms for isReadable.\n        // If input parms are invalid, return {\"level\":\"AA\", \"size\":\"small\"}\n        var level, size;\n        parms = parms || {\"level\":\"AA\", \"size\":\"small\"};\n        level = (parms.level || \"AA\").toUpperCase();\n        size = (parms.size || \"small\").toLowerCase();\n        if (level !== \"AA\" && level !== \"AAA\") {\n            level = \"AA\";\n        }\n        if (size !== \"small\" && size !== \"large\") {\n            size = \"small\";\n        }\n        return {\"level\":level, \"size\":size};\n    }\n\n// Node: Export function\n    if (typeof module !== \"undefined\" && module.exports) {\n        module.exports = tinycolor;\n    }\n// AMD/requirejs: Define the module\n    else if (typeof define === 'function' && define.amd) {\n        define(function () {return tinycolor;});\n    }\n// Browser: Expose to window\n    else {\n        window.tinycolor = tinycolor;\n    }\n\n})(Math);\n","jquery/spectrum/spectrum.js":"// Spectrum Colorpicker v1.8.1\n// https://github.com/bgrins/spectrum\n// Author: Brian Grinstead\n// License: MIT\n\n(function (factory) {\n    \"use strict\";\n\n    if (typeof define === 'function' && define.amd) { // AMD\n        define(['jquery'], factory);\n    }\n    else if (typeof exports == \"object\" && typeof module == \"object\") { // CommonJS\n        module.exports = factory(require('jquery'));\n    }\n    else { // Browser\n        factory(jQuery);\n    }\n})(function($, undefined) {\n    \"use strict\";\n\n    var defaultOpts = {\n\n            // Callbacks\n            beforeShow: noop,\n            move: noop,\n            change: noop,\n            show: noop,\n            hide: noop,\n\n            // Options\n            color: false,\n            flat: false,\n            showInput: false,\n            allowEmpty: false,\n            showButtons: true,\n            clickoutFiresChange: true,\n            showInitial: false,\n            showPalette: false,\n            showPaletteOnly: false,\n            hideAfterPaletteSelect: false,\n            togglePaletteOnly: false,\n            showSelectionPalette: true,\n            localStorageKey: false,\n            appendTo: \"body\",\n            maxSelectionSize: 7,\n            cancelText: \"cancel\",\n            chooseText: \"choose\",\n            togglePaletteMoreText: \"more\",\n            togglePaletteLessText: \"less\",\n            clearText: \"Clear Color Selection\",\n            noColorSelectedText: \"No Color Selected\",\n            preferredFormat: false,\n            className: \"\", // Deprecated - use containerClassName and replacerClassName instead.\n            containerClassName: \"\",\n            replacerClassName: \"\",\n            showAlpha: false,\n            theme: \"sp-light\",\n            palette: [[\"#ffffff\", \"#000000\", \"#ff0000\", \"#ff8000\", \"#ffff00\", \"#008000\", \"#0000ff\", \"#4b0082\", \"#9400d3\"]],\n            selectionPalette: [],\n            disabled: false,\n            offset: null\n        },\n        spectrums = [],\n        IE = !!/msie/i.exec( window.navigator.userAgent ),\n        rgbaSupport = (function() {\n            function contains( str, substr ) {\n                return !!~('' + str).indexOf(substr);\n            }\n\n            var elem = document.createElement('div');\n            var style = elem.style;\n            style.cssText = 'background-color:rgba(0,0,0,.5)';\n            return contains(style.backgroundColor, 'rgba') || contains(style.backgroundColor, 'hsla');\n        })(),\n        replaceInput = [\n            \"<div class='sp-replacer'>\",\n            \"<div class='sp-preview'><div class='sp-preview-inner'></div></div>\",\n            \"<div class='sp-dd'>&#9660;</div>\",\n            \"</div>\"\n        ].join(''),\n        markup = (function () {\n\n            // IE does not support gradients with multiple stops, so we need to simulate\n            //  that for the rainbow slider with 8 divs that each have a single gradient\n            var gradientFix = \"\";\n            if (IE) {\n                for (var i = 1; i <= 6; i++) {\n                    gradientFix += \"<div class='sp-\" + i + \"'></div>\";\n                }\n            }\n\n            return [\n                \"<div class='sp-container sp-hidden'>\",\n                \"<div class='sp-palette-container'>\",\n                \"<div class='sp-palette sp-thumb sp-cf'></div>\",\n                \"<div class='sp-palette-button-container sp-cf'>\",\n                \"<button type='button' class='sp-palette-toggle'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-picker-container'>\",\n                \"<div class='sp-top sp-cf'>\",\n                \"<div class='sp-fill'></div>\",\n                \"<div class='sp-top-inner'>\",\n                \"<div class='sp-color'>\",\n                \"<div class='sp-sat'>\",\n                \"<div class='sp-val'>\",\n                \"<div class='sp-dragger'></div>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-clear sp-clear-display'>\",\n                \"</div>\",\n                \"<div class='sp-hue'>\",\n                \"<div class='sp-slider'></div>\",\n                gradientFix,\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-alpha'><div class='sp-alpha-inner'><div class='sp-alpha-handle'></div></div></div>\",\n                \"</div>\",\n                \"<div class='sp-input-container sp-cf'>\",\n                \"<input class='sp-input' type='text' spellcheck='false'  />\",\n                \"</div>\",\n                \"<div class='sp-initial sp-thumb sp-cf'></div>\",\n                \"<div class='sp-button-container sp-cf'>\",\n                \"<a class='sp-cancel' href='#'></a>\",\n                \"<button type='button' class='sp-choose'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\"\n            ].join(\"\");\n        })();\n\n    function paletteTemplate (p, color, className, opts) {\n        var html = [];\n        for (var i = 0; i < p.length; i++) {\n            var current = p[i];\n            if(current) {\n                var tiny = tinycolor(current);\n                var c = tiny.toHsl().l < 0.5 ? \"sp-thumb-el sp-thumb-dark\" : \"sp-thumb-el sp-thumb-light\";\n                c += (tinycolor.equals(color, current)) ? \" sp-thumb-active\" : \"\";\n                var formattedString = tiny.toString(opts.preferredFormat || \"rgb\");\n                var swatchStyle = rgbaSupport ? (\"background-color:\" + tiny.toRgbString()) : \"filter:\" + tiny.toFilter();\n                html.push('<span title=\"' + formattedString + '\" data-color=\"' + tiny.toRgbString() + '\" class=\"' + c + '\"><span class=\"sp-thumb-inner\" style=\"' + swatchStyle + ';\"></span></span>');\n            } else {\n                var cls = 'sp-clear-display';\n                html.push($('<div />')\n                    .append($('<span data-color=\"\" style=\"background-color:transparent;\" class=\"' + cls + '\"></span>')\n                        .attr('title', opts.noColorSelectedText)\n                    )\n                    .html()\n                );\n            }\n        }\n        return \"<div class='sp-cf \" + className + \"'>\" + html.join('') + \"</div>\";\n    }\n\n    function hideAll() {\n        for (var i = 0; i < spectrums.length; i++) {\n            if (spectrums[i]) {\n                spectrums[i].hide();\n            }\n        }\n    }\n\n    function instanceOptions(o, callbackContext) {\n        var opts = $.extend({}, defaultOpts, o);\n        opts.callbacks = {\n            'move': bind(opts.move, callbackContext),\n            'change': bind(opts.change, callbackContext),\n            'show': bind(opts.show, callbackContext),\n            'hide': bind(opts.hide, callbackContext),\n            'beforeShow': bind(opts.beforeShow, callbackContext)\n        };\n\n        return opts;\n    }\n\n    function spectrum(element, o) {\n\n        var opts = instanceOptions(o, element),\n            flat = opts.flat,\n            showSelectionPalette = opts.showSelectionPalette,\n            localStorageKey = opts.localStorageKey,\n            theme = opts.theme,\n            callbacks = opts.callbacks,\n            resize = throttle(reflow, 10),\n            visible = false,\n            isDragging = false,\n            dragWidth = 0,\n            dragHeight = 0,\n            dragHelperHeight = 0,\n            slideHeight = 0,\n            slideWidth = 0,\n            alphaWidth = 0,\n            alphaSlideHelperWidth = 0,\n            slideHelperHeight = 0,\n            currentHue = 0,\n            currentSaturation = 0,\n            currentValue = 0,\n            currentAlpha = 1,\n            palette = [],\n            paletteArray = [],\n            paletteLookup = {},\n            selectionPalette = opts.selectionPalette.slice(0),\n            maxSelectionSize = opts.maxSelectionSize,\n            draggingClass = \"sp-dragging\",\n            shiftMovementDirection = null;\n\n        var doc = element.ownerDocument,\n            body = doc.body,\n            boundElement = $(element),\n            disabled = false,\n            container = $(markup, doc).addClass(theme),\n            pickerContainer = container.find(\".sp-picker-container\"),\n            dragger = container.find(\".sp-color\"),\n            dragHelper = container.find(\".sp-dragger\"),\n            slider = container.find(\".sp-hue\"),\n            slideHelper = container.find(\".sp-slider\"),\n            alphaSliderInner = container.find(\".sp-alpha-inner\"),\n            alphaSlider = container.find(\".sp-alpha\"),\n            alphaSlideHelper = container.find(\".sp-alpha-handle\"),\n            textInput = container.find(\".sp-input\"),\n            paletteContainer = container.find(\".sp-palette\"),\n            initialColorContainer = container.find(\".sp-initial\"),\n            cancelButton = container.find(\".sp-cancel\"),\n            clearButton = container.find(\".sp-clear\"),\n            chooseButton = container.find(\".sp-choose\"),\n            toggleButton = container.find(\".sp-palette-toggle\"),\n            isInput = boundElement.is(\"input\"),\n            isInputTypeColor = isInput && boundElement.attr(\"type\") === \"color\" && inputTypeColorSupport(),\n            shouldReplace = isInput && !flat,\n            replacer = (shouldReplace) ? $(replaceInput).addClass(theme).addClass(opts.className).addClass(opts.replacerClassName) : $([]),\n            offsetElement = (shouldReplace) ? replacer : boundElement,\n            previewElement = replacer.find(\".sp-preview-inner\"),\n            initialColor = opts.color || (isInput && boundElement.val()),\n            colorOnShow = false,\n            currentPreferredFormat = opts.preferredFormat,\n            clickoutFiresChange = !opts.showButtons || opts.clickoutFiresChange,\n            isEmpty = !initialColor,\n            allowEmpty = opts.allowEmpty && !isInputTypeColor;\n\n        function applyOptions() {\n\n            if (opts.showPaletteOnly) {\n                opts.showPalette = true;\n            }\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n\n            if (opts.palette) {\n                palette = opts.palette.slice(0);\n                paletteArray = $.isArray(palette[0]) ? palette : [palette];\n                paletteLookup = {};\n                for (var i = 0; i < paletteArray.length; i++) {\n                    for (var j = 0; j < paletteArray[i].length; j++) {\n                        var rgb = tinycolor(paletteArray[i][j]).toRgbString();\n                        paletteLookup[rgb] = true;\n                    }\n                }\n            }\n\n            container.toggleClass(\"sp-flat\", flat);\n            container.toggleClass(\"sp-input-disabled\", !opts.showInput);\n            container.toggleClass(\"sp-alpha-enabled\", opts.showAlpha);\n            container.toggleClass(\"sp-clear-enabled\", allowEmpty);\n            container.toggleClass(\"sp-buttons-disabled\", !opts.showButtons);\n            container.toggleClass(\"sp-palette-buttons-disabled\", !opts.togglePaletteOnly);\n            container.toggleClass(\"sp-palette-disabled\", !opts.showPalette);\n            container.toggleClass(\"sp-palette-only\", opts.showPaletteOnly);\n            container.toggleClass(\"sp-initial-disabled\", !opts.showInitial);\n            container.addClass(opts.className).addClass(opts.containerClassName);\n\n            reflow();\n        }\n\n        function initialize() {\n\n            if (IE) {\n                container.find(\"*:not(input)\").attr(\"unselectable\", \"on\");\n            }\n\n            applyOptions();\n\n            if (shouldReplace) {\n                boundElement.after(replacer).hide();\n            }\n\n            if (!allowEmpty) {\n                clearButton.hide();\n            }\n\n            if (flat) {\n                boundElement.after(container).hide();\n            }\n            else {\n\n                var appendTo = opts.appendTo === \"parent\" ? boundElement.parent() : $(opts.appendTo);\n                if (appendTo.length !== 1) {\n                    appendTo = $(\"body\");\n                }\n\n                appendTo.append(container);\n            }\n\n            updateSelectionPaletteFromStorage();\n\n            offsetElement.on(\"click.spectrum touchstart.spectrum\", function (e) {\n                if (!disabled) {\n                    toggle();\n                }\n\n                e.stopPropagation();\n\n                if (!$(e.target).is(\"input\")) {\n                    e.preventDefault();\n                }\n            });\n\n            if(boundElement.is(\":disabled\") || (opts.disabled === true)) {\n                disable();\n            }\n\n            // Prevent clicks from bubbling up to document.  This would cause it to be hidden.\n            container.click(stopPropagation);\n\n            // Handle user typed input\n            textInput.change(setFromTextInput);\n            textInput.on(\"paste\", function () {\n                setTimeout(setFromTextInput, 1);\n            });\n            textInput.keydown(function (e) { if (e.keyCode == 13) { setFromTextInput(); } });\n\n            cancelButton.text(opts.cancelText);\n            cancelButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                revert();\n                hide();\n            });\n\n            clearButton.attr(\"title\", opts.clearText);\n            clearButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                isEmpty = true;\n                move();\n\n                if(flat) {\n                    //for the flat style, this is a change event\n                    updateOriginalInput(true);\n                }\n            });\n\n            chooseButton.text(opts.chooseText);\n            chooseButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                if (IE && textInput.is(\":focus\")) {\n                    textInput.trigger('change');\n                }\n\n                if (isValid()) {\n                    updateOriginalInput(true);\n                    hide();\n                }\n            });\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n            toggleButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                opts.showPaletteOnly = !opts.showPaletteOnly;\n\n                // To make sure the Picker area is drawn on the right, next to the\n                // Palette area (and not below the palette), first move the Palette\n                // to the left to make space for the picker, plus 5px extra.\n                // The 'applyOptions' function puts the whole container back into place\n                // and takes care of the button-text and the sp-palette-only CSS class.\n                if (!opts.showPaletteOnly && !flat) {\n                    container.css('left', '-=' + (pickerContainer.outerWidth(true) + 5));\n                }\n                applyOptions();\n            });\n\n            draggable(alphaSlider, function (dragX, dragY, e) {\n                currentAlpha = (dragX / alphaWidth);\n                isEmpty = false;\n                if (e.shiftKey) {\n                    currentAlpha = Math.round(currentAlpha * 10) / 10;\n                }\n\n                move();\n            }, dragStart, dragStop);\n\n            draggable(slider, function (dragX, dragY) {\n                currentHue = parseFloat(dragY / slideHeight);\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n                move();\n            }, dragStart, dragStop);\n\n            draggable(dragger, function (dragX, dragY, e) {\n\n                // shift+drag should snap the movement to either the x or y axis.\n                if (!e.shiftKey) {\n                    shiftMovementDirection = null;\n                }\n                else if (!shiftMovementDirection) {\n                    var oldDragX = currentSaturation * dragWidth;\n                    var oldDragY = dragHeight - (currentValue * dragHeight);\n                    var furtherFromX = Math.abs(dragX - oldDragX) > Math.abs(dragY - oldDragY);\n\n                    shiftMovementDirection = furtherFromX ? \"x\" : \"y\";\n                }\n\n                var setSaturation = !shiftMovementDirection || shiftMovementDirection === \"x\";\n                var setValue = !shiftMovementDirection || shiftMovementDirection === \"y\";\n\n                if (setSaturation) {\n                    currentSaturation = parseFloat(dragX / dragWidth);\n                }\n                if (setValue) {\n                    currentValue = parseFloat((dragHeight - dragY) / dragHeight);\n                }\n\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n\n                move();\n\n            }, dragStart, dragStop);\n\n            if (!!initialColor) {\n                set(initialColor);\n\n                // In case color was black - update the preview UI and set the format\n                // since the set function will not run (default color is black).\n                updateUI();\n                currentPreferredFormat = opts.preferredFormat || tinycolor(initialColor).format;\n\n                addColorToSelectionPalette(initialColor);\n            }\n            else {\n                updateUI();\n            }\n\n            if (flat) {\n                show();\n            }\n\n            function paletteElementClick(e) {\n                if (e.data && e.data.ignore) {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n                }\n                else {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n\n                    updateOriginalInput(true);\n                    if (opts.hideAfterPaletteSelect) {\n                        hide();\n                    }\n                }\n\n                return false;\n            }\n\n            var paletteEvent = IE ? \"mousedown.spectrum\" : \"click.spectrum touchstart.spectrum\";\n            paletteContainer.on(paletteEvent, \".sp-thumb-el\", paletteElementClick);\n            initialColorContainer.on(paletteEvent, \".sp-thumb-el:nth-child(1)\", { ignore: true }, paletteElementClick);\n        }\n\n        function updateSelectionPaletteFromStorage() {\n\n            if (localStorageKey && window.localStorage) {\n\n                // Migrate old palettes over to new format.  May want to remove this eventually.\n                try {\n                    var oldPalette = window.localStorage[localStorageKey].split(\",#\");\n                    if (oldPalette.length > 1) {\n                        delete window.localStorage[localStorageKey];\n                        $.each(oldPalette, function(i, c) {\n                            addColorToSelectionPalette(c);\n                        });\n                    }\n                }\n                catch(e) { }\n\n                try {\n                    selectionPalette = window.localStorage[localStorageKey].split(\";\");\n                }\n                catch (e) { }\n            }\n        }\n\n        function addColorToSelectionPalette(color) {\n            if (showSelectionPalette) {\n                var rgb = tinycolor(color).toRgbString();\n                if (!paletteLookup[rgb] && $.inArray(rgb, selectionPalette) === -1) {\n                    selectionPalette.push(rgb);\n                    while(selectionPalette.length > maxSelectionSize) {\n                        selectionPalette.shift();\n                    }\n                }\n\n                if (localStorageKey && window.localStorage) {\n                    try {\n                        window.localStorage[localStorageKey] = selectionPalette.join(\";\");\n                    }\n                    catch(e) { }\n                }\n            }\n        }\n\n        function getUniqueSelectionPalette() {\n            var unique = [];\n            if (opts.showPalette) {\n                for (var i = 0; i < selectionPalette.length; i++) {\n                    var rgb = tinycolor(selectionPalette[i]).toRgbString();\n\n                    if (!paletteLookup[rgb]) {\n                        unique.push(selectionPalette[i]);\n                    }\n                }\n            }\n\n            return unique.reverse().slice(0, opts.maxSelectionSize);\n        }\n\n        function drawPalette() {\n\n            var currentColor = get();\n\n            var html = $.map(paletteArray, function (palette, i) {\n                return paletteTemplate(palette, currentColor, \"sp-palette-row sp-palette-row-\" + i, opts);\n            });\n\n            updateSelectionPaletteFromStorage();\n\n            if (selectionPalette) {\n                html.push(paletteTemplate(getUniqueSelectionPalette(), currentColor, \"sp-palette-row sp-palette-row-selection\", opts));\n            }\n\n            paletteContainer.html(html.join(\"\"));\n        }\n\n        function drawInitial() {\n            if (opts.showInitial) {\n                var initial = colorOnShow;\n                var current = get();\n                initialColorContainer.html(paletteTemplate([initial, current], current, \"sp-palette-row-initial\", opts));\n            }\n        }\n\n        function dragStart() {\n            if (dragHeight <= 0 || dragWidth <= 0 || slideHeight <= 0) {\n                reflow();\n            }\n            isDragging = true;\n            container.addClass(draggingClass);\n            shiftMovementDirection = null;\n            boundElement.trigger('dragstart.spectrum', [ get() ]);\n        }\n\n        function dragStop() {\n            isDragging = false;\n            container.removeClass(draggingClass);\n            boundElement.trigger('dragstop.spectrum', [ get() ]);\n        }\n\n        function setFromTextInput() {\n\n            var value = textInput.val();\n\n            if ((value === null || value === \"\") && allowEmpty) {\n                set(null);\n                move();\n                updateOriginalInput();\n            }\n            else {\n                var tiny = tinycolor(value);\n                if (tiny.isValid()) {\n                    set(tiny);\n                    move();\n                    updateOriginalInput(true);\n                }\n                else {\n                    textInput.addClass(\"sp-validation-error\");\n                }\n            }\n        }\n\n        function toggle() {\n            if (visible) {\n                hide();\n            }\n            else {\n                show();\n            }\n        }\n\n        function show() {\n            var event = $.Event('beforeShow.spectrum');\n\n            if (visible) {\n                reflow();\n                return;\n            }\n\n            boundElement.trigger(event, [ get() ]);\n\n            if (callbacks.beforeShow(get()) === false || event.isDefaultPrevented()) {\n                return;\n            }\n\n            hideAll();\n            visible = true;\n\n            $(doc).on(\"keydown.spectrum\", onkeydown);\n            $(doc).on(\"click.spectrum\", clickout);\n            $(window).on(\"resize.spectrum\", resize);\n            replacer.addClass(\"sp-active\");\n            container.removeClass(\"sp-hidden\");\n\n            reflow();\n            updateUI();\n\n            colorOnShow = get();\n\n            drawInitial();\n            callbacks.show(colorOnShow);\n            boundElement.trigger('show.spectrum', [ colorOnShow ]);\n        }\n\n        function onkeydown(e) {\n            // Close on ESC\n            if (e.keyCode === 27) {\n                hide();\n            }\n        }\n\n        function clickout(e) {\n            // Return on right click.\n            if (e.button == 2) { return; }\n\n            // If a drag event was happening during the mouseup, don't hide\n            // on click.\n            if (isDragging) { return; }\n\n            if (clickoutFiresChange) {\n                updateOriginalInput(true);\n            }\n            else {\n                revert();\n            }\n            hide();\n        }\n\n        function hide() {\n            // Return if hiding is unnecessary\n            if (!visible || flat) { return; }\n            visible = false;\n\n            $(doc).off(\"keydown.spectrum\", onkeydown);\n            $(doc).off(\"click.spectrum\", clickout);\n            $(window).off(\"resize.spectrum\", resize);\n\n            replacer.removeClass(\"sp-active\");\n            container.addClass(\"sp-hidden\");\n\n            callbacks.hide(get());\n            boundElement.trigger('hide.spectrum', [ get() ]);\n        }\n\n        function revert() {\n            set(colorOnShow, true);\n            updateOriginalInput(true);\n        }\n\n        function set(color, ignoreFormatChange) {\n            if (tinycolor.equals(color, get())) {\n                // Update UI just in case a validation error needs\n                // to be cleared.\n                updateUI();\n                return;\n            }\n\n            var newColor, newHsv;\n            if (!color && allowEmpty) {\n                isEmpty = true;\n            } else {\n                isEmpty = false;\n                newColor = tinycolor(color);\n                newHsv = newColor.toHsv();\n\n                currentHue = (newHsv.h % 360) / 360;\n                currentSaturation = newHsv.s;\n                currentValue = newHsv.v;\n                currentAlpha = newHsv.a;\n            }\n            updateUI();\n\n            if (newColor && newColor.isValid() && !ignoreFormatChange) {\n                currentPreferredFormat = opts.preferredFormat || newColor.getFormat();\n            }\n        }\n\n        function get(opts) {\n            opts = opts || { };\n\n            if (allowEmpty && isEmpty) {\n                return null;\n            }\n\n            return tinycolor.fromRatio({\n                h: currentHue,\n                s: currentSaturation,\n                v: currentValue,\n                a: Math.round(currentAlpha * 1000) / 1000\n            }, { format: opts.format || currentPreferredFormat });\n        }\n\n        function isValid() {\n            return !textInput.hasClass(\"sp-validation-error\");\n        }\n\n        function move() {\n            updateUI();\n\n            callbacks.move(get());\n            boundElement.trigger('move.spectrum', [ get() ]);\n        }\n\n        function updateUI() {\n\n            textInput.removeClass(\"sp-validation-error\");\n\n            updateHelperLocations();\n\n            // Update dragger background color (gradients take care of saturation and value).\n            var flatColor = tinycolor.fromRatio({ h: currentHue, s: 1, v: 1 });\n            dragger.css(\"background-color\", flatColor.toHexString());\n\n            // Get a format that alpha will be included in (hex and names ignore alpha)\n            var format = currentPreferredFormat;\n            if (currentAlpha < 1 && !(currentAlpha === 0 && format === \"name\")) {\n                if (format === \"hex\" || format === \"hex3\" || format === \"hex6\" || format === \"name\") {\n                    format = \"rgb\";\n                }\n            }\n\n            var realColor = get({ format: format }),\n                displayColor = '';\n\n            //reset background info for preview element\n            previewElement.removeClass(\"sp-clear-display\");\n            previewElement.css('background-color', 'transparent');\n\n            if (!realColor && allowEmpty) {\n                // Update the replaced elements background with icon indicating no color selection\n                previewElement.addClass(\"sp-clear-display\");\n            }\n            else {\n                var realHex = realColor.toHexString(),\n                    realRgb = realColor.toRgbString();\n\n                // Update the replaced elements background color (with actual selected color)\n                if (rgbaSupport || realColor.alpha === 1) {\n                    previewElement.css(\"background-color\", realRgb);\n                }\n                else {\n                    previewElement.css(\"background-color\", \"transparent\");\n                    previewElement.css(\"filter\", realColor.toFilter());\n                }\n\n                if (opts.showAlpha) {\n                    var rgb = realColor.toRgb();\n                    rgb.a = 0;\n                    var realAlpha = tinycolor(rgb).toRgbString();\n                    var gradient = \"linear-gradient(left, \" + realAlpha + \", \" + realHex + \")\";\n\n                    if (IE) {\n                        alphaSliderInner.css(\"filter\", tinycolor(realAlpha).toFilter({ gradientType: 1 }, realHex));\n                    }\n                    else {\n                        alphaSliderInner.css(\"background\", \"-webkit-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-moz-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-ms-\" + gradient);\n                        // Use current syntax gradient on unprefixed property.\n                        alphaSliderInner.css(\"background\",\n                            \"linear-gradient(to right, \" + realAlpha + \", \" + realHex + \")\");\n                    }\n                }\n\n                displayColor = realColor.toString(format);\n            }\n\n            // Update the text entry input as it changes happen\n            if (opts.showInput) {\n                textInput.val(displayColor);\n            }\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            drawInitial();\n        }\n\n        function updateHelperLocations() {\n            var s = currentSaturation;\n            var v = currentValue;\n\n            if(allowEmpty && isEmpty) {\n                //if selected color is empty, hide the helpers\n                alphaSlideHelper.hide();\n                slideHelper.hide();\n                dragHelper.hide();\n            }\n            else {\n                //make sure helpers are visible\n                alphaSlideHelper.show();\n                slideHelper.show();\n                dragHelper.show();\n\n                // Where to show the little circle in that displays your current selected color\n                var dragX = s * dragWidth;\n                var dragY = dragHeight - (v * dragHeight);\n                dragX = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragWidth - dragHelperHeight, dragX - dragHelperHeight)\n                );\n                dragY = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragHeight - dragHelperHeight, dragY - dragHelperHeight)\n                );\n                dragHelper.css({\n                    \"top\": dragY + \"px\",\n                    \"left\": dragX + \"px\"\n                });\n\n                var alphaX = currentAlpha * alphaWidth;\n                alphaSlideHelper.css({\n                    \"left\": (alphaX - (alphaSlideHelperWidth / 2)) + \"px\"\n                });\n\n                // Where to show the bar that displays your current selected hue\n                var slideY = (currentHue) * slideHeight;\n                slideHelper.css({\n                    \"top\": (slideY - slideHelperHeight) + \"px\"\n                });\n            }\n        }\n\n        function updateOriginalInput(fireCallback) {\n            var color = get(),\n                displayColor = '',\n                hasChanged = !tinycolor.equals(color, colorOnShow);\n\n            if (color) {\n                displayColor = color.toString(currentPreferredFormat);\n                // Update the selection palette with the current color\n                addColorToSelectionPalette(color);\n            }\n\n            if (isInput) {\n                boundElement.val(displayColor);\n            }\n\n            if (fireCallback && hasChanged) {\n                callbacks.change(color);\n                boundElement.trigger('change', [ color ]);\n            }\n        }\n\n        function reflow() {\n            if (!visible) {\n                return; // Calculations would be useless and wouldn't be reliable anyways\n            }\n            dragWidth = dragger.width();\n            dragHeight = dragger.height();\n            dragHelperHeight = dragHelper.height();\n            slideWidth = slider.width();\n            slideHeight = slider.height();\n            slideHelperHeight = slideHelper.height();\n            alphaWidth = alphaSlider.width();\n            alphaSlideHelperWidth = alphaSlideHelper.width();\n\n            if (!flat) {\n                container.css(\"position\", \"absolute\");\n                if (opts.offset) {\n                    container.offset(opts.offset);\n                } else {\n                    container.offset(getOffset(container, offsetElement));\n                }\n            }\n\n            updateHelperLocations();\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            boundElement.trigger('reflow.spectrum');\n        }\n\n        function destroy() {\n            boundElement.show();\n            offsetElement.off(\"click.spectrum touchstart.spectrum\");\n            container.remove();\n            replacer.remove();\n            spectrums[spect.id] = null;\n        }\n\n        function option(optionName, optionValue) {\n            if (optionName === undefined) {\n                return $.extend({}, opts);\n            }\n            if (optionValue === undefined) {\n                return opts[optionName];\n            }\n\n            opts[optionName] = optionValue;\n\n            if (optionName === \"preferredFormat\") {\n                currentPreferredFormat = opts.preferredFormat;\n            }\n            applyOptions();\n        }\n\n        function enable() {\n            disabled = false;\n            boundElement.attr(\"disabled\", false);\n            offsetElement.removeClass(\"sp-disabled\");\n        }\n\n        function disable() {\n            hide();\n            disabled = true;\n            boundElement.attr(\"disabled\", true);\n            offsetElement.addClass(\"sp-disabled\");\n        }\n\n        function setOffset(coord) {\n            opts.offset = coord;\n            reflow();\n        }\n\n        initialize();\n\n        var spect = {\n            show: show,\n            hide: hide,\n            toggle: toggle,\n            reflow: reflow,\n            option: option,\n            enable: enable,\n            disable: disable,\n            offset: setOffset,\n            set: function (c) {\n                set(c);\n                updateOriginalInput();\n            },\n            get: get,\n            destroy: destroy,\n            container: container\n        };\n\n        spect.id = spectrums.push(spect) - 1;\n\n        return spect;\n    }\n\n    /**\n     * checkOffset - get the offset below/above and left/right element depending on screen position\n     * Thanks https://github.com/jquery/jquery-ui/blob/master/ui/jquery.ui.datepicker.js\n     */\n    function getOffset(picker, input) {\n        var extraY = 0;\n        var dpWidth = picker.outerWidth();\n        var dpHeight = picker.outerHeight();\n        var inputHeight = input.outerHeight();\n        var doc = picker[0].ownerDocument;\n        var docElem = doc.documentElement;\n        var viewWidth = docElem.clientWidth + $(doc).scrollLeft();\n        var viewHeight = docElem.clientHeight + $(doc).scrollTop();\n        var offset = input.offset();\n        var offsetLeft = offset.left;\n        var offsetTop = offset.top;\n\n        offsetTop += inputHeight;\n\n        offsetLeft -=\n            Math.min(offsetLeft, (offsetLeft + dpWidth > viewWidth && viewWidth > dpWidth) ?\n                Math.abs(offsetLeft + dpWidth - viewWidth) : 0);\n\n        offsetTop -=\n            Math.min(offsetTop, ((offsetTop + dpHeight > viewHeight && viewHeight > dpHeight) ?\n                Math.abs(dpHeight + inputHeight - extraY) : extraY));\n\n        return {\n            top: offsetTop,\n            bottom: offset.bottom,\n            left: offsetLeft,\n            right: offset.right,\n            width: offset.width,\n            height: offset.height\n        };\n    }\n\n    /**\n     * noop - do nothing\n     */\n    function noop() {\n\n    }\n\n    /**\n     * stopPropagation - makes the code only doing this a little easier to read in line\n     */\n    function stopPropagation(e) {\n        e.stopPropagation();\n    }\n\n    /**\n     * Create a function bound to a given object\n     * Thanks to underscore.js\n     */\n    function bind(func, obj) {\n        var slice = Array.prototype.slice;\n        var args = slice.call(arguments, 2);\n        return function () {\n            return func.apply(obj, args.concat(slice.call(arguments)));\n        };\n    }\n\n    /**\n     * Lightweight drag helper.  Handles containment within the element, so that\n     * when dragging, the x is within [0,element.width] and y is within [0,element.height]\n     */\n    function draggable(element, onmove, onstart, onstop) {\n        onmove = onmove || function () { };\n        onstart = onstart || function () { };\n        onstop = onstop || function () { };\n        var doc = document;\n        var dragging = false;\n        var offset = {};\n        var maxHeight = 0;\n        var maxWidth = 0;\n        var hasTouch = ('ontouchstart' in window);\n\n        var duringDragEvents = {};\n        duringDragEvents[\"selectstart\"] = prevent;\n        duringDragEvents[\"dragstart\"] = prevent;\n        duringDragEvents[\"touchmove mousemove\"] = move;\n        duringDragEvents[\"touchend mouseup\"] = stop;\n\n        function prevent(e) {\n            if (e.stopPropagation) {\n                e.stopPropagation();\n            }\n            if (e.preventDefault) {\n                e.preventDefault();\n            }\n            e.returnValue = false;\n        }\n\n        function move(e) {\n            if (dragging) {\n                // Mouseup happened outside of window\n                if (IE && doc.documentMode < 9 && !e.button) {\n                    return stop();\n                }\n\n                var t0 = e.originalEvent && e.originalEvent.touches && e.originalEvent.touches[0];\n                var pageX = t0 && t0.pageX || e.pageX;\n                var pageY = t0 && t0.pageY || e.pageY;\n\n                var dragX = Math.max(0, Math.min(pageX - offset.left, maxWidth));\n                var dragY = Math.max(0, Math.min(pageY - offset.top, maxHeight));\n\n                if (hasTouch) {\n                    // Stop scrolling in iOS\n                    prevent(e);\n                }\n\n                onmove.apply(element, [dragX, dragY, e]);\n            }\n        }\n\n        function start(e) {\n            var rightclick = (e.which) ? (e.which == 3) : (e.button == 2);\n\n            if (!rightclick && !dragging) {\n                if (onstart.apply(element, arguments) !== false) {\n                    dragging = true;\n                    maxHeight = $(element).height();\n                    maxWidth = $(element).width();\n                    offset = $(element).offset();\n\n                    $(doc).on(duringDragEvents);\n                    $(doc.body).addClass(\"sp-dragging\");\n\n                    move(e);\n\n                    prevent(e);\n                }\n            }\n        }\n\n        function stop() {\n            if (dragging) {\n                $(doc).off(duringDragEvents);\n                $(doc.body).removeClass(\"sp-dragging\");\n\n                // Wait a tick before notifying observers to allow the click event\n                // to fire in Chrome.\n                setTimeout(function() {\n                    onstop.apply(element, arguments);\n                }, 0);\n            }\n            dragging = false;\n        }\n\n        $(element).on(\"touchstart mousedown\", start);\n    }\n\n    function throttle(func, wait, debounce) {\n        var timeout;\n        return function () {\n            var context = this, args = arguments;\n            var throttler = function () {\n                timeout = null;\n                func.apply(context, args);\n            };\n            if (debounce) clearTimeout(timeout);\n            if (debounce || !timeout) timeout = setTimeout(throttler, wait);\n        };\n    }\n\n    function inputTypeColorSupport() {\n        return $.fn.spectrum.inputTypeColorSupport();\n    }\n\n    /**\n     * Define a jQuery plugin\n     */\n    var dataID = \"spectrum.id\";\n    $.fn.spectrum = function (opts, extra) {\n\n        if (typeof opts == \"string\") {\n\n            var returnValue = this;\n            var args = Array.prototype.slice.call( arguments, 1 );\n\n            this.each(function () {\n                var spect = spectrums[$(this).data(dataID)];\n                if (spect) {\n                    var method = spect[opts];\n                    if (!method) {\n                        throw new Error( \"Spectrum: no such method: '\" + opts + \"'\" );\n                    }\n\n                    if (opts == \"get\") {\n                        returnValue = spect.get();\n                    }\n                    else if (opts == \"container\") {\n                        returnValue = spect.container;\n                    }\n                    else if (opts == \"option\") {\n                        returnValue = spect.option.apply(spect, args);\n                    }\n                    else if (opts == \"destroy\") {\n                        spect.destroy();\n                        $(this).removeData(dataID);\n                    }\n                    else {\n                        method.apply(spect, args);\n                    }\n                }\n            });\n\n            return returnValue;\n        }\n\n        // Initializing a new instance of spectrum\n        return this.spectrum(\"destroy\").each(function () {\n            var options = $.extend({}, $(this).data(), opts);\n            var spect = spectrum(this, options);\n            $(this).data(dataID, spect.id);\n        });\n    };\n\n    $.fn.spectrum.load = true;\n    $.fn.spectrum.loadOpts = {};\n    $.fn.spectrum.draggable = draggable;\n    $.fn.spectrum.defaults = defaultOpts;\n    $.fn.spectrum.inputTypeColorSupport = function inputTypeColorSupport() {\n        if (typeof inputTypeColorSupport._cachedResult === \"undefined\") {\n            var colorInput = $(\"<input type='color'/>\")[0]; // if color element is supported, value will default to not null\n            inputTypeColorSupport._cachedResult = colorInput.type === \"color\" && colorInput.value !== \"\";\n        }\n        return inputTypeColorSupport._cachedResult;\n    };\n\n    $.spectrum = { };\n    $.spectrum.localization = { };\n    $.spectrum.palettes = { };\n\n    $.fn.spectrum.processNativeColorInputs = function () {\n        var colorInputs = $(\"input[type=color]\");\n        if (colorInputs.length && !inputTypeColorSupport()) {\n            colorInputs.spectrum({\n                preferredFormat: \"hex6\"\n            });\n        }\n    };\n\n    // TinyColor v1.1.2\n    // https://github.com/bgrins/TinyColor\n    // Brian Grinstead, MIT License\n\n    (function() {\n\n        var trimLeft = /^[\\s,#]+/,\n            trimRight = /\\s+$/,\n            tinyCounter = 0,\n            math = Math,\n            mathRound = math.round,\n            mathMin = math.min,\n            mathMax = math.max,\n            mathRandom = math.random;\n\n        var tinycolor = function(color, opts) {\n\n            color = (color) ? color : '';\n            opts = opts || { };\n\n            // If input is already a tinycolor, return itself\n            if (color instanceof tinycolor) {\n                return color;\n            }\n            // If we are called as a function, call using new instead\n            if (!(this instanceof tinycolor)) {\n                return new tinycolor(color, opts);\n            }\n\n            var rgb = inputToRGB(color);\n            this._originalInput = color;\n            this._r = rgb.r;\n            this._g = rgb.g;\n            this._b = rgb.b;\n            this._a = rgb.a;\n            this._roundA = mathRound(1000 * this._a) / 1000;\n            this._format = opts.format || rgb.format;\n            this._gradientType = opts.gradientType;\n\n            // Don't let the range of [0,255] come back in [0,1].\n            // Potentially lose a little bit of precision here, but will fix issues where\n            // .5 gets interpreted as half of the total, instead of half of 1\n            // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n            if (this._r < 1) { this._r = mathRound(this._r); }\n            if (this._g < 1) { this._g = mathRound(this._g); }\n            if (this._b < 1) { this._b = mathRound(this._b); }\n\n            this._ok = rgb.ok;\n            this._tc_id = tinyCounter++;\n        };\n\n        tinycolor.prototype = {\n            isDark: function() {\n                return this.getBrightness() < 128;\n            },\n            isLight: function() {\n                return !this.isDark();\n            },\n            isValid: function() {\n                return this._ok;\n            },\n            getOriginalInput: function() {\n                return this._originalInput;\n            },\n            getFormat: function() {\n                return this._format;\n            },\n            getAlpha: function() {\n                return this._a;\n            },\n            getBrightness: function() {\n                var rgb = this.toRgb();\n                return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n            },\n            setAlpha: function(value) {\n                this._a = boundAlpha(value);\n                this._roundA = mathRound(1000 * this._a) / 1000;\n                return this;\n            },\n            toHsv: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };\n            },\n            toHsvString: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);\n                return (this._a == 1) ?\n                    \"hsv(\"  + h + \", \" + s + \"%, \" + v + \"%)\" :\n                    \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \"+ this._roundA + \")\";\n            },\n            toHsl: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };\n            },\n            toHslString: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                var h = mathRound(hsl.h * 360), s = mathRound(hsl.s * 100), l = mathRound(hsl.l * 100);\n                return (this._a == 1) ?\n                    \"hsl(\"  + h + \", \" + s + \"%, \" + l + \"%)\" :\n                    \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \"+ this._roundA + \")\";\n            },\n            toHex: function(allow3Char) {\n                return rgbToHex(this._r, this._g, this._b, allow3Char);\n            },\n            toHexString: function(allow3Char) {\n                return '#' + this.toHex(allow3Char);\n            },\n            toHex8: function() {\n                return rgbaToHex(this._r, this._g, this._b, this._a);\n            },\n            toHex8String: function() {\n                return '#' + this.toHex8();\n            },\n            toRgb: function() {\n                return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };\n            },\n            toRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \")\" :\n                    \"rgba(\" + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \", \" + this._roundA + \")\";\n            },\n            toPercentageRgb: function() {\n                return { r: mathRound(bound01(this._r, 255) * 100) + \"%\", g: mathRound(bound01(this._g, 255) * 100) + \"%\", b: mathRound(bound01(this._b, 255) * 100) + \"%\", a: this._a };\n            },\n            toPercentageRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%)\" :\n                    \"rgba(\" + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n            },\n            toName: function() {\n                if (this._a === 0) {\n                    return \"transparent\";\n                }\n\n                if (this._a < 1) {\n                    return false;\n                }\n\n                return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n            },\n            toFilter: function(secondColor) {\n                var hex8String = '#' + rgbaToHex(this._r, this._g, this._b, this._a);\n                var secondHex8String = hex8String;\n                var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n\n                if (secondColor) {\n                    var s = tinycolor(secondColor);\n                    secondHex8String = s.toHex8String();\n                }\n\n                return \"progid:DXImageTransform.Microsoft.gradient(\"+gradientType+\"startColorstr=\"+hex8String+\",endColorstr=\"+secondHex8String+\")\";\n            },\n            toString: function(format) {\n                var formatSet = !!format;\n                format = format || this._format;\n\n                var formattedString = false;\n                var hasAlpha = this._a < 1 && this._a >= 0;\n                var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"name\");\n\n                if (needsAlphaFormat) {\n                    // Special case for \"transparent\", all other non-alpha formats\n                    // will return rgba when there is transparency.\n                    if (format === \"name\" && this._a === 0) {\n                        return this.toName();\n                    }\n                    return this.toRgbString();\n                }\n                if (format === \"rgb\") {\n                    formattedString = this.toRgbString();\n                }\n                if (format === \"prgb\") {\n                    formattedString = this.toPercentageRgbString();\n                }\n                if (format === \"hex\" || format === \"hex6\") {\n                    formattedString = this.toHexString();\n                }\n                if (format === \"hex3\") {\n                    formattedString = this.toHexString(true);\n                }\n                if (format === \"hex8\") {\n                    formattedString = this.toHex8String();\n                }\n                if (format === \"name\") {\n                    formattedString = this.toName();\n                }\n                if (format === \"hsl\") {\n                    formattedString = this.toHslString();\n                }\n                if (format === \"hsv\") {\n                    formattedString = this.toHsvString();\n                }\n\n                return formattedString || this.toHexString();\n            },\n\n            _applyModification: function(fn, args) {\n                var color = fn.apply(null, [this].concat([].slice.call(args)));\n                this._r = color._r;\n                this._g = color._g;\n                this._b = color._b;\n                this.setAlpha(color._a);\n                return this;\n            },\n            lighten: function() {\n                return this._applyModification(lighten, arguments);\n            },\n            brighten: function() {\n                return this._applyModification(brighten, arguments);\n            },\n            darken: function() {\n                return this._applyModification(darken, arguments);\n            },\n            desaturate: function() {\n                return this._applyModification(desaturate, arguments);\n            },\n            saturate: function() {\n                return this._applyModification(saturate, arguments);\n            },\n            greyscale: function() {\n                return this._applyModification(greyscale, arguments);\n            },\n            spin: function() {\n                return this._applyModification(spin, arguments);\n            },\n\n            _applyCombination: function(fn, args) {\n                return fn.apply(null, [this].concat([].slice.call(args)));\n            },\n            analogous: function() {\n                return this._applyCombination(analogous, arguments);\n            },\n            complement: function() {\n                return this._applyCombination(complement, arguments);\n            },\n            monochromatic: function() {\n                return this._applyCombination(monochromatic, arguments);\n            },\n            splitcomplement: function() {\n                return this._applyCombination(splitcomplement, arguments);\n            },\n            triad: function() {\n                return this._applyCombination(triad, arguments);\n            },\n            tetrad: function() {\n                return this._applyCombination(tetrad, arguments);\n            }\n        };\n\n        // If input is an object, force 1 into \"1.0\" to handle ratios properly\n        // String input requires \"1.0\" as input, so 1 will be treated as 1\n        tinycolor.fromRatio = function(color, opts) {\n            if (typeof color == \"object\") {\n                var newColor = {};\n                for (var i in color) {\n                    if (color.hasOwnProperty(i)) {\n                        if (i === \"a\") {\n                            newColor[i] = color[i];\n                        }\n                        else {\n                            newColor[i] = convertToPercentage(color[i]);\n                        }\n                    }\n                }\n                color = newColor;\n            }\n\n            return tinycolor(color, opts);\n        };\n\n        // Given a string or object, convert that input to RGB\n        // Possible string inputs:\n        //\n        //     \"red\"\n        //     \"#f00\" or \"f00\"\n        //     \"#ff0000\" or \"ff0000\"\n        //     \"#ff000000\" or \"ff000000\"\n        //     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n        //     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n        //     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n        //     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n        //     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n        //     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n        //     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n        //\n        function inputToRGB(color) {\n\n            var rgb = { r: 0, g: 0, b: 0 };\n            var a = 1;\n            var ok = false;\n            var format = false;\n\n            if (typeof color == \"string\") {\n                color = stringInputToObject(color);\n            }\n\n            if (typeof color == \"object\") {\n                if (color.hasOwnProperty(\"r\") && color.hasOwnProperty(\"g\") && color.hasOwnProperty(\"b\")) {\n                    rgb = rgbToRgb(color.r, color.g, color.b);\n                    ok = true;\n                    format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"v\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.v = convertToPercentage(color.v);\n                    rgb = hsvToRgb(color.h, color.s, color.v);\n                    ok = true;\n                    format = \"hsv\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"l\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.l = convertToPercentage(color.l);\n                    rgb = hslToRgb(color.h, color.s, color.l);\n                    ok = true;\n                    format = \"hsl\";\n                }\n\n                if (color.hasOwnProperty(\"a\")) {\n                    a = color.a;\n                }\n            }\n\n            a = boundAlpha(a);\n\n            return {\n                ok: ok,\n                format: color.format || format,\n                r: mathMin(255, mathMax(rgb.r, 0)),\n                g: mathMin(255, mathMax(rgb.g, 0)),\n                b: mathMin(255, mathMax(rgb.b, 0)),\n                a: a\n            };\n        }\n\n\n        // Conversion Functions\n        // --------------------\n\n        // `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n        // <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n        // `rgbToRgb`\n        // Handle bounds / percentage checking to conform to CSS color spec\n        // <http://www.w3.org/TR/css3-color/>\n        // *Assumes:* r, g, b in [0, 255] or [0, 1]\n        // *Returns:* { r, g, b } in [0, 255]\n        function rgbToRgb(r, g, b){\n            return {\n                r: bound01(r, 255) * 255,\n                g: bound01(g, 255) * 255,\n                b: bound01(b, 255) * 255\n            };\n        }\n\n        // `rgbToHsl`\n        // Converts an RGB color value to HSL.\n        // *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n        // *Returns:* { h, s, l } in [0,1]\n        function rgbToHsl(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, l = (max + min) / 2;\n\n            if(max == min) {\n                h = s = 0; // achromatic\n            }\n            else {\n                var d = max - min;\n                s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n\n                h /= 6;\n            }\n\n            return { h: h, s: s, l: l };\n        }\n\n        // `hslToRgb`\n        // Converts an HSL color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hslToRgb(h, s, l) {\n            var r, g, b;\n\n            h = bound01(h, 360);\n            s = bound01(s, 100);\n            l = bound01(l, 100);\n\n            function hue2rgb(p, q, t) {\n                if(t < 0) t += 1;\n                if(t > 1) t -= 1;\n                if(t < 1/6) return p + (q - p) * 6 * t;\n                if(t < 1/2) return q;\n                if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n                return p;\n            }\n\n            if(s === 0) {\n                r = g = b = l; // achromatic\n            }\n            else {\n                var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n                var p = 2 * l - q;\n                r = hue2rgb(p, q, h + 1/3);\n                g = hue2rgb(p, q, h);\n                b = hue2rgb(p, q, h - 1/3);\n            }\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHsv`\n        // Converts an RGB color value to HSV\n        // *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n        // *Returns:* { h, s, v } in [0,1]\n        function rgbToHsv(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, v = max;\n\n            var d = max - min;\n            s = max === 0 ? 0 : d / max;\n\n            if(max == min) {\n                h = 0; // achromatic\n            }\n            else {\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n                h /= 6;\n            }\n            return { h: h, s: s, v: v };\n        }\n\n        // `hsvToRgb`\n        // Converts an HSV color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hsvToRgb(h, s, v) {\n\n            h = bound01(h, 360) * 6;\n            s = bound01(s, 100);\n            v = bound01(v, 100);\n\n            var i = math.floor(h),\n                f = h - i,\n                p = v * (1 - s),\n                q = v * (1 - f * s),\n                t = v * (1 - (1 - f) * s),\n                mod = i % 6,\n                r = [v, q, p, p, t, v][mod],\n                g = [t, v, v, q, p, p][mod],\n                b = [p, p, t, v, v, q][mod];\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHex`\n        // Converts an RGB color to hex\n        // Assumes r, g, and b are contained in the set [0, 255]\n        // Returns a 3 or 6 character hex\n        function rgbToHex(r, g, b, allow3Char) {\n\n            var hex = [\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            // Return a 3 character hex if possible\n            if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n                return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n            }\n\n            return hex.join(\"\");\n        }\n        // `rgbaToHex`\n        // Converts an RGBA color plus alpha transparency to hex\n        // Assumes r, g, b and a are contained in the set [0, 255]\n        // Returns an 8 character hex\n        function rgbaToHex(r, g, b, a) {\n\n            var hex = [\n                pad2(convertDecimalToHex(a)),\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            return hex.join(\"\");\n        }\n\n        // `equals`\n        // Can be called with any tinycolor input\n        tinycolor.equals = function (color1, color2) {\n            if (!color1 || !color2) { return false; }\n            return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n        };\n        tinycolor.random = function() {\n            return tinycolor.fromRatio({\n                r: mathRandom(),\n                g: mathRandom(),\n                b: mathRandom()\n            });\n        };\n\n\n        // Modification Functions\n        // ----------------------\n        // Thanks to less.js for some of the basics here\n        // <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n        function desaturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s -= amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function saturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s += amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function greyscale(color) {\n            return tinycolor(color).desaturate(100);\n        }\n\n        function lighten (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l += amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        function brighten(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var rgb = tinycolor(color).toRgb();\n            rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * - (amount / 100))));\n            rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * - (amount / 100))));\n            rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * - (amount / 100))));\n            return tinycolor(rgb);\n        }\n\n        function darken (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l -= amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        // Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n        // Values outside of this range will be wrapped into this range.\n        function spin(color, amount) {\n            var hsl = tinycolor(color).toHsl();\n            var hue = (mathRound(hsl.h) + amount) % 360;\n            hsl.h = hue < 0 ? 360 + hue : hue;\n            return tinycolor(hsl);\n        }\n\n        // Combination Functions\n        // ---------------------\n        // Thanks to jQuery xColor for some of the ideas behind these\n        // <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n        function complement(color) {\n            var hsl = tinycolor(color).toHsl();\n            hsl.h = (hsl.h + 180) % 360;\n            return tinycolor(hsl);\n        }\n\n        function triad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 120) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 240) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function tetrad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 90) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 180) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 270) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function splitcomplement(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l}),\n                tinycolor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l})\n            ];\n        }\n\n        function analogous(color, results, slices) {\n            results = results || 6;\n            slices = slices || 30;\n\n            var hsl = tinycolor(color).toHsl();\n            var part = 360 / slices;\n            var ret = [tinycolor(color)];\n\n            for (hsl.h = ((hsl.h - (part * results >> 1)) + 720) % 360; --results; ) {\n                hsl.h = (hsl.h + part) % 360;\n                ret.push(tinycolor(hsl));\n            }\n            return ret;\n        }\n\n        function monochromatic(color, results) {\n            results = results || 6;\n            var hsv = tinycolor(color).toHsv();\n            var h = hsv.h, s = hsv.s, v = hsv.v;\n            var ret = [];\n            var modification = 1 / results;\n\n            while (results--) {\n                ret.push(tinycolor({ h: h, s: s, v: v}));\n                v = (v + modification) % 1;\n            }\n\n            return ret;\n        }\n\n        // Utility Functions\n        // ---------------------\n\n        tinycolor.mix = function(color1, color2, amount) {\n            amount = (amount === 0) ? 0 : (amount || 50);\n\n            var rgb1 = tinycolor(color1).toRgb();\n            var rgb2 = tinycolor(color2).toRgb();\n\n            var p = amount / 100;\n            var w = p * 2 - 1;\n            var a = rgb2.a - rgb1.a;\n\n            var w1;\n\n            if (w * a == -1) {\n                w1 = w;\n            } else {\n                w1 = (w + a) / (1 + w * a);\n            }\n\n            w1 = (w1 + 1) / 2;\n\n            var w2 = 1 - w1;\n\n            var rgba = {\n                r: rgb2.r * w1 + rgb1.r * w2,\n                g: rgb2.g * w1 + rgb1.g * w2,\n                b: rgb2.b * w1 + rgb1.b * w2,\n                a: rgb2.a * p  + rgb1.a * (1 - p)\n            };\n\n            return tinycolor(rgba);\n        };\n\n\n        // Readability Functions\n        // ---------------------\n        // <http://www.w3.org/TR/AERT#color-contrast>\n\n        // `readability`\n        // Analyze the 2 colors and returns an object with the following properties:\n        //    `brightness`: difference in brightness between the two colors\n        //    `color`: difference in color/hue between the two colors\n        tinycolor.readability = function(color1, color2) {\n            var c1 = tinycolor(color1);\n            var c2 = tinycolor(color2);\n            var rgb1 = c1.toRgb();\n            var rgb2 = c2.toRgb();\n            var brightnessA = c1.getBrightness();\n            var brightnessB = c2.getBrightness();\n            var colorDiff = (\n                Math.max(rgb1.r, rgb2.r) - Math.min(rgb1.r, rgb2.r) +\n                Math.max(rgb1.g, rgb2.g) - Math.min(rgb1.g, rgb2.g) +\n                Math.max(rgb1.b, rgb2.b) - Math.min(rgb1.b, rgb2.b)\n            );\n\n            return {\n                brightness: Math.abs(brightnessA - brightnessB),\n                color: colorDiff\n            };\n        };\n\n        // `readable`\n        // http://www.w3.org/TR/AERT#color-contrast\n        // Ensure that foreground and background color combinations provide sufficient contrast.\n        // *Example*\n        //    tinycolor.isReadable(\"#000\", \"#111\") => false\n        tinycolor.isReadable = function(color1, color2) {\n            var readability = tinycolor.readability(color1, color2);\n            return readability.brightness > 125 && readability.color > 500;\n        };\n\n        // `mostReadable`\n        // Given a base color and a list of possible foreground or background\n        // colors for that base, returns the most readable color.\n        // *Example*\n        //    tinycolor.mostReadable(\"#123\", [\"#fff\", \"#000\"]) => \"#000\"\n        tinycolor.mostReadable = function(baseColor, colorList) {\n            var bestColor = null;\n            var bestScore = 0;\n            var bestIsReadable = false;\n            for (var i=0; i < colorList.length; i++) {\n\n                // We normalize both around the \"acceptable\" breaking point,\n                // but rank brightness constrast higher than hue.\n\n                var readability = tinycolor.readability(baseColor, colorList[i]);\n                var readable = readability.brightness > 125 && readability.color > 500;\n                var score = 3 * (readability.brightness / 125) + (readability.color / 500);\n\n                if ((readable && ! bestIsReadable) ||\n                    (readable && bestIsReadable && score > bestScore) ||\n                    ((! readable) && (! bestIsReadable) && score > bestScore)) {\n                    bestIsReadable = readable;\n                    bestScore = score;\n                    bestColor = tinycolor(colorList[i]);\n                }\n            }\n            return bestColor;\n        };\n\n\n        // Big List of Colors\n        // ------------------\n        // <http://www.w3.org/TR/css3-color/#svg-color>\n        var names = tinycolor.names = {\n            aliceblue: \"f0f8ff\",\n            antiquewhite: \"faebd7\",\n            aqua: \"0ff\",\n            aquamarine: \"7fffd4\",\n            azure: \"f0ffff\",\n            beige: \"f5f5dc\",\n            bisque: \"ffe4c4\",\n            black: \"000\",\n            blanchedalmond: \"ffebcd\",\n            blue: \"00f\",\n            blueviolet: \"8a2be2\",\n            brown: \"a52a2a\",\n            burlywood: \"deb887\",\n            burntsienna: \"ea7e5d\",\n            cadetblue: \"5f9ea0\",\n            chartreuse: \"7fff00\",\n            chocolate: \"d2691e\",\n            coral: \"ff7f50\",\n            cornflowerblue: \"6495ed\",\n            cornsilk: \"fff8dc\",\n            crimson: \"dc143c\",\n            cyan: \"0ff\",\n            darkblue: \"00008b\",\n            darkcyan: \"008b8b\",\n            darkgoldenrod: \"b8860b\",\n            darkgray: \"a9a9a9\",\n            darkgreen: \"006400\",\n            darkgrey: \"a9a9a9\",\n            darkkhaki: \"bdb76b\",\n            darkmagenta: \"8b008b\",\n            darkolivegreen: \"556b2f\",\n            darkorange: \"ff8c00\",\n            darkorchid: \"9932cc\",\n            darkred: \"8b0000\",\n            darksalmon: \"e9967a\",\n            darkseagreen: \"8fbc8f\",\n            darkslateblue: \"483d8b\",\n            darkslategray: \"2f4f4f\",\n            darkslategrey: \"2f4f4f\",\n            darkturquoise: \"00ced1\",\n            darkviolet: \"9400d3\",\n            deeppink: \"ff1493\",\n            deepskyblue: \"00bfff\",\n            dimgray: \"696969\",\n            dimgrey: \"696969\",\n            dodgerblue: \"1e90ff\",\n            firebrick: \"b22222\",\n            floralwhite: \"fffaf0\",\n            forestgreen: \"228b22\",\n            fuchsia: \"f0f\",\n            gainsboro: \"dcdcdc\",\n            ghostwhite: \"f8f8ff\",\n            gold: \"ffd700\",\n            goldenrod: \"daa520\",\n            gray: \"808080\",\n            green: \"008000\",\n            greenyellow: \"adff2f\",\n            grey: \"808080\",\n            honeydew: \"f0fff0\",\n            hotpink: \"ff69b4\",\n            indianred: \"cd5c5c\",\n            indigo: \"4b0082\",\n            ivory: \"fffff0\",\n            khaki: \"f0e68c\",\n            lavender: \"e6e6fa\",\n            lavenderblush: \"fff0f5\",\n            lawngreen: \"7cfc00\",\n            lemonchiffon: \"fffacd\",\n            lightblue: \"add8e6\",\n            lightcoral: \"f08080\",\n            lightcyan: \"e0ffff\",\n            lightgoldenrodyellow: \"fafad2\",\n            lightgray: \"d3d3d3\",\n            lightgreen: \"90ee90\",\n            lightgrey: \"d3d3d3\",\n            lightpink: \"ffb6c1\",\n            lightsalmon: \"ffa07a\",\n            lightseagreen: \"20b2aa\",\n            lightskyblue: \"87cefa\",\n            lightslategray: \"789\",\n            lightslategrey: \"789\",\n            lightsteelblue: \"b0c4de\",\n            lightyellow: \"ffffe0\",\n            lime: \"0f0\",\n            limegreen: \"32cd32\",\n            linen: \"faf0e6\",\n            magenta: \"f0f\",\n            maroon: \"800000\",\n            mediumaquamarine: \"66cdaa\",\n            mediumblue: \"0000cd\",\n            mediumorchid: \"ba55d3\",\n            mediumpurple: \"9370db\",\n            mediumseagreen: \"3cb371\",\n            mediumslateblue: \"7b68ee\",\n            mediumspringgreen: \"00fa9a\",\n            mediumturquoise: \"48d1cc\",\n            mediumvioletred: \"c71585\",\n            midnightblue: \"191970\",\n            mintcream: \"f5fffa\",\n            mistyrose: \"ffe4e1\",\n            moccasin: \"ffe4b5\",\n            navajowhite: \"ffdead\",\n            navy: \"000080\",\n            oldlace: \"fdf5e6\",\n            olive: \"808000\",\n            olivedrab: \"6b8e23\",\n            orange: \"ffa500\",\n            orangered: \"ff4500\",\n            orchid: \"da70d6\",\n            palegoldenrod: \"eee8aa\",\n            palegreen: \"98fb98\",\n            paleturquoise: \"afeeee\",\n            palevioletred: \"db7093\",\n            papayawhip: \"ffefd5\",\n            peachpuff: \"ffdab9\",\n            peru: \"cd853f\",\n            pink: \"ffc0cb\",\n            plum: \"dda0dd\",\n            powderblue: \"b0e0e6\",\n            purple: \"800080\",\n            rebeccapurple: \"663399\",\n            red: \"f00\",\n            rosybrown: \"bc8f8f\",\n            royalblue: \"4169e1\",\n            saddlebrown: \"8b4513\",\n            salmon: \"fa8072\",\n            sandybrown: \"f4a460\",\n            seagreen: \"2e8b57\",\n            seashell: \"fff5ee\",\n            sienna: \"a0522d\",\n            silver: \"c0c0c0\",\n            skyblue: \"87ceeb\",\n            slateblue: \"6a5acd\",\n            slategray: \"708090\",\n            slategrey: \"708090\",\n            snow: \"fffafa\",\n            springgreen: \"00ff7f\",\n            steelblue: \"4682b4\",\n            tan: \"d2b48c\",\n            teal: \"008080\",\n            thistle: \"d8bfd8\",\n            tomato: \"ff6347\",\n            turquoise: \"40e0d0\",\n            violet: \"ee82ee\",\n            wheat: \"f5deb3\",\n            white: \"fff\",\n            whitesmoke: \"f5f5f5\",\n            yellow: \"ff0\",\n            yellowgreen: \"9acd32\"\n        };\n\n        // Make it easy to access colors via `hexNames[hex]`\n        var hexNames = tinycolor.hexNames = flip(names);\n\n\n        // Utilities\n        // ---------\n\n        // `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n        function flip(o) {\n            var flipped = { };\n            for (var i in o) {\n                if (o.hasOwnProperty(i)) {\n                    flipped[o[i]] = i;\n                }\n            }\n            return flipped;\n        }\n\n        // Return a valid alpha value [0,1] with all invalid values being set to 1\n        function boundAlpha(a) {\n            a = parseFloat(a);\n\n            if (isNaN(a) || a < 0 || a > 1) {\n                a = 1;\n            }\n\n            return a;\n        }\n\n        // Take input from [0, n] and return it as [0, 1]\n        function bound01(n, max) {\n            if (isOnePointZero(n)) { n = \"100%\"; }\n\n            var processPercent = isPercentage(n);\n            n = mathMin(max, mathMax(0, parseFloat(n)));\n\n            // Automatically convert percentage into number\n            if (processPercent) {\n                n = parseInt(n * max, 10) / 100;\n            }\n\n            // Handle floating point rounding errors\n            if ((math.abs(n - max) < 0.000001)) {\n                return 1;\n            }\n\n            // Convert into [0, 1] range if it isn't already\n            return (n % max) / parseFloat(max);\n        }\n\n        // Force a number between 0 and 1\n        function clamp01(val) {\n            return mathMin(1, mathMax(0, val));\n        }\n\n        // Parse a base-16 hex value into a base-10 integer\n        function parseIntFromHex(val) {\n            return parseInt(val, 16);\n        }\n\n        // Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n        // <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n        function isOnePointZero(n) {\n            return typeof n == \"string\" && n.indexOf('.') != -1 && parseFloat(n) === 1;\n        }\n\n        // Check to see if string passed in is a percentage\n        function isPercentage(n) {\n            return typeof n === \"string\" && n.indexOf('%') != -1;\n        }\n\n        // Force a hex value to have 2 characters\n        function pad2(c) {\n            return c.length == 1 ? '0' + c : '' + c;\n        }\n\n        // Replace a decimal with it's percentage value\n        function convertToPercentage(n) {\n            if (n <= 1) {\n                n = (n * 100) + \"%\";\n            }\n\n            return n;\n        }\n\n        // Converts a decimal to a hex value\n        function convertDecimalToHex(d) {\n            return Math.round(parseFloat(d) * 255).toString(16);\n        }\n        // Converts a hex value to a decimal\n        function convertHexToDecimal(h) {\n            return (parseIntFromHex(h) / 255);\n        }\n\n        var matchers = (function() {\n\n            // <http://www.w3.org/TR/css3-values/#integers>\n            var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n            // <http://www.w3.org/TR/css3-values/#number-value>\n            var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n            // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n            var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n            // Actual matching.\n            // Parentheses and commas are optional, but not required.\n            // Whitespace can take the place of commas or opening paren\n            var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n            var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n\n            return {\n                rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n                rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n                hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n                hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n                hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n                hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n                hex3: /^([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n                hex6: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n                hex8: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n            };\n        })();\n\n        // `stringInputToObject`\n        // Permissive string parsing.  Take in a number of formats, and output an object\n        // based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n        function stringInputToObject(color) {\n\n            color = color.replace(trimLeft,'').replace(trimRight, '').toLowerCase();\n            var named = false;\n            if (names[color]) {\n                color = names[color];\n                named = true;\n            }\n            else if (color == 'transparent') {\n                return { r: 0, g: 0, b: 0, a: 0, format: \"name\" };\n            }\n\n            // Try to match string input using regular expressions.\n            // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n            // Just return an object and let the conversion functions handle that.\n            // This way the result will be the same whether the tinycolor is initialized with string or object.\n            var match;\n            if ((match = matchers.rgb.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3] };\n            }\n            if ((match = matchers.rgba.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsl.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3] };\n            }\n            if ((match = matchers.hsla.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsv.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3] };\n            }\n            if ((match = matchers.hsva.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3], a: match[4] };\n            }\n            if ((match = matchers.hex8.exec(color))) {\n                return {\n                    a: convertHexToDecimal(match[1]),\n                    r: parseIntFromHex(match[2]),\n                    g: parseIntFromHex(match[3]),\n                    b: parseIntFromHex(match[4]),\n                    format: named ? \"name\" : \"hex8\"\n                };\n            }\n            if ((match = matchers.hex6.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1]),\n                    g: parseIntFromHex(match[2]),\n                    b: parseIntFromHex(match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n            if ((match = matchers.hex3.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1] + '' + match[1]),\n                    g: parseIntFromHex(match[2] + '' + match[2]),\n                    b: parseIntFromHex(match[3] + '' + match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n\n            return false;\n        }\n\n        window.tinycolor = tinycolor;\n    })();\n\n    $(function () {\n        if ($.fn.spectrum.load) {\n            $.fn.spectrum.processNativeColorInputs();\n        }\n    });\n\n});\n","jquery/colorpicker/js/colorpicker.js":"/**\n *\n * Color picker\n * Author: Stefan Petre www.eyecon.ro\n * \n * Dual licensed under the MIT and GPL licenses\n * \n */\n\ndefine([\n\t\"jquery\",\n], function ($) {\n\tvar ColorPicker = function () {\n\t\tvar\n\t\t\tids = {},\n\t\t\tinAction,\n\t\t\tcharMin = 65,\n\t\t\tvisible,\n\t\t\ttpl = '<div class=\"colorpicker\"><div class=\"colorpicker_color\"><div><div></div></div></div><div class=\"colorpicker_hue\"><div></div></div><div class=\"colorpicker_new_color\"></div><div class=\"colorpicker_current_color\"></div><div class=\"colorpicker_hex\"><input type=\"text\" maxlength=\"6\" size=\"6\" /></div><div class=\"colorpicker_rgb_r colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_rgb_g colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_rgb_b colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_h colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_s colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_b colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_submit\"></div></div>',\n\t\t\tdefaults = {\n\t\t\t\teventName: 'click',\n\t\t\t\tonShow: function () {},\n\t\t\t\tonBeforeShow: function(){},\n\t\t\t\tonHide: function () {},\n\t\t\t\tonChange: function () {},\n\t\t\t\tonSubmit: function () {},\n\t\t\t\tcolor: 'ff0000',\n\t\t\t\tlivePreview: true,\n\t\t\t\tflat: false\n\t\t\t},\n\t\t\tfillRGBFields = function  (hsb, cal) {\n\t\t\t\tvar rgb = HSBToRGB(hsb);\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(1).val(rgb.r).end()\n\t\t\t\t\t.eq(2).val(rgb.g).end()\n\t\t\t\t\t.eq(3).val(rgb.b).end();\n\t\t\t},\n\t\t\tfillHSBFields = function  (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(4).val(hsb.h).end()\n\t\t\t\t\t.eq(5).val(hsb.s).end()\n\t\t\t\t\t.eq(6).val(hsb.b).end();\n\t\t\t},\n\t\t\tfillHexFields = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(0).val(HSBToHex(hsb)).end();\n\t\t\t},\n\t\t\tsetSelector = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').selector.css('backgroundColor', '#' + HSBToHex({h: hsb.h, s: 100, b: 100}));\n\t\t\t\t$(cal).data('colorpicker').selectorIndic.css({\n\t\t\t\t\tleft: parseInt(150 * hsb.s/100, 10),\n\t\t\t\t\ttop: parseInt(150 * (100-hsb.b)/100, 10)\n\t\t\t\t});\n\t\t\t},\n\t\t\tsetHue = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').hue.css('top', parseInt(150 - 150 * hsb.h/360, 10));\n\t\t\t},\n\t\t\tsetCurrentColor = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').currentColor.css('backgroundColor', '#' + HSBToHex(hsb));\n\t\t\t},\n\t\t\tsetNewColor = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').newColor.css('backgroundColor', '#' + HSBToHex(hsb));\n\t\t\t},\n\t\t\tkeyDown = function (ev) {\n\t\t\t\tvar pressedKey = ev.charCode || ev.keyCode || -1;\n\t\t\t\tif ((pressedKey > charMin && pressedKey <= 90) || pressedKey == 32) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tvar cal = $(this).parent().parent();\n\t\t\t\tif (cal.data('colorpicker').livePreview === true) {\n\t\t\t\t\tchange.apply(this);\n\t\t\t\t}\n\t\t\t},\n\t\t\tchange = function (ev) {\n\t\t\t\tvar cal = $(this).parent().parent(), col;\n\t\t\t\tif (this.parentNode.className.indexOf('_hex') > 0) {\n\t\t\t\t\tcal.data('colorpicker').color = col = HexToHSB(fixHex(this.value));\n\t\t\t\t} else if (this.parentNode.className.indexOf('_hsb') > 0) {\n\t\t\t\t\tcal.data('colorpicker').color = col = fixHSB({\n\t\t\t\t\t\th: parseInt(cal.data('colorpicker').fields.eq(4).val(), 10),\n\t\t\t\t\t\ts: parseInt(cal.data('colorpicker').fields.eq(5).val(), 10),\n\t\t\t\t\t\tb: parseInt(cal.data('colorpicker').fields.eq(6).val(), 10)\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\tcal.data('colorpicker').color = col = RGBToHSB(fixRGB({\n\t\t\t\t\t\tr: parseInt(cal.data('colorpicker').fields.eq(1).val(), 10),\n\t\t\t\t\t\tg: parseInt(cal.data('colorpicker').fields.eq(2).val(), 10),\n\t\t\t\t\t\tb: parseInt(cal.data('colorpicker').fields.eq(3).val(), 10)\n\t\t\t\t\t}));\n\t\t\t\t}\n\t\t\t\tif (ev) {\n\t\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\t}\n\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t\tcal.data('colorpicker').onChange.apply(cal, [col, HSBToHex(col), HSBToRGB(col)]);\n\t\t\t},\n\t\t\tblur = function (ev) {\n\t\t\t\tvar cal = $(this).parent().parent();\n\t\t\t\tcal.data('colorpicker').fields.parent().removeClass('colorpicker_focus');\n\t\t\t},\n\t\t\tfocus = function () {\n\t\t\t\tcharMin = this.parentNode.className.indexOf('_hex') > 0 ? 70 : 65;\n\t\t\t\t$(this).parent().parent().data('colorpicker').fields.parent().removeClass('colorpicker_focus');\n\t\t\t\t$(this).parent().addClass('colorpicker_focus');\n\t\t\t},\n\t\t\tdownIncrement = function (ev) {\n\t\t\t\tvar field = $(this).parent().find('input').focus();\n\t\t\t\tvar current = {\n\t\t\t\t\tel: $(this).parent().addClass('colorpicker_slider'),\n\t\t\t\t\tmax: this.parentNode.className.indexOf('_hsb_h') > 0 ? 360 : (this.parentNode.className.indexOf('_hsb') > 0 ? 100 : 255),\n\t\t\t\t\ty: ev.pageY,\n\t\t\t\t\tfield: field,\n\t\t\t\t\tval: parseInt(field.val(), 10),\n\t\t\t\t\tpreview: $(this).parent().parent().data('colorpicker').livePreview\t\t\t\t\t\n\t\t\t\t};\n\t\t\t\t$(document).bind('mouseup', current, upIncrement);\n\t\t\t\t$(document).bind('mousemove', current, moveIncrement);\n\t\t\t},\n\t\t\tmoveIncrement = function (ev) {\n\t\t\t\tev.data.field.val(Math.max(0, Math.min(ev.data.max, parseInt(ev.data.val + ev.pageY - ev.data.y, 10))));\n\t\t\t\tif (ev.data.preview) {\n\t\t\t\t\tchange.apply(ev.data.field.get(0), [true]);\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupIncrement = function (ev) {\n\t\t\t\tchange.apply(ev.data.field.get(0), [true]);\n\t\t\t\tev.data.el.removeClass('colorpicker_slider').find('input').focus();\n\t\t\t\t$(document).unbind('mouseup', upIncrement);\n\t\t\t\t$(document).unbind('mousemove', moveIncrement);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tdownHue = function (ev) {\n\t\t\t\tvar current = {\n\t\t\t\t\tcal: $(this).parent(),\n\t\t\t\t\ty: $(this).offset().top\n\t\t\t\t};\n\t\t\t\tcurrent.preview = current.cal.data('colorpicker').livePreview;\n\t\t\t\t$(document).bind('mouseup', current, upHue);\n\t\t\t\t$(document).bind('mousemove', current, moveHue);\n\t\t\t},\n\t\t\tmoveHue = function (ev) {\n\t\t\t\tchange.apply(\n\t\t\t\t\tev.data.cal.data('colorpicker')\n\t\t\t\t\t\t.fields\n\t\t\t\t\t\t.eq(4)\n\t\t\t\t\t\t.val(parseInt(360*(150 - Math.max(0,Math.min(150,(ev.pageY - ev.data.y))))/150, 10))\n\t\t\t\t\t\t.get(0),\n\t\t\t\t\t[ev.data.preview]\n\t\t\t\t);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupHue = function (ev) {\n\t\t\t\tfillRGBFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\tfillHexFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\t$(document).unbind('mouseup', upHue);\n\t\t\t\t$(document).unbind('mousemove', moveHue);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tdownSelector = function (ev) {\n\t\t\t\tvar current = {\n\t\t\t\t\tcal: $(this).parent(),\n\t\t\t\t\tpos: $(this).offset()\n\t\t\t\t};\n\t\t\t\tcurrent.preview = current.cal.data('colorpicker').livePreview;\n\t\t\t\t$(document).bind('mouseup', current, upSelector);\n\t\t\t\t$(document).bind('mousemove', current, moveSelector);\n\t\t\t},\n\t\t\tmoveSelector = function (ev) {\n\t\t\t\tchange.apply(\n\t\t\t\t\tev.data.cal.data('colorpicker')\n\t\t\t\t\t\t.fields\n\t\t\t\t\t\t.eq(6)\n\t\t\t\t\t\t.val(parseInt(100*(150 - Math.max(0,Math.min(150,(ev.pageY - ev.data.pos.top))))/150, 10))\n\t\t\t\t\t\t.end()\n\t\t\t\t\t\t.eq(5)\n\t\t\t\t\t\t.val(parseInt(100*(Math.max(0,Math.min(150,(ev.pageX - ev.data.pos.left))))/150, 10))\n\t\t\t\t\t\t.get(0),\n\t\t\t\t\t[ev.data.preview]\n\t\t\t\t);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupSelector = function (ev) {\n\t\t\t\tfillRGBFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\tfillHexFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\t$(document).unbind('mouseup', upSelector);\n\t\t\t\t$(document).unbind('mousemove', moveSelector);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tenterSubmit = function (ev) {\n\t\t\t\t$(this).addClass('colorpicker_focus');\n\t\t\t},\n\t\t\tleaveSubmit = function (ev) {\n\t\t\t\t$(this).removeClass('colorpicker_focus');\n\t\t\t},\n\t\t\tclickSubmit = function (ev) {\n\t\t\t\tvar cal = $(this).parent();\n\t\t\t\tvar col = cal.data('colorpicker').color;\n\t\t\t\tcal.data('colorpicker').origColor = col;\n\t\t\t\tsetCurrentColor(col, cal.get(0));\n\t\t\t\tcal.data('colorpicker').onSubmit(col, HSBToHex(col), HSBToRGB(col), cal.data('colorpicker').el);\n\t\t\t},\n\t\t\tshow = function (ev) {\n\t\t\t\tvar cal = $('#' + $(this).data('colorpickerId'));\n\t\t\t\tcal.data('colorpicker').onBeforeShow.apply(this, [cal.get(0)]);\n\t\t\t\tvar pos = $(this).offset();\n\t\t\t\tvar viewPort = getViewport();\n\t\t\t\tvar top = pos.top + this.offsetHeight;\n\t\t\t\tvar left = pos.left;\n\t\t\t\tif (top + 176 > viewPort.t + viewPort.h) {\n\t\t\t\t\ttop -= this.offsetHeight + 176;\n\t\t\t\t}\n\t\t\t\tif (left + 356 > viewPort.l + viewPort.w) {\n\t\t\t\t\tleft -= 356;\n\t\t\t\t}\n\t\t\t\tcal.css({left: left + 'px', top: top + 'px'});\n\t\t\t\tif (cal.data('colorpicker').onShow.apply(this, [cal.get(0)]) != false) {\n\t\t\t\t\tcal.show();\n\t\t\t\t}\n\t\t\t\t$(document).bind('mousedown', {cal: cal}, hide);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\thide = function (ev) {\n\t\t\t\tif (!isChildOf(ev.data.cal.get(0), ev.target, ev.data.cal.get(0))) {\n\t\t\t\t\tif (ev.data.cal.data('colorpicker').onHide.apply(this, [ev.data.cal.get(0)]) != false) {\n\t\t\t\t\t\tev.data.cal.hide();\n\t\t\t\t\t}\n\t\t\t\t\t$(document).unbind('mousedown', hide);\n\t\t\t\t}\n\t\t\t},\n\t\t\tisChildOf = function(parentEl, el, container) {\n\t\t\t\tif (parentEl == el) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\tif (parentEl.contains) {\n\t\t\t\t\treturn parentEl.contains(el);\n\t\t\t\t}\n\t\t\t\tif ( parentEl.compareDocumentPosition ) {\n\t\t\t\t\treturn !!(parentEl.compareDocumentPosition(el) & 16);\n\t\t\t\t}\n\t\t\t\tvar prEl = el.parentNode;\n\t\t\t\twhile(prEl && prEl != container) {\n\t\t\t\t\tif (prEl == parentEl)\n\t\t\t\t\t\treturn true;\n\t\t\t\t\tprEl = prEl.parentNode;\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tgetViewport = function () {\n\t\t\t\tvar m = document.compatMode == 'CSS1Compat';\n\t\t\t\treturn {\n\t\t\t\t\tl : window.pageXOffset || (m ? document.documentElement.scrollLeft : document.body.scrollLeft),\n\t\t\t\t\tt : window.pageYOffset || (m ? document.documentElement.scrollTop : document.body.scrollTop),\n\t\t\t\t\tw : window.innerWidth || (m ? document.documentElement.clientWidth : document.body.clientWidth),\n\t\t\t\t\th : window.innerHeight || (m ? document.documentElement.clientHeight : document.body.clientHeight)\n\t\t\t\t};\n\t\t\t},\n\t\t\tfixHSB = function (hsb) {\n\t\t\t\treturn {\n\t\t\t\t\th: Math.min(360, Math.max(0, hsb.h)),\n\t\t\t\t\ts: Math.min(100, Math.max(0, hsb.s)),\n\t\t\t\t\tb: Math.min(100, Math.max(0, hsb.b))\n\t\t\t\t};\n\t\t\t}, \n\t\t\tfixRGB = function (rgb) {\n\t\t\t\treturn {\n\t\t\t\t\tr: Math.min(255, Math.max(0, rgb.r)),\n\t\t\t\t\tg: Math.min(255, Math.max(0, rgb.g)),\n\t\t\t\t\tb: Math.min(255, Math.max(0, rgb.b))\n\t\t\t\t};\n\t\t\t},\n\t\t\tfixHex = function (hex) {\n\t\t\t\tvar len = 6 - hex.length;\n\t\t\t\tif (len > 0) {\n\t\t\t\t\tvar o = [];\n\t\t\t\t\tfor (var i=0; i<len; i++) {\n\t\t\t\t\t\to.push('0');\n\t\t\t\t\t}\n\t\t\t\t\to.push(hex);\n\t\t\t\t\thex = o.join('');\n\t\t\t\t}\n\t\t\t\treturn hex;\n\t\t\t}, \n\t\t\tHexToRGB = function (hex) {\n\t\t\t\tvar hex = parseInt(((hex.indexOf('#') > -1) ? hex.substring(1) : hex), 16);\n\t\t\t\treturn {r: hex >> 16, g: (hex & 0x00FF00) >> 8, b: (hex & 0x0000FF)};\n\t\t\t},\n\t\t\tHexToHSB = function (hex) {\n\t\t\t\treturn RGBToHSB(HexToRGB(hex));\n\t\t\t},\n\t\t\tRGBToHSB = function (rgb) {\n\t\t\t\tvar hsb = {\n\t\t\t\t\th: 0,\n\t\t\t\t\ts: 0,\n\t\t\t\t\tb: 0\n\t\t\t\t};\n\t\t\t\tvar min = Math.min(rgb.r, rgb.g, rgb.b);\n\t\t\t\tvar max = Math.max(rgb.r, rgb.g, rgb.b);\n\t\t\t\tvar delta = max - min;\n\t\t\t\thsb.b = max;\n\t\t\t\tif (max != 0) {\n\t\t\t\t\t\n\t\t\t\t}\n\t\t\t\thsb.s = max != 0 ? 255 * delta / max : 0;\n\t\t\t\tif (hsb.s != 0) {\n\t\t\t\t\tif (rgb.r == max) {\n\t\t\t\t\t\thsb.h = (rgb.g - rgb.b) / delta;\n\t\t\t\t\t} else if (rgb.g == max) {\n\t\t\t\t\t\thsb.h = 2 + (rgb.b - rgb.r) / delta;\n\t\t\t\t\t} else {\n\t\t\t\t\t\thsb.h = 4 + (rgb.r - rgb.g) / delta;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\thsb.h = -1;\n\t\t\t\t}\n\t\t\t\thsb.h *= 60;\n\t\t\t\tif (hsb.h < 0) {\n\t\t\t\t\thsb.h += 360;\n\t\t\t\t}\n\t\t\t\thsb.s *= 100/255;\n\t\t\t\thsb.b *= 100/255;\n\t\t\t\treturn hsb;\n\t\t\t},\n\t\t\tHSBToRGB = function (hsb) {\n\t\t\t\tvar rgb = {};\n\t\t\t\tvar h = Math.round(hsb.h);\n\t\t\t\tvar s = Math.round(hsb.s*255/100);\n\t\t\t\tvar v = Math.round(hsb.b*255/100);\n\t\t\t\tif(s == 0) {\n\t\t\t\t\trgb.r = rgb.g = rgb.b = v;\n\t\t\t\t} else {\n\t\t\t\t\tvar t1 = v;\n\t\t\t\t\tvar t2 = (255-s)*v/255;\n\t\t\t\t\tvar t3 = (t1-t2)*(h%60)/60;\n\t\t\t\t\tif(h==360) h = 0;\n\t\t\t\t\tif(h<60) {rgb.r=t1;\trgb.b=t2; rgb.g=t2+t3}\n\t\t\t\t\telse if(h<120) {rgb.g=t1; rgb.b=t2;\trgb.r=t1-t3}\n\t\t\t\t\telse if(h<180) {rgb.g=t1; rgb.r=t2;\trgb.b=t2+t3}\n\t\t\t\t\telse if(h<240) {rgb.b=t1; rgb.r=t2;\trgb.g=t1-t3}\n\t\t\t\t\telse if(h<300) {rgb.b=t1; rgb.g=t2;\trgb.r=t2+t3}\n\t\t\t\t\telse if(h<360) {rgb.r=t1; rgb.g=t2;\trgb.b=t1-t3}\n\t\t\t\t\telse {rgb.r=0; rgb.g=0;\trgb.b=0}\n\t\t\t\t}\n\t\t\t\treturn {r:Math.round(rgb.r), g:Math.round(rgb.g), b:Math.round(rgb.b)};\n\t\t\t},\n\t\t\tRGBToHex = function (rgb) {\n\t\t\t\tvar hex = [\n\t\t\t\t\trgb.r.toString(16),\n\t\t\t\t\trgb.g.toString(16),\n\t\t\t\t\trgb.b.toString(16)\n\t\t\t\t];\n\t\t\t\t$.each(hex, function (nr, val) {\n\t\t\t\t\tif (val.length == 1) {\n\t\t\t\t\t\thex[nr] = '0' + val;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\treturn hex.join('');\n\t\t\t},\n\t\t\tHSBToHex = function (hsb) {\n\t\t\t\treturn RGBToHex(HSBToRGB(hsb));\n\t\t\t},\n\t\t\trestoreOriginal = function () {\n\t\t\t\tvar cal = $(this).parent();\n\t\t\t\tvar col = cal.data('colorpicker').origColor;\n\t\t\t\tcal.data('colorpicker').color = col;\n\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t};\n\t\treturn {\n\t\t\tinit: function (opt) {\n\t\t\t\topt = $.extend({}, defaults, opt||{});\n\t\t\t\tif (typeof opt.color == 'string') {\n\t\t\t\t\topt.color = HexToHSB(opt.color);\n\t\t\t\t} else if (opt.color.r != undefined && opt.color.g != undefined && opt.color.b != undefined) {\n\t\t\t\t\topt.color = RGBToHSB(opt.color);\n\t\t\t\t} else if (opt.color.h != undefined && opt.color.s != undefined && opt.color.b != undefined) {\n\t\t\t\t\topt.color = fixHSB(opt.color);\n\t\t\t\t} else {\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t\treturn this.each(function () {\n\t\t\t\t\tif (!$(this).data('colorpickerId')) {\n\t\t\t\t\t\tvar options = $.extend({}, opt);\n\t\t\t\t\t\toptions.origColor = opt.color;\n\t\t\t\t\t\tvar id = 'collorpicker_' + parseInt(Math.random() * 1000);\n\t\t\t\t\t\t$(this).data('colorpickerId', id);\n\t\t\t\t\t\tvar cal = $(tpl).attr('id', id);\n\t\t\t\t\t\tif (options.flat) {\n\t\t\t\t\t\t\tcal.appendTo(this).show();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tcal.appendTo(document.body);\n\t\t\t\t\t\t}\n\t\t\t\t\t\toptions.fields = cal\n\t\t\t\t\t\t\t\t\t\t\t.find('input')\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('keyup', keyDown)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('change', change)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('blur', blur)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('focus', focus);\n\t\t\t\t\t\tcal\n\t\t\t\t\t\t\t.find('span').bind('mousedown', downIncrement).end()\n\t\t\t\t\t\t\t.find('>div.colorpicker_current_color').bind('click', restoreOriginal);\n\t\t\t\t\t\toptions.selector = cal.find('div.colorpicker_color').bind('mousedown', downSelector);\n\t\t\t\t\t\toptions.selectorIndic = options.selector.find('div div');\n\t\t\t\t\t\toptions.el = this;\n\t\t\t\t\t\toptions.hue = cal.find('div.colorpicker_hue div');\n\t\t\t\t\t\tcal.find('div.colorpicker_hue').bind('mousedown', downHue);\n\t\t\t\t\t\toptions.newColor = cal.find('div.colorpicker_new_color');\n\t\t\t\t\t\toptions.currentColor = cal.find('div.colorpicker_current_color');\n\t\t\t\t\t\tcal.data('colorpicker', options);\n\t\t\t\t\t\tcal.find('div.colorpicker_submit')\n\t\t\t\t\t\t\t.bind('mouseenter', enterSubmit)\n\t\t\t\t\t\t\t.bind('mouseleave', leaveSubmit)\n\t\t\t\t\t\t\t.bind('click', clickSubmit);\n\t\t\t\t\t\tfillRGBFields(options.color, cal.get(0));\n\t\t\t\t\t\tfillHSBFields(options.color, cal.get(0));\n\t\t\t\t\t\tfillHexFields(options.color, cal.get(0));\n\t\t\t\t\t\tsetHue(options.color, cal.get(0));\n\t\t\t\t\t\tsetSelector(options.color, cal.get(0));\n\t\t\t\t\t\tsetCurrentColor(options.color, cal.get(0));\n\t\t\t\t\t\tsetNewColor(options.color, cal.get(0));\n\t\t\t\t\t\tif (options.flat) {\n\t\t\t\t\t\t\tcal.css({\n\t\t\t\t\t\t\t\tposition: 'relative',\n\t\t\t\t\t\t\t\tdisplay: 'block'\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t$(this).bind(options.eventName, show);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\tshowPicker: function() {\n\t\t\t\treturn this.each( function () {\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\tshow.apply(this);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\thidePicker: function() {\n\t\t\t\treturn this.each( function () {\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\t$('#' + $(this).data('colorpickerId')).hide();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\tsetColor: function(col) {\n\t\t\t\tif (typeof col == 'string') {\n\t\t\t\t\tcol = HexToHSB(col);\n\t\t\t\t} else if (col.r != undefined && col.g != undefined && col.b != undefined) {\n\t\t\t\t\tcol = RGBToHSB(col);\n\t\t\t\t} else if (col.h != undefined && col.s != undefined && col.b != undefined) {\n\t\t\t\t\tcol = fixHSB(col);\n\t\t\t\t} else {\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t\treturn this.each(function(){\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\tvar cal = $('#' + $(this).data('colorpickerId'));\n\t\t\t\t\t\tcal.data('colorpicker').color = col;\n\t\t\t\t\t\tcal.data('colorpicker').origColor = col;\n\t\t\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\t\t\tsetCurrentColor(col, cal.get(0));\n\t\t\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\t}();\n\t$.fn.extend({\n\t\tColorPicker: ColorPicker.init,\n\t\tColorPickerHide: ColorPicker.hidePicker,\n\t\tColorPickerShow: ColorPicker.showPicker,\n\t\tColorPickerSetColor: ColorPicker.setColor\n\t});\n});","jquery/jstree/jquery.jstree.js":"/*globals jQuery, define, module, exports, require, window, document, postMessage */\n(function (factory) {\n    \"use strict\";\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery'], factory);\n    }\n    else if(typeof module !== 'undefined' && module.exports) {\n        module.exports = factory(require('jquery'));\n    }\n    else {\n        factory(jQuery);\n    }\n}(function ($, undefined) {\n    \"use strict\";\n    /*!\n * jsTree 3.3.12\n * http://jstree.com/\n *\n * Copyright (c) 2014 Ivan Bozhanov (http://vakata.com)\n *\n * Licensed same as jquery - under the terms of the MIT License\n *   http://www.opensource.org/licenses/mit-license.php\n */\n    /*!\n * if using jslint please allow for the jQuery global and use following options:\n * jslint: loopfunc: true, browser: true, ass: true, bitwise: true, continue: true, nomen: true, plusplus: true, regexp: true, unparam: true, todo: true, white: true\n */\n    /*jshint -W083 */\n\n    // prevent another load? maybe there is a better way?\n    if($.jstree) {\n        return;\n    }\n\n    /**\n     * ### jsTree core functionality\n     */\n\n        // internal variables\n    var instance_counter = 0,\n        ccp_node = false,\n        ccp_mode = false,\n        ccp_inst = false,\n        themes_loaded = [],\n        src = $('script:last').attr('src'),\n        document = window.document; // local variable is always faster to access then a global\n\n    var setImmediate = window.setImmediate;\n    var Promise = window.Promise;\n    if (!setImmediate && Promise) {\n        // Good enough approximation of setImmediate\n        setImmediate = function (cb, arg) {\n            Promise.resolve(arg).then(cb);\n        };\n    }\n\n    /**\n     * holds all jstree related functions and variables, including the actual class and methods to create, access and manipulate instances.\n     * @name $.jstree\n     */\n    $.jstree = {\n        /**\n         * specifies the jstree version in use\n         * @name $.jstree.version\n         */\n        version : '3.3.12',\n        /**\n         * holds all the default options used when creating new instances\n         * @name $.jstree.defaults\n         */\n        defaults : {\n            /**\n             * configure which plugins will be active on an instance. Should be an array of strings, where each element is a plugin name. The default is `[]`\n             * @name $.jstree.defaults.plugins\n             */\n            plugins : []\n        },\n        /**\n         * stores all loaded jstree plugins (used internally)\n         * @name $.jstree.plugins\n         */\n        plugins : {},\n        path : src && src.indexOf('/') !== -1 ? src.replace(/\\/[^\\/]+$/,'') : '',\n        idregex : /[\\\\:&!^|()\\[\\]<>@*'+~#\";.,=\\- \\/${}%?`]/g,\n        root : '#'\n    };\n\n    /**\n     * creates a jstree instance\n     * @name $.jstree.create(el [, options])\n     * @param {DOMElement|jQuery|String} el the element to create the instance on, can be jQuery extended or a selector\n     * @param {Object} options options for this instance (extends `$.jstree.defaults`)\n     * @return {jsTree} the new instance\n     */\n    $.jstree.create = function (el, options) {\n        var tmp = new $.jstree.core(++instance_counter),\n            opt = options;\n        options = $.extend(true, {}, $.jstree.defaults, options);\n        if(opt && opt.plugins) {\n            options.plugins = opt.plugins;\n        }\n        $.each(options.plugins, function (i, k) {\n            if(i !== 'core') {\n                tmp = tmp.plugin(k, options[k]);\n            }\n        });\n        $(el).data('jstree', tmp);\n        tmp.init(el, options);\n        return tmp;\n    };\n    /**\n     * remove all traces of jstree from the DOM and destroy all instances\n     * @name $.jstree.destroy()\n     */\n    $.jstree.destroy = function () {\n        $('.jstree:jstree').jstree('destroy');\n        $(document).off('.jstree');\n    };\n    /**\n     * the jstree class constructor, used only internally\n     * @private\n     * @name $.jstree.core(id)\n     * @param {Number} id this instance's index\n     */\n    $.jstree.core = function (id) {\n        this._id = id;\n        this._cnt = 0;\n        this._wrk = null;\n        this._data = {\n            core : {\n                themes : {\n                    name : false,\n                    dots : false,\n                    icons : false,\n                    ellipsis : false\n                },\n                selected : [],\n                last_error : {},\n                working : false,\n                worker_queue : [],\n                focused : null\n            }\n        };\n    };\n    /**\n     * get a reference to an existing instance\n     *\n     * __Examples__\n     *\n     *\t// provided a container with an ID of \"tree\", and a nested node with an ID of \"branch\"\n     *\t// all of there will return the same instance\n     *\t$.jstree.reference('tree');\n     *\t$.jstree.reference('#tree');\n     *\t$.jstree.reference($('#tree'));\n     *\t$.jstree.reference(document.getElementByID('tree'));\n     *\t$.jstree.reference('branch');\n     *\t$.jstree.reference('#branch');\n     *\t$.jstree.reference($('#branch'));\n     *\t$.jstree.reference(document.getElementByID('branch'));\n     *\n     * @name $.jstree.reference(needle)\n     * @param {DOMElement|jQuery|String} needle\n     * @return {jsTree|null} the instance or `null` if not found\n     */\n    $.jstree.reference = function (needle) {\n        var tmp = null,\n            obj = null;\n        if(needle && needle.id && (!needle.tagName || !needle.nodeType)) { needle = needle.id; }\n\n        if(!obj || !obj.length) {\n            try { obj = $(needle); } catch (ignore) { }\n        }\n        if(!obj || !obj.length) {\n            try { obj = $('#' + needle.replace($.jstree.idregex,'\\\\$&')); } catch (ignore) { }\n        }\n        if(obj && obj.length && (obj = obj.closest('.jstree')).length && (obj = obj.data('jstree'))) {\n            tmp = obj;\n        }\n        else {\n            $('.jstree').each(function () {\n                var inst = $(this).data('jstree');\n                if(inst && inst._model.data[needle]) {\n                    tmp = inst;\n                    return false;\n                }\n            });\n        }\n        return tmp;\n    };\n    /**\n     * Create an instance, get an instance or invoke a command on a instance.\n     *\n     * If there is no instance associated with the current node a new one is created and `arg` is used to extend `$.jstree.defaults` for this new instance. There would be no return value (chaining is not broken).\n     *\n     * If there is an existing instance and `arg` is a string the command specified by `arg` is executed on the instance, with any additional arguments passed to the function. If the function returns a value it will be returned (chaining could break depending on function).\n     *\n     * If there is an existing instance and `arg` is not a string the instance itself is returned (similar to `$.jstree.reference`).\n     *\n     * In any other case - nothing is returned and chaining is not broken.\n     *\n     * __Examples__\n     *\n     *\t$('#tree1').jstree(); // creates an instance\n     *\t$('#tree2').jstree({ plugins : [] }); // create an instance with some options\n     *\t$('#tree1').jstree('open_node', '#branch_1'); // call a method on an existing instance, passing additional arguments\n     *\t$('#tree2').jstree(); // get an existing instance (or create an instance)\n     *\t$('#tree2').jstree(true); // get an existing instance (will not create new instance)\n     *\t$('#branch_1').jstree().select_node('#branch_1'); // get an instance (using a nested element and call a method)\n     *\n     * @name $().jstree([arg])\n     * @param {String|Object} arg\n     * @return {Mixed}\n     */\n    $.fn.jstree = function (arg) {\n        // check for string argument\n        var is_method\t= (typeof arg === 'string'),\n            args\t\t= Array.prototype.slice.call(arguments, 1),\n            result\t\t= null;\n        if(arg === true && !this.length) { return false; }\n        this.each(function () {\n            // get the instance (if there is one) and method (if it exists)\n            var instance = $.jstree.reference(this),\n                method = is_method && instance ? instance[arg] : null;\n            // if calling a method, and method is available - execute on the instance\n            result = is_method && method ?\n                method.apply(instance, args) :\n                null;\n            // if there is no instance and no method is being called - create one\n            if(!instance && !is_method && (arg === undefined || $.isPlainObject(arg))) {\n                $.jstree.create(this, arg);\n            }\n            // if there is an instance and no method is called - return the instance\n            if( (instance && !is_method) || arg === true ) {\n                result = instance || false;\n            }\n            // if there was a method call which returned a result - break and return the value\n            if(result !== null && result !== undefined) {\n                return false;\n            }\n        });\n        // if there was a method call with a valid return value - return that, otherwise continue the chain\n        return result !== null && result !== undefined ?\n            result : this;\n    };\n    /**\n     * used to find elements containing an instance\n     *\n     * __Examples__\n     *\n     *\t$('div:jstree').each(function () {\n     *\t\t$(this).jstree('destroy');\n     *\t});\n     *\n     * @name $(':jstree')\n     * @return {jQuery}\n     */\n    $.expr.pseudos.jstree = $.expr.createPseudo(function(search) {\n        return function(a) {\n            return $(a).hasClass('jstree') &&\n                $(a).data('jstree') !== undefined;\n        };\n    });\n\n    /**\n     * stores all defaults for the core\n     * @name $.jstree.defaults.core\n     */\n    $.jstree.defaults.core = {\n        /**\n         * data configuration\n         *\n         * If left as `false` the HTML inside the jstree container element is used to populate the tree (that should be an unordered list with list items).\n         *\n         * You can also pass in a HTML string or a JSON array here.\n         *\n         * It is possible to pass in a standard jQuery-like AJAX config and jstree will automatically determine if the response is JSON or HTML and use that to populate the tree.\n         * In addition to the standard jQuery ajax options here you can supply functions for `data` and `url`, the functions will be run in the current instance's scope and a param will be passed indicating which node is being loaded, the return value of those functions will be used.\n         *\n         * The last option is to specify a function, that function will receive the node being loaded as argument and a second param which is a function which should be called with the result.\n         *\n         * __Examples__\n         *\n         *\t// AJAX\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'data' : {\n         *\t\t\t\t'url' : '/get/children/',\n         *\t\t\t\t'data' : function (node) {\n         *\t\t\t\t\treturn { 'id' : node.id };\n         *\t\t\t\t}\n         *\t\t\t}\n         *\t\t});\n         *\n         *\t// direct data\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'data' : [\n         *\t\t\t\t'Simple root node',\n         *\t\t\t\t{\n         *\t\t\t\t\t'id' : 'node_2',\n         *\t\t\t\t\t'text' : 'Root node with options',\n         *\t\t\t\t\t'state' : { 'opened' : true, 'selected' : true },\n         *\t\t\t\t\t'children' : [ { 'text' : 'Child 1' }, 'Child 2']\n         *\t\t\t\t}\n         *\t\t\t]\n         *\t\t}\n         *\t});\n         *\n         *\t// function\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'data' : function (obj, callback) {\n         *\t\t\t\tcallback.call(this, ['Root 1', 'Root 2']);\n         *\t\t\t}\n         *\t\t});\n         *\n         * @name $.jstree.defaults.core.data\n         */\n        data\t\t\t: false,\n        /**\n         * configure the various strings used throughout the tree\n         *\n         * You can use an object where the key is the string you need to replace and the value is your replacement.\n         * Another option is to specify a function which will be called with an argument of the needed string and should return the replacement.\n         * If left as `false` no replacement is made.\n         *\n         * __Examples__\n         *\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'strings' : {\n         *\t\t\t\t'Loading ...' : 'Please wait ...'\n         *\t\t\t}\n         *\t\t}\n         *\t});\n         *\n         * @name $.jstree.defaults.core.strings\n         */\n        strings\t\t\t: false,\n        /**\n         * determines what happens when a user tries to modify the structure of the tree\n         * If left as `false` all operations like create, rename, delete, move or copy are prevented.\n         * You can set this to `true` to allow all interactions or use a function to have better control.\n         *\n         * __Examples__\n         *\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'check_callback' : function (operation, node, node_parent, node_position, more) {\n         *\t\t\t\t// operation can be 'create_node', 'rename_node', 'delete_node', 'move_node', 'copy_node' or 'edit'\n         *\t\t\t\t// in case of 'rename_node' node_position is filled with the new node name\n         *\t\t\t\treturn operation === 'rename_node' ? true : false;\n         *\t\t\t}\n         *\t\t}\n         *\t});\n         *\n         * @name $.jstree.defaults.core.check_callback\n         */\n        check_callback\t: false,\n        /**\n         * a callback called with a single object parameter in the instance's scope when something goes wrong (operation prevented, ajax failed, etc)\n         * @name $.jstree.defaults.core.error\n         */\n        error\t\t\t: $.noop,\n        /**\n         * the open / close animation duration in milliseconds - set this to `false` to disable the animation (default is `200`)\n         * @name $.jstree.defaults.core.animation\n         */\n        animation\t\t: 200,\n        /**\n         * a boolean indicating if multiple nodes can be selected\n         * @name $.jstree.defaults.core.multiple\n         */\n        multiple\t\t: true,\n        /**\n         * theme configuration object\n         * @name $.jstree.defaults.core.themes\n         */\n        themes\t\t\t: {\n            /**\n             * the name of the theme to use (if left as `false` the default theme is used)\n             * @name $.jstree.defaults.core.themes.name\n             */\n            name\t\t\t: false,\n            /**\n             * the URL of the theme's CSS file, leave this as `false` if you have manually included the theme CSS (recommended). You can set this to `true` too which will try to autoload the theme.\n             * @name $.jstree.defaults.core.themes.url\n             */\n            url\t\t\t\t: false,\n            /**\n             * the location of all jstree themes - only used if `url` is set to `true`\n             * @name $.jstree.defaults.core.themes.dir\n             */\n            dir\t\t\t\t: false,\n            /**\n             * a boolean indicating if connecting dots are shown\n             * @name $.jstree.defaults.core.themes.dots\n             */\n            dots\t\t\t: true,\n            /**\n             * a boolean indicating if node icons are shown\n             * @name $.jstree.defaults.core.themes.icons\n             */\n            icons\t\t\t: true,\n            /**\n             * a boolean indicating if node ellipsis should be shown - this only works with a fixed with on the container\n             * @name $.jstree.defaults.core.themes.ellipsis\n             */\n            ellipsis\t\t: false,\n            /**\n             * a boolean indicating if the tree background is striped\n             * @name $.jstree.defaults.core.themes.stripes\n             */\n            stripes\t\t\t: false,\n            /**\n             * a string (or boolean `false`) specifying the theme variant to use (if the theme supports variants)\n             * @name $.jstree.defaults.core.themes.variant\n             */\n            variant\t\t\t: false,\n            /**\n             * a boolean specifying if a reponsive version of the theme should kick in on smaller screens (if the theme supports it). Defaults to `false`.\n             * @name $.jstree.defaults.core.themes.responsive\n             */\n            responsive\t\t: false\n        },\n        /**\n         * if left as `true` all parents of all selected nodes will be opened once the tree loads (so that all selected nodes are visible to the user)\n         * @name $.jstree.defaults.core.expand_selected_onload\n         */\n        expand_selected_onload : true,\n        /**\n         * if left as `true` web workers will be used to parse incoming JSON data where possible, so that the UI will not be blocked by large requests. Workers are however about 30% slower. Defaults to `true`\n         * @name $.jstree.defaults.core.worker\n         */\n        worker : true,\n        /**\n         * Force node text to plain text (and escape HTML). Defaults to `false`\n         * @name $.jstree.defaults.core.force_text\n         */\n        force_text : false,\n        /**\n         * Should the node be toggled if the text is double clicked. Defaults to `true`\n         * @name $.jstree.defaults.core.dblclick_toggle\n         */\n        dblclick_toggle : true,\n        /**\n         * Should the loaded nodes be part of the state. Defaults to `false`\n         * @name $.jstree.defaults.core.loaded_state\n         */\n        loaded_state : false,\n        /**\n         * Should the last active node be focused when the tree container is blurred and the focused again. This helps working with screen readers. Defaults to `true`\n         * @name $.jstree.defaults.core.restore_focus\n         */\n        restore_focus : true,\n        /**\n         * Force to compute and set \"aria-setsize\" and \"aria-posinset\" explicitly for each treeitem.\n         * Some browsers may compute incorrect elements position and produce wrong announcements for screen readers. Defaults to `false`\n         * @name $.jstree.defaults.core.compute_elements_positions\n         */\n        compute_elements_positions : false,\n        /**\n         * Default keyboard shortcuts (an object where each key is the button name or combo - like 'enter', 'ctrl-space', 'p', etc and the value is the function to execute in the instance's scope)\n         * @name $.jstree.defaults.core.keyboard\n         */\n        keyboard : {\n            'ctrl-space': function (e) {\n                // aria defines space only with Ctrl\n                e.type = \"click\";\n                $(e.currentTarget).trigger(e);\n            },\n            'enter': function (e) {\n                // enter\n                e.type = \"click\";\n                $(e.currentTarget).trigger(e);\n            },\n            'left': function (e) {\n                // left\n                e.preventDefault();\n                if(this.is_open(e.currentTarget)) {\n                    this.close_node(e.currentTarget);\n                }\n                else {\n                    var o = this.get_parent(e.currentTarget);\n                    if(o && o.id !== $.jstree.root) { this.get_node(o, true).children('.jstree-anchor').trigger('focus'); }\n                }\n            },\n            'up': function (e) {\n                // up\n                e.preventDefault();\n                var o = this.get_prev_dom(e.currentTarget);\n                if(o && o.length) { o.children('.jstree-anchor').trigger('focus'); }\n            },\n            'right': function (e) {\n                // right\n                e.preventDefault();\n                if(this.is_closed(e.currentTarget)) {\n                    this.open_node(e.currentTarget, function (o) { this.get_node(o, true).children('.jstree-anchor').trigger('focus'); });\n                }\n                else if (this.is_open(e.currentTarget)) {\n                    var o = this.get_node(e.currentTarget, true).children('.jstree-children')[0];\n                    if(o) { $(this._firstChild(o)).children('.jstree-anchor').trigger('focus'); }\n                }\n            },\n            'down': function (e) {\n                // down\n                e.preventDefault();\n                var o = this.get_next_dom(e.currentTarget);\n                if(o && o.length) { o.children('.jstree-anchor').trigger('focus'); }\n            },\n            '*': function (e) {\n                // aria defines * on numpad as open_all - not very common\n                this.open_all();\n            },\n            'home': function (e) {\n                // home\n                e.preventDefault();\n                var o = this._firstChild(this.get_container_ul()[0]);\n                if(o) { $(o).children('.jstree-anchor').filter(':visible').trigger('focus'); }\n            },\n            'end': function (e) {\n                // end\n                e.preventDefault();\n                this.element.find('.jstree-anchor').filter(':visible').last().trigger('focus');\n            },\n            'f2': function (e) {\n                // f2 - safe to include - if check_callback is false it will fail\n                e.preventDefault();\n                this.edit(e.currentTarget);\n            }\n        }\n    };\n    $.jstree.core.prototype = {\n        /**\n         * used to decorate an instance with a plugin. Used internally.\n         * @private\n         * @name plugin(deco [, opts])\n         * @param  {String} deco the plugin to decorate with\n         * @param  {Object} opts options for the plugin\n         * @return {jsTree}\n         */\n        plugin : function (deco, opts) {\n            var Child = $.jstree.plugins[deco];\n            if(Child) {\n                this._data[deco] = {};\n                Child.prototype = this;\n                return new Child(opts, this);\n            }\n            return this;\n        },\n        /**\n         * initialize the instance. Used internally.\n         * @private\n         * @name init(el, optons)\n         * @param {DOMElement|jQuery|String} el the element we are transforming\n         * @param {Object} options options for this instance\n         * @trigger init.jstree, loading.jstree, loaded.jstree, ready.jstree, changed.jstree\n         */\n        init : function (el, options) {\n            this._model = {\n                data : {},\n                changed : [],\n                force_full_redraw : false,\n                redraw_timeout : false,\n                default_state : {\n                    loaded : true,\n                    opened : false,\n                    selected : false,\n                    disabled : false\n                }\n            };\n            this._model.data[$.jstree.root] = {\n                id : $.jstree.root,\n                parent : null,\n                parents : [],\n                children : [],\n                children_d : [],\n                state : { loaded : false }\n            };\n\n            this.element = $(el).addClass('jstree jstree-' + this._id);\n            this.settings = options;\n\n            this._data.core.ready = false;\n            this._data.core.loaded = false;\n            this._data.core.rtl = (this.element.css(\"direction\") === \"rtl\");\n            this.element[this._data.core.rtl ? 'addClass' : 'removeClass'](\"jstree-rtl\");\n            this.element.attr('role','tree');\n            if(this.settings.core.multiple) {\n                this.element.attr('aria-multiselectable', true);\n            }\n            if(!this.element.attr('tabindex')) {\n                this.element.attr('tabindex','0');\n            }\n\n            this.bind();\n            /**\n             * triggered after all events are bound\n             * @event\n             * @name init.jstree\n             */\n            this.trigger(\"init\");\n\n            this._data.core.original_container_html = this.element.find(\" > ul > li\").clone(true);\n            this._data.core.original_container_html\n                .find(\"li\").addBack()\n                .contents().filter(function() {\n                return this.nodeType === 3 && (!this.nodeValue || /^\\s+$/.test(this.nodeValue));\n            })\n                .remove();\n            this.element.html(\"<\"+\"ul class='jstree-container-ul jstree-children' role='group'><\"+\"li id='j\"+this._id+\"_loading' class='jstree-initial-node jstree-loading jstree-leaf jstree-last' role='none'><i class='jstree-icon jstree-ocl'></i><\"+\"a class='jstree-anchor' role='treeitem' href='#'><i class='jstree-icon jstree-themeicon-hidden'></i>\" + this.get_string(\"Loading ...\") + \"</a></li></ul>\");\n            this.element.attr('aria-activedescendant','j' + this._id + '_loading');\n            this._data.core.li_height = this.get_container_ul().children(\"li\").first().outerHeight() || 24;\n            this._data.core.node = this._create_prototype_node();\n            /**\n             * triggered after the loading text is shown and before loading starts\n             * @event\n             * @name loading.jstree\n             */\n            this.trigger(\"loading\");\n            this.load_node($.jstree.root);\n        },\n        /**\n         * destroy an instance\n         * @name destroy()\n         * @param  {Boolean} keep_html if not set to `true` the container will be emptied, otherwise the current DOM elements will be kept intact\n         */\n        destroy : function (keep_html) {\n            /**\n             * triggered before the tree is destroyed\n             * @event\n             * @name destroy.jstree\n             */\n            this.trigger(\"destroy\");\n            if(this._wrk) {\n                try {\n                    window.URL.revokeObjectURL(this._wrk);\n                    this._wrk = null;\n                }\n                catch (ignore) { }\n            }\n            if(!keep_html) { this.element.empty(); }\n            this.teardown();\n        },\n        /**\n         * Create a prototype node\n         * @name _create_prototype_node()\n         * @return {DOMElement}\n         */\n        _create_prototype_node : function () {\n            var _node = document.createElement('LI'), _temp1, _temp2;\n            _node.setAttribute('role', 'none');\n            _temp1 = document.createElement('I');\n            _temp1.className = 'jstree-icon jstree-ocl';\n            _temp1.setAttribute('role', 'presentation');\n            _node.appendChild(_temp1);\n            _temp1 = document.createElement('A');\n            _temp1.className = 'jstree-anchor';\n            _temp1.setAttribute('href','#');\n            _temp1.setAttribute('tabindex','-1');\n            _temp1.setAttribute('role', 'treeitem');\n            _temp2 = document.createElement('I');\n            _temp2.className = 'jstree-icon jstree-themeicon';\n            _temp2.setAttribute('role', 'presentation');\n            _temp1.appendChild(_temp2);\n            _node.appendChild(_temp1);\n            _temp1 = _temp2 = null;\n\n            return _node;\n        },\n        _kbevent_to_func : function (e) {\n            var keys = {\n                8: \"Backspace\", 9: \"Tab\", 13: \"Enter\", 19: \"Pause\", 27: \"Esc\",\n                32: \"Space\", 33: \"PageUp\", 34: \"PageDown\", 35: \"End\", 36: \"Home\",\n                37: \"Left\", 38: \"Up\", 39: \"Right\", 40: \"Down\", 44: \"Print\", 45: \"Insert\",\n                46: \"Delete\", 96: \"Numpad0\", 97: \"Numpad1\", 98: \"Numpad2\", 99 : \"Numpad3\",\n                100: \"Numpad4\", 101: \"Numpad5\", 102: \"Numpad6\", 103: \"Numpad7\",\n                104: \"Numpad8\", 105: \"Numpad9\", '-13': \"NumpadEnter\", 112: \"F1\",\n                113: \"F2\", 114: \"F3\", 115: \"F4\", 116: \"F5\", 117: \"F6\", 118: \"F7\",\n                119: \"F8\", 120: \"F9\", 121: \"F10\", 122: \"F11\", 123: \"F12\", 144: \"Numlock\",\n                145: \"Scrolllock\", 16: 'Shift', 17: 'Ctrl', 18: 'Alt',\n                48: '0',  49: '1',  50: '2',  51: '3',  52: '4', 53:  '5',\n                54: '6',  55: '7',  56: '8',  57: '9',  59: ';',  61: '=', 65:  'a',\n                66: 'b',  67: 'c',  68: 'd',  69: 'e',  70: 'f',  71: 'g', 72:  'h',\n                73: 'i',  74: 'j',  75: 'k',  76: 'l',  77: 'm',  78: 'n', 79:  'o',\n                80: 'p',  81: 'q',  82: 'r',  83: 's',  84: 't',  85: 'u', 86:  'v',\n                87: 'w',  88: 'x',  89: 'y',  90: 'z', 107: '+', 109: '-', 110: '.',\n                186: ';', 187: '=', 188: ',', 189: '-', 190: '.', 191: '/', 192: '`',\n                219: '[', 220: '\\\\',221: ']', 222: \"'\", 111: '/', 106: '*', 173: '-'\n            };\n            var parts = [];\n            if (e.ctrlKey) { parts.push('ctrl'); }\n            if (e.altKey) { parts.push('alt'); }\n            if (e.shiftKey) { parts.push('shift'); }\n            parts.push(keys[e.which] || e.which);\n            parts = parts.sort().join('-').toLowerCase();\n            if (parts === 'shift-shift' || parts === 'ctrl-ctrl' || parts === 'alt-alt') {\n                return null;\n            }\n\n            var kb = this.settings.core.keyboard, i, tmp;\n            for (i in kb) {\n                if (kb.hasOwnProperty(i)) {\n                    tmp = i;\n                    if (tmp !== '-' && tmp !== '+') {\n                        tmp = tmp.replace('--', '-MINUS').replace('+-', '-MINUS').replace('++', '-PLUS').replace('-+', '-PLUS');\n                        tmp = tmp.split(/-|\\+/).sort().join('-').replace('MINUS', '-').replace('PLUS', '+').toLowerCase();\n                    }\n                    if (tmp === parts) {\n                        return kb[i];\n                    }\n                }\n            }\n            return null;\n        },\n        /**\n         * part of the destroying of an instance. Used internally.\n         * @private\n         * @name teardown()\n         */\n        teardown : function () {\n            this.unbind();\n            this.element\n                .removeClass('jstree')\n                .removeData('jstree')\n                .find(\"[class^='jstree']\")\n                .addBack()\n                .attr(\"class\", function () { return this.className.replace(/jstree[^ ]*|$/ig,''); });\n            this.element = null;\n        },\n        /**\n         * bind all events. Used internally.\n         * @private\n         * @name bind()\n         */\n        bind : function () {\n            var word = '',\n                tout = null,\n                was_click = 0;\n            this.element\n                .on(\"dblclick.jstree\", function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(document.selection && document.selection.empty) {\n                        document.selection.empty();\n                    }\n                    else {\n                        if(window.getSelection) {\n                            var sel = window.getSelection();\n                            try {\n                                sel.removeAllRanges();\n                                sel.collapse();\n                            } catch (ignore) { }\n                        }\n                    }\n                })\n                .on(\"mousedown.jstree\", function (e) {\n                    if(e.target === this.element[0]) {\n                        e.preventDefault(); // prevent losing focus when clicking scroll arrows (FF, Chrome)\n                        was_click = +(new Date()); // ie does not allow to prevent losing focus\n                    }\n                }.bind(this))\n                .on(\"mousedown.jstree\", \".jstree-ocl\", function (e) {\n                    e.preventDefault(); // prevent any node inside from losing focus when clicking the open/close icon\n                })\n                .on(\"click.jstree\", \".jstree-ocl\", function (e) {\n                    this.toggle_node(e.target);\n                }.bind(this))\n                .on(\"dblclick.jstree\", \".jstree-anchor\", function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(this.settings.core.dblclick_toggle) {\n                        this.toggle_node(e.target);\n                    }\n                }.bind(this))\n                .on(\"click.jstree\", \".jstree-anchor\", function (e) {\n                    e.preventDefault();\n                    if(e.currentTarget !== document.activeElement) { $(e.currentTarget).trigger('focus'); }\n                    this.activate_node(e.currentTarget, e);\n                }.bind(this))\n                .on('keydown.jstree', '.jstree-anchor', function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(this._data.core.rtl) {\n                        if(e.which === 37) { e.which = 39; }\n                        else if(e.which === 39) { e.which = 37; }\n                    }\n                    var f = this._kbevent_to_func(e);\n                    if (f) {\n                        var r = f.call(this, e);\n                        if (r === false || r === true) {\n                            return r;\n                        }\n                    }\n                }.bind(this))\n                .on(\"load_node.jstree\", function (e, data) {\n                    if(data.status) {\n                        if(data.node.id === $.jstree.root && !this._data.core.loaded) {\n                            this._data.core.loaded = true;\n                            if(this._firstChild(this.get_container_ul()[0])) {\n                                this.element.attr('aria-activedescendant',this._firstChild(this.get_container_ul()[0]).id);\n                            }\n                            /**\n                             * triggered after the root node is loaded for the first time\n                             * @event\n                             * @name loaded.jstree\n                             */\n                            this.trigger(\"loaded\");\n                        }\n                        if(!this._data.core.ready) {\n                            setTimeout(function() {\n                                if(this.element && !this.get_container_ul().find('.jstree-loading').length) {\n                                    this._data.core.ready = true;\n                                    if(this._data.core.selected.length) {\n                                        if(this.settings.core.expand_selected_onload) {\n                                            var tmp = [], i, j;\n                                            for(i = 0, j = this._data.core.selected.length; i < j; i++) {\n                                                tmp = tmp.concat(this._model.data[this._data.core.selected[i]].parents);\n                                            }\n                                            tmp = $.vakata.array_unique(tmp);\n                                            for(i = 0, j = tmp.length; i < j; i++) {\n                                                this.open_node(tmp[i], false, 0);\n                                            }\n                                        }\n                                        this.trigger('changed', { 'action' : 'ready', 'selected' : this._data.core.selected });\n                                    }\n                                    /**\n                                     * triggered after all nodes are finished loading\n                                     * @event\n                                     * @name ready.jstree\n                                     */\n                                    this.trigger(\"ready\");\n                                }\n                            }.bind(this), 0);\n                        }\n                    }\n                }.bind(this))\n                // quick searching when the tree is focused\n                .on('keypress.jstree', function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(tout) { clearTimeout(tout); }\n                    tout = setTimeout(function () {\n                        word = '';\n                    }, 500);\n\n                    var chr = String.fromCharCode(e.which).toLowerCase(),\n                        col = this.element.find('.jstree-anchor').filter(':visible'),\n                        ind = col.index(document.activeElement) || 0,\n                        end = false;\n                    word += chr;\n\n                    // match for whole word from current node down (including the current node)\n                    if(word.length > 1) {\n                        col.slice(ind).each(function (i, v) {\n                            if($(v).text().toLowerCase().indexOf(word) === 0) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n\n                        // match for whole word from the beginning of the tree\n                        col.slice(0, ind).each(function (i, v) {\n                            if($(v).text().toLowerCase().indexOf(word) === 0) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n                    }\n                    // list nodes that start with that letter (only if word consists of a single char)\n                    if(new RegExp('^' + chr.replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g, '\\\\$&') + '+$').test(word)) {\n                        // search for the next node starting with that letter\n                        col.slice(ind + 1).each(function (i, v) {\n                            if($(v).text().toLowerCase().charAt(0) === chr) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n\n                        // search from the beginning\n                        col.slice(0, ind + 1).each(function (i, v) {\n                            if($(v).text().toLowerCase().charAt(0) === chr) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n                    }\n                }.bind(this))\n                // THEME RELATED\n                .on(\"init.jstree\", function () {\n                    var s = this.settings.core.themes;\n                    this._data.core.themes.dots\t\t\t= s.dots;\n                    this._data.core.themes.stripes\t\t= s.stripes;\n                    this._data.core.themes.icons\t\t= s.icons;\n                    this._data.core.themes.ellipsis\t\t= s.ellipsis;\n                    this.set_theme(s.name || \"default\", s.url);\n                    this.set_theme_variant(s.variant);\n                }.bind(this))\n                .on(\"loading.jstree\", function () {\n                    this[ this._data.core.themes.dots ? \"show_dots\" : \"hide_dots\" ]();\n                    this[ this._data.core.themes.icons ? \"show_icons\" : \"hide_icons\" ]();\n                    this[ this._data.core.themes.stripes ? \"show_stripes\" : \"hide_stripes\" ]();\n                    this[ this._data.core.themes.ellipsis ? \"show_ellipsis\" : \"hide_ellipsis\" ]();\n                }.bind(this))\n                .on('blur.jstree', '.jstree-anchor', function (e) {\n                    this._data.core.focused = null;\n                    $(e.currentTarget).filter('.jstree-hovered').trigger('mouseleave');\n                    this.element.attr('tabindex', '0');\n                }.bind(this))\n                .on('focus.jstree', '.jstree-anchor', function (e) {\n                    var tmp = this.get_node(e.currentTarget);\n                    if(tmp && tmp.id) {\n                        this._data.core.focused = tmp.id;\n                    }\n                    this.element.find('.jstree-hovered').not(e.currentTarget).trigger('mouseleave');\n                    $(e.currentTarget).trigger('mouseenter');\n                    this.element.attr('tabindex', '-1');\n                }.bind(this))\n                .on('focus.jstree', function () {\n                    if(+(new Date()) - was_click > 500 && !this._data.core.focused && this.settings.core.restore_focus) {\n                        was_click = 0;\n                        var act = this.get_node(this.element.attr('aria-activedescendant'), true);\n                        if(act) {\n                            act.find('> .jstree-anchor').trigger('focus');\n                        }\n                    }\n                }.bind(this))\n                .on('mouseenter.jstree', '.jstree-anchor', function (e) {\n                    this.hover_node(e.currentTarget);\n                }.bind(this))\n                .on('mouseleave.jstree', '.jstree-anchor', function (e) {\n                    this.dehover_node(e.currentTarget);\n                }.bind(this));\n        },\n        /**\n         * part of the destroying of an instance. Used internally.\n         * @private\n         * @name unbind()\n         */\n        unbind : function () {\n            this.element.off('.jstree');\n            $(document).off('.jstree-' + this._id);\n        },\n        /**\n         * trigger an event. Used internally.\n         * @private\n         * @name trigger(ev [, data])\n         * @param  {String} ev the name of the event to trigger\n         * @param  {Object} data additional data to pass with the event\n         */\n        trigger : function (ev, data) {\n            if(!data) {\n                data = {};\n            }\n            data.instance = this;\n            this.element.triggerHandler(ev.replace('.jstree','') + '.jstree', data);\n        },\n        /**\n         * returns the jQuery extended instance container\n         * @name get_container()\n         * @return {jQuery}\n         */\n        get_container : function () {\n            return this.element;\n        },\n        /**\n         * returns the jQuery extended main UL node inside the instance container. Used internally.\n         * @private\n         * @name get_container_ul()\n         * @return {jQuery}\n         */\n        get_container_ul : function () {\n            return this.element.children(\".jstree-children\").first();\n        },\n        /**\n         * gets string replacements (localization). Used internally.\n         * @private\n         * @name get_string(key)\n         * @param  {String} key\n         * @return {String}\n         */\n        get_string : function (key) {\n            var a = this.settings.core.strings;\n            if($.vakata.is_function(a)) { return a.call(this, key); }\n            if(a && a[key]) { return a[key]; }\n            return key;\n        },\n        /**\n         * gets the first child of a DOM node. Used internally.\n         * @private\n         * @name _firstChild(dom)\n         * @param  {DOMElement} dom\n         * @return {DOMElement}\n         */\n        _firstChild : function (dom) {\n            dom = dom ? dom.firstChild : null;\n            while(dom !== null && dom.nodeType !== 1) {\n                dom = dom.nextSibling;\n            }\n            return dom;\n        },\n        /**\n         * gets the next sibling of a DOM node. Used internally.\n         * @private\n         * @name _nextSibling(dom)\n         * @param  {DOMElement} dom\n         * @return {DOMElement}\n         */\n        _nextSibling : function (dom) {\n            dom = dom ? dom.nextSibling : null;\n            while(dom !== null && dom.nodeType !== 1) {\n                dom = dom.nextSibling;\n            }\n            return dom;\n        },\n        /**\n         * gets the previous sibling of a DOM node. Used internally.\n         * @private\n         * @name _previousSibling(dom)\n         * @param  {DOMElement} dom\n         * @return {DOMElement}\n         */\n        _previousSibling : function (dom) {\n            dom = dom ? dom.previousSibling : null;\n            while(dom !== null && dom.nodeType !== 1) {\n                dom = dom.previousSibling;\n            }\n            return dom;\n        },\n        /**\n         * get the JSON representation of a node (or the actual jQuery extended DOM node) by using any input (child DOM element, ID string, selector, etc)\n         * @name get_node(obj [, as_dom])\n         * @param  {mixed} obj\n         * @param  {Boolean} as_dom\n         * @return {Object|jQuery}\n         */\n        get_node : function (obj, as_dom) {\n            if(obj && obj.id) {\n                obj = obj.id;\n            }\n            if (obj instanceof $ && obj.length && obj[0].id) {\n                obj = obj[0].id;\n            }\n            var dom;\n            try {\n                if(this._model.data[obj]) {\n                    obj = this._model.data[obj];\n                }\n                else if(typeof obj === \"string\" && this._model.data[obj.replace(/^#/, '')]) {\n                    obj = this._model.data[obj.replace(/^#/, '')];\n                }\n                else if(typeof obj === \"string\" && (dom = $('#' + obj.replace($.jstree.idregex,'\\\\$&'), this.element)).length && this._model.data[dom.closest('.jstree-node').attr('id')]) {\n                    obj = this._model.data[dom.closest('.jstree-node').attr('id')];\n                }\n                else if((dom = this.element.find(obj)).length && this._model.data[dom.closest('.jstree-node').attr('id')]) {\n                    obj = this._model.data[dom.closest('.jstree-node').attr('id')];\n                }\n                else if((dom = this.element.find(obj)).length && dom.hasClass('jstree')) {\n                    obj = this._model.data[$.jstree.root];\n                }\n                else {\n                    return false;\n                }\n\n                if(as_dom) {\n                    obj = obj.id === $.jstree.root ? this.element : $('#' + obj.id.replace($.jstree.idregex,'\\\\$&'), this.element);\n                }\n                return obj;\n            } catch (ex) { return false; }\n        },\n        /**\n         * get the path to a node, either consisting of node texts, or of node IDs, optionally glued together (otherwise an array)\n         * @name get_path(obj [, glue, ids])\n         * @param  {mixed} obj the node\n         * @param  {String} glue if you want the path as a string - pass the glue here (for example '/'), if a falsy value is supplied here, an array is returned\n         * @param  {Boolean} ids if set to true build the path using ID, otherwise node text is used\n         * @return {mixed}\n         */\n        get_path : function (obj, glue, ids) {\n            obj = obj.parents ? obj : this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root || !obj.parents) {\n                return false;\n            }\n            var i, j, p = [];\n            p.push(ids ? obj.id : obj.text);\n            for(i = 0, j = obj.parents.length; i < j; i++) {\n                p.push(ids ? obj.parents[i] : this.get_text(obj.parents[i]));\n            }\n            p = p.reverse().slice(1);\n            return glue ? p.join(glue) : p;\n        },\n        /**\n         * get the next visible node that is below the `obj` node. If `strict` is set to `true` only sibling nodes are returned.\n         * @name get_next_dom(obj [, strict])\n         * @param  {mixed} obj\n         * @param  {Boolean} strict\n         * @return {jQuery}\n         */\n        get_next_dom : function (obj, strict) {\n            var tmp;\n            obj = this.get_node(obj, true);\n            if(obj[0] === this.element[0]) {\n                tmp = this._firstChild(this.get_container_ul()[0]);\n                while (tmp && tmp.offsetHeight === 0) {\n                    tmp = this._nextSibling(tmp);\n                }\n                return tmp ? $(tmp) : false;\n            }\n            if(!obj || !obj.length) {\n                return false;\n            }\n            if(strict) {\n                tmp = obj[0];\n                do {\n                    tmp = this._nextSibling(tmp);\n                } while (tmp && tmp.offsetHeight === 0);\n                return tmp ? $(tmp) : false;\n            }\n            if(obj.hasClass(\"jstree-open\")) {\n                tmp = this._firstChild(obj.children('.jstree-children')[0]);\n                while (tmp && tmp.offsetHeight === 0) {\n                    tmp = this._nextSibling(tmp);\n                }\n                if(tmp !== null) {\n                    return $(tmp);\n                }\n            }\n            tmp = obj[0];\n            do {\n                tmp = this._nextSibling(tmp);\n            } while (tmp && tmp.offsetHeight === 0);\n            if(tmp !== null) {\n                return $(tmp);\n            }\n            return obj.parentsUntil(\".jstree\",\".jstree-node\").nextAll(\".jstree-node:visible\").first();\n        },\n        /**\n         * get the previous visible node that is above the `obj` node. If `strict` is set to `true` only sibling nodes are returned.\n         * @name get_prev_dom(obj [, strict])\n         * @param  {mixed} obj\n         * @param  {Boolean} strict\n         * @return {jQuery}\n         */\n        get_prev_dom : function (obj, strict) {\n            var tmp;\n            obj = this.get_node(obj, true);\n            if(obj[0] === this.element[0]) {\n                tmp = this.get_container_ul()[0].lastChild;\n                while (tmp && tmp.offsetHeight === 0) {\n                    tmp = this._previousSibling(tmp);\n                }\n                return tmp ? $(tmp) : false;\n            }\n            if(!obj || !obj.length) {\n                return false;\n            }\n            if(strict) {\n                tmp = obj[0];\n                do {\n                    tmp = this._previousSibling(tmp);\n                } while (tmp && tmp.offsetHeight === 0);\n                return tmp ? $(tmp) : false;\n            }\n            tmp = obj[0];\n            do {\n                tmp = this._previousSibling(tmp);\n            } while (tmp && tmp.offsetHeight === 0);\n            if(tmp !== null) {\n                obj = $(tmp);\n                while(obj.hasClass(\"jstree-open\")) {\n                    obj = obj.children(\".jstree-children\").first().children(\".jstree-node:visible:last\");\n                }\n                return obj;\n            }\n            tmp = obj[0].parentNode.parentNode;\n            return tmp && tmp.className && tmp.className.indexOf('jstree-node') !== -1 ? $(tmp) : false;\n        },\n        /**\n         * get the parent ID of a node\n         * @name get_parent(obj)\n         * @param  {mixed} obj\n         * @return {String}\n         */\n        get_parent : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            return obj.parent;\n        },\n        /**\n         * get a jQuery collection of all the children of a node (node must be rendered), returns false on error\n         * @name get_children_dom(obj)\n         * @param  {mixed} obj\n         * @return {jQuery}\n         */\n        get_children_dom : function (obj) {\n            obj = this.get_node(obj, true);\n            if(obj[0] === this.element[0]) {\n                return this.get_container_ul().children(\".jstree-node\");\n            }\n            if(!obj || !obj.length) {\n                return false;\n            }\n            return obj.children(\".jstree-children\").children(\".jstree-node\");\n        },\n        /**\n         * checks if a node has children\n         * @name is_parent(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_parent : function (obj) {\n            obj = this.get_node(obj);\n            return obj && (obj.state.loaded === false || obj.children.length > 0);\n        },\n        /**\n         * checks if a node is loaded (its children are available)\n         * @name is_loaded(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_loaded : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state.loaded;\n        },\n        /**\n         * check if a node is currently loading (fetching children)\n         * @name is_loading(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_loading : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state && obj.state.loading;\n        },\n        /**\n         * check if a node is opened\n         * @name is_open(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_open : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state.opened;\n        },\n        /**\n         * check if a node is in a closed state\n         * @name is_closed(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_closed : function (obj) {\n            obj = this.get_node(obj);\n            return obj && this.is_parent(obj) && !obj.state.opened;\n        },\n        /**\n         * check if a node has no children\n         * @name is_leaf(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_leaf : function (obj) {\n            return !this.is_parent(obj);\n        },\n        /**\n         * loads a node (fetches its children using the `core.data` setting). Multiple nodes can be passed to by using an array.\n         * @name load_node(obj [, callback])\n         * @param  {mixed} obj\n         * @param  {function} callback a function to be executed once loading is complete, the function is executed in the instance's scope and receives two arguments - the node and a boolean status\n         * @return {Boolean}\n         * @trigger load_node.jstree\n         */\n        load_node : function (obj, callback) {\n            var k, l, i, j, c;\n            if($.vakata.is_array(obj)) {\n                this._load_nodes(obj.slice(), callback);\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj) {\n                if(callback) { callback.call(this, obj, false); }\n                return false;\n            }\n            // if(obj.state.loading) { } // the node is already loading - just wait for it to load and invoke callback? but if called implicitly it should be loaded again?\n            if(obj.state.loaded) {\n                obj.state.loaded = false;\n                for(i = 0, j = obj.parents.length; i < j; i++) {\n                    this._model.data[obj.parents[i]].children_d = $.vakata.array_filter(this._model.data[obj.parents[i]].children_d, function (v) {\n                        return $.inArray(v, obj.children_d) === -1;\n                    });\n                }\n                for(k = 0, l = obj.children_d.length; k < l; k++) {\n                    if(this._model.data[obj.children_d[k]].state.selected) {\n                        c = true;\n                    }\n                    delete this._model.data[obj.children_d[k]];\n                }\n                if (c) {\n                    this._data.core.selected = $.vakata.array_filter(this._data.core.selected, function (v) {\n                        return $.inArray(v, obj.children_d) === -1;\n                    });\n                }\n                obj.children = [];\n                obj.children_d = [];\n                if(c) {\n                    this.trigger('changed', { 'action' : 'load_node', 'node' : obj, 'selected' : this._data.core.selected });\n                }\n            }\n            obj.state.failed = false;\n            obj.state.loading = true;\n            this.get_node(obj, true).addClass(\"jstree-loading\").attr('aria-busy',true);\n            this._load_node(obj, function (status) {\n                obj = this._model.data[obj.id];\n                obj.state.loading = false;\n                obj.state.loaded = status;\n                obj.state.failed = !obj.state.loaded;\n                var dom = this.get_node(obj, true), i = 0, j = 0, m = this._model.data, has_children = false;\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    if(m[obj.children[i]] && !m[obj.children[i]].state.hidden) {\n                        has_children = true;\n                        break;\n                    }\n                }\n                if(obj.state.loaded && dom && dom.length) {\n                    dom.removeClass('jstree-closed jstree-open jstree-leaf');\n                    if (!has_children) {\n                        dom.addClass('jstree-leaf');\n                    }\n                    else {\n                        if (obj.id !== '#') {\n                            dom.addClass(obj.state.opened ? 'jstree-open' : 'jstree-closed');\n                        }\n                    }\n                }\n                dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                /**\n                 * triggered after a node is loaded\n                 * @event\n                 * @name load_node.jstree\n                 * @param {Object} node the node that was loading\n                 * @param {Boolean} status was the node loaded successfully\n                 */\n                this.trigger('load_node', { \"node\" : obj, \"status\" : status });\n                if(callback) {\n                    callback.call(this, obj, status);\n                }\n            }.bind(this));\n            return true;\n        },\n        /**\n         * load an array of nodes (will also load unavailable nodes as soon as they appear in the structure). Used internally.\n         * @private\n         * @name _load_nodes(nodes [, callback])\n         * @param  {array} nodes\n         * @param  {function} callback a function to be executed once loading is complete, the function is executed in the instance's scope and receives one argument - the array passed to _load_nodes\n         */\n        _load_nodes : function (nodes, callback, is_callback, force_reload) {\n            var r = true,\n                c = function () { this._load_nodes(nodes, callback, true); },\n                m = this._model.data, i, j, tmp = [];\n            for(i = 0, j = nodes.length; i < j; i++) {\n                if(m[nodes[i]] && ( (!m[nodes[i]].state.loaded && !m[nodes[i]].state.failed) || (!is_callback && force_reload) )) {\n                    if(!this.is_loading(nodes[i])) {\n                        this.load_node(nodes[i], c);\n                    }\n                    r = false;\n                }\n            }\n            if(r) {\n                for(i = 0, j = nodes.length; i < j; i++) {\n                    if(m[nodes[i]] && m[nodes[i]].state.loaded) {\n                        tmp.push(nodes[i]);\n                    }\n                }\n                if(callback && !callback.done) {\n                    callback.call(this, tmp);\n                    callback.done = true;\n                }\n            }\n        },\n        /**\n         * loads all unloaded nodes\n         * @name load_all([obj, callback])\n         * @param {mixed} obj the node to load recursively, omit to load all nodes in the tree\n         * @param {function} callback a function to be executed once loading all the nodes is complete,\n         * @trigger load_all.jstree\n         */\n        load_all : function (obj, callback) {\n            if(!obj) { obj = $.jstree.root; }\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var to_load = [],\n                m = this._model.data,\n                c = m[obj.id].children_d,\n                i, j;\n            if(obj.state && !obj.state.loaded) {\n                to_load.push(obj.id);\n            }\n            for(i = 0, j = c.length; i < j; i++) {\n                if(m[c[i]] && m[c[i]].state && !m[c[i]].state.loaded) {\n                    to_load.push(c[i]);\n                }\n            }\n            if(to_load.length) {\n                this._load_nodes(to_load, function () {\n                    this.load_all(obj, callback);\n                });\n            }\n            else {\n                /**\n                 * triggered after a load_all call completes\n                 * @event\n                 * @name load_all.jstree\n                 * @param {Object} node the recursively loaded node\n                 */\n                if(callback) { callback.call(this, obj); }\n                this.trigger('load_all', { \"node\" : obj });\n            }\n        },\n        /**\n         * handles the actual loading of a node. Used only internally.\n         * @private\n         * @name _load_node(obj [, callback])\n         * @param  {mixed} obj\n         * @param  {function} callback a function to be executed once loading is complete, the function is executed in the instance's scope and receives one argument - a boolean status\n         * @return {Boolean}\n         */\n        _load_node : function (obj, callback) {\n            var s = this.settings.core.data, t;\n            var notTextOrCommentNode = function notTextOrCommentNode () {\n                return this.nodeType !== 3 && this.nodeType !== 8;\n            };\n            // use original HTML\n            if(!s) {\n                if(obj.id === $.jstree.root) {\n                    return this._append_html_data(obj, this._data.core.original_container_html.clone(true), function (status) {\n                        callback.call(this, status);\n                    });\n                }\n                else {\n                    return callback.call(this, false);\n                }\n                // return callback.call(this, obj.id === $.jstree.root ? this._append_html_data(obj, this._data.core.original_container_html.clone(true)) : false);\n            }\n            if($.vakata.is_function(s)) {\n                return s.call(this, obj, function (d) {\n                    if(d === false) {\n                        callback.call(this, false);\n                    }\n                    else {\n                        this[typeof d === 'string' ? '_append_html_data' : '_append_json_data'](obj, typeof d === 'string' ? $($.parseHTML(d)).filter(notTextOrCommentNode) : d, function (status) {\n                            callback.call(this, status);\n                        });\n                    }\n                    // return d === false ? callback.call(this, false) : callback.call(this, this[typeof d === 'string' ? '_append_html_data' : '_append_json_data'](obj, typeof d === 'string' ? $(d) : d));\n                }.bind(this));\n            }\n            if(typeof s === 'object') {\n                if(s.url) {\n                    s = $.extend(true, {}, s);\n                    if($.vakata.is_function(s.url)) {\n                        s.url = s.url.call(this, obj);\n                    }\n                    if($.vakata.is_function(s.data)) {\n                        s.data = s.data.call(this, obj);\n                    }\n                    return $.ajax(s)\n                        .done(function (d,t,x) {\n                            var type = x.getResponseHeader('Content-Type');\n                            if((type && type.indexOf('json') !== -1) || typeof d === \"object\") {\n                                return this._append_json_data(obj, d, function (status) { callback.call(this, status); });\n                                //return callback.call(this, this._append_json_data(obj, d));\n                            }\n                            if((type && type.indexOf('html') !== -1) || typeof d === \"string\") {\n                                return this._append_html_data(obj, $($.parseHTML(d)).filter(notTextOrCommentNode), function (status) { callback.call(this, status); });\n                                // return callback.call(this, this._append_html_data(obj, $(d)));\n                            }\n                            this._data.core.last_error = { 'error' : 'ajax', 'plugin' : 'core', 'id' : 'core_04', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id, 'xhr' : x }) };\n                            this.settings.core.error.call(this, this._data.core.last_error);\n                            return callback.call(this, false);\n                        }.bind(this))\n                        .fail(function (f) {\n                            this._data.core.last_error = { 'error' : 'ajax', 'plugin' : 'core', 'id' : 'core_04', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id, 'xhr' : f }) };\n                            callback.call(this, false);\n                            this.settings.core.error.call(this, this._data.core.last_error);\n                        }.bind(this));\n                }\n                if ($.vakata.is_array(s)) {\n                    t = $.extend(true, [], s);\n                } else if ($.isPlainObject(s)) {\n                    t = $.extend(true, {}, s);\n                } else {\n                    t = s;\n                }\n                if(obj.id === $.jstree.root) {\n                    return this._append_json_data(obj, t, function (status) {\n                        callback.call(this, status);\n                    });\n                }\n                else {\n                    this._data.core.last_error = { 'error' : 'nodata', 'plugin' : 'core', 'id' : 'core_05', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id }) };\n                    this.settings.core.error.call(this, this._data.core.last_error);\n                    return callback.call(this, false);\n                }\n                //return callback.call(this, (obj.id === $.jstree.root ? this._append_json_data(obj, t) : false) );\n            }\n            if(typeof s === 'string') {\n                if(obj.id === $.jstree.root) {\n                    return this._append_html_data(obj, $($.parseHTML(s)).filter(notTextOrCommentNode), function (status) {\n                        callback.call(this, status);\n                    });\n                }\n                else {\n                    this._data.core.last_error = { 'error' : 'nodata', 'plugin' : 'core', 'id' : 'core_06', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id }) };\n                    this.settings.core.error.call(this, this._data.core.last_error);\n                    return callback.call(this, false);\n                }\n                //return callback.call(this, (obj.id === $.jstree.root ? this._append_html_data(obj, $(s)) : false) );\n            }\n            return callback.call(this, false);\n        },\n        /**\n         * adds a node to the list of nodes to redraw. Used only internally.\n         * @private\n         * @name _node_changed(obj [, callback])\n         * @param  {mixed} obj\n         */\n        _node_changed : function (obj) {\n            obj = this.get_node(obj);\n            if (obj && $.inArray(obj.id, this._model.changed) === -1) {\n                this._model.changed.push(obj.id);\n            }\n        },\n        /**\n         * appends HTML content to the tree. Used internally.\n         * @private\n         * @name _append_html_data(obj, data)\n         * @param  {mixed} obj the node to append to\n         * @param  {String} data the HTML string to parse and append\n         * @trigger model.jstree, changed.jstree\n         */\n        _append_html_data : function (dom, data, cb) {\n            dom = this.get_node(dom);\n            dom.children = [];\n            dom.children_d = [];\n            var dat = data.is('ul') ? data.children() : data,\n                par = dom.id,\n                chd = [],\n                dpc = [],\n                m = this._model.data,\n                p = m[par],\n                s = this._data.core.selected.length,\n                tmp, i, j;\n            dat.each(function (i, v) {\n                tmp = this._parse_model_from_html($(v), par, p.parents.concat());\n                if(tmp) {\n                    chd.push(tmp);\n                    dpc.push(tmp);\n                    if(m[tmp].children_d.length) {\n                        dpc = dpc.concat(m[tmp].children_d);\n                    }\n                }\n            }.bind(this));\n            p.children = chd;\n            p.children_d = dpc;\n            for(i = 0, j = p.parents.length; i < j; i++) {\n                m[p.parents[i]].children_d = m[p.parents[i]].children_d.concat(dpc);\n            }\n            /**\n             * triggered when new data is inserted to the tree model\n             * @event\n             * @name model.jstree\n             * @param {Array} nodes an array of node IDs\n             * @param {String} parent the parent ID of the nodes\n             */\n            this.trigger('model', { \"nodes\" : dpc, 'parent' : par });\n            if(par !== $.jstree.root) {\n                this._node_changed(par);\n                this.redraw();\n            }\n            else {\n                this.get_container_ul().children('.jstree-initial-node').remove();\n                this.redraw(true);\n            }\n            if(this._data.core.selected.length !== s) {\n                this.trigger('changed', { 'action' : 'model', 'selected' : this._data.core.selected });\n            }\n            cb.call(this, true);\n        },\n        /**\n         * appends JSON content to the tree. Used internally.\n         * @private\n         * @name _append_json_data(obj, data)\n         * @param  {mixed} obj the node to append to\n         * @param  {String} data the JSON object to parse and append\n         * @param  {Boolean} force_processing internal param - do not set\n         * @trigger model.jstree, changed.jstree\n         */\n        _append_json_data : function (dom, data, cb, force_processing) {\n            if(this.element === null) { return; }\n            dom = this.get_node(dom);\n            dom.children = [];\n            dom.children_d = [];\n            // *%$@!!!\n            if(data.d) {\n                data = data.d;\n                if(typeof data === \"string\") {\n                    data = JSON.parse(data);\n                }\n            }\n            if(!$.vakata.is_array(data)) { data = [data]; }\n            var w = null,\n                args = {\n                    'df'\t: this._model.default_state,\n                    'dat'\t: data,\n                    'par'\t: dom.id,\n                    'm'\t\t: this._model.data,\n                    't_id'\t: this._id,\n                    't_cnt'\t: this._cnt,\n                    'sel'\t: this._data.core.selected\n                },\n                inst = this,\n                func = function (data, undefined) {\n                    if(data.data) { data = data.data; }\n                    var dat = data.dat,\n                        par = data.par,\n                        chd = [],\n                        dpc = [],\n                        add = [],\n                        df = data.df,\n                        t_id = data.t_id,\n                        t_cnt = data.t_cnt,\n                        m = data.m,\n                        p = m[par],\n                        sel = data.sel,\n                        tmp, i, j, rslt,\n                        parse_flat = function (d, p, ps) {\n                            if(!ps) { ps = []; }\n                            else { ps = ps.concat(); }\n                            if(p) { ps.unshift(p); }\n                            var tid = d.id.toString(),\n                                i, j, c, e,\n                                tmp = {\n                                    id\t\t\t: tid,\n                                    text\t\t: d.text || '',\n                                    icon\t\t: d.icon !== undefined ? d.icon : true,\n                                    parent\t\t: p,\n                                    parents\t\t: ps,\n                                    children\t: d.children || [],\n                                    children_d\t: d.children_d || [],\n                                    data\t\t: d.data,\n                                    state\t\t: { },\n                                    li_attr\t\t: { id : false },\n                                    a_attr\t\t: { href : '#' },\n                                    original\t: false\n                                };\n                            for(i in df) {\n                                if(df.hasOwnProperty(i)) {\n                                    tmp.state[i] = df[i];\n                                }\n                            }\n                            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                                tmp.icon = d.data.jstree.icon;\n                            }\n                            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                                tmp.icon = true;\n                            }\n                            if(d && d.data) {\n                                tmp.data = d.data;\n                                if(d.data.jstree) {\n                                    for(i in d.data.jstree) {\n                                        if(d.data.jstree.hasOwnProperty(i)) {\n                                            tmp.state[i] = d.data.jstree[i];\n                                        }\n                                    }\n                                }\n                            }\n                            if(d && typeof d.state === 'object') {\n                                for (i in d.state) {\n                                    if(d.state.hasOwnProperty(i)) {\n                                        tmp.state[i] = d.state[i];\n                                    }\n                                }\n                            }\n                            if(d && typeof d.li_attr === 'object') {\n                                for (i in d.li_attr) {\n                                    if(d.li_attr.hasOwnProperty(i)) {\n                                        tmp.li_attr[i] = d.li_attr[i];\n                                    }\n                                }\n                            }\n                            if(!tmp.li_attr.id) {\n                                tmp.li_attr.id = tid;\n                            }\n                            if(d && typeof d.a_attr === 'object') {\n                                for (i in d.a_attr) {\n                                    if(d.a_attr.hasOwnProperty(i)) {\n                                        tmp.a_attr[i] = d.a_attr[i];\n                                    }\n                                }\n                            }\n                            if(d && d.children && d.children === true) {\n                                tmp.state.loaded = false;\n                                tmp.children = [];\n                                tmp.children_d = [];\n                            }\n                            m[tmp.id] = tmp;\n                            for(i = 0, j = tmp.children.length; i < j; i++) {\n                                c = parse_flat(m[tmp.children[i]], tmp.id, ps);\n                                e = m[c];\n                                tmp.children_d.push(c);\n                                if(e.children_d.length) {\n                                    tmp.children_d = tmp.children_d.concat(e.children_d);\n                                }\n                            }\n                            delete d.data;\n                            delete d.children;\n                            m[tmp.id].original = d;\n                            if(tmp.state.selected) {\n                                add.push(tmp.id);\n                            }\n                            return tmp.id;\n                        },\n                        parse_nest = function (d, p, ps) {\n                            if(!ps) { ps = []; }\n                            else { ps = ps.concat(); }\n                            if(p) { ps.unshift(p); }\n                            var tid = false, i, j, c, e, tmp;\n                            do {\n                                tid = 'j' + t_id + '_' + (++t_cnt);\n                            } while(m[tid]);\n\n                            tmp = {\n                                id\t\t\t: false,\n                                text\t\t: typeof d === 'string' ? d : '',\n                                icon\t\t: typeof d === 'object' && d.icon !== undefined ? d.icon : true,\n                                parent\t\t: p,\n                                parents\t\t: ps,\n                                children\t: [],\n                                children_d\t: [],\n                                data\t\t: null,\n                                state\t\t: { },\n                                li_attr\t\t: { id : false },\n                                a_attr\t\t: { href : '#' },\n                                original\t: false\n                            };\n                            for(i in df) {\n                                if(df.hasOwnProperty(i)) {\n                                    tmp.state[i] = df[i];\n                                }\n                            }\n                            if(d && d.id) { tmp.id = d.id.toString(); }\n                            if(d && d.text) { tmp.text = d.text; }\n                            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                                tmp.icon = d.data.jstree.icon;\n                            }\n                            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                                tmp.icon = true;\n                            }\n                            if(d && d.data) {\n                                tmp.data = d.data;\n                                if(d.data.jstree) {\n                                    for(i in d.data.jstree) {\n                                        if(d.data.jstree.hasOwnProperty(i)) {\n                                            tmp.state[i] = d.data.jstree[i];\n                                        }\n                                    }\n                                }\n                            }\n                            if(d && typeof d.state === 'object') {\n                                for (i in d.state) {\n                                    if(d.state.hasOwnProperty(i)) {\n                                        tmp.state[i] = d.state[i];\n                                    }\n                                }\n                            }\n                            if(d && typeof d.li_attr === 'object') {\n                                for (i in d.li_attr) {\n                                    if(d.li_attr.hasOwnProperty(i)) {\n                                        tmp.li_attr[i] = d.li_attr[i];\n                                    }\n                                }\n                            }\n                            if(tmp.li_attr.id && !tmp.id) {\n                                tmp.id = tmp.li_attr.id.toString();\n                            }\n                            if(!tmp.id) {\n                                tmp.id = tid;\n                            }\n                            if(!tmp.li_attr.id) {\n                                tmp.li_attr.id = tmp.id;\n                            }\n                            if(d && typeof d.a_attr === 'object') {\n                                for (i in d.a_attr) {\n                                    if(d.a_attr.hasOwnProperty(i)) {\n                                        tmp.a_attr[i] = d.a_attr[i];\n                                    }\n                                }\n                            }\n                            if(d && d.children && d.children.length) {\n                                for(i = 0, j = d.children.length; i < j; i++) {\n                                    c = parse_nest(d.children[i], tmp.id, ps);\n                                    e = m[c];\n                                    tmp.children.push(c);\n                                    if(e.children_d.length) {\n                                        tmp.children_d = tmp.children_d.concat(e.children_d);\n                                    }\n                                }\n                                tmp.children_d = tmp.children_d.concat(tmp.children);\n                            }\n                            if(d && d.children && d.children === true) {\n                                tmp.state.loaded = false;\n                                tmp.children = [];\n                                tmp.children_d = [];\n                            }\n                            delete d.data;\n                            delete d.children;\n                            tmp.original = d;\n                            m[tmp.id] = tmp;\n                            if(tmp.state.selected) {\n                                add.push(tmp.id);\n                            }\n                            return tmp.id;\n                        };\n\n                    if(dat.length && dat[0].id !== undefined && dat[0].parent !== undefined) {\n                        // Flat JSON support (for easy import from DB):\n                        // 1) convert to object (foreach)\n                        for(i = 0, j = dat.length; i < j; i++) {\n                            if(!dat[i].children) {\n                                dat[i].children = [];\n                            }\n                            if(!dat[i].state) {\n                                dat[i].state = {};\n                            }\n                            m[dat[i].id.toString()] = dat[i];\n                        }\n                        // 2) populate children (foreach)\n                        for(i = 0, j = dat.length; i < j; i++) {\n                            if (!m[dat[i].parent.toString()]) {\n                                if (typeof inst !== \"undefined\") {\n                                    inst._data.core.last_error = { 'error' : 'parse', 'plugin' : 'core', 'id' : 'core_07', 'reason' : 'Node with invalid parent', 'data' : JSON.stringify({ 'id' : dat[i].id.toString(), 'parent' : dat[i].parent.toString() }) };\n                                    inst.settings.core.error.call(inst, inst._data.core.last_error);\n                                }\n                                continue;\n                            }\n\n                            m[dat[i].parent.toString()].children.push(dat[i].id.toString());\n                            // populate parent.children_d\n                            p.children_d.push(dat[i].id.toString());\n                        }\n                        // 3) normalize && populate parents and children_d with recursion\n                        for(i = 0, j = p.children.length; i < j; i++) {\n                            tmp = parse_flat(m[p.children[i]], par, p.parents.concat());\n                            dpc.push(tmp);\n                            if(m[tmp].children_d.length) {\n                                dpc = dpc.concat(m[tmp].children_d);\n                            }\n                        }\n                        for(i = 0, j = p.parents.length; i < j; i++) {\n                            m[p.parents[i]].children_d = m[p.parents[i]].children_d.concat(dpc);\n                        }\n                        // ?) three_state selection - p.state.selected && t - (if three_state foreach(dat => ch) -> foreach(parents) if(parent.selected) child.selected = true;\n                        rslt = {\n                            'cnt' : t_cnt,\n                            'mod' : m,\n                            'sel' : sel,\n                            'par' : par,\n                            'dpc' : dpc,\n                            'add' : add\n                        };\n                    }\n                    else {\n                        for(i = 0, j = dat.length; i < j; i++) {\n                            tmp = parse_nest(dat[i], par, p.parents.concat());\n                            if(tmp) {\n                                chd.push(tmp);\n                                dpc.push(tmp);\n                                if(m[tmp].children_d.length) {\n                                    dpc = dpc.concat(m[tmp].children_d);\n                                }\n                            }\n                        }\n                        p.children = chd;\n                        p.children_d = dpc;\n                        for(i = 0, j = p.parents.length; i < j; i++) {\n                            m[p.parents[i]].children_d = m[p.parents[i]].children_d.concat(dpc);\n                        }\n                        rslt = {\n                            'cnt' : t_cnt,\n                            'mod' : m,\n                            'sel' : sel,\n                            'par' : par,\n                            'dpc' : dpc,\n                            'add' : add\n                        };\n                    }\n                    if(typeof window === 'undefined' || typeof window.document === 'undefined') {\n                        postMessage(rslt);\n                    }\n                    else {\n                        return rslt;\n                    }\n                },\n                rslt = function (rslt, worker) {\n                    if(this.element === null) { return; }\n                    this._cnt = rslt.cnt;\n                    var i, m = this._model.data;\n                    for (i in m) {\n                        if (m.hasOwnProperty(i) && m[i].state && m[i].state.loading && rslt.mod[i]) {\n                            rslt.mod[i].state.loading = true;\n                        }\n                    }\n                    this._model.data = rslt.mod; // breaks the reference in load_node - careful\n\n                    if(worker) {\n                        var j, a = rslt.add, r = rslt.sel, s = this._data.core.selected.slice();\n                        m = this._model.data;\n                        // if selection was changed while calculating in worker\n                        if(r.length !== s.length || $.vakata.array_unique(r.concat(s)).length !== r.length) {\n                            // deselect nodes that are no longer selected\n                            for(i = 0, j = r.length; i < j; i++) {\n                                if($.inArray(r[i], a) === -1 && $.inArray(r[i], s) === -1) {\n                                    m[r[i]].state.selected = false;\n                                }\n                            }\n                            // select nodes that were selected in the mean time\n                            for(i = 0, j = s.length; i < j; i++) {\n                                if($.inArray(s[i], r) === -1) {\n                                    m[s[i]].state.selected = true;\n                                }\n                            }\n                        }\n                    }\n                    if(rslt.add.length) {\n                        this._data.core.selected = this._data.core.selected.concat(rslt.add);\n                    }\n\n                    this.trigger('model', { \"nodes\" : rslt.dpc, 'parent' : rslt.par });\n\n                    if(rslt.par !== $.jstree.root) {\n                        this._node_changed(rslt.par);\n                        this.redraw();\n                    }\n                    else {\n                        // this.get_container_ul().children('.jstree-initial-node').remove();\n                        this.redraw(true);\n                    }\n                    if(rslt.add.length) {\n                        this.trigger('changed', { 'action' : 'model', 'selected' : this._data.core.selected });\n                    }\n\n                    // If no worker, try to mimic worker behavioour, by invoking cb asynchronously\n                    if (!worker && setImmediate) {\n                        setImmediate(function(){\n                            cb.call(inst, true);\n                        });\n                    }\n                    else {\n                        cb.call(inst, true);\n                    }\n                };\n            if(this.settings.core.worker && window.Blob && window.URL && window.Worker) {\n                try {\n                    if(this._wrk === null) {\n                        this._wrk = window.URL.createObjectURL(\n                            new window.Blob(\n                                ['self.onmessage = ' + func.toString()],\n                                {type:\"text/javascript\"}\n                            )\n                        );\n                    }\n                    if(!this._data.core.working || force_processing) {\n                        this._data.core.working = true;\n                        w = new window.Worker(this._wrk);\n                        w.onmessage = function (e) {\n                            rslt.call(this, e.data, true);\n                            try { w.terminate(); w = null; } catch(ignore) { }\n                            if(this._data.core.worker_queue.length) {\n                                this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                            }\n                            else {\n                                this._data.core.working = false;\n                            }\n                        }.bind(this);\n                        if(!args.par) {\n                            if(this._data.core.worker_queue.length) {\n                                this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                            }\n                            else {\n                                this._data.core.working = false;\n                            }\n                        }\n                        else {\n                            w.postMessage(args);\n                        }\n                    }\n                    else {\n                        this._data.core.worker_queue.push([dom, data, cb, true]);\n                    }\n                }\n                catch(e) {\n                    rslt.call(this, func(args), false);\n                    if(this._data.core.worker_queue.length) {\n                        this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                    }\n                    else {\n                        this._data.core.working = false;\n                    }\n                }\n            }\n            else {\n                rslt.call(this, func(args), false);\n            }\n        },\n        /**\n         * parses a node from a jQuery object and appends them to the in memory tree model. Used internally.\n         * @private\n         * @name _parse_model_from_html(d [, p, ps])\n         * @param  {jQuery} d the jQuery object to parse\n         * @param  {String} p the parent ID\n         * @param  {Array} ps list of all parents\n         * @return {String} the ID of the object added to the model\n         */\n        _parse_model_from_html : function (d, p, ps) {\n            if(!ps) { ps = []; }\n            else { ps = [].concat(ps); }\n            if(p) { ps.unshift(p); }\n            var c, e, m = this._model.data,\n                data = {\n                    id\t\t\t: false,\n                    text\t\t: false,\n                    icon\t\t: true,\n                    parent\t\t: p,\n                    parents\t\t: ps,\n                    children\t: [],\n                    children_d\t: [],\n                    data\t\t: null,\n                    state\t\t: { },\n                    li_attr\t\t: { id : false },\n                    a_attr\t\t: { href : '#' },\n                    original\t: false\n                }, i, tmp, tid;\n            for(i in this._model.default_state) {\n                if(this._model.default_state.hasOwnProperty(i)) {\n                    data.state[i] = this._model.default_state[i];\n                }\n            }\n            tmp = $.vakata.attributes(d, true);\n            $.each(tmp, function (i, v) {\n                v = $.vakata.trim(v);\n                if(!v.length) { return true; }\n                data.li_attr[i] = v;\n                if(i === 'id') {\n                    data.id = v.toString();\n                }\n            });\n            tmp = d.children('a').first();\n            if(tmp.length) {\n                tmp = $.vakata.attributes(tmp, true);\n                $.each(tmp, function (i, v) {\n                    v = $.vakata.trim(v);\n                    if(v.length) {\n                        data.a_attr[i] = v;\n                    }\n                });\n            }\n            tmp = d.children(\"a\").first().length ? d.children(\"a\").first().clone() : d.clone();\n            tmp.children(\"ins, i, ul\").remove();\n            tmp = tmp.html();\n            tmp = $('<div></div>').html(tmp);\n            data.text = this.settings.core.force_text ? tmp.text() : tmp.html();\n            tmp = d.data();\n            data.data = tmp ? $.extend(true, {}, tmp) : null;\n            data.state.opened = d.hasClass('jstree-open');\n            data.state.selected = d.children('a').hasClass('jstree-clicked');\n            data.state.disabled = d.children('a').hasClass('jstree-disabled');\n            if(data.data && data.data.jstree) {\n                for(i in data.data.jstree) {\n                    if(data.data.jstree.hasOwnProperty(i)) {\n                        data.state[i] = data.data.jstree[i];\n                    }\n                }\n            }\n            tmp = d.children(\"a\").children(\".jstree-themeicon\");\n            if(tmp.length) {\n                data.icon = tmp.hasClass('jstree-themeicon-hidden') ? false : tmp.attr('rel');\n            }\n            if(data.state.icon !== undefined) {\n                data.icon = data.state.icon;\n            }\n            if(data.icon === undefined || data.icon === null || data.icon === \"\") {\n                data.icon = true;\n            }\n            tmp = d.children(\"ul\").children(\"li\");\n            do {\n                tid = 'j' + this._id + '_' + (++this._cnt);\n            } while(m[tid]);\n            data.id = data.li_attr.id ? data.li_attr.id.toString() : tid;\n            if(tmp.length) {\n                tmp.each(function (i, v) {\n                    c = this._parse_model_from_html($(v), data.id, ps);\n                    e = this._model.data[c];\n                    data.children.push(c);\n                    if(e.children_d.length) {\n                        data.children_d = data.children_d.concat(e.children_d);\n                    }\n                }.bind(this));\n                data.children_d = data.children_d.concat(data.children);\n            }\n            else {\n                if(d.hasClass('jstree-closed')) {\n                    data.state.loaded = false;\n                }\n            }\n            if(data.li_attr['class']) {\n                data.li_attr['class'] = data.li_attr['class'].replace('jstree-closed','').replace('jstree-open','');\n            }\n            if(data.a_attr['class']) {\n                data.a_attr['class'] = data.a_attr['class'].replace('jstree-clicked','').replace('jstree-disabled','');\n            }\n            m[data.id] = data;\n            if(data.state.selected) {\n                this._data.core.selected.push(data.id);\n            }\n            return data.id;\n        },\n        /**\n         * parses a node from a JSON object (used when dealing with flat data, which has no nesting of children, but has id and parent properties) and appends it to the in memory tree model. Used internally.\n         * @private\n         * @name _parse_model_from_flat_json(d [, p, ps])\n         * @param  {Object} d the JSON object to parse\n         * @param  {String} p the parent ID\n         * @param  {Array} ps list of all parents\n         * @return {String} the ID of the object added to the model\n         */\n        _parse_model_from_flat_json : function (d, p, ps) {\n            if(!ps) { ps = []; }\n            else { ps = ps.concat(); }\n            if(p) { ps.unshift(p); }\n            var tid = d.id.toString(),\n                m = this._model.data,\n                df = this._model.default_state,\n                i, j, c, e,\n                tmp = {\n                    id\t\t\t: tid,\n                    text\t\t: d.text || '',\n                    icon\t\t: d.icon !== undefined ? d.icon : true,\n                    parent\t\t: p,\n                    parents\t\t: ps,\n                    children\t: d.children || [],\n                    children_d\t: d.children_d || [],\n                    data\t\t: d.data,\n                    state\t\t: { },\n                    li_attr\t\t: { id : false },\n                    a_attr\t\t: { href : '#' },\n                    original\t: false\n                };\n            for(i in df) {\n                if(df.hasOwnProperty(i)) {\n                    tmp.state[i] = df[i];\n                }\n            }\n            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                tmp.icon = d.data.jstree.icon;\n            }\n            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                tmp.icon = true;\n            }\n            if(d && d.data) {\n                tmp.data = d.data;\n                if(d.data.jstree) {\n                    for(i in d.data.jstree) {\n                        if(d.data.jstree.hasOwnProperty(i)) {\n                            tmp.state[i] = d.data.jstree[i];\n                        }\n                    }\n                }\n            }\n            if(d && typeof d.state === 'object') {\n                for (i in d.state) {\n                    if(d.state.hasOwnProperty(i)) {\n                        tmp.state[i] = d.state[i];\n                    }\n                }\n            }\n            if(d && typeof d.li_attr === 'object') {\n                for (i in d.li_attr) {\n                    if(d.li_attr.hasOwnProperty(i)) {\n                        tmp.li_attr[i] = d.li_attr[i];\n                    }\n                }\n            }\n            if(!tmp.li_attr.id) {\n                tmp.li_attr.id = tid;\n            }\n            if(d && typeof d.a_attr === 'object') {\n                for (i in d.a_attr) {\n                    if(d.a_attr.hasOwnProperty(i)) {\n                        tmp.a_attr[i] = d.a_attr[i];\n                    }\n                }\n            }\n            if(d && d.children && d.children === true) {\n                tmp.state.loaded = false;\n                tmp.children = [];\n                tmp.children_d = [];\n            }\n            m[tmp.id] = tmp;\n            for(i = 0, j = tmp.children.length; i < j; i++) {\n                c = this._parse_model_from_flat_json(m[tmp.children[i]], tmp.id, ps);\n                e = m[c];\n                tmp.children_d.push(c);\n                if(e.children_d.length) {\n                    tmp.children_d = tmp.children_d.concat(e.children_d);\n                }\n            }\n            delete d.data;\n            delete d.children;\n            m[tmp.id].original = d;\n            if(tmp.state.selected) {\n                this._data.core.selected.push(tmp.id);\n            }\n            return tmp.id;\n        },\n        /**\n         * parses a node from a JSON object and appends it to the in memory tree model. Used internally.\n         * @private\n         * @name _parse_model_from_json(d [, p, ps])\n         * @param  {Object} d the JSON object to parse\n         * @param  {String} p the parent ID\n         * @param  {Array} ps list of all parents\n         * @return {String} the ID of the object added to the model\n         */\n        _parse_model_from_json : function (d, p, ps) {\n            if(!ps) { ps = []; }\n            else { ps = ps.concat(); }\n            if(p) { ps.unshift(p); }\n            var tid = false, i, j, c, e, m = this._model.data, df = this._model.default_state, tmp;\n            do {\n                tid = 'j' + this._id + '_' + (++this._cnt);\n            } while(m[tid]);\n\n            tmp = {\n                id\t\t\t: false,\n                text\t\t: typeof d === 'string' ? d : '',\n                icon\t\t: typeof d === 'object' && d.icon !== undefined ? d.icon : true,\n                parent\t\t: p,\n                parents\t\t: ps,\n                children\t: [],\n                children_d\t: [],\n                data\t\t: null,\n                state\t\t: { },\n                li_attr\t\t: { id : false },\n                a_attr\t\t: { href : '#' },\n                original\t: false\n            };\n            for(i in df) {\n                if(df.hasOwnProperty(i)) {\n                    tmp.state[i] = df[i];\n                }\n            }\n            if(d && d.id) { tmp.id = d.id.toString(); }\n            if(d && d.text) { tmp.text = d.text; }\n            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                tmp.icon = d.data.jstree.icon;\n            }\n            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                tmp.icon = true;\n            }\n            if(d && d.data) {\n                tmp.data = d.data;\n                if(d.data.jstree) {\n                    for(i in d.data.jstree) {\n                        if(d.data.jstree.hasOwnProperty(i)) {\n                            tmp.state[i] = d.data.jstree[i];\n                        }\n                    }\n                }\n            }\n            if(d && typeof d.state === 'object') {\n                for (i in d.state) {\n                    if(d.state.hasOwnProperty(i)) {\n                        tmp.state[i] = d.state[i];\n                    }\n                }\n            }\n            if(d && typeof d.li_attr === 'object') {\n                for (i in d.li_attr) {\n                    if(d.li_attr.hasOwnProperty(i)) {\n                        tmp.li_attr[i] = d.li_attr[i];\n                    }\n                }\n            }\n            if(tmp.li_attr.id && !tmp.id) {\n                tmp.id = tmp.li_attr.id.toString();\n            }\n            if(!tmp.id) {\n                tmp.id = tid;\n            }\n            if(!tmp.li_attr.id) {\n                tmp.li_attr.id = tmp.id;\n            }\n            if(d && typeof d.a_attr === 'object') {\n                for (i in d.a_attr) {\n                    if(d.a_attr.hasOwnProperty(i)) {\n                        tmp.a_attr[i] = d.a_attr[i];\n                    }\n                }\n            }\n            if(d && d.children && d.children.length) {\n                for(i = 0, j = d.children.length; i < j; i++) {\n                    c = this._parse_model_from_json(d.children[i], tmp.id, ps);\n                    e = m[c];\n                    tmp.children.push(c);\n                    if(e.children_d.length) {\n                        tmp.children_d = tmp.children_d.concat(e.children_d);\n                    }\n                }\n                tmp.children_d = tmp.children.concat(tmp.children_d);\n            }\n            if(d && d.children && d.children === true) {\n                tmp.state.loaded = false;\n                tmp.children = [];\n                tmp.children_d = [];\n            }\n            delete d.data;\n            delete d.children;\n            tmp.original = d;\n            m[tmp.id] = tmp;\n            if(tmp.state.selected) {\n                this._data.core.selected.push(tmp.id);\n            }\n            return tmp.id;\n        },\n        /**\n         * redraws all nodes that need to be redrawn. Used internally.\n         * @private\n         * @name _redraw()\n         * @trigger redraw.jstree\n         */\n        _redraw : function () {\n            var nodes = this._model.force_full_redraw ? this._model.data[$.jstree.root].children.concat([]) : this._model.changed.concat([]),\n                f = document.createElement('UL'), tmp, i, j, fe = this._data.core.focused;\n            for(i = 0, j = nodes.length; i < j; i++) {\n                tmp = this.redraw_node(nodes[i], true, this._model.force_full_redraw);\n                if(tmp && this._model.force_full_redraw) {\n                    f.appendChild(tmp);\n                }\n            }\n            if(this._model.force_full_redraw) {\n                f.className = this.get_container_ul()[0].className;\n                f.setAttribute('role','group');\n                this.element.empty().append(f);\n                //this.get_container_ul()[0].appendChild(f);\n            }\n            if(fe !== null && this.settings.core.restore_focus) {\n                tmp = this.get_node(fe, true);\n                if(tmp && tmp.length && tmp.children('.jstree-anchor')[0] !== document.activeElement) {\n                    tmp.children('.jstree-anchor').trigger('focus');\n                }\n                else {\n                    this._data.core.focused = null;\n                }\n            }\n            this._model.force_full_redraw = false;\n            this._model.changed = [];\n            /**\n             * triggered after nodes are redrawn\n             * @event\n             * @name redraw.jstree\n             * @param {array} nodes the redrawn nodes\n             */\n            this.trigger('redraw', { \"nodes\" : nodes });\n        },\n        /**\n         * redraws all nodes that need to be redrawn or optionally - the whole tree\n         * @name redraw([full])\n         * @param {Boolean} full if set to `true` all nodes are redrawn.\n         */\n        redraw : function (full) {\n            if(full) {\n                this._model.force_full_redraw = true;\n            }\n            //if(this._model.redraw_timeout) {\n            //\tclearTimeout(this._model.redraw_timeout);\n            //}\n            //this._model.redraw_timeout = setTimeout($.proxy(this._redraw, this),0);\n            this._redraw();\n        },\n        /**\n         * redraws a single node's children. Used internally.\n         * @private\n         * @name draw_children(node)\n         * @param {mixed} node the node whose children will be redrawn\n         */\n        draw_children : function (node) {\n            var obj = this.get_node(node),\n                i = false,\n                j = false,\n                k = false,\n                d = document;\n            if(!obj) { return false; }\n            if(obj.id === $.jstree.root) { return this.redraw(true); }\n            node = this.get_node(node, true);\n            if(!node || !node.length) { return false; } // TODO: quick toggle\n\n            node.children('.jstree-children').remove();\n            node = node[0];\n            if(obj.children.length && obj.state.loaded) {\n                k = d.createElement('UL');\n                k.setAttribute('role', 'group');\n                k.className = 'jstree-children';\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    k.appendChild(this.redraw_node(obj.children[i], true, true));\n                }\n                node.appendChild(k);\n            }\n        },\n        /**\n         * redraws a single node. Used internally.\n         * @private\n         * @name redraw_node(node, deep, is_callback, force_render)\n         * @param {mixed} node the node to redraw\n         * @param {Boolean} deep should child nodes be redrawn too\n         * @param {Boolean} is_callback is this a recursion call\n         * @param {Boolean} force_render should children of closed parents be drawn anyway\n         */\n        redraw_node : function (node, deep, is_callback, force_render) {\n            var obj = this.get_node(node),\n                par = false,\n                ind = false,\n                old = false,\n                i = false,\n                j = false,\n                k = false,\n                c = '',\n                d = document,\n                m = this._model.data,\n                f = false,\n                s = false,\n                tmp = null,\n                t = 0,\n                l = 0,\n                has_children = false,\n                last_sibling = false;\n            if(!obj) { return false; }\n            if(obj.id === $.jstree.root) {  return this.redraw(true); }\n            deep = deep || obj.children.length === 0;\n            node = !document.querySelector ? document.getElementById(obj.id) : this.element[0].querySelector('#' + (\"0123456789\".indexOf(obj.id[0]) !== -1 ? '\\\\3' + obj.id[0] + ' ' + obj.id.substr(1).replace($.jstree.idregex,'\\\\$&') : obj.id.replace($.jstree.idregex,'\\\\$&')) ); //, this.element);\n            if(!node) {\n                deep = true;\n                //node = d.createElement('LI');\n                if(!is_callback) {\n                    par = obj.parent !== $.jstree.root ? $('#' + obj.parent.replace($.jstree.idregex,'\\\\$&'), this.element)[0] : null;\n                    if(par !== null && (!par || !m[obj.parent].state.opened)) {\n                        return false;\n                    }\n                    ind = $.inArray(obj.id, par === null ? m[$.jstree.root].children : m[obj.parent].children);\n                }\n            }\n            else {\n                node = $(node);\n                if(!is_callback) {\n                    par = node.parent().parent()[0];\n                    if(par === this.element[0]) {\n                        par = null;\n                    }\n                    ind = node.index();\n                }\n                // m[obj.id].data = node.data(); // use only node's data, no need to touch jquery storage\n                if(!deep && obj.children.length && !node.children('.jstree-children').length) {\n                    deep = true;\n                }\n                if(!deep) {\n                    old = node.children('.jstree-children')[0];\n                }\n                f = node.children('.jstree-anchor')[0] === document.activeElement;\n                node.remove();\n                //node = d.createElement('LI');\n                //node = node[0];\n            }\n            node = this._data.core.node.cloneNode(true);\n            // node is DOM, deep is boolean\n\n            c = 'jstree-node ';\n            for(i in obj.li_attr) {\n                if(obj.li_attr.hasOwnProperty(i)) {\n                    if(i === 'id') { continue; }\n                    if(i !== 'class') {\n                        node.setAttribute(i, obj.li_attr[i]);\n                    }\n                    else {\n                        c += obj.li_attr[i];\n                    }\n                }\n            }\n            if(!obj.a_attr.id) {\n                obj.a_attr.id = obj.id + '_anchor';\n            }\n            node.childNodes[1].setAttribute('aria-selected', !!obj.state.selected);\n            node.childNodes[1].setAttribute('aria-level', obj.parents.length);\n            if(this.settings.core.compute_elements_positions) {\n                node.childNodes[1].setAttribute('aria-setsize', m[obj.parent].children.length);\n                node.childNodes[1].setAttribute('aria-posinset', m[obj.parent].children.indexOf(obj.id) + 1);\n            }\n            if(obj.state.disabled) {\n                node.childNodes[1].setAttribute('aria-disabled', true);\n            }\n\n            for(i = 0, j = obj.children.length; i < j; i++) {\n                if(!m[obj.children[i]].state.hidden) {\n                    has_children = true;\n                    break;\n                }\n            }\n            if(obj.parent !== null && m[obj.parent] && !obj.state.hidden) {\n                i = $.inArray(obj.id, m[obj.parent].children);\n                last_sibling = obj.id;\n                if(i !== -1) {\n                    i++;\n                    for(j = m[obj.parent].children.length; i < j; i++) {\n                        if(!m[m[obj.parent].children[i]].state.hidden) {\n                            last_sibling = m[obj.parent].children[i];\n                        }\n                        if(last_sibling !== obj.id) {\n                            break;\n                        }\n                    }\n                }\n            }\n\n            if(obj.state.hidden) {\n                c += ' jstree-hidden';\n            }\n            if (obj.state.loading) {\n                c += ' jstree-loading';\n            }\n            if(obj.state.loaded && !has_children) {\n                c += ' jstree-leaf';\n            }\n            else {\n                c += obj.state.opened && obj.state.loaded ? ' jstree-open' : ' jstree-closed';\n                node.childNodes[1].setAttribute('aria-expanded', (obj.state.opened && obj.state.loaded) );\n            }\n            if(last_sibling === obj.id) {\n                c += ' jstree-last';\n            }\n            node.id = obj.id;\n            node.className = c;\n            c = ( obj.state.selected ? ' jstree-clicked' : '') + ( obj.state.disabled ? ' jstree-disabled' : '');\n            for(j in obj.a_attr) {\n                if(obj.a_attr.hasOwnProperty(j)) {\n                    if(j === 'href' && obj.a_attr[j] === '#') { continue; }\n                    if(j !== 'class') {\n                        node.childNodes[1].setAttribute(j, obj.a_attr[j]);\n                    }\n                    else {\n                        c += ' ' + obj.a_attr[j];\n                    }\n                }\n            }\n            if(c.length) {\n                node.childNodes[1].className = 'jstree-anchor ' + c;\n            }\n            if((obj.icon && obj.icon !== true) || obj.icon === false) {\n                if(obj.icon === false) {\n                    node.childNodes[1].childNodes[0].className += ' jstree-themeicon-hidden';\n                }\n                else if(obj.icon.indexOf('/') === -1 && obj.icon.indexOf('.') === -1) {\n                    node.childNodes[1].childNodes[0].className += ' ' + obj.icon + ' jstree-themeicon-custom';\n                }\n                else {\n                    node.childNodes[1].childNodes[0].style.backgroundImage = 'url(\"'+obj.icon+'\")';\n                    node.childNodes[1].childNodes[0].style.backgroundPosition = 'center center';\n                    node.childNodes[1].childNodes[0].style.backgroundSize = 'auto';\n                    node.childNodes[1].childNodes[0].className += ' jstree-themeicon-custom';\n                }\n            }\n\n            if(this.settings.core.force_text) {\n                node.childNodes[1].appendChild(d.createTextNode(obj.text));\n            }\n            else {\n                node.childNodes[1].innerHTML += obj.text;\n            }\n\n\n            if(deep && obj.children.length && (obj.state.opened || force_render) && obj.state.loaded) {\n                k = d.createElement('UL');\n                k.setAttribute('role', 'group');\n                k.className = 'jstree-children';\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    k.appendChild(this.redraw_node(obj.children[i], deep, true));\n                }\n                node.appendChild(k);\n            }\n            if(old) {\n                node.appendChild(old);\n            }\n            if(!is_callback) {\n                // append back using par / ind\n                if(!par) {\n                    par = this.element[0];\n                }\n                for(i = 0, j = par.childNodes.length; i < j; i++) {\n                    if(par.childNodes[i] && par.childNodes[i].className && par.childNodes[i].className.indexOf('jstree-children') !== -1) {\n                        tmp = par.childNodes[i];\n                        break;\n                    }\n                }\n                if(!tmp) {\n                    tmp = d.createElement('UL');\n                    tmp.setAttribute('role', 'group');\n                    tmp.className = 'jstree-children';\n                    par.appendChild(tmp);\n                }\n                par = tmp;\n\n                if(ind < par.childNodes.length) {\n                    par.insertBefore(node, par.childNodes[ind]);\n                }\n                else {\n                    par.appendChild(node);\n                }\n                if(f) {\n                    t = this.element[0].scrollTop;\n                    l = this.element[0].scrollLeft;\n                    node.childNodes[1].focus();\n                    this.element[0].scrollTop = t;\n                    this.element[0].scrollLeft = l;\n                }\n            }\n            if(obj.state.opened && !obj.state.loaded) {\n                obj.state.opened = false;\n                setTimeout(function () {\n                    this.open_node(obj.id, false, 0);\n                }.bind(this), 0);\n            }\n            return node;\n        },\n        /**\n         * opens a node, revealing its children. If the node is not loaded it will be loaded and opened once ready.\n         * @name open_node(obj [, callback, animation])\n         * @param {mixed} obj the node to open\n         * @param {Function} callback a function to execute once the node is opened\n         * @param {Number} animation the animation duration in milliseconds when opening the node (overrides the `core.animation` setting). Use `false` for no animation.\n         * @trigger open_node.jstree, after_open.jstree, before_open.jstree\n         */\n        open_node : function (obj, callback, animation) {\n            var t1, t2, d, t;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.open_node(obj[t1], callback, animation);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            animation = animation === undefined ? this.settings.core.animation : animation;\n            if(!this.is_closed(obj)) {\n                if(callback) {\n                    callback.call(this, obj, false);\n                }\n                return false;\n            }\n            if(!this.is_loaded(obj)) {\n                if(this.is_loading(obj)) {\n                    return setTimeout(function () {\n                        this.open_node(obj, callback, animation);\n                    }.bind(this), 500);\n                }\n                this.load_node(obj, function (o, ok) {\n                    return ok ? this.open_node(o, callback, animation) : (callback ? callback.call(this, o, false) : false);\n                });\n            }\n            else {\n                d = this.get_node(obj, true);\n                t = this;\n                if(d.length) {\n                    if(animation && d.children(\".jstree-children\").length) {\n                        d.children(\".jstree-children\").stop(true, true);\n                    }\n                    if(obj.children.length && !this._firstChild(d.children('.jstree-children')[0])) {\n                        this.draw_children(obj);\n                        //d = this.get_node(obj, true);\n                    }\n                    if(!animation) {\n                        this.trigger('before_open', { \"node\" : obj });\n                        d[0].className = d[0].className.replace('jstree-closed', 'jstree-open');\n                        d[0].childNodes[1].setAttribute(\"aria-expanded\", true);\n                    }\n                    else {\n                        this.trigger('before_open', { \"node\" : obj });\n                        d\n                            .children(\".jstree-children\").css(\"display\",\"none\").end()\n                            .removeClass(\"jstree-closed\").addClass(\"jstree-open\")\n                            .children('.jstree-anchor').attr(\"aria-expanded\", true).end()\n                            .children(\".jstree-children\").stop(true, true)\n                            .slideDown(animation, function () {\n                                this.style.display = \"\";\n                                if (t.element) {\n                                    t.trigger(\"after_open\", { \"node\" : obj });\n                                }\n                            });\n                    }\n                }\n                obj.state.opened = true;\n                if(callback) {\n                    callback.call(this, obj, true);\n                }\n                if(!d.length) {\n                    /**\n                     * triggered when a node is about to be opened (if the node is supposed to be in the DOM, it will be, but it won't be visible yet)\n                     * @event\n                     * @name before_open.jstree\n                     * @param {Object} node the opened node\n                     */\n                    this.trigger('before_open', { \"node\" : obj });\n                }\n                /**\n                 * triggered when a node is opened (if there is an animation it will not be completed yet)\n                 * @event\n                 * @name open_node.jstree\n                 * @param {Object} node the opened node\n                 */\n                this.trigger('open_node', { \"node\" : obj });\n                if(!animation || !d.length) {\n                    /**\n                     * triggered when a node is opened and the animation is complete\n                     * @event\n                     * @name after_open.jstree\n                     * @param {Object} node the opened node\n                     */\n                    this.trigger(\"after_open\", { \"node\" : obj });\n                }\n                return true;\n            }\n        },\n        /**\n         * opens every parent of a node (node should be loaded)\n         * @name _open_to(obj)\n         * @param {mixed} obj the node to reveal\n         * @private\n         */\n        _open_to : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            var i, j, p = obj.parents;\n            for(i = 0, j = p.length; i < j; i+=1) {\n                if(i !== $.jstree.root) {\n                    this.open_node(p[i], false, 0);\n                }\n            }\n            return $('#' + obj.id.replace($.jstree.idregex,'\\\\$&'), this.element);\n        },\n        /**\n         * closes a node, hiding its children\n         * @name close_node(obj [, animation])\n         * @param {mixed} obj the node to close\n         * @param {Number} animation the animation duration in milliseconds when closing the node (overrides the `core.animation` setting). Use `false` for no animation.\n         * @trigger close_node.jstree, after_close.jstree\n         */\n        close_node : function (obj, animation) {\n            var t1, t2, t, d;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.close_node(obj[t1], animation);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            if(this.is_closed(obj)) {\n                return false;\n            }\n            animation = animation === undefined ? this.settings.core.animation : animation;\n            t = this;\n            d = this.get_node(obj, true);\n\n            obj.state.opened = false;\n            /**\n             * triggered when a node is closed (if there is an animation it will not be complete yet)\n             * @event\n             * @name close_node.jstree\n             * @param {Object} node the closed node\n             */\n            this.trigger('close_node',{ \"node\" : obj });\n            if(!d.length) {\n                /**\n                 * triggered when a node is closed and the animation is complete\n                 * @event\n                 * @name after_close.jstree\n                 * @param {Object} node the closed node\n                 */\n                this.trigger(\"after_close\", { \"node\" : obj });\n            }\n            else {\n                if(!animation) {\n                    d[0].className = d[0].className.replace('jstree-open', 'jstree-closed');\n                    d.children('.jstree-anchor').attr(\"aria-expanded\", false);\n                    d.children('.jstree-children').remove();\n                    this.trigger(\"after_close\", { \"node\" : obj });\n                }\n                else {\n                    d\n                        .children(\".jstree-children\").attr(\"style\",\"display:block !important\").end()\n                        .removeClass(\"jstree-open\").addClass(\"jstree-closed\")\n                        .children('.jstree-anchor').attr(\"aria-expanded\", false).end()\n                        .children(\".jstree-children\").stop(true, true).slideUp(animation, function () {\n                        this.style.display = \"\";\n                        d.children('.jstree-children').remove();\n                        if (t.element) {\n                            t.trigger(\"after_close\", { \"node\" : obj });\n                        }\n                    });\n                }\n            }\n        },\n        /**\n         * toggles a node - closing it if it is open, opening it if it is closed\n         * @name toggle_node(obj)\n         * @param {mixed} obj the node to toggle\n         */\n        toggle_node : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.toggle_node(obj[t1]);\n                }\n                return true;\n            }\n            if(this.is_closed(obj)) {\n                return this.open_node(obj);\n            }\n            if(this.is_open(obj)) {\n                return this.close_node(obj);\n            }\n        },\n        /**\n         * opens all nodes within a node (or the tree), revealing their children. If the node is not loaded it will be loaded and opened once ready.\n         * @name open_all([obj, animation, original_obj])\n         * @param {mixed} obj the node to open recursively, omit to open all nodes in the tree\n         * @param {Number} animation the animation duration in milliseconds when opening the nodes, the default is no animation\n         * @param {jQuery} reference to the node that started the process (internal use)\n         * @trigger open_all.jstree\n         */\n        open_all : function (obj, animation, original_obj) {\n            if(!obj) { obj = $.jstree.root; }\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var dom = obj.id === $.jstree.root ? this.get_container_ul() : this.get_node(obj, true), i, j, _this;\n            if(!dom.length) {\n                for(i = 0, j = obj.children_d.length; i < j; i++) {\n                    if(this.is_closed(this._model.data[obj.children_d[i]])) {\n                        this._model.data[obj.children_d[i]].state.opened = true;\n                    }\n                }\n                return this.trigger('open_all', { \"node\" : obj });\n            }\n            original_obj = original_obj || dom;\n            _this = this;\n            dom = this.is_closed(obj) ? dom.find('.jstree-closed').addBack() : dom.find('.jstree-closed');\n            dom.each(function () {\n                _this.open_node(\n                    this,\n                    function(node, status) { if(status && this.is_parent(node)) { this.open_all(node, animation, original_obj); } },\n                    animation || 0\n                );\n            });\n            if(original_obj.find('.jstree-closed').length === 0) {\n                /**\n                 * triggered when an `open_all` call completes\n                 * @event\n                 * @name open_all.jstree\n                 * @param {Object} node the opened node\n                 */\n                this.trigger('open_all', { \"node\" : this.get_node(original_obj) });\n            }\n        },\n        /**\n         * closes all nodes within a node (or the tree), revealing their children\n         * @name close_all([obj, animation])\n         * @param {mixed} obj the node to close recursively, omit to close all nodes in the tree\n         * @param {Number} animation the animation duration in milliseconds when closing the nodes, the default is no animation\n         * @trigger close_all.jstree\n         */\n        close_all : function (obj, animation) {\n            if(!obj) { obj = $.jstree.root; }\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var dom = obj.id === $.jstree.root ? this.get_container_ul() : this.get_node(obj, true),\n                _this = this, i, j;\n            if(dom.length) {\n                dom = this.is_open(obj) ? dom.find('.jstree-open').addBack() : dom.find('.jstree-open');\n                $(dom.get().reverse()).each(function () { _this.close_node(this, animation || 0); });\n            }\n            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                this._model.data[obj.children_d[i]].state.opened = false;\n            }\n            /**\n             * triggered when an `close_all` call completes\n             * @event\n             * @name close_all.jstree\n             * @param {Object} node the closed node\n             */\n            this.trigger('close_all', { \"node\" : obj });\n        },\n        /**\n         * checks if a node is disabled (not selectable)\n         * @name is_disabled(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_disabled : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state && obj.state.disabled;\n        },\n        /**\n         * enables a node - so that it can be selected\n         * @name enable_node(obj)\n         * @param {mixed} obj the node to enable\n         * @trigger enable_node.jstree\n         */\n        enable_node : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.enable_node(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            obj.state.disabled = false;\n            this.get_node(obj,true).children('.jstree-anchor').removeClass('jstree-disabled').attr('aria-disabled', false);\n            /**\n             * triggered when an node is enabled\n             * @event\n             * @name enable_node.jstree\n             * @param {Object} node the enabled node\n             */\n            this.trigger('enable_node', { 'node' : obj });\n        },\n        /**\n         * disables a node - so that it can not be selected\n         * @name disable_node(obj)\n         * @param {mixed} obj the node to disable\n         * @trigger disable_node.jstree\n         */\n        disable_node : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.disable_node(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            obj.state.disabled = true;\n            this.get_node(obj,true).children('.jstree-anchor').addClass('jstree-disabled').attr('aria-disabled', true);\n            /**\n             * triggered when an node is disabled\n             * @event\n             * @name disable_node.jstree\n             * @param {Object} node the disabled node\n             */\n            this.trigger('disable_node', { 'node' : obj });\n        },\n        /**\n         * determines if a node is hidden\n         * @name is_hidden(obj)\n         * @param {mixed} obj the node\n         */\n        is_hidden : function (obj) {\n            obj = this.get_node(obj);\n            return obj.state.hidden === true;\n        },\n        /**\n         * hides a node - it is still in the structure but will not be visible\n         * @name hide_node(obj)\n         * @param {mixed} obj the node to hide\n         * @param {Boolean} skip_redraw internal parameter controlling if redraw is called\n         * @trigger hide_node.jstree\n         */\n        hide_node : function (obj, skip_redraw) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.hide_node(obj[t1], true);\n                }\n                if (!skip_redraw) {\n                    this.redraw();\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            if(!obj.state.hidden) {\n                obj.state.hidden = true;\n                this._node_changed(obj.parent);\n                if(!skip_redraw) {\n                    this.redraw();\n                }\n                /**\n                 * triggered when an node is hidden\n                 * @event\n                 * @name hide_node.jstree\n                 * @param {Object} node the hidden node\n                 */\n                this.trigger('hide_node', { 'node' : obj });\n            }\n        },\n        /**\n         * shows a node\n         * @name show_node(obj)\n         * @param {mixed} obj the node to show\n         * @param {Boolean} skip_redraw internal parameter controlling if redraw is called\n         * @trigger show_node.jstree\n         */\n        show_node : function (obj, skip_redraw) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.show_node(obj[t1], true);\n                }\n                if (!skip_redraw) {\n                    this.redraw();\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            if(obj.state.hidden) {\n                obj.state.hidden = false;\n                this._node_changed(obj.parent);\n                if(!skip_redraw) {\n                    this.redraw();\n                }\n                /**\n                 * triggered when an node is shown\n                 * @event\n                 * @name show_node.jstree\n                 * @param {Object} node the shown node\n                 */\n                this.trigger('show_node', { 'node' : obj });\n            }\n        },\n        /**\n         * hides all nodes\n         * @name hide_all()\n         * @trigger hide_all.jstree\n         */\n        hide_all : function (skip_redraw) {\n            var i, m = this._model.data, ids = [];\n            for(i in m) {\n                if(m.hasOwnProperty(i) && i !== $.jstree.root && !m[i].state.hidden) {\n                    m[i].state.hidden = true;\n                    ids.push(i);\n                }\n            }\n            this._model.force_full_redraw = true;\n            if(!skip_redraw) {\n                this.redraw();\n            }\n            /**\n             * triggered when all nodes are hidden\n             * @event\n             * @name hide_all.jstree\n             * @param {Array} nodes the IDs of all hidden nodes\n             */\n            this.trigger('hide_all', { 'nodes' : ids });\n            return ids;\n        },\n        /**\n         * shows all nodes\n         * @name show_all()\n         * @trigger show_all.jstree\n         */\n        show_all : function (skip_redraw) {\n            var i, m = this._model.data, ids = [];\n            for(i in m) {\n                if(m.hasOwnProperty(i) && i !== $.jstree.root && m[i].state.hidden) {\n                    m[i].state.hidden = false;\n                    ids.push(i);\n                }\n            }\n            this._model.force_full_redraw = true;\n            if(!skip_redraw) {\n                this.redraw();\n            }\n            /**\n             * triggered when all nodes are shown\n             * @event\n             * @name show_all.jstree\n             * @param {Array} nodes the IDs of all shown nodes\n             */\n            this.trigger('show_all', { 'nodes' : ids });\n            return ids;\n        },\n        /**\n         * called when a node is selected by the user. Used internally.\n         * @private\n         * @name activate_node(obj, e)\n         * @param {mixed} obj the node\n         * @param {Object} e the related event\n         * @trigger activate_node.jstree, changed.jstree\n         */\n        activate_node : function (obj, e) {\n            if(this.is_disabled(obj)) {\n                return false;\n            }\n            if(!e || typeof e !== 'object') {\n                e = {};\n            }\n\n            // ensure last_clicked is still in the DOM, make it fresh (maybe it was moved?) and make sure it is still selected, if not - make last_clicked the last selected node\n            this._data.core.last_clicked = this._data.core.last_clicked && this._data.core.last_clicked.id !== undefined ? this.get_node(this._data.core.last_clicked.id) : null;\n            if(this._data.core.last_clicked && !this._data.core.last_clicked.state.selected) { this._data.core.last_clicked = null; }\n            if(!this._data.core.last_clicked && this._data.core.selected.length) { this._data.core.last_clicked = this.get_node(this._data.core.selected[this._data.core.selected.length - 1]); }\n\n            if(!this.settings.core.multiple || (!e.metaKey && !e.ctrlKey && !e.shiftKey) || (e.shiftKey && (!this._data.core.last_clicked || !this.get_parent(obj) || this.get_parent(obj) !== this._data.core.last_clicked.parent ) )) {\n                if(!this.settings.core.multiple && (e.metaKey || e.ctrlKey || e.shiftKey) && this.is_selected(obj)) {\n                    this.deselect_node(obj, false, e);\n                }\n                else {\n                    this.deselect_all(true);\n                    this.select_node(obj, false, false, e);\n                    this._data.core.last_clicked = this.get_node(obj);\n                }\n            }\n            else {\n                if(e.shiftKey) {\n                    var o = this.get_node(obj).id,\n                        l = this._data.core.last_clicked.id,\n                        p = this.get_node(this._data.core.last_clicked.parent).children,\n                        c = false,\n                        i, j;\n                    for(i = 0, j = p.length; i < j; i += 1) {\n                        // separate IFs work whem o and l are the same\n                        if(p[i] === o) {\n                            c = !c;\n                        }\n                        if(p[i] === l) {\n                            c = !c;\n                        }\n                        if(!this.is_disabled(p[i]) && (c || p[i] === o || p[i] === l)) {\n                            if (!this.is_hidden(p[i])) {\n                                this.select_node(p[i], true, false, e);\n                            }\n                        }\n                        else {\n                            this.deselect_node(p[i], true, e);\n                        }\n                    }\n                    this.trigger('changed', { 'action' : 'select_node', 'node' : this.get_node(obj), 'selected' : this._data.core.selected, 'event' : e });\n                }\n                else {\n                    if(!this.is_selected(obj)) {\n                        this.select_node(obj, false, false, e);\n                    }\n                    else {\n                        this.deselect_node(obj, false, e);\n                    }\n                }\n            }\n            /**\n             * triggered when an node is clicked or intercated with by the user\n             * @event\n             * @name activate_node.jstree\n             * @param {Object} node\n             * @param {Object} event the ooriginal event (if any) which triggered the call (may be an empty object)\n             */\n            this.trigger('activate_node', { 'node' : this.get_node(obj), 'event' : e });\n        },\n        /**\n         * applies the hover state on a node, called when a node is hovered by the user. Used internally.\n         * @private\n         * @name hover_node(obj)\n         * @param {mixed} obj\n         * @trigger hover_node.jstree\n         */\n        hover_node : function (obj) {\n            obj = this.get_node(obj, true);\n            if(!obj || !obj.length || obj.children('.jstree-hovered').length) {\n                return false;\n            }\n            var o = this.element.find('.jstree-hovered'), t = this.element;\n            if(o && o.length) { this.dehover_node(o); }\n\n            obj.children('.jstree-anchor').addClass('jstree-hovered');\n            /**\n             * triggered when an node is hovered\n             * @event\n             * @name hover_node.jstree\n             * @param {Object} node\n             */\n            this.trigger('hover_node', { 'node' : this.get_node(obj) });\n            setTimeout(function () { t.attr('aria-activedescendant', obj[0].id); }, 0);\n        },\n        /**\n         * removes the hover state from a nodecalled when a node is no longer hovered by the user. Used internally.\n         * @private\n         * @name dehover_node(obj)\n         * @param {mixed} obj\n         * @trigger dehover_node.jstree\n         */\n        dehover_node : function (obj) {\n            obj = this.get_node(obj, true);\n            if(!obj || !obj.length || !obj.children('.jstree-hovered').length) {\n                return false;\n            }\n            obj.children('.jstree-anchor').removeClass('jstree-hovered');\n            /**\n             * triggered when an node is no longer hovered\n             * @event\n             * @name dehover_node.jstree\n             * @param {Object} node\n             */\n            this.trigger('dehover_node', { 'node' : this.get_node(obj) });\n        },\n        /**\n         * select a node\n         * @name select_node(obj [, supress_event, prevent_open])\n         * @param {mixed} obj an array can be used to select multiple nodes\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @param {Boolean} prevent_open if set to `true` parents of the selected node won't be opened\n         * @trigger select_node.jstree, changed.jstree\n         */\n        select_node : function (obj, supress_event, prevent_open, e) {\n            var dom, t1, t2, th;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.select_node(obj[t1], supress_event, prevent_open, e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(!obj.state.selected) {\n                obj.state.selected = true;\n                this._data.core.selected.push(obj.id);\n                if(!prevent_open) {\n                    dom = this._open_to(obj);\n                }\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').addClass('jstree-clicked').attr('aria-selected', true);\n                }\n                /**\n                 * triggered when an node is selected\n                 * @event\n                 * @name select_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this select_node\n                 */\n                this.trigger('select_node', { 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                if(!supress_event) {\n                    /**\n                     * triggered when selection changes\n                     * @event\n                     * @name changed.jstree\n                     * @param {Object} node\n                     * @param {Object} action the action that caused the selection to change\n                     * @param {Array} selected the current selection\n                     * @param {Object} event the event (if any) that triggered this changed event\n                     */\n                    this.trigger('changed', { 'action' : 'select_node', 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                }\n            }\n        },\n        /**\n         * deselect a node\n         * @name deselect_node(obj [, supress_event])\n         * @param {mixed} obj an array can be used to deselect multiple nodes\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @trigger deselect_node.jstree, changed.jstree\n         */\n        deselect_node : function (obj, supress_event, e) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.deselect_node(obj[t1], supress_event, e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(obj.state.selected) {\n                obj.state.selected = false;\n                this._data.core.selected = $.vakata.array_remove_item(this._data.core.selected, obj.id);\n                if(dom.length) {\n                    dom.children('.jstree-anchor').removeClass('jstree-clicked').attr('aria-selected', false);\n                }\n                /**\n                 * triggered when an node is deselected\n                 * @event\n                 * @name deselect_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this deselect_node\n                 */\n                this.trigger('deselect_node', { 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                if(!supress_event) {\n                    this.trigger('changed', { 'action' : 'deselect_node', 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                }\n            }\n        },\n        /**\n         * select all nodes in the tree\n         * @name select_all([supress_event])\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @trigger select_all.jstree, changed.jstree\n         */\n        select_all : function (supress_event) {\n            var tmp = this._data.core.selected.concat([]), i, j;\n            this._data.core.selected = this._model.data[$.jstree.root].children_d.concat();\n            for(i = 0, j = this._data.core.selected.length; i < j; i++) {\n                if(this._model.data[this._data.core.selected[i]]) {\n                    this._model.data[this._data.core.selected[i]].state.selected = true;\n                }\n            }\n            this.redraw(true);\n            /**\n             * triggered when all nodes are selected\n             * @event\n             * @name select_all.jstree\n             * @param {Array} selected the current selection\n             */\n            this.trigger('select_all', { 'selected' : this._data.core.selected });\n            if(!supress_event) {\n                this.trigger('changed', { 'action' : 'select_all', 'selected' : this._data.core.selected, 'old_selection' : tmp });\n            }\n        },\n        /**\n         * deselect all selected nodes\n         * @name deselect_all([supress_event])\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @trigger deselect_all.jstree, changed.jstree\n         */\n        deselect_all : function (supress_event) {\n            var tmp = this._data.core.selected.concat([]), i, j;\n            for(i = 0, j = this._data.core.selected.length; i < j; i++) {\n                if(this._model.data[this._data.core.selected[i]]) {\n                    this._model.data[this._data.core.selected[i]].state.selected = false;\n                }\n            }\n            this._data.core.selected = [];\n            this.element.find('.jstree-clicked').removeClass('jstree-clicked').attr('aria-selected', false);\n            /**\n             * triggered when all nodes are deselected\n             * @event\n             * @name deselect_all.jstree\n             * @param {Object} node the previous selection\n             * @param {Array} selected the current selection\n             */\n            this.trigger('deselect_all', { 'selected' : this._data.core.selected, 'node' : tmp });\n            if(!supress_event) {\n                this.trigger('changed', { 'action' : 'deselect_all', 'selected' : this._data.core.selected, 'old_selection' : tmp });\n            }\n        },\n        /**\n         * checks if a node is selected\n         * @name is_selected(obj)\n         * @param  {mixed}  obj\n         * @return {Boolean}\n         */\n        is_selected : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            return obj.state.selected;\n        },\n        /**\n         * get an array of all selected nodes\n         * @name get_selected([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         */\n        get_selected : function (full) {\n            return full ? $.map(this._data.core.selected, function (i) { return this.get_node(i); }.bind(this)) : this._data.core.selected.slice();\n        },\n        /**\n         * get an array of all top level selected nodes (ignoring children of selected nodes)\n         * @name get_top_selected([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         */\n        get_top_selected : function (full) {\n            var tmp = this.get_selected(true),\n                obj = {}, i, j, k, l;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                obj[tmp[i].id] = tmp[i];\n            }\n            for(i = 0, j = tmp.length; i < j; i++) {\n                for(k = 0, l = tmp[i].children_d.length; k < l; k++) {\n                    if(obj[tmp[i].children_d[k]]) {\n                        delete obj[tmp[i].children_d[k]];\n                    }\n                }\n            }\n            tmp = [];\n            for(i in obj) {\n                if(obj.hasOwnProperty(i)) {\n                    tmp.push(i);\n                }\n            }\n            return full ? $.map(tmp, function (i) { return this.get_node(i); }.bind(this)) : tmp;\n        },\n        /**\n         * get an array of all bottom level selected nodes (ignoring selected parents)\n         * @name get_bottom_selected([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         */\n        get_bottom_selected : function (full) {\n            var tmp = this.get_selected(true),\n                obj = [], i, j;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                if(!tmp[i].children.length) {\n                    obj.push(tmp[i].id);\n                }\n            }\n            return full ? $.map(obj, function (i) { return this.get_node(i); }.bind(this)) : obj;\n        },\n        /**\n         * gets the current state of the tree so that it can be restored later with `set_state(state)`. Used internally.\n         * @name get_state()\n         * @private\n         * @return {Object}\n         */\n        get_state : function () {\n            var state\t= {\n                'core' : {\n                    'open' : [],\n                    'loaded' : [],\n                    'scroll' : {\n                        'left' : this.element.scrollLeft(),\n                        'top' : this.element.scrollTop()\n                    },\n                    /*!\n\t\t\t\t\t'themes' : {\n\t\t\t\t\t\t'name' : this.get_theme(),\n\t\t\t\t\t\t'icons' : this._data.core.themes.icons,\n\t\t\t\t\t\t'dots' : this._data.core.themes.dots\n\t\t\t\t\t},\n\t\t\t\t\t*/\n                    'selected' : []\n                }\n            }, i;\n            for(i in this._model.data) {\n                if(this._model.data.hasOwnProperty(i)) {\n                    if(i !== $.jstree.root) {\n                        if(this._model.data[i].state.loaded && this.settings.core.loaded_state) {\n                            state.core.loaded.push(i);\n                        }\n                        if(this._model.data[i].state.opened) {\n                            state.core.open.push(i);\n                        }\n                        if(this._model.data[i].state.selected) {\n                            state.core.selected.push(i);\n                        }\n                    }\n                }\n            }\n            return state;\n        },\n        /**\n         * sets the state of the tree. Used internally.\n         * @name set_state(state [, callback])\n         * @private\n         * @param {Object} state the state to restore. Keep in mind this object is passed by reference and jstree will modify it.\n         * @param {Function} callback an optional function to execute once the state is restored.\n         * @trigger set_state.jstree\n         */\n        set_state : function (state, callback) {\n            if(state) {\n                if(state.core && state.core.selected && state.core.initial_selection === undefined) {\n                    state.core.initial_selection = this._data.core.selected.concat([]).sort().join(',');\n                }\n                if(state.core) {\n                    var res, n, t, _this, i;\n                    if(state.core.loaded) {\n                        if(!this.settings.core.loaded_state || !$.vakata.is_array(state.core.loaded) || !state.core.loaded.length) {\n                            delete state.core.loaded;\n                            this.set_state(state, callback);\n                        }\n                        else {\n                            this._load_nodes(state.core.loaded, function (nodes) {\n                                delete state.core.loaded;\n                                this.set_state(state, callback);\n                            });\n                        }\n                        return false;\n                    }\n                    if(state.core.open) {\n                        if(!$.vakata.is_array(state.core.open) || !state.core.open.length) {\n                            delete state.core.open;\n                            this.set_state(state, callback);\n                        }\n                        else {\n                            this._load_nodes(state.core.open, function (nodes) {\n                                this.open_node(nodes, false, 0);\n                                delete state.core.open;\n                                this.set_state(state, callback);\n                            });\n                        }\n                        return false;\n                    }\n                    if(state.core.scroll) {\n                        if(state.core.scroll && state.core.scroll.left !== undefined) {\n                            this.element.scrollLeft(state.core.scroll.left);\n                        }\n                        if(state.core.scroll && state.core.scroll.top !== undefined) {\n                            this.element.scrollTop(state.core.scroll.top);\n                        }\n                        delete state.core.scroll;\n                        this.set_state(state, callback);\n                        return false;\n                    }\n                    if(state.core.selected) {\n                        _this = this;\n                        if (state.core.initial_selection === undefined ||\n                            state.core.initial_selection === this._data.core.selected.concat([]).sort().join(',')\n                        ) {\n                            this.deselect_all();\n                            $.each(state.core.selected, function (i, v) {\n                                _this.select_node(v, false, true);\n                            });\n                        }\n                        delete state.core.initial_selection;\n                        delete state.core.selected;\n                        this.set_state(state, callback);\n                        return false;\n                    }\n                    for(i in state) {\n                        if(state.hasOwnProperty(i) && i !== \"core\" && $.inArray(i, this.settings.plugins) === -1) {\n                            delete state[i];\n                        }\n                    }\n                    if($.isEmptyObject(state.core)) {\n                        delete state.core;\n                        this.set_state(state, callback);\n                        return false;\n                    }\n                }\n                if($.isEmptyObject(state)) {\n                    state = null;\n                    if(callback) { callback.call(this); }\n                    /**\n                     * triggered when a `set_state` call completes\n                     * @event\n                     * @name set_state.jstree\n                     */\n                    this.trigger('set_state');\n                    return false;\n                }\n                return true;\n            }\n            return false;\n        },\n        /**\n         * refreshes the tree - all nodes are reloaded with calls to `load_node`.\n         * @name refresh()\n         * @param {Boolean} skip_loading an option to skip showing the loading indicator\n         * @param {Mixed} forget_state if set to `true` state will not be reapplied, if set to a function (receiving the current state as argument) the result of that function will be used as state\n         * @trigger refresh.jstree\n         */\n        refresh : function (skip_loading, forget_state) {\n            this._data.core.state = forget_state === true ? {} : this.get_state();\n            if(forget_state && $.vakata.is_function(forget_state)) { this._data.core.state = forget_state.call(this, this._data.core.state); }\n            this._cnt = 0;\n            this._model.data = {};\n            this._model.data[$.jstree.root] = {\n                id : $.jstree.root,\n                parent : null,\n                parents : [],\n                children : [],\n                children_d : [],\n                state : { loaded : false }\n            };\n            this._data.core.selected = [];\n            this._data.core.last_clicked = null;\n            this._data.core.focused = null;\n\n            var c = this.get_container_ul()[0].className;\n            if(!skip_loading) {\n                this.element.html(\"<\"+\"ul class='\"+c+\"' role='group'><\"+\"li class='jstree-initial-node jstree-loading jstree-leaf jstree-last' role='none' id='j\"+this._id+\"_loading'><i class='jstree-icon jstree-ocl'></i><\"+\"a class='jstree-anchor' role='treeitem' href='#'><i class='jstree-icon jstree-themeicon-hidden'></i>\" + this.get_string(\"Loading ...\") + \"</a></li></ul>\");\n                this.element.attr('aria-activedescendant','j'+this._id+'_loading');\n            }\n            this.load_node($.jstree.root, function (o, s) {\n                if(s) {\n                    this.get_container_ul()[0].className = c;\n                    if(this._firstChild(this.get_container_ul()[0])) {\n                        this.element.attr('aria-activedescendant',this._firstChild(this.get_container_ul()[0]).id);\n                    }\n                    this.set_state($.extend(true, {}, this._data.core.state), function () {\n                        /**\n                         * triggered when a `refresh` call completes\n                         * @event\n                         * @name refresh.jstree\n                         */\n                        this.trigger('refresh');\n                    });\n                }\n                this._data.core.state = null;\n            });\n        },\n        /**\n         * refreshes a node in the tree (reload its children) all opened nodes inside that node are reloaded with calls to `load_node`.\n         * @name refresh_node(obj)\n         * @param  {mixed} obj the node\n         * @trigger refresh_node.jstree\n         */\n        refresh_node : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            var opened = [], to_load = [], s = this._data.core.selected.concat([]);\n            to_load.push(obj.id);\n            if(obj.state.opened === true) { opened.push(obj.id); }\n            this.get_node(obj, true).find('.jstree-open').each(function() { to_load.push(this.id); opened.push(this.id); });\n            this._load_nodes(to_load, function (nodes) {\n                this.open_node(opened, false, 0);\n                this.select_node(s);\n                /**\n                 * triggered when a node is refreshed\n                 * @event\n                 * @name refresh_node.jstree\n                 * @param {Object} node - the refreshed node\n                 * @param {Array} nodes - an array of the IDs of the nodes that were reloaded\n                 */\n                this.trigger('refresh_node', { 'node' : obj, 'nodes' : nodes });\n            }.bind(this), false, true);\n        },\n        /**\n         * set (change) the ID of a node\n         * @name set_id(obj, id)\n         * @param  {mixed} obj the node\n         * @param  {String} id the new ID\n         * @return {Boolean}\n         * @trigger set_id.jstree\n         */\n        set_id : function (obj, id) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            var i, j, m = this._model.data, old = obj.id;\n            id = id.toString();\n            // update parents (replace current ID with new one in children and children_d)\n            m[obj.parent].children[$.inArray(obj.id, m[obj.parent].children)] = id;\n            for(i = 0, j = obj.parents.length; i < j; i++) {\n                m[obj.parents[i]].children_d[$.inArray(obj.id, m[obj.parents[i]].children_d)] = id;\n            }\n            // update children (replace current ID with new one in parent and parents)\n            for(i = 0, j = obj.children.length; i < j; i++) {\n                m[obj.children[i]].parent = id;\n            }\n            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                m[obj.children_d[i]].parents[$.inArray(obj.id, m[obj.children_d[i]].parents)] = id;\n            }\n            i = $.inArray(obj.id, this._data.core.selected);\n            if(i !== -1) { this._data.core.selected[i] = id; }\n            // update model and obj itself (obj.id, this._model.data[KEY])\n            i = this.get_node(obj.id, true);\n            if(i) {\n                i.attr('id', id); //.children('.jstree-anchor').attr('id', id + '_anchor').end().attr('aria-labelledby', id + '_anchor');\n                if(this.element.attr('aria-activedescendant') === obj.id) {\n                    this.element.attr('aria-activedescendant', id);\n                }\n            }\n            delete m[obj.id];\n            obj.id = id;\n            obj.li_attr.id = id;\n            m[id] = obj;\n            /**\n             * triggered when a node id value is changed\n             * @event\n             * @name set_id.jstree\n             * @param {Object} node\n             * @param {String} old the old id\n             */\n            this.trigger('set_id',{ \"node\" : obj, \"new\" : obj.id, \"old\" : old });\n            return true;\n        },\n        /**\n         * get the text value of a node\n         * @name get_text(obj)\n         * @param  {mixed} obj the node\n         * @return {String}\n         */\n        get_text : function (obj) {\n            obj = this.get_node(obj);\n            return (!obj || obj.id === $.jstree.root) ? false : obj.text;\n        },\n        /**\n         * set the text value of a node. Used internally, please use `rename_node(obj, val)`.\n         * @private\n         * @name set_text(obj, val)\n         * @param  {mixed} obj the node, you can pass an array to set the text on multiple nodes\n         * @param  {String} val the new text value\n         * @return {Boolean}\n         * @trigger set_text.jstree\n         */\n        set_text : function (obj, val) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.set_text(obj[t1], val);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            obj.text = val;\n            if(this.get_node(obj, true).length) {\n                this.redraw_node(obj.id);\n            }\n            /**\n             * triggered when a node text value is changed\n             * @event\n             * @name set_text.jstree\n             * @param {Object} obj\n             * @param {String} text the new value\n             */\n            this.trigger('set_text',{ \"obj\" : obj, \"text\" : val });\n            return true;\n        },\n        /**\n         * gets a JSON representation of a node (or the whole tree)\n         * @name get_json([obj, options])\n         * @param  {mixed} obj\n         * @param  {Object} options\n         * @param  {Boolean} options.no_state do not return state information\n         * @param  {Boolean} options.no_id do not return ID\n         * @param  {Boolean} options.no_children do not include children\n         * @param  {Boolean} options.no_data do not include node data\n         * @param  {Boolean} options.no_li_attr do not include LI attributes\n         * @param  {Boolean} options.no_a_attr do not include A attributes\n         * @param  {Boolean} options.flat return flat JSON instead of nested\n         * @return {Object}\n         */\n        get_json : function (obj, options, flat) {\n            obj = this.get_node(obj || $.jstree.root);\n            if(!obj) { return false; }\n            if(options && options.flat && !flat) { flat = []; }\n            var tmp = {\n                'id' : obj.id,\n                'text' : obj.text,\n                'icon' : this.get_icon(obj),\n                'li_attr' : $.extend(true, {}, obj.li_attr),\n                'a_attr' : $.extend(true, {}, obj.a_attr),\n                'state' : {},\n                'data' : options && options.no_data ? false : $.extend(true, $.vakata.is_array(obj.data)?[]:{}, obj.data)\n                //( this.get_node(obj, true).length ? this.get_node(obj, true).data() : obj.data ),\n            }, i, j;\n            if(options && options.flat) {\n                tmp.parent = obj.parent;\n            }\n            else {\n                tmp.children = [];\n            }\n            if(!options || !options.no_state) {\n                for(i in obj.state) {\n                    if(obj.state.hasOwnProperty(i)) {\n                        tmp.state[i] = obj.state[i];\n                    }\n                }\n            } else {\n                delete tmp.state;\n            }\n            if(options && options.no_li_attr) {\n                delete tmp.li_attr;\n            }\n            if(options && options.no_a_attr) {\n                delete tmp.a_attr;\n            }\n            if(options && options.no_id) {\n                delete tmp.id;\n                if(tmp.li_attr && tmp.li_attr.id) {\n                    delete tmp.li_attr.id;\n                }\n                if(tmp.a_attr && tmp.a_attr.id) {\n                    delete tmp.a_attr.id;\n                }\n            }\n            if(options && options.flat && obj.id !== $.jstree.root) {\n                flat.push(tmp);\n            }\n            if(!options || !options.no_children) {\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    if(options && options.flat) {\n                        this.get_json(obj.children[i], options, flat);\n                    }\n                    else {\n                        tmp.children.push(this.get_json(obj.children[i], options));\n                    }\n                }\n            }\n            return options && options.flat ? flat : (obj.id === $.jstree.root ? tmp.children : tmp);\n        },\n        /**\n         * create a new node (do not confuse with load_node)\n         * @name create_node([par, node, pos, callback, is_loaded])\n         * @param  {mixed}   par       the parent node (to create a root node use either \"#\" (string) or `null`)\n         * @param  {mixed}   node      the data for the new node (a valid JSON object, or a simple string with the name)\n         * @param  {mixed}   pos       the index at which to insert the node, \"first\" and \"last\" are also supported, default is \"last\"\n         * @param  {Function} callback a function to be called once the node is created\n         * @param  {Boolean} is_loaded internal argument indicating if the parent node was succesfully loaded\n         * @return {String}            the ID of the newly create node\n         * @trigger model.jstree, create_node.jstree\n         */\n        create_node : function (par, node, pos, callback, is_loaded) {\n            if(par === null) { par = $.jstree.root; }\n            par = this.get_node(par);\n            if(!par) { return false; }\n            pos = pos === undefined ? \"last\" : pos;\n            if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                return this.load_node(par, function () { this.create_node(par, node, pos, callback, true); });\n            }\n            if(!node) { node = { \"text\" : this.get_string('New node') }; }\n            if(typeof node === \"string\") {\n                node = { \"text\" : node };\n            } else {\n                node = $.extend(true, {}, node);\n            }\n            if(node.text === undefined) { node.text = this.get_string('New node'); }\n            var tmp, dpc, i, j;\n\n            if(par.id === $.jstree.root) {\n                if(pos === \"before\") { pos = \"first\"; }\n                if(pos === \"after\") { pos = \"last\"; }\n            }\n            switch(pos) {\n                case \"before\":\n                    tmp = this.get_node(par.parent);\n                    pos = $.inArray(par.id, tmp.children);\n                    par = tmp;\n                    break;\n                case \"after\" :\n                    tmp = this.get_node(par.parent);\n                    pos = $.inArray(par.id, tmp.children) + 1;\n                    par = tmp;\n                    break;\n                case \"inside\":\n                case \"first\":\n                    pos = 0;\n                    break;\n                case \"last\":\n                    pos = par.children.length;\n                    break;\n                default:\n                    if(!pos) { pos = 0; }\n                    break;\n            }\n            if(pos > par.children.length) { pos = par.children.length; }\n            if(!node.id) { node.id = true; }\n            if(!this.check(\"create_node\", node, par, pos)) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            if(node.id === true) { delete node.id; }\n            node = this._parse_model_from_json(node, par.id, par.parents.concat());\n            if(!node) { return false; }\n            tmp = this.get_node(node);\n            dpc = [];\n            dpc.push(node);\n            dpc = dpc.concat(tmp.children_d);\n            this.trigger('model', { \"nodes\" : dpc, \"parent\" : par.id });\n\n            par.children_d = par.children_d.concat(dpc);\n            for(i = 0, j = par.parents.length; i < j; i++) {\n                this._model.data[par.parents[i]].children_d = this._model.data[par.parents[i]].children_d.concat(dpc);\n            }\n            node = tmp;\n            tmp = [];\n            for(i = 0, j = par.children.length; i < j; i++) {\n                tmp[i >= pos ? i+1 : i] = par.children[i];\n            }\n            tmp[pos] = node.id;\n            par.children = tmp;\n\n            this.redraw_node(par, true);\n            /**\n             * triggered when a node is created\n             * @event\n             * @name create_node.jstree\n             * @param {Object} node\n             * @param {String} parent the parent's ID\n             * @param {Number} position the position of the new node among the parent's children\n             */\n            this.trigger('create_node', { \"node\" : this.get_node(node), \"parent\" : par.id, \"position\" : pos });\n            if(callback) { callback.call(this, this.get_node(node)); }\n            return node.id;\n        },\n        /**\n         * set the text value of a node\n         * @name rename_node(obj, val)\n         * @param  {mixed} obj the node, you can pass an array to rename multiple nodes to the same name\n         * @param  {String} val the new text value\n         * @return {Boolean}\n         * @trigger rename_node.jstree\n         */\n        rename_node : function (obj, val) {\n            var t1, t2, old;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.rename_node(obj[t1], val);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            old = obj.text;\n            if(!this.check(\"rename_node\", obj, this.get_parent(obj), val)) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            this.set_text(obj, val); // .apply(this, Array.prototype.slice.call(arguments))\n            /**\n             * triggered when a node is renamed\n             * @event\n             * @name rename_node.jstree\n             * @param {Object} node\n             * @param {String} text the new value\n             * @param {String} old the old value\n             */\n            this.trigger('rename_node', { \"node\" : obj, \"text\" : val, \"old\" : old });\n            return true;\n        },\n        /**\n         * remove a node\n         * @name delete_node(obj)\n         * @param  {mixed} obj the node, you can pass an array to delete multiple nodes\n         * @return {Boolean}\n         * @trigger delete_node.jstree, changed.jstree\n         */\n        delete_node : function (obj) {\n            var t1, t2, par, pos, tmp, i, j, k, l, c, top, lft;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.delete_node(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            par = this.get_node(obj.parent);\n            pos = $.inArray(obj.id, par.children);\n            c = false;\n            if(!this.check(\"delete_node\", obj, par, pos)) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            if(pos !== -1) {\n                par.children = $.vakata.array_remove(par.children, pos);\n            }\n            tmp = obj.children_d.concat([]);\n            tmp.push(obj.id);\n            for(i = 0, j = obj.parents.length; i < j; i++) {\n                this._model.data[obj.parents[i]].children_d = $.vakata.array_filter(this._model.data[obj.parents[i]].children_d, function (v) {\n                    return $.inArray(v, tmp) === -1;\n                });\n            }\n            for(k = 0, l = tmp.length; k < l; k++) {\n                if(this._model.data[tmp[k]].state.selected) {\n                    c = true;\n                    break;\n                }\n            }\n            if (c) {\n                this._data.core.selected = $.vakata.array_filter(this._data.core.selected, function (v) {\n                    return $.inArray(v, tmp) === -1;\n                });\n            }\n            /**\n             * triggered when a node is deleted\n             * @event\n             * @name delete_node.jstree\n             * @param {Object} node\n             * @param {String} parent the parent's ID\n             */\n            this.trigger('delete_node', { \"node\" : obj, \"parent\" : par.id });\n            if(c) {\n                this.trigger('changed', { 'action' : 'delete_node', 'node' : obj, 'selected' : this._data.core.selected, 'parent' : par.id });\n            }\n            for(k = 0, l = tmp.length; k < l; k++) {\n                delete this._model.data[tmp[k]];\n            }\n            if($.inArray(this._data.core.focused, tmp) !== -1) {\n                this._data.core.focused = null;\n                top = this.element[0].scrollTop;\n                lft = this.element[0].scrollLeft;\n                if(par.id === $.jstree.root) {\n                    if (this._model.data[$.jstree.root].children[0]) {\n                        this.get_node(this._model.data[$.jstree.root].children[0], true).children('.jstree-anchor').triger('focus');\n                    }\n                }\n                else {\n                    this.get_node(par, true).children('.jstree-anchor').trigger('focus');\n                }\n                this.element[0].scrollTop  = top;\n                this.element[0].scrollLeft = lft;\n            }\n            this.redraw_node(par, true);\n            return true;\n        },\n        /**\n         * check if an operation is premitted on the tree. Used internally.\n         * @private\n         * @name check(chk, obj, par, pos)\n         * @param  {String} chk the operation to check, can be \"create_node\", \"rename_node\", \"delete_node\", \"copy_node\" or \"move_node\"\n         * @param  {mixed} obj the node\n         * @param  {mixed} par the parent\n         * @param  {mixed} pos the position to insert at, or if \"rename_node\" - the new name\n         * @param  {mixed} more some various additional information, for example if a \"move_node\" operations is triggered by DND this will be the hovered node\n         * @return {Boolean}\n         */\n        check : function (chk, obj, par, pos, more) {\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            par = par && par.id ? par : this.get_node(par);\n            var tmp = chk.match(/^move_node|copy_node|create_node$/i) ? par : obj,\n                chc = this.settings.core.check_callback;\n            if(chk === \"move_node\" || chk === \"copy_node\") {\n                if((!more || !more.is_multi) && (chk === \"move_node\" && $.inArray(obj.id, par.children) === pos)) {\n                    this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_08', 'reason' : 'Moving node to its current position', 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    return false;\n                }\n                if((!more || !more.is_multi) && (obj.id === par.id || (chk === \"move_node\" && $.inArray(obj.id, par.children) === pos) || $.inArray(par.id, obj.children_d) !== -1)) {\n                    this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_01', 'reason' : 'Moving parent inside child', 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    return false;\n                }\n            }\n            if(tmp && tmp.data) { tmp = tmp.data; }\n            if(tmp && tmp.functions && (tmp.functions[chk] === false || tmp.functions[chk] === true)) {\n                if(tmp.functions[chk] === false) {\n                    this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_02', 'reason' : 'Node data prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                }\n                return tmp.functions[chk];\n            }\n            if(chc === false || ($.vakata.is_function(chc) && chc.call(this, chk, obj, par, pos, more) === false) || (chc && chc[chk] === false)) {\n                this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_03', 'reason' : 'User config for core.check_callback prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                return false;\n            }\n            return true;\n        },\n        /**\n         * get the last error\n         * @name last_error()\n         * @return {Object}\n         */\n        last_error : function () {\n            return this._data.core.last_error;\n        },\n        /**\n         * move a node to a new parent\n         * @name move_node(obj, par [, pos, callback, is_loaded])\n         * @param  {mixed} obj the node to move, pass an array to move multiple nodes\n         * @param  {mixed} par the new parent\n         * @param  {mixed} pos the position to insert at (besides integer values, \"first\" and \"last\" are supported, as well as \"before\" and \"after\"), defaults to integer `0`\n         * @param  {function} callback a function to call once the move is completed, receives 3 arguments - the node, the new parent and the position\n         * @param  {Boolean} is_loaded internal parameter indicating if the parent node has been loaded\n         * @param  {Boolean} skip_redraw internal parameter indicating if the tree should be redrawn\n         * @param  {Boolean} instance internal parameter indicating if the node comes from another instance\n         * @trigger move_node.jstree\n         */\n        move_node : function (obj, par, pos, callback, is_loaded, skip_redraw, origin) {\n            var t1, t2, old_par, old_pos, new_par, old_ins, is_multi, dpc, tmp, i, j, k, l, p;\n\n            par = this.get_node(par);\n            pos = pos === undefined ? 0 : pos;\n            if(!par) { return false; }\n            if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                return this.load_node(par, function () { this.move_node(obj, par, pos, callback, true, false, origin); });\n            }\n\n            if($.vakata.is_array(obj)) {\n                if(obj.length === 1) {\n                    obj = obj[0];\n                }\n                else {\n                    //obj = obj.slice();\n                    for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                        if((tmp = this.move_node(obj[t1], par, pos, callback, is_loaded, false, origin))) {\n                            par = tmp;\n                            pos = \"after\";\n                        }\n                    }\n                    this.redraw();\n                    return true;\n                }\n            }\n            obj = obj && obj.id ? obj : this.get_node(obj);\n\n            if(!obj || obj.id === $.jstree.root) { return false; }\n\n            old_par = (obj.parent || $.jstree.root).toString();\n            new_par = (!pos.toString().match(/^(before|after)$/) || par.id === $.jstree.root) ? par : this.get_node(par.parent);\n            old_ins = origin ? origin : (this._model.data[obj.id] ? this : $.jstree.reference(obj.id));\n            is_multi = !old_ins || !old_ins._id || (this._id !== old_ins._id);\n            old_pos = old_ins && old_ins._id && old_par && old_ins._model.data[old_par] && old_ins._model.data[old_par].children ? $.inArray(obj.id, old_ins._model.data[old_par].children) : -1;\n            if(old_ins && old_ins._id) {\n                obj = old_ins._model.data[obj.id];\n            }\n\n            if(is_multi) {\n                if((tmp = this.copy_node(obj, par, pos, callback, is_loaded, false, origin))) {\n                    if(old_ins) { old_ins.delete_node(obj); }\n                    return tmp;\n                }\n                return false;\n            }\n            //var m = this._model.data;\n            if(par.id === $.jstree.root) {\n                if(pos === \"before\") { pos = \"first\"; }\n                if(pos === \"after\") { pos = \"last\"; }\n            }\n            switch(pos) {\n                case \"before\":\n                    pos = $.inArray(par.id, new_par.children);\n                    break;\n                case \"after\" :\n                    pos = $.inArray(par.id, new_par.children) + 1;\n                    break;\n                case \"inside\":\n                case \"first\":\n                    pos = 0;\n                    break;\n                case \"last\":\n                    pos = new_par.children.length;\n                    break;\n                default:\n                    if(!pos) { pos = 0; }\n                    break;\n            }\n            if(pos > new_par.children.length) { pos = new_par.children.length; }\n            if(!this.check(\"move_node\", obj, new_par, pos, { 'core' : true, 'origin' : origin, 'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id) })) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            if(obj.parent === new_par.id) {\n                dpc = new_par.children.concat();\n                tmp = $.inArray(obj.id, dpc);\n                if(tmp !== -1) {\n                    dpc = $.vakata.array_remove(dpc, tmp);\n                    if(pos > tmp) { pos--; }\n                }\n                tmp = [];\n                for(i = 0, j = dpc.length; i < j; i++) {\n                    tmp[i >= pos ? i+1 : i] = dpc[i];\n                }\n                tmp[pos] = obj.id;\n                new_par.children = tmp;\n                this._node_changed(new_par.id);\n                this.redraw(new_par.id === $.jstree.root);\n            }\n            else {\n                // clean old parent and up\n                tmp = obj.children_d.concat();\n                tmp.push(obj.id);\n                for(i = 0, j = obj.parents.length; i < j; i++) {\n                    dpc = [];\n                    p = old_ins._model.data[obj.parents[i]].children_d;\n                    for(k = 0, l = p.length; k < l; k++) {\n                        if($.inArray(p[k], tmp) === -1) {\n                            dpc.push(p[k]);\n                        }\n                    }\n                    old_ins._model.data[obj.parents[i]].children_d = dpc;\n                }\n                old_ins._model.data[old_par].children = $.vakata.array_remove_item(old_ins._model.data[old_par].children, obj.id);\n\n                // insert into new parent and up\n                for(i = 0, j = new_par.parents.length; i < j; i++) {\n                    this._model.data[new_par.parents[i]].children_d = this._model.data[new_par.parents[i]].children_d.concat(tmp);\n                }\n                dpc = [];\n                for(i = 0, j = new_par.children.length; i < j; i++) {\n                    dpc[i >= pos ? i+1 : i] = new_par.children[i];\n                }\n                dpc[pos] = obj.id;\n                new_par.children = dpc;\n                new_par.children_d.push(obj.id);\n                new_par.children_d = new_par.children_d.concat(obj.children_d);\n\n                // update object\n                obj.parent = new_par.id;\n                tmp = new_par.parents.concat();\n                tmp.unshift(new_par.id);\n                p = obj.parents.length;\n                obj.parents = tmp;\n\n                // update object children\n                tmp = tmp.concat();\n                for(i = 0, j = obj.children_d.length; i < j; i++) {\n                    this._model.data[obj.children_d[i]].parents = this._model.data[obj.children_d[i]].parents.slice(0,p*-1);\n                    Array.prototype.push.apply(this._model.data[obj.children_d[i]].parents, tmp);\n                }\n\n                if(old_par === $.jstree.root || new_par.id === $.jstree.root) {\n                    this._model.force_full_redraw = true;\n                }\n                if(!this._model.force_full_redraw) {\n                    this._node_changed(old_par);\n                    this._node_changed(new_par.id);\n                }\n                if(!skip_redraw) {\n                    this.redraw();\n                }\n            }\n            if(callback) { callback.call(this, obj, new_par, pos); }\n            /**\n             * triggered when a node is moved\n             * @event\n             * @name move_node.jstree\n             * @param {Object} node\n             * @param {String} parent the parent's ID\n             * @param {Number} position the position of the node among the parent's children\n             * @param {String} old_parent the old parent of the node\n             * @param {Number} old_position the old position of the node\n             * @param {Boolean} is_multi do the node and new parent belong to different instances\n             * @param {jsTree} old_instance the instance the node came from\n             * @param {jsTree} new_instance the instance of the new parent\n             */\n            this.trigger('move_node', { \"node\" : obj, \"parent\" : new_par.id, \"position\" : pos, \"old_parent\" : old_par, \"old_position\" : old_pos, 'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id), 'old_instance' : old_ins, 'new_instance' : this });\n            return obj.id;\n        },\n        /**\n         * copy a node to a new parent\n         * @name copy_node(obj, par [, pos, callback, is_loaded])\n         * @param  {mixed} obj the node to copy, pass an array to copy multiple nodes\n         * @param  {mixed} par the new parent\n         * @param  {mixed} pos the position to insert at (besides integer values, \"first\" and \"last\" are supported, as well as \"before\" and \"after\"), defaults to integer `0`\n         * @param  {function} callback a function to call once the move is completed, receives 3 arguments - the node, the new parent and the position\n         * @param  {Boolean} is_loaded internal parameter indicating if the parent node has been loaded\n         * @param  {Boolean} skip_redraw internal parameter indicating if the tree should be redrawn\n         * @param  {Boolean} instance internal parameter indicating if the node comes from another instance\n         * @trigger model.jstree copy_node.jstree\n         */\n        copy_node : function (obj, par, pos, callback, is_loaded, skip_redraw, origin) {\n            var t1, t2, dpc, tmp, i, j, node, old_par, new_par, old_ins, is_multi;\n\n            par = this.get_node(par);\n            pos = pos === undefined ? 0 : pos;\n            if(!par) { return false; }\n            if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                return this.load_node(par, function () { this.copy_node(obj, par, pos, callback, true, false, origin); });\n            }\n\n            if($.vakata.is_array(obj)) {\n                if(obj.length === 1) {\n                    obj = obj[0];\n                }\n                else {\n                    //obj = obj.slice();\n                    for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                        if((tmp = this.copy_node(obj[t1], par, pos, callback, is_loaded, true, origin))) {\n                            par = tmp;\n                            pos = \"after\";\n                        }\n                    }\n                    this.redraw();\n                    return true;\n                }\n            }\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n\n            old_par = (obj.parent || $.jstree.root).toString();\n            new_par = (!pos.toString().match(/^(before|after)$/) || par.id === $.jstree.root) ? par : this.get_node(par.parent);\n            old_ins = origin ? origin : (this._model.data[obj.id] ? this : $.jstree.reference(obj.id));\n            is_multi = !old_ins || !old_ins._id || (this._id !== old_ins._id);\n\n            if(old_ins && old_ins._id) {\n                obj = old_ins._model.data[obj.id];\n            }\n\n            if(par.id === $.jstree.root) {\n                if(pos === \"before\") { pos = \"first\"; }\n                if(pos === \"after\") { pos = \"last\"; }\n            }\n            switch(pos) {\n                case \"before\":\n                    pos = $.inArray(par.id, new_par.children);\n                    break;\n                case \"after\" :\n                    pos = $.inArray(par.id, new_par.children) + 1;\n                    break;\n                case \"inside\":\n                case \"first\":\n                    pos = 0;\n                    break;\n                case \"last\":\n                    pos = new_par.children.length;\n                    break;\n                default:\n                    if(!pos) { pos = 0; }\n                    break;\n            }\n            if(pos > new_par.children.length) { pos = new_par.children.length; }\n            if(!this.check(\"copy_node\", obj, new_par, pos, { 'core' : true, 'origin' : origin, 'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id) })) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            node = old_ins ? old_ins.get_json(obj, { no_id : true, no_data : true, no_state : true }) : obj;\n            if(!node) { return false; }\n            if(node.id === true) { delete node.id; }\n            node = this._parse_model_from_json(node, new_par.id, new_par.parents.concat());\n            if(!node) { return false; }\n            tmp = this.get_node(node);\n            if(obj && obj.state && obj.state.loaded === false) { tmp.state.loaded = false; }\n            dpc = [];\n            dpc.push(node);\n            dpc = dpc.concat(tmp.children_d);\n            this.trigger('model', { \"nodes\" : dpc, \"parent\" : new_par.id });\n\n            // insert into new parent and up\n            for(i = 0, j = new_par.parents.length; i < j; i++) {\n                this._model.data[new_par.parents[i]].children_d = this._model.data[new_par.parents[i]].children_d.concat(dpc);\n            }\n            dpc = [];\n            for(i = 0, j = new_par.children.length; i < j; i++) {\n                dpc[i >= pos ? i+1 : i] = new_par.children[i];\n            }\n            dpc[pos] = tmp.id;\n            new_par.children = dpc;\n            new_par.children_d.push(tmp.id);\n            new_par.children_d = new_par.children_d.concat(tmp.children_d);\n\n            if(new_par.id === $.jstree.root) {\n                this._model.force_full_redraw = true;\n            }\n            if(!this._model.force_full_redraw) {\n                this._node_changed(new_par.id);\n            }\n            if(!skip_redraw) {\n                this.redraw(new_par.id === $.jstree.root);\n            }\n            if(callback) { callback.call(this, tmp, new_par, pos); }\n            /**\n             * triggered when a node is copied\n             * @event\n             * @name copy_node.jstree\n             * @param {Object} node the copied node\n             * @param {Object} original the original node\n             * @param {String} parent the parent's ID\n             * @param {Number} position the position of the node among the parent's children\n             * @param {String} old_parent the old parent of the node\n             * @param {Number} old_position the position of the original node\n             * @param {Boolean} is_multi do the node and new parent belong to different instances\n             * @param {jsTree} old_instance the instance the node came from\n             * @param {jsTree} new_instance the instance of the new parent\n             */\n            this.trigger('copy_node', { \"node\" : tmp, \"original\" : obj, \"parent\" : new_par.id, \"position\" : pos, \"old_parent\" : old_par, \"old_position\" : old_ins && old_ins._id && old_par && old_ins._model.data[old_par] && old_ins._model.data[old_par].children ? $.inArray(obj.id, old_ins._model.data[old_par].children) : -1,'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id), 'old_instance' : old_ins, 'new_instance' : this });\n            return tmp.id;\n        },\n        /**\n         * cut a node (a later call to `paste(obj)` would move the node)\n         * @name cut(obj)\n         * @param  {mixed} obj multiple objects can be passed using an array\n         * @trigger cut.jstree\n         */\n        cut : function (obj) {\n            if(!obj) { obj = this._data.core.selected.concat(); }\n            if(!$.vakata.is_array(obj)) { obj = [obj]; }\n            if(!obj.length) { return false; }\n            var tmp = [], o, t1, t2;\n            for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                o = this.get_node(obj[t1]);\n                if(o && o.id && o.id !== $.jstree.root) { tmp.push(o); }\n            }\n            if(!tmp.length) { return false; }\n            ccp_node = tmp;\n            ccp_inst = this;\n            ccp_mode = 'move_node';\n            /**\n             * triggered when nodes are added to the buffer for moving\n             * @event\n             * @name cut.jstree\n             * @param {Array} node\n             */\n            this.trigger('cut', { \"node\" : obj });\n        },\n        /**\n         * copy a node (a later call to `paste(obj)` would copy the node)\n         * @name copy(obj)\n         * @param  {mixed} obj multiple objects can be passed using an array\n         * @trigger copy.jstree\n         */\n        copy : function (obj) {\n            if(!obj) { obj = this._data.core.selected.concat(); }\n            if(!$.vakata.is_array(obj)) { obj = [obj]; }\n            if(!obj.length) { return false; }\n            var tmp = [], o, t1, t2;\n            for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                o = this.get_node(obj[t1]);\n                if(o && o.id && o.id !== $.jstree.root) { tmp.push(o); }\n            }\n            if(!tmp.length) { return false; }\n            ccp_node = tmp;\n            ccp_inst = this;\n            ccp_mode = 'copy_node';\n            /**\n             * triggered when nodes are added to the buffer for copying\n             * @event\n             * @name copy.jstree\n             * @param {Array} node\n             */\n            this.trigger('copy', { \"node\" : obj });\n        },\n        /**\n         * get the current buffer (any nodes that are waiting for a paste operation)\n         * @name get_buffer()\n         * @return {Object} an object consisting of `mode` (\"copy_node\" or \"move_node\"), `node` (an array of objects) and `inst` (the instance)\n         */\n        get_buffer : function () {\n            return { 'mode' : ccp_mode, 'node' : ccp_node, 'inst' : ccp_inst };\n        },\n        /**\n         * check if there is something in the buffer to paste\n         * @name can_paste()\n         * @return {Boolean}\n         */\n        can_paste : function () {\n            return ccp_mode !== false && ccp_node !== false; // && ccp_inst._model.data[ccp_node];\n        },\n        /**\n         * copy or move the previously cut or copied nodes to a new parent\n         * @name paste(obj [, pos])\n         * @param  {mixed} obj the new parent\n         * @param  {mixed} pos the position to insert at (besides integer, \"first\" and \"last\" are supported), defaults to integer `0`\n         * @trigger paste.jstree\n         */\n        paste : function (obj, pos) {\n            obj = this.get_node(obj);\n            if(!obj || !ccp_mode || !ccp_mode.match(/^(copy_node|move_node)$/) || !ccp_node) { return false; }\n            if(this[ccp_mode](ccp_node, obj, pos, false, false, false, ccp_inst)) {\n                /**\n                 * triggered when paste is invoked\n                 * @event\n                 * @name paste.jstree\n                 * @param {String} parent the ID of the receiving node\n                 * @param {Array} node the nodes in the buffer\n                 * @param {String} mode the performed operation - \"copy_node\" or \"move_node\"\n                 */\n                this.trigger('paste', { \"parent\" : obj.id, \"node\" : ccp_node, \"mode\" : ccp_mode });\n            }\n            ccp_node = false;\n            ccp_mode = false;\n            ccp_inst = false;\n        },\n        /**\n         * clear the buffer of previously copied or cut nodes\n         * @name clear_buffer()\n         * @trigger clear_buffer.jstree\n         */\n        clear_buffer : function () {\n            ccp_node = false;\n            ccp_mode = false;\n            ccp_inst = false;\n            /**\n             * triggered when the copy / cut buffer is cleared\n             * @event\n             * @name clear_buffer.jstree\n             */\n            this.trigger('clear_buffer');\n        },\n        /**\n         * put a node in edit mode (input field to rename the node)\n         * @name edit(obj [, default_text, callback])\n         * @param  {mixed} obj\n         * @param  {String} default_text the text to populate the input with (if omitted or set to a non-string value the node's text value is used)\n         * @param  {Function} callback a function to be called once the text box is blurred, it is called in the instance's scope and receives the node, a status parameter (true if the rename is successful, false otherwise), a boolean indicating if the user cancelled the edit and the original unescaped value provided by the user. You can also access the node's title using .text\n         */\n        edit : function (obj, default_text, callback) {\n            var rtl, w, a, s, t, h1, h2, fn, tmp, cancel = false;\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            if(!this.check(\"edit\", obj, this.get_parent(obj))) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            tmp = obj;\n            default_text = typeof default_text === 'string' ? default_text : obj.text;\n            this.set_text(obj, \"\");\n            obj = this._open_to(obj);\n            tmp.text = default_text;\n\n            rtl = this._data.core.rtl;\n            w  = this.element.width();\n            this._data.core.focused = tmp.id;\n            a  = obj.children('.jstree-anchor').trigger('focus');\n            s  = $('<span></span>');\n            /*!\n\t\t\toi = obj.children(\"i:visible\"),\n\t\t\tai = a.children(\"i:visible\"),\n\t\t\tw1 = oi.width() * oi.length,\n\t\t\tw2 = ai.width() * ai.length,\n\t\t\t*/\n            t  = default_text;\n            h1 = $(\"<\"+\"div></div>\", { css : { \"position\" : \"absolute\", \"top\" : \"-200px\", \"left\" : (rtl ? \"0px\" : \"-1000px\"), \"visibility\" : \"hidden\" } }).appendTo(document.body);\n            h2 = $(\"<\"+\"input />\", {\n                \"value\" : t,\n                \"class\" : \"jstree-rename-input\",\n                // \"size\" : t.length,\n                \"css\" : {\n                    \"padding\" : \"0\",\n                    \"border\" : \"1px solid silver\",\n                    \"box-sizing\" : \"border-box\",\n                    \"display\" : \"inline-block\",\n                    \"height\" : (this._data.core.li_height) + \"px\",\n                    \"lineHeight\" : (this._data.core.li_height) + \"px\",\n                    \"width\" : \"150px\" // will be set a bit further down\n                },\n                \"blur\" : function (e) {\n                    e.stopImmediatePropagation();\n                    e.preventDefault();\n                    var i = s.children(\".jstree-rename-input\"),\n                        v = i.val(),\n                        f = this.settings.core.force_text,\n                        nv;\n                    if(v === \"\") { v = t; }\n                    h1.remove();\n                    s.replaceWith(a);\n                    s.remove();\n                    t = f ? t : $('<div></div>').append($.parseHTML(t)).html();\n                    obj = this.get_node(obj);\n                    this.set_text(obj, t);\n                    nv = !!this.rename_node(obj, f ? $('<div></div>').text(v).text() : $('<div></div>').append($.parseHTML(v)).html());\n                    if(!nv) {\n                        this.set_text(obj, t); // move this up? and fix #483\n                    }\n                    this._data.core.focused = tmp.id;\n                    setTimeout(function () {\n                        var node = this.get_node(tmp.id, true);\n                        if(node.length) {\n                            this._data.core.focused = tmp.id;\n                            node.children('.jstree-anchor').trigger('focus');\n                        }\n                    }.bind(this), 0);\n                    if(callback) {\n                        callback.call(this, tmp, nv, cancel, v);\n                    }\n                    h2 = null;\n                }.bind(this),\n                \"keydown\" : function (e) {\n                    var key = e.which;\n                    if(key === 27) {\n                        cancel = true;\n                        this.value = t;\n                    }\n                    if(key === 27 || key === 13 || key === 37 || key === 38 || key === 39 || key === 40 || key === 32) {\n                        e.stopImmediatePropagation();\n                    }\n                    if(key === 27 || key === 13) {\n                        e.preventDefault();\n                        this.blur();\n                    }\n                },\n                \"click\" : function (e) { e.stopImmediatePropagation(); },\n                \"mousedown\" : function (e) { e.stopImmediatePropagation(); },\n                \"keyup\" : function (e) {\n                    h2.width(Math.min(h1.text(\"pW\" + this.value).width(),w));\n                },\n                \"keypress\" : function(e) {\n                    if(e.which === 13) { return false; }\n                }\n            });\n            fn = {\n                fontFamily\t\t: a.css('fontFamily')\t\t|| '',\n                fontSize\t\t: a.css('fontSize')\t\t\t|| '',\n                fontWeight\t\t: a.css('fontWeight')\t\t|| '',\n                fontStyle\t\t: a.css('fontStyle')\t\t|| '',\n                fontStretch\t\t: a.css('fontStretch')\t\t|| '',\n                fontVariant\t\t: a.css('fontVariant')\t\t|| '',\n                letterSpacing\t: a.css('letterSpacing')\t|| '',\n                wordSpacing\t\t: a.css('wordSpacing')\t\t|| ''\n            };\n            s.attr('class', a.attr('class')).append(a.contents().clone()).append(h2);\n            a.replaceWith(s);\n            h1.css(fn);\n            h2.css(fn).width(Math.min(h1.text(\"pW\" + h2[0].value).width(),w))[0].select();\n            $(document).one('mousedown.jstree touchstart.jstree dnd_start.vakata', function (e) {\n                if (h2 && e.target !== h2) {\n                    $(h2).trigger('blur');\n                }\n            });\n        },\n\n\n        /**\n         * changes the theme\n         * @name set_theme(theme_name [, theme_url])\n         * @param {String} theme_name the name of the new theme to apply\n         * @param {mixed} theme_url  the location of the CSS file for this theme. Omit or set to `false` if you manually included the file. Set to `true` to autoload from the `core.themes.dir` directory.\n         * @trigger set_theme.jstree\n         */\n        set_theme : function (theme_name, theme_url) {\n            if(!theme_name) { return false; }\n            if(theme_url === true) {\n                var dir = this.settings.core.themes.dir;\n                if(!dir) { dir = $.jstree.path + '/themes'; }\n                theme_url = dir + '/' + theme_name + '/style.css';\n            }\n            if(theme_url && $.inArray(theme_url, themes_loaded) === -1) {\n                $('head').append('<'+'link rel=\"stylesheet\" href=\"' + theme_url + '\" type=\"text/css\" />');\n                themes_loaded.push(theme_url);\n            }\n            if(this._data.core.themes.name) {\n                this.element.removeClass('jstree-' + this._data.core.themes.name);\n            }\n            this._data.core.themes.name = theme_name;\n            this.element.addClass('jstree-' + theme_name);\n            this.element[this.settings.core.themes.responsive ? 'addClass' : 'removeClass' ]('jstree-' + theme_name + '-responsive');\n            /**\n             * triggered when a theme is set\n             * @event\n             * @name set_theme.jstree\n             * @param {String} theme the new theme\n             */\n            this.trigger('set_theme', { 'theme' : theme_name });\n        },\n        /**\n         * gets the name of the currently applied theme name\n         * @name get_theme()\n         * @return {String}\n         */\n        get_theme : function () { return this._data.core.themes.name; },\n        /**\n         * changes the theme variant (if the theme has variants)\n         * @name set_theme_variant(variant_name)\n         * @param {String|Boolean} variant_name the variant to apply (if `false` is used the current variant is removed)\n         */\n        set_theme_variant : function (variant_name) {\n            if(this._data.core.themes.variant) {\n                this.element.removeClass('jstree-' + this._data.core.themes.name + '-' + this._data.core.themes.variant);\n            }\n            this._data.core.themes.variant = variant_name;\n            if(variant_name) {\n                this.element.addClass('jstree-' + this._data.core.themes.name + '-' + this._data.core.themes.variant);\n            }\n        },\n        /**\n         * gets the name of the currently applied theme variant\n         * @name get_theme()\n         * @return {String}\n         */\n        get_theme_variant : function () { return this._data.core.themes.variant; },\n        /**\n         * shows a striped background on the container (if the theme supports it)\n         * @name show_stripes()\n         */\n        show_stripes : function () {\n            this._data.core.themes.stripes = true;\n            this.get_container_ul().addClass(\"jstree-striped\");\n            /**\n             * triggered when stripes are shown\n             * @event\n             * @name show_stripes.jstree\n             */\n            this.trigger('show_stripes');\n        },\n        /**\n         * hides the striped background on the container\n         * @name hide_stripes()\n         */\n        hide_stripes : function () {\n            this._data.core.themes.stripes = false;\n            this.get_container_ul().removeClass(\"jstree-striped\");\n            /**\n             * triggered when stripes are hidden\n             * @event\n             * @name hide_stripes.jstree\n             */\n            this.trigger('hide_stripes');\n        },\n        /**\n         * toggles the striped background on the container\n         * @name toggle_stripes()\n         */\n        toggle_stripes : function () { if(this._data.core.themes.stripes) { this.hide_stripes(); } else { this.show_stripes(); } },\n        /**\n         * shows the connecting dots (if the theme supports it)\n         * @name show_dots()\n         */\n        show_dots : function () {\n            this._data.core.themes.dots = true;\n            this.get_container_ul().removeClass(\"jstree-no-dots\");\n            /**\n             * triggered when dots are shown\n             * @event\n             * @name show_dots.jstree\n             */\n            this.trigger('show_dots');\n        },\n        /**\n         * hides the connecting dots\n         * @name hide_dots()\n         */\n        hide_dots : function () {\n            this._data.core.themes.dots = false;\n            this.get_container_ul().addClass(\"jstree-no-dots\");\n            /**\n             * triggered when dots are hidden\n             * @event\n             * @name hide_dots.jstree\n             */\n            this.trigger('hide_dots');\n        },\n        /**\n         * toggles the connecting dots\n         * @name toggle_dots()\n         */\n        toggle_dots : function () { if(this._data.core.themes.dots) { this.hide_dots(); } else { this.show_dots(); } },\n        /**\n         * show the node icons\n         * @name show_icons()\n         */\n        show_icons : function () {\n            this._data.core.themes.icons = true;\n            this.get_container_ul().removeClass(\"jstree-no-icons\");\n            /**\n             * triggered when icons are shown\n             * @event\n             * @name show_icons.jstree\n             */\n            this.trigger('show_icons');\n        },\n        /**\n         * hide the node icons\n         * @name hide_icons()\n         */\n        hide_icons : function () {\n            this._data.core.themes.icons = false;\n            this.get_container_ul().addClass(\"jstree-no-icons\");\n            /**\n             * triggered when icons are hidden\n             * @event\n             * @name hide_icons.jstree\n             */\n            this.trigger('hide_icons');\n        },\n        /**\n         * toggle the node icons\n         * @name toggle_icons()\n         */\n        toggle_icons : function () { if(this._data.core.themes.icons) { this.hide_icons(); } else { this.show_icons(); } },\n        /**\n         * show the node ellipsis\n         * @name show_icons()\n         */\n        show_ellipsis : function () {\n            this._data.core.themes.ellipsis = true;\n            this.get_container_ul().addClass(\"jstree-ellipsis\");\n            /**\n             * triggered when ellisis is shown\n             * @event\n             * @name show_ellipsis.jstree\n             */\n            this.trigger('show_ellipsis');\n        },\n        /**\n         * hide the node ellipsis\n         * @name hide_ellipsis()\n         */\n        hide_ellipsis : function () {\n            this._data.core.themes.ellipsis = false;\n            this.get_container_ul().removeClass(\"jstree-ellipsis\");\n            /**\n             * triggered when ellisis is hidden\n             * @event\n             * @name hide_ellipsis.jstree\n             */\n            this.trigger('hide_ellipsis');\n        },\n        /**\n         * toggle the node ellipsis\n         * @name toggle_icons()\n         */\n        toggle_ellipsis : function () { if(this._data.core.themes.ellipsis) { this.hide_ellipsis(); } else { this.show_ellipsis(); } },\n        /**\n         * set the node icon for a node\n         * @name set_icon(obj, icon)\n         * @param {mixed} obj\n         * @param {String} icon the new icon - can be a path to an icon or a className, if using an image that is in the current directory use a `./` prefix, otherwise it will be detected as a class\n         */\n        set_icon : function (obj, icon) {\n            var t1, t2, dom, old;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.set_icon(obj[t1], icon);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            old = obj.icon;\n            obj.icon = icon === true || icon === null || icon === undefined || icon === '' ? true : icon;\n            dom = this.get_node(obj, true).children(\".jstree-anchor\").children(\".jstree-themeicon\");\n            if(icon === false) {\n                dom.removeClass('jstree-themeicon-custom ' + old).css(\"background\",\"\").removeAttr(\"rel\");\n                this.hide_icon(obj);\n            }\n            else if(icon === true || icon === null || icon === undefined || icon === '') {\n                dom.removeClass('jstree-themeicon-custom ' + old).css(\"background\",\"\").removeAttr(\"rel\");\n                if(old === false) { this.show_icon(obj); }\n            }\n            else if(icon.indexOf(\"/\") === -1 && icon.indexOf(\".\") === -1) {\n                dom.removeClass(old).css(\"background\",\"\");\n                dom.addClass(icon + ' jstree-themeicon-custom').attr(\"rel\",icon);\n                if(old === false) { this.show_icon(obj); }\n            }\n            else {\n                dom.removeClass(old).css(\"background\",\"\");\n                dom.addClass('jstree-themeicon-custom').css(\"background\", \"url('\" + icon + \"') center center no-repeat\").attr(\"rel\",icon);\n                if(old === false) { this.show_icon(obj); }\n            }\n            return true;\n        },\n        /**\n         * get the node icon for a node\n         * @name get_icon(obj)\n         * @param {mixed} obj\n         * @return {String}\n         */\n        get_icon : function (obj) {\n            obj = this.get_node(obj);\n            return (!obj || obj.id === $.jstree.root) ? false : obj.icon;\n        },\n        /**\n         * hide the icon on an individual node\n         * @name hide_icon(obj)\n         * @param {mixed} obj\n         */\n        hide_icon : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.hide_icon(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj === $.jstree.root) { return false; }\n            obj.icon = false;\n            this.get_node(obj, true).children(\".jstree-anchor\").children(\".jstree-themeicon\").addClass('jstree-themeicon-hidden');\n            return true;\n        },\n        /**\n         * show the icon on an individual node\n         * @name show_icon(obj)\n         * @param {mixed} obj\n         */\n        show_icon : function (obj) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.show_icon(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj === $.jstree.root) { return false; }\n            dom = this.get_node(obj, true);\n            obj.icon = dom.length ? dom.children(\".jstree-anchor\").children(\".jstree-themeicon\").attr('rel') : true;\n            if(!obj.icon) { obj.icon = true; }\n            dom.children(\".jstree-anchor\").children(\".jstree-themeicon\").removeClass('jstree-themeicon-hidden');\n            return true;\n        }\n    };\n\n    // helpers\n    $.vakata = {};\n    // collect attributes\n    $.vakata.attributes = function(node, with_values) {\n        node = $(node)[0];\n        var attr = with_values ? {} : [];\n        if(node && node.attributes) {\n            $.each(node.attributes, function (i, v) {\n                if($.inArray(v.name.toLowerCase(),['style','contenteditable','hasfocus','tabindex']) !== -1) { return; }\n                if(v.value !== null && $.vakata.trim(v.value) !== '') {\n                    if(with_values) { attr[v.name] = v.value; }\n                    else { attr.push(v.name); }\n                }\n            });\n        }\n        return attr;\n    };\n    $.vakata.array_unique = function(array) {\n        var a = [], i, j, l, o = {};\n        for(i = 0, l = array.length; i < l; i++) {\n            if(o[array[i]] === undefined) {\n                a.push(array[i]);\n                o[array[i]] = true;\n            }\n        }\n        return a;\n    };\n    // remove item from array\n    $.vakata.array_remove = function(array, from) {\n        array.splice(from, 1);\n        return array;\n        //var rest = array.slice((to || from) + 1 || array.length);\n        //array.length = from < 0 ? array.length + from : from;\n        //array.push.apply(array, rest);\n        //return array;\n    };\n    // remove item from array\n    $.vakata.array_remove_item = function(array, item) {\n        var tmp = $.inArray(item, array);\n        return tmp !== -1 ? $.vakata.array_remove(array, tmp) : array;\n    };\n    $.vakata.array_filter = function(c,a,b,d,e) {\n        if (c.filter) {\n            return c.filter(a, b);\n        }\n        d=[];\n        for (e in c) {\n            if (~~e+''===e+'' && e>=0 && a.call(b,c[e],+e,c)) {\n                d.push(c[e]);\n            }\n        }\n        return d;\n    };\n    $.vakata.trim = function (text) {\n        return String.prototype.trim ?\n            String.prototype.trim.call(text.toString()) :\n            text.toString().replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n    };\n    $.vakata.is_function = function(obj) {\n        return typeof obj === \"function\" && typeof obj.nodeType !== \"number\";\n    };\n    $.vakata.is_array = Array.isArray || function (obj) {\n        return Object.prototype.toString.call(obj) === \"[object Array]\";\n    };\n\n    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_objects/Function/bind#polyfill\n    if (!Function.prototype.bind) {\n        Function.prototype.bind = function () {\n            var thatFunc = this, thatArg = arguments[0];\n            var args = Array.prototype.slice.call(arguments, 1);\n            if (typeof thatFunc !== 'function') {\n                // closest thing possible to the ECMAScript 5\n                // internal IsCallable function\n                throw new TypeError('Function.prototype.bind - what is trying to be bound is not callable');\n            }\n            return function(){\n                var funcArgs = args.concat(Array.prototype.slice.call(arguments));\n                return thatFunc.apply(thatArg, funcArgs);\n            };\n        };\n    }\n\n\n    /**\n     * ### Changed plugin\n     *\n     * This plugin adds more information to the `changed.jstree` event. The new data is contained in the `changed` event data property, and contains a lists of `selected` and `deselected` nodes.\n     */\n\n    $.jstree.plugins.changed = function (options, parent) {\n        var last = [];\n        this.trigger = function (ev, data) {\n            var i, j;\n            if(!data) {\n                data = {};\n            }\n            if(ev.replace('.jstree','') === 'changed') {\n                data.changed = { selected : [], deselected : [] };\n                var tmp = {};\n                for(i = 0, j = last.length; i < j; i++) {\n                    tmp[last[i]] = 1;\n                }\n                for(i = 0, j = data.selected.length; i < j; i++) {\n                    if(!tmp[data.selected[i]]) {\n                        data.changed.selected.push(data.selected[i]);\n                    }\n                    else {\n                        tmp[data.selected[i]] = 2;\n                    }\n                }\n                for(i = 0, j = last.length; i < j; i++) {\n                    if(tmp[last[i]] === 1) {\n                        data.changed.deselected.push(last[i]);\n                    }\n                }\n                last = data.selected.slice();\n            }\n            /**\n             * triggered when selection changes (the \"changed\" plugin enhances the original event with more data)\n             * @event\n             * @name changed.jstree\n             * @param {Object} node\n             * @param {Object} action the action that caused the selection to change\n             * @param {Array} selected the current selection\n             * @param {Object} changed an object containing two properties `selected` and `deselected` - both arrays of node IDs, which were selected or deselected since the last changed event\n             * @param {Object} event the event (if any) that triggered this changed event\n             * @plugin changed\n             */\n            parent.trigger.call(this, ev, data);\n        };\n        this.refresh = function (skip_loading, forget_state) {\n            last = [];\n            return parent.refresh.apply(this, arguments);\n        };\n    };\n\n    /**\n     * ### Checkbox plugin\n     *\n     * This plugin renders checkbox icons in front of each node, making multiple selection much easier.\n     * It also supports tri-state behavior, meaning that if a node has a few of its children checked it will be rendered as undetermined, and state will be propagated up.\n     */\n\n    var _i = document.createElement('I');\n    _i.className = 'jstree-icon jstree-checkbox';\n    _i.setAttribute('role', 'presentation');\n    /**\n     * stores all defaults for the checkbox plugin\n     * @name $.jstree.defaults.checkbox\n     * @plugin checkbox\n     */\n    $.jstree.defaults.checkbox = {\n        /**\n         * a boolean indicating if checkboxes should be visible (can be changed at a later time using `show_checkboxes()` and `hide_checkboxes`). Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.visible\n         * @plugin checkbox\n         */\n        visible\t\t\t\t: true,\n        /**\n         * a boolean indicating if checkboxes should cascade down and have an undetermined state. Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.three_state\n         * @plugin checkbox\n         */\n        three_state\t\t\t: true,\n        /**\n         * a boolean indicating if clicking anywhere on the node should act as clicking on the checkbox. Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.whole_node\n         * @plugin checkbox\n         */\n        whole_node\t\t\t: true,\n        /**\n         * a boolean indicating if the selected style of a node should be kept, or removed. Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.keep_selected_style\n         * @plugin checkbox\n         */\n        keep_selected_style\t: true,\n        /**\n         * This setting controls how cascading and undetermined nodes are applied.\n         * If 'up' is in the string - cascading up is enabled, if 'down' is in the string - cascading down is enabled, if 'undetermined' is in the string - undetermined nodes will be used.\n         * If `three_state` is set to `true` this setting is automatically set to 'up+down+undetermined'. Defaults to ''.\n         * @name $.jstree.defaults.checkbox.cascade\n         * @plugin checkbox\n         */\n        cascade\t\t\t\t: '',\n        /**\n         * This setting controls if checkbox are bound to the general tree selection or to an internal array maintained by the checkbox plugin. Defaults to `true`, only set to `false` if you know exactly what you are doing.\n         * @name $.jstree.defaults.checkbox.tie_selection\n         * @plugin checkbox\n         */\n        tie_selection\t\t: true,\n\n        /**\n         * This setting controls if cascading down affects disabled checkboxes\n         * @name $.jstree.defaults.checkbox.cascade_to_disabled\n         * @plugin checkbox\n         */\n        cascade_to_disabled : true,\n\n        /**\n         * This setting controls if cascading down affects hidden checkboxes\n         * @name $.jstree.defaults.checkbox.cascade_to_hidden\n         * @plugin checkbox\n         */\n        cascade_to_hidden : true\n    };\n    $.jstree.plugins.checkbox = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n            this._data.checkbox.uto = false;\n            this._data.checkbox.selected = [];\n            if(this.settings.checkbox.three_state) {\n                this.settings.checkbox.cascade = 'up+down+undetermined';\n            }\n            this.element\n                .on(\"init.jstree\", function () {\n                    this._data.checkbox.visible = this.settings.checkbox.visible;\n                    if(!this.settings.checkbox.keep_selected_style) {\n                        this.element.addClass('jstree-checkbox-no-clicked');\n                    }\n                    if(this.settings.checkbox.tie_selection) {\n                        this.element.addClass('jstree-checkbox-selection');\n                    }\n                }.bind(this))\n                .on(\"loading.jstree\", function () {\n                    this[ this._data.checkbox.visible ? 'show_checkboxes' : 'hide_checkboxes' ]();\n                }.bind(this));\n            if(this.settings.checkbox.cascade.indexOf('undetermined') !== -1) {\n                this.element\n                    .on('changed.jstree uncheck_node.jstree check_node.jstree uncheck_all.jstree check_all.jstree move_node.jstree copy_node.jstree redraw.jstree open_node.jstree', function () {\n                        // only if undetermined is in setting\n                        if(this._data.checkbox.uto) { clearTimeout(this._data.checkbox.uto); }\n                        this._data.checkbox.uto = setTimeout(this._undetermined.bind(this), 50);\n                    }.bind(this));\n            }\n            if(!this.settings.checkbox.tie_selection) {\n                this.element\n                    .on('model.jstree', function (e, data) {\n                        var m = this._model.data,\n                            p = m[data.parent],\n                            dpc = data.nodes,\n                            i, j;\n                        for(i = 0, j = dpc.length; i < j; i++) {\n                            m[dpc[i]].state.checked = m[dpc[i]].state.checked || (m[dpc[i]].original && m[dpc[i]].original.state && m[dpc[i]].original.state.checked);\n                            if(m[dpc[i]].state.checked) {\n                                this._data.checkbox.selected.push(dpc[i]);\n                            }\n                        }\n                    }.bind(this));\n            }\n            if(this.settings.checkbox.cascade.indexOf('up') !== -1 || this.settings.checkbox.cascade.indexOf('down') !== -1) {\n                this.element\n                    .on('model.jstree', function (e, data) {\n                        var m = this._model.data,\n                            p = m[data.parent],\n                            dpc = data.nodes,\n                            chd = [],\n                            c, i, j, k, l, tmp, s = this.settings.checkbox.cascade, t = this.settings.checkbox.tie_selection;\n\n                        if(s.indexOf('down') !== -1) {\n                            // apply down\n                            if(p.state[ t ? 'selected' : 'checked' ]) {\n                                for(i = 0, j = dpc.length; i < j; i++) {\n                                    m[dpc[i]].state[ t ? 'selected' : 'checked' ] = true;\n                                }\n\n                                this._data[ t ? 'core' : 'checkbox' ].selected = this._data[ t ? 'core' : 'checkbox' ].selected.concat(dpc);\n                            }\n                            else {\n                                for(i = 0, j = dpc.length; i < j; i++) {\n                                    if(m[dpc[i]].state[ t ? 'selected' : 'checked' ]) {\n                                        for(k = 0, l = m[dpc[i]].children_d.length; k < l; k++) {\n                                            m[m[dpc[i]].children_d[k]].state[ t ? 'selected' : 'checked' ] = true;\n                                        }\n                                        this._data[ t ? 'core' : 'checkbox' ].selected = this._data[ t ? 'core' : 'checkbox' ].selected.concat(m[dpc[i]].children_d);\n                                    }\n                                }\n                            }\n                        }\n\n                        if(s.indexOf('up') !== -1) {\n                            // apply up\n                            for(i = 0, j = p.children_d.length; i < j; i++) {\n                                if(!m[p.children_d[i]].children.length) {\n                                    chd.push(m[p.children_d[i]].parent);\n                                }\n                            }\n                            chd = $.vakata.array_unique(chd);\n                            for(k = 0, l = chd.length; k < l; k++) {\n                                p = m[chd[k]];\n                                while(p && p.id !== $.jstree.root) {\n                                    c = 0;\n                                    for(i = 0, j = p.children.length; i < j; i++) {\n                                        c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                                    }\n                                    if(c === j) {\n                                        p.state[ t ? 'selected' : 'checked' ] = true;\n                                        this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                        tmp = this.get_node(p, true);\n                                        if(tmp && tmp.length) {\n                                            tmp.attr('aria-selected', true).children('.jstree-anchor').addClass( t ? 'jstree-clicked' : 'jstree-checked');\n                                        }\n                                    }\n                                    else {\n                                        break;\n                                    }\n                                    p = this.get_node(p.parent);\n                                }\n                            }\n                        }\n\n                        this._data[ t ? 'core' : 'checkbox' ].selected = $.vakata.array_unique(this._data[ t ? 'core' : 'checkbox' ].selected);\n                    }.bind(this))\n                    .on(this.settings.checkbox.tie_selection ? 'select_node.jstree' : 'check_node.jstree', function (e, data) {\n                        var self = this,\n                            obj = data.node,\n                            m = this._model.data,\n                            par = this.get_node(obj.parent),\n                            i, j, c, tmp, s = this.settings.checkbox.cascade, t = this.settings.checkbox.tie_selection,\n                            sel = {}, cur = this._data[ t ? 'core' : 'checkbox' ].selected;\n\n                        for (i = 0, j = cur.length; i < j; i++) {\n                            sel[cur[i]] = true;\n                        }\n\n                        // apply down\n                        if(s.indexOf('down') !== -1) {\n                            //this._data[ t ? 'core' : 'checkbox' ].selected = $.vakata.array_unique(this._data[ t ? 'core' : 'checkbox' ].selected.concat(obj.children_d));\n                            var selectedIds = this._cascade_new_checked_state(obj.id, true);\n                            var temp = obj.children_d.concat(obj.id);\n                            for (i = 0, j = temp.length; i < j; i++) {\n                                if (selectedIds.indexOf(temp[i]) > -1) {\n                                    sel[temp[i]] = true;\n                                }\n                                else {\n                                    delete sel[temp[i]];\n                                }\n                            }\n                        }\n\n                        // apply up\n                        if(s.indexOf('up') !== -1) {\n                            while(par && par.id !== $.jstree.root) {\n                                c = 0;\n                                for(i = 0, j = par.children.length; i < j; i++) {\n                                    c += m[par.children[i]].state[ t ? 'selected' : 'checked' ];\n                                }\n                                if(c === j) {\n                                    par.state[ t ? 'selected' : 'checked' ] = true;\n                                    sel[par.id] = true;\n                                    //this._data[ t ? 'core' : 'checkbox' ].selected.push(par.id);\n                                    tmp = this.get_node(par, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                                else {\n                                    break;\n                                }\n                                par = this.get_node(par.parent);\n                            }\n                        }\n\n                        cur = [];\n                        for (i in sel) {\n                            if (sel.hasOwnProperty(i)) {\n                                cur.push(i);\n                            }\n                        }\n                        this._data[ t ? 'core' : 'checkbox' ].selected = cur;\n                    }.bind(this))\n                    .on(this.settings.checkbox.tie_selection ? 'deselect_all.jstree' : 'uncheck_all.jstree', function (e, data) {\n                        var obj = this.get_node($.jstree.root),\n                            m = this._model.data,\n                            i, j, tmp;\n                        for(i = 0, j = obj.children_d.length; i < j; i++) {\n                            tmp = m[obj.children_d[i]];\n                            if(tmp && tmp.original && tmp.original.state && tmp.original.state.undetermined) {\n                                tmp.original.state.undetermined = false;\n                            }\n                        }\n                    }.bind(this))\n                    .on(this.settings.checkbox.tie_selection ? 'deselect_node.jstree' : 'uncheck_node.jstree', function (e, data) {\n                        var self = this,\n                            obj = data.node,\n                            dom = this.get_node(obj, true),\n                            i, j, tmp, s = this.settings.checkbox.cascade, t = this.settings.checkbox.tie_selection,\n                            cur = this._data[ t ? 'core' : 'checkbox' ].selected, sel = {},\n                            stillSelectedIds = [],\n                            allIds = obj.children_d.concat(obj.id);\n\n                        // apply down\n                        if(s.indexOf('down') !== -1) {\n                            var selectedIds = this._cascade_new_checked_state(obj.id, false);\n\n                            cur = $.vakata.array_filter(cur, function(id) {\n                                return allIds.indexOf(id) === -1 || selectedIds.indexOf(id) > -1;\n                            });\n                        }\n\n                        // only apply up if cascade up is enabled and if this node is not selected\n                        // (if all child nodes are disabled and cascade_to_disabled === false then this node will till be selected).\n                        if(s.indexOf('up') !== -1 && cur.indexOf(obj.id) === -1) {\n                            for(i = 0, j = obj.parents.length; i < j; i++) {\n                                tmp = this._model.data[obj.parents[i]];\n                                tmp.state[ t ? 'selected' : 'checked' ] = false;\n                                if(tmp && tmp.original && tmp.original.state && tmp.original.state.undetermined) {\n                                    tmp.original.state.undetermined = false;\n                                }\n                                tmp = this.get_node(obj.parents[i], true);\n                                if(tmp && tmp.length) {\n                                    tmp.attr('aria-selected', false).children('.jstree-anchor').removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                }\n                            }\n\n                            cur = $.vakata.array_filter(cur, function(id) {\n                                return obj.parents.indexOf(id) === -1;\n                            });\n                        }\n\n                        this._data[ t ? 'core' : 'checkbox' ].selected = cur;\n                    }.bind(this));\n            }\n            if(this.settings.checkbox.cascade.indexOf('up') !== -1) {\n                this.element\n                    .on('delete_node.jstree', function (e, data) {\n                        // apply up (whole handler)\n                        var p = this.get_node(data.parent),\n                            m = this._model.data,\n                            i, j, c, tmp, t = this.settings.checkbox.tie_selection;\n                        while(p && p.id !== $.jstree.root && !p.state[ t ? 'selected' : 'checked' ]) {\n                            c = 0;\n                            for(i = 0, j = p.children.length; i < j; i++) {\n                                c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                            }\n                            if(j > 0 && c === j) {\n                                p.state[ t ? 'selected' : 'checked' ] = true;\n                                this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                tmp = this.get_node(p, true);\n                                if(tmp && tmp.length) {\n                                    tmp.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                }\n                            }\n                            else {\n                                break;\n                            }\n                            p = this.get_node(p.parent);\n                        }\n                    }.bind(this))\n                    .on('move_node.jstree', function (e, data) {\n                        // apply up (whole handler)\n                        var is_multi = data.is_multi,\n                            old_par = data.old_parent,\n                            new_par = this.get_node(data.parent),\n                            m = this._model.data,\n                            p, c, i, j, tmp, t = this.settings.checkbox.tie_selection;\n                        if(!is_multi) {\n                            p = this.get_node(old_par);\n                            while(p && p.id !== $.jstree.root && !p.state[ t ? 'selected' : 'checked' ]) {\n                                c = 0;\n                                for(i = 0, j = p.children.length; i < j; i++) {\n                                    c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                                }\n                                if(j > 0 && c === j) {\n                                    p.state[ t ? 'selected' : 'checked' ] = true;\n                                    this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                    tmp = this.get_node(p, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                                else {\n                                    break;\n                                }\n                                p = this.get_node(p.parent);\n                            }\n                        }\n                        p = new_par;\n                        while(p && p.id !== $.jstree.root) {\n                            c = 0;\n                            for(i = 0, j = p.children.length; i < j; i++) {\n                                c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                            }\n                            if(c === j) {\n                                if(!p.state[ t ? 'selected' : 'checked' ]) {\n                                    p.state[ t ? 'selected' : 'checked' ] = true;\n                                    this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                    tmp = this.get_node(p, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                            }\n                            else {\n                                if(p.state[ t ? 'selected' : 'checked' ]) {\n                                    p.state[ t ? 'selected' : 'checked' ] = false;\n                                    this._data[ t ? 'core' : 'checkbox' ].selected = $.vakata.array_remove_item(this._data[ t ? 'core' : 'checkbox' ].selected, p.id);\n                                    tmp = this.get_node(p, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.attr('aria-selected', false).children('.jstree-anchor').removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                                else {\n                                    break;\n                                }\n                            }\n                            p = this.get_node(p.parent);\n                        }\n                    }.bind(this));\n            }\n        };\n        /**\n         * get an array of all nodes whose state is \"undetermined\"\n         * @name get_undetermined([full])\n         * @param  {boolean} full: if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_undetermined = function (full) {\n            if (this.settings.checkbox.cascade.indexOf('undetermined') === -1) {\n                return [];\n            }\n            var i, j, k, l, o = {}, m = this._model.data, t = this.settings.checkbox.tie_selection, s = this._data[ t ? 'core' : 'checkbox' ].selected, p = [], tt = this, r = [];\n            for(i = 0, j = s.length; i < j; i++) {\n                if(m[s[i]] && m[s[i]].parents) {\n                    for(k = 0, l = m[s[i]].parents.length; k < l; k++) {\n                        if(o[m[s[i]].parents[k]] !== undefined) {\n                            break;\n                        }\n                        if(m[s[i]].parents[k] !== $.jstree.root) {\n                            o[m[s[i]].parents[k]] = true;\n                            p.push(m[s[i]].parents[k]);\n                        }\n                    }\n                }\n            }\n            // attempt for server side undetermined state\n            this.element.find('.jstree-closed').not(':has(.jstree-children)')\n                .each(function () {\n                    var tmp = tt.get_node(this), tmp2;\n\n                    if(!tmp) { return; }\n\n                    if(!tmp.state.loaded) {\n                        if(tmp.original && tmp.original.state && tmp.original.state.undetermined && tmp.original.state.undetermined === true) {\n                            if(o[tmp.id] === undefined && tmp.id !== $.jstree.root) {\n                                o[tmp.id] = true;\n                                p.push(tmp.id);\n                            }\n                            for(k = 0, l = tmp.parents.length; k < l; k++) {\n                                if(o[tmp.parents[k]] === undefined && tmp.parents[k] !== $.jstree.root) {\n                                    o[tmp.parents[k]] = true;\n                                    p.push(tmp.parents[k]);\n                                }\n                            }\n                        }\n                    }\n                    else {\n                        for(i = 0, j = tmp.children_d.length; i < j; i++) {\n                            tmp2 = m[tmp.children_d[i]];\n                            if(!tmp2.state.loaded && tmp2.original && tmp2.original.state && tmp2.original.state.undetermined && tmp2.original.state.undetermined === true) {\n                                if(o[tmp2.id] === undefined && tmp2.id !== $.jstree.root) {\n                                    o[tmp2.id] = true;\n                                    p.push(tmp2.id);\n                                }\n                                for(k = 0, l = tmp2.parents.length; k < l; k++) {\n                                    if(o[tmp2.parents[k]] === undefined && tmp2.parents[k] !== $.jstree.root) {\n                                        o[tmp2.parents[k]] = true;\n                                        p.push(tmp2.parents[k]);\n                                    }\n                                }\n                            }\n                        }\n                    }\n                });\n            for (i = 0, j = p.length; i < j; i++) {\n                if(!m[p[i]].state[ t ? 'selected' : 'checked' ]) {\n                    r.push(full ? m[p[i]] : p[i]);\n                }\n            }\n            return r;\n        };\n        /**\n         * set the undetermined state where and if necessary. Used internally.\n         * @private\n         * @name _undetermined()\n         * @plugin checkbox\n         */\n        this._undetermined = function () {\n            if(this.element === null) { return; }\n            var p = this.get_undetermined(false), i, j, s;\n\n            this.element.find('.jstree-undetermined').removeClass('jstree-undetermined');\n            for (i = 0, j = p.length; i < j; i++) {\n                s = this.get_node(p[i], true);\n                if(s && s.length) {\n                    s.children('.jstree-anchor').children('.jstree-checkbox').addClass('jstree-undetermined');\n                }\n            }\n        };\n        this.redraw_node = function(obj, deep, is_callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if(obj) {\n                var i, j, tmp = null, icon = null;\n                for(i = 0, j = obj.childNodes.length; i < j; i++) {\n                    if(obj.childNodes[i] && obj.childNodes[i].className && obj.childNodes[i].className.indexOf(\"jstree-anchor\") !== -1) {\n                        tmp = obj.childNodes[i];\n                        break;\n                    }\n                }\n                if(tmp) {\n                    if(!this.settings.checkbox.tie_selection && this._model.data[obj.id].state.checked) { tmp.className += ' jstree-checked'; }\n                    icon = _i.cloneNode(false);\n                    if(this._model.data[obj.id].state.checkbox_disabled) { icon.className += ' jstree-checkbox-disabled'; }\n                    tmp.insertBefore(icon, tmp.childNodes[0]);\n                }\n            }\n            if(!is_callback && this.settings.checkbox.cascade.indexOf('undetermined') !== -1) {\n                if(this._data.checkbox.uto) { clearTimeout(this._data.checkbox.uto); }\n                this._data.checkbox.uto = setTimeout(this._undetermined.bind(this), 50);\n            }\n            return obj;\n        };\n        /**\n         * show the node checkbox icons\n         * @name show_checkboxes()\n         * @plugin checkbox\n         */\n        this.show_checkboxes = function () { this._data.core.themes.checkboxes = true; this.get_container_ul().removeClass(\"jstree-no-checkboxes\"); };\n        /**\n         * hide the node checkbox icons\n         * @name hide_checkboxes()\n         * @plugin checkbox\n         */\n        this.hide_checkboxes = function () { this._data.core.themes.checkboxes = false; this.get_container_ul().addClass(\"jstree-no-checkboxes\"); };\n        /**\n         * toggle the node icons\n         * @name toggle_checkboxes()\n         * @plugin checkbox\n         */\n        this.toggle_checkboxes = function () { if(this._data.core.themes.checkboxes) { this.hide_checkboxes(); } else { this.show_checkboxes(); } };\n        /**\n         * checks if a node is in an undetermined state\n         * @name is_undetermined(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        this.is_undetermined = function (obj) {\n            obj = this.get_node(obj);\n            var s = this.settings.checkbox.cascade, i, j, t = this.settings.checkbox.tie_selection, d = this._data[ t ? 'core' : 'checkbox' ].selected, m = this._model.data;\n            if(!obj || obj.state[ t ? 'selected' : 'checked' ] === true || s.indexOf('undetermined') === -1 || (s.indexOf('down') === -1 && s.indexOf('up') === -1)) {\n                return false;\n            }\n            if(!obj.state.loaded && obj.original.state.undetermined === true) {\n                return true;\n            }\n            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                if($.inArray(obj.children_d[i], d) !== -1 || (!m[obj.children_d[i]].state.loaded && m[obj.children_d[i]].original.state.undetermined)) {\n                    return true;\n                }\n            }\n            return false;\n        };\n        /**\n         * disable a node's checkbox\n         * @name disable_checkbox(obj)\n         * @param {mixed} obj an array can be used too\n         * @trigger disable_checkbox.jstree\n         * @plugin checkbox\n         */\n        this.disable_checkbox = function (obj) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.disable_checkbox(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(!obj.state.checkbox_disabled) {\n                obj.state.checkbox_disabled = true;\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').children('.jstree-checkbox').addClass('jstree-checkbox-disabled');\n                }\n                /**\n                 * triggered when an node's checkbox is disabled\n                 * @event\n                 * @name disable_checkbox.jstree\n                 * @param {Object} node\n                 * @plugin checkbox\n                 */\n                this.trigger('disable_checkbox', { 'node' : obj });\n            }\n        };\n        /**\n         * enable a node's checkbox\n         * @name enable_checkbox(obj)\n         * @param {mixed} obj an array can be used too\n         * @trigger enable_checkbox.jstree\n         * @plugin checkbox\n         */\n        this.enable_checkbox = function (obj) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.enable_checkbox(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(obj.state.checkbox_disabled) {\n                obj.state.checkbox_disabled = false;\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').children('.jstree-checkbox').removeClass('jstree-checkbox-disabled');\n                }\n                /**\n                 * triggered when an node's checkbox is enabled\n                 * @event\n                 * @name enable_checkbox.jstree\n                 * @param {Object} node\n                 * @plugin checkbox\n                 */\n                this.trigger('enable_checkbox', { 'node' : obj });\n            }\n        };\n\n        this.activate_node = function (obj, e) {\n            if($(e.target).hasClass('jstree-checkbox-disabled')) {\n                return false;\n            }\n            if(this.settings.checkbox.tie_selection && (this.settings.checkbox.whole_node || $(e.target).hasClass('jstree-checkbox'))) {\n                e.ctrlKey = true;\n            }\n            if(this.settings.checkbox.tie_selection || (!this.settings.checkbox.whole_node && !$(e.target).hasClass('jstree-checkbox'))) {\n                return parent.activate_node.call(this, obj, e);\n            }\n            if(this.is_disabled(obj)) {\n                return false;\n            }\n            if(this.is_checked(obj)) {\n                this.uncheck_node(obj, e);\n            }\n            else {\n                this.check_node(obj, e);\n            }\n            this.trigger('activate_node', { 'node' : this.get_node(obj) });\n        };\n\n        /**\n         * Cascades checked state to a node and all its descendants. This function does NOT affect hidden and disabled nodes (or their descendants).\n         * However if these unaffected nodes are already selected their ids will be included in the returned array.\n         * @private\n         * @name _cascade_new_checked_state(id, checkedState)\n         * @param {string} id the node ID\n         * @param {bool} checkedState should the nodes be checked or not\n         * @returns {Array} Array of all node id's (in this tree branch) that are checked.\n         */\n        this._cascade_new_checked_state = function (id, checkedState) {\n            var self = this;\n            var t = this.settings.checkbox.tie_selection;\n            var node = this._model.data[id];\n            var selectedNodeIds = [];\n            var selectedChildrenIds = [], i, j, selectedChildIds;\n\n            if (\n                (this.settings.checkbox.cascade_to_disabled || !node.state.disabled) &&\n                (this.settings.checkbox.cascade_to_hidden || !node.state.hidden)\n            ) {\n                //First try and check/uncheck the children\n                if (node.children) {\n                    for (i = 0, j = node.children.length; i < j; i++) {\n                        var childId = node.children[i];\n                        selectedChildIds = self._cascade_new_checked_state(childId, checkedState);\n                        selectedNodeIds = selectedNodeIds.concat(selectedChildIds);\n                        if (selectedChildIds.indexOf(childId) > -1) {\n                            selectedChildrenIds.push(childId);\n                        }\n                    }\n                }\n\n                var dom = self.get_node(node, true);\n\n                //A node's state is undetermined if some but not all of it's children are checked/selected .\n                var undetermined = selectedChildrenIds.length > 0 && selectedChildrenIds.length < node.children.length;\n\n                if(node.original && node.original.state && node.original.state.undetermined) {\n                    node.original.state.undetermined = undetermined;\n                }\n\n                //If a node is undetermined then remove selected class\n                if (undetermined) {\n                    node.state[ t ? 'selected' : 'checked' ] = false;\n                    dom.attr('aria-selected', false).children('.jstree-anchor').removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                }\n                    //Otherwise, if the checkedState === true (i.e. the node is being checked now) and all of the node's children are checked (if it has any children),\n                //check the node and style it correctly.\n                else if (checkedState && selectedChildrenIds.length === node.children.length) {\n                    node.state[ t ? 'selected' : 'checked' ] = checkedState;\n                    selectedNodeIds.push(node.id);\n\n                    dom.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                }\n                else {\n                    node.state[ t ? 'selected' : 'checked' ] = false;\n                    dom.attr('aria-selected', false).children('.jstree-anchor').removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                }\n            }\n            else {\n                selectedChildIds = this.get_checked_descendants(id);\n\n                if (node.state[ t ? 'selected' : 'checked' ]) {\n                    selectedChildIds.push(node.id);\n                }\n\n                selectedNodeIds = selectedNodeIds.concat(selectedChildIds);\n            }\n\n            return selectedNodeIds;\n        };\n\n        /**\n         * Gets ids of nodes selected in branch (of tree) specified by id (does not include the node specified by id)\n         * @name get_checked_descendants(obj)\n         * @param {string} id the node ID\n         * @return {Array} array of IDs\n         * @plugin checkbox\n         */\n        this.get_checked_descendants = function (id) {\n            var self = this;\n            var t = self.settings.checkbox.tie_selection;\n            var node = self._model.data[id];\n\n            return $.vakata.array_filter(node.children_d, function(_id) {\n                return self._model.data[_id].state[ t ? 'selected' : 'checked' ];\n            });\n        };\n\n        /**\n         * check a node (only if tie_selection in checkbox settings is false, otherwise select_node will be called internally)\n         * @name check_node(obj)\n         * @param {mixed} obj an array can be used to check multiple nodes\n         * @trigger check_node.jstree\n         * @plugin checkbox\n         */\n        this.check_node = function (obj, e) {\n            if(this.settings.checkbox.tie_selection) { return this.select_node(obj, false, true, e); }\n            var dom, t1, t2, th;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.check_node(obj[t1], e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(!obj.state.checked) {\n                obj.state.checked = true;\n                this._data.checkbox.selected.push(obj.id);\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').addClass('jstree-checked');\n                }\n                /**\n                 * triggered when an node is checked (only if tie_selection in checkbox settings is false)\n                 * @event\n                 * @name check_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this check_node\n                 * @plugin checkbox\n                 */\n                this.trigger('check_node', { 'node' : obj, 'selected' : this._data.checkbox.selected, 'event' : e });\n            }\n        };\n        /**\n         * uncheck a node (only if tie_selection in checkbox settings is false, otherwise deselect_node will be called internally)\n         * @name uncheck_node(obj)\n         * @param {mixed} obj an array can be used to uncheck multiple nodes\n         * @trigger uncheck_node.jstree\n         * @plugin checkbox\n         */\n        this.uncheck_node = function (obj, e) {\n            if(this.settings.checkbox.tie_selection) { return this.deselect_node(obj, false, e); }\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.uncheck_node(obj[t1], e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(obj.state.checked) {\n                obj.state.checked = false;\n                this._data.checkbox.selected = $.vakata.array_remove_item(this._data.checkbox.selected, obj.id);\n                if(dom.length) {\n                    dom.children('.jstree-anchor').removeClass('jstree-checked');\n                }\n                /**\n                 * triggered when an node is unchecked (only if tie_selection in checkbox settings is false)\n                 * @event\n                 * @name uncheck_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this uncheck_node\n                 * @plugin checkbox\n                 */\n                this.trigger('uncheck_node', { 'node' : obj, 'selected' : this._data.checkbox.selected, 'event' : e });\n            }\n        };\n\n        /**\n         * checks all nodes in the tree (only if tie_selection in checkbox settings is false, otherwise select_all will be called internally)\n         * @name check_all()\n         * @trigger check_all.jstree, changed.jstree\n         * @plugin checkbox\n         */\n        this.check_all = function () {\n            if(this.settings.checkbox.tie_selection) { return this.select_all(); }\n            var tmp = this._data.checkbox.selected.concat([]), i, j;\n            this._data.checkbox.selected = this._model.data[$.jstree.root].children_d.concat();\n            for(i = 0, j = this._data.checkbox.selected.length; i < j; i++) {\n                if(this._model.data[this._data.checkbox.selected[i]]) {\n                    this._model.data[this._data.checkbox.selected[i]].state.checked = true;\n                }\n            }\n            this.redraw(true);\n            /**\n             * triggered when all nodes are checked (only if tie_selection in checkbox settings is false)\n             * @event\n             * @name check_all.jstree\n             * @param {Array} selected the current selection\n             * @plugin checkbox\n             */\n            this.trigger('check_all', { 'selected' : this._data.checkbox.selected });\n        };\n        /**\n         * uncheck all checked nodes (only if tie_selection in checkbox settings is false, otherwise deselect_all will be called internally)\n         * @name uncheck_all()\n         * @trigger uncheck_all.jstree\n         * @plugin checkbox\n         */\n        this.uncheck_all = function () {\n            if(this.settings.checkbox.tie_selection) { return this.deselect_all(); }\n            var tmp = this._data.checkbox.selected.concat([]), i, j;\n            for(i = 0, j = this._data.checkbox.selected.length; i < j; i++) {\n                if(this._model.data[this._data.checkbox.selected[i]]) {\n                    this._model.data[this._data.checkbox.selected[i]].state.checked = false;\n                }\n            }\n            this._data.checkbox.selected = [];\n            this.element.find('.jstree-checked').removeClass('jstree-checked');\n            /**\n             * triggered when all nodes are unchecked (only if tie_selection in checkbox settings is false)\n             * @event\n             * @name uncheck_all.jstree\n             * @param {Object} node the previous selection\n             * @param {Array} selected the current selection\n             * @plugin checkbox\n             */\n            this.trigger('uncheck_all', { 'selected' : this._data.checkbox.selected, 'node' : tmp });\n        };\n        /**\n         * checks if a node is checked (if tie_selection is on in the settings this function will return the same as is_selected)\n         * @name is_checked(obj)\n         * @param  {mixed}  obj\n         * @return {Boolean}\n         * @plugin checkbox\n         */\n        this.is_checked = function (obj) {\n            if(this.settings.checkbox.tie_selection) { return this.is_selected(obj); }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            return obj.state.checked;\n        };\n        /**\n         * get an array of all checked nodes (if tie_selection is on in the settings this function will return the same as get_selected)\n         * @name get_checked([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_checked = function (full) {\n            if(this.settings.checkbox.tie_selection) { return this.get_selected(full); }\n            return full ? $.map(this._data.checkbox.selected, function (i) { return this.get_node(i); }.bind(this)) : this._data.checkbox.selected.slice();\n        };\n        /**\n         * get an array of all top level checked nodes (ignoring children of checked nodes) (if tie_selection is on in the settings this function will return the same as get_top_selected)\n         * @name get_top_checked([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_top_checked = function (full) {\n            if(this.settings.checkbox.tie_selection) { return this.get_top_selected(full); }\n            var tmp = this.get_checked(true),\n                obj = {}, i, j, k, l;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                obj[tmp[i].id] = tmp[i];\n            }\n            for(i = 0, j = tmp.length; i < j; i++) {\n                for(k = 0, l = tmp[i].children_d.length; k < l; k++) {\n                    if(obj[tmp[i].children_d[k]]) {\n                        delete obj[tmp[i].children_d[k]];\n                    }\n                }\n            }\n            tmp = [];\n            for(i in obj) {\n                if(obj.hasOwnProperty(i)) {\n                    tmp.push(i);\n                }\n            }\n            return full ? $.map(tmp, function (i) { return this.get_node(i); }.bind(this)) : tmp;\n        };\n        /**\n         * get an array of all bottom level checked nodes (ignoring selected parents) (if tie_selection is on in the settings this function will return the same as get_bottom_selected)\n         * @name get_bottom_checked([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_bottom_checked = function (full) {\n            if(this.settings.checkbox.tie_selection) { return this.get_bottom_selected(full); }\n            var tmp = this.get_checked(true),\n                obj = [], i, j;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                if(!tmp[i].children.length) {\n                    obj.push(tmp[i].id);\n                }\n            }\n            return full ? $.map(obj, function (i) { return this.get_node(i); }.bind(this)) : obj;\n        };\n        this.load_node = function (obj, callback) {\n            var k, l, i, j, c, tmp;\n            if(!$.vakata.is_array(obj) && !this.settings.checkbox.tie_selection) {\n                tmp = this.get_node(obj);\n                if(tmp && tmp.state.loaded) {\n                    for(k = 0, l = tmp.children_d.length; k < l; k++) {\n                        if(this._model.data[tmp.children_d[k]].state.checked) {\n                            c = true;\n                            this._data.checkbox.selected = $.vakata.array_remove_item(this._data.checkbox.selected, tmp.children_d[k]);\n                        }\n                    }\n                }\n            }\n            return parent.load_node.apply(this, arguments);\n        };\n        this.get_state = function () {\n            var state = parent.get_state.apply(this, arguments);\n            if(this.settings.checkbox.tie_selection) { return state; }\n            state.checkbox = this._data.checkbox.selected.slice();\n            return state;\n        };\n        this.set_state = function (state, callback) {\n            var res = parent.set_state.apply(this, arguments);\n            if(res && state.checkbox) {\n                if(!this.settings.checkbox.tie_selection) {\n                    this.uncheck_all();\n                    var _this = this;\n                    $.each(state.checkbox, function (i, v) {\n                        _this.check_node(v);\n                    });\n                }\n                delete state.checkbox;\n                this.set_state(state, callback);\n                return false;\n            }\n            return res;\n        };\n        this.refresh = function (skip_loading, forget_state) {\n            if(this.settings.checkbox.tie_selection) {\n                this._data.checkbox.selected = [];\n            }\n            return parent.refresh.apply(this, arguments);\n        };\n    };\n\n    // include the checkbox plugin by default\n    // $.jstree.defaults.plugins.push(\"checkbox\");\n\n\n    /**\n     * ### Conditionalselect plugin\n     *\n     * This plugin allows defining a callback to allow or deny node selection by user input (activate node method).\n     */\n\n    /**\n     * a callback (function) which is invoked in the instance's scope and receives two arguments - the node and the event that triggered the `activate_node` call. Returning false prevents working with the node, returning true allows invoking activate_node. Defaults to returning `true`.\n     * @name $.jstree.defaults.checkbox.visible\n     * @plugin checkbox\n     */\n    $.jstree.defaults.conditionalselect = function () { return true; };\n    $.jstree.plugins.conditionalselect = function (options, parent) {\n        // own function\n        this.activate_node = function (obj, e) {\n            if(this.settings.conditionalselect.call(this, this.get_node(obj), e)) {\n                return parent.activate_node.call(this, obj, e);\n            }\n        };\n    };\n\n\n    /**\n     * ### Contextmenu plugin\n     *\n     * Shows a context menu when a node is right-clicked.\n     */\n\n    /**\n     * stores all defaults for the contextmenu plugin\n     * @name $.jstree.defaults.contextmenu\n     * @plugin contextmenu\n     */\n    $.jstree.defaults.contextmenu = {\n        /**\n         * a boolean indicating if the node should be selected when the context menu is invoked on it. Defaults to `true`.\n         * @name $.jstree.defaults.contextmenu.select_node\n         * @plugin contextmenu\n         */\n        select_node : true,\n        /**\n         * a boolean indicating if the menu should be shown aligned with the node. Defaults to `true`, otherwise the mouse coordinates are used.\n         * @name $.jstree.defaults.contextmenu.show_at_node\n         * @plugin contextmenu\n         */\n        show_at_node : true,\n        /**\n         * an object of actions, or a function that accepts a node and a callback function and calls the callback function with an object of actions available for that node (you can also return the items too).\n         *\n         * Each action consists of a key (a unique name) and a value which is an object with the following properties (only label and action are required). Once a menu item is activated the `action` function will be invoked with an object containing the following keys: item - the contextmenu item definition as seen below, reference - the DOM node that was used (the tree node), element - the contextmenu DOM element, position - an object with x/y properties indicating the position of the menu.\n         *\n         * * `separator_before` - a boolean indicating if there should be a separator before this item\n         * * `separator_after` - a boolean indicating if there should be a separator after this item\n         * * `_disabled` - a boolean indicating if this action should be disabled\n         * * `label` - a string - the name of the action (could be a function returning a string)\n         * * `title` - a string - an optional tooltip for the item\n         * * `action` - a function to be executed if this item is chosen, the function will receive\n         * * `icon` - a string, can be a path to an icon or a className, if using an image that is in the current directory use a `./` prefix, otherwise it will be detected as a class\n         * * `shortcut` - keyCode which will trigger the action if the menu is open (for example `113` for rename, which equals F2)\n         * * `shortcut_label` - shortcut label (like for example `F2` for rename)\n         * * `submenu` - an object with the same structure as $.jstree.defaults.contextmenu.items which can be used to create a submenu - each key will be rendered as a separate option in a submenu that will appear once the current item is hovered\n         *\n         * @name $.jstree.defaults.contextmenu.items\n         * @plugin contextmenu\n         */\n        items : function (o, cb) { // Could be an object directly\n            return {\n                \"create\" : {\n                    \"separator_before\"\t: false,\n                    \"separator_after\"\t: true,\n                    \"_disabled\"\t\t\t: false, //(this.check(\"create_node\", data.reference, {}, \"last\")),\n                    \"label\"\t\t\t\t: \"Create\",\n                    \"action\"\t\t\t: function (data) {\n                        var inst = $.jstree.reference(data.reference),\n                            obj = inst.get_node(data.reference);\n                        inst.create_node(obj, {}, \"last\", function (new_node) {\n                            try {\n                                inst.edit(new_node);\n                            } catch (ex) {\n                                setTimeout(function () { inst.edit(new_node); },0);\n                            }\n                        });\n                    }\n                },\n                \"rename\" : {\n                    \"separator_before\"\t: false,\n                    \"separator_after\"\t: false,\n                    \"_disabled\"\t\t\t: false, //(this.check(\"rename_node\", data.reference, this.get_parent(data.reference), \"\")),\n                    \"label\"\t\t\t\t: \"Rename\",\n                    /*!\n\t\t\t\t\t\"shortcut\"\t\t\t: 113,\n\t\t\t\t\t\"shortcut_label\"\t: 'F2',\n\t\t\t\t\t\"icon\"\t\t\t\t: \"glyphicon glyphicon-leaf\",\n\t\t\t\t\t*/\n                    \"action\"\t\t\t: function (data) {\n                        var inst = $.jstree.reference(data.reference),\n                            obj = inst.get_node(data.reference);\n                        inst.edit(obj);\n                    }\n                },\n                \"remove\" : {\n                    \"separator_before\"\t: false,\n                    \"icon\"\t\t\t\t: false,\n                    \"separator_after\"\t: false,\n                    \"_disabled\"\t\t\t: false, //(this.check(\"delete_node\", data.reference, this.get_parent(data.reference), \"\")),\n                    \"label\"\t\t\t\t: \"Delete\",\n                    \"action\"\t\t\t: function (data) {\n                        var inst = $.jstree.reference(data.reference),\n                            obj = inst.get_node(data.reference);\n                        if(inst.is_selected(obj)) {\n                            inst.delete_node(inst.get_selected());\n                        }\n                        else {\n                            inst.delete_node(obj);\n                        }\n                    }\n                },\n                \"ccp\" : {\n                    \"separator_before\"\t: true,\n                    \"icon\"\t\t\t\t: false,\n                    \"separator_after\"\t: false,\n                    \"label\"\t\t\t\t: \"Edit\",\n                    \"action\"\t\t\t: false,\n                    \"submenu\" : {\n                        \"cut\" : {\n                            \"separator_before\"\t: false,\n                            \"separator_after\"\t: false,\n                            \"label\"\t\t\t\t: \"Cut\",\n                            \"action\"\t\t\t: function (data) {\n                                var inst = $.jstree.reference(data.reference),\n                                    obj = inst.get_node(data.reference);\n                                if(inst.is_selected(obj)) {\n                                    inst.cut(inst.get_top_selected());\n                                }\n                                else {\n                                    inst.cut(obj);\n                                }\n                            }\n                        },\n                        \"copy\" : {\n                            \"separator_before\"\t: false,\n                            \"icon\"\t\t\t\t: false,\n                            \"separator_after\"\t: false,\n                            \"label\"\t\t\t\t: \"Copy\",\n                            \"action\"\t\t\t: function (data) {\n                                var inst = $.jstree.reference(data.reference),\n                                    obj = inst.get_node(data.reference);\n                                if(inst.is_selected(obj)) {\n                                    inst.copy(inst.get_top_selected());\n                                }\n                                else {\n                                    inst.copy(obj);\n                                }\n                            }\n                        },\n                        \"paste\" : {\n                            \"separator_before\"\t: false,\n                            \"icon\"\t\t\t\t: false,\n                            \"_disabled\"\t\t\t: function (data) {\n                                return !$.jstree.reference(data.reference).can_paste();\n                            },\n                            \"separator_after\"\t: false,\n                            \"label\"\t\t\t\t: \"Paste\",\n                            \"action\"\t\t\t: function (data) {\n                                var inst = $.jstree.reference(data.reference),\n                                    obj = inst.get_node(data.reference);\n                                inst.paste(obj);\n                            }\n                        }\n                    }\n                }\n            };\n        }\n    };\n\n    $.jstree.plugins.contextmenu = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n\n            var last_ts = 0, cto = null, ex, ey;\n            this.element\n                .on(\"init.jstree loading.jstree ready.jstree\", function () {\n                    this.get_container_ul().addClass('jstree-contextmenu');\n                }.bind(this))\n                .on(\"contextmenu.jstree\", \".jstree-anchor\", function (e, data) {\n                    if (e.target.tagName.toLowerCase() === 'input') {\n                        return;\n                    }\n                    e.preventDefault();\n                    last_ts = e.ctrlKey ? +new Date() : 0;\n                    if(data || cto) {\n                        last_ts = (+new Date()) + 10000;\n                    }\n                    if(cto) {\n                        clearTimeout(cto);\n                    }\n                    if(!this.is_loading(e.currentTarget)) {\n                        this.show_contextmenu(e.currentTarget, e.pageX, e.pageY, e);\n                    }\n                }.bind(this))\n                .on(\"click.jstree\", \".jstree-anchor\", function (e) {\n                    if(this._data.contextmenu.visible && (!last_ts || (+new Date()) - last_ts > 250)) { // work around safari & macOS ctrl+click\n                        $.vakata.context.hide();\n                    }\n                    last_ts = 0;\n                }.bind(this))\n                .on(\"touchstart.jstree\", \".jstree-anchor\", function (e) {\n                    if(!e.originalEvent || !e.originalEvent.changedTouches || !e.originalEvent.changedTouches[0]) {\n                        return;\n                    }\n                    ex = e.originalEvent.changedTouches[0].clientX;\n                    ey = e.originalEvent.changedTouches[0].clientY;\n                    cto = setTimeout(function () {\n                        $(e.currentTarget).trigger('contextmenu', true);\n                    }, 750);\n                })\n                .on('touchmove.vakata.jstree', function (e) {\n                    if(cto && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0] && (Math.abs(ex - e.originalEvent.changedTouches[0].clientX) > 10 || Math.abs(ey - e.originalEvent.changedTouches[0].clientY) > 10)) {\n                        clearTimeout(cto);\n                        $.vakata.context.hide();\n                    }\n                })\n                .on('touchend.vakata.jstree', function (e) {\n                    if(cto) {\n                        clearTimeout(cto);\n                    }\n                });\n\n            /*!\n\t\t\tif(!('oncontextmenu' in document.body) && ('ontouchstart' in document.body)) {\n\t\t\t\tvar el = null, tm = null;\n\t\t\t\tthis.element\n\t\t\t\t\t.on(\"touchstart\", \".jstree-anchor\", function (e) {\n\t\t\t\t\t\tel = e.currentTarget;\n\t\t\t\t\t\ttm = +new Date();\n\t\t\t\t\t\t$(document).one(\"touchend\", function (e) {\n\t\t\t\t\t\t\te.target = document.elementFromPoint(e.originalEvent.targetTouches[0].pageX - window.pageXOffset, e.originalEvent.targetTouches[0].pageY - window.pageYOffset);\n\t\t\t\t\t\t\te.currentTarget = e.target;\n\t\t\t\t\t\t\ttm = ((+(new Date())) - tm);\n\t\t\t\t\t\t\tif(e.target === el && tm > 600 && tm < 1000) {\n\t\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t\t\t$(el).trigger('contextmenu', e);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tel = null;\n\t\t\t\t\t\t\ttm = null;\n\t\t\t\t\t\t});\n\t\t\t\t\t});\n\t\t\t}\n\t\t\t*/\n            $(document).on(\"context_hide.vakata.jstree\", function (e, data) {\n                this._data.contextmenu.visible = false;\n                $(data.reference).removeClass('jstree-context');\n            }.bind(this));\n        };\n        this.teardown = function () {\n            if(this._data.contextmenu.visible) {\n                $.vakata.context.hide();\n            }\n            $(document).off(\"context_hide.vakata.jstree\");\n            parent.teardown.call(this);\n        };\n\n        /**\n         * prepare and show the context menu for a node\n         * @name show_contextmenu(obj [, x, y])\n         * @param {mixed} obj the node\n         * @param {Number} x the x-coordinate relative to the document to show the menu at\n         * @param {Number} y the y-coordinate relative to the document to show the menu at\n         * @param {Object} e the event if available that triggered the contextmenu\n         * @plugin contextmenu\n         * @trigger show_contextmenu.jstree\n         */\n        this.show_contextmenu = function (obj, x, y, e) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            var s = this.settings.contextmenu,\n                d = this.get_node(obj, true),\n                a = d.children(\".jstree-anchor\"),\n                o = false,\n                i = false;\n            if(s.show_at_node || x === undefined || y === undefined) {\n                o = a.offset();\n                x = o.left;\n                y = o.top + this._data.core.li_height;\n            }\n            if(this.settings.contextmenu.select_node && !this.is_selected(obj)) {\n                this.activate_node(obj, e);\n            }\n\n            i = s.items;\n            if($.vakata.is_function(i)) {\n                i = i.call(this, obj, function (i) {\n                    this._show_contextmenu(obj, x, y, i);\n                }.bind(this));\n            }\n            if($.isPlainObject(i)) {\n                this._show_contextmenu(obj, x, y, i);\n            }\n        };\n        /**\n         * show the prepared context menu for a node\n         * @name _show_contextmenu(obj, x, y, i)\n         * @param {mixed} obj the node\n         * @param {Number} x the x-coordinate relative to the document to show the menu at\n         * @param {Number} y the y-coordinate relative to the document to show the menu at\n         * @param {Number} i the object of items to show\n         * @plugin contextmenu\n         * @trigger show_contextmenu.jstree\n         * @private\n         */\n        this._show_contextmenu = function (obj, x, y, i) {\n            var d = this.get_node(obj, true),\n                a = d.children(\".jstree-anchor\");\n            $(document).one(\"context_show.vakata.jstree\", function (e, data) {\n                var cls = 'jstree-contextmenu jstree-' + this.get_theme() + '-contextmenu';\n                $(data.element).addClass(cls);\n                a.addClass('jstree-context');\n            }.bind(this));\n            this._data.contextmenu.visible = true;\n            $.vakata.context.show(a, { 'x' : x, 'y' : y }, i);\n            /**\n             * triggered when the contextmenu is shown for a node\n             * @event\n             * @name show_contextmenu.jstree\n             * @param {Object} node the node\n             * @param {Number} x the x-coordinate of the menu relative to the document\n             * @param {Number} y the y-coordinate of the menu relative to the document\n             * @plugin contextmenu\n             */\n            this.trigger('show_contextmenu', { \"node\" : obj, \"x\" : x, \"y\" : y });\n        };\n    };\n\n    // contextmenu helper\n    (function ($) {\n        var right_to_left = false,\n            vakata_context = {\n                element\t\t: false,\n                reference\t: false,\n                position_x\t: 0,\n                position_y\t: 0,\n                items\t\t: [],\n                html\t\t: \"\",\n                is_visible\t: false\n            };\n\n        $.vakata.context = {\n            settings : {\n                hide_onmouseleave\t: 0,\n                icons\t\t\t\t: true\n            },\n            _trigger : function (event_name) {\n                $(document).triggerHandler(\"context_\" + event_name + \".vakata\", {\n                    \"reference\"\t: vakata_context.reference,\n                    \"element\"\t: vakata_context.element,\n                    \"position\"\t: {\n                        \"x\" : vakata_context.position_x,\n                        \"y\" : vakata_context.position_y\n                    }\n                });\n            },\n            _execute : function (i) {\n                i = vakata_context.items[i];\n                return i && (!i._disabled || ($.vakata.is_function(i._disabled) && !i._disabled({ \"item\" : i, \"reference\" : vakata_context.reference, \"element\" : vakata_context.element }))) && i.action ? i.action.call(null, {\n                    \"item\"\t\t: i,\n                    \"reference\"\t: vakata_context.reference,\n                    \"element\"\t: vakata_context.element,\n                    \"position\"\t: {\n                        \"x\" : vakata_context.position_x,\n                        \"y\" : vakata_context.position_y\n                    }\n                }) : false;\n            },\n            _parse : function (o, is_callback) {\n                if(!o) { return false; }\n                if(!is_callback) {\n                    vakata_context.html\t\t= \"\";\n                    vakata_context.items\t= [];\n                }\n                var str = \"\",\n                    sep = false,\n                    tmp;\n\n                if(is_callback) { str += \"<\"+\"ul>\"; }\n                $.each(o, function (i, val) {\n                    if(!val) { return true; }\n                    vakata_context.items.push(val);\n                    if(!sep && val.separator_before) {\n                        str += \"<\"+\"li class='vakata-context-separator'><\"+\"a href='#' \" + ($.vakata.context.settings.icons ? '' : 'class=\"vakata-context-no-icons\"') + \">&#160;<\"+\"/a><\"+\"/li>\";\n                    }\n                    sep = false;\n                    str += \"<\"+\"li class='\" + (val._class || \"\") + (val._disabled === true || ($.vakata.is_function(val._disabled) && val._disabled({ \"item\" : val, \"reference\" : vakata_context.reference, \"element\" : vakata_context.element })) ? \" vakata-contextmenu-disabled \" : \"\") + \"' \"+(val.shortcut?\" data-shortcut='\"+val.shortcut+\"' \":'')+\">\";\n                    str += \"<\"+\"a href='#' rel='\" + (vakata_context.items.length - 1) + \"' \" + (val.title ? \"title='\" + val.title + \"'\" : \"\") + \">\";\n                    if($.vakata.context.settings.icons) {\n                        str += \"<\"+\"i \";\n                        if(val.icon) {\n                            if(val.icon.indexOf(\"/\") !== -1 || val.icon.indexOf(\".\") !== -1) { str += \" style='background:url(\\\"\" + val.icon + \"\\\") center center no-repeat' \"; }\n                            else { str += \" class='\" + val.icon + \"' \"; }\n                        }\n                        str += \"><\"+\"/i><\"+\"span class='vakata-contextmenu-sep'>&#160;<\"+\"/span>\";\n                    }\n                    str += ($.vakata.is_function(val.label) ? val.label({ \"item\" : i, \"reference\" : vakata_context.reference, \"element\" : vakata_context.element }) : val.label) + (val.shortcut?' <span class=\"vakata-contextmenu-shortcut vakata-contextmenu-shortcut-'+val.shortcut+'\">'+ (val.shortcut_label || '') +'</span>':'') + \"<\"+\"/a>\";\n                    if(val.submenu) {\n                        tmp = $.vakata.context._parse(val.submenu, true);\n                        if(tmp) { str += tmp; }\n                    }\n                    str += \"<\"+\"/li>\";\n                    if(val.separator_after) {\n                        str += \"<\"+\"li class='vakata-context-separator'><\"+\"a href='#' \" + ($.vakata.context.settings.icons ? '' : 'class=\"vakata-context-no-icons\"') + \">&#160;<\"+\"/a><\"+\"/li>\";\n                        sep = true;\n                    }\n                });\n                str  = str.replace(/<li class\\='vakata-context-separator'\\><\\/li\\>$/,\"\");\n                if(is_callback) { str += \"</ul>\"; }\n                /**\n                 * triggered on the document when the contextmenu is parsed (HTML is built)\n                 * @event\n                 * @plugin contextmenu\n                 * @name context_parse.vakata\n                 * @param {jQuery} reference the element that was right clicked\n                 * @param {jQuery} element the DOM element of the menu itself\n                 * @param {Object} position the x & y coordinates of the menu\n                 */\n                if(!is_callback) { vakata_context.html = str; $.vakata.context._trigger(\"parse\"); }\n                return str.length > 10 ? str : false;\n            },\n            _show_submenu : function (o) {\n                o = $(o);\n                if(!o.length || !o.children(\"ul\").length) { return; }\n                var e = o.children(\"ul\"),\n                    xl = o.offset().left,\n                    x = xl + o.outerWidth(),\n                    y = o.offset().top,\n                    w = e.width(),\n                    h = e.height(),\n                    dw = $(window).width() + $(window).scrollLeft(),\n                    dh = $(window).height() + $(window).scrollTop();\n                // \u043c\u043e\u0436\u0435 \u0434\u0430 \u0441\u0435 \u0441\u043f\u0435\u0441\u0442\u0438 \u0435 \u0435\u0434\u043d\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 - \u0434\u0430\u043b\u0438 \u043d\u044f\u043c\u0430 \u043d\u044f\u043a\u043e\u0439 \u043e\u0442 \u043a\u043b\u0430\u0441\u043e\u0432\u0435\u0442\u0435 \u0432\u0435\u0447\u0435 \u043d\u0430\u0433\u043e\u0440\u0435\n                if(right_to_left) {\n                    o[x - (w + 10 + o.outerWidth()) < 0 ? \"addClass\" : \"removeClass\"](\"vakata-context-left\");\n                }\n                else {\n                    o[x + w > dw  && xl > dw - x ? \"addClass\" : \"removeClass\"](\"vakata-context-right\");\n                }\n                if(y + h + 10 > dh) {\n                    e.css(\"bottom\",\"-1px\");\n                }\n\n                //if does not fit - stick it to the side\n                if (o.hasClass('vakata-context-right')) {\n                    if (xl < w) {\n                        e.css(\"margin-right\", xl - w);\n                    }\n                } else {\n                    if (dw - x < w) {\n                        e.css(\"margin-left\", dw - x - w);\n                    }\n                }\n\n                e.show();\n            },\n            show : function (reference, position, data) {\n                var o, e, x, y, w, h, dw, dh, cond = true;\n                if(vakata_context.element && vakata_context.element.length) {\n                    vakata_context.element.width('');\n                }\n                switch(cond) {\n                    case (!position && !reference):\n                        return false;\n                    case (!!position && !!reference):\n                        vakata_context.reference\t= reference;\n                        vakata_context.position_x\t= position.x;\n                        vakata_context.position_y\t= position.y;\n                        break;\n                    case (!position && !!reference):\n                        vakata_context.reference\t= reference;\n                        o = reference.offset();\n                        vakata_context.position_x\t= o.left + reference.outerHeight();\n                        vakata_context.position_y\t= o.top;\n                        break;\n                    case (!!position && !reference):\n                        vakata_context.position_x\t= position.x;\n                        vakata_context.position_y\t= position.y;\n                        break;\n                }\n                if(!!reference && !data && $(reference).data('vakata_contextmenu')) {\n                    data = $(reference).data('vakata_contextmenu');\n                }\n                if($.vakata.context._parse(data)) {\n                    vakata_context.element.html(vakata_context.html);\n                }\n                if(vakata_context.items.length) {\n                    vakata_context.element.appendTo(document.body);\n                    e = vakata_context.element;\n                    x = vakata_context.position_x;\n                    y = vakata_context.position_y;\n                    w = e.width();\n                    h = e.height();\n                    dw = $(window).width() + $(window).scrollLeft();\n                    dh = $(window).height() + $(window).scrollTop();\n                    if(right_to_left) {\n                        x -= (e.outerWidth() - $(reference).outerWidth());\n                        if(x < $(window).scrollLeft() + 20) {\n                            x = $(window).scrollLeft() + 20;\n                        }\n                    }\n                    if(x + w + 20 > dw) {\n                        x = dw - (w + 20);\n                    }\n                    if(y + h + 20 > dh) {\n                        y = dh - (h + 20);\n                    }\n\n                    vakata_context.element\n                        .css({ \"left\" : x, \"top\" : y })\n                        .show()\n                        .find('a').first().trigger('focus').parent().addClass(\"vakata-context-hover\");\n                    vakata_context.is_visible = true;\n                    /**\n                     * triggered on the document when the contextmenu is shown\n                     * @event\n                     * @plugin contextmenu\n                     * @name context_show.vakata\n                     * @param {jQuery} reference the element that was right clicked\n                     * @param {jQuery} element the DOM element of the menu itself\n                     * @param {Object} position the x & y coordinates of the menu\n                     */\n                    $.vakata.context._trigger(\"show\");\n                }\n            },\n            hide : function () {\n                if(vakata_context.is_visible) {\n                    vakata_context.element.hide().find(\"ul\").hide().end().find(':focus').trigger('blur').end().detach();\n                    vakata_context.is_visible = false;\n                    /**\n                     * triggered on the document when the contextmenu is hidden\n                     * @event\n                     * @plugin contextmenu\n                     * @name context_hide.vakata\n                     * @param {jQuery} reference the element that was right clicked\n                     * @param {jQuery} element the DOM element of the menu itself\n                     * @param {Object} position the x & y coordinates of the menu\n                     */\n                    $.vakata.context._trigger(\"hide\");\n                }\n            }\n        };\n        $(function () {\n            right_to_left = $(document.body).css(\"direction\") === \"rtl\";\n            var to = false;\n\n            vakata_context.element = $(\"<ul class='vakata-context'></ul>\");\n            vakata_context.element\n                .on(\"mouseenter\", \"li\", function (e) {\n                    e.stopImmediatePropagation();\n\n                    if($.contains(this, e.relatedTarget)) {\n                        // \u043f\u0440\u0435\u043c\u0430\u0445\u043d\u0430\u0442\u043e \u0437\u0430\u0440\u0430\u0434\u0438 delegate mouseleave \u043f\u043e-\u0434\u043e\u043b\u0443\n                        // $(this).find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\");\n                        return;\n                    }\n\n                    if(to) { clearTimeout(to); }\n                    vakata_context.element.find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").end();\n\n                    $(this)\n                        .siblings().find(\"ul\").hide().end().end()\n                        .parentsUntil(\".vakata-context\", \"li\").addBack().addClass(\"vakata-context-hover\");\n                    $.vakata.context._show_submenu(this);\n                })\n                // \u0442\u0435\u0441\u0442\u043e\u0432\u043e - \u0434\u0430\u043b\u0438 \u043d\u0435 \u043d\u0430\u0442\u043e\u0432\u0430\u0440\u0432\u0430?\n                .on(\"mouseleave\", \"li\", function (e) {\n                    if($.contains(this, e.relatedTarget)) { return; }\n                    $(this).find(\".vakata-context-hover\").addBack().removeClass(\"vakata-context-hover\");\n                })\n                .on(\"mouseleave\", function (e) {\n                    $(this).find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\");\n                    if($.vakata.context.settings.hide_onmouseleave) {\n                        to = setTimeout(\n                            (function (t) {\n                                return function () { $.vakata.context.hide(); };\n                            }(this)), $.vakata.context.settings.hide_onmouseleave);\n                    }\n                })\n                .on(\"click\", \"a\", function (e) {\n                    e.preventDefault();\n                    //})\n                    //.on(\"mouseup\", \"a\", function (e) {\n                    if(!$(this).trigger('blur').parent().hasClass(\"vakata-context-disabled\") && $.vakata.context._execute($(this).attr(\"rel\")) !== false) {\n                        $.vakata.context.hide();\n                    }\n                })\n                .on('keydown', 'a', function (e) {\n                    var o = null;\n                    switch(e.which) {\n                        case 13:\n                        case 32:\n                            e.type = \"click\";\n                            e.preventDefault();\n                            $(e.currentTarget).trigger(e);\n                            break;\n                        case 37:\n                            if(vakata_context.is_visible) {\n                                vakata_context.element.find(\".vakata-context-hover\").last().closest(\"li\").first().find(\"ul\").hide().find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").end().end().children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 38:\n                            if(vakata_context.is_visible) {\n                                o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").prevAll(\"li:not(.vakata-context-separator)\").first();\n                                if(!o.length) { o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\"li:not(.vakata-context-separator)\").last(); }\n                                o.addClass(\"vakata-context-hover\").children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 39:\n                            if(vakata_context.is_visible) {\n                                vakata_context.element.find(\".vakata-context-hover\").last().children(\"ul\").show().children(\"li:not(.vakata-context-separator)\").removeClass(\"vakata-context-hover\").first().addClass(\"vakata-context-hover\").children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 40:\n                            if(vakata_context.is_visible) {\n                                o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").nextAll(\"li:not(.vakata-context-separator)\").first();\n                                if(!o.length) { o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\"li:not(.vakata-context-separator)\").first(); }\n                                o.addClass(\"vakata-context-hover\").children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 27:\n                            $.vakata.context.hide();\n                            e.preventDefault();\n                            break;\n                        default:\n                            //console.log(e.which);\n                            break;\n                    }\n                })\n                .on('keydown', function (e) {\n                    e.preventDefault();\n                    var a = vakata_context.element.find('.vakata-contextmenu-shortcut-' + e.which).parent();\n                    if(a.parent().not('.vakata-context-disabled')) {\n                        a.trigger('click');\n                    }\n                });\n\n            $(document)\n                .on(\"mousedown.vakata.jstree\", function (e) {\n                    if(vakata_context.is_visible && vakata_context.element[0] !== e.target  && !$.contains(vakata_context.element[0], e.target)) {\n                        $.vakata.context.hide();\n                    }\n                })\n                .on(\"context_show.vakata.jstree\", function (e, data) {\n                    vakata_context.element.find(\"li:has(ul)\").children(\"a\").addClass(\"vakata-context-parent\");\n                    if(right_to_left) {\n                        vakata_context.element.addClass(\"vakata-context-rtl\").css(\"direction\", \"rtl\");\n                    }\n                    // also apply a RTL class?\n                    vakata_context.element.find(\"ul\").hide().end();\n                });\n        });\n    }($));\n    // $.jstree.defaults.plugins.push(\"contextmenu\");\n\n\n    /**\n     * ### Drag'n'drop plugin\n     *\n     * Enables dragging and dropping of nodes in the tree, resulting in a move or copy operations.\n     */\n\n    /**\n     * stores all defaults for the drag'n'drop plugin\n     * @name $.jstree.defaults.dnd\n     * @plugin dnd\n     */\n    $.jstree.defaults.dnd = {\n        /**\n         * a boolean indicating if a copy should be possible while dragging (by pressint the meta key or Ctrl). Defaults to `true`.\n         * @name $.jstree.defaults.dnd.copy\n         * @plugin dnd\n         */\n        copy : true,\n        /**\n         * a number indicating how long a node should remain hovered while dragging to be opened. Defaults to `500`.\n         * @name $.jstree.defaults.dnd.open_timeout\n         * @plugin dnd\n         */\n        open_timeout : 500,\n        /**\n         * a function invoked each time a node is about to be dragged, invoked in the tree's scope and receives the nodes about to be dragged as an argument (array) and the event that started the drag - return `false` to prevent dragging\n         * @name $.jstree.defaults.dnd.is_draggable\n         * @plugin dnd\n         */\n        is_draggable : true,\n        /**\n         * a boolean indicating if checks should constantly be made while the user is dragging the node (as opposed to checking only on drop), default is `true`\n         * @name $.jstree.defaults.dnd.check_while_dragging\n         * @plugin dnd\n         */\n        check_while_dragging : true,\n        /**\n         * a boolean indicating if nodes from this tree should only be copied with dnd (as opposed to moved), default is `false`\n         * @name $.jstree.defaults.dnd.always_copy\n         * @plugin dnd\n         */\n        always_copy : false,\n        /**\n         * when dropping a node \"inside\", this setting indicates the position the node should go to - it can be an integer or a string: \"first\" (same as 0) or \"last\", default is `0`\n         * @name $.jstree.defaults.dnd.inside_pos\n         * @plugin dnd\n         */\n        inside_pos : 0,\n        /**\n         * when starting the drag on a node that is selected this setting controls if all selected nodes are dragged or only the single node, default is `true`, which means all selected nodes are dragged when the drag is started on a selected node\n         * @name $.jstree.defaults.dnd.drag_selection\n         * @plugin dnd\n         */\n        drag_selection : true,\n        /**\n         * controls whether dnd works on touch devices. If left as boolean true dnd will work the same as in desktop browsers, which in some cases may impair scrolling. If set to boolean false dnd will not work on touch devices. There is a special third option - string \"selected\" which means only selected nodes can be dragged on touch devices.\n         * @name $.jstree.defaults.dnd.touch\n         * @plugin dnd\n         */\n        touch : true,\n        /**\n         * controls whether items can be dropped anywhere on the node, not just on the anchor, by default only the node anchor is a valid drop target. Works best with the wholerow plugin. If enabled on mobile depending on the interface it might be hard for the user to cancel the drop, since the whole tree container will be a valid drop target.\n         * @name $.jstree.defaults.dnd.large_drop_target\n         * @plugin dnd\n         */\n        large_drop_target : false,\n        /**\n         * controls whether a drag can be initiated from any part of the node and not just the text/icon part, works best with the wholerow plugin. Keep in mind it can cause problems with tree scrolling on mobile depending on the interface - in that case set the touch option to \"selected\".\n         * @name $.jstree.defaults.dnd.large_drag_target\n         * @plugin dnd\n         */\n        large_drag_target : false,\n        /**\n         * controls whether use HTML5 dnd api instead of classical. That will allow better integration of dnd events with other HTML5 controls.\n         * @reference http://caniuse.com/#feat=dragndrop\n         * @name $.jstree.defaults.dnd.use_html5\n         * @plugin dnd\n         */\n        use_html5: false\n    };\n    var drg, elm;\n    // TODO: now check works by checking for each node individually, how about max_children, unique, etc?\n    $.jstree.plugins.dnd = function (options, parent) {\n        this.init = function (el, options) {\n            parent.init.call(this, el, options);\n            this.settings.dnd.use_html5 = this.settings.dnd.use_html5 && ('draggable' in document.createElement('span'));\n        };\n        this.bind = function () {\n            parent.bind.call(this);\n\n            this.element\n                .on(this.settings.dnd.use_html5 ? 'dragstart.jstree' : 'mousedown.jstree touchstart.jstree', this.settings.dnd.large_drag_target ? '.jstree-node' : '.jstree-anchor', function (e) {\n                    if(this.settings.dnd.large_drag_target && $(e.target).closest('.jstree-node')[0] !== e.currentTarget) {\n                        return true;\n                    }\n                    if(e.type === \"touchstart\" && (!this.settings.dnd.touch || (this.settings.dnd.touch === 'selected' && !$(e.currentTarget).closest('.jstree-node').children('.jstree-anchor').hasClass('jstree-clicked')))) {\n                        return true;\n                    }\n                    var obj = this.get_node(e.target),\n                        mlt = this.is_selected(obj) && this.settings.dnd.drag_selection ? this.get_top_selected().length : 1,\n                        txt = (mlt > 1 ? mlt + ' ' + this.get_string('nodes') : this.get_text(e.currentTarget));\n                    if(this.settings.core.force_text) {\n                        txt = $.vakata.html.escape(txt);\n                    }\n                    if(obj && obj.id && obj.id !== $.jstree.root && (e.which === 1 || e.type === \"touchstart\" || e.type === \"dragstart\") &&\n                        (this.settings.dnd.is_draggable === true || ($.vakata.is_function(this.settings.dnd.is_draggable) && this.settings.dnd.is_draggable.call(this, (mlt > 1 ? this.get_top_selected(true) : [obj]), e)))\n                    ) {\n                        drg = { 'jstree' : true, 'origin' : this, 'obj' : this.get_node(obj,true), 'nodes' : mlt > 1 ? this.get_top_selected() : [obj.id] };\n                        elm = e.currentTarget;\n                        if (this.settings.dnd.use_html5) {\n                            $.vakata.dnd._trigger('start', e, { 'helper': $(), 'element': elm, 'data': drg });\n                        } else {\n                            this.element.trigger('mousedown.jstree');\n                            return $.vakata.dnd.start(e, drg, '<div id=\"jstree-dnd\" class=\"jstree-' + this.get_theme() + ' jstree-' + this.get_theme() + '-' + this.get_theme_variant() + ' ' + ( this.settings.core.themes.responsive ? ' jstree-dnd-responsive' : '' ) + '\"><i class=\"jstree-icon jstree-er\"></i>' + txt + '<ins class=\"jstree-copy\">+</ins></div>');\n                        }\n                    }\n                }.bind(this));\n            if (this.settings.dnd.use_html5) {\n                this.element\n                    .on('dragover.jstree', function (e) {\n                        e.preventDefault();\n                        $.vakata.dnd._trigger('move', e, { 'helper': $(), 'element': elm, 'data': drg });\n                        return false;\n                    })\n                    //.on('dragenter.jstree', this.settings.dnd.large_drop_target ? '.jstree-node' : '.jstree-anchor', $.proxy(function (e) {\n                    //\t\te.preventDefault();\n                    //\t\t$.vakata.dnd._trigger('move', e, { 'helper': $(), 'element': elm, 'data': drg });\n                    //\t\treturn false;\n                    //\t}, this))\n                    .on('drop.jstree', function (e) {\n                        e.preventDefault();\n                        $.vakata.dnd._trigger('stop', e, { 'helper': $(), 'element': elm, 'data': drg });\n                        return false;\n                    }.bind(this));\n            }\n        };\n        this.redraw_node = function(obj, deep, callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if (obj && this.settings.dnd.use_html5) {\n                if (this.settings.dnd.large_drag_target) {\n                    obj.setAttribute('draggable', true);\n                } else {\n                    var i, j, tmp = null;\n                    for(i = 0, j = obj.childNodes.length; i < j; i++) {\n                        if(obj.childNodes[i] && obj.childNodes[i].className && obj.childNodes[i].className.indexOf(\"jstree-anchor\") !== -1) {\n                            tmp = obj.childNodes[i];\n                            break;\n                        }\n                    }\n                    if(tmp) {\n                        tmp.setAttribute('draggable', true);\n                    }\n                }\n            }\n            return obj;\n        };\n    };\n\n    $(function() {\n        // bind only once for all instances\n        var lastmv = false,\n            laster = false,\n            lastev = false,\n            opento = false,\n            marker = $('<div id=\"jstree-marker\">&#160;</div>').hide(); //.appendTo('body');\n\n        $(document)\n            .on('dragover.vakata.jstree', function (e) {\n                if (elm) {\n                    $.vakata.dnd._trigger('move', e, { 'helper': $(), 'element': elm, 'data': drg });\n                }\n            })\n            .on('drop.vakata.jstree', function (e) {\n                if (elm) {\n                    $.vakata.dnd._trigger('stop', e, { 'helper': $(), 'element': elm, 'data': drg });\n                    elm = null;\n                    drg = null;\n                }\n            })\n            .on('dnd_start.vakata.jstree', function (e, data) {\n                lastmv = false;\n                lastev = false;\n                if(!data || !data.data || !data.data.jstree) { return; }\n                marker.appendTo(document.body); //.show();\n            })\n            .on('dnd_move.vakata.jstree', function (e, data) {\n                var isDifferentNode = data.event.target !== lastev.target;\n                if(opento) {\n                    if (!data.event || data.event.type !== 'dragover' || isDifferentNode) {\n                        clearTimeout(opento);\n                    }\n                }\n                if(!data || !data.data || !data.data.jstree) { return; }\n\n                // if we are hovering the marker image do nothing (can happen on \"inside\" drags)\n                if(data.event.target.id && data.event.target.id === 'jstree-marker') {\n                    return;\n                }\n                lastev = data.event;\n\n                var ins = $.jstree.reference(data.event.target),\n                    ref = false,\n                    off = false,\n                    rel = false,\n                    tmp, l, t, h, p, i, o, ok, t1, t2, op, ps, pr, ip, tm, is_copy, pn, c;\n                // if we are over an instance\n                if(ins && ins._data && ins._data.dnd) {\n                    marker.attr('class', 'jstree-' + ins.get_theme() + ( ins.settings.core.themes.responsive ? ' jstree-dnd-responsive' : '' ));\n                    is_copy = data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey)));\n                    data.helper\n                        .children().attr('class', 'jstree-' + ins.get_theme() + ' jstree-' + ins.get_theme() + '-' + ins.get_theme_variant() + ' ' + ( ins.settings.core.themes.responsive ? ' jstree-dnd-responsive' : '' ))\n                        .find('.jstree-copy').first()[ is_copy ? 'show' : 'hide' ]();\n\n                    // if are hovering the container itself add a new root node\n                    //console.log(data.event);\n                    if( (data.event.target === ins.element[0] || data.event.target === ins.get_container_ul()[0]) && ins.get_container_ul().children().length === 0) {\n                        ok = true;\n                        for(t1 = 0, t2 = data.data.nodes.length; t1 < t2; t1++) {\n                            ok = ok && ins.check( (data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey)) ) ? \"copy_node\" : \"move_node\"), (data.data.origin && data.data.origin !== ins ? data.data.origin.get_node(data.data.nodes[t1]) : data.data.nodes[t1]), $.jstree.root, 'last', { 'dnd' : true, 'ref' : ins.get_node($.jstree.root), 'pos' : 'i', 'origin' : data.data.origin, 'is_multi' : (data.data.origin && data.data.origin !== ins), 'is_foreign' : (!data.data.origin) });\n                            if(!ok) { break; }\n                        }\n                        if(ok) {\n                            lastmv = { 'ins' : ins, 'par' : $.jstree.root, 'pos' : 'last' };\n                            marker.hide();\n                            data.helper.find('.jstree-icon').first().removeClass('jstree-er').addClass('jstree-ok');\n                            if (data.event.originalEvent && data.event.originalEvent.dataTransfer) {\n                                data.event.originalEvent.dataTransfer.dropEffect = is_copy ? 'copy' : 'move';\n                            }\n                            return;\n                        }\n                    }\n                    else {\n                        // if we are hovering a tree node\n                        ref = ins.settings.dnd.large_drop_target ? $(data.event.target).closest('.jstree-node').children('.jstree-anchor') : $(data.event.target).closest('.jstree-anchor');\n                        if(ref && ref.length && ref.parent().is('.jstree-closed, .jstree-open, .jstree-leaf')) {\n                            off = ref.offset();\n                            rel = (data.event.pageY !== undefined ? data.event.pageY : data.event.originalEvent.pageY) - off.top;\n                            h = ref.outerHeight();\n                            if(rel < h / 3) {\n                                o = ['b', 'i', 'a'];\n                            }\n                            else if(rel > h - h / 3) {\n                                o = ['a', 'i', 'b'];\n                            }\n                            else {\n                                o = rel > h / 2 ? ['i', 'a', 'b'] : ['i', 'b', 'a'];\n                            }\n                            $.each(o, function (j, v) {\n                                switch(v) {\n                                    case 'b':\n                                        l = off.left - 6;\n                                        t = off.top;\n                                        p = ins.get_parent(ref);\n                                        i = ref.parent().index();\n                                        c = 'jstree-below';\n                                        break;\n                                    case 'i':\n                                        ip = ins.settings.dnd.inside_pos;\n                                        tm = ins.get_node(ref.parent());\n                                        l = off.left - 2;\n                                        t = off.top + h / 2 + 1;\n                                        p = tm.id;\n                                        i = ip === 'first' ? 0 : (ip === 'last' ? tm.children.length : Math.min(ip, tm.children.length));\n                                        c = 'jstree-inside';\n                                        break;\n                                    case 'a':\n                                        l = off.left - 6;\n                                        t = off.top + h;\n                                        p = ins.get_parent(ref);\n                                        i = ref.parent().index() + 1;\n                                        c = 'jstree-above';\n                                        break;\n                                }\n                                ok = true;\n                                for(t1 = 0, t2 = data.data.nodes.length; t1 < t2; t1++) {\n                                    op = data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey))) ? \"copy_node\" : \"move_node\";\n                                    ps = i;\n                                    if(op === \"move_node\" && v === 'a' && (data.data.origin && data.data.origin === ins) && p === ins.get_parent(data.data.nodes[t1])) {\n                                        pr = ins.get_node(p);\n                                        if(ps > $.inArray(data.data.nodes[t1], pr.children)) {\n                                            ps -= 1;\n                                        }\n                                    }\n                                    ok = ok && ( (ins && ins.settings && ins.settings.dnd && ins.settings.dnd.check_while_dragging === false) || ins.check(op, (data.data.origin && data.data.origin !== ins ? data.data.origin.get_node(data.data.nodes[t1]) : data.data.nodes[t1]), p, ps, { 'dnd' : true, 'ref' : ins.get_node(ref.parent()), 'pos' : v, 'origin' : data.data.origin, 'is_multi' : (data.data.origin && data.data.origin !== ins), 'is_foreign' : (!data.data.origin) }) );\n                                    if(!ok) {\n                                        if(ins && ins.last_error) { laster = ins.last_error(); }\n                                        break;\n                                    }\n                                }\n                                if(v === 'i' && ref.parent().is('.jstree-closed') && ins.settings.dnd.open_timeout) {\n                                    if (!data.event || data.event.type !== 'dragover' || isDifferentNode) {\n                                        if (opento) { clearTimeout(opento); }\n                                        opento = setTimeout((function (x, z) { return function () { x.open_node(z); }; }(ins, ref)), ins.settings.dnd.open_timeout);\n                                    }\n                                }\n                                if(ok) {\n                                    pn = ins.get_node(p, true);\n                                    if (!pn.hasClass('.jstree-dnd-parent')) {\n                                        $('.jstree-dnd-parent').removeClass('jstree-dnd-parent');\n                                        pn.addClass('jstree-dnd-parent');\n                                    }\n                                    lastmv = { 'ins' : ins, 'par' : p, 'pos' : v === 'i' && ip === 'last' && i === 0 && !ins.is_loaded(tm) ? 'last' : i };\n                                    marker.css({ 'left' : l + 'px', 'top' : t + 'px' }).show();\n                                    marker.removeClass('jstree-above jstree-inside jstree-below').addClass(c);\n                                    data.helper.find('.jstree-icon').first().removeClass('jstree-er').addClass('jstree-ok');\n                                    if (data.event.originalEvent && data.event.originalEvent.dataTransfer) {\n                                        data.event.originalEvent.dataTransfer.dropEffect = is_copy ? 'copy' : 'move';\n                                    }\n                                    laster = {};\n                                    o = true;\n                                    return false;\n                                }\n                            });\n                            if(o === true) { return; }\n                        }\n                    }\n                }\n                $('.jstree-dnd-parent').removeClass('jstree-dnd-parent');\n                lastmv = false;\n                data.helper.find('.jstree-icon').removeClass('jstree-ok').addClass('jstree-er');\n                if (data.event.originalEvent && data.event.originalEvent.dataTransfer) {\n                    //data.event.originalEvent.dataTransfer.dropEffect = 'none';\n                }\n                marker.hide();\n            })\n            .on('dnd_scroll.vakata.jstree', function (e, data) {\n                if(!data || !data.data || !data.data.jstree) { return; }\n                marker.hide();\n                lastmv = false;\n                lastev = false;\n                data.helper.find('.jstree-icon').first().removeClass('jstree-ok').addClass('jstree-er');\n            })\n            .on('dnd_stop.vakata.jstree', function (e, data) {\n                $('.jstree-dnd-parent').removeClass('jstree-dnd-parent');\n                if(opento) { clearTimeout(opento); }\n                if(!data || !data.data || !data.data.jstree) { return; }\n                marker.hide().detach();\n                var i, j, nodes = [];\n                if(lastmv) {\n                    for(i = 0, j = data.data.nodes.length; i < j; i++) {\n                        nodes[i] = data.data.origin ? data.data.origin.get_node(data.data.nodes[i]) : data.data.nodes[i];\n                    }\n                    lastmv.ins[ data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey))) ? 'copy_node' : 'move_node' ](nodes, lastmv.par, lastmv.pos, false, false, false, data.data.origin);\n                }\n                else {\n                    i = $(data.event.target).closest('.jstree');\n                    if(i.length && laster && laster.error && laster.error === 'check') {\n                        i = i.jstree(true);\n                        if(i) {\n                            i.settings.core.error.call(this, laster);\n                        }\n                    }\n                }\n                lastev = false;\n                lastmv = false;\n            })\n            .on('keyup.jstree keydown.jstree', function (e, data) {\n                data = $.vakata.dnd._get();\n                if(data && data.data && data.data.jstree) {\n                    if (e.type === \"keyup\" && e.which === 27) {\n                        if (opento) { clearTimeout(opento); }\n                        lastmv = false;\n                        laster = false;\n                        lastev = false;\n                        opento = false;\n                        marker.hide().detach();\n                        $.vakata.dnd._clean();\n                    } else {\n                        data.helper.find('.jstree-copy').first()[ data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (e.metaKey || e.ctrlKey))) ? 'show' : 'hide' ]();\n                        if(lastev) {\n                            lastev.metaKey = e.metaKey;\n                            lastev.ctrlKey = e.ctrlKey;\n                            $.vakata.dnd._trigger('move', lastev);\n                        }\n                    }\n                }\n            });\n    });\n\n    // helpers\n    (function ($) {\n        $.vakata.html = {\n            div : $('<div></div>'),\n            escape : function (str) {\n                return $.vakata.html.div.text(str).html();\n            },\n            strip : function (str) {\n                return $.vakata.html.div.empty().append($.parseHTML(str)).text();\n            }\n        };\n        // private variable\n        var vakata_dnd = {\n            element\t: false,\n            target\t: false,\n            is_down\t: false,\n            is_drag\t: false,\n            helper\t: false,\n            helper_w: 0,\n            data\t: false,\n            init_x\t: 0,\n            init_y\t: 0,\n            scroll_l: 0,\n            scroll_t: 0,\n            scroll_e: false,\n            scroll_i: false,\n            is_touch: false\n        };\n        $.vakata.dnd = {\n            settings : {\n                scroll_speed\t\t: 10,\n                scroll_proximity\t: 20,\n                helper_left\t\t\t: 5,\n                helper_top\t\t\t: 10,\n                threshold\t\t\t: 5,\n                threshold_touch\t\t: 10\n            },\n            _trigger : function (event_name, e, data) {\n                if (data === undefined) {\n                    data = $.vakata.dnd._get();\n                }\n                data.event = e;\n                $(document).triggerHandler(\"dnd_\" + event_name + \".vakata\", data);\n            },\n            _get : function () {\n                return {\n                    \"data\"\t\t: vakata_dnd.data,\n                    \"element\"\t: vakata_dnd.element,\n                    \"helper\"\t: vakata_dnd.helper\n                };\n            },\n            _clean : function () {\n                if(vakata_dnd.helper) { vakata_dnd.helper.remove(); }\n                if(vakata_dnd.scroll_i) { clearInterval(vakata_dnd.scroll_i); vakata_dnd.scroll_i = false; }\n                vakata_dnd = {\n                    element\t: false,\n                    target\t: false,\n                    is_down\t: false,\n                    is_drag\t: false,\n                    helper\t: false,\n                    helper_w: 0,\n                    data\t: false,\n                    init_x\t: 0,\n                    init_y\t: 0,\n                    scroll_l: 0,\n                    scroll_t: 0,\n                    scroll_e: false,\n                    scroll_i: false,\n                    is_touch: false\n                };\n                elm = null;\n                $(document).off(\"mousemove.vakata.jstree touchmove.vakata.jstree\", $.vakata.dnd.drag);\n                $(document).off(\"mouseup.vakata.jstree touchend.vakata.jstree\", $.vakata.dnd.stop);\n            },\n            _scroll : function (init_only) {\n                if(!vakata_dnd.scroll_e || (!vakata_dnd.scroll_l && !vakata_dnd.scroll_t)) {\n                    if(vakata_dnd.scroll_i) { clearInterval(vakata_dnd.scroll_i); vakata_dnd.scroll_i = false; }\n                    return false;\n                }\n                if(!vakata_dnd.scroll_i) {\n                    vakata_dnd.scroll_i = setInterval($.vakata.dnd._scroll, 100);\n                    return false;\n                }\n                if(init_only === true) { return false; }\n\n                var i = vakata_dnd.scroll_e.scrollTop(),\n                    j = vakata_dnd.scroll_e.scrollLeft();\n                vakata_dnd.scroll_e.scrollTop(i + vakata_dnd.scroll_t * $.vakata.dnd.settings.scroll_speed);\n                vakata_dnd.scroll_e.scrollLeft(j + vakata_dnd.scroll_l * $.vakata.dnd.settings.scroll_speed);\n                if(i !== vakata_dnd.scroll_e.scrollTop() || j !== vakata_dnd.scroll_e.scrollLeft()) {\n                    /**\n                     * triggered on the document when a drag causes an element to scroll\n                     * @event\n                     * @plugin dnd\n                     * @name dnd_scroll.vakata\n                     * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                     * @param {DOM} element the DOM element being dragged\n                     * @param {jQuery} helper the helper shown next to the mouse\n                     * @param {jQuery} event the element that is scrolling\n                     */\n                    $.vakata.dnd._trigger(\"scroll\", vakata_dnd.scroll_e);\n                }\n            },\n            start : function (e, data, html) {\n                if(e.type === \"touchstart\" && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0]) {\n                    e.pageX = e.originalEvent.changedTouches[0].pageX;\n                    e.pageY = e.originalEvent.changedTouches[0].pageY;\n                    e.target = document.elementFromPoint(e.originalEvent.changedTouches[0].pageX - window.pageXOffset, e.originalEvent.changedTouches[0].pageY - window.pageYOffset);\n                }\n                if(vakata_dnd.is_drag) { $.vakata.dnd.stop({}); }\n                try {\n                    e.currentTarget.unselectable = \"on\";\n                    e.currentTarget.onselectstart = function() { return false; };\n                    if(e.currentTarget.style) {\n                        e.currentTarget.style.touchAction = \"none\";\n                        e.currentTarget.style.msTouchAction = \"none\";\n                        e.currentTarget.style.MozUserSelect = \"none\";\n                    }\n                } catch(ignore) { }\n                vakata_dnd.init_x\t= e.pageX;\n                vakata_dnd.init_y\t= e.pageY;\n                vakata_dnd.data\t\t= data;\n                vakata_dnd.is_down\t= true;\n                vakata_dnd.element\t= e.currentTarget;\n                vakata_dnd.target\t= e.target;\n                vakata_dnd.is_touch\t= e.type === \"touchstart\";\n                if(html !== false) {\n                    vakata_dnd.helper = $(\"<div id='vakata-dnd'></div>\").html(html).css({\n                        \"display\"\t\t: \"block\",\n                        \"margin\"\t\t: \"0\",\n                        \"padding\"\t\t: \"0\",\n                        \"position\"\t\t: \"absolute\",\n                        \"top\"\t\t\t: \"-2000px\",\n                        \"lineHeight\"\t: \"16px\",\n                        \"zIndex\"\t\t: \"10000\"\n                    });\n                }\n                $(document).on(\"mousemove.vakata.jstree touchmove.vakata.jstree\", $.vakata.dnd.drag);\n                $(document).on(\"mouseup.vakata.jstree touchend.vakata.jstree\", $.vakata.dnd.stop);\n                return false;\n            },\n            drag : function (e) {\n                if(e.type === \"touchmove\" && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0]) {\n                    e.pageX = e.originalEvent.changedTouches[0].pageX;\n                    e.pageY = e.originalEvent.changedTouches[0].pageY;\n                    e.target = document.elementFromPoint(e.originalEvent.changedTouches[0].pageX - window.pageXOffset, e.originalEvent.changedTouches[0].pageY - window.pageYOffset);\n                }\n                if(!vakata_dnd.is_down) { return; }\n                if(!vakata_dnd.is_drag) {\n                    if(\n                        Math.abs(e.pageX - vakata_dnd.init_x) > (vakata_dnd.is_touch ? $.vakata.dnd.settings.threshold_touch : $.vakata.dnd.settings.threshold) ||\n                        Math.abs(e.pageY - vakata_dnd.init_y) > (vakata_dnd.is_touch ? $.vakata.dnd.settings.threshold_touch : $.vakata.dnd.settings.threshold)\n                    ) {\n                        if(vakata_dnd.helper) {\n                            vakata_dnd.helper.appendTo(document.body);\n                            vakata_dnd.helper_w = vakata_dnd.helper.outerWidth();\n                        }\n                        vakata_dnd.is_drag = true;\n                        $(vakata_dnd.target).one('click.vakata', false);\n                        /**\n                         * triggered on the document when a drag starts\n                         * @event\n                         * @plugin dnd\n                         * @name dnd_start.vakata\n                         * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                         * @param {DOM} element the DOM element being dragged\n                         * @param {jQuery} helper the helper shown next to the mouse\n                         * @param {Object} event the event that caused the start (probably mousemove)\n                         */\n                        $.vakata.dnd._trigger(\"start\", e);\n                    }\n                    else { return; }\n                }\n\n                var d  = false, w  = false,\n                    dh = false, wh = false,\n                    dw = false, ww = false,\n                    dt = false, dl = false,\n                    ht = false, hl = false;\n\n                vakata_dnd.scroll_t = 0;\n                vakata_dnd.scroll_l = 0;\n                vakata_dnd.scroll_e = false;\n                $($(e.target).parentsUntil(\"body\").addBack().get().reverse())\n                    .filter(function () {\n                        return\t(/^auto|scroll$/).test($(this).css(\"overflow\")) &&\n                            (this.scrollHeight > this.offsetHeight || this.scrollWidth > this.offsetWidth);\n                    })\n                    .each(function () {\n                        var t = $(this), o = t.offset();\n                        if(this.scrollHeight > this.offsetHeight) {\n                            if(o.top + t.height() - e.pageY < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_t = 1; }\n                            if(e.pageY - o.top < $.vakata.dnd.settings.scroll_proximity)\t\t\t\t{ vakata_dnd.scroll_t = -1; }\n                        }\n                        if(this.scrollWidth > this.offsetWidth) {\n                            if(o.left + t.width() - e.pageX < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_l = 1; }\n                            if(e.pageX - o.left < $.vakata.dnd.settings.scroll_proximity)\t\t\t\t{ vakata_dnd.scroll_l = -1; }\n                        }\n                        if(vakata_dnd.scroll_t || vakata_dnd.scroll_l) {\n                            vakata_dnd.scroll_e = $(this);\n                            return false;\n                        }\n                    });\n\n                if(!vakata_dnd.scroll_e) {\n                    d  = $(document); w = $(window);\n                    dh = d.height(); wh = w.height();\n                    dw = d.width(); ww = w.width();\n                    dt = d.scrollTop(); dl = d.scrollLeft();\n                    if(dh > wh && e.pageY - dt < $.vakata.dnd.settings.scroll_proximity)\t\t{ vakata_dnd.scroll_t = -1;  }\n                    if(dh > wh && wh - (e.pageY - dt) < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_t = 1; }\n                    if(dw > ww && e.pageX - dl < $.vakata.dnd.settings.scroll_proximity)\t\t{ vakata_dnd.scroll_l = -1; }\n                    if(dw > ww && ww - (e.pageX - dl) < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_l = 1; }\n                    if(vakata_dnd.scroll_t || vakata_dnd.scroll_l) {\n                        vakata_dnd.scroll_e = d;\n                    }\n                }\n                if(vakata_dnd.scroll_e) { $.vakata.dnd._scroll(true); }\n\n                if(vakata_dnd.helper) {\n                    ht = parseInt(e.pageY + $.vakata.dnd.settings.helper_top, 10);\n                    hl = parseInt(e.pageX + $.vakata.dnd.settings.helper_left, 10);\n                    if(dh && ht + 25 > dh) { ht = dh - 50; }\n                    if(dw && hl + vakata_dnd.helper_w > dw) { hl = dw - (vakata_dnd.helper_w + 2); }\n                    vakata_dnd.helper.css({\n                        left\t: hl + \"px\",\n                        top\t\t: ht + \"px\"\n                    });\n                }\n                /**\n                 * triggered on the document when a drag is in progress\n                 * @event\n                 * @plugin dnd\n                 * @name dnd_move.vakata\n                 * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                 * @param {DOM} element the DOM element being dragged\n                 * @param {jQuery} helper the helper shown next to the mouse\n                 * @param {Object} event the event that caused this to trigger (most likely mousemove)\n                 */\n                $.vakata.dnd._trigger(\"move\", e);\n                return false;\n            },\n            stop : function (e) {\n                if(e.type === \"touchend\" && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0]) {\n                    e.pageX = e.originalEvent.changedTouches[0].pageX;\n                    e.pageY = e.originalEvent.changedTouches[0].pageY;\n                    e.target = document.elementFromPoint(e.originalEvent.changedTouches[0].pageX - window.pageXOffset, e.originalEvent.changedTouches[0].pageY - window.pageYOffset);\n                }\n                if(vakata_dnd.is_drag) {\n                    /**\n                     * triggered on the document when a drag stops (the dragged element is dropped)\n                     * @event\n                     * @plugin dnd\n                     * @name dnd_stop.vakata\n                     * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                     * @param {DOM} element the DOM element being dragged\n                     * @param {jQuery} helper the helper shown next to the mouse\n                     * @param {Object} event the event that caused the stop\n                     */\n                    if (e.target !== vakata_dnd.target) {\n                        $(vakata_dnd.target).off('click.vakata');\n                    }\n                    $.vakata.dnd._trigger(\"stop\", e);\n                }\n                else {\n                    if(e.type === \"touchend\" && e.target === vakata_dnd.target) {\n                        var to = setTimeout(function () { $(e.target).trigger('click'); }, 100);\n                        $(e.target).one('click', function() { if(to) { clearTimeout(to); } });\n                    }\n                }\n                $.vakata.dnd._clean();\n                return false;\n            }\n        };\n    }($));\n\n    // include the dnd plugin by default\n    // $.jstree.defaults.plugins.push(\"dnd\");\n\n\n    /**\n     * ### Massload plugin\n     *\n     * Adds massload functionality to jsTree, so that multiple nodes can be loaded in a single request (only useful with lazy loading).\n     */\n\n    /**\n     * massload configuration\n     *\n     * It is possible to set this to a standard jQuery-like AJAX config.\n     * In addition to the standard jQuery ajax options here you can supply functions for `data` and `url`, the functions will be run in the current instance's scope and a param will be passed indicating which node IDs need to be loaded, the return value of those functions will be used.\n     *\n     * You can also set this to a function, that function will receive the node IDs being loaded as argument and a second param which is a function (callback) which should be called with the result.\n     *\n     * Both the AJAX and the function approach rely on the same return value - an object where the keys are the node IDs, and the value is the children of that node as an array.\n     *\n     *\t{\n     *\t\t\"id1\" : [{ \"text\" : \"Child of ID1\", \"id\" : \"c1\" }, { \"text\" : \"Another child of ID1\", \"id\" : \"c2\" }],\n     *\t\t\"id2\" : [{ \"text\" : \"Child of ID2\", \"id\" : \"c3\" }]\n     *\t}\n     *\n     * @name $.jstree.defaults.massload\n     * @plugin massload\n     */\n    $.jstree.defaults.massload = null;\n    $.jstree.plugins.massload = function (options, parent) {\n        this.init = function (el, options) {\n            this._data.massload = {};\n            parent.init.call(this, el, options);\n        };\n        this._load_nodes = function (nodes, callback, is_callback, force_reload) {\n            var s = this.settings.massload,\n                toLoad = [],\n                m = this._model.data,\n                i, j, dom;\n            if (!is_callback) {\n                for(i = 0, j = nodes.length; i < j; i++) {\n                    if(!m[nodes[i]] || ( (!m[nodes[i]].state.loaded && !m[nodes[i]].state.failed) || force_reload) ) {\n                        toLoad.push(nodes[i]);\n                        dom = this.get_node(nodes[i], true);\n                        if (dom && dom.length) {\n                            dom.addClass(\"jstree-loading\").attr('aria-busy',true);\n                        }\n                    }\n                }\n                this._data.massload = {};\n                if (toLoad.length) {\n                    if($.vakata.is_function(s)) {\n                        return s.call(this, toLoad, function (data) {\n                            var i, j;\n                            if(data) {\n                                for(i in data) {\n                                    if(data.hasOwnProperty(i)) {\n                                        this._data.massload[i] = data[i];\n                                    }\n                                }\n                            }\n                            for(i = 0, j = nodes.length; i < j; i++) {\n                                dom = this.get_node(nodes[i], true);\n                                if (dom && dom.length) {\n                                    dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                                }\n                            }\n                            parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n                        }.bind(this));\n                    }\n                    if(typeof s === 'object' && s && s.url) {\n                        s = $.extend(true, {}, s);\n                        if($.vakata.is_function(s.url)) {\n                            s.url = s.url.call(this, toLoad);\n                        }\n                        if($.vakata.is_function(s.data)) {\n                            s.data = s.data.call(this, toLoad);\n                        }\n                        return $.ajax(s)\n                            .done(function (data,t,x) {\n                                var i, j;\n                                if(data) {\n                                    for(i in data) {\n                                        if(data.hasOwnProperty(i)) {\n                                            this._data.massload[i] = data[i];\n                                        }\n                                    }\n                                }\n                                for(i = 0, j = nodes.length; i < j; i++) {\n                                    dom = this.get_node(nodes[i], true);\n                                    if (dom && dom.length) {\n                                        dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                                    }\n                                }\n                                parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n                            }.bind(this))\n                            .fail(function (f) {\n                                parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n                            }.bind(this));\n                    }\n                }\n            }\n            return parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n        };\n        this._load_node = function (obj, callback) {\n            var data = this._data.massload[obj.id],\n                rslt = null, dom;\n            if(data) {\n                rslt = this[typeof data === 'string' ? '_append_html_data' : '_append_json_data'](\n                    obj,\n                    typeof data === 'string' ? $($.parseHTML(data)).filter(function () { return this.nodeType !== 3; }) : data,\n                    function (status) { callback.call(this, status); }\n                );\n                dom = this.get_node(obj.id, true);\n                if (dom && dom.length) {\n                    dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                }\n                delete this._data.massload[obj.id];\n                return rslt;\n            }\n            return parent._load_node.call(this, obj, callback);\n        };\n    };\n\n\n    /**\n     * ### Search plugin\n     *\n     * Adds search functionality to jsTree.\n     */\n\n    /**\n     * stores all defaults for the search plugin\n     * @name $.jstree.defaults.search\n     * @plugin search\n     */\n    $.jstree.defaults.search = {\n        /**\n         * a jQuery-like AJAX config, which jstree uses if a server should be queried for results.\n         *\n         * A `str` (which is the search string) parameter will be added with the request, an optional `inside` parameter will be added if the search is limited to a node id. The expected result is a JSON array with nodes that need to be opened so that matching nodes will be revealed.\n         * Leave this setting as `false` to not query the server. You can also set this to a function, which will be invoked in the instance's scope and receive 3 parameters - the search string, the callback to call with the array of nodes to load, and the optional node ID to limit the search to\n         * @name $.jstree.defaults.search.ajax\n         * @plugin search\n         */\n        ajax : false,\n        /**\n         * Indicates if the search should be fuzzy or not (should `chnd3` match `child node 3`). Default is `false`.\n         * @name $.jstree.defaults.search.fuzzy\n         * @plugin search\n         */\n        fuzzy : false,\n        /**\n         * Indicates if the search should be case sensitive. Default is `false`.\n         * @name $.jstree.defaults.search.case_sensitive\n         * @plugin search\n         */\n        case_sensitive : false,\n        /**\n         * Indicates if the tree should be filtered (by default) to show only matching nodes (keep in mind this can be a heavy on large trees in old browsers).\n         * This setting can be changed at runtime when calling the search method. Default is `false`.\n         * @name $.jstree.defaults.search.show_only_matches\n         * @plugin search\n         */\n        show_only_matches : false,\n        /**\n         * Indicates if the children of matched element are shown (when show_only_matches is true)\n         * This setting can be changed at runtime when calling the search method. Default is `false`.\n         * @name $.jstree.defaults.search.show_only_matches_children\n         * @plugin search\n         */\n        show_only_matches_children : false,\n        /**\n         * Indicates if all nodes opened to reveal the search result, should be closed when the search is cleared or a new search is performed. Default is `true`.\n         * @name $.jstree.defaults.search.close_opened_onclear\n         * @plugin search\n         */\n        close_opened_onclear : true,\n        /**\n         * Indicates if only leaf nodes should be included in search results. Default is `false`.\n         * @name $.jstree.defaults.search.search_leaves_only\n         * @plugin search\n         */\n        search_leaves_only : false,\n        /**\n         * If set to a function it wil be called in the instance's scope with two arguments - search string and node (where node will be every node in the structure, so use with caution).\n         * If the function returns a truthy value the node will be considered a match (it might not be displayed if search_only_leaves is set to true and the node is not a leaf). Default is `false`.\n         * @name $.jstree.defaults.search.search_callback\n         * @plugin search\n         */\n        search_callback : false\n    };\n\n    $.jstree.plugins.search = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n\n            this._data.search.str = \"\";\n            this._data.search.dom = $();\n            this._data.search.res = [];\n            this._data.search.opn = [];\n            this._data.search.som = false;\n            this._data.search.smc = false;\n            this._data.search.hdn = [];\n\n            this.element\n                .on(\"search.jstree\", function (e, data) {\n                    if(this._data.search.som && data.res.length) {\n                        var m = this._model.data, i, j, p = [], k, l;\n                        for(i = 0, j = data.res.length; i < j; i++) {\n                            if(m[data.res[i]] && !m[data.res[i]].state.hidden) {\n                                p.push(data.res[i]);\n                                p = p.concat(m[data.res[i]].parents);\n                                if(this._data.search.smc) {\n                                    for (k = 0, l = m[data.res[i]].children_d.length; k < l; k++) {\n                                        if (m[m[data.res[i]].children_d[k]] && !m[m[data.res[i]].children_d[k]].state.hidden) {\n                                            p.push(m[data.res[i]].children_d[k]);\n                                        }\n                                    }\n                                }\n                            }\n                        }\n                        p = $.vakata.array_remove_item($.vakata.array_unique(p), $.jstree.root);\n                        this._data.search.hdn = this.hide_all(true);\n                        this.show_node(p, true);\n                        this.redraw(true);\n                    }\n                }.bind(this))\n                .on(\"clear_search.jstree\", function (e, data) {\n                    if(this._data.search.som && data.res.length) {\n                        this.show_node(this._data.search.hdn, true);\n                        this.redraw(true);\n                    }\n                }.bind(this));\n        };\n        /**\n         * used to search the tree nodes for a given string\n         * @name search(str [, skip_async])\n         * @param {String} str the search string\n         * @param {Boolean} skip_async if set to true server will not be queried even if configured\n         * @param {Boolean} show_only_matches if set to true only matching nodes will be shown (keep in mind this can be very slow on large trees or old browsers)\n         * @param {mixed} inside an optional node to whose children to limit the search\n         * @param {Boolean} append if set to true the results of this search are appended to the previous search\n         * @plugin search\n         * @trigger search.jstree\n         */\n        this.search = function (str, skip_async, show_only_matches, inside, append, show_only_matches_children) {\n            if(str === false || $.vakata.trim(str.toString()) === \"\") {\n                return this.clear_search();\n            }\n            inside = this.get_node(inside);\n            inside = inside && inside.id ? inside.id : null;\n            str = str.toString();\n            var s = this.settings.search,\n                a = s.ajax ? s.ajax : false,\n                m = this._model.data,\n                f = null,\n                r = [],\n                p = [], i, j;\n            if(this._data.search.res.length && !append) {\n                this.clear_search();\n            }\n            if(show_only_matches === undefined) {\n                show_only_matches = s.show_only_matches;\n            }\n            if(show_only_matches_children === undefined) {\n                show_only_matches_children = s.show_only_matches_children;\n            }\n            if(!skip_async && a !== false) {\n                if($.vakata.is_function(a)) {\n                    return a.call(this, str, function (d) {\n                        if(d && d.d) { d = d.d; }\n                        this._load_nodes(!$.vakata.is_array(d) ? [] : $.vakata.array_unique(d), function () {\n                            this.search(str, true, show_only_matches, inside, append, show_only_matches_children);\n                        });\n                    }.bind(this), inside);\n                }\n                else {\n                    a = $.extend({}, a);\n                    if(!a.data) { a.data = {}; }\n                    a.data.str = str;\n                    if(inside) {\n                        a.data.inside = inside;\n                    }\n                    if (this._data.search.lastRequest) {\n                        this._data.search.lastRequest.abort();\n                    }\n                    this._data.search.lastRequest = $.ajax(a)\n                        .fail(function () {\n                            this._data.core.last_error = { 'error' : 'ajax', 'plugin' : 'search', 'id' : 'search_01', 'reason' : 'Could not load search parents', 'data' : JSON.stringify(a) };\n                            this.settings.core.error.call(this, this._data.core.last_error);\n                        }.bind(this))\n                        .done(function (d) {\n                            if(d && d.d) { d = d.d; }\n                            this._load_nodes(!$.vakata.is_array(d) ? [] : $.vakata.array_unique(d), function () {\n                                this.search(str, true, show_only_matches, inside, append, show_only_matches_children);\n                            });\n                        }.bind(this));\n                    return this._data.search.lastRequest;\n                }\n            }\n            if(!append) {\n                this._data.search.str = str;\n                this._data.search.dom = $();\n                this._data.search.res = [];\n                this._data.search.opn = [];\n                this._data.search.som = show_only_matches;\n                this._data.search.smc = show_only_matches_children;\n            }\n\n            f = new $.vakata.search(str, true, { caseSensitive : s.case_sensitive, fuzzy : s.fuzzy });\n            $.each(m[inside ? inside : $.jstree.root].children_d, function (ii, i) {\n                var v = m[i];\n                if(v.text && !v.state.hidden && (!s.search_leaves_only || (v.state.loaded && v.children.length === 0)) && ( (s.search_callback && s.search_callback.call(this, str, v)) || (!s.search_callback && f.search(v.text).isMatch) ) ) {\n                    r.push(i);\n                    p = p.concat(v.parents);\n                }\n            });\n            if(r.length) {\n                p = $.vakata.array_unique(p);\n                for(i = 0, j = p.length; i < j; i++) {\n                    if(p[i] !== $.jstree.root && m[p[i]] && this.open_node(p[i], null, 0) === true) {\n                        this._data.search.opn.push(p[i]);\n                    }\n                }\n                if(!append) {\n                    this._data.search.dom = $(this.element[0].querySelectorAll('#' + $.map(r, function (v) { return \"0123456789\".indexOf(v[0]) !== -1 ? '\\\\3' + v[0] + ' ' + v.substr(1).replace($.jstree.idregex,'\\\\$&') : v.replace($.jstree.idregex,'\\\\$&'); }).join(', #')));\n                    this._data.search.res = r;\n                }\n                else {\n                    this._data.search.dom = this._data.search.dom.add($(this.element[0].querySelectorAll('#' + $.map(r, function (v) { return \"0123456789\".indexOf(v[0]) !== -1 ? '\\\\3' + v[0] + ' ' + v.substr(1).replace($.jstree.idregex,'\\\\$&') : v.replace($.jstree.idregex,'\\\\$&'); }).join(', #'))));\n                    this._data.search.res = $.vakata.array_unique(this._data.search.res.concat(r));\n                }\n                this._data.search.dom.children(\".jstree-anchor\").addClass('jstree-search');\n            }\n            /**\n             * triggered after search is complete\n             * @event\n             * @name search.jstree\n             * @param {jQuery} nodes a jQuery collection of matching nodes\n             * @param {String} str the search string\n             * @param {Array} res a collection of objects represeing the matching nodes\n             * @plugin search\n             */\n            this.trigger('search', { nodes : this._data.search.dom, str : str, res : this._data.search.res, show_only_matches : show_only_matches });\n        };\n        /**\n         * used to clear the last search (removes classes and shows all nodes if filtering is on)\n         * @name clear_search()\n         * @plugin search\n         * @trigger clear_search.jstree\n         */\n        this.clear_search = function () {\n            if(this.settings.search.close_opened_onclear) {\n                this.close_node(this._data.search.opn, 0);\n            }\n            /**\n             * triggered after search is complete\n             * @event\n             * @name clear_search.jstree\n             * @param {jQuery} nodes a jQuery collection of matching nodes (the result from the last search)\n             * @param {String} str the search string (the last search string)\n             * @param {Array} res a collection of objects represeing the matching nodes (the result from the last search)\n             * @plugin search\n             */\n            this.trigger('clear_search', { 'nodes' : this._data.search.dom, str : this._data.search.str, res : this._data.search.res });\n            if(this._data.search.res.length) {\n                this._data.search.dom = $(this.element[0].querySelectorAll('#' + $.map(this._data.search.res, function (v) {\n                    return \"0123456789\".indexOf(v[0]) !== -1 ? '\\\\3' + v[0] + ' ' + v.substr(1).replace($.jstree.idregex,'\\\\$&') : v.replace($.jstree.idregex,'\\\\$&');\n                }).join(', #')));\n                this._data.search.dom.children(\".jstree-anchor\").removeClass(\"jstree-search\");\n            }\n            this._data.search.str = \"\";\n            this._data.search.res = [];\n            this._data.search.opn = [];\n            this._data.search.dom = $();\n        };\n\n        this.redraw_node = function(obj, deep, callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if(obj) {\n                if($.inArray(obj.id, this._data.search.res) !== -1) {\n                    var i, j, tmp = null;\n                    for(i = 0, j = obj.childNodes.length; i < j; i++) {\n                        if(obj.childNodes[i] && obj.childNodes[i].className && obj.childNodes[i].className.indexOf(\"jstree-anchor\") !== -1) {\n                            tmp = obj.childNodes[i];\n                            break;\n                        }\n                    }\n                    if(tmp) {\n                        tmp.className += ' jstree-search';\n                    }\n                }\n            }\n            return obj;\n        };\n    };\n\n    // helpers\n    (function ($) {\n        // from http://kiro.me/projects/fuse.html\n        $.vakata.search = function(pattern, txt, options) {\n            options = options || {};\n            options = $.extend({}, $.vakata.search.defaults, options);\n            if(options.fuzzy !== false) {\n                options.fuzzy = true;\n            }\n            pattern = options.caseSensitive ? pattern : pattern.toLowerCase();\n            var MATCH_LOCATION\t= options.location,\n                MATCH_DISTANCE\t= options.distance,\n                MATCH_THRESHOLD\t= options.threshold,\n                patternLen = pattern.length,\n                matchmask, pattern_alphabet, match_bitapScore, search;\n            if(patternLen > 32) {\n                options.fuzzy = false;\n            }\n            if(options.fuzzy) {\n                matchmask = 1 << (patternLen - 1);\n                pattern_alphabet = (function () {\n                    var mask = {},\n                        i = 0;\n                    for (i = 0; i < patternLen; i++) {\n                        mask[pattern.charAt(i)] = 0;\n                    }\n                    for (i = 0; i < patternLen; i++) {\n                        mask[pattern.charAt(i)] |= 1 << (patternLen - i - 1);\n                    }\n                    return mask;\n                }());\n                match_bitapScore = function (e, x) {\n                    var accuracy = e / patternLen,\n                        proximity = Math.abs(MATCH_LOCATION - x);\n                    if(!MATCH_DISTANCE) {\n                        return proximity ? 1.0 : accuracy;\n                    }\n                    return accuracy + (proximity / MATCH_DISTANCE);\n                };\n            }\n            search = function (text) {\n                text = options.caseSensitive ? text : text.toLowerCase();\n                if(pattern === text || text.indexOf(pattern) !== -1) {\n                    return {\n                        isMatch: true,\n                        score: 0\n                    };\n                }\n                if(!options.fuzzy) {\n                    return {\n                        isMatch: false,\n                        score: 1\n                    };\n                }\n                var i, j,\n                    textLen = text.length,\n                    scoreThreshold = MATCH_THRESHOLD,\n                    bestLoc = text.indexOf(pattern, MATCH_LOCATION),\n                    binMin, binMid,\n                    binMax = patternLen + textLen,\n                    lastRd, start, finish, rd, charMatch,\n                    score = 1,\n                    locations = [];\n                if (bestLoc !== -1) {\n                    scoreThreshold = Math.min(match_bitapScore(0, bestLoc), scoreThreshold);\n                    bestLoc = text.lastIndexOf(pattern, MATCH_LOCATION + patternLen);\n                    if (bestLoc !== -1) {\n                        scoreThreshold = Math.min(match_bitapScore(0, bestLoc), scoreThreshold);\n                    }\n                }\n                bestLoc = -1;\n                for (i = 0; i < patternLen; i++) {\n                    binMin = 0;\n                    binMid = binMax;\n                    while (binMin < binMid) {\n                        if (match_bitapScore(i, MATCH_LOCATION + binMid) <= scoreThreshold) {\n                            binMin = binMid;\n                        } else {\n                            binMax = binMid;\n                        }\n                        binMid = Math.floor((binMax - binMin) / 2 + binMin);\n                    }\n                    binMax = binMid;\n                    start = Math.max(1, MATCH_LOCATION - binMid + 1);\n                    finish = Math.min(MATCH_LOCATION + binMid, textLen) + patternLen;\n                    rd = new Array(finish + 2);\n                    rd[finish + 1] = (1 << i) - 1;\n                    for (j = finish; j >= start; j--) {\n                        charMatch = pattern_alphabet[text.charAt(j - 1)];\n                        if (i === 0) {\n                            rd[j] = ((rd[j + 1] << 1) | 1) & charMatch;\n                        } else {\n                            rd[j] = ((rd[j + 1] << 1) | 1) & charMatch | (((lastRd[j + 1] | lastRd[j]) << 1) | 1) | lastRd[j + 1];\n                        }\n                        if (rd[j] & matchmask) {\n                            score = match_bitapScore(i, j - 1);\n                            if (score <= scoreThreshold) {\n                                scoreThreshold = score;\n                                bestLoc = j - 1;\n                                locations.push(bestLoc);\n                                if (bestLoc > MATCH_LOCATION) {\n                                    start = Math.max(1, 2 * MATCH_LOCATION - bestLoc);\n                                } else {\n                                    break;\n                                }\n                            }\n                        }\n                    }\n                    if (match_bitapScore(i + 1, MATCH_LOCATION) > scoreThreshold) {\n                        break;\n                    }\n                    lastRd = rd;\n                }\n                return {\n                    isMatch: bestLoc >= 0,\n                    score: score\n                };\n            };\n            return txt === true ? { 'search' : search } : search(txt);\n        };\n        $.vakata.search.defaults = {\n            location : 0,\n            distance : 100,\n            threshold : 0.6,\n            fuzzy : false,\n            caseSensitive : false\n        };\n    }($));\n\n    // include the search plugin by default\n    // $.jstree.defaults.plugins.push(\"search\");\n\n\n    /**\n     * ### Sort plugin\n     *\n     * Automatically sorts all siblings in the tree according to a sorting function.\n     */\n\n    /**\n     * the settings function used to sort the nodes.\n     * It is executed in the tree's context, accepts two nodes as arguments and should return `1` or `-1`.\n     * @name $.jstree.defaults.sort\n     * @plugin sort\n     */\n    $.jstree.defaults.sort = function (a, b) {\n        //return this.get_type(a) === this.get_type(b) ? (this.get_text(a) > this.get_text(b) ? 1 : -1) : this.get_type(a) >= this.get_type(b);\n        return this.get_text(a) > this.get_text(b) ? 1 : -1;\n    };\n    $.jstree.plugins.sort = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n            this.element\n                .on(\"model.jstree\", function (e, data) {\n                    this.sort(data.parent, true);\n                }.bind(this))\n                .on(\"rename_node.jstree create_node.jstree\", function (e, data) {\n                    this.sort(data.parent || data.node.parent, false);\n                    this.redraw_node(data.parent || data.node.parent, true);\n                }.bind(this))\n                .on(\"move_node.jstree copy_node.jstree\", function (e, data) {\n                    this.sort(data.parent, false);\n                    this.redraw_node(data.parent, true);\n                }.bind(this));\n        };\n        /**\n         * used to sort a node's children\n         * @private\n         * @name sort(obj [, deep])\n         * @param  {mixed} obj the node\n         * @param {Boolean} deep if set to `true` nodes are sorted recursively.\n         * @plugin sort\n         * @trigger search.jstree\n         */\n        this.sort = function (obj, deep) {\n            var i, j;\n            obj = this.get_node(obj);\n            if(obj && obj.children && obj.children.length) {\n                obj.children.sort(this.settings.sort.bind(this));\n                if(deep) {\n                    for(i = 0, j = obj.children_d.length; i < j; i++) {\n                        this.sort(obj.children_d[i], false);\n                    }\n                }\n            }\n        };\n    };\n\n    // include the sort plugin by default\n    // $.jstree.defaults.plugins.push(\"sort\");\n\n    /**\n     * ### State plugin\n     *\n     * Saves the state of the tree (selected nodes, opened nodes) on the user's computer using available options (localStorage, cookies, etc)\n     */\n\n    var to = false;\n    /**\n     * stores all defaults for the state plugin\n     * @name $.jstree.defaults.state\n     * @plugin state\n     */\n    $.jstree.defaults.state = {\n        /**\n         * A string for the key to use when saving the current tree (change if using multiple trees in your project). Defaults to `jstree`.\n         * @name $.jstree.defaults.state.key\n         * @plugin state\n         */\n        key\t\t: 'jstree',\n        /**\n         * A space separated list of events that trigger a state save. Defaults to `changed.jstree open_node.jstree close_node.jstree`.\n         * @name $.jstree.defaults.state.events\n         * @plugin state\n         */\n        events\t: 'changed.jstree open_node.jstree close_node.jstree check_node.jstree uncheck_node.jstree',\n        /**\n         * Time in milliseconds after which the state will expire. Defaults to 'false' meaning - no expire.\n         * @name $.jstree.defaults.state.ttl\n         * @plugin state\n         */\n        ttl\t\t: false,\n        /**\n         * A function that will be executed prior to restoring state with one argument - the state object. Can be used to clear unwanted parts of the state.\n         * @name $.jstree.defaults.state.filter\n         * @plugin state\n         */\n        filter\t: false,\n        /**\n         * Should loaded nodes be restored (setting this to true means that it is possible that the whole tree will be loaded for some users - use with caution). Defaults to `false`\n         * @name $.jstree.defaults.state.preserve_loaded\n         * @plugin state\n         */\n        preserve_loaded : false\n    };\n    $.jstree.plugins.state = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n            var bind = function () {\n                this.element.on(this.settings.state.events, function () {\n                    if(to) { clearTimeout(to); }\n                    to = setTimeout(function () { this.save_state(); }.bind(this), 100);\n                }.bind(this));\n                /**\n                 * triggered when the state plugin is finished restoring the state (and immediately after ready if there is no state to restore).\n                 * @event\n                 * @name state_ready.jstree\n                 * @plugin state\n                 */\n                this.trigger('state_ready');\n            }.bind(this);\n            this.element\n                .on(\"ready.jstree\", function (e, data) {\n                    this.element.one(\"restore_state.jstree\", bind);\n                    if(!this.restore_state()) { bind(); }\n                }.bind(this));\n        };\n        /**\n         * save the state\n         * @name save_state()\n         * @plugin state\n         */\n        this.save_state = function () {\n            var tm = this.get_state();\n            if (!this.settings.state.preserve_loaded) {\n                delete tm.core.loaded;\n            }\n            var st = { 'state' : tm, 'ttl' : this.settings.state.ttl, 'sec' : +(new Date()) };\n            $.vakata.storage.set(this.settings.state.key, JSON.stringify(st));\n        };\n        /**\n         * restore the state from the user's computer\n         * @name restore_state()\n         * @plugin state\n         */\n        this.restore_state = function () {\n            var k = $.vakata.storage.get(this.settings.state.key);\n            if(!!k) { try { k = JSON.parse(k); } catch(ex) { return false; } }\n            if(!!k && k.ttl && k.sec && +(new Date()) - k.sec > k.ttl) { return false; }\n            if(!!k && k.state) { k = k.state; }\n            if(!!k && $.vakata.is_function(this.settings.state.filter)) { k = this.settings.state.filter.call(this, k); }\n            if(!!k) {\n                if (!this.settings.state.preserve_loaded) {\n                    delete k.core.loaded;\n                }\n                this.element.one(\"set_state.jstree\", function (e, data) { data.instance.trigger('restore_state', { 'state' : $.extend(true, {}, k) }); });\n                this.set_state(k);\n                return true;\n            }\n            return false;\n        };\n        /**\n         * clear the state on the user's computer\n         * @name clear_state()\n         * @plugin state\n         */\n        this.clear_state = function () {\n            return $.vakata.storage.del(this.settings.state.key);\n        };\n    };\n\n    (function ($, undefined) {\n        $.vakata.storage = {\n            // simply specifying the functions in FF throws an error\n            set : function (key, val) { return window.localStorage.setItem(key, val); },\n            get : function (key) { return window.localStorage.getItem(key); },\n            del : function (key) { return window.localStorage.removeItem(key); }\n        };\n    }($));\n\n    // include the state plugin by default\n    // $.jstree.defaults.plugins.push(\"state\");\n\n    /**\n     * ### Types plugin\n     *\n     * Makes it possible to add predefined types for groups of nodes, which make it possible to easily control nesting rules and icon for each group.\n     */\n\n    /**\n     * An object storing all types as key value pairs, where the key is the type name and the value is an object that could contain following keys (all optional).\n     *\n     * * `max_children` the maximum number of immediate children this node type can have. Do not specify or set to `-1` for unlimited.\n     * * `max_depth` the maximum number of nesting this node type can have. A value of `1` would mean that the node can have children, but no grandchildren. Do not specify or set to `-1` for unlimited.\n     * * `valid_children` an array of node type strings, that nodes of this type can have as children. Do not specify or set to `-1` for no limits.\n     * * `icon` a string - can be a path to an icon or a className, if using an image that is in the current directory use a `./` prefix, otherwise it will be detected as a class. Omit to use the default icon from your theme.\n     * * `li_attr` an object of values which will be used to add HTML attributes on the resulting LI DOM node (merged with the node's own data)\n     * * `a_attr` an object of values which will be used to add HTML attributes on the resulting A DOM node (merged with the node's own data)\n     *\n     * There are two predefined types:\n     *\n     * * `#` represents the root of the tree, for example `max_children` would control the maximum number of root nodes.\n     * * `default` represents the default node - any settings here will be applied to all nodes that do not have a type specified.\n     *\n     * @name $.jstree.defaults.types\n     * @plugin types\n     */\n    $.jstree.defaults.types = {\n        'default' : {}\n    };\n    $.jstree.defaults.types[$.jstree.root] = {};\n\n    $.jstree.plugins.types = function (options, parent) {\n        this.init = function (el, options) {\n            var i, j;\n            if(options && options.types && options.types['default']) {\n                for(i in options.types) {\n                    if(i !== \"default\" && i !== $.jstree.root && options.types.hasOwnProperty(i)) {\n                        for(j in options.types['default']) {\n                            if(options.types['default'].hasOwnProperty(j) && options.types[i][j] === undefined) {\n                                options.types[i][j] = options.types['default'][j];\n                            }\n                        }\n                    }\n                }\n            }\n            parent.init.call(this, el, options);\n            this._model.data[$.jstree.root].type = $.jstree.root;\n        };\n        this.refresh = function (skip_loading, forget_state) {\n            parent.refresh.call(this, skip_loading, forget_state);\n            this._model.data[$.jstree.root].type = $.jstree.root;\n        };\n        this.bind = function () {\n            this.element\n                .on('model.jstree', function (e, data) {\n                    var m = this._model.data,\n                        dpc = data.nodes,\n                        t = this.settings.types,\n                        i, j, c = 'default', k;\n                    for(i = 0, j = dpc.length; i < j; i++) {\n                        c = 'default';\n                        if(m[dpc[i]].original && m[dpc[i]].original.type && t[m[dpc[i]].original.type]) {\n                            c = m[dpc[i]].original.type;\n                        }\n                        if(m[dpc[i]].data && m[dpc[i]].data.jstree && m[dpc[i]].data.jstree.type && t[m[dpc[i]].data.jstree.type]) {\n                            c = m[dpc[i]].data.jstree.type;\n                        }\n                        m[dpc[i]].type = c;\n                        if(m[dpc[i]].icon === true && t[c].icon !== undefined) {\n                            m[dpc[i]].icon = t[c].icon;\n                        }\n                        if(t[c].li_attr !== undefined && typeof t[c].li_attr === 'object') {\n                            for (k in t[c].li_attr) {\n                                if (t[c].li_attr.hasOwnProperty(k)) {\n                                    if (k === 'id') {\n                                        continue;\n                                    }\n                                    else if (m[dpc[i]].li_attr[k] === undefined) {\n                                        m[dpc[i]].li_attr[k] = t[c].li_attr[k];\n                                    }\n                                    else if (k === 'class') {\n                                        m[dpc[i]].li_attr['class'] = t[c].li_attr['class'] + ' ' + m[dpc[i]].li_attr['class'];\n                                    }\n                                }\n                            }\n                        }\n                        if(t[c].a_attr !== undefined && typeof t[c].a_attr === 'object') {\n                            for (k in t[c].a_attr) {\n                                if (t[c].a_attr.hasOwnProperty(k)) {\n                                    if (k === 'id') {\n                                        continue;\n                                    }\n                                    else if (m[dpc[i]].a_attr[k] === undefined) {\n                                        m[dpc[i]].a_attr[k] = t[c].a_attr[k];\n                                    }\n                                    else if (k === 'href' && m[dpc[i]].a_attr[k] === '#') {\n                                        m[dpc[i]].a_attr['href'] = t[c].a_attr['href'];\n                                    }\n                                    else if (k === 'class') {\n                                        m[dpc[i]].a_attr['class'] = t[c].a_attr['class'] + ' ' + m[dpc[i]].a_attr['class'];\n                                    }\n                                }\n                            }\n                        }\n                    }\n                    m[$.jstree.root].type = $.jstree.root;\n                }.bind(this));\n            parent.bind.call(this);\n        };\n        this.get_json = function (obj, options, flat) {\n            var i, j,\n                m = this._model.data,\n                opt = options ? $.extend(true, {}, options, {no_id:false}) : {},\n                tmp = parent.get_json.call(this, obj, opt, flat);\n            if(tmp === false) { return false; }\n            if($.vakata.is_array(tmp)) {\n                for(i = 0, j = tmp.length; i < j; i++) {\n                    tmp[i].type = tmp[i].id && m[tmp[i].id] && m[tmp[i].id].type ? m[tmp[i].id].type : \"default\";\n                    if(options && options.no_id) {\n                        delete tmp[i].id;\n                        if(tmp[i].li_attr && tmp[i].li_attr.id) {\n                            delete tmp[i].li_attr.id;\n                        }\n                        if(tmp[i].a_attr && tmp[i].a_attr.id) {\n                            delete tmp[i].a_attr.id;\n                        }\n                    }\n                }\n            }\n            else {\n                tmp.type = tmp.id && m[tmp.id] && m[tmp.id].type ? m[tmp.id].type : \"default\";\n                if(options && options.no_id) {\n                    tmp = this._delete_ids(tmp);\n                }\n            }\n            return tmp;\n        };\n        this._delete_ids = function (tmp) {\n            if($.vakata.is_array(tmp)) {\n                for(var i = 0, j = tmp.length; i < j; i++) {\n                    tmp[i] = this._delete_ids(tmp[i]);\n                }\n                return tmp;\n            }\n            delete tmp.id;\n            if(tmp.li_attr && tmp.li_attr.id) {\n                delete tmp.li_attr.id;\n            }\n            if(tmp.a_attr && tmp.a_attr.id) {\n                delete tmp.a_attr.id;\n            }\n            if(tmp.children && $.vakata.is_array(tmp.children)) {\n                tmp.children = this._delete_ids(tmp.children);\n            }\n            return tmp;\n        };\n        this.check = function (chk, obj, par, pos, more) {\n            if(parent.check.call(this, chk, obj, par, pos, more) === false) { return false; }\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            par = par && par.id ? par : this.get_node(par);\n            var m = obj && obj.id ? (more && more.origin ? more.origin : $.jstree.reference(obj.id)) : null, tmp, d, i, j;\n            m = m && m._model && m._model.data ? m._model.data : null;\n            switch(chk) {\n                case \"create_node\":\n                case \"move_node\":\n                case \"copy_node\":\n                    if(chk !== 'move_node' || $.inArray(obj.id, par.children) === -1) {\n                        tmp = this.get_rules(par);\n                        if(tmp.max_children !== undefined && tmp.max_children !== -1 && tmp.max_children === par.children.length) {\n                            this._data.core.last_error = { 'error' : 'check', 'plugin' : 'types', 'id' : 'types_01', 'reason' : 'max_children prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                            return false;\n                        }\n                        if(tmp.valid_children !== undefined && tmp.valid_children !== -1 && $.inArray((obj.type || 'default'), tmp.valid_children) === -1) {\n                            this._data.core.last_error = { 'error' : 'check', 'plugin' : 'types', 'id' : 'types_02', 'reason' : 'valid_children prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                            return false;\n                        }\n                        if(m && obj.children_d && obj.parents) {\n                            d = 0;\n                            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                                d = Math.max(d, m[obj.children_d[i]].parents.length);\n                            }\n                            d = d - obj.parents.length + 1;\n                        }\n                        if(d <= 0 || d === undefined) { d = 1; }\n                        do {\n                            if(tmp.max_depth !== undefined && tmp.max_depth !== -1 && tmp.max_depth < d) {\n                                this._data.core.last_error = { 'error' : 'check', 'plugin' : 'types', 'id' : 'types_03', 'reason' : 'max_depth prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                                return false;\n                            }\n                            par = this.get_node(par.parent);\n                            tmp = this.get_rules(par);\n                            d++;\n                        } while(par);\n                    }\n                    break;\n            }\n            return true;\n        };\n        /**\n         * used to retrieve the type settings object for a node\n         * @name get_rules(obj)\n         * @param {mixed} obj the node to find the rules for\n         * @return {Object}\n         * @plugin types\n         */\n        this.get_rules = function (obj) {\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var tmp = this.get_type(obj, true);\n            if(tmp.max_depth === undefined) { tmp.max_depth = -1; }\n            if(tmp.max_children === undefined) { tmp.max_children = -1; }\n            if(tmp.valid_children === undefined) { tmp.valid_children = -1; }\n            return tmp;\n        };\n        /**\n         * used to retrieve the type string or settings object for a node\n         * @name get_type(obj [, rules])\n         * @param {mixed} obj the node to find the rules for\n         * @param {Boolean} rules if set to `true` instead of a string the settings object will be returned\n         * @return {String|Object}\n         * @plugin types\n         */\n        this.get_type = function (obj, rules) {\n            obj = this.get_node(obj);\n            return (!obj) ? false : ( rules ? $.extend({ 'type' : obj.type }, this.settings.types[obj.type]) : obj.type);\n        };\n        /**\n         * used to change a node's type\n         * @name set_type(obj, type)\n         * @param {mixed} obj the node to change\n         * @param {String} type the new type\n         * @plugin types\n         */\n        this.set_type = function (obj, type) {\n            var m = this._model.data, t, t1, t2, old_type, old_icon, k, d, a;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.set_type(obj[t1], type);\n                }\n                return true;\n            }\n            t = this.settings.types;\n            obj = this.get_node(obj);\n            if(!t[type] || !obj) { return false; }\n            d = this.get_node(obj, true);\n            if (d && d.length) {\n                a = d.children('.jstree-anchor');\n            }\n            old_type = obj.type;\n            old_icon = this.get_icon(obj);\n            obj.type = type;\n            if(old_icon === true || !t[old_type] || (t[old_type].icon !== undefined && old_icon === t[old_type].icon)) {\n                this.set_icon(obj, t[type].icon !== undefined ? t[type].icon : true);\n            }\n\n            // remove old type props\n            if(t[old_type] && t[old_type].li_attr !== undefined && typeof t[old_type].li_attr === 'object') {\n                for (k in t[old_type].li_attr) {\n                    if (t[old_type].li_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].li_attr['class'] = (m[obj.id].li_attr['class'] || '').replace(t[old_type].li_attr[k], '');\n                            if (d) { d.removeClass(t[old_type].li_attr[k]); }\n                        }\n                        else if (m[obj.id].li_attr[k] === t[old_type].li_attr[k]) {\n                            m[obj.id].li_attr[k] = null;\n                            if (d) { d.removeAttr(k); }\n                        }\n                    }\n                }\n            }\n            if(t[old_type] && t[old_type].a_attr !== undefined && typeof t[old_type].a_attr === 'object') {\n                for (k in t[old_type].a_attr) {\n                    if (t[old_type].a_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].a_attr['class'] = (m[obj.id].a_attr['class'] || '').replace(t[old_type].a_attr[k], '');\n                            if (a) { a.removeClass(t[old_type].a_attr[k]); }\n                        }\n                        else if (m[obj.id].a_attr[k] === t[old_type].a_attr[k]) {\n                            if (k === 'href') {\n                                m[obj.id].a_attr[k] = '#';\n                                if (a) { a.attr('href', '#'); }\n                            }\n                            else {\n                                delete m[obj.id].a_attr[k];\n                                if (a) { a.removeAttr(k); }\n                            }\n                        }\n                    }\n                }\n            }\n\n            // add new props\n            if(t[type].li_attr !== undefined && typeof t[type].li_attr === 'object') {\n                for (k in t[type].li_attr) {\n                    if (t[type].li_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (m[obj.id].li_attr[k] === undefined) {\n                            m[obj.id].li_attr[k] = t[type].li_attr[k];\n                            if (d) {\n                                if (k === 'class') {\n                                    d.addClass(t[type].li_attr[k]);\n                                }\n                                else {\n                                    d.attr(k, t[type].li_attr[k]);\n                                }\n                            }\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].li_attr['class'] = t[type].li_attr[k] + ' ' + m[obj.id].li_attr['class'];\n                            if (d) { d.addClass(t[type].li_attr[k]); }\n                        }\n                    }\n                }\n            }\n            if(t[type].a_attr !== undefined && typeof t[type].a_attr === 'object') {\n                for (k in t[type].a_attr) {\n                    if (t[type].a_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (m[obj.id].a_attr[k] === undefined) {\n                            m[obj.id].a_attr[k] = t[type].a_attr[k];\n                            if (a) {\n                                if (k === 'class') {\n                                    a.addClass(t[type].a_attr[k]);\n                                }\n                                else {\n                                    a.attr(k, t[type].a_attr[k]);\n                                }\n                            }\n                        }\n                        else if (k === 'href' && m[obj.id].a_attr[k] === '#') {\n                            m[obj.id].a_attr['href'] = t[type].a_attr['href'];\n                            if (a) { a.attr('href', t[type].a_attr['href']); }\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].a_attr['class'] = t[type].a_attr['class'] + ' ' + m[obj.id].a_attr['class'];\n                            if (a) { a.addClass(t[type].a_attr[k]); }\n                        }\n                    }\n                }\n            }\n\n            return true;\n        };\n    };\n    // include the types plugin by default\n    // $.jstree.defaults.plugins.push(\"types\");\n\n\n    /**\n     * ### Unique plugin\n     *\n     * Enforces that no nodes with the same name can coexist as siblings.\n     */\n\n    /**\n     * stores all defaults for the unique plugin\n     * @name $.jstree.defaults.unique\n     * @plugin unique\n     */\n    $.jstree.defaults.unique = {\n        /**\n         * Indicates if the comparison should be case sensitive. Default is `false`.\n         * @name $.jstree.defaults.unique.case_sensitive\n         * @plugin unique\n         */\n        case_sensitive : false,\n        /**\n         * Indicates if white space should be trimmed before the comparison. Default is `false`.\n         * @name $.jstree.defaults.unique.trim_whitespace\n         * @plugin unique\n         */\n        trim_whitespace : false,\n        /**\n         * A callback executed in the instance's scope when a new node is created and the name is already taken, the two arguments are the conflicting name and the counter. The default will produce results like `New node (2)`.\n         * @name $.jstree.defaults.unique.duplicate\n         * @plugin unique\n         */\n        duplicate : function (name, counter) {\n            return name + ' (' + counter + ')';\n        }\n    };\n\n    $.jstree.plugins.unique = function (options, parent) {\n        this.check = function (chk, obj, par, pos, more) {\n            if(parent.check.call(this, chk, obj, par, pos, more) === false) { return false; }\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            par = par && par.id ? par : this.get_node(par);\n            if(!par || !par.children) { return true; }\n            var n = chk === \"rename_node\" ? pos : obj.text,\n                c = [],\n                s = this.settings.unique.case_sensitive,\n                w = this.settings.unique.trim_whitespace,\n                m = this._model.data, i, j, t;\n            for(i = 0, j = par.children.length; i < j; i++) {\n                t = m[par.children[i]].text;\n                if (!s) {\n                    t = t.toLowerCase();\n                }\n                if (w) {\n                    t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                }\n                c.push(t);\n            }\n            if(!s) { n = n.toLowerCase(); }\n            if (w) { n = n.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, ''); }\n            switch(chk) {\n                case \"delete_node\":\n                    return true;\n                case \"rename_node\":\n                    t = obj.text || '';\n                    if (!s) {\n                        t = t.toLowerCase();\n                    }\n                    if (w) {\n                        t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                    }\n                    i = ($.inArray(n, c) === -1 || (obj.text && t === n));\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_01', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    }\n                    return i;\n                case \"create_node\":\n                    i = ($.inArray(n, c) === -1);\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_04', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    }\n                    return i;\n                case \"copy_node\":\n                    i = ($.inArray(n, c) === -1);\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_02', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    }\n                    return i;\n                case \"move_node\":\n                    i = ( (obj.parent === par.id && (!more || !more.is_multi)) || $.inArray(n, c) === -1);\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_03', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    }\n                    return i;\n            }\n            return true;\n        };\n        this.create_node = function (par, node, pos, callback, is_loaded) {\n            if(!node || node.text === undefined) {\n                if(par === null) {\n                    par = $.jstree.root;\n                }\n                par = this.get_node(par);\n                if(!par) {\n                    return parent.create_node.call(this, par, node, pos, callback, is_loaded);\n                }\n                pos = pos === undefined ? \"last\" : pos;\n                if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                    return parent.create_node.call(this, par, node, pos, callback, is_loaded);\n                }\n                if(!node) { node = {}; }\n                var tmp, n, dpc, i, j, m = this._model.data, s = this.settings.unique.case_sensitive, w = this.settings.unique.trim_whitespace, cb = this.settings.unique.duplicate, t;\n                n = tmp = this.get_string('New node');\n                dpc = [];\n                for(i = 0, j = par.children.length; i < j; i++) {\n                    t = m[par.children[i]].text;\n                    if (!s) {\n                        t = t.toLowerCase();\n                    }\n                    if (w) {\n                        t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                    }\n                    dpc.push(t);\n                }\n                i = 1;\n                t = n;\n                if (!s) {\n                    t = t.toLowerCase();\n                }\n                if (w) {\n                    t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                }\n                while($.inArray(t, dpc) !== -1) {\n                    n = cb.call(this, tmp, (++i)).toString();\n                    t = n;\n                    if (!s) {\n                        t = t.toLowerCase();\n                    }\n                    if (w) {\n                        t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                    }\n                }\n                node.text = n;\n            }\n            return parent.create_node.call(this, par, node, pos, callback, is_loaded);\n        };\n    };\n\n    // include the unique plugin by default\n    // $.jstree.defaults.plugins.push(\"unique\");\n\n\n    /**\n     * ### Wholerow plugin\n     *\n     * Makes each node appear block level. Making selection easier. May cause slow down for large trees in old browsers.\n     */\n\n    var div = document.createElement('DIV');\n    div.setAttribute('unselectable','on');\n    div.setAttribute('role','presentation');\n    div.className = 'jstree-wholerow';\n    div.innerHTML = '&#160;';\n    $.jstree.plugins.wholerow = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n\n            this.element\n                .on('ready.jstree set_state.jstree', function () {\n                    this.hide_dots();\n                }.bind(this))\n                .on(\"init.jstree loading.jstree ready.jstree\", function () {\n                    //div.style.height = this._data.core.li_height + 'px';\n                    this.get_container_ul().addClass('jstree-wholerow-ul');\n                }.bind(this))\n                .on(\"deselect_all.jstree\", function (e, data) {\n                    this.element.find('.jstree-wholerow-clicked').removeClass('jstree-wholerow-clicked');\n                }.bind(this))\n                .on(\"changed.jstree\", function (e, data) {\n                    this.element.find('.jstree-wholerow-clicked').removeClass('jstree-wholerow-clicked');\n                    var tmp = false, i, j;\n                    for(i = 0, j = data.selected.length; i < j; i++) {\n                        tmp = this.get_node(data.selected[i], true);\n                        if(tmp && tmp.length) {\n                            tmp.children('.jstree-wholerow').addClass('jstree-wholerow-clicked');\n                        }\n                    }\n                }.bind(this))\n                .on(\"open_node.jstree\", function (e, data) {\n                    this.get_node(data.node, true).find('.jstree-clicked').parent().children('.jstree-wholerow').addClass('jstree-wholerow-clicked');\n                }.bind(this))\n                .on(\"hover_node.jstree dehover_node.jstree\", function (e, data) {\n                    if(e.type === \"hover_node\" && this.is_disabled(data.node)) { return; }\n                    this.get_node(data.node, true).children('.jstree-wholerow')[e.type === \"hover_node\"?\"addClass\":\"removeClass\"]('jstree-wholerow-hovered');\n                }.bind(this))\n                .on(\"contextmenu.jstree\", \".jstree-wholerow\", function (e) {\n                    if (this._data.contextmenu) {\n                        e.preventDefault();\n                        var tmp = $.Event('contextmenu', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey, pageX : e.pageX, pageY : e.pageY });\n                        $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp);\n                    }\n                }.bind(this))\n                /*!\n\t\t\t\t.on(\"mousedown.jstree touchstart.jstree\", \".jstree-wholerow\", function (e) {\n\t\t\t\t\t\tif(e.target === e.currentTarget) {\n\t\t\t\t\t\t\tvar a = $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\");\n\t\t\t\t\t\t\te.target = a[0];\n\t\t\t\t\t\t\ta.trigger(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t})\n\t\t\t\t*/\n                .on(\"click.jstree\", \".jstree-wholerow\", function (e) {\n                    e.stopImmediatePropagation();\n                    var tmp = $.Event('click', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey });\n                    $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp).trigger('focus');\n                })\n                .on(\"dblclick.jstree\", \".jstree-wholerow\", function (e) {\n                    e.stopImmediatePropagation();\n                    var tmp = $.Event('dblclick', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey });\n                    $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp).trigger('focus');\n                })\n                .on(\"click.jstree\", \".jstree-leaf > .jstree-ocl\", function (e) {\n                    e.stopImmediatePropagation();\n                    var tmp = $.Event('click', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey });\n                    $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp).trigger('focus');\n                }.bind(this))\n                .on(\"mouseover.jstree\", \".jstree-wholerow, .jstree-icon\", function (e) {\n                    e.stopImmediatePropagation();\n                    if(!this.is_disabled(e.currentTarget)) {\n                        this.hover_node(e.currentTarget);\n                    }\n                    return false;\n                }.bind(this))\n                .on(\"mouseleave.jstree\", \".jstree-node\", function (e) {\n                    this.dehover_node(e.currentTarget);\n                }.bind(this));\n        };\n        this.teardown = function () {\n            if(this.settings.wholerow) {\n                this.element.find(\".jstree-wholerow\").remove();\n            }\n            parent.teardown.call(this);\n        };\n        this.redraw_node = function(obj, deep, callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if(obj) {\n                var tmp = div.cloneNode(true);\n                //tmp.style.height = this._data.core.li_height + 'px';\n                if($.inArray(obj.id, this._data.core.selected) !== -1) { tmp.className += ' jstree-wholerow-clicked'; }\n                if(this._data.core.focused && this._data.core.focused === obj.id) { tmp.className += ' jstree-wholerow-hovered'; }\n                obj.insertBefore(tmp, obj.childNodes[0]);\n            }\n            return obj;\n        };\n    };\n    // include the wholerow plugin by default\n    // $.jstree.defaults.plugins.push(\"wholerow\");\n    if(window.customElements && Object && Object.create) {\n        var proto = Object.create(HTMLElement.prototype);\n        proto.createdCallback = function () {\n            var c = { core : {}, plugins : [] }, i;\n            for(i in $.jstree.plugins) {\n                if($.jstree.plugins.hasOwnProperty(i) && this.attributes[i]) {\n                    c.plugins.push(i);\n                    if(this.getAttribute(i) && JSON.parse(this.getAttribute(i))) {\n                        c[i] = JSON.parse(this.getAttribute(i));\n                    }\n                }\n            }\n            for(i in $.jstree.defaults.core) {\n                if($.jstree.defaults.core.hasOwnProperty(i) && this.attributes[i]) {\n                    c.core[i] = JSON.parse(this.getAttribute(i)) || this.getAttribute(i);\n                }\n            }\n            $(this).jstree(c);\n        };\n        // proto.attributeChangedCallback = function (name, previous, value) { };\n        try {\n            window.customElements.define(\"vakata-jstree\", function() {}, { prototype: proto });\n        } catch (ignore) { }\n    }\n\n}));\n","Magento_CurrencySymbol/js/symbols-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element)\n            .mage('form')\n            .mage('validation');\n\n        /**\n         * Toggle the field to use the default value\n         *\n         * @param {String} code\n         * @param {String} value\n         */\n        function toggleUseDefault(code, value) {\n            var checkbox = $('#custom_currency_symbol_inherit' + code),\n                input = $('#custom_currency_symbol' + code);\n\n            if (checkbox.is(':checked')) {\n                input.val(value);\n                input.prop('disabled', true);\n            } else {\n                input.prop('disabled', false);\n            }\n        }\n\n        window.toggleUseDefault = toggleUseDefault;\n    };\n});\n","Magento_Eav/js/input-types.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    return function (config) {\n        $('select#frontend_input').each(function () {\n            var select = $(this),\n                currentValue = select.find('option:selected').val(),\n                compatibleTypes = config.inputTypes,\n                enabledTypes = [],\n                iterator,\n                warning = $('<label>')\n                    .hide()\n                    .text($.mage.__('These changes affect all related products.'))\n                    .addClass('mage-error')\n                    .attr({\n                        generated: true, for: select.attr('id')\n                    }),\n                hint = $('<p>')\n                    .hide()\n                    .addClass('note')\n                    .attr({\n                        generated: true\n                    }),\n                hints = config.hints,\n\n            /**\n             * Toggle hint about changes types\n             */\n            toggleWarning = function () {\n                if (select.find('option:selected').val() === currentValue) {\n                    warning.hide();\n                } else {\n                    warning.show();\n                }\n            },\n\n            /**\n             * Toggle hint\n             */\n            toggleHint = function () {\n                if (typeof hints[select.find('option:selected').val()] !== 'undefined') {\n                    select.after(hint.show().text(hints[select.find('option:selected').val()]));\n                } else {\n                    hint.hide();\n                }\n            },\n\n            /**\n             * Remove unsupported options\n             */\n            removeOption = function () {\n                if (!~enabledTypes.indexOf($(this).val())) {\n                    $(this).remove();\n                }\n            };\n\n            // find enabled types for switching dor current input type\n            for (iterator = 0; iterator < compatibleTypes.length; iterator++) {\n                if (compatibleTypes[iterator].indexOf(currentValue) >= 0) {\n                    enabledTypes = compatibleTypes[iterator];\n                }\n            }\n\n            // Check current type (allow only compatible types)\n            if (~enabledTypes.indexOf(currentValue)) {\n                // Enable select and keep only available options (all other will be removed)\n                select.prop('disabled', false).find('option').each(removeOption);\n                // Add warning on page and event for show/hide it\n                select.after(warning).on('change', toggleWarning);\n            }\n            //bind hint toggling on change event\n            select.on('change', toggleHint);\n            //show hint for currently selected value\n            toggleHint();\n        });\n    };\n});\n","vimeo/player.min.js":"/*! @vimeo/player v2.16.4 | (c) 2022 Vimeo | MIT License | https://github.com/vimeo/player.js */\n!function(e,t){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=t():\"function\"==typeof define&&define.amd?define(t):((e=\"undefined\"!=typeof globalThis?globalThis:e||self).Vimeo=e.Vimeo||{},e.Vimeo.Player=t())}(this,function(){\"use strict\";function r(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,\"value\"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var e=\"undefined\"!=typeof global&&\"[object global]\"==={}.toString.call(global);function i(e,t){return 0===e.indexOf(t.toLowerCase())?e:\"\".concat(t.toLowerCase()).concat(e.substr(0,1).toUpperCase()).concat(e.substr(1))}function l(e){return/^(https?:)?\\/\\/((player|www)\\.)?vimeo\\.com(?=$|\\/)/.test(e)}function u(e){var t=0<arguments.length&&void 0!==e?e:{},n=t.id,e=t.url,t=n||e;if(!t)throw new Error(\"An id or url must be passed, either in an options object or as a data-vimeo-id or data-vimeo-url attribute.\");if(e=t,!isNaN(parseFloat(e))&&isFinite(e)&&Math.floor(e)==e)return\"https://vimeo.com/\".concat(t);if(l(t))return t.replace(\"http:\",\"https:\");if(n)throw new TypeError(\"\u201c\".concat(n,\"\u201d is not a valid video id.\"));throw new TypeError(\"\u201c\".concat(t,\"\u201d is not a vimeo.com url.\"))}var t=void 0!==Array.prototype.indexOf,Player=\"undefined\"!=typeof window&&void 0!==window.postMessage;if(!(e||t&&Player))throw new Error(\"Sorry, the Vimeo Player API is not available in this browser.\");var n,o,a=\"undefined\"!=typeof globalThis?globalThis:\"undefined\"!=typeof window?window:\"undefined\"!=typeof global?global:\"undefined\"!=typeof self?self:{};function c(){if(void 0===this)throw new TypeError(\"Constructor WeakMap requires 'new'\");if(o(this,\"_id\",\"_WeakMap_\"+f()+\".\"+f()),0<arguments.length)throw new TypeError(\"WeakMap iterable is not supported\")}function s(e,t){if(!d(e)||!n.call(e,\"_id\"))throw new TypeError(t+\" method called on incompatible receiver \"+typeof e)}function f(){return Math.random().toString().substring(2)}function d(e){return Object(e)===e}(Player=\"undefined\"!=typeof self?self:\"undefined\"!=typeof window?window:a).WeakMap||(n=Object.prototype.hasOwnProperty,Player.WeakMap=((o=function(e,t,n){Object.defineProperty?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:n}):e[t]=n})(c.prototype,\"delete\",function(e){if(s(this,\"delete\"),!d(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)&&(delete e[this._id],!0)}),o(c.prototype,\"get\",function(e){if(s(this,\"get\"),d(e)){var t=e[this._id];return t&&t[0]===e?t[1]:void 0}}),o(c.prototype,\"has\",function(e){if(s(this,\"has\"),!d(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)}),o(c.prototype,\"set\",function(e,t){if(s(this,\"set\"),!d(e))throw new TypeError(\"Invalid value used as weak map key\");var n=e[this._id];return n&&n[0]===e?n[1]=t:o(e,this._id,[e,t]),this}),o(c,\"_polyfill\",!0),c));var h,m=(function(e){var t,n,r;r=function(){var t,n,r,o,i,e=Object.prototype.toString,a=\"undefined\"!=typeof setImmediate?function(e){return setImmediate(e)}:setTimeout;try{Object.defineProperty({},\"x\",{}),t=function(e,t,n,r){return Object.defineProperty(e,t,{value:n,writable:!0,configurable:!1!==r})}}catch(e){t=function(e,t,n){return e[t]=n,e}}function u(e,t){this.fn=e,this.self=t,this.next=void 0}function l(e,t){y.add(e,t),n=n||a(y.drain)}function c(e){var t,n=typeof e;return\"function\"==typeof(t=null!=e&&(\"object\"==n||\"function\"==n)?e.then:t)&&t}function s(){for(var e=0;e<this.chain.length;e++)!function(e,t,n){var r,o;try{!1===t?n.reject(e.msg):(r=!0===t?e.msg:t.call(void 0,e.msg))===n.promise?n.reject(TypeError(\"Promise-chain cycle\")):(o=c(r))?o.call(r,n.resolve,n.reject):n.resolve(r)}catch(e){n.reject(e)}}(this,1===this.state?this.chain[e].success:this.chain[e].failure,this.chain[e]);this.chain.length=0}function f(e){var n,r=this;if(!r.triggered){r.triggered=!0,r.def&&(r=r.def);try{(n=c(e))?l(function(){var t=new m(r);try{n.call(e,function(){f.apply(t,arguments)},function(){d.apply(t,arguments)})}catch(e){d.call(t,e)}}):(r.msg=e,r.state=1,0<r.chain.length&&l(s,r))}catch(e){d.call(new m(r),e)}}}function d(e){var t=this;t.triggered||(t.triggered=!0,(t=t.def?t.def:t).msg=e,t.state=2,0<t.chain.length&&l(s,t))}function h(e,n,r,o){for(var t=0;t<n.length;t++)!function(t){e.resolve(n[t]).then(function(e){r(t,e)},o)}(t)}function m(e){this.def=e,this.triggered=!1}function v(e){this.promise=e,this.state=0,this.triggered=!1,this.chain=[],this.msg=void 0}function p(e){if(\"function\"!=typeof e)throw TypeError(\"Not a function\");if(0!==this.__NPO__)throw TypeError(\"Not a promise\");this.__NPO__=1;var r=new v(this);this.then=function(e,t){var n={success:\"function\"!=typeof e||e,failure:\"function\"==typeof t&&t};return n.promise=new this.constructor(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");n.resolve=e,n.reject=t}),r.chain.push(n),0!==r.state&&l(s,r),n.promise},this.catch=function(e){return this.then(void 0,e)};try{e.call(void 0,function(e){f.call(r,e)},function(e){d.call(r,e)})}catch(e){d.call(r,e)}}var y={add:function(e,t){i=new u(e,t),o?o.next=i:r=i,o=i,i=void 0},drain:function(){var e=r;for(r=o=n=void 0;e;)e.fn.call(e.self),e=e.next}},g=t({},\"constructor\",p,!1);return t(p.prototype=g,\"__NPO__\",0,!1),t(p,\"resolve\",function(n){return n&&\"object\"==typeof n&&1===n.__NPO__?n:new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");e(n)})}),t(p,\"reject\",function(n){return new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");t(n)})}),t(p,\"all\",function(t){var a=this;return\"[object Array]\"!=e.call(t)?a.reject(TypeError(\"Not an array\")):0===t.length?a.resolve([]):new a(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");var r=t.length,o=Array(r),i=0;h(a,t,function(e,t){o[e]=t,++i===r&&n(o)},e)})}),t(p,\"race\",function(t){var r=this;return\"[object Array]\"!=e.call(t)?r.reject(TypeError(\"Not an array\")):new r(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");h(r,t,function(e,t){n(t)},e)})}),p},(n=a)[t=\"Promise\"]=n[t]||r(),e.exports&&(e.exports=n[t])}(h={exports:{}}),h.exports),v=new WeakMap;function p(e,t,n){var r=v.get(e.element)||{};t in r||(r[t]=[]),r[t].push(n),v.set(e.element,r)}function y(e,t){return(v.get(e.element)||{})[t]||[]}function g(e,t,n){var r=v.get(e.element)||{};if(!r[t])return!0;if(!n)return r[t]=[],v.set(e.element,r),!0;n=r[t].indexOf(n);return-1!==n&&r[t].splice(n,1),v.set(e.element,r),r[t]&&0===r[t].length}var w=[\"autopause\",\"autoplay\",\"background\",\"byline\",\"color\",\"controls\",\"dnt\",\"height\",\"id\",\"interactive_params\",\"keyboard\",\"loop\",\"maxheight\",\"maxwidth\",\"muted\",\"playsinline\",\"portrait\",\"responsive\",\"speed\",\"texttrack\",\"title\",\"transparent\",\"url\",\"width\"];function b(r,e){return w.reduce(function(e,t){var n=r.getAttribute(\"data-vimeo-\".concat(t));return!n&&\"\"!==n||(e[t]=\"\"===n?1:n),e},1<arguments.length&&void 0!==e?e:{})}function k(e,t){var n=e.html;if(!t)throw new TypeError(\"An element must be provided\");if(null!==t.getAttribute(\"data-vimeo-initialized\"))return t.querySelector(\"iframe\");e=document.createElement(\"div\");return e.innerHTML=n,t.appendChild(e.firstChild),t.setAttribute(\"data-vimeo-initialized\",\"true\"),t.querySelector(\"iframe\")}function E(i,e,t){var a=1<arguments.length&&void 0!==e?e:{},u=2<arguments.length?t:void 0;return new Promise(function(t,n){if(!l(i))throw new TypeError(\"\u201c\".concat(i,\"\u201d is not a vimeo.com url.\"));var e,r=\"https://vimeo.com/api/oembed.json?url=\".concat(encodeURIComponent(i));for(e in a)a.hasOwnProperty(e)&&(r+=\"&\".concat(e,\"=\").concat(encodeURIComponent(a[e])));var o=new(\"XDomainRequest\"in window?XDomainRequest:XMLHttpRequest);o.open(\"GET\",r,!0),o.onload=function(){if(404!==o.status)if(403!==o.status)try{var e=JSON.parse(o.responseText);if(403===e.domain_status_code)return k(e,u),void n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));t(e)}catch(e){n(e)}else n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));else n(new Error(\"\u201c\".concat(i,\"\u201d was not found.\")))},o.onerror=function(){var e=o.status?\" (\".concat(o.status,\")\"):\"\";n(new Error(\"There was an error fetching the embed code from Vimeo\".concat(e,\".\")))},o.send()})}function T(e){function n(e){\"console\"in window&&console.error&&console.error(\"There was an error creating an embed: \".concat(e))}e=0<arguments.length&&void 0!==e?e:document,e=[].slice.call(e.querySelectorAll(\"[data-vimeo-id], [data-vimeo-url]\"));e.forEach(function(t){try{if(null!==t.getAttribute(\"data-vimeo-defer\"))return;var e=b(t);E(u(e),e,t).then(function(e){return k(e,t)}).catch(n)}catch(e){n(e)}})}function P(e){if(\"string\"==typeof e)try{e=JSON.parse(e)}catch(e){return console.warn(e),{}}return e}function _(e,t,n){e.element.contentWindow&&e.element.contentWindow.postMessage&&(t={method:t},void 0!==n&&(t.value=n),8<=(n=parseFloat(navigator.userAgent.toLowerCase().replace(/^.*msie (\\d+).*$/,\"$1\")))&&n<10&&(t=JSON.stringify(t)),e.element.contentWindow.postMessage(t,e.origin))}function M(n,r){var t,e,o,i,a=[];(r=P(r)).event?(\"error\"===r.event&&y(n,r.data.method).forEach(function(e){var t=new Error(r.data.message);t.name=r.data.name,e.reject(t),g(n,r.data.method,e)}),a=y(n,\"event:\".concat(r.event)),t=r.data):r.method&&(e=n,o=r.method,(i=!((i=y(e,o)).length<1)&&(i=i.shift(),g(e,o,i),i))&&(a.push(i),t=r.value)),a.forEach(function(e){try{if(\"function\"==typeof e)return void e.call(n,t);e.resolve(t)}catch(e){}})}var N,F,x,C=new WeakMap,j=new WeakMap,A={},Player=function(){function Player(i){var e,a=this,t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(!function(e,t){if(!(e instanceof t))throw new TypeError(\"Cannot call a class as a function\")}(this,Player),window.jQuery&&i instanceof jQuery&&(1<i.length&&window.console&&console.warn&&console.warn(\"A jQuery object with multiple elements was passed, using the first element.\"),i=i[0]),\"undefined\"!=typeof document&&\"string\"==typeof i&&(i=document.getElementById(i)),e=i,!Boolean(e&&1===e.nodeType&&\"nodeName\"in e&&e.ownerDocument&&e.ownerDocument.defaultView))throw new TypeError(\"You must pass either a valid element or a valid id.\");if(\"IFRAME\"===i.nodeName||(r=i.querySelector(\"iframe\"))&&(i=r),\"IFRAME\"===i.nodeName&&!l(i.getAttribute(\"src\")||\"\"))throw new Error(\"The player element passed isn\u2019t a Vimeo embed.\");if(C.has(i))return C.get(i);this._window=i.ownerDocument.defaultView,this.element=i,this.origin=\"*\";var n,r=new m(function(r,o){var e;a._onMessage=function(e){if(l(e.origin)&&a.element.contentWindow===e.source){\"*\"===a.origin&&(a.origin=e.origin);var t=P(e.data);if(t&&\"error\"===t.event&&t.data&&\"ready\"===t.data.method){var n=new Error(t.data.message);return n.name=t.data.name,void o(n)}e=t&&\"ready\"===t.event,n=t&&\"ping\"===t.method;if(e||n)return a.element.setAttribute(\"data-ready\",\"true\"),void r();M(a,t)}},a._window.addEventListener(\"message\",a._onMessage),\"IFRAME\"!==a.element.nodeName&&E(u(e=b(i,t)),e,i).then(function(e){var t,n,r=k(e,i);return a.element=r,a._originalElement=i,t=i,n=r,r=v.get(t),v.set(n,r),v.delete(t),C.set(a.element,a),e}).catch(o)});return j.set(this,r),C.set(this.element,this),\"IFRAME\"===this.element.nodeName&&_(this,\"ping\"),A.isEnabled&&(n=function(){return A.exit()},this.fullscreenchangeHandler=function(){(A.isFullscreen?p:g)(a,\"event:exitFullscreen\",n),a.ready().then(function(){_(a,\"fullscreenchange\",A.isFullscreen)})},A.on(\"fullscreenchange\",this.fullscreenchangeHandler)),this}var e,t,n;return e=Player,(t=[{key:\"callMethod\",value:function(n){var r=this,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};return new m(function(e,t){return r.ready().then(function(){p(r,n,{resolve:e,reject:t}),_(r,n,o)}).catch(t)})}},{key:\"get\",value:function(n){var r=this;return new m(function(e,t){return n=i(n,\"get\"),r.ready().then(function(){p(r,n,{resolve:e,reject:t}),_(r,n)}).catch(t)})}},{key:\"set\",value:function(n,r){var o=this;return new m(function(e,t){if(n=i(n,\"set\"),null==r)throw new TypeError(\"There must be a value to set.\");return o.ready().then(function(){p(o,n,{resolve:e,reject:t}),_(o,n,r)}).catch(t)})}},{key:\"on\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(!t)throw new TypeError(\"You must pass a callback function.\");if(\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");0===y(this,\"event:\".concat(e)).length&&this.callMethod(\"addEventListener\",e).catch(function(){}),p(this,\"event:\".concat(e),t)}},{key:\"off\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(t&&\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");g(this,\"event:\".concat(e),t)&&this.callMethod(\"removeEventListener\",e).catch(function(e){})}},{key:\"loadVideo\",value:function(e){return this.callMethod(\"loadVideo\",e)}},{key:\"ready\",value:function(){var e=j.get(this)||new m(function(e,t){t(new Error(\"Unknown player. Probably unloaded.\"))});return m.resolve(e)}},{key:\"addCuePoint\",value:function(e){return this.callMethod(\"addCuePoint\",{time:e,data:1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}})}},{key:\"removeCuePoint\",value:function(e){return this.callMethod(\"removeCuePoint\",e)}},{key:\"enableTextTrack\",value:function(e,t){if(!e)throw new TypeError(\"You must pass a language.\");return this.callMethod(\"enableTextTrack\",{language:e,kind:t})}},{key:\"disableTextTrack\",value:function(){return this.callMethod(\"disableTextTrack\")}},{key:\"pause\",value:function(){return this.callMethod(\"pause\")}},{key:\"play\",value:function(){return this.callMethod(\"play\")}},{key:\"requestFullscreen\",value:function(){return A.isEnabled?A.request(this.element):this.callMethod(\"requestFullscreen\")}},{key:\"exitFullscreen\",value:function(){return A.isEnabled?A.exit():this.callMethod(\"exitFullscreen\")}},{key:\"getFullscreen\",value:function(){return A.isEnabled?m.resolve(A.isFullscreen):this.get(\"fullscreen\")}},{key:\"requestPictureInPicture\",value:function(){return this.callMethod(\"requestPictureInPicture\")}},{key:\"exitPictureInPicture\",value:function(){return this.callMethod(\"exitPictureInPicture\")}},{key:\"getPictureInPicture\",value:function(){return this.get(\"pictureInPicture\")}},{key:\"unload\",value:function(){return this.callMethod(\"unload\")}},{key:\"destroy\",value:function(){var n=this;return new m(function(e){var t;j.delete(n),C.delete(n.element),n._originalElement&&(C.delete(n._originalElement),n._originalElement.removeAttribute(\"data-vimeo-initialized\")),n.element&&\"IFRAME\"===n.element.nodeName&&n.element.parentNode&&(n.element.parentNode.parentNode&&n._originalElement&&n._originalElement!==n.element.parentNode?n.element.parentNode.parentNode.removeChild(n.element.parentNode):n.element.parentNode.removeChild(n.element)),n.element&&\"DIV\"===n.element.nodeName&&n.element.parentNode&&(n.element.removeAttribute(\"data-vimeo-initialized\"),(t=n.element.querySelector(\"iframe\"))&&t.parentNode&&(t.parentNode.parentNode&&n._originalElement&&n._originalElement!==t.parentNode?t.parentNode.parentNode.removeChild(t.parentNode):t.parentNode.removeChild(t))),n._window.removeEventListener(\"message\",n._onMessage),A.isEnabled&&A.off(\"fullscreenchange\",n.fullscreenchangeHandler),e()})}},{key:\"getAutopause\",value:function(){return this.get(\"autopause\")}},{key:\"setAutopause\",value:function(e){return this.set(\"autopause\",e)}},{key:\"getBuffered\",value:function(){return this.get(\"buffered\")}},{key:\"getCameraProps\",value:function(){return this.get(\"cameraProps\")}},{key:\"setCameraProps\",value:function(e){return this.set(\"cameraProps\",e)}},{key:\"getChapters\",value:function(){return this.get(\"chapters\")}},{key:\"getCurrentChapter\",value:function(){return this.get(\"currentChapter\")}},{key:\"getColor\",value:function(){return this.get(\"color\")}},{key:\"setColor\",value:function(e){return this.set(\"color\",e)}},{key:\"getCuePoints\",value:function(){return this.get(\"cuePoints\")}},{key:\"getCurrentTime\",value:function(){return this.get(\"currentTime\")}},{key:\"setCurrentTime\",value:function(e){return this.set(\"currentTime\",e)}},{key:\"getDuration\",value:function(){return this.get(\"duration\")}},{key:\"getEnded\",value:function(){return this.get(\"ended\")}},{key:\"getLoop\",value:function(){return this.get(\"loop\")}},{key:\"setLoop\",value:function(e){return this.set(\"loop\",e)}},{key:\"setMuted\",value:function(e){return this.set(\"muted\",e)}},{key:\"getMuted\",value:function(){return this.get(\"muted\")}},{key:\"getPaused\",value:function(){return this.get(\"paused\")}},{key:\"getPlaybackRate\",value:function(){return this.get(\"playbackRate\")}},{key:\"setPlaybackRate\",value:function(e){return this.set(\"playbackRate\",e)}},{key:\"getPlayed\",value:function(){return this.get(\"played\")}},{key:\"getQualities\",value:function(){return this.get(\"qualities\")}},{key:\"getQuality\",value:function(){return this.get(\"quality\")}},{key:\"setQuality\",value:function(e){return this.set(\"quality\",e)}},{key:\"getSeekable\",value:function(){return this.get(\"seekable\")}},{key:\"getSeeking\",value:function(){return this.get(\"seeking\")}},{key:\"getTextTracks\",value:function(){return this.get(\"textTracks\")}},{key:\"getVideoEmbedCode\",value:function(){return this.get(\"videoEmbedCode\")}},{key:\"getVideoId\",value:function(){return this.get(\"videoId\")}},{key:\"getVideoTitle\",value:function(){return this.get(\"videoTitle\")}},{key:\"getVideoWidth\",value:function(){return this.get(\"videoWidth\")}},{key:\"getVideoHeight\",value:function(){return this.get(\"videoHeight\")}},{key:\"getVideoUrl\",value:function(){return this.get(\"videoUrl\")}},{key:\"getVolume\",value:function(){return this.get(\"volume\")}},{key:\"setVolume\",value:function(e){return this.set(\"volume\",e)}}])&&r(e.prototype,t),n&&r(e,n),Player}();return e||(N=function(){for(var e,t=[[\"requestFullscreen\",\"exitFullscreen\",\"fullscreenElement\",\"fullscreenEnabled\",\"fullscreenchange\",\"fullscreenerror\"],[\"webkitRequestFullscreen\",\"webkitExitFullscreen\",\"webkitFullscreenElement\",\"webkitFullscreenEnabled\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"webkitRequestFullScreen\",\"webkitCancelFullScreen\",\"webkitCurrentFullScreenElement\",\"webkitCancelFullScreen\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"mozRequestFullScreen\",\"mozCancelFullScreen\",\"mozFullScreenElement\",\"mozFullScreenEnabled\",\"mozfullscreenchange\",\"mozfullscreenerror\"],[\"msRequestFullscreen\",\"msExitFullscreen\",\"msFullscreenElement\",\"msFullscreenEnabled\",\"MSFullscreenChange\",\"MSFullscreenError\"]],n=0,r=t.length,o={};n<r;n++)if((e=t[n])&&e[1]in document){for(n=0;n<e.length;n++)o[t[0][n]]=e[n];return o}return!1}(),F={fullscreenchange:N.fullscreenchange,fullscreenerror:N.fullscreenerror},x={request:function(o){return new Promise(function(e,t){function n(){x.off(\"fullscreenchange\",n),e()}x.on(\"fullscreenchange\",n);var r=(o=o||document.documentElement)[N.requestFullscreen]();r instanceof Promise&&r.then(n).catch(t)})},exit:function(){return new Promise(function(t,e){var n,r;x.isFullscreen?(n=function e(){x.off(\"fullscreenchange\",e),t()},x.on(\"fullscreenchange\",n),(r=document[N.exitFullscreen]())instanceof Promise&&r.then(n).catch(e)):t()})},on:function(e,t){e=F[e];e&&document.addEventListener(e,t)},off:function(e,t){e=F[e];e&&document.removeEventListener(e,t)}},Object.defineProperties(x,{isFullscreen:{get:function(){return Boolean(document[N.fullscreenElement])}},element:{enumerable:!0,get:function(){return document[N.fullscreenElement]}},isEnabled:{enumerable:!0,get:function(){return Boolean(document[N.fullscreenEnabled])}}}),A=x,T(),function(e){var r=0<arguments.length&&void 0!==e?e:document;window.VimeoPlayerResizeEmbeds_||(window.VimeoPlayerResizeEmbeds_=!0,window.addEventListener(\"message\",function(e){if(l(e.origin)&&e.data&&\"spacechange\"===e.data.event)for(var t=r.querySelectorAll(\"iframe\"),n=0;n<t.length;n++)if(t[n].contentWindow===e.source){t[n].parentElement.style.paddingBottom=\"\".concat(e.data.data[0].bottom,\"px\");break}}))}()),Player});\n","vimeo/vimeo-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'vimeo'\n], function (Player) {\n    'use strict';\n\n    window.Vimeo = window.Vimeo || {\n        'Player': Player\n    };\n});\n","knockoutjs/knockout-repeat.js":"// REPEAT binding for Knockout http://knockoutjs.com/\n// (c) Michael Best\n// License: MIT (http://www.opensource.org/licenses/mit-license.php)\n// Version 2.1.0\n\n(function(factory) {\n    if (typeof define === 'function' && define.amd) {\n        // [1] AMD anonymous module\n        define(['knockout'], factory);\n    } else if (typeof exports === 'object') {\n        // [2] commonJS\n        factory(require('knockout'));\n    } else {\n        // [3] No module loader (plain <script> tag) - put directly in global namespace\n        factory(window.ko);\n    }\n})(function(ko) {\n\nif (!ko.virtualElements)\n    throw Error('Repeat requires at least Knockout 2.1');\n\nvar ko_bindingFlags = ko.bindingFlags || {};\nvar ko_unwrap = ko.utils.unwrapObservable;\n\nvar koProtoName = '__ko_proto__';\n\nif (ko.version >= \"3.0.0\") {\n    // In Knockout 3.0.0, use the node preprocessor to replace a node with a repeat binding with a virtual element\n    var provider = ko.bindingProvider.instance, previousPreprocessFn = provider.preprocessNode;\n    provider.preprocessNode = function(node) {\n        var newNodes, nodeBinding;\n        if (!previousPreprocessFn || !(newNodes = previousPreprocessFn.call(this, node))) {\n            if (node.nodeType === 1 && (nodeBinding = node.getAttribute('data-bind'))) {\n                if (/^\\s*repeat\\s*:/.test(nodeBinding)) {\n                    var leadingComment = node.ownerDocument.createComment('ko ' + nodeBinding),\n                        trailingComment = node.ownerDocument.createComment('/ko');\n                    node.parentNode.insertBefore(leadingComment, node);\n                    node.parentNode.insertBefore(trailingComment, node.nextSibling);\n                    node.removeAttribute('data-bind');\n                    newNodes = [leadingComment, node, trailingComment];\n                }\n            }\n        }\n        return newNodes;\n    };\n}\n\nko.virtualElements.allowedBindings.repeat = true;\nko.bindingHandlers.repeat = {\n    flags: ko_bindingFlags.contentBind | ko_bindingFlags.canUseVirtual,\n    init: function(element, valueAccessor, allBindingsAccessor, xxx, bindingContext) {\n\n        // Read and set fixed options--these options cannot be changed\n        var repeatParam = ko_unwrap(valueAccessor());\n        if (repeatParam && typeof repeatParam == 'object' && !('length' in repeatParam)) {\n            var repeatIndex = repeatParam.index,\n                repeatData = repeatParam.item,\n                repeatStep = repeatParam.step,\n                repeatReversed = repeatParam.reverse,\n                repeatBind = repeatParam.bind,\n                repeatInit = repeatParam.init,\n                repeatUpdate = repeatParam.update;\n        }\n        // Set default values for options that need it\n        repeatIndex = repeatIndex || '$index';\n        repeatData = repeatData || ko.bindingHandlers.repeat.itemName || '$item';\n        repeatStep = repeatStep || 1;\n        repeatReversed = repeatReversed || false;\n\n        var parent = element.parentNode, placeholder;\n        if (element.nodeType == 8) {    // virtual element\n            // Extract the \"children\" and find the single element node\n            var childNodes = ko.utils.arrayFilter(ko.virtualElements.childNodes(element), function(node) { return node.nodeType == 1;});\n            if (childNodes.length !== 1) {\n                throw Error(\"Repeat binding requires a single element to repeat\");\n            }\n            ko.virtualElements.emptyNode(element);\n\n            // The placeholder is the closing comment normally, or the opening comment if reversed\n            placeholder = repeatReversed ? element : element.nextSibling;\n            // The element to repeat is the contained element\n            element = childNodes[0];\n        } else {    // regular element\n            // First clean the element node and remove node's binding\n            var origBindString = element.getAttribute('data-bind');\n            ko.cleanNode(element);\n            element.removeAttribute('data-bind');\n\n            // Original element is no longer needed: delete it and create a placeholder comment\n            placeholder = element.ownerDocument.createComment('ko_repeatplaceholder ' + origBindString);\n            parent.replaceChild(placeholder, element);\n        }\n\n        // extract and remove a data-repeat-bind attribute, if present\n        if (!repeatBind) {\n            repeatBind = element.getAttribute('data-repeat-bind');\n            if (repeatBind) {\n                element.removeAttribute('data-repeat-bind');\n            }\n        }\n\n        // Make a copy of the element node to be copied for each repetition\n        var cleanNode = element.cloneNode(true);\n        if (typeof repeatBind == \"string\") {\n            cleanNode.setAttribute('data-bind', repeatBind);\n            repeatBind = null;\n        }\n\n        // Set up persistent data\n        var lastRepeatCount = 0,\n            notificationObservable = ko.observable(),\n            repeatArray, arrayObservable;\n\n        if (repeatInit) {\n            repeatInit(parent);\n        }\n\n        var subscribable = ko.computed(function() {\n            function makeArrayItemAccessor(index) {\n                var f = function(newValue) {\n                    var item = repeatArray[index];\n                    // Reading the value of the item\n                    if (!arguments.length) {\n                        notificationObservable();   // for dependency tracking\n                        return ko_unwrap(item);\n                    }\n                    // Writing a value to the item\n                    if (ko.isObservable(item)) {\n                        item(newValue);\n                    } else if (arrayObservable && arrayObservable.splice) {\n                        arrayObservable.splice(index, 1, newValue);\n                    } else {\n                        repeatArray[index] = newValue;\n                    }\n                    return this;\n                };\n                // Pretend that our accessor function is an observable\n                f[koProtoName] = ko.observable;\n                return f;\n            }\n\n            function makeBinding(item, index, context) {\n                return repeatArray\n                    ? function() { return repeatBind.call(bindingContext.$data, item, index, context); }\n                    : function() { return repeatBind.call(bindingContext.$data, index, context); }\n            }\n\n            // Read and set up variable options--these options can change and will update the binding\n            var paramObservable = valueAccessor(), repeatParam = ko_unwrap(paramObservable), repeatCount = 0;\n            if (repeatParam && typeof repeatParam == 'object') {\n                if ('length' in repeatParam) {\n                    repeatArray = repeatParam;\n                    repeatCount = repeatArray.length;\n                } else {\n                    if ('foreach' in repeatParam) {\n                        repeatArray = ko_unwrap(paramObservable = repeatParam.foreach);\n                        if (repeatArray && typeof repeatArray == 'object' && 'length' in repeatArray) {\n                            repeatCount = repeatArray.length || 0;\n                        } else {\n                            repeatCount = repeatArray || 0;\n                            repeatArray = null;\n                        }\n                    }\n                    // If a count value is provided (>0), always output that number of items\n                    if ('count' in repeatParam)\n                        repeatCount = ko_unwrap(repeatParam.count) || repeatCount;\n                    // If a limit is provided, don't output more than the limit\n                    if ('limit' in repeatParam)\n                        repeatCount = Math.min(repeatCount, ko_unwrap(repeatParam.limit)) || repeatCount;\n                }\n                arrayObservable = repeatArray && ko.isObservable(paramObservable) ? paramObservable : null;\n            } else {\n                repeatCount = repeatParam || 0;\n            }\n\n            // Remove nodes from end if array is shorter\n            for (; lastRepeatCount > repeatCount; lastRepeatCount-=repeatStep) {\n                ko.removeNode(repeatReversed ? placeholder.nextSibling : placeholder.previousSibling);\n            }\n\n            // Notify existing nodes of change\n            notificationObservable.notifySubscribers();\n\n            // Add nodes to end if array is longer (also initially populates nodes)\n            for (; lastRepeatCount < repeatCount; lastRepeatCount+=repeatStep) {\n                // Clone node and add to document\n                var newNode = cleanNode.cloneNode(true);\n                parent.insertBefore(newNode, repeatReversed ? placeholder.nextSibling : placeholder);\n                newNode.setAttribute('data-repeat-index', lastRepeatCount);\n\n                // Apply bindings to inserted node\n                if (repeatArray && repeatData == '$data') {\n                    var newContext = bindingContext.createChildContext(makeArrayItemAccessor(lastRepeatCount));\n                } else {\n                    var newContext = bindingContext.extend();\n                    if (repeatArray)\n                        newContext[repeatData] = makeArrayItemAccessor(lastRepeatCount);\n                }\n                newContext[repeatIndex] = lastRepeatCount;\n                if (repeatBind) {\n                    var result = ko.applyBindingsToNode(newNode, makeBinding(newContext[repeatData], lastRepeatCount, newContext), newContext, true),\n                        shouldBindDescendants = result && result.shouldBindDescendants;\n                }\n                if (!repeatBind || (result && shouldBindDescendants !== false)) {\n                    ko.applyBindings(newContext, newNode);\n                }\n            }\n            if (repeatUpdate) {\n                repeatUpdate(parent);\n            }\n        }, null, {disposeWhenNodeIsRemoved: placeholder});\n\n        return { controlsDescendantBindings: true, subscribable: subscribable };\n    }\n};\n});","knockoutjs/knockout-es5.js":"/*!\n * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5\n * Copyright (c) Steve Sanderson\n * MIT license\n */\n\n(function(global, undefined) {\n  'use strict';\n\n  var ko;\n\n  // Model tracking\n  // --------------\n  //\n  // This is the central feature of Knockout-ES5. We augment model objects by converting properties\n  // into ES5 getter/setter pairs that read/write an underlying Knockout observable. This means you can\n  // use plain JavaScript syntax to read/write the property while still getting the full benefits of\n  // Knockout's automatic dependency detection and notification triggering.\n  //\n  // For comparison, here's Knockout ES3-compatible syntax:\n  //\n  //     var firstNameLength = myModel.user().firstName().length; // Read\n  //     myModel.user().firstName('Bert'); // Write\n  //\n  // ... versus Knockout-ES5 syntax:\n  //\n  //     var firstNameLength = myModel.user.firstName.length; // Read\n  //     myModel.user.firstName = 'Bert'; // Write\n\n  // `ko.track(model)` converts each property on the given model object into a getter/setter pair that\n  // wraps a Knockout observable. Optionally specify an array of property names to wrap; otherwise we\n  // wrap all properties. If any of the properties are already observables, we replace them with\n  // ES5 getter/setter pairs that wrap your original observable instances. In the case of readonly\n  // ko.computed properties, we simply do not define a setter (so attempted writes will be ignored,\n  // which is how ES5 readonly properties normally behave).\n  //\n  // By design, this does *not* recursively walk child object properties, because making literally\n  // everything everywhere independently observable is usually unhelpful. When you do want to track\n  // child object properties independently, define your own class for those child objects and put\n  // a separate ko.track call into its constructor --- this gives you far more control.\n  /**\n   * @param {object} obj\n   * @param {object|array.<string>} propertyNamesOrSettings\n   * @param {boolean} propertyNamesOrSettings.deep Use deep track.\n   * @param {array.<string>} propertyNamesOrSettings.fields Array of property names to wrap.\n   * todo: @param {array.<string>} propertyNamesOrSettings.exclude Array of exclude property names to wrap.\n   * todo: @param {function(string, *):boolean} propertyNamesOrSettings.filter Function to filter property \n   *   names to wrap. A function that takes ... params\n   * @return {object}\n   */\n  function track(obj, propertyNamesOrSettings) {\n    if (!obj || typeof obj !== 'object') {\n      throw new Error('When calling ko.track, you must pass an object as the first parameter.');\n    }\n\n    var propertyNames;\n\n    if ( isPlainObject(propertyNamesOrSettings) ) {\n      // defaults\n      propertyNamesOrSettings.deep = propertyNamesOrSettings.deep || false;\n      propertyNamesOrSettings.fields = propertyNamesOrSettings.fields || Object.getOwnPropertyNames(obj);\n      propertyNamesOrSettings.lazy = propertyNamesOrSettings.lazy || false;\n\n      wrap(obj, propertyNamesOrSettings.fields, propertyNamesOrSettings);\n    } else {\n      propertyNames = propertyNamesOrSettings || Object.getOwnPropertyNames(obj);\n      wrap(obj, propertyNames, {});\n    }\n\n    return obj;\n  }\n\n  // fix for ie\n  var rFunctionName = /^function\\s*([^\\s(]+)/;\n  function getFunctionName( ctor ){\n    if (ctor.name) {\n      return ctor.name;\n    }\n    return (ctor.toString().trim().match( rFunctionName ) || [])[1];\n  }\n\n  function canTrack(obj) {\n    return obj && typeof obj === 'object' && getFunctionName(obj.constructor) === 'Object';\n  }\n\n  function createPropertyDescriptor(originalValue, prop, map) {\n    var isObservable = ko.isObservable(originalValue);\n    var isArray = !isObservable && Array.isArray(originalValue);\n    var observable = isObservable ? originalValue\n        : isArray ? ko.observableArray(originalValue)\n        : ko.observable(originalValue);\n\n    map[prop] = function () { return observable; };\n\n    // add check in case the object is already an observable array\n    if (isArray || (isObservable && 'push' in observable)) {\n      notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n    }\n\n    return {\n      configurable: true,\n      enumerable: true,\n      get: observable,\n      set: ko.isWriteableObservable(observable) ? observable : undefined\n    };\n  }\n\n  function createLazyPropertyDescriptor(originalValue, prop, map) {\n    if (ko.isObservable(originalValue)) {\n      // no need to be lazy if we already have an observable\n      return createPropertyDescriptor(originalValue, prop, map);\n    }\n\n    var observable;\n\n    function getOrCreateObservable(value, writing) {\n      if (observable) {\n        return writing ? observable(value) : observable;\n      }\n\n      if (Array.isArray(value)) {\n        observable = ko.observableArray(value);\n        notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n        return observable;\n      }\n\n      return (observable = ko.observable(value));\n    }\n\n    map[prop] = function () { return getOrCreateObservable(originalValue); };\n    return {\n      configurable: true,\n      enumerable: true,\n      get: function () { return getOrCreateObservable(originalValue)(); },\n      set: function (value) { getOrCreateObservable(value, true); }\n    };\n  }\n\n  function wrap(obj, props, options) {\n    if (!props.length) {\n      return;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, true);\n    var descriptors = {};\n\n    props.forEach(function (prop) {\n      // Skip properties that are already tracked\n      if (prop in allObservablesForObject) {\n        return;\n      }\n\n      // Skip properties where descriptor can't be redefined\n      if (Object.getOwnPropertyDescriptor(obj, prop).configurable === false){\n        return;\n      }\n\n      var originalValue = obj[prop];\n      descriptors[prop] = (options.lazy ? createLazyPropertyDescriptor : createPropertyDescriptor)\n        (originalValue, prop, allObservablesForObject);\n\n      if (options.deep && canTrack(originalValue)) {\n        wrap(originalValue, Object.keys(originalValue), options);\n      }\n    });\n\n    Object.defineProperties(obj, descriptors);\n  }\n\n  function isPlainObject( obj ){\n    return !!obj && typeof obj === 'object' && obj.constructor === Object;\n  }\n\n  // Lazily created by `getAllObservablesForObject` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var objectToObservableMap;\n\n  // Gets or creates the hidden internal key-value collection of observables corresponding to\n  // properties on the model object.\n  function getAllObservablesForObject(obj, createIfNotDefined) {\n    if (!objectToObservableMap) {\n      objectToObservableMap = weakMapFactory();\n    }\n\n    var result = objectToObservableMap.get(obj);\n    if (!result && createIfNotDefined) {\n      result = {};\n      objectToObservableMap.set(obj, result);\n    }\n    return result;\n  }\n\n  // Removes the internal references to observables mapped to the specified properties\n  // or the entire object reference if no properties are passed in. This allows the\n  // observables to be replaced and tracked again.\n  function untrack(obj, propertyNames) {\n    if (!objectToObservableMap) {\n      return;\n    }\n\n    if (arguments.length === 1) {\n      objectToObservableMap['delete'](obj);\n    } else {\n      var allObservablesForObject = getAllObservablesForObject(obj, false);\n      if (allObservablesForObject) {\n        propertyNames.forEach(function(propertyName) {\n          delete allObservablesForObject[propertyName];\n        });\n      }\n    }\n  }\n\n  // Computed properties\n  // -------------------\n  //\n  // The preceding code is already sufficient to upgrade ko.computed model properties to ES5\n  // getter/setter pairs (or in the case of readonly ko.computed properties, just a getter).\n  // These then behave like a regular property with a getter function, except they are smarter:\n  // your evaluator is only invoked when one of its dependencies changes. The result is cached\n  // and used for all evaluations until the next time a dependency changes).\n  //\n  // However, instead of forcing developers to declare a ko.computed property explicitly, it's\n  // nice to offer a utility function that declares a computed getter directly.\n\n  // Implements `ko.defineProperty`\n  function defineComputedProperty(obj, propertyName, evaluatorOrOptions) {\n    var ko = this,\n      computedOptions = { owner: obj, deferEvaluation: true };\n\n    if (typeof evaluatorOrOptions === 'function') {\n      computedOptions.read = evaluatorOrOptions;\n    } else {\n      if ('value' in evaluatorOrOptions) {\n        throw new Error('For ko.defineProperty, you must not specify a \"value\" for the property. ' +\n                        'You must provide a \"get\" function.');\n      }\n\n      if (typeof evaluatorOrOptions.get !== 'function') {\n        throw new Error('For ko.defineProperty, the third parameter must be either an evaluator function, ' +\n                        'or an options object containing a function called \"get\".');\n      }\n\n      computedOptions.read = evaluatorOrOptions.get;\n      computedOptions.write = evaluatorOrOptions.set;\n    }\n\n    obj[propertyName] = ko.computed(computedOptions);\n    track.call(ko, obj, [propertyName]);\n    return obj;\n  }\n\n  // Array handling\n  // --------------\n  //\n  // Arrays are special, because unlike other property types, they have standard mutator functions\n  // (`push`/`pop`/`splice`/etc.) and it's desirable to trigger a change notification whenever one of\n  // those mutator functions is invoked.\n  //\n  // Traditionally, Knockout handles this by putting special versions of `push`/`pop`/etc. on observable\n  // arrays that mutate the underlying array and then trigger a notification. That approach doesn't\n  // work for Knockout-ES5 because properties now return the underlying arrays, so the mutator runs\n  // in the context of the underlying array, not any particular observable:\n  //\n  //     // Operates on the underlying array value\n  //     myModel.someCollection.push('New value');\n  //\n  // To solve this, Knockout-ES5 detects array values, and modifies them as follows:\n  //  1. Associates a hidden subscribable with each array instance that it encounters\n  //  2. Intercepts standard mutators (`push`/`pop`/etc.) and makes them trigger the subscribable\n  // Then, for model properties whose values are arrays, the property's underlying observable\n  // subscribes to the array subscribable, so it can trigger a change notification after mutation.\n\n  // Given an observable that underlies a model property, watch for any array value that might\n  // be assigned as the property value, and hook into its change events\n  function notifyWhenPresentOrFutureArrayValuesMutate(ko, observable) {\n    var watchingArraySubscription = null;\n    ko.computed(function () {\n      // Unsubscribe to any earlier array instance\n      if (watchingArraySubscription) {\n        watchingArraySubscription.dispose();\n        watchingArraySubscription = null;\n      }\n\n      // Subscribe to the new array instance\n      var newArrayInstance = observable();\n      if (newArrayInstance instanceof Array) {\n        watchingArraySubscription = startWatchingArrayInstance(ko, observable, newArrayInstance);\n      }\n    });\n  }\n\n  // Listens for array mutations, and when they happen, cause the observable to fire notifications.\n  // This is used to make model properties of type array fire notifications when the array changes.\n  // Returns a subscribable that can later be disposed.\n  function startWatchingArrayInstance(ko, observable, arrayInstance) {\n    var subscribable = getSubscribableForArray(ko, arrayInstance);\n    return subscribable.subscribe(observable);\n  }\n\n  // Lazily created by `getSubscribableForArray` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var arraySubscribablesMap;\n\n  // Gets or creates a subscribable that fires after each array mutation\n  function getSubscribableForArray(ko, arrayInstance) {\n    if (!arraySubscribablesMap) {\n      arraySubscribablesMap = weakMapFactory();\n    }\n\n    var subscribable = arraySubscribablesMap.get(arrayInstance);\n    if (!subscribable) {\n      subscribable = new ko.subscribable();\n      arraySubscribablesMap.set(arrayInstance, subscribable);\n\n      var notificationPauseSignal = {};\n      wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal);\n      addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal);\n    }\n\n    return subscribable;\n  }\n\n  // After each array mutation, fires a notification on the given subscribable\n  function wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal) {\n    ['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'].forEach(function(fnName) {\n      var origMutator = arrayInstance[fnName];\n      arrayInstance[fnName] = function() {\n        var result = origMutator.apply(this, arguments);\n        if (notificationPauseSignal.pause !== true) {\n          subscribable.notifySubscribers(this);\n        }\n        return result;\n      };\n    });\n  }\n\n  // Adds Knockout's additional array mutation functions to the array\n  function addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal) {\n    ['remove', 'removeAll', 'destroy', 'destroyAll', 'replace'].forEach(function(fnName) {\n      // Make it a non-enumerable property for consistency with standard Array functions\n      Object.defineProperty(arrayInstance, fnName, {\n        enumerable: false,\n        value: function() {\n          var result;\n\n          // These additional array mutators are built using the underlying push/pop/etc.\n          // mutators, which are wrapped to trigger notifications. But we don't want to\n          // trigger multiple notifications, so pause the push/pop/etc. wrappers and\n          // delivery only one notification at the end of the process.\n          notificationPauseSignal.pause = true;\n          try {\n            // Creates a temporary observableArray that can perform the operation.\n            result = ko.observableArray.fn[fnName].apply(ko.observableArray(arrayInstance), arguments);\n          }\n          finally {\n            notificationPauseSignal.pause = false;\n          }\n          subscribable.notifySubscribers(arrayInstance);\n          return result;\n        }\n      });\n    });\n  }\n\n  // Static utility functions\n  // ------------------------\n  //\n  // Since Knockout-ES5 sets up properties that return values, not observables, you can't\n  // trivially subscribe to the underlying observables (e.g., `someProperty.subscribe(...)`),\n  // or tell them that object values have mutated, etc. To handle this, we set up some\n  // extra utility functions that can return or work with the underlying observables.\n\n  // Returns the underlying observable associated with a model property (or `null` if the\n  // model or property doesn't exist, or isn't associated with an observable). This means\n  // you can subscribe to the property, e.g.:\n  //\n  //     ko.getObservable(model, 'propertyName')\n  //       .subscribe(function(newValue) { ... });\n  function getObservable(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return null;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    if (allObservablesForObject && propertyName in allObservablesForObject) {\n      return allObservablesForObject[propertyName]();\n    }\n\n    return null;\n  }\n  \n  // Returns a boolean indicating whether the property on the object has an underlying\n  // observables. This does the check in a way not to create an observable if the\n  // object was created with lazily created observables\n  function isTracked(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return false;\n    }\n    \n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    return !!allObservablesForObject && propertyName in allObservablesForObject;\n  }\n\n  // Causes a property's associated observable to fire a change notification. Useful when\n  // the property value is a complex object and you've modified a child property.\n  function valueHasMutated(obj, propertyName) {\n    var observable = getObservable(obj, propertyName);\n\n    if (observable) {\n      observable.valueHasMutated();\n    }\n  }\n\n  // Module initialisation\n  // ---------------------\n  //\n  // When this script is first evaluated, it works out what kind of module loading scenario\n  // it is in (Node.js or a browser `<script>` tag), stashes a reference to its dependencies\n  // (currently that's just the WeakMap shim), and then finally attaches itself to whichever\n  // instance of Knockout.js it can find.\n\n  // A function that returns a new ES6-compatible WeakMap instance (using ES5 shim if needed).\n  // Instantiate