require.config({"config": {
        "jsbuild":{"knockoutjs/knockout.js":"/*!\n * Knockout JavaScript library v3.5.1\n * (c) The Knockout.js team - http://knockoutjs.com/\n * License: MIT (http://www.opensource.org/licenses/mit-license.php)\n */\n\n(function(){\n    var DEBUG=true;\n    (function(undefined){\n        // (0, eval)('this') is a robust way of getting a reference to the global object\n        // For details, see http://stackoverflow.com/questions/14119988/return-this-0-evalthis/14120023#14120023\n        var window = this || (0, eval)('this'),\n            document = window['document'],\n            navigator = window['navigator'],\n            jQueryInstance = window[\"jQuery\"],\n            JSON = window[\"JSON\"];\n\n        if (!jQueryInstance && typeof jQuery !== \"undefined\") {\n            jQueryInstance = jQuery;\n        }\n        (function(factory) {\n            // Support three module loading scenarios\n            if (typeof define === 'function' && define['amd']) {\n                // [1] AMD anonymous module\n                define(['exports', 'require'], factory);\n            } else if (typeof exports === 'object' && typeof module === 'object') {\n                // [2] CommonJS/Node.js\n                factory(module['exports'] || exports);  // module.exports is for Node.js\n            } else {\n                // [3] No module loader (plain <script> tag) - put directly in global namespace\n                factory(window['ko'] = {});\n            }\n        }(function(koExports, amdRequire){\n// Internally, all KO objects are attached to koExports (even the non-exported ones whose names will be minified by the closure compiler).\n// In the future, the following \"ko\" variable may be made distinct from \"koExports\" so that private objects are not externally reachable.\n            var ko = typeof koExports !== 'undefined' ? koExports : {};\n// Google Closure Compiler helpers (used only to make the minified file smaller)\n            ko.exportSymbol = function(koPath, object) {\n                var tokens = koPath.split(\".\");\n\n                // In the future, \"ko\" may become distinct from \"koExports\" (so that non-exported objects are not reachable)\n                // At that point, \"target\" would be set to: (typeof koExports !== \"undefined\" ? koExports : ko)\n                var target = ko;\n\n                for (var i = 0; i < tokens.length - 1; i++)\n                    target = target[tokens[i]];\n                target[tokens[tokens.length - 1]] = object;\n            };\n            ko.exportProperty = function(owner, publicName, object) {\n                owner[publicName] = object;\n            };\n            ko.version = \"3.5.1\";\n\n            ko.exportSymbol('version', ko.version);\n// For any options that may affect various areas of Knockout and aren't directly associated with data binding.\n            ko.options = {\n                'deferUpdates': false,\n                'useOnlyNativeEvents': false,\n                'foreachHidesDestroyed': false\n            };\n\n//ko.exportSymbol('options', ko.options);   // 'options' isn't minified\n            ko.utils = (function () {\n                var hasOwnProperty = Object.prototype.hasOwnProperty;\n\n                function objectForEach(obj, action) {\n                    for (var prop in obj) {\n                        if (hasOwnProperty.call(obj, prop)) {\n                            action(prop, obj[prop]);\n                        }\n                    }\n                }\n\n                function extend(target, source) {\n                    if (source) {\n                        for(var prop in source) {\n                            if(hasOwnProperty.call(source, prop)) {\n                                target[prop] = source[prop];\n                            }\n                        }\n                    }\n                    return target;\n                }\n\n                function setPrototypeOf(obj, proto) {\n                    obj.__proto__ = proto;\n                    return obj;\n                }\n\n                var canSetPrototype = ({ __proto__: [] } instanceof Array);\n                var canUseSymbols = !DEBUG && typeof Symbol === 'function';\n\n                // Represent the known event types in a compact way, then at runtime transform it into a hash with event name as key (for fast lookup)\n                var knownEvents = {}, knownEventTypesByEventName = {};\n                var keyEventTypeName = (navigator && /Firefox\\/2/i.test(navigator.userAgent)) ? 'KeyboardEvent' : 'UIEvents';\n                knownEvents[keyEventTypeName] = ['keyup', 'keydown', 'keypress'];\n                knownEvents['MouseEvents'] = ['click', 'dblclick', 'mousedown', 'mouseup', 'mousemove', 'mouseover', 'mouseout', 'mouseenter', 'mouseleave'];\n                objectForEach(knownEvents, function(eventType, knownEventsForType) {\n                    if (knownEventsForType.length) {\n                        for (var i = 0, j = knownEventsForType.length; i < j; i++)\n                            knownEventTypesByEventName[knownEventsForType[i]] = eventType;\n                    }\n                });\n                var eventsThatMustBeRegisteredUsingAttachEvent = { 'propertychange': true }; // Workaround for an IE9 issue - https://github.com/SteveSanderson/knockout/issues/406\n\n                // Detect IE versions for bug workarounds (uses IE conditionals, not UA string, for robustness)\n                // Note that, since IE 10 does not support conditional comments, the following logic only detects IE < 10.\n                // Currently this is by design, since IE 10+ behaves correctly when treated as a standard browser.\n                // If there is a future need to detect specific versions of IE10+, we will amend this.\n                var ieVersion = document && (function() {\n                    var version = 3, div = document.createElement('div'), iElems = div.getElementsByTagName('i');\n\n                    // Keep constructing conditional HTML blocks until we hit one that resolves to an empty fragment\n                    while (\n                        div.innerHTML = '<!--[if gt IE ' + (++version) + ']><i></i><![endif]-->',\n                            iElems[0]\n                        ) {}\n                    return version > 4 ? version : undefined;\n                }());\n                var isIe6 = ieVersion === 6,\n                    isIe7 = ieVersion === 7;\n\n                function isClickOnCheckableElement(element, eventType) {\n                    if ((ko.utils.tagNameLower(element) !== \"input\") || !element.type) return false;\n                    if (eventType.toLowerCase() != \"click\") return false;\n                    var inputType = element.type;\n                    return (inputType == \"checkbox\") || (inputType == \"radio\");\n                }\n\n                // For details on the pattern for changing node classes\n                // see: https://github.com/knockout/knockout/issues/1597\n                var cssClassNameRegex = /\\S+/g;\n\n                var jQueryEventAttachName;\n\n                function toggleDomNodeCssClass(node, classNames, shouldHaveClass) {\n                    var addOrRemoveFn;\n                    if (classNames) {\n                        if (typeof node.classList === 'object') {\n                            addOrRemoveFn = node.classList[shouldHaveClass ? 'add' : 'remove'];\n                            ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                                addOrRemoveFn.call(node.classList, className);\n                            });\n                        } else if (typeof node.className['baseVal'] === 'string') {\n                            // SVG tag .classNames is an SVGAnimatedString instance\n                            toggleObjectClassPropertyString(node.className, 'baseVal', classNames, shouldHaveClass);\n                        } else {\n                            // node.className ought to be a string.\n                            toggleObjectClassPropertyString(node, 'className', classNames, shouldHaveClass);\n                        }\n                    }\n                }\n\n                function toggleObjectClassPropertyString(obj, prop, classNames, shouldHaveClass) {\n                    // obj/prop is either a node/'className' or a SVGAnimatedString/'baseVal'.\n                    var currentClassNames = obj[prop].match(cssClassNameRegex) || [];\n                    ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                        ko.utils.addOrRemoveItem(currentClassNames, className, shouldHaveClass);\n                    });\n                    obj[prop] = currentClassNames.join(\" \");\n                }\n\n                return {\n                    fieldsIncludedWithJsonPost: ['authenticity_token', /^__RequestVerificationToken(_.*)?$/],\n\n                    arrayForEach: function (array, action, actionOwner) {\n                        for (var i = 0, j = array.length; i < j; i++) {\n                            action.call(actionOwner, array[i], i, array);\n                        }\n                    },\n\n                    arrayIndexOf: typeof Array.prototype.indexOf == \"function\"\n                        ? function (array, item) {\n                            return Array.prototype.indexOf.call(array, item);\n                        }\n                        : function (array, item) {\n                            for (var i = 0, j = array.length; i < j; i++) {\n                                if (array[i] === item)\n                                    return i;\n                            }\n                            return -1;\n                        },\n\n                    arrayFirst: function (array, predicate, predicateOwner) {\n                        for (var i = 0, j = array.length; i < j; i++) {\n                            if (predicate.call(predicateOwner, array[i], i, array))\n                                return array[i];\n                        }\n                        return undefined;\n                    },\n\n                    arrayRemoveItem: function (array, itemToRemove) {\n                        var index = ko.utils.arrayIndexOf(array, itemToRemove);\n                        if (index > 0) {\n                            array.splice(index, 1);\n                        }\n                        else if (index === 0) {\n                            array.shift();\n                        }\n                    },\n\n                    arrayGetDistinctValues: function (array) {\n                        var result = [];\n                        if (array) {\n                            ko.utils.arrayForEach(array, function(item) {\n                                if (ko.utils.arrayIndexOf(result, item) < 0)\n                                    result.push(item);\n                            });\n                        }\n                        return result;\n                    },\n\n                    arrayMap: function (array, mapping, mappingOwner) {\n                        var result = [];\n                        if (array) {\n                            for (var i = 0, j = array.length; i < j; i++)\n                                result.push(mapping.call(mappingOwner, array[i], i));\n                        }\n                        return result;\n                    },\n\n                    arrayFilter: function (array, predicate, predicateOwner) {\n                        var result = [];\n                        if (array) {\n                            for (var i = 0, j = array.length; i < j; i++)\n                                if (predicate.call(predicateOwner, array[i], i))\n                                    result.push(array[i]);\n                        }\n                        return result;\n                    },\n\n                    arrayPushAll: function (array, valuesToPush) {\n                        if (valuesToPush instanceof Array)\n                            array.push.apply(array, valuesToPush);\n                        else\n                            for (var i = 0, j = valuesToPush.length; i < j; i++)\n                                array.push(valuesToPush[i]);\n                        return array;\n                    },\n\n                    addOrRemoveItem: function(array, value, included) {\n                        var existingEntryIndex = ko.utils.arrayIndexOf(ko.utils.peekObservable(array), value);\n                        if (existingEntryIndex < 0) {\n                            if (included)\n                                array.push(value);\n                        } else {\n                            if (!included)\n                                array.splice(existingEntryIndex, 1);\n                        }\n                    },\n\n                    canSetPrototype: canSetPrototype,\n\n                    extend: extend,\n\n                    setPrototypeOf: setPrototypeOf,\n\n                    setPrototypeOfOrExtend: canSetPrototype ? setPrototypeOf : extend,\n\n                    objectForEach: objectForEach,\n\n                    objectMap: function(source, mapping, mappingOwner) {\n                        if (!source)\n                            return source;\n                        var target = {};\n                        for (var prop in source) {\n                            if (hasOwnProperty.call(source, prop)) {\n                                target[prop] = mapping.call(mappingOwner, source[prop], prop, source);\n                            }\n                        }\n                        return target;\n                    },\n\n                    emptyDomNode: function (domNode) {\n                        while (domNode.firstChild) {\n                            ko.removeNode(domNode.firstChild);\n                        }\n                    },\n\n                    moveCleanedNodesToContainerElement: function(nodes) {\n                        // Ensure it's a real array, as we're about to reparent the nodes and\n                        // we don't want the underlying collection to change while we're doing that.\n                        var nodesArray = ko.utils.makeArray(nodes);\n                        var templateDocument = (nodesArray[0] && nodesArray[0].ownerDocument) || document;\n\n                        var container = templateDocument.createElement('div');\n                        for (var i = 0, j = nodesArray.length; i < j; i++) {\n                            container.appendChild(ko.cleanNode(nodesArray[i]));\n                        }\n                        return container;\n                    },\n\n                    cloneNodes: function (nodesArray, shouldCleanNodes) {\n                        for (var i = 0, j = nodesArray.length, newNodesArray = []; i < j; i++) {\n                            var clonedNode = nodesArray[i].cloneNode(true);\n                            newNodesArray.push(shouldCleanNodes ? ko.cleanNode(clonedNode) : clonedNode);\n                        }\n                        return newNodesArray;\n                    },\n\n                    setDomNodeChildren: function (domNode, childNodes) {\n                        ko.utils.emptyDomNode(domNode);\n                        if (childNodes) {\n                            for (var i = 0, j = childNodes.length; i < j; i++)\n                                domNode.appendChild(childNodes[i]);\n                        }\n                    },\n\n                    replaceDomNodes: function (nodeToReplaceOrNodeArray, newNodesArray) {\n                        var nodesToReplaceArray = nodeToReplaceOrNodeArray.nodeType ? [nodeToReplaceOrNodeArray] : nodeToReplaceOrNodeArray;\n                        if (nodesToReplaceArray.length > 0) {\n                            var insertionPoint = nodesToReplaceArray[0];\n                            var parent = insertionPoint.parentNode;\n                            for (var i = 0, j = newNodesArray.length; i < j; i++)\n                                parent.insertBefore(newNodesArray[i], insertionPoint);\n                            for (var i = 0, j = nodesToReplaceArray.length; i < j; i++) {\n                                ko.removeNode(nodesToReplaceArray[i]);\n                            }\n                        }\n                    },\n\n                    fixUpContinuousNodeArray: function(continuousNodeArray, parentNode) {\n                        // Before acting on a set of nodes that were previously outputted by a template function, we have to reconcile\n                        // them against what is in the DOM right now. It may be that some of the nodes have already been removed, or that\n                        // new nodes might have been inserted in the middle, for example by a binding. Also, there may previously have been\n                        // leading comment nodes (created by rewritten string-based templates) that have since been removed during binding.\n                        // So, this function translates the old \"map\" output array into its best guess of the set of current DOM nodes.\n                        //\n                        // Rules:\n                        //   [A] Any leading nodes that have been removed should be ignored\n                        //       These most likely correspond to memoization nodes that were already removed during binding\n                        //       See https://github.com/knockout/knockout/pull/440\n                        //   [B] Any trailing nodes that have been remove should be ignored\n                        //       This prevents the code here from adding unrelated nodes to the array while processing rule [C]\n                        //       See https://github.com/knockout/knockout/pull/1903\n                        //   [C] We want to output a continuous series of nodes. So, ignore any nodes that have already been removed,\n                        //       and include any nodes that have been inserted among the previous collection\n\n                        if (continuousNodeArray.length) {\n                            // The parent node can be a virtual element; so get the real parent node\n                            parentNode = (parentNode.nodeType === 8 && parentNode.parentNode) || parentNode;\n\n                            // Rule [A]\n                            while (continuousNodeArray.length && continuousNodeArray[0].parentNode !== parentNode)\n                                continuousNodeArray.splice(0, 1);\n\n                            // Rule [B]\n                            while (continuousNodeArray.length > 1 && continuousNodeArray[continuousNodeArray.length - 1].parentNode !== parentNode)\n                                continuousNodeArray.length--;\n\n                            // Rule [C]\n                            if (continuousNodeArray.length > 1) {\n                                var current = continuousNodeArray[0], last = continuousNodeArray[continuousNodeArray.length - 1];\n                                // Replace with the actual new continuous node set\n                                continuousNodeArray.length = 0;\n                                while (current !== last) {\n                                    continuousNodeArray.push(current);\n                                    current = current.nextSibling;\n                                }\n                                continuousNodeArray.push(last);\n                            }\n                        }\n                        return continuousNodeArray;\n                    },\n\n                    setOptionNodeSelectionState: function (optionNode, isSelected) {\n                        // IE6 sometimes throws \"unknown error\" if you try to write to .selected directly, whereas Firefox struggles with setAttribute. Pick one based on browser.\n                        if (ieVersion < 7)\n                            optionNode.setAttribute(\"selected\", isSelected);\n                        else\n                            optionNode.selected = isSelected;\n                    },\n\n                    stringTrim: function (string) {\n                        return string === null || string === undefined ? '' :\n                            string.trim ?\n                                string.trim() :\n                                string.toString().replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, '');\n                    },\n\n                    stringStartsWith: function (string, startsWith) {\n                        string = string || \"\";\n                        if (startsWith.length > string.length)\n                            return false;\n                        return string.substring(0, startsWith.length) === startsWith;\n                    },\n\n                    domNodeIsContainedBy: function (node, containedByNode) {\n                        if (node === containedByNode)\n                            return true;\n                        if (node.nodeType === 11)\n                            return false; // Fixes issue #1162 - can't use node.contains for document fragments on IE8\n                        if (containedByNode.contains)\n                            return containedByNode.contains(node.nodeType !== 1 ? node.parentNode : node);\n                        if (containedByNode.compareDocumentPosition)\n                            return (containedByNode.compareDocumentPosition(node) & 16) == 16;\n                        while (node && node != containedByNode) {\n                            node = node.parentNode;\n                        }\n                        return !!node;\n                    },\n\n                    domNodeIsAttachedToDocument: function (node) {\n                        return ko.utils.domNodeIsContainedBy(node, node.ownerDocument.documentElement);\n                    },\n\n                    anyDomNodeIsAttachedToDocument: function(nodes) {\n                        return !!ko.utils.arrayFirst(nodes, ko.utils.domNodeIsAttachedToDocument);\n                    },\n\n                    tagNameLower: function(element) {\n                        // For HTML elements, tagName will always be upper case; for XHTML elements, it'll be lower case.\n                        // Possible future optimization: If we know it's an element from an XHTML document (not HTML),\n                        // we don't need to do the .toLowerCase() as it will always be lower case anyway.\n                        return element && element.tagName && element.tagName.toLowerCase();\n                    },\n\n                    catchFunctionErrors: function (delegate) {\n                        return ko['onError'] ? function () {\n                            try {\n                                return delegate.apply(this, arguments);\n                            } catch (e) {\n                                ko['onError'] && ko['onError'](e);\n                                throw e;\n                            }\n                        } : delegate;\n                    },\n\n                    setTimeout: function (handler, timeout) {\n                        return setTimeout(ko.utils.catchFunctionErrors(handler), timeout);\n                    },\n\n                    deferError: function (error) {\n                        setTimeout(function () {\n                            ko['onError'] && ko['onError'](error);\n                            throw error;\n                        }, 0);\n                    },\n\n                    registerEventHandler: function (element, eventType, handler) {\n                        var wrappedHandler = ko.utils.catchFunctionErrors(handler);\n\n                        var mustUseAttachEvent = eventsThatMustBeRegisteredUsingAttachEvent[eventType];\n                        if (!ko.options['useOnlyNativeEvents'] && !mustUseAttachEvent && jQueryInstance) {\n                            if (!jQueryEventAttachName) {\n                                jQueryEventAttachName = (typeof jQueryInstance(element)['on'] == 'function') ? 'on' : 'bind';\n                            }\n                            jQueryInstance(element)[jQueryEventAttachName](eventType, wrappedHandler);\n                        } else if (!mustUseAttachEvent && typeof element.addEventListener == \"function\")\n                            element.addEventListener(eventType, wrappedHandler, false);\n                        else if (typeof element.attachEvent != \"undefined\") {\n                            var attachEventHandler = function (event) { wrappedHandler.call(element, event); },\n                                attachEventName = \"on\" + eventType;\n                            element.attachEvent(attachEventName, attachEventHandler);\n\n                            // IE does not dispose attachEvent handlers automatically (unlike with addEventListener)\n                            // so to avoid leaks, we have to remove them manually. See bug #856\n                            ko.utils.domNodeDisposal.addDisposeCallback(element, function() {\n                                element.detachEvent(attachEventName, attachEventHandler);\n                            });\n                        } else\n                            throw new Error(\"Browser doesn't support addEventListener or attachEvent\");\n                    },\n\n                    triggerEvent: function (element, eventType) {\n                        if (!(element && element.nodeType))\n                            throw new Error(\"element must be a DOM node when calling triggerEvent\");\n\n                        // For click events on checkboxes and radio buttons, jQuery toggles the element checked state *after* the\n                        // event handler runs instead of *before*. (This was fixed in 1.9 for checkboxes but not for radio buttons.)\n                        // IE doesn't change the checked state when you trigger the click event using \"fireEvent\".\n                        // In both cases, we'll use the click method instead.\n                        var useClickWorkaround = isClickOnCheckableElement(element, eventType);\n\n                        if (!ko.options['useOnlyNativeEvents'] && jQueryInstance && !useClickWorkaround) {\n                            jQueryInstance(element)['trigger'](eventType);\n                        } else if (typeof document.createEvent == \"function\") {\n                            if (typeof element.dispatchEvent == \"function\") {\n                                var eventCategory = knownEventTypesByEventName[eventType] || \"HTMLEvents\";\n                                var event = document.createEvent(eventCategory);\n                                event.initEvent(eventType, true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, element);\n                                element.dispatchEvent(event);\n                            }\n                            else\n                                throw new Error(\"The supplied element doesn't support dispatchEvent\");\n                        } else if (useClickWorkaround && element.click) {\n                            element.click();\n                        } else if (typeof element.fireEvent != \"undefined\") {\n                            element.fireEvent(\"on\" + eventType);\n                        } else {\n                            throw new Error(\"Browser doesn't support triggering events\");\n                        }\n                    },\n\n                    unwrapObservable: function (value) {\n                        return ko.isObservable(value) ? value() : value;\n                    },\n\n                    peekObservable: function (value) {\n                        return ko.isObservable(value) ? value.peek() : value;\n                    },\n\n                    toggleDomNodeCssClass: toggleDomNodeCssClass,\n\n                    setTextContent: function(element, textContent) {\n                        var value = ko.utils.unwrapObservable(textContent);\n                        if ((value === null) || (value === undefined))\n                            value = \"\";\n\n                        // We need there to be exactly one child: a text node.\n                        // If there are no children, more than one, or if it's not a text node,\n                        // we'll clear everything and create a single text node.\n                        var innerTextNode = ko.virtualElements.firstChild(element);\n                        if (!innerTextNode || innerTextNode.nodeType != 3 || ko.virtualElements.nextSibling(innerTextNode)) {\n                            ko.virtualElements.setDomNodeChildren(element, [element.ownerDocument.createTextNode(value)]);\n                        } else {\n                            innerTextNode.data = value;\n                        }\n\n                        ko.utils.forceRefresh(element);\n                    },\n\n                    setElementName: function(element, name) {\n                        element.name = name;\n\n                        // Workaround IE 6/7 issue\n                        // - https://github.com/SteveSanderson/knockout/issues/197\n                        // - http://www.matts411.com/post/setting_the_name_attribute_in_ie_dom/\n                        if (ieVersion <= 7) {\n                            try {\n                                var escapedName = element.name.replace(/[&<>'\"]/g, function(r){ return \"&#\" + r.charCodeAt(0) + \";\"; });\n                                element.mergeAttributes(document.createElement(\"<input name='\" + escapedName + \"'/>\"), false);\n                            }\n                            catch(e) {} // For IE9 with doc mode \"IE9 Standards\" and browser mode \"IE9 Compatibility View\"\n                        }\n                    },\n\n                    forceRefresh: function(node) {\n                        // Workaround for an IE9 rendering bug - https://github.com/SteveSanderson/knockout/issues/209\n                        if (ieVersion >= 9) {\n                            // For text nodes and comment nodes (most likely virtual elements), we will have to refresh the container\n                            var elem = node.nodeType == 1 ? node : node.parentNode;\n                            if (elem.style)\n                                elem.style.zoom = elem.style.zoom;\n                        }\n                    },\n\n                    ensureSelectElementIsRenderedCorrectly: function(selectElement) {\n                        // Workaround for IE9 rendering bug - it doesn't reliably display all the text in dynamically-added select boxes unless you force it to re-render by updating the width.\n                        // (See https://github.com/SteveSanderson/knockout/issues/312, http://stackoverflow.com/questions/5908494/select-only-shows-first-char-of-selected-option)\n                        // Also fixes IE7 and IE8 bug that causes selects to be zero width if enclosed by 'if' or 'with'. (See issue #839)\n                        if (ieVersion) {\n                            var originalWidth = selectElement.style.width;\n                            selectElement.style.width = 0;\n                            selectElement.style.width = originalWidth;\n                        }\n                    },\n\n                    range: function (min, max) {\n                        min = ko.utils.unwrapObservable(min);\n                        max = ko.utils.unwrapObservable(max);\n                        var result = [];\n                        for (var i = min; i <= max; i++)\n                            result.push(i);\n                        return result;\n                    },\n\n                    makeArray: function(arrayLikeObject) {\n                        var result = [];\n                        for (var i = 0, j = arrayLikeObject.length; i < j; i++) {\n                            result.push(arrayLikeObject[i]);\n                        };\n                        return result;\n                    },\n\n                    createSymbolOrString: function(identifier) {\n                        return canUseSymbols ? Symbol(identifier) : identifier;\n                    },\n\n                    isIe6 : isIe6,\n                    isIe7 : isIe7,\n                    ieVersion : ieVersion,\n\n                    getFormFields: function(form, fieldName) {\n                        var fields = ko.utils.makeArray(form.getElementsByTagName(\"input\")).concat(ko.utils.makeArray(form.getElementsByTagName(\"textarea\")));\n                        var isMatchingField = (typeof fieldName == 'string')\n                            ? function(field) { return field.name === fieldName }\n                            : function(field) { return fieldName.test(field.name) }; // Treat fieldName as regex or object containing predicate\n                        var matches = [];\n                        for (var i = fields.length - 1; i >= 0; i--) {\n                            if (isMatchingField(fields[i]))\n                                matches.push(fields[i]);\n                        };\n                        return matches;\n                    },\n\n                    parseJson: function (jsonString) {\n                        if (typeof jsonString == \"string\") {\n                            jsonString = ko.utils.stringTrim(jsonString);\n                            if (jsonString) {\n                                if (JSON && JSON.parse) // Use native parsing where available\n                                    return JSON.parse(jsonString);\n                                return (new Function(\"return \" + jsonString))(); // Fallback on less safe parsing for older browsers\n                            }\n                        }\n                        return null;\n                    },\n\n                    stringifyJson: function (data, replacer, space) {   // replacer and space are optional\n                        if (!JSON || !JSON.stringify)\n                            throw new Error(\"Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js\");\n                        return JSON.stringify(ko.utils.unwrapObservable(data), replacer, space);\n                    },\n\n                    postJson: function (urlOrForm, data, options) {\n                        options = options || {};\n                        var params = options['params'] || {};\n                        var includeFields = options['includeFields'] || this.fieldsIncludedWithJsonPost;\n                        var url = urlOrForm;\n\n                        // If we were given a form, use its 'action' URL and pick out any requested field values\n                        if((typeof urlOrForm == 'object') && (ko.utils.tagNameLower(urlOrForm) === \"form\")) {\n                            var originalForm = urlOrForm;\n                            url = originalForm.action;\n                            for (var i = includeFields.length - 1; i >= 0; i--) {\n                                var fields = ko.utils.getFormFields(originalForm, includeFields[i]);\n                                for (var j = fields.length - 1; j >= 0; j--)\n                                    params[fields[j].name] = fields[j].value;\n                            }\n                        }\n\n                        data = ko.utils.unwrapObservable(data);\n                        var form = document.createElement(\"form\");\n                        form.style.display = \"none\";\n                        form.action = url;\n                        form.method = \"post\";\n                        for (var key in data) {\n                            // Since 'data' this is a model object, we include all properties including those inherited from its prototype\n                            var input = document.createElement(\"input\");\n                            input.type = \"hidden\";\n                            input.name = key;\n                            input.value = ko.utils.stringifyJson(ko.utils.unwrapObservable(data[key]));\n                            form.appendChild(input);\n                        }\n                        objectForEach(params, function(key, value) {\n                            var input = document.createElement(\"input\");\n                            input.type = \"hidden\";\n                            input.name = key;\n                            input.value = value;\n                            form.appendChild(input);\n                        });\n                        document.body.appendChild(form);\n                        options['submitter'] ? options['submitter'](form) : form.submit();\n                        setTimeout(function () { form.parentNode.removeChild(form); }, 0);\n                    }\n                }\n            }());\n\n            ko.exportSymbol('utils', ko.utils);\n            ko.exportSymbol('utils.arrayForEach', ko.utils.arrayForEach);\n            ko.exportSymbol('utils.arrayFirst', ko.utils.arrayFirst);\n            ko.exportSymbol('utils.arrayFilter', ko.utils.arrayFilter);\n            ko.exportSymbol('utils.arrayGetDistinctValues', ko.utils.arrayGetDistinctValues);\n            ko.exportSymbol('utils.arrayIndexOf', ko.utils.arrayIndexOf);\n            ko.exportSymbol('utils.arrayMap', ko.utils.arrayMap);\n            ko.exportSymbol('utils.arrayPushAll', ko.utils.arrayPushAll);\n            ko.exportSymbol('utils.arrayRemoveItem', ko.utils.arrayRemoveItem);\n            ko.exportSymbol('utils.cloneNodes', ko.utils.cloneNodes);\n            ko.exportSymbol('utils.createSymbolOrString', ko.utils.createSymbolOrString);\n            ko.exportSymbol('utils.extend', ko.utils.extend);\n            ko.exportSymbol('utils.fieldsIncludedWithJsonPost', ko.utils.fieldsIncludedWithJsonPost);\n            ko.exportSymbol('utils.getFormFields', ko.utils.getFormFields);\n            ko.exportSymbol('utils.objectMap', ko.utils.objectMap);\n            ko.exportSymbol('utils.peekObservable', ko.utils.peekObservable);\n            ko.exportSymbol('utils.postJson', ko.utils.postJson);\n            ko.exportSymbol('utils.parseJson', ko.utils.parseJson);\n            ko.exportSymbol('utils.registerEventHandler', ko.utils.registerEventHandler);\n            ko.exportSymbol('utils.stringifyJson', ko.utils.stringifyJson);\n            ko.exportSymbol('utils.range', ko.utils.range);\n            ko.exportSymbol('utils.toggleDomNodeCssClass', ko.utils.toggleDomNodeCssClass);\n            ko.exportSymbol('utils.triggerEvent', ko.utils.triggerEvent);\n            ko.exportSymbol('utils.unwrapObservable', ko.utils.unwrapObservable);\n            ko.exportSymbol('utils.objectForEach', ko.utils.objectForEach);\n            ko.exportSymbol('utils.addOrRemoveItem', ko.utils.addOrRemoveItem);\n            ko.exportSymbol('utils.setTextContent', ko.utils.setTextContent);\n            ko.exportSymbol('unwrap', ko.utils.unwrapObservable); // Convenient shorthand, because this is used so commonly\n\n            if (!Function.prototype['bind']) {\n                // Function.prototype.bind is a standard part of ECMAScript 5th Edition (December 2009, http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf)\n                // In case the browser doesn't implement it natively, provide a JavaScript implementation. This implementation is based on the one in prototype.js\n                Function.prototype['bind'] = function (object) {\n                    var originalFunction = this;\n                    if (arguments.length === 1) {\n                        return function () {\n                            return originalFunction.apply(object, arguments);\n                        };\n                    } else {\n                        var partialArgs = Array.prototype.slice.call(arguments, 1);\n                        return function () {\n                            var args = partialArgs.slice(0);\n                            args.push.apply(args, arguments);\n                            return originalFunction.apply(object, args);\n                        };\n                    }\n                };\n            }\n\n            ko.utils.domData = new (function () {\n                var uniqueId = 0;\n                var dataStoreKeyExpandoPropertyName = \"__ko__\" + (new Date).getTime();\n                var dataStore = {};\n\n                var getDataForNode, clear;\n                if (!ko.utils.ieVersion) {\n                    // We considered using WeakMap, but it has a problem in IE 11 and Edge that prevents using\n                    // it cross-window, so instead we just store the data directly on the node.\n                    // See https://github.com/knockout/knockout/issues/2141\n                    getDataForNode = function (node, createIfNotFound) {\n                        var dataForNode = node[dataStoreKeyExpandoPropertyName];\n                        if (!dataForNode && createIfNotFound) {\n                            dataForNode = node[dataStoreKeyExpandoPropertyName] = {};\n                        }\n                        return dataForNode;\n                    };\n                    clear = function (node) {\n                        if (node[dataStoreKeyExpandoPropertyName]) {\n                            delete node[dataStoreKeyExpandoPropertyName];\n                            return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n                        }\n                        return false;\n                    };\n                } else {\n                    // Old IE versions have memory issues if you store objects on the node, so we use a\n                    // separate data storage and link to it from the node using a string key.\n                    getDataForNode = function (node, createIfNotFound) {\n                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n                        var hasExistingDataStore = dataStoreKey && (dataStoreKey !== \"null\") && dataStore[dataStoreKey];\n                        if (!hasExistingDataStore) {\n                            if (!createIfNotFound)\n                                return undefined;\n                            dataStoreKey = node[dataStoreKeyExpandoPropertyName] = \"ko\" + uniqueId++;\n                            dataStore[dataStoreKey] = {};\n                        }\n                        return dataStore[dataStoreKey];\n                    };\n                    clear = function (node) {\n                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n                        if (dataStoreKey) {\n                            delete dataStore[dataStoreKey];\n                            node[dataStoreKeyExpandoPropertyName] = null;\n                            return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n                        }\n                        return false;\n                    };\n                }\n\n                return {\n                    get: function (node, key) {\n                        var dataForNode = getDataForNode(node, false);\n                        return dataForNode && dataForNode[key];\n                    },\n                    set: function (node, key, value) {\n                        // Make sure we don't actually create a new domData key if we are actually deleting a value\n                        var dataForNode = getDataForNode(node, value !== undefined /* createIfNotFound */);\n                        dataForNode && (dataForNode[key] = value);\n                    },\n                    getOrSet: function (node, key, value) {\n                        var dataForNode = getDataForNode(node, true /* createIfNotFound */);\n                        return dataForNode[key] || (dataForNode[key] = value);\n                    },\n                    clear: clear,\n\n                    nextKey: function () {\n                        return (uniqueId++) + dataStoreKeyExpandoPropertyName;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('utils.domData', ko.utils.domData);\n            ko.exportSymbol('utils.domData.clear', ko.utils.domData.clear); // Exporting only so specs can clear up after themselves fully\n\n            ko.utils.domNodeDisposal = new (function () {\n                var domDataKey = ko.utils.domData.nextKey();\n                var cleanableNodeTypes = { 1: true, 8: true, 9: true };       // Element, Comment, Document\n                var cleanableNodeTypesWithDescendants = { 1: true, 9: true }; // Element, Document\n\n                function getDisposeCallbacksCollection(node, createIfNotFound) {\n                    var allDisposeCallbacks = ko.utils.domData.get(node, domDataKey);\n                    if ((allDisposeCallbacks === undefined) && createIfNotFound) {\n                        allDisposeCallbacks = [];\n                        ko.utils.domData.set(node, domDataKey, allDisposeCallbacks);\n                    }\n                    return allDisposeCallbacks;\n                }\n                function destroyCallbacksCollection(node) {\n                    ko.utils.domData.set(node, domDataKey, undefined);\n                }\n\n                function cleanSingleNode(node) {\n                    // Run all the dispose callbacks\n                    var callbacks = getDisposeCallbacksCollection(node, false);\n                    if (callbacks) {\n                        callbacks = callbacks.slice(0); // Clone, as the array may be modified during iteration (typically, callbacks will remove themselves)\n                        for (var i = 0; i < callbacks.length; i++)\n                            callbacks[i](node);\n                    }\n\n                    // Erase the DOM data\n                    ko.utils.domData.clear(node);\n\n                    // Perform cleanup needed by external libraries (currently only jQuery, but can be extended)\n                    ko.utils.domNodeDisposal[\"cleanExternalData\"](node);\n\n                    // Clear any immediate-child comment nodes, as these wouldn't have been found by\n                    // node.getElementsByTagName(\"*\") in cleanNode() (comment nodes aren't elements)\n                    if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                        cleanNodesInList(node.childNodes, true/*onlyComments*/);\n                    }\n                }\n\n                function cleanNodesInList(nodeList, onlyComments) {\n                    var cleanedNodes = [], lastCleanedNode;\n                    for (var i = 0; i < nodeList.length; i++) {\n                        if (!onlyComments || nodeList[i].nodeType === 8) {\n                            cleanSingleNode(cleanedNodes[cleanedNodes.length] = lastCleanedNode = nodeList[i]);\n                            if (nodeList[i] !== lastCleanedNode) {\n                                while (i-- && ko.utils.arrayIndexOf(cleanedNodes, nodeList[i]) == -1) {}\n                            }\n                        }\n                    }\n                }\n\n                return {\n                    addDisposeCallback : function(node, callback) {\n                        if (typeof callback != \"function\")\n                            throw new Error(\"Callback must be a function\");\n                        getDisposeCallbacksCollection(node, true).push(callback);\n                    },\n\n                    removeDisposeCallback : function(node, callback) {\n                        var callbacksCollection = getDisposeCallbacksCollection(node, false);\n                        if (callbacksCollection) {\n                            ko.utils.arrayRemoveItem(callbacksCollection, callback);\n                            if (callbacksCollection.length == 0)\n                                destroyCallbacksCollection(node);\n                        }\n                    },\n\n                    cleanNode : function(node) {\n                        ko.dependencyDetection.ignore(function () {\n                            // First clean this node, where applicable\n                            if (cleanableNodeTypes[node.nodeType]) {\n                                cleanSingleNode(node);\n\n                                // ... then its descendants, where applicable\n                                if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                                    cleanNodesInList(node.getElementsByTagName(\"*\"));\n                                }\n                            }\n                        });\n\n                        return node;\n                    },\n\n                    removeNode : function(node) {\n                        ko.cleanNode(node);\n                        if (node.parentNode)\n                            node.parentNode.removeChild(node);\n                    },\n\n                    \"cleanExternalData\" : function (node) {\n                        // Special support for jQuery here because it's so commonly used.\n                        // Many jQuery plugins (including jquery.tmpl) store data using jQuery's equivalent of domData\n                        // so notify it to tear down any resources associated with the node & descendants here.\n                        if (jQueryInstance && (typeof jQueryInstance['cleanData'] == \"function\"))\n                            jQueryInstance['cleanData']([node]);\n                    }\n                };\n            })();\n            ko.cleanNode = ko.utils.domNodeDisposal.cleanNode; // Shorthand name for convenience\n            ko.removeNode = ko.utils.domNodeDisposal.removeNode; // Shorthand name for convenience\n            ko.exportSymbol('cleanNode', ko.cleanNode);\n            ko.exportSymbol('removeNode', ko.removeNode);\n            ko.exportSymbol('utils.domNodeDisposal', ko.utils.domNodeDisposal);\n            ko.exportSymbol('utils.domNodeDisposal.addDisposeCallback', ko.utils.domNodeDisposal.addDisposeCallback);\n            ko.exportSymbol('utils.domNodeDisposal.removeDisposeCallback', ko.utils.domNodeDisposal.removeDisposeCallback);\n            (function () {\n                var none = [0, \"\", \"\"],\n                    table = [1, \"<table>\", \"</table>\"],\n                    tbody = [2, \"<table><tbody>\", \"</tbody></table>\"],\n                    tr = [3, \"<table><tbody><tr>\", \"</tr></tbody></table>\"],\n                    select = [1, \"<select multiple='multiple'>\", \"</select>\"],\n                    lookup = {\n                        'thead': table,\n                        'tbody': table,\n                        'tfoot': table,\n                        'tr': tbody,\n                        'td': tr,\n                        'th': tr,\n                        'option': select,\n                        'optgroup': select\n                    },\n\n                    // This is needed for old IE if you're *not* using either jQuery or innerShiv. Doesn't affect other cases.\n                    mayRequireCreateElementHack = ko.utils.ieVersion <= 8;\n\n                function getWrap(tags) {\n                    var m = tags.match(/^(?:<!--.*?-->\\s*?)*?<([a-z]+)[\\s>]/);\n                    return (m && lookup[m[1]]) || none;\n                }\n\n                function simpleHtmlParse(html, documentContext) {\n                    documentContext || (documentContext = document);\n                    var windowContext = documentContext['parentWindow'] || documentContext['defaultView'] || window;\n\n                    // Based on jQuery's \"clean\" function, but only accounting for table-related elements.\n                    // If you have referenced jQuery, this won't be used anyway - KO will use jQuery's \"clean\" function directly\n\n                    // Note that there's still an issue in IE < 9 whereby it will discard comment nodes that are the first child of\n                    // a descendant node. For example: \"<div><!-- mycomment -->abc</div>\" will get parsed as \"<div>abc</div>\"\n                    // This won't affect anyone who has referenced jQuery, and there's always the workaround of inserting a dummy node\n                    // (possibly a text node) in front of the comment. So, KO does not attempt to workaround this IE issue automatically at present.\n\n                    // Trim whitespace, otherwise indexOf won't work as expected\n                    var tags = ko.utils.stringTrim(html).toLowerCase(), div = documentContext.createElement(\"div\"),\n                        wrap = getWrap(tags),\n                        depth = wrap[0];\n\n                    // Go to html and back, then peel off extra wrappers\n                    // Note that we always prefix with some dummy text, because otherwise, IE<9 will strip out leading comment nodes in descendants. Total madness.\n                    var markup = \"ignored<div>\" + wrap[1] + html + wrap[2] + \"</div>\";\n                    if (typeof windowContext['innerShiv'] == \"function\") {\n                        // Note that innerShiv is deprecated in favour of html5shiv. We should consider adding\n                        // support for html5shiv (except if no explicit support is needed, e.g., if html5shiv\n                        // somehow shims the native APIs so it just works anyway)\n                        div.appendChild(windowContext['innerShiv'](markup));\n                    } else {\n                        if (mayRequireCreateElementHack) {\n                            // The document.createElement('my-element') trick to enable custom elements in IE6-8\n                            // only works if we assign innerHTML on an element associated with that document.\n                            documentContext.body.appendChild(div);\n                        }\n\n                        div.innerHTML = markup;\n\n                        if (mayRequireCreateElementHack) {\n                            div.parentNode.removeChild(div);\n                        }\n                    }\n\n                    // Move to the right depth\n                    while (depth--)\n                        div = div.lastChild;\n\n                    return ko.utils.makeArray(div.lastChild.childNodes);\n                }\n\n                function jQueryHtmlParse(html, documentContext) {\n                    // jQuery's \"parseHTML\" function was introduced in jQuery 1.8.0 and is a documented public API.\n                    if (jQueryInstance['parseHTML']) {\n                        return jQueryInstance['parseHTML'](html, documentContext) || []; // Ensure we always return an array and never null\n                    } else {\n                        // For jQuery < 1.8.0, we fall back on the undocumented internal \"clean\" function.\n                        var elems = jQueryInstance['clean']([html], documentContext);\n\n                        // As of jQuery 1.7.1, jQuery parses the HTML by appending it to some dummy parent nodes held in an in-memory document fragment.\n                        // Unfortunately, it never clears the dummy parent nodes from the document fragment, so it leaks memory over time.\n                        // Fix this by finding the top-most dummy parent element, and detaching it from its owner fragment.\n                        if (elems && elems[0]) {\n                            // Find the top-most parent element that's a direct child of a document fragment\n                            var elem = elems[0];\n                            while (elem.parentNode && elem.parentNode.nodeType !== 11 /* i.e., DocumentFragment */)\n                                elem = elem.parentNode;\n                            // ... then detach it\n                            if (elem.parentNode)\n                                elem.parentNode.removeChild(elem);\n                        }\n\n                        return elems;\n                    }\n                }\n\n                ko.utils.parseHtmlFragment = function(html, documentContext) {\n                    return jQueryInstance ?\n                        jQueryHtmlParse(html, documentContext) :   // As below, benefit from jQuery's optimisations where possible\n                        simpleHtmlParse(html, documentContext);  // ... otherwise, this simple logic will do in most common cases.\n                };\n\n                ko.utils.parseHtmlForTemplateNodes = function(html, documentContext) {\n                    var nodes = ko.utils.parseHtmlFragment(html, documentContext);\n                    return (nodes.length && nodes[0].parentElement) || ko.utils.moveCleanedNodesToContainerElement(nodes);\n                };\n\n                ko.utils.setHtml = function(node, html) {\n                    ko.utils.emptyDomNode(node);\n\n                    // There's no legitimate reason to display a stringified observable without unwrapping it, so we'll unwrap it\n                    html = ko.utils.unwrapObservable(html);\n\n                    if ((html !== null) && (html !== undefined)) {\n                        if (typeof html != 'string')\n                            html = html.toString();\n\n                        // jQuery contains a lot of sophisticated code to parse arbitrary HTML fragments,\n                        // for example <tr> elements which are not normally allowed to exist on their own.\n                        // If you've referenced jQuery we'll use that rather than duplicating its code.\n                        if (jQueryInstance) {\n                            jQueryInstance(node)['html'](html);\n                        } else {\n                            // ... otherwise, use KO's own parsing logic.\n                            var parsedNodes = ko.utils.parseHtmlFragment(html, node.ownerDocument);\n                            for (var i = 0; i < parsedNodes.length; i++)\n                                node.appendChild(parsedNodes[i]);\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('utils.parseHtmlFragment', ko.utils.parseHtmlFragment);\n            ko.exportSymbol('utils.setHtml', ko.utils.setHtml);\n\n            ko.memoization = (function () {\n                var memos = {};\n\n                function randomMax8HexChars() {\n                    return (((1 + Math.random()) * 0x100000000) | 0).toString(16).substring(1);\n                }\n                function generateRandomId() {\n                    return randomMax8HexChars() + randomMax8HexChars();\n                }\n                function findMemoNodes(rootNode, appendToArray) {\n                    if (!rootNode)\n                        return;\n                    if (rootNode.nodeType == 8) {\n                        var memoId = ko.memoization.parseMemoText(rootNode.nodeValue);\n                        if (memoId != null)\n                            appendToArray.push({ domNode: rootNode, memoId: memoId });\n                    } else if (rootNode.nodeType == 1) {\n                        for (var i = 0, childNodes = rootNode.childNodes, j = childNodes.length; i < j; i++)\n                            findMemoNodes(childNodes[i], appendToArray);\n                    }\n                }\n\n                return {\n                    memoize: function (callback) {\n                        if (typeof callback != \"function\")\n                            throw new Error(\"You can only pass a function to ko.memoization.memoize()\");\n                        var memoId = generateRandomId();\n                        memos[memoId] = callback;\n                        return \"<!--[ko_memo:\" + memoId + \"]-->\";\n                    },\n\n                    unmemoize: function (memoId, callbackParams) {\n                        var callback = memos[memoId];\n                        if (callback === undefined)\n                            throw new Error(\"Couldn't find any memo with ID \" + memoId + \". Perhaps it's already been unmemoized.\");\n                        try {\n                            callback.apply(null, callbackParams || []);\n                            return true;\n                        }\n                        finally { delete memos[memoId]; }\n                    },\n\n                    unmemoizeDomNodeAndDescendants: function (domNode, extraCallbackParamsArray) {\n                        var memos = [];\n                        findMemoNodes(domNode, memos);\n                        for (var i = 0, j = memos.length; i < j; i++) {\n                            var node = memos[i].domNode;\n                            var combinedParams = [node];\n                            if (extraCallbackParamsArray)\n                                ko.utils.arrayPushAll(combinedParams, extraCallbackParamsArray);\n                            ko.memoization.unmemoize(memos[i].memoId, combinedParams);\n                            node.nodeValue = \"\"; // Neuter this node so we don't try to unmemoize it again\n                            if (node.parentNode)\n                                node.parentNode.removeChild(node); // If possible, erase it totally (not always possible - someone else might just hold a reference to it then call unmemoizeDomNodeAndDescendants again)\n                        }\n                    },\n\n                    parseMemoText: function (memoText) {\n                        var match = memoText.match(/^\\[ko_memo\\:(.*?)\\]$/);\n                        return match ? match[1] : null;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('memoization', ko.memoization);\n            ko.exportSymbol('memoization.memoize', ko.memoization.memoize);\n            ko.exportSymbol('memoization.unmemoize', ko.memoization.unmemoize);\n            ko.exportSymbol('memoization.parseMemoText', ko.memoization.parseMemoText);\n            ko.exportSymbol('memoization.unmemoizeDomNodeAndDescendants', ko.memoization.unmemoizeDomNodeAndDescendants);\n            ko.tasks = (function () {\n                var scheduler,\n                    taskQueue = [],\n                    taskQueueLength = 0,\n                    nextHandle = 1,\n                    nextIndexToProcess = 0;\n\n                if (window['MutationObserver']) {\n                    // Chrome 27+, Firefox 14+, IE 11+, Opera 15+, Safari 6.1+\n                    // From https://github.com/petkaantonov/bluebird * Copyright (c) 2014 Petka Antonov * License: MIT\n                    scheduler = (function (callback) {\n                        var div = document.createElement(\"div\");\n                        new MutationObserver(callback).observe(div, {attributes: true});\n                        return function () { div.classList.toggle(\"foo\"); };\n                    })(scheduledProcess);\n                } else if (document && \"onreadystatechange\" in document.createElement(\"script\")) {\n                    // IE 6-10\n                    // From https://github.com/YuzuJS/setImmediate * Copyright (c) 2012 Barnesandnoble.com, llc, Donavon West, and Domenic Denicola * License: MIT\n                    scheduler = function (callback) {\n                        var script = document.createElement(\"script\");\n                        script.onreadystatechange = function () {\n                            script.onreadystatechange = null;\n                            document.documentElement.removeChild(script);\n                            script = null;\n                            callback();\n                        };\n                        document.documentElement.appendChild(script);\n                    };\n                } else {\n                    scheduler = function (callback) {\n                        setTimeout(callback, 0);\n                    };\n                }\n\n                function processTasks() {\n                    if (taskQueueLength) {\n                        // Each mark represents the end of a logical group of tasks and the number of these groups is\n                        // limited to prevent unchecked recursion.\n                        var mark = taskQueueLength, countMarks = 0;\n\n                        // nextIndexToProcess keeps track of where we are in the queue; processTasks can be called recursively without issue\n                        for (var task; nextIndexToProcess < taskQueueLength; ) {\n                            if (task = taskQueue[nextIndexToProcess++]) {\n                                if (nextIndexToProcess > mark) {\n                                    if (++countMarks >= 5000) {\n                                        nextIndexToProcess = taskQueueLength;   // skip all tasks remaining in the queue since any of them could be causing the recursion\n                                        ko.utils.deferError(Error(\"'Too much recursion' after processing \" + countMarks + \" task groups.\"));\n                                        break;\n                                    }\n                                    mark = taskQueueLength;\n                                }\n                                try {\n                                    task();\n                                } catch (ex) {\n                                    ko.utils.deferError(ex);\n                                }\n                            }\n                        }\n                    }\n                }\n\n                function scheduledProcess() {\n                    processTasks();\n\n                    // Reset the queue\n                    nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n                }\n\n                function scheduleTaskProcessing() {\n                    ko.tasks['scheduler'](scheduledProcess);\n                }\n\n                var tasks = {\n                    'scheduler': scheduler,     // Allow overriding the scheduler\n\n                    schedule: function (func) {\n                        if (!taskQueueLength) {\n                            scheduleTaskProcessing();\n                        }\n\n                        taskQueue[taskQueueLength++] = func;\n                        return nextHandle++;\n                    },\n\n                    cancel: function (handle) {\n                        var index = handle - (nextHandle - taskQueueLength);\n                        if (index >= nextIndexToProcess && index < taskQueueLength) {\n                            taskQueue[index] = null;\n                        }\n                    },\n\n                    // For testing only: reset the queue and return the previous queue length\n                    'resetForTesting': function () {\n                        var length = taskQueueLength - nextIndexToProcess;\n                        nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n                        return length;\n                    },\n\n                    runEarly: processTasks\n                };\n\n                return tasks;\n            })();\n\n            ko.exportSymbol('tasks', ko.tasks);\n            ko.exportSymbol('tasks.schedule', ko.tasks.schedule);\n//ko.exportSymbol('tasks.cancel', ko.tasks.cancel);  \"cancel\" isn't minified\n            ko.exportSymbol('tasks.runEarly', ko.tasks.runEarly);\n            ko.extenders = {\n                'throttle': function(target, timeout) {\n                    // Throttling means two things:\n\n                    // (1) For dependent observables, we throttle *evaluations* so that, no matter how fast its dependencies\n                    //     notify updates, the target doesn't re-evaluate (and hence doesn't notify) faster than a certain rate\n                    target['throttleEvaluation'] = timeout;\n\n                    // (2) For writable targets (observables, or writable dependent observables), we throttle *writes*\n                    //     so the target cannot change value synchronously or faster than a certain rate\n                    var writeTimeoutInstance = null;\n                    return ko.dependentObservable({\n                        'read': target,\n                        'write': function(value) {\n                            clearTimeout(writeTimeoutInstance);\n                            writeTimeoutInstance = ko.utils.setTimeout(function() {\n                                target(value);\n                            }, timeout);\n                        }\n                    });\n                },\n\n                'rateLimit': function(target, options) {\n                    var timeout, method, limitFunction;\n\n                    if (typeof options == 'number') {\n                        timeout = options;\n                    } else {\n                        timeout = options['timeout'];\n                        method = options['method'];\n                    }\n\n                    // rateLimit supersedes deferred updates\n                    target._deferUpdates = false;\n\n                    limitFunction = typeof method == 'function' ? method : method == 'notifyWhenChangesStop' ?  debounce : throttle;\n                    target.limit(function(callback) {\n                        return limitFunction(callback, timeout, options);\n                    });\n                },\n\n                'deferred': function(target, options) {\n                    if (options !== true) {\n                        throw new Error('The \\'deferred\\' extender only accepts the value \\'true\\', because it is not supported to turn deferral off once enabled.')\n                    }\n\n                    if (!target._deferUpdates) {\n                        target._deferUpdates = true;\n                        target.limit(function (callback) {\n                            var handle,\n                                ignoreUpdates = false;\n                            return function () {\n                                if (!ignoreUpdates) {\n                                    ko.tasks.cancel(handle);\n                                    handle = ko.tasks.schedule(callback);\n\n                                    try {\n                                        ignoreUpdates = true;\n                                        target['notifySubscribers'](undefined, 'dirty');\n                                    } finally {\n                                        ignoreUpdates = false;\n                                    }\n                                }\n                            };\n                        });\n                    }\n                },\n\n                'notify': function(target, notifyWhen) {\n                    target[\"equalityComparer\"] = notifyWhen == \"always\" ?\n                        null :  // null equalityComparer means to always notify\n                        valuesArePrimitiveAndEqual;\n                }\n            };\n\n            var primitiveTypes = { 'undefined':1, 'boolean':1, 'number':1, 'string':1 };\n            function valuesArePrimitiveAndEqual(a, b) {\n                var oldValueIsPrimitive = (a === null) || (typeof(a) in primitiveTypes);\n                return oldValueIsPrimitive ? (a === b) : false;\n            }\n\n            function throttle(callback, timeout) {\n                var timeoutInstance;\n                return function () {\n                    if (!timeoutInstance) {\n                        timeoutInstance = ko.utils.setTimeout(function () {\n                            timeoutInstance = undefined;\n                            callback();\n                        }, timeout);\n                    }\n                };\n            }\n\n            function debounce(callback, timeout) {\n                var timeoutInstance;\n                return function () {\n                    clearTimeout(timeoutInstance);\n                    timeoutInstance = ko.utils.setTimeout(callback, timeout);\n                };\n            }\n\n            function applyExtenders(requestedExtenders) {\n                var target = this;\n                if (requestedExtenders) {\n                    ko.utils.objectForEach(requestedExtenders, function(key, value) {\n                        var extenderHandler = ko.extenders[key];\n                        if (typeof extenderHandler == 'function') {\n                            target = extenderHandler(target, value) || target;\n                        }\n                    });\n                }\n                return target;\n            }\n\n            ko.exportSymbol('extenders', ko.extenders);\n\n            ko.subscription = function (target, callback, disposeCallback) {\n                this._target = target;\n                this._callback = callback;\n                this._disposeCallback = disposeCallback;\n                this._isDisposed = false;\n                this._node = null;\n                this._domNodeDisposalCallback = null;\n                ko.exportProperty(this, 'dispose', this.dispose);\n                ko.exportProperty(this, 'disposeWhenNodeIsRemoved', this.disposeWhenNodeIsRemoved);\n            };\n            ko.subscription.prototype.dispose = function () {\n                var self = this;\n                if (!self._isDisposed) {\n                    if (self._domNodeDisposalCallback) {\n                        ko.utils.domNodeDisposal.removeDisposeCallback(self._node, self._domNodeDisposalCallback);\n                    }\n                    self._isDisposed = true;\n                    self._disposeCallback();\n\n                    self._target = self._callback = self._disposeCallback = self._node = self._domNodeDisposalCallback = null;\n                }\n            };\n            ko.subscription.prototype.disposeWhenNodeIsRemoved = function (node) {\n                this._node = node;\n                ko.utils.domNodeDisposal.addDisposeCallback(node, this._domNodeDisposalCallback = this.dispose.bind(this));\n            };\n\n            ko.subscribable = function () {\n                ko.utils.setPrototypeOfOrExtend(this, ko_subscribable_fn);\n                ko_subscribable_fn.init(this);\n            }\n\n            var defaultEvent = \"change\";\n\n// Moved out of \"limit\" to avoid the extra closure\n            function limitNotifySubscribers(value, event) {\n                if (!event || event === defaultEvent) {\n                    this._limitChange(value);\n                } else if (event === 'beforeChange') {\n                    this._limitBeforeChange(value);\n                } else {\n                    this._origNotifySubscribers(value, event);\n                }\n            }\n\n            var ko_subscribable_fn = {\n                init: function(instance) {\n                    instance._subscriptions = { \"change\": [] };\n                    instance._versionNumber = 1;\n                },\n\n                subscribe: function (callback, callbackTarget, event) {\n                    var self = this;\n\n                    event = event || defaultEvent;\n                    var boundCallback = callbackTarget ? callback.bind(callbackTarget) : callback;\n\n                    var subscription = new ko.subscription(self, boundCallback, function () {\n                        ko.utils.arrayRemoveItem(self._subscriptions[event], subscription);\n                        if (self.afterSubscriptionRemove)\n                            self.afterSubscriptionRemove(event);\n                    });\n\n                    if (self.beforeSubscriptionAdd)\n                        self.beforeSubscriptionAdd(event);\n\n                    if (!self._subscriptions[event])\n                        self._subscriptions[event] = [];\n                    self._subscriptions[event].push(subscription);\n\n                    return subscription;\n                },\n\n                \"notifySubscribers\": function (valueToNotify, event) {\n                    event = event || defaultEvent;\n                    if (event === defaultEvent) {\n                        this.updateVersion();\n                    }\n                    if (this.hasSubscriptionsForEvent(event)) {\n                        var subs = event === defaultEvent && this._changeSubscriptions || this._subscriptions[event].slice(0);\n                        try {\n                            ko.dependencyDetection.begin(); // Begin suppressing dependency detection (by setting the top frame to undefined)\n                            for (var i = 0, subscription; subscription = subs[i]; ++i) {\n                                // In case a subscription was disposed during the arrayForEach cycle, check\n                                // for isDisposed on each subscription before invoking its callback\n                                if (!subscription._isDisposed)\n                                    subscription._callback(valueToNotify);\n                            }\n                        } finally {\n                            ko.dependencyDetection.end(); // End suppressing dependency detection\n                        }\n                    }\n                },\n\n                getVersion: function () {\n                    return this._versionNumber;\n                },\n\n                hasChanged: function (versionToCheck) {\n                    return this.getVersion() !== versionToCheck;\n                },\n\n                updateVersion: function () {\n                    ++this._versionNumber;\n                },\n\n                limit: function(limitFunction) {\n                    var self = this, selfIsObservable = ko.isObservable(self),\n                        ignoreBeforeChange, notifyNextChange, previousValue, pendingValue, didUpdate,\n                        beforeChange = 'beforeChange';\n\n                    if (!self._origNotifySubscribers) {\n                        self._origNotifySubscribers = self[\"notifySubscribers\"];\n                        self[\"notifySubscribers\"] = limitNotifySubscribers;\n                    }\n\n                    var finish = limitFunction(function() {\n                        self._notificationIsPending = false;\n\n                        // If an observable provided a reference to itself, access it to get the latest value.\n                        // This allows computed observables to delay calculating their value until needed.\n                        if (selfIsObservable && pendingValue === self) {\n                            pendingValue = self._evalIfChanged ? self._evalIfChanged() : self();\n                        }\n                        var shouldNotify = notifyNextChange || (didUpdate && self.isDifferent(previousValue, pendingValue));\n\n                        didUpdate = notifyNextChange = ignoreBeforeChange = false;\n\n                        if (shouldNotify) {\n                            self._origNotifySubscribers(previousValue = pendingValue);\n                        }\n                    });\n\n                    self._limitChange = function(value, isDirty) {\n                        if (!isDirty || !self._notificationIsPending) {\n                            didUpdate = !isDirty;\n                        }\n                        self._changeSubscriptions = self._subscriptions[defaultEvent].slice(0);\n                        self._notificationIsPending = ignoreBeforeChange = true;\n                        pendingValue = value;\n                        finish();\n                    };\n                    self._limitBeforeChange = function(value) {\n                        if (!ignoreBeforeChange) {\n                            previousValue = value;\n                            self._origNotifySubscribers(value, beforeChange);\n                        }\n                    };\n                    self._recordUpdate = function() {\n                        didUpdate = true;\n                    };\n                    self._notifyNextChangeIfValueIsDifferent = function() {\n                        if (self.isDifferent(previousValue, self.peek(true /*evaluate*/))) {\n                            notifyNextChange = true;\n                        }\n                    };\n                },\n\n                hasSubscriptionsForEvent: function(event) {\n                    return this._subscriptions[event] && this._subscriptions[event].length;\n                },\n\n                getSubscriptionsCount: function (event) {\n                    if (event) {\n                        return this._subscriptions[event] && this._subscriptions[event].length || 0;\n                    } else {\n                        var total = 0;\n                        ko.utils.objectForEach(this._subscriptions, function(eventName, subscriptions) {\n                            if (eventName !== 'dirty')\n                                total += subscriptions.length;\n                        });\n                        return total;\n                    }\n                },\n\n                isDifferent: function(oldValue, newValue) {\n                    return !this['equalityComparer'] || !this['equalityComparer'](oldValue, newValue);\n                },\n\n                toString: function() {\n                    return '[object Object]'\n                },\n\n                extend: applyExtenders\n            };\n\n            ko.exportProperty(ko_subscribable_fn, 'init', ko_subscribable_fn.init);\n            ko.exportProperty(ko_subscribable_fn, 'subscribe', ko_subscribable_fn.subscribe);\n            ko.exportProperty(ko_subscribable_fn, 'extend', ko_subscribable_fn.extend);\n            ko.exportProperty(ko_subscribable_fn, 'getSubscriptionsCount', ko_subscribable_fn.getSubscriptionsCount);\n\n// For browsers that support proto assignment, we overwrite the prototype of each\n// observable instance. Since observables are functions, we need Function.prototype\n// to still be in the prototype chain.\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(ko_subscribable_fn, Function.prototype);\n            }\n\n            ko.subscribable['fn'] = ko_subscribable_fn;\n\n\n            ko.isSubscribable = function (instance) {\n                return instance != null && typeof instance.subscribe == \"function\" && typeof instance[\"notifySubscribers\"] == \"function\";\n            };\n\n            ko.exportSymbol('subscribable', ko.subscribable);\n            ko.exportSymbol('isSubscribable', ko.isSubscribable);\n\n            ko.computedContext = ko.dependencyDetection = (function () {\n                var outerFrames = [],\n                    currentFrame,\n                    lastId = 0;\n\n                // Return a unique ID that can be assigned to an observable for dependency tracking.\n                // Theoretically, you could eventually overflow the number storage size, resulting\n                // in duplicate IDs. But in JavaScript, the largest exact integral value is 2^53\n                // or 9,007,199,254,740,992. If you created 1,000,000 IDs per second, it would\n                // take over 285 years to reach that number.\n                // Reference http://blog.vjeux.com/2010/javascript/javascript-max_int-number-limits.html\n                function getId() {\n                    return ++lastId;\n                }\n\n                function begin(options) {\n                    outerFrames.push(currentFrame);\n                    currentFrame = options;\n                }\n\n                function end() {\n                    currentFrame = outerFrames.pop();\n                }\n\n                return {\n                    begin: begin,\n\n                    end: end,\n\n                    registerDependency: function (subscribable) {\n                        if (currentFrame) {\n                            if (!ko.isSubscribable(subscribable))\n                                throw new Error(\"Only subscribable things can act as dependencies\");\n                            currentFrame.callback.call(currentFrame.callbackTarget, subscribable, subscribable._id || (subscribable._id = getId()));\n                        }\n                    },\n\n                    ignore: function (callback, callbackTarget, callbackArgs) {\n                        try {\n                            begin();\n                            return callback.apply(callbackTarget, callbackArgs || []);\n                        } finally {\n                            end();\n                        }\n                    },\n\n                    getDependenciesCount: function () {\n                        if (currentFrame)\n                            return currentFrame.computed.getDependenciesCount();\n                    },\n\n                    getDependencies: function () {\n                        if (currentFrame)\n                            return currentFrame.computed.getDependencies();\n                    },\n\n                    isInitial: function() {\n                        if (currentFrame)\n                            return currentFrame.isInitial;\n                    },\n\n                    computed: function() {\n                        if (currentFrame)\n                            return currentFrame.computed;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('computedContext', ko.computedContext);\n            ko.exportSymbol('computedContext.getDependenciesCount', ko.computedContext.getDependenciesCount);\n            ko.exportSymbol('computedContext.getDependencies', ko.computedContext.getDependencies);\n            ko.exportSymbol('computedContext.isInitial', ko.computedContext.isInitial);\n            ko.exportSymbol('computedContext.registerDependency', ko.computedContext.registerDependency);\n\n            ko.exportSymbol('ignoreDependencies', ko.ignoreDependencies = ko.dependencyDetection.ignore);\n            var observableLatestValue = ko.utils.createSymbolOrString('_latestValue');\n\n            ko.observable = function (initialValue) {\n                function observable() {\n                    if (arguments.length > 0) {\n                        // Write\n\n                        // Ignore writes if the value hasn't changed\n                        if (observable.isDifferent(observable[observableLatestValue], arguments[0])) {\n                            observable.valueWillMutate();\n                            observable[observableLatestValue] = arguments[0];\n                            observable.valueHasMutated();\n                        }\n                        return this; // Permits chained assignments\n                    }\n                    else {\n                        // Read\n                        ko.dependencyDetection.registerDependency(observable); // The caller only needs to be notified of changes if they did a \"read\" operation\n                        return observable[observableLatestValue];\n                    }\n                }\n\n                observable[observableLatestValue] = initialValue;\n\n                // Inherit from 'subscribable'\n                if (!ko.utils.canSetPrototype) {\n                    // 'subscribable' won't be on the prototype chain unless we put it there directly\n                    ko.utils.extend(observable, ko.subscribable['fn']);\n                }\n                ko.subscribable['fn'].init(observable);\n\n                // Inherit from 'observable'\n                ko.utils.setPrototypeOfOrExtend(observable, observableFn);\n\n                if (ko.options['deferUpdates']) {\n                    ko.extenders['deferred'](observable, true);\n                }\n\n                return observable;\n            }\n\n// Define prototype for observables\n            var observableFn = {\n                'equalityComparer': valuesArePrimitiveAndEqual,\n                peek: function() { return this[observableLatestValue]; },\n                valueHasMutated: function () {\n                    this['notifySubscribers'](this[observableLatestValue], 'spectate');\n                    this['notifySubscribers'](this[observableLatestValue]);\n                },\n                valueWillMutate: function () { this['notifySubscribers'](this[observableLatestValue], 'beforeChange'); }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observable constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(observableFn, ko.subscribable['fn']);\n            }\n\n            var protoProperty = ko.observable.protoProperty = '__ko_proto__';\n            observableFn[protoProperty] = ko.observable;\n\n            ko.isObservable = function (instance) {\n                var proto = typeof instance == 'function' && instance[protoProperty];\n                if (proto && proto !== observableFn[protoProperty] && proto !== ko.computed['fn'][protoProperty]) {\n                    throw Error(\"Invalid object that looks like an observable; possibly from another Knockout instance\");\n                }\n                return !!proto;\n            };\n\n            ko.isWriteableObservable = function (instance) {\n                return (typeof instance == 'function' && (\n                    (instance[protoProperty] === observableFn[protoProperty]) ||  // Observable\n                    (instance[protoProperty] === ko.computed['fn'][protoProperty] && instance.hasWriteFunction)));   // Writable computed observable\n            };\n\n            ko.exportSymbol('observable', ko.observable);\n            ko.exportSymbol('isObservable', ko.isObservable);\n            ko.exportSymbol('isWriteableObservable', ko.isWriteableObservable);\n            ko.exportSymbol('isWritableObservable', ko.isWriteableObservable);\n            ko.exportSymbol('observable.fn', observableFn);\n            ko.exportProperty(observableFn, 'peek', observableFn.peek);\n            ko.exportProperty(observableFn, 'valueHasMutated', observableFn.valueHasMutated);\n            ko.exportProperty(observableFn, 'valueWillMutate', observableFn.valueWillMutate);\n            ko.observableArray = function (initialValues) {\n                initialValues = initialValues || [];\n\n                if (typeof initialValues != 'object' || !('length' in initialValues))\n                    throw new Error(\"The argument passed when initializing an observable array must be an array, or null, or undefined.\");\n\n                var result = ko.observable(initialValues);\n                ko.utils.setPrototypeOfOrExtend(result, ko.observableArray['fn']);\n                return result.extend({'trackArrayChanges':true});\n            };\n\n            ko.observableArray['fn'] = {\n                'remove': function (valueOrPredicate) {\n                    var underlyingArray = this.peek();\n                    var removedValues = [];\n                    var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n                    for (var i = 0; i < underlyingArray.length; i++) {\n                        var value = underlyingArray[i];\n                        if (predicate(value)) {\n                            if (removedValues.length === 0) {\n                                this.valueWillMutate();\n                            }\n                            if (underlyingArray[i] !== value) {\n                                throw Error(\"Array modified during remove; cannot remove item\");\n                            }\n                            removedValues.push(value);\n                            underlyingArray.splice(i, 1);\n                            i--;\n                        }\n                    }\n                    if (removedValues.length) {\n                        this.valueHasMutated();\n                    }\n                    return removedValues;\n                },\n\n                'removeAll': function (arrayOfValues) {\n                    // If you passed zero args, we remove everything\n                    if (arrayOfValues === undefined) {\n                        var underlyingArray = this.peek();\n                        var allValues = underlyingArray.slice(0);\n                        this.valueWillMutate();\n                        underlyingArray.splice(0, underlyingArray.length);\n                        this.valueHasMutated();\n                        return allValues;\n                    }\n                    // If you passed an arg, we interpret it as an array of entries to remove\n                    if (!arrayOfValues)\n                        return [];\n                    return this['remove'](function (value) {\n                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n                    });\n                },\n\n                'destroy': function (valueOrPredicate) {\n                    var underlyingArray = this.peek();\n                    var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n                    this.valueWillMutate();\n                    for (var i = underlyingArray.length - 1; i >= 0; i--) {\n                        var value = underlyingArray[i];\n                        if (predicate(value))\n                            value[\"_destroy\"] = true;\n                    }\n                    this.valueHasMutated();\n                },\n\n                'destroyAll': function (arrayOfValues) {\n                    // If you passed zero args, we destroy everything\n                    if (arrayOfValues === undefined)\n                        return this['destroy'](function() { return true });\n\n                    // If you passed an arg, we interpret it as an array of entries to destroy\n                    if (!arrayOfValues)\n                        return [];\n                    return this['destroy'](function (value) {\n                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n                    });\n                },\n\n                'indexOf': function (item) {\n                    var underlyingArray = this();\n                    return ko.utils.arrayIndexOf(underlyingArray, item);\n                },\n\n                'replace': function(oldItem, newItem) {\n                    var index = this['indexOf'](oldItem);\n                    if (index >= 0) {\n                        this.valueWillMutate();\n                        this.peek()[index] = newItem;\n                        this.valueHasMutated();\n                    }\n                },\n\n                'sorted': function (compareFunction) {\n                    var arrayCopy = this().slice(0);\n                    return compareFunction ? arrayCopy.sort(compareFunction) : arrayCopy.sort();\n                },\n\n                'reversed': function () {\n                    return this().slice(0).reverse();\n                }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observableArray constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(ko.observableArray['fn'], ko.observable['fn']);\n            }\n\n// Populate ko.observableArray.fn with read/write functions from native arrays\n// Important: Do not add any additional functions here that may reasonably be used to *read* data from the array\n// because we'll eval them without causing subscriptions, so ko.computed output could end up getting stale\n            ko.utils.arrayForEach([\"pop\", \"push\", \"reverse\", \"shift\", \"sort\", \"splice\", \"unshift\"], function (methodName) {\n                ko.observableArray['fn'][methodName] = function () {\n                    // Use \"peek\" to avoid creating a subscription in any computed that we're executing in the context of\n                    // (for consistency with mutating regular observables)\n                    var underlyingArray = this.peek();\n                    this.valueWillMutate();\n                    this.cacheDiffForKnownOperation(underlyingArray, methodName, arguments);\n                    var methodCallResult = underlyingArray[methodName].apply(underlyingArray, arguments);\n                    this.valueHasMutated();\n                    // The native sort and reverse methods return a reference to the array, but it makes more sense to return the observable array instead.\n                    return methodCallResult === underlyingArray ? this : methodCallResult;\n                };\n            });\n\n// Populate ko.observableArray.fn with read-only functions from native arrays\n            ko.utils.arrayForEach([\"slice\"], function (methodName) {\n                ko.observableArray['fn'][methodName] = function () {\n                    var underlyingArray = this();\n                    return underlyingArray[methodName].apply(underlyingArray, arguments);\n                };\n            });\n\n            ko.isObservableArray = function (instance) {\n                return ko.isObservable(instance)\n                    && typeof instance[\"remove\"] == \"function\"\n                    && typeof instance[\"push\"] == \"function\";\n            };\n\n            ko.exportSymbol('observableArray', ko.observableArray);\n            ko.exportSymbol('isObservableArray', ko.isObservableArray);\n            var arrayChangeEventName = 'arrayChange';\n            ko.extenders['trackArrayChanges'] = function(target, options) {\n                // Use the provided options--each call to trackArrayChanges overwrites the previously set options\n                target.compareArrayOptions = {};\n                if (options && typeof options == \"object\") {\n                    ko.utils.extend(target.compareArrayOptions, options);\n                }\n                target.compareArrayOptions['sparse'] = true;\n\n                // Only modify the target observable once\n                if (target.cacheDiffForKnownOperation) {\n                    return;\n                }\n                var trackingChanges = false,\n                    cachedDiff = null,\n                    changeSubscription,\n                    spectateSubscription,\n                    pendingChanges = 0,\n                    previousContents,\n                    underlyingBeforeSubscriptionAddFunction = target.beforeSubscriptionAdd,\n                    underlyingAfterSubscriptionRemoveFunction = target.afterSubscriptionRemove;\n\n                // Watch \"subscribe\" calls, and for array change events, ensure change tracking is enabled\n                target.beforeSubscriptionAdd = function (event) {\n                    if (underlyingBeforeSubscriptionAddFunction) {\n                        underlyingBeforeSubscriptionAddFunction.call(target, event);\n                    }\n                    if (event === arrayChangeEventName) {\n                        trackChanges();\n                    }\n                };\n                // Watch \"dispose\" calls, and for array change events, ensure change tracking is disabled when all are disposed\n                target.afterSubscriptionRemove = function (event) {\n                    if (underlyingAfterSubscriptionRemoveFunction) {\n                        underlyingAfterSubscriptionRemoveFunction.call(target, event);\n                    }\n                    if (event === arrayChangeEventName && !target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                        if (changeSubscription) {\n                            changeSubscription.dispose();\n                        }\n                        if (spectateSubscription) {\n                            spectateSubscription.dispose();\n                        }\n                        spectateSubscription = changeSubscription = null;\n                        trackingChanges = false;\n                        previousContents = undefined;\n                    }\n                };\n\n                function trackChanges() {\n                    if (trackingChanges) {\n                        // Whenever there's a new subscription and there are pending notifications, make sure all previous\n                        // subscriptions are notified of the change so that all subscriptions are in sync.\n                        notifyChanges();\n                        return;\n                    }\n\n                    trackingChanges = true;\n\n                    // Track how many times the array actually changed value\n                    spectateSubscription = target.subscribe(function () {\n                        ++pendingChanges;\n                    }, null, \"spectate\");\n\n                    // Each time the array changes value, capture a clone so that on the next\n                    // change it's possible to produce a diff\n                    previousContents = [].concat(target.peek() || []);\n                    cachedDiff = null;\n                    changeSubscription = target.subscribe(notifyChanges);\n\n                    function notifyChanges() {\n                        if (pendingChanges) {\n                            // Make a copy of the current contents and ensure it's an array\n                            var currentContents = [].concat(target.peek() || []), changes;\n\n                            // Compute the diff and issue notifications, but only if someone is listening\n                            if (target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                                changes = getChanges(previousContents, currentContents);\n                            }\n\n                            // Eliminate references to the old, removed items, so they can be GCed\n                            previousContents = currentContents;\n                            cachedDiff = null;\n                            pendingChanges = 0;\n\n                            if (changes && changes.length) {\n                                target['notifySubscribers'](changes, arrayChangeEventName);\n                            }\n                        }\n                    }\n                }\n\n                function getChanges(previousContents, currentContents) {\n                    // We try to re-use cached diffs.\n                    // The scenarios where pendingChanges > 1 are when using rate limiting or deferred updates,\n                    // which without this check would not be compatible with arrayChange notifications. Normally,\n                    // notifications are issued immediately so we wouldn't be queueing up more than one.\n                    if (!cachedDiff || pendingChanges > 1) {\n                        cachedDiff = ko.utils.compareArrays(previousContents, currentContents, target.compareArrayOptions);\n                    }\n\n                    return cachedDiff;\n                }\n\n                target.cacheDiffForKnownOperation = function(rawArray, operationName, args) {\n                    // Only run if we're currently tracking changes for this observable array\n                    // and there aren't any pending deferred notifications.\n                    if (!trackingChanges || pendingChanges) {\n                        return;\n                    }\n                    var diff = [],\n                        arrayLength = rawArray.length,\n                        argsLength = args.length,\n                        offset = 0;\n\n                    function pushDiff(status, value, index) {\n                        return diff[diff.length] = { 'status': status, 'value': value, 'index': index };\n                    }\n                    switch (operationName) {\n                        case 'push':\n                            offset = arrayLength;\n                        case 'unshift':\n                            for (var index = 0; index < argsLength; index++) {\n                                pushDiff('added', args[index], offset + index);\n                            }\n                            break;\n\n                        case 'pop':\n                            offset = arrayLength - 1;\n                        case 'shift':\n                            if (arrayLength) {\n                                pushDiff('deleted', rawArray[offset], offset);\n                            }\n                            break;\n\n                        case 'splice':\n                            // Negative start index means 'from end of array'. After that we clamp to [0...arrayLength].\n                            // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice\n                            var startIndex = Math.min(Math.max(0, args[0] < 0 ? arrayLength + args[0] : args[0]), arrayLength),\n                                endDeleteIndex = argsLength === 1 ? arrayLength : Math.min(startIndex + (args[1] || 0), arrayLength),\n                                endAddIndex = startIndex + argsLength - 2,\n                                endIndex = Math.max(endDeleteIndex, endAddIndex),\n                                additions = [], deletions = [];\n                            for (var index = startIndex, argsIndex = 2; index < endIndex; ++index, ++argsIndex) {\n                                if (index < endDeleteIndex)\n                                    deletions.push(pushDiff('deleted', rawArray[index], index));\n                                if (index < endAddIndex)\n                                    additions.push(pushDiff('added', args[argsIndex], index));\n                            }\n                            ko.utils.findMovesInArrayComparison(deletions, additions);\n                            break;\n\n                        default:\n                            return;\n                    }\n                    cachedDiff = diff;\n                };\n            };\n            var computedState = ko.utils.createSymbolOrString('_state');\n\n            ko.computed = ko.dependentObservable = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget, options) {\n                if (typeof evaluatorFunctionOrOptions === \"object\") {\n                    // Single-parameter syntax - everything is on this \"options\" param\n                    options = evaluatorFunctionOrOptions;\n                } else {\n                    // Multi-parameter syntax - construct the options according to the params passed\n                    options = options || {};\n                    if (evaluatorFunctionOrOptions) {\n                        options[\"read\"] = evaluatorFunctionOrOptions;\n                    }\n                }\n                if (typeof options[\"read\"] != \"function\")\n                    throw Error(\"Pass a function that returns the value of the ko.computed\");\n\n                var writeFunction = options[\"write\"];\n                var state = {\n                    latestValue: undefined,\n                    isStale: true,\n                    isDirty: true,\n                    isBeingEvaluated: false,\n                    suppressDisposalUntilDisposeWhenReturnsFalse: false,\n                    isDisposed: false,\n                    pure: false,\n                    isSleeping: false,\n                    readFunction: options[\"read\"],\n                    evaluatorFunctionTarget: evaluatorFunctionTarget || options[\"owner\"],\n                    disposeWhenNodeIsRemoved: options[\"disposeWhenNodeIsRemoved\"] || options.disposeWhenNodeIsRemoved || null,\n                    disposeWhen: options[\"disposeWhen\"] || options.disposeWhen,\n                    domNodeDisposalCallback: null,\n                    dependencyTracking: {},\n                    dependenciesCount: 0,\n                    evaluationTimeoutInstance: null\n                };\n\n                function computedObservable() {\n                    if (arguments.length > 0) {\n                        if (typeof writeFunction === \"function\") {\n                            // Writing a value\n                            writeFunction.apply(state.evaluatorFunctionTarget, arguments);\n                        } else {\n                            throw new Error(\"Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.\");\n                        }\n                        return this; // Permits chained assignments\n                    } else {\n                        // Reading the value\n                        if (!state.isDisposed) {\n                            ko.dependencyDetection.registerDependency(computedObservable);\n                        }\n                        if (state.isDirty || (state.isSleeping && computedObservable.haveDependenciesChanged())) {\n                            computedObservable.evaluateImmediate();\n                        }\n                        return state.latestValue;\n                    }\n                }\n\n                computedObservable[computedState] = state;\n                computedObservable.hasWriteFunction = typeof writeFunction === \"function\";\n\n                // Inherit from 'subscribable'\n                if (!ko.utils.canSetPrototype) {\n                    // 'subscribable' won't be on the prototype chain unless we put it there directly\n                    ko.utils.extend(computedObservable, ko.subscribable['fn']);\n                }\n                ko.subscribable['fn'].init(computedObservable);\n\n                // Inherit from 'computed'\n                ko.utils.setPrototypeOfOrExtend(computedObservable, computedFn);\n\n                if (options['pure']) {\n                    state.pure = true;\n                    state.isSleeping = true;     // Starts off sleeping; will awake on the first subscription\n                    ko.utils.extend(computedObservable, pureComputedOverrides);\n                } else if (options['deferEvaluation']) {\n                    ko.utils.extend(computedObservable, deferEvaluationOverrides);\n                }\n\n                if (ko.options['deferUpdates']) {\n                    ko.extenders['deferred'](computedObservable, true);\n                }\n\n                if (DEBUG) {\n                    // #1731 - Aid debugging by exposing the computed's options\n                    computedObservable[\"_options\"] = options;\n                }\n\n                if (state.disposeWhenNodeIsRemoved) {\n                    // Since this computed is associated with a DOM node, and we don't want to dispose the computed\n                    // until the DOM node is *removed* from the document (as opposed to never having been in the document),\n                    // we'll prevent disposal until \"disposeWhen\" first returns false.\n                    state.suppressDisposalUntilDisposeWhenReturnsFalse = true;\n\n                    // disposeWhenNodeIsRemoved: true can be used to opt into the \"only dispose after first false result\"\n                    // behaviour even if there's no specific node to watch. In that case, clear the option so we don't try\n                    // to watch for a non-node's disposal. This technique is intended for KO's internal use only and shouldn't\n                    // be documented or used by application code, as it's likely to change in a future version of KO.\n                    if (!state.disposeWhenNodeIsRemoved.nodeType) {\n                        state.disposeWhenNodeIsRemoved = null;\n                    }\n                }\n\n                // Evaluate, unless sleeping or deferEvaluation is true\n                if (!state.isSleeping && !options['deferEvaluation']) {\n                    computedObservable.evaluateImmediate();\n                }\n\n                // Attach a DOM node disposal callback so that the computed will be proactively disposed as soon as the node is\n                // removed using ko.removeNode. But skip if isActive is false (there will never be any dependencies to dispose).\n                if (state.disposeWhenNodeIsRemoved && computedObservable.isActive()) {\n                    ko.utils.domNodeDisposal.addDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback = function () {\n                        computedObservable.dispose();\n                    });\n                }\n\n                return computedObservable;\n            };\n\n// Utility function that disposes a given dependencyTracking entry\n            function computedDisposeDependencyCallback(id, entryToDispose) {\n                if (entryToDispose !== null && entryToDispose.dispose) {\n                    entryToDispose.dispose();\n                }\n            }\n\n// This function gets called each time a dependency is detected while evaluating a computed.\n// It's factored out as a shared function to avoid creating unnecessary function instances during evaluation.\n            function computedBeginDependencyDetectionCallback(subscribable, id) {\n                var computedObservable = this.computedObservable,\n                    state = computedObservable[computedState];\n                if (!state.isDisposed) {\n                    if (this.disposalCount && this.disposalCandidates[id]) {\n                        // Don't want to dispose this subscription, as it's still being used\n                        computedObservable.addDependencyTracking(id, subscribable, this.disposalCandidates[id]);\n                        this.disposalCandidates[id] = null; // No need to actually delete the property - disposalCandidates is a transient object anyway\n                        --this.disposalCount;\n                    } else if (!state.dependencyTracking[id]) {\n                        // Brand new subscription - add it\n                        computedObservable.addDependencyTracking(id, subscribable, state.isSleeping ? { _target: subscribable } : computedObservable.subscribeToDependency(subscribable));\n                    }\n                    // If the observable we've accessed has a pending notification, ensure we get notified of the actual final value (bypass equality checks)\n                    if (subscribable._notificationIsPending) {\n                        subscribable._notifyNextChangeIfValueIsDifferent();\n                    }\n                }\n            }\n\n            var computedFn = {\n                \"equalityComparer\": valuesArePrimitiveAndEqual,\n                getDependenciesCount: function () {\n                    return this[computedState].dependenciesCount;\n                },\n                getDependencies: function () {\n                    var dependencyTracking = this[computedState].dependencyTracking, dependentObservables = [];\n\n                    ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                        dependentObservables[dependency._order] = dependency._target;\n                    });\n\n                    return dependentObservables;\n                },\n                hasAncestorDependency: function (obs) {\n                    if (!this[computedState].dependenciesCount) {\n                        return false;\n                    }\n                    var dependencies = this.getDependencies();\n                    if (ko.utils.arrayIndexOf(dependencies, obs) !== -1) {\n                        return true;\n                    }\n                    return !!ko.utils.arrayFirst(dependencies, function (dep) {\n                        return dep.hasAncestorDependency && dep.hasAncestorDependency(obs);\n                    });\n                },\n                addDependencyTracking: function (id, target, trackingObj) {\n                    if (this[computedState].pure && target === this) {\n                        throw Error(\"A 'pure' computed must not be called recursively\");\n                    }\n\n                    this[computedState].dependencyTracking[id] = trackingObj;\n                    trackingObj._order = this[computedState].dependenciesCount++;\n                    trackingObj._version = target.getVersion();\n                },\n                haveDependenciesChanged: function () {\n                    var id, dependency, dependencyTracking = this[computedState].dependencyTracking;\n                    for (id in dependencyTracking) {\n                        if (Object.prototype.hasOwnProperty.call(dependencyTracking, id)) {\n                            dependency = dependencyTracking[id];\n                            if ((this._evalDelayed && dependency._target._notificationIsPending) || dependency._target.hasChanged(dependency._version)) {\n                                return true;\n                            }\n                        }\n                    }\n                },\n                markDirty: function () {\n                    // Process \"dirty\" events if we can handle delayed notifications\n                    if (this._evalDelayed && !this[computedState].isBeingEvaluated) {\n                        this._evalDelayed(false /*isChange*/);\n                    }\n                },\n                isActive: function () {\n                    var state = this[computedState];\n                    return state.isDirty || state.dependenciesCount > 0;\n                },\n                respondToChange: function () {\n                    // Ignore \"change\" events if we've already scheduled a delayed notification\n                    if (!this._notificationIsPending) {\n                        this.evaluatePossiblyAsync();\n                    } else if (this[computedState].isDirty) {\n                        this[computedState].isStale = true;\n                    }\n                },\n                subscribeToDependency: function (target) {\n                    if (target._deferUpdates) {\n                        var dirtySub = target.subscribe(this.markDirty, this, 'dirty'),\n                            changeSub = target.subscribe(this.respondToChange, this);\n                        return {\n                            _target: target,\n                            dispose: function () {\n                                dirtySub.dispose();\n                                changeSub.dispose();\n                            }\n                        };\n                    } else {\n                        return target.subscribe(this.evaluatePossiblyAsync, this);\n                    }\n                },\n                evaluatePossiblyAsync: function () {\n                    var computedObservable = this,\n                        throttleEvaluationTimeout = computedObservable['throttleEvaluation'];\n                    if (throttleEvaluationTimeout && throttleEvaluationTimeout >= 0) {\n                        clearTimeout(this[computedState].evaluationTimeoutInstance);\n                        this[computedState].evaluationTimeoutInstance = ko.utils.setTimeout(function () {\n                            computedObservable.evaluateImmediate(true /*notifyChange*/);\n                        }, throttleEvaluationTimeout);\n                    } else if (computedObservable._evalDelayed) {\n                        computedObservable._evalDelayed(true /*isChange*/);\n                    } else {\n                        computedObservable.evaluateImmediate(true /*notifyChange*/);\n                    }\n                },\n                evaluateImmediate: function (notifyChange) {\n                    var computedObservable = this,\n                        state = computedObservable[computedState],\n                        disposeWhen = state.disposeWhen,\n                        changed = false;\n\n                    if (state.isBeingEvaluated) {\n                        // If the evaluation of a ko.computed causes side effects, it's possible that it will trigger its own re-evaluation.\n                        // This is not desirable (it's hard for a developer to realise a chain of dependencies might cause this, and they almost\n                        // certainly didn't intend infinite re-evaluations). So, for predictability, we simply prevent ko.computeds from causing\n                        // their own re-evaluation. Further discussion at https://github.com/SteveSanderson/knockout/pull/387\n                        return;\n                    }\n\n                    // Do not evaluate (and possibly capture new dependencies) if disposed\n                    if (state.isDisposed) {\n                        return;\n                    }\n\n                    if (state.disposeWhenNodeIsRemoved && !ko.utils.domNodeIsAttachedToDocument(state.disposeWhenNodeIsRemoved) || disposeWhen && disposeWhen()) {\n                        // See comment above about suppressDisposalUntilDisposeWhenReturnsFalse\n                        if (!state.suppressDisposalUntilDisposeWhenReturnsFalse) {\n                            computedObservable.dispose();\n                            return;\n                        }\n                    } else {\n                        // It just did return false, so we can stop suppressing now\n                        state.suppressDisposalUntilDisposeWhenReturnsFalse = false;\n                    }\n\n                    state.isBeingEvaluated = true;\n                    try {\n                        changed = this.evaluateImmediate_CallReadWithDependencyDetection(notifyChange);\n                    } finally {\n                        state.isBeingEvaluated = false;\n                    }\n\n                    return changed;\n                },\n                evaluateImmediate_CallReadWithDependencyDetection: function (notifyChange) {\n                    // This function is really just part of the evaluateImmediate logic. You would never call it from anywhere else.\n                    // Factoring it out into a separate function means it can be independent of the try/catch block in evaluateImmediate,\n                    // which contributes to saving about 40% off the CPU overhead of computed evaluation (on V8 at least).\n\n                    var computedObservable = this,\n                        state = computedObservable[computedState],\n                        changed = false;\n\n                    // Initially, we assume that none of the subscriptions are still being used (i.e., all are candidates for disposal).\n                    // Then, during evaluation, we cross off any that are in fact still being used.\n                    var isInitial = state.pure ? undefined : !state.dependenciesCount,   // If we're evaluating when there are no previous dependencies, it must be the first time\n                        dependencyDetectionContext = {\n                            computedObservable: computedObservable,\n                            disposalCandidates: state.dependencyTracking,\n                            disposalCount: state.dependenciesCount\n                        };\n\n                    ko.dependencyDetection.begin({\n                        callbackTarget: dependencyDetectionContext,\n                        callback: computedBeginDependencyDetectionCallback,\n                        computed: computedObservable,\n                        isInitial: isInitial\n                    });\n\n                    state.dependencyTracking = {};\n                    state.dependenciesCount = 0;\n\n                    var newValue = this.evaluateImmediate_CallReadThenEndDependencyDetection(state, dependencyDetectionContext);\n\n                    if (!state.dependenciesCount) {\n                        computedObservable.dispose();\n                        changed = true; // When evaluation causes a disposal, make sure all dependent computeds get notified so they'll see the new state\n                    } else {\n                        changed = computedObservable.isDifferent(state.latestValue, newValue);\n                    }\n\n                    if (changed) {\n                        if (!state.isSleeping) {\n                            computedObservable[\"notifySubscribers\"](state.latestValue, \"beforeChange\");\n                        } else {\n                            computedObservable.updateVersion();\n                        }\n\n                        state.latestValue = newValue;\n                        if (DEBUG) computedObservable._latestValue = newValue;\n\n                        computedObservable[\"notifySubscribers\"](state.latestValue, \"spectate\");\n\n                        if (!state.isSleeping && notifyChange) {\n                            computedObservable[\"notifySubscribers\"](state.latestValue);\n                        }\n                        if (computedObservable._recordUpdate) {\n                            computedObservable._recordUpdate();\n                        }\n                    }\n\n                    if (isInitial) {\n                        computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n                    }\n\n                    return changed;\n                },\n                evaluateImmediate_CallReadThenEndDependencyDetection: function (state, dependencyDetectionContext) {\n                    // This function is really part of the evaluateImmediate_CallReadWithDependencyDetection logic.\n                    // You'd never call it from anywhere else. Factoring it out means that evaluateImmediate_CallReadWithDependencyDetection\n                    // can be independent of try/finally blocks, which contributes to saving about 40% off the CPU\n                    // overhead of computed evaluation (on V8 at least).\n\n                    try {\n                        var readFunction = state.readFunction;\n                        return state.evaluatorFunctionTarget ? readFunction.call(state.evaluatorFunctionTarget) : readFunction();\n                    } finally {\n                        ko.dependencyDetection.end();\n\n                        // For each subscription no longer being used, remove it from the active subscriptions list and dispose it\n                        if (dependencyDetectionContext.disposalCount && !state.isSleeping) {\n                            ko.utils.objectForEach(dependencyDetectionContext.disposalCandidates, computedDisposeDependencyCallback);\n                        }\n\n                        state.isStale = state.isDirty = false;\n                    }\n                },\n                peek: function (evaluate) {\n                    // By default, peek won't re-evaluate, except while the computed is sleeping or to get the initial value when \"deferEvaluation\" is set.\n                    // Pass in true to evaluate if needed.\n                    var state = this[computedState];\n                    if ((state.isDirty && (evaluate || !state.dependenciesCount)) || (state.isSleeping && this.haveDependenciesChanged())) {\n                        this.evaluateImmediate();\n                    }\n                    return state.latestValue;\n                },\n                limit: function (limitFunction) {\n                    // Override the limit function with one that delays evaluation as well\n                    ko.subscribable['fn'].limit.call(this, limitFunction);\n                    this._evalIfChanged = function () {\n                        if (!this[computedState].isSleeping) {\n                            if (this[computedState].isStale) {\n                                this.evaluateImmediate();\n                            } else {\n                                this[computedState].isDirty = false;\n                            }\n                        }\n                        return this[computedState].latestValue;\n                    };\n                    this._evalDelayed = function (isChange) {\n                        this._limitBeforeChange(this[computedState].latestValue);\n\n                        // Mark as dirty\n                        this[computedState].isDirty = true;\n                        if (isChange) {\n                            this[computedState].isStale = true;\n                        }\n\n                        // Pass the observable to the \"limit\" code, which will evaluate it when\n                        // it's time to do the notification.\n                        this._limitChange(this, !isChange /* isDirty */);\n                    };\n                },\n                dispose: function () {\n                    var state = this[computedState];\n                    if (!state.isSleeping && state.dependencyTracking) {\n                        ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                            if (dependency.dispose)\n                                dependency.dispose();\n                        });\n                    }\n                    if (state.disposeWhenNodeIsRemoved && state.domNodeDisposalCallback) {\n                        ko.utils.domNodeDisposal.removeDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback);\n                    }\n                    state.dependencyTracking = undefined;\n                    state.dependenciesCount = 0;\n                    state.isDisposed = true;\n                    state.isStale = false;\n                    state.isDirty = false;\n                    state.isSleeping = false;\n                    state.disposeWhenNodeIsRemoved = undefined;\n                    state.disposeWhen = undefined;\n                    state.readFunction = undefined;\n                    if (!this.hasWriteFunction) {\n                        state.evaluatorFunctionTarget = undefined;\n                    }\n                }\n            };\n\n            var pureComputedOverrides = {\n                beforeSubscriptionAdd: function (event) {\n                    // If asleep, wake up the computed by subscribing to any dependencies.\n                    var computedObservable = this,\n                        state = computedObservable[computedState];\n                    if (!state.isDisposed && state.isSleeping && event == 'change') {\n                        state.isSleeping = false;\n                        if (state.isStale || computedObservable.haveDependenciesChanged()) {\n                            state.dependencyTracking = null;\n                            state.dependenciesCount = 0;\n                            if (computedObservable.evaluateImmediate()) {\n                                computedObservable.updateVersion();\n                            }\n                        } else {\n                            // First put the dependencies in order\n                            var dependenciesOrder = [];\n                            ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                                dependenciesOrder[dependency._order] = id;\n                            });\n                            // Next, subscribe to each one\n                            ko.utils.arrayForEach(dependenciesOrder, function (id, order) {\n                                var dependency = state.dependencyTracking[id],\n                                    subscription = computedObservable.subscribeToDependency(dependency._target);\n                                subscription._order = order;\n                                subscription._version = dependency._version;\n                                state.dependencyTracking[id] = subscription;\n                            });\n                            // Waking dependencies may have triggered effects\n                            if (computedObservable.haveDependenciesChanged()) {\n                                if (computedObservable.evaluateImmediate()) {\n                                    computedObservable.updateVersion();\n                                }\n                            }\n                        }\n\n                        if (!state.isDisposed) {     // test since evaluating could trigger disposal\n                            computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n                        }\n                    }\n                },\n                afterSubscriptionRemove: function (event) {\n                    var state = this[computedState];\n                    if (!state.isDisposed && event == 'change' && !this.hasSubscriptionsForEvent('change')) {\n                        ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                            if (dependency.dispose) {\n                                state.dependencyTracking[id] = {\n                                    _target: dependency._target,\n                                    _order: dependency._order,\n                                    _version: dependency._version\n                                };\n                                dependency.dispose();\n                            }\n                        });\n                        state.isSleeping = true;\n                        this[\"notifySubscribers\"](undefined, \"asleep\");\n                    }\n                },\n                getVersion: function () {\n                    // Because a pure computed is not automatically updated while it is sleeping, we can't\n                    // simply return the version number. Instead, we check if any of the dependencies have\n                    // changed and conditionally re-evaluate the computed observable.\n                    var state = this[computedState];\n                    if (state.isSleeping && (state.isStale || this.haveDependenciesChanged())) {\n                        this.evaluateImmediate();\n                    }\n                    return ko.subscribable['fn'].getVersion.call(this);\n                }\n            };\n\n            var deferEvaluationOverrides = {\n                beforeSubscriptionAdd: function (event) {\n                    // This will force a computed with deferEvaluation to evaluate when the first subscription is registered.\n                    if (event == 'change' || event == 'beforeChange') {\n                        this.peek();\n                    }\n                }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.computed constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(computedFn, ko.subscribable['fn']);\n            }\n\n// Set the proto values for ko.computed\n            var protoProp = ko.observable.protoProperty; // == \"__ko_proto__\"\n            computedFn[protoProp] = ko.computed;\n\n            ko.isComputed = function (instance) {\n                return (typeof instance == 'function' && instance[protoProp] === computedFn[protoProp]);\n            };\n\n            ko.isPureComputed = function (instance) {\n                return ko.isComputed(instance) && instance[computedState] && instance[computedState].pure;\n            };\n\n            ko.exportSymbol('computed', ko.computed);\n            ko.exportSymbol('dependentObservable', ko.computed);    // export ko.dependentObservable for backwards compatibility (1.x)\n            ko.exportSymbol('isComputed', ko.isComputed);\n            ko.exportSymbol('isPureComputed', ko.isPureComputed);\n            ko.exportSymbol('computed.fn', computedFn);\n            ko.exportProperty(computedFn, 'peek', computedFn.peek);\n            ko.exportProperty(computedFn, 'dispose', computedFn.dispose);\n            ko.exportProperty(computedFn, 'isActive', computedFn.isActive);\n            ko.exportProperty(computedFn, 'getDependenciesCount', computedFn.getDependenciesCount);\n            ko.exportProperty(computedFn, 'getDependencies', computedFn.getDependencies);\n\n            ko.pureComputed = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget) {\n                if (typeof evaluatorFunctionOrOptions === 'function') {\n                    return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget, {'pure':true});\n                } else {\n                    evaluatorFunctionOrOptions = ko.utils.extend({}, evaluatorFunctionOrOptions);   // make a copy of the parameter object\n                    evaluatorFunctionOrOptions['pure'] = true;\n                    return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget);\n                }\n            }\n            ko.exportSymbol('pureComputed', ko.pureComputed);\n\n            (function() {\n                var maxNestedObservableDepth = 10; // Escape the (unlikely) pathological case where an observable's current value is itself (or similar reference cycle)\n\n                ko.toJS = function(rootObject) {\n                    if (arguments.length == 0)\n                        throw new Error(\"When calling ko.toJS, pass the object you want to convert.\");\n\n                    // We just unwrap everything at every level in the object graph\n                    return mapJsObjectGraph(rootObject, function(valueToMap) {\n                        // Loop because an observable's value might in turn be another observable wrapper\n                        for (var i = 0; ko.isObservable(valueToMap) && (i < maxNestedObservableDepth); i++)\n                            valueToMap = valueToMap();\n                        return valueToMap;\n                    });\n                };\n\n                ko.toJSON = function(rootObject, replacer, space) {     // replacer and space are optional\n                    var plainJavaScriptObject = ko.toJS(rootObject);\n                    return ko.utils.stringifyJson(plainJavaScriptObject, replacer, space);\n                };\n\n                function mapJsObjectGraph(rootObject, mapInputCallback, visitedObjects) {\n                    visitedObjects = visitedObjects || new objectLookup();\n\n                    rootObject = mapInputCallback(rootObject);\n                    var canHaveProperties = (typeof rootObject == \"object\") && (rootObject !== null) && (rootObject !== undefined) && (!(rootObject instanceof RegExp)) && (!(rootObject instanceof Date)) && (!(rootObject instanceof String)) && (!(rootObject instanceof Number)) && (!(rootObject instanceof Boolean));\n                    if (!canHaveProperties)\n                        return rootObject;\n\n                    var outputProperties = rootObject instanceof Array ? [] : {};\n                    visitedObjects.save(rootObject, outputProperties);\n\n                    visitPropertiesOrArrayEntries(rootObject, function(indexer) {\n                        var propertyValue = mapInputCallback(rootObject[indexer]);\n\n                        switch (typeof propertyValue) {\n                            case \"boolean\":\n                            case \"number\":\n                            case \"string\":\n                            case \"function\":\n                                outputProperties[indexer] = propertyValue;\n                                break;\n                            case \"object\":\n                            case \"undefined\":\n                                var previouslyMappedValue = visitedObjects.get(propertyValue);\n                                outputProperties[indexer] = (previouslyMappedValue !== undefined)\n                                    ? previouslyMappedValue\n                                    : mapJsObjectGraph(propertyValue, mapInputCallback, visitedObjects);\n                                break;\n                        }\n                    });\n\n                    return outputProperties;\n                }\n\n                function visitPropertiesOrArrayEntries(rootObject, visitorCallback) {\n                    if (rootObject instanceof Array) {\n                        for (var i = 0; i < rootObject.length; i++)\n                            visitorCallback(i);\n\n                        // For arrays, also respect toJSON property for custom mappings (fixes #278)\n                        if (typeof rootObject['toJSON'] == 'function')\n                            visitorCallback('toJSON');\n                    } else {\n                        for (var propertyName in rootObject) {\n                            visitorCallback(propertyName);\n                        }\n                    }\n                };\n\n                function objectLookup() {\n                    this.keys = [];\n                    this.values = [];\n                };\n\n                objectLookup.prototype = {\n                    constructor: objectLookup,\n                    save: function(key, value) {\n                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n                        if (existingIndex >= 0)\n                            this.values[existingIndex] = value;\n                        else {\n                            this.keys.push(key);\n                            this.values.push(value);\n                        }\n                    },\n                    get: function(key) {\n                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n                        return (existingIndex >= 0) ? this.values[existingIndex] : undefined;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('toJS', ko.toJS);\n            ko.exportSymbol('toJSON', ko.toJSON);\n            ko.when = function(predicate, callback, context) {\n                function kowhen (resolve) {\n                    var observable = ko.pureComputed(predicate, context).extend({notify:'always'});\n                    var subscription = observable.subscribe(function(value) {\n                        if (value) {\n                            subscription.dispose();\n                            resolve(value);\n                        }\n                    });\n                    // In case the initial value is true, process it right away\n                    observable['notifySubscribers'](observable.peek());\n\n                    return subscription;\n                }\n                if (typeof Promise === \"function\" && !callback) {\n                    return new Promise(kowhen);\n                } else {\n                    return kowhen(callback.bind(context));\n                }\n            };\n\n            ko.exportSymbol('when', ko.when);\n            (function () {\n                var hasDomDataExpandoProperty = '__ko__hasDomDataOptionValue__';\n\n                // Normally, SELECT elements and their OPTIONs can only take value of type 'string' (because the values\n                // are stored on DOM attributes). ko.selectExtensions provides a way for SELECTs/OPTIONs to have values\n                // that are arbitrary objects. This is very convenient when implementing things like cascading dropdowns.\n                ko.selectExtensions = {\n                    readValue : function(element) {\n                        switch (ko.utils.tagNameLower(element)) {\n                            case 'option':\n                                if (element[hasDomDataExpandoProperty] === true)\n                                    return ko.utils.domData.get(element, ko.bindingHandlers.options.optionValueDomDataKey);\n                                return ko.utils.ieVersion <= 7\n                                    ? (element.getAttributeNode('value') && element.getAttributeNode('value').specified ? element.value : element.text)\n                                    : element.value;\n                            case 'select':\n                                return element.selectedIndex >= 0 ? ko.selectExtensions.readValue(element.options[element.selectedIndex]) : undefined;\n                            default:\n                                return element.value;\n                        }\n                    },\n\n                    writeValue: function(element, value, allowUnset) {\n                        switch (ko.utils.tagNameLower(element)) {\n                            case 'option':\n                                if (typeof value === \"string\") {\n                                    ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, undefined);\n                                    if (hasDomDataExpandoProperty in element) { // IE <= 8 throws errors if you delete non-existent properties from a DOM node\n                                        delete element[hasDomDataExpandoProperty];\n                                    }\n                                    element.value = value;\n                                }\n                                else {\n                                    // Store arbitrary object using DomData\n                                    ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, value);\n                                    element[hasDomDataExpandoProperty] = true;\n\n                                    // Special treatment of numbers is just for backward compatibility. KO 1.2.1 wrote numerical values to element.value.\n                                    element.value = typeof value === \"number\" ? value : \"\";\n                                }\n                                break;\n                            case 'select':\n                                if (value === \"\" || value === null)       // A blank string or null value will select the caption\n                                    value = undefined;\n                                var selection = -1;\n                                for (var i = 0, n = element.options.length, optionValue; i < n; ++i) {\n                                    optionValue = ko.selectExtensions.readValue(element.options[i]);\n                                    // Include special check to handle selecting a caption with a blank string value\n                                    if (optionValue == value || (optionValue === \"\" && value === undefined)) {\n                                        selection = i;\n                                        break;\n                                    }\n                                }\n                                if (allowUnset || selection >= 0 || (value === undefined && element.size > 1)) {\n                                    element.selectedIndex = selection;\n                                    if (ko.utils.ieVersion === 6) {\n                                        // Workaround for IE6 bug: It won't reliably apply values to SELECT nodes during the same execution thread\n                                        // right after you've changed the set of OPTION nodes on it. So for that node type, we'll schedule a second thread\n                                        // to apply the value as well.\n                                        ko.utils.setTimeout(function () {\n                                            element.selectedIndex = selection;\n                                        }, 0);\n                                    }\n                                }\n                                break;\n                            default:\n                                if ((value === null) || (value === undefined))\n                                    value = \"\";\n                                element.value = value;\n                                break;\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('selectExtensions', ko.selectExtensions);\n            ko.exportSymbol('selectExtensions.readValue', ko.selectExtensions.readValue);\n            ko.exportSymbol('selectExtensions.writeValue', ko.selectExtensions.writeValue);\n            ko.expressionRewriting = (function () {\n                var javaScriptReservedWords = [\"true\", \"false\", \"null\", \"undefined\"];\n\n                // Matches something that can be assigned to--either an isolated identifier or something ending with a property accessor\n                // This is designed to be simple and avoid false negatives, but could produce false positives (e.g., a+b.c).\n                // This also will not properly handle nested brackets (e.g., obj1[obj2['prop']]; see #911).\n                var javaScriptAssignmentTarget = /^(?:[$_a-z][$\\w]*|(.+)(\\.\\s*[$_a-z][$\\w]*|\\[.+\\]))$/i;\n\n                function getWriteableValue(expression) {\n                    if (ko.utils.arrayIndexOf(javaScriptReservedWords, expression) >= 0)\n                        return false;\n                    var match = expression.match(javaScriptAssignmentTarget);\n                    return match === null ? false : match[1] ? ('Object(' + match[1] + ')' + match[2]) : expression;\n                }\n\n                // The following regular expressions will be used to split an object-literal string into tokens\n\n                var specials = ',\"\\'`{}()/:[\\\\]',    // These characters have special meaning to the parser and must not appear in the middle of a token, except as part of a string.\n                    // Create the actual regular expression by or-ing the following regex strings. The order is important.\n                    bindingToken = RegExp([\n                        // These match strings, either with double quotes, single quotes, or backticks\n                        '\"(?:\\\\\\\\.|[^\"])*\"',\n                        \"'(?:\\\\\\\\.|[^'])*'\",\n                        \"`(?:\\\\\\\\.|[^`])*`\",\n                        // Match C style comments\n                        \"/\\\\*(?:[^*]|\\\\*+[^*/])*\\\\*+/\",\n                        // Match C++ style comments\n                        \"//.*\\n\",\n                        // Match a regular expression (text enclosed by slashes), but will also match sets of divisions\n                        // as a regular expression (this is handled by the parsing loop below).\n                        '/(?:\\\\\\\\.|[^/])+/\\w*',\n                        // Match text (at least two characters) that does not contain any of the above special characters,\n                        // although some of the special characters are allowed to start it (all but the colon and comma).\n                        // The text can contain spaces, but leading or trailing spaces are skipped.\n                        '[^\\\\s:,/][^' + specials + ']*[^\\\\s' + specials + ']',\n                        // Match any non-space character not matched already. This will match colons and commas, since they're\n                        // not matched by \"everyThingElse\", but will also match any other single character that wasn't already\n                        // matched (for example: in \"a: 1, b: 2\", each of the non-space characters will be matched by oneNotSpace).\n                        '[^\\\\s]'\n                    ].join('|'), 'g'),\n\n                    // Match end of previous token to determine whether a slash is a division or regex.\n                    divisionLookBehind = /[\\])\"'A-Za-z0-9_$]+$/,\n                    keywordRegexLookBehind = {'in':1,'return':1,'typeof':1};\n\n                function parseObjectLiteral(objectLiteralString) {\n                    // Trim leading and trailing spaces from the string\n                    var str = ko.utils.stringTrim(objectLiteralString);\n\n                    // Trim braces '{' surrounding the whole object literal\n                    if (str.charCodeAt(0) === 123) str = str.slice(1, -1);\n\n                    // Add a newline to correctly match a C++ style comment at the end of the string and\n                    // add a comma so that we don't need a separate code block to deal with the last item\n                    str += \"\\n,\";\n\n                    // Split into tokens\n                    var result = [], toks = str.match(bindingToken), key, values = [], depth = 0;\n\n                    if (toks.length > 1) {\n                        for (var i = 0, tok; tok = toks[i]; ++i) {\n                            var c = tok.charCodeAt(0);\n                            // A comma signals the end of a key/value pair if depth is zero\n                            if (c === 44) { // \",\"\n                                if (depth <= 0) {\n                                    result.push((key && values.length) ? {key: key, value: values.join('')} : {'unknown': key || values.join('')});\n                                    key = depth = 0;\n                                    values = [];\n                                    continue;\n                                }\n                                // Simply skip the colon that separates the name and value\n                            } else if (c === 58) { // \":\"\n                                if (!depth && !key && values.length === 1) {\n                                    key = values.pop();\n                                    continue;\n                                }\n                                // Comments: skip them\n                            } else if (c === 47 && tok.length > 1 && (tok.charCodeAt(1) === 47 || tok.charCodeAt(1) === 42)) {  // \"//\" or \"/*\"\n                                continue;\n                                // A set of slashes is initially matched as a regular expression, but could be division\n                            } else if (c === 47 && i && tok.length > 1) {  // \"/\"\n                                // Look at the end of the previous token to determine if the slash is actually division\n                                var match = toks[i-1].match(divisionLookBehind);\n                                if (match && !keywordRegexLookBehind[match[0]]) {\n                                    // The slash is actually a division punctuator; re-parse the remainder of the string (not including the slash)\n                                    str = str.substr(str.indexOf(tok) + 1);\n                                    toks = str.match(bindingToken);\n                                    i = -1;\n                                    // Continue with just the slash\n                                    tok = '/';\n                                }\n                                // Increment depth for parentheses, braces, and brackets so that interior commas are ignored\n                            } else if (c === 40 || c === 123 || c === 91) { // '(', '{', '['\n                                ++depth;\n                            } else if (c === 41 || c === 125 || c === 93) { // ')', '}', ']'\n                                --depth;\n                                // The key will be the first token; if it's a string, trim the quotes\n                            } else if (!key && !values.length && (c === 34 || c === 39)) { // '\"', \"'\"\n                                tok = tok.slice(1, -1);\n                            }\n                            values.push(tok);\n                        }\n                        if (depth > 0) {\n                            throw Error(\"Unbalanced parentheses, braces, or brackets\");\n                        }\n                    }\n                    return result;\n                }\n\n                // Two-way bindings include a write function that allow the handler to update the value even if it's not an observable.\n                var twoWayBindings = {};\n\n                function preProcessBindings(bindingsStringOrKeyValueArray, bindingOptions) {\n                    bindingOptions = bindingOptions || {};\n\n                    function processKeyValue(key, val) {\n                        var writableVal;\n                        function callPreprocessHook(obj) {\n                            return (obj && obj['preprocess']) ? (val = obj['preprocess'](val, key, processKeyValue)) : true;\n                        }\n                        if (!bindingParams) {\n                            if (!callPreprocessHook(ko['getBindingHandler'](key)))\n                                return;\n\n                            if (twoWayBindings[key] && (writableVal = getWriteableValue(val))) {\n                                // For two-way bindings, provide a write method in case the value\n                                // isn't a writable observable.\n                                var writeKey = typeof twoWayBindings[key] == 'string' ? twoWayBindings[key] : key;\n                                propertyAccessorResultStrings.push(\"'\" + writeKey + \"':function(_z){\" + writableVal + \"=_z}\");\n                            }\n                        }\n                        // Values are wrapped in a function so that each value can be accessed independently\n                        if (makeValueAccessors) {\n                            val = 'function(){return ' + val + ' }';\n                        }\n                        resultStrings.push(\"'\" + key + \"':\" + val);\n                    }\n\n                    var resultStrings = [],\n                        propertyAccessorResultStrings = [],\n                        makeValueAccessors = bindingOptions['valueAccessors'],\n                        bindingParams = bindingOptions['bindingParams'],\n                        keyValueArray = typeof bindingsStringOrKeyValueArray === \"string\" ?\n                            parseObjectLiteral(bindingsStringOrKeyValueArray) : bindingsStringOrKeyValueArray;\n\n                    ko.utils.arrayForEach(keyValueArray, function(keyValue) {\n                        processKeyValue(keyValue.key || keyValue['unknown'], keyValue.value);\n                    });\n\n                    if (propertyAccessorResultStrings.length)\n                        processKeyValue('_ko_property_writers', \"{\" + propertyAccessorResultStrings.join(\",\") + \" }\");\n\n                    return resultStrings.join(\",\");\n                }\n\n                return {\n                    bindingRewriteValidators: [],\n\n                    twoWayBindings: twoWayBindings,\n\n                    parseObjectLiteral: parseObjectLiteral,\n\n                    preProcessBindings: preProcessBindings,\n\n                    keyValueArrayContainsKey: function(keyValueArray, key) {\n                        for (var i = 0; i < keyValueArray.length; i++)\n                            if (keyValueArray[i]['key'] == key)\n                                return true;\n                        return false;\n                    },\n\n                    // Internal, private KO utility for updating model properties from within bindings\n                    // property:            If the property being updated is (or might be) an observable, pass it here\n                    //                      If it turns out to be a writable observable, it will be written to directly\n                    // allBindings:         An object with a get method to retrieve bindings in the current execution context.\n                    //                      This will be searched for a '_ko_property_writers' property in case you're writing to a non-observable\n                    // key:                 The key identifying the property to be written. Example: for { hasFocus: myValue }, write to 'myValue' by specifying the key 'hasFocus'\n                    // value:               The value to be written\n                    // checkIfDifferent:    If true, and if the property being written is a writable observable, the value will only be written if\n                    //                      it is !== existing value on that writable observable\n                    writeValueToProperty: function(property, allBindings, key, value, checkIfDifferent) {\n                        if (!property || !ko.isObservable(property)) {\n                            var propWriters = allBindings.get('_ko_property_writers');\n                            if (propWriters && propWriters[key])\n                                propWriters[key](value);\n                        } else if (ko.isWriteableObservable(property) && (!checkIfDifferent || property.peek() !== value)) {\n                            property(value);\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('expressionRewriting', ko.expressionRewriting);\n            ko.exportSymbol('expressionRewriting.bindingRewriteValidators', ko.expressionRewriting.bindingRewriteValidators);\n            ko.exportSymbol('expressionRewriting.parseObjectLiteral', ko.expressionRewriting.parseObjectLiteral);\n            ko.exportSymbol('expressionRewriting.preProcessBindings', ko.expressionRewriting.preProcessBindings);\n\n// Making bindings explicitly declare themselves as \"two way\" isn't ideal in the long term (it would be better if\n// all bindings could use an official 'property writer' API without needing to declare that they might). However,\n// since this is not, and has never been, a public API (_ko_property_writers was never documented), it's acceptable\n// as an internal implementation detail in the short term.\n// For those developers who rely on _ko_property_writers in their custom bindings, we expose _twoWayBindings as an\n// undocumented feature that makes it relatively easy to upgrade to KO 3.0. However, this is still not an official\n// public API, and we reserve the right to remove it at any time if we create a real public property writers API.\n            ko.exportSymbol('expressionRewriting._twoWayBindings', ko.expressionRewriting.twoWayBindings);\n\n// For backward compatibility, define the following aliases. (Previously, these function names were misleading because\n// they referred to JSON specifically, even though they actually work with arbitrary JavaScript object literal expressions.)\n            ko.exportSymbol('jsonExpressionRewriting', ko.expressionRewriting);\n            ko.exportSymbol('jsonExpressionRewriting.insertPropertyAccessorsIntoJson', ko.expressionRewriting.preProcessBindings);\n            (function() {\n                // \"Virtual elements\" is an abstraction on top of the usual DOM API which understands the notion that comment nodes\n                // may be used to represent hierarchy (in addition to the DOM's natural hierarchy).\n                // If you call the DOM-manipulating functions on ko.virtualElements, you will be able to read and write the state\n                // of that virtual hierarchy\n                //\n                // The point of all this is to support containerless templates (e.g., <!-- ko foreach:someCollection -->blah<!-- /ko -->)\n                // without having to scatter special cases all over the binding and templating code.\n\n                // IE 9 cannot reliably read the \"nodeValue\" property of a comment node (see https://github.com/SteveSanderson/knockout/issues/186)\n                // but it does give them a nonstandard alternative property called \"text\" that it can read reliably. Other browsers don't have that property.\n                // So, use node.text where available, and node.nodeValue elsewhere\n                var commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\n\n                var startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\n                var endCommentRegex =   commentNodesHaveTextProperty ? /^<!--\\s*\\/ko\\s*-->$/ : /^\\s*\\/ko\\s*$/;\n                var htmlTagsWithOptionallyClosingChildren = { 'ul': true, 'ol': true };\n\n                function isStartComment(node) {\n                    return (node.nodeType == 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n                }\n\n                function isEndComment(node) {\n                    return (node.nodeType == 8) && endCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n                }\n\n                function isUnmatchedEndComment(node) {\n                    return isEndComment(node) && !(ko.utils.domData.get(node, matchedEndCommentDataKey));\n                }\n\n                var matchedEndCommentDataKey = \"__ko_matchedEndComment__\"\n\n                function getVirtualChildren(startComment, allowUnbalanced) {\n                    var currentNode = startComment;\n                    var depth = 1;\n                    var children = [];\n                    while (currentNode = currentNode.nextSibling) {\n                        if (isEndComment(currentNode)) {\n                            ko.utils.domData.set(currentNode, matchedEndCommentDataKey, true);\n                            depth--;\n                            if (depth === 0)\n                                return children;\n                        }\n\n                        children.push(currentNode);\n\n                        if (isStartComment(currentNode))\n                            depth++;\n                    }\n                    if (!allowUnbalanced)\n                        throw new Error(\"Cannot find closing comment tag to match: \" + startComment.nodeValue);\n                    return null;\n                }\n\n                function getMatchingEndComment(startComment, allowUnbalanced) {\n                    var allVirtualChildren = getVirtualChildren(startComment, allowUnbalanced);\n                    if (allVirtualChildren) {\n                        if (allVirtualChildren.length > 0)\n                            return allVirtualChildren[allVirtualChildren.length - 1].nextSibling;\n                        return startComment.nextSibling;\n                    } else\n                        return null; // Must have no matching end comment, and allowUnbalanced is true\n                }\n\n                function getUnbalancedChildTags(node) {\n                    // e.g., from <div>OK</div><!-- ko blah --><span>Another</span>, returns: <!-- ko blah --><span>Another</span>\n                    //       from <div>OK</div><!-- /ko --><!-- /ko -->,             returns: <!-- /ko --><!-- /ko -->\n                    var childNode = node.firstChild, captureRemaining = null;\n                    if (childNode) {\n                        do {\n                            if (captureRemaining)                   // We already hit an unbalanced node and are now just scooping up all subsequent nodes\n                                captureRemaining.push(childNode);\n                            else if (isStartComment(childNode)) {\n                                var matchingEndComment = getMatchingEndComment(childNode, /* allowUnbalanced: */ true);\n                                if (matchingEndComment)             // It's a balanced tag, so skip immediately to the end of this virtual set\n                                    childNode = matchingEndComment;\n                                else\n                                    captureRemaining = [childNode]; // It's unbalanced, so start capturing from this point\n                            } else if (isEndComment(childNode)) {\n                                captureRemaining = [childNode];     // It's unbalanced (if it wasn't, we'd have skipped over it already), so start capturing\n                            }\n                        } while (childNode = childNode.nextSibling);\n                    }\n                    return captureRemaining;\n                }\n\n                ko.virtualElements = {\n                    allowedBindings: {},\n\n                    childNodes: function(node) {\n                        return isStartComment(node) ? getVirtualChildren(node) : node.childNodes;\n                    },\n\n                    emptyNode: function(node) {\n                        if (!isStartComment(node))\n                            ko.utils.emptyDomNode(node);\n                        else {\n                            var virtualChildren = ko.virtualElements.childNodes(node);\n                            for (var i = 0, j = virtualChildren.length; i < j; i++)\n                                ko.removeNode(virtualChildren[i]);\n                        }\n                    },\n\n                    setDomNodeChildren: function(node, childNodes) {\n                        if (!isStartComment(node))\n                            ko.utils.setDomNodeChildren(node, childNodes);\n                        else {\n                            ko.virtualElements.emptyNode(node);\n                            var endCommentNode = node.nextSibling; // Must be the next sibling, as we just emptied the children\n                            for (var i = 0, j = childNodes.length; i < j; i++)\n                                endCommentNode.parentNode.insertBefore(childNodes[i], endCommentNode);\n                        }\n                    },\n\n                    prepend: function(containerNode, nodeToPrepend) {\n                        var insertBeforeNode;\n\n                        if (isStartComment(containerNode)) {\n                            // Start comments must always have a parent and at least one following sibling (the end comment)\n                            insertBeforeNode = containerNode.nextSibling;\n                            containerNode = containerNode.parentNode;\n                        } else {\n                            insertBeforeNode = containerNode.firstChild;\n                        }\n\n                        if (!insertBeforeNode) {\n                            containerNode.appendChild(nodeToPrepend);\n                        } else if (nodeToPrepend !== insertBeforeNode) {       // IE will sometimes crash if you try to insert a node before itself\n                            containerNode.insertBefore(nodeToPrepend, insertBeforeNode);\n                        }\n                    },\n\n                    insertAfter: function(containerNode, nodeToInsert, insertAfterNode) {\n                        if (!insertAfterNode) {\n                            ko.virtualElements.prepend(containerNode, nodeToInsert);\n                        } else {\n                            // Children of start comments must always have a parent and at least one following sibling (the end comment)\n                            var insertBeforeNode = insertAfterNode.nextSibling;\n\n                            if (isStartComment(containerNode)) {\n                                containerNode = containerNode.parentNode;\n                            }\n\n                            if (!insertBeforeNode) {\n                                containerNode.appendChild(nodeToInsert);\n                            } else if (nodeToInsert !== insertBeforeNode) {       // IE will sometimes crash if you try to insert a node before itself\n                                containerNode.insertBefore(nodeToInsert, insertBeforeNode);\n                            }\n                        }\n                    },\n\n                    firstChild: function(node) {\n                        if (!isStartComment(node)) {\n                            if (node.firstChild && isEndComment(node.firstChild)) {\n                                throw new Error(\"Found invalid end comment, as the first child of \" + node);\n                            }\n                            return node.firstChild;\n                        } else if (!node.nextSibling || isEndComment(node.nextSibling)) {\n                            return null;\n                        } else {\n                            return node.nextSibling;\n                        }\n                    },\n\n                    nextSibling: function(node) {\n                        if (isStartComment(node)) {\n                            node = getMatchingEndComment(node);\n                        }\n\n                        if (node.nextSibling && isEndComment(node.nextSibling)) {\n                            if (isUnmatchedEndComment(node.nextSibling)) {\n                                throw Error(\"Found end comment without a matching opening comment, as child of \" + node);\n                            } else {\n                                return null;\n                            }\n                        } else {\n                            return node.nextSibling;\n                        }\n                    },\n\n                    hasBindingValue: isStartComment,\n\n                    virtualNodeBindingValue: function(node) {\n                        var regexMatch = (commentNodesHaveTextProperty ? node.text : node.nodeValue).match(startCommentRegex);\n                        return regexMatch ? regexMatch[1] : null;\n                    },\n\n                    normaliseVirtualElementDomStructure: function(elementVerified) {\n                        // Workaround for https://github.com/SteveSanderson/knockout/issues/155\n                        // (IE <= 8 or IE 9 quirks mode parses your HTML weirdly, treating closing </li> tags as if they don't exist, thereby moving comment nodes\n                        // that are direct descendants of <ul> into the preceding <li>)\n                        if (!htmlTagsWithOptionallyClosingChildren[ko.utils.tagNameLower(elementVerified)])\n                            return;\n\n                        // Scan immediate children to see if they contain unbalanced comment tags. If they do, those comment tags\n                        // must be intended to appear *after* that child, so move them there.\n                        var childNode = elementVerified.firstChild;\n                        if (childNode) {\n                            do {\n                                if (childNode.nodeType === 1) {\n                                    var unbalancedTags = getUnbalancedChildTags(childNode);\n                                    if (unbalancedTags) {\n                                        // Fix up the DOM by moving the unbalanced tags to where they most likely were intended to be placed - *after* the child\n                                        var nodeToInsertBefore = childNode.nextSibling;\n                                        for (var i = 0; i < unbalancedTags.length; i++) {\n                                            if (nodeToInsertBefore)\n                                                elementVerified.insertBefore(unbalancedTags[i], nodeToInsertBefore);\n                                            else\n                                                elementVerified.appendChild(unbalancedTags[i]);\n                                        }\n                                    }\n                                }\n                            } while (childNode = childNode.nextSibling);\n                        }\n                    }\n                };\n            })();\n            ko.exportSymbol('virtualElements', ko.virtualElements);\n            ko.exportSymbol('virtualElements.allowedBindings', ko.virtualElements.allowedBindings);\n            ko.exportSymbol('virtualElements.emptyNode', ko.virtualElements.emptyNode);\n//ko.exportSymbol('virtualElements.firstChild', ko.virtualElements.firstChild);     // firstChild is not minified\n            ko.exportSymbol('virtualElements.insertAfter', ko.virtualElements.insertAfter);\n//ko.exportSymbol('virtualElements.nextSibling', ko.virtualElements.nextSibling);   // nextSibling is not minified\n            ko.exportSymbol('virtualElements.prepend', ko.virtualElements.prepend);\n            ko.exportSymbol('virtualElements.setDomNodeChildren', ko.virtualElements.setDomNodeChildren);\n            (function() {\n                var defaultBindingAttributeName = \"data-bind\";\n\n                ko.bindingProvider = function() {\n                    this.bindingCache = {};\n                };\n\n                ko.utils.extend(ko.bindingProvider.prototype, {\n                    'nodeHasBindings': function(node) {\n                        switch (node.nodeType) {\n                            case 1: // Element\n                                return node.getAttribute(defaultBindingAttributeName) != null\n                                    || ko.components['getComponentNameForNode'](node);\n                            case 8: // Comment node\n                                return ko.virtualElements.hasBindingValue(node);\n                            default: return false;\n                        }\n                    },\n\n                    'getBindings': function(node, bindingContext) {\n                        var bindingsString = this['getBindingsString'](node, bindingContext),\n                            parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node) : null;\n                        return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ false);\n                    },\n\n                    'getBindingAccessors': function(node, bindingContext) {\n                        var bindingsString = this['getBindingsString'](node, bindingContext),\n                            parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node, { 'valueAccessors': true }) : null;\n                        return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ true);\n                    },\n\n                    // The following function is only used internally by this default provider.\n                    // It's not part of the interface definition for a general binding provider.\n                    'getBindingsString': function(node, bindingContext) {\n                        switch (node.nodeType) {\n                            case 1: return node.getAttribute(defaultBindingAttributeName);   // Element\n                            case 8: return ko.virtualElements.virtualNodeBindingValue(node); // Comment node\n                            default: return null;\n                        }\n                    },\n\n                    // The following function is only used internally by this default provider.\n                    // It's not part of the interface definition for a general binding provider.\n                    'parseBindingsString': function(bindingsString, bindingContext, node, options) {\n                        try {\n                            var bindingFunction = createBindingsStringEvaluatorViaCache(bindingsString, this.bindingCache, options);\n                            return bindingFunction(bindingContext, node);\n                        } catch (ex) {\n                            ex.message = \"Unable to parse bindings.\\nBindings value: \" + bindingsString + \"\\nMessage: \" + ex.message;\n                            throw ex;\n                        }\n                    }\n                });\n\n                ko.bindingProvider['instance'] = new ko.bindingProvider();\n\n                function createBindingsStringEvaluatorViaCache(bindingsString, cache, options) {\n                    var cacheKey = bindingsString + (options && options['valueAccessors'] || '');\n                    return cache[cacheKey]\n                        || (cache[cacheKey] = createBindingsStringEvaluator(bindingsString, options));\n                }\n\n                function createBindingsStringEvaluator(bindingsString, options) {\n                    // Build the source for a function that evaluates \"expression\"\n                    // For each scope variable, add an extra level of \"with\" nesting\n                    // Example result: with(sc1) { with(sc0) { return (expression) } }\n                    var rewrittenBindings = ko.expressionRewriting.preProcessBindings(bindingsString, options),\n                        functionBody = \"with($context){with($data||{}){return{\" + rewrittenBindings + \"}}}\";\n                    return new Function(\"$context\", \"$element\", functionBody);\n                }\n            })();\n\n            ko.exportSymbol('bindingProvider', ko.bindingProvider);\n            (function () {\n                // Hide or don't minify context properties, see https://github.com/knockout/knockout/issues/2294\n                var contextSubscribable = ko.utils.createSymbolOrString('_subscribable');\n                var contextAncestorBindingInfo = ko.utils.createSymbolOrString('_ancestorBindingInfo');\n                var contextDataDependency = ko.utils.createSymbolOrString('_dataDependency');\n\n                ko.bindingHandlers = {};\n\n                // The following element types will not be recursed into during binding.\n                var bindingDoesNotRecurseIntoElementTypes = {\n                    // Don't want bindings that operate on text nodes to mutate <script> and <textarea> contents,\n                    // because it's unexpected and a potential XSS issue.\n                    // Also bindings should not operate on <template> elements since this breaks in Internet Explorer\n                    // and because such elements' contents are always intended to be bound in a different context\n                    // from where they appear in the document.\n                    'script': true,\n                    'textarea': true,\n                    'template': true\n                };\n\n                // Use an overridable method for retrieving binding handlers so that plugins may support dynamically created handlers\n                ko['getBindingHandler'] = function(bindingKey) {\n                    return ko.bindingHandlers[bindingKey];\n                };\n\n                var inheritParentVm = {};\n\n                // The ko.bindingContext constructor is only called directly to create the root context. For child\n                // contexts, use bindingContext.createChildContext or bindingContext.extend.\n                ko.bindingContext = function(dataItemOrAccessor, parentContext, dataItemAlias, extendCallback, options) {\n\n                    // The binding context object includes static properties for the current, parent, and root view models.\n                    // If a view model is actually stored in an observable, the corresponding binding context object, and\n                    // any child contexts, must be updated when the view model is changed.\n                    function updateContext() {\n                        // Most of the time, the context will directly get a view model object, but if a function is given,\n                        // we call the function to retrieve the view model. If the function accesses any observables or returns\n                        // an observable, the dependency is tracked, and those observables can later cause the binding\n                        // context to be updated.\n                        var dataItemOrObservable = isFunc ? realDataItemOrAccessor() : realDataItemOrAccessor,\n                            dataItem = ko.utils.unwrapObservable(dataItemOrObservable);\n\n                        if (parentContext) {\n                            // Copy $root and any custom properties from the parent context\n                            ko.utils.extend(self, parentContext);\n\n                            // Copy Symbol properties\n                            if (contextAncestorBindingInfo in parentContext) {\n                                self[contextAncestorBindingInfo] = parentContext[contextAncestorBindingInfo];\n                            }\n                        } else {\n                            self['$parents'] = [];\n                            self['$root'] = dataItem;\n\n                            // Export 'ko' in the binding context so it will be available in bindings and templates\n                            // even if 'ko' isn't exported as a global, such as when using an AMD loader.\n                            // See https://github.com/SteveSanderson/knockout/issues/490\n                            self['ko'] = ko;\n                        }\n\n                        self[contextSubscribable] = subscribable;\n\n                        if (shouldInheritData) {\n                            dataItem = self['$data'];\n                        } else {\n                            self['$rawData'] = dataItemOrObservable;\n                            self['$data'] = dataItem;\n                        }\n\n                        if (dataItemAlias)\n                            self[dataItemAlias] = dataItem;\n\n                        // The extendCallback function is provided when creating a child context or extending a context.\n                        // It handles the specific actions needed to finish setting up the binding context. Actions in this\n                        // function could also add dependencies to this binding context.\n                        if (extendCallback)\n                            extendCallback(self, parentContext, dataItem);\n\n                        // When a \"parent\" context is given and we don't already have a dependency on its context, register a dependency on it.\n                        // Thus whenever the parent context is updated, this context will also be updated.\n                        if (parentContext && parentContext[contextSubscribable] && !ko.computedContext.computed().hasAncestorDependency(parentContext[contextSubscribable])) {\n                            parentContext[contextSubscribable]();\n                        }\n\n                        if (dataDependency) {\n                            self[contextDataDependency] = dataDependency;\n                        }\n\n                        return self['$data'];\n                    }\n\n                    var self = this,\n                        shouldInheritData = dataItemOrAccessor === inheritParentVm,\n                        realDataItemOrAccessor = shouldInheritData ? undefined : dataItemOrAccessor,\n                        isFunc = typeof(realDataItemOrAccessor) == \"function\" && !ko.isObservable(realDataItemOrAccessor),\n                        nodes,\n                        subscribable,\n                        dataDependency = options && options['dataDependency'];\n\n                    if (options && options['exportDependencies']) {\n                        // The \"exportDependencies\" option means that the calling code will track any dependencies and re-create\n                        // the binding context when they change.\n                        updateContext();\n                    } else {\n                        subscribable = ko.pureComputed(updateContext);\n                        subscribable.peek();\n\n                        // At this point, the binding context has been initialized, and the \"subscribable\" computed observable is\n                        // subscribed to any observables that were accessed in the process. If there is nothing to track, the\n                        // computed will be inactive, and we can safely throw it away. If it's active, the computed is stored in\n                        // the context object.\n                        if (subscribable.isActive()) {\n                            // Always notify because even if the model ($data) hasn't changed, other context properties might have changed\n                            subscribable['equalityComparer'] = null;\n                        } else {\n                            self[contextSubscribable] = undefined;\n                        }\n                    }\n                }\n\n                // Extend the binding context hierarchy with a new view model object. If the parent context is watching\n                // any observables, the new child context will automatically get a dependency on the parent context.\n                // But this does not mean that the $data value of the child context will also get updated. If the child\n                // view model also depends on the parent view model, you must provide a function that returns the correct\n                // view model on each update.\n                ko.bindingContext.prototype['createChildContext'] = function (dataItemOrAccessor, dataItemAlias, extendCallback, options) {\n                    if (!options && dataItemAlias && typeof dataItemAlias == \"object\") {\n                        options = dataItemAlias;\n                        dataItemAlias = options['as'];\n                        extendCallback = options['extend'];\n                    }\n\n                    if (dataItemAlias && options && options['noChildContext']) {\n                        var isFunc = typeof(dataItemOrAccessor) == \"function\" && !ko.isObservable(dataItemOrAccessor);\n                        return new ko.bindingContext(inheritParentVm, this, null, function (self) {\n                            if (extendCallback)\n                                extendCallback(self);\n                            self[dataItemAlias] = isFunc ? dataItemOrAccessor() : dataItemOrAccessor;\n                        }, options);\n                    }\n\n                    return new ko.bindingContext(dataItemOrAccessor, this, dataItemAlias, function (self, parentContext) {\n                        // Extend the context hierarchy by setting the appropriate pointers\n                        self['$parentContext'] = parentContext;\n                        self['$parent'] = parentContext['$data'];\n                        self['$parents'] = (parentContext['$parents'] || []).slice(0);\n                        self['$parents'].unshift(self['$parent']);\n                        if (extendCallback)\n                            extendCallback(self);\n                    }, options);\n                };\n\n                // Extend the binding context with new custom properties. This doesn't change the context hierarchy.\n                // Similarly to \"child\" contexts, provide a function here to make sure that the correct values are set\n                // when an observable view model is updated.\n                ko.bindingContext.prototype['extend'] = function(properties, options) {\n                    return new ko.bindingContext(inheritParentVm, this, null, function(self, parentContext) {\n                        ko.utils.extend(self, typeof(properties) == \"function\" ? properties(self) : properties);\n                    }, options);\n                };\n\n                var boundElementDomDataKey = ko.utils.domData.nextKey();\n\n                function asyncContextDispose(node) {\n                    var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey),\n                        asyncContext = bindingInfo && bindingInfo.asyncContext;\n                    if (asyncContext) {\n                        bindingInfo.asyncContext = null;\n                        asyncContext.notifyAncestor();\n                    }\n                }\n                function AsyncCompleteContext(node, bindingInfo, ancestorBindingInfo) {\n                    this.node = node;\n                    this.bindingInfo = bindingInfo;\n                    this.asyncDescendants = [];\n                    this.childrenComplete = false;\n\n                    if (!bindingInfo.asyncContext) {\n                        ko.utils.domNodeDisposal.addDisposeCallback(node, asyncContextDispose);\n                    }\n\n                    if (ancestorBindingInfo && ancestorBindingInfo.asyncContext) {\n                        ancestorBindingInfo.asyncContext.asyncDescendants.push(node);\n                        this.ancestorBindingInfo = ancestorBindingInfo;\n                    }\n                }\n                AsyncCompleteContext.prototype.notifyAncestor = function () {\n                    if (this.ancestorBindingInfo && this.ancestorBindingInfo.asyncContext) {\n                        this.ancestorBindingInfo.asyncContext.descendantComplete(this.node);\n                    }\n                };\n                AsyncCompleteContext.prototype.descendantComplete = function (node) {\n                    ko.utils.arrayRemoveItem(this.asyncDescendants, node);\n                    if (!this.asyncDescendants.length && this.childrenComplete) {\n                        this.completeChildren();\n                    }\n                };\n                AsyncCompleteContext.prototype.completeChildren = function () {\n                    this.childrenComplete = true;\n                    if (this.bindingInfo.asyncContext && !this.asyncDescendants.length) {\n                        this.bindingInfo.asyncContext = null;\n                        ko.utils.domNodeDisposal.removeDisposeCallback(this.node, asyncContextDispose);\n                        ko.bindingEvent.notify(this.node, ko.bindingEvent.descendantsComplete);\n                        this.notifyAncestor();\n                    }\n                };\n\n                ko.bindingEvent = {\n                    childrenComplete: \"childrenComplete\",\n                    descendantsComplete : \"descendantsComplete\",\n\n                    subscribe: function (node, event, callback, context, options) {\n                        var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n                        if (!bindingInfo.eventSubscribable) {\n                            bindingInfo.eventSubscribable = new ko.subscribable;\n                        }\n                        if (options && options['notifyImmediately'] && bindingInfo.notifiedEvents[event]) {\n                            ko.dependencyDetection.ignore(callback, context, [node]);\n                        }\n                        return bindingInfo.eventSubscribable.subscribe(callback, context, event);\n                    },\n\n                    notify: function (node, event) {\n                        var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey);\n                        if (bindingInfo) {\n                            bindingInfo.notifiedEvents[event] = true;\n                            if (bindingInfo.eventSubscribable) {\n                                bindingInfo.eventSubscribable['notifySubscribers'](node, event);\n                            }\n                            if (event == ko.bindingEvent.childrenComplete) {\n                                if (bindingInfo.asyncContext) {\n                                    bindingInfo.asyncContext.completeChildren();\n                                } else if (bindingInfo.asyncContext === undefined && bindingInfo.eventSubscribable && bindingInfo.eventSubscribable.hasSubscriptionsForEvent(ko.bindingEvent.descendantsComplete)) {\n                                    // It's currently an error to register a descendantsComplete handler for a node that was never registered as completing asynchronously.\n                                    // That's because without the asyncContext, we don't have a way to know that all descendants have completed.\n                                    throw new Error(\"descendantsComplete event not supported for bindings on this node\");\n                                }\n                            }\n                        }\n                    },\n\n                    startPossiblyAsyncContentBinding: function (node, bindingContext) {\n                        var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n\n                        if (!bindingInfo.asyncContext) {\n                            bindingInfo.asyncContext = new AsyncCompleteContext(node, bindingInfo, bindingContext[contextAncestorBindingInfo]);\n                        }\n\n                        // If the provided context was already extended with this node's binding info, just return the extended context\n                        if (bindingContext[contextAncestorBindingInfo] == bindingInfo) {\n                            return bindingContext;\n                        }\n\n                        return bindingContext['extend'](function (ctx) {\n                            ctx[contextAncestorBindingInfo] = bindingInfo;\n                        });\n                    }\n                };\n\n                // Returns the valueAccessor function for a binding value\n                function makeValueAccessor(value) {\n                    return function() {\n                        return value;\n                    };\n                }\n\n                // Returns the value of a valueAccessor function\n                function evaluateValueAccessor(valueAccessor) {\n                    return valueAccessor();\n                }\n\n                // Given a function that returns bindings, create and return a new object that contains\n                // binding value-accessors functions. Each accessor function calls the original function\n                // so that it always gets the latest value and all dependencies are captured. This is used\n                // by ko.applyBindingsToNode and getBindingsAndMakeAccessors.\n                function makeAccessorsFromFunction(callback) {\n                    return ko.utils.objectMap(ko.dependencyDetection.ignore(callback), function(value, key) {\n                        return function() {\n                            return callback()[key];\n                        };\n                    });\n                }\n\n                // Given a bindings function or object, create and return a new object that contains\n                // binding value-accessors functions. This is used by ko.applyBindingsToNode.\n                function makeBindingAccessors(bindings, context, node) {\n                    if (typeof bindings === 'function') {\n                        return makeAccessorsFromFunction(bindings.bind(null, context, node));\n                    } else {\n                        return ko.utils.objectMap(bindings, makeValueAccessor);\n                    }\n                }\n\n                // This function is used if the binding provider doesn't include a getBindingAccessors function.\n                // It must be called with 'this' set to the provider instance.\n                function getBindingsAndMakeAccessors(node, context) {\n                    return makeAccessorsFromFunction(this['getBindings'].bind(this, node, context));\n                }\n\n                function validateThatBindingIsAllowedForVirtualElements(bindingName) {\n                    var validator = ko.virtualElements.allowedBindings[bindingName];\n                    if (!validator)\n                        throw new Error(\"The binding '\" + bindingName + \"' cannot be used with virtual elements\")\n                }\n\n                function applyBindingsToDescendantsInternal(bindingContext, elementOrVirtualElement) {\n                    var nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n\n                    if (nextInQueue) {\n                        var currentChild,\n                            provider = ko.bindingProvider['instance'],\n                            preprocessNode = provider['preprocessNode'];\n\n                        // Preprocessing allows a binding provider to mutate a node before bindings are applied to it. For example it's\n                        // possible to insert new siblings after it, and/or replace the node with a different one. This can be used to\n                        // implement custom binding syntaxes, such as {{ value }} for string interpolation, or custom element types that\n                        // trigger insertion of <template> contents at that point in the document.\n                        if (preprocessNode) {\n                            while (currentChild = nextInQueue) {\n                                nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                                preprocessNode.call(provider, currentChild);\n                            }\n                            // Reset nextInQueue for the next loop\n                            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n                        }\n\n                        while (currentChild = nextInQueue) {\n                            // Keep a record of the next child *before* applying bindings, in case the binding removes the current child from its position\n                            nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                            applyBindingsToNodeAndDescendantsInternal(bindingContext, currentChild);\n                        }\n                    }\n                    ko.bindingEvent.notify(elementOrVirtualElement, ko.bindingEvent.childrenComplete);\n                }\n\n                function applyBindingsToNodeAndDescendantsInternal(bindingContext, nodeVerified) {\n                    var bindingContextForDescendants = bindingContext;\n\n                    var isElement = (nodeVerified.nodeType === 1);\n                    if (isElement) // Workaround IE <= 8 HTML parsing weirdness\n                        ko.virtualElements.normaliseVirtualElementDomStructure(nodeVerified);\n\n                    // Perf optimisation: Apply bindings only if...\n                    // (1) We need to store the binding info for the node (all element nodes)\n                    // (2) It might have bindings (e.g., it has a data-bind attribute, or it's a marker for a containerless template)\n                    var shouldApplyBindings = isElement || ko.bindingProvider['instance']['nodeHasBindings'](nodeVerified);\n                    if (shouldApplyBindings)\n                        bindingContextForDescendants = applyBindingsToNodeInternal(nodeVerified, null, bindingContext)['bindingContextForDescendants'];\n\n                    if (bindingContextForDescendants && !bindingDoesNotRecurseIntoElementTypes[ko.utils.tagNameLower(nodeVerified)]) {\n                        applyBindingsToDescendantsInternal(bindingContextForDescendants, nodeVerified);\n                    }\n                }\n\n                function topologicalSortBindings(bindings) {\n                    // Depth-first sort\n                    var result = [],                // The list of key/handler pairs that we will return\n                        bindingsConsidered = {},    // A temporary record of which bindings are already in 'result'\n                        cyclicDependencyStack = []; // Keeps track of a depth-search so that, if there's a cycle, we know which bindings caused it\n                    ko.utils.objectForEach(bindings, function pushBinding(bindingKey) {\n                        if (!bindingsConsidered[bindingKey]) {\n                            var binding = ko['getBindingHandler'](bindingKey);\n                            if (binding) {\n                                // First add dependencies (if any) of the current binding\n                                if (binding['after']) {\n                                    cyclicDependencyStack.push(bindingKey);\n                                    ko.utils.arrayForEach(binding['after'], function(bindingDependencyKey) {\n                                        if (bindings[bindingDependencyKey]) {\n                                            if (ko.utils.arrayIndexOf(cyclicDependencyStack, bindingDependencyKey) !== -1) {\n                                                throw Error(\"Cannot combine the following bindings, because they have a cyclic dependency: \" + cyclicDependencyStack.join(\", \"));\n                                            } else {\n                                                pushBinding(bindingDependencyKey);\n                                            }\n                                        }\n                                    });\n                                    cyclicDependencyStack.length--;\n                                }\n                                // Next add the current binding\n                                result.push({ key: bindingKey, handler: binding });\n                            }\n                            bindingsConsidered[bindingKey] = true;\n                        }\n                    });\n\n                    return result;\n                }\n\n                function applyBindingsToNodeInternal(node, sourceBindings, bindingContext) {\n                    var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n\n                    // Prevent multiple applyBindings calls for the same node, except when a binding value is specified\n                    var alreadyBound = bindingInfo.alreadyBound;\n                    if (!sourceBindings) {\n                        if (alreadyBound) {\n                            throw Error(\"You cannot apply bindings multiple times to the same element.\");\n                        }\n                        bindingInfo.alreadyBound = true;\n                    }\n                    if (!alreadyBound) {\n                        bindingInfo.context = bindingContext;\n                    }\n                    if (!bindingInfo.notifiedEvents) {\n                        bindingInfo.notifiedEvents = {};\n                    }\n\n                    // Use bindings if given, otherwise fall back on asking the bindings provider to give us some bindings\n                    var bindings;\n                    if (sourceBindings && typeof sourceBindings !== 'function') {\n                        bindings = sourceBindings;\n                    } else {\n                        var provider = ko.bindingProvider['instance'],\n                            getBindings = provider['getBindingAccessors'] || getBindingsAndMakeAccessors;\n\n                        // Get the binding from the provider within a computed observable so that we can update the bindings whenever\n                        // the binding context is updated or if the binding provider accesses observables.\n                        var bindingsUpdater = ko.dependentObservable(\n                            function() {\n                                bindings = sourceBindings ? sourceBindings(bindingContext, node) : getBindings.call(provider, node, bindingContext);\n                                // Register a dependency on the binding context to support observable view models.\n                                if (bindings) {\n                                    if (bindingContext[contextSubscribable]) {\n                                        bindingContext[contextSubscribable]();\n                                    }\n                                    if (bindingContext[contextDataDependency]) {\n                                        bindingContext[contextDataDependency]();\n                                    }\n                                }\n                                return bindings;\n                            },\n                            null, { disposeWhenNodeIsRemoved: node }\n                        );\n\n                        if (!bindings || !bindingsUpdater.isActive())\n                            bindingsUpdater = null;\n                    }\n\n                    var contextToExtend = bindingContext;\n                    var bindingHandlerThatControlsDescendantBindings;\n                    if (bindings) {\n                        // Return the value accessor for a given binding. When bindings are static (won't be updated because of a binding\n                        // context update), just return the value accessor from the binding. Otherwise, return a function that always gets\n                        // the latest binding value and registers a dependency on the binding updater.\n                        var getValueAccessor = bindingsUpdater\n                            ? function(bindingKey) {\n                                return function() {\n                                    return evaluateValueAccessor(bindingsUpdater()[bindingKey]);\n                                };\n                            } : function(bindingKey) {\n                                return bindings[bindingKey];\n                            };\n\n                        // Use of allBindings as a function is maintained for backwards compatibility, but its use is deprecated\n                        function allBindings() {\n                            return ko.utils.objectMap(bindingsUpdater ? bindingsUpdater() : bindings, evaluateValueAccessor);\n                        }\n                        // The following is the 3.x allBindings API\n                        allBindings['get'] = function(key) {\n                            return bindings[key] && evaluateValueAccessor(getValueAccessor(key));\n                        };\n                        allBindings['has'] = function(key) {\n                            return key in bindings;\n                        };\n\n                        if (ko.bindingEvent.childrenComplete in bindings) {\n                            ko.bindingEvent.subscribe(node, ko.bindingEvent.childrenComplete, function () {\n                                var callback = evaluateValueAccessor(bindings[ko.bindingEvent.childrenComplete]);\n                                if (callback) {\n                                    var nodes = ko.virtualElements.childNodes(node);\n                                    if (nodes.length) {\n                                        callback(nodes, ko.dataFor(nodes[0]));\n                                    }\n                                }\n                            });\n                        }\n\n                        if (ko.bindingEvent.descendantsComplete in bindings) {\n                            contextToExtend = ko.bindingEvent.startPossiblyAsyncContentBinding(node, bindingContext);\n                            ko.bindingEvent.subscribe(node, ko.bindingEvent.descendantsComplete, function () {\n                                var callback = evaluateValueAccessor(bindings[ko.bindingEvent.descendantsComplete]);\n                                if (callback && ko.virtualElements.firstChild(node)) {\n                                    callback(node);\n                                }\n                            });\n                        }\n\n                        // First put the bindings into the right order\n                        var orderedBindings = topologicalSortBindings(bindings);\n\n                        // Go through the sorted bindings, calling init and update for each\n                        ko.utils.arrayForEach(orderedBindings, function(bindingKeyAndHandler) {\n                            // Note that topologicalSortBindings has already filtered out any nonexistent binding handlers,\n                            // so bindingKeyAndHandler.handler will always be nonnull.\n                            var handlerInitFn = bindingKeyAndHandler.handler[\"init\"],\n                                handlerUpdateFn = bindingKeyAndHandler.handler[\"update\"],\n                                bindingKey = bindingKeyAndHandler.key;\n\n                            if (node.nodeType === 8) {\n                                validateThatBindingIsAllowedForVirtualElements(bindingKey);\n                            }\n\n                            try {\n                                // Run init, ignoring any dependencies\n                                if (typeof handlerInitFn == \"function\") {\n                                    ko.dependencyDetection.ignore(function() {\n                                        var initResult = handlerInitFn(node, getValueAccessor(bindingKey), allBindings, contextToExtend['$data'], contextToExtend);\n\n                                        // If this binding handler claims to control descendant bindings, make a note of this\n                                        if (initResult && initResult['controlsDescendantBindings']) {\n                                            if (bindingHandlerThatControlsDescendantBindings !== undefined)\n                                                throw new Error(\"Multiple bindings (\" + bindingHandlerThatControlsDescendantBindings + \" and \" + bindingKey + \") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.\");\n                                            bindingHandlerThatControlsDescendantBindings = bindingKey;\n                                        }\n                                    });\n                                }\n\n                                // Run update in its own computed wrapper\n                                if (typeof handlerUpdateFn == \"function\") {\n                                    ko.dependentObservable(\n                                        function() {\n                                            handlerUpdateFn(node, getValueAccessor(bindingKey), allBindings, contextToExtend['$data'], contextToExtend);\n                                        },\n                                        null,\n                                        { disposeWhenNodeIsRemoved: node }\n                                    );\n                                }\n                            } catch (ex) {\n                                ex.message = \"Unable to process binding \\\"\" + bindingKey + \": \" + bindings[bindingKey] + \"\\\"\\nMessage: \" + ex.message;\n                                throw ex;\n                            }\n                        });\n                    }\n\n                    var shouldBindDescendants = bindingHandlerThatControlsDescendantBindings === undefined;\n                    return {\n                        'shouldBindDescendants': shouldBindDescendants,\n                        'bindingContextForDescendants': shouldBindDescendants && contextToExtend\n                    };\n                };\n\n                ko.storedBindingContextForNode = function (node) {\n                    var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey);\n                    return bindingInfo && bindingInfo.context;\n                }\n\n                function getBindingContext(viewModelOrBindingContext, extendContextCallback) {\n                    return viewModelOrBindingContext && (viewModelOrBindingContext instanceof ko.bindingContext)\n                        ? viewModelOrBindingContext\n                        : new ko.bindingContext(viewModelOrBindingContext, undefined, undefined, extendContextCallback);\n                }\n\n                ko.applyBindingAccessorsToNode = function (node, bindings, viewModelOrBindingContext) {\n                    if (node.nodeType === 1) // If it's an element, workaround IE <= 8 HTML parsing weirdness\n                        ko.virtualElements.normaliseVirtualElementDomStructure(node);\n                    return applyBindingsToNodeInternal(node, bindings, getBindingContext(viewModelOrBindingContext));\n                };\n\n                ko.applyBindingsToNode = function (node, bindings, viewModelOrBindingContext) {\n                    var context = getBindingContext(viewModelOrBindingContext);\n                    return ko.applyBindingAccessorsToNode(node, makeBindingAccessors(bindings, context, node), context);\n                };\n\n                ko.applyBindingsToDescendants = function(viewModelOrBindingContext, rootNode) {\n                    if (rootNode.nodeType === 1 || rootNode.nodeType === 8)\n                        applyBindingsToDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode);\n                };\n\n                ko.applyBindings = function (viewModelOrBindingContext, rootNode, extendContextCallback) {\n                    // If jQuery is loaded after Knockout, we won't initially have access to it. So save it here.\n                    if (!jQueryInstance && window['jQuery']) {\n                        jQueryInstance = window['jQuery'];\n                    }\n\n                    if (arguments.length < 2) {\n                        rootNode = document.body;\n                        if (!rootNode) {\n                            throw Error(\"ko.applyBindings: could not find document.body; has the document been loaded?\");\n                        }\n                    } else if (!rootNode || (rootNode.nodeType !== 1 && rootNode.nodeType !== 8)) {\n                        throw Error(\"ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node\");\n                    }\n\n                    applyBindingsToNodeAndDescendantsInternal(getBindingContext(viewModelOrBindingContext, extendContextCallback), rootNode);\n                };\n\n                // Retrieving binding context from arbitrary nodes\n                ko.contextFor = function(node) {\n                    // We can only do something meaningful for elements and comment nodes (in particular, not text nodes, as IE can't store domdata for them)\n                    if (node && (node.nodeType === 1 || node.nodeType === 8)) {\n                        return ko.storedBindingContextForNode(node);\n                    }\n                    return undefined;\n                };\n                ko.dataFor = function(node) {\n                    var context = ko.contextFor(node);\n                    return context ? context['$data'] : undefined;\n                };\n\n                ko.exportSymbol('bindingHandlers', ko.bindingHandlers);\n                ko.exportSymbol('bindingEvent', ko.bindingEvent);\n                ko.exportSymbol('bindingEvent.subscribe', ko.bindingEvent.subscribe);\n                ko.exportSymbol('bindingEvent.startPossiblyAsyncContentBinding', ko.bindingEvent.startPossiblyAsyncContentBinding);\n                ko.exportSymbol('applyBindings', ko.applyBindings);\n                ko.exportSymbol('applyBindingsToDescendants', ko.applyBindingsToDescendants);\n                ko.exportSymbol('applyBindingAccessorsToNode', ko.applyBindingAccessorsToNode);\n                ko.exportSymbol('applyBindingsToNode', ko.applyBindingsToNode);\n                ko.exportSymbol('contextFor', ko.contextFor);\n                ko.exportSymbol('dataFor', ko.dataFor);\n            })();\n            (function(undefined) {\n                var loadingSubscribablesCache = {}, // Tracks component loads that are currently in flight\n                    loadedDefinitionsCache = {};    // Tracks component loads that have already completed\n\n                ko.components = {\n                    get: function(componentName, callback) {\n                        var cachedDefinition = getObjectOwnProperty(loadedDefinitionsCache, componentName);\n                        if (cachedDefinition) {\n                            // It's already loaded and cached. Reuse the same definition object.\n                            // Note that for API consistency, even cache hits complete asynchronously by default.\n                            // You can bypass this by putting synchronous:true on your component config.\n                            if (cachedDefinition.isSynchronousComponent) {\n                                ko.dependencyDetection.ignore(function() { // See comment in loaderRegistryBehaviors.js for reasoning\n                                    callback(cachedDefinition.definition);\n                                });\n                            } else {\n                                ko.tasks.schedule(function() { callback(cachedDefinition.definition); });\n                            }\n                        } else {\n                            // Join the loading process that is already underway, or start a new one.\n                            loadComponentAndNotify(componentName, callback);\n                        }\n                    },\n\n                    clearCachedDefinition: function(componentName) {\n                        delete loadedDefinitionsCache[componentName];\n                    },\n\n                    _getFirstResultFromLoaders: getFirstResultFromLoaders\n                };\n\n                function getObjectOwnProperty(obj, propName) {\n                    return Object.prototype.hasOwnProperty.call(obj, propName) ? obj[propName] : undefined;\n                }\n\n                function loadComponentAndNotify(componentName, callback) {\n                    var subscribable = getObjectOwnProperty(loadingSubscribablesCache, componentName),\n                        completedAsync;\n                    if (!subscribable) {\n                        // It's not started loading yet. Start loading, and when it's done, move it to loadedDefinitionsCache.\n                        subscribable = loadingSubscribablesCache[componentName] = new ko.subscribable();\n                        subscribable.subscribe(callback);\n\n                        beginLoadingComponent(componentName, function(definition, config) {\n                            var isSynchronousComponent = !!(config && config['synchronous']);\n                            loadedDefinitionsCache[componentName] = { definition: definition, isSynchronousComponent: isSynchronousComponent };\n                            delete loadingSubscribablesCache[componentName];\n\n                            // For API consistency, all loads complete asynchronously. However we want to avoid\n                            // adding an extra task schedule if it's unnecessary (i.e., the completion is already\n                            // async).\n                            //\n                            // You can bypass the 'always asynchronous' feature by putting the synchronous:true\n                            // flag on your component configuration when you register it.\n                            if (completedAsync || isSynchronousComponent) {\n                                // Note that notifySubscribers ignores any dependencies read within the callback.\n                                // See comment in loaderRegistryBehaviors.js for reasoning\n                                subscribable['notifySubscribers'](definition);\n                            } else {\n                                ko.tasks.schedule(function() {\n                                    subscribable['notifySubscribers'](definition);\n                                });\n                            }\n                        });\n                        completedAsync = true;\n                    } else {\n                        subscribable.subscribe(callback);\n                    }\n                }\n\n                function beginLoadingComponent(componentName, callback) {\n                    getFirstResultFromLoaders('getConfig', [componentName], function(config) {\n                        if (config) {\n                            // We have a config, so now load its definition\n                            getFirstResultFromLoaders('loadComponent', [componentName, config], function(definition) {\n                                callback(definition, config);\n                            });\n                        } else {\n                            // The component has no config - it's unknown to all the loaders.\n                            // Note that this is not an error (e.g., a module loading error) - that would abort the\n                            // process and this callback would not run. For this callback to run, all loaders must\n                            // have confirmed they don't know about this component.\n                            callback(null, null);\n                        }\n                    });\n                }\n\n                function getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders) {\n                    // On the first call in the stack, start with the full set of loaders\n                    if (!candidateLoaders) {\n                        candidateLoaders = ko.components['loaders'].slice(0); // Use a copy, because we'll be mutating this array\n                    }\n\n                    // Try the next candidate\n                    var currentCandidateLoader = candidateLoaders.shift();\n                    if (currentCandidateLoader) {\n                        var methodInstance = currentCandidateLoader[methodName];\n                        if (methodInstance) {\n                            var wasAborted = false,\n                                synchronousReturnValue = methodInstance.apply(currentCandidateLoader, argsExceptCallback.concat(function(result) {\n                                    if (wasAborted) {\n                                        callback(null);\n                                    } else if (result !== null) {\n                                        // This candidate returned a value. Use it.\n                                        callback(result);\n                                    } else {\n                                        // Try the next candidate\n                                        getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                                    }\n                                }));\n\n                            // Currently, loaders may not return anything synchronously. This leaves open the possibility\n                            // that we'll extend the API to support synchronous return values in the future. It won't be\n                            // a breaking change, because currently no loader is allowed to return anything except undefined.\n                            if (synchronousReturnValue !== undefined) {\n                                wasAborted = true;\n\n                                // Method to suppress exceptions will remain undocumented. This is only to keep\n                                // KO's specs running tidily, since we can observe the loading got aborted without\n                                // having exceptions cluttering up the console too.\n                                if (!currentCandidateLoader['suppressLoaderExceptions']) {\n                                    throw new Error('Component loaders must supply values by invoking the callback, not by returning values synchronously.');\n                                }\n                            }\n                        } else {\n                            // This candidate doesn't have the relevant handler. Synchronously move on to the next one.\n                            getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                        }\n                    } else {\n                        // No candidates returned a value\n                        callback(null);\n                    }\n                }\n\n                // Reference the loaders via string name so it's possible for developers\n                // to replace the whole array by assigning to ko.components.loaders\n                ko.components['loaders'] = [];\n\n                ko.exportSymbol('components', ko.components);\n                ko.exportSymbol('components.get', ko.components.get);\n                ko.exportSymbol('components.clearCachedDefinition', ko.components.clearCachedDefinition);\n            })();\n            (function(undefined) {\n\n                // The default loader is responsible for two things:\n                // 1. Maintaining the default in-memory registry of component configuration objects\n                //    (i.e., the thing you're writing to when you call ko.components.register(someName, ...))\n                // 2. Answering requests for components by fetching configuration objects\n                //    from that default in-memory registry and resolving them into standard\n                //    component definition objects (of the form { createViewModel: ..., template: ... })\n                // Custom loaders may override either of these facilities, i.e.,\n                // 1. To supply configuration objects from some other source (e.g., conventions)\n                // 2. Or, to resolve configuration objects by loading viewmodels/templates via arbitrary logic.\n\n                var defaultConfigRegistry = {};\n\n                ko.components.register = function(componentName, config) {\n                    if (!config) {\n                        throw new Error('Invalid configuration for ' + componentName);\n                    }\n\n                    if (ko.components.isRegistered(componentName)) {\n                        throw new Error('Component ' + componentName + ' is already registered');\n                    }\n\n                    defaultConfigRegistry[componentName] = config;\n                };\n\n                ko.components.isRegistered = function(componentName) {\n                    return Object.prototype.hasOwnProperty.call(defaultConfigRegistry, componentName);\n                };\n\n                ko.components.unregister = function(componentName) {\n                    delete defaultConfigRegistry[componentName];\n                    ko.components.clearCachedDefinition(componentName);\n                };\n\n                ko.components.defaultLoader = {\n                    'getConfig': function(componentName, callback) {\n                        var result = ko.components.isRegistered(componentName)\n                            ? defaultConfigRegistry[componentName]\n                            : null;\n                        callback(result);\n                    },\n\n                    'loadComponent': function(componentName, config, callback) {\n                        var errorCallback = makeErrorCallback(componentName);\n                        possiblyGetConfigFromAmd(errorCallback, config, function(loadedConfig) {\n                            resolveConfig(componentName, errorCallback, loadedConfig, callback);\n                        });\n                    },\n\n                    'loadTemplate': function(componentName, templateConfig, callback) {\n                        resolveTemplate(makeErrorCallback(componentName), templateConfig, callback);\n                    },\n\n                    'loadViewModel': function(componentName, viewModelConfig, callback) {\n                        resolveViewModel(makeErrorCallback(componentName), viewModelConfig, callback);\n                    }\n                };\n\n                var createViewModelKey = 'createViewModel';\n\n                // Takes a config object of the form { template: ..., viewModel: ... }, and asynchronously convert it\n                // into the standard component definition format:\n                //    { template: <ArrayOfDomNodes>, createViewModel: function(params, componentInfo) { ... } }.\n                // Since both template and viewModel may need to be resolved asynchronously, both tasks are performed\n                // in parallel, and the results joined when both are ready. We don't depend on any promises infrastructure,\n                // so this is implemented manually below.\n                function resolveConfig(componentName, errorCallback, config, callback) {\n                    var result = {},\n                        makeCallBackWhenZero = 2,\n                        tryIssueCallback = function() {\n                            if (--makeCallBackWhenZero === 0) {\n                                callback(result);\n                            }\n                        },\n                        templateConfig = config['template'],\n                        viewModelConfig = config['viewModel'];\n\n                    if (templateConfig) {\n                        possiblyGetConfigFromAmd(errorCallback, templateConfig, function(loadedConfig) {\n                            ko.components._getFirstResultFromLoaders('loadTemplate', [componentName, loadedConfig], function(resolvedTemplate) {\n                                result['template'] = resolvedTemplate;\n                                tryIssueCallback();\n                            });\n                        });\n                    } else {\n                        tryIssueCallback();\n                    }\n\n                    if (viewModelConfig) {\n                        possiblyGetConfigFromAmd(errorCallback, viewModelConfig, function(loadedConfig) {\n                            ko.components._getFirstResultFromLoaders('loadViewModel', [componentName, loadedConfig], function(resolvedViewModel) {\n                                result[createViewModelKey] = resolvedViewModel;\n                                tryIssueCallback();\n                            });\n                        });\n                    } else {\n                        tryIssueCallback();\n                    }\n                }\n\n                function resolveTemplate(errorCallback, templateConfig, callback) {\n                    if (typeof templateConfig === 'string') {\n                        // Markup - parse it\n                        callback(ko.utils.parseHtmlFragment(templateConfig));\n                    } else if (templateConfig instanceof Array) {\n                        // Assume already an array of DOM nodes - pass through unchanged\n                        callback(templateConfig);\n                    } else if (isDocumentFragment(templateConfig)) {\n                        // Document fragment - use its child nodes\n                        callback(ko.utils.makeArray(templateConfig.childNodes));\n                    } else if (templateConfig['element']) {\n                        var element = templateConfig['element'];\n                        if (isDomElement(element)) {\n                            // Element instance - copy its child nodes\n                            callback(cloneNodesFromTemplateSourceElement(element));\n                        } else if (typeof element === 'string') {\n                            // Element ID - find it, then copy its child nodes\n                            var elemInstance = document.getElementById(element);\n                            if (elemInstance) {\n                                callback(cloneNodesFromTemplateSourceElement(elemInstance));\n                            } else {\n                                errorCallback('Cannot find element with ID ' + element);\n                            }\n                        } else {\n                            errorCallback('Unknown element type: ' + element);\n                        }\n                    } else {\n                        errorCallback('Unknown template value: ' + templateConfig);\n                    }\n                }\n\n                function resolveViewModel(errorCallback, viewModelConfig, callback) {\n                    if (typeof viewModelConfig === 'function') {\n                        // Constructor - convert to standard factory function format\n                        // By design, this does *not* supply componentInfo to the constructor, as the intent is that\n                        // componentInfo contains non-viewmodel data (e.g., the component's element) that should only\n                        // be used in factory functions, not viewmodel constructors.\n                        callback(function (params /*, componentInfo */) {\n                            return new viewModelConfig(params);\n                        });\n                    } else if (typeof viewModelConfig[createViewModelKey] === 'function') {\n                        // Already a factory function - use it as-is\n                        callback(viewModelConfig[createViewModelKey]);\n                    } else if ('instance' in viewModelConfig) {\n                        // Fixed object instance - promote to createViewModel format for API consistency\n                        var fixedInstance = viewModelConfig['instance'];\n                        callback(function (params, componentInfo) {\n                            return fixedInstance;\n                        });\n                    } else if ('viewModel' in viewModelConfig) {\n                        // Resolved AMD module whose value is of the form { viewModel: ... }\n                        resolveViewModel(errorCallback, viewModelConfig['viewModel'], callback);\n                    } else {\n                        errorCallback('Unknown viewModel value: ' + viewModelConfig);\n                    }\n                }\n\n                function cloneNodesFromTemplateSourceElement(elemInstance) {\n                    switch (ko.utils.tagNameLower(elemInstance)) {\n                        case 'script':\n                            return ko.utils.parseHtmlFragment(elemInstance.text);\n                        case 'textarea':\n                            return ko.utils.parseHtmlFragment(elemInstance.value);\n                        case 'template':\n                            // For browsers with proper <template> element support (i.e., where the .content property\n                            // gives a document fragment), use that document fragment.\n                            if (isDocumentFragment(elemInstance.content)) {\n                                return ko.utils.cloneNodes(elemInstance.content.childNodes);\n                            }\n                    }\n\n                    // Regular elements such as <div>, and <template> elements on old browsers that don't really\n                    // understand <template> and just treat it as a regular container\n                    return ko.utils.cloneNodes(elemInstance.childNodes);\n                }\n\n                function isDomElement(obj) {\n                    if (window['HTMLElement']) {\n                        return obj instanceof HTMLElement;\n                    } else {\n                        return obj && obj.tagName && obj.nodeType === 1;\n                    }\n                }\n\n                function isDocumentFragment(obj) {\n                    if (window['DocumentFragment']) {\n                        return obj instanceof DocumentFragment;\n                    } else {\n                        return obj && obj.nodeType === 11;\n                    }\n                }\n\n                function possiblyGetConfigFromAmd(errorCallback, config, callback) {\n                    if (typeof config['require'] === 'string') {\n                        // The config is the value of an AMD module\n                        if (amdRequire || window['require']) {\n                            (amdRequire || window['require'])([config['require']], function (module) {\n                                if (module && typeof module === 'object' && module.__esModule && module.default) {\n                                    module = module.default;\n                                }\n                                callback(module);\n                            });\n                        } else {\n                            errorCallback('Uses require, but no AMD loader is present');\n                        }\n                    } else {\n                        callback(config);\n                    }\n                }\n\n                function makeErrorCallback(componentName) {\n                    return function (message) {\n                        throw new Error('Component \\'' + componentName + '\\': ' + message);\n                    };\n                }\n\n                ko.exportSymbol('components.register', ko.components.register);\n                ko.exportSymbol('components.isRegistered', ko.components.isRegistered);\n                ko.exportSymbol('components.unregister', ko.components.unregister);\n\n                // Expose the default loader so that developers can directly ask it for configuration\n                // or to resolve configuration\n                ko.exportSymbol('components.defaultLoader', ko.components.defaultLoader);\n\n                // By default, the default loader is the only registered component loader\n                ko.components['loaders'].push(ko.components.defaultLoader);\n\n                // Privately expose the underlying config registry for use in old-IE shim\n                ko.components._allRegisteredComponents = defaultConfigRegistry;\n            })();\n            (function (undefined) {\n                // Overridable API for determining which component name applies to a given node. By overriding this,\n                // you can for example map specific tagNames to components that are not preregistered.\n                ko.components['getComponentNameForNode'] = function(node) {\n                    var tagNameLower = ko.utils.tagNameLower(node);\n                    if (ko.components.isRegistered(tagNameLower)) {\n                        // Try to determine that this node can be considered a *custom* element; see https://github.com/knockout/knockout/issues/1603\n                        if (tagNameLower.indexOf('-') != -1 || ('' + node) == \"[object HTMLUnknownElement]\" || (ko.utils.ieVersion <= 8 && node.tagName === tagNameLower)) {\n                            return tagNameLower;\n                        }\n                    }\n                };\n\n                ko.components.addBindingsForCustomElement = function(allBindings, node, bindingContext, valueAccessors) {\n                    // Determine if it's really a custom element matching a component\n                    if (node.nodeType === 1) {\n                        var componentName = ko.components['getComponentNameForNode'](node);\n                        if (componentName) {\n                            // It does represent a component, so add a component binding for it\n                            allBindings = allBindings || {};\n\n                            if (allBindings['component']) {\n                                // Avoid silently overwriting some other 'component' binding that may already be on the element\n                                throw new Error('Cannot use the \"component\" binding on a custom element matching a component');\n                            }\n\n                            var componentBindingValue = { 'name': componentName, 'params': getComponentParamsFromCustomElement(node, bindingContext) };\n\n                            allBindings['component'] = valueAccessors\n                                ? function() { return componentBindingValue; }\n                                : componentBindingValue;\n                        }\n                    }\n\n                    return allBindings;\n                }\n\n                var nativeBindingProviderInstance = new ko.bindingProvider();\n\n                function getComponentParamsFromCustomElement(elem, bindingContext) {\n                    var paramsAttribute = elem.getAttribute('params');\n\n                    if (paramsAttribute) {\n                        var params = nativeBindingProviderInstance['parseBindingsString'](paramsAttribute, bindingContext, elem, { 'valueAccessors': true, 'bindingParams': true }),\n                            rawParamComputedValues = ko.utils.objectMap(params, function(paramValue, paramName) {\n                                return ko.computed(paramValue, null, { disposeWhenNodeIsRemoved: elem });\n                            }),\n                            result = ko.utils.objectMap(rawParamComputedValues, function(paramValueComputed, paramName) {\n                                var paramValue = paramValueComputed.peek();\n                                // Does the evaluation of the parameter value unwrap any observables?\n                                if (!paramValueComputed.isActive()) {\n                                    // No it doesn't, so there's no need for any computed wrapper. Just pass through the supplied value directly.\n                                    // Example: \"someVal: firstName, age: 123\" (whether or not firstName is an observable/computed)\n                                    return paramValue;\n                                } else {\n                                    // Yes it does. Supply a computed property that unwraps both the outer (binding expression)\n                                    // level of observability, and any inner (resulting model value) level of observability.\n                                    // This means the component doesn't have to worry about multiple unwrapping. If the value is a\n                                    // writable observable, the computed will also be writable and pass the value on to the observable.\n                                    return ko.computed({\n                                        'read': function() {\n                                            return ko.utils.unwrapObservable(paramValueComputed());\n                                        },\n                                        'write': ko.isWriteableObservable(paramValue) && function(value) {\n                                            paramValueComputed()(value);\n                                        },\n                                        disposeWhenNodeIsRemoved: elem\n                                    });\n                                }\n                            });\n\n                        // Give access to the raw computeds, as long as that wouldn't overwrite any custom param also called '$raw'\n                        // This is in case the developer wants to react to outer (binding) observability separately from inner\n                        // (model value) observability, or in case the model value observable has subobservables.\n                        if (!Object.prototype.hasOwnProperty.call(result, '$raw')) {\n                            result['$raw'] = rawParamComputedValues;\n                        }\n\n                        return result;\n                    } else {\n                        // For consistency, absence of a \"params\" attribute is treated the same as the presence of\n                        // any empty one. Otherwise component viewmodels need special code to check whether or not\n                        // 'params' or 'params.$raw' is null/undefined before reading subproperties, which is annoying.\n                        return { '$raw': {} };\n                    }\n                }\n\n                // --------------------------------------------------------------------------------\n                // Compatibility code for older (pre-HTML5) IE browsers\n\n                if (ko.utils.ieVersion < 9) {\n                    // Whenever you preregister a component, enable it as a custom element in the current document\n                    ko.components['register'] = (function(originalFunction) {\n                        return function(componentName) {\n                            document.createElement(componentName); // Allows IE<9 to parse markup containing the custom element\n                            return originalFunction.apply(this, arguments);\n                        }\n                    })(ko.components['register']);\n\n                    // Whenever you create a document fragment, enable all preregistered component names as custom elements\n                    // This is needed to make innerShiv/jQuery HTML parsing correctly handle the custom elements\n                    document.createDocumentFragment = (function(originalFunction) {\n                        return function() {\n                            var newDocFrag = originalFunction(),\n                                allComponents = ko.components._allRegisteredComponents;\n                            for (var componentName in allComponents) {\n                                if (Object.prototype.hasOwnProperty.call(allComponents, componentName)) {\n                                    newDocFrag.createElement(componentName);\n                                }\n                            }\n                            return newDocFrag;\n                        };\n                    })(document.createDocumentFragment);\n                }\n            })();(function(undefined) {\n                var componentLoadingOperationUniqueId = 0;\n\n                ko.bindingHandlers['component'] = {\n                    'init': function(element, valueAccessor, ignored1, ignored2, bindingContext) {\n                        var currentViewModel,\n                            currentLoadingOperationId,\n                            afterRenderSub,\n                            disposeAssociatedComponentViewModel = function () {\n                                var currentViewModelDispose = currentViewModel && currentViewModel['dispose'];\n                                if (typeof currentViewModelDispose === 'function') {\n                                    currentViewModelDispose.call(currentViewModel);\n                                }\n                                if (afterRenderSub) {\n                                    afterRenderSub.dispose();\n                                }\n                                afterRenderSub = null;\n                                currentViewModel = null;\n                                // Any in-flight loading operation is no longer relevant, so make sure we ignore its completion\n                                currentLoadingOperationId = null;\n                            },\n                            originalChildNodes = ko.utils.makeArray(ko.virtualElements.childNodes(element));\n\n                        ko.virtualElements.emptyNode(element);\n                        ko.utils.domNodeDisposal.addDisposeCallback(element, disposeAssociatedComponentViewModel);\n\n                        ko.computed(function () {\n                            var value = ko.utils.unwrapObservable(valueAccessor()),\n                                componentName, componentParams;\n\n                            if (typeof value === 'string') {\n                                componentName = value;\n                            } else {\n                                componentName = ko.utils.unwrapObservable(value['name']);\n                                componentParams = ko.utils.unwrapObservable(value['params']);\n                            }\n\n                            if (!componentName) {\n                                throw new Error('No component name specified');\n                            }\n\n                            var asyncContext = ko.bindingEvent.startPossiblyAsyncContentBinding(element, bindingContext);\n\n                            var loadingOperationId = currentLoadingOperationId = ++componentLoadingOperationUniqueId;\n                            ko.components.get(componentName, function(componentDefinition) {\n                                // If this is not the current load operation for this element, ignore it.\n                                if (currentLoadingOperationId !== loadingOperationId) {\n                                    return;\n                                }\n\n                                // Clean up previous state\n                                disposeAssociatedComponentViewModel();\n\n                                // Instantiate and bind new component. Implicitly this cleans any old DOM nodes.\n                                if (!componentDefinition) {\n                                    throw new Error('Unknown component \\'' + componentName + '\\'');\n                                }\n                                cloneTemplateIntoElement(componentName, componentDefinition, element);\n\n                                var componentInfo = {\n                                    'element': element,\n                                    'templateNodes': originalChildNodes\n                                };\n\n                                var componentViewModel = createViewModel(componentDefinition, componentParams, componentInfo),\n                                    childBindingContext = asyncContext['createChildContext'](componentViewModel, {\n                                        'extend': function(ctx) {\n                                            ctx['$component'] = componentViewModel;\n                                            ctx['$componentTemplateNodes'] = originalChildNodes;\n                                        }\n                                    });\n\n                                if (componentViewModel && componentViewModel['koDescendantsComplete']) {\n                                    afterRenderSub = ko.bindingEvent.subscribe(element, ko.bindingEvent.descendantsComplete, componentViewModel['koDescendantsComplete'], componentViewModel);\n                                }\n\n                                currentViewModel = componentViewModel;\n                                ko.applyBindingsToDescendants(childBindingContext, element);\n                            });\n                        }, null, { disposeWhenNodeIsRemoved: element });\n\n                        return { 'controlsDescendantBindings': true };\n                    }\n                };\n\n                ko.virtualElements.allowedBindings['component'] = true;\n\n                function cloneTemplateIntoElement(componentName, componentDefinition, element) {\n                    var template = componentDefinition['template'];\n                    if (!template) {\n                        throw new Error('Component \\'' + componentName + '\\' has no template');\n                    }\n\n                    var clonedNodesArray = ko.utils.cloneNodes(template);\n                    ko.virtualElements.setDomNodeChildren(element, clonedNodesArray);\n                }\n\n                function createViewModel(componentDefinition, componentParams, componentInfo) {\n                    var componentViewModelFactory = componentDefinition['createViewModel'];\n                    return componentViewModelFactory\n                        ? componentViewModelFactory.call(componentDefinition, componentParams, componentInfo)\n                        : componentParams; // Template-only component\n                }\n\n            })();\n            var attrHtmlToJavaScriptMap = { 'class': 'className', 'for': 'htmlFor' };\n            ko.bindingHandlers['attr'] = {\n                'update': function(element, valueAccessor, allBindings) {\n                    var value = ko.utils.unwrapObservable(valueAccessor()) || {};\n                    ko.utils.objectForEach(value, function(attrName, attrValue) {\n                        attrValue = ko.utils.unwrapObservable(attrValue);\n\n                        // Find the namespace of this attribute, if any.\n                        var prefixLen = attrName.indexOf(':');\n                        var namespace = \"lookupNamespaceURI\" in element && prefixLen > 0 && element.lookupNamespaceURI(attrName.substr(0, prefixLen));\n\n                        // To cover cases like \"attr: { checked:someProp }\", we want to remove the attribute entirely\n                        // when someProp is a \"no value\"-like value (strictly null, false, or undefined)\n                        // (because the absence of the \"checked\" attr is how to mark an element as not checked, etc.)\n                        var toRemove = (attrValue === false) || (attrValue === null) || (attrValue === undefined);\n                        if (toRemove) {\n                            namespace ? element.removeAttributeNS(namespace, attrName) : element.removeAttribute(attrName);\n                        } else {\n                            attrValue = attrValue.toString();\n                        }\n\n                        // In IE <= 7 and IE8 Quirks Mode, you have to use the JavaScript property name instead of the\n                        // HTML attribute name for certain attributes. IE8 Standards Mode supports the correct behavior,\n                        // but instead of figuring out the mode, we'll just set the attribute through the JavaScript\n                        // property for IE <= 8.\n                        if (ko.utils.ieVersion <= 8 && attrName in attrHtmlToJavaScriptMap) {\n                            attrName = attrHtmlToJavaScriptMap[attrName];\n                            if (toRemove)\n                                element.removeAttribute(attrName);\n                            else\n                                element[attrName] = attrValue;\n                        } else if (!toRemove) {\n                            namespace ? element.setAttributeNS(namespace, attrName, attrValue) : element.setAttribute(attrName, attrValue);\n                        }\n\n                        // Treat \"name\" specially - although you can think of it as an attribute, it also needs\n                        // special handling on older versions of IE (https://github.com/SteveSanderson/knockout/pull/333)\n                        // Deliberately being case-sensitive here because XHTML would regard \"Name\" as a different thing\n                        // entirely, and there's no strong reason to allow for such casing in HTML.\n                        if (attrName === \"name\") {\n                            ko.utils.setElementName(element, toRemove ? \"\" : attrValue);\n                        }\n                    });\n                }\n            };\n            (function() {\n\n                ko.bindingHandlers['checked'] = {\n                    'after': ['value', 'attr'],\n                    'init': function (element, valueAccessor, allBindings) {\n                        var checkedValue = ko.pureComputed(function() {\n                            // Treat \"value\" like \"checkedValue\" when it is included with \"checked\" binding\n                            if (allBindings['has']('checkedValue')) {\n                                return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n                            } else if (useElementValue) {\n                                if (allBindings['has']('value')) {\n                                    return ko.utils.unwrapObservable(allBindings.get('value'));\n                                } else {\n                                    return element.value;\n                                }\n                            }\n                        });\n\n                        function updateModel() {\n                            // This updates the model value from the view value.\n                            // It runs in response to DOM events (click) and changes in checkedValue.\n                            var isChecked = element.checked,\n                                elemValue = checkedValue();\n\n                            // When we're first setting up this computed, don't change any model state.\n                            if (ko.computedContext.isInitial()) {\n                                return;\n                            }\n\n                            // We can ignore unchecked radio buttons, because some other radio\n                            // button will be checked, and that one can take care of updating state.\n                            // Also ignore value changes to an already unchecked checkbox.\n                            if (!isChecked && (isRadio || ko.computedContext.getDependenciesCount())) {\n                                return;\n                            }\n\n                            var modelValue = ko.dependencyDetection.ignore(valueAccessor);\n                            if (valueIsArray) {\n                                var writableValue = rawValueIsNonArrayObservable ? modelValue.peek() : modelValue,\n                                    saveOldValue = oldElemValue;\n                                oldElemValue = elemValue;\n\n                                if (saveOldValue !== elemValue) {\n                                    // When we're responding to the checkedValue changing, and the element is\n                                    // currently checked, replace the old elem value with the new elem value\n                                    // in the model array.\n                                    if (isChecked) {\n                                        ko.utils.addOrRemoveItem(writableValue, elemValue, true);\n                                        ko.utils.addOrRemoveItem(writableValue, saveOldValue, false);\n                                    }\n                                } else {\n                                    // When we're responding to the user having checked/unchecked a checkbox,\n                                    // add/remove the element value to the model array.\n                                    ko.utils.addOrRemoveItem(writableValue, elemValue, isChecked);\n                                }\n\n                                if (rawValueIsNonArrayObservable && ko.isWriteableObservable(modelValue)) {\n                                    modelValue(writableValue);\n                                }\n                            } else {\n                                if (isCheckbox) {\n                                    if (elemValue === undefined) {\n                                        elemValue = isChecked;\n                                    } else if (!isChecked) {\n                                        elemValue = undefined;\n                                    }\n                                }\n                                ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n                            }\n                        };\n\n                        function updateView() {\n                            // This updates the view value from the model value.\n                            // It runs in response to changes in the bound (checked) value.\n                            var modelValue = ko.utils.unwrapObservable(valueAccessor()),\n                                elemValue = checkedValue();\n\n                            if (valueIsArray) {\n                                // When a checkbox is bound to an array, being checked represents its value being present in that array\n                                element.checked = ko.utils.arrayIndexOf(modelValue, elemValue) >= 0;\n                                oldElemValue = elemValue;\n                            } else if (isCheckbox && elemValue === undefined) {\n                                // When a checkbox is bound to any other value (not an array) and \"checkedValue\" is not defined,\n                                // being checked represents the value being trueish\n                                element.checked = !!modelValue;\n                            } else {\n                                // Otherwise, being checked means that the checkbox or radio button's value corresponds to the model value\n                                element.checked = (checkedValue() === modelValue);\n                            }\n                        };\n\n                        var isCheckbox = element.type == \"checkbox\",\n                            isRadio = element.type == \"radio\";\n\n                        // Only bind to check boxes and radio buttons\n                        if (!isCheckbox && !isRadio) {\n                            return;\n                        }\n\n                        var rawValue = valueAccessor(),\n                            valueIsArray = isCheckbox && (ko.utils.unwrapObservable(rawValue) instanceof Array),\n                            rawValueIsNonArrayObservable = !(valueIsArray && rawValue.push && rawValue.splice),\n                            useElementValue = isRadio || valueIsArray,\n                            oldElemValue = valueIsArray ? checkedValue() : undefined;\n\n                        // IE 6 won't allow radio buttons to be selected unless they have a name\n                        if (isRadio && !element.name)\n                            ko.bindingHandlers['uniqueName']['init'](element, function() { return true });\n\n                        // Set up two computeds to update the binding:\n\n                        // The first responds to changes in the checkedValue value and to element clicks\n                        ko.computed(updateModel, null, { disposeWhenNodeIsRemoved: element });\n                        ko.utils.registerEventHandler(element, \"click\", updateModel);\n\n                        // The second responds to changes in the model value (the one associated with the checked binding)\n                        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n\n                        rawValue = undefined;\n                    }\n                };\n                ko.expressionRewriting.twoWayBindings['checked'] = true;\n\n                ko.bindingHandlers['checkedValue'] = {\n                    'update': function (element, valueAccessor) {\n                        element.value = ko.utils.unwrapObservable(valueAccessor());\n                    }\n                };\n\n            })();var classesWrittenByBindingKey = '__ko__cssValue';\n            ko.bindingHandlers['class'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.stringTrim(ko.utils.unwrapObservable(valueAccessor()));\n                    ko.utils.toggleDomNodeCssClass(element, element[classesWrittenByBindingKey], false);\n                    element[classesWrittenByBindingKey] = value;\n                    ko.utils.toggleDomNodeCssClass(element, value, true);\n                }\n            };\n\n            ko.bindingHandlers['css'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    if (value !== null && typeof value == \"object\") {\n                        ko.utils.objectForEach(value, function(className, shouldHaveClass) {\n                            shouldHaveClass = ko.utils.unwrapObservable(shouldHaveClass);\n                            ko.utils.toggleDomNodeCssClass(element, className, shouldHaveClass);\n                        });\n                    } else {\n                        ko.bindingHandlers['class']['update'](element, valueAccessor);\n                    }\n                }\n            };\n            ko.bindingHandlers['enable'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    if (value && element.disabled)\n                        element.removeAttribute(\"disabled\");\n                    else if ((!value) && (!element.disabled))\n                        element.disabled = true;\n                }\n            };\n\n            ko.bindingHandlers['disable'] = {\n                'update': function (element, valueAccessor) {\n                    ko.bindingHandlers['enable']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n                }\n            };\n// For certain common events (currently just 'click'), allow a simplified data-binding syntax\n// e.g. click:handler instead of the usual full-length event:{click:handler}\n            function makeEventHandlerShortcut(eventName) {\n                ko.bindingHandlers[eventName] = {\n                    'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                        var newValueAccessor = function () {\n                            var result = {};\n                            result[eventName] = valueAccessor();\n                            return result;\n                        };\n                        return ko.bindingHandlers['event']['init'].call(this, element, newValueAccessor, allBindings, viewModel, bindingContext);\n                    }\n                }\n            }\n\n            ko.bindingHandlers['event'] = {\n                'init' : function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    var eventsToHandle = valueAccessor() || {};\n                    ko.utils.objectForEach(eventsToHandle, function(eventName) {\n                        if (typeof eventName == \"string\") {\n                            ko.utils.registerEventHandler(element, eventName, function (event) {\n                                var handlerReturnValue;\n                                var handlerFunction = valueAccessor()[eventName];\n                                if (!handlerFunction)\n                                    return;\n\n                                try {\n                                    // Take all the event args, and prefix with the viewmodel\n                                    var argsForHandler = ko.utils.makeArray(arguments);\n                                    viewModel = bindingContext['$data'];\n                                    argsForHandler.unshift(viewModel);\n                                    handlerReturnValue = handlerFunction.apply(viewModel, argsForHandler);\n                                } finally {\n                                    if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                                        if (event.preventDefault)\n                                            event.preventDefault();\n                                        else\n                                            event.returnValue = false;\n                                    }\n                                }\n\n                                var bubble = allBindings.get(eventName + 'Bubble') !== false;\n                                if (!bubble) {\n                                    event.cancelBubble = true;\n                                    if (event.stopPropagation)\n                                        event.stopPropagation();\n                                }\n                            });\n                        }\n                    });\n                }\n            };\n// \"foreach: someExpression\" is equivalent to \"template: { foreach: someExpression }\"\n// \"foreach: { data: someExpression, afterAdd: myfn }\" is equivalent to \"template: { foreach: someExpression, afterAdd: myfn }\"\n            ko.bindingHandlers['foreach'] = {\n                makeTemplateValueAccessor: function(valueAccessor) {\n                    return function() {\n                        var modelValue = valueAccessor(),\n                            unwrappedValue = ko.utils.peekObservable(modelValue);    // Unwrap without setting a dependency here\n\n                        // If unwrappedValue is the array, pass in the wrapped value on its own\n                        // The value will be unwrapped and tracked within the template binding\n                        // (See https://github.com/SteveSanderson/knockout/issues/523)\n                        if ((!unwrappedValue) || typeof unwrappedValue.length == \"number\")\n                            return { 'foreach': modelValue, 'templateEngine': ko.nativeTemplateEngine.instance };\n\n                        // If unwrappedValue.data is the array, preserve all relevant options and unwrap again value so we get updates\n                        ko.utils.unwrapObservable(modelValue);\n                        return {\n                            'foreach': unwrappedValue['data'],\n                            'as': unwrappedValue['as'],\n                            'noChildContext': unwrappedValue['noChildContext'],\n                            'includeDestroyed': unwrappedValue['includeDestroyed'],\n                            'afterAdd': unwrappedValue['afterAdd'],\n                            'beforeRemove': unwrappedValue['beforeRemove'],\n                            'afterRender': unwrappedValue['afterRender'],\n                            'beforeMove': unwrappedValue['beforeMove'],\n                            'afterMove': unwrappedValue['afterMove'],\n                            'templateEngine': ko.nativeTemplateEngine.instance\n                        };\n                    };\n                },\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    return ko.bindingHandlers['template']['init'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor));\n                },\n                'update': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    return ko.bindingHandlers['template']['update'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor), allBindings, viewModel, bindingContext);\n                }\n            };\n            ko.expressionRewriting.bindingRewriteValidators['foreach'] = false; // Can't rewrite control flow bindings\n            ko.virtualElements.allowedBindings['foreach'] = true;\n            var hasfocusUpdatingProperty = '__ko_hasfocusUpdating';\n            var hasfocusLastValue = '__ko_hasfocusLastValue';\n            ko.bindingHandlers['hasfocus'] = {\n                'init': function(element, valueAccessor, allBindings) {\n                    var handleElementFocusChange = function(isFocused) {\n                        // Where possible, ignore which event was raised and determine focus state using activeElement,\n                        // as this avoids phantom focus/blur events raised when changing tabs in modern browsers.\n                        // However, not all KO-targeted browsers (Firefox 2) support activeElement. For those browsers,\n                        // prevent a loss of focus when changing tabs/windows by setting a flag that prevents hasfocus\n                        // from calling 'blur()' on the element when it loses focus.\n                        // Discussion at https://github.com/SteveSanderson/knockout/pull/352\n                        element[hasfocusUpdatingProperty] = true;\n                        var ownerDoc = element.ownerDocument;\n                        if (\"activeElement\" in ownerDoc) {\n                            var active;\n                            try {\n                                active = ownerDoc.activeElement;\n                            } catch(e) {\n                                // IE9 throws if you access activeElement during page load (see issue #703)\n                                active = ownerDoc.body;\n                            }\n                            isFocused = (active === element);\n                        }\n                        var modelValue = valueAccessor();\n                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'hasfocus', isFocused, true);\n\n                        //cache the latest value, so we can avoid unnecessarily calling focus/blur in the update function\n                        element[hasfocusLastValue] = isFocused;\n                        element[hasfocusUpdatingProperty] = false;\n                    };\n                    var handleElementFocusIn = handleElementFocusChange.bind(null, true);\n                    var handleElementFocusOut = handleElementFocusChange.bind(null, false);\n\n                    ko.utils.registerEventHandler(element, \"focus\", handleElementFocusIn);\n                    ko.utils.registerEventHandler(element, \"focusin\", handleElementFocusIn); // For IE\n                    ko.utils.registerEventHandler(element, \"blur\",  handleElementFocusOut);\n                    ko.utils.registerEventHandler(element, \"focusout\",  handleElementFocusOut); // For IE\n\n                    // Assume element is not focused (prevents \"blur\" being called initially)\n                    element[hasfocusLastValue] = false;\n                },\n                'update': function(element, valueAccessor) {\n                    var value = !!ko.utils.unwrapObservable(valueAccessor());\n\n                    if (!element[hasfocusUpdatingProperty] && element[hasfocusLastValue] !== value) {\n                        value ? element.focus() : element.blur();\n\n                        // In IE, the blur method doesn't always cause the element to lose focus (for example, if the window is not in focus).\n                        // Setting focus to the body element does seem to be reliable in IE, but should only be used if we know that the current\n                        // element was focused already.\n                        if (!value && element[hasfocusLastValue]) {\n                            element.ownerDocument.body.focus();\n                        }\n\n                        // For IE, which doesn't reliably fire \"focus\" or \"blur\" events synchronously\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, value ? \"focusin\" : \"focusout\"]);\n                    }\n                }\n            };\n            ko.expressionRewriting.twoWayBindings['hasfocus'] = true;\n\n            ko.bindingHandlers['hasFocus'] = ko.bindingHandlers['hasfocus']; // Make \"hasFocus\" an alias\n            ko.expressionRewriting.twoWayBindings['hasFocus'] = 'hasfocus';\n            ko.bindingHandlers['html'] = {\n                'init': function() {\n                    // Prevent binding on the dynamically-injected HTML (as developers are unlikely to expect that, and it has security implications)\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor) {\n                    // setHtml will unwrap the value if needed\n                    ko.utils.setHtml(element, valueAccessor());\n                }\n            };\n            (function () {\n\n// Makes a binding like with or if\n                function makeWithIfBinding(bindingKey, isWith, isNot) {\n                    ko.bindingHandlers[bindingKey] = {\n                        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                            var didDisplayOnLastUpdate, savedNodes, contextOptions = {}, completeOnRender, needAsyncContext, renderOnEveryChange;\n\n                            if (isWith) {\n                                var as = allBindings.get('as'), noChildContext = allBindings.get('noChildContext');\n                                renderOnEveryChange = !(as && noChildContext);\n                                contextOptions = { 'as': as, 'noChildContext': noChildContext, 'exportDependencies': renderOnEveryChange };\n                            }\n\n                            completeOnRender = allBindings.get(\"completeOn\") == \"render\";\n                            needAsyncContext = completeOnRender || allBindings['has'](ko.bindingEvent.descendantsComplete);\n\n                            ko.computed(function() {\n                                var value = ko.utils.unwrapObservable(valueAccessor()),\n                                    shouldDisplay = !isNot !== !value, // equivalent to isNot ? !value : !!value,\n                                    isInitial = !savedNodes,\n                                    childContext;\n\n                                if (!renderOnEveryChange && shouldDisplay === didDisplayOnLastUpdate) {\n                                    return;\n                                }\n\n                                if (needAsyncContext) {\n                                    bindingContext = ko.bindingEvent.startPossiblyAsyncContentBinding(element, bindingContext);\n                                }\n\n                                if (shouldDisplay) {\n                                    if (!isWith || renderOnEveryChange) {\n                                        contextOptions['dataDependency'] = ko.computedContext.computed();\n                                    }\n\n                                    if (isWith) {\n                                        childContext = bindingContext['createChildContext'](typeof value == \"function\" ? value : valueAccessor, contextOptions);\n                                    } else if (ko.computedContext.getDependenciesCount()) {\n                                        childContext = bindingContext['extend'](null, contextOptions);\n                                    } else {\n                                        childContext = bindingContext;\n                                    }\n                                }\n\n                                // Save a copy of the inner nodes on the initial update, but only if we have dependencies.\n                                if (isInitial && ko.computedContext.getDependenciesCount()) {\n                                    savedNodes = ko.utils.cloneNodes(ko.virtualElements.childNodes(element), true /* shouldCleanNodes */);\n                                }\n\n                                if (shouldDisplay) {\n                                    if (!isInitial) {\n                                        ko.virtualElements.setDomNodeChildren(element, ko.utils.cloneNodes(savedNodes));\n                                    }\n\n                                    ko.applyBindingsToDescendants(childContext, element);\n                                } else {\n                                    ko.virtualElements.emptyNode(element);\n\n                                    if (!completeOnRender) {\n                                        ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                                    }\n                                }\n\n                                didDisplayOnLastUpdate = shouldDisplay;\n\n                            }, null, { disposeWhenNodeIsRemoved: element });\n\n                            return { 'controlsDescendantBindings': true };\n                        }\n                    };\n                    ko.expressionRewriting.bindingRewriteValidators[bindingKey] = false; // Can't rewrite control flow bindings\n                    ko.virtualElements.allowedBindings[bindingKey] = true;\n                }\n\n// Construct the actual binding handlers\n                makeWithIfBinding('if');\n                makeWithIfBinding('ifnot', false /* isWith */, true /* isNot */);\n                makeWithIfBinding('with', true /* isWith */);\n\n            })();ko.bindingHandlers['let'] = {\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    // Make a modified binding context, with extra properties, and apply it to descendant elements\n                    var innerContext = bindingContext['extend'](valueAccessor);\n                    ko.applyBindingsToDescendants(innerContext, element);\n\n                    return { 'controlsDescendantBindings': true };\n                }\n            };\n            ko.virtualElements.allowedBindings['let'] = true;\n            var captionPlaceholder = {};\n            ko.bindingHandlers['options'] = {\n                'init': function(element) {\n                    if (ko.utils.tagNameLower(element) !== \"select\")\n                        throw new Error(\"options binding applies only to SELECT elements\");\n\n                    // Remove all existing <option>s.\n                    while (element.length > 0) {\n                        element.remove(0);\n                    }\n\n                    // Ensures that the binding processor doesn't try to bind the options\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor, allBindings) {\n                    function selectedOptions() {\n                        return ko.utils.arrayFilter(element.options, function (node) { return node.selected; });\n                    }\n\n                    var selectWasPreviouslyEmpty = element.length == 0,\n                        multiple = element.multiple,\n                        previousScrollTop = (!selectWasPreviouslyEmpty && multiple) ? element.scrollTop : null,\n                        unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n                        valueAllowUnset = allBindings.get('valueAllowUnset') && allBindings['has']('value'),\n                        includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n                        arrayToDomNodeChildrenOptions = {},\n                        captionValue,\n                        filteredArray,\n                        previousSelectedValues = [];\n\n                    if (!valueAllowUnset) {\n                        if (multiple) {\n                            previousSelectedValues = ko.utils.arrayMap(selectedOptions(), ko.selectExtensions.readValue);\n                        } else if (element.selectedIndex >= 0) {\n                            previousSelectedValues.push(ko.selectExtensions.readValue(element.options[element.selectedIndex]));\n                        }\n                    }\n\n                    if (unwrappedArray) {\n                        if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                            unwrappedArray = [unwrappedArray];\n\n                        // Filter out any entries marked as destroyed\n                        filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                            return includeDestroyed || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n                        });\n\n                        // If caption is included, add it to the array\n                        if (allBindings['has']('optionsCaption')) {\n                            captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                            // If caption value is null or undefined, don't show a caption\n                            if (captionValue !== null && captionValue !== undefined) {\n                                filteredArray.unshift(captionPlaceholder);\n                            }\n                        }\n                    } else {\n                        // If a falsy value is provided (e.g. null), we'll simply empty the select element\n                    }\n\n                    function applyToObject(object, predicate, defaultValue) {\n                        var predicateType = typeof predicate;\n                        if (predicateType == \"function\")    // Given a function; run it against the data value\n                            return predicate(object);\n                        else if (predicateType == \"string\") // Given a string; treat it as a property name on the data value\n                            return object[predicate];\n                        else                                // Given no optionsText arg; use the data value itself\n                            return defaultValue;\n                    }\n\n                    // The following functions can run at two different times:\n                    // The first is when the whole array is being updated directly from this binding handler.\n                    // The second is when an observable value for a specific array entry is updated.\n                    // oldOptions will be empty in the first case, but will be filled with the previously generated option in the second.\n                    var itemUpdate = false;\n                    function optionForArrayItem(arrayEntry, index, oldOptions) {\n                        if (oldOptions.length) {\n                            previousSelectedValues = !valueAllowUnset && oldOptions[0].selected ? [ ko.selectExtensions.readValue(oldOptions[0]) ] : [];\n                            itemUpdate = true;\n                        }\n                        var option = element.ownerDocument.createElement(\"option\");\n                        if (arrayEntry === captionPlaceholder) {\n                            ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                            ko.selectExtensions.writeValue(option, undefined);\n                        } else {\n                            // Apply a value to the option element\n                            var optionValue = applyToObject(arrayEntry, allBindings.get('optionsValue'), arrayEntry);\n                            ko.selectExtensions.writeValue(option, ko.utils.unwrapObservable(optionValue));\n\n                            // Apply some text to the option element\n                            var optionText = applyToObject(arrayEntry, allBindings.get('optionsText'), optionValue);\n                            ko.utils.setTextContent(option, optionText);\n                        }\n                        return [option];\n                    }\n\n                    // By using a beforeRemove callback, we delay the removal until after new items are added. This fixes a selection\n                    // problem in IE<=8 and Firefox. See https://github.com/knockout/knockout/issues/1208\n                    arrayToDomNodeChildrenOptions['beforeRemove'] =\n                        function (option) {\n                            element.removeChild(option);\n                        };\n\n                    function setSelectionCallback(arrayEntry, newOptions) {\n                        if (itemUpdate && valueAllowUnset) {\n                            // The model value is authoritative, so make sure its value is the one selected\n                            ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                        } else if (previousSelectedValues.length) {\n                            // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                            // That's why we first added them without selection. Now it's time to set the selection.\n                            var isSelected = ko.utils.arrayIndexOf(previousSelectedValues, ko.selectExtensions.readValue(newOptions[0])) >= 0;\n                            ko.utils.setOptionNodeSelectionState(newOptions[0], isSelected);\n\n                            // If this option was changed from being selected during a single-item update, notify the change\n                            if (itemUpdate && !isSelected) {\n                                ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                            }\n                        }\n                    }\n\n                    var callback = setSelectionCallback;\n                    if (allBindings['has']('optionsAfterRender') && typeof allBindings.get('optionsAfterRender') == \"function\") {\n                        callback = function(arrayEntry, newOptions) {\n                            setSelectionCallback(arrayEntry, newOptions);\n                            ko.dependencyDetection.ignore(allBindings.get('optionsAfterRender'), null, [newOptions[0], arrayEntry !== captionPlaceholder ? arrayEntry : undefined]);\n                        }\n                    }\n\n                    ko.utils.setDomNodeChildrenFromArrayMapping(element, filteredArray, optionForArrayItem, arrayToDomNodeChildrenOptions, callback);\n\n                    if (!valueAllowUnset) {\n                        // Determine if the selection has changed as a result of updating the options list\n                        var selectionChanged;\n                        if (multiple) {\n                            // For a multiple-select box, compare the new selection count to the previous one\n                            // But if nothing was selected before, the selection can't have changed\n                            selectionChanged = previousSelectedValues.length && selectedOptions().length < previousSelectedValues.length;\n                        } else {\n                            // For a single-select box, compare the current value to the previous value\n                            // But if nothing was selected before or nothing is selected now, just look for a change in selection\n                            selectionChanged = (previousSelectedValues.length && element.selectedIndex >= 0)\n                                ? (ko.selectExtensions.readValue(element.options[element.selectedIndex]) !== previousSelectedValues[0])\n                                : (previousSelectedValues.length || element.selectedIndex >= 0);\n                        }\n\n                        // Ensure consistency between model value and selected option.\n                        // If the dropdown was changed so that selection is no longer the same,\n                        // notify the value or selectedOptions binding.\n                        if (selectionChanged) {\n                            ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                        }\n                    }\n\n                    if (valueAllowUnset || ko.computedContext.isInitial()) {\n                        ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                    }\n\n                    // Workaround for IE bug\n                    ko.utils.ensureSelectElementIsRenderedCorrectly(element);\n\n                    if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20)\n                        element.scrollTop = previousScrollTop;\n                }\n            };\n            ko.bindingHandlers['options'].optionValueDomDataKey = ko.utils.domData.nextKey();\n            ko.bindingHandlers['selectedOptions'] = {\n                'init': function (element, valueAccessor, allBindings) {\n                    function updateFromView() {\n                        var value = valueAccessor(), valueToWrite = [];\n                        ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                            if (node.selected)\n                                valueToWrite.push(ko.selectExtensions.readValue(node));\n                        });\n                        ko.expressionRewriting.writeValueToProperty(value, allBindings, 'selectedOptions', valueToWrite);\n                    }\n\n                    function updateFromModel() {\n                        var newValue = ko.utils.unwrapObservable(valueAccessor()),\n                            previousScrollTop = element.scrollTop;\n\n                        if (newValue && typeof newValue.length == \"number\") {\n                            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                                var isSelected = ko.utils.arrayIndexOf(newValue, ko.selectExtensions.readValue(node)) >= 0;\n                                if (node.selected != isSelected) {      // This check prevents flashing of the select element in IE\n                                    ko.utils.setOptionNodeSelectionState(node, isSelected);\n                                }\n                            });\n                        }\n\n                        element.scrollTop = previousScrollTop;\n                    }\n\n                    if (ko.utils.tagNameLower(element) != \"select\") {\n                        throw new Error(\"selectedOptions binding applies only to SELECT elements\");\n                    }\n\n                    var updateFromModelComputed;\n                    ko.bindingEvent.subscribe(element, ko.bindingEvent.childrenComplete, function () {\n                        if (!updateFromModelComputed) {\n                            ko.utils.registerEventHandler(element, \"change\", updateFromView);\n                            updateFromModelComputed = ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                        } else {\n                            updateFromView();\n                        }\n                    }, null, { 'notifyImmediately': true });\n                },\n                'update': function() {} // Keep for backwards compatibility with code that may have wrapped binding\n            };\n            ko.expressionRewriting.twoWayBindings['selectedOptions'] = true;\n            ko.bindingHandlers['style'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor() || {});\n                    ko.utils.objectForEach(value, function(styleName, styleValue) {\n                        styleValue = ko.utils.unwrapObservable(styleValue);\n\n                        if (styleValue === null || styleValue === undefined || styleValue === false) {\n                            // Empty string removes the value, whereas null/undefined have no effect\n                            styleValue = \"\";\n                        }\n\n                        if (jQueryInstance) {\n                            jQueryInstance(element)['css'](styleName, styleValue);\n                        } else if (/^--/.test(styleName)) {\n                            // Is styleName a custom CSS property?\n                            element.style.setProperty(styleName, styleValue);\n                        } else {\n                            styleName = styleName.replace(/-(\\w)/g, function (all, letter) {\n                                return letter.toUpperCase();\n                            });\n\n                            var previousStyle = element.style[styleName];\n                            element.style[styleName] = styleValue;\n\n                            if (styleValue !== previousStyle && element.style[styleName] == previousStyle && !isNaN(styleValue)) {\n                                element.style[styleName] = styleValue + \"px\";\n                            }\n                        }\n                    });\n                }\n            };\n            ko.bindingHandlers['submit'] = {\n                'init': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    if (typeof valueAccessor() != \"function\")\n                        throw new Error(\"The value for a submit binding must be a function\");\n                    ko.utils.registerEventHandler(element, \"submit\", function (event) {\n                        var handlerReturnValue;\n                        var value = valueAccessor();\n                        try { handlerReturnValue = value.call(bindingContext['$data'], element); }\n                        finally {\n                            if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                                if (event.preventDefault)\n                                    event.preventDefault();\n                                else\n                                    event.returnValue = false;\n                            }\n                        }\n                    });\n                }\n            };\n            ko.bindingHandlers['text'] = {\n                'init': function() {\n                    // Prevent binding on the dynamically-injected text node (as developers are unlikely to expect that, and it has security implications).\n                    // It should also make things faster, as we no longer have to consider whether the text node might be bindable.\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor) {\n                    ko.utils.setTextContent(element, valueAccessor());\n                }\n            };\n            ko.virtualElements.allowedBindings['text'] = true;\n            (function () {\n\n                if (window && window.navigator) {\n                    var parseVersion = function (matches) {\n                        if (matches) {\n                            return parseFloat(matches[1]);\n                        }\n                    };\n\n                    // Detect various browser versions because some old versions don't fully support the 'input' event\n                    var userAgent = window.navigator.userAgent,\n                        operaVersion, chromeVersion, safariVersion, firefoxVersion, ieVersion, edgeVersion;\n\n                    (operaVersion = window.opera && window.opera.version && parseInt(window.opera.version()))\n                    || (edgeVersion = parseVersion(userAgent.match(/Edge\\/([^ ]+)$/)))\n                    || (chromeVersion = parseVersion(userAgent.match(/Chrome\\/([^ ]+)/)))\n                    || (safariVersion = parseVersion(userAgent.match(/Version\\/([^ ]+) Safari/)))\n                    || (firefoxVersion = parseVersion(userAgent.match(/Firefox\\/([^ ]+)/)))\n                    || (ieVersion = ko.utils.ieVersion || parseVersion(userAgent.match(/MSIE ([^ ]+)/)))      // Detects up to IE 10\n                    || (ieVersion = parseVersion(userAgent.match(/rv:([^ )]+)/)));      // Detects IE 11\n                }\n\n// IE 8 and 9 have bugs that prevent the normal events from firing when the value changes.\n// But it does fire the 'selectionchange' event on many of those, presumably because the\n// cursor is moving and that counts as the selection changing. The 'selectionchange' event is\n// fired at the document level only and doesn't directly indicate which element changed. We\n// set up just one event handler for the document and use 'activeElement' to determine which\n// element was changed.\n                if (ieVersion >= 8 && ieVersion < 10) {\n                    var selectionChangeRegisteredName = ko.utils.domData.nextKey(),\n                        selectionChangeHandlerName = ko.utils.domData.nextKey();\n                    var selectionChangeHandler = function(event) {\n                        var target = this.activeElement,\n                            handler = target && ko.utils.domData.get(target, selectionChangeHandlerName);\n                        if (handler) {\n                            handler(event);\n                        }\n                    };\n                    var registerForSelectionChangeEvent = function (element, handler) {\n                        var ownerDoc = element.ownerDocument;\n                        if (!ko.utils.domData.get(ownerDoc, selectionChangeRegisteredName)) {\n                            ko.utils.domData.set(ownerDoc, selectionChangeRegisteredName, true);\n                            ko.utils.registerEventHandler(ownerDoc, 'selectionchange', selectionChangeHandler);\n                        }\n                        ko.utils.domData.set(element, selectionChangeHandlerName, handler);\n                    };\n                }\n\n                ko.bindingHandlers['textInput'] = {\n                    'init': function (element, valueAccessor, allBindings) {\n\n                        var previousElementValue = element.value,\n                            timeoutHandle,\n                            elementValueBeforeEvent;\n\n                        var updateModel = function (event) {\n                            clearTimeout(timeoutHandle);\n                            elementValueBeforeEvent = timeoutHandle = undefined;\n\n                            var elementValue = element.value;\n                            if (previousElementValue !== elementValue) {\n                                // Provide a way for tests to know exactly which event was processed\n                                if (DEBUG && event) element['_ko_textInputProcessedEvent'] = event.type;\n                                previousElementValue = elementValue;\n                                ko.expressionRewriting.writeValueToProperty(valueAccessor(), allBindings, 'textInput', elementValue);\n                            }\n                        };\n\n                        var deferUpdateModel = function (event) {\n                            if (!timeoutHandle) {\n                                // The elementValueBeforeEvent variable is set *only* during the brief gap between an\n                                // event firing and the updateModel function running. This allows us to ignore model\n                                // updates that are from the previous state of the element, usually due to techniques\n                                // such as rateLimit. Such updates, if not ignored, can cause keystrokes to be lost.\n                                elementValueBeforeEvent = element.value;\n                                var handler = DEBUG ? updateModel.bind(element, {type: event.type}) : updateModel;\n                                timeoutHandle = ko.utils.setTimeout(handler, 4);\n                            }\n                        };\n\n                        // IE9 will mess up the DOM if you handle events synchronously which results in DOM changes (such as other bindings);\n                        // so we'll make sure all updates are asynchronous\n                        var ieUpdateModel = ko.utils.ieVersion == 9 ? deferUpdateModel : updateModel,\n                            ourUpdate = false;\n\n                        var updateView = function () {\n                            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                            if (modelValue === null || modelValue === undefined) {\n                                modelValue = '';\n                            }\n\n                            if (elementValueBeforeEvent !== undefined && modelValue === elementValueBeforeEvent) {\n                                ko.utils.setTimeout(updateView, 4);\n                                return;\n                            }\n\n                            // Update the element only if the element and model are different. On some browsers, updating the value\n                            // will move the cursor to the end of the input, which would be bad while the user is typing.\n                            if (element.value !== modelValue) {\n                                ourUpdate = true;  // Make sure we ignore events (propertychange) that result from updating the value\n                                element.value = modelValue;\n                                ourUpdate = false;\n                                previousElementValue = element.value; // In case the browser changes the value (see #2281)\n                            }\n                        };\n\n                        var onEvent = function (event, handler) {\n                            ko.utils.registerEventHandler(element, event, handler);\n                        };\n\n                        if (DEBUG && ko.bindingHandlers['textInput']['_forceUpdateOn']) {\n                            // Provide a way for tests to specify exactly which events are bound\n                            ko.utils.arrayForEach(ko.bindingHandlers['textInput']['_forceUpdateOn'], function(eventName) {\n                                if (eventName.slice(0,5) == 'after') {\n                                    onEvent(eventName.slice(5), deferUpdateModel);\n                                } else {\n                                    onEvent(eventName, updateModel);\n                                }\n                            });\n                        } else {\n                            if (ieVersion) {\n                                // All versions (including 11) of Internet Explorer have a bug that they don't generate an input or propertychange event when ESC is pressed\n                                onEvent('keypress', updateModel);\n                            }\n                            if (ieVersion < 11) {\n                                // Internet Explorer <= 8 doesn't support the 'input' event, but does include 'propertychange' that fires whenever\n                                // any property of an element changes. Unlike 'input', it also fires if a property is changed from JavaScript code,\n                                // but that's an acceptable compromise for this binding. IE 9 and 10 support 'input', but since they don't always\n                                // fire it when using autocomplete, we'll use 'propertychange' for them also.\n                                onEvent('propertychange', function(event) {\n                                    if (!ourUpdate && event.propertyName === 'value') {\n                                        ieUpdateModel(event);\n                                    }\n                                });\n                            }\n                            if (ieVersion == 8) {\n                                // IE 8 has a bug where it fails to fire 'propertychange' on the first update following a value change from\n                                // JavaScript code. It also doesn't fire if you clear the entire value. To fix this, we bind to the following\n                                // events too.\n                                onEvent('keyup', updateModel);      // A single keystoke\n                                onEvent('keydown', updateModel);    // The first character when a key is held down\n                            }\n                            if (registerForSelectionChangeEvent) {\n                                // Internet Explorer 9 doesn't fire the 'input' event when deleting text, including using\n                                // the backspace, delete, or ctrl-x keys, clicking the 'x' to clear the input, dragging text\n                                // out of the field, and cutting or deleting text using the context menu. 'selectionchange'\n                                // can detect all of those except dragging text out of the field, for which we use 'dragend'.\n                                // These are also needed in IE8 because of the bug described above.\n                                registerForSelectionChangeEvent(element, ieUpdateModel);  // 'selectionchange' covers cut, paste, drop, delete, etc.\n                                onEvent('dragend', deferUpdateModel);\n                            }\n\n                            if (!ieVersion || ieVersion >= 9) {\n                                // All other supported browsers support the 'input' event, which fires whenever the content of the element is changed\n                                // through the user interface.\n                                onEvent('input', ieUpdateModel);\n                            }\n\n                            if (safariVersion < 5 && ko.utils.tagNameLower(element) === \"textarea\") {\n                                // Safari <5 doesn't fire the 'input' event for <textarea> elements (it does fire 'textInput'\n                                // but only when typing). So we'll just catch as much as we can with keydown, cut, and paste.\n                                onEvent('keydown', deferUpdateModel);\n                                onEvent('paste', deferUpdateModel);\n                                onEvent('cut', deferUpdateModel);\n                            } else if (operaVersion < 11) {\n                                // Opera 10 doesn't always fire the 'input' event for cut, paste, undo & drop operations.\n                                // We can try to catch some of those using 'keydown'.\n                                onEvent('keydown', deferUpdateModel);\n                            } else if (firefoxVersion < 4.0) {\n                                // Firefox <= 3.6 doesn't fire the 'input' event when text is filled in through autocomplete\n                                onEvent('DOMAutoComplete', updateModel);\n\n                                // Firefox <=3.5 doesn't fire the 'input' event when text is dropped into the input.\n                                onEvent('dragdrop', updateModel);       // <3.5\n                                onEvent('drop', updateModel);           // 3.5\n                            } else if (edgeVersion && element.type === \"number\") {\n                                // Microsoft Edge doesn't fire 'input' or 'change' events for number inputs when\n                                // the value is changed via the up / down arrow keys\n                                onEvent('keydown', deferUpdateModel);\n                            }\n                        }\n\n                        // Bind to the change event so that we can catch programmatic updates of the value that fire this event.\n                        onEvent('change', updateModel);\n\n                        // To deal with browsers that don't notify any kind of event for some changes (IE, Safari, etc.)\n                        onEvent('blur', updateModel);\n\n                        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n                    }\n                };\n                ko.expressionRewriting.twoWayBindings['textInput'] = true;\n\n// textinput is an alias for textInput\n                ko.bindingHandlers['textinput'] = {\n                    // preprocess is the only way to set up a full alias\n                    'preprocess': function (value, name, addBinding) {\n                        addBinding('textInput', value);\n                    }\n                };\n\n            })();ko.bindingHandlers['uniqueName'] = {\n                'init': function (element, valueAccessor) {\n                    if (valueAccessor()) {\n                        var name = \"ko_unique_\" + (++ko.bindingHandlers['uniqueName'].currentIndex);\n                        ko.utils.setElementName(element, name);\n                    }\n                }\n            };\n            ko.bindingHandlers['uniqueName'].currentIndex = 0;\n            ko.bindingHandlers['using'] = {\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    var options;\n\n                    if (allBindings['has']('as')) {\n                        options = { 'as': allBindings.get('as'), 'noChildContext': allBindings.get('noChildContext') };\n                    }\n\n                    var innerContext = bindingContext['createChildContext'](valueAccessor, options);\n                    ko.applyBindingsToDescendants(innerContext, element);\n\n                    return { 'controlsDescendantBindings': true };\n                }\n            };\n            ko.virtualElements.allowedBindings['using'] = true;\n            ko.bindingHandlers['value'] = {\n                'init': function (element, valueAccessor, allBindings) {\n                    var tagName = ko.utils.tagNameLower(element),\n                        isInputElement = tagName == \"input\";\n\n                    // If the value binding is placed on a radio/checkbox, then just pass through to checkedValue and quit\n                    if (isInputElement && (element.type == \"checkbox\" || element.type == \"radio\")) {\n                        ko.applyBindingAccessorsToNode(element, { 'checkedValue': valueAccessor });\n                        return;\n                    }\n\n                    var eventsToCatch = [];\n                    var requestedEventsToCatch = allBindings.get(\"valueUpdate\");\n                    var propertyChangedFired = false;\n                    var elementValueBeforeEvent = null;\n\n                    if (requestedEventsToCatch) {\n                        // Allow both individual event names, and arrays of event names\n                        if (typeof requestedEventsToCatch == \"string\") {\n                            eventsToCatch = [requestedEventsToCatch];\n                        } else {\n                            eventsToCatch = ko.utils.arrayGetDistinctValues(requestedEventsToCatch);\n                        }\n                        ko.utils.arrayRemoveItem(eventsToCatch, \"change\");  // We'll subscribe to \"change\" events later\n                    }\n\n                    var valueUpdateHandler = function() {\n                        elementValueBeforeEvent = null;\n                        propertyChangedFired = false;\n                        var modelValue = valueAccessor();\n                        var elementValue = ko.selectExtensions.readValue(element);\n                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'value', elementValue);\n                    }\n\n                    // Workaround for https://github.com/SteveSanderson/knockout/issues/122\n                    // IE doesn't fire \"change\" events on textboxes if the user selects a value from its autocomplete list\n                    var ieAutoCompleteHackNeeded = ko.utils.ieVersion && isInputElement && element.type == \"text\"\n                        && element.autocomplete != \"off\" && (!element.form || element.form.autocomplete != \"off\");\n                    if (ieAutoCompleteHackNeeded && ko.utils.arrayIndexOf(eventsToCatch, \"propertychange\") == -1) {\n                        ko.utils.registerEventHandler(element, \"propertychange\", function () { propertyChangedFired = true });\n                        ko.utils.registerEventHandler(element, \"focus\", function () { propertyChangedFired = false });\n                        ko.utils.registerEventHandler(element, \"blur\", function() {\n                            if (propertyChangedFired) {\n                                valueUpdateHandler();\n                            }\n                        });\n                    }\n\n                    ko.utils.arrayForEach(eventsToCatch, function(eventName) {\n                        // The syntax \"after<eventname>\" means \"run the handler asynchronously after the event\"\n                        // This is useful, for example, to catch \"keydown\" events after the browser has updated the control\n                        // (otherwise, ko.selectExtensions.readValue(this) will receive the control's value *before* the key event)\n                        var handler = valueUpdateHandler;\n                        if (ko.utils.stringStartsWith(eventName, \"after\")) {\n                            handler = function() {\n                                // The elementValueBeforeEvent variable is non-null *only* during the brief gap between\n                                // a keyX event firing and the valueUpdateHandler running, which is scheduled to happen\n                                // at the earliest asynchronous opportunity. We store this temporary information so that\n                                // if, between keyX and valueUpdateHandler, the underlying model value changes separately,\n                                // we can overwrite that model value change with the value the user just typed. Otherwise,\n                                // techniques like rateLimit can trigger model changes at critical moments that will\n                                // override the user's inputs, causing keystrokes to be lost.\n                                elementValueBeforeEvent = ko.selectExtensions.readValue(element);\n                                ko.utils.setTimeout(valueUpdateHandler, 0);\n                            };\n                            eventName = eventName.substring(\"after\".length);\n                        }\n                        ko.utils.registerEventHandler(element, eventName, handler);\n                    });\n\n                    var updateFromModel;\n\n                    if (isInputElement && element.type == \"file\") {\n                        // For file input elements, can only write the empty string\n                        updateFromModel = function () {\n                            var newValue = ko.utils.unwrapObservable(valueAccessor());\n                            if (newValue === null || newValue === undefined || newValue === \"\") {\n                                element.value = \"\";\n                            } else {\n                                ko.dependencyDetection.ignore(valueUpdateHandler);  // reset the model to match the element\n                            }\n                        }\n                    } else {\n                        updateFromModel = function () {\n                            var newValue = ko.utils.unwrapObservable(valueAccessor());\n                            var elementValue = ko.selectExtensions.readValue(element);\n\n                            if (elementValueBeforeEvent !== null && newValue === elementValueBeforeEvent) {\n                                ko.utils.setTimeout(updateFromModel, 0);\n                                return;\n                            }\n\n                            var valueHasChanged = newValue !== elementValue;\n\n                            if (valueHasChanged || elementValue === undefined) {\n                                if (tagName === \"select\") {\n                                    var allowUnset = allBindings.get('valueAllowUnset');\n                                    ko.selectExtensions.writeValue(element, newValue, allowUnset);\n                                    if (!allowUnset && newValue !== ko.selectExtensions.readValue(element)) {\n                                        // If you try to set a model value that can't be represented in an already-populated dropdown, reject that change,\n                                        // because you're not allowed to have a model value that disagrees with a visible UI selection.\n                                        ko.dependencyDetection.ignore(valueUpdateHandler);\n                                    }\n                                } else {\n                                    ko.selectExtensions.writeValue(element, newValue);\n                                }\n                            }\n                        };\n                    }\n\n                    if (tagName === \"select\") {\n                        var updateFromModelComputed;\n                        ko.bindingEvent.subscribe(element, ko.bindingEvent.childrenComplete, function () {\n                            if (!updateFromModelComputed) {\n                                ko.utils.registerEventHandler(element, \"change\", valueUpdateHandler);\n                                updateFromModelComputed = ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                            } else if (allBindings.get('valueAllowUnset')) {\n                                updateFromModel();\n                            } else {\n                                valueUpdateHandler();\n                            }\n                        }, null, { 'notifyImmediately': true });\n                    } else {\n                        ko.utils.registerEventHandler(element, \"change\", valueUpdateHandler);\n                        ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                    }\n                },\n                'update': function() {} // Keep for backwards compatibility with code that may have wrapped value binding\n            };\n            ko.expressionRewriting.twoWayBindings['value'] = true;\n            ko.bindingHandlers['visible'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    var isCurrentlyVisible = !(element.style.display == \"none\");\n                    if (value && !isCurrentlyVisible)\n                        element.style.display = \"\";\n                    else if ((!value) && isCurrentlyVisible)\n                        element.style.display = \"none\";\n                }\n            };\n\n            ko.bindingHandlers['hidden'] = {\n                'update': function (element, valueAccessor) {\n                    ko.bindingHandlers['visible']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n                }\n            };\n// 'click' is just a shorthand for the usual full-length event:{click:handler}\n            makeEventHandlerShortcut('click');\n// If you want to make a custom template engine,\n//\n// [1] Inherit from this class (like ko.nativeTemplateEngine does)\n// [2] Override 'renderTemplateSource', supplying a function with this signature:\n//\n//        function (templateSource, bindingContext, options) {\n//            // - templateSource.text() is the text of the template you should render\n//            // - bindingContext.$data is the data you should pass into the template\n//            //   - you might also want to make bindingContext.$parent, bindingContext.$parents,\n//            //     and bindingContext.$root available in the template too\n//            // - options gives you access to any other properties set on \"data-bind: { template: options }\"\n//            // - templateDocument is the document object of the template\n//            //\n//            // Return value: an array of DOM nodes\n//        }\n//\n// [3] Override 'createJavaScriptEvaluatorBlock', supplying a function with this signature:\n//\n//        function (script) {\n//            // Return value: Whatever syntax means \"Evaluate the JavaScript statement 'script' and output the result\"\n//            //               For example, the jquery.tmpl template engine converts 'someScript' to '${ someScript }'\n//        }\n//\n//     This is only necessary if you want to allow data-bind attributes to reference arbitrary template variables.\n//     If you don't want to allow that, you can set the property 'allowTemplateRewriting' to false (like ko.nativeTemplateEngine does)\n//     and then you don't need to override 'createJavaScriptEvaluatorBlock'.\n\n            ko.templateEngine = function () { };\n\n            ko.templateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n                throw new Error(\"Override renderTemplateSource\");\n            };\n\n            ko.templateEngine.prototype['createJavaScriptEvaluatorBlock'] = function (script) {\n                throw new Error(\"Override createJavaScriptEvaluatorBlock\");\n            };\n\n            ko.templateEngine.prototype['makeTemplateSource'] = function(template, templateDocument) {\n                // Named template\n                if (typeof template == \"string\") {\n                    templateDocument = templateDocument || document;\n                    var elem = templateDocument.getElementById(template);\n                    if (!elem)\n                        throw new Error(\"Cannot find template with ID \" + template);\n                    return new ko.templateSources.domElement(elem);\n                } else if ((template.nodeType == 1) || (template.nodeType == 8)) {\n                    // Anonymous template\n                    return new ko.templateSources.anonymousTemplate(template);\n                } else\n                    throw new Error(\"Unknown template type: \" + template);\n            };\n\n            ko.templateEngine.prototype['renderTemplate'] = function (template, bindingContext, options, templateDocument) {\n                var templateSource = this['makeTemplateSource'](template, templateDocument);\n                return this['renderTemplateSource'](templateSource, bindingContext, options, templateDocument);\n            };\n\n            ko.templateEngine.prototype['isTemplateRewritten'] = function (template, templateDocument) {\n                // Skip rewriting if requested\n                if (this['allowTemplateRewriting'] === false)\n                    return true;\n                return this['makeTemplateSource'](template, templateDocument)['data'](\"isRewritten\");\n            };\n\n            ko.templateEngine.prototype['rewriteTemplate'] = function (template, rewriterCallback, templateDocument) {\n                var templateSource = this['makeTemplateSource'](template, templateDocument);\n                var rewritten = rewriterCallback(templateSource['text']());\n                templateSource['text'](rewritten);\n                templateSource['data'](\"isRewritten\", true);\n            };\n\n            ko.exportSymbol('templateEngine', ko.templateEngine);\n\n            ko.templateRewriting = (function () {\n                var memoizeDataBindingAttributeSyntaxRegex = /(<([a-z]+\\d*)(?:\\s+(?!data-bind\\s*=\\s*)[a-z0-9\\-]+(?:=(?:\\\"[^\\\"]*\\\"|\\'[^\\']*\\'|[^>]*))?)*\\s+)data-bind\\s*=\\s*([\"'])([\\s\\S]*?)\\3/gi;\n                var memoizeVirtualContainerBindingSyntaxRegex = /<!--\\s*ko\\b\\s*([\\s\\S]*?)\\s*-->/g;\n\n                function validateDataBindValuesForRewriting(keyValueArray) {\n                    var allValidators = ko.expressionRewriting.bindingRewriteValidators;\n                    for (var i = 0; i < keyValueArray.length; i++) {\n                        var key = keyValueArray[i]['key'];\n                        if (Object.prototype.hasOwnProperty.call(allValidators, key)) {\n                            var validator = allValidators[key];\n\n                            if (typeof validator === \"function\") {\n                                var possibleErrorMessage = validator(keyValueArray[i]['value']);\n                                if (possibleErrorMessage)\n                                    throw new Error(possibleErrorMessage);\n                            } else if (!validator) {\n                                throw new Error(\"This template engine does not support the '\" + key + \"' binding within its templates\");\n                            }\n                        }\n                    }\n                }\n\n                function constructMemoizedTagReplacement(dataBindAttributeValue, tagToRetain, nodeName, templateEngine) {\n                    var dataBindKeyValueArray = ko.expressionRewriting.parseObjectLiteral(dataBindAttributeValue);\n                    validateDataBindValuesForRewriting(dataBindKeyValueArray);\n                    var rewrittenDataBindAttributeValue = ko.expressionRewriting.preProcessBindings(dataBindKeyValueArray, {'valueAccessors':true});\n\n                    // For no obvious reason, Opera fails to evaluate rewrittenDataBindAttributeValue unless it's wrapped in an additional\n                    // anonymous function, even though Opera's built-in debugger can evaluate it anyway. No other browser requires this\n                    // extra indirection.\n                    var applyBindingsToNextSiblingScript =\n                        \"ko.__tr_ambtns(function($context,$element){return(function(){return{ \" + rewrittenDataBindAttributeValue + \" } })()},'\" + nodeName.toLowerCase() + \"')\";\n                    return templateEngine['createJavaScriptEvaluatorBlock'](applyBindingsToNextSiblingScript) + tagToRetain;\n                }\n\n                return {\n                    ensureTemplateIsRewritten: function (template, templateEngine, templateDocument) {\n                        if (!templateEngine['isTemplateRewritten'](template, templateDocument))\n                            templateEngine['rewriteTemplate'](template, function (htmlString) {\n                                return ko.templateRewriting.memoizeBindingAttributeSyntax(htmlString, templateEngine);\n                            }, templateDocument);\n                    },\n\n                    memoizeBindingAttributeSyntax: function (htmlString, templateEngine) {\n                        return htmlString.replace(memoizeDataBindingAttributeSyntaxRegex, function () {\n                            return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[4], /* tagToRetain: */ arguments[1], /* nodeName: */ arguments[2], templateEngine);\n                        }).replace(memoizeVirtualContainerBindingSyntaxRegex, function() {\n                            return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[1], /* tagToRetain: */ \"<!-- ko -->\", /* nodeName: */ \"#comment\", templateEngine);\n                        });\n                    },\n\n                    applyMemoizedBindingsToNextSibling: function (bindings, nodeName) {\n                        return ko.memoization.memoize(function (domNode, bindingContext) {\n                            var nodeToBind = domNode.nextSibling;\n                            if (nodeToBind && nodeToBind.nodeName.toLowerCase() === nodeName) {\n                                ko.applyBindingAccessorsToNode(nodeToBind, bindings, bindingContext);\n                            }\n                        });\n                    }\n                }\n            })();\n\n\n// Exported only because it has to be referenced by string lookup from within rewritten template\n            ko.exportSymbol('__tr_ambtns', ko.templateRewriting.applyMemoizedBindingsToNextSibling);\n            (function() {\n                // A template source represents a read/write way of accessing a template. This is to eliminate the need for template loading/saving\n                // logic to be duplicated in every template engine (and means they can all work with anonymous templates, etc.)\n                //\n                // Two are provided by default:\n                //  1. ko.templateSources.domElement       - reads/writes the text content of an arbitrary DOM element\n                //  2. ko.templateSources.anonymousElement - uses ko.utils.domData to read/write text *associated* with the DOM element, but\n                //                                           without reading/writing the actual element text content, since it will be overwritten\n                //                                           with the rendered template output.\n                // You can implement your own template source if you want to fetch/store templates somewhere other than in DOM elements.\n                // Template sources need to have the following functions:\n                //   text() \t\t\t- returns the template text from your storage location\n                //   text(value)\t\t- writes the supplied template text to your storage location\n                //   data(key)\t\t\t- reads values stored using data(key, value) - see below\n                //   data(key, value)\t- associates \"value\" with this template and the key \"key\". Is used to store information like \"isRewritten\".\n                //\n                // Optionally, template sources can also have the following functions:\n                //   nodes()            - returns a DOM element containing the nodes of this template, where available\n                //   nodes(value)       - writes the given DOM element to your storage location\n                // If a DOM element is available for a given template source, template engines are encouraged to use it in preference over text()\n                // for improved speed. However, all templateSources must supply text() even if they don't supply nodes().\n                //\n                // Once you've implemented a templateSource, make your template engine use it by subclassing whatever template engine you were\n                // using and overriding \"makeTemplateSource\" to return an instance of your custom template source.\n\n                ko.templateSources = {};\n\n                // ---- ko.templateSources.domElement -----\n\n                // template types\n                var templateScript = 1,\n                    templateTextArea = 2,\n                    templateTemplate = 3,\n                    templateElement = 4;\n\n                ko.templateSources.domElement = function(element) {\n                    this.domElement = element;\n\n                    if (element) {\n                        var tagNameLower = ko.utils.tagNameLower(element);\n                        this.templateType =\n                            tagNameLower === \"script\" ? templateScript :\n                                tagNameLower === \"textarea\" ? templateTextArea :\n                                    // For browsers with proper <template> element support, where the .content property gives a document fragment\n                                    tagNameLower == \"template\" && element.content && element.content.nodeType === 11 ? templateTemplate :\n                                        templateElement;\n                    }\n                }\n\n                ko.templateSources.domElement.prototype['text'] = function(/* valueToWrite */) {\n                    var elemContentsProperty = this.templateType === templateScript ? \"text\"\n                        : this.templateType === templateTextArea ? \"value\"\n                            : \"innerHTML\";\n\n                    if (arguments.length == 0) {\n                        return this.domElement[elemContentsProperty];\n                    } else {\n                        var valueToWrite = arguments[0];\n                        if (elemContentsProperty === \"innerHTML\")\n                            ko.utils.setHtml(this.domElement, valueToWrite);\n                        else\n                            this.domElement[elemContentsProperty] = valueToWrite;\n                    }\n                };\n\n                var dataDomDataPrefix = ko.utils.domData.nextKey() + \"_\";\n                ko.templateSources.domElement.prototype['data'] = function(key /*, valueToWrite */) {\n                    if (arguments.length === 1) {\n                        return ko.utils.domData.get(this.domElement, dataDomDataPrefix + key);\n                    } else {\n                        ko.utils.domData.set(this.domElement, dataDomDataPrefix + key, arguments[1]);\n                    }\n                };\n\n                var templatesDomDataKey = ko.utils.domData.nextKey();\n                function getTemplateDomData(element) {\n                    return ko.utils.domData.get(element, templatesDomDataKey) || {};\n                }\n                function setTemplateDomData(element, data) {\n                    ko.utils.domData.set(element, templatesDomDataKey, data);\n                }\n\n                ko.templateSources.domElement.prototype['nodes'] = function(/* valueToWrite */) {\n                    var element = this.domElement;\n                    if (arguments.length == 0) {\n                        var templateData = getTemplateDomData(element),\n                            nodes = templateData.containerData || (\n                                this.templateType === templateTemplate ? element.content :\n                                    this.templateType === templateElement ? element :\n                                        undefined);\n                        if (!nodes || templateData.alwaysCheckText) {\n                            // If the template is associated with an element that stores the template as text,\n                            // parse and cache the nodes whenever there's new text content available. This allows\n                            // the user to update the template content by updating the text of template node.\n                            var text = this['text']();\n                            if (text && text !== templateData.textData) {\n                                nodes = ko.utils.parseHtmlForTemplateNodes(text, element.ownerDocument);\n                                setTemplateDomData(element, {containerData: nodes, textData: text, alwaysCheckText: true});\n                            }\n                        }\n                        return nodes;\n                    } else {\n                        var valueToWrite = arguments[0];\n                        if (this.templateType !== undefined) {\n                            this['text'](\"\");   // clear the text from the node\n                        }\n                        setTemplateDomData(element, {containerData: valueToWrite});\n                    }\n                };\n\n                // ---- ko.templateSources.anonymousTemplate -----\n                // Anonymous templates are normally saved/retrieved as DOM nodes through \"nodes\".\n                // For compatibility, you can also read \"text\"; it will be serialized from the nodes on demand.\n                // Writing to \"text\" is still supported, but then the template data will not be available as DOM nodes.\n\n                ko.templateSources.anonymousTemplate = function(element) {\n                    this.domElement = element;\n                }\n                ko.templateSources.anonymousTemplate.prototype = new ko.templateSources.domElement();\n                ko.templateSources.anonymousTemplate.prototype.constructor = ko.templateSources.anonymousTemplate;\n                ko.templateSources.anonymousTemplate.prototype['text'] = function(/* valueToWrite */) {\n                    if (arguments.length == 0) {\n                        var templateData = getTemplateDomData(this.domElement);\n                        if (templateData.textData === undefined && templateData.containerData)\n                            templateData.textData = templateData.containerData.innerHTML;\n                        return templateData.textData;\n                    } else {\n                        var valueToWrite = arguments[0];\n                        setTemplateDomData(this.domElement, {textData: valueToWrite});\n                    }\n                };\n\n                ko.exportSymbol('templateSources', ko.templateSources);\n                ko.exportSymbol('templateSources.domElement', ko.templateSources.domElement);\n                ko.exportSymbol('templateSources.anonymousTemplate', ko.templateSources.anonymousTemplate);\n            })();\n            (function () {\n                var _templateEngine;\n                ko.setTemplateEngine = function (templateEngine) {\n                    if ((templateEngine != undefined) && !(templateEngine instanceof ko.templateEngine))\n                        throw new Error(\"templateEngine must inherit from ko.templateEngine\");\n                    _templateEngine = templateEngine;\n                }\n\n                function invokeForEachNodeInContinuousRange(firstNode, lastNode, action) {\n                    var node, nextInQueue = firstNode, firstOutOfRangeNode = ko.virtualElements.nextSibling(lastNode);\n                    while (nextInQueue && ((node = nextInQueue) !== firstOutOfRangeNode)) {\n                        nextInQueue = ko.virtualElements.nextSibling(node);\n                        action(node, nextInQueue);\n                    }\n                }\n\n                function activateBindingsOnContinuousNodeArray(continuousNodeArray, bindingContext) {\n                    // To be used on any nodes that have been rendered by a template and have been inserted into some parent element\n                    // Walks through continuousNodeArray (which *must* be continuous, i.e., an uninterrupted sequence of sibling nodes, because\n                    // the algorithm for walking them relies on this), and for each top-level item in the virtual-element sense,\n                    // (1) Does a regular \"applyBindings\" to associate bindingContext with this node and to activate any non-memoized bindings\n                    // (2) Unmemoizes any memos in the DOM subtree (e.g., to activate bindings that had been memoized during template rewriting)\n\n                    if (continuousNodeArray.length) {\n                        var firstNode = continuousNodeArray[0],\n                            lastNode = continuousNodeArray[continuousNodeArray.length - 1],\n                            parentNode = firstNode.parentNode,\n                            provider = ko.bindingProvider['instance'],\n                            preprocessNode = provider['preprocessNode'];\n\n                        if (preprocessNode) {\n                            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node, nextNodeInRange) {\n                                var nodePreviousSibling = node.previousSibling;\n                                var newNodes = preprocessNode.call(provider, node);\n                                if (newNodes) {\n                                    if (node === firstNode)\n                                        firstNode = newNodes[0] || nextNodeInRange;\n                                    if (node === lastNode)\n                                        lastNode = newNodes[newNodes.length - 1] || nodePreviousSibling;\n                                }\n                            });\n\n                            // Because preprocessNode can change the nodes, including the first and last nodes, update continuousNodeArray to match.\n                            // We need the full set, including inner nodes, because the unmemoize step might remove the first node (and so the real\n                            // first node needs to be in the array).\n                            continuousNodeArray.length = 0;\n                            if (!firstNode) { // preprocessNode might have removed all the nodes, in which case there's nothing left to do\n                                return;\n                            }\n                            if (firstNode === lastNode) {\n                                continuousNodeArray.push(firstNode);\n                            } else {\n                                continuousNodeArray.push(firstNode, lastNode);\n                                ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                            }\n                        }\n\n                        // Need to applyBindings *before* unmemoziation, because unmemoization might introduce extra nodes (that we don't want to re-bind)\n                        // whereas a regular applyBindings won't introduce new memoized nodes\n                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                            if (node.nodeType === 1 || node.nodeType === 8)\n                                ko.applyBindings(bindingContext, node);\n                        });\n                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                            if (node.nodeType === 1 || node.nodeType === 8)\n                                ko.memoization.unmemoizeDomNodeAndDescendants(node, [bindingContext]);\n                        });\n\n                        // Make sure any changes done by applyBindings or unmemoize are reflected in the array\n                        ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                    }\n                }\n\n                function getFirstNodeFromPossibleArray(nodeOrNodeArray) {\n                    return nodeOrNodeArray.nodeType ? nodeOrNodeArray\n                        : nodeOrNodeArray.length > 0 ? nodeOrNodeArray[0]\n                            : null;\n                }\n\n                function executeTemplate(targetNodeOrNodeArray, renderMode, template, bindingContext, options) {\n                    options = options || {};\n                    var firstTargetNode = targetNodeOrNodeArray && getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                    var templateDocument = (firstTargetNode || template || {}).ownerDocument;\n                    var templateEngineToUse = (options['templateEngine'] || _templateEngine);\n                    ko.templateRewriting.ensureTemplateIsRewritten(template, templateEngineToUse, templateDocument);\n                    var renderedNodesArray = templateEngineToUse['renderTemplate'](template, bindingContext, options, templateDocument);\n\n                    // Loosely check result is an array of DOM nodes\n                    if ((typeof renderedNodesArray.length != \"number\") || (renderedNodesArray.length > 0 && typeof renderedNodesArray[0].nodeType != \"number\"))\n                        throw new Error(\"Template engine must return an array of DOM nodes\");\n\n                    var haveAddedNodesToParent = false;\n                    switch (renderMode) {\n                        case \"replaceChildren\":\n                            ko.virtualElements.setDomNodeChildren(targetNodeOrNodeArray, renderedNodesArray);\n                            haveAddedNodesToParent = true;\n                            break;\n                        case \"replaceNode\":\n                            ko.utils.replaceDomNodes(targetNodeOrNodeArray, renderedNodesArray);\n                            haveAddedNodesToParent = true;\n                            break;\n                        case \"ignoreTargetNode\": break;\n                        default:\n                            throw new Error(\"Unknown renderMode: \" + renderMode);\n                    }\n\n                    if (haveAddedNodesToParent) {\n                        activateBindingsOnContinuousNodeArray(renderedNodesArray, bindingContext);\n                        if (options['afterRender']) {\n                            ko.dependencyDetection.ignore(options['afterRender'], null, [renderedNodesArray, bindingContext[options['as'] || '$data']]);\n                        }\n                        if (renderMode == \"replaceChildren\") {\n                            ko.bindingEvent.notify(targetNodeOrNodeArray, ko.bindingEvent.childrenComplete);\n                        }\n                    }\n\n                    return renderedNodesArray;\n                }\n\n                function resolveTemplateName(template, data, context) {\n                    // The template can be specified as:\n                    if (ko.isObservable(template)) {\n                        // 1. An observable, with string value\n                        return template();\n                    } else if (typeof template === 'function') {\n                        // 2. A function of (data, context) returning a string\n                        return template(data, context);\n                    } else {\n                        // 3. A string\n                        return template;\n                    }\n                }\n\n                ko.renderTemplate = function (template, dataOrBindingContext, options, targetNodeOrNodeArray, renderMode) {\n                    options = options || {};\n                    if ((options['templateEngine'] || _templateEngine) == undefined)\n                        throw new Error(\"Set a template engine before calling renderTemplate\");\n                    renderMode = renderMode || \"replaceChildren\";\n\n                    if (targetNodeOrNodeArray) {\n                        var firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n\n                        var whenToDispose = function () { return (!firstTargetNode) || !ko.utils.domNodeIsAttachedToDocument(firstTargetNode); }; // Passive disposal (on next evaluation)\n                        var activelyDisposeWhenNodeIsRemoved = (firstTargetNode && renderMode == \"replaceNode\") ? firstTargetNode.parentNode : firstTargetNode;\n\n                        return ko.dependentObservable( // So the DOM is automatically updated when any dependency changes\n                            function () {\n                                // Ensure we've got a proper binding context to work with\n                                var bindingContext = (dataOrBindingContext && (dataOrBindingContext instanceof ko.bindingContext))\n                                    ? dataOrBindingContext\n                                    : new ko.bindingContext(dataOrBindingContext, null, null, null, { \"exportDependencies\": true });\n\n                                var templateName = resolveTemplateName(template, bindingContext['$data'], bindingContext),\n                                    renderedNodesArray = executeTemplate(targetNodeOrNodeArray, renderMode, templateName, bindingContext, options);\n\n                                if (renderMode == \"replaceNode\") {\n                                    targetNodeOrNodeArray = renderedNodesArray;\n                                    firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                                }\n                            },\n                            null,\n                            { disposeWhen: whenToDispose, disposeWhenNodeIsRemoved: activelyDisposeWhenNodeIsRemoved }\n                        );\n                    } else {\n                        // We don't yet have a DOM node to evaluate, so use a memo and render the template later when there is a DOM node\n                        return ko.memoization.memoize(function (domNode) {\n                            ko.renderTemplate(template, dataOrBindingContext, options, domNode, \"replaceNode\");\n                        });\n                    }\n                };\n\n                ko.renderTemplateForEach = function (template, arrayOrObservableArray, options, targetNode, parentBindingContext) {\n                    // Since setDomNodeChildrenFromArrayMapping always calls executeTemplateForArrayItem and then\n                    // activateBindingsCallback for added items, we can store the binding context in the former to use in the latter.\n                    var arrayItemContext, asName = options['as'];\n\n                    // This will be called by setDomNodeChildrenFromArrayMapping to get the nodes to add to targetNode\n                    var executeTemplateForArrayItem = function (arrayValue, index) {\n                        // Support selecting template as a function of the data being rendered\n                        arrayItemContext = parentBindingContext['createChildContext'](arrayValue, {\n                            'as': asName,\n                            'noChildContext': options['noChildContext'],\n                            'extend': function(context) {\n                                context['$index'] = index;\n                                if (asName) {\n                                    context[asName + \"Index\"] = index;\n                                }\n                            }\n                        });\n\n                        var templateName = resolveTemplateName(template, arrayValue, arrayItemContext);\n                        return executeTemplate(targetNode, \"ignoreTargetNode\", templateName, arrayItemContext, options);\n                    };\n\n                    // This will be called whenever setDomNodeChildrenFromArrayMapping has added nodes to targetNode\n                    var activateBindingsCallback = function(arrayValue, addedNodesArray, index) {\n                        activateBindingsOnContinuousNodeArray(addedNodesArray, arrayItemContext);\n                        if (options['afterRender'])\n                            options['afterRender'](addedNodesArray, arrayValue);\n\n                        // release the \"cache\" variable, so that it can be collected by\n                        // the GC when its value isn't used from within the bindings anymore.\n                        arrayItemContext = null;\n                    };\n\n                    var setDomNodeChildrenFromArrayMapping = function (newArray, changeList) {\n                        // Call setDomNodeChildrenFromArrayMapping, ignoring any observables unwrapped within (most likely from a callback function).\n                        // If the array items are observables, though, they will be unwrapped in executeTemplateForArrayItem and managed within setDomNodeChildrenFromArrayMapping.\n                        ko.dependencyDetection.ignore(ko.utils.setDomNodeChildrenFromArrayMapping, null, [targetNode, newArray, executeTemplateForArrayItem, options, activateBindingsCallback, changeList]);\n                        ko.bindingEvent.notify(targetNode, ko.bindingEvent.childrenComplete);\n                    };\n\n                    var shouldHideDestroyed = (options['includeDestroyed'] === false) || (ko.options['foreachHidesDestroyed'] && !options['includeDestroyed']);\n\n                    if (!shouldHideDestroyed && !options['beforeRemove'] && ko.isObservableArray(arrayOrObservableArray)) {\n                        setDomNodeChildrenFromArrayMapping(arrayOrObservableArray.peek());\n\n                        var subscription = arrayOrObservableArray.subscribe(function (changeList) {\n                            setDomNodeChildrenFromArrayMapping(arrayOrObservableArray(), changeList);\n                        }, null, \"arrayChange\");\n                        subscription.disposeWhenNodeIsRemoved(targetNode);\n\n                        return subscription;\n                    } else {\n                        return ko.dependentObservable(function () {\n                            var unwrappedArray = ko.utils.unwrapObservable(arrayOrObservableArray) || [];\n                            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                                unwrappedArray = [unwrappedArray];\n\n                            if (shouldHideDestroyed) {\n                                // Filter out any entries marked as destroyed\n                                unwrappedArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                                    return item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n                                });\n                            }\n                            setDomNodeChildrenFromArrayMapping(unwrappedArray);\n\n                        }, null, { disposeWhenNodeIsRemoved: targetNode });\n                    }\n                };\n\n                var templateComputedDomDataKey = ko.utils.domData.nextKey();\n                function disposeOldComputedAndStoreNewOne(element, newComputed) {\n                    var oldComputed = ko.utils.domData.get(element, templateComputedDomDataKey);\n                    if (oldComputed && (typeof(oldComputed.dispose) == 'function'))\n                        oldComputed.dispose();\n                    ko.utils.domData.set(element, templateComputedDomDataKey, (newComputed && (!newComputed.isActive || newComputed.isActive())) ? newComputed : undefined);\n                }\n\n                var cleanContainerDomDataKey = ko.utils.domData.nextKey();\n                ko.bindingHandlers['template'] = {\n                    'init': function(element, valueAccessor) {\n                        // Support anonymous templates\n                        var bindingValue = ko.utils.unwrapObservable(valueAccessor());\n                        if (typeof bindingValue == \"string\" || 'name' in bindingValue) {\n                            // It's a named template - clear the element\n                            ko.virtualElements.emptyNode(element);\n                        } else if ('nodes' in bindingValue) {\n                            // We've been given an array of DOM nodes. Save them as the template source.\n                            // There is no known use case for the node array being an observable array (if the output\n                            // varies, put that behavior *into* your template - that's what templates are for), and\n                            // the implementation would be a mess, so assert that it's not observable.\n                            var nodes = bindingValue['nodes'] || [];\n                            if (ko.isObservable(nodes)) {\n                                throw new Error('The \"nodes\" option must be a plain, non-observable array.');\n                            }\n\n                            // If the nodes are already attached to a KO-generated container, we reuse that container without moving the\n                            // elements to a new one (we check only the first node, as the nodes are always moved together)\n                            var container = nodes[0] && nodes[0].parentNode;\n                            if (!container || !ko.utils.domData.get(container, cleanContainerDomDataKey)) {\n                                container = ko.utils.moveCleanedNodesToContainerElement(nodes);\n                                ko.utils.domData.set(container, cleanContainerDomDataKey, true);\n                            }\n\n                            new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n                        } else {\n                            // It's an anonymous template - store the element contents, then clear the element\n                            var templateNodes = ko.virtualElements.childNodes(element);\n                            if (templateNodes.length > 0) {\n                                var container = ko.utils.moveCleanedNodesToContainerElement(templateNodes); // This also removes the nodes from their current parent\n                                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n                            } else {\n                                throw new Error(\"Anonymous template defined, but no template content was provided\");\n                            }\n                        }\n                        return { 'controlsDescendantBindings': true };\n                    },\n                    'update': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                        var value = valueAccessor(),\n                            options = ko.utils.unwrapObservable(value),\n                            shouldDisplay = true,\n                            templateComputed = null,\n                            template;\n\n                        if (typeof options == \"string\") {\n                            template = value;\n                            options = {};\n                        } else {\n                            template = 'name' in options ? options['name'] : element;\n\n                            // Support \"if\"/\"ifnot\" conditions\n                            if ('if' in options)\n                                shouldDisplay = ko.utils.unwrapObservable(options['if']);\n                            if (shouldDisplay && 'ifnot' in options)\n                                shouldDisplay = !ko.utils.unwrapObservable(options['ifnot']);\n\n                            // Don't show anything if an empty name is given (see #2446)\n                            if (shouldDisplay && !template) {\n                                shouldDisplay = false;\n                            }\n                        }\n\n                        if ('foreach' in options) {\n                            // Render once for each data point (treating data set as empty if shouldDisplay==false)\n                            var dataArray = (shouldDisplay && options['foreach']) || [];\n                            templateComputed = ko.renderTemplateForEach(template, dataArray, options, element, bindingContext);\n                        } else if (!shouldDisplay) {\n                            ko.virtualElements.emptyNode(element);\n                        } else {\n                            // Render once for this single data point (or use the viewModel if no data was provided)\n                            var innerBindingContext = bindingContext;\n                            if ('data' in options) {\n                                innerBindingContext = bindingContext['createChildContext'](options['data'], {\n                                    'as': options['as'],\n                                    'noChildContext': options['noChildContext'],\n                                    'exportDependencies': true\n                                });\n                            }\n                            templateComputed = ko.renderTemplate(template, innerBindingContext, options, element);\n                        }\n\n                        // It only makes sense to have a single template computed per element (otherwise which one should have its output displayed?)\n                        disposeOldComputedAndStoreNewOne(element, templateComputed);\n                    }\n                };\n\n                // Anonymous templates can't be rewritten. Give a nice error message if you try to do it.\n                ko.expressionRewriting.bindingRewriteValidators['template'] = function(bindingValue) {\n                    var parsedBindingValue = ko.expressionRewriting.parseObjectLiteral(bindingValue);\n\n                    if ((parsedBindingValue.length == 1) && parsedBindingValue[0]['unknown'])\n                        return null; // It looks like a string literal, not an object literal, so treat it as a named template (which is allowed for rewriting)\n\n                    if (ko.expressionRewriting.keyValueArrayContainsKey(parsedBindingValue, \"name\"))\n                        return null; // Named templates can be rewritten, so return \"no error\"\n                    return \"This template engine does not support anonymous templates nested within its templates\";\n                };\n\n                ko.virtualElements.allowedBindings['template'] = true;\n            })();\n\n            ko.exportSymbol('setTemplateEngine', ko.setTemplateEngine);\n            ko.exportSymbol('renderTemplate', ko.renderTemplate);\n// Go through the items that have been added and deleted and try to find matches between them.\n            ko.utils.findMovesInArrayComparison = function (left, right, limitFailedCompares) {\n                if (left.length && right.length) {\n                    var failedCompares, l, r, leftItem, rightItem;\n                    for (failedCompares = l = 0; (!limitFailedCompares || failedCompares < limitFailedCompares) && (leftItem = left[l]); ++l) {\n                        for (r = 0; rightItem = right[r]; ++r) {\n                            if (leftItem['value'] === rightItem['value']) {\n                                leftItem['moved'] = rightItem['index'];\n                                rightItem['moved'] = leftItem['index'];\n                                right.splice(r, 1);         // This item is marked as moved; so remove it from right list\n                                failedCompares = r = 0;     // Reset failed compares count because we're checking for consecutive failures\n                                break;\n                            }\n                        }\n                        failedCompares += r;\n                    }\n                }\n            };\n\n            ko.utils.compareArrays = (function () {\n                var statusNotInOld = 'added', statusNotInNew = 'deleted';\n\n                // Simple calculation based on Levenshtein distance.\n                function compareArrays(oldArray, newArray, options) {\n                    // For backward compatibility, if the third arg is actually a bool, interpret\n                    // it as the old parameter 'dontLimitMoves'. Newer code should use { dontLimitMoves: true }.\n                    options = (typeof options === 'boolean') ? { 'dontLimitMoves': options } : (options || {});\n                    oldArray = oldArray || [];\n                    newArray = newArray || [];\n\n                    if (oldArray.length < newArray.length)\n                        return compareSmallArrayToBigArray(oldArray, newArray, statusNotInOld, statusNotInNew, options);\n                    else\n                        return compareSmallArrayToBigArray(newArray, oldArray, statusNotInNew, statusNotInOld, options);\n                }\n\n                function compareSmallArrayToBigArray(smlArray, bigArray, statusNotInSml, statusNotInBig, options) {\n                    var myMin = Math.min,\n                        myMax = Math.max,\n                        editDistanceMatrix = [],\n                        smlIndex, smlIndexMax = smlArray.length,\n                        bigIndex, bigIndexMax = bigArray.length,\n                        compareRange = (bigIndexMax - smlIndexMax) || 1,\n                        maxDistance = smlIndexMax + bigIndexMax + 1,\n                        thisRow, lastRow,\n                        bigIndexMaxForRow, bigIndexMinForRow;\n\n                    for (smlIndex = 0; smlIndex <= smlIndexMax; smlIndex++) {\n                        lastRow = thisRow;\n                        editDistanceMatrix.push(thisRow = []);\n                        bigIndexMaxForRow = myMin(bigIndexMax, smlIndex + compareRange);\n                        bigIndexMinForRow = myMax(0, smlIndex - 1);\n                        for (bigIndex = bigIndexMinForRow; bigIndex <= bigIndexMaxForRow; bigIndex++) {\n                            if (!bigIndex)\n                                thisRow[bigIndex] = smlIndex + 1;\n                            else if (!smlIndex)  // Top row - transform empty array into new array via additions\n                                thisRow[bigIndex] = bigIndex + 1;\n                            else if (smlArray[smlIndex - 1] === bigArray[bigIndex - 1])\n                                thisRow[bigIndex] = lastRow[bigIndex - 1];                  // copy value (no edit)\n                            else {\n                                var northDistance = lastRow[bigIndex] || maxDistance;       // not in big (deletion)\n                                var westDistance = thisRow[bigIndex - 1] || maxDistance;    // not in small (addition)\n                                thisRow[bigIndex] = myMin(northDistance, westDistance) + 1;\n                            }\n                        }\n                    }\n\n                    var editScript = [], meMinusOne, notInSml = [], notInBig = [];\n                    for (smlIndex = smlIndexMax, bigIndex = bigIndexMax; smlIndex || bigIndex;) {\n                        meMinusOne = editDistanceMatrix[smlIndex][bigIndex] - 1;\n                        if (bigIndex && meMinusOne === editDistanceMatrix[smlIndex][bigIndex-1]) {\n                            notInSml.push(editScript[editScript.length] = {     // added\n                                'status': statusNotInSml,\n                                'value': bigArray[--bigIndex],\n                                'index': bigIndex });\n                        } else if (smlIndex && meMinusOne === editDistanceMatrix[smlIndex - 1][bigIndex]) {\n                            notInBig.push(editScript[editScript.length] = {     // deleted\n                                'status': statusNotInBig,\n                                'value': smlArray[--smlIndex],\n                                'index': smlIndex });\n                        } else {\n                            --bigIndex;\n                            --smlIndex;\n                            if (!options['sparse']) {\n                                editScript.push({\n                                    'status': \"retained\",\n                                    'value': bigArray[bigIndex] });\n                            }\n                        }\n                    }\n\n                    // Set a limit on the number of consecutive non-matching comparisons; having it a multiple of\n                    // smlIndexMax keeps the time complexity of this algorithm linear.\n                    ko.utils.findMovesInArrayComparison(notInBig, notInSml, !options['dontLimitMoves'] && smlIndexMax * 10);\n\n                    return editScript.reverse();\n                }\n\n                return compareArrays;\n            })();\n\n            ko.exportSymbol('utils.compareArrays', ko.utils.compareArrays);\n            (function () {\n                // Objective:\n                // * Given an input array, a container DOM node, and a function from array elements to arrays of DOM nodes,\n                //   map the array elements to arrays of DOM nodes, concatenate together all these arrays, and use them to populate the container DOM node\n                // * Next time we're given the same combination of things (with the array possibly having mutated), update the container DOM node\n                //   so that its children is again the concatenation of the mappings of the array elements, but don't re-map any array elements that we\n                //   previously mapped - retain those nodes, and just insert/delete other ones\n\n                // \"callbackAfterAddingNodes\" will be invoked after any \"mapping\"-generated nodes are inserted into the container node\n                // You can use this, for example, to activate bindings on those nodes.\n\n                function mapNodeAndRefreshWhenChanged(containerNode, mapping, valueToMap, callbackAfterAddingNodes, index) {\n                    // Map this array value inside a dependentObservable so we re-map when any dependency changes\n                    var mappedNodes = [];\n                    var dependentObservable = ko.dependentObservable(function() {\n                        var newMappedNodes = mapping(valueToMap, index, ko.utils.fixUpContinuousNodeArray(mappedNodes, containerNode)) || [];\n\n                        // On subsequent evaluations, just replace the previously-inserted DOM nodes\n                        if (mappedNodes.length > 0) {\n                            ko.utils.replaceDomNodes(mappedNodes, newMappedNodes);\n                            if (callbackAfterAddingNodes)\n                                ko.dependencyDetection.ignore(callbackAfterAddingNodes, null, [valueToMap, newMappedNodes, index]);\n                        }\n\n                        // Replace the contents of the mappedNodes array, thereby updating the record\n                        // of which nodes would be deleted if valueToMap was itself later removed\n                        mappedNodes.length = 0;\n                        ko.utils.arrayPushAll(mappedNodes, newMappedNodes);\n                    }, null, { disposeWhenNodeIsRemoved: containerNode, disposeWhen: function() { return !ko.utils.anyDomNodeIsAttachedToDocument(mappedNodes); } });\n                    return { mappedNodes : mappedNodes, dependentObservable : (dependentObservable.isActive() ? dependentObservable : undefined) };\n                }\n\n                var lastMappingResultDomDataKey = ko.utils.domData.nextKey(),\n                    deletedItemDummyValue = ko.utils.domData.nextKey();\n\n                ko.utils.setDomNodeChildrenFromArrayMapping = function (domNode, array, mapping, options, callbackAfterAddingNodes, editScript) {\n                    array = array || [];\n                    if (typeof array.length == \"undefined\") // Coerce single value into array\n                        array = [array];\n\n                    options = options || {};\n                    var lastMappingResult = ko.utils.domData.get(domNode, lastMappingResultDomDataKey);\n                    var isFirstExecution = !lastMappingResult;\n\n                    // Build the new mapping result\n                    var newMappingResult = [];\n                    var lastMappingResultIndex = 0;\n                    var currentArrayIndex = 0;\n\n                    var nodesToDelete = [];\n                    var itemsToMoveFirstIndexes = [];\n                    var itemsForBeforeRemoveCallbacks = [];\n                    var itemsForMoveCallbacks = [];\n                    var itemsForAfterAddCallbacks = [];\n                    var mapData;\n                    var countWaitingForRemove = 0;\n\n                    function itemAdded(value) {\n                        mapData = { arrayEntry: value, indexObservable: ko.observable(currentArrayIndex++) };\n                        newMappingResult.push(mapData);\n                        if (!isFirstExecution) {\n                            itemsForAfterAddCallbacks.push(mapData);\n                        }\n                    }\n\n                    function itemMovedOrRetained(oldPosition) {\n                        mapData = lastMappingResult[oldPosition];\n                        if (currentArrayIndex !== mapData.indexObservable.peek())\n                            itemsForMoveCallbacks.push(mapData);\n                        // Since updating the index might change the nodes, do so before calling fixUpContinuousNodeArray\n                        mapData.indexObservable(currentArrayIndex++);\n                        ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode);\n                        newMappingResult.push(mapData);\n                    }\n\n                    function callCallback(callback, items) {\n                        if (callback) {\n                            for (var i = 0, n = items.length; i < n; i++) {\n                                ko.utils.arrayForEach(items[i].mappedNodes, function(node) {\n                                    callback(node, i, items[i].arrayEntry);\n                                });\n                            }\n                        }\n                    }\n\n                    if (isFirstExecution) {\n                        ko.utils.arrayForEach(array, itemAdded);\n                    } else {\n                        if (!editScript || (lastMappingResult && lastMappingResult['_countWaitingForRemove'])) {\n                            // Compare the provided array against the previous one\n                            var lastArray = ko.utils.arrayMap(lastMappingResult, function (x) { return x.arrayEntry; }),\n                                compareOptions = {\n                                    'dontLimitMoves': options['dontLimitMoves'],\n                                    'sparse': true\n                                };\n                            editScript = ko.utils.compareArrays(lastArray, array, compareOptions);\n                        }\n\n                        for (var i = 0, editScriptItem, movedIndex, itemIndex; editScriptItem = editScript[i]; i++) {\n                            movedIndex = editScriptItem['moved'];\n                            itemIndex = editScriptItem['index'];\n                            switch (editScriptItem['status']) {\n                                case \"deleted\":\n                                    while (lastMappingResultIndex < itemIndex) {\n                                        itemMovedOrRetained(lastMappingResultIndex++);\n                                    }\n                                    if (movedIndex === undefined) {\n                                        mapData = lastMappingResult[lastMappingResultIndex];\n\n                                        // Stop tracking changes to the mapping for these nodes\n                                        if (mapData.dependentObservable) {\n                                            mapData.dependentObservable.dispose();\n                                            mapData.dependentObservable = undefined;\n                                        }\n\n                                        // Queue these nodes for later removal\n                                        if (ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode).length) {\n                                            if (options['beforeRemove']) {\n                                                newMappingResult.push(mapData);\n                                                countWaitingForRemove++;\n                                                if (mapData.arrayEntry === deletedItemDummyValue) {\n                                                    mapData = null;\n                                                } else {\n                                                    itemsForBeforeRemoveCallbacks.push(mapData);\n                                                }\n                                            }\n                                            if (mapData) {\n                                                nodesToDelete.push.apply(nodesToDelete, mapData.mappedNodes);\n                                            }\n                                        }\n                                    }\n                                    lastMappingResultIndex++;\n                                    break;\n\n                                case \"added\":\n                                    while (currentArrayIndex < itemIndex) {\n                                        itemMovedOrRetained(lastMappingResultIndex++);\n                                    }\n                                    if (movedIndex !== undefined) {\n                                        itemsToMoveFirstIndexes.push(newMappingResult.length);\n                                        itemMovedOrRetained(movedIndex);\n                                    } else {\n                                        itemAdded(editScriptItem['value']);\n                                    }\n                                    break;\n                            }\n                        }\n\n                        while (currentArrayIndex < array.length) {\n                            itemMovedOrRetained(lastMappingResultIndex++);\n                        }\n\n                        // Record that the current view may still contain deleted items\n                        // because it means we won't be able to use a provided editScript.\n                        newMappingResult['_countWaitingForRemove'] = countWaitingForRemove;\n                    }\n\n                    // Store a copy of the array items we just considered so we can difference it next time\n                    ko.utils.domData.set(domNode, lastMappingResultDomDataKey, newMappingResult);\n\n                    // Call beforeMove first before any changes have been made to the DOM\n                    callCallback(options['beforeMove'], itemsForMoveCallbacks);\n\n                    // Next remove nodes for deleted items (or just clean if there's a beforeRemove callback)\n                    ko.utils.arrayForEach(nodesToDelete, options['beforeRemove'] ? ko.cleanNode : ko.removeNode);\n\n                    var i, j, lastNode, nodeToInsert, mappedNodes, activeElement;\n\n                    // Since most browsers remove the focus from an element when it's moved to another location,\n                    // save the focused element and try to restore it later.\n                    try {\n                        activeElement = domNode.ownerDocument.activeElement;\n                    } catch(e) {\n                        // IE9 throws if you access activeElement during page load (see issue #703)\n                    }\n\n                    // Try to reduce overall moved nodes by first moving the ones that were marked as moved by the edit script\n                    if (itemsToMoveFirstIndexes.length) {\n                        while ((i = itemsToMoveFirstIndexes.shift()) != undefined) {\n                            mapData = newMappingResult[i];\n                            for (lastNode = undefined; i; ) {\n                                if ((mappedNodes = newMappingResult[--i].mappedNodes) && mappedNodes.length) {\n                                    lastNode = mappedNodes[mappedNodes.length-1];\n                                    break;\n                                }\n                            }\n                            for (j = 0; nodeToInsert = mapData.mappedNodes[j]; lastNode = nodeToInsert, j++) {\n                                ko.virtualElements.insertAfter(domNode, nodeToInsert, lastNode);\n                            }\n                        }\n                    }\n\n                    // Next add/reorder the remaining items (will include deleted items if there's a beforeRemove callback)\n                    for (i = 0; mapData = newMappingResult[i]; i++) {\n                        // Get nodes for newly added items\n                        if (!mapData.mappedNodes)\n                            ko.utils.extend(mapData, mapNodeAndRefreshWhenChanged(domNode, mapping, mapData.arrayEntry, callbackAfterAddingNodes, mapData.indexObservable));\n\n                        // Put nodes in the right place if they aren't there already\n                        for (j = 0; nodeToInsert = mapData.mappedNodes[j]; lastNode = nodeToInsert, j++) {\n                            ko.virtualElements.insertAfter(domNode, nodeToInsert, lastNode);\n                        }\n\n                        // Run the callbacks for newly added nodes (for example, to apply bindings, etc.)\n                        if (!mapData.initialized && callbackAfterAddingNodes) {\n                            callbackAfterAddingNodes(mapData.arrayEntry, mapData.mappedNodes, mapData.indexObservable);\n                            mapData.initialized = true;\n                            lastNode = mapData.mappedNodes[mapData.mappedNodes.length - 1];     // get the last node again since it may have been changed by a preprocessor\n                        }\n                    }\n\n                    // Restore the focused element if it had lost focus\n                    if (activeElement && domNode.ownerDocument.activeElement != activeElement) {\n                        activeElement.focus();\n                    }\n\n                    // If there's a beforeRemove callback, call it after reordering.\n                    // Note that we assume that the beforeRemove callback will usually be used to remove the nodes using\n                    // some sort of animation, which is why we first reorder the nodes that will be removed. If the\n                    // callback instead removes the nodes right away, it would be more efficient to skip reordering them.\n                    // Perhaps we'll make that change in the future if this scenario becomes more common.\n                    callCallback(options['beforeRemove'], itemsForBeforeRemoveCallbacks);\n\n                    // Replace the stored values of deleted items with a dummy value. This provides two benefits: it marks this item\n                    // as already \"removed\" so we won't call beforeRemove for it again, and it ensures that the item won't match up\n                    // with an actual item in the array and appear as \"retained\" or \"moved\".\n                    for (i = 0; i < itemsForBeforeRemoveCallbacks.length; ++i) {\n                        itemsForBeforeRemoveCallbacks[i].arrayEntry = deletedItemDummyValue;\n                    }\n\n                    // Finally call afterMove and afterAdd callbacks\n                    callCallback(options['afterMove'], itemsForMoveCallbacks);\n                    callCallback(options['afterAdd'], itemsForAfterAddCallbacks);\n                }\n            })();\n\n            ko.exportSymbol('utils.setDomNodeChildrenFromArrayMapping', ko.utils.setDomNodeChildrenFromArrayMapping);\n            ko.nativeTemplateEngine = function () {\n                this['allowTemplateRewriting'] = false;\n            }\n\n            ko.nativeTemplateEngine.prototype = new ko.templateEngine();\n            ko.nativeTemplateEngine.prototype.constructor = ko.nativeTemplateEngine;\n            ko.nativeTemplateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n                var useNodesIfAvailable = !(ko.utils.ieVersion < 9), // IE<9 cloneNode doesn't work properly\n                    templateNodesFunc = useNodesIfAvailable ? templateSource['nodes'] : null,\n                    templateNodes = templateNodesFunc ? templateSource['nodes']() : null;\n\n                if (templateNodes) {\n                    return ko.utils.makeArray(templateNodes.cloneNode(true).childNodes);\n                } else {\n                    var templateText = templateSource['text']();\n                    return ko.utils.parseHtmlFragment(templateText, templateDocument);\n                }\n            };\n\n            ko.nativeTemplateEngine.instance = new ko.nativeTemplateEngine();\n            ko.setTemplateEngine(ko.nativeTemplateEngine.instance);\n\n            ko.exportSymbol('nativeTemplateEngine', ko.nativeTemplateEngine);\n            (function() {\n                ko.jqueryTmplTemplateEngine = function () {\n                    // Detect which version of jquery-tmpl you're using. Unfortunately jquery-tmpl\n                    // doesn't expose a version number, so we have to infer it.\n                    // Note that as of Knockout 1.3, we only support jQuery.tmpl 1.0.0pre and later,\n                    // which KO internally refers to as version \"2\", so older versions are no longer detected.\n                    var jQueryTmplVersion = this.jQueryTmplVersion = (function() {\n                        if (!jQueryInstance || !(jQueryInstance['tmpl']))\n                            return 0;\n                        // Since it exposes no official version number, we use our own numbering system. To be updated as jquery-tmpl evolves.\n                        try {\n                            if (jQueryInstance['tmpl']['tag']['tmpl']['open'].toString().indexOf('__') >= 0) {\n                                // Since 1.0.0pre, custom tags should append markup to an array called \"__\"\n                                return 2; // Final version of jquery.tmpl\n                            }\n                        } catch(ex) { /* Apparently not the version we were looking for */ }\n\n                        return 1; // Any older version that we don't support\n                    })();\n\n                    function ensureHasReferencedJQueryTemplates() {\n                        if (jQueryTmplVersion < 2)\n                            throw new Error(\"Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.\");\n                    }\n\n                    function executeTemplate(compiledTemplate, data, jQueryTemplateOptions) {\n                        return jQueryInstance['tmpl'](compiledTemplate, data, jQueryTemplateOptions);\n                    }\n\n                    this['renderTemplateSource'] = function(templateSource, bindingContext, options, templateDocument) {\n                        templateDocument = templateDocument || document;\n                        options = options || {};\n                        ensureHasReferencedJQueryTemplates();\n\n                        // Ensure we have stored a precompiled version of this template (don't want to reparse on every render)\n                        var precompiled = templateSource['data']('precompiled');\n                        if (!precompiled) {\n                            var templateText = templateSource['text']() || \"\";\n                            // Wrap in \"with($whatever.koBindingContext) { ... }\"\n                            templateText = \"{{ko_with $item.koBindingContext}}\" + templateText + \"{{/ko_with}}\";\n\n                            precompiled = jQueryInstance['template'](null, templateText);\n                            templateSource['data']('precompiled', precompiled);\n                        }\n\n                        var data = [bindingContext['$data']]; // Prewrap the data in an array to stop jquery.tmpl from trying to unwrap any arrays\n                        var jQueryTemplateOptions = jQueryInstance['extend']({ 'koBindingContext': bindingContext }, options['templateOptions']);\n\n                        var resultNodes = executeTemplate(precompiled, data, jQueryTemplateOptions);\n                        resultNodes['appendTo'](templateDocument.createElement(\"div\")); // Using \"appendTo\" forces jQuery/jQuery.tmpl to perform necessary cleanup work\n\n                        jQueryInstance['fragments'] = {}; // Clear jQuery's fragment cache to avoid a memory leak after a large number of template renders\n                        return resultNodes;\n                    };\n\n                    this['createJavaScriptEvaluatorBlock'] = function(script) {\n                        return \"{{ko_code ((function() { return \" + script + \" })()) }}\";\n                    };\n\n                    this['addTemplate'] = function(templateName, templateMarkup) {\n                        document.write(\"<script type='text/html' id='\" + templateName + \"'>\" + templateMarkup + \"<\" + \"/script>\");\n                    };\n\n                    if (jQueryTmplVersion > 0) {\n                        jQueryInstance['tmpl']['tag']['ko_code'] = {\n                            open: \"__.push($1 || '');\"\n                        };\n                        jQueryInstance['tmpl']['tag']['ko_with'] = {\n                            open: \"with($1) {\",\n                            close: \"} \"\n                        };\n                    }\n                };\n\n                ko.jqueryTmplTemplateEngine.prototype = new ko.templateEngine();\n                ko.jqueryTmplTemplateEngine.prototype.constructor = ko.jqueryTmplTemplateEngine;\n\n                // Use this one by default *only if jquery.tmpl is referenced*\n                var jqueryTmplTemplateEngineInstance = new ko.jqueryTmplTemplateEngine();\n                if (jqueryTmplTemplateEngineInstance.jQueryTmplVersion > 0)\n                    ko.setTemplateEngine(jqueryTmplTemplateEngineInstance);\n\n                ko.exportSymbol('jqueryTmplTemplateEngine', ko.jqueryTmplTemplateEngine);\n            })();\n        }));\n    }());\n})();\n","Amasty_Reports/vendor/amcharts4/animated.min.js":"/**\n * @license\n * Copyright (c) 2018 amCharts (Antanas Marcelionis, Martynas Majeris)\n *\n * This sofware is provided under multiple licenses. Please see below for\n * links to appropriate usage.\n *\n * Free amCharts linkware license. Details and conditions:\n * https://github.com/amcharts/amcharts4/blob/master/LICENSE\n *\n * One of the amCharts commercial licenses. Details and pricing:\n * https://www.amcharts.com/online-store/\n * https://www.amcharts.com/online-store/licenses-explained/\n *\n * If in doubt, contact amCharts at contact@amcharts.com\n *\n * PLEASE DO NOT REMOVE THIS COPYRIGHT NOTICE.\n * @hidden\n */\nam4internal_webpackJsonp([\"ab45\"],{lhmh:function(t,e,a){\"use strict\";Object.defineProperty(e,\"__esModule\",{value:!0});var i=a(\"01H4\"),n=function(t){Object(i.a)(t,\"SpriteState\")&&(t.transitionDuration=400),Object(i.a)(t,\"Component\")&&(t.rangeChangeDuration=700,t.interpolationDuration=700,t.sequencedInterpolation=!1,Object(i.a)(t,\"SankeyDiagram\")&&(t.sequencedInterpolation=!0),Object(i.a)(t,\"FunnelSeries\")&&(t.sequencedInterpolation=!0)),Object(i.a)(t,\"Chart\")&&(t.defaultState.transitionDuration=2e3,t.hiddenState.transitionDuration=1e3),Object(i.a)(t,\"Tooltip\")&&(t.animationDuration=400,t.defaultState.transitionDuration=400,t.hiddenState.transitionDuration=400),Object(i.a)(t,\"Scrollbar\")&&(t.animationDuration=700),Object(i.a)(t,\"Series\")&&(t.defaultState.transitionDuration=1e3,t.hiddenState.transitionDuration=700,t.hiddenState.properties.opacity=1,t.showOnInit=!0),Object(i.a)(t,\"MapSeries\")&&(t.hiddenState.properties.opacity=0),Object(i.a)(t,\"PercentSeries\")&&(t.hiddenState.properties.opacity=0),Object(i.a)(t,\"FunnelSlice\")&&(t.defaultState.transitionDuration=800,t.hiddenState.transitionDuration=1e3,t.hiddenState.properties.opacity=1),Object(i.a)(t,\"Slice\")&&(t.defaultState.transitionDuration=700,t.hiddenState.transitionDuration=1e3,t.hiddenState.properties.opacity=1),Object(i.a)(t,\"Preloader\")&&(t.hiddenState.transitionDuration=2e3),Object(i.a)(t,\"Column\")&&(t.defaultState.transitionDuration=700,t.hiddenState.transitionDuration=1e3,t.hiddenState.properties.opacity=1),Object(i.a)(t,\"Column3D\")&&(t.hiddenState.properties.opacity=0)};window.am4themes_animated=n}},[\"lhmh\"]);\n//# sourceMappingURL=animated.js.map","Amasty_Reports/vendor/amcharts4/charts.min.js":"/**\n * @license\n * Copyright (c) 2018 amCharts (Antanas Marcelionis, Martynas Majeris)\n *\n * This sofware is provided under multiple licenses. Please see below for\n * links to appropriate usage.\n *\n * Free amCharts linkware license. Details and conditions:\n * https://github.com/amcharts/amcharts4/blob/master/LICENSE\n *\n * One of the amCharts commercial licenses. Details and pricing:\n * https://www.amcharts.com/online-store/\n * https://www.amcharts.com/online-store/licenses-explained/\n *\n * If in doubt, contact amCharts at contact@amcharts.com\n *\n * PLEASE DO NOT REMOVE THIS COPYRIGHT NOTICE.\n * @hidden\n */\nam4internal_webpackJsonp([\"689e\"],{XFs4:function(t,e,i){\"use strict\";Object.defineProperty(e,\"__esModule\",{value:!0});var a={};i.d(a,\"GaugeChartDataItem\",function(){return Pt}),i.d(a,\"GaugeChart\",function(){return At}),i.d(a,\"RadarChartDataItem\",function(){return ft}),i.d(a,\"RadarChart\",function(){return xt}),i.d(a,\"XYChartDataItem\",function(){return G}),i.d(a,\"XYChart\",function(){return q}),i.d(a,\"SerialChartDataItem\",function(){return r.b}),i.d(a,\"SerialChart\",function(){return r.a}),i.d(a,\"PieChart3DDataItem\",function(){return Vt}),i.d(a,\"PieChart3D\",function(){return St}),i.d(a,\"PieChartDataItem\",function(){return Ct.b}),i.d(a,\"PieChart\",function(){return Ct.a}),i.d(a,\"SlicedChart\",function(){return Ot}),i.d(a,\"SlicedChartDataItem\",function(){return kt}),i.d(a,\"FlowDiagramDataItem\",function(){return zt}),i.d(a,\"FlowDiagram\",function(){return Ut}),i.d(a,\"SankeyDiagramDataItem\",function(){return Qt}),i.d(a,\"SankeyDiagram\",function(){return $t}),i.d(a,\"ChordDiagramDataItem\",function(){return ne}),i.d(a,\"ChordDiagram\",function(){return re}),i.d(a,\"TreeMapDataItem\",function(){return ce}),i.d(a,\"TreeMap\",function(){return de}),i.d(a,\"XYChart3DDataItem\",function(){return ve}),i.d(a,\"XYChart3D\",function(){return be}),i.d(a,\"ChartDataItem\",function(){return wt.b}),i.d(a,\"Chart\",function(){return wt.a}),i.d(a,\"LegendDataItem\",function(){return jt.b}),i.d(a,\"Legend\",function(){return jt.a}),i.d(a,\"LegendSettings\",function(){return jt.c}),i.d(a,\"HeatLegend\",function(){return Pe.a}),i.d(a,\"SeriesDataItem\",function(){return V.b}),i.d(a,\"Series\",function(){return V.a}),i.d(a,\"XYSeriesDataItem\",function(){return R}),i.d(a,\"XYSeries\",function(){return L}),i.d(a,\"LineSeriesDataItem\",function(){return it}),i.d(a,\"LineSeries\",function(){return at}),i.d(a,\"LineSeriesSegment\",function(){return J}),i.d(a,\"CandlestickSeriesDataItem\",function(){return Ce}),i.d(a,\"CandlestickSeries\",function(){return Ie}),i.d(a,\"OHLCSeriesDataItem\",function(){return _e}),i.d(a,\"OHLCSeries\",function(){return Te}),i.d(a,\"ColumnSeriesDataItem\",function(){return oe}),i.d(a,\"ColumnSeries\",function(){return le}),i.d(a,\"StepLineSeriesDataItem\",function(){return Se}),i.d(a,\"StepLineSeries\",function(){return Fe}),i.d(a,\"RadarSeriesDataItem\",function(){return nt}),i.d(a,\"RadarSeries\",function(){return rt}),i.d(a,\"RadarColumnSeriesDataItem\",function(){return Oe}),i.d(a,\"RadarColumnSeries\",function(){return we}),i.d(a,\"PieSeriesDataItem\",function(){return It.b}),i.d(a,\"PieSeries\",function(){return It.a}),i.d(a,\"FunnelSeries\",function(){return Ne}),i.d(a,\"FunnelSeriesDataItem\",function(){return je}),i.d(a,\"PyramidSeries\",function(){return We}),i.d(a,\"PyramidSeriesDataItem\",function(){return Me}),i.d(a,\"PictorialStackedSeries\",function(){return Ee}),i.d(a,\"PictorialStackedSeriesDataItem\",function(){return Be}),i.d(a,\"PieTick\",function(){return He.a}),i.d(a,\"FunnelSlice\",function(){return Le}),i.d(a,\"PieSeries3DDataItem\",function(){return _t}),i.d(a,\"PieSeries3D\",function(){return Tt}),i.d(a,\"TreeMapSeriesDataItem\",function(){return he}),i.d(a,\"TreeMapSeries\",function(){return ue}),i.d(a,\"ColumnSeries3DDataItem\",function(){return fe}),i.d(a,\"ColumnSeries3D\",function(){return xe}),i.d(a,\"ConeSeriesDataItem\",function(){return Ke}),i.d(a,\"ConeSeries\",function(){return Ge}),i.d(a,\"CurvedColumnSeries\",function(){return Je}),i.d(a,\"CurvedColumnSeriesDataItem\",function(){return Ze}),i.d(a,\"AxisDataItem\",function(){return A.b}),i.d(a,\"Axis\",function(){return A.a}),i.d(a,\"Grid\",function(){return ct.a}),i.d(a,\"AxisTick\",function(){return Qe.a}),i.d(a,\"AxisLabel\",function(){return $e.a}),i.d(a,\"AxisLine\",function(){return ti.a}),i.d(a,\"AxisFill\",function(){return ht.a}),i.d(a,\"AxisRenderer\",function(){return lt.a}),i.d(a,\"AxisBreak\",function(){return C.a}),i.d(a,\"ValueAxisDataItem\",function(){return l.b}),i.d(a,\"ValueAxis\",function(){return l.a}),i.d(a,\"CategoryAxisDataItem\",function(){return _}),i.d(a,\"CategoryAxis\",function(){return T}),i.d(a,\"CategoryAxisBreak\",function(){return I}),i.d(a,\"DateAxisDataItem\",function(){return x}),i.d(a,\"DateAxis\",function(){return v}),i.d(a,\"DurationAxisDataItem\",function(){return ei}),i.d(a,\"DurationAxis\",function(){return ii}),i.d(a,\"DateAxisBreak\",function(){return d}),i.d(a,\"ValueAxisBreak\",function(){return u.a}),i.d(a,\"AxisRendererX\",function(){return b.a}),i.d(a,\"AxisRendererY\",function(){return P.a}),i.d(a,\"AxisRendererRadial\",function(){return mt}),i.d(a,\"AxisLabelCircular\",function(){return pt.a}),i.d(a,\"AxisRendererCircular\",function(){return yt}),i.d(a,\"AxisFillCircular\",function(){return ut}),i.d(a,\"GridCircular\",function(){return dt}),i.d(a,\"AxisRendererX3D\",function(){return pe}),i.d(a,\"AxisRendererY3D\",function(){return ye}),i.d(a,\"Tick\",function(){return Xe.a}),i.d(a,\"Bullet\",function(){return et.a}),i.d(a,\"LabelBullet\",function(){return Kt}),i.d(a,\"CircleBullet\",function(){return ai}),i.d(a,\"ErrorBullet\",function(){return ni}),i.d(a,\"XYChartScrollbar\",function(){return U}),i.d(a,\"ClockHand\",function(){return bt}),i.d(a,\"FlowDiagramNode\",function(){return Nt}),i.d(a,\"FlowDiagramLink\",function(){return Bt}),i.d(a,\"SankeyNode\",function(){return Gt}),i.d(a,\"SankeyLink\",function(){return Zt}),i.d(a,\"ChordNode\",function(){return ee}),i.d(a,\"ChordLink\",function(){return ae}),i.d(a,\"NavigationBarDataItem\",function(){return hi}),i.d(a,\"NavigationBar\",function(){return ui}),i.d(a,\"Column\",function(){return se}),i.d(a,\"Candlestick\",function(){return Ae}),i.d(a,\"OHLC\",function(){return De}),i.d(a,\"RadarColumn\",function(){return ke}),i.d(a,\"Column3D\",function(){return me}),i.d(a,\"ConeColumn\",function(){return Ue}),i.d(a,\"CurvedColumn\",function(){return qe}),i.d(a,\"XYCursor\",function(){return B}),i.d(a,\"Cursor\",function(){return N}),i.d(a,\"RadarCursor\",function(){return ot});var n=i(\"m4/l\"),r=i(\"2I/e\"),s=i(\"C6dT\"),o=i(\"vMqJ\"),l=i(\"pR7v\"),h=i(\"+qIf\"),u=i(\"ZoDA\"),c=i(\"aCit\"),d=function(t){function e(){var e=t.call(this)||this;return e.className=\"DateAxisBreak\",e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"startDate\",{get:function(){return this.getPropertyValue(\"startDate\")},set:function(t){this.setPropertyValue(\"startDate\",t)&&(this.startValue=t.getTime(),this.axis&&(this.axis.invalidate(),this.axis.invalidateSeries()))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endDate\",{get:function(){return this.getPropertyValue(\"endDate\")},set:function(t){this.setPropertyValue(\"endDate\",t)&&(this.endValue=t.getTime(),this.axis&&(this.axis.invalidate(),this.axis.invalidateSeries()))},enumerable:!0,configurable:!0}),e}(u.a);c.b.registeredClasses.DateAxisBreak=d;var p=i(\"L91H\"),y=i(\"Mtpk\"),g=i(\"Wglt\"),m=i(\"Gg2j\"),f=i(\"Qkdp\"),x=function(t){function e(){var e=t.call(this)||this;return e.className=\"DateAxisDataItem\",e.applyTheme(),e.values.date={},e.values.endDate={},e}return n.c(e,t),Object.defineProperty(e.prototype,\"date\",{get:function(){return this.dates.date},set:function(t){this.setDate(\"date\",t),this.value=t.getTime()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endDate\",{get:function(){return this.dates.endDate},set:function(t){this.setDate(\"endDate\",t),this.endValue=t.getTime()},enumerable:!0,configurable:!0}),e}(l.b),v=function(t){function e(){var e=t.call(this)||this;return e.gridIntervals=new o.b,e.dateFormats=new h.a,e.periodChangeDateFormats=new h.a,e._baseIntervalReal={timeUnit:\"day\",count:1},e._minDifference={},e.className=\"DateAxis\",e.setPropertyValue(\"markUnitChange\",!0),e.snapTooltip=!0,e.gridIntervals.pushAll([{timeUnit:\"millisecond\",count:1},{timeUnit:\"millisecond\",count:5},{timeUnit:\"millisecond\",count:10},{timeUnit:\"millisecond\",count:50},{timeUnit:\"millisecond\",count:100},{timeUnit:\"millisecond\",count:500},{timeUnit:\"second\",count:1},{timeUnit:\"second\",count:5},{timeUnit:\"second\",count:10},{timeUnit:\"second\",count:30},{timeUnit:\"minute\",count:1},{timeUnit:\"minute\",count:5},{timeUnit:\"minute\",count:10},{timeUnit:\"minute\",count:15},{timeUnit:\"minute\",count:30},{timeUnit:\"hour\",count:1},{timeUnit:\"hour\",count:3},{timeUnit:\"hour\",count:6},{timeUnit:\"hour\",count:12},{timeUnit:\"day\",count:1},{timeUnit:\"day\",count:2},{timeUnit:\"day\",count:3},{timeUnit:\"day\",count:4},{timeUnit:\"day\",count:5},{timeUnit:\"week\",count:1},{timeUnit:\"month\",count:1},{timeUnit:\"month\",count:2},{timeUnit:\"month\",count:3},{timeUnit:\"month\",count:6},{timeUnit:\"year\",count:1},{timeUnit:\"year\",count:2},{timeUnit:\"year\",count:5},{timeUnit:\"year\",count:10},{timeUnit:\"year\",count:50},{timeUnit:\"year\",count:100},{timeUnit:\"year\",count:200},{timeUnit:\"year\",count:500},{timeUnit:\"year\",count:1e3},{timeUnit:\"year\",count:2e3},{timeUnit:\"year\",count:5e3},{timeUnit:\"year\",count:1e4},{timeUnit:\"year\",count:1e5}]),e.axisFieldName=\"date\",e.applyTheme(),e}return n.c(e,t),e.prototype.fillRule=function(t){var e=t.value,i=t.component,a=i._gridInterval,n=p.getDuration(a.timeUnit,a.count);Math.round((e-i.min)/n)/2==Math.round(Math.round((e-i.min)/n)/2)?t.axisFill.__disabled=!0:t.axisFill.__disabled=!1},e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),this.dateFormats.hasKey(\"millisecond\")||this.dateFormats.setKey(\"millisecond\",this.language.translate(\"_date_millisecond\")),this.dateFormats.hasKey(\"second\")||this.dateFormats.setKey(\"second\",this.language.translate(\"_date_second\")),this.dateFormats.hasKey(\"minute\")||this.dateFormats.setKey(\"minute\",this.language.translate(\"_date_minute\")),this.dateFormats.hasKey(\"hour\")||this.dateFormats.setKey(\"hour\",this.language.translate(\"_date_hour\")),this.dateFormats.hasKey(\"day\")||this.dateFormats.setKey(\"day\",this.language.translate(\"_date_day\")),this.dateFormats.hasKey(\"week\")||this.dateFormats.setKey(\"week\",this.language.translate(\"_date_day\")),this.dateFormats.hasKey(\"month\")||this.dateFormats.setKey(\"month\",this.language.translate(\"_date_month\")),this.dateFormats.hasKey(\"year\")||this.dateFormats.setKey(\"year\",this.language.translate(\"_date_year\")),this.periodChangeDateFormats.hasKey(\"millisecond\")||this.periodChangeDateFormats.setKey(\"millisecond\",this.language.translate(\"_date_millisecond\")),this.periodChangeDateFormats.hasKey(\"second\")||this.periodChangeDateFormats.setKey(\"second\",this.language.translate(\"_date_second\")),this.periodChangeDateFormats.hasKey(\"minute\")||this.periodChangeDateFormats.setKey(\"minute\",this.language.translate(\"_date_minute\")),this.periodChangeDateFormats.hasKey(\"hour\")||this.periodChangeDateFormats.setKey(\"hour\",this.language.translate(\"_date_hour\")),this.periodChangeDateFormats.hasKey(\"day\")||this.periodChangeDateFormats.setKey(\"day\",this.language.translate(\"_date_day\")),this.periodChangeDateFormats.hasKey(\"week\")||this.periodChangeDateFormats.setKey(\"week\",this.language.translate(\"_date_day\")),this.periodChangeDateFormats.hasKey(\"month\")||this.periodChangeDateFormats.setKey(\"month\",this.language.translate(\"_date_month\")+\" \"+this.language.translate(\"_date_year\"))},e.prototype.createDataItem=function(){return new x},e.prototype.createAxisBreak=function(){return new d},e.prototype.validateDataItems=function(){var e=this.start,i=this.end,a=(this.max-this.min)/this.baseDuration;t.prototype.validateDataItems.call(this),this.maxZoomFactor=(this.max-this.min)/this.baseDuration,this._deltaMinMax=this.baseDuration/2,e+=(i-e)*(1-a/((this.max-this.min)/this.baseDuration)),this.zoom({start:e,end:i},!1,!0)},e.prototype.handleSelectionExtremesChange=function(){},e.prototype.calculateZoom=function(){var e=this;t.prototype.calculateZoom.call(this);var i=this.chooseInterval(0,this.adjustDifference(this._minZoomed,this._maxZoomed),this._gridCount);p.getDuration(i.timeUnit,i.count)<this.baseDuration&&(i=n.a({},this.baseInterval)),this._gridInterval=i,this._gridDate=p.round(new Date(this.min),i.timeUnit,i.count,this.getFirstWeekDay(),this.dateFormatter.utc),this._nextGridUnit=p.getNextUnit(i.timeUnit),this._intervalDuration=p.getDuration(i.timeUnit,i.count);var a=Math.ceil(this._difference/this._intervalDuration);a=Math.max(-5,Math.floor(this.start*a)-3),p.add(this._gridDate,i.timeUnit,a*i.count,this.dateFormatter.utc),g.each(this.series.iterator(),function(t){if(t.baseAxis==e){var i=t.getAxisField(e),a=p.round(new Date(e._minZoomed),e.baseInterval.timeUnit,e.baseInterval.count).getTime(),n=a.toString(),r=t.dataItemsByAxis.getKey(e.uid).getKey(n),s=0;0!=e.start&&(s=r?(r=e.findFirst(r,a,i)).index:t.dataItems.findClosestIndex(e._minZoomed,function(t){return t[i]},\"left\"));var o=e.baseInterval,l=p.add(p.round(new Date(e._maxZoomed),o.timeUnit,o.count,e.getFirstWeekDay(),e.dateFormatter.utc),o.timeUnit,o.count,e.dateFormatter.utc).getTime(),h=l.toString(),u=t.dataItemsByAxis.getKey(e.uid).getKey(h),c=t.dataItems.length;1!=e.end&&(u?c=u.index:(l-=1,c=t.dataItems.findClosestIndex(l,function(t){return t[i]},\"right\")+1)),t.startIndex=s,t.endIndex=c,t.dataRangeInvalid&&t.validateDataRange()}})},e.prototype.findFirst=function(t,e,i){var a=t.index;if(a>0){var n=t.component.dataItems.getIndex(a-1),r=n[i];return!r||r.getTime()<e?t:this.findFirst(n,e,i)}return t},e.prototype.validateData=function(){t.prototype.validateData.call(this),y.isNumber(this.baseInterval.count)||(this.baseInterval.count=1)},Object.defineProperty(e.prototype,\"minDifference\",{get:function(){var t=this,e=Number.MAX_VALUE;return this.series.each(function(i){e>t._minDifference[i.uid]&&(e=t._minDifference[i.uid])}),e!=Number.MAX_VALUE&&0!=e||(e=p.getDuration(\"day\")),e},enumerable:!0,configurable:!0}),e.prototype.seriesDataChangeUpdate=function(t){this._minDifference[t.uid]=Number.MAX_VALUE},e.prototype.postProcessSeriesDataItems=function(){var t=this;this.series.each(function(e){JSON.stringify(e._baseInterval[t.uid])!=JSON.stringify(t.baseInterval)&&(e.dataItems.each(function(e){t.postProcessSeriesDataItem(e)}),e._baseInterval[t.uid]=t.baseInterval)}),this.addEmptyUnitsBreaks()},e.prototype.postProcessSeriesDataItem=function(t){var e=this,i=this.baseInterval,a=t.component.dataItemsByAxis.getKey(this.uid);f.each(t.dates,function(n){var r=t.getDate(n).getTime(),s=p.round(new Date(r),i.timeUnit,i.count,e.getFirstWeekDay(),e.dateFormatter.utc).getTime(),o=p.add(new Date(s),i.timeUnit,i.count,e.dateFormatter.utc);t.setCalculatedValue(n,s,\"open\"),t.setCalculatedValue(n,o.getTime(),\"close\"),a.setKey(s.toString(),t)})},e.prototype.addEmptyUnitsBreaks=function(){var t=this;if(this.skipEmptyPeriods&&y.isNumber(this.min)&&y.isNumber(this.max)){var e=this.baseInterval.timeUnit,i=this.baseInterval.count;this.axisBreaks.clear();for(var a=p.round(new Date(this.min),e,i,this.getFirstWeekDay(),this.dateFormatter.utc),n=void 0,r=function(){p.add(a,e,i,s.dateFormatter.utc);var r=a.getTime(),o=r.toString();g.contains(s.series.iterator(),function(e){return!!e.dataItemsByAxis.getKey(t.uid).getKey(o)})?n&&(n.endDate=new Date(r-1),n=void 0):n||((n=s.axisBreaks.create()).startDate=new Date(r))},s=this;a.getTime()<this.max-this.baseDuration;)r()}},e.prototype.fixAxisBreaks=function(){var e=this;t.prototype.fixAxisBreaks.call(this);var i=this.axisBreaks;i.length>0&&i.each(function(t){var i=Math.ceil(e._gridCount*(Math.min(e.end,t.endPosition)-Math.max(e.start,t.startPosition))/(e.end-e.start));t.gridInterval=e.chooseInterval(0,t.adjustedEndValue-t.adjustedStartValue,i);var a=p.round(new Date(t.adjustedStartValue),t.gridInterval.timeUnit,t.gridInterval.count,e.getFirstWeekDay(),e.dateFormatter.utc);a.getTime()>t.startDate.getTime()&&p.add(a,t.gridInterval.timeUnit,t.gridInterval.count,e.dateFormatter.utc),t.gridDate=a})},e.prototype.getFirstWeekDay=function(){return this.dateFormatter?this.dateFormatter.firstDayOfWeek:1},e.prototype.getGridDate=function(t,e){var i=this._gridInterval.timeUnit,a=this._gridInterval.count;p.round(t,i,1,this.getFirstWeekDay(),this.dateFormatter.utc);var n=t.getTime(),r=p.copy(t),s=p.add(r,i,e,this.dateFormatter.utc).getTime(),o=this.isInBreak(s);o&&o.endDate&&(r=new Date(o.endDate.getTime()),p.round(r,i,a,this.getFirstWeekDay(),this.dateFormatter.utc),r.getTime()<o.endDate.getTime()&&p.add(r,i,a,this.dateFormatter.utc),s=r.getTime());var l=this.adjustDifference(n,s);return Math.round(l/p.getDuration(i))<a?this.getGridDate(t,e+a):r},e.prototype.getBreaklessDate=function(t,e,i){var a=new Date(t.endValue);p.round(a,e,i,this.getFirstWeekDay(),this.dateFormatter.utc),p.add(a,e,i,this.dateFormatter.utc);var n=a.getTime();return(t=this.isInBreak(n))?this.getBreaklessDate(t,e,i):a},e.prototype.validateAxisElements=function(){var t=this;if(y.isNumber(this.max)&&y.isNumber(this.min)){this.calculateZoom();var e=this._gridDate.getTime(),i=this._gridInterval.timeUnit,a=this._gridInterval.count,n=p.copy(this._gridDate),r=this._dataItemsIterator;this.resetIterators();for(var s=function(){var t=o.getGridDate(p.copy(n),a);e=t.getTime();var s=p.copy(t);s=p.add(s,i,a,o.dateFormatter.utc);var l=o.dateFormats.getKey(i);o.markUnitChange&&n&&p.checkChange(t,n,o._nextGridUnit,o.dateFormatter.utc)&&\"year\"!==i&&(l=o.periodChangeDateFormats.getKey(i));var h=o.dateFormatter.format(t,l),u=r.find(function(t){return t.text===h});u.__disabled&&(u.__disabled=!1),o.appendDataItem(u),u.axisBreak=void 0,u.date=t,u.endDate=s,u.text=h,n=t,o.validateDataElement(u)},o=this;e<=this._maxZoomed;)s();var l=this.renderer;g.each(this.axisBreaks.iterator(),function(e){if(e.breakSize>0){var i=e.gridInterval.timeUnit,a=e.gridInterval.count;if(m.getDistance(e.startPoint,e.endPoint)>4*l.minGridDistance)for(var n,s=e.gridDate.getTime(),o=0,h=function(){var l=p.copy(e.gridDate);if(s=p.add(l,i,a*o,t.dateFormatter.utc).getTime(),o++,s>e.adjustedStartValue&&s<e.adjustedEndValue){var h=p.copy(l);h=p.add(h,i,a,t.dateFormatter.utc);var u=t.dateFormats.getKey(i);t.markUnitChange&&n&&p.checkChange(l,n,t._nextGridUnit,t.dateFormatter.utc)&&\"year\"!==i&&(u=t.periodChangeDateFormats.getKey(i));var c=t.dateFormatter.format(l,u),d=r.find(function(t){return t.text===c});d.__disabled&&(d.__disabled=!1),t.appendDataItem(d),d.axisBreak=e,e.dataItems.moveValue(d),d.date=l,d.endDate=h,d.text=c,n=l,t.validateDataElement(d)}};s<=e.adjustedMax;)h()}})}},e.prototype.validateDataElement=function(t){if(y.isNumber(this.max)&&y.isNumber(this.min)){var e=this.renderer,i=t.value,a=t.endValue;y.isNumber(a)||(a=i);var n=this.valueToPosition(i),r=this.valueToPosition(a),s=r;!t.isRange&&this._gridInterval.count>this.baseInterval.count&&(r=n+(r-n)/(this._gridInterval.count/this.baseInterval.count)),t.position=n;var o=t.tick;o&&!o.disabled&&e.updateTickElement(o,n,r);var l=t.grid;l&&!l.disabled&&e.updateGridElement(l,n,r);var h=t.axisFill;h&&!h.disabled&&(e.updateFillElement(h,n,s),t.isRange||this.fillRule(t));var u=t.mask;u&&e.updateFillElement(u,n,r);var c=t.label;if(c&&!c.disabled){var d=c.location;0==d&&(d=1!=this._gridInterval.count||\"week\"==this._gridInterval.timeUnit||t.isRange?0:.5),e.updateLabelElement(c,n,r,d)}}},Object.defineProperty(e.prototype,\"baseDuration\",{get:function(){return p.getDuration(this.baseInterval.timeUnit,this.baseInterval.count)},enumerable:!0,configurable:!0}),e.prototype.adjustMinMax=function(t,e){return{min:t,max:e,step:this.baseDuration}},e.prototype.fixMin=function(t){var e=p.round(new Date(t),this.baseInterval.timeUnit,this.baseInterval.count,this.getFirstWeekDay(),this.dateFormatter.utc).getTime();return e+(p.add(new Date(e),this.baseInterval.timeUnit,this.baseInterval.count,this.dateFormatter.utc).getTime()-e)*this.startLocation},e.prototype.fixMax=function(t){var e=p.round(new Date(t),this.baseInterval.timeUnit,this.baseInterval.count,this.getFirstWeekDay(),this.dateFormatter.utc).getTime();return e+(p.add(new Date(e),this.baseInterval.timeUnit,this.baseInterval.count,this.dateFormatter.utc).getTime()-e)*this.endLocation},e.prototype.chooseInterval=function(t,e,i){var a=this.gridIntervals,r=a.getIndex(t),s=p.getDuration(r.timeUnit,r.count),o=a.length-1;if(t>=o)return n.a({},a.getIndex(o));var l=Math.ceil(e/s);return e<s&&t>0?n.a({},a.getIndex(t-1)):l<=i?n.a({},a.getIndex(t)):t+1<a.length?this.chooseInterval(t+1,e,i):n.a({},a.getIndex(t))},e.prototype.formatLabel=function(t){return this.dateFormatter.format(t)},e.prototype.dateToPosition=function(t){return this.valueToPosition(t.getTime())},e.prototype.anyToPosition=function(t){return t instanceof Date?this.dateToPosition(t):this.valueToPosition(t)},e.prototype.dateToPoint=function(t){var e=this.dateToPosition(t),i=this.renderer.positionToPoint(e),a=this.renderer.positionToAngle(e);return{x:i.x,y:i.y,angle:a}},e.prototype.anyToPoint=function(t){return t instanceof Date?this.dateToPoint(t):this.valueToPoint(t)},e.prototype.positionToDate=function(t){return new Date(this.positionToValue(t))},e.prototype.getX=function(t,e,i){var a=this.getTimeByLocation(t,e,i);return y.isNumber(a)||(a=this.baseValue),this.renderer.positionToPoint(this.valueToPosition(a)).x},e.prototype.getY=function(t,e,i){var a=this.getTimeByLocation(t,e,i),n=t.getValue(\"valueX\",\"stack\");return y.isNumber(a)||(a=this.baseValue),this.renderer.positionToPoint(this.valueToPosition(a+n)).y},e.prototype.getAngle=function(t,e,i,a){var n=this.getTimeByLocation(t,e,i),r=t.getValue(a,\"stack\");return y.isNumber(n)||(n=this.baseValue),this.positionToAngle(this.valueToPosition(n+r))},e.prototype.getTimeByLocation=function(t,e,i){if(y.hasValue(e)){y.isNumber(i)||(i=t.workingLocations[e],y.isNumber(i)||(i=0));var a=t.values[e].open,n=t.values[e].close;return y.isNumber(a)&&y.isNumber(n)?a+(n-a)*i:void 0}},e.prototype.processSeriesDataItem=function(t,e){var i,a=t.component,n=t[\"date\"+e];if(n){i=n.getTime();var r,s=t[\"openDate\"+e],o=this._prevSeriesTime;if(s&&(r=s.getTime()),y.isNumber(r)){var l=Math.abs(i-r);this._minDifference[a.uid]>l&&(this._minDifference[a.uid]=l)}var h=i-o;h>0&&this._minDifference[a.uid]>h&&(this._minDifference[a.uid]=h),this._prevSeriesTime=i,a._baseInterval[this.uid]?this.postProcessSeriesDataItem(t):this._baseInterval&&(a._baseInterval[this.uid]=this._baseInterval,this.postProcessSeriesDataItem(t))}},e.prototype.updateAxisBySeries=function(){t.prototype.updateAxisBySeries.call(this);var e=this.chooseInterval(0,this.minDifference,1);this.minDifference>=p.getDuration(\"day\",27)&&\"week\"==e.timeUnit&&(e.timeUnit=\"month\",e.count=1),this.minDifference>=p.getDuration(\"day\",58)&&1==e.count&&(e.count=2),this.minDifference>=p.getDuration(\"day\",87)&&2==e.count&&(e.count=3),this.minDifference>=p.getDuration(\"day\",174)&&5==e.count&&(e.count=6),this.minDifference>=p.getDuration(\"hour\",23)&&\"hour\"==e.timeUnit&&(e.timeUnit=\"day\",e.count=1),this.minDifference>=p.getDuration(\"week\",1)-p.getDuration(\"hour\",1)&&\"day\"==e.timeUnit&&(e.timeUnit=\"week\",e.count=1),this.minDifference>=p.getDuration(\"year\",1)-p.getDuration(\"day\",1.01)&&\"month\"==e.timeUnit&&(e.timeUnit=\"year\",e.count=1),this._baseIntervalReal=e},Object.defineProperty(e.prototype,\"baseInterval\",{get:function(){return this._baseInterval?this._baseInterval:this._baseIntervalReal},set:function(t){JSON.stringify(this._baseInterval)!=JSON.stringify(t)&&(this._baseInterval=t,y.isNumber(t.count)||(t.count=1),this.invalidate(),this.postProcessSeriesDataItems())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"skipEmptyPeriods\",{get:function(){return this.getPropertyValue(\"skipEmptyPeriods\")},set:function(t){if(this.setPropertyValue(\"skipEmptyPeriods\",t)&&this.invalidateData(),t){var e=this.axisBreaks.template;e.startLine.disabled=!0,e.endLine.disabled=!0,e.fillShape.disabled=!0,e.breakSize=0}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"tooltipDateFormat\",{get:function(){return this.getPropertyValue(\"tooltipDateFormat\")},set:function(t){this.setPropertyValue(\"tooltipDateFormat\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"markUnitChange\",{get:function(){return this.getPropertyValue(\"markUnitChange\")},set:function(t){this.setPropertyValue(\"markUnitChange\",t)&&this.invalidateData()},enumerable:!0,configurable:!0}),e.prototype.getTooltipText=function(t){var e,i=this.positionToDate(t);if(i=p.round(i,this.baseInterval.timeUnit,this.baseInterval.count,this.getFirstWeekDay(),this.dateFormatter.utc),y.hasValue(this.tooltipDateFormat))e=this.dateFormatter.format(i,this.tooltipDateFormat);else{var a=this.dateFormats.getKey(this.baseInterval.timeUnit);e=a?this.dateFormatter.format(i,a):this.getPositionLabel(t)}return this.adapter.apply(\"getTooltipText\",e)},e.prototype.roundPosition=function(t,e){var i=this.baseInterval,a=i.timeUnit,n=i.count,r=this.positionToDate(t);if(p.round(r,a,n,this.getFirstWeekDay(),this.dateFormatter.utc),e>0&&p.add(r,a,e*n,this.dateFormatter.utc),this.isInBreak(r.getTime()))for(;r.getTime()<this.max&&(p.add(r,a,n,this.dateFormatter.utc),this.isInBreak(r.getTime())););return this.dateToPosition(r)},e.prototype.getCellStartPosition=function(t){return this.roundPosition(t,0)},e.prototype.getCellEndPosition=function(t){return this.roundPosition(t,1)},e.prototype.getSeriesDataItem=function(t,e,i){var a,n=this.positionToValue(e),r=p.round(new Date(n),this.baseInterval.timeUnit,this.baseInterval.count,this.getFirstWeekDay(),this.dateFormatter.utc),s=t.dataItemsByAxis.getKey(this.uid).getKey(r.getTime().toString());!s&&i&&(a=\"Y\"==this.axisLetter?\"dateY\":\"dateX\",s=t.dataItems.getIndex(t.dataItems.findClosestIndex(r.getTime(),function(t){return t[a]?t[a].getTime():-1/0},\"any\")));return s},e.prototype.getPositionLabel=function(t){var e=this.positionToDate(t);return this.dateFormatter.format(e,this.getCurrentLabelFormat())},e.prototype.getCurrentLabelFormat=function(){return this.dateFormats.getKey(this._gridInterval?this._gridInterval.timeUnit:\"day\")},e.prototype.initRenderer=function(){t.prototype.initRenderer.call(this);var e=this.renderer;e&&(e.ticks.template.location=0,e.grid.template.location=0,e.labels.template.location=0,e.baseGrid.disabled=!0)},Object.defineProperty(e.prototype,\"basePoint\",{get:function(){return{x:0,y:0}},enumerable:!0,configurable:!0}),e.prototype.zoomToDates=function(t,e,i,a){t=this.dateFormatter.parse(t),e=this.dateFormatter.parse(e),this.zoomToValues(t.getTime(),e.getTime(),i,a)},e.prototype.asIs=function(e){return\"baseInterval\"==e||t.prototype.asIs.call(this,e)},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.dateFormats=e.dateFormats,this.periodChangeDateFormats=e.periodChangeDateFormats,e._baseInterval&&(this.baseInterval=e.baseInterval)},e.prototype.showTooltipAtPosition=function(e,i){var a=this;if(i||(e=this.toAxisPosition(e)),this.snapTooltip){var n,r=p.round(this.positionToDate(e),this.baseInterval.timeUnit,1,this.getFirstWeekDay(),this.dateFormatter.utc).getTime();if(this.series.each(function(t){if(t.baseAxis==a){var i=a.getSeriesDataItem(t,e,!0);if(i){var s=void 0;t.xAxis==a&&(s=i.dateX),t.yAxis==a&&(s=i.dateY),n?Math.abs(n.getTime()-r)>Math.abs(s.getTime()-r)&&(n=s):n=s}}}),n){var s=n.getTime();n=p.round(new Date(s),this.baseInterval.timeUnit,this.baseInterval.count,this.getFirstWeekDay(),this.dateFormatter.utc),s=n.getTime(),n=new Date(n.getTime()+this.baseDuration*this.renderer.tooltipLocation),e=this.dateToPosition(n),this.series.each(function(t){var e=t.dataItemsByAxis.getKey(a.uid).getKey(s.toString()),i=t.showTooltipAtDataItem(e);i?a.chart._seriesPoints.push({series:t,point:i}):(t.tooltipText||t.tooltipHTML)&&t.hideTooltip()})}}t.prototype.showTooltipAtPosition.call(this,e,!0)},Object.defineProperty(e.prototype,\"snapTooltip\",{get:function(){return this.getPropertyValue(\"snapTooltip\")},set:function(t){this.setPropertyValue(\"snapTooltip\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"gridInterval\",{get:function(){return this._gridInterval},enumerable:!0,configurable:!0}),e.prototype.makeGap=function(t,e){var i=t.component;if(t&&e&&(!i.connect&&y.isNumber(i.autoGapCount)&&i.baseAxis==this&&t.dates[\"date\"+this.axisLetter].getTime()-e.dates[\"date\"+this.axisLetter].getTime()>i.autoGapCount*this.baseDuration))return!0;return!1},e}(l.a);c.b.registeredClasses.DateAxis=v,c.b.registeredClasses.DateAxisDataItem=x;var b=i(\"k6kv\"),P=i(\"OXm9\"),A=i(\"AAkI\"),C=i(\"Uslz\"),I=function(t){function e(){var e=t.call(this)||this;return e.className=\"CategoryAxisBreak\",e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"startPosition\",{get:function(){if(this.axis)return this.axis.indexToPosition(this.adjustedStartValue)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endPosition\",{get:function(){if(this.axis)return this.axis.indexToPosition(this.adjustedEndValue)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"startCategory\",{get:function(){return this.getPropertyValue(\"startCategory\")},set:function(t){this.setPropertyValue(\"startCategory\",t)&&this.axis&&(this.axis.invalidateDataItems(),this.axis.invalidateSeries())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endCategory\",{get:function(){return this.getPropertyValue(\"endCategory\")},set:function(t){this.setPropertyValue(\"endCategory\",t)&&this.axis&&(this.axis.invalidateDataItems(),this.axis.invalidateSeries())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"startValue\",{get:function(){var t=this.getPropertyValue(\"startCategory\");return t?this.axis.categoryToIndex(t):this.getPropertyValue(\"startValue\")},set:function(t){this.setPropertyValue(\"startValue\",t)&&this.axis&&(this.axis.invalidateDataItems(),this.axis.invalidateSeries())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endValue\",{get:function(){var t=this.getPropertyValue(\"endCategory\");return t?this.axis.categoryToIndex(t):this.getPropertyValue(\"endValue\")},set:function(t){this.setPropertyValue(\"endValue\",t)&&this.axis&&(this.axis.invalidateDataItems(),this.axis.invalidateSeries())},enumerable:!0,configurable:!0}),e}(C.a);c.b.registeredClasses.CategoryAxisBreak=I;var D=i(\"x79X\"),_=function(t){function e(){var e=t.call(this)||this;return e.adapter=new D.a(e),e.seriesDataItems={},e.className=\"CategoryAxisDataItem\",e.text=\"{category}\",e.locations.category=0,e.locations.endCategory=1,e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"category\",{get:function(){return this.adapter.isEnabled(\"category\")?this.adapter.apply(\"category\",this.properties.category):this.properties.category},set:function(t){this.setProperty(\"category\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endCategory\",{get:function(){return this.properties.endCategory},set:function(t){this.setProperty(\"endCategory\",t)},enumerable:!0,configurable:!0}),e}(A.b),T=function(t){function e(){var e=t.call(this)||this;return e.dataItemsByCategory=new h.a,e.className=\"CategoryAxis\",e.axisFieldName=\"category\",e._lastDataItem=e.createDataItem(),e._lastDataItem.component=e,e._disposers.push(e._lastDataItem),e.applyTheme(),e}return n.c(e,t),e.prototype.createDataItem=function(){return new _},e.prototype.createAxisBreak=function(){return new I},e.prototype.processSeriesDataItem=function(e,i){t.prototype.processSeriesDataItem.call(this,e,i);var a=e[\"category\"+this.axisLetter],n=this.dataItemsByCategory.getKey(a);if(n){var r=e.component.uid,s=n.seriesDataItems[r];s||(s=[],n.seriesDataItems[r]=s),s.push(e)}},e.prototype.validateDataRange=function(){var i=this;t.prototype.validateDataRange.call(this),g.each(this._series.iterator(),function(t){if(t.xAxis instanceof e&&t.yAxis instanceof e)t.invalidateDataRange();else{var a=i.positionToIndex(i.start),n=i.positionToIndex(i.end);n>=i.dataItems.length&&n--;for(var r=t.uid,s=void 0,o=void 0,l=a;l<=n;l++){var h=i.dataItems.getIndex(l);if(h){var u=h.seriesDataItems[r];if(u)for(var c=0;c<u.length;c++){var d=u[c];if(d){var p=d.index;(!y.isNumber(s)||p<s)&&(s=p),(!y.isNumber(o)||p>o)&&(o=p)}}}}y.isNumber(s)?t.startIndex=s:t.start=i.start,y.isNumber(o)?t.endIndex=o+1:t.end=i.end,i.axisBreaks.length>0&&t.invalidateDataRange()}})},e.prototype.validate=function(){var e=this;t.prototype.validate.call(this);var i=this.dataItems.length,a=m.fitToRange(Math.floor(this.start*i-1),0,i),n=m.fitToRange(Math.ceil(this.end*i),0,i);this.renderer.invalid&&this.renderer.validate();var r=this.renderer.axisLength/this.renderer.minGridDistance,s=Math.min(this.dataItems.length,Math.ceil((n-a)/r));if(this._startIndex=Math.floor(a/s)*s,this._endIndex=Math.ceil(this.end*i),this.fixAxisBreaks(),this._startIndex==this._endIndex&&this._endIndex++,this._frequency=s,!(this.axisLength<=0)){this.maxZoomFactor=this.dataItems.length,this.dataItems.length<=0&&(this.maxZoomFactor=1),this.resetIterators(),a=m.max(0,this._startIndex-this._frequency),n=m.min(this.dataItems.length,this._endIndex+this._frequency);for(var o=0,l=0;l<a;l++){(u=this.dataItems.getIndex(l)).__disabled=!0}l=n;for(var h=this.dataItems.length;l<h;l++){(u=this.dataItems.getIndex(l)).__disabled=!0}for(l=a;l<n;l++)if(l<this.dataItems.length){var u=this.dataItems.getIndex(l);if(l/this._frequency==Math.round(l/this._frequency))this.isInBreak(l)||(this.appendDataItem(u),this.validateDataElement(u,o)),o++;else u.__disabled=!0}this.appendDataItem(this._lastDataItem),this.validateDataElement(this._lastDataItem,o+1,this.dataItems.length),this.axisBreaks.each(function(t){var i=t.adjustedStartValue,a=t.adjustedEndValue;if(m.intersect({start:i,end:a},{start:e._startIndex,end:e._endIndex}))for(var n=m.fitToRange(Math.ceil(e._frequency/t.breakSize),1,a-i),r=0,s=i;s<=a;s+=n){var o=e.dataItems.getIndex(s);e.appendDataItem(o),e.validateDataElement(o,r),r++}}),this.validateBreaks(),this.validateAxisRanges(),this.ghostLabel.invalidate(),this.renderer.invalidateLayout()}},e.prototype.validateDataElement=function(e,i,a){t.prototype.validateDataElement.call(this,e);var n=this.renderer;y.isNumber(a)||(a=this.categoryToIndex(e.category));var r=this.categoryToIndex(e.endCategory);y.isNumber(r)||(r=a);var s,o,l,h=this.indexToPosition(a,e.locations.category),u=this.indexToPosition(r,e.locations.endCategory);e.position=h,e.isRange&&(s=r,o=this.indexToPosition(a,e.locations.category),l=this.indexToPosition(s,e.locations.endCategory)),e.point=n.positionToPoint(h);var c=e.tick;c&&!c.disabled&&n.updateTickElement(c,h,u);var d=e.grid;d&&!d.disabled&&n.updateGridElement(d,h,u);var p=e.label;p&&!p.disabled&&(e.isRange&&void 0!=p.text||(e.text=e.text),n.updateLabelElement(p,h,u),(e.label.measuredWidth>this.ghostLabel.measuredWidth||e.label.measuredHeight>this.ghostLabel.measuredHeight)&&(this.ghostLabel.text=e.label.currentText));var g=e.axisFill;g&&!g.disabled&&(e.isRange||(s=a+this._frequency,o=this.indexToPosition(a,g.location),l=this.indexToPosition(s,g.location)),n.updateFillElement(g,o,l),e.isRange||this.fillRule(e,i));var m=e.mask;m&&n.updateFillElement(m,o,l)},e.prototype.disposeData=function(){this.dataItemsByCategory.clear(),t.prototype.disposeData.call(this)},e.prototype.processDataItem=function(e,i){t.prototype.processDataItem.call(this,e,i),this.dataItemsByCategory.setKey(e.category,e)},e.prototype.getDataItem=function(t){var e=t[this.dataFields.category],i=this.dataItemsByCategory.getKey(e);return i||this.dataItems.create()},e.prototype.indexToPosition=function(t,e){y.isNumber(e)||(e=.5);var i=this.startIndex,a=this.endIndex,n=this.adjustDifference(i,a),r=this.startLocation;n-=r,n-=1-this.endLocation;var s=this.axisBreaks;return g.eachContinue(s.iterator(),function(e){var n=e.adjustedStartValue,r=e.adjustedEndValue;if(t<i)return!1;if(m.intersect({start:n,end:r},{start:i,end:a})){n=Math.max(i,n),r=Math.min(a,r);var s=e.breakSize;t>r?i+=(r-n)*(1-s):t<n||(t=n+(t-n)*s)}return!0}),m.round((t+e-r-i)/n,5)},e.prototype.categoryToPosition=function(t,e){var i=this.categoryToIndex(t);return this.indexToPosition(i,e)},e.prototype.categoryToPoint=function(t,e){var i=this.categoryToPosition(t,e),a=this.renderer.positionToPoint(i),n=this.renderer.positionToAngle(i);return{x:a.x,y:a.y,angle:n}},e.prototype.anyToPoint=function(t,e){return this.categoryToPoint(t,e)},e.prototype.anyToPosition=function(t,e){return this.categoryToPosition(t,e)},e.prototype.categoryToIndex=function(t){if(y.hasValue(t)){var e=this.dataItemsByCategory.getKey(t);if(e)return e.index}},e.prototype.zoomToCategories=function(t,e){this.zoomToIndexes(this.categoryToIndex(t),this.categoryToIndex(e)+1)},e.prototype.getAnyRangePath=function(t,e,i,a){var n=this.categoryToPosition(t,i),r=this.categoryToPosition(e,a);return this.getPositionRangePath(n,r)},e.prototype.roundPosition=function(t,e){var i=this.positionToIndex(t);return this.indexToPosition(i,e)},e.prototype.getFirstSeriesDataItem=function(t,e){for(var i=0;i<t.dataItems.length;i++){var a=t.dataItems.getIndex(i);if(t.xAxis==this&&a.categoryX==e)return a;if(t.yAxis==this&&a.categoryY==e)return a}},e.prototype.getLastSeriesDataItem=function(t,e){for(var i=t.dataItems.length-1;i>=0;i--){var a=t.dataItems.getIndex(i);if(t.xAxis==this&&a.categoryX==e)return a;if(t.yAxis==this&&a.categoryY==e)return a}},e.prototype.getSeriesDataItem=function(t,e,i){var a=this;if(y.isNumber(e)){var n=this.positionToIndex(e);n>=this.dataItems.length&&n--;var r=this.dataItems.getIndex(n);if(r){var s,o=r.category,l=t.dataItems.getIndex(n);if(l){if(t.xAxis==this&&l.categoryX==o)return l;if(t.yAxis==this&&l.categoryY==o)return l}return t.dataItems.each(function(e){t.xAxis==a&&e.categoryX==o&&(s||(s=e),Math.abs(n-s.index)>Math.abs(n-e.index)&&(s=e)),t.yAxis==a&&e.categoryY==o&&(s||(s=e),Math.abs(n-s.index)>Math.abs(n-e.index)&&(s=e))}),s}}},e.prototype.getX=function(t,e,i){var a;return y.hasValue(e)&&(a=this.categoryToPosition(t.categories[e],i)),y.isNaN(a)?this.basePoint.x:this.renderer.positionToPoint(a).x},e.prototype.getY=function(t,e,i){var a;return y.hasValue(e)&&(a=this.categoryToPosition(t.categories[e],i)),y.isNaN(a)?this.basePoint.y:this.renderer.positionToPoint(a).y},e.prototype.getAngle=function(t,e,i,a){return this.positionToAngle(this.categoryToPosition(t.categories[e],i))},e.prototype.getCellStartPosition=function(t){return this.roundPosition(t,0)},e.prototype.getCellEndPosition=function(t){return this.roundPosition(t,1)},e.prototype.getTooltipText=function(t){var e=this.dataItems.getIndex(this.positionToIndex(t));if(e)return this.adapter.apply(\"getTooltipText\",e.category)},e.prototype.positionToIndex=function(t){(t=m.round(t,10))<0&&(t=0);var e=this.startIndex,i=this.endIndex,a=i-e,n=this.axisBreaks,r=null;return g.eachContinue(n.iterator(),function(n){var s=n.startPosition,o=n.endPosition,l=n.adjustedStartValue,h=n.adjustedEndValue;l=m.max(l,e),h=m.min(h,i);var u=n.breakSize;if(a-=(h-l)*(1-u),t>o)e+=(h-l)*(1-u);else if(!(t<s)){var c=(t-s)/(o-s);return r=l+Math.round(c*(h-l)),!1}return!0}),y.isNumber(r)||(r=Math.floor(t*a+e)),r},e.prototype.positionToCategory=function(t){return this.getPositionLabel(t)},e.prototype.getPositionLabel=function(t){var e=this.dataItems.getIndex(this.positionToIndex(t));if(e)return e.category},Object.defineProperty(e.prototype,\"basePoint\",{get:function(){return this.renderer.positionToPoint(1)},enumerable:!0,configurable:!0}),e.prototype.initRenderer=function(){t.prototype.initRenderer.call(this),this.renderer.baseGrid.disabled=!0},Object.defineProperty(e.prototype,\"frequency\",{get:function(){return this._frequency},enumerable:!0,configurable:!0}),e}(A.a);c.b.registeredClasses.CategoryAxis=T,c.b.registeredClasses.CategoryAxisDataItem=_;var V=i(\"aM7D\"),S=i(\"Vs7R\"),F=i(\"hD5A\"),k=i(\"v9UT\"),O=i(\"hJ5i\"),w=i(\"hGwe\"),R=function(t){function e(){var e=t.call(this)||this;return e.className=\"XYSeriesDataItem\",e.values.valueX={stack:0},e.values.valueY={stack:0},e.values.openValueX={},e.values.openValueY={},e.values.dateX={},e.values.dateY={},e.values.openDateX={},e.values.openDateY={},e.setLocation(\"dateX\",.5,0),e.setLocation(\"dateY\",.5,0),e.setLocation(\"categoryX\",.5,0),e.setLocation(\"categoryY\",.5,0),e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"valueX\",{get:function(){return this.values.valueX.value},set:function(t){this.setValue(\"valueX\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"valueY\",{get:function(){return this.values.valueY.value},set:function(t){this.setValue(\"valueY\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"dateX\",{get:function(){return this.getDate(\"dateX\")},set:function(t){this.setDate(\"dateX\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"dateY\",{get:function(){return this.getDate(\"dateY\")},set:function(t){this.setDate(\"dateY\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"categoryX\",{get:function(){return this.categories.categoryX},set:function(t){this.setCategory(\"categoryX\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"categoryY\",{get:function(){return this.categories.categoryY},set:function(t){this.setCategory(\"categoryY\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"openValueX\",{get:function(){return this.values.openValueX.value},set:function(t){this.setValue(\"openValueX\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"openValueY\",{get:function(){return this.values.openValueY.value},set:function(t){this.setValue(\"openValueY\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"openDateX\",{get:function(){return this.getDate(\"openDateX\")},set:function(t){this.setDate(\"openDateX\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"openDateY\",{get:function(){return this.getDate(\"openDateY\")},set:function(t){this.setDate(\"openDateY\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"openCategoryX\",{get:function(){return this.categories.openCategoryX},set:function(t){this.setProperty(\"openCategoryX\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"openCategoryY\",{get:function(){return this.categories.openCategoryY},set:function(t){this.setProperty(\"openCategoryY\",t)},enumerable:!0,configurable:!0}),e.prototype.getMin=function(t,e,i){var a,n=this;return y.isNumber(i)||(i=0),O.each(t,function(t){var r;r=e?n.getWorkingValue(t):n.getValue(t),((r+=i)<a||!y.isNumber(a))&&(a=r)}),a},e.prototype.getMax=function(t,e,i){var a,n=this;return y.isNumber(i)||(i=0),O.each(t,function(t){var r;r=e?n.getWorkingValue(t):n.getValue(t),((r+=i)>a||!y.isNumber(a))&&(a=r)}),a},e}(V.b),L=function(t){function e(){var e=t.call(this)||this;return e._xAxis=new F.d,e._yAxis=new F.d,e._xValueFields=[],e._yValueFields=[],e._baseInterval={},e.className=\"XYSeries\",e.isMeasured=!1,e.cursorTooltipEnabled=!0,e.cursorHoverEnabled=!0,e.excludeFromTotal=!1,e.mainContainer.mask=new S.a,e.mainContainer.mask.setElement(e.paper.add(\"path\")),e.stacked=!1,e.snapTooltip=!1,e.tooltip.pointerOrientation=\"horizontal\",e.tooltip.events.on(\"hidden\",function(){e.returnBulletDefaultState()},void 0,!1),e._disposers.push(e._xAxis),e._disposers.push(e._yAxis),e.applyTheme(),e}return n.c(e,t),e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"X/Y Series\"))},e.prototype.createDataItem=function(){return new R},e.prototype.dataChangeUpdate=function(){this._tmin.clear(),this._tmax.clear(),this._smin.clear(),this._smax.clear(),this.xAxis&&this.xAxis.seriesDataChangeUpdate(this),this.yAxis&&this.yAxis.seriesDataChangeUpdate(this)},e.prototype.validateData=function(){if(this.defineFields(),this.data.length>0&&this.dataChangeUpdate(),t.prototype.validateData.call(this),this.updateItemReaderText(),!y.hasValue(this.dataFields[this._xField])||!y.hasValue(this.dataFields[this._yField]))throw Error('Data fields for series \"'+(this.name?this.name:this.uid)+'\" are not properly defined.')},e.prototype.processDataItem=function(e,i){try{t.prototype.processDataItem.call(this,e,i),e.events.disable(),this.xAxis.processSeriesDataItem(e,\"X\"),this.yAxis.processSeriesDataItem(e,\"Y\"),e.events.enable(),this.setInitialWorkingValues(e)}catch(t){this._chart.raiseCriticalError(t)}},e.prototype.updateDataItem=function(e){t.prototype.updateDataItem.call(this,e),this.xAxis.processSeriesDataItem(e,\"X\"),this.yAxis.processSeriesDataItem(e,\"Y\")},e.prototype.setInitialWorkingValues=function(t){},e.prototype.disposeData=function(){if(t.prototype.disposeData.call(this),this.xAxis){var e=this.dataItemsByAxis.getKey(this.xAxis.uid);e&&e.clear(),this.xAxis instanceof T&&this.clearCatAxis(this.xAxis)}if(this.yAxis){var i=this.dataItemsByAxis.getKey(this.yAxis.uid);i&&i.clear(),this.yAxis instanceof T&&this.clearCatAxis(this.yAxis)}},e.prototype.clearCatAxis=function(t){var e=this.uid;t.dataItems.each(function(t){t.seriesDataItems[e]&&(t.seriesDataItems[e]=[])})},e.prototype.defineFields=function(){var t=this.xAxis,e=this.yAxis,i=t.axisFieldName,a=i+\"X\",n=\"open\"+k.capitalize(i)+\"X\",r=e.axisFieldName,s=r+\"Y\",o=\"open\"+k.capitalize(r)+\"Y\";this._xField=a,this._yField=s,this.dataFields[n]&&(this._xOpenField=n),this.dataFields[o]&&(this._yOpenField=o),this.dataFields[o]||this.baseAxis!=this.yAxis||(this._yOpenField=s),this.dataFields[n]||this.baseAxis!=this.xAxis||(this._xOpenField=a),this.stacked&&this.baseAxis==this.xAxis&&(this._xOpenField=a),this.stacked&&this.baseAxis==this.yAxis&&(this._yOpenField=s),this.xAxis instanceof T&&this.yAxis instanceof T&&(this._yOpenField||(this._yOpenField=s)),this._xValueFields=[],this._yValueFields=[],this.addValueField(this.xAxis,this._xValueFields,this._xField),this.addValueField(this.xAxis,this._xValueFields,this._xOpenField),this.addValueField(this.yAxis,this._yValueFields,this._yField),this.addValueField(this.yAxis,this._yValueFields,this._yOpenField)},e.prototype.addValueField=function(t,e,i){t instanceof l.a&&y.hasValue(this.dataFields[i])&&-1==e.indexOf(i)&&e.push(i)},e.prototype.setCategoryAxisField=function(t,e){y.hasValue(this.dataFields[t])||(this.dataFields[t]=e.dataFields.category)},e.prototype.setDateAxisField=function(t,e){y.hasValue(this.dataFields[t])||(this.dataFields[t]=e.dataFields.date)},e.prototype.afterDraw=function(){t.prototype.afterDraw.call(this),this.createMask()},e.prototype.createMask=function(){if(this.mainContainer.mask){var t=this.getMaskPath();g.each(this.axisRanges.iterator(),function(e){e.axisFill.fillPath&&(e.axisFill.validate(),t+=e.axisFill.fillPath)}),this.mainContainer.mask.path=t}},e.prototype.getMaskPath=function(){return w.rectToPath({x:0,y:0,width:this.xAxis.axisLength,height:this.yAxis.axisLength})},e.prototype.getAxisField=function(t){return t==this.xAxis?this.xField:t==this.yAxis?this.yField:void 0},e.prototype.validateDataItems=function(){this.xAxis.updateAxisBySeries(),this.yAxis.updateAxisBySeries(),t.prototype.validateDataItems.call(this),this.xAxis.postProcessSeriesDataItems(),this.yAxis.postProcessSeriesDataItems()},e.prototype.validateDataRange=function(){this.xAxis.dataRangeInvalid&&this.xAxis.validateDataRange(),this.yAxis.dataRangeInvalid&&this.yAxis.validateDataRange(),t.prototype.validateDataRange.call(this)},e.prototype.validate=function(){this.xAxis.invalid&&this.xAxis.validate(),this.yAxis.invalid&&this.yAxis.validate(),this.y=this.yAxis.pixelY,this.x=this.xAxis.pixelX,this._showBullets=!0;var e=this.minBulletDistance;y.isNumber(e)&&this.baseAxis.axisLength/(this.endIndex-this.startIndex)<e&&(this._showBullets=!1),t.prototype.validate.call(this)},Object.defineProperty(e.prototype,\"xAxis\",{get:function(){if(this.chart){if(!this._xAxis.get()){var t=this.chart.xAxes.getIndex(0);if(!t)throw Error(\"There are no X axes on chart.\");this.xAxis=t}return this._xAxis.get()}},set:function(t){var e=this._xAxis.get();e!=t&&(e&&(this.dataItemsByAxis.removeKey(e.uid),this._xAxis.dispose(),e.series.removeValue(this)),this._xAxis.set(t,t.registerSeries(this)),this.dataItemsByAxis.setKey(t.uid,new h.a),this.invalidateData())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"yAxis\",{get:function(){if(this.chart){if(!this._yAxis.get()){var t=this.chart.yAxes.getIndex(0);if(!t)throw Error(\"There are no Y axes on chart.\");this.yAxis=t}return this._yAxis.get()}},set:function(t){var e=this._yAxis.get();e!=t&&(e&&(this.dataItemsByAxis.removeKey(e.uid),this._yAxis.dispose(),e.series.removeValue(this)),this._yAxis.set(t,t.registerSeries(this)),this.dataItemsByAxis.setKey(t.uid,new h.a),this.invalidateData())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"baseAxis\",{get:function(){return this._baseAxis||(this.yAxis instanceof v&&(this._baseAxis=this.yAxis),this.xAxis instanceof v&&(this._baseAxis=this.xAxis),this.yAxis instanceof T&&(this._baseAxis=this.yAxis),this.xAxis instanceof T&&(this._baseAxis=this.xAxis),this._baseAxis||(this._baseAxis=this.xAxis)),this._baseAxis},set:function(t){this._baseAxis!=t&&(this._baseAxis=t,this.invalidate())},enumerable:!0,configurable:!0}),e.prototype.processValues=function(e){t.prototype.processValues.call(this,e);var i=this.dataItems,a=1/0,n=-1/0,r=1/0,s=-1/0,o=this.startIndex,l=this.endIndex;e||(o=0,l=this.dataItems.length);for(var h=o;h<l;h++){var u=i.getIndex(h);this.getStackValue(u,e);var c=u.getValue(\"valueX\",\"stack\"),d=u.getValue(\"valueY\",\"stack\");a=m.min(u.getMin(this._xValueFields,e,c),a),r=m.min(u.getMin(this._yValueFields,e,d),r),n=m.max(u.getMax(this._xValueFields,e,c),n),s=m.max(u.getMax(this._yValueFields,e,d),s),this.stacked&&(this.baseAxis==this.xAxis&&(r=m.min(r,d)),this.baseAxis==this.yAxis&&(a=m.min(a,c)))}this.xAxis.processSeriesDataItems(),this.yAxis.processSeriesDataItems();var p=this.xAxis.uid,y=this.yAxis.uid;if(!e&&(this._tmin.getKey(p)!=a||this._tmax.getKey(p)!=n||this._tmin.getKey(y)!=r||this._tmax.getKey(y)!=s)){this._tmin.setKey(p,a),this._tmax.setKey(p,n),this._tmin.setKey(y,r),this._tmax.setKey(y,s);var g=this.stackedSeries;g&&(g.isDisposed()?this.stackedSeries=void 0:g.processValues(!1)),this.dispatchImmediately(\"extremeschanged\")}this._smin.getKey(p)==a&&this._smax.getKey(p)==n&&this._smin.getKey(y)==r&&this._smax.getKey(y)==s||(this._smin.setKey(p,a),this._smax.setKey(p,n),this._smin.setKey(y,r),this._smax.setKey(y,s),(this.appeared||0!=this.start||1!=this.end)&&this.dispatchImmediately(\"selectionextremeschanged\")),!e&&this.stacked&&this.processValues(!0)},e.prototype.hideTooltip=function(){t.prototype.hideTooltip.call(this),this.returnBulletDefaultState(),this._prevTooltipDataItem=void 0},e.prototype.showTooltipAtPosition=function(t,e){var i;if(this.visible&&!this.isHiding&&!this.isShowing){var a=this._xAxis.get(),n=this._yAxis.get();a==this.baseAxis&&(i=a.getSeriesDataItem(this,a.toAxisPosition(t),this.snapTooltip)),n==this.baseAxis&&(i=n.getSeriesDataItem(this,n.toAxisPosition(e),this.snapTooltip));var r=this.showTooltipAtDataItem(i);if(r)return r;if(!this.tooltipText)return}this.hideTooltip()},e.prototype.showTooltipAtDataItem=function(t){if(this.returnBulletDefaultState(t),t&&t.visible&&(this.updateLegendValue(t),this.cursorTooltipEnabled)){this.tooltipDataItem=t;var e=this.tooltipXField,i=this.tooltipYField;if(y.hasValue(t[e])&&y.hasValue(t[i])){var a=this.getPoint(t,e,i,t.locations[e],t.locations[i]);if(a){if(this.tooltipX=a.x,this.tooltipY=a.y,this._prevTooltipDataItem!=t&&(this.dispatchImmediately(\"tooltipshownat\",{type:\"tooltipshownat\",target:this,dataItem:t}),this._prevTooltipDataItem=t),this.cursorHoverEnabled)try{for(var r=n.g(t.sprites),s=r.next();!s.done;s=r.next()){var o=s.value;!o.parent.visible||o.isHidden||o.__disabled||o.disabled||o.isHiding||(o.isHover=!0)}}catch(t){l={error:t}}finally{try{s&&!s.done&&(h=r.return)&&h.call(r)}finally{if(l)throw l.error}}return this.showTooltip()?k.spritePointToSvg({x:a.x,y:a.y},this):void 0}}}var l,h},e.prototype.returnBulletDefaultState=function(t){if(this._prevTooltipDataItem&&this._prevTooltipDataItem!=t)try{for(var e=n.g(this._prevTooltipDataItem.sprites),i=e.next();!i.done;i=e.next()){var a=i.value;a.isDisposed()?this._prevTooltipDataItem=void 0:a.isHover=!1}}catch(t){r={error:t}}finally{try{i&&!i.done&&(s=e.return)&&s.call(e)}finally{if(r)throw r.error}}var r,s},e.prototype.shouldCreateBullet=function(t,e){var i=e.xField;y.hasValue(i)||(i=this.xField);var a=e.yField;return y.hasValue(a)||(a=this.yField),!(this.xAxis instanceof l.a&&!t.hasValue([i])||this.yAxis instanceof l.a&&!t.hasValue([a]))},e.prototype.positionBullet=function(e){t.prototype.positionBullet.call(this,e);var i=e.dataItem,a=e.xField;y.hasValue(a)||(a=this.xField);var n=e.yField;if(y.hasValue(n)||(n=this.yField),this.xAxis instanceof l.a&&!i.hasValue([a])||this.yAxis instanceof l.a&&!i.hasValue([n]))e.visible=!1;else{var r=this.getBulletLocationX(e,a),s=this.getBulletLocationY(e,n),o=this.getPoint(i,a,n,r,s);if(o){var h=o.x,u=o.y;if(y.isNumber(e.locationX)&&this.xOpenField!=this.xField)h-=(h-this.xAxis.getX(i,this.xOpenField))*e.locationX;if(y.isNumber(e.locationY)&&this.yOpenField!=this.yField)u-=(u-this.yAxis.getY(i,this.yOpenField))*e.locationY;e.moveTo({x:h,y:u}),e.visible=!0}else e.visible=!1}},e.prototype.getBulletLocationX=function(t,e){var i=t.locationX,a=t.dataItem;return y.isNumber(i)||(i=a.workingLocations[e]),i},e.prototype.getBulletLocationY=function(t,e){var i=t.locationY,a=t.dataItem;return y.isNumber(i)||(i=a.workingLocations[e]),i},Object.defineProperty(e.prototype,\"stacked\",{get:function(){return this.getPropertyValue(\"stacked\")},set:function(t){this.setPropertyValue(\"stacked\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"snapTooltip\",{get:function(){return this.getPropertyValue(\"snapTooltip\")},set:function(t){this.setPropertyValue(\"snapTooltip\",t)},enumerable:!0,configurable:!0}),e.prototype.show=function(e){var i,a=this;this.xAxis instanceof l.a&&this.xAxis!=this.baseAxis&&(i=this._xValueFields),this.yAxis instanceof l.a&&this.yAxis!=this.baseAxis&&(i=this._yValueFields);var n,r=this.startIndex,s=this.endIndex,o=0,h=this.defaultState.transitionDuration;y.isNumber(e)&&(h=e),g.each(g.indexed(this.dataItems.iterator()),function(t){var e=t[0],l=t[1];a.sequencedInterpolation&&h>0&&(o=a.sequencedInterpolationDelay*e+h*(e-r)/(s-r)),n=l.show(h,o,i)});var u=t.prototype.show.call(this,e);return n&&!n.isFinished()&&(u=n),u},e.prototype.hide=function(e){var i,a,n=this,r=this.xAxis;r instanceof l.a&&r!=this.baseAxis&&(i=this._xValueFields,a=this.stacked||r.minZoomed<0&&r.maxZoomed>0||this.stackedSeries?0:r.min);var s=this.yAxis;s instanceof l.a&&s!=this.baseAxis&&(i=this._yValueFields,a=this.stacked||s.minZoomed<0&&s.maxZoomed>0||this.stackedSeries?0:s.min);var o=this.startIndex,h=this.endIndex,u=this.hiddenState.transitionDuration;y.isNumber(e)&&(u=e);var c,d=0;g.each(g.indexed(this.dataItems.iterator()),function(t){var e=t[0],r=t[1];0==u?r.hide(0,0,a,i):(n.sequencedInterpolation&&u>0&&(d=n.sequencedInterpolationDelay*e+u*(e-o)/(h-o)),c=r.hide(u,d,a,i))});var p=t.prototype.hide.call(this,u);return p&&!p.isFinished()&&p.delay(d),c&&!c.isFinished()&&(p=c),this.validateDataElements(),p},e.prototype.handleDataItemWorkingValueChange=function(e,i){t.prototype.handleDataItemWorkingValueChange.call(this,e,i);var a=this.baseAxis.series;g.each(a.iterator(),function(t){t.stacked&&t.invalidateProcessedData()})},e.prototype.getStackValue=function(t,e){var i=this;if(this.stacked){var a,n=this.chart,r=n.series.indexOf(this);this.xAxis!=this.baseAxis&&this.xAxis instanceof l.a&&(a=this.xField),this.yAxis!=this.baseAxis&&this.yAxis instanceof l.a&&(a=this.yField),t.setCalculatedValue(a,0,\"stack\"),g.eachContinue(n.series.range(0,r).backwards().iterator(),function(n){if(n.xAxis==i.xAxis&&n.yAxis==i.yAxis){n.stackedSeries=i;var r=n.dataItems.getIndex(t.index);if(r&&r.hasValue(i._xValueFields)&&r.hasValue(i._yValueFields)){var s=t.getValue(a),o=void 0;if(o=e?r.getWorkingValue(a)+r.getValue(a,\"stack\"):r.getValue(a)+r.getValue(a,\"stack\"),s>=0&&o>=0||s<0&&o<0)return t.setCalculatedValue(a,o,\"stack\"),!1}else if(!n.stacked)return!1}return!0})}},Object.defineProperty(e.prototype,\"xField\",{get:function(){return this._xField},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"yField\",{get:function(){return this._yField},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"xOpenField\",{get:function(){return this._xOpenField},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"yOpenField\",{get:function(){return this._yOpenField},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"tooltipXField\",{get:function(){return this._tooltipXField?this._tooltipXField:this._xField},set:function(t){this._tooltipXField=t},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"tooltipYField\",{get:function(){return this._tooltipYField?this._tooltipYField:this._yField},set:function(t){this._tooltipYField=t},enumerable:!0,configurable:!0}),e.prototype.min=function(t){return this._tmin.getKey(t.uid)},e.prototype.max=function(t){return this._tmax.getKey(t.uid)},e.prototype.selectionMin=function(t){var e=this._smin.getKey(t.uid);return y.isNumber(e)||(e=this.min(t)),e},e.prototype.selectionMax=function(t){var e=this._smax.getKey(t.uid);return y.isNumber(e)||(e=this.max(t)),e},e.prototype.processConfig=function(e){if(e){if(y.hasValue(e.xAxis)&&y.isString(e.xAxis)&&(this.map.hasKey(e.xAxis)?e.xAxis=this.map.getKey(e.xAxis):(this.processingErrors.push(\"[XYSeries (\"+(this.name||\"unnamed\")+')] No axis with id \"'+e.xAxis+'\" found for `xAxis`.'),delete e.xAxis)),y.hasValue(e.yAxis)&&y.isString(e.yAxis)&&(this.map.hasKey(e.yAxis)?e.yAxis=this.map.getKey(e.yAxis):(this.processingErrors.push(\"[XYSeries (\"+(this.name||\"unnamed\")+')] No axis with id \"'+e.yAxis+'\" found for `yAxis`.'),delete e.yAxis)),y.hasValue(e.axisRanges)&&y.isArray(e.axisRanges))for(var i=0,a=e.axisRanges.length;i<a;i++){var n=e.axisRanges[i];y.hasValue(n.type)||(n.type=\"AxisDataItem\"),y.hasValue(n.axis)&&y.isString(n.axis)&&this.map.hasKey(n.axis)?n.component=this.map.getKey(n.axis):y.hasValue(n.component)&&y.isString(n.component)&&this.map.hasKey(n.component)&&(n.component=this.map.getKey(n.component))}y.hasValue(e.dataFields)&&y.isObject(e.dataFields)||this.processingErrors.push(\"`dataFields` is not set for series [\"+(this.name||\"unnamed\")+\"]\")}t.prototype.processConfig.call(this,e)},e.prototype.getPoint=function(t,e,i,a,n,r,s){var o=this.xAxis.getX(t,e,a),l=this.yAxis.getY(t,i,n);return{x:o=m.fitToRange(o,-2e4,2e4),y:l=m.fitToRange(l,-2e4,2e4)}},e.prototype.updateItemReaderText=function(){var t=\"\";f.each(this.dataFields,function(e,i){t+=\"{\"+e+\"} \"}),this.itemReaderText=t},Object.defineProperty(e.prototype,\"cursorTooltipEnabled\",{get:function(){return this.getPropertyValue(\"cursorTooltipEnabled\")},set:function(t){this.setPropertyValue(\"cursorTooltipEnabled\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"cursorHoverEnabled\",{get:function(){return this.getPropertyValue(\"cursorHoverEnabled\")},set:function(t){this.setPropertyValue(\"cursorHoverEnabled\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"excludeFromTotal\",{get:function(){return this.getPropertyValue(\"excludeFromTotal\")},set:function(t){this.setPropertyValue(\"excludeFromTotal\",t)},enumerable:!0,configurable:!0}),e}(V.a);c.b.registeredClasses.XYSeries=L,c.b.registeredClasses.XYSeriesDataItem=R;var X=i(\"zhwk\"),Y=i(\"tjMS\"),j=i(\"qCRI\"),N=function(t){function e(){var e=t.call(this)||this;e.point={x:0,y:0},e._stick=\"none\",e.className=\"Cursor\",e.width=Object(Y.c)(100),e.height=Object(Y.c)(100),e.shouldClone=!1,e.hide(0),e.trackable=!0,e.clickable=!0,e.isMeasured=!1;var i=Object(X.b)();return e._disposers.push(i.body.events.on(\"down\",e.handleCursorDown,e)),e._disposers.push(i.body.events.on(\"up\",e.handleCursorUp,e)),e._disposers.push(i.body.events.on(\"track\",e.handleCursorMove,e)),e.applyTheme(),e}return n.c(e,t),e.prototype.handleCursorMove=function(t){if(!(!this.interactionsEnabled||this.interactions.isTouchProtected&&t.touch)){if((\"zoom\"==this._generalBehavior||\"pan\"==this._generalBehavior)&&this.downPoint||Object(X.b)().isLocalElement(t.pointer,this.paper.svg,this.uid)){var e=k.documentPointToSprite(t.pointer.point,this);return\"hard\"==this._stick&&this._stickPoint&&(e=this._stickPoint),\"soft\"==this._stick&&this._stickPoint&&(this.fitsToBounds(e)||(e=this._stickPoint)),this.triggerMove(e),e}this.isHidden&&this.isHiding||this.hide()}},e.prototype.hideReal=function(e){if(\"hard\"!=this._stick&&\"soft\"!=this._stick||!this._stickPoint)return t.prototype.hideReal.call(this,e)},e.prototype.triggerMove=function(t,e){t.x=m.round(t.x,1),t.y=m.round(t.y,1),e&&(this._stick=e),\"hard\"!=e&&\"soft\"!=e||(this._stickPoint=t),this.triggerMoveReal(t)},e.prototype.triggerMoveReal=function(t){this.point.x==t.x&&this.point.y==t.y||(this.point=t,this.invalidatePosition(),this.fitsToBounds(t)?this.show(0):this.downPoint||this.hide(0),this.visible&&(this.getPositions(),this.dispatch(\"cursorpositionchanged\")))},e.prototype.triggerDown=function(t){this.triggerDownReal(t)},e.prototype.triggerDownReal=function(t){switch(this._generalBehavior){case\"zoom\":this.dispatchImmediately(\"zoomstarted\");break;case\"select\":this.dispatchImmediately(\"selectstarted\");break;case\"pan\":this.dispatchImmediately(\"panstarted\"),Object(X.b)().setGlobalStyle(j.a.grabbing)}},e.prototype.triggerUp=function(t){this.triggerUpReal(t)},e.prototype.triggerUpReal=function(t){this.updatePoint(this.upPoint);var e=Object(X.b)();if(m.getDistance(this._upPointOrig,this._downPointOrig)>e.getHitOption(this.interactions,\"hitTolerance\")){switch(this._generalBehavior){case\"zoom\":this.dispatchImmediately(\"zoomended\");break;case\"select\":this.dispatchImmediately(\"selectended\");break;case\"pan\":this.dispatchImmediately(\"panended\"),e.setGlobalStyle(j.a.default)}this.downPoint=void 0,this.updateSelection()}else this.dispatchImmediately(\"behaviorcanceled\"),e.setGlobalStyle(j.a.default),this.downPoint=void 0},e.prototype.updateSelection=function(){},e.prototype.getPositions=function(){this.xPosition=this.point.x/this.innerWidth,this.yPosition=1-this.point.y/this.innerHeight},e.prototype.handleCursorDown=function(t){if(!(!this.interactionsEnabled||this.interactions.isTouchProtected&&t.touch)&&Object(X.b)().isLocalElement(t.pointer,this.paper.svg,this.uid)){var e=k.documentPointToSprite(t.pointer.point,this);this._downPointOrig={x:e.x,y:e.y},t.event.cancelable&&this.shouldPreventGestures(t.touch)&&this.fitsToBounds(e)&&t.event.preventDefault(),this.triggerMove(e),this.triggerDown(e)}},e.prototype.shouldPreventGestures=function(t){return!0},e.prototype.updatePoint=function(t){},e.prototype.handleCursorUp=function(t){if(this.interactionsEnabled&&((\"zoom\"==this._generalBehavior||\"pan\"==this._generalBehavior)&&this.downPoint||Object(X.b)().isLocalElement(t.pointer,this.paper.svg,this.uid))){var e=k.documentPointToSprite(t.pointer.point,this);this._upPointOrig={x:e.x,y:e.y},this.triggerMove(e),this.triggerUp(e)}},Object.defineProperty(e.prototype,\"chart\",{get:function(){return this._chart},set:function(t){this._chart=t,y.hasValue(this._chart.plotContainer)&&Object(X.b)().lockElement(this._chart.plotContainer.interactions)},enumerable:!0,configurable:!0}),e}(s.a);c.b.registeredClasses.Cursor=N;var M=i(\"8ZqG\"),W=i(\"MIZb\"),B=function(t){function e(){var e=t.call(this)||this;e._lineX=new F.d,e._lineY=new F.d,e._xAxis=new F.d,e._yAxis=new F.d,e.className=\"XYCursor\",e.behavior=\"zoomX\",e.maxPanOut=.1;var i=new W.a,a=e.createChild(S.a);a.shouldClone=!1,a.fillOpacity=.2,a.fill=i.getFor(\"alternativeBackground\"),a.isMeasured=!1,a.interactionsEnabled=!1,e.selection=a,e._disposers.push(e.selection);var n=e.createChild(S.a);n.shouldClone=!1,n.stroke=i.getFor(\"grid\"),n.fill=Object(M.c)(),n.strokeDasharray=\"3,3\",n.isMeasured=!1,n.strokeOpacity=.4,n.interactionsEnabled=!1,n.y=0,e.lineX=n,e._disposers.push(e.lineX);var r=e.createChild(S.a);return r.shouldClone=!1,r.stroke=i.getFor(\"grid\"),r.fill=Object(M.c)(),r.strokeDasharray=\"3,3\",r.isMeasured=!1,r.strokeOpacity=.4,r.interactionsEnabled=!1,r.x=0,e.lineY=r,e._disposers.push(e.lineY),e.events.on(\"sizechanged\",e.updateSize,e,!1),e._disposers.push(e._lineX),e._disposers.push(e._lineY),e._disposers.push(e._xAxis),e._disposers.push(e._yAxis),e.mask=e,e.applyTheme(),e}return n.c(e,t),e.prototype.updateSize=function(){this.lineX&&(this.lineX.path=w.moveTo({x:0,y:0})+w.lineTo({x:0,y:this.innerHeight})),this.lineY&&(this.lineY.path=w.moveTo({x:0,y:0})+w.lineTo({x:this.innerWidth,y:0}))},e.prototype.updateSelection=function(){if(this._usesSelection){var t=this.downPoint;if(t){var e=this.point;this.lineX&&(e.x=this.lineX.pixelX),this.lineY&&(e.y=this.lineY.pixelY);var i=this.selection,a=Math.min(e.x,t.x),n=Math.min(e.y,t.y),r=m.round(Math.abs(t.x-e.x),this._positionPrecision),s=m.round(Math.abs(t.y-e.y),this._positionPrecision);switch(this.behavior){case\"zoomX\":n=0,s=this.pixelHeight;break;case\"zoomY\":a=0,r=this.pixelWidth;break;case\"selectX\":n=0,s=this.pixelHeight;break;case\"selectY\":a=0,r=this.pixelWidth}i.x=a,i.y=n,i.path=w.rectangle(r,s),i.validatePosition()}else this.selection.hide()}},e.prototype.fixPoint=function(t){return t.x=Math.max(0,t.x),t.y=Math.max(0,t.y),t.x=Math.min(this.pixelWidth,t.x),t.y=Math.min(this.pixelHeight,t.y),t},e.prototype.triggerMoveReal=function(e){t.prototype.triggerMoveReal.call(this,e),this.snapToSeries&&!this.snapToSeries.isHidden||this.updateLinePositions(e),this.downPoint&&m.getDistance(this.downPoint,e)>3&&\"pan\"==this._generalBehavior&&(this.getPanningRanges(),this.dispatch(\"panning\"))},e.prototype.updateLinePositions=function(t){t=this.fixPoint(this.point),this.lineX&&this.lineX.visible&&!this.xAxis&&(this.lineX.x=t.x),this.lineY&&this.lineY.visible&&!this.yAxis&&(this.lineY.y=t.y),this.updateSelection()},e.prototype.triggerDownReal=function(e){if(this.visible&&!this.isHiding)if(this.fitsToBounds(e)){this.downPoint={x:e.x,y:e.y},this.updatePoint(e),this.point.x=this.downPoint.x,this.point.y=this.downPoint.y;var i=this.selection,a=this.downPoint.x,n=this.downPoint.y;this._usesSelection&&(i.x=a,i.y=n,i.path=\"\",i.show()),t.prototype.triggerDownReal.call(this,e)}else this.downPoint=void 0;else this.downPoint=void 0},e.prototype.updatePoint=function(t){this.lineX&&(t.x=this.lineX.pixelX),this.lineY&&(t.y=this.lineY.pixelY)},e.prototype.triggerUpReal=function(e){m.getDistance(this._upPointOrig,this._downPointOrig)>Object(X.b)().getHitOption(this.interactions,\"hitTolerance\")?this.downPoint&&(this.upPoint=e,this.updatePoint(this.upPoint),this.getRanges(),\"selectX\"==this.behavior||\"selectY\"==this.behavior||\"selectXY\"==this.behavior||this.selection.hide(),t.prototype.triggerUpReal.call(this,e)):(this.selection.hide(0),\"pan\"==this._generalBehavior&&Object(X.b)().setGlobalStyle(j.a.default));this.downPoint=void 0},e.prototype.getPanningRanges=function(){var t=m.round(this.downPoint.x/this.innerWidth,5),e=m.round(this.downPoint.y/this.innerHeight,5),i=t-m.round(this.point.x/this.innerWidth,5),a=-e+m.round(this.point.y/this.innerHeight,5);this.xRange={start:i,end:1+i},this.yRange={start:a,end:1+a},\"panX\"==this.behavior&&(this.yRange.start=0,this.yRange.end=1),\"panY\"==this.behavior&&(this.xRange.start=0,this.xRange.end=1)},e.prototype.getRanges=function(){this.lineX&&(this.upPoint.x=this.lineX.pixelX),this.lineY&&(this.upPoint.y=this.lineY.pixelY),k.used(this.selection);var t=m.round(this.downPoint.x/this.innerWidth,5),e=m.round(this.upPoint.x/this.innerWidth,5),i=m.round(this.downPoint.y/this.innerHeight,5),a=m.round(this.upPoint.y/this.innerHeight,5);this.xRange={start:m.min(t,e),end:m.max(t,e)},this.yRange={start:m.min(i,a),end:m.max(i,a)}},Object.defineProperty(e.prototype,\"behavior\",{get:function(){return this.getPropertyValue(\"behavior\")},set:function(t){this.setPropertyValue(\"behavior\",t,!0),this._usesSelection=!1,-1!=t.indexOf(\"zoom\")&&(this._generalBehavior=\"zoom\",this._usesSelection=!0),-1!=t.indexOf(\"select\")&&(this._generalBehavior=\"select\",this._usesSelection=!0),-1!=t.indexOf(\"pan\")&&(this._generalBehavior=\"pan\",this._usesSelection=!1)},enumerable:!0,configurable:!0}),e.prototype.shouldPreventGestures=function(t){return!(this.interactions.isTouchProtected&&t||\"none\"==this.behavior)},Object.defineProperty(e.prototype,\"fullWidthLineX\",{get:function(){return this.getPropertyValue(\"fullWidthLineX\")},set:function(t){this.setPropertyValue(\"fullWidthLineX\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"fullWidthLineY\",{get:function(){return this.getPropertyValue(\"fullWidthLineY\")},set:function(t){this.setPropertyValue(\"fullWidthLineY\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"maxPanOut\",{get:function(){return this.getPropertyValue(\"maxPanOut\")},set:function(t){this.setPropertyValue(\"maxPanOut\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"xAxis\",{get:function(){return this._xAxis.get()},set:function(t){this._xAxis.get()!=t&&this._xAxis.set(t,new F.c([t.tooltip.events.on(\"positionchanged\",this.handleXTooltipPosition,this,!1)]))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"yAxis\",{get:function(){return this._yAxis.get()},set:function(t){this._yAxis.get()!=t&&this._yAxis.set(t,new F.c([t.tooltip.events.on(\"positionchanged\",this.handleYTooltipPosition,this,!1)]))},enumerable:!0,configurable:!0}),e.prototype.handleXTooltipPosition=function(t){var e=this.xAxis.tooltip,i=k.svgPointToSprite({x:e.pixelX,y:e.pixelY},this),a=i.x;if(this.lineX&&(this.lineX.x=a,this.fitsToBounds(i)||this.hide()),this.xAxis&&this.fullWidthLineX){var n=this.xAxis.currentItemStartPoint,r=this.xAxis.currentItemEndPoint;if(n&&r){this.lineX.x=a;var s=r.x-n.x;this.lineX.path=w.rectangle(s,this.innerHeight,-s/2)}}},e.prototype.handleYTooltipPosition=function(t){var e=this.yAxis.tooltip,i=k.svgPointToSprite({x:e.pixelX,y:e.pixelY},this),a=i.y;if(this.lineY&&(this.lineY.y=a,this.fitsToBounds(i)||this.hide()),this.yAxis&&this.fullWidthLineY){var n=this.yAxis.currentItemStartPoint,r=this.yAxis.currentItemEndPoint;if(n&&r){this.lineY.y=a;var s=r.y-n.y;this.lineY.path=w.rectangle(this.innerWidth,s,0,-s/2)}}},Object.defineProperty(e.prototype,\"lineX\",{get:function(){return this._lineX.get()},set:function(t){t?(t.setElement(this.paper.add(\"path\")),this._lineX.set(t,t.events.on(\"positionchanged\",this.updateSelection,this,!1)),t.interactionsEnabled=!1,t.parent=this):this._lineX.reset()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"lineY\",{get:function(){return this._lineY.get()},set:function(t){t?(t.setElement(this.paper.add(\"path\")),this._lineY.set(t,t.events.on(\"positionchanged\",this.updateSelection,this,!1)),t.parent=this,t.interactionsEnabled=!1):this._lineY.reset()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"selection\",{get:function(){return this._selection},set:function(t){this._selection=t,t&&(t.element=this.paper.add(\"path\"),t.parent=this)},enumerable:!0,configurable:!0}),e.prototype.processConfig=function(e){e&&(y.hasValue(e.xAxis)&&y.isString(e.xAxis)&&(this.map.hasKey(e.xAxis)?e.xAxis=this.map.getKey(e.xAxis):(this.processingErrors.push('[XYCursor] No axis with id \"'+e.xAxis+'\" found for `xAxis`'),delete e.xAxis)),y.hasValue(e.yAxis)&&y.isString(e.yAxis)&&(this.map.hasKey(e.yAxis)?e.yAxis=this.map.getKey(e.yAxis):(this.processingErrors.push('[XYCursor] No axis with id \"'+e.yAxis+'\" found for `yAxis`'),delete e.yAxis)),y.hasValue(e.snapToSeries)&&y.isString(e.snapToSeries)&&(this.map.hasKey(e.snapToSeries)?e.snapToSeries=this.map.getKey(e.snapToSeries):(this.processingErrors.push('[XYCursor] No series with id \"'+e.snapToSeries+'\" found for `series`'),delete e.snapToSeries))),t.prototype.processConfig.call(this,e)},Object.defineProperty(e.prototype,\"snapToSeries\",{get:function(){return this.getPropertyValue(\"snapToSeries\")},set:function(t){this.setPropertyValue(\"snapToSeries\",t)&&(this._snapToDisposer&&this._snapToDisposer.dispose(),t&&(this._snapToDisposer=t.events.on(\"tooltipshownat\",this.handleSnap,this,!1)))},enumerable:!0,configurable:!0}),e.prototype.handleSnap=function(){var t=this.snapToSeries,e=t.tooltipY,i=t.tooltipX;this.xAxis&&this.xAxis.renderer.opposite&&(e-=this.pixelHeight),this.point={x:i,y:e},this.getPositions();var a=i,n=e;i-=this.pixelWidth,this.yAxis&&this.yAxis.renderer.opposite&&(i+=this.pixelWidth);var r=t.tooltip,s=r.animationDuration,o=r.animationEasing;t.baseAxis==t.xAxis&&t.yAxis.showTooltipAtPosition(this.yPosition),t.baseAxis==t.yAxis&&t.xAxis.showTooltipAtPosition(this.xPosition),this.lineX.animate([{property:\"y\",to:e}],s,o),this.lineY.animate([{property:\"x\",to:i}],s,o),this.xAxis||this.lineX.animate([{property:\"x\",to:a}],s,o),this.yAxis||this.lineY.animate([{property:\"y\",to:n}],s,o)},e.prototype.dispose=function(){this.hide(0),t.prototype.dispose.call(this)},e}(N);c.b.registeredClasses.XYCursor=B;var E=i(\"BEgH\"),H=i(\"ISWh\"),z=i(\"85D4\"),U=function(t){function e(){var e=t.call(this)||this;e._chart=new F.d,e.className=\"XYChartScrollbar\";var i=new W.a;e.padding(0,0,0,0);var a=e.createChild(q);a.shouldClone=!1,a.margin(0,0,0,0),a.padding(0,0,0,0),a.interactionsEnabled=!1,e._scrollbarChart=a,e._disposers.push(e._scrollbarChart),e.minHeight=60,e.minWidth=60;var n=e.createChild(S.a);n.shouldClone=!1,n.setElement(e.paper.add(\"path\")),n.fill=i.getFor(\"background\"),n.fillOpacity=.8,n.interactionsEnabled=!1,n.isMeasured=!1,n.toBack(),e._unselectedOverlay=n,e._disposers.push(e._unselectedOverlay),a.toBack(),e.background.cornerRadius(0,0,0,0);var r=e.thumb.background;r.cornerRadius(0,0,0,0),r.fillOpacity=0,r.fill=i.getFor(\"background\");var s=r.states.getKey(\"hover\");s&&(s.properties.fillOpacity=.2);var o=r.states.getKey(\"down\");return o&&(o.properties.fillOpacity=.4),e._disposers.push(e._chart),e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"series\",{get:function(){return this._series||(this._series=new o.b,this._disposers.push(this._series.events.on(\"inserted\",this.handleSeriesAdded,this,!1)),this._disposers.push(this._series.events.on(\"removed\",this.handleSeriesRemoved,this,!1))),this._series},enumerable:!0,configurable:!0}),e.prototype.handleSeriesAdded=function(t){var e=t.newValue,i=this.scrollbarChart;i.zoomOutButton.disabled=!0,this.chart=e.chart;var a=!0,n=!0;g.each(this.series.iterator(),function(t){t!=e&&(t.xAxis==e.xAxis&&(a=!1),t.yAxis==e.yAxis&&(n=!1))});var r=new W.a,s=e.clone();if(a){var o=e.xAxis.clone();i.xAxes.moveValue(o),o.title.disabled=!0,o.rangeChangeDuration=0,o.id=e.uid,(l=o.renderer).ticks.template.disabled=!0,l.inside=!0,l.labels.template.inside=!0,l.line.strokeOpacity=0,l.minLabelPosition=.02,l.maxLabelPosition=.98,l.line.disabled=!0,l.axisFills.template.disabled=!0,l.baseGrid.disabled=!0,l.grid.template.strokeOpacity=.05,l.minWidth=void 0,l.minHeight=void 0,l.padding(0,0,0,0),l.chart=i,l.margin(0,0,0,0),l.labels.template.fillOpacity=.5,s.xAxis=o}if(n){var l,h=e.yAxis.clone();i.yAxes.moveValue(h),h.title.disabled=!0,h.rangeChangeDuration=0,(l=h.renderer).ticks.template.disabled=!0,l.inside=!0,l.labels.template.inside=!0,l.line.strokeOpacity=0,l.minLabelPosition=.02,l.maxLabelPosition=.98,l.line.disabled=!0,l.axisFills.template.disabled=!0,l.grid.template.stroke=r.getFor(\"background\"),l.baseGrid.disabled=!0,l.grid.template.strokeOpacity=.05,l.minWidth=void 0,l.minHeight=void 0,l.chart=i,l.padding(0,0,0,0),l.margin(0,0,0,0),l.labels.template.fillOpacity=.5,s.yAxis=h}s.rangeChangeDuration=0,s.interpolationDuration=0,s.defaultState.transitionDuration=0,s.showOnInit=!1,this._disposers.push(s.events.on(\"validated\",this.zoomOutAxes,this,!1)),this._disposers.push(e.events.on(\"datavalidated\",function(){s.data!=e.data&&(s.data=e.data)},void 0,!1)),s.defaultState.properties.visible=!0,s.filters.push(new z.a),i.series.push(s),this.updateByOrientation()},e.prototype.updateByOrientation=function(){var t=this;this._scrollbarChart&&(g.each(this._scrollbarChart.xAxes.iterator(),function(e){var i=e.renderer;\"vertical\"==t.orientation?(i.grid.template.disabled=!0,i.labels.template.disabled=!0,i.minGridDistance=10):(i.grid.template.disabled=!1,i.labels.template.disabled=!1,i.minGridDistance=e.clonedFrom.renderer.minGridDistance)}),g.each(this._scrollbarChart.yAxes.iterator(),function(e){var i=e.renderer;\"horizontal\"==t.orientation?(i.grid.template.disabled=!0,i.labels.template.disabled=!0,i.minGridDistance=10):(i.grid.template.disabled=!1,i.labels.template.disabled=!1,i.minGridDistance=e.clonedFrom.renderer.minGridDistance)}))},e.prototype.handleSeriesRemoved=function(t){t.oldValue.events.off(\"validated\",this.zoomOutAxes,this)},Object.defineProperty(e.prototype,\"scrollbarChart\",{get:function(){return this._scrollbarChart},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"chart\",{get:function(){return this._chart.get()},set:function(t){this._chart.get()!==t&&(this._chart.set(t,t.events.on(\"datavalidated\",this.handleDataChanged,this,!1)),this.handleDataChanged(),this._scrollbarChart.dataProvider=t)},enumerable:!0,configurable:!0}),e.prototype.handleDataChanged=function(){this.chart.data!=this.scrollbarChart.data&&(this.scrollbarChart.data=this.chart.data)},e.prototype.zoomOutAxes=function(){var t=this.scrollbarChart;g.each(t.xAxes.iterator(),function(t){t.zoom({start:0,end:1},!0,!0)}),g.each(t.yAxes.iterator(),function(t){t.zoom({start:0,end:1},!0,!0)})},e.prototype.updateThumb=function(){if(t.prototype.updateThumb.call(this),this._unselectedOverlay){var e=this.thumb,i=e.pixelX||0,a=e.pixelY||0,n=e.pixelWidth||0,r=e.pixelHeight||0,s=\"\";\"horizontal\"==this.orientation?(s=w.rectToPath({x:-1,y:0,width:i,height:r}),s+=w.rectToPath({x:i+n,y:0,width:(this.pixelWidth||0)-i-n,height:r})):(s=w.rectToPath({x:0,y:0,width:n,height:a}),s+=w.rectToPath({x:0,y:a+r,width:n,height:(this.pixelHeight||0)-a-r})),this._unselectedOverlay.path=s}},e.prototype.processConfig=function(e){if(e&&y.hasValue(e.series)&&y.isArray(e.series))for(var i=0,a=e.series.length;i<a;i++){var n=e.series[i];if(y.hasValue(n)&&y.isString(n)){if(!this.map.hasKey(n))throw Error(\"XYChartScrollbar error: Series with id `\"+n+\"` does not exist.\");e.series[i]=this.map.getKey(n)}}t.prototype.processConfig.call(this,e)},e}(H.a);c.b.registeredClasses.XYChartScrollbar=U;var K=i(\"TGuK\"),G=function(t){function e(){var e=t.call(this)||this;return e.className=\"XYChartDataItem\",e.applyTheme(),e}return n.c(e,t),e}(r.b),q=function(t){function e(){var e=t.call(this)||this;e._axisRendererX=b.a,e._axisRendererY=P.a,e._seriesPoints=[],e.className=\"XYChart\",e.maskBullets=!0,e.arrangeTooltips=!0;var i=e.chartContainer;i.layout=\"vertical\",e.padding(15,15,15,15);var a=i.createChild(s.a);a.shouldClone=!1,a.layout=\"vertical\",a.width=Object(Y.c)(100),a.zIndex=1,e.topAxesContainer=a;var n=i.createChild(s.a);n.shouldClone=!1,n.layout=\"horizontal\",n.width=Object(Y.c)(100),n.height=Object(Y.c)(100),n.zIndex=0,e.yAxesAndPlotContainer=n;var r=i.createChild(s.a);r.shouldClone=!1,r.width=Object(Y.c)(100),r.layout=\"vertical\",r.zIndex=1,e.bottomAxesContainer=r;var o=n.createChild(s.a);o.shouldClone=!1,o.layout=\"horizontal\",o.height=Object(Y.c)(100),o.contentAlign=\"right\",o.events.on(\"transformed\",e.updateXAxesMargins,e,!1),o.zIndex=1,e.leftAxesContainer=o;var l=n.createChild(s.a);l.shouldClone=!1,l.height=Object(Y.c)(100),l.width=Object(Y.c)(100),l.background.fillOpacity=0,e.plotContainer=l,e.mouseWheelBehavior=\"none\",e._cursorContainer=l;var h=n.createChild(s.a);h.shouldClone=!1,h.layout=\"horizontal\",h.height=Object(Y.c)(100),h.zIndex=1,h.events.on(\"transformed\",e.updateXAxesMargins,e,!1),e.rightAxesContainer=h,e.seriesContainer.parent=l,e.bulletsContainer.parent=l;var u=l.createChild(E.a);return u.shouldClone=!1,u.align=\"right\",u.valign=\"top\",u.zIndex=Number.MAX_SAFE_INTEGER,u.marginTop=5,u.marginRight=5,u.hide(0),e.zoomOutButton=u,e._bulletMask=e.plotContainer,e.applyTheme(),e}return n.c(e,t),e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),this.zoomOutButton.exportable=!1,y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"X/Y chart\"))},e.prototype.draw=function(){t.prototype.draw.call(this),this.seriesContainer.toFront(),this.bulletsContainer.toFront(),this.maskBullets&&(this.bulletsContainer.mask=this._bulletMask),this.updateSeriesLegend()},e.prototype.updatePlotElements=function(){g.each(this.series.iterator(),function(t){t.invalidate()})},e.prototype.validateData=function(){0==this._parseDataFrom&&(g.each(this.xAxes.iterator(),function(t){t.dataChangeUpdate()}),g.each(this.yAxes.iterator(),function(t){t.dataChangeUpdate()}),g.each(this.series.iterator(),function(t){t.dataChangeUpdate()})),t.prototype.validateData.call(this)},e.prototype.updateXAxesMargins=function(){var t=this.leftAxesContainer.measuredWidth,e=this.rightAxesContainer.measuredWidth,i=this.bottomAxesContainer;i.paddingLeft==t&&i.paddingRight==e||(i.paddingLeft=t,i.paddingRight=e);var a=this.topAxesContainer;a.paddingLeft==t&&a.paddingRight==e||(a.paddingLeft=t,a.paddingRight=e)},e.prototype.handleXAxisChange=function(t){this.updateXAxis(t.target)},e.prototype.handleYAxisChange=function(t){this.updateYAxis(t.target)},e.prototype.processXAxis=function(t){var e=t.newValue;e.chart=this,e.renderer||(e.renderer=new this._axisRendererX,e.renderer.observe([\"opposite\",\"inside\",\"inversed\",\"minGridDistance\"],this.handleXAxisChange,this,!1)),e.axisLetter=\"X\",e.events.on(\"startendchanged\",this.handleXAxisRangeChange,this,!1),e.dataProvider=this,this.updateXAxis(e.renderer),this.processAxis(e)},e.prototype.processYAxis=function(t){var e=t.newValue;e.chart=this,e.renderer||(e.renderer=new this._axisRendererY,e.renderer.observe([\"opposite\",\"inside\",\"inversed\",\"minGridDistance\"],this.handleYAxisChange,this,!1)),e.axisLetter=\"Y\",e.events.on(\"startendchanged\",this.handleYAxisRangeChange,this,!1),e.dataProvider=this,this.updateYAxis(e.renderer),this.processAxis(e)},e.prototype.handleXAxisRangeChange=function(){var t=this.getCommonAxisRange(this.xAxes);this.scrollbarX&&this.zoomAxes(this.xAxes,t,!0),this.toggleZoomOutButton(),this.updateScrollbar(this.scrollbarX,t)},e.prototype.toggleZoomOutButton=function(){if(this.zoomOutButton){var t=!1;g.eachContinue(this.xAxes.iterator(),function(e){return 0==m.round(e.start,3)&&1==m.round(e.end,3)||(t=!0,!1)}),g.eachContinue(this.yAxes.iterator(),function(e){return 0==m.round(e.start,3)&&1==m.round(e.end,3)||(t=!0,!1)}),this.seriesAppeared||(t=!1),t?this.zoomOutButton.show():this.zoomOutButton.hide()}},e.prototype.seriesAppeared=function(){var t=!1;return g.each(this.series.iterator(),function(e){if(!e.appeared)return t=!1,!1}),t},e.prototype.handleYAxisRangeChange=function(){var t=this.getCommonAxisRange(this.yAxes);this.scrollbarY&&this.zoomAxes(this.yAxes,t,!0),this.toggleZoomOutButton(),this.updateScrollbar(this.scrollbarY,t)},e.prototype.updateScrollbar=function(t,e){t&&(t.skipRangeEvents(),t.start=e.start,t.end=e.end)},e.prototype.getCommonAxisRange=function(t){var e,i;return g.each(t.iterator(),function(t){var a=t.start,n=t.end;t.renderer.inversed&&(a=1-t.end,n=1-t.start),(!y.isNumber(e)||a<e)&&(e=a),(!y.isNumber(i)||n>i)&&(i=n)}),{start:e,end:i}},e.prototype.updateXAxis=function(t){var e=t.axis;t.opposite?(e.parent=this.topAxesContainer,e.toFront()):(e.parent=this.bottomAxesContainer,e.toBack()),e.renderer&&e.renderer.processRenderer()},e.prototype.updateYAxis=function(t){var e=t.axis;t.opposite?(e.parent=this.rightAxesContainer,e.toBack()):(e.parent=this.leftAxesContainer,e.toFront()),e.renderer&&e.renderer.processRenderer()},e.prototype.processAxis=function(t){var e=this;t instanceof T&&this._dataUsers.moveValue(t);var i=t.renderer;i.gridContainer.parent=this.plotContainer,i.gridContainer.toBack(),i.breakContainer.parent=this.plotContainer,i.breakContainer.toFront(),i.breakContainer.zIndex=10,t.addDisposer(new F.b(function(){e.dataUsers.removeValue(t)})),this.plotContainer.events.on(\"maxsizechanged\",function(){e.inited&&(t.invalidateDataItems(),e.updateSeriesMasks())},t,!1)},e.prototype.updateSeriesMasks=function(){k.isIE()&&this.series.each(function(t){var e=t.mainContainer.mask;t.mainContainer.mask=void 0,t.mainContainer.mask=e})},Object.defineProperty(e.prototype,\"xAxes\",{get:function(){return this._xAxes||(this._xAxes=new o.b,this._xAxes.events.on(\"inserted\",this.processXAxis,this,!1),this._xAxes.events.on(\"removed\",this.handleAxisRemoval,this,!1)),this._xAxes},enumerable:!0,configurable:!0}),e.prototype.handleAxisRemoval=function(t){var e=t.oldValue;this.dataUsers.removeValue(e),e.autoDispose&&e.dispose()},Object.defineProperty(e.prototype,\"yAxes\",{get:function(){return this._yAxes||(this._yAxes=new o.b,this._yAxes.events.on(\"inserted\",this.processYAxis,this,!1),this._yAxes.events.on(\"removed\",this.handleAxisRemoval,this,!1)),this._yAxes},enumerable:!0,configurable:!0}),e.prototype.handleSeriesAdded=function(e){try{t.prototype.handleSeriesAdded.call(this,e);var i=e.newValue;0!=this.xAxes.length&&0!=this.yAxes.length||(c.b.removeFromInvalidComponents(i),i.dataInvalid=!1),k.used(i.xAxis),k.used(i.yAxis),void 0==i.fill&&(i.fill=this.colors.next()),void 0==i.stroke&&(i.stroke=i.fill)}catch(t){this.raiseCriticalError(t)}},Object.defineProperty(e.prototype,\"cursor\",{get:function(){return this._cursor},set:function(t){this._cursor!=t&&(this._cursor&&this.removeDispose(this._cursor),this._cursor=t,t&&(this._disposers.push(t),t.chart=this,t.shouldClone=!1,t.parent=this._cursorContainer,t.events.on(\"cursorpositionchanged\",this.handleCursorPositionChange,this,!1),t.events.on(\"zoomstarted\",this.handleCursorZoomStart,this,!1),t.events.on(\"zoomended\",this.handleCursorZoomEnd,this,!1),t.events.on(\"panstarted\",this.handleCursorPanStart,this,!1),t.events.on(\"panning\",this.handleCursorPanning,this,!1),t.events.on(\"panended\",this.handleCursorPanEnd,this,!1),t.events.on(\"behaviorcanceled\",this.handleCursorCanceled,this,!1),t.events.on(\"hidden\",this.handleHideCursor,this,!1),t.zIndex=Number.MAX_SAFE_INTEGER-1,this.tapToActivate&&this.setTapToActivate(this.tapToActivate)))},enumerable:!0,configurable:!0}),e.prototype.createCursor=function(){return new B},e.prototype.handleCursorPositionChange=function(){var t=this.cursor;if(t.visible&&!t.isHiding){var e=this.cursor.xPosition,i=this.cursor.yPosition;this.showSeriesTooltip({x:e,y:i});var a=void 0,n=t.snapToSeries;n&&(n.baseAxis==n.xAxis&&(a=n.yAxis),n.baseAxis==n.yAxis&&(a=n.xAxis)),this._seriesPoints=[],this.showAxisTooltip(this.xAxes,e,a),this.showAxisTooltip(this.yAxes,i,a),this.sortSeriesTooltips(this._seriesPoints)}},e.prototype.handleHideCursor=function(){this.hideObjectTooltip(this.xAxes),this.hideObjectTooltip(this.yAxes),this.hideObjectTooltip(this.series),this.updateSeriesLegend()},e.prototype.updateSeriesLegend=function(){g.each(this.series.iterator(),function(t){t.updateLegendValue()})},e.prototype.hideObjectTooltip=function(t){g.each(t.iterator(),function(t){t.hideTooltip(0)})},e.prototype.showSeriesTooltip=function(t){var e=this;if(t){var i=[];this.series.each(function(a){if(a.xAxis instanceof v&&a.xAxis.snapTooltip||a.yAxis instanceof v&&a.yAxis.snapTooltip);else{var n=a.showTooltipAtPosition(t.x,t.y);n&&(a.tooltip.setBounds({x:0,y:0,width:e.pixelWidth,height:e.pixelHeight}),i.push({series:a,point:n}))}}),this.arrangeTooltips&&this.sortSeriesTooltips(i)}else this.series.each(function(t){t.hideTooltip()})},e.prototype.sortSeriesTooltips=function(t){var e=k.spritePointToSvg({x:-.5,y:-.5},this.plotContainer),i=k.spritePointToSvg({x:this.plotContainer.pixelWidth+.5,y:this.plotContainer.pixelHeight+.5},this.plotContainer),a=0,n=[];O.each(t,function(t){var r=t.point;r&&m.isInRectangle(r,{x:e.x,y:e.y,width:i.x-e.x,height:i.y-e.y})&&(n.push({point:r,series:t.series}),a+=r.y)}),(t=n).sort(function(t,e){return t.point.y>e.point.y?1:t.point.y<e.point.y?-1:0});var r=a/t.length,s=k.svgPointToDocument({x:0,y:0},this.svgContainer.SVGContainer).y;if(t.length>0){var o=e.y,l=i.y;k.spritePointToDocument({x:0,y:o},this);var h=!1;if(r>o+(l-o)/2)for(var u=l,c=t.length-1;c>=0;c--){var d=(f=t[c].series).tooltip,p=t[c].point.y;if(d.setBounds({x:0,y:-s,width:this.pixelWidth,height:u+s}),d.invalid&&d.validate(),d.toBack(),(u=k.spritePointToSvg({x:0,y:d.label.pixelY-d.pixelY+p-d.pixelMarginTop},d).y)<-s){h=!0;break}}if(r<=o+(l-o)/2||h)for(var y=o,g=(c=0,t.length);c<g;c++){var f=t[c].series;p=t[c].point.y;(d=f.tooltip).setBounds({x:0,y:y,width:this.pixelWidth,height:l}),d.invalid&&d.validate(),d.toBack(),y=k.spritePointToSvg({x:0,y:d.label.pixelY+d.label.measuredHeight-d.pixelY+p+d.pixelMarginBottom},d).y}}},e.prototype.showAxisTooltip=function(t,e,i){var a=this;g.each(t.iterator(),function(t){t!=i&&(a.dataItems.length>0||t.dataItems.length>0)&&t.showTooltipAtPosition(e)})},e.prototype.getUpdatedRange=function(t,e){if(t){var i,a,n=t.renderer.inversed;t.renderer instanceof P.a&&(e=m.invertRange(e)),n?(m.invertRange(e),i=1-t.end,a=1-t.start):(i=t.start,a=t.end);var r=a-i;return{start:i+e.start*r,end:i+e.end*r}}},e.prototype.handleCursorZoomEnd=function(t){var e=this.cursor,i=e.behavior;if(\"zoomX\"==i||\"zoomXY\"==i){var a=e.xRange;a&&this.xAxes.length>0&&((a=this.getUpdatedRange(this.xAxes.getIndex(0),a)).priority=\"start\",this.zoomAxes(this.xAxes,a))}if(\"zoomY\"==i||\"zoomXY\"==i){var n=e.yRange;n&&this.yAxes.length>0&&((n=this.getUpdatedRange(this.yAxes.getIndex(0),n)).priority=\"start\",this.zoomAxes(this.yAxes,n))}this.handleHideCursor()},e.prototype.handleCursorPanStart=function(t){var e=this.xAxes.getIndex(0);e&&(this._panStartXRange={start:e.start,end:e.end});var i=this.yAxes.getIndex(0);i&&(this._panStartYRange={start:i.start,end:i.end})},e.prototype.handleCursorPanEnd=function(t){var e=this.cursor.behavior;if(this._panEndXRange&&(\"panX\"==e||\"panXY\"==e)){var i=0;(a=this._panEndXRange).start<0&&(i=a.start),a.end>1&&(i=a.end-1),this.zoomAxes(this.xAxes,{start:a.start-i,end:a.end-i},!1,!0),this._panEndXRange=void 0,this._panStartXRange=void 0}if(this._panEndYRange&&(\"panY\"==e||\"panXY\"==e)){var a;i=0;(a=this._panEndYRange).start<0&&(i=a.start),a.end>1&&(i=a.end-1),this.zoomAxes(this.yAxes,{start:a.start-i,end:a.end-i},!1,!0),this._panEndYRange=void 0,this._panStartYRange=void 0}},e.prototype.handleCursorCanceled=function(){this._panEndXRange=void 0,this._panStartXRange=void 0},e.prototype.handleCursorPanning=function(t){var e=this.cursor,i=e.behavior,a=e.maxPanOut;if(this._panStartXRange&&(\"panX\"==i||\"panXY\"==i)){var n=this._panStartXRange,r=e.xRange,s=this.getCommonAxisRange(this.xAxes),o=n.end-n.start,l=r.start*(s.end-s.start),h=Math.max(-a,l+n.start),u=Math.min(l+n.end,1+a);h<=0&&(u=h+o),u>=1&&(h=u-o);var c={start:h,end:u};this._panEndXRange=c,this.zoomAxes(this.xAxes,c,!1,!1,e.maxPanOut)}if(this._panStartYRange&&(\"panY\"==i||\"panXY\"==i)){n=this._panStartYRange,r=e.yRange,s=this.getCommonAxisRange(this.yAxes),o=n.end-n.start,l=r.start*(s.end-s.start),h=Math.max(-a,l+n.start),u=Math.min(l+n.end,1+a);h<=0&&(u=h+o),u>=1&&(h=u-o);c={start:h,end:u};this._panEndYRange=c,this.zoomAxes(this.yAxes,c,!1,!1,e.maxPanOut)}this.handleHideCursor()},e.prototype.handleCursorZoomStart=function(t){},Object.defineProperty(e.prototype,\"scrollbarX\",{get:function(){return this._scrollbarX},set:function(t){var e=this;this._scrollbarX&&this.removeDispose(this._scrollbarX),this._scrollbarX=t,t&&(this._disposers.push(t),t.parent=this.topAxesContainer,t.shouldClone=!1,t.startGrip.exportable=!1,t.endGrip.exportable=!1,t.toBack(),t.orientation=\"horizontal\",t.events.on(\"rangechanged\",this.handleXScrollbarChange,this,!1),t.adapter.add(\"positionValue\",function(t){var i=e.xAxes.getIndex(0);return i&&(t.value=i.getPositionLabel(t.position)),t}))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"scrollbarY\",{get:function(){return this._scrollbarY},set:function(t){var e=this;this._scrollbarY&&this.removeDispose(this._scrollbarY),this._scrollbarY=t,t&&(this._disposers.push(t),t.parent=this.rightAxesContainer,t.startGrip.exportable=!1,t.shouldClone=!1,t.endGrip.exportable=!1,t.toFront(),t.orientation=\"vertical\",t.events.on(\"rangechanged\",this.handleYScrollbarChange,this,!1),t.adapter.add(\"positionValue\",function(t){var i=e.yAxes.getIndex(0);return i&&(t.value=i.getPositionLabel(t.position)),t}))},enumerable:!0,configurable:!0}),e.prototype.handleXScrollbarChange=function(t){if(this.inited){var e=t.target,i=e.range;1==i.end&&(i.priority=\"end\"),0==i.start&&(i.priority=\"start\"),i=this.zoomAxes(this.xAxes,i),e.fixRange(i)}},e.prototype.handleYScrollbarChange=function(t){if(this.inited){var e=t.target,i=e.range;1==i.end&&(i.priority=\"end\"),0==i.start&&(i.priority=\"start\"),i=this.zoomAxes(this.yAxes,i),e.fixRange(i)}},e.prototype.zoomAxes=function(t,e,i,a,n){var r={start:0,end:1};return this.showSeriesTooltip(),this.dataInvalid||g.each(t.iterator(),function(t){t.renderer.inversed&&(e=m.invertRange(e)),t.hideTooltip(0),a&&(e.start=t.roundPosition(e.start+1e-4,0),e.end=t.roundPosition(e.end+1e-4,0));var s=t.zoom(e,i,i,n);t.renderer.inversed&&(s=m.invertRange(s)),r=s}),r},Object.defineProperty(e.prototype,\"maskBullets\",{get:function(){return this.getPropertyValue(\"maskBullets\")},set:function(t){this.setPropertyValue(\"maskBullets\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"arrangeTooltips\",{get:function(){return this.getPropertyValue(\"arrangeTooltips\")},set:function(t){this.setPropertyValue(\"arrangeTooltips\",t,!0)},enumerable:!0,configurable:!0}),e.prototype.handleWheel=function(t){var e=this.plotContainer,i=k.documentPointToSvg(t.point,this.htmlContainer,this.svgContainer.cssScale),a=k.svgPointToSprite(i,e),n=t.shift.y,r=this.getCommonAxisRange(this.xAxes),s=this.getCommonAxisRange(this.yAxes),o=this.mouseWheelBehavior;if(\"panX\"==o||\"panXY\"==o){var l=r.end-r.start,h=Math.max(-0,r.start+.05*n/100),u=Math.min(r.end+.05*n/100,1);h<=0&&(u=h+l),u>=1&&(h=u-l),this.zoomAxes(this.xAxes,{start:h,end:u})}if(\"panY\"==o||\"panXY\"==o){n*=-1;var c=s.end-s.start,d=Math.max(-0,s.start+.05*n/100),p=Math.min(s.end+.05*n/100,1);d<=0&&(p=d+c),p>=1&&(d=p-c),this.zoomAxes(this.yAxes,{start:d,end:p})}if(\"zoomX\"==o||\"zoomXY\"==o){var y=a.x/e.maxWidth;h=Math.max(-0,r.start-.05*n/100*y);h=Math.min(h,r.start+(r.end-r.start)*y-.05*.05);u=Math.min(r.end+.05*n/100*(1-y),1);u=Math.max(u,r.start+(r.end-r.start)*y+.05*.05),this.zoomAxes(this.xAxes,{start:h,end:u})}if(\"zoomY\"==o||\"zoomXY\"==o){var g=a.y/e.maxHeight;d=Math.max(-0,s.start-.05*n/100*(1-g));d=Math.min(d,s.start+(s.end-s.start)*g-.05*.05);p=Math.min(s.end+.05*n/100*g,1);p=Math.max(p,s.start+(s.end-s.start)*g+.05*.05),this.zoomAxes(this.yAxes,{start:d,end:p})}},Object.defineProperty(e.prototype,\"mouseWheelBehavior\",{get:function(){return this.getPropertyValue(\"mouseWheelBehavior\")},set:function(t){this.setPropertyValue(\"mouseWheelBehavior\",t)&&(\"none\"!=t?(this._mouseWheelDisposer=this.plotContainer.events.on(\"wheel\",this.handleWheel,this,!1),this._disposers.push(this._mouseWheelDisposer)):this._mouseWheelDisposer&&(this.plotContainer.wheelable=!1,this.plotContainer.hoverable=!1,this._mouseWheelDisposer.dispose()))},enumerable:!0,configurable:!0}),e.prototype.dataSourceDateFields=function(e){var i=this;return e=t.prototype.dataSourceDateFields.call(this,e),g.each(this.series.iterator(),function(t){e=i.populateDataSourceFields(e,t.dataFields,[\"dateX\",\"dateY\",\"openDateX\",\"openDateY\"])}),e},e.prototype.dataSourceNumberFields=function(e){var i=this;return e=t.prototype.dataSourceDateFields.call(this,e),g.each(this.series.iterator(),function(t){e=i.populateDataSourceFields(e,t.dataFields,[\"valueX\",\"valueY\",\"openValueX\",\"openValueY\"])}),e},e.prototype.processConfig=function(e){if(e){var i=[],a=[];if(y.hasValue(e.xAxes)&&y.isArray(e.xAxes))for(var n=0,r=e.xAxes.length;n<r;n++){if(!e.xAxes[n].type)throw Error(\"[XYChart error] No type set for xAxes[\"+n+\"].\");y.hasValue(e.xAxes[n].axisRanges)&&(i.push({axisRanges:e.xAxes[n].axisRanges,index:n}),delete e.xAxes[n].axisRanges)}if(y.hasValue(e.yAxes)&&y.isArray(e.yAxes))for(n=0,r=e.yAxes.length;n<r;n++){if(!e.yAxes[n].type)throw Error(\"[XYChart error] No type set for yAxes[\"+n+\"].\");y.hasValue(e.yAxes[n].axisRanges)&&(a.push({axisRanges:e.yAxes[n].axisRanges,index:n}),delete e.yAxes[n].axisRanges)}if(y.hasValue(e.series)&&y.isArray(e.series))for(n=0,r=e.series.length;n<r;n++)e.series[n].type=e.series[n].type||\"LineSeries\";if(y.hasValue(e.cursor)&&!y.hasValue(e.cursor.type)&&(e.cursor.type=\"XYCursor\"),y.hasValue(e.scrollbarX)&&!y.hasValue(e.scrollbarX.type)&&(e.scrollbarX.type=\"Scrollbar\"),y.hasValue(e.scrollbarY)&&!y.hasValue(e.scrollbarY.type)&&(e.scrollbarY.type=\"Scrollbar\"),t.prototype.processConfig.call(this,e),a.length)for(n=0,r=a.length;n<r;n++)this.yAxes.getIndex(a[n].index).config={axisRanges:a[n].axisRanges};if(i.length)for(n=0,r=i.length;n<r;n++)this.xAxes.getIndex(i[n].index).config={axisRanges:i[n].axisRanges}}},e.prototype.configOrder=function(e,i){return e==i?0:\"scrollbarX\"==e?1:\"scrollbarX\"==i?-1:\"scrollbarY\"==e?1:\"scrollbarY\"==i?-1:\"cursor\"==e?1:\"cursor\"==i?-1:\"series\"==e?1:\"series\"==i?-1:t.prototype.configOrder.call(this,e,i)},e.prototype.createSeries=function(){return new L},Object.defineProperty(e.prototype,\"zoomOutButton\",{get:function(){return this._zoomOutButton},set:function(t){var e=this;this._zoomOutButton=t,t&&t.events.on(\"hit\",function(){e.zoomAxes(e.xAxes,{start:0,end:1}),e.zoomAxes(e.yAxes,{start:0,end:1})},void 0,!1)},enumerable:!0,configurable:!0}),e.prototype.copyFrom=function(e){var i=this;e.xAxes.each(function(t){i.xAxes.push(t.clone())}),e.yAxes.each(function(t){i.yAxes.push(t.clone())}),t.prototype.copyFrom.call(this,e),e.cursor&&(this.cursor=e.cursor.clone()),e.scrollbarX&&(this.scrollbarX=e.scrollbarX.clone()),e.scrollbarY&&(this.scrollbarY=e.scrollbarY.clone())},e.prototype.disposeData=function(){t.prototype.disposeData.call(this);var e=this.scrollbarX;e&&e instanceof U&&e.scrollbarChart.disposeData();var i=this.scrollbarY;i&&i instanceof U&&i.scrollbarChart.disposeData(),this.xAxes.each(function(t){t.disposeData()}),this.yAxes.each(function(t){t.disposeData()})},e.prototype.addData=function(e,i){this.scrollbarX instanceof U&&this.addScrollbarData(this.scrollbarX,i),this.scrollbarY instanceof U&&this.addScrollbarData(this.scrollbarY,i),t.prototype.addData.call(this,e,i)},e.prototype.addScrollbarData=function(t,e){var i=t.scrollbarChart;i._parseDataFrom=i.data.length,i.invalidateData()},e.prototype.removeScrollbarData=function(t,e){var i=t.scrollbarChart;if(y.isNumber(e)){for(;e>0;){var a=this.dataItems.getIndex(0);a&&i.dataItems.remove(a),i.dataUsers.each(function(t){var e=t.dataItems.getIndex(0);e&&t.dataItems.remove(e)}),i._parseDataFrom--,e--}i.invalidateData()}},e.prototype.removeData=function(e){this.scrollbarX instanceof U&&this.removeScrollbarData(this.scrollbarX,e),this.scrollbarY instanceof U&&this.removeScrollbarData(this.scrollbarY,e),t.prototype.removeData.call(this,e)},e.prototype.setTapToActivate=function(e){t.prototype.setTapToActivate.call(this,e),this.cursor&&(this.cursor.interactions.isTouchProtected=e,this.plotContainer.interactions.isTouchProtected=e)},e.prototype.handleTapToActivate=function(){t.prototype.handleTapToActivate.call(this),this.cursor&&(this.cursor.interactions.isTouchProtected=!1,this.plotContainer.interactions.isTouchProtected=!1)},e.prototype.handleTapToActivateDeactivation=function(){t.prototype.handleTapToActivateDeactivation.call(this),this.cursor&&(this.cursor.interactions.isTouchProtected=!0,this.plotContainer.interactions.isTouchProtected=!0)},e}(r.a);c.b.registeredClasses.XYChart=q,K.c.push({relevant:K.b.maybeXS,state:function(t,e){if(t instanceof q&&t.scrollbarX){var i=t.states.create(e);return t.scrollbarX.states.create(e).properties.disabled=!0,i}return null}}),K.c.push({relevant:K.b.maybeXS,state:function(t,e){if(t instanceof q&&t.scrollbarY){var i=t.states.create(e);return t.scrollbarY.states.create(e).properties.disabled=!0,i}return null}});var Z=i(\"aFzC\"),J=function(t){function e(){var e=t.call(this)||this;e.className=\"LineSeriesSegment\",e.isMeasured=!1,e.interactionsEnabled=!1,e.layout=\"none\";var i=e.createChild(S.a);e.fillSprite=i,i.shouldClone=!1,i.setElement(e.paper.add(\"path\")),i.isMeasured=!1,e._disposers.push(i);var a=e.createChild(S.a);return e.strokeSprite=a,a.shouldClone=!1,a.fill=Object(M.c)(),a.setElement(e.paper.add(\"path\")),a.isMeasured=!1,e._disposers.push(a),e}return n.c(e,t),e.prototype.drawSegment=function(t,e,i,a){if(!this.disabled)if(t.length>0&&e.length>0){var n=w.moveTo({x:t[0].x-.2,y:t[0].y-.2})+w.moveTo(t[0])+new Z.b(i,a).smooth(t);0==this.strokeOpacity||0==this.strokeSprite.strokeOpacity||(this.strokeSprite.path=n),(this.fillOpacity>0||this.fillSprite.fillOpacity>0)&&(n+=w.lineTo(e[0])+new Z.b(i,a).smooth(e),n+=w.lineTo(t[0]),n+=w.closePath(),this.fillSprite.path=n)}else this.fillSprite.path=\"\",this.strokeSprite.path=\"\"},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e);var i=this.strokeSprite;f.copyProperties(e,i.properties,S.b),i.events.copyFrom(e.strokeSprite.events),i.fillOpacity=0;var a=this.fillSprite;f.copyProperties(e,a.properties,S.b),a.events.copyFrom(e.fillSprite.events),a.strokeOpacity=0},e}(s.a);c.b.registeredClasses.LineSeriesSegment=J;var Q=i(\"PTiM\"),$=i(\"p9TX\"),tt=i(\"GtDR\"),et=i(\"TXRX\"),it=function(t){function e(){var e=t.call(this)||this;return e.className=\"LineSeriesDataItem\",e}return n.c(e,t),e}(R),at=function(t){function e(){var e=t.call(this)||this;return e.minDistance=.5,e.segments=new o.e(e.createSegment()),e.segments.template.applyOnClones=!0,e._disposers.push(new o.c(e.segments)),e._disposers.push(e.segments.template),e._segmentsIterator=new g.ListIterator(e.segments,function(){return e.segments.create()}),e._segmentsIterator.createNewItems=!0,e.className=\"LineSeries\",e.strokeOpacity=1,e.fillOpacity=0,e.connect=!0,e.tensionX=1,e.tensionY=1,e.autoGapCount=1.1,e.segmentsContainer=e.mainContainer.createChild(s.a),e.segmentsContainer.isMeasured=!1,e.bulletsContainer.toFront(),e.applyTheme(),e}return n.c(e,t),e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"Line Series\"))},e.prototype.createSegment=function(){return new J},e.prototype.createDataItem=function(){return new it},e.prototype.setInitialWorkingValues=function(t){var e=this._yAxis.get(),i=this._xAxis.get();if(this.appeared&&this.visible){var a=this.dataItems.getIndex(t.index-1);if(t.component=this,this.baseAxis==i&&e instanceof l.a){var n=e.minZoomed;a&&(n=a.values.valueY.workingValue),t.setWorkingValue(\"valueY\",n,0),t.setWorkingValue(\"valueY\",t.values.valueY.value),i instanceof v&&(t.setWorkingLocation(\"dateX\",t.locations.dateX-1,0),t.setWorkingLocation(\"dateX\",t.locations.dateX))}if(this.baseAxis==e&&i instanceof l.a){var r=i.minZoomed;a&&(r=a.values.valueX.workingValue),t.setWorkingValue(\"valueX\",r,0),t.setWorkingValue(\"valueX\",t.values.valueX.value),e instanceof v&&(t.setWorkingLocation(\"dateY\",t.locations.dateX-1,0),t.setWorkingLocation(\"dateY\",t.locations.dateY))}}else this.baseAxis==i&&e instanceof l.a&&(i instanceof v&&t.setWorkingLocation(\"dateX\",t.locations.dateX),i instanceof T&&t.setWorkingLocation(\"categoryX\",t.locations.categoryX)),this.baseAxis==e&&i instanceof l.a&&(e instanceof v&&t.setWorkingLocation(\"dateY\",t.locations.dateY),e instanceof T&&t.setWorkingLocation(\"categoryY\",t.locations.categoryY))},e.prototype.updateLegendValue=function(e){t.prototype.updateLegendValue.call(this,e),e&&e.segment&&(this.tooltipColorSource=e.segment)},e.prototype.validate=function(){var e=this;t.prototype.validate.call(this),this._segmentsIterator.reset(),this.openSegmentWrapper(this._adjustedStartIndex),g.each(this.axisRanges.iterator(),function(t){e.openSegmentWrapper(e._adjustedStartIndex,t)}),g.each(this._segmentsIterator.iterator(),function(t){t.__disabled=!0})},e.prototype.sliceData=function(){for(var t=this.startIndex,e=this.endIndex,i=this.startIndex-1;i>=0;i--){if((n=this.dataItems.getIndex(i))&&n.hasValue(this._xValueFields)&&n.hasValue(this._yValueFields)){t=i;break}}this._adjustedStartIndex=this.findAdjustedIndex(t,[\"stroke\",\"strokeWidth\",\"strokeDasharray\",\"strokeOpacity\",\"fill\",\"fillOpacity\",\"opacity\"]);i=this.endIndex;for(var a=this.dataItems.length;i<a;i++){var n;if((n=this.dataItems.getIndex(i))&&n.hasValue(this._xValueFields)&&n.hasValue(this._yValueFields)){e=i+1;break}}this._workingStartIndex=t,this._workingEndIndex=e},e.prototype.findAdjustedIndex=function(t,e){var i=this,a=this.propertyFields,n=t;return O.each(e,function(e){if(y.hasValue(a[e]))for(var r=n;r>=0;r--){var s=i.dataItems.getIndex(r);if(s&&y.hasValue(s.properties[e])){t>r&&(t=r);break}}}),t},e.prototype.openSegmentWrapper=function(t,e){var i={index:t,axisRange:e};do{i=this.openSegment(i.index,i.axisRange)}while(i)},e.prototype.openSegment=function(t,e){var i=!1,a=[];t=Math.min(t,this.dataItems.length);var n,r=Math.min(this._workingEndIndex,this.dataItems.length);this._workingEndIndex=Math.min(this._workingEndIndex,this.dataItems.length);var s=!1,o=this._segmentsIterator.getFirst();o.__disabled=!1,e?(o.parent=e.contents,f.copyProperties(e.contents,o,S.b)):(f.copyProperties(this,o,S.b),o.filters.clear(),o.parent=this.segmentsContainer);for(var l=t;l<r;l++){var h=this.dataItems.getIndex(l);if(h.segment=o,h.hasProperties&&(l==t?this.updateSegmentProperties(h.properties,o):s=this.updateSegmentProperties(h.properties,o,!0)),h.hasValue(this._xValueFields)&&h.hasValue(this._yValueFields))this.addPoints(a,h,this.xField,this.yField);else{if(l==t)continue;if(!this.connect){n=l;break}}if(n=l,this.baseAxis instanceof v){var u=this.dataItems.getIndex(l+1);if(u&&this.baseAxis.makeGap(u,h)){i=!0;break}}if(s)break}return this.closeSegment(o,a,t,n,e,i)},e.prototype.addPoints=function(t,e,i,a,n){var r=this.getPoint(e,i,a,e.workingLocations[i],e.workingLocations[a]);n||(e.point=r),t.push(r)},e.prototype.closeSegment=function(t,e,i,a,n,r){var s=[];if(this.dataFields[this._xOpenField]||this.dataFields[this._yOpenField]||this.stacked)for(var o=a;o>=i;o--){var l=this.dataItems.getIndex(o);l.hasValue(this._xValueFields)&&l.hasValue(this._yValueFields)&&this.addPoints(s,l,this.xOpenField,this.yOpenField,!0)}else{var h=this.baseAxis,u=e.length,c=this.xAxis,d=this.yAxis;u>0&&(h==c?(s.push({x:e[u-1].x,y:d.basePoint.y}),s.push({x:e[0].x,y:d.basePoint.y})):(s.push({x:c.basePoint.x,y:e[u-1].y}),s.push({x:c.basePoint.x,y:e[0].y})))}return this.drawSegment(t,e,s),r&&a++,a<this._workingEndIndex-1?{index:a,axisRange:n}:null},e.prototype.drawSegment=function(t,e,i){t.drawSegment(e,i,this.tensionX,this.tensionY)},e.prototype.updateSegmentProperties=function(t,e,i){var a=!1;return f.each(t,function(t,n){if(y.hasValue(n)){var r=e[t],s=void 0;r&&(s=r.toString?r.toString():r);var o=void 0;n&&(o=n.toString?n.toString():n),r==n||void 0!=s&&void 0!=o&&s==o||(i||(e[t]=n),a=!0)}}),a},Object.defineProperty(e.prototype,\"connect\",{get:function(){return this.getPropertyValue(\"connect\")},set:function(t){this.setPropertyValue(\"connect\",t)&&this.invalidate()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"tensionX\",{get:function(){return this.getPropertyValue(\"tensionX\")},set:function(t){this.setPropertyValue(\"tensionX\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"tensionY\",{get:function(){return this.getPropertyValue(\"tensionY\")},set:function(t){this.setPropertyValue(\"tensionY\",t,!0)},enumerable:!0,configurable:!0}),e.prototype.createLegendMarker=function(t){var e=this,i=t.pixelWidth,a=t.pixelHeight;t.disposeChildren();var n=t.createChild(Q.a);if(n.shouldClone=!1,f.copyProperties(this,n,S.b),n.x2=i,n.y=a/2,n.visible=!0,this.fillOpacity>0){var r=t.createChild(tt.a);f.copyProperties(this,r,S.b),r.width=i,r.height=a,r.y=0,r.strokeOpacity=0,r.visible=!0,n.y=0}var o=t.dataItem;o.color=this.stroke,o.colorOrig=this.fill,g.eachContinue(this.bullets.iterator(),function(n){if(n instanceof et.a&&!n.copyToLegendMarker)return!1;var r=!1;if(n instanceof s.a&&g.each(n.children.iterator(),function(t){if(t instanceof $.a)return r=!0,!0}),!r){var o=n.clone();return o.parent=t,o.isMeasured=!0,o.tooltipText=void 0,o.x=i/2,e.fillOpacity>0?o.y=0:o.y=a/2,o.visible=!0,y.hasValue(o.fill)||(o.fill=e.fill),y.hasValue(o.stroke)||(o.stroke=e.stroke),!1}})},e.prototype.disposeData=function(){t.prototype.disposeData.call(this),this.segments.clear()},Object.defineProperty(e.prototype,\"autoGapCount\",{get:function(){return this.getPropertyValue(\"autoGapCount\")},set:function(t){this.setPropertyValue(\"autoGapCount\",t,!0)},enumerable:!0,configurable:!0}),e}(L);c.b.registeredClasses.LineSeries=at,c.b.registeredClasses.LineSeriesDataItem=it;var nt=function(t){function e(){var e=t.call(this)||this;return e.className=\"RadarSeriesDataItem\",e.setLocation(\"dateX\",0,0),e.setLocation(\"dateY\",0,0),e.setLocation(\"categoryX\",0,0),e.setLocation(\"categoryY\",0,0),e.applyTheme(),e}return n.c(e,t),e}(it),rt=function(t){function e(){var e=t.call(this)||this;return e.className=\"RadarSeries\",e.connectEnds=!0,e.applyTheme(),e}return n.c(e,t),e.prototype.validate=function(){this.chart.invalid&&this.chart.validate(),t.prototype.validate.call(this)},e.prototype.createDataItem=function(){return new nt},e.prototype.getPoint=function(t,e,i,a,n,r,s){r||(r=\"valueX\"),s||(s=\"valueY\");var o=this.yAxis.getX(t,i,n,s),l=this.yAxis.getY(t,i,n,s),h=m.getDistance({x:o,y:l});0==h&&(h=1e-5);var u=this.xAxis.getAngle(t,e,a,r),c=this.chart.startAngle,d=this.chart.endAngle;return u<c||u>d?void 0:{x:h*m.cos(u),y:h*m.sin(u)}},e.prototype.addPoints=function(t,e,i,a,n){var r=this.getPoint(e,i,a,e.locations[i],e.locations[a]);r&&t.push(r)},e.prototype.getMaskPath=function(){var t=this.yAxis.renderer;return w.arc(t.startAngle,t.endAngle-t.startAngle,t.pixelRadius,t.pixelInnerRadius)},e.prototype.drawSegment=function(e,i,a){var n=this.yAxis.renderer;this.connectEnds&&360==Math.abs(n.endAngle-n.startAngle)&&(this.dataFields[this._xOpenField]||this.dataFields[this._yOpenField]||this.stacked)&&(i.push(i[0]),a.length>0&&a.unshift(a[a.length-1])),t.prototype.drawSegment.call(this,e,i,a)},Object.defineProperty(e.prototype,\"connectEnds\",{get:function(){return this.getPropertyValue(\"connectEnds\")},set:function(t){this.setPropertyValue(\"connectEnds\",t,!0)},enumerable:!0,configurable:!0}),e}(at);c.b.registeredClasses.RadarSeries=rt,c.b.registeredClasses.RadarSeriesDataItem=nt;var st=i(\"FzPm\"),ot=function(t){function e(){var e=t.call(this)||this;return e.className=\"RadarCursor\",e.radius=Object(Y.c)(100),e.innerRadius=Object(Y.c)(0),e.applyTheme(),e.mask=void 0,e}return n.c(e,t),e.prototype.fitsToBounds=function(t){var e=m.getDistance(t);return e<this.truePixelRadius+1&&e>this.pixelInnerRadius-1},Object.defineProperty(e.prototype,\"startAngle\",{get:function(){return this.getPropertyValue(\"startAngle\")},set:function(t){this.setPropertyValue(\"startAngle\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endAngle\",{get:function(){return this.getPropertyValue(\"endAngle\")},set:function(t){this.setPropertyValue(\"endAngle\",t,!0)},enumerable:!0,configurable:!0}),e.prototype.triggerMoveReal=function(e){this.xAxis&&(!this.xAxis||this.xAxis.cursorTooltipEnabled&&!this.xAxis.tooltip.disabled)||this.updateLineX(this.point),this.yAxis&&(!this.yAxis||this.yAxis.cursorTooltipEnabled&&!this.yAxis.tooltip.disabled)||this.updateLineY(this.point),this.updateSelection(),t.prototype.triggerMoveReal.call(this,e)},e.prototype.updateLineX=function(t){var e=this.pixelRadius,i=this.startAngle,a=this.endAngle,n=this.pixelInnerRadius;if(e>0&&y.isNumber(i)&&y.isNumber(a)&&y.isNumber(n)){var r=m.fitAngleToRange(m.getAngle(t),i,a),s=void 0;if(this.lineX&&this.lineX.visible){if(this.lineX.moveTo({x:0,y:0}),this.xAxis&&this.fullWidthLineX){var o=this.xAxis.currentItemStartPoint,l=this.xAxis.currentItemEndPoint;if(o&&l){var h=m.fitAngleToRange(m.getAngle(o),i,a),u=m.fitAngleToRange(m.getAngle(l),i,a)-h;i<a?u<0&&(u+=360):u>0&&(u-=360),r-=u/2,s=w.moveTo({x:n*m.cos(r),y:n*m.sin(r)})+w.lineTo({x:e*m.cos(r),y:e*m.sin(r)})+w.arcTo(r,u,e)+w.lineTo({x:n*m.cos(r+u),y:n*m.sin(r+u)})+w.arcTo(r+u,-u,n)}}s||(s=w.moveTo({x:n*m.cos(r),y:n*m.sin(r)})+w.lineTo({x:e*m.cos(r),y:e*m.sin(r)})),this.lineX.path=s}}},e.prototype.updateLineY=function(t){if(this.lineY&&this.lineY.visible){var e=this.startAngle,i=this.endAngle,a=this.truePixelRadius,n=m.fitToRange(m.getDistance(t),0,this.truePixelRadius);if(y.isNumber(n)&&y.isNumber(e)){this.lineY.moveTo({x:0,y:0});var r=void 0,s=i-e;if(this.yAxis&&this.fullWidthLineY){var o=this.yAxis.currentItemStartPoint,l=this.yAxis.currentItemEndPoint;if(o&&l){var h=m.fitToRange(m.getDistance(o),0,a);n=m.fitToRange(m.getDistance(l),0,a),r=w.moveTo({x:n*m.cos(e),y:n*m.sin(e)})+w.arcTo(e,s,n),r+=w.moveTo({x:h*m.cos(i),y:h*m.sin(i)})+w.arcTo(i,-s,h)}}r||(r=w.moveTo({x:n*m.cos(e),y:n*m.sin(e)})+w.arcTo(e,i-e,n)),this.lineY.path=r}}},e.prototype.updateSelection=function(){if(this._usesSelection){var t=this.downPoint;if(t){var e=this.point,i=this.pixelRadius,a=this.truePixelRadius,n=this.pixelInnerRadius,r=Math.min(this.startAngle,this.endAngle),s=Math.max(this.startAngle,this.endAngle),o=m.fitAngleToRange(m.getAngle(t),r,s),l=m.fitAngleToRange(m.getAngle(e),r,s),h=m.getDistance(t);if(h<a){var u=m.fitToRange(m.getDistance(e),0,a);this._prevAngle=l;var c=w.moveTo({x:0,y:0}),d=m.sin(o),p=m.cos(o),y=m.sin(l),g=m.cos(l),f=this.behavior;\"zoomX\"==f||\"selectX\"==f?c+=w.lineTo({x:i*p,y:i*d})+w.arcTo(o,l-o,i)+w.lineTo({x:n*g,y:n*y})+w.arcTo(l,o-l,n):\"zoomY\"==f||\"selectY\"==f?c=w.moveTo({x:u*m.cos(r),y:u*m.sin(r)})+w.arcTo(r,s-r,u)+w.lineTo({x:h*m.cos(s),y:h*m.sin(s)})+w.arcTo(s,r-s,h)+w.closePath():\"zoomXY\"==f&&(c=w.moveTo({x:u*m.cos(o),y:u*m.sin(o)})+w.arcTo(o,l-o,u)+w.lineTo({x:h*m.cos(l),y:h*m.sin(l)})+w.arcTo(l,o-l,h)+w.closePath()),this.selection.path=c}this.selection.moveTo({x:0,y:0})}}},e.prototype.getPositions=function(){if(this.chart){var t=this.pixelInnerRadius,e=this.truePixelRadius-t,i=this.startAngle,a=this.endAngle,n=(m.fitAngleToRange(m.getAngle(this.point),i,a)-i)/(a-i);this.xPosition=n,this.yPosition=m.fitToRange((m.getDistance(this.point)-t)/e,0,1)}},e.prototype.updatePoint=function(t){},e.prototype.handleXTooltipPosition=function(t){if(this.xAxis.cursorTooltipEnabled){var e=this.xAxis.tooltip;this.updateLineX(k.svgPointToSprite({x:e.pixelX,y:e.pixelY},this))}},e.prototype.handleYTooltipPosition=function(t){if(this.yAxis.cursorTooltipEnabled){var e=this.yAxis.tooltip;this.updateLineY(k.svgPointToSprite({x:e.pixelX,y:e.pixelY},this))}},e.prototype.updateLinePositions=function(t){},e.prototype.getRanges=function(){var t=this.downPoint;if(t){var e=this.upPoint;if(this.chart){var i=this.pixelRadius,a=this.startAngle,n=this.endAngle,r=m.fitAngleToRange(m.getAngle(t),this.startAngle,this.endAngle),s=m.fitAngleToRange(m.getAngle(e),this.startAngle,this.endAngle),o=m.fitToRange(m.getDistance(t),0,i),l=m.fitToRange(m.getDistance(e),0,i),h=0,u=1,c=0,d=1,p=this.behavior;if(\"zoomX\"==p||\"selectX\"==p||\"zoomXY\"==p||\"selectXY\"==p){var y=n-a;h=m.round((r-a)/y,5),u=m.round((s-a)/y,5)}\"zoomY\"!=p&&\"selectY\"!=p&&\"zoomXY\"!=p&&\"selectXY\"!=p||(c=m.round(o/i,5),d=m.round(l/i,5)),this.xRange={start:Math.min(h,u),end:Math.max(h,u)},this.yRange={start:Math.min(c,d),end:Math.max(c,d)},\"selectX\"==this.behavior||\"selectY\"==this.behavior||\"selectXY\"==this.behavior||this.selection.hide()}}},e.prototype.updateSize=function(){},Object.defineProperty(e.prototype,\"radius\",{get:function(){return this.getPropertyValue(\"radius\")},set:function(t){this.setPercentProperty(\"radius\",t,!1,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"pixelRadius\",{get:function(){return k.relativeRadiusToValue(this.radius,this.truePixelRadius)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"truePixelRadius\",{get:function(){return k.relativeToValue(Object(Y.c)(100),m.min(this.innerWidth/2,this.innerHeight/2))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"innerRadius\",{get:function(){return this.getPropertyValue(\"innerRadius\")},set:function(t){this.setPercentProperty(\"innerRadius\",t,!1,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"pixelInnerRadius\",{get:function(){var t=this.innerRadius;return t instanceof Y.a&&(t=Object(Y.c)(100*t.value*this.chart.innerRadiusModifyer)),k.relativeRadiusToValue(t,this.truePixelRadius)||0},enumerable:!0,configurable:!0}),e.prototype.fixPoint=function(t){return t},e}(B);c.b.registeredClasses.RadarCursor=ot;var lt=i(\"Meme\"),ht=i(\"8EhG\"),ut=function(t){function e(e){var i=t.call(this,e)||this;return i.className=\"AxisFillCircular\",i.element=i.paper.add(\"path\"),i.radius=Object(Y.c)(100),i.applyTheme(),i}return n.c(e,t),e.prototype.draw=function(){if(t.prototype.draw.call(this),this.axis){var e=this.axis.renderer;this.fillPath=e.getPositionRangePath(this.startPosition,this.endPosition,this.radius,y.hasValue(this.innerRadius)?this.innerRadius:e.innerRadius,this.cornerRadius),this.path=this.fillPath}},Object.defineProperty(e.prototype,\"innerRadius\",{get:function(){return this.getPropertyValue(\"innerRadius\")},set:function(t){this.setPercentProperty(\"innerRadius\",t,!0,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"radius\",{get:function(){return this.getPropertyValue(\"radius\")},set:function(t){this.setPercentProperty(\"radius\",t,!0,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"cornerRadius\",{get:function(){return this.getPropertyValue(\"cornerRadius\")},set:function(t){this.setPropertyValue(\"cornerRadius\",t,!0)},enumerable:!0,configurable:!0}),e}(ht.a);c.b.registeredClasses.AxisFillCircular=ut;var ct=i(\"AaJ4\"),dt=function(t){function e(){var e=t.call(this)||this;return e.className=\"GridCircular\",e.pixelPerfect=!1,e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"innerRadius\",{get:function(){return this.getPropertyValue(\"innerRadius\")},set:function(t){this.setPercentProperty(\"innerRadius\",t,!0,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"radius\",{get:function(){return this.getPropertyValue(\"radius\")},set:function(t){this.setPercentProperty(\"radius\",t,!0,!1,10,!1)},enumerable:!0,configurable:!0}),e}(ct.a);c.b.registeredClasses.GridCircular=dt;var pt=i(\"IbTV\"),yt=function(t){function e(){var e=t.call(this)||this;return e.pixelRadiusReal=0,e.layout=\"none\",e.className=\"AxisRendererCircular\",e.isMeasured=!1,e.startAngle=-90,e.endAngle=270,e.useChartAngles=!0,e.radius=Object(Y.c)(100),e.isMeasured=!1,e.grid.template.location=0,e.labels.template.location=0,e.labels.template.radius=15,e.ticks.template.location=0,e.ticks.template.pixelPerfect=!1,e.tooltipLocation=0,e.line.strokeOpacity=0,e.applyTheme(),e}return n.c(e,t),e.prototype.setAxis=function(e){var i=this;t.prototype.setAxis.call(this,e),e.isMeasured=!1;var a=e.tooltip;a.adapter.add(\"dx\",function(t,e){var a=k.svgPointToSprite({x:e.pixelX,y:e.pixelY},i);return i.pixelRadius*Math.cos(Math.atan2(a.y,a.x))-a.x}),a.adapter.add(\"dy\",function(t,e){var a=k.svgPointToSprite({x:e.pixelX,y:e.pixelY},i);return i.pixelRadius*Math.sin(Math.atan2(a.y,a.x))-a.y})},e.prototype.validate=function(){this.chart&&this.chart.invalid&&this.chart.validate(),t.prototype.validate.call(this)},Object.defineProperty(e.prototype,\"axisLength\",{get:function(){return 2*Math.PI*this.pixelRadius},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"radius\",{get:function(){return this.getPropertyValue(\"radius\")},set:function(t){this.setPercentProperty(\"radius\",t,!1,!1,10,!1)&&this.axis&&this.axis.invalidate()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"pixelRadius\",{get:function(){return k.relativeRadiusToValue(this.radius,this.pixelRadiusReal)||0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"innerRadius\",{get:function(){return this.getPropertyValue(\"innerRadius\")},set:function(t){this.setPercentProperty(\"innerRadius\",t,!1,!1,10,!1)&&this.axis&&this.axis.invalidate()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"useChartAngles\",{get:function(){return this.getPropertyValue(\"useChartAngles\")},set:function(t){this.setPropertyValue(\"useChartAngles\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"pixelInnerRadius\",{get:function(){return k.relativeRadiusToValue(this.innerRadius,this.pixelRadiusReal)||0},enumerable:!0,configurable:!0}),e.prototype.positionToPoint=function(t){var e=this.positionToCoordinate(t),i=this.startAngle+(this.endAngle-this.startAngle)*e/this.axisLength;return{x:this.pixelRadius*m.cos(i),y:this.pixelRadius*m.sin(i)}},e.prototype.positionToAngle=function(t){var e,i=this.axis,a=(this.endAngle-this.startAngle)/(i.end-i.start);return e=i.renderer.inversed?this.startAngle+(i.end-t)*a:this.startAngle+(t-i.start)*a,m.round(e,3)},e.prototype.updateAxisLine=function(){var t=this.pixelRadius,e=this.startAngle,i=this.endAngle-e;this.line.path=w.moveTo({x:t*m.cos(e),y:t*m.sin(e)})+w.arcTo(e,i,t,t)},e.prototype.updateGridElement=function(t,e,i){e+=(i-e)*t.location;var a=this.positionToPoint(e);if(t.element){var n=m.DEGREES*Math.atan2(a.y,a.x),r=k.relativeRadiusToValue(y.hasValue(t.radius)?t.radius:Object(Y.c)(100),this.pixelRadius),s=k.relativeRadiusToValue(t.innerRadius,this.pixelRadius);t.zIndex=0;var o=k.relativeRadiusToValue(y.isNumber(s)?s:this.innerRadius,this.pixelRadius,!0);t.path=w.moveTo({x:o*m.cos(n),y:o*m.sin(n)})+w.lineTo({x:r*m.cos(n),y:r*m.sin(n)})}this.toggleVisibility(t,e,0,1)},e.prototype.updateTickElement=function(t,e,i){e+=(i-e)*t.location;var a=this.positionToPoint(e);if(t.element){var n=this.pixelRadius,r=m.DEGREES*Math.atan2(a.y,a.x),s=t.length;t.inside&&(s=-s),t.zIndex=1,t.path=w.moveTo({x:n*m.cos(r),y:n*m.sin(r)})+w.lineTo({x:(n+s)*m.cos(r),y:(n+s)*m.sin(r)})}this.toggleVisibility(t,e,0,1)},e.prototype.updateLabelElement=function(t,e,i,a){y.hasValue(a)||(a=t.location),e+=(i-e)*a,t.fixPosition(this.positionToAngle(e),this.pixelRadius),t.zIndex=2,this.toggleVisibility(t,e,this.minLabelPosition,this.maxLabelPosition)},e.prototype.fitsToBounds=function(t){return!0},Object.defineProperty(e.prototype,\"startAngle\",{get:function(){return this.getPropertyValue(\"startAngle\")},set:function(t){this.setPropertyValue(\"startAngle\",t)&&(this.invalidateAxisItems(),this.axis&&this.axis.invalidateSeries())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endAngle\",{get:function(){return this.getPropertyValue(\"endAngle\")},set:function(t){this.setPropertyValue(\"endAngle\",t)&&(this.invalidateAxisItems(),this.axis&&this.axis.invalidateSeries())},enumerable:!0,configurable:!0}),e.prototype.getPositionRangePath=function(t,e,i,a,n){var r=\"\";if(y.isNumber(t)&&y.isNumber(e)){y.hasValue(i)||(i=this.radius),t=m.max(t,this.axis.start),(e=m.min(e,this.axis.end))<t&&(e=t);var s=k.relativeRadiusToValue(i,this.pixelRadius),o=k.relativeRadiusToValue(a,this.pixelRadius,!0),l=this.positionToAngle(t),h=this.positionToAngle(e)-l;r=w.arc(l,h,s,o,s,n)}return r},e.prototype.createGrid=function(){return new dt},e.prototype.createFill=function(t){return new ut(t)},e.prototype.createLabel=function(){return new pt.a},e.prototype.pointToPosition=function(t){var e=m.fitAngleToRange(m.getAngle(t),this.startAngle,this.endAngle);return this.coordinateToPosition((e-this.startAngle)/360*this.axisLength)},e}(lt.a);c.b.registeredClasses.AxisRendererCircular=yt;var gt=i(\"Vk33\"),mt=function(t){function e(){var e=t.call(this)||this;return e._chart=new F.d,e.pixelRadiusReal=0,e.className=\"AxisRendererRadial\",e.isMeasured=!1,e.startAngle=-90,e.endAngle=270,e.minGridDistance=30,e.gridType=\"circles\",e.axisAngle=-90,e.isMeasured=!1,e.layout=\"none\",e.radius=Object(Y.c)(100),e.line.strokeOpacity=0,e.labels.template.horizontalCenter=\"middle\",e._disposers.push(e._chart),e.applyTheme(),e}return n.c(e,t),e.prototype.validate=function(){this.chart&&this.chart.invalid&&this.chart.validate(),t.prototype.validate.call(this)},Object.defineProperty(e.prototype,\"axisLength\",{get:function(){return this.pixelRadius-this.pixelInnerRadius},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"radius\",{get:function(){return this.getPropertyValue(\"radius\")},set:function(t){this.setPercentProperty(\"radius\",t,!1,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"pixelRadius\",{get:function(){return k.relativeRadiusToValue(this.radius,this.pixelRadiusReal)||0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"innerRadius\",{get:function(){return this.getPropertyValue(\"innerRadius\")},set:function(t){this.setPercentProperty(\"innerRadius\",t,!1,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"pixelInnerRadius\",{get:function(){return k.relativeRadiusToValue(this.innerRadius,this.pixelRadiusReal)||0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"chart\",{get:function(){return this._chart.get()},set:function(t){this._chart.set(t,null)},enumerable:!0,configurable:!0}),e.prototype.positionToPoint=function(t){var e=m.fitToRange(this.positionToCoordinate(t),0,1/0);return{x:e*m.cos(this.axisAngle),y:e*m.sin(this.axisAngle)}},e.prototype.updateAxisLine=function(){this.line.path=w.moveTo({x:this.pixelInnerRadius*m.cos(this.axisAngle),y:this.pixelInnerRadius*m.sin(this.axisAngle)})+w.lineTo({x:this.pixelRadius*m.cos(this.axisAngle),y:this.pixelRadius*m.sin(this.axisAngle)});var t=this.axis.title;t.valign=\"none\",t.horizontalCenter=\"middle\",t.verticalCenter=\"bottom\",t.y=-this.axisLength/2;var e=90;this.opposite?this.inside||(e=-90):this.inside&&(e=-90),t.rotation=e},e.prototype.updateGridElement=function(t,e,i){e+=(i-e)*t.location;var a,n=this.positionToPoint(e),r=m.getDistance(n),s=this.startAngle,o=this.endAngle;if(y.isNumber(r)&&t.element){var l=this.chart,h=l.xAxes.getIndex(0),u=l.dataItems.length,c=l.series.getIndex(0);if(\"polygons\"==this.gridType&&u>0&&c&&h&&h instanceof T){var d=h.renderer.grid.template.location,p=h.getAngle(c.dataItems.getIndex(0),\"categoryX\",d);a=w.moveTo({x:r*m.cos(p),y:r*m.sin(p)});for(var g=l.dataItems.length,f=1;f<g;f++)p=h.getAngle(c.dataItems.getIndex(f),\"categoryX\",d),a+=w.lineTo({x:r*m.cos(p),y:r*m.sin(p)});p=h.getAngle(c.dataItems.getIndex(g-1),\"categoryX\",h.renderer.cellEndLocation),a+=w.lineTo({x:r*m.cos(p),y:r*m.sin(p)})}else a=w.moveTo({x:r*m.cos(s),y:r*m.sin(s)})+w.arcTo(s,o-s,r,r);t.path=a}this.toggleVisibility(t,e,0,1)},e.prototype.updateLabelElement=function(t,e,i,a){y.hasValue(a)||(a=t.location),e+=(i-e)*a;var n=this.positionToPoint(e);this.positionItem(t,n),this.toggleVisibility(t,e,this.minLabelPosition,this.maxLabelPosition)},e.prototype.updateBaseGridElement=function(){},e.prototype.fitsToBounds=function(t){return!0},Object.defineProperty(e.prototype,\"startAngle\",{get:function(){return this.getPropertyValue(\"startAngle\")},set:function(t){this.setPropertyValue(\"startAngle\",t)&&this.invalidateAxisItems()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endAngle\",{get:function(){return this.getPropertyValue(\"endAngle\")},set:function(t){this.setPropertyValue(\"endAngle\",t)&&this.invalidateAxisItems()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"axisAngle\",{get:function(){return this.getPropertyValue(\"axisAngle\")},set:function(t){this.setPropertyValue(\"axisAngle\",m.normalizeAngle(t)),this.invalidateAxisItems()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"gridType\",{get:function(){return this.chart.xAxes.getIndex(0)instanceof T?this.getPropertyValue(\"gridType\"):\"circles\"},set:function(t){this.setPropertyValue(\"gridType\",t,!0)},enumerable:!0,configurable:!0}),e.prototype.getPositionRangePath=function(t,e){var i,a=this.pixelInnerRadius,n=this.axisLength+a,r=m.fitToRange(this.positionToCoordinate(t),a,n),s=m.fitToRange(this.positionToCoordinate(e),a,n),o=this.startAngle,l=this.endAngle-o,h=this.chart,u=h.xAxes.getIndex(0),c=h.dataItems.length,d=h.series.getIndex(0);if(\"polygons\"==this.gridType&&c>0&&d&&u&&u instanceof T){var p=u.renderer.grid.template.location,y=u.getAngle(d.dataItems.getIndex(0),\"categoryX\",p);i=w.moveTo({x:s*m.cos(y),y:s*m.sin(y)});for(var g=h.dataItems.length,f=1;f<g;f++)y=u.getAngle(d.dataItems.getIndex(f),\"categoryX\",p),i+=w.lineTo({x:s*m.cos(y),y:s*m.sin(y)});y=u.getAngle(d.dataItems.getIndex(g-1),\"categoryX\",u.renderer.cellEndLocation),i+=w.lineTo({x:s*m.cos(y),y:s*m.sin(y)}),i+=w.moveTo({x:r*m.cos(y),y:r*m.sin(y)});for(f=g-1;f>=0;f--)y=u.getAngle(d.dataItems.getIndex(f),\"categoryX\",p),i+=w.lineTo({x:r*m.cos(y),y:r*m.sin(y)})}else i=w.arc(o,l,s,r);return i},e.prototype.updateBreakElement=function(t){var e=t.startLine,i=t.endLine,a=t.fillShape,n=t.startPoint,r=t.endPoint;e.radius=Math.abs(n.y),i.radius=Math.abs(r.y),a.radius=Math.abs(r.y),a.innerRadius=Math.abs(n.y)},e.prototype.createBreakSprites=function(t){t.startLine=new gt.a,t.endLine=new gt.a,t.fillShape=new gt.a},e.prototype.updateTooltip=function(){if(this.axis){var t=this.axisAngle;t<0&&(t+=360);var e=\"vertical\";(t>45&&t<135||t>225&&t<315)&&(e=\"horizontal\"),this.axis.updateTooltip(e,{x:-4e3,y:-4e3,width:8e3,height:8e3})}},e.prototype.updateTickElement=function(t,e){var i=this.positionToPoint(e);if(t.element){var a=m.normalizeAngle(this.axisAngle+90);a/90!=Math.round(a/90)?t.pixelPerfect=!1:t.pixelPerfect=!0;var n=-t.length;t.inside&&(n*=-1),t.path=w.moveTo({x:0,y:0})+w.lineTo({x:n*m.cos(a),y:n*m.sin(a)})}this.positionItem(t,i),this.toggleVisibility(t,e,0,1)},e.prototype.positionToCoordinate=function(t){var e,i=this.axis,a=i.axisFullLength,n=this.pixelInnerRadius;return e=i.renderer.inversed?(i.end-t)*a+n:(t-i.start)*a+n,m.round(e,1)},e.prototype.pointToPosition=function(t){var e=m.getDistance(t)-this.pixelInnerRadius;return this.coordinateToPosition(e)},e}(P.a);c.b.registeredClasses.AxisRendererRadial=mt;var ft=function(t){function e(){var e=t.call(this)||this;return e.className=\"RadarChartDataItem\",e.applyTheme(),e}return n.c(e,t),e}(G),xt=function(t){function e(){var e=t.call(this)||this;e._axisRendererX=yt,e._axisRendererY=mt,e.innerRadiusModifyer=1,e.className=\"RadarChart\",e.startAngle=-90,e.endAngle=270,e.radius=Object(Y.c)(80),e.innerRadius=0;var i=e.plotContainer.createChild(s.a);return i.shouldClone=!1,i.layout=\"absolute\",i.align=\"center\",i.valign=\"middle\",e.seriesContainer.parent=i,e.radarContainer=i,e.bulletsContainer.parent=i,e._cursorContainer=i,e._bulletMask=i.createChild(st.a),e._bulletMask.shouldClone=!1,e._bulletMask.element=e.paper.add(\"path\"),e._bulletMask.opacity=0,e.applyTheme(),e}return n.c(e,t),e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"Radar chart\"))},e.prototype.processAxis=function(e){t.prototype.processAxis.call(this,e);var i=e.renderer;i.gridContainer.parent=i,i.breakContainer.parent=i,e.parent=this.radarContainer,i.toBack()},e.prototype.handleXAxisRangeChange=function(){t.prototype.handleXAxisRangeChange.call(this),g.each(this.yAxes.iterator(),function(t){t.invalidate()})},e.prototype.handleYAxisRangeChange=function(){t.prototype.handleYAxisRangeChange.call(this),g.each(this.xAxes.iterator(),function(t){t.invalidate()})},e.prototype.createCursor=function(){return new ot},e.prototype.processConfig=function(e){if(e&&(y.hasValue(e.cursor)&&!y.hasValue(e.cursor.type)&&(e.cursor.type=\"RadarCursor\"),y.hasValue(e.series)&&y.isArray(e.series)))for(var i=0,a=e.series.length;i<a;i++)e.series[i].type=e.series[i].type||\"RadarSeries\";t.prototype.processConfig.call(this,e)},e.prototype.beforeDraw=function(){t.prototype.beforeDraw.call(this);var e=this.plotContainer,i=m.getArcRect(this.startAngle,this.endAngle,1),a={x:0,y:0,width:0,height:0},n=e.innerWidth/i.width,r=e.innerHeight/i.height,s=this.innerRadius;if(s instanceof Y.a){var o=s.value,l=Math.min(n,r);o=Math.max(l*o,l-Math.min(e.innerHeight,e.innerWidth))/l,a=m.getArcRect(this.startAngle,this.endAngle,o),this.innerRadiusModifyer=o/s.value,s=Object(Y.c)(100*o)}i=m.getCommonRectangle([i,a]);var h=Math.min(e.innerWidth/i.width,e.innerHeight/i.height),u=2*k.relativeRadiusToValue(this.radius,h)||0,c=u/2,d=this.startAngle,p=this.endAngle;this._pixelInnerRadius=k.relativeRadiusToValue(s,c),this._bulletMask.path=w.arc(d,p-d,c,this._pixelInnerRadius),g.each(this.xAxes.iterator(),function(t){t.renderer.useChartAngles&&(t.renderer.startAngle=d,t.renderer.endAngle=p),t.width=u,t.height=u,t.renderer.pixelRadiusReal=c,t.renderer.innerRadius=s}),g.each(this.yAxes.iterator(),function(t){t.renderer.startAngle=d,t.renderer.endAngle=p,t.width=u,t.height=u,t.renderer.pixelRadiusReal=c,t.renderer.innerRadius=s});var y=this.cursor;y&&(y.width=u,y.height=u,y.startAngle=d,y.endAngle=p),this.radarContainer.definedBBox={x:c*i.x,y:c*i.y,width:c*i.width,height:c*i.height},this.radarContainer.validatePosition()},e.prototype.createSeries=function(){return new rt},Object.defineProperty(e.prototype,\"startAngle\",{get:function(){return this.getPropertyValue(\"startAngle\")},set:function(t){this.setPropertyValue(\"startAngle\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endAngle\",{get:function(){return this.getPropertyValue(\"endAngle\")},set:function(t){this.setPropertyValue(\"endAngle\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"radius\",{get:function(){return this.getPropertyValue(\"radius\")},set:function(t){this.setPercentProperty(\"radius\",t,!0,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"pixelInnerRadius\",{get:function(){return this._pixelInnerRadius},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"innerRadius\",{get:function(){return this.getPropertyValue(\"innerRadius\")},set:function(t){this.setPercentProperty(\"innerRadius\",t,!0,!1,10,!1)},enumerable:!0,configurable:!0}),e.prototype.updateXAxis=function(t){t&&t.processRenderer()},e.prototype.updateYAxis=function(t){t&&t.processRenderer()},e}(q);c.b.registeredClasses.RadarChart=xt;var vt=i(\"DziZ\"),bt=function(t){function e(){var e=t.call(this)||this;e._axis=new F.d,e.className=\"ClockHand\";var i=new W.a;e.fill=i.getFor(\"alternativeBackground\"),e.stroke=e.fill;var a=new st.a;a.radius=5,e.pin=a,e.isMeasured=!1,e.startWidth=5,e.endWidth=1,e.width=Object(Y.c)(100),e.height=Object(Y.c)(100),e.radius=Object(Y.c)(100),e.innerRadius=Object(Y.c)(0);var n=new vt.a;return e.hand=n,e._disposers.push(e._axis),e.applyTheme(),e}return n.c(e,t),e.prototype.validate=function(){t.prototype.validate.call(this);var e=this.hand;e.width=this.pixelWidth;var i=Math.max(this.startWidth,this.endWidth);if(e.height=i,e.leftSide=Object(Y.c)(this.startWidth/i*100),e.rightSide=Object(Y.c)(this.endWidth/i*100),this.axis){var a=this.axis.renderer,n=k.relativeRadiusToValue(this.innerRadius,a.pixelRadius),r=k.relativeRadiusToValue(this.radius,a.pixelRadius);e.x=n,e.y=-i/2,e.width=r-n}},Object.defineProperty(e.prototype,\"pin\",{get:function(){return this._pin},set:function(t){this._pin&&this.removeDispose(this._pin),t&&(this._pin=t,t.parent=this,this._disposers.push(t))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"hand\",{get:function(){return this._hand},set:function(t){this._hand&&this.removeDispose(this._hand),t&&(this._hand=t,t.parent=this,this._disposers.push(t))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"radius\",{get:function(){return this.getPropertyValue(\"radius\")},set:function(t){this.setPercentProperty(\"radius\",t,!0,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"innerRadius\",{get:function(){return this.getPropertyValue(\"innerRadius\")},set:function(t){this.setPercentProperty(\"innerRadius\",t,!0,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"startWidth\",{get:function(){return this.getPropertyValue(\"startWidth\")},set:function(t){this.setPropertyValue(\"startWidth\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endWidth\",{get:function(){return this.getPropertyValue(\"endWidth\")},set:function(t){this.setPropertyValue(\"endWidth\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"rotationDirection\",{get:function(){return this.getPropertyValue(\"rotationDirection\")},set:function(t){this.setPropertyValue(\"rotationDirection\",t)},enumerable:!0,configurable:!0}),e.prototype.showValue=function(t,e,i){if(this._value=t,void 0!=t&&(y.isNumber(e)||(e=0),this.axis)){var a=this.axis.renderer.positionToAngle(this.axis.anyToPosition(t)),n=this.rotation;\"clockWise\"==this.rotationDirection&&a<n&&(this.rotation=n-360),\"counterClockWise\"==this.rotationDirection&&a>n&&(this.rotation=n+360),this.animate({property:\"rotation\",to:a},e,i)}},Object.defineProperty(e.prototype,\"value\",{get:function(){return this._value},set:function(t){this.showValue(t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"axis\",{get:function(){return this._axis.get()},set:function(t){if(this.axis!=t&&this._axis.set(t,new F.c([t.events.on(\"datavalidated\",this.updateValue,this,!1),t.events.on(\"datarangechanged\",this.updateValue,this,!1),t.events.on(\"dataitemsvalidated\",this.updateValue,this,!1),t.events.on(\"propertychanged\",this.invalidate,this,!1)])),t){var e=t.chart;e&&(this.rotation=e.startAngle)}this.parent=t.renderer,this.zIndex=5},enumerable:!0,configurable:!0}),e.prototype.updateValue=function(){this.value=this.value},e.prototype.processConfig=function(e){e&&y.hasValue(e.axis)&&y.isString(e.axis)&&this.map.hasKey(e.axis)&&(e.axis=this.map.getKey(e.axis)),t.prototype.processConfig.call(this,e)},e}(s.a);c.b.registeredClasses.ClockHand=bt;var Pt=function(t){function e(){var e=t.call(this)||this;return e.className=\"GaugeChartDataItem\",e.applyTheme(),e}return n.c(e,t),e}(ft),At=function(t){function e(){var e=t.call(this)||this;return e.className=\"GaugeChart\",e.startAngle=180,e.endAngle=360,e.hands=new o.e(new bt),e.hands.events.on(\"inserted\",e.processHand,e,!1),e._disposers.push(new o.c(e.hands)),e._disposers.push(e.hands.template),e.applyTheme(),e}return n.c(e,t),e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"Gauge chart\"))},e.prototype.processHand=function(t){var e=t.newValue;e.axis||(e.axis=this.xAxes.getIndex(0))},e}(xt);c.b.registeredClasses.GaugeChart=At;var Ct=i(\"quKg\"),It=i(\"Puh1\"),Dt=i(\"nPzZ\"),_t=function(t){function e(){var e=t.call(this)||this;return e.className=\"PieSeries3DDataItem\",e.values.depthValue={},e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"depthValue\",{get:function(){return this.values.depthValue.value},set:function(t){this.setValue(\"depthValue\",t)},enumerable:!0,configurable:!0}),e}(It.b),Tt=function(t){function e(){var e=t.call(this)||this;return e.className=\"PieSeries3D\",e.applyTheme(),e}return n.c(e,t),e.prototype.createDataItem=function(){return new _t},e.prototype.createSlice=function(){return new Dt.a},e.prototype.validateDataElement=function(e){var i=e.slice,a=this.depth;y.isNumber(a)||(a=this.chart.depth);var n=e.values.depthValue.percent;y.isNumber(n)||(n=100),i.depth=n*a/100;var r=this.angle;y.isNumber(r)||(r=this.chart.angle),i.angle=r,t.prototype.validateDataElement.call(this,e)},e.prototype.validate=function(){t.prototype.validate.call(this);for(var e=this._workingStartIndex;e<this._workingEndIndex;e++){var i=this.dataItems.getIndex(e).slice,a=i.startAngle;a>=-90&&a<90?i.toFront():a>=90&&i.toBack()}},Object.defineProperty(e.prototype,\"depth\",{get:function(){return this.getPropertyValue(\"depth\")},set:function(t){this.setPropertyValue(\"depth\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"angle\",{get:function(){return this.getPropertyValue(\"angle\")},set:function(t){this.setPropertyValue(\"angle\",t)},enumerable:!0,configurable:!0}),e.prototype.positionBullet=function(e){t.prototype.positionBullet.call(this,e);var i=e.dataItem.slice;e.y=e.pixelY-i.depth},e}(It.a);c.b.registeredClasses.PieSeries3D=Tt,c.b.registeredClasses.PieSeries3DDataItem=_t;var Vt=function(t){function e(){var e=t.call(this)||this;return e.className=\"PieChart3DDataItem\",e.applyTheme(),e}return n.c(e,t),e}(Ct.b),St=function(t){function e(){var e=t.call(this)||this;return e.className=\"PieChart3D\",e.depth=20,e.angle=10,e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"depth\",{get:function(){return this.getPropertyValue(\"depth\")},set:function(t){this.setPropertyValue(\"depth\",t)&&this.invalidateDataUsers()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"angle\",{get:function(){return this.getPropertyValue(\"angle\")},set:function(t){t=m.fitToRange(t,0,90),this.setPropertyValue(\"angle\",t)&&this.invalidateDataUsers()},enumerable:!0,configurable:!0}),e.prototype.createSeries=function(){return new Tt},e}(Ct.a);c.b.registeredClasses.PieChart3D=St;var Ft=i(\"DXFp\"),kt=function(t){function e(){var e=t.call(this)||this;return e.className=\"SlicedChartDataItem\",e.applyTheme(),e}return n.c(e,t),e}(Ft.b),Ot=function(t){function e(){var e=t.call(this)||this;return e.className=\"SlicedChart\",e.seriesContainer.layout=\"horizontal\",e.padding(15,15,15,15),e.applyTheme(),e}return n.c(e,t),e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"Sliced chart\"))},e.prototype.validate=function(){t.prototype.validate.call(this)},e}(Ft.a);c.b.registeredClasses.SlicedChart=Ot,c.b.registeredClasses.SlicedChartDataItem=kt;var wt=i(\"VIOb\"),Rt=i(\"wUYf\"),Lt=i(\"MlsF\"),Xt=i(\"3Cxr\"),Yt=i(\"CnhP\"),jt=i(\"uWmK\"),Nt=function(t){function e(){var e=t.call(this)||this;return e.legendSettings=new jt.c,e.className=\"FlowDiagramNode\",e.isMeasured=!1,new W.a,e.draggable=!0,e.inert=!0,e.setStateOnChildren=!0,e.events.on(\"positionchanged\",e.invalidateLinks,e,!1),e.events.on(\"sizechanged\",e.invalidateLinks,e,!1),e}return n.c(e,t),e.prototype.handleHit=function(t){this.isHidden||this.isHiding?this.show():this.hide()},e.prototype.show=function(e){var i=t.prototype.show.call(this,e);return this.outgoingDataItems.each(function(t){(!t.toNode||t.toNode&&!t.toNode.isHidden)&&t.setWorkingValue(\"value\",t.getValue(\"value\"),e)}),this.incomingDataItems.each(function(t){(!t.fromNode||t.fromNode&&!t.fromNode.isHidden)&&t.setWorkingValue(\"value\",t.getValue(\"value\"),e)}),i},e.prototype.hide=function(e){var i=t.prototype.hide.call(this,e);return this.outgoingDataItems.each(function(t){t.setWorkingValue(\"value\",0,e)}),this.incomingDataItems.each(function(t){t.setWorkingValue(\"value\",0,e)}),i},e.prototype.validate=function(){this.isDisposed()||(t.prototype.validate.call(this),this.invalidateLinks())},e.prototype.invalidateLinks=function(){var t=this;this.outgoingDataItems.each(function(e){var i=e.link;if(\"fromNode\"==i.colorMode&&(i.fill=i.dataItem.fromNode.color),\"gradient\"==i.colorMode){i.fill=i.gradient,i.stroke=i.gradient;var a=i.gradient.stops.getIndex(0);a&&(a.color=t.color,i.gradient.validate())}}),this.incomingDataItems.each(function(e){var i=e.link;if(\"toNode\"==i.colorMode&&(i.fill=i.dataItem.toNode.color),\"gradient\"==i.colorMode){i.fill=i.gradient,i.stroke=i.gradient;var a=i.gradient.stops.getIndex(1);a&&(a.color=t.color,i.gradient.validate())}})},Object.defineProperty(e.prototype,\"incomingDataItems\",{get:function(){var t=this;if(!this._incomingDataItems){var e=new o.b;e.events.on(\"inserted\",function(){\"name\"==t.chart.sortBy?t._incomingSorted=g.sort(t._incomingDataItems.iterator(),function(t,e){return Rt.order(t.fromName,e.fromName)}):\"value\"==t.chart.sortBy?t._incomingSorted=g.sort(t._incomingDataItems.iterator(),function(t,e){return Lt.b(Xt.order(t.value,e.value))}):t._incomingSorted=t._incomingDataItems.iterator()},void 0,!1),this._incomingDataItems=e}return this._incomingDataItems},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"outgoingDataItems\",{get:function(){var t=this;if(!this._outgoingDataItems){var e=new o.b;e.events.on(\"inserted\",function(){\"name\"==t.chart.sortBy?t._outgoingSorted=g.sort(t._outgoingDataItems.iterator(),function(t,e){return Rt.order(t.fromName,e.fromName)}):\"value\"==t.chart.sortBy?t._outgoingSorted=g.sort(t._outgoingDataItems.iterator(),function(t,e){return Lt.b(Xt.order(t.value,e.value))}):t._outgoingSorted=t._outgoingDataItems.iterator()},void 0,!1),this._outgoingDataItems=e}return this._outgoingDataItems},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"name\",{get:function(){return this.getPropertyValue(\"name\")},set:function(t){this.setPropertyValue(\"name\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"total\",{get:function(){return this.getPropertyValue(\"total\")},set:function(t){this.setPropertyValue(\"total\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"totalIncoming\",{get:function(){return this.getPropertyValue(\"totalIncoming\")},set:function(t){this.setPropertyValue(\"totalIncoming\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"totalOutgoing\",{get:function(){return this.getPropertyValue(\"totalOutgoing\")},set:function(t){this.setPropertyValue(\"totalOutgoing\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"color\",{get:function(){return this.getPropertyValue(\"color\")},set:function(t){this.setColorProperty(\"color\",t),this._background&&(this._background.fill=t),this.fill=t},enumerable:!0,configurable:!0}),e.prototype.createLegendMarker=function(t){var e=t.pixelWidth,i=t.pixelHeight;t.removeChildren();var a=t.createChild(Yt.a);a.shouldClone=!1,f.copyProperties(this,a,S.b),a.stroke=this.fill,a.copyFrom(this),a.padding(0,0,0,0),a.width=e,a.height=i;var n=t.dataItem;n.color=a.fill,n.colorOrig=a.fill},Object.defineProperty(e.prototype,\"legendDataItem\",{get:function(){return this._legendDataItem},set:function(t){this._legendDataItem=t,this._legendDataItem.itemContainer.deepInvalidate()},enumerable:!0,configurable:!0}),e}(s.a);c.b.registeredClasses.FlowDiagramNode=Nt;var Mt=i(\"sxA1\"),Wt=i(\"jfaP\"),Bt=function(t){function e(){var e=t.call(this)||this;e.className=\"FlowDiagramLink\";var i=new W.a;return e.maskBullets=!1,e.colorMode=\"fromNode\",e.layout=\"none\",e.isMeasured=!1,e.startAngle=0,e.endAngle=0,e.strokeOpacity=0,e.verticalCenter=\"none\",e.horizontalCenter=\"none\",e.tooltipText=\"{fromName}\u2192{toName}:{value.value}\",e.tooltipLocation=.5,e.link=e.createChild(S.a),e.link.shouldClone=!1,e.link.setElement(e.paper.add(\"path\")),e.link.isMeasured=!1,e.fillOpacity=.2,e.fill=i.getFor(\"alternativeBackground\"),e.applyTheme(),e}return n.c(e,t),e.prototype.positionBullets=function(){var t=this;g.each(this.bullets.iterator(),function(e){e.parent=t.bulletsContainer,e.maxWidth=t.maxWidth,e.maxHeight=t.maxHeight,t.positionBullet(e)})},Object.defineProperty(e.prototype,\"bulletsContainer\",{get:function(){if(!this._bulletsContainer){var t=this.createChild(s.a);t.shouldClone=!1,t.layout=\"none\",this._bulletsContainer=t}return this._bulletsContainer},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"bulletsMask\",{get:function(){if(!this._bulletsMask){var t=this.createChild(S.a);t.shouldClone=!1,t.setElement(this.paper.add(\"path\")),t.isMeasured=!1,this._bulletsMask=t}return this._bulletsMask},enumerable:!0,configurable:!0}),e.prototype.positionBullet=function(t){var e=t.locationX;y.isNumber(e)||(e=t.locationY),y.isNumber(e)||(e=.5);var i=this.middleLine.positionToPoint(e);t.moveTo(i);var a,n=t.propertyFields.rotation;t.dataItem&&(a=t.dataItem.dataContext[n]);y.isNumber(a)||(a=i.angle),t.rotation=a},Object.defineProperty(e.prototype,\"startAngle\",{get:function(){return this.getPropertyValue(\"startAngle\")},set:function(t){this.setPropertyValue(\"startAngle\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endAngle\",{get:function(){return this.getPropertyValue(\"endAngle\")},set:function(t){this.setPropertyValue(\"endAngle\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"colorMode\",{get:function(){return this.getPropertyValue(\"colorMode\")},set:function(t){if(\"gradient\"==t){var e=this.fill;this.gradient.stops.clear(),e instanceof M.a&&(this.gradient.addColor(e),this.gradient.addColor(e)),this.fill=this.gradient,this.stroke=this.gradient}this.setPropertyValue(\"colorMode\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"maskBullets\",{get:function(){return this.getPropertyValue(\"maskBullets\")},set:function(t){this.setPropertyValue(\"maskBullets\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"tooltipLocation\",{get:function(){return this.getPropertyValue(\"tooltipLocation\")},set:function(t){this.setPropertyValue(\"tooltipLocation\",t,!0)},enumerable:!0,configurable:!0}),e.prototype.setFill=function(e){t.prototype.setFill.call(this,e);var i=this._gradient;i&&e instanceof M.a&&(i.stops.clear(),i.addColor(e),i.addColor(e))},e.prototype.measureElement=function(){},Object.defineProperty(e.prototype,\"bullets\",{get:function(){var t=this;return this._bullets||(this._bullets=new o.e(new et.a),this._disposers.push(new o.c(this._bullets)),this._disposers.push(this._bullets.template),this._bullets.events.on(\"inserted\",function(e){e.newValue.events.on(\"propertychanged\",function(e){\"locationX\"!=e.property&&\"locationY\"!=e.property||t.positionBullet(e.target)},void 0,!1)},void 0,!1)),this._bullets},enumerable:!0,configurable:!0}),e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.bullets.copyFrom(e.bullets);var i=this.middleLine;i&&(i instanceof Q.a&&e.middleLine instanceof Q.a&&i.copyFrom(e.middleLine),i instanceof Wt.a&&e.middleLine instanceof Wt.a&&i.copyFrom(e.middleLine)),this.link.copyFrom(e.link)},e.prototype.getTooltipX=function(){if(this.middleLine)return this.middleLine.positionToPoint(this.tooltipLocation).x},e.prototype.getTooltipY=function(){if(this.middleLine)return this.middleLine.positionToPoint(this.tooltipLocation).y},Object.defineProperty(e.prototype,\"gradient\",{get:function(){return this._gradient||(this._gradient=new Mt.a),this._gradient},enumerable:!0,configurable:!0}),e}(s.a);c.b.registeredClasses.FlowDiagramLink=Bt;var Et=i(\"/e9j\"),Ht=i(\"DHte\"),zt=function(t){function e(){var e=t.call(this)||this;return e.className=\"FlowDiagramDataItem\",e.values.value={},e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"fromName\",{get:function(){return this.properties.fromName},set:function(t){this.setProperty(\"fromName\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"toName\",{get:function(){return this.properties.toName},set:function(t){this.setProperty(\"toName\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"color\",{get:function(){return this.properties.color},set:function(t){this.setProperty(\"color\",Object(M.e)(t))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"value\",{get:function(){return this.values.value.value},set:function(t){this.setValue(\"value\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"link\",{get:function(){var t=this;if(!this._link){var e=this.component.links.create();this._link=e,this.addSprite(e),this._disposers.push(new F.b(function(){t.component&&t.component.links.removeValue(e)}))}return this._link},enumerable:!0,configurable:!0}),e}(wt.b),Ut=function(t){function e(){var e=t.call(this)||this;e.colors=new Ht.a,e.className=\"FlowDiagram\",e.nodePadding=20,e.sortBy=\"none\",e.sequencedInterpolation=!0,e.colors.step=2,e.minNodeSize=.02;var i=e.chartContainer.createChild(s.a);i.shouldClone=!1,i.layout=\"none\",i.isMeasured=!1,e.linksContainer=i;var a=e.chartContainer.createChild(s.a);return a.shouldClone=!1,a.layout=\"none\",a.isMeasured=!1,e.nodesContainer=a,e.dataItem=e.createDataItem(),e.dataItem.component=e,e.applyTheme(),e}return n.c(e,t),e.prototype.dispose=function(){t.prototype.dispose.call(this),this.dataItem.dispose()},e.prototype.validateData=function(){var e=this;0==this._parseDataFrom&&this.nodes.clear(),this.sortNodes(),this.colors.reset(),t.prototype.validateData.call(this);var i,a,n=0,r=0;g.each(this.dataItems.iterator(),function(t){var s=t.fromName;s&&((o=e.nodes.getKey(s))||((o=e.nodes.create(s)).name=s,o.chart=e,o.dataItem=t),t.fromNode=o,t.fromNode.outgoingDataItems.push(t));var o,l=t.toName;l&&((o=e.nodes.getKey(l))||((o=e.nodes.create(l)).name=l,o.chart=e,o.dataItem=t),t.toNode=o,t.toNode.incomingDataItems.push(t));if(!t.fromNode){var h=new Et.a;h.opacities=[0,1],t.link.strokeModifier=h}if(!t.toNode){var u=new Et.a;u.opacities=[1,0],t.link.strokeModifier=u}var c=t.value;y.isNumber(c)&&(n+=c,r++,(i>c||!y.isNumber(i))&&(i=c),(a<c||!y.isNumber(a))&&(a=c))});var s=\"value\";this.dataItem.setCalculatedValue(s,a,\"high\"),this.dataItem.setCalculatedValue(s,i,\"low\"),this.dataItem.setCalculatedValue(s,n,\"sum\"),this.dataItem.setCalculatedValue(s,n/r,\"average\"),this.dataItem.setCalculatedValue(s,r,\"count\"),g.each(this.nodes.iterator(),function(t){var i=t[1];i.fill instanceof M.a&&(i.color=i.fill),void 0==i.color&&(i.color=e.colors.next()),void 0!=i.dataItem.color&&(i.color=i.dataItem.color),i.dataItem.visible||i.hide(0),e.getNodeValue(i)}),this.sortNodes(),this.feedLegend()},e.prototype.handleDataItemWorkingValueChange=function(t,e){this.invalidate()},e.prototype.sortNodes=function(){\"name\"==this.sortBy?this._sorted=this.nodes.sortedIterator():\"value\"==this.sortBy?this._sorted=g.sort(this.nodes.iterator(),function(t,e){return Lt.b(Xt.order(t[1].total,e[1].total))}):this._sorted=this.nodes.iterator()},e.prototype.getNodeValue=function(t){var e=0,i=0;g.each(t.incomingDataItems.iterator(),function(t){var i=t.getWorkingValue(\"value\");y.isNumber(i)&&(e+=i)}),g.each(t.outgoingDataItems.iterator(),function(t){var e=t.getWorkingValue(\"value\");y.isNumber(e)&&(i+=e)}),t.total=e+i,t.totalIncoming=e,t.totalOutgoing=i},e.prototype.changeSorting=function(){this.sortNodes()},e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"Flow diagram\"))},e.prototype.createDataItem=function(){return new zt},Object.defineProperty(e.prototype,\"nodePadding\",{get:function(){return this.getPropertyValue(\"nodePadding\")},set:function(t){this.setPropertyValue(\"nodePadding\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"sortBy\",{get:function(){return this.getPropertyValue(\"sortBy\")},set:function(t){this.setPropertyValue(\"sortBy\",t),this.changeSorting()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"minNodeSize\",{get:function(){return this.getPropertyValue(\"minNodeSize\")},set:function(t){this.setPropertyValue(\"minNodeSize\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"nodes\",{get:function(){if(!this._nodes){var t=this.createNode();t.events.on(\"hit\",function(t){t.target.handleHit(t)}),this._nodes=new h.c(t),this._disposers.push(new h.b(this._nodes))}return this._nodes},enumerable:!0,configurable:!0}),e.prototype.createNode=function(){var t=new Nt;return this._disposers.push(t),t},Object.defineProperty(e.prototype,\"links\",{get:function(){return this._links||(this._links=new o.e(this.createLink()),this._disposers.push(new o.c(this._links))),this._links},enumerable:!0,configurable:!0}),e.prototype.createLink=function(){var t=new Bt;return this._disposers.push(t),t},e.prototype.feedLegend=function(){var t=this.legend;if(t){var e=[];this.nodes.each(function(t,i){e.push(i)}),t.data=e,t.dataFields.name=\"name\"}},e.prototype.disposeData=function(){t.prototype.disposeData.call(this),this.nodes.clear()},e}(wt.a);c.b.registeredClasses.FlowDiagram=Ut;var Kt=function(t){function e(){var e=t.call(this)||this;e.className=\"LabelBullet\";var i=e.createChild($.a);return i.shouldClone=!1,i.verticalCenter=\"middle\",i.horizontalCenter=\"middle\",i.truncate=!0,i.hideOversized=!1,i.maxWidth=500,i.maxHeight=500,i.stroke=Object(M.c)(),i.strokeOpacity=0,i.fill=(new W.a).getFor(\"text\"),e.events.on(\"maxsizechanged\",e.handleMaxSize,e,!1),e.label=i,e.applyTheme(),e}return n.c(e,t),e.prototype.handleMaxSize=function(){this.label.maxWidth=this.maxWidth,this.label.maxHeight=this.maxHeight},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.label.copyFrom(e.label)},e}(et.a);c.b.registeredClasses.LabelBullet=Kt;var Gt=function(t){function e(){var e=t.call(this)||this;e.nextInCoord=0,e.nextOutCoord=0,e.className=\"SankeyNode\",e.width=10,e.height=10;var i=e.createChild(Kt);i.shouldClone=!1,i.locationX=1,i.locationY=.5,i.label.text=\"{name}\",i.width=150,i.height=150,i.label.horizontalCenter=\"left\",i.label.padding(0,5,0,5),e.nameLabel=i;var a=e.createChild(Kt);a.shouldClone=!1,a.label.hideOversized=!1,a.locationX=.5,a.locationY=.5,a.width=150,a.height=150,a.label.horizontalCenter=\"middle\",e.valueLabel=a;var n=e.hiddenState;return n.properties.fill=(new W.a).getFor(\"disabledBackground\"),n.properties.opacity=.5,n.properties.visible=!0,e.background.hiddenState.copyFrom(n),e}return n.c(e,t),e.prototype.invalidateLinks=function(){var e=this;t.prototype.invalidateLinks.call(this),this.nextInCoord=0,this.nextOutCoord=0;var i=this.chart;if(i){var a=i.orientation;this._incomingSorted&&g.each(this._incomingSorted,function(t){var n=t.link,r=t.getWorkingValue(\"value\");if(y.isNumber(r)){n.parent=e.chart.linksContainer;var s=void 0,o=void 0,l=void 0;if(\"horizontal\"==a?(s=e.pixelX+e.dx,o=e.nextInCoord+e.pixelY+e.dy,l=0):(o=e.pixelY+e.dy,s=e.nextInCoord+e.pixelX+e.dx,l=90),n.endX=s,n.endY=o,n.startAngle=l,n.endAngle=l,n.gradient.rotation=l,n.linkWidth=r*i.valueHeight,!t.fromNode){\"horizontal\"==a?(n.maxWidth=200,n.startX=e.pixelX+e.dx-n.maxWidth,n.startY=n.endY):(n.maxHeight=200,n.startX=n.endX,n.startY=e.pixelY+e.dy-n.maxHeight),k.used(n.gradient),n.fill=t.toNode.color;var h=n.gradient.stops.getIndex(0);h&&(\"gradient\"==n.colorMode&&(h.color=e.color),h.opacity=0,n.fill=n.gradient,n.stroke=n.gradient,n.gradient.validate())}e.nextInCoord+=n.linkWidth}}),this._outgoingSorted&&g.each(this._outgoingSorted,function(t){var i=t.link;i.parent=e.chart.linksContainer;var n=t.getWorkingValue(\"value\");if(y.isNumber(n)){var r=void 0,s=void 0,o=void 0;if(\"horizontal\"==a?(o=0,r=e.pixelX+e.pixelWidth+e.dx-1,s=e.nextOutCoord+e.pixelY+e.dy):(o=90,r=e.nextOutCoord+e.pixelX+e.dx,s=e.pixelY+e.pixelHeight+e.dy-1),i.startX=r,i.startY=s,i.startAngle=o,i.endAngle=o,i.gradient.rotation=o,i.linkWidth=n*e.chart.valueHeight,!t.toNode){\"horizontal\"==a?(i.maxWidth=200,i.endX=e.pixelX+i.maxWidth+e.dx,i.endY=i.startY):(i.maxHeight=200,i.endX=i.startX,i.endY=e.pixelY+i.maxHeight+e.dy),i.opacity=e.opacity;var l=i.gradient.stops.getIndex(1);l&&(\"gradient\"==i.colorMode&&(l.color=e.color),l.opacity=0,i.fill=i.gradient,i.stroke=i.gradient,i.gradient.validate())}e.nextOutCoord+=i.linkWidth}})}this.positionBullet(this.nameLabel),this.positionBullet(this.valueLabel)},e.prototype.positionBullet=function(t){t&&(t.x=this.measuredWidth*t.locationX,t.y=this.measuredHeight*t.locationY)},Object.defineProperty(e.prototype,\"level\",{get:function(){return this.getPropertyValue(\"level\")},set:function(t){this.setPropertyValue(\"level\",t,!0)},enumerable:!0,configurable:!0}),e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.nameLabel.copyFrom(e.nameLabel),this.valueLabel.copyFrom(e.valueLabel)},e}(Nt);c.b.registeredClasses.SankeyNode=Gt;var qt=i(\"xgTw\"),Zt=function(t){function e(){var e=t.call(this)||this;return e.className=\"SankeyLink\",new W.a,e.tension=.8,e.controlPointDistance=.2,e.startAngle=0,e.endAngle=0,e.linkWidth=0,e.startX=0,e.endX=0,e.startY=0,e.endY=0,e.middleLine=e.createChild(qt.a),e.middleLine.shouldClone=!1,e.middleLine.strokeOpacity=0,e.applyTheme(),e}return n.c(e,t),e.prototype.validate=function(){if(t.prototype.validate.call(this),!this.isTemplate){var e=this.startX,i=this.startY,a=this.endX,n=this.endY;y.isNumber(a)||(a=e),y.isNumber(n)||(n=i);var r=this.startAngle,s=this.endAngle,o=this.linkWidth,l=\"\",h=e,u=i,c=a,d=n,p=e+o*m.sin(r),g=a+o*m.sin(s),f=i+o*m.cos(r),x=n+o*m.cos(s),v=e+o/2*m.sin(r),b=a+o/2*m.sin(s),P=i+o/2*m.cos(r),A=n+o/2*m.cos(s);this.zIndex=this.zIndex||this.dataItem.index;var C=this.tension+(1-this.tension)*m.sin(r),I=this.tension+(1-this.tension)*m.cos(r);if(this.middleLine.tensionX=C,this.middleLine.tensionY=I,y.isNumber(o)&&y.isNumber(e)&&y.isNumber(a)&&y.isNumber(i)&&y.isNumber(n)){m.round(h,3)==m.round(c,3)&&(c+=.01),m.round(u,3)==m.round(d,3)&&(d+=.01),m.round(p,3)==m.round(g,3)&&(g+=.01),m.round(f,3)==m.round(x,3)&&(x+=.01);var D=Math.min(p,g,h,c),_=Math.min(f,x,u,d),T=Math.max(p,g,h,c),V=Math.max(f,x,u,d);this._bbox={x:D,y:_,width:T-D,height:V-_};var S=this.controlPointDistance,F=h+(c-h)*S*m.cos(r),k=u+(d-u)*S*m.sin(r),O=c-(c-h)*S*m.cos(s),R=d-(d-u)*S*m.sin(s),L=v+(b-v)*S*m.cos(r),X=P+(A-P)*S*m.sin(r),Y=b-(b-v)*S*m.cos(s),j=A-(A-P)*S*m.sin(s),N=m.getAngle({x:F,y:k},{x:O,y:R}),M=(o/m.cos(N)-o)/m.tan(N)*m.cos(r),W=(o/m.sin(N)-o)*m.tan(N)*m.sin(r),B=-M/2+p+(g-p)*S*m.cos(r),E=-W/2+f+(x-f)*S*m.sin(r),H=-M/2+g-(g-p)*S*m.cos(s),z=-W/2+x-(x-f)*S*m.sin(s);this.middleLine.segments=[[{x:v,y:P},{x:L,y:X},{x:Y,y:j},{x:b,y:A}]],F+=M/2,k+=W/2,O+=M/2,R+=W/2,l+=w.moveTo({x:h,y:u}),l+=new Z.b(C,I).smooth([{x:h,y:u},{x:F,y:k},{x:O,y:R},{x:c,y:d}]),l+=w.lineTo({x:g,y:x}),l+=new Z.b(C,I).smooth([{x:g,y:x},{x:H,y:z},{x:B,y:E},{x:p,y:f}]),l+=w.closePath()}this.link.path=l,this.maskBullets&&(this.bulletsMask.path=l,this.bulletsContainer.mask=this.bulletsMask),this.positionBullets()}},Object.defineProperty(e.prototype,\"startX\",{get:function(){return this.getPropertyValue(\"startX\")},set:function(t){this.setPropertyValue(\"startX\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endX\",{get:function(){return this.getPropertyValue(\"endX\")},set:function(t){this.setPropertyValue(\"endX\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"startY\",{get:function(){return this.getPropertyValue(\"startY\")},set:function(t){this.setPropertyValue(\"startY\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endY\",{get:function(){return this.getPropertyValue(\"endY\")},set:function(t){this.setPropertyValue(\"endY\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"linkWidth\",{get:function(){return this.getPropertyValue(\"linkWidth\")},set:function(t){this.setPropertyValue(\"linkWidth\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"controlPointDistance\",{get:function(){return this.getPropertyValue(\"controlPointDistance\")},set:function(t){this.setPropertyValue(\"controlPointDistance\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"tension\",{get:function(){return this.getPropertyValue(\"tension\")},set:function(t){this.setPropertyValue(\"tension\",t,!0)},enumerable:!0,configurable:!0}),e}(Bt);c.b.registeredClasses.SankeyLink=Zt;var Jt=i(\"1yyj\"),Qt=function(t){function e(){var e=t.call(this)||this;return e.className=\"SankeyDiagramDataItem\",e.applyTheme(),e}return n.c(e,t),e}(zt),$t=function(t){function e(){var e=t.call(this)||this;return e.className=\"SankeyDiagram\",e.orientation=\"horizontal\",e.nodeAlign=\"middle\",e.nodesContainer.width=Object(Y.c)(100),e.nodesContainer.height=Object(Y.c)(100),e.linksContainer.width=Object(Y.c)(100),e.linksContainer.height=Object(Y.c)(100),e.applyTheme(),e}return n.c(e,t),e.prototype.validateData=function(){var e=this;t.prototype.validateData.call(this),this._levelCount=0,this.nodes.each(function(t,i){i.level=e.getNodeLevel(i,0),e._levelCount=m.max(e._levelCount,i.level)})},e.prototype.getNodeLevel=function(t,e){var i=this,a=[e];return g.each(t.incomingDataItems.iterator(),function(t){t.fromNode&&a.push(i.getNodeLevel(t.fromNode,e+1))}),Math.max.apply(Math,n.f(a))},e.prototype.calculateValueHeight=function(){var t=this;this._levelSum={},this._levelNodesCount={},this.maxSum=0;var e,i,a=this.dataItem.values.value.sum;g.each(this._sorted,function(e){var i=e[1];t.getNodeValue(i)}),this.nodes.each(function(e,i){var n=i.level,r=Math.max(i.totalIncoming,i.totalOutgoing);r/a<t.minNodeSize&&(r=a*t.minNodeSize),y.isNumber(t._levelSum[n])?t._levelSum[n]+=r:t._levelSum[n]=r,y.isNumber(t._levelNodesCount[n])?t._levelNodesCount[n]++:t._levelNodesCount[n]=1}),e=\"horizontal\"==this.orientation?this.chartContainer.maxHeight-1:this.chartContainer.maxWidth-1,f.each(this._levelSum,function(a,n){var r=n;n=n*e/(e-(t._levelNodesCount[a]-1)*t.nodePadding),t.maxSum<n&&(t.maxSum=r,i=y.toNumber(a))}),this._maxSumLevel=i;var n=this._levelNodesCount[this._maxSumLevel],r=(e-(n-1)*this.nodePadding)/this.maxSum;if(y.isNumber(this.valueHeight)){var s=void 0;try{s=this._heightAnimation.animationOptions[0].to}catch(t){}if(s!=r){var o=this.interpolationDuration;try{o=this.nodes.template.states.getKey(\"active\").transitionDuration}catch(t){}this._heightAnimation=new Jt.a(this,{property:\"valueHeight\",from:this.valueHeight,to:r},o).start(),this._disposers.push(this._heightAnimation)}}else this.valueHeight=r},e.prototype.validate=function(){var e=this;t.prototype.validate.call(this),this.calculateValueHeight();var i=this.nodesContainer,a={},n=this._levelNodesCount[this._maxSumLevel],r=this.dataItem.values.value.sum;g.each(this._sorted,function(t){var s,o,l,h=t[1],u=h.level,c=0,d=e._levelNodesCount[u];switch(e.nodeAlign){case\"bottom\":c=(e.maxSum-e._levelSum[u])*e.valueHeight-(d-n)*e.nodePadding;break;case\"middle\":c=(e.maxSum-e._levelSum[u])*e.valueHeight/2-(d-n)*e.nodePadding/2}h.parent=i;var p=Math.max(h.totalIncoming,h.totalOutgoing);if(p/r<e.minNodeSize&&(p=r*e.minNodeSize),\"horizontal\"==e.orientation){o=(s=(e.innerWidth-h.pixelWidth)/e._levelCount)*h.level,l=a[u]||c;var y=p*e.valueHeight;h.height=y,h.minX=o,h.maxX=o,a[u]=l+y+e.nodePadding}else{s=(e.innerHeight-h.pixelHeight)/e._levelCount,o=a[u]||c,l=s*h.level;var g=p*e.valueHeight;h.width=g,h.minY=l,h.maxY=l,a[u]=o+g+e.nodePadding}h.x=o,h.y=l})},e.prototype.showReal=function(e){var i=this;if(this.interpolationDuration>0){var a=this.nodesContainer,n=0;g.each(this.links.iterator(),function(t){t.hide(0)}),g.each(this._sorted,function(t){var e,r=t[1];\"horizontal\"==i.orientation?(r.dx=-(a.pixelWidth-r.pixelWidth)/i._levelCount,e=\"dx\"):(r.dy=-(a.pixelHeight-r.pixelHeight)/i._levelCount,e=\"dy\");var s=0,o=i.interpolationDuration;i.sequencedInterpolation&&(s=i.sequencedInterpolationDelay*n+o*n/g.length(i.nodes.iterator())),r.opacity=0,r.invalidateLinks(),r.animate([{property:\"opacity\",from:0,to:1},{property:e,to:0}],i.interpolationDuration,i.interpolationEasing).delay(s),g.each(r.outgoingDataItems.iterator(),function(t){var e=t.link.show(i.interpolationDuration);e&&!e.isFinished()&&e.delay(s)}),g.each(r.incomingDataItems.iterator(),function(t){if(!t.fromNode){var e=t.link.show(i.interpolationDuration);e&&!e.isFinished()&&e.delay(s)}}),n++})}return t.prototype.showReal.call(this)},e.prototype.changeSorting=function(){var t=this;this.sortNodes();var e={};g.each(this._sorted,function(i){var a,n,r=i[1],s=r.level,o=(t.maxSum-t._levelSum[s])*t.valueHeight/2;\"horizontal\"==t.orientation?(a=\"y\",n=r.pixelHeight):(a=\"x\",n=r.pixelWidth),r.animate({property:a,to:e[s]||o},t.interpolationDuration,t.interpolationEasing),e[s]=(e[s]||o)+n+t.nodePadding,r.invalidateLinks()})},e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"Sankey diagram\"))},e.prototype.createDataItem=function(){return new Qt},Object.defineProperty(e.prototype,\"nodeAlign\",{get:function(){return this.getPropertyValue(\"nodeAlign\")},set:function(t){this.setPropertyValue(\"nodeAlign\",t),this.changeSorting()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"orientation\",{get:function(){return this.getPropertyValue(\"orientation\")},set:function(t){this.setPropertyValue(\"orientation\",t,!0);var e=this.nodes.template.nameLabel;\"vertical\"==t?(this.nodes.template.width=void 0,e.label.horizontalCenter=\"middle\",e.locationX=.5):(this.nodes.template.height=void 0,e.label.horizontalCenter=\"left\",e.locationX=1)},enumerable:!0,configurable:!0}),e.prototype.createNode=function(){var t=new Gt;return this._disposers.push(t),t},e.prototype.createLink=function(){var t=new Zt;return this._disposers.push(t),t},Object.defineProperty(e.prototype,\"valueHeight\",{get:function(){return this._valueHeight},set:function(t){t!=this._valueHeight&&(this._valueHeight=t,this.invalidate())},enumerable:!0,configurable:!0}),e.prototype.disposeData=function(){t.prototype.disposeData.call(this),this._sorted=this.nodes.iterator()},e}(Ut);c.b.registeredClasses.SankeyDiagram=$t;var te=i(\"Inf5\"),ee=function(t){function e(){var e=t.call(this)||this;e.className=\"ChordNode\";var i=e.createChild(pt.a);i.location=.5,i.radius=5,i.text=\"{name}\",i.zIndex=1,i.shouldClone=!1,e.label=i,e.layout=\"none\",e.events.on(\"positionchanged\",e.updateRotation,e,!1),e.isMeasured=!1,e.slice=e.createChild(te.a),e.slice.isMeasured=!1;var a=e.hiddenState;return a.properties.fill=(new W.a).getFor(\"disabledBackground\"),a.properties.opacity=.5,a.properties.visible=!0,e.setStateOnChildren=!1,e.slice.hiddenState.properties.visible=!0,e.adapter.add(\"tooltipX\",function(t,e){return e.slice.ix*(e.slice.radius-(e.slice.radius-e.slice.pixelInnerRadius)/2)}),e.adapter.add(\"tooltipY\",function(t,e){return e.slice.iy*(e.slice.radius-(e.slice.radius-e.slice.pixelInnerRadius)/2)}),e}return n.c(e,t),e.prototype.invalidateLinks=function(){var e=this;t.prototype.invalidateLinks.call(this);var i=this.label,a=this.slice,n=this.chart;if(n&&a){var r=this.total,s=a.arc,o=a.startAngle;this.children.each(function(t){if(t instanceof et.a){var e=t.locationX;y.isNumber(e)||(e=.5);var i=t.locationY;y.isNumber(i)||(i=1);var n=o+s*e,r=i*a.radius;t.x=r*m.cos(n),t.y=r*m.sin(n)}});var l=o+s*i.location,h=o+(1-r/this.adjustedTotal)*s*.5;y.isNaN(h)&&(h=o),i.fixPosition(l,a.radius),this.nextAngle=h,this._outgoingSorted&&g.each(this._outgoingSorted,function(t){var i=t.link;i.parent=e.chart.linksContainer;var r=t.getWorkingValue(\"value\");if(y.isNumber(r)){if(n.nonRibbon){var l=i.percentWidth;y.isNumber(l)||(l=5),l/=100,i.startAngle=o+s/2-s/2*l,i.arc=s*l}else i.arc=r*n.valueAngle,i.startAngle=e.nextAngle,e.nextAngle+=i.arc;t.toNode||(i.endAngle=i.startAngle),i.radius=a.pixelInnerRadius}}),this._incomingSorted&&g.each(this._incomingSorted,function(t){var i=t.link;if(i.radius=a.pixelInnerRadius,n.nonRibbon){var r=i.percentWidth;y.isNumber(r)||(r=5),r/=100,i.endAngle=o+s/2-s/2*r,i.arc=s*r}else{i.endAngle=e.nextAngle;var l=t.getWorkingValue(\"value\");y.isNumber(l)&&(i.arc=l*n.valueAngle,e.nextAngle+=i.arc)}t.fromNode||(i.startAngle=i.endAngle)})}},e.prototype.updateRotation=function(){var t=this.slice,e=this.trueStartAngle+t.arc/2,i=t.radius,a=i*m.cos(e),n=i*m.sin(e),r=m.getAngle({x:a+this.pixelX,y:n+this.pixelY});t.startAngle=this.trueStartAngle+(r-e),this.dx=-this.pixelX,this.dy=-this.pixelY},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.label.copyFrom(e.label),this.slice.copyFrom(e.slice)},e}(Nt);c.b.registeredClasses.ChordNode=ee;var ie=function(t){function e(){var e=t.call(this)||this;return e.className=\"QuadraticCurve\",e.element=e.paper.add(\"path\"),e.pixelPerfect=!1,e.fill=Object(M.c)(),e.applyTheme(),e}return n.c(e,t),e.prototype.draw=function(){if(y.isNumber(this.x1+this.x2+this.y1+this.y2+this.cpx+this.cpy)){var t={x:this.x1,y:this.y1},e={x:this.x2,y:this.y2},i={x:this.cpx,y:this.cpy},a=w.moveTo(t)+w.quadraticCurveTo(e,i);this.path=a}},Object.defineProperty(e.prototype,\"cpx\",{get:function(){return this.getPropertyValue(\"cpx\")},set:function(t){this.setPropertyValue(\"cpx\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"cpy\",{get:function(){return this.getPropertyValue(\"cpy\")},set:function(t){this.setPropertyValue(\"cpy\",t,!0)},enumerable:!0,configurable:!0}),e.prototype.positionToPoint=function(t){var e={x:this.x1,y:this.y1},i={x:this.cpx,y:this.cpy},a={x:this.x2,y:this.y2},n=m.getPointOnQuadraticCurve(e,a,i,t),r=m.getPointOnQuadraticCurve(e,a,i,t+.001);return{x:n.x,y:n.y,angle:m.getAngle(n,r)}},e}(Q.a),ae=function(t){function e(){var e=t.call(this)||this;return e.className=\"ChordLink\",e.middleLine=e.createChild(ie),e.middleLine.shouldClone=!1,e.middleLine.strokeOpacity=0,e.applyTheme(),e}return n.c(e,t),e.prototype.validate=function(){if(t.prototype.validate.call(this),!this.isTemplate){var e=this.startAngle,i=this.endAngle,a=this.arc,n=this.radius,r=this.dataItem.fromNode,s=this.dataItem.toNode,o=0,l=0;r&&(o=r.pixelX+r.dx,l=r.pixelY+r.dy);var h=0,u=0;if(s&&(h=s.pixelX+s.dx,u=s.pixelY+s.dy),n>0){var c=n*m.cos(e)+o,d=n*m.sin(e)+l,p=n*m.cos(i)+h,y=n*m.sin(i)+u,g={x:0,y:0},f=w.moveTo({x:c,y:d});f+=w.arcTo(e,a,n),f+=w.quadraticCurveTo({x:p,y:y},g),f+=w.arcTo(i,a,n),f+=w.quadraticCurveTo({x:c,y:d},g),this.link.path=a>0?f:\"\",this.maskBullets&&(this.bulletsMask.path=f,this.bulletsContainer.mask=this.bulletsMask);var x=e+a/2,v=i+a/2,b=this.middleLine;b.x1=n*m.cos(x)+o,b.y1=n*m.sin(x)+l,b.x2=n*m.cos(v)+h,b.y2=n*m.sin(v)+u,b.cpx=0,b.cpy=0,b.stroke=this.fill,this.positionBullets()}}},Object.defineProperty(e.prototype,\"radius\",{get:function(){return this.getPropertyValue(\"radius\")},set:function(t){this.setPropertyValue(\"radius\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"arc\",{get:function(){return this.getPropertyValue(\"arc\")},set:function(t){this.setPropertyValue(\"arc\",t,!0)},enumerable:!0,configurable:!0}),e}(Bt);c.b.registeredClasses.ChordLink=ae;var ne=function(t){function e(){var e=t.call(this)||this;return e.className=\"ChordDiagramDataItem\",e.applyTheme(),e}return n.c(e,t),e}(zt),re=function(t){function e(){var e=t.call(this)||this;e.valueAngle=0,e.className=\"ChordDiagram\",e.startAngle=-90,e.endAngle=270,e.radius=Object(Y.c)(80),e.innerRadius=-15,e.nodePadding=5;var i=e.chartContainer.createChild(s.a);return i.align=\"center\",i.valign=\"middle\",i.shouldClone=!1,i.layout=\"absolute\",e.chordContainer=i,e.nodesContainer.parent=i,e.linksContainer.parent=i,e.chartContainer.events.on(\"maxsizechanged\",e.invalidate,e,!1),e.applyTheme(),e}return n.c(e,t),e.prototype.validate=function(){var e=this,i=this.chartContainer,a=this.endAngle,n=this.startAngle+this.nodePadding/2,r=m.getArcRect(this.startAngle,this.endAngle,1);r=m.getCommonRectangle([r,{x:0,y:0,width:0,height:0}]);var s=Math.min(i.innerWidth/r.width,i.innerHeight/r.height);y.isNumber(s)||(s=0);var o=k.relativeRadiusToValue(this.radius,s),l=k.relativeRadiusToValue(this.innerRadius,o,!0),h=this.dataItem.values.value.sum,u=0,c=0;g.each(this._sorted,function(t){var i=t[1];e.getNodeValue(i),u++;var a=i.total;i.total/h<e.minNodeSize&&(a=h*e.minNodeSize),c+=a}),this.valueAngle=(a-this.startAngle-this.nodePadding*u)/c,g.each(this._sorted,function(t){var i=t[1],r=i.slice;r.radius=o,r.innerRadius=l;var s,c=i.total;i.total/h<e.minNodeSize&&(c=h*e.minNodeSize),i.adjustedTotal=c,s=e.nonRibbon?(a-e.startAngle)/u-e.nodePadding:e.valueAngle*c,r.arc=s,r.startAngle=n,i.trueStartAngle=n,i.parent=e.nodesContainer,i.validate(),n+=s+e.nodePadding}),this.chordContainer.definedBBox={x:o*r.x,y:o*r.y,width:o*r.width,height:o*r.height},this.chordContainer.invalidateLayout(),t.prototype.validate.call(this)},e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"Chord diagram\"))},e.prototype.createDataItem=function(){return new ne},Object.defineProperty(e.prototype,\"startAngle\",{get:function(){return this.getPropertyValue(\"startAngle\")},set:function(t){this.setPropertyValue(\"startAngle\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endAngle\",{get:function(){return this.getPropertyValue(\"endAngle\")},set:function(t){this.setPropertyValue(\"endAngle\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"radius\",{get:function(){return this.getPropertyValue(\"radius\")},set:function(t){this.setPercentProperty(\"radius\",t,!0,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"innerRadius\",{get:function(){return this.getPropertyValue(\"innerRadius\")},set:function(t){this.setPercentProperty(\"innerRadius\",t,!0,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"nonRibbon\",{get:function(){return this.getPropertyValue(\"nonRibbon\")},set:function(t){this.setPropertyValue(\"nonRibbon\",t,!0),this.links.template.middleLine.strokeOpacity=1,this.links.template.link.fillOpacity=0},enumerable:!0,configurable:!0}),e.prototype.createNode=function(){var t=new ee;return this._disposers.push(t),t},e.prototype.createLink=function(){var t=new ae;return this._disposers.push(t),t},e}(Ut);c.b.registeredClasses.ChordDiagram=re;var se=function(t){function e(){var e=t.call(this)||this;return e.className=\"Column\",e.width=Object(Y.c)(80),e.height=Object(Y.c)(80),e.applyOnClones=!0,e.strokeOpacity=1,e.layout=\"none\",e.createAssets(),e.events.on(\"childadded\",e.handleKidAdded,e,!1),e}return n.c(e,t),e.prototype.handleKidAdded=function(){\"none\"==this.layout&&(this.layout=\"absolute\")},e.prototype.createAssets=function(){this.column=this.createChild(Yt.a),this.column.shouldClone=!1,this.column.cornerRadius(0,0,0,0),this._disposers.push(this.column)},e.prototype.validate=function(){t.prototype.validate.call(this);var e=this.column;e&&(e.width=m.min(this.pixelWidth,this.maxWidth),e.height=m.min(this.pixelHeight,this.maxHeight),e.invalid&&e.validate())},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.column&&this.column.copyFrom(e.column)},Object.defineProperty(e.prototype,\"bbox\",{get:function(){return this.definedBBox?this.definedBBox:this.column?{x:0,y:0,width:this.column.measuredWidth,height:this.column.measuredHeight}:{x:0,y:0,width:m.min(this.pixelWidth,this.maxWidth),height:m.min(this.pixelHeight,this.maxHeight)}},enumerable:!0,configurable:!0}),e}(s.a);c.b.registeredClasses.Column=se;var oe=function(t){function e(){var e=t.call(this)||this;return e.className=\"ColumnSeriesDataItem\",e.locations.dateX=.5,e.locations.dateY=.5,e.locations.categoryX=.5,e.locations.categoryY=.5,e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"column\",{get:function(){return this._column},set:function(t){this.setColumn(t)},enumerable:!0,configurable:!0}),e.prototype.setColumn=function(t){var e=this;if(this._column&&t!=this._column&&O.remove(this.sprites,this._column),this._column=t,t){var i=t.dataItem;i&&i!=this&&(i.column=void 0),this.addSprite(t),this._disposers.push(new F.b(function(){e.component&&e.component.columns.removeValue(t)}))}},Object.defineProperty(e.prototype,\"rangesColumns\",{get:function(){return this._rangesColumns||(this._rangesColumns=new h.a),this._rangesColumns},enumerable:!0,configurable:!0}),e}(R),le=function(t){function e(){var e=t.call(this)||this;e._startLocation=0,e._endLocation=1,e.className=\"ColumnSeries\",e.width=Object(Y.c)(100),e.height=Object(Y.c)(100),e.strokeOpacity=0,e.fillOpacity=1,e.clustered=!0;var i=e.mainContainer.createChild(s.a);return i.shouldClone=!1,i.isMeasured=!1,i.layout=\"none\",e._columnsContainer=i,e.columns.template.pixelPerfect=!1,e.tooltipColorSource=e.columns.template,e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"columnsContainer\",{get:function(){return this._columnsContainer},enumerable:!0,configurable:!0}),e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"Column Series\"))},e.prototype.createDataItem=function(){return new oe},e.prototype.validate=function(){var i=this,a=this.chart.series,n=0,r=0;g.each(a.iterator(),function(t){t instanceof e&&i.baseAxis==t.baseAxis&&((!t.stacked&&t.clustered||0===n)&&n++,t==i&&(r=n-1))});var s=this.baseAxis.renderer,o=s.cellStartLocation,l=s.cellEndLocation;this._startLocation=o+r/n*(l-o),this._endLocation=o+(r+1)/n*(l-o),t.prototype.validate.call(this);for(var h=0;h<this.startIndex;h++){var u=this.dataItems.getIndex(h);this.disableUnusedColumns(u)}for(h=this.dataItems.length-1;h>this.endIndex;h--){u=this.dataItems.getIndex(h);this.disableUnusedColumns(u)}},e.prototype.validateDataElement=function(e){this.validateDataElementReal(e),t.prototype.validateDataElement.call(this,e)},e.prototype.getStartLocation=function(t){var e=this._startLocation;return this.baseAxis==this.xAxis?e+=t.locations[this.xOpenField]-.5:e+=t.locations[this.yOpenField]-.5,e},e.prototype.handleDataItemWorkingValueChange=function(e,i){this.simplifiedProcessing?this.validateDataElement(e):t.prototype.handleDataItemWorkingValueChange.call(this,e,i)},e.prototype.getEndLocation=function(t){var e=this._endLocation;return this.baseAxis==this.xAxis?e+=t.locations[this.xField]-.5:e+=t.locations[this.yField]-.5,e},e.prototype.validateDataElementReal=function(t){var e,i,a,n,r=this,s=this.getStartLocation(t),o=this.getEndLocation(t),h=this.xField,u=this.xOpenField,c=this.yField,d=this.yOpenField,p=this.columns.template,x=p.percentWidth,v=p.percentHeight,b=p.pixelWidth,P=p.pixelHeight,A=p.maxWidth,C=p.maxHeight,I=p.pixelPaddingLeft,D=p.pixelPaddingRight,_=p.pixelPaddingTop,V=p.pixelPaddingBottom,F=!1;if(this.xAxis instanceof T&&this.yAxis instanceof T){if(!t.hasValue(this._xValueFields)||!t.hasValue(this._yValueFields))return;if(s=0,o=1,!y.isNaN(x))s+=R=m.round((o-s)*(1-x/100)/2,5),o-=R;if(e=this.xAxis.getX(t,u,s),i=this.xAxis.getX(t,h,o),y.isNaN(x))e+=R=(i-e-b)/2,i-=R;if(!y.isNaN(A))e+=R=(i-e-A)/2,i-=R;if(s=0,o=1,!y.isNaN(v))s+=R=m.round((1-v/100)/2,5),o-=R;if(a=this.yAxis.getY(t,d,s),n=this.yAxis.getY(t,c,o),y.isNaN(v))n+=R=(n-a-P)/2,a-=R;if(!y.isNaN(C))n+=R=(n-a-C)/2,a-=R;i=this.fixHorizontalCoordinate(i),e=this.fixHorizontalCoordinate(e),a=this.fixVerticalCoordinate(a),n=this.fixVerticalCoordinate(n)}else if(this.baseAxis==this.xAxis){if(!t.hasValue(this._yValueFields))return;if(!y.isNaN(x))s+=R=m.round((o-s)*(1-x/100)/2,5),o-=R;if(e=this.xAxis.getX(t,u,s),i=this.xAxis.getX(t,h,o),y.isNaN(x))e+=R=(i-e-b)/2,i-=R;if(!y.isNaN(A))e+=R=(i-e-A)/2,i-=R;var k=t.locations[d],O=t.locations[c];this.yAxis instanceof l.a&&this.dataFields[this.yField]!=this.dataFields[this.yOpenField]&&(k=0,O=0),n=this.yAxis.getY(t,d,k),a=this.yAxis.getY(t,c,O);var w=Math.ceil(this.yAxis.axisLength);(a<0&&n<0||a>w&&n>w)&&(F=!0),a=this.fixVerticalCoordinate(a),n=this.fixVerticalCoordinate(n),Math.abs(i-e)-I-D==0&&(F=!0)}else{if(!t.hasValue(this._xValueFields))return;var R;if(!y.isNaN(v))s+=R=m.round((o-s)*(1-v/100)/2,5),o-=R;if(a=this.yAxis.getY(t,d,s),n=this.yAxis.getY(t,c,o),y.isNaN(v))n-=R=(n-a-P)/2,a+=R;if(!y.isNaN(C))n-=R=(n-a-C)/2,a+=R;var L=t.locations[h],X=t.locations[u];this.xAxis instanceof l.a&&this.dataFields[this.xField]!=this.dataFields[this.xOpenField]&&(L=0,X=0),i=this.xAxis.getX(t,h,L),e=this.xAxis.getX(t,u,X);w=Math.ceil(this.xAxis.axisLength);(i<0&&e<0||i>w&&e>w)&&(F=!0),i=this.fixHorizontalCoordinate(i),e=this.fixHorizontalCoordinate(e),Math.abs(a-n)-_-V==0&&(F=!0)}var Y,j=Math.abs(i-e),N=Math.abs(n-a),M=Math.min(e,i),W=Math.min(a,n);F?this.disableUnusedColumns(t):(t.column?Y=t.column:(Y=this.columns.create(),f.copyProperties(this,Y,S.b),f.copyProperties(this.columns.template,Y,S.b),t.addSprite(Y),t.column=Y,this.itemsFocusable()?(Y.role=\"menuitem\",Y.focusable=!0):(Y.role=\"listitem\",Y.focusable=!1),Y.focusable&&(Y.events.once(\"focus\",function(e){Y.readerTitle=r.populateString(r.itemReaderText,t)},void 0,!1),Y.events.once(\"blur\",function(t){Y.readerTitle=\"\"},void 0,!1)),Y.hoverable&&(Y.events.once(\"over\",function(e){Y.readerTitle=r.populateString(r.itemReaderText,t)},void 0,!1),Y.events.once(\"out\",function(t){Y.readerTitle=\"\"},void 0,!1))),Y.width=j,Y.height=N,Y.x=M,Y.y=W,Y.realX=e,Y.realY=a,Y.realWidth=i-e,Y.realHeight=n-a,Y.parent=this.columnsContainer,Y.virtualParent=this,this.setColumnStates(Y),Y.invalid&&Y.validate(),Y.__disabled=!1,g.each(this.axisRanges.iterator(),function(e){var i=t.rangesColumns.getKey(e.uid);i||(i=r.columns.create(),f.copyProperties(e.contents,i,S.b),t.addSprite(i),t.rangesColumns.setKey(e.uid,i)),i.parent=e.contents,i.width=j,i.height=N,i.x=M,i.y=W,r.setColumnStates(i),i.invalid&&i.validate(),i.__disabled=!1}));t.itemWidth=j,t.itemHeight=N},e.prototype.disableUnusedColumns=function(t){t&&(t.column&&(t.column.width=0,t.column.height=0,t.column.__disabled=!0),g.each(this.axisRanges.iterator(),function(e){var i=t.rangesColumns.getKey(e.uid);i&&(i.width=0,i.height=0,i.__disabled=!0)}))},e.prototype.setColumnStates=function(t){var e=t.dataItem;if(this.xAxis instanceof l.a||this.yAxis instanceof l.a){var i,a=void 0,n=void 0;this.baseAxis==this.yAxis?this.xOpenField&&this.xField&&this.xAxis instanceof l.a&&(i=e.getValue(this.xOpenField),a=e.getValue(this.xField),n=e.getValue(this.xAxis.axisFieldName+\"X\",\"previousChange\")):this.yOpenField&&this.yField&&this.yAxis instanceof l.a&&(i=e.getValue(this.yOpenField),a=e.getValue(this.yField),n=e.getValue(this.yAxis.axisFieldName+\"Y\",\"previousChange\")),a<i?(e.droppedFromOpen=!0,t.defaultState.copyFrom(this._dropFromOpenState),t.setState(this._dropFromOpenState,0)):(e.droppedFromOpen=!1,t.defaultState.copyFrom(this._riseFromOpenState),t.setState(this._riseFromOpenState,0)),n<0?(e.droppedFromPrevious=!0,t.defaultState.copyFrom(this._dropFromPreviousState),t.setState(this._dropFromPreviousState,0)):(e.droppedFromPrevious=!1,t.defaultState.copyFrom(this._riseFromPreviousState),t.setState(this._riseFromPreviousState,0))}},Object.defineProperty(e.prototype,\"columns\",{get:function(){return this._columns||(this._columns=new o.e(this.createColumnTemplate()),this._disposers.push(new o.c(this._columns)),this._disposers.push(this._columns.template)),this._columns},enumerable:!0,configurable:!0}),e.prototype.createColumnTemplate=function(){return new se},Object.defineProperty(e.prototype,\"clustered\",{get:function(){return this.getPropertyValue(\"clustered\")},set:function(t){this.setPropertyValue(\"clustered\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"dropFromOpenState\",{get:function(){return this._dropFromOpenState||(this._dropFromOpenState=this.states.create(\"dropFromOpenState\")),this._dropFromOpenState},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"dropFromPreviousState\",{get:function(){return this._dropFromPreviousState||(this._dropFromPreviousState=this.states.create(\"dropFromPreviousState\")),this._dropFromPreviousState},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"riseFromOpenState\",{get:function(){return this._riseFromOpenState||(this._riseFromOpenState=this.states.create(\"riseFromOpenState\")),this._riseFromOpenState},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"riseFromPreviousState\",{get:function(){return this._riseFromPreviousState||(this._riseFromPreviousState=this.states.create(\"riseFromPreviousState\")),this._riseFromPreviousState},enumerable:!0,configurable:!0}),e.prototype.updateLegendValue=function(e){var i=this;if(t.prototype.updateLegendValue.call(this,e),this.legendDataItem){var a,n,r=this.legendDataItem.marker;e&&(a=e.droppedFromOpen?this._dropFromOpenState:this._riseFromOpenState,n=e.droppedFromPrevious?this._dropFromPreviousState:this._riseFromPreviousState),g.each(r.children.iterator(),function(t){e?(t.setState(n),t.setState(a)):(t.setState(i._riseFromPreviousState),t.setState(i._riseFromOpenState))})}},e.prototype.createLegendMarker=function(t){var e=t.pixelWidth,i=t.pixelHeight;t.removeChildren();var a=t.createChild(Yt.a);a.shouldClone=!1,f.copyProperties(this,a,S.b),a.copyFrom(this.columns.template),a.padding(0,0,0,0),a.width=e,a.height=i;var n=t.dataItem;n.color=this.fill,n.colorOrig=this.fill},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.columns.template.copyFrom(e.columns.template)},e.prototype.getBulletLocationX=function(e,i){if(this.baseAxis==this.xAxis){var a=e.locationX;return y.isNumber(a)||(a=.5),this._endLocation-(this._endLocation-this._startLocation)*a}return t.prototype.getBulletLocationX.call(this,e,i)},e.prototype.getBulletLocationY=function(e,i){if(this.baseAxis==this.yAxis){var a=e.locationY;return y.isNumber(a)||(a=.5),this._endLocation-(this._endLocation-this._startLocation)*a}return t.prototype.getBulletLocationY.call(this,e,i)},e.prototype.fixVerticalCoordinate=function(t){var e=this.columns.template.pixelPaddingBottom,i=-this.columns.template.pixelPaddingTop,a=this.yAxis.axisLength+e;return m.fitToRange(t,i,a)},e.prototype.fixHorizontalCoordinate=function(t){var e=this.columns.template.pixelPaddingLeft,i=this.columns.template.pixelPaddingRight,a=-e,n=this.xAxis.axisLength+i;return m.fitToRange(t,a,n)},e.prototype.disposeData=function(){t.prototype.disposeData.call(this),this.columns.clear()},e}(L);c.b.registeredClasses.ColumnSeries=le,c.b.registeredClasses.ColumnSeriesDataItem=oe;var he=function(t){function e(){var e=t.call(this)||this;return e.className=\"TreeMapSeriesDataItem\",e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"parentName\",{get:function(){var t=this.treeMapDataItem;if(t&&t.parent)return t.parent.name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"value\",{get:function(){var t=this.treeMapDataItem;if(t)return t.value},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"treeMapDataItem\",{get:function(){return this._dataContext},enumerable:!0,configurable:!0}),e.prototype.hide=function(e,i,a,n){var r=this.treeMapDataItem;return r&&r.hide(e),t.prototype.hide.call(this,e,i,a,n)},e.prototype.show=function(e,i,a){var n=this.treeMapDataItem;return n&&n.show(e,i,a),t.prototype.show.call(this,e,i,a)},e}(oe),ue=function(t){function e(){var e=t.call(this)||this;e.className=\"TreeMapSeries\",e.applyTheme(),e.fillOpacity=1,e.strokeOpacity=1,e.minBulletDistance=0,e.columns.template.tooltipText=\"{parentName} {name}: {value}\",e.columns.template.configField=\"config\";var i=new W.a;return e.stroke=i.getFor(\"background\"),e.dataFields.openValueX=\"x0\",e.dataFields.valueX=\"x1\",e.dataFields.openValueY=\"y0\",e.dataFields.valueY=\"y1\",e.sequencedInterpolation=!1,e.showOnInit=!1,e.columns.template.pixelPerfect=!1,e}return n.c(e,t),e.prototype.processDataItem=function(e,i){i.seriesDataItem=e,t.prototype.processDataItem.call(this,e,i)},e.prototype.createDataItem=function(){return new he},e.prototype.show=function(e){var i=this.defaultState.transitionDuration;return y.isNumber(e)&&(i=e),this.dataItems.each(function(t){t.show(e)}),t.prototype.showReal.call(this,i)},e.prototype.hide=function(e){var i=this.defaultState.transitionDuration;y.isNumber(e)&&(i=e);var a=t.prototype.hideReal.call(this,i);return this.dataItems.each(function(t){t.hide(e)}),a},e.prototype.processValues=function(){},e.prototype.dataChangeUpdate=function(){},e.prototype.processConfig=function(e){e&&(y.hasValue(e.dataFields)&&y.isObject(e.dataFields)||(e.dataFields={})),t.prototype.processConfig.call(this,e)},e.prototype.createLegendMarker=function(t){var e=t.pixelWidth,i=t.pixelHeight;t.removeChildren();var a=t.createChild(Yt.a);a.shouldClone=!1,f.copyProperties(this,a,S.b),a.padding(0,0,0,0),a.width=e,a.height=i;var n=t.dataItem;n.color=a.fill,n.colorOrig=a.fill},e}(le);c.b.registeredClasses.TreeMapSeries=ue,c.b.registeredClasses.TreeMapSeriesDataItem=he;var ce=function(t){function e(){var e=t.call(this)||this;return e.rows=[],e.className=\"TreeMapDataItem\",e.values.value={},e.values.x0={},e.values.y0={},e.values.x1={},e.values.y1={},e.hasChildren.children=!0,e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"legendDataItem\",{get:function(){return this._legendDataItem},set:function(t){this._legendDataItem=t,t.label&&(t.label.dataItem=this),t.valueLabel&&(t.valueLabel.dataItem=this)},enumerable:!0,configurable:!0}),e.prototype.getDuration=function(){return 0},Object.defineProperty(e.prototype,\"value\",{get:function(){var t=0;return this.children&&0!=this.children.length?g.each(this.children.iterator(),function(e){var i=e.value;y.isNumber(i)&&(t+=i)}):t=this.values.value.workingValue,t},set:function(t){this.setValue(\"value\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"percent\",{get:function(){return this.parent?this.value/this.parent.value*100:100},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"x0\",{get:function(){return this.values.x0.value},set:function(t){this.setValue(\"x0\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"x1\",{get:function(){return this.values.x1.value},set:function(t){this.setValue(\"x1\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"y0\",{get:function(){return this.values.y0.value},set:function(t){this.setValue(\"y0\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"y1\",{get:function(){return this.values.y1.value},set:function(t){this.setValue(\"y1\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"name\",{get:function(){return this.properties.name},set:function(t){this.setProperty(\"name\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"children\",{get:function(){return this.properties.children},set:function(t){this.setProperty(\"children\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"level\",{get:function(){return this.parent?this.parent.level+1:0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"color\",{get:function(){var t=this.properties.color;return void 0==t&&this.parent&&(t=this.parent.color),void 0==t&&this.component&&(t=this.component.colors.getIndex(this.component.colors.step*this.index)),t},set:function(t){this.setProperty(\"color\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"fill\",{get:function(){return this.color},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"series\",{get:function(){return this._series},set:function(t){t!=this._series&&(this._series&&(this.component.series.removeValue(this._series),this._series.dispose()),this._series=t,this._disposers.push(t))},enumerable:!0,configurable:!0}),e.prototype.hide=function(e,i,a,n){return this.setWorkingValue(\"value\",0),this.children&&this.children.each(function(t){t.hide(e,i,a,n)}),t.prototype.hide.call(this,e,i,a,n)},e.prototype.show=function(e,i,a){return this.setWorkingValue(\"value\",this.values.value.value),this.children&&this.children.each(function(t){t.show(e,i,a)}),t.prototype.show.call(this,e,i,a)},e}(G),de=function(t){function e(){var e=t.call(this)||this;e.layoutAlgorithm=e.squarify,e.zoomable=!0,e.className=\"TreeMap\",e.maxLevels=2,e.currentLevel=0,e.colors=new Ht.a,e.sorting=\"descending\";var i=e.xAxes.push(new l.a);i.title.disabled=!0,i.strictMinMax=!0;var a=i.renderer;a.inside=!0,a.labels.template.disabled=!0,a.ticks.template.disabled=!0,a.grid.template.disabled=!0,a.axisFills.template.disabled=!0,a.minGridDistance=100,a.line.disabled=!0,a.baseGrid.disabled=!0;var n=e.yAxes.push(new l.a);n.title.disabled=!0,n.strictMinMax=!0;var r=n.renderer;r.inside=!0,r.labels.template.disabled=!0,r.ticks.template.disabled=!0,r.grid.template.disabled=!0,r.axisFills.template.disabled=!0,r.minGridDistance=100,r.line.disabled=!0,r.baseGrid.disabled=!0,r.inversed=!0,e.xAxis=i,e.yAxis=n;var s=new ue;return e.seriesTemplates=new h.c(s),e._disposers.push(new h.b(e.seriesTemplates)),e._disposers.push(s),e.zoomOutButton.events.on(\"hit\",function(){e.zoomToChartDataItem(e._homeDataItem)},void 0,!1),e.seriesTemplates.events.on(\"insertKey\",function(t){t.newValue.isTemplate=!0},void 0,!1),e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"navigationBar\",{get:function(){return this._navigationBar},set:function(t){var e=this;this._navigationBar!=t&&(this._navigationBar=t,t.parent=this,t.toBack(),t.links.template.events.on(\"hit\",function(t){var i=t.target.dataItem.dataContext;i.isDisposed()||(e.zoomToChartDataItem(i),e.createTreeSeries(i))},void 0,!0),this._disposers.push(t))},enumerable:!0,configurable:!0}),e.prototype.validateData=function(){this.series.clear(),this._tempSeries=[],t.prototype.validateData.call(this),this._homeDataItem&&this._homeDataItem.dispose();var e=this.dataItems.template.clone();this._homeDataItem=e,g.each(this.dataItems.iterator(),function(t){t.parent=e}),e.children=this.dataItems,e.x0=0,e.y0=0,e.name=this._homeText;var i=10*Math.round(1e3*this.pixelHeight/this.pixelWidth/10)||1e3;e.x1=1e3,e.y1=i,this.xAxis.min=0,this.xAxis.max=1e3,this.xAxis.getMinMax(),this.yAxis.min=0,this.yAxis.max=i,this.yAxis.getMinMax(),this.layoutItems(e),this.createTreeSeries(e)},e.prototype.layoutItems=function(t,e){if(t){var i=t.children;e||(e=this.sorting),\"ascending\"==e&&i.values.sort(function(t,e){return t.value-e.value}),\"descending\"==e&&i.values.sort(function(t,e){return e.value-t.value}),this._updateDataItemIndexes(0),this.layoutAlgorithm(t);for(var a=0,n=i.length;a<n;a++){var r=i.getIndex(a);r.children&&this.layoutItems(r)}}},e.prototype.createTreeSeries=function(t){var e=this;this._tempSeries=[];for(var i=[t],a=t.parent;void 0!=a;)this.initSeries(a),i.push(a),a=a.parent;i.reverse(),this.navigationBar&&(this.navigationBar.data=i),this.createTreeSeriesReal(t),O.each(this._tempSeries,function(t){-1==e.series.indexOf(t)&&e.series.push(t),t.zIndex=t.level})},e.prototype.createTreeSeriesReal=function(t){if(t.children&&t.level<this.currentLevel+this.maxLevels){this.initSeries(t);for(var e=0;e<t.children.length;e++){var i=t.children.getIndex(e);i.children&&this.createTreeSeriesReal(i)}}},e.prototype.setData=function(e){this.currentLevel=0,this.currentlyZoomed=void 0,this.xAxis.start=0,this.xAxis.end=1,this.yAxis.start=0,this.yAxis.end=1,t.prototype.setData.call(this,e)},e.prototype.seriesAppeared=function(){return!0},e.prototype.initSeries=function(t){var e=this;if(!t.series){var i=void 0,a=this.seriesTemplates.getKey(t.level.toString());(i=a?a.clone():this.series.create()).dataItem.dataContext=t,i.name=t.name,i.parentDataItem=t,t.series=i;var n=t.level;i.level=n;var r=t.dataContext;r&&(i.config=r.config),this.dataUsers.removeValue(i),i.data=t.children.values,i.fill=t.color,i.columnsContainer.hide(0),i.bulletsContainer.hide(0),i.columns.template.adapter.add(\"fill\",function(t,e){var i=e.dataItem;if(i){var a=i.treeMapDataItem;if(a)return e.fill=a.color,e.adapter.remove(\"fill\"),a.color}}),this.zoomable&&(t.level>this.currentLevel||t.children&&t.children.length>0)&&(i.columns.template.cursorOverStyle=j.a.pointer,this.zoomable&&i.columns.template.events.on(\"hit\",function(i){var a=i.target.dataItem;t.level>e.currentLevel?e.zoomToChartDataItem(a.treeMapDataItem.parent):e.zoomToSeriesDataItem(a)},this,void 0))}this._tempSeries.push(t.series)},e.prototype.toggleBullets=function(t){var e=this;g.each(this.series.iterator(),function(i){-1==e._tempSeries.indexOf(i)?(i.columnsContainer.hide(),i.bulletsContainer.hide(t)):(i.columnsContainer.show(),i.bulletsContainer.show(t),i.level<e.currentLevel&&i.bulletsContainer.hide(t))})},e.prototype.zoomToSeriesDataItem=function(t){this.zoomToChartDataItem(t.treeMapDataItem)},e.prototype.zoomToChartDataItem=function(t){var e=this,i=this.zoomOutButton;if(i&&(t!=this._homeDataItem?i.show():i.hide()),t&&t.children){this.xAxis.zoomToValues(t.x0,t.x1),this.yAxis.zoomToValues(t.y0,t.y1),this.currentLevel=t.level,this.currentlyZoomed=t,this.createTreeSeries(t);var a=this.xAxis.rangeChangeAnimation||this.yAxis.rangeChangeAnimation;!a||a.isDisposed()||a.isFinished()?this.toggleBullets():(this._dataDisposers.push(a),a.events.once(\"animationended\",function(){e.toggleBullets()}))}},e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"TreeMap chart\"))},e.prototype.createDataItem=function(){return new ce},Object.defineProperty(e.prototype,\"maxLevels\",{get:function(){return this.getPropertyValue(\"maxLevels\")},set:function(t){this.setPropertyValue(\"maxLevels\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"currentLevel\",{get:function(){return this.getPropertyValue(\"currentLevel\")},set:function(t){this.setPropertyValue(\"currentLevel\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"sorting\",{get:function(){return this.getPropertyValue(\"sorting\")},set:function(t){this.setPropertyValue(\"sorting\",t,!0)},enumerable:!0,configurable:!0}),e.prototype.createSeries=function(){return new ue},Object.defineProperty(e.prototype,\"homeText\",{get:function(){return this._homeText},set:function(t){this._homeText=t,this._homeDataItem&&(this._homeDataItem.name=this._homeText)},enumerable:!0,configurable:!0}),e.prototype.processConfig=function(e){if(e){if(y.hasValue(e.layoutAlgorithm)&&y.isString(e.layoutAlgorithm))switch(e.layoutAlgorithm){case\"squarify\":e.layoutAlgorithm=this.squarify;break;case\"binaryTree\":e.layoutAlgorithm=this.binaryTree;break;case\"slice\":e.layoutAlgorithm=this.slice;break;case\"dice\":e.layoutAlgorithm=this.dice;break;case\"sliceDice\":e.layoutAlgorithm=this.sliceDice;break;default:delete e.layoutAlgorithm}y.hasValue(e.navigationBar)&&!y.hasValue(e.navigationBar.type)&&(e.navigationBar.type=\"NavigationBar\"),t.prototype.processConfig.call(this,e)}},e.prototype.validateLayout=function(){t.prototype.validateLayout.call(this),this.layoutItems(this.currentlyZoomed)},e.prototype.validateDataItems=function(){t.prototype.validateDataItems.call(this),this.layoutItems(this._homeDataItem),g.each(this.series.iterator(),function(t){t.validateRawData()}),this.zoomToChartDataItem(this._homeDataItem)},e.prototype.binaryTree=function(t){var e,i,a=t.children,n=a.length,r=new Array(n+1);for(r[0]=i=e=0;e<n;++e)r[e+1]=i+=a.getIndex(e).value;!function t(e,i,n,s,o,l,h){if(e>=i-1){var u=a.getIndex(e);return u.x0=s,u.y0=o,u.x1=l,void(u.y1=h)}var c=r[e],d=n/2+c,p=e+1,y=i-1;for(;p<y;){var g=p+y>>>1;r[g]<d?p=g+1:y=g}d-r[p-1]<r[p]-d&&e+1<p&&--p;var m=r[p]-c,f=n-m;if(l-s>h-o){var x=(s*f+l*m)/n;t(e,p,m,s,o,x,h),t(p,i,f,x,o,l,h)}else{var v=(o*f+h*m)/n;t(e,p,m,s,o,l,v),t(p,i,f,s,v,l,h)}}(0,n,t.value,t.x0,t.y0,t.x1,t.y1)},e.prototype.slice=function(t){for(var e,i=t.x0,a=t.x1,n=t.y0,r=t.y1,s=t.children,o=-1,l=s.length,h=t.value&&(r-n)/t.value;++o<l;)(e=s.getIndex(o)).x0=i,e.x1=a,e.y0=n,n+=e.value*h,e.y1=n},e.prototype.dice=function(t){for(var e,i=t.x0,a=t.x1,n=t.y0,r=t.y1,s=t.children,o=-1,l=s.length,h=t.value&&(a-i)/t.value;++o<l;)(e=s.getIndex(o)).y0=n,e.y1=r,e.x0=i,i+=e.value*h,e.x1=i},e.prototype.sliceDice=function(t){1&t.level?this.slice(t):this.dice(t)},e.prototype.squarify=function(t){for(var e,i,a,n,r,s,o,l,h,u,c=(1+Math.sqrt(5))/2,d=t.x0,p=t.x1,y=t.y0,g=t.y1,m=t.children,f=0,x=0,v=m.length,b=t.value;f<v;){i=p-d,a=g-y;do{n=m.getIndex(x++).value}while(!n&&x<v);for(r=s=n,u=n*n*(h=Math.max(a/i,i/a)/(b*c)),l=Math.max(s/u,u/r);x<v;++x){if(n+=e=m.getIndex(x).value,e<r&&(r=e),e>s&&(s=e),u=n*n*h,(o=Math.max(s/u,u/r))>l){n-=e;break}l=o}var P=this.dataItems.template.clone();P.value=n,P.dice=i<a,P.children=m.slice(f,x),P.x0=d,P.y0=y,P.x1=p,P.y1=g,P.dice?(P.y1=b?y+=a*n/b:g,this.dice(P)):(P.x1=b?d+=i*n/b:p,this.slice(P)),b-=n,f=x}},e.prototype.handleDataItemValueChange=function(t,e){\"value\"==e&&this.invalidateDataItems()},e.prototype.handleDataItemWorkingValueChange=function(t,e){\"value\"==e&&this.invalidateDataItems()},e.prototype.getLegendLevel=function(t){if(t&&t.children)return t.children.length>1?t:1==t.children.length?this.getLegendLevel(t.children.getIndex(0)):t},e.prototype.feedLegend=function(){var t=this.legend;if(t){t.dataFields.name=\"name\";var e=this.getLegendLevel(this._homeDataItem);if(e){var i=[];e.children.each(function(t){i.push(t)}),t.data=i}}},e.prototype.disposeData=function(){t.prototype.disposeData.call(this),this._homeDataItem=void 0,this.series.clear(),this.navigationBar&&this.navigationBar.disposeData(),this.xAxis.disposeData(),this.yAxis.disposeData()},e.prototype.getExporting=function(){var e=this,i=t.prototype.getExporting.call(this);return i.adapter.add(\"formatDataFields\",function(t){return\"csv\"!=t.format&&\"xlsx\"!=t.format||y.hasValue(e.dataFields.children)&&delete t.dataFields[e.dataFields.children],t}),i},e}(q);c.b.registeredClasses.TreeMap=de;var pe=function(t){function e(){var e=t.call(this)||this;return e._chart=new F.d,e.className=\"AxisRendererX3D\",e._disposers.push(e._chart),e.applyTheme(),e}return n.c(e,t),e.prototype.updateGridElement=function(t,e,i){e+=(i-e)*t.location;var a=this.positionToPoint(e);if(t.element){var n=this.chart.dx3D||0,r=this.chart.dy3D||0,s=this.getHeight();t.path=w.moveTo({x:n,y:r})+w.lineTo({x:n,y:s+r})+w.lineTo({x:0,y:s})}this.positionItem(t,a),this.toggleVisibility(t,e,0,1)},e.prototype.updateBaseGridElement=function(){t.prototype.updateBaseGridElement.call(this);var e=this.getHeight(),i=this.chart.dx3D||0,a=this.chart.dy3D||0;this.baseGrid.path=w.moveTo({x:i,y:a})+w.lineTo({x:0,y:0})+w.lineTo({x:0,y:e})},Object.defineProperty(e.prototype,\"chart\",{get:function(){return this._chart.get()},set:function(t){t&&this._chart.set(t,t.events.on(\"propertychanged\",this.handle3DChanged,this,!1))},enumerable:!0,configurable:!0}),e.prototype.handle3DChanged=function(t){\"depth\"!=t.property&&\"angle\"!=t.property||this.invalidate()},e}(b.a);c.b.registeredClasses.AxisRendererX3D=pe;var ye=function(t){function e(){var e=t.call(this)||this;return e._chart=new F.d,e.className=\"AxisRendererY3D\",e._disposers.push(e._chart),e.applyTheme(),e}return n.c(e,t),e.prototype.updateGridElement=function(t,e,i){e+=(i-e)*t.location;var a=this.positionToPoint(e);if(t.element){var n=this.chart.dx3D||0,r=this.chart.dy3D||0,s=this.getWidth();t.path=w.moveTo({x:0,y:0})+w.lineTo({x:n,y:r})+w.lineTo({x:s+n,y:r})}this.positionItem(t,a),this.toggleVisibility(t,e,0,1)},e.prototype.updateBaseGridElement=function(){t.prototype.updateBaseGridElement.call(this);var e=this.chart.dx3D||0,i=this.chart.dy3D||0,a=this.getWidth();this.baseGrid.path=w.moveTo({x:0,y:0})+w.lineTo({x:a,y:0})+w.lineTo({x:a+e,y:i})},Object.defineProperty(e.prototype,\"chart\",{get:function(){return this._chart.get()},set:function(t){t&&this._chart.set(t,t.events.on(\"propertychanged\",this.handle3DChanged,this,!1))},enumerable:!0,configurable:!0}),e.prototype.handle3DChanged=function(t){\"depth\"!=t.property&&\"angle\"!=t.property||this.invalidate()},e}(P.a),ge=i(\"Mr4Y\"),me=function(t){function e(){var e=t.call(this)||this;return e.className=\"Column3D\",e}return n.c(e,t),e.prototype.createAssets=function(){this.column3D=this.createChild(ge.a),this.column3D.shouldClone=!1,this.column3D.strokeOpacity=0,this.column=this.column3D},e.prototype.validate=function(){t.prototype.validate.call(this),this.column3D&&(this.column3D.width=this.pixelWidth,this.column3D.height=this.pixelHeight,this.column3D.invalid&&this.column3D.validate())},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.column3D&&this.column3D.copyFrom(e.column3D)},e.prototype.setFill=function(e){t.prototype.setFill.call(this,e),this.column.fill=e},e}(se);c.b.registeredClasses.Column3D=me;var fe=function(t){function e(){var e=t.call(this)||this;return e.className=\"ColumnSeries3DDataItem\",e.applyTheme(),e}return n.c(e,t),e}(oe),xe=function(t){function e(){var e=t.call(this)||this;return e.className=\"ColumnSeries3D\",e.columns.template.column3D.applyOnClones=!0,e.columns.template.hiddenState.properties.visible=!0,e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"columnsContainer\",{get:function(){return this.chart&&this.chart.columnsContainer?this.chart.columnsContainer:this._columnsContainer},enumerable:!0,configurable:!0}),e.prototype.validateDataElementReal=function(e){t.prototype.validateDataElementReal.call(this,e),e.column&&(e.column.dx=this.dx,e.column.dy=this.dy)},e.prototype.validateDataElements=function(){t.prototype.validateDataElements.call(this),this.chart&&this.chart.invalidateLayout()},e.prototype.createColumnTemplate=function(){return new me},Object.defineProperty(e.prototype,\"depth\",{get:function(){return this.getPropertyValue(\"depth\")},set:function(t){this.setPropertyValue(\"depth\",t,!0),this.columns.template.column3D.depth=t},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"angle\",{get:function(){return this.getPropertyValue(\"angle\")},set:function(t){this.setPropertyValue(\"angle\",t),this.columns.template.column3D.angle=t},enumerable:!0,configurable:!0}),e}(le);c.b.registeredClasses.ColumnSeries3D=xe,c.b.registeredClasses.ColumnSeries3DDataItem=fe;var ve=function(t){function e(){var e=t.call(this)||this;return e.className=\"XYChart3DDataItem\",e.applyTheme(),e}return n.c(e,t),e}(G),be=function(t){function e(){var e=t.call(this)||this;e._axisRendererX=pe,e._axisRendererY=ye,e.className=\"XYChart3D\",e.depth=30,e.angle=30;var i=e.seriesContainer.createChild(s.a);return i.shouldClone=!1,i.isMeasured=!1,i.layout=\"none\",e.columnsContainer=i,e.columnsContainer.mask=e.createChild(S.a),e.applyTheme(),e}return n.c(e,t),e.prototype.updateSeriesMasks=function(){if(t.prototype.updateSeriesMasks.call(this),k.isIE()){var e=this.columnsContainer,i=e.mask;e.mask=void 0,e.mask=i}},Object.defineProperty(e.prototype,\"depth\",{get:function(){return this.getPropertyValue(\"depth\")},set:function(t){this.setPropertyValue(\"depth\",t),this.fixLayout(),this.invalidateDataUsers()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"angle\",{get:function(){return this.getPropertyValue(\"angle\")},set:function(t){this.setPropertyValue(\"angle\",t),this.fixLayout(),this.invalidateDataUsers()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"dx3D\",{get:function(){return m.cos(this.angle)*this.depth},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"dy3D\",{get:function(){return-m.sin(this.angle)*this.depth},enumerable:!0,configurable:!0}),e.prototype.validateLayout=function(){t.prototype.validateLayout.call(this),this.fixColumns()},e.prototype.fixLayout=function(){this.chartContainer.marginTop=-this.dy3D,this.chartContainer.paddingRight=this.dx3D,this.scrollbarX&&(this.scrollbarX.dy=this.dy3D,this.scrollbarX.dx=this.dx3D),this.scrollbarY&&(this.scrollbarY.dy=this.dy3D,this.scrollbarY.dx=this.dx3D),this.fixColumns(),t.prototype.fixLayout.call(this)},e.prototype.fixColumns=function(){var t=this,e=1,i=0;g.each(this.series.iterator(),function(t){t instanceof xe&&(!t.clustered&&i>0&&e++,t.depthIndex=e-1,i++)});var a=0;g.each(this.series.iterator(),function(i){if(i instanceof xe){i.depth=t.depth/e,i.angle=t.angle,i.dx=t.depth/e*m.cos(t.angle)*i.depthIndex,i.dy=-t.depth/e*m.sin(t.angle)*i.depthIndex;var n=!1;(i.baseAxis==i.xAxis&&i.xAxis.renderer.inversed||i.baseAxis==i.yAxis&&i.yAxis.renderer.inversed)&&(n=!0);var r=1;i.columns.each(function(t){t.zIndex=n?1e3*(1e3-r)+a-100*i.depthIndex:1e3*r+a-100*i.depthIndex,r++}),n?a--:a++}}),this.maskColumns()},e.prototype.processConfig=function(e){if(e&&y.hasValue(e.series)&&y.isArray(e.series))for(var i=0,a=e.series.length;i<a;i++)e.series[i].type=e.series[i].type||\"ColumnSeries3D\";t.prototype.processConfig.call(this,e)},e.prototype.maskColumns=function(){var t=this.plotContainer.pixelWidth,e=this.plotContainer.pixelHeight,i=this.dx3D,a=this.dy3D,n=w.moveTo({x:0,y:0})+w.lineTo({x:i,y:a})+w.lineTo({x:t+i,y:a})+w.lineTo({x:t+i,y:e+a})+w.lineTo({x:t,y:e})+w.lineTo({x:t,y:e})+w.lineTo({x:0,y:e})+w.closePath(),r=this.columnsContainer;r&&r.mask&&(r.mask.path=n)},e}(q);c.b.registeredClasses.XYChart3D=be;var Pe=i(\"2OXf\"),Ae=function(t){function e(){var e=t.call(this)||this;return e.className=\"Candlestick\",e.layout=\"none\",e}return n.c(e,t),e.prototype.createAssets=function(){t.prototype.createAssets.call(this),this.lowLine=this.createChild(Q.a),this.lowLine.shouldClone=!1,this.highLine=this.createChild(Q.a),this.highLine.shouldClone=!1},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.lowLine&&this.lowLine.copyFrom(e.lowLine),this.highLine&&this.highLine.copyFrom(e.highLine)},e}(se);c.b.registeredClasses.Candlestick=Ae;var Ce=function(t){function e(){var e=t.call(this)||this;return e.values.lowValueX={},e.values.lowValueY={},e.values.highValueX={},e.values.highValueY={},e.className=\"CandlestickSeriesDataItem\",e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"lowValueX\",{get:function(){return this.values.lowValueX.value},set:function(t){this.setValue(\"lowValueX\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"lowValueY\",{get:function(){return this.values.lowValueY.value},set:function(t){this.setValue(\"lowValueY\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"highValueX\",{get:function(){return this.values.highValueX.value},set:function(t){this.setValue(\"highValueX\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"highValueY\",{get:function(){return this.values.highValueY.value},set:function(t){this.setValue(\"highValueY\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"closeValueX\",{get:function(){return this.values.valueX.value},set:function(t){this.setValue(\"valueX\",t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"closeValueY\",{get:function(){return this.values.valueY.value},set:function(t){this.setValue(\"valueY\",t)},enumerable:!0,configurable:!0}),e}(oe),Ie=function(t){function e(){var e=t.call(this)||this;e.className=\"CandlestickSeries\",e.strokeOpacity=1;var i=new W.a,a=i.getFor(\"positive\"),n=i.getFor(\"negative\");return e.dropFromOpenState.properties.fill=n,e.dropFromOpenState.properties.stroke=n,e.riseFromOpenState.properties.fill=a,e.riseFromOpenState.properties.stroke=a,e.applyTheme(),e}return n.c(e,t),e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"Candlestick Series\"))},e.prototype.createDataItem=function(){return new Ce},e.prototype.validateDataElementReal=function(e){t.prototype.validateDataElementReal.call(this,e),this.validateCandlestick(e)},e.prototype.validateCandlestick=function(t){var e=t.column;if(e){var i=e.lowLine,a=e.highLine;if(this.baseAxis==this.xAxis){var n=e.pixelWidth/2;i.x=n,a.x=n;var r=t.getWorkingValue(this.yOpenField),s=t.getWorkingValue(this.yField),o=this.yAxis.getY(t,this.yOpenField),l=this.yAxis.getY(t,this.yField),h=this.yAxis.getY(t,this.yLowField),u=this.yAxis.getY(t,this.yHighField),c=e.pixelY;i.y1=h-c,a.y1=u-c,r<s?(i.y2=o-c,a.y2=l-c):(i.y2=l-c,a.y2=o-c)}if(this.baseAxis==this.yAxis){var d=e.pixelHeight/2;i.y=d,a.y=d;var p=t.getWorkingValue(this.xOpenField),y=t.getWorkingValue(this.xField),m=this.xAxis.getX(t,this.xOpenField),f=this.xAxis.getX(t,this.xField),x=this.xAxis.getX(t,this.xLowField),v=this.xAxis.getX(t,this.xHighField),b=e.pixelX;i.x1=x-b,a.x1=v-b,p<y?(i.x2=m-b,a.x2=f-b):(i.x2=f-b,a.x2=m-b)}g.each(this.axisRanges.iterator(),function(e){var n=t.rangesColumns.getKey(e.uid);if(n){var r=n.lowLine;r.x=i.x,r.y=i.y,r.x1=i.x1,r.x2=i.x2,r.y1=i.y1,r.y2=i.y2;var s=n.highLine;s.x=a.x,s.y=a.y,s.x1=a.x1,s.x2=a.x2,s.y1=a.y1,s.y2=a.y2}})}},Object.defineProperty(e.prototype,\"xLowField\",{get:function(){return this._xLowField},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"yLowField\",{get:function(){return this._yLowField},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"xHighField\",{get:function(){return this._xHighField},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"yHighField\",{get:function(){return this._yHighField},enumerable:!0,configurable:!0}),e.prototype.defineFields=function(){if(t.prototype.defineFields.call(this),this.baseAxis==this.xAxis){var e=k.capitalize(this.yAxis.axisFieldName);this._yLowField=\"low\"+e+\"Y\",this._yHighField=\"high\"+e+\"Y\"}if(this.baseAxis==this.yAxis){var i=k.capitalize(this.xAxis.axisFieldName);this._xLowField=\"low\"+i+\"X\",this._xHighField=\"high\"+i+\"X\"}this.addValueField(this.xAxis,this._xValueFields,this._xLowField),this.addValueField(this.xAxis,this._xValueFields,this._xHighField),this.addValueField(this.yAxis,this._yValueFields,this._yLowField),this.addValueField(this.yAxis,this._yValueFields,this._yHighField)},e.prototype.createLegendMarker=function(t){var e=t.pixelWidth,i=t.pixelHeight;t.removeChildren();var a,n,r=t.createChild(Ae);r.shouldClone=!1,r.copyFrom(this.columns.template);var s=r.lowLine,o=r.highLine;this.baseAxis==this.yAxis?(a=e/3,n=i,s.y=i/2,o.y=i/2,s.x2=e/3,o.x2=e/3,o.x=e/3*2,r.column.x=e/3):(a=e,n=i/3,s.x=e/2,o.x=e/2,s.y2=i/3,o.y2=i/3,o.y=i/3*2,r.column.y=i/3),r.width=a,r.height=n,f.copyProperties(this,t,S.b),f.copyProperties(this.columns.template,r,S.b),r.stroke=this.riseFromOpenState.properties.stroke,r.fill=r.stroke;var l=t.dataItem;l.color=r.fill,l.colorOrig=r.fill},e.prototype.createColumnTemplate=function(){return new Ae},e}(le);c.b.registeredClasses.CandlestickSeries=Ie,c.b.registeredClasses.CandlestickSeriesDataItem=Ce;var De=function(t){function e(){var e=t.call(this)||this;return e.className=\"OHLC\",e.layout=\"none\",e}return n.c(e,t),e.prototype.createAssets=function(){this.openLine=this.createChild(Q.a),this.openLine.shouldClone=!1,this.highLowLine=this.createChild(Q.a),this.highLowLine.shouldClone=!1,this.closeLine=this.createChild(Q.a),this.closeLine.shouldClone=!1},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.openLine&&this.openLine.copyFrom(e.openLine),this.highLowLine&&this.highLowLine.copyFrom(e.highLowLine),this.closeLine&&this.closeLine.copyFrom(e.closeLine)},e}(Ae);c.b.registeredClasses.OHLC=De;var _e=function(t){function e(){var e=t.call(this)||this;return e.className=\"OHLCSeriesDataItem\",e.applyTheme(),e}return n.c(e,t),e}(Ce),Te=function(t){function e(){var e=t.call(this)||this;return e.className=\"OHLCSeries\",e.applyTheme(),e}return n.c(e,t),e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"OHLC Series\"))},e.prototype.createDataItem=function(){return new _e},e.prototype.validateCandlestick=function(t){var e=t.column;if(e){var i=e.openLine,a=e.highLowLine,n=e.closeLine;if(this.baseAxis==this.xAxis){var r=e.pixelWidth/2;a.x=r,t.getWorkingValue(this.yOpenField),t.getWorkingValue(this.yField);var s=this.yAxis.getY(t,this.yOpenField),o=this.yAxis.getY(t,this.yField),l=this.yAxis.getY(t,this.yLowField),h=this.yAxis.getY(t,this.yHighField),u=e.pixelY;i.y1=s-u,i.y2=s-u,i.x1=0,i.x2=r,n.y1=o-u,n.y2=o-u,n.x1=r,n.x2=2*r,a.y1=h-u,a.y2=l-u}if(this.baseAxis==this.yAxis){var c=e.pixelHeight/2;a.y=c,t.getWorkingValue(this.xOpenField),t.getWorkingValue(this.xField);var d=this.xAxis.getX(t,this.xOpenField),p=this.xAxis.getX(t,this.xField),y=this.xAxis.getX(t,this.xLowField),m=this.xAxis.getX(t,this.xHighField),f=e.pixelX;i.x1=d-f,i.x2=d-f,i.y1=c,i.y2=2*c,n.x1=p-f,n.x2=p-f,n.y1=0,n.y2=c,a.x1=m-f,a.x2=y-f}g.each(this.axisRanges.iterator(),function(e){var r=t.rangesColumns.getKey(e.uid);if(r){var s=r.openLine;s.x=i.x,s.y=i.y,s.x1=i.x1,s.x2=i.x2,s.y1=i.y1,s.y2=i.y2;var o=r.closeLine;o.x=n.x,o.y=n.y,o.x1=n.x1,o.x2=n.x2,o.y1=n.y1,o.y2=n.y2;var l=r.highLowLine;l.x=a.x,l.y=a.y,l.x1=a.x1,l.x2=a.x2,l.y1=a.y1,l.y2=a.y2}})}},e.prototype.createLegendMarker=function(t){var e=t.pixelWidth,i=t.pixelHeight;t.removeChildren();var a,n,r=t.createChild(De);r.shouldClone=!1,r.copyFrom(this.columns.template);var s=r.openLine,o=r.closeLine,l=r.highLowLine;this.baseAxis==this.yAxis?(a=e/3,n=i,l.y=i/2,l.x2=e,s.x=e/3*2,s.y2=i/2,o.x=e/3,o.y2=i,o.y1=i/2):(a=e,n=i/3,l.x=e/2,l.y2=i,s.y=i/3*2,s.x2=e/2,o.y=i/3,o.x2=e,o.x1=e/2),r.width=a,r.height=n,f.copyProperties(this,t,S.b),f.copyProperties(this.columns.template,r,S.b),r.stroke=this.riseFromOpenState.properties.stroke;var h=t.dataItem;h.color=r.stroke,h.colorOrig=r.stroke},e.prototype.createColumnTemplate=function(){return new De},e}(Ie);c.b.registeredClasses.OHLCSeries=Te,c.b.registeredClasses.OHLCSeriesDataItem=_e;var Ve=function(t){function e(){var e=t.call(this)||this;return e.className=\"StepLineSeriesSegment\",e}return n.c(e,t),e.prototype.drawSegment=function(t,e,i,a,n,r){if(t.length>0&&e.length>0)if(n){var s=w.moveTo(t[0]);if(t.length>0)for(var o=1;o<t.length;o++){var l=t[o];o/2==Math.round(o/2)?s+=w.moveTo(l):s+=w.lineTo(l)}this.strokeSprite.path=s,(this.fillOpacity>0||this.fillSprite.fillOpacity>0)&&(s=w.moveTo(t[0])+w.polyline(t),s+=w.lineTo(e[0])+w.polyline(e),s+=w.lineTo(t[0]),s+=w.closePath(),this.fillSprite.path=s)}else{s=w.moveTo(t[0])+w.polyline(t);this.strokeSprite.path=s,(this.fillOpacity>0||this.fillSprite.fillOpacity>0)&&(s+=w.lineTo(e[0])+w.polyline(e),s+=w.lineTo(t[0]),s+=w.closePath(),this.fillSprite.path=s)}},e}(J);c.b.registeredClasses.StepLineSeriesSegment=Ve;var Se=function(t){function e(){var e=t.call(this)||this;return e.className=\"StepLineSeriesDataItem\",e.applyTheme(),e}return n.c(e,t),e}(it),Fe=function(t){function e(){var e=t.call(this)||this;return e.className=\"StepLineSeries\",e.applyTheme(),e.startLocation=0,e.endLocation=1,e}return n.c(e,t),e.prototype.createDataItem=function(){return new Se},e.prototype.addPoints=function(t,e,i,a,n){var r=this.startLocation,s=this.endLocation,o=this.xAxis.getX(e,i,r),l=this.yAxis.getY(e,a,r),h=this.xAxis.getX(e,i,s),u=this.yAxis.getY(e,a,s);if(o=m.fitToRange(o,-2e4,2e4),l=m.fitToRange(l,-2e4,2e4),h=m.fitToRange(h,-2e4,2e4),u=m.fitToRange(u,-2e4,2e4),!this.noRisers&&this.connect&&t.length>1){var c=t[t.length-1];this.baseAxis==this.xAxis&&(n?t.push({x:c.x,y:u}):t.push({x:o,y:c.y})),this.baseAxis==this.yAxis&&(n?t.push({x:h,y:c.y}):t.push({x:c.x,y:l}))}var d={x:o,y:l},p={x:h,y:u};n?t.push(p,d):t.push(d,p)},e.prototype.drawSegment=function(t,e,i){var a=!1;this.yAxis==this.baseAxis&&(a=!0),t.drawSegment(e,i,this.tensionX,this.tensionY,this.noRisers,a)},e.prototype.createSegment=function(){return new Ve},Object.defineProperty(e.prototype,\"noRisers\",{get:function(){return this.getPropertyValue(\"noRisers\")},set:function(t){this.setPropertyValue(\"noRisers\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"startLocation\",{get:function(){return this.getPropertyValue(\"startLocation\")},set:function(t){this.setPropertyValue(\"startLocation\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endLocation\",{get:function(){return this.getPropertyValue(\"endLocation\")},set:function(t){this.setPropertyValue(\"endLocation\",t,!0)},enumerable:!0,configurable:!0}),e}(at);c.b.registeredClasses.StepLineSeries=Fe,c.b.registeredClasses.StepLineSeriesDataItem=Se;var ke=function(t){function e(){var e=t.call(this)||this;return e.className=\"RadarColumn\",e}return n.c(e,t),e.prototype.createAssets=function(){this.radarColumn=this.createChild(te.a),this.radarColumn.shouldClone=!1,this.radarColumn.strokeOpacity=void 0,this.column=this.radarColumn},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.radarColumn&&this.radarColumn.copyFrom(e.radarColumn)},e.prototype.getTooltipX=function(){var t=this.getPropertyValue(\"tooltipX\");return y.isNumber(t)||(t=this.radarColumn.tooltipX),t},e.prototype.getTooltipY=function(){var t=this.getPropertyValue(\"tooltipX\");return y.isNumber(t)||(t=this.radarColumn.tooltipY),t},e}(se);c.b.registeredClasses.RadarColumn=ke;var Oe=function(t){function e(){var e=t.call(this)||this;return e.className=\"ColumnSeriesDataItem\",e.applyTheme(),e}return n.c(e,t),e}(oe),we=function(t){function e(){var e=t.call(this)||this;return e.className=\"RadarColumnSeries\",e.applyTheme(),e}return n.c(e,t),e.prototype.createColumnTemplate=function(){return new ke},e.prototype.validate=function(){this.chart.invalid&&this.chart.validate(),t.prototype.validate.call(this)},e.prototype.validateDataElementReal=function(t){var e,i,a,n,r=this,s=this.chart.startAngle,o=this.chart.endAngle,l=this.yField,h=this.yOpenField,u=this.xField,c=this.xOpenField,d=this.getStartLocation(t),p=this.getEndLocation(t),x=(o-s)/(this.dataItems.length*(this.end-this.start)),v=this.columns.template.percentWidth;y.isNaN(v)&&(v=100);var b=m.round((p-d)*(1-v/100)/2,5);if(d+=b,p-=b,this.baseAxis==this.xAxis?(a=m.getDistance({x:this.yAxis.getX(t,l,t.locations[l],\"valueY\"),y:this.yAxis.getY(t,l,t.locations[l],\"valueY\")}),n=m.getDistance({x:this.yAxis.getX(t,h,t.locations[h],\"valueY\"),y:this.yAxis.getY(t,h,t.locations[h],\"valueY\")}),e=this.xAxis.getAngle(t,c,d,\"valueX\"),i=this.xAxis.getAngle(t,u,p,\"valueX\"),s+=d*x,o-=(1-p)*x):(a=m.getDistance({x:this.yAxis.getX(t,l,d,\"valueY\"),y:this.yAxis.getY(t,l,d,\"valueY\")}),n=m.getDistance({x:this.yAxis.getX(t,h,p,\"valueY\"),y:this.yAxis.getY(t,h,p,\"valueY\")}),e=this.xAxis.getAngle(t,u,t.locations[u],\"valueX\"),i=this.xAxis.getAngle(t,c,t.locations[c],\"valueX\")),i<e){var P=i;i=e,e=P}e=m.fitToRange(e,s,o),i=m.fitToRange(i,s,o);var A=t.column;A||(A=this.columns.create(),t.column=A,f.forceCopyProperties(this.columns.template,A,S.b),t.addSprite(A),this.setColumnStates(A));var C=A.radarColumn;C.startAngle=e;var I=i-e;I>0?(C.arc=I,C.radius=a,C.innerRadius=n,A.__disabled=!1,A.parent=this.columnsContainer,g.each(this.axisRanges.iterator(),function(i){var s=t.rangesColumns.getKey(i.uid);s||(s=r.columns.create(),f.forceCopyProperties(r.columns.template,s,S.b),f.copyProperties(i.contents,s,S.b),s.dataItem&&O.remove(s.dataItem.sprites,s),t.addSprite(s),r.setColumnStates(s),t.rangesColumns.setKey(i.uid,s));var o=s.radarColumn;o.startAngle=e,o.arc=I,o.radius=a,o.innerRadius=n,o.invalid&&o.validate(),s.__disabled=!1,s.parent=i.contents})):this.disableUnusedColumns(t)},e.prototype.getPoint=function(t,e,i,a,n,r,s){r||(r=\"valueX\"),s||(s=\"valueY\");var o=this.yAxis.getX(t,i,n,s),l=this.yAxis.getY(t,i,n,s),h=m.getDistance({x:o,y:l});0==h&&(h=1e-5);var u=this.xAxis.getAngle(t,e,a,r);return{x:h*m.cos(u),y:h*m.sin(u)}},e.prototype.getMaskPath=function(){var t=this.yAxis.renderer;return w.arc(t.startAngle,t.endAngle-t.startAngle,t.pixelRadius,t.pixelInnerRadius)},e}(le);c.b.registeredClasses.RadarColumnSeries=we,c.b.registeredClasses.RadarColumnSeriesDataItem=Oe;var Re=i(\"AC2I\"),Le=function(t){function e(){var e=t.call(this)||this;return e.slice=e.createChild(S.a),e.slice.shouldClone=!1,e.slice.setElement(e.paper.add(\"path\")),e.slice.isMeasured=!1,e.orientation=\"vertical\",e.bottomWidth=Object(Y.c)(100),e.topWidth=Object(Y.c)(100),e.isMeasured=!1,e.width=10,e.height=10,e.expandDistance=0,e.className=\"FunnelSlice\",e.applyTheme(),e}return n.c(e,t),e.prototype.draw=function(){t.prototype.draw.call(this);var e=this.pixelPaddingTop,i=this.pixelPaddingBottom,a=this.pixelPaddingRight,n=this.pixelPaddingLeft,r=this.pixelWidth-a-n,s=this.pixelHeight-e-i,o=this.expandDistance,l=\"\";if(\"vertical\"==this.orientation){var h={x:(r-(f=k.relativeToValue(this.topWidth,r)))/2+n,y:e},u={x:(r+f)/2+n,y:e},c={x:(r+(x=k.relativeToValue(this.bottomWidth,r)))/2+n,y:e+s},d={x:(r-x)/2+n,y:e+s},p={x:u.x+(c.x-u.x)/2+o*s,y:u.y+.5*s},y={x:h.x+(d.x-h.x)/2-o*s,y:h.y+.5*s},g=w.lineTo(c),m=\"\";0!=o&&(g=w.quadraticCurveTo(c,p),m=w.quadraticCurveTo(h,y)),l=w.moveTo(h)+w.lineTo(u)+g+w.lineTo(d)+m,this.tickPoint={x:u.x+(c.x-u.x)/2,y:u.y+(c.y-u.y)/2}}else{var f,x,v={x:n,y:(s-(f=k.relativeToValue(this.topWidth,s)))/2+e},b={x:n,y:(s+f)/2+e},P={x:n+r,y:(s-(x=k.relativeToValue(this.bottomWidth,s)))/2+e},A={x:n+r,y:(s+x)/2+e};p={y:v.y+(P.y-v.y)/2-o*r,x:v.x+.5*r},y={y:b.y+(A.y-b.y)/2+o*r,x:b.x+.5*r},g=w.lineTo(P),m=\"\";0!=o&&(g=w.quadraticCurveTo(P,p),m=w.quadraticCurveTo(b,y)),l=w.moveTo(b)+w.lineTo(v)+g+w.lineTo(A)+m,this.tickPoint={y:b.y+(A.y-b.y)/2,x:b.x+(A.x-b.x)/2}}this.slice.path=l,this.invalidateLayout()},e.prototype.getPoint=function(t,e){var i=this.pixelPaddingTop,a=this.pixelPaddingBottom,n=this.pixelPaddingRight,r=this.pixelPaddingLeft,s=this.pixelWidth-n-r,o=this.pixelHeight-i-a;if(\"vertical\"==this.orientation){var l={x:(s-(d=k.relativeToValue(this.topWidth,s)))/2+r,y:i},h={x:(s+d)/2+r,y:i},u={x:(s+(p=k.relativeToValue(this.bottomWidth,s)))/2+r,y:i+o},c=l.x+({x:(s-p)/2+r,y:i+o}.x-l.x)*e;return{x:c+(h.x+(u.x-h.x)*e-c)*t,y:h.y+(u.y-h.y)*e}}var d,p,y={x:r,y:(o-(d=k.relativeToValue(this.topWidth,o)))/2+i},g={x:r,y:(o+d)/2+i},m={x:r+s,y:(o-(p=k.relativeToValue(this.bottomWidth,o)))/2+i},f=y.y+(m.y-y.y)*t;return{y:f+(g.y+({x:r+s,y:(o+p)/2+i}.y-g.y)*t-f)*e,x:y.x+(m.x-y.x)*t}},Object.defineProperty(e.prototype,\"bottomWidth\",{get:function(){return this.getPropertyValue(\"bottomWidth\")},set:function(t){this.setPercentProperty(\"bottomWidth\",t,!0,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"topWidth\",{get:function(){return this.getPropertyValue(\"topWidth\")},set:function(t){this.setPercentProperty(\"topWidth\",t,!0,!1,10,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"orientation\",{get:function(){return this.getPropertyValue(\"orientation\")},set:function(t){this.setPropertyValue(\"orientation\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"expandDistance\",{get:function(){return this.getPropertyValue(\"expandDistance\")},set:function(t){this.setPropertyValue(\"expandDistance\",t,!0)},enumerable:!0,configurable:!0}),e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.slice&&this.slice.copyFrom(e.slice)},e}(s.a);c.b.registeredClasses.FunnelSlice=Le;var Xe=i(\"qzbU\"),Ye=function(t){function e(){var e=t.call(this)||this;return e._label=new F.d,e._slice=new F.d,e.className=\"FunnelTick\",e.element=e.paper.add(\"path\"),e._disposers.push(e._label),e._disposers.push(e._slice),e.setPropertyValue(\"locationX\",0),e.setPropertyValue(\"locationY\",0),e.applyTheme(),e}return n.c(e,t),e.prototype.draw=function(){t.prototype.draw.call(this);var e=this.slice,i=e.getPoint(this.locationX,this.locationY);if(i){var a=this.label,n=e.dataItem.component;if(\"vertical\"==n.orientation){var r=a.pixelX,s=a.pixelY;n.labelsOpposite||(r+=a.maxRight);var o=k.spritePointToSprite(i,e,this.parent),l=k.spritePointToSprite({x:r,y:s},a.parent,this.parent);this.path=w.moveTo(o)+w.lineTo(l)}else{r=a.pixelX,s=a.pixelY;n.labelsOpposite||(s+=a.maxBottom);o=k.spritePointToSprite(i,e,this.parent),l=k.spritePointToSprite({x:r,y:s},a.parent,this.parent);this.path=w.moveTo(o)+w.lineTo(l)}}},Object.defineProperty(e.prototype,\"slice\",{get:function(){return this._slice.get()},set:function(t){this._slice.set(t,new F.c([t.events.on(\"transformed\",this.invalidate,this,!1),t.events.on(\"validated\",this.invalidate,this,!1)]))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"label\",{get:function(){return this._label.get()},set:function(t){this._label.set(t,t.events.on(\"transformed\",this.invalidate,this,!1))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"locationX\",{get:function(){return this.getPropertyValue(\"locationX\")},set:function(t){this.setPropertyValue(\"locationX\",t,!1,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"locationY\",{get:function(){return this.getPropertyValue(\"locationY\")},set:function(t){this.setPropertyValue(\"locationY\",t,!1,!0)},enumerable:!0,configurable:!0}),e}(Xe.a);c.b.registeredClasses.FunnelTick=Ye;var je=function(t){function e(){var e=t.call(this)||this;return e.className=\"FunnelSeriesDataItem\",e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"sliceLink\",{get:function(){var t=this;if(!this._sliceLink){var e=this.component.sliceLinks.create();this._sliceLink=e,this._disposers.push(e),e.parent=this.component.slicesContainer,this._disposers.push(new F.b(function(){t.component&&t.component.sliceLinks.removeValue(e)})),this.addSprite(e),e.visible=this.visible}return this._sliceLink},enumerable:!0,configurable:!0}),e}(Re.b),Ne=function(t){function e(){var e=t.call(this)||this;return e._nextY=0,e.className=\"FunnelSeries\",e.orientation=\"vertical\",e.width=Object(Y.c)(100),e.height=Object(Y.c)(100),e.slicesContainer.width=Object(Y.c)(100),e.slicesContainer.height=Object(Y.c)(100),e._disposers.push(e.slicesContainer.events.on(\"maxsizechanged\",e.invalidateDataItems,e,!1)),e.labelsOpposite=!0,e.labelsContainer.layout=\"absolute\",e.bottomRatio=0,e.applyTheme(),e}return n.c(e,t),e.prototype.createSlice=function(){return new Le},e.prototype.createTick=function(){return new Ye},e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"Funnel Series\"))},e.prototype.createDataItem=function(){return new je},e.prototype.initSlice=function(t){t.isMeasured=!1,t.defaultState.properties.scale=1,t.observe(\"scale\",this.handleSliceScale,this),t.observe([\"dx\",\"dy\",\"x\",\"y\"],this.handleSliceMove,this),t.tooltipText=\"{category}: {value.percent.formatNumber('#.#')}% ({value.value})\",t.states.create(\"hover\").properties.expandDistance=.2},e.prototype.initLabel=function(e){t.prototype.initLabel.call(this,e),e.verticalCenter=\"middle\",e.horizontalCenter=\"middle\",e.isMeasured=!0,e.padding(5,5,5,5)},e.prototype.validate=function(){t.prototype.validate.call(this),this._nextY=0},e.prototype.validateDataElements=function(){var e=this.slicesContainer,i=this.labelsContainer,a=this.labels.template;this.alignLabels?(a.interactionsEnabled=!0,e.isMeasured=!0,i.isMeasured=!0):(a.interactionsEnabled=!1,e.isMeasured=!1,i.isMeasured=!1);var n=0,r=0;this.dataItems.each(function(t){y.hasValue(t.value)&&(r++,t.value>0?n+=t.getWorkingValue(\"value\")/t.value:n+=1)}),this._total=1/r*n,this._count=r,t.prototype.validateDataElements.call(this),this.arrangeLabels()},e.prototype.getNextValue=function(t){var e=t.index,i=t.getWorkingValue(\"value\");if(e<this.dataItems.length-1){var a=this.dataItems.getIndex(e+1);if(i=a.getWorkingValue(\"value\"),!a.visible||a.isHiding)return this.getNextValue(a)}return i},e.prototype.formDataElement=function(){},e.prototype.validateDataElement=function(e){if(y.hasValue(e.value)){var i=e.slice;i.orientation=this.orientation;var a=e.sliceLink;a.orientation=this.orientation;var n=e.tick,r=e.label;n.slice=i,n.label=r,this.decorateSlice(e),a.fill=i.fill,e.index==this.dataItems.length-1&&(a.disabled=!0),t.prototype.validateDataElement.call(this,e)}},e.prototype.decorateSlice=function(t){var e=t.slice,i=t.sliceLink,a=t.label,n=t.tick,r=this.slicesContainer.innerWidth,s=this.slicesContainer.innerHeight,o=this.getNextValue(t),l=t.getWorkingValue(\"value\"),h=this.bottomRatio,u=1;if(t.value>0&&(u=l/t.value),\"vertical\"==this.orientation){var c=i.pixelHeight*u;s+=c,e.topWidth=l/this.dataItem.values.value.high*r,e.bottomWidth=(l-(l-o)*h)/this.dataItem.values.value.high*r,i.topWidth=e.bottomWidth,i.bottomWidth=(l-(l-o))/this.dataItem.values.value.high*r,e.y=this._nextY,e.height=m.max(0,s/this._count*u/this._total-c),e.x=r/2,this.alignLabels?a.x=void 0:a.x=e.x,a.y=e.pixelY+e.pixelHeight*n.locationY,this._nextY+=e.pixelHeight+c,i.y=this._nextY-c,i.x=e.x}else{var d=i.pixelWidth*u;r+=d,e.topWidth=l/this.dataItem.values.value.high*s,e.bottomWidth=(l-(l-o)*h)/this.dataItem.values.value.high*s,i.topWidth=e.bottomWidth,i.bottomWidth=(l-(l-o))/this.dataItem.values.value.high*s,e.x=this._nextY,e.width=r/this._count*u*1/this._total-d,e.y=s/2,this.alignLabels?a.y=this.labelsContainer.measuredHeight:a.y=e.y,a.x=e.pixelX+e.pixelWidth*n.locationX,this._nextY+=e.pixelWidth+d,i.x=this._nextY-d,i.y=e.y}},e.prototype.arrangeLabels=function(){if(this.alignLabels){var t=this.labels.length;if(t>1){var e=this.labels.getIndex(t-1),i=e.pixelY,a=e.pixelX;if(t>1){for(var n=t-2;n>=0;n--){(r=this.labels.getIndex(n)).visible&&(r.invalid&&r.validate(),\"vertical\"==this.orientation?r.pixelY+r.measuredHeight>i&&(r.y=i-r.measuredHeight):r.pixelX+r.measuredWidth>a&&(r.x=a-r.measuredWidth),i=r.pixelY,a=r.pixelX)}i=0,a=0;for(n=0;n<t;n++){var r;(r=this.labels.getIndex(n)).visible&&(r.invalid&&r.validate(),\"vertical\"==this.orientation?r.pixelY<i&&(r.y=i):r.pixelX<a&&(r.x=a),i+=r.measuredHeight,a+=r.measuredWidth)}}}}},e.prototype.positionBullet=function(e){t.prototype.positionBullet.call(this,e);var i=e.dataItem.slice,a=e.locationX;y.isNumber(a)||(a=.5);var n=e.locationY;y.isNumber(n)||(n=1),e.x=i.pixelX+i.measuredWidth*a,e.y=i.pixelY+i.measuredHeight*n},Object.defineProperty(e.prototype,\"orientation\",{get:function(){return this.getPropertyValue(\"orientation\")},set:function(t){this.setPropertyValue(\"orientation\",t)&&(this.labelsOpposite=this.labelsOpposite,this.invalidate(),\"vertical\"==t?(this.ticks.template.locationX=1,this.ticks.template.locationY=.5,this.labels.template.rotation=0,this.layout=\"horizontal\"):(this.ticks.template.locationX=.5,this.ticks.template.locationY=1,this.labels.template.rotation=-90,this.layout=\"vertical\"))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"bottomRatio\",{get:function(){return this.getPropertyValue(\"bottomRatio\")},set:function(t){this.setPropertyValue(\"bottomRatio\",t)&&this.invalidate()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"sliceLinks\",{get:function(){if(!this._sliceLinks){var t=new Le;t.applyOnClones=!0,t.fillOpacity=.5,t.expandDistance=-.3,t.hiddenState.properties.opacity=0,this._disposers.push(t),this._sliceLinks=new o.e(t),this._disposers.push(new o.c(this._sliceLinks))}return this._sliceLinks},enumerable:!0,configurable:!0}),e.prototype.show=function(e){var i=this,a=this.startIndex,n=this.endIndex,r=this.defaultState.transitionDuration;y.isNumber(e)&&(r=e);var s=0;return g.each(g.indexed(this.dataItems.iterator()),function(t){var e=t[0],o=t[1];i.sequencedInterpolation&&(s=i.sequencedInterpolationDelay*e+r*(e-a)/(n-a)),o.show(r,s,[\"value\"])}),t.prototype.show.call(this,e)},e.prototype.hide=function(e){var i=this,a=[\"value\"],n=this.startIndex,r=this.endIndex,s=0,o=this.hiddenState.transitionDuration;y.isNumber(e)&&(o=e),g.each(g.indexed(this.dataItems.iterator()),function(t){var e=t[0],l=t[1];i.sequencedInterpolation&&(s=i.sequencedInterpolationDelay*e+o*(e-n)/(r-n)),l.hide(o,s,0,a)});var l=t.prototype.hide.call(this,e);return l&&!l.isFinished()&&l.delay(s),l},e.prototype.setAlignLabels=function(e){t.prototype.setAlignLabels.call(this,e),this.ticks.template.disabled=!e;var i=this.labelsContainer;i&&(e?(i.height=void 0,i.width=void 0,i.margin(10,10,10,10)):(i.width=Object(Y.c)(100),i.height=Object(Y.c)(100))),this.labelsOpposite=this.labelsOpposite},Object.defineProperty(e.prototype,\"labelsOpposite\",{get:function(){return this.getPropertyValue(\"labelsOpposite\")},set:function(t){this.setPropertyValue(\"labelsOpposite\",t);var e=this.labels.template,i=\"none\",a=\"none\";this.alignLabels?t?(this.labelsContainer.toFront(),\"vertical\"==this.orientation?(this.ticks.template.locationX=1,e.horizontalCenter=\"left\",i=\"right\"):(this.ticks.template.locationY=1,e.horizontalCenter=\"right\",a=\"bottom\")):(this.labelsContainer.toBack(),\"vertical\"==this.orientation?(this.ticks.template.locationX=0,i=\"left\"):(a=\"top\",this.ticks.template.locationY=0)):\"vertical\"==this.orientation?i=\"center\":a=\"middle\",e.align=i,e.valign=a,this.validateLayout(),this.ticks.each(function(t){t.invalidate()}),this.invalidateDataItems()},enumerable:!0,configurable:!0}),e}(Re.a);c.b.registeredClasses.FunnelSeries=Ne,c.b.registeredClasses.FunnelSeriesDataItem=je;var Me=function(t){function e(){var e=t.call(this)||this;return e.className=\"PyramidSeriesDataItem\",e.applyTheme(),e}return n.c(e,t),e}(je),We=function(t){function e(){var e=t.call(this)||this;return e.className=\"PyramidSeries\",e.topWidth=Object(Y.c)(0),e.bottomWidth=Object(Y.c)(100),e.pyramidHeight=Object(Y.c)(100),e.valueIs=\"area\",e.sliceLinks.template.width=0,e.sliceLinks.template.height=0,e.applyTheme(),e}return n.c(e,t),e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"Pyramid Series\"))},e.prototype.createDataItem=function(){return new Me},e.prototype.validate=function(){t.prototype.validate.call(this),this._nextWidth=void 0},e.prototype.getNextValue=function(t){var e=t.index,i=t.getWorkingValue(\"value\");e<this.dataItems.length-1&&(i=this.dataItems.getIndex(e+1).getWorkingValue(\"value\"));return 0==i&&(i=1e-6),i},e.prototype.validateDataElements=function(){var e=this,i=this.slicesContainer.innerWidth,a=this.slicesContainer.innerHeight;if(this.dataItems.each(function(t){var n=t.getWorkingValue(\"value\")/t.value,r=t.sliceLink;\"vertical\"==e.orientation?a-=r.pixelHeight*n:i-=r.pixelWidth*n}),this._pyramidHeight=k.relativeToValue(this.pyramidHeight,a),this._pyramidWidth=k.relativeToValue(this.pyramidHeight,i),\"vertical\"==this.orientation){var n=(a-this._pyramidHeight)/2;this.slicesContainer.y=n,this.labelsContainer.y=n,this.ticksContainer.y=n}else{var r=(i-this._pyramidWidth)/2;this.slicesContainer.x=r,this.labelsContainer.x=r,this.ticksContainer.x=r}t.prototype.validateDataElements.call(this)},e.prototype.decorateSlice=function(t){var e=this.dataItem.values.value.sum;if(0!=e){var i=t.slice,a=t.sliceLink,n=t.label,r=t.tick;this.getNextValue(t);var s=t.getWorkingValue(\"value\");0==s&&(s=1e-6);var o=this._pyramidWidth,l=this._pyramidHeight,h=this.slicesContainer.innerWidth,u=this.slicesContainer.innerHeight,c=a.pixelWidth,d=a.pixelHeight;if(\"vertical\"==this.orientation){var p=k.relativeToValue(this.topWidth,h);y.isNumber(this._nextWidth)||(this._nextWidth=p);var g=k.relativeToValue(this.bottomWidth,h),m=this._nextWidth,f=Math.atan2(l,p-g);0==(A=Math.tan(Math.PI/2-f))&&(A=1e-8);var x=void 0,v=void 0;if(\"area\"==this.valueIs){var b=(p+g)/2*l*s/e,P=Math.abs(m*m-2*b*A);v=(2*b-(x=(m-Math.sqrt(P))/A)*m)/x}else{v=m-(x=l*s/this.dataItem.values.value.sum)*A}i.height=x,i.width=h,i.bottomWidth=v,i.topWidth=m,a.topWidth=i.bottomWidth,a.bottomWidth=i.bottomWidth,i.y=this._nextY,this.alignLabels?n.x=0:n.x=h/2,n.y=i.pixelY+i.pixelHeight*r.locationY+i.dy,this._nextY+=i.pixelHeight+d*s/t.value,a.y=this._nextY-d,a.x=h/2}else{p=k.relativeToValue(this.topWidth,u);y.isNumber(this._nextWidth)||(this._nextWidth=p);var A;g=k.relativeToValue(this.bottomWidth,u),m=this._nextWidth,f=Math.atan2(o,p-g);0==(A=Math.tan(Math.PI/2-f))&&(A=1e-8);var C=void 0;v=void 0;if(\"area\"==this.valueIs)v=(2*(b=(p+g)/2*o*s/this.dataItem.values.value.sum)-(C=(m-Math.sqrt(m*m-2*b*A))/A)*m)/C;else v=m-(C=o*s/this.dataItem.values.value.sum)*A;i.width=C,i.height=u,i.bottomWidth=v,i.topWidth=m,a.topWidth=i.bottomWidth,a.bottomWidth=i.bottomWidth,i.x=this._nextY,this.alignLabels?n.y=this.labelsContainer.measuredHeight:n.y=u/2,n.x=i.pixelX+i.pixelWidth*r.locationX+i.dx,this._nextY+=i.pixelWidth+c*s/t.value,a.x=this._nextY-c,a.y=u/2}this._nextWidth=i.bottomWidth}},Object.defineProperty(e.prototype,\"topWidth\",{get:function(){return this.getPropertyValue(\"topWidth\")},set:function(t){this.setPercentProperty(\"topWidth\",t,!1,!1,10,!1)&&this.invalidate()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"pyramidHeight\",{get:function(){return this.getPropertyValue(\"pyramidHeight\")},set:function(t){this.setPercentProperty(\"pyramidHeight\",t,!1,!1,10,!1)&&this.invalidate()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"bottomWidth\",{get:function(){return this.getPropertyValue(\"bottomWidth\")},set:function(t){this.setPercentProperty(\"bottomWidth\",t,!1,!1,10,!1)&&this.invalidate()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"valueIs\",{get:function(){return this.getPropertyValue(\"valueIs\")},set:function(t){this.setPropertyValue(\"valueIs\",t)&&this.invalidate()},enumerable:!0,configurable:!0}),e}(Ne);c.b.registeredClasses.PyramidSeries=We,c.b.registeredClasses.PyramidSeriesDataItem=Me;var Be=function(t){function e(){var e=t.call(this)||this;return e.className=\"PictorialStackedSeriesDataItem\",e.applyTheme(),e}return n.c(e,t),e}(Me),Ee=function(t){function e(){var e=t.call(this)||this;return e.className=\"PictorialStackedSeries\",e.topWidth=Object(Y.c)(100),e.bottomWidth=Object(Y.c)(100),e.valueIs=\"height\",e.applyTheme(),e.startLocation=0,e.endLocation=1,e._maskSprite=e.slicesContainer.createChild(S.a),e._maskSprite.visible=!1,e._maskSprite.zIndex=100,e._maskSprite.shouldClone=!1,e}return n.c(e,t),e.prototype.validateDataElements=function(){var e=this.slicesContainer.maxWidth,i=this.slicesContainer.maxHeight,a=this._maskSprite,n=a.measuredWidth/a.scale,r=a.measuredHeight/a.scale,s=m.min(i/r,e/n);s==1/0&&(s=1),s=m.max(.001,s);var o=this.startLocation,l=this.endLocation,h=m.min(e,n*s),u=m.min(i,r*s);if(a.scale=s,\"vertical\"==this.orientation?(this.topWidth=h+4,this.bottomWidth=h+4,this.pyramidHeight=u*(l-o),a.x=e/2,a.y=u/2):(this.topWidth=u+4,this.bottomWidth=u+4,this.pyramidHeight=h*(l-o),a.valign=\"middle\",a.x=h/2,a.y=i/2),a.verticalCenter=\"middle\",a.horizontalCenter=\"middle\",t.prototype.validateDataElements.call(this),\"vertical\"==this.orientation){var c=(i-u)/2;this.slicesContainer.y=c,this.labelsContainer.y=c,this.ticksContainer.y=c,this.slices.template.dy=o*u}else{var d=(e-h)/2;this.slicesContainer.x=d,this.labelsContainer.x=d,this.ticksContainer.x=d,this.slices.template.dx=o*h}this.slicesContainer.mask=this._maskSprite},e.prototype.applyInternalDefaults=function(){t.prototype.applyInternalDefaults.call(this),y.hasValue(this.readerTitle)||(this.readerTitle=this.language.translate(\"Pyramid Series\"))},e.prototype.createDataItem=function(){return new Be},Object.defineProperty(e.prototype,\"maskSprite\",{get:function(){return this._maskSprite},enumerable:!0,configurable:!0}),e.prototype.initSlice=function(e){t.prototype.initSlice.call(this,e);var i=e.states.getKey(\"hover\");i&&(i.properties.expandDistance=0)},Object.defineProperty(e.prototype,\"startLocation\",{get:function(){return this.getPropertyValue(\"startLocation\")},set:function(t){this.setPropertyValue(\"startLocation\",t)&&this.invalidateDataItems()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"endLocation\",{get:function(){return this.getPropertyValue(\"endLocation\")},set:function(t){this.setPropertyValue(\"endLocation\",t)&&this.invalidateDataItems()},enumerable:!0,configurable:!0}),e}(We);c.b.registeredClasses.PictorialStackedSeries=Ee,c.b.registeredClasses.PictorialStackedSeriesDataItem=Be;var He=i(\"BmDP\"),ze=i(\"ncT3\"),Ue=function(t){function e(){var e=t.call(this)||this;return e.className=\"ConeColumn\",e}return n.c(e,t),e.prototype.createAssets=function(){this.coneColumn=this.createChild(ze.a),this.coneColumn.shouldClone=!1,this.column=this.coneColumn},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.coneColumn&&this.coneColumn.copyFrom(e.coneColumn)},e}(se);c.b.registeredClasses.ConeColumn=Ue;var Ke=function(t){function e(){var e=t.call(this)||this;return e.className=\"ConeSeriesDataItem\",e.applyTheme(),e}return n.c(e,t),e}(oe),Ge=function(t){function e(){var e=t.call(this)||this;return e.className=\"ConeSeries\",e.applyTheme(),e}return n.c(e,t),e.prototype.createColumnTemplate=function(){return new Ue},e.prototype.getMaskPath=function(){var t=0,e=0,i=this.columns.getIndex(0);if(i)return this.baseAxis==this.xAxis?e=i.coneColumn.bottom.radiusY+1:t=i.coneColumn.bottom.radiusY+1,w.rectToPath({x:-t,y:0,width:this.xAxis.axisLength+t,height:this.yAxis.axisLength+e})},e.prototype.validateDataElementReal=function(e){if(t.prototype.validateDataElementReal.call(this,e),e.column){var i=e.column.coneColumn;i.fill=e.column.fill,this.baseAxis==this.yAxis?i.orientation=\"horizontal\":i.orientation=\"vertical\"}},e}(le);c.b.registeredClasses.ConeSeries=Ge,c.b.registeredClasses.ConeSeriesDataItem=Ke;var qe=function(t){function e(){var e=t.call(this)||this;return e.className=\"CurvedColumn\",e}return n.c(e,t),e.prototype.createAssets=function(){this.curvedColumn=this.createChild(S.a),this.curvedColumn.shouldClone=!1,this.setPropertyValue(\"tension\",.7),this.width=Object(Y.c)(120),this.height=Object(Y.c)(120),this.column=this.curvedColumn},e.prototype.draw=function(){t.prototype.draw.call(this);var e,i=this.realWidth,a=this.realHeight,n=this.realX-this.pixelX,r=this.realY-this.pixelY;k.used(this.width);var s=1,o=1;\"vertical\"==this.orientation?(s=this.tension,e=[{x:0,y:a+r},{x:i/2,y:r},{x:i,y:a+r}]):(o=this.tension,e=[{x:n,y:0},{x:n+i,y:a/2},{x:n,y:a}]);var l=w.moveTo(e[0])+new Z.b(s,o).smooth(e);this.column.path=l},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.curvedColumn&&this.curvedColumn.copyFrom(e.curvedColumn)},Object.defineProperty(e.prototype,\"tension\",{get:function(){return this.getPropertyValue(\"tension\")},set:function(t){this.setPropertyValue(\"tension\",t,!0)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,\"orientation\",{get:function(){return this.getPropertyValue(\"orientation\")},set:function(t){this.setPropertyValue(\"orientation\",t,!0)},enumerable:!0,configurable:!0}),e}(se);c.b.registeredClasses.CurvedColumn=qe;var Ze=function(t){function e(){var e=t.call(this)||this;return e.className=\"CurvedColumnSeriesDataItem\",e.applyTheme(),e}return n.c(e,t),e}(oe),Je=function(t){function e(){var e=t.call(this)||this;return e.className=\"CurvedColumnSeries\",e.applyTheme(),e}return n.c(e,t),e.prototype.createColumnTemplate=function(){return new qe},e.prototype.validateDataElementReal=function(e){t.prototype.validateDataElementReal.call(this,e);var i=e.column;(i=e.column)&&(e.column.curvedColumn.fill=e.column.fill,this.baseAxis==this.yAxis?i.orientation=\"horizontal\":i.orientation=\"vertical\")},e}(le);c.b.registeredClasses.CurvedColumnSeries=Je,c.b.registeredClasses.CurvedColumnSeriesDataItem=Ze;var Qe=i(\"eN1s\"),$e=i(\"TDx+\"),ti=i(\"eAid\"),ei=function(t){function e(){var e=t.call(this)||this;return e.className=\"DurationAxisDataItem\",e.applyTheme(),e}return n.c(e,t),e}(l.b),ii=function(t){function e(){var e=t.call(this)||this;return e._baseUnit=\"second\",e.className=\"DurationAxis\",e.setPropertyValue(\"maxZoomFactor\",1e6),e.applyTheme(),e}return n.c(e,t),e.prototype.formatLabel=function(t,e){return this.durationFormatter.format(t,e||this.axisDurationFormat)},e.prototype.adjustMinMax=function(e,i,a,r,s){var o,l,h,u=this.baseUnit;if(this.setPropertyValue(\"maxPrecision\",0),\"millisecond\"==u||\"second\"==u||\"minute\"==u||\"hour\"==u){r<=1&&(r=1),r=Math.round(r);var c=e,d=i;0===a&&(a=Math.abs(i));var p,y=[60,30,20,15,10,2,1],g=1;\"hour\"==u&&(y=[24,12,6,4,2,1]);try{for(var f=n.g(y),x=f.next();!x.done;x=f.next()){var v=x.value;if(a/v>r){g=v;break}}}catch(t){l={error:t}}finally{try{x&&!x.done&&(h=f.return)&&h.call(f)}finally{if(l)throw l.error}}var b=Math.ceil((i-e)/g/r),P=Math.log(Math.abs(b))*Math.LOG10E,A=Math.pow(10,Math.floor(P))/10,C=b/A;p=g*(b=m.closest(y,C)*A),this.durationFormatter.getValueUnit(p,this.baseUnit),e=Math.floor(e/p)*p,i=Math.ceil(i/p)*p,s&&((e-=p)<0&&c>=0&&(e=0),(i+=p)>0&&d<=0&&(i=0)),o={min:e,max:i,step:p}}else o=t.prototype.adjustMinMax.call(this,e,i,a,r,s);return this.axisDurationFormat=this.durationFormatter.getFormat(o.step,o.max,this.baseUnit),o},Object.defineProperty(e.prototype,\"tooltipDurationFormat\",{get:function(){return this._tooltipDurationFormat},set:function(t){this._tooltipDurationFormat=t},enumerable:!0,configurable:!0}),e.prototype.getTooltipText=function(t){var e=m.round(this.positionToValue(t),this._stepDecimalPlaces);return this.adapter.apply(\"getTooltipText\",this.formatLabel(e,this.tooltipDurationFormat))},Object.defineProperty(e.prototype,\"baseUnit\",{get:function(){return this._baseUnit},set:function(t){this._baseUnit!=t&&(this._baseUnit=t,this.durationFormatter.baseUnit=t,this.invalidate())},enumerable:!0,configurable:!0}),e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.baseUnit=e.baseUnit},e}(l.a);c.b.registeredClasses.DurationAxis=ii,c.b.registeredClasses.DurationAxisDataItem=ei;var ai=function(t){function e(){var e=t.call(this)||this;e.className=\"CircleBullet\";var i=e.createChild(st.a);return i.shouldClone=!1,i.radius=5,i.isMeasured=!1,e.circle=i,e.applyTheme(),e}return n.c(e,t),e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.circle.copyFrom(e.circle)},e}(et.a);c.b.registeredClasses.CircleBullet=ai;var ni=function(t){function e(){var e=t.call(this)||this;return e.className=\"ErrorBullet\",e.errorLine=e.createChild(S.a),e.errorLine.shouldClone=!1,e.width=20,e.height=20,e.strokeOpacity=1,e.isDynamic=!0,e}return n.c(e,t),e.prototype.validatePosition=function(){t.prototype.validatePosition.call(this);var e=this.pixelWidth/2,i=this.pixelHeight/2;this.errorLine.path=w.moveTo({x:-e,y:-i})+w.lineTo({x:e,y:-i})+w.moveTo({x:0,y:-i})+w.lineTo({x:0,y:i})+w.moveTo({x:-e,y:i})+w.lineTo({x:e,y:i})},e.prototype.copyFrom=function(e){t.prototype.copyFrom.call(this,e),this.errorLine.copyFrom(e.errorLine)},e}(et.a);c.b.registeredClasses.ErrorBullet=ni;var ri=i(\"Y9w3\"),si=i(\"A6AV\"),oi=i(\"Trvg\"),li=i(\"Rnbi\"),hi=function(t){function e(){var e=t.call(this)||this;return e.className=\"NavigationBarDataItem\",e.applyTheme(),e}return n.c(e,t),Object.defineProperty(e.prototype,\"name\",{get:function(){return this.properties.name},set:function(t){this.setProperty(\"name\",t)},enumerable:!0,configurable:!0}),e}(si.a),ui=function(t){function e(){var e=t.call(this)||this;e.className=\"NavigationBar\";var i=new W.a,a=new oi.a;a.valign=\"middle\",a.paddingTop=8,a.paddingBottom=8,e.paddingBottom=2,e.links=new o.e(a),e._disposers.push(new o.c(e.links)),e._disposers.push(a),e._linksIterator=new g.ListIterator(e.links,function(){return e.links.create()}),e._linksIterator.createNewItems=!0;var n=new li.a;n.direction=\"right\",n.width=8,n.height=12,n.fill=i.getFor(\"alternativeBackground\"),n.fillOpacity=.5,n.valign=\"middle\",n.marginLeft=10,n.marginRight=10,e.separators=new o.e(n),e._disposers.push(new o.c(e.separators)),e._disposers.push(n);var r=new oi.a;return e.activeLink=r,r.copyFrom(a),r.valign=\"middle\",r.fontWeight=\"bold\",e.width=Object(Y.c)(100),e.layout=\"grid\",e.dataFields.name=\"name\",e.applyTheme(),e}return n.c(e,t),e.prototype.validateDataElements=function(){this.removeChildren(),this._linksIterator.reset(),t.prototype.validateDataElements.call(this)},e.prototype.validateDataElement=function(e){var i;if(t.prototype.validateDataElement.call(this,e),e.index<this.dataItems.length-1){(i=this._linksIterator.getLast()).parent=this;var a=this.separators.create();a.parent=this,a.valign=\"middle\"}else(i=this.activeLink).events.copyFrom(this.links.template.events),i.hide(0),i.show(),i.parent=this;i.dataItem=e,i.text=e.name,i.validate()},e}(ri.a);c.b.registeredClasses.NavigationBar=ui,c.b.registeredClasses.NavigationBarDataItem=hi,window.am4charts=a}},[\"XFs4\"]);\n//# sourceMappingURL=charts.js.map"}
}});
