require.config({"config": {
        "jsbuild":{"Magento_ProductVideo/js/get-video-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate'\n], function ($, alert) {\n        'use strict';\n\n        var videoRegister = {\n            _register: {},\n\n            /**\n             * Checks, if api is already registered\n             *\n             * @param {String} api\n             * @returns {bool}\n             */\n            isRegistered: function (api) {\n                return this._register[api] !== undefined;\n            },\n\n            /**\n             * Checks, if api is loaded\n             *\n             * @param {String} api\n             * @returns {bool}\n             */\n            isLoaded: function (api) {\n                return this._register[api] !== undefined && this._register[api] === true;\n            },\n\n            /**\n             * Register new video api\n             * @param {String} api\n             * @param {bool} loaded\n             */\n            register: function (api, loaded) {\n                loaded = loaded || false;\n                this._register[api] = loaded;\n            }\n        };\n\n        $.widget('mage.productVideoLoader', {\n\n            /**\n             * @private\n             */\n            _create: function () {\n                switch (this.element.data('type')) {\n                    case 'youtube':\n                        this.element.videoYoutube();\n                        this._player = this.element.data('mageVideoYoutube');\n                        break;\n\n                    case 'vimeo':\n                        this.element.videoVimeo();\n                        this._player = this.element.data('mageVideoVimeo');\n                        break;\n                    default:\n                        throw {\n                            name: $.mage.__('Video Error'),\n                            message: $.mage.__('Unknown video type'),\n\n                            /**\n                             * Return string\n                             */\n                            toString: function () {\n                                return this.name + ': ' + this.message;\n                            }\n                        };\n                }\n            },\n\n            /**\n             * Initializes variables\n             * @private\n             */\n            _initialize: function () {\n                this._params = this.element.data('params') || {};\n                this._code = this.element.data('code');\n                this._width = this.element.data('width');\n                this._height = this.element.data('height');\n                this._autoplay = !!this.element.data('autoplay');\n                this._playing = this._autoplay || false;\n                this.useYoutubeNocookie = this.element.data('youtubenocookie') || false;\n\n                this._responsive = this.element.data('responsive') !== false;\n\n                if (this._responsive === true) {\n                    this.element.addClass('responsive');\n                }\n\n                this._calculateRatio();\n            },\n\n            /**\n             * Abstract play command\n             */\n            play: function () {\n                this._player.play();\n            },\n\n            /**\n             * Abstract pause command\n             */\n            pause: function () {\n                this._player.pause();\n            },\n\n            /**\n             * Abstract stop command\n             */\n            stop: function () {\n                this._player.stop();\n            },\n\n            /**\n             * Abstract playing command\n             */\n            playing: function () {\n                return this._player.playing();\n            },\n\n            /**\n             * Abstract destroying command\n             */\n            destroy: function () {\n                if (this._player) {\n                    this._player.destroy();\n                }\n            },\n\n            /**\n             * Calculates ratio for responsive videos\n             * @private\n             */\n            _calculateRatio: function () {\n                if (!this._responsive) {\n                    return;\n                }\n                this.element.css('paddingBottom', this._height / this._width * 100 + '%');\n            }\n        });\n\n        $.widget('mage.videoYoutube', $.mage.productVideoLoader, {\n\n            /**\n             * Initialization of the Youtube widget\n             * @private\n             */\n            _create: function () {\n                var self = this;\n\n                this._initialize();\n\n                this.element.append('<div></div>');\n\n                this._on(window, {\n\n                    /**\n                     * Youtube state check\n                     * @private\n                     */\n                    'youtubeapiready': function () {\n                        var host = 'https://www.youtube.com';\n\n                        if (self.useYoutubeNocookie) {\n                            host = 'https://www.youtube-nocookie.com';\n                        }\n\n                        if (self._player !== undefined) {\n                            return;\n                        }\n\n                        if (self._autoplay) {\n                            self._params.autoplay = 1;\n                        }\n                        self._params.rel = 0;\n\n                        self._player = new window.YT.Player(self.element.children(':first')[0], {\n                            height: self._height,\n                            width: self._width,\n                            videoId: self._code,\n                            playerVars: self._params,\n                            host: host,\n                            events: {\n\n                                /**\n                                 * @private\n                                 */\n                                'onReady': function onPlayerReady() {\n                                    self._player.getDuration();\n                                },\n\n                                /**\n                                 * State change flag init\n                                 */\n                                onStateChange: function (data) {\n                                    switch (window.parseInt(data.data, 10)) {\n                                        case 1:\n                                            self._playing = true;\n                                            break;\n                                        default:\n                                            self._playing = false;\n                                            break;\n                                    }\n\n                                    self._trigger('statechange', {}, data);\n                                }\n                            }\n\n                        });\n                    }\n                });\n\n                this._loadApi();\n            },\n\n            /**\n             * Loads Youtube API and triggers event, when loaded\n             * @private\n             */\n            _loadApi: function () {\n                var element,\n                    scriptTag;\n\n                if (videoRegister.isRegistered('youtube')) {\n                    if (videoRegister.isLoaded('youtube')) {\n                        $(window).trigger('youtubeapiready');\n                    }\n\n                    return;\n                }\n                videoRegister.register('youtube');\n\n                element = document.createElement('script');\n                scriptTag = document.getElementsByTagName('script')[0];\n\n                element.async = true;\n                element.src = 'https://www.youtube.com/iframe_api';\n                scriptTag.parentNode.insertBefore(element, scriptTag);\n\n                /**\n                 * Trigger youtube api ready event\n                 */\n                window.onYouTubeIframeAPIReady = function () {\n                    $(window).trigger('youtubeapiready');\n                    videoRegister.register('youtube', true);\n                };\n            },\n\n            /**\n             * Play command for Youtube\n             */\n            play: function () {\n                this._player.playVideo();\n                this._playing = true;\n            },\n\n            /**\n             * Pause command for Youtube\n             */\n            pause: function () {\n                this._player.pauseVideo();\n                this._playing = false;\n            },\n\n            /**\n             * Stop command for Youtube\n             */\n            stop: function () {\n                this._player.stopVideo();\n                this._playing = false;\n            },\n\n            /**\n             * Playing command for Youtube\n             */\n            playing: function () {\n                return this._playing;\n            },\n\n            /**\n             * stops and unloads player\n             * @private\n             */\n            destroy: function () {\n                if (this._player) {\n                    this.stop();\n                    this._player.destroy();\n                    this._player = undefined;\n                }\n            }\n        });\n\n        $.widget('mage.videoVimeo', $.mage.productVideoLoader, {\n\n            /**\n             * Initialize the Vimeo widget\n             * @private\n             */\n            _create: function () {\n                var timestamp,\n                    src,\n                    additionalParams;\n\n                this._initialize();\n                timestamp = new Date().getTime();\n\n                if (this._autoplay) {\n                    additionalParams += '&autoplay=1';\n                }\n\n                src = 'https://player.vimeo.com/video/' +\n                    this._code + '?api=1&player_id=vimeo' +\n                    this._code +\n                    timestamp +\n                    additionalParams;\n                this.element.append(\n                    $('<iframe></iframe>')\n                        .attr('frameborder', 0)\n                        .attr('id', 'vimeo' + this._code + timestamp)\n                        .attr('width', this._width)\n                        .attr('height', this._height)\n                        .attr('src', src)\n                );\n\n            }\n        });\n\n        $.widget('mage.videoData', {\n            options: {\n                youtubeKey: '',\n                eventSource: '' //where is data going from - focus out or click on button\n            },\n\n            _REQUEST_VIDEO_INFORMATION_TRIGGER: 'request_video_information',\n\n            _UPDATE_VIDEO_INFORMATION_TRIGGER: 'updated_video_information',\n\n            _START_UPDATE_INFORMATION_TRIGGER: 'update_video_information',\n\n            _ERROR_UPDATE_INFORMATION_TRIGGER: 'error_updated_information',\n\n            _FINISH_UPDATE_INFORMATION_TRIGGER: 'finish_update_information',\n\n            _VIDEO_URL_VALIDATE_TRIGGER: 'validate_video_url',\n\n            _videoInformation: null,\n\n            _currentVideoUrl: null,\n\n            /**\n             * @private\n             */\n            _init: function () {\n                this.element.on(this._START_UPDATE_INFORMATION_TRIGGER, $.proxy(this._onRequestHandler, this));\n                this.element.on(this._ERROR_UPDATE_INFORMATION_TRIGGER, $.proxy(this._onVideoInvalid, this));\n                this.element.on(this._FINISH_UPDATE_INFORMATION_TRIGGER, $.proxy(\n                    function () {\n                        this._currentVideoUrl = null;\n                    }, this\n                ));\n                this.element.on(this._VIDEO_URL_VALIDATE_TRIGGER, $.proxy(this._onUrlValidateHandler, this));\n            },\n\n            /**\n             * @private\n             */\n            _onUrlValidateHandler: function (event, callback, forceVideo) {\n                var url = this.element.val(),\n                    videoInfo;\n\n                videoInfo = this._validateURL(url, forceVideo);\n\n                if (videoInfo) {\n                    callback();\n                } else {\n                    this._onRequestError($.mage.__('Invalid video url'));\n                }\n            },\n\n            /**\n             * @private\n             */\n            _onRequestHandler: function () {\n                var url = this.element.val(),\n                    self = this,\n                    videoInfo,\n                    type,\n                    id,\n                    googleapisUrl;\n\n                if (this._currentVideoUrl === url) {\n                    return;\n                }\n\n                this._currentVideoUrl = url;\n\n                this.element.trigger(this._REQUEST_VIDEO_INFORMATION_TRIGGER, {\n                    url: url\n                });\n\n                if (!url) {\n                    return;\n                }\n\n                videoInfo = this._validateURL(url);\n\n                if (!videoInfo) {\n                    this._onRequestError($.mage.__('Invalid video url'));\n\n                    return;\n                }\n\n                /**\n                 *\n                 * @param {Object} data\n                 * @private\n                 */\n                function _onYouTubeLoaded(data) {\n                    var tmp,\n                        uploadedFormatted,\n                        respData,\n                        createErrorMessage;\n\n                    /**\n                     * Create errors message\n                     *\n                     * @returns {String}\n                     */\n                    createErrorMessage = function () {\n                        var error = data.error,\n                            errors = error.errors,\n                            i,\n                            errLength = errors.length,\n                            tmpError,\n                            errReason,\n                            errorsMessage = [];\n\n                        for (i = 0; i < errLength; i++) {\n                            tmpError = errors[i];\n                            errReason = tmpError.reason;\n\n                            if (['keyInvalid'].indexOf(errReason) !== -1) {\n                                errorsMessage.push($.mage.__('Youtube API key is invalid'));\n\n                                break;\n                            }\n\n                            errorsMessage.push(tmpError.message);\n                        }\n\n                        return $.mage.__('Video cant be shown due to the following reason: ') +\n                            $.unique(errorsMessage).join(', ');\n                    };\n\n                    if (data.error && [400, 402, 403].indexOf(data.error.code) !== -1) {\n                        this._onRequestError(createErrorMessage());\n\n                        return;\n                    }\n\n                    if (!data.items || data.items.length < 1) {\n                        this._onRequestError($.mage.__('Video not found'));\n\n                        return;\n                    }\n\n                    tmp = data.items[0];\n                    uploadedFormatted = tmp.snippet.publishedAt.replace('T', ' ').replace(/\\..+/g, '');\n                    respData = {\n                        duration: this._formatYoutubeDuration(tmp.contentDetails.duration),\n                        channel: tmp.snippet.channelTitle,\n                        channelId: tmp.snippet.channelId,\n                        uploaded: uploadedFormatted,\n                        title: tmp.snippet.localized.title,\n                        description: tmp.snippet.description,\n                        thumbnail: tmp.snippet.thumbnails.high.url,\n                        videoId: videoInfo.id,\n                        videoProvider: videoInfo.type,\n                        useYoutubeNocookie: videoInfo.useYoutubeNocookie\n                    };\n                    this._videoInformation = respData;\n                    this.element.trigger(this._UPDATE_VIDEO_INFORMATION_TRIGGER, respData);\n                    this.element.trigger(this._FINISH_UPDATE_INFORMATION_TRIGGER, true);\n                }\n\n                /**\n                 * @private\n                 */\n                function _onVimeoLoaded(data) {\n                    var tmp,\n                        respData,\n                        videoDescription = '';\n\n                    if (!data) {\n                        this._onRequestError($.mage.__('Video not found'));\n\n                        return null;\n                    }\n                    tmp = data;\n\n                    if (tmp.description !== null) {\n                        videoDescription = tmp.description;\n                    }\n\n                    if (tmp.duration == null) {\n                        this._onRequestError(\n                            $.mage.__('Because of its privacy settings, this video cannot be played here.')\n                        );\n                    } else {\n                        respData = {\n                            duration: this._formatVimeoDuration(tmp.duration),\n                            channel: tmp['author_name'],\n                            channelId: tmp['author_url'],\n                            uploaded: tmp['upload_date'],\n                            title: tmp.title,\n                            description: videoDescription.replace(/(&nbsp;|<([^>]+)>)/ig, ''),\n                            thumbnail: tmp['thumbnail_url'],\n                            videoId: videoInfo.id,\n                            videoProvider: videoInfo.type\n                        };\n                        this._videoInformation = respData;\n                        this.element.trigger(this._UPDATE_VIDEO_INFORMATION_TRIGGER, respData);\n                        this.element.trigger(this._FINISH_UPDATE_INFORMATION_TRIGGER, true);\n                    }\n                }\n\n                type = videoInfo.type;\n                id = videoInfo.id;\n\n                if (type === 'youtube') {\n                    googleapisUrl = 'https://www.googleapis.com/youtube/v3/videos?id=' +\n                        id +\n                        '&part=snippet,contentDetails&key=' +\n                        this.options.youtubeKey + '&alt=json&callback=?';\n                    $.getJSON(googleapisUrl,\n                        {\n                            format: 'json'\n                        },\n                        $.proxy(_onYouTubeLoaded, self)\n                    ).fail(\n                        function () {\n                            self._onRequestError('Video not found');\n                        }\n                    );\n                } else if (type === 'vimeo') {\n                    $.ajax({\n                        url: 'https://vimeo.com/api/oembed.json',\n                        dataType: 'jsonp',\n                        data: {\n                            format: 'json',\n                            url: 'https://vimeo.com/' + id\n                        },\n                        timeout: 5000,\n                        success:  $.proxy(_onVimeoLoaded, self),\n\n                        /**\n                         * @private\n                         */\n                        error: function () {\n                            self._onRequestError($.mage.__('Video not found'));\n                        }\n                    });\n                }\n            },\n\n            /**\n             * @private\n             */\n            _onVideoInvalid: function (event, data) {\n                this._videoInformation = null;\n                this.element.val('');\n                alert({\n                    content: 'Error: \"' + data + '\"'\n                });\n            },\n\n            /**\n             * @private\n             */\n            _onRequestError: function (error) {\n                this.element.trigger(this._ERROR_UPDATE_INFORMATION_TRIGGER, error);\n                this.element.trigger(this._FINISH_UPDATE_INFORMATION_TRIGGER, false);\n                this._currentVideoUrl = null;\n            },\n\n            /**\n             * @private\n             */\n            _formatYoutubeDuration: function (duration) {\n                var match = duration.match(/PT(\\d+H)?(\\d+M)?(\\d+S)?/),\n                    hours = parseInt(match[1], 10) || 0,\n                    minutes = parseInt(match[2], 10) || 0,\n                    seconds = parseInt(match[3], 10) || 0;\n\n                return this._formatVimeoDuration(hours * 3600 + minutes * 60 + seconds);\n            },\n\n            /**\n             * @private\n             */\n            _formatVimeoDuration: function (seconds) {\n                return new Date(seconds * 1000).toUTCString().match(/(\\d\\d:\\d\\d:\\d\\d)/)[0];\n            },\n\n            /**\n             * @private\n             */\n            _parseHref: function (href) {\n                var a = document.createElement('a');\n\n                a.href = href;\n\n                return a;\n            },\n\n            /**\n             * @private\n             */\n            _validateURL: function (href, forceVideo) {\n                var id,\n                    type,\n                    ampersandPosition,\n                    vimeoRegex,\n                    useYoutubeNocookie = false;\n\n                if (typeof href !== 'string') {\n                    return href;\n                }\n                href = this._parseHref(href);\n\n                if (href.host.match(/youtube\\.com/) && href.search) {\n\n                    id = href.search.split('v=')[1];\n\n                    if (id) {\n                        ampersandPosition = id.indexOf('&');\n                        type = 'youtube';\n                    }\n\n                    if (id && ampersandPosition !== -1) {\n                        id = id.substring(0, ampersandPosition);\n                    }\n\n                } else if (href.host.match(/youtube\\.com|youtu\\.be|youtube-nocookie.com/)) {\n                    id = href.pathname.replace(/^\\/(embed\\/|v\\/)?/, '').replace(/\\/.*/, '');\n                    type = 'youtube';\n\n                    if (href.host.match(/youtube-nocookie.com/)) {\n                        useYoutubeNocookie = true;\n                    }\n                } else if (href.host.match(/vimeo\\.com/)) {\n                    type = 'vimeo';\n                    vimeoRegex = new RegExp(['https?:\\\\/\\\\/(?:www\\\\.|player\\\\.)?vimeo.com\\\\/(?:channels\\\\/(?:\\\\w+\\\\/)',\n                        '?|groups\\\\/([^\\\\/]*)\\\\/videos\\\\/|album\\\\/(\\\\d+)\\\\/video\\\\/|video\\\\/|)(\\\\d+)(?:$|\\\\/|\\\\?)'\n                    ].join(''));\n\n                    if (href.href.match(vimeoRegex) != null) {\n                        id = href.href.match(vimeoRegex)[3];\n                    }\n                }\n\n                if ((!id || !type) && forceVideo) {\n                    id = href.href;\n                    type = 'custom';\n                }\n\n                return id ? {\n                    id: id, type: type, s: href.search.replace(/^\\?/, ''), useYoutubeNocookie: useYoutubeNocookie\n                } : false;\n            }\n        });\n    });\n","Magento_ProductVideo/js/video-modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'productGallery',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'mage/backend/tree-suggest',\n    'mage/backend/validation',\n    'newVideoDialog'\n], function ($, productGallery) {\n    'use strict';\n\n    $.widget('mage.productGallery', productGallery, {\n\n        /**\n         * Bind events\n         * @private\n         */\n        _bind: function () {\n            var events = {},\n                itemId;\n\n            this._super();\n\n            /**\n             * Add item_id value to opened modal\n             * @param {Object} event\n             */\n            events['click ' + this.options.imageSelector] = function (event) {\n                if (!$(event.currentTarget).is('.ui-sortable-helper')) {\n                    itemId = $(event.currentTarget).find('input')[0].name.match(/\\[([^\\]]*)\\]/g)[2];\n                    this.videoDialog.find('#item_id').val(itemId);\n                }\n            };\n            this._on(events);\n            this.element.prev().find('[data-role=\"add-video-button\"]').on('click', this.showModal.bind(this));\n            this.element.on('openDialog', '.gallery.ui-sortable', $.proxy(this._onOpenDialog, this));\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this._super();\n            this.videoDialog = this.element.find('#new-video');\n            this.videoDialog.mage('newVideoDialog', this.videoDialog.data('modalInfo'));\n        },\n\n        /**\n         * Open dialog for external video\n         * @private\n         */\n        _onOpenDialog: function (e, imageData) {\n\n            if (imageData['media_type'] !== 'external-video') {\n                this._superApply(arguments);\n            } else {\n                this.showModal();\n            }\n        },\n\n        /**\n         * Fired on trigger \"openModal\"\n         */\n        showModal: function () {\n            this.videoDialog.modal('openModal');\n        }\n    });\n\n    return $.mage.productGallery;\n});\n","Magento_InventoryBundleProductAdminUi/js/form/element/grid-column-quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column'\n], function ($t, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryBundleProductAdminUi/grid/column/quantity-per-source',\n            itemsToDisplay: 3,\n            showFullListDescription: $t('Show more...')\n        },\n\n        /**\n         * Get source items from product data.\n         *\n         * @param {Object} rowData\n         * @returns {Array}\n         */\n        getSourceItemsData: function (rowData) {\n            return rowData['quantity_per_source'];\n        }\n    });\n});\n","Magento_InventoryBundleProductAdminUi/js/form/element/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function ($t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_InventoryBundleProductAdminUi/dynamic-rows/cells/cell-source',\n            itemsToDisplay: 3,\n            isFullList: true,\n            showFullListDescription: $t('Show more...'),\n            listens: {\n                value: 'updateItems'\n            }\n        },\n\n        /**\n         * Observe elements.\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['items', 'isFullList']);\n\n            return this;\n        },\n\n        /**\n         * Prepare data to use.\n         *\n         * @param {Object} data\n         * @private\n         */\n        updateItems: function (data) {\n            this.isFullList(data.length > this.itemsToDisplay);\n            this.isFullList() ? this.items(data.slice(0, this.itemsToDisplay)) : this.items(data);\n        }\n    });\n});\n","Amasty_Mostviewed/js/form/provider.js":"define([\n    'jquery',\n    'Magento_Ui/js/form/provider'\n], function ($, Element) {\n    'use strict';\n\n    return Element.extend({\n        /**\n         * Saves currently available data.\n         *\n         * @param {Object} [options] - Addtitional request options.\n         * @returns {Provider} Chainable.\n         */\n        save: function (options) {\n            var data = this.get('data');\n\n            /* delete unused data */\n            delete data.parent_ids;\n            delete data.child_products_container;\n\n            var newParent = [];\n            $(data.parent_products_container).each(function (i, item) {\n                newParent[i] = {'entity_id' : item.entity_id} // remove other data\n            });\n            data.parent_products_container = newParent;\n\n            this.client.save(data, options);\n\n            return this;\n        }\n    });\n});\n","Amasty_Mostviewed/js/form/components/fieldset.js":"define([\n    'Magento_Ui/js/form/components/fieldset'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            visible: true\n        },\n\n        /**\n         * Show element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        show: function () {\n            this.visible(true);\n\n            return this;\n        },\n\n        /**\n         * Hide element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        hide: function () {\n            this.visible(false);\n\n            return this;\n        }\n    });\n});\n","Amasty_Mostviewed/js/pack/form/discount-type.js":"define([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/select'\n], function ($, _, uiRegistry, Select) {\n    'use strict';\n\n    return Select.extend({\n        fieldsHideIfConditional: [\n            'index = discount_amount',\n            'index = apply_for_parent',\n            'index = apply_condition',\n            'index = cart_message',\n        ],\n\n        updateVisibleFields: function (value) {\n            var isConditional = value == 2;\n\n            _.each(this.fieldsHideIfConditional, function (fieldHideIfConditional) {\n                uiRegistry.get(fieldHideIfConditional, function (elem) {\n                    elem.visible(!isConditional);\n                });\n            });\n\n            uiRegistry.get('hideIfConditional = 1', function () {\n                _.each(uiRegistry.filter('hideIfConditional = 1'), function (elem) {\n                    elem.visible(!isConditional);\n                });\n            });\n\n            uiRegistry.get('showIfConditional = 1', function () {\n                _.each(uiRegistry.filter('showIfConditional = 1'), function (elem) {\n                    elem.visible(isConditional);\n                });\n            });\n        }\n    });\n});\n","Amasty_Mostviewed/js/lib/core/collection.js":"define([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'uiComponent',\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (_, utils, registry, Element, $, async) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            visible: true,\n            ignoredElements: []\n        },\n\n        /**\n         * Called when another element was added to current component.\n         * If element ignored - mean element must be hide/show by his configuration.\n         *\n         * @param {Object} elem - Instance of an element that was added.\n         * @returns {Collection} Chainable.\n         */\n        initElement: function (elem) {\n            if (elem.additionalClasses && this.ignoredElements.indexOf(elem.index) === -1) {\n                elem.additionalClasses[this.className] = true;\n            }\n\n            elem.initContainer(this);\n\n            return this;\n        },\n\n        /**\n         * Show element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        show: function () {\n            $('.' + this.className).show();\n\n            return this;\n        },\n\n        /**\n         * Hide element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        hide: function () {\n            var element = $('.' + this.className),\n                self = this;\n\n            if (element.length) {\n                element.hide();\n            } else {\n                async.async('.' + self.className, function (item) {\n                    $(item).hide();\n                }.bind(this));\n            }\n\n            return this;\n        }\n    });\n});\n","Amasty_Mostviewed/js/grid/provider.js":"define([\n    'jquery',\n    'Magento_Ui/js/grid/provider'\n], function ($, provider) {\n    'use strict';\n\n    return provider.extend({\n        reload: function (options) {\n            var conditionElements = $('.ammost-' +\n                this.params['relation'] +\n                '-to-display [data-form-part=\"amasty_mostviewed_product_group_form\"]'\n            ), onlyOutOfStock = $(\n                '[data-index=\"for_out_of_stock\"] input'\n            ), conditions = {};\n            $.each(conditionElements, function (index, element) {\n                conditions[element.name] = element.value;\n            });\n            if (onlyOutOfStock.length) {\n                conditions['for_out_of_stock'] = onlyOutOfStock.val();\n            }\n\n            var params = {};\n            $.each(this.params, function(index, item) {\n                var temp = {};\n                temp[index] = item;\n                $.extend(params, temp);\n            });\n            $.extend(this.params, conditions);\n\n            this._super({'refresh': true});\n\n            this.params = params;\n        }\n    });\n});\n","Amasty_Mostviewed/js/grid/columns/sales/subtotal.js":"define([\n    'Magento_Ui/js/grid/columns/column'\n], function (column) {\n    'use strict';\n\n    return column.extend({\n        getLabel: function (record) {\n            return parseFloat(record[this.index].replace( /^\\D+/g, '')) ? record[this.index] : '-';\n        }\n    });\n});\n","Amasty_Mostviewed/js/dynamic-rows/dynamic-rows-grid.js":"/**\n * Missing Prototype library fix\n */\ndefine([\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid',\n    'prototype'\n], function (dynamicRowsGrid) {\n    'use strict';\n\n    return dynamicRowsGrid;\n});\n","Amasty_Mostviewed/js/dynamic-rows/element/select-label.js":"/**\n * Select Element for dinamic rows\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/select'\n], function (_, select) {\n    'use strict';\n\n    return select.extend({\n        /**\n         * Replace value id with label text\n         */\n        normalizeData: function () {\n            var value = this._super(),\n                option;\n\n            if (value !== '') {\n                option = this.getOption(value);\n\n                return option && option.label;\n            }\n\n            if (!this.caption()) {\n                return findFirst(this.options);\n            }\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/dynamic-rows-configurable-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n        'use strict';\n\n        var mixin = {\n\n            /**\n             * Parsed data\n             *\n             * @param {Array} data - array with data\n             * about selected records\n             */\n            processingInsertDataFromGrid: function (data) {\n                var changes,\n                    tmpArray;\n\n                if (!data.length) {\n                    return;\n                }\n\n                tmpArray = this.getUnionInsertData();\n\n                changes = this._checkGridData(data);\n                this.cacheGridData = data;\n\n                changes.each(function (changedObject) {\n                    var mappedData = this.mappingValue(changedObject),\n                        sources = [];\n\n                    mappedData[this.canEditField] = 0;\n                    mappedData[this.newProductField] = 0;\n                    mappedData.variationKey = this._getVariationKey(changedObject);\n                    mappedData['configurable_attribute'] = this._getConfigurableAttribute(changedObject);\n\n                    if ('quantity_per_source' in changedObject) {\n                        changedObject['quantity_per_source'].each(function (source) {\n                            sources.push({\n                                'quantity_per_source': source.qty,\n                                'source': source['source_name'],\n                                'source_code': source['source_code']\n                            });\n                        });\n                        mappedData['quantity_per_source'] = sources;\n                    }\n\n                    tmpArray.push(mappedData);\n                }, this);\n\n                // Attributes cannot be changed before regeneration thought wizard\n                if (!this.source.get('data.attributes').length) {\n                    this.source.set('data.attributes', this.attributesTmp);\n                }\n                this.unionInsertData(tmpArray);\n            }\n        };\n\n        return function (target) {\n            return target.extend(mixin);\n        };\n    }\n);\n","Magento_InventoryConfigurableProductAdminUi/js/configurable-quantity-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiCollection',\n    'jquery',\n    'ko',\n    'uiLayout',\n    'mageUtils',\n    'underscore',\n    'mage/translate'\n], function (Collection, $, ko, layout, utils, _, $t) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            attribute: {},\n            template: 'Magento_InventoryConfigurableProductAdminUi/container',\n            identifier: 'source_code',\n            dataScope: '',\n            currentAttribute: '',\n            insertListingComponent: '',\n            dynamicRowsName: 'dynamicRows',\n            type: '',\n            templateElementNames: {\n                button: 'button_template',\n                dynamicRows: 'dynamic_rows_template',\n                group: 'group_template'\n            },\n            ignoreTmpls: {\n                childTemplate: true\n            },\n            listens: {\n                'attribute': 'handlerAttributeChange',\n                'insertListingValue': 'handlerInsertValueChange',\n                'type': 'handlerTypeChange'\n            },\n            dynamicRowsCollection: {},\n            imports: {\n                insertListingValue: '${$.insertListingComponent}:value'\n            },\n            modules: {\n                insertListing: '${$.insertListingComponent}'\n            }\n        },\n\n        /**\n         * Generates data for dynamic-rows records\n         * @param {Array} data\n         *\n         * @returns {Array}\n         */\n        generateDynamicRowsData: function (data) {\n            var items = [];\n\n            _.each(data, function (item) {\n                items.push({\n                    'source': item.name,\n                    'source_code': item[this.identifier],\n                    'source_status': parseInt(item.enabled, 10) ? $.mage.__('Enabled') : $.mage.__('Disabled')\n                });\n            }.bind(this));\n\n            return items;\n        },\n\n        /**\n         * Handler for InsertListing value\n         *\n         * @param {Array} data\n         */\n        handlerInsertValueChange: function (data) {\n            var items,\n                path = this.dynamicRowsName + '.' + this.currentDynamicRows;\n\n            if (!this.currentDynamicRows) {\n                return;\n            }\n\n            if (!data.length) {\n                return;\n            }\n\n            items = this.generateDynamicRowsData(data);\n            this.source.set(path, items);\n        },\n\n        /**\n         * Handler for attribute property\n         *\n         * @param {Object} data\n         */\n        handlerAttributeChange: function (data) {\n            if (data && data !== this.currentAttribute) {\n                this.currentAttribute = data;\n                this.destroyChildren();\n\n                _.each(data.chosen, function (item) {\n                    this.addChild(item);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Handler for type property\n         *\n         * @param {String} data\n         */\n        handlerTypeChange: function (data) {\n            if (data === 'single') {\n                this.destroyChildren();\n                this.currentAttribute = {};\n                this.addChild();\n            } else if (data === 'each' && this.attribute) {\n                this.handlerAttributeChange(this.attribute);\n            }\n        },\n\n        /** @inheritdoc */\n        validate: function (elem) {\n            if (typeof elem === 'undefined') {\n                return;\n            }\n\n            if (typeof elem.validate === 'function') {\n                this.valid &= elem.validate().valid;\n            } else if (elem.elems) {\n                elem.elems().forEach(this.validate, this);\n            }\n        },\n\n        /**\n         * Parses string templates.\n         * Skip parse if deferredTmpl property set to \"true\"\n         *\n         * @param {Object} obj\n         *\n         * @returns obj\n         */\n        parseTemplateString: function (obj) {\n            var children;\n\n            if (obj.children) {\n                children = utils.copy(obj.children);\n                delete obj.children;\n            }\n\n            obj = utils.template(obj, obj);\n            obj.children = children;\n\n            if (children) {\n                _.each(children, function (child, name) {\n                    obj.children[name] = child.config.deferredTmpl ? child : this.parseTemplateString(child);\n                }, this);\n            }\n\n            obj.name = obj.config.name || obj.name;\n\n            return obj;\n        },\n\n        /**\n         * Handler for modal\n         *\n         * @param {String} id - dynamic-rows name that open modal\n         */\n        handleToggleSourcesModal: function (id) {\n            this.currentDynamicRows = this.type === 'each' ? this.currentAttribute.code + '.' + id : id;\n            this.insertListing().value(this.source.get(this.dynamicRowsName + '.' + this.currentDynamicRows));\n        },\n\n        /**\n         * Generates dynamic data for child.\n         *\n         * @param {Object | Undefined} data - optional.\n         */\n        generateDynamicData: function (data) {\n            var key = data ? data.label : this.dynamicRowsName,\n                drExportTo = this.name + ':dynamicRowsCollection.',\n                drDataScope = 'data.' + this.name + '.',\n                drDataProvider = this.dynamicRowsName + '.';\n\n            if (this.type === 'each') {\n                drDataScope += this.currentAttribute.code + '.';\n                drExportTo += this.currentAttribute.code + '.';\n                drDataProvider += this.currentAttribute.code + '.';\n            }\n\n            drDataScope += key;\n            drExportTo += key;\n            drDataProvider += key;\n\n            return {\n                group: {\n                    name: key\n                },\n                button: {\n                    label: data ? data.label : $t('Quantity'),\n                    targetName: this.name,\n                    param: key\n                },\n                dynamicRows: {\n                    dataScope: drDataScope,\n                    dataProvider: drDataProvider,\n                    name: this.dynamicRowsName,\n                    exportTo: drExportTo\n                }\n            };\n        },\n\n        /**\n         * @param {Object | Undefined} data - optional.\n         */\n        addChild: function (data) {\n            var template = utils.copy(this.childTemplate.templates).children,\n                dynamicRows = template[this.templateElementNames.dynamicRows],\n                button = template[this.templateElementNames.button],\n                group = template[this.templateElementNames.group],\n                dynamicData = this.generateDynamicData(data);\n\n            group.dynamicData = dynamicData.group;\n            group.parent = this.name;\n            group = this.parseTemplateString(group);\n\n            button.dynamicData = dynamicData.button;\n            button.parent = this.name + '.' + group.name;\n            button = this.parseTemplateString(button);\n\n            dynamicRows.dynamicData = dynamicData.dynamicRows;\n            dynamicRows.parent = this.name + '.' + group.name;\n            dynamicRows = this.parseTemplateString(dynamicRows);\n\n            layout([group, button, dynamicRows]);\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/form/element/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function ($t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_InventoryConfigurableProductAdminUi/dynamic-rows/cells/cell-source',\n            itemsToDisplay: 5,\n            isFullList: true,\n            showFullListDescription: $t('Show more...'),\n            listens: {\n                value: 'updateItems'\n            }\n        },\n\n        /**\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['items', 'isFullList']);\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {Object} data\n         */\n        updateItems: function (data) {\n            this.isFullList(data.length > this.itemsToDisplay);\n            this.isFullList() ? this.items(data.slice(0, this.itemsToDisplay)) : this.items(data);\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/components/sources-visibility-checker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'uiComponent'\n], function (_, registry, component) {\n    'use strict';\n\n    return component.extend({\n        defaults: {\n            sourcesIndex: ''\n        },\n\n        /**\n         * Hide source tab if convert product to configurable and show it if to simple.\n         */\n        applySourcesConfiguration: function (visibleMatrix) {\n            var source = registry.get('index = ' + this.sourcesIndex);\n\n            if (!_.isUndefined(source)) {\n                source.visible(!visibleMatrix);\n            }\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/components/dynamic-rows-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_ConfigurableProduct/js/components/dynamic-rows-configurable'\n], function (dynamicRowsConfigurable) {\n    'use strict';\n\n    return dynamicRowsConfigurable.extend({\n        defaults: {\n            quantityFieldName: 'quantity_per_source'\n        },\n\n        /** @inheritdoc */\n        getProductData: function (row) {\n            var product = this._super(row);\n\n            product[this.quantityFieldName] = row.quantityPerSource;\n\n            return product;\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/variations/steps/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_ConfigurableProduct/js/variations/steps/bulk',\n    'jquery',\n    'ko',\n    'underscore'\n], function (Bulk, $, ko, _) {\n    'use strict';\n\n    return Bulk.extend({\n        defaults: {\n            quantityModuleName: '',\n            quantityPerSource: '',\n            exports: {\n                attribute: '${$.provider}:data.inventoryAttribute',\n                type: '${$.provider}:data.inventoryType'\n            },\n            modules: {\n                quantityResolver: '${$.quantityResolver}'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var sections;\n\n            this._super();\n\n            sections = this.sections();\n            sections.quantityPerSource = {\n                label: 'Quantity Per Source',\n                type: ko.observable('none'),\n                value: ko.observable(),\n                attribute: ko.observable()\n            };\n            this.sections(sections);\n\n            /**\n             * Make options sections.\n             */\n            this.makeOptionSections = function () {\n                return {\n                    images: new this.makeImages(null),\n                    price: this.price,\n                    quantityPerSource: this.quantityPerSource\n                };\n            }.bind(this);\n\n            this.initAttributeListener();\n\n            return this;\n        },\n\n        /**\n         * Inits listeners for attribute change.\n         */\n        initAttributeListener: function () {\n            var quantityPerSource = this.sections().quantityPerSource;\n\n            quantityPerSource.attribute.subscribe(function (data) {\n                this.attribute(data);\n            }.bind(this));\n\n            quantityPerSource.type.subscribe(function (data) {\n                this.type(data);\n            }.bind(this));\n        },\n\n        /**\n         * Calls 'initObservable' of parent, initializes 'options' and 'initialOptions'\n         *     properties, calls 'setOptions' passing options to it\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'attribute',\n                    'type'\n                ]);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        force: function (wizard) {\n            if (this.type() === 'each' && this.attribute() || this.type() === 'single') {\n                this.prepareDynamicRowsData();\n            }\n\n            this._super(wizard);\n        },\n\n        /**\n         * Prepares dynamic rows data for the next step\n         */\n        prepareDynamicRowsData: function () {\n            var data,\n                module = this.quantityResolver();\n\n            if (this.type() === 'each') {\n                data = module.dynamicRowsCollection[this.attribute().code];\n\n                _.each(this.attribute().chosen, function (item) {\n                    item.sections().quantityPerSource = data[item.label];\n                });\n            } else if (this.type() === 'single') {\n                data = module.dynamicRowsCollection[module.dynamicRowsName];\n                this.sections().quantityPerSource.value(data);\n            }\n        },\n\n        /** @inheritdoc */\n        validate: function () {\n            var valid = true,\n                quantityPerSource = this.quantityResolver();\n\n            this._super();\n\n            if (this.type() && this.type() !== 'none') {\n                quantityPerSource.valid = true;\n\n                quantityPerSource.elems().forEach(function (item) {\n                    quantityPerSource.validate.call(quantityPerSource, item);\n                    valid = valid && item.elems()[1].elems().length;\n                });\n\n                if (!quantityPerSource.valid || !valid) {\n                    throw new Error($.mage.__('Please fill-in correct values.'));\n                }\n            }\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/variations/steps/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_ConfigurableProduct/js/variations/steps/summary',\n    'jquery',\n    'mage/translate'\n], function (Summary, $) {\n    'use strict';\n\n    return Summary.extend({\n        defaults: {\n            attributesName: [\n                $.mage.__('Images'),\n                $.mage.__('SKU'),\n                $.mage.__('Quantity Per Source'),\n                $.mage.__('Price')\n            ],\n            quantityFieldName: 'quantityPerSource'\n        }\n    });\n});\n","Magento_Theme/js/bootstrap.js":"/**\n *\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'jquery/fileUploader/jquery.fileupload-ui',\n    'mage/adminhtml/browser',\n    'Magento_Theme/js/form'\n]);\n","Magento_Theme/js/custom-js-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('theme.themeJsList', {\n        options: {\n            templateId: null,\n            emptyTemplateId: null,\n            refreshFileListEvent: null,\n            prefixItemId: '',\n            suffixItemId: ''\n        },\n\n        /**\n         * Initialize widget\n         *\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Bind event handlers\n         *\n         * @protected\n         */\n        _bind: function () {\n            $('body').on(this.options.refreshFileListEvent, $.proxy(this._onRefreshList, this));\n        },\n\n        /**\n         * Render js files list\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @protected\n         */\n        _onRefreshList: function (event, data) {\n            $(this.element).html('');\n\n            if (data.jsList.length) {\n                this._renderList(data.jsList);\n            } else {\n                this._renderEmptyList();\n            }\n        },\n\n        /**\n         * Get item js list id\n         *\n         * @param {*} fileId\n         * @return {String}\n         * @protected\n         */\n        _getItemId: function (fileId) {\n            return this.options.prefixItemId + fileId + this.options.suffixItemId;\n        },\n\n        /**\n         * Render js list\n         *\n         * @param {Array} jsList\n         * @protected\n         */\n        _renderList: function (jsList) {\n            var itemTmpl,\n                index,\n                tmpl;\n\n            for (index = 0; index < jsList.length; index++) {\n                itemTmpl = $('<li></li>').html($(this.options.templateId).html());\n\n                $(itemTmpl).attr('class', $(this.options.templateId).attr('class'));\n\n                itemTmpl.attr('id', this._getItemId(jsList[index].id));\n\n                tmpl = mageTemplate(itemTmpl.html(), {\n                    data: jsList[index]\n                });\n\n                itemTmpl.html(tmpl);\n\n                itemTmpl.removeClass('no-display');\n                itemTmpl.appendTo(this.element);\n            }\n        },\n\n        /**\n         * Set empty js list\n         *\n         * @protected\n         */\n        _renderEmptyList: function () {\n            var itemTmpl = $('<li></li>').html($(this.options.emptyTemplateId).html());\n\n            $(itemTmpl).attr('class', $(this.options.emptyTemplateId).attr('class'));\n\n            itemTmpl.attr('id', 'empty-js-list');\n            itemTmpl.removeClass('no-display');\n            itemTmpl.appendTo(this.element);\n        }\n    });\n});\n","Magento_Theme/js/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'prototype'\n], function () {\n    'use strict';\n\n    /**\n     * @param {*} selected\n     * @param {Object} defaultsById\n     */\n    function parentThemeOnChange(selected, defaultsById) {\n        var statusBar = $$('.tab-item-link')[0],\n            isChanged = statusBar.hasClassName('changed'),\n            defaults;\n\n        if (!isChanged) {\n            defaults = defaultsById[selected];\n            $('theme_title').value = defaults['theme_title'];\n        }\n    }\n\n    window.parentThemeOnChange = parentThemeOnChange;\n});\n","Magento_Theme/js/sortable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * JQuery UI Widget declaration: 'mage.sortable'\n *\n * @api\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    /**\n     * Widget panel\n     */\n    $.widget('mage.sortable', $.ui.sortable, {\n        options: {\n            moveUpEvent:   'moveUp',\n            moveDownEvent: 'moveDown'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._super();\n            this.initButtons();\n            this.bind();\n        },\n\n        /**\n         * Init buttons.\n         */\n        initButtons: function () {\n            this.element.find('input.up').on('click', $.proxy(function (event) {\n                $('body').trigger(this.options.moveUpEvent, {\n                    item: $(event.target).parent('li')\n                });\n            }, this));\n            this.element.find('input.down').on('click', $.proxy(function (event) {\n                $('body').trigger(this.options.moveDownEvent, {\n                    item: $(event.target).parent('li')\n                });\n            }, this));\n        },\n\n        /**\n         * Bind.\n         */\n        bind: function () {\n            var $body = $('body');\n\n            $body.on(this.options.moveUpEvent, $.proxy(this._onMoveUp, this));\n            $body.on(this.options.moveDownEvent, $.proxy(this._onMoveDown, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _onMoveUp: function (event, data) {\n            data.item.insertBefore(data.item.prev());\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _onMoveDown: function (event, data) {\n            data.item.insertAfter(data.item.next());\n        }\n    });\n\n    return $.mage.sortable;\n});\n","Magento_Theme/js/form/component/robots-reset-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/components/button',\n    'uiRegistry'\n], function (Button, registry) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            customInstructionField: '${ $.parentName }.custom_instructions',\n            label: '',\n            buttonTpl: 'Magento_Theme/form/element/button'\n        },\n\n        /**\n         * @private\n         * @param {String} json\n         * @return {String}\n         */\n        _parseJson: function (json) {\n            return JSON.parse(json);\n        },\n\n        /**\n         * @param {String} defaultRobotsTxt\n         */\n        reset: function (defaultRobotsTxt) {\n            var customInstructions = registry.get(this.customInstructionField);\n\n            if (customInstructions) {\n                customInstructions.set('value', this._parseJson(defaultRobotsTxt));\n            }\n        }\n    });\n});\n","Magento_Translation/js/mage-translation-dictionary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'text!js-translation.json'\n], function (dict) {\n    'use strict';\n\n    return JSON.parse(dict);\n});\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function () {\n    'use strict';\n\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_Downloadable/downloadable-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/product/weight-handler',\n    'Magento_Catalog/catalog/type-events'\n], function ($, weight, productType) {\n    'use strict';\n\n    return {\n        $checkbox: $('[data-action=change-type-product-downloadable]'),\n        $items: $('#product_info_tabs_downloadable_items'),\n        $tab: null,\n        isDownloadable: false,\n\n        /**\n         * Show\n         */\n        show: function () {\n            this.$checkbox.prop('checked', true);\n            this.$items.show();\n        },\n\n        /**\n         * Hide\n         */\n        hide: function () {\n            this.$checkbox.prop('checked', false);\n            this.$items.hide();\n        },\n\n        /**\n         * Constructor component\n         * @param {Object} data - this backend data\n         */\n        'Magento_Downloadable/downloadable-type-handler': function (data) {\n            this.$tab = $('[data-tab=' + data.tabId + ']');\n            this.isDownloadable = data.isDownloadable;\n            this.bindAll();\n            this._initType();\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            this.$checkbox.on('change', function (event) {\n                $(document).trigger('setTypeProduct', $(event.target).prop('checked') ?\n                    'downloadable' :\n                    productType.type.init === 'downloadable' ? 'virtual' : productType.type.init\n                );\n            });\n\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n        },\n\n        /**\n         * Init type\n         * @private\n         */\n        _initType: function () {\n            if (productType.type.current === 'downloadable') {\n                weight.change(false);\n                weight.$weightSwitcher().one('change', function () {\n                    $(document).trigger(\n                        'setTypeProduct',\n                        productType.type.init === 'downloadable' ? 'virtual' : productType.type.init\n                    );\n                });\n                this.show();\n            } else {\n                this.hide();\n            }\n        }\n    };\n});\n","Magento_Downloadable/js/components/price-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            linksPurchasedSeparately: '0',\n            useDefaultPrice: false,\n            listens: {\n                linksPurchasedSeparately: 'changeDisabledStatus',\n                useDefaultPrice: 'changeDisabledStatus'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n            this.changeDisabledStatus();\n\n            return this;\n        },\n\n        /**\n         * Disable/enable price field\n         */\n        changeDisabledStatus: function () {\n            if (this.linksPurchasedSeparately === '1') {\n                if (this.useDefaultPrice) {\n                    this.disabled(true);\n                } else {\n                    this.disabled(false);\n                }\n            } else {\n                this.disabled(true);\n            }\n        }\n    });\n});\n","Magento_Downloadable/js/components/file-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/file-uploader'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            fileInputName: ''\n        },\n\n        /**\n         * Adds provided file to the files list.\n         *\n         * @param {Object} file\n         * @returns {FileUploder} Chainable.\n         */\n        addFile: function (file) {\n            var processedFile = this.processFile(file),\n                tmpFile = [],\n                resultFile = {\n                'file': processedFile.file,\n                'name': processedFile.name,\n                'size': processedFile.size,\n                'status': processedFile.status ? processedFile.status : 'new'\n            };\n\n            tmpFile[0] = resultFile;\n\n            this.isMultipleFiles ?\n                this.value.push(tmpFile) :\n                this.value(tmpFile);\n\n            return this;\n        }\n    });\n});\n","Magento_Downloadable/js/components/upload-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry'\n], function (Select, registry) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            listens: {\n                value: 'changeTypeUpload'\n            },\n            typeUrl: 'file',\n            typeFile: 'link_url',\n            filterPlaceholder: 'ns = ${ $.ns }, parentScope = ${ $.parentScope }'\n        },\n\n        /**\n         * Initialize component.\n         * @returns {Element}\n         */\n        initialize: function () {\n            return this\n                ._super()\n                .changeTypeUpload(this.initialValue);\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated.\n         *\n         * @param {String} currentValue\n         * @returns {*}\n         */\n        onUpdate: function (currentValue) {\n            this.changeTypeUpload(currentValue);\n\n            return this._super();\n        },\n\n        /**\n         * Change visibility for typeUrl/typeFile based on current value.\n         *\n         * @param {String} currentValue\n         */\n        changeTypeUpload: function (currentValue) {\n            var componentFile = this.filterPlaceholder + ', index=' + this.typeFile,\n                componentUrl = this.filterPlaceholder + ', index=' + this.typeUrl;\n\n            switch (currentValue) {\n\n                case 'file':\n                    this.changeVisible(componentFile, true);\n                    this.changeVisible(componentUrl, false);\n                    break;\n\n                case 'url':\n                    this.changeVisible(componentFile, false);\n                    this.changeVisible(componentUrl, true);\n                    break;\n            }\n        },\n\n        /**\n         * Change visible\n         *\n         * @param {String} filter\n         * @param {Boolean} visible\n         */\n        changeVisible: function (filter, visible) {\n            registry.async(filter)(\n                function (currentComponent) {\n                    currentComponent.visible(visible);\n                }\n            );\n        }\n    });\n});\n","Magento_Downloadable/js/components/use-price-default-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            linksPurchasedSeparately: '0',\n            listens: {\n                linksPurchasedSeparately: 'changeVisibleStatus'\n            }\n        },\n\n        /**\n         * Change visibility of checkbox\n         */\n        changeVisibleStatus: function () {\n            if (this.linksPurchasedSeparately === '1') {\n                this.visible(true);\n            } else {\n                this.visible(false);\n            }\n        }\n    });\n});\n","Magento_Downloadable/js/components/is-downloadable-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            listens: {\n                disabled: 'changeVisibility'\n            },\n            modules: {\n                samplesFieldset: '${ $.samplesFieldset }',\n                linksFieldset: '${ $.linksFieldset}'\n            }\n        },\n\n        /**\n         * Change visibility for samplesFieldset & linksFieldset based on current statuses of checkbox.\n         */\n        changeVisibility: function () {\n            if (this.samplesFieldset() && this.linksFieldset()) {\n                if (this.checked() && !this.disabled()) {\n                    this.samplesFieldset().visible(true);\n                    this.linksFieldset().visible(true);\n                } else {\n                    this.samplesFieldset().visible(false);\n                    this.linksFieldset().visible(false);\n                }\n            }\n        },\n\n        /**\n         * Handle checked state changes for checkbox / radio button.\n         *\n         * @param {Boolean} newChecked\n         */\n        onCheckedChanged: function (newChecked) {\n            this.changeVisibility();\n            this._super(newChecked);\n        }\n    });\n});\n","Magento_LoginAsCustomerAdminUi/js/confirmation-popup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Ui/js/modal/confirm',\n    'jquery',\n    'ko',\n    'mage/translate',\n    'mage/template',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'text!Magento_LoginAsCustomerAdminUi/template/confirmation-popup/store-view-ptions.html'\n], function (Component, confirm, $, ko, $t, template, _, alert, selectTpl) {\n\n    'use strict';\n\n    return Component.extend({\n        /**\n         * Initialize Component\n         */\n        initialize: function () {\n            var self = this,\n                content;\n\n            this._super();\n\n            content = '<div class=\"message message-warning\">' + self.content + '</div>';\n\n            if (self.showStoreViewOptions) {\n                content = template(\n                    selectTpl,\n                    {\n                        data: {\n                            showStoreViewOptions: self.showStoreViewOptions,\n                            storeViewOptions: self.storeViewOptions,\n                            label: $t('Store')\n                        }\n                    }) + content;\n            }\n\n            /**\n             * Confirmation popup\n             *\n             * @param {String} url\n             * @returns {Boolean}\n             */\n            window.lacConfirmationPopup = function (url) {\n                confirm({\n                    title: self.title,\n                    content: content,\n                    modalClass: 'confirm lac-confirm',\n                    actions: {\n                        /**\n                         * Confirm action.\n                         */\n                        confirm: function () {\n                            var storeId = $('#lac-confirmation-popup-store-id').val(),\n                                formKey = $('input[name=\"form_key\"]').val(),\n                                params = {};\n\n                            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                            if (storeId) {\n                                params.store_id = storeId;\n                            }\n\n                            if (formKey) {\n                                params.form_key = formKey;\n                            }\n                            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n                            $.ajax({\n                                url: url,\n                                type: 'POST',\n                                dataType: 'json',\n                                data: params,\n                                showLoader: true,\n\n                                /**\n                                 * Open redirect URL in new window, or show messages if they are present\n                                 *\n                                 * @param {Object} data\n                                 */\n                                success: function (data) {\n                                    var messages = data.messages || [];\n\n                                    if (data.message) {\n                                        messages.push(data.message);\n                                    }\n\n                                    if (data.redirectUrl) {\n                                        window.open(data.redirectUrl);\n                                    } else if (messages.length) {\n                                        messages = messages.map(function (message) {\n                                            return _.escape(message);\n                                        });\n\n                                        alert({\n                                            content: messages.join('<br>')\n                                        });\n                                    }\n                                },\n\n                                /**\n                                 * Show XHR response text\n                                 *\n                                 * @param {Object} jqXHR\n                                 */\n                                error: function (jqXHR) {\n                                    alert({\n                                        content: _.escape(jqXHR.responseText)\n                                    });\n                                }\n                            });\n                        }\n                    },\n                    buttons: [{\n                        text: $t('Cancel'),\n                        class: 'action-secondary action-dismiss',\n\n                        /**\n                         * Click handler.\n                         */\n                        click: function (event) {\n                            this.closeModal(event);\n                        }\n                    }, {\n                        text: $t('Login as Customer'),\n                        class: 'action-primary action-accept',\n\n                        /**\n                         * Click handler.\n                         */\n                        click: function (event) {\n                            this.closeModal(event, true);\n                        }\n                    }]\n                });\n\n                return false;\n            };\n        }\n    });\n});\n","Magento_InventorySalesAdminUi/js/product/grid/cell/salable-quantity.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventorySalesAdminUi/product/grid/cell/salable-quantity.html'\n        },\n\n        /**\n         * Get salable quantity data (stock name and salable qty)\n         *\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSalableQuantityData: function (record) {\n            return record[this.index] ? record[this.index] : [];\n        }\n    });\n});\n","Magento_InventorySalesAdminUi/js/stock/grid/cell/sales-channels.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'underscore'\n], function (Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventorySalesAdminUi/stock/grid/cell/sales-channel-cell.html'\n        },\n\n        /**\n         * Get sales channels grouped by type\n         *\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSalesChannelsGroupedByType: function (record) {\n            var result = [];\n\n            _.each(record[this.index], function (channels, type) {\n                result.push({\n                    type: type,\n                    channels: channels\n                });\n            });\n\n            return result;\n        }\n    });\n});\n"}
}});
