require.config({"config": {
        "jsbuild":{"Amasty_Reports/amcharts/plugins/export/libs/fabric.js/fabric.js":"// phpcs:ignoreFile\n/* eslint-disable */\n/* build: `node build.js modules=ALL exclude=json,gestures minifier=uglifyjs` */\n/*! Fabric.js Copyright 2008-2015, Printio (Juriy Zaytsev, Maxim Chernyak) */\n\nvar fabric = fabric || { version: \"1.6.2\" };\nif (typeof exports !== 'undefined') {\n  exports.fabric = fabric;\n}\n\nif (typeof document !== 'undefined' && typeof window !== 'undefined') {\n  fabric.document = document;\n  fabric.window = window;\n  // ensure globality even if entire library were function wrapped (as in Meteor.js packaging system)\n  window.fabric = fabric;\n}\nelse {\n  // assume we're running under node.js when document/window are not present\n  fabric.document = require(\"jsdom\")\n    .jsdom(\"<!DOCTYPE html><html><head></head><body></body></html>\");\n\n  if (fabric.document.createWindow) {\n    fabric.window = fabric.document.createWindow();\n  } else {\n    fabric.window = fabric.document.parentWindow;\n  }\n}\n\n/**\n * True when in environment that supports touch events\n * @type boolean\n */\nfabric.isTouchSupported = \"ontouchstart\" in fabric.document.documentElement;\n\n/**\n * True when in environment that's probably Node.js\n * @type boolean\n */\nfabric.isLikelyNode = typeof Buffer !== 'undefined' &&\n                      typeof window === 'undefined';\n\n/* _FROM_SVG_START_ */\n/**\n * Attributes parsed from all SVG elements\n * @type array\n */\nfabric.SHARED_ATTRIBUTES = [\n  \"display\",\n  \"transform\",\n  \"fill\", \"fill-opacity\", \"fill-rule\",\n  \"opacity\",\n  \"stroke\", \"stroke-dasharray\", \"stroke-linecap\",\n  \"stroke-linejoin\", \"stroke-miterlimit\",\n  \"stroke-opacity\", \"stroke-width\",\n  \"id\"\n];\n/* _FROM_SVG_END_ */\n\n/**\n * Pixel per Inch as a default value set to 96. Can be changed for more realistic conversion.\n */\nfabric.DPI = 96;\nfabric.reNum = '(?:[-+]?(?:\\\\d+|\\\\d*\\\\.\\\\d+)(?:e[-+]?\\\\d+)?)';\nfabric.fontPaths = { };\n\n/**\n * Device Pixel Ratio\n * @see https://developer.apple.com/library/safari/documentation/AudioVideo/Conceptual/HTML-canvas-guide/SettingUptheCanvas/SettingUptheCanvas.html\n */\nfabric.devicePixelRatio = fabric.window.devicePixelRatio ||\n                          fabric.window.webkitDevicePixelRatio ||\n                          fabric.window.mozDevicePixelRatio ||\n                          1;\n\n\n(function() {\n\n  /**\n   * @private\n   * @param {String} eventName\n   * @param {Function} handler\n   */\n  function _removeEventListener(eventName, handler) {\n    if (!this.__eventListeners[eventName]) {\n      return;\n    }\n    var eventListener = this.__eventListeners[eventName];\n    if (handler) {\n      eventListener[eventListener.indexOf(handler)] = false;\n    }\n    else {\n      fabric.util.array.fill(eventListener, false);\n    }\n  }\n\n  /**\n   * Observes specified event\n   * @deprecated `observe` deprecated since 0.8.34 (use `on` instead)\n   * @memberOf fabric.Observable\n   * @alias on\n   * @param {String|Object} eventName Event name (eg. 'after:render') or object with key/value pairs (eg. {'after:render': handler, 'selection:cleared': handler})\n   * @param {Function} handler Function that receives a notification when an event of the specified type occurs\n   * @return {Self} thisArg\n   * @chainable\n   */\n  function observe(eventName, handler) {\n    if (!this.__eventListeners) {\n      this.__eventListeners = { };\n    }\n    // one object with key/value pairs was passed\n    if (arguments.length === 1) {\n      for (var prop in eventName) {\n        this.on(prop, eventName[prop]);\n      }\n    }\n    else {\n      if (!this.__eventListeners[eventName]) {\n        this.__eventListeners[eventName] = [ ];\n      }\n      this.__eventListeners[eventName].push(handler);\n    }\n    return this;\n  }\n\n  /**\n   * Stops event observing for a particular event handler. Calling this method\n   * without arguments removes all handlers for all events\n   * @deprecated `stopObserving` deprecated since 0.8.34 (use `off` instead)\n   * @memberOf fabric.Observable\n   * @alias off\n   * @param {String|Object} eventName Event name (eg. 'after:render') or object with key/value pairs (eg. {'after:render': handler, 'selection:cleared': handler})\n   * @param {Function} handler Function to be deleted from EventListeners\n   * @return {Self} thisArg\n   * @chainable\n   */\n  function stopObserving(eventName, handler) {\n    if (!this.__eventListeners) {\n      return;\n    }\n\n    // remove all key/value pairs (event name -> event handler)\n    if (arguments.length === 0) {\n      for (eventName in this.__eventListeners) {\n        _removeEventListener.call(this, eventName);\n      }\n    }\n    // one object with key/value pairs was passed\n    else if (arguments.length === 1 && typeof arguments[0] === 'object') {\n      for (var prop in eventName) {\n        _removeEventListener.call(this, prop, eventName[prop]);\n      }\n    }\n    else {\n      _removeEventListener.call(this, eventName, handler);\n    }\n    return this;\n  }\n\n  /**\n   * Fires event with an optional options object\n   * @deprecated `fire` deprecated since 1.0.7 (use `trigger` instead)\n   * @memberOf fabric.Observable\n   * @alias trigger\n   * @param {String} eventName Event name to fire\n   * @param {Object} [options] Options object\n   * @return {Self} thisArg\n   * @chainable\n   */\n  function fire(eventName, options) {\n    if (!this.__eventListeners) {\n      return;\n    }\n\n    var listenersForEvent = this.__eventListeners[eventName];\n    if (!listenersForEvent) {\n      return;\n    }\n\n    for (var i = 0, len = listenersForEvent.length; i < len; i++) {\n      listenersForEvent[i] && listenersForEvent[i].call(this, options || { });\n    }\n    this.__eventListeners[eventName] = listenersForEvent.filter(function(value) {\n      return value !== false;\n    });\n    return this;\n  }\n\n  /**\n   * @namespace fabric.Observable\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-2#events}\n   * @see {@link http://fabricjs.com/events|Events demo}\n   */\n  fabric.Observable = {\n    observe: observe,\n    stopObserving: stopObserving,\n    fire: fire,\n\n    on: observe,\n    off: stopObserving,\n    trigger: fire\n  };\n})();\n\n\n/**\n * @namespace fabric.Collection\n */\nfabric.Collection = {\n\n  /**\n   * Adds objects to collection, then renders canvas (if `renderOnAddRemove` is not `false`)\n   * Objects should be instances of (or inherit from) fabric.Object\n   * @param {...fabric.Object} object Zero or more fabric instances\n   * @return {Self} thisArg\n   */\n  add: function () {\n    this._objects.push.apply(this._objects, arguments);\n    for (var i = 0, length = arguments.length; i < length; i++) {\n      this._onObjectAdded(arguments[i]);\n    }\n    this.renderOnAddRemove && this.renderAll();\n    return this;\n  },\n\n  /**\n   * Inserts an object into collection at specified index, then renders canvas (if `renderOnAddRemove` is not `false`)\n   * An object should be an instance of (or inherit from) fabric.Object\n   * @param {Object} object Object to insert\n   * @param {Number} index Index to insert object at\n   * @param {Boolean} nonSplicing When `true`, no splicing (shifting) of objects occurs\n   * @return {Self} thisArg\n   * @chainable\n   */\n  insertAt: function (object, index, nonSplicing) {\n    var objects = this.getObjects();\n    if (nonSplicing) {\n      objects[index] = object;\n    }\n    else {\n      objects.splice(index, 0, object);\n    }\n    this._onObjectAdded(object);\n    this.renderOnAddRemove && this.renderAll();\n    return this;\n  },\n\n  /**\n   * Removes objects from a collection, then renders canvas (if `renderOnAddRemove` is not `false`)\n   * @param {...fabric.Object} object Zero or more fabric instances\n   * @return {Self} thisArg\n   * @chainable\n   */\n  remove: function() {\n    var objects = this.getObjects(),\n        index;\n\n    for (var i = 0, length = arguments.length; i < length; i++) {\n      index = objects.indexOf(arguments[i]);\n\n      // only call onObjectRemoved if an object was actually removed\n      if (index !== -1) {\n        objects.splice(index, 1);\n        this._onObjectRemoved(arguments[i]);\n      }\n    }\n\n    this.renderOnAddRemove && this.renderAll();\n    return this;\n  },\n\n  /**\n   * Executes given function for each object in this group\n   * @param {Function} callback\n   *                   Callback invoked with current object as first argument,\n   *                   index - as second and an array of all objects - as third.\n   *                   Iteration happens in reverse order (for performance reasons).\n   *                   Callback is invoked in a context of Global Object (e.g. `window`)\n   *                   when no `context` argument is given\n   *\n   * @param {Object} context Context (aka thisObject)\n   * @return {Self} thisArg\n   */\n  forEachObject: function(callback, context) {\n    var objects = this.getObjects(),\n        i = objects.length;\n    while (i--) {\n      callback.call(context, objects[i], i, objects);\n    }\n    return this;\n  },\n\n  /**\n   * Returns an array of children objects of this instance\n   * Type parameter introduced in 1.3.10\n   * @param {String} [type] When specified, only objects of this type are returned\n   * @return {Array}\n   */\n  getObjects: function(type) {\n    if (typeof type === 'undefined') {\n      return this._objects;\n    }\n    return this._objects.filter(function(o) {\n      return o.type === type;\n    });\n  },\n\n  /**\n   * Returns object at specified index\n   * @param {Number} index\n   * @return {Self} thisArg\n   */\n  item: function (index) {\n    return this.getObjects()[index];\n  },\n\n  /**\n   * Returns true if collection contains no objects\n   * @return {Boolean} true if collection is empty\n   */\n  isEmpty: function () {\n    return this.getObjects().length === 0;\n  },\n\n  /**\n   * Returns a size of a collection (i.e: length of an array containing its objects)\n   * @return {Number} Collection size\n   */\n  size: function() {\n    return this.getObjects().length;\n  },\n\n  /**\n   * Returns true if collection contains an object\n   * @param {Object} object Object to check against\n   * @return {Boolean} `true` if collection contains an object\n   */\n  contains: function(object) {\n    return this.getObjects().indexOf(object) > -1;\n  },\n\n  /**\n   * Returns number representation of a collection complexity\n   * @return {Number} complexity\n   */\n  complexity: function () {\n    return this.getObjects().reduce(function (memo, current) {\n      memo += current.complexity ? current.complexity() : 0;\n      return memo;\n    }, 0);\n  }\n};\n\n\n(function(global) {\n\n  var sqrt = Math.sqrt,\n      atan2 = Math.atan2,\n      pow = Math.pow,\n      abs = Math.abs,\n      PiBy180 = Math.PI / 180;\n\n  /**\n   * @namespace fabric.util\n   */\n  fabric.util = {\n\n    /**\n     * Removes value from an array.\n     * Presence of value (and its position in an array) is determined via `Array.prototype.indexOf`\n     * @static\n     * @memberOf fabric.util\n     * @param {Array} array\n     * @param {Any} value\n     * @return {Array} original array\n     */\n    removeFromArray: function(array, value) {\n      var idx = array.indexOf(value);\n      if (idx !== -1) {\n        array.splice(idx, 1);\n      }\n      return array;\n    },\n\n    /**\n     * Returns random number between 2 specified ones.\n     * @static\n     * @memberOf fabric.util\n     * @param {Number} min lower limit\n     * @param {Number} max upper limit\n     * @return {Number} random value (between min and max)\n     */\n    getRandomInt: function(min, max) {\n      return Math.floor(Math.random() * (max - min + 1)) + min;\n    },\n\n    /**\n     * Transforms degrees to radians.\n     * @static\n     * @memberOf fabric.util\n     * @param {Number} degrees value in degrees\n     * @return {Number} value in radians\n     */\n    degreesToRadians: function(degrees) {\n      return degrees * PiBy180;\n    },\n\n    /**\n     * Transforms radians to degrees.\n     * @static\n     * @memberOf fabric.util\n     * @param {Number} radians value in radians\n     * @return {Number} value in degrees\n     */\n    radiansToDegrees: function(radians) {\n      return radians / PiBy180;\n    },\n\n    /**\n     * Rotates `point` around `origin` with `radians`\n     * @static\n     * @memberOf fabric.util\n     * @param {fabric.Point} point The point to rotate\n     * @param {fabric.Point} origin The origin of the rotation\n     * @param {Number} radians The radians of the angle for the rotation\n     * @return {fabric.Point} The new rotated point\n     */\n    rotatePoint: function(point, origin, radians) {\n      point.subtractEquals(origin);\n      var v = fabric.util.rotateVector(point, radians);\n      return new fabric.Point(v.x, v.y).addEquals(origin);\n    },\n\n    /**\n     * Rotates `vector` with `radians`\n     * @static\n     * @memberOf fabric.util\n     * @param {Object} vector The vector to rotate (x and y)\n     * @param {Number} radians The radians of the angle for the rotation\n     * @return {Object} The new rotated point\n     */\n    rotateVector: function(vector, radians) {\n      var sin = Math.sin(radians),\n          cos = Math.cos(radians),\n          rx = vector.x * cos - vector.y * sin,\n          ry = vector.x * sin + vector.y * cos;\n      return {\n        x: rx,\n        y: ry\n      };\n    },\n\n    /**\n     * Apply transform t to point p\n     * @static\n     * @memberOf fabric.util\n     * @param  {fabric.Point} p The point to transform\n     * @param  {Array} t The transform\n     * @param  {Boolean} [ignoreOffset] Indicates that the offset should not be applied\n     * @return {fabric.Point} The transformed point\n     */\n    transformPoint: function(p, t, ignoreOffset) {\n      if (ignoreOffset) {\n        return new fabric.Point(\n          t[0] * p.x + t[2] * p.y,\n          t[1] * p.x + t[3] * p.y\n        );\n      }\n      return new fabric.Point(\n        t[0] * p.x + t[2] * p.y + t[4],\n        t[1] * p.x + t[3] * p.y + t[5]\n      );\n    },\n\n    /**\n     * Returns coordinates of points's bounding rectangle (left, top, width, height)\n     * @param {Array} points 4 points array\n     * @return {Object} Object with left, top, width, height properties\n     */\n    makeBoundingBoxFromPoints: function(points) {\n      var xPoints = [points[0].x, points[1].x, points[2].x, points[3].x],\n          minX = fabric.util.array.min(xPoints),\n          maxX = fabric.util.array.max(xPoints),\n          width = Math.abs(minX - maxX),\n          yPoints = [points[0].y, points[1].y, points[2].y, points[3].y],\n          minY = fabric.util.array.min(yPoints),\n          maxY = fabric.util.array.max(yPoints),\n          height = Math.abs(minY - maxY);\n\n      return {\n        left: minX,\n        top: minY,\n        width: width,\n        height: height\n      };\n    },\n\n    /**\n     * Invert transformation t\n     * @static\n     * @memberOf fabric.util\n     * @param {Array} t The transform\n     * @return {Array} The inverted transform\n     */\n    invertTransform: function(t) {\n      var a = 1 / (t[0] * t[3] - t[1] * t[2]),\n          r = [a * t[3], -a * t[1], -a * t[2], a * t[0]],\n          o = fabric.util.transformPoint({ x: t[4], y: t[5] }, r, true);\n      r[4] = -o.x;\n      r[5] = -o.y;\n      return r;\n    },\n\n    /**\n     * A wrapper around Number#toFixed, which contrary to native method returns number, not string.\n     * @static\n     * @memberOf fabric.util\n     * @param {Number|String} number number to operate on\n     * @param {Number} fractionDigits number of fraction digits to \"leave\"\n     * @return {Number}\n     */\n    toFixed: function(number, fractionDigits) {\n      return parseFloat(Number(number).toFixed(fractionDigits));\n    },\n\n    /**\n     * Converts from attribute value to pixel value if applicable.\n     * Returns converted pixels or original value not converted.\n     * @param {Number|String} value number to operate on\n     * @return {Number|String}\n     */\n    parseUnit: function(value, fontSize) {\n      var unit = /\\D{0,2}$/.exec(value),\n          number = parseFloat(value);\n      if (!fontSize) {\n        fontSize = fabric.Text.DEFAULT_SVG_FONT_SIZE;\n      }\n      switch (unit[0]) {\n        case 'mm':\n          return number * fabric.DPI / 25.4;\n\n        case 'cm':\n          return number * fabric.DPI / 2.54;\n\n        case 'in':\n          return number * fabric.DPI;\n\n        case 'pt':\n          return number * fabric.DPI / 72; // or * 4 / 3\n\n        case 'pc':\n          return number * fabric.DPI / 72 * 12; // or * 16\n\n        case 'em':\n          return number * fontSize;\n\n        default:\n          return number;\n      }\n    },\n\n    /**\n     * Function which always returns `false`.\n     * @static\n     * @memberOf fabric.util\n     * @return {Boolean}\n     */\n    falseFunction: function() {\n      return false;\n    },\n\n    /**\n     * Returns klass \"Class\" object of given namespace\n     * @memberOf fabric.util\n     * @param {String} type Type of object (eg. 'circle')\n     * @param {String} namespace Namespace to get klass \"Class\" object from\n     * @return {Object} klass \"Class\"\n     */\n    getKlass: function(type, namespace) {\n      // capitalize first letter only\n      type = fabric.util.string.camelize(type.charAt(0).toUpperCase() + type.slice(1));\n      return fabric.util.resolveNamespace(namespace)[type];\n    },\n\n    /**\n     * Returns object of given namespace\n     * @memberOf fabric.util\n     * @param {String} namespace Namespace string e.g. 'fabric.Image.filter' or 'fabric'\n     * @return {Object} Object for given namespace (default fabric)\n     */\n    resolveNamespace: function(namespace) {\n      if (!namespace) {\n        return fabric;\n      }\n\n      var parts = namespace.split('.'),\n          len = parts.length,\n          obj = global || fabric.window;\n\n      for (var i = 0; i < len; ++i) {\n        obj = obj[parts[i]];\n      }\n\n      return obj;\n    },\n\n    /**\n     * Loads image element from given url and passes it to a callback\n     * @memberOf fabric.util\n     * @param {String} url URL representing an image\n     * @param {Function} callback Callback; invoked with loaded image\n     * @param {Any} [context] Context to invoke callback in\n     * @param {Object} [crossOrigin] crossOrigin value to set image element to\n     */\n    loadImage: function(url, callback, context, crossOrigin) {\n      if (!url) {\n        callback && callback.call(context, url);\n        return;\n      }\n\n      var img = fabric.util.createImage();\n\n      /** @ignore */\n      img.onload = function () {\n        callback && callback.call(context, img);\n        img = img.onload = img.onerror = null;\n      };\n\n      /** @ignore */\n      img.onerror = function() {\n        fabric.log('Error loading ' + img.src);\n        callback && callback.call(context, null, true);\n        img = img.onload = img.onerror = null;\n      };\n\n      // data-urls appear to be buggy with crossOrigin\n      // https://github.com/kangax/fabric.js/commit/d0abb90f1cd5c5ef9d2a94d3fb21a22330da3e0a#commitcomment-4513767\n      // see https://code.google.com/p/chromium/issues/detail?id=315152\n      //     https://bugzilla.mozilla.org/show_bug.cgi?id=935069\n      if (url.indexOf('data') !== 0 && crossOrigin) {\n        img.crossOrigin = crossOrigin;\n      }\n\n      img.src = url;\n    },\n\n    /**\n     * Creates corresponding fabric instances from their object representations\n     * @static\n     * @memberOf fabric.util\n     * @param {Array} objects Objects to enliven\n     * @param {Function} callback Callback to invoke when all objects are created\n     * @param {String} namespace Namespace to get klass \"Class\" object from\n     * @param {Function} reviver Method for further parsing of object elements,\n     * called after each fabric object created.\n     */\n    enlivenObjects: function(objects, callback, namespace, reviver) {\n      objects = objects || [ ];\n\n      function onLoaded() {\n        if (++numLoadedObjects === numTotalObjects) {\n          callback && callback(enlivenedObjects);\n        }\n      }\n\n      var enlivenedObjects = [ ],\n          numLoadedObjects = 0,\n          numTotalObjects = objects.length;\n\n      if (!numTotalObjects) {\n        callback && callback(enlivenedObjects);\n        return;\n      }\n\n      objects.forEach(function (o, index) {\n        // if sparse array\n        if (!o || !o.type) {\n          onLoaded();\n          return;\n        }\n        var klass = fabric.util.getKlass(o.type, namespace);\n        if (klass.async) {\n          klass.fromObject(o, function (obj, error) {\n            if (!error) {\n              enlivenedObjects[index] = obj;\n              reviver && reviver(o, enlivenedObjects[index]);\n            }\n            onLoaded();\n          });\n        }\n        else {\n          enlivenedObjects[index] = klass.fromObject(o);\n          reviver && reviver(o, enlivenedObjects[index]);\n          onLoaded();\n        }\n      });\n    },\n\n    /**\n     * Groups SVG elements (usually those retrieved from SVG document)\n     * @static\n     * @memberOf fabric.util\n     * @param {Array} elements SVG elements to group\n     * @param {Object} [options] Options object\n     * @return {fabric.Object|fabric.PathGroup}\n     */\n    groupSVGElements: function(elements, options, path) {\n      var object;\n\n      object = new fabric.PathGroup(elements, options);\n\n      if (typeof path !== 'undefined') {\n        object.setSourcePath(path);\n      }\n      return object;\n    },\n\n    /**\n     * Populates an object with properties of another object\n     * @static\n     * @memberOf fabric.util\n     * @param {Object} source Source object\n     * @param {Object} destination Destination object\n     * @return {Array} properties Propertie names to include\n     */\n    populateWithProperties: function(source, destination, properties) {\n      if (properties && Object.prototype.toString.call(properties) === '[object Array]') {\n        for (var i = 0, len = properties.length; i < len; i++) {\n          if (properties[i] in source) {\n            destination[properties[i]] = source[properties[i]];\n          }\n        }\n      }\n    },\n\n    /**\n     * Draws a dashed line between two points\n     *\n     * This method is used to draw dashed line around selection area.\n     * See <a href=\"http://stackoverflow.com/questions/4576724/dotted-stroke-in-canvas\">dotted stroke in canvas</a>\n     *\n     * @param {CanvasRenderingContext2D} ctx context\n     * @param {Number} x  start x coordinate\n     * @param {Number} y start y coordinate\n     * @param {Number} x2 end x coordinate\n     * @param {Number} y2 end y coordinate\n     * @param {Array} da dash array pattern\n     */\n    drawDashedLine: function(ctx, x, y, x2, y2, da) {\n      var dx = x2 - x,\n          dy = y2 - y,\n          len = sqrt(dx * dx + dy * dy),\n          rot = atan2(dy, dx),\n          dc = da.length,\n          di = 0,\n          draw = true;\n\n      ctx.save();\n      ctx.translate(x, y);\n      ctx.moveTo(0, 0);\n      ctx.rotate(rot);\n\n      x = 0;\n      while (len > x) {\n        x += da[di++ % dc];\n        if (x > len) {\n          x = len;\n        }\n        ctx[draw ? 'lineTo' : 'moveTo'](x, 0);\n        draw = !draw;\n      }\n\n      ctx.restore();\n    },\n\n    /**\n     * Creates canvas element and initializes it via excanvas if necessary\n     * @static\n     * @memberOf fabric.util\n     * @param {CanvasElement} [canvasEl] optional canvas element to initialize;\n     * when not given, element is created implicitly\n     * @return {CanvasElement} initialized canvas element\n     */\n    createCanvasElement: function(canvasEl) {\n      canvasEl || (canvasEl = fabric.document.createElement('canvas'));\n      //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n      if (!canvasEl.getContext && typeof G_vmlCanvasManager !== 'undefined') {\n        G_vmlCanvasManager.initElement(canvasEl);\n      }\n      //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n      return canvasEl;\n    },\n\n    /**\n     * Creates image element (works on client and node)\n     * @static\n     * @memberOf fabric.util\n     * @return {HTMLImageElement} HTML image element\n     */\n    createImage: function() {\n      return fabric.isLikelyNode\n        ? new (require('canvas').Image)()\n        : fabric.document.createElement('img');\n    },\n\n    /**\n     * Creates accessors (getXXX, setXXX) for a \"class\", based on \"stateProperties\" array\n     * @static\n     * @memberOf fabric.util\n     * @param {Object} klass \"Class\" to create accessors for\n     */\n    createAccessors: function(klass) {\n      var proto = klass.prototype;\n\n      for (var i = proto.stateProperties.length; i--; ) {\n\n        var propName = proto.stateProperties[i],\n            capitalizedPropName = propName.charAt(0).toUpperCase() + propName.slice(1),\n            setterName = 'set' + capitalizedPropName,\n            getterName = 'get' + capitalizedPropName;\n\n        // using `new Function` for better introspection\n        if (!proto[getterName]) {\n          proto[getterName] = (function(property) {\n            return new Function('return this.get(\"' + property + '\")');\n          })(propName);\n        }\n        if (!proto[setterName]) {\n          proto[setterName] = (function(property) {\n            return new Function('value', 'return this.set(\"' + property + '\", value)');\n          })(propName);\n        }\n      }\n    },\n\n    /**\n     * @static\n     * @memberOf fabric.util\n     * @param {fabric.Object} receiver Object implementing `clipTo` method\n     * @param {CanvasRenderingContext2D} ctx Context to clip\n     */\n    clipContext: function(receiver, ctx) {\n      ctx.save();\n      ctx.beginPath();\n      receiver.clipTo(ctx);\n      ctx.clip();\n    },\n\n    /**\n     * Multiply matrix A by matrix B to nest transformations\n     * @static\n     * @memberOf fabric.util\n     * @param  {Array} a First transformMatrix\n     * @param  {Array} b Second transformMatrix\n     * @param  {Boolean} is2x2 flag to multiply matrices as 2x2 matrices\n     * @return {Array} The product of the two transform matrices\n     */\n    multiplyTransformMatrices: function(a, b, is2x2) {\n      // Matrix multiply a * b\n      return [\n        a[0] * b[0] + a[2] * b[1],\n        a[1] * b[0] + a[3] * b[1],\n        a[0] * b[2] + a[2] * b[3],\n        a[1] * b[2] + a[3] * b[3],\n        is2x2 ? 0 : a[0] * b[4] + a[2] * b[5] + a[4],\n        is2x2 ? 0 : a[1] * b[4] + a[3] * b[5] + a[5]\n      ];\n    },\n\n    /**\n     * Decomposes standard 2x2 matrix into transform componentes\n     * @static\n     * @memberOf fabric.util\n     * @param  {Array} a transformMatrix\n     * @return {Object} Components of transform\n     */\n    qrDecompose: function(a) {\n      var angle = atan2(a[1], a[0]),\n          denom = pow(a[0], 2) + pow(a[1], 2),\n          scaleX = sqrt(denom),\n          scaleY = (a[0] * a[3] - a[2] * a [1]) / scaleX,\n          skewX = atan2(a[0] * a[2] + a[1] * a [3], denom);\n      return {\n        angle: angle  / PiBy180,\n        scaleX: scaleX,\n        scaleY: scaleY,\n        skewX: skewX / PiBy180,\n        skewY: 0,\n        translateX: a[4],\n        translateY: a[5]\n      };\n    },\n\n    customTransformMatrix: function(scaleX, scaleY, skewX) {\n      var skewMatrixX = [1, 0, abs(Math.tan(skewX * PiBy180)), 1],\n          scaleMatrix = [abs(scaleX), 0, 0, abs(scaleY)];\n      return fabric.util.multiplyTransformMatrices(scaleMatrix, skewMatrixX, true);\n    },\n\n    resetObjectTransform: function (target) {\n      target.scaleX = 1;\n      target.scaleY = 1;\n      target.skewX = 0;\n      target.skewY = 0;\n      target.flipX = false;\n      target.flipY = false;\n      target.setAngle(0);\n    },\n\n    /**\n     * Returns string representation of function body\n     * @param {Function} fn Function to get body of\n     * @return {String} Function body\n     */\n    getFunctionBody: function(fn) {\n      return (String(fn).match(/function[^{]*\\{([\\s\\S]*)\\}/) || {})[1];\n    },\n\n    /**\n     * Returns true if context has transparent pixel\n     * at specified location (taking tolerance into account)\n     * @param {CanvasRenderingContext2D} ctx context\n     * @param {Number} x x coordinate\n     * @param {Number} y y coordinate\n     * @param {Number} tolerance Tolerance\n     */\n    isTransparent: function(ctx, x, y, tolerance) {\n\n      // If tolerance is > 0 adjust start coords to take into account.\n      // If moves off Canvas fix to 0\n      if (tolerance > 0) {\n        if (x > tolerance) {\n          x -= tolerance;\n        }\n        else {\n          x = 0;\n        }\n        if (y > tolerance) {\n          y -= tolerance;\n        }\n        else {\n          y = 0;\n        }\n      }\n\n      var _isTransparent = true,\n          imageData = ctx.getImageData(x, y, (tolerance * 2) || 1, (tolerance * 2) || 1);\n\n      // Split image data - for tolerance > 1, pixelDataSize = 4;\n      for (var i = 3, l = imageData.data.length; i < l; i += 4) {\n        var temp = imageData.data[i];\n        _isTransparent = temp <= 0;\n        if (_isTransparent === false) {\n          break; // Stop if colour found\n        }\n      }\n\n      imageData = null;\n\n      return _isTransparent;\n    },\n\n    /**\n     * Parse preserveAspectRatio attribute from element\n     * @param {string} attribute to be parsed\n     * @return {Object} an object containing align and meetOrSlice attribute\n     */\n    parsePreserveAspectRatioAttribute: function(attribute) {\n      var meetOrSlice = 'meet', alignX = 'Mid', alignY = 'Mid',\n          aspectRatioAttrs = attribute.split(' '), align;\n\n      if (aspectRatioAttrs && aspectRatioAttrs.length) {\n        meetOrSlice = aspectRatioAttrs.pop();\n        if (meetOrSlice !== 'meet' && meetOrSlice !== 'slice') {\n          align = meetOrSlice;\n          meetOrSlice = 'meet';\n        }\n        else if (aspectRatioAttrs.length) {\n          align = aspectRatioAttrs.pop();\n        }\n      }\n      //divide align in alignX and alignY\n      alignX = align !== 'none' ? align.slice(1, 4) : 'none';\n      alignY = align !== 'none' ? align.slice(5, 8) : 'none';\n      return {\n        meetOrSlice: meetOrSlice,\n        alignX: alignX,\n        alignY: alignY\n      };\n    }\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function() {\n\n  var arcToSegmentsCache = { },\n      segmentToBezierCache = { },\n      boundsOfCurveCache = { },\n      _join = Array.prototype.join;\n\n  /* Adapted from http://dxr.mozilla.org/mozilla-central/source/content/svg/content/src/nsSVGPathDataParser.cpp\n   * by Andrea Bogazzi code is under MPL. if you don't have a copy of the license you can take it here\n   * http://mozilla.org/MPL/2.0/\n   */\n  function arcToSegments(toX, toY, rx, ry, large, sweep, rotateX) {\n    var argsString = _join.call(arguments);\n    if (arcToSegmentsCache[argsString]) {\n      return arcToSegmentsCache[argsString];\n    }\n\n    var PI = Math.PI, th = rotateX * PI / 180,\n        sinTh = Math.sin(th),\n        cosTh = Math.cos(th),\n        fromX = 0, fromY = 0;\n\n    rx = Math.abs(rx);\n    ry = Math.abs(ry);\n\n    var px = -cosTh * toX * 0.5 - sinTh * toY * 0.5,\n        py = -cosTh * toY * 0.5 + sinTh * toX * 0.5,\n        rx2 = rx * rx, ry2 = ry * ry, py2 = py * py, px2 = px * px,\n        pl = rx2 * ry2 - rx2 * py2 - ry2 * px2,\n        root = 0;\n\n    if (pl < 0) {\n      var s = Math.sqrt(1 - pl/(rx2 * ry2));\n      rx *= s;\n      ry *= s;\n    }\n    else {\n      root = (large === sweep ? -1.0 : 1.0) *\n              Math.sqrt( pl /(rx2 * py2 + ry2 * px2));\n    }\n\n    var cx = root * rx * py / ry,\n        cy = -root * ry * px / rx,\n        cx1 = cosTh * cx - sinTh * cy + toX * 0.5,\n        cy1 = sinTh * cx + cosTh * cy + toY * 0.5,\n        mTheta = calcVectorAngle(1, 0, (px - cx) / rx, (py - cy) / ry),\n        dtheta = calcVectorAngle((px - cx) / rx, (py - cy) / ry, (-px - cx) / rx, (-py - cy) / ry);\n\n    if (sweep === 0 && dtheta > 0) {\n      dtheta -= 2 * PI;\n    }\n    else if (sweep === 1 && dtheta < 0) {\n      dtheta += 2 * PI;\n    }\n\n    // Convert into cubic bezier segments <= 90deg\n    var segments = Math.ceil(Math.abs(dtheta / PI * 2)),\n        result = [], mDelta = dtheta / segments,\n        mT = 8 / 3 * Math.sin(mDelta / 4) * Math.sin(mDelta / 4) / Math.sin(mDelta / 2),\n        th3 = mTheta + mDelta;\n\n    for (var i = 0; i < segments; i++) {\n      result[i] = segmentToBezier(mTheta, th3, cosTh, sinTh, rx, ry, cx1, cy1, mT, fromX, fromY);\n      fromX = result[i][4];\n      fromY = result[i][5];\n      mTheta = th3;\n      th3 += mDelta;\n    }\n    arcToSegmentsCache[argsString] = result;\n    return result;\n  }\n\n  function segmentToBezier(th2, th3, cosTh, sinTh, rx, ry, cx1, cy1, mT, fromX, fromY) {\n    var argsString2 = _join.call(arguments);\n    if (segmentToBezierCache[argsString2]) {\n      return segmentToBezierCache[argsString2];\n    }\n\n    var costh2 = Math.cos(th2),\n        sinth2 = Math.sin(th2),\n        costh3 = Math.cos(th3),\n        sinth3 = Math.sin(th3),\n        toX = cosTh * rx * costh3 - sinTh * ry * sinth3 + cx1,\n        toY = sinTh * rx * costh3 + cosTh * ry * sinth3 + cy1,\n        cp1X = fromX + mT * ( - cosTh * rx * sinth2 - sinTh * ry * costh2),\n        cp1Y = fromY + mT * ( - sinTh * rx * sinth2 + cosTh * ry * costh2),\n        cp2X = toX + mT * ( cosTh * rx * sinth3 + sinTh * ry * costh3),\n        cp2Y = toY + mT * ( sinTh * rx * sinth3 - cosTh * ry * costh3);\n\n    segmentToBezierCache[argsString2] = [\n      cp1X, cp1Y,\n      cp2X, cp2Y,\n      toX, toY\n    ];\n    return segmentToBezierCache[argsString2];\n  }\n\n  /*\n   * Private\n   */\n  function calcVectorAngle(ux, uy, vx, vy) {\n    var ta = Math.atan2(uy, ux),\n        tb = Math.atan2(vy, vx);\n    if (tb >= ta) {\n      return tb - ta;\n    }\n    else {\n      return 2 * Math.PI - (ta - tb);\n    }\n  }\n\n  /**\n   * Draws arc\n   * @param {CanvasRenderingContext2D} ctx\n   * @param {Number} fx\n   * @param {Number} fy\n   * @param {Array} coords\n   */\n  fabric.util.drawArc = function(ctx, fx, fy, coords) {\n    var rx = coords[0],\n        ry = coords[1],\n        rot = coords[2],\n        large = coords[3],\n        sweep = coords[4],\n        tx = coords[5],\n        ty = coords[6],\n        segs = [[ ], [ ], [ ], [ ]],\n        segsNorm = arcToSegments(tx - fx, ty - fy, rx, ry, large, sweep, rot);\n\n    for (var i = 0, len = segsNorm.length; i < len; i++) {\n      segs[i][0] = segsNorm[i][0] + fx;\n      segs[i][1] = segsNorm[i][1] + fy;\n      segs[i][2] = segsNorm[i][2] + fx;\n      segs[i][3] = segsNorm[i][3] + fy;\n      segs[i][4] = segsNorm[i][4] + fx;\n      segs[i][5] = segsNorm[i][5] + fy;\n      ctx.bezierCurveTo.apply(ctx, segs[i]);\n    }\n  };\n\n  /**\n   * Calculate bounding box of a elliptic-arc\n   * @param {Number} fx start point of arc\n   * @param {Number} fy\n   * @param {Number} rx horizontal radius\n   * @param {Number} ry vertical radius\n   * @param {Number} rot angle of horizontal axe\n   * @param {Number} large 1 or 0, whatever the arc is the big or the small on the 2 points\n   * @param {Number} sweep 1 or 0, 1 clockwise or counterclockwise direction\n   * @param {Number} tx end point of arc\n   * @param {Number} ty\n   */\n  fabric.util.getBoundsOfArc = function(fx, fy, rx, ry, rot, large, sweep, tx, ty) {\n\n    var fromX = 0, fromY = 0, bound = [ ], bounds = [ ],\n    segs = arcToSegments(tx - fx, ty - fy, rx, ry, large, sweep, rot),\n    boundCopy = [[ ], [ ]];\n\n    for (var i = 0, len = segs.length; i < len; i++) {\n      bound = getBoundsOfCurve(fromX, fromY, segs[i][0], segs[i][1], segs[i][2], segs[i][3], segs[i][4], segs[i][5]);\n      boundCopy[0].x = bound[0].x + fx;\n      boundCopy[0].y = bound[0].y + fy;\n      boundCopy[1].x = bound[1].x + fx;\n      boundCopy[1].y = bound[1].y + fy;\n      bounds.push(boundCopy[0]);\n      bounds.push(boundCopy[1]);\n      fromX = segs[i][4];\n      fromY = segs[i][5];\n    }\n    return bounds;\n  };\n\n  /**\n   * Calculate bounding box of a beziercurve\n   * @param {Number} x0 starting point\n   * @param {Number} y0\n   * @param {Number} x1 first control point\n   * @param {Number} y1\n   * @param {Number} x2 secondo control point\n   * @param {Number} y2\n   * @param {Number} x3 end of beizer\n   * @param {Number} y3\n   */\n  // taken from http://jsbin.com/ivomiq/56/edit  no credits available for that.\n  function getBoundsOfCurve(x0, y0, x1, y1, x2, y2, x3, y3) {\n    var argsString = _join.call(arguments);\n    if (boundsOfCurveCache[argsString]) {\n      return boundsOfCurveCache[argsString];\n    }\n\n    var sqrt = Math.sqrt,\n        min = Math.min, max = Math.max,\n        abs = Math.abs, tvalues = [ ],\n        bounds = [[ ], [ ]],\n        a, b, c, t, t1, t2, b2ac, sqrtb2ac;\n\n    b = 6 * x0 - 12 * x1 + 6 * x2;\n    a = -3 * x0 + 9 * x1 - 9 * x2 + 3 * x3;\n    c = 3 * x1 - 3 * x0;\n\n    for (var i = 0; i < 2; ++i) {\n      if (i > 0) {\n        b = 6 * y0 - 12 * y1 + 6 * y2;\n        a = -3 * y0 + 9 * y1 - 9 * y2 + 3 * y3;\n        c = 3 * y1 - 3 * y0;\n      }\n\n      if (abs(a) < 1e-12) {\n        if (abs(b) < 1e-12) {\n          continue;\n        }\n        t = -c / b;\n        if (0 < t && t < 1) {\n          tvalues.push(t);\n        }\n        continue;\n      }\n      b2ac = b * b - 4 * c * a;\n      if (b2ac < 0) {\n        continue;\n      }\n      sqrtb2ac = sqrt(b2ac);\n      t1 = (-b + sqrtb2ac) / (2 * a);\n      if (0 < t1 && t1 < 1) {\n        tvalues.push(t1);\n      }\n      t2 = (-b - sqrtb2ac) / (2 * a);\n      if (0 < t2 && t2 < 1) {\n        tvalues.push(t2);\n      }\n    }\n\n    var x, y, j = tvalues.length, jlen = j, mt;\n    while (j--) {\n      t = tvalues[j];\n      mt = 1 - t;\n      x = (mt * mt * mt * x0) + (3 * mt * mt * t * x1) + (3 * mt * t * t * x2) + (t * t * t * x3);\n      bounds[0][j] = x;\n\n      y = (mt * mt * mt * y0) + (3 * mt * mt * t * y1) + (3 * mt * t * t * y2) + (t * t * t * y3);\n      bounds[1][j] = y;\n    }\n\n    bounds[0][jlen] = x0;\n    bounds[1][jlen] = y0;\n    bounds[0][jlen + 1] = x3;\n    bounds[1][jlen + 1] = y3;\n    var result = [\n      {\n        x: min.apply(null, bounds[0]),\n        y: min.apply(null, bounds[1])\n      },\n      {\n        x: max.apply(null, bounds[0]),\n        y: max.apply(null, bounds[1])\n      }\n    ];\n    boundsOfCurveCache[argsString] = result;\n    return result;\n  }\n\n  fabric.util.getBoundsOfCurve = getBoundsOfCurve;\n\n})();\n\n\n(function() {\n\n  var slice = Array.prototype.slice;\n\n  /* _ES5_COMPAT_START_ */\n\n  if (!Array.prototype.indexOf) {\n    /**\n     * Finds index of an element in an array\n     * @param {Any} searchElement\n     * @param {Number} [fromIndex]\n     * @return {Number}\n     */\n    Array.prototype.indexOf = function (searchElement /*, fromIndex */ ) {\n      if (this === void 0 || this === null) {\n        throw new TypeError();\n      }\n      var t = Object(this), len = t.length >>> 0;\n      if (len === 0) {\n        return -1;\n      }\n      var n = 0;\n      if (arguments.length > 0) {\n        n = Number(arguments[1]);\n        if (n !== n) { // shortcut for verifying if it's NaN\n          n = 0;\n        }\n        else if (n !== 0 && n !== Number.POSITIVE_INFINITY && n !== Number.NEGATIVE_INFINITY) {\n          n = (n > 0 || -1) * Math.floor(Math.abs(n));\n        }\n      }\n      if (n >= len) {\n        return -1;\n      }\n      var k = n >= 0 ? n : Math.max(len - Math.abs(n), 0);\n      for (; k < len; k++) {\n        if (k in t && t[k] === searchElement) {\n          return k;\n        }\n      }\n      return -1;\n    };\n  }\n\n  if (!Array.prototype.forEach) {\n    /**\n     * Iterates an array, invoking callback for each element\n     * @param {Function} fn Callback to invoke for each element\n     * @param {Object} [context] Context to invoke callback in\n     * @return {Array}\n     */\n    Array.prototype.forEach = function(fn, context) {\n      for (var i = 0, len = this.length >>> 0; i < len; i++) {\n        if (i in this) {\n          fn.call(context, this[i], i, this);\n        }\n      }\n    };\n  }\n\n  if (!Array.prototype.map) {\n    /**\n     * Returns a result of iterating over an array, invoking callback for each element\n     * @param {Function} fn Callback to invoke for each element\n     * @param {Object} [context] Context to invoke callback in\n     * @return {Array}\n     */\n    Array.prototype.map = function(fn, context) {\n      var result = [ ];\n      for (var i = 0, len = this.length >>> 0; i < len; i++) {\n        if (i in this) {\n          result[i] = fn.call(context, this[i], i, this);\n        }\n      }\n      return result;\n    };\n  }\n\n  if (!Array.prototype.every) {\n    /**\n     * Returns true if a callback returns truthy value for all elements in an array\n     * @param {Function} fn Callback to invoke for each element\n     * @param {Object} [context] Context to invoke callback in\n     * @return {Boolean}\n     */\n    Array.prototype.every = function(fn, context) {\n      for (var i = 0, len = this.length >>> 0; i < len; i++) {\n        if (i in this && !fn.call(context, this[i], i, this)) {\n          return false;\n        }\n      }\n      return true;\n    };\n  }\n\n  if (!Array.prototype.some) {\n    /**\n     * Returns true if a callback returns truthy value for at least one element in an array\n     * @param {Function} fn Callback to invoke for each element\n     * @param {Object} [context] Context to invoke callback in\n     * @return {Boolean}\n     */\n    Array.prototype.some = function(fn, context) {\n      for (var i = 0, len = this.length >>> 0; i < len; i++) {\n        if (i in this && fn.call(context, this[i], i, this)) {\n          return true;\n        }\n      }\n      return false;\n    };\n  }\n\n  if (!Array.prototype.filter) {\n    /**\n     * Returns the result of iterating over elements in an array\n     * @param {Function} fn Callback to invoke for each element\n     * @param {Object} [context] Context to invoke callback in\n     * @return {Array}\n     */\n    Array.prototype.filter = function(fn, context) {\n      var result = [ ], val;\n      for (var i = 0, len = this.length >>> 0; i < len; i++) {\n        if (i in this) {\n          val = this[i]; // in case fn mutates this\n          if (fn.call(context, val, i, this)) {\n            result.push(val);\n          }\n        }\n      }\n      return result;\n    };\n  }\n\n  if (!Array.prototype.reduce) {\n    /**\n     * Returns \"folded\" (reduced) result of iterating over elements in an array\n     * @param {Function} fn Callback to invoke for each element\n     * @param {Object} [initial] Object to use as the first argument to the first call of the callback\n     * @return {Any}\n     */\n    Array.prototype.reduce = function(fn /*, initial*/) {\n      var len = this.length >>> 0,\n          i = 0,\n          rv;\n\n      if (arguments.length > 1) {\n        rv = arguments[1];\n      }\n      else {\n        do {\n          if (i in this) {\n            rv = this[i++];\n            break;\n          }\n          // if array contains no values, no initial value to return\n          if (++i >= len) {\n            throw new TypeError();\n          }\n        }\n        while (true);\n      }\n      for (; i < len; i++) {\n        if (i in this) {\n          rv = fn.call(null, rv, this[i], i, this);\n        }\n      }\n      return rv;\n    };\n  }\n\n  /* _ES5_COMPAT_END_ */\n\n  /**\n   * Invokes method on all items in a given array\n   * @memberOf fabric.util.array\n   * @param {Array} array Array to iterate over\n   * @param {String} method Name of a method to invoke\n   * @return {Array}\n   */\n  function invoke(array, method) {\n    var args = slice.call(arguments, 2), result = [ ];\n    for (var i = 0, len = array.length; i < len; i++) {\n      result[i] = args.length ? array[i][method].apply(array[i], args) : array[i][method].call(array[i]);\n    }\n    return result;\n  }\n\n  /**\n   * Finds maximum value in array (not necessarily \"first\" one)\n   * @memberOf fabric.util.array\n   * @param {Array} array Array to iterate over\n   * @param {String} byProperty\n   * @return {Any}\n   */\n  function max(array, byProperty) {\n    return find(array, byProperty, function(value1, value2) {\n      return value1 >= value2;\n    });\n  }\n\n  /**\n   * Finds minimum value in array (not necessarily \"first\" one)\n   * @memberOf fabric.util.array\n   * @param {Array} array Array to iterate over\n   * @param {String} byProperty\n   * @return {Any}\n   */\n  function min(array, byProperty) {\n    return find(array, byProperty, function(value1, value2) {\n      return value1 < value2;\n    });\n  }\n\n  /**\n   * @private\n   */\n  function fill(array, value) {\n    var k = array.length;\n    while (k--) {\n      array[k] = value;\n    }\n    return array;\n  }\n\n  /**\n   * @private\n   */\n  function find(array, byProperty, condition) {\n    if (!array || array.length === 0) {\n      return;\n    }\n\n    var i = array.length - 1,\n        result = byProperty ? array[i][byProperty] : array[i];\n    if (byProperty) {\n      while (i--) {\n        if (condition(array[i][byProperty], result)) {\n          result = array[i][byProperty];\n        }\n      }\n    }\n    else {\n      while (i--) {\n        if (condition(array[i], result)) {\n          result = array[i];\n        }\n      }\n    }\n    return result;\n  }\n\n  /**\n   * @namespace fabric.util.array\n   */\n  fabric.util.array = {\n    fill: fill,\n    invoke: invoke,\n    min: min,\n    max: max\n  };\n\n})();\n\n\n(function() {\n\n  /**\n   * Copies all enumerable properties of one object to another\n   * @memberOf fabric.util.object\n   * @param {Object} destination Where to copy to\n   * @param {Object} source Where to copy from\n   * @return {Object}\n   */\n  function extend(destination, source) {\n    // JScript DontEnum bug is not taken care of\n    for (var property in source) {\n      destination[property] = source[property];\n    }\n    return destination;\n  }\n\n  /**\n   * Creates an empty object and copies all enumerable properties of another object to it\n   * @memberOf fabric.util.object\n   * @param {Object} object Object to clone\n   * @return {Object}\n   */\n  function clone(object) {\n    return extend({ }, object);\n  }\n\n  /** @namespace fabric.util.object */\n  fabric.util.object = {\n    extend: extend,\n    clone: clone\n  };\n\n})();\n\n\n(function() {\n\n  /* _ES5_COMPAT_START_ */\n  if (!String.prototype.trim) {\n    /**\n     * Trims a string (removing whitespace from the beginning and the end)\n     * @function external:String#trim\n     * @see <a href=\"https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/String/Trim\">String#trim on MDN</a>\n     */\n    String.prototype.trim = function () {\n      // this trim is not fully ES3 or ES5 compliant, but it should cover most cases for now\n      return this.replace(/^[\\s\\xA0]+/, '').replace(/[\\s\\xA0]+$/, '');\n    };\n  }\n  /* _ES5_COMPAT_END_ */\n\n  /**\n   * Camelizes a string\n   * @memberOf fabric.util.string\n   * @param {String} string String to camelize\n   * @return {String} Camelized version of a string\n   */\n  function camelize(string) {\n    return string.replace(/-+(.)?/g, function(match, character) {\n      return character ? character.toUpperCase() : '';\n    });\n  }\n\n  /**\n   * Capitalizes a string\n   * @memberOf fabric.util.string\n   * @param {String} string String to capitalize\n   * @param {Boolean} [firstLetterOnly] If true only first letter is capitalized\n   * and other letters stay untouched, if false first letter is capitalized\n   * and other letters are converted to lowercase.\n   * @return {String} Capitalized version of a string\n   */\n  function capitalize(string, firstLetterOnly) {\n    return string.charAt(0).toUpperCase() +\n      (firstLetterOnly ? string.slice(1) : string.slice(1).toLowerCase());\n  }\n\n  /**\n   * Escapes XML in a string\n   * @memberOf fabric.util.string\n   * @param {String} string String to escape\n   * @return {String} Escaped version of a string\n   */\n  function escapeXml(string) {\n    return string.replace(/&/g, '&amp;')\n       .replace(/\"/g, '&quot;')\n       .replace(/'/g, '&apos;')\n       .replace(/</g, '&lt;')\n       .replace(/>/g, '&gt;');\n  }\n\n  /**\n   * String utilities\n   * @namespace fabric.util.string\n   */\n  fabric.util.string = {\n    camelize: camelize,\n    capitalize: capitalize,\n    escapeXml: escapeXml\n  };\n}());\n\n\n/* _ES5_COMPAT_START_ */\n(function() {\n\n  var slice = Array.prototype.slice,\n      apply = Function.prototype.apply,\n      Dummy = function() { };\n\n  if (!Function.prototype.bind) {\n    /**\n     * Cross-browser approximation of ES5 Function.prototype.bind (not fully spec conforming)\n     * @see <a href=\"https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Function/bind\">Function#bind on MDN</a>\n     * @param {Object} thisArg Object to bind function to\n     * @param {Any[]} Values to pass to a bound function\n     * @return {Function}\n     */\n    Function.prototype.bind = function(thisArg) {\n      var _this = this, args = slice.call(arguments, 1), bound;\n      if (args.length) {\n        bound = function() {\n          return apply.call(_this, this instanceof Dummy ? this : thisArg, args.concat(slice.call(arguments)));\n        };\n      }\n      else {\n        /** @ignore */\n        bound = function() {\n          return apply.call(_this, this instanceof Dummy ? this : thisArg, arguments);\n        };\n      }\n      Dummy.prototype = this.prototype;\n      bound.prototype = new Dummy();\n\n      return bound;\n    };\n  }\n\n})();\n/* _ES5_COMPAT_END_ */\n\n\n(function() {\n\n  var slice = Array.prototype.slice, emptyFunction = function() { },\n\n      IS_DONTENUM_BUGGY = (function() {\n        for (var p in { toString: 1 }) {\n          if (p === 'toString') {\n            return false;\n          }\n        }\n        return true;\n      })(),\n\n      /** @ignore */\n      addMethods = function(klass, source, parent) {\n        for (var property in source) {\n\n          if (property in klass.prototype &&\n              typeof klass.prototype[property] === 'function' &&\n              (source[property] + '').indexOf('callSuper') > -1) {\n\n            klass.prototype[property] = (function(property) {\n              return function() {\n\n                var superclass = this.constructor.superclass;\n                this.constructor.superclass = parent;\n                var returnValue = source[property].apply(this, arguments);\n                this.constructor.superclass = superclass;\n\n                if (property !== 'initialize') {\n                  return returnValue;\n                }\n              };\n            })(property);\n          }\n          else {\n            klass.prototype[property] = source[property];\n          }\n\n          if (IS_DONTENUM_BUGGY) {\n            if (source.toString !== Object.prototype.toString) {\n              klass.prototype.toString = source.toString;\n            }\n            if (source.valueOf !== Object.prototype.valueOf) {\n              klass.prototype.valueOf = source.valueOf;\n            }\n          }\n        }\n      };\n\n  function Subclass() { }\n\n  function callSuper(methodName) {\n    var fn = this.constructor.superclass.prototype[methodName];\n    return (arguments.length > 1)\n      ? fn.apply(this, slice.call(arguments, 1))\n      : fn.call(this);\n  }\n\n  /**\n   * Helper for creation of \"classes\".\n   * @memberOf fabric.util\n   * @param {Function} [parent] optional \"Class\" to inherit from\n   * @param {Object} [properties] Properties shared by all instances of this class\n   *                  (be careful modifying objects defined here as this would affect all instances)\n   */\n  function createClass() {\n    var parent = null,\n        properties = slice.call(arguments, 0);\n\n    if (typeof properties[0] === 'function') {\n      parent = properties.shift();\n    }\n    function klass() {\n      this.initialize.apply(this, arguments);\n    }\n\n    klass.superclass = parent;\n    klass.subclasses = [ ];\n\n    if (parent) {\n      Subclass.prototype = parent.prototype;\n      klass.prototype = new Subclass();\n      parent.subclasses.push(klass);\n    }\n    for (var i = 0, length = properties.length; i < length; i++) {\n      addMethods(klass, properties[i], parent);\n    }\n    if (!klass.prototype.initialize) {\n      klass.prototype.initialize = emptyFunction;\n    }\n    klass.prototype.constructor = klass;\n    klass.prototype.callSuper = callSuper;\n    return klass;\n  }\n\n  fabric.util.createClass = createClass;\n})();\n\n\n(function () {\n\n  var unknown = 'unknown';\n\n  /* EVENT HANDLING */\n\n  function areHostMethods(object) {\n    var methodNames = Array.prototype.slice.call(arguments, 1),\n        t, i, len = methodNames.length;\n    for (i = 0; i < len; i++) {\n      t = typeof object[methodNames[i]];\n      if (!(/^(?:function|object|unknown)$/).test(t)) {\n        return false;\n      }\n    }\n    return true;\n  }\n\n  /** @ignore */\n  var getElement,\n      setElement,\n      getUniqueId = (function () {\n        var uid = 0;\n        return function (element) {\n          return element.__uniqueID || (element.__uniqueID = 'uniqueID__' + uid++);\n        };\n      })();\n\n  (function () {\n    var elements = { };\n    /** @ignore */\n    getElement = function (uid) {\n      return elements[uid];\n    };\n    /** @ignore */\n    setElement = function (uid, element) {\n      elements[uid] = element;\n    };\n  })();\n\n  function createListener(uid, handler) {\n    return {\n      handler: handler,\n      wrappedHandler: createWrappedHandler(uid, handler)\n    };\n  }\n\n  function createWrappedHandler(uid, handler) {\n    return function (e) {\n      handler.call(getElement(uid), e || fabric.window.event);\n    };\n  }\n\n  function createDispatcher(uid, eventName) {\n    return function (e) {\n      if (handlers[uid] && handlers[uid][eventName]) {\n        var handlersForEvent = handlers[uid][eventName];\n        for (var i = 0, len = handlersForEvent.length; i < len; i++) {\n          handlersForEvent[i].call(this, e || fabric.window.event);\n        }\n      }\n    };\n  }\n\n  var shouldUseAddListenerRemoveListener = (\n        areHostMethods(fabric.document.documentElement, 'addEventListener', 'removeEventListener') &&\n        areHostMethods(fabric.window, 'addEventListener', 'removeEventListener')),\n\n      shouldUseAttachEventDetachEvent = (\n        areHostMethods(fabric.document.documentElement, 'attachEvent', 'detachEvent') &&\n        areHostMethods(fabric.window, 'attachEvent', 'detachEvent')),\n\n      // IE branch\n      listeners = { },\n\n      // DOM L0 branch\n      handlers = { },\n\n      addListener, removeListener;\n\n  if (shouldUseAddListenerRemoveListener) {\n    /** @ignore */\n    addListener = function (element, eventName, handler) {\n      element.addEventListener(eventName, handler, false);\n    };\n    /** @ignore */\n    removeListener = function (element, eventName, handler) {\n      element.removeEventListener(eventName, handler, false);\n    };\n  }\n\n  else if (shouldUseAttachEventDetachEvent) {\n    /** @ignore */\n    addListener = function (element, eventName, handler) {\n      var uid = getUniqueId(element);\n      setElement(uid, element);\n      if (!listeners[uid]) {\n        listeners[uid] = { };\n      }\n      if (!listeners[uid][eventName]) {\n        listeners[uid][eventName] = [ ];\n\n      }\n      var listener = createListener(uid, handler);\n      listeners[uid][eventName].push(listener);\n      element.attachEvent('on' + eventName, listener.wrappedHandler);\n    };\n    /** @ignore */\n    removeListener = function (element, eventName, handler) {\n      var uid = getUniqueId(element), listener;\n      if (listeners[uid] && listeners[uid][eventName]) {\n        for (var i = 0, len = listeners[uid][eventName].length; i < len; i++) {\n          listener = listeners[uid][eventName][i];\n          if (listener && listener.handler === handler) {\n            element.detachEvent('on' + eventName, listener.wrappedHandler);\n            listeners[uid][eventName][i] = null;\n          }\n        }\n      }\n    };\n  }\n  else {\n    /** @ignore */\n    addListener = function (element, eventName, handler) {\n      var uid = getUniqueId(element);\n      if (!handlers[uid]) {\n        handlers[uid] = { };\n      }\n      if (!handlers[uid][eventName]) {\n        handlers[uid][eventName] = [ ];\n        var existingHandler = element['on' + eventName];\n        if (existingHandler) {\n          handlers[uid][eventName].push(existingHandler);\n        }\n        element['on' + eventName] = createDispatcher(uid, eventName);\n      }\n      handlers[uid][eventName].push(handler);\n    };\n    /** @ignore */\n    removeListener = function (element, eventName, handler) {\n      var uid = getUniqueId(element);\n      if (handlers[uid] && handlers[uid][eventName]) {\n        var handlersForEvent = handlers[uid][eventName];\n        for (var i = 0, len = handlersForEvent.length; i < len; i++) {\n          if (handlersForEvent[i] === handler) {\n            handlersForEvent.splice(i, 1);\n          }\n        }\n      }\n    };\n  }\n\n  /**\n   * Adds an event listener to an element\n   * @function\n   * @memberOf fabric.util\n   * @param {HTMLElement} element\n   * @param {String} eventName\n   * @param {Function} handler\n   */\n  fabric.util.addListener = addListener;\n\n  /**\n   * Removes an event listener from an element\n   * @function\n   * @memberOf fabric.util\n   * @param {HTMLElement} element\n   * @param {String} eventName\n   * @param {Function} handler\n   */\n  fabric.util.removeListener = removeListener;\n\n  /**\n   * Cross-browser wrapper for getting event's coordinates\n   * @memberOf fabric.util\n   * @param {Event} event Event object\n   */\n  function getPointer(event) {\n    event || (event = fabric.window.event);\n\n    var element = event.target ||\n                  (typeof event.srcElement !== unknown ? event.srcElement : null),\n\n        scroll = fabric.util.getScrollLeftTop(element);\n\n    return {\n      x: pointerX(event) + scroll.left,\n      y: pointerY(event) + scroll.top\n    };\n  }\n\n  var pointerX = function(event) {\n    // looks like in IE (<9) clientX at certain point (apparently when mouseup fires on VML element)\n    // is represented as COM object, with all the consequences, like \"unknown\" type and error on [[Get]]\n    // need to investigate later\n    return (typeof event.clientX !== unknown ? event.clientX : 0);\n  },\n\n  pointerY = function(event) {\n    return (typeof event.clientY !== unknown ? event.clientY : 0);\n  };\n\n  function _getPointer(event, pageProp, clientProp) {\n    var touchProp = event.type === 'touchend' ? 'changedTouches' : 'touches';\n\n    return (event[touchProp] && event[touchProp][0]\n      ? (event[touchProp][0][pageProp] - (event[touchProp][0][pageProp] - event[touchProp][0][clientProp]))\n        || event[clientProp]\n      : event[clientProp]);\n  }\n\n  if (fabric.isTouchSupported) {\n    pointerX = function(event) {\n      return _getPointer(event, 'pageX', 'clientX');\n    };\n    pointerY = function(event) {\n      return _getPointer(event, 'pageY', 'clientY');\n    };\n  }\n\n  fabric.util.getPointer = getPointer;\n\n  fabric.util.object.extend(fabric.util, fabric.Observable);\n\n})();\n\n\n(function () {\n\n  /**\n   * Cross-browser wrapper for setting element's style\n   * @memberOf fabric.util\n   * @param {HTMLElement} element\n   * @param {Object} styles\n   * @return {HTMLElement} Element that was passed as a first argument\n   */\n  function setStyle(element, styles) {\n    var elementStyle = element.style;\n    if (!elementStyle) {\n      return element;\n    }\n    if (typeof styles === 'string') {\n      element.style.cssText += ';' + styles;\n      return styles.indexOf('opacity') > -1\n        ? setOpacity(element, styles.match(/opacity:\\s*(\\d?\\.?\\d*)/)[1])\n        : element;\n    }\n    for (var property in styles) {\n      if (property === 'opacity') {\n        setOpacity(element, styles[property]);\n      }\n      else {\n        var normalizedProperty = (property === 'float' || property === 'cssFloat')\n          ? (typeof elementStyle.styleFloat === 'undefined' ? 'cssFloat' : 'styleFloat')\n          : property;\n        elementStyle[normalizedProperty] = styles[property];\n      }\n    }\n    return element;\n  }\n\n  var parseEl = fabric.document.createElement('div'),\n      supportsOpacity = typeof parseEl.style.opacity === 'string',\n      supportsFilters = typeof parseEl.style.filter === 'string',\n      reOpacity = /alpha\\s*\\(\\s*opacity\\s*=\\s*([^\\)]+)\\)/,\n\n      /** @ignore */\n      setOpacity = function (element) { return element; };\n\n  if (supportsOpacity) {\n    /** @ignore */\n    setOpacity = function(element, value) {\n      element.style.opacity = value;\n      return element;\n    };\n  }\n  else if (supportsFilters) {\n    /** @ignore */\n    setOpacity = function(element, value) {\n      var es = element.style;\n      if (element.currentStyle && !element.currentStyle.hasLayout) {\n        es.zoom = 1;\n      }\n      if (reOpacity.test(es.filter)) {\n        value = value >= 0.9999 ? '' : ('alpha(opacity=' + (value * 100) + ')');\n        es.filter = es.filter.replace(reOpacity, value);\n      }\n      else {\n        es.filter += ' alpha(opacity=' + (value * 100) + ')';\n      }\n      return element;\n    };\n  }\n\n  fabric.util.setStyle = setStyle;\n\n})();\n\n\n(function() {\n\n  var _slice = Array.prototype.slice;\n\n  /**\n   * Takes id and returns an element with that id (if one exists in a document)\n   * @memberOf fabric.util\n   * @param {String|HTMLElement} id\n   * @return {HTMLElement|null}\n   */\n  function getById(id) {\n    return typeof id === 'string' ? fabric.document.getElementById(id) : id;\n  }\n\n  var sliceCanConvertNodelists,\n      /**\n       * Converts an array-like object (e.g. arguments or NodeList) to an array\n       * @memberOf fabric.util\n       * @param {Object} arrayLike\n       * @return {Array}\n       */\n      toArray = function(arrayLike) {\n        return _slice.call(arrayLike, 0);\n      };\n\n  try {\n    sliceCanConvertNodelists = toArray(fabric.document.childNodes) instanceof Array;\n  }\n  catch (err) { }\n\n  if (!sliceCanConvertNodelists) {\n    toArray = function(arrayLike) {\n      var arr = new Array(arrayLike.length), i = arrayLike.length;\n      while (i--) {\n        arr[i] = arrayLike[i];\n      }\n      return arr;\n    };\n  }\n\n  /**\n   * Creates specified element with specified attributes\n   * @memberOf fabric.util\n   * @param {String} tagName Type of an element to create\n   * @param {Object} [attributes] Attributes to set on an element\n   * @return {HTMLElement} Newly created element\n   */\n  function makeElement(tagName, attributes) {\n    var el = fabric.document.createElement(tagName);\n    for (var prop in attributes) {\n      if (prop === 'class') {\n        el.className = attributes[prop];\n      }\n      else if (prop === 'for') {\n        el.htmlFor = attributes[prop];\n      }\n      else {\n        el.setAttribute(prop, attributes[prop]);\n      }\n    }\n    return el;\n  }\n\n  /**\n   * Adds class to an element\n   * @memberOf fabric.util\n   * @param {HTMLElement} element Element to add class to\n   * @param {String} className Class to add to an element\n   */\n  function addClass(element, className) {\n    if (element && (' ' + element.className + ' ').indexOf(' ' + className + ' ') === -1) {\n      element.className += (element.className ? ' ' : '') + className;\n    }\n  }\n\n  /**\n   * Wraps element with another element\n   * @memberOf fabric.util\n   * @param {HTMLElement} element Element to wrap\n   * @param {HTMLElement|String} wrapper Element to wrap with\n   * @param {Object} [attributes] Attributes to set on a wrapper\n   * @return {HTMLElement} wrapper\n   */\n  function wrapElement(element, wrapper, attributes) {\n    if (typeof wrapper === 'string') {\n      wrapper = makeElement(wrapper, attributes);\n    }\n    if (element.parentNode) {\n      element.parentNode.replaceChild(wrapper, element);\n    }\n    wrapper.appendChild(element);\n    return wrapper;\n  }\n\n  /**\n   * Returns element scroll offsets\n   * @memberOf fabric.util\n   * @param {HTMLElement} element Element to operate on\n   * @return {Object} Object with left/top values\n   */\n  function getScrollLeftTop(element) {\n\n    var left = 0,\n        top = 0,\n        docElement = fabric.document.documentElement,\n        body = fabric.document.body || {\n          scrollLeft: 0, scrollTop: 0\n        };\n\n    // While loop checks (and then sets element to) .parentNode OR .host\n    //  to account for ShadowDOM. We still want to traverse up out of ShadowDOM,\n    //  but the .parentNode of a root ShadowDOM node will always be null, instead\n    //  it should be accessed through .host. See http://stackoverflow.com/a/24765528/4383938\n    while (element && (element.parentNode || element.host)) {\n\n      // Set element to element parent, or 'host' in case of ShadowDOM\n      element = element.parentNode || element.host;\n\n      if (element === fabric.document) {\n        left = body.scrollLeft || docElement.scrollLeft || 0;\n        top = body.scrollTop ||  docElement.scrollTop || 0;\n      }\n      else {\n        left += element.scrollLeft || 0;\n        top += element.scrollTop || 0;\n      }\n\n      if (element.nodeType === 1 &&\n          fabric.util.getElementStyle(element, 'position') === 'fixed') {\n        break;\n      }\n    }\n\n    return { left: left, top: top };\n  }\n\n  /**\n   * Returns offset for a given element\n   * @function\n   * @memberOf fabric.util\n   * @param {HTMLElement} element Element to get offset for\n   * @return {Object} Object with \"left\" and \"top\" properties\n   */\n  function getElementOffset(element) {\n    var docElem,\n        doc = element && element.ownerDocument,\n        box = { left: 0, top: 0 },\n        offset = { left: 0, top: 0 },\n        scrollLeftTop,\n        offsetAttributes = {\n          borderLeftWidth: 'left',\n          borderTopWidth:  'top',\n          paddingLeft:     'left',\n          paddingTop:      'top'\n        };\n\n    if (!doc) {\n      return offset;\n    }\n\n    for (var attr in offsetAttributes) {\n      offset[offsetAttributes[attr]] += parseInt(getElementStyle(element, attr), 10) || 0;\n    }\n\n    docElem = doc.documentElement;\n    if ( typeof element.getBoundingClientRect !== 'undefined' ) {\n      box = element.getBoundingClientRect();\n    }\n\n    scrollLeftTop = getScrollLeftTop(element);\n\n    return {\n      left: box.left + scrollLeftTop.left - (docElem.clientLeft || 0) + offset.left,\n      top: box.top + scrollLeftTop.top - (docElem.clientTop || 0)  + offset.top\n    };\n  }\n\n  /**\n   * Returns style attribute value of a given element\n   * @memberOf fabric.util\n   * @param {HTMLElement} element Element to get style attribute for\n   * @param {String} attr Style attribute to get for element\n   * @return {String} Style attribute value of the given element.\n   */\n  var getElementStyle;\n  if (fabric.document.defaultView && fabric.document.defaultView.getComputedStyle) {\n    getElementStyle = function(element, attr) {\n      var style = fabric.document.defaultView.getComputedStyle(element, null);\n      return style ? style[attr] : undefined;\n    };\n  }\n  else {\n    getElementStyle = function(element, attr) {\n      var value = element.style[attr];\n      if (!value && element.currentStyle) {\n        value = element.currentStyle[attr];\n      }\n      return value;\n    };\n  }\n\n  (function () {\n    var style = fabric.document.documentElement.style,\n        selectProp = 'userSelect' in style\n          ? 'userSelect'\n          : 'MozUserSelect' in style\n            ? 'MozUserSelect'\n            : 'WebkitUserSelect' in style\n              ? 'WebkitUserSelect'\n              : 'KhtmlUserSelect' in style\n                ? 'KhtmlUserSelect'\n                : '';\n\n    /**\n     * Makes element unselectable\n     * @memberOf fabric.util\n     * @param {HTMLElement} element Element to make unselectable\n     * @return {HTMLElement} Element that was passed in\n     */\n    function makeElementUnselectable(element) {\n      if (typeof element.onselectstart !== 'undefined') {\n        element.onselectstart = fabric.util.falseFunction;\n      }\n      if (selectProp) {\n        element.style[selectProp] = 'none';\n      }\n      else if (typeof element.unselectable === 'string') {\n        element.unselectable = 'on';\n      }\n      return element;\n    }\n\n    /**\n     * Makes element selectable\n     * @memberOf fabric.util\n     * @param {HTMLElement} element Element to make selectable\n     * @return {HTMLElement} Element that was passed in\n     */\n    function makeElementSelectable(element) {\n      if (typeof element.onselectstart !== 'undefined') {\n        element.onselectstart = null;\n      }\n      if (selectProp) {\n        element.style[selectProp] = '';\n      }\n      else if (typeof element.unselectable === 'string') {\n        element.unselectable = '';\n      }\n      return element;\n    }\n\n    fabric.util.makeElementUnselectable = makeElementUnselectable;\n    fabric.util.makeElementSelectable = makeElementSelectable;\n  })();\n\n  (function() {\n\n    /**\n     * Inserts a script element with a given url into a document; invokes callback, when that script is finished loading\n     * @memberOf fabric.util\n     * @param {String} url URL of a script to load\n     * @param {Function} callback Callback to execute when script is finished loading\n     */\n    function getScript(url, callback) {\n      var headEl = fabric.document.getElementsByTagName('head')[0],\n          scriptEl = fabric.document.createElement('script'),\n          loading = true;\n\n      /** @ignore */\n      scriptEl.onload = /** @ignore */ scriptEl.onreadystatechange = function(e) {\n        if (loading) {\n          if (typeof this.readyState === 'string' &&\n              this.readyState !== 'loaded' &&\n              this.readyState !== 'complete') {\n            return;\n          }\n          loading = false;\n          callback(e || fabric.window.event);\n          scriptEl = scriptEl.onload = scriptEl.onreadystatechange = null;\n        }\n      };\n      scriptEl.src = url;\n      headEl.appendChild(scriptEl);\n      // causes issue in Opera\n      // headEl.removeChild(scriptEl);\n    }\n\n    fabric.util.getScript = getScript;\n  })();\n\n  fabric.util.getById = getById;\n  fabric.util.toArray = toArray;\n  fabric.util.makeElement = makeElement;\n  fabric.util.addClass = addClass;\n  fabric.util.wrapElement = wrapElement;\n  fabric.util.getScrollLeftTop = getScrollLeftTop;\n  fabric.util.getElementOffset = getElementOffset;\n  fabric.util.getElementStyle = getElementStyle;\n\n})();\n\n\n(function() {\n\n  function addParamToUrl(url, param) {\n    return url + (/\\?/.test(url) ? '&' : '?') + param;\n  }\n\n  var makeXHR = (function() {\n    var factories = [\n      function() { return new ActiveXObject('Microsoft.XMLHTTP'); },\n      function() { return new ActiveXObject('Msxml2.XMLHTTP'); },\n      function() { return new ActiveXObject('Msxml2.XMLHTTP.3.0'); },\n      function() { return new XMLHttpRequest(); }\n    ];\n    for (var i = factories.length; i--; ) {\n      try {\n        var req = factories[i]();\n        if (req) {\n          return factories[i];\n        }\n      }\n      catch (err) { }\n    }\n  })();\n\n  function emptyFn() { }\n\n  /**\n   * Cross-browser abstraction for sending XMLHttpRequest\n   * @memberOf fabric.util\n   * @param {String} url URL to send XMLHttpRequest to\n   * @param {Object} [options] Options object\n   * @param {String} [options.method=\"GET\"]\n   * @param {Function} options.onComplete Callback to invoke when request is completed\n   * @return {XMLHttpRequest} request\n   */\n  function request(url, options) {\n\n    options || (options = { });\n\n    var method = options.method ? options.method.toUpperCase() : 'GET',\n        onComplete = options.onComplete || function() { },\n        xhr = makeXHR(),\n        body;\n\n    /** @ignore */\n    xhr.onreadystatechange = function() {\n      if (xhr.readyState === 4) {\n        onComplete(xhr);\n        xhr.onreadystatechange = emptyFn;\n      }\n    };\n\n    if (method === 'GET') {\n      body = null;\n      if (typeof options.parameters === 'string') {\n        url = addParamToUrl(url, options.parameters);\n      }\n    }\n\n    xhr.open(method, url, true);\n\n    if (method === 'POST' || method === 'PUT') {\n      xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');\n    }\n\n    xhr.send(body);\n    return xhr;\n  }\n\n  fabric.util.request = request;\n})();\n\n\n/**\n * Wrapper around `console.log` (when available)\n * @param {Any} [values] Values to log\n */\nfabric.log = function() { };\n\n/**\n * Wrapper around `console.warn` (when available)\n * @param {Any} [values] Values to log as a warning\n */\nfabric.warn = function() { };\n\n/* jshint ignore:start */\nif (typeof console !== 'undefined') {\n\n  ['log', 'warn'].forEach(function(methodName) {\n\n    if (typeof console[methodName] !== 'undefined' &&\n        typeof console[methodName].apply === 'function') {\n\n      fabric[methodName] = function() {\n        return console[methodName].apply(console, arguments);\n      };\n    }\n  });\n}\n/* jshint ignore:end */\n\n\n(function() {\n\n  /**\n   * Changes value from one to another within certain period of time, invoking callbacks as value is being changed.\n   * @memberOf fabric.util\n   * @param {Object} [options] Animation options\n   * @param {Function} [options.onChange] Callback; invoked on every value change\n   * @param {Function} [options.onComplete] Callback; invoked when value change is completed\n   * @param {Number} [options.startValue=0] Starting value\n   * @param {Number} [options.endValue=100] Ending value\n   * @param {Number} [options.byValue=100] Value to modify the property by\n   * @param {Function} [options.easing] Easing function\n   * @param {Number} [options.duration=500] Duration of change (in ms)\n   */\n  function animate(options) {\n\n    requestAnimFrame(function(timestamp) {\n      options || (options = { });\n\n      var start = timestamp || +new Date(),\n          duration = options.duration || 500,\n          finish = start + duration, time,\n          onChange = options.onChange || function() { },\n          abort = options.abort || function() { return false; },\n          easing = options.easing || function(t, b, c, d) {return -c * Math.cos(t / d * (Math.PI / 2)) + c + b;},\n          startValue = 'startValue' in options ? options.startValue : 0,\n          endValue = 'endValue' in options ? options.endValue : 100,\n          byValue = options.byValue || endValue - startValue;\n\n      options.onStart && options.onStart();\n\n      (function tick(ticktime) {\n        time = ticktime || +new Date();\n        var currentTime = time > finish ? duration : (time - start);\n        if (abort()) {\n          options.onComplete && options.onComplete();\n          return;\n        }\n        onChange(easing(currentTime, startValue, byValue, duration));\n        if (time > finish) {\n          options.onComplete && options.onComplete();\n          return;\n        }\n        requestAnimFrame(tick);\n      })(start);\n    });\n\n  }\n\n  var _requestAnimFrame = fabric.window.requestAnimationFrame       ||\n                          fabric.window.webkitRequestAnimationFrame ||\n                          fabric.window.mozRequestAnimationFrame    ||\n                          fabric.window.oRequestAnimationFrame      ||\n                          fabric.window.msRequestAnimationFrame     ||\n                          function(callback) {\n                            fabric.window.setTimeout(callback, 1000 / 60);\n                          };\n\n  /**\n   * requestAnimationFrame polyfill based on http://paulirish.com/2011/requestanimationframe-for-smart-animating/\n   * In order to get a precise start time, `requestAnimFrame` should be called as an entry into the method\n   * @memberOf fabric.util\n   * @param {Function} callback Callback to invoke\n   * @param {DOMElement} element optional Element to associate with animation\n   */\n  function requestAnimFrame() {\n    return _requestAnimFrame.apply(fabric.window, arguments);\n  }\n\n  fabric.util.animate = animate;\n  fabric.util.requestAnimFrame = requestAnimFrame;\n\n})();\n\n\n(function() {\n\n  function normalize(a, c, p, s) {\n    if (a < Math.abs(c)) {\n      a = c;\n      s = p / 4;\n    }\n    else {\n      //handle the 0/0 case:\n      if (c === 0 && a === 0) {\n        s = p / (2 * Math.PI) * Math.asin(1);\n      }\n      else {\n        s = p / (2 * Math.PI) * Math.asin(c / a);\n      }\n    }\n    return { a: a, c: c, p: p, s: s };\n  }\n\n  function elastic(opts, t, d) {\n    return opts.a *\n      Math.pow(2, 10 * (t -= 1)) *\n      Math.sin( (t * d - opts.s) * (2 * Math.PI) / opts.p );\n  }\n\n  /**\n   * Cubic easing out\n   * @memberOf fabric.util.ease\n   */\n  function easeOutCubic(t, b, c, d) {\n    return c * ((t = t / d - 1) * t * t + 1) + b;\n  }\n\n  /**\n   * Cubic easing in and out\n   * @memberOf fabric.util.ease\n   */\n  function easeInOutCubic(t, b, c, d) {\n    t /= d/2;\n    if (t < 1) {\n      return c / 2 * t * t * t + b;\n    }\n    return c / 2 * ((t -= 2) * t * t + 2) + b;\n  }\n\n  /**\n   * Quartic easing in\n   * @memberOf fabric.util.ease\n   */\n  function easeInQuart(t, b, c, d) {\n    return c * (t /= d) * t * t * t + b;\n  }\n\n  /**\n   * Quartic easing out\n   * @memberOf fabric.util.ease\n   */\n  function easeOutQuart(t, b, c, d) {\n    return -c * ((t = t / d - 1) * t * t * t - 1) + b;\n  }\n\n  /**\n   * Quartic easing in and out\n   * @memberOf fabric.util.ease\n   */\n  function easeInOutQuart(t, b, c, d) {\n    t /= d / 2;\n    if (t < 1) {\n      return c / 2 * t * t * t * t + b;\n    }\n    return -c / 2 * ((t -= 2) * t * t * t - 2) + b;\n  }\n\n  /**\n   * Quintic easing in\n   * @memberOf fabric.util.ease\n   */\n  function easeInQuint(t, b, c, d) {\n    return c * (t /= d) * t * t * t * t + b;\n  }\n\n  /**\n   * Quintic easing out\n   * @memberOf fabric.util.ease\n   */\n  function easeOutQuint(t, b, c, d) {\n    return c * ((t = t / d - 1) * t * t * t * t + 1) + b;\n  }\n\n  /**\n   * Quintic easing in and out\n   * @memberOf fabric.util.ease\n   */\n  function easeInOutQuint(t, b, c, d) {\n    t /= d / 2;\n    if (t < 1) {\n      return c / 2 * t * t * t * t * t + b;\n    }\n    return c / 2 * ((t -= 2) * t * t * t * t + 2) + b;\n  }\n\n  /**\n   * Sinusoidal easing in\n   * @memberOf fabric.util.ease\n   */\n  function easeInSine(t, b, c, d) {\n    return -c * Math.cos(t / d * (Math.PI / 2)) + c + b;\n  }\n\n  /**\n   * Sinusoidal easing out\n   * @memberOf fabric.util.ease\n   */\n  function easeOutSine(t, b, c, d) {\n    return c * Math.sin(t / d * (Math.PI / 2)) + b;\n  }\n\n  /**\n   * Sinusoidal easing in and out\n   * @memberOf fabric.util.ease\n   */\n  function easeInOutSine(t, b, c, d) {\n    return -c / 2 * (Math.cos(Math.PI * t / d) - 1) + b;\n  }\n\n  /**\n   * Exponential easing in\n   * @memberOf fabric.util.ease\n   */\n  function easeInExpo(t, b, c, d) {\n    return (t === 0) ? b : c * Math.pow(2, 10 * (t / d - 1)) + b;\n  }\n\n  /**\n   * Exponential easing out\n   * @memberOf fabric.util.ease\n   */\n  function easeOutExpo(t, b, c, d) {\n    return (t === d) ? b + c : c * (-Math.pow(2, -10 * t / d) + 1) + b;\n  }\n\n  /**\n   * Exponential easing in and out\n   * @memberOf fabric.util.ease\n   */\n  function easeInOutExpo(t, b, c, d) {\n    if (t === 0) {\n      return b;\n    }\n    if (t === d) {\n      return b + c;\n    }\n    t /= d / 2;\n    if (t < 1) {\n      return c / 2 * Math.pow(2, 10 * (t - 1)) + b;\n    }\n    return c / 2 * (-Math.pow(2, -10 * --t) + 2) + b;\n  }\n\n  /**\n   * Circular easing in\n   * @memberOf fabric.util.ease\n   */\n  function easeInCirc(t, b, c, d) {\n    return -c * (Math.sqrt(1 - (t /= d) * t) - 1) + b;\n  }\n\n  /**\n   * Circular easing out\n   * @memberOf fabric.util.ease\n   */\n  function easeOutCirc(t, b, c, d) {\n    return c * Math.sqrt(1 - (t = t / d - 1) * t) + b;\n  }\n\n  /**\n   * Circular easing in and out\n   * @memberOf fabric.util.ease\n   */\n  function easeInOutCirc(t, b, c, d) {\n    t /= d / 2;\n    if (t < 1) {\n      return -c / 2 * (Math.sqrt(1 - t * t) - 1) + b;\n    }\n    return c / 2 * (Math.sqrt(1 - (t -= 2) * t) + 1) + b;\n  }\n\n  /**\n   * Elastic easing in\n   * @memberOf fabric.util.ease\n   */\n  function easeInElastic(t, b, c, d) {\n    var s = 1.70158, p = 0, a = c;\n    if (t === 0) {\n      return b;\n    }\n    t /= d;\n    if (t === 1) {\n      return b + c;\n    }\n    if (!p) {\n      p = d * 0.3;\n    }\n    var opts = normalize(a, c, p, s);\n    return -elastic(opts, t, d) + b;\n  }\n\n  /**\n   * Elastic easing out\n   * @memberOf fabric.util.ease\n   */\n  function easeOutElastic(t, b, c, d) {\n    var s = 1.70158, p = 0, a = c;\n    if (t === 0) {\n      return b;\n    }\n    t /= d;\n    if (t === 1) {\n      return b + c;\n    }\n    if (!p) {\n      p = d * 0.3;\n    }\n    var opts = normalize(a, c, p, s);\n    return opts.a * Math.pow(2, -10 * t) * Math.sin((t * d - opts.s) * (2 * Math.PI) / opts.p ) + opts.c + b;\n  }\n\n  /**\n   * Elastic easing in and out\n   * @memberOf fabric.util.ease\n   */\n  function easeInOutElastic(t, b, c, d) {\n    var s = 1.70158, p = 0, a = c;\n    if (t === 0) {\n      return b;\n    }\n    t /= d / 2;\n    if (t === 2) {\n      return b + c;\n    }\n    if (!p) {\n      p = d * (0.3 * 1.5);\n    }\n    var opts = normalize(a, c, p, s);\n    if (t < 1) {\n      return -0.5 * elastic(opts, t, d) + b;\n    }\n    return opts.a * Math.pow(2, -10 * (t -= 1)) *\n      Math.sin((t * d - opts.s) * (2 * Math.PI) / opts.p ) * 0.5 + opts.c + b;\n  }\n\n  /**\n   * Backwards easing in\n   * @memberOf fabric.util.ease\n   */\n  function easeInBack(t, b, c, d, s) {\n    if (s === undefined) {\n      s = 1.70158;\n    }\n    return c * (t /= d) * t * ((s + 1) * t - s) + b;\n  }\n\n  /**\n   * Backwards easing out\n   * @memberOf fabric.util.ease\n   */\n  function easeOutBack(t, b, c, d, s) {\n    if (s === undefined) {\n      s = 1.70158;\n    }\n    return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;\n  }\n\n  /**\n   * Backwards easing in and out\n   * @memberOf fabric.util.ease\n   */\n  function easeInOutBack(t, b, c, d, s) {\n    if (s === undefined) {\n      s = 1.70158;\n    }\n    t /= d / 2;\n    if (t < 1) {\n      return c / 2 * (t * t * (((s *= (1.525)) + 1) * t - s)) + b;\n    }\n    return c / 2 * ((t -= 2) * t * (((s *= (1.525)) + 1) * t + s) + 2) + b;\n  }\n\n  /**\n   * Bouncing easing in\n   * @memberOf fabric.util.ease\n   */\n  function easeInBounce(t, b, c, d) {\n    return c - easeOutBounce (d - t, 0, c, d) + b;\n  }\n\n  /**\n   * Bouncing easing out\n   * @memberOf fabric.util.ease\n   */\n  function easeOutBounce(t, b, c, d) {\n    if ((t /= d) < (1 / 2.75)) {\n      return c * (7.5625 * t * t) + b;\n    }\n    else if (t < (2/2.75)) {\n      return c * (7.5625 * (t -= (1.5 / 2.75)) * t + 0.75) + b;\n    }\n    else if (t < (2.5/2.75)) {\n      return c * (7.5625 * (t -= (2.25 / 2.75)) * t + 0.9375) + b;\n    }\n    else {\n      return c * (7.5625 * (t -= (2.625 / 2.75)) * t + 0.984375) + b;\n    }\n  }\n\n  /**\n   * Bouncing easing in and out\n   * @memberOf fabric.util.ease\n   */\n  function easeInOutBounce(t, b, c, d) {\n    if (t < d / 2) {\n      return easeInBounce (t * 2, 0, c, d) * 0.5 + b;\n    }\n    return easeOutBounce(t * 2 - d, 0, c, d) * 0.5 + c * 0.5 + b;\n  }\n\n  /**\n   * Easing functions\n   * See <a href=\"http://gizma.com/easing/\">Easing Equations by Robert Penner</a>\n   * @namespace fabric.util.ease\n   */\n  fabric.util.ease = {\n\n    /**\n     * Quadratic easing in\n     * @memberOf fabric.util.ease\n     */\n    easeInQuad: function(t, b, c, d) {\n      return c * (t /= d) * t + b;\n    },\n\n    /**\n     * Quadratic easing out\n     * @memberOf fabric.util.ease\n     */\n    easeOutQuad: function(t, b, c, d) {\n      return -c * (t /= d) * (t - 2) + b;\n    },\n\n    /**\n     * Quadratic easing in and out\n     * @memberOf fabric.util.ease\n     */\n    easeInOutQuad: function(t, b, c, d) {\n      t /= (d / 2);\n      if (t < 1) {\n        return c / 2 * t * t + b;\n      }\n      return -c / 2 * ((--t) * (t - 2) - 1) + b;\n    },\n\n    /**\n     * Cubic easing in\n     * @memberOf fabric.util.ease\n     */\n    easeInCubic: function(t, b, c, d) {\n      return c * (t /= d) * t * t + b;\n    },\n\n    easeOutCubic: easeOutCubic,\n    easeInOutCubic: easeInOutCubic,\n    easeInQuart: easeInQuart,\n    easeOutQuart: easeOutQuart,\n    easeInOutQuart: easeInOutQuart,\n    easeInQuint: easeInQuint,\n    easeOutQuint: easeOutQuint,\n    easeInOutQuint: easeInOutQuint,\n    easeInSine: easeInSine,\n    easeOutSine: easeOutSine,\n    easeInOutSine: easeInOutSine,\n    easeInExpo: easeInExpo,\n    easeOutExpo: easeOutExpo,\n    easeInOutExpo: easeInOutExpo,\n    easeInCirc: easeInCirc,\n    easeOutCirc: easeOutCirc,\n    easeInOutCirc: easeInOutCirc,\n    easeInElastic: easeInElastic,\n    easeOutElastic: easeOutElastic,\n    easeInOutElastic: easeInOutElastic,\n    easeInBack: easeInBack,\n    easeOutBack: easeOutBack,\n    easeInOutBack: easeInOutBack,\n    easeInBounce: easeInBounce,\n    easeOutBounce: easeOutBounce,\n    easeInOutBounce: easeInOutBounce\n  };\n\n}());\n\n\n(function(global) {\n\n  'use strict';\n\n  /**\n   * @name fabric\n   * @namespace\n   */\n\n  var fabric = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend,\n      capitalize = fabric.util.string.capitalize,\n      clone = fabric.util.object.clone,\n      toFixed = fabric.util.toFixed,\n      parseUnit = fabric.util.parseUnit,\n      multiplyTransformMatrices = fabric.util.multiplyTransformMatrices,\n\n      reAllowedSVGTagNames = /^(path|circle|polygon|polyline|ellipse|rect|line|image|text)$/i,\n      reViewBoxTagNames = /^(symbol|image|marker|pattern|view|svg)$/i,\n      reNotAllowedAncestors = /^(?:pattern|defs|symbol|metadata)$/i,\n      reAllowedParents = /^(symbol|g|a|svg)$/i,\n\n      attributesMap = {\n        cx:                   'left',\n        x:                    'left',\n        r:                    'radius',\n        cy:                   'top',\n        y:                    'top',\n        display:              'visible',\n        visibility:           'visible',\n        transform:            'transformMatrix',\n        'fill-opacity':       'fillOpacity',\n        'fill-rule':          'fillRule',\n        'font-family':        'fontFamily',\n        'font-size':          'fontSize',\n        'font-style':         'fontStyle',\n        'font-weight':        'fontWeight',\n        'stroke-dasharray':   'strokeDashArray',\n        'stroke-linecap':     'strokeLineCap',\n        'stroke-linejoin':    'strokeLineJoin',\n        'stroke-miterlimit':  'strokeMiterLimit',\n        'stroke-opacity':     'strokeOpacity',\n        'stroke-width':       'strokeWidth',\n        'text-decoration':    'textDecoration',\n        'text-anchor':        'originX'\n      },\n\n      colorAttributes = {\n        stroke: 'strokeOpacity',\n        fill:   'fillOpacity'\n      };\n\n  fabric.cssRules = { };\n  fabric.gradientDefs = { };\n\n  function normalizeAttr(attr) {\n    // transform attribute names\n    if (attr in attributesMap) {\n      return attributesMap[attr];\n    }\n    return attr;\n  }\n\n  function normalizeValue(attr, value, parentAttributes, fontSize) {\n    var isArray = Object.prototype.toString.call(value) === '[object Array]',\n        parsed;\n\n    if ((attr === 'fill' || attr === 'stroke') && value === 'none') {\n      value = '';\n    }\n    else if (attr === 'strokeDashArray') {\n      value = value.replace(/,/g, ' ').split(/\\s+/).map(function(n) {\n        return parseFloat(n);\n      });\n    }\n    else if (attr === 'transformMatrix') {\n      if (parentAttributes && parentAttributes.transformMatrix) {\n        value = multiplyTransformMatrices(\n          parentAttributes.transformMatrix, fabric.parseTransformAttribute(value));\n      }\n      else {\n        value = fabric.parseTransformAttribute(value);\n      }\n    }\n    else if (attr === 'visible') {\n      value = (value === 'none' || value === 'hidden') ? false : true;\n      // display=none on parent element always takes precedence over child element\n      if (parentAttributes && parentAttributes.visible === false) {\n        value = false;\n      }\n    }\n    else if (attr === 'originX' /* text-anchor */) {\n      value = value === 'start' ? 'left' : value === 'end' ? 'right' : 'center';\n    }\n    else {\n      parsed = isArray ? value.map(parseUnit) : parseUnit(value, fontSize);\n    }\n\n    return (!isArray && isNaN(parsed) ? value : parsed);\n  }\n\n  /**\n   * @private\n   * @param {Object} attributes Array of attributes to parse\n   */\n  function _setStrokeFillOpacity(attributes) {\n    for (var attr in colorAttributes) {\n\n      if (typeof attributes[colorAttributes[attr]] === 'undefined' || attributes[attr] === '') {\n        continue;\n      }\n\n      if (typeof attributes[attr] === 'undefined') {\n        if (!fabric.Object.prototype[attr]) {\n          continue;\n        }\n        attributes[attr] = fabric.Object.prototype[attr];\n      }\n\n      if (attributes[attr].indexOf('url(') === 0) {\n        continue;\n      }\n\n      var color = new fabric.Color(attributes[attr]);\n      attributes[attr] = color.setAlpha(toFixed(color.getAlpha() * attributes[colorAttributes[attr]], 2)).toRgba();\n    }\n    return attributes;\n  }\n\n  /**\n   * Parses \"transform\" attribute, returning an array of values\n   * @static\n   * @function\n   * @memberOf fabric\n   * @param {String} attributeValue String containing attribute value\n   * @return {Array} Array of 6 elements representing transformation matrix\n   */\n  fabric.parseTransformAttribute = (function() {\n    function rotateMatrix(matrix, args) {\n      var angle = args[0],\n          x = (args.length === 3) ? args[1] : 0,\n          y = (args.length === 3) ? args[2] : 0;\n\n      matrix[0] = Math.cos(angle);\n      matrix[1] = Math.sin(angle);\n      matrix[2] = -Math.sin(angle);\n      matrix[3] = Math.cos(angle);\n      matrix[4] = x - (matrix[0] * x + matrix[2] * y);\n      matrix[5] = y - (matrix[1] * x + matrix[3] * y);\n    }\n\n    function scaleMatrix(matrix, args) {\n      var multiplierX = args[0],\n          multiplierY = (args.length === 2) ? args[1] : args[0];\n\n      matrix[0] = multiplierX;\n      matrix[3] = multiplierY;\n    }\n\n    function skewXMatrix(matrix, args) {\n      matrix[2] = Math.tan(fabric.util.degreesToRadians(args[0]));\n    }\n\n    function skewYMatrix(matrix, args) {\n      matrix[1] = Math.tan(fabric.util.degreesToRadians(args[0]));\n    }\n\n    function translateMatrix(matrix, args) {\n      matrix[4] = args[0];\n      if (args.length === 2) {\n        matrix[5] = args[1];\n      }\n    }\n\n    // identity matrix\n    var iMatrix = [\n          1, // a\n          0, // b\n          0, // c\n          1, // d\n          0, // e\n          0  // f\n        ],\n\n        // == begin transform regexp\n        number = fabric.reNum,\n\n        commaWsp = '(?:\\\\s+,?\\\\s*|,\\\\s*)',\n\n        skewX = '(?:(skewX)\\\\s*\\\\(\\\\s*(' + number + ')\\\\s*\\\\))',\n\n        skewY = '(?:(skewY)\\\\s*\\\\(\\\\s*(' + number + ')\\\\s*\\\\))',\n\n        rotate = '(?:(rotate)\\\\s*\\\\(\\\\s*(' + number + ')(?:' +\n                    commaWsp + '(' + number + ')' +\n                    commaWsp + '(' + number + '))?\\\\s*\\\\))',\n\n        scale = '(?:(scale)\\\\s*\\\\(\\\\s*(' + number + ')(?:' +\n                    commaWsp + '(' + number + '))?\\\\s*\\\\))',\n\n        translate = '(?:(translate)\\\\s*\\\\(\\\\s*(' + number + ')(?:' +\n                    commaWsp + '(' + number + '))?\\\\s*\\\\))',\n\n        matrix = '(?:(matrix)\\\\s*\\\\(\\\\s*' +\n                  '(' + number + ')' + commaWsp +\n                  '(' + number + ')' + commaWsp +\n                  '(' + number + ')' + commaWsp +\n                  '(' + number + ')' + commaWsp +\n                  '(' + number + ')' + commaWsp +\n                  '(' + number + ')' +\n                  '\\\\s*\\\\))',\n\n        transform = '(?:' +\n                    matrix + '|' +\n                    translate + '|' +\n                    scale + '|' +\n                    rotate + '|' +\n                    skewX + '|' +\n                    skewY +\n                    ')',\n\n        transforms = '(?:' + transform + '(?:' + commaWsp + '*' + transform + ')*' + ')',\n\n        transformList = '^\\\\s*(?:' + transforms + '?)\\\\s*$',\n\n        // http://www.w3.org/TR/SVG/coords.html#TransformAttribute\n        reTransformList = new RegExp(transformList),\n        // == end transform regexp\n\n        reTransform = new RegExp(transform, 'g');\n\n    return function(attributeValue) {\n\n      // start with identity matrix\n      var matrix = iMatrix.concat(),\n          matrices = [ ];\n\n      // return if no argument was given or\n      // an argument does not match transform attribute regexp\n      if (!attributeValue || (attributeValue && !reTransformList.test(attributeValue))) {\n        return matrix;\n      }\n\n      attributeValue.replace(reTransform, function(match) {\n\n        var m = new RegExp(transform).exec(match).filter(function (match) {\n              return (match !== '' && match != null);\n            }),\n            operation = m[1],\n            args = m.slice(2).map(parseFloat);\n\n        switch (operation) {\n          case 'translate':\n            translateMatrix(matrix, args);\n            break;\n          case 'rotate':\n            args[0] = fabric.util.degreesToRadians(args[0]);\n            rotateMatrix(matrix, args);\n            break;\n          case 'scale':\n            scaleMatrix(matrix, args);\n            break;\n          case 'skewX':\n            skewXMatrix(matrix, args);\n            break;\n          case 'skewY':\n            skewYMatrix(matrix, args);\n            break;\n          case 'matrix':\n            matrix = args;\n            break;\n        }\n\n        // snapshot current matrix into matrices array\n        matrices.push(matrix.concat());\n        // reset\n        matrix = iMatrix.concat();\n      });\n\n      var combinedMatrix = matrices[0];\n      while (matrices.length > 1) {\n        matrices.shift();\n        combinedMatrix = fabric.util.multiplyTransformMatrices(combinedMatrix, matrices[0]);\n      }\n      return combinedMatrix;\n    };\n  })();\n\n  /**\n   * @private\n   */\n  function parseStyleString(style, oStyle) {\n    var attr, value;\n    style.replace(/;\\s*$/, '').split(';').forEach(function (chunk) {\n      var pair = chunk.split(':');\n\n      attr = normalizeAttr(pair[0].trim().toLowerCase());\n      value = normalizeValue(attr, pair[1].trim());\n\n      oStyle[attr] = value;\n    });\n  }\n\n  /**\n   * @private\n   */\n  function parseStyleObject(style, oStyle) {\n    var attr, value;\n    for (var prop in style) {\n      if (typeof style[prop] === 'undefined') {\n        continue;\n      }\n\n      attr = normalizeAttr(prop.toLowerCase());\n      value = normalizeValue(attr, style[prop]);\n\n      oStyle[attr] = value;\n    }\n  }\n\n  /**\n   * @private\n   */\n  function getGlobalStylesForElement(element, svgUid) {\n    var styles = { };\n    for (var rule in fabric.cssRules[svgUid]) {\n      if (elementMatchesRule(element, rule.split(' '))) {\n        for (var property in fabric.cssRules[svgUid][rule]) {\n          styles[property] = fabric.cssRules[svgUid][rule][property];\n        }\n      }\n    }\n    return styles;\n  }\n\n  /**\n   * @private\n   */\n  function elementMatchesRule(element, selectors) {\n    var firstMatching, parentMatching = true;\n    //start from rightmost selector.\n    firstMatching = selectorMatches(element, selectors.pop());\n    if (firstMatching && selectors.length) {\n      parentMatching = doesSomeParentMatch(element, selectors);\n    }\n    return firstMatching && parentMatching && (selectors.length === 0);\n  }\n\n  function doesSomeParentMatch(element, selectors) {\n    var selector, parentMatching = true;\n    while (element.parentNode && element.parentNode.nodeType === 1 && selectors.length) {\n      if (parentMatching) {\n        selector = selectors.pop();\n      }\n      element = element.parentNode;\n      parentMatching = selectorMatches(element, selector);\n    }\n    return selectors.length === 0;\n  }\n\n  /**\n   * @private\n   */\n  function selectorMatches(element, selector) {\n    var nodeName = element.nodeName,\n        classNames = element.getAttribute('class'),\n        id = element.getAttribute('id'), matcher;\n    // i check if a selector matches slicing away part from it.\n    // if i get empty string i should match\n    matcher = new RegExp('^' + nodeName, 'i');\n    selector = selector.replace(matcher, '');\n    if (id && selector.length) {\n      matcher = new RegExp('#' + id + '(?![a-zA-Z\\\\-]+)', 'i');\n      selector = selector.replace(matcher, '');\n    }\n    if (classNames && selector.length) {\n      classNames = classNames.split(' ');\n      for (var i = classNames.length; i--;) {\n        matcher = new RegExp('\\\\.' + classNames[i] + '(?![a-zA-Z\\\\-]+)', 'i');\n        selector = selector.replace(matcher, '');\n      }\n    }\n    return selector.length === 0;\n  }\n\n  /**\n   * @private\n   * to support IE8 missing getElementById on SVGdocument\n   */\n  function elementById(doc, id) {\n    var el;\n    doc.getElementById && (el = doc.getElementById(id));\n    if (el) {\n      return el;\n    }\n    var node, i, nodelist = doc.getElementsByTagName('*');\n    for (i = 0; i < nodelist.length; i++) {\n      node = nodelist[i];\n      if (id === node.getAttribute('id')) {\n        return node;\n      }\n    }\n  }\n\n  /**\n   * @private\n   */\n  function parseUseDirectives(doc) {\n    var nodelist = doc.getElementsByTagName('use'), i = 0;\n    while (nodelist.length && i < nodelist.length) {\n      var el = nodelist[i],\n          xlink = el.getAttribute('xlink:href').substr(1),\n          x = el.getAttribute('x') || 0,\n          y = el.getAttribute('y') || 0,\n          el2 = elementById(doc, xlink).cloneNode(true),\n          currentTrans = (el2.getAttribute('transform') || '') + ' translate(' + x + ', ' + y + ')',\n          parentNode, oldLength = nodelist.length, attr, j, attrs, l;\n\n      applyViewboxTransform(el2);\n      if (/^svg$/i.test(el2.nodeName)) {\n        var el3 = el2.ownerDocument.createElement('g');\n        for (j = 0, attrs = el2.attributes, l = attrs.length; j < l; j++) {\n          attr = attrs.item(j);\n          el3.setAttribute(attr.nodeName, attr.nodeValue);\n        }\n        while (el2.firstChild != null) {\n          el3.appendChild(el2.firstChild);\n        }\n        el2 = el3;\n      }\n\n      for (j = 0, attrs = el.attributes, l = attrs.length; j < l; j++) {\n        attr = attrs.item(j);\n        if (attr.nodeName === 'x' || attr.nodeName === 'y' || attr.nodeName === 'xlink:href') {\n          continue;\n        }\n\n        if (attr.nodeName === 'transform') {\n          currentTrans = attr.nodeValue + ' ' + currentTrans;\n        }\n        else {\n          el2.setAttribute(attr.nodeName, attr.nodeValue);\n        }\n      }\n\n      el2.setAttribute('transform', currentTrans);\n      el2.setAttribute('instantiated_by_use', '1');\n      el2.removeAttribute('id');\n      parentNode = el.parentNode;\n      parentNode.replaceChild(el2, el);\n      // some browsers do not shorten nodelist after replaceChild (IE8)\n      if (nodelist.length === oldLength) {\n        i++;\n      }\n    }\n  }\n\n  // http://www.w3.org/TR/SVG/coords.html#ViewBoxAttribute\n  // matches, e.g.: +14.56e-12, etc.\n  var reViewBoxAttrValue = new RegExp(\n    '^' +\n    '\\\\s*(' + fabric.reNum + '+)\\\\s*,?' +\n    '\\\\s*(' + fabric.reNum + '+)\\\\s*,?' +\n    '\\\\s*(' + fabric.reNum + '+)\\\\s*,?' +\n    '\\\\s*(' + fabric.reNum + '+)\\\\s*' +\n    '$'\n  );\n\n  /**\n   * Add a <g> element that envelop all child elements and makes the viewbox transformMatrix descend on all elements\n   */\n  function applyViewboxTransform(element) {\n\n    var viewBoxAttr = element.getAttribute('viewBox'),\n        scaleX = 1,\n        scaleY = 1,\n        minX = 0,\n        minY = 0,\n        viewBoxWidth, viewBoxHeight, matrix, el,\n        widthAttr = element.getAttribute('width'),\n        heightAttr = element.getAttribute('height'),\n        x = element.getAttribute('x') || 0,\n        y = element.getAttribute('y') || 0,\n        preserveAspectRatio = element.getAttribute('preserveAspectRatio') || '',\n        missingViewBox = (!viewBoxAttr || !reViewBoxTagNames.test(element.tagName)\n                           || !(viewBoxAttr = viewBoxAttr.match(reViewBoxAttrValue))),\n        missingDimAttr = (!widthAttr || !heightAttr || widthAttr === '100%' || heightAttr === '100%'),\n        toBeParsed = missingViewBox && missingDimAttr,\n        parsedDim = { }, translateMatrix = '';\n\n    parsedDim.width = 0;\n    parsedDim.height = 0;\n    parsedDim.toBeParsed = toBeParsed;\n\n    if (toBeParsed) {\n      return parsedDim;\n    }\n\n    if (missingViewBox) {\n      parsedDim.width = parseUnit(widthAttr);\n      parsedDim.height = parseUnit(heightAttr);\n      return parsedDim;\n    }\n\n    minX = -parseFloat(viewBoxAttr[1]),\n    minY = -parseFloat(viewBoxAttr[2]),\n    viewBoxWidth = parseFloat(viewBoxAttr[3]),\n    viewBoxHeight = parseFloat(viewBoxAttr[4]);\n\n    if (!missingDimAttr) {\n      parsedDim.width = parseUnit(widthAttr);\n      parsedDim.height = parseUnit(heightAttr);\n      scaleX = parsedDim.width / viewBoxWidth;\n      scaleY = parsedDim.height / viewBoxHeight;\n    }\n    else {\n      parsedDim.width = viewBoxWidth;\n      parsedDim.height = viewBoxHeight;\n    }\n\n    // default is to preserve aspect ratio\n    preserveAspectRatio = fabric.util.parsePreserveAspectRatioAttribute(preserveAspectRatio);\n    if (preserveAspectRatio.alignX !== 'none') {\n      //translate all container for the effect of Mid, Min, Max\n      scaleY = scaleX = (scaleX > scaleY ? scaleY : scaleX);\n    }\n\n    if (scaleX === 1 && scaleY === 1 && minX === 0 && minY === 0 && x === 0 && y === 0) {\n      return parsedDim;\n    }\n\n    if (x || y) {\n      translateMatrix = ' translate(' + parseUnit(x) + ' ' + parseUnit(y) + ') ';\n    }\n\n    matrix = translateMatrix + ' matrix(' + scaleX +\n                  ' 0' +\n                  ' 0 ' +\n                  scaleY + ' ' +\n                  (minX * scaleX) + ' ' +\n                  (minY * scaleY) + ') ';\n\n    if (element.tagName === 'svg') {\n      el = element.ownerDocument.createElement('g');\n      while (element.firstChild != null) {\n        el.appendChild(element.firstChild);\n      }\n      element.appendChild(el);\n    }\n    else {\n      el = element;\n      matrix = el.getAttribute('transform') + matrix;\n    }\n\n    el.setAttribute('transform', matrix);\n    return parsedDim;\n  }\n\n  /**\n   * Parses an SVG document, converts it to an array of corresponding fabric.* instances and passes them to a callback\n   * @static\n   * @function\n   * @memberOf fabric\n   * @param {SVGDocument} doc SVG document to parse\n   * @param {Function} callback Callback to call when parsing is finished; It's being passed an array of elements (parsed from a document).\n   * @param {Function} [reviver] Method for further parsing of SVG elements, called after each fabric object created.\n   */\n  fabric.parseSVGDocument = (function() {\n\n    function hasAncestorWithNodeName(element, nodeName) {\n      while (element && (element = element.parentNode)) {\n        if (nodeName.test(element.nodeName) && !element.getAttribute('instantiated_by_use')) {\n          return true;\n        }\n      }\n      return false;\n    }\n\n    return function(doc, callback, reviver) {\n      if (!doc) {\n        return;\n      }\n\n      parseUseDirectives(doc);\n\n      var startTime = new Date(),\n          svgUid =  fabric.Object.__uid++,\n          options = applyViewboxTransform(doc),\n          descendants = fabric.util.toArray(doc.getElementsByTagName('*'));\n\n      options.svgUid = svgUid;\n\n      if (descendants.length === 0 && fabric.isLikelyNode) {\n        // we're likely in node, where \"o3-xml\" library fails to gEBTN(\"*\")\n        // https://github.com/ajaxorg/node-o3-xml/issues/21\n        descendants = doc.selectNodes('//*[name(.)!=\"svg\"]');\n        var arr = [ ];\n        for (var i = 0, len = descendants.length; i < len; i++) {\n          arr[i] = descendants[i];\n        }\n        descendants = arr;\n      }\n\n      var elements = descendants.filter(function(el) {\n        applyViewboxTransform(el);\n        return reAllowedSVGTagNames.test(el.tagName) &&\n              !hasAncestorWithNodeName(el, reNotAllowedAncestors); // http://www.w3.org/TR/SVG/struct.html#DefsElement\n      });\n\n      if (!elements || (elements && !elements.length)) {\n        callback && callback([], {});\n        return;\n      }\n\n      fabric.gradientDefs[svgUid] = fabric.getGradientDefs(doc);\n      fabric.cssRules[svgUid] = fabric.getCSSRules(doc);\n      // Precedence of rules:   style > class > attribute\n      fabric.parseElements(elements, function(instances) {\n        fabric.documentParsingTime = new Date() - startTime;\n        if (callback) {\n          callback(instances, options);\n        }\n      }, clone(options), reviver);\n    };\n  })();\n\n  /**\n   * Used for caching SVG documents (loaded via `fabric.Canvas#loadSVGFromURL`)\n   * @namespace\n   */\n  var svgCache = {\n\n    /**\n     * @param {String} name\n     * @param {Function} callback\n     */\n    has: function (name, callback) {\n      callback(false);\n    },\n\n    get: function () {\n      /* NOOP */\n    },\n\n    set: function () {\n      /* NOOP */\n    }\n  };\n\n  /**\n   * @private\n   */\n  function _enlivenCachedObject(cachedObject) {\n\n    var objects = cachedObject.objects,\n        options = cachedObject.options;\n\n    objects = objects.map(function (o) {\n      return fabric[capitalize(o.type)].fromObject(o);\n    });\n\n    return ({ objects: objects, options: options });\n  }\n\n  /**\n   * @private\n   */\n  function _createSVGPattern(markup, canvas, property) {\n    if (canvas[property] && canvas[property].toSVG) {\n      markup.push(\n        '\\t<pattern x=\"0\" y=\"0\" id=\"', property, 'Pattern\" ',\n          'width=\"', canvas[property].source.width,\n          '\" height=\"', canvas[property].source.height,\n          '\" patternUnits=\"userSpaceOnUse\">\\n',\n        '\\t\\t<image x=\"0\" y=\"0\" ',\n        'width=\"', canvas[property].source.width,\n        '\" height=\"', canvas[property].source.height,\n        '\" xlink:href=\"', canvas[property].source.src,\n        '\"></image>\\n\\t</pattern>\\n'\n      );\n    }\n  }\n\n  var reFontDeclaration = new RegExp(\n    '(normal|italic)?\\\\s*(normal|small-caps)?\\\\s*' +\n    '(normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900)?\\\\s*(' +\n      fabric.reNum +\n    '(?:px|cm|mm|em|pt|pc|in)*)(?:\\\\/(normal|' + fabric.reNum + '))?\\\\s+(.*)');\n\n  extend(fabric, {\n    /**\n     * Parses a short font declaration, building adding its properties to a style object\n     * @static\n     * @function\n     * @memberOf fabric\n     * @param {String} value font declaration\n     * @param {Object} oStyle definition\n     */\n    parseFontDeclaration: function(value, oStyle) {\n      var match = value.match(reFontDeclaration);\n\n      if (!match) {\n        return;\n      }\n      var fontStyle = match[1],\n          // font variant is not used\n          // fontVariant = match[2],\n          fontWeight = match[3],\n          fontSize = match[4],\n          lineHeight = match[5],\n          fontFamily = match[6];\n\n      if (fontStyle) {\n        oStyle.fontStyle = fontStyle;\n      }\n      if (fontWeight) {\n        oStyle.fontWeight = isNaN(parseFloat(fontWeight)) ? fontWeight : parseFloat(fontWeight);\n      }\n      if (fontSize) {\n        oStyle.fontSize = parseUnit(fontSize);\n      }\n      if (fontFamily) {\n        oStyle.fontFamily = fontFamily;\n      }\n      if (lineHeight) {\n        oStyle.lineHeight = lineHeight === 'normal' ? 1 : lineHeight;\n      }\n    },\n\n    /**\n     * Parses an SVG document, returning all of the gradient declarations found in it\n     * @static\n     * @function\n     * @memberOf fabric\n     * @param {SVGDocument} doc SVG document to parse\n     * @return {Object} Gradient definitions; key corresponds to element id, value -- to gradient definition element\n     */\n    getGradientDefs: function(doc) {\n      var linearGradientEls = doc.getElementsByTagName('linearGradient'),\n          radialGradientEls = doc.getElementsByTagName('radialGradient'),\n          el, i, j = 0, id, xlink, elList = [ ],\n          gradientDefs = { }, idsToXlinkMap = { };\n\n      elList.length = linearGradientEls.length + radialGradientEls.length;\n      i = linearGradientEls.length;\n      while (i--) {\n        elList[j++] = linearGradientEls[i];\n      }\n      i = radialGradientEls.length;\n      while (i--) {\n        elList[j++] = radialGradientEls[i];\n      }\n\n      while (j--) {\n        el = elList[j];\n        xlink = el.getAttribute('xlink:href');\n        id = el.getAttribute('id');\n        if (xlink) {\n          idsToXlinkMap[id] = xlink.substr(1);\n        }\n        gradientDefs[id] = el;\n      }\n\n      for (id in idsToXlinkMap) {\n        var el2 = gradientDefs[idsToXlinkMap[id]].cloneNode(true);\n        el = gradientDefs[id];\n        while (el2.firstChild) {\n          el.appendChild(el2.firstChild);\n        }\n      }\n      return gradientDefs;\n    },\n\n    /**\n     * Returns an object of attributes' name/value, given element and an array of attribute names;\n     * Parses parent \"g\" nodes recursively upwards.\n     * @static\n     * @memberOf fabric\n     * @param {DOMElement} element Element to parse\n     * @param {Array} attributes Array of attributes to parse\n     * @return {Object} object containing parsed attributes' names/values\n     */\n    parseAttributes: function(element, attributes, svgUid) {\n\n      if (!element) {\n        return;\n      }\n\n      var value,\n          parentAttributes = { },\n          fontSize;\n\n      if (typeof svgUid === 'undefined') {\n        svgUid = element.getAttribute('svgUid');\n      }\n      // if there's a parent container (`g` or `a` or `symbol` node), parse its attributes recursively upwards\n      if (element.parentNode && reAllowedParents.test(element.parentNode.nodeName)) {\n        parentAttributes = fabric.parseAttributes(element.parentNode, attributes, svgUid);\n      }\n      fontSize = (parentAttributes && parentAttributes.fontSize ) ||\n                 element.getAttribute('font-size') || fabric.Text.DEFAULT_SVG_FONT_SIZE;\n\n      var ownAttributes = attributes.reduce(function(memo, attr) {\n        value = element.getAttribute(attr);\n        if (value) {\n          attr = normalizeAttr(attr);\n          value = normalizeValue(attr, value, parentAttributes, fontSize);\n\n          memo[attr] = value;\n        }\n        return memo;\n      }, { });\n\n      // add values parsed from style, which take precedence over attributes\n      // (see: http://www.w3.org/TR/SVG/styling.html#UsingPresentationAttributes)\n      ownAttributes = extend(ownAttributes,\n        extend(getGlobalStylesForElement(element, svgUid), fabric.parseStyleAttribute(element)));\n      if (ownAttributes.font) {\n        fabric.parseFontDeclaration(ownAttributes.font, ownAttributes);\n      }\n      return _setStrokeFillOpacity(extend(parentAttributes, ownAttributes));\n    },\n\n    /**\n     * Transforms an array of svg elements to corresponding fabric.* instances\n     * @static\n     * @memberOf fabric\n     * @param {Array} elements Array of elements to parse\n     * @param {Function} callback Being passed an array of fabric instances (transformed from SVG elements)\n     * @param {Object} [options] Options object\n     * @param {Function} [reviver] Method for further parsing of SVG elements, called after each fabric object created.\n     */\n    parseElements: function(elements, callback, options, reviver) {\n      new fabric.ElementsParser(elements, callback, options, reviver).parse();\n    },\n\n    /**\n     * Parses \"style\" attribute, retuning an object with values\n     * @static\n     * @memberOf fabric\n     * @param {SVGElement} element Element to parse\n     * @return {Object} Objects with values parsed from style attribute of an element\n     */\n    parseStyleAttribute: function(element) {\n      var oStyle = { },\n          style = element.getAttribute('style');\n\n      if (!style) {\n        return oStyle;\n      }\n\n      if (typeof style === 'string') {\n        parseStyleString(style, oStyle);\n      }\n      else {\n        parseStyleObject(style, oStyle);\n      }\n\n      return oStyle;\n    },\n\n    /**\n     * Parses \"points\" attribute, returning an array of values\n     * @static\n     * @memberOf fabric\n     * @param {String} points points attribute string\n     * @return {Array} array of points\n     */\n    parsePointsAttribute: function(points) {\n\n      // points attribute is required and must not be empty\n      if (!points) {\n        return null;\n      }\n\n      // replace commas with whitespace and remove bookending whitespace\n      points = points.replace(/,/g, ' ').trim();\n\n      points = points.split(/\\s+/);\n      var parsedPoints = [ ], i, len;\n\n      i = 0;\n      len = points.length;\n      for (; i < len; i+=2) {\n        parsedPoints.push({\n          x: parseFloat(points[i]),\n          y: parseFloat(points[i + 1])\n        });\n      }\n\n      // odd number of points is an error\n      // if (parsedPoints.length % 2 !== 0) {\n      //   return null;\n      // }\n\n      return parsedPoints;\n    },\n\n    /**\n     * Returns CSS rules for a given SVG document\n     * @static\n     * @function\n     * @memberOf fabric\n     * @param {SVGDocument} doc SVG document to parse\n     * @return {Object} CSS rules of this document\n     */\n    getCSSRules: function(doc) {\n      var styles = doc.getElementsByTagName('style'),\n          allRules = { }, rules;\n\n      // very crude parsing of style contents\n      for (var i = 0, len = styles.length; i < len; i++) {\n        // IE9 doesn't support textContent, but provides text instead.\n        var styleContents = styles[i].textContent || styles[i].text;\n\n        // remove comments\n        styleContents = styleContents.replace(/\\/\\*[\\s\\S]*?\\*\\//g, '');\n        if (styleContents.trim() === '') {\n          continue;\n        }\n        rules = styleContents.match(/[^{]*\\{[\\s\\S]*?\\}/g);\n        rules = rules.map(function(rule) { return rule.trim(); });\n\n        rules.forEach(function(rule) {\n\n          var match = rule.match(/([\\s\\S]*?)\\s*\\{([^}]*)\\}/),\n          ruleObj = { }, declaration = match[2].trim(),\n          propertyValuePairs = declaration.replace(/;$/, '').split(/\\s*;\\s*/);\n\n          for (var i = 0, len = propertyValuePairs.length; i < len; i++) {\n            var pair = propertyValuePairs[i].split(/\\s*:\\s*/),\n                property = normalizeAttr(pair[0]),\n                value = normalizeValue(property, pair[1], pair[0]);\n            ruleObj[property] = value;\n          }\n          rule = match[1];\n          rule.split(',').forEach(function(_rule) {\n            _rule = _rule.replace(/^svg/i, '').trim();\n            if (_rule === '') {\n              return;\n            }\n            allRules[_rule] = fabric.util.object.clone(ruleObj);\n          });\n        });\n      }\n      return allRules;\n    },\n\n    /**\n     * Takes url corresponding to an SVG document, and parses it into a set of fabric objects. Note that SVG is fetched via XMLHttpRequest, so it needs to conform to SOP (Same Origin Policy)\n     * @memberOf fabric\n     * @param {String} url\n     * @param {Function} callback\n     * @param {Function} [reviver] Method for further parsing of SVG elements, called after each fabric object created.\n     */\n    loadSVGFromURL: function(url, callback, reviver) {\n\n      url = url.replace(/^\\n\\s*/, '').trim();\n      svgCache.has(url, function (hasUrl) {\n        if (hasUrl) {\n          svgCache.get(url, function (value) {\n            var enlivedRecord = _enlivenCachedObject(value);\n            callback(enlivedRecord.objects, enlivedRecord.options);\n          });\n        }\n        else {\n          new fabric.util.request(url, {\n            method: 'get',\n            onComplete: onComplete\n          });\n        }\n      });\n\n      function onComplete(r) {\n\n        var xml = r.responseXML;\n        if (xml && !xml.documentElement && fabric.window.ActiveXObject && r.responseText) {\n          xml = new ActiveXObject('Microsoft.XMLDOM');\n          xml.async = 'false';\n          //IE chokes on DOCTYPE\n          xml.loadXML(r.responseText.replace(/<!DOCTYPE[\\s\\S]*?(\\[[\\s\\S]*\\])*?>/i, ''));\n        }\n        if (!xml || !xml.documentElement) {\n          return;\n        }\n\n        fabric.parseSVGDocument(xml.documentElement, function (results, options) {\n          svgCache.set(url, {\n            objects: fabric.util.array.invoke(results, 'toObject'),\n            options: options\n          });\n          callback(results, options);\n        }, reviver);\n      }\n    },\n\n    /**\n     * Takes string corresponding to an SVG document, and parses it into a set of fabric objects\n     * @memberOf fabric\n     * @param {String} string\n     * @param {Function} callback\n     * @param {Function} [reviver] Method for further parsing of SVG elements, called after each fabric object created.\n     */\n    loadSVGFromString: function(string, callback, reviver) {\n      string = string.trim();\n      var doc;\n      if (typeof DOMParser !== 'undefined') {\n        var parser = new DOMParser();\n        if (parser && parser.parseFromString) {\n          doc = parser.parseFromString(string, 'text/xml');\n        }\n      }\n      else if (fabric.window.ActiveXObject) {\n        doc = new ActiveXObject('Microsoft.XMLDOM');\n        doc.async = 'false';\n        // IE chokes on DOCTYPE\n        doc.loadXML(string.replace(/<!DOCTYPE[\\s\\S]*?(\\[[\\s\\S]*\\])*?>/i, ''));\n      }\n\n      fabric.parseSVGDocument(doc.documentElement, function (results, options) {\n        callback(results, options);\n      }, reviver);\n    },\n\n    /**\n     * Creates markup containing SVG font faces,\n     * font URLs for font faces must be collected by developers\n     * and are not extracted from the DOM by fabricjs\n     * @param {Array} objects Array of fabric objects\n     * @return {String}\n     */\n    createSVGFontFacesMarkup: function(objects) {\n      var markup = '', fontList = { }, obj, fontFamily,\n          style, row, rowIndex, _char, charIndex,\n          fontPaths = fabric.fontPaths;\n\n      for (var i = 0, len = objects.length; i < len; i++) {\n        obj = objects[i];\n        fontFamily = obj.fontFamily;\n        if (obj.type.indexOf('text') === -1 || fontList[fontFamily] || !fontPaths[fontFamily]) {\n          continue;\n        }\n        fontList[fontFamily] = true;\n        if (!obj.styles) {\n          continue;\n        }\n        style = obj.styles;\n        for (rowIndex in style) {\n          row = style[rowIndex];\n          for (charIndex in row) {\n            _char = row[charIndex];\n            fontFamily = _char.fontFamily;\n            if (!fontList[fontFamily] && fontPaths[fontFamily]) {\n              fontList[fontFamily] = true;\n            }\n          }\n        }\n      }\n\n      for (var j in fontList) {\n        markup += [\n          //jscs:disable validateIndentation\n          '\\t\\t@font-face {\\n',\n            '\\t\\t\\tfont-family: \\'', j, '\\';\\n',\n            '\\t\\t\\tsrc: url(\\'', fontPaths[j], '\\');\\n',\n          '\\t\\t}\\n'\n          //jscs:enable validateIndentation\n        ].join('');\n      }\n\n      if (markup) {\n        markup = [\n          //jscs:disable validateIndentation\n          '\\t<style type=\"text/css\">',\n            '<![CDATA[\\n',\n              markup,\n            ']]>',\n          '</style>\\n'\n          //jscs:enable validateIndentation\n        ].join('');\n      }\n\n      return markup;\n    },\n\n    /**\n     * Creates markup containing SVG referenced elements like patterns, gradients etc.\n     * @param {fabric.Canvas} canvas instance of fabric.Canvas\n     * @return {String}\n     */\n    createSVGRefElementsMarkup: function(canvas) {\n      var markup = [ ];\n\n      _createSVGPattern(markup, canvas, 'backgroundColor');\n      _createSVGPattern(markup, canvas, 'overlayColor');\n\n      return markup.join('');\n    }\n  });\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\nfabric.ElementsParser = function(elements, callback, options, reviver) {\n  this.elements = elements;\n  this.callback = callback;\n  this.options = options;\n  this.reviver = reviver;\n  this.svgUid = (options && options.svgUid) || 0;\n};\n\nfabric.ElementsParser.prototype.parse = function() {\n  this.instances = new Array(this.elements.length);\n  this.numElements = this.elements.length;\n\n  this.createObjects();\n};\n\nfabric.ElementsParser.prototype.createObjects = function() {\n  for (var i = 0, len = this.elements.length; i < len; i++) {\n    this.elements[i].setAttribute('svgUid', this.svgUid);\n    (function(_this, i) {\n      setTimeout(function() {\n        _this.createObject(_this.elements[i], i);\n      }, 0);\n    })(this, i);\n  }\n};\n\nfabric.ElementsParser.prototype.createObject = function(el, index) {\n  var klass = fabric[fabric.util.string.capitalize(el.tagName)];\n  if (klass && klass.fromElement) {\n    try {\n      this._createObject(klass, el, index);\n    }\n    catch (err) {\n      fabric.log(err);\n    }\n  }\n  else {\n    this.checkIfDone();\n  }\n};\n\nfabric.ElementsParser.prototype._createObject = function(klass, el, index) {\n  if (klass.async) {\n    klass.fromElement(el, this.createCallback(index, el), this.options);\n  }\n  else {\n    var obj = klass.fromElement(el, this.options);\n    this.resolveGradient(obj, 'fill');\n    this.resolveGradient(obj, 'stroke');\n    this.reviver && this.reviver(el, obj);\n    this.instances[index] = obj;\n    this.checkIfDone();\n  }\n};\n\nfabric.ElementsParser.prototype.createCallback = function(index, el) {\n  var _this = this;\n  return function(obj) {\n    _this.resolveGradient(obj, 'fill');\n    _this.resolveGradient(obj, 'stroke');\n    _this.reviver && _this.reviver(el, obj);\n    _this.instances[index] = obj;\n    _this.checkIfDone();\n  };\n};\n\nfabric.ElementsParser.prototype.resolveGradient = function(obj, property) {\n\n  var instanceFillValue = obj.get(property);\n  if (!(/^url\\(/).test(instanceFillValue)) {\n    return;\n  }\n  var gradientId = instanceFillValue.slice(5, instanceFillValue.length - 1);\n  if (fabric.gradientDefs[this.svgUid][gradientId]) {\n    obj.set(property,\n      fabric.Gradient.fromElement(fabric.gradientDefs[this.svgUid][gradientId], obj));\n  }\n};\n\nfabric.ElementsParser.prototype.checkIfDone = function() {\n  if (--this.numElements === 0) {\n    this.instances = this.instances.filter(function(el) {\n      return el != null;\n    });\n    this.callback(this.instances);\n  }\n};\n\n\n(function(global) {\n\n  'use strict';\n\n  /* Adaptation of work of Kevin Lindsey (kevin@kevlindev.com) */\n\n  var fabric = global.fabric || (global.fabric = { });\n\n  if (fabric.Point) {\n    fabric.warn('fabric.Point is already defined');\n    return;\n  }\n\n  fabric.Point = Point;\n\n  /**\n   * Point class\n   * @class fabric.Point\n   * @memberOf fabric\n   * @constructor\n   * @param {Number} x\n   * @param {Number} y\n   * @return {fabric.Point} thisArg\n   */\n  function Point(x, y) {\n    this.x = x;\n    this.y = y;\n  }\n\n  Point.prototype = /** @lends fabric.Point.prototype */ {\n\n    constructor: Point,\n\n    /**\n     * Adds another point to this one and returns another one\n     * @param {fabric.Point} that\n     * @return {fabric.Point} new Point instance with added values\n     */\n    add: function (that) {\n      return new Point(this.x + that.x, this.y + that.y);\n    },\n\n    /**\n     * Adds another point to this one\n     * @param {fabric.Point} that\n     * @return {fabric.Point} thisArg\n     */\n    addEquals: function (that) {\n      this.x += that.x;\n      this.y += that.y;\n      return this;\n    },\n\n    /**\n     * Adds value to this point and returns a new one\n     * @param {Number} scalar\n     * @return {fabric.Point} new Point with added value\n     */\n    scalarAdd: function (scalar) {\n      return new Point(this.x + scalar, this.y + scalar);\n    },\n\n    /**\n     * Adds value to this point\n     * @param {Number} scalar\n     * @return {fabric.Point} thisArg\n     */\n    scalarAddEquals: function (scalar) {\n      this.x += scalar;\n      this.y += scalar;\n      return this;\n    },\n\n    /**\n     * Subtracts another point from this point and returns a new one\n     * @param {fabric.Point} that\n     * @return {fabric.Point} new Point object with subtracted values\n     */\n    subtract: function (that) {\n      return new Point(this.x - that.x, this.y - that.y);\n    },\n\n    /**\n     * Subtracts another point from this point\n     * @param {fabric.Point} that\n     * @return {fabric.Point} thisArg\n     */\n    subtractEquals: function (that) {\n      this.x -= that.x;\n      this.y -= that.y;\n      return this;\n    },\n\n    /**\n     * Subtracts value from this point and returns a new one\n     * @param {Number} scalar\n     * @return {fabric.Point}\n     */\n    scalarSubtract: function (scalar) {\n      return new Point(this.x - scalar, this.y - scalar);\n    },\n\n    /**\n     * Subtracts value from this point\n     * @param {Number} scalar\n     * @return {fabric.Point} thisArg\n     */\n    scalarSubtractEquals: function (scalar) {\n      this.x -= scalar;\n      this.y -= scalar;\n      return this;\n    },\n\n    /**\n     * Miltiplies this point by a value and returns a new one\n     * @param {Number} scalar\n     * @return {fabric.Point}\n     */\n    multiply: function (scalar) {\n      return new Point(this.x * scalar, this.y * scalar);\n    },\n\n    /**\n     * Miltiplies this point by a value\n     * @param {Number} scalar\n     * @return {fabric.Point} thisArg\n     */\n    multiplyEquals: function (scalar) {\n      this.x *= scalar;\n      this.y *= scalar;\n      return this;\n    },\n\n    /**\n     * Divides this point by a value and returns a new one\n     * @param {Number} scalar\n     * @return {fabric.Point}\n     */\n    divide: function (scalar) {\n      return new Point(this.x / scalar, this.y / scalar);\n    },\n\n    /**\n     * Divides this point by a value\n     * @param {Number} scalar\n     * @return {fabric.Point} thisArg\n     */\n    divideEquals: function (scalar) {\n      this.x /= scalar;\n      this.y /= scalar;\n      return this;\n    },\n\n    /**\n     * Returns true if this point is equal to another one\n     * @param {fabric.Point} that\n     * @return {Boolean}\n     */\n    eq: function (that) {\n      return (this.x === that.x && this.y === that.y);\n    },\n\n    /**\n     * Returns true if this point is less than another one\n     * @param {fabric.Point} that\n     * @return {Boolean}\n     */\n    lt: function (that) {\n      return (this.x < that.x && this.y < that.y);\n    },\n\n    /**\n     * Returns true if this point is less than or equal to another one\n     * @param {fabric.Point} that\n     * @return {Boolean}\n     */\n    lte: function (that) {\n      return (this.x <= that.x && this.y <= that.y);\n    },\n\n    /**\n\n     * Returns true if this point is greater another one\n     * @param {fabric.Point} that\n     * @return {Boolean}\n     */\n    gt: function (that) {\n      return (this.x > that.x && this.y > that.y);\n    },\n\n    /**\n     * Returns true if this point is greater than or equal to another one\n     * @param {fabric.Point} that\n     * @return {Boolean}\n     */\n    gte: function (that) {\n      return (this.x >= that.x && this.y >= that.y);\n    },\n\n    /**\n     * Returns new point which is the result of linear interpolation with this one and another one\n     * @param {fabric.Point} that\n     * @param {Number} t\n     * @return {fabric.Point}\n     */\n    lerp: function (that, t) {\n      return new Point(this.x + (that.x - this.x) * t, this.y + (that.y - this.y) * t);\n    },\n\n    /**\n     * Returns distance from this point and another one\n     * @param {fabric.Point} that\n     * @return {Number}\n     */\n    distanceFrom: function (that) {\n      var dx = this.x - that.x,\n          dy = this.y - that.y;\n      return Math.sqrt(dx * dx + dy * dy);\n    },\n\n    /**\n     * Returns the point between this point and another one\n     * @param {fabric.Point} that\n     * @return {fabric.Point}\n     */\n    midPointFrom: function (that) {\n      return new Point(this.x + (that.x - this.x)/2, this.y + (that.y - this.y)/2);\n    },\n\n    /**\n     * Returns a new point which is the min of this and another one\n     * @param {fabric.Point} that\n     * @return {fabric.Point}\n     */\n    min: function (that) {\n      return new Point(Math.min(this.x, that.x), Math.min(this.y, that.y));\n    },\n\n    /**\n     * Returns a new point which is the max of this and another one\n     * @param {fabric.Point} that\n     * @return {fabric.Point}\n     */\n    max: function (that) {\n      return new Point(Math.max(this.x, that.x), Math.max(this.y, that.y));\n    },\n\n    /**\n     * Returns string representation of this point\n     * @return {String}\n     */\n    toString: function () {\n      return this.x + ',' + this.y;\n    },\n\n    /**\n     * Sets x/y of this point\n     * @param {Number} x\n     * @param {Number} y\n     */\n    setXY: function (x, y) {\n      this.x = x;\n      this.y = y;\n    },\n\n    /**\n     * Sets x/y of this point from another point\n     * @param {fabric.Point} that\n     */\n    setFromPoint: function (that) {\n      this.x = that.x;\n      this.y = that.y;\n    },\n\n    /**\n     * Swaps x/y of this point and another point\n     * @param {fabric.Point} that\n     */\n    swap: function (that) {\n      var x = this.x,\n          y = this.y;\n      this.x = that.x;\n      this.y = that.y;\n      that.x = x;\n      that.y = y;\n    }\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  /* Adaptation of work of Kevin Lindsey (kevin@kevlindev.com) */\n  var fabric = global.fabric || (global.fabric = { });\n\n  if (fabric.Intersection) {\n    fabric.warn('fabric.Intersection is already defined');\n    return;\n  }\n\n  /**\n   * Intersection class\n   * @class fabric.Intersection\n   * @memberOf fabric\n   * @constructor\n   */\n  function Intersection(status) {\n    this.status = status;\n    this.points = [];\n  }\n\n  fabric.Intersection = Intersection;\n\n  fabric.Intersection.prototype = /** @lends fabric.Intersection.prototype */ {\n\n    /**\n     * Appends a point to intersection\n     * @param {fabric.Point} point\n     */\n    appendPoint: function (point) {\n      this.points.push(point);\n    },\n\n    /**\n     * Appends points to intersection\n     * @param {Array} points\n     */\n    appendPoints: function (points) {\n      this.points = this.points.concat(points);\n    }\n  };\n\n  /**\n   * Checks if one line intersects another\n   * @static\n   * @param {fabric.Point} a1\n   * @param {fabric.Point} a2\n   * @param {fabric.Point} b1\n   * @param {fabric.Point} b2\n   * @return {fabric.Intersection}\n   */\n  fabric.Intersection.intersectLineLine = function (a1, a2, b1, b2) {\n    var result,\n        uaT = (b2.x - b1.x) * (a1.y - b1.y) - (b2.y - b1.y) * (a1.x - b1.x),\n        ubT = (a2.x - a1.x) * (a1.y - b1.y) - (a2.y - a1.y) * (a1.x - b1.x),\n        uB = (b2.y - b1.y) * (a2.x - a1.x) - (b2.x - b1.x) * (a2.y - a1.y);\n    if (uB !== 0) {\n      var ua = uaT / uB,\n          ub = ubT / uB;\n      if (0 <= ua && ua <= 1 && 0 <= ub && ub <= 1) {\n        result = new Intersection('Intersection');\n        result.points.push(new fabric.Point(a1.x + ua * (a2.x - a1.x), a1.y + ua * (a2.y - a1.y)));\n      }\n      else {\n        result = new Intersection();\n      }\n    }\n    else {\n      if (uaT === 0 || ubT === 0) {\n        result = new Intersection('Coincident');\n      }\n      else {\n        result = new Intersection('Parallel');\n      }\n    }\n    return result;\n  };\n\n  /**\n   * Checks if line intersects polygon\n   * @static\n   * @param {fabric.Point} a1\n   * @param {fabric.Point} a2\n   * @param {Array} points\n   * @return {fabric.Intersection}\n   */\n  fabric.Intersection.intersectLinePolygon = function(a1, a2, points) {\n    var result = new Intersection(),\n        length = points.length;\n\n    for (var i = 0; i < length; i++) {\n      var b1 = points[i],\n          b2 = points[(i + 1) % length],\n          inter = Intersection.intersectLineLine(a1, a2, b1, b2);\n\n      result.appendPoints(inter.points);\n    }\n    if (result.points.length > 0) {\n      result.status = 'Intersection';\n    }\n    return result;\n  };\n\n  /**\n   * Checks if polygon intersects another polygon\n   * @static\n   * @param {Array} points1\n   * @param {Array} points2\n   * @return {fabric.Intersection}\n   */\n  fabric.Intersection.intersectPolygonPolygon = function (points1, points2) {\n    var result = new Intersection(),\n        length = points1.length;\n\n    for (var i = 0; i < length; i++) {\n      var a1 = points1[i],\n          a2 = points1[(i + 1) % length],\n          inter = Intersection.intersectLinePolygon(a1, a2, points2);\n\n      result.appendPoints(inter.points);\n    }\n    if (result.points.length > 0) {\n      result.status = 'Intersection';\n    }\n    return result;\n  };\n\n  /**\n   * Checks if polygon intersects rectangle\n   * @static\n   * @param {Array} points\n   * @param {Number} r1\n   * @param {Number} r2\n   * @return {fabric.Intersection}\n   */\n  fabric.Intersection.intersectPolygonRectangle = function (points, r1, r2) {\n    var min = r1.min(r2),\n        max = r1.max(r2),\n        topRight = new fabric.Point(max.x, min.y),\n        bottomLeft = new fabric.Point(min.x, max.y),\n        inter1 = Intersection.intersectLinePolygon(min, topRight, points),\n        inter2 = Intersection.intersectLinePolygon(topRight, max, points),\n        inter3 = Intersection.intersectLinePolygon(max, bottomLeft, points),\n        inter4 = Intersection.intersectLinePolygon(bottomLeft, min, points),\n        result = new Intersection();\n\n    result.appendPoints(inter1.points);\n    result.appendPoints(inter2.points);\n    result.appendPoints(inter3.points);\n    result.appendPoints(inter4.points);\n\n    if (result.points.length > 0) {\n      result.status = 'Intersection';\n    }\n    return result;\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { });\n\n  if (fabric.Color) {\n    fabric.warn('fabric.Color is already defined.');\n    return;\n  }\n\n  /**\n   * Color class\n   * The purpose of {@link fabric.Color} is to abstract and encapsulate common color operations;\n   * {@link fabric.Color} is a constructor and creates instances of {@link fabric.Color} objects.\n   *\n   * @class fabric.Color\n   * @param {String} color optional in hex or rgb(a) or hsl format or from known color list\n   * @return {fabric.Color} thisArg\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-2/#colors}\n   */\n  function Color(color) {\n    if (!color) {\n      this.setSource([0, 0, 0, 1]);\n    }\n    else {\n      this._tryParsingColor(color);\n    }\n  }\n\n  fabric.Color = Color;\n\n  fabric.Color.prototype = /** @lends fabric.Color.prototype */ {\n\n    /**\n     * @private\n     * @param {String|Array} color Color value to parse\n     */\n    _tryParsingColor: function(color) {\n      var source;\n\n      if (color in Color.colorNameMap) {\n        color = Color.colorNameMap[color];\n      }\n\n      if (color === 'transparent') {\n        source = [255, 255, 255, 0];\n      }\n\n      if (!source) {\n        source = Color.sourceFromHex(color);\n      }\n      if (!source) {\n        source = Color.sourceFromRgb(color);\n      }\n      if (!source) {\n        source = Color.sourceFromHsl(color);\n      }\n      if (!source) {\n        //if color is not recognize let's make black as canvas does\n        source = [0, 0, 0, 1];\n      }\n      if (source) {\n        this.setSource(source);\n      }\n    },\n\n    /**\n     * Adapted from <a href=\"https://rawgithub.com/mjijackson/mjijackson.github.com/master/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript.html\">https://github.com/mjijackson</a>\n     * @private\n     * @param {Number} r Red color value\n     * @param {Number} g Green color value\n     * @param {Number} b Blue color value\n     * @return {Array} Hsl color\n     */\n    _rgbToHsl: function(r, g, b) {\n      r /= 255, g /= 255, b /= 255;\n\n      var h, s, l,\n          max = fabric.util.array.max([r, g, b]),\n          min = fabric.util.array.min([r, g, b]);\n\n      l = (max + min) / 2;\n\n      if (max === min) {\n        h = s = 0; // achromatic\n      }\n      else {\n        var d = max - min;\n        s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n        switch (max) {\n          case r:\n            h = (g - b) / d + (g < b ? 6 : 0);\n            break;\n          case g:\n            h = (b - r) / d + 2;\n            break;\n          case b:\n            h = (r - g) / d + 4;\n            break;\n        }\n        h /= 6;\n      }\n\n      return [\n        Math.round(h * 360),\n        Math.round(s * 100),\n        Math.round(l * 100)\n      ];\n    },\n\n    /**\n     * Returns source of this color (where source is an array representation; ex: [200, 200, 100, 1])\n     * @return {Array}\n     */\n    getSource: function() {\n      return this._source;\n    },\n\n    /**\n     * Sets source of this color (where source is an array representation; ex: [200, 200, 100, 1])\n     * @param {Array} source\n     */\n    setSource: function(source) {\n      this._source = source;\n    },\n\n    /**\n     * Returns color represenation in RGB format\n     * @return {String} ex: rgb(0-255,0-255,0-255)\n     */\n    toRgb: function() {\n      var source = this.getSource();\n      return 'rgb(' + source[0] + ',' + source[1] + ',' + source[2] + ')';\n    },\n\n    /**\n     * Returns color represenation in RGBA format\n     * @return {String} ex: rgba(0-255,0-255,0-255,0-1)\n     */\n    toRgba: function() {\n      var source = this.getSource();\n      return 'rgba(' + source[0] + ',' + source[1] + ',' + source[2] + ',' + source[3] + ')';\n    },\n\n    /**\n     * Returns color represenation in HSL format\n     * @return {String} ex: hsl(0-360,0%-100%,0%-100%)\n     */\n    toHsl: function() {\n      var source = this.getSource(),\n          hsl = this._rgbToHsl(source[0], source[1], source[2]);\n\n      return 'hsl(' + hsl[0] + ',' + hsl[1] + '%,' + hsl[2] + '%)';\n    },\n\n    /**\n     * Returns color represenation in HSLA format\n     * @return {String} ex: hsla(0-360,0%-100%,0%-100%,0-1)\n     */\n    toHsla: function() {\n      var source = this.getSource(),\n          hsl = this._rgbToHsl(source[0], source[1], source[2]);\n\n      return 'hsla(' + hsl[0] + ',' + hsl[1] + '%,' + hsl[2] + '%,' + source[3] + ')';\n    },\n\n    /**\n     * Returns color represenation in HEX format\n     * @return {String} ex: FF5555\n     */\n    toHex: function() {\n      var source = this.getSource(), r, g, b;\n\n      r = source[0].toString(16);\n      r = (r.length === 1) ? ('0' + r) : r;\n\n      g = source[1].toString(16);\n      g = (g.length === 1) ? ('0' + g) : g;\n\n      b = source[2].toString(16);\n      b = (b.length === 1) ? ('0' + b) : b;\n\n      return r.toUpperCase() + g.toUpperCase() + b.toUpperCase();\n    },\n\n    /**\n     * Gets value of alpha channel for this color\n     * @return {Number} 0-1\n     */\n    getAlpha: function() {\n      return this.getSource()[3];\n    },\n\n    /**\n     * Sets value of alpha channel for this color\n     * @param {Number} alpha Alpha value 0-1\n     * @return {fabric.Color} thisArg\n     */\n    setAlpha: function(alpha) {\n      var source = this.getSource();\n      source[3] = alpha;\n      this.setSource(source);\n      return this;\n    },\n\n    /**\n     * Transforms color to its grayscale representation\n     * @return {fabric.Color} thisArg\n     */\n    toGrayscale: function() {\n      var source = this.getSource(),\n          average = parseInt((source[0] * 0.3 + source[1] * 0.59 + source[2] * 0.11).toFixed(0), 10),\n          currentAlpha = source[3];\n      this.setSource([average, average, average, currentAlpha]);\n      return this;\n    },\n\n    /**\n     * Transforms color to its black and white representation\n     * @param {Number} threshold\n     * @return {fabric.Color} thisArg\n     */\n    toBlackWhite: function(threshold) {\n      var source = this.getSource(),\n          average = (source[0] * 0.3 + source[1] * 0.59 + source[2] * 0.11).toFixed(0),\n          currentAlpha = source[3];\n\n      threshold = threshold || 127;\n\n      average = (Number(average) < Number(threshold)) ? 0 : 255;\n      this.setSource([average, average, average, currentAlpha]);\n      return this;\n    },\n\n    /**\n     * Overlays color with another color\n     * @param {String|fabric.Color} otherColor\n     * @return {fabric.Color} thisArg\n     */\n    overlayWith: function(otherColor) {\n      if (!(otherColor instanceof Color)) {\n        otherColor = new Color(otherColor);\n      }\n\n      var result = [],\n          alpha = this.getAlpha(),\n          otherAlpha = 0.5,\n          source = this.getSource(),\n          otherSource = otherColor.getSource();\n\n      for (var i = 0; i < 3; i++) {\n        result.push(Math.round((source[i] * (1 - otherAlpha)) + (otherSource[i] * otherAlpha)));\n      }\n\n      result[3] = alpha;\n      this.setSource(result);\n      return this;\n    }\n  };\n\n  /**\n   * Regex matching color in RGB or RGBA formats (ex: rgb(0, 0, 0), rgba(255, 100, 10, 0.5), rgba( 255 , 100 , 10 , 0.5 ), rgb(1,1,1), rgba(100%, 60%, 10%, 0.5))\n   * @static\n   * @field\n   * @memberOf fabric.Color\n   */\n  fabric.Color.reRGBa = /^rgba?\\(\\s*(\\d{1,3}(?:\\.\\d+)?\\%?)\\s*,\\s*(\\d{1,3}(?:\\.\\d+)?\\%?)\\s*,\\s*(\\d{1,3}(?:\\.\\d+)?\\%?)\\s*(?:\\s*,\\s*(\\d+(?:\\.\\d+)?)\\s*)?\\)$/;\n\n  /**\n   * Regex matching color in HSL or HSLA formats (ex: hsl(200, 80%, 10%), hsla(300, 50%, 80%, 0.5), hsla( 300 , 50% , 80% , 0.5 ))\n   * @static\n   * @field\n   * @memberOf fabric.Color\n   */\n  fabric.Color.reHSLa = /^hsla?\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3}\\%)\\s*,\\s*(\\d{1,3}\\%)\\s*(?:\\s*,\\s*(\\d+(?:\\.\\d+)?)\\s*)?\\)$/;\n\n  /**\n   * Regex matching color in HEX format (ex: #FF5555, 010155, aff)\n   * @static\n   * @field\n   * @memberOf fabric.Color\n   */\n  fabric.Color.reHex = /^#?([0-9a-f]{6}|[0-9a-f]{3})$/i;\n\n  /**\n   * Map of the 17 basic color names with HEX code\n   * @static\n   * @field\n   * @memberOf fabric.Color\n   * @see: http://www.w3.org/TR/CSS2/syndata.html#color-units\n   */\n  fabric.Color.colorNameMap = {\n    aqua:    '#00FFFF',\n    black:   '#000000',\n    blue:    '#0000FF',\n    fuchsia: '#FF00FF',\n    gray:    '#808080',\n    grey:    '#808080',\n    green:   '#008000',\n    lime:    '#00FF00',\n    maroon:  '#800000',\n    navy:    '#000080',\n    olive:   '#808000',\n    orange:  '#FFA500',\n    purple:  '#800080',\n    red:     '#FF0000',\n    silver:  '#C0C0C0',\n    teal:    '#008080',\n    white:   '#FFFFFF',\n    yellow:  '#FFFF00'\n  };\n\n  /**\n   * @private\n   * @param {Number} p\n   * @param {Number} q\n   * @param {Number} t\n   * @return {Number}\n   */\n  function hue2rgb(p, q, t) {\n    if (t < 0) {\n      t += 1;\n    }\n    if (t > 1) {\n      t -= 1;\n    }\n    if (t < 1/6) {\n      return p + (q - p) * 6 * t;\n    }\n    if (t < 1/2) {\n      return q;\n    }\n    if (t < 2/3) {\n      return p + (q - p) * (2/3 - t) * 6;\n    }\n    return p;\n  }\n\n  /**\n   * Returns new color object, when given a color in RGB format\n   * @memberOf fabric.Color\n   * @param {String} color Color value ex: rgb(0-255,0-255,0-255)\n   * @return {fabric.Color}\n   */\n  fabric.Color.fromRgb = function(color) {\n    return Color.fromSource(Color.sourceFromRgb(color));\n  };\n\n  /**\n   * Returns array represenatation (ex: [100, 100, 200, 1]) of a color that's in RGB or RGBA format\n   * @memberOf fabric.Color\n   * @param {String} color Color value ex: rgb(0-255,0-255,0-255), rgb(0%-100%,0%-100%,0%-100%)\n   * @return {Array} source\n   */\n  fabric.Color.sourceFromRgb = function(color) {\n    var match = color.match(Color.reRGBa);\n    if (match) {\n      var r = parseInt(match[1], 10) / (/%$/.test(match[1]) ? 100 : 1) * (/%$/.test(match[1]) ? 255 : 1),\n          g = parseInt(match[2], 10) / (/%$/.test(match[2]) ? 100 : 1) * (/%$/.test(match[2]) ? 255 : 1),\n          b = parseInt(match[3], 10) / (/%$/.test(match[3]) ? 100 : 1) * (/%$/.test(match[3]) ? 255 : 1);\n\n      return [\n        parseInt(r, 10),\n        parseInt(g, 10),\n        parseInt(b, 10),\n        match[4] ? parseFloat(match[4]) : 1\n      ];\n    }\n  };\n\n  /**\n   * Returns new color object, when given a color in RGBA format\n   * @static\n   * @function\n   * @memberOf fabric.Color\n   * @param {String} color\n   * @return {fabric.Color}\n   */\n  fabric.Color.fromRgba = Color.fromRgb;\n\n  /**\n   * Returns new color object, when given a color in HSL format\n   * @param {String} color Color value ex: hsl(0-260,0%-100%,0%-100%)\n   * @memberOf fabric.Color\n   * @return {fabric.Color}\n   */\n  fabric.Color.fromHsl = function(color) {\n    return Color.fromSource(Color.sourceFromHsl(color));\n  };\n\n  /**\n   * Returns array represenatation (ex: [100, 100, 200, 1]) of a color that's in HSL or HSLA format.\n   * Adapted from <a href=\"https://rawgithub.com/mjijackson/mjijackson.github.com/master/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript.html\">https://github.com/mjijackson</a>\n   * @memberOf fabric.Color\n   * @param {String} color Color value ex: hsl(0-360,0%-100%,0%-100%) or hsla(0-360,0%-100%,0%-100%, 0-1)\n   * @return {Array} source\n   * @see http://http://www.w3.org/TR/css3-color/#hsl-color\n   */\n  fabric.Color.sourceFromHsl = function(color) {\n    var match = color.match(Color.reHSLa);\n    if (!match) {\n      return;\n    }\n\n    var h = (((parseFloat(match[1]) % 360) + 360) % 360) / 360,\n        s = parseFloat(match[2]) / (/%$/.test(match[2]) ? 100 : 1),\n        l = parseFloat(match[3]) / (/%$/.test(match[3]) ? 100 : 1),\n        r, g, b;\n\n    if (s === 0) {\n      r = g = b = l;\n    }\n    else {\n      var q = l <= 0.5 ? l * (s + 1) : l + s - l * s,\n          p = l * 2 - q;\n\n      r = hue2rgb(p, q, h + 1/3);\n      g = hue2rgb(p, q, h);\n      b = hue2rgb(p, q, h - 1/3);\n    }\n\n    return [\n      Math.round(r * 255),\n      Math.round(g * 255),\n      Math.round(b * 255),\n      match[4] ? parseFloat(match[4]) : 1\n    ];\n  };\n\n  /**\n   * Returns new color object, when given a color in HSLA format\n   * @static\n   * @function\n   * @memberOf fabric.Color\n   * @param {String} color\n   * @return {fabric.Color}\n   */\n  fabric.Color.fromHsla = Color.fromHsl;\n\n  /**\n   * Returns new color object, when given a color in HEX format\n   * @static\n   * @memberOf fabric.Color\n   * @param {String} color Color value ex: FF5555\n   * @return {fabric.Color}\n   */\n  fabric.Color.fromHex = function(color) {\n    return Color.fromSource(Color.sourceFromHex(color));\n  };\n\n  /**\n   * Returns array represenatation (ex: [100, 100, 200, 1]) of a color that's in HEX format\n   * @static\n   * @memberOf fabric.Color\n   * @param {String} color ex: FF5555\n   * @return {Array} source\n   */\n  fabric.Color.sourceFromHex = function(color) {\n    if (color.match(Color.reHex)) {\n      var value = color.slice(color.indexOf('#') + 1),\n          isShortNotation = (value.length === 3),\n          r = isShortNotation ? (value.charAt(0) + value.charAt(0)) : value.substring(0, 2),\n          g = isShortNotation ? (value.charAt(1) + value.charAt(1)) : value.substring(2, 4),\n          b = isShortNotation ? (value.charAt(2) + value.charAt(2)) : value.substring(4, 6);\n\n      return [\n        parseInt(r, 16),\n        parseInt(g, 16),\n        parseInt(b, 16),\n        1\n      ];\n    }\n  };\n\n  /**\n   * Returns new color object, when given color in array representation (ex: [200, 100, 100, 0.5])\n   * @static\n   * @memberOf fabric.Color\n   * @param {Array} source\n   * @return {fabric.Color}\n   */\n  fabric.Color.fromSource = function(source) {\n    var oColor = new Color();\n    oColor.setSource(source);\n    return oColor;\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function() {\n\n  /* _FROM_SVG_START_ */\n  function getColorStop(el) {\n    var style = el.getAttribute('style'),\n        offset = el.getAttribute('offset') || 0,\n        color, colorAlpha, opacity;\n\n    // convert percents to absolute values\n    offset = parseFloat(offset) / (/%$/.test(offset) ? 100 : 1);\n    offset = offset < 0 ? 0 : offset > 1 ? 1 : offset;\n    if (style) {\n      var keyValuePairs = style.split(/\\s*;\\s*/);\n\n      if (keyValuePairs[keyValuePairs.length - 1] === '') {\n        keyValuePairs.pop();\n      }\n\n      for (var i = keyValuePairs.length; i--; ) {\n\n        var split = keyValuePairs[i].split(/\\s*:\\s*/),\n            key = split[0].trim(),\n            value = split[1].trim();\n\n        if (key === 'stop-color') {\n          color = value;\n        }\n        else if (key === 'stop-opacity') {\n          opacity = value;\n        }\n      }\n    }\n\n    if (!color) {\n      color = el.getAttribute('stop-color') || 'rgb(0,0,0)';\n    }\n    if (!opacity) {\n      opacity = el.getAttribute('stop-opacity');\n    }\n\n    color = new fabric.Color(color);\n    colorAlpha = color.getAlpha();\n    opacity = isNaN(parseFloat(opacity)) ? 1 : parseFloat(opacity);\n    opacity *= colorAlpha;\n\n    return {\n      offset: offset,\n      color: color.toRgb(),\n      opacity: opacity\n    };\n  }\n\n  function getLinearCoords(el) {\n    return {\n      x1: el.getAttribute('x1') || 0,\n      y1: el.getAttribute('y1') || 0,\n      x2: el.getAttribute('x2') || '100%',\n      y2: el.getAttribute('y2') || 0\n    };\n  }\n\n  function getRadialCoords(el) {\n    return {\n      x1: el.getAttribute('fx') || el.getAttribute('cx') || '50%',\n      y1: el.getAttribute('fy') || el.getAttribute('cy') || '50%',\n      r1: 0,\n      x2: el.getAttribute('cx') || '50%',\n      y2: el.getAttribute('cy') || '50%',\n      r2: el.getAttribute('r') || '50%'\n    };\n  }\n  /* _FROM_SVG_END_ */\n\n  /**\n   * Gradient class\n   * @class fabric.Gradient\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-2#gradients}\n   * @see {@link fabric.Gradient#initialize} for constructor definition\n   */\n  fabric.Gradient = fabric.util.createClass(/** @lends fabric.Gradient.prototype */ {\n\n    /**\n     * Horizontal offset for aligning gradients coming from SVG when outside pathgroups\n     * @type Number\n     * @default 0\n     */\n    offsetX: 0,\n\n    /**\n     * Vertical offset for aligning gradients coming from SVG when outside pathgroups\n     * @type Number\n     * @default 0\n     */\n    offsetY: 0,\n\n    /**\n     * Constructor\n     * @param {Object} [options] Options object with type, coords, gradientUnits and colorStops\n     * @return {fabric.Gradient} thisArg\n     */\n    initialize: function(options) {\n      options || (options = { });\n\n      var coords = { };\n\n      this.id = fabric.Object.__uid++;\n      this.type = options.type || 'linear';\n\n      coords = {\n        x1: options.coords.x1 || 0,\n        y1: options.coords.y1 || 0,\n        x2: options.coords.x2 || 0,\n        y2: options.coords.y2 || 0\n      };\n\n      if (this.type === 'radial') {\n        coords.r1 = options.coords.r1 || 0;\n        coords.r2 = options.coords.r2 || 0;\n      }\n      this.coords = coords;\n      this.colorStops = options.colorStops.slice();\n      if (options.gradientTransform) {\n        this.gradientTransform = options.gradientTransform;\n      }\n      this.offsetX = options.offsetX || this.offsetX;\n      this.offsetY = options.offsetY || this.offsetY;\n    },\n\n    /**\n     * Adds another colorStop\n     * @param {Object} colorStop Object with offset and color\n     * @return {fabric.Gradient} thisArg\n     */\n    addColorStop: function(colorStop) {\n      for (var position in colorStop) {\n        var color = new fabric.Color(colorStop[position]);\n        this.colorStops.push({\n          offset: position,\n          color: color.toRgb(),\n          opacity: color.getAlpha()\n        });\n      }\n      return this;\n    },\n\n    /**\n     * Returns object representation of a gradient\n     * @return {Object}\n     */\n    toObject: function() {\n      return {\n        type: this.type,\n        coords: this.coords,\n        colorStops: this.colorStops,\n        offsetX: this.offsetX,\n        offsetY: this.offsetY,\n        gradientTransform: this.gradientTransform ? this.gradientTransform.concat() : this.gradientTransform\n      };\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns SVG representation of an gradient\n     * @param {Object} object Object to create a gradient for\n     * @param {Boolean} normalize Whether coords should be normalized\n     * @return {String} SVG representation of an gradient (linear/radial)\n     */\n    toSVG: function(object) {\n      var coords = fabric.util.object.clone(this.coords),\n          markup, commonAttributes;\n\n      // colorStops must be sorted ascending\n      this.colorStops.sort(function(a, b) {\n        return a.offset - b.offset;\n      });\n\n      if (!(object.group && object.group.type === 'path-group')) {\n        for (var prop in coords) {\n          if (prop === 'x1' || prop === 'x2' || prop === 'r2') {\n            coords[prop] += this.offsetX - object.width / 2;\n          }\n          else if (prop === 'y1' || prop === 'y2') {\n            coords[prop] += this.offsetY - object.height / 2;\n          }\n        }\n      }\n\n      commonAttributes = 'id=\"SVGID_' + this.id +\n                     '\" gradientUnits=\"userSpaceOnUse\"';\n      if (this.gradientTransform) {\n        commonAttributes += ' gradientTransform=\"matrix(' + this.gradientTransform.join(' ') + ')\" ';\n      }\n      if (this.type === 'linear') {\n        markup = [\n          //jscs:disable validateIndentation\n          '<linearGradient ',\n            commonAttributes,\n            ' x1=\"', coords.x1,\n            '\" y1=\"', coords.y1,\n            '\" x2=\"', coords.x2,\n            '\" y2=\"', coords.y2,\n          '\">\\n'\n          //jscs:enable validateIndentation\n        ];\n      }\n      else if (this.type === 'radial') {\n        markup = [\n          //jscs:disable validateIndentation\n          '<radialGradient ',\n            commonAttributes,\n            ' cx=\"', coords.x2,\n            '\" cy=\"', coords.y2,\n            '\" r=\"', coords.r2,\n            '\" fx=\"', coords.x1,\n            '\" fy=\"', coords.y1,\n          '\">\\n'\n          //jscs:enable validateIndentation\n        ];\n      }\n\n      for (var i = 0; i < this.colorStops.length; i++) {\n        markup.push(\n          //jscs:disable validateIndentation\n          '<stop ',\n            'offset=\"', (this.colorStops[i].offset * 100) + '%',\n            '\" style=\"stop-color:', this.colorStops[i].color,\n            (this.colorStops[i].opacity != null ? ';stop-opacity: ' + this.colorStops[i].opacity : ';'),\n          '\"/>\\n'\n          //jscs:enable validateIndentation\n        );\n      }\n\n      markup.push((this.type === 'linear' ? '</linearGradient>\\n' : '</radialGradient>\\n'));\n\n      return markup.join('');\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * Returns an instance of CanvasGradient\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @return {CanvasGradient}\n     */\n    toLive: function(ctx, object) {\n      var gradient, prop, coords = fabric.util.object.clone(this.coords);\n\n      if (!this.type) {\n        return;\n      }\n\n      if (object.group && object.group.type === 'path-group') {\n        for (prop in coords) {\n          if (prop === 'x1' || prop === 'x2') {\n            coords[prop] += -this.offsetX + object.width / 2;\n          }\n          else if (prop === 'y1' || prop === 'y2') {\n            coords[prop] += -this.offsetY + object.height / 2;\n          }\n        }\n      }\n\n      if (this.type === 'linear') {\n        gradient = ctx.createLinearGradient(\n          coords.x1, coords.y1, coords.x2, coords.y2);\n      }\n      else if (this.type === 'radial') {\n        gradient = ctx.createRadialGradient(\n          coords.x1, coords.y1, coords.r1, coords.x2, coords.y2, coords.r2);\n      }\n\n      for (var i = 0, len = this.colorStops.length; i < len; i++) {\n        var color = this.colorStops[i].color,\n            opacity = this.colorStops[i].opacity,\n            offset = this.colorStops[i].offset;\n\n        if (typeof opacity !== 'undefined') {\n          color = new fabric.Color(color).setAlpha(opacity).toRgba();\n        }\n        gradient.addColorStop(parseFloat(offset), color);\n      }\n\n      return gradient;\n    }\n  });\n\n  fabric.util.object.extend(fabric.Gradient, {\n\n    /* _FROM_SVG_START_ */\n    /**\n     * Returns {@link fabric.Gradient} instance from an SVG element\n     * @static\n     * @memberOf fabric.Gradient\n     * @param {SVGGradientElement} el SVG gradient element\n     * @param {fabric.Object} instance\n     * @return {fabric.Gradient} Gradient instance\n     * @see http://www.w3.org/TR/SVG/pservers.html#LinearGradientElement\n     * @see http://www.w3.org/TR/SVG/pservers.html#RadialGradientElement\n     */\n    fromElement: function(el, instance) {\n\n      /**\n       *  @example:\n       *\n       *  <linearGradient id=\"linearGrad1\">\n       *    <stop offset=\"0%\" stop-color=\"white\"/>\n       *    <stop offset=\"100%\" stop-color=\"black\"/>\n       *  </linearGradient>\n       *\n       *  OR\n       *\n       *  <linearGradient id=\"linearGrad2\">\n       *    <stop offset=\"0\" style=\"stop-color:rgb(255,255,255)\"/>\n       *    <stop offset=\"1\" style=\"stop-color:rgb(0,0,0)\"/>\n       *  </linearGradient>\n       *\n       *  OR\n       *\n       *  <radialGradient id=\"radialGrad1\">\n       *    <stop offset=\"0%\" stop-color=\"white\" stop-opacity=\"1\" />\n       *    <stop offset=\"50%\" stop-color=\"black\" stop-opacity=\"0.5\" />\n       *    <stop offset=\"100%\" stop-color=\"white\" stop-opacity=\"1\" />\n       *  </radialGradient>\n       *\n       *  OR\n       *\n       *  <radialGradient id=\"radialGrad2\">\n       *    <stop offset=\"0\" stop-color=\"rgb(255,255,255)\" />\n       *    <stop offset=\"0.5\" stop-color=\"rgb(0,0,0)\" />\n       *    <stop offset=\"1\" stop-color=\"rgb(255,255,255)\" />\n       *  </radialGradient>\n       *\n       */\n\n      var colorStopEls = el.getElementsByTagName('stop'),\n          type = (el.nodeName === 'linearGradient' ? 'linear' : 'radial'),\n          gradientUnits = el.getAttribute('gradientUnits') || 'objectBoundingBox',\n          gradientTransform = el.getAttribute('gradientTransform'),\n          colorStops = [],\n          coords = { }, ellipseMatrix;\n\n      if (type === 'linear') {\n        coords = getLinearCoords(el);\n      }\n      else if (type === 'radial') {\n        coords = getRadialCoords(el);\n      }\n\n      for (var i = colorStopEls.length; i--; ) {\n        colorStops.push(getColorStop(colorStopEls[i]));\n      }\n\n      ellipseMatrix = _convertPercentUnitsToValues(instance, coords, gradientUnits);\n\n      var gradient = new fabric.Gradient({\n        type: type,\n        coords: coords,\n        colorStops: colorStops,\n        offsetX: -instance.left,\n        offsetY: -instance.top\n      });\n\n      if (gradientTransform || ellipseMatrix !== '') {\n        gradient.gradientTransform = fabric.parseTransformAttribute((gradientTransform || '') + ellipseMatrix);\n      }\n      return gradient;\n    },\n    /* _FROM_SVG_END_ */\n\n    /**\n     * Returns {@link fabric.Gradient} instance from its object representation\n     * @static\n     * @memberOf fabric.Gradient\n     * @param {Object} obj\n     * @param {Object} [options] Options object\n     */\n    forObject: function(obj, options) {\n      options || (options = { });\n      _convertPercentUnitsToValues(obj, options.coords, 'userSpaceOnUse');\n      return new fabric.Gradient(options);\n    }\n  });\n\n  /**\n   * @private\n   */\n  function _convertPercentUnitsToValues(object, options, gradientUnits) {\n    var propValue, addFactor = 0, multFactor = 1, ellipseMatrix = '';\n    for (var prop in options) {\n      propValue = parseFloat(options[prop], 10);\n      if (typeof options[prop] === 'string' && /^\\d+%$/.test(options[prop])) {\n        multFactor = 0.01;\n      }\n      else {\n        multFactor = 1;\n      }\n      if (prop === 'x1' || prop === 'x2' || prop === 'r2') {\n        multFactor *= gradientUnits === 'objectBoundingBox' ? object.width : 1;\n        addFactor = gradientUnits === 'objectBoundingBox' ? object.left || 0 : 0;\n      }\n      else if (prop === 'y1' || prop === 'y2') {\n        multFactor *= gradientUnits === 'objectBoundingBox' ? object.height : 1;\n        addFactor = gradientUnits === 'objectBoundingBox' ? object.top || 0 : 0;\n      }\n      options[prop] = propValue * multFactor + addFactor;\n    }\n    if (object.type === 'ellipse' &&\n        options.r2 !== null &&\n        gradientUnits === 'objectBoundingBox' &&\n        object.rx !== object.ry) {\n\n      var scaleFactor = object.ry/object.rx;\n      ellipseMatrix = ' scale(1, ' + scaleFactor + ')';\n      if (options.y1) {\n        options.y1 /= scaleFactor;\n      }\n      if (options.y2) {\n        options.y2 /= scaleFactor;\n      }\n    }\n    return ellipseMatrix;\n  }\n})();\n\n\n/**\n * Pattern class\n * @class fabric.Pattern\n * @see {@link http://fabricjs.com/patterns|Pattern demo}\n * @see {@link http://fabricjs.com/dynamic-patterns|DynamicPattern demo}\n * @see {@link fabric.Pattern#initialize} for constructor definition\n */\nfabric.Pattern = fabric.util.createClass(/** @lends fabric.Pattern.prototype */ {\n\n  /**\n   * Repeat property of a pattern (one of repeat, repeat-x, repeat-y or no-repeat)\n   * @type String\n   * @default\n   */\n  repeat: 'repeat',\n\n  /**\n   * Pattern horizontal offset from object's left/top corner\n   * @type Number\n   * @default\n   */\n  offsetX: 0,\n\n  /**\n   * Pattern vertical offset from object's left/top corner\n   * @type Number\n   * @default\n   */\n  offsetY: 0,\n\n  /**\n   * Constructor\n   * @param {Object} [options] Options object\n   * @return {fabric.Pattern} thisArg\n   */\n  initialize: function(options) {\n    options || (options = { });\n\n    this.id = fabric.Object.__uid++;\n\n    if (options.source) {\n      if (typeof options.source === 'string') {\n        // function string\n        if (typeof fabric.util.getFunctionBody(options.source) !== 'undefined') {\n          this.source = new Function(fabric.util.getFunctionBody(options.source));\n        }\n        else {\n          // img src string\n          var _this = this;\n          this.source = fabric.util.createImage();\n          fabric.util.loadImage(options.source, function(img) {\n            _this.source = img;\n          });\n        }\n      }\n      else {\n        // img element\n        this.source = options.source;\n      }\n    }\n    if (options.repeat) {\n      this.repeat = options.repeat;\n    }\n    if (options.offsetX) {\n      this.offsetX = options.offsetX;\n    }\n    if (options.offsetY) {\n      this.offsetY = options.offsetY;\n    }\n  },\n\n  /**\n   * Returns object representation of a pattern\n   * @return {Object} Object representation of a pattern instance\n   */\n  toObject: function() {\n\n    var source;\n\n    // callback\n    if (typeof this.source === 'function') {\n      source = String(this.source);\n    }\n    // <img> element\n    else if (typeof this.source.src === 'string') {\n      source = this.source.src;\n    }\n    // <canvas> element\n    else if (typeof this.source === 'object' && this.source.toDataURL) {\n      source = this.source.toDataURL();\n    }\n\n    return {\n      source: source,\n      repeat: this.repeat,\n      offsetX: this.offsetX,\n      offsetY: this.offsetY\n    };\n  },\n\n  /* _TO_SVG_START_ */\n  /**\n   * Returns SVG representation of a pattern\n   * @param {fabric.Object} object\n   * @return {String} SVG representation of a pattern\n   */\n  toSVG: function(object) {\n    var patternSource = typeof this.source === 'function' ? this.source() : this.source,\n        patternWidth = patternSource.width / object.getWidth(),\n        patternHeight = patternSource.height / object.getHeight(),\n        patternOffsetX = this.offsetX / object.getWidth(),\n        patternOffsetY = this.offsetY / object.getHeight(),\n        patternImgSrc = '';\n    if (this.repeat === 'repeat-x' || this.repeat === 'no-repeat') {\n      patternHeight = 1;\n    }\n    if (this.repeat === 'repeat-y' || this.repeat === 'no-repeat') {\n      patternWidth = 1;\n    }\n    if (patternSource.src) {\n      patternImgSrc = patternSource.src;\n    }\n    else if (patternSource.toDataURL) {\n      patternImgSrc = patternSource.toDataURL();\n    }\n\n    return '<pattern id=\"SVGID_' + this.id +\n                  '\" x=\"' + patternOffsetX +\n                  '\" y=\"' + patternOffsetY +\n                  '\" width=\"' + patternWidth +\n                  '\" height=\"' + patternHeight + '\">\\n' +\n             '<image x=\"0\" y=\"0\"' +\n                    ' width=\"' + patternSource.width +\n                    '\" height=\"' + patternSource.height +\n                    '\" xlink:href=\"' + patternImgSrc +\n             '\"></image>\\n' +\n           '</pattern>\\n';\n  },\n  /* _TO_SVG_END_ */\n\n  /**\n   * Returns an instance of CanvasPattern\n   * @param {CanvasRenderingContext2D} ctx Context to create pattern\n   * @return {CanvasPattern}\n   */\n  toLive: function(ctx) {\n    var source = typeof this.source === 'function'\n      ? this.source()\n      : this.source;\n\n    // if the image failed to load, return, and allow rest to continue loading\n    if (!source) {\n      return '';\n    }\n\n    // if an image\n    if (typeof source.src !== 'undefined') {\n      if (!source.complete) {\n        return '';\n      }\n      if (source.naturalWidth === 0 || source.naturalHeight === 0) {\n        return '';\n      }\n    }\n    return ctx.createPattern(source, this.repeat);\n  }\n});\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { }),\n      toFixed = fabric.util.toFixed;\n\n  if (fabric.Shadow) {\n    fabric.warn('fabric.Shadow is already defined.');\n    return;\n  }\n\n  /**\n   * Shadow class\n   * @class fabric.Shadow\n   * @see {@link http://fabricjs.com/shadows|Shadow demo}\n   * @see {@link fabric.Shadow#initialize} for constructor definition\n   */\n  fabric.Shadow = fabric.util.createClass(/** @lends fabric.Shadow.prototype */ {\n\n    /**\n     * Shadow color\n     * @type String\n     * @default\n     */\n    color: 'rgb(0,0,0)',\n\n    /**\n     * Shadow blur\n     * @type Number\n     */\n    blur: 0,\n\n    /**\n     * Shadow horizontal offset\n     * @type Number\n     * @default\n     */\n    offsetX: 0,\n\n    /**\n     * Shadow vertical offset\n     * @type Number\n     * @default\n     */\n    offsetY: 0,\n\n    /**\n     * Whether the shadow should affect stroke operations\n     * @type Boolean\n     * @default\n     */\n    affectStroke: false,\n\n    /**\n     * Indicates whether toObject should include default values\n     * @type Boolean\n     * @default\n     */\n    includeDefaultValues: true,\n\n    /**\n     * Constructor\n     * @param {Object|String} [options] Options object with any of color, blur, offsetX, offsetX properties or string (e.g. \"rgba(0,0,0,0.2) 2px 2px 10px, \"2px 2px 10px rgba(0,0,0,0.2)\")\n     * @return {fabric.Shadow} thisArg\n     */\n    initialize: function(options) {\n\n      if (typeof options === 'string') {\n        options = this._parseShadow(options);\n      }\n\n      for (var prop in options) {\n        this[prop] = options[prop];\n      }\n\n      this.id = fabric.Object.__uid++;\n    },\n\n    /**\n     * @private\n     * @param {String} shadow Shadow value to parse\n     * @return {Object} Shadow object with color, offsetX, offsetY and blur\n     */\n    _parseShadow: function(shadow) {\n      var shadowStr = shadow.trim(),\n          offsetsAndBlur = fabric.Shadow.reOffsetsAndBlur.exec(shadowStr) || [ ],\n          color = shadowStr.replace(fabric.Shadow.reOffsetsAndBlur, '') || 'rgb(0,0,0)';\n\n      return {\n        color: color.trim(),\n        offsetX: parseInt(offsetsAndBlur[1], 10) || 0,\n        offsetY: parseInt(offsetsAndBlur[2], 10) || 0,\n        blur: parseInt(offsetsAndBlur[3], 10) || 0\n      };\n    },\n\n    /**\n     * Returns a string representation of an instance\n     * @see http://www.w3.org/TR/css-text-decor-3/#text-shadow\n     * @return {String} Returns CSS3 text-shadow declaration\n     */\n    toString: function() {\n      return [this.offsetX, this.offsetY, this.blur, this.color].join('px ');\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns SVG representation of a shadow\n     * @param {fabric.Object} object\n     * @return {String} SVG representation of a shadow\n     */\n    toSVG: function(object) {\n      var fBoxX = 40, fBoxY = 40, NUM_FRACTION_DIGITS = fabric.Object.NUM_FRACTION_DIGITS,\n          offset = fabric.util.rotateVector(\n            { x: this.offsetX, y: this.offsetY },\n            fabric.util.degreesToRadians(-object.angle)),\n          BLUR_BOX = 20;\n\n      if (object.width && object.height) {\n        //http://www.w3.org/TR/SVG/filters.html#FilterEffectsRegion\n        // we add some extra space to filter box to contain the blur ( 20 )\n        fBoxX = toFixed((Math.abs(offset.x) + this.blur) / object.width, NUM_FRACTION_DIGITS) * 100 + BLUR_BOX;\n        fBoxY = toFixed((Math.abs(offset.y) + this.blur) / object.height, NUM_FRACTION_DIGITS) * 100 + BLUR_BOX;\n      }\n      if (object.flipX) {\n        offset.x *= -1;\n      }\n      if (object.flipY) {\n        offset.y *= -1;\n      }\n      return (\n        '<filter id=\"SVGID_' + this.id + '\" y=\"-' + fBoxY + '%\" height=\"' + (100 + 2 * fBoxY) + '%\" ' +\n          'x=\"-' + fBoxX + '%\" width=\"' + (100 + 2 * fBoxX) + '%\" ' + '>\\n' +\n          '\\t<feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"' +\n            toFixed(this.blur ? this.blur / 2 : 0, NUM_FRACTION_DIGITS) + '\"></feGaussianBlur>\\n' +\n          '\\t<feOffset dx=\"' + toFixed(offset.x, NUM_FRACTION_DIGITS) +\n          '\" dy=\"' + toFixed(offset.y, NUM_FRACTION_DIGITS) + '\" result=\"oBlur\" ></feOffset>\\n' +\n          '\\t<feFlood flood-color=\"' + this.color + '\"/>\\n' +\n          '\\t<feComposite in2=\"oBlur\" operator=\"in\" />\\n' +\n          '\\t<feMerge>\\n' +\n            '\\t\\t<feMergeNode></feMergeNode>\\n' +\n            '\\t\\t<feMergeNode in=\"SourceGraphic\"></feMergeNode>\\n' +\n          '\\t</feMerge>\\n' +\n        '</filter>\\n');\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * Returns object representation of a shadow\n     * @return {Object} Object representation of a shadow instance\n     */\n    toObject: function() {\n      if (this.includeDefaultValues) {\n        return {\n          color: this.color,\n          blur: this.blur,\n          offsetX: this.offsetX,\n          offsetY: this.offsetY,\n          affectStroke: this.affectStroke\n        };\n      }\n      var obj = { }, proto = fabric.Shadow.prototype;\n\n      ['color', 'blur', 'offsetX', 'offsetY', 'affectStroke'].forEach(function(prop) {\n        if (this[prop] !== proto[prop]) {\n          obj[prop] = this[prop];\n        }\n      }, this);\n\n      return obj;\n    }\n  });\n\n  /**\n   * Regex matching shadow offsetX, offsetY and blur (ex: \"2px 2px 10px rgba(0,0,0,0.2)\", \"rgb(0,255,0) 2px 2px\")\n   * @static\n   * @field\n   * @memberOf fabric.Shadow\n   */\n  fabric.Shadow.reOffsetsAndBlur = /(?:\\s|^)(-?\\d+(?:px)?(?:\\s?|$))?(-?\\d+(?:px)?(?:\\s?|$))?(\\d+(?:px)?)?(?:\\s?|$)(?:$|\\s)/;\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function () {\n\n  'use strict';\n\n  if (fabric.StaticCanvas) {\n    fabric.warn('fabric.StaticCanvas is already defined.');\n    return;\n  }\n\n  // aliases for faster resolution\n  var extend = fabric.util.object.extend,\n      getElementOffset = fabric.util.getElementOffset,\n      removeFromArray = fabric.util.removeFromArray,\n      toFixed = fabric.util.toFixed,\n\n      CANVAS_INIT_ERROR = new Error('Could not initialize `canvas` element');\n\n  /**\n   * Static canvas class\n   * @class fabric.StaticCanvas\n   * @mixes fabric.Collection\n   * @mixes fabric.Observable\n   * @see {@link http://fabricjs.com/static_canvas|StaticCanvas demo}\n   * @see {@link fabric.StaticCanvas#initialize} for constructor definition\n   * @fires before:render\n   * @fires after:render\n   * @fires canvas:cleared\n   * @fires object:added\n   * @fires object:removed\n   */\n  fabric.StaticCanvas = fabric.util.createClass(/** @lends fabric.StaticCanvas.prototype */ {\n\n    /**\n     * Constructor\n     * @param {HTMLElement | String} el &lt;canvas> element to initialize instance on\n     * @param {Object} [options] Options object\n     * @return {Object} thisArg\n     */\n    initialize: function(el, options) {\n      options || (options = { });\n\n      this._initStatic(el, options);\n    },\n\n    /**\n     * Background color of canvas instance.\n     * Should be set via {@link fabric.StaticCanvas#setBackgroundColor}.\n     * @type {(String|fabric.Pattern)}\n     * @default\n     */\n    backgroundColor: '',\n\n    /**\n     * Background image of canvas instance.\n     * Should be set via {@link fabric.StaticCanvas#setBackgroundImage}.\n     * <b>Backwards incompatibility note:</b> The \"backgroundImageOpacity\"\n     * and \"backgroundImageStretch\" properties are deprecated since 1.3.9.\n     * Use {@link fabric.Image#opacity}, {@link fabric.Image#width} and {@link fabric.Image#height}.\n     * @type fabric.Image\n     * @default\n     */\n    backgroundImage: null,\n\n    /**\n     * Overlay color of canvas instance.\n     * Should be set via {@link fabric.StaticCanvas#setOverlayColor}\n     * @since 1.3.9\n     * @type {(String|fabric.Pattern)}\n     * @default\n     */\n    overlayColor: '',\n\n    /**\n     * Overlay image of canvas instance.\n     * Should be set via {@link fabric.StaticCanvas#setOverlayImage}.\n     * <b>Backwards incompatibility note:</b> The \"overlayImageLeft\"\n     * and \"overlayImageTop\" properties are deprecated since 1.3.9.\n     * Use {@link fabric.Image#left} and {@link fabric.Image#top}.\n     * @type fabric.Image\n     * @default\n     */\n    overlayImage: null,\n\n    /**\n     * Indicates whether toObject/toDatalessObject should include default values\n     * @type Boolean\n     * @default\n     */\n    includeDefaultValues: true,\n\n    /**\n     * Indicates whether objects' state should be saved\n     * @type Boolean\n     * @default\n     */\n    stateful: true,\n\n    /**\n     * Indicates whether {@link fabric.Collection.add}, {@link fabric.Collection.insertAt} and {@link fabric.Collection.remove} should also re-render canvas.\n     * Disabling this option could give a great performance boost when adding/removing a lot of objects to/from canvas at once\n     * (followed by a manual rendering after addition/deletion)\n     * @type Boolean\n     * @default\n     */\n    renderOnAddRemove: true,\n\n    /**\n     * Function that determines clipping of entire canvas area\n     * Being passed context as first argument. See clipping canvas area in {@link https://github.com/kangax/fabric.js/wiki/FAQ}\n     * @type Function\n     * @default\n     */\n    clipTo: null,\n\n    /**\n     * Indicates whether object controls (borders/controls) are rendered above overlay image\n     * @type Boolean\n     * @default\n     */\n    controlsAboveOverlay: false,\n\n    /**\n     * Indicates whether the browser can be scrolled when using a touchscreen and dragging on the canvas\n     * @type Boolean\n     * @default\n     */\n    allowTouchScrolling: false,\n\n    /**\n     * Indicates whether this canvas will use image smoothing, this is on by default in browsers\n     * @type Boolean\n     * @default\n     */\n    imageSmoothingEnabled: true,\n\n    /**\n     * Indicates whether objects should remain in current stack position when selected. When false objects are brought to top and rendered as part of the selection group\n     * @type Boolean\n     * @default\n     */\n    preserveObjectStacking: false,\n\n    /**\n     * The transformation (in the format of Canvas transform) which focuses the viewport\n     * @type Array\n     * @default\n     */\n    viewportTransform: [1, 0, 0, 1, 0, 0],\n\n    /**\n     * Callback; invoked right before object is about to be scaled/rotated\n     */\n    onBeforeScaleRotate: function () {\n      /* NOOP */\n    },\n\n    /**\n     * When true, canvas is scaled by devicePixelRatio for better rendering on retina screens\n     */\n    enableRetinaScaling: true,\n\n    /**\n     * @private\n     * @param {HTMLElement | String} el &lt;canvas> element to initialize instance on\n     * @param {Object} [options] Options object\n     */\n    _initStatic: function(el, options) {\n      this._objects = [];\n\n      this._createLowerCanvas(el);\n      this._initOptions(options);\n      this._setImageSmoothing();\n\n      // only initialize retina scaling once\n      if (!this.interactive) {\n        this._initRetinaScaling();\n      }\n\n      if (options.overlayImage) {\n        this.setOverlayImage(options.overlayImage, this.renderAll.bind(this));\n      }\n      if (options.backgroundImage) {\n        this.setBackgroundImage(options.backgroundImage, this.renderAll.bind(this));\n      }\n      if (options.backgroundColor) {\n        this.setBackgroundColor(options.backgroundColor, this.renderAll.bind(this));\n      }\n      if (options.overlayColor) {\n        this.setOverlayColor(options.overlayColor, this.renderAll.bind(this));\n      }\n      this.calcOffset();\n    },\n\n    /**\n     * @private\n     */\n    _isRetinaScaling: function() {\n      return (fabric.devicePixelRatio !== 1 && this.enableRetinaScaling);\n    },\n\n    /**\n     * @private\n     */\n    _initRetinaScaling: function() {\n      if (!this._isRetinaScaling()) {\n        return;\n      }\n\n      this.lowerCanvasEl.setAttribute('width', this.width * fabric.devicePixelRatio);\n      this.lowerCanvasEl.setAttribute('height', this.height * fabric.devicePixelRatio);\n\n      this.contextContainer.scale(fabric.devicePixelRatio, fabric.devicePixelRatio);\n    },\n\n    /**\n     * Calculates canvas element offset relative to the document\n     * This method is also attached as \"resize\" event handler of window\n     * @return {fabric.Canvas} instance\n     * @chainable\n     */\n    calcOffset: function () {\n      this._offset = getElementOffset(this.lowerCanvasEl);\n      return this;\n    },\n\n    /**\n     * Sets {@link fabric.StaticCanvas#overlayImage|overlay image} for this canvas\n     * @param {(fabric.Image|String)} image fabric.Image instance or URL of an image to set overlay to\n     * @param {Function} callback callback to invoke when image is loaded and set as an overlay\n     * @param {Object} [options] Optional options to set for the {@link fabric.Image|overlay image}.\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     * @see {@link http://jsfiddle.net/fabricjs/MnzHT/|jsFiddle demo}\n     * @example <caption>Normal overlayImage with left/top = 0</caption>\n     * canvas.setOverlayImage('http://fabricjs.com/assets/jail_cell_bars.png', canvas.renderAll.bind(canvas), {\n     *   // Needed to position overlayImage at 0/0\n     *   originX: 'left',\n     *   originY: 'top'\n     * });\n     * @example <caption>overlayImage with different properties</caption>\n     * canvas.setOverlayImage('http://fabricjs.com/assets/jail_cell_bars.png', canvas.renderAll.bind(canvas), {\n     *   opacity: 0.5,\n     *   angle: 45,\n     *   left: 400,\n     *   top: 400,\n     *   originX: 'left',\n     *   originY: 'top'\n     * });\n     * @example <caption>Stretched overlayImage #1 - width/height correspond to canvas width/height</caption>\n     * fabric.Image.fromURL('http://fabricjs.com/assets/jail_cell_bars.png', function(img) {\n     *    img.set({width: canvas.width, height: canvas.height, originX: 'left', originY: 'top'});\n     *    canvas.setOverlayImage(img, canvas.renderAll.bind(canvas));\n     * });\n     * @example <caption>Stretched overlayImage #2 - width/height correspond to canvas width/height</caption>\n     * canvas.setOverlayImage('http://fabricjs.com/assets/jail_cell_bars.png', canvas.renderAll.bind(canvas), {\n     *   width: canvas.width,\n     *   height: canvas.height,\n     *   // Needed to position overlayImage at 0/0\n     *   originX: 'left',\n     *   originY: 'top'\n     * });\n     * @example <caption>overlayImage loaded from cross-origin</caption>\n     * canvas.setOverlayImage('http://fabricjs.com/assets/jail_cell_bars.png', canvas.renderAll.bind(canvas), {\n     *   opacity: 0.5,\n     *   angle: 45,\n     *   left: 400,\n     *   top: 400,\n     *   originX: 'left',\n     *   originY: 'top',\n     *   crossOrigin: 'anonymous'\n     * });\n     */\n    setOverlayImage: function (image, callback, options) {\n      return this.__setBgOverlayImage('overlayImage', image, callback, options);\n    },\n\n    /**\n     * Sets {@link fabric.StaticCanvas#backgroundImage|background image} for this canvas\n     * @param {(fabric.Image|String)} image fabric.Image instance or URL of an image to set background to\n     * @param {Function} callback Callback to invoke when image is loaded and set as background\n     * @param {Object} [options] Optional options to set for the {@link fabric.Image|background image}.\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     * @see {@link http://jsfiddle.net/fabricjs/YH9yD/|jsFiddle demo}\n     * @example <caption>Normal backgroundImage with left/top = 0</caption>\n     * canvas.setBackgroundImage('http://fabricjs.com/assets/honey_im_subtle.png', canvas.renderAll.bind(canvas), {\n     *   // Needed to position backgroundImage at 0/0\n     *   originX: 'left',\n     *   originY: 'top'\n     * });\n     * @example <caption>backgroundImage with different properties</caption>\n     * canvas.setBackgroundImage('http://fabricjs.com/assets/honey_im_subtle.png', canvas.renderAll.bind(canvas), {\n     *   opacity: 0.5,\n     *   angle: 45,\n     *   left: 400,\n     *   top: 400,\n     *   originX: 'left',\n     *   originY: 'top'\n     * });\n     * @example <caption>Stretched backgroundImage #1 - width/height correspond to canvas width/height</caption>\n     * fabric.Image.fromURL('http://fabricjs.com/assets/honey_im_subtle.png', function(img) {\n     *    img.set({width: canvas.width, height: canvas.height, originX: 'left', originY: 'top'});\n     *    canvas.setBackgroundImage(img, canvas.renderAll.bind(canvas));\n     * });\n     * @example <caption>Stretched backgroundImage #2 - width/height correspond to canvas width/height</caption>\n     * canvas.setBackgroundImage('http://fabricjs.com/assets/honey_im_subtle.png', canvas.renderAll.bind(canvas), {\n     *   width: canvas.width,\n     *   height: canvas.height,\n     *   // Needed to position backgroundImage at 0/0\n     *   originX: 'left',\n     *   originY: 'top'\n     * });\n     * @example <caption>backgroundImage loaded from cross-origin</caption>\n     * canvas.setBackgroundImage('http://fabricjs.com/assets/honey_im_subtle.png', canvas.renderAll.bind(canvas), {\n     *   opacity: 0.5,\n     *   angle: 45,\n     *   left: 400,\n     *   top: 400,\n     *   originX: 'left',\n     *   originY: 'top',\n     *   crossOrigin: 'anonymous'\n     * });\n     */\n    setBackgroundImage: function (image, callback, options) {\n      return this.__setBgOverlayImage('backgroundImage', image, callback, options);\n    },\n\n    /**\n     * Sets {@link fabric.StaticCanvas#overlayColor|background color} for this canvas\n     * @param {(String|fabric.Pattern)} overlayColor Color or pattern to set background color to\n     * @param {Function} callback Callback to invoke when background color is set\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     * @see {@link http://jsfiddle.net/fabricjs/pB55h/|jsFiddle demo}\n     * @example <caption>Normal overlayColor - color value</caption>\n     * canvas.setOverlayColor('rgba(255, 73, 64, 0.6)', canvas.renderAll.bind(canvas));\n     * @example <caption>fabric.Pattern used as overlayColor</caption>\n     * canvas.setOverlayColor({\n     *   source: 'http://fabricjs.com/assets/escheresque_ste.png'\n     * }, canvas.renderAll.bind(canvas));\n     * @example <caption>fabric.Pattern used as overlayColor with repeat and offset</caption>\n     * canvas.setOverlayColor({\n     *   source: 'http://fabricjs.com/assets/escheresque_ste.png',\n     *   repeat: 'repeat',\n     *   offsetX: 200,\n     *   offsetY: 100\n     * }, canvas.renderAll.bind(canvas));\n     */\n    setOverlayColor: function(overlayColor, callback) {\n      return this.__setBgOverlayColor('overlayColor', overlayColor, callback);\n    },\n\n    /**\n     * Sets {@link fabric.StaticCanvas#backgroundColor|background color} for this canvas\n     * @param {(String|fabric.Pattern)} backgroundColor Color or pattern to set background color to\n     * @param {Function} callback Callback to invoke when background color is set\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     * @see {@link http://jsfiddle.net/fabricjs/hXzvk/|jsFiddle demo}\n     * @example <caption>Normal backgroundColor - color value</caption>\n     * canvas.setBackgroundColor('rgba(255, 73, 64, 0.6)', canvas.renderAll.bind(canvas));\n     * @example <caption>fabric.Pattern used as backgroundColor</caption>\n     * canvas.setBackgroundColor({\n     *   source: 'http://fabricjs.com/assets/escheresque_ste.png'\n     * }, canvas.renderAll.bind(canvas));\n     * @example <caption>fabric.Pattern used as backgroundColor with repeat and offset</caption>\n     * canvas.setBackgroundColor({\n     *   source: 'http://fabricjs.com/assets/escheresque_ste.png',\n     *   repeat: 'repeat',\n     *   offsetX: 200,\n     *   offsetY: 100\n     * }, canvas.renderAll.bind(canvas));\n     */\n    setBackgroundColor: function(backgroundColor, callback) {\n      return this.__setBgOverlayColor('backgroundColor', backgroundColor, callback);\n    },\n\n    /**\n     * @private\n     * @see {@link http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#dom-context-2d-imagesmoothingenabled|WhatWG Canvas Standard}\n     */\n    _setImageSmoothing: function() {\n      var ctx = this.getContext();\n\n      ctx.imageSmoothingEnabled = ctx.imageSmoothingEnabled || ctx.webkitImageSmoothingEnabled\n        || ctx.mozImageSmoothingEnabled || ctx.msImageSmoothingEnabled || ctx.oImageSmoothingEnabled;\n      ctx.imageSmoothingEnabled = this.imageSmoothingEnabled;\n    },\n\n    /**\n     * @private\n     * @param {String} property Property to set ({@link fabric.StaticCanvas#backgroundImage|backgroundImage}\n     * or {@link fabric.StaticCanvas#overlayImage|overlayImage})\n     * @param {(fabric.Image|String|null)} image fabric.Image instance, URL of an image or null to set background or overlay to\n     * @param {Function} callback Callback to invoke when image is loaded and set as background or overlay\n     * @param {Object} [options] Optional options to set for the {@link fabric.Image|image}.\n     */\n    __setBgOverlayImage: function(property, image, callback, options) {\n      if (typeof image === 'string') {\n        fabric.util.loadImage(image, function(img) {\n          this[property] = new fabric.Image(img, options);\n          callback && callback(img);\n        }, this, options && options.crossOrigin);\n      }\n      else {\n        options && image.setOptions(options);\n        this[property] = image;\n        callback && callback(image);\n      }\n\n      return this;\n    },\n\n    /**\n     * @private\n     * @param {String} property Property to set ({@link fabric.StaticCanvas#backgroundColor|backgroundColor}\n     * or {@link fabric.StaticCanvas#overlayColor|overlayColor})\n     * @param {(Object|String|null)} color Object with pattern information, color value or null\n     * @param {Function} [callback] Callback is invoked when color is set\n     */\n    __setBgOverlayColor: function(property, color, callback) {\n      if (color && color.source) {\n        var _this = this;\n        fabric.util.loadImage(color.source, function(img) {\n          _this[property] = new fabric.Pattern({\n            source: img,\n            repeat: color.repeat,\n            offsetX: color.offsetX,\n            offsetY: color.offsetY\n          });\n          callback && callback();\n        });\n      }\n      else {\n        this[property] = color;\n        callback && callback();\n      }\n\n      return this;\n    },\n\n    /**\n     * @private\n     */\n    _createCanvasElement: function() {\n      var element = fabric.document.createElement('canvas');\n      if (!element.style) {\n        element.style = { };\n      }\n      if (!element) {\n        throw CANVAS_INIT_ERROR;\n      }\n      this._initCanvasElement(element);\n      return element;\n    },\n\n    /**\n     * @private\n     * @param {HTMLElement} element\n     */\n    _initCanvasElement: function(element) {\n      fabric.util.createCanvasElement(element);\n\n      if (typeof element.getContext === 'undefined') {\n        throw CANVAS_INIT_ERROR;\n      }\n    },\n\n    /**\n     * @private\n     * @param {Object} [options] Options object\n     */\n    _initOptions: function (options) {\n      for (var prop in options) {\n        this[prop] = options[prop];\n      }\n\n      this.width = this.width || parseInt(this.lowerCanvasEl.width, 10) || 0;\n      this.height = this.height || parseInt(this.lowerCanvasEl.height, 10) || 0;\n\n      if (!this.lowerCanvasEl.style) {\n        return;\n      }\n\n      this.lowerCanvasEl.width = this.width;\n      this.lowerCanvasEl.height = this.height;\n\n      this.lowerCanvasEl.style.width = this.width + 'px';\n      this.lowerCanvasEl.style.height = this.height + 'px';\n\n      this.viewportTransform = this.viewportTransform.slice();\n    },\n\n    /**\n     * Creates a bottom canvas\n     * @private\n     * @param {HTMLElement} [canvasEl]\n     */\n    _createLowerCanvas: function (canvasEl) {\n      this.lowerCanvasEl = fabric.util.getById(canvasEl) || this._createCanvasElement();\n      this._initCanvasElement(this.lowerCanvasEl);\n\n      fabric.util.addClass(this.lowerCanvasEl, 'lower-canvas');\n\n      if (this.interactive) {\n        this._applyCanvasStyle(this.lowerCanvasEl);\n      }\n\n      this.contextContainer = this.lowerCanvasEl.getContext('2d');\n    },\n\n    /**\n     * Returns canvas width (in px)\n     * @return {Number}\n     */\n    getWidth: function () {\n      return this.width;\n    },\n\n    /**\n     * Returns canvas height (in px)\n     * @return {Number}\n     */\n    getHeight: function () {\n      return this.height;\n    },\n\n    /**\n     * Sets width of this canvas instance\n     * @param {Number|String} value                         Value to set width to\n     * @param {Object}        [options]                     Options object\n     * @param {Boolean}       [options.backstoreOnly=false] Set the given dimensions only as canvas backstore dimensions\n     * @param {Boolean}       [options.cssOnly=false]       Set the given dimensions only as css dimensions\n     * @return {fabric.Canvas} instance\n     * @chainable true\n     */\n    setWidth: function (value, options) {\n      return this.setDimensions({ width: value }, options);\n    },\n\n    /**\n     * Sets height of this canvas instance\n     * @param {Number|String} value                         Value to set height to\n     * @param {Object}        [options]                     Options object\n     * @param {Boolean}       [options.backstoreOnly=false] Set the given dimensions only as canvas backstore dimensions\n     * @param {Boolean}       [options.cssOnly=false]       Set the given dimensions only as css dimensions\n     * @return {fabric.Canvas} instance\n     * @chainable true\n     */\n    setHeight: function (value, options) {\n      return this.setDimensions({ height: value }, options);\n    },\n\n    /**\n     * Sets dimensions (width, height) of this canvas instance. when options.cssOnly flag active you should also supply the unit of measure (px/%/em)\n     * @param {Object}        dimensions                    Object with width/height properties\n     * @param {Number|String} [dimensions.width]            Width of canvas element\n     * @param {Number|String} [dimensions.height]           Height of canvas element\n     * @param {Object}        [options]                     Options object\n     * @param {Boolean}       [options.backstoreOnly=false] Set the given dimensions only as canvas backstore dimensions\n     * @param {Boolean}       [options.cssOnly=false]       Set the given dimensions only as css dimensions\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    setDimensions: function (dimensions, options) {\n      var cssValue;\n\n      options = options || {};\n\n      for (var prop in dimensions) {\n        cssValue = dimensions[prop];\n\n        if (!options.cssOnly) {\n          this._setBackstoreDimension(prop, dimensions[prop]);\n          cssValue += 'px';\n        }\n\n        if (!options.backstoreOnly) {\n          this._setCssDimension(prop, cssValue);\n        }\n      }\n      this._initRetinaScaling();\n      this._setImageSmoothing();\n      this.calcOffset();\n\n      if (!options.cssOnly) {\n        this.renderAll();\n      }\n\n      return this;\n    },\n\n    /**\n     * Helper for setting width/height\n     * @private\n     * @param {String} prop property (width|height)\n     * @param {Number} value value to set property to\n     * @return {fabric.Canvas} instance\n     * @chainable true\n     */\n    _setBackstoreDimension: function (prop, value) {\n      this.lowerCanvasEl[prop] = value;\n\n      if (this.upperCanvasEl) {\n        this.upperCanvasEl[prop] = value;\n      }\n\n      if (this.cacheCanvasEl) {\n        this.cacheCanvasEl[prop] = value;\n      }\n\n      this[prop] = value;\n\n      return this;\n    },\n\n    /**\n     * Helper for setting css width/height\n     * @private\n     * @param {String} prop property (width|height)\n     * @param {String} value value to set property to\n     * @return {fabric.Canvas} instance\n     * @chainable true\n     */\n    _setCssDimension: function (prop, value) {\n      this.lowerCanvasEl.style[prop] = value;\n\n      if (this.upperCanvasEl) {\n        this.upperCanvasEl.style[prop] = value;\n      }\n\n      if (this.wrapperEl) {\n        this.wrapperEl.style[prop] = value;\n      }\n\n      return this;\n    },\n\n    /**\n     * Returns canvas zoom level\n     * @return {Number}\n     */\n    getZoom: function () {\n      return Math.sqrt(this.viewportTransform[0] * this.viewportTransform[3]);\n    },\n\n    /**\n     * Sets viewport transform of this canvas instance\n     * @param {Array} vpt the transform in the form of context.transform\n     * @return {fabric.Canvas} instance\n     * @chainable true\n     */\n    setViewportTransform: function (vpt) {\n      var activeGroup = this.getActiveGroup();\n      this.viewportTransform = vpt;\n      this.renderAll();\n      for (var i = 0, len = this._objects.length; i < len; i++) {\n        this._objects[i].setCoords();\n      }\n      if (activeGroup) {\n        activeGroup.setCoords();\n      }\n      return this;\n    },\n\n    /**\n     * Sets zoom level of this canvas instance, zoom centered around point\n     * @param {fabric.Point} point to zoom with respect to\n     * @param {Number} value to set zoom to, less than 1 zooms out\n     * @return {fabric.Canvas} instance\n     * @chainable true\n     */\n    zoomToPoint: function (point, value) {\n      // TODO: just change the scale, preserve other transformations\n      var before = point;\n      point = fabric.util.transformPoint(point, fabric.util.invertTransform(this.viewportTransform));\n      this.viewportTransform[0] = value;\n      this.viewportTransform[3] = value;\n      var after = fabric.util.transformPoint(point, this.viewportTransform);\n      this.viewportTransform[4] += before.x - after.x;\n      this.viewportTransform[5] += before.y - after.y;\n      this.renderAll();\n      for (var i = 0, len = this._objects.length; i < len; i++) {\n        this._objects[i].setCoords();\n      }\n      return this;\n    },\n\n    /**\n     * Sets zoom level of this canvas instance\n     * @param {Number} value to set zoom to, less than 1 zooms out\n     * @return {fabric.Canvas} instance\n     * @chainable true\n     */\n    setZoom: function (value) {\n      this.zoomToPoint(new fabric.Point(0, 0), value);\n      return this;\n    },\n\n    /**\n     * Pan viewport so as to place point at top left corner of canvas\n     * @param {fabric.Point} point to move to\n     * @return {fabric.Canvas} instance\n     * @chainable true\n     */\n    absolutePan: function (point) {\n      this.viewportTransform[4] = -point.x;\n      this.viewportTransform[5] = -point.y;\n      this.renderAll();\n      for (var i = 0, len = this._objects.length; i < len; i++) {\n        this._objects[i].setCoords();\n      }\n      return this;\n    },\n\n    /**\n     * Pans viewpoint relatively\n     * @param {fabric.Point} point (position vector) to move by\n     * @return {fabric.Canvas} instance\n     * @chainable true\n     */\n    relativePan: function (point) {\n      return this.absolutePan(new fabric.Point(\n        -point.x - this.viewportTransform[4],\n        -point.y - this.viewportTransform[5]\n      ));\n    },\n\n    /**\n     * Returns &lt;canvas> element corresponding to this instance\n     * @return {HTMLCanvasElement}\n     */\n    getElement: function () {\n      return this.lowerCanvasEl;\n    },\n\n    /**\n     * Returns currently selected object, if any\n     * @return {fabric.Object}\n     */\n    getActiveObject: function() {\n      return null;\n    },\n\n    /**\n     * Returns currently selected group of object, if any\n     * @return {fabric.Group}\n     */\n    getActiveGroup: function() {\n      return null;\n    },\n\n    /**\n     * @private\n     * @param {fabric.Object} obj Object that was added\n     */\n    _onObjectAdded: function(obj) {\n      this.stateful && obj.setupState();\n      obj._set('canvas', this);\n      obj.setCoords();\n      this.fire('object:added', { target: obj });\n      obj.fire('added');\n    },\n\n    /**\n     * @private\n     * @param {fabric.Object} obj Object that was removed\n     */\n    _onObjectRemoved: function(obj) {\n      // removing active object should fire \"selection:cleared\" events\n      if (this.getActiveObject() === obj) {\n        this.fire('before:selection:cleared', { target: obj });\n        this._discardActiveObject();\n        this.fire('selection:cleared');\n      }\n\n      this.fire('object:removed', { target: obj });\n      obj.fire('removed');\n    },\n\n    /**\n     * Clears specified context of canvas element\n     * @param {CanvasRenderingContext2D} ctx Context to clear\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    clearContext: function(ctx) {\n      ctx.clearRect(0, 0, this.width, this.height);\n      return this;\n    },\n\n    /**\n     * Returns context of canvas where objects are drawn\n     * @return {CanvasRenderingContext2D}\n     */\n    getContext: function () {\n      return this.contextContainer;\n    },\n\n    /**\n     * Clears all contexts (background, main, top) of an instance\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    clear: function () {\n      this._objects.length = 0;\n      if (this.discardActiveGroup) {\n        this.discardActiveGroup();\n      }\n      if (this.discardActiveObject) {\n        this.discardActiveObject();\n      }\n      this.clearContext(this.contextContainer);\n      if (this.contextTop) {\n        this.clearContext(this.contextTop);\n      }\n      this.fire('canvas:cleared');\n      this.renderAll();\n      return this;\n    },\n\n    /**\n     * Divides objects in two groups, one to render immediately\n     * and one to render as activeGroup.\n     * return objects to render immediately and pushes the other in the activeGroup.\n     */\n    _chooseObjectsToRender: function() {\n      var activeGroup = this.getActiveGroup(),\n          object, objsToRender = [ ], activeGroupObjects = [ ];\n\n      if (activeGroup && !this.preserveObjectStacking) {\n        for (var i = 0, length = this._objects.length; i < length; i++) {\n          object = this._objects[i];\n          if (!activeGroup.contains(object)) {\n            objsToRender.push(object);\n          }\n          else {\n            activeGroupObjects.push(object);\n          }\n        }\n        activeGroup._set('_objects', activeGroupObjects);\n      }\n      else {\n        objsToRender = this._objects;\n      }\n      return objsToRender;\n    },\n\n    /**\n     * Renders both the top canvas and the secondary container canvas.\n     * @param {Boolean} [allOnTop] Whether we want to force all images to be rendered on the top canvas\n     * @return {fabric.Canvas} instance\n     * @chainable\n     */\n    renderAll: function () {\n      var canvasToDrawOn = this.contextContainer, objsToRender;\n\n      if (this.contextTop && this.selection && !this._groupSelector && !this.isDrawingMode) {\n        this.clearContext(this.contextTop);\n      }\n\n      this.clearContext(canvasToDrawOn);\n\n      this.fire('before:render');\n\n      if (this.clipTo) {\n        fabric.util.clipContext(this, canvasToDrawOn);\n      }\n      this._renderBackground(canvasToDrawOn);\n\n      canvasToDrawOn.save();\n      objsToRender = this._chooseObjectsToRender();\n      //apply viewport transform once for all rendering process\n      canvasToDrawOn.transform.apply(canvasToDrawOn, this.viewportTransform);\n      this._renderObjects(canvasToDrawOn, objsToRender);\n      this.preserveObjectStacking || this._renderObjects(canvasToDrawOn, [this.getActiveGroup()]);\n      canvasToDrawOn.restore();\n\n      if (!this.controlsAboveOverlay && this.interactive) {\n        this.drawControls(canvasToDrawOn);\n      }\n      if (this.clipTo) {\n        canvasToDrawOn.restore();\n      }\n      this._renderOverlay(canvasToDrawOn);\n      if (this.controlsAboveOverlay && this.interactive) {\n        this.drawControls(canvasToDrawOn);\n      }\n\n      this.fire('after:render');\n      return this;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Array} objects to render\n     */\n    _renderObjects: function(ctx, objects) {\n      for (var i = 0, length = objects.length; i < length; ++i) {\n        objects[i] && objects[i].render(ctx);\n      }\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {string} property 'background' or 'overlay'\n     */\n    _renderBackgroundOrOverlay: function(ctx, property) {\n      var object = this[property + 'Color'];\n      if (object) {\n        ctx.fillStyle = object.toLive\n          ? object.toLive(ctx)\n          : object;\n\n        ctx.fillRect(\n          object.offsetX || 0,\n          object.offsetY || 0,\n          this.width,\n          this.height);\n      }\n      object = this[property + 'Image'];\n      if (object) {\n        object.render(ctx);\n      }\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderBackground: function(ctx) {\n      this._renderBackgroundOrOverlay(ctx, 'background');\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderOverlay: function(ctx) {\n      this._renderBackgroundOrOverlay(ctx, 'overlay');\n    },\n\n    /**\n     * Method to render only the top canvas.\n     * Also used to render the group selection box.\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    renderTop: function () {\n      var ctx = this.contextTop || this.contextContainer;\n      this.clearContext(ctx);\n\n      // we render the top context - last object\n      if (this.selection && this._groupSelector) {\n        this._drawSelection();\n      }\n\n      this.fire('after:render');\n\n      return this;\n    },\n\n    /**\n     * Returns coordinates of a center of canvas.\n     * Returned value is an object with top and left properties\n     * @return {Object} object with \"top\" and \"left\" number values\n     */\n    getCenter: function () {\n      return {\n        top: this.getHeight() / 2,\n        left: this.getWidth() / 2\n      };\n    },\n\n    /**\n     * Centers object horizontally.\n     * You might need to call `setCoords` on an object after centering, to update controls area.\n     * @param {fabric.Object} object Object to center horizontally\n     * @return {fabric.Canvas} thisArg\n     */\n    centerObjectH: function (object) {\n      this._centerObject(object, new fabric.Point(this.getCenter().left, object.getCenterPoint().y));\n      this.renderAll();\n      return this;\n    },\n\n    /**\n     * Centers object vertically.\n     * You might need to call `setCoords` on an object after centering, to update controls area.\n     * @param {fabric.Object} object Object to center vertically\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    centerObjectV: function (object) {\n      this._centerObject(object, new fabric.Point(object.getCenterPoint().x, this.getCenter().top));\n      this.renderAll();\n      return this;\n    },\n\n    /**\n     * Centers object vertically and horizontally.\n     * You might need to call `setCoords` on an object after centering, to update controls area.\n     * @param {fabric.Object} object Object to center vertically and horizontally\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    centerObject: function(object) {\n      var center = this.getCenter();\n\n      this._centerObject(object, new fabric.Point(center.left, center.top));\n      this.renderAll();\n      return this;\n    },\n\n    /**\n     * @private\n     * @param {fabric.Object} object Object to center\n     * @param {fabric.Point} center Center point\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    _centerObject: function(object, center) {\n      object.setPositionByOrigin(center, 'center', 'center');\n      return this;\n    },\n\n    /**\n     * Returs dataless JSON representation of canvas\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {String} json string\n     */\n    toDatalessJSON: function (propertiesToInclude) {\n      return this.toDatalessObject(propertiesToInclude);\n    },\n\n    /**\n     * Returns object representation of canvas\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} object representation of an instance\n     */\n    toObject: function (propertiesToInclude) {\n      return this._toObjectMethod('toObject', propertiesToInclude);\n    },\n\n    /**\n     * Returns dataless object representation of canvas\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} object representation of an instance\n     */\n    toDatalessObject: function (propertiesToInclude) {\n      return this._toObjectMethod('toDatalessObject', propertiesToInclude);\n    },\n\n    /**\n     * @private\n     */\n    _toObjectMethod: function (methodName, propertiesToInclude) {\n\n      var data = {\n        objects: this._toObjects(methodName, propertiesToInclude)\n      };\n\n      extend(data, this.__serializeBgOverlay());\n\n      fabric.util.populateWithProperties(this, data, propertiesToInclude);\n\n      return data;\n    },\n\n    /**\n     * @private\n     */\n    _toObjects: function(methodName, propertiesToInclude) {\n      return this.getObjects().map(function(instance) {\n        return this._toObject(instance, methodName, propertiesToInclude);\n      }, this);\n    },\n\n    /**\n     * @private\n     */\n    _toObject: function(instance, methodName, propertiesToInclude) {\n      var originalValue;\n\n      if (!this.includeDefaultValues) {\n        originalValue = instance.includeDefaultValues;\n        instance.includeDefaultValues = false;\n      }\n\n      //If the object is part of the current selection group, it should\n      //be transformed appropriately\n      //i.e. it should be serialised as it would appear if the selection group\n      //were to be destroyed.\n      var originalProperties = this._realizeGroupTransformOnObject(instance),\n          object = instance[methodName](propertiesToInclude);\n      if (!this.includeDefaultValues) {\n        instance.includeDefaultValues = originalValue;\n      }\n\n      //Undo the damage we did by changing all of its properties\n      this._unwindGroupTransformOnObject(instance, originalProperties);\n\n      return object;\n    },\n\n    /**\n     * Realises an object's group transformation on it\n     * @private\n     * @param {fabric.Object} [instance] the object to transform (gets mutated)\n     * @returns the original values of instance which were changed\n     */\n    _realizeGroupTransformOnObject: function(instance) {\n      var layoutProps = ['angle', 'flipX', 'flipY', 'height', 'left', 'scaleX', 'scaleY', 'top', 'width'];\n      if (instance.group && instance.group === this.getActiveGroup()) {\n        //Copy all the positionally relevant properties across now\n        var originalValues = {};\n        layoutProps.forEach(function(prop) {\n          originalValues[prop] = instance[prop];\n        });\n        this.getActiveGroup().realizeTransform(instance);\n        return originalValues;\n      }\n      else {\n        return null;\n      }\n    },\n\n    /**\n     * Restores the changed properties of instance\n     * @private\n     * @param {fabric.Object} [instance] the object to un-transform (gets mutated)\n     * @param {Object} [originalValues] the original values of instance, as returned by _realizeGroupTransformOnObject\n     */\n    _unwindGroupTransformOnObject: function(instance, originalValues) {\n      if (originalValues) {\n        instance.set(originalValues);\n      }\n    },\n\n    /**\n     * @private\n     */\n    __serializeBgOverlay: function() {\n      var data = {\n        background: (this.backgroundColor && this.backgroundColor.toObject)\n          ? this.backgroundColor.toObject()\n          : this.backgroundColor\n      };\n\n      if (this.overlayColor) {\n        data.overlay = this.overlayColor.toObject\n          ? this.overlayColor.toObject()\n          : this.overlayColor;\n      }\n      if (this.backgroundImage) {\n        data.backgroundImage = this.backgroundImage.toObject();\n      }\n      if (this.overlayImage) {\n        data.overlayImage = this.overlayImage.toObject();\n      }\n\n      return data;\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * When true, getSvgTransform() will apply the StaticCanvas.viewportTransform to the SVG transformation. When true,\n     * a zoomed canvas will then produce zoomed SVG output.\n     * @type Boolean\n     * @default\n     */\n    svgViewportTransformation: true,\n\n    /**\n     * Returns SVG representation of canvas\n     * @function\n     * @param {Object} [options] Options object for SVG output\n     * @param {Boolean} [options.suppressPreamble=false] If true xml tag is not included\n     * @param {Object} [options.viewBox] SVG viewbox object\n     * @param {Number} [options.viewBox.x] x-cooridnate of viewbox\n     * @param {Number} [options.viewBox.y] y-coordinate of viewbox\n     * @param {Number} [options.viewBox.width] Width of viewbox\n     * @param {Number} [options.viewBox.height] Height of viewbox\n     * @param {String} [options.encoding=UTF-8] Encoding of SVG output\n     * @param {String} [options.width] desired width of svg with or without units\n     * @param {String} [options.height] desired height of svg with or without units\n     * @param {Function} [reviver] Method for further parsing of svg elements, called after each fabric object converted into svg representation.\n     * @return {String} SVG string\n     * @tutorial {@link http://fabricjs.com/fabric-intro-part-3#serialization}\n     * @see {@link http://jsfiddle.net/fabricjs/jQ3ZZ/|jsFiddle demo}\n     * @example <caption>Normal SVG output</caption>\n     * var svg = canvas.toSVG();\n     * @example <caption>SVG output without preamble (without &lt;?xml ../>)</caption>\n     * var svg = canvas.toSVG({suppressPreamble: true});\n     * @example <caption>SVG output with viewBox attribute</caption>\n     * var svg = canvas.toSVG({\n     *   viewBox: {\n     *     x: 100,\n     *     y: 100,\n     *     width: 200,\n     *     height: 300\n     *   }\n     * });\n     * @example <caption>SVG output with different encoding (default: UTF-8)</caption>\n     * var svg = canvas.toSVG({encoding: 'ISO-8859-1'});\n     * @example <caption>Modify SVG output with reviver function</caption>\n     * var svg = canvas.toSVG(null, function(svg) {\n     *   return svg.replace('stroke-dasharray: ; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; ', '');\n     * });\n     */\n    toSVG: function(options, reviver) {\n      options || (options = { });\n\n      var markup = [];\n\n      this._setSVGPreamble(markup, options);\n      this._setSVGHeader(markup, options);\n\n      this._setSVGBgOverlayColor(markup, 'backgroundColor');\n      this._setSVGBgOverlayImage(markup, 'backgroundImage');\n\n      this._setSVGObjects(markup, reviver);\n\n      this._setSVGBgOverlayColor(markup, 'overlayColor');\n      this._setSVGBgOverlayImage(markup, 'overlayImage');\n\n      markup.push('</svg>');\n\n      return markup.join('');\n    },\n\n    /**\n     * @private\n     */\n    _setSVGPreamble: function(markup, options) {\n      if (options.suppressPreamble) {\n        return;\n      }\n      markup.push(\n        '<?xml version=\"1.0\" encoding=\"', (options.encoding || 'UTF-8'), '\" standalone=\"no\" ?>\\n',\n          '<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" ',\n            '\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\\n'\n      );\n    },\n\n    /**\n     * @private\n     */\n    _setSVGHeader: function(markup, options) {\n      var width = options.width || this.width,\n          height = options.height || this.height,\n          vpt, viewBox = 'viewBox=\"0 0 ' + this.width + ' ' + this.height + '\" ',\n          NUM_FRACTION_DIGITS = fabric.Object.NUM_FRACTION_DIGITS;\n\n      if (options.viewBox) {\n        viewBox = 'viewBox=\"' +\n                options.viewBox.x + ' ' +\n                options.viewBox.y + ' ' +\n                options.viewBox.width + ' ' +\n                options.viewBox.height + '\" ';\n      }\n      else {\n        if (this.svgViewportTransformation) {\n          vpt = this.viewportTransform;\n          viewBox = 'viewBox=\"' +\n                  toFixed(-vpt[4] / vpt[0], NUM_FRACTION_DIGITS) + ' ' +\n                  toFixed(-vpt[5] / vpt[3], NUM_FRACTION_DIGITS) + ' ' +\n                  toFixed(this.width / vpt[0], NUM_FRACTION_DIGITS) + ' ' +\n                  toFixed(this.height / vpt[3], NUM_FRACTION_DIGITS) + '\" ';\n        }\n      }\n\n      markup.push(\n        '<svg ',\n          'xmlns=\"http://www.w3.org/2000/svg\" ',\n          'xmlns:xlink=\"http://www.w3.org/1999/xlink\" ',\n          'version=\"1.1\" ',\n          'width=\"', width, '\" ',\n          'height=\"', height, '\" ',\n          (this.backgroundColor && !this.backgroundColor.toLive\n            ? 'style=\"background-color: ' + this.backgroundColor + '\" '\n            : null),\n          viewBox,\n          'xml:space=\"preserve\">\\n',\n        '<desc>Created with Fabric.js ', fabric.version, '</desc>\\n',\n        '<defs>',\n          fabric.createSVGFontFacesMarkup(this.getObjects()),\n          fabric.createSVGRefElementsMarkup(this),\n        '</defs>\\n'\n      );\n    },\n\n    /**\n     * @private\n     */\n    _setSVGObjects: function(markup, reviver) {\n      for (var i = 0, objects = this.getObjects(), len = objects.length; i < len; i++) {\n        var instance = objects[i],\n            //If the object is in a selection group, simulate what would happen to that\n            //object when the group is deselected\n            originalProperties = this._realizeGroupTransformOnObject(instance);\n        markup.push(instance.toSVG(reviver));\n        this._unwindGroupTransformOnObject(instance, originalProperties);\n      }\n    },\n\n    /**\n     * @private\n     */\n    _setSVGBgOverlayImage: function(markup, property) {\n      if (this[property] && this[property].toSVG) {\n        markup.push(this[property].toSVG());\n      }\n    },\n\n    /**\n     * @private\n     */\n    _setSVGBgOverlayColor: function(markup, property) {\n      if (this[property] && this[property].source) {\n        markup.push(\n          '<rect x=\"', this[property].offsetX, '\" y=\"', this[property].offsetY, '\" ',\n            'width=\"',\n              (this[property].repeat === 'repeat-y' || this[property].repeat === 'no-repeat'\n                ? this[property].source.width\n                : this.width),\n            '\" height=\"',\n              (this[property].repeat === 'repeat-x' || this[property].repeat === 'no-repeat'\n                ? this[property].source.height\n                : this.height),\n            '\" fill=\"url(#' + property + 'Pattern)\"',\n          '></rect>\\n'\n        );\n      }\n      else if (this[property] && property === 'overlayColor') {\n        markup.push(\n          '<rect x=\"0\" y=\"0\" ',\n            'width=\"', this.width,\n            '\" height=\"', this.height,\n            '\" fill=\"', this[property], '\"',\n          '></rect>\\n'\n        );\n      }\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * Moves an object or the objects of a multiple selection\n     * to the bottom of the stack of drawn objects\n     * @param {fabric.Object} object Object to send to back\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    sendToBack: function (object) {\n      if (!object) {\n        return this;\n      }\n      var activeGroup = this.getActiveGroup ? this.getActiveGroup() : null,\n          i, obj, objs;\n      if (object === activeGroup) {\n        objs = activeGroup._objects;\n        for (i = objs.length; i--;) {\n          obj = objs[i];\n          removeFromArray(this._objects, obj);\n          this._objects.unshift(obj);\n        }\n      }\n      else {\n        removeFromArray(this._objects, object);\n        this._objects.unshift(object);\n      }\n      return this.renderAll && this.renderAll();\n    },\n\n    /**\n     * Moves an object or the objects of a multiple selection\n     * to the top of the stack of drawn objects\n     * @param {fabric.Object} object Object to send\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    bringToFront: function (object) {\n      if (!object) {\n        return this;\n      }\n      var activeGroup = this.getActiveGroup ? this.getActiveGroup() : null,\n          i, obj, objs;\n      if (object === activeGroup) {\n        objs = activeGroup._objects;\n        for (i = 0; i < objs.length; i++) {\n          obj = objs[i];\n          removeFromArray(this._objects, obj);\n          this._objects.push(obj);\n        }\n      }\n      else {\n        removeFromArray(this._objects, object);\n        this._objects.push(object);\n      }\n      return this.renderAll && this.renderAll();\n    },\n\n    /**\n     * Moves an object or a selection down in stack of drawn objects\n     * @param {fabric.Object} object Object to send\n     * @param {Boolean} [intersecting] If `true`, send object behind next lower intersecting object\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    sendBackwards: function (object, intersecting) {\n      if (!object) {\n        return this;\n      }\n      var activeGroup = this.getActiveGroup ? this.getActiveGroup() : null,\n          i, obj, idx, newIdx, objs;\n\n      if (object === activeGroup) {\n        objs = activeGroup._objects;\n        for (i = 0; i < objs.length; i++) {\n          obj = objs[i];\n          idx = this._objects.indexOf(obj);\n          if (idx !== 0) {\n            newIdx = idx - 1;\n            removeFromArray(this._objects, obj);\n            this._objects.splice(newIdx, 0, obj);\n          }\n        }\n      }\n      else {\n        idx = this._objects.indexOf(object);\n        if (idx !== 0) {\n          // if object is not on the bottom of stack\n          newIdx = this._findNewLowerIndex(object, idx, intersecting);\n          removeFromArray(this._objects, object);\n          this._objects.splice(newIdx, 0, object);\n        }\n      }\n      this.renderAll && this.renderAll();\n      return this;\n    },\n\n    /**\n     * @private\n     */\n    _findNewLowerIndex: function(object, idx, intersecting) {\n      var newIdx;\n\n      if (intersecting) {\n        newIdx = idx;\n\n        // traverse down the stack looking for the nearest intersecting object\n        for (var i = idx - 1; i >= 0; --i) {\n\n          var isIntersecting = object.intersectsWithObject(this._objects[i]) ||\n                               object.isContainedWithinObject(this._objects[i]) ||\n                               this._objects[i].isContainedWithinObject(object);\n\n          if (isIntersecting) {\n            newIdx = i;\n            break;\n          }\n        }\n      }\n      else {\n        newIdx = idx - 1;\n      }\n\n      return newIdx;\n    },\n\n    /**\n     * Moves an object or a selection up in stack of drawn objects\n     * @param {fabric.Object} object Object to send\n     * @param {Boolean} [intersecting] If `true`, send object in front of next upper intersecting object\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    bringForward: function (object, intersecting) {\n      if (!object) {\n        return this;\n      }\n      var activeGroup = this.getActiveGroup ? this.getActiveGroup() : null,\n          i, obj, idx, newIdx, objs;\n\n      if (object === activeGroup) {\n        objs = activeGroup._objects;\n        for (i = objs.length; i--;) {\n          obj = objs[i];\n          idx = this._objects.indexOf(obj);\n          if (idx !== this._objects.length - 1) {\n            newIdx = idx + 1;\n            removeFromArray(this._objects, obj);\n            this._objects.splice(newIdx, 0, obj);\n          }\n        }\n      }\n      else {\n        idx = this._objects.indexOf(object);\n        if (idx !== this._objects.length - 1) {\n          // if object is not on top of stack (last item in an array)\n          newIdx = this._findNewUpperIndex(object, idx, intersecting);\n          removeFromArray(this._objects, object);\n          this._objects.splice(newIdx, 0, object);\n        }\n      }\n      this.renderAll && this.renderAll();\n      return this;\n    },\n\n    /**\n     * @private\n     */\n    _findNewUpperIndex: function(object, idx, intersecting) {\n      var newIdx;\n\n      if (intersecting) {\n        newIdx = idx;\n\n        // traverse up the stack looking for the nearest intersecting object\n        for (var i = idx + 1; i < this._objects.length; ++i) {\n\n          var isIntersecting = object.intersectsWithObject(this._objects[i]) ||\n                               object.isContainedWithinObject(this._objects[i]) ||\n                               this._objects[i].isContainedWithinObject(object);\n\n          if (isIntersecting) {\n            newIdx = i;\n            break;\n          }\n        }\n      }\n      else {\n        newIdx = idx + 1;\n      }\n\n      return newIdx;\n    },\n\n    /**\n     * Moves an object to specified level in stack of drawn objects\n     * @param {fabric.Object} object Object to send\n     * @param {Number} index Position to move to\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    moveTo: function (object, index) {\n      removeFromArray(this._objects, object);\n      this._objects.splice(index, 0, object);\n      return this.renderAll && this.renderAll();\n    },\n\n    /**\n     * Clears a canvas element and removes all event listeners\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    dispose: function () {\n      this.clear();\n      return this;\n    },\n\n    /**\n     * Returns a string representation of an instance\n     * @return {String} string representation of an instance\n     */\n    toString: function () {\n      return '#<fabric.Canvas (' + this.complexity() + '): ' +\n               '{ objects: ' + this.getObjects().length + ' }>';\n    }\n  });\n\n  extend(fabric.StaticCanvas.prototype, fabric.Observable);\n  extend(fabric.StaticCanvas.prototype, fabric.Collection);\n  extend(fabric.StaticCanvas.prototype, fabric.DataURLExporter);\n\n  extend(fabric.StaticCanvas, /** @lends fabric.StaticCanvas */ {\n\n    /**\n     * @static\n     * @type String\n     * @default\n     */\n    EMPTY_JSON: '{\"objects\": [], \"background\": \"white\"}',\n\n    /**\n     * Provides a way to check support of some of the canvas methods\n     * (either those of HTMLCanvasElement itself, or rendering context)\n     *\n     * @param {String} methodName Method to check support for;\n     *                            Could be one of \"getImageData\", \"toDataURL\", \"toDataURLWithQuality\" or \"setLineDash\"\n     * @return {Boolean | null} `true` if method is supported (or at least exists),\n     *                          `null` if canvas element or context can not be initialized\n     */\n    supports: function (methodName) {\n      var el = fabric.util.createCanvasElement();\n\n      if (!el || !el.getContext) {\n        return null;\n      }\n\n      var ctx = el.getContext('2d');\n      if (!ctx) {\n        return null;\n      }\n\n      switch (methodName) {\n\n        case 'getImageData':\n          return typeof ctx.getImageData !== 'undefined';\n\n        case 'setLineDash':\n          return typeof ctx.setLineDash !== 'undefined';\n\n        case 'toDataURL':\n          return typeof el.toDataURL !== 'undefined';\n\n        case 'toDataURLWithQuality':\n          try {\n            el.toDataURL('image/jpeg', 0);\n            return true;\n          }\n          catch (e) { }\n          return false;\n\n        default:\n          return null;\n      }\n    }\n  });\n\n  /**\n   * Returns JSON representation of canvas\n   * @function\n   * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n   * @return {String} JSON string\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-3#serialization}\n   * @see {@link http://jsfiddle.net/fabricjs/pec86/|jsFiddle demo}\n   * @example <caption>JSON without additional properties</caption>\n   * var json = canvas.toJSON();\n   * @example <caption>JSON with additional properties included</caption>\n   * var json = canvas.toJSON(['lockMovementX', 'lockMovementY', 'lockRotation', 'lockScalingX', 'lockScalingY', 'lockUniScaling']);\n   * @example <caption>JSON without default values</caption>\n   * canvas.includeDefaultValues = false;\n   * var json = canvas.toJSON();\n   */\n  fabric.StaticCanvas.prototype.toJSON = fabric.StaticCanvas.prototype.toObject;\n\n})();\n\n\n/**\n * BaseBrush class\n * @class fabric.BaseBrush\n * @see {@link http://fabricjs.com/freedrawing|Freedrawing demo}\n */\nfabric.BaseBrush = fabric.util.createClass(/** @lends fabric.BaseBrush.prototype */ {\n\n  /**\n   * Color of a brush\n   * @type String\n   * @default\n   */\n  color:            'rgb(0, 0, 0)',\n\n  /**\n   * Width of a brush\n   * @type Number\n   * @default\n   */\n  width:            1,\n\n  /**\n   * Shadow object representing shadow of this shape.\n   * <b>Backwards incompatibility note:</b> This property replaces \"shadowColor\" (String), \"shadowOffsetX\" (Number),\n   * \"shadowOffsetY\" (Number) and \"shadowBlur\" (Number) since v1.2.12\n   * @type fabric.Shadow\n   * @default\n   */\n  shadow:           null,\n\n  /**\n   * Line endings style of a brush (one of \"butt\", \"round\", \"square\")\n   * @type String\n   * @default\n   */\n  strokeLineCap:    'round',\n\n  /**\n   * Corner style of a brush (one of \"bevil\", \"round\", \"miter\")\n   * @type String\n   * @default\n   */\n  strokeLineJoin:   'round',\n\n  /**\n   * Stroke Dash Array.\n   * @type Array\n   * @default\n   */\n  strokeDashArray:  null,\n\n  /**\n   * Sets shadow of an object\n   * @param {Object|String} [options] Options object or string (e.g. \"2px 2px 10px rgba(0,0,0,0.2)\")\n   * @return {fabric.Object} thisArg\n   * @chainable\n   */\n  setShadow: function(options) {\n    this.shadow = new fabric.Shadow(options);\n    return this;\n  },\n\n  /**\n   * Sets brush styles\n   * @private\n   */\n  _setBrushStyles: function() {\n    var ctx = this.canvas.contextTop;\n\n    ctx.strokeStyle = this.color;\n    ctx.lineWidth = this.width;\n    ctx.lineCap = this.strokeLineCap;\n    ctx.lineJoin = this.strokeLineJoin;\n    if (this.strokeDashArray && fabric.StaticCanvas.supports('setLineDash')) {\n      ctx.setLineDash(this.strokeDashArray);\n    }\n  },\n\n  /**\n   * Sets brush shadow styles\n   * @private\n   */\n  _setShadow: function() {\n    if (!this.shadow) {\n      return;\n    }\n\n    var ctx = this.canvas.contextTop;\n\n    ctx.shadowColor = this.shadow.color;\n    ctx.shadowBlur = this.shadow.blur;\n    ctx.shadowOffsetX = this.shadow.offsetX;\n    ctx.shadowOffsetY = this.shadow.offsetY;\n  },\n\n  /**\n   * Removes brush shadow styles\n   * @private\n   */\n  _resetShadow: function() {\n    var ctx = this.canvas.contextTop;\n\n    ctx.shadowColor = '';\n    ctx.shadowBlur = ctx.shadowOffsetX = ctx.shadowOffsetY = 0;\n  }\n});\n\n\n(function() {\n\n  /**\n   * PencilBrush class\n   * @class fabric.PencilBrush\n   * @extends fabric.BaseBrush\n   */\n  fabric.PencilBrush = fabric.util.createClass(fabric.BaseBrush, /** @lends fabric.PencilBrush.prototype */ {\n\n    /**\n     * Constructor\n     * @param {fabric.Canvas} canvas\n     * @return {fabric.PencilBrush} Instance of a pencil brush\n     */\n    initialize: function(canvas) {\n      this.canvas = canvas;\n      this._points = [ ];\n    },\n\n    /**\n     * Inovoked on mouse down\n     * @param {Object} pointer\n     */\n    onMouseDown: function(pointer) {\n      this._prepareForDrawing(pointer);\n      // capture coordinates immediately\n      // this allows to draw dots (when movement never occurs)\n      this._captureDrawingPath(pointer);\n      this._render();\n    },\n\n    /**\n     * Inovoked on mouse move\n     * @param {Object} pointer\n     */\n    onMouseMove: function(pointer) {\n      this._captureDrawingPath(pointer);\n      // redraw curve\n      // clear top canvas\n      this.canvas.clearContext(this.canvas.contextTop);\n      this._render();\n    },\n\n    /**\n     * Invoked on mouse up\n     */\n    onMouseUp: function() {\n      this._finalizeAndAddPath();\n    },\n\n    /**\n     * @private\n     * @param {Object} pointer Actual mouse position related to the canvas.\n     */\n    _prepareForDrawing: function(pointer) {\n\n      var p = new fabric.Point(pointer.x, pointer.y);\n\n      this._reset();\n      this._addPoint(p);\n\n      this.canvas.contextTop.moveTo(p.x, p.y);\n    },\n\n    /**\n     * @private\n     * @param {fabric.Point} point Point to be added to points array\n     */\n    _addPoint: function(point) {\n      this._points.push(point);\n    },\n\n    /**\n     * Clear points array and set contextTop canvas style.\n     * @private\n     */\n    _reset: function() {\n      this._points.length = 0;\n\n      this._setBrushStyles();\n      this._setShadow();\n    },\n\n    /**\n     * @private\n     * @param {Object} pointer Actual mouse position related to the canvas.\n     */\n    _captureDrawingPath: function(pointer) {\n      var pointerPoint = new fabric.Point(pointer.x, pointer.y);\n      this._addPoint(pointerPoint);\n    },\n\n    /**\n     * Draw a smooth path on the topCanvas using quadraticCurveTo\n     * @private\n     */\n    _render: function() {\n      var ctx  = this.canvas.contextTop,\n          v = this.canvas.viewportTransform,\n          p1 = this._points[0],\n          p2 = this._points[1];\n\n      ctx.save();\n      ctx.transform(v[0], v[1], v[2], v[3], v[4], v[5]);\n      ctx.beginPath();\n\n      //if we only have 2 points in the path and they are the same\n      //it means that the user only clicked the canvas without moving the mouse\n      //then we should be drawing a dot. A path isn't drawn between two identical dots\n      //that's why we set them apart a bit\n      if (this._points.length === 2 && p1.x === p2.x && p1.y === p2.y) {\n        p1.x -= 0.5;\n        p2.x += 0.5;\n      }\n      ctx.moveTo(p1.x, p1.y);\n\n      for (var i = 1, len = this._points.length; i < len; i++) {\n        // we pick the point between pi + 1 & pi + 2 as the\n        // end point and p1 as our control point.\n        var midPoint = p1.midPointFrom(p2);\n        ctx.quadraticCurveTo(p1.x, p1.y, midPoint.x, midPoint.y);\n\n        p1 = this._points[i];\n        p2 = this._points[i + 1];\n      }\n      // Draw last line as a straight line while\n      // we wait for the next point to be able to calculate\n      // the bezier control point\n      ctx.lineTo(p1.x, p1.y);\n      ctx.stroke();\n      ctx.restore();\n    },\n\n    /**\n     * Converts points to SVG path\n     * @param {Array} points Array of points\n     * @param {Number} minX\n     * @param {Number} minY\n     * @return {String} SVG path\n     */\n    convertPointsToSVGPath: function(points) {\n      var path = [],\n          p1 = new fabric.Point(points[0].x, points[0].y),\n          p2 = new fabric.Point(points[1].x, points[1].y);\n\n      path.push('M ', points[0].x, ' ', points[0].y, ' ');\n      for (var i = 1, len = points.length; i < len; i++) {\n        var midPoint = p1.midPointFrom(p2);\n        // p1 is our bezier control point\n        // midpoint is our endpoint\n        // start point is p(i-1) value.\n        path.push('Q ', p1.x, ' ', p1.y, ' ', midPoint.x, ' ', midPoint.y, ' ');\n        p1 = new fabric.Point(points[i].x, points[i].y);\n        if ((i + 1) < points.length) {\n          p2 = new fabric.Point(points[i + 1].x, points[i + 1].y);\n        }\n      }\n      path.push('L ', p1.x, ' ', p1.y, ' ');\n      return path;\n    },\n\n    /**\n     * Creates fabric.Path object to add on canvas\n     * @param {String} pathData Path data\n     * @return {fabric.Path} Path to add on canvas\n     */\n    createPath: function(pathData) {\n      var path = new fabric.Path(pathData, {\n                   fill: null,\n                   stroke: this.color,\n                   strokeWidth: this.width,\n                   strokeLineCap: this.strokeLineCap,\n                   strokeLineJoin: this.strokeLineJoin,\n                   strokeDashArray: this.strokeDashArray,\n                   originX: 'center',\n                   originY: 'center'\n                 });\n\n      if (this.shadow) {\n        this.shadow.affectStroke = true;\n        path.setShadow(this.shadow);\n      }\n\n      return path;\n    },\n\n    /**\n     * On mouseup after drawing the path on contextTop canvas\n     * we use the points captured to create an new fabric path object\n     * and add it to the fabric canvas.\n     */\n    _finalizeAndAddPath: function() {\n      var ctx = this.canvas.contextTop;\n      ctx.closePath();\n\n      var pathData = this.convertPointsToSVGPath(this._points).join('');\n      if (pathData === 'M 0 0 Q 0 0 0 0 L 0 0') {\n        // do not create 0 width/height paths, as they are\n        // rendered inconsistently across browsers\n        // Firefox 4, for example, renders a dot,\n        // whereas Chrome 10 renders nothing\n        this.canvas.renderAll();\n        return;\n      }\n\n      var path = this.createPath(pathData);\n\n      this.canvas.add(path);\n      path.setCoords();\n\n      this.canvas.clearContext(this.canvas.contextTop);\n      this._resetShadow();\n      this.canvas.renderAll();\n\n      // fire event 'path' created\n      this.canvas.fire('path:created', { path: path });\n    }\n  });\n})();\n\n\n/**\n * CircleBrush class\n * @class fabric.CircleBrush\n */\nfabric.CircleBrush = fabric.util.createClass(fabric.BaseBrush, /** @lends fabric.CircleBrush.prototype */ {\n\n  /**\n   * Width of a brush\n   * @type Number\n   * @default\n   */\n  width: 10,\n\n  /**\n   * Constructor\n   * @param {fabric.Canvas} canvas\n   * @return {fabric.CircleBrush} Instance of a circle brush\n   */\n  initialize: function(canvas) {\n    this.canvas = canvas;\n    this.points = [ ];\n  },\n\n  /**\n   * Invoked inside on mouse down and mouse move\n   * @param {Object} pointer\n   */\n  drawDot: function(pointer) {\n    var point = this.addPoint(pointer),\n        ctx = this.canvas.contextTop,\n        v = this.canvas.viewportTransform;\n    ctx.save();\n    ctx.transform(v[0], v[1], v[2], v[3], v[4], v[5]);\n\n    ctx.fillStyle = point.fill;\n    ctx.beginPath();\n    ctx.arc(point.x, point.y, point.radius, 0, Math.PI * 2, false);\n    ctx.closePath();\n    ctx.fill();\n\n    ctx.restore();\n  },\n\n  /**\n   * Invoked on mouse down\n   */\n  onMouseDown: function(pointer) {\n    this.points.length = 0;\n    this.canvas.clearContext(this.canvas.contextTop);\n    this._setShadow();\n    this.drawDot(pointer);\n  },\n\n  /**\n   * Invoked on mouse move\n   * @param {Object} pointer\n   */\n  onMouseMove: function(pointer) {\n    this.drawDot(pointer);\n  },\n\n  /**\n   * Invoked on mouse up\n   */\n  onMouseUp: function() {\n    var originalRenderOnAddRemove = this.canvas.renderOnAddRemove;\n    this.canvas.renderOnAddRemove = false;\n\n    var circles = [ ];\n\n    for (var i = 0, len = this.points.length; i < len; i++) {\n      var point = this.points[i],\n          circle = new fabric.Circle({\n            radius: point.radius,\n            left: point.x,\n            top: point.y,\n            originX: 'center',\n            originY: 'center',\n            fill: point.fill\n          });\n\n      this.shadow && circle.setShadow(this.shadow);\n\n      circles.push(circle);\n    }\n    var group = new fabric.Group(circles, { originX: 'center', originY: 'center' });\n    group.canvas = this.canvas;\n\n    this.canvas.add(group);\n    this.canvas.fire('path:created', { path: group });\n\n    this.canvas.clearContext(this.canvas.contextTop);\n    this._resetShadow();\n    this.canvas.renderOnAddRemove = originalRenderOnAddRemove;\n    this.canvas.renderAll();\n  },\n\n  /**\n   * @param {Object} pointer\n   * @return {fabric.Point} Just added pointer point\n   */\n  addPoint: function(pointer) {\n    var pointerPoint = new fabric.Point(pointer.x, pointer.y),\n\n        circleRadius = fabric.util.getRandomInt(\n                        Math.max(0, this.width - 20), this.width + 20) / 2,\n\n        circleColor = new fabric.Color(this.color)\n                        .setAlpha(fabric.util.getRandomInt(0, 100) / 100)\n                        .toRgba();\n\n    pointerPoint.radius = circleRadius;\n    pointerPoint.fill = circleColor;\n\n    this.points.push(pointerPoint);\n\n    return pointerPoint;\n  }\n});\n\n\n/**\n * SprayBrush class\n * @class fabric.SprayBrush\n */\nfabric.SprayBrush = fabric.util.createClass( fabric.BaseBrush, /** @lends fabric.SprayBrush.prototype */ {\n\n  /**\n   * Width of a spray\n   * @type Number\n   * @default\n   */\n  width:              10,\n\n  /**\n   * Density of a spray (number of dots per chunk)\n   * @type Number\n   * @default\n   */\n  density:            20,\n\n  /**\n   * Width of spray dots\n   * @type Number\n   * @default\n   */\n  dotWidth:           1,\n\n  /**\n   * Width variance of spray dots\n   * @type Number\n   * @default\n   */\n  dotWidthVariance:   1,\n\n  /**\n   * Whether opacity of a dot should be random\n   * @type Boolean\n   * @default\n   */\n  randomOpacity:        false,\n\n  /**\n   * Whether overlapping dots (rectangles) should be removed (for performance reasons)\n   * @type Boolean\n   * @default\n   */\n  optimizeOverlapping:  true,\n\n  /**\n   * Constructor\n   * @param {fabric.Canvas} canvas\n   * @return {fabric.SprayBrush} Instance of a spray brush\n   */\n  initialize: function(canvas) {\n    this.canvas = canvas;\n    this.sprayChunks = [ ];\n  },\n\n  /**\n   * Invoked on mouse down\n   * @param {Object} pointer\n   */\n  onMouseDown: function(pointer) {\n    this.sprayChunks.length = 0;\n    this.canvas.clearContext(this.canvas.contextTop);\n    this._setShadow();\n\n    this.addSprayChunk(pointer);\n    this.render();\n  },\n\n  /**\n   * Invoked on mouse move\n   * @param {Object} pointer\n   */\n  onMouseMove: function(pointer) {\n    this.addSprayChunk(pointer);\n    this.render();\n  },\n\n  /**\n   * Invoked on mouse up\n   */\n  onMouseUp: function() {\n    var originalRenderOnAddRemove = this.canvas.renderOnAddRemove;\n    this.canvas.renderOnAddRemove = false;\n\n    var rects = [ ];\n\n    for (var i = 0, ilen = this.sprayChunks.length; i < ilen; i++) {\n      var sprayChunk = this.sprayChunks[i];\n\n      for (var j = 0, jlen = sprayChunk.length; j < jlen; j++) {\n\n        var rect = new fabric.Rect({\n          width: sprayChunk[j].width,\n          height: sprayChunk[j].width,\n          left: sprayChunk[j].x + 1,\n          top: sprayChunk[j].y + 1,\n          originX: 'center',\n          originY: 'center',\n          fill: this.color\n        });\n\n        this.shadow && rect.setShadow(this.shadow);\n        rects.push(rect);\n      }\n    }\n\n    if (this.optimizeOverlapping) {\n      rects = this._getOptimizedRects(rects);\n    }\n\n    var group = new fabric.Group(rects, { originX: 'center', originY: 'center' });\n    group.canvas = this.canvas;\n\n    this.canvas.add(group);\n    this.canvas.fire('path:created', { path: group });\n\n    this.canvas.clearContext(this.canvas.contextTop);\n    this._resetShadow();\n    this.canvas.renderOnAddRemove = originalRenderOnAddRemove;\n    this.canvas.renderAll();\n  },\n\n  /**\n   * @private\n   * @param {Array} rects\n   */\n  _getOptimizedRects: function(rects) {\n\n    // avoid creating duplicate rects at the same coordinates\n    var uniqueRects = { }, key;\n\n    for (var i = 0, len = rects.length; i < len; i++) {\n      key = rects[i].left + '' + rects[i].top;\n      if (!uniqueRects[key]) {\n        uniqueRects[key] = rects[i];\n      }\n    }\n    var uniqueRectsArray = [ ];\n    for (key in uniqueRects) {\n      uniqueRectsArray.push(uniqueRects[key]);\n    }\n\n    return uniqueRectsArray;\n  },\n\n  /**\n   * Renders brush\n   */\n  render: function() {\n    var ctx = this.canvas.contextTop;\n    ctx.fillStyle = this.color;\n\n    var v = this.canvas.viewportTransform;\n    ctx.save();\n    ctx.transform(v[0], v[1], v[2], v[3], v[4], v[5]);\n\n    for (var i = 0, len = this.sprayChunkPoints.length; i < len; i++) {\n      var point = this.sprayChunkPoints[i];\n      if (typeof point.opacity !== 'undefined') {\n        ctx.globalAlpha = point.opacity;\n      }\n      ctx.fillRect(point.x, point.y, point.width, point.width);\n    }\n    ctx.restore();\n  },\n\n  /**\n   * @param {Object} pointer\n   */\n  addSprayChunk: function(pointer) {\n    this.sprayChunkPoints = [ ];\n\n    var x, y, width, radius = this.width / 2;\n\n    for (var i = 0; i < this.density; i++) {\n\n      x = fabric.util.getRandomInt(pointer.x - radius, pointer.x + radius);\n      y = fabric.util.getRandomInt(pointer.y - radius, pointer.y + radius);\n\n      if (this.dotWidthVariance) {\n        width = fabric.util.getRandomInt(\n          // bottom clamp width to 1\n          Math.max(1, this.dotWidth - this.dotWidthVariance),\n          this.dotWidth + this.dotWidthVariance);\n      }\n      else {\n        width = this.dotWidth;\n      }\n\n      var point = new fabric.Point(x, y);\n      point.width = width;\n\n      if (this.randomOpacity) {\n        point.opacity = fabric.util.getRandomInt(0, 100) / 100;\n      }\n\n      this.sprayChunkPoints.push(point);\n    }\n\n    this.sprayChunks.push(this.sprayChunkPoints);\n  }\n});\n\n\n/**\n * PatternBrush class\n * @class fabric.PatternBrush\n * @extends fabric.BaseBrush\n */\nfabric.PatternBrush = fabric.util.createClass(fabric.PencilBrush, /** @lends fabric.PatternBrush.prototype */ {\n\n  getPatternSrc: function() {\n\n    var dotWidth = 20,\n        dotDistance = 5,\n        patternCanvas = fabric.document.createElement('canvas'),\n        patternCtx = patternCanvas.getContext('2d');\n\n    patternCanvas.width = patternCanvas.height = dotWidth + dotDistance;\n\n    patternCtx.fillStyle = this.color;\n    patternCtx.beginPath();\n    patternCtx.arc(dotWidth / 2, dotWidth / 2, dotWidth / 2, 0, Math.PI * 2, false);\n    patternCtx.closePath();\n    patternCtx.fill();\n\n    return patternCanvas;\n  },\n\n  getPatternSrcFunction: function() {\n    return String(this.getPatternSrc).replace('this.color', '\"' + this.color + '\"');\n  },\n\n  /**\n   * Creates \"pattern\" instance property\n   */\n  getPattern: function() {\n    return this.canvas.contextTop.createPattern(this.source || this.getPatternSrc(), 'repeat');\n  },\n\n  /**\n   * Sets brush styles\n   */\n  _setBrushStyles: function() {\n    this.callSuper('_setBrushStyles');\n    this.canvas.contextTop.strokeStyle = this.getPattern();\n  },\n\n  /**\n   * Creates path\n   */\n  createPath: function(pathData) {\n    var path = this.callSuper('createPath', pathData);\n    path.stroke = new fabric.Pattern({\n      source: this.source || this.getPatternSrcFunction()\n    });\n    return path;\n  }\n});\n\n\n(function() {\n\n  var getPointer = fabric.util.getPointer,\n      degreesToRadians = fabric.util.degreesToRadians,\n      radiansToDegrees = fabric.util.radiansToDegrees,\n      atan2 = Math.atan2,\n      abs = Math.abs,\n\n      STROKE_OFFSET = 0.5;\n\n  /**\n   * Canvas class\n   * @class fabric.Canvas\n   * @extends fabric.StaticCanvas\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-1#canvas}\n   * @see {@link fabric.Canvas#initialize} for constructor definition\n   *\n   * @fires object:modified\n   * @fires object:rotating\n   * @fires object:scaling\n   * @fires object:moving\n   * @fires object:selected\n   *\n   * @fires before:selection:cleared\n   * @fires selection:cleared\n   * @fires selection:created\n   *\n   * @fires path:created\n   * @fires mouse:down\n   * @fires mouse:move\n   * @fires mouse:up\n   * @fires mouse:over\n   * @fires mouse:out\n   *\n   */\n  fabric.Canvas = fabric.util.createClass(fabric.StaticCanvas, /** @lends fabric.Canvas.prototype */ {\n\n    /**\n     * Constructor\n     * @param {HTMLElement | String} el &lt;canvas> element to initialize instance on\n     * @param {Object} [options] Options object\n     * @return {Object} thisArg\n     */\n    initialize: function(el, options) {\n      options || (options = { });\n\n      this._initStatic(el, options);\n      this._initInteractive();\n      this._createCacheCanvas();\n    },\n\n    /**\n     * When true, objects can be transformed by one side (unproportionally)\n     * @type Boolean\n     * @default\n     */\n    uniScaleTransform:      false,\n\n    /**\n     * Indicates which key enable unproportional scaling\n     * values: altKey, shiftKey, ctrlKey\n     * @since 1.6.2\n     * @type String\n     * @default\n     */\n    uniScaleKey:           'shiftKey',\n\n    /**\n     * When true, objects use center point as the origin of scale transformation.\n     * <b>Backwards incompatibility note:</b> This property replaces \"centerTransform\" (Boolean).\n     * @since 1.3.4\n     * @type Boolean\n     * @default\n     */\n    centeredScaling:        false,\n\n    /**\n     * When true, objects use center point as the origin of rotate transformation.\n     * <b>Backwards incompatibility note:</b> This property replaces \"centerTransform\" (Boolean).\n     * @since 1.3.4\n     * @type Boolean\n     * @default\n     */\n    centeredRotation:       false,\n\n    /**\n     * Indicates which key enable centered Transfrom\n     * values: altKey, shiftKey, ctrlKey\n     * @since 1.6.2\n     * @type String\n     * @default\n     */\n    centeredKey:           'altKey',\n\n    /**\n     * Indicates which key enable alternate action on corner\n     * values: altKey, shiftKey, ctrlKey\n     * @since 1.6.2\n     * @type String\n     * @default\n     */\n    altActionKey:           'shiftKey',\n\n    /**\n     * Indicates that canvas is interactive. This property should not be changed.\n     * @type Boolean\n     * @default\n     */\n    interactive:            true,\n\n    /**\n     * Indicates whether group selection should be enabled\n     * @type Boolean\n     * @default\n     */\n    selection:              true,\n\n    /**\n     * Indicates which key enable multiple click selection\n     * values: altKey, shiftKey, ctrlKey\n     * @since 1.6.2\n     * @type String\n     * @default\n     */\n    selectionKey:           'shiftKey',\n\n    /**\n     * Color of selection\n     * @type String\n     * @default\n     */\n    selectionColor:         'rgba(100, 100, 255, 0.3)', // blue\n\n    /**\n     * Default dash array pattern\n     * If not empty the selection border is dashed\n     * @type Array\n     */\n    selectionDashArray:     [ ],\n\n    /**\n     * Color of the border of selection (usually slightly darker than color of selection itself)\n     * @type String\n     * @default\n     */\n    selectionBorderColor:   'rgba(255, 255, 255, 0.3)',\n\n    /**\n     * Width of a line used in object/group selection\n     * @type Number\n     * @default\n     */\n    selectionLineWidth:     1,\n\n    /**\n     * Default cursor value used when hovering over an object on canvas\n     * @type String\n     * @default\n     */\n    hoverCursor:            'move',\n\n    /**\n     * Default cursor value used when moving an object on canvas\n     * @type String\n     * @default\n     */\n    moveCursor:             'move',\n\n    /**\n     * Default cursor value used for the entire canvas\n     * @type String\n     * @default\n     */\n    defaultCursor:          'default',\n\n    /**\n     * Cursor value used during free drawing\n     * @type String\n     * @default\n     */\n    freeDrawingCursor:      'crosshair',\n\n    /**\n     * Cursor value used for rotation point\n     * @type String\n     * @default\n     */\n    rotationCursor:         'crosshair',\n\n    /**\n     * Default element class that's given to wrapper (div) element of canvas\n     * @type String\n     * @default\n     */\n    containerClass:         'canvas-container',\n\n    /**\n     * When true, object detection happens on per-pixel basis rather than on per-bounding-box\n     * @type Boolean\n     * @default\n     */\n    perPixelTargetFind:     false,\n\n    /**\n     * Number of pixels around target pixel to tolerate (consider active) during object detection\n     * @type Number\n     * @default\n     */\n    targetFindTolerance:    0,\n\n    /**\n     * When true, target detection is skipped when hovering over canvas. This can be used to improve performance.\n     * @type Boolean\n     * @default\n     */\n    skipTargetFind:         false,\n\n    /**\n     * When true, mouse events on canvas (mousedown/mousemove/mouseup) result in free drawing.\n     * After mousedown, mousemove creates a shape,\n     * and then mouseup finalizes it and adds an instance of `fabric.Path` onto canvas.\n     * @tutorial {@link http://fabricjs.com/fabric-intro-part-4#free_drawing}\n     * @type Boolean\n     * @default\n     */\n    isDrawingMode:          false,\n\n    /**\n     * @private\n     */\n    _initInteractive: function() {\n      this._currentTransform = null;\n      this._groupSelector = null;\n      this._initWrapperElement();\n      this._createUpperCanvas();\n      this._initEventListeners();\n\n      this._initRetinaScaling();\n\n      this.freeDrawingBrush = fabric.PencilBrush && new fabric.PencilBrush(this);\n\n      this.calcOffset();\n    },\n\n    /**\n     * Resets the current transform to its original values and chooses the type of resizing based on the event\n     * @private\n     * @param {Event} e Event object fired on mousemove\n     */\n    _resetCurrentTransform: function() {\n      var t = this._currentTransform;\n\n      t.target.set({\n        scaleX: t.original.scaleX,\n        scaleY: t.original.scaleY,\n        skewX: t.original.skewX,\n        skewY: t.original.skewY,\n        left: t.original.left,\n        top: t.original.top\n      });\n\n      if (this._shouldCenterTransform(t.target)) {\n        if (t.action === 'rotate') {\n          this._setOriginToCenter(t.target);\n        }\n        else {\n          if (t.originX !== 'center') {\n            if (t.originX === 'right') {\n              t.mouseXSign = -1;\n            }\n            else {\n              t.mouseXSign = 1;\n            }\n          }\n          if (t.originY !== 'center') {\n            if (t.originY === 'bottom') {\n              t.mouseYSign = -1;\n            }\n            else {\n              t.mouseYSign = 1;\n            }\n          }\n\n          t.originX = 'center';\n          t.originY = 'center';\n        }\n      }\n      else {\n        t.originX = t.original.originX;\n        t.originY = t.original.originY;\n      }\n    },\n\n    /**\n     * Checks if point is contained within an area of given object\n     * @param {Event} e Event object\n     * @param {fabric.Object} target Object to test against\n     * @return {Boolean} true if point is contained within an area of given object\n     */\n    containsPoint: function (e, target) {\n      var pointer = this.getPointer(e, true),\n          xy = this._normalizePointer(target, pointer);\n\n      // http://www.geog.ubc.ca/courses/klink/gis.notes/ncgia/u32.html\n      // http://idav.ucdavis.edu/~okreylos/TAship/Spring2000/PointInPolygon.html\n      return (target.containsPoint(xy) || target._findTargetCorner(pointer));\n    },\n\n    /**\n     * @private\n     */\n    _normalizePointer: function (object, pointer) {\n      var activeGroup = this.getActiveGroup(),\n          isObjectInGroup = (\n            activeGroup &&\n            object.type !== 'group' &&\n            activeGroup.contains(object)),\n          lt, m;\n\n      if (isObjectInGroup) {\n        m = fabric.util.multiplyTransformMatrices(\n              this.viewportTransform,\n              activeGroup.calcTransformMatrix());\n\n        m = fabric.util.invertTransform(m);\n        pointer = fabric.util.transformPoint(pointer, m , false);\n        lt = fabric.util.transformPoint(activeGroup.getCenterPoint(), m , false);\n        pointer.x -= lt.x;\n        pointer.y -= lt.y;\n      }\n      return { x: pointer.x, y: pointer.y };\n    },\n\n    /**\n     * Returns true if object is transparent at a certain location\n     * @param {fabric.Object} target Object to check\n     * @param {Number} x Left coordinate\n     * @param {Number} y Top coordinate\n     * @return {Boolean}\n     */\n    isTargetTransparent: function (target, x, y) {\n      var hasBorders = target.hasBorders,\n          transparentCorners = target.transparentCorners,\n          ctx = this.contextCache,\n          shouldTransform = target.group && target.group === this.getActiveGroup();\n\n      target.hasBorders = target.transparentCorners = false;\n\n      if (shouldTransform) {\n        ctx.save();\n        ctx.transform.apply(ctx, target.group.calcTransformMatrix());\n      }\n      target.render(ctx);\n      target.active && target._renderControls(ctx);\n\n      target.hasBorders = hasBorders;\n      target.transparentCorners = transparentCorners;\n\n      var isTransparent = fabric.util.isTransparent(\n        ctx, x, y, this.targetFindTolerance);\n      shouldTransform && ctx.restore();\n\n      this.clearContext(ctx);\n\n      return isTransparent;\n    },\n\n    /**\n     * @private\n     * @param {Event} e Event object\n     * @param {fabric.Object} target\n     */\n    _shouldClearSelection: function (e, target) {\n      var activeGroup = this.getActiveGroup(),\n          activeObject = this.getActiveObject();\n\n      return (\n        !target\n        ||\n        (target &&\n          activeGroup &&\n          !activeGroup.contains(target) &&\n          activeGroup !== target &&\n          !e[this.selectionKey])\n        ||\n        (target && !target.evented)\n        ||\n        (target &&\n          !target.selectable &&\n          activeObject &&\n          activeObject !== target)\n      );\n    },\n\n    /**\n     * @private\n     * @param {fabric.Object} target\n     */\n    _shouldCenterTransform: function (target) {\n      if (!target) {\n        return;\n      }\n\n      var t = this._currentTransform,\n          centerTransform;\n\n      if (t.action === 'scale' || t.action === 'scaleX' || t.action === 'scaleY') {\n        centerTransform = this.centeredScaling || target.centeredScaling;\n      }\n      else if (t.action === 'rotate') {\n        centerTransform = this.centeredRotation || target.centeredRotation;\n      }\n\n      return centerTransform ? !t.altKey : t.altKey;\n    },\n\n    /**\n     * @private\n     */\n    _getOriginFromCorner: function(target, corner) {\n      var origin = {\n        x: target.originX,\n        y: target.originY\n      };\n\n      if (corner === 'ml' || corner === 'tl' || corner === 'bl') {\n        origin.x = 'right';\n      }\n      else if (corner === 'mr' || corner === 'tr' || corner === 'br') {\n        origin.x = 'left';\n      }\n\n      if (corner === 'tl' || corner === 'mt' || corner === 'tr') {\n        origin.y = 'bottom';\n      }\n      else if (corner === 'bl' || corner === 'mb' || corner === 'br') {\n        origin.y = 'top';\n      }\n\n      return origin;\n    },\n\n    /**\n     * @private\n     */\n    _getActionFromCorner: function(target, corner, e) {\n      if (!corner) {\n        return 'drag';\n      }\n\n      switch (corner) {\n        case 'mtr':\n          return 'rotate';\n        case 'ml':\n        case 'mr':\n          return e[this.altActionKey] ? 'skewY' : 'scaleX';\n        case 'mt':\n        case 'mb':\n          return e[this.altActionKey] ? 'skewX' : 'scaleY';\n        default:\n          return 'scale';\n      }\n    },\n\n    /**\n     * @private\n     * @param {Event} e Event object\n     * @param {fabric.Object} target\n     */\n    _setupCurrentTransform: function (e, target) {\n      if (!target) {\n        return;\n      }\n\n      var pointer = this.getPointer(e),\n          corner = target._findTargetCorner(this.getPointer(e, true)),\n          action = this._getActionFromCorner(target, corner, e),\n          origin = this._getOriginFromCorner(target, corner);\n\n      this._currentTransform = {\n        target: target,\n        action: action,\n        corner: corner,\n        scaleX: target.scaleX,\n        scaleY: target.scaleY,\n        skewX: target.skewX,\n        skewY: target.skewY,\n        offsetX: pointer.x - target.left,\n        offsetY: pointer.y - target.top,\n        originX: origin.x,\n        originY: origin.y,\n        ex: pointer.x,\n        ey: pointer.y,\n        lastX: pointer.x,\n        lastY: pointer.y,\n        left: target.left,\n        top: target.top,\n        theta: degreesToRadians(target.angle),\n        width: target.width * target.scaleX,\n        mouseXSign: 1,\n        mouseYSign: 1,\n        shiftKey: e.shiftKey,\n        altKey: e[this.centeredKey]\n      };\n\n      this._currentTransform.original = {\n        left: target.left,\n        top: target.top,\n        scaleX: target.scaleX,\n        scaleY: target.scaleY,\n        skewX: target.skewX,\n        skewY: target.skewY,\n        originX: origin.x,\n        originY: origin.y\n      };\n\n      this._resetCurrentTransform();\n    },\n\n    /**\n     * Translates object by \"setting\" its left/top\n     * @private\n     * @param {Number} x pointer's x coordinate\n     * @param {Number} y pointer's y coordinate\n     * @return {Boolean} true if the translation occurred\n     */\n    _translateObject: function (x, y) {\n      var transform = this._currentTransform,\n          target = transform.target,\n          newLeft = x - transform.offsetX,\n          newTop = y - transform.offsetY,\n          moveX = !target.get('lockMovementX') && target.left !== newLeft,\n          moveY = !target.get('lockMovementY') && target.top !== newTop;\n\n      moveX && target.set('left', newLeft);\n      moveY && target.set('top', newTop);\n      return moveX || moveY;\n    },\n\n    /**\n     * Check if we are increasing a positive skew or lower it,\n     * checking mouse direction and pressed corner.\n     * @private\n     */\n    _changeSkewTransformOrigin: function(mouseMove, t, by) {\n      var property = 'originX', origins = { 0: 'center' },\n          skew = t.target.skewX, originA = 'left', originB = 'right',\n          corner = t.corner === 'mt' || t.corner === 'ml' ? 1 : -1,\n          flipSign = 1;\n\n      mouseMove = mouseMove > 0 ? 1 : -1;\n      if (by === 'y') {\n        skew = t.target.skewY;\n        originA = 'top';\n        originB = 'bottom';\n        property = 'originY';\n      }\n      origins[-1] = originA;\n      origins[1] = originB;\n\n      t.target.flipX && (flipSign *= -1);\n      t.target.flipY && (flipSign *= -1);\n\n      if (skew === 0) {\n        t.skewSign = -corner * mouseMove * flipSign;\n        t[property] = origins[-mouseMove];\n      }\n      else {\n        skew = skew > 0 ? 1 : -1;\n        t.skewSign = skew;\n        t[property] = origins[skew * corner * flipSign];\n      }\n    },\n\n    /**\n     * Skew object by mouse events\n     * @private\n     * @param {Number} x pointer's x coordinate\n     * @param {Number} y pointer's y coordinate\n     * @param {String} by Either 'x' or 'y'\n     * @return {Boolean} true if the skewing occurred\n     */\n    _skewObject: function (x, y, by) {\n      var t = this._currentTransform,\n          target = t.target, skewed = false,\n          lockSkewingX = target.get('lockSkewingX'),\n          lockSkewingY = target.get('lockSkewingY');\n\n      if ((lockSkewingX && by === 'x') || (lockSkewingY && by === 'y')) {\n        return false;\n      }\n\n      // Get the constraint point\n      var center = target.getCenterPoint(),\n          actualMouseByCenter = target.toLocalPoint(new fabric.Point(x, y), 'center', 'center')[by],\n          lastMouseByCenter = target.toLocalPoint(new fabric.Point(t.lastX, t.lastY), 'center', 'center')[by],\n          actualMouseByOrigin, constraintPosition, dim = target._getTransformedDimensions();\n\n      this._changeSkewTransformOrigin(actualMouseByCenter - lastMouseByCenter, t, by);\n      actualMouseByOrigin = target.toLocalPoint(new fabric.Point(x, y), t.originX, t.originY)[by],\n\n      constraintPosition = target.translateToOriginPoint(center, t.originX, t.originY);\n      // Actually skew the object\n      skewed = this._setObjectSkew(actualMouseByOrigin, t, by, dim);\n      t.lastX = x;\n      t.lastY = y;\n      // Make sure the constraints apply\n      target.setPositionByOrigin(constraintPosition, t.originX, t.originY);\n      return skewed;\n    },\n\n    /**\n     * Set object skew\n     * @private\n     * @return {Boolean} true if the skewing occurred\n     */\n    _setObjectSkew: function(localMouse, transform, by, _dim) {\n      var target = transform.target, newValue, skewed = false,\n          skewSign = transform.skewSign, newDim, dimNoSkew,\n          otherBy, _otherBy, _by, newDimMouse, skewX, skewY;\n\n      if (by === 'x') {\n        otherBy = 'y';\n        _otherBy = 'Y';\n        _by = 'X';\n        skewX = 0;\n        skewY = target.skewY;\n      }\n      else {\n        otherBy = 'x';\n        _otherBy = 'X';\n        _by = 'Y';\n        skewX = target.skewX;\n        skewY = 0;\n      }\n\n      dimNoSkew = target._getTransformedDimensions(skewX, skewY);\n      newDimMouse = 2 * Math.abs(localMouse) - dimNoSkew[by];\n      if (newDimMouse <= 2) {\n        newValue = 0;\n      }\n      else {\n        newValue = skewSign * Math.atan((newDimMouse / target['scale' + _by]) /\n                                        (dimNoSkew[otherBy] / target['scale' + _otherBy]));\n        newValue = fabric.util.radiansToDegrees(newValue);\n      }\n      skewed = target['skew' + _by] !== newValue;\n      target.set('skew' + _by, newValue);\n      if (target['skew' + _otherBy] !== 0) {\n        newDim = target._getTransformedDimensions();\n        newValue = (_dim[otherBy] / newDim[otherBy]) * target['scale' + _otherBy];\n        target.set('scale' + _otherBy, newValue);\n      }\n      return skewed;\n    },\n\n    /**\n     * Scales object by invoking its scaleX/scaleY methods\n     * @private\n     * @param {Number} x pointer's x coordinate\n     * @param {Number} y pointer's y coordinate\n     * @param {String} by Either 'x' or 'y' - specifies dimension constraint by which to scale an object.\n     *                    When not provided, an object is scaled by both dimensions equally\n     * @return {Boolean} true if the scaling occurred\n     */\n    _scaleObject: function (x, y, by) {\n      var t = this._currentTransform,\n          target = t.target,\n          lockScalingX = target.get('lockScalingX'),\n          lockScalingY = target.get('lockScalingY'),\n          lockScalingFlip = target.get('lockScalingFlip');\n\n      if (lockScalingX && lockScalingY) {\n        return false;\n      }\n\n      // Get the constraint point\n      var constraintPosition = target.translateToOriginPoint(target.getCenterPoint(), t.originX, t.originY),\n          localMouse = target.toLocalPoint(new fabric.Point(x, y), t.originX, t.originY),\n          dim = target._getTransformedDimensions(), scaled = false;\n\n      this._setLocalMouse(localMouse, t);\n\n      // Actually scale the object\n      scaled = this._setObjectScale(localMouse, t, lockScalingX, lockScalingY, by, lockScalingFlip, dim);\n\n      // Make sure the constraints apply\n      target.setPositionByOrigin(constraintPosition, t.originX, t.originY);\n      return scaled;\n    },\n\n    /**\n     * @private\n     * @return {Boolean} true if the scaling occurred\n     */\n    _setObjectScale: function(localMouse, transform, lockScalingX, lockScalingY, by, lockScalingFlip, _dim) {\n      var target = transform.target, forbidScalingX = false, forbidScalingY = false, scaled = false,\n          changeX, changeY, scaleX, scaleY;\n\n      scaleX = localMouse.x * target.scaleX / _dim.x;\n      scaleY = localMouse.y * target.scaleY / _dim.y;\n      changeX = target.scaleX !== scaleX;\n      changeY = target.scaleY !== scaleY;\n\n      if (lockScalingFlip && scaleX <= 0 && scaleX < target.scaleX) {\n        forbidScalingX = true;\n      }\n\n      if (lockScalingFlip && scaleY <= 0 && scaleY < target.scaleY) {\n        forbidScalingY = true;\n      }\n\n      if (by === 'equally' && !lockScalingX && !lockScalingY) {\n        forbidScalingX || forbidScalingY || (scaled = this._scaleObjectEqually(localMouse, target, transform, _dim));\n      }\n      else if (!by) {\n        forbidScalingX || lockScalingX || (target.set('scaleX', scaleX) && (scaled = scaled || changeX));\n        forbidScalingY || lockScalingY || (target.set('scaleY', scaleY) && (scaled = scaled || changeY));\n      }\n      else if (by === 'x' && !target.get('lockUniScaling')) {\n        forbidScalingX || lockScalingX || (target.set('scaleX', scaleX) && (scaled = scaled || changeX));\n      }\n      else if (by === 'y' && !target.get('lockUniScaling')) {\n        forbidScalingY || lockScalingY || (target.set('scaleY', scaleY) && (scaled = scaled || changeY));\n      }\n      transform.newScaleX = scaleX;\n      transform.newScaleY = scaleY;\n      forbidScalingX || forbidScalingY || this._flipObject(transform, by);\n      return scaled;\n    },\n\n    /**\n     * @private\n     * @return {Boolean} true if the scaling occurred\n     */\n    _scaleObjectEqually: function(localMouse, target, transform, _dim) {\n\n      var dist = localMouse.y + localMouse.x,\n          lastDist = _dim.y * transform.original.scaleY / target.scaleY +\n                     _dim.x * transform.original.scaleX / target.scaleX,\n          scaled;\n\n      // We use transform.scaleX/Y instead of target.scaleX/Y\n      // because the object may have a min scale and we'll loose the proportions\n      transform.newScaleX = transform.original.scaleX * dist / lastDist;\n      transform.newScaleY = transform.original.scaleY * dist / lastDist;\n      scaled = transform.newScaleX !== target.scaleX || transform.newScaleY !== target.scaleY;\n      target.set('scaleX', transform.newScaleX);\n      target.set('scaleY', transform.newScaleY);\n      return scaled;\n    },\n\n    /**\n     * @private\n     */\n    _flipObject: function(transform, by) {\n      if (transform.newScaleX < 0 && by !== 'y') {\n        if (transform.originX === 'left') {\n          transform.originX = 'right';\n        }\n        else if (transform.originX === 'right') {\n          transform.originX = 'left';\n        }\n      }\n\n      if (transform.newScaleY < 0 && by !== 'x') {\n        if (transform.originY === 'top') {\n          transform.originY = 'bottom';\n        }\n        else if (transform.originY === 'bottom') {\n          transform.originY = 'top';\n        }\n      }\n    },\n\n    /**\n     * @private\n     */\n    _setLocalMouse: function(localMouse, t) {\n      var target = t.target;\n\n      if (t.originX === 'right') {\n        localMouse.x *= -1;\n      }\n      else if (t.originX === 'center') {\n        localMouse.x *= t.mouseXSign * 2;\n\n        if (localMouse.x < 0) {\n          t.mouseXSign = -t.mouseXSign;\n        }\n      }\n\n      if (t.originY === 'bottom') {\n        localMouse.y *= -1;\n      }\n      else if (t.originY === 'center') {\n        localMouse.y *= t.mouseYSign * 2;\n\n        if (localMouse.y < 0) {\n          t.mouseYSign = -t.mouseYSign;\n        }\n      }\n\n      // adjust the mouse coordinates when dealing with padding\n      if (abs(localMouse.x) > target.padding) {\n        if (localMouse.x < 0) {\n          localMouse.x += target.padding;\n        }\n        else {\n          localMouse.x -= target.padding;\n        }\n      }\n      else { // mouse is within the padding, set to 0\n        localMouse.x = 0;\n      }\n\n      if (abs(localMouse.y) > target.padding) {\n        if (localMouse.y < 0) {\n          localMouse.y += target.padding;\n        }\n        else {\n          localMouse.y -= target.padding;\n        }\n      }\n      else {\n        localMouse.y = 0;\n      }\n    },\n\n    /**\n     * Rotates object by invoking its rotate method\n     * @private\n     * @param {Number} x pointer's x coordinate\n     * @param {Number} y pointer's y coordinate\n     * @return {Boolean} true if the rotation occurred\n     */\n    _rotateObject: function (x, y) {\n\n      var t = this._currentTransform;\n\n      if (t.target.get('lockRotation')) {\n        return false;\n      }\n\n      var lastAngle = atan2(t.ey - t.top, t.ex - t.left),\n          curAngle = atan2(y - t.top, x - t.left),\n          angle = radiansToDegrees(curAngle - lastAngle + t.theta);\n\n      // normalize angle to positive value\n      if (angle < 0) {\n        angle = 360 + angle;\n      }\n\n      t.target.angle = angle % 360;\n      return true;\n    },\n\n    /**\n     * Set the cursor type of the canvas element\n     * @param {String} value Cursor type of the canvas element.\n     * @see http://www.w3.org/TR/css3-ui/#cursor\n     */\n    setCursor: function (value) {\n      this.upperCanvasEl.style.cursor = value;\n    },\n\n    /**\n     * @private\n     */\n    _resetObjectTransform: function (target) {\n      target.scaleX = 1;\n      target.scaleY = 1;\n      target.skewX = 0;\n      target.skewY = 0;\n      target.setAngle(0);\n    },\n\n    /**\n     * @private\n     */\n    _drawSelection: function () {\n      var ctx = this.contextTop,\n          groupSelector = this._groupSelector,\n          left = groupSelector.left,\n          top = groupSelector.top,\n          aleft = abs(left),\n          atop = abs(top);\n\n      ctx.fillStyle = this.selectionColor;\n\n      ctx.fillRect(\n        groupSelector.ex - ((left > 0) ? 0 : -left),\n        groupSelector.ey - ((top > 0) ? 0 : -top),\n        aleft,\n        atop\n      );\n\n      ctx.lineWidth = this.selectionLineWidth;\n      ctx.strokeStyle = this.selectionBorderColor;\n\n      // selection border\n      if (this.selectionDashArray.length > 1) {\n\n        var px = groupSelector.ex + STROKE_OFFSET - ((left > 0) ? 0: aleft),\n            py = groupSelector.ey + STROKE_OFFSET - ((top > 0) ? 0: atop);\n\n        ctx.beginPath();\n\n        fabric.util.drawDashedLine(ctx, px, py, px + aleft, py, this.selectionDashArray);\n        fabric.util.drawDashedLine(ctx, px, py + atop - 1, px + aleft, py + atop - 1, this.selectionDashArray);\n        fabric.util.drawDashedLine(ctx, px, py, px, py + atop, this.selectionDashArray);\n        fabric.util.drawDashedLine(ctx, px + aleft - 1, py, px + aleft - 1, py + atop, this.selectionDashArray);\n\n        ctx.closePath();\n        ctx.stroke();\n      }\n      else {\n        ctx.strokeRect(\n          groupSelector.ex + STROKE_OFFSET - ((left > 0) ? 0 : aleft),\n          groupSelector.ey + STROKE_OFFSET - ((top > 0) ? 0 : atop),\n          aleft,\n          atop\n        );\n      }\n    },\n\n    /**\n     * @private\n     */\n    _isLastRenderedObject: function(e) {\n      return (\n        this.controlsAboveOverlay &&\n        this.lastRenderedObjectWithControlsAboveOverlay &&\n        this.lastRenderedObjectWithControlsAboveOverlay.visible &&\n        this.containsPoint(e, this.lastRenderedObjectWithControlsAboveOverlay) &&\n        this.lastRenderedObjectWithControlsAboveOverlay._findTargetCorner(this.getPointer(e, true)));\n    },\n\n    /**\n     * Method that determines what object we are clicking on\n     * @param {Event} e mouse event\n     * @param {Boolean} skipGroup when true, group is skipped and only objects are traversed through\n     */\n    findTarget: function (e, skipGroup) {\n      if (this.skipTargetFind) {\n        return;\n      }\n\n      if (this._isLastRenderedObject(e)) {\n        return this.lastRenderedObjectWithControlsAboveOverlay;\n      }\n\n      // first check current group (if one exists)\n      var activeGroup = this.getActiveGroup();\n      if (!skipGroup && this._checkTarget(e, activeGroup, this.getPointer(e, true))) {\n        return activeGroup;\n      }\n\n      var target = this._searchPossibleTargets(e, skipGroup);\n      this._fireOverOutEvents(target, e);\n\n      return target;\n    },\n\n    /**\n     * @private\n     */\n    _fireOverOutEvents: function(target, e) {\n      if (target) {\n        if (this._hoveredTarget !== target) {\n          if (this._hoveredTarget) {\n            this.fire('mouse:out', { target: this._hoveredTarget, e: e });\n            this._hoveredTarget.fire('mouseout');\n          }\n          this.fire('mouse:over', { target: target, e: e });\n          target.fire('mouseover');\n          this._hoveredTarget = target;\n        }\n      }\n      else if (this._hoveredTarget) {\n        this.fire('mouse:out', { target: this._hoveredTarget, e: e });\n        this._hoveredTarget.fire('mouseout');\n        this._hoveredTarget = null;\n      }\n    },\n\n    /**\n     * @private\n     */\n    _checkTarget: function(e, obj, pointer) {\n      if (obj &&\n          obj.visible &&\n          obj.evented &&\n          this.containsPoint(e, obj)){\n        if ((this.perPixelTargetFind || obj.perPixelTargetFind) && !obj.isEditing) {\n          var isTransparent = this.isTargetTransparent(obj, pointer.x, pointer.y);\n          if (!isTransparent) {\n            return true;\n          }\n        }\n        else {\n          return true;\n        }\n      }\n    },\n\n    /**\n     * @private\n     */\n    _searchPossibleTargets: function(e, skipGroup) {\n\n      // Cache all targets where their bounding box contains point.\n      var target,\n          pointer = this.getPointer(e, true),\n          i = this._objects.length;\n      // Do not check for currently grouped objects, since we check the parent group itself.\n      // untill we call this function specifically to search inside the activeGroup\n      while (i--) {\n        if ((!this._objects[i].group || skipGroup) && this._checkTarget(e, this._objects[i], pointer)){\n          this.relatedTarget = this._objects[i];\n          target = this._objects[i];\n          break;\n        }\n      }\n\n      return target;\n    },\n\n    /**\n     * Returns pointer coordinates relative to canvas.\n     * @param {Event} e\n     * @return {Object} object with \"x\" and \"y\" number values\n     */\n    getPointer: function (e, ignoreZoom, upperCanvasEl) {\n      if (!upperCanvasEl) {\n        upperCanvasEl = this.upperCanvasEl;\n      }\n      var pointer = getPointer(e),\n          bounds = upperCanvasEl.getBoundingClientRect(),\n          boundsWidth = bounds.width || 0,\n          boundsHeight = bounds.height || 0,\n          cssScale;\n\n      if (!boundsWidth || !boundsHeight ) {\n        if ('top' in bounds && 'bottom' in bounds) {\n          boundsHeight = Math.abs( bounds.top - bounds.bottom );\n        }\n        if ('right' in bounds && 'left' in bounds) {\n          boundsWidth = Math.abs( bounds.right - bounds.left );\n        }\n      }\n\n      this.calcOffset();\n\n      pointer.x = pointer.x - this._offset.left;\n      pointer.y = pointer.y - this._offset.top;\n      if (!ignoreZoom) {\n        pointer = fabric.util.transformPoint(\n          pointer,\n          fabric.util.invertTransform(this.viewportTransform)\n        );\n      }\n\n      if (boundsWidth === 0 || boundsHeight === 0) {\n        // If bounds are not available (i.e. not visible), do not apply scale.\n        cssScale = { width: 1, height: 1 };\n      }\n      else {\n        cssScale = {\n          width: upperCanvasEl.width / boundsWidth,\n          height: upperCanvasEl.height / boundsHeight\n        };\n      }\n\n      return {\n        x: pointer.x * cssScale.width,\n        y: pointer.y * cssScale.height\n      };\n    },\n\n    /**\n     * @private\n     * @throws {CANVAS_INIT_ERROR} If canvas can not be initialized\n     */\n    _createUpperCanvas: function () {\n      var lowerCanvasClass = this.lowerCanvasEl.className.replace(/\\s*lower-canvas\\s*/, '');\n\n      this.upperCanvasEl = this._createCanvasElement();\n      fabric.util.addClass(this.upperCanvasEl, 'upper-canvas ' + lowerCanvasClass);\n\n      this.wrapperEl.appendChild(this.upperCanvasEl);\n\n      this._copyCanvasStyle(this.lowerCanvasEl, this.upperCanvasEl);\n      this._applyCanvasStyle(this.upperCanvasEl);\n      this.contextTop = this.upperCanvasEl.getContext('2d');\n    },\n\n    /**\n     * @private\n     */\n    _createCacheCanvas: function () {\n      this.cacheCanvasEl = this._createCanvasElement();\n      this.cacheCanvasEl.setAttribute('width', this.width);\n      this.cacheCanvasEl.setAttribute('height', this.height);\n      this.contextCache = this.cacheCanvasEl.getContext('2d');\n    },\n\n    /**\n     * @private\n     */\n    _initWrapperElement: function () {\n      this.wrapperEl = fabric.util.wrapElement(this.lowerCanvasEl, 'div', {\n        'class': this.containerClass\n      });\n      fabric.util.setStyle(this.wrapperEl, {\n        width: this.getWidth() + 'px',\n        height: this.getHeight() + 'px',\n        position: 'relative'\n      });\n      fabric.util.makeElementUnselectable(this.wrapperEl);\n    },\n\n    /**\n     * @private\n     * @param {HTMLElement} element canvas element to apply styles on\n     */\n    _applyCanvasStyle: function (element) {\n      var width = this.getWidth() || element.width,\n          height = this.getHeight() || element.height;\n\n      fabric.util.setStyle(element, {\n        position: 'absolute',\n        width: width + 'px',\n        height: height + 'px',\n        left: 0,\n        top: 0\n      });\n      element.width = width;\n      element.height = height;\n      fabric.util.makeElementUnselectable(element);\n    },\n\n    /**\n     * Copys the the entire inline style from one element (fromEl) to another (toEl)\n     * @private\n     * @param {Element} fromEl Element style is copied from\n     * @param {Element} toEl Element copied style is applied to\n     */\n    _copyCanvasStyle: function (fromEl, toEl) {\n      toEl.style.cssText = fromEl.style.cssText;\n    },\n\n    /**\n     * Returns context of canvas where object selection is drawn\n     * @return {CanvasRenderingContext2D}\n     */\n    getSelectionContext: function() {\n      return this.contextTop;\n    },\n\n    /**\n     * Returns &lt;canvas> element on which object selection is drawn\n     * @return {HTMLCanvasElement}\n     */\n    getSelectionElement: function () {\n      return this.upperCanvasEl;\n    },\n\n    /**\n     * @private\n     * @param {Object} object\n     */\n    _setActiveObject: function(object) {\n      if (this._activeObject) {\n        this._activeObject.set('active', false);\n      }\n      this._activeObject = object;\n      object.set('active', true);\n    },\n\n    /**\n     * Sets given object as the only active object on canvas\n     * @param {fabric.Object} object Object to set as an active one\n     * @param {Event} [e] Event (passed along when firing \"object:selected\")\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    setActiveObject: function (object, e) {\n      this._setActiveObject(object);\n      this.renderAll();\n      this.fire('object:selected', { target: object, e: e });\n      object.fire('selected', { e: e });\n      return this;\n    },\n\n    /**\n     * Returns currently active object\n     * @return {fabric.Object} active object\n     */\n    getActiveObject: function () {\n      return this._activeObject;\n    },\n\n    /**\n     * @private\n     */\n    _discardActiveObject: function() {\n      if (this._activeObject) {\n        this._activeObject.set('active', false);\n      }\n      this._activeObject = null;\n    },\n\n    /**\n     * Discards currently active object\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    discardActiveObject: function (e) {\n      this._discardActiveObject();\n      this.renderAll();\n      this.fire('selection:cleared', { e: e });\n      return this;\n    },\n\n    /**\n     * @private\n     * @param {fabric.Group} group\n     */\n    _setActiveGroup: function(group) {\n      this._activeGroup = group;\n      if (group) {\n        group.set('active', true);\n      }\n    },\n\n    /**\n     * Sets active group to a specified one\n     * @param {fabric.Group} group Group to set as a current one\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    setActiveGroup: function (group, e) {\n      this._setActiveGroup(group);\n      if (group) {\n        this.fire('object:selected', { target: group, e: e });\n        group.fire('selected', { e: e });\n      }\n      return this;\n    },\n\n    /**\n     * Returns currently active group\n     * @return {fabric.Group} Current group\n     */\n    getActiveGroup: function () {\n      return this._activeGroup;\n    },\n\n    /**\n     * @private\n     */\n    _discardActiveGroup: function() {\n      var g = this.getActiveGroup();\n      if (g) {\n        g.destroy();\n      }\n      this.setActiveGroup(null);\n    },\n\n    /**\n     * Discards currently active group\n     * @return {fabric.Canvas} thisArg\n     */\n    discardActiveGroup: function (e) {\n      this._discardActiveGroup();\n      this.fire('selection:cleared', { e: e });\n      return this;\n    },\n\n    /**\n     * Deactivates all objects on canvas, removing any active group or object\n     * @return {fabric.Canvas} thisArg\n     */\n    deactivateAll: function () {\n      var allObjects = this.getObjects(),\n          i = 0,\n          len = allObjects.length;\n      for ( ; i < len; i++) {\n        allObjects[i].set('active', false);\n      }\n      this._discardActiveGroup();\n      this._discardActiveObject();\n      return this;\n    },\n\n    /**\n     * Deactivates all objects and dispatches appropriate events\n     * @return {fabric.Canvas} thisArg\n     */\n    deactivateAllWithDispatch: function (e) {\n      var activeObject = this.getActiveGroup() || this.getActiveObject();\n      if (activeObject) {\n        this.fire('before:selection:cleared', { target: activeObject, e: e });\n      }\n      this.deactivateAll();\n      if (activeObject) {\n        this.fire('selection:cleared', { e: e });\n      }\n      return this;\n    },\n\n    /**\n     * Clears a canvas element and removes all event listeners\n     * @return {fabric.Canvas} thisArg\n     * @chainable\n     */\n    dispose: function () {\n      this.callSuper('dispose');\n      var wrapper = this.wrapperEl;\n      this.removeListeners();\n      wrapper.removeChild(this.upperCanvasEl);\n      wrapper.removeChild(this.lowerCanvasEl);\n      delete this.upperCanvasEl;\n      if (wrapper.parentNode) {\n        wrapper.parentNode.replaceChild(this.lowerCanvasEl, this.wrapperEl);\n      }\n      delete this.wrapperEl;\n      return this;\n    },\n\n    /**\n     * Draws objects' controls (borders/controls)\n     * @param {CanvasRenderingContext2D} ctx Context to render controls on\n     */\n    drawControls: function(ctx) {\n      var activeGroup = this.getActiveGroup();\n\n      if (activeGroup) {\n        activeGroup._renderControls(ctx);\n      }\n      else {\n        this._drawObjectsControls(ctx);\n      }\n    },\n\n    /**\n     * @private\n     */\n    _drawObjectsControls: function(ctx) {\n      for (var i = 0, len = this._objects.length; i < len; ++i) {\n        if (!this._objects[i] || !this._objects[i].active) {\n          continue;\n        }\n        this._objects[i]._renderControls(ctx);\n        this.lastRenderedObjectWithControlsAboveOverlay = this._objects[i];\n      }\n    }\n  });\n\n  // copying static properties manually to work around Opera's bug,\n  // where \"prototype\" property is enumerable and overrides existing prototype\n  for (var prop in fabric.StaticCanvas) {\n    if (prop !== 'prototype') {\n      fabric.Canvas[prop] = fabric.StaticCanvas[prop];\n    }\n  }\n\n  if (fabric.isTouchSupported) {\n    /** @ignore */\n    fabric.Canvas.prototype._setCursorFromEvent = function() { };\n  }\n\n  /**\n   * @ignore\n   * @class fabric.Element\n   * @alias fabric.Canvas\n   * @deprecated Use {@link fabric.Canvas} instead.\n   * @constructor\n   */\n  fabric.Element = fabric.Canvas;\n})();\n\n\n(function() {\n\n  var cursorOffset = {\n    mt: 0, // n\n    tr: 1, // ne\n    mr: 2, // e\n    br: 3, // se\n    mb: 4, // s\n    bl: 5, // sw\n    ml: 6, // w\n    tl: 7 // nw\n  },\n  addListener = fabric.util.addListener,\n  removeListener = fabric.util.removeListener;\n\n  fabric.util.object.extend(fabric.Canvas.prototype, /** @lends fabric.Canvas.prototype */ {\n\n    /**\n     * Map of cursor style values for each of the object controls\n     * @private\n     */\n    cursorMap: [\n      'n-resize',\n      'ne-resize',\n      'e-resize',\n      'se-resize',\n      's-resize',\n      'sw-resize',\n      'w-resize',\n      'nw-resize'\n    ],\n\n    /**\n     * Adds mouse listeners to canvas\n     * @private\n     */\n    _initEventListeners: function () {\n\n      this._bindEvents();\n\n      addListener(fabric.window, 'resize', this._onResize);\n\n      // mouse events\n      addListener(this.upperCanvasEl, 'mousedown', this._onMouseDown);\n      addListener(this.upperCanvasEl, 'mousemove', this._onMouseMove);\n      addListener(this.upperCanvasEl, 'mousewheel', this._onMouseWheel);\n      addListener(this.upperCanvasEl, 'mouseout', this._onMouseOut);\n\n      // touch events\n      addListener(this.upperCanvasEl, 'touchstart', this._onMouseDown);\n      addListener(this.upperCanvasEl, 'touchmove', this._onMouseMove);\n\n      if (typeof eventjs !== 'undefined' && 'add' in eventjs) {\n        eventjs.add(this.upperCanvasEl, 'gesture', this._onGesture);\n        eventjs.add(this.upperCanvasEl, 'drag', this._onDrag);\n        eventjs.add(this.upperCanvasEl, 'orientation', this._onOrientationChange);\n        eventjs.add(this.upperCanvasEl, 'shake', this._onShake);\n        eventjs.add(this.upperCanvasEl, 'longpress', this._onLongPress);\n      }\n    },\n\n    /**\n     * @private\n     */\n    _bindEvents: function() {\n      this._onMouseDown = this._onMouseDown.bind(this);\n      this._onMouseMove = this._onMouseMove.bind(this);\n      this._onMouseUp = this._onMouseUp.bind(this);\n      this._onResize = this._onResize.bind(this);\n      this._onGesture = this._onGesture.bind(this);\n      this._onDrag = this._onDrag.bind(this);\n      this._onShake = this._onShake.bind(this);\n      this._onLongPress = this._onLongPress.bind(this);\n      this._onOrientationChange = this._onOrientationChange.bind(this);\n      this._onMouseWheel = this._onMouseWheel.bind(this);\n      this._onMouseOut = this._onMouseOut.bind(this);\n    },\n\n    /**\n     * Removes all event listeners\n     */\n    removeListeners: function() {\n      removeListener(fabric.window, 'resize', this._onResize);\n\n      removeListener(this.upperCanvasEl, 'mousedown', this._onMouseDown);\n      removeListener(this.upperCanvasEl, 'mousemove', this._onMouseMove);\n      removeListener(this.upperCanvasEl, 'mousewheel', this._onMouseWheel);\n      removeListener(this.upperCanvasEl, 'mouseout', this._onMouseOut);\n\n      removeListener(this.upperCanvasEl, 'touchstart', this._onMouseDown);\n      removeListener(this.upperCanvasEl, 'touchmove', this._onMouseMove);\n\n      if (typeof eventjs !== 'undefined' && 'remove' in eventjs) {\n        eventjs.remove(this.upperCanvasEl, 'gesture', this._onGesture);\n        eventjs.remove(this.upperCanvasEl, 'drag', this._onDrag);\n        eventjs.remove(this.upperCanvasEl, 'orientation', this._onOrientationChange);\n        eventjs.remove(this.upperCanvasEl, 'shake', this._onShake);\n        eventjs.remove(this.upperCanvasEl, 'longpress', this._onLongPress);\n      }\n    },\n\n    /**\n     * @private\n     * @param {Event} [e] Event object fired on Event.js gesture\n     * @param {Event} [self] Inner Event object\n     */\n    _onGesture: function(e, self) {\n      this.__onTransformGesture && this.__onTransformGesture(e, self);\n    },\n\n    /**\n     * @private\n     * @param {Event} [e] Event object fired on Event.js drag\n     * @param {Event} [self] Inner Event object\n     */\n    _onDrag: function(e, self) {\n      this.__onDrag && this.__onDrag(e, self);\n    },\n\n    /**\n     * @private\n     * @param {Event} [e] Event object fired on Event.js wheel event\n     * @param {Event} [self] Inner Event object\n     */\n    _onMouseWheel: function(e, self) {\n      this.__onMouseWheel && this.__onMouseWheel(e, self);\n    },\n\n    /**\n     * @private\n     * @param {Event} e Event object fired on mousedown\n     */\n    _onMouseOut: function(e) {\n      var target = this._hoveredTarget;\n      this.fire('mouse:out', { target: target, e: e });\n      this._hoveredTarget = null;\n      target && target.fire('mouseout', { e: e });\n    },\n\n    /**\n     * @private\n     * @param {Event} [e] Event object fired on Event.js orientation change\n     * @param {Event} [self] Inner Event object\n     */\n    _onOrientationChange: function(e, self) {\n      this.__onOrientationChange && this.__onOrientationChange(e, self);\n    },\n\n    /**\n     * @private\n     * @param {Event} [e] Event object fired on Event.js shake\n     * @param {Event} [self] Inner Event object\n     */\n    _onShake: function(e, self) {\n      this.__onShake && this.__onShake(e, self);\n    },\n\n    /**\n     * @private\n     * @param {Event} [e] Event object fired on Event.js shake\n     * @param {Event} [self] Inner Event object\n     */\n    _onLongPress: function(e, self) {\n      this.__onLongPress && this.__onLongPress(e, self);\n    },\n\n    /**\n     * @private\n     * @param {Event} e Event object fired on mousedown\n     */\n    _onMouseDown: function (e) {\n      this.__onMouseDown(e);\n\n      addListener(fabric.document, 'touchend', this._onMouseUp);\n      addListener(fabric.document, 'touchmove', this._onMouseMove);\n\n      removeListener(this.upperCanvasEl, 'mousemove', this._onMouseMove);\n      removeListener(this.upperCanvasEl, 'touchmove', this._onMouseMove);\n\n      if (e.type === 'touchstart') {\n        // Unbind mousedown to prevent double triggers from touch devices\n        removeListener(this.upperCanvasEl, 'mousedown', this._onMouseDown);\n      }\n      else {\n        addListener(fabric.document, 'mouseup', this._onMouseUp);\n        addListener(fabric.document, 'mousemove', this._onMouseMove);\n      }\n    },\n\n    /**\n     * @private\n     * @param {Event} e Event object fired on mouseup\n     */\n    _onMouseUp: function (e) {\n      this.__onMouseUp(e);\n\n      removeListener(fabric.document, 'mouseup', this._onMouseUp);\n      removeListener(fabric.document, 'touchend', this._onMouseUp);\n\n      removeListener(fabric.document, 'mousemove', this._onMouseMove);\n      removeListener(fabric.document, 'touchmove', this._onMouseMove);\n\n      addListener(this.upperCanvasEl, 'mousemove', this._onMouseMove);\n      addListener(this.upperCanvasEl, 'touchmove', this._onMouseMove);\n\n      if (e.type === 'touchend') {\n        // Wait 400ms before rebinding mousedown to prevent double triggers\n        // from touch devices\n        var _this = this;\n        setTimeout(function() {\n          addListener(_this.upperCanvasEl, 'mousedown', _this._onMouseDown);\n        }, 400);\n      }\n    },\n\n    /**\n     * @private\n     * @param {Event} e Event object fired on mousemove\n     */\n    _onMouseMove: function (e) {\n      !this.allowTouchScrolling && e.preventDefault && e.preventDefault();\n      this.__onMouseMove(e);\n    },\n\n    /**\n     * @private\n     */\n    _onResize: function () {\n      this.calcOffset();\n    },\n\n    /**\n     * Decides whether the canvas should be redrawn in mouseup and mousedown events.\n     * @private\n     * @param {Object} target\n     * @param {Object} pointer\n     */\n    _shouldRender: function(target, pointer) {\n      var activeObject = this.getActiveGroup() || this.getActiveObject();\n\n      return !!(\n        (target && (\n          target.isMoving ||\n          target !== activeObject))\n        ||\n        (!target && !!activeObject)\n        ||\n        (!target && !activeObject && !this._groupSelector)\n        ||\n        (pointer &&\n          this._previousPointer &&\n          this.selection && (\n          pointer.x !== this._previousPointer.x ||\n          pointer.y !== this._previousPointer.y))\n      );\n    },\n\n    /**\n     * Method that defines the actions when mouse is released on canvas.\n     * The method resets the currentTransform parameters, store the image corner\n     * position in the image object and render the canvas on top.\n     * @private\n     * @param {Event} e Event object fired on mouseup\n     */\n    __onMouseUp: function (e) {\n      var target, searchTarget = true, transform = this._currentTransform;\n\n      if (this.isDrawingMode && this._isCurrentlyDrawing) {\n        this._onMouseUpInDrawingMode(e);\n        return;\n      }\n\n      if (transform) {\n        this._finalizeCurrentTransform();\n        searchTarget = !transform.actionPerformed;\n      }\n\n      target = searchTarget ? this.findTarget(e, true) : transform.target;\n\n      var shouldRender = this._shouldRender(target, this.getPointer(e));\n\n      this._maybeGroupObjects(e);\n\n      if (target) {\n        target.isMoving = false;\n      }\n\n      shouldRender && this.renderAll();\n\n      this._handleCursorAndEvent(e, target);\n    },\n\n    _handleCursorAndEvent: function(e, target) {\n      this._setCursorFromEvent(e, target);\n\n      // Can't find any reason, disabling for now\n      // TODO: why are we doing this?\n      /* var _this = this;\n      setTimeout(function () {\n        _this._setCursorFromEvent(e, target);\n      }, 50); */\n\n      this.fire('mouse:up', { target: target, e: e });\n      target && target.fire('mouseup', { e: e });\n    },\n\n    /**\n     * @private\n     */\n    _finalizeCurrentTransform: function() {\n\n      var transform = this._currentTransform,\n          target = transform.target;\n\n      if (target._scaling) {\n        target._scaling = false;\n      }\n\n      target.setCoords();\n      this._restoreOriginXY(target);\n\n      if (transform.actionPerformed || (this.stateful && target.hasStateChanged())) {\n        this.fire('object:modified', { target: target });\n        target.fire('modified');\n      }\n    },\n\n    /**\n     * @private\n     * @param {Object} target Object to restore\n     */\n    _restoreOriginXY: function(target) {\n      if (this._previousOriginX && this._previousOriginY) {\n\n        var originPoint = target.translateToOriginPoint(\n          target.getCenterPoint(),\n          this._previousOriginX,\n          this._previousOriginY);\n\n        target.originX = this._previousOriginX;\n        target.originY = this._previousOriginY;\n\n        target.left = originPoint.x;\n        target.top = originPoint.y;\n\n        this._previousOriginX = null;\n        this._previousOriginY = null;\n      }\n    },\n\n    /**\n     * @private\n     * @param {Event} e Event object fired on mousedown\n     */\n    _onMouseDownInDrawingMode: function(e) {\n      this._isCurrentlyDrawing = true;\n      this.discardActiveObject(e).renderAll();\n      if (this.clipTo) {\n        fabric.util.clipContext(this, this.contextTop);\n      }\n      var ivt = fabric.util.invertTransform(this.viewportTransform),\n          pointer = fabric.util.transformPoint(this.getPointer(e, true), ivt);\n      this.freeDrawingBrush.onMouseDown(pointer);\n      this.fire('mouse:down', { e: e });\n\n      var target = this.findTarget(e);\n      if (typeof target !== 'undefined') {\n        target.fire('mousedown', { e: e, target: target });\n      }\n    },\n\n    /**\n     * @private\n     * @param {Event} e Event object fired on mousemove\n     */\n    _onMouseMoveInDrawingMode: function(e) {\n      if (this._isCurrentlyDrawing) {\n        var ivt = fabric.util.invertTransform(this.viewportTransform),\n            pointer = fabric.util.transformPoint(this.getPointer(e, true), ivt);\n        this.freeDrawingBrush.onMouseMove(pointer);\n      }\n      this.setCursor(this.freeDrawingCursor);\n      this.fire('mouse:move', { e: e });\n\n      var target = this.findTarget(e);\n      if (typeof target !== 'undefined') {\n        target.fire('mousemove', { e: e, target: target });\n      }\n    },\n\n    /**\n     * @private\n     * @param {Event} e Event object fired on mouseup\n     */\n    _onMouseUpInDrawingMode: function(e) {\n      this._isCurrentlyDrawing = false;\n      if (this.clipTo) {\n        this.contextTop.restore();\n      }\n      this.freeDrawingBrush.onMouseUp();\n      this.fire('mouse:up', { e: e });\n\n      var target = this.findTarget(e);\n      if (typeof target !== 'undefined') {\n        target.fire('mouseup', { e: e, target: target });\n      }\n    },\n\n    /**\n     * Method that defines the actions when mouse is clic ked on canvas.\n     * The method inits the currentTransform parameters and renders all the\n     * canvas so the current image can be placed on the top canvas and the rest\n     * in on the container one.\n     * @private\n     * @param {Event} e Event object fired on mousedown\n     */\n    __onMouseDown: function (e) {\n\n      // accept only left clicks\n      var isLeftClick  = 'which' in e ? e.which === 1 : e.button === 0;\n      if (!isLeftClick && !fabric.isTouchSupported) {\n        return;\n      }\n\n      if (this.isDrawingMode) {\n        this._onMouseDownInDrawingMode(e);\n        return;\n      }\n\n      // ignore if some object is being transformed at this moment\n      if (this._currentTransform) {\n        return;\n      }\n\n      var target = this.findTarget(e),\n          pointer = this.getPointer(e, true);\n\n      // save pointer for check in __onMouseUp event\n      this._previousPointer = pointer;\n\n      var shouldRender = this._shouldRender(target, pointer),\n          shouldGroup = this._shouldGroup(e, target);\n\n      if (this._shouldClearSelection(e, target)) {\n        this._clearSelection(e, target, pointer);\n      }\n      else if (shouldGroup) {\n        this._handleGrouping(e, target);\n        target = this.getActiveGroup();\n      }\n\n      if (target) {\n        if (target.selectable && (target.__corner || !shouldGroup)) {\n          this._beforeTransform(e, target);\n          this._setupCurrentTransform(e, target);\n        }\n\n        if (target !== this.getActiveGroup() && target !== this.getActiveObject()) {\n          this.deactivateAll();\n          target.selectable && this.setActiveObject(target, e);\n        }\n      }\n      // we must renderAll so that active image is placed on the top canvas\n      shouldRender && this.renderAll();\n\n      this.fire('mouse:down', { target: target, e: e });\n      target && target.fire('mousedown', { e: e });\n    },\n\n    /**\n     * @private\n     */\n    _beforeTransform: function(e, target) {\n      this.stateful && target.saveState();\n\n      // determine if it's a drag or rotate case\n      if (target._findTargetCorner(this.getPointer(e))) {\n        this.onBeforeScaleRotate(target);\n      }\n\n    },\n\n    /**\n     * @private\n     */\n    _clearSelection: function(e, target, pointer) {\n      this.deactivateAllWithDispatch(e);\n\n      if (target && target.selectable) {\n        this.setActiveObject(target, e);\n      }\n      else if (this.selection) {\n        this._groupSelector = {\n          ex: pointer.x,\n          ey: pointer.y,\n          top: 0,\n          left: 0\n        };\n      }\n    },\n\n    /**\n     * @private\n     * @param {Object} target Object for that origin is set to center\n     */\n    _setOriginToCenter: function(target) {\n      this._previousOriginX = this._currentTransform.target.originX;\n      this._previousOriginY = this._currentTransform.target.originY;\n\n      var center = target.getCenterPoint();\n\n      target.originX = 'center';\n      target.originY = 'center';\n\n      target.left = center.x;\n      target.top = center.y;\n\n      this._currentTransform.left = target.left;\n      this._currentTransform.top = target.top;\n    },\n\n    /**\n     * @private\n     * @param {Object} target Object for that center is set to origin\n     */\n    _setCenterToOrigin: function(target) {\n      var originPoint = target.translateToOriginPoint(\n        target.getCenterPoint(),\n        this._previousOriginX,\n        this._previousOriginY);\n\n      target.originX = this._previousOriginX;\n      target.originY = this._previousOriginY;\n\n      target.left = originPoint.x;\n      target.top = originPoint.y;\n\n      this._previousOriginX = null;\n      this._previousOriginY = null;\n    },\n\n    /**\n     * Method that defines the actions when mouse is hovering the canvas.\n     * The currentTransform parameter will definde whether the user is rotating/scaling/translating\n     * an image or neither of them (only hovering). A group selection is also possible and would cancel\n     * all any other type of action.\n     * In case of an image transformation only the top canvas will be rendered.\n     * @private\n     * @param {Event} e Event object fired on mousemove\n     */\n    __onMouseMove: function (e) {\n\n      var target, pointer;\n\n      if (this.isDrawingMode) {\n        this._onMouseMoveInDrawingMode(e);\n        return;\n      }\n      if (typeof e.touches !== 'undefined' && e.touches.length > 1) {\n        return;\n      }\n\n      var groupSelector = this._groupSelector;\n\n      // We initially clicked in an empty area, so we draw a box for multiple selection\n      if (groupSelector) {\n        pointer = this.getPointer(e, true);\n\n        groupSelector.left = pointer.x - groupSelector.ex;\n        groupSelector.top = pointer.y - groupSelector.ey;\n\n        this.renderTop();\n      }\n      else if (!this._currentTransform) {\n        target = this.findTarget(e);\n        this._setCursorFromEvent(e, target);\n      }\n      else {\n        this._transformObject(e);\n      }\n\n      this.fire('mouse:move', { target: target, e: e });\n      target && target.fire('mousemove', { e: e });\n    },\n\n    /**\n     * @private\n     * @param {Event} e Event fired on mousemove\n     */\n    _transformObject: function(e) {\n      var pointer = this.getPointer(e),\n          transform = this._currentTransform;\n\n      transform.reset = false,\n      transform.target.isMoving = true;\n\n      this._beforeScaleTransform(e, transform);\n      this._performTransformAction(e, transform, pointer);\n\n      this.renderAll();\n    },\n\n    /**\n     * @private\n     */\n    _performTransformAction: function(e, transform, pointer) {\n      var x = pointer.x,\n          y = pointer.y,\n          target = transform.target,\n          action = transform.action,\n          actionPerformed = false;\n\n      if (action === 'rotate') {\n        (actionPerformed = this._rotateObject(x, y)) && this._fire('rotating', target, e);\n      }\n      else if (action === 'scale') {\n        (actionPerformed = this._onScale(e, transform, x, y)) && this._fire('scaling', target, e);\n      }\n      else if (action === 'scaleX') {\n        (actionPerformed = this._scaleObject(x, y, 'x')) && this._fire('scaling', target, e);\n      }\n      else if (action === 'scaleY') {\n        (actionPerformed = this._scaleObject(x, y, 'y')) && this._fire('scaling', target, e);\n      }\n      else if (action === 'skewX') {\n        (actionPerformed = this._skewObject(x, y, 'x')) && this._fire('skewing', target, e);\n      }\n      else if (action === 'skewY') {\n        (actionPerformed = this._skewObject(x, y, 'y')) && this._fire('skewing', target, e);\n      }\n      else {\n        actionPerformed = this._translateObject(x, y);\n        if (actionPerformed) {\n          this._fire('moving', target, e);\n          this.setCursor(target.moveCursor || this.moveCursor);\n        }\n      }\n      transform.actionPerformed = actionPerformed;\n    },\n\n    /**\n     * @private\n     */\n    _fire: function(eventName, target, e) {\n      this.fire('object:' + eventName, { target: target, e: e });\n      target.fire(eventName, { e: e });\n    },\n\n    /**\n     * @private\n     */\n    _beforeScaleTransform: function(e, transform) {\n      if (transform.action === 'scale' || transform.action === 'scaleX' || transform.action === 'scaleY') {\n        var centerTransform = this._shouldCenterTransform(transform.target);\n\n        // Switch from a normal resize to center-based\n        if ((centerTransform && (transform.originX !== 'center' || transform.originY !== 'center')) ||\n           // Switch from center-based resize to normal one\n           (!centerTransform && transform.originX === 'center' && transform.originY === 'center')\n        ) {\n          this._resetCurrentTransform();\n          transform.reset = true;\n        }\n      }\n    },\n\n    /**\n     * @private\n     * @return {Boolean} true if the scaling occurred\n     */\n    _onScale: function(e, transform, x, y) {\n      // rotate object only if shift key is not pressed\n      // and if it is not a group we are transforming\n      if ((e[this.uniScaleKey] || this.uniScaleTransform) && !transform.target.get('lockUniScaling')) {\n        transform.currentAction = 'scale';\n        return this._scaleObject(x, y);\n      }\n      else {\n        // Switch from a normal resize to proportional\n        if (!transform.reset && transform.currentAction === 'scale') {\n          this._resetCurrentTransform();\n        }\n\n        transform.currentAction = 'scaleEqually';\n        return this._scaleObject(x, y, 'equally');\n      }\n    },\n\n    /**\n     * Sets the cursor depending on where the canvas is being hovered.\n     * Note: very buggy in Opera\n     * @param {Event} e Event object\n     * @param {Object} target Object that the mouse is hovering, if so.\n     */\n    _setCursorFromEvent: function (e, target) {\n      if (!target) {\n        this.setCursor(this.defaultCursor);\n        return false;\n      }\n\n      var hoverCursor = target.hoverCursor || this.hoverCursor;\n      if (!target.selectable) {\n        //let's skip _findTargetCorner if object is not selectable\n        this.setCursor(hoverCursor);\n      }\n      else {\n        var activeGroup = this.getActiveGroup(),\n            // only show proper corner when group selection is not active\n            corner = target._findTargetCorner\n                      && (!activeGroup || !activeGroup.contains(target))\n                      && target._findTargetCorner(this.getPointer(e, true));\n\n        if (!corner) {\n          this.setCursor(hoverCursor);\n        }\n        else {\n          this._setCornerCursor(corner, target, e);\n        }\n      }\n      //actually unclear why it should return something\n      //is never evaluated\n      return true;\n    },\n\n    /**\n     * @private\n     */\n    _setCornerCursor: function(corner, target, e) {\n      if (corner in cursorOffset) {\n        this.setCursor(this._getRotatedCornerCursor(corner, target, e));\n      }\n      else if (corner === 'mtr' && target.hasRotatingPoint) {\n        this.setCursor(this.rotationCursor);\n      }\n      else {\n        this.setCursor(this.defaultCursor);\n        return false;\n      }\n    },\n\n    /**\n     * @private\n     */\n    _getRotatedCornerCursor: function(corner, target, e) {\n      var n = Math.round((target.getAngle() % 360) / 45);\n\n      if (n < 0) {\n        n += 8; // full circle ahead\n      }\n      n += cursorOffset[corner];\n      if (e[this.altActionKey] && cursorOffset[corner] % 2 === 0) {\n        //if we are holding shift and we are on a mx corner...\n        n += 2;\n      }\n      // normalize n to be from 0 to 7\n      n %= 8;\n\n      return this.cursorMap[n];\n    }\n  });\n})();\n\n\n(function() {\n\n  var min = Math.min,\n      max = Math.max;\n\n  fabric.util.object.extend(fabric.Canvas.prototype, /** @lends fabric.Canvas.prototype */ {\n\n    /**\n     * @private\n     * @param {Event} e Event object\n     * @param {fabric.Object} target\n     * @return {Boolean}\n     */\n    _shouldGroup: function(e, target) {\n      var activeObject = this.getActiveObject();\n      return e[this.selectionKey] && target && target.selectable &&\n            (this.getActiveGroup() || (activeObject && activeObject !== target))\n            && this.selection;\n    },\n\n    /**\n     * @private\n     * @param {Event} e Event object\n     * @param {fabric.Object} target\n     */\n    _handleGrouping: function (e, target) {\n\n      if (target === this.getActiveGroup()) {\n\n        // if it's a group, find target again, this time skipping group\n        target = this.findTarget(e, true);\n\n        // if even object is not found, bail out\n        if (!target || target.isType('group')) {\n          return;\n        }\n      }\n      if (this.getActiveGroup()) {\n        this._updateActiveGroup(target, e);\n      }\n      else {\n        this._createActiveGroup(target, e);\n      }\n\n      if (this._activeGroup) {\n        this._activeGroup.saveCoords();\n      }\n    },\n\n    /**\n     * @private\n     */\n    _updateActiveGroup: function(target, e) {\n      var activeGroup = this.getActiveGroup();\n\n      if (activeGroup.contains(target)) {\n\n        activeGroup.removeWithUpdate(target);\n        target.set('active', false);\n\n        if (activeGroup.size() === 1) {\n          // remove group alltogether if after removal it only contains 1 object\n          this.discardActiveGroup(e);\n          // activate last remaining object\n          this.setActiveObject(activeGroup.item(0));\n          return;\n        }\n      }\n      else {\n        activeGroup.addWithUpdate(target);\n      }\n      this.fire('selection:created', { target: activeGroup, e: e });\n      activeGroup.set('active', true);\n    },\n\n    /**\n     * @private\n     */\n    _createActiveGroup: function(target, e) {\n\n      if (this._activeObject && target !== this._activeObject) {\n\n        var group = this._createGroup(target);\n        group.addWithUpdate();\n\n        this.setActiveGroup(group);\n        this._activeObject = null;\n\n        this.fire('selection:created', { target: group, e: e });\n      }\n\n      target.set('active', true);\n    },\n\n    /**\n     * @private\n     * @param {Object} target\n     */\n    _createGroup: function(target) {\n\n      var objects = this.getObjects(),\n          isActiveLower = objects.indexOf(this._activeObject) < objects.indexOf(target),\n          groupObjects = isActiveLower\n            ? [ this._activeObject, target ]\n            : [ target, this._activeObject ];\n\n      return new fabric.Group(groupObjects, {\n        canvas: this\n      });\n    },\n\n    /**\n     * @private\n     * @param {Event} e mouse event\n     */\n    _groupSelectedObjects: function (e) {\n\n      var group = this._collectObjects();\n\n      // do not create group for 1 element only\n      if (group.length === 1) {\n        this.setActiveObject(group[0], e);\n      }\n      else if (group.length > 1) {\n        group = new fabric.Group(group.reverse(), {\n          canvas: this\n        });\n        group.addWithUpdate();\n        this.setActiveGroup(group, e);\n        group.saveCoords();\n        this.fire('selection:created', { target: group });\n        this.renderAll();\n      }\n    },\n\n    /**\n     * @private\n     */\n    _collectObjects: function() {\n      var group = [ ],\n          currentObject,\n          x1 = this._groupSelector.ex,\n          y1 = this._groupSelector.ey,\n          x2 = x1 + this._groupSelector.left,\n          y2 = y1 + this._groupSelector.top,\n          selectionX1Y1 = new fabric.Point(min(x1, x2), min(y1, y2)),\n          selectionX2Y2 = new fabric.Point(max(x1, x2), max(y1, y2)),\n          isClick = x1 === x2 && y1 === y2;\n\n      for (var i = this._objects.length; i--; ) {\n        currentObject = this._objects[i];\n\n        if (!currentObject || !currentObject.selectable || !currentObject.visible) {\n          continue;\n        }\n\n        if (currentObject.intersectsWithRect(selectionX1Y1, selectionX2Y2) ||\n            currentObject.isContainedWithinRect(selectionX1Y1, selectionX2Y2) ||\n            currentObject.containsPoint(selectionX1Y1) ||\n            currentObject.containsPoint(selectionX2Y2)\n        ) {\n          currentObject.set('active', true);\n          group.push(currentObject);\n\n          // only add one object if it's a click\n          if (isClick) {\n            break;\n          }\n        }\n      }\n\n      return group;\n    },\n\n    /**\n     * @private\n     */\n    _maybeGroupObjects: function(e) {\n      if (this.selection && this._groupSelector) {\n        this._groupSelectedObjects(e);\n      }\n\n      var activeGroup = this.getActiveGroup();\n      if (activeGroup) {\n        activeGroup.setObjectsCoords().setCoords();\n        activeGroup.isMoving = false;\n        this.setCursor(this.defaultCursor);\n      }\n\n      // clear selection and current transformation\n      this._groupSelector = null;\n      this._currentTransform = null;\n    }\n  });\n\n})();\n\n\nfabric.util.object.extend(fabric.StaticCanvas.prototype, /** @lends fabric.StaticCanvas.prototype */ {\n\n  /**\n   * Exports canvas element to a dataurl image. Note that when multiplier is used, cropping is scaled appropriately\n   * @param {Object} [options] Options object\n   * @param {String} [options.format=png] The format of the output image. Either \"jpeg\" or \"png\"\n   * @param {Number} [options.quality=1] Quality level (0..1). Only used for jpeg.\n   * @param {Number} [options.multiplier=1] Multiplier to scale by\n   * @param {Number} [options.left] Cropping left offset. Introduced in v1.2.14\n   * @param {Number} [options.top] Cropping top offset. Introduced in v1.2.14\n   * @param {Number} [options.width] Cropping width. Introduced in v1.2.14\n   * @param {Number} [options.height] Cropping height. Introduced in v1.2.14\n   * @return {String} Returns a data: URL containing a representation of the object in the format specified by options.format\n   * @see {@link http://jsfiddle.net/fabricjs/NfZVb/|jsFiddle demo}\n   * @example <caption>Generate jpeg dataURL with lower quality</caption>\n   * var dataURL = canvas.toDataURL({\n   *   format: 'jpeg',\n   *   quality: 0.8\n   * });\n   * @example <caption>Generate cropped png dataURL (clipping of canvas)</caption>\n   * var dataURL = canvas.toDataURL({\n   *   format: 'png',\n   *   left: 100,\n   *   top: 100,\n   *   width: 200,\n   *   height: 200\n   * });\n   * @example <caption>Generate double scaled png dataURL</caption>\n   * var dataURL = canvas.toDataURL({\n   *   format: 'png',\n   *   multiplier: 2\n   * });\n   */\n  toDataURL: function (options) {\n    options || (options = { });\n\n    var format = options.format || 'png',\n        quality = options.quality || 1,\n        multiplier = options.multiplier || 1,\n        cropping = {\n          left: options.left,\n          top: options.top,\n          width: options.width,\n          height: options.height\n        };\n\n    if (this._isRetinaScaling()) {\n      multiplier *= fabric.devicePixelRatio;\n    }\n\n    if (multiplier !== 1) {\n      return this.__toDataURLWithMultiplier(format, quality, cropping, multiplier);\n    }\n    else {\n      return this.__toDataURL(format, quality, cropping);\n    }\n  },\n\n  /**\n   * @private\n   */\n  __toDataURL: function(format, quality, cropping) {\n\n    this.renderAll();\n\n    var canvasEl = this.contextContainer.canvas,\n        croppedCanvasEl = this.__getCroppedCanvas(canvasEl, cropping);\n\n    // to avoid common confusion https://github.com/kangax/fabric.js/issues/806\n    if (format === 'jpg') {\n      format = 'jpeg';\n    }\n\n    var data = (fabric.StaticCanvas.supports('toDataURLWithQuality'))\n              ? (croppedCanvasEl || canvasEl).toDataURL('image/' + format, quality)\n              : (croppedCanvasEl || canvasEl).toDataURL('image/' + format);\n\n    if (croppedCanvasEl) {\n      croppedCanvasEl = null;\n    }\n\n    return data;\n  },\n\n  /**\n   * @private\n   */\n  __getCroppedCanvas: function(canvasEl, cropping) {\n\n    var croppedCanvasEl,\n        croppedCtx,\n        shouldCrop = 'left' in cropping ||\n                     'top' in cropping ||\n                     'width' in cropping ||\n                     'height' in cropping;\n\n    if (shouldCrop) {\n\n      croppedCanvasEl = fabric.util.createCanvasElement();\n      croppedCtx = croppedCanvasEl.getContext('2d');\n\n      croppedCanvasEl.width = cropping.width || this.width;\n      croppedCanvasEl.height = cropping.height || this.height;\n\n      croppedCtx.drawImage(canvasEl, -cropping.left || 0, -cropping.top || 0);\n    }\n\n    return croppedCanvasEl;\n  },\n\n  /**\n   * @private\n   */\n  __toDataURLWithMultiplier: function(format, quality, cropping, multiplier) {\n\n    var origWidth = this.getWidth(),\n        origHeight = this.getHeight(),\n        scaledWidth = origWidth * multiplier,\n        scaledHeight = origHeight * multiplier,\n        activeObject = this.getActiveObject(),\n        activeGroup = this.getActiveGroup(),\n        zoom = this.getZoom(),\n        newZoom = zoom * multiplier / fabric.devicePixelRatio;\n\n    if (multiplier > 1) {\n      this.setDimensions({ width: scaledWidth, height: scaledHeight });\n    }\n\n    this.setZoom(newZoom);\n\n    if (cropping.left) {\n      cropping.left *= multiplier;\n    }\n    if (cropping.top) {\n      cropping.top *= multiplier;\n    }\n    if (cropping.width) {\n      cropping.width *= multiplier;\n    }\n    else if (multiplier < 1) {\n      cropping.width = scaledWidth;\n    }\n    if (cropping.height) {\n      cropping.height *= multiplier;\n    }\n    else if (multiplier < 1) {\n      cropping.height = scaledHeight;\n    }\n\n    if (activeGroup) {\n      // not removing group due to complications with restoring it with correct state afterwords\n      this._tempRemoveBordersControlsFromGroup(activeGroup);\n    }\n    else if (activeObject && this.deactivateAll) {\n      this.deactivateAll();\n    }\n\n    var data = this.__toDataURL(format, quality, cropping);\n    if (activeGroup) {\n      this._restoreBordersControlsOnGroup(activeGroup);\n    }\n    else if (activeObject && this.setActiveObject) {\n      this.setActiveObject(activeObject);\n    }\n    this.setZoom(zoom);\n    //setDimensions with no option object is taking care of:\n    //this.width, this.height, this.renderAll()\n    this.setDimensions({ width: origWidth, height: origHeight });\n\n    return data;\n  },\n\n  /**\n   * Exports canvas element to a dataurl image (allowing to change image size via multiplier).\n   * @deprecated since 1.0.13\n   * @param {String} format (png|jpeg)\n   * @param {Number} multiplier\n   * @param {Number} quality (0..1)\n   * @return {String}\n   */\n  toDataURLWithMultiplier: function (format, multiplier, quality) {\n    return this.toDataURL({\n      format: format,\n      multiplier: multiplier,\n      quality: quality\n    });\n  },\n\n  /**\n   * @private\n   */\n  _tempRemoveBordersControlsFromGroup: function(group) {\n    group.origHasControls = group.hasControls;\n    group.origBorderColor = group.borderColor;\n\n    group.hasControls = true;\n    group.borderColor = 'rgba(0,0,0,0)';\n\n    group.forEachObject(function(o) {\n      o.origBorderColor = o.borderColor;\n      o.borderColor = 'rgba(0,0,0,0)';\n    });\n  },\n\n  /**\n   * @private\n   */\n  _restoreBordersControlsOnGroup: function(group) {\n    group.hideControls = group.origHideControls;\n    group.borderColor = group.origBorderColor;\n\n    group.forEachObject(function(o) {\n      o.borderColor = o.origBorderColor;\n      delete o.origBorderColor;\n    });\n  }\n});\n\n\nfabric.util.object.extend(fabric.StaticCanvas.prototype, /** @lends fabric.StaticCanvas.prototype */ {\n\n  /**\n   * Populates canvas with data from the specified dataless JSON.\n   * JSON format must conform to the one of {@link fabric.Canvas#toDatalessJSON}\n   * @deprecated since 1.2.2\n   * @param {String|Object} json JSON string or object\n   * @param {Function} callback Callback, invoked when json is parsed\n   *                            and corresponding objects (e.g: {@link fabric.Image})\n   *                            are initialized\n   * @param {Function} [reviver] Method for further parsing of JSON elements, called after each fabric object created.\n   * @return {fabric.Canvas} instance\n   * @chainable\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-3#deserialization}\n   */\n  loadFromDatalessJSON: function (json, callback, reviver) {\n    return this.loadFromJSON(json, callback, reviver);\n  },\n\n  /**\n   * Populates canvas with data from the specified JSON.\n   * JSON format must conform to the one of {@link fabric.Canvas#toJSON}\n   * @param {String|Object} json JSON string or object\n   * @param {Function} callback Callback, invoked when json is parsed\n   *                            and corresponding objects (e.g: {@link fabric.Image})\n   *                            are initialized\n   * @param {Function} [reviver] Method for further parsing of JSON elements, called after each fabric object created.\n   * @return {fabric.Canvas} instance\n   * @chainable\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-3#deserialization}\n   * @see {@link http://jsfiddle.net/fabricjs/fmgXt/|jsFiddle demo}\n   * @example <caption>loadFromJSON</caption>\n   * canvas.loadFromJSON(json, canvas.renderAll.bind(canvas));\n   * @example <caption>loadFromJSON with reviver</caption>\n   * canvas.loadFromJSON(json, canvas.renderAll.bind(canvas), function(o, object) {\n   *   // `o` = json object\n   *   // `object` = fabric.Object instance\n   *   // ... do some stuff ...\n   * });\n   */\n  loadFromJSON: function (json, callback, reviver) {\n    if (!json) {\n      return;\n    }\n\n    // serialize if it wasn't already\n    var serialized = (typeof json === 'string')\n      ? JSON.parse(json)\n      : fabric.util.object.clone(json);\n\n    this.clear();\n\n    var _this = this;\n    this._enlivenObjects(serialized.objects, function () {\n      _this._setBgOverlay(serialized, callback);\n    }, reviver);\n    // remove parts i cannot set as options\n    delete serialized.objects;\n    delete serialized.backgroundImage;\n    delete serialized.overlayImage;\n    delete serialized.background;\n    delete serialized.overlay;\n    // this._initOptions does too many things to just\n    // call it. Normally loading an Object from JSON\n    // create the Object instance. Here the Canvas is\n    // already an instance and we are just loading things over it\n    for (var prop in serialized) {\n      this[prop] = serialized[prop];\n    }\n    return this;\n  },\n\n  /**\n   * @private\n   * @param {Object} serialized Object with background and overlay information\n   * @param {Function} callback Invoked after all background and overlay images/patterns loaded\n   */\n  _setBgOverlay: function(serialized, callback) {\n    var _this = this,\n        loaded = {\n          backgroundColor: false,\n          overlayColor: false,\n          backgroundImage: false,\n          overlayImage: false\n        };\n\n    if (!serialized.backgroundImage && !serialized.overlayImage && !serialized.background && !serialized.overlay) {\n      callback && callback();\n      return;\n    }\n\n    var cbIfLoaded = function () {\n      if (loaded.backgroundImage && loaded.overlayImage && loaded.backgroundColor && loaded.overlayColor) {\n        _this.renderAll();\n        callback && callback();\n      }\n    };\n\n    this.__setBgOverlay('backgroundImage', serialized.backgroundImage, loaded, cbIfLoaded);\n    this.__setBgOverlay('overlayImage', serialized.overlayImage, loaded, cbIfLoaded);\n    this.__setBgOverlay('backgroundColor', serialized.background, loaded, cbIfLoaded);\n    this.__setBgOverlay('overlayColor', serialized.overlay, loaded, cbIfLoaded);\n\n    cbIfLoaded();\n  },\n\n  /**\n   * @private\n   * @param {String} property Property to set (backgroundImage, overlayImage, backgroundColor, overlayColor)\n   * @param {(Object|String)} value Value to set\n   * @param {Object} loaded Set loaded property to true if property is set\n   * @param {Object} callback Callback function to invoke after property is set\n   */\n  __setBgOverlay: function(property, value, loaded, callback) {\n    var _this = this;\n\n    if (!value) {\n      loaded[property] = true;\n      return;\n    }\n\n    if (property === 'backgroundImage' || property === 'overlayImage') {\n      fabric.Image.fromObject(value, function(img) {\n        _this[property] = img;\n        loaded[property] = true;\n        callback && callback();\n      });\n    }\n    else {\n      this['set' + fabric.util.string.capitalize(property, true)](value, function() {\n        loaded[property] = true;\n        callback && callback();\n      });\n    }\n  },\n\n  /**\n   * @private\n   * @param {Array} objects\n   * @param {Function} callback\n   * @param {Function} [reviver]\n   */\n  _enlivenObjects: function (objects, callback, reviver) {\n    var _this = this;\n\n    if (!objects || objects.length === 0) {\n      callback && callback();\n      return;\n    }\n\n    var renderOnAddRemove = this.renderOnAddRemove;\n    this.renderOnAddRemove = false;\n\n    fabric.util.enlivenObjects(objects, function(enlivenedObjects) {\n      enlivenedObjects.forEach(function(obj, index) {\n        _this.insertAt(obj, index, true);\n      });\n\n      _this.renderOnAddRemove = renderOnAddRemove;\n      callback && callback();\n    }, null, reviver);\n  },\n\n  /**\n   * @private\n   * @param {String} format\n   * @param {Function} callback\n   */\n  _toDataURL: function (format, callback) {\n    this.clone(function (clone) {\n      callback(clone.toDataURL(format));\n    });\n  },\n\n  /**\n   * @private\n   * @param {String} format\n   * @param {Number} multiplier\n   * @param {Function} callback\n   */\n  _toDataURLWithMultiplier: function (format, multiplier, callback) {\n    this.clone(function (clone) {\n      callback(clone.toDataURLWithMultiplier(format, multiplier));\n    });\n  },\n\n  /**\n   * Clones canvas instance\n   * @param {Object} [callback] Receives cloned instance as a first argument\n   * @param {Array} [properties] Array of properties to include in the cloned canvas and children\n   */\n  clone: function (callback, properties) {\n    var data = JSON.stringify(this.toJSON(properties));\n    this.cloneWithoutData(function(clone) {\n      clone.loadFromJSON(data, function() {\n        callback && callback(clone);\n      });\n    });\n  },\n\n  /**\n   * Clones canvas instance without cloning existing data.\n   * This essentially copies canvas dimensions, clipping properties, etc.\n   * but leaves data empty (so that you can populate it with your own)\n   * @param {Object} [callback] Receives cloned instance as a first argument\n   */\n  cloneWithoutData: function(callback) {\n    var el = fabric.document.createElement('canvas');\n\n    el.width = this.getWidth();\n    el.height = this.getHeight();\n\n    var clone = new fabric.Canvas(el);\n    clone.clipTo = this.clipTo;\n    if (this.backgroundImage) {\n      clone.setBackgroundImage(this.backgroundImage.src, function() {\n        clone.renderAll();\n        callback && callback(clone);\n      });\n      clone.backgroundImageOpacity = this.backgroundImageOpacity;\n      clone.backgroundImageStretch = this.backgroundImageStretch;\n    }\n    else {\n      callback && callback(clone);\n    }\n  }\n});\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend,\n      toFixed = fabric.util.toFixed,\n      capitalize = fabric.util.string.capitalize,\n      degreesToRadians = fabric.util.degreesToRadians,\n      supportsLineDash = fabric.StaticCanvas.supports('setLineDash');\n\n  if (fabric.Object) {\n    return;\n  }\n\n  /**\n   * Root object class from which all 2d shape classes inherit from\n   * @class fabric.Object\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-1#objects}\n   * @see {@link fabric.Object#initialize} for constructor definition\n   *\n   * @fires added\n   * @fires removed\n   *\n   * @fires selected\n   * @fires modified\n   * @fires rotating\n   * @fires scaling\n   * @fires moving\n   * @fires skewing\n   *\n   * @fires mousedown\n   * @fires mouseup\n   * @fires mouseover\n   * @fires mouseout\n   */\n  fabric.Object = fabric.util.createClass(/** @lends fabric.Object.prototype */ {\n\n    /**\n     * Retrieves object's {@link fabric.Object#clipTo|clipping function}\n     * @method getClipTo\n     * @memberOf fabric.Object.prototype\n     * @return {Function}\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#clipTo|clipping function}\n     * @method setClipTo\n     * @memberOf fabric.Object.prototype\n     * @param {Function} clipTo Clipping function\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#transformMatrix|transformMatrix}\n     * @method getTransformMatrix\n     * @memberOf fabric.Object.prototype\n     * @return {Array} transformMatrix\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#transformMatrix|transformMatrix}\n     * @method setTransformMatrix\n     * @memberOf fabric.Object.prototype\n     * @param {Array} transformMatrix\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#visible|visible} state\n     * @method getVisible\n     * @memberOf fabric.Object.prototype\n     * @return {Boolean} True if visible\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#visible|visible} state\n     * @method setVisible\n     * @memberOf fabric.Object.prototype\n     * @param {Boolean} value visible value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#shadow|shadow}\n     * @method getShadow\n     * @memberOf fabric.Object.prototype\n     * @return {Object} Shadow instance\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#stroke|stroke}\n     * @method getStroke\n     * @memberOf fabric.Object.prototype\n     * @return {String} stroke value\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#stroke|stroke}\n     * @method setStroke\n     * @memberOf fabric.Object.prototype\n     * @param {String} value stroke value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#strokeWidth|strokeWidth}\n     * @method getStrokeWidth\n     * @memberOf fabric.Object.prototype\n     * @return {Number} strokeWidth value\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#strokeWidth|strokeWidth}\n     * @method setStrokeWidth\n     * @memberOf fabric.Object.prototype\n     * @param {Number} value strokeWidth value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#originX|originX}\n     * @method getOriginX\n     * @memberOf fabric.Object.prototype\n     * @return {String} originX value\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#originX|originX}\n     * @method setOriginX\n     * @memberOf fabric.Object.prototype\n     * @param {String} value originX value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#originY|originY}\n     * @method getOriginY\n     * @memberOf fabric.Object.prototype\n     * @return {String} originY value\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#originY|originY}\n     * @method setOriginY\n     * @memberOf fabric.Object.prototype\n     * @param {String} value originY value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#fill|fill}\n     * @method getFill\n     * @memberOf fabric.Object.prototype\n     * @return {String} Fill value\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#fill|fill}\n     * @method setFill\n     * @memberOf fabric.Object.prototype\n     * @param {String} value Fill value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#opacity|opacity}\n     * @method getOpacity\n     * @memberOf fabric.Object.prototype\n     * @return {Number} Opacity value (0-1)\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#opacity|opacity}\n     * @method setOpacity\n     * @memberOf fabric.Object.prototype\n     * @param {Number} value Opacity value (0-1)\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#angle|angle} (in degrees)\n     * @method getAngle\n     * @memberOf fabric.Object.prototype\n     * @return {Number}\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#top|top position}\n     * @method getTop\n     * @memberOf fabric.Object.prototype\n     * @return {Number} Top value (in pixels)\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#top|top position}\n     * @method setTop\n     * @memberOf fabric.Object.prototype\n     * @param {Number} value Top value (in pixels)\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#left|left position}\n     * @method getLeft\n     * @memberOf fabric.Object.prototype\n     * @return {Number} Left value (in pixels)\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#left|left position}\n     * @method setLeft\n     * @memberOf fabric.Object.prototype\n     * @param {Number} value Left value (in pixels)\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#scaleX|scaleX} value\n     * @method getScaleX\n     * @memberOf fabric.Object.prototype\n     * @return {Number} scaleX value\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#scaleX|scaleX} value\n     * @method setScaleX\n     * @memberOf fabric.Object.prototype\n     * @param {Number} value scaleX value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#scaleY|scaleY} value\n     * @method getScaleY\n     * @memberOf fabric.Object.prototype\n     * @return {Number} scaleY value\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#scaleY|scaleY} value\n     * @method setScaleY\n     * @memberOf fabric.Object.prototype\n     * @param {Number} value scaleY value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#flipX|flipX} value\n     * @method getFlipX\n     * @memberOf fabric.Object.prototype\n     * @return {Boolean} flipX value\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#flipX|flipX} value\n     * @method setFlipX\n     * @memberOf fabric.Object.prototype\n     * @param {Boolean} value flipX value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's {@link fabric.Object#flipY|flipY} value\n     * @method getFlipY\n     * @memberOf fabric.Object.prototype\n     * @return {Boolean} flipY value\n     */\n\n    /**\n     * Sets object's {@link fabric.Object#flipY|flipY} value\n     * @method setFlipY\n     * @memberOf fabric.Object.prototype\n     * @param {Boolean} value flipY value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n\n    /**\n     * Type of an object (rect, circle, path, etc.).\n     * Note that this property is meant to be read-only and not meant to be modified.\n     * If you modify, certain parts of Fabric (such as JSON loading) won't work correctly.\n     * @type String\n     * @default\n     */\n    type:                     'object',\n\n    /**\n     * Horizontal origin of transformation of an object (one of \"left\", \"right\", \"center\")\n     * See http://jsfiddle.net/1ow02gea/40/ on how originX/originY affect objects in groups\n     * @type String\n     * @default\n     */\n    originX:                  'left',\n\n    /**\n     * Vertical origin of transformation of an object (one of \"top\", \"bottom\", \"center\")\n     * See http://jsfiddle.net/1ow02gea/40/ on how originX/originY affect objects in groups\n     * @type String\n     * @default\n     */\n    originY:                  'top',\n\n    /**\n     * Top position of an object. Note that by default it's relative to object top. You can change this by setting originY={top/center/bottom}\n     * @type Number\n     * @default\n     */\n    top:                      0,\n\n    /**\n     * Left position of an object. Note that by default it's relative to object left. You can change this by setting originX={left/center/right}\n     * @type Number\n     * @default\n     */\n    left:                     0,\n\n    /**\n     * Object width\n     * @type Number\n     * @default\n     */\n    width:                    0,\n\n    /**\n     * Object height\n     * @type Number\n     * @default\n     */\n    height:                   0,\n\n    /**\n     * Object scale factor (horizontal)\n     * @type Number\n     * @default\n     */\n    scaleX:                   1,\n\n    /**\n     * Object scale factor (vertical)\n     * @type Number\n     * @default\n     */\n    scaleY:                   1,\n\n    /**\n     * When true, an object is rendered as flipped horizontally\n     * @type Boolean\n     * @default\n     */\n    flipX:                    false,\n\n    /**\n     * When true, an object is rendered as flipped vertically\n     * @type Boolean\n     * @default\n     */\n    flipY:                    false,\n\n    /**\n     * Opacity of an object\n     * @type Number\n     * @default\n     */\n    opacity:                  1,\n\n    /**\n     * Angle of rotation of an object (in degrees)\n     * @type Number\n     * @default\n     */\n    angle:                    0,\n\n    /**\n     * Angle of skew on x axes of an object (in degrees)\n     * @type Number\n     * @default\n     */\n    skewX:                    0,\n\n    /**\n     * Angle of skew on y axes of an object (in degrees)\n     * @type Number\n     * @default\n     */\n    skewY:                    0,\n\n    /**\n     * Size of object's controlling corners (in pixels)\n     * @type Number\n     * @default\n     */\n    cornerSize:               13,\n\n    /**\n     * When true, object's controlling corners are rendered as transparent inside (i.e. stroke instead of fill)\n     * @type Boolean\n     * @default\n     */\n    transparentCorners:       true,\n\n    /**\n     * Default cursor value used when hovering over this object on canvas\n     * @type String\n     * @default\n     */\n    hoverCursor:              null,\n\n    /**\n     * Default cursor value used when moving this object on canvas\n     * @type String\n     * @default\n     */\n    moveCursor:               null,\n\n    /**\n     * Padding between object and its controlling borders (in pixels)\n     * @type Number\n     * @default\n     */\n    padding:                  0,\n\n    /**\n     * Color of controlling borders of an object (when it's active)\n     * @type String\n     * @default\n     */\n    borderColor:              'rgba(102,153,255,0.75)',\n\n    /**\n     * Array specifying dash pattern of an object's borders (hasBorder must be true)\n     * @since 1.6.2\n     * @type Array\n     */\n    borderDashArray:          null,\n\n    /**\n     * Color of controlling corners of an object (when it's active)\n     * @type String\n     * @default\n     */\n    cornerColor:              'rgba(102,153,255,0.5)',\n\n    /**\n     * Color of controlling corners of an object (when it's active and transparentCorners false)\n     * @since 1.6.2\n     * @type String\n     * @default\n     */\n    cornerStrokeColor:        null,\n\n    /**\n     * Specify style of control, 'rect' or 'circle'\n     * @since 1.6.2\n     * @type String\n     */\n    cornerStyle:          'rect',\n\n    /**\n     * Array specifying dash pattern of an object's control (hasBorder must be true)\n     * @since 1.6.2\n     * @type Array\n     */\n    cornerDashArray:          null,\n\n    /**\n     * When true, this object will use center point as the origin of transformation\n     * when being scaled via the controls.\n     * <b>Backwards incompatibility note:</b> This property replaces \"centerTransform\" (Boolean).\n     * @since 1.3.4\n     * @type Boolean\n     * @default\n     */\n    centeredScaling:          false,\n\n    /**\n     * When true, this object will use center point as the origin of transformation\n     * when being rotated via the controls.\n     * <b>Backwards incompatibility note:</b> This property replaces \"centerTransform\" (Boolean).\n     * @since 1.3.4\n     * @type Boolean\n     * @default\n     */\n    centeredRotation:         true,\n\n    /**\n     * Color of object's fill\n     * @type String\n     * @default\n     */\n    fill:                     'rgb(0,0,0)',\n\n    /**\n     * Fill rule used to fill an object\n     * accepted values are nonzero, evenodd\n     * <b>Backwards incompatibility note:</b> This property was used for setting globalCompositeOperation until v1.4.12 (use `fabric.Object#globalCompositeOperation` instead)\n     * @type String\n     * @default\n     */\n    fillRule:                 'nonzero',\n\n    /**\n     * Composite rule used for canvas globalCompositeOperation\n     * @type String\n     * @default\n     */\n    globalCompositeOperation: 'source-over',\n\n    /**\n     * Background color of an object. Only works with text objects at the moment.\n     * @type String\n     * @default\n     */\n    backgroundColor:          '',\n\n    /**\n     * Selection Background color of an object. colored layer behind the object when it is active.\n     * does not mix good with globalCompositeOperation methods.\n     * @type String\n     * @default\n     */\n    selectionBackgroundColor:          '',\n\n    /**\n     * When defined, an object is rendered via stroke and this property specifies its color\n     * @type String\n     * @default\n     */\n    stroke:                   null,\n\n    /**\n     * Width of a stroke used to render this object\n     * @type Number\n     * @default\n     */\n    strokeWidth:              1,\n\n    /**\n     * Array specifying dash pattern of an object's stroke (stroke must be defined)\n     * @type Array\n     */\n    strokeDashArray:          null,\n\n    /**\n     * Line endings style of an object's stroke (one of \"butt\", \"round\", \"square\")\n     * @type String\n     * @default\n     */\n    strokeLineCap:            'butt',\n\n    /**\n     * Corner style of an object's stroke (one of \"bevil\", \"round\", \"miter\")\n     * @type String\n     * @default\n     */\n    strokeLineJoin:           'miter',\n\n    /**\n     * Maximum miter length (used for strokeLineJoin = \"miter\") of an object's stroke\n     * @type Number\n     * @default\n     */\n    strokeMiterLimit:         10,\n\n    /**\n     * Shadow object representing shadow of this shape\n     * @type fabric.Shadow\n     * @default\n     */\n    shadow:                   null,\n\n    /**\n     * Opacity of object's controlling borders when object is active and moving\n     * @type Number\n     * @default\n     */\n    borderOpacityWhenMoving:  0.4,\n\n    /**\n     * Scale factor of object's controlling borders\n     * @type Number\n     * @default\n     */\n    borderScaleFactor:        1,\n\n    /**\n     * Transform matrix (similar to SVG's transform matrix)\n     * @type Array\n     */\n    transformMatrix:          null,\n\n    /**\n     * Minimum allowed scale value of an object\n     * @type Number\n     * @default\n     */\n    minScaleLimit:            0.01,\n\n    /**\n     * When set to `false`, an object can not be selected for modification (using either point-click-based or group-based selection).\n     * But events still fire on it.\n     * @type Boolean\n     * @default\n     */\n    selectable:               true,\n\n    /**\n     * When set to `false`, an object can not be a target of events. All events propagate through it. Introduced in v1.3.4\n     * @type Boolean\n     * @default\n     */\n    evented:                  true,\n\n    /**\n     * When set to `false`, an object is not rendered on canvas\n     * @type Boolean\n     * @default\n     */\n    visible:                  true,\n\n    /**\n     * When set to `false`, object's controls are not displayed and can not be used to manipulate object\n     * @type Boolean\n     * @default\n     */\n    hasControls:              true,\n\n    /**\n     * When set to `false`, object's controlling borders are not rendered\n     * @type Boolean\n     * @default\n     */\n    hasBorders:               true,\n\n    /**\n     * When set to `false`, object's controlling rotating point will not be visible or selectable\n     * @type Boolean\n     * @default\n     */\n    hasRotatingPoint:         true,\n\n    /**\n     * Offset for object's controlling rotating point (when enabled via `hasRotatingPoint`)\n     * @type Number\n     * @default\n     */\n    rotatingPointOffset:      40,\n\n    /**\n     * When set to `true`, objects are \"found\" on canvas on per-pixel basis rather than according to bounding box\n     * @type Boolean\n     * @default\n     */\n    perPixelTargetFind:       false,\n\n    /**\n     * When `false`, default object's values are not included in its serialization\n     * @type Boolean\n     * @default\n     */\n    includeDefaultValues:     true,\n\n    /**\n     * Function that determines clipping of an object (context is passed as a first argument)\n     * Note that context origin is at the object's center point (not left/top corner)\n     * @type Function\n     */\n    clipTo:                   null,\n\n    /**\n     * When `true`, object horizontal movement is locked\n     * @type Boolean\n     * @default\n     */\n    lockMovementX:            false,\n\n    /**\n     * When `true`, object vertical movement is locked\n     * @type Boolean\n     * @default\n     */\n    lockMovementY:            false,\n\n    /**\n     * When `true`, object rotation is locked\n     * @type Boolean\n     * @default\n     */\n    lockRotation:             false,\n\n    /**\n     * When `true`, object horizontal scaling is locked\n     * @type Boolean\n     * @default\n     */\n    lockScalingX:             false,\n\n    /**\n     * When `true`, object vertical scaling is locked\n     * @type Boolean\n     * @default\n     */\n    lockScalingY:             false,\n\n    /**\n     * When `true`, object non-uniform scaling is locked\n     * @type Boolean\n     * @default\n     */\n    lockUniScaling:           false,\n\n    /**\n     * When `true`, object horizontal skewing is locked\n     * @type Boolean\n     * @default\n     */\n    lockSkewingX:             false,\n\n    /**\n     * When `true`, object vertical skewing is locked\n     * @type Boolean\n     * @default\n     */\n    lockSkewingY:             false,\n\n    /**\n     * When `true`, object cannot be flipped by scaling into negative values\n     * @type Boolean\n     * @default\n     */\n\n    lockScalingFlip:          false,\n    /**\n     * List of properties to consider when checking if state\n     * of an object is changed (fabric.Object#hasStateChanged)\n     * as well as for history (undo/redo) purposes\n     * @type Array\n     */\n    stateProperties:  (\n      'top left width height scaleX scaleY flipX flipY originX originY transformMatrix ' +\n      'stroke strokeWidth strokeDashArray strokeLineCap strokeLineJoin strokeMiterLimit ' +\n      'angle opacity fill fillRule globalCompositeOperation shadow clipTo visible backgroundColor ' +\n      'alignX alignY meetOrSlice skewX skewY'\n    ).split(' '),\n\n    /**\n     * Constructor\n     * @param {Object} [options] Options object\n     */\n    initialize: function(options) {\n      if (options) {\n        this.setOptions(options);\n      }\n    },\n\n    /**\n     * @private\n     * @param {Object} [options] Options object\n     */\n    _initGradient: function(options) {\n      if (options.fill && options.fill.colorStops && !(options.fill instanceof fabric.Gradient)) {\n        this.set('fill', new fabric.Gradient(options.fill));\n      }\n      if (options.stroke && options.stroke.colorStops && !(options.stroke instanceof fabric.Gradient)) {\n        this.set('stroke', new fabric.Gradient(options.stroke));\n      }\n    },\n\n    /**\n     * @private\n     * @param {Object} [options] Options object\n     */\n    _initPattern: function(options) {\n      if (options.fill && options.fill.source && !(options.fill instanceof fabric.Pattern)) {\n        this.set('fill', new fabric.Pattern(options.fill));\n      }\n      if (options.stroke && options.stroke.source && !(options.stroke instanceof fabric.Pattern)) {\n        this.set('stroke', new fabric.Pattern(options.stroke));\n      }\n    },\n\n    /**\n     * @private\n     * @param {Object} [options] Options object\n     */\n    _initClipping: function(options) {\n      if (!options.clipTo || typeof options.clipTo !== 'string') {\n        return;\n      }\n\n      var functionBody = fabric.util.getFunctionBody(options.clipTo);\n      if (typeof functionBody !== 'undefined') {\n        this.clipTo = new Function('ctx', functionBody);\n      }\n    },\n\n    /**\n     * Sets object's properties from options\n     * @param {Object} [options] Options object\n     */\n    setOptions: function(options) {\n      for (var prop in options) {\n        this.set(prop, options[prop]);\n      }\n      this._initGradient(options);\n      this._initPattern(options);\n      this._initClipping(options);\n    },\n\n    /**\n     * Transforms context when rendering an object\n     * @param {CanvasRenderingContext2D} ctx Context\n     * @param {Boolean} fromLeft When true, context is transformed to object's top/left corner. This is used when rendering text on Node\n     */\n    transform: function(ctx, fromLeft) {\n      if (this.group && this.canvas.preserveObjectStacking && this.group === this.canvas._activeGroup) {\n        this.group.transform(ctx);\n      }\n      var center = fromLeft ? this._getLeftTopCoords() : this.getCenterPoint();\n      ctx.translate(center.x, center.y);\n      ctx.rotate(degreesToRadians(this.angle));\n      ctx.scale(\n        this.scaleX * (this.flipX ? -1 : 1),\n        this.scaleY * (this.flipY ? -1 : 1)\n      );\n      ctx.transform(1, 0, Math.tan(degreesToRadians(this.skewX)), 1, 0, 0);\n      ctx.transform(1, Math.tan(degreesToRadians(this.skewY)), 0, 1, 0, 0);\n    },\n\n    /**\n     * Returns an object representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      var NUM_FRACTION_DIGITS = fabric.Object.NUM_FRACTION_DIGITS,\n\n          object = {\n            type:                     this.type,\n            originX:                  this.originX,\n            originY:                  this.originY,\n            left:                     toFixed(this.left, NUM_FRACTION_DIGITS),\n            top:                      toFixed(this.top, NUM_FRACTION_DIGITS),\n            width:                    toFixed(this.width, NUM_FRACTION_DIGITS),\n            height:                   toFixed(this.height, NUM_FRACTION_DIGITS),\n            fill:                     (this.fill && this.fill.toObject) ? this.fill.toObject() : this.fill,\n            stroke:                   (this.stroke && this.stroke.toObject) ? this.stroke.toObject() : this.stroke,\n            strokeWidth:              toFixed(this.strokeWidth, NUM_FRACTION_DIGITS),\n            strokeDashArray:          this.strokeDashArray ? this.strokeDashArray.concat() : this.strokeDashArray,\n            strokeLineCap:            this.strokeLineCap,\n            strokeLineJoin:           this.strokeLineJoin,\n            strokeMiterLimit:         toFixed(this.strokeMiterLimit, NUM_FRACTION_DIGITS),\n            scaleX:                   toFixed(this.scaleX, NUM_FRACTION_DIGITS),\n            scaleY:                   toFixed(this.scaleY, NUM_FRACTION_DIGITS),\n            angle:                    toFixed(this.getAngle(), NUM_FRACTION_DIGITS),\n            flipX:                    this.flipX,\n            flipY:                    this.flipY,\n            opacity:                  toFixed(this.opacity, NUM_FRACTION_DIGITS),\n            shadow:                   (this.shadow && this.shadow.toObject) ? this.shadow.toObject() : this.shadow,\n            visible:                  this.visible,\n            clipTo:                   this.clipTo && String(this.clipTo),\n            backgroundColor:          this.backgroundColor,\n            fillRule:                 this.fillRule,\n            globalCompositeOperation: this.globalCompositeOperation,\n            transformMatrix:          this.transformMatrix ? this.transformMatrix.concat() : this.transformMatrix,\n            skewX:                    toFixed(this.skewX, NUM_FRACTION_DIGITS),\n            skewY:                    toFixed(this.skewY, NUM_FRACTION_DIGITS)\n          };\n\n      if (!this.includeDefaultValues) {\n        object = this._removeDefaultValues(object);\n      }\n\n      fabric.util.populateWithProperties(this, object, propertiesToInclude);\n\n      return object;\n    },\n\n    /**\n     * Returns (dataless) object representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} Object representation of an instance\n     */\n    toDatalessObject: function(propertiesToInclude) {\n      // will be overwritten by subclasses\n      return this.toObject(propertiesToInclude);\n    },\n\n    /**\n     * @private\n     * @param {Object} object\n     */\n    _removeDefaultValues: function(object) {\n      var prototype = fabric.util.getKlass(object.type).prototype,\n          stateProperties = prototype.stateProperties;\n\n      stateProperties.forEach(function(prop) {\n        if (object[prop] === prototype[prop]) {\n          delete object[prop];\n        }\n        var isArray = Object.prototype.toString.call(object[prop]) === '[object Array]' &&\n                      Object.prototype.toString.call(prototype[prop]) === '[object Array]';\n\n        // basically a check for [] === []\n        if (isArray && object[prop].length === 0 && prototype[prop].length === 0) {\n          delete object[prop];\n        }\n      });\n\n      return object;\n    },\n\n    /**\n     * Returns a string representation of an instance\n     * @return {String}\n     */\n    toString: function() {\n      return '#<fabric.' + capitalize(this.type) + '>';\n    },\n\n    /**\n     * Basic getter\n     * @param {String} property Property name\n     * @return {Any} value of a property\n     */\n    get: function(property) {\n      return this[property];\n    },\n\n    /**\n     * @private\n     */\n    _setObject: function(obj) {\n      for (var prop in obj) {\n        this._set(prop, obj[prop]);\n      }\n    },\n\n    /**\n     * Sets property to a given value. When changing position/dimension -related properties (left, top, scale, angle, etc.) `set` does not update position of object's borders/controls. If you need to update those, call `setCoords()`.\n     * @param {String|Object} key Property name or object (if object, iterate over the object properties)\n     * @param {Object|Function} value Property value (if function, the value is passed into it and its return value is used as a new one)\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    set: function(key, value) {\n      if (typeof key === 'object') {\n        this._setObject(key);\n      }\n      else {\n        if (typeof value === 'function' && key !== 'clipTo') {\n          this._set(key, value(this.get(key)));\n        }\n        else {\n          this._set(key, value);\n        }\n      }\n      return this;\n    },\n\n    /**\n     * @private\n     * @param {String} key\n     * @param {Any} value\n     * @return {fabric.Object} thisArg\n     */\n    _set: function(key, value) {\n      var shouldConstrainValue = (key === 'scaleX' || key === 'scaleY');\n\n      if (shouldConstrainValue) {\n        value = this._constrainScale(value);\n      }\n      if (key === 'scaleX' && value < 0) {\n        this.flipX = !this.flipX;\n        value *= -1;\n      }\n      else if (key === 'scaleY' && value < 0) {\n        this.flipY = !this.flipY;\n        value *= -1;\n      }\n      else if (key === 'shadow' && value && !(value instanceof fabric.Shadow)) {\n        value = new fabric.Shadow(value);\n      }\n\n      this[key] = value;\n\n      if (key === 'width' || key === 'height') {\n        this.minScaleLimit = Math.min(0.1, 1/Math.max(this.width, this.height));\n      }\n\n      return this;\n    },\n\n    /**\n     * This callback function is called by the parent group of an object every\n     * time a non-delegated property changes on the group. It is passed the key\n     * and value as parameters. Not adding in this function's signature to avoid\n     * Travis build error about unused variables.\n     */\n    setOnGroup: function() {\n      // implemented by sub-classes, as needed.\n    },\n\n    /**\n     * Toggles specified property from `true` to `false` or from `false` to `true`\n     * @param {String} property Property to toggle\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    toggle: function(property) {\n      var value = this.get(property);\n      if (typeof value === 'boolean') {\n        this.set(property, !value);\n      }\n      return this;\n    },\n\n    /**\n     * Sets sourcePath of an object\n     * @param {String} value Value to set sourcePath to\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    setSourcePath: function(value) {\n      this.sourcePath = value;\n      return this;\n    },\n\n    /**\n     * Retrieves viewportTransform from Object's canvas if possible\n     * @method getViewportTransform\n     * @memberOf fabric.Object.prototype\n     * @return {Boolean} flipY value // TODO\n     */\n    getViewportTransform: function() {\n      if (this.canvas && this.canvas.viewportTransform) {\n        return this.canvas.viewportTransform;\n      }\n      return [1, 0, 0, 1, 0, 0];\n    },\n\n    /**\n     * Renders an object on a specified context\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Boolean} [noTransform] When true, context is not transformed\n     */\n    render: function(ctx, noTransform) {\n      // do not render if width/height are zeros or object is not visible\n      if ((this.width === 0 && this.height === 0) || !this.visible) {\n        return;\n      }\n\n      ctx.save();\n\n      //setup fill rule for current object\n      this._setupCompositeOperation(ctx);\n      this.drawSelectionBackground(ctx);\n      if (!noTransform) {\n        this.transform(ctx);\n      }\n      this._setStrokeStyles(ctx);\n      this._setFillStyles(ctx);\n      if (this.transformMatrix) {\n        ctx.transform.apply(ctx, this.transformMatrix);\n      }\n      this._setOpacity(ctx);\n      this._setShadow(ctx);\n      this.clipTo && fabric.util.clipContext(this, ctx);\n      this._render(ctx, noTransform);\n      this.clipTo && ctx.restore();\n\n      ctx.restore();\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _setOpacity: function(ctx) {\n      if (this.group) {\n        this.group._setOpacity(ctx);\n      }\n      ctx.globalAlpha *= this.opacity;\n    },\n\n    _setStrokeStyles: function(ctx) {\n      if (this.stroke) {\n        ctx.lineWidth = this.strokeWidth;\n        ctx.lineCap = this.strokeLineCap;\n        ctx.lineJoin = this.strokeLineJoin;\n        ctx.miterLimit = this.strokeMiterLimit;\n        ctx.strokeStyle = this.stroke.toLive\n          ? this.stroke.toLive(ctx, this)\n          : this.stroke;\n      }\n    },\n\n    _setFillStyles: function(ctx) {\n      if (this.fill) {\n        ctx.fillStyle = this.fill.toLive\n          ? this.fill.toLive(ctx, this)\n          : this.fill;\n      }\n    },\n\n    /**\n     * @private\n     * Sets line dash\n     * @param {CanvasRenderingContext2D} ctx Context to set the dash line on\n     * @param {Array} dashArray array representing dashes\n     * @param {Function} alternative function to call if browaser does not support lineDash\n     */\n    _setLineDash: function(ctx, dashArray, alternative) {\n      if (!dashArray) {\n        return;\n      }\n      // Spec requires the concatenation of two copies the dash list when the number of elements is odd\n      if (1 & dashArray.length) {\n        dashArray.push.apply(dashArray, dashArray);\n      }\n      if (supportsLineDash) {\n        ctx.setLineDash(dashArray);\n      }\n      else {\n        alternative && alternative(ctx);\n      }\n    },\n\n    /**\n     * Renders controls and borders for the object\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Boolean} [noTransform] When true, context is not transformed\n     */\n    _renderControls: function(ctx, noTransform) {\n      if (!this.active || noTransform\n          || (this.group && this.group !== this.canvas.getActiveGroup())) {\n        return;\n      }\n\n      var vpt = this.getViewportTransform(),\n          matrix = this.calcTransformMatrix(),\n          options;\n      matrix = fabric.util.multiplyTransformMatrices(vpt, matrix);\n      options = fabric.util.qrDecompose(matrix);\n\n      ctx.save();\n      ctx.translate(options.translateX, options.translateY);\n      ctx.lineWidth = 1 / this.borderScaleFactor;\n      ctx.globalAlpha = this.isMoving ? this.borderOpacityWhenMoving : 1;\n\n      if (this.group && this.group === this.canvas.getActiveGroup()) {\n        ctx.rotate(degreesToRadians(options.angle));\n        this.drawBordersInGroup(ctx, options);\n      }\n      else {\n        ctx.rotate(degreesToRadians(this.angle));\n        this.drawBorders(ctx);\n      }\n      this.drawControls(ctx);\n      ctx.restore();\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _setShadow: function(ctx) {\n      if (!this.shadow) {\n        return;\n      }\n\n      var multX = (this.canvas && this.canvas.viewportTransform[0]) || 1,\n          multY = (this.canvas && this.canvas.viewportTransform[3]) || 1;\n      if (this.canvas && this.canvas._isRetinaScaling()) {\n        multX *= fabric.devicePixelRatio;\n        multY *= fabric.devicePixelRatio;\n      }\n      ctx.shadowColor = this.shadow.color;\n      ctx.shadowBlur = this.shadow.blur * (multX + multY) * (this.scaleX + this.scaleY) / 4;\n      ctx.shadowOffsetX = this.shadow.offsetX * multX * this.scaleX;\n      ctx.shadowOffsetY = this.shadow.offsetY * multY * this.scaleY;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _removeShadow: function(ctx) {\n      if (!this.shadow) {\n        return;\n      }\n\n      ctx.shadowColor = '';\n      ctx.shadowBlur = ctx.shadowOffsetX = ctx.shadowOffsetY = 0;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderFill: function(ctx) {\n      if (!this.fill) {\n        return;\n      }\n\n      ctx.save();\n      if (this.fill.gradientTransform) {\n        var g = this.fill.gradientTransform;\n        ctx.transform.apply(ctx, g);\n      }\n      if (this.fill.toLive) {\n        ctx.translate(\n          -this.width / 2 + this.fill.offsetX || 0,\n          -this.height / 2 + this.fill.offsetY || 0);\n      }\n      if (this.fillRule === 'evenodd') {\n        ctx.fill('evenodd');\n      }\n      else {\n        ctx.fill();\n      }\n      ctx.restore();\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderStroke: function(ctx) {\n      if (!this.stroke || this.strokeWidth === 0) {\n        return;\n      }\n\n      if (this.shadow && !this.shadow.affectStroke) {\n        this._removeShadow(ctx);\n      }\n\n      ctx.save();\n\n      this._setLineDash(ctx, this.strokeDashArray, this._renderDashedStroke);\n      if (this.stroke.gradientTransform) {\n        var g = this.stroke.gradientTransform;\n        ctx.transform.apply(ctx, g);\n      }\n      if (this.stroke.toLive) {\n        ctx.translate(\n          -this.width / 2 + this.stroke.offsetX || 0,\n          -this.height / 2 + this.stroke.offsetY || 0);\n      }\n      ctx.stroke();\n      ctx.restore();\n    },\n\n    /**\n     * Clones an instance\n     * @param {Function} callback Callback is invoked with a clone as a first argument\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {fabric.Object} clone of an instance\n     */\n    clone: function(callback, propertiesToInclude) {\n      if (this.constructor.fromObject) {\n        return this.constructor.fromObject(this.toObject(propertiesToInclude), callback);\n      }\n      return new fabric.Object(this.toObject(propertiesToInclude));\n    },\n\n    /**\n     * Creates an instance of fabric.Image out of an object\n     * @param {Function} callback callback, invoked with an instance as a first argument\n     * @return {fabric.Object} thisArg\n     */\n    cloneAsImage: function(callback) {\n      var dataUrl = this.toDataURL();\n      fabric.util.loadImage(dataUrl, function(img) {\n        if (callback) {\n          callback(new fabric.Image(img));\n        }\n      });\n      return this;\n    },\n\n    /**\n     * Converts an object into a data-url-like string\n     * @param {Object} options Options object\n     * @param {String} [options.format=png] The format of the output image. Either \"jpeg\" or \"png\"\n     * @param {Number} [options.quality=1] Quality level (0..1). Only used for jpeg.\n     * @param {Number} [options.multiplier=1] Multiplier to scale by\n     * @param {Number} [options.left] Cropping left offset. Introduced in v1.2.14\n     * @param {Number} [options.top] Cropping top offset. Introduced in v1.2.14\n     * @param {Number} [options.width] Cropping width. Introduced in v1.2.14\n     * @param {Number} [options.height] Cropping height. Introduced in v1.2.14\n     * @return {String} Returns a data: URL containing a representation of the object in the format specified by options.format\n     */\n    toDataURL: function(options) {\n      options || (options = { });\n\n      var el = fabric.util.createCanvasElement(),\n          boundingRect = this.getBoundingRect();\n\n      el.width = boundingRect.width;\n      el.height = boundingRect.height;\n\n      fabric.util.wrapElement(el, 'div');\n      var canvas = new fabric.StaticCanvas(el);\n\n      // to avoid common confusion https://github.com/kangax/fabric.js/issues/806\n      if (options.format === 'jpg') {\n        options.format = 'jpeg';\n      }\n\n      if (options.format === 'jpeg') {\n        canvas.backgroundColor = '#fff';\n      }\n\n      var origParams = {\n        active: this.get('active'),\n        left: this.getLeft(),\n        top: this.getTop()\n      };\n\n      this.set('active', false);\n      this.setPositionByOrigin(new fabric.Point(canvas.getWidth() / 2, canvas.getHeight() / 2), 'center', 'center');\n\n      var originalCanvas = this.canvas;\n      canvas.add(this);\n      var data = canvas.toDataURL(options);\n\n      this.set(origParams).setCoords();\n      this.canvas = originalCanvas;\n\n      canvas.dispose();\n      canvas = null;\n\n      return data;\n    },\n\n    /**\n     * Returns true if specified type is identical to the type of an instance\n     * @param {String} type Type to check against\n     * @return {Boolean}\n     */\n    isType: function(type) {\n      return this.type === type;\n    },\n\n    /**\n     * Returns complexity of an instance\n     * @return {Number} complexity of this instance\n     */\n    complexity: function() {\n      return 0;\n    },\n\n    /**\n     * Returns a JSON representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} JSON\n     */\n    toJSON: function(propertiesToInclude) {\n      // delegate, not alias\n      return this.toObject(propertiesToInclude);\n    },\n\n    /**\n     * Sets gradient (fill or stroke) of an object\n     * <b>Backwards incompatibility note:</b> This method was named \"setGradientFill\" until v1.1.0\n     * @param {String} property Property name 'stroke' or 'fill'\n     * @param {Object} [options] Options object\n     * @param {String} [options.type] Type of gradient 'radial' or 'linear'\n     * @param {Number} [options.x1=0] x-coordinate of start point\n     * @param {Number} [options.y1=0] y-coordinate of start point\n     * @param {Number} [options.x2=0] x-coordinate of end point\n     * @param {Number} [options.y2=0] y-coordinate of end point\n     * @param {Number} [options.r1=0] Radius of start point (only for radial gradients)\n     * @param {Number} [options.r2=0] Radius of end point (only for radial gradients)\n     * @param {Object} [options.colorStops] Color stops object eg. {0: 'ff0000', 1: '000000'}\n     * @param {Object} [options.gradientTransform] transforMatrix for gradient\n     * @return {fabric.Object} thisArg\n     * @chainable\n     * @see {@link http://jsfiddle.net/fabricjs/58y8b/|jsFiddle demo}\n     * @example <caption>Set linear gradient</caption>\n     * object.setGradient('fill', {\n     *   type: 'linear',\n     *   x1: -object.width / 2,\n     *   y1: 0,\n     *   x2: object.width / 2,\n     *   y2: 0,\n     *   colorStops: {\n     *     0: 'red',\n     *     0.5: '#005555',\n     *     1: 'rgba(0,0,255,0.5)'\n     *   }\n     * });\n     * canvas.renderAll();\n     * @example <caption>Set radial gradient</caption>\n     * object.setGradient('fill', {\n     *   type: 'radial',\n     *   x1: 0,\n     *   y1: 0,\n     *   x2: 0,\n     *   y2: 0,\n     *   r1: object.width / 2,\n     *   r2: 10,\n     *   colorStops: {\n     *     0: 'red',\n     *     0.5: '#005555',\n     *     1: 'rgba(0,0,255,0.5)'\n     *   }\n     * });\n     * canvas.renderAll();\n     */\n    setGradient: function(property, options) {\n      options || (options = { });\n\n      var gradient = { colorStops: [] };\n\n      gradient.type = options.type || (options.r1 || options.r2 ? 'radial' : 'linear');\n      gradient.coords = {\n        x1: options.x1,\n        y1: options.y1,\n        x2: options.x2,\n        y2: options.y2\n      };\n\n      if (options.r1 || options.r2) {\n        gradient.coords.r1 = options.r1;\n        gradient.coords.r2 = options.r2;\n      }\n\n      options.gradientTransform && (gradient.gradientTransform = options.gradientTransform);\n\n      for (var position in options.colorStops) {\n        var color = new fabric.Color(options.colorStops[position]);\n        gradient.colorStops.push({\n          offset: position,\n          color: color.toRgb(),\n          opacity: color.getAlpha()\n        });\n      }\n\n      return this.set(property, fabric.Gradient.forObject(this, gradient));\n    },\n\n    /**\n     * Sets pattern fill of an object\n     * @param {Object} options Options object\n     * @param {(String|HTMLImageElement)} options.source Pattern source\n     * @param {String} [options.repeat=repeat] Repeat property of a pattern (one of repeat, repeat-x, repeat-y or no-repeat)\n     * @param {Number} [options.offsetX=0] Pattern horizontal offset from object's left/top corner\n     * @param {Number} [options.offsetY=0] Pattern vertical offset from object's left/top corner\n     * @return {fabric.Object} thisArg\n     * @chainable\n     * @see {@link http://jsfiddle.net/fabricjs/QT3pa/|jsFiddle demo}\n     * @example <caption>Set pattern</caption>\n     * fabric.util.loadImage('http://fabricjs.com/assets/escheresque_ste.png', function(img) {\n     *   object.setPatternFill({\n     *     source: img,\n     *     repeat: 'repeat'\n     *   });\n     *   canvas.renderAll();\n     * });\n     */\n    setPatternFill: function(options) {\n      return this.set('fill', new fabric.Pattern(options));\n    },\n\n    /**\n     * Sets {@link fabric.Object#shadow|shadow} of an object\n     * @param {Object|String} [options] Options object or string (e.g. \"2px 2px 10px rgba(0,0,0,0.2)\")\n     * @param {String} [options.color=rgb(0,0,0)] Shadow color\n     * @param {Number} [options.blur=0] Shadow blur\n     * @param {Number} [options.offsetX=0] Shadow horizontal offset\n     * @param {Number} [options.offsetY=0] Shadow vertical offset\n     * @return {fabric.Object} thisArg\n     * @chainable\n     * @see {@link http://jsfiddle.net/fabricjs/7gvJG/|jsFiddle demo}\n     * @example <caption>Set shadow with string notation</caption>\n     * object.setShadow('2px 2px 10px rgba(0,0,0,0.2)');\n     * canvas.renderAll();\n     * @example <caption>Set shadow with object notation</caption>\n     * object.setShadow({\n     *   color: 'red',\n     *   blur: 10,\n     *   offsetX: 20,\n     *   offsetY: 20\n     * });\n     * canvas.renderAll();\n     */\n    setShadow: function(options) {\n      return this.set('shadow', options ? new fabric.Shadow(options) : null);\n    },\n\n    /**\n     * Sets \"color\" of an instance (alias of `set('fill', &hellip;)`)\n     * @param {String} color Color value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    setColor: function(color) {\n      this.set('fill', color);\n      return this;\n    },\n\n    /**\n     * Sets \"angle\" of an instance\n     * @param {Number} angle Angle value (in degrees)\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    setAngle: function(angle) {\n      var shouldCenterOrigin = (this.originX !== 'center' || this.originY !== 'center') && this.centeredRotation;\n\n      if (shouldCenterOrigin) {\n        this._setOriginToCenter();\n      }\n\n      this.set('angle', angle);\n\n      if (shouldCenterOrigin) {\n        this._resetOrigin();\n      }\n\n      return this;\n    },\n\n    /**\n     * Centers object horizontally on canvas to which it was added last.\n     * You might need to call `setCoords` on an object after centering, to update controls area.\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    centerH: function () {\n      this.canvas.centerObjectH(this);\n      return this;\n    },\n\n    /**\n     * Centers object vertically on canvas to which it was added last.\n     * You might need to call `setCoords` on an object after centering, to update controls area.\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    centerV: function () {\n      this.canvas.centerObjectV(this);\n      return this;\n    },\n\n    /**\n     * Centers object vertically and horizontally on canvas to which is was added last\n     * You might need to call `setCoords` on an object after centering, to update controls area.\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    center: function () {\n      this.canvas.centerObject(this);\n      return this;\n    },\n\n    /**\n     * Removes object from canvas to which it was added last\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    remove: function() {\n      this.canvas.remove(this);\n      return this;\n    },\n\n    /**\n     * Returns coordinates of a pointer relative to an object\n     * @param {Event} e Event to operate upon\n     * @param {Object} [pointer] Pointer to operate upon (instead of event)\n     * @return {Object} Coordinates of a pointer (x, y)\n     */\n    getLocalPointer: function(e, pointer) {\n      pointer = pointer || this.canvas.getPointer(e);\n      var pClicked = new fabric.Point(pointer.x, pointer.y),\n          objectLeftTop = this._getLeftTopCoords();\n      if (this.angle) {\n        pClicked = fabric.util.rotatePoint(\n          pClicked, objectLeftTop, fabric.util.degreesToRadians(-this.angle));\n      }\n      return {\n        x: pClicked.x - objectLeftTop.x,\n        y: pClicked.y - objectLeftTop.y\n      };\n    },\n\n    /**\n     * Sets canvas globalCompositeOperation for specific object\n     * custom composition operation for the particular object can be specifed using globalCompositeOperation property\n     * @param {CanvasRenderingContext2D} ctx Rendering canvas context\n     */\n    _setupCompositeOperation: function (ctx) {\n      if (this.globalCompositeOperation) {\n        ctx.globalCompositeOperation = this.globalCompositeOperation;\n      }\n    }\n  });\n\n  fabric.util.createAccessors(fabric.Object);\n\n  /**\n   * Alias for {@link fabric.Object.prototype.setAngle}\n   * @alias rotate -> setAngle\n   * @memberOf fabric.Object\n   */\n  fabric.Object.prototype.rotate = fabric.Object.prototype.setAngle;\n\n  extend(fabric.Object.prototype, fabric.Observable);\n\n  /**\n   * Defines the number of fraction digits to use when serializing object values.\n   * You can use it to increase/decrease precision of such values like left, top, scaleX, scaleY, etc.\n   * @static\n   * @memberOf fabric.Object\n   * @constant\n   * @type Number\n   */\n  fabric.Object.NUM_FRACTION_DIGITS = 2;\n\n  /**\n   * Unique id used internally when creating SVG elements\n   * @static\n   * @memberOf fabric.Object\n   * @type Number\n   */\n  fabric.Object.__uid = 0;\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function() {\n\n  var degreesToRadians = fabric.util.degreesToRadians,\n      originXOffset = {\n        left: -0.5,\n        center: 0,\n        right: 0.5\n      },\n      originYOffset = {\n        top: -0.5,\n        center: 0,\n        bottom: 0.5\n      };\n\n  fabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {\n\n    /**\n     * Translates the coordinates from origin to center coordinates (based on the object's dimensions)\n     * @param {fabric.Point} point The point which corresponds to the originX and originY params\n     * @param {String} fromOriginX Horizontal origin: 'left', 'center' or 'right'\n     * @param {String} fromOriginY Vertical origin: 'top', 'center' or 'bottom'\n     * @param {String} toOriginX Horizontal origin: 'left', 'center' or 'right'\n     * @param {String} toOriginY Vertical origin: 'top', 'center' or 'bottom'\n     * @return {fabric.Point}\n     */\n    translateToGivenOrigin: function(point, fromOriginX, fromOriginY, toOriginX, toOriginY) {\n      var x = point.x,\n          y = point.y,\n          offsetX = originXOffset[toOriginX] - originXOffset[fromOriginX],\n          offsetY = originYOffset[toOriginY] - originYOffset[fromOriginY],\n          dim;\n      if (offsetX || offsetY) {\n        dim = this._getTransformedDimensions();\n        x = point.x + offsetX * dim.x;\n        y = point.y + offsetY * dim.y;\n      }\n      return new fabric.Point(x, y);\n    },\n\n    /**\n     * Translates the coordinates from origin to center coordinates (based on the object's dimensions)\n     * @param {fabric.Point} point The point which corresponds to the originX and originY params\n     * @param {String} originX Horizontal origin: 'left', 'center' or 'right'\n     * @param {String} originY Vertical origin: 'top', 'center' or 'bottom'\n     * @return {fabric.Point}\n     */\n    translateToCenterPoint: function(point, originX, originY) {\n      var p = this.translateToGivenOrigin(point, originX, originY, 'center', 'center');\n      if (this.angle) {\n        return fabric.util.rotatePoint(p, point, degreesToRadians(this.angle));\n      }\n      return p;\n    },\n\n    /**\n     * Translates the coordinates from center to origin coordinates (based on the object's dimensions)\n     * @param {fabric.Point} center The point which corresponds to center of the object\n     * @param {String} originX Horizontal origin: 'left', 'center' or 'right'\n     * @param {String} originY Vertical origin: 'top', 'center' or 'bottom'\n     * @return {fabric.Point}\n     */\n    translateToOriginPoint: function(center, originX, originY) {\n      var p = this.translateToGivenOrigin(center, 'center', 'center', originX, originY);\n      if (this.angle) {\n        return fabric.util.rotatePoint(p, center, degreesToRadians(this.angle));\n      }\n      return p;\n    },\n\n    /**\n     * Returns the real center coordinates of the object\n     * @return {fabric.Point}\n     */\n    getCenterPoint: function() {\n      var leftTop = new fabric.Point(this.left, this.top);\n      return this.translateToCenterPoint(leftTop, this.originX, this.originY);\n    },\n\n    /**\n     * Returns the coordinates of the object based on center coordinates\n     * @param {fabric.Point} point The point which corresponds to the originX and originY params\n     * @return {fabric.Point}\n     */\n    // getOriginPoint: function(center) {\n    //   return this.translateToOriginPoint(center, this.originX, this.originY);\n    // },\n\n    /**\n     * Returns the coordinates of the object as if it has a different origin\n     * @param {String} originX Horizontal origin: 'left', 'center' or 'right'\n     * @param {String} originY Vertical origin: 'top', 'center' or 'bottom'\n     * @return {fabric.Point}\n     */\n    getPointByOrigin: function(originX, originY) {\n      var center = this.getCenterPoint();\n      return this.translateToOriginPoint(center, originX, originY);\n    },\n\n    /**\n     * Returns the point in local coordinates\n     * @param {fabric.Point} point The point relative to the global coordinate system\n     * @param {String} originX Horizontal origin: 'left', 'center' or 'right'\n     * @param {String} originY Vertical origin: 'top', 'center' or 'bottom'\n     * @return {fabric.Point}\n     */\n    toLocalPoint: function(point, originX, originY) {\n      var center = this.getCenterPoint(),\n          p, p2;\n\n      if (originX && originY) {\n        p = this.translateToGivenOrigin(center, 'center', 'center', originX, originY);\n      }\n      else {\n        p = new fabric.Point(this.left, this.top);\n      }\n\n      p2 = new fabric.Point(point.x, point.y);\n      if (this.angle) {\n        p2 = fabric.util.rotatePoint(p2, center, -degreesToRadians(this.angle));\n      }\n      return p2.subtractEquals(p);\n    },\n\n    /**\n     * Returns the point in global coordinates\n     * @param {fabric.Point} The point relative to the local coordinate system\n     * @return {fabric.Point}\n     */\n    // toGlobalPoint: function(point) {\n    //   return fabric.util.rotatePoint(point, this.getCenterPoint(), degreesToRadians(this.angle)).addEquals(new fabric.Point(this.left, this.top));\n    // },\n\n    /**\n     * Sets the position of the object taking into consideration the object's origin\n     * @param {fabric.Point} pos The new position of the object\n     * @param {String} originX Horizontal origin: 'left', 'center' or 'right'\n     * @param {String} originY Vertical origin: 'top', 'center' or 'bottom'\n     * @return {void}\n     */\n    setPositionByOrigin: function(pos, originX, originY) {\n      var center = this.translateToCenterPoint(pos, originX, originY),\n          position = this.translateToOriginPoint(center, this.originX, this.originY);\n\n      this.set('left', position.x);\n      this.set('top', position.y);\n    },\n\n    /**\n     * @param {String} to One of 'left', 'center', 'right'\n     */\n    adjustPosition: function(to) {\n      var angle = degreesToRadians(this.angle),\n          hypotFull = this.getWidth(),\n          xFull = Math.cos(angle) * hypotFull,\n          yFull = Math.sin(angle) * hypotFull;\n\n      //TODO: this function does not consider mixed situation like top, center.\n      this.left += xFull * (originXOffset[to] - originXOffset[this.originX]);\n      this.top += yFull * (originXOffset[to] - originXOffset[this.originX]);\n\n      this.setCoords();\n      this.originX = to;\n    },\n\n    /**\n     * Sets the origin/position of the object to it's center point\n     * @private\n     * @return {void}\n     */\n    _setOriginToCenter: function() {\n      this._originalOriginX = this.originX;\n      this._originalOriginY = this.originY;\n\n      var center = this.getCenterPoint();\n\n      this.originX = 'center';\n      this.originY = 'center';\n\n      this.left = center.x;\n      this.top = center.y;\n    },\n\n    /**\n     * Resets the origin/position of the object to it's original origin\n     * @private\n     * @return {void}\n     */\n    _resetOrigin: function() {\n      var originPoint = this.translateToOriginPoint(\n        this.getCenterPoint(),\n        this._originalOriginX,\n        this._originalOriginY);\n\n      this.originX = this._originalOriginX;\n      this.originY = this._originalOriginY;\n\n      this.left = originPoint.x;\n      this.top = originPoint.y;\n\n      this._originalOriginX = null;\n      this._originalOriginY = null;\n    },\n\n    /**\n     * @private\n     */\n    _getLeftTopCoords: function() {\n      return this.translateToOriginPoint(this.getCenterPoint(), 'left', 'top');\n    }\n  });\n\n})();\n\n\n(function() {\n\n  function getCoords(oCoords) {\n    return [\n      new fabric.Point(oCoords.tl.x, oCoords.tl.y),\n      new fabric.Point(oCoords.tr.x, oCoords.tr.y),\n      new fabric.Point(oCoords.br.x, oCoords.br.y),\n      new fabric.Point(oCoords.bl.x, oCoords.bl.y)\n    ];\n  }\n\n  var degreesToRadians = fabric.util.degreesToRadians,\n      multiplyMatrices = fabric.util.multiplyTransformMatrices;\n\n  fabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {\n\n    /**\n     * Object containing coordinates of object's controls\n     * @type Object\n     * @default\n     */\n    oCoords: null,\n\n    /**\n     * Checks if object intersects with an area formed by 2 points\n     * @param {Object} pointTL top-left point of area\n     * @param {Object} pointBR bottom-right point of area\n     * @return {Boolean} true if object intersects with an area formed by 2 points\n     */\n    intersectsWithRect: function(pointTL, pointBR) {\n      var oCoords = getCoords(this.oCoords),\n          intersection = fabric.Intersection.intersectPolygonRectangle(\n            oCoords,\n            pointTL,\n            pointBR\n          );\n      return intersection.status === 'Intersection';\n    },\n\n    /**\n     * Checks if object intersects with another object\n     * @param {Object} other Object to test\n     * @return {Boolean} true if object intersects with another object\n     */\n    intersectsWithObject: function(other) {\n      var intersection = fabric.Intersection.intersectPolygonPolygon(\n            getCoords(this.oCoords),\n            getCoords(other.oCoords)\n          );\n\n      return intersection.status === 'Intersection';\n    },\n\n    /**\n     * Checks if object is fully contained within area of another object\n     * @param {Object} other Object to test\n     * @return {Boolean} true if object is fully contained within area of another object\n     */\n    isContainedWithinObject: function(other) {\n      var boundingRect = other.getBoundingRect(),\n          point1 = new fabric.Point(boundingRect.left, boundingRect.top),\n          point2 = new fabric.Point(boundingRect.left + boundingRect.width, boundingRect.top + boundingRect.height);\n\n      return this.isContainedWithinRect(point1, point2);\n    },\n\n    /**\n     * Checks if object is fully contained within area formed by 2 points\n     * @param {Object} pointTL top-left point of area\n     * @param {Object} pointBR bottom-right point of area\n     * @return {Boolean} true if object is fully contained within area formed by 2 points\n     */\n    isContainedWithinRect: function(pointTL, pointBR) {\n      var boundingRect = this.getBoundingRect();\n\n      return (\n        boundingRect.left >= pointTL.x &&\n        boundingRect.left + boundingRect.width <= pointBR.x &&\n        boundingRect.top >= pointTL.y &&\n        boundingRect.top + boundingRect.height <= pointBR.y\n      );\n    },\n\n    /**\n     * Checks if point is inside the object\n     * @param {fabric.Point} point Point to check against\n     * @return {Boolean} true if point is inside the object\n     */\n    containsPoint: function(point) {\n      var lines = this._getImageLines(this.oCoords),\n          xPoints = this._findCrossPoints(point, lines);\n\n      // if xPoints is odd then point is inside the object\n      return (xPoints !== 0 && xPoints % 2 === 1);\n    },\n\n    /**\n     * Method that returns an object with the object edges in it, given the coordinates of the corners\n     * @private\n     * @param {Object} oCoords Coordinates of the object corners\n     */\n    _getImageLines: function(oCoords) {\n      return {\n        topline: {\n          o: oCoords.tl,\n          d: oCoords.tr\n        },\n        rightline: {\n          o: oCoords.tr,\n          d: oCoords.br\n        },\n        bottomline: {\n          o: oCoords.br,\n          d: oCoords.bl\n        },\n        leftline: {\n          o: oCoords.bl,\n          d: oCoords.tl\n        }\n      };\n    },\n\n    /**\n     * Helper method to determine how many cross points are between the 4 object edges\n     * and the horizontal line determined by a point on canvas\n     * @private\n     * @param {fabric.Point} point Point to check\n     * @param {Object} oCoords Coordinates of the object being evaluated\n     */\n    _findCrossPoints: function(point, oCoords) {\n      var b1, b2, a1, a2, xi, yi,\n          xcount = 0,\n          iLine;\n\n      for (var lineKey in oCoords) {\n        iLine = oCoords[lineKey];\n        // optimisation 1: line below point. no cross\n        if ((iLine.o.y < point.y) && (iLine.d.y < point.y)) {\n          continue;\n        }\n        // optimisation 2: line above point. no cross\n        if ((iLine.o.y >= point.y) && (iLine.d.y >= point.y)) {\n          continue;\n        }\n        // optimisation 3: vertical line case\n        if ((iLine.o.x === iLine.d.x) && (iLine.o.x >= point.x)) {\n          xi = iLine.o.x;\n          yi = point.y;\n        }\n        // calculate the intersection point\n        else {\n          b1 = 0;\n          b2 = (iLine.d.y - iLine.o.y) / (iLine.d.x - iLine.o.x);\n          a1 = point.y - b1 * point.x;\n          a2 = iLine.o.y - b2 * iLine.o.x;\n\n          xi = - (a1 - a2) / (b1 - b2);\n          yi = a1 + b1 * xi;\n        }\n        // dont count xi < point.x cases\n        if (xi >= point.x) {\n          xcount += 1;\n        }\n        // optimisation 4: specific for square images\n        if (xcount === 2) {\n          break;\n        }\n      }\n      return xcount;\n    },\n\n    /**\n     * Returns width of an object's bounding rectangle\n     * @deprecated since 1.0.4\n     * @return {Number} width value\n     */\n    getBoundingRectWidth: function() {\n      return this.getBoundingRect().width;\n    },\n\n    /**\n     * Returns height of an object's bounding rectangle\n     * @deprecated since 1.0.4\n     * @return {Number} height value\n     */\n    getBoundingRectHeight: function() {\n      return this.getBoundingRect().height;\n    },\n\n    /**\n     * Returns coordinates of object's bounding rectangle (left, top, width, height)\n     * @return {Object} Object with left, top, width, height properties\n     */\n    getBoundingRect: function() {\n      this.oCoords || this.setCoords();\n      return fabric.util.makeBoundingBoxFromPoints([\n        this.oCoords.tl,\n        this.oCoords.tr,\n        this.oCoords.br,\n        this.oCoords.bl\n      ]);\n    },\n\n    /**\n     * Returns width of an object\n     * @return {Number} width value\n     */\n    getWidth: function() {\n      //needs to be changed\n      return this._getTransformedDimensions().x;\n    },\n\n    /**\n     * Returns height of an object\n     * @return {Number} height value\n     */\n    getHeight: function() {\n      //needs to be changed\n      return this._getTransformedDimensions().y;\n    },\n\n    /**\n     * Makes sure the scale is valid and modifies it if necessary\n     * @private\n     * @param {Number} value\n     * @return {Number}\n     */\n    _constrainScale: function(value) {\n      if (Math.abs(value) < this.minScaleLimit) {\n        if (value < 0) {\n          return -this.minScaleLimit;\n        }\n        else {\n          return this.minScaleLimit;\n        }\n      }\n      return value;\n    },\n\n    /**\n     * Scales an object (equally by x and y)\n     * @param {Number} value Scale factor\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    scale: function(value) {\n      value = this._constrainScale(value);\n\n      if (value < 0) {\n        this.flipX = !this.flipX;\n        this.flipY = !this.flipY;\n        value *= -1;\n      }\n\n      this.scaleX = value;\n      this.scaleY = value;\n      this.setCoords();\n      return this;\n    },\n\n    /**\n     * Scales an object to a given width, with respect to bounding box (scaling by x/y equally)\n     * @param {Number} value New width value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    scaleToWidth: function(value) {\n      // adjust to bounding rect factor so that rotated shapes would fit as well\n      var boundingRectFactor = this.getBoundingRect().width / this.getWidth();\n      return this.scale(value / this.width / boundingRectFactor);\n    },\n\n    /**\n     * Scales an object to a given height, with respect to bounding box (scaling by x/y equally)\n     * @param {Number} value New height value\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    scaleToHeight: function(value) {\n      // adjust to bounding rect factor so that rotated shapes would fit as well\n      var boundingRectFactor = this.getBoundingRect().height / this.getHeight();\n      return this.scale(value / this.height / boundingRectFactor);\n    },\n\n    /**\n     * Sets corner position coordinates based on current angle, width and height\n     * See https://github.com/kangax/fabric.js/wiki/When-to-call-setCoords\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    setCoords: function() {\n      var theta = degreesToRadians(this.angle),\n          vpt = this.getViewportTransform(),\n          dim = this._calculateCurrentDimensions(),\n          currentWidth = dim.x, currentHeight = dim.y;\n\n      // If width is negative, make postive. Fixes path selection issue\n      if (currentWidth < 0) {\n        currentWidth = Math.abs(currentWidth);\n      }\n\n      var sinTh = Math.sin(theta),\n          cosTh = Math.cos(theta),\n          _angle = currentWidth > 0 ? Math.atan(currentHeight / currentWidth) : 0,\n          _hypotenuse = (currentWidth / Math.cos(_angle)) / 2,\n          offsetX = Math.cos(_angle + theta) * _hypotenuse,\n          offsetY = Math.sin(_angle + theta) * _hypotenuse,\n\n          // offset added for rotate and scale actions\n          coords = fabric.util.transformPoint(this.getCenterPoint(), vpt),\n          tl  = new fabric.Point(coords.x - offsetX, coords.y - offsetY),\n          tr  = new fabric.Point(tl.x + (currentWidth * cosTh), tl.y + (currentWidth * sinTh)),\n          bl  = new fabric.Point(tl.x - (currentHeight * sinTh), tl.y + (currentHeight * cosTh)),\n          br  = new fabric.Point(coords.x + offsetX, coords.y + offsetY),\n          ml  = new fabric.Point((tl.x + bl.x)/2, (tl.y + bl.y)/2),\n          mt  = new fabric.Point((tr.x + tl.x)/2, (tr.y + tl.y)/2),\n          mr  = new fabric.Point((br.x + tr.x)/2, (br.y + tr.y)/2),\n          mb  = new fabric.Point((br.x + bl.x)/2, (br.y + bl.y)/2),\n          mtr = new fabric.Point(mt.x + sinTh * this.rotatingPointOffset, mt.y - cosTh * this.rotatingPointOffset);\n      // debugging\n\n      /* setTimeout(function() {\n         canvas.contextTop.fillStyle = 'green';\n         canvas.contextTop.fillRect(mb.x, mb.y, 3, 3);\n         canvas.contextTop.fillRect(bl.x, bl.y, 3, 3);\n         canvas.contextTop.fillRect(br.x, br.y, 3, 3);\n         canvas.contextTop.fillRect(tl.x, tl.y, 3, 3);\n         canvas.contextTop.fillRect(tr.x, tr.y, 3, 3);\n         canvas.contextTop.fillRect(ml.x, ml.y, 3, 3);\n         canvas.contextTop.fillRect(mr.x, mr.y, 3, 3);\n         canvas.contextTop.fillRect(mt.x, mt.y, 3, 3);\n         canvas.contextTop.fillRect(mtr.x, mtr.y, 3, 3);\n       }, 50); */\n\n      this.oCoords = {\n        // corners\n        tl: tl, tr: tr, br: br, bl: bl,\n        // middle\n        ml: ml, mt: mt, mr: mr, mb: mb,\n        // rotating point\n        mtr: mtr\n      };\n\n      // set coordinates of the draggable boxes in the corners used to scale/rotate the image\n      this._setCornerCoords && this._setCornerCoords();\n\n      return this;\n    },\n\n    _calcRotateMatrix: function() {\n      if (this.angle) {\n        var theta = degreesToRadians(this.angle), cos = Math.cos(theta), sin = Math.sin(theta);\n        return [cos, sin, -sin, cos, 0, 0];\n      }\n      return [1, 0, 0, 1, 0, 0];\n    },\n\n    calcTransformMatrix: function() {\n      var center = this.getCenterPoint(),\n          translateMatrix = [1, 0, 0, 1, center.x, center.y],\n          rotateMatrix = this._calcRotateMatrix(),\n          dimensionMatrix = this._calcDimensionsTransformMatrix(this.skewX, this.skewY, true),\n          matrix = this.group ? this.group.calcTransformMatrix() : [1, 0, 0, 1, 0, 0];\n      matrix = multiplyMatrices(matrix, translateMatrix);\n      matrix = multiplyMatrices(matrix, rotateMatrix);\n      matrix = multiplyMatrices(matrix, dimensionMatrix);\n      return matrix;\n    },\n\n    _calcDimensionsTransformMatrix: function(skewX, skewY, flipping) {\n      var skewMatrixX = [1, 0, Math.tan(degreesToRadians(skewX)), 1],\n          skewMatrixY = [1, Math.tan(degreesToRadians(skewY)), 0, 1],\n          scaleX = this.scaleX * (flipping && this.flipX ? -1 : 1),\n          scaleY = this.scaleY * (flipping && this.flipY ? -1 : 1),\n          scaleMatrix = [scaleX, 0, 0, scaleY],\n          m = multiplyMatrices(scaleMatrix, skewMatrixX, true);\n      return multiplyMatrices(m, skewMatrixY, true);\n    }\n  });\n})();\n\n\nfabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {\n\n  /**\n   * Moves an object to the bottom of the stack of drawn objects\n   * @return {fabric.Object} thisArg\n   * @chainable\n   */\n  sendToBack: function() {\n    if (this.group) {\n      fabric.StaticCanvas.prototype.sendToBack.call(this.group, this);\n    }\n    else {\n      this.canvas.sendToBack(this);\n    }\n    return this;\n  },\n\n  /**\n   * Moves an object to the top of the stack of drawn objects\n   * @return {fabric.Object} thisArg\n   * @chainable\n   */\n  bringToFront: function() {\n    if (this.group) {\n      fabric.StaticCanvas.prototype.bringToFront.call(this.group, this);\n    }\n    else {\n      this.canvas.bringToFront(this);\n    }\n    return this;\n  },\n\n  /**\n   * Moves an object down in stack of drawn objects\n   * @param {Boolean} [intersecting] If `true`, send object behind next lower intersecting object\n   * @return {fabric.Object} thisArg\n   * @chainable\n   */\n  sendBackwards: function(intersecting) {\n    if (this.group) {\n      fabric.StaticCanvas.prototype.sendBackwards.call(this.group, this, intersecting);\n    }\n    else {\n      this.canvas.sendBackwards(this, intersecting);\n    }\n    return this;\n  },\n\n  /**\n   * Moves an object up in stack of drawn objects\n   * @param {Boolean} [intersecting] If `true`, send object in front of next upper intersecting object\n   * @return {fabric.Object} thisArg\n   * @chainable\n   */\n  bringForward: function(intersecting) {\n    if (this.group) {\n      fabric.StaticCanvas.prototype.bringForward.call(this.group, this, intersecting);\n    }\n    else {\n      this.canvas.bringForward(this, intersecting);\n    }\n    return this;\n  },\n\n  /**\n   * Moves an object to specified level in stack of drawn objects\n   * @param {Number} index New position of object\n   * @return {fabric.Object} thisArg\n   * @chainable\n   */\n  moveTo: function(index) {\n    if (this.group) {\n      fabric.StaticCanvas.prototype.moveTo.call(this.group, this, index);\n    }\n    else {\n      this.canvas.moveTo(this, index);\n    }\n    return this;\n  }\n});\n\n\n/* _TO_SVG_START_ */\n(function() {\n\n  function getSvgColorString(prop, value) {\n    if (!value) {\n      return prop + ': none; ';\n    }\n    else if (value.toLive) {\n      return prop + ': url(#SVGID_' + value.id + '); ';\n    }\n    else {\n      var color = new fabric.Color(value),\n          str = prop + ': ' + value + '; ',\n          opacity = color.getAlpha();\n      if (opacity !== 1) {\n        //change the color in rgb + opacity\n        str = prop + ': ' + color.toRgb() + '; ';\n        str += prop + '-opacity: ' + opacity.toString() + '; ';\n      }\n      return str;\n    }\n  }\n\n  fabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {\n    /**\n     * Returns styles-string for svg-export\n     * @param {Boolean} skipShadow a boolean to skip shadow filter output\n     * @return {String}\n     */\n    getSvgStyles: function(skipShadow) {\n\n      var fillRule = this.fillRule,\n          strokeWidth = this.strokeWidth ? this.strokeWidth : '0',\n          strokeDashArray = this.strokeDashArray ? this.strokeDashArray.join(' ') : 'none',\n          strokeLineCap = this.strokeLineCap ? this.strokeLineCap : 'butt',\n          strokeLineJoin = this.strokeLineJoin ? this.strokeLineJoin : 'miter',\n          strokeMiterLimit = this.strokeMiterLimit ? this.strokeMiterLimit : '4',\n          opacity = typeof this.opacity !== 'undefined' ? this.opacity : '1',\n          visibility = this.visible ? '' : ' visibility: hidden;',\n          filter = skipShadow ? '' : this.getSvgFilter(),\n          fill = getSvgColorString('fill', this.fill),\n          stroke = getSvgColorString('stroke', this.stroke);\n\n      return [\n        stroke,\n        'stroke-width: ', strokeWidth, '; ',\n        'stroke-dasharray: ', strokeDashArray, '; ',\n        'stroke-linecap: ', strokeLineCap, '; ',\n        'stroke-linejoin: ', strokeLineJoin, '; ',\n        'stroke-miterlimit: ', strokeMiterLimit, '; ',\n        fill,\n        'fill-rule: ', fillRule, '; ',\n        'opacity: ', opacity, ';',\n        filter,\n        visibility\n      ].join('');\n    },\n\n    /**\n     * Returns filter for svg shadow\n     * @return {String}\n     */\n    getSvgFilter: function() {\n      return this.shadow ? 'filter: url(#SVGID_' + this.shadow.id + ');' : '';\n    },\n\n    /**\n     * Returns transform-string for svg-export\n     * @return {String}\n     */\n    getSvgTransform: function() {\n      if (this.group && this.group.type === 'path-group') {\n        return '';\n      }\n      var toFixed = fabric.util.toFixed,\n          angle = this.getAngle(),\n          skewX = (this.getSkewX() % 360),\n          skewY = (this.getSkewY() % 360),\n          center = this.getCenterPoint(),\n\n          NUM_FRACTION_DIGITS = fabric.Object.NUM_FRACTION_DIGITS,\n\n          translatePart = this.type === 'path-group' ? '' : 'translate(' +\n                            toFixed(center.x, NUM_FRACTION_DIGITS) +\n                            ' ' +\n                            toFixed(center.y, NUM_FRACTION_DIGITS) +\n                          ')',\n\n          anglePart = angle !== 0\n            ? (' rotate(' + toFixed(angle, NUM_FRACTION_DIGITS) + ')')\n            : '',\n\n          scalePart = (this.scaleX === 1 && this.scaleY === 1)\n            ? '' :\n            (' scale(' +\n              toFixed(this.scaleX, NUM_FRACTION_DIGITS) +\n              ' ' +\n              toFixed(this.scaleY, NUM_FRACTION_DIGITS) +\n            ')'),\n\n          skewXPart = skewX !== 0 ? ' skewX(' + toFixed(skewX, NUM_FRACTION_DIGITS) + ')' : '',\n\n          skewYPart = skewY !== 0 ? ' skewY(' + toFixed(skewY, NUM_FRACTION_DIGITS) + ')' : '',\n\n          addTranslateX = this.type === 'path-group' ? this.width : 0,\n\n          flipXPart = this.flipX ? ' matrix(-1 0 0 1 ' + addTranslateX + ' 0) ' : '',\n\n          addTranslateY = this.type === 'path-group' ? this.height : 0,\n\n          flipYPart = this.flipY ? ' matrix(1 0 0 -1 0 ' + addTranslateY + ')' : '';\n\n      return [\n        translatePart, anglePart, scalePart, flipXPart, flipYPart, skewXPart, skewYPart\n      ].join('');\n    },\n\n    /**\n     * Returns transform-string for svg-export from the transform matrix of single elements\n     * @return {String}\n     */\n    getSvgTransformMatrix: function() {\n      return this.transformMatrix ? ' matrix(' + this.transformMatrix.join(' ') + ') ' : '';\n    },\n\n    /**\n     * @private\n     */\n    _createBaseSVGMarkup: function() {\n      var markup = [ ];\n\n      if (this.fill && this.fill.toLive) {\n        markup.push(this.fill.toSVG(this, false));\n      }\n      if (this.stroke && this.stroke.toLive) {\n        markup.push(this.stroke.toSVG(this, false));\n      }\n      if (this.shadow) {\n        markup.push(this.shadow.toSVG(this));\n      }\n      return markup;\n    }\n  });\n})();\n/* _TO_SVG_END_ */\n\n\n/*\n  Depends on `stateProperties`\n*/\nfabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {\n\n  /**\n   * Returns true if object state (one of its state properties) was changed\n   * @return {Boolean} true if instance' state has changed since `{@link fabric.Object#saveState}` was called\n   */\n  hasStateChanged: function() {\n    return this.stateProperties.some(function(prop) {\n      return this.get(prop) !== this.originalState[prop];\n    }, this);\n  },\n\n  /**\n   * Saves state of an object\n   * @param {Object} [options] Object with additional `stateProperties` array to include when saving state\n   * @return {fabric.Object} thisArg\n   */\n  saveState: function(options) {\n    this.stateProperties.forEach(function(prop) {\n      this.originalState[prop] = this.get(prop);\n    }, this);\n\n    if (options && options.stateProperties) {\n      options.stateProperties.forEach(function(prop) {\n        this.originalState[prop] = this.get(prop);\n      }, this);\n    }\n\n    return this;\n  },\n\n  /**\n   * Setups state of an object\n   * @return {fabric.Object} thisArg\n   */\n  setupState: function() {\n    this.originalState = { };\n    this.saveState();\n\n    return this;\n  }\n});\n\n\n(function() {\n\n  var degreesToRadians = fabric.util.degreesToRadians,\n      //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n      isVML = function() { return typeof G_vmlCanvasManager !== 'undefined'; };\n  //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n  fabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {\n\n    /**\n     * The object interactivity controls.\n     * @private\n     */\n    _controlsVisibility: null,\n\n    /**\n     * Determines which corner has been clicked\n     * @private\n     * @param {Object} pointer The pointer indicating the mouse position\n     * @return {String|Boolean} corner code (tl, tr, bl, br, etc.), or false if nothing is found\n     */\n    _findTargetCorner: function(pointer) {\n      if (!this.hasControls || !this.active) {\n        return false;\n      }\n\n      var ex = pointer.x,\n          ey = pointer.y,\n          xPoints,\n          lines;\n      this.__corner = 0;\n      for (var i in this.oCoords) {\n\n        if (!this.isControlVisible(i)) {\n          continue;\n        }\n\n        if (i === 'mtr' && !this.hasRotatingPoint) {\n          continue;\n        }\n\n        if (this.get('lockUniScaling') &&\n           (i === 'mt' || i === 'mr' || i === 'mb' || i === 'ml')) {\n          continue;\n        }\n\n        lines = this._getImageLines(this.oCoords[i].corner);\n\n        // debugging\n\n        // canvas.contextTop.fillRect(lines.bottomline.d.x, lines.bottomline.d.y, 2, 2);\n        // canvas.contextTop.fillRect(lines.bottomline.o.x, lines.bottomline.o.y, 2, 2);\n\n        // canvas.contextTop.fillRect(lines.leftline.d.x, lines.leftline.d.y, 2, 2);\n        // canvas.contextTop.fillRect(lines.leftline.o.x, lines.leftline.o.y, 2, 2);\n\n        // canvas.contextTop.fillRect(lines.topline.d.x, lines.topline.d.y, 2, 2);\n        // canvas.contextTop.fillRect(lines.topline.o.x, lines.topline.o.y, 2, 2);\n\n        // canvas.contextTop.fillRect(lines.rightline.d.x, lines.rightline.d.y, 2, 2);\n        // canvas.contextTop.fillRect(lines.rightline.o.x, lines.rightline.o.y, 2, 2);\n\n        xPoints = this._findCrossPoints({ x: ex, y: ey }, lines);\n        if (xPoints !== 0 && xPoints % 2 === 1) {\n          this.__corner = i;\n          return i;\n        }\n      }\n      return false;\n    },\n\n    /**\n     * Sets the coordinates of the draggable boxes in the corners of\n     * the image used to scale/rotate it.\n     * @private\n     */\n    _setCornerCoords: function() {\n      var coords = this.oCoords,\n          newTheta = degreesToRadians(45 - this.angle),\n          /* Math.sqrt(2 * Math.pow(this.cornerSize, 2)) / 2, */\n          /* 0.707106 stands for sqrt(2)/2 */\n          cornerHypotenuse = this.cornerSize * 0.707106,\n          cosHalfOffset = cornerHypotenuse * Math.cos(newTheta),\n          sinHalfOffset = cornerHypotenuse * Math.sin(newTheta),\n          x, y;\n\n      for (var point in coords) {\n        x = coords[point].x;\n        y = coords[point].y;\n        coords[point].corner = {\n          tl: {\n            x: x - sinHalfOffset,\n            y: y - cosHalfOffset\n          },\n          tr: {\n            x: x + cosHalfOffset,\n            y: y - sinHalfOffset\n          },\n          bl: {\n            x: x - cosHalfOffset,\n            y: y + sinHalfOffset\n          },\n          br: {\n            x: x + sinHalfOffset,\n            y: y + cosHalfOffset\n          }\n        };\n      }\n    },\n\n    /*\n     * Calculate object dimensions from its properties\n     * @private\n     */\n    _getNonTransformedDimensions: function() {\n      var strokeWidth = this.strokeWidth,\n          w = this.width,\n          h = this.height,\n          addStrokeToW = true,\n          addStrokeToH = true;\n\n      if (this.type === 'line' && this.strokeLineCap === 'butt') {\n        addStrokeToH = w;\n        addStrokeToW = h;\n      }\n\n      if (addStrokeToH) {\n        h += h < 0 ? -strokeWidth : strokeWidth;\n      }\n\n      if (addStrokeToW) {\n        w += w < 0 ? -strokeWidth : strokeWidth;\n      }\n\n      return { x: w, y: h };\n    },\n\n    /*\n     * @private\n     */\n    _getTransformedDimensions: function(skewX, skewY) {\n      if (typeof skewX === 'undefined') {\n        skewX = this.skewX;\n      }\n      if (typeof skewY === 'undefined') {\n        skewY = this.skewY;\n      }\n      var dimensions = this._getNonTransformedDimensions(),\n          dimX = dimensions.x /2, dimY = dimensions.y / 2,\n          points = [\n          {\n            x: -dimX,\n            y: -dimY\n          },\n          {\n            x: dimX,\n            y: -dimY\n          },\n          {\n            x: -dimX,\n            y: dimY\n          },\n          {\n            x: dimX,\n            y: dimY\n          }],\n          i, transformMatrix = this._calcDimensionsTransformMatrix(skewX, skewY, false),\n          bbox;\n      for (i = 0; i < points.length; i++) {\n        points[i] = fabric.util.transformPoint(points[i], transformMatrix);\n      }\n      bbox = fabric.util.makeBoundingBoxFromPoints(points);\n      return { x: bbox.width, y: bbox.height };\n    },\n\n    /*\n     * private\n     */\n    _calculateCurrentDimensions: function()  {\n      var vpt = this.getViewportTransform(),\n          dim = this._getTransformedDimensions(),\n          w = dim.x, h = dim.y;\n\n      w += 2 * this.padding;\n      h += 2 * this.padding;\n\n      return fabric.util.transformPoint(new fabric.Point(w, h), vpt, true);\n    },\n\n    /**\n     * Draws a colored layer behind the object, inside its selection borders.\n     * Requires public options: padding, selectionBackgroundColor\n     * this function is called when the context is transformed\n     * @param {CanvasRenderingContext2D} ctx Context to draw on\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    drawSelectionBackground: function(ctx) {\n      if (!this.selectionBackgroundColor || !this.active || this.group) {\n        return this;\n      }\n      ctx.save();\n      var center = this.getCenterPoint(), wh = this._calculateCurrentDimensions();\n      ctx.translate(center.x, center.y);\n      ctx.rotate(degreesToRadians(this.angle));\n      ctx.fillStyle = this.selectionBackgroundColor;\n      ctx.fillRect(-wh.x/2, -wh.y/2, wh.x, wh.y);\n      ctx.restore();\n      return this;\n    },\n\n    /**\n     * Draws borders of an object's bounding box.\n     * Requires public properties: width, height\n     * Requires public options: padding, borderColor\n     * @param {CanvasRenderingContext2D} ctx Context to draw on\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    drawBorders: function(ctx) {\n      if (!this.hasBorders) {\n        return this;\n      }\n\n      var wh = this._calculateCurrentDimensions(),\n          strokeWidth = 1 / this.borderScaleFactor,\n          width = wh.x + strokeWidth,\n          height = wh.y + strokeWidth;\n\n      ctx.save();\n      ctx.strokeStyle = this.borderColor;\n      this._setLineDash(ctx, this.borderDashArray, null);\n\n      ctx.strokeRect(\n        -width / 2,\n        -height / 2,\n        width,\n        height\n      );\n\n      if (this.hasRotatingPoint && this.isControlVisible('mtr') && !this.get('lockRotation') && this.hasControls) {\n\n        var rotateHeight = -height / 2;\n\n        ctx.beginPath();\n        ctx.moveTo(0, rotateHeight);\n        ctx.lineTo(0, rotateHeight - this.rotatingPointOffset);\n        ctx.closePath();\n        ctx.stroke();\n      }\n\n      ctx.restore();\n      return this;\n    },\n\n    /**\n     * Draws borders of an object's bounding box when it is inside a group.\n     * Requires public properties: width, height\n     * Requires public options: padding, borderColor\n     * @param {CanvasRenderingContext2D} ctx Context to draw on\n     * @param {object} options object representing current object parameters\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    drawBordersInGroup: function(ctx, options) {\n      if (!this.hasBorders) {\n        return this;\n      }\n\n      var p = this._getNonTransformedDimensions(),\n          matrix = fabric.util.customTransformMatrix(options.scaleX, options.scaleY, options.skewX),\n          wh = fabric.util.transformPoint(p, matrix),\n          strokeWidth = 1 / this.borderScaleFactor,\n          width = wh.x + strokeWidth + 2 * this.padding,\n          height = wh.y + strokeWidth + 2 * this.padding;\n\n      ctx.save();\n      this._setLineDash(ctx, this.borderDashArray, null);\n      ctx.strokeStyle = this.borderColor;\n\n      ctx.strokeRect(\n        -width / 2,\n        -height / 2,\n        width,\n        height\n      );\n\n      ctx.restore();\n      return this;\n    },\n\n    /**\n     * Draws corners of an object's bounding box.\n     * Requires public properties: width, height\n     * Requires public options: cornerSize, padding\n     * @param {CanvasRenderingContext2D} ctx Context to draw on\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    drawControls: function(ctx) {\n      if (!this.hasControls) {\n        return this;\n      }\n\n      var wh = this._calculateCurrentDimensions(),\n          width = wh.x,\n          height = wh.y,\n          scaleOffset = this.cornerSize,\n          left = -(width + scaleOffset) / 2,\n          top = -(height + scaleOffset) / 2,\n          methodName = this.transparentCorners ? 'stroke' : 'fill';\n\n      ctx.save();\n      ctx.strokeStyle = ctx.fillStyle = this.cornerColor;\n      if (!this.transparentCorners) {\n        ctx.strokeStyle = this.cornerStrokeColor;\n      }\n      this._setLineDash(ctx, this.cornerDashArray, null);\n\n      // top-left\n      this._drawControl('tl', ctx, methodName,\n        left,\n        top);\n\n      // top-right\n      this._drawControl('tr', ctx, methodName,\n        left + width,\n        top);\n\n      // bottom-left\n      this._drawControl('bl', ctx, methodName,\n        left,\n        top + height);\n\n      // bottom-right\n      this._drawControl('br', ctx, methodName,\n        left + width,\n        top + height);\n\n      if (!this.get('lockUniScaling')) {\n\n        // middle-top\n        this._drawControl('mt', ctx, methodName,\n          left + width/2,\n          top);\n\n        // middle-bottom\n        this._drawControl('mb', ctx, methodName,\n          left + width/2,\n          top + height);\n\n        // middle-right\n        this._drawControl('mr', ctx, methodName,\n          left + width,\n          top + height/2);\n\n        // middle-left\n        this._drawControl('ml', ctx, methodName,\n          left,\n          top + height/2);\n      }\n\n      // middle-top-rotate\n      if (this.hasRotatingPoint) {\n        this._drawControl('mtr', ctx, methodName,\n          left + width / 2,\n          top - this.rotatingPointOffset);\n      }\n\n      ctx.restore();\n\n      return this;\n    },\n\n    /**\n     * @private\n     */\n    _drawControl: function(control, ctx, methodName, left, top) {\n      if (!this.isControlVisible(control)) {\n        return;\n      }\n      var size = this.cornerSize, stroke = !this.transparentCorners && this.cornerStrokeColor;\n      switch (this.cornerStyle) {\n        case 'circle':\n          ctx.beginPath();\n          ctx.arc(left + size/2, top + size/2, size/2, 0, 2 * Math.PI, false);\n          ctx[methodName]();\n          if (stroke) {\n            ctx.stroke();\n          }\n          break;\n        default:\n          isVML() || this.transparentCorners || ctx.clearRect(left, top, size, size);\n          ctx[methodName + 'Rect'](left, top, size, size);\n          if (stroke) {\n            ctx.strokeRect(left, top, size, size);\n          }\n      }\n    },\n\n    /**\n     * Returns true if the specified control is visible, false otherwise.\n     * @param {String} controlName The name of the control. Possible values are 'tl', 'tr', 'br', 'bl', 'ml', 'mt', 'mr', 'mb', 'mtr'.\n     * @returns {Boolean} true if the specified control is visible, false otherwise\n     */\n    isControlVisible: function(controlName) {\n      return this._getControlsVisibility()[controlName];\n    },\n\n    /**\n     * Sets the visibility of the specified control.\n     * @param {String} controlName The name of the control. Possible values are 'tl', 'tr', 'br', 'bl', 'ml', 'mt', 'mr', 'mb', 'mtr'.\n     * @param {Boolean} visible true to set the specified control visible, false otherwise\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    setControlVisible: function(controlName, visible) {\n      this._getControlsVisibility()[controlName] = visible;\n      return this;\n    },\n\n    /**\n     * Sets the visibility state of object controls.\n     * @param {Object} [options] Options object\n     * @param {Boolean} [options.bl] true to enable the bottom-left control, false to disable it\n     * @param {Boolean} [options.br] true to enable the bottom-right control, false to disable it\n     * @param {Boolean} [options.mb] true to enable the middle-bottom control, false to disable it\n     * @param {Boolean} [options.ml] true to enable the middle-left control, false to disable it\n     * @param {Boolean} [options.mr] true to enable the middle-right control, false to disable it\n     * @param {Boolean} [options.mt] true to enable the middle-top control, false to disable it\n     * @param {Boolean} [options.tl] true to enable the top-left control, false to disable it\n     * @param {Boolean} [options.tr] true to enable the top-right control, false to disable it\n     * @param {Boolean} [options.mtr] true to enable the middle-top-rotate control, false to disable it\n     * @return {fabric.Object} thisArg\n     * @chainable\n     */\n    setControlsVisibility: function(options) {\n      options || (options = { });\n\n      for (var p in options) {\n        this.setControlVisible(p, options[p]);\n      }\n      return this;\n    },\n\n    /**\n     * Returns the instance of the control visibility set for this object.\n     * @private\n     * @returns {Object}\n     */\n    _getControlsVisibility: function() {\n      if (!this._controlsVisibility) {\n        this._controlsVisibility = {\n          tl: true,\n          tr: true,\n          br: true,\n          bl: true,\n          ml: true,\n          mt: true,\n          mr: true,\n          mb: true,\n          mtr: true\n        };\n      }\n      return this._controlsVisibility;\n    }\n  });\n})();\n\n\nfabric.util.object.extend(fabric.StaticCanvas.prototype, /** @lends fabric.StaticCanvas.prototype */ {\n\n  /**\n   * Animation duration (in ms) for fx* methods\n   * @type Number\n   * @default\n   */\n  FX_DURATION: 500,\n\n  /**\n   * Centers object horizontally with animation.\n   * @param {fabric.Object} object Object to center\n   * @param {Object} [callbacks] Callbacks object with optional \"onComplete\" and/or \"onChange\" properties\n   * @param {Function} [callbacks.onComplete] Invoked on completion\n   * @param {Function} [callbacks.onChange] Invoked on every step of animation\n   * @return {fabric.Canvas} thisArg\n   * @chainable\n   */\n  fxCenterObjectH: function (object, callbacks) {\n    callbacks = callbacks || { };\n\n    var empty = function() { },\n        onComplete = callbacks.onComplete || empty,\n        onChange = callbacks.onChange || empty,\n        _this = this;\n\n    fabric.util.animate({\n      startValue: object.get('left'),\n      endValue: this.getCenter().left,\n      duration: this.FX_DURATION,\n      onChange: function(value) {\n        object.set('left', value);\n        _this.renderAll();\n        onChange();\n      },\n      onComplete: function() {\n        object.setCoords();\n        onComplete();\n      }\n    });\n\n    return this;\n  },\n\n  /**\n   * Centers object vertically with animation.\n   * @param {fabric.Object} object Object to center\n   * @param {Object} [callbacks] Callbacks object with optional \"onComplete\" and/or \"onChange\" properties\n   * @param {Function} [callbacks.onComplete] Invoked on completion\n   * @param {Function} [callbacks.onChange] Invoked on every step of animation\n   * @return {fabric.Canvas} thisArg\n   * @chainable\n   */\n  fxCenterObjectV: function (object, callbacks) {\n    callbacks = callbacks || { };\n\n    var empty = function() { },\n        onComplete = callbacks.onComplete || empty,\n        onChange = callbacks.onChange || empty,\n        _this = this;\n\n    fabric.util.animate({\n      startValue: object.get('top'),\n      endValue: this.getCenter().top,\n      duration: this.FX_DURATION,\n      onChange: function(value) {\n        object.set('top', value);\n        _this.renderAll();\n        onChange();\n      },\n      onComplete: function() {\n        object.setCoords();\n        onComplete();\n      }\n    });\n\n    return this;\n  },\n\n  /**\n   * Same as `fabric.Canvas#remove` but animated\n   * @param {fabric.Object} object Object to remove\n   * @param {Object} [callbacks] Callbacks object with optional \"onComplete\" and/or \"onChange\" properties\n   * @param {Function} [callbacks.onComplete] Invoked on completion\n   * @param {Function} [callbacks.onChange] Invoked on every step of animation\n   * @return {fabric.Canvas} thisArg\n   * @chainable\n   */\n  fxRemove: function (object, callbacks) {\n    callbacks = callbacks || { };\n\n    var empty = function() { },\n        onComplete = callbacks.onComplete || empty,\n        onChange = callbacks.onChange || empty,\n        _this = this;\n\n    fabric.util.animate({\n      startValue: object.get('opacity'),\n      endValue: 0,\n      duration: this.FX_DURATION,\n      onStart: function() {\n        object.set('active', false);\n      },\n      onChange: function(value) {\n        object.set('opacity', value);\n        _this.renderAll();\n        onChange();\n      },\n      onComplete: function () {\n        _this.remove(object);\n        onComplete();\n      }\n    });\n\n    return this;\n  }\n});\n\nfabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {\n  /**\n   * Animates object's properties\n   * @param {String|Object} property Property to animate (if string) or properties to animate (if object)\n   * @param {Number|Object} value Value to animate property to (if string was given first) or options object\n   * @return {fabric.Object} thisArg\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-2#animation}\n   * @chainable\n   *\n   * As object \u2014 multiple properties\n   *\n   * object.animate({ left: ..., top: ... });\n   * object.animate({ left: ..., top: ... }, { duration: ... });\n   *\n   * As string \u2014 one property\n   *\n   * object.animate('left', ...);\n   * object.animate('left', { duration: ... });\n   *\n   */\n  animate: function() {\n    if (arguments[0] && typeof arguments[0] === 'object') {\n      var propsToAnimate = [ ], prop, skipCallbacks;\n      for (prop in arguments[0]) {\n        propsToAnimate.push(prop);\n      }\n      for (var i = 0, len = propsToAnimate.length; i < len; i++) {\n        prop = propsToAnimate[i];\n        skipCallbacks = i !== len - 1;\n        this._animate(prop, arguments[0][prop], arguments[1], skipCallbacks);\n      }\n    }\n    else {\n      this._animate.apply(this, arguments);\n    }\n    return this;\n  },\n\n  /**\n   * @private\n   * @param {String} property Property to animate\n   * @param {String} to Value to animate to\n   * @param {Object} [options] Options object\n   * @param {Boolean} [skipCallbacks] When true, callbacks like onchange and oncomplete are not invoked\n   */\n  _animate: function(property, to, options, skipCallbacks) {\n    var _this = this, propPair;\n\n    to = to.toString();\n\n    if (!options) {\n      options = { };\n    }\n    else {\n      options = fabric.util.object.clone(options);\n    }\n\n    if (~property.indexOf('.')) {\n      propPair = property.split('.');\n    }\n\n    var currentValue = propPair\n      ? this.get(propPair[0])[propPair[1]]\n      : this.get(property);\n\n    if (!('from' in options)) {\n      options.from = currentValue;\n    }\n\n    if (~to.indexOf('=')) {\n      to = currentValue + parseFloat(to.replace('=', ''));\n    }\n    else {\n      to = parseFloat(to);\n    }\n\n    fabric.util.animate({\n      startValue: options.from,\n      endValue: to,\n      byValue: options.by,\n      easing: options.easing,\n      duration: options.duration,\n      abort: options.abort && function() {\n        return options.abort.call(_this);\n      },\n      onChange: function(value) {\n        if (propPair) {\n          _this[propPair[0]][propPair[1]] = value;\n        }\n        else {\n          _this.set(property, value);\n        }\n        if (skipCallbacks) {\n          return;\n        }\n        options.onChange && options.onChange();\n      },\n      onComplete: function() {\n        if (skipCallbacks) {\n          return;\n        }\n\n        _this.setCoords();\n        options.onComplete && options.onComplete();\n      }\n    });\n  }\n});\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend,\n      coordProps = { x1: 1, x2: 1, y1: 1, y2: 1 },\n      supportsLineDash = fabric.StaticCanvas.supports('setLineDash');\n\n  if (fabric.Line) {\n    fabric.warn('fabric.Line is already defined');\n    return;\n  }\n\n  /**\n   * Line class\n   * @class fabric.Line\n   * @extends fabric.Object\n   * @see {@link fabric.Line#initialize} for constructor definition\n   */\n  fabric.Line = fabric.util.createClass(fabric.Object, /** @lends fabric.Line.prototype */ {\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'line',\n\n    /**\n     * x value or first line edge\n     * @type Number\n     * @default\n     */\n    x1: 0,\n\n    /**\n     * y value or first line edge\n     * @type Number\n     * @default\n     */\n    y1: 0,\n\n    /**\n     * x value or second line edge\n     * @type Number\n     * @default\n     */\n    x2: 0,\n\n    /**\n     * y value or second line edge\n     * @type Number\n     * @default\n     */\n    y2: 0,\n\n    /**\n     * Constructor\n     * @param {Array} [points] Array of points\n     * @param {Object} [options] Options object\n     * @return {fabric.Line} thisArg\n     */\n    initialize: function(points, options) {\n      options = options || { };\n\n      if (!points) {\n        points = [0, 0, 0, 0];\n      }\n\n      this.callSuper('initialize', options);\n\n      this.set('x1', points[0]);\n      this.set('y1', points[1]);\n      this.set('x2', points[2]);\n      this.set('y2', points[3]);\n\n      this._setWidthHeight(options);\n    },\n\n    /**\n     * @private\n     * @param {Object} [options] Options\n     */\n    _setWidthHeight: function(options) {\n      options || (options = { });\n\n      this.width = Math.abs(this.x2 - this.x1);\n      this.height = Math.abs(this.y2 - this.y1);\n\n      this.left = 'left' in options\n        ? options.left\n        : this._getLeftToOriginX();\n\n      this.top = 'top' in options\n        ? options.top\n        : this._getTopToOriginY();\n    },\n\n    /**\n     * @private\n     * @param {String} key\n     * @param {Any} value\n     */\n    _set: function(key, value) {\n      this.callSuper('_set', key, value);\n      if (typeof coordProps[key] !== 'undefined') {\n        this._setWidthHeight();\n      }\n      return this;\n    },\n\n    /**\n     * @private\n     * @return {Number} leftToOriginX Distance from left edge of canvas to originX of Line.\n     */\n    _getLeftToOriginX: makeEdgeToOriginGetter(\n      { // property names\n        origin: 'originX',\n        axis1: 'x1',\n        axis2: 'x2',\n        dimension: 'width'\n      },\n      { // possible values of origin\n        nearest: 'left',\n        center: 'center',\n        farthest: 'right'\n      }\n    ),\n\n    /**\n     * @private\n     * @return {Number} topToOriginY Distance from top edge of canvas to originY of Line.\n     */\n    _getTopToOriginY: makeEdgeToOriginGetter(\n      { // property names\n        origin: 'originY',\n        axis1: 'y1',\n        axis2: 'y2',\n        dimension: 'height'\n      },\n      { // possible values of origin\n        nearest: 'top',\n        center: 'center',\n        farthest: 'bottom'\n      }\n    ),\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _render: function(ctx, noTransform) {\n      ctx.beginPath();\n\n      if (noTransform) {\n        //  Line coords are distances from left-top of canvas to origin of line.\n        //  To render line in a path-group, we need to translate them to\n        //  distances from center of path-group to center of line.\n        var cp = this.getCenterPoint();\n        ctx.translate(\n          cp.x - this.strokeWidth / 2,\n          cp.y - this.strokeWidth / 2\n        );\n      }\n\n      if (!this.strokeDashArray || this.strokeDashArray && supportsLineDash) {\n        // move from center (of virtual box) to its left/top corner\n        // we can't assume x1, y1 is top left and x2, y2 is bottom right\n        var p = this.calcLinePoints();\n        ctx.moveTo(p.x1, p.y1);\n        ctx.lineTo(p.x2, p.y2);\n      }\n\n      ctx.lineWidth = this.strokeWidth;\n\n      // TODO: test this\n      // make sure setting \"fill\" changes color of a line\n      // (by copying fillStyle to strokeStyle, since line is stroked, not filled)\n      var origStrokeStyle = ctx.strokeStyle;\n      ctx.strokeStyle = this.stroke || ctx.fillStyle;\n      this.stroke && this._renderStroke(ctx);\n      ctx.strokeStyle = origStrokeStyle;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderDashedStroke: function(ctx) {\n      var p = this.calcLinePoints();\n\n      ctx.beginPath();\n      fabric.util.drawDashedLine(ctx, p.x1, p.y1, p.x2, p.y2, this.strokeDashArray);\n      ctx.closePath();\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @methd toObject\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      return extend(this.callSuper('toObject', propertiesToInclude), this.calcLinePoints());\n    },\n\n    /**\n     * Recalculates line points given width and height\n     * @private\n     */\n    calcLinePoints: function() {\n      var xMult = this.x1 <= this.x2 ? -1 : 1,\n          yMult = this.y1 <= this.y2 ? -1 : 1,\n          x1 = (xMult * this.width * 0.5),\n          y1 = (yMult * this.height * 0.5),\n          x2 = (xMult * this.width * -0.5),\n          y2 = (yMult * this.height * -0.5);\n\n      return {\n        x1: x1,\n        x2: x2,\n        y1: y1,\n        y2: y2\n      };\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns SVG representation of an instance\n     * @param {Function} [reviver] Method for further parsing of svg representation.\n     * @return {String} svg representation of an instance\n     */\n    toSVG: function(reviver) {\n      var markup = this._createBaseSVGMarkup(),\n          p = { x1: this.x1, x2: this.x2, y1: this.y1, y2: this.y2 };\n\n      if (!(this.group && this.group.type === 'path-group')) {\n        p = this.calcLinePoints();\n      }\n      markup.push(\n        '<line ',\n          'x1=\"', p.x1,\n          '\" y1=\"', p.y1,\n          '\" x2=\"', p.x2,\n          '\" y2=\"', p.y2,\n          '\" style=\"', this.getSvgStyles(),\n          '\" transform=\"', this.getSvgTransform(),\n          this.getSvgTransformMatrix(),\n        '\"/>\\n'\n      );\n\n      return reviver ? reviver(markup.join('')) : markup.join('');\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * Returns complexity of an instance\n     * @return {Number} complexity\n     */\n    complexity: function() {\n      return 1;\n    }\n  });\n\n  /* _FROM_SVG_START_ */\n  /**\n   * List of attribute names to account for when parsing SVG element (used by {@link fabric.Line.fromElement})\n   * @static\n   * @memberOf fabric.Line\n   * @see http://www.w3.org/TR/SVG/shapes.html#LineElement\n   */\n  fabric.Line.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat('x1 y1 x2 y2'.split(' '));\n\n  /**\n   * Returns fabric.Line instance from an SVG element\n   * @static\n   * @memberOf fabric.Line\n   * @param {SVGElement} element Element to parse\n   * @param {Object} [options] Options object\n   * @return {fabric.Line} instance of fabric.Line\n   */\n  fabric.Line.fromElement = function(element, options) {\n    var parsedAttributes = fabric.parseAttributes(element, fabric.Line.ATTRIBUTE_NAMES),\n        points = [\n          parsedAttributes.x1 || 0,\n          parsedAttributes.y1 || 0,\n          parsedAttributes.x2 || 0,\n          parsedAttributes.y2 || 0\n        ];\n    return new fabric.Line(points, extend(parsedAttributes, options));\n  };\n  /* _FROM_SVG_END_ */\n\n  /**\n   * Returns fabric.Line instance from an object representation\n   * @static\n   * @memberOf fabric.Line\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Line} instance of fabric.Line\n   */\n  fabric.Line.fromObject = function(object) {\n    var points = [object.x1, object.y1, object.x2, object.y2];\n    return new fabric.Line(points, object);\n  };\n\n  /**\n   * Produces a function that calculates distance from canvas edge to Line origin.\n   */\n  function makeEdgeToOriginGetter(propertyNames, originValues) {\n    var origin = propertyNames.origin,\n        axis1 = propertyNames.axis1,\n        axis2 = propertyNames.axis2,\n        dimension = propertyNames.dimension,\n        nearest = originValues.nearest,\n        center = originValues.center,\n        farthest = originValues.farthest;\n\n    return function() {\n      switch (this.get(origin)) {\n      case nearest:\n        return Math.min(this.get(axis1), this.get(axis2));\n      case center:\n        return Math.min(this.get(axis1), this.get(axis2)) + (0.5 * this.get(dimension));\n      case farthest:\n        return Math.max(this.get(axis1), this.get(axis2));\n      }\n    };\n\n  }\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { }),\n      pi = Math.PI,\n      extend = fabric.util.object.extend;\n\n  if (fabric.Circle) {\n    fabric.warn('fabric.Circle is already defined.');\n    return;\n  }\n\n  /**\n   * Circle class\n   * @class fabric.Circle\n   * @extends fabric.Object\n   * @see {@link fabric.Circle#initialize} for constructor definition\n   */\n  fabric.Circle = fabric.util.createClass(fabric.Object, /** @lends fabric.Circle.prototype */ {\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'circle',\n\n    /**\n     * Radius of this circle\n     * @type Number\n     * @default\n     */\n    radius: 0,\n\n    /**\n     * Start angle of the circle, moving clockwise\n     * @type Number\n     * @default 0\n     */\n    startAngle: 0,\n\n    /**\n     * End angle of the circle\n     * @type Number\n     * @default 2Pi\n     */\n    endAngle: pi * 2,\n\n    /**\n     * Constructor\n     * @param {Object} [options] Options object\n     * @return {fabric.Circle} thisArg\n     */\n    initialize: function(options) {\n      options = options || { };\n\n      this.callSuper('initialize', options);\n      this.set('radius', options.radius || 0);\n\n      this.startAngle = options.startAngle || this.startAngle;\n      this.endAngle = options.endAngle || this.endAngle;\n    },\n\n    /**\n     * @private\n     * @param {String} key\n     * @param {Any} value\n     * @return {fabric.Circle} thisArg\n     */\n    _set: function(key, value) {\n      this.callSuper('_set', key, value);\n\n      if (key === 'radius') {\n        this.setRadius(value);\n      }\n\n      return this;\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      return extend(this.callSuper('toObject', propertiesToInclude), {\n        radius: this.get('radius'),\n        startAngle: this.startAngle,\n        endAngle: this.endAngle\n      });\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns svg representation of an instance\n     * @param {Function} [reviver] Method for further parsing of svg representation.\n     * @return {String} svg representation of an instance\n     */\n    toSVG: function(reviver) {\n      var markup = this._createBaseSVGMarkup(), x = 0, y = 0,\n      angle = (this.endAngle - this.startAngle) % ( 2 * pi);\n\n      if (angle === 0) {\n        if (this.group && this.group.type === 'path-group') {\n          x = this.left + this.radius;\n          y = this.top + this.radius;\n        }\n        markup.push(\n          '<circle ',\n            'cx=\"' + x + '\" cy=\"' + y + '\" ',\n            'r=\"', this.radius,\n            '\" style=\"', this.getSvgStyles(),\n            '\" transform=\"', this.getSvgTransform(),\n            ' ', this.getSvgTransformMatrix(),\n          '\"/>\\n'\n        );\n      }\n      else {\n        var startX = Math.cos(this.startAngle) * this.radius,\n            startY = Math.sin(this.startAngle) * this.radius,\n            endX = Math.cos(this.endAngle) * this.radius,\n            endY = Math.sin(this.endAngle) * this.radius,\n            largeFlag = angle > pi ? '1' : '0';\n\n        markup.push(\n          '<path d=\"M ' + startX + ' ' + startY,\n          ' A ' + this.radius + ' ' + this.radius,\n          ' 0 ', + largeFlag + ' 1', ' ' + endX + ' ' + endY,\n          '\" style=\"', this.getSvgStyles(),\n          '\" transform=\"', this.getSvgTransform(),\n          ' ', this.getSvgTransformMatrix(),\n          '\"/>\\n'\n        );\n      }\n\n      return reviver ? reviver(markup.join('')) : markup.join('');\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx context to render on\n     * @param {Boolean} [noTransform] When true, context is not transformed\n     */\n    _render: function(ctx, noTransform) {\n      ctx.beginPath();\n      ctx.arc(noTransform ? this.left + this.radius : 0,\n              noTransform ? this.top + this.radius : 0,\n              this.radius,\n              this.startAngle,\n              this.endAngle, false);\n      this._renderFill(ctx);\n      this._renderStroke(ctx);\n    },\n\n    /**\n     * Returns horizontal radius of an object (according to how an object is scaled)\n     * @return {Number}\n     */\n    getRadiusX: function() {\n      return this.get('radius') * this.get('scaleX');\n    },\n\n    /**\n     * Returns vertical radius of an object (according to how an object is scaled)\n     * @return {Number}\n     */\n    getRadiusY: function() {\n      return this.get('radius') * this.get('scaleY');\n    },\n\n    /**\n     * Sets radius of an object (and updates width accordingly)\n     * @return {fabric.Circle} thisArg\n     */\n    setRadius: function(value) {\n      this.radius = value;\n      return this.set('width', value * 2).set('height', value * 2);\n    },\n\n    /**\n     * Returns complexity of an instance\n     * @return {Number} complexity of this instance\n     */\n    complexity: function() {\n      return 1;\n    }\n  });\n\n  /* _FROM_SVG_START_ */\n  /**\n   * List of attribute names to account for when parsing SVG element (used by {@link fabric.Circle.fromElement})\n   * @static\n   * @memberOf fabric.Circle\n   * @see: http://www.w3.org/TR/SVG/shapes.html#CircleElement\n   */\n  fabric.Circle.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat('cx cy r'.split(' '));\n\n  /**\n   * Returns {@link fabric.Circle} instance from an SVG element\n   * @static\n   * @memberOf fabric.Circle\n   * @param {SVGElement} element Element to parse\n   * @param {Object} [options] Options object\n   * @throws {Error} If value of `r` attribute is missing or invalid\n   * @return {fabric.Circle} Instance of fabric.Circle\n   */\n  fabric.Circle.fromElement = function(element, options) {\n    options || (options = { });\n\n    var parsedAttributes = fabric.parseAttributes(element, fabric.Circle.ATTRIBUTE_NAMES);\n\n    if (!isValidRadius(parsedAttributes)) {\n      throw new Error('value of `r` attribute is required and can not be negative');\n    }\n\n    parsedAttributes.left = parsedAttributes.left || 0;\n    parsedAttributes.top = parsedAttributes.top || 0;\n\n    var obj = new fabric.Circle(extend(parsedAttributes, options));\n\n    obj.left -= obj.radius;\n    obj.top -= obj.radius;\n    return obj;\n  };\n\n  /**\n   * @private\n   */\n  function isValidRadius(attributes) {\n    return (('radius' in attributes) && (attributes.radius >= 0));\n  }\n  /* _FROM_SVG_END_ */\n\n  /**\n   * Returns {@link fabric.Circle} instance from an object representation\n   * @static\n   * @memberOf fabric.Circle\n   * @param {Object} object Object to create an instance from\n   * @return {Object} Instance of fabric.Circle\n   */\n  fabric.Circle.fromObject = function(object) {\n    return new fabric.Circle(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { });\n\n  if (fabric.Triangle) {\n    fabric.warn('fabric.Triangle is already defined');\n    return;\n  }\n\n  /**\n   * Triangle class\n   * @class fabric.Triangle\n   * @extends fabric.Object\n   * @return {fabric.Triangle} thisArg\n   * @see {@link fabric.Triangle#initialize} for constructor definition\n   */\n  fabric.Triangle = fabric.util.createClass(fabric.Object, /** @lends fabric.Triangle.prototype */ {\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'triangle',\n\n    /**\n     * Constructor\n     * @param {Object} [options] Options object\n     * @return {Object} thisArg\n     */\n    initialize: function(options) {\n      options = options || { };\n\n      this.callSuper('initialize', options);\n\n      this.set('width', options.width || 100)\n          .set('height', options.height || 100);\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _render: function(ctx) {\n      var widthBy2 = this.width / 2,\n          heightBy2 = this.height / 2;\n\n      ctx.beginPath();\n      ctx.moveTo(-widthBy2, heightBy2);\n      ctx.lineTo(0, -heightBy2);\n      ctx.lineTo(widthBy2, heightBy2);\n      ctx.closePath();\n\n      this._renderFill(ctx);\n      this._renderStroke(ctx);\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderDashedStroke: function(ctx) {\n      var widthBy2 = this.width / 2,\n          heightBy2 = this.height / 2;\n\n      ctx.beginPath();\n      fabric.util.drawDashedLine(ctx, -widthBy2, heightBy2, 0, -heightBy2, this.strokeDashArray);\n      fabric.util.drawDashedLine(ctx, 0, -heightBy2, widthBy2, heightBy2, this.strokeDashArray);\n      fabric.util.drawDashedLine(ctx, widthBy2, heightBy2, -widthBy2, heightBy2, this.strokeDashArray);\n      ctx.closePath();\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns SVG representation of an instance\n     * @param {Function} [reviver] Method for further parsing of svg representation.\n     * @return {String} svg representation of an instance\n     */\n    toSVG: function(reviver) {\n      var markup = this._createBaseSVGMarkup(),\n          widthBy2 = this.width / 2,\n          heightBy2 = this.height / 2,\n          points = [\n            -widthBy2 + ' ' + heightBy2,\n            '0 ' + -heightBy2,\n            widthBy2 + ' ' + heightBy2\n          ]\n          .join(',');\n\n      markup.push(\n        '<polygon ',\n          'points=\"', points,\n          '\" style=\"', this.getSvgStyles(),\n          '\" transform=\"', this.getSvgTransform(),\n        '\"/>'\n      );\n\n      return reviver ? reviver(markup.join('')) : markup.join('');\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * Returns complexity of an instance\n     * @return {Number} complexity of this instance\n     */\n    complexity: function() {\n      return 1;\n    }\n  });\n\n  /**\n   * Returns fabric.Triangle instance from an object representation\n   * @static\n   * @memberOf fabric.Triangle\n   * @param {Object} object Object to create an instance from\n   * @return {Object} instance of Canvas.Triangle\n   */\n  fabric.Triangle.fromObject = function(object) {\n    return new fabric.Triangle(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { }),\n      piBy2   = Math.PI * 2,\n      extend = fabric.util.object.extend;\n\n  if (fabric.Ellipse) {\n    fabric.warn('fabric.Ellipse is already defined.');\n    return;\n  }\n\n  /**\n   * Ellipse class\n   * @class fabric.Ellipse\n   * @extends fabric.Object\n   * @return {fabric.Ellipse} thisArg\n   * @see {@link fabric.Ellipse#initialize} for constructor definition\n   */\n  fabric.Ellipse = fabric.util.createClass(fabric.Object, /** @lends fabric.Ellipse.prototype */ {\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'ellipse',\n\n    /**\n     * Horizontal radius\n     * @type Number\n     * @default\n     */\n    rx:   0,\n\n    /**\n     * Vertical radius\n     * @type Number\n     * @default\n     */\n    ry:   0,\n\n    /**\n     * Constructor\n     * @param {Object} [options] Options object\n     * @return {fabric.Ellipse} thisArg\n     */\n    initialize: function(options) {\n      options = options || { };\n\n      this.callSuper('initialize', options);\n\n      this.set('rx', options.rx || 0);\n      this.set('ry', options.ry || 0);\n    },\n\n    /**\n     * @private\n     * @param {String} key\n     * @param {Any} value\n     * @return {fabric.Ellipse} thisArg\n     */\n    _set: function(key, value) {\n      this.callSuper('_set', key, value);\n      switch (key) {\n\n        case 'rx':\n          this.rx = value;\n          this.set('width', value * 2);\n          break;\n\n        case 'ry':\n          this.ry = value;\n          this.set('height', value * 2);\n          break;\n\n      }\n      return this;\n    },\n\n    /**\n     * Returns horizontal radius of an object (according to how an object is scaled)\n     * @return {Number}\n     */\n    getRx: function() {\n      return this.get('rx') * this.get('scaleX');\n    },\n\n    /**\n     * Returns Vertical radius of an object (according to how an object is scaled)\n     * @return {Number}\n     */\n    getRy: function() {\n      return this.get('ry') * this.get('scaleY');\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      return extend(this.callSuper('toObject', propertiesToInclude), {\n        rx: this.get('rx'),\n        ry: this.get('ry')\n      });\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns svg representation of an instance\n     * @param {Function} [reviver] Method for further parsing of svg representation.\n     * @return {String} svg representation of an instance\n     */\n    toSVG: function(reviver) {\n      var markup = this._createBaseSVGMarkup(), x = 0, y = 0;\n      if (this.group && this.group.type === 'path-group') {\n        x = this.left + this.rx;\n        y = this.top + this.ry;\n      }\n      markup.push(\n        '<ellipse ',\n          'cx=\"', x, '\" cy=\"', y, '\" ',\n          'rx=\"', this.rx,\n          '\" ry=\"', this.ry,\n          '\" style=\"', this.getSvgStyles(),\n          '\" transform=\"', this.getSvgTransform(),\n          this.getSvgTransformMatrix(),\n        '\"/>\\n'\n      );\n\n      return reviver ? reviver(markup.join('')) : markup.join('');\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx context to render on\n     * @param {Boolean} [noTransform] When true, context is not transformed\n     */\n    _render: function(ctx, noTransform) {\n      ctx.beginPath();\n      ctx.save();\n      ctx.transform(1, 0, 0, this.ry/this.rx, 0, 0);\n      ctx.arc(\n        noTransform ? this.left + this.rx : 0,\n        noTransform ? (this.top + this.ry) * this.rx/this.ry : 0,\n        this.rx,\n        0,\n        piBy2,\n        false);\n      ctx.restore();\n      this._renderFill(ctx);\n      this._renderStroke(ctx);\n    },\n\n    /**\n     * Returns complexity of an instance\n     * @return {Number} complexity\n     */\n    complexity: function() {\n      return 1;\n    }\n  });\n\n  /* _FROM_SVG_START_ */\n  /**\n   * List of attribute names to account for when parsing SVG element (used by {@link fabric.Ellipse.fromElement})\n   * @static\n   * @memberOf fabric.Ellipse\n   * @see http://www.w3.org/TR/SVG/shapes.html#EllipseElement\n   */\n  fabric.Ellipse.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat('cx cy rx ry'.split(' '));\n\n  /**\n   * Returns {@link fabric.Ellipse} instance from an SVG element\n   * @static\n   * @memberOf fabric.Ellipse\n   * @param {SVGElement} element Element to parse\n   * @param {Object} [options] Options object\n   * @return {fabric.Ellipse}\n   */\n  fabric.Ellipse.fromElement = function(element, options) {\n    options || (options = { });\n\n    var parsedAttributes = fabric.parseAttributes(element, fabric.Ellipse.ATTRIBUTE_NAMES);\n\n    parsedAttributes.left = parsedAttributes.left || 0;\n    parsedAttributes.top = parsedAttributes.top || 0;\n\n    var ellipse = new fabric.Ellipse(extend(parsedAttributes, options));\n\n    ellipse.top -= ellipse.ry;\n    ellipse.left -= ellipse.rx;\n    return ellipse;\n  };\n  /* _FROM_SVG_END_ */\n\n  /**\n   * Returns {@link fabric.Ellipse} instance from an object representation\n   * @static\n   * @memberOf fabric.Ellipse\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Ellipse}\n   */\n  fabric.Ellipse.fromObject = function(object) {\n    return new fabric.Ellipse(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend;\n\n  if (fabric.Rect) {\n    fabric.warn('fabric.Rect is already defined');\n    return;\n  }\n\n  var stateProperties = fabric.Object.prototype.stateProperties.concat();\n  stateProperties.push('rx', 'ry', 'x', 'y');\n\n  /**\n   * Rectangle class\n   * @class fabric.Rect\n   * @extends fabric.Object\n   * @return {fabric.Rect} thisArg\n   * @see {@link fabric.Rect#initialize} for constructor definition\n   */\n  fabric.Rect = fabric.util.createClass(fabric.Object, /** @lends fabric.Rect.prototype */ {\n\n    /**\n     * List of properties to consider when checking if state of an object is changed ({@link fabric.Object#hasStateChanged})\n     * as well as for history (undo/redo) purposes\n     * @type Array\n     */\n    stateProperties: stateProperties,\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'rect',\n\n    /**\n     * Horizontal border radius\n     * @type Number\n     * @default\n     */\n    rx:   0,\n\n    /**\n     * Vertical border radius\n     * @type Number\n     * @default\n     */\n    ry:   0,\n\n    /**\n     * Used to specify dash pattern for stroke on this object\n     * @type Array\n     */\n    strokeDashArray: null,\n\n    /**\n     * Constructor\n     * @param {Object} [options] Options object\n     * @return {Object} thisArg\n     */\n    initialize: function(options) {\n      options = options || { };\n\n      this.callSuper('initialize', options);\n      this._initRxRy();\n\n    },\n\n    /**\n     * Initializes rx/ry attributes\n     * @private\n     */\n    _initRxRy: function() {\n      if (this.rx && !this.ry) {\n        this.ry = this.rx;\n      }\n      else if (this.ry && !this.rx) {\n        this.rx = this.ry;\n      }\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _render: function(ctx, noTransform) {\n\n      // optimize 1x1 case (used in spray brush)\n      if (this.width === 1 && this.height === 1) {\n        ctx.fillRect(-0.5, -0.5, 1, 1);\n        return;\n      }\n\n      var rx = this.rx ? Math.min(this.rx, this.width / 2) : 0,\n          ry = this.ry ? Math.min(this.ry, this.height / 2) : 0,\n          w = this.width,\n          h = this.height,\n          x = noTransform ? this.left : -this.width / 2,\n          y = noTransform ? this.top : -this.height / 2,\n          isRounded = rx !== 0 || ry !== 0,\n          k = 1 - 0.5522847498 /* \"magic number\" for bezier approximations of arcs (http://itc.ktu.lt/itc354/Riskus354.pdf) */;\n\n      ctx.beginPath();\n\n      ctx.moveTo(x + rx, y);\n\n      ctx.lineTo(x + w - rx, y);\n      isRounded && ctx.bezierCurveTo(x + w - k * rx, y, x + w, y + k * ry, x + w, y + ry);\n\n      ctx.lineTo(x + w, y + h - ry);\n      isRounded && ctx.bezierCurveTo(x + w, y + h - k * ry, x + w - k * rx, y + h, x + w - rx, y + h);\n\n      ctx.lineTo(x + rx, y + h);\n      isRounded && ctx.bezierCurveTo(x + k * rx, y + h, x, y + h - k * ry, x, y + h - ry);\n\n      ctx.lineTo(x, y + ry);\n      isRounded && ctx.bezierCurveTo(x, y + k * ry, x + k * rx, y, x + rx, y);\n\n      ctx.closePath();\n\n      this._renderFill(ctx);\n      this._renderStroke(ctx);\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderDashedStroke: function(ctx) {\n      var x = -this.width / 2,\n          y = -this.height / 2,\n          w = this.width,\n          h = this.height;\n\n      ctx.beginPath();\n      fabric.util.drawDashedLine(ctx, x, y, x + w, y, this.strokeDashArray);\n      fabric.util.drawDashedLine(ctx, x + w, y, x + w, y + h, this.strokeDashArray);\n      fabric.util.drawDashedLine(ctx, x + w, y + h, x, y + h, this.strokeDashArray);\n      fabric.util.drawDashedLine(ctx, x, y + h, x, y, this.strokeDashArray);\n      ctx.closePath();\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      var object = extend(this.callSuper('toObject', propertiesToInclude), {\n        rx: this.get('rx') || 0,\n        ry: this.get('ry') || 0\n      });\n      if (!this.includeDefaultValues) {\n        this._removeDefaultValues(object);\n      }\n      return object;\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns svg representation of an instance\n     * @param {Function} [reviver] Method for further parsing of svg representation.\n     * @return {String} svg representation of an instance\n     */\n    toSVG: function(reviver) {\n      var markup = this._createBaseSVGMarkup(), x = this.left, y = this.top;\n      if (!(this.group && this.group.type === 'path-group')) {\n        x = -this.width / 2;\n        y = -this.height / 2;\n      }\n      markup.push(\n        '<rect ',\n          'x=\"', x, '\" y=\"', y,\n          '\" rx=\"', this.get('rx'), '\" ry=\"', this.get('ry'),\n          '\" width=\"', this.width, '\" height=\"', this.height,\n          '\" style=\"', this.getSvgStyles(),\n          '\" transform=\"', this.getSvgTransform(),\n          this.getSvgTransformMatrix(),\n        '\"/>\\n');\n\n      return reviver ? reviver(markup.join('')) : markup.join('');\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * Returns complexity of an instance\n     * @return {Number} complexity\n     */\n    complexity: function() {\n      return 1;\n    }\n  });\n\n  /* _FROM_SVG_START_ */\n  /**\n   * List of attribute names to account for when parsing SVG element (used by `fabric.Rect.fromElement`)\n   * @static\n   * @memberOf fabric.Rect\n   * @see: http://www.w3.org/TR/SVG/shapes.html#RectElement\n   */\n  fabric.Rect.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat('x y rx ry width height'.split(' '));\n\n  /**\n   * Returns {@link fabric.Rect} instance from an SVG element\n   * @static\n   * @memberOf fabric.Rect\n   * @param {SVGElement} element Element to parse\n   * @param {Object} [options] Options object\n   * @return {fabric.Rect} Instance of fabric.Rect\n   */\n  fabric.Rect.fromElement = function(element, options) {\n    if (!element) {\n      return null;\n    }\n    options = options || { };\n\n    var parsedAttributes = fabric.parseAttributes(element, fabric.Rect.ATTRIBUTE_NAMES);\n\n    parsedAttributes.left = parsedAttributes.left || 0;\n    parsedAttributes.top  = parsedAttributes.top  || 0;\n    var rect = new fabric.Rect(extend((options ? fabric.util.object.clone(options) : { }), parsedAttributes));\n    rect.visible = rect.width > 0 && rect.height > 0;\n    return rect;\n  };\n  /* _FROM_SVG_END_ */\n\n  /**\n   * Returns {@link fabric.Rect} instance from an object representation\n   * @static\n   * @memberOf fabric.Rect\n   * @param {Object} object Object to create an instance from\n   * @return {Object} instance of fabric.Rect\n   */\n  fabric.Rect.fromObject = function(object) {\n    return new fabric.Rect(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { });\n\n  if (fabric.Polyline) {\n    fabric.warn('fabric.Polyline is already defined');\n    return;\n  }\n\n  /**\n   * Polyline class\n   * @class fabric.Polyline\n   * @extends fabric.Object\n   * @see {@link fabric.Polyline#initialize} for constructor definition\n   */\n  fabric.Polyline = fabric.util.createClass(fabric.Object, /** @lends fabric.Polyline.prototype */ {\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'polyline',\n\n    /**\n     * Points array\n     * @type Array\n     * @default\n     */\n    points: null,\n\n    /**\n     * Minimum X from points values, necessary to offset points\n     * @type Number\n     * @default\n     */\n    minX: 0,\n\n    /**\n     * Minimum Y from points values, necessary to offset points\n     * @type Number\n     * @default\n     */\n    minY: 0,\n\n    /**\n     * Constructor\n     * @param {Array} points Array of points (where each point is an object with x and y)\n     * @param {Object} [options] Options object\n     * @param {Boolean} [skipOffset] Whether points offsetting should be skipped\n     * @return {fabric.Polyline} thisArg\n     * @example\n     * var poly = new fabric.Polyline([\n     *     { x: 10, y: 10 },\n     *     { x: 50, y: 30 },\n     *     { x: 40, y: 70 },\n     *     { x: 60, y: 50 },\n     *     { x: 100, y: 150 },\n     *     { x: 40, y: 100 }\n     *   ], {\n     *   stroke: 'red',\n     *   left: 100,\n     *   top: 100\n     * });\n     */\n    initialize: function(points, options) {\n      return fabric.Polygon.prototype.initialize.call(this, points, options);\n    },\n\n    /**\n     * @private\n     */\n    _calcDimensions: function() {\n      return fabric.Polygon.prototype._calcDimensions.call(this);\n    },\n\n    /**\n     * @private\n     */\n    _applyPointOffset: function() {\n      return fabric.Polygon.prototype._applyPointOffset.call(this);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      return fabric.Polygon.prototype.toObject.call(this, propertiesToInclude);\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns SVG representation of an instance\n     * @param {Function} [reviver] Method for further parsing of svg representation.\n     * @return {String} svg representation of an instance\n     */\n    toSVG: function(reviver) {\n      return fabric.Polygon.prototype.toSVG.call(this, reviver);\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _render: function(ctx, noTransform) {\n      if (!fabric.Polygon.prototype.commonRender.call(this, ctx, noTransform)) {\n        return;\n      }\n      this._renderFill(ctx);\n      this._renderStroke(ctx);\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderDashedStroke: function(ctx) {\n      var p1, p2;\n\n      ctx.beginPath();\n      for (var i = 0, len = this.points.length; i < len; i++) {\n        p1 = this.points[i];\n        p2 = this.points[i + 1] || p1;\n        fabric.util.drawDashedLine(ctx, p1.x, p1.y, p2.x, p2.y, this.strokeDashArray);\n      }\n    },\n\n    /**\n     * Returns complexity of an instance\n     * @return {Number} complexity of this instance\n     */\n    complexity: function() {\n      return this.get('points').length;\n    }\n  });\n\n  /* _FROM_SVG_START_ */\n  /**\n   * List of attribute names to account for when parsing SVG element (used by {@link fabric.Polyline.fromElement})\n   * @static\n   * @memberOf fabric.Polyline\n   * @see: http://www.w3.org/TR/SVG/shapes.html#PolylineElement\n   */\n  fabric.Polyline.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat();\n\n  /**\n   * Returns fabric.Polyline instance from an SVG element\n   * @static\n   * @memberOf fabric.Polyline\n   * @param {SVGElement} element Element to parse\n   * @param {Object} [options] Options object\n   * @return {fabric.Polyline} Instance of fabric.Polyline\n   */\n  fabric.Polyline.fromElement = function(element, options) {\n    if (!element) {\n      return null;\n    }\n    options || (options = { });\n\n    var points = fabric.parsePointsAttribute(element.getAttribute('points')),\n        parsedAttributes = fabric.parseAttributes(element, fabric.Polyline.ATTRIBUTE_NAMES);\n\n    return new fabric.Polyline(points, fabric.util.object.extend(parsedAttributes, options));\n  };\n  /* _FROM_SVG_END_ */\n\n  /**\n   * Returns fabric.Polyline instance from an object representation\n   * @static\n   * @memberOf fabric.Polyline\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Polyline} Instance of fabric.Polyline\n   */\n  fabric.Polyline.fromObject = function(object) {\n    var points = object.points;\n    return new fabric.Polyline(points, object, true);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend,\n      min = fabric.util.array.min,\n      max = fabric.util.array.max,\n      toFixed = fabric.util.toFixed;\n\n  if (fabric.Polygon) {\n    fabric.warn('fabric.Polygon is already defined');\n    return;\n  }\n\n  /**\n   * Polygon class\n   * @class fabric.Polygon\n   * @extends fabric.Object\n   * @see {@link fabric.Polygon#initialize} for constructor definition\n   */\n  fabric.Polygon = fabric.util.createClass(fabric.Object, /** @lends fabric.Polygon.prototype */ {\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'polygon',\n\n    /**\n     * Points array\n     * @type Array\n     * @default\n     */\n    points: null,\n\n    /**\n     * Minimum X from points values, necessary to offset points\n     * @type Number\n     * @default\n     */\n    minX: 0,\n\n    /**\n     * Minimum Y from points values, necessary to offset points\n     * @type Number\n     * @default\n     */\n    minY: 0,\n\n    /**\n     * Constructor\n     * @param {Array} points Array of points\n     * @param {Object} [options] Options object\n     * @return {fabric.Polygon} thisArg\n     */\n    initialize: function(points, options) {\n      options = options || { };\n      this.points = points || [ ];\n      this.callSuper('initialize', options);\n      this._calcDimensions();\n      if (!('top' in options)) {\n        this.top = this.minY;\n      }\n      if (!('left' in options)) {\n        this.left = this.minX;\n      }\n      this.pathOffset = {\n        x: this.minX + this.width / 2,\n        y: this.minY + this.height / 2\n      };\n    },\n\n    /**\n     * @private\n     */\n    _calcDimensions: function() {\n\n      var points = this.points,\n          minX = min(points, 'x'),\n          minY = min(points, 'y'),\n          maxX = max(points, 'x'),\n          maxY = max(points, 'y');\n\n      this.width = (maxX - minX) || 0;\n      this.height = (maxY - minY) || 0;\n\n      this.minX = minX || 0,\n      this.minY = minY || 0;\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      return extend(this.callSuper('toObject', propertiesToInclude), {\n        points: this.points.concat()\n      });\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns svg representation of an instance\n     * @param {Function} [reviver] Method for further parsing of svg representation.\n     * @return {String} svg representation of an instance\n     */\n    toSVG: function(reviver) {\n      var points = [], addTransform,\n          markup = this._createBaseSVGMarkup();\n\n      for (var i = 0, len = this.points.length; i < len; i++) {\n        points.push(toFixed(this.points[i].x, 2), ',', toFixed(this.points[i].y, 2), ' ');\n      }\n      if (!(this.group && this.group.type === 'path-group')) {\n        addTransform = ' translate(' + (-this.pathOffset.x) + ', ' + (-this.pathOffset.y) + ') ';\n      }\n      markup.push(\n        '<', this.type, ' ',\n          'points=\"', points.join(''),\n          '\" style=\"', this.getSvgStyles(),\n          '\" transform=\"', this.getSvgTransform(), addTransform,\n          ' ', this.getSvgTransformMatrix(),\n        '\"/>\\n'\n      );\n\n      return reviver ? reviver(markup.join('')) : markup.join('');\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _render: function(ctx, noTransform) {\n      if (!this.commonRender(ctx, noTransform)) {\n        return;\n      }\n      this._renderFill(ctx);\n      if (this.stroke || this.strokeDashArray) {\n        ctx.closePath();\n        this._renderStroke(ctx);\n      }\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    commonRender: function(ctx, noTransform) {\n      var point, len = this.points.length;\n\n      if (!len || isNaN(this.points[len - 1].y)) {\n        // do not draw if no points or odd points\n        // NaN comes from parseFloat of a empty string in parser\n        return false;\n      }\n\n      noTransform || ctx.translate(-this.pathOffset.x, -this.pathOffset.y);\n      ctx.beginPath();\n      ctx.moveTo(this.points[0].x, this.points[0].y);\n      for (var i = 0; i < len; i++) {\n        point = this.points[i];\n        ctx.lineTo(point.x, point.y);\n      }\n      return true;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderDashedStroke: function(ctx) {\n      fabric.Polyline.prototype._renderDashedStroke.call(this, ctx);\n      ctx.closePath();\n    },\n\n    /**\n     * Returns complexity of an instance\n     * @return {Number} complexity of this instance\n     */\n    complexity: function() {\n      return this.points.length;\n    }\n  });\n\n  /* _FROM_SVG_START_ */\n  /**\n   * List of attribute names to account for when parsing SVG element (used by `fabric.Polygon.fromElement`)\n   * @static\n   * @memberOf fabric.Polygon\n   * @see: http://www.w3.org/TR/SVG/shapes.html#PolygonElement\n   */\n  fabric.Polygon.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat();\n\n  /**\n   * Returns {@link fabric.Polygon} instance from an SVG element\n   * @static\n   * @memberOf fabric.Polygon\n   * @param {SVGElement} element Element to parse\n   * @param {Object} [options] Options object\n   * @return {fabric.Polygon} Instance of fabric.Polygon\n   */\n  fabric.Polygon.fromElement = function(element, options) {\n    if (!element) {\n      return null;\n    }\n\n    options || (options = { });\n\n    var points = fabric.parsePointsAttribute(element.getAttribute('points')),\n        parsedAttributes = fabric.parseAttributes(element, fabric.Polygon.ATTRIBUTE_NAMES);\n\n    return new fabric.Polygon(points, extend(parsedAttributes, options));\n  };\n  /* _FROM_SVG_END_ */\n\n  /**\n   * Returns fabric.Polygon instance from an object representation\n   * @static\n   * @memberOf fabric.Polygon\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Polygon} Instance of fabric.Polygon\n   */\n  fabric.Polygon.fromObject = function(object) {\n    return new fabric.Polygon(object.points, object, true);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { }),\n      min = fabric.util.array.min,\n      max = fabric.util.array.max,\n      extend = fabric.util.object.extend,\n      _toString = Object.prototype.toString,\n      drawArc = fabric.util.drawArc,\n      commandLengths = {\n        m: 2,\n        l: 2,\n        h: 1,\n        v: 1,\n        c: 6,\n        s: 4,\n        q: 4,\n        t: 2,\n        a: 7\n      },\n      repeatedCommands = {\n        m: 'l',\n        M: 'L'\n      };\n\n  if (fabric.Path) {\n    fabric.warn('fabric.Path is already defined');\n    return;\n  }\n\n  /**\n   * Path class\n   * @class fabric.Path\n   * @extends fabric.Object\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-1#path_and_pathgroup}\n   * @see {@link fabric.Path#initialize} for constructor definition\n   */\n  fabric.Path = fabric.util.createClass(fabric.Object, /** @lends fabric.Path.prototype */ {\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'path',\n\n    /**\n     * Array of path points\n     * @type Array\n     * @default\n     */\n    path: null,\n\n    /**\n     * Minimum X from points values, necessary to offset points\n     * @type Number\n     * @default\n     */\n    minX: 0,\n\n    /**\n     * Minimum Y from points values, necessary to offset points\n     * @type Number\n     * @default\n     */\n    minY: 0,\n\n    /**\n     * Constructor\n     * @param {Array|String} path Path data (sequence of coordinates and corresponding \"command\" tokens)\n     * @param {Object} [options] Options object\n     * @return {fabric.Path} thisArg\n     */\n    initialize: function(path, options) {\n      options = options || { };\n\n      this.setOptions(options);\n\n      if (!path) {\n        path = [ ];\n      }\n\n      var fromArray = _toString.call(path) === '[object Array]';\n\n      this.path = fromArray\n        ? path\n        // one of commands (m,M,l,L,q,Q,c,C,etc.) followed by non-command characters (i.e. command values)\n        : path.match && path.match(/[mzlhvcsqta][^mzlhvcsqta]*/gi);\n\n      if (!this.path) {\n        return;\n      }\n\n      if (!fromArray) {\n        this.path = this._parsePath();\n      }\n\n      this._setPositionDimensions(options);\n\n      if (options.sourcePath) {\n        this.setSourcePath(options.sourcePath);\n      }\n    },\n\n    /**\n     * @private\n     * @param {Object} options Options object\n     */\n    _setPositionDimensions: function(options) {\n      var calcDim = this._parseDimensions();\n\n      this.minX = calcDim.left;\n      this.minY = calcDim.top;\n      this.width = calcDim.width;\n      this.height = calcDim.height;\n\n      if (typeof options.left === 'undefined') {\n        this.left = calcDim.left + (this.originX === 'center'\n          ? this.width / 2\n          : this.originX === 'right'\n            ? this.width\n            : 0);\n      }\n\n      if (typeof options.top === 'undefined') {\n        this.top = calcDim.top + (this.originY === 'center'\n          ? this.height / 2\n          : this.originY === 'bottom'\n            ? this.height\n            : 0);\n      }\n\n      this.pathOffset = this.pathOffset || {\n        x: this.minX + this.width / 2,\n        y: this.minY + this.height / 2\n      };\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx context to render path on\n     */\n    _render: function(ctx) {\n      var current, // current instruction\n          previous = null,\n          subpathStartX = 0,\n          subpathStartY = 0,\n          x = 0, // current x\n          y = 0, // current y\n          controlX = 0, // current control point x\n          controlY = 0, // current control point y\n          tempX,\n          tempY,\n          l = -this.pathOffset.x,\n          t = -this.pathOffset.y;\n\n      if (this.group && this.group.type === 'path-group') {\n        l = 0;\n        t = 0;\n      }\n\n      ctx.beginPath();\n\n      for (var i = 0, len = this.path.length; i < len; ++i) {\n\n        current = this.path[i];\n\n        switch (current[0]) { // first letter\n\n          case 'l': // lineto, relative\n            x += current[1];\n            y += current[2];\n            ctx.lineTo(x + l, y + t);\n            break;\n\n          case 'L': // lineto, absolute\n            x = current[1];\n            y = current[2];\n            ctx.lineTo(x + l, y + t);\n            break;\n\n          case 'h': // horizontal lineto, relative\n            x += current[1];\n            ctx.lineTo(x + l, y + t);\n            break;\n\n          case 'H': // horizontal lineto, absolute\n            x = current[1];\n            ctx.lineTo(x + l, y + t);\n            break;\n\n          case 'v': // vertical lineto, relative\n            y += current[1];\n            ctx.lineTo(x + l, y + t);\n            break;\n\n          case 'V': // verical lineto, absolute\n            y = current[1];\n            ctx.lineTo(x + l, y + t);\n            break;\n\n          case 'm': // moveTo, relative\n            x += current[1];\n            y += current[2];\n            subpathStartX = x;\n            subpathStartY = y;\n            ctx.moveTo(x + l, y + t);\n            break;\n\n          case 'M': // moveTo, absolute\n            x = current[1];\n            y = current[2];\n            subpathStartX = x;\n            subpathStartY = y;\n            ctx.moveTo(x + l, y + t);\n            break;\n\n          case 'c': // bezierCurveTo, relative\n            tempX = x + current[5];\n            tempY = y + current[6];\n            controlX = x + current[3];\n            controlY = y + current[4];\n            ctx.bezierCurveTo(\n              x + current[1] + l, // x1\n              y + current[2] + t, // y1\n              controlX + l, // x2\n              controlY + t, // y2\n              tempX + l,\n              tempY + t\n            );\n            x = tempX;\n            y = tempY;\n            break;\n\n          case 'C': // bezierCurveTo, absolute\n            x = current[5];\n            y = current[6];\n            controlX = current[3];\n            controlY = current[4];\n            ctx.bezierCurveTo(\n              current[1] + l,\n              current[2] + t,\n              controlX + l,\n              controlY + t,\n              x + l,\n              y + t\n            );\n            break;\n\n          case 's': // shorthand cubic bezierCurveTo, relative\n\n            // transform to absolute x,y\n            tempX = x + current[3];\n            tempY = y + current[4];\n\n            if (previous[0].match(/[CcSs]/) === null) {\n              // If there is no previous command or if the previous command was not a C, c, S, or s,\n              // the control point is coincident with the current point\n              controlX = x;\n              controlY = y;\n            }\n            else {\n              // calculate reflection of previous control points\n              controlX = 2 * x - controlX;\n              controlY = 2 * y - controlY;\n            }\n\n            ctx.bezierCurveTo(\n              controlX + l,\n              controlY + t,\n              x + current[1] + l,\n              y + current[2] + t,\n              tempX + l,\n              tempY + t\n            );\n            // set control point to 2nd one of this command\n            // \"... the first control point is assumed to be\n            // the reflection of the second control point on\n            // the previous command relative to the current point.\"\n            controlX = x + current[1];\n            controlY = y + current[2];\n\n            x = tempX;\n            y = tempY;\n            break;\n\n          case 'S': // shorthand cubic bezierCurveTo, absolute\n            tempX = current[3];\n            tempY = current[4];\n            if (previous[0].match(/[CcSs]/) === null) {\n              // If there is no previous command or if the previous command was not a C, c, S, or s,\n              // the control point is coincident with the current point\n              controlX = x;\n              controlY = y;\n            }\n            else {\n              // calculate reflection of previous control points\n              controlX = 2 * x - controlX;\n              controlY = 2 * y - controlY;\n            }\n            ctx.bezierCurveTo(\n              controlX + l,\n              controlY + t,\n              current[1] + l,\n              current[2] + t,\n              tempX + l,\n              tempY + t\n            );\n            x = tempX;\n            y = tempY;\n\n            // set control point to 2nd one of this command\n            // \"... the first control point is assumed to be\n            // the reflection of the second control point on\n            // the previous command relative to the current point.\"\n            controlX = current[1];\n            controlY = current[2];\n\n            break;\n\n          case 'q': // quadraticCurveTo, relative\n            // transform to absolute x,y\n            tempX = x + current[3];\n            tempY = y + current[4];\n\n            controlX = x + current[1];\n            controlY = y + current[2];\n\n            ctx.quadraticCurveTo(\n              controlX + l,\n              controlY + t,\n              tempX + l,\n              tempY + t\n            );\n            x = tempX;\n            y = tempY;\n            break;\n\n          case 'Q': // quadraticCurveTo, absolute\n            tempX = current[3];\n            tempY = current[4];\n\n            ctx.quadraticCurveTo(\n              current[1] + l,\n              current[2] + t,\n              tempX + l,\n              tempY + t\n            );\n            x = tempX;\n            y = tempY;\n            controlX = current[1];\n            controlY = current[2];\n            break;\n\n          case 't': // shorthand quadraticCurveTo, relative\n\n            // transform to absolute x,y\n            tempX = x + current[1];\n            tempY = y + current[2];\n\n            if (previous[0].match(/[QqTt]/) === null) {\n              // If there is no previous command or if the previous command was not a Q, q, T or t,\n              // assume the control point is coincident with the current point\n              controlX = x;\n              controlY = y;\n            }\n            else {\n              // calculate reflection of previous control point\n              controlX = 2 * x - controlX;\n              controlY = 2 * y - controlY;\n            }\n\n            ctx.quadraticCurveTo(\n              controlX + l,\n              controlY + t,\n              tempX + l,\n              tempY + t\n            );\n            x = tempX;\n            y = tempY;\n\n            break;\n\n          case 'T':\n            tempX = current[1];\n            tempY = current[2];\n\n            if (previous[0].match(/[QqTt]/) === null) {\n              // If there is no previous command or if the previous command was not a Q, q, T or t,\n              // assume the control point is coincident with the current point\n              controlX = x;\n              controlY = y;\n            }\n            else {\n              // calculate reflection of previous control point\n              controlX = 2 * x - controlX;\n              controlY = 2 * y - controlY;\n            }\n            ctx.quadraticCurveTo(\n              controlX + l,\n              controlY + t,\n              tempX + l,\n              tempY + t\n            );\n            x = tempX;\n            y = tempY;\n            break;\n\n          case 'a':\n            // TODO: optimize this\n            drawArc(ctx, x + l, y + t, [\n              current[1],\n              current[2],\n              current[3],\n              current[4],\n              current[5],\n              current[6] + x + l,\n              current[7] + y + t\n            ]);\n            x += current[6];\n            y += current[7];\n            break;\n\n          case 'A':\n            // TODO: optimize this\n            drawArc(ctx, x + l, y + t, [\n              current[1],\n              current[2],\n              current[3],\n              current[4],\n              current[5],\n              current[6] + l,\n              current[7] + t\n            ]);\n            x = current[6];\n            y = current[7];\n            break;\n\n          case 'z':\n          case 'Z':\n            x = subpathStartX;\n            y = subpathStartY;\n            ctx.closePath();\n            break;\n        }\n        previous = current;\n      }\n      this._renderFill(ctx);\n      this._renderStroke(ctx);\n    },\n\n    /**\n     * Returns string representation of an instance\n     * @return {String} string representation of an instance\n     */\n    toString: function() {\n      return '#<fabric.Path (' + this.complexity() +\n        '): { \"top\": ' + this.top + ', \"left\": ' + this.left + ' }>';\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      var o = extend(this.callSuper('toObject', propertiesToInclude), {\n        path: this.path.map(function(item) { return item.slice() }),\n        pathOffset: this.pathOffset\n      });\n      if (this.sourcePath) {\n        o.sourcePath = this.sourcePath;\n      }\n      if (this.transformMatrix) {\n        o.transformMatrix = this.transformMatrix;\n      }\n      return o;\n    },\n\n    /**\n     * Returns dataless object representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} object representation of an instance\n     */\n    toDatalessObject: function(propertiesToInclude) {\n      var o = this.toObject(propertiesToInclude);\n      if (this.sourcePath) {\n        o.path = this.sourcePath;\n      }\n      delete o.sourcePath;\n      return o;\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns svg representation of an instance\n     * @param {Function} [reviver] Method for further parsing of svg representation.\n     * @return {String} svg representation of an instance\n     */\n    toSVG: function(reviver) {\n      var chunks = [],\n          markup = this._createBaseSVGMarkup(), addTransform = '';\n\n      for (var i = 0, len = this.path.length; i < len; i++) {\n        chunks.push(this.path[i].join(' '));\n      }\n      var path = chunks.join(' ');\n      if (!(this.group && this.group.type === 'path-group')) {\n        addTransform = ' translate(' + (-this.pathOffset.x) + ', ' + (-this.pathOffset.y) + ') ';\n      }\n      markup.push(\n        //jscs:disable validateIndentation\n        '<path ',\n          'd=\"', path,\n          '\" style=\"', this.getSvgStyles(),\n          '\" transform=\"', this.getSvgTransform(), addTransform,\n          this.getSvgTransformMatrix(), '\" stroke-linecap=\"round\" ',\n        '/>\\n'\n        //jscs:enable validateIndentation\n      );\n\n      return reviver ? reviver(markup.join('')) : markup.join('');\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * Returns number representation of an instance complexity\n     * @return {Number} complexity of this instance\n     */\n    complexity: function() {\n      return this.path.length;\n    },\n\n    /**\n     * @private\n     */\n    _parsePath: function() {\n      var result = [ ],\n          coords = [ ],\n          currentPath,\n          parsed,\n          re = /([-+]?((\\d+\\.\\d+)|((\\d+)|(\\.\\d+)))(?:e[-+]?\\d+)?)/ig,\n          match,\n          coordsStr;\n\n      for (var i = 0, coordsParsed, len = this.path.length; i < len; i++) {\n        currentPath = this.path[i];\n\n        coordsStr = currentPath.slice(1).trim();\n        coords.length = 0;\n\n        while ((match = re.exec(coordsStr))) {\n          coords.push(match[0]);\n        }\n\n        coordsParsed = [ currentPath.charAt(0) ];\n\n        for (var j = 0, jlen = coords.length; j < jlen; j++) {\n          parsed = parseFloat(coords[j]);\n          if (!isNaN(parsed)) {\n            coordsParsed.push(parsed);\n          }\n        }\n\n        var command = coordsParsed[0],\n            commandLength = commandLengths[command.toLowerCase()],\n            repeatedCommand = repeatedCommands[command] || command;\n\n        if (coordsParsed.length - 1 > commandLength) {\n          for (var k = 1, klen = coordsParsed.length; k < klen; k += commandLength) {\n            result.push([ command ].concat(coordsParsed.slice(k, k + commandLength)));\n            command = repeatedCommand;\n          }\n        }\n        else {\n          result.push(coordsParsed);\n        }\n      }\n\n      return result;\n    },\n\n    /**\n     * @private\n     */\n    _parseDimensions: function() {\n\n      var aX = [],\n          aY = [],\n          current, // current instruction\n          previous = null,\n          subpathStartX = 0,\n          subpathStartY = 0,\n          x = 0, // current x\n          y = 0, // current y\n          controlX = 0, // current control point x\n          controlY = 0, // current control point y\n          tempX,\n          tempY,\n          bounds;\n\n      for (var i = 0, len = this.path.length; i < len; ++i) {\n\n        current = this.path[i];\n\n        switch (current[0]) { // first letter\n\n          case 'l': // lineto, relative\n            x += current[1];\n            y += current[2];\n            bounds = [ ];\n            break;\n\n          case 'L': // lineto, absolute\n            x = current[1];\n            y = current[2];\n            bounds = [ ];\n            break;\n\n          case 'h': // horizontal lineto, relative\n            x += current[1];\n            bounds = [ ];\n            break;\n\n          case 'H': // horizontal lineto, absolute\n            x = current[1];\n            bounds = [ ];\n            break;\n\n          case 'v': // vertical lineto, relative\n            y += current[1];\n            bounds = [ ];\n            break;\n\n          case 'V': // verical lineto, absolute\n            y = current[1];\n            bounds = [ ];\n            break;\n\n          case 'm': // moveTo, relative\n            x += current[1];\n            y += current[2];\n            subpathStartX = x;\n            subpathStartY = y;\n            bounds = [ ];\n            break;\n\n          case 'M': // moveTo, absolute\n            x = current[1];\n            y = current[2];\n            subpathStartX = x;\n            subpathStartY = y;\n            bounds = [ ];\n            break;\n\n          case 'c': // bezierCurveTo, relative\n            tempX = x + current[5];\n            tempY = y + current[6];\n            controlX = x + current[3];\n            controlY = y + current[4];\n            bounds = fabric.util.getBoundsOfCurve(x, y,\n              x + current[1], // x1\n              y + current[2], // y1\n              controlX, // x2\n              controlY, // y2\n              tempX,\n              tempY\n            );\n            x = tempX;\n            y = tempY;\n            break;\n\n          case 'C': // bezierCurveTo, absolute\n            x = current[5];\n            y = current[6];\n            controlX = current[3];\n            controlY = current[4];\n            bounds = fabric.util.getBoundsOfCurve(x, y,\n              current[1],\n              current[2],\n              controlX,\n              controlY,\n              x,\n              y\n            );\n            break;\n\n          case 's': // shorthand cubic bezierCurveTo, relative\n\n            // transform to absolute x,y\n            tempX = x + current[3];\n            tempY = y + current[4];\n\n            if (previous[0].match(/[CcSs]/) === null) {\n              // If there is no previous command or if the previous command was not a C, c, S, or s,\n              // the control point is coincident with the current point\n              controlX = x;\n              controlY = y;\n            }\n            else {\n              // calculate reflection of previous control points\n              controlX = 2 * x - controlX;\n              controlY = 2 * y - controlY;\n            }\n\n            bounds = fabric.util.getBoundsOfCurve(x, y,\n              controlX,\n              controlY,\n              x + current[1],\n              y + current[2],\n              tempX,\n              tempY\n            );\n            // set control point to 2nd one of this command\n            // \"... the first control point is assumed to be\n            // the reflection of the second control point on\n            // the previous command relative to the current point.\"\n            controlX = x + current[1];\n            controlY = y + current[2];\n            x = tempX;\n            y = tempY;\n            break;\n\n          case 'S': // shorthand cubic bezierCurveTo, absolute\n            tempX = current[3];\n            tempY = current[4];\n            if (previous[0].match(/[CcSs]/) === null) {\n              // If there is no previous command or if the previous command was not a C, c, S, or s,\n              // the control point is coincident with the current point\n              controlX = x;\n              controlY = y;\n            }\n            else {\n              // calculate reflection of previous control points\n              controlX = 2 * x - controlX;\n              controlY = 2 * y - controlY;\n            }\n            bounds = fabric.util.getBoundsOfCurve(x, y,\n              controlX,\n              controlY,\n              current[1],\n              current[2],\n              tempX,\n              tempY\n            );\n            x = tempX;\n            y = tempY;\n            // set control point to 2nd one of this command\n            // \"... the first control point is assumed to be\n            // the reflection of the second control point on\n            // the previous command relative to the current point.\"\n            controlX = current[1];\n            controlY = current[2];\n            break;\n\n          case 'q': // quadraticCurveTo, relative\n            // transform to absolute x,y\n            tempX = x + current[3];\n            tempY = y + current[4];\n            controlX = x + current[1];\n            controlY = y + current[2];\n            bounds = fabric.util.getBoundsOfCurve(x, y,\n              controlX,\n              controlY,\n              controlX,\n              controlY,\n              tempX,\n              tempY\n            );\n            x = tempX;\n            y = tempY;\n            break;\n\n          case 'Q': // quadraticCurveTo, absolute\n            controlX = current[1];\n            controlY = current[2];\n            bounds = fabric.util.getBoundsOfCurve(x, y,\n              controlX,\n              controlY,\n              controlX,\n              controlY,\n              current[3],\n              current[4]\n            );\n            x = current[3];\n            y = current[4];\n            break;\n\n          case 't': // shorthand quadraticCurveTo, relative\n            // transform to absolute x,y\n            tempX = x + current[1];\n            tempY = y + current[2];\n            if (previous[0].match(/[QqTt]/) === null) {\n              // If there is no previous command or if the previous command was not a Q, q, T or t,\n              // assume the control point is coincident with the current point\n              controlX = x;\n              controlY = y;\n            }\n            else {\n              // calculate reflection of previous control point\n              controlX = 2 * x - controlX;\n              controlY = 2 * y - controlY;\n            }\n\n            bounds = fabric.util.getBoundsOfCurve(x, y,\n              controlX,\n              controlY,\n              controlX,\n              controlY,\n              tempX,\n              tempY\n            );\n            x = tempX;\n            y = tempY;\n\n            break;\n\n          case 'T':\n            tempX = current[1];\n            tempY = current[2];\n\n            if (previous[0].match(/[QqTt]/) === null) {\n              // If there is no previous command or if the previous command was not a Q, q, T or t,\n              // assume the control point is coincident with the current point\n              controlX = x;\n              controlY = y;\n            }\n            else {\n              // calculate reflection of previous control point\n              controlX = 2 * x - controlX;\n              controlY = 2 * y - controlY;\n            }\n            bounds = fabric.util.getBoundsOfCurve(x, y,\n              controlX,\n              controlY,\n              controlX,\n              controlY,\n              tempX,\n              tempY\n            );\n            x = tempX;\n            y = tempY;\n            break;\n\n          case 'a':\n            // TODO: optimize this\n            bounds = fabric.util.getBoundsOfArc(x, y,\n              current[1],\n              current[2],\n              current[3],\n              current[4],\n              current[5],\n              current[6] + x,\n              current[7] + y\n            );\n            x += current[6];\n            y += current[7];\n            break;\n\n          case 'A':\n            // TODO: optimize this\n            bounds = fabric.util.getBoundsOfArc(x, y,\n              current[1],\n              current[2],\n              current[3],\n              current[4],\n              current[5],\n              current[6],\n              current[7]\n            );\n            x = current[6];\n            y = current[7];\n            break;\n\n          case 'z':\n          case 'Z':\n            x = subpathStartX;\n            y = subpathStartY;\n            break;\n        }\n        previous = current;\n        bounds.forEach(function (point) {\n          aX.push(point.x);\n          aY.push(point.y);\n        });\n        aX.push(x);\n        aY.push(y);\n      }\n\n      var minX = min(aX) || 0,\n          minY = min(aY) || 0,\n          maxX = max(aX) || 0,\n          maxY = max(aY) || 0,\n          deltaX = maxX - minX,\n          deltaY = maxY - minY,\n\n          o = {\n            left: minX,\n            top: minY,\n            width: deltaX,\n            height: deltaY\n          };\n\n      return o;\n    }\n  });\n\n  /**\n   * Creates an instance of fabric.Path from an object\n   * @static\n   * @memberOf fabric.Path\n   * @param {Object} object\n   * @param {Function} callback Callback to invoke when an fabric.Path instance is created\n   */\n  fabric.Path.fromObject = function(object, callback) {\n    if (typeof object.path === 'string') {\n      fabric.loadSVGFromURL(object.path, function (elements) {\n        var path = elements[0],\n            pathUrl = object.path;\n\n        delete object.path;\n\n        fabric.util.object.extend(path, object);\n        path.setSourcePath(pathUrl);\n\n        callback(path);\n      });\n    }\n    else {\n      callback(new fabric.Path(object.path, object));\n    }\n  };\n\n  /* _FROM_SVG_START_ */\n  /**\n   * List of attribute names to account for when parsing SVG element (used by `fabric.Path.fromElement`)\n   * @static\n   * @memberOf fabric.Path\n   * @see http://www.w3.org/TR/SVG/paths.html#PathElement\n   */\n  fabric.Path.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat(['d']);\n\n  /**\n   * Creates an instance of fabric.Path from an SVG <path> element\n   * @static\n   * @memberOf fabric.Path\n   * @param {SVGElement} element to parse\n   * @param {Function} callback Callback to invoke when an fabric.Path instance is created\n   * @param {Object} [options] Options object\n   */\n  fabric.Path.fromElement = function(element, callback, options) {\n    var parsedAttributes = fabric.parseAttributes(element, fabric.Path.ATTRIBUTE_NAMES);\n    callback && callback(new fabric.Path(parsedAttributes.d, extend(parsedAttributes, options)));\n  };\n  /* _FROM_SVG_END_ */\n\n  /**\n   * Indicates that instances of this type are async\n   * @static\n   * @memberOf fabric.Path\n   * @type Boolean\n   * @default\n   */\n  fabric.Path.async = true;\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend,\n      invoke = fabric.util.array.invoke,\n      parentToObject = fabric.Object.prototype.toObject;\n\n  if (fabric.PathGroup) {\n    fabric.warn('fabric.PathGroup is already defined');\n    return;\n  }\n\n  /**\n   * Path group class\n   * @class fabric.PathGroup\n   * @extends fabric.Path\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-1#path_and_pathgroup}\n   * @see {@link fabric.PathGroup#initialize} for constructor definition\n   */\n  fabric.PathGroup = fabric.util.createClass(fabric.Path, /** @lends fabric.PathGroup.prototype */ {\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'path-group',\n\n    /**\n     * Fill value\n     * @type String\n     * @default\n     */\n    fill: '',\n\n    /**\n     * Constructor\n     * @param {Array} paths\n     * @param {Object} [options] Options object\n     * @return {fabric.PathGroup} thisArg\n     */\n    initialize: function(paths, options) {\n\n      options = options || { };\n      this.paths = paths || [ ];\n\n      for (var i = this.paths.length; i--;) {\n        this.paths[i].group = this;\n      }\n\n      if (options.toBeParsed) {\n        this.parseDimensionsFromPaths(options);\n        delete options.toBeParsed;\n      }\n      this.setOptions(options);\n      this.setCoords();\n\n      if (options.sourcePath) {\n        this.setSourcePath(options.sourcePath);\n      }\n    },\n\n    /**\n     * Calculate width and height based on paths contained\n     */\n    parseDimensionsFromPaths: function(options) {\n      var points, p, xC = [ ], yC = [ ], path, height, width,\n          m;\n      for (var j = this.paths.length; j--;) {\n        path = this.paths[j];\n        height = path.height + path.strokeWidth;\n        width = path.width + path.strokeWidth;\n        points = [\n          { x: path.left, y: path.top },\n          { x: path.left + width, y: path.top },\n          { x: path.left, y: path.top + height },\n          { x: path.left + width, y: path.top + height }\n        ];\n        m = this.paths[j].transformMatrix;\n        for (var i = 0; i < points.length; i++) {\n          p = points[i];\n          if (m) {\n            p = fabric.util.transformPoint(p, m, false);\n          }\n          xC.push(p.x);\n          yC.push(p.y);\n        }\n      }\n      options.width = Math.max.apply(null, xC);\n      options.height = Math.max.apply(null, yC);\n    },\n\n    /**\n     * Renders this group on a specified context\n     * @param {CanvasRenderingContext2D} ctx Context to render this instance on\n     */\n    render: function(ctx) {\n      // do not render if object is not visible\n      if (!this.visible) {\n        return;\n      }\n\n      ctx.save();\n\n      if (this.transformMatrix) {\n        ctx.transform.apply(ctx, this.transformMatrix);\n      }\n      this.transform(ctx);\n\n      this._setShadow(ctx);\n      this.clipTo && fabric.util.clipContext(this, ctx);\n      ctx.translate(-this.width/2, -this.height/2);\n      for (var i = 0, l = this.paths.length; i < l; ++i) {\n        this.paths[i].render(ctx, true);\n      }\n      this.clipTo && ctx.restore();\n      ctx.restore();\n    },\n\n    /**\n     * Sets certain property to a certain value\n     * @param {String} prop\n     * @param {Any} value\n     * @return {fabric.PathGroup} thisArg\n     */\n    _set: function(prop, value) {\n\n      if (prop === 'fill' && value && this.isSameColor()) {\n        var i = this.paths.length;\n        while (i--) {\n          this.paths[i]._set(prop, value);\n        }\n      }\n\n      return this.callSuper('_set', prop, value);\n    },\n\n    /**\n     * Returns object representation of this path group\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      var o = extend(parentToObject.call(this, propertiesToInclude), {\n        paths: invoke(this.getObjects(), 'toObject', propertiesToInclude)\n      });\n      if (this.sourcePath) {\n        o.sourcePath = this.sourcePath;\n      }\n      return o;\n    },\n\n    /**\n     * Returns dataless object representation of this path group\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} dataless object representation of an instance\n     */\n    toDatalessObject: function(propertiesToInclude) {\n      var o = this.toObject(propertiesToInclude);\n      if (this.sourcePath) {\n        o.paths = this.sourcePath;\n      }\n      return o;\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns svg representation of an instance\n     * @param {Function} [reviver] Method for further parsing of svg representation.\n     * @return {String} svg representation of an instance\n     */\n    toSVG: function(reviver) {\n      var objects = this.getObjects(),\n          p = this.getPointByOrigin('left', 'top'),\n          translatePart = 'translate(' + p.x + ' ' + p.y + ')',\n          markup = this._createBaseSVGMarkup();\n      markup.push(\n        '<g ',\n        'style=\"', this.getSvgStyles(), '\" ',\n        'transform=\"', this.getSvgTransformMatrix(), translatePart, this.getSvgTransform(), '\" ',\n        '>\\n'\n      );\n\n      for (var i = 0, len = objects.length; i < len; i++) {\n        markup.push('\\t', objects[i].toSVG(reviver));\n      }\n      markup.push('</g>\\n');\n\n      return reviver ? reviver(markup.join('')) : markup.join('');\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * Returns a string representation of this path group\n     * @return {String} string representation of an object\n     */\n    toString: function() {\n      return '#<fabric.PathGroup (' + this.complexity() +\n        '): { top: ' + this.top + ', left: ' + this.left + ' }>';\n    },\n\n    /**\n     * Returns true if all paths in this group are of same color\n     * @return {Boolean} true if all paths are of the same color (`fill`)\n     */\n    isSameColor: function() {\n      var firstPathFill = this.getObjects()[0].get('fill') || '';\n      if (typeof firstPathFill !== 'string') {\n        return false;\n      }\n      firstPathFill = firstPathFill.toLowerCase();\n      return this.getObjects().every(function(path) {\n        var pathFill = path.get('fill') || '';\n        return typeof pathFill === 'string' && (pathFill).toLowerCase() === firstPathFill;\n      });\n    },\n\n    /**\n     * Returns number representation of object's complexity\n     * @return {Number} complexity\n     */\n    complexity: function() {\n      return this.paths.reduce(function(total, path) {\n        return total + ((path && path.complexity) ? path.complexity() : 0);\n      }, 0);\n    },\n\n    /**\n     * Returns all paths in this path group\n     * @return {Array} array of path objects included in this path group\n     */\n    getObjects: function() {\n      return this.paths;\n    }\n  });\n\n  /**\n   * Creates fabric.PathGroup instance from an object representation\n   * @static\n   * @memberOf fabric.PathGroup\n   * @param {Object} object Object to create an instance from\n   * @param {Function} callback Callback to invoke when an fabric.PathGroup instance is created\n   */\n  fabric.PathGroup.fromObject = function(object, callback) {\n    if (typeof object.paths === 'string') {\n      fabric.loadSVGFromURL(object.paths, function (elements) {\n\n        var pathUrl = object.paths;\n        delete object.paths;\n\n        var pathGroup = fabric.util.groupSVGElements(elements, object, pathUrl);\n\n        callback(pathGroup);\n      });\n    }\n    else {\n      fabric.util.enlivenObjects(object.paths, function(enlivenedObjects) {\n        delete object.paths;\n        callback(new fabric.PathGroup(enlivenedObjects, object));\n      });\n    }\n  };\n\n  /**\n   * Indicates that instances of this type are async\n   * @static\n   * @memberOf fabric.PathGroup\n   * @type Boolean\n   * @default\n   */\n  fabric.PathGroup.async = true;\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend,\n      min = fabric.util.array.min,\n      max = fabric.util.array.max,\n      invoke = fabric.util.array.invoke;\n\n  if (fabric.Group) {\n    return;\n  }\n\n  // lock-related properties, for use in fabric.Group#get\n  // to enable locking behavior on group\n  // when one of its objects has lock-related properties set\n  var _lockProperties = {\n    lockMovementX:  true,\n    lockMovementY:  true,\n    lockRotation:   true,\n    lockScalingX:   true,\n    lockScalingY:   true,\n    lockUniScaling: true\n  };\n\n  /**\n   * Group class\n   * @class fabric.Group\n   * @extends fabric.Object\n   * @mixes fabric.Collection\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-3#groups}\n   * @see {@link fabric.Group#initialize} for constructor definition\n   */\n  fabric.Group = fabric.util.createClass(fabric.Object, fabric.Collection, /** @lends fabric.Group.prototype */ {\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'group',\n\n    /**\n     * Width of stroke\n     * @type Number\n     * @default\n     */\n    strokeWidth: 0,\n\n    /**\n     * Constructor\n     * @param {Object} objects Group objects\n     * @param {Object} [options] Options object\n     * @param {Boolean} [isAlreadyGrouped] if true, objects have been grouped already.\n     * @return {Object} thisArg\n     */\n    initialize: function(objects, options, isAlreadyGrouped) {\n      options = options || { };\n\n      this._objects = [];\n      // if objects enclosed in a group have been grouped already,\n      // we cannot change properties of objects.\n      // Thus we need to set options to group without objects,\n      // because delegatedProperties propagate to objects.\n      isAlreadyGrouped && this.callSuper('initialize', options);\n\n      this._objects = objects || [];\n      for (var i = this._objects.length; i--; ) {\n        this._objects[i].group = this;\n      }\n\n      this.originalState = { };\n\n      if (options.originX) {\n        this.originX = options.originX;\n      }\n      if (options.originY) {\n        this.originY = options.originY;\n      }\n\n      if (isAlreadyGrouped) {\n        // do not change coordinate of objects enclosed in a group,\n        // because objects coordinate system have been group coodinate system already.\n        this._updateObjectsCoords(true);\n      }\n      else {\n        this._calcBounds();\n        this._updateObjectsCoords();\n        this.callSuper('initialize', options);\n      }\n\n      this.setCoords();\n      this.saveCoords();\n    },\n\n    /**\n     * @private\n     * @param {Boolean} [skipCoordsChange] if true, coordinates of objects enclosed in a group do not change\n     */\n    _updateObjectsCoords: function(skipCoordsChange) {\n      for (var i = this._objects.length; i--; ){\n        this._updateObjectCoords(this._objects[i], skipCoordsChange);\n      }\n    },\n\n    /**\n     * @private\n     * @param {Object} object\n     * @param {Boolean} [skipCoordsChange] if true, coordinates of object dose not change\n     */\n    _updateObjectCoords: function(object, skipCoordsChange) {\n      // do not display corners of objects enclosed in a group\n      object.__origHasControls = object.hasControls;\n      object.hasControls = false;\n\n      if (skipCoordsChange) {\n        return;\n      }\n\n      var objectLeft = object.getLeft(),\n          objectTop = object.getTop(),\n          center = this.getCenterPoint();\n\n      object.set({\n        originalLeft: objectLeft,\n        originalTop: objectTop,\n        left: objectLeft - center.x,\n        top: objectTop - center.y\n      });\n      object.setCoords();\n    },\n\n    /**\n     * Returns string represenation of a group\n     * @return {String}\n     */\n    toString: function() {\n      return '#<fabric.Group: (' + this.complexity() + ')>';\n    },\n\n    /**\n     * Adds an object to a group; Then recalculates group's dimension, position.\n     * @param {Object} object\n     * @return {fabric.Group} thisArg\n     * @chainable\n     */\n    addWithUpdate: function(object) {\n      this._restoreObjectsState();\n      fabric.util.resetObjectTransform(this);\n      if (object) {\n        this._objects.push(object);\n        object.group = this;\n        object._set('canvas', this.canvas);\n      }\n      // since _restoreObjectsState set objects inactive\n      this.forEachObject(this._setObjectActive, this);\n      this._calcBounds();\n      this._updateObjectsCoords();\n      return this;\n    },\n\n    /**\n     * @private\n     */\n    _setObjectActive: function(object) {\n      object.set('active', true);\n      object.group = this;\n    },\n\n    /**\n     * Removes an object from a group; Then recalculates group's dimension, position.\n     * @param {Object} object\n     * @return {fabric.Group} thisArg\n     * @chainable\n     */\n    removeWithUpdate: function(object) {\n      this._restoreObjectsState();\n      fabric.util.resetObjectTransform(this);\n      // since _restoreObjectsState set objects inactive\n      this.forEachObject(this._setObjectActive, this);\n\n      this.remove(object);\n      this._calcBounds();\n      this._updateObjectsCoords();\n\n      return this;\n    },\n\n    /**\n     * @private\n     */\n    _onObjectAdded: function(object) {\n      object.group = this;\n      object._set('canvas', this.canvas);\n    },\n\n    /**\n     * @private\n     */\n    _onObjectRemoved: function(object) {\n      delete object.group;\n      object.set('active', false);\n    },\n\n    /**\n     * Properties that are delegated to group objects when reading/writing\n     * @param {Object} delegatedProperties\n     */\n    delegatedProperties: {\n      fill:             true,\n      stroke:           true,\n      strokeWidth:      true,\n      fontFamily:       true,\n      fontWeight:       true,\n      fontSize:         true,\n      fontStyle:        true,\n      lineHeight:       true,\n      textDecoration:   true,\n      textAlign:        true,\n      backgroundColor:  true\n    },\n\n    /**\n     * @private\n     */\n    _set: function(key, value) {\n      var i = this._objects.length;\n\n      if (this.delegatedProperties[key] || key === 'canvas') {\n        while (i--) {\n          this._objects[i].set(key, value);\n        }\n      }\n      else {\n        while (i--) {\n          this._objects[i].setOnGroup(key, value);\n        }\n      }\n\n      this.callSuper('_set', key, value);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      return extend(this.callSuper('toObject', propertiesToInclude), {\n        objects: invoke(this._objects, 'toObject', propertiesToInclude)\n      });\n    },\n\n    /**\n     * Renders instance on a given context\n     * @param {CanvasRenderingContext2D} ctx context to render instance on\n     */\n    render: function(ctx) {\n      // do not render if object is not visible\n      if (!this.visible) {\n        return;\n      }\n\n      ctx.save();\n      if (this.transformMatrix) {\n        ctx.transform.apply(ctx, this.transformMatrix);\n      }\n      this.transform(ctx);\n      this._setShadow(ctx);\n      this.clipTo && fabric.util.clipContext(this, ctx);\n      // the array is now sorted in order of highest first, so start from end\n      for (var i = 0, len = this._objects.length; i < len; i++) {\n        this._renderObject(this._objects[i], ctx);\n      }\n\n      this.clipTo && ctx.restore();\n\n      ctx.restore();\n    },\n\n    /**\n     * Renders controls and borders for the object\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Boolean} [noTransform] When true, context is not transformed\n     */\n    _renderControls: function(ctx, noTransform) {\n      this.callSuper('_renderControls', ctx, noTransform);\n      for (var i = 0, len = this._objects.length; i < len; i++) {\n        this._objects[i]._renderControls(ctx);\n      }\n    },\n\n    /**\n     * @private\n     */\n    _renderObject: function(object, ctx) {\n      // do not render if object is not visible\n      if (!object.visible) {\n        return;\n      }\n\n      var originalHasRotatingPoint = object.hasRotatingPoint;\n      object.hasRotatingPoint = false;\n      object.render(ctx);\n      object.hasRotatingPoint = originalHasRotatingPoint;\n    },\n\n    /**\n     * Retores original state of each of group objects (original state is that which was before group was created).\n     * @private\n     * @return {fabric.Group} thisArg\n     * @chainable\n     */\n    _restoreObjectsState: function() {\n      this._objects.forEach(this._restoreObjectState, this);\n      return this;\n    },\n\n    /**\n     * Realises the transform from this group onto the supplied object\n     * i.e. it tells you what would happen if the supplied object was in\n     * the group, and then the group was destroyed. It mutates the supplied\n     * object.\n     * @param {fabric.Object} object\n     * @return {fabric.Object} transformedObject\n     */\n    realizeTransform: function(object) {\n      var matrix = object.calcTransformMatrix(),\n          options = fabric.util.qrDecompose(matrix),\n          center = new fabric.Point(options.translateX, options.translateY);\n      object.scaleX = options.scaleX;\n      object.scaleY = options.scaleY;\n      object.skewX = options.skewX;\n      object.skewY = options.skewY;\n      object.angle = options.angle;\n      object.flipX = false;\n      object.flipY = false;\n      object.setPositionByOrigin(center, 'center', 'center');\n      return object;\n    },\n\n    /**\n     * Restores original state of a specified object in group\n     * @private\n     * @param {fabric.Object} object\n     * @return {fabric.Group} thisArg\n     */\n    _restoreObjectState: function(object) {\n      this.realizeTransform(object);\n      object.setCoords();\n      object.hasControls = object.__origHasControls;\n      delete object.__origHasControls;\n      object.set('active', false);\n      delete object.group;\n\n      return this;\n    },\n\n    /**\n     * Destroys a group (restoring state of its objects)\n     * @return {fabric.Group} thisArg\n     * @chainable\n     */\n    destroy: function() {\n      return this._restoreObjectsState();\n    },\n\n    /**\n     * Saves coordinates of this instance (to be used together with `hasMoved`)\n     * @saveCoords\n     * @return {fabric.Group} thisArg\n     * @chainable\n     */\n    saveCoords: function() {\n      this._originalLeft = this.get('left');\n      this._originalTop = this.get('top');\n      return this;\n    },\n\n    /**\n     * Checks whether this group was moved (since `saveCoords` was called last)\n     * @return {Boolean} true if an object was moved (since fabric.Group#saveCoords was called)\n     */\n    hasMoved: function() {\n      return this._originalLeft !== this.get('left') ||\n             this._originalTop !== this.get('top');\n    },\n\n    /**\n     * Sets coordinates of all group objects\n     * @return {fabric.Group} thisArg\n     * @chainable\n     */\n    setObjectsCoords: function() {\n      this.forEachObject(function(object) {\n        object.setCoords();\n      });\n      return this;\n    },\n\n    /**\n     * @private\n     */\n    _calcBounds: function(onlyWidthHeight) {\n      var aX = [],\n          aY = [],\n          o, prop,\n          props = ['tr', 'br', 'bl', 'tl'],\n          i = 0, iLen = this._objects.length,\n          j, jLen = props.length;\n\n      for ( ; i < iLen; ++i) {\n        o = this._objects[i];\n        o.setCoords();\n        for (j = 0; j < jLen; j++) {\n          prop = props[j];\n          aX.push(o.oCoords[prop].x);\n          aY.push(o.oCoords[prop].y);\n        }\n      }\n\n      this.set(this._getBounds(aX, aY, onlyWidthHeight));\n    },\n\n    /**\n     * @private\n     */\n    _getBounds: function(aX, aY, onlyWidthHeight) {\n      var ivt = fabric.util.invertTransform(this.getViewportTransform()),\n          minXY = fabric.util.transformPoint(new fabric.Point(min(aX), min(aY)), ivt),\n          maxXY = fabric.util.transformPoint(new fabric.Point(max(aX), max(aY)), ivt),\n          obj = {\n            width: (maxXY.x - minXY.x) || 0,\n            height: (maxXY.y - minXY.y) || 0\n          };\n\n      if (!onlyWidthHeight) {\n        obj.left = minXY.x || 0;\n        obj.top = minXY.y || 0;\n        if (this.originX === 'center') {\n          obj.left += obj.width / 2;\n        }\n        if (this.originX === 'right') {\n          obj.left += obj.width;\n        }\n        if (this.originY === 'center') {\n          obj.top += obj.height / 2;\n        }\n        if (this.originY === 'bottom') {\n          obj.top += obj.height;\n        }\n      }\n      return obj;\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns svg representation of an instance\n     * @param {Function} [reviver] Method for further parsing of svg representation.\n     * @return {String} svg representation of an instance\n     */\n    toSVG: function(reviver) {\n      var markup = this._createBaseSVGMarkup();\n      markup.push(\n        '<g transform=\"',\n        /* avoiding styles intentionally */\n        this.getSvgTransform(),\n        this.getSvgTransformMatrix(),\n        '\" style=\"',\n        this.getSvgFilter(),\n        '\">\\n'\n      );\n\n      for (var i = 0, len = this._objects.length; i < len; i++) {\n        markup.push('\\t', this._objects[i].toSVG(reviver));\n      }\n\n      markup.push('</g>\\n');\n\n      return reviver ? reviver(markup.join('')) : markup.join('');\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * Returns requested property\n     * @param {String} prop Property to get\n     * @return {Any}\n     */\n    get: function(prop) {\n      if (prop in _lockProperties) {\n        if (this[prop]) {\n          return this[prop];\n        }\n        else {\n          for (var i = 0, len = this._objects.length; i < len; i++) {\n            if (this._objects[i][prop]) {\n              return true;\n            }\n          }\n          return false;\n        }\n      }\n      else {\n        if (prop in this.delegatedProperties) {\n          return this._objects[0] && this._objects[0].get(prop);\n        }\n        return this[prop];\n      }\n    }\n  });\n\n  /**\n   * Returns {@link fabric.Group} instance from an object representation\n   * @static\n   * @memberOf fabric.Group\n   * @param {Object} object Object to create a group from\n   * @param {Function} [callback] Callback to invoke when an group instance is created\n   * @return {fabric.Group} An instance of fabric.Group\n   */\n  fabric.Group.fromObject = function(object, callback) {\n    fabric.util.enlivenObjects(object.objects, function(enlivenedObjects) {\n      delete object.objects;\n      callback && callback(new fabric.Group(enlivenedObjects, object, true));\n    });\n  };\n\n  /**\n   * Indicates that instances of this type are async\n   * @static\n   * @memberOf fabric.Group\n   * @type Boolean\n   * @default\n   */\n  fabric.Group.async = true;\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var extend = fabric.util.object.extend;\n\n  if (!global.fabric) {\n    global.fabric = { };\n  }\n\n  if (global.fabric.Image) {\n    fabric.warn('fabric.Image is already defined.');\n    return;\n  }\n\n  /**\n   * Image class\n   * @class fabric.Image\n   * @extends fabric.Object\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-1#images}\n   * @see {@link fabric.Image#initialize} for constructor definition\n   */\n  fabric.Image = fabric.util.createClass(fabric.Object, /** @lends fabric.Image.prototype */ {\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'image',\n\n    /**\n     * crossOrigin value (one of \"\", \"anonymous\", \"use-credentials\")\n     * @see https://developer.mozilla.org/en-US/docs/HTML/CORS_settings_attributes\n     * @type String\n     * @default\n     */\n    crossOrigin: '',\n\n    /**\n     * AlignX value, part of preserveAspectRatio (one of \"none\", \"mid\", \"min\", \"max\")\n     * @see http://www.w3.org/TR/SVG/coords.html#PreserveAspectRatioAttribute\n     * This parameter defines how the picture is aligned to its viewport when image element width differs from image width.\n     * @type String\n     * @default\n     */\n    alignX: 'none',\n\n    /**\n     * AlignY value, part of preserveAspectRatio (one of \"none\", \"mid\", \"min\", \"max\")\n     * @see http://www.w3.org/TR/SVG/coords.html#PreserveAspectRatioAttribute\n     * This parameter defines how the picture is aligned to its viewport when image element height differs from image height.\n     * @type String\n     * @default\n     */\n    alignY: 'none',\n\n    /**\n     * meetOrSlice value, part of preserveAspectRatio  (one of \"meet\", \"slice\").\n     * if meet the image is always fully visibile, if slice the viewport is always filled with image.\n     * @see http://www.w3.org/TR/SVG/coords.html#PreserveAspectRatioAttribute\n     * @type String\n     * @default\n     */\n    meetOrSlice: 'meet',\n\n    /**\n     * Width of a stroke.\n     * For image quality a stroke multiple of 2 gives better results.\n     * @type Number\n     * @default\n     */\n    strokeWidth: 0,\n\n    /**\n     * private\n     * contains last value of scaleX to detect\n     * if the Image got resized after the last Render\n     * @type Number\n     */\n    _lastScaleX: 1,\n\n    /**\n     * private\n     * contains last value of scaleY to detect\n     * if the Image got resized after the last Render\n     * @type Number\n     */\n    _lastScaleY: 1,\n\n    /**\n     * Constructor\n     * @param {HTMLImageElement | String} element Image element\n     * @param {Object} [options] Options object\n     * @return {fabric.Image} thisArg\n     */\n    initialize: function(element, options) {\n      options || (options = { });\n      this.filters = [ ];\n      this.resizeFilters = [ ];\n      this.callSuper('initialize', options);\n      this._initElement(element, options);\n    },\n\n    /**\n     * Returns image element which this instance if based on\n     * @return {HTMLImageElement} Image element\n     */\n    getElement: function() {\n      return this._element;\n    },\n\n    /**\n     * Sets image element for this instance to a specified one.\n     * If filters defined they are applied to new image.\n     * You might need to call `canvas.renderAll` and `object.setCoords` after replacing, to render new image and update controls area.\n     * @param {HTMLImageElement} element\n     * @param {Function} [callback] Callback is invoked when all filters have been applied and new image is generated\n     * @param {Object} [options] Options object\n     * @return {fabric.Image} thisArg\n     * @chainable\n     */\n    setElement: function(element, callback, options) {\n      this._element = element;\n      this._originalElement = element;\n      this._initConfig(options);\n\n      if (this.filters.length !== 0) {\n        this.applyFilters(callback);\n      }\n      else if (callback) {\n        callback();\n      }\n\n      return this;\n    },\n\n    /**\n     * Sets crossOrigin value (on an instance and corresponding image element)\n     * @return {fabric.Image} thisArg\n     * @chainable\n     */\n    setCrossOrigin: function(value) {\n      this.crossOrigin = value;\n      this._element.crossOrigin = value;\n\n      return this;\n    },\n\n    /**\n     * Returns original size of an image\n     * @return {Object} Object with \"width\" and \"height\" properties\n     */\n    getOriginalSize: function() {\n      var element = this.getElement();\n      return {\n        width: element.width,\n        height: element.height\n      };\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _stroke: function(ctx) {\n      if (!this.stroke || this.strokeWidth === 0) {\n        return;\n      }\n      var w = this.width / 2, h = this.height / 2;\n      ctx.beginPath();\n      ctx.moveTo(-w, -h);\n      ctx.lineTo(w, -h);\n      ctx.lineTo(w, h);\n      ctx.lineTo(-w, h);\n      ctx.lineTo(-w, -h);\n      ctx.closePath();\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderDashedStroke: function(ctx) {\n      var x = -this.width / 2,\n          y = -this.height / 2,\n          w = this.width,\n          h = this.height;\n\n      ctx.save();\n      this._setStrokeStyles(ctx);\n\n      ctx.beginPath();\n      fabric.util.drawDashedLine(ctx, x, y, x + w, y, this.strokeDashArray);\n      fabric.util.drawDashedLine(ctx, x + w, y, x + w, y + h, this.strokeDashArray);\n      fabric.util.drawDashedLine(ctx, x + w, y + h, x, y + h, this.strokeDashArray);\n      fabric.util.drawDashedLine(ctx, x, y + h, x, y, this.strokeDashArray);\n      ctx.closePath();\n      ctx.restore();\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      var filters = [ ], resizeFilters = [ ],\n          element = this._originalElement,\n          scaleX = 1, scaleY = 1;\n\n      this.filters.forEach(function(filterObj) {\n        if (filterObj) {\n          if (filterObj.type === 'Resize') {\n            scaleX *= filterObj.scaleX;\n            scaleY *= filterObj.scaleY;\n          }\n          filters.push(filterObj.toObject());\n        }\n      });\n\n      this.resizeFilters.forEach(function(filterObj) {\n        filterObj && resizeFilters.push(filterObj.toObject());\n      });\n\n      var object = extend(this.callSuper('toObject', propertiesToInclude), {\n        src: element ? element.src || element._src : '',\n        filters: filters,\n        resizeFilters: resizeFilters,\n        crossOrigin: this.crossOrigin,\n        alignX: this.alignX,\n        alignY: this.alignY,\n        meetOrSlice: this.meetOrSlice\n      });\n\n      object.width /= scaleX;\n      object.height /= scaleY;\n\n      if (!this.includeDefaultValues) {\n        this._removeDefaultValues(object);\n      }\n\n      return object;\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns SVG representation of an instance\n     * @param {Function} [reviver] Method for further parsing of svg representation.\n     * @return {String} svg representation of an instance\n     */\n    toSVG: function(reviver) {\n      var markup = this._createBaseSVGMarkup(), x = -this.width / 2, y = -this.height / 2,\n          preserveAspectRatio = 'none';\n      if (this.group && this.group.type === 'path-group') {\n        x = this.left;\n        y = this.top;\n      }\n      if (this.alignX !== 'none' && this.alignY !== 'none') {\n        preserveAspectRatio = 'x' + this.alignX + 'Y' + this.alignY + ' ' + this.meetOrSlice;\n      }\n      markup.push(\n        '<g transform=\"', this.getSvgTransform(), this.getSvgTransformMatrix(), '\">\\n',\n          '<image xlink:href=\"', this.getSvgSrc(),\n            '\" x=\"', x, '\" y=\"', y,\n            '\" style=\"', this.getSvgStyles(),\n            // we're essentially moving origin of transformation from top/left corner to the center of the shape\n            // by wrapping it in container <g> element with actual transformation, then offsetting object to the top/left\n            // so that object's center aligns with container's left/top\n            '\" width=\"', this.width,\n            '\" height=\"', this.height,\n            '\" preserveAspectRatio=\"', preserveAspectRatio, '\"',\n          '></image>\\n'\n      );\n\n      if (this.stroke || this.strokeDashArray) {\n        var origFill = this.fill;\n        this.fill = null;\n        markup.push(\n          '<rect ',\n            'x=\"', x, '\" y=\"', y,\n            '\" width=\"', this.width, '\" height=\"', this.height,\n            '\" style=\"', this.getSvgStyles(),\n          '\"/>\\n'\n        );\n        this.fill = origFill;\n      }\n\n      markup.push('</g>\\n');\n\n      return reviver ? reviver(markup.join('')) : markup.join('');\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * Returns source of an image\n     * @return {String} Source of an image\n     */\n    getSrc: function() {\n      if (this.getElement()) {\n        return this.getElement().src || this.getElement()._src;\n      }\n    },\n\n    /**\n     * Sets source of an image\n     * @param {String} src Source string (URL)\n     * @param {Function} [callback] Callback is invoked when image has been loaded (and all filters have been applied)\n     * @param {Object} [options] Options object\n     * @return {fabric.Image} thisArg\n     * @chainable\n     */\n    setSrc: function(src, callback, options) {\n      fabric.util.loadImage(src, function(img) {\n        return this.setElement(img, callback, options);\n      }, this, options && options.crossOrigin);\n    },\n\n    /**\n     * Returns string representation of an instance\n     * @return {String} String representation of an instance\n     */\n    toString: function() {\n      return '#<fabric.Image: { src: \"' + this.getSrc() + '\" }>';\n    },\n\n    /**\n     * Returns a clone of an instance\n     * @param {Function} callback Callback is invoked with a clone as a first argument\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     */\n    clone: function(callback, propertiesToInclude) {\n      this.constructor.fromObject(this.toObject(propertiesToInclude), callback);\n    },\n\n    /**\n     * Applies filters assigned to this image (from \"filters\" array)\n     * @method applyFilters\n     * @param {Function} callback Callback is invoked when all filters have been applied and new image is generated\n     * @return {fabric.Image} thisArg\n     * @chainable\n     */\n    applyFilters: function(callback, filters, imgElement, forResizing) {\n\n      filters = filters || this.filters;\n      imgElement = imgElement || this._originalElement;\n\n      if (!imgElement) {\n        return;\n      }\n\n      var imgEl = imgElement,\n          canvasEl = fabric.util.createCanvasElement(),\n          replacement = fabric.util.createImage(),\n          _this = this;\n\n      canvasEl.width = imgEl.width;\n      canvasEl.height = imgEl.height;\n      canvasEl.getContext('2d').drawImage(imgEl, 0, 0, imgEl.width, imgEl.height);\n\n      if (filters.length === 0) {\n        this._element = imgElement;\n        callback && callback();\n        return canvasEl;\n      }\n      filters.forEach(function(filter) {\n        filter && filter.applyTo(canvasEl, filter.scaleX || _this.scaleX, filter.scaleY || _this.scaleY);\n        if (!forResizing && filter && filter.type === 'Resize') {\n          _this.width *= filter.scaleX;\n          _this.height *= filter.scaleY;\n        }\n      });\n\n      /** @ignore */\n      replacement.width = canvasEl.width;\n      replacement.height = canvasEl.height;\n\n      if (fabric.isLikelyNode) {\n        replacement.src = canvasEl.toBuffer(undefined, fabric.Image.pngCompression);\n        // onload doesn't fire in some node versions, so we invoke callback manually\n        _this._element = replacement;\n        !forResizing && (_this._filteredEl = replacement);\n        callback && callback();\n      }\n      else {\n        replacement.onload = function() {\n          _this._element = replacement;\n          !forResizing && (_this._filteredEl = replacement);\n          callback && callback();\n          replacement.onload = canvasEl = imgEl = null;\n        };\n        replacement.src = canvasEl.toDataURL('image/png');\n      }\n      return canvasEl;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _render: function(ctx, noTransform) {\n      var x, y, imageMargins = this._findMargins(), elementToDraw;\n\n      x = (noTransform ? this.left : -this.width / 2);\n      y = (noTransform ? this.top : -this.height / 2);\n\n      if (this.meetOrSlice === 'slice') {\n        ctx.beginPath();\n        ctx.rect(x, y, this.width, this.height);\n        ctx.clip();\n      }\n\n      if (this.isMoving === false && this.resizeFilters.length && this._needsResize()) {\n        this._lastScaleX = this.scaleX;\n        this._lastScaleY = this.scaleY;\n        elementToDraw = this.applyFilters(null, this.resizeFilters, this._filteredEl || this._originalElement, true);\n      }\n      else {\n        elementToDraw = this._element;\n      }\n      elementToDraw && ctx.drawImage(elementToDraw,\n                                     x + imageMargins.marginX,\n                                     y + imageMargins.marginY,\n                                     imageMargins.width,\n                                     imageMargins.height\n                                    );\n\n      this._stroke(ctx);\n      this._renderStroke(ctx);\n    },\n\n    /**\n     * @private, needed to check if image needs resize\n     */\n    _needsResize: function() {\n      return (this.scaleX !== this._lastScaleX || this.scaleY !== this._lastScaleY);\n    },\n\n    /**\n     * @private\n     */\n    _findMargins: function() {\n      var width = this.width, height = this.height, scales,\n          scale, marginX = 0, marginY = 0;\n\n      if (this.alignX !== 'none' || this.alignY !== 'none') {\n        scales = [this.width / this._element.width, this.height / this._element.height];\n        scale = this.meetOrSlice === 'meet'\n                ? Math.min.apply(null, scales) : Math.max.apply(null, scales);\n        width = this._element.width * scale;\n        height = this._element.height * scale;\n        if (this.alignX === 'Mid') {\n          marginX = (this.width - width) / 2;\n        }\n        if (this.alignX === 'Max') {\n          marginX = this.width - width;\n        }\n        if (this.alignY === 'Mid') {\n          marginY = (this.height - height) / 2;\n        }\n        if (this.alignY === 'Max') {\n          marginY = this.height - height;\n        }\n      }\n      return {\n        width:  width,\n        height: height,\n        marginX: marginX,\n        marginY: marginY\n      };\n    },\n\n    /**\n     * @private\n     */\n    _resetWidthHeight: function() {\n      var element = this.getElement();\n\n      this.set('width', element.width);\n      this.set('height', element.height);\n    },\n\n    /**\n     * The Image class's initialization method. This method is automatically\n     * called by the constructor.\n     * @private\n     * @param {HTMLImageElement|String} element The element representing the image\n     * @param {Object} [options] Options object\n     */\n    _initElement: function(element, options) {\n      this.setElement(fabric.util.getById(element), null, options);\n      fabric.util.addClass(this.getElement(), fabric.Image.CSS_CANVAS);\n    },\n\n    /**\n     * @private\n     * @param {Object} [options] Options object\n     */\n    _initConfig: function(options) {\n      options || (options = { });\n      this.setOptions(options);\n      this._setWidthHeight(options);\n      if (this._element && this.crossOrigin) {\n        this._element.crossOrigin = this.crossOrigin;\n      }\n    },\n\n    /**\n     * @private\n     * @param {Array} filters to be initialized\n     * @param {Function} callback Callback to invoke when all fabric.Image.filters instances are created\n     */\n    _initFilters: function(filters, callback) {\n      if (filters && filters.length) {\n        fabric.util.enlivenObjects(filters, function(enlivenedObjects) {\n          callback && callback(enlivenedObjects);\n        }, 'fabric.Image.filters');\n      }\n      else {\n        callback && callback();\n      }\n    },\n\n    /**\n     * @private\n     * @param {Object} [options] Object with width/height properties\n     */\n    _setWidthHeight: function(options) {\n      this.width = 'width' in options\n        ? options.width\n        : (this.getElement()\n            ? this.getElement().width || 0\n            : 0);\n\n      this.height = 'height' in options\n        ? options.height\n        : (this.getElement()\n            ? this.getElement().height || 0\n            : 0);\n    },\n\n    /**\n     * Returns complexity of an instance\n     * @return {Number} complexity of this instance\n     */\n    complexity: function() {\n      return 1;\n    }\n  });\n\n  /**\n   * Default CSS class name for canvas\n   * @static\n   * @type String\n   * @default\n   */\n  fabric.Image.CSS_CANVAS = 'canvas-img';\n\n  /**\n   * Alias for getSrc\n   * @static\n   */\n  fabric.Image.prototype.getSvgSrc = fabric.Image.prototype.getSrc;\n\n  /**\n   * Creates an instance of fabric.Image from its object representation\n   * @static\n   * @param {Object} object Object to create an instance from\n   * @param {Function} [callback] Callback to invoke when an image instance is created\n   */\n  fabric.Image.fromObject = function(object, callback) {\n    fabric.util.loadImage(object.src, function(img) {\n      fabric.Image.prototype._initFilters.call(object, object.filters, function(filters) {\n        object.filters = filters || [ ];\n        fabric.Image.prototype._initFilters.call(object, object.resizeFilters, function(resizeFilters) {\n          object.resizeFilters = resizeFilters || [ ];\n          var instance = new fabric.Image(img, object);\n          callback && callback(instance);\n        });\n      });\n    }, null, object.crossOrigin);\n  };\n\n  /**\n   * Creates an instance of fabric.Image from an URL string\n   * @static\n   * @param {String} url URL to create an image from\n   * @param {Function} [callback] Callback to invoke when image is created (newly created image is passed as a first argument)\n   * @param {Object} [imgOptions] Options object\n   */\n  fabric.Image.fromURL = function(url, callback, imgOptions) {\n    fabric.util.loadImage(url, function(img) {\n      callback && callback(new fabric.Image(img, imgOptions));\n    }, null, imgOptions && imgOptions.crossOrigin);\n  };\n\n  /* _FROM_SVG_START_ */\n  /**\n   * List of attribute names to account for when parsing SVG element (used by {@link fabric.Image.fromElement})\n   * @static\n   * @see {@link http://www.w3.org/TR/SVG/struct.html#ImageElement}\n   */\n  fabric.Image.ATTRIBUTE_NAMES =\n    fabric.SHARED_ATTRIBUTES.concat('x y width height preserveAspectRatio xlink:href'.split(' '));\n\n  /**\n   * Returns {@link fabric.Image} instance from an SVG element\n   * @static\n   * @param {SVGElement} element Element to parse\n   * @param {Function} callback Callback to execute when fabric.Image object is created\n   * @param {Object} [options] Options object\n   * @return {fabric.Image} Instance of fabric.Image\n   */\n  fabric.Image.fromElement = function(element, callback, options) {\n    var parsedAttributes = fabric.parseAttributes(element, fabric.Image.ATTRIBUTE_NAMES),\n        preserveAR;\n\n    if (parsedAttributes.preserveAspectRatio) {\n      preserveAR = fabric.util.parsePreserveAspectRatioAttribute(parsedAttributes.preserveAspectRatio);\n      extend(parsedAttributes, preserveAR);\n    }\n\n    fabric.Image.fromURL(parsedAttributes['xlink:href'], callback,\n      extend((options ? fabric.util.object.clone(options) : { }), parsedAttributes));\n  };\n  /* _FROM_SVG_END_ */\n\n  /**\n   * Indicates that instances of this type are async\n   * @static\n   * @type Boolean\n   * @default\n   */\n  fabric.Image.async = true;\n\n  /**\n   * Indicates compression level used when generating PNG under Node (in applyFilters). Any of 0-9\n   * @static\n   * @type Number\n   * @default\n   */\n  fabric.Image.pngCompression = 1;\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\nfabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {\n\n  /**\n   * @private\n   * @return {Number} angle value\n   */\n  _getAngleValueForStraighten: function() {\n    var angle = this.getAngle() % 360;\n    if (angle > 0) {\n      return Math.round((angle - 1) / 90) * 90;\n    }\n    return Math.round(angle / 90) * 90;\n  },\n\n  /**\n   * Straightens an object (rotating it from current angle to one of 0, 90, 180, 270, etc. depending on which is closer)\n   * @return {fabric.Object} thisArg\n   * @chainable\n   */\n  straighten: function() {\n    this.setAngle(this._getAngleValueForStraighten());\n    return this;\n  },\n\n  /**\n   * Same as {@link fabric.Object.prototype.straighten} but with animation\n   * @param {Object} callbacks Object with callback functions\n   * @param {Function} [callbacks.onComplete] Invoked on completion\n   * @param {Function} [callbacks.onChange] Invoked on every step of animation\n   * @return {fabric.Object} thisArg\n   * @chainable\n   */\n  fxStraighten: function(callbacks) {\n    callbacks = callbacks || { };\n\n    var empty = function() { },\n        onComplete = callbacks.onComplete || empty,\n        onChange = callbacks.onChange || empty,\n        _this = this;\n\n    fabric.util.animate({\n      startValue: this.get('angle'),\n      endValue: this._getAngleValueForStraighten(),\n      duration: this.FX_DURATION,\n      onChange: function(value) {\n        _this.setAngle(value);\n        onChange();\n      },\n      onComplete: function() {\n        _this.setCoords();\n        onComplete();\n      },\n      onStart: function() {\n        _this.set('active', false);\n      }\n    });\n\n    return this;\n  }\n});\n\nfabric.util.object.extend(fabric.StaticCanvas.prototype, /** @lends fabric.StaticCanvas.prototype */ {\n\n  /**\n   * Straightens object, then rerenders canvas\n   * @param {fabric.Object} object Object to straighten\n   * @return {fabric.Canvas} thisArg\n   * @chainable\n   */\n  straightenObject: function (object) {\n    object.straighten();\n    this.renderAll();\n    return this;\n  },\n\n  /**\n   * Same as {@link fabric.Canvas.prototype.straightenObject}, but animated\n   * @param {fabric.Object} object Object to straighten\n   * @return {fabric.Canvas} thisArg\n   * @chainable\n   */\n  fxStraightenObject: function (object) {\n    object.fxStraighten({\n      onChange: this.renderAll.bind(this)\n    });\n    return this;\n  }\n});\n\n\n/**\n * @namespace fabric.Image.filters\n * @memberOf fabric.Image\n * @tutorial {@link http://fabricjs.com/fabric-intro-part-2#image_filters}\n * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n */\nfabric.Image.filters = fabric.Image.filters || { };\n\n/**\n * Root filter class from which all filter classes inherit from\n * @class fabric.Image.filters.BaseFilter\n * @memberOf fabric.Image.filters\n */\nfabric.Image.filters.BaseFilter = fabric.util.createClass(/** @lends fabric.Image.filters.BaseFilter.prototype */ {\n\n  /**\n   * Filter type\n   * @param {String} type\n   * @default\n   */\n  type: 'BaseFilter',\n\n  /**\n   * Constructor\n   * @param {Object} [options] Options object\n   */\n  initialize: function(options) {\n    if (options) {\n      this.setOptions(options);\n    }\n  },\n\n  /**\n   * Sets filter's properties from options\n   * @param {Object} [options] Options object\n   */\n  setOptions: function(options) {\n    for (var prop in options) {\n      this[prop] = options[prop];\n    }\n  },\n\n  /**\n   * Returns object representation of an instance\n   * @return {Object} Object representation of an instance\n   */\n  toObject: function() {\n    return { type: this.type };\n  },\n\n  /**\n   * Returns a JSON representation of an instance\n   * @return {Object} JSON\n   */\n  toJSON: function() {\n    // delegate, not alias\n    return this.toObject();\n  }\n});\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend;\n\n  /**\n   * Brightness filter class\n   * @class fabric.Image.filters.Brightness\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link fabric.Image.filters.Brightness#initialize} for constructor definition\n   * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n   * @example\n   * var filter = new fabric.Image.filters.Brightness({\n   *   brightness: 200\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.Brightness = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Brightness.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'Brightness',\n\n    /**\n     * Constructor\n     * @memberOf fabric.Image.filters.Brightness.prototype\n     * @param {Object} [options] Options object\n     * @param {Number} [options.brightness=0] Value to brighten the image up (0..255)\n     */\n    initialize: function(options) {\n      options = options || { };\n      this.brightness = options.brightness || 0;\n    },\n\n    /**\n     * Applies filter to canvas element\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          brightness = this.brightness;\n\n      for (var i = 0, len = data.length; i < len; i += 4) {\n        data[i] += brightness;\n        data[i + 1] += brightness;\n        data[i + 2] += brightness;\n      }\n\n      context.putImageData(imageData, 0, 0);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function() {\n      return extend(this.callSuper('toObject'), {\n        brightness: this.brightness\n      });\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Image.filters.Brightness} Instance of fabric.Image.filters.Brightness\n   */\n  fabric.Image.filters.Brightness.fromObject = function(object) {\n    return new fabric.Image.filters.Brightness(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend;\n\n  /**\n   * Adapted from <a href=\"http://www.html5rocks.com/en/tutorials/canvas/imagefilters/\">html5rocks article</a>\n   * @class fabric.Image.filters.Convolute\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link fabric.Image.filters.Convolute#initialize} for constructor definition\n   * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n   * @example <caption>Sharpen filter</caption>\n   * var filter = new fabric.Image.filters.Convolute({\n   *   matrix: [ 0, -1,  0,\n   *            -1,  5, -1,\n   *             0, -1,  0 ]\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   * @example <caption>Blur filter</caption>\n   * var filter = new fabric.Image.filters.Convolute({\n   *   matrix: [ 1/9, 1/9, 1/9,\n   *             1/9, 1/9, 1/9,\n   *             1/9, 1/9, 1/9 ]\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   * @example <caption>Emboss filter</caption>\n   * var filter = new fabric.Image.filters.Convolute({\n   *   matrix: [ 1,   1,  1,\n   *             1, 0.7, -1,\n   *            -1,  -1, -1 ]\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   * @example <caption>Emboss filter with opaqueness</caption>\n   * var filter = new fabric.Image.filters.Convolute({\n   *   opaque: true,\n   *   matrix: [ 1,   1,  1,\n   *             1, 0.7, -1,\n   *            -1,  -1, -1 ]\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.Convolute = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Convolute.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'Convolute',\n\n    /**\n     * Constructor\n     * @memberOf fabric.Image.filters.Convolute.prototype\n     * @param {Object} [options] Options object\n     * @param {Boolean} [options.opaque=false] Opaque value (true/false)\n     * @param {Array} [options.matrix] Filter matrix\n     */\n    initialize: function(options) {\n      options = options || { };\n\n      this.opaque = options.opaque;\n      this.matrix = options.matrix || [\n        0, 0, 0,\n        0, 1, 0,\n        0, 0, 0\n      ];\n    },\n\n    /**\n     * Applies filter to canvas element\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n\n      var weights = this.matrix,\n          context = canvasEl.getContext('2d'),\n          pixels = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n\n          side = Math.round(Math.sqrt(weights.length)),\n          halfSide = Math.floor(side/2),\n          src = pixels.data,\n          sw = pixels.width,\n          sh = pixels.height,\n          output = context.createImageData(sw, sh),\n          dst = output.data,\n          // go through the destination image pixels\n          alphaFac = this.opaque ? 1 : 0,\n          r, g, b, a, dstOff,\n          scx, scy, srcOff, wt;\n\n      for (var y = 0; y < sh; y++) {\n        for (var x = 0; x < sw; x++) {\n          dstOff = (y * sw + x) * 4;\n          // calculate the weighed sum of the source image pixels that\n          // fall under the convolution matrix\n          r = 0; g = 0; b = 0; a = 0;\n\n          for (var cy = 0; cy < side; cy++) {\n            for (var cx = 0; cx < side; cx++) {\n              scy = y + cy - halfSide;\n              scx = x + cx - halfSide;\n\n              /* jshint maxdepth:5 */\n              if (scy < 0 || scy > sh || scx < 0 || scx > sw) {\n                continue;\n              }\n\n              srcOff = (scy * sw + scx) * 4;\n              wt = weights[cy * side + cx];\n\n              r += src[srcOff] * wt;\n              g += src[srcOff + 1] * wt;\n              b += src[srcOff + 2] * wt;\n              a += src[srcOff + 3] * wt;\n            }\n          }\n          dst[dstOff] = r;\n          dst[dstOff + 1] = g;\n          dst[dstOff + 2] = b;\n          dst[dstOff + 3] = a + alphaFac * (255 - a);\n        }\n      }\n\n      context.putImageData(output, 0, 0);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function() {\n      return extend(this.callSuper('toObject'), {\n        opaque: this.opaque,\n        matrix: this.matrix\n      });\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Image.filters.Convolute} Instance of fabric.Image.filters.Convolute\n   */\n  fabric.Image.filters.Convolute.fromObject = function(object) {\n    return new fabric.Image.filters.Convolute(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend;\n\n  /**\n   * GradientTransparency filter class\n   * @class fabric.Image.filters.GradientTransparency\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link fabric.Image.filters.GradientTransparency#initialize} for constructor definition\n   * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n   * @example\n   * var filter = new fabric.Image.filters.GradientTransparency({\n   *   threshold: 200\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.GradientTransparency = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.GradientTransparency.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'GradientTransparency',\n\n    /**\n     * Constructor\n     * @memberOf fabric.Image.filters.GradientTransparency.prototype\n     * @param {Object} [options] Options object\n     * @param {Number} [options.threshold=100] Threshold value\n     */\n    initialize: function(options) {\n      options = options || { };\n      this.threshold = options.threshold || 100;\n    },\n\n    /**\n     * Applies filter to canvas element\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          threshold = this.threshold,\n          total = data.length;\n\n      for (var i = 0, len = data.length; i < len; i += 4) {\n        data[i + 3] = threshold + 255 * (total - i) / total;\n      }\n\n      context.putImageData(imageData, 0, 0);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function() {\n      return extend(this.callSuper('toObject'), {\n        threshold: this.threshold\n      });\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Image.filters.GradientTransparency} Instance of fabric.Image.filters.GradientTransparency\n   */\n  fabric.Image.filters.GradientTransparency.fromObject = function(object) {\n    return new fabric.Image.filters.GradientTransparency(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { });\n\n  /**\n   * Grayscale image filter class\n   * @class fabric.Image.filters.Grayscale\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n   * @example\n   * var filter = new fabric.Image.filters.Grayscale();\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.Grayscale = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Grayscale.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'Grayscale',\n\n    /**\n     * Applies filter to canvas element\n     * @memberOf fabric.Image.filters.Grayscale.prototype\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          len = imageData.width * imageData.height * 4,\n          index = 0,\n          average;\n\n      while (index < len) {\n        average = (data[index] + data[index + 1] + data[index + 2]) / 3;\n        data[index]     = average;\n        data[index + 1] = average;\n        data[index + 2] = average;\n        index += 4;\n      }\n\n      context.putImageData(imageData, 0, 0);\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @return {fabric.Image.filters.Grayscale} Instance of fabric.Image.filters.Grayscale\n   */\n  fabric.Image.filters.Grayscale.fromObject = function() {\n    return new fabric.Image.filters.Grayscale();\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { });\n\n  /**\n   * Invert filter class\n   * @class fabric.Image.filters.Invert\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n   * @example\n   * var filter = new fabric.Image.filters.Invert();\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.Invert = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Invert.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'Invert',\n\n    /**\n     * Applies filter to canvas element\n     * @memberOf fabric.Image.filters.Invert.prototype\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          iLen = data.length, i;\n\n      for (i = 0; i < iLen; i+=4) {\n        data[i] = 255 - data[i];\n        data[i + 1] = 255 - data[i + 1];\n        data[i + 2] = 255 - data[i + 2];\n      }\n\n      context.putImageData(imageData, 0, 0);\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @return {fabric.Image.filters.Invert} Instance of fabric.Image.filters.Invert\n   */\n  fabric.Image.filters.Invert.fromObject = function() {\n    return new fabric.Image.filters.Invert();\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend;\n\n  /**\n   * Mask filter class\n   * See http://resources.aleph-1.com/mask/\n   * @class fabric.Image.filters.Mask\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link fabric.Image.filters.Mask#initialize} for constructor definition\n   */\n  fabric.Image.filters.Mask = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Mask.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'Mask',\n\n    /**\n     * Constructor\n     * @memberOf fabric.Image.filters.Mask.prototype\n     * @param {Object} [options] Options object\n     * @param {fabric.Image} [options.mask] Mask image object\n     * @param {Number} [options.channel=0] Rgb channel (0, 1, 2 or 3)\n     */\n    initialize: function(options) {\n      options = options || { };\n\n      this.mask = options.mask;\n      this.channel = [ 0, 1, 2, 3 ].indexOf(options.channel) > -1 ? options.channel : 0;\n    },\n\n    /**\n     * Applies filter to canvas element\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n      if (!this.mask) {\n        return;\n      }\n\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          maskEl = this.mask.getElement(),\n          maskCanvasEl = fabric.util.createCanvasElement(),\n          channel = this.channel,\n          i,\n          iLen = imageData.width * imageData.height * 4;\n\n      maskCanvasEl.width = canvasEl.width;\n      maskCanvasEl.height = canvasEl.height;\n\n      maskCanvasEl.getContext('2d').drawImage(maskEl, 0, 0, canvasEl.width, canvasEl.height);\n\n      var maskImageData = maskCanvasEl.getContext('2d').getImageData(0, 0, canvasEl.width, canvasEl.height),\n          maskData = maskImageData.data;\n\n      for (i = 0; i < iLen; i += 4) {\n        data[i + 3] = maskData[i + channel];\n      }\n\n      context.putImageData(imageData, 0, 0);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function() {\n      return extend(this.callSuper('toObject'), {\n        mask: this.mask.toObject(),\n        channel: this.channel\n      });\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @param {Object} object Object to create an instance from\n   * @param {Function} [callback] Callback to invoke when a mask filter instance is created\n   */\n  fabric.Image.filters.Mask.fromObject = function(object, callback) {\n    fabric.util.loadImage(object.mask.src, function(img) {\n      object.mask = new fabric.Image(img, object.mask);\n      callback && callback(new fabric.Image.filters.Mask(object));\n    });\n  };\n\n  /**\n   * Indicates that instances of this type are async\n   * @static\n   * @type Boolean\n   * @default\n   */\n  fabric.Image.filters.Mask.async = true;\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend;\n\n  /**\n   * Noise filter class\n   * @class fabric.Image.filters.Noise\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link fabric.Image.filters.Noise#initialize} for constructor definition\n   * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n   * @example\n   * var filter = new fabric.Image.filters.Noise({\n   *   noise: 700\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.Noise = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Noise.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'Noise',\n\n    /**\n     * Constructor\n     * @memberOf fabric.Image.filters.Noise.prototype\n     * @param {Object} [options] Options object\n     * @param {Number} [options.noise=0] Noise value\n     */\n    initialize: function(options) {\n      options = options || { };\n      this.noise = options.noise || 0;\n    },\n\n    /**\n     * Applies filter to canvas element\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          noise = this.noise, rand;\n\n      for (var i = 0, len = data.length; i < len; i += 4) {\n\n        rand = (0.5 - Math.random()) * noise;\n\n        data[i] += rand;\n        data[i + 1] += rand;\n        data[i + 2] += rand;\n      }\n\n      context.putImageData(imageData, 0, 0);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function() {\n      return extend(this.callSuper('toObject'), {\n        noise: this.noise\n      });\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Image.filters.Noise} Instance of fabric.Image.filters.Noise\n   */\n  fabric.Image.filters.Noise.fromObject = function(object) {\n    return new fabric.Image.filters.Noise(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend;\n\n  /**\n   * Pixelate filter class\n   * @class fabric.Image.filters.Pixelate\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link fabric.Image.filters.Pixelate#initialize} for constructor definition\n   * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n   * @example\n   * var filter = new fabric.Image.filters.Pixelate({\n   *   blocksize: 8\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.Pixelate = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Pixelate.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'Pixelate',\n\n    /**\n     * Constructor\n     * @memberOf fabric.Image.filters.Pixelate.prototype\n     * @param {Object} [options] Options object\n     * @param {Number} [options.blocksize=4] Blocksize for pixelate\n     */\n    initialize: function(options) {\n      options = options || { };\n      this.blocksize = options.blocksize || 4;\n    },\n\n    /**\n     * Applies filter to canvas element\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          iLen = imageData.height,\n          jLen = imageData.width,\n          index, i, j, r, g, b, a;\n\n      for (i = 0; i < iLen; i += this.blocksize) {\n        for (j = 0; j < jLen; j += this.blocksize) {\n\n          index = (i * 4) * jLen + (j * 4);\n\n          r = data[index];\n          g = data[index + 1];\n          b = data[index + 2];\n          a = data[index + 3];\n\n          /*\n           blocksize: 4\n\n           [1,x,x,x,1]\n           [x,x,x,x,1]\n           [x,x,x,x,1]\n           [x,x,x,x,1]\n           [1,1,1,1,1]\n           */\n\n          for (var _i = i, _ilen = i + this.blocksize; _i < _ilen; _i++) {\n            for (var _j = j, _jlen = j + this.blocksize; _j < _jlen; _j++) {\n              index = (_i * 4) * jLen + (_j * 4);\n              data[index] = r;\n              data[index + 1] = g;\n              data[index + 2] = b;\n              data[index + 3] = a;\n            }\n          }\n        }\n      }\n\n      context.putImageData(imageData, 0, 0);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function() {\n      return extend(this.callSuper('toObject'), {\n        blocksize: this.blocksize\n      });\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Image.filters.Pixelate} Instance of fabric.Image.filters.Pixelate\n   */\n  fabric.Image.filters.Pixelate.fromObject = function(object) {\n    return new fabric.Image.filters.Pixelate(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend;\n\n  /**\n   * Remove white filter class\n   * @class fabric.Image.filters.RemoveWhite\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link fabric.Image.filters.RemoveWhite#initialize} for constructor definition\n   * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n   * @example\n   * var filter = new fabric.Image.filters.RemoveWhite({\n   *   threshold: 40,\n   *   distance: 140\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.RemoveWhite = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.RemoveWhite.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'RemoveWhite',\n\n    /**\n     * Constructor\n     * @memberOf fabric.Image.filters.RemoveWhite.prototype\n     * @param {Object} [options] Options object\n     * @param {Number} [options.threshold=30] Threshold value\n     * @param {Number} [options.distance=20] Distance value\n     */\n    initialize: function(options) {\n      options = options || { };\n      this.threshold = options.threshold || 30;\n      this.distance = options.distance || 20;\n    },\n\n    /**\n     * Applies filter to canvas element\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          threshold = this.threshold,\n          distance = this.distance,\n          limit = 255 - threshold,\n          abs = Math.abs,\n          r, g, b;\n\n      for (var i = 0, len = data.length; i < len; i += 4) {\n        r = data[i];\n        g = data[i + 1];\n        b = data[i + 2];\n\n        if (r > limit &&\n            g > limit &&\n            b > limit &&\n            abs(r - g) < distance &&\n            abs(r - b) < distance &&\n            abs(g - b) < distance\n        ) {\n          data[i + 3] = 0;\n        }\n      }\n\n      context.putImageData(imageData, 0, 0);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function() {\n      return extend(this.callSuper('toObject'), {\n        threshold: this.threshold,\n        distance: this.distance\n      });\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Image.filters.RemoveWhite} Instance of fabric.Image.filters.RemoveWhite\n   */\n  fabric.Image.filters.RemoveWhite.fromObject = function(object) {\n    return new fabric.Image.filters.RemoveWhite(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { });\n\n  /**\n   * Sepia filter class\n   * @class fabric.Image.filters.Sepia\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n   * @example\n   * var filter = new fabric.Image.filters.Sepia();\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.Sepia = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Sepia.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'Sepia',\n\n    /**\n     * Applies filter to canvas element\n     * @memberOf fabric.Image.filters.Sepia.prototype\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          iLen = data.length, i, avg;\n\n      for (i = 0; i < iLen; i+=4) {\n        avg = 0.3  * data[i] + 0.59 * data[i + 1] + 0.11 * data[i + 2];\n        data[i] = avg + 100;\n        data[i + 1] = avg + 50;\n        data[i + 2] = avg + 255;\n      }\n\n      context.putImageData(imageData, 0, 0);\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @return {fabric.Image.filters.Sepia} Instance of fabric.Image.filters.Sepia\n   */\n  fabric.Image.filters.Sepia.fromObject = function() {\n    return new fabric.Image.filters.Sepia();\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { });\n\n  /**\n   * Sepia2 filter class\n   * @class fabric.Image.filters.Sepia2\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n   * @example\n   * var filter = new fabric.Image.filters.Sepia2();\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.Sepia2 = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Sepia2.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'Sepia2',\n\n    /**\n     * Applies filter to canvas element\n     * @memberOf fabric.Image.filters.Sepia.prototype\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          iLen = data.length, i, r, g, b;\n\n      for (i = 0; i < iLen; i+=4) {\n        r = data[i];\n        g = data[i + 1];\n        b = data[i + 2];\n\n        data[i] = (r * 0.393 + g * 0.769 + b * 0.189 ) / 1.351;\n        data[i + 1] = (r * 0.349 + g * 0.686 + b * 0.168 ) / 1.203;\n        data[i + 2] = (r * 0.272 + g * 0.534 + b * 0.131 ) / 2.140;\n      }\n\n      context.putImageData(imageData, 0, 0);\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @return {fabric.Image.filters.Sepia2} Instance of fabric.Image.filters.Sepia2\n   */\n  fabric.Image.filters.Sepia2.fromObject = function() {\n    return new fabric.Image.filters.Sepia2();\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend;\n\n  /**\n   * Tint filter class\n   * Adapted from <a href=\"https://github.com/mezzoblue/PaintbrushJS\">https://github.com/mezzoblue/PaintbrushJS</a>\n   * @class fabric.Image.filters.Tint\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link fabric.Image.filters.Tint#initialize} for constructor definition\n   * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n   * @example <caption>Tint filter with hex color and opacity</caption>\n   * var filter = new fabric.Image.filters.Tint({\n   *   color: '#3513B0',\n   *   opacity: 0.5\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   * @example <caption>Tint filter with rgba color</caption>\n   * var filter = new fabric.Image.filters.Tint({\n   *   color: 'rgba(53, 21, 176, 0.5)'\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.Tint = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Tint.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'Tint',\n\n    /**\n     * Constructor\n     * @memberOf fabric.Image.filters.Tint.prototype\n     * @param {Object} [options] Options object\n     * @param {String} [options.color=#000000] Color to tint the image with\n     * @param {Number} [options.opacity] Opacity value that controls the tint effect's transparency (0..1)\n     */\n    initialize: function(options) {\n      options = options || { };\n\n      this.color = options.color || '#000000';\n      this.opacity = typeof options.opacity !== 'undefined'\n                      ? options.opacity\n                      : new fabric.Color(this.color).getAlpha();\n    },\n\n    /**\n     * Applies filter to canvas element\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          iLen = data.length, i,\n          tintR, tintG, tintB,\n          r, g, b, alpha1,\n          source;\n\n      source = new fabric.Color(this.color).getSource();\n\n      tintR = source[0] * this.opacity;\n      tintG = source[1] * this.opacity;\n      tintB = source[2] * this.opacity;\n\n      alpha1 = 1 - this.opacity;\n\n      for (i = 0; i < iLen; i+=4) {\n        r = data[i];\n        g = data[i + 1];\n        b = data[i + 2];\n\n        // alpha compositing\n        data[i] = tintR + r * alpha1;\n        data[i + 1] = tintG + g * alpha1;\n        data[i + 2] = tintB + b * alpha1;\n      }\n\n      context.putImageData(imageData, 0, 0);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function() {\n      return extend(this.callSuper('toObject'), {\n        color: this.color,\n        opacity: this.opacity\n      });\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Image.filters.Tint} Instance of fabric.Image.filters.Tint\n   */\n  fabric.Image.filters.Tint.fromObject = function(object) {\n    return new fabric.Image.filters.Tint(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend;\n\n  /**\n   * Multiply filter class\n   * Adapted from <a href=\"http://www.laurenscorijn.com/articles/colormath-basics\">http://www.laurenscorijn.com/articles/colormath-basics</a>\n   * @class fabric.Image.filters.Multiply\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @example <caption>Multiply filter with hex color</caption>\n   * var filter = new fabric.Image.filters.Multiply({\n   *   color: '#F0F'\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   * @example <caption>Multiply filter with rgb color</caption>\n   * var filter = new fabric.Image.filters.Multiply({\n   *   color: 'rgb(53, 21, 176)'\n   * });\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.Multiply = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Multiply.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'Multiply',\n\n    /**\n     * Constructor\n     * @memberOf fabric.Image.filters.Multiply.prototype\n     * @param {Object} [options] Options object\n     * @param {String} [options.color=#000000] Color to multiply the image pixels with\n     */\n    initialize: function(options) {\n      options = options || { };\n\n      this.color = options.color || '#000000';\n    },\n\n    /**\n     * Applies filter to canvas element\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl) {\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          iLen = data.length, i,\n          source;\n\n      source = new fabric.Color(this.color).getSource();\n\n      for (i = 0; i < iLen; i+=4) {\n        data[i] *= source[0] / 255;\n        data[i + 1] *= source[1] / 255;\n        data[i + 2] *= source[2] / 255;\n      }\n\n      context.putImageData(imageData, 0, 0);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function() {\n      return extend(this.callSuper('toObject'), {\n        color: this.color\n      });\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Image.filters.Multiply} Instance of fabric.Image.filters.Multiply\n   */\n  fabric.Image.filters.Multiply.fromObject = function(object) {\n    return new fabric.Image.filters.Multiply(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n  'use strict';\n\n  var fabric = global.fabric;\n\n  /**\n   * Color Blend filter class\n   * @class fabric.Image.filter.Blend\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @example\n   * var filter = new fabric.Image.filters.Blend({\n   *  color: '#000',\n   *  mode: 'multiply'\n   * });\n   *\n   * var filter = new fabric.Image.filters.Blend({\n   *  image: fabricImageObject,\n   *  mode: 'multiply',\n   *  alpha: 0.5\n   * });\n\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.Blend = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Blend.prototype */{\n    type: 'Blend',\n\n    initialize: function(options) {\n      options = options || {};\n      this.color = options.color || '#000';\n      this.image = options.image || false;\n      this.mode = options.mode || 'multiply';\n      this.alpha = options.alpha || 1;\n    },\n\n    applyTo: function(canvasEl) {\n      var context = canvasEl.getContext('2d'),\n          imageData = context.getImageData(0, 0, canvasEl.width, canvasEl.height),\n          data = imageData.data,\n          tr, tg, tb,\n          r, g, b,\n          _r, _g, _b,\n          source,\n          isImage = false;\n\n      if (this.image) {\n        // Blend images\n        isImage = true;\n\n        var _el = fabric.util.createCanvasElement();\n        _el.width = this.image.width;\n        _el.height = this.image.height;\n\n        var tmpCanvas = new fabric.StaticCanvas(_el);\n        tmpCanvas.add(this.image);\n        var context2 =  tmpCanvas.getContext('2d');\n        source = context2.getImageData(0, 0, tmpCanvas.width, tmpCanvas.height).data;\n      }\n      else {\n        // Blend color\n        source = new fabric.Color(this.color).getSource();\n\n        tr = source[0] * this.alpha;\n        tg = source[1] * this.alpha;\n        tb = source[2] * this.alpha;\n      }\n\n      for (var i = 0, len = data.length; i < len; i += 4) {\n\n        r = data[i];\n        g = data[i + 1];\n        b = data[i + 2];\n\n        if (isImage) {\n          tr = source[i] * this.alpha;\n          tg = source[i + 1] * this.alpha;\n          tb = source[i + 2] * this.alpha;\n        }\n\n        switch (this.mode) {\n          case 'multiply':\n            data[i] = r * tr / 255;\n            data[i + 1] = g * tg / 255;\n            data[i + 2] = b * tb / 255;\n            break;\n          case 'screen':\n            data[i] = 1 - (1 - r) * (1 - tr);\n            data[i + 1] = 1 - (1 - g) * (1 - tg);\n            data[i + 2] = 1 - (1 - b) * (1 - tb);\n            break;\n          case 'add':\n            data[i] = Math.min(255, r + tr);\n            data[i + 1] = Math.min(255, g + tg);\n            data[i + 2] = Math.min(255, b + tb);\n            break;\n          case 'diff':\n          case 'difference':\n            data[i] = Math.abs(r - tr);\n            data[i + 1] = Math.abs(g - tg);\n            data[i + 2] = Math.abs(b - tb);\n            break;\n          case 'subtract':\n            _r = r - tr;\n            _g = g - tg;\n            _b = b - tb;\n\n            data[i] = (_r < 0) ? 0 : _r;\n            data[i + 1] = (_g < 0) ? 0 : _g;\n            data[i + 2] = (_b < 0) ? 0 : _b;\n            break;\n          case 'darken':\n            data[i] = Math.min(r, tr);\n            data[i + 1] = Math.min(g, tg);\n            data[i + 2] = Math.min(b, tb);\n            break;\n          case 'lighten':\n            data[i] = Math.max(r, tr);\n            data[i + 1] = Math.max(g, tg);\n            data[i + 2] = Math.max(b, tb);\n            break;\n        }\n      }\n\n      context.putImageData(imageData, 0, 0);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function() {\n      return {\n        color: this.color,\n        image: this.image,\n        mode: this.mode,\n        alpha: this.alpha\n      };\n    }\n  });\n\n  fabric.Image.filters.Blend.fromObject = function(object) {\n    return new fabric.Image.filters.Blend(object);\n  };\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric  = global.fabric || (global.fabric = { }), pow = Math.pow, floor = Math.floor,\n      sqrt = Math.sqrt, abs = Math.abs, max = Math.max, round = Math.round, sin = Math.sin,\n      ceil = Math.ceil;\n\n  /**\n   * Resize image filter class\n   * @class fabric.Image.filters.Resize\n   * @memberOf fabric.Image.filters\n   * @extends fabric.Image.filters.BaseFilter\n   * @see {@link http://fabricjs.com/image-filters|ImageFilters demo}\n   * @example\n   * var filter = new fabric.Image.filters.Resize();\n   * object.filters.push(filter);\n   * object.applyFilters(canvas.renderAll.bind(canvas));\n   */\n  fabric.Image.filters.Resize = fabric.util.createClass(fabric.Image.filters.BaseFilter, /** @lends fabric.Image.filters.Resize.prototype */ {\n\n    /**\n     * Filter type\n     * @param {String} type\n     * @default\n     */\n    type: 'Resize',\n\n    /**\n     * Resize type\n     * @param {String} resizeType\n     * @default\n     */\n    resizeType: 'hermite',\n\n    /**\n     * Scale factor for resizing, x axis\n     * @param {Number} scaleX\n     * @default\n     */\n    scaleX: 0,\n\n    /**\n     * Scale factor for resizing, y axis\n     * @param {Number} scaleY\n     * @default\n     */\n    scaleY: 0,\n\n    /**\n     * LanczosLobes parameter for lanczos filter\n     * @param {Number} lanczosLobes\n     * @default\n     */\n    lanczosLobes: 3,\n\n    /**\n     * Applies filter to canvas element\n     * @memberOf fabric.Image.filters.Resize.prototype\n     * @param {Object} canvasEl Canvas element to apply filter to\n     */\n    applyTo: function(canvasEl, scaleX, scaleY) {\n\n      this.rcpScaleX = 1 / scaleX;\n      this.rcpScaleY = 1 / scaleY;\n\n      var oW = canvasEl.width, oH = canvasEl.height,\n          dW = round(oW * scaleX), dH = round(oH * scaleY),\n          imageData;\n\n      if (this.resizeType === 'sliceHack') {\n        imageData = this.sliceByTwo(canvasEl, oW, oH, dW, dH);\n      }\n      if (this.resizeType === 'hermite') {\n        imageData = this.hermiteFastResize(canvasEl, oW, oH, dW, dH);\n      }\n      if (this.resizeType === 'bilinear') {\n        imageData = this.bilinearFiltering(canvasEl, oW, oH, dW, dH);\n      }\n      if (this.resizeType === 'lanczos') {\n        imageData = this.lanczosResize(canvasEl, oW, oH, dW, dH);\n      }\n      canvasEl.width = dW;\n      canvasEl.height = dH;\n      canvasEl.getContext('2d').putImageData(imageData, 0, 0);\n    },\n\n    sliceByTwo: function(canvasEl, width, height, newWidth, newHeight) {\n      var context = canvasEl.getContext('2d'), imageData,\n          multW = 0.5, multH = 0.5, signW = 1, signH = 1,\n          doneW = false, doneH = false, stepW = width, stepH = height,\n          tmpCanvas = fabric.util.createCanvasElement(),\n          tmpCtx = tmpCanvas.getContext('2d');\n      newWidth = floor(newWidth);\n      newHeight = floor(newHeight);\n      tmpCanvas.width = max(newWidth, width);\n      tmpCanvas.height = max(newHeight, height);\n\n      if (newWidth > width) {\n        multW = 2;\n        signW = -1;\n      }\n      if (newHeight > height) {\n        multH = 2;\n        signH = -1;\n      }\n      imageData = context.getImageData(0, 0, width, height);\n      canvasEl.width = max(newWidth, width);\n      canvasEl.height = max(newHeight, height);\n      context.putImageData(imageData, 0, 0);\n\n      while (!doneW || !doneH) {\n        width = stepW;\n        height = stepH;\n        if (newWidth * signW < floor(stepW * multW * signW)) {\n          stepW = floor(stepW * multW);\n        }\n        else {\n          stepW = newWidth;\n          doneW = true;\n        }\n        if (newHeight * signH < floor(stepH * multH * signH)) {\n          stepH = floor(stepH * multH);\n        }\n        else {\n          stepH = newHeight;\n          doneH = true;\n        }\n        imageData = context.getImageData(0, 0, width, height);\n        tmpCtx.putImageData(imageData, 0, 0);\n        context.clearRect(0, 0, stepW, stepH);\n        context.drawImage(tmpCanvas, 0, 0, width, height, 0, 0, stepW, stepH);\n      }\n      return context.getImageData(0, 0, newWidth, newHeight);\n    },\n\n    lanczosResize: function(canvasEl, oW, oH, dW, dH) {\n\n      function lanczosCreate(lobes) {\n        return function(x) {\n          if (x > lobes) {\n            return 0;\n          }\n          x *= Math.PI;\n          if (abs(x) < 1e-16) {\n            return 1;\n          }\n          var xx = x / lobes;\n          return sin(x) * sin(xx) / x / xx;\n        };\n      }\n\n      function process(u) {\n        var v, i, weight, idx, a, red, green,\n            blue, alpha, fX, fY;\n        center.x = (u + 0.5) * ratioX;\n        icenter.x = floor(center.x);\n        for (v = 0; v < dH; v++) {\n          center.y = (v + 0.5) * ratioY;\n          icenter.y = floor(center.y);\n          a = 0, red = 0, green = 0, blue = 0, alpha = 0;\n          for (i = icenter.x - range2X; i <= icenter.x + range2X; i++) {\n            if (i < 0 || i >= oW) {\n              continue;\n            }\n            fX = floor(1000 * abs(i - center.x));\n            if (!cacheLanc[fX]) {\n              cacheLanc[fX] = { };\n            }\n            for (var j = icenter.y - range2Y; j <= icenter.y + range2Y; j++) {\n              if (j < 0 || j >= oH) {\n                continue;\n              }\n              fY = floor(1000 * abs(j - center.y));\n              if (!cacheLanc[fX][fY]) {\n                cacheLanc[fX][fY] = lanczos(sqrt(pow(fX * rcpRatioX, 2) + pow(fY * rcpRatioY, 2)) / 1000);\n              }\n              weight = cacheLanc[fX][fY];\n              if (weight > 0) {\n                idx = (j * oW + i) * 4;\n                a += weight;\n                red += weight * srcData[idx];\n                green += weight * srcData[idx + 1];\n                blue += weight * srcData[idx + 2];\n                alpha += weight * srcData[idx + 3];\n              }\n            }\n          }\n          idx = (v * dW + u) * 4;\n          destData[idx] = red / a;\n          destData[idx + 1] = green / a;\n          destData[idx + 2] = blue / a;\n          destData[idx + 3] = alpha / a;\n        }\n\n        if (++u < dW) {\n          return process(u);\n        }\n        else {\n          return destImg;\n        }\n      }\n\n      var context = canvasEl.getContext('2d'),\n          srcImg = context.getImageData(0, 0, oW, oH),\n          destImg = context.getImageData(0, 0, dW, dH),\n          srcData = srcImg.data, destData = destImg.data,\n          lanczos = lanczosCreate(this.lanczosLobes),\n          ratioX = this.rcpScaleX, ratioY = this.rcpScaleY,\n          rcpRatioX = 2 / this.rcpScaleX, rcpRatioY = 2 / this.rcpScaleY,\n          range2X = ceil(ratioX * this.lanczosLobes / 2),\n          range2Y = ceil(ratioY * this.lanczosLobes / 2),\n          cacheLanc = { }, center = { }, icenter = { };\n\n      return process(0);\n    },\n\n    bilinearFiltering: function(canvasEl, w, h, w2, h2) {\n      var a, b, c, d, x, y, i, j, xDiff, yDiff, chnl,\n          color, offset = 0, origPix, ratioX = this.rcpScaleX,\n          ratioY = this.rcpScaleY, context = canvasEl.getContext('2d'),\n          w4 = 4 * (w - 1), img = context.getImageData(0, 0, w, h),\n          pixels = img.data, destImage = context.getImageData(0, 0, w2, h2),\n          destPixels = destImage.data;\n      for (i = 0; i < h2; i++) {\n        for (j = 0; j < w2; j++) {\n          x = floor(ratioX * j);\n          y = floor(ratioY * i);\n          xDiff = ratioX * j - x;\n          yDiff = ratioY * i - y;\n          origPix = 4 * (y * w + x);\n\n          for (chnl = 0; chnl < 4; chnl++) {\n            a = pixels[origPix + chnl];\n            b = pixels[origPix + 4 + chnl];\n            c = pixels[origPix + w4 + chnl];\n            d = pixels[origPix + w4 + 4 + chnl];\n            color = a * (1 - xDiff) * (1 - yDiff) + b * xDiff * (1 - yDiff) +\n                    c * yDiff * (1 - xDiff) + d * xDiff * yDiff;\n            destPixels[offset++] = color;\n          }\n        }\n      }\n      return destImage;\n    },\n\n    hermiteFastResize: function(canvasEl, oW, oH, dW, dH) {\n      var ratioW = this.rcpScaleX, ratioH = this.rcpScaleY,\n          ratioWHalf = ceil(ratioW / 2),\n          ratioHHalf = ceil(ratioH / 2),\n          context = canvasEl.getContext('2d'),\n          img = context.getImageData(0, 0, oW, oH), data = img.data,\n          img2 = context.getImageData(0, 0, dW, dH), data2 = img2.data;\n      for (var j = 0; j < dH; j++) {\n        for (var i = 0; i < dW; i++) {\n          var x2 = (i + j * dW) * 4, weight = 0, weights = 0, weightsAlpha = 0,\n              gxR = 0, gxG = 0, gxB = 0, gxA = 0, centerY = (j + 0.5) * ratioH;\n          for (var yy = floor(j * ratioH); yy < (j + 1) * ratioH; yy++) {\n            var dy = abs(centerY - (yy + 0.5)) / ratioHHalf,\n                centerX = (i + 0.5) * ratioW, w0 = dy * dy;\n            for (var xx = floor(i * ratioW); xx < (i + 1) * ratioW; xx++) {\n              var dx = abs(centerX - (xx + 0.5)) / ratioWHalf,\n                  w = sqrt(w0 + dx * dx);\n              /*jshint maxdepth:5 */\n              if (w > 1 && w < -1) {\n                continue;\n              }\n              //hermite filter\n              weight = 2 * w * w * w - 3 * w * w + 1;\n              if (weight > 0) {\n                dx = 4 * (xx + yy * oW);\n                //alpha\n                gxA += weight * data[dx + 3];\n                weightsAlpha += weight;\n                //colors\n                /*jshint maxdepth:6 */\n                if (data[dx + 3] < 255) {\n                  weight = weight * data[dx + 3] / 250;\n                }\n                /*jshint maxdepth:5 */\n                gxR += weight * data[dx];\n                gxG += weight * data[dx + 1];\n                gxB += weight * data[dx + 2];\n                weights += weight;\n              }\n              /*jshint maxdepth:4 */\n            }\n          }\n          data2[x2] = gxR / weights;\n          data2[x2 + 1] = gxG / weights;\n          data2[x2 + 2] = gxB / weights;\n          data2[x2 + 3] = gxA / weightsAlpha;\n        }\n      }\n      return img2;\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function() {\n      return {\n        type: this.type,\n        scaleX: this.scaleX,\n        scaleY: this.scaleY,\n        resizeType: this.resizeType,\n        lanczosLobes: this.lanczosLobes\n      };\n    }\n  });\n\n  /**\n   * Returns filter instance from an object representation\n   * @static\n   * @return {fabric.Image.filters.Resize} Instance of fabric.Image.filters.Resize\n   */\n  fabric.Image.filters.Resize.fromObject = function(object) {\n    return new fabric.Image.filters.Resize(object);\n  };\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = { }),\n      extend = fabric.util.object.extend,\n      clone = fabric.util.object.clone,\n      toFixed = fabric.util.toFixed,\n      supportsLineDash = fabric.StaticCanvas.supports('setLineDash'),\n      NUM_FRACTION_DIGITS = fabric.Object.NUM_FRACTION_DIGITS;\n\n  if (fabric.Text) {\n    fabric.warn('fabric.Text is already defined');\n    return;\n  }\n\n  var stateProperties = fabric.Object.prototype.stateProperties.concat();\n  stateProperties.push(\n    'fontFamily',\n    'fontWeight',\n    'fontSize',\n    'text',\n    'textDecoration',\n    'textAlign',\n    'fontStyle',\n    'lineHeight',\n    'textBackgroundColor'\n  );\n\n  /**\n   * Text class\n   * @class fabric.Text\n   * @extends fabric.Object\n   * @return {fabric.Text} thisArg\n   * @tutorial {@link http://fabricjs.com/fabric-intro-part-2#text}\n   * @see {@link fabric.Text#initialize} for constructor definition\n   */\n  fabric.Text = fabric.util.createClass(fabric.Object, /** @lends fabric.Text.prototype */ {\n\n    /**\n     * Properties which when set cause object to change dimensions\n     * @type Object\n     * @private\n     */\n    _dimensionAffectingProps: {\n      fontSize: true,\n      fontWeight: true,\n      fontFamily: true,\n      fontStyle: true,\n      lineHeight: true,\n      stroke: true,\n      strokeWidth: true,\n      text: true,\n      textAlign: true\n    },\n\n    /**\n     * @private\n     */\n    _reNewline: /\\r?\\n/,\n\n    /**\n     * Use this regular expression to filter for whitespace that is not a new line.\n     * Mostly used when text is 'justify' aligned.\n     * @private\n     */\n    _reSpacesAndTabs: /[ \\t\\r]+/g,\n\n    /**\n     * Retrieves object's fontSize\n     * @method getFontSize\n     * @memberOf fabric.Text.prototype\n     * @return {String} Font size (in pixels)\n     */\n\n    /**\n     * Sets object's fontSize\n     * Does not update the object .width and .height,\n     * call ._initDimensions() to update the values.\n     * @method setFontSize\n     * @memberOf fabric.Text.prototype\n     * @param {Number} fontSize Font size (in pixels)\n     * @return {fabric.Text}\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's fontWeight\n     * @method getFontWeight\n     * @memberOf fabric.Text.prototype\n     * @return {(String|Number)} Font weight\n     */\n\n    /**\n     * Sets object's fontWeight\n     * Does not update the object .width and .height,\n     * call ._initDimensions() to update the values.\n     * @method setFontWeight\n     * @memberOf fabric.Text.prototype\n     * @param {(Number|String)} fontWeight Font weight\n     * @return {fabric.Text}\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's fontFamily\n     * @method getFontFamily\n     * @memberOf fabric.Text.prototype\n     * @return {String} Font family\n     */\n\n    /**\n     * Sets object's fontFamily\n     * Does not update the object .width and .height,\n     * call ._initDimensions() to update the values.\n     * @method setFontFamily\n     * @memberOf fabric.Text.prototype\n     * @param {String} fontFamily Font family\n     * @return {fabric.Text}\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's text\n     * @method getText\n     * @memberOf fabric.Text.prototype\n     * @return {String} text\n     */\n\n    /**\n     * Sets object's text\n     * Does not update the object .width and .height,\n     * call ._initDimensions() to update the values.\n     * @method setText\n     * @memberOf fabric.Text.prototype\n     * @param {String} text Text\n     * @return {fabric.Text}\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's textDecoration\n     * @method getTextDecoration\n     * @memberOf fabric.Text.prototype\n     * @return {String} Text decoration\n     */\n\n    /**\n     * Sets object's textDecoration\n     * @method setTextDecoration\n     * @memberOf fabric.Text.prototype\n     * @param {String} textDecoration Text decoration\n     * @return {fabric.Text}\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's fontStyle\n     * @method getFontStyle\n     * @memberOf fabric.Text.prototype\n     * @return {String} Font style\n     */\n\n    /**\n     * Sets object's fontStyle\n     * Does not update the object .width and .height,\n     * call ._initDimensions() to update the values.\n     * @method setFontStyle\n     * @memberOf fabric.Text.prototype\n     * @param {String} fontStyle Font style\n     * @return {fabric.Text}\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's lineHeight\n     * @method getLineHeight\n     * @memberOf fabric.Text.prototype\n     * @return {Number} Line height\n     */\n\n    /**\n     * Sets object's lineHeight\n     * @method setLineHeight\n     * @memberOf fabric.Text.prototype\n     * @param {Number} lineHeight Line height\n     * @return {fabric.Text}\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's textAlign\n     * @method getTextAlign\n     * @memberOf fabric.Text.prototype\n     * @return {String} Text alignment\n     */\n\n    /**\n     * Sets object's textAlign\n     * @method setTextAlign\n     * @memberOf fabric.Text.prototype\n     * @param {String} textAlign Text alignment\n     * @return {fabric.Text}\n     * @chainable\n     */\n\n    /**\n     * Retrieves object's textBackgroundColor\n     * @method getTextBackgroundColor\n     * @memberOf fabric.Text.prototype\n     * @return {String} Text background color\n     */\n\n    /**\n     * Sets object's textBackgroundColor\n     * @method setTextBackgroundColor\n     * @memberOf fabric.Text.prototype\n     * @param {String} textBackgroundColor Text background color\n     * @return {fabric.Text}\n     * @chainable\n     */\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type:                 'text',\n\n    /**\n     * Font size (in pixels)\n     * @type Number\n     * @default\n     */\n    fontSize:             40,\n\n    /**\n     * Font weight (e.g. bold, normal, 400, 600, 800)\n     * @type {(Number|String)}\n     * @default\n     */\n    fontWeight:           'normal',\n\n    /**\n     * Font family\n     * @type String\n     * @default\n     */\n    fontFamily:           'Times New Roman',\n\n    /**\n     * Text decoration Possible values: \"\", \"underline\", \"overline\" or \"line-through\".\n     * @type String\n     * @default\n     */\n    textDecoration:       '',\n\n    /**\n     * Text alignment. Possible values: \"left\", \"center\", \"right\" or \"justify\".\n     * @type String\n     * @default\n     */\n    textAlign:            'left',\n\n    /**\n     * Font style . Possible values: \"\", \"normal\", \"italic\" or \"oblique\".\n     * @type String\n     * @default\n     */\n    fontStyle:            '',\n\n    /**\n     * Line height\n     * @type Number\n     * @default\n     */\n    lineHeight:           1.16,\n\n    /**\n     * Background color of text lines\n     * @type String\n     * @default\n     */\n    textBackgroundColor:  '',\n\n    /**\n     * List of properties to consider when checking if\n     * state of an object is changed ({@link fabric.Object#hasStateChanged})\n     * as well as for history (undo/redo) purposes\n     * @type Array\n     */\n    stateProperties:      stateProperties,\n\n    /**\n     * When defined, an object is rendered via stroke and this property specifies its color.\n     * <b>Backwards incompatibility note:</b> This property was named \"strokeStyle\" until v1.1.6\n     * @type String\n     * @default\n     */\n    stroke:               null,\n\n    /**\n     * Shadow object representing shadow of this shape.\n     * <b>Backwards incompatibility note:</b> This property was named \"textShadow\" (String) until v1.2.11\n     * @type fabric.Shadow\n     * @default\n     */\n    shadow:               null,\n\n    /**\n     * @private\n     */\n    _fontSizeFraction: 0.25,\n\n    /**\n     * Text Line proportion to font Size (in pixels)\n     * @type Number\n     * @default\n     */\n    _fontSizeMult:             1.13,\n\n    /**\n     * Constructor\n     * @param {String} text Text string\n     * @param {Object} [options] Options object\n     * @return {fabric.Text} thisArg\n     */\n    initialize: function(text, options) {\n      options = options || { };\n      this.text = text;\n      this.__skipDimension = true;\n      this.setOptions(options);\n      this.__skipDimension = false;\n      this._initDimensions();\n    },\n\n    /**\n     * Initialize text dimensions. Render all text on given context\n     * or on a offscreen canvas to get the text width with measureText.\n     * Updates this.width and this.height with the proper values.\n     * Does not return dimensions.\n     * @param {CanvasRenderingContext2D} [ctx] Context to render on\n     * @private\n     */\n    _initDimensions: function(ctx) {\n      if (this.__skipDimension) {\n        return;\n      }\n      if (!ctx) {\n        ctx = fabric.util.createCanvasElement().getContext('2d');\n        this._setTextStyles(ctx);\n      }\n      this._textLines = this._splitTextIntoLines();\n      this._clearCache();\n      this.width = this._getTextWidth(ctx);\n      this.height = this._getTextHeight(ctx);\n    },\n\n    /**\n     * Returns string representation of an instance\n     * @return {String} String representation of text object\n     */\n    toString: function() {\n      return '#<fabric.Text (' + this.complexity() +\n        '): { \"text\": \"' + this.text + '\", \"fontFamily\": \"' + this.fontFamily + '\" }>';\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _render: function(ctx) {\n      this.clipTo && fabric.util.clipContext(this, ctx);\n      this._setOpacity(ctx);\n      this._setShadow(ctx);\n      this._setupCompositeOperation(ctx);\n      this._renderTextBackground(ctx);\n      this._setStrokeStyles(ctx);\n      this._setFillStyles(ctx);\n      this._renderText(ctx);\n      this._renderTextDecoration(ctx);\n      this.clipTo && ctx.restore();\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderText: function(ctx) {\n\n      this._translateForTextAlign(ctx);\n      this._renderTextFill(ctx);\n      this._renderTextStroke(ctx);\n      this._translateForTextAlign(ctx, true);\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Boolean} back Indicates if translate back or forward\n     */\n    _translateForTextAlign: function(ctx, back) {\n      if (this.textAlign !== 'left' && this.textAlign !== 'justify') {\n        var sign = back ? -1 : 1;\n        ctx.translate(this.textAlign === 'center' ? (sign * this.width / 2) : sign * this.width, 0);\n      }\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _setTextStyles: function(ctx) {\n      ctx.textBaseline = 'alphabetic';\n      if (!this.skipTextAlign) {\n        ctx.textAlign = this.textAlign;\n      }\n      ctx.font = this._getFontDeclaration();\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @return {Number} Height of fabric.Text object\n     */\n    _getTextHeight: function() {\n      return this._textLines.length * this._getHeightOfLine();\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @return {Number} Maximum width of fabric.Text object\n     */\n    _getTextWidth: function(ctx) {\n      var maxWidth = this._getLineWidth(ctx, 0);\n\n      for (var i = 1, len = this._textLines.length; i < len; i++) {\n        var currentLineWidth = this._getLineWidth(ctx, i);\n        if (currentLineWidth > maxWidth) {\n          maxWidth = currentLineWidth;\n        }\n      }\n      return maxWidth;\n    },\n\n    /**\n     * @private\n     * @param {String} method Method name (\"fillText\" or \"strokeText\")\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {String} chars Chars to render\n     * @param {Number} left Left position of text\n     * @param {Number} top Top position of text\n     */\n    _renderChars: function(method, ctx, chars, left, top) {\n      // remove Text word from method var\n      var shortM = method.slice(0, -4);\n      if (this[shortM].toLive) {\n        var offsetX = -this.width / 2 + this[shortM].offsetX || 0,\n            offsetY = -this.height / 2 + this[shortM].offsetY || 0;\n        ctx.save();\n        ctx.translate(offsetX, offsetY);\n        left -= offsetX;\n        top -= offsetY;\n      }\n      ctx[method](chars, left, top);\n      this[shortM].toLive && ctx.restore();\n    },\n\n    /**\n     * @private\n     * @param {String} method Method name (\"fillText\" or \"strokeText\")\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {String} line Text to render\n     * @param {Number} left Left position of text\n     * @param {Number} top Top position of text\n     * @param {Number} lineIndex Index of a line in a text\n     */\n    _renderTextLine: function(method, ctx, line, left, top, lineIndex) {\n      // lift the line by quarter of fontSize\n      top -= this.fontSize * this._fontSizeFraction;\n\n      // short-circuit\n      var lineWidth = this._getLineWidth(ctx, lineIndex);\n      if (this.textAlign !== 'justify' || this.width < lineWidth) {\n        this._renderChars(method, ctx, line, left, top, lineIndex);\n        return;\n      }\n\n      // stretch the line\n      var words = line.split(/\\s+/),\n          charOffset = 0,\n          wordsWidth = this._getWidthOfWords(ctx, line, lineIndex, 0),\n          widthDiff = this.width - wordsWidth,\n          numSpaces = words.length - 1,\n          spaceWidth = numSpaces > 0 ? widthDiff / numSpaces : 0,\n          leftOffset = 0, word;\n\n      for (var i = 0, len = words.length; i < len; i++) {\n        while (line[charOffset] === ' ' && charOffset < line.length) {\n          charOffset++;\n        }\n        word = words[i];\n        this._renderChars(method, ctx, word, left + leftOffset, top, lineIndex, charOffset);\n        leftOffset += this._getWidthOfWords(ctx, word, lineIndex, charOffset) + spaceWidth;\n        charOffset += word.length;\n      }\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Number} line\n     */\n    _getWidthOfWords: function (ctx, line) {\n      return ctx.measureText(line.replace(/\\s+/g, '')).width;\n    },\n\n    /**\n     * @private\n     * @return {Number} Left offset\n     */\n    _getLeftOffset: function() {\n      return -this.width / 2;\n    },\n\n    /**\n     * @private\n     * @return {Number} Top offset\n     */\n    _getTopOffset: function() {\n      return -this.height / 2;\n    },\n\n    /**\n     * Returns true because text has no style\n     */\n    isEmptyStyles: function() {\n      return true;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderTextFill: function(ctx) {\n      if (!this.fill && this.isEmptyStyles()) {\n        return;\n      }\n\n      var lineHeights = 0;\n\n      for (var i = 0, len = this._textLines.length; i < len; i++) {\n        var heightOfLine = this._getHeightOfLine(ctx, i),\n            maxHeight = heightOfLine / this.lineHeight;\n\n        this._renderTextLine(\n          'fillText',\n          ctx,\n          this._textLines[i],\n          this._getLeftOffset(),\n          this._getTopOffset() + lineHeights + maxHeight,\n          i\n        );\n        lineHeights += heightOfLine;\n      }\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderTextStroke: function(ctx) {\n      if ((!this.stroke || this.strokeWidth === 0) && this.isEmptyStyles()) {\n        return;\n      }\n\n      var lineHeights = 0;\n\n      if (this.shadow && !this.shadow.affectStroke) {\n        this._removeShadow(ctx);\n      }\n\n      ctx.save();\n\n      if (this.strokeDashArray) {\n        // Spec requires the concatenation of two copies the dash list when the number of elements is odd\n        if (1 & this.strokeDashArray.length) {\n          this.strokeDashArray.push.apply(this.strokeDashArray, this.strokeDashArray);\n        }\n        supportsLineDash && ctx.setLineDash(this.strokeDashArray);\n      }\n\n      ctx.beginPath();\n      for (var i = 0, len = this._textLines.length; i < len; i++) {\n        var heightOfLine = this._getHeightOfLine(ctx, i),\n            maxHeight = heightOfLine / this.lineHeight;\n\n        this._renderTextLine(\n          'strokeText',\n          ctx,\n          this._textLines[i],\n          this._getLeftOffset(),\n          this._getTopOffset() + lineHeights + maxHeight,\n          i\n        );\n        lineHeights += heightOfLine;\n      }\n      ctx.closePath();\n      ctx.restore();\n    },\n\n    _getHeightOfLine: function() {\n      return this.fontSize * this._fontSizeMult * this.lineHeight;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Array} textLines Array of all text lines\n     */\n    _renderTextBackground: function(ctx) {\n      this._renderTextBoxBackground(ctx);\n      this._renderTextLinesBackground(ctx);\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderTextBoxBackground: function(ctx) {\n      if (!this.backgroundColor) {\n        return;\n      }\n\n      ctx.fillStyle = this.backgroundColor;\n\n      ctx.fillRect(\n        this._getLeftOffset(),\n        this._getTopOffset(),\n        this.width,\n        this.height\n      );\n      // if there is background color no other shadows\n      // should be casted\n      this._removeShadow(ctx);\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderTextLinesBackground: function(ctx) {\n      if (!this.textBackgroundColor) {\n        return;\n      }\n      var lineTopOffset = 0, heightOfLine,\n          lineWidth, lineLeftOffset;\n\n      ctx.fillStyle = this.textBackgroundColor;\n      for (var i = 0, len = this._textLines.length; i < len; i++) {\n        heightOfLine = this._getHeightOfLine(ctx, i);\n        lineWidth = this._getLineWidth(ctx, i);\n        if (lineWidth > 0) {\n          lineLeftOffset = this._getLineLeftOffset(lineWidth);\n          ctx.fillRect(\n            this._getLeftOffset() + lineLeftOffset,\n            this._getTopOffset() + lineTopOffset,\n            lineWidth,\n            heightOfLine / this.lineHeight\n          );\n        }\n        lineTopOffset += heightOfLine;\n      }\n      // if there is text background color no\n      // other shadows should be casted\n      this._removeShadow(ctx);\n    },\n\n    /**\n     * @private\n     * @param {Number} lineWidth Width of text line\n     * @return {Number} Line left offset\n     */\n    _getLineLeftOffset: function(lineWidth) {\n      if (this.textAlign === 'center') {\n        return (this.width - lineWidth) / 2;\n      }\n      if (this.textAlign === 'right') {\n        return this.width - lineWidth;\n      }\n      return 0;\n    },\n\n    /**\n     * @private\n     */\n    _clearCache: function() {\n      this.__lineWidths = [ ];\n      this.__lineHeights = [ ];\n    },\n\n    /**\n     * @private\n     */\n    _shouldClearCache: function() {\n      var shouldClear = false;\n      if (this._forceClearCache) {\n        this._forceClearCache = false;\n        return true;\n      }\n      for (var prop in this._dimensionAffectingProps) {\n        if (this['__' + prop] !== this[prop]) {\n          this['__' + prop] = this[prop];\n          shouldClear = true;\n        }\n      }\n      return shouldClear;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Number} lineIndex line number\n     * @return {Number} Line width\n     */\n    _getLineWidth: function(ctx, lineIndex) {\n      if (this.__lineWidths[lineIndex]) {\n        return this.__lineWidths[lineIndex] === -1 ? this.width : this.__lineWidths[lineIndex];\n      }\n\n      var width, wordCount, line = this._textLines[lineIndex];\n\n      if (line === '') {\n        width = 0;\n      }\n      else {\n        width = this._measureLine(ctx, lineIndex);\n      }\n      this.__lineWidths[lineIndex] = width;\n\n      if (width && this.textAlign === 'justify') {\n        wordCount = line.split(/\\s+/);\n        if (wordCount.length > 1) {\n          this.__lineWidths[lineIndex] = -1;\n        }\n      }\n      return width;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Number} lineIndex line number\n     * @return {Number} Line width\n     */\n    _measureLine: function(ctx, lineIndex) {\n      return ctx.measureText(this._textLines[lineIndex]).width;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderTextDecoration: function(ctx) {\n      if (!this.textDecoration) {\n        return;\n      }\n\n      var halfOfVerticalBox = this.height / 2,\n          _this = this, offsets = [];\n\n      /** @ignore */\n      function renderLinesAtOffset(offsets) {\n        var i, lineHeight = 0, len, j, oLen, lineWidth,\n            lineLeftOffset, heightOfLine;\n\n        for (i = 0, len = _this._textLines.length; i < len; i++) {\n\n          lineWidth = _this._getLineWidth(ctx, i),\n          lineLeftOffset = _this._getLineLeftOffset(lineWidth),\n          heightOfLine = _this._getHeightOfLine(ctx, i);\n\n          for (j = 0, oLen = offsets.length; j < oLen; j++) {\n            ctx.fillRect(\n              _this._getLeftOffset() + lineLeftOffset,\n              lineHeight + (_this._fontSizeMult - 1 + offsets[j] ) * _this.fontSize - halfOfVerticalBox,\n              lineWidth,\n              _this.fontSize / 15);\n          }\n          lineHeight += heightOfLine;\n        }\n      }\n\n      if (this.textDecoration.indexOf('underline') > -1) {\n        offsets.push(0.85); // 1 - 3/16\n      }\n      if (this.textDecoration.indexOf('line-through') > -1) {\n        offsets.push(0.43);\n      }\n      if (this.textDecoration.indexOf('overline') > -1) {\n        offsets.push(-0.12);\n      }\n      if (offsets.length > 0) {\n        renderLinesAtOffset(offsets);\n      }\n    },\n\n    /**\n     * @private\n     */\n    _getFontDeclaration: function() {\n      return [\n        // node-canvas needs \"weight style\", while browsers need \"style weight\"\n        (fabric.isLikelyNode ? this.fontWeight : this.fontStyle),\n        (fabric.isLikelyNode ? this.fontStyle : this.fontWeight),\n        this.fontSize + 'px',\n        (fabric.isLikelyNode ? ('\"' + this.fontFamily + '\"') : this.fontFamily)\n      ].join(' ');\n    },\n\n    /**\n     * Renders text instance on a specified context\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    render: function(ctx, noTransform) {\n      // do not render if object is not visible\n      if (!this.visible) {\n        return;\n      }\n\n      ctx.save();\n      this._setTextStyles(ctx);\n\n      if (this._shouldClearCache()) {\n        this._initDimensions(ctx);\n      }\n      this.drawSelectionBackground(ctx);\n      if (!noTransform) {\n        this.transform(ctx);\n      }\n      if (this.transformMatrix) {\n        ctx.transform.apply(ctx, this.transformMatrix);\n      }\n      if (this.group && this.group.type === 'path-group') {\n        ctx.translate(this.left, this.top);\n      }\n      this._render(ctx);\n      ctx.restore();\n    },\n\n    /**\n     * Returns the text as an array of lines.\n     * @returns {Array} Lines in the text\n     */\n    _splitTextIntoLines: function() {\n      return this.text.split(this._reNewline);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} Object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      var object = extend(this.callSuper('toObject', propertiesToInclude), {\n        text:                 this.text,\n        fontSize:             this.fontSize,\n        fontWeight:           this.fontWeight,\n        fontFamily:           this.fontFamily,\n        fontStyle:            this.fontStyle,\n        lineHeight:           this.lineHeight,\n        textDecoration:       this.textDecoration,\n        textAlign:            this.textAlign,\n        textBackgroundColor:  this.textBackgroundColor\n      });\n      if (!this.includeDefaultValues) {\n        this._removeDefaultValues(object);\n      }\n      return object;\n    },\n\n    /* _TO_SVG_START_ */\n    /**\n     * Returns SVG representation of an instance\n     * @param {Function} [reviver] Method for further parsing of svg representation.\n     * @return {String} svg representation of an instance\n     */\n    toSVG: function(reviver) {\n      var markup = this._createBaseSVGMarkup(),\n          offsets = this._getSVGLeftTopOffsets(this.ctx),\n          textAndBg = this._getSVGTextAndBg(offsets.textTop, offsets.textLeft);\n      this._wrapSVGTextAndBg(markup, textAndBg);\n\n      return reviver ? reviver(markup.join('')) : markup.join('');\n    },\n\n    /**\n     * @private\n     */\n    _getSVGLeftTopOffsets: function(ctx) {\n      var lineTop = this._getHeightOfLine(ctx, 0),\n          textLeft = -this.width / 2,\n          textTop = 0;\n\n      return {\n        textLeft: textLeft + (this.group && this.group.type === 'path-group' ? this.left : 0),\n        textTop: textTop + (this.group && this.group.type === 'path-group' ? -this.top : 0),\n        lineTop: lineTop\n      };\n    },\n\n    /**\n     * @private\n     */\n    _wrapSVGTextAndBg: function(markup, textAndBg) {\n      var noShadow = true, filter = this.getSvgFilter(),\n          style = filter === '' ? '' : ' style=\"' + filter + '\"';\n\n      markup.push(\n        '\\t<g transform=\"', this.getSvgTransform(), this.getSvgTransformMatrix(), '\"',\n          style, '>\\n',\n          textAndBg.textBgRects.join(''),\n          '\\t\\t<text ',\n            (this.fontFamily ? 'font-family=\"' + this.fontFamily.replace(/\"/g, '\\'') + '\" ': ''),\n            (this.fontSize ? 'font-size=\"' + this.fontSize + '\" ': ''),\n            (this.fontStyle ? 'font-style=\"' + this.fontStyle + '\" ': ''),\n            (this.fontWeight ? 'font-weight=\"' + this.fontWeight + '\" ': ''),\n            (this.textDecoration ? 'text-decoration=\"' + this.textDecoration + '\" ': ''),\n            'style=\"', this.getSvgStyles(noShadow), '\" >\\n',\n            textAndBg.textSpans.join(''),\n          '\\t\\t</text>\\n',\n        '\\t</g>\\n'\n      );\n    },\n\n    /**\n     * @private\n     * @param {Number} textTopOffset Text top offset\n     * @param {Number} textLeftOffset Text left offset\n     * @return {Object}\n     */\n    _getSVGTextAndBg: function(textTopOffset, textLeftOffset) {\n      var textSpans = [ ],\n          textBgRects = [ ],\n          height = 0;\n      // bounding-box background\n      this._setSVGBg(textBgRects);\n\n      // text and text-background\n      for (var i = 0, len = this._textLines.length; i < len; i++) {\n        if (this.textBackgroundColor) {\n          this._setSVGTextLineBg(textBgRects, i, textLeftOffset, textTopOffset, height);\n        }\n        this._setSVGTextLineText(i, textSpans, height, textLeftOffset, textTopOffset, textBgRects);\n        height += this._getHeightOfLine(this.ctx, i);\n      }\n\n      return {\n        textSpans: textSpans,\n        textBgRects: textBgRects\n      };\n    },\n\n    _setSVGTextLineText: function(i, textSpans, height, textLeftOffset, textTopOffset) {\n      var yPos = this.fontSize * (this._fontSizeMult - this._fontSizeFraction)\n        - textTopOffset + height - this.height / 2;\n      if (this.textAlign === 'justify') {\n        // i call from here to do not intefere with IText\n        this._setSVGTextLineJustifed(i, textSpans, yPos, textLeftOffset);\n        return;\n      }\n      textSpans.push(\n        '\\t\\t\\t<tspan x=\"',\n          toFixed(textLeftOffset + this._getLineLeftOffset(this._getLineWidth(this.ctx, i)), NUM_FRACTION_DIGITS), '\" ',\n          'y=\"',\n          toFixed(yPos, NUM_FRACTION_DIGITS),\n          '\" ',\n          // doing this on <tspan> elements since setting opacity\n          // on containing <text> one doesn't work in Illustrator\n          this._getFillAttributes(this.fill), '>',\n          fabric.util.string.escapeXml(this._textLines[i]),\n        '</tspan>\\n'\n      );\n    },\n\n    _setSVGTextLineJustifed: function(i, textSpans, yPos, textLeftOffset) {\n      var ctx = fabric.util.createCanvasElement().getContext('2d');\n\n      this._setTextStyles(ctx);\n\n      var line = this._textLines[i],\n          words = line.split(/\\s+/),\n          wordsWidth = this._getWidthOfWords(ctx, line),\n          widthDiff = this.width - wordsWidth,\n          numSpaces = words.length - 1,\n          spaceWidth = numSpaces > 0 ? widthDiff / numSpaces : 0,\n          word, attributes = this._getFillAttributes(this.fill),\n          len;\n\n      textLeftOffset += this._getLineLeftOffset(this._getLineWidth(ctx, i));\n\n      for (i = 0, len = words.length; i < len; i++) {\n        word = words[i];\n        textSpans.push(\n          '\\t\\t\\t<tspan x=\"',\n            toFixed(textLeftOffset, NUM_FRACTION_DIGITS), '\" ',\n            'y=\"',\n            toFixed(yPos, NUM_FRACTION_DIGITS),\n            '\" ',\n            // doing this on <tspan> elements since setting opacity\n            // on containing <text> one doesn't work in Illustrator\n            attributes, '>',\n            fabric.util.string.escapeXml(word),\n          '</tspan>\\n'\n        );\n        textLeftOffset += this._getWidthOfWords(ctx, word) + spaceWidth;\n      }\n    },\n\n    _setSVGTextLineBg: function(textBgRects, i, textLeftOffset, textTopOffset, height) {\n      textBgRects.push(\n        '\\t\\t<rect ',\n          this._getFillAttributes(this.textBackgroundColor),\n          ' x=\"',\n          toFixed(textLeftOffset + this._getLineLeftOffset(this._getLineWidth(this.ctx, i)), NUM_FRACTION_DIGITS),\n          '\" y=\"',\n          toFixed(height - this.height / 2, NUM_FRACTION_DIGITS),\n          '\" width=\"',\n          toFixed(this._getLineWidth(this.ctx, i), NUM_FRACTION_DIGITS),\n          '\" height=\"',\n          toFixed(this._getHeightOfLine(this.ctx, i) / this.lineHeight, NUM_FRACTION_DIGITS),\n        '\"></rect>\\n');\n    },\n\n    _setSVGBg: function(textBgRects) {\n      if (this.backgroundColor) {\n        textBgRects.push(\n          '\\t\\t<rect ',\n            this._getFillAttributes(this.backgroundColor),\n            ' x=\"',\n            toFixed(-this.width / 2, NUM_FRACTION_DIGITS),\n            '\" y=\"',\n            toFixed(-this.height / 2, NUM_FRACTION_DIGITS),\n            '\" width=\"',\n            toFixed(this.width, NUM_FRACTION_DIGITS),\n            '\" height=\"',\n            toFixed(this.height, NUM_FRACTION_DIGITS),\n          '\"></rect>\\n');\n      }\n    },\n\n    /**\n     * Adobe Illustrator (at least CS5) is unable to render rgba()-based fill values\n     * we work around it by \"moving\" alpha channel into opacity attribute and setting fill's alpha to 1\n     *\n     * @private\n     * @param {Any} value\n     * @return {String}\n     */\n    _getFillAttributes: function(value) {\n      var fillColor = (value && typeof value === 'string') ? new fabric.Color(value) : '';\n      if (!fillColor || !fillColor.getSource() || fillColor.getAlpha() === 1) {\n        return 'fill=\"' + value + '\"';\n      }\n      return 'opacity=\"' + fillColor.getAlpha() + '\" fill=\"' + fillColor.setAlpha(1).toRgb() + '\"';\n    },\n    /* _TO_SVG_END_ */\n\n    /**\n     * Sets specified property to a specified value\n     * @param {String} key\n     * @param {Any} value\n     * @return {fabric.Text} thisArg\n     * @chainable\n     */\n    _set: function(key, value) {\n      this.callSuper('_set', key, value);\n\n      if (key in this._dimensionAffectingProps) {\n        this._initDimensions();\n        this.setCoords();\n      }\n    },\n\n    /**\n     * Returns complexity of an instance\n     * @return {Number} complexity\n     */\n    complexity: function() {\n      return 1;\n    }\n  });\n\n  /* _FROM_SVG_START_ */\n  /**\n   * List of attribute names to account for when parsing SVG element (used by {@link fabric.Text.fromElement})\n   * @static\n   * @memberOf fabric.Text\n   * @see: http://www.w3.org/TR/SVG/text.html#TextElement\n   */\n  fabric.Text.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat(\n    'x y dx dy font-family font-style font-weight font-size text-decoration text-anchor'.split(' '));\n\n  /**\n   * Default SVG font size\n   * @static\n   * @memberOf fabric.Text\n   */\n  fabric.Text.DEFAULT_SVG_FONT_SIZE = 16;\n\n  /**\n   * Returns fabric.Text instance from an SVG element (<b>not yet implemented</b>)\n   * @static\n   * @memberOf fabric.Text\n   * @param {SVGElement} element Element to parse\n   * @param {Object} [options] Options object\n   * @return {fabric.Text} Instance of fabric.Text\n   */\n  fabric.Text.fromElement = function(element, options) {\n    if (!element) {\n      return null;\n    }\n\n    var parsedAttributes = fabric.parseAttributes(element, fabric.Text.ATTRIBUTE_NAMES);\n    options = fabric.util.object.extend((options ? fabric.util.object.clone(options) : { }), parsedAttributes);\n\n    options.top = options.top || 0;\n    options.left = options.left || 0;\n    if ('dx' in parsedAttributes) {\n      options.left += parsedAttributes.dx;\n    }\n    if ('dy' in parsedAttributes) {\n      options.top += parsedAttributes.dy;\n    }\n    if (!('fontSize' in options)) {\n      options.fontSize = fabric.Text.DEFAULT_SVG_FONT_SIZE;\n    }\n\n    if (!options.originX) {\n      options.originX = 'left';\n    }\n\n    var textContent = '';\n\n    // The XML is not properly parsed in IE9 so a workaround to get\n    // textContent is through firstChild.data. Another workaround would be\n    // to convert XML loaded from a file to be converted using DOMParser (same way loadSVGFromString() does)\n    if (!('textContent' in element)) {\n      if ('firstChild' in element && element.firstChild !== null) {\n        if ('data' in element.firstChild && element.firstChild.data !== null) {\n          textContent = element.firstChild.data;\n        }\n      }\n    }\n    else {\n      textContent = element.textContent;\n    }\n\n    textContent = textContent.replace(/^\\s+|\\s+$|\\n+/g, '').replace(/\\s+/g, ' ');\n\n    var text = new fabric.Text(textContent, options),\n        /*\n          Adjust positioning:\n            x/y attributes in SVG correspond to the bottom-left corner of text bounding box\n            top/left properties in Fabric correspond to center point of text bounding box\n        */\n        offX = 0;\n\n    if (text.originX === 'left') {\n      offX = text.getWidth() / 2;\n    }\n    if (text.originX === 'right') {\n      offX = -text.getWidth() / 2;\n    }\n    text.set({\n      left: text.getLeft() + offX,\n      top: text.getTop() - text.getHeight() / 2 + text.fontSize * (0.18 + text._fontSizeFraction) /* 0.3 is the old lineHeight */\n    });\n\n    return text;\n  };\n  /* _FROM_SVG_END_ */\n\n  /**\n   * Returns fabric.Text instance from an object representation\n   * @static\n   * @memberOf fabric.Text\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Text} Instance of fabric.Text\n   */\n  fabric.Text.fromObject = function(object) {\n    return new fabric.Text(object.text, clone(object));\n  };\n\n  fabric.util.createAccessors(fabric.Text);\n\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function() {\n\n  var clone = fabric.util.object.clone;\n\n  /**\n   * IText class (introduced in <b>v1.4</b>) Events are also fired with \"text:\"\n   * prefix when observing canvas.\n   * @class fabric.IText\n   * @extends fabric.Text\n   * @mixes fabric.Observable\n   *\n   * @fires changed\n   * @fires selection:changed\n   * @fires editing:entered\n   * @fires editing:exited\n   *\n   * @return {fabric.IText} thisArg\n   * @see {@link fabric.IText#initialize} for constructor definition\n   *\n   * <p>Supported key combinations:</p>\n   * <pre>\n   *   Move cursor:                    left, right, up, down\n   *   Select character:               shift + left, shift + right\n   *   Select text vertically:         shift + up, shift + down\n   *   Move cursor by word:            alt + left, alt + right\n   *   Select words:                   shift + alt + left, shift + alt + right\n   *   Move cursor to line start/end:  cmd + left, cmd + right or home, end\n   *   Select till start/end of line:  cmd + shift + left, cmd + shift + right or shift + home, shift + end\n   *   Jump to start/end of text:      cmd + up, cmd + down\n   *   Select till start/end of text:  cmd + shift + up, cmd + shift + down or shift + pgUp, shift + pgDown\n   *   Delete character:               backspace\n   *   Delete word:                    alt + backspace\n   *   Delete line:                    cmd + backspace\n   *   Forward delete:                 delete\n   *   Copy text:                      ctrl/cmd + c\n   *   Paste text:                     ctrl/cmd + v\n   *   Cut text:                       ctrl/cmd + x\n   *   Select entire text:             ctrl/cmd + a\n   *   Quit editing                    tab or esc\n   * </pre>\n   *\n   * <p>Supported mouse/touch combination</p>\n   * <pre>\n   *   Position cursor:                click/touch\n   *   Create selection:               click/touch & drag\n   *   Create selection:               click & shift + click\n   *   Select word:                    double click\n   *   Select line:                    triple click\n   * </pre>\n   */\n  fabric.IText = fabric.util.createClass(fabric.Text, fabric.Observable, /** @lends fabric.IText.prototype */ {\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'i-text',\n\n    /**\n     * Index where text selection starts (or where cursor is when there is no selection)\n     * @type Number\n     * @default\n     */\n    selectionStart: 0,\n\n    /**\n     * Index where text selection ends\n     * @type Number\n     * @default\n     */\n    selectionEnd: 0,\n\n    /**\n     * Color of text selection\n     * @type String\n     * @default\n     */\n    selectionColor: 'rgba(17,119,255,0.3)',\n\n    /**\n     * Indicates whether text is in editing mode\n     * @type Boolean\n     * @default\n     */\n    isEditing: false,\n\n    /**\n     * Indicates whether a text can be edited\n     * @type Boolean\n     * @default\n     */\n    editable: true,\n\n    /**\n     * Border color of text object while it's in editing mode\n     * @type String\n     * @default\n     */\n    editingBorderColor: 'rgba(102,153,255,0.25)',\n\n    /**\n     * Width of cursor (in px)\n     * @type Number\n     * @default\n     */\n    cursorWidth: 2,\n\n    /**\n     * Color of default cursor (when not overwritten by character style)\n     * @type String\n     * @default\n     */\n    cursorColor: '#333',\n\n    /**\n     * Delay between cursor blink (in ms)\n     * @type Number\n     * @default\n     */\n    cursorDelay: 1000,\n\n    /**\n     * Duration of cursor fadein (in ms)\n     * @type Number\n     * @default\n     */\n    cursorDuration: 600,\n\n    /**\n     * Object containing character styles\n     * (where top-level properties corresponds to line number and 2nd-level properties -- to char number in a line)\n     * @type Object\n     * @default\n     */\n    styles: null,\n\n    /**\n     * Indicates whether internal text char widths can be cached\n     * @type Boolean\n     * @default\n     */\n    caching: true,\n\n    /**\n     * @private\n     */\n    _reSpace: /\\s|\\n/,\n\n    /**\n     * @private\n     */\n    _currentCursorOpacity: 0,\n\n    /**\n     * @private\n     */\n    _selectionDirection: null,\n\n    /**\n     * @private\n     */\n    _abortCursorAnimation: false,\n\n    /**\n     * @private\n     */\n    _charWidthsCache: { },\n\n    /**\n     * @private\n     */\n    __widthOfSpace: [ ],\n\n    /**\n     * Constructor\n     * @param {String} text Text string\n     * @param {Object} [options] Options object\n     * @return {fabric.IText} thisArg\n     */\n    initialize: function(text, options) {\n      this.styles = options ? (options.styles || { }) : { };\n      this.callSuper('initialize', text, options);\n      this.initBehavior();\n    },\n\n    /**\n     * @private\n     */\n    _clearCache: function() {\n      this.callSuper('_clearCache');\n      this.__widthOfSpace = [ ];\n    },\n\n    /**\n     * Returns true if object has no styling\n     */\n    isEmptyStyles: function() {\n      if (!this.styles) {\n        return true;\n      }\n      var obj = this.styles;\n\n      for (var p1 in obj) {\n        for (var p2 in obj[p1]) {\n          /*jshint unused:false */\n          for (var p3 in obj[p1][p2]) {\n            return false;\n          }\n        }\n      }\n      return true;\n    },\n\n    /**\n     * Sets selection start (left boundary of a selection)\n     * @param {Number} index Index to set selection start to\n     */\n    setSelectionStart: function(index) {\n      index = Math.max(index, 0);\n      if (this.selectionStart !== index) {\n        this.fire('selection:changed');\n        this.canvas && this.canvas.fire('text:selection:changed', { target: this });\n        this.selectionStart = index;\n      }\n      this._updateTextarea();\n    },\n\n    /**\n     * Sets selection end (right boundary of a selection)\n     * @param {Number} index Index to set selection end to\n     */\n    setSelectionEnd: function(index) {\n      index = Math.min(index, this.text.length);\n      if (this.selectionEnd !== index) {\n        this.fire('selection:changed');\n        this.canvas && this.canvas.fire('text:selection:changed', { target: this });\n        this.selectionEnd = index;\n      }\n      this._updateTextarea();\n    },\n\n    /**\n     * Gets style of a current selection/cursor (at the start position)\n     * @param {Number} [startIndex] Start index to get styles at\n     * @param {Number} [endIndex] End index to get styles at\n     * @return {Object} styles Style object at a specified (or current) index\n     */\n    getSelectionStyles: function(startIndex, endIndex) {\n\n      if (arguments.length === 2) {\n        var styles = [ ];\n        for (var i = startIndex; i < endIndex; i++) {\n          styles.push(this.getSelectionStyles(i));\n        }\n        return styles;\n      }\n\n      var loc = this.get2DCursorLocation(startIndex),\n          style = this._getStyleDeclaration(loc.lineIndex, loc.charIndex);\n\n      return style || {};\n    },\n\n    /**\n     * Sets style of a current selection\n     * @param {Object} [styles] Styles object\n     * @return {fabric.IText} thisArg\n     * @chainable\n     */\n    setSelectionStyles: function(styles) {\n      if (this.selectionStart === this.selectionEnd) {\n        this._extendStyles(this.selectionStart, styles);\n      }\n      else {\n        for (var i = this.selectionStart; i < this.selectionEnd; i++) {\n          this._extendStyles(i, styles);\n        }\n      }\n      /* not included in _extendStyles to avoid clearing cache more than once */\n      this._forceClearCache = true;\n      return this;\n    },\n\n    /**\n     * @private\n     */\n    _extendStyles: function(index, styles) {\n      var loc = this.get2DCursorLocation(index);\n\n      if (!this._getLineStyle(loc.lineIndex)) {\n        this._setLineStyle(loc.lineIndex, {});\n      }\n\n      if (!this._getStyleDeclaration(loc.lineIndex, loc.charIndex)) {\n        this._setStyleDeclaration(loc.lineIndex, loc.charIndex, {});\n      }\n\n      fabric.util.object.extend(this._getStyleDeclaration(loc.lineIndex, loc.charIndex), styles);\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _render: function(ctx) {\n      this.callSuper('_render', ctx);\n      this.ctx = ctx;\n      this.isEditing && this.renderCursorOrSelection();\n    },\n\n    /**\n     * Renders cursor or selection (depending on what exists)\n     */\n    renderCursorOrSelection: function() {\n      if (!this.active) {\n        return;\n      }\n\n      var chars = this.text.split(''),\n          boundaries, ctx;\n\n      if (this.canvas.contextTop) {\n        ctx = this.canvas.contextTop;\n        ctx.save();\n        ctx.transform.apply(ctx, this.canvas.viewportTransform);\n        this.transform(ctx);\n        this.transformMatrix && ctx.transform.apply(ctx, this.transformMatrix);\n      }\n      else {\n        ctx = this.ctx;\n        ctx.save();\n      }\n\n      if (this.selectionStart === this.selectionEnd) {\n        boundaries = this._getCursorBoundaries(chars, 'cursor');\n        this.renderCursor(boundaries, ctx);\n      }\n      else {\n        boundaries = this._getCursorBoundaries(chars, 'selection');\n        this.renderSelection(chars, boundaries, ctx);\n      }\n\n      ctx.restore();\n    },\n\n    /**\n     * Returns 2d representation (lineIndex and charIndex) of cursor (or selection start)\n     * @param {Number} [selectionStart] Optional index. When not given, current selectionStart is used.\n     */\n    get2DCursorLocation: function(selectionStart) {\n      if (typeof selectionStart === 'undefined') {\n        selectionStart = this.selectionStart;\n      }\n      var len = this._textLines.length;\n      for (var i = 0; i < len; i++) {\n        if (selectionStart <= this._textLines[i].length) {\n          return {\n            lineIndex: i,\n            charIndex: selectionStart\n          };\n        }\n        selectionStart -= this._textLines[i].length + 1;\n      }\n      return {\n        lineIndex: i - 1,\n        charIndex: this._textLines[i - 1].length < selectionStart ? this._textLines[i - 1].length : selectionStart\n      };\n    },\n\n    /**\n     * Returns complete style of char at the current cursor\n     * @param {Number} lineIndex Line index\n     * @param {Number} charIndex Char index\n     * @return {Object} Character style\n     */\n    getCurrentCharStyle: function(lineIndex, charIndex) {\n      var style = this._getStyleDeclaration(lineIndex, charIndex === 0 ? 0 : charIndex - 1);\n\n      return {\n        fontSize: style && style.fontSize || this.fontSize,\n        fill: style && style.fill || this.fill,\n        textBackgroundColor: style && style.textBackgroundColor || this.textBackgroundColor,\n        textDecoration: style && style.textDecoration || this.textDecoration,\n        fontFamily: style && style.fontFamily || this.fontFamily,\n        fontWeight: style && style.fontWeight || this.fontWeight,\n        fontStyle: style && style.fontStyle || this.fontStyle,\n        stroke: style && style.stroke || this.stroke,\n        strokeWidth: style && style.strokeWidth || this.strokeWidth\n      };\n    },\n\n    /**\n     * Returns fontSize of char at the current cursor\n     * @param {Number} lineIndex Line index\n     * @param {Number} charIndex Char index\n     * @return {Number} Character font size\n     */\n    getCurrentCharFontSize: function(lineIndex, charIndex) {\n      var style = this._getStyleDeclaration(lineIndex, charIndex === 0 ? 0 : charIndex - 1);\n      return style && style.fontSize ? style.fontSize : this.fontSize;\n    },\n\n    /**\n     * Returns color (fill) of char at the current cursor\n     * @param {Number} lineIndex Line index\n     * @param {Number} charIndex Char index\n     * @return {String} Character color (fill)\n     */\n    getCurrentCharColor: function(lineIndex, charIndex) {\n      var style = this._getStyleDeclaration(lineIndex, charIndex === 0 ? 0 : charIndex - 1);\n      return style && style.fill ? style.fill : this.cursorColor;\n    },\n\n    /**\n     * Returns cursor boundaries (left, top, leftOffset, topOffset)\n     * @private\n     * @param {Array} chars Array of characters\n     * @param {String} typeOfBoundaries\n     */\n    _getCursorBoundaries: function(chars, typeOfBoundaries) {\n\n      // left/top are left/top of entire text box\n      // leftOffset/topOffset are offset from that left/top point of a text box\n\n      var left = Math.round(this._getLeftOffset()),\n          top = this._getTopOffset(),\n\n          offsets = this._getCursorBoundariesOffsets(\n                      chars, typeOfBoundaries);\n\n      return {\n        left: left,\n        top: top,\n        leftOffset: offsets.left + offsets.lineLeft,\n        topOffset: offsets.top\n      };\n    },\n\n    /**\n     * @private\n     */\n    _getCursorBoundariesOffsets: function(chars, typeOfBoundaries) {\n\n      var lineLeftOffset = 0,\n\n          lineIndex = 0,\n          charIndex = 0,\n          topOffset = 0,\n          leftOffset = 0;\n\n      for (var i = 0; i < this.selectionStart; i++) {\n        if (chars[i] === '\\n') {\n          leftOffset = 0;\n          topOffset += this._getHeightOfLine(this.ctx, lineIndex);\n\n          lineIndex++;\n          charIndex = 0;\n        }\n        else {\n          leftOffset += this._getWidthOfChar(this.ctx, chars[i], lineIndex, charIndex);\n          charIndex++;\n        }\n\n        lineLeftOffset = this._getLineLeftOffset(this._getLineWidth(this.ctx, lineIndex));\n      }\n      if (typeOfBoundaries === 'cursor') {\n        topOffset += (1 - this._fontSizeFraction) * this._getHeightOfLine(this.ctx, lineIndex) / this.lineHeight\n          - this.getCurrentCharFontSize(lineIndex, charIndex) * (1 - this._fontSizeFraction);\n      }\n\n      return {\n        top: topOffset,\n        left: leftOffset,\n        lineLeft: lineLeftOffset\n      };\n    },\n\n    /**\n     * Renders cursor\n     * @param {Object} boundaries\n     * @param {CanvasRenderingContext2D} ctx transformed context to draw on\n     */\n    renderCursor: function(boundaries, ctx) {\n\n      var cursorLocation = this.get2DCursorLocation(),\n          lineIndex = cursorLocation.lineIndex,\n          charIndex = cursorLocation.charIndex,\n          charHeight = this.getCurrentCharFontSize(lineIndex, charIndex),\n          leftOffset = (lineIndex === 0 && charIndex === 0)\n                    ? this._getLineLeftOffset(this._getLineWidth(ctx, lineIndex))\n                    : boundaries.leftOffset;\n\n      ctx.fillStyle = this.getCurrentCharColor(lineIndex, charIndex);\n      ctx.globalAlpha = this.__isMousedown ? 1 : this._currentCursorOpacity;\n\n      ctx.fillRect(\n        boundaries.left + leftOffset,\n        boundaries.top + boundaries.topOffset,\n        this.cursorWidth / this.scaleX,\n        charHeight);\n\n    },\n\n    /**\n     * Renders text selection\n     * @param {Array} chars Array of characters\n     * @param {Object} boundaries Object with left/top/leftOffset/topOffset\n     * @param {CanvasRenderingContext2D} ctx transformed context to draw on\n     */\n    renderSelection: function(chars, boundaries, ctx) {\n\n      ctx.fillStyle = this.selectionColor;\n\n      var start = this.get2DCursorLocation(this.selectionStart),\n          end = this.get2DCursorLocation(this.selectionEnd),\n          startLine = start.lineIndex,\n          endLine = end.lineIndex;\n\n      for (var i = startLine; i <= endLine; i++) {\n        var lineOffset = this._getLineLeftOffset(this._getLineWidth(ctx, i)) || 0,\n            lineHeight = this._getHeightOfLine(this.ctx, i),\n            boxWidth = 0, line = this._textLines[i];\n\n        if (i === startLine) {\n          for (var j = 0, len = line.length; j < len; j++) {\n            if (j >= start.charIndex && (i !== endLine || j < end.charIndex)) {\n              boxWidth += this._getWidthOfChar(ctx, line[j], i, j);\n            }\n            if (j < start.charIndex) {\n              lineOffset += this._getWidthOfChar(ctx, line[j], i, j);\n            }\n          }\n        }\n        else if (i > startLine && i < endLine) {\n          boxWidth += this._getLineWidth(ctx, i) || 5;\n        }\n        else if (i === endLine) {\n          for (var j2 = 0, j2len = end.charIndex; j2 < j2len; j2++) {\n            boxWidth += this._getWidthOfChar(ctx, line[j2], i, j2);\n          }\n        }\n\n        ctx.fillRect(\n          boundaries.left + lineOffset,\n          boundaries.top + boundaries.topOffset,\n          boxWidth,\n          lineHeight);\n\n        boundaries.topOffset += lineHeight;\n      }\n    },\n\n    /**\n     * @private\n     * @param {String} method\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderChars: function(method, ctx, line, left, top, lineIndex, charOffset) {\n\n      if (this.isEmptyStyles()) {\n        return this._renderCharsFast(method, ctx, line, left, top);\n      }\n\n      charOffset = charOffset || 0;\n      this.skipTextAlign = true;\n\n      // set proper box offset\n      left -= this.textAlign === 'center'\n        ? (this.width / 2)\n        : (this.textAlign === 'right')\n          ? this.width\n          : 0;\n\n      // set proper line offset\n      var lineHeight = this._getHeightOfLine(ctx, lineIndex),\n          lineLeftOffset = this._getLineLeftOffset(this._getLineWidth(ctx, lineIndex)),\n          prevStyle,\n          thisStyle,\n          charsToRender = '';\n\n      left += lineLeftOffset || 0;\n\n      ctx.save();\n      top -= lineHeight / this.lineHeight * this._fontSizeFraction;\n      for (var i = charOffset, len = line.length + charOffset; i <= len; i++) {\n        prevStyle = prevStyle || this.getCurrentCharStyle(lineIndex, i);\n        thisStyle = this.getCurrentCharStyle(lineIndex, i + 1);\n\n        if (this._hasStyleChanged(prevStyle, thisStyle) || i === len) {\n          this._renderChar(method, ctx, lineIndex, i - 1, charsToRender, left, top, lineHeight);\n          charsToRender = '';\n          prevStyle = thisStyle;\n        }\n        charsToRender += line[i - charOffset];\n      }\n      ctx.restore();\n    },\n\n    /**\n     * @private\n     * @param {String} method\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {String} line Content of the line\n     * @param {Number} left Left coordinate\n     * @param {Number} top Top coordinate\n     */\n    _renderCharsFast: function(method, ctx, line, left, top) {\n      this.skipTextAlign = false;\n\n      if (method === 'fillText' && this.fill) {\n        this.callSuper('_renderChars', method, ctx, line, left, top);\n      }\n      if (method === 'strokeText' && ((this.stroke && this.strokeWidth > 0) || this.skipFillStrokeCheck)) {\n        this.callSuper('_renderChars', method, ctx, line, left, top);\n      }\n    },\n\n    /**\n     * @private\n     * @param {String} method\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Number} lineIndex\n     * @param {Number} i\n     * @param {String} _char\n     * @param {Number} left Left coordinate\n     * @param {Number} top Top coordinate\n     * @param {Number} lineHeight Height of the line\n     */\n    _renderChar: function(method, ctx, lineIndex, i, _char, left, top, lineHeight) {\n      var charWidth, charHeight, shouldFill, shouldStroke,\n          decl = this._getStyleDeclaration(lineIndex, i),\n          offset, textDecoration;\n\n      if (decl) {\n        charHeight = this._getHeightOfChar(ctx, _char, lineIndex, i);\n        shouldStroke = decl.stroke;\n        shouldFill = decl.fill;\n        textDecoration = decl.textDecoration;\n      }\n      else {\n        charHeight = this.fontSize;\n      }\n\n      shouldStroke = (shouldStroke || this.stroke) && method === 'strokeText';\n      shouldFill = (shouldFill || this.fill) && method === 'fillText';\n\n      decl && ctx.save();\n\n      charWidth = this._applyCharStylesGetWidth(ctx, _char, lineIndex, i, decl || {});\n      textDecoration = textDecoration || this.textDecoration;\n\n      if (decl && decl.textBackgroundColor) {\n        this._removeShadow(ctx);\n      }\n      shouldFill && ctx.fillText(_char, left, top);\n      shouldStroke && ctx.strokeText(_char, left, top);\n\n      if (textDecoration || textDecoration !== '') {\n        offset = this._fontSizeFraction * lineHeight / this.lineHeight;\n        this._renderCharDecoration(ctx, textDecoration, left, top, offset, charWidth, charHeight);\n      }\n\n      decl && ctx.restore();\n      ctx.translate(charWidth, 0);\n    },\n\n    /**\n     * @private\n     * @param {Object} prevStyle\n     * @param {Object} thisStyle\n     */\n    _hasStyleChanged: function(prevStyle, thisStyle) {\n      return (prevStyle.fill !== thisStyle.fill ||\n              prevStyle.fontSize !== thisStyle.fontSize ||\n              prevStyle.textBackgroundColor !== thisStyle.textBackgroundColor ||\n              prevStyle.textDecoration !== thisStyle.textDecoration ||\n              prevStyle.fontFamily !== thisStyle.fontFamily ||\n              prevStyle.fontWeight !== thisStyle.fontWeight ||\n              prevStyle.fontStyle !== thisStyle.fontStyle ||\n              prevStyle.stroke !== thisStyle.stroke ||\n              prevStyle.strokeWidth !== thisStyle.strokeWidth\n      );\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderCharDecoration: function(ctx, textDecoration, left, top, offset, charWidth, charHeight) {\n\n      if (!textDecoration) {\n        return;\n      }\n\n      var decorationWeight = charHeight / 15,\n          positions = {\n            underline: top + charHeight / 10,\n            'line-through': top - charHeight * (this._fontSizeFraction + this._fontSizeMult - 1) + decorationWeight,\n            overline: top - (this._fontSizeMult - this._fontSizeFraction) * charHeight\n          },\n          decorations = ['underline', 'line-through', 'overline'], i, decoration;\n\n      for (i = 0; i < decorations.length; i++) {\n        decoration = decorations[i];\n        if (textDecoration.indexOf(decoration) > -1) {\n          ctx.fillRect(left, positions[decoration], charWidth , decorationWeight);\n        }\n      }\n    },\n\n    /**\n     * @private\n     * @param {String} method\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {String} line\n     */\n    _renderTextLine: function(method, ctx, line, left, top, lineIndex) {\n      // to \"cancel\" this.fontSize subtraction in fabric.Text#_renderTextLine\n      // the adding 0.03 is just to align text with itext by overlap test\n      if (!this.isEmptyStyles()) {\n        top += this.fontSize * (this._fontSizeFraction + 0.03);\n      }\n      this.callSuper('_renderTextLine', method, ctx, line, left, top, lineIndex);\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderTextDecoration: function(ctx) {\n      if (this.isEmptyStyles()) {\n        return this.callSuper('_renderTextDecoration', ctx);\n      }\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _renderTextLinesBackground: function(ctx) {\n      this.callSuper('_renderTextLinesBackground', ctx);\n\n      var lineTopOffset = 0, heightOfLine,\n          lineWidth, lineLeftOffset,\n          leftOffset = this._getLeftOffset(),\n          topOffset = this._getTopOffset(),\n          line, _char, style;\n\n      for (var i = 0, len = this._textLines.length; i < len; i++) {\n        heightOfLine = this._getHeightOfLine(ctx, i);\n        line = this._textLines[i];\n\n        if (line === '' || !this.styles || !this._getLineStyle(i)) {\n          lineTopOffset += heightOfLine;\n          continue;\n        }\n\n        lineWidth = this._getLineWidth(ctx, i);\n        lineLeftOffset = this._getLineLeftOffset(lineWidth);\n\n        for (var j = 0, jlen = line.length; j < jlen; j++) {\n          style = this._getStyleDeclaration(i, j);\n          if (!style || !style.textBackgroundColor) {\n            continue;\n          }\n          _char = line[j];\n\n          ctx.fillStyle = style.textBackgroundColor;\n\n          ctx.fillRect(\n            leftOffset + lineLeftOffset + this._getWidthOfCharsAt(ctx, i, j),\n            topOffset + lineTopOffset,\n            this._getWidthOfChar(ctx, _char, i, j) + 1,\n            heightOfLine / this.lineHeight\n          );\n        }\n        lineTopOffset += heightOfLine;\n      }\n    },\n\n    /**\n     * @private\n     */\n    _getCacheProp: function(_char, styleDeclaration) {\n      return _char +\n             styleDeclaration.fontFamily +\n             styleDeclaration.fontSize +\n             styleDeclaration.fontWeight +\n             styleDeclaration.fontStyle +\n             styleDeclaration.shadow;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {String} _char\n     * @param {Number} lineIndex\n     * @param {Number} charIndex\n     * @param {Object} [decl]\n     */\n    _applyCharStylesGetWidth: function(ctx, _char, lineIndex, charIndex, decl) {\n      var charDecl = this._getStyleDeclaration(lineIndex, charIndex),\n          styleDeclaration = (decl && clone(decl)) || clone(charDecl), width;\n\n      this._applyFontStyles(styleDeclaration);\n\n      var cacheProp = this._getCacheProp(_char, styleDeclaration);\n\n      // short-circuit if no styles for this char\n      // global style from object is always applyed and handled by save and restore\n      if (!charDecl && this._charWidthsCache[cacheProp] && this.caching) {\n        return this._charWidthsCache[cacheProp];\n      }\n\n      if (typeof styleDeclaration.shadow === 'string') {\n        styleDeclaration.shadow = new fabric.Shadow(styleDeclaration.shadow);\n      }\n\n      var fill = styleDeclaration.fill || this.fill;\n      ctx.fillStyle = fill.toLive\n        ? fill.toLive(ctx, this)\n        : fill;\n\n      if (styleDeclaration.stroke) {\n        ctx.strokeStyle = (styleDeclaration.stroke && styleDeclaration.stroke.toLive)\n          ? styleDeclaration.stroke.toLive(ctx, this)\n          : styleDeclaration.stroke;\n      }\n\n      ctx.lineWidth = styleDeclaration.strokeWidth || this.strokeWidth;\n      ctx.font = this._getFontDeclaration.call(styleDeclaration);\n\n      //if we want this._setShadow.call to work with styleDeclarion\n      //we have to add those references\n      if (styleDeclaration.shadow) {\n        styleDeclaration.scaleX = this.scaleX;\n        styleDeclaration.scaleY = this.scaleY;\n        styleDeclaration.canvas = this.canvas;\n        this._setShadow.call(styleDeclaration, ctx);\n      }\n\n      if (!this.caching || !this._charWidthsCache[cacheProp]) {\n        width = ctx.measureText(_char).width;\n        this.caching && (this._charWidthsCache[cacheProp] = width);\n        return width;\n      }\n\n      return this._charWidthsCache[cacheProp];\n    },\n\n    /**\n     * @private\n     * @param {Object} styleDeclaration\n     */\n    _applyFontStyles: function(styleDeclaration) {\n      if (!styleDeclaration.fontFamily) {\n        styleDeclaration.fontFamily = this.fontFamily;\n      }\n      if (!styleDeclaration.fontSize) {\n        styleDeclaration.fontSize = this.fontSize;\n      }\n      if (!styleDeclaration.fontWeight) {\n        styleDeclaration.fontWeight = this.fontWeight;\n      }\n      if (!styleDeclaration.fontStyle) {\n        styleDeclaration.fontStyle = this.fontStyle;\n      }\n    },\n\n    /**\n     * @param {Number} lineIndex\n     * @param {Number} charIndex\n     * @param {Boolean} [returnCloneOrEmpty=false]\n     * @private\n     */\n    _getStyleDeclaration: function(lineIndex, charIndex, returnCloneOrEmpty) {\n      if (returnCloneOrEmpty) {\n        return (this.styles[lineIndex] && this.styles[lineIndex][charIndex])\n          ? clone(this.styles[lineIndex][charIndex])\n          : { };\n      }\n\n      return this.styles[lineIndex] && this.styles[lineIndex][charIndex] ? this.styles[lineIndex][charIndex] : null;\n    },\n\n    /**\n     * @param {Number} lineIndex\n     * @param {Number} charIndex\n     * @param {Object} style\n     * @private\n     */\n    _setStyleDeclaration: function(lineIndex, charIndex, style) {\n      this.styles[lineIndex][charIndex] = style;\n    },\n\n    /**\n     *\n     * @param {Number} lineIndex\n     * @param {Number} charIndex\n     * @private\n     */\n    _deleteStyleDeclaration: function(lineIndex, charIndex) {\n      delete this.styles[lineIndex][charIndex];\n    },\n\n    /**\n     * @param {Number} lineIndex\n     * @private\n     */\n    _getLineStyle: function(lineIndex) {\n      return this.styles[lineIndex];\n    },\n\n    /**\n     * @param {Number} lineIndex\n     * @param {Object} style\n     * @private\n     */\n    _setLineStyle: function(lineIndex, style) {\n      this.styles[lineIndex] = style;\n    },\n\n    /**\n     * @param {Number} lineIndex\n     * @private\n     */\n    _deleteLineStyle: function(lineIndex) {\n      delete this.styles[lineIndex];\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _getWidthOfChar: function(ctx, _char, lineIndex, charIndex) {\n      if (!this._isMeasuring && this.textAlign === 'justify' && this._reSpacesAndTabs.test(_char)) {\n        return this._getWidthOfSpace(ctx, lineIndex);\n      }\n\n      var styleDeclaration = this._getStyleDeclaration(lineIndex, charIndex, true);\n      this._applyFontStyles(styleDeclaration);\n      var cacheProp = this._getCacheProp(_char, styleDeclaration);\n\n      if (this._charWidthsCache[cacheProp] && this.caching) {\n        return this._charWidthsCache[cacheProp];\n      }\n      else if (ctx) {\n        ctx.save();\n        var width = this._applyCharStylesGetWidth(ctx, _char, lineIndex, charIndex);\n        ctx.restore();\n        return width;\n      }\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _getHeightOfChar: function(ctx, lineIndex, charIndex) {\n      var style = this._getStyleDeclaration(lineIndex, charIndex);\n      return style && style.fontSize ? style.fontSize : this.fontSize;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Number} lineIndex\n     * @param {Number} charIndex\n     */\n    _getWidthOfCharsAt: function(ctx, lineIndex, charIndex) {\n      var width = 0, i, _char;\n      for (i = 0; i < charIndex; i++) {\n        _char = this._textLines[lineIndex][i];\n        width += this._getWidthOfChar(ctx, _char, lineIndex, i);\n      }\n      return width;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Number} lineIndex line number\n     * @return {Number} Line width\n     */\n    _measureLine: function(ctx, lineIndex) {\n      this._isMeasuring = true;\n      var width = this._getWidthOfCharsAt(ctx, lineIndex, this._textLines[lineIndex].length);\n      this._isMeasuring = false;\n      return width;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Number} lineIndex\n     */\n    _getWidthOfSpace: function (ctx, lineIndex) {\n      if (this.__widthOfSpace[lineIndex]) {\n        return this.__widthOfSpace[lineIndex];\n      }\n      var line = this._textLines[lineIndex],\n          wordsWidth = this._getWidthOfWords(ctx, line, lineIndex, 0),\n          widthDiff = this.width - wordsWidth,\n          numSpaces = line.length - line.replace(this._reSpacesAndTabs, '').length,\n          width = Math.max(widthDiff / numSpaces, ctx.measureText(' ').width);\n      this.__widthOfSpace[lineIndex] = width;\n      return width;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     * @param {Number} line\n     * @param {Number} lineIndex\n     */\n    _getWidthOfWords: function (ctx, line, lineIndex, charOffset) {\n      var width = 0;\n\n      for (var charIndex = 0; charIndex < line.length; charIndex++) {\n        var _char = line[charIndex];\n\n        if (!_char.match(/\\s/)) {\n          width += this._getWidthOfChar(ctx, _char, lineIndex, charIndex + charOffset);\n        }\n      }\n\n      return width;\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _getHeightOfLine: function(ctx, lineIndex) {\n      if (this.__lineHeights[lineIndex]) {\n        return this.__lineHeights[lineIndex];\n      }\n\n      var line = this._textLines[lineIndex],\n          maxHeight = this._getHeightOfChar(ctx, lineIndex, 0);\n\n      for (var i = 1, len = line.length; i < len; i++) {\n        var currentCharHeight = this._getHeightOfChar(ctx, lineIndex, i);\n        if (currentCharHeight > maxHeight) {\n          maxHeight = currentCharHeight;\n        }\n      }\n      this.__lineHeights[lineIndex] = maxHeight * this.lineHeight * this._fontSizeMult;\n      return this.__lineHeights[lineIndex];\n    },\n\n    /**\n     * @private\n     * @param {CanvasRenderingContext2D} ctx Context to render on\n     */\n    _getTextHeight: function(ctx) {\n      var height = 0;\n      for (var i = 0, len = this._textLines.length; i < len; i++) {\n        height += this._getHeightOfLine(ctx, i);\n      }\n      return height;\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @method toObject\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      var clonedStyles = { }, i, j, row;\n      for (i in this.styles) {\n        row = this.styles[i];\n        clonedStyles[i] = { };\n        for (j in row) {\n          clonedStyles[i][j] = clone(row[j]);\n        }\n      }\n      return fabric.util.object.extend(this.callSuper('toObject', propertiesToInclude), {\n        styles: clonedStyles\n      });\n    }\n  });\n\n  /**\n   * Returns fabric.IText instance from an object representation\n   * @static\n   * @memberOf fabric.IText\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.IText} instance of fabric.IText\n   */\n  fabric.IText.fromObject = function(object) {\n    return new fabric.IText(object.text, clone(object));\n  };\n})();\n\n\n(function() {\n\n  var clone = fabric.util.object.clone;\n\n  fabric.util.object.extend(fabric.IText.prototype, /** @lends fabric.IText.prototype */ {\n\n    /**\n     * Initializes all the interactive behavior of IText\n     */\n    initBehavior: function() {\n      this.initAddedHandler();\n      this.initRemovedHandler();\n      this.initCursorSelectionHandlers();\n      this.initDoubleClickSimulation();\n    },\n\n    /**\n     * Initializes \"selected\" event handler\n     */\n    initSelectedHandler: function() {\n      this.on('selected', function() {\n\n        var _this = this;\n        setTimeout(function() {\n          _this.selected = true;\n        }, 100);\n      });\n    },\n\n    /**\n     * Initializes \"added\" event handler\n     */\n    initAddedHandler: function() {\n      var _this = this;\n      this.on('added', function() {\n        if (this.canvas && !this.canvas._hasITextHandlers) {\n          this.canvas._hasITextHandlers = true;\n          this._initCanvasHandlers();\n        }\n\n        // Track IText instances per-canvas. Only register in this array once added\n        // to a canvas; we don't want to leak a reference to the instance forever\n        // simply because it existed at some point.\n        // (Might be added to a collection, but not on a canvas.)\n        if (_this.canvas) {\n          _this.canvas._iTextInstances = _this.canvas._iTextInstances || [];\n          _this.canvas._iTextInstances.push(_this);\n        }\n      });\n    },\n\n    initRemovedHandler: function() {\n      var _this = this;\n      this.on('removed', function() {\n        // (Might be removed from a collection, but not on a canvas.)\n        if (_this.canvas) {\n          _this.canvas._iTextInstances = _this.canvas._iTextInstances || [];\n          fabric.util.removeFromArray(_this.canvas._iTextInstances, _this);\n        }\n      });\n    },\n\n    /**\n     * @private\n     */\n    _initCanvasHandlers: function() {\n      var _this = this;\n\n      this.canvas.on('selection:cleared', function() {\n        fabric.IText.prototype.exitEditingOnOthers(_this.canvas);\n      });\n\n      this.canvas.on('mouse:up', function() {\n        if (_this.canvas._iTextInstances) {\n          _this.canvas._iTextInstances.forEach(function(obj) {\n            obj.__isMousedown = false;\n          });\n        }\n      });\n\n      this.canvas.on('object:selected', function() {\n        fabric.IText.prototype.exitEditingOnOthers(_this.canvas);\n      });\n    },\n\n    /**\n     * @private\n     */\n    _tick: function() {\n      this._currentTickState = this._animateCursor(this, 1, this.cursorDuration, '_onTickComplete');\n    },\n\n    /**\n     * @private\n     */\n    _animateCursor: function(obj, targetOpacity, duration, completeMethod) {\n\n      var tickState;\n\n      tickState = {\n        isAborted: false,\n        abort: function() {\n          this.isAborted = true;\n        },\n      };\n\n      obj.animate('_currentCursorOpacity', targetOpacity, {\n        duration: duration,\n        onComplete: function() {\n          if (!tickState.isAborted) {\n            obj[completeMethod]();\n          }\n        },\n        onChange: function() {\n          if (obj.canvas) {\n            obj.canvas.clearContext(obj.canvas.contextTop || obj.ctx);\n            obj.renderCursorOrSelection();\n          }\n        },\n        abort: function() {\n          return tickState.isAborted;\n        }\n      });\n      return tickState;\n    },\n\n    /**\n     * @private\n     */\n    _onTickComplete: function() {\n\n      var _this = this;\n\n      if (this._cursorTimeout1) {\n        clearTimeout(this._cursorTimeout1);\n      }\n      this._cursorTimeout1 = setTimeout(function() {\n        _this._currentTickCompleteState = _this._animateCursor(_this, 0, this.cursorDuration / 2, '_tick');\n      }, 100);\n    },\n\n    /**\n     * Initializes delayed cursor\n     */\n    initDelayedCursor: function(restart) {\n      var _this = this,\n          delay = restart ? 0 : this.cursorDelay;\n\n      this._currentTickState && this._currentTickState.abort();\n      this._currentTickCompleteState && this._currentTickCompleteState.abort();\n      clearTimeout(this._cursorTimeout1);\n      this._currentCursorOpacity = 1;\n      if (this.canvas) {\n        this.canvas.clearContext(this.canvas.contextTop || this.ctx);\n        this.renderCursorOrSelection();\n      }\n      if (this._cursorTimeout2) {\n        clearTimeout(this._cursorTimeout2);\n      }\n      this._cursorTimeout2 = setTimeout(function() {\n        _this._tick();\n      }, delay);\n    },\n\n    /**\n     * Aborts cursor animation and clears all timeouts\n     */\n    abortCursorAnimation: function() {\n      this._currentTickState && this._currentTickState.abort();\n      this._currentTickCompleteState && this._currentTickCompleteState.abort();\n\n      clearTimeout(this._cursorTimeout1);\n      clearTimeout(this._cursorTimeout2);\n\n      this._currentCursorOpacity = 0;\n      this.canvas && this.canvas.clearContext(this.canvas.contextTop || this.ctx);\n    },\n\n    /**\n     * Selects entire text\n     */\n    selectAll: function() {\n      this.setSelectionStart(0);\n      this.setSelectionEnd(this.text.length);\n    },\n\n    /**\n     * Returns selected text\n     * @return {String}\n     */\n    getSelectedText: function() {\n      return this.text.slice(this.selectionStart, this.selectionEnd);\n    },\n\n    /**\n     * Find new selection index representing start of current word according to current selection index\n     * @param {Number} startFrom Surrent selection index\n     * @return {Number} New selection index\n     */\n    findWordBoundaryLeft: function(startFrom) {\n      var offset = 0, index = startFrom - 1;\n\n      // remove space before cursor first\n      if (this._reSpace.test(this.text.charAt(index))) {\n        while (this._reSpace.test(this.text.charAt(index))) {\n          offset++;\n          index--;\n        }\n      }\n      while (/\\S/.test(this.text.charAt(index)) && index > -1) {\n        offset++;\n        index--;\n      }\n\n      return startFrom - offset;\n    },\n\n    /**\n     * Find new selection index representing end of current word according to current selection index\n     * @param {Number} startFrom Current selection index\n     * @return {Number} New selection index\n     */\n    findWordBoundaryRight: function(startFrom) {\n      var offset = 0, index = startFrom;\n\n      // remove space after cursor first\n      if (this._reSpace.test(this.text.charAt(index))) {\n        while (this._reSpace.test(this.text.charAt(index))) {\n          offset++;\n          index++;\n        }\n      }\n      while (/\\S/.test(this.text.charAt(index)) && index < this.text.length) {\n        offset++;\n        index++;\n      }\n\n      return startFrom + offset;\n    },\n\n    /**\n     * Find new selection index representing start of current line according to current selection index\n     * @param {Number} startFrom Current selection index\n     * @return {Number} New selection index\n     */\n    findLineBoundaryLeft: function(startFrom) {\n      var offset = 0, index = startFrom - 1;\n\n      while (!/\\n/.test(this.text.charAt(index)) && index > -1) {\n        offset++;\n        index--;\n      }\n\n      return startFrom - offset;\n    },\n\n    /**\n     * Find new selection index representing end of current line according to current selection index\n     * @param {Number} startFrom Current selection index\n     * @return {Number} New selection index\n     */\n    findLineBoundaryRight: function(startFrom) {\n      var offset = 0, index = startFrom;\n\n      while (!/\\n/.test(this.text.charAt(index)) && index < this.text.length) {\n        offset++;\n        index++;\n      }\n\n      return startFrom + offset;\n    },\n\n    /**\n     * Returns number of newlines in selected text\n     * @return {Number} Number of newlines in selected text\n     */\n    getNumNewLinesInSelectedText: function() {\n      var selectedText = this.getSelectedText(),\n          numNewLines  = 0;\n\n      for (var i = 0, len = selectedText.length; i < len; i++) {\n        if (selectedText[i] === '\\n') {\n          numNewLines++;\n        }\n      }\n      return numNewLines;\n    },\n\n    /**\n     * Finds index corresponding to beginning or end of a word\n     * @param {Number} selectionStart Index of a character\n     * @param {Number} direction 1 or -1\n     * @return {Number} Index of the beginning or end of a word\n     */\n    searchWordBoundary: function(selectionStart, direction) {\n      var index     = this._reSpace.test(this.text.charAt(selectionStart)) ? selectionStart - 1 : selectionStart,\n          _char     = this.text.charAt(index),\n          reNonWord = /[ \\n\\.,;!\\?\\-]/;\n\n      while (!reNonWord.test(_char) && index > 0 && index < this.text.length) {\n        index += direction;\n        _char = this.text.charAt(index);\n      }\n      if (reNonWord.test(_char) && _char !== '\\n') {\n        index += direction === 1 ? 0 : 1;\n      }\n      return index;\n    },\n\n    /**\n     * Selects a word based on the index\n     * @param {Number} selectionStart Index of a character\n     */\n    selectWord: function(selectionStart) {\n      var newSelectionStart = this.searchWordBoundary(selectionStart, -1), /* search backwards */\n          newSelectionEnd   = this.searchWordBoundary(selectionStart, 1);\n      /* search forward */\n\n      this.setSelectionStart(newSelectionStart);\n      this.setSelectionEnd(newSelectionEnd);\n    },\n\n    /**\n     * Selects a line based on the index\n     * @param {Number} selectionStart Index of a character\n     */\n    selectLine: function(selectionStart) {\n      var newSelectionStart = this.findLineBoundaryLeft(selectionStart),\n          newSelectionEnd   = this.findLineBoundaryRight(selectionStart);\n\n      this.setSelectionStart(newSelectionStart);\n      this.setSelectionEnd(newSelectionEnd);\n    },\n\n    /**\n     * Enters editing state\n     * @return {fabric.IText} thisArg\n     * @chainable\n     */\n    enterEditing: function(e) {\n      if (this.isEditing || !this.editable) {\n        return;\n      }\n\n      if (this.canvas) {\n        this.exitEditingOnOthers(this.canvas);\n      }\n\n      this.isEditing = true;\n\n      this.initHiddenTextarea(e);\n      this.hiddenTextarea.focus();\n      this._updateTextarea();\n      this._saveEditingProps();\n      this._setEditingProps();\n      this._textBeforeEdit = this.text;\n\n      this._tick();\n      this.fire('editing:entered');\n\n      if (!this.canvas) {\n        return this;\n      }\n\n      this.canvas.renderAll();\n      this.canvas.fire('text:editing:entered', { target: this });\n      this.initMouseMoveHandler();\n      return this;\n    },\n\n    exitEditingOnOthers: function(canvas) {\n      if (canvas._iTextInstances) {\n        canvas._iTextInstances.forEach(function(obj) {\n          obj.selected = false;\n          if (obj.isEditing) {\n            obj.exitEditing();\n          }\n        });\n      }\n    },\n\n    /**\n     * Initializes \"mousemove\" event handler\n     */\n    initMouseMoveHandler: function() {\n      var _this = this;\n      this.canvas.on('mouse:move', function(options) {\n        if (!_this.__isMousedown || !_this.isEditing) {\n          return;\n        }\n\n        var newSelectionStart = _this.getSelectionStartFromPointer(options.e);\n        if (newSelectionStart >= _this.__selectionStartOnMouseDown) {\n          _this.setSelectionStart(_this.__selectionStartOnMouseDown);\n          _this.setSelectionEnd(newSelectionStart);\n        }\n        else {\n          _this.setSelectionStart(newSelectionStart);\n          _this.setSelectionEnd(_this.__selectionStartOnMouseDown);\n        }\n      });\n    },\n\n    /**\n     * @private\n     */\n    _setEditingProps: function() {\n      this.hoverCursor = 'text';\n\n      if (this.canvas) {\n        this.canvas.defaultCursor = this.canvas.moveCursor = 'text';\n      }\n\n      this.borderColor = this.editingBorderColor;\n\n      this.hasControls = this.selectable = false;\n      this.lockMovementX = this.lockMovementY = true;\n    },\n\n    /**\n     * @private\n     */\n    _updateTextarea: function() {\n      if (!this.hiddenTextarea || this.inCompositionMode) {\n        return;\n      }\n\n      this.hiddenTextarea.value = this.text;\n      this.hiddenTextarea.selectionStart = this.selectionStart;\n      this.hiddenTextarea.selectionEnd = this.selectionEnd;\n      if (this.selectionStart === this.selectionEnd) {\n        var p = this._calcTextareaPosition();\n        this.hiddenTextarea.style.left = p.x + 'px';\n        this.hiddenTextarea.style.top = p.y + 'px';\n      }\n    },\n\n    /**\n     * @private\n     */\n    _calcTextareaPosition: function() {\n      var chars = this.text.split(''),\n          boundaries = this._getCursorBoundaries(chars, 'cursor'),\n          cursorLocation = this.get2DCursorLocation(),\n          lineIndex = cursorLocation.lineIndex,\n          charIndex = cursorLocation.charIndex,\n          charHeight = this.getCurrentCharFontSize(lineIndex, charIndex),\n          leftOffset = (lineIndex === 0 && charIndex === 0)\n                    ? this._getLineLeftOffset(this._getLineWidth(this.ctx, lineIndex))\n                    : boundaries.leftOffset,\n          m = this.calcTransformMatrix(),\n          p = { x: boundaries.left + leftOffset, y: boundaries.top + boundaries.topOffset + charHeight };\n      this.hiddenTextarea.style.fontSize = charHeight + 'px';\n      return fabric.util.transformPoint(p, m);\n    },\n\n    /**\n     * @private\n     */\n    _saveEditingProps: function() {\n      this._savedProps = {\n        hasControls: this.hasControls,\n        borderColor: this.borderColor,\n        lockMovementX: this.lockMovementX,\n        lockMovementY: this.lockMovementY,\n        hoverCursor: this.hoverCursor,\n        defaultCursor: this.canvas && this.canvas.defaultCursor,\n        moveCursor: this.canvas && this.canvas.moveCursor\n      };\n    },\n\n    /**\n     * @private\n     */\n    _restoreEditingProps: function() {\n      if (!this._savedProps) {\n        return;\n      }\n\n      this.hoverCursor = this._savedProps.overCursor;\n      this.hasControls = this._savedProps.hasControls;\n      this.borderColor = this._savedProps.borderColor;\n      this.lockMovementX = this._savedProps.lockMovementX;\n      this.lockMovementY = this._savedProps.lockMovementY;\n\n      if (this.canvas) {\n        this.canvas.defaultCursor = this._savedProps.defaultCursor;\n        this.canvas.moveCursor = this._savedProps.moveCursor;\n      }\n    },\n\n    /**\n     * Exits from editing state\n     * @return {fabric.IText} thisArg\n     * @chainable\n     */\n    exitEditing: function() {\n      var isTextChanged = (this._textBeforeEdit !== this.text);\n      this.selected = false;\n      this.isEditing = false;\n      this.selectable = true;\n\n      this.selectionEnd = this.selectionStart;\n      this.hiddenTextarea && this.canvas && this.hiddenTextarea.parentNode.removeChild(this.hiddenTextarea);\n      this.hiddenTextarea = null;\n\n      this.abortCursorAnimation();\n      this._restoreEditingProps();\n      this._currentCursorOpacity = 0;\n\n      this.fire('editing:exited');\n      isTextChanged && this.fire('modified');\n      if (this.canvas) {\n        this.canvas.fire('text:editing:exited', { target: this });\n        isTextChanged && this.canvas.fire('object:modified', { target: this });\n      }\n\n      return this;\n    },\n\n    /**\n     * @private\n     */\n    _removeExtraneousStyles: function() {\n      for (var prop in this.styles) {\n        if (!this._textLines[prop]) {\n          delete this.styles[prop];\n        }\n      }\n    },\n\n    /**\n     * @private\n     */\n    _removeCharsFromTo: function(start, end) {\n      while (end !== start) {\n        this._removeSingleCharAndStyle(start + 1);\n        end--;\n      }\n      this.setSelectionStart(start);\n    },\n\n    _removeSingleCharAndStyle: function(index) {\n      var isBeginningOfLine = this.text[index - 1] === '\\n',\n          indexStyle        = isBeginningOfLine ? index : index - 1;\n      this.removeStyleObject(isBeginningOfLine, indexStyle);\n      this.text = this.text.slice(0, index - 1) +\n        this.text.slice(index);\n\n      this._textLines = this._splitTextIntoLines();\n    },\n\n    /**\n     * Inserts characters where cursor is (replacing selection if one exists)\n     * @param {String} _chars Characters to insert\n     * @param {Boolean} useCopiedStyle use fabric.copiedTextStyle\n     */\n    insertChars: function(_chars, useCopiedStyle) {\n      var style;\n\n      if (this.selectionEnd - this.selectionStart > 1) {\n        this._removeCharsFromTo(this.selectionStart, this.selectionEnd);\n        this.setSelectionEnd(this.selectionStart);\n      }\n      //short circuit for block paste\n      if (!useCopiedStyle && this.isEmptyStyles()) {\n        this.insertChar(_chars, false);\n        return;\n      }\n      for (var i = 0, len = _chars.length; i < len; i++) {\n        if (useCopiedStyle) {\n          style = fabric.copiedTextStyle[i];\n        }\n        this.insertChar(_chars[i], i < len - 1, style);\n      }\n    },\n\n    /**\n     * Inserts a character where cursor is\n     * @param {String} _char Characters to insert\n     * @param {Boolean} skipUpdate trigger rendering and updates at the end of text insert\n     * @param {Object} styleObject Style to be inserted for the new char\n     */\n    insertChar: function(_char, skipUpdate, styleObject) {\n      var isEndOfLine = this.text[this.selectionStart] === '\\n';\n      this.text = this.text.slice(0, this.selectionStart) +\n        _char + this.text.slice(this.selectionEnd);\n      this._textLines = this._splitTextIntoLines();\n      this.insertStyleObjects(_char, isEndOfLine, styleObject);\n      this.selectionStart += _char.length;\n      this.selectionEnd = this.selectionStart;\n      if (skipUpdate) {\n        return;\n      }\n      this._updateTextarea();\n      this.canvas && this.canvas.renderAll();\n      this.setCoords();\n      this.fire('changed');\n      this.canvas && this.canvas.fire('text:changed', { target: this });\n    },\n\n    /**\n     * Inserts new style object\n     * @param {Number} lineIndex Index of a line\n     * @param {Number} charIndex Index of a char\n     * @param {Boolean} isEndOfLine True if it's end of line\n     */\n    insertNewlineStyleObject: function(lineIndex, charIndex, isEndOfLine) {\n\n      this.shiftLineStyles(lineIndex, +1);\n\n      if (!this.styles[lineIndex + 1]) {\n        this.styles[lineIndex + 1] = {};\n      }\n\n      var currentCharStyle = {},\n          newLineStyles    = {};\n\n      if (this.styles[lineIndex] && this.styles[lineIndex][charIndex - 1]) {\n        currentCharStyle = this.styles[lineIndex][charIndex - 1];\n      }\n\n      // if there's nothing after cursor,\n      // we clone current char style onto the next (otherwise empty) line\n      if (isEndOfLine) {\n        newLineStyles[0] = clone(currentCharStyle);\n        this.styles[lineIndex + 1] = newLineStyles;\n      }\n      // otherwise we clone styles of all chars\n      // after cursor onto the next line, from the beginning\n      else {\n        for (var index in this.styles[lineIndex]) {\n          if (parseInt(index, 10) >= charIndex) {\n            newLineStyles[parseInt(index, 10) - charIndex] = this.styles[lineIndex][index];\n            // remove lines from the previous line since they're on a new line now\n            delete this.styles[lineIndex][index];\n          }\n        }\n        this.styles[lineIndex + 1] = newLineStyles;\n      }\n      this._forceClearCache = true;\n    },\n\n    /**\n     * Inserts style object for a given line/char index\n     * @param {Number} lineIndex Index of a line\n     * @param {Number} charIndex Index of a char\n     * @param {Object} [style] Style object to insert, if given\n     */\n    insertCharStyleObject: function(lineIndex, charIndex, style) {\n\n      var currentLineStyles       = this.styles[lineIndex],\n          currentLineStylesCloned = clone(currentLineStyles);\n\n      if (charIndex === 0 && !style) {\n        charIndex = 1;\n      }\n\n      // shift all char styles by 1 forward\n      // 0,1,2,3 -> (charIndex=2) -> 0,1,3,4 -> (insert 2) -> 0,1,2,3,4\n      for (var index in currentLineStylesCloned) {\n        var numericIndex = parseInt(index, 10);\n\n        if (numericIndex >= charIndex) {\n          currentLineStyles[numericIndex + 1] = currentLineStylesCloned[numericIndex];\n\n          // only delete the style if there was nothing moved there\n          if (!currentLineStylesCloned[numericIndex - 1]) {\n            delete currentLineStyles[numericIndex];\n          }\n        }\n      }\n\n      this.styles[lineIndex][charIndex] =\n        style || clone(currentLineStyles[charIndex - 1]);\n      this._forceClearCache = true;\n    },\n\n    /**\n     * Inserts style object(s)\n     * @param {String} _chars Characters at the location where style is inserted\n     * @param {Boolean} isEndOfLine True if it's end of line\n     * @param {Object} [styleObject] Style to insert\n     */\n    insertStyleObjects: function(_chars, isEndOfLine, styleObject) {\n      // removed shortcircuit over isEmptyStyles\n\n      var cursorLocation = this.get2DCursorLocation(),\n          lineIndex      = cursorLocation.lineIndex,\n          charIndex      = cursorLocation.charIndex;\n\n      if (!this._getLineStyle(lineIndex)) {\n        this._setLineStyle(lineIndex, {});\n      }\n\n      if (_chars === '\\n') {\n        this.insertNewlineStyleObject(lineIndex, charIndex, isEndOfLine);\n      }\n      else {\n        this.insertCharStyleObject(lineIndex, charIndex, styleObject);\n      }\n    },\n\n    /**\n     * Shifts line styles up or down\n     * @param {Number} lineIndex Index of a line\n     * @param {Number} offset Can be -1 or +1\n     */\n    shiftLineStyles: function(lineIndex, offset) {\n      // shift all line styles by 1 upward\n      var clonedStyles = clone(this.styles);\n      for (var line in this.styles) {\n        var numericLine = parseInt(line, 10);\n        if (numericLine > lineIndex) {\n          this.styles[numericLine + offset] = clonedStyles[numericLine];\n          if (!clonedStyles[numericLine - offset]) {\n            delete this.styles[numericLine];\n          }\n        }\n      }\n      //TODO: evaluate if delete old style lines with offset -1\n    },\n\n    /**\n     * Removes style object\n     * @param {Boolean} isBeginningOfLine True if cursor is at the beginning of line\n     * @param {Number} [index] Optional index. When not given, current selectionStart is used.\n     */\n    removeStyleObject: function(isBeginningOfLine, index) {\n\n      var cursorLocation = this.get2DCursorLocation(index),\n          lineIndex      = cursorLocation.lineIndex,\n          charIndex      = cursorLocation.charIndex;\n\n      this._removeStyleObject(isBeginningOfLine, cursorLocation, lineIndex, charIndex);\n    },\n\n    _getTextOnPreviousLine: function(lIndex) {\n      return this._textLines[lIndex - 1];\n    },\n\n    _removeStyleObject: function(isBeginningOfLine, cursorLocation, lineIndex, charIndex) {\n\n      if (isBeginningOfLine) {\n        var textOnPreviousLine     = this._getTextOnPreviousLine(cursorLocation.lineIndex),\n            newCharIndexOnPrevLine = textOnPreviousLine ? textOnPreviousLine.length : 0;\n\n        if (!this.styles[lineIndex - 1]) {\n          this.styles[lineIndex - 1] = {};\n        }\n        for (charIndex in this.styles[lineIndex]) {\n          this.styles[lineIndex - 1][parseInt(charIndex, 10) + newCharIndexOnPrevLine]\n            = this.styles[lineIndex][charIndex];\n        }\n        this.shiftLineStyles(cursorLocation.lineIndex, -1);\n      }\n      else {\n        var currentLineStyles = this.styles[lineIndex];\n\n        if (currentLineStyles) {\n          delete currentLineStyles[charIndex];\n        }\n        var currentLineStylesCloned = clone(currentLineStyles);\n        // shift all styles by 1 backwards\n        for (var i in currentLineStylesCloned) {\n          var numericIndex = parseInt(i, 10);\n          if (numericIndex >= charIndex && numericIndex !== 0) {\n            currentLineStyles[numericIndex - 1] = currentLineStylesCloned[numericIndex];\n            delete currentLineStyles[numericIndex];\n          }\n        }\n      }\n    },\n\n    /**\n     * Inserts new line\n     */\n    insertNewline: function() {\n      this.insertChars('\\n');\n    }\n  });\n})();\n\n\nfabric.util.object.extend(fabric.IText.prototype, /** @lends fabric.IText.prototype */ {\n  /**\n   * Initializes \"dbclick\" event handler\n   */\n  initDoubleClickSimulation: function() {\n\n    // for double click\n    this.__lastClickTime = +new Date();\n\n    // for triple click\n    this.__lastLastClickTime = +new Date();\n\n    this.__lastPointer = { };\n\n    this.on('mousedown', this.onMouseDown.bind(this));\n  },\n\n  onMouseDown: function(options) {\n\n    this.__newClickTime = +new Date();\n    var newPointer = this.canvas.getPointer(options.e);\n\n    if (this.isTripleClick(newPointer)) {\n      this.fire('tripleclick', options);\n      this._stopEvent(options.e);\n    }\n    else if (this.isDoubleClick(newPointer)) {\n      this.fire('dblclick', options);\n      this._stopEvent(options.e);\n    }\n\n    this.__lastLastClickTime = this.__lastClickTime;\n    this.__lastClickTime = this.__newClickTime;\n    this.__lastPointer = newPointer;\n    this.__lastIsEditing = this.isEditing;\n    this.__lastSelected = this.selected;\n  },\n\n  isDoubleClick: function(newPointer) {\n    return this.__newClickTime - this.__lastClickTime < 500 &&\n        this.__lastPointer.x === newPointer.x &&\n        this.__lastPointer.y === newPointer.y && this.__lastIsEditing;\n  },\n\n  isTripleClick: function(newPointer) {\n    return this.__newClickTime - this.__lastClickTime < 500 &&\n        this.__lastClickTime - this.__lastLastClickTime < 500 &&\n        this.__lastPointer.x === newPointer.x &&\n        this.__lastPointer.y === newPointer.y;\n  },\n\n  /**\n   * @private\n   */\n  _stopEvent: function(e) {\n    e.preventDefault && e.preventDefault();\n    e.stopPropagation && e.stopPropagation();\n  },\n\n  /**\n   * Initializes event handlers related to cursor or selection\n   */\n  initCursorSelectionHandlers: function() {\n    this.initSelectedHandler();\n    this.initMousedownHandler();\n    this.initMouseupHandler();\n    this.initClicks();\n  },\n\n  /**\n   * Initializes double and triple click event handlers\n   */\n  initClicks: function() {\n    this.on('dblclick', function(options) {\n      this.selectWord(this.getSelectionStartFromPointer(options.e));\n    });\n    this.on('tripleclick', function(options) {\n      this.selectLine(this.getSelectionStartFromPointer(options.e));\n    });\n  },\n\n  /**\n   * Initializes \"mousedown\" event handler\n   */\n  initMousedownHandler: function() {\n    this.on('mousedown', function(options) {\n      if (!this.editable) {\n        return;\n      }\n      var pointer = this.canvas.getPointer(options.e);\n\n      this.__mousedownX = pointer.x;\n      this.__mousedownY = pointer.y;\n      this.__isMousedown = true;\n\n      if (this.hiddenTextarea && this.canvas) {\n        this.canvas.wrapperEl.appendChild(this.hiddenTextarea);\n      }\n\n      if (this.selected) {\n        this.setCursorByClick(options.e);\n      }\n\n      if (this.isEditing) {\n        this.__selectionStartOnMouseDown = this.selectionStart;\n        this.initDelayedCursor(true);\n      }\n    });\n  },\n\n  /**\n   * @private\n   */\n  _isObjectMoved: function(e) {\n    var pointer = this.canvas.getPointer(e);\n\n    return this.__mousedownX !== pointer.x ||\n           this.__mousedownY !== pointer.y;\n  },\n\n  /**\n   * Initializes \"mouseup\" event handler\n   */\n  initMouseupHandler: function() {\n    this.on('mouseup', function(options) {\n      this.__isMousedown = false;\n      if (!this.editable || this._isObjectMoved(options.e)) {\n        return;\n      }\n\n      if (this.__lastSelected && !this.__corner) {\n        this.enterEditing(options.e);\n        this.initDelayedCursor(true);\n      }\n      this.selected = true;\n    });\n  },\n\n  /**\n   * Changes cursor location in a text depending on passed pointer (x/y) object\n   * @param {Event} e Event object\n   */\n  setCursorByClick: function(e) {\n    var newSelectionStart = this.getSelectionStartFromPointer(e);\n\n    if (e.shiftKey) {\n      if (newSelectionStart < this.selectionStart) {\n        this.setSelectionEnd(this.selectionStart);\n        this.setSelectionStart(newSelectionStart);\n      }\n      else {\n        this.setSelectionEnd(newSelectionStart);\n      }\n    }\n    else {\n      this.setSelectionStart(newSelectionStart);\n      this.setSelectionEnd(newSelectionStart);\n    }\n  },\n\n  /**\n   * Returns index of a character corresponding to where an object was clicked\n   * @param {Event} e Event object\n   * @return {Number} Index of a character\n   */\n  getSelectionStartFromPointer: function(e) {\n    var mouseOffset = this.getLocalPointer(e),\n        prevWidth = 0,\n        width = 0,\n        height = 0,\n        charIndex = 0,\n        newSelectionStart,\n        line;\n\n    for (var i = 0, len = this._textLines.length; i < len; i++) {\n      line = this._textLines[i];\n      height += this._getHeightOfLine(this.ctx, i) * this.scaleY;\n\n      var widthOfLine = this._getLineWidth(this.ctx, i),\n          lineLeftOffset = this._getLineLeftOffset(widthOfLine);\n\n      width = lineLeftOffset * this.scaleX;\n\n      for (var j = 0, jlen = line.length; j < jlen; j++) {\n\n        prevWidth = width;\n\n        width += this._getWidthOfChar(this.ctx, line[j], i, this.flipX ? jlen - j : j) *\n                 this.scaleX;\n\n        if (height <= mouseOffset.y || width <= mouseOffset.x) {\n          charIndex++;\n          continue;\n        }\n\n        return this._getNewSelectionStartFromOffset(\n          mouseOffset, prevWidth, width, charIndex + i, jlen);\n      }\n\n      if (mouseOffset.y < height) {\n        //this happens just on end of lines.\n        return this._getNewSelectionStartFromOffset(\n          mouseOffset, prevWidth, width, charIndex + i - 1, jlen);\n      }\n    }\n\n    // clicked somewhere after all chars, so set at the end\n    if (typeof newSelectionStart === 'undefined') {\n      return this.text.length;\n    }\n  },\n\n  /**\n   * @private\n   */\n  _getNewSelectionStartFromOffset: function(mouseOffset, prevWidth, width, index, jlen) {\n\n    var distanceBtwLastCharAndCursor = mouseOffset.x - prevWidth,\n        distanceBtwNextCharAndCursor = width - mouseOffset.x,\n        offset = distanceBtwNextCharAndCursor > distanceBtwLastCharAndCursor ? 0 : 1,\n        newSelectionStart = index + offset;\n\n    // if object is horizontally flipped, mirror cursor location from the end\n    if (this.flipX) {\n      newSelectionStart = jlen - newSelectionStart;\n    }\n\n    if (newSelectionStart > this.text.length) {\n      newSelectionStart = this.text.length;\n    }\n\n    return newSelectionStart;\n  }\n});\n\n\nfabric.util.object.extend(fabric.IText.prototype, /** @lends fabric.IText.prototype */ {\n\n  /**\n   * Initializes hidden textarea (needed to bring up keyboard in iOS)\n   */\n  initHiddenTextarea: function(e) {\n    var p;\n    if (e && this.canvas) {\n      p = this.canvas.getPointer(e);\n    }\n    else {\n      this.oCoords || this.setCoords();\n      p = this.oCoords.tl;\n    }\n    this.hiddenTextarea = fabric.document.createElement('textarea');\n\n    this.hiddenTextarea.setAttribute('autocapitalize', 'off');\n    this.hiddenTextarea.style.cssText = 'position: absolute; top: ' + p.y + 'px; left: ' + p.x + 'px; opacity: 0;'\n                                        + ' width: 0px; height: 0px; z-index: -999;';\n    if (this.canvas) {\n      this.canvas.lowerCanvasEl.parentNode.appendChild(this.hiddenTextarea);\n    }\n    else {\n      fabric.document.body.appendChild(this.hiddenTextarea);\n    }\n\n    fabric.util.addListener(this.hiddenTextarea, 'keydown', this.onKeyDown.bind(this));\n    fabric.util.addListener(this.hiddenTextarea, 'keyup', this.onKeyUp.bind(this));\n    fabric.util.addListener(this.hiddenTextarea, 'input', this.onInput.bind(this));\n    fabric.util.addListener(this.hiddenTextarea, 'copy', this.copy.bind(this));\n    fabric.util.addListener(this.hiddenTextarea, 'cut', this.cut.bind(this));\n    fabric.util.addListener(this.hiddenTextarea, 'paste', this.paste.bind(this));\n    fabric.util.addListener(this.hiddenTextarea, 'compositionstart', this.onCompositionStart.bind(this));\n    fabric.util.addListener(this.hiddenTextarea, 'compositionupdate', this.onCompositionUpdate.bind(this));\n    fabric.util.addListener(this.hiddenTextarea, 'compositionend', this.onCompositionEnd.bind(this));\n\n    if (!this._clickHandlerInitialized && this.canvas) {\n      fabric.util.addListener(this.canvas.upperCanvasEl, 'click', this.onClick.bind(this));\n      this._clickHandlerInitialized = true;\n    }\n  },\n\n  /**\n   * @private\n   */\n  _keysMap: {\n    8:  'removeChars',\n    9:  'exitEditing',\n    27: 'exitEditing',\n    13: 'insertNewline',\n    33: 'moveCursorUp',\n    34: 'moveCursorDown',\n    35: 'moveCursorRight',\n    36: 'moveCursorLeft',\n    37: 'moveCursorLeft',\n    38: 'moveCursorUp',\n    39: 'moveCursorRight',\n    40: 'moveCursorDown',\n    46: 'forwardDelete'\n  },\n\n  /**\n   * @private\n   */\n  _ctrlKeysMapUp: {\n    67: 'copy',\n    88: 'cut'\n  },\n\n  /**\n   * @private\n   */\n  _ctrlKeysMapDown: {\n    65: 'selectAll'\n  },\n\n  onClick: function() {\n    // No need to trigger click event here, focus is enough to have the keyboard appear on Android\n    this.hiddenTextarea && this.hiddenTextarea.focus();\n  },\n\n  /**\n   * Handles keyup event\n   * @param {Event} e Event object\n   */\n  onKeyDown: function(e) {\n    if (!this.isEditing) {\n      return;\n    }\n    if (e.keyCode in this._keysMap) {\n      this[this._keysMap[e.keyCode]](e);\n    }\n    else if ((e.keyCode in this._ctrlKeysMapDown) && (e.ctrlKey || e.metaKey)) {\n      this[this._ctrlKeysMapDown[e.keyCode]](e);\n    }\n    else {\n      return;\n    }\n    e.stopImmediatePropagation();\n    e.preventDefault();\n    this.canvas && this.canvas.renderAll();\n  },\n\n  /**\n   * Handles keyup event\n   * We handle KeyUp because ie11 and edge have difficulties copy/pasting\n   * if a copy/cut event fired, keyup is dismissed\n   * @param {Event} e Event object\n   */\n  onKeyUp: function(e) {\n    if (!this.isEditing || this._copyDone) {\n      this._copyDone = false;\n      return;\n    }\n    if ((e.keyCode in this._ctrlKeysMapUp) && (e.ctrlKey || e.metaKey)) {\n      this[this._ctrlKeysMapUp[e.keyCode]](e);\n    }\n    else {\n      return;\n    }\n    e.stopImmediatePropagation();\n    e.preventDefault();\n    this.canvas && this.canvas.renderAll();\n  },\n\n  /**\n   * Handles onInput event\n   * @param {Event} e Event object\n   */\n  onInput: function(e) {\n    if (!this.isEditing || this.inCompositionMode) {\n      return;\n    }\n    var offset = this.selectionStart || 0,\n        offsetEnd = this.selectionEnd || 0,\n        textLength = this.text.length,\n        newTextLength = this.hiddenTextarea.value.length,\n        diff, charsToInsert, start;\n    if (newTextLength > textLength) {\n      //we added some character\n      start = this._selectionDirection === 'left' ? offsetEnd : offset;\n      diff = newTextLength - textLength;\n      charsToInsert = this.hiddenTextarea.value.slice(start, start + diff);\n    }\n    else {\n      //we selected a portion of text and then input something else.\n      //Internet explorer does not trigger this else\n      diff = newTextLength - textLength + offsetEnd - offset;\n      charsToInsert = this.hiddenTextarea.value.slice(offset, offset + diff);\n    }\n    this.insertChars(charsToInsert);\n    e.stopPropagation();\n  },\n\n  /**\n   * Composition start\n   */\n  onCompositionStart: function() {\n    this.inCompositionMode = true;\n    this.prevCompositionLength = 0;\n    this.compositionStart = this.selectionStart;\n  },\n\n  /**\n   * Composition end\n   */\n  onCompositionEnd: function() {\n    this.inCompositionMode = false;\n  },\n\n  /**\n   * Composition update\n   */\n  onCompositionUpdate: function(e) {\n    var data = e.data;\n    this.selectionStart = this.compositionStart;\n    this.selectionEnd = this.selectionEnd === this.selectionStart ?\n      this.compositionStart + this.prevCompositionLength : this.selectionEnd;\n    this.insertChars(data, false);\n    this.prevCompositionLength = data.length;\n  },\n\n  /**\n   * Forward delete\n   */\n  forwardDelete: function(e) {\n    if (this.selectionStart === this.selectionEnd) {\n      if (this.selectionStart === this.text.length) {\n        return;\n      }\n      this.moveCursorRight(e);\n    }\n    this.removeChars(e);\n  },\n\n  /**\n   * Copies selected text\n   * @param {Event} e Event object\n   */\n  copy: function(e) {\n    if (this.selectionStart === this.selectionEnd) {\n      //do not cut-copy if no selection\n      return;\n    }\n    var selectedText = this.getSelectedText(),\n        clipboardData = this._getClipboardData(e);\n\n    // Check for backward compatibility with old browsers\n    if (clipboardData) {\n      clipboardData.setData('text', selectedText);\n    }\n\n    fabric.copiedText = selectedText;\n    fabric.copiedTextStyle = this.getSelectionStyles(\n                          this.selectionStart,\n                          this.selectionEnd);\n    e.stopImmediatePropagation();\n    e.preventDefault();\n    this._copyDone = true;\n  },\n\n  /**\n   * Pastes text\n   * @param {Event} e Event object\n   */\n  paste: function(e) {\n    var copiedText = null,\n        clipboardData = this._getClipboardData(e),\n        useCopiedStyle = true;\n\n    // Check for backward compatibility with old browsers\n    if (clipboardData) {\n      copiedText = clipboardData.getData('text').replace(/\\r/g, '');\n      if (!fabric.copiedTextStyle || fabric.copiedText !== copiedText) {\n        useCopiedStyle = false;\n      }\n    }\n    else {\n      copiedText = fabric.copiedText;\n    }\n\n    if (copiedText) {\n      this.insertChars(copiedText, useCopiedStyle);\n    }\n    e.stopImmediatePropagation();\n    e.preventDefault();\n  },\n\n  /**\n   * Cuts text\n   * @param {Event} e Event object\n   */\n  cut: function(e) {\n    if (this.selectionStart === this.selectionEnd) {\n      return;\n    }\n\n    this.copy(e);\n    this.removeChars(e);\n  },\n\n  /**\n   * @private\n   * @param {Event} e Event object\n   * @return {Object} Clipboard data object\n   */\n  _getClipboardData: function(e) {\n    return (e && e.clipboardData) || fabric.window.clipboardData;\n  },\n\n  /**\n   * Gets start offset of a selection\n   * @param {Event} e Event object\n   * @param {Boolean} isRight\n   * @return {Number}\n   */\n  getDownCursorOffset: function(e, isRight) {\n    var selectionProp = isRight ? this.selectionEnd : this.selectionStart,\n        cursorLocation = this.get2DCursorLocation(selectionProp),\n        _char, lineLeftOffset, lineIndex = cursorLocation.lineIndex,\n        textOnSameLineBeforeCursor = this._textLines[lineIndex].slice(0, cursorLocation.charIndex),\n        textOnSameLineAfterCursor = this._textLines[lineIndex].slice(cursorLocation.charIndex),\n        textOnNextLine = this._textLines[lineIndex + 1] || '';\n\n    // if on last line, down cursor goes to end of line\n    if (lineIndex === this._textLines.length - 1 || e.metaKey || e.keyCode === 34) {\n\n      // move to the end of a text\n      return this.text.length - selectionProp;\n    }\n\n    var widthOfSameLineBeforeCursor = this._getLineWidth(this.ctx, lineIndex);\n    lineLeftOffset = this._getLineLeftOffset(widthOfSameLineBeforeCursor);\n\n    var widthOfCharsOnSameLineBeforeCursor = lineLeftOffset;\n\n    for (var i = 0, len = textOnSameLineBeforeCursor.length; i < len; i++) {\n      _char = textOnSameLineBeforeCursor[i];\n      widthOfCharsOnSameLineBeforeCursor += this._getWidthOfChar(this.ctx, _char, lineIndex, i);\n    }\n\n    var indexOnNextLine = this._getIndexOnNextLine(\n      cursorLocation, textOnNextLine, widthOfCharsOnSameLineBeforeCursor);\n\n    return textOnSameLineAfterCursor.length + 1 + indexOnNextLine;\n  },\n\n  /**\n   * @private\n   */\n  _getIndexOnNextLine: function(cursorLocation, textOnNextLine, widthOfCharsOnSameLineBeforeCursor) {\n    var lineIndex = cursorLocation.lineIndex + 1,\n        widthOfNextLine = this._getLineWidth(this.ctx, lineIndex),\n        lineLeftOffset = this._getLineLeftOffset(widthOfNextLine),\n        widthOfCharsOnNextLine = lineLeftOffset,\n        indexOnNextLine = 0,\n        foundMatch;\n\n    for (var j = 0, jlen = textOnNextLine.length; j < jlen; j++) {\n\n      var _char = textOnNextLine[j],\n          widthOfChar = this._getWidthOfChar(this.ctx, _char, lineIndex, j);\n\n      widthOfCharsOnNextLine += widthOfChar;\n\n      if (widthOfCharsOnNextLine > widthOfCharsOnSameLineBeforeCursor) {\n\n        foundMatch = true;\n\n        var leftEdge = widthOfCharsOnNextLine - widthOfChar,\n            rightEdge = widthOfCharsOnNextLine,\n            offsetFromLeftEdge = Math.abs(leftEdge - widthOfCharsOnSameLineBeforeCursor),\n            offsetFromRightEdge = Math.abs(rightEdge - widthOfCharsOnSameLineBeforeCursor);\n\n        indexOnNextLine = offsetFromRightEdge < offsetFromLeftEdge ? j + 1 : j;\n\n        break;\n      }\n    }\n\n    // reached end\n    if (!foundMatch) {\n      indexOnNextLine = textOnNextLine.length;\n    }\n\n    return indexOnNextLine;\n  },\n\n  /**\n   * Moves cursor down\n   * @param {Event} e Event object\n   */\n  moveCursorDown: function(e) {\n    this.abortCursorAnimation();\n    this._currentCursorOpacity = 1;\n\n    var offset = this.getDownCursorOffset(e, this._selectionDirection === 'right');\n\n    if (e.shiftKey) {\n      this.moveCursorDownWithShift(offset);\n    }\n    else {\n      this.moveCursorDownWithoutShift(offset);\n    }\n\n    this.initDelayedCursor();\n  },\n\n  /**\n   * Moves cursor down without keeping selection\n   * @param {Number} offset\n   */\n  moveCursorDownWithoutShift: function(offset) {\n    this._selectionDirection = 'right';\n    this.setSelectionStart(this.selectionStart + offset);\n    this.setSelectionEnd(this.selectionStart);\n  },\n\n  /**\n   * private\n   */\n  swapSelectionPoints: function() {\n    var swapSel = this.selectionEnd;\n    this.setSelectionEnd(this.selectionStart);\n    this.setSelectionStart(swapSel);\n  },\n\n  /**\n   * Moves cursor down while keeping selection\n   * @param {Number} offset\n   */\n  moveCursorDownWithShift: function(offset) {\n    if (this.selectionEnd === this.selectionStart) {\n      this._selectionDirection = 'right';\n    }\n    if (this._selectionDirection === 'right') {\n      this.setSelectionEnd(this.selectionEnd + offset);\n    }\n    else {\n      this.setSelectionStart(this.selectionStart + offset);\n    }\n    if (this.selectionEnd < this.selectionStart  && this._selectionDirection === 'left') {\n      this.swapSelectionPoints();\n      this._selectionDirection = 'right';\n    }\n    if (this.selectionEnd > this.text.length) {\n      this.setSelectionEnd(this.text.length);\n    }\n  },\n\n  /**\n   * @param {Event} e Event object\n   * @param {Boolean} isRight\n   * @return {Number}\n   */\n  getUpCursorOffset: function(e, isRight) {\n    var selectionProp = isRight ? this.selectionEnd : this.selectionStart,\n        cursorLocation = this.get2DCursorLocation(selectionProp),\n        lineIndex = cursorLocation.lineIndex;\n    // if on first line, up cursor goes to start of line\n    if (lineIndex === 0 || e.metaKey || e.keyCode === 33) {\n      return selectionProp;\n    }\n\n    var textOnSameLineBeforeCursor = this._textLines[lineIndex].slice(0, cursorLocation.charIndex),\n        textOnPreviousLine = this._textLines[lineIndex - 1] || '',\n        _char,\n        widthOfSameLineBeforeCursor = this._getLineWidth(this.ctx, cursorLocation.lineIndex),\n        lineLeftOffset = this._getLineLeftOffset(widthOfSameLineBeforeCursor),\n        widthOfCharsOnSameLineBeforeCursor = lineLeftOffset;\n\n    for (var i = 0, len = textOnSameLineBeforeCursor.length; i < len; i++) {\n      _char = textOnSameLineBeforeCursor[i];\n      widthOfCharsOnSameLineBeforeCursor += this._getWidthOfChar(this.ctx, _char, lineIndex, i);\n    }\n\n    var indexOnPrevLine = this._getIndexOnPrevLine(\n      cursorLocation, textOnPreviousLine, widthOfCharsOnSameLineBeforeCursor);\n\n    return textOnPreviousLine.length - indexOnPrevLine + textOnSameLineBeforeCursor.length;\n  },\n\n  /**\n   * @private\n   */\n  _getIndexOnPrevLine: function(cursorLocation, textOnPreviousLine, widthOfCharsOnSameLineBeforeCursor) {\n\n    var lineIndex = cursorLocation.lineIndex - 1,\n        widthOfPreviousLine = this._getLineWidth(this.ctx, lineIndex),\n        lineLeftOffset = this._getLineLeftOffset(widthOfPreviousLine),\n        widthOfCharsOnPreviousLine = lineLeftOffset,\n        indexOnPrevLine = 0,\n        foundMatch;\n\n    for (var j = 0, jlen = textOnPreviousLine.length; j < jlen; j++) {\n\n      var _char = textOnPreviousLine[j],\n          widthOfChar = this._getWidthOfChar(this.ctx, _char, lineIndex, j);\n\n      widthOfCharsOnPreviousLine += widthOfChar;\n\n      if (widthOfCharsOnPreviousLine > widthOfCharsOnSameLineBeforeCursor) {\n\n        foundMatch = true;\n\n        var leftEdge = widthOfCharsOnPreviousLine - widthOfChar,\n            rightEdge = widthOfCharsOnPreviousLine,\n            offsetFromLeftEdge = Math.abs(leftEdge - widthOfCharsOnSameLineBeforeCursor),\n            offsetFromRightEdge = Math.abs(rightEdge - widthOfCharsOnSameLineBeforeCursor);\n\n        indexOnPrevLine = offsetFromRightEdge < offsetFromLeftEdge ? j : (j - 1);\n\n        break;\n      }\n    }\n\n    // reached end\n    if (!foundMatch) {\n      indexOnPrevLine = textOnPreviousLine.length - 1;\n    }\n\n    return indexOnPrevLine;\n  },\n\n  /**\n   * Moves cursor up\n   * @param {Event} e Event object\n   */\n  moveCursorUp: function(e) {\n\n    this.abortCursorAnimation();\n    this._currentCursorOpacity = 1;\n\n    var offset = this.getUpCursorOffset(e, this._selectionDirection === 'right');\n    if (e.shiftKey) {\n      this.moveCursorUpWithShift(offset);\n    }\n    else {\n      this.moveCursorUpWithoutShift(offset);\n    }\n\n    this.initDelayedCursor();\n  },\n\n  /**\n   * Moves cursor up with shift\n   * @param {Number} offset\n   */\n  moveCursorUpWithShift: function(offset) {\n    if (this.selectionEnd === this.selectionStart) {\n      this._selectionDirection = 'left';\n    }\n    if (this._selectionDirection === 'right') {\n      this.setSelectionEnd(this.selectionEnd - offset);\n    }\n    else {\n      this.setSelectionStart(this.selectionStart - offset);\n    }\n    if (this.selectionEnd < this.selectionStart && this._selectionDirection === 'right') {\n      this.swapSelectionPoints();\n      this._selectionDirection = 'left';\n    }\n  },\n\n  /**\n   * Moves cursor up without shift\n   * @param {Number} offset\n   */\n  moveCursorUpWithoutShift: function(offset) {\n    if (this.selectionStart === this.selectionEnd) {\n      this.setSelectionStart(this.selectionStart - offset);\n    }\n    this.setSelectionEnd(this.selectionStart);\n\n    this._selectionDirection = 'left';\n  },\n\n  /**\n   * Moves cursor left\n   * @param {Event} e Event object\n   */\n  moveCursorLeft: function(e) {\n    if (this.selectionStart === 0 && this.selectionEnd === 0) {\n      return;\n    }\n\n    this.abortCursorAnimation();\n    this._currentCursorOpacity = 1;\n\n    if (e.shiftKey) {\n      this.moveCursorLeftWithShift(e);\n    }\n    else {\n      this.moveCursorLeftWithoutShift(e);\n    }\n\n    this.initDelayedCursor();\n  },\n\n  /**\n   * @private\n   */\n  _move: function(e, prop, direction) {\n    var propMethod = (prop === 'selectionStart' ? 'setSelectionStart' : 'setSelectionEnd');\n    if (e.altKey) {\n      this[propMethod](this['findWordBoundary' + direction](this[prop]));\n    }\n    else if (e.metaKey || e.keyCode === 35 ||  e.keyCode === 36 ) {\n      this[propMethod](this['findLineBoundary' + direction](this[prop]));\n    }\n    else {\n      this[propMethod](this[prop] + (direction === 'Left' ? -1 : 1));\n    }\n  },\n\n  /**\n   * @private\n   */\n  _moveLeft: function(e, prop) {\n    this._move(e, prop, 'Left');\n  },\n\n  /**\n   * @private\n   */\n  _moveRight: function(e, prop) {\n    this._move(e, prop, 'Right');\n  },\n\n  /**\n   * Moves cursor left without keeping selection\n   * @param {Event} e\n   */\n  moveCursorLeftWithoutShift: function(e) {\n    this._selectionDirection = 'left';\n\n    // only move cursor when there is no selection,\n    // otherwise we discard it, and leave cursor on same place\n    if (this.selectionEnd === this.selectionStart) {\n      this._moveLeft(e, 'selectionStart');\n    }\n    this.setSelectionEnd(this.selectionStart);\n  },\n\n  /**\n   * Moves cursor left while keeping selection\n   * @param {Event} e\n   */\n  moveCursorLeftWithShift: function(e) {\n    if (this._selectionDirection === 'right' && this.selectionStart !== this.selectionEnd) {\n      this._moveLeft(e, 'selectionEnd');\n    }\n    else {\n      this._selectionDirection = 'left';\n      this._moveLeft(e, 'selectionStart');\n    }\n  },\n\n  /**\n   * Moves cursor right\n   * @param {Event} e Event object\n   */\n  moveCursorRight: function(e) {\n    if (this.selectionStart >= this.text.length && this.selectionEnd >= this.text.length) {\n      return;\n    }\n\n    this.abortCursorAnimation();\n    this._currentCursorOpacity = 1;\n\n    if (e.shiftKey) {\n      this.moveCursorRightWithShift(e);\n    }\n    else {\n      this.moveCursorRightWithoutShift(e);\n    }\n\n    this.initDelayedCursor();\n  },\n\n  /**\n   * Moves cursor right while keeping selection\n   * @param {Event} e\n   */\n  moveCursorRightWithShift: function(e) {\n    if (this._selectionDirection === 'left' && this.selectionStart !== this.selectionEnd) {\n      this._moveRight(e, 'selectionStart');\n    }\n    else {\n      this._selectionDirection = 'right';\n      this._moveRight(e, 'selectionEnd');\n    }\n  },\n\n  /**\n   * Moves cursor right without keeping selection\n   * @param {Event} e Event object\n   */\n  moveCursorRightWithoutShift: function(e) {\n    this._selectionDirection = 'right';\n\n    if (this.selectionStart === this.selectionEnd) {\n      this._moveRight(e, 'selectionStart');\n      this.setSelectionEnd(this.selectionStart);\n    }\n    else {\n      this.setSelectionEnd(this.selectionEnd + this.getNumNewLinesInSelectedText());\n      this.setSelectionStart(this.selectionEnd);\n    }\n  },\n\n  /**\n   * Removes characters selected by selection\n   * @param {Event} e Event object\n   */\n  removeChars: function(e) {\n    if (this.selectionStart === this.selectionEnd) {\n      this._removeCharsNearCursor(e);\n    }\n    else {\n      this._removeCharsFromTo(this.selectionStart, this.selectionEnd);\n    }\n\n    this.setSelectionEnd(this.selectionStart);\n\n    this._removeExtraneousStyles();\n\n    this.canvas && this.canvas.renderAll();\n\n    this.setCoords();\n    this.fire('changed');\n    this.canvas && this.canvas.fire('text:changed', { target: this });\n  },\n\n  /**\n   * @private\n   * @param {Event} e Event object\n   */\n  _removeCharsNearCursor: function(e) {\n    if (this.selectionStart === 0) {\n      return;\n    }\n    if (e.metaKey) {\n      // remove all till the start of current line\n      var leftLineBoundary = this.findLineBoundaryLeft(this.selectionStart);\n\n      this._removeCharsFromTo(leftLineBoundary, this.selectionStart);\n      this.setSelectionStart(leftLineBoundary);\n    }\n    else if (e.altKey) {\n      // remove all till the start of current word\n      var leftWordBoundary = this.findWordBoundaryLeft(this.selectionStart);\n\n      this._removeCharsFromTo(leftWordBoundary, this.selectionStart);\n      this.setSelectionStart(leftWordBoundary);\n    }\n    else {\n      this._removeSingleCharAndStyle(this.selectionStart);\n      this.setSelectionStart(this.selectionStart - 1);\n    }\n  }\n});\n\n\n/* _TO_SVG_START_ */\n(function() {\n  var toFixed = fabric.util.toFixed,\n      NUM_FRACTION_DIGITS = fabric.Object.NUM_FRACTION_DIGITS;\n\n  fabric.util.object.extend(fabric.IText.prototype, /** @lends fabric.IText.prototype */ {\n\n    /**\n     * @private\n     */\n    _setSVGTextLineText: function(lineIndex, textSpans, height, textLeftOffset, textTopOffset, textBgRects) {\n      if (!this._getLineStyle(lineIndex)) {\n        fabric.Text.prototype._setSVGTextLineText.call(this,\n          lineIndex, textSpans, height, textLeftOffset, textTopOffset);\n      }\n      else {\n        this._setSVGTextLineChars(\n          lineIndex, textSpans, height, textLeftOffset, textBgRects);\n      }\n    },\n\n    /**\n     * @private\n     */\n    _setSVGTextLineChars: function(lineIndex, textSpans, height, textLeftOffset, textBgRects) {\n\n      var chars = this._textLines[lineIndex],\n          charOffset = 0,\n          lineLeftOffset = this._getLineLeftOffset(this._getLineWidth(this.ctx, lineIndex)) - this.width / 2,\n          lineOffset = this._getSVGLineTopOffset(lineIndex),\n          heightOfLine = this._getHeightOfLine(this.ctx, lineIndex);\n\n      for (var i = 0, len = chars.length; i < len; i++) {\n        var styleDecl = this._getStyleDeclaration(lineIndex, i) || { };\n\n        textSpans.push(\n          this._createTextCharSpan(\n            chars[i], styleDecl, lineLeftOffset, lineOffset.lineTop + lineOffset.offset, charOffset));\n\n        var charWidth = this._getWidthOfChar(this.ctx, chars[i], lineIndex, i);\n\n        if (styleDecl.textBackgroundColor) {\n          textBgRects.push(\n            this._createTextCharBg(\n              styleDecl, lineLeftOffset, lineOffset.lineTop, heightOfLine, charWidth, charOffset));\n        }\n\n        charOffset += charWidth;\n      }\n    },\n\n    /**\n     * @private\n     */\n    _getSVGLineTopOffset: function(lineIndex) {\n      var lineTopOffset = 0, lastHeight = 0;\n      for (var j = 0; j < lineIndex; j++) {\n        lineTopOffset += this._getHeightOfLine(this.ctx, j);\n      }\n      lastHeight = this._getHeightOfLine(this.ctx, j);\n      return {\n        lineTop: lineTopOffset,\n        offset: (this._fontSizeMult - this._fontSizeFraction) * lastHeight / (this.lineHeight * this._fontSizeMult)\n      };\n    },\n\n    /**\n     * @private\n     */\n    _createTextCharBg: function(styleDecl, lineLeftOffset, lineTopOffset, heightOfLine, charWidth, charOffset) {\n      return [\n        //jscs:disable validateIndentation\n        '\\t\\t<rect fill=\"', styleDecl.textBackgroundColor,\n        '\" x=\"', toFixed(lineLeftOffset + charOffset, NUM_FRACTION_DIGITS),\n        '\" y=\"', toFixed(lineTopOffset - this.height/2, NUM_FRACTION_DIGITS),\n        '\" width=\"', toFixed(charWidth, NUM_FRACTION_DIGITS),\n        '\" height=\"', toFixed(heightOfLine / this.lineHeight, NUM_FRACTION_DIGITS),\n        '\"></rect>\\n'\n        //jscs:enable validateIndentation\n      ].join('');\n    },\n\n    /**\n     * @private\n     */\n    _createTextCharSpan: function(_char, styleDecl, lineLeftOffset, lineTopOffset, charOffset) {\n\n      var fillStyles = this.getSvgStyles.call(fabric.util.object.extend({\n        visible: true,\n        fill: this.fill,\n        stroke: this.stroke,\n        type: 'text',\n        getSvgFilter: fabric.Object.prototype.getSvgFilter\n      }, styleDecl));\n\n      return [\n        //jscs:disable validateIndentation\n        '\\t\\t\\t<tspan x=\"', toFixed(lineLeftOffset + charOffset, NUM_FRACTION_DIGITS), '\" y=\"',\n          toFixed(lineTopOffset - this.height/2, NUM_FRACTION_DIGITS), '\" ',\n          (styleDecl.fontFamily ? 'font-family=\"' + styleDecl.fontFamily.replace(/\"/g, '\\'') + '\" ': ''),\n          (styleDecl.fontSize ? 'font-size=\"' + styleDecl.fontSize + '\" ': ''),\n          (styleDecl.fontStyle ? 'font-style=\"' + styleDecl.fontStyle + '\" ': ''),\n          (styleDecl.fontWeight ? 'font-weight=\"' + styleDecl.fontWeight + '\" ': ''),\n          (styleDecl.textDecoration ? 'text-decoration=\"' + styleDecl.textDecoration + '\" ': ''),\n          'style=\"', fillStyles, '\">',\n          fabric.util.string.escapeXml(_char),\n        '</tspan>\\n'\n        //jscs:enable validateIndentation\n      ].join('');\n    }\n  });\n})();\n/* _TO_SVG_END_ */\n\n\n(function(global) {\n\n  'use strict';\n\n  var fabric = global.fabric || (global.fabric = {}),\n      clone  = fabric.util.object.clone;\n\n  /**\n   * Textbox class, based on IText, allows the user to resize the text rectangle\n   * and wraps lines automatically. Textboxes have their Y scaling locked, the\n   * user can only change width. Height is adjusted automatically based on the\n   * wrapping of lines.\n   * @class fabric.Textbox\n   * @extends fabric.IText\n   * @mixes fabric.Observable\n   * @return {fabric.Textbox} thisArg\n   * @see {@link fabric.Textbox#initialize} for constructor definition\n   */\n  fabric.Textbox = fabric.util.createClass(fabric.IText, fabric.Observable, {\n\n    /**\n     * Type of an object\n     * @type String\n     * @default\n     */\n    type: 'textbox',\n\n    /**\n     * Minimum width of textbox, in pixels.\n     * @type Number\n     * @default\n     */\n    minWidth: 20,\n\n    /**\n     * Minimum calculated width of a textbox, in pixels.\n     * @type Number\n     * @default\n     */\n    dynamicMinWidth: 0,\n\n    /**\n     * Cached array of text wrapping.\n     * @type Array\n     */\n    __cachedLines: null,\n\n    /**\n     * Override standard Object class values\n     */\n    lockScalingY: true,\n\n    /**\n     * Override standard Object class values\n     */\n    lockScalingFlip: true,\n\n    /**\n     * Constructor. Some scaling related property values are forced. Visibility\n     * of controls is also fixed; only the rotation and width controls are\n     * made available.\n     * @param {String} text Text string\n     * @param {Object} [options] Options object\n     * @return {fabric.Textbox} thisArg\n     */\n    initialize: function(text, options) {\n      this.ctx = fabric.util.createCanvasElement().getContext('2d');\n      this.callSuper('initialize', text, options);\n      this.setControlsVisibility(fabric.Textbox.getTextboxControlVisibility());\n\n      // add width to this list of props that effect line wrapping.\n      this._dimensionAffectingProps.width = true;\n    },\n\n    /**\n     * Unlike superclass's version of this function, Textbox does not update\n     * its width.\n     * @param {CanvasRenderingContext2D} ctx Context to use for measurements\n     * @private\n     * @override\n     */\n    _initDimensions: function(ctx) {\n      if (this.__skipDimension) {\n        return;\n      }\n\n      if (!ctx) {\n        ctx = fabric.util.createCanvasElement().getContext('2d');\n        this._setTextStyles(ctx);\n      }\n\n      // clear dynamicMinWidth as it will be different after we re-wrap line\n      this.dynamicMinWidth = 0;\n\n      // wrap lines\n      this._textLines = this._splitTextIntoLines();\n\n      // if after wrapping, the width is smaller than dynamicMinWidth, change the width and re-wrap\n      if (this.dynamicMinWidth > this.width) {\n        this._set('width', this.dynamicMinWidth);\n      }\n\n      // clear cache and re-calculate height\n      this._clearCache();\n      this.height = this._getTextHeight(ctx);\n    },\n\n    /**\n     * Generate an object that translates the style object so that it is\n     * broken up by visual lines (new lines and automatic wrapping).\n     * The original text styles object is broken up by actual lines (new lines only),\n     * which is only sufficient for Text / IText\n     * @private\n     */\n    _generateStyleMap: function() {\n      var realLineCount     = 0,\n          realLineCharCount = 0,\n          charCount         = 0,\n          map               = {};\n\n      for (var i = 0; i < this._textLines.length; i++) {\n        if (this.text[charCount] === '\\n') {\n          realLineCharCount = 0;\n          charCount++;\n          realLineCount++;\n        }\n        else if (this.text[charCount] === ' ') {\n          // this case deals with space's that are removed from end of lines when wrapping\n          realLineCharCount++;\n          charCount++;\n        }\n\n        map[i] = { line: realLineCount, offset: realLineCharCount };\n\n        charCount += this._textLines[i].length;\n        realLineCharCount += this._textLines[i].length;\n      }\n\n      return map;\n    },\n\n    /**\n     * @param {Number} lineIndex\n     * @param {Number} charIndex\n     * @param {Boolean} [returnCloneOrEmpty=false]\n     * @private\n     */\n    _getStyleDeclaration: function(lineIndex, charIndex, returnCloneOrEmpty) {\n      if (this._styleMap) {\n        var map = this._styleMap[lineIndex];\n        if (!map) {\n          return returnCloneOrEmpty ? { } : null;\n        }\n        lineIndex = map.line;\n        charIndex = map.offset + charIndex;\n      }\n      return this.callSuper('_getStyleDeclaration', lineIndex, charIndex, returnCloneOrEmpty);\n    },\n\n    /**\n     * @param {Number} lineIndex\n     * @param {Number} charIndex\n     * @param {Object} style\n     * @private\n     */\n    _setStyleDeclaration: function(lineIndex, charIndex, style) {\n      var map = this._styleMap[lineIndex];\n      lineIndex = map.line;\n      charIndex = map.offset + charIndex;\n\n      this.styles[lineIndex][charIndex] = style;\n    },\n\n    /**\n     * @param {Number} lineIndex\n     * @param {Number} charIndex\n     * @private\n     */\n    _deleteStyleDeclaration: function(lineIndex, charIndex) {\n      var map = this._styleMap[lineIndex];\n      lineIndex = map.line;\n      charIndex = map.offset + charIndex;\n\n      delete this.styles[lineIndex][charIndex];\n    },\n\n    /**\n     * @param {Number} lineIndex\n     * @private\n     */\n    _getLineStyle: function(lineIndex) {\n      var map = this._styleMap[lineIndex];\n      return this.styles[map.line];\n    },\n\n    /**\n     * @param {Number} lineIndex\n     * @param {Object} style\n     * @private\n     */\n    _setLineStyle: function(lineIndex, style) {\n      var map = this._styleMap[lineIndex];\n      this.styles[map.line] = style;\n    },\n\n    /**\n     * @param {Number} lineIndex\n     * @private\n     */\n    _deleteLineStyle: function(lineIndex) {\n      var map = this._styleMap[lineIndex];\n      delete this.styles[map.line];\n    },\n\n    /**\n     * Wraps text using the 'width' property of Textbox. First this function\n     * splits text on newlines, so we preserve newlines entered by the user.\n     * Then it wraps each line using the width of the Textbox by calling\n     * _wrapLine().\n     * @param {CanvasRenderingContext2D} ctx Context to use for measurements\n     * @param {String} text The string of text that is split into lines\n     * @returns {Array} Array of lines\n     */\n    _wrapText: function(ctx, text) {\n      var lines = text.split(this._reNewline), wrapped = [], i;\n\n      for (i = 0; i < lines.length; i++) {\n        wrapped = wrapped.concat(this._wrapLine(ctx, lines[i], i));\n      }\n\n      return wrapped;\n    },\n\n    /**\n     * Helper function to measure a string of text, given its lineIndex and charIndex offset\n     *\n     * @param {CanvasRenderingContext2D} ctx\n     * @param {String} text\n     * @param {number} lineIndex\n     * @param {number} charOffset\n     * @returns {number}\n     * @private\n     */\n    _measureText: function(ctx, text, lineIndex, charOffset) {\n      var width = 0;\n      charOffset = charOffset || 0;\n\n      for (var i = 0, len = text.length; i < len; i++) {\n        width += this._getWidthOfChar(ctx, text[i], lineIndex, i + charOffset);\n      }\n\n      return width;\n    },\n\n    /**\n     * Wraps a line of text using the width of the Textbox and a context.\n     * @param {CanvasRenderingContext2D} ctx Context to use for measurements\n     * @param {String} text The string of text to split into lines\n     * @param {Number} lineIndex\n     * @returns {Array} Array of line(s) into which the given text is wrapped\n     * to.\n     */\n    _wrapLine: function(ctx, text, lineIndex) {\n      var lineWidth        = 0,\n          lines            = [],\n          line             = '',\n          words            = text.split(' '),\n          word             = '',\n          offset           = 0,\n          infix            = ' ',\n          wordWidth        = 0,\n          infixWidth       = 0,\n          largestWordWidth = 0,\n          lineJustStarted = true;\n\n      for (var i = 0; i < words.length; i++) {\n        word = words[i];\n        wordWidth = this._measureText(ctx, word, lineIndex, offset);\n\n        offset += word.length;\n\n        lineWidth += infixWidth + wordWidth;\n\n        if (lineWidth >= this.width && !lineJustStarted) {\n          lines.push(line);\n          line = '';\n          lineWidth = wordWidth;\n          lineJustStarted = true;\n        }\n\n        if (!lineJustStarted) {\n          line += infix;\n        }\n        line += word;\n\n        infixWidth = this._measureText(ctx, infix, lineIndex, offset);\n        offset++;\n        lineJustStarted = false;\n        // keep track of largest word\n        if (wordWidth > largestWordWidth) {\n          largestWordWidth = wordWidth;\n        }\n      }\n\n      i && lines.push(line);\n\n      if (largestWordWidth > this.dynamicMinWidth) {\n        this.dynamicMinWidth = largestWordWidth;\n      }\n\n      return lines;\n    },\n    /**\n     * Gets lines of text to render in the Textbox. This function calculates\n     * text wrapping on the fly everytime it is called.\n     * @returns {Array} Array of lines in the Textbox.\n     * @override\n     */\n    _splitTextIntoLines: function() {\n      var originalAlign = this.textAlign;\n      this.ctx.save();\n      this._setTextStyles(this.ctx);\n      this.textAlign = 'left';\n      var lines = this._wrapText(this.ctx, this.text);\n      this.textAlign = originalAlign;\n      this.ctx.restore();\n      this._textLines = lines;\n      this._styleMap = this._generateStyleMap();\n      return lines;\n    },\n\n    /**\n     * When part of a group, we don't want the Textbox's scale to increase if\n     * the group's increases. That's why we reduce the scale of the Textbox by\n     * the amount that the group's increases. This is to maintain the effective\n     * scale of the Textbox at 1, so that font-size values make sense. Otherwise\n     * the same font-size value would result in different actual size depending\n     * on the value of the scale.\n     * @param {String} key\n     * @param {Any} value\n     */\n    setOnGroup: function(key, value) {\n      if (key === 'scaleX') {\n        this.set('scaleX', Math.abs(1 / value));\n        this.set('width', (this.get('width') * value) /\n          (typeof this.__oldScaleX === 'undefined' ? 1 : this.__oldScaleX));\n        this.__oldScaleX = value;\n      }\n    },\n\n    /**\n     * Returns 2d representation (lineIndex and charIndex) of cursor (or selection start).\n     * Overrides the superclass function to take into account text wrapping.\n     *\n     * @param {Number} [selectionStart] Optional index. When not given, current selectionStart is used.\n     */\n    get2DCursorLocation: function(selectionStart) {\n      if (typeof selectionStart === 'undefined') {\n        selectionStart = this.selectionStart;\n      }\n\n      var numLines = this._textLines.length,\n          removed  = 0;\n\n      for (var i = 0; i < numLines; i++) {\n        var line    = this._textLines[i],\n            lineLen = line.length;\n\n        if (selectionStart <= removed + lineLen) {\n          return {\n            lineIndex: i,\n            charIndex: selectionStart - removed\n          };\n        }\n\n        removed += lineLen;\n\n        if (this.text[removed] === '\\n' || this.text[removed] === ' ') {\n          removed++;\n        }\n      }\n\n      return {\n        lineIndex: numLines - 1,\n        charIndex: this._textLines[numLines - 1].length\n      };\n    },\n\n    /**\n     * Overrides superclass function and uses text wrapping data to get cursor\n     * boundary offsets instead of the array of chars.\n     * @param {Array} chars Unused\n     * @param {String} typeOfBoundaries Can be 'cursor' or 'selection'\n     * @returns {Object} Object with 'top', 'left', and 'lineLeft' properties set.\n     */\n    _getCursorBoundariesOffsets: function(chars, typeOfBoundaries) {\n      var topOffset      = 0,\n          leftOffset     = 0,\n          cursorLocation = this.get2DCursorLocation(),\n          lineChars      = this._textLines[cursorLocation.lineIndex].split(''),\n          lineLeftOffset = this._getLineLeftOffset(this._getLineWidth(this.ctx, cursorLocation.lineIndex));\n\n      for (var i = 0; i < cursorLocation.charIndex; i++) {\n        leftOffset += this._getWidthOfChar(this.ctx, lineChars[i], cursorLocation.lineIndex, i);\n      }\n\n      for (i = 0; i < cursorLocation.lineIndex; i++) {\n        topOffset += this._getHeightOfLine(this.ctx, i);\n      }\n\n      if (typeOfBoundaries === 'cursor') {\n        topOffset += (1 - this._fontSizeFraction) * this._getHeightOfLine(this.ctx, cursorLocation.lineIndex)\n          / this.lineHeight - this.getCurrentCharFontSize(cursorLocation.lineIndex, cursorLocation.charIndex)\n          * (1 - this._fontSizeFraction);\n      }\n\n      return {\n        top: topOffset,\n        left: leftOffset,\n        lineLeft: lineLeftOffset\n      };\n    },\n\n    getMinWidth: function() {\n      return Math.max(this.minWidth, this.dynamicMinWidth);\n    },\n\n    /**\n     * Returns object representation of an instance\n     * @method toObject\n     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output\n     * @return {Object} object representation of an instance\n     */\n    toObject: function(propertiesToInclude) {\n      return fabric.util.object.extend(this.callSuper('toObject', propertiesToInclude), {\n        minWidth: this.minWidth\n      });\n    }\n  });\n  /**\n   * Returns fabric.Textbox instance from an object representation\n   * @static\n   * @memberOf fabric.Textbox\n   * @param {Object} object Object to create an instance from\n   * @return {fabric.Textbox} instance of fabric.Textbox\n   */\n  fabric.Textbox.fromObject = function(object) {\n    return new fabric.Textbox(object.text, clone(object));\n  };\n  /**\n   * Returns the default controls visibility required for Textboxes.\n   * @returns {Object}\n   */\n  fabric.Textbox.getTextboxControlVisibility = function() {\n    return {\n      tl: false,\n      tr: false,\n      br: false,\n      bl: false,\n      ml: true,\n      mt: false,\n      mr: true,\n      mb: false,\n      mtr: true\n    };\n  };\n  /**\n   * Contains all fabric.Textbox objects that have been created\n   * @static\n   * @memberOf fabric.Textbox\n   * @type Array\n   */\n  fabric.Textbox.instances = [];\n})(typeof exports !== 'undefined' ? exports : this);\n\n\n(function() {\n\n  /**\n   * Override _setObjectScale and add Textbox specific resizing behavior. Resizing\n   * a Textbox doesn't scale text, it only changes width and makes text wrap automatically.\n   */\n  var setObjectScaleOverridden = fabric.Canvas.prototype._setObjectScale;\n\n  fabric.Canvas.prototype._setObjectScale = function(localMouse, transform,\n                                                     lockScalingX, lockScalingY, by, lockScalingFlip, _dim) {\n\n    var t = transform.target;\n    if (t instanceof fabric.Textbox) {\n      var w = t.width * ((localMouse.x / transform.scaleX) / (t.width + t.strokeWidth));\n      if (w >= t.getMinWidth()) {\n        t.set('width', w);\n        return true;\n      }\n    }\n    else {\n      return setObjectScaleOverridden.call(fabric.Canvas.prototype, localMouse, transform,\n        lockScalingX, lockScalingY, by, lockScalingFlip, _dim);\n    }\n  };\n\n  /**\n   * Sets controls of this group to the Textbox's special configuration if\n   * one is present in the group. Deletes _controlsVisibility otherwise, so that\n   * it gets initialized to default value at runtime.\n   */\n  fabric.Group.prototype._refreshControlsVisibility = function() {\n    if (typeof fabric.Textbox === 'undefined') {\n      return;\n    }\n    for (var i = this._objects.length; i--;) {\n      if (this._objects[i] instanceof fabric.Textbox) {\n        this.setControlsVisibility(fabric.Textbox.getTextboxControlVisibility());\n        return;\n      }\n    }\n  };\n\n  var clone = fabric.util.object.clone;\n\n  fabric.util.object.extend(fabric.Textbox.prototype, /** @lends fabric.IText.prototype */ {\n    /**\n     * @private\n     */\n    _removeExtraneousStyles: function() {\n      for (var prop in this._styleMap) {\n        if (!this._textLines[prop]) {\n          delete this.styles[this._styleMap[prop].line];\n        }\n      }\n    },\n\n    /**\n     * Inserts style object for a given line/char index\n     * @param {Number} lineIndex Index of a line\n     * @param {Number} charIndex Index of a char\n     * @param {Object} [style] Style object to insert, if given\n     */\n    insertCharStyleObject: function(lineIndex, charIndex, style) {\n      // adjust lineIndex and charIndex\n      var map = this._styleMap[lineIndex];\n      lineIndex = map.line;\n      charIndex = map.offset + charIndex;\n\n      fabric.IText.prototype.insertCharStyleObject.apply(this, [lineIndex, charIndex, style]);\n    },\n\n    /**\n     * Inserts new style object\n     * @param {Number} lineIndex Index of a line\n     * @param {Number} charIndex Index of a char\n     * @param {Boolean} isEndOfLine True if it's end of line\n     */\n    insertNewlineStyleObject: function(lineIndex, charIndex, isEndOfLine) {\n      // adjust lineIndex and charIndex\n      var map = this._styleMap[lineIndex];\n      lineIndex = map.line;\n      charIndex = map.offset + charIndex;\n\n      fabric.IText.prototype.insertNewlineStyleObject.apply(this, [lineIndex, charIndex, isEndOfLine]);\n    },\n\n    /**\n     * Shifts line styles up or down. This function is slightly different than the one in\n     * itext_behaviour as it takes into account the styleMap.\n     *\n     * @param {Number} lineIndex Index of a line\n     * @param {Number} offset Can be -1 or +1\n     */\n    shiftLineStyles: function(lineIndex, offset) {\n      // shift all line styles by 1 upward\n      var clonedStyles = clone(this.styles),\n          map          = this._styleMap[lineIndex];\n\n      // adjust line index\n      lineIndex = map.line;\n\n      for (var line in this.styles) {\n        var numericLine = parseInt(line, 10);\n\n        if (numericLine > lineIndex) {\n          this.styles[numericLine + offset] = clonedStyles[numericLine];\n\n          if (!clonedStyles[numericLine - offset]) {\n            delete this.styles[numericLine];\n          }\n        }\n      }\n      //TODO: evaluate if delete old style lines with offset -1\n    },\n\n    /**\n     * Figure out programatically the text on previous actual line (actual = separated by \\n);\n     *\n     * @param {Number} lIndex\n     * @returns {String}\n     * @private\n     */\n    _getTextOnPreviousLine: function(lIndex) {\n      var textOnPreviousLine = this._textLines[lIndex - 1];\n\n      while (this._styleMap[lIndex - 2] && this._styleMap[lIndex - 2].line === this._styleMap[lIndex - 1].line) {\n        textOnPreviousLine = this._textLines[lIndex - 2] + textOnPreviousLine;\n\n        lIndex--;\n      }\n\n      return textOnPreviousLine;\n    },\n\n    /**\n     * Removes style object\n     * @param {Boolean} isBeginningOfLine True if cursor is at the beginning of line\n     * @param {Number} [index] Optional index. When not given, current selectionStart is used.\n     */\n    removeStyleObject: function(isBeginningOfLine, index) {\n\n      var cursorLocation = this.get2DCursorLocation(index),\n          map            = this._styleMap[cursorLocation.lineIndex],\n          lineIndex      = map.line,\n          charIndex      = map.offset + cursorLocation.charIndex;\n      this._removeStyleObject(isBeginningOfLine, cursorLocation, lineIndex, charIndex);\n    }\n  });\n})();\n\n\n(function() {\n  var override = fabric.IText.prototype._getNewSelectionStartFromOffset;\n  /**\n   * Overrides the IText implementation and adjusts character index as there is not always a linebreak\n   *\n   * @param {Number} mouseOffset\n   * @param {Number} prevWidth\n   * @param {Number} width\n   * @param {Number} index\n   * @param {Number} jlen\n   * @returns {Number}\n   */\n  fabric.IText.prototype._getNewSelectionStartFromOffset = function(mouseOffset, prevWidth, width, index, jlen) {\n    index = override.call(this, mouseOffset, prevWidth, width, index, jlen);\n\n    // the index passed into the function is padded by the amount of lines from _textLines (to account for \\n)\n    // we need to remove this padding, and pad it by actual lines, and / or spaces that are meant to be there\n    var tmp     = 0,\n        removed = 0;\n\n    // account for removed characters\n    for (var i = 0; i < this._textLines.length; i++) {\n      tmp += this._textLines[i].length;\n\n      if (tmp + removed >= index) {\n        break;\n      }\n\n      if (this.text[tmp + removed] === '\\n' || this.text[tmp + removed] === ' ') {\n        removed++;\n      }\n    }\n\n    return index - i + removed;\n  };\n})();\n\n\n(function() {\n\n  if (typeof document !== 'undefined' && typeof window !== 'undefined') {\n    return;\n  }\n\n  var DOMParser = require('xmldom').DOMParser,\n      URL = require('url'),\n      HTTP = require('http'),\n      HTTPS = require('https'),\n\n      Canvas = require('canvas'),\n      Image = require('canvas').Image;\n\n  /** @private */\n  function request(url, encoding, callback) {\n    var oURL = URL.parse(url);\n\n    // detect if http or https is used\n    if ( !oURL.port ) {\n      oURL.port = ( oURL.protocol.indexOf('https:') === 0 ) ? 443 : 80;\n    }\n\n    // assign request handler based on protocol\n    var reqHandler = (oURL.protocol.indexOf('https:') === 0 ) ? HTTPS : HTTP,\n        req = reqHandler.request({\n          hostname: oURL.hostname,\n          port: oURL.port,\n          path: oURL.path,\n          method: 'GET'\n        }, function(response) {\n          var body = '';\n          if (encoding) {\n            response.setEncoding(encoding);\n          }\n          response.on('end', function () {\n            callback(body);\n          });\n          response.on('data', function (chunk) {\n            if (response.statusCode === 200) {\n              body += chunk;\n            }\n          });\n        });\n\n    req.on('error', function(err) {\n      if (err.errno === process.ECONNREFUSED) {\n        fabric.log('ECONNREFUSED: connection refused to ' + oURL.hostname + ':' + oURL.port);\n      }\n      else {\n        fabric.log(err.message);\n      }\n      callback(null);\n    });\n\n    req.end();\n  }\n\n  /** @private */\n  function requestFs(path, callback) {\n    var fs = require('fs');\n    fs.readFile(path, function (err, data) {\n      if (err) {\n        fabric.log(err);\n        throw err;\n      }\n      else {\n        callback(data);\n      }\n    });\n  }\n\n  fabric.util.loadImage = function(url, callback, context) {\n    function createImageAndCallBack(data) {\n      if (data) {\n        img.src = new Buffer(data, 'binary');\n        // preserving original url, which seems to be lost in node-canvas\n        img._src = url;\n        callback && callback.call(context, img);\n      }\n      else {\n        img = null;\n        callback && callback.call(context, null, true);\n      }\n    }\n    var img = new Image();\n    if (url && (url instanceof Buffer || url.indexOf('data') === 0)) {\n      img.src = img._src = url;\n      callback && callback.call(context, img);\n    }\n    else if (url && url.indexOf('http') !== 0) {\n      requestFs(url, createImageAndCallBack);\n    }\n    else if (url) {\n      request(url, 'binary', createImageAndCallBack);\n    }\n    else {\n      callback && callback.call(context, url);\n    }\n  };\n\n  fabric.loadSVGFromURL = function(url, callback, reviver) {\n    url = url.replace(/^\\n\\s*/, '').replace(/\\?.*$/, '').trim();\n    if (url.indexOf('http') !== 0) {\n      requestFs(url, function(body) {\n        fabric.loadSVGFromString(body.toString(), callback, reviver);\n      });\n    }\n    else {\n      request(url, '', function(body) {\n        fabric.loadSVGFromString(body, callback, reviver);\n      });\n    }\n  };\n\n  fabric.loadSVGFromString = function(string, callback, reviver) {\n    var doc = new DOMParser().parseFromString(string);\n    fabric.parseSVGDocument(doc.documentElement, function(results, options) {\n      callback && callback(results, options);\n    }, reviver);\n  };\n\n  fabric.util.getScript = function(url, callback) {\n    request(url, '', function(body) {\n      eval(body);\n      callback && callback();\n    });\n  };\n\n  fabric.Image.fromObject = function(object, callback) {\n    fabric.util.loadImage(object.src, function(img) {\n      var oImg = new fabric.Image(img);\n\n      oImg._initConfig(object);\n      oImg._initFilters(object.filters, function(filters) {\n        oImg.filters = filters || [ ];\n        oImg._initFilters(object.resizeFilters, function(resizeFilters) {\n          oImg.resizeFilters = resizeFilters || [ ];\n          callback && callback(oImg);\n        });\n      });\n    });\n  };\n  /**\n   * Only available when running fabric on node.js\n   * @param {Number} width Canvas width\n   * @param {Number} height Canvas height\n   * @param {Object} [options] Options to pass to FabricCanvas.\n   * @param {Object} [nodeCanvasOptions] Options to pass to NodeCanvas.\n   * @return {Object} wrapped canvas instance\n   */\n  fabric.createCanvasForNode = function(width, height, options, nodeCanvasOptions) {\n    nodeCanvasOptions = nodeCanvasOptions || options;\n\n    var canvasEl = fabric.document.createElement('canvas'),\n        nodeCanvas = new Canvas(width || 600, height || 600, nodeCanvasOptions);\n\n    // jsdom doesn't create style on canvas element, so here be temp. workaround\n    canvasEl.style = { };\n\n    canvasEl.width = nodeCanvas.width;\n    canvasEl.height = nodeCanvas.height;\n\n    var FabricCanvas = fabric.Canvas || fabric.StaticCanvas,\n        fabricCanvas = new FabricCanvas(canvasEl, options);\n\n    fabricCanvas.contextContainer = nodeCanvas.getContext('2d');\n    fabricCanvas.nodeCanvas = nodeCanvas;\n    fabricCanvas.Font = Canvas.Font;\n\n    return fabricCanvas;\n  };\n\n  /** @ignore */\n  fabric.StaticCanvas.prototype.createPNGStream = function() {\n    return this.nodeCanvas.createPNGStream();\n  };\n\n  fabric.StaticCanvas.prototype.createJPEGStream = function(opts) {\n    return this.nodeCanvas.createJPEGStream(opts);\n  };\n\n  var origSetWidth = fabric.StaticCanvas.prototype.setWidth;\n  fabric.StaticCanvas.prototype.setWidth = function(width, options) {\n    origSetWidth.call(this, width, options);\n    this.nodeCanvas.width = width;\n    return this;\n  };\n  if (fabric.Canvas) {\n    fabric.Canvas.prototype.setWidth = fabric.StaticCanvas.prototype.setWidth;\n  }\n\n  var origSetHeight = fabric.StaticCanvas.prototype.setHeight;\n  fabric.StaticCanvas.prototype.setHeight = function(height, options) {\n    origSetHeight.call(this, height, options);\n    this.nodeCanvas.height = height;\n    return this;\n  };\n  if (fabric.Canvas) {\n    fabric.Canvas.prototype.setHeight = fabric.StaticCanvas.prototype.setHeight;\n  }\n\n})();\n","Amasty_Reports/amcharts/plugins/export/libs/fabric.js/fabric.min.js":"// phpcs:ignoreFile\n/* eslint-disable */\nvar fabric=fabric||{version:\"1.6.2\"};\"undefined\"!=typeof exports&&(exports.fabric=fabric),\"undefined\"!=typeof document&&\"undefined\"!=typeof window?(fabric.document=document,fabric.window=window,window.fabric=fabric):(fabric.document=require(\"jsdom\").jsdom(\"<!DOCTYPE html><html><head></head><body></body></html>\"),fabric.document.createWindow?fabric.window=fabric.document.createWindow():fabric.window=fabric.document.parentWindow),fabric.isTouchSupported=\"ontouchstart\"in fabric.document.documentElement,fabric.isLikelyNode=\"undefined\"!=typeof Buffer&&\"undefined\"==typeof window,fabric.SHARED_ATTRIBUTES=[\"display\",\"transform\",\"fill\",\"fill-opacity\",\"fill-rule\",\"opacity\",\"stroke\",\"stroke-dasharray\",\"stroke-linecap\",\"stroke-linejoin\",\"stroke-miterlimit\",\"stroke-opacity\",\"stroke-width\",\"id\"],fabric.DPI=96,fabric.reNum=\"(?:[-+]?(?:\\\\d+|\\\\d*\\\\.\\\\d+)(?:e[-+]?\\\\d+)?)\",fabric.fontPaths={},fabric.devicePixelRatio=fabric.window.devicePixelRatio||fabric.window.webkitDevicePixelRatio||fabric.window.mozDevicePixelRatio||1,function(){function t(t,e){if(this.__eventListeners[t]){var i=this.__eventListeners[t];e?i[i.indexOf(e)]=!1:fabric.util.array.fill(i,!1)}}function e(t,e){if(this.__eventListeners||(this.__eventListeners={}),1===arguments.length)for(var i in t)this.on(i,t[i]);else this.__eventListeners[t]||(this.__eventListeners[t]=[]),this.__eventListeners[t].push(e);return this}function i(e,i){if(this.__eventListeners){if(0===arguments.length)for(e in this.__eventListeners)t.call(this,e);else if(1===arguments.length&&\"object\"==typeof arguments[0])for(var r in e)t.call(this,r,e[r]);else t.call(this,e,i);return this}}function r(t,e){if(this.__eventListeners){var i=this.__eventListeners[t];if(i){for(var r=0,n=i.length;n>r;r++)i[r]&&i[r].call(this,e||{});return this.__eventListeners[t]=i.filter(function(t){return t!==!1}),this}}}fabric.Observable={observe:e,stopObserving:i,fire:r,on:e,off:i,trigger:r}}(),fabric.Collection={add:function(){this._objects.push.apply(this._objects,arguments);for(var t=0,e=arguments.length;e>t;t++)this._onObjectAdded(arguments[t]);return this.renderOnAddRemove&&this.renderAll(),this},insertAt:function(t,e,i){var r=this.getObjects();return i?r[e]=t:r.splice(e,0,t),this._onObjectAdded(t),this.renderOnAddRemove&&this.renderAll(),this},remove:function(){for(var t,e=this.getObjects(),i=0,r=arguments.length;r>i;i++)t=e.indexOf(arguments[i]),-1!==t&&(e.splice(t,1),this._onObjectRemoved(arguments[i]));return this.renderOnAddRemove&&this.renderAll(),this},forEachObject:function(t,e){for(var i=this.getObjects(),r=i.length;r--;)t.call(e,i[r],r,i);return this},getObjects:function(t){return\"undefined\"==typeof t?this._objects:this._objects.filter(function(e){return e.type===t})},item:function(t){return this.getObjects()[t]},isEmpty:function(){return 0===this.getObjects().length},size:function(){return this.getObjects().length},contains:function(t){return this.getObjects().indexOf(t)>-1},complexity:function(){return this.getObjects().reduce(function(t,e){return t+=e.complexity?e.complexity():0},0)}},function(t){var e=Math.sqrt,i=Math.atan2,r=Math.pow,n=Math.abs,s=Math.PI/180;fabric.util={removeFromArray:function(t,e){var i=t.indexOf(e);return-1!==i&&t.splice(i,1),t},getRandomInt:function(t,e){return Math.floor(Math.random()*(e-t+1))+t},degreesToRadians:function(t){return t*s},radiansToDegrees:function(t){return t/s},rotatePoint:function(t,e,i){t.subtractEquals(e);var r=fabric.util.rotateVector(t,i);return new fabric.Point(r.x,r.y).addEquals(e)},rotateVector:function(t,e){var i=Math.sin(e),r=Math.cos(e),n=t.x*r-t.y*i,s=t.x*i+t.y*r;return{x:n,y:s}},transformPoint:function(t,e,i){return i?new fabric.Point(e[0]*t.x+e[2]*t.y,e[1]*t.x+e[3]*t.y):new fabric.Point(e[0]*t.x+e[2]*t.y+e[4],e[1]*t.x+e[3]*t.y+e[5])},makeBoundingBoxFromPoints:function(t){var e=[t[0].x,t[1].x,t[2].x,t[3].x],i=fabric.util.array.min(e),r=fabric.util.array.max(e),n=Math.abs(i-r),s=[t[0].y,t[1].y,t[2].y,t[3].y],o=fabric.util.array.min(s),a=fabric.util.array.max(s),h=Math.abs(o-a);return{left:i,top:o,width:n,height:h}},invertTransform:function(t){var e=1/(t[0]*t[3]-t[1]*t[2]),i=[e*t[3],-e*t[1],-e*t[2],e*t[0]],r=fabric.util.transformPoint({x:t[4],y:t[5]},i,!0);return i[4]=-r.x,i[5]=-r.y,i},toFixed:function(t,e){return parseFloat(Number(t).toFixed(e))},parseUnit:function(t,e){var i=/\\D{0,2}$/.exec(t),r=parseFloat(t);switch(e||(e=fabric.Text.DEFAULT_SVG_FONT_SIZE),i[0]){case\"mm\":return r*fabric.DPI/25.4;case\"cm\":return r*fabric.DPI/2.54;case\"in\":return r*fabric.DPI;case\"pt\":return r*fabric.DPI/72;case\"pc\":return r*fabric.DPI/72*12;case\"em\":return r*e;default:return r}},falseFunction:function(){return!1},getKlass:function(t,e){return t=fabric.util.string.camelize(t.charAt(0).toUpperCase()+t.slice(1)),fabric.util.resolveNamespace(e)[t]},resolveNamespace:function(e){if(!e)return fabric;for(var i=e.split(\".\"),r=i.length,n=t||fabric.window,s=0;r>s;++s)n=n[i[s]];return n},loadImage:function(t,e,i,r){if(!t)return void(e&&e.call(i,t));var n=fabric.util.createImage();n.onload=function(){e&&e.call(i,n),n=n.onload=n.onerror=null},n.onerror=function(){fabric.log(\"Error loading \"+n.src),e&&e.call(i,null,!0),n=n.onload=n.onerror=null},0!==t.indexOf(\"data\")&&r&&(n.crossOrigin=r),n.src=t},enlivenObjects:function(t,e,i,r){function n(){++o===a&&e&&e(s)}t=t||[];var s=[],o=0,a=t.length;return a?void t.forEach(function(t,e){if(!t||!t.type)return void n();var o=fabric.util.getKlass(t.type,i);o.async?o.fromObject(t,function(i,o){o||(s[e]=i,r&&r(t,s[e])),n()}):(s[e]=o.fromObject(t),r&&r(t,s[e]),n())}):void(e&&e(s))},groupSVGElements:function(t,e,i){var r;return r=new fabric.PathGroup(t,e),\"undefined\"!=typeof i&&r.setSourcePath(i),r},populateWithProperties:function(t,e,i){if(i&&\"[object Array]\"===Object.prototype.toString.call(i))for(var r=0,n=i.length;n>r;r++)i[r]in t&&(e[i[r]]=t[i[r]])},drawDashedLine:function(t,r,n,s,o,a){var h=s-r,c=o-n,l=e(h*h+c*c),u=i(c,h),f=a.length,d=0,g=!0;for(t.save(),t.translate(r,n),t.moveTo(0,0),t.rotate(u),r=0;l>r;)r+=a[d++%f],r>l&&(r=l),t[g?\"lineTo\":\"moveTo\"](r,0),g=!g;t.restore()},createCanvasElement:function(t){return t||(t=fabric.document.createElement(\"canvas\")),t.getContext||\"undefined\"==typeof G_vmlCanvasManager||G_vmlCanvasManager.initElement(t),t},createImage:function(){return fabric.isLikelyNode?new(require(\"canvas\").Image):fabric.document.createElement(\"img\")},createAccessors:function(t){for(var e=t.prototype,i=e.stateProperties.length;i--;){var r=e.stateProperties[i],n=r.charAt(0).toUpperCase()+r.slice(1),s=\"set\"+n,o=\"get\"+n;e[o]||(e[o]=function(t){return new Function('return this.get(\"'+t+'\")')}(r)),e[s]||(e[s]=function(t){return new Function(\"value\",'return this.set(\"'+t+'\", value)')}(r))}},clipContext:function(t,e){e.save(),e.beginPath(),t.clipTo(e),e.clip()},multiplyTransformMatrices:function(t,e,i){return[t[0]*e[0]+t[2]*e[1],t[1]*e[0]+t[3]*e[1],t[0]*e[2]+t[2]*e[3],t[1]*e[2]+t[3]*e[3],i?0:t[0]*e[4]+t[2]*e[5]+t[4],i?0:t[1]*e[4]+t[3]*e[5]+t[5]]},qrDecompose:function(t){var n=i(t[1],t[0]),o=r(t[0],2)+r(t[1],2),a=e(o),h=(t[0]*t[3]-t[2]*t[1])/a,c=i(t[0]*t[2]+t[1]*t[3],o);return{angle:n/s,scaleX:a,scaleY:h,skewX:c/s,skewY:0,translateX:t[4],translateY:t[5]}},customTransformMatrix:function(t,e,i){var r=[1,0,n(Math.tan(i*s)),1],o=[n(t),0,0,n(e)];return fabric.util.multiplyTransformMatrices(o,r,!0)},resetObjectTransform:function(t){t.scaleX=1,t.scaleY=1,t.skewX=0,t.skewY=0,t.flipX=!1,t.flipY=!1,t.setAngle(0)},getFunctionBody:function(t){return(String(t).match(/function[^{]*\\{([\\s\\S]*)\\}/)||{})[1]},isTransparent:function(t,e,i,r){r>0&&(e>r?e-=r:e=0,i>r?i-=r:i=0);for(var n=!0,s=t.getImageData(e,i,2*r||1,2*r||1),o=3,a=s.data.length;a>o;o+=4){var h=s.data[o];if(n=0>=h,n===!1)break}return s=null,n},parsePreserveAspectRatioAttribute:function(t){var e,i=\"meet\",r=\"Mid\",n=\"Mid\",s=t.split(\" \");return s&&s.length&&(i=s.pop(),\"meet\"!==i&&\"slice\"!==i?(e=i,i=\"meet\"):s.length&&(e=s.pop())),r=\"none\"!==e?e.slice(1,4):\"none\",n=\"none\"!==e?e.slice(5,8):\"none\",{meetOrSlice:i,alignX:r,alignY:n}}}}(\"undefined\"!=typeof exports?exports:this),function(){function t(t,r,s,o,h,c,l){var u=a.call(arguments);if(n[u])return n[u];var f=Math.PI,d=l*f/180,g=Math.sin(d),p=Math.cos(d),v=0,b=0;s=Math.abs(s),o=Math.abs(o);var m=-p*t*.5-g*r*.5,y=-p*r*.5+g*t*.5,_=s*s,x=o*o,S=y*y,C=m*m,w=_*x-_*S-x*C,O=0;if(0>w){var T=Math.sqrt(1-w/(_*x));s*=T,o*=T}else O=(h===c?-1:1)*Math.sqrt(w/(_*S+x*C));var k=O*s*y/o,j=-O*o*m/s,A=p*k-g*j+.5*t,M=g*k+p*j+.5*r,P=i(1,0,(m-k)/s,(y-j)/o),L=i((m-k)/s,(y-j)/o,(-m-k)/s,(-y-j)/o);0===c&&L>0?L-=2*f:1===c&&0>L&&(L+=2*f);for(var D=Math.ceil(Math.abs(L/f*2)),E=[],I=L/D,R=8/3*Math.sin(I/4)*Math.sin(I/4)/Math.sin(I/2),B=P+I,F=0;D>F;F++)E[F]=e(P,B,p,g,s,o,A,M,R,v,b),v=E[F][4],b=E[F][5],P=B,B+=I;return n[u]=E,E}function e(t,e,i,r,n,o,h,c,l,u,f){var d=a.call(arguments);if(s[d])return s[d];var g=Math.cos(t),p=Math.sin(t),v=Math.cos(e),b=Math.sin(e),m=i*n*v-r*o*b+h,y=r*n*v+i*o*b+c,_=u+l*(-i*n*p-r*o*g),x=f+l*(-r*n*p+i*o*g),S=m+l*(i*n*b+r*o*v),C=y+l*(r*n*b-i*o*v);return s[d]=[_,x,S,C,m,y],s[d]}function i(t,e,i,r){var n=Math.atan2(e,t),s=Math.atan2(r,i);return s>=n?s-n:2*Math.PI-(n-s)}function r(t,e,i,r,n,s,h,c){var l=a.call(arguments);if(o[l])return o[l];var u,f,d,g,p,v,b,m,y=Math.sqrt,_=Math.min,x=Math.max,S=Math.abs,C=[],w=[[],[]];f=6*t-12*i+6*n,u=-3*t+9*i-9*n+3*h,d=3*i-3*t;for(var O=0;2>O;++O)if(O>0&&(f=6*e-12*r+6*s,u=-3*e+9*r-9*s+3*c,d=3*r-3*e),S(u)<1e-12){if(S(f)<1e-12)continue;g=-d/f,g>0&&1>g&&C.push(g)}else b=f*f-4*d*u,0>b||(m=y(b),p=(-f+m)/(2*u),p>0&&1>p&&C.push(p),v=(-f-m)/(2*u),v>0&&1>v&&C.push(v));for(var T,k,j,A=C.length,M=A;A--;)g=C[A],j=1-g,T=j*j*j*t+3*j*j*g*i+3*j*g*g*n+g*g*g*h,w[0][A]=T,k=j*j*j*e+3*j*j*g*r+3*j*g*g*s+g*g*g*c,w[1][A]=k;w[0][M]=t,w[1][M]=e,w[0][M+1]=h,w[1][M+1]=c;var P=[{x:_.apply(null,w[0]),y:_.apply(null,w[1])},{x:x.apply(null,w[0]),y:x.apply(null,w[1])}];return o[l]=P,P}var n={},s={},o={},a=Array.prototype.join;fabric.util.drawArc=function(e,i,r,n){for(var s=n[0],o=n[1],a=n[2],h=n[3],c=n[4],l=n[5],u=n[6],f=[[],[],[],[]],d=t(l-i,u-r,s,o,h,c,a),g=0,p=d.length;p>g;g++)f[g][0]=d[g][0]+i,f[g][1]=d[g][1]+r,f[g][2]=d[g][2]+i,f[g][3]=d[g][3]+r,f[g][4]=d[g][4]+i,f[g][5]=d[g][5]+r,e.bezierCurveTo.apply(e,f[g])},fabric.util.getBoundsOfArc=function(e,i,n,s,o,a,h,c,l){for(var u=0,f=0,d=[],g=[],p=t(c-e,l-i,n,s,a,h,o),v=[[],[]],b=0,m=p.length;m>b;b++)d=r(u,f,p[b][0],p[b][1],p[b][2],p[b][3],p[b][4],p[b][5]),v[0].x=d[0].x+e,v[0].y=d[0].y+i,v[1].x=d[1].x+e,v[1].y=d[1].y+i,g.push(v[0]),g.push(v[1]),u=p[b][4],f=p[b][5];return g},fabric.util.getBoundsOfCurve=r}(),function(){function t(t,e){for(var i=s.call(arguments,2),r=[],n=0,o=t.length;o>n;n++)r[n]=i.length?t[n][e].apply(t[n],i):t[n][e].call(t[n]);return r}function e(t,e){return n(t,e,function(t,e){return t>=e})}function i(t,e){return n(t,e,function(t,e){return e>t})}function r(t,e){for(var i=t.length;i--;)t[i]=e;return t}function n(t,e,i){if(t&&0!==t.length){var r=t.length-1,n=e?t[r][e]:t[r];if(e)for(;r--;)i(t[r][e],n)&&(n=t[r][e]);else for(;r--;)i(t[r],n)&&(n=t[r]);return n}}var s=Array.prototype.slice;Array.prototype.indexOf||(Array.prototype.indexOf=function(t){if(void 0===this||null===this)throw new TypeError;var e=Object(this),i=e.length>>>0;if(0===i)return-1;var r=0;if(arguments.length>0&&(r=Number(arguments[1]),r!==r?r=0:0!==r&&r!==Number.POSITIVE_INFINITY&&r!==Number.NEGATIVE_INFINITY&&(r=(r>0||-1)*Math.floor(Math.abs(r)))),r>=i)return-1;for(var n=r>=0?r:Math.max(i-Math.abs(r),0);i>n;n++)if(n in e&&e[n]===t)return n;return-1}),Array.prototype.forEach||(Array.prototype.forEach=function(t,e){for(var i=0,r=this.length>>>0;r>i;i++)i in this&&t.call(e,this[i],i,this)}),Array.prototype.map||(Array.prototype.map=function(t,e){for(var i=[],r=0,n=this.length>>>0;n>r;r++)r in this&&(i[r]=t.call(e,this[r],r,this));return i}),Array.prototype.every||(Array.prototype.every=function(t,e){for(var i=0,r=this.length>>>0;r>i;i++)if(i in this&&!t.call(e,this[i],i,this))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(t,e){for(var i=0,r=this.length>>>0;r>i;i++)if(i in this&&t.call(e,this[i],i,this))return!0;return!1}),Array.prototype.filter||(Array.prototype.filter=function(t,e){for(var i,r=[],n=0,s=this.length>>>0;s>n;n++)n in this&&(i=this[n],t.call(e,i,n,this)&&r.push(i));return r}),Array.prototype.reduce||(Array.prototype.reduce=function(t){var e,i=this.length>>>0,r=0;if(arguments.length>1)e=arguments[1];else for(;;){if(r in this){e=this[r++];break}if(++r>=i)throw new TypeError}for(;i>r;r++)r in this&&(e=t.call(null,e,this[r],r,this));return e}),fabric.util.array={fill:r,invoke:t,min:i,max:e}}(),function(){function t(t,e){for(var i in e)t[i]=e[i];return t}function e(e){return t({},e)}fabric.util.object={extend:t,clone:e}}(),function(){function t(t){return t.replace(/-+(.)?/g,function(t,e){return e?e.toUpperCase():\"\"})}function e(t,e){return t.charAt(0).toUpperCase()+(e?t.slice(1):t.slice(1).toLowerCase())}function i(t){return t.replace(/&/g,\"&amp;\").replace(/\"/g,\"&quot;\").replace(/'/g,\"&apos;\").replace(/</g,\"&lt;\").replace(/>/g,\"&gt;\")}String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\\s\\xA0]+/,\"\").replace(/[\\s\\xA0]+$/,\"\")}),fabric.util.string={camelize:t,capitalize:e,escapeXml:i}}(),function(){var t=Array.prototype.slice,e=Function.prototype.apply,i=function(){};Function.prototype.bind||(Function.prototype.bind=function(r){var n,s=this,o=t.call(arguments,1);return n=o.length?function(){return e.call(s,this instanceof i?this:r,o.concat(t.call(arguments)))}:function(){return e.call(s,this instanceof i?this:r,arguments)},i.prototype=this.prototype,n.prototype=new i,n})}(),function(){function t(){}function e(t){var e=this.constructor.superclass.prototype[t];return arguments.length>1?e.apply(this,r.call(arguments,1)):e.call(this)}function i(){function i(){this.initialize.apply(this,arguments)}var s=null,a=r.call(arguments,0);\"function\"==typeof a[0]&&(s=a.shift()),i.superclass=s,i.subclasses=[],s&&(t.prototype=s.prototype,i.prototype=new t,s.subclasses.push(i));for(var h=0,c=a.length;c>h;h++)o(i,a[h],s);return i.prototype.initialize||(i.prototype.initialize=n),i.prototype.constructor=i,i.prototype.callSuper=e,i}var r=Array.prototype.slice,n=function(){},s=function(){for(var t in{toString:1})if(\"toString\"===t)return!1;return!0}(),o=function(t,e,i){for(var r in e)r in t.prototype&&\"function\"==typeof t.prototype[r]&&(e[r]+\"\").indexOf(\"callSuper\")>-1?t.prototype[r]=function(t){return function(){var r=this.constructor.superclass;this.constructor.superclass=i;var n=e[t].apply(this,arguments);return this.constructor.superclass=r,\"initialize\"!==t?n:void 0}}(r):t.prototype[r]=e[r],s&&(e.toString!==Object.prototype.toString&&(t.prototype.toString=e.toString),e.valueOf!==Object.prototype.valueOf&&(t.prototype.valueOf=e.valueOf))};fabric.util.createClass=i}(),function(){function t(t){var e,i,r=Array.prototype.slice.call(arguments,1),n=r.length;for(i=0;n>i;i++)if(e=typeof t[r[i]],!/^(?:function|object|unknown)$/.test(e))return!1;return!0}function e(t,e){return{handler:e,wrappedHandler:i(t,e)}}function i(t,e){return function(i){e.call(o(t),i||fabric.window.event)}}function r(t,e){return function(i){if(p[t]&&p[t][e])for(var r=p[t][e],n=0,s=r.length;s>n;n++)r[n].call(this,i||fabric.window.event)}}function n(t){t||(t=fabric.window.event);var e=t.target||(typeof t.srcElement!==h?t.srcElement:null),i=fabric.util.getScrollLeftTop(e);return{x:v(t)+i.left,y:b(t)+i.top}}function s(t,e,i){var r=\"touchend\"===t.type?\"changedTouches\":\"touches\";return t[r]&&t[r][0]?t[r][0][e]-(t[r][0][e]-t[r][0][i])||t[i]:t[i]}var o,a,h=\"unknown\",c=function(){var t=0;return function(e){return e.__uniqueID||(e.__uniqueID=\"uniqueID__\"+t++)}}();!function(){var t={};o=function(e){return t[e]},a=function(e,i){t[e]=i}}();var l,u,f=t(fabric.document.documentElement,\"addEventListener\",\"removeEventListener\")&&t(fabric.window,\"addEventListener\",\"removeEventListener\"),d=t(fabric.document.documentElement,\"attachEvent\",\"detachEvent\")&&t(fabric.window,\"attachEvent\",\"detachEvent\"),g={},p={};f?(l=function(t,e,i){t.addEventListener(e,i,!1)},u=function(t,e,i){t.removeEventListener(e,i,!1)}):d?(l=function(t,i,r){var n=c(t);a(n,t),g[n]||(g[n]={}),g[n][i]||(g[n][i]=[]);var s=e(n,r);g[n][i].push(s),t.attachEvent(\"on\"+i,s.wrappedHandler)},u=function(t,e,i){var r,n=c(t);if(g[n]&&g[n][e])for(var s=0,o=g[n][e].length;o>s;s++)r=g[n][e][s],r&&r.handler===i&&(t.detachEvent(\"on\"+e,r.wrappedHandler),g[n][e][s]=null)}):(l=function(t,e,i){var n=c(t);if(p[n]||(p[n]={}),!p[n][e]){p[n][e]=[];var s=t[\"on\"+e];s&&p[n][e].push(s),t[\"on\"+e]=r(n,e)}p[n][e].push(i)},u=function(t,e,i){var r=c(t);if(p[r]&&p[r][e])for(var n=p[r][e],s=0,o=n.length;o>s;s++)n[s]===i&&n.splice(s,1)}),fabric.util.addListener=l,fabric.util.removeListener=u;var v=function(t){return typeof t.clientX!==h?t.clientX:0},b=function(t){return typeof t.clientY!==h?t.clientY:0};fabric.isTouchSupported&&(v=function(t){return s(t,\"pageX\",\"clientX\")},b=function(t){return s(t,\"pageY\",\"clientY\")}),fabric.util.getPointer=n,fabric.util.object.extend(fabric.util,fabric.Observable)}(),function(){function t(t,e){var i=t.style;if(!i)return t;if(\"string\"==typeof e)return t.style.cssText+=\";\"+e,e.indexOf(\"opacity\")>-1?s(t,e.match(/opacity:\\s*(\\d?\\.?\\d*)/)[1]):t;for(var r in e)if(\"opacity\"===r)s(t,e[r]);else{var n=\"float\"===r||\"cssFloat\"===r?\"undefined\"==typeof i.styleFloat?\"cssFloat\":\"styleFloat\":r;i[n]=e[r]}return t}var e=fabric.document.createElement(\"div\"),i=\"string\"==typeof e.style.opacity,r=\"string\"==typeof e.style.filter,n=/alpha\\s*\\(\\s*opacity\\s*=\\s*([^\\)]+)\\)/,s=function(t){return t};i?s=function(t,e){return t.style.opacity=e,t}:r&&(s=function(t,e){var i=t.style;return t.currentStyle&&!t.currentStyle.hasLayout&&(i.zoom=1),n.test(i.filter)?(e=e>=.9999?\"\":\"alpha(opacity=\"+100*e+\")\",i.filter=i.filter.replace(n,e)):i.filter+=\" alpha(opacity=\"+100*e+\")\",t}),fabric.util.setStyle=t}(),function(){function t(t){return\"string\"==typeof t?fabric.document.getElementById(t):t}function e(t,e){var i=fabric.document.createElement(t);for(var r in e)\"class\"===r?i.className=e[r]:\"for\"===r?i.htmlFor=e[r]:i.setAttribute(r,e[r]);return i}function i(t,e){t&&-1===(\" \"+t.className+\" \").indexOf(\" \"+e+\" \")&&(t.className+=(t.className?\" \":\"\")+e)}function r(t,i,r){return\"string\"==typeof i&&(i=e(i,r)),t.parentNode&&t.parentNode.replaceChild(i,t),i.appendChild(t),i}function n(t){for(var e=0,i=0,r=fabric.document.documentElement,n=fabric.document.body||{scrollLeft:0,scrollTop:0};t&&(t.parentNode||t.host)&&(t=t.parentNode||t.host,t===fabric.document?(e=n.scrollLeft||r.scrollLeft||0,i=n.scrollTop||r.scrollTop||0):(e+=t.scrollLeft||0,i+=t.scrollTop||0),1!==t.nodeType||\"fixed\"!==fabric.util.getElementStyle(t,\"position\")););return{left:e,top:i}}function s(t){var e,i,r=t&&t.ownerDocument,s={left:0,top:0},o={left:0,top:0},a={borderLeftWidth:\"left\",borderTopWidth:\"top\",paddingLeft:\"left\",paddingTop:\"top\"};if(!r)return o;for(var h in a)o[a[h]]+=parseInt(l(t,h),10)||0;return e=r.documentElement,\"undefined\"!=typeof t.getBoundingClientRect&&(s=t.getBoundingClientRect()),i=n(t),{left:s.left+i.left-(e.clientLeft||0)+o.left,top:s.top+i.top-(e.clientTop||0)+o.top}}var o,a=Array.prototype.slice,h=function(t){return a.call(t,0)};try{o=h(fabric.document.childNodes)instanceof Array}catch(c){}o||(h=function(t){for(var e=new Array(t.length),i=t.length;i--;)e[i]=t[i];return e});var l;l=fabric.document.defaultView&&fabric.document.defaultView.getComputedStyle?function(t,e){var i=fabric.document.defaultView.getComputedStyle(t,null);return i?i[e]:void 0}:function(t,e){var i=t.style[e];return!i&&t.currentStyle&&(i=t.currentStyle[e]),i},function(){function t(t){return\"undefined\"!=typeof t.onselectstart&&(t.onselectstart=fabric.util.falseFunction),r?t.style[r]=\"none\":\"string\"==typeof t.unselectable&&(t.unselectable=\"on\"),t}function e(t){return\"undefined\"!=typeof t.onselectstart&&(t.onselectstart=null),r?t.style[r]=\"\":\"string\"==typeof t.unselectable&&(t.unselectable=\"\"),t}var i=fabric.document.documentElement.style,r=\"userSelect\"in i?\"userSelect\":\"MozUserSelect\"in i?\"MozUserSelect\":\"WebkitUserSelect\"in i?\"WebkitUserSelect\":\"KhtmlUserSelect\"in i?\"KhtmlUserSelect\":\"\";fabric.util.makeElementUnselectable=t,fabric.util.makeElementSelectable=e}(),function(){function t(t,e){var i=fabric.document.getElementsByTagName(\"head\")[0],r=fabric.document.createElement(\"script\"),n=!0;r.onload=r.onreadystatechange=function(t){if(n){if(\"string\"==typeof this.readyState&&\"loaded\"!==this.readyState&&\"complete\"!==this.readyState)return;n=!1,e(t||fabric.window.event),r=r.onload=r.onreadystatechange=null}},r.src=t,i.appendChild(r)}fabric.util.getScript=t}(),fabric.util.getById=t,fabric.util.toArray=h,fabric.util.makeElement=e,fabric.util.addClass=i,fabric.util.wrapElement=r,fabric.util.getScrollLeftTop=n,fabric.util.getElementOffset=s,fabric.util.getElementStyle=l}(),function(){function t(t,e){return t+(/\\?/.test(t)?\"&\":\"?\")+e}function e(){}function i(i,n){n||(n={});var s,o=n.method?n.method.toUpperCase():\"GET\",a=n.onComplete||function(){},h=r();return h.onreadystatechange=function(){4===h.readyState&&(a(h),h.onreadystatechange=e)},\"GET\"===o&&(s=null,\"string\"==typeof n.parameters&&(i=t(i,n.parameters))),h.open(o,i,!0),\"POST\"!==o&&\"PUT\"!==o||h.setRequestHeader(\"Content-Type\",\"application/x-www-form-urlencoded\"),h.send(s),h}var r=function(){for(var t=[function(){return new ActiveXObject(\"Microsoft.XMLHTTP\")},function(){return new ActiveXObject(\"Msxml2.XMLHTTP\")},function(){return new ActiveXObject(\"Msxml2.XMLHTTP.3.0\")},function(){return new XMLHttpRequest}],e=t.length;e--;)try{var i=t[e]();if(i)return t[e]}catch(r){}}();fabric.util.request=i}(),fabric.log=function(){},fabric.warn=function(){},\"undefined\"!=typeof console&&[\"log\",\"warn\"].forEach(function(t){\"undefined\"!=typeof console[t]&&\"function\"==typeof console[t].apply&&(fabric[t]=function(){return console[t].apply(console,arguments)})}),function(){function t(t){e(function(i){t||(t={});var r,n=i||+new Date,s=t.duration||500,o=n+s,a=t.onChange||function(){},h=t.abort||function(){return!1},c=t.easing||function(t,e,i,r){return-i*Math.cos(t/r*(Math.PI/2))+i+e},l=\"startValue\"in t?t.startValue:0,u=\"endValue\"in t?t.endValue:100,f=t.byValue||u-l;t.onStart&&t.onStart(),function d(i){r=i||+new Date;var u=r>o?s:r-n;return h()?void(t.onComplete&&t.onComplete()):(a(c(u,l,f,s)),r>o?void(t.onComplete&&t.onComplete()):void e(d))}(n)})}function e(){return i.apply(fabric.window,arguments)}var i=fabric.window.requestAnimationFrame||fabric.window.webkitRequestAnimationFrame||fabric.window.mozRequestAnimationFrame||fabric.window.oRequestAnimationFrame||fabric.window.msRequestAnimationFrame||function(t){fabric.window.setTimeout(t,1e3/60)};fabric.util.animate=t,fabric.util.requestAnimFrame=e}(),function(){function t(t,e,i,r){return t<Math.abs(e)?(t=e,r=i/4):r=0===e&&0===t?i/(2*Math.PI)*Math.asin(1):i/(2*Math.PI)*Math.asin(e/t),{a:t,c:e,p:i,s:r}}function e(t,e,i){return t.a*Math.pow(2,10*(e-=1))*Math.sin((e*i-t.s)*(2*Math.PI)/t.p)}function i(t,e,i,r){return i*((t=t/r-1)*t*t+1)+e}function r(t,e,i,r){return t/=r/2,1>t?i/2*t*t*t+e:i/2*((t-=2)*t*t+2)+e}function n(t,e,i,r){return i*(t/=r)*t*t*t+e}function s(t,e,i,r){return-i*((t=t/r-1)*t*t*t-1)+e}function o(t,e,i,r){return t/=r/2,1>t?i/2*t*t*t*t+e:-i/2*((t-=2)*t*t*t-2)+e}function a(t,e,i,r){return i*(t/=r)*t*t*t*t+e}function h(t,e,i,r){return i*((t=t/r-1)*t*t*t*t+1)+e}function c(t,e,i,r){return t/=r/2,1>t?i/2*t*t*t*t*t+e:i/2*((t-=2)*t*t*t*t+2)+e}function l(t,e,i,r){return-i*Math.cos(t/r*(Math.PI/2))+i+e}function u(t,e,i,r){return i*Math.sin(t/r*(Math.PI/2))+e}function f(t,e,i,r){return-i/2*(Math.cos(Math.PI*t/r)-1)+e}function d(t,e,i,r){return 0===t?e:i*Math.pow(2,10*(t/r-1))+e}function g(t,e,i,r){return t===r?e+i:i*(-Math.pow(2,-10*t/r)+1)+e}function p(t,e,i,r){return 0===t?e:t===r?e+i:(t/=r/2,1>t?i/2*Math.pow(2,10*(t-1))+e:i/2*(-Math.pow(2,-10*--t)+2)+e)}function v(t,e,i,r){return-i*(Math.sqrt(1-(t/=r)*t)-1)+e}function b(t,e,i,r){return i*Math.sqrt(1-(t=t/r-1)*t)+e}function m(t,e,i,r){return t/=r/2,1>t?-i/2*(Math.sqrt(1-t*t)-1)+e:i/2*(Math.sqrt(1-(t-=2)*t)+1)+e}function y(i,r,n,s){var o=1.70158,a=0,h=n;if(0===i)return r;if(i/=s,1===i)return r+n;a||(a=.3*s);var c=t(h,n,a,o);return-e(c,i,s)+r}function _(e,i,r,n){var s=1.70158,o=0,a=r;if(0===e)return i;if(e/=n,1===e)return i+r;o||(o=.3*n);var h=t(a,r,o,s);return h.a*Math.pow(2,-10*e)*Math.sin((e*n-h.s)*(2*Math.PI)/h.p)+h.c+i}function x(i,r,n,s){var o=1.70158,a=0,h=n;if(0===i)return r;if(i/=s/2,2===i)return r+n;a||(a=s*(.3*1.5));var c=t(h,n,a,o);return 1>i?-.5*e(c,i,s)+r:c.a*Math.pow(2,-10*(i-=1))*Math.sin((i*s-c.s)*(2*Math.PI)/c.p)*.5+c.c+r}function S(t,e,i,r,n){return void 0===n&&(n=1.70158),i*(t/=r)*t*((n+1)*t-n)+e}function C(t,e,i,r,n){return void 0===n&&(n=1.70158),i*((t=t/r-1)*t*((n+1)*t+n)+1)+e}function w(t,e,i,r,n){return void 0===n&&(n=1.70158),t/=r/2,1>t?i/2*(t*t*(((n*=1.525)+1)*t-n))+e:i/2*((t-=2)*t*(((n*=1.525)+1)*t+n)+2)+e}function O(t,e,i,r){return i-T(r-t,0,i,r)+e}function T(t,e,i,r){return(t/=r)<1/2.75?i*(7.5625*t*t)+e:2/2.75>t?i*(7.5625*(t-=1.5/2.75)*t+.75)+e:2.5/2.75>t?i*(7.5625*(t-=2.25/2.75)*t+.9375)+e:i*(7.5625*(t-=2.625/2.75)*t+.984375)+e}function k(t,e,i,r){return r/2>t?.5*O(2*t,0,i,r)+e:.5*T(2*t-r,0,i,r)+.5*i+e}fabric.util.ease={easeInQuad:function(t,e,i,r){return i*(t/=r)*t+e},easeOutQuad:function(t,e,i,r){return-i*(t/=r)*(t-2)+e},easeInOutQuad:function(t,e,i,r){return t/=r/2,1>t?i/2*t*t+e:-i/2*(--t*(t-2)-1)+e},easeInCubic:function(t,e,i,r){return i*(t/=r)*t*t+e},easeOutCubic:i,easeInOutCubic:r,easeInQuart:n,easeOutQuart:s,easeInOutQuart:o,easeInQuint:a,easeOutQuint:h,easeInOutQuint:c,easeInSine:l,easeOutSine:u,easeInOutSine:f,easeInExpo:d,easeOutExpo:g,easeInOutExpo:p,easeInCirc:v,easeOutCirc:b,easeInOutCirc:m,easeInElastic:y,easeOutElastic:_,easeInOutElastic:x,easeInBack:S,easeOutBack:C,easeInOutBack:w,easeInBounce:O,easeOutBounce:T,easeInOutBounce:k}}(),function(t){\"use strict\";function e(t){return t in T?T[t]:t}function i(t,e,i,r){var n,s=\"[object Array]\"===Object.prototype.toString.call(e);return\"fill\"!==t&&\"stroke\"!==t||\"none\"!==e?\"strokeDashArray\"===t?e=e.replace(/,/g,\" \").split(/\\s+/).map(function(t){return parseFloat(t)}):\"transformMatrix\"===t?e=i&&i.transformMatrix?x(i.transformMatrix,p.parseTransformAttribute(e)):p.parseTransformAttribute(e):\"visible\"===t?(e=\"none\"!==e&&\"hidden\"!==e,i&&i.visible===!1&&(e=!1)):\"originX\"===t?e=\"start\"===e?\"left\":\"end\"===e?\"right\":\"center\":n=s?e.map(_):_(e,r):e=\"\",!s&&isNaN(n)?e:n}function r(t){for(var e in k)if(\"undefined\"!=typeof t[k[e]]&&\"\"!==t[e]){if(\"undefined\"==typeof t[e]){if(!p.Object.prototype[e])continue;t[e]=p.Object.prototype[e]}if(0!==t[e].indexOf(\"url(\")){var i=new p.Color(t[e]);t[e]=i.setAlpha(y(i.getAlpha()*t[k[e]],2)).toRgba()}}return t}function n(t,r){var n,s;t.replace(/;\\s*$/,\"\").split(\";\").forEach(function(t){var o=t.split(\":\");n=e(o[0].trim().toLowerCase()),s=i(n,o[1].trim()),r[n]=s})}function s(t,r){var n,s;for(var o in t)\"undefined\"!=typeof t[o]&&(n=e(o.toLowerCase()),s=i(n,t[o]),r[n]=s)}function o(t,e){var i={};for(var r in p.cssRules[e])if(a(t,r.split(\" \")))for(var n in p.cssRules[e][r])i[n]=p.cssRules[e][r][n];return i}function a(t,e){var i,r=!0;return i=c(t,e.pop()),i&&e.length&&(r=h(t,e)),i&&r&&0===e.length}function h(t,e){for(var i,r=!0;t.parentNode&&1===t.parentNode.nodeType&&e.length;)r&&(i=e.pop()),t=t.parentNode,r=c(t,i);return 0===e.length}function c(t,e){var i,r=t.nodeName,n=t.getAttribute(\"class\"),s=t.getAttribute(\"id\");if(i=new RegExp(\"^\"+r,\"i\"),e=e.replace(i,\"\"),s&&e.length&&(i=new RegExp(\"#\"+s+\"(?![a-zA-Z\\\\-]+)\",\"i\"),e=e.replace(i,\"\")),n&&e.length){n=n.split(\" \");for(var o=n.length;o--;)i=new RegExp(\"\\\\.\"+n[o]+\"(?![a-zA-Z\\\\-]+)\",\"i\"),e=e.replace(i,\"\")}return 0===e.length}function l(t,e){var i;if(t.getElementById&&(i=t.getElementById(e)),i)return i;var r,n,s=t.getElementsByTagName(\"*\");for(n=0;n<s.length;n++)if(r=s[n],e===r.getAttribute(\"id\"))return r}function u(t){for(var e=t.getElementsByTagName(\"use\"),i=0;e.length&&i<e.length;){var r,n,s,o,a,h=e[i],c=h.getAttribute(\"xlink:href\").substr(1),u=h.getAttribute(\"x\")||0,d=h.getAttribute(\"y\")||0,g=l(t,c).cloneNode(!0),p=(g.getAttribute(\"transform\")||\"\")+\" translate(\"+u+\", \"+d+\")\",v=e.length;if(f(g),/^svg$/i.test(g.nodeName)){var b=g.ownerDocument.createElement(\"g\");for(s=0,o=g.attributes,a=o.length;a>s;s++)n=o.item(s),b.setAttribute(n.nodeName,n.nodeValue);for(;null!=g.firstChild;)b.appendChild(g.firstChild);g=b}for(s=0,o=h.attributes,a=o.length;a>s;s++)n=o.item(s),\"x\"!==n.nodeName&&\"y\"!==n.nodeName&&\"xlink:href\"!==n.nodeName&&(\"transform\"===n.nodeName?p=n.nodeValue+\" \"+p:g.setAttribute(n.nodeName,n.nodeValue));g.setAttribute(\"transform\",p),g.setAttribute(\"instantiated_by_use\",\"1\"),g.removeAttribute(\"id\"),r=h.parentNode,r.replaceChild(g,h),e.length===v&&i++}}function f(t){var e,i,r,n,s=t.getAttribute(\"viewBox\"),o=1,a=1,h=0,c=0,l=t.getAttribute(\"width\"),u=t.getAttribute(\"height\"),f=t.getAttribute(\"x\")||0,d=t.getAttribute(\"y\")||0,g=t.getAttribute(\"preserveAspectRatio\")||\"\",v=!s||!C.test(t.tagName)||!(s=s.match(j)),b=!l||!u||\"100%\"===l||\"100%\"===u,m=v&&b,y={},x=\"\";if(y.width=0,y.height=0,y.toBeParsed=m,m)return y;if(v)return y.width=_(l),y.height=_(u),y;if(h=-parseFloat(s[1]),c=-parseFloat(s[2]),e=parseFloat(s[3]),i=parseFloat(s[4]),b?(y.width=e,y.height=i):(y.width=_(l),y.height=_(u),o=y.width/e,a=y.height/i),g=p.util.parsePreserveAspectRatioAttribute(g),\"none\"!==g.alignX&&(a=o=o>a?a:o),1===o&&1===a&&0===h&&0===c&&0===f&&0===d)return y;if((f||d)&&(x=\" translate(\"+_(f)+\" \"+_(d)+\") \"),r=x+\" matrix(\"+o+\" 0 0 \"+a+\" \"+h*o+\" \"+c*a+\") \",\"svg\"===t.tagName){for(n=t.ownerDocument.createElement(\"g\");null!=t.firstChild;)n.appendChild(t.firstChild);t.appendChild(n)}else n=t,r=n.getAttribute(\"transform\")+r;return n.setAttribute(\"transform\",r),y}function d(t){var e=t.objects,i=t.options;return e=e.map(function(t){return p[b(t.type)].fromObject(t)}),{objects:e,options:i}}function g(t,e,i){e[i]&&e[i].toSVG&&t.push('\t<pattern x=\"0\" y=\"0\" id=\"',i,'Pattern\" ','width=\"',e[i].source.width,'\" height=\"',e[i].source.height,'\" patternUnits=\"userSpaceOnUse\">\\n','\t\t<image x=\"0\" y=\"0\" ','width=\"',e[i].source.width,'\" height=\"',e[i].source.height,'\" xlink:href=\"',e[i].source.src,'\"></image>\\n\t</pattern>\\n')}var p=t.fabric||(t.fabric={}),v=p.util.object.extend,b=p.util.string.capitalize,m=p.util.object.clone,y=p.util.toFixed,_=p.util.parseUnit,x=p.util.multiplyTransformMatrices,S=/^(path|circle|polygon|polyline|ellipse|rect|line|image|text)$/i,C=/^(symbol|image|marker|pattern|view|svg)$/i,w=/^(?:pattern|defs|symbol|metadata)$/i,O=/^(symbol|g|a|svg)$/i,T={cx:\"left\",x:\"left\",r:\"radius\",cy:\"top\",y:\"top\",display:\"visible\",visibility:\"visible\",transform:\"transformMatrix\",\"fill-opacity\":\"fillOpacity\",\"fill-rule\":\"fillRule\",\"font-family\":\"fontFamily\",\"font-size\":\"fontSize\",\"font-style\":\"fontStyle\",\"font-weight\":\"fontWeight\",\"stroke-dasharray\":\"strokeDashArray\",\"stroke-linecap\":\"strokeLineCap\",\"stroke-linejoin\":\"strokeLineJoin\",\"stroke-miterlimit\":\"strokeMiterLimit\",\"stroke-opacity\":\"strokeOpacity\",\"stroke-width\":\"strokeWidth\",\"text-decoration\":\"textDecoration\",\"text-anchor\":\"originX\"},k={stroke:\"strokeOpacity\",fill:\"fillOpacity\"};p.cssRules={},p.gradientDefs={},p.parseTransformAttribute=function(){function t(t,e){var i=e[0],r=3===e.length?e[1]:0,n=3===e.length?e[2]:0;t[0]=Math.cos(i),t[1]=Math.sin(i),t[2]=-Math.sin(i),t[3]=Math.cos(i),t[4]=r-(t[0]*r+t[2]*n),t[5]=n-(t[1]*r+t[3]*n)}function e(t,e){var i=e[0],r=2===e.length?e[1]:e[0];t[0]=i,t[3]=r}function i(t,e){t[2]=Math.tan(p.util.degreesToRadians(e[0]))}function r(t,e){t[1]=Math.tan(p.util.degreesToRadians(e[0]))}function n(t,e){t[4]=e[0],2===e.length&&(t[5]=e[1])}var s=[1,0,0,1,0,0],o=p.reNum,a=\"(?:\\\\s+,?\\\\s*|,\\\\s*)\",h=\"(?:(skewX)\\\\s*\\\\(\\\\s*(\"+o+\")\\\\s*\\\\))\",c=\"(?:(skewY)\\\\s*\\\\(\\\\s*(\"+o+\")\\\\s*\\\\))\",l=\"(?:(rotate)\\\\s*\\\\(\\\\s*(\"+o+\")(?:\"+a+\"(\"+o+\")\"+a+\"(\"+o+\"))?\\\\s*\\\\))\",u=\"(?:(scale)\\\\s*\\\\(\\\\s*(\"+o+\")(?:\"+a+\"(\"+o+\"))?\\\\s*\\\\))\",f=\"(?:(translate)\\\\s*\\\\(\\\\s*(\"+o+\")(?:\"+a+\"(\"+o+\"))?\\\\s*\\\\))\",d=\"(?:(matrix)\\\\s*\\\\(\\\\s*(\"+o+\")\"+a+\"(\"+o+\")\"+a+\"(\"+o+\")\"+a+\"(\"+o+\")\"+a+\"(\"+o+\")\"+a+\"(\"+o+\")\\\\s*\\\\))\",g=\"(?:\"+d+\"|\"+f+\"|\"+u+\"|\"+l+\"|\"+h+\"|\"+c+\")\",v=\"(?:\"+g+\"(?:\"+a+\"*\"+g+\")*)\",b=\"^\\\\s*(?:\"+v+\"?)\\\\s*$\",m=new RegExp(b),y=new RegExp(g,\"g\");\nreturn function(o){var a=s.concat(),h=[];if(!o||o&&!m.test(o))return a;o.replace(y,function(o){var c=new RegExp(g).exec(o).filter(function(t){return\"\"!==t&&null!=t}),l=c[1],u=c.slice(2).map(parseFloat);switch(l){case\"translate\":n(a,u);break;case\"rotate\":u[0]=p.util.degreesToRadians(u[0]),t(a,u);break;case\"scale\":e(a,u);break;case\"skewX\":i(a,u);break;case\"skewY\":r(a,u);break;case\"matrix\":a=u}h.push(a.concat()),a=s.concat()});for(var c=h[0];h.length>1;)h.shift(),c=p.util.multiplyTransformMatrices(c,h[0]);return c}}();var j=new RegExp(\"^\\\\s*(\"+p.reNum+\"+)\\\\s*,?\\\\s*(\"+p.reNum+\"+)\\\\s*,?\\\\s*(\"+p.reNum+\"+)\\\\s*,?\\\\s*(\"+p.reNum+\"+)\\\\s*$\");p.parseSVGDocument=function(){function t(t,e){for(;t&&(t=t.parentNode);)if(e.test(t.nodeName)&&!t.getAttribute(\"instantiated_by_use\"))return!0;return!1}return function(e,i,r){if(e){u(e);var n=new Date,s=p.Object.__uid++,o=f(e),a=p.util.toArray(e.getElementsByTagName(\"*\"));if(o.svgUid=s,0===a.length&&p.isLikelyNode){a=e.selectNodes('//*[name(.)!=\"svg\"]');for(var h=[],c=0,l=a.length;l>c;c++)h[c]=a[c];a=h}var d=a.filter(function(e){return f(e),S.test(e.tagName)&&!t(e,w)});if(!d||d&&!d.length)return void(i&&i([],{}));p.gradientDefs[s]=p.getGradientDefs(e),p.cssRules[s]=p.getCSSRules(e),p.parseElements(d,function(t){p.documentParsingTime=new Date-n,i&&i(t,o)},m(o),r)}}}();var A={has:function(t,e){e(!1)},get:function(){},set:function(){}},M=new RegExp(\"(normal|italic)?\\\\s*(normal|small-caps)?\\\\s*(normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900)?\\\\s*(\"+p.reNum+\"(?:px|cm|mm|em|pt|pc|in)*)(?:\\\\/(normal|\"+p.reNum+\"))?\\\\s+(.*)\");v(p,{parseFontDeclaration:function(t,e){var i=t.match(M);if(i){var r=i[1],n=i[3],s=i[4],o=i[5],a=i[6];r&&(e.fontStyle=r),n&&(e.fontWeight=isNaN(parseFloat(n))?n:parseFloat(n)),s&&(e.fontSize=_(s)),a&&(e.fontFamily=a),o&&(e.lineHeight=\"normal\"===o?1:o)}},getGradientDefs:function(t){var e,i,r,n,s=t.getElementsByTagName(\"linearGradient\"),o=t.getElementsByTagName(\"radialGradient\"),a=0,h=[],c={},l={};for(h.length=s.length+o.length,i=s.length;i--;)h[a++]=s[i];for(i=o.length;i--;)h[a++]=o[i];for(;a--;)e=h[a],n=e.getAttribute(\"xlink:href\"),r=e.getAttribute(\"id\"),n&&(l[r]=n.substr(1)),c[r]=e;for(r in l){var u=c[l[r]].cloneNode(!0);for(e=c[r];u.firstChild;)e.appendChild(u.firstChild)}return c},parseAttributes:function(t,n,s){if(t){var a,h,c={};\"undefined\"==typeof s&&(s=t.getAttribute(\"svgUid\")),t.parentNode&&O.test(t.parentNode.nodeName)&&(c=p.parseAttributes(t.parentNode,n,s)),h=c&&c.fontSize||t.getAttribute(\"font-size\")||p.Text.DEFAULT_SVG_FONT_SIZE;var l=n.reduce(function(r,n){return a=t.getAttribute(n),a&&(n=e(n),a=i(n,a,c,h),r[n]=a),r},{});return l=v(l,v(o(t,s),p.parseStyleAttribute(t))),l.font&&p.parseFontDeclaration(l.font,l),r(v(c,l))}},parseElements:function(t,e,i,r){new p.ElementsParser(t,e,i,r).parse()},parseStyleAttribute:function(t){var e={},i=t.getAttribute(\"style\");return i?(\"string\"==typeof i?n(i,e):s(i,e),e):e},parsePointsAttribute:function(t){if(!t)return null;t=t.replace(/,/g,\" \").trim(),t=t.split(/\\s+/);var e,i,r=[];for(e=0,i=t.length;i>e;e+=2)r.push({x:parseFloat(t[e]),y:parseFloat(t[e+1])});return r},getCSSRules:function(t){for(var r,n=t.getElementsByTagName(\"style\"),s={},o=0,a=n.length;a>o;o++){var h=n[o].textContent||n[o].text;h=h.replace(/\\/\\*[\\s\\S]*?\\*\\//g,\"\"),\"\"!==h.trim()&&(r=h.match(/[^{]*\\{[\\s\\S]*?\\}/g),r=r.map(function(t){return t.trim()}),r.forEach(function(t){for(var r=t.match(/([\\s\\S]*?)\\s*\\{([^}]*)\\}/),n={},o=r[2].trim(),a=o.replace(/;$/,\"\").split(/\\s*;\\s*/),h=0,c=a.length;c>h;h++){var l=a[h].split(/\\s*:\\s*/),u=e(l[0]),f=i(u,l[1],l[0]);n[u]=f}t=r[1],t.split(\",\").forEach(function(t){t=t.replace(/^svg/i,\"\").trim(),\"\"!==t&&(s[t]=p.util.object.clone(n))})}))}return s},loadSVGFromURL:function(t,e,i){function r(r){var n=r.responseXML;n&&!n.documentElement&&p.window.ActiveXObject&&r.responseText&&(n=new ActiveXObject(\"Microsoft.XMLDOM\"),n.async=\"false\",n.loadXML(r.responseText.replace(/<!DOCTYPE[\\s\\S]*?(\\[[\\s\\S]*\\])*?>/i,\"\"))),n&&n.documentElement&&p.parseSVGDocument(n.documentElement,function(i,r){A.set(t,{objects:p.util.array.invoke(i,\"toObject\"),options:r}),e(i,r)},i)}t=t.replace(/^\\n\\s*/,\"\").trim(),A.has(t,function(i){i?A.get(t,function(t){var i=d(t);e(i.objects,i.options)}):new p.util.request(t,{method:\"get\",onComplete:r})})},loadSVGFromString:function(t,e,i){t=t.trim();var r;if(\"undefined\"!=typeof DOMParser){var n=new DOMParser;n&&n.parseFromString&&(r=n.parseFromString(t,\"text/xml\"))}else p.window.ActiveXObject&&(r=new ActiveXObject(\"Microsoft.XMLDOM\"),r.async=\"false\",r.loadXML(t.replace(/<!DOCTYPE[\\s\\S]*?(\\[[\\s\\S]*\\])*?>/i,\"\")));p.parseSVGDocument(r.documentElement,function(t,i){e(t,i)},i)},createSVGFontFacesMarkup:function(t){for(var e,i,r,n,s,o,a,h=\"\",c={},l=p.fontPaths,u=0,f=t.length;f>u;u++)if(e=t[u],i=e.fontFamily,-1!==e.type.indexOf(\"text\")&&!c[i]&&l[i]&&(c[i]=!0,e.styles)){r=e.styles;for(s in r){n=r[s];for(a in n)o=n[a],i=o.fontFamily,!c[i]&&l[i]&&(c[i]=!0)}}for(var d in c)h+=[\"\t\t@font-face {\\n\",\"\t\t\tfont-family: '\",d,\"';\\n\",\"\t\t\tsrc: url('\",l[d],\"');\\n\",\"\t\t}\\n\"].join(\"\");return h&&(h=['\t<style type=\"text/css\">',\"<![CDATA[\\n\",h,\"]]>\",\"</style>\\n\"].join(\"\")),h},createSVGRefElementsMarkup:function(t){var e=[];return g(e,t,\"backgroundColor\"),g(e,t,\"overlayColor\"),e.join(\"\")}})}(\"undefined\"!=typeof exports?exports:this),fabric.ElementsParser=function(t,e,i,r){this.elements=t,this.callback=e,this.options=i,this.reviver=r,this.svgUid=i&&i.svgUid||0},fabric.ElementsParser.prototype.parse=function(){this.instances=new Array(this.elements.length),this.numElements=this.elements.length,this.createObjects()},fabric.ElementsParser.prototype.createObjects=function(){for(var t=0,e=this.elements.length;e>t;t++)this.elements[t].setAttribute(\"svgUid\",this.svgUid),function(t,e){setTimeout(function(){t.createObject(t.elements[e],e)},0)}(this,t)},fabric.ElementsParser.prototype.createObject=function(t,e){var i=fabric[fabric.util.string.capitalize(t.tagName)];if(i&&i.fromElement)try{this._createObject(i,t,e)}catch(r){fabric.log(r)}else this.checkIfDone()},fabric.ElementsParser.prototype._createObject=function(t,e,i){if(t.async)t.fromElement(e,this.createCallback(i,e),this.options);else{var r=t.fromElement(e,this.options);this.resolveGradient(r,\"fill\"),this.resolveGradient(r,\"stroke\"),this.reviver&&this.reviver(e,r),this.instances[i]=r,this.checkIfDone()}},fabric.ElementsParser.prototype.createCallback=function(t,e){var i=this;return function(r){i.resolveGradient(r,\"fill\"),i.resolveGradient(r,\"stroke\"),i.reviver&&i.reviver(e,r),i.instances[t]=r,i.checkIfDone()}},fabric.ElementsParser.prototype.resolveGradient=function(t,e){var i=t.get(e);if(/^url\\(/.test(i)){var r=i.slice(5,i.length-1);fabric.gradientDefs[this.svgUid][r]&&t.set(e,fabric.Gradient.fromElement(fabric.gradientDefs[this.svgUid][r],t))}},fabric.ElementsParser.prototype.checkIfDone=function(){0===--this.numElements&&(this.instances=this.instances.filter(function(t){return null!=t}),this.callback(this.instances))},function(t){\"use strict\";function e(t,e){this.x=t,this.y=e}var i=t.fabric||(t.fabric={});return i.Point?void i.warn(\"fabric.Point is already defined\"):(i.Point=e,void(e.prototype={constructor:e,add:function(t){return new e(this.x+t.x,this.y+t.y)},addEquals:function(t){return this.x+=t.x,this.y+=t.y,this},scalarAdd:function(t){return new e(this.x+t,this.y+t)},scalarAddEquals:function(t){return this.x+=t,this.y+=t,this},subtract:function(t){return new e(this.x-t.x,this.y-t.y)},subtractEquals:function(t){return this.x-=t.x,this.y-=t.y,this},scalarSubtract:function(t){return new e(this.x-t,this.y-t)},scalarSubtractEquals:function(t){return this.x-=t,this.y-=t,this},multiply:function(t){return new e(this.x*t,this.y*t)},multiplyEquals:function(t){return this.x*=t,this.y*=t,this},divide:function(t){return new e(this.x/t,this.y/t)},divideEquals:function(t){return this.x/=t,this.y/=t,this},eq:function(t){return this.x===t.x&&this.y===t.y},lt:function(t){return this.x<t.x&&this.y<t.y},lte:function(t){return this.x<=t.x&&this.y<=t.y},gt:function(t){return this.x>t.x&&this.y>t.y},gte:function(t){return this.x>=t.x&&this.y>=t.y},lerp:function(t,i){return new e(this.x+(t.x-this.x)*i,this.y+(t.y-this.y)*i)},distanceFrom:function(t){var e=this.x-t.x,i=this.y-t.y;return Math.sqrt(e*e+i*i)},midPointFrom:function(t){return new e(this.x+(t.x-this.x)/2,this.y+(t.y-this.y)/2)},min:function(t){return new e(Math.min(this.x,t.x),Math.min(this.y,t.y))},max:function(t){return new e(Math.max(this.x,t.x),Math.max(this.y,t.y))},toString:function(){return this.x+\",\"+this.y},setXY:function(t,e){this.x=t,this.y=e},setFromPoint:function(t){this.x=t.x,this.y=t.y},swap:function(t){var e=this.x,i=this.y;this.x=t.x,this.y=t.y,t.x=e,t.y=i}}))}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";function e(t){this.status=t,this.points=[]}var i=t.fabric||(t.fabric={});return i.Intersection?void i.warn(\"fabric.Intersection is already defined\"):(i.Intersection=e,i.Intersection.prototype={appendPoint:function(t){this.points.push(t)},appendPoints:function(t){this.points=this.points.concat(t)}},i.Intersection.intersectLineLine=function(t,r,n,s){var o,a=(s.x-n.x)*(t.y-n.y)-(s.y-n.y)*(t.x-n.x),h=(r.x-t.x)*(t.y-n.y)-(r.y-t.y)*(t.x-n.x),c=(s.y-n.y)*(r.x-t.x)-(s.x-n.x)*(r.y-t.y);if(0!==c){var l=a/c,u=h/c;l>=0&&1>=l&&u>=0&&1>=u?(o=new e(\"Intersection\"),o.points.push(new i.Point(t.x+l*(r.x-t.x),t.y+l*(r.y-t.y)))):o=new e}else o=new e(0===a||0===h?\"Coincident\":\"Parallel\");return o},i.Intersection.intersectLinePolygon=function(t,i,r){for(var n=new e,s=r.length,o=0;s>o;o++){var a=r[o],h=r[(o+1)%s],c=e.intersectLineLine(t,i,a,h);n.appendPoints(c.points)}return n.points.length>0&&(n.status=\"Intersection\"),n},i.Intersection.intersectPolygonPolygon=function(t,i){for(var r=new e,n=t.length,s=0;n>s;s++){var o=t[s],a=t[(s+1)%n],h=e.intersectLinePolygon(o,a,i);r.appendPoints(h.points)}return r.points.length>0&&(r.status=\"Intersection\"),r},void(i.Intersection.intersectPolygonRectangle=function(t,r,n){var s=r.min(n),o=r.max(n),a=new i.Point(o.x,s.y),h=new i.Point(s.x,o.y),c=e.intersectLinePolygon(s,a,t),l=e.intersectLinePolygon(a,o,t),u=e.intersectLinePolygon(o,h,t),f=e.intersectLinePolygon(h,s,t),d=new e;return d.appendPoints(c.points),d.appendPoints(l.points),d.appendPoints(u.points),d.appendPoints(f.points),d.points.length>0&&(d.status=\"Intersection\"),d}))}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";function e(t){t?this._tryParsingColor(t):this.setSource([0,0,0,1])}function i(t,e,i){return 0>i&&(i+=1),i>1&&(i-=1),1/6>i?t+6*(e-t)*i:.5>i?e:2/3>i?t+(e-t)*(2/3-i)*6:t}var r=t.fabric||(t.fabric={});return r.Color?void r.warn(\"fabric.Color is already defined.\"):(r.Color=e,r.Color.prototype={_tryParsingColor:function(t){var i;t in e.colorNameMap&&(t=e.colorNameMap[t]),\"transparent\"===t&&(i=[255,255,255,0]),i||(i=e.sourceFromHex(t)),i||(i=e.sourceFromRgb(t)),i||(i=e.sourceFromHsl(t)),i||(i=[0,0,0,1]),i&&this.setSource(i)},_rgbToHsl:function(t,e,i){t/=255,e/=255,i/=255;var n,s,o,a=r.util.array.max([t,e,i]),h=r.util.array.min([t,e,i]);if(o=(a+h)/2,a===h)n=s=0;else{var c=a-h;switch(s=o>.5?c/(2-a-h):c/(a+h),a){case t:n=(e-i)/c+(i>e?6:0);break;case e:n=(i-t)/c+2;break;case i:n=(t-e)/c+4}n/=6}return[Math.round(360*n),Math.round(100*s),Math.round(100*o)]},getSource:function(){return this._source},setSource:function(t){this._source=t},toRgb:function(){var t=this.getSource();return\"rgb(\"+t[0]+\",\"+t[1]+\",\"+t[2]+\")\"},toRgba:function(){var t=this.getSource();return\"rgba(\"+t[0]+\",\"+t[1]+\",\"+t[2]+\",\"+t[3]+\")\"},toHsl:function(){var t=this.getSource(),e=this._rgbToHsl(t[0],t[1],t[2]);return\"hsl(\"+e[0]+\",\"+e[1]+\"%,\"+e[2]+\"%)\"},toHsla:function(){var t=this.getSource(),e=this._rgbToHsl(t[0],t[1],t[2]);return\"hsla(\"+e[0]+\",\"+e[1]+\"%,\"+e[2]+\"%,\"+t[3]+\")\"},toHex:function(){var t,e,i,r=this.getSource();return t=r[0].toString(16),t=1===t.length?\"0\"+t:t,e=r[1].toString(16),e=1===e.length?\"0\"+e:e,i=r[2].toString(16),i=1===i.length?\"0\"+i:i,t.toUpperCase()+e.toUpperCase()+i.toUpperCase()},getAlpha:function(){return this.getSource()[3]},setAlpha:function(t){var e=this.getSource();return e[3]=t,this.setSource(e),this},toGrayscale:function(){var t=this.getSource(),e=parseInt((.3*t[0]+.59*t[1]+.11*t[2]).toFixed(0),10),i=t[3];return this.setSource([e,e,e,i]),this},toBlackWhite:function(t){var e=this.getSource(),i=(.3*e[0]+.59*e[1]+.11*e[2]).toFixed(0),r=e[3];return t=t||127,i=Number(i)<Number(t)?0:255,this.setSource([i,i,i,r]),this},overlayWith:function(t){t instanceof e||(t=new e(t));for(var i=[],r=this.getAlpha(),n=.5,s=this.getSource(),o=t.getSource(),a=0;3>a;a++)i.push(Math.round(s[a]*(1-n)+o[a]*n));return i[3]=r,this.setSource(i),this}},r.Color.reRGBa=/^rgba?\\(\\s*(\\d{1,3}(?:\\.\\d+)?\\%?)\\s*,\\s*(\\d{1,3}(?:\\.\\d+)?\\%?)\\s*,\\s*(\\d{1,3}(?:\\.\\d+)?\\%?)\\s*(?:\\s*,\\s*(\\d+(?:\\.\\d+)?)\\s*)?\\)$/,r.Color.reHSLa=/^hsla?\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3}\\%)\\s*,\\s*(\\d{1,3}\\%)\\s*(?:\\s*,\\s*(\\d+(?:\\.\\d+)?)\\s*)?\\)$/,r.Color.reHex=/^#?([0-9a-f]{6}|[0-9a-f]{3})$/i,r.Color.colorNameMap={aqua:\"#00FFFF\",black:\"#000000\",blue:\"#0000FF\",fuchsia:\"#FF00FF\",gray:\"#808080\",grey:\"#808080\",green:\"#008000\",lime:\"#00FF00\",maroon:\"#800000\",navy:\"#000080\",olive:\"#808000\",orange:\"#FFA500\",purple:\"#800080\",red:\"#FF0000\",silver:\"#C0C0C0\",teal:\"#008080\",white:\"#FFFFFF\",yellow:\"#FFFF00\"},r.Color.fromRgb=function(t){return e.fromSource(e.sourceFromRgb(t))},r.Color.sourceFromRgb=function(t){var i=t.match(e.reRGBa);if(i){var r=parseInt(i[1],10)/(/%$/.test(i[1])?100:1)*(/%$/.test(i[1])?255:1),n=parseInt(i[2],10)/(/%$/.test(i[2])?100:1)*(/%$/.test(i[2])?255:1),s=parseInt(i[3],10)/(/%$/.test(i[3])?100:1)*(/%$/.test(i[3])?255:1);return[parseInt(r,10),parseInt(n,10),parseInt(s,10),i[4]?parseFloat(i[4]):1]}},r.Color.fromRgba=e.fromRgb,r.Color.fromHsl=function(t){return e.fromSource(e.sourceFromHsl(t))},r.Color.sourceFromHsl=function(t){var r=t.match(e.reHSLa);if(r){var n,s,o,a=(parseFloat(r[1])%360+360)%360/360,h=parseFloat(r[2])/(/%$/.test(r[2])?100:1),c=parseFloat(r[3])/(/%$/.test(r[3])?100:1);if(0===h)n=s=o=c;else{var l=.5>=c?c*(h+1):c+h-c*h,u=2*c-l;n=i(u,l,a+1/3),s=i(u,l,a),o=i(u,l,a-1/3)}return[Math.round(255*n),Math.round(255*s),Math.round(255*o),r[4]?parseFloat(r[4]):1]}},r.Color.fromHsla=e.fromHsl,r.Color.fromHex=function(t){return e.fromSource(e.sourceFromHex(t))},r.Color.sourceFromHex=function(t){if(t.match(e.reHex)){var i=t.slice(t.indexOf(\"#\")+1),r=3===i.length,n=r?i.charAt(0)+i.charAt(0):i.substring(0,2),s=r?i.charAt(1)+i.charAt(1):i.substring(2,4),o=r?i.charAt(2)+i.charAt(2):i.substring(4,6);return[parseInt(n,16),parseInt(s,16),parseInt(o,16),1]}},void(r.Color.fromSource=function(t){var i=new e;return i.setSource(t),i}))}(\"undefined\"!=typeof exports?exports:this),function(){function t(t){var e,i,r,n=t.getAttribute(\"style\"),s=t.getAttribute(\"offset\")||0;if(s=parseFloat(s)/(/%$/.test(s)?100:1),s=0>s?0:s>1?1:s,n){var o=n.split(/\\s*;\\s*/);\"\"===o[o.length-1]&&o.pop();for(var a=o.length;a--;){var h=o[a].split(/\\s*:\\s*/),c=h[0].trim(),l=h[1].trim();\"stop-color\"===c?e=l:\"stop-opacity\"===c&&(r=l)}}return e||(e=t.getAttribute(\"stop-color\")||\"rgb(0,0,0)\"),r||(r=t.getAttribute(\"stop-opacity\")),e=new fabric.Color(e),i=e.getAlpha(),r=isNaN(parseFloat(r))?1:parseFloat(r),r*=i,{offset:s,color:e.toRgb(),opacity:r}}function e(t){return{x1:t.getAttribute(\"x1\")||0,y1:t.getAttribute(\"y1\")||0,x2:t.getAttribute(\"x2\")||\"100%\",y2:t.getAttribute(\"y2\")||0}}function i(t){return{x1:t.getAttribute(\"fx\")||t.getAttribute(\"cx\")||\"50%\",y1:t.getAttribute(\"fy\")||t.getAttribute(\"cy\")||\"50%\",r1:0,x2:t.getAttribute(\"cx\")||\"50%\",y2:t.getAttribute(\"cy\")||\"50%\",r2:t.getAttribute(\"r\")||\"50%\"}}function r(t,e,i){var r,n=0,s=1,o=\"\";for(var a in e)r=parseFloat(e[a],10),s=\"string\"==typeof e[a]&&/^\\d+%$/.test(e[a])?.01:1,\"x1\"===a||\"x2\"===a||\"r2\"===a?(s*=\"objectBoundingBox\"===i?t.width:1,n=\"objectBoundingBox\"===i?t.left||0:0):\"y1\"!==a&&\"y2\"!==a||(s*=\"objectBoundingBox\"===i?t.height:1,n=\"objectBoundingBox\"===i?t.top||0:0),e[a]=r*s+n;if(\"ellipse\"===t.type&&null!==e.r2&&\"objectBoundingBox\"===i&&t.rx!==t.ry){var h=t.ry/t.rx;o=\" scale(1, \"+h+\")\",e.y1&&(e.y1/=h),e.y2&&(e.y2/=h)}return o}fabric.Gradient=fabric.util.createClass({offsetX:0,offsetY:0,initialize:function(t){t||(t={});var e={};this.id=fabric.Object.__uid++,this.type=t.type||\"linear\",e={x1:t.coords.x1||0,y1:t.coords.y1||0,x2:t.coords.x2||0,y2:t.coords.y2||0},\"radial\"===this.type&&(e.r1=t.coords.r1||0,e.r2=t.coords.r2||0),this.coords=e,this.colorStops=t.colorStops.slice(),t.gradientTransform&&(this.gradientTransform=t.gradientTransform),this.offsetX=t.offsetX||this.offsetX,this.offsetY=t.offsetY||this.offsetY},addColorStop:function(t){for(var e in t){var i=new fabric.Color(t[e]);this.colorStops.push({offset:e,color:i.toRgb(),opacity:i.getAlpha()})}return this},toObject:function(){return{type:this.type,coords:this.coords,colorStops:this.colorStops,offsetX:this.offsetX,offsetY:this.offsetY,gradientTransform:this.gradientTransform?this.gradientTransform.concat():this.gradientTransform}},toSVG:function(t){var e,i,r=fabric.util.object.clone(this.coords);if(this.colorStops.sort(function(t,e){return t.offset-e.offset}),!t.group||\"path-group\"!==t.group.type)for(var n in r)\"x1\"===n||\"x2\"===n||\"r2\"===n?r[n]+=this.offsetX-t.width/2:\"y1\"!==n&&\"y2\"!==n||(r[n]+=this.offsetY-t.height/2);i='id=\"SVGID_'+this.id+'\" gradientUnits=\"userSpaceOnUse\"',this.gradientTransform&&(i+=' gradientTransform=\"matrix('+this.gradientTransform.join(\" \")+')\" '),\"linear\"===this.type?e=[\"<linearGradient \",i,' x1=\"',r.x1,'\" y1=\"',r.y1,'\" x2=\"',r.x2,'\" y2=\"',r.y2,'\">\\n']:\"radial\"===this.type&&(e=[\"<radialGradient \",i,' cx=\"',r.x2,'\" cy=\"',r.y2,'\" r=\"',r.r2,'\" fx=\"',r.x1,'\" fy=\"',r.y1,'\">\\n']);for(var s=0;s<this.colorStops.length;s++)e.push(\"<stop \",'offset=\"',100*this.colorStops[s].offset+\"%\",'\" style=\"stop-color:',this.colorStops[s].color,null!=this.colorStops[s].opacity?\";stop-opacity: \"+this.colorStops[s].opacity:\";\",'\"/>\\n');return e.push(\"linear\"===this.type?\"</linearGradient>\\n\":\"</radialGradient>\\n\"),e.join(\"\")},toLive:function(t,e){var i,r,n=fabric.util.object.clone(this.coords);if(this.type){if(e.group&&\"path-group\"===e.group.type)for(r in n)\"x1\"===r||\"x2\"===r?n[r]+=-this.offsetX+e.width/2:\"y1\"!==r&&\"y2\"!==r||(n[r]+=-this.offsetY+e.height/2);\"linear\"===this.type?i=t.createLinearGradient(n.x1,n.y1,n.x2,n.y2):\"radial\"===this.type&&(i=t.createRadialGradient(n.x1,n.y1,n.r1,n.x2,n.y2,n.r2));for(var s=0,o=this.colorStops.length;o>s;s++){var a=this.colorStops[s].color,h=this.colorStops[s].opacity,c=this.colorStops[s].offset;\"undefined\"!=typeof h&&(a=new fabric.Color(a).setAlpha(h).toRgba()),i.addColorStop(parseFloat(c),a)}return i}}}),fabric.util.object.extend(fabric.Gradient,{fromElement:function(n,s){var o,a=n.getElementsByTagName(\"stop\"),h=\"linearGradient\"===n.nodeName?\"linear\":\"radial\",c=n.getAttribute(\"gradientUnits\")||\"objectBoundingBox\",l=n.getAttribute(\"gradientTransform\"),u=[],f={};\"linear\"===h?f=e(n):\"radial\"===h&&(f=i(n));for(var d=a.length;d--;)u.push(t(a[d]));o=r(s,f,c);var g=new fabric.Gradient({type:h,coords:f,colorStops:u,offsetX:-s.left,offsetY:-s.top});return(l||\"\"!==o)&&(g.gradientTransform=fabric.parseTransformAttribute((l||\"\")+o)),g},forObject:function(t,e){return e||(e={}),r(t,e.coords,\"userSpaceOnUse\"),new fabric.Gradient(e)}})}(),fabric.Pattern=fabric.util.createClass({repeat:\"repeat\",offsetX:0,offsetY:0,initialize:function(t){if(t||(t={}),this.id=fabric.Object.__uid++,t.source)if(\"string\"==typeof t.source)if(\"undefined\"!=typeof fabric.util.getFunctionBody(t.source))this.source=new Function(fabric.util.getFunctionBody(t.source));else{var e=this;this.source=fabric.util.createImage(),fabric.util.loadImage(t.source,function(t){e.source=t})}else this.source=t.source;t.repeat&&(this.repeat=t.repeat),t.offsetX&&(this.offsetX=t.offsetX),t.offsetY&&(this.offsetY=t.offsetY)},toObject:function(){var t;return\"function\"==typeof this.source?t=String(this.source):\"string\"==typeof this.source.src?t=this.source.src:\"object\"==typeof this.source&&this.source.toDataURL&&(t=this.source.toDataURL()),{source:t,repeat:this.repeat,offsetX:this.offsetX,offsetY:this.offsetY}},toSVG:function(t){var e=\"function\"==typeof this.source?this.source():this.source,i=e.width/t.getWidth(),r=e.height/t.getHeight(),n=this.offsetX/t.getWidth(),s=this.offsetY/t.getHeight(),o=\"\";return\"repeat-x\"!==this.repeat&&\"no-repeat\"!==this.repeat||(r=1),\"repeat-y\"!==this.repeat&&\"no-repeat\"!==this.repeat||(i=1),e.src?o=e.src:e.toDataURL&&(o=e.toDataURL()),'<pattern id=\"SVGID_'+this.id+'\" x=\"'+n+'\" y=\"'+s+'\" width=\"'+i+'\" height=\"'+r+'\">\\n<image x=\"0\" y=\"0\" width=\"'+e.width+'\" height=\"'+e.height+'\" xlink:href=\"'+o+'\"></image>\\n</pattern>\\n'},toLive:function(t){var e=\"function\"==typeof this.source?this.source():this.source;if(!e)return\"\";if(\"undefined\"!=typeof e.src){if(!e.complete)return\"\";if(0===e.naturalWidth||0===e.naturalHeight)return\"\"}return t.createPattern(e,this.repeat)}}),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.toFixed;return e.Shadow?void e.warn(\"fabric.Shadow is already defined.\"):(e.Shadow=e.util.createClass({color:\"rgb(0,0,0)\",blur:0,offsetX:0,offsetY:0,affectStroke:!1,includeDefaultValues:!0,initialize:function(t){\"string\"==typeof t&&(t=this._parseShadow(t));for(var i in t)this[i]=t[i];this.id=e.Object.__uid++},_parseShadow:function(t){var i=t.trim(),r=e.Shadow.reOffsetsAndBlur.exec(i)||[],n=i.replace(e.Shadow.reOffsetsAndBlur,\"\")||\"rgb(0,0,0)\";return{color:n.trim(),offsetX:parseInt(r[1],10)||0,offsetY:parseInt(r[2],10)||0,blur:parseInt(r[3],10)||0}},toString:function(){return[this.offsetX,this.offsetY,this.blur,this.color].join(\"px \")},toSVG:function(t){var r=40,n=40,s=e.Object.NUM_FRACTION_DIGITS,o=e.util.rotateVector({x:this.offsetX,y:this.offsetY},e.util.degreesToRadians(-t.angle)),a=20;return t.width&&t.height&&(r=100*i((Math.abs(o.x)+this.blur)/t.width,s)+a,n=100*i((Math.abs(o.y)+this.blur)/t.height,s)+a),t.flipX&&(o.x*=-1),t.flipY&&(o.y*=-1),'<filter id=\"SVGID_'+this.id+'\" y=\"-'+n+'%\" height=\"'+(100+2*n)+'%\" x=\"-'+r+'%\" width=\"'+(100+2*r)+'%\" >\\n\t<feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"'+i(this.blur?this.blur/2:0,s)+'\"></feGaussianBlur>\\n\t<feOffset dx=\"'+i(o.x,s)+'\" dy=\"'+i(o.y,s)+'\" result=\"oBlur\" ></feOffset>\\n\t<feFlood flood-color=\"'+this.color+'\"/>\\n\t<feComposite in2=\"oBlur\" operator=\"in\" />\\n\t<feMerge>\\n\t\t<feMergeNode></feMergeNode>\\n\t\t<feMergeNode in=\"SourceGraphic\"></feMergeNode>\\n\t</feMerge>\\n</filter>\\n'},toObject:function(){if(this.includeDefaultValues)return{color:this.color,blur:this.blur,offsetX:this.offsetX,offsetY:this.offsetY,affectStroke:this.affectStroke};var t={},i=e.Shadow.prototype;return[\"color\",\"blur\",\"offsetX\",\"offsetY\",\"affectStroke\"].forEach(function(e){this[e]!==i[e]&&(t[e]=this[e])},this),t}}),void(e.Shadow.reOffsetsAndBlur=/(?:\\s|^)(-?\\d+(?:px)?(?:\\s?|$))?(-?\\d+(?:px)?(?:\\s?|$))?(\\d+(?:px)?)?(?:\\s?|$)(?:$|\\s)/))}(\"undefined\"!=typeof exports?exports:this),function(){\"use strict\";if(fabric.StaticCanvas)return void fabric.warn(\"fabric.StaticCanvas is already defined.\");var t=fabric.util.object.extend,e=fabric.util.getElementOffset,i=fabric.util.removeFromArray,r=fabric.util.toFixed,n=new Error(\"Could not initialize `canvas` element\");fabric.StaticCanvas=fabric.util.createClass({initialize:function(t,e){e||(e={}),this._initStatic(t,e)},backgroundColor:\"\",backgroundImage:null,overlayColor:\"\",overlayImage:null,includeDefaultValues:!0,stateful:!0,renderOnAddRemove:!0,clipTo:null,controlsAboveOverlay:!1,allowTouchScrolling:!1,imageSmoothingEnabled:!0,preserveObjectStacking:!1,viewportTransform:[1,0,0,1,0,0],onBeforeScaleRotate:function(){},enableRetinaScaling:!0,_initStatic:function(t,e){this._objects=[],this._createLowerCanvas(t),this._initOptions(e),this._setImageSmoothing(),this.interactive||this._initRetinaScaling(),e.overlayImage&&this.setOverlayImage(e.overlayImage,this.renderAll.bind(this)),e.backgroundImage&&this.setBackgroundImage(e.backgroundImage,this.renderAll.bind(this)),e.backgroundColor&&this.setBackgroundColor(e.backgroundColor,this.renderAll.bind(this)),e.overlayColor&&this.setOverlayColor(e.overlayColor,this.renderAll.bind(this)),this.calcOffset()},_isRetinaScaling:function(){return 1!==fabric.devicePixelRatio&&this.enableRetinaScaling},_initRetinaScaling:function(){this._isRetinaScaling()&&(this.lowerCanvasEl.setAttribute(\"width\",this.width*fabric.devicePixelRatio),this.lowerCanvasEl.setAttribute(\"height\",this.height*fabric.devicePixelRatio),this.contextContainer.scale(fabric.devicePixelRatio,fabric.devicePixelRatio))},calcOffset:function(){return this._offset=e(this.lowerCanvasEl),this},setOverlayImage:function(t,e,i){return this.__setBgOverlayImage(\"overlayImage\",t,e,i)},setBackgroundImage:function(t,e,i){return this.__setBgOverlayImage(\"backgroundImage\",t,e,i)},setOverlayColor:function(t,e){return this.__setBgOverlayColor(\"overlayColor\",t,e)},setBackgroundColor:function(t,e){return this.__setBgOverlayColor(\"backgroundColor\",t,e)},_setImageSmoothing:function(){var t=this.getContext();t.imageSmoothingEnabled=t.imageSmoothingEnabled||t.webkitImageSmoothingEnabled||t.mozImageSmoothingEnabled||t.msImageSmoothingEnabled||t.oImageSmoothingEnabled,t.imageSmoothingEnabled=this.imageSmoothingEnabled},__setBgOverlayImage:function(t,e,i,r){return\"string\"==typeof e?fabric.util.loadImage(e,function(e){this[t]=new fabric.Image(e,r),i&&i(e)},this,r&&r.crossOrigin):(r&&e.setOptions(r),this[t]=e,i&&i(e)),this},__setBgOverlayColor:function(t,e,i){if(e&&e.source){var r=this;fabric.util.loadImage(e.source,function(n){r[t]=new fabric.Pattern({source:n,repeat:e.repeat,offsetX:e.offsetX,offsetY:e.offsetY}),i&&i()})}else this[t]=e,i&&i();return this},_createCanvasElement:function(){var t=fabric.document.createElement(\"canvas\");if(t.style||(t.style={}),!t)throw n;return this._initCanvasElement(t),t},_initCanvasElement:function(t){if(fabric.util.createCanvasElement(t),\"undefined\"==typeof t.getContext)throw n},_initOptions:function(t){for(var e in t)this[e]=t[e];this.width=this.width||parseInt(this.lowerCanvasEl.width,10)||0,this.height=this.height||parseInt(this.lowerCanvasEl.height,10)||0,this.lowerCanvasEl.style&&(this.lowerCanvasEl.width=this.width,this.lowerCanvasEl.height=this.height,this.lowerCanvasEl.style.width=this.width+\"px\",this.lowerCanvasEl.style.height=this.height+\"px\",this.viewportTransform=this.viewportTransform.slice())},_createLowerCanvas:function(t){this.lowerCanvasEl=fabric.util.getById(t)||this._createCanvasElement(),this._initCanvasElement(this.lowerCanvasEl),fabric.util.addClass(this.lowerCanvasEl,\"lower-canvas\"),this.interactive&&this._applyCanvasStyle(this.lowerCanvasEl),this.contextContainer=this.lowerCanvasEl.getContext(\"2d\")},getWidth:function(){return this.width},getHeight:function(){return this.height},setWidth:function(t,e){return this.setDimensions({width:t},e)},setHeight:function(t,e){return this.setDimensions({height:t},e)},setDimensions:function(t,e){var i;e=e||{};for(var r in t)i=t[r],e.cssOnly||(this._setBackstoreDimension(r,t[r]),i+=\"px\"),e.backstoreOnly||this._setCssDimension(r,i);return this._initRetinaScaling(),this._setImageSmoothing(),this.calcOffset(),e.cssOnly||this.renderAll(),this},_setBackstoreDimension:function(t,e){return this.lowerCanvasEl[t]=e,this.upperCanvasEl&&(this.upperCanvasEl[t]=e),this.cacheCanvasEl&&(this.cacheCanvasEl[t]=e),this[t]=e,this},_setCssDimension:function(t,e){return this.lowerCanvasEl.style[t]=e,this.upperCanvasEl&&(this.upperCanvasEl.style[t]=e),this.wrapperEl&&(this.wrapperEl.style[t]=e),this},getZoom:function(){return Math.sqrt(this.viewportTransform[0]*this.viewportTransform[3])},setViewportTransform:function(t){var e=this.getActiveGroup();this.viewportTransform=t,this.renderAll();for(var i=0,r=this._objects.length;r>i;i++)this._objects[i].setCoords();return e&&e.setCoords(),this},zoomToPoint:function(t,e){var i=t;t=fabric.util.transformPoint(t,fabric.util.invertTransform(this.viewportTransform)),this.viewportTransform[0]=e,this.viewportTransform[3]=e;var r=fabric.util.transformPoint(t,this.viewportTransform);this.viewportTransform[4]+=i.x-r.x,this.viewportTransform[5]+=i.y-r.y,this.renderAll();for(var n=0,s=this._objects.length;s>n;n++)this._objects[n].setCoords();return this},setZoom:function(t){return this.zoomToPoint(new fabric.Point(0,0),t),this},absolutePan:function(t){this.viewportTransform[4]=-t.x,this.viewportTransform[5]=-t.y,this.renderAll();for(var e=0,i=this._objects.length;i>e;e++)this._objects[e].setCoords();return this},relativePan:function(t){return this.absolutePan(new fabric.Point(-t.x-this.viewportTransform[4],-t.y-this.viewportTransform[5]))},getElement:function(){return this.lowerCanvasEl},getActiveObject:function(){return null},getActiveGroup:function(){return null},_onObjectAdded:function(t){this.stateful&&t.setupState(),t._set(\"canvas\",this),t.setCoords(),this.fire(\"object:added\",{target:t}),t.fire(\"added\")},_onObjectRemoved:function(t){this.getActiveObject()===t&&(this.fire(\"before:selection:cleared\",{target:t}),this._discardActiveObject(),this.fire(\"selection:cleared\")),this.fire(\"object:removed\",{target:t}),t.fire(\"removed\")},clearContext:function(t){return t.clearRect(0,0,this.width,this.height),this},getContext:function(){return this.contextContainer},clear:function(){return this._objects.length=0,this.discardActiveGroup&&this.discardActiveGroup(),this.discardActiveObject&&this.discardActiveObject(),this.clearContext(this.contextContainer),this.contextTop&&this.clearContext(this.contextTop),this.fire(\"canvas:cleared\"),this.renderAll(),this},_chooseObjectsToRender:function(){var t,e=this.getActiveGroup(),i=[],r=[];if(e&&!this.preserveObjectStacking){for(var n=0,s=this._objects.length;s>n;n++)t=this._objects[n],e.contains(t)?r.push(t):i.push(t);e._set(\"_objects\",r)}else i=this._objects;return i},renderAll:function(){var t,e=this.contextContainer;return this.contextTop&&this.selection&&!this._groupSelector&&!this.isDrawingMode&&this.clearContext(this.contextTop),this.clearContext(e),this.fire(\"before:render\"),this.clipTo&&fabric.util.clipContext(this,e),this._renderBackground(e),e.save(),t=this._chooseObjectsToRender(),e.transform.apply(e,this.viewportTransform),this._renderObjects(e,t),this.preserveObjectStacking||this._renderObjects(e,[this.getActiveGroup()]),e.restore(),!this.controlsAboveOverlay&&this.interactive&&this.drawControls(e),this.clipTo&&e.restore(),this._renderOverlay(e),this.controlsAboveOverlay&&this.interactive&&this.drawControls(e),this.fire(\"after:render\"),this},_renderObjects:function(t,e){for(var i=0,r=e.length;r>i;++i)e[i]&&e[i].render(t)},_renderBackgroundOrOverlay:function(t,e){var i=this[e+\"Color\"];i&&(t.fillStyle=i.toLive?i.toLive(t):i,t.fillRect(i.offsetX||0,i.offsetY||0,this.width,this.height)),i=this[e+\"Image\"],i&&i.render(t)},_renderBackground:function(t){this._renderBackgroundOrOverlay(t,\"background\")},_renderOverlay:function(t){this._renderBackgroundOrOverlay(t,\"overlay\")},renderTop:function(){var t=this.contextTop||this.contextContainer;return this.clearContext(t),this.selection&&this._groupSelector&&this._drawSelection(),this.fire(\"after:render\"),this},getCenter:function(){return{top:this.getHeight()/2,left:this.getWidth()/2}},centerObjectH:function(t){return this._centerObject(t,new fabric.Point(this.getCenter().left,t.getCenterPoint().y)),this.renderAll(),this},centerObjectV:function(t){return this._centerObject(t,new fabric.Point(t.getCenterPoint().x,this.getCenter().top)),this.renderAll(),this},centerObject:function(t){var e=this.getCenter();return this._centerObject(t,new fabric.Point(e.left,e.top)),this.renderAll(),this},_centerObject:function(t,e){return t.setPositionByOrigin(e,\"center\",\"center\"),this},toDatalessJSON:function(t){return this.toDatalessObject(t)},toObject:function(t){return this._toObjectMethod(\"toObject\",t)},toDatalessObject:function(t){return this._toObjectMethod(\"toDatalessObject\",t)},_toObjectMethod:function(e,i){var r={objects:this._toObjects(e,i)};return t(r,this.__serializeBgOverlay()),fabric.util.populateWithProperties(this,r,i),r},_toObjects:function(t,e){return this.getObjects().map(function(i){\nreturn this._toObject(i,t,e)},this)},_toObject:function(t,e,i){var r;this.includeDefaultValues||(r=t.includeDefaultValues,t.includeDefaultValues=!1);var n=this._realizeGroupTransformOnObject(t),s=t[e](i);return this.includeDefaultValues||(t.includeDefaultValues=r),this._unwindGroupTransformOnObject(t,n),s},_realizeGroupTransformOnObject:function(t){var e=[\"angle\",\"flipX\",\"flipY\",\"height\",\"left\",\"scaleX\",\"scaleY\",\"top\",\"width\"];if(t.group&&t.group===this.getActiveGroup()){var i={};return e.forEach(function(e){i[e]=t[e]}),this.getActiveGroup().realizeTransform(t),i}return null},_unwindGroupTransformOnObject:function(t,e){e&&t.set(e)},__serializeBgOverlay:function(){var t={background:this.backgroundColor&&this.backgroundColor.toObject?this.backgroundColor.toObject():this.backgroundColor};return this.overlayColor&&(t.overlay=this.overlayColor.toObject?this.overlayColor.toObject():this.overlayColor),this.backgroundImage&&(t.backgroundImage=this.backgroundImage.toObject()),this.overlayImage&&(t.overlayImage=this.overlayImage.toObject()),t},svgViewportTransformation:!0,toSVG:function(t,e){t||(t={});var i=[];return this._setSVGPreamble(i,t),this._setSVGHeader(i,t),this._setSVGBgOverlayColor(i,\"backgroundColor\"),this._setSVGBgOverlayImage(i,\"backgroundImage\"),this._setSVGObjects(i,e),this._setSVGBgOverlayColor(i,\"overlayColor\"),this._setSVGBgOverlayImage(i,\"overlayImage\"),i.push(\"</svg>\"),i.join(\"\")},_setSVGPreamble:function(t,e){e.suppressPreamble||t.push('<?xml version=\"1.0\" encoding=\"',e.encoding||\"UTF-8\",'\" standalone=\"no\" ?>\\n','<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" ','\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\\n')},_setSVGHeader:function(t,e){var i,n=e.width||this.width,s=e.height||this.height,o='viewBox=\"0 0 '+this.width+\" \"+this.height+'\" ',a=fabric.Object.NUM_FRACTION_DIGITS;e.viewBox?o='viewBox=\"'+e.viewBox.x+\" \"+e.viewBox.y+\" \"+e.viewBox.width+\" \"+e.viewBox.height+'\" ':this.svgViewportTransformation&&(i=this.viewportTransform,o='viewBox=\"'+r(-i[4]/i[0],a)+\" \"+r(-i[5]/i[3],a)+\" \"+r(this.width/i[0],a)+\" \"+r(this.height/i[3],a)+'\" '),t.push(\"<svg \",'xmlns=\"http://www.w3.org/2000/svg\" ','xmlns:xlink=\"http://www.w3.org/1999/xlink\" ','version=\"1.1\" ','width=\"',n,'\" ','height=\"',s,'\" ',this.backgroundColor&&!this.backgroundColor.toLive?'style=\"background-color: '+this.backgroundColor+'\" ':null,o,'xml:space=\"preserve\">\\n',\"<desc>Created with Fabric.js \",fabric.version,\"</desc>\\n\",\"<defs>\",fabric.createSVGFontFacesMarkup(this.getObjects()),fabric.createSVGRefElementsMarkup(this),\"</defs>\\n\")},_setSVGObjects:function(t,e){for(var i=0,r=this.getObjects(),n=r.length;n>i;i++){var s=r[i],o=this._realizeGroupTransformOnObject(s);t.push(s.toSVG(e)),this._unwindGroupTransformOnObject(s,o)}},_setSVGBgOverlayImage:function(t,e){this[e]&&this[e].toSVG&&t.push(this[e].toSVG())},_setSVGBgOverlayColor:function(t,e){this[e]&&this[e].source?t.push('<rect x=\"',this[e].offsetX,'\" y=\"',this[e].offsetY,'\" ','width=\"',\"repeat-y\"===this[e].repeat||\"no-repeat\"===this[e].repeat?this[e].source.width:this.width,'\" height=\"',\"repeat-x\"===this[e].repeat||\"no-repeat\"===this[e].repeat?this[e].source.height:this.height,'\" fill=\"url(#'+e+'Pattern)\"',\"></rect>\\n\"):this[e]&&\"overlayColor\"===e&&t.push('<rect x=\"0\" y=\"0\" ','width=\"',this.width,'\" height=\"',this.height,'\" fill=\"',this[e],'\"',\"></rect>\\n\")},sendToBack:function(t){if(!t)return this;var e,r,n,s=this.getActiveGroup?this.getActiveGroup():null;if(t===s)for(n=s._objects,e=n.length;e--;)r=n[e],i(this._objects,r),this._objects.unshift(r);else i(this._objects,t),this._objects.unshift(t);return this.renderAll&&this.renderAll()},bringToFront:function(t){if(!t)return this;var e,r,n,s=this.getActiveGroup?this.getActiveGroup():null;if(t===s)for(n=s._objects,e=0;e<n.length;e++)r=n[e],i(this._objects,r),this._objects.push(r);else i(this._objects,t),this._objects.push(t);return this.renderAll&&this.renderAll()},sendBackwards:function(t,e){if(!t)return this;var r,n,s,o,a,h=this.getActiveGroup?this.getActiveGroup():null;if(t===h)for(a=h._objects,r=0;r<a.length;r++)n=a[r],s=this._objects.indexOf(n),0!==s&&(o=s-1,i(this._objects,n),this._objects.splice(o,0,n));else s=this._objects.indexOf(t),0!==s&&(o=this._findNewLowerIndex(t,s,e),i(this._objects,t),this._objects.splice(o,0,t));return this.renderAll&&this.renderAll(),this},_findNewLowerIndex:function(t,e,i){var r;if(i){r=e;for(var n=e-1;n>=0;--n){var s=t.intersectsWithObject(this._objects[n])||t.isContainedWithinObject(this._objects[n])||this._objects[n].isContainedWithinObject(t);if(s){r=n;break}}}else r=e-1;return r},bringForward:function(t,e){if(!t)return this;var r,n,s,o,a,h=this.getActiveGroup?this.getActiveGroup():null;if(t===h)for(a=h._objects,r=a.length;r--;)n=a[r],s=this._objects.indexOf(n),s!==this._objects.length-1&&(o=s+1,i(this._objects,n),this._objects.splice(o,0,n));else s=this._objects.indexOf(t),s!==this._objects.length-1&&(o=this._findNewUpperIndex(t,s,e),i(this._objects,t),this._objects.splice(o,0,t));return this.renderAll&&this.renderAll(),this},_findNewUpperIndex:function(t,e,i){var r;if(i){r=e;for(var n=e+1;n<this._objects.length;++n){var s=t.intersectsWithObject(this._objects[n])||t.isContainedWithinObject(this._objects[n])||this._objects[n].isContainedWithinObject(t);if(s){r=n;break}}}else r=e+1;return r},moveTo:function(t,e){return i(this._objects,t),this._objects.splice(e,0,t),this.renderAll&&this.renderAll()},dispose:function(){return this.clear(),this},toString:function(){return\"#<fabric.Canvas (\"+this.complexity()+\"): { objects: \"+this.getObjects().length+\" }>\"}}),t(fabric.StaticCanvas.prototype,fabric.Observable),t(fabric.StaticCanvas.prototype,fabric.Collection),t(fabric.StaticCanvas.prototype,fabric.DataURLExporter),t(fabric.StaticCanvas,{EMPTY_JSON:'{\"objects\": [], \"background\": \"white\"}',supports:function(t){var e=fabric.util.createCanvasElement();if(!e||!e.getContext)return null;var i=e.getContext(\"2d\");if(!i)return null;switch(t){case\"getImageData\":return\"undefined\"!=typeof i.getImageData;case\"setLineDash\":return\"undefined\"!=typeof i.setLineDash;case\"toDataURL\":return\"undefined\"!=typeof e.toDataURL;case\"toDataURLWithQuality\":try{return e.toDataURL(\"image/jpeg\",0),!0}catch(r){}return!1;default:return null}}}),fabric.StaticCanvas.prototype.toJSON=fabric.StaticCanvas.prototype.toObject}(),fabric.BaseBrush=fabric.util.createClass({color:\"rgb(0, 0, 0)\",width:1,shadow:null,strokeLineCap:\"round\",strokeLineJoin:\"round\",strokeDashArray:null,setShadow:function(t){return this.shadow=new fabric.Shadow(t),this},_setBrushStyles:function(){var t=this.canvas.contextTop;t.strokeStyle=this.color,t.lineWidth=this.width,t.lineCap=this.strokeLineCap,t.lineJoin=this.strokeLineJoin,this.strokeDashArray&&fabric.StaticCanvas.supports(\"setLineDash\")&&t.setLineDash(this.strokeDashArray)},_setShadow:function(){if(this.shadow){var t=this.canvas.contextTop;t.shadowColor=this.shadow.color,t.shadowBlur=this.shadow.blur,t.shadowOffsetX=this.shadow.offsetX,t.shadowOffsetY=this.shadow.offsetY}},_resetShadow:function(){var t=this.canvas.contextTop;t.shadowColor=\"\",t.shadowBlur=t.shadowOffsetX=t.shadowOffsetY=0}}),function(){fabric.PencilBrush=fabric.util.createClass(fabric.BaseBrush,{initialize:function(t){this.canvas=t,this._points=[]},onMouseDown:function(t){this._prepareForDrawing(t),this._captureDrawingPath(t),this._render()},onMouseMove:function(t){this._captureDrawingPath(t),this.canvas.clearContext(this.canvas.contextTop),this._render()},onMouseUp:function(){this._finalizeAndAddPath()},_prepareForDrawing:function(t){var e=new fabric.Point(t.x,t.y);this._reset(),this._addPoint(e),this.canvas.contextTop.moveTo(e.x,e.y)},_addPoint:function(t){this._points.push(t)},_reset:function(){this._points.length=0,this._setBrushStyles(),this._setShadow()},_captureDrawingPath:function(t){var e=new fabric.Point(t.x,t.y);this._addPoint(e)},_render:function(){var t=this.canvas.contextTop,e=this.canvas.viewportTransform,i=this._points[0],r=this._points[1];t.save(),t.transform(e[0],e[1],e[2],e[3],e[4],e[5]),t.beginPath(),2===this._points.length&&i.x===r.x&&i.y===r.y&&(i.x-=.5,r.x+=.5),t.moveTo(i.x,i.y);for(var n=1,s=this._points.length;s>n;n++){var o=i.midPointFrom(r);t.quadraticCurveTo(i.x,i.y,o.x,o.y),i=this._points[n],r=this._points[n+1]}t.lineTo(i.x,i.y),t.stroke(),t.restore()},convertPointsToSVGPath:function(t){var e=[],i=new fabric.Point(t[0].x,t[0].y),r=new fabric.Point(t[1].x,t[1].y);e.push(\"M \",t[0].x,\" \",t[0].y,\" \");for(var n=1,s=t.length;s>n;n++){var o=i.midPointFrom(r);e.push(\"Q \",i.x,\" \",i.y,\" \",o.x,\" \",o.y,\" \"),i=new fabric.Point(t[n].x,t[n].y),n+1<t.length&&(r=new fabric.Point(t[n+1].x,t[n+1].y))}return e.push(\"L \",i.x,\" \",i.y,\" \"),e},createPath:function(t){var e=new fabric.Path(t,{fill:null,stroke:this.color,strokeWidth:this.width,strokeLineCap:this.strokeLineCap,strokeLineJoin:this.strokeLineJoin,strokeDashArray:this.strokeDashArray,originX:\"center\",originY:\"center\"});return this.shadow&&(this.shadow.affectStroke=!0,e.setShadow(this.shadow)),e},_finalizeAndAddPath:function(){var t=this.canvas.contextTop;t.closePath();var e=this.convertPointsToSVGPath(this._points).join(\"\");if(\"M 0 0 Q 0 0 0 0 L 0 0\"===e)return void this.canvas.renderAll();var i=this.createPath(e);this.canvas.add(i),i.setCoords(),this.canvas.clearContext(this.canvas.contextTop),this._resetShadow(),this.canvas.renderAll(),this.canvas.fire(\"path:created\",{path:i})}})}(),fabric.CircleBrush=fabric.util.createClass(fabric.BaseBrush,{width:10,initialize:function(t){this.canvas=t,this.points=[]},drawDot:function(t){var e=this.addPoint(t),i=this.canvas.contextTop,r=this.canvas.viewportTransform;i.save(),i.transform(r[0],r[1],r[2],r[3],r[4],r[5]),i.fillStyle=e.fill,i.beginPath(),i.arc(e.x,e.y,e.radius,0,2*Math.PI,!1),i.closePath(),i.fill(),i.restore()},onMouseDown:function(t){this.points.length=0,this.canvas.clearContext(this.canvas.contextTop),this._setShadow(),this.drawDot(t)},onMouseMove:function(t){this.drawDot(t)},onMouseUp:function(){var t=this.canvas.renderOnAddRemove;this.canvas.renderOnAddRemove=!1;for(var e=[],i=0,r=this.points.length;r>i;i++){var n=this.points[i],s=new fabric.Circle({radius:n.radius,left:n.x,top:n.y,originX:\"center\",originY:\"center\",fill:n.fill});this.shadow&&s.setShadow(this.shadow),e.push(s)}var o=new fabric.Group(e,{originX:\"center\",originY:\"center\"});o.canvas=this.canvas,this.canvas.add(o),this.canvas.fire(\"path:created\",{path:o}),this.canvas.clearContext(this.canvas.contextTop),this._resetShadow(),this.canvas.renderOnAddRemove=t,this.canvas.renderAll()},addPoint:function(t){var e=new fabric.Point(t.x,t.y),i=fabric.util.getRandomInt(Math.max(0,this.width-20),this.width+20)/2,r=new fabric.Color(this.color).setAlpha(fabric.util.getRandomInt(0,100)/100).toRgba();return e.radius=i,e.fill=r,this.points.push(e),e}}),fabric.SprayBrush=fabric.util.createClass(fabric.BaseBrush,{width:10,density:20,dotWidth:1,dotWidthVariance:1,randomOpacity:!1,optimizeOverlapping:!0,initialize:function(t){this.canvas=t,this.sprayChunks=[]},onMouseDown:function(t){this.sprayChunks.length=0,this.canvas.clearContext(this.canvas.contextTop),this._setShadow(),this.addSprayChunk(t),this.render()},onMouseMove:function(t){this.addSprayChunk(t),this.render()},onMouseUp:function(){var t=this.canvas.renderOnAddRemove;this.canvas.renderOnAddRemove=!1;for(var e=[],i=0,r=this.sprayChunks.length;r>i;i++)for(var n=this.sprayChunks[i],s=0,o=n.length;o>s;s++){var a=new fabric.Rect({width:n[s].width,height:n[s].width,left:n[s].x+1,top:n[s].y+1,originX:\"center\",originY:\"center\",fill:this.color});this.shadow&&a.setShadow(this.shadow),e.push(a)}this.optimizeOverlapping&&(e=this._getOptimizedRects(e));var h=new fabric.Group(e,{originX:\"center\",originY:\"center\"});h.canvas=this.canvas,this.canvas.add(h),this.canvas.fire(\"path:created\",{path:h}),this.canvas.clearContext(this.canvas.contextTop),this._resetShadow(),this.canvas.renderOnAddRemove=t,this.canvas.renderAll()},_getOptimizedRects:function(t){for(var e,i={},r=0,n=t.length;n>r;r++)e=t[r].left+\"\"+t[r].top,i[e]||(i[e]=t[r]);var s=[];for(e in i)s.push(i[e]);return s},render:function(){var t=this.canvas.contextTop;t.fillStyle=this.color;var e=this.canvas.viewportTransform;t.save(),t.transform(e[0],e[1],e[2],e[3],e[4],e[5]);for(var i=0,r=this.sprayChunkPoints.length;r>i;i++){var n=this.sprayChunkPoints[i];\"undefined\"!=typeof n.opacity&&(t.globalAlpha=n.opacity),t.fillRect(n.x,n.y,n.width,n.width)}t.restore()},addSprayChunk:function(t){this.sprayChunkPoints=[];for(var e,i,r,n=this.width/2,s=0;s<this.density;s++){e=fabric.util.getRandomInt(t.x-n,t.x+n),i=fabric.util.getRandomInt(t.y-n,t.y+n),r=this.dotWidthVariance?fabric.util.getRandomInt(Math.max(1,this.dotWidth-this.dotWidthVariance),this.dotWidth+this.dotWidthVariance):this.dotWidth;var o=new fabric.Point(e,i);o.width=r,this.randomOpacity&&(o.opacity=fabric.util.getRandomInt(0,100)/100),this.sprayChunkPoints.push(o)}this.sprayChunks.push(this.sprayChunkPoints)}}),fabric.PatternBrush=fabric.util.createClass(fabric.PencilBrush,{getPatternSrc:function(){var t=20,e=5,i=fabric.document.createElement(\"canvas\"),r=i.getContext(\"2d\");return i.width=i.height=t+e,r.fillStyle=this.color,r.beginPath(),r.arc(t/2,t/2,t/2,0,2*Math.PI,!1),r.closePath(),r.fill(),i},getPatternSrcFunction:function(){return String(this.getPatternSrc).replace(\"this.color\",'\"'+this.color+'\"')},getPattern:function(){return this.canvas.contextTop.createPattern(this.source||this.getPatternSrc(),\"repeat\")},_setBrushStyles:function(){this.callSuper(\"_setBrushStyles\"),this.canvas.contextTop.strokeStyle=this.getPattern()},createPath:function(t){var e=this.callSuper(\"createPath\",t);return e.stroke=new fabric.Pattern({source:this.source||this.getPatternSrcFunction()}),e}}),function(){var t=fabric.util.getPointer,e=fabric.util.degreesToRadians,i=fabric.util.radiansToDegrees,r=Math.atan2,n=Math.abs,s=.5;fabric.Canvas=fabric.util.createClass(fabric.StaticCanvas,{initialize:function(t,e){e||(e={}),this._initStatic(t,e),this._initInteractive(),this._createCacheCanvas()},uniScaleTransform:!1,uniScaleKey:\"shiftKey\",centeredScaling:!1,centeredRotation:!1,centeredKey:\"altKey\",altActionKey:\"shiftKey\",interactive:!0,selection:!0,selectionKey:\"shiftKey\",selectionColor:\"rgba(100, 100, 255, 0.3)\",selectionDashArray:[],selectionBorderColor:\"rgba(255, 255, 255, 0.3)\",selectionLineWidth:1,hoverCursor:\"move\",moveCursor:\"move\",defaultCursor:\"default\",freeDrawingCursor:\"crosshair\",rotationCursor:\"crosshair\",containerClass:\"canvas-container\",perPixelTargetFind:!1,targetFindTolerance:0,skipTargetFind:!1,isDrawingMode:!1,_initInteractive:function(){this._currentTransform=null,this._groupSelector=null,this._initWrapperElement(),this._createUpperCanvas(),this._initEventListeners(),this._initRetinaScaling(),this.freeDrawingBrush=fabric.PencilBrush&&new fabric.PencilBrush(this),this.calcOffset()},_resetCurrentTransform:function(){var t=this._currentTransform;t.target.set({scaleX:t.original.scaleX,scaleY:t.original.scaleY,skewX:t.original.skewX,skewY:t.original.skewY,left:t.original.left,top:t.original.top}),this._shouldCenterTransform(t.target)?\"rotate\"===t.action?this._setOriginToCenter(t.target):(\"center\"!==t.originX&&(\"right\"===t.originX?t.mouseXSign=-1:t.mouseXSign=1),\"center\"!==t.originY&&(\"bottom\"===t.originY?t.mouseYSign=-1:t.mouseYSign=1),t.originX=\"center\",t.originY=\"center\"):(t.originX=t.original.originX,t.originY=t.original.originY)},containsPoint:function(t,e){var i=this.getPointer(t,!0),r=this._normalizePointer(e,i);return e.containsPoint(r)||e._findTargetCorner(i)},_normalizePointer:function(t,e){var i,r,n=this.getActiveGroup(),s=n&&\"group\"!==t.type&&n.contains(t);return s&&(r=fabric.util.multiplyTransformMatrices(this.viewportTransform,n.calcTransformMatrix()),r=fabric.util.invertTransform(r),e=fabric.util.transformPoint(e,r,!1),i=fabric.util.transformPoint(n.getCenterPoint(),r,!1),e.x-=i.x,e.y-=i.y),{x:e.x,y:e.y}},isTargetTransparent:function(t,e,i){var r=t.hasBorders,n=t.transparentCorners,s=this.contextCache,o=t.group&&t.group===this.getActiveGroup();t.hasBorders=t.transparentCorners=!1,o&&(s.save(),s.transform.apply(s,t.group.calcTransformMatrix())),t.render(s),t.active&&t._renderControls(s),t.hasBorders=r,t.transparentCorners=n;var a=fabric.util.isTransparent(s,e,i,this.targetFindTolerance);return o&&s.restore(),this.clearContext(s),a},_shouldClearSelection:function(t,e){var i=this.getActiveGroup(),r=this.getActiveObject();return!e||e&&i&&!i.contains(e)&&i!==e&&!t[this.selectionKey]||e&&!e.evented||e&&!e.selectable&&r&&r!==e},_shouldCenterTransform:function(t){if(t){var e,i=this._currentTransform;return\"scale\"===i.action||\"scaleX\"===i.action||\"scaleY\"===i.action?e=this.centeredScaling||t.centeredScaling:\"rotate\"===i.action&&(e=this.centeredRotation||t.centeredRotation),e?!i.altKey:i.altKey}},_getOriginFromCorner:function(t,e){var i={x:t.originX,y:t.originY};return\"ml\"===e||\"tl\"===e||\"bl\"===e?i.x=\"right\":\"mr\"!==e&&\"tr\"!==e&&\"br\"!==e||(i.x=\"left\"),\"tl\"===e||\"mt\"===e||\"tr\"===e?i.y=\"bottom\":\"bl\"!==e&&\"mb\"!==e&&\"br\"!==e||(i.y=\"top\"),i},_getActionFromCorner:function(t,e,i){if(!e)return\"drag\";switch(e){case\"mtr\":return\"rotate\";case\"ml\":case\"mr\":return i[this.altActionKey]?\"skewY\":\"scaleX\";case\"mt\":case\"mb\":return i[this.altActionKey]?\"skewX\":\"scaleY\";default:return\"scale\"}},_setupCurrentTransform:function(t,i){if(i){var r=this.getPointer(t),n=i._findTargetCorner(this.getPointer(t,!0)),s=this._getActionFromCorner(i,n,t),o=this._getOriginFromCorner(i,n);this._currentTransform={target:i,action:s,corner:n,scaleX:i.scaleX,scaleY:i.scaleY,skewX:i.skewX,skewY:i.skewY,offsetX:r.x-i.left,offsetY:r.y-i.top,originX:o.x,originY:o.y,ex:r.x,ey:r.y,lastX:r.x,lastY:r.y,left:i.left,top:i.top,theta:e(i.angle),width:i.width*i.scaleX,mouseXSign:1,mouseYSign:1,shiftKey:t.shiftKey,altKey:t[this.centeredKey]},this._currentTransform.original={left:i.left,top:i.top,scaleX:i.scaleX,scaleY:i.scaleY,skewX:i.skewX,skewY:i.skewY,originX:o.x,originY:o.y},this._resetCurrentTransform()}},_translateObject:function(t,e){var i=this._currentTransform,r=i.target,n=t-i.offsetX,s=e-i.offsetY,o=!r.get(\"lockMovementX\")&&r.left!==n,a=!r.get(\"lockMovementY\")&&r.top!==s;return o&&r.set(\"left\",n),a&&r.set(\"top\",s),o||a},_changeSkewTransformOrigin:function(t,e,i){var r=\"originX\",n={0:\"center\"},s=e.target.skewX,o=\"left\",a=\"right\",h=\"mt\"===e.corner||\"ml\"===e.corner?1:-1,c=1;t=t>0?1:-1,\"y\"===i&&(s=e.target.skewY,o=\"top\",a=\"bottom\",r=\"originY\"),n[-1]=o,n[1]=a,e.target.flipX&&(c*=-1),e.target.flipY&&(c*=-1),0===s?(e.skewSign=-h*t*c,e[r]=n[-t]):(s=s>0?1:-1,e.skewSign=s,e[r]=n[s*h*c])},_skewObject:function(t,e,i){var r=this._currentTransform,n=r.target,s=!1,o=n.get(\"lockSkewingX\"),a=n.get(\"lockSkewingY\");if(o&&\"x\"===i||a&&\"y\"===i)return!1;var h,c,l=n.getCenterPoint(),u=n.toLocalPoint(new fabric.Point(t,e),\"center\",\"center\")[i],f=n.toLocalPoint(new fabric.Point(r.lastX,r.lastY),\"center\",\"center\")[i],d=n._getTransformedDimensions();return this._changeSkewTransformOrigin(u-f,r,i),h=n.toLocalPoint(new fabric.Point(t,e),r.originX,r.originY)[i],c=n.translateToOriginPoint(l,r.originX,r.originY),s=this._setObjectSkew(h,r,i,d),r.lastX=t,r.lastY=e,n.setPositionByOrigin(c,r.originX,r.originY),s},_setObjectSkew:function(t,e,i,r){var n,s,o,a,h,c,l,u,f,d=e.target,g=!1,p=e.skewSign;return\"x\"===i?(a=\"y\",h=\"Y\",c=\"X\",u=0,f=d.skewY):(a=\"x\",h=\"X\",c=\"Y\",u=d.skewX,f=0),o=d._getTransformedDimensions(u,f),l=2*Math.abs(t)-o[i],2>=l?n=0:(n=p*Math.atan(l/d[\"scale\"+c]/(o[a]/d[\"scale\"+h])),n=fabric.util.radiansToDegrees(n)),g=d[\"skew\"+c]!==n,d.set(\"skew\"+c,n),0!==d[\"skew\"+h]&&(s=d._getTransformedDimensions(),n=r[a]/s[a]*d[\"scale\"+h],d.set(\"scale\"+h,n)),g},_scaleObject:function(t,e,i){var r=this._currentTransform,n=r.target,s=n.get(\"lockScalingX\"),o=n.get(\"lockScalingY\"),a=n.get(\"lockScalingFlip\");if(s&&o)return!1;var h=n.translateToOriginPoint(n.getCenterPoint(),r.originX,r.originY),c=n.toLocalPoint(new fabric.Point(t,e),r.originX,r.originY),l=n._getTransformedDimensions(),u=!1;return this._setLocalMouse(c,r),u=this._setObjectScale(c,r,s,o,i,a,l),n.setPositionByOrigin(h,r.originX,r.originY),u},_setObjectScale:function(t,e,i,r,n,s,o){var a,h,c,l,u=e.target,f=!1,d=!1,g=!1;return c=t.x*u.scaleX/o.x,l=t.y*u.scaleY/o.y,a=u.scaleX!==c,h=u.scaleY!==l,s&&0>=c&&c<u.scaleX&&(f=!0),s&&0>=l&&l<u.scaleY&&(d=!0),\"equally\"!==n||i||r?n?\"x\"!==n||u.get(\"lockUniScaling\")?\"y\"!==n||u.get(\"lockUniScaling\")||d||r||u.set(\"scaleY\",l)&&(g=g||h):f||i||u.set(\"scaleX\",c)&&(g=g||a):(f||i||u.set(\"scaleX\",c)&&(g=g||a),d||r||u.set(\"scaleY\",l)&&(g=g||h)):f||d||(g=this._scaleObjectEqually(t,u,e,o)),e.newScaleX=c,e.newScaleY=l,f||d||this._flipObject(e,n),g},_scaleObjectEqually:function(t,e,i,r){var n,s=t.y+t.x,o=r.y*i.original.scaleY/e.scaleY+r.x*i.original.scaleX/e.scaleX;return i.newScaleX=i.original.scaleX*s/o,i.newScaleY=i.original.scaleY*s/o,n=i.newScaleX!==e.scaleX||i.newScaleY!==e.scaleY,e.set(\"scaleX\",i.newScaleX),e.set(\"scaleY\",i.newScaleY),n},_flipObject:function(t,e){t.newScaleX<0&&\"y\"!==e&&(\"left\"===t.originX?t.originX=\"right\":\"right\"===t.originX&&(t.originX=\"left\")),t.newScaleY<0&&\"x\"!==e&&(\"top\"===t.originY?t.originY=\"bottom\":\"bottom\"===t.originY&&(t.originY=\"top\"))},_setLocalMouse:function(t,e){var i=e.target;\"right\"===e.originX?t.x*=-1:\"center\"===e.originX&&(t.x*=2*e.mouseXSign,t.x<0&&(e.mouseXSign=-e.mouseXSign)),\"bottom\"===e.originY?t.y*=-1:\"center\"===e.originY&&(t.y*=2*e.mouseYSign,t.y<0&&(e.mouseYSign=-e.mouseYSign)),n(t.x)>i.padding?t.x<0?t.x+=i.padding:t.x-=i.padding:t.x=0,n(t.y)>i.padding?t.y<0?t.y+=i.padding:t.y-=i.padding:t.y=0},_rotateObject:function(t,e){var n=this._currentTransform;if(n.target.get(\"lockRotation\"))return!1;var s=r(n.ey-n.top,n.ex-n.left),o=r(e-n.top,t-n.left),a=i(o-s+n.theta);return 0>a&&(a=360+a),n.target.angle=a%360,!0},setCursor:function(t){this.upperCanvasEl.style.cursor=t},_resetObjectTransform:function(t){t.scaleX=1,t.scaleY=1,t.skewX=0,t.skewY=0,t.setAngle(0)},_drawSelection:function(){var t=this.contextTop,e=this._groupSelector,i=e.left,r=e.top,o=n(i),a=n(r);if(t.fillStyle=this.selectionColor,t.fillRect(e.ex-(i>0?0:-i),e.ey-(r>0?0:-r),o,a),t.lineWidth=this.selectionLineWidth,t.strokeStyle=this.selectionBorderColor,this.selectionDashArray.length>1){var h=e.ex+s-(i>0?0:o),c=e.ey+s-(r>0?0:a);t.beginPath(),fabric.util.drawDashedLine(t,h,c,h+o,c,this.selectionDashArray),fabric.util.drawDashedLine(t,h,c+a-1,h+o,c+a-1,this.selectionDashArray),fabric.util.drawDashedLine(t,h,c,h,c+a,this.selectionDashArray),fabric.util.drawDashedLine(t,h+o-1,c,h+o-1,c+a,this.selectionDashArray),t.closePath(),t.stroke()}else t.strokeRect(e.ex+s-(i>0?0:o),e.ey+s-(r>0?0:a),o,a)},_isLastRenderedObject:function(t){return this.controlsAboveOverlay&&this.lastRenderedObjectWithControlsAboveOverlay&&this.lastRenderedObjectWithControlsAboveOverlay.visible&&this.containsPoint(t,this.lastRenderedObjectWithControlsAboveOverlay)&&this.lastRenderedObjectWithControlsAboveOverlay._findTargetCorner(this.getPointer(t,!0))},findTarget:function(t,e){if(!this.skipTargetFind){if(this._isLastRenderedObject(t))return this.lastRenderedObjectWithControlsAboveOverlay;var i=this.getActiveGroup();if(!e&&this._checkTarget(t,i,this.getPointer(t,!0)))return i;var r=this._searchPossibleTargets(t,e);return this._fireOverOutEvents(r,t),r}},_fireOverOutEvents:function(t,e){t?this._hoveredTarget!==t&&(this._hoveredTarget&&(this.fire(\"mouse:out\",{target:this._hoveredTarget,e:e}),this._hoveredTarget.fire(\"mouseout\")),this.fire(\"mouse:over\",{target:t,e:e}),t.fire(\"mouseover\"),this._hoveredTarget=t):this._hoveredTarget&&(this.fire(\"mouse:out\",{target:this._hoveredTarget,e:e}),this._hoveredTarget.fire(\"mouseout\"),this._hoveredTarget=null)},_checkTarget:function(t,e,i){if(e&&e.visible&&e.evented&&this.containsPoint(t,e)){if(!this.perPixelTargetFind&&!e.perPixelTargetFind||e.isEditing)return!0;var r=this.isTargetTransparent(e,i.x,i.y);if(!r)return!0}},_searchPossibleTargets:function(t,e){for(var i,r=this.getPointer(t,!0),n=this._objects.length;n--;)if((!this._objects[n].group||e)&&this._checkTarget(t,this._objects[n],r)){this.relatedTarget=this._objects[n],i=this._objects[n];break}return i},getPointer:function(e,i,r){r||(r=this.upperCanvasEl);var n,s=t(e),o=r.getBoundingClientRect(),a=o.width||0,h=o.height||0;return a&&h||(\"top\"in o&&\"bottom\"in o&&(h=Math.abs(o.top-o.bottom)),\"right\"in o&&\"left\"in o&&(a=Math.abs(o.right-o.left))),this.calcOffset(),s.x=s.x-this._offset.left,s.y=s.y-this._offset.top,i||(s=fabric.util.transformPoint(s,fabric.util.invertTransform(this.viewportTransform))),n=0===a||0===h?{width:1,height:1}:{width:r.width/a,height:r.height/h},{x:s.x*n.width,y:s.y*n.height}},_createUpperCanvas:function(){var t=this.lowerCanvasEl.className.replace(/\\s*lower-canvas\\s*/,\"\");this.upperCanvasEl=this._createCanvasElement(),fabric.util.addClass(this.upperCanvasEl,\"upper-canvas \"+t),this.wrapperEl.appendChild(this.upperCanvasEl),this._copyCanvasStyle(this.lowerCanvasEl,this.upperCanvasEl),this._applyCanvasStyle(this.upperCanvasEl),this.contextTop=this.upperCanvasEl.getContext(\"2d\")},_createCacheCanvas:function(){this.cacheCanvasEl=this._createCanvasElement(),this.cacheCanvasEl.setAttribute(\"width\",this.width),this.cacheCanvasEl.setAttribute(\"height\",this.height),this.contextCache=this.cacheCanvasEl.getContext(\"2d\")},_initWrapperElement:function(){this.wrapperEl=fabric.util.wrapElement(this.lowerCanvasEl,\"div\",{\"class\":this.containerClass}),fabric.util.setStyle(this.wrapperEl,{width:this.getWidth()+\"px\",height:this.getHeight()+\"px\",position:\"relative\"}),fabric.util.makeElementUnselectable(this.wrapperEl)},_applyCanvasStyle:function(t){var e=this.getWidth()||t.width,i=this.getHeight()||t.height;fabric.util.setStyle(t,{position:\"absolute\",width:e+\"px\",height:i+\"px\",left:0,top:0}),t.width=e,t.height=i,fabric.util.makeElementUnselectable(t)},_copyCanvasStyle:function(t,e){e.style.cssText=t.style.cssText},getSelectionContext:function(){return this.contextTop},getSelectionElement:function(){return this.upperCanvasEl},_setActiveObject:function(t){this._activeObject&&this._activeObject.set(\"active\",!1),this._activeObject=t,t.set(\"active\",!0)},setActiveObject:function(t,e){return this._setActiveObject(t),this.renderAll(),this.fire(\"object:selected\",{target:t,e:e}),t.fire(\"selected\",{e:e}),this},getActiveObject:function(){return this._activeObject},_discardActiveObject:function(){this._activeObject&&this._activeObject.set(\"active\",!1),this._activeObject=null},discardActiveObject:function(t){return this._discardActiveObject(),this.renderAll(),this.fire(\"selection:cleared\",{e:t}),this},_setActiveGroup:function(t){this._activeGroup=t,t&&t.set(\"active\",!0)},setActiveGroup:function(t,e){return this._setActiveGroup(t),t&&(this.fire(\"object:selected\",{target:t,e:e}),t.fire(\"selected\",{e:e})),this},getActiveGroup:function(){return this._activeGroup},_discardActiveGroup:function(){var t=this.getActiveGroup();t&&t.destroy(),this.setActiveGroup(null)},discardActiveGroup:function(t){return this._discardActiveGroup(),this.fire(\"selection:cleared\",{e:t}),this},deactivateAll:function(){for(var t=this.getObjects(),e=0,i=t.length;i>e;e++)t[e].set(\"active\",!1);return this._discardActiveGroup(),this._discardActiveObject(),this},deactivateAllWithDispatch:function(t){var e=this.getActiveGroup()||this.getActiveObject();return e&&this.fire(\"before:selection:cleared\",{target:e,e:t}),this.deactivateAll(),e&&this.fire(\"selection:cleared\",{e:t}),this},dispose:function(){this.callSuper(\"dispose\");var t=this.wrapperEl;return this.removeListeners(),t.removeChild(this.upperCanvasEl),t.removeChild(this.lowerCanvasEl),delete this.upperCanvasEl,t.parentNode&&t.parentNode.replaceChild(this.lowerCanvasEl,this.wrapperEl),delete this.wrapperEl,this},drawControls:function(t){var e=this.getActiveGroup();e?e._renderControls(t):this._drawObjectsControls(t)},_drawObjectsControls:function(t){for(var e=0,i=this._objects.length;i>e;++e)this._objects[e]&&this._objects[e].active&&(this._objects[e]._renderControls(t),this.lastRenderedObjectWithControlsAboveOverlay=this._objects[e])}});for(var o in fabric.StaticCanvas)\"prototype\"!==o&&(fabric.Canvas[o]=fabric.StaticCanvas[o]);fabric.isTouchSupported&&(fabric.Canvas.prototype._setCursorFromEvent=function(){}),fabric.Element=fabric.Canvas}(),function(){var t={mt:0,tr:1,mr:2,br:3,mb:4,bl:5,ml:6,tl:7},e=fabric.util.addListener,i=fabric.util.removeListener;fabric.util.object.extend(fabric.Canvas.prototype,{cursorMap:[\"n-resize\",\"ne-resize\",\"e-resize\",\"se-resize\",\"s-resize\",\"sw-resize\",\"w-resize\",\"nw-resize\"],_initEventListeners:function(){this._bindEvents(),e(fabric.window,\"resize\",this._onResize),e(this.upperCanvasEl,\"mousedown\",this._onMouseDown),e(this.upperCanvasEl,\"mousemove\",this._onMouseMove),e(this.upperCanvasEl,\"mousewheel\",this._onMouseWheel),e(this.upperCanvasEl,\"mouseout\",this._onMouseOut),e(this.upperCanvasEl,\"touchstart\",this._onMouseDown),e(this.upperCanvasEl,\"touchmove\",this._onMouseMove),\"undefined\"!=typeof eventjs&&\"add\"in eventjs&&(eventjs.add(this.upperCanvasEl,\"gesture\",this._onGesture),eventjs.add(this.upperCanvasEl,\"drag\",this._onDrag),eventjs.add(this.upperCanvasEl,\"orientation\",this._onOrientationChange),eventjs.add(this.upperCanvasEl,\"shake\",this._onShake),eventjs.add(this.upperCanvasEl,\"longpress\",this._onLongPress))},_bindEvents:function(){this._onMouseDown=this._onMouseDown.bind(this),this._onMouseMove=this._onMouseMove.bind(this),this._onMouseUp=this._onMouseUp.bind(this),this._onResize=this._onResize.bind(this),this._onGesture=this._onGesture.bind(this),this._onDrag=this._onDrag.bind(this),this._onShake=this._onShake.bind(this),this._onLongPress=this._onLongPress.bind(this),this._onOrientationChange=this._onOrientationChange.bind(this),this._onMouseWheel=this._onMouseWheel.bind(this),this._onMouseOut=this._onMouseOut.bind(this)},removeListeners:function(){i(fabric.window,\"resize\",this._onResize),i(this.upperCanvasEl,\"mousedown\",this._onMouseDown),i(this.upperCanvasEl,\"mousemove\",this._onMouseMove),i(this.upperCanvasEl,\"mousewheel\",this._onMouseWheel),i(this.upperCanvasEl,\"mouseout\",this._onMouseOut),i(this.upperCanvasEl,\"touchstart\",this._onMouseDown),i(this.upperCanvasEl,\"touchmove\",this._onMouseMove),\"undefined\"!=typeof eventjs&&\"remove\"in eventjs&&(eventjs.remove(this.upperCanvasEl,\"gesture\",this._onGesture),eventjs.remove(this.upperCanvasEl,\"drag\",this._onDrag),eventjs.remove(this.upperCanvasEl,\"orientation\",this._onOrientationChange),eventjs.remove(this.upperCanvasEl,\"shake\",this._onShake),eventjs.remove(this.upperCanvasEl,\"longpress\",this._onLongPress))},_onGesture:function(t,e){this.__onTransformGesture&&this.__onTransformGesture(t,e)},_onDrag:function(t,e){this.__onDrag&&this.__onDrag(t,e)},_onMouseWheel:function(t,e){this.__onMouseWheel&&this.__onMouseWheel(t,e)},_onMouseOut:function(t){var e=this._hoveredTarget;this.fire(\"mouse:out\",{target:e,e:t}),this._hoveredTarget=null,e&&e.fire(\"mouseout\",{e:t})},_onOrientationChange:function(t,e){this.__onOrientationChange&&this.__onOrientationChange(t,e)},_onShake:function(t,e){this.__onShake&&this.__onShake(t,e)},_onLongPress:function(t,e){this.__onLongPress&&this.__onLongPress(t,e)},_onMouseDown:function(t){this.__onMouseDown(t),e(fabric.document,\"touchend\",this._onMouseUp),e(fabric.document,\"touchmove\",this._onMouseMove),i(this.upperCanvasEl,\"mousemove\",this._onMouseMove),i(this.upperCanvasEl,\"touchmove\",this._onMouseMove),\"touchstart\"===t.type?i(this.upperCanvasEl,\"mousedown\",this._onMouseDown):(e(fabric.document,\"mouseup\",this._onMouseUp),e(fabric.document,\"mousemove\",this._onMouseMove))},_onMouseUp:function(t){if(this.__onMouseUp(t),i(fabric.document,\"mouseup\",this._onMouseUp),i(fabric.document,\"touchend\",this._onMouseUp),i(fabric.document,\"mousemove\",this._onMouseMove),i(fabric.document,\"touchmove\",this._onMouseMove),e(this.upperCanvasEl,\"mousemove\",this._onMouseMove),e(this.upperCanvasEl,\"touchmove\",this._onMouseMove),\"touchend\"===t.type){var r=this;setTimeout(function(){e(r.upperCanvasEl,\"mousedown\",r._onMouseDown)},400)}},_onMouseMove:function(t){!this.allowTouchScrolling&&t.preventDefault&&t.preventDefault(),\nthis.__onMouseMove(t)},_onResize:function(){this.calcOffset()},_shouldRender:function(t,e){var i=this.getActiveGroup()||this.getActiveObject();return!!(t&&(t.isMoving||t!==i)||!t&&i||!t&&!i&&!this._groupSelector||e&&this._previousPointer&&this.selection&&(e.x!==this._previousPointer.x||e.y!==this._previousPointer.y))},__onMouseUp:function(t){var e,i=!0,r=this._currentTransform;if(this.isDrawingMode&&this._isCurrentlyDrawing)return void this._onMouseUpInDrawingMode(t);r&&(this._finalizeCurrentTransform(),i=!r.actionPerformed),e=i?this.findTarget(t,!0):r.target;var n=this._shouldRender(e,this.getPointer(t));this._maybeGroupObjects(t),e&&(e.isMoving=!1),n&&this.renderAll(),this._handleCursorAndEvent(t,e)},_handleCursorAndEvent:function(t,e){this._setCursorFromEvent(t,e),this.fire(\"mouse:up\",{target:e,e:t}),e&&e.fire(\"mouseup\",{e:t})},_finalizeCurrentTransform:function(){var t=this._currentTransform,e=t.target;e._scaling&&(e._scaling=!1),e.setCoords(),this._restoreOriginXY(e),(t.actionPerformed||this.stateful&&e.hasStateChanged())&&(this.fire(\"object:modified\",{target:e}),e.fire(\"modified\"))},_restoreOriginXY:function(t){if(this._previousOriginX&&this._previousOriginY){var e=t.translateToOriginPoint(t.getCenterPoint(),this._previousOriginX,this._previousOriginY);t.originX=this._previousOriginX,t.originY=this._previousOriginY,t.left=e.x,t.top=e.y,this._previousOriginX=null,this._previousOriginY=null}},_onMouseDownInDrawingMode:function(t){this._isCurrentlyDrawing=!0,this.discardActiveObject(t).renderAll(),this.clipTo&&fabric.util.clipContext(this,this.contextTop);var e=fabric.util.invertTransform(this.viewportTransform),i=fabric.util.transformPoint(this.getPointer(t,!0),e);this.freeDrawingBrush.onMouseDown(i),this.fire(\"mouse:down\",{e:t});var r=this.findTarget(t);\"undefined\"!=typeof r&&r.fire(\"mousedown\",{e:t,target:r})},_onMouseMoveInDrawingMode:function(t){if(this._isCurrentlyDrawing){var e=fabric.util.invertTransform(this.viewportTransform),i=fabric.util.transformPoint(this.getPointer(t,!0),e);this.freeDrawingBrush.onMouseMove(i)}this.setCursor(this.freeDrawingCursor),this.fire(\"mouse:move\",{e:t});var r=this.findTarget(t);\"undefined\"!=typeof r&&r.fire(\"mousemove\",{e:t,target:r})},_onMouseUpInDrawingMode:function(t){this._isCurrentlyDrawing=!1,this.clipTo&&this.contextTop.restore(),this.freeDrawingBrush.onMouseUp(),this.fire(\"mouse:up\",{e:t});var e=this.findTarget(t);\"undefined\"!=typeof e&&e.fire(\"mouseup\",{e:t,target:e})},__onMouseDown:function(t){var e=\"which\"in t?1===t.which:0===t.button;if(e||fabric.isTouchSupported){if(this.isDrawingMode)return void this._onMouseDownInDrawingMode(t);if(!this._currentTransform){var i=this.findTarget(t),r=this.getPointer(t,!0);this._previousPointer=r;var n=this._shouldRender(i,r),s=this._shouldGroup(t,i);this._shouldClearSelection(t,i)?this._clearSelection(t,i,r):s&&(this._handleGrouping(t,i),i=this.getActiveGroup()),i&&(!i.selectable||!i.__corner&&s||(this._beforeTransform(t,i),this._setupCurrentTransform(t,i)),i!==this.getActiveGroup()&&i!==this.getActiveObject()&&(this.deactivateAll(),i.selectable&&this.setActiveObject(i,t))),n&&this.renderAll(),this.fire(\"mouse:down\",{target:i,e:t}),i&&i.fire(\"mousedown\",{e:t})}}},_beforeTransform:function(t,e){this.stateful&&e.saveState(),e._findTargetCorner(this.getPointer(t))&&this.onBeforeScaleRotate(e)},_clearSelection:function(t,e,i){this.deactivateAllWithDispatch(t),e&&e.selectable?this.setActiveObject(e,t):this.selection&&(this._groupSelector={ex:i.x,ey:i.y,top:0,left:0})},_setOriginToCenter:function(t){this._previousOriginX=this._currentTransform.target.originX,this._previousOriginY=this._currentTransform.target.originY;var e=t.getCenterPoint();t.originX=\"center\",t.originY=\"center\",t.left=e.x,t.top=e.y,this._currentTransform.left=t.left,this._currentTransform.top=t.top},_setCenterToOrigin:function(t){var e=t.translateToOriginPoint(t.getCenterPoint(),this._previousOriginX,this._previousOriginY);t.originX=this._previousOriginX,t.originY=this._previousOriginY,t.left=e.x,t.top=e.y,this._previousOriginX=null,this._previousOriginY=null},__onMouseMove:function(t){var e,i;if(this.isDrawingMode)return void this._onMouseMoveInDrawingMode(t);if(!(\"undefined\"!=typeof t.touches&&t.touches.length>1)){var r=this._groupSelector;r?(i=this.getPointer(t,!0),r.left=i.x-r.ex,r.top=i.y-r.ey,this.renderTop()):this._currentTransform?this._transformObject(t):(e=this.findTarget(t),this._setCursorFromEvent(t,e)),this.fire(\"mouse:move\",{target:e,e:t}),e&&e.fire(\"mousemove\",{e:t})}},_transformObject:function(t){var e=this.getPointer(t),i=this._currentTransform;i.reset=!1,i.target.isMoving=!0,this._beforeScaleTransform(t,i),this._performTransformAction(t,i,e),this.renderAll()},_performTransformAction:function(t,e,i){var r=i.x,n=i.y,s=e.target,o=e.action,a=!1;\"rotate\"===o?(a=this._rotateObject(r,n))&&this._fire(\"rotating\",s,t):\"scale\"===o?(a=this._onScale(t,e,r,n))&&this._fire(\"scaling\",s,t):\"scaleX\"===o?(a=this._scaleObject(r,n,\"x\"))&&this._fire(\"scaling\",s,t):\"scaleY\"===o?(a=this._scaleObject(r,n,\"y\"))&&this._fire(\"scaling\",s,t):\"skewX\"===o?(a=this._skewObject(r,n,\"x\"))&&this._fire(\"skewing\",s,t):\"skewY\"===o?(a=this._skewObject(r,n,\"y\"))&&this._fire(\"skewing\",s,t):(a=this._translateObject(r,n),a&&(this._fire(\"moving\",s,t),this.setCursor(s.moveCursor||this.moveCursor))),e.actionPerformed=a},_fire:function(t,e,i){this.fire(\"object:\"+t,{target:e,e:i}),e.fire(t,{e:i})},_beforeScaleTransform:function(t,e){if(\"scale\"===e.action||\"scaleX\"===e.action||\"scaleY\"===e.action){var i=this._shouldCenterTransform(e.target);(i&&(\"center\"!==e.originX||\"center\"!==e.originY)||!i&&\"center\"===e.originX&&\"center\"===e.originY)&&(this._resetCurrentTransform(),e.reset=!0)}},_onScale:function(t,e,i,r){return!t[this.uniScaleKey]&&!this.uniScaleTransform||e.target.get(\"lockUniScaling\")?(e.reset||\"scale\"!==e.currentAction||this._resetCurrentTransform(),e.currentAction=\"scaleEqually\",this._scaleObject(i,r,\"equally\")):(e.currentAction=\"scale\",this._scaleObject(i,r))},_setCursorFromEvent:function(t,e){if(!e)return this.setCursor(this.defaultCursor),!1;var i=e.hoverCursor||this.hoverCursor;if(e.selectable){var r=this.getActiveGroup(),n=e._findTargetCorner&&(!r||!r.contains(e))&&e._findTargetCorner(this.getPointer(t,!0));n?this._setCornerCursor(n,e,t):this.setCursor(i)}else this.setCursor(i);return!0},_setCornerCursor:function(e,i,r){if(e in t)this.setCursor(this._getRotatedCornerCursor(e,i,r));else{if(\"mtr\"!==e||!i.hasRotatingPoint)return this.setCursor(this.defaultCursor),!1;this.setCursor(this.rotationCursor)}},_getRotatedCornerCursor:function(e,i,r){var n=Math.round(i.getAngle()%360/45);return 0>n&&(n+=8),n+=t[e],r[this.altActionKey]&&t[e]%2===0&&(n+=2),n%=8,this.cursorMap[n]}})}(),function(){var t=Math.min,e=Math.max;fabric.util.object.extend(fabric.Canvas.prototype,{_shouldGroup:function(t,e){var i=this.getActiveObject();return t[this.selectionKey]&&e&&e.selectable&&(this.getActiveGroup()||i&&i!==e)&&this.selection},_handleGrouping:function(t,e){e===this.getActiveGroup()&&(e=this.findTarget(t,!0),!e||e.isType(\"group\"))||(this.getActiveGroup()?this._updateActiveGroup(e,t):this._createActiveGroup(e,t),this._activeGroup&&this._activeGroup.saveCoords())},_updateActiveGroup:function(t,e){var i=this.getActiveGroup();if(i.contains(t)){if(i.removeWithUpdate(t),t.set(\"active\",!1),1===i.size())return this.discardActiveGroup(e),void this.setActiveObject(i.item(0))}else i.addWithUpdate(t);this.fire(\"selection:created\",{target:i,e:e}),i.set(\"active\",!0)},_createActiveGroup:function(t,e){if(this._activeObject&&t!==this._activeObject){var i=this._createGroup(t);i.addWithUpdate(),this.setActiveGroup(i),this._activeObject=null,this.fire(\"selection:created\",{target:i,e:e})}t.set(\"active\",!0)},_createGroup:function(t){var e=this.getObjects(),i=e.indexOf(this._activeObject)<e.indexOf(t),r=i?[this._activeObject,t]:[t,this._activeObject];return new fabric.Group(r,{canvas:this})},_groupSelectedObjects:function(t){var e=this._collectObjects();1===e.length?this.setActiveObject(e[0],t):e.length>1&&(e=new fabric.Group(e.reverse(),{canvas:this}),e.addWithUpdate(),this.setActiveGroup(e,t),e.saveCoords(),this.fire(\"selection:created\",{target:e}),this.renderAll())},_collectObjects:function(){for(var i,r=[],n=this._groupSelector.ex,s=this._groupSelector.ey,o=n+this._groupSelector.left,a=s+this._groupSelector.top,h=new fabric.Point(t(n,o),t(s,a)),c=new fabric.Point(e(n,o),e(s,a)),l=n===o&&s===a,u=this._objects.length;u--&&(i=this._objects[u],!(i&&i.selectable&&i.visible&&(i.intersectsWithRect(h,c)||i.isContainedWithinRect(h,c)||i.containsPoint(h)||i.containsPoint(c))&&(i.set(\"active\",!0),r.push(i),l))););return r},_maybeGroupObjects:function(t){this.selection&&this._groupSelector&&this._groupSelectedObjects(t);var e=this.getActiveGroup();e&&(e.setObjectsCoords().setCoords(),e.isMoving=!1,this.setCursor(this.defaultCursor)),this._groupSelector=null,this._currentTransform=null}})}(),fabric.util.object.extend(fabric.StaticCanvas.prototype,{toDataURL:function(t){t||(t={});var e=t.format||\"png\",i=t.quality||1,r=t.multiplier||1,n={left:t.left,top:t.top,width:t.width,height:t.height};return this._isRetinaScaling()&&(r*=fabric.devicePixelRatio),1!==r?this.__toDataURLWithMultiplier(e,i,n,r):this.__toDataURL(e,i,n)},__toDataURL:function(t,e,i){this.renderAll();var r=this.contextContainer.canvas,n=this.__getCroppedCanvas(r,i);\"jpg\"===t&&(t=\"jpeg\");var s=fabric.StaticCanvas.supports(\"toDataURLWithQuality\")?(n||r).toDataURL(\"image/\"+t,e):(n||r).toDataURL(\"image/\"+t);return n&&(n=null),s},__getCroppedCanvas:function(t,e){var i,r,n=\"left\"in e||\"top\"in e||\"width\"in e||\"height\"in e;return n&&(i=fabric.util.createCanvasElement(),r=i.getContext(\"2d\"),i.width=e.width||this.width,i.height=e.height||this.height,r.drawImage(t,-e.left||0,-e.top||0)),i},__toDataURLWithMultiplier:function(t,e,i,r){var n=this.getWidth(),s=this.getHeight(),o=n*r,a=s*r,h=this.getActiveObject(),c=this.getActiveGroup(),l=this.getZoom(),u=l*r/fabric.devicePixelRatio;r>1&&this.setDimensions({width:o,height:a}),this.setZoom(u),i.left&&(i.left*=r),i.top&&(i.top*=r),i.width?i.width*=r:1>r&&(i.width=o),i.height?i.height*=r:1>r&&(i.height=a),c?this._tempRemoveBordersControlsFromGroup(c):h&&this.deactivateAll&&this.deactivateAll();var f=this.__toDataURL(t,e,i);return c?this._restoreBordersControlsOnGroup(c):h&&this.setActiveObject&&this.setActiveObject(h),this.setZoom(l),this.setDimensions({width:n,height:s}),f},toDataURLWithMultiplier:function(t,e,i){return this.toDataURL({format:t,multiplier:e,quality:i})},_tempRemoveBordersControlsFromGroup:function(t){t.origHasControls=t.hasControls,t.origBorderColor=t.borderColor,t.hasControls=!0,t.borderColor=\"rgba(0,0,0,0)\",t.forEachObject(function(t){t.origBorderColor=t.borderColor,t.borderColor=\"rgba(0,0,0,0)\"})},_restoreBordersControlsOnGroup:function(t){t.hideControls=t.origHideControls,t.borderColor=t.origBorderColor,t.forEachObject(function(t){t.borderColor=t.origBorderColor,delete t.origBorderColor})}}),fabric.util.object.extend(fabric.StaticCanvas.prototype,{loadFromDatalessJSON:function(t,e,i){return this.loadFromJSON(t,e,i)},loadFromJSON:function(t,e,i){if(t){var r=\"string\"==typeof t?JSON.parse(t):fabric.util.object.clone(t);this.clear();var n=this;this._enlivenObjects(r.objects,function(){n._setBgOverlay(r,e)},i),delete r.objects,delete r.backgroundImage,delete r.overlayImage,delete r.background,delete r.overlay;for(var s in r)this[s]=r[s];return this}},_setBgOverlay:function(t,e){var i=this,r={backgroundColor:!1,overlayColor:!1,backgroundImage:!1,overlayImage:!1};if(!(t.backgroundImage||t.overlayImage||t.background||t.overlay))return void(e&&e());var n=function(){r.backgroundImage&&r.overlayImage&&r.backgroundColor&&r.overlayColor&&(i.renderAll(),e&&e())};this.__setBgOverlay(\"backgroundImage\",t.backgroundImage,r,n),this.__setBgOverlay(\"overlayImage\",t.overlayImage,r,n),this.__setBgOverlay(\"backgroundColor\",t.background,r,n),this.__setBgOverlay(\"overlayColor\",t.overlay,r,n),n()},__setBgOverlay:function(t,e,i,r){var n=this;return e?void(\"backgroundImage\"===t||\"overlayImage\"===t?fabric.Image.fromObject(e,function(e){n[t]=e,i[t]=!0,r&&r()}):this[\"set\"+fabric.util.string.capitalize(t,!0)](e,function(){i[t]=!0,r&&r()})):void(i[t]=!0)},_enlivenObjects:function(t,e,i){var r=this;if(!t||0===t.length)return void(e&&e());var n=this.renderOnAddRemove;this.renderOnAddRemove=!1,fabric.util.enlivenObjects(t,function(t){t.forEach(function(t,e){r.insertAt(t,e,!0)}),r.renderOnAddRemove=n,e&&e()},null,i)},_toDataURL:function(t,e){this.clone(function(i){e(i.toDataURL(t))})},_toDataURLWithMultiplier:function(t,e,i){this.clone(function(r){i(r.toDataURLWithMultiplier(t,e))})},clone:function(t,e){var i=JSON.stringify(this.toJSON(e));this.cloneWithoutData(function(e){e.loadFromJSON(i,function(){t&&t(e)})})},cloneWithoutData:function(t){var e=fabric.document.createElement(\"canvas\");e.width=this.getWidth(),e.height=this.getHeight();var i=new fabric.Canvas(e);i.clipTo=this.clipTo,this.backgroundImage?(i.setBackgroundImage(this.backgroundImage.src,function(){i.renderAll(),t&&t(i)}),i.backgroundImageOpacity=this.backgroundImageOpacity,i.backgroundImageStretch=this.backgroundImageStretch):t&&t(i)}}),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend,r=e.util.toFixed,n=e.util.string.capitalize,s=e.util.degreesToRadians,o=e.StaticCanvas.supports(\"setLineDash\");e.Object||(e.Object=e.util.createClass({type:\"object\",originX:\"left\",originY:\"top\",top:0,left:0,width:0,height:0,scaleX:1,scaleY:1,flipX:!1,flipY:!1,opacity:1,angle:0,skewX:0,skewY:0,cornerSize:13,transparentCorners:!0,hoverCursor:null,moveCursor:null,padding:0,borderColor:\"rgba(102,153,255,0.75)\",borderDashArray:null,cornerColor:\"rgba(102,153,255,0.5)\",cornerStrokeColor:null,cornerStyle:\"rect\",cornerDashArray:null,centeredScaling:!1,centeredRotation:!0,fill:\"rgb(0,0,0)\",fillRule:\"nonzero\",globalCompositeOperation:\"source-over\",backgroundColor:\"\",selectionBackgroundColor:\"\",stroke:null,strokeWidth:1,strokeDashArray:null,strokeLineCap:\"butt\",strokeLineJoin:\"miter\",strokeMiterLimit:10,shadow:null,borderOpacityWhenMoving:.4,borderScaleFactor:1,transformMatrix:null,minScaleLimit:.01,selectable:!0,evented:!0,visible:!0,hasControls:!0,hasBorders:!0,hasRotatingPoint:!0,rotatingPointOffset:40,perPixelTargetFind:!1,includeDefaultValues:!0,clipTo:null,lockMovementX:!1,lockMovementY:!1,lockRotation:!1,lockScalingX:!1,lockScalingY:!1,lockUniScaling:!1,lockSkewingX:!1,lockSkewingY:!1,lockScalingFlip:!1,stateProperties:\"top left width height scaleX scaleY flipX flipY originX originY transformMatrix stroke strokeWidth strokeDashArray strokeLineCap strokeLineJoin strokeMiterLimit angle opacity fill fillRule globalCompositeOperation shadow clipTo visible backgroundColor alignX alignY meetOrSlice skewX skewY\".split(\" \"),initialize:function(t){t&&this.setOptions(t)},_initGradient:function(t){!t.fill||!t.fill.colorStops||t.fill instanceof e.Gradient||this.set(\"fill\",new e.Gradient(t.fill)),!t.stroke||!t.stroke.colorStops||t.stroke instanceof e.Gradient||this.set(\"stroke\",new e.Gradient(t.stroke))},_initPattern:function(t){!t.fill||!t.fill.source||t.fill instanceof e.Pattern||this.set(\"fill\",new e.Pattern(t.fill)),!t.stroke||!t.stroke.source||t.stroke instanceof e.Pattern||this.set(\"stroke\",new e.Pattern(t.stroke))},_initClipping:function(t){if(t.clipTo&&\"string\"==typeof t.clipTo){var i=e.util.getFunctionBody(t.clipTo);\"undefined\"!=typeof i&&(this.clipTo=new Function(\"ctx\",i))}},setOptions:function(t){for(var e in t)this.set(e,t[e]);this._initGradient(t),this._initPattern(t),this._initClipping(t)},transform:function(t,e){this.group&&this.canvas.preserveObjectStacking&&this.group===this.canvas._activeGroup&&this.group.transform(t);var i=e?this._getLeftTopCoords():this.getCenterPoint();t.translate(i.x,i.y),t.rotate(s(this.angle)),t.scale(this.scaleX*(this.flipX?-1:1),this.scaleY*(this.flipY?-1:1)),t.transform(1,0,Math.tan(s(this.skewX)),1,0,0),t.transform(1,Math.tan(s(this.skewY)),0,1,0,0)},toObject:function(t){var i=e.Object.NUM_FRACTION_DIGITS,n={type:this.type,originX:this.originX,originY:this.originY,left:r(this.left,i),top:r(this.top,i),width:r(this.width,i),height:r(this.height,i),fill:this.fill&&this.fill.toObject?this.fill.toObject():this.fill,stroke:this.stroke&&this.stroke.toObject?this.stroke.toObject():this.stroke,strokeWidth:r(this.strokeWidth,i),strokeDashArray:this.strokeDashArray?this.strokeDashArray.concat():this.strokeDashArray,strokeLineCap:this.strokeLineCap,strokeLineJoin:this.strokeLineJoin,strokeMiterLimit:r(this.strokeMiterLimit,i),scaleX:r(this.scaleX,i),scaleY:r(this.scaleY,i),angle:r(this.getAngle(),i),flipX:this.flipX,flipY:this.flipY,opacity:r(this.opacity,i),shadow:this.shadow&&this.shadow.toObject?this.shadow.toObject():this.shadow,visible:this.visible,clipTo:this.clipTo&&String(this.clipTo),backgroundColor:this.backgroundColor,fillRule:this.fillRule,globalCompositeOperation:this.globalCompositeOperation,transformMatrix:this.transformMatrix?this.transformMatrix.concat():this.transformMatrix,skewX:r(this.skewX,i),skewY:r(this.skewY,i)};return this.includeDefaultValues||(n=this._removeDefaultValues(n)),e.util.populateWithProperties(this,n,t),n},toDatalessObject:function(t){return this.toObject(t)},_removeDefaultValues:function(t){var i=e.util.getKlass(t.type).prototype,r=i.stateProperties;return r.forEach(function(e){t[e]===i[e]&&delete t[e];var r=\"[object Array]\"===Object.prototype.toString.call(t[e])&&\"[object Array]\"===Object.prototype.toString.call(i[e]);r&&0===t[e].length&&0===i[e].length&&delete t[e]}),t},toString:function(){return\"#<fabric.\"+n(this.type)+\">\"},get:function(t){return this[t]},_setObject:function(t){for(var e in t)this._set(e,t[e])},set:function(t,e){return\"object\"==typeof t?this._setObject(t):\"function\"==typeof e&&\"clipTo\"!==t?this._set(t,e(this.get(t))):this._set(t,e),this},_set:function(t,i){var r=\"scaleX\"===t||\"scaleY\"===t;return r&&(i=this._constrainScale(i)),\"scaleX\"===t&&0>i?(this.flipX=!this.flipX,i*=-1):\"scaleY\"===t&&0>i?(this.flipY=!this.flipY,i*=-1):\"shadow\"!==t||!i||i instanceof e.Shadow||(i=new e.Shadow(i)),this[t]=i,\"width\"!==t&&\"height\"!==t||(this.minScaleLimit=Math.min(.1,1/Math.max(this.width,this.height))),this},setOnGroup:function(){},toggle:function(t){var e=this.get(t);return\"boolean\"==typeof e&&this.set(t,!e),this},setSourcePath:function(t){return this.sourcePath=t,this},getViewportTransform:function(){return this.canvas&&this.canvas.viewportTransform?this.canvas.viewportTransform:[1,0,0,1,0,0]},render:function(t,i){0===this.width&&0===this.height||!this.visible||(t.save(),this._setupCompositeOperation(t),this.drawSelectionBackground(t),i||this.transform(t),this._setStrokeStyles(t),this._setFillStyles(t),this.transformMatrix&&t.transform.apply(t,this.transformMatrix),this._setOpacity(t),this._setShadow(t),this.clipTo&&e.util.clipContext(this,t),this._render(t,i),this.clipTo&&t.restore(),t.restore())},_setOpacity:function(t){this.group&&this.group._setOpacity(t),t.globalAlpha*=this.opacity},_setStrokeStyles:function(t){this.stroke&&(t.lineWidth=this.strokeWidth,t.lineCap=this.strokeLineCap,t.lineJoin=this.strokeLineJoin,t.miterLimit=this.strokeMiterLimit,t.strokeStyle=this.stroke.toLive?this.stroke.toLive(t,this):this.stroke)},_setFillStyles:function(t){this.fill&&(t.fillStyle=this.fill.toLive?this.fill.toLive(t,this):this.fill)},_setLineDash:function(t,e,i){e&&(1&e.length&&e.push.apply(e,e),o?t.setLineDash(e):i&&i(t))},_renderControls:function(t,i){if(!(!this.active||i||this.group&&this.group!==this.canvas.getActiveGroup())){var r,n=this.getViewportTransform(),o=this.calcTransformMatrix();o=e.util.multiplyTransformMatrices(n,o),r=e.util.qrDecompose(o),t.save(),t.translate(r.translateX,r.translateY),t.lineWidth=1/this.borderScaleFactor,t.globalAlpha=this.isMoving?this.borderOpacityWhenMoving:1,this.group&&this.group===this.canvas.getActiveGroup()?(t.rotate(s(r.angle)),this.drawBordersInGroup(t,r)):(t.rotate(s(this.angle)),this.drawBorders(t)),this.drawControls(t),t.restore()}},_setShadow:function(t){if(this.shadow){var i=this.canvas&&this.canvas.viewportTransform[0]||1,r=this.canvas&&this.canvas.viewportTransform[3]||1;this.canvas&&this.canvas._isRetinaScaling()&&(i*=e.devicePixelRatio,r*=e.devicePixelRatio),t.shadowColor=this.shadow.color,t.shadowBlur=this.shadow.blur*(i+r)*(this.scaleX+this.scaleY)/4,t.shadowOffsetX=this.shadow.offsetX*i*this.scaleX,t.shadowOffsetY=this.shadow.offsetY*r*this.scaleY}},_removeShadow:function(t){this.shadow&&(t.shadowColor=\"\",t.shadowBlur=t.shadowOffsetX=t.shadowOffsetY=0)},_renderFill:function(t){if(this.fill){if(t.save(),this.fill.gradientTransform){var e=this.fill.gradientTransform;t.transform.apply(t,e)}this.fill.toLive&&t.translate(-this.width/2+this.fill.offsetX||0,-this.height/2+this.fill.offsetY||0),\"evenodd\"===this.fillRule?t.fill(\"evenodd\"):t.fill(),t.restore()}},_renderStroke:function(t){if(this.stroke&&0!==this.strokeWidth){if(this.shadow&&!this.shadow.affectStroke&&this._removeShadow(t),t.save(),this._setLineDash(t,this.strokeDashArray,this._renderDashedStroke),this.stroke.gradientTransform){var e=this.stroke.gradientTransform;t.transform.apply(t,e)}this.stroke.toLive&&t.translate(-this.width/2+this.stroke.offsetX||0,-this.height/2+this.stroke.offsetY||0),t.stroke(),t.restore()}},clone:function(t,i){return this.constructor.fromObject?this.constructor.fromObject(this.toObject(i),t):new e.Object(this.toObject(i))},cloneAsImage:function(t){var i=this.toDataURL();return e.util.loadImage(i,function(i){t&&t(new e.Image(i))}),this},toDataURL:function(t){t||(t={});var i=e.util.createCanvasElement(),r=this.getBoundingRect();i.width=r.width,i.height=r.height,e.util.wrapElement(i,\"div\");var n=new e.StaticCanvas(i);\"jpg\"===t.format&&(t.format=\"jpeg\"),\"jpeg\"===t.format&&(n.backgroundColor=\"#fff\");var s={active:this.get(\"active\"),left:this.getLeft(),top:this.getTop()};this.set(\"active\",!1),this.setPositionByOrigin(new e.Point(n.getWidth()/2,n.getHeight()/2),\"center\",\"center\");var o=this.canvas;n.add(this);var a=n.toDataURL(t);return this.set(s).setCoords(),this.canvas=o,n.dispose(),n=null,a},isType:function(t){return this.type===t},complexity:function(){return 0},toJSON:function(t){return this.toObject(t)},setGradient:function(t,i){i||(i={});var r={colorStops:[]};r.type=i.type||(i.r1||i.r2?\"radial\":\"linear\"),r.coords={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2},(i.r1||i.r2)&&(r.coords.r1=i.r1,r.coords.r2=i.r2),i.gradientTransform&&(r.gradientTransform=i.gradientTransform);for(var n in i.colorStops){var s=new e.Color(i.colorStops[n]);r.colorStops.push({offset:n,color:s.toRgb(),opacity:s.getAlpha()})}return this.set(t,e.Gradient.forObject(this,r))},setPatternFill:function(t){return this.set(\"fill\",new e.Pattern(t))},setShadow:function(t){return this.set(\"shadow\",t?new e.Shadow(t):null)},setColor:function(t){return this.set(\"fill\",t),this},setAngle:function(t){var e=(\"center\"!==this.originX||\"center\"!==this.originY)&&this.centeredRotation;return e&&this._setOriginToCenter(),this.set(\"angle\",t),e&&this._resetOrigin(),this},centerH:function(){return this.canvas.centerObjectH(this),this},centerV:function(){return this.canvas.centerObjectV(this),this},center:function(){return this.canvas.centerObject(this),this},remove:function(){return this.canvas.remove(this),this},getLocalPointer:function(t,i){i=i||this.canvas.getPointer(t);var r=new e.Point(i.x,i.y),n=this._getLeftTopCoords();return this.angle&&(r=e.util.rotatePoint(r,n,e.util.degreesToRadians(-this.angle))),{x:r.x-n.x,y:r.y-n.y}},_setupCompositeOperation:function(t){this.globalCompositeOperation&&(t.globalCompositeOperation=this.globalCompositeOperation)}}),e.util.createAccessors(e.Object),e.Object.prototype.rotate=e.Object.prototype.setAngle,i(e.Object.prototype,e.Observable),e.Object.NUM_FRACTION_DIGITS=2,e.Object.__uid=0)}(\"undefined\"!=typeof exports?exports:this),function(){var t=fabric.util.degreesToRadians,e={left:-.5,center:0,right:.5},i={top:-.5,center:0,bottom:.5};fabric.util.object.extend(fabric.Object.prototype,{translateToGivenOrigin:function(t,r,n,s,o){var a,h=t.x,c=t.y,l=e[s]-e[r],u=i[o]-i[n];return(l||u)&&(a=this._getTransformedDimensions(),h=t.x+l*a.x,c=t.y+u*a.y),new fabric.Point(h,c)},translateToCenterPoint:function(e,i,r){var n=this.translateToGivenOrigin(e,i,r,\"center\",\"center\");return this.angle?fabric.util.rotatePoint(n,e,t(this.angle)):n},translateToOriginPoint:function(e,i,r){var n=this.translateToGivenOrigin(e,\"center\",\"center\",i,r);return this.angle?fabric.util.rotatePoint(n,e,t(this.angle)):n},getCenterPoint:function(){var t=new fabric.Point(this.left,this.top);return this.translateToCenterPoint(t,this.originX,this.originY)},getPointByOrigin:function(t,e){var i=this.getCenterPoint();return this.translateToOriginPoint(i,t,e)},toLocalPoint:function(e,i,r){var n,s,o=this.getCenterPoint();return n=i&&r?this.translateToGivenOrigin(o,\"center\",\"center\",i,r):new fabric.Point(this.left,this.top),s=new fabric.Point(e.x,e.y),this.angle&&(s=fabric.util.rotatePoint(s,o,-t(this.angle))),s.subtractEquals(n)},setPositionByOrigin:function(t,e,i){var r=this.translateToCenterPoint(t,e,i),n=this.translateToOriginPoint(r,this.originX,this.originY);this.set(\"left\",n.x),this.set(\"top\",n.y)},adjustPosition:function(i){var r=t(this.angle),n=this.getWidth(),s=Math.cos(r)*n,o=Math.sin(r)*n;this.left+=s*(e[i]-e[this.originX]),this.top+=o*(e[i]-e[this.originX]),this.setCoords(),this.originX=i},_setOriginToCenter:function(){this._originalOriginX=this.originX,this._originalOriginY=this.originY;var t=this.getCenterPoint();this.originX=\"center\",this.originY=\"center\",this.left=t.x,this.top=t.y},_resetOrigin:function(){var t=this.translateToOriginPoint(this.getCenterPoint(),this._originalOriginX,this._originalOriginY);this.originX=this._originalOriginX,this.originY=this._originalOriginY,this.left=t.x,this.top=t.y,this._originalOriginX=null,this._originalOriginY=null},_getLeftTopCoords:function(){return this.translateToOriginPoint(this.getCenterPoint(),\"left\",\"top\")}})}(),function(){function t(t){return[new fabric.Point(t.tl.x,t.tl.y),new fabric.Point(t.tr.x,t.tr.y),new fabric.Point(t.br.x,t.br.y),new fabric.Point(t.bl.x,t.bl.y)]}var e=fabric.util.degreesToRadians,i=fabric.util.multiplyTransformMatrices;fabric.util.object.extend(fabric.Object.prototype,{oCoords:null,intersectsWithRect:function(e,i){var r=t(this.oCoords),n=fabric.Intersection.intersectPolygonRectangle(r,e,i);return\"Intersection\"===n.status},intersectsWithObject:function(e){var i=fabric.Intersection.intersectPolygonPolygon(t(this.oCoords),t(e.oCoords));return\"Intersection\"===i.status},isContainedWithinObject:function(t){var e=t.getBoundingRect(),i=new fabric.Point(e.left,e.top),r=new fabric.Point(e.left+e.width,e.top+e.height);return this.isContainedWithinRect(i,r)},isContainedWithinRect:function(t,e){var i=this.getBoundingRect();return i.left>=t.x&&i.left+i.width<=e.x&&i.top>=t.y&&i.top+i.height<=e.y},containsPoint:function(t){var e=this._getImageLines(this.oCoords),i=this._findCrossPoints(t,e);return 0!==i&&i%2===1},_getImageLines:function(t){return{topline:{o:t.tl,d:t.tr},rightline:{o:t.tr,d:t.br},bottomline:{o:t.br,d:t.bl},leftline:{o:t.bl,d:t.tl}}},_findCrossPoints:function(t,e){var i,r,n,s,o,a,h,c=0;for(var l in e)if(h=e[l],!(h.o.y<t.y&&h.d.y<t.y||h.o.y>=t.y&&h.d.y>=t.y||(h.o.x===h.d.x&&h.o.x>=t.x?(o=h.o.x,a=t.y):(i=0,r=(h.d.y-h.o.y)/(h.d.x-h.o.x),n=t.y-i*t.x,s=h.o.y-r*h.o.x,o=-(n-s)/(i-r),a=n+i*o),o>=t.x&&(c+=1),2!==c)))break;return c},getBoundingRectWidth:function(){return this.getBoundingRect().width},getBoundingRectHeight:function(){return this.getBoundingRect().height},getBoundingRect:function(){return this.oCoords||this.setCoords(),fabric.util.makeBoundingBoxFromPoints([this.oCoords.tl,this.oCoords.tr,this.oCoords.br,this.oCoords.bl])},getWidth:function(){return this._getTransformedDimensions().x},getHeight:function(){return this._getTransformedDimensions().y},_constrainScale:function(t){return Math.abs(t)<this.minScaleLimit?0>t?-this.minScaleLimit:this.minScaleLimit:t},scale:function(t){return t=this._constrainScale(t),0>t&&(this.flipX=!this.flipX,this.flipY=!this.flipY,t*=-1),this.scaleX=t,this.scaleY=t,this.setCoords(),this},scaleToWidth:function(t){var e=this.getBoundingRect().width/this.getWidth();return this.scale(t/this.width/e)},scaleToHeight:function(t){var e=this.getBoundingRect().height/this.getHeight();return this.scale(t/this.height/e)},setCoords:function(){var t=e(this.angle),i=this.getViewportTransform(),r=this._calculateCurrentDimensions(),n=r.x,s=r.y;0>n&&(n=Math.abs(n));var o=Math.sin(t),a=Math.cos(t),h=n>0?Math.atan(s/n):0,c=n/Math.cos(h)/2,l=Math.cos(h+t)*c,u=Math.sin(h+t)*c,f=fabric.util.transformPoint(this.getCenterPoint(),i),d=new fabric.Point(f.x-l,f.y-u),g=new fabric.Point(d.x+n*a,d.y+n*o),p=new fabric.Point(d.x-s*o,d.y+s*a),v=new fabric.Point(f.x+l,f.y+u),b=new fabric.Point((d.x+p.x)/2,(d.y+p.y)/2),m=new fabric.Point((g.x+d.x)/2,(g.y+d.y)/2),y=new fabric.Point((v.x+g.x)/2,(v.y+g.y)/2),_=new fabric.Point((v.x+p.x)/2,(v.y+p.y)/2),x=new fabric.Point(m.x+o*this.rotatingPointOffset,m.y-a*this.rotatingPointOffset);return this.oCoords={tl:d,tr:g,br:v,bl:p,ml:b,mt:m,mr:y,mb:_,mtr:x},this._setCornerCoords&&this._setCornerCoords(),this},_calcRotateMatrix:function(){if(this.angle){var t=e(this.angle),i=Math.cos(t),r=Math.sin(t);return[i,r,-r,i,0,0]}return[1,0,0,1,0,0]},calcTransformMatrix:function(){var t=this.getCenterPoint(),e=[1,0,0,1,t.x,t.y],r=this._calcRotateMatrix(),n=this._calcDimensionsTransformMatrix(this.skewX,this.skewY,!0),s=this.group?this.group.calcTransformMatrix():[1,0,0,1,0,0];return s=i(s,e),s=i(s,r),s=i(s,n)},_calcDimensionsTransformMatrix:function(t,r,n){var s=[1,0,Math.tan(e(t)),1],o=[1,Math.tan(e(r)),0,1],a=this.scaleX*(n&&this.flipX?-1:1),h=this.scaleY*(n&&this.flipY?-1:1),c=[a,0,0,h],l=i(c,s,!0);return i(l,o,!0)}})}(),fabric.util.object.extend(fabric.Object.prototype,{sendToBack:function(){return this.group?fabric.StaticCanvas.prototype.sendToBack.call(this.group,this):this.canvas.sendToBack(this),this},bringToFront:function(){return this.group?fabric.StaticCanvas.prototype.bringToFront.call(this.group,this):this.canvas.bringToFront(this),this},sendBackwards:function(t){return this.group?fabric.StaticCanvas.prototype.sendBackwards.call(this.group,this,t):this.canvas.sendBackwards(this,t),this},bringForward:function(t){return this.group?fabric.StaticCanvas.prototype.bringForward.call(this.group,this,t):this.canvas.bringForward(this,t),this},moveTo:function(t){return this.group?fabric.StaticCanvas.prototype.moveTo.call(this.group,this,t):this.canvas.moveTo(this,t),this}}),function(){function t(t,e){if(e){if(e.toLive)return t+\": url(#SVGID_\"+e.id+\"); \";var i=new fabric.Color(e),r=t+\": \"+e+\"; \",n=i.getAlpha();return 1!==n&&(r=t+\": \"+i.toRgb()+\"; \",r+=t+\"-opacity: \"+n.toString()+\"; \"),r}return t+\": none; \"}fabric.util.object.extend(fabric.Object.prototype,{getSvgStyles:function(e){var i=this.fillRule,r=this.strokeWidth?this.strokeWidth:\"0\",n=this.strokeDashArray?this.strokeDashArray.join(\" \"):\"none\",s=this.strokeLineCap?this.strokeLineCap:\"butt\",o=this.strokeLineJoin?this.strokeLineJoin:\"miter\",a=this.strokeMiterLimit?this.strokeMiterLimit:\"4\",h=\"undefined\"!=typeof this.opacity?this.opacity:\"1\",c=this.visible?\"\":\" visibility: hidden;\",l=e?\"\":this.getSvgFilter(),u=t(\"fill\",this.fill),f=t(\"stroke\",this.stroke);return[f,\"stroke-width: \",r,\"; \",\"stroke-dasharray: \",n,\"; \",\"stroke-linecap: \",s,\"; \",\"stroke-linejoin: \",o,\"; \",\"stroke-miterlimit: \",a,\"; \",u,\"fill-rule: \",i,\"; \",\"opacity: \",h,\";\",l,c].join(\"\")},getSvgFilter:function(){return this.shadow?\"filter: url(#SVGID_\"+this.shadow.id+\");\":\"\"},getSvgTransform:function(){if(this.group&&\"path-group\"===this.group.type)return\"\";var t=fabric.util.toFixed,e=this.getAngle(),i=this.getSkewX()%360,r=this.getSkewY()%360,n=this.getCenterPoint(),s=fabric.Object.NUM_FRACTION_DIGITS,o=\"path-group\"===this.type?\"\":\"translate(\"+t(n.x,s)+\" \"+t(n.y,s)+\")\",a=0!==e?\" rotate(\"+t(e,s)+\")\":\"\",h=1===this.scaleX&&1===this.scaleY?\"\":\" scale(\"+t(this.scaleX,s)+\" \"+t(this.scaleY,s)+\")\",c=0!==i?\" skewX(\"+t(i,s)+\")\":\"\",l=0!==r?\" skewY(\"+t(r,s)+\")\":\"\",u=\"path-group\"===this.type?this.width:0,f=this.flipX?\" matrix(-1 0 0 1 \"+u+\" 0) \":\"\",d=\"path-group\"===this.type?this.height:0,g=this.flipY?\" matrix(1 0 0 -1 0 \"+d+\")\":\"\";\nreturn[o,a,h,f,g,c,l].join(\"\")},getSvgTransformMatrix:function(){return this.transformMatrix?\" matrix(\"+this.transformMatrix.join(\" \")+\") \":\"\"},_createBaseSVGMarkup:function(){var t=[];return this.fill&&this.fill.toLive&&t.push(this.fill.toSVG(this,!1)),this.stroke&&this.stroke.toLive&&t.push(this.stroke.toSVG(this,!1)),this.shadow&&t.push(this.shadow.toSVG(this)),t}})}(),fabric.util.object.extend(fabric.Object.prototype,{hasStateChanged:function(){return this.stateProperties.some(function(t){return this.get(t)!==this.originalState[t]},this)},saveState:function(t){return this.stateProperties.forEach(function(t){this.originalState[t]=this.get(t)},this),t&&t.stateProperties&&t.stateProperties.forEach(function(t){this.originalState[t]=this.get(t)},this),this},setupState:function(){return this.originalState={},this.saveState(),this}}),function(){var t=fabric.util.degreesToRadians,e=function(){return\"undefined\"!=typeof G_vmlCanvasManager};fabric.util.object.extend(fabric.Object.prototype,{_controlsVisibility:null,_findTargetCorner:function(t){if(!this.hasControls||!this.active)return!1;var e,i,r=t.x,n=t.y;this.__corner=0;for(var s in this.oCoords)if(this.isControlVisible(s)&&(\"mtr\"!==s||this.hasRotatingPoint)&&(!this.get(\"lockUniScaling\")||\"mt\"!==s&&\"mr\"!==s&&\"mb\"!==s&&\"ml\"!==s)&&(i=this._getImageLines(this.oCoords[s].corner),e=this._findCrossPoints({x:r,y:n},i),0!==e&&e%2===1))return this.__corner=s,s;return!1},_setCornerCoords:function(){var e,i,r=this.oCoords,n=t(45-this.angle),s=.707106*this.cornerSize,o=s*Math.cos(n),a=s*Math.sin(n);for(var h in r)e=r[h].x,i=r[h].y,r[h].corner={tl:{x:e-a,y:i-o},tr:{x:e+o,y:i-a},bl:{x:e-o,y:i+a},br:{x:e+a,y:i+o}}},_getNonTransformedDimensions:function(){var t=this.strokeWidth,e=this.width,i=this.height,r=!0,n=!0;return\"line\"===this.type&&\"butt\"===this.strokeLineCap&&(n=e,r=i),n&&(i+=0>i?-t:t),r&&(e+=0>e?-t:t),{x:e,y:i}},_getTransformedDimensions:function(t,e){\"undefined\"==typeof t&&(t=this.skewX),\"undefined\"==typeof e&&(e=this.skewY);var i,r,n=this._getNonTransformedDimensions(),s=n.x/2,o=n.y/2,a=[{x:-s,y:-o},{x:s,y:-o},{x:-s,y:o},{x:s,y:o}],h=this._calcDimensionsTransformMatrix(t,e,!1);for(i=0;i<a.length;i++)a[i]=fabric.util.transformPoint(a[i],h);return r=fabric.util.makeBoundingBoxFromPoints(a),{x:r.width,y:r.height}},_calculateCurrentDimensions:function(){var t=this.getViewportTransform(),e=this._getTransformedDimensions(),i=e.x,r=e.y;return i+=2*this.padding,r+=2*this.padding,fabric.util.transformPoint(new fabric.Point(i,r),t,!0)},drawSelectionBackground:function(e){if(!this.selectionBackgroundColor||!this.active||this.group)return this;e.save();var i=this.getCenterPoint(),r=this._calculateCurrentDimensions();return e.translate(i.x,i.y),e.rotate(t(this.angle)),e.fillStyle=this.selectionBackgroundColor,e.fillRect(-r.x/2,-r.y/2,r.x,r.y),e.restore(),this},drawBorders:function(t){if(!this.hasBorders)return this;var e=this._calculateCurrentDimensions(),i=1/this.borderScaleFactor,r=e.x+i,n=e.y+i;if(t.save(),t.strokeStyle=this.borderColor,this._setLineDash(t,this.borderDashArray,null),t.strokeRect(-r/2,-n/2,r,n),this.hasRotatingPoint&&this.isControlVisible(\"mtr\")&&!this.get(\"lockRotation\")&&this.hasControls){var s=-n/2;t.beginPath(),t.moveTo(0,s),t.lineTo(0,s-this.rotatingPointOffset),t.closePath(),t.stroke()}return t.restore(),this},drawBordersInGroup:function(t,e){if(!this.hasBorders)return this;var i=this._getNonTransformedDimensions(),r=fabric.util.customTransformMatrix(e.scaleX,e.scaleY,e.skewX),n=fabric.util.transformPoint(i,r),s=1/this.borderScaleFactor,o=n.x+s+2*this.padding,a=n.y+s+2*this.padding;return t.save(),this._setLineDash(t,this.borderDashArray,null),t.strokeStyle=this.borderColor,t.strokeRect(-o/2,-a/2,o,a),t.restore(),this},drawControls:function(t){if(!this.hasControls)return this;var e=this._calculateCurrentDimensions(),i=e.x,r=e.y,n=this.cornerSize,s=-(i+n)/2,o=-(r+n)/2,a=this.transparentCorners?\"stroke\":\"fill\";return t.save(),t.strokeStyle=t.fillStyle=this.cornerColor,this.transparentCorners||(t.strokeStyle=this.cornerStrokeColor),this._setLineDash(t,this.cornerDashArray,null),this._drawControl(\"tl\",t,a,s,o),this._drawControl(\"tr\",t,a,s+i,o),this._drawControl(\"bl\",t,a,s,o+r),this._drawControl(\"br\",t,a,s+i,o+r),this.get(\"lockUniScaling\")||(this._drawControl(\"mt\",t,a,s+i/2,o),this._drawControl(\"mb\",t,a,s+i/2,o+r),this._drawControl(\"mr\",t,a,s+i,o+r/2),this._drawControl(\"ml\",t,a,s,o+r/2)),this.hasRotatingPoint&&this._drawControl(\"mtr\",t,a,s+i/2,o-this.rotatingPointOffset),t.restore(),this},_drawControl:function(t,i,r,n,s){if(this.isControlVisible(t)){var o=this.cornerSize,a=!this.transparentCorners&&this.cornerStrokeColor;switch(this.cornerStyle){case\"circle\":i.beginPath(),i.arc(n+o/2,s+o/2,o/2,0,2*Math.PI,!1),i[r](),a&&i.stroke();break;default:e()||this.transparentCorners||i.clearRect(n,s,o,o),i[r+\"Rect\"](n,s,o,o),a&&i.strokeRect(n,s,o,o)}}},isControlVisible:function(t){return this._getControlsVisibility()[t]},setControlVisible:function(t,e){return this._getControlsVisibility()[t]=e,this},setControlsVisibility:function(t){t||(t={});for(var e in t)this.setControlVisible(e,t[e]);return this},_getControlsVisibility:function(){return this._controlsVisibility||(this._controlsVisibility={tl:!0,tr:!0,br:!0,bl:!0,ml:!0,mt:!0,mr:!0,mb:!0,mtr:!0}),this._controlsVisibility}})}(),fabric.util.object.extend(fabric.StaticCanvas.prototype,{FX_DURATION:500,fxCenterObjectH:function(t,e){e=e||{};var i=function(){},r=e.onComplete||i,n=e.onChange||i,s=this;return fabric.util.animate({startValue:t.get(\"left\"),endValue:this.getCenter().left,duration:this.FX_DURATION,onChange:function(e){t.set(\"left\",e),s.renderAll(),n()},onComplete:function(){t.setCoords(),r()}}),this},fxCenterObjectV:function(t,e){e=e||{};var i=function(){},r=e.onComplete||i,n=e.onChange||i,s=this;return fabric.util.animate({startValue:t.get(\"top\"),endValue:this.getCenter().top,duration:this.FX_DURATION,onChange:function(e){t.set(\"top\",e),s.renderAll(),n()},onComplete:function(){t.setCoords(),r()}}),this},fxRemove:function(t,e){e=e||{};var i=function(){},r=e.onComplete||i,n=e.onChange||i,s=this;return fabric.util.animate({startValue:t.get(\"opacity\"),endValue:0,duration:this.FX_DURATION,onStart:function(){t.set(\"active\",!1)},onChange:function(e){t.set(\"opacity\",e),s.renderAll(),n()},onComplete:function(){s.remove(t),r()}}),this}}),fabric.util.object.extend(fabric.Object.prototype,{animate:function(){if(arguments[0]&&\"object\"==typeof arguments[0]){var t,e,i=[];for(t in arguments[0])i.push(t);for(var r=0,n=i.length;n>r;r++)t=i[r],e=r!==n-1,this._animate(t,arguments[0][t],arguments[1],e)}else this._animate.apply(this,arguments);return this},_animate:function(t,e,i,r){var n,s=this;e=e.toString(),i=i?fabric.util.object.clone(i):{},~t.indexOf(\".\")&&(n=t.split(\".\"));var o=n?this.get(n[0])[n[1]]:this.get(t);\"from\"in i||(i.from=o),e=~e.indexOf(\"=\")?o+parseFloat(e.replace(\"=\",\"\")):parseFloat(e),fabric.util.animate({startValue:i.from,endValue:e,byValue:i.by,easing:i.easing,duration:i.duration,abort:i.abort&&function(){return i.abort.call(s)},onChange:function(e){n?s[n[0]][n[1]]=e:s.set(t,e),r||i.onChange&&i.onChange()},onComplete:function(){r||(s.setCoords(),i.onComplete&&i.onComplete())}})}}),function(t){\"use strict\";function e(t,e){var i=t.origin,r=t.axis1,n=t.axis2,s=t.dimension,o=e.nearest,a=e.center,h=e.farthest;return function(){switch(this.get(i)){case o:return Math.min(this.get(r),this.get(n));case a:return Math.min(this.get(r),this.get(n))+.5*this.get(s);case h:return Math.max(this.get(r),this.get(n))}}}var i=t.fabric||(t.fabric={}),r=i.util.object.extend,n={x1:1,x2:1,y1:1,y2:1},s=i.StaticCanvas.supports(\"setLineDash\");return i.Line?void i.warn(\"fabric.Line is already defined\"):(i.Line=i.util.createClass(i.Object,{type:\"line\",x1:0,y1:0,x2:0,y2:0,initialize:function(t,e){e=e||{},t||(t=[0,0,0,0]),this.callSuper(\"initialize\",e),this.set(\"x1\",t[0]),this.set(\"y1\",t[1]),this.set(\"x2\",t[2]),this.set(\"y2\",t[3]),this._setWidthHeight(e)},_setWidthHeight:function(t){t||(t={}),this.width=Math.abs(this.x2-this.x1),this.height=Math.abs(this.y2-this.y1),this.left=\"left\"in t?t.left:this._getLeftToOriginX(),this.top=\"top\"in t?t.top:this._getTopToOriginY()},_set:function(t,e){return this.callSuper(\"_set\",t,e),\"undefined\"!=typeof n[t]&&this._setWidthHeight(),this},_getLeftToOriginX:e({origin:\"originX\",axis1:\"x1\",axis2:\"x2\",dimension:\"width\"},{nearest:\"left\",center:\"center\",farthest:\"right\"}),_getTopToOriginY:e({origin:\"originY\",axis1:\"y1\",axis2:\"y2\",dimension:\"height\"},{nearest:\"top\",center:\"center\",farthest:\"bottom\"}),_render:function(t,e){if(t.beginPath(),e){var i=this.getCenterPoint();t.translate(i.x-this.strokeWidth/2,i.y-this.strokeWidth/2)}if(!this.strokeDashArray||this.strokeDashArray&&s){var r=this.calcLinePoints();t.moveTo(r.x1,r.y1),t.lineTo(r.x2,r.y2)}t.lineWidth=this.strokeWidth;var n=t.strokeStyle;t.strokeStyle=this.stroke||t.fillStyle,this.stroke&&this._renderStroke(t),t.strokeStyle=n},_renderDashedStroke:function(t){var e=this.calcLinePoints();t.beginPath(),i.util.drawDashedLine(t,e.x1,e.y1,e.x2,e.y2,this.strokeDashArray),t.closePath()},toObject:function(t){return r(this.callSuper(\"toObject\",t),this.calcLinePoints())},calcLinePoints:function(){var t=this.x1<=this.x2?-1:1,e=this.y1<=this.y2?-1:1,i=t*this.width*.5,r=e*this.height*.5,n=t*this.width*-.5,s=e*this.height*-.5;return{x1:i,x2:n,y1:r,y2:s}},toSVG:function(t){var e=this._createBaseSVGMarkup(),i={x1:this.x1,x2:this.x2,y1:this.y1,y2:this.y2};return this.group&&\"path-group\"===this.group.type||(i=this.calcLinePoints()),e.push(\"<line \",'x1=\"',i.x1,'\" y1=\"',i.y1,'\" x2=\"',i.x2,'\" y2=\"',i.y2,'\" style=\"',this.getSvgStyles(),'\" transform=\"',this.getSvgTransform(),this.getSvgTransformMatrix(),'\"/>\\n'),t?t(e.join(\"\")):e.join(\"\")},complexity:function(){return 1}}),i.Line.ATTRIBUTE_NAMES=i.SHARED_ATTRIBUTES.concat(\"x1 y1 x2 y2\".split(\" \")),i.Line.fromElement=function(t,e){var n=i.parseAttributes(t,i.Line.ATTRIBUTE_NAMES),s=[n.x1||0,n.y1||0,n.x2||0,n.y2||0];return new i.Line(s,r(n,e))},void(i.Line.fromObject=function(t){var e=[t.x1,t.y1,t.x2,t.y2];return new i.Line(e,t)}))}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";function e(t){return\"radius\"in t&&t.radius>=0}var i=t.fabric||(t.fabric={}),r=Math.PI,n=i.util.object.extend;return i.Circle?void i.warn(\"fabric.Circle is already defined.\"):(i.Circle=i.util.createClass(i.Object,{type:\"circle\",radius:0,startAngle:0,endAngle:2*r,initialize:function(t){t=t||{},this.callSuper(\"initialize\",t),this.set(\"radius\",t.radius||0),this.startAngle=t.startAngle||this.startAngle,this.endAngle=t.endAngle||this.endAngle},_set:function(t,e){return this.callSuper(\"_set\",t,e),\"radius\"===t&&this.setRadius(e),this},toObject:function(t){return n(this.callSuper(\"toObject\",t),{radius:this.get(\"radius\"),startAngle:this.startAngle,endAngle:this.endAngle})},toSVG:function(t){var e=this._createBaseSVGMarkup(),i=0,n=0,s=(this.endAngle-this.startAngle)%(2*r);if(0===s)this.group&&\"path-group\"===this.group.type&&(i=this.left+this.radius,n=this.top+this.radius),e.push(\"<circle \",'cx=\"'+i+'\" cy=\"'+n+'\" ','r=\"',this.radius,'\" style=\"',this.getSvgStyles(),'\" transform=\"',this.getSvgTransform(),\" \",this.getSvgTransformMatrix(),'\"/>\\n');else{var o=Math.cos(this.startAngle)*this.radius,a=Math.sin(this.startAngle)*this.radius,h=Math.cos(this.endAngle)*this.radius,c=Math.sin(this.endAngle)*this.radius,l=s>r?\"1\":\"0\";e.push('<path d=\"M '+o+\" \"+a,\" A \"+this.radius+\" \"+this.radius,\" 0 \",+l+\" 1\",\" \"+h+\" \"+c,'\" style=\"',this.getSvgStyles(),'\" transform=\"',this.getSvgTransform(),\" \",this.getSvgTransformMatrix(),'\"/>\\n')}return t?t(e.join(\"\")):e.join(\"\")},_render:function(t,e){t.beginPath(),t.arc(e?this.left+this.radius:0,e?this.top+this.radius:0,this.radius,this.startAngle,this.endAngle,!1),this._renderFill(t),this._renderStroke(t)},getRadiusX:function(){return this.get(\"radius\")*this.get(\"scaleX\")},getRadiusY:function(){return this.get(\"radius\")*this.get(\"scaleY\")},setRadius:function(t){return this.radius=t,this.set(\"width\",2*t).set(\"height\",2*t)},complexity:function(){return 1}}),i.Circle.ATTRIBUTE_NAMES=i.SHARED_ATTRIBUTES.concat(\"cx cy r\".split(\" \")),i.Circle.fromElement=function(t,r){r||(r={});var s=i.parseAttributes(t,i.Circle.ATTRIBUTE_NAMES);if(!e(s))throw new Error(\"value of `r` attribute is required and can not be negative\");s.left=s.left||0,s.top=s.top||0;var o=new i.Circle(n(s,r));return o.left-=o.radius,o.top-=o.radius,o},void(i.Circle.fromObject=function(t){return new i.Circle(t)}))}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={});return e.Triangle?void e.warn(\"fabric.Triangle is already defined\"):(e.Triangle=e.util.createClass(e.Object,{type:\"triangle\",initialize:function(t){t=t||{},this.callSuper(\"initialize\",t),this.set(\"width\",t.width||100).set(\"height\",t.height||100)},_render:function(t){var e=this.width/2,i=this.height/2;t.beginPath(),t.moveTo(-e,i),t.lineTo(0,-i),t.lineTo(e,i),t.closePath(),this._renderFill(t),this._renderStroke(t)},_renderDashedStroke:function(t){var i=this.width/2,r=this.height/2;t.beginPath(),e.util.drawDashedLine(t,-i,r,0,-r,this.strokeDashArray),e.util.drawDashedLine(t,0,-r,i,r,this.strokeDashArray),e.util.drawDashedLine(t,i,r,-i,r,this.strokeDashArray),t.closePath()},toSVG:function(t){var e=this._createBaseSVGMarkup(),i=this.width/2,r=this.height/2,n=[-i+\" \"+r,\"0 \"+-r,i+\" \"+r].join(\",\");return e.push(\"<polygon \",'points=\"',n,'\" style=\"',this.getSvgStyles(),'\" transform=\"',this.getSvgTransform(),'\"/>'),t?t(e.join(\"\")):e.join(\"\")},complexity:function(){return 1}}),void(e.Triangle.fromObject=function(t){return new e.Triangle(t)}))}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=2*Math.PI,r=e.util.object.extend;return e.Ellipse?void e.warn(\"fabric.Ellipse is already defined.\"):(e.Ellipse=e.util.createClass(e.Object,{type:\"ellipse\",rx:0,ry:0,initialize:function(t){t=t||{},this.callSuper(\"initialize\",t),this.set(\"rx\",t.rx||0),this.set(\"ry\",t.ry||0)},_set:function(t,e){switch(this.callSuper(\"_set\",t,e),t){case\"rx\":this.rx=e,this.set(\"width\",2*e);break;case\"ry\":this.ry=e,this.set(\"height\",2*e)}return this},getRx:function(){return this.get(\"rx\")*this.get(\"scaleX\")},getRy:function(){return this.get(\"ry\")*this.get(\"scaleY\")},toObject:function(t){return r(this.callSuper(\"toObject\",t),{rx:this.get(\"rx\"),ry:this.get(\"ry\")})},toSVG:function(t){var e=this._createBaseSVGMarkup(),i=0,r=0;return this.group&&\"path-group\"===this.group.type&&(i=this.left+this.rx,r=this.top+this.ry),e.push(\"<ellipse \",'cx=\"',i,'\" cy=\"',r,'\" ','rx=\"',this.rx,'\" ry=\"',this.ry,'\" style=\"',this.getSvgStyles(),'\" transform=\"',this.getSvgTransform(),this.getSvgTransformMatrix(),'\"/>\\n'),t?t(e.join(\"\")):e.join(\"\")},_render:function(t,e){t.beginPath(),t.save(),t.transform(1,0,0,this.ry/this.rx,0,0),t.arc(e?this.left+this.rx:0,e?(this.top+this.ry)*this.rx/this.ry:0,this.rx,0,i,!1),t.restore(),this._renderFill(t),this._renderStroke(t)},complexity:function(){return 1}}),e.Ellipse.ATTRIBUTE_NAMES=e.SHARED_ATTRIBUTES.concat(\"cx cy rx ry\".split(\" \")),e.Ellipse.fromElement=function(t,i){i||(i={});var n=e.parseAttributes(t,e.Ellipse.ATTRIBUTE_NAMES);n.left=n.left||0,n.top=n.top||0;var s=new e.Ellipse(r(n,i));return s.top-=s.ry,s.left-=s.rx,s},void(e.Ellipse.fromObject=function(t){return new e.Ellipse(t)}))}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend;if(e.Rect)return void e.warn(\"fabric.Rect is already defined\");var r=e.Object.prototype.stateProperties.concat();r.push(\"rx\",\"ry\",\"x\",\"y\"),e.Rect=e.util.createClass(e.Object,{stateProperties:r,type:\"rect\",rx:0,ry:0,strokeDashArray:null,initialize:function(t){t=t||{},this.callSuper(\"initialize\",t),this._initRxRy()},_initRxRy:function(){this.rx&&!this.ry?this.ry=this.rx:this.ry&&!this.rx&&(this.rx=this.ry)},_render:function(t,e){if(1===this.width&&1===this.height)return void t.fillRect(-.5,-.5,1,1);var i=this.rx?Math.min(this.rx,this.width/2):0,r=this.ry?Math.min(this.ry,this.height/2):0,n=this.width,s=this.height,o=e?this.left:-this.width/2,a=e?this.top:-this.height/2,h=0!==i||0!==r,c=.4477152502;t.beginPath(),t.moveTo(o+i,a),t.lineTo(o+n-i,a),h&&t.bezierCurveTo(o+n-c*i,a,o+n,a+c*r,o+n,a+r),t.lineTo(o+n,a+s-r),h&&t.bezierCurveTo(o+n,a+s-c*r,o+n-c*i,a+s,o+n-i,a+s),t.lineTo(o+i,a+s),h&&t.bezierCurveTo(o+c*i,a+s,o,a+s-c*r,o,a+s-r),t.lineTo(o,a+r),h&&t.bezierCurveTo(o,a+c*r,o+c*i,a,o+i,a),t.closePath(),this._renderFill(t),this._renderStroke(t)},_renderDashedStroke:function(t){var i=-this.width/2,r=-this.height/2,n=this.width,s=this.height;t.beginPath(),e.util.drawDashedLine(t,i,r,i+n,r,this.strokeDashArray),e.util.drawDashedLine(t,i+n,r,i+n,r+s,this.strokeDashArray),e.util.drawDashedLine(t,i+n,r+s,i,r+s,this.strokeDashArray),e.util.drawDashedLine(t,i,r+s,i,r,this.strokeDashArray),t.closePath()},toObject:function(t){var e=i(this.callSuper(\"toObject\",t),{rx:this.get(\"rx\")||0,ry:this.get(\"ry\")||0});return this.includeDefaultValues||this._removeDefaultValues(e),e},toSVG:function(t){var e=this._createBaseSVGMarkup(),i=this.left,r=this.top;return this.group&&\"path-group\"===this.group.type||(i=-this.width/2,r=-this.height/2),e.push(\"<rect \",'x=\"',i,'\" y=\"',r,'\" rx=\"',this.get(\"rx\"),'\" ry=\"',this.get(\"ry\"),'\" width=\"',this.width,'\" height=\"',this.height,'\" style=\"',this.getSvgStyles(),'\" transform=\"',this.getSvgTransform(),this.getSvgTransformMatrix(),'\"/>\\n'),t?t(e.join(\"\")):e.join(\"\")},complexity:function(){return 1}}),e.Rect.ATTRIBUTE_NAMES=e.SHARED_ATTRIBUTES.concat(\"x y rx ry width height\".split(\" \")),e.Rect.fromElement=function(t,r){if(!t)return null;r=r||{};var n=e.parseAttributes(t,e.Rect.ATTRIBUTE_NAMES);n.left=n.left||0,n.top=n.top||0;var s=new e.Rect(i(r?e.util.object.clone(r):{},n));return s.visible=s.width>0&&s.height>0,s},e.Rect.fromObject=function(t){return new e.Rect(t)}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={});return e.Polyline?void e.warn(\"fabric.Polyline is already defined\"):(e.Polyline=e.util.createClass(e.Object,{type:\"polyline\",points:null,minX:0,minY:0,initialize:function(t,i){return e.Polygon.prototype.initialize.call(this,t,i)},_calcDimensions:function(){return e.Polygon.prototype._calcDimensions.call(this)},_applyPointOffset:function(){return e.Polygon.prototype._applyPointOffset.call(this)},toObject:function(t){return e.Polygon.prototype.toObject.call(this,t)},toSVG:function(t){return e.Polygon.prototype.toSVG.call(this,t)},_render:function(t,i){e.Polygon.prototype.commonRender.call(this,t,i)&&(this._renderFill(t),this._renderStroke(t))},_renderDashedStroke:function(t){var i,r;t.beginPath();for(var n=0,s=this.points.length;s>n;n++)i=this.points[n],r=this.points[n+1]||i,e.util.drawDashedLine(t,i.x,i.y,r.x,r.y,this.strokeDashArray)},complexity:function(){return this.get(\"points\").length}}),e.Polyline.ATTRIBUTE_NAMES=e.SHARED_ATTRIBUTES.concat(),e.Polyline.fromElement=function(t,i){if(!t)return null;i||(i={});var r=e.parsePointsAttribute(t.getAttribute(\"points\")),n=e.parseAttributes(t,e.Polyline.ATTRIBUTE_NAMES);return new e.Polyline(r,e.util.object.extend(n,i))},void(e.Polyline.fromObject=function(t){var i=t.points;return new e.Polyline(i,t,!0)}))}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend,r=e.util.array.min,n=e.util.array.max,s=e.util.toFixed;return e.Polygon?void e.warn(\"fabric.Polygon is already defined\"):(e.Polygon=e.util.createClass(e.Object,{type:\"polygon\",points:null,minX:0,minY:0,initialize:function(t,e){e=e||{},this.points=t||[],this.callSuper(\"initialize\",e),this._calcDimensions(),\"top\"in e||(this.top=this.minY),\"left\"in e||(this.left=this.minX),this.pathOffset={x:this.minX+this.width/2,y:this.minY+this.height/2}},_calcDimensions:function(){var t=this.points,e=r(t,\"x\"),i=r(t,\"y\"),s=n(t,\"x\"),o=n(t,\"y\");this.width=s-e||0,this.height=o-i||0,this.minX=e||0,this.minY=i||0},toObject:function(t){return i(this.callSuper(\"toObject\",t),{points:this.points.concat()})},toSVG:function(t){for(var e,i=[],r=this._createBaseSVGMarkup(),n=0,o=this.points.length;o>n;n++)i.push(s(this.points[n].x,2),\",\",s(this.points[n].y,2),\" \");return this.group&&\"path-group\"===this.group.type||(e=\" translate(\"+-this.pathOffset.x+\", \"+-this.pathOffset.y+\") \"),r.push(\"<\",this.type,\" \",'points=\"',i.join(\"\"),'\" style=\"',this.getSvgStyles(),'\" transform=\"',this.getSvgTransform(),e,\" \",this.getSvgTransformMatrix(),'\"/>\\n'),t?t(r.join(\"\")):r.join(\"\")},_render:function(t,e){this.commonRender(t,e)&&(this._renderFill(t),(this.stroke||this.strokeDashArray)&&(t.closePath(),this._renderStroke(t)))},commonRender:function(t,e){var i,r=this.points.length;if(!r||isNaN(this.points[r-1].y))return!1;e||t.translate(-this.pathOffset.x,-this.pathOffset.y),t.beginPath(),t.moveTo(this.points[0].x,this.points[0].y);for(var n=0;r>n;n++)i=this.points[n],t.lineTo(i.x,i.y);return!0},_renderDashedStroke:function(t){e.Polyline.prototype._renderDashedStroke.call(this,t),t.closePath()},complexity:function(){return this.points.length}}),e.Polygon.ATTRIBUTE_NAMES=e.SHARED_ATTRIBUTES.concat(),e.Polygon.fromElement=function(t,r){if(!t)return null;r||(r={});var n=e.parsePointsAttribute(t.getAttribute(\"points\")),s=e.parseAttributes(t,e.Polygon.ATTRIBUTE_NAMES);return new e.Polygon(n,i(s,r))},void(e.Polygon.fromObject=function(t){return new e.Polygon(t.points,t,!0)}))}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.array.min,r=e.util.array.max,n=e.util.object.extend,s=Object.prototype.toString,o=e.util.drawArc,a={m:2,l:2,h:1,v:1,c:6,s:4,q:4,t:2,a:7},h={m:\"l\",M:\"L\"};return e.Path?void e.warn(\"fabric.Path is already defined\"):(e.Path=e.util.createClass(e.Object,{type:\"path\",path:null,minX:0,minY:0,initialize:function(t,e){e=e||{},this.setOptions(e),t||(t=[]);var i=\"[object Array]\"===s.call(t);this.path=i?t:t.match&&t.match(/[mzlhvcsqta][^mzlhvcsqta]*/gi),this.path&&(i||(this.path=this._parsePath()),this._setPositionDimensions(e),e.sourcePath&&this.setSourcePath(e.sourcePath))},_setPositionDimensions:function(t){var e=this._parseDimensions();this.minX=e.left,this.minY=e.top,this.width=e.width,this.height=e.height,\"undefined\"==typeof t.left&&(this.left=e.left+(\"center\"===this.originX?this.width/2:\"right\"===this.originX?this.width:0)),\"undefined\"==typeof t.top&&(this.top=e.top+(\"center\"===this.originY?this.height/2:\"bottom\"===this.originY?this.height:0)),this.pathOffset=this.pathOffset||{x:this.minX+this.width/2,y:this.minY+this.height/2}},_render:function(t){var e,i,r,n=null,s=0,a=0,h=0,c=0,l=0,u=0,f=-this.pathOffset.x,d=-this.pathOffset.y;this.group&&\"path-group\"===this.group.type&&(f=0,d=0),t.beginPath();for(var g=0,p=this.path.length;p>g;++g){switch(e=this.path[g],e[0]){case\"l\":h+=e[1],c+=e[2],t.lineTo(h+f,c+d);break;case\"L\":h=e[1],c=e[2],t.lineTo(h+f,c+d);break;case\"h\":h+=e[1],t.lineTo(h+f,c+d);break;case\"H\":h=e[1],t.lineTo(h+f,c+d);break;case\"v\":c+=e[1],t.lineTo(h+f,c+d);break;case\"V\":c=e[1],t.lineTo(h+f,c+d);break;case\"m\":h+=e[1],c+=e[2],s=h,a=c,t.moveTo(h+f,c+d);break;case\"M\":h=e[1],c=e[2],s=h,a=c,t.moveTo(h+f,c+d);break;case\"c\":i=h+e[5],r=c+e[6],l=h+e[3],u=c+e[4],t.bezierCurveTo(h+e[1]+f,c+e[2]+d,l+f,u+d,i+f,r+d),h=i,c=r;break;case\"C\":h=e[5],c=e[6],l=e[3],u=e[4],t.bezierCurveTo(e[1]+f,e[2]+d,l+f,u+d,h+f,c+d);break;case\"s\":i=h+e[3],r=c+e[4],null===n[0].match(/[CcSs]/)?(l=h,u=c):(l=2*h-l,u=2*c-u),t.bezierCurveTo(l+f,u+d,h+e[1]+f,c+e[2]+d,i+f,r+d),l=h+e[1],u=c+e[2],h=i,c=r;break;case\"S\":i=e[3],r=e[4],null===n[0].match(/[CcSs]/)?(l=h,u=c):(l=2*h-l,u=2*c-u),t.bezierCurveTo(l+f,u+d,e[1]+f,e[2]+d,i+f,r+d),h=i,c=r,l=e[1],u=e[2];break;case\"q\":i=h+e[3],r=c+e[4],l=h+e[1],u=c+e[2],t.quadraticCurveTo(l+f,u+d,i+f,r+d),h=i,c=r;break;case\"Q\":i=e[3],r=e[4],t.quadraticCurveTo(e[1]+f,e[2]+d,i+f,r+d),h=i,c=r,l=e[1],u=e[2];break;case\"t\":i=h+e[1],r=c+e[2],null===n[0].match(/[QqTt]/)?(l=h,u=c):(l=2*h-l,u=2*c-u),t.quadraticCurveTo(l+f,u+d,i+f,r+d),h=i,c=r;break;case\"T\":i=e[1],r=e[2],null===n[0].match(/[QqTt]/)?(l=h,u=c):(l=2*h-l,u=2*c-u),t.quadraticCurveTo(l+f,u+d,i+f,r+d),h=i,c=r;break;case\"a\":o(t,h+f,c+d,[e[1],e[2],e[3],e[4],e[5],e[6]+h+f,e[7]+c+d]),h+=e[6],c+=e[7];break;case\"A\":o(t,h+f,c+d,[e[1],e[2],e[3],e[4],e[5],e[6]+f,e[7]+d]),h=e[6],c=e[7];break;case\"z\":case\"Z\":h=s,c=a,t.closePath()}n=e}this._renderFill(t),this._renderStroke(t)},toString:function(){return\"#<fabric.Path (\"+this.complexity()+'): { \"top\": '+this.top+', \"left\": '+this.left+\" }>\"},toObject:function(t){var e=n(this.callSuper(\"toObject\",t),{path:this.path.map(function(t){return t.slice()}),pathOffset:this.pathOffset});return this.sourcePath&&(e.sourcePath=this.sourcePath),this.transformMatrix&&(e.transformMatrix=this.transformMatrix),e},toDatalessObject:function(t){var e=this.toObject(t);return this.sourcePath&&(e.path=this.sourcePath),delete e.sourcePath,e},toSVG:function(t){for(var e=[],i=this._createBaseSVGMarkup(),r=\"\",n=0,s=this.path.length;s>n;n++)e.push(this.path[n].join(\" \"));var o=e.join(\" \");return this.group&&\"path-group\"===this.group.type||(r=\" translate(\"+-this.pathOffset.x+\", \"+-this.pathOffset.y+\") \"),i.push(\"<path \",'d=\"',o,'\" style=\"',this.getSvgStyles(),'\" transform=\"',this.getSvgTransform(),r,this.getSvgTransformMatrix(),'\" stroke-linecap=\"round\" ',\"/>\\n\"),t?t(i.join(\"\")):i.join(\"\")},complexity:function(){return this.path.length},_parsePath:function(){for(var t,e,i,r,n,s=[],o=[],c=/([-+]?((\\d+\\.\\d+)|((\\d+)|(\\.\\d+)))(?:e[-+]?\\d+)?)/gi,l=0,u=this.path.length;u>l;l++){for(t=this.path[l],r=t.slice(1).trim(),o.length=0;i=c.exec(r);)o.push(i[0]);n=[t.charAt(0)];for(var f=0,d=o.length;d>f;f++)e=parseFloat(o[f]),isNaN(e)||n.push(e);var g=n[0],p=a[g.toLowerCase()],v=h[g]||g;if(n.length-1>p)for(var b=1,m=n.length;m>b;b+=p)s.push([g].concat(n.slice(b,b+p))),g=v;else s.push(n)}return s},_parseDimensions:function(){for(var t,n,s,o,a=[],h=[],c=null,l=0,u=0,f=0,d=0,g=0,p=0,v=0,b=this.path.length;b>v;++v){switch(t=this.path[v],t[0]){case\"l\":f+=t[1],d+=t[2],o=[];break;case\"L\":f=t[1],d=t[2],o=[];break;case\"h\":f+=t[1],o=[];break;case\"H\":f=t[1],o=[];break;case\"v\":d+=t[1],o=[];break;case\"V\":d=t[1],o=[];break;case\"m\":f+=t[1],d+=t[2],l=f,u=d,o=[];break;case\"M\":f=t[1],d=t[2],l=f,u=d,o=[];break;case\"c\":n=f+t[5],s=d+t[6],g=f+t[3],p=d+t[4],o=e.util.getBoundsOfCurve(f,d,f+t[1],d+t[2],g,p,n,s),f=n,d=s;break;case\"C\":f=t[5],d=t[6],g=t[3],p=t[4],o=e.util.getBoundsOfCurve(f,d,t[1],t[2],g,p,f,d);break;case\"s\":n=f+t[3],s=d+t[4],null===c[0].match(/[CcSs]/)?(g=f,p=d):(g=2*f-g,p=2*d-p),o=e.util.getBoundsOfCurve(f,d,g,p,f+t[1],d+t[2],n,s),g=f+t[1],p=d+t[2],f=n,d=s;break;case\"S\":n=t[3],s=t[4],null===c[0].match(/[CcSs]/)?(g=f,p=d):(g=2*f-g,p=2*d-p),o=e.util.getBoundsOfCurve(f,d,g,p,t[1],t[2],n,s),f=n,d=s,g=t[1],p=t[2];break;case\"q\":n=f+t[3],s=d+t[4],g=f+t[1],p=d+t[2],o=e.util.getBoundsOfCurve(f,d,g,p,g,p,n,s),f=n,d=s;break;case\"Q\":g=t[1],p=t[2],o=e.util.getBoundsOfCurve(f,d,g,p,g,p,t[3],t[4]),f=t[3],d=t[4];break;case\"t\":n=f+t[1],s=d+t[2],null===c[0].match(/[QqTt]/)?(g=f,p=d):(g=2*f-g,p=2*d-p),o=e.util.getBoundsOfCurve(f,d,g,p,g,p,n,s),f=n,d=s;break;case\"T\":n=t[1],s=t[2],null===c[0].match(/[QqTt]/)?(g=f,p=d):(g=2*f-g,p=2*d-p),o=e.util.getBoundsOfCurve(f,d,g,p,g,p,n,s),f=n,d=s;break;case\"a\":o=e.util.getBoundsOfArc(f,d,t[1],t[2],t[3],t[4],t[5],t[6]+f,t[7]+d),f+=t[6],d+=t[7];break;case\"A\":o=e.util.getBoundsOfArc(f,d,t[1],t[2],t[3],t[4],t[5],t[6],t[7]),f=t[6],d=t[7];break;case\"z\":case\"Z\":f=l,d=u}c=t,o.forEach(function(t){a.push(t.x),h.push(t.y)}),a.push(f),h.push(d)}var m=i(a)||0,y=i(h)||0,_=r(a)||0,x=r(h)||0,S=_-m,C=x-y,w={left:m,top:y,width:S,height:C};return w}}),e.Path.fromObject=function(t,i){\"string\"==typeof t.path?e.loadSVGFromURL(t.path,function(r){var n=r[0],s=t.path;delete t.path,e.util.object.extend(n,t),n.setSourcePath(s),i(n)}):i(new e.Path(t.path,t))},e.Path.ATTRIBUTE_NAMES=e.SHARED_ATTRIBUTES.concat([\"d\"]),e.Path.fromElement=function(t,i,r){var s=e.parseAttributes(t,e.Path.ATTRIBUTE_NAMES);i&&i(new e.Path(s.d,n(s,r)))},void(e.Path.async=!0))}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend,r=e.util.array.invoke,n=e.Object.prototype.toObject;return e.PathGroup?void e.warn(\"fabric.PathGroup is already defined\"):(e.PathGroup=e.util.createClass(e.Path,{type:\"path-group\",fill:\"\",initialize:function(t,e){e=e||{},this.paths=t||[];for(var i=this.paths.length;i--;)this.paths[i].group=this;e.toBeParsed&&(this.parseDimensionsFromPaths(e),delete e.toBeParsed),this.setOptions(e),this.setCoords(),e.sourcePath&&this.setSourcePath(e.sourcePath)},parseDimensionsFromPaths:function(t){for(var i,r,n,s,o,a,h=[],c=[],l=this.paths.length;l--;){n=this.paths[l],s=n.height+n.strokeWidth,o=n.width+n.strokeWidth,i=[{x:n.left,y:n.top},{x:n.left+o,y:n.top},{x:n.left,y:n.top+s},{x:n.left+o,y:n.top+s}],a=this.paths[l].transformMatrix;for(var u=0;u<i.length;u++)r=i[u],a&&(r=e.util.transformPoint(r,a,!1)),h.push(r.x),c.push(r.y)}t.width=Math.max.apply(null,h),t.height=Math.max.apply(null,c)},render:function(t){if(this.visible){t.save(),this.transformMatrix&&t.transform.apply(t,this.transformMatrix),this.transform(t),this._setShadow(t),this.clipTo&&e.util.clipContext(this,t),t.translate(-this.width/2,-this.height/2);for(var i=0,r=this.paths.length;r>i;++i)this.paths[i].render(t,!0);this.clipTo&&t.restore(),t.restore()}},_set:function(t,e){if(\"fill\"===t&&e&&this.isSameColor())for(var i=this.paths.length;i--;)this.paths[i]._set(t,e);return this.callSuper(\"_set\",t,e)},toObject:function(t){var e=i(n.call(this,t),{paths:r(this.getObjects(),\"toObject\",t)});return this.sourcePath&&(e.sourcePath=this.sourcePath),e},toDatalessObject:function(t){var e=this.toObject(t);return this.sourcePath&&(e.paths=this.sourcePath),e},toSVG:function(t){var e=this.getObjects(),i=this.getPointByOrigin(\"left\",\"top\"),r=\"translate(\"+i.x+\" \"+i.y+\")\",n=this._createBaseSVGMarkup();n.push(\"<g \",'style=\"',this.getSvgStyles(),'\" ','transform=\"',this.getSvgTransformMatrix(),r,this.getSvgTransform(),'\" ',\">\\n\");for(var s=0,o=e.length;o>s;s++)n.push(\"\t\",e[s].toSVG(t));return n.push(\"</g>\\n\"),t?t(n.join(\"\")):n.join(\"\")},toString:function(){return\"#<fabric.PathGroup (\"+this.complexity()+\"): { top: \"+this.top+\", left: \"+this.left+\" }>\"},isSameColor:function(){var t=this.getObjects()[0].get(\"fill\")||\"\";return\"string\"!=typeof t?!1:(t=t.toLowerCase(),this.getObjects().every(function(e){var i=e.get(\"fill\")||\"\";return\"string\"==typeof i&&i.toLowerCase()===t}))},complexity:function(){return this.paths.reduce(function(t,e){return t+(e&&e.complexity?e.complexity():0)},0)},getObjects:function(){return this.paths}}),e.PathGroup.fromObject=function(t,i){\"string\"==typeof t.paths?e.loadSVGFromURL(t.paths,function(r){var n=t.paths;delete t.paths;var s=e.util.groupSVGElements(r,t,n);i(s)}):e.util.enlivenObjects(t.paths,function(r){delete t.paths,i(new e.PathGroup(r,t))})},void(e.PathGroup.async=!0))}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend,r=e.util.array.min,n=e.util.array.max,s=e.util.array.invoke;if(!e.Group){var o={lockMovementX:!0,lockMovementY:!0,lockRotation:!0,lockScalingX:!0,lockScalingY:!0,lockUniScaling:!0};e.Group=e.util.createClass(e.Object,e.Collection,{type:\"group\",strokeWidth:0,initialize:function(t,e,i){e=e||{},this._objects=[],i&&this.callSuper(\"initialize\",e),this._objects=t||[];for(var r=this._objects.length;r--;)this._objects[r].group=this;this.originalState={},e.originX&&(this.originX=e.originX),e.originY&&(this.originY=e.originY),i?this._updateObjectsCoords(!0):(this._calcBounds(),this._updateObjectsCoords(),this.callSuper(\"initialize\",e)),this.setCoords(),this.saveCoords()},_updateObjectsCoords:function(t){for(var e=this._objects.length;e--;)this._updateObjectCoords(this._objects[e],t)},_updateObjectCoords:function(t,e){if(t.__origHasControls=t.hasControls,t.hasControls=!1,!e){var i=t.getLeft(),r=t.getTop(),n=this.getCenterPoint();t.set({originalLeft:i,originalTop:r,\nleft:i-n.x,top:r-n.y}),t.setCoords()}},toString:function(){return\"#<fabric.Group: (\"+this.complexity()+\")>\"},addWithUpdate:function(t){return this._restoreObjectsState(),e.util.resetObjectTransform(this),t&&(this._objects.push(t),t.group=this,t._set(\"canvas\",this.canvas)),this.forEachObject(this._setObjectActive,this),this._calcBounds(),this._updateObjectsCoords(),this},_setObjectActive:function(t){t.set(\"active\",!0),t.group=this},removeWithUpdate:function(t){return this._restoreObjectsState(),e.util.resetObjectTransform(this),this.forEachObject(this._setObjectActive,this),this.remove(t),this._calcBounds(),this._updateObjectsCoords(),this},_onObjectAdded:function(t){t.group=this,t._set(\"canvas\",this.canvas)},_onObjectRemoved:function(t){delete t.group,t.set(\"active\",!1)},delegatedProperties:{fill:!0,stroke:!0,strokeWidth:!0,fontFamily:!0,fontWeight:!0,fontSize:!0,fontStyle:!0,lineHeight:!0,textDecoration:!0,textAlign:!0,backgroundColor:!0},_set:function(t,e){var i=this._objects.length;if(this.delegatedProperties[t]||\"canvas\"===t)for(;i--;)this._objects[i].set(t,e);else for(;i--;)this._objects[i].setOnGroup(t,e);this.callSuper(\"_set\",t,e)},toObject:function(t){return i(this.callSuper(\"toObject\",t),{objects:s(this._objects,\"toObject\",t)})},render:function(t){if(this.visible){t.save(),this.transformMatrix&&t.transform.apply(t,this.transformMatrix),this.transform(t),this._setShadow(t),this.clipTo&&e.util.clipContext(this,t);for(var i=0,r=this._objects.length;r>i;i++)this._renderObject(this._objects[i],t);this.clipTo&&t.restore(),t.restore()}},_renderControls:function(t,e){this.callSuper(\"_renderControls\",t,e);for(var i=0,r=this._objects.length;r>i;i++)this._objects[i]._renderControls(t)},_renderObject:function(t,e){if(t.visible){var i=t.hasRotatingPoint;t.hasRotatingPoint=!1,t.render(e),t.hasRotatingPoint=i}},_restoreObjectsState:function(){return this._objects.forEach(this._restoreObjectState,this),this},realizeTransform:function(t){var i=t.calcTransformMatrix(),r=e.util.qrDecompose(i),n=new e.Point(r.translateX,r.translateY);return t.scaleX=r.scaleX,t.scaleY=r.scaleY,t.skewX=r.skewX,t.skewY=r.skewY,t.angle=r.angle,t.flipX=!1,t.flipY=!1,t.setPositionByOrigin(n,\"center\",\"center\"),t},_restoreObjectState:function(t){return this.realizeTransform(t),t.setCoords(),t.hasControls=t.__origHasControls,delete t.__origHasControls,t.set(\"active\",!1),delete t.group,this},destroy:function(){return this._restoreObjectsState()},saveCoords:function(){return this._originalLeft=this.get(\"left\"),this._originalTop=this.get(\"top\"),this},hasMoved:function(){return this._originalLeft!==this.get(\"left\")||this._originalTop!==this.get(\"top\")},setObjectsCoords:function(){return this.forEachObject(function(t){t.setCoords()}),this},_calcBounds:function(t){for(var e,i,r,n=[],s=[],o=[\"tr\",\"br\",\"bl\",\"tl\"],a=0,h=this._objects.length,c=o.length;h>a;++a)for(e=this._objects[a],e.setCoords(),r=0;c>r;r++)i=o[r],n.push(e.oCoords[i].x),s.push(e.oCoords[i].y);this.set(this._getBounds(n,s,t))},_getBounds:function(t,i,s){var o=e.util.invertTransform(this.getViewportTransform()),a=e.util.transformPoint(new e.Point(r(t),r(i)),o),h=e.util.transformPoint(new e.Point(n(t),n(i)),o),c={width:h.x-a.x||0,height:h.y-a.y||0};return s||(c.left=a.x||0,c.top=a.y||0,\"center\"===this.originX&&(c.left+=c.width/2),\"right\"===this.originX&&(c.left+=c.width),\"center\"===this.originY&&(c.top+=c.height/2),\"bottom\"===this.originY&&(c.top+=c.height)),c},toSVG:function(t){var e=this._createBaseSVGMarkup();e.push('<g transform=\"',this.getSvgTransform(),this.getSvgTransformMatrix(),'\" style=\"',this.getSvgFilter(),'\">\\n');for(var i=0,r=this._objects.length;r>i;i++)e.push(\"\t\",this._objects[i].toSVG(t));return e.push(\"</g>\\n\"),t?t(e.join(\"\")):e.join(\"\")},get:function(t){if(t in o){if(this[t])return this[t];for(var e=0,i=this._objects.length;i>e;e++)if(this._objects[e][t])return!0;return!1}return t in this.delegatedProperties?this._objects[0]&&this._objects[0].get(t):this[t]}}),e.Group.fromObject=function(t,i){e.util.enlivenObjects(t.objects,function(r){delete t.objects,i&&i(new e.Group(r,t,!0))})},e.Group.async=!0}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=fabric.util.object.extend;return t.fabric||(t.fabric={}),t.fabric.Image?void fabric.warn(\"fabric.Image is already defined.\"):(fabric.Image=fabric.util.createClass(fabric.Object,{type:\"image\",crossOrigin:\"\",alignX:\"none\",alignY:\"none\",meetOrSlice:\"meet\",strokeWidth:0,_lastScaleX:1,_lastScaleY:1,initialize:function(t,e){e||(e={}),this.filters=[],this.resizeFilters=[],this.callSuper(\"initialize\",e),this._initElement(t,e)},getElement:function(){return this._element},setElement:function(t,e,i){return this._element=t,this._originalElement=t,this._initConfig(i),0!==this.filters.length?this.applyFilters(e):e&&e(),this},setCrossOrigin:function(t){return this.crossOrigin=t,this._element.crossOrigin=t,this},getOriginalSize:function(){var t=this.getElement();return{width:t.width,height:t.height}},_stroke:function(t){if(this.stroke&&0!==this.strokeWidth){var e=this.width/2,i=this.height/2;t.beginPath(),t.moveTo(-e,-i),t.lineTo(e,-i),t.lineTo(e,i),t.lineTo(-e,i),t.lineTo(-e,-i),t.closePath()}},_renderDashedStroke:function(t){var e=-this.width/2,i=-this.height/2,r=this.width,n=this.height;t.save(),this._setStrokeStyles(t),t.beginPath(),fabric.util.drawDashedLine(t,e,i,e+r,i,this.strokeDashArray),fabric.util.drawDashedLine(t,e+r,i,e+r,i+n,this.strokeDashArray),fabric.util.drawDashedLine(t,e+r,i+n,e,i+n,this.strokeDashArray),fabric.util.drawDashedLine(t,e,i+n,e,i,this.strokeDashArray),t.closePath(),t.restore()},toObject:function(t){var i=[],r=[],n=this._originalElement,s=1,o=1;this.filters.forEach(function(t){t&&(\"Resize\"===t.type&&(s*=t.scaleX,o*=t.scaleY),i.push(t.toObject()))}),this.resizeFilters.forEach(function(t){t&&r.push(t.toObject())});var a=e(this.callSuper(\"toObject\",t),{src:n?n.src||n._src:\"\",filters:i,resizeFilters:r,crossOrigin:this.crossOrigin,alignX:this.alignX,alignY:this.alignY,meetOrSlice:this.meetOrSlice});return a.width/=s,a.height/=o,this.includeDefaultValues||this._removeDefaultValues(a),a},toSVG:function(t){var e=this._createBaseSVGMarkup(),i=-this.width/2,r=-this.height/2,n=\"none\";if(this.group&&\"path-group\"===this.group.type&&(i=this.left,r=this.top),\"none\"!==this.alignX&&\"none\"!==this.alignY&&(n=\"x\"+this.alignX+\"Y\"+this.alignY+\" \"+this.meetOrSlice),e.push('<g transform=\"',this.getSvgTransform(),this.getSvgTransformMatrix(),'\">\\n','<image xlink:href=\"',this.getSvgSrc(),'\" x=\"',i,'\" y=\"',r,'\" style=\"',this.getSvgStyles(),'\" width=\"',this.width,'\" height=\"',this.height,'\" preserveAspectRatio=\"',n,'\"',\"></image>\\n\"),this.stroke||this.strokeDashArray){var s=this.fill;this.fill=null,e.push(\"<rect \",'x=\"',i,'\" y=\"',r,'\" width=\"',this.width,'\" height=\"',this.height,'\" style=\"',this.getSvgStyles(),'\"/>\\n'),this.fill=s}return e.push(\"</g>\\n\"),t?t(e.join(\"\")):e.join(\"\")},getSrc:function(){return this.getElement()?this.getElement().src||this.getElement()._src:void 0},setSrc:function(t,e,i){fabric.util.loadImage(t,function(t){return this.setElement(t,e,i)},this,i&&i.crossOrigin)},toString:function(){return'#<fabric.Image: { src: \"'+this.getSrc()+'\" }>'},clone:function(t,e){this.constructor.fromObject(this.toObject(e),t)},applyFilters:function(t,e,i,r){if(e=e||this.filters,i=i||this._originalElement){var n=i,s=fabric.util.createCanvasElement(),o=fabric.util.createImage(),a=this;return s.width=n.width,s.height=n.height,s.getContext(\"2d\").drawImage(n,0,0,n.width,n.height),0===e.length?(this._element=i,t&&t(),s):(e.forEach(function(t){t&&t.applyTo(s,t.scaleX||a.scaleX,t.scaleY||a.scaleY),!r&&t&&\"Resize\"===t.type&&(a.width*=t.scaleX,a.height*=t.scaleY)}),o.width=s.width,o.height=s.height,fabric.isLikelyNode?(o.src=s.toBuffer(void 0,fabric.Image.pngCompression),a._element=o,!r&&(a._filteredEl=o),t&&t()):(o.onload=function(){a._element=o,!r&&(a._filteredEl=o),t&&t(),o.onload=s=n=null},o.src=s.toDataURL(\"image/png\")),s)}},_render:function(t,e){var i,r,n,s=this._findMargins();i=e?this.left:-this.width/2,r=e?this.top:-this.height/2,\"slice\"===this.meetOrSlice&&(t.beginPath(),t.rect(i,r,this.width,this.height),t.clip()),this.isMoving===!1&&this.resizeFilters.length&&this._needsResize()?(this._lastScaleX=this.scaleX,this._lastScaleY=this.scaleY,n=this.applyFilters(null,this.resizeFilters,this._filteredEl||this._originalElement,!0)):n=this._element,n&&t.drawImage(n,i+s.marginX,r+s.marginY,s.width,s.height),this._stroke(t),this._renderStroke(t)},_needsResize:function(){return this.scaleX!==this._lastScaleX||this.scaleY!==this._lastScaleY},_findMargins:function(){var t,e,i=this.width,r=this.height,n=0,s=0;return\"none\"===this.alignX&&\"none\"===this.alignY||(t=[this.width/this._element.width,this.height/this._element.height],e=\"meet\"===this.meetOrSlice?Math.min.apply(null,t):Math.max.apply(null,t),i=this._element.width*e,r=this._element.height*e,\"Mid\"===this.alignX&&(n=(this.width-i)/2),\"Max\"===this.alignX&&(n=this.width-i),\"Mid\"===this.alignY&&(s=(this.height-r)/2),\"Max\"===this.alignY&&(s=this.height-r)),{width:i,height:r,marginX:n,marginY:s}},_resetWidthHeight:function(){var t=this.getElement();this.set(\"width\",t.width),this.set(\"height\",t.height)},_initElement:function(t,e){this.setElement(fabric.util.getById(t),null,e),fabric.util.addClass(this.getElement(),fabric.Image.CSS_CANVAS)},_initConfig:function(t){t||(t={}),this.setOptions(t),this._setWidthHeight(t),this._element&&this.crossOrigin&&(this._element.crossOrigin=this.crossOrigin)},_initFilters:function(t,e){t&&t.length?fabric.util.enlivenObjects(t,function(t){e&&e(t)},\"fabric.Image.filters\"):e&&e()},_setWidthHeight:function(t){this.width=\"width\"in t?t.width:this.getElement()?this.getElement().width||0:0,this.height=\"height\"in t?t.height:this.getElement()?this.getElement().height||0:0},complexity:function(){return 1}}),fabric.Image.CSS_CANVAS=\"canvas-img\",fabric.Image.prototype.getSvgSrc=fabric.Image.prototype.getSrc,fabric.Image.fromObject=function(t,e){fabric.util.loadImage(t.src,function(i){fabric.Image.prototype._initFilters.call(t,t.filters,function(r){t.filters=r||[],fabric.Image.prototype._initFilters.call(t,t.resizeFilters,function(r){t.resizeFilters=r||[];var n=new fabric.Image(i,t);e&&e(n)})})},null,t.crossOrigin)},fabric.Image.fromURL=function(t,e,i){fabric.util.loadImage(t,function(t){e&&e(new fabric.Image(t,i))},null,i&&i.crossOrigin)},fabric.Image.ATTRIBUTE_NAMES=fabric.SHARED_ATTRIBUTES.concat(\"x y width height preserveAspectRatio xlink:href\".split(\" \")),fabric.Image.fromElement=function(t,i,r){var n,s=fabric.parseAttributes(t,fabric.Image.ATTRIBUTE_NAMES);s.preserveAspectRatio&&(n=fabric.util.parsePreserveAspectRatioAttribute(s.preserveAspectRatio),e(s,n)),fabric.Image.fromURL(s[\"xlink:href\"],i,e(r?fabric.util.object.clone(r):{},s))},fabric.Image.async=!0,void(fabric.Image.pngCompression=1))}(\"undefined\"!=typeof exports?exports:this),fabric.util.object.extend(fabric.Object.prototype,{_getAngleValueForStraighten:function(){var t=this.getAngle()%360;return t>0?90*Math.round((t-1)/90):90*Math.round(t/90)},straighten:function(){return this.setAngle(this._getAngleValueForStraighten()),this},fxStraighten:function(t){t=t||{};var e=function(){},i=t.onComplete||e,r=t.onChange||e,n=this;return fabric.util.animate({startValue:this.get(\"angle\"),endValue:this._getAngleValueForStraighten(),duration:this.FX_DURATION,onChange:function(t){n.setAngle(t),r()},onComplete:function(){n.setCoords(),i()},onStart:function(){n.set(\"active\",!1)}}),this}}),fabric.util.object.extend(fabric.StaticCanvas.prototype,{straightenObject:function(t){return t.straighten(),this.renderAll(),this},fxStraightenObject:function(t){return t.fxStraighten({onChange:this.renderAll.bind(this)}),this}}),fabric.Image.filters=fabric.Image.filters||{},fabric.Image.filters.BaseFilter=fabric.util.createClass({type:\"BaseFilter\",initialize:function(t){t&&this.setOptions(t)},setOptions:function(t){for(var e in t)this[e]=t[e]},toObject:function(){return{type:this.type}},toJSON:function(){return this.toObject()}}),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend;e.Image.filters.Brightness=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Brightness\",initialize:function(t){t=t||{},this.brightness=t.brightness||0},applyTo:function(t){for(var e=t.getContext(\"2d\"),i=e.getImageData(0,0,t.width,t.height),r=i.data,n=this.brightness,s=0,o=r.length;o>s;s+=4)r[s]+=n,r[s+1]+=n,r[s+2]+=n;e.putImageData(i,0,0)},toObject:function(){return i(this.callSuper(\"toObject\"),{brightness:this.brightness})}}),e.Image.filters.Brightness.fromObject=function(t){return new e.Image.filters.Brightness(t)}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend;e.Image.filters.Convolute=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Convolute\",initialize:function(t){t=t||{},this.opaque=t.opaque,this.matrix=t.matrix||[0,0,0,0,1,0,0,0,0]},applyTo:function(t){for(var e,i,r,n,s,o,a,h,c,l=this.matrix,u=t.getContext(\"2d\"),f=u.getImageData(0,0,t.width,t.height),d=Math.round(Math.sqrt(l.length)),g=Math.floor(d/2),p=f.data,v=f.width,b=f.height,m=u.createImageData(v,b),y=m.data,_=this.opaque?1:0,x=0;b>x;x++)for(var S=0;v>S;S++){s=4*(x*v+S),e=0,i=0,r=0,n=0;for(var C=0;d>C;C++)for(var w=0;d>w;w++)a=x+C-g,o=S+w-g,0>a||a>b||0>o||o>v||(h=4*(a*v+o),c=l[C*d+w],e+=p[h]*c,i+=p[h+1]*c,r+=p[h+2]*c,n+=p[h+3]*c);y[s]=e,y[s+1]=i,y[s+2]=r,y[s+3]=n+_*(255-n)}u.putImageData(m,0,0)},toObject:function(){return i(this.callSuper(\"toObject\"),{opaque:this.opaque,matrix:this.matrix})}}),e.Image.filters.Convolute.fromObject=function(t){return new e.Image.filters.Convolute(t)}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend;e.Image.filters.GradientTransparency=e.util.createClass(e.Image.filters.BaseFilter,{type:\"GradientTransparency\",initialize:function(t){t=t||{},this.threshold=t.threshold||100},applyTo:function(t){for(var e=t.getContext(\"2d\"),i=e.getImageData(0,0,t.width,t.height),r=i.data,n=this.threshold,s=r.length,o=0,a=r.length;a>o;o+=4)r[o+3]=n+255*(s-o)/s;e.putImageData(i,0,0)},toObject:function(){return i(this.callSuper(\"toObject\"),{threshold:this.threshold})}}),e.Image.filters.GradientTransparency.fromObject=function(t){return new e.Image.filters.GradientTransparency(t)}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={});e.Image.filters.Grayscale=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Grayscale\",applyTo:function(t){for(var e,i=t.getContext(\"2d\"),r=i.getImageData(0,0,t.width,t.height),n=r.data,s=r.width*r.height*4,o=0;s>o;)e=(n[o]+n[o+1]+n[o+2])/3,n[o]=e,n[o+1]=e,n[o+2]=e,o+=4;i.putImageData(r,0,0)}}),e.Image.filters.Grayscale.fromObject=function(){return new e.Image.filters.Grayscale}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={});e.Image.filters.Invert=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Invert\",applyTo:function(t){var e,i=t.getContext(\"2d\"),r=i.getImageData(0,0,t.width,t.height),n=r.data,s=n.length;for(e=0;s>e;e+=4)n[e]=255-n[e],n[e+1]=255-n[e+1],n[e+2]=255-n[e+2];i.putImageData(r,0,0)}}),e.Image.filters.Invert.fromObject=function(){return new e.Image.filters.Invert}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend;e.Image.filters.Mask=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Mask\",initialize:function(t){t=t||{},this.mask=t.mask,this.channel=[0,1,2,3].indexOf(t.channel)>-1?t.channel:0},applyTo:function(t){if(this.mask){var i,r=t.getContext(\"2d\"),n=r.getImageData(0,0,t.width,t.height),s=n.data,o=this.mask.getElement(),a=e.util.createCanvasElement(),h=this.channel,c=n.width*n.height*4;a.width=t.width,a.height=t.height,a.getContext(\"2d\").drawImage(o,0,0,t.width,t.height);var l=a.getContext(\"2d\").getImageData(0,0,t.width,t.height),u=l.data;for(i=0;c>i;i+=4)s[i+3]=u[i+h];r.putImageData(n,0,0)}},toObject:function(){return i(this.callSuper(\"toObject\"),{mask:this.mask.toObject(),channel:this.channel})}}),e.Image.filters.Mask.fromObject=function(t,i){e.util.loadImage(t.mask.src,function(r){t.mask=new e.Image(r,t.mask),i&&i(new e.Image.filters.Mask(t))})},e.Image.filters.Mask.async=!0}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend;e.Image.filters.Noise=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Noise\",initialize:function(t){t=t||{},this.noise=t.noise||0},applyTo:function(t){for(var e,i=t.getContext(\"2d\"),r=i.getImageData(0,0,t.width,t.height),n=r.data,s=this.noise,o=0,a=n.length;a>o;o+=4)e=(.5-Math.random())*s,n[o]+=e,n[o+1]+=e,n[o+2]+=e;i.putImageData(r,0,0)},toObject:function(){return i(this.callSuper(\"toObject\"),{noise:this.noise})}}),e.Image.filters.Noise.fromObject=function(t){return new e.Image.filters.Noise(t)}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend;e.Image.filters.Pixelate=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Pixelate\",initialize:function(t){t=t||{},this.blocksize=t.blocksize||4},applyTo:function(t){var e,i,r,n,s,o,a,h=t.getContext(\"2d\"),c=h.getImageData(0,0,t.width,t.height),l=c.data,u=c.height,f=c.width;for(i=0;u>i;i+=this.blocksize)for(r=0;f>r;r+=this.blocksize){e=4*i*f+4*r,n=l[e],s=l[e+1],o=l[e+2],a=l[e+3];for(var d=i,g=i+this.blocksize;g>d;d++)for(var p=r,v=r+this.blocksize;v>p;p++)e=4*d*f+4*p,l[e]=n,l[e+1]=s,l[e+2]=o,l[e+3]=a}h.putImageData(c,0,0)},toObject:function(){return i(this.callSuper(\"toObject\"),{blocksize:this.blocksize})}}),e.Image.filters.Pixelate.fromObject=function(t){return new e.Image.filters.Pixelate(t)}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend;e.Image.filters.RemoveWhite=e.util.createClass(e.Image.filters.BaseFilter,{type:\"RemoveWhite\",initialize:function(t){t=t||{},this.threshold=t.threshold||30,this.distance=t.distance||20},applyTo:function(t){for(var e,i,r,n=t.getContext(\"2d\"),s=n.getImageData(0,0,t.width,t.height),o=s.data,a=this.threshold,h=this.distance,c=255-a,l=Math.abs,u=0,f=o.length;f>u;u+=4)e=o[u],i=o[u+1],r=o[u+2],e>c&&i>c&&r>c&&l(e-i)<h&&l(e-r)<h&&l(i-r)<h&&(o[u+3]=0);n.putImageData(s,0,0)},toObject:function(){return i(this.callSuper(\"toObject\"),{threshold:this.threshold,distance:this.distance})}}),e.Image.filters.RemoveWhite.fromObject=function(t){return new e.Image.filters.RemoveWhite(t)}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={});e.Image.filters.Sepia=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Sepia\",applyTo:function(t){var e,i,r=t.getContext(\"2d\"),n=r.getImageData(0,0,t.width,t.height),s=n.data,o=s.length;for(e=0;o>e;e+=4)i=.3*s[e]+.59*s[e+1]+.11*s[e+2],s[e]=i+100,s[e+1]=i+50,s[e+2]=i+255;r.putImageData(n,0,0)}}),e.Image.filters.Sepia.fromObject=function(){return new e.Image.filters.Sepia}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={});e.Image.filters.Sepia2=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Sepia2\",applyTo:function(t){var e,i,r,n,s=t.getContext(\"2d\"),o=s.getImageData(0,0,t.width,t.height),a=o.data,h=a.length;for(e=0;h>e;e+=4)i=a[e],r=a[e+1],n=a[e+2],a[e]=(.393*i+.769*r+.189*n)/1.351,a[e+1]=(.349*i+.686*r+.168*n)/1.203,a[e+2]=(.272*i+.534*r+.131*n)/2.14;s.putImageData(o,0,0)}}),e.Image.filters.Sepia2.fromObject=function(){return new e.Image.filters.Sepia2}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend;e.Image.filters.Tint=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Tint\",initialize:function(t){t=t||{},this.color=t.color||\"#000000\",this.opacity=\"undefined\"!=typeof t.opacity?t.opacity:new e.Color(this.color).getAlpha()},applyTo:function(t){var i,r,n,s,o,a,h,c,l,u=t.getContext(\"2d\"),f=u.getImageData(0,0,t.width,t.height),d=f.data,g=d.length;for(l=new e.Color(this.color).getSource(),r=l[0]*this.opacity,n=l[1]*this.opacity,s=l[2]*this.opacity,c=1-this.opacity,i=0;g>i;i+=4)o=d[i],a=d[i+1],h=d[i+2],d[i]=r+o*c,d[i+1]=n+a*c,d[i+2]=s+h*c;u.putImageData(f,0,0)},toObject:function(){return i(this.callSuper(\"toObject\"),{color:this.color,opacity:this.opacity})}}),e.Image.filters.Tint.fromObject=function(t){return new e.Image.filters.Tint(t)}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend;e.Image.filters.Multiply=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Multiply\",initialize:function(t){t=t||{},this.color=t.color||\"#000000\"},applyTo:function(t){var i,r,n=t.getContext(\"2d\"),s=n.getImageData(0,0,t.width,t.height),o=s.data,a=o.length;for(r=new e.Color(this.color).getSource(),i=0;a>i;i+=4)o[i]*=r[0]/255,o[i+1]*=r[1]/255,o[i+2]*=r[2]/255;n.putImageData(s,0,0)},toObject:function(){return i(this.callSuper(\"toObject\"),{color:this.color})}}),e.Image.filters.Multiply.fromObject=function(t){return new e.Image.filters.Multiply(t)}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric;e.Image.filters.Blend=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Blend\",initialize:function(t){t=t||{},this.color=t.color||\"#000\",this.image=t.image||!1,this.mode=t.mode||\"multiply\",this.alpha=t.alpha||1},applyTo:function(t){var i,r,n,s,o,a,h,c,l,u,f=t.getContext(\"2d\"),d=f.getImageData(0,0,t.width,t.height),g=d.data,p=!1;if(this.image){p=!0;var v=e.util.createCanvasElement();v.width=this.image.width,v.height=this.image.height;var b=new e.StaticCanvas(v);b.add(this.image);var m=b.getContext(\"2d\");u=m.getImageData(0,0,b.width,b.height).data}else u=new e.Color(this.color).getSource(),i=u[0]*this.alpha,r=u[1]*this.alpha,n=u[2]*this.alpha;for(var y=0,_=g.length;_>y;y+=4)switch(s=g[y],o=g[y+1],a=g[y+2],p&&(i=u[y]*this.alpha,r=u[y+1]*this.alpha,n=u[y+2]*this.alpha),this.mode){case\"multiply\":g[y]=s*i/255,g[y+1]=o*r/255,g[y+2]=a*n/255;break;case\"screen\":g[y]=1-(1-s)*(1-i),g[y+1]=1-(1-o)*(1-r),g[y+2]=1-(1-a)*(1-n);break;case\"add\":g[y]=Math.min(255,s+i),g[y+1]=Math.min(255,o+r),g[y+2]=Math.min(255,a+n);break;case\"diff\":case\"difference\":g[y]=Math.abs(s-i),g[y+1]=Math.abs(o-r),g[y+2]=Math.abs(a-n);break;case\"subtract\":h=s-i,c=o-r,l=a-n,g[y]=0>h?0:h,g[y+1]=0>c?0:c,g[y+2]=0>l?0:l;break;case\"darken\":g[y]=Math.min(s,i),g[y+1]=Math.min(o,r),g[y+2]=Math.min(a,n);break;case\"lighten\":g[y]=Math.max(s,i),g[y+1]=Math.max(o,r),g[y+2]=Math.max(a,n)}f.putImageData(d,0,0)},toObject:function(){return{color:this.color,image:this.image,mode:this.mode,alpha:this.alpha}}}),e.Image.filters.Blend.fromObject=function(t){return new e.Image.filters.Blend(t)}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=Math.pow,r=Math.floor,n=Math.sqrt,s=Math.abs,o=Math.max,a=Math.round,h=Math.sin,c=Math.ceil;e.Image.filters.Resize=e.util.createClass(e.Image.filters.BaseFilter,{type:\"Resize\",resizeType:\"hermite\",scaleX:0,scaleY:0,lanczosLobes:3,applyTo:function(t,e,i){this.rcpScaleX=1/e,this.rcpScaleY=1/i;var r,n=t.width,s=t.height,o=a(n*e),h=a(s*i);\"sliceHack\"===this.resizeType&&(r=this.sliceByTwo(t,n,s,o,h)),\"hermite\"===this.resizeType&&(r=this.hermiteFastResize(t,n,s,o,h)),\"bilinear\"===this.resizeType&&(r=this.bilinearFiltering(t,n,s,o,h)),\"lanczos\"===this.resizeType&&(r=this.lanczosResize(t,n,s,o,h)),t.width=o,t.height=h,t.getContext(\"2d\").putImageData(r,0,0)},sliceByTwo:function(t,i,n,s,a){var h,c=t.getContext(\"2d\"),l=.5,u=.5,f=1,d=1,g=!1,p=!1,v=i,b=n,m=e.util.createCanvasElement(),y=m.getContext(\"2d\");for(s=r(s),a=r(a),m.width=o(s,i),m.height=o(a,n),s>i&&(l=2,f=-1),a>n&&(u=2,d=-1),h=c.getImageData(0,0,i,n),t.width=o(s,i),t.height=o(a,n),c.putImageData(h,0,0);!g||!p;)i=v,n=b,s*f<r(v*l*f)?v=r(v*l):(v=s,g=!0),a*d<r(b*u*d)?b=r(b*u):(b=a,p=!0),h=c.getImageData(0,0,i,n),y.putImageData(h,0,0),c.clearRect(0,0,v,b),c.drawImage(m,0,0,i,n,0,0,v,b);return c.getImageData(0,0,s,a)},lanczosResize:function(t,e,o,a,l){function u(t){return function(e){if(e>t)return 0;if(e*=Math.PI,s(e)<1e-16)return 1;var i=e/t;return h(e)*h(i)/e/i}}function f(t){var h,c,u,d,g,j,A,M,P,L,D;for(T.x=(t+.5)*y,k.x=r(T.x),h=0;l>h;h++){for(T.y=(h+.5)*_,k.y=r(T.y),g=0,j=0,A=0,M=0,P=0,c=k.x-C;c<=k.x+C;c++)if(!(0>c||c>=e)){L=r(1e3*s(c-T.x)),O[L]||(O[L]={});for(var E=k.y-w;E<=k.y+w;E++)0>E||E>=o||(D=r(1e3*s(E-T.y)),O[L][D]||(O[L][D]=m(n(i(L*x,2)+i(D*S,2))/1e3)),u=O[L][D],u>0&&(d=4*(E*e+c),g+=u,j+=u*v[d],A+=u*v[d+1],M+=u*v[d+2],P+=u*v[d+3]))}d=4*(h*a+t),b[d]=j/g,b[d+1]=A/g,b[d+2]=M/g,b[d+3]=P/g}return++t<a?f(t):p}var d=t.getContext(\"2d\"),g=d.getImageData(0,0,e,o),p=d.getImageData(0,0,a,l),v=g.data,b=p.data,m=u(this.lanczosLobes),y=this.rcpScaleX,_=this.rcpScaleY,x=2/this.rcpScaleX,S=2/this.rcpScaleY,C=c(y*this.lanczosLobes/2),w=c(_*this.lanczosLobes/2),O={},T={},k={};return f(0)},bilinearFiltering:function(t,e,i,n,s){var o,a,h,c,l,u,f,d,g,p,v,b,m,y=0,_=this.rcpScaleX,x=this.rcpScaleY,S=t.getContext(\"2d\"),C=4*(e-1),w=S.getImageData(0,0,e,i),O=w.data,T=S.getImageData(0,0,n,s),k=T.data;for(f=0;s>f;f++)for(d=0;n>d;d++)for(l=r(_*d),u=r(x*f),g=_*d-l,p=x*f-u,m=4*(u*e+l),v=0;4>v;v++)o=O[m+v],a=O[m+4+v],h=O[m+C+v],c=O[m+C+4+v],b=o*(1-g)*(1-p)+a*g*(1-p)+h*p*(1-g)+c*g*p,k[y++]=b;return T},hermiteFastResize:function(t,e,i,o,a){for(var h=this.rcpScaleX,l=this.rcpScaleY,u=c(h/2),f=c(l/2),d=t.getContext(\"2d\"),g=d.getImageData(0,0,e,i),p=g.data,v=d.getImageData(0,0,o,a),b=v.data,m=0;a>m;m++)for(var y=0;o>y;y++){for(var _=4*(y+m*o),x=0,S=0,C=0,w=0,O=0,T=0,k=0,j=(m+.5)*l,A=r(m*l);(m+1)*l>A;A++)for(var M=s(j-(A+.5))/f,P=(y+.5)*h,L=M*M,D=r(y*h);(y+1)*h>D;D++){var E=s(P-(D+.5))/u,I=n(L+E*E);I>1&&-1>I||(x=2*I*I*I-3*I*I+1,x>0&&(E=4*(D+A*e),k+=x*p[E+3],C+=x,p[E+3]<255&&(x=x*p[E+3]/250),w+=x*p[E],O+=x*p[E+1],T+=x*p[E+2],S+=x))}b[_]=w/S,b[_+1]=O/S,b[_+2]=T/S,b[_+3]=k/C}return v},toObject:function(){return{type:this.type,scaleX:this.scaleX,scaleY:this.scaleY,resizeType:this.resizeType,lanczosLobes:this.lanczosLobes}}}),e.Image.filters.Resize.fromObject=function(t){return new e.Image.filters.Resize(t)}}(\"undefined\"!=typeof exports?exports:this),function(t){\"use strict\";var e=t.fabric||(t.fabric={}),i=e.util.object.extend,r=e.util.object.clone,n=e.util.toFixed,s=e.StaticCanvas.supports(\"setLineDash\"),o=e.Object.NUM_FRACTION_DIGITS;if(e.Text)return void e.warn(\"fabric.Text is already defined\");var a=e.Object.prototype.stateProperties.concat();a.push(\"fontFamily\",\"fontWeight\",\"fontSize\",\"text\",\"textDecoration\",\"textAlign\",\"fontStyle\",\"lineHeight\",\"textBackgroundColor\"),e.Text=e.util.createClass(e.Object,{_dimensionAffectingProps:{fontSize:!0,fontWeight:!0,fontFamily:!0,fontStyle:!0,lineHeight:!0,stroke:!0,strokeWidth:!0,text:!0,textAlign:!0},_reNewline:/\\r?\\n/,_reSpacesAndTabs:/[ \\t\\r]+/g,type:\"text\",fontSize:40,fontWeight:\"normal\",fontFamily:\"Times New Roman\",textDecoration:\"\",textAlign:\"left\",fontStyle:\"\",lineHeight:1.16,textBackgroundColor:\"\",stateProperties:a,stroke:null,shadow:null,_fontSizeFraction:.25,_fontSizeMult:1.13,initialize:function(t,e){e=e||{},this.text=t,this.__skipDimension=!0,this.setOptions(e),this.__skipDimension=!1,this._initDimensions()},_initDimensions:function(t){this.__skipDimension||(t||(t=e.util.createCanvasElement().getContext(\"2d\"),this._setTextStyles(t)),this._textLines=this._splitTextIntoLines(),this._clearCache(),this.width=this._getTextWidth(t),this.height=this._getTextHeight(t))},toString:function(){return\"#<fabric.Text (\"+this.complexity()+'): { \"text\": \"'+this.text+'\", \"fontFamily\": \"'+this.fontFamily+'\" }>'},_render:function(t){this.clipTo&&e.util.clipContext(this,t),this._setOpacity(t),this._setShadow(t),this._setupCompositeOperation(t),this._renderTextBackground(t),this._setStrokeStyles(t),this._setFillStyles(t),this._renderText(t),this._renderTextDecoration(t),this.clipTo&&t.restore()},_renderText:function(t){this._translateForTextAlign(t),this._renderTextFill(t),this._renderTextStroke(t),this._translateForTextAlign(t,!0)},_translateForTextAlign:function(t,e){if(\"left\"!==this.textAlign&&\"justify\"!==this.textAlign){var i=e?-1:1;t.translate(\"center\"===this.textAlign?i*this.width/2:i*this.width,0)}},_setTextStyles:function(t){t.textBaseline=\"alphabetic\",this.skipTextAlign||(t.textAlign=this.textAlign),t.font=this._getFontDeclaration()},_getTextHeight:function(){return this._textLines.length*this._getHeightOfLine()},_getTextWidth:function(t){for(var e=this._getLineWidth(t,0),i=1,r=this._textLines.length;r>i;i++){var n=this._getLineWidth(t,i);n>e&&(e=n)}return e},_renderChars:function(t,e,i,r,n){var s=t.slice(0,-4);if(this[s].toLive){var o=-this.width/2+this[s].offsetX||0,a=-this.height/2+this[s].offsetY||0;e.save(),e.translate(o,a),r-=o,n-=a}e[t](i,r,n),this[s].toLive&&e.restore()},_renderTextLine:function(t,e,i,r,n,s){n-=this.fontSize*this._fontSizeFraction;var o=this._getLineWidth(e,s);if(\"justify\"!==this.textAlign||this.width<o)return void this._renderChars(t,e,i,r,n,s);for(var a,h=i.split(/\\s+/),c=0,l=this._getWidthOfWords(e,i,s,0),u=this.width-l,f=h.length-1,d=f>0?u/f:0,g=0,p=0,v=h.length;v>p;p++){for(;\" \"===i[c]&&c<i.length;)c++;a=h[p],this._renderChars(t,e,a,r+g,n,s,c),g+=this._getWidthOfWords(e,a,s,c)+d,c+=a.length}},_getWidthOfWords:function(t,e){return t.measureText(e.replace(/\\s+/g,\"\")).width},_getLeftOffset:function(){return-this.width/2},_getTopOffset:function(){return-this.height/2},isEmptyStyles:function(){return!0},_renderTextFill:function(t){if(this.fill||!this.isEmptyStyles())for(var e=0,i=0,r=this._textLines.length;r>i;i++){var n=this._getHeightOfLine(t,i),s=n/this.lineHeight;this._renderTextLine(\"fillText\",t,this._textLines[i],this._getLeftOffset(),this._getTopOffset()+e+s,i),e+=n}},_renderTextStroke:function(t){if(this.stroke&&0!==this.strokeWidth||!this.isEmptyStyles()){var e=0;this.shadow&&!this.shadow.affectStroke&&this._removeShadow(t),t.save(),this.strokeDashArray&&(1&this.strokeDashArray.length&&this.strokeDashArray.push.apply(this.strokeDashArray,this.strokeDashArray),s&&t.setLineDash(this.strokeDashArray)),t.beginPath();for(var i=0,r=this._textLines.length;r>i;i++){var n=this._getHeightOfLine(t,i),o=n/this.lineHeight;this._renderTextLine(\"strokeText\",t,this._textLines[i],this._getLeftOffset(),this._getTopOffset()+e+o,i),e+=n}t.closePath(),t.restore()}},_getHeightOfLine:function(){return this.fontSize*this._fontSizeMult*this.lineHeight},_renderTextBackground:function(t){this._renderTextBoxBackground(t),this._renderTextLinesBackground(t)},_renderTextBoxBackground:function(t){this.backgroundColor&&(t.fillStyle=this.backgroundColor,t.fillRect(this._getLeftOffset(),this._getTopOffset(),this.width,this.height),this._removeShadow(t))},_renderTextLinesBackground:function(t){if(this.textBackgroundColor){var e,i,r,n=0;t.fillStyle=this.textBackgroundColor;for(var s=0,o=this._textLines.length;o>s;s++)e=this._getHeightOfLine(t,s),i=this._getLineWidth(t,s),i>0&&(r=this._getLineLeftOffset(i),t.fillRect(this._getLeftOffset()+r,this._getTopOffset()+n,i,e/this.lineHeight)),n+=e;this._removeShadow(t)}},_getLineLeftOffset:function(t){return\"center\"===this.textAlign?(this.width-t)/2:\"right\"===this.textAlign?this.width-t:0},_clearCache:function(){this.__lineWidths=[],this.__lineHeights=[]},_shouldClearCache:function(){var t=!1;if(this._forceClearCache)return this._forceClearCache=!1,!0;for(var e in this._dimensionAffectingProps)this[\"__\"+e]!==this[e]&&(this[\"__\"+e]=this[e],t=!0);return t},_getLineWidth:function(t,e){if(this.__lineWidths[e])return-1===this.__lineWidths[e]?this.width:this.__lineWidths[e];var i,r,n=this._textLines[e];return i=\"\"===n?0:this._measureLine(t,e),this.__lineWidths[e]=i,i&&\"justify\"===this.textAlign&&(r=n.split(/\\s+/),r.length>1&&(this.__lineWidths[e]=-1)),i},_measureLine:function(t,e){return t.measureText(this._textLines[e]).width},_renderTextDecoration:function(t){function e(e){var n,s,o,a,h,c,l,u=0;for(n=0,s=r._textLines.length;s>n;n++){for(h=r._getLineWidth(t,n),c=r._getLineLeftOffset(h),\nl=r._getHeightOfLine(t,n),o=0,a=e.length;a>o;o++)t.fillRect(r._getLeftOffset()+c,u+(r._fontSizeMult-1+e[o])*r.fontSize-i,h,r.fontSize/15);u+=l}}if(this.textDecoration){var i=this.height/2,r=this,n=[];this.textDecoration.indexOf(\"underline\")>-1&&n.push(.85),this.textDecoration.indexOf(\"line-through\")>-1&&n.push(.43),this.textDecoration.indexOf(\"overline\")>-1&&n.push(-.12),n.length>0&&e(n)}},_getFontDeclaration:function(){return[e.isLikelyNode?this.fontWeight:this.fontStyle,e.isLikelyNode?this.fontStyle:this.fontWeight,this.fontSize+\"px\",e.isLikelyNode?'\"'+this.fontFamily+'\"':this.fontFamily].join(\" \")},render:function(t,e){this.visible&&(t.save(),this._setTextStyles(t),this._shouldClearCache()&&this._initDimensions(t),this.drawSelectionBackground(t),e||this.transform(t),this.transformMatrix&&t.transform.apply(t,this.transformMatrix),this.group&&\"path-group\"===this.group.type&&t.translate(this.left,this.top),this._render(t),t.restore())},_splitTextIntoLines:function(){return this.text.split(this._reNewline)},toObject:function(t){var e=i(this.callSuper(\"toObject\",t),{text:this.text,fontSize:this.fontSize,fontWeight:this.fontWeight,fontFamily:this.fontFamily,fontStyle:this.fontStyle,lineHeight:this.lineHeight,textDecoration:this.textDecoration,textAlign:this.textAlign,textBackgroundColor:this.textBackgroundColor});return this.includeDefaultValues||this._removeDefaultValues(e),e},toSVG:function(t){var e=this._createBaseSVGMarkup(),i=this._getSVGLeftTopOffsets(this.ctx),r=this._getSVGTextAndBg(i.textTop,i.textLeft);return this._wrapSVGTextAndBg(e,r),t?t(e.join(\"\")):e.join(\"\")},_getSVGLeftTopOffsets:function(t){var e=this._getHeightOfLine(t,0),i=-this.width/2,r=0;return{textLeft:i+(this.group&&\"path-group\"===this.group.type?this.left:0),textTop:r+(this.group&&\"path-group\"===this.group.type?-this.top:0),lineTop:e}},_wrapSVGTextAndBg:function(t,e){var i=!0,r=this.getSvgFilter(),n=\"\"===r?\"\":' style=\"'+r+'\"';t.push('\t<g transform=\"',this.getSvgTransform(),this.getSvgTransformMatrix(),'\"',n,\">\\n\",e.textBgRects.join(\"\"),\"\t\t<text \",this.fontFamily?'font-family=\"'+this.fontFamily.replace(/\"/g,\"'\")+'\" ':\"\",this.fontSize?'font-size=\"'+this.fontSize+'\" ':\"\",this.fontStyle?'font-style=\"'+this.fontStyle+'\" ':\"\",this.fontWeight?'font-weight=\"'+this.fontWeight+'\" ':\"\",this.textDecoration?'text-decoration=\"'+this.textDecoration+'\" ':\"\",'style=\"',this.getSvgStyles(i),'\" >\\n',e.textSpans.join(\"\"),\"\t\t</text>\\n\",\"\t</g>\\n\")},_getSVGTextAndBg:function(t,e){var i=[],r=[],n=0;this._setSVGBg(r);for(var s=0,o=this._textLines.length;o>s;s++)this.textBackgroundColor&&this._setSVGTextLineBg(r,s,e,t,n),this._setSVGTextLineText(s,i,n,e,t,r),n+=this._getHeightOfLine(this.ctx,s);return{textSpans:i,textBgRects:r}},_setSVGTextLineText:function(t,i,r,s,a){var h=this.fontSize*(this._fontSizeMult-this._fontSizeFraction)-a+r-this.height/2;return\"justify\"===this.textAlign?void this._setSVGTextLineJustifed(t,i,h,s):void i.push('\t\t\t<tspan x=\"',n(s+this._getLineLeftOffset(this._getLineWidth(this.ctx,t)),o),'\" ','y=\"',n(h,o),'\" ',this._getFillAttributes(this.fill),\">\",e.util.string.escapeXml(this._textLines[t]),\"</tspan>\\n\")},_setSVGTextLineJustifed:function(t,i,r,s){var a=e.util.createCanvasElement().getContext(\"2d\");this._setTextStyles(a);var h,c,l=this._textLines[t],u=l.split(/\\s+/),f=this._getWidthOfWords(a,l),d=this.width-f,g=u.length-1,p=g>0?d/g:0,v=this._getFillAttributes(this.fill);for(s+=this._getLineLeftOffset(this._getLineWidth(a,t)),t=0,c=u.length;c>t;t++)h=u[t],i.push('\t\t\t<tspan x=\"',n(s,o),'\" ','y=\"',n(r,o),'\" ',v,\">\",e.util.string.escapeXml(h),\"</tspan>\\n\"),s+=this._getWidthOfWords(a,h)+p},_setSVGTextLineBg:function(t,e,i,r,s){t.push(\"\t\t<rect \",this._getFillAttributes(this.textBackgroundColor),' x=\"',n(i+this._getLineLeftOffset(this._getLineWidth(this.ctx,e)),o),'\" y=\"',n(s-this.height/2,o),'\" width=\"',n(this._getLineWidth(this.ctx,e),o),'\" height=\"',n(this._getHeightOfLine(this.ctx,e)/this.lineHeight,o),'\"></rect>\\n')},_setSVGBg:function(t){this.backgroundColor&&t.push(\"\t\t<rect \",this._getFillAttributes(this.backgroundColor),' x=\"',n(-this.width/2,o),'\" y=\"',n(-this.height/2,o),'\" width=\"',n(this.width,o),'\" height=\"',n(this.height,o),'\"></rect>\\n')},_getFillAttributes:function(t){var i=t&&\"string\"==typeof t?new e.Color(t):\"\";return i&&i.getSource()&&1!==i.getAlpha()?'opacity=\"'+i.getAlpha()+'\" fill=\"'+i.setAlpha(1).toRgb()+'\"':'fill=\"'+t+'\"'},_set:function(t,e){this.callSuper(\"_set\",t,e),t in this._dimensionAffectingProps&&(this._initDimensions(),this.setCoords())},complexity:function(){return 1}}),e.Text.ATTRIBUTE_NAMES=e.SHARED_ATTRIBUTES.concat(\"x y dx dy font-family font-style font-weight font-size text-decoration text-anchor\".split(\" \")),e.Text.DEFAULT_SVG_FONT_SIZE=16,e.Text.fromElement=function(t,i){if(!t)return null;var r=e.parseAttributes(t,e.Text.ATTRIBUTE_NAMES);i=e.util.object.extend(i?e.util.object.clone(i):{},r),i.top=i.top||0,i.left=i.left||0,\"dx\"in r&&(i.left+=r.dx),\"dy\"in r&&(i.top+=r.dy),\"fontSize\"in i||(i.fontSize=e.Text.DEFAULT_SVG_FONT_SIZE),i.originX||(i.originX=\"left\");var n=\"\";\"textContent\"in t?n=t.textContent:\"firstChild\"in t&&null!==t.firstChild&&\"data\"in t.firstChild&&null!==t.firstChild.data&&(n=t.firstChild.data),n=n.replace(/^\\s+|\\s+$|\\n+/g,\"\").replace(/\\s+/g,\" \");var s=new e.Text(n,i),o=0;return\"left\"===s.originX&&(o=s.getWidth()/2),\"right\"===s.originX&&(o=-s.getWidth()/2),s.set({left:s.getLeft()+o,top:s.getTop()-s.getHeight()/2+s.fontSize*(.18+s._fontSizeFraction)}),s},e.Text.fromObject=function(t){return new e.Text(t.text,r(t))},e.util.createAccessors(e.Text)}(\"undefined\"!=typeof exports?exports:this),function(){var t=fabric.util.object.clone;fabric.IText=fabric.util.createClass(fabric.Text,fabric.Observable,{type:\"i-text\",selectionStart:0,selectionEnd:0,selectionColor:\"rgba(17,119,255,0.3)\",isEditing:!1,editable:!0,editingBorderColor:\"rgba(102,153,255,0.25)\",cursorWidth:2,cursorColor:\"#333\",cursorDelay:1e3,cursorDuration:600,styles:null,caching:!0,_reSpace:/\\s|\\n/,_currentCursorOpacity:0,_selectionDirection:null,_abortCursorAnimation:!1,_charWidthsCache:{},__widthOfSpace:[],initialize:function(t,e){this.styles=e?e.styles||{}:{},this.callSuper(\"initialize\",t,e),this.initBehavior()},_clearCache:function(){this.callSuper(\"_clearCache\"),this.__widthOfSpace=[]},isEmptyStyles:function(){if(!this.styles)return!0;var t=this.styles;for(var e in t)for(var i in t[e])for(var r in t[e][i])return!1;return!0},setSelectionStart:function(t){t=Math.max(t,0),this.selectionStart!==t&&(this.fire(\"selection:changed\"),this.canvas&&this.canvas.fire(\"text:selection:changed\",{target:this}),this.selectionStart=t),this._updateTextarea()},setSelectionEnd:function(t){t=Math.min(t,this.text.length),this.selectionEnd!==t&&(this.fire(\"selection:changed\"),this.canvas&&this.canvas.fire(\"text:selection:changed\",{target:this}),this.selectionEnd=t),this._updateTextarea()},getSelectionStyles:function(t,e){if(2===arguments.length){for(var i=[],r=t;e>r;r++)i.push(this.getSelectionStyles(r));return i}var n=this.get2DCursorLocation(t),s=this._getStyleDeclaration(n.lineIndex,n.charIndex);return s||{}},setSelectionStyles:function(t){if(this.selectionStart===this.selectionEnd)this._extendStyles(this.selectionStart,t);else for(var e=this.selectionStart;e<this.selectionEnd;e++)this._extendStyles(e,t);return this._forceClearCache=!0,this},_extendStyles:function(t,e){var i=this.get2DCursorLocation(t);this._getLineStyle(i.lineIndex)||this._setLineStyle(i.lineIndex,{}),this._getStyleDeclaration(i.lineIndex,i.charIndex)||this._setStyleDeclaration(i.lineIndex,i.charIndex,{}),fabric.util.object.extend(this._getStyleDeclaration(i.lineIndex,i.charIndex),e)},_render:function(t){this.callSuper(\"_render\",t),this.ctx=t,this.isEditing&&this.renderCursorOrSelection()},renderCursorOrSelection:function(){if(this.active){var t,e,i=this.text.split(\"\");this.canvas.contextTop?(e=this.canvas.contextTop,e.save(),e.transform.apply(e,this.canvas.viewportTransform),this.transform(e),this.transformMatrix&&e.transform.apply(e,this.transformMatrix)):(e=this.ctx,e.save()),this.selectionStart===this.selectionEnd?(t=this._getCursorBoundaries(i,\"cursor\"),this.renderCursor(t,e)):(t=this._getCursorBoundaries(i,\"selection\"),this.renderSelection(i,t,e)),e.restore()}},get2DCursorLocation:function(t){\"undefined\"==typeof t&&(t=this.selectionStart);for(var e=this._textLines.length,i=0;e>i;i++){if(t<=this._textLines[i].length)return{lineIndex:i,charIndex:t};t-=this._textLines[i].length+1}return{lineIndex:i-1,charIndex:this._textLines[i-1].length<t?this._textLines[i-1].length:t}},getCurrentCharStyle:function(t,e){var i=this._getStyleDeclaration(t,0===e?0:e-1);return{fontSize:i&&i.fontSize||this.fontSize,fill:i&&i.fill||this.fill,textBackgroundColor:i&&i.textBackgroundColor||this.textBackgroundColor,textDecoration:i&&i.textDecoration||this.textDecoration,fontFamily:i&&i.fontFamily||this.fontFamily,fontWeight:i&&i.fontWeight||this.fontWeight,fontStyle:i&&i.fontStyle||this.fontStyle,stroke:i&&i.stroke||this.stroke,strokeWidth:i&&i.strokeWidth||this.strokeWidth}},getCurrentCharFontSize:function(t,e){var i=this._getStyleDeclaration(t,0===e?0:e-1);return i&&i.fontSize?i.fontSize:this.fontSize},getCurrentCharColor:function(t,e){var i=this._getStyleDeclaration(t,0===e?0:e-1);return i&&i.fill?i.fill:this.cursorColor},_getCursorBoundaries:function(t,e){var i=Math.round(this._getLeftOffset()),r=this._getTopOffset(),n=this._getCursorBoundariesOffsets(t,e);return{left:i,top:r,leftOffset:n.left+n.lineLeft,topOffset:n.top}},_getCursorBoundariesOffsets:function(t,e){for(var i=0,r=0,n=0,s=0,o=0,a=0;a<this.selectionStart;a++)\"\\n\"===t[a]?(o=0,s+=this._getHeightOfLine(this.ctx,r),r++,n=0):(o+=this._getWidthOfChar(this.ctx,t[a],r,n),n++),i=this._getLineLeftOffset(this._getLineWidth(this.ctx,r));return\"cursor\"===e&&(s+=(1-this._fontSizeFraction)*this._getHeightOfLine(this.ctx,r)/this.lineHeight-this.getCurrentCharFontSize(r,n)*(1-this._fontSizeFraction)),{top:s,left:o,lineLeft:i}},renderCursor:function(t,e){var i=this.get2DCursorLocation(),r=i.lineIndex,n=i.charIndex,s=this.getCurrentCharFontSize(r,n),o=0===r&&0===n?this._getLineLeftOffset(this._getLineWidth(e,r)):t.leftOffset;e.fillStyle=this.getCurrentCharColor(r,n),e.globalAlpha=this.__isMousedown?1:this._currentCursorOpacity,e.fillRect(t.left+o,t.top+t.topOffset,this.cursorWidth/this.scaleX,s)},renderSelection:function(t,e,i){i.fillStyle=this.selectionColor;for(var r=this.get2DCursorLocation(this.selectionStart),n=this.get2DCursorLocation(this.selectionEnd),s=r.lineIndex,o=n.lineIndex,a=s;o>=a;a++){var h=this._getLineLeftOffset(this._getLineWidth(i,a))||0,c=this._getHeightOfLine(this.ctx,a),l=0,u=this._textLines[a];if(a===s)for(var f=0,d=u.length;d>f;f++)f>=r.charIndex&&(a!==o||f<n.charIndex)&&(l+=this._getWidthOfChar(i,u[f],a,f)),f<r.charIndex&&(h+=this._getWidthOfChar(i,u[f],a,f));else if(a>s&&o>a)l+=this._getLineWidth(i,a)||5;else if(a===o)for(var g=0,p=n.charIndex;p>g;g++)l+=this._getWidthOfChar(i,u[g],a,g);i.fillRect(e.left+h,e.top+e.topOffset,l,c),e.topOffset+=c}},_renderChars:function(t,e,i,r,n,s,o){if(this.isEmptyStyles())return this._renderCharsFast(t,e,i,r,n);o=o||0,this.skipTextAlign=!0,r-=\"center\"===this.textAlign?this.width/2:\"right\"===this.textAlign?this.width:0;var a,h,c=this._getHeightOfLine(e,s),l=this._getLineLeftOffset(this._getLineWidth(e,s)),u=\"\";r+=l||0,e.save(),n-=c/this.lineHeight*this._fontSizeFraction;for(var f=o,d=i.length+o;d>=f;f++)a=a||this.getCurrentCharStyle(s,f),h=this.getCurrentCharStyle(s,f+1),(this._hasStyleChanged(a,h)||f===d)&&(this._renderChar(t,e,s,f-1,u,r,n,c),u=\"\",a=h),u+=i[f-o];e.restore()},_renderCharsFast:function(t,e,i,r,n){this.skipTextAlign=!1,\"fillText\"===t&&this.fill&&this.callSuper(\"_renderChars\",t,e,i,r,n),\"strokeText\"===t&&(this.stroke&&this.strokeWidth>0||this.skipFillStrokeCheck)&&this.callSuper(\"_renderChars\",t,e,i,r,n)},_renderChar:function(t,e,i,r,n,s,o,a){var h,c,l,u,f,d,g=this._getStyleDeclaration(i,r);g?(c=this._getHeightOfChar(e,n,i,r),u=g.stroke,l=g.fill,d=g.textDecoration):c=this.fontSize,u=(u||this.stroke)&&\"strokeText\"===t,l=(l||this.fill)&&\"fillText\"===t,g&&e.save(),h=this._applyCharStylesGetWidth(e,n,i,r,g||{}),d=d||this.textDecoration,g&&g.textBackgroundColor&&this._removeShadow(e),l&&e.fillText(n,s,o),u&&e.strokeText(n,s,o),(d||\"\"!==d)&&(f=this._fontSizeFraction*a/this.lineHeight,this._renderCharDecoration(e,d,s,o,f,h,c)),g&&e.restore(),e.translate(h,0)},_hasStyleChanged:function(t,e){return t.fill!==e.fill||t.fontSize!==e.fontSize||t.textBackgroundColor!==e.textBackgroundColor||t.textDecoration!==e.textDecoration||t.fontFamily!==e.fontFamily||t.fontWeight!==e.fontWeight||t.fontStyle!==e.fontStyle||t.stroke!==e.stroke||t.strokeWidth!==e.strokeWidth},_renderCharDecoration:function(t,e,i,r,n,s,o){if(e){var a,h,c=o/15,l={underline:r+o/10,\"line-through\":r-o*(this._fontSizeFraction+this._fontSizeMult-1)+c,overline:r-(this._fontSizeMult-this._fontSizeFraction)*o},u=[\"underline\",\"line-through\",\"overline\"];for(a=0;a<u.length;a++)h=u[a],e.indexOf(h)>-1&&t.fillRect(i,l[h],s,c)}},_renderTextLine:function(t,e,i,r,n,s){this.isEmptyStyles()||(n+=this.fontSize*(this._fontSizeFraction+.03)),this.callSuper(\"_renderTextLine\",t,e,i,r,n,s)},_renderTextDecoration:function(t){return this.isEmptyStyles()?this.callSuper(\"_renderTextDecoration\",t):void 0},_renderTextLinesBackground:function(t){this.callSuper(\"_renderTextLinesBackground\",t);for(var e,i,r,n,s,o,a=0,h=this._getLeftOffset(),c=this._getTopOffset(),l=0,u=this._textLines.length;u>l;l++)if(e=this._getHeightOfLine(t,l),n=this._textLines[l],\"\"!==n&&this.styles&&this._getLineStyle(l)){i=this._getLineWidth(t,l),r=this._getLineLeftOffset(i);for(var f=0,d=n.length;d>f;f++)o=this._getStyleDeclaration(l,f),o&&o.textBackgroundColor&&(s=n[f],t.fillStyle=o.textBackgroundColor,t.fillRect(h+r+this._getWidthOfCharsAt(t,l,f),c+a,this._getWidthOfChar(t,s,l,f)+1,e/this.lineHeight));a+=e}else a+=e},_getCacheProp:function(t,e){return t+e.fontFamily+e.fontSize+e.fontWeight+e.fontStyle+e.shadow},_applyCharStylesGetWidth:function(e,i,r,n,s){var o,a=this._getStyleDeclaration(r,n),h=s&&t(s)||t(a);this._applyFontStyles(h);var c=this._getCacheProp(i,h);if(!a&&this._charWidthsCache[c]&&this.caching)return this._charWidthsCache[c];\"string\"==typeof h.shadow&&(h.shadow=new fabric.Shadow(h.shadow));var l=h.fill||this.fill;return e.fillStyle=l.toLive?l.toLive(e,this):l,h.stroke&&(e.strokeStyle=h.stroke&&h.stroke.toLive?h.stroke.toLive(e,this):h.stroke),e.lineWidth=h.strokeWidth||this.strokeWidth,e.font=this._getFontDeclaration.call(h),h.shadow&&(h.scaleX=this.scaleX,h.scaleY=this.scaleY,h.canvas=this.canvas,this._setShadow.call(h,e)),this.caching&&this._charWidthsCache[c]?this._charWidthsCache[c]:(o=e.measureText(i).width,this.caching&&(this._charWidthsCache[c]=o),o)},_applyFontStyles:function(t){t.fontFamily||(t.fontFamily=this.fontFamily),t.fontSize||(t.fontSize=this.fontSize),t.fontWeight||(t.fontWeight=this.fontWeight),t.fontStyle||(t.fontStyle=this.fontStyle)},_getStyleDeclaration:function(e,i,r){return r?this.styles[e]&&this.styles[e][i]?t(this.styles[e][i]):{}:this.styles[e]&&this.styles[e][i]?this.styles[e][i]:null},_setStyleDeclaration:function(t,e,i){this.styles[t][e]=i},_deleteStyleDeclaration:function(t,e){delete this.styles[t][e]},_getLineStyle:function(t){return this.styles[t]},_setLineStyle:function(t,e){this.styles[t]=e},_deleteLineStyle:function(t){delete this.styles[t]},_getWidthOfChar:function(t,e,i,r){if(!this._isMeasuring&&\"justify\"===this.textAlign&&this._reSpacesAndTabs.test(e))return this._getWidthOfSpace(t,i);var n=this._getStyleDeclaration(i,r,!0);this._applyFontStyles(n);var s=this._getCacheProp(e,n);if(this._charWidthsCache[s]&&this.caching)return this._charWidthsCache[s];if(t){t.save();var o=this._applyCharStylesGetWidth(t,e,i,r);return t.restore(),o}},_getHeightOfChar:function(t,e,i){var r=this._getStyleDeclaration(e,i);return r&&r.fontSize?r.fontSize:this.fontSize},_getWidthOfCharsAt:function(t,e,i){var r,n,s=0;for(r=0;i>r;r++)n=this._textLines[e][r],s+=this._getWidthOfChar(t,n,e,r);return s},_measureLine:function(t,e){this._isMeasuring=!0;var i=this._getWidthOfCharsAt(t,e,this._textLines[e].length);return this._isMeasuring=!1,i},_getWidthOfSpace:function(t,e){if(this.__widthOfSpace[e])return this.__widthOfSpace[e];var i=this._textLines[e],r=this._getWidthOfWords(t,i,e,0),n=this.width-r,s=i.length-i.replace(this._reSpacesAndTabs,\"\").length,o=Math.max(n/s,t.measureText(\" \").width);return this.__widthOfSpace[e]=o,o},_getWidthOfWords:function(t,e,i,r){for(var n=0,s=0;s<e.length;s++){var o=e[s];o.match(/\\s/)||(n+=this._getWidthOfChar(t,o,i,s+r))}return n},_getHeightOfLine:function(t,e){if(this.__lineHeights[e])return this.__lineHeights[e];for(var i=this._textLines[e],r=this._getHeightOfChar(t,e,0),n=1,s=i.length;s>n;n++){var o=this._getHeightOfChar(t,e,n);o>r&&(r=o)}return this.__lineHeights[e]=r*this.lineHeight*this._fontSizeMult,this.__lineHeights[e]},_getTextHeight:function(t){for(var e=0,i=0,r=this._textLines.length;r>i;i++)e+=this._getHeightOfLine(t,i);return e},toObject:function(e){var i,r,n,s={};for(i in this.styles){n=this.styles[i],s[i]={};for(r in n)s[i][r]=t(n[r])}return fabric.util.object.extend(this.callSuper(\"toObject\",e),{styles:s})}}),fabric.IText.fromObject=function(e){return new fabric.IText(e.text,t(e))}}(),function(){var t=fabric.util.object.clone;fabric.util.object.extend(fabric.IText.prototype,{initBehavior:function(){this.initAddedHandler(),this.initRemovedHandler(),this.initCursorSelectionHandlers(),this.initDoubleClickSimulation()},initSelectedHandler:function(){this.on(\"selected\",function(){var t=this;setTimeout(function(){t.selected=!0},100)})},initAddedHandler:function(){var t=this;this.on(\"added\",function(){this.canvas&&!this.canvas._hasITextHandlers&&(this.canvas._hasITextHandlers=!0,this._initCanvasHandlers()),t.canvas&&(t.canvas._iTextInstances=t.canvas._iTextInstances||[],t.canvas._iTextInstances.push(t))})},initRemovedHandler:function(){var t=this;this.on(\"removed\",function(){t.canvas&&(t.canvas._iTextInstances=t.canvas._iTextInstances||[],fabric.util.removeFromArray(t.canvas._iTextInstances,t))})},_initCanvasHandlers:function(){var t=this;this.canvas.on(\"selection:cleared\",function(){fabric.IText.prototype.exitEditingOnOthers(t.canvas)}),this.canvas.on(\"mouse:up\",function(){t.canvas._iTextInstances&&t.canvas._iTextInstances.forEach(function(t){t.__isMousedown=!1})}),this.canvas.on(\"object:selected\",function(){fabric.IText.prototype.exitEditingOnOthers(t.canvas)})},_tick:function(){this._currentTickState=this._animateCursor(this,1,this.cursorDuration,\"_onTickComplete\")},_animateCursor:function(t,e,i,r){var n;return n={isAborted:!1,abort:function(){this.isAborted=!0}},t.animate(\"_currentCursorOpacity\",e,{duration:i,onComplete:function(){n.isAborted||t[r]()},onChange:function(){t.canvas&&(t.canvas.clearContext(t.canvas.contextTop||t.ctx),t.renderCursorOrSelection())},abort:function(){return n.isAborted}}),n},_onTickComplete:function(){var t=this;this._cursorTimeout1&&clearTimeout(this._cursorTimeout1),this._cursorTimeout1=setTimeout(function(){t._currentTickCompleteState=t._animateCursor(t,0,this.cursorDuration/2,\"_tick\")},100)},initDelayedCursor:function(t){var e=this,i=t?0:this.cursorDelay;this._currentTickState&&this._currentTickState.abort(),this._currentTickCompleteState&&this._currentTickCompleteState.abort(),clearTimeout(this._cursorTimeout1),this._currentCursorOpacity=1,this.canvas&&(this.canvas.clearContext(this.canvas.contextTop||this.ctx),this.renderCursorOrSelection()),this._cursorTimeout2&&clearTimeout(this._cursorTimeout2),this._cursorTimeout2=setTimeout(function(){e._tick()},i)},abortCursorAnimation:function(){this._currentTickState&&this._currentTickState.abort(),this._currentTickCompleteState&&this._currentTickCompleteState.abort(),clearTimeout(this._cursorTimeout1),clearTimeout(this._cursorTimeout2),this._currentCursorOpacity=0,this.canvas&&this.canvas.clearContext(this.canvas.contextTop||this.ctx)},selectAll:function(){this.setSelectionStart(0),this.setSelectionEnd(this.text.length)},getSelectedText:function(){return this.text.slice(this.selectionStart,this.selectionEnd)},findWordBoundaryLeft:function(t){var e=0,i=t-1;if(this._reSpace.test(this.text.charAt(i)))for(;this._reSpace.test(this.text.charAt(i));)e++,i--;for(;/\\S/.test(this.text.charAt(i))&&i>-1;)e++,i--;return t-e},findWordBoundaryRight:function(t){var e=0,i=t;if(this._reSpace.test(this.text.charAt(i)))for(;this._reSpace.test(this.text.charAt(i));)e++,i++;for(;/\\S/.test(this.text.charAt(i))&&i<this.text.length;)e++,i++;return t+e},findLineBoundaryLeft:function(t){for(var e=0,i=t-1;!/\\n/.test(this.text.charAt(i))&&i>-1;)e++,i--;return t-e},findLineBoundaryRight:function(t){for(var e=0,i=t;!/\\n/.test(this.text.charAt(i))&&i<this.text.length;)e++,i++;return t+e},getNumNewLinesInSelectedText:function(){for(var t=this.getSelectedText(),e=0,i=0,r=t.length;r>i;i++)\"\\n\"===t[i]&&e++;return e},searchWordBoundary:function(t,e){for(var i=this._reSpace.test(this.text.charAt(t))?t-1:t,r=this.text.charAt(i),n=/[ \\n\\.,;!\\?\\-]/;!n.test(r)&&i>0&&i<this.text.length;)i+=e,r=this.text.charAt(i);return n.test(r)&&\"\\n\"!==r&&(i+=1===e?0:1),i},selectWord:function(t){var e=this.searchWordBoundary(t,-1),i=this.searchWordBoundary(t,1);this.setSelectionStart(e),this.setSelectionEnd(i)},selectLine:function(t){var e=this.findLineBoundaryLeft(t),i=this.findLineBoundaryRight(t);this.setSelectionStart(e),this.setSelectionEnd(i)},enterEditing:function(t){return!this.isEditing&&this.editable?(this.canvas&&this.exitEditingOnOthers(this.canvas),this.isEditing=!0,this.initHiddenTextarea(t),this.hiddenTextarea.focus(),this._updateTextarea(),this._saveEditingProps(),this._setEditingProps(),this._textBeforeEdit=this.text,this._tick(),this.fire(\"editing:entered\"),this.canvas?(this.canvas.renderAll(),this.canvas.fire(\"text:editing:entered\",{target:this}),this.initMouseMoveHandler(),this):this):void 0},exitEditingOnOthers:function(t){t._iTextInstances&&t._iTextInstances.forEach(function(t){t.selected=!1,t.isEditing&&t.exitEditing()})},initMouseMoveHandler:function(){var t=this;this.canvas.on(\"mouse:move\",function(e){if(t.__isMousedown&&t.isEditing){var i=t.getSelectionStartFromPointer(e.e);i>=t.__selectionStartOnMouseDown?(t.setSelectionStart(t.__selectionStartOnMouseDown),t.setSelectionEnd(i)):(t.setSelectionStart(i),t.setSelectionEnd(t.__selectionStartOnMouseDown))}})},_setEditingProps:function(){this.hoverCursor=\"text\",this.canvas&&(this.canvas.defaultCursor=this.canvas.moveCursor=\"text\"),this.borderColor=this.editingBorderColor,this.hasControls=this.selectable=!1,this.lockMovementX=this.lockMovementY=!0},_updateTextarea:function(){if(this.hiddenTextarea&&!this.inCompositionMode&&(this.hiddenTextarea.value=this.text,this.hiddenTextarea.selectionStart=this.selectionStart,this.hiddenTextarea.selectionEnd=this.selectionEnd,this.selectionStart===this.selectionEnd)){var t=this._calcTextareaPosition();this.hiddenTextarea.style.left=t.x+\"px\",this.hiddenTextarea.style.top=t.y+\"px\"}},_calcTextareaPosition:function(){var t=this.text.split(\"\"),e=this._getCursorBoundaries(t,\"cursor\"),i=this.get2DCursorLocation(),r=i.lineIndex,n=i.charIndex,s=this.getCurrentCharFontSize(r,n),o=0===r&&0===n?this._getLineLeftOffset(this._getLineWidth(this.ctx,r)):e.leftOffset,a=this.calcTransformMatrix(),h={x:e.left+o,y:e.top+e.topOffset+s};return this.hiddenTextarea.style.fontSize=s+\"px\",fabric.util.transformPoint(h,a)},_saveEditingProps:function(){this._savedProps={hasControls:this.hasControls,borderColor:this.borderColor,lockMovementX:this.lockMovementX,lockMovementY:this.lockMovementY,hoverCursor:this.hoverCursor,defaultCursor:this.canvas&&this.canvas.defaultCursor,moveCursor:this.canvas&&this.canvas.moveCursor}},_restoreEditingProps:function(){this._savedProps&&(this.hoverCursor=this._savedProps.overCursor,this.hasControls=this._savedProps.hasControls,this.borderColor=this._savedProps.borderColor,this.lockMovementX=this._savedProps.lockMovementX,this.lockMovementY=this._savedProps.lockMovementY,this.canvas&&(this.canvas.defaultCursor=this._savedProps.defaultCursor,this.canvas.moveCursor=this._savedProps.moveCursor))},exitEditing:function(){var t=this._textBeforeEdit!==this.text;return this.selected=!1,this.isEditing=!1,this.selectable=!0,this.selectionEnd=this.selectionStart,this.hiddenTextarea&&this.canvas&&this.hiddenTextarea.parentNode.removeChild(this.hiddenTextarea),this.hiddenTextarea=null,this.abortCursorAnimation(),this._restoreEditingProps(),this._currentCursorOpacity=0,this.fire(\"editing:exited\"),t&&this.fire(\"modified\"),this.canvas&&(this.canvas.fire(\"text:editing:exited\",{target:this}),t&&this.canvas.fire(\"object:modified\",{target:this})),this},_removeExtraneousStyles:function(){for(var t in this.styles)this._textLines[t]||delete this.styles[t]},_removeCharsFromTo:function(t,e){for(;e!==t;)this._removeSingleCharAndStyle(t+1),e--;this.setSelectionStart(t)},_removeSingleCharAndStyle:function(t){var e=\"\\n\"===this.text[t-1],i=e?t:t-1;this.removeStyleObject(e,i),this.text=this.text.slice(0,t-1)+this.text.slice(t),this._textLines=this._splitTextIntoLines()},insertChars:function(t,e){var i;if(this.selectionEnd-this.selectionStart>1&&(this._removeCharsFromTo(this.selectionStart,this.selectionEnd),this.setSelectionEnd(this.selectionStart)),!e&&this.isEmptyStyles())return void this.insertChar(t,!1);for(var r=0,n=t.length;n>r;r++)e&&(i=fabric.copiedTextStyle[r]),this.insertChar(t[r],n-1>r,i)},insertChar:function(t,e,i){var r=\"\\n\"===this.text[this.selectionStart];this.text=this.text.slice(0,this.selectionStart)+t+this.text.slice(this.selectionEnd),this._textLines=this._splitTextIntoLines(),this.insertStyleObjects(t,r,i),this.selectionStart+=t.length,this.selectionEnd=this.selectionStart,e||(this._updateTextarea(),this.canvas&&this.canvas.renderAll(),this.setCoords(),this.fire(\"changed\"),this.canvas&&this.canvas.fire(\"text:changed\",{target:this}))},insertNewlineStyleObject:function(e,i,r){this.shiftLineStyles(e,1),this.styles[e+1]||(this.styles[e+1]={});var n={},s={};if(this.styles[e]&&this.styles[e][i-1]&&(n=this.styles[e][i-1]),r)s[0]=t(n),this.styles[e+1]=s;else{for(var o in this.styles[e])parseInt(o,10)>=i&&(s[parseInt(o,10)-i]=this.styles[e][o],delete this.styles[e][o]);this.styles[e+1]=s}this._forceClearCache=!0},insertCharStyleObject:function(e,i,r){var n=this.styles[e],s=t(n);0!==i||r||(i=1);for(var o in s){var a=parseInt(o,10);a>=i&&(n[a+1]=s[a],s[a-1]||delete n[a])}this.styles[e][i]=r||t(n[i-1]),this._forceClearCache=!0},insertStyleObjects:function(t,e,i){var r=this.get2DCursorLocation(),n=r.lineIndex,s=r.charIndex;this._getLineStyle(n)||this._setLineStyle(n,{}),\"\\n\"===t?this.insertNewlineStyleObject(n,s,e):this.insertCharStyleObject(n,s,i)},shiftLineStyles:function(e,i){var r=t(this.styles);for(var n in this.styles){var s=parseInt(n,10);s>e&&(this.styles[s+i]=r[s],r[s-i]||delete this.styles[s])}},removeStyleObject:function(t,e){var i=this.get2DCursorLocation(e),r=i.lineIndex,n=i.charIndex;this._removeStyleObject(t,i,r,n)},_getTextOnPreviousLine:function(t){return this._textLines[t-1]},_removeStyleObject:function(e,i,r,n){if(e){var s=this._getTextOnPreviousLine(i.lineIndex),o=s?s.length:0;this.styles[r-1]||(this.styles[r-1]={});for(n in this.styles[r])this.styles[r-1][parseInt(n,10)+o]=this.styles[r][n];this.shiftLineStyles(i.lineIndex,-1)}else{var a=this.styles[r];a&&delete a[n];var h=t(a);for(var c in h){var l=parseInt(c,10);l>=n&&0!==l&&(a[l-1]=h[l],delete a[l])}}},insertNewline:function(){this.insertChars(\"\\n\")}})}(),fabric.util.object.extend(fabric.IText.prototype,{initDoubleClickSimulation:function(){this.__lastClickTime=+new Date,this.__lastLastClickTime=+new Date,this.__lastPointer={},this.on(\"mousedown\",this.onMouseDown.bind(this))},onMouseDown:function(t){this.__newClickTime=+new Date;var e=this.canvas.getPointer(t.e);this.isTripleClick(e)?(this.fire(\"tripleclick\",t),this._stopEvent(t.e)):this.isDoubleClick(e)&&(this.fire(\"dblclick\",t),this._stopEvent(t.e)),this.__lastLastClickTime=this.__lastClickTime,this.__lastClickTime=this.__newClickTime,this.__lastPointer=e,this.__lastIsEditing=this.isEditing,this.__lastSelected=this.selected},isDoubleClick:function(t){return this.__newClickTime-this.__lastClickTime<500&&this.__lastPointer.x===t.x&&this.__lastPointer.y===t.y&&this.__lastIsEditing},isTripleClick:function(t){return this.__newClickTime-this.__lastClickTime<500&&this.__lastClickTime-this.__lastLastClickTime<500&&this.__lastPointer.x===t.x&&this.__lastPointer.y===t.y},_stopEvent:function(t){t.preventDefault&&t.preventDefault(),t.stopPropagation&&t.stopPropagation()},initCursorSelectionHandlers:function(){this.initSelectedHandler(),this.initMousedownHandler(),this.initMouseupHandler(),this.initClicks()},initClicks:function(){this.on(\"dblclick\",function(t){this.selectWord(this.getSelectionStartFromPointer(t.e))}),this.on(\"tripleclick\",function(t){this.selectLine(this.getSelectionStartFromPointer(t.e))})},initMousedownHandler:function(){this.on(\"mousedown\",function(t){if(this.editable){var e=this.canvas.getPointer(t.e);this.__mousedownX=e.x,this.__mousedownY=e.y,this.__isMousedown=!0,this.hiddenTextarea&&this.canvas&&this.canvas.wrapperEl.appendChild(this.hiddenTextarea),this.selected&&this.setCursorByClick(t.e),this.isEditing&&(this.__selectionStartOnMouseDown=this.selectionStart,this.initDelayedCursor(!0))}})},_isObjectMoved:function(t){var e=this.canvas.getPointer(t);return this.__mousedownX!==e.x||this.__mousedownY!==e.y},initMouseupHandler:function(){this.on(\"mouseup\",function(t){this.__isMousedown=!1,this.editable&&!this._isObjectMoved(t.e)&&(this.__lastSelected&&!this.__corner&&(this.enterEditing(t.e),this.initDelayedCursor(!0)),this.selected=!0)})},setCursorByClick:function(t){var e=this.getSelectionStartFromPointer(t);t.shiftKey?e<this.selectionStart?(this.setSelectionEnd(this.selectionStart),this.setSelectionStart(e)):this.setSelectionEnd(e):(this.setSelectionStart(e),this.setSelectionEnd(e))},getSelectionStartFromPointer:function(t){for(var e,i,r=this.getLocalPointer(t),n=0,s=0,o=0,a=0,h=0,c=this._textLines.length;c>h;h++){i=this._textLines[h],o+=this._getHeightOfLine(this.ctx,h)*this.scaleY;var l=this._getLineWidth(this.ctx,h),u=this._getLineLeftOffset(l);s=u*this.scaleX;for(var f=0,d=i.length;d>f;f++){if(n=s,s+=this._getWidthOfChar(this.ctx,i[f],h,this.flipX?d-f:f)*this.scaleX,!(o<=r.y||s<=r.x))return this._getNewSelectionStartFromOffset(r,n,s,a+h,d);a++}if(r.y<o)return this._getNewSelectionStartFromOffset(r,n,s,a+h-1,d)}return\"undefined\"==typeof e?this.text.length:void 0},_getNewSelectionStartFromOffset:function(t,e,i,r,n){var s=t.x-e,o=i-t.x,a=o>s?0:1,h=r+a;return this.flipX&&(h=n-h),h>this.text.length&&(h=this.text.length),h}}),fabric.util.object.extend(fabric.IText.prototype,{initHiddenTextarea:function(t){var e;t&&this.canvas?e=this.canvas.getPointer(t):(this.oCoords||this.setCoords(),e=this.oCoords.tl),this.hiddenTextarea=fabric.document.createElement(\"textarea\"),this.hiddenTextarea.setAttribute(\"autocapitalize\",\"off\"),this.hiddenTextarea.style.cssText=\"position: absolute; top: \"+e.y+\"px; left: \"+e.x+\"px; opacity: 0; width: 0px; height: 0px; z-index: -999;\",this.canvas?this.canvas.lowerCanvasEl.parentNode.appendChild(this.hiddenTextarea):fabric.document.body.appendChild(this.hiddenTextarea),fabric.util.addListener(this.hiddenTextarea,\"keydown\",this.onKeyDown.bind(this)),fabric.util.addListener(this.hiddenTextarea,\"keyup\",this.onKeyUp.bind(this)),fabric.util.addListener(this.hiddenTextarea,\"input\",this.onInput.bind(this)),fabric.util.addListener(this.hiddenTextarea,\"copy\",this.copy.bind(this)),fabric.util.addListener(this.hiddenTextarea,\"cut\",this.cut.bind(this)),fabric.util.addListener(this.hiddenTextarea,\"paste\",this.paste.bind(this)),fabric.util.addListener(this.hiddenTextarea,\"compositionstart\",this.onCompositionStart.bind(this)),fabric.util.addListener(this.hiddenTextarea,\"compositionupdate\",this.onCompositionUpdate.bind(this)),fabric.util.addListener(this.hiddenTextarea,\"compositionend\",this.onCompositionEnd.bind(this)),\n!this._clickHandlerInitialized&&this.canvas&&(fabric.util.addListener(this.canvas.upperCanvasEl,\"click\",this.onClick.bind(this)),this._clickHandlerInitialized=!0)},_keysMap:{8:\"removeChars\",9:\"exitEditing\",27:\"exitEditing\",13:\"insertNewline\",33:\"moveCursorUp\",34:\"moveCursorDown\",35:\"moveCursorRight\",36:\"moveCursorLeft\",37:\"moveCursorLeft\",38:\"moveCursorUp\",39:\"moveCursorRight\",40:\"moveCursorDown\",46:\"forwardDelete\"},_ctrlKeysMapUp:{67:\"copy\",88:\"cut\"},_ctrlKeysMapDown:{65:\"selectAll\"},onClick:function(){this.hiddenTextarea&&this.hiddenTextarea.focus()},onKeyDown:function(t){if(this.isEditing){if(t.keyCode in this._keysMap)this[this._keysMap[t.keyCode]](t);else{if(!(t.keyCode in this._ctrlKeysMapDown&&(t.ctrlKey||t.metaKey)))return;this[this._ctrlKeysMapDown[t.keyCode]](t)}t.stopImmediatePropagation(),t.preventDefault(),this.canvas&&this.canvas.renderAll()}},onKeyUp:function(t){return!this.isEditing||this._copyDone?void(this._copyDone=!1):void(t.keyCode in this._ctrlKeysMapUp&&(t.ctrlKey||t.metaKey)&&(this[this._ctrlKeysMapUp[t.keyCode]](t),t.stopImmediatePropagation(),t.preventDefault(),this.canvas&&this.canvas.renderAll()))},onInput:function(t){if(this.isEditing&&!this.inCompositionMode){var e,i,r,n=this.selectionStart||0,s=this.selectionEnd||0,o=this.text.length,a=this.hiddenTextarea.value.length;a>o?(r=\"left\"===this._selectionDirection?s:n,e=a-o,i=this.hiddenTextarea.value.slice(r,r+e)):(e=a-o+s-n,i=this.hiddenTextarea.value.slice(n,n+e)),this.insertChars(i),t.stopPropagation()}},onCompositionStart:function(){this.inCompositionMode=!0,this.prevCompositionLength=0,this.compositionStart=this.selectionStart},onCompositionEnd:function(){this.inCompositionMode=!1},onCompositionUpdate:function(t){var e=t.data;this.selectionStart=this.compositionStart,this.selectionEnd=this.selectionEnd===this.selectionStart?this.compositionStart+this.prevCompositionLength:this.selectionEnd,this.insertChars(e,!1),this.prevCompositionLength=e.length},forwardDelete:function(t){if(this.selectionStart===this.selectionEnd){if(this.selectionStart===this.text.length)return;this.moveCursorRight(t)}this.removeChars(t)},copy:function(t){if(this.selectionStart!==this.selectionEnd){var e=this.getSelectedText(),i=this._getClipboardData(t);i&&i.setData(\"text\",e),fabric.copiedText=e,fabric.copiedTextStyle=this.getSelectionStyles(this.selectionStart,this.selectionEnd),t.stopImmediatePropagation(),t.preventDefault(),this._copyDone=!0}},paste:function(t){var e=null,i=this._getClipboardData(t),r=!0;i?(e=i.getData(\"text\").replace(/\\r/g,\"\"),fabric.copiedTextStyle&&fabric.copiedText===e||(r=!1)):e=fabric.copiedText,e&&this.insertChars(e,r),t.stopImmediatePropagation(),t.preventDefault()},cut:function(t){this.selectionStart!==this.selectionEnd&&(this.copy(t),this.removeChars(t))},_getClipboardData:function(t){return t&&t.clipboardData||fabric.window.clipboardData},getDownCursorOffset:function(t,e){var i,r,n=e?this.selectionEnd:this.selectionStart,s=this.get2DCursorLocation(n),o=s.lineIndex,a=this._textLines[o].slice(0,s.charIndex),h=this._textLines[o].slice(s.charIndex),c=this._textLines[o+1]||\"\";if(o===this._textLines.length-1||t.metaKey||34===t.keyCode)return this.text.length-n;var l=this._getLineWidth(this.ctx,o);r=this._getLineLeftOffset(l);for(var u=r,f=0,d=a.length;d>f;f++)i=a[f],u+=this._getWidthOfChar(this.ctx,i,o,f);var g=this._getIndexOnNextLine(s,c,u);return h.length+1+g},_getIndexOnNextLine:function(t,e,i){for(var r,n=t.lineIndex+1,s=this._getLineWidth(this.ctx,n),o=this._getLineLeftOffset(s),a=o,h=0,c=0,l=e.length;l>c;c++){var u=e[c],f=this._getWidthOfChar(this.ctx,u,n,c);if(a+=f,a>i){r=!0;var d=a-f,g=a,p=Math.abs(d-i),v=Math.abs(g-i);h=p>v?c+1:c;break}}return r||(h=e.length),h},moveCursorDown:function(t){this.abortCursorAnimation(),this._currentCursorOpacity=1;var e=this.getDownCursorOffset(t,\"right\"===this._selectionDirection);t.shiftKey?this.moveCursorDownWithShift(e):this.moveCursorDownWithoutShift(e),this.initDelayedCursor()},moveCursorDownWithoutShift:function(t){this._selectionDirection=\"right\",this.setSelectionStart(this.selectionStart+t),this.setSelectionEnd(this.selectionStart)},swapSelectionPoints:function(){var t=this.selectionEnd;this.setSelectionEnd(this.selectionStart),this.setSelectionStart(t)},moveCursorDownWithShift:function(t){this.selectionEnd===this.selectionStart&&(this._selectionDirection=\"right\"),\"right\"===this._selectionDirection?this.setSelectionEnd(this.selectionEnd+t):this.setSelectionStart(this.selectionStart+t),this.selectionEnd<this.selectionStart&&\"left\"===this._selectionDirection&&(this.swapSelectionPoints(),this._selectionDirection=\"right\"),this.selectionEnd>this.text.length&&this.setSelectionEnd(this.text.length)},getUpCursorOffset:function(t,e){var i=e?this.selectionEnd:this.selectionStart,r=this.get2DCursorLocation(i),n=r.lineIndex;if(0===n||t.metaKey||33===t.keyCode)return i;for(var s,o=this._textLines[n].slice(0,r.charIndex),a=this._textLines[n-1]||\"\",h=this._getLineWidth(this.ctx,r.lineIndex),c=this._getLineLeftOffset(h),l=c,u=0,f=o.length;f>u;u++)s=o[u],l+=this._getWidthOfChar(this.ctx,s,n,u);var d=this._getIndexOnPrevLine(r,a,l);return a.length-d+o.length},_getIndexOnPrevLine:function(t,e,i){for(var r,n=t.lineIndex-1,s=this._getLineWidth(this.ctx,n),o=this._getLineLeftOffset(s),a=o,h=0,c=0,l=e.length;l>c;c++){var u=e[c],f=this._getWidthOfChar(this.ctx,u,n,c);if(a+=f,a>i){r=!0;var d=a-f,g=a,p=Math.abs(d-i),v=Math.abs(g-i);h=p>v?c:c-1;break}}return r||(h=e.length-1),h},moveCursorUp:function(t){this.abortCursorAnimation(),this._currentCursorOpacity=1;var e=this.getUpCursorOffset(t,\"right\"===this._selectionDirection);t.shiftKey?this.moveCursorUpWithShift(e):this.moveCursorUpWithoutShift(e),this.initDelayedCursor()},moveCursorUpWithShift:functi