require.config({"config": {
        "jsbuild":{"Magento_Paypal/js/paypal-checkout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data',\n    'jquery-ui-modules/widget',\n    'mage/mage'\n], function ($, confirm, customerData) {\n    'use strict';\n\n    $.widget('mage.paypalCheckout', {\n        options: {\n            originalForm:\n                'form:not(#product_addtocart_form_from_popup):has(input[name=\"product\"][value=%1])',\n            productId: 'input[type=\"hidden\"][name=\"product\"]',\n            ppCheckoutSelector: '[data-role=pp-checkout-url]',\n            ppCheckoutInput: '<input type=\"hidden\" data-role=\"pp-checkout-url\" name=\"return_url\" value=\"\"/>'\n        },\n\n        /**\n         * Initialize store credit events\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', '[data-action=\"checkout-form-submit\"]', $.proxy(function (e) {\n                var $target = $(e.target),\n                    returnUrl = $target.data('checkout-url'),\n                    productId = $target.closest('form').find(this.options.productId).val(),\n                    originalForm = this.options.originalForm.replace('%1', productId),\n                    self = this,\n                    billingAgreement = customerData.get('paypal-billing-agreement');\n\n                e.preventDefault();\n\n                if (billingAgreement().askToCreate) {\n                    confirm({\n                        content: billingAgreement().confirmMessage,\n                        actions: {\n\n                            /**\n                             * Confirmation handler\n                             *\n                             */\n                            confirm: function () {\n                                returnUrl = billingAgreement().confirmUrl;\n                                self._redirect(returnUrl, originalForm);\n                            },\n\n                            /**\n                             * Cancel confirmation handler\n                             *\n                             */\n                            cancel: function (event) {\n                                if (event && !$(event.target).hasClass('action-close')) {\n                                    self._redirect(returnUrl);\n                                }\n                            }\n                        }\n                    });\n                } else {\n                    this._redirect(returnUrl, originalForm);\n                }\n            }, this));\n        },\n\n        /**\n         * Redirect to certain url, with optional form\n         * @param {String} returnUrl\n         * @param {HTMLElement} originalForm\n         *\n         */\n        _redirect: function (returnUrl, originalForm) {\n            var $form,\n                ppCheckoutInput;\n\n            if (this.options.isCatalogProduct) {\n                // find the form from which the button was clicked\n                $form = originalForm ? $(originalForm) : $($(this.options.shortcutContainerClass).closest('form'));\n\n                ppCheckoutInput = $form.find(this.options.ppCheckoutSelector)[0];\n\n                if (!ppCheckoutInput) {\n                    ppCheckoutInput = $(this.options.ppCheckoutInput);\n                    ppCheckoutInput.appendTo($form);\n                }\n                $(ppCheckoutInput).val(returnUrl);\n\n                $form.trigger('submit');\n            } else {\n                $.mage.redirect(returnUrl);\n            }\n        }\n    });\n\n    return $.mage.paypalCheckout;\n});\n","Magento_Paypal/js/order-review.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'mage/translate',\n    'mage/mage',\n    'mage/validation'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.orderReview', {\n        options: {\n            orderReviewSubmitSelector: '#review-button',\n            shippingSelector: '#shipping_method',\n            shippingSubmitFormSelector: null,\n            updateOrderSelector: '#update-order',\n            billingAsShippingSelector: '#billing\\\\:as_shipping',\n            updateContainerSelector: '#details-reload',\n            waitLoadingContainer: '#review-please-wait',\n            shippingMethodContainer: '#shipping-method-container',\n            agreementSelector: 'div.checkout-agreements input',\n            isAjax: false,\n            shippingMethodUpdateUrl: null,\n            updateOrderSubmitUrl: null,\n            canEditShippingMethod: false\n        },\n\n        /**\n         * Widget instance properties\n         */\n        triggerPropertyChange: true,\n        isShippingSubmitForm: false,\n\n        /** @inheritdoc */\n        _create: function () {\n            var isDisable;\n\n            //change handler for ajaxEnabled\n            if (this.options.isAjax) {\n                this._submitOrder = this._ajaxSubmitOrder;\n            }\n\n            this.element.on('click', this.options.orderReviewSubmitSelector, $.proxy(this._submitOrder, this))\n                .on('click', this.options.billingAsShippingSelector, $.proxy(this._shippingTobilling, this))\n                .on('change',\n                    this.options.shippingSelector,\n                    $.proxy(this._submitUpdateOrder,\n                        this,\n                        this.options.updateOrderSubmitUrl,\n                        this.options.updateContainerSelector\n                    )\n                ).find(this.options.updateOrderSelector).on('click', $.proxy(this._updateOrderHandler, this)).end();\n            this._shippingTobilling();\n\n            if ($(this.options.shippingSubmitFormSelector).length && this.options.canEditShippingMethod) {\n                this.isShippingSubmitForm = true;\n                $(this.options.shippingSubmitFormSelector)\n                    .on('change',\n                        this.options.shippingSelector,\n                        $.proxy(\n                            this._submitUpdateOrder,\n                            this,\n                            $(this.options.shippingSubmitFormSelector).prop('action'),\n                            this.options.updateContainerSelector\n                        )\n                    );\n                this._updateOrderSubmit(!$(this.options.shippingSubmitFormSelector)\n                    .find(this.options.shippingSelector).val());\n            } else {\n                isDisable = this.isShippingSubmitForm && this.element.find(this.options.shippingSelector).val();\n                this.element\n                    .on('input propertychange', ':input[name]',\n                        $.proxy(this._updateOrderSubmit, this, isDisable, this._onShippingChange)\n                    ).find('select').not(this.options.shippingSelector).on('change', this._propertyChange);\n                this._updateOrderSubmit(isDisable);\n            }\n        },\n\n        /**\n         * show ajax loader\n         */\n        _ajaxBeforeSend: function () {\n            this.element.find(this.options.waitLoadingContainer).show();\n        },\n\n        /**\n         * hide ajax loader\n         */\n        _ajaxComplete: function () {\n            this.element.find(this.options.waitLoadingContainer).hide();\n        },\n\n        /**\n         * trigger propertychange for input type select\n         */\n        _propertyChange: function () {\n            $(this).trigger('propertychange');\n        },\n\n        /**\n         * trigger change for the update of shipping methods from server\n         */\n        _updateOrderHandler: function () {\n            $(this.options.shippingSelector).trigger('change');\n        },\n\n        /**\n         * Attempt to submit order\n         */\n        _submitOrder: function () {\n            if (this._validateForm()) {\n                this.element.find(this.options.updateOrderSelector).fadeTo(0, 0.5)\n                    .end().find(this.options.waitLoadingContainer).show()\n                    .end().trigger('submit');\n                this._updateOrderSubmit(true);\n            }\n        },\n\n        /**\n         * Attempt to ajax submit order\n         */\n        _ajaxSubmitOrder: function () {\n            if (this.element.find(this.options.waitLoadingContainer).is(':visible')) {\n                return false;\n            }\n            $.ajax({\n                url: this.element.prop('action'),\n                type: 'post',\n                context: this,\n                data: {\n                    isAjax: 1\n                },\n                dataType: 'json',\n                beforeSend: this._ajaxBeforeSend,\n                complete: this._ajaxComplete,\n\n                /** @inheritdoc */\n                success: function (response) {\n                    var msg;\n\n                    if (typeof response === 'object' && !$.isEmptyObject(response)) {\n                        if (response['error_messages']) {\n                            this._ajaxComplete();\n                            msg = response['error_messages'];\n\n                            /* eslint-disable max-depth */\n                            if (msg) {\n                                if (Array.isArray(msg)) {\n                                    msg = msg.join('\\n');\n                                }\n                            }\n\n                            /* eslint-enablemax-depth */\n                            alert({\n                                content: msg\n                            });\n\n                            return false;\n                        }\n\n                        if (response.redirect) {\n                            $.mage.redirect(response.redirect);\n\n                            return false;\n                        } else if (response.success) {\n                            $.mage.redirect(this.options.successUrl);\n\n                            return false;\n                        }\n                        this._ajaxComplete();\n                        alert({\n                            content: $.mage.__('Sorry, something went wrong.')\n                        });\n                    }\n                },\n\n                /** @inheritdoc */\n                error: function () {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    this._ajaxComplete();\n                }\n            });\n        },\n\n        /**\n         * Validate Order form\n         */\n        _validateForm: function () {\n            this.element.find(this.options.agreementSelector).off('change').on('change', $.proxy(function () {\n                var isValid = this._validateForm();\n\n                this._updateOrderSubmit(!isValid);\n            }, this));\n\n            if (this.element.data('mageValidation')) {\n                return this.element.validation().valid();\n            }\n\n            return true;\n        },\n\n        /**\n         * Check/Set whether order can be submitted\n         * Also disables form submission element, if any\n         * @param {*} shouldDisable - whether should prevent order submission explicitly\n         * @param {Function} [fn] - function for shipping change handler\n         * @param {*} [*] - if true the property change will be set to true\n         */\n        _updateOrderSubmit: function (shouldDisable, fn) {\n            this._toggleButton(this.options.orderReviewSubmitSelector, shouldDisable);\n\n            if (typeof fn === 'function') {\n                fn.call(this);\n            }\n        },\n\n        /**\n         * Enable/Disable button\n         * @param {jQuery} button - button selector to be toggled\n         * @param {*} disable - boolean for toggling\n         */\n        _toggleButton: function (button, disable) {\n            $(button).prop({\n                'disabled': disable\n            }).toggleClass('no-checkout', disable).fadeTo(0, disable ? 0.5 : 1);\n        },\n\n        /**\n         * Copy element value from shipping to billing address\n         * @param {jQuery.Event} e - optional\n         */\n        _shippingTobilling: function (e) {\n            var isChecked, opacity;\n\n            if (this.options.shippingSubmitFormSelector) {\n                return false;\n            }\n            isChecked = $(this.options.billingAsShippingSelector).is(':checked');\n            opacity = isChecked ? 0.5 : 1;\n\n            if (isChecked) {\n                this.element.validation('clearError', ':input[name^=\"billing\"]');\n            }\n            $(':input[name^=\"shipping\"]', this.element).each($.proxy(function (key, value) {\n                var fieldObj = $(value.id.replace('shipping:', '#billing\\\\:'));\n\n                if (isChecked) {\n                    fieldObj = fieldObj.val($(value).val());\n                }\n                fieldObj.prop({\n                    'readonly': isChecked,\n                    'disabled': isChecked\n                }).fadeTo(0, opacity);\n\n                if (fieldObj.is('select')) {\n                    this.triggerPropertyChange = false;\n                    fieldObj.trigger('change');\n                }\n            }, this));\n\n            if (isChecked || e) {\n                this._updateOrderSubmit(true);\n            }\n            this.triggerPropertyChange = true;\n        },\n\n        /**\n         * Dispatch an ajax request of Update Order submission\n         * @param {*} url - url where to submit shipping method\n         * @param {*} resultId - id of element to be updated\n         */\n        _submitUpdateOrder: function (url, resultId) {\n            var isChecked, formData, callBackResponseHandler, shippingMethod;\n\n            if (this.element.find(this.options.waitLoadingContainer).is(':visible')) {\n                return false;\n            }\n            isChecked = $(this.options.billingAsShippingSelector).is(':checked');\n            formData = null;\n            callBackResponseHandler = null;\n            let val = $(this.options.shippingSelector).val();\n\n            shippingMethod = val.trim();\n            this._shippingTobilling();\n\n            if (url && resultId && shippingMethod) {\n                this._updateOrderSubmit(true);\n                this._toggleButton(this.options.updateOrderSelector, true);\n\n                // form data and callBack updated based on the shipping Form element\n                if (this.isShippingSubmitForm) {\n                    formData = $(this.options.shippingSubmitFormSelector).serialize() + '&isAjax=true';\n\n                    /**\n                     * @param {Object} response\n                     */\n                    callBackResponseHandler = function (response) {\n                        $(resultId).html(response);\n                        this._updateOrderSubmit(false);\n                        this._ajaxComplete();\n                    };\n                } else {\n                    formData = this.element.serialize() + '&isAjax=true';\n\n                    /**\n                     * @param {Object} response\n                     */\n                    callBackResponseHandler = function (response) {\n                        $(resultId).html(response);\n                        this._ajaxShippingUpdate(shippingMethod);\n                    };\n                }\n\n                if (isChecked) {\n                    $(this.options.shippingSelect).prop('disabled', true);\n                }\n                $.ajax({\n                    url: url,\n                    type: 'post',\n                    context: this,\n                    beforeSend: this._ajaxBeforeSend,\n                    data: formData,\n                    success: callBackResponseHandler\n                });\n            }\n        },\n\n        /**\n         * Update Shipping Methods Element from server\n         * @param {*} shippingMethod\n         */\n        _ajaxShippingUpdate: function (shippingMethod) {\n            $.ajax({\n                url: this.options.shippingMethodUpdateUrl,\n                data: {\n                    isAjax: true,\n                    'shipping_method': shippingMethod\n                },\n                type: 'post',\n                context: this,\n\n                /** @inheritdoc */\n                success: function (response) {\n                    $(this.options.shippingMethodContainer).parent().html(response);\n                    this._toggleButton(this.options.updateOrderSelector, false);\n                    this._updateOrderSubmit(false);\n                },\n                complete: this._ajaxComplete\n            });\n        },\n\n        /**\n         * Actions on change Shipping Address data\n         */\n        _onShippingChange: function () {\n            let val = $(this.options.shippingSelector).val();\n\n            if (this.triggerPropertyChange && val.trim()) {\n                this.element.find(this.options.shippingSelector).hide().end()\n                    .find(this.options.shippingSelector + '_update').show();\n            }\n        }\n    });\n\n    return $.mage.orderReview;\n});\n","Magento_Paypal/js/model/iframe.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['ko'], function (ko) {\n    'use strict';\n\n    var isInAction = ko.observable(false);\n\n    return {\n        isInAction: isInAction,\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        stopEventPropagation: function (event) {\n            event.stopImmediatePropagation();\n            event.preventDefault();\n        }\n    };\n});\n","Magento_Paypal/js/model/iframe-redirect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Paypal/js/model/iframe',\n    'Magento_Ui/js/model/messageList'\n],\nfunction (ko, iframe, messageList) {\n    'use strict';\n\n    return function (cartUrl, errorMessage, goToSuccessPage, successUrl) {\n        if (this === window.self) {\n            window.location = cartUrl;\n        }\n\n        if (!!errorMessage.message) { //eslint-disable-line no-extra-boolean-cast\n            document.removeEventListener('click', iframe.stopEventPropagation, true);\n            iframe.isInAction(false);\n            messageList.addErrorMessage(errorMessage);\n        } else if (!!goToSuccessPage) { //eslint-disable-line no-extra-boolean-cast\n            window.location = successUrl;\n        } else {\n            window.location = cartUrl;\n        }\n    };\n});\n","Magento_Paypal/js/in-context/paypal-sdk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var dfd = $.Deferred();\n\n    /**\n     * Loads the PayPal SDK object\n     * @param {String} paypalUrl - the url of the PayPal SDK\n     * @param {Array} dataAttributes - Array of the Attributes for PayPal SDK Script tag\n     */\n    return function loadPaypalScript(paypalUrl, dataAttributes) {\n        //configuration for loaded PayPal script\n        require.config({\n            paths: {\n                paypalSdk: paypalUrl\n            },\n            shim: {\n                paypalSdk: {\n                    exports: 'paypal'\n                }\n            },\n            attributes: {\n                'paypalSdk': dataAttributes\n            },\n\n            /**\n             * Add attributes under Paypal SDK Script tag\n             */\n            onNodeCreated: function (node, config, name) {\n                if (config.attributes && config.attributes[name]) {\n                    $.each(dataAttributes, function (index, elem) {\n                        node.setAttribute(index, elem);\n                    });\n                }\n            }\n        });\n\n        if (dfd.state() !== 'resolved') {\n            require(['paypalSdk'], function (paypalObject) {\n                dfd.resolve(paypalObject);\n            });\n        }\n\n        return dfd.promise();\n    };\n});\n","Magento_Paypal/js/in-context/button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_Paypal/js/in-context/express-checkout-wrapper',\n    'Magento_Customer/js/customer-data'\n], function (Component, $, Wrapper, customerData) {\n    'use strict';\n\n    return Component.extend(Wrapper).extend({\n        defaults: {\n            declinePayment: false\n        },\n\n        /** @inheritdoc */\n        initialize: function (config, element) {\n            var cart = customerData.get('cart'),\n                customer = customerData.get('customer');\n\n            this._super();\n            this.renderPayPalButtons(element);\n\n            if (cart().isGuestCheckoutAllowed === undefined) {\n                cart.subscribe(function (updatedCart) {\n                    this.declinePayment = !customer().firstname && !cart().isGuestCheckoutAllowed;\n\n                    return updatedCart;\n                }.bind(this));\n            }\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        beforePayment: function (resolve, reject) {\n            var promise = $.Deferred();\n\n            if (this.declinePayment) {\n                this.addError(this.signInMessage, 'warning');\n\n                reject();\n            } else {\n                promise.resolve();\n            }\n\n            return promise;\n        },\n\n        /** @inheritdoc */\n        prepareClientConfig: function () {\n            this._super();\n\n            return this.clientConfig;\n        }\n    });\n});\n","Magento_Paypal/js/in-context/express-checkout-smart-buttons.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* eslint-disable max-nested-callbacks */\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_Paypal/js/in-context/paypal-sdk',\n    'Magento_Customer/js/customer-data',\n    'domReady!'\n], function (_, $, paypalSdk, customerData) {\n    'use strict';\n\n    /**\n     * Triggers beforePayment action on PayPal buttons\n     *\n     * @param {Object} clientConfig\n     * @returns {Object} jQuery promise\n     */\n    function performCreateOrder(clientConfig) {\n        var params = {\n            'quote_id': clientConfig.quoteId,\n            'customer_id': clientConfig.customerId || '',\n            'form_key': clientConfig.formKey,\n            button: clientConfig.button\n        };\n\n        return $.Deferred(function (deferred) {\n            clientConfig.rendererComponent.beforePayment(deferred.resolve, deferred.reject).then(function () {\n                $.post(clientConfig.getTokenUrl, params).done(function (res) {\n                    clientConfig.rendererComponent.afterPayment(res, deferred.resolve, deferred.reject);\n                }).fail(function (jqXHR, textStatus, err) {\n                    clientConfig.rendererComponent.catchPayment(err, deferred.resolve, deferred.reject);\n                });\n            });\n        }).promise();\n    }\n\n    /**\n     * Triggers beforeOnAuthorize action on PayPal buttons\n     * @param {Object} clientConfig\n     * @param {Object} data\n     * @param {Object} actions\n     * @returns {Object} jQuery promise\n     */\n    function performOnApprove(clientConfig, data, actions) {\n        var params = {\n            paymentToken: data.orderID,\n            payerId: data.payerID,\n            paypalFundingSource: customerData.get('paypal-funding-source'),\n            'form_key': clientConfig.formKey\n        };\n\n        return $.Deferred(function (deferred) {\n            clientConfig.rendererComponent.beforeOnAuthorize(deferred.resolve, deferred.reject, actions)\n                .then(function () {\n                    $.post(clientConfig.onAuthorizeUrl, params).done(function (res) {\n                        clientConfig.rendererComponent\n                            .afterOnAuthorize(res, deferred.resolve, deferred.reject, actions);\n                        customerData.set('paypal-funding-source', '');\n                    }).fail(function (jqXHR, textStatus, err) {\n                        clientConfig.rendererComponent.catchOnAuthorize(err, deferred.resolve, deferred.reject);\n                        customerData.set('paypal-funding-source', '');\n                    });\n                });\n        }).promise();\n    }\n\n    return function (clientConfig, element) {\n        paypalSdk(clientConfig.sdkUrl, clientConfig.dataAttributes).done(function (paypal) {\n            paypal.Buttons({\n                style: clientConfig.styles,\n\n                /**\n                 * onInit is called when the button first renders\n                 * @param {Object} data\n                 * @param {Object} actions\n                 */\n                onInit: function (data, actions) {\n                    clientConfig.rendererComponent.validate(actions);\n                },\n\n                /**\n                 * Triggers beforePayment action on PayPal buttons\n                 * @returns {Object} jQuery promise\n                 */\n                createOrder: function () {\n                    return performCreateOrder(clientConfig);\n                },\n\n                /**\n                 * Triggers beforeOnAuthorize action on PayPal buttons\n                 * @param {Object} data\n                 * @param {Object} actions\n                 */\n                onApprove: function (data, actions) {\n                    performOnApprove(clientConfig, data, actions);\n                },\n\n                /**\n                 * Execute logic on Paypal button click\n                 */\n                onClick: function (data) {\n                    customerData.set('paypal-funding-source', data.fundingSource);\n                    clientConfig.rendererComponent.validate();\n                    clientConfig.rendererComponent.onClick();\n                },\n\n                /**\n                 * Process cancel action\n                 * @param {Object} data\n                 * @param {Object} actions\n                 */\n                onCancel: function (data, actions) {\n                    clientConfig.rendererComponent.onCancel(data, actions);\n                },\n\n                /**\n                 * Process errors\n                 *\n                 * @param {Error} err\n                 */\n                onError: function (err) {\n                    clientConfig.rendererComponent.onError(err);\n                }\n            }).render(element);\n        });\n    };\n});\n","Magento_Paypal/js/in-context/express-checkout-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Customer/js/customer-data',\n    'Magento_Paypal/js/in-context/express-checkout-smart-buttons',\n    'Magento_Ui/js/modal/alert',\n    'mage/cookies'\n], function ($, $t, customerData, checkoutSmartButtons, alert) {\n    'use strict';\n\n    return {\n        defaults: {\n            paymentActionError: $t('Something went wrong with your request. Please try again later.'),\n            signInMessage: $t('To check out, please sign in with your email address.')\n        },\n\n        /**\n         * Render PayPal buttons using checkout.js\n         */\n        renderPayPalButtons: function (element) {\n            checkoutSmartButtons(this.prepareClientConfig(), element);\n        },\n\n        /**\n         * Validate payment method\n         *\n         * @param {Object} actions\n         */\n        validate: function (actions) {\n            this.actions = actions || this.actions;\n        },\n\n        /**\n         * Execute logic on Paypal button click\n         */\n        onClick: function () {},\n\n        /**\n         * Before payment execute\n         *\n         * @param {Function} resolve\n         * @param {Function} reject\n         * @return {*}\n         */\n        beforePayment: function (resolve, reject) { //eslint-disable-line no-unused-vars\n            return $.Deferred().resolve();\n        },\n\n        /**\n         * After payment execute\n         *\n         * @param {Object} res\n         * @param {Function} resolve\n         * @param {Function} reject\n         *\n         * @return {*}\n         */\n        afterPayment: function (res, resolve, reject) {\n\n            if (res.success) {\n                return resolve(res.token);\n            }\n\n            return reject(new Error(res['error_message']));\n        },\n\n        /**\n         * Catch payment\n         *\n         * @param {Error} err\n         * @param {Function} resolve\n         * @param {Function} reject\n         */\n        catchPayment: function (err, resolve, reject) {\n            this.addAlert(this.paymentActionError);\n            reject(err);\n        },\n\n        /**\n         * Before onAuthorize execute\n         *\n         * @param {Function} resolve\n         * @param {Function} reject\n         * @param {Object} actions\n         *\n         * @return {jQuery.Deferred}\n         */\n        beforeOnAuthorize: function (resolve, reject, actions) { //eslint-disable-line no-unused-vars\n            //display loading widget.\n            $('body').trigger('processStart');\n\n            return $.Deferred().resolve();\n        },\n\n        /**\n         * After onAuthorize execute\n         *\n         * @param {Object} res\n         * @param {Function} resolve\n         * @param {Function} reject\n         * @param {Object} actions\n         *\n         * @return {*}\n         */\n        afterOnAuthorize: function (res, resolve, reject, actions) {\n            $('body').trigger('processStop');\n\n            if (res.success) {\n                resolve();\n\n                return actions.redirect(res.redirectUrl);\n            }\n\n            return reject(new Error(res['error_message']));\n        },\n\n        /**\n         * Catch payment\n         *\n         * @param {Error} err\n         * @param {Function} resolve\n         * @param {Function} reject\n         */\n        catchOnAuthorize: function (err, resolve, reject) {\n            $('body').trigger('processStop');\n            this.addAlert(this.paymentActionError);\n            reject(err);\n        },\n\n        /**\n         * Process cancel action\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         */\n        onCancel: function (data, actions) {\n            $('body').trigger('processStop');\n            actions.redirect(this.clientConfig.onCancelUrl);\n        },\n\n        /**\n         * Process errors\n         *\n         * @param {Error} err\n         */\n        onError: function (err) { //eslint-disable-line no-unused-vars\n            // Uncaught error isn't displayed in the console\n        },\n\n        /**\n         * Adds error message\n         *\n         * @param {String} message\n         * @param {String} [type]\n         */\n        addError: function (message, type) {\n            type = type || 'error';\n            customerData.set('messages', {\n                messages: [{\n                    type: type,\n                    text: message\n                }],\n                'data_id': Math.floor(Date.now() / 1000)\n            });\n        },\n\n        /**\n         * Add alert message\n         *\n         * @param {String} message\n         */\n        addAlert: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * @returns {String}\n         */\n        getButtonId: function () {\n            return this.inContextId;\n        },\n\n        /**\n         * Populate client config with all required data\n         *\n         * @return {Object}\n         */\n        prepareClientConfig: function () {\n            this.clientConfig.rendererComponent = this;\n            this.clientConfig.formKey = $.mage.cookies.get('form_key');\n\n            return this.clientConfig;\n        }\n    };\n});\n","Magento_Paypal/js/in-context/product-express-checkout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    'uiComponent',\n    'Magento_Paypal/js/in-context/express-checkout-wrapper',\n    'Magento_Customer/js/customer-data'\n], function (_, $, Component, Wrapper, customerData) {\n    'use strict';\n\n    return Component.extend(Wrapper).extend({\n        defaults: {\n            productFormSelector: '#product_addtocart_form',\n            declinePayment: false,\n            formInvalid: false,\n            productAddedToCart: false\n        },\n\n        /** @inheritdoc */\n        initialize: function (config, element) {\n            var cart = customerData.get('cart'),\n                customer = customerData.get('customer'),\n                isGuestCheckoutAllowed;\n\n            this._super();\n\n            isGuestCheckoutAllowed = cart().isGuestCheckoutAllowed;\n\n            if (typeof isGuestCheckoutAllowed === 'undefined') {\n                isGuestCheckoutAllowed = config.clientConfig.isGuestCheckoutAllowed;\n            }\n\n            if (config.clientConfig.isVisibleOnProductPage) {\n                this.renderPayPalButtons(element);\n            }\n\n            this.declinePayment = !customer().firstname && !isGuestCheckoutAllowed;\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        onClick: function () {\n            var $form = $(this.productFormSelector);\n\n            if (!this.declinePayment && !this.productAddedToCart) {\n                $form.trigger('submit');\n                this.formInvalid = !$form.validation('isValid');\n                this.productAddedToCart = true;\n            }\n        },\n\n        /** @inheritdoc */\n        beforePayment: function (resolve, reject) {\n            var promise = $.Deferred();\n\n            if (this.declinePayment) {\n                this.addError(this.signInMessage, 'warning');\n                reject();\n            } else if (this.formInvalid) {\n                reject();\n            } else {\n                $(document).on('ajax:addToCart', function (e, data) {\n                    if (_.isEmpty(data.response)) {\n                        return promise.resolve();\n                    }\n\n                    return reject();\n                });\n                $(document).on('ajax:addToCart:error', reject);\n            }\n\n            return promise;\n        },\n\n        /**\n         * After payment execute\n         *\n         * @param {Object} res\n         * @param {Function} resolve\n         * @param {Function} reject\n         *\n         * @return {*}\n         */\n        afterPayment: function (res, resolve, reject) {\n            if (res.success) {\n                return resolve(res.token);\n            }\n\n            this.addAlert(res['error_message']);\n\n            return reject(new Error(res['error_message']));\n        },\n\n        /** @inheritdoc */\n        prepareClientConfig: function () {\n            this._super();\n            this.clientConfig.quoteId = '';\n            this.clientConfig.customerId = '';\n\n            return this.clientConfig;\n        },\n\n        /** @inheritdoc */\n        onError: function (err) {\n            this.productAddedToCart = false;\n            this._super(err);\n        },\n\n        /** @inheritdoc */\n        onCancel: function (data, actions) {\n            this.productAddedToCart = false;\n            this._super(data, actions);\n        },\n\n        /** @inheritdoc */\n        afterOnAuthorize: function (res, resolve, reject, actions) {\n            this.productAddedToCart = false;\n\n            return this._super(res, resolve, reject, actions);\n        }\n    });\n});\n","Magento_Paypal/js/in-context/billing-agreement.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data'\n], function ($, confirm, customerData) {\n    'use strict';\n\n    $.widget('mage.billingAgreement', {\n        options: {\n            invalidateOnLoad: false,\n            cancelButtonSelector: '.block-billing-agreements-view button.cancel',\n            cancelMessage: '',\n            cancelUrl: ''\n        },\n\n        /**\n         * Initialize billing agreements events\n         * @private\n         */\n        _create: function () {\n            var self = this;\n\n            if (this.options.invalidateOnLoad) {\n                this.invalidate();\n            }\n            $(this.options.cancelButtonSelector).on('click', function () {\n                confirm({\n                    content: self.options.cancelMessage,\n                    actions: {\n                        /**\n                         * 'Confirm' action handler.\n                         */\n                        confirm: function () {\n                            self.invalidate();\n                            window.location.href = self.options.cancelUrl;\n                        }\n                    }\n                });\n\n                return false;\n            });\n        },\n\n        /**\n         * clear paypal billing agreement customer data\n         * @returns void\n         */\n        invalidate: function () {\n            customerData.invalidate(['paypal-billing-agreement']);\n        }\n    });\n\n    return $.mage.billingAgreement;\n});\n","Magento_Paypal/js/view/paylater.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'uiElement',\n    'uiLayout',\n    'Magento_Paypal/js/in-context/paypal-sdk',\n    'domReady!'\n], function (\n    $,\n    ko,\n    Component,\n    layout,\n    paypalSdk\n) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            template: 'Magento_Paypal/paylater',\n            sdkUrl: '',\n            attributes: {\n                class: 'pay-later-message'\n            },\n            dataAttributes: {},\n            refreshSelector: '',\n            displayAmount: false,\n            amountComponentConfig: {\n                name: '${ $.name }.amountProvider',\n                component: ''\n            }\n        },\n        paypal: null,\n        amount: null,\n\n        /**\n         * Initialize\n         *\n         * @returns {*}\n         */\n        initialize: function () {\n            this._super()\n                .observe(['amount']);\n\n            if (this.displayAmount) {\n                layout([this.amountComponentConfig]);\n            }\n\n            if (this.sdkUrl !== '') {\n                this.loadPayPalSdk(this.sdkUrl, this.dataAttributes)\n                    .then(this._setPayPalObject.bind(this));\n            }\n\n            if (this.refreshSelector) {\n                $(this.refreshSelector).on('click', this._refreshMessages.bind(this));\n            }\n\n            return this;\n        },\n\n        /**\n         * Get attribute value from configuration\n         *\n         * @param {String} attributeName\n         * @returns {*|null}\n         */\n        getAttribute: function (attributeName) {\n            return typeof this.attributes[attributeName] !== 'undefined' ?\n                this.attributes[attributeName] : null;\n        },\n\n        /**\n         * Load PP SDK with preconfigured options\n         *\n         * @param {String} sdkUrl - the url of the PayPal SDK\n         * @param {Array} dataAttributes - Array of the Attributes for PayPal SDK Script tag\n         */\n        loadPayPalSdk: function (sdkUrl, dataAttributes) {\n            return paypalSdk(sdkUrl, dataAttributes);\n        },\n\n        /**\n         * Set reference to paypal Sdk object\n         *\n         * @param {Object} paypal\n         * @private\n         */\n        _setPayPalObject: function (paypal) {\n            this.paypal = paypal;\n        },\n\n        /**\n         * Render messages\n         *\n         * @private\n         */\n        _refreshMessages: function () {\n            if (this.paypal) {\n                this.paypal.Messages.render();\n            }\n        }\n    });\n});\n","Magento_Paypal/js/view/amountProviders/product.js":"/**\n* Copyright \u00a9 Magento, Inc. All rights reserved.\n* See COPYING.txt for license details.\n*/\n\ndefine([\n    'jquery',\n    'uiElement',\n    'uiRegistry',\n    'priceBox',\n    'domReady!'\n], function (\n    $,\n    Component,\n    registry\n) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            priceBoxSelector: '.price-box',\n            qtyFieldSelector: '#product_addtocart_form [name=\"qty\"]',\n            amount: null\n        },\n        qty: 1,\n        price: 0,\n        priceType: '',\n\n        /**\n         * Initialize\n         *\n         * @returns {*}\n         */\n        initialize: function () {\n            var priceBox;\n\n            this._super();\n\n            priceBox = $(this.priceBoxSelector);\n            priceBox.on('priceUpdated', this._onPriceChange.bind(this));\n\n            if (priceBox.priceBox('option') &&\n                priceBox.priceBox('option').prices &&\n                (priceBox.priceBox('option').prices.finalPrice || priceBox.priceBox('option').prices.basePrice)\n            ) {\n                this.priceType = priceBox.priceBox('option').prices.finalPrice ? 'finalPrice' : 'basePrice';\n                this.price = priceBox.priceBox('option').prices[this.priceType].amount;\n            }\n\n            $(this.qtyFieldSelector).on('change', this._onQtyChange.bind(this));\n\n            priceBox.trigger('updatePrice');\n\n            return this;\n        },\n\n        /**\n         * Handle changed product qty\n         *\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onQtyChange: function (event) {\n            var qty = parseFloat($(event.target).val());\n\n            this.qty = !isNaN(qty) && qty ? qty : 1;\n            this._updateAmount();\n        },\n\n        /**\n         * Handle product price change\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _onPriceChange: function (event, data) {\n            this.price = data[this.priceType].amount;\n            this._updateAmount();\n        },\n\n        /**\n         * Calculate and update amount\n         *\n         * @private\n         */\n        _updateAmount: function () {\n            var amount = this.price * this.qty,\n                payLater = registry.get(this.parentName);\n\n            if (amount !== 0) {\n                payLater.amount(amount);\n            }\n        }\n    });\n});\n","Magento_Paypal/js/view/amountProviders/checkout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'uiElement',\n    'uiRegistry',\n    'Magento_Checkout/js/model/quote',\n    'domReady!'\n], function (\n    $,\n    ko,\n    Component,\n    registry,\n    quote\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            amount: null\n        },\n\n        /**\n         * Initialize\n         *\n         * @returns {*}\n         */\n        initialize: function () {\n            this._super();\n\n            this.updateAmount();\n\n            return this;\n        },\n\n        /**\n         * Update amount\n         */\n        updateAmount: function () {\n            var payLater = registry.get(this.parentName);\n\n            quote.totals.subscribe(function (newValue) {\n                payLater.amount(newValue['base_grand_total']);\n            });\n        }\n    });\n});\n","Magento_Paypal/js/view/amountProviders/product-grouped.js":"/**\n* Copyright \u00a9 Magento, Inc. All rights reserved.\n* See COPYING.txt for license details.\n*/\n\ndefine([\n    'jquery',\n    'uiElement',\n    'uiRegistry',\n    'domReady!'\n], function (\n    $,\n    Component,\n    registry\n) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            tableWrapperSelector: '.table-wrapper.grouped',\n            priceBoxSelector: '[data-role=\"priceBox\"]',\n            qtyFieldSelector: '.input-text.qty',\n            amount: null\n        },\n        priceInfo: {},\n\n        /**\n         * Initialize\n         *\n         * @returns {*}\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n\n            $('tbody tr', this.tableWrapperSelector).each(function (index, element) {\n                var priceBox = $(self.priceBoxSelector, element),\n                    qtyElement = $(self.qtyFieldSelector, element),\n                    productId = priceBox.data('productId'),\n                    priceElement = $('#product-price-' + productId);\n\n                self.priceInfo[productId] = {\n                    qty: self._getQty(qtyElement),\n                    price: priceElement.data('priceAmount')\n                };\n            });\n\n            $(this.qtyFieldSelector).on('change', this._onQtyChange.bind(this));\n\n            this._updateAmount();\n\n            return this;\n        },\n\n        /**\n         * Get product quantity\n         *\n         * @param {jQuery.Element} element\n         * @private\n         */\n        _getQty: function (element) {\n            var qty = parseFloat(element.val());\n\n            return !isNaN(qty) && qty ? qty : 0;\n        },\n\n        /**\n         * Handle changed product quantity\n         *\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onQtyChange: function (event) {\n            var qtyElement = $(event.target),\n                parent = qtyElement.parents('tr'),\n                priceBox = $(this.priceBoxSelector, parent),\n                productId = priceBox.data('productId');\n\n            if (this.priceInfo[productId]) {\n                this.priceInfo[productId].qty = this._getQty(qtyElement);\n            }\n\n            this._updateAmount();\n        },\n\n        /**\n         * Calculate and update amount\n         *\n         * @private\n         */\n        _updateAmount: function () {\n            var productId,\n                amount = 0,\n                payLater = registry.get(this.parentName);\n\n            for (productId in this.priceInfo) {\n                if (this.priceInfo.hasOwnProperty(productId)) {\n                    amount += this.priceInfo[productId].price * this.priceInfo[productId].qty;\n                }\n            }\n\n            payLater.amount(amount);\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/paypal-payments.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    var isContextCheckout = window.checkoutConfig.payment.paypalExpress.isContextCheckout,\n        paypalExpress = 'Magento_Paypal/js/view/payment/method-renderer' +\n            (isContextCheckout ? '/in-context/checkout-express' : '/paypal-express');\n\n    rendererList.push(\n        {\n            type: 'paypal_express',\n            component: paypalExpress,\n            config: window.checkoutConfig.payment.paypalExpress.inContextConfig\n        },\n        {\n            type: 'payflow_express',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/payflow-express'\n        },\n        {\n            type: 'payflow_express_bml',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/payflow-express-bml'\n        },\n        {\n            type: 'payflowpro',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method'\n        },\n        {\n            type: 'payflow_link',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n        },\n        {\n            type: 'payflow_advanced',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n        },\n        {\n            type: 'hosted_pro',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n        },\n        {\n            type: 'paypal_billing_agreement',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/paypal-billing-agreement'\n        }\n    );\n\n    /**\n     * Add view logic here if needed\n     **/\n    return Component.extend({});\n});\n","Magento_Paypal/js/view/payment/method-renderer/payflow-express.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/payflow-express'\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Paypal/js/action/set-payment-method',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Customer/js/customer-data'\n], function ($, Component, setPaymentMethodAction, additionalValidators, quote, customerData) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/payflow-express-bml',\n            billingAgreement: ''\n        },\n\n        /** Init observable variables */\n        initObservable: function () {\n            this._super()\n                .observe('billingAgreement');\n\n            return this;\n        },\n\n        /** Open window with  */\n        showAcceptanceWindow: function (data, event) {\n            window.open(\n                $(event.currentTarget).attr('href'),\n                'olcwhatispaypal',\n                'toolbar=no, location=no,' +\n                ' directories=no, status=no,' +\n                ' menubar=no, scrollbars=yes,' +\n                ' resizable=yes, ,left=0,' +\n                ' top=0, width=400, height=350'\n            );\n\n            return false;\n        },\n\n        /** Returns payment acceptance mark link path */\n        getPaymentAcceptanceMarkHref: function () {\n            return window.checkoutConfig.payment.paypalExpress.paymentAcceptanceMarkHref;\n        },\n\n        /** Returns payment acceptance mark image path */\n        getPaymentAcceptanceMarkSrc: function () {\n            return window.checkoutConfig.payment.paypalExpress.paymentAcceptanceMarkSrc;\n        },\n\n        /** Returns billing agreement data */\n        getBillingAgreementCode: function () {\n            return window.checkoutConfig.payment.paypalExpress.billingAgreementCode[this.item.method];\n        },\n\n        /** Returns payment information data */\n        getData: function () {\n            var parent = this._super(),\n                additionalData = null;\n\n            if (this.getBillingAgreementCode()) {\n                additionalData = {};\n                additionalData[this.getBillingAgreementCode()] = this.billingAgreement();\n            }\n\n            return $.extend(true, parent, {\n                'additional_data': additionalData\n            });\n        },\n\n        /** Redirect to paypal */\n        continueToPayPal: function () {\n            if (additionalValidators.validate()) {\n                //update payment method information if additional data was changed\n                setPaymentMethodAction(this.messageContainer).done(\n                    function () {\n                        customerData.invalidate(['cart']);\n                        $.mage.redirect(\n                            window.checkoutConfig.payment.paypalExpress.redirectUrl[quote.paymentMethod().method]\n                        );\n                    }\n                );\n\n                return false;\n            }\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/payflowpro-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Payment/js/view/payment/iframe',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Vault/js/view/payment/vault-enabler'\n], function ($, Component, additionalValidators, setPaymentInformationAction, fullScreenLoader, VaultEnabler) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/payflowpro-form'\n        },\n        placeOrderHandler: null,\n        validateHandler: null,\n\n        /**\n         * @returns {exports.initialize}\n         */\n        initialize: function () {\n            this._super();\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            return this;\n        },\n\n        /**\n         * @param {Function} handler\n         */\n        setPlaceOrderHandler: function (handler) {\n            this.placeOrderHandler = handler;\n        },\n\n        /**\n         * @param {Function} handler\n         */\n        setValidateHandler: function (handler) {\n            this.validateHandler = handler;\n        },\n\n        /**\n         * @returns {Object}\n         */\n        context: function () {\n            return this;\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        isShowLegend: function () {\n            return true;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'payflowpro';\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            return true;\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            var self = this;\n\n            if (this.validateHandler() &&\n                additionalValidators.validate() &&\n                this.isPlaceOrderActionAllowed() === true\n            ) {\n                this.isPlaceOrderActionAllowed(false);\n                fullScreenLoader.startLoader();\n                $.when(\n                    setPaymentInformationAction(this.messageContainer, self.getData())\n                ).done(\n                    function () {\n                        self.placeOrderHandler().fail(\n                            function () {\n                                fullScreenLoader.stopLoader();\n                            }\n                        );\n                    }\n                ).always(\n                    function () {\n                        self.isPlaceOrderActionAllowed(true);\n                        fullScreenLoader.stopLoader();\n                    }\n                );\n            }\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'cc_type': this.creditCardType(),\n                    'cc_exp_year': this.creditCardExpYear(),\n                    'cc_exp_month': this.creditCardExpMonth(),\n                    'cc_last_4': this.creditCardNumber().substr(-4)\n                }\n            };\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * @returns {Bool}\n         */\n        isVaultEnabled: function () {\n            return this.vaultEnabler.isVaultEnabled();\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return 'payflowpro_cc_vault';\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/paypal-express'\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/iframe-methods.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Paypal/js/model/iframe',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function (Component, iframe, fullScreenLoader) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/iframe-methods',\n            paymentReady: false\n        },\n        redirectAfterPlaceOrder: false,\n        isInAction: iframe.isInAction,\n\n        /**\n         * @return {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe('paymentReady');\n\n            return this;\n        },\n\n        /**\n         * @return {*}\n         */\n        isPaymentReady: function () {\n            return this.paymentReady();\n        },\n\n        /**\n         * Get action url for payment method iframe.\n         * @returns {String}\n         */\n        getActionUrl: function () {\n            return this.isInAction() ? window.checkoutConfig.payment.paypalIframe.actionUrl[this.getCode()] : '';\n        },\n\n        /**\n         * Places order in pending payment status.\n         */\n        placePendingPaymentOrder: function () {\n            if (this.placeOrder()) {\n                fullScreenLoader.startLoader();\n                this.isInAction(true);\n                // capture all click events\n                document.addEventListener('click', iframe.stopEventPropagation, true);\n            }\n        },\n\n        /**\n         * @return {*}\n         */\n        getPlaceOrderDeferredObject: function () {\n            var self = this;\n\n            return this._super().fail(function () {\n                fullScreenLoader.stopLoader();\n                self.isInAction(false);\n                document.removeEventListener('click', iframe.stopEventPropagation, true);\n            });\n        },\n\n        /**\n         * After place order callback\n         */\n        afterPlaceOrder: function () {\n            if (this.iframeIsLoaded) {\n                document.getElementById(this.getCode() + '-iframe')\n                    .contentWindow.location.reload();\n                this.paymentReady(false);\n            }\n\n            this.paymentReady(true);\n            this.iframeIsLoaded = true;\n            this.isPlaceOrderActionAllowed(true);\n            fullScreenLoader.stopLoader();\n        },\n\n        /**\n         * Hide loader when iframe is fully loaded.\n         */\n        iframeLoaded: function () {\n            fullScreenLoader.stopLoader();\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/paypal-billing-agreement.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/view/payment/default',\n    'mage/validation'\n], function ($, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/paypal_billing_agreement-form',\n            selectedBillingAgreement: ''\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('selectedBillingAgreement');\n\n            return this;\n        },\n\n        /**\n         * @return {*}\n         */\n        getTransportName: function () {\n            return window.checkoutConfig.payment.paypalBillingAgreement.transportName;\n        },\n\n        /**\n         * @return {*}\n         */\n        getBillingAgreements: function () {\n            return window.checkoutConfig.payment.paypalBillingAgreement.agreements;\n        },\n\n        /**\n         * @return {Object}\n         */\n        getData: function () {\n            var additionalData = null;\n\n            if (this.getTransportName()) {\n                additionalData = {};\n                additionalData[this.getTransportName()] = this.selectedBillingAgreement();\n            }\n\n            return {\n                'method': this.item.method,\n                'additional_data': additionalData\n            };\n        },\n\n        /**\n         * @return {jQuery}\n         */\n        validate: function () {\n            var form = '#billing-agreement-form';\n\n            return $(form).validation() && $(form).validation('isValid');\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/payflow-express-bml.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/payflow-express-bml'\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/payflowpro/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Vault/js/view/payment/method-renderer/vault'\n], function (VaultComponent) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'Magento_Vault/payment/form'\n        },\n\n        /**\n         * @returns {String}\n         */\n        getToken: function () {\n            return this.publicHash;\n        },\n\n        /**\n         * Get last 4 digits of card\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details['cc_last_4'];\n        },\n\n        /**\n         * Get expiration date\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details['cc_exp_month'] + '/' + this.details['cc_exp_year'];\n        },\n\n        /**\n         * Get card type\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details['cc_type'];\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/in-context/checkout-express.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract',\n    'Magento_Paypal/js/in-context/express-checkout-wrapper',\n    'Magento_Paypal/js/action/set-payment-method',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Ui/js/lib/view/utils/async'\n], function ($, Component, Wrapper, setPaymentMethod, additionalValidators, messageList) {\n    'use strict';\n\n    return Component.extend(Wrapper).extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/paypal-express-in-context',\n            validationElements: 'input'\n        },\n\n        /**\n         * Listens element on change and validate it.\n         *\n         * @param {HTMLElement} context\n         */\n        initListeners: function (context) {\n            $.async(this.validationElements, context, function (element) {\n                $(element).on('change', function () {\n                    this.validate();\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         *  Validates Smart Buttons\n         */\n        validate: function () {\n            this._super();\n\n            if (this.actions) {\n                additionalValidators.validate(true) ? this.actions.enable() : this.actions.disable();\n            }\n        },\n\n        /** @inheritdoc */\n        beforePayment: function (resolve, reject) {\n            var promise = $.Deferred();\n\n            setPaymentMethod(this.messageContainer).done(function () {\n                return promise.resolve();\n            }).fail(function (response) {\n                var error;\n\n                try {\n                    error = JSON.parse(response.responseText);\n                } catch (exception) {\n                    error = this.paymentActionError;\n                }\n\n                this.addError(error);\n\n                return reject(new Error(error));\n            }.bind(this));\n\n            return promise;\n        },\n\n        /**\n         * Populate client config with all required data\n         *\n         * @return {Object}\n         */\n        prepareClientConfig: function () {\n            this._super();\n            this.clientConfig.quoteId = window.checkoutConfig.quoteData['entity_id'];\n            this.clientConfig.customerId = window.customerData.id;\n            this.clientConfig.button = 0;\n\n            return this.clientConfig;\n        },\n\n        /**\n         * Adding logic to be triggered onClick action for smart buttons component\n         */\n        onClick: function () {\n            additionalValidators.validate();\n        },\n\n        /**\n         * Adds error message\n         *\n         * @param {String} message\n         */\n        addError: function (message) {\n            messageList.addErrorMessage({\n                message: message\n            });\n        },\n\n        /**\n         * After payment execute\n         *\n         * @param {Object} res\n         * @param {Function} resolve\n         * @param {Function} reject\n         *\n         * @return {*}\n         */\n        afterPayment: function (res, resolve, reject) {\n            if (res.success) {\n                return resolve(res.token);\n            }\n\n            this.addError(res['error_message']);\n\n            return reject(new Error(res['error_message']));\n        },\n\n        /**\n         * After onAuthorize execute\n         *\n         * @param {Object} res\n         * @param {Function} resolve\n         * @param {Function} reject\n         * @param {Object} actions\n         *\n         * @return {*}\n         */\n        afterOnAuthorize: function (res, resolve, reject, actions) {\n            if (res.success) {\n                resolve();\n\n                return actions.redirect(res.redirectUrl);\n            }\n\n            this.addError(res['error_message']);\n\n            return reject(new Error(res['error_message']));\n        }\n    });\n});\n","Magento_Paypal/js/action/set-payment-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/set-payment-information'\n], function (quote, setPaymentInformation) {\n    'use strict';\n\n    return function (messageContainer) {\n        return setPaymentInformation(messageContainer, quote.paymentMethod());\n    };\n});\n","Magento_Usps/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                },\n                'postcode': {\n                    'required': false\n                }\n            };\n        }\n    };\n});\n","Magento_Usps/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    './shipping-rates-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig;\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var rules = validationRules.getRules(),\n                self = this;\n\n            $.each(rules, function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            if (!this.validationErrors.length) {\n                if (address['country_id'] == checkoutConfig.originCountryCode) { //eslint-disable-line eqeqeq\n                    return !utils.isEmpty(address.postcode);\n                }\n\n                return true;\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Usps/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    '../model/shipping-rates-validator',\n    '../model/shipping-rates-validation-rules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    uspsShippingRatesValidator,\n    uspsShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('usps', uspsShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('usps', uspsShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_Wishlist/js/search.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.wishlistSearch', {\n\n        /**\n         * Bind handlers to events\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(this._toggleForm, this));\n        },\n\n        /**\n         * Toggle Form\n         * @private\n         */\n        _toggleForm: function () {\n            switch (this.element.val()) {\n                case 'name':\n                    $(this.options.emailFormSelector).hide();\n                    $(this.options.nameFormSelector).show();\n                    break;\n\n                case 'email':\n                    $(this.options.nameFormSelector).hide();\n                    $(this.options.emailFormSelector).show();\n                    break;\n                default:\n                    $(this.options.emailFormSelector).add(this.options.nameFormSelector).hide();\n            }\n        }\n    });\n\n    return $.mage.wishlistSearch;\n});\n","Magento_Wishlist/js/wishlist.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'mage/validation/validation',\n    'mage/dataPost'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.wishlist', {\n        options: {\n            dataAttribute: 'item-id',\n            nameFormat: 'qty[{0}]',\n            btnRemoveSelector: '[data-role=remove]',\n            qtySelector: '[data-role=qty]',\n            addToCartSelector: '[data-role=tocart]',\n            addAllToCartSelector: '[data-role=all-tocart]',\n            commentInputType: 'textarea',\n            infoList: false\n        },\n\n        /**\n         * Bind handlers to events.\n         */\n        _create: function () {\n            var _this = this;\n\n            if (!this.options.infoList) {\n                this.element\n                    .on('addToCart', function (event, context) {\n                        var urlParams;\n\n                        event.stopPropagation(event);\n                        $(context).data('stop-processing', true);\n                        urlParams = _this._getItemsToCartParams(\n                            $(context).parents('[data-row=product-item]').find(_this.options.addToCartSelector)\n                        );\n                        $.mage.dataPost().postData(urlParams);\n\n                        return false;\n                    })\n                    .on('click', this.options.btnRemoveSelector, $.proxy(function (event) {\n                        event.preventDefault();\n                        $.mage.dataPost().postData($(event.currentTarget).data('post-remove'));\n                    }, this))\n                    .on('click', this.options.addToCartSelector, $.proxy(this._beforeAddToCart, this))\n                    .on('click', this.options.addAllToCartSelector, $.proxy(this._addAllWItemsToCart, this))\n                    .on('focusin focusout', this.options.commentInputType, $.proxy(this._focusComment, this));\n            }\n\n            // Setup validation for the form\n            this.element.mage('validation', {\n                /** @inheritdoc */\n                errorPlacement: function (error, element) {\n                    error.insertAfter(element.next());\n                }\n            });\n        },\n\n        /**\n         * Process data before add to cart\n         *\n         * - update item's qty value.\n         *\n         * @param {Event} event\n         * @private\n         */\n        _beforeAddToCart: function (event) {\n            var elem = $(event.currentTarget),\n                itemId = elem.data(this.options.dataAttribute),\n                qtyName = $.validator.format(this.options.nameFormat, itemId),\n                qtyValue = elem.parents().find('[name=\"' + qtyName + '\"]').val(),\n                params = elem.data('post');\n\n            if (params) {\n                params.data = $.extend({}, params.data, {\n                    'qty': qtyValue\n                });\n                elem.data('post', params);\n            }\n        },\n\n        /**\n         * Add wish list items to cart.\n         * @private\n         * @param {jQuery} elem - clicked 'add to cart' button\n         */\n        _getItemsToCartParams: function (elem) {\n            var itemId, url, qtyName, qtyValue;\n\n            if (elem.data(this.options.dataAttribute)) {\n                itemId = elem.data(this.options.dataAttribute);\n                url = this.options.addToCartUrl;\n                qtyName = $.validator.format(this.options.nameFormat, itemId);\n                qtyValue = elem.parents().find('[name=\"' + qtyName + '\"]').val();\n                url.data.item = itemId;\n                url.data.qty = qtyValue;\n\n                return url;\n            }\n        },\n\n        /**\n         * Add all wish list items to cart\n         * @private\n         */\n        _addAllWItemsToCart: function () {\n            var urlParams = this.options.addAllToCartUrl,\n                separator = urlParams.action.indexOf('?') >= 0 ? '&' : '?';\n\n            this.element.find(this.options.qtySelector).each(function (index, element) {\n                urlParams.action += separator + $(element).prop('name') + '=' + encodeURIComponent($(element).val());\n                separator = '&';\n            });\n            $.mage.dataPost().postData(urlParams);\n        },\n\n        /**\n         * Toggle comment string.\n         * @private\n         * @param {Event} e\n         */\n        _focusComment: function (e) {\n            var commentInput = e.currentTarget;\n\n            if (commentInput.value === '' || commentInput.value === this.options.commentString) {\n                commentInput.value = commentInput.value === this.options.commentString ?\n                    '' : this.options.commentString;\n            }\n        }\n    });\n\n    // Extension for mage.wishlist - Select All checkbox\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        options: {\n            selectAllCheckbox: '#select-all',\n            parentContainer: '#wishlist-table'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var selectAllCheckboxParent, checkboxCount;\n\n            this._super();\n            selectAllCheckboxParent = $(this.options.selectAllCheckbox).parents(this.options.parentContainer);\n            checkboxCount = selectAllCheckboxParent\n                .find('input:checkbox:not(' + this.options.selectAllCheckbox + ')').length;\n            // If Select all checkbox is checked, check all item checkboxes, if unchecked, uncheck all item checkboxes\n            $(this.options.selectAllCheckbox).on('click', function () {\n                selectAllCheckboxParent.find('input:checkbox').attr('checked', $(this).is(':checked'));\n            });\n            // If all item checkboxes are checked, check select all checkbox,\n            // if not all item checkboxes are checked, uncheck select all checkbox\n            selectAllCheckboxParent.on(\n                'click',\n                'input:checkbox:not(' + this.options.selectAllCheckbox + ')',\n                $.proxy(function () {\n                    var checkedCount = selectAllCheckboxParent\n                        .find('input:checkbox:checked:not(' + this.options.selectAllCheckbox + ')').length;\n\n                    $(this.options.selectAllCheckbox).attr('checked', checkboxCount === checkedCount);\n                }, this)\n            );\n        }\n    });\n    // Extension for mage.wishlist info add to cart\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        /** @inheritdoc */\n        _create: function () {\n            this._super();\n\n            if (this.options.infoList) {\n                this.element.on('addToCart', $.proxy(function (event, context) {\n                    this.element.find('input:checkbox').attr('checked', false);\n                    $(context).closest('tr').find('input:checkbox').attr('checked', true);\n                    this.element.trigger('submit');\n                }, this));\n                this._checkBoxValidate();\n            }\n        },\n\n        /**\n         * validate checkbox selection.\n         * @private\n         */\n        _checkBoxValidate: function () {\n            this.element.validation({\n                submitHandler: $.proxy(function (form) {\n                    if ($(form).find('input:checkbox:checked').length) {\n                        form.submit();\n                    } else {\n                        alert({\n                            content: this.options.checkBoxValidationMessage\n                        });\n                    }\n                }, this)\n            });\n        }\n    });\n\n    // Extension for mage.wishlist - Add Wishlist item to Gift Registry\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        options: {\n            formTmplSelector: '#form-tmpl',\n            formTmplId: '#wishlist-hidden-form'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var _this = this;\n\n            this._super();\n            this.element.on('click', '[data-wishlist-to-giftregistry]', function () {\n                var json = $(this).data('wishlist-to-giftregistry'),\n                    tmplJson = {\n                        item: json.itemId,\n                        entity: json.entity,\n                        url: json.url\n                    },\n                    html = mageTemplate(_this.options.formTmplSelector, {\n                        data: tmplJson\n                    });\n\n                $(html).appendTo('body');\n                $(_this.options.formTmplId).trigger('submit');\n            });\n        }\n    });\n\n    return $.mage.wishlist;\n});\n","Magento_Wishlist/js/add-to-wishlist.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.addToWishlist', {\n        options: {\n            bundleInfo: 'div.control [name^=bundle_option]',\n            configurableInfo: '.super-attribute-select',\n            groupedInfo: '#super-product-table input',\n            downloadableInfo: '#downloadable-links-list input',\n            customOptionsInfo: '.product-custom-option',\n            qtyInfo: '#qty',\n            actionElement: '[data-action=\"add-to-wishlist\"]',\n            productListWrapper: '.product-item-info',\n            productPageWrapper: '.product-info-main'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            var options = this.options,\n                dataUpdateFunc = '_updateWishlistData',\n                validateProductQty = '_validateWishlistQty',\n                changeCustomOption = 'change ' + options.customOptionsInfo,\n                changeQty = 'change ' + options.qtyInfo,\n                updateWishlist = 'click ' + options.actionElement,\n                events = {},\n                key;\n\n            if ('productType' in options) {\n                if (typeof options.productType === 'string') {\n                    options.productType = [options.productType];\n                }\n            } else {\n                options.productType = [];\n            }\n\n            events[changeCustomOption] = dataUpdateFunc;\n            events[changeQty] = dataUpdateFunc;\n            events[updateWishlist] = validateProductQty;\n\n            for (key in options.productType) {\n                if (options.productType.hasOwnProperty(key) && options.productType[key] + 'Info' in options) {\n                    events['change ' + options[options.productType[key] + 'Info']] = dataUpdateFunc;\n                }\n            }\n            this._on(events);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _updateWishlistData: function (event) {\n            var dataToAdd = {},\n                isFileUploaded = false,\n                handleObjSelector = null,\n                self = this;\n\n            if (event.handleObj.selector == this.options.qtyInfo) { //eslint-disable-line eqeqeq\n                this._updateAddToWishlistButton({}, event);\n                event.stopPropagation();\n\n                return;\n            }\n\n            handleObjSelector = $(event.currentTarget).closest('form').find(event.handleObj.selector);\n\n            handleObjSelector.each(function (index, element) {\n                if ($(element).is('input[type=text]') ||\n                    $(element).is('input[type=email]') ||\n                    $(element).is('input[type=number]') ||\n                    $(element).is('input[type=hidden]') ||\n                    $(element).is('input[type=checkbox]:checked') ||\n                    $(element).is('input[type=radio]:checked') ||\n                    $(element).is('textarea') ||\n                    $('#' + element.id + ' option:selected').length\n                ) {\n                    if ($(element).data('selector') || $(element).attr('name')) {\n                        dataToAdd = $.extend({}, dataToAdd, self._getElementData(element));\n                    }\n\n                    return;\n                }\n\n                if ($(element).is('input[type=file]') && $(element).val()) {\n                    isFileUploaded = true;\n                }\n            });\n\n            if (isFileUploaded) {\n                this.bindFormSubmit();\n            }\n            this._updateAddToWishlistButton(dataToAdd, event);\n            event.stopPropagation();\n        },\n\n        /**\n         * @param {Object} dataToAdd\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _updateAddToWishlistButton: function (dataToAdd, event) {\n            var self = this,\n                buttons = this._getAddToWishlistButton(event);\n\n            buttons.each(function (index, element) {\n                var params = $(element).data('post'),\n                    currentTarget = event.currentTarget,\n                    targetElement,\n                    targetValue;\n\n                if (!params) {\n                    params = {\n                        'data': {}\n                    };\n                } else if ($(currentTarget).data('selector') || $(currentTarget).attr('name')) {\n                    targetElement = self._getElementData(currentTarget);\n                    targetValue = Object.keys(targetElement)[0];\n\n                    if (params.data.hasOwnProperty(targetValue) && !dataToAdd.hasOwnProperty(targetValue)) {\n                        delete params.data[targetValue];\n                    }\n                }\n\n                params.data = $.extend({}, params.data, dataToAdd, {\n                    'qty': $(self.options.qtyInfo).val()\n                });\n                $(element).data('post', params);\n            });\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _getAddToWishlistButton: function (event) {\n            var productListWrapper = $(event.currentTarget).closest(this.options.productListWrapper);\n\n            if (productListWrapper.length) {\n                return productListWrapper.find(this.options.actionElement);\n            }\n\n            return $(this.options.actionElement);\n        },\n\n        /**\n         * @param {Object} array1\n         * @param {Object} array2\n         * @return {Object}\n         * @private\n         * @deprecated\n         */\n        _arrayDiffByKeys: function (array1, array2) {\n            var result = {};\n\n            $.each(array1, function (key, value) {\n                if (key.indexOf('option') === -1) {\n                    return;\n                }\n\n                if (!array2[key]) {\n                    result[key] = value;\n                }\n            });\n\n            return result;\n        },\n\n        /**\n         * @param {HTMLElement} element\n         * @return {Object}\n         * @private\n         */\n        _getElementData: function (element) {\n            var data, elementName, elementValue;\n\n            element = $(element);\n            data = {};\n            elementName = element.data('selector') ? element.data('selector') : element.attr('name');\n            elementValue = element.val();\n\n            if (element.is('select[multiple]') && elementValue !== null) {\n                if (elementName.substr(elementName.length - 2) == '[]') { //eslint-disable-line eqeqeq\n                    elementName = elementName.substring(0, elementName.length - 2);\n                }\n                $.each(elementValue, function (key, option) {\n                    data[elementName + '[' + option + ']'] = option;\n                });\n            } else if (elementName.substr(elementName.length - 2) == '[]') { //eslint-disable-line eqeqeq, max-depth\n                elementName = elementName.substring(0, elementName.length - 2);\n\n                data[elementName + '[' + elementValue + ']'] = elementValue;\n            } else {\n                data[elementName] = elementValue;\n            }\n\n            return data;\n        },\n\n        /**\n         * @param {Object} params\n         * @param {Object} dataToAdd\n         * @private\n         * @deprecated\n         */\n        _removeExcessiveData: function (params, dataToAdd) {\n            var dataToRemove = this._arrayDiffByKeys(params.data, dataToAdd);\n\n            $.each(dataToRemove, function (key) {\n                delete params.data[key];\n            });\n        },\n\n        /**\n         * Bind form submit.\n         */\n        bindFormSubmit: function () {\n            var self = this;\n\n            $('[data-action=\"add-to-wishlist\"]').on('click', function (event) {\n                var element, params, form, action;\n\n                event.stopPropagation();\n                event.preventDefault();\n\n                element = $('input[type=file]' + self.options.customOptionsInfo);\n                params = $(event.currentTarget).data('post');\n                form = $(element).closest('form');\n                action = params.action;\n\n                if (params.data.id) {\n                    $('<input>', {\n                        type: 'hidden',\n                        name: 'id',\n                        value: params.data.id\n                    }).appendTo(form);\n                }\n\n                if (params.data.uenc) {\n                    action += 'uenc/' + params.data.uenc;\n                }\n\n                $(form).attr('action', action).trigger('submit');\n            });\n        },\n\n        /**\n         * Validate product quantity before updating Wish List\n         *\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _validateWishlistQty: function (event) {\n            var element = $(this.options.qtyInfo);\n\n            if (!(element.validation() && element.validation('isValid'))) {\n                event.preventDefault();\n                event.stopPropagation();\n\n                return;\n            }\n        }\n    });\n\n    return $.mage.addToWishlist;\n});\n","Magento_Wishlist/js/product/addtowishlist-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Element, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Get request POST data.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['extension_attributes']['wishlist_button'].url);\n        },\n\n        /**\n         * Check if component must be shown.\n         *\n         * @return {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_wishlist', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Wishlist/js/view/wishlist.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.wishlist = customerData.get('wishlist');\n        }\n    });\n});\n","MageBig_NewsPopup/js/js.cookie.js":"/*!\r\n * JavaScript Cookie v2.1.4\r\n * https://github.com/js-cookie/js-cookie\r\n *\r\n * Copyright 2006, 2015 Klaus Hartl & Fagner Brack\r\n * Released under the MIT license\r\n */\r\n;(function (factory) {\r\n    var registeredInModuleLoader = false;\r\n    if (typeof define === 'function' && define.amd) {\r\n        define(factory);\r\n        registeredInModuleLoader = true;\r\n    }\r\n    if (typeof exports === 'object') {\r\n        module.exports = factory();\r\n        registeredInModuleLoader = true;\r\n    }\r\n    if (!registeredInModuleLoader) {\r\n        var OldCookies = window.Cookies;\r\n        var api = window.Cookies = factory();\r\n        api.noConflict = function () {\r\n            window.Cookies = OldCookies;\r\n            return api;\r\n        };\r\n    }\r\n}(function () {\r\n    function extend () {\r\n        var i = 0;\r\n        var result = {};\r\n        for (; i < arguments.length; i++) {\r\n            var attributes = arguments[ i ];\r\n            for (var key in attributes) {\r\n                result[key] = attributes[key];\r\n            }\r\n        }\r\n        return result;\r\n    }\r\n\r\n    function init (converter) {\r\n        function api (key, value, attributes) {\r\n            var result;\r\n            if (typeof document === 'undefined') {\r\n                return;\r\n            }\r\n\r\n            // Write\r\n\r\n            if (arguments.length > 1) {\r\n                attributes = extend({\r\n                    path: '/'\r\n                }, api.defaults, attributes);\r\n\r\n                if (typeof attributes.expires === 'number') {\r\n                    var expires = new Date();\r\n                    expires.setMilliseconds(expires.getMilliseconds() + attributes.expires * 864e+5);\r\n                    attributes.expires = expires;\r\n                }\r\n\r\n                // We're using \"expires\" because \"max-age\" is not supported by IE\r\n                attributes.expires = attributes.expires ? attributes.expires.toUTCString() : '';\r\n\r\n                try {\r\n                    result = JSON.stringify(value);\r\n                    if (/^[\\{\\[]/.test(result)) {\r\n                        value = result;\r\n                    }\r\n                } catch (e) {}\r\n\r\n                if (!converter.write) {\r\n                    value = encodeURIComponent(String(value))\r\n                        .replace(/%(23|24|26|2B|3A|3C|3E|3D|2F|3F|40|5B|5D|5E|60|7B|7D|7C)/g, decodeURIComponent);\r\n                } else {\r\n                    value = converter.write(value, key);\r\n                }\r\n\r\n                key = encodeURIComponent(String(key));\r\n                key = key.replace(/%(23|24|26|2B|5E|60|7C)/g, decodeURIComponent);\r\n                key = key.replace(/[\\(\\)]/g, escape);\r\n\r\n                var stringifiedAttributes = '';\r\n\r\n                for (var attributeName in attributes) {\r\n                    if (!attributes[attributeName]) {\r\n                        continue;\r\n                    }\r\n                    stringifiedAttributes += '; ' + attributeName;\r\n                    if (attributes[attributeName] === true) {\r\n                        continue;\r\n                    }\r\n                    stringifiedAttributes += '=' + attributes[attributeName];\r\n                }\r\n                return (document.cookie = key + '=' + value + stringifiedAttributes);\r\n            }\r\n\r\n            // Read\r\n\r\n            if (!key) {\r\n                result = {};\r\n            }\r\n\r\n            // To prevent the for loop in the first place assign an empty array\r\n            // in case there are no cookies at all. Also prevents odd result when\r\n            // calling \"get()\"\r\n            var cookies = document.cookie ? document.cookie.split('; ') : [];\r\n            var rdecode = /(%[0-9A-Z]{2})+/g;\r\n            var i = 0;\r\n\r\n            for (; i < cookies.length; i++) {\r\n                var parts = cookies[i].split('=');\r\n                var cookie = parts.slice(1).join('=');\r\n\r\n                if (cookie.charAt(0) === '\"') {\r\n                    cookie = cookie.slice(1, -1);\r\n                }\r\n\r\n                try {\r\n                    var name = parts[0].replace(rdecode, decodeURIComponent);\r\n                    cookie = converter.read ?\r\n                        converter.read(cookie, name) : converter(cookie, name) ||\r\n                        cookie.replace(rdecode, decodeURIComponent);\r\n\r\n                    if (this.json) {\r\n                        try {\r\n                            cookie = JSON.parse(cookie);\r\n                        } catch (e) {}\r\n                    }\r\n\r\n                    if (key === name) {\r\n                        result = cookie;\r\n                        break;\r\n                    }\r\n\r\n                    if (!key) {\r\n                        result[name] = cookie;\r\n                    }\r\n                } catch (e) {}\r\n            }\r\n\r\n            return result;\r\n        }\r\n\r\n        api.set = api;\r\n        api.get = function (key) {\r\n            return api.call(api, key);\r\n        };\r\n        api.getJSON = function () {\r\n            return api.apply({\r\n                json: true\r\n            }, [].slice.call(arguments));\r\n        };\r\n        api.defaults = {};\r\n\r\n        api.remove = function (key, attributes) {\r\n            api(key, '', extend(attributes, {\r\n                expires: -1\r\n            }));\r\n        };\r\n\r\n        api.withConverter = init;\r\n\r\n        return api;\r\n    }\r\n\r\n    return init(function () {});\r\n}));","MageBig_NewsPopup/js/ajax-newsletter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'magnificpopup'\n], function ($, customerData) {\n    'use strict';\n\n    return function (config, element, callback) {\n        $(element).on('submit', function (event) {\n            var $form = $(event.currentTarget);\n            event.preventDefault();\n            if ($form.validation() && $form.validation('isValid')) {\n                var formUrl = $form.attr('action');\n\n                $.ajax({\n                    url: formUrl,\n                    data: $form.serialize(),\n                    type: 'post',\n                    beforeSend: function () {\n                        $('body').trigger('processStart');\n                    },\n                    success: function (res) {\n                        if (res.success) {\n                            if (typeof callback === 'function') {\n                                callback(config.cookieFlag, config.cookieLifetime, config.showhome);\n                            }\n\n                            if ($.magnificPopup.instance.isOpen) {\n                                $.magnificPopup.close();\n                            }\n\n                            customerData.set('messages', {\n                                messages: [{\n                                    type: 'success',\n                                    text: res.message\n                                }],\n                                'data_id': Math.floor(Date.now() / 1000)\n                            });\n                        } else {\n                            customerData.set('messages', {\n                                messages: [{\n                                    type: 'error',\n                                    text: res.message\n                                }],\n                                'data_id': Math.floor(Date.now() / 1000)\n                            });\n                        }\n                    },\n                    error: function () {\n                        console.log('subscribe error');\n                    }\n                }).done(function (res) {\n                    $('body').trigger('processStop');\n\n                    if (typeof grecaptcha !== 'undefined') {\n                        var c = $('.g-recaptcha').length;\n                        for (var i = 0; i < c; i++)\n                            grecaptcha.reset(i);\n\n                        $('input[name=\"token\"]').val('');\n                    }\n                });\n            }\n        });\n    };\n});\n","MageBig_NewsPopup/js/newsletter.js":"define([\n    \"jquery\",\n    'MageBig_NewsPopup/js/js.cookie',\n    'Magento_Customer/js/customer-data',\n    'MageBig_NewsPopup/js/ajax-newsletter',\n    'mage/validation',\n    \"domReady!\",\n    \"magnificpopup\"\n], function($,Cookies, customerData, ajaxNewsletter){\n    \"use strict\";\n\n    $.widget('custom.mbNewsPopup', {\n        options: {\n            idPopup: '#magebig_newsletter',\n            cookieName: 'magebig_newsletter',\n            cookieLifetime: 3600,\n            cookieFlag: 'magebig_newsletter_Flag',\n            isSuccess: \".messages .message-success\",\n            notShow: '.not-show-popup input',\n            submitButton: \".btn-subscribe\",\n            form: '#mb-newsletter-form'\n        },\n\n        _create: function() {\n            var subscribeFlag = Cookies.get(this.options.cookieFlag);\n            var cookieName = this.options.cookieName;\n            var cookieFlag = this.options.cookieFlag;\n            var cookieLifetime = this.options.cookieLifetime;\n            var showhome = this.options.showHome;\n            var self = this;\n\n            self.hidePopup(cookieName, cookieLifetime, showhome);\n\n            ajaxNewsletter(self.options, self.options.form, self._subsSetcookie);\n\n            if (!(subscribeFlag && this.options.isSuccess.length) && !Cookies.get(cookieName)) {\n                var idPopup = this.options.idPopup;\n                setTimeout(function () {\n                    if ($.magnificPopup.instance.isOpen) {\n                        $.magnificPopup.close();\n                    }\n                    setTimeout(function () {\n                        $.magnificPopup.open({\n                            items: {\n                                src: idPopup,\n                                type: 'inline'\n                            },\n                            overflowY: 'auto',\n                            fixedContentPos: false,\n                            removalDelay: 300,\n                            mainClass: 'mfp-zoom-in',\n                            callbacks: {\n                                open: function () {\n                                    if (this.fixedContentPos) {\n                                        if (this._hasScrollBar(this.wH)) {\n                                            var s = this._getScrollbarSize();\n                                            if (s) {\n                                                $('.sticky-menu.active').css('padding-right', s);\n                                                $('#go-top').css('margin-right', s);\n                                            }\n                                        }\n                                    }\n                                },\n                                close: function () {\n                                    $('.sticky-menu.active').css('padding-right', '');\n                                    $('#go-top').css('margin-right', '');\n                                }\n                            }\n                        });\n                    }, 500);\n                }, 4500);\n            } else {\n                self._subsRemove(cookieFlag, showhome);\n                self._subsSetcookie(cookieName, cookieLifetime, showhome);\n            }\n        },\n\n        hidePopup: function (cookieName, cookieLifetime, showhome) {\n            var self = this;\n\n            $(this.options.notShow).on('click', function () {\n                var $elm = $(this);\n\n                if ($elm.is(':checked')) {\n                    self._subsSetcookie(cookieName, cookieLifetime, showhome);\n                } else {\n                    self._subsRemove(cookieName, showhome);\n                }\n            });\n        },\n\n        _subsSetcookie: function (cookieName, cookieLifetime, showhome) {\n            if (cookieLifetime == 0 && showhome == 1) {\n                Cookies.set(cookieName, 'true');\n            } else if ((cookieLifetime == 365 || cookieLifetime == 1) && showhome == 0) {\n                Cookies.set(cookieName, 'true', {expires: cookieLifetime, path: '/'});\n            } else if ((cookieLifetime == 365 || cookieLifetime == 1) && showhome == 1) {\n                Cookies.set(cookieName, 'true', {expires: cookieLifetime});\n            } else if (cookieLifetime == 0 && showhome == 0) {\n                Cookies.set(cookieName, 'true', {path: '/'});\n            }\n        },\n\n        _subsRemove: function (cookieName, showhome) {\n            if (showhome == 1) {\n                Cookies.remove(cookieName);\n            } else {\n                Cookies.remove(cookieName, { path: '/' });\n            }\n        },\n\n        validate: function () {\n            var form = this.options.form;\n\n            return $(form).validation() && $(form).validation('isValid');\n        }\n    });\n\n    return $.custom.mbNewsPopup;\n});\n","Magento_Cookie/js/require-cookie.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'mage/mage',\n    'mage/translate'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.requireCookie', {\n        options: {\n            event: 'click',\n            noCookieUrl: 'enable-cookies',\n            triggers: ['.action.login', '.action.submit'],\n            isRedirectCmsPage: true\n        },\n\n        /**\n         * Constructor\n         * @private\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * This method binds elements found in this widget.\n         * @private\n         */\n        _bind: function () {\n            var events = {};\n\n            $.each(this.options.triggers, function (index, value) {\n                events['click ' + value] = '_checkCookie';\n            });\n            this._on(events);\n        },\n\n        /**\n         * This method set the url for the redirect.\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _checkCookie: function (event) {\n            if (navigator.cookieEnabled) {\n                return;\n            }\n\n            event.preventDefault();\n\n            if (this.options.isRedirectCmsPage) {\n                window.location = this.options.noCookieUrl;\n            } else {\n                alert({\n                    content: $.mage.__('Cookies are disabled in your browser.')\n                });\n            }\n        }\n    });\n\n    return $.mage.requireCookie;\n});\n","Magento_Cookie/js/notices.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/cookies'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.cookieNotices', {\n        /** @inheritdoc */\n        _create: function () {\n            if ($.mage.cookies.get(this.options.cookieName)) {\n                this.element.hide();\n            } else {\n                this.element.show();\n            }\n            $(this.options.cookieAllowButtonSelector).on('click', $.proxy(function () {\n                var cookieExpires = new Date(new Date().getTime() + this.options.cookieLifetime * 1000);\n\n                $.mage.cookies.set(this.options.cookieName, JSON.stringify(this.options.cookieValue), {\n                    expires: cookieExpires\n                });\n\n                if ($.mage.cookies.get(this.options.cookieName)) {\n                    this.element.hide();\n                    $(document).trigger('user:allowed:save:cookie');\n                } else {\n                    window.location.href = this.options.noCookiesUrl;\n                }\n            }, this));\n        }\n    });\n\n    return $.mage.cookieNotices;\n});\n","Magento_GoogleAnalytics/js/google-analytics.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* jscs:disable */\n/* eslint-disable */\ndefine([\n    'jquery',\n    'mage/cookies'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {Object} config\n     */\n    return function (config) {\n        var allowServices = false,\n            allowedCookies,\n            allowedWebsites;\n\n        if (config.isCookieRestrictionModeEnabled) {\n            allowedCookies = $.mage.cookies.get(config.cookieName);\n\n            if (allowedCookies !== null) {\n                allowedWebsites = JSON.parse(allowedCookies);\n\n                if (allowedWebsites[config.currentWebsite] === 1) {\n                    allowServices = true;\n                }\n            }\n        } else {\n            allowServices = true;\n        }\n\n        if (allowServices) {\n            (function (i, s, o, g, r, a, m) {\n                i.GoogleAnalyticsObject = r;\n                i[r] = i[r] || function () {\n                        (i[r].q = i[r].q || []).push(arguments)\n                    }, i[r].l = 1 * new Date();\n                a = s.createElement(o),\n                    m = s.getElementsByTagName(o)[0];\n                a.async = 1;\n                a.src = g;\n                m.parentNode.insertBefore(a, m)\n            })(window, document, 'script', '//www.google-analytics.com/analytics.js', 'ga');\n\n            // Process page info\n            ga('create', config.pageTrackingData.accountId, 'auto');\n\n            if (config.pageTrackingData.isAnonymizedIpActive) {\n                ga('set', 'anonymizeIp', true);\n            }\n\n            // Process orders data\n            if (config.ordersTrackingData.hasOwnProperty('currency')) {\n                ga('require', 'ec', 'ec.js');\n\n                ga('set', 'currencyCode', config.ordersTrackingData.currency);\n\n                // Collect product data for GA\n                if (config.ordersTrackingData.products) {\n                    $.each(config.ordersTrackingData.products, function (index, value) {\n                        ga('ec:addProduct', value);\n                    });\n                }\n\n                // Collect orders data for GA\n                if (config.ordersTrackingData.orders) {\n                    $.each(config.ordersTrackingData.orders, function (index, value) {\n                        ga('ec:setAction', 'purchase', value);\n                    });\n                }\n\n                ga('send', 'pageview');\n            } else {\n                // Process Data if not orders\n                ga('send', 'pageview' + config.pageTrackingData.optPageUrl);\n            }\n        }\n    }\n});\n","Magento_InstantPurchase/js/view/instant-purchase.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data',\n    'mage/url',\n    'mage/template',\n    'mage/translate',\n    'text!Magento_InstantPurchase/template/confirmation.html',\n    'mage/validation'\n], function (ko, $, _, Component, confirm, customerData, urlBuilder, mageTemplate, $t, confirmationTemplate) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_InstantPurchase/instant-purchase',\n            buttonText: $t('Instant Purchase'),\n            purchaseUrl: urlBuilder.build('instantpurchase/button/placeOrder'),\n            showButton: false,\n            paymentToken: null,\n            shippingAddress: null,\n            billingAddress: null,\n            shippingMethod: null,\n            productFormSelector: '#product_addtocart_form',\n            confirmationTitle: $t('Instant Purchase Confirmation'),\n            confirmationData: {\n                message: $t('Are you sure you want to place order and pay?'),\n                shippingAddressTitle: $t('Shipping Address'),\n                billingAddressTitle: $t('Billing Address'),\n                paymentMethodTitle: $t('Payment Method'),\n                shippingMethodTitle: $t('Shipping Method')\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var instantPurchase = customerData.get('instant-purchase');\n\n            this._super();\n\n            this.setPurchaseData(instantPurchase());\n            instantPurchase.subscribe(this.setPurchaseData, this);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('showButton paymentToken shippingAddress billingAddress shippingMethod');\n\n            return this;\n        },\n\n        /**\n         * Set data from customerData.\n         *\n         * @param {Object} data\n         */\n        setPurchaseData: function (data) {\n            this.showButton(data.available);\n            this.paymentToken(data.paymentToken);\n            this.shippingAddress(data.shippingAddress);\n            this.billingAddress(data.billingAddress);\n            this.shippingMethod(data.shippingMethod);\n        },\n\n        /**\n         * Confirmation method\n         */\n        instantPurchase: function () {\n            var form = $(this.productFormSelector),\n                confirmTemplate = mageTemplate(confirmationTemplate),\n                confirmData = _.extend({}, this.confirmationData, {\n                    paymentToken: this.paymentToken().summary,\n                    shippingAddress: this.shippingAddress().summary,\n                    billingAddress: this.billingAddress().summary,\n                    shippingMethod: this.shippingMethod().summary\n                });\n\n            if (!(form.validation() && form.validation('isValid'))) {\n                return;\n            }\n\n            confirm({\n                title: this.confirmationTitle,\n                content: confirmTemplate({\n                    data: confirmData\n                }),\n                actions: {\n                    /** @inheritdoc */\n                    confirm: function () {\n                        $.ajax({\n                            url: this.purchaseUrl,\n                            data: form.serialize(),\n                            type: 'post',\n                            dataType: 'json',\n\n                            /** Show loader before send */\n                            beforeSend: function () {\n                                $('body').trigger('processStart');\n                            }\n                        }).always(function () {\n                            $('body').trigger('processStop');\n                        });\n                    }.bind(this)\n                }\n            });\n        }\n    });\n});\n","Magento_ProductVideo/js/load-player.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n @version 0.0.1\n @requires jQuery & jQuery UI\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'vimeoWrapper'\n], function ($) {\n    'use strict';\n\n    var videoRegister = {\n        _register: {},\n\n        /**\n         * Checks, if api is already registered\n         *\n         * @param {String} api\n         * @returns {bool}\n         */\n        isRegistered: function (api) {\n            return this._register[api] !== undefined;\n        },\n\n        /**\n         * Checks, if api is loaded\n         *\n         * @param {String} api\n         * @returns {bool}\n         */\n        isLoaded: function (api) {\n            return this._register[api] !== undefined && this._register[api] === true;\n        },\n\n        /**\n         * Register new video api\n         * @param {String} api\n         * @param {bool} loaded\n         */\n        register: function (api, loaded) {\n            loaded = loaded || false;\n            this._register[api] = loaded;\n        }\n    };\n\n    $.widget('mage.productVideoLoader', {\n\n        /**\n         * @private\n         */\n        _create: function () {\n            switch (this.element.data('type')) {\n                case 'youtube':\n                    this.element.videoYoutube();\n                    this._player = this.element.data('mageVideoYoutube');\n                    break;\n\n                case 'vimeo':\n                    this.element.videoVimeo();\n                    this._player = this.element.data('mageVideoVimeo');\n                    break;\n                default:\n                    throw {\n                        name: 'Video Error',\n                        message: 'Unknown video type',\n\n                        /**\n                         * join name with message\n                         */\n                        toString: function () {\n                            return this.name + ': ' + this.message;\n                        }\n                    };\n            }\n        },\n\n        /**\n         * Initializes variables\n         * @private\n         */\n        _initialize: function () {\n            this._params = this.element.data('params') || {};\n            this._code = this.element.data('code');\n            this._width = this.element.data('width');\n            this._height = this.element.data('height');\n            this._autoplay = !!this.element.data('autoplay');\n            this._playing = this._autoplay || false;\n            this._loop = this.element.data('loop');\n            this._rel = this.element.data('related');\n            this.useYoutubeNocookie = this.element.data('youtubenocookie') || false;\n\n            this._responsive = this.element.data('responsive') !== false;\n\n            if (this._responsive === true) {\n                this.element.addClass('responsive');\n            }\n\n            this._calculateRatio();\n        },\n\n        /**\n         * Abstract play command\n         */\n        play: function () {\n            this._player.play();\n        },\n\n        /**\n         * Abstract pause command\n         */\n        pause: function () {\n            this._player.pause();\n        },\n\n        /**\n         * Abstract stop command\n         */\n        stop: function () {\n            this._player.stop();\n        },\n\n        /**\n         * Abstract playing command\n         */\n        playing: function () {\n            return this._player.playing();\n        },\n\n        /**\n         * Calculates ratio for responsive videos\n         * @private\n         */\n        _calculateRatio: function () {\n            if (!this._responsive) {\n                return;\n            }\n            this.element.css('paddingBottom', this._height / this._width * 100 + '%');\n        }\n    });\n\n    $.widget('mage.videoYoutube', $.mage.productVideoLoader, {\n\n        /**\n         * Initialization of the Youtube widget\n         * @private\n         */\n        _create: function () {\n            var self = this;\n\n            this._initialize();\n\n            this.element.append('<div></div>');\n\n            this._on(window, {\n\n                /**\n                 * Handle event\n                 */\n                'youtubeapiready': function () {\n                    var host = 'https://www.youtube.com';\n\n                    if (self.useYoutubeNocookie) {\n                        host = 'https://www.youtube-nocookie.com';\n                    }\n\n                    if (self._player !== undefined) {\n                        return;\n                    }\n                    self._autoplay = true;\n\n                    if (self._autoplay) {\n                        self._params.autoplay = 1;\n                    }\n\n                    if (!self._rel) {\n                        self._params.rel = 0;\n                    }\n\n                    self._player = new window.YT.Player(self.element.children(':first')[0], {\n                        height: self._height,\n                        width: self._width,\n                        videoId: self._code,\n                        playerVars: self._params,\n                        host: host,\n                        events: {\n\n                            /**\n                             * Get duration\n                             */\n                            'onReady': function onPlayerReady() {\n                                self._player.getDuration();\n                                self.element.closest('.fotorama__stage__frame')\n                                    .addClass('fotorama__product-video--loaded');\n                            },\n\n                            /**\n                             * Event observer\n                             */\n                            onStateChange: function (data) {\n                                switch (window.parseInt(data.data, 10)) {\n                                    case 1:\n                                        self._playing = true;\n                                        break;\n                                    default:\n                                        self._playing = false;\n                                        break;\n                                }\n\n                                self._trigger('statechange', {}, data);\n\n                                if (data.data === window.YT.PlayerState.ENDED && self._loop) {\n                                    self._player.playVideo();\n                                }\n                            }\n                        }\n\n                    });\n                }\n            });\n\n            this._loadApi();\n        },\n\n        /**\n         * Loads Youtube API and triggers event, when loaded\n         * @private\n         */\n        _loadApi: function () {\n            var element,\n                scriptTag;\n\n            if (videoRegister.isRegistered('youtube')) {\n                if (videoRegister.isLoaded('youtube')) {\n                    $(window).trigger('youtubeapiready');\n                }\n\n                return;\n            }\n\n            // if script already loaded by other library\n            if (window.YT) {\n                videoRegister.register('youtube', true);\n                $(window).trigger('youtubeapiready');\n\n                return;\n            }\n            videoRegister.register('youtube');\n\n            element = document.createElement('script');\n            scriptTag = document.getElementsByTagName('script')[0];\n\n            element.async = true;\n            element.src = 'https://www.youtube.com/iframe_api';\n            scriptTag.parentNode.insertBefore(element, scriptTag);\n\n            /**\n             * Event observe and handle\n             */\n            window.onYouTubeIframeAPIReady = function () {\n                $(window).trigger('youtubeapiready');\n                videoRegister.register('youtube', true);\n            };\n        },\n\n        /**\n         * Play command for Youtube\n         */\n        play: function () {\n            this._player.playVideo();\n            this._playing = true;\n        },\n\n        /**\n         * Pause command for Youtube\n         */\n        pause: function () {\n            this._player.pauseVideo();\n            this._playing = false;\n        },\n\n        /**\n         * Stop command for Youtube\n         */\n        stop: function () {\n            this._player.stopVideo();\n            this._playing = false;\n        },\n\n        /**\n         * Playing command for Youtube\n         */\n        playing: function () {\n            return this._playing;\n        },\n\n        /**\n         * stops and unloads player\n         * @private\n         */\n        _destroy: function () {\n            this.stop();\n        }\n    });\n\n    $.widget('mage.videoVimeo', $.mage.productVideoLoader, {\n\n        /**\n         * Initialize the Vimeo widget\n         * @private\n         */\n        _create: function () {\n            var timestamp,\n                additionalParams = '',\n                src,\n                id;\n\n            this._initialize();\n            timestamp = new Date().getTime();\n            this._autoplay = true;\n\n            if (this._autoplay) {\n                additionalParams += '&autoplay=1';\n            }\n\n            if (this._loop) {\n                additionalParams += '&loop=1';\n            }\n            src = 'https://player.vimeo.com/video/' +\n                this._code + '?api=1&player_id=vimeo' +\n                this._code +\n                timestamp +\n                additionalParams;\n            id = 'vimeo' + this._code + timestamp;\n            this.element.append(\n                $('<iframe></iframe>')\n                    .attr('frameborder', 0)\n                    .attr('id', id)\n                    .attr('width', this._width)\n                    .attr('height', this._height)\n                    .attr('src', src)\n                    .attr('webkitallowfullscreen', '')\n                    .attr('mozallowfullscreen', '')\n                    .attr('allowfullscreen', '')\n                    .attr('referrerPolicy', 'origin')\n                    .attr('allow', 'autoplay')\n            );\n\n            /* eslint-disable no-undef */\n            this._player = new Vimeo.Player(this.element.children(':first')[0]);\n\n            this._player.ready().then(function () {\n                $('#' + id).closest('.fotorama__stage__frame').addClass('fotorama__product-video--loaded');\n            });\n        },\n\n        /**\n         * Play command for Vimeo\n         */\n        play: function () {\n            this._player.play();\n            this._playing = true;\n        },\n\n        /**\n         * Pause command for Vimeo\n         */\n        pause: function () {\n            this._player.pause();\n            this._playing = false;\n        },\n\n        /**\n         * Stop command for Vimeo\n         */\n        stop: function () {\n            this._player.unload();\n            this._playing = false;\n        },\n\n        /**\n         * Playing command for Vimeo\n         */\n        playing: function () {\n            return this._playing;\n        }\n    });\n});\n","Magento_ProductVideo/js/fotorama-add-video-events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'catalogGallery',\n    'loadPlayer'\n], function ($) {\n    'use strict';\n\n    /**\n     * @private\n     */\n    var allowBase = true; //global var is needed because fotorama always fully reloads events in case of fullscreen\n\n    /**\n     * @private\n     */\n    function parseHref(href) {\n        var a = document.createElement('a');\n\n        a.href = href;\n\n        return a;\n    }\n\n    /**\n     * @private\n     */\n    function parseURL(href, forceVideo) {\n        var id,\n            type,\n            ampersandPosition,\n            vimeoRegex,\n            useYoutubeNocookie = false;\n\n        /**\n         * Get youtube ID\n         * @param {String} srcid\n         * @returns {{}}\n         */\n        function _getYoutubeId(srcid) {\n            if (srcid) {\n                ampersandPosition = srcid.indexOf('&');\n\n                if (ampersandPosition === -1) {\n                    return srcid;\n                }\n\n                srcid = srcid.substring(0, ampersandPosition);\n            }\n\n            return srcid;\n        }\n\n        if (typeof href !== 'string') {\n            return href;\n        }\n\n        href = parseHref(href);\n\n        if (href.host.match(/youtube\\.com/) && href.search) {\n            id = href.search.split('v=')[1];\n\n            if (id) {\n                id = _getYoutubeId(id);\n                type = 'youtube';\n            }\n        } else if (href.host.match(/youtube\\.com|youtu\\.be|youtube-nocookie.com/)) {\n            id = href.pathname.replace(/^\\/(embed\\/|v\\/)?/, '').replace(/\\/.*/, '');\n            type = 'youtube';\n\n            if (href.host.match(/youtube-nocookie.com/)) {\n                useYoutubeNocookie = true;\n            }\n        } else if (href.host.match(/vimeo\\.com/)) {\n            type = 'vimeo';\n            vimeoRegex = new RegExp(['https?:\\\\/\\\\/(?:www\\\\.|player\\\\.)?vimeo.com\\\\/(?:channels\\\\/(?:\\\\w+\\\\/)',\n                '?|groups\\\\/([^\\\\/]*)\\\\/videos\\\\/|album\\\\/(\\\\d+)\\\\/video\\\\/|video\\\\/|)(\\\\d+)(?:$|\\\\/|\\\\?)'\n            ].join(''));\n            id = href.href.match(vimeoRegex)[3];\n        }\n\n        if ((!id || !type) && forceVideo) {\n            id = href.href;\n            type = 'custom';\n        }\n\n        return id ? {\n            id: id, type: type, s: href.search.replace(/^\\?/, ''), useYoutubeNocookie: useYoutubeNocookie\n        } : false;\n    }\n\n    //create AddFotoramaVideoEvents widget\n    $.widget('mage.AddFotoramaVideoEvents', {\n        options: {\n            videoData: '',\n            videoSettings: '',\n            optionsVideoData: '',\n            dataMergeStrategy: 'replace'\n        },\n\n        /**\n         * @private\n         */\n        onVimeoJSFramework: function () {},\n        defaultVideoData: [],\n        PV: 'product-video', // [CONST]\n        VU: 'video-unplayed',\n        PVLOADED: 'fotorama__product-video--loaded', // [CONST]\n        PVLOADING: 'fotorama__product-video--loading', // [CONST]\n        VID: 'video', // [CONST]\n        VI: 'vimeo', // [CONST]\n        FTVC: 'fotorama__video-close',\n        FTAR: 'fotorama__arr',\n        fotoramaSpinner: 'fotorama__spinner',\n        fotoramaSpinnerShow: 'fotorama__spinner--show',\n        TI: 'video-thumb-icon',\n        isFullscreen: false,\n        FTCF: '[data-gallery-role=\"fotorama__fullscreen-icon\"]',\n        Base: 0, //on check for video is base this setting become true if there is any video with base role\n        MobileMaxWidth: 768,\n        GP: 'gallery-placeholder', //gallery placeholder class is needed to find and erase <script> tag\n        videoData: null,\n        videoDataPlaceholder: [{\n            id: '',\n            isBase: true,\n            mediaType: 'image',\n            provider: ''\n        }],\n\n        /**\n         * Creates widget\n         * @private\n         */\n        _create: function () {\n            $(this.element).data('gallery') ?\n                this._onGalleryLoaded() :\n                $(this.element).on('gallery:loaded', this._onGalleryLoaded.bind(this));\n        },\n\n        /**\n         *\n         * @private\n         */\n        _initialize: function () {\n            if (!this.defaultVideoData.length) {\n                this.defaultVideoData = this.options.videoData;\n            }\n\n            // If product does not have images, no video data generated,\n            // but for configurable product we still need a video data, in case of 'prepend' gallery strategy.\n            if (!this.defaultVideoData.length && !this.options.videoData.length) {\n                this.defaultVideoData = this.options.videoData = this.videoDataPlaceholder;\n            }\n\n            this.clearEvents();\n\n            if (this._checkForVideoExist()) {\n                this._checkFullscreen();\n                this._listenForFullscreen();\n                this._isVideoBase();\n                this._initFotoramaVideo();\n                this._attachFotoramaEvents();\n            }\n        },\n\n        /**\n         * Callback which fired after gallery gets initialized.\n         */\n        _onGalleryLoaded: function () {\n            this.fotoramaItem = $(this.element).find('.fotorama-item');\n            this._initialize();\n        },\n\n        /**\n         * Clear gallery events to prevent duplicated calls.\n         *\n         * @private\n         */\n        clearEvents: function () {\n            if (this.fotoramaItem !== undefined) {\n                this.fotoramaItem.off(\n                    'fotorama:show.' + this.PV +\n                    ' fotorama:showend.' + this.PV +\n                    ' fotorama:fullscreenenter.' + this.PV +\n                    ' fotorama:fullscreenexit.' + this.PV\n                );\n            }\n        },\n\n        /**\n         *\n         * @param {Object} options\n         * @private\n         */\n        _setOptions: function (options) {\n            if (options.videoData && options.videoData.length) {\n                this.options.videoData = options.videoData;\n            }\n\n            this._loadVideoData(options);\n            this._initialize();\n        },\n\n        /**\n         * Set video data for configurable product.\n         *\n         * @param {Object} options\n         * @private\n         */\n        _loadVideoData: function (options) {\n            if (options.selectedOption) {\n                if (options.dataMergeStrategy === 'prepend') {\n                    this.options.videoData = [].concat(\n                        this.options.optionsVideoData[options.selectedOption],\n                        this.defaultVideoData\n                    );\n                } else {\n                    this.options.videoData = this.options.optionsVideoData[options.selectedOption];\n                }\n            } else {\n                this.options.videoData = this.defaultVideoData;\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _checkFullscreen: function () {\n            if (this.fotoramaItem.data('fotorama').fullScreen || false) {\n                this.isFullscreen = true;\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _listenForFullscreen: function () {\n            this.fotoramaItem.on('fotorama:fullscreenenter.' + this.PV, $.proxy(function () {\n                this.isFullscreen = true;\n            }, this));\n\n            this.fotoramaItem.on('fotorama:fullscreenexit.' + this.PV, $.proxy(function () {\n                this.isFullscreen = false;\n                this._hideVideoArrows();\n            }, this));\n        },\n\n        /**\n         *\n         * @param {Object} inputData\n         * @param {bool} isJSON\n         * @returns {{}}\n         * @private\n         */\n        _createVideoData: function (inputData, isJSON) {\n            var videoData = [],\n                dataUrl,\n                tmpVideoData,\n                tmpInputData,\n                i;\n\n            if (isJSON) {\n                inputData = JSON.parse(inputData);\n            }\n\n            for (i = 0; i < inputData.length; i++) {\n                tmpInputData = inputData[i];\n                dataUrl = '';\n                tmpVideoData = {\n                    mediaType: '',\n                    isBase: '',\n                    id: '',\n                    provider: ''\n                };\n                tmpVideoData.mediaType = this.VID;\n\n                if (tmpInputData.mediaType !== 'external-video') {\n                    tmpVideoData.mediaType = tmpInputData.mediaType;\n                }\n\n                tmpVideoData.isBase = tmpInputData.isBase;\n\n                if (tmpInputData.videoUrl && tmpInputData.videoUrl !== null) {\n                    dataUrl = tmpInputData.videoUrl;\n                    dataUrl = parseURL(dataUrl);\n                    tmpVideoData.id = dataUrl.id;\n                    tmpVideoData.provider = dataUrl.type;\n                    tmpVideoData.videoUrl = tmpInputData.videoUrl;\n                    tmpVideoData.useYoutubeNocookie = dataUrl.useYoutubeNocookie;\n                }\n\n                videoData.push(tmpVideoData);\n            }\n\n            return videoData;\n        },\n\n        /**\n         *\n         * @param {Object} fotorama\n         * @param {bool} isBase\n         * @private\n         */\n        _createCloseVideo: function (fotorama, isBase) {\n            var closeVideo;\n\n            this.fotoramaItem.find('.' + this.FTVC).remove();\n            this.fotoramaItem.append('<div class=\"' + this.FTVC + '\"></div>');\n            this.fotoramaItem.css('position', 'relative');\n            closeVideo = this.fotoramaItem.find('.' + this.FTVC);\n            this._closeVideoSetEvents(closeVideo, fotorama);\n\n            if (\n                isBase &&\n                this.options.videoData[fotorama.activeIndex].isBase &&\n                $(window).width() > this.MobileMaxWidth) {\n                this._showCloseVideo();\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _hideCloseVideo: function () {\n            this.fotoramaItem\n                .find('.' + this.FTVC)\n                .removeClass('fotorama-show-control');\n        },\n\n        /**\n         *\n         * @private\n         */\n        _showCloseVideo: function () {\n            this.fotoramaItem\n                .find('.' + this.FTVC)\n                .addClass('fotorama-show-control');\n        },\n\n        /**\n         *\n         * @param {jQuery} $closeVideo\n         * @param {jQuery} fotorama\n         * @private\n         */\n        _closeVideoSetEvents: function ($closeVideo, fotorama) {\n            $closeVideo.on('click', $.proxy(function () {\n                this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, true);\n                this._hideCloseVideo();\n            }, this));\n        },\n\n        /**\n         *\n         * @returns {Boolean}\n         * @private\n         */\n        _checkForVideoExist: function () {\n            var key, result, checker, videoSettings;\n\n            if (!this.options.videoData) {\n                return false;\n            }\n\n            if (!this.options.videoSettings) {\n                return false;\n            }\n\n            result = this._createVideoData(this.options.videoData, false);\n            checker = false;\n            videoSettings = this.options.videoSettings[0];\n            videoSettings.playIfBase = parseInt(videoSettings.playIfBase, 10);\n            videoSettings.showRelated = parseInt(videoSettings.showRelated, 10);\n            videoSettings.videoAutoRestart = parseInt(videoSettings.videoAutoRestart, 10);\n\n            for (key in result) {\n                if (result[key].mediaType === this.VID) {\n                    checker = true;\n                }\n            }\n\n            if (checker) {\n                this.options.videoData = result;\n            }\n\n            return checker;\n        },\n\n        /**\n         *\n         * @private\n         */\n        _isVideoBase: function () {\n            var allVideoData = this.options.videoData,\n                videoItem,\n                allVideoDataKeys,\n                key,\n                i;\n\n            allVideoDataKeys = Object.keys(allVideoData);\n\n            for (i = 0; i < allVideoDataKeys.length; i++) {\n                key = allVideoDataKeys[i];\n                videoItem = allVideoData[key];\n\n                if (\n                    videoItem.mediaType === this.VID && videoItem.isBase &&\n                    this.options.videoSettings[0].playIfBase && allowBase\n                ) {\n                    this.Base = true;\n                    allowBase = false;\n                }\n            }\n\n            if (!this.isFullscreen) {\n                this._createCloseVideo(this.fotoramaItem.data('fotorama'), this.Base);\n            }\n        },\n\n        /**\n         *\n         * @param {Event} e\n         * @private\n         */\n        _initFotoramaVideo: function (e) {\n            var fotorama = this.fotoramaItem.data('fotorama'),\n                thumbsParent,\n                thumbs,\n                t;\n\n            if (!fotorama.activeFrame.$navThumbFrame) {\n                this.fotoramaItem.on('fotorama:showend.' + this.PV, $.proxy(function (evt, fotoramaData) {\n                    $(fotoramaData.activeFrame.$stageFrame).removeAttr('href');\n                }, this));\n\n                this._startPrepareForPlayer(e, fotorama);\n\n                return null;\n            }\n\n            fotorama.data.map($.proxy(this._setItemType, this));\n            thumbsParent = fotorama.activeFrame.$navThumbFrame.parent();\n            thumbs = thumbsParent.find('.fotorama__nav__frame:visible');\n\n            for (t = 0; t < thumbs.length; t++) {\n                this._setThumbsIcon(thumbs.eq(t), t);\n                this._checkForVideo(e, fotorama, t + 1);\n            }\n\n            this.fotoramaItem.on('fotorama:showend.' + this.PV, $.proxy(function (evt, fotoramaData) {\n                $(fotoramaData.activeFrame.$stageFrame).removeAttr('href');\n            }, this));\n        },\n\n        /**\n         *\n         * @param {Object} elem\n         * @param {Number} i\n         * @private\n         */\n        _setThumbsIcon: function (elem, i) {\n            var fotorama = this.fotoramaItem.data('fotorama');\n\n            if (fotorama.options.nav === 'dots' && elem.hasClass(this.TI)) {\n                elem.removeClass(this.TI);\n            }\n\n            if (this.options.videoData[i].mediaType === this.VID &&\n                fotorama.data[i].type ===  this.VID &&\n                fotorama.options.nav === 'thumbs') {\n                elem.addClass(this.TI);\n            }\n        },\n\n        /**\n         * Temporary solution with adding types for configurable product items\n         *\n         * @param {Object} item\n         * @param {Number} i\n         * @private\n         */\n        _setItemType: function (item, i) {\n            !item.type && (item.type = this.options.videoData[i].mediaType);\n        },\n\n        /**\n         * Attach\n         *\n         * @private\n         */\n        _attachFotoramaEvents: function () {\n            this.fotoramaItem.on('fotorama:showend.' + this.PV, $.proxy(function (e, fotorama) {\n                this._startPrepareForPlayer(e, fotorama);\n            }, this));\n\n            this.fotoramaItem.on('fotorama:show.' + this.PV, $.proxy(function (e, fotorama) {\n                this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, true);\n            }, this));\n\n            this.fotoramaItem.on('fotorama:fullscreenexit.' + this.PV, $.proxy(function (e, fotorama) {\n                fotorama.activeFrame.$stageFrame.find('.' + this.PV).remove();\n                this._startPrepareForPlayer(e, fotorama);\n            }, this));\n        },\n\n        /**\n         * Start prepare for player\n         *\n         * @param {Event} e\n         * @param {jQuery} fotorama\n         * @private\n         */\n        _startPrepareForPlayer: function (e, fotorama) {\n            this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, false);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i - 1);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i + 1);\n        },\n\n        /**\n         * Check for video\n         *\n         * @param {Event} e\n         * @param {jQuery} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _checkForVideo: function (e, fotorama, number) {\n            var videoData = this.options.videoData[number - 1],\n                $image = fotorama.data[number - 1];\n\n            if ($image) {\n                !$image.type && this._setItemType($image, number - 1);\n\n                if ($image.type === 'image') {\n                    $image.$navThumbFrame && $image.$navThumbFrame.removeClass(this.TI);\n                    this._hideCloseVideo();\n\n                    return;\n                } else if ($image.$navThumbFrame && $image.type === 'video') {\n                    !$image.$navThumbFrame.hasClass(this.TI) && $image.$navThumbFrame.addClass(this.TI);\n                }\n\n                $image = $image.$stageFrame;\n            }\n\n            if ($image && videoData && videoData.mediaType === this.VID) {\n                $(fotorama.activeFrame.$stageFrame).removeAttr('href');\n                this._prepareForVideoContainer($image, videoData, fotorama, number);\n            }\n\n            if (this.isFullscreen && this.fotoramaItem.data('fotorama').activeFrame.i === number) {\n                this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].trigger('click');\n            }\n        },\n\n        /**\n         * Prepare for video container\n         *\n         * @param {jQuery} $image\n         * @param {Object} videoData\n         * @param {Object} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _prepareForVideoContainer: function ($image, videoData, fotorama, number) {\n            $image.addClass('fotorama-video-container').addClass(this.VU);\n            this._createVideoContainer(videoData, $image);\n            this._setVideoEvent($image, this.PV, fotorama, number);\n        },\n\n        /**\n         * Create video container\n         *\n         * @param {Object} videoData\n         * @param {jQuery} $image\n         * @private\n         */\n        _createVideoContainer: function (videoData, $image) {\n            var videoSettings;\n\n            videoSettings = this.options.videoSettings[0];\n            $image.find('.' + this.PV).remove();\n            $image.append(\n                '<div class=\"' +\n                this.PV +\n                '\" data-related=\"' +\n                videoSettings.showRelated +\n                '\" data-loop=\"' +\n                videoSettings.videoAutoRestart +\n                '\" data-type=\"' +\n                videoData.provider +\n                '\" data-code=\"' +\n                videoData.id +\n                '\"  data-youtubenocookie=\"' +\n                videoData.useYoutubeNocookie +\n                '\" data-width=\"100%\" data-height=\"100%\"></div>'\n            );\n        },\n\n        /**\n         *\n         * @param {Object} $image\n         * @param {Object} PV\n         * @param {Object} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _setVideoEvent: function ($image, PV, fotorama, number) {\n            $image.find('.magnify-lens').remove();\n            $image\n                .off('click tap', $.proxy(this._clickHandler, this))\n                .on('click tap', $.proxy(this._clickHandler, this));\n            this._handleBaseVideo(fotorama, number); //check for video is it base and handle it if it's base\n        },\n\n        /**\n         * Hides preview arrows above video player.\n         * @private\n         */\n        _hideVideoArrows: function () {\n            var arrows = $('.' + this.FTAR);\n\n            arrows.removeClass('fotorama__arr--shown');\n            arrows.removeClass('fotorama__arr--hidden');\n        },\n\n        /**\n         * @private\n         */\n        _showLoader: function () {\n            var spinner = this.fotoramaItem.find('.' + this.fotoramaSpinner);\n\n            spinner.addClass(this.fotoramaSpinnerShow);\n            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame.addClass(this.PVLOADING);\n        },\n\n        /**\n         * @private\n         */\n        _hideLoader: function () {\n            var spinner = this.fotoramaItem.find('.' + this.fotoramaSpinner);\n\n            spinner.removeClass(this.fotoramaSpinnerShow);\n            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame.removeClass(this.PVLOADING);\n        },\n\n        /**\n         * @param {Event} event\n         * @private\n         */\n        _clickHandler: function (event) {\n            var type;\n\n            if ($(event.target).hasClass(this.VU) && $(event.target).find('iframe').length === 0) {\n                $(event.target).removeClass(this.VU);\n                type = $(event.target).find('.' + this.PV).data('type');\n\n                if (type === this.VI) {\n                    $(event.target).find('.' + this.PV).productVideoLoader();\n                } else if (type === this.VI) {\n                    this._showLoader();\n                    this.onVimeoJSFramework = function () {\n                        $(event.target).find('.' + this.PV).productVideoLoader();\n                        this._hideLoader();\n                    }.bind(this);\n                } else {\n                    $(event.target).find('.' + this.PV).productVideoLoader();\n                }\n\n                $('.' + this.FTAR).addClass(this.isFullscreen ? 'fotorama__arr--shown' : 'fotorama__arr--hidden');\n                $('.' + this.FTVC).addClass('fotorama-show-control');\n            }\n        },\n\n        /**\n         * Handle base video\n         * @param {Object} fotorama\n         * @param {Number} srcNumber\n         * @private\n         */\n        _handleBaseVideo: function (fotorama, srcNumber) {\n            var videoData = this.options.videoData,\n                activeIndex = fotorama.activeIndex,\n                number = parseInt(srcNumber, 10),\n                activeIndexIsBase = videoData[activeIndex];\n\n            if (!this.Base) {\n                return;\n            }\n\n            if (activeIndexIsBase && number === 1 && $(window).width() > this.MobileMaxWidth) {\n                setTimeout($.proxy(function () {\n                    fotorama.requestFullScreen();\n                    this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].trigger('click');\n                    this.Base = false;\n                }, this), 50);\n            }\n        },\n\n        /**\n         * Destroy video player\n         * @param {jQuery} $wrapper\n         * @param {jQuery} current\n         * @param {bool} close\n         * @private\n         */\n        _unloadVideoPlayer: function ($wrapper, current, close) {\n            var self = this;\n\n            if (!$wrapper) {\n                return;\n            }\n\n            $wrapper.find('.' + this.PVLOADED).removeClass(this.PVLOADED);\n            this._hideLoader();\n\n            $wrapper.find('.' + this.PV).each(function () {\n                var $item = $(this).parent(),\n                    cloneVideoDiv,\n                    iframeElement = $(this).find('iframe'),\n                    currentIndex,\n                    itemIndex;\n\n                if (iframeElement.length === 0) {\n                    return;\n                }\n\n                currentIndex = current.activeFrame.$stageFrame.index();\n                itemIndex = $item.index();\n\n                if (currentIndex === itemIndex && !close) {\n                    return;\n                }\n\n                if (currentIndex !== itemIndex && close) {\n                    return;\n                }\n\n                iframeElement.remove();\n                cloneVideoDiv = $(this).clone();\n                $(this).remove();\n                $item.append(cloneVideoDiv);\n                $item.addClass(self.VU);\n\n                self._hideCloseVideo();\n                self._hideVideoArrows();\n\n                if (self.isFullscreen && !self.fotoramaItem.data('fotorama').options.fullscreen.arrows) {\n                    if ($('.' + self.FTAR + '--prev').is(':focus') || $('.' + self.FTAR + '--next').is(':focus')) {\n                        $(self.FTCF).trigger('focus');\n                    }\n                }\n            });\n        }\n    });\n\n    return $.mage.AddFotoramaVideoEvents;\n});\n","Magento_Theme/js/theme.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/smart-keyboard-handler',\n    'mage/mage',\n    'mage/ie-class-fixer',\n    'domReady!'\n], function ($, keyboardHandler) {\n    'use strict';\n\n    $('.cart-summary').mage('sticky', {\n        container: '#maincontent'\n    });\n\n    $('.panel.header > .header.links').clone().appendTo('#store\\\\.links');\n    $('#store\\\\.links li a').each(function () {\n        var id = $(this).attr('id');\n\n        if (id !== undefined) {\n            $(this).attr('id', id + '_mobile');\n        }\n    });\n\n    keyboardHandler.apply();\n});\n","Magento_Theme/js/row-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * JQuery UI Widget declaration: 'mage.rowBuilder'\n *\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery-ui-modules/widget'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.rowBuilder', {\n\n        /**\n         * options with default values for setting up the template\n         */\n        options: {\n            //Default template options\n            rowTemplate: '#template-registrant',\n            rowContainer: '#registrant-container',\n            //Row index used by the template rows.\n            rowIndex: 0,\n            //Row count: Should not be set externally\n            rowCount: 0,\n            rowParentElem: '<li></li>',\n            rowContainerClass: 'fields',\n            addRowBtn: '#add-registrant-button',\n            btnRemoveIdPrefix: 'btn-remove',\n            btnRemoveSelector: '.btn-remove',\n            rowIdPrefix: 'row',\n            //This class is added to rows added after the first one. Adds the dotted separator\n            additionalRowClass: 'add-row',\n\n            /*\n             This is provided during widget instantiation. eg :\n             formDataPost : {\"formData\":formData,\"templateFields\":['field1-name','field2-name'] }\n             -\"formData\" is the multi-dimensional array of form field values : [['a','b'],['c','b']]\n             received from the server and encoded\n             -\"templateFields\" are the input fields in the template with index suffixed after the field name\n             eg field1-name{index}\n             */\n            formDataPost: null,\n            //Default selectors for add element of a template\n            addEventSelector: 'button',\n            //Default selectors for remove markup elements of a template\n            remEventSelector: 'a',\n            //This option allows adding first row delete option and a row separator\n            hideFirstRowAddSeparator: true,\n            //Max rows - This option should be set when instantiating the widget\n            maxRows: 1000,\n            maxRowsMsg: '#max-registrant-message'\n        },\n\n        /**\n         * Initialize create\n         * @private\n         */\n        _create: function () {\n            this.rowTemplate = mageTemplate(this.options.rowTemplate);\n\n            this.options.rowCount = this.options.rowIndex = 0;\n\n            //On document ready related tasks\n            $($.proxy(this.ready, this));\n\n            //Binding template-wide events handlers for adding and removing rows\n            this.element.on(\n                'click',\n                this.options.addEventSelector + this.options.addRowBtn,\n                $.proxy(this.handleAdd, this)\n            );\n            this.element.on(\n                'click',\n                this.options.remEventSelector + this.options.btnRemoveSelector,\n                $.proxy(this.handleRemove, this)\n            );\n        },\n\n        /**\n         * Initialize template\n         * @public\n         */\n        ready: function () {\n            if (this.options.formDataPost &&\n                this.options.formDataPost.formData &&\n                this.options.formDataPost.formData.length\n            ) {\n                this.processFormDataArr(this.options.formDataPost);\n            } else if (this.options.rowIndex === 0 && this.options.maxRows !== 0) {\n                //If no form data , then add default row\n                this.addRow(0);\n            }\n        },\n\n        /**\n         * Process and loop through all row data to create preselected values. This is used for any error on submit.\n         * For complex implementations the inheriting widget can override this behavior\n         * @public\n         * @param {Object} formDataArr\n         */\n        processFormDataArr: function (formDataArr) {\n            var formData = formDataArr.formData,\n                templateFields = formDataArr.templateFields,\n                formRow,\n                i, j;\n\n            for (i = this.options.rowIndex = 0; i < formData.length; this.options.rowIndex = i++) {\n                this.addRow(i);\n\n                formRow = formData[i];\n\n                for (j = 0; j < formRow.length; j++) {\n                    this.setFieldById(templateFields[j] + i, formRow[j]);\n                }\n            }\n\n        },\n\n        /**\n         * Initialize and create markup for template row. Add it to the parent container.\n         * The template processing will substitute row index at all places marked with _index_ in the template\n         * using the template\n         * @public\n         * @param {Number} index - current index/count of the created template. This will be used as the id\n         * @return {*}\n         */\n        addRow: function (index) {\n            var row = $(this.options.rowParentElem),\n                tmpl;\n\n            row.addClass(this.options.rowContainerClass).attr('id', this.options.rowIdPrefix + index);\n\n            tmpl = this.rowTemplate({\n                data: {\n                    _index_: index\n                }\n            });\n\n            $(tmpl).appendTo(row);\n\n            $(this.options.rowContainer).append(row).trigger('contentUpdated');\n\n            row.addClass(this.options.additionalRowClass);\n\n            //Remove 'delete' link and additionalRowClass for first row\n            if (this.options.rowIndex === 0 && this.options.hideFirstRowAddSeparator) {\n                $('#' + this._esc(this.options.btnRemoveIdPrefix) + '0').remove();\n                $('#' + this._esc(this.options.rowIdPrefix) + '0').removeClass(this.options.additionalRowClass);\n            }\n\n            this.maxRowCheck(++this.options.rowCount);\n\n            return row;\n        },\n\n        /**\n         * Remove return item information row\n         * @public\n         * @param {*} rowIndex - return item information row index\n         * @return {Boolean}\n         */\n        removeRow: function (rowIndex) {\n            $('#' + this._esc(this.options.rowIdPrefix) + rowIndex).remove();\n            this.maxRowCheck(--this.options.rowCount);\n\n            return false;\n        },\n\n        /**\n         * Function to check if maximum rows are exceeded and render/hide maxMsg and Add btn\n         * @public\n         * @param {Number} rowIndex\n         */\n        maxRowCheck: function (rowIndex) {\n            var addRowBtn = $(this.options.addRowBtn),\n                maxRowMsg = $(this.options.maxRowsMsg);\n\n            //liIndex starts from 0\n            if (rowIndex >= this.options.maxRows) {\n                addRowBtn.hide();\n                maxRowMsg.show();\n            } else if (addRowBtn.is(':hidden')) {\n                addRowBtn.show();\n                maxRowMsg.hide();\n            }\n        },\n\n        /**\n         * Set the value on given element\n         * @public\n         * @param {String} domId\n         * @param {String} value\n         */\n        setFieldById: function (domId, value) {\n            var x = $('#' + this._esc(domId));\n\n            if (x.length) {\n\n                if (x.is(':checkbox')) {\n                    x.attr('checked', true);\n                } else if (x.is('option')) {\n                    x.attr('selected', 'selected');\n                } else {\n                    x.val(value);\n                }\n            }\n        },\n\n        /**\n         * Delegated handler for adding a row\n         * @public\n         * @return {Boolean}\n         */\n        handleAdd: function () {\n            this.addRow(++this.options.rowIndex);\n\n            return false;\n        },\n\n        /**\n         * Delegated handler for removing a selected row\n         * @public\n         * @param {Object} e - Native event object\n         * @return {Boolean}\n         */\n        handleRemove: function (e) {\n            this.removeRow($(e.currentTarget).closest('[id^=\"' + this.options.btnRemoveIdPrefix + '\"]')\n                .attr('id').replace(this.options.btnRemoveIdPrefix, ''));\n\n            return false;\n        },\n\n        /**\n         * Utility function to add escape chars for jquery selector strings\n         * @private\n         * @param {String} str - String to be processed\n         * @return {String}\n         */\n        _esc: function (str) {\n            return str ? str.replace(/([ ;&,.+*~\\':\"!\\^$\\[\\]()=>|\\/@])/g, '\\\\$1') : str;\n        }\n    });\n\n    return $.mage.rowBuilder;\n});\n","Magento_Theme/js/cookie-status.js":"define([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, modal) {\n    'use strict';\n\n    $.widget('mage.cookieStatus', {\n        options: {\n            type: 'popup',\n            responsive: true,\n            innerScroll: true,\n            autoOpen: true,\n            buttons: [{\n                text: $.mage.__('Close'),\n                class: 'cookie-status',\n\n                /**\n                 * Callback for click event\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }]\n        },\n\n        /**\n         * Init object\n         * @private\n         */\n        _init: function () {\n\n            if (!navigator.cookieEnabled) {\n                modal(this.options, $('#cookie-status'));\n            }\n        }\n    });\n\n    return $.mage.cookieStatus;\n});\n","Magento_Theme/js/model/breadcrumb-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return [];\n});\n","Magento_Theme/js/view/breadcrumbs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Theme/js/model/breadcrumb-list',\n    'text!Magento_Theme/templates/breadcrumbs.html',\n    'jquery-ui-modules/widget'\n], function ($, mageTemplate, breadcrumbList, tpl) {\n    'use strict';\n\n    /**\n     * Breadcrumb Widget.\n     */\n    $.widget('mage.breadcrumbs', {\n\n        /** @inheritdoc */\n        _init: function () {\n            this._super();\n            this._render();\n        },\n\n        /**\n         * Render breadcrumb.\n         *\n         * @private\n         */\n        _render: function () {\n            var html,\n                crumbs = breadcrumbList,\n                template = mageTemplate(tpl);\n\n            this._decorate(crumbs);\n\n            html = template({\n                'breadcrumbs': crumbs\n            });\n\n            if (html.length) {\n                $(this.element).html(html);\n            }\n        },\n\n        /**\n         * Decorate list.\n         *\n         * @param {Array} list\n         * @private\n         */\n        _decorate: function (list) {\n\n            if (list.length) {\n                list[0].first = true;\n            }\n\n            if (list.length > 1) {\n                list[list.length - 1].last = true;\n            }\n        }\n    });\n\n    return $.mage.breadcrumbs;\n});\n","Magento_Theme/js/view/add-home-breadcrumb.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* eslint-disable max-nested-callbacks, no-undef */\ndefine([\n    'jquery',\n    'Magento_Theme/js/model/breadcrumb-list',\n    'mage/translate'\n], function ($, breadcrumbList) {\n    'use strict';\n\n    /**\n     * @return {Object}\n     */\n    var homeCrumb = function () {\n        return {\n            name: 'home',\n            label: $.mage.__('Home'),\n            title: $.mage.__('Go to Home Page'),\n            link: BASE_URL || ''\n        };\n    };\n\n    return function (breadcrumb) {\n\n        breadcrumbList.unshift(homeCrumb());\n\n        return breadcrumb;\n    };\n});\n","Magento_Theme/js/view/messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'underscore',\n    'escaper',\n    'jquery/jquery-storageapi'\n], function ($, Component, customerData, _, escaper) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            cookieMessages: [],\n            messages: [],\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Extends Component object by storage observable messages.\n         */\n        initialize: function () {\n            this._super();\n\n            this.cookieMessages = _.unique($.cookieStorage.get('mage-messages'), 'text');\n            this.messages = customerData.get('messages').extend({\n                disposableCustomerData: 'messages'\n            });\n\n            // Force to clean obsolete messages\n            if (!_.isEmpty(this.messages().messages)) {\n                customerData.set('messages', {});\n            }\n\n            $.mage.cookies.set('mage-messages', '', {\n                samesite: 'strict',\n                domain: ''\n            });\n        },\n\n        /**\n         * Prepare the given message to be rendered as HTML\n         *\n         * @param {String} message\n         * @return {String}\n         */\n        prepareMessageForHtml: function (message) {\n            return escaper.escapeHtml(message, this.allowedTags);\n        }\n    });\n});\n","Magento_Translation/js/mage-translation-dictionary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'text!js-translation.json'\n], function (dict) {\n    'use strict';\n\n    return JSON.parse(dict);\n});\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function () {\n    'use strict';\n\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_Translation/js/add-class.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).addClass(config.class);\n    };\n});\n","MageBig_Ajaxcompare/js/ajax-compare.js":"define([\n    'jquery',\n    'mage/translate',\n    'mage/validation/validation',\n    'magnificpopup'\n], function ($) {\n    'use strict';\n\n    $.widget('magebig.ajaxCompare', {\n\n        options: {\n            enabled: null,\n            ajaxCompareUrl: null,\n            compareBtnSelector: '.action.tocompare'\n        },\n\n        _create: function () {\n            if (this.options.enabled == true) {\n                this.initEvents();\n            }\n        },\n\n        initEvents: function () {\n            var self = this;\n            $('body').on('click', this.options.compareBtnSelector, function (e) {\n                e.preventDefault();\n                e.stopPropagation();\n                var params = $(this).data('post').data;\n                self.addCompare(params);\n            });\n        },\n\n        addCompare: function (params) {\n            var self = this;\n            $.ajax({\n                url: self.options.ajaxCompareUrl,\n                data: params,\n                type: 'POST',\n                dataType: 'json',\n                beforeSend: function () {\n                    $('body').trigger('processStart');\n                },\n                success: function (res) {\n                    $('body').trigger('processStop');\n                    if (res.html_popup) {\n                        $.magnificPopup.open({\n                            items: {\n                                src: res.html_popup,\n                                type: 'inline'\n                            },\n                            overflowY: 'auto',\n                            removalDelay: 300,\n                            mainClass: 'mfp-zoom-in',\n                            callbacks: {\n                                open: function() {\n                                    if( this.fixedContentPos ) {\n                                        if(this._hasScrollBar(this.wH)){\n                                            var s = this._getScrollbarSize();\n                                            if(s) {\n                                                $('.sticky-menu.active').css('padding-right', s);\n                                                $('#go-top').css('margin-right', s);\n                                            }\n                                        }\n                                    }\n                                },\n                                close: function() {\n                                    $('.sticky-menu.active').css('padding-right', '');\n                                    $('#go-top').css('margin-right', '');\n                                }\n                            }\n                        });\n                    } else {\n                        $('body').trigger('processStop');\n                        alert('No response from server');\n                    }\n                },\n                error: function (res) {\n                    $('body').trigger('processStop');\n                    alert('Error in sending ajax request');\n                }\n            });\n        }\n    });\n\n    return $.magebig.ajaxCompare;\n});","Magento_Downloadable/js/downloadable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'Magento_Catalog/js/price-box'\n], function ($) {\n    'use strict';\n\n    /**\n     * Downloadable widget\n     */\n    $.widget('mage.downloadable', {\n        options: {\n            priceHolderSelector: '.price-box',\n            linkElement: '',\n            allElements: ''\n        },\n\n        /**\n         * @inheritdoc\n         */\n        _init: function initLinks() {\n            var element = this.element,\n                options = $(this.options.linkElement, element);\n\n            options.trigger('change');\n        },\n\n        /**\n         *  @inheritdoc\n         */\n        _create: function () {\n            var self = this;\n\n            this.element.find(this.options.linkElement).on('change', $.proxy(function () {\n                this._reloadPrice();\n            }, this));\n\n            this.element.find(this.options.allElements).on('change', function () {\n                if (this.checked) {\n                    $('label[for=\"' + this.id + '\"] > span').text($(this).attr('data-checked'));\n                    self.element.find(self.options.linkElement + ':not(:checked)').each(function () {\n                        $(this).trigger('click');\n                    });\n                } else {\n                    $('[for=\"' + this.id + '\"] > span').text($(this).attr('data-notchecked'));\n                    self.element.find(self.options.linkElement + ':checked').each(function () {\n                        $(this).trigger('click');\n                    });\n                }\n            });\n\n            this._reloadPrice();\n        },\n\n        /**\n         * Reload product price with selected link price included\n         * @private\n         */\n        _reloadPrice: function () {\n            var finalPrice = 0,\n                basePrice = 0;\n\n            this.element.find(this.options.linkElement + ':checked').each($.proxy(function (index, element) {\n                finalPrice += this.options.config.links[$(element).val()].finalPrice;\n                basePrice += this.options.config.links[$(element).val()].basePrice;\n            }, this));\n\n            $(this.options.priceHolderSelector).trigger('updatePrice', {\n                'prices': {\n                    'finalPrice': {\n                        'amount': finalPrice\n                    },\n                    'basePrice': {\n                        'amount': basePrice\n                    }\n                }\n            });\n\n            this.reloadAllCheckText();\n        },\n\n        /**\n         * Reload all-elements-checkbox's label\n         * @private\n         */\n        reloadAllCheckText: function () {\n            var allChecked = true,\n                allElementsCheck = $(this.options.allElements),\n                allElementsLabel = $('label[for=\"' + allElementsCheck.attr('id') + '\"] > span');\n\n            $(this.options.linkElement).each(function () {\n                if (!this.checked) {\n                    allChecked = false;\n                }\n            });\n\n            if (allChecked) {\n                allElementsLabel.text(allElementsCheck.attr('data-checked'));\n                allElementsCheck.prop('checked', true);\n            } else {\n                allElementsLabel.text(allElementsCheck.attr('data-notchecked'));\n                allElementsCheck.prop('checked', false);\n            }\n        }\n    });\n\n    return $.mage.downloadable;\n});\n","Magento_Ups/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'postcode': {\n                    'required': true\n                },\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_Ups/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    'Magento_Ups/js/model/shipping-rates-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Ups/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    'Magento_Ups/js/model/shipping-rates-validator',\n    'Magento_Ups/js/model/shipping-rates-validation-rules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    upsShippingRatesValidator,\n    upsShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('ups', upsShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('ups', upsShippingRatesValidationRules);\n\n    return Component;\n});\n","MageBig_WidgetPlus/js/parallax.js":"/*!\n * parallax.js v1.5.0 (http://pixelcog.github.io/parallax.js/)\n * @copyright 2016 PixelCog, Inc.\n * @license MIT (https://github.com/pixelcog/parallax.js/blob/master/LICENSE)\n */\n\n;(function ( $, window, document, undefined ) {\n\n    // Polyfill for requestAnimationFrame\n    // via: https://gist.github.com/paulirish/1579671\n\n    (function() {\n        var lastTime = 0;\n        var vendors = ['ms', 'moz', 'webkit', 'o'];\n        for(var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {\n            window.requestAnimationFrame = window[vendors[x]+'RequestAnimationFrame'];\n            window.cancelAnimationFrame = window[vendors[x]+'CancelAnimationFrame'] || window[vendors[x]+'CancelRequestAnimationFrame'];\n        }\n\n        if (!window.requestAnimationFrame)\n            window.requestAnimationFrame = function(callback) {\n                var currTime = new Date().getTime();\n                var timeToCall = Math.max(0, 16 - (currTime - lastTime));\n                var id = window.setTimeout(function() { callback(currTime + timeToCall); },\n                    timeToCall);\n                lastTime = currTime + timeToCall;\n                return id;\n            };\n\n        if (!window.cancelAnimationFrame)\n            window.cancelAnimationFrame = function(id) {\n                clearTimeout(id);\n            };\n    }());\n\n\n    // Parallax Constructor\n\n    function Parallax(element, options) {\n        var self = this;\n\n        if (typeof options == 'object') {\n            delete options.refresh;\n            delete options.render;\n            $.extend(this, options);\n        }\n\n        this.$element = $(element);\n\n        if (!this.imageSrc && this.$element.is('img')) {\n            this.imageSrc = this.$element.attr('src');\n        }\n\n        var positions = (this.position + '').toLowerCase().match(/\\S+/g) || [];\n\n        if (positions.length < 1) {\n            positions.push('center');\n        }\n        if (positions.length == 1) {\n            positions.push(positions[0]);\n        }\n\n        if (positions[0] == 'top' || positions[0] == 'bottom' || positions[1] == 'left' || positions[1] == 'right') {\n            positions = [positions[1], positions[0]];\n        }\n\n        if (this.positionX !== undefined) positions[0] = this.positionX.toLowerCase();\n        if (this.positionY !== undefined) positions[1] = this.positionY.toLowerCase();\n\n        self.positionX = positions[0];\n        self.positionY = positions[1];\n\n        if (this.positionX != 'left' && this.positionX != 'right') {\n            if (isNaN(parseInt(this.positionX))) {\n                this.positionX = 'center';\n            } else {\n                this.positionX = parseInt(this.positionX);\n            }\n        }\n\n        if (this.positionY != 'top' && this.positionY != 'bottom') {\n            if (isNaN(parseInt(this.positionY))) {\n                this.positionY = 'center';\n            } else {\n                this.positionY = parseInt(this.positionY);\n            }\n        }\n\n        this.position =\n            this.positionX + (isNaN(this.positionX)? '' : 'px') + ' ' +\n            this.positionY + (isNaN(this.positionY)? '' : 'px');\n\n        if (navigator.userAgent.match(/(iPod|iPhone|iPad)/)) {\n            if (this.imageSrc && this.iosFix && !this.$element.is('img')) {\n                this.$element.css({\n                    backgroundImage: 'url(\"' + this.imageSrc + '\")',\n                    backgroundSize: 'cover',\n                    backgroundPosition: this.position\n                });\n            }\n            return this;\n        }\n\n        if (navigator.userAgent.match(/(Android)/)) {\n            if (this.imageSrc && this.androidFix && !this.$element.is('img')) {\n                this.$element.css({\n                    backgroundImage: 'url(\"' + this.imageSrc + '\")',\n                    backgroundSize: 'cover',\n                    backgroundPosition: this.position\n                });\n            }\n            return this;\n        }\n\n        this.$mirror = $('<div />').prependTo(this.mirrorContainer);\n\n        var slider = this.$element.find('>.parallax-slider');\n        var sliderExisted = false;\n\n        if (slider.length == 0)\n            this.$slider = $('<img />').prependTo(this.$mirror);\n        else {\n            this.$slider = slider.prependTo(this.$mirror)\n            sliderExisted = true;\n        }\n\n        this.$mirror.addClass('parallax-mirror').css({\n            visibility: 'hidden',\n            zIndex: this.zIndex,\n            position: 'fixed',\n            top: 0,\n            left: 0,\n            overflow: 'hidden'\n        });\n\n        this.$slider.addClass('parallax-slider').one('load', function() {\n            if (!self.naturalHeight || !self.naturalWidth) {\n                self.naturalHeight = this.naturalHeight || this.height || 1;\n                self.naturalWidth  = this.naturalWidth  || this.width  || 1;\n            }\n            self.aspectRatio = self.naturalWidth / self.naturalHeight;\n\n            Parallax.isSetup || Parallax.setup();\n            Parallax.sliders.push(self);\n            Parallax.isFresh = false;\n            Parallax.requestRender();\n        });\n\n        if (!sliderExisted)\n            this.$slider[0].src = this.imageSrc;\n\n        if (this.naturalHeight && this.naturalWidth || this.$slider[0].complete || slider.length > 0) {\n            this.$slider.trigger('load');\n        }\n\n    }\n\n\n    // Parallax Instance Methods\n\n    $.extend(Parallax.prototype, {\n        speed:    0.2,\n        bleed:    0,\n        zIndex:   -100,\n        iosFix:   true,\n        androidFix: true,\n        position: 'center',\n        overScrollFix: false,\n        mirrorContainer: 'body',\n\n        refresh: function() {\n            this.boxWidth        = this.$element.outerWidth();\n            this.boxHeight       = this.$element.outerHeight() + this.bleed * 2;\n            this.boxOffsetTop    = this.$element.offset().top - this.bleed;\n            this.boxOffsetLeft   = this.$element.offset().left;\n            this.boxOffsetBottom = this.boxOffsetTop + this.boxHeight;\n\n            var winHeight = Parallax.winHeight;\n            var docHeight = Parallax.docHeight;\n            var maxOffset = Math.min(this.boxOffsetTop, docHeight - winHeight);\n            var minOffset = Math.max(this.boxOffsetTop + this.boxHeight - winHeight, 0);\n            var imageHeightMin = this.boxHeight + (maxOffset - minOffset) * (1 - this.speed) | 0;\n            var imageOffsetMin = (this.boxOffsetTop - maxOffset) * (1 - this.speed) | 0;\n            var margin;\n\n            if (imageHeightMin * this.aspectRatio >= this.boxWidth) {\n                this.imageWidth    = imageHeightMin * this.aspectRatio | 0;\n                this.imageHeight   = imageHeightMin;\n                this.offsetBaseTop = imageOffsetMin;\n\n                margin = this.imageWidth - this.boxWidth;\n\n                if (this.positionX == 'left') {\n                    this.offsetLeft = 0;\n                } else if (this.positionX == 'right') {\n                    this.offsetLeft = - margin;\n                } else if (!isNaN(this.positionX)) {\n                    this.offsetLeft = Math.max(this.positionX, - margin);\n                } else {\n                    this.offsetLeft = - margin / 2 | 0;\n                }\n            } else {\n                this.imageWidth    = this.boxWidth;\n                this.imageHeight   = this.boxWidth / this.aspectRatio | 0;\n                this.offsetLeft    = 0;\n\n                margin = this.imageHeight - imageHeightMin;\n\n                if (this.positionY == 'top') {\n                    this.offsetBaseTop = imageOffsetMin;\n                } else if (this.positionY == 'bottom') {\n                    this.offsetBaseTop = imageOffsetMin - margin;\n                } else if (!isNaN(this.positionY)) {\n                    this.offsetBaseTop = imageOffsetMin + Math.max(this.positionY, - margin);\n                } else {\n                    this.offsetBaseTop = imageOffsetMin - margin / 2 | 0;\n                }\n            }\n        },\n\n        render: function() {\n            var scrollTop    = Parallax.scrollTop;\n            var scrollLeft   = Parallax.scrollLeft;\n            var overScroll   = this.overScrollFix ? Parallax.overScroll : 0;\n            var scrollBottom = scrollTop + Parallax.winHeight;\n\n            if (this.boxOffsetBottom > scrollTop && this.boxOffsetTop <= scrollBottom) {\n                this.visibility = 'visible';\n                this.mirrorTop = this.boxOffsetTop  - scrollTop;\n                this.mirrorLeft = this.boxOffsetLeft - scrollLeft;\n                this.offsetTop = this.offsetBaseTop - this.mirrorTop * (1 - this.speed);\n            } else {\n                this.visibility = 'hidden';\n            }\n\n            this.$mirror.css({\n                transform: 'translate3d('+this.mirrorLeft+'px, '+(this.mirrorTop - overScroll)+'px, 0px)',\n                visibility: this.visibility,\n                height: this.boxHeight,\n                width: this.boxWidth\n            });\n\n            this.$slider.css({\n                transform: 'translate3d('+this.offsetLeft+'px, '+this.offsetTop+'px, 0px)',\n                position: 'absolute',\n                height: this.imageHeight,\n                width: this.imageWidth,\n                maxWidth: 'none'\n            });\n        }\n    });\n\n\n    // Parallax Static Methods\n\n    $.extend(Parallax, {\n        scrollTop:    0,\n        scrollLeft:   0,\n        winHeight:    0,\n        winWidth:     0,\n        docHeight:    1 << 30,\n        docWidth:     1 << 30,\n        sliders:      [],\n        isReady:      false,\n        isFresh:      false,\n        isBusy:       false,\n\n        setup: function() {\n            if (this.isReady) return;\n\n            var self = this;\n\n            var $doc = $(document), $win = $(window);\n\n            var loadDimensions = function() {\n                Parallax.winHeight = $win.height();\n                Parallax.winWidth  = $win.width();\n                Parallax.docHeight = $doc.height();\n                Parallax.docWidth  = $doc.width();\n            };\n\n            var loadScrollPosition = function() {\n                var winScrollTop  = $win.scrollTop();\n                var scrollTopMax  = Parallax.docHeight - Parallax.winHeight;\n                var scrollLeftMax = Parallax.docWidth  - Parallax.winWidth;\n                Parallax.scrollTop  = Math.max(0, Math.min(scrollTopMax,  winScrollTop));\n                Parallax.scrollLeft = Math.max(0, Math.min(scrollLeftMax, $win.scrollLeft()));\n                Parallax.overScroll = Math.max(winScrollTop - scrollTopMax, Math.min(winScrollTop, 0));\n            };\n\n            $('body').on('contentUpdated', function () {\n                loadDimensions();\n                self.refresh();\n                Parallax.isFresh = false;\n                Parallax.requestRender();\n            });\n\n            $win.on('resize.px.parallax load.px.parallax', function() {\n                loadDimensions();\n                self.refresh();\n                Parallax.isFresh = false;\n                Parallax.requestRender();\n            })\n                .on('scroll.px.parallax load.px.parallax', function() {\n                    loadScrollPosition();\n                    Parallax.requestRender();\n                });\n\n            loadDimensions();\n            loadScrollPosition();\n\n            this.isReady = true;\n\n            var lastPosition = -1;\n\n            function frameLoop() {\n                if (lastPosition == window.pageYOffset) {   // Avoid overcalculations\n                    window.requestAnimationFrame(frameLoop);\n                    return false;\n                } else lastPosition = window.pageYOffset;\n\n                self.render();\n                window.requestAnimationFrame(frameLoop);\n            }\n\n            frameLoop();\n        },\n\n        configure: function(options) {\n            if (typeof options == 'object') {\n                delete options.refresh;\n                delete options.render;\n                $.extend(this.prototype, options);\n            }\n        },\n\n        refresh: function() {\n            $.each(this.sliders, function(){ this.refresh(); });\n            this.isFresh = true;\n        },\n\n        render: function() {\n            this.isFresh || this.refresh();\n            $.each(this.sliders, function(){ this.render(); });\n        },\n\n        requestRender: function() {\n            var self = this;\n            self.render();\n            self.isBusy = false;\n        },\n        destroy: function(el){\n            var i,\n                parallaxElement = $(el).data('px.parallax');\n            if (!!parallaxElement.$mirror) {\n                parallaxElement.$mirror.remove();\n            }\n            for(i=0; i < this.sliders.length; i+=1){\n                if(this.sliders[i] == parallaxElement){\n                    this.sliders.splice(i, 1);\n                }\n            }\n            $(el).data('px.parallax', false);\n            if(this.sliders.length === 0){\n                $(window).off('scroll.px.parallax resize.px.parallax load.px.parallax');\n                this.isReady = false;\n                Parallax.isSetup = false;\n            }\n        }\n    });\n\n\n    // Parallax Plugin Definition\n\n    function Plugin(option) {\n        return this.each(function () {\n            var $this = $(this);\n            var options = typeof option == 'object' && option;\n\n            if (this == window || this == document || $this.is('body')) {\n                Parallax.configure(options);\n            }\n            else if (!$this.data('px.parallax')) {\n                options = $.extend({}, $this.data(), options);\n                $this.data('px.parallax', new Parallax(this, options));\n            }\n            else if (typeof option == 'object')\n            {\n                $.extend($this.data('px.parallax'), options);\n            }\n            if (typeof option == 'string') {\n                if(option == 'destroy'){\n                    Parallax.destroy(this);\n                }else{\n                    Parallax[option]();\n                }\n            }\n        });\n    }\n\n    var old = $.fn.parallax;\n\n    $.fn.parallax             = Plugin;\n    $.fn.parallax.Constructor = Parallax;\n\n\n    // Parallax No Conflict\n\n    $.fn.parallax.noConflict = function () {\n        $.fn.parallax = old;\n        return this;\n    };\n\n\n    // Parallax Data-API\n\n    $( function () {\n        $('[data-parallax=\"scroll\"]').parallax();\n    });\n\n}(jQuery, window, document));\n","MageBig_WidgetPlus/js/owl.carousel-set.js":"define([\r\n    'jquery',\r\n    'jquery-ui-modules/widget',\r\n    'MageBig_WidgetPlus/js/owl.carousel'\r\n], function ($) {\r\n    'use strict';\r\n\r\n    $.widget('magebig.owlWidget', {\r\n        options: {\r\n            autoplay: false,\r\n            autoplayHoverPause: true,\r\n            smartSpeed: 750,\r\n            rewind: true,\r\n            navText: ['<i class=\"mbi mbi-chevron-left\"></i>', '<i class=\"mbi mbi-chevron-right\"></i>'],\r\n            animateOut: 'fadeOut',\r\n            rtl: false\r\n        },\r\n        _create: function() {\r\n            var self = this,\r\n                elm = this.element,\r\n                id = '#'+elm.attr('id'),\r\n                owl,\r\n                autoplay = this.options.autoplay;\r\n\r\n            if (elm.find('[data-content-type=html]').first().length) {\r\n                elm.find('[data-content-type=html]').children().unwrap();\r\n            }\r\n\r\n            owl = elm.find('.owl-carousel');\r\n\r\n            if (elm.hasClass('lazyload') && autoplay) {\r\n                this.options.autoplay = false;\r\n                self._initOwl(owl);\r\n\r\n                document.addEventListener('lazybeforeunveil', function (e) {\r\n                    var aa = $(e.target).filter(id);\r\n                    if (aa.length && autoplay) {\r\n                        owl.trigger('play.owl.autoplay');\r\n                    }\r\n                });\r\n            } else {\r\n                self._initOwl(owl);\r\n            }\r\n        },\r\n        _initOwl: function (owl) {\r\n            var self = this;\r\n\r\n            if (owl.length) {\r\n                if (self.options.rtl || $('body').hasClass('layout-rtl')) {\r\n                    self.options.rtl = true;\r\n                }\r\n\r\n                if ($(self.element).parents('.container').length) {\r\n                    self.options.responsiveBaseElement = '.container';\r\n                }\r\n\r\n                owl.on('initialized.owl.carousel', function (e) {\r\n                    setTimeout(function () {\r\n                        var video = owl.find('.owl-item.active video');\r\n                        if (video.length) {\r\n                            var paused = video[0].paused;\r\n                            if (paused) {\r\n                                video.get(0).play();\r\n                            }\r\n                        }\r\n                    }, 2000);\r\n                });\r\n\r\n                owl.owlCarousel(self.options);\r\n\r\n                owl.on('translate.owl.carousel', function (e) {\r\n                    var video = owl.find('.owl-item video');\r\n                    if (video.length) {\r\n                        video.each(function () {\r\n                            $(this).get(0).pause();\r\n                        });\r\n                    }\r\n                });\r\n\r\n                owl.on('translated.owl.carousel', function (e) {\r\n                    var video = owl.find('.owl-item.active video');\r\n                    if (video.length) {\r\n                        video.get(0).play();\r\n                    }\r\n                });\r\n\r\n                owl.on('dragged.owl.carousel', function (e) {\r\n                    owl.trigger('stop.owl.autoplay');\r\n                });\r\n            }\r\n        }\r\n    });\r\n\r\n    return $.magebig.owlWidget;\r\n});\r\n","MageBig_WidgetPlus/js/jcountdown-set.js":"define([\r\n    'jquery',\r\n    'MageBig_WidgetPlus/js/jcountdown'\r\n], function ($) {\r\n    'use strict';\r\n\r\n    $.widget('magebig.jCoundown', {\r\n        options: {\r\n        },\r\n        _create: function() {\r\n            var template = \"<div class='cd-sale day'><span class='num'>%d</span><span class='unit'>%td</span></div><div class='cd-sale hour'><span class='num'>%h</span><span class='unit'>%th</span></div><div class='cd-sale minute'><span class='num'>%i</span><span class='unit'>%ti</span></div><div class='cd-sale second'><span class='num'>%s</span><span class='unit'>%ts</span></div>\",\r\n                hoursOnly = false,\r\n                minsOnly = false,\r\n                secsOnly = false,\r\n                elm = $(this.element);\r\n\r\n            if (elm.data('day-loop') == true) {\r\n                var today = new Date();\r\n                today.setDate(today.getDate() + 1);\r\n\r\n                var monthNames = [\r\n                    \"January\", \"February\", \"March\",\r\n                    \"April\", \"May\", \"June\", \"July\",\r\n                    \"August\", \"September\", \"October\",\r\n                    \"November\", \"December\"\r\n                ];\r\n                var dateString = monthNames[today.getMonth()] + \" \" + today.getDate() + \", \" + today.getFullYear();\r\n            }\r\n\r\n            if (elm.data('hours-only') == true) {\r\n                hoursOnly = true;\r\n                template = \"<div class='cd-sale hour'><span class='num'>%h</span><span class='unit'>%th</span></div><div class='cd-sale minute'><span class='num'>%i</span><span class='unit'>%ti</span></div><div class='cd-sale second'><span class='num'>%s</span><span class='unit'>%ts</span></div>\";\r\n            }\r\n\r\n            if (elm.data('mins-only') == true && !hoursOnly) {\r\n                minsOnly = true;\r\n                template = \"<div class='cd-sale minute'><span class='num'>%i</span><span class='unit'>%ti</span></div><div class='cd-sale second'><span class='num'>%s</span><span class='unit'>%ts</span></div>\";\r\n            }\r\n\r\n            if (elm.data('secs-only') == true && !hoursOnly && !minsOnly) {\r\n                minsOnly = true;\r\n                template = \"<div class='cd-sale second'><span class='num'>%s</span><span class='unit'>%ts</span></div>\";\r\n            }\r\n\r\n            var countdownConfig = {\r\n                date: dateString ? dateString : null,\r\n                dataAttr: dateString ? null : this.options.dataAttr,\r\n                template: template,\r\n                dayText: this.options.dayText,\r\n                hourText: this.options.hourText,\r\n                minText: this.options.minText,\r\n                secText: this.options.secText,\r\n                daySingularText: this.options.daySingularText,\r\n                hourSingularText: this.options.hourSingularText,\r\n                minSingularText: this.options.minSingularText,\r\n                secSingularText: this.options.secSingularText,\r\n                leadingZero: true,\r\n                offset: this.options.offset,\r\n                hoursOnly: hoursOnly,\r\n                minsOnly: minsOnly,\r\n                secsOnly: secsOnly\r\n            };\r\n\r\n            elm.countdown(countdownConfig);\r\n        }\r\n    });\r\n\r\n    return $.magebig.jCoundown;\r\n});","MageBig_WidgetPlus/js/parallax-set.js":"define([\r\n    \"jquery\",\r\n    \"MageBig_WidgetPlus/js/parallax\",\r\n    \"domReady!\"\r\n], function($) {\r\n    \"use strict\";\r\n\r\n    return function(config, element) {\r\n        var parallaxConfig = {\r\n            imageSrc: config.imageSrc,\r\n            mirrorContainer: element,\r\n            zIndex: 0\r\n        };\r\n        setTimeout(function() {\r\n            $(element).parallax(parallaxConfig);\r\n        }, 1000);\r\n    }\r\n});","MageBig_WidgetPlus/js/owl.carousel.js":"/**\n * Owl Carousel v2.3.4\n * Copyright 2013-2018 David Deutsch\n * Licensed under: SEE LICENSE IN https://github.com/OwlCarousel2/OwlCarousel2/blob/master/LICENSE\n */\n/**\n * Owl carousel\n * @version 2.3.4\n * @author Bartosz Wojciechowski\n * @author David Deutsch\n * @license The MIT License (MIT)\n * @todo Lazy Load Icon\n * @todo prevent animationend bubling\n * @todo itemsScaleUp\n * @todo Test Zepto\n * @todo stagePadding calculate wrong active classes\n */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\"jquery\"], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    /**\n     * Creates a carousel.\n     * @class The Owl Carousel.\n     * @public\n     * @param {HTMLElement|jQuery} element - The element to create the carousel for.\n     * @param {Object} [options] - The options\n     */\n    function Owl(element, options) {\n\n        /**\n         * Current settings for the carousel.\n         * @public\n         */\n        this.settings = null;\n\n        var runningOnBrowser = typeof window !== \"undefined\";\n        var isBot = runningOnBrowser && !(\"onscroll\" in window) || typeof navigator !== \"undefined\" && /(gle|ing|ro)bot|crawl|spider/i.test(navigator.userAgent);\n        var autoP = options.autoplay;\n        if (autoP && isBot) {\n            options.autoplay = false;\n        }\n\n        /**\n         * Current options set by the caller including defaults.\n         * @public\n         */\n        this.options = $.extend({}, Owl.Defaults, options);\n\n        /**\n         * Plugin element.\n         * @public\n         */\n        this.$element = $(element);\n\n        /**\n         * Proxied event handlers.\n         * @protected\n         */\n        this._handlers = {};\n\n        /**\n         * References to the running plugins of this carousel.\n         * @protected\n         */\n        this._plugins = {};\n\n        /**\n         * Currently suppressed events to prevent them from being retriggered.\n         * @protected\n         */\n        this._supress = {};\n\n        /**\n         * Absolute current position.\n         * @protected\n         */\n        this._current = null;\n\n        /**\n         * Animation speed in milliseconds.\n         * @protected\n         */\n        this._speed = null;\n\n        /**\n         * Coordinates of all items in pixel.\n         * @todo The name of this member is missleading.\n         * @protected\n         */\n        this._coordinates = [];\n\n        /**\n         * Current breakpoint.\n         * @todo Real media queries would be nice.\n         * @protected\n         */\n        this._breakpoint = null;\n\n        /**\n         * Current width of the plugin element.\n         */\n        this._width = null;\n\n        /**\n         * All real items.\n         * @protected\n         */\n        this._items = [];\n\n        /**\n         * All cloned items.\n         * @protected\n         */\n        this._clones = [];\n\n        /**\n         * Merge values of all items.\n         * @todo Maybe this could be part of a plugin.\n         * @protected\n         */\n        this._mergers = [];\n\n        /**\n         * Widths of all items.\n         */\n        this._widths = [];\n\n        /**\n         * Invalidated parts within the update process.\n         * @protected\n         */\n        this._invalidated = {};\n\n        /**\n         * Ordered list of workers for the update process.\n         * @protected\n         */\n        this._pipe = [];\n\n        /**\n         * Current state information for the drag operation.\n         * @todo #261\n         * @protected\n         */\n        this._drag = {\n            time: null,\n            target: null,\n            pointer: null,\n            stage: {\n                start: null,\n                current: null\n            },\n            direction: null\n        };\n\n        /**\n         * Current state information and their tags.\n         * @type {Object}\n         * @protected\n         */\n        this._states = {\n            current: {},\n            tags: {\n                'initializing': ['busy'],\n                'animating': ['busy'],\n                'dragging': ['interacting']\n            }\n        };\n\n        $.each(['onResize', 'onThrottledResize'], $.proxy(function (i, handler) {\n            this._handlers[handler] = $.proxy(this[handler], this);\n        }, this));\n\n        $.each(Owl.Plugins, $.proxy(function (key, plugin) {\n            this._plugins[key.charAt(0).toLowerCase() + key.slice(1)]\n                = new plugin(this);\n        }, this));\n\n        $.each(Owl.Workers, $.proxy(function (priority, worker) {\n            this._pipe.push({\n                'filter': worker.filter,\n                'run': $.proxy(worker.run, this)\n            });\n        }, this));\n\n        this.setup();\n        this.initialize();\n    }\n\n    /**\n     * Default options for the carousel.\n     * @public\n     */\n    Owl.Defaults = {\n        items: 3,\n        loop: false,\n        center: false,\n        rewind: false,\n        checkVisibility: true,\n\n        mouseDrag: true,\n        touchDrag: true,\n        pullDrag: true,\n        freeDrag: false,\n\n        margin: 0,\n        stagePadding: 0,\n\n        merge: false,\n        mergeFit: true,\n        autoWidth: false,\n\n        startPosition: 0,\n        rtl: false,\n\n        smartSpeed: 250,\n        fluidSpeed: false,\n        dragEndSpeed: false,\n\n        responsive: {},\n        responsiveRefreshRate: 200,\n        responsiveBaseElement: window,\n\n        fallbackEasing: 'swing',\n        slideTransition: '',\n\n        info: false,\n\n        nestedItemSelector: false,\n        itemElement: 'div',\n        stageElement: 'div',\n\n        refreshClass: 'owl-refresh',\n        loadedClass: 'owl-loaded',\n        loadingClass: 'owl-loading',\n        rtlClass: 'owl-rtl',\n        responsiveClass: 'owl-responsive',\n        dragClass: 'owl-drag',\n        itemClass: 'owl-item',\n        stageClass: 'owl-stage',\n        stageOuterClass: 'owl-stage-outer',\n        grabClass: 'owl-grab'\n    };\n\n    /**\n     * Enumeration for width.\n     * @public\n     * @readonly\n     * @enum {String}\n     */\n    Owl.Width = {\n        Default: 'default',\n        Inner: 'inner',\n        Outer: 'outer'\n    };\n\n    /**\n     * Enumeration for types.\n     * @public\n     * @readonly\n     * @enum {String}\n     */\n    Owl.Type = {\n        Event: 'event',\n        State: 'state'\n    };\n\n    /**\n     * Contains all registered plugins.\n     * @public\n     */\n    Owl.Plugins = {};\n\n    /**\n     * List of workers involved in the update process.\n     */\n    Owl.Workers = [{\n        filter: ['width', 'settings'],\n        run: function () {\n            this._width = this.$element.width();\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function (cache) {\n            cache.current = this._items && this._items[this.relative(this._current)];\n        }\n    }, {\n        filter: ['items', 'settings'],\n        run: function () {\n            this.$stage.children('.cloned').remove();\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function (cache) {\n            var margin = this.settings.margin || '',\n                grid = !this.settings.autoWidth,\n                rtl = this.settings.rtl,\n                css = {\n                    'width': 'auto',\n                    'margin-left': rtl ? margin : '',\n                    'margin-right': rtl ? '' : margin\n                };\n\n            !grid && this.$stage.children().css(css);\n\n            cache.css = css;\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function (cache) {\n            var width = (this.width() / this.settings.items).toFixed(3) - this.settings.margin,\n                merge = null,\n                iterator = this._items.length,\n                grid = !this.settings.autoWidth,\n                widths = [];\n\n            cache.items = {\n                merge: false,\n                width: width\n            };\n\n            while (iterator--) {\n                merge = this._mergers[iterator];\n                merge = this.settings.mergeFit && Math.min(merge, this.settings.items) || merge;\n\n                cache.items.merge = merge > 1 || cache.items.merge;\n\n                widths[iterator] = !grid ? this._items[iterator].width() : width * merge;\n            }\n\n            this._widths = widths;\n        }\n    }, {\n        filter: ['items', 'settings'],\n        run: function () {\n            var clones = [],\n                items = this._items,\n                settings = this.settings,\n                // TODO: Should be computed from number of min width items in stage\n                view = Math.max(settings.items * 2, 4),\n                size = Math.ceil(items.length / 2) * 2,\n                repeat = settings.loop && items.length ? settings.rewind ? view : Math.max(view, size) : 0,\n                append = '',\n                prepend = '';\n\n            repeat /= 2;\n\n            if (settings.loop && items.length && settings.stagePadding) {\n                repeat += 1;\n            }\n\n            while (repeat > 0) {\n                // Switch to only using appended clones\n                clones.push(this.normalize(clones.length / 2, true));\n                $(items[clones[clones.length - 1]][0]).clone(true).addClass('cloned').appendTo(this.$stage);\n                clones.push(this.normalize(items.length - 1 - (clones.length - 1) / 2, true));\n                $(items[clones[clones.length - 1]][0]).clone(true).addClass('cloned').prependTo(this.$stage);\n                repeat -= 1;\n            }\n\n            this._clones = clones;\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function () {\n            var rtl = this.settings.rtl ? 1 : -1,\n                size = this._clones.length + this._items.length,\n                iterator = -1,\n                previous = 0,\n                current = 0,\n                coordinates = [];\n\n            while (++iterator < size) {\n                previous = coordinates[iterator - 1] || 0;\n                current = this._widths[this.relative(iterator)] + this.settings.margin;\n                coordinates.push(previous + current * rtl);\n            }\n\n            this._coordinates = coordinates;\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function () {\n            var padding = this.settings.stagePadding,\n                coordinates = this._coordinates,\n                css = {\n                    'width': Math.ceil(Math.abs(coordinates[coordinates.length - 1])) + padding + 1,\n                    'padding-right': padding || ''\n                };\n            var rtl = this.settings.rtl ? 1 : -1;\n            if (rtl == 1) {\n                css = {\n                    'width': Math.ceil(Math.abs(coordinates[coordinates.length - 1])) + padding + 1,\n                    'padding-left': padding || ''\n                };\n            }\n\n            this.$stage.css(css);\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function (cache) {\n            var iterator = this._coordinates.length,\n                grid = !this.settings.autoWidth,\n                items = this.$stage.children();\n\n            if (grid && cache.items.merge) {\n                while (iterator--) {\n                    cache.css.width = this._widths[this.relative(iterator)];\n                    items.eq(iterator).css(cache.css);\n                }\n            } else if (grid) {\n                cache.css.width = cache.items.width;\n                items.css(cache.css);\n            }\n        }\n    }, {\n        filter: ['items'],\n        run: function () {\n            this._coordinates.length < 1 && this.$stage.removeAttr('style');\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function (cache) {\n            cache.current = cache.current ? this.$stage.children().index(cache.current) : 0;\n            cache.current = Math.max(this.minimum(), Math.min(this.maximum(), cache.current));\n            this.reset(cache.current);\n        }\n    }, {\n        filter: ['position'],\n        run: function () {\n            this.animate(this.coordinates(this._current));\n        }\n    }, {\n        filter: ['width', 'position', 'items', 'settings'],\n        run: function () {\n            var rtl = this.settings.rtl ? 1 : -1,\n                padding = this.settings.stagePadding,\n                begin = this.coordinates(this.current()) + padding,\n                end = begin + this.width() * rtl,\n                inner, outer, matches = [], i, n;\n\n            for (i = 0, n = this._coordinates.length; i < n; i++) {\n                inner = this._coordinates[i - 1] || 0;\n                outer = Math.abs(this._coordinates[i]) + padding * rtl;\n\n                if ((this.op(inner, '<=', begin) && (this.op(inner, '>', end)))\n                    || (this.op(outer, '<', begin) && this.op(outer, '>', end))) {\n                    matches.push(i);\n                }\n            }\n\n            this.$stage.children('.active').removeClass('active');\n            this.$stage.children(':eq(' + matches.join('), :eq(') + ')').addClass('active');\n\n            this.$stage.children('.center').removeClass('center');\n            if (this.settings.center) {\n                this.$stage.children().eq(this.current()).addClass('center');\n            }\n        }\n    }];\n\n    /**\n     * Create the stage DOM element\n     */\n    Owl.prototype.initializeStage = function () {\n        this.$stage = this.$element.find('.' + this.settings.stageClass);\n\n        // if the stage is already in the DOM, grab it and skip stage initialization\n        if (this.$stage.length) {\n            return;\n        }\n\n        this.$element.addClass(this.options.loadingClass);\n\n        // create stage\n        this.$stage = $('<' + this.settings.stageElement + '>', {\n            \"class\": this.settings.stageClass\n        }).wrap($('<div/>', {\n            \"class\": this.settings.stageOuterClass\n        }));\n\n        // append stage\n        this.$element.append(this.$stage.parent());\n    };\n\n    /**\n     * Create item DOM elements\n     */\n    Owl.prototype.initializeItems = function () {\n        var $items = this.$element.find('.owl-item');\n\n        // if the items are already in the DOM, grab them and skip item initialization\n        if ($items.length) {\n            this._items = $items.get().map(function (item) {\n                return $(item);\n            });\n\n            this._mergers = this._items.map(function () {\n                return 1;\n            });\n\n            this.refresh();\n\n            return;\n        }\n\n        // append content\n        this.replace(this.$element.children().not(this.$stage.parent()));\n\n        // check visibility\n        if (this.isVisible()) {\n            // update view\n            this.refresh();\n        } else {\n            // invalidate width\n            this.invalidate('width');\n        }\n\n        this.$element\n            .removeClass(this.options.loadingClass)\n            .addClass(this.options.loadedClass);\n    };\n\n    /**\n     * Initializes the carousel.\n     * @protected\n     */\n    Owl.prototype.initialize = function () {\n        this.enter('initializing');\n        this.trigger('initialize');\n\n        this.$element.toggleClass(this.settings.rtlClass, this.settings.rtl);\n\n        if (this.settings.autoWidth && !this.is('pre-loading')) {\n            var imgs, nestedSelector, width;\n            imgs = this.$element.find('img');\n            nestedSelector = this.settings.nestedItemSelector ? '.' + this.settings.nestedItemSelector : undefined;\n            width = this.$element.children(nestedSelector).width();\n\n            if (imgs.length && width <= 0) {\n                this.preloadAutoWidthImages(imgs);\n            }\n        }\n\n        this.initializeStage();\n        this.initializeItems();\n\n        // register event handlers\n        this.registerEventHandlers();\n\n        this.leave('initializing');\n        this.trigger('initialized');\n    };\n\n    /**\n     * @returns {Boolean} visibility of $element\n     *                    if you know the carousel will always be visible you can set `checkVisibility` to `false` to\n     *                    prevent the expensive browser layout forced reflow the $element.is(':visible') does\n     */\n    Owl.prototype.isVisible = function () {\n        return this.settings.checkVisibility\n            ? this.$element.is(':visible')\n            : true;\n    };\n\n    /**\n     * Setups the current settings.\n     * @todo Remove responsive classes. Why should adaptive designs be brought into IE8?\n     * @todo Support for media queries by using `matchMedia` would be nice.\n     * @public\n     */\n    Owl.prototype.setup = function () {\n        var viewport = this.viewport(),\n            overwrites = this.options.responsive,\n            match = -1,\n            settings = null;\n\n        if (!overwrites) {\n            settings = $.extend({}, this.options);\n        } else {\n            $.each(overwrites, function (breakpoint) {\n                if (breakpoint <= viewport && breakpoint > match) {\n                    match = Number(breakpoint);\n                }\n            });\n\n            settings = $.extend({}, this.options, overwrites[match]);\n            if (typeof settings.stagePadding === 'function') {\n                settings.stagePadding = settings.stagePadding();\n            }\n            delete settings.responsive;\n\n            // responsive class\n            if (settings.responsiveClass) {\n                this.$element.attr('class',\n                    this.$element.attr('class').replace(new RegExp('(' + this.options.responsiveClass + '-)\\\\S+\\\\s', 'g'), '$1' + match)\n                );\n            }\n        }\n\n        this.trigger('change', {property: {name: 'settings', value: settings}});\n        this._breakpoint = match;\n        this.settings = settings;\n        this.invalidate('settings');\n        this.trigger('changed', {property: {name: 'settings', value: this.settings}});\n    };\n\n    /**\n     * Updates option logic if necessery.\n     * @protected\n     */\n    Owl.prototype.optionsLogic = function () {\n        if (this.settings.autoWidth) {\n            this.settings.stagePadding = false;\n            this.settings.merge = false;\n        }\n    };\n\n    /**\n     * Prepares an item before add.\n     * @todo Rename event parameter `content` to `item`.\n     * @protected\n     * @returns {jQuery|HTMLElement} - The item container.\n     */\n    Owl.prototype.prepare = function (item) {\n        var event = this.trigger('prepare', {content: item});\n\n        if (!event.data) {\n            event.data = $('<' + this.settings.itemElement + '/>')\n                .addClass(this.options.itemClass).append(item)\n        }\n\n        this.trigger('prepared', {content: event.data});\n\n        return event.data;\n    };\n\n    /**\n     * Updates the view.\n     * @public\n     */\n    Owl.prototype.update = function () {\n        var i = 0,\n            n = this._pipe.length,\n            filter = $.proxy(function (p) {\n                return this[p]\n            }, this._invalidated),\n            cache = {};\n\n        while (i < n) {\n            if (this._invalidated.all || $.grep(this._pipe[i].filter, filter).length > 0) {\n                this._pipe[i].run(cache);\n            }\n            i++;\n        }\n\n        this._invalidated = {};\n\n        !this.is('valid') && this.enter('valid');\n    };\n\n    /**\n     * Gets the width of the view.\n     * @public\n     * @param {Owl.Width} [dimension=Owl.Width.Default] - The dimension to return.\n     * @returns {Number} - The width of the view in pixel.\n     */\n    Owl.prototype.width = function (dimension) {\n        dimension = dimension || Owl.Width.Default;\n        switch (dimension) {\n            case Owl.Width.Inner:\n            case Owl.Width.Outer:\n                return this._width;\n            default:\n                return this._width - this.settings.stagePadding + this.settings.margin;\n        }\n    };\n\n    /**\n     * Refreshes the carousel primarily for adaptive purposes.\n     * @public\n     */\n    Owl.prototype.refresh = function (resizing) {\n        resizing = resizing || false;\n\n        this.enter('refreshing');\n        this.trigger('refresh');\n\n        this.setup();\n\n        this.optionsLogic();\n\n        this.$element.addClass(this.options.refreshClass);\n\n        this.update();\n\n        if (!resizing) {\n            this.onResize();\n        }\n\n        this.$element.removeClass(this.options.refreshClass);\n\n        this.leave('refreshing');\n        this.trigger('refreshed');\n    };\n\n    /**\n     * Checks window `resize` event.\n     * @protected\n     */\n    Owl.prototype.onThrottledResize = function () {\n        window.clearTimeout(this.resizeTimer);\n        this.resizeTimer = window.setTimeout(this._handlers.onResize, this.settings.responsiveRefreshRate);\n    };\n\n    /**\n     * Checks window `resize` event.\n     * @protected\n     */\n    Owl.prototype.onResize = function () {\n        var resizing = true;\n\n        if (!this._items.length) {\n            return false;\n        }\n\n        if (this._width === this.$element.width()) {\n            return false;\n        }\n\n        if (!this.isVisible()) {\n            return false;\n        }\n\n        this.enter('resizing');\n\n        if (this.trigger('resize').isDefaultPrevented()) {\n            this.leave('resizing');\n            return false;\n        }\n\n        this.invalidate('width');\n\n        this.refresh(resizing);\n\n        this.leave('resizing');\n        this.trigger('resized');\n    };\n\n    /**\n     * Registers event handlers.\n     * @todo Check `msPointerEnabled`\n     * @todo #261\n     * @protected\n     */\n    Owl.prototype.registerEventHandlers = function () {\n        if ($.support.transition) {\n            this.$stage.on($.support.transition.end + '.owl.core', $.proxy(this.onTransitionEnd, this));\n        }\n\n        if (this.settings.responsive !== false) {\n            this.on(window, 'resize', this._handlers.onThrottledResize);\n            this.on(window, 'drop', this._handlers.onThrottledResize);\n        }\n\n        if (this.settings.mouseDrag) {\n            this.$element.addClass(this.options.dragClass);\n            this.$stage.on('mousedown.owl.core', $.proxy(this.onDragStart, this));\n            this.$stage.on('dragstart.owl.core selectstart.owl.core', function () {\n                return false\n            });\n        }\n\n        if (this.settings.touchDrag) {\n            this.$stage.on('touchstart.owl.core', $.proxy(this.onDragStart, this));\n            this.$stage.on('touchcancel.owl.core', $.proxy(this.onDragEnd, this));\n        }\n    };\n\n    /**\n     * Handles `touchstart` and `mousedown` events.\n     * @todo Horizontal swipe threshold as option\n     * @todo #261\n     * @protected\n     * @param {Event} event - The event arguments.\n     */\n    Owl.prototype.onDragStart = function (event) {\n        var stage = null;\n\n        if (event.which === 3) {\n            return;\n        }\n\n        if ($.support.transform) {\n            stage = this.$stage.css('transform').replace(/.*\\(|\\)| /g, '').split(',');\n            stage = {\n                x: stage[stage.length === 16 ? 12 : 4],\n                y: stage[stage.length === 16 ? 13 : 5]\n            };\n        } else {\n            stage = this.$stage.position();\n            stage = {\n                x: this.settings.rtl ?\n                    stage.left + this.$stage.width() - this.width() + this.settings.margin :\n                    stage.left,\n                y: stage.top\n            };\n        }\n\n        if (this.is('animating')) {\n            $.support.transform ? this.animate(stage.x) : this.$stage.stop()\n            this.invalidate('position');\n        }\n\n        this.$element.toggleClass(this.options.grabClass, event.type === 'mousedown');\n\n        this.speed(0);\n\n        this._drag.time = new Date().getTime();\n        this._drag.target = $(event.target);\n        this._drag.stage.start = stage;\n        this._drag.stage.current = stage;\n        this._drag.pointer = this.pointer(event);\n\n        $(document).on('mouseup.owl.core touchend.owl.core', $.proxy(this.onDragEnd, this));\n\n        $(document).one('mousemove.owl.core touchmove.owl.core', $.proxy(function (event) {\n            var delta = this.difference(this._drag.pointer, this.pointer(event));\n\n            if (Math.abs(delta.x) < Math.abs(delta.y) && this.is('valid')) {\n                return;\n            }\n\n            // event.preventDefault();\n\n            this.enter('dragging');\n            this.trigger('drag');\n            this.onDragMove(event);\n\n            $(document).on('mousemove.owl.core touchmove.owl.core', $.proxy(this.onDragMove, this));\n        }, this));\n    };\n\n    /**\n     * Handles the `touchmove` and `mousemove` events.\n     * @todo #261\n     * @protected\n     * @param {Event} event - The event arguments.\n     */\n    Owl.prototype.onDragMove = function (event) {\n        var minimum = null,\n            maximum = null,\n            pull = null,\n            delta = this.difference(this._drag.pointer, this.pointer(event)),\n            stage = this.difference(this._drag.stage.start, delta);\n\n        if (!this.is('dragging')) {\n            return;\n        }\n\n        // event.preventDefault();\n\n        if (this.settings.loop) {\n            minimum = this.coordinates(this.minimum());\n            maximum = this.coordinates(this.maximum() + 1) - minimum;\n            stage.x = (((stage.x - minimum) % maximum + maximum) % maximum) + minimum;\n        } else {\n            minimum = this.settings.rtl ? this.coordinates(this.maximum()) : this.coordinates(this.minimum());\n            maximum = this.settings.rtl ? this.coordinates(this.minimum()) : this.coordinates(this.maximum());\n            pull = this.settings.pullDrag ? -1 * delta.x / 5 : 0;\n            stage.x = Math.max(Math.min(stage.x, minimum + pull), maximum + pull);\n        }\n\n        this._drag.stage.current = stage;\n\n        this.animate(stage.x);\n    };\n\n    /**\n     * Handles the `touchend` and `mouseup` events.\n     * @todo #261\n     * @todo Threshold for click event\n     * @protected\n     * @param {Event} event - The event arguments.\n     */\n    Owl.prototype.onDragEnd = function (event) {\n        var delta = this.difference(this._drag.pointer, this.pointer(event)),\n            stage = this._drag.stage.current,\n            direction = delta.x > 0 ^ this.settings.rtl ? 'left' : 'right';\n\n        $(document).off('.owl.core');\n\n        this.$element.removeClass(this.options.grabClass);\n\n        if (delta.x !== 0 && this.is('dragging') || !this.is('valid')) {\n            this.speed(this.settings.dragEndSpeed || this.settings.smartSpeed);\n            this.current(this.closest(stage.x, delta.x !== 0 ? direction : this._drag.direction));\n            this.invalidate('position');\n            this.update();\n\n            this._drag.direction = direction;\n\n            if ((Math.abs(delta.x) > 3 || new Date().getTime() - this._drag.time > 300) && (event.type === 'mouseup' || event.type === 'mousedown')) {\n                this._drag.target.one('click.owl.core', function () {\n                    return false;\n                });\n            }\n        }\n\n        if (!this.is('dragging')) {\n            return;\n        }\n\n        this.leave('dragging');\n        this.trigger('dragged');\n    };\n\n    /**\n     * Gets absolute position of the closest item for a coordinate.\n     * @todo Setting `freeDrag` makes `closest` not reusable. See #165.\n     * @protected\n     * @param {Number} coordinate - The coordinate in pixel.\n     * @param {String} direction - The direction to check for the closest item. Ether `left` or `right`.\n     * @return {Number} - The absolute position of the closest item.\n     */\n    Owl.prototype.closest = function (coordinate, direction) {\n        var position = -1,\n            pull = 30,\n            width = this.width(),\n            count = this.settings.items,\n            itemWidth = Math.round(width / count),\n            coordinates = this.coordinates();\n\n        if (!this.settings.freeDrag) {\n            // check closest item\n            $.each(coordinates, $.proxy(function (index, value) {\n                // on a left pull, check on current index\n                if (direction === 'left' && coordinate > value - pull && coordinate < value + pull) {\n                    position = index;\n                    // on a right pull, check on previous index\n                    // to do so, subtract width from value and set position = index + 1\n                } else if (direction === 'right' && coordinate > value - itemWidth - pull && coordinate < value - itemWidth + pull) {\n                    position = index + 1;\n                } else if (this.op(coordinate, '<', value)\n                    && this.op(coordinate, '>', coordinates[index + 1] !== undefined ? coordinates[index + 1] : value - width)) {\n                    position = direction === 'left' ? index + 1 : index;\n                }\n                return position === -1;\n            }, this));\n        }\n\n        if (!this.settings.loop) {\n            // non loop boundries\n            if (this.op(coordinate, '>', coordinates[this.minimum()])) {\n                position = coordinate = this.minimum();\n            } else if (this.op(coordinate, '<', coordinates[this.maximum()])) {\n                position = coordinate = this.maximum();\n            }\n        }\n\n        return position;\n    };\n\n    /**\n     * Animates the stage.\n     * @todo #270\n     * @public\n     * @param {Number} coordinate - The coordinate in pixels.\n     */\n    Owl.prototype.animate = function (coordinate) {\n        var animate = this.speed() > 0;\n\n        this.is('animating') && this.onTransitionEnd();\n\n        if (animate) {\n            this.enter('animating');\n            this.trigger('translate');\n        }\n\n        if ($.support.transform3d && $.support.transition) {\n            this.$stage.css({\n                transform: 'translate3d(' + coordinate + 'px,0px,0px)',\n                transition: (this.speed() / 1000) + 's' + (\n                    this.settings.slideTransition ? ' ' + this.settings.slideTransition : ''\n                )\n            });\n        } else if (animate) {\n            this.$stage.animate({\n                left: coordinate + 'px'\n            }, this.speed(), this.settings.fallbackEasing, $.proxy(this.onTransitionEnd, this));\n        } else {\n            this.$stage.css({\n                left: coordinate + 'px'\n            });\n        }\n    };\n\n    /**\n     * Checks whether the carousel is in a specific state or not.\n     * @param {String} state - The state to check.\n     * @returns {Boolean} - The flag which indicates if the carousel is busy.\n     */\n    Owl.prototype.is = function (state) {\n        return this._states.current[state] && this._states.current[state] > 0;\n    };\n\n    /**\n     * Sets the absolute position of the current item.\n     * @public\n     * @param {Number} [position] - The new absolute position or nothing to leave it unchanged.\n     * @returns {Number} - The absolute position of the current item.\n     */\n    Owl.prototype.current = function (position) {\n        if (position === undefined) {\n            return this._current;\n        }\n\n        if (this._items.length === 0) {\n            return undefined;\n        }\n\n        position = this.normalize(position);\n\n        if (this._current !== position) {\n            var event = this.trigger('change', {property: {name: 'position', value: position}});\n\n            if (event.data !== undefined) {\n                position = this.normalize(event.data);\n            }\n\n            this._current = position;\n\n            this.invalidate('position');\n\n            this.trigger('changed', {property: {name: 'position', value: this._current}});\n        }\n\n        return this._current;\n    };\n\n    /**\n     * Invalidates the given part of the update routine.\n     * @param {String} [part] - The part to invalidate.\n     * @returns {Array.<String>} - The invalidated parts.\n     */\n    Owl.prototype.invalidate = function (part) {\n        if ($.type(part) === 'string') {\n            this._invalidated[part] = true;\n            this.is('valid') && this.leave('valid');\n        }\n        return $.map(this._invalidated, function (v, i) {\n            return i\n        });\n    };\n\n    /**\n     * Resets the absolute position of the current item.\n     * @public\n     * @param {Number} position - The absolute position of the new item.\n     */\n    Owl.prototype.reset = function (position) {\n        position = this.normalize(position);\n\n        if (position === undefined) {\n            return;\n        }\n\n        this._speed = 0;\n        this._current = position;\n\n        this.suppress(['translate', 'translated']);\n\n        this.animate(this.coordinates(position));\n\n        this.release(['translate', 'translated']);\n    };\n\n    /**\n     * Normalizes an absolute or a relative position of an item.\n     * @public\n     * @param {Number} position - The absolute or relative position to normalize.\n     * @param {Boolean} [relative=false] - Whether the given position is relative or not.\n     * @returns {Number} - The normalized position.\n     */\n    Owl.prototype.normalize = function (position, relative) {\n        var n = this._items.length,\n            m = relative ? 0 : this._clones.length;\n\n        if (!this.isNumeric(position) || n < 1) {\n            position = undefined;\n        } else if (position < 0 || position >= n + m) {\n            position = ((position - m / 2) % n + n) % n + m / 2;\n        }\n\n        return position;\n    };\n\n    /**\n     * Converts an absolute position of an item into a relative one.\n     * @public\n     * @param {Number} position - The absolute position to convert.\n     * @returns {Number} - The converted position.\n     */\n    Owl.prototype.relative = function (position) {\n        position -= this._clones.length / 2;\n        return this.normalize(position, true);\n    };\n\n    /**\n     * Gets the maximum position for the current item.\n     * @public\n     * @param {Boolean} [relative=false] - Whether to return an absolute position or a relative position.\n     * @returns {Number}\n     */\n    Owl.prototype.maximum = function (relative) {\n        var settings = this.settings,\n            maximum = this._coordinates.length,\n            iterator,\n            reciprocalItemsWidth,\n            elementWidth;\n\n        if (settings.loop) {\n            maximum = this._clones.length / 2 + this._items.length - 1;\n        } else if (settings.autoWidth || settings.merge) {\n            iterator = this._items.length;\n            if (iterator) {\n                reciprocalItemsWidth = this._items[--iterator].width();\n                elementWidth = this.$element.width();\n                while (iterator--) {\n                    reciprocalItemsWidth += this._items[iterator].width() + this.settings.margin;\n                    if (reciprocalItemsWidth > elementWidth) {\n                        break;\n                    }\n                }\n            }\n            maximum = iterator + 1;\n        } else if (settings.center) {\n            maximum = this._items.length - 1;\n        } else {\n            maximum = this._items.length - settings.items;\n        }\n\n        if (relative) {\n            maximum -= this._clones.length / 2;\n        }\n\n        return Math.max(maximum, 0);\n    };\n\n    /**\n     * Gets the minimum position for the current item.\n     * @public\n     * @param {Boolean} [relative=false] - Whether to return an absolute position or a relative position.\n     * @returns {Number}\n     */\n    Owl.prototype.minimum = function (relative) {\n        return relative ? 0 : this._clones.length / 2;\n    };\n\n    /**\n     * Gets an item at the specified relative position.\n     * @public\n     * @param {Number} [position] - The relative position of the item.\n     * @return {jQuery|Array.<jQuery>} - The item at the given position or all items if no position was given.\n     */\n    Owl.prototype.items = function (position) {\n        if (position === undefined) {\n            return this._items.slice();\n        }\n\n        position = this.normalize(position, true);\n        return this._items[position];\n    };\n\n    /**\n     * Gets an item at the specified relative position.\n     * @public\n     * @param {Number} [position] - The relative position of the item.\n     * @return {jQuery|Array.<jQuery>} - The item at the given position or all items if no position was given.\n     */\n    Owl.prototype.mergers = function (position) {\n        if (position === undefined) {\n            return this._mergers.slice();\n        }\n\n        position = this.normalize(position, true);\n        return this._mergers[position];\n    };\n\n    /**\n     * Gets the absolute positions of clones for an item.\n     * @public\n     * @param {Number} [position] - The relative position of the item.\n     * @returns {Array.<Number>} - The absolute positions of clones for the item or all if no position was given.\n     */\n    Owl.prototype.clones = function (position) {\n        var odd = this._clones.length / 2,\n            even = odd + this._items.length,\n            map = function (index) {\n                return index % 2 === 0 ? even + index / 2 : odd - (index + 1) / 2\n            };\n\n        if (position === undefined) {\n            return $.map(this._clones, function (v, i) {\n                return map(i)\n            });\n        }\n\n        return $.map(this._clones, function (v, i) {\n            return v === position ? map(i) : null\n        });\n    };\n\n    /**\n     * Sets the current animation speed.\n     * @public\n     * @param {Number} [speed] - The animation speed in milliseconds or nothing to leave it unchanged.\n     * @returns {Number} - The current animation speed in milliseconds.\n     */\n    Owl.prototype.speed = function (speed) {\n        if (speed !== undefined) {\n            this._speed = speed;\n        }\n\n        return this._speed;\n    };\n\n    /**\n     * Gets the coordinate of an item.\n     * @todo The name of this method is missleanding.\n     * @public\n     * @param {Number} position - The absolute position of the item within `minimum()` and `maximum()`.\n     * @returns {Number|Array.<Number>} - The coordinate of the item in pixel or all coordinates.\n     */\n    Owl.prototype.coordinates = function (position) {\n        var multiplier = 1,\n            newPosition = position - 1,\n            coordinate;\n\n        if (position === undefined) {\n            return $.map(this._coordinates, $.proxy(function (coordinate, index) {\n                return this.coordinates(index);\n            }, this));\n        }\n\n        if (this.settings.center) {\n            if (this.settings.rtl) {\n                multiplier = -1;\n                newPosition = position + 1;\n            }\n\n            coordinate = this._coordinates[position];\n            var delta = (this.settings.rtl) ? (this._coordinates[0] + this._coordinates[this._coordinates.length - 1]) : 0;\n            coordinate += (this.width() - coordinate + (this._coordinates[newPosition] || delta)) / 2 * multiplier;\n        } else {\n            coordinate = this._coordinates[newPosition] || 0;\n        }\n\n        coordinate = Math.ceil(coordinate);\n\n        return coordinate;\n    };\n\n    /**\n     * Calculates the speed for a translation.\n     * @protected\n     * @param {Number} from - The absolute position of the start item.\n     * @param {Number} to - The absolute position of the target item.\n     * @param {Number} [factor=undefined] - The time factor in milliseconds.\n     * @returns {Number} - The time in milliseconds for the translation.\n     */\n    Owl.prototype.duration = function (from, to, factor) {\n        if (factor === 0) {\n            return 0;\n        }\n\n        return Math.min(Math.max(Math.abs(to - from), 1), 6) * Math.abs((factor || this.settings.smartSpeed));\n    };\n\n    /**\n     * Slides to the specified item.\n     * @public\n     * @param {Number} position - The position of the item.\n     * @param {Number} [speed] - The time in milliseconds for the transition.\n     */\n    Owl.prototype.to = function (position, speed) {\n        var current = this.current(),\n            revert = null,\n            distance = position - this.relative(current),\n            items = this._items.length,\n            minimum = this.minimum(),\n            maximum = this.maximum();\n\n        if (this.settings.loop) {\n            position = current + distance;\n            revert = ((position - minimum) % items + items) % items + minimum;\n\n            if (Math.abs(distance) > items / 2)\t{\n                maximum += 1;\n            }\n\n            if (revert !== position && revert - distance <= maximum && revert - distance > 0) {\n                current = revert - distance;\n                position = revert;\n                this.reset(current);\n            } else if ( revert !== position && position < 0) {\n                current = revert - Math.floor(items / 2);\n                if (Math.abs(distance) > items / 2) {\n                    current += Math.abs(distance) - Math.ceil(items / 2);\n                }\n                position = current + distance;\n                this.reset(current);\n            }\n        } else if (this.settings.rewind) {\n            maximum += 1;\n            position = (position % maximum + maximum) % maximum;\n        } else {\n            position = Math.max(minimum, Math.min(maximum, position));\n        }\n\n        this.speed(this.duration(current, position, speed));\n        this.current(position);\n\n        if (this.isVisible()) {\n            this.update();\n        }\n    };\n\n    /**\n     * Slides to the next item.\n     * @public\n     * @param {Number} [speed] - The time in milliseconds for the transition.\n     */\n    Owl.prototype.next = function (speed) {\n        speed = speed || false;\n        this.to(this.relative(this.current()) + 1, speed);\n    };\n\n    /**\n     * Slides to the previous item.\n     * @public\n     * @param {Number} [speed] - The time in milliseconds for the transition.\n     */\n    Owl.prototype.prev = function (speed) {\n        speed = speed || false;\n        this.to(this.relative(this.current()) - 1, speed);\n    };\n\n    /**\n     * Handles the end of an animation.\n     * @protected\n     * @param {Event} event - The event arguments.\n     */\n    Owl.prototype.onTransitionEnd = function (event) {\n\n        // if css2 animation then event object is undefined\n        if (event !== undefined) {\n            event.stopPropagation();\n\n            // Catch only owl-stage transitionEnd event\n            if ((event.target || event.srcElement || event.originalTarget) !== this.$stage.get(0)) {\n                return false;\n            }\n        }\n\n        this.leave('animating');\n        this.trigger('translated');\n    };\n\n    /**\n     * Gets viewport width.\n     * @protected\n     * @return {Number} - The width in pixel.\n     */\n    Owl.prototype.viewport = function () {\n        var width;\n        if (this.options.responsiveBaseElement !== window) {\n            width = $(this.options.responsiveBaseElement).innerWidth();\n        } else if (window.innerWidth) {\n            width = window.innerWidth;\n        } else if (document.documentElement && document.documentElement.clientWidth) {\n            width = document.documentElement.clientWidth;\n        } else {\n            console.warn('Can not detect viewport width.');\n        }\n        return width;\n    };\n\n    /**\n     * Replaces the current content.\n     * @public\n     * @param {HTMLElement|jQuery|String} content - The new content.\n     */\n    Owl.prototype.replace = function (content) {\n        this.$stage.empty();\n        this._items = [];\n\n        if (content) {\n            content = (content instanceof jQuery) ? content : $(content);\n        }\n\n        if (this.settings.nestedItemSelector) {\n            content = content.find('.' + this.settings.nestedItemSelector);\n        }\n\n        content.filter(function () {\n            return this.nodeType === 1;\n        }).each($.proxy(function (index, item) {\n            item = this.prepare(item);\n            this.$stage.append(item);\n            this._items.push(item);\n            this._mergers.push(item.find('[data-merge]').addBack('[data-merge]').attr('data-merge') * 1 || 1);\n        }, this));\n\n        this.reset(this.isNumeric(this.settings.startPosition) ? this.settings.startPosition : 0);\n\n        this.invalidate('items');\n    };\n\n    /**\n     * Adds an item.\n     * @todo Use `item` instead of `content` for the event arguments.\n     * @public\n     * @param {HTMLElement|jQuery|String} content - The item content to add.\n     * @param {Number} [position] - The relative position at which to insert the item otherwise the item will be added to the end.\n     */\n    Owl.prototype.add = function (content, position) {\n        var current = this.relative(this._current);\n\n        position = position === undefined ? this._items.length : this.normalize(position, true);\n        content = content instanceof jQuery ? content : $(content);\n\n        this.trigger('add', {content: content, position: position});\n\n        content = this.prepare(content);\n\n        if (this._items.length === 0 || position === this._items.length) {\n            this._items.length === 0 && this.$stage.append(content);\n            this._items.length !== 0 && this._items[position - 1].after(content);\n            this._items.push(content);\n            this._mergers.push(content.find('[data-merge]').addBack('[data-merge]').attr('data-merge') * 1 || 1);\n        } else {\n            this._items[position].before(content);\n            this._items.splice(position, 0, content);\n            this._mergers.splice(position, 0, content.find('[data-merge]').addBack('[data-merge]').attr('data-merge') * 1 || 1);\n        }\n\n        this._items[current] && this.reset(this._items[current].index());\n\n        this.invalidate('items');\n\n        this.trigger('added', {content: content, position: position});\n    };\n\n    /**\n     * Removes an item by its position.\n     * @todo Use `item` instead of `content` for the event arguments.\n     * @public\n     * @param {Number} position - The relative position of the item to remove.\n     */\n    Owl.prototype.remove = function (position) {\n        position = this.normalize(position, true);\n\n        if (position === undefined) {\n            return;\n        }\n\n        this.trigger('remove', {content: this._items[position], position: position});\n\n        this._items[position].remove();\n        this._items.splice(position, 1);\n        this._mergers.splice(position, 1);\n\n        this.invalidate('items');\n\n        this.trigger('removed', {content: null, position: position});\n    };\n\n    /**\n     * Preloads images with auto width.\n     * @todo Replace by a more generic approach\n     * @protected\n     */\n    Owl.prototype.preloadAutoWidthImages = function (images) {\n        images.each($.proxy(function (i, element) {\n            this.enter('pre-loading');\n            element = $(element);\n            $(new Image()).one('load', $.proxy(function (e) {\n                element.attr('src', e.target.src);\n                element.css('opacity', 1);\n                this.leave('pre-loading');\n                !this.is('pre-loading') && !this.is('initializing') && this.refresh();\n            }, this)).attr('src', (window.devicePixelRatio > 1) ? element.attr('data-src-retina') : element.attr('data-src') || element.attr('src'));\n        }, this));\n    };\n\n    /**\n     * Destroys the carousel.\n     * @public\n     */\n    Owl.prototype.destroy = function () {\n\n        this.$element.off('.owl.core');\n        this.$stage.off('.owl.core');\n        $(document).off('.owl.core');\n\n        if (this.settings.responsive !== false) {\n            window.clearTimeout(this.resizeTimer);\n            this.off(window, 'resize', this._handlers.onThrottledResize);\n        }\n\n        for (var i in this._plugins) {\n            this._plugins[i].destroy();\n        }\n\n        this.$stage.children('.cloned').remove();\n\n        this.$stage.unwrap();\n        this.$stage.children().contents().unwrap();\n        this.$stage.children().unwrap();\n        this.$stage.remove();\n        this.$element\n            .removeClass(this.options.refreshClass)\n            .removeClass(this.options.loadingClass)\n            .removeClass(this.options.loadedClass)\n            .removeClass(this.options.rtlClass)\n            .removeClass(this.options.dragClass)\n            .removeClass(this.options.grabClass)\n            .attr('class', this.$element.attr('class').replace(new RegExp(this.options.responsiveClass + '-\\\\S+\\\\s', 'g'), ''))\n            .removeData('owl.carousel');\n    };\n\n    /**\n     * Operators to calculate right-to-left and left-to-right.\n     * @protected\n     * @param {Number} [a] - The left side operand.\n     * @param {String} [o] - The operator.\n     * @param {Number} [b] - The right side operand.\n     */\n    Owl.prototype.op = function (a, o, b) {\n        var rtl = this.settings.rtl;\n        switch (o) {\n            case '<':\n                return rtl ? a > b : a < b;\n            case '>':\n                return rtl ? a < b : a > b;\n            case '>=':\n                return rtl ? a <= b : a >= b;\n            case '<=':\n                return rtl ? a >= b : a <= b;\n            default:\n                break;\n        }\n    };\n\n    /**\n     * Attaches to an internal event.\n     * @protected\n     * @param {HTMLElement} element - The event source.\n     * @param {String} event - The event name.\n     * @param {Function} listener - The event handler to attach.\n     * @param {Boolean} capture - Wether the event should be handled at the capturing phase or not.\n     */\n    Owl.prototype.on = function (element, event, listener, capture) {\n        if (element.addEventListener) {\n            element.addEventListener(event, listener, capture);\n        } else if (element.attachEvent) {\n            element.attachEvent('on' + event, listener);\n        }\n    };\n\n    /**\n     * Detaches from an internal event.\n     * @protected\n     * @param {HTMLElement} element - The event source.\n     * @param {String} event - The event name.\n     * @param {Function} listener - The attached event handler to detach.\n     * @param {Boolean} capture - Wether the attached event handler was registered as a capturing listener or not.\n     */\n    Owl.prototype.off = function (element, event, listener, capture) {\n        if (element.removeEventListener) {\n            element.removeEventListener(event, listener, capture);\n        } else if (element.detachEvent) {\n            element.detachEvent('on' + event, listener);\n        }\n    };\n\n    /**\n     * Triggers a public event.\n     * @todo Remove `status`, `relatedTarget` should be used instead.\n     * @protected\n     * @param {String} name - The event name.\n     * @param {*} [data=null] - The event data.\n     * @param {String} [namespace=carousel] - The event namespace.\n     * @param {String} [state] - The state which is associated with the event.\n     * @param {Boolean} [enter=false] - Indicates if the call enters the specified state or not.\n     * @returns {Event} - The event arguments.\n     */\n    Owl.prototype.trigger = function (name, data, namespace, state, enter) {\n        var status = {\n            item: {count: this._items.length, index: this.current()}\n        }, handler = $.camelCase(\n            $.grep(['on', name, namespace], function (v) {\n                return v\n            })\n                .join('-').toLowerCase()\n        ), event = $.Event(\n            [name, 'owl', namespace || 'carousel'].join('.').toLowerCase(),\n            $.extend({relatedTarget: this}, status, data)\n        );\n\n        if (!this._supress[name]) {\n            $.each(this._plugins, function (name, plugin) {\n                if (plugin.onTrigger) {\n                    plugin.onTrigger(event);\n                }\n            });\n\n            this.register({type: Owl.Type.Event, name: name});\n            this.$element.trigger(event);\n\n            if (this.settings && typeof this.settings[handler] === 'function') {\n                this.settings[handler].call(this, event);\n            }\n        }\n\n        return event;\n    };\n\n    /**\n     * Enters a state.\n     * @param name - The state name.\n     */\n    Owl.prototype.enter = function (name) {\n        $.each([name].concat(this._states.tags[name] || []), $.proxy(function (i, name) {\n            if (this._states.current[name] === undefined) {\n                this._states.current[name] = 0;\n            }\n\n            this._states.current[name]++;\n        }, this));\n    };\n\n    /**\n     * Leaves a state.\n     * @param name - The state name.\n     */\n    Owl.prototype.leave = function (name) {\n        $.each([name].concat(this._states.tags[name] || []), $.proxy(function (i, name) {\n            this._states.current[name]--;\n        }, this));\n    };\n\n    /**\n     * Registers an event or state.\n     * @public\n     * @param {Object} object - The event or state to register.\n     */\n    Owl.prototype.register = function (object) {\n        if (object.type === Owl.Type.Event) {\n            if (!$.event.special[object.name]) {\n                $.event.special[object.name] = {};\n            }\n\n            if (!$.event.special[object.name].owl) {\n                var _default = $.event.special[object.name]._default;\n                $.event.special[object.name]._default = function (e) {\n                    if (_default && _default.apply && (!e.namespace || e.namespace.indexOf('owl') === -1)) {\n                        return _default.apply(this, arguments);\n                    }\n                    return e.namespace && e.namespace.indexOf('owl') > -1;\n                };\n                $.event.special[object.name].owl = true;\n            }\n        } else if (object.type === Owl.Type.State) {\n            if (!this._states.tags[object.name]) {\n                this._states.tags[object.name] = object.tags;\n            } else {\n                this._states.tags[object.name] = this._states.tags[object.name].concat(object.tags);\n            }\n\n            this._states.tags[object.name] = $.grep(this._states.tags[object.name], $.proxy(function (tag, i) {\n                return $.inArray(tag, this._states.tags[object.name]) === i;\n            }, this));\n        }\n    };\n\n    /**\n     * Suppresses events.\n     * @protected\n     * @param {Array.<String>} events - The events to suppress.\n     */\n    Owl.prototype.suppress = function (events) {\n        $.each(events, $.proxy(function (index, event) {\n            this._supress[event] = true;\n        }, this));\n    };\n\n    /**\n     * Releases suppressed events.\n     * @protected\n     * @param {Array.<String>} events - The events to release.\n     */\n    Owl.prototype.release = function (events) {\n        $.each(events, $.proxy(function (index, event) {\n            delete this._supress[event];\n        }, this));\n    };\n\n    /**\n     * Gets unified pointer coordinates from event.\n     * @todo #261\n     * @protected\n     * @param {Event} - The `mousedown` or `touchstart` event.\n     * @returns {Object} - Contains `x` and `y` coordinates of current pointer position.\n     */\n    Owl.prototype.pointer = function (event) {\n        var result = {x: null, y: null};\n\n        event = event.originalEvent || event || window.event;\n\n        event = event.touches && event.touches.length ?\n            event.touches[0] : event.changedTouches && event.changedTouches.length ?\n                event.changedTouches[0] : event;\n\n        if (event.pageX) {\n            result.x = event.pageX;\n            result.y = event.pageY;\n        } else {\n            result.x = event.clientX;\n            result.y = event.clientY;\n        }\n\n        return result;\n    };\n\n    /**\n     * Determines if the input is a Number or something that can be coerced to a Number\n     * @protected\n     * @param {Number|String|Object|Array|Boolean|RegExp|Function|Symbol} - The input to be tested\n     * @returns {Boolean} - An indication if the input is a Number or can be coerced to a Number\n     */\n    Owl.prototype.isNumeric = function (number) {\n        return !isNaN(parseFloat(number));\n    };\n\n    /**\n     * Gets the difference of two vectors.\n     * @todo #261\n     * @protected\n     * @param {Object} - The first vector.\n     * @param {Object} - The second vector.\n     * @returns {Object} - The difference.\n     */\n    Owl.prototype.difference = function (first, second) {\n        return {\n            x: first.x - second.x,\n            y: first.y - second.y\n        };\n    };\n\n    /**\n     * The jQuery Plugin for the Owl Carousel\n     * @todo Navigation plugin `next` and `prev`\n     * @public\n     */\n    $.fn.owlCarousel = function (option) {\n        var args = Array.prototype.slice.call(arguments, 1);\n\n        return this.each(function () {\n            var $this = $(this),\n                data = $this.data('owl.carousel');\n\n            if (!data) {\n                data = new Owl(this, typeof option == 'object' && option);\n                $this.data('owl.carousel', data);\n\n                $.each([\n                    'next', 'prev', 'to', 'destroy', 'refresh', 'replace', 'add', 'remove'\n                ], function (i, event) {\n                    data.register({type: Owl.Type.Event, name: event});\n                    data.$element.on(event + '.owl.carousel.core', $.proxy(function (e) {\n                        if (e.namespace && e.relatedTarget !== this) {\n                            this.suppress([event]);\n                            data[event].apply(this, [].slice.call(arguments, 1));\n                            this.release([event]);\n                        }\n                    }, data));\n                });\n            }\n\n            if (typeof option == 'string' && option.charAt(0) !== '_') {\n                data[option].apply(data, args);\n            }\n        });\n    };\n\n    /**\n     * The constructor for the jQuery Plugin\n     * @public\n     */\n    $.fn.owlCarousel.Constructor = Owl;\n\n\n    /**\n     * AutoRefresh Plugin\n     * @version 2.3.4\n     * @author Artus Kolanowski\n     * @author David Deutsch\n     * @license The MIT License (MIT)\n     */\n\n\n    /**\n     * Creates the auto refresh plugin.\n     * @class The Auto Refresh Plugin\n     * @param {Owl} carousel - The Owl Carousel\n     */\n    var AutoRefresh = function (carousel) {\n        /**\n         * Reference to the core.\n         * @protected\n         * @type {Owl}\n         */\n        this._core = carousel;\n\n        /**\n         * Refresh interval.\n         * @protected\n         * @type {number}\n         */\n        this._interval = null;\n\n        /**\n         * Whether the element is currently visible or not.\n         * @protected\n         * @type {Boolean}\n         */\n        this._visible = null;\n\n        /**\n         * All event handlers.\n         * @protected\n         * @type {Object}\n         */\n        this._handlers = {\n            'initialized.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._core.settings.autoRefresh) {\n                    this.watch();\n                }\n            }, this)\n        };\n\n        // set default options\n        this._core.options = $.extend({}, AutoRefresh.Defaults, this._core.options);\n\n        // register event handlers\n        this._core.$element.on(this._handlers);\n    };\n\n    /**\n     * Default options.\n     * @public\n     */\n    AutoRefresh.Defaults = {\n        autoRefresh: true,\n        autoRefreshInterval: 500\n    };\n\n    /**\n     * Watches the element.\n     */\n    AutoRefresh.prototype.watch = function () {\n        if (this._interval) {\n            return;\n        }\n\n        this._visible = this._core.isVisible();\n        this._interval = window.setInterval($.proxy(this.refresh, this), this._core.settings.autoRefreshInterval);\n    };\n\n    /**\n     * Refreshes the element.\n     */\n    AutoRefresh.prototype.refresh = function () {\n        if (this._core.isVisible() === this._visible) {\n            return;\n        }\n\n        this._visible = !this._visible;\n\n        this._core.$element.toggleClass('owl-hidden', !this._visible);\n\n        this._visible && (this._core.invalidate('width') && this._core.refresh());\n    };\n\n    /**\n     * Destroys the plugin.\n     */\n    AutoRefresh.prototype.destroy = function () {\n        var handler, property;\n\n        window.clearInterval(this._interval);\n\n        for (handler in this._handlers) {\n            this._core.$element.off(handler, this._handlers[handler]);\n        }\n        for (property in Object.getOwnPropertyNames(this)) {\n            typeof this[property] != 'function' && (this[property] = null);\n        }\n    };\n\n    $.fn.owlCarousel.Constructor.Plugins.AutoRefresh = AutoRefresh;\n\n\n    /**\n     * Lazy Plugin\n     * @version 2.3.4\n     * @author Bartosz Wojciechowski\n     * @author David Deutsch\n     * @license The MIT License (MIT)\n     */\n\n\n    /**\n     * Creates the lazy plugin.\n     * @class The Lazy Plugin\n     * @param {Owl} carousel - The Owl Carousel\n     */\n    var Lazy = function (carousel) {\n\n        /**\n         * Reference to the core.\n         * @protected\n         * @type {Owl}\n         */\n        this._core = carousel;\n\n        /**\n         * Already loaded items.\n         * @protected\n         * @type {Array.<jQuery>}\n         */\n        this._loaded = [];\n\n        /**\n         * Event handlers.\n         * @protected\n         * @type {Object}\n         */\n        this._handlers = {\n            'initialized.owl.carousel change.owl.carousel resized.owl.carousel': $.proxy(function (e) {\n                if (!e.namespace) {\n                    return;\n                }\n\n                if (!this._core.settings || !this._core.settings.lazyLoad) {\n                    return;\n                }\n\n                if ((e.property && e.property.name === 'position') || e.type === 'initialized' || e.type === 'resized') {\n                    var settings = this._core.settings,\n                        n = (settings.center && Math.ceil(settings.items / 2) || settings.items),\n                        i = ((settings.center && n * -1) || 0),\n                        position = (e.property && e.property.value !== undefined ? e.property.value : this._core.current()) + i,\n                        clones = this._core.clones().length,\n                        load = $.proxy(function (i, v) {\n                            this.load(v)\n                        }, this);\n                    //TODO: Need documentation for this new option\n                    if (settings.lazyLoadEager > 0) {\n                        n += settings.lazyLoadEager;\n                        // If the carousel is looping also preload images that are to the \"left\"\n                        if (settings.loop) {\n                            position -= settings.lazyLoadEager;\n                            n++;\n                        }\n                    }\n\n                    if (!settings.center && settings.stagePadding) {\n                        position--;\n                        n += 2;\n                    }\n\n                    while (i++ < n) {\n                        this.load(clones / 2 + this._core.relative(position));\n                        clones && $.each(this._core.clones(this._core.relative(position)), load);\n                        position++;\n                    }\n                }\n            }, this)\n        };\n\n        // set the default options\n        this._core.options = $.extend({}, Lazy.Defaults, this._core.options);\n\n        // register event handler\n        this._core.$element.on(this._handlers);\n    };\n\n    /**\n     * Animate Plugin\n     * @version 2.3.4\n     * @author Bartosz Wojciechowski\n     * @author David Deutsch\n     * @license The MIT License (MIT)\n     */\n\n\n    /**\n     * Creates the animate plugin.\n     * @class The Navigation Plugin\n     * @param {Owl} scope - The Owl Carousel\n     */\n    var Animate = function (scope) {\n        this.core = scope;\n        this.core.options = $.extend({}, Animate.Defaults, this.core.options);\n        this.swapping = true;\n        this.previous = undefined;\n        this.next = undefined;\n\n        this.handlers = {\n            'change.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && e.property.name == 'position') {\n                    this.previous = this.core.current();\n                    this.next = e.property.value;\n                }\n            }, this),\n            'drag.owl.carousel dragged.owl.carousel translated.owl.carousel': $.proxy(function (e) {\n                if (e.namespace) {\n                    this.swapping = e.type == 'translated';\n                }\n            }, this),\n            'translate.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this.swapping && (this.core.options.animateOut || this.core.options.animateIn)) {\n                    this.swap();\n                }\n            }, this)\n        };\n\n        this.core.$element.on(this.handlers);\n    };\n\n    /**\n     * Default options.\n     * @public\n     */\n    Animate.Defaults = {\n        animateOut: false,\n        animateIn: false\n    };\n\n    /**\n     * Toggles the animation classes whenever an translations starts.\n     * @protected\n     * @returns {Boolean|undefined}\n     */\n    Animate.prototype.swap = function () {\n\n        if (this.core.settings.items !== 1) {\n            return;\n        }\n\n        if (!$.support.animation || !$.support.transition) {\n            return;\n        }\n\n        this.core.speed(0);\n\n        var left,\n            clear = $.proxy(this.clear, this),\n            previous = this.core.$stage.children().eq(this.previous),\n            next = this.core.$stage.children().eq(this.next),\n            incoming = this.core.settings.animateIn,\n            outgoing = this.core.settings.animateOut;\n\n        if (this.core.current() === this.previous) {\n            return;\n        }\n\n        if (outgoing) {\n            left = this.core.coordinates(this.previous) - this.core.coordinates(this.next);\n            previous.one($.support.animation.end, clear)\n                .css({'left': left + 'px'})\n                .addClass('animated owl-animated-out')\n                .addClass(outgoing);\n        }\n\n        if (incoming) {\n            next.one($.support.animation.end, clear)\n                .addClass('animated owl-animated-in')\n                .addClass(incoming);\n        }\n    };\n\n    Animate.prototype.clear = function (e) {\n        $(e.target).css({'left': ''})\n            .removeClass('animated owl-animated-out owl-animated-in')\n            .removeClass(this.core.settings.animateIn)\n            .removeClass(this.core.settings.animateOut);\n        this.core.onTransitionEnd();\n    };\n\n    /**\n     * Destroys the plugin.\n     * @public\n     */\n    Animate.prototype.destroy = function () {\n        var handler, property;\n\n        for (handler in this.handlers) {\n            this.core.$element.off(handler, this.handlers[handler]);\n        }\n        for (property in Object.getOwnPropertyNames(this)) {\n            typeof this[property] != 'function' && (this[property] = null);\n        }\n    };\n\n    $.fn.owlCarousel.Constructor.Plugins.Animate = Animate;\n\n\n    /**\n     * Autoplay Plugin\n     * @version 2.3.4\n     * @author Bartosz Wojciechowski\n     * @author Artus Kolanowski\n     * @author David Deutsch\n     * @author Tom De Caluw\u00e9\n     * @license The MIT License (MIT)\n     */\n\n\n    /**\n     * Creates the autoplay plugin.\n     * @class The Autoplay Plugin\n     * @param {Owl} scope - The Owl Carousel\n     */\n    var Autoplay = function (carousel) {\n        /**\n         * Reference to the core.\n         * @protected\n         * @type {Owl}\n         */\n        this._core = carousel;\n\n        /**\n         * The autoplay timeout id.\n         * @type {Number}\n         */\n        this._call = null;\n\n        /**\n         * Depending on the state of the plugin, this variable contains either\n         * the start time of the timer or the current timer value if it's\n         * paused. Since we start in a paused state we initialize the timer\n         * value.\n         * @type {Number}\n         */\n        this._time = 0;\n\n        /**\n         * Stores the timeout currently used.\n         * @type {Number}\n         */\n        this._timeout = 0;\n\n        /**\n         * Indicates whenever the autoplay is paused.\n         * @type {Boolean}\n         */\n        this._paused = true;\n\n        /**\n         * All event handlers.\n         * @protected\n         * @type {Object}\n         */\n        this._handlers = {\n            'changed.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && e.property.name === 'settings') {\n                    if (this._core.settings.autoplay) {\n                        this.play();\n                    } else {\n                        this.stop();\n                    }\n                } else if (e.namespace && e.property.name === 'position' && this._paused) {\n                    // Reset the timer. This code is triggered when the position\n                    // of the carousel was changed through user interaction.\n                    this._time = 0;\n                }\n            }, this),\n            'initialized.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._core.settings.autoplay) {\n                    this.play();\n                }\n            }, this),\n            'play.owl.autoplay': $.proxy(function (e, t, s) {\n                if (e.namespace) {\n                    this.play(t, s);\n                }\n            }, this),\n            'stop.owl.autoplay': $.proxy(function (e) {\n                if (e.namespace) {\n                    this.stop();\n                }\n            }, this),\n            'mouseover.owl.autoplay': $.proxy(function () {\n                if (this._core.settings.autoplayHoverPause && this._core.is('rotating')) {\n                    this.pause();\n                }\n            }, this),\n            'mouseleave.owl.autoplay': $.proxy(function () {\n                if (this._core.settings.autoplayHoverPause && this._core.is('rotating')) {\n                    this.play();\n                }\n            }, this),\n            'touchstart.owl.core': $.proxy(function () {\n                if (this._core.settings.autoplayHoverPause && this._core.is('rotating')) {\n                    this.pause();\n                }\n            }, this),\n            'touchend.owl.core': $.proxy(function () {\n                if (this._core.settings.autoplayHoverPause) {\n                    this.play();\n                }\n            }, this)\n        };\n\n        var eventPassive = ['wheel', 'scroll', 'touchstart', 'touchmove', 'mousewheel'];\n        $.each(eventPassive, function (index, event) {\n            $.event.special[event] = {\n                setup: function (_, ns, handle) {\n                    this.addEventListener(event, handle, {passive: !!ns.indexOf('noPreventDefault')});\n                }\n            };\n        });\n\n        // register event handlers\n        this._core.$element.on(this._handlers);\n\n        // set default options\n        this._core.options = $.extend({}, Autoplay.Defaults, this._core.options);\n    };\n\n    /**\n     * Default options.\n     * @public\n     */\n    Autoplay.Defaults = {\n        autoplay: false,\n        autoplayTimeout: 5000,\n        autoplayHoverPause: false,\n        autoplaySpeed: false\n    };\n\n    /**\n     * Transition to the next slide and set a timeout for the next transition.\n     * @private\n     * @param {Number} [speed] - The animation speed for the animations.\n     */\n    Autoplay.prototype._next = function (speed) {\n        this._call = window.setTimeout(\n            $.proxy(this._next, this, speed),\n            this._timeout * (Math.round(this.read() / this._timeout) + 1) - this.read()\n        );\n\n        if (this._core.is('interacting') || document.hidden) {\n            return;\n        }\n        this._core.next(speed || this._core.settings.autoplaySpeed);\n    }\n\n    /**\n     * Reads the current timer value when the timer is playing.\n     * @public\n     */\n    Autoplay.prototype.read = function () {\n        return new Date().getTime() - this._time;\n    };\n\n    /**\n     * Starts the autoplay.\n     * @public\n     * @param {Number} [timeout] - The interval before the next animation starts.\n     * @param {Number} [speed] - The animation speed for the animations.\n     */\n    Autoplay.prototype.play = function (timeout, speed) {\n        var elapsed;\n\n        if (!this._core.is('rotating')) {\n            this._core.enter('rotating');\n        }\n\n        timeout = timeout || this._core.settings.autoplayTimeout;\n\n        // Calculate the elapsed time since the last transition. If the carousel\n        // wasn't playing this calculation will yield zero.\n        elapsed = Math.min(this._time % (this._timeout || timeout), timeout);\n\n        if (this._paused) {\n            // Start the clock.\n            this._time = this.read();\n            this._paused = false;\n        } else {\n            // Clear the active timeout to allow replacement.\n            window.clearTimeout(this._call);\n        }\n\n        // Adjust the origin of the timer to match the new timeout value.\n        this._time += this.read() % timeout - elapsed;\n\n        this._timeout = timeout;\n        this._call = window.setTimeout($.proxy(this._next, this, speed), timeout - elapsed);\n    };\n\n    /**\n     * Stops the autoplay.\n     * @public\n     */\n    Autoplay.prototype.stop = function () {\n        if (this._core.is('rotating')) {\n            // Reset the clock.\n            this._time = 0;\n            this._paused = true;\n\n            window.clearTimeout(this._call);\n            this._core.leave('rotating');\n        }\n    };\n\n    /**\n     * Pauses the autoplay.\n     * @public\n     */\n    Autoplay.prototype.pause = function () {\n        if (this._core.is('rotating') && !this._paused) {\n            // Pause the clock.\n            this._time = this.read();\n            this._paused = true;\n\n            window.clearTimeout(this._call);\n        }\n    };\n\n    /**\n     * Destroys the plugin.\n     */\n    Autoplay.prototype.destroy = function () {\n        var handler, property;\n\n        this.stop();\n\n        for (handler in this._handlers) {\n            this._core.$element.off(handler, this._handlers[handler]);\n        }\n        for (property in Object.getOwnPropertyNames(this)) {\n            typeof this[property] != 'function' && (this[property] = null);\n        }\n    };\n\n    $.fn.owlCarousel.Constructor.Plugins.autoplay = Autoplay;\n\n\n    /**\n     * Navigation Plugin\n     * @version 2.3.4\n     * @author Artus Kolanowski\n     * @author David Deutsch\n     * @license The MIT License (MIT)\n     */\n\n\n    /**\n     * Creates the navigation plugin.\n     * @class The Navigation Plugin\n     * @param {Owl} carousel - The Owl Carousel.\n     */\n    var Navigation = function (carousel) {\n        /**\n         * Reference to the core.\n         * @protected\n         * @type {Owl}\n         */\n        this._core = carousel;\n\n        /**\n         * Indicates whether the plugin is initialized or not.\n         * @protected\n         * @type {Boolean}\n         */\n        this._initialized = false;\n\n        /**\n         * The current paging indexes.\n         * @protected\n         * @type {Array}\n         */\n        this._pages = [];\n\n        /**\n         * All DOM elements of the user interface.\n         * @protected\n         * @type {Object}\n         */\n        this._controls = {};\n\n        /**\n         * Markup for an indicator.\n         * @protected\n         * @type {Array.<String>}\n         */\n        this._templates = [];\n\n        /**\n         * The carousel element.\n         * @type {jQuery}\n         */\n        this.$element = this._core.$element;\n\n        /**\n         * Overridden methods of the carousel.\n         * @protected\n         * @type {Object}\n         */\n        this._overrides = {\n            next: this._core.next,\n            prev: this._core.prev,\n            to: this._core.to\n        };\n\n        /**\n         * All event handlers.\n         * @protected\n         * @type {Object}\n         */\n        this._handlers = {\n            'prepared.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._core.settings.dotsData) {\n                    this._templates.push('<div class=\"' + this._core.settings.dotClass + '\">' +\n                        $(e.content).find('[data-dot]').addBack('[data-dot]').attr('data-dot') + '</div>');\n                }\n            }, this),\n            'added.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._core.settings.dotsData) {\n                    this._templates.splice(e.position, 0, this._templates.pop());\n                }\n            }, this),\n            'remove.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._core.settings.dotsData) {\n                    this._templates.splice(e.position, 1);\n                }\n            }, this),\n            'changed.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && e.property.name == 'position') {\n                    this.draw();\n                }\n            }, this),\n            'initialized.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && !this._initialized) {\n                    this._core.trigger('initialize', null, 'navigation');\n                    this.initialize();\n                    this.update();\n                    this.draw();\n                    this._initialized = true;\n                    this._core.trigger('initialized', null, 'navigation');\n                }\n            }, this),\n            'refreshed.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._initialized) {\n                    this._core.trigger('refresh', null, 'navigation');\n                    this.update();\n                    this.draw();\n                    this._core.trigger('refreshed', null, 'navigation');\n                }\n            }, this)\n        };\n\n        // set default options\n        this._core.options = $.extend({}, Navigation.Defaults, this._core.options);\n\n        // register event handlers\n        this.$element.on(this._handlers);\n    };\n\n    /**\n     * Default options.\n     * @public\n     * @todo Rename `slideBy` to `navBy`\n     */\n    Navigation.Defaults = {\n        nav: false,\n        navText: [\n            '<span aria-label=\"' + 'Previous' + '\">&#x2039;</span>',\n            '<span aria-label=\"' + 'Next' + '\">&#x203a;</span>'\n        ],\n        navSpeed: false,\n        navElement: 'button type=\"button\" role=\"presentation\"',\n        navContainer: false,\n        navContainerClass: 'owl-nav',\n        navClass: [\n            'owl-prev',\n            'owl-next'\n        ],\n        slideBy: 1,\n        dotClass: 'owl-dot',\n        dotsClass: 'owl-dots',\n        dots: true,\n        dotsEach: false,\n        dotsData: false,\n        dotsSpeed: false,\n        dotsContainer: false\n    };\n\n    /**\n     * Initializes the layout of the plugin and extends the carousel.\n     * @protected\n     */\n    Navigation.prototype.initialize = function () {\n        var override,\n            settings = this._core.settings;\n\n        // create DOM structure for relative navigation\n        this._controls.$relative = (settings.navContainer ? $(settings.navContainer)\n            : $('<div>').addClass(settings.navContainerClass).appendTo(this.$element)).addClass('disabled');\n\n        this._controls.$previous = $('<' + settings.navElement + '>')\n            .addClass(settings.navClass[0])\n            .attr('aria-label', 'previous')\n            .html(settings.navText[0])\n            .prependTo(this._controls.$relative)\n            .on('click', $.proxy(function (e) {\n                this.prev(settings.navSpeed);\n            }, this));\n        this._controls.$next = $('<' + settings.navElement + '>')\n            .addClass(settings.navClass[1])\n            .attr('aria-label', 'next')\n            .html(settings.navText[1])\n            .appendTo(this._controls.$relative)\n            .on('click', $.proxy(function (e) {\n                this.next(settings.navSpeed);\n            }, this));\n\n        // create DOM structure for absolute navigation\n        if (!settings.dotsData) {\n            this._templates = [$('<button type=\"button\" aria-label=\"dot\">')\n                .addClass(settings.dotClass)\n                .append($('<span>'))\n                .prop('outerHTML')];\n        }\n\n        this._controls.$absolute = (settings.dotsContainer ? $(settings.dotsContainer)\n            : $('<div>').addClass(settings.dotsClass).appendTo(this.$element)).addClass('disabled');\n\n        this._controls.$absolute.on('click', 'button', $.proxy(function (e) {\n            var index = $(e.target).parent().is(this._controls.$absolute)\n                ? $(e.target).index() : $(e.target).parent().index();\n\n            e.preventDefault();\n\n            this.to(index, settings.dotsSpeed);\n        }, this));\n\n        /*$el.on('focusin', function() {\n            $(document).off(\".carousel\");\n\n            $(document).on('keydown.carousel', function(e) {\n                if(e.keyCode == 37) {\n                    $el.trigger('prev.owl')\n                }\n                if(e.keyCode == 39) {\n                    $el.trigger('next.owl')\n                }\n            });\n        });*/\n\n        // override public methods of the carousel\n        for (override in this._overrides) {\n            this._core[override] = $.proxy(this[override], this);\n        }\n    };\n\n    /**\n     * Destroys the plugin.\n     * @protected\n     */\n    Navigation.prototype.destroy = function () {\n        var handler, control, property, override, settings;\n        settings = this._core.settings;\n\n        for (handler in this._handlers) {\n            this.$element.off(handler, this._handlers[handler]);\n        }\n        for (control in this._controls) {\n            if (control === '$relative' && settings.navContainer) {\n                this._controls[control].html('');\n            } else {\n                this._controls[control].remove();\n            }\n        }\n        for (override in this.overides) {\n            this._core[override] = this._overrides[override];\n        }\n        for (property in Object.getOwnPropertyNames(this)) {\n            typeof this[property] != 'function' && (this[property] = null);\n        }\n    };\n\n    /**\n     * Updates the internal state.\n     * @protected\n     */\n    Navigation.prototype.update = function () {\n        var i, j, k,\n            lower = this._core.clones().length / 2,\n            upper = lower + this._core.items().length,\n            maximum = this._core.maximum(true),\n            settings = this._core.settings,\n            size = settings.center || settings.autoWidth || settings.dotsData\n                ? 1 : settings.dotsEach || settings.items;\n\n        if (settings.slideBy !== 'page') {\n            settings.slideBy = Math.min(settings.slideBy, settings.items);\n        }\n\n        if (settings.dots || settings.slideBy == 'page') {\n            this._pages = [];\n\n            for (i = lower, j = 0, k = 0; i < upper; i++) {\n                if (j >= size || j === 0) {\n                    this._pages.push({\n                        start: Math.min(maximum, i - lower),\n                        end: i - lower + size - 1\n                    });\n                    if (Math.min(maximum, i - lower) === maximum) {\n                        break;\n                    }\n                    j = 0, ++k;\n                }\n                j += this._core.mergers(this._core.relative(i));\n            }\n        }\n    };\n\n    /**\n     * Draws the user interface.\n     * @todo The option `dotsData` wont work.\n     * @protected\n     */\n    Navigation.prototype.draw = function () {\n        var difference,\n            settings = this._core.settings,\n            disabled = this._core.items().length <= settings.items,\n            index = this._core.relative(this._core.current()),\n            loop = settings.loop || settings.rewind;\n\n        this._controls.$relative.toggleClass('disabled', !settings.nav || disabled);\n\n        if (settings.nav) {\n            this._controls.$previous.toggleClass('disabled', !loop && index <= this._core.minimum(true));\n            this._controls.$next.toggleClass('disabled', !loop && index >= this._core.maximum(true));\n        }\n\n        this._controls.$absolute.toggleClass('disabled', !settings.dots || disabled);\n\n        if (settings.dots) {\n            difference = this._pages.length - this._controls.$absolute.children().length;\n\n            if (settings.dotsData && difference !== 0) {\n                this._controls.$absolute.html(this._templates.join(''));\n            } else if (difference > 0) {\n                this._controls.$absolute.append(new Array(difference + 1).join(this._templates[0]));\n            } else if (difference < 0) {\n                this._controls.$absolute.children().slice(difference).remove();\n            }\n\n            this._controls.$absolute.find('.active').removeClass('active');\n            this._controls.$absolute.children().eq($.inArray(this.current(), this._pages)).addClass('active');\n        }\n    };\n\n    /**\n     * Extends event data.\n     * @protected\n     * @param {Event} event - The event object which gets thrown.\n     */\n    Navigation.prototype.onTrigger = function (event) {\n        var settings = this._core.settings;\n\n        event.page = {\n            index: $.inArray(this.current(), this._pages),\n            count: this._pages.length,\n            size: settings && (settings.center || settings.autoWidth || settings.dotsData\n                ? 1 : settings.dotsEach || settings.items)\n        };\n    };\n\n    /**\n     * Gets the current page position of the carousel.\n     * @protected\n     * @returns {Number}\n     */\n    Navigation.prototype.current = function () {\n        var current = this._core.relative(this._core.current());\n        return $.grep(this._pages, $.proxy(function (page, index) {\n            return page.start <= current && page.end >= current;\n        }, this)).pop();\n    };\n\n    /**\n     * Gets the current succesor/predecessor position.\n     * @protected\n     * @returns {Number}\n     */\n    Navigation.prototype.getPosition = function (successor) {\n        var position, length,\n            settings = this._core.settings;\n\n        if (settings.slideBy == 'page') {\n            position = this._core.relative(this._core.current());\n            successor ? position += settings.items : position -= settings.items;\n        } else {\n            position = this._core.relative(this._core.current());\n            length = this._core.items().length;\n            successor ? position += settings.slideBy : position -= settings.slideBy;\n        }\n\n        return position;\n    };\n\n    /**\n     * Slides to the next item or page.\n     * @public\n     * @param {Number} [speed=false] - The time in milliseconds for the transition.\n     */\n    Navigation.prototype.next = function (speed) {\n        $.proxy(this._overrides.to, this._core)(this.getPosition(true), speed);\n    };\n\n    /**\n     * Slides to the previous item or page.\n     * @public\n     * @param {Number} [speed=false] - The time in milliseconds for the transition.\n     */\n    Navigation.prototype.prev = function (speed) {\n        $.proxy(this._overrides.to, this._core)(this.getPosition(false), speed);\n    };\n\n    /**\n     * Slides to the specified item or page.\n     * @public\n     * @param {Number} position - The position of the item or page.\n     * @param {Number} [speed] - The time in milliseconds for the transition.\n     * @param {Boolean} [standard=false] - Whether to use the standard behaviour or not.\n     */\n    Navigation.prototype.to = function (position, speed, standard) {\n        var length;\n\n        if (!standard && this._pages.length) {\n            length = this._pages.length;\n            $.proxy(this._overrides.to, this._core)(this._pages[((position % length) + length) % length].start, speed);\n        } else {\n            $.proxy(this._overrides.to, this._core)(position, speed);\n        }\n    };\n\n    $.fn.owlCarousel.Constructor.Plugins.Navigation = Navigation;\n\n\n    /**\n     * Hash Plugin\n     * @version 2.3.4\n     * @author Artus Kolanowski\n     * @author David Deutsch\n     * @license The MIT License (MIT)\n     */\n\n\n    /**\n     * Creates the hash plugin.\n     * @class The Hash Plugin\n     * @param {Owl} carousel - The Owl Carousel\n     */\n    var Hash = function (carousel) {\n        /**\n         * Reference to the core.\n         * @protected\n         * @type {Owl}\n         */\n        this._core = carousel;\n\n        /**\n         * Hash index for the items.\n         * @protected\n         * @type {Object}\n         */\n        this._hashes = {};\n\n        /**\n         * The carousel element.\n         * @type {jQuery}\n         */\n        this.$element = this._core.$element;\n\n        /**\n         * All event handlers.\n         * @protected\n         * @type {Object}\n         */\n        this._handlers = {\n            'initialized.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._core.settings.startPosition === 'URLHash') {\n                    $(window).trigger('hashchange.owl.navigation');\n                }\n            }, this),\n            'prepared.owl.carousel': $.proxy(function (e) {\n                if (e.namespace) {\n                    var hash = $(e.content).find('[data-hash]').addBack('[data-hash]').attr('data-hash');\n\n                    if (!hash) {\n                        return;\n                    }\n\n                    this._hashes[hash] = e.content;\n                }\n            }, this),\n            'changed.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && e.property.name === 'position') {\n                    var current = this._core.items(this._core.relative(this._core.current())),\n                        hash = $.map(this._hashes, function (item, hash) {\n                            return item === current ? hash : null;\n                        }).join();\n\n                    if (!hash || window.location.hash.slice(1) === hash) {\n                        return;\n                    }\n\n                    window.location.hash = hash;\n                }\n            }, this)\n        };\n\n        // set default options\n        this._core.options = $.extend({}, Hash.Defaults, this._core.options);\n\n        // register the event handlers\n        this.$element.on(this._handlers);\n\n        // register event listener for hash navigation\n        $(window).on('hashchange.owl.navigation', $.proxy(function (e) {\n            var hash = window.location.hash.substring(1),\n                items = this._core.$stage.children(),\n                position = this._hashes[hash] && items.index(this._hashes[hash]);\n\n            if (position === undefined || position === this._core.current()) {\n                return;\n            }\n\n            this._core.to(this._core.relative(position), false, true);\n        }, this));\n    };\n\n    /**\n     * Default options.\n     * @public\n     */\n    Hash.Defaults = {\n        URLhashListener: false\n    };\n\n    /**\n     * Destroys the plugin.\n     * @public\n     */\n    Hash.prototype.destroy = function () {\n        var handler, property;\n\n        $(window).off('hashchange.owl.navigation');\n\n        for (handler in this._handlers) {\n            this._core.$element.off(handler, this._handlers[handler]);\n        }\n        for (property in Object.getOwnPropertyNames(this)) {\n            typeof this[property] != 'function' && (this[property] = null);\n        }\n    };\n\n    $.fn.owlCarousel.Constructor.Plugins.Hash = Hash;\n\n\n    /**\n     * Support Plugin\n     *\n     * @version 2.3.4\n     * @author Vivid Planet Software GmbH\n     * @author Artus Kolanowski\n     * @author David Deutsch\n     * @license The MIT License (MIT)\n     */\n\n\n    var style = $('<support>').get(0).style,\n        prefixes = 'Webkit Moz O ms'.split(' '),\n        events = {\n            transition: {\n                end: {\n                    WebkitTransition: 'webkitTransitionEnd',\n                    MozTransition: 'transitionend',\n                    OTransition: 'oTransitionEnd',\n                    transition: 'transitionend'\n                }\n            },\n            animation: {\n                end: {\n                    WebkitAnimation: 'webkitAnimationEnd',\n                    MozAnimation: 'animationend',\n                    OAnimation: 'oAnimationEnd',\n                    animation: 'animationend'\n                }\n            }\n        },\n        tests = {\n            csstransforms: function () {\n                return !!test('transform');\n            },\n            csstransforms3d: function () {\n                return !!test('perspective');\n            },\n            csstransitions: function () {\n                return !!test('transition');\n            },\n            cssanimations: function () {\n                return !!test('animation');\n            }\n        };\n\n    function test(property, prefixed) {\n        var result = false,\n            upper = property.charAt(0).toUpperCase() + property.slice(1);\n\n        $.each((property + ' ' + prefixes.join(upper + ' ') + upper).split(' '), function (i, property) {\n            if (style[property] !== undefined) {\n                result = prefixed ? property : true;\n                return false;\n            }\n        });\n\n        return result;\n    }\n\n    function prefixed(property) {\n        return test(property, true);\n    }\n\n    if (tests.csstransitions()) {\n        /* jshint -W053 */\n        $.support.transition = new String(prefixed('transition'))\n        $.support.transition.end = events.transition.end[$.support.transition];\n    }\n\n    if (tests.cssanimations()) {\n        /* jshint -W053 */\n        $.support.animation = new String(prefixed('animation'))\n        $.support.animation.end = events.animation.end[$.support.animation];\n    }\n\n    if (tests.csstransforms()) {\n        /* jshint -W053 */\n        $.support.transform = new String(prefixed('transform'));\n        $.support.transform3d = tests.csstransforms3d();\n    }\n\n}));\n","MageBig_WidgetPlus/js/jcountdown.js":"/*! jCountdown jQuery Plugin - v2.0.1 - 2015-10-18\r\n* https://github.com/tomgrohl/jCountdown/\r\n* Copyright (c) 2015 Tom Ellis; Licensed MIT */\r\n(function (factory) {\r\n    if (typeof define === 'function' && define.amd) {\r\n        define([\"jquery\"], factory);\r\n    } else {\r\n        factory(jQuery);\r\n    }\r\n}(function ($) {\r\n\r\n$.fn.countdown = function( method /*, options*/ ) {\r\n\r\n    var msPerHr = 3600000,\r\n        secPerYear = 31557600,\r\n        secPerMonth = 2629800,\r\n        secPerWeek = 604800,\r\n        secPerDay = 86400,\r\n        secPerHr = 3600,\r\n        secPerMin = 60,\r\n        secPerSec = 1,\r\n        rTemplateTokens = /%y|%m|%w|%d|%h|%i|%s|%ty|%tm|%tw|%td|%th|%ti|%ts/g,\r\n        rDigitGlobal = /\\d/g,\r\n        localNumber = function( numToConvert, settings ) {\r\n\r\n            var arr = numToConvert.toString().match(rDigitGlobal),\r\n                localeNumber = \"\";\r\n\r\n            $.each( arr, function(i,num) {\r\n                num = Number(num);\r\n                localeNumber += (\"\"+ settings.digits[num]) || \"\"+num;\r\n            });\r\n\r\n            return localeNumber;\r\n        },\r\n        dateNow = function( $this ) {\r\n            var now = new Date(), // Default to local time\r\n                settings = $this.data(\"jcdData\");\r\n\r\n            if ( !settings ) {\r\n                return new Date();\r\n            }\r\n\r\n            if ( settings.offset !== null ) {\r\n                now = getTimezoneDate( settings.offset );\r\n            }\r\n\r\n            now.setMilliseconds(0);\r\n            return now;\r\n        },\r\n        getTimezoneDate = function( offset ) {\r\n            // Returns date now based on timezone/offset\r\n            var hrs,\r\n                dateMS,\r\n                curHrs,\r\n                tmpDate = new Date();\r\n\r\n            if ( offset !== null ) {\r\n                hrs = offset * msPerHr;\r\n                curHrs = tmpDate.getTime() - ( ( -tmpDate.getTimezoneOffset() / 60 ) * msPerHr ) + hrs;\r\n                dateMS = tmpDate.setTime( curHrs );\r\n            }\r\n\r\n            return new Date( dateMS );\r\n        },\r\n        addEventHandlers = function($element, options) {\r\n\r\n            // Add event handlers where set\r\n            if ( options.onStart ) {\r\n                $element.on(\"start.jcdevt\", options.onStart );\r\n            }\r\n\r\n            if ( options.onChange ) {\r\n                $element.on(\"change.jcdevt\", options.onChange );\r\n            }\r\n\r\n            if ( options.onComplete ) {\r\n                $element.on(\"complete.jcdevt\", options.onComplete );\r\n            }\r\n\r\n            if ( options.onPause ) {\r\n                $element.on(\"pause.jcdevt\", options.onPause );\r\n            }\r\n\r\n            if ( options.onResume ) {\r\n                $element.on(\"resume.jcdevt\", options.onResume );\r\n            }\r\n\r\n            if ( options.onLocaleChange ) {\r\n                $element.on(\"locale.jcdevt\", options.onLocaleChange );\r\n            }\r\n        },\r\n\r\n        generateTemplate = function( settings ) {\r\n            var template = settings.template,\r\n                yearsLeft = settings.yearsLeft,\r\n                monthsLeft = settings.monthsLeft,\r\n                weeksLeft = settings.weeksLeft,\r\n                daysLeft = settings.daysLeft,\r\n                hrsLeft = settings.hrsLeft,\r\n                minsLeft = settings.minsLeft,\r\n                secLeft = settings.secLeft,\r\n                hideYears = false,\r\n                hideMonths = false,\r\n                hideWeeks = false,\r\n                hideDays = false,\r\n                hideHours = false,\r\n                hideMins = false;\r\n\r\n            if (settings.isRTL) {\r\n                template = settings.rtlTemplate;\r\n            }\r\n\r\n            if ( settings.omitZero ) {\r\n\r\n                if ( settings.yearsAndMonths ) {\r\n\r\n                    if( !settings.yearsLeft ) {\r\n                        hideYears = true;\r\n                    }\r\n                    if( !settings.monthsLeft ) {\r\n                        hideMonths = true;\r\n                    }\r\n                }\r\n\r\n                if ( settings.weeks && ( ( settings.yearsAndMonths && hideMonths && !settings.weeksLeft ) || ( !settings.yearsAndMonths && !settings.weeksLeft ) ) ) {\r\n                    hideWeeks = true;\r\n                }\r\n\r\n                if ( hideWeeks && !daysLeft ) {\r\n                    hideDays = true;\r\n                }\r\n\r\n                if ( hideDays && !hrsLeft ) {\r\n                    hideHours = true;\r\n                }\r\n\r\n                if ( hideHours && !minsLeft ) {\r\n                    hideMins = true;\r\n                }\r\n\r\n            }\r\n\r\n            if ( settings.leadingZero ) {\r\n\r\n                if ( yearsLeft < 10 ) {\r\n                    yearsLeft = \"0\" + yearsLeft;\r\n                }\r\n\r\n                if ( monthsLeft < 10 ) {\r\n                    monthsLeft = \"0\" + monthsLeft;\r\n                }\r\n\r\n                if ( weeksLeft < 10 ) {\r\n                    weeksLeft = \"0\" + weeksLeft;\r\n                }\r\n\r\n                if ( daysLeft < 10 ) {\r\n                    daysLeft = \"0\" + daysLeft;\r\n                }\r\n\r\n                if ( hrsLeft < 10 ) {\r\n                    hrsLeft = \"0\" + hrsLeft;\r\n                }\r\n\r\n                if ( minsLeft < 10 ) {\r\n                    minsLeft = \"0\" + minsLeft;\r\n                }\r\n\r\n                if ( secLeft < 10 ) {\r\n                    secLeft = \"0\" + secLeft;\r\n                }\r\n            }\r\n\r\n            yearsLeft = localNumber( yearsLeft, settings );\r\n            monthsLeft = localNumber( monthsLeft, settings );\r\n            weeksLeft = localNumber( weeksLeft, settings );\r\n            daysLeft = localNumber( daysLeft, settings );\r\n            hrsLeft = localNumber( hrsLeft, settings );\r\n            minsLeft = localNumber( minsLeft, settings );\r\n            secLeft = localNumber( secLeft, settings );\r\n\r\n            if ( settings.yearsAndMonths ) {\r\n\r\n                if ( !settings.omitZero || !hideYears  ) {\r\n                    template = template.replace('%y', yearsLeft);\r\n                    template = template.replace('%ty', (yearsLeft == 1 && settings.yearSingularText) ? settings.yearSingularText : settings.yearText);\r\n                }\r\n\r\n                //Only hide months if years is at 0 as well as months\r\n                if ( !settings.omitZero || ( !hideYears && monthsLeft ) || ( !hideYears && !hideMonths ) ) {\r\n                    template = template.replace('%m', monthsLeft);\r\n                    template = template.replace('%tm', (monthsLeft == 1 && settings.monthSingularText) ? settings.monthSingularText : settings.monthText);\r\n                }\r\n            }\r\n\r\n            if ( settings.weeks && !hideWeeks ) {\r\n                template = template.replace('%w', weeksLeft);\r\n                template = template.replace('%tw', (weeksLeft == 1 && settings.weekSingularText) ? settings.weekSingularText : settings.weekText);\r\n\r\n            }\r\n\r\n            if ( !hideDays ) {\r\n                template = template.replace('%d', daysLeft);\r\n                template = template.replace('%td', (daysLeft == 1 && settings.daySingularText) ? settings.daySingularText : settings.dayText);\r\n            }\r\n\r\n            if ( !hideHours ) {\r\n                template = template.replace('%h', hrsLeft);\r\n                template = template.replace('%th', (hrsLeft == 1 && settings.hourSingularText) ? settings.hourSingularText : settings.hourText);\r\n            }\r\n\r\n            if ( !hideMins ) {\r\n                template = template.replace('%i', minsLeft);\r\n                template = template.replace('%ti', (minsLeft == 1 && settings.minSingularText) ? settings.minSingularText : settings.minText);\r\n            }\r\n\r\n            template = template.replace('%s', secLeft);\r\n            template = template.replace('%ts', (secLeft == 1 && settings.secSingularText) ? settings.secSingularText : settings.secText);\r\n\r\n            // Remove un-used tokens\r\n            template = template.replace(rTemplateTokens,'');\r\n\r\n            return template;\r\n        },\r\n        updateCallback = function() {\r\n\r\n            var $this = this,\r\n                template,\r\n                now,\r\n                date,\r\n                timeLeft,\r\n                yearsLeft = 0,\r\n                monthsLeft = 0,\r\n                weeksLeft = 0,\r\n                daysLeft,\r\n                hrsLeft,\r\n                minsLeft,\r\n                secLeft,\r\n                time = \"\",\r\n                diff,\r\n                extractSection = function( numSecs ) {\r\n                    var amount;\r\n\r\n                    amount = Math.floor( diff / numSecs );\r\n                    diff -= amount * numSecs;\r\n\r\n                    return amount;\r\n                },\r\n                settings = $this.data(\"jcdData\");\r\n\r\n            // No settings so return\r\n            if ( !settings ) {\r\n                return false;\r\n            }\r\n\r\n            now = dateNow( $this );\r\n\r\n            if ( null !== settings.serverDiff ) {\r\n                date = new Date( settings.serverDiff + settings.clientdateNow.getTime() );\r\n            }\r\n            else {\r\n                date = settings.dateObj;\r\n            }\r\n\r\n            date.setMilliseconds(0);\r\n\r\n            timeLeft = ( settings.direction === \"down\" ) ? date.getTime() - now.getTime() : now.getTime() - date.getTime();\r\n\r\n            diff = Math.round( timeLeft / 1000 );\r\n\r\n            daysLeft = extractSection( secPerDay );\r\n            hrsLeft = extractSection( secPerHr );\r\n            minsLeft = extractSection( secPerMin );\r\n            secLeft = extractSection( secPerSec );\r\n\r\n            if ( settings.yearsAndMonths ) {\r\n\r\n                //Add days back on so we can calculate years easier\r\n                diff += ( daysLeft * secPerDay );\r\n\r\n                yearsLeft = extractSection( secPerYear );\r\n                monthsLeft = extractSection( secPerMonth );\r\n                daysLeft = extractSection( secPerDay );\r\n            }\r\n\r\n            if ( settings.weeks ) {\r\n                //Add days back on so we can calculate weeks easier\r\n                diff += ( daysLeft * secPerDay );\r\n\r\n                weeksLeft = extractSection( secPerWeek );\r\n                daysLeft = extractSection( secPerDay );\r\n            }\r\n\r\n            /**\r\n             * The following 3 option should never be used together!\r\n             * MAKE them work for any time\r\n             */\r\n\r\n            if ( settings.hoursOnly || settings.minsOnly || settings.secsOnly )\r\n            {\r\n\r\n                if ( settings.yearsAndMonths ) {\r\n                    //Add years, months, weeks and days back on so we can calculate dates easier\r\n                    diff += ( yearsLeft * secPerYear );\r\n                    diff += ( monthsLeft * secPerMonth );\r\n\r\n                    yearsLeft = monthsLeft = 0;\r\n                }\r\n\r\n                if ( settings.weeks ) {\r\n                    diff += ( weeksLeft * secPerWeek );\r\n\r\n                    weeksLeft = 0;\r\n                }\r\n\r\n            }\r\n\r\n            // Assumes you are using dates within a month  ( ~ 30 days )\r\n            // as years and months aren't taken into account\r\n            if ( settings.hoursOnly ) {\r\n\r\n                // Add days back on\r\n                diff += ( daysLeft * secPerDay );\r\n\r\n                // Add hours back on\r\n                diff += ( hrsLeft * secPerHr );\r\n                hrsLeft = extractSection( secPerHr );\r\n\r\n            }\r\n\r\n            // Assumes you are only using dates in the near future ( <= 24 hours )\r\n            // as years and months aren't taken into account\r\n            if ( settings.minsOnly ) {\r\n\r\n\r\n                // Add days back on\r\n                diff += ( daysLeft * secPerDay );\r\n                daysLeft = 0;\r\n\r\n                // Add hours back on\r\n                diff += ( hrsLeft * secPerHr );\r\n                hrsLeft = 0;\r\n\r\n                diff += ( minsLeft * secPerMin );\r\n\r\n                minsLeft = extractSection( secPerMin );\r\n\r\n            }\r\n\r\n            // Assumes you are only using dates in the near future ( <= 60 minutes )\r\n            // as years, months and days aren't taken into account\r\n            if ( settings.secsOnly ) {\r\n\r\n\r\n                // Add days back on\r\n                diff += ( daysLeft * secPerDay );\r\n                daysLeft = 0;\r\n\r\n                // Add hours back on\r\n                diff += ( hrsLeft * secPerHr );\r\n                hrsLeft = 0;\r\n\r\n                // Add minutes back on\r\n                diff += ( minsLeft * secPerMin );\r\n                minsLeft = 0;\r\n\r\n                // Add seconds back on\r\n                diff += secLeft;\r\n\r\n                secLeft = extractSection( secPerSec );\r\n            }\r\n\r\n            settings.yearsLeft = yearsLeft;\r\n            settings.monthsLeft = monthsLeft;\r\n            settings.weeksLeft = weeksLeft;\r\n            settings.daysLeft = daysLeft;\r\n            settings.hrsLeft = hrsLeft;\r\n            settings.minsLeft = minsLeft;\r\n            settings.secLeft = secLeft;\r\n\r\n            $this.data(\"jcdData\", settings);\r\n\r\n            // Check if the countdown has finished\r\n            // We've got the time sections set so we can now do the templating\r\n\r\n            if ( ( settings.direction === \"down\" && ( now < date || settings.minus ) ) || ( settings.direction === \"up\" && ( date < now || settings.minus )  ) ) {\r\n                time = generateTemplate( settings );\r\n            }\r\n            else {\r\n                settings.yearsLeft = settings.monthsLeft = settings.weeksLeft = settings.daysLeft = settings.hrsLeft = settings.minsLeft = settings.secLeft = 0;\r\n\r\n                time = generateTemplate( settings );\r\n                settings.hasCompleted = true;\r\n            }\r\n\r\n            $this.html( time ).triggerMulti(\"change.jcdevt,countChange\", [settings]);\r\n\r\n            if ( settings.hasCompleted ) {\r\n                $this.triggerMulti(\"complete.jcdevt,countComplete\");\r\n                clearInterval( settings.timer );\r\n            }\r\n\r\n        },\r\n        methods = {\r\n            init: function( options ) {\r\n                var opts = $.extend( {}, $.fn.countdown.defaults, options ),\r\n                    testDate,\r\n                    testString,\r\n                    settings = {};\r\n\r\n                return this.each(function() {\r\n\r\n                    var $this = $(this),\r\n                        intervalCallback;\r\n\r\n                    // If this element already has a countdown timer\r\n                    // just change the settings\r\n                    if ( $this.data(\"jcdData\") ) {\r\n                        $this.countdown(\"changeSettings\", options, true);\r\n                        opts = $this.data(\"jcdData\");\r\n                    }\r\n\r\n                    if ( opts.date === null && opts.dataAttr === null ) {\r\n                        $.error(\"No Date passed to jCountdown. date option is required.\");\r\n                        return true;\r\n                    }\r\n\r\n                    if ( opts.date ) {\r\n                        testString = opts.date;\r\n                    } else {\r\n                        testString = $this.attr('data-' + opts.dataAttr);\r\n                    }\r\n\r\n                    testDate = new Date(testString);\r\n\r\n                    if( testDate.toString() === \"Invalid Date\" ) {\r\n                        $.error(\"Invalid Date passed to jCountdown: \" + testString);\r\n                    }\r\n\r\n                    // Setup any event handlers\r\n                    addEventHandlers($this, options);\r\n\r\n                    // Create a settings object based off the plugin options\r\n                    settings = $.extend({}, opts);\r\n\r\n                    // Cache DOM elements for templating\r\n                    settings.dom = {};\r\n\r\n                    settings.dom.$time = $(\"<\"+settings.timeWrapElement+\">\").addClass(settings.timeWrapClass);\r\n                    settings.dom.$text = $(\"<\"+settings.textWrapElement+\">\").addClass(settings.textWrapClass);\r\n\r\n                    settings.clientdateNow = new Date();\r\n                    settings.clientdateNow.setMilliseconds(0);\r\n                    settings.originalHTML = $this.html();\r\n                    settings.dateObj = new Date( testString );\r\n                    settings.dateObj.setMilliseconds(0);\r\n                    settings.hasCompleted = false;\r\n                    settings.timer = 0;\r\n                    settings.yearsLeft = settings.monthsLeft = settings.weeksLeft = settings.daysLeft = settings.hrsLeft = settings.minsLeft = settings.secLeft = 0;\r\n                    settings.difference = null;\r\n\r\n                    // Create a callback for the interval\r\n                    intervalCallback = $.proxy(updateCallback, $this);\r\n                    settings.timer = setInterval(intervalCallback, settings.updateTime);\r\n\r\n                    $this.data(\"jcdData\", settings).triggerMulti(\"start.jcdevt,countStart\", [settings]);\r\n\r\n                    intervalCallback();\r\n\r\n                });\r\n            },\r\n            changeSettings: function( options, internal ) {\r\n\r\n                // Like resume but with resetting/changing options\r\n                return this.each(function() {\r\n                    var $this  = $(this),\r\n                        settings,\r\n                        testDate,\r\n                        func = $.proxy( updateCallback, $this );\r\n\r\n                    if ( !$this.data(\"jcdData\") ) {\r\n                        return true;\r\n                    }\r\n\r\n                    settings = $.extend( {}, $this.data(\"jcdData\"), options );\r\n\r\n                    if ( options.hasOwnProperty(\"date\") ) {\r\n                        testDate = new Date(options.date);\r\n\r\n                        if ( testDate.toString() === \"Invalid Date\" ) {\r\n                            $.error(\"Invalid Date passed to jCountdown: \" + options.date);\r\n                        }\r\n                    }\r\n\r\n                    settings.completed = false;\r\n                    settings.dateObj  = new Date( options.date );\r\n\r\n                    // Clear the timer, as it might not be needed\r\n                    clearInterval( settings.timer );\r\n                    $this.off(\".jcdevt\").data(\"jcdData\", settings);\r\n\r\n                    // As this can be accessed via the init method as well,\r\n                    // we need to check how this method is being accessed\r\n                    if ( !internal ) {\r\n\r\n                        addEventHandlers($this, settings);\r\n\r\n                        settings.timer = setInterval( func, settings.updateTime );\r\n                        $this.data(\"jcdData\", settings);\r\n                        func(); //Needs to run straight away when changing settings\r\n                    }\r\n\r\n                    settings = null;\r\n                });\r\n\r\n            },\r\n            resume: function() {\r\n\r\n                // Resumes a countdown timer\r\n                return this.each(function() {\r\n                    var $this = $(this),\r\n                        settings = $this.data(\"jcdData\"),\r\n                        func = $.proxy( updateCallback, $this );\r\n\r\n                    if ( !settings ) {\r\n                        return true;\r\n                    }\r\n\r\n                    $this.data(\"jcdData\", settings).triggerMulti(\"resume.jcdevt,countResume\", [settings] );\r\n                    // We only want to resume a countdown that hasn't finished\r\n                    if ( !settings.hasCompleted ) {\r\n                        settings.timer = setInterval( func, settings.updateTime );\r\n\r\n                        if ( settings.stopwatch && settings.direction === \"up\" ) {\r\n\r\n                            var t = dateNow( $this ).getTime() - settings.pausedAt.getTime(),\r\n                                d = new Date();\r\n                            d.setTime( settings.dateObj.getTime() + t );\r\n\r\n                            settings.dateObj = d; //This is internal date\r\n                        }\r\n\r\n                        func();\r\n                    }\r\n                });\r\n\r\n            },\r\n            pause: function() {\r\n                // Pause a countdown timer\r\n                return this.each(function() {\r\n                    var $this = $(this),\r\n                        settings = $this.data(\"jcdData\");\r\n\r\n                    if ( !settings ) {\r\n                        return true;\r\n                    }\r\n\r\n                    if ( settings.stopwatch ) {\r\n                        settings.pausedAt = dateNow( $this );\r\n                    }\r\n                    // Clear interval (Will be started on resume)\r\n                    clearInterval( settings.timer );\r\n                    // Trigger pause event handler\r\n                    $this.data(\"jcdData\", settings).triggerMulti(\"pause.jcdevt,countPause\", [settings] );\r\n                });\r\n            },\r\n            complete: function() {\r\n                return this.each(function() {\r\n                    var $this = $(this),\r\n                        settings = $this.data(\"jcdData\");\r\n\r\n                    if ( !settings ) {\r\n                        return true;\r\n                    }\r\n                    // Clear timer\r\n                    clearInterval( settings.timer );\r\n                    settings.hasCompleted = true;\r\n                    // Update setting, trigger complete event handler, then unbind all events\r\n                    // We don\"t delete the settings in case they need to be checked later on\r\n\r\n                    $this.data(\"jcdData\", settings).triggerMulti(\"complete.jcdevt,countComplete\", [settings]);\r\n                });\r\n            },\r\n            destroy: function() {\r\n                return this.each(function() {\r\n                    var $this = $(this),\r\n                        settings = $this.data(\"jcdData\");\r\n\r\n                    if ( !settings ) {\r\n                        return true;\r\n                    }\r\n                    // Clear timer\r\n                    clearInterval( settings.timer );\r\n                    // Unbind all events, remove data and put DOM Element back to its original state (HTML wise)\r\n                    $this.off(\".jcdevt\").removeData(\"jcdData\").html( settings.originalHTML );\r\n                });\r\n            },\r\n            getSettings: function( name ) {\r\n                var $this = $(this),\r\n                    settings = $this.data(\"jcdData\");\r\n\r\n                // If an individual setting is required\r\n                if ( name && settings ) {\r\n                    // If it exists, return it\r\n                    if ( settings.hasOwnProperty( name ) ) {\r\n                        return settings[name];\r\n                    }\r\n                    return undefined;\r\n                }\r\n                // Return all settings or undefined\r\n                return settings;\r\n            },\r\n            changeLocale: function( locale ) {\r\n                var $this = $(this),\r\n                    settings = $this.data(\"jcdData\");\r\n\r\n                // If no locale exists error and return false\r\n                if ( !$.fn.countdown.locale[locale] ) {\r\n                    $.error(\"Locale '\" + locale + \"' does not exist\");\r\n                    return false;\r\n                }\r\n\r\n                $.extend( settings, $.fn.countdown.locale[locale] );\r\n\r\n                $this.data(\"jcdData\", settings).triggerMulti(\"locale.jcdevt,localeChange\", [settings]);\r\n\r\n                return true;\r\n            }\r\n        };\r\n\r\n    if( methods[ method ] ) {\r\n        return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ) );\r\n    } else if ( typeof method === \"object\" || !method ) {\r\n        return methods.init.apply( this, arguments );\r\n    } else {\r\n        $.error(\"Method \"+ method +\" does not exist in the jCountdown Plugin\");\r\n    }\r\n};\r\n\r\n// Expose defaults so we can easily override settings\r\n// Useful for locale plugins\r\n$.fn.countdown.defaults = {\r\n    date: null,\r\n    dataAttr: null,\r\n    updateTime: 1000,\r\n    yearText: 'years',\r\n    monthText: 'months',\r\n    weekText: 'weeks',\r\n    dayText: 'days',\r\n    hourText: 'hours',\r\n    minText: 'mins',\r\n    secText: 'sec',\r\n    yearSingularText: 'year',\r\n    monthSingularText: 'month',\r\n    weekSingularText: 'week',\r\n    daySingularText: 'day',\r\n    hourSingularText: 'hour',\r\n    minSingularText: 'min',\r\n    secSingularText: 'sec',\r\n    digits : [0,1,2,3,4,5,6,7,8,9],\r\n    isRTL: false,\r\n    minus: false,\r\n    onStart: null,\r\n    onChange: null,\r\n    onComplete: null,\r\n    onResume: null,\r\n    onPause: null,\r\n    onLocaleChange: null,\r\n    leadingZero: false,\r\n    offset: null,\r\n    serverDiff:null,\r\n    hoursOnly: false,\r\n    minsOnly: false,\r\n    secsOnly: false,\r\n    weeks: false,\r\n    hours: false,\r\n    yearsAndMonths: false,\r\n    direction: \"down\",\r\n    stopwatch: false,\r\n    omitZero: false,\r\n\r\n    rtlTemplate: '%ts %s : %ti %i : %th %h : %tm %m : %ty %y',\r\n    template: '%y %ty : %m %tm : %h %th : %i %ti : %s %ts'\r\n};\r\n\r\n// Locale cache\r\n$.fn.countdown.locale = [];\r\n\r\n// Store default english locale so we can switch easier\r\n$.fn.countdown.locale.en = {\r\n    yearText: 'years',\r\n    monthText: 'months',\r\n    weekText: 'weeks',\r\n    dayText: 'days',\r\n    hourText: 'hours',\r\n    minText: 'mins',\r\n    secText: 'sec',\r\n    yearSingularText: 'year',\r\n    monthSingularText: 'month',\r\n    weekSingularText: 'week',\r\n    daySingularText: 'day',\r\n    hourSingularText: 'hour',\r\n    minSingularText: 'min',\r\n    secSingularText: 'sec',\r\n    isRTL: false\r\n};\r\n\r\n//\r\n$.fn.triggerMulti = function( eventTypes, extraParameters ) {\r\n    var events = eventTypes.split(\",\");\r\n        \r\n    return this.each(function() {\r\n        var $this = $(this);\r\n\r\n        for ( var i = 0; i < events.length; i++) {\r\n            $this.trigger( events[i], extraParameters );\r\n        }   \r\n    });\r\n};\r\n\r\n}));","MageBig_WidgetPlus/js/videobackground.js":"define([\r\n    \"jquery\",\r\n    \"domReady!\"\r\n], function($){\r\n    \"use strict\";\r\n\r\n    $.widget('magebig.videobackground', {\r\n        options: {\r\n            videoType: 'contain'\r\n        },\r\n\r\n        _create: function() {\r\n            self = this;\r\n            self.initial();\r\n        },\r\n\r\n        initial: function() {\r\n            var elmId = '#' + this.element[0]['id'],\r\n                self = this,\r\n                timer = false,\r\n                videosrc = $(elmId).attr('data-videosrc'),\r\n                videoPlay;\r\n            if (typeof videosrc !== typeof undefined && videosrc !== false) {\r\n                videoPlay = '<video class=\"background\" loop ' + self.options.autoplay + ' ' + self.options.muted + ' ' + self.options.controls\r\n                    + '><source src=\"' + videosrc + '\" type=\"video/mp4\"></video>';\r\n                $(elmId).append(videoPlay).append('<div class=\"playvideo mbi mbi-play-circle\"></div>');\r\n            }\r\n\r\n            var video = $(elmId + ' video'),\r\n                play = video.next('.playvideo');\r\n\r\n            if (video[0].paused) {\r\n                play.addClass('mbi-pause-circle').removeClass('mbi-play-circle');\r\n            } else {\r\n                play.addClass('mbi-play-circle').removeClass('mbi-pause-circle');\r\n            }\r\n\r\n            $(elmId + ' .playvideo').on('click', function(event) {\r\n                event.preventDefault();\r\n                if (video[0].paused) {\r\n                    video[0].play();\r\n                    play.addClass('mbi-pause-circle').removeClass('mbi-play-circle');\r\n                } else {\r\n                    video[0].pause();\r\n                    play.addClass('mbi-play-circle').removeClass('mbi-pause-circle');\r\n                }\r\n            });\r\n\r\n            self.scaleVideo();\r\n\r\n            $(window).on('resize', function() {\r\n                if (timer) clearTimeout(timer);\r\n                timer = setTimeout(function(){\r\n                    self.scaleVideo();\r\n                }, 1000);\r\n            });\r\n        },\r\n\r\n        scaleVideo: function () {\r\n            var self = this;\r\n            var elmId = '#' + this.element[0]['id'];\r\n            var video = $(elmId + ' video');\r\n\r\n            video.bind(\"loadedmetadata\", function () {\r\n                var elmId = '#' + self.element[0]['id'];\r\n                var heightContainer = $(elmId).outerHeight();\r\n                var widthContainer = $(elmId).outerWidth();\r\n\r\n                var widthVideo = this.videoWidth;\r\n                var heightVideo = this.videoHeight;\r\n\r\n                var ratioVideo = widthVideo/heightVideo;\r\n\r\n                if (self.options.videoType == 'contain') {\r\n                    heightVideo = parseInt(heightContainer) + 4;\r\n                    widthVideo = parseInt(heightVideo*ratioVideo);\r\n                    if (widthVideo < widthContainer) {\r\n                        widthVideo = parseInt(widthContainer) + 4;\r\n                        heightVideo = parseInt(widthVideo/ratioVideo);\r\n                    }\r\n                    video.height(heightVideo).width(widthVideo);\r\n                } else if (self.options.videoType == 'fullscreen') {\r\n                    var windowWidth = $(window).width(),\r\n                        windowHeight = $(window).height();\r\n\r\n                    $(elmId).width(windowWidth).height(windowHeight);\r\n\r\n                    heightVideo = parseInt(heightContainer) + 4;\r\n                    widthVideo = parseInt(heightVideo*ratioVideo);\r\n                    if (widthVideo < widthContainer) {\r\n                        widthVideo = parseInt(widthContainer) + 4;\r\n                        heightVideo = parseInt(widthVideo/ratioVideo);\r\n                    }\r\n                    video.height(heightVideo).width(widthVideo);\r\n                }\r\n            });\r\n        }\r\n    });\r\n    return $.magebig.videobackground;\r\n});","MageBig_WidgetPlus/js/product/addtocart-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'mage/apply/main'\n], function (Element, uencProcessor, columnStatusValidator, mage) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare data, that will be inserted as data-mage-init attribute into button. With help of this attribute\n         * Add To * buttons can understand post data and urls\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getDataMageInit: function (row) {\n            return '{\"redirectUrl\": { \"url\" : \"'  + uencProcessor(row['add_to_cart_button'].url) + '\"}}';\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_cart_button']['post_data']);\n        },\n\n        getUenc: function (row) {\n            return JSON.parse(this.getDataPost(row)).data.uenc;\n        },\n\n        getAction: function (row) {\n            return uencProcessor(row['add_to_cart_button'].url);\n        },\n\n        getId: function (row) {\n            return row['id'];\n        },\n\n        getSku: function (row) {\n            return row['extension_attributes'].sku;\n        },\n\n        getFormKey: function (row) {\n            return row['extension_attributes'].form_key;\n        },\n\n        getAddToCartMageInit: function () {\n            mage.apply();\n            // return '{\"catalogAddToCart\": {}}';\n        },\n\n        /**\n         * Check if product has required options.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasRequiredOptions: function (row) {\n            return row['add_to_cart_button']['required_options'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_cart', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","MageBig_WidgetPlus/js/product/list/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/listing',\n    'jquery',\n    'MageBig_WidgetPlus/js/owl.carousel-set',\n    'mage/apply/main',\n    'jquery-ui-modules/tooltip'\n], function (ko, _, Listing, $, owlWidget, mage) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            additionalClasses: '',\n            filteredRows: {},\n            limit: 5,\n            listens: {\n                elems: 'filterRowsFromCache',\n                '${ $.provider }:data.items': 'filterRowsFromServer'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.filteredRows = ko.observable();\n            this.initProductsLimit();\n            this.hideLoader();\n        },\n\n        /**\n         * Initialize product limit\n         * Product limit can be configured through Ui component.\n         * Product limit are present in widget form\n         *\n         * @returns {exports}\n         */\n        initProductsLimit: function () {\n            if (this.source['page_size']) {\n                this.limit = this.source['page_size'];\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Sort and filter rows, that are already in magento storage cache\n         *\n         * @return void\n         */\n        filterRowsFromCache: function () {\n            this._filterRows(this.rows);\n        },\n\n        /**\n         * Sort and filter rows, that are come from backend\n         *\n         * @param {Object} rows\n         */\n        filterRowsFromServer: function (rows) {\n            this._filterRows(rows);\n        },\n\n        /**\n         * Filter rows by limit and sort them\n         *\n         * @param {Array} rows\n         * @private\n         */\n        _filterRows: function (rows) {\n            this.filteredRows(_.sortBy(rows, 'added_at').reverse().slice(0, this.limit));\n        },\n\n        /**\n         * Can retrieve product url\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getUrl: function (row) {\n            return row.url;\n        },\n\n        /**\n         * Get product attribute by code.\n         *\n         * @param {String} code\n         * @return {Object}\n         */\n        getComponentByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                component;\n\n            component = _.filter(elems, function (elem) {\n                return elem.index === code;\n            }, this).pop();\n\n            return component;\n        },\n\n        /**\n         * Init slider\n         */\n        sliderInit: function (index) {\n            var count = this.filteredRows._latestValue.length;\n\n            if (index === count - 1) {\n                setTimeout(function () {\n                    // $(\"form[data-role='tocart-form']\").catalogAddToCart();\n                    var rtl = false;\n                    if ($('body').hasClass('layout-rtl') || $('body').hasClass('rtl')) {\n                        rtl = true;\n                    }\n                    $('.recently-viewed').owlWidget({\n                        \"autoplay\": false,\n                        \"autoplayTimeout\": 5000,\n                        \"items\": 5,\n                        \"margin\": 30,\n                        \"rewind\": true,\n                        \"nav\": true,\n                        \"navText\": ['<i class=\"mbi mbi-chevron-left\"></i>', '<i class=\"mbi mbi-chevron-right\"></i>'],\n                        \"dots\": false,\n                        \"responsive\": {\n                            \"0\": {\"items\": 2},\n                            \"576\": {\"items\": 2},\n                            \"768\": {\"items\": 3},\n                            \"992\": {\"items\": 4},\n                            \"1200\": {\"items\": 5},\n                            \"1600\": {\"items\": 6}\n                        },\n                        \"rtl\": rtl\n                    });\n                    if ($(window).width() > 767) {\n                        $('.mb-tooltip').tooltip({\n                            show: null,\n                            hide: {\n                                delay: 250\n                            },\n                            position: {\n                                my: \"center bottom-30\",\n                                at: \"center top\",\n                                using: function (position, feedback) {\n                                    $(this).css(position);\n                                    $(this).addClass(\"magebig-tooltip\");\n                                }\n                            },\n                            open: function (event, ui) {\n                                ui.tooltip.addClass('in');\n                            },\n                            close: function (event, ui) {\n                                ui.tooltip.removeClass('in');\n                                $(\".ui-helper-hidden-accessible\").remove();\n                            }\n                        });\n                    }\n                }, 1000);\n            }\n        },\n\n        getPercentDiscount: function (row) {\n            var regular_price = row['price_info']['regular_price'],\n                special_price = row['price_info']['final_price'];\n\n            if (regular_price > special_price) {\n                var discount;\n                discount = 100 - parseInt(Math.round((special_price / regular_price) * 100));\n\n                return discount > 0 ? '-' + discount + '%' : false;\n            }\n\n            return false;\n        }\n    });\n});\n","MageBig_AjaxFilter/js/range-slider.js":"/*jshint browser:true jquery:true*/\n/*global alert*/\n\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'jquery/ui-modules/widgets/slider'\n], function ($, priceUtil) {\n    \"use strict\";\n\n    $.widget('magebig.rangeSlider', {\n\n        options: {\n            fromLabel: '[data-role=from-label]',\n            toLabel: '[data-role=to-label]',\n            sliderBar: '[data-role=slider-bar]',\n            applyButton: '[data-role=apply-range]',\n            rate: 1.0000,\n            maxLabelOffset: 0.01\n        },\n\n        _create: function () {\n            this._initSliderValues();\n            this._createSlider();\n            this._refreshDisplay();\n        },\n\n        _initSliderValues: function () {\n            this.rate = parseFloat(this.options.rate);\n            this.from = Math.floor(this.options.currentValue.from * this.rate);\n            this.to = Math.round(this.options.currentValue.to * this.rate);\n            this.minValue = Math.floor(this.options.minValue * this.rate);\n            this.maxValue = Math.round(this.options.maxValue * this.rate);\n        },\n\n        _createSlider: function () {\n            this.element.find(this.options.sliderBar).slider({\n                range: true,\n                min: this.minValue,\n                max: this.maxValue,\n                values: [this.from, this.to],\n                slide: this._onSliderChange.bind(this),\n                step: this.options.step\n            });\n        },\n\n        _onSliderChange: function (ev, ui) {\n            this.from = ui.values[0];\n            this.to = ui.values[1];\n            this._refreshDisplay();\n        },\n\n        _refreshDisplay: function () {\n            if (this.element.find('[data-role=from-label]')) {\n                this.element.find('[data-role=from-label]').html(this._formatLabel(this.from));\n            }\n\n            if (this.element.find('[data-role=to-label]')) {\n                this.element.find('[data-role=to-label]').html(this._formatLabel(this.to - this.options.maxLabelOffset));\n            }\n\n            this._applyRange();\n        },\n\n        _applyRange: function () {\n            var from = this.from * (1 / this.rate),\n                to = this.to * (1 / this.rate),\n                url = this.options.actionUrl,\n                code = this.options.code;\n\n            url += (url.search(/\\?/) != -1) ? '&' : '?';\n            url += code + '=' + from + '-' + to;\n            this.element.find(this.options.applyButton).attr('href', url);\n        },\n\n        _formatLabel: function (value) {\n            var formattedValue = value;\n\n            if (this.options.fieldFormat) {\n                formattedValue = priceUtil.formatPrice(value, this.options.fieldFormat);\n            }\n\n            return formattedValue;\n        }\n    });\n\n    return $.magebig.rangeSlider;\n});\n","MageBig_AjaxFilter/js/ajaxfilter.js":"/**\n * Copyright \u00c2\u00a9 2018 MageBig. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'nanoscroller'\n], function ($) {\n\n    !function (o) {\n        if (o.support.touch = \"ontouchend\" in document, o.support.touch) {\n            var t, e = o.ui.mouse.prototype, u = e._mouseInit, n = e._mouseDestroy;\n\n            function c(o, t) {\n                if (!(o.originalEvent.touches.length > 1)) {\n                    o.preventDefault();\n                    var e = o.originalEvent.changedTouches[0], u = document.createEvent(\"MouseEvents\");\n                    u.initMouseEvent(t, !0, !0, window, 1, e.screenX, e.screenY, e.clientX, e.clientY, !1, !1, !1, !1, 0, null), o.target.dispatchEvent(u)\n                }\n            }\n\n            e._touchStart = function (o) {\n                !t && this._mouseCapture(o.originalEvent.changedTouches[0]) && (t = !0, this._touchMoved = !1, c(o, \"mouseover\"), c(o, \"mousemove\"), c(o, \"mousedown\"))\n            }, e._touchMove = function (o) {\n                t && (this._touchMoved = !0, c(o, \"mousemove\"))\n            }, e._touchEnd = function (o) {\n                t && (c(o, \"mouseup\"), c(o, \"mouseout\"), this._touchMoved || c(o, \"click\"), t = !1)\n            }, e._mouseInit = function () {\n                var t = this;\n                t.element.bind({\n                    touchstart: o.proxy(t, \"_touchStart\"),\n                    touchmove: o.proxy(t, \"_touchMove\"),\n                    touchend: o.proxy(t, \"_touchEnd\")\n                }), u.call(t)\n            }, e._mouseDestroy = function () {\n                var t = this;\n                t.element.unbind({\n                    touchstart: o.proxy(t, \"_touchStart\"),\n                    touchmove: o.proxy(t, \"_touchMove\"),\n                    touchend: o.proxy(t, \"_touchEnd\")\n                }), n.call(t)\n            }\n        }\n    }($);\n\n    $.widget('magebig.ajaxfilter', {\n        options: {\n            enableAjax: true,\n            ajaxSelector: '.filter-current a.action.remove, .filter-options-content a, a.filter-clear, .toolbar-products .pages-items a'\n        },\n\n        _create: function () {\n            var self = this, conf = this.options;\n            this._initBlockHtml();\n            this._defaultEvents();\n            setTimeout(function () {\n                self._updateToolbar();\n            }, 500);\n\n            this._searchTextFilter();\n\n            if (typeof window.history.replaceState === \"function\") {\n                window.history.replaceState({url: document.URL}, document.title);\n\n                setTimeout(function () {\n                    window.onpopstate = function (e) {\n                        if (e.state) {\n                            self._ajaxFilter(e.state.url, true, false);\n                        }\n                    };\n                }, 0)\n            }\n        },\n\n        _initBlockHtml: function () {\n            var self = this, conf = this.options;\n\n            $('.filter-options-item .filter-options-overflow').addClass('nano-content').wrap('<div class=\"nano\"></div>');\n            $('.filter-options-item .nano').nanoScroller();\n\n            this._cloneFilterClear();\n\n            $('[data-role=filter-dropdown]').on('change', function () {\n                var $select = $(this),\n                    actionUrl = $select.val();\n                self.activeCode = $select.data('code');\n                self._ajaxFilter(actionUrl, true, true);\n            });\n            $('[data-role=mb-filter-checkbox] [type=checkbox]').on('change', function () {\n                var $checkbox = $(this),\n                    $elm = $checkbox.parents('[data-role=mb-filter-checkbox]').first(),\n                    code = $elm.data('code'),\n                    actionUrl = $elm.data('action'),\n                    multiSelect = $elm.data('select'),\n                    value = [];\n                if (multiSelect) {\n                    $elm.find('[type=checkbox]:checked').each(function () {\n                        value.push($(this).val());\n                    });\n                } else if ($checkbox.is(':checked')) {\n                    value.push($checkbox.val());\n                    $elm.find('[type=checkbox]:checked').each(function () {\n                        var $this = $(this);\n                        if (!$this.is($checkbox)) {\n                            $this.prop('checked', false);\n                        }\n                    });\n                }\n                if (value.length) {\n                    value = value.join(',');\n                    actionUrl += (actionUrl.search(/\\?/) != -1) ? '&' : '?';\n                    actionUrl += code + '=' + value;\n                }\n                self.activeCode = code;\n                self._ajaxFilter(actionUrl, true, true);\n            });\n        },\n\n        _updateToolbar: function () {\n            var self = this,\n                currURL = document.URL,\n                currURLVars = this.getUrlVars(currURL),\n                params = '?',\n                $currentUrl = window.location.protocol + '//' + window.location.hostname + window.location.pathname;\n\n            $.each(currURLVars, function (index, value) {\n                if (index !== 'p' && index !== 'page') {\n                    params += index + '=' + value + '&';\n                }\n            });\n\n            $('.toolbar.toolbar-products .pages-items a').each(function () {\n                var pageUrl = $(this).attr('href'),\n                    paging = '',\n                    newUrl,\n                    urlVars;\n\n                if (pageUrl.indexOf('p=') > -1 || pageUrl.indexOf('page=') > -1) {\n                    urlVars = self.getUrlVars(pageUrl);\n\n                    $.each(urlVars, function (index, value) {\n                        if (index === 'p' || index === 'page') {\n                            paging = index + '=' + value;\n                        }\n                    });\n\n                    newUrl = $currentUrl + params + paging;\n                    $(this).attr('href', newUrl);\n                }\n            });\n\n            $('.toolbar.toolbar-products').each(function () {\n                var $toolbar = $(this);\n\n                setTimeout(function () {\n                    var toolbarForm = $toolbar.data('mageProductListToolbarForm');\n                    if (toolbarForm) {\n                        toolbarForm.changeUrl = function (paramName, paramValue, defaultValue) {\n                            var decode = window.decodeURIComponent,\n                                urlPaths = this.options.url.split('?'),\n                                baseUrl = urlPaths[0],\n                                urlParams = urlPaths[1] ? urlPaths[1].split('&') : [],\n                                paramData = {},\n                                parameters, i;\n\n                            for (i = 0; i < urlParams.length; i++) {\n                                parameters = urlParams[i].split('=');\n                                paramData[decode(parameters[0])] = parameters[1] !== undefined ?\n                                    decode(parameters[1].replace(/\\+/g, '%20')) : '';\n                            }\n                            paramData[paramName] = paramValue;\n\n                            if (paramValue == defaultValue) {\n                                delete paramData[paramName];\n                            }\n                            paramData = $.param(paramData);\n\n                            var actionUrl = baseUrl + (paramData.length ? '?' + paramData : '');\n                            self._ajaxFilter(actionUrl, true, true);\n                        }\n                    }\n                }, 500);\n            });\n        },\n        _defaultEvents: function () {\n            var self = this, conf = this.options;\n            $(conf.ajaxSelector).on('click', function (e) {\n                e.preventDefault();\n                var $a = $(this);\n                var actionUrl = $a.attr('href');\n                self._ajaxFilter(actionUrl, true, true);\n            });\n        },\n\n        getUrlVars: function (url) {\n            var vars = {};\n            var parts = url.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {\n                vars[key] = value;\n            });\n            return vars;\n        },\n\n        _ajaxFilter: function (actionUrl, needSrollTop, pushState) {\n            var self = this, conf = this.options;\n\n            if ((!actionUrl) || (actionUrl.search('javascript:') == 0) || (actionUrl.search('#') == 0)) {\n                return;\n            }\n\n            if (self.getUrlVars(actionUrl)[\"p\"] == self.getUrlVars(window.location.href)[\"p\"] && pushState) {\n                var tmp = \"p=\" + self.getUrlVars(actionUrl)[\"p\"];\n                actionUrl = actionUrl.replace(tmp, \"\");\n            }\n\n            if (!self.options.enableAjax) {\n                window.location.href = actionUrl;\n                return false;\n            }\n\n            $.ajax({\n                url: actionUrl,\n                type: 'POST',\n                data: {ajax_filter: 1},\n                beforeSend: function () {\n                    $('body').trigger('processStart');\n                },\n                success: function (res) {\n                    if ($.magnificPopup.instance.isOpen) {\n                        $.magnificPopup.close();\n                    }\n                    if (res.catalog_leftnav) {\n                        $('.block.filter').first().replaceWith(res.catalog_leftnav);\n                    }\n                    if (res.category_products) {\n                        res.category_products = decodeURIComponent(res.category_products);\n                        var $listContainer = $('#product-container-wrap');\n                        $listContainer.html(res.category_products);\n\n                        setTimeout(function () {\n                            self._updateToolbar();\n                        }, 0);\n                    }\n                    if (res.page_main_title) {\n                        $('.page-title-wrapper').first().replaceWith(res.page_main_title);\n                    }\n\n                    var urlState;\n\n                    if (res.updated_url) {\n                        urlState = res.updated_url\n                    } else {\n                        urlState = actionUrl;\n                    }\n\n                    if (pushState) {\n                        window.history.pushState({url: urlState}, document.title, urlState);\n                    } else {\n                        var n = history.state;\n                        history.replaceState(n, document.title, urlState);\n                    }\n\n                    self._initBlockHtml();\n                    self._defaultEvents();\n\n                    $('body').trigger('contentUpdated');\n                    setTimeout(function () {\n                        $('body').trigger('reloadAjaxScroll');\n                        if (needSrollTop) {\n                            $('body,html').animate({\n                                scrollTop: $listContainer.offset().top - 100\n                            }, 800);\n                        }\n                    }, 100);\n\n                    $('body').trigger('processStop');\n                },\n                error: function (res) {\n                    $('body').trigger('processStop');\n                    alert('Error in sending ajax request');\n                }\n            }).done(function (res) {\n                $('body').trigger('processStop');\n            });\n        },\n\n        _cloneFilterClear: function () {\n            if (!$('#product-container-wrap .clear-filter-wrap').length) {\n                $('#product-container-wrap').prepend('<div class=\"clear-filter-wrap\"></div>');\n            }\n            if ($('.filter-current').length) {\n                var filter = $('.filter-current').clone().addClass('now-filter-clone');\n                $('.clear-filter-wrap').html(filter);\n            }\n        },\n\n        _searchTextFilter: function () {\n            var self = this;\n            $(\"input.search-filter\").on(\"keyup\", function (ev) {\n                var texto = $(this).val(),\n                    elm = $(this).parents('.filter-options-wrap');\n                self._searchFilter(elm, texto);\n            });\n        },\n\n        _searchFilter: function (elm, texto) {\n            var lista = elm.find('li.item')\n                .hide()\n                .filter(function () {\n                    var item = $(this).text();\n                    var padrao = new RegExp(texto, \"i\");\n\n                    return padrao.test(item);\n                })\n                .show();\n\n        }\n\n    });\n    return $.magebig.ajaxfilter;\n});\n","MageBig_AjaxFilter/js/slider.js":"/*!\n * jQuery UI Slider - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/slider/\n */\ndefine(['jquery','jquery-ui-modules/core','jquery-ui-modules/mouse'],function($,undefined){var numPages=5;$.widget(\"ui.slider\",$.ui.mouse,{version:\"1.10.4\",widgetEventPrefix:\"slide\",options:{animate:false,distance:0,max:100,min:0,orientation:\"horizontal\",range:false,step:1,value:0,values:null,change:null,slide:null,start:null,stop:null},_create:function(){this._keySliding=false;this._mouseSliding=false;this._animateOff=true;this._handleIndex=null;this._detectOrientation();this._mouseInit();this.element.addClass(\"ui-slider\"+\" ui-slider-\"+this.orientation+\" ui-widget\"+\" ui-widget-content\"+\" ui-corner-all\");this._refresh();this._setOption(\"disabled\",this.options.disabled);this._animateOff=false;},_refresh:function(){this._createRange();this._createHandles();this._setupEvents();this._refreshValue();},_createHandles:function(){var i,handleCount,options=this.options,existingHandles=this.element.find(\".ui-slider-handle\").addClass(\"ui-state-default ui-corner-all\"),handle=\"<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>\",handles=[];handleCount=(options.values&&options.values.length)||1;if(existingHandles.length>handleCount){existingHandles.slice(handleCount).remove();existingHandles=existingHandles.slice(0,handleCount);}\n        for(i=existingHandles.length;i<handleCount;i++){handles.push(handle);}\n        this.handles=existingHandles.add($(handles.join(\"\")).appendTo(this.element));this.handle=this.handles.eq(0);this.handles.each(function(i){$(this).data(\"ui-slider-handle-index\",i);});},_createRange:function(){var options=this.options,classes=\"\";if(options.range){if(options.range===true){if(!options.values){options.values=[this._valueMin(),this._valueMin()];}else if(options.values.length&&options.values.length!==2){options.values=[options.values[0],options.values[0]];}else if($.isArray(options.values)){options.values=options.values.slice(0);}}\n        if(!this.range||!this.range.length){this.range=$(\"<div></div>\").appendTo(this.element);classes=\"ui-slider-range\"+\" ui-widget-header ui-corner-all\";}else{this.range.removeClass(\"ui-slider-range-min ui-slider-range-max\").css({\"left\":\"\",\"bottom\":\"\"});}\n        this.range.addClass(classes+\n            ((options.range===\"min\"||options.range===\"max\")?\" ui-slider-range-\"+options.range:\"\"));}else{if(this.range){this.range.remove();}\n        this.range=null;}},_setupEvents:function(){var elements=this.handles.add(this.range).filter(\"a\");this._off(elements);this._on(elements,this._handleEvents);this._hoverable(elements);this._focusable(elements);},_destroy:function(){this.handles.remove();if(this.range){this.range.remove();}\n        this.element.removeClass(\"ui-slider\"+\" ui-slider-horizontal\"+\" ui-slider-vertical\"+\" ui-widget\"+\" ui-widget-content\"+\" ui-corner-all\");this._mouseDestroy();},_mouseCapture:function(event){var position,normValue,distance,closestHandle,index,allowed,offset,mouseOverHandle,that=this,o=this.options;if(o.disabled){return false;}\n        this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()};this.elementOffset=this.element.offset();position={x:event.pageX,y:event.pageY};normValue=this._normValueFromMouse(position);distance=this._valueMax()-this._valueMin()+1;this.handles.each(function(i){var thisDistance=Math.abs(normValue-that.values(i));if((distance>thisDistance)||(distance===thisDistance&&(i===that._lastChangedValue||that.values(i)===o.min))){distance=thisDistance;closestHandle=$(this);index=i;}});allowed=this._start(event,index);if(allowed===false){return false;}\n        this._mouseSliding=true;this._handleIndex=index;closestHandle.addClass(\"ui-state-active\").focus();offset=closestHandle.offset();mouseOverHandle=!$(event.target).parents().addBack().is(\".ui-slider-handle\");this._clickOffset=mouseOverHandle?{left:0,top:0}:{left:event.pageX-offset.left-(closestHandle.width()/ 2),top:event.pageY-offset.top-\n                (closestHandle.height()/ 2)-\n                (parseInt(closestHandle.css(\"borderTopWidth\"),10)||0)-\n                (parseInt(closestHandle.css(\"borderBottomWidth\"),10)||0)+\n                (parseInt(closestHandle.css(\"marginTop\"),10)||0)};if(!this.handles.hasClass(\"ui-state-hover\")){this._slide(event,index,normValue);}\n        this._animateOff=true;return true;},_mouseStart:function(){return true;},_mouseDrag:function(event){var position={x:event.pageX,y:event.pageY},normValue=this._normValueFromMouse(position);this._slide(event,this._handleIndex,normValue);return false;},_mouseStop:function(event){this.handles.removeClass(\"ui-state-active\");this._mouseSliding=false;this._stop(event,this._handleIndex);this._change(event,this._handleIndex);this._handleIndex=null;this._clickOffset=null;this._animateOff=false;return false;},_detectOrientation:function(){this.orientation=(this.options.orientation===\"vertical\")?\"vertical\":\"horizontal\";},_normValueFromMouse:function(position){var pixelTotal,pixelMouse,percentMouse,valueTotal,valueMouse;if(this.orientation===\"horizontal\"){pixelTotal=this.elementSize.width;pixelMouse=position.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0);}else{pixelTotal=this.elementSize.height;pixelMouse=position.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0);}\n        percentMouse=(pixelMouse / pixelTotal);if(percentMouse>1){percentMouse=1;}\n        if(percentMouse<0){percentMouse=0;}\n        if(this.orientation===\"vertical\"){percentMouse=1-percentMouse;}\n        valueTotal=this._valueMax()-this._valueMin();valueMouse=this._valueMin()+percentMouse*valueTotal;return this._trimAlignValue(valueMouse);},_start:function(event,index){var uiHash={handle:this.handles[index],value:this.value()};if(this.options.values&&this.options.values.length){uiHash.value=this.values(index);uiHash.values=this.values();}\n        return this._trigger(\"start\",event,uiHash);},_slide:function(event,index,newVal){var otherVal,newValues,allowed;if(this.options.values&&this.options.values.length){otherVal=this.values(index?0:1);if((this.options.values.length===2&&this.options.range===true)&&((index===0&&newVal>otherVal)||(index===1&&newVal<otherVal))){newVal=otherVal;}\n        if(newVal!==this.values(index)){newValues=this.values();newValues[index]=newVal;allowed=this._trigger(\"slide\",event,{handle:this.handles[index],value:newVal,values:newValues});otherVal=this.values(index?0:1);if(allowed!==false){this.values(index,newVal);}}}else{if(newVal!==this.value()){allowed=this._trigger(\"slide\",event,{handle:this.handles[index],value:newVal});if(allowed!==false){this.value(newVal);}}}},_stop:function(event,index){var uiHash={handle:this.handles[index],value:this.value()};if(this.options.values&&this.options.values.length){uiHash.value=this.values(index);uiHash.values=this.values();}\n        this._trigger(\"stop\",event,uiHash);},_change:function(event,index){if(!this._keySliding&&!this._mouseSliding){var uiHash={handle:this.handles[index],value:this.value()};if(this.options.values&&this.options.values.length){uiHash.value=this.values(index);uiHash.values=this.values();}\n        this._lastChangedValue=index;this._trigger(\"change\",event,uiHash);}},value:function(newValue){if(arguments.length){this.options.value=this._trimAlignValue(newValue);this._refreshValue();this._change(null,0);return;}\n        return this._value();},values:function(index,newValue){var vals,newValues,i;if(arguments.length>1){this.options.values[index]=this._trimAlignValue(newValue);this._refreshValue();this._change(null,index);return;}\n        if(arguments.length){if($.isArray(arguments[0])){vals=this.options.values;newValues=arguments[0];for(i=0;i<vals.length;i+=1){vals[i]=this._trimAlignValue(newValues[i]);this._change(null,i);}\n            this._refreshValue();}else{if(this.options.values&&this.options.values.length){return this._values(index);}else{return this.value();}}}else{return this._values();}},_setOption:function(key,value){var i,valsLength=0;if(key===\"range\"&&this.options.range===true){if(value===\"min\"){this.options.value=this._values(0);this.options.values=null;}else if(value===\"max\"){this.options.value=this._values(this.options.values.length-1);this.options.values=null;}}\n        if($.isArray(this.options.values)){valsLength=this.options.values.length;}\n        $.Widget.prototype._setOption.apply(this,arguments);switch(key){case\"orientation\":this._detectOrientation();this.element.removeClass(\"ui-slider-horizontal ui-slider-vertical\").addClass(\"ui-slider-\"+this.orientation);this._refreshValue();break;case\"value\":this._animateOff=true;this._refreshValue();this._change(null,0);this._animateOff=false;break;case\"values\":this._animateOff=true;this._refreshValue();for(i=0;i<valsLength;i+=1){this._change(null,i);}\n            this._animateOff=false;break;case\"min\":case\"max\":this._animateOff=true;this._refreshValue();this._animateOff=false;break;case\"range\":this._animateOff=true;this._refresh();this._animateOff=false;break;}},_value:function(){var val=this.options.value;val=this._trimAlignValue(val);return val;},_values:function(index){var val,vals,i;if(arguments.length){val=this.options.values[index];val=this._trimAlignValue(val);return val;}else if(this.options.values&&this.options.values.length){vals=this.options.values.slice();for(i=0;i<vals.length;i+=1){vals[i]=this._trimAlignValue(vals[i]);}\n        return vals;}else{return[];}},_trimAlignValue:function(val){if(val<=this._valueMin()){return this._valueMin();}\n        if(val>=this._valueMax()){return this._valueMax();}\n        var step=(this.options.step>0)?this.options.step:1,valModStep=(val-this._valueMin())%step,alignValue=val-valModStep;if(Math.abs(valModStep)*2>=step){alignValue+=(valModStep>0)?step:(-step);}\n        return parseFloat(alignValue.toFixed(5));},_valueMin:function(){return this.options.min;},_valueMax:function(){return this.options.max;},_refreshValue:function(){var lastValPercent,valPercent,value,valueMin,valueMax,oRange=this.options.range,o=this.options,that=this,animate=(!this._animateOff)?o.animate:false,_set={};if(this.options.values&&this.options.values.length){this.handles.each(function(i){valPercent=(that.values(i)-that._valueMin())/(that._valueMax()-that._valueMin())*100;_set[that.orientation===\"horizontal\"?\"left\":\"bottom\"]=valPercent+\"%\";$(this).stop(1,1)[animate?\"animate\":\"css\"](_set,o.animate);if(that.options.range===true){if(that.orientation===\"horizontal\"){if(i===0){that.range.stop(1,1)[animate?\"animate\":\"css\"]({left:valPercent+\"%\"},o.animate);}\n        if(i===1){that.range[animate?\"animate\":\"css\"]({width:(valPercent-lastValPercent)+\"%\"},{queue:false,duration:o.animate});}}else{if(i===0){that.range.stop(1,1)[animate?\"animate\":\"css\"]({bottom:(valPercent)+\"%\"},o.animate);}\n        if(i===1){that.range[animate?\"animate\":\"css\"]({height:(valPercent-lastValPercent)+\"%\"},{queue:false,duration:o.animate});}}}\n        lastValPercent=valPercent;});}else{value=this.value();valueMin=this._valueMin();valueMax=this._valueMax();valPercent=(valueMax!==valueMin)?(value-valueMin)/(valueMax-valueMin)*100:0;_set[this.orientation===\"horizontal\"?\"left\":\"bottom\"]=valPercent+\"%\";this.handle.stop(1,1)[animate?\"animate\":\"css\"](_set,o.animate);if(oRange===\"min\"&&this.orientation===\"horizontal\"){this.range.stop(1,1)[animate?\"animate\":\"css\"]({width:valPercent+\"%\"},o.animate);}\n        if(oRange===\"max\"&&this.orientation===\"horizontal\"){this.range[animate?\"animate\":\"css\"]({width:(100-valPercent)+\"%\"},{queue:false,duration:o.animate});}\n        if(oRange===\"min\"&&this.orientation===\"vertical\"){this.range.stop(1,1)[animate?\"animate\":\"css\"]({height:valPercent+\"%\"},o.animate);}\n        if(oRange===\"max\"&&this.orientation===\"vertical\"){this.range[animate?\"animate\":\"css\"]({height:(100-valPercent)+\"%\"},{queue:false,duration:o.animate});}}},_handleEvents:{keydown:function(event){var allowed,curVal,newVal,step,index=$(event.target).data(\"ui-slider-handle-index\");switch(event.keyCode){case $.ui.keyCode.HOME:case $.ui.keyCode.END:case $.ui.keyCode.PAGE_UP:case $.ui.keyCode.PAGE_DOWN:case $.ui.keyCode.UP:case $.ui.keyCode.RIGHT:case $.ui.keyCode.DOWN:case $.ui.keyCode.LEFT:event.preventDefault();if(!this._keySliding){this._keySliding=true;$(event.target).addClass(\"ui-state-active\");allowed=this._start(event,index);if(allowed===false){return;}}\n            break;}\n            step=this.options.step;if(this.options.values&&this.options.values.length){curVal=newVal=this.values(index);}else{curVal=newVal=this.value();}\n            switch(event.keyCode){case $.ui.keyCode.HOME:newVal=this._valueMin();break;case $.ui.keyCode.END:newVal=this._valueMax();break;case $.ui.keyCode.PAGE_UP:newVal=this._trimAlignValue(curVal+((this._valueMax()-this._valueMin())/ numPages));break;case $.ui.keyCode.PAGE_DOWN:newVal=this._trimAlignValue(curVal-((this._valueMax()-this._valueMin())/ numPages));break;case $.ui.keyCode.UP:case $.ui.keyCode.RIGHT:if(curVal===this._valueMax()){return;}\n                newVal=this._trimAlignValue(curVal+step);break;case $.ui.keyCode.DOWN:case $.ui.keyCode.LEFT:if(curVal===this._valueMin()){return;}\n                newVal=this._trimAlignValue(curVal-step);break;}\n            this._slide(event,index,newVal);},click:function(event){event.preventDefault();},keyup:function(event){var index=$(event.target).data(\"ui-slider-handle-index\");if(this._keySliding){this._keySliding=false;this._stop(event,index);this._change(event,index);$(event.target).removeClass(\"ui-state-active\");}}}});});\n","Magento_Vault/js/customer_account/deleteWidget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modalToggle',\n    'mage/translate'\n], function ($, modalToggle) {\n    'use strict';\n\n    return function (config, deleteButton) {\n        config.buttons = [\n            {\n                text: $.mage.__('Cancel'),\n                class: 'action secondary cancel'\n            }, {\n                text: $.mage.__('Delete'),\n                class: 'action primary',\n\n                /**\n                 * Default action on button click\n                 */\n                click: function (event) { //eslint-disable-line no-unused-vars\n                    $(deleteButton.form).trigger('submit');\n                }\n            }\n        ];\n\n        modalToggle(config, deleteButton);\n    };\n});\n","Magento_Vault/js/view/payment/vault-enabler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\n/* @api */\ndefine(\n    [\n        'uiElement'\n    ],\n    function (\n        Component\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                isActivePaymentTokenEnabler: true\n            },\n\n            /**\n             * @param {String} paymentCode\n             */\n            setPaymentCode: function (paymentCode) {\n                this.paymentCode = paymentCode;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([\n                        'isActivePaymentTokenEnabler'\n                    ]);\n\n                return this;\n            },\n\n            /**\n             * @param {Object} data\n             */\n            visitAdditionalData: function (data) {\n                if (!this.isVaultEnabled()) {\n                    return;\n                }\n\n                if (!('additional_data' in data)) {\n                    data['additional_data'] = {};\n                }\n\n                data['additional_data']['is_active_payment_token_enabler'] = this.isActivePaymentTokenEnabler();\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isVaultEnabled: function () {\n                return typeof window.checkoutConfig.vault[this.paymentCode] !== 'undefined' &&\n                    window.checkoutConfig.vault[this.paymentCode]['is_enabled'] === true;\n            }\n        });\n    }\n);\n","Magento_Vault/js/view/payment/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\n/* @api */\ndefine([\n    'underscore',\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list',\n    'uiLayout',\n    'uiRegistry'\n], function (_, Component, rendererList, layout, registry) {\n    'use strict';\n\n    var vaultGroupName = 'vaultGroup';\n\n    layout([{\n        name: vaultGroupName,\n        component: 'Magento_Checkout/js/model/payment/method-group',\n        alias: 'vault',\n        sortOrder: 10\n    }]);\n\n    registry.get(vaultGroupName, function (vaultGroup) {\n        _.each(window.checkoutConfig.payment.vault, function (config, index) {\n            rendererList.push(\n                {\n                    type: index,\n                    config: config.config,\n                    component: config.component,\n                    group: vaultGroup,\n\n                    /**\n                     * Custom payment method types comparator\n                     * @param {String} typeA\n                     * @param {String} typeB\n                     * @return {Boolean}\n                     */\n                    typeComparatorCallback: function (typeA, typeB) {\n                        // vault token items have the same name as vault payment without index\n                        return typeA.substring(0, typeA.lastIndexOf('_')) === typeB;\n                    }\n                }\n            );\n        });\n    });\n\n    /**\n     * Add view logic here if needed\n     */\n    return Component.extend({});\n});\n","Magento_Vault/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Checkout/js/action/select-payment-method',\n        'Magento_Checkout/js/checkout-data'\n    ],\n    function (Component, selectPaymentMethod, checkoutData) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Vault/payment/form'\n            },\n\n            /**\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([]);\n\n                return this;\n            },\n\n            /**\n             * @returns\n             */\n            selectPaymentMethod: function () {\n                selectPaymentMethod(\n                    {\n                        method: this.getId()\n                    }\n                );\n                checkoutData.setSelectedPaymentMethod(this.getId());\n\n                return true;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getTitle: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getToken: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getId: function () {\n                return this.index;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Get last 4 digits of card\n             * @returns {String}\n             */\n            getMaskedCard: function () {\n                return '';\n            },\n\n            /**\n             * Get expiration date\n             * @returns {String}\n             */\n            getExpirationDate: function () {\n                return '';\n            },\n\n            /**\n             * Get card type\n             * @returns {String}\n             */\n            getCardType: function () {\n                return '';\n            },\n\n            /**\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.ccform.icons[type]\n                    : false;\n            },\n\n            /**\n             * Return state of place order button.\n             *\n             * @return {Boolean}\n             */\n            isButtonActive: function () {\n                return this.isActive() && this.isPlaceOrderActionAllowed();\n            },\n\n            /**\n             * Check if payment is active.\n             *\n             * @return {Boolean}\n             */\n            isActive: function () {\n                return this.isChecked() === this.getId();\n            },\n\n            /**\n             * @returns {*}\n             */\n            getData: function () {\n                var data = {\n                    method: this.getCode()\n                };\n\n                data['additional_data'] = {};\n                data['additional_data']['public_hash'] = this.getToken();\n\n                return data;\n            }\n        });\n    }\n);\n","Magento_ReCaptchaPaypal/js/payflowpro-method-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/payment/additional-validators'\n], function ($, additionalValidators) {\n    'use strict';\n\n    return function (originalComponent) {\n        return originalComponent.extend({\n            /**\n             * Initializes reCaptcha\n             */\n            placeOrder: function () {\n                var original = this._super.bind(this),\n                    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    isEnabledForPaypal = window.checkoutConfig.recaptcha_paypal,\n                    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    paymentFormSelector = $('#co-payment-form'),\n                    startEvent = 'captcha:startExecute',\n                    endEvent = 'captcha:endExecute';\n\n                if (!this.validateHandler() || !additionalValidators.validate() || !isEnabledForPaypal) {\n                    return original();\n                }\n\n                paymentFormSelector.off(endEvent).on(endEvent, function () {\n                    original();\n                    paymentFormSelector.off(endEvent);\n                });\n\n                paymentFormSelector.trigger(startEvent);\n            }\n        });\n    };\n});\n","Magento_ReCaptchaPaypal/js/reCaptchaPaypal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(\n    [\n        'Magento_ReCaptchaFrontendUi/js/reCaptcha',\n        'jquery'\n    ],\n    function (Component, $) {\n        'use strict';\n\n        return Component.extend({\n\n            /**\n             * Recaptcha callback\n             * @param {String} token\n             */\n            reCaptchaCallback: function (token) {\n                this.tokenField.value = token;\n                this.$parentForm.trigger('captcha:endExecute');\n            },\n\n            /**\n             * Initialize parent form.\n             *\n             * @param {Object} parentForm\n             * @param {String} widgetId\n             */\n            initParentForm: function (parentForm, widgetId) {\n                var me = this;\n\n                parentForm.on('captcha:startExecute', function (event) {\n                    if (!me.tokenField.value && me.getIsInvisibleRecaptcha()) {\n                        // eslint-disable-next-line no-undef\n                        grecaptcha.execute(widgetId);\n                        event.preventDefault(event);\n                        event.stopImmediatePropagation();\n                    } else {\n                        me.$parentForm.trigger('captcha:endExecute');\n                    }\n                });\n\n                // Create a virtual token field\n                this.tokenField = $('<input type=\"text\" name=\"token\" style=\"display: none\" />')[0];\n                this.$parentForm = parentForm;\n                parentForm.append(this.tokenField);\n            }\n        });\n    }\n);\n"}
}});
