require.config({"config": {
        "jsbuild":{"MageBig_WidgetPlus/js/owl.carousel.js":"/**\n * Owl Carousel v2.3.4\n * Copyright 2013-2018 David Deutsch\n * Licensed under: SEE LICENSE IN https://github.com/OwlCarousel2/OwlCarousel2/blob/master/LICENSE\n */\n/**\n * Owl carousel\n * @version 2.3.4\n * @author Bartosz Wojciechowski\n * @author David Deutsch\n * @license The MIT License (MIT)\n * @todo Lazy Load Icon\n * @todo prevent animationend bubling\n * @todo itemsScaleUp\n * @todo Test Zepto\n * @todo stagePadding calculate wrong active classes\n */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\"jquery\"], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    /**\n     * Creates a carousel.\n     * @class The Owl Carousel.\n     * @public\n     * @param {HTMLElement|jQuery} element - The element to create the carousel for.\n     * @param {Object} [options] - The options\n     */\n    function Owl(element, options) {\n\n        /**\n         * Current settings for the carousel.\n         * @public\n         */\n        this.settings = null;\n\n        var runningOnBrowser = typeof window !== \"undefined\";\n        var isBot = runningOnBrowser && !(\"onscroll\" in window) || typeof navigator !== \"undefined\" && /(gle|ing|ro)bot|crawl|spider/i.test(navigator.userAgent);\n        var autoP = options.autoplay;\n        if (autoP && isBot) {\n            options.autoplay = false;\n        }\n\n        /**\n         * Current options set by the caller including defaults.\n         * @public\n         */\n        this.options = $.extend({}, Owl.Defaults, options);\n\n        /**\n         * Plugin element.\n         * @public\n         */\n        this.$element = $(element);\n\n        /**\n         * Proxied event handlers.\n         * @protected\n         */\n        this._handlers = {};\n\n        /**\n         * References to the running plugins of this carousel.\n         * @protected\n         */\n        this._plugins = {};\n\n        /**\n         * Currently suppressed events to prevent them from being retriggered.\n         * @protected\n         */\n        this._supress = {};\n\n        /**\n         * Absolute current position.\n         * @protected\n         */\n        this._current = null;\n\n        /**\n         * Animation speed in milliseconds.\n         * @protected\n         */\n        this._speed = null;\n\n        /**\n         * Coordinates of all items in pixel.\n         * @todo The name of this member is missleading.\n         * @protected\n         */\n        this._coordinates = [];\n\n        /**\n         * Current breakpoint.\n         * @todo Real media queries would be nice.\n         * @protected\n         */\n        this._breakpoint = null;\n\n        /**\n         * Current width of the plugin element.\n         */\n        this._width = null;\n\n        /**\n         * All real items.\n         * @protected\n         */\n        this._items = [];\n\n        /**\n         * All cloned items.\n         * @protected\n         */\n        this._clones = [];\n\n        /**\n         * Merge values of all items.\n         * @todo Maybe this could be part of a plugin.\n         * @protected\n         */\n        this._mergers = [];\n\n        /**\n         * Widths of all items.\n         */\n        this._widths = [];\n\n        /**\n         * Invalidated parts within the update process.\n         * @protected\n         */\n        this._invalidated = {};\n\n        /**\n         * Ordered list of workers for the update process.\n         * @protected\n         */\n        this._pipe = [];\n\n        /**\n         * Current state information for the drag operation.\n         * @todo #261\n         * @protected\n         */\n        this._drag = {\n            time: null,\n            target: null,\n            pointer: null,\n            stage: {\n                start: null,\n                current: null\n            },\n            direction: null\n        };\n\n        /**\n         * Current state information and their tags.\n         * @type {Object}\n         * @protected\n         */\n        this._states = {\n            current: {},\n            tags: {\n                'initializing': ['busy'],\n                'animating': ['busy'],\n                'dragging': ['interacting']\n            }\n        };\n\n        $.each(['onResize', 'onThrottledResize'], $.proxy(function (i, handler) {\n            this._handlers[handler] = $.proxy(this[handler], this);\n        }, this));\n\n        $.each(Owl.Plugins, $.proxy(function (key, plugin) {\n            this._plugins[key.charAt(0).toLowerCase() + key.slice(1)]\n                = new plugin(this);\n        }, this));\n\n        $.each(Owl.Workers, $.proxy(function (priority, worker) {\n            this._pipe.push({\n                'filter': worker.filter,\n                'run': $.proxy(worker.run, this)\n            });\n        }, this));\n\n        this.setup();\n        this.initialize();\n    }\n\n    /**\n     * Default options for the carousel.\n     * @public\n     */\n    Owl.Defaults = {\n        items: 3,\n        loop: false,\n        center: false,\n        rewind: false,\n        checkVisibility: true,\n\n        mouseDrag: true,\n        touchDrag: true,\n        pullDrag: true,\n        freeDrag: false,\n\n        margin: 0,\n        stagePadding: 0,\n\n        merge: false,\n        mergeFit: true,\n        autoWidth: false,\n\n        startPosition: 0,\n        rtl: false,\n\n        smartSpeed: 250,\n        fluidSpeed: false,\n        dragEndSpeed: false,\n\n        responsive: {},\n        responsiveRefreshRate: 200,\n        responsiveBaseElement: window,\n\n        fallbackEasing: 'swing',\n        slideTransition: '',\n\n        info: false,\n\n        nestedItemSelector: false,\n        itemElement: 'div',\n        stageElement: 'div',\n\n        refreshClass: 'owl-refresh',\n        loadedClass: 'owl-loaded',\n        loadingClass: 'owl-loading',\n        rtlClass: 'owl-rtl',\n        responsiveClass: 'owl-responsive',\n        dragClass: 'owl-drag',\n        itemClass: 'owl-item',\n        stageClass: 'owl-stage',\n        stageOuterClass: 'owl-stage-outer',\n        grabClass: 'owl-grab'\n    };\n\n    /**\n     * Enumeration for width.\n     * @public\n     * @readonly\n     * @enum {String}\n     */\n    Owl.Width = {\n        Default: 'default',\n        Inner: 'inner',\n        Outer: 'outer'\n    };\n\n    /**\n     * Enumeration for types.\n     * @public\n     * @readonly\n     * @enum {String}\n     */\n    Owl.Type = {\n        Event: 'event',\n        State: 'state'\n    };\n\n    /**\n     * Contains all registered plugins.\n     * @public\n     */\n    Owl.Plugins = {};\n\n    /**\n     * List of workers involved in the update process.\n     */\n    Owl.Workers = [{\n        filter: ['width', 'settings'],\n        run: function () {\n            this._width = this.$element.width();\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function (cache) {\n            cache.current = this._items && this._items[this.relative(this._current)];\n        }\n    }, {\n        filter: ['items', 'settings'],\n        run: function () {\n            this.$stage.children('.cloned').remove();\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function (cache) {\n            var margin = this.settings.margin || '',\n                grid = !this.settings.autoWidth,\n                rtl = this.settings.rtl,\n                css = {\n                    'width': 'auto',\n                    'margin-left': rtl ? margin : '',\n                    'margin-right': rtl ? '' : margin\n                };\n\n            !grid && this.$stage.children().css(css);\n\n            cache.css = css;\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function (cache) {\n            var width = (this.width() / this.settings.items).toFixed(3) - this.settings.margin,\n                merge = null,\n                iterator = this._items.length,\n                grid = !this.settings.autoWidth,\n                widths = [];\n\n            cache.items = {\n                merge: false,\n                width: width\n            };\n\n            while (iterator--) {\n                merge = this._mergers[iterator];\n                merge = this.settings.mergeFit && Math.min(merge, this.settings.items) || merge;\n\n                cache.items.merge = merge > 1 || cache.items.merge;\n\n                widths[iterator] = !grid ? this._items[iterator].width() : width * merge;\n            }\n\n            this._widths = widths;\n        }\n    }, {\n        filter: ['items', 'settings'],\n        run: function () {\n            var clones = [],\n                items = this._items,\n                settings = this.settings,\n                // TODO: Should be computed from number of min width items in stage\n                view = Math.max(settings.items * 2, 4),\n                size = Math.ceil(items.length / 2) * 2,\n                repeat = settings.loop && items.length ? settings.rewind ? view : Math.max(view, size) : 0,\n                append = '',\n                prepend = '';\n\n            repeat /= 2;\n\n            if (settings.loop && items.length && settings.stagePadding) {\n                repeat += 1;\n            }\n\n            while (repeat > 0) {\n                // Switch to only using appended clones\n                clones.push(this.normalize(clones.length / 2, true));\n                $(items[clones[clones.length - 1]][0]).clone(true).addClass('cloned').appendTo(this.$stage);\n                clones.push(this.normalize(items.length - 1 - (clones.length - 1) / 2, true));\n                $(items[clones[clones.length - 1]][0]).clone(true).addClass('cloned').prependTo(this.$stage);\n                repeat -= 1;\n            }\n\n            this._clones = clones;\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function () {\n            var rtl = this.settings.rtl ? 1 : -1,\n                size = this._clones.length + this._items.length,\n                iterator = -1,\n                previous = 0,\n                current = 0,\n                coordinates = [];\n\n            while (++iterator < size) {\n                previous = coordinates[iterator - 1] || 0;\n                current = this._widths[this.relative(iterator)] + this.settings.margin;\n                coordinates.push(previous + current * rtl);\n            }\n\n            this._coordinates = coordinates;\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function () {\n            var padding = this.settings.stagePadding,\n                coordinates = this._coordinates,\n                css = {\n                    'width': Math.ceil(Math.abs(coordinates[coordinates.length - 1])) + padding + 1,\n                    'padding-right': padding || ''\n                };\n            var rtl = this.settings.rtl ? 1 : -1;\n            if (rtl == 1) {\n                css = {\n                    'width': Math.ceil(Math.abs(coordinates[coordinates.length - 1])) + padding + 1,\n                    'padding-left': padding || ''\n                };\n            }\n\n            this.$stage.css(css);\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function (cache) {\n            var iterator = this._coordinates.length,\n                grid = !this.settings.autoWidth,\n                items = this.$stage.children();\n\n            if (grid && cache.items.merge) {\n                while (iterator--) {\n                    cache.css.width = this._widths[this.relative(iterator)];\n                    items.eq(iterator).css(cache.css);\n                }\n            } else if (grid) {\n                cache.css.width = cache.items.width;\n                items.css(cache.css);\n            }\n        }\n    }, {\n        filter: ['items'],\n        run: function () {\n            this._coordinates.length < 1 && this.$stage.removeAttr('style');\n        }\n    }, {\n        filter: ['width', 'items', 'settings'],\n        run: function (cache) {\n            cache.current = cache.current ? this.$stage.children().index(cache.current) : 0;\n            cache.current = Math.max(this.minimum(), Math.min(this.maximum(), cache.current));\n            this.reset(cache.current);\n        }\n    }, {\n        filter: ['position'],\n        run: function () {\n            this.animate(this.coordinates(this._current));\n        }\n    }, {\n        filter: ['width', 'position', 'items', 'settings'],\n        run: function () {\n            var rtl = this.settings.rtl ? 1 : -1,\n                padding = this.settings.stagePadding,\n                begin = this.coordinates(this.current()) + padding,\n                end = begin + this.width() * rtl,\n                inner, outer, matches = [], i, n;\n\n            for (i = 0, n = this._coordinates.length; i < n; i++) {\n                inner = this._coordinates[i - 1] || 0;\n                outer = Math.abs(this._coordinates[i]) + padding * rtl;\n\n                if ((this.op(inner, '<=', begin) && (this.op(inner, '>', end)))\n                    || (this.op(outer, '<', begin) && this.op(outer, '>', end))) {\n                    matches.push(i);\n                }\n            }\n\n            this.$stage.children('.active').removeClass('active');\n            this.$stage.children(':eq(' + matches.join('), :eq(') + ')').addClass('active');\n\n            this.$stage.children('.center').removeClass('center');\n            if (this.settings.center) {\n                this.$stage.children().eq(this.current()).addClass('center');\n            }\n        }\n    }];\n\n    /**\n     * Create the stage DOM element\n     */\n    Owl.prototype.initializeStage = function () {\n        this.$stage = this.$element.find('.' + this.settings.stageClass);\n\n        // if the stage is already in the DOM, grab it and skip stage initialization\n        if (this.$stage.length) {\n            return;\n        }\n\n        this.$element.addClass(this.options.loadingClass);\n\n        // create stage\n        this.$stage = $('<' + this.settings.stageElement + '>', {\n            \"class\": this.settings.stageClass\n        }).wrap($('<div/>', {\n            \"class\": this.settings.stageOuterClass\n        }));\n\n        // append stage\n        this.$element.append(this.$stage.parent());\n    };\n\n    /**\n     * Create item DOM elements\n     */\n    Owl.prototype.initializeItems = function () {\n        var $items = this.$element.find('.owl-item');\n\n        // if the items are already in the DOM, grab them and skip item initialization\n        if ($items.length) {\n            this._items = $items.get().map(function (item) {\n                return $(item);\n            });\n\n            this._mergers = this._items.map(function () {\n                return 1;\n            });\n\n            this.refresh();\n\n            return;\n        }\n\n        // append content\n        this.replace(this.$element.children().not(this.$stage.parent()));\n\n        // check visibility\n        if (this.isVisible()) {\n            // update view\n            this.refresh();\n        } else {\n            // invalidate width\n            this.invalidate('width');\n        }\n\n        this.$element\n            .removeClass(this.options.loadingClass)\n            .addClass(this.options.loadedClass);\n    };\n\n    /**\n     * Initializes the carousel.\n     * @protected\n     */\n    Owl.prototype.initialize = function () {\n        this.enter('initializing');\n        this.trigger('initialize');\n\n        this.$element.toggleClass(this.settings.rtlClass, this.settings.rtl);\n\n        if (this.settings.autoWidth && !this.is('pre-loading')) {\n            var imgs, nestedSelector, width;\n            imgs = this.$element.find('img');\n            nestedSelector = this.settings.nestedItemSelector ? '.' + this.settings.nestedItemSelector : undefined;\n            width = this.$element.children(nestedSelector).width();\n\n            if (imgs.length && width <= 0) {\n                this.preloadAutoWidthImages(imgs);\n            }\n        }\n\n        this.initializeStage();\n        this.initializeItems();\n\n        // register event handlers\n        this.registerEventHandlers();\n\n        this.leave('initializing');\n        this.trigger('initialized');\n    };\n\n    /**\n     * @returns {Boolean} visibility of $element\n     *                    if you know the carousel will always be visible you can set `checkVisibility` to `false` to\n     *                    prevent the expensive browser layout forced reflow the $element.is(':visible') does\n     */\n    Owl.prototype.isVisible = function () {\n        return this.settings.checkVisibility\n            ? this.$element.is(':visible')\n            : true;\n    };\n\n    /**\n     * Setups the current settings.\n     * @todo Remove responsive classes. Why should adaptive designs be brought into IE8?\n     * @todo Support for media queries by using `matchMedia` would be nice.\n     * @public\n     */\n    Owl.prototype.setup = function () {\n        var viewport = this.viewport(),\n            overwrites = this.options.responsive,\n            match = -1,\n            settings = null;\n\n        if (!overwrites) {\n            settings = $.extend({}, this.options);\n        } else {\n            $.each(overwrites, function (breakpoint) {\n                if (breakpoint <= viewport && breakpoint > match) {\n                    match = Number(breakpoint);\n                }\n            });\n\n            settings = $.extend({}, this.options, overwrites[match]);\n            if (typeof settings.stagePadding === 'function') {\n                settings.stagePadding = settings.stagePadding();\n            }\n            delete settings.responsive;\n\n            // responsive class\n            if (settings.responsiveClass) {\n                this.$element.attr('class',\n                    this.$element.attr('class').replace(new RegExp('(' + this.options.responsiveClass + '-)\\\\S+\\\\s', 'g'), '$1' + match)\n                );\n            }\n        }\n\n        this.trigger('change', {property: {name: 'settings', value: settings}});\n        this._breakpoint = match;\n        this.settings = settings;\n        this.invalidate('settings');\n        this.trigger('changed', {property: {name: 'settings', value: this.settings}});\n    };\n\n    /**\n     * Updates option logic if necessery.\n     * @protected\n     */\n    Owl.prototype.optionsLogic = function () {\n        if (this.settings.autoWidth) {\n            this.settings.stagePadding = false;\n            this.settings.merge = false;\n        }\n    };\n\n    /**\n     * Prepares an item before add.\n     * @todo Rename event parameter `content` to `item`.\n     * @protected\n     * @returns {jQuery|HTMLElement} - The item container.\n     */\n    Owl.prototype.prepare = function (item) {\n        var event = this.trigger('prepare', {content: item});\n\n        if (!event.data) {\n            event.data = $('<' + this.settings.itemElement + '/>')\n                .addClass(this.options.itemClass).append(item)\n        }\n\n        this.trigger('prepared', {content: event.data});\n\n        return event.data;\n    };\n\n    /**\n     * Updates the view.\n     * @public\n     */\n    Owl.prototype.update = function () {\n        var i = 0,\n            n = this._pipe.length,\n            filter = $.proxy(function (p) {\n                return this[p]\n            }, this._invalidated),\n            cache = {};\n\n        while (i < n) {\n            if (this._invalidated.all || $.grep(this._pipe[i].filter, filter).length > 0) {\n                this._pipe[i].run(cache);\n            }\n            i++;\n        }\n\n        this._invalidated = {};\n\n        !this.is('valid') && this.enter('valid');\n    };\n\n    /**\n     * Gets the width of the view.\n     * @public\n     * @param {Owl.Width} [dimension=Owl.Width.Default] - The dimension to return.\n     * @returns {Number} - The width of the view in pixel.\n     */\n    Owl.prototype.width = function (dimension) {\n        dimension = dimension || Owl.Width.Default;\n        switch (dimension) {\n            case Owl.Width.Inner:\n            case Owl.Width.Outer:\n                return this._width;\n            default:\n                return this._width - this.settings.stagePadding + this.settings.margin;\n        }\n    };\n\n    /**\n     * Refreshes the carousel primarily for adaptive purposes.\n     * @public\n     */\n    Owl.prototype.refresh = function (resizing) {\n        resizing = resizing || false;\n\n        this.enter('refreshing');\n        this.trigger('refresh');\n\n        this.setup();\n\n        this.optionsLogic();\n\n        this.$element.addClass(this.options.refreshClass);\n\n        this.update();\n\n        if (!resizing) {\n            this.onResize();\n        }\n\n        this.$element.removeClass(this.options.refreshClass);\n\n        this.leave('refreshing');\n        this.trigger('refreshed');\n    };\n\n    /**\n     * Checks window `resize` event.\n     * @protected\n     */\n    Owl.prototype.onThrottledResize = function () {\n        window.clearTimeout(this.resizeTimer);\n        this.resizeTimer = window.setTimeout(this._handlers.onResize, this.settings.responsiveRefreshRate);\n    };\n\n    /**\n     * Checks window `resize` event.\n     * @protected\n     */\n    Owl.prototype.onResize = function () {\n        var resizing = true;\n\n        if (!this._items.length) {\n            return false;\n        }\n\n        if (this._width === this.$element.width()) {\n            return false;\n        }\n\n        if (!this.isVisible()) {\n            return false;\n        }\n\n        this.enter('resizing');\n\n        if (this.trigger('resize').isDefaultPrevented()) {\n            this.leave('resizing');\n            return false;\n        }\n\n        this.invalidate('width');\n\n        this.refresh(resizing);\n\n        this.leave('resizing');\n        this.trigger('resized');\n    };\n\n    /**\n     * Registers event handlers.\n     * @todo Check `msPointerEnabled`\n     * @todo #261\n     * @protected\n     */\n    Owl.prototype.registerEventHandlers = function () {\n        if ($.support.transition) {\n            this.$stage.on($.support.transition.end + '.owl.core', $.proxy(this.onTransitionEnd, this));\n        }\n\n        if (this.settings.responsive !== false) {\n            this.on(window, 'resize', this._handlers.onThrottledResize);\n            this.on(window, 'drop', this._handlers.onThrottledResize);\n        }\n\n        if (this.settings.mouseDrag) {\n            this.$element.addClass(this.options.dragClass);\n            this.$stage.on('mousedown.owl.core', $.proxy(this.onDragStart, this));\n            this.$stage.on('dragstart.owl.core selectstart.owl.core', function () {\n                return false\n            });\n        }\n\n        if (this.settings.touchDrag) {\n            this.$stage.on('touchstart.owl.core', $.proxy(this.onDragStart, this));\n            this.$stage.on('touchcancel.owl.core', $.proxy(this.onDragEnd, this));\n        }\n    };\n\n    /**\n     * Handles `touchstart` and `mousedown` events.\n     * @todo Horizontal swipe threshold as option\n     * @todo #261\n     * @protected\n     * @param {Event} event - The event arguments.\n     */\n    Owl.prototype.onDragStart = function (event) {\n        var stage = null;\n\n        if (event.which === 3) {\n            return;\n        }\n\n        if ($.support.transform) {\n            stage = this.$stage.css('transform').replace(/.*\\(|\\)| /g, '').split(',');\n            stage = {\n                x: stage[stage.length === 16 ? 12 : 4],\n                y: stage[stage.length === 16 ? 13 : 5]\n            };\n        } else {\n            stage = this.$stage.position();\n            stage = {\n                x: this.settings.rtl ?\n                    stage.left + this.$stage.width() - this.width() + this.settings.margin :\n                    stage.left,\n                y: stage.top\n            };\n        }\n\n        if (this.is('animating')) {\n            $.support.transform ? this.animate(stage.x) : this.$stage.stop()\n            this.invalidate('position');\n        }\n\n        this.$element.toggleClass(this.options.grabClass, event.type === 'mousedown');\n\n        this.speed(0);\n\n        this._drag.time = new Date().getTime();\n        this._drag.target = $(event.target);\n        this._drag.stage.start = stage;\n        this._drag.stage.current = stage;\n        this._drag.pointer = this.pointer(event);\n\n        $(document).on('mouseup.owl.core touchend.owl.core', $.proxy(this.onDragEnd, this));\n\n        $(document).one('mousemove.owl.core touchmove.owl.core', $.proxy(function (event) {\n            var delta = this.difference(this._drag.pointer, this.pointer(event));\n\n            if (Math.abs(delta.x) < Math.abs(delta.y) && this.is('valid')) {\n                return;\n            }\n\n            // event.preventDefault();\n\n            this.enter('dragging');\n            this.trigger('drag');\n            this.onDragMove(event);\n\n            $(document).on('mousemove.owl.core touchmove.owl.core', $.proxy(this.onDragMove, this));\n        }, this));\n    };\n\n    /**\n     * Handles the `touchmove` and `mousemove` events.\n     * @todo #261\n     * @protected\n     * @param {Event} event - The event arguments.\n     */\n    Owl.prototype.onDragMove = function (event) {\n        var minimum = null,\n            maximum = null,\n            pull = null,\n            delta = this.difference(this._drag.pointer, this.pointer(event)),\n            stage = this.difference(this._drag.stage.start, delta);\n\n        if (!this.is('dragging')) {\n            return;\n        }\n\n        // event.preventDefault();\n\n        if (this.settings.loop) {\n            minimum = this.coordinates(this.minimum());\n            maximum = this.coordinates(this.maximum() + 1) - minimum;\n            stage.x = (((stage.x - minimum) % maximum + maximum) % maximum) + minimum;\n        } else {\n            minimum = this.settings.rtl ? this.coordinates(this.maximum()) : this.coordinates(this.minimum());\n            maximum = this.settings.rtl ? this.coordinates(this.minimum()) : this.coordinates(this.maximum());\n            pull = this.settings.pullDrag ? -1 * delta.x / 5 : 0;\n            stage.x = Math.max(Math.min(stage.x, minimum + pull), maximum + pull);\n        }\n\n        this._drag.stage.current = stage;\n\n        this.animate(stage.x);\n    };\n\n    /**\n     * Handles the `touchend` and `mouseup` events.\n     * @todo #261\n     * @todo Threshold for click event\n     * @protected\n     * @param {Event} event - The event arguments.\n     */\n    Owl.prototype.onDragEnd = function (event) {\n        var delta = this.difference(this._drag.pointer, this.pointer(event)),\n            stage = this._drag.stage.current,\n            direction = delta.x > 0 ^ this.settings.rtl ? 'left' : 'right';\n\n        $(document).off('.owl.core');\n\n        this.$element.removeClass(this.options.grabClass);\n\n        if (delta.x !== 0 && this.is('dragging') || !this.is('valid')) {\n            this.speed(this.settings.dragEndSpeed || this.settings.smartSpeed);\n            this.current(this.closest(stage.x, delta.x !== 0 ? direction : this._drag.direction));\n            this.invalidate('position');\n            this.update();\n\n            this._drag.direction = direction;\n\n            if ((Math.abs(delta.x) > 3 || new Date().getTime() - this._drag.time > 300) && (event.type === 'mouseup' || event.type === 'mousedown')) {\n                this._drag.target.one('click.owl.core', function () {\n                    return false;\n                });\n            }\n        }\n\n        if (!this.is('dragging')) {\n            return;\n        }\n\n        this.leave('dragging');\n        this.trigger('dragged');\n    };\n\n    /**\n     * Gets absolute position of the closest item for a coordinate.\n     * @todo Setting `freeDrag` makes `closest` not reusable. See #165.\n     * @protected\n     * @param {Number} coordinate - The coordinate in pixel.\n     * @param {String} direction - The direction to check for the closest item. Ether `left` or `right`.\n     * @return {Number} - The absolute position of the closest item.\n     */\n    Owl.prototype.closest = function (coordinate, direction) {\n        var position = -1,\n            pull = 30,\n            width = this.width(),\n            count = this.settings.items,\n            itemWidth = Math.round(width / count),\n            coordinates = this.coordinates();\n\n        if (!this.settings.freeDrag) {\n            // check closest item\n            $.each(coordinates, $.proxy(function (index, value) {\n                // on a left pull, check on current index\n                if (direction === 'left' && coordinate > value - pull && coordinate < value + pull) {\n                    position = index;\n                    // on a right pull, check on previous index\n                    // to do so, subtract width from value and set position = index + 1\n                } else if (direction === 'right' && coordinate > value - itemWidth - pull && coordinate < value - itemWidth + pull) {\n                    position = index + 1;\n                } else if (this.op(coordinate, '<', value)\n                    && this.op(coordinate, '>', coordinates[index + 1] !== undefined ? coordinates[index + 1] : value - width)) {\n                    position = direction === 'left' ? index + 1 : index;\n                }\n                return position === -1;\n            }, this));\n        }\n\n        if (!this.settings.loop) {\n            // non loop boundries\n            if (this.op(coordinate, '>', coordinates[this.minimum()])) {\n                position = coordinate = this.minimum();\n            } else if (this.op(coordinate, '<', coordinates[this.maximum()])) {\n                position = coordinate = this.maximum();\n            }\n        }\n\n        return position;\n    };\n\n    /**\n     * Animates the stage.\n     * @todo #270\n     * @public\n     * @param {Number} coordinate - The coordinate in pixels.\n     */\n    Owl.prototype.animate = function (coordinate) {\n        var animate = this.speed() > 0;\n\n        this.is('animating') && this.onTransitionEnd();\n\n        if (animate) {\n            this.enter('animating');\n            this.trigger('translate');\n        }\n\n        if ($.support.transform3d && $.support.transition) {\n            this.$stage.css({\n                transform: 'translate3d(' + coordinate + 'px,0px,0px)',\n                transition: (this.speed() / 1000) + 's' + (\n                    this.settings.slideTransition ? ' ' + this.settings.slideTransition : ''\n                )\n            });\n        } else if (animate) {\n            this.$stage.animate({\n                left: coordinate + 'px'\n            }, this.speed(), this.settings.fallbackEasing, $.proxy(this.onTransitionEnd, this));\n        } else {\n            this.$stage.css({\n                left: coordinate + 'px'\n            });\n        }\n    };\n\n    /**\n     * Checks whether the carousel is in a specific state or not.\n     * @param {String} state - The state to check.\n     * @returns {Boolean} - The flag which indicates if the carousel is busy.\n     */\n    Owl.prototype.is = function (state) {\n        return this._states.current[state] && this._states.current[state] > 0;\n    };\n\n    /**\n     * Sets the absolute position of the current item.\n     * @public\n     * @param {Number} [position] - The new absolute position or nothing to leave it unchanged.\n     * @returns {Number} - The absolute position of the current item.\n     */\n    Owl.prototype.current = function (position) {\n        if (position === undefined) {\n            return this._current;\n        }\n\n        if (this._items.length === 0) {\n            return undefined;\n        }\n\n        position = this.normalize(position);\n\n        if (this._current !== position) {\n            var event = this.trigger('change', {property: {name: 'position', value: position}});\n\n            if (event.data !== undefined) {\n                position = this.normalize(event.data);\n            }\n\n            this._current = position;\n\n            this.invalidate('position');\n\n            this.trigger('changed', {property: {name: 'position', value: this._current}});\n        }\n\n        return this._current;\n    };\n\n    /**\n     * Invalidates the given part of the update routine.\n     * @param {String} [part] - The part to invalidate.\n     * @returns {Array.<String>} - The invalidated parts.\n     */\n    Owl.prototype.invalidate = function (part) {\n        if ($.type(part) === 'string') {\n            this._invalidated[part] = true;\n            this.is('valid') && this.leave('valid');\n        }\n        return $.map(this._invalidated, function (v, i) {\n            return i\n        });\n    };\n\n    /**\n     * Resets the absolute position of the current item.\n     * @public\n     * @param {Number} position - The absolute position of the new item.\n     */\n    Owl.prototype.reset = function (position) {\n        position = this.normalize(position);\n\n        if (position === undefined) {\n            return;\n        }\n\n        this._speed = 0;\n        this._current = position;\n\n        this.suppress(['translate', 'translated']);\n\n        this.animate(this.coordinates(position));\n\n        this.release(['translate', 'translated']);\n    };\n\n    /**\n     * Normalizes an absolute or a relative position of an item.\n     * @public\n     * @param {Number} position - The absolute or relative position to normalize.\n     * @param {Boolean} [relative=false] - Whether the given position is relative or not.\n     * @returns {Number} - The normalized position.\n     */\n    Owl.prototype.normalize = function (position, relative) {\n        var n = this._items.length,\n            m = relative ? 0 : this._clones.length;\n\n        if (!this.isNumeric(position) || n < 1) {\n            position = undefined;\n        } else if (position < 0 || position >= n + m) {\n            position = ((position - m / 2) % n + n) % n + m / 2;\n        }\n\n        return position;\n    };\n\n    /**\n     * Converts an absolute position of an item into a relative one.\n     * @public\n     * @param {Number} position - The absolute position to convert.\n     * @returns {Number} - The converted position.\n     */\n    Owl.prototype.relative = function (position) {\n        position -= this._clones.length / 2;\n        return this.normalize(position, true);\n    };\n\n    /**\n     * Gets the maximum position for the current item.\n     * @public\n     * @param {Boolean} [relative=false] - Whether to return an absolute position or a relative position.\n     * @returns {Number}\n     */\n    Owl.prototype.maximum = function (relative) {\n        var settings = this.settings,\n            maximum = this._coordinates.length,\n            iterator,\n            reciprocalItemsWidth,\n            elementWidth;\n\n        if (settings.loop) {\n            maximum = this._clones.length / 2 + this._items.length - 1;\n        } else if (settings.autoWidth || settings.merge) {\n            iterator = this._items.length;\n            if (iterator) {\n                reciprocalItemsWidth = this._items[--iterator].width();\n                elementWidth = this.$element.width();\n                while (iterator--) {\n                    reciprocalItemsWidth += this._items[iterator].width() + this.settings.margin;\n                    if (reciprocalItemsWidth > elementWidth) {\n                        break;\n                    }\n                }\n            }\n            maximum = iterator + 1;\n        } else if (settings.center) {\n            maximum = this._items.length - 1;\n        } else {\n            maximum = this._items.length - settings.items;\n        }\n\n        if (relative) {\n            maximum -= this._clones.length / 2;\n        }\n\n        return Math.max(maximum, 0);\n    };\n\n    /**\n     * Gets the minimum position for the current item.\n     * @public\n     * @param {Boolean} [relative=false] - Whether to return an absolute position or a relative position.\n     * @returns {Number}\n     */\n    Owl.prototype.minimum = function (relative) {\n        return relative ? 0 : this._clones.length / 2;\n    };\n\n    /**\n     * Gets an item at the specified relative position.\n     * @public\n     * @param {Number} [position] - The relative position of the item.\n     * @return {jQuery|Array.<jQuery>} - The item at the given position or all items if no position was given.\n     */\n    Owl.prototype.items = function (position) {\n        if (position === undefined) {\n            return this._items.slice();\n        }\n\n        position = this.normalize(position, true);\n        return this._items[position];\n    };\n\n    /**\n     * Gets an item at the specified relative position.\n     * @public\n     * @param {Number} [position] - The relative position of the item.\n     * @return {jQuery|Array.<jQuery>} - The item at the given position or all items if no position was given.\n     */\n    Owl.prototype.mergers = function (position) {\n        if (position === undefined) {\n            return this._mergers.slice();\n        }\n\n        position = this.normalize(position, true);\n        return this._mergers[position];\n    };\n\n    /**\n     * Gets the absolute positions of clones for an item.\n     * @public\n     * @param {Number} [position] - The relative position of the item.\n     * @returns {Array.<Number>} - The absolute positions of clones for the item or all if no position was given.\n     */\n    Owl.prototype.clones = function (position) {\n        var odd = this._clones.length / 2,\n            even = odd + this._items.length,\n            map = function (index) {\n                return index % 2 === 0 ? even + index / 2 : odd - (index + 1) / 2\n            };\n\n        if (position === undefined) {\n            return $.map(this._clones, function (v, i) {\n                return map(i)\n            });\n        }\n\n        return $.map(this._clones, function (v, i) {\n            return v === position ? map(i) : null\n        });\n    };\n\n    /**\n     * Sets the current animation speed.\n     * @public\n     * @param {Number} [speed] - The animation speed in milliseconds or nothing to leave it unchanged.\n     * @returns {Number} - The current animation speed in milliseconds.\n     */\n    Owl.prototype.speed = function (speed) {\n        if (speed !== undefined) {\n            this._speed = speed;\n        }\n\n        return this._speed;\n    };\n\n    /**\n     * Gets the coordinate of an item.\n     * @todo The name of this method is missleanding.\n     * @public\n     * @param {Number} position - The absolute position of the item within `minimum()` and `maximum()`.\n     * @returns {Number|Array.<Number>} - The coordinate of the item in pixel or all coordinates.\n     */\n    Owl.prototype.coordinates = function (position) {\n        var multiplier = 1,\n            newPosition = position - 1,\n            coordinate;\n\n        if (position === undefined) {\n            return $.map(this._coordinates, $.proxy(function (coordinate, index) {\n                return this.coordinates(index);\n            }, this));\n        }\n\n        if (this.settings.center) {\n            if (this.settings.rtl) {\n                multiplier = -1;\n                newPosition = position + 1;\n            }\n\n            coordinate = this._coordinates[position];\n            var delta = (this.settings.rtl) ? (this._coordinates[0] + this._coordinates[this._coordinates.length - 1]) : 0;\n            coordinate += (this.width() - coordinate + (this._coordinates[newPosition] || delta)) / 2 * multiplier;\n        } else {\n            coordinate = this._coordinates[newPosition] || 0;\n        }\n\n        coordinate = Math.ceil(coordinate);\n\n        return coordinate;\n    };\n\n    /**\n     * Calculates the speed for a translation.\n     * @protected\n     * @param {Number} from - The absolute position of the start item.\n     * @param {Number} to - The absolute position of the target item.\n     * @param {Number} [factor=undefined] - The time factor in milliseconds.\n     * @returns {Number} - The time in milliseconds for the translation.\n     */\n    Owl.prototype.duration = function (from, to, factor) {\n        if (factor === 0) {\n            return 0;\n        }\n\n        return Math.min(Math.max(Math.abs(to - from), 1), 6) * Math.abs((factor || this.settings.smartSpeed));\n    };\n\n    /**\n     * Slides to the specified item.\n     * @public\n     * @param {Number} position - The position of the item.\n     * @param {Number} [speed] - The time in milliseconds for the transition.\n     */\n    Owl.prototype.to = function (position, speed) {\n        var current = this.current(),\n            revert = null,\n            distance = position - this.relative(current),\n            items = this._items.length,\n            minimum = this.minimum(),\n            maximum = this.maximum();\n\n        if (this.settings.loop) {\n            position = current + distance;\n            revert = ((position - minimum) % items + items) % items + minimum;\n\n            if (Math.abs(distance) > items / 2)\t{\n                maximum += 1;\n            }\n\n            if (revert !== position && revert - distance <= maximum && revert - distance > 0) {\n                current = revert - distance;\n                position = revert;\n                this.reset(current);\n            } else if ( revert !== position && position < 0) {\n                current = revert - Math.floor(items / 2);\n                if (Math.abs(distance) > items / 2) {\n                    current += Math.abs(distance) - Math.ceil(items / 2);\n                }\n                position = current + distance;\n                this.reset(current);\n            }\n        } else if (this.settings.rewind) {\n            maximum += 1;\n            position = (position % maximum + maximum) % maximum;\n        } else {\n            position = Math.max(minimum, Math.min(maximum, position));\n        }\n\n        this.speed(this.duration(current, position, speed));\n        this.current(position);\n\n        if (this.isVisible()) {\n            this.update();\n        }\n    };\n\n    /**\n     * Slides to the next item.\n     * @public\n     * @param {Number} [speed] - The time in milliseconds for the transition.\n     */\n    Owl.prototype.next = function (speed) {\n        speed = speed || false;\n        this.to(this.relative(this.current()) + 1, speed);\n    };\n\n    /**\n     * Slides to the previous item.\n     * @public\n     * @param {Number} [speed] - The time in milliseconds for the transition.\n     */\n    Owl.prototype.prev = function (speed) {\n        speed = speed || false;\n        this.to(this.relative(this.current()) - 1, speed);\n    };\n\n    /**\n     * Handles the end of an animation.\n     * @protected\n     * @param {Event} event - The event arguments.\n     */\n    Owl.prototype.onTransitionEnd = function (event) {\n\n        // if css2 animation then event object is undefined\n        if (event !== undefined) {\n            event.stopPropagation();\n\n            // Catch only owl-stage transitionEnd event\n            if ((event.target || event.srcElement || event.originalTarget) !== this.$stage.get(0)) {\n                return false;\n            }\n        }\n\n        this.leave('animating');\n        this.trigger('translated');\n    };\n\n    /**\n     * Gets viewport width.\n     * @protected\n     * @return {Number} - The width in pixel.\n     */\n    Owl.prototype.viewport = function () {\n        var width;\n        if (this.options.responsiveBaseElement !== window) {\n            width = $(this.options.responsiveBaseElement).innerWidth();\n        } else if (window.innerWidth) {\n            width = window.innerWidth;\n        } else if (document.documentElement && document.documentElement.clientWidth) {\n            width = document.documentElement.clientWidth;\n        } else {\n            console.warn('Can not detect viewport width.');\n        }\n        return width;\n    };\n\n    /**\n     * Replaces the current content.\n     * @public\n     * @param {HTMLElement|jQuery|String} content - The new content.\n     */\n    Owl.prototype.replace = function (content) {\n        this.$stage.empty();\n        this._items = [];\n\n        if (content) {\n            content = (content instanceof jQuery) ? content : $(content);\n        }\n\n        if (this.settings.nestedItemSelector) {\n            content = content.find('.' + this.settings.nestedItemSelector);\n        }\n\n        content.filter(function () {\n            return this.nodeType === 1;\n        }).each($.proxy(function (index, item) {\n            item = this.prepare(item);\n            this.$stage.append(item);\n            this._items.push(item);\n            this._mergers.push(item.find('[data-merge]').addBack('[data-merge]').attr('data-merge') * 1 || 1);\n        }, this));\n\n        this.reset(this.isNumeric(this.settings.startPosition) ? this.settings.startPosition : 0);\n\n        this.invalidate('items');\n    };\n\n    /**\n     * Adds an item.\n     * @todo Use `item` instead of `content` for the event arguments.\n     * @public\n     * @param {HTMLElement|jQuery|String} content - The item content to add.\n     * @param {Number} [position] - The relative position at which to insert the item otherwise the item will be added to the end.\n     */\n    Owl.prototype.add = function (content, position) {\n        var current = this.relative(this._current);\n\n        position = position === undefined ? this._items.length : this.normalize(position, true);\n        content = content instanceof jQuery ? content : $(content);\n\n        this.trigger('add', {content: content, position: position});\n\n        content = this.prepare(content);\n\n        if (this._items.length === 0 || position === this._items.length) {\n            this._items.length === 0 && this.$stage.append(content);\n            this._items.length !== 0 && this._items[position - 1].after(content);\n            this._items.push(content);\n            this._mergers.push(content.find('[data-merge]').addBack('[data-merge]').attr('data-merge') * 1 || 1);\n        } else {\n            this._items[position].before(content);\n            this._items.splice(position, 0, content);\n            this._mergers.splice(position, 0, content.find('[data-merge]').addBack('[data-merge]').attr('data-merge') * 1 || 1);\n        }\n\n        this._items[current] && this.reset(this._items[current].index());\n\n        this.invalidate('items');\n\n        this.trigger('added', {content: content, position: position});\n    };\n\n    /**\n     * Removes an item by its position.\n     * @todo Use `item` instead of `content` for the event arguments.\n     * @public\n     * @param {Number} position - The relative position of the item to remove.\n     */\n    Owl.prototype.remove = function (position) {\n        position = this.normalize(position, true);\n\n        if (position === undefined) {\n            return;\n        }\n\n        this.trigger('remove', {content: this._items[position], position: position});\n\n        this._items[position].remove();\n        this._items.splice(position, 1);\n        this._mergers.splice(position, 1);\n\n        this.invalidate('items');\n\n        this.trigger('removed', {content: null, position: position});\n    };\n\n    /**\n     * Preloads images with auto width.\n     * @todo Replace by a more generic approach\n     * @protected\n     */\n    Owl.prototype.preloadAutoWidthImages = function (images) {\n        images.each($.proxy(function (i, element) {\n            this.enter('pre-loading');\n            element = $(element);\n            $(new Image()).one('load', $.proxy(function (e) {\n                element.attr('src', e.target.src);\n                element.css('opacity', 1);\n                this.leave('pre-loading');\n                !this.is('pre-loading') && !this.is('initializing') && this.refresh();\n            }, this)).attr('src', (window.devicePixelRatio > 1) ? element.attr('data-src-retina') : element.attr('data-src') || element.attr('src'));\n        }, this));\n    };\n\n    /**\n     * Destroys the carousel.\n     * @public\n     */\n    Owl.prototype.destroy = function () {\n\n        this.$element.off('.owl.core');\n        this.$stage.off('.owl.core');\n        $(document).off('.owl.core');\n\n        if (this.settings.responsive !== false) {\n            window.clearTimeout(this.resizeTimer);\n            this.off(window, 'resize', this._handlers.onThrottledResize);\n        }\n\n        for (var i in this._plugins) {\n            this._plugins[i].destroy();\n        }\n\n        this.$stage.children('.cloned').remove();\n\n        this.$stage.unwrap();\n        this.$stage.children().contents().unwrap();\n        this.$stage.children().unwrap();\n        this.$stage.remove();\n        this.$element\n            .removeClass(this.options.refreshClass)\n            .removeClass(this.options.loadingClass)\n            .removeClass(this.options.loadedClass)\n            .removeClass(this.options.rtlClass)\n            .removeClass(this.options.dragClass)\n            .removeClass(this.options.grabClass)\n            .attr('class', this.$element.attr('class').replace(new RegExp(this.options.responsiveClass + '-\\\\S+\\\\s', 'g'), ''))\n            .removeData('owl.carousel');\n    };\n\n    /**\n     * Operators to calculate right-to-left and left-to-right.\n     * @protected\n     * @param {Number} [a] - The left side operand.\n     * @param {String} [o] - The operator.\n     * @param {Number} [b] - The right side operand.\n     */\n    Owl.prototype.op = function (a, o, b) {\n        var rtl = this.settings.rtl;\n        switch (o) {\n            case '<':\n                return rtl ? a > b : a < b;\n            case '>':\n                return rtl ? a < b : a > b;\n            case '>=':\n                return rtl ? a <= b : a >= b;\n            case '<=':\n                return rtl ? a >= b : a <= b;\n            default:\n                break;\n        }\n    };\n\n    /**\n     * Attaches to an internal event.\n     * @protected\n     * @param {HTMLElement} element - The event source.\n     * @param {String} event - The event name.\n     * @param {Function} listener - The event handler to attach.\n     * @param {Boolean} capture - Wether the event should be handled at the capturing phase or not.\n     */\n    Owl.prototype.on = function (element, event, listener, capture) {\n        if (element.addEventListener) {\n            element.addEventListener(event, listener, capture);\n        } else if (element.attachEvent) {\n            element.attachEvent('on' + event, listener);\n        }\n    };\n\n    /**\n     * Detaches from an internal event.\n     * @protected\n     * @param {HTMLElement} element - The event source.\n     * @param {String} event - The event name.\n     * @param {Function} listener - The attached event handler to detach.\n     * @param {Boolean} capture - Wether the attached event handler was registered as a capturing listener or not.\n     */\n    Owl.prototype.off = function (element, event, listener, capture) {\n        if (element.removeEventListener) {\n            element.removeEventListener(event, listener, capture);\n        } else if (element.detachEvent) {\n            element.detachEvent('on' + event, listener);\n        }\n    };\n\n    /**\n     * Triggers a public event.\n     * @todo Remove `status`, `relatedTarget` should be used instead.\n     * @protected\n     * @param {String} name - The event name.\n     * @param {*} [data=null] - The event data.\n     * @param {String} [namespace=carousel] - The event namespace.\n     * @param {String} [state] - The state which is associated with the event.\n     * @param {Boolean} [enter=false] - Indicates if the call enters the specified state or not.\n     * @returns {Event} - The event arguments.\n     */\n    Owl.prototype.trigger = function (name, data, namespace, state, enter) {\n        var status = {\n            item: {count: this._items.length, index: this.current()}\n        }, handler = $.camelCase(\n            $.grep(['on', name, namespace], function (v) {\n                return v\n            })\n                .join('-').toLowerCase()\n        ), event = $.Event(\n            [name, 'owl', namespace || 'carousel'].join('.').toLowerCase(),\n            $.extend({relatedTarget: this}, status, data)\n        );\n\n        if (!this._supress[name]) {\n            $.each(this._plugins, function (name, plugin) {\n                if (plugin.onTrigger) {\n                    plugin.onTrigger(event);\n                }\n            });\n\n            this.register({type: Owl.Type.Event, name: name});\n            this.$element.trigger(event);\n\n            if (this.settings && typeof this.settings[handler] === 'function') {\n                this.settings[handler].call(this, event);\n            }\n        }\n\n        return event;\n    };\n\n    /**\n     * Enters a state.\n     * @param name - The state name.\n     */\n    Owl.prototype.enter = function (name) {\n        $.each([name].concat(this._states.tags[name] || []), $.proxy(function (i, name) {\n            if (this._states.current[name] === undefined) {\n                this._states.current[name] = 0;\n            }\n\n            this._states.current[name]++;\n        }, this));\n    };\n\n    /**\n     * Leaves a state.\n     * @param name - The state name.\n     */\n    Owl.prototype.leave = function (name) {\n        $.each([name].concat(this._states.tags[name] || []), $.proxy(function (i, name) {\n            this._states.current[name]--;\n        }, this));\n    };\n\n    /**\n     * Registers an event or state.\n     * @public\n     * @param {Object} object - The event or state to register.\n     */\n    Owl.prototype.register = function (object) {\n        if (object.type === Owl.Type.Event) {\n            if (!$.event.special[object.name]) {\n                $.event.special[object.name] = {};\n            }\n\n            if (!$.event.special[object.name].owl) {\n                var _default = $.event.special[object.name]._default;\n                $.event.special[object.name]._default = function (e) {\n                    if (_default && _default.apply && (!e.namespace || e.namespace.indexOf('owl') === -1)) {\n                        return _default.apply(this, arguments);\n                    }\n                    return e.namespace && e.namespace.indexOf('owl') > -1;\n                };\n                $.event.special[object.name].owl = true;\n            }\n        } else if (object.type === Owl.Type.State) {\n            if (!this._states.tags[object.name]) {\n                this._states.tags[object.name] = object.tags;\n            } else {\n                this._states.tags[object.name] = this._states.tags[object.name].concat(object.tags);\n            }\n\n            this._states.tags[object.name] = $.grep(this._states.tags[object.name], $.proxy(function (tag, i) {\n                return $.inArray(tag, this._states.tags[object.name]) === i;\n            }, this));\n        }\n    };\n\n    /**\n     * Suppresses events.\n     * @protected\n     * @param {Array.<String>} events - The events to suppress.\n     */\n    Owl.prototype.suppress = function (events) {\n        $.each(events, $.proxy(function (index, event) {\n            this._supress[event] = true;\n        }, this));\n    };\n\n    /**\n     * Releases suppressed events.\n     * @protected\n     * @param {Array.<String>} events - The events to release.\n     */\n    Owl.prototype.release = function (events) {\n        $.each(events, $.proxy(function (index, event) {\n            delete this._supress[event];\n        }, this));\n    };\n\n    /**\n     * Gets unified pointer coordinates from event.\n     * @todo #261\n     * @protected\n     * @param {Event} - The `mousedown` or `touchstart` event.\n     * @returns {Object} - Contains `x` and `y` coordinates of current pointer position.\n     */\n    Owl.prototype.pointer = function (event) {\n        var result = {x: null, y: null};\n\n        event = event.originalEvent || event || window.event;\n\n        event = event.touches && event.touches.length ?\n            event.touches[0] : event.changedTouches && event.changedTouches.length ?\n                event.changedTouches[0] : event;\n\n        if (event.pageX) {\n            result.x = event.pageX;\n            result.y = event.pageY;\n        } else {\n            result.x = event.clientX;\n            result.y = event.clientY;\n        }\n\n        return result;\n    };\n\n    /**\n     * Determines if the input is a Number or something that can be coerced to a Number\n     * @protected\n     * @param {Number|String|Object|Array|Boolean|RegExp|Function|Symbol} - The input to be tested\n     * @returns {Boolean} - An indication if the input is a Number or can be coerced to a Number\n     */\n    Owl.prototype.isNumeric = function (number) {\n        return !isNaN(parseFloat(number));\n    };\n\n    /**\n     * Gets the difference of two vectors.\n     * @todo #261\n     * @protected\n     * @param {Object} - The first vector.\n     * @param {Object} - The second vector.\n     * @returns {Object} - The difference.\n     */\n    Owl.prototype.difference = function (first, second) {\n        return {\n            x: first.x - second.x,\n            y: first.y - second.y\n        };\n    };\n\n    /**\n     * The jQuery Plugin for the Owl Carousel\n     * @todo Navigation plugin `next` and `prev`\n     * @public\n     */\n    $.fn.owlCarousel = function (option) {\n        var args = Array.prototype.slice.call(arguments, 1);\n\n        return this.each(function () {\n            var $this = $(this),\n                data = $this.data('owl.carousel');\n\n            if (!data) {\n                data = new Owl(this, typeof option == 'object' && option);\n                $this.data('owl.carousel', data);\n\n                $.each([\n                    'next', 'prev', 'to', 'destroy', 'refresh', 'replace', 'add', 'remove'\n                ], function (i, event) {\n                    data.register({type: Owl.Type.Event, name: event});\n                    data.$element.on(event + '.owl.carousel.core', $.proxy(function (e) {\n                        if (e.namespace && e.relatedTarget !== this) {\n                            this.suppress([event]);\n                            data[event].apply(this, [].slice.call(arguments, 1));\n                            this.release([event]);\n                        }\n                    }, data));\n                });\n            }\n\n            if (typeof option == 'string' && option.charAt(0) !== '_') {\n                data[option].apply(data, args);\n            }\n        });\n    };\n\n    /**\n     * The constructor for the jQuery Plugin\n     * @public\n     */\n    $.fn.owlCarousel.Constructor = Owl;\n\n\n    /**\n     * AutoRefresh Plugin\n     * @version 2.3.4\n     * @author Artus Kolanowski\n     * @author David Deutsch\n     * @license The MIT License (MIT)\n     */\n\n\n    /**\n     * Creates the auto refresh plugin.\n     * @class The Auto Refresh Plugin\n     * @param {Owl} carousel - The Owl Carousel\n     */\n    var AutoRefresh = function (carousel) {\n        /**\n         * Reference to the core.\n         * @protected\n         * @type {Owl}\n         */\n        this._core = carousel;\n\n        /**\n         * Refresh interval.\n         * @protected\n         * @type {number}\n         */\n        this._interval = null;\n\n        /**\n         * Whether the element is currently visible or not.\n         * @protected\n         * @type {Boolean}\n         */\n        this._visible = null;\n\n        /**\n         * All event handlers.\n         * @protected\n         * @type {Object}\n         */\n        this._handlers = {\n            'initialized.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._core.settings.autoRefresh) {\n                    this.watch();\n                }\n            }, this)\n        };\n\n        // set default options\n        this._core.options = $.extend({}, AutoRefresh.Defaults, this._core.options);\n\n        // register event handlers\n        this._core.$element.on(this._handlers);\n    };\n\n    /**\n     * Default options.\n     * @public\n     */\n    AutoRefresh.Defaults = {\n        autoRefresh: true,\n        autoRefreshInterval: 500\n    };\n\n    /**\n     * Watches the element.\n     */\n    AutoRefresh.prototype.watch = function () {\n        if (this._interval) {\n            return;\n        }\n\n        this._visible = this._core.isVisible();\n        this._interval = window.setInterval($.proxy(this.refresh, this), this._core.settings.autoRefreshInterval);\n    };\n\n    /**\n     * Refreshes the element.\n     */\n    AutoRefresh.prototype.refresh = function () {\n        if (this._core.isVisible() === this._visible) {\n            return;\n        }\n\n        this._visible = !this._visible;\n\n        this._core.$element.toggleClass('owl-hidden', !this._visible);\n\n        this._visible && (this._core.invalidate('width') && this._core.refresh());\n    };\n\n    /**\n     * Destroys the plugin.\n     */\n    AutoRefresh.prototype.destroy = function () {\n        var handler, property;\n\n        window.clearInterval(this._interval);\n\n        for (handler in this._handlers) {\n            this._core.$element.off(handler, this._handlers[handler]);\n        }\n        for (property in Object.getOwnPropertyNames(this)) {\n            typeof this[property] != 'function' && (this[property] = null);\n        }\n    };\n\n    $.fn.owlCarousel.Constructor.Plugins.AutoRefresh = AutoRefresh;\n\n\n    /**\n     * Lazy Plugin\n     * @version 2.3.4\n     * @author Bartosz Wojciechowski\n     * @author David Deutsch\n     * @license The MIT License (MIT)\n     */\n\n\n    /**\n     * Creates the lazy plugin.\n     * @class The Lazy Plugin\n     * @param {Owl} carousel - The Owl Carousel\n     */\n    var Lazy = function (carousel) {\n\n        /**\n         * Reference to the core.\n         * @protected\n         * @type {Owl}\n         */\n        this._core = carousel;\n\n        /**\n         * Already loaded items.\n         * @protected\n         * @type {Array.<jQuery>}\n         */\n        this._loaded = [];\n\n        /**\n         * Event handlers.\n         * @protected\n         * @type {Object}\n         */\n        this._handlers = {\n            'initialized.owl.carousel change.owl.carousel resized.owl.carousel': $.proxy(function (e) {\n                if (!e.namespace) {\n                    return;\n                }\n\n                if (!this._core.settings || !this._core.settings.lazyLoad) {\n                    return;\n                }\n\n                if ((e.property && e.property.name === 'position') || e.type === 'initialized' || e.type === 'resized') {\n                    var settings = this._core.settings,\n                        n = (settings.center && Math.ceil(settings.items / 2) || settings.items),\n                        i = ((settings.center && n * -1) || 0),\n                        position = (e.property && e.property.value !== undefined ? e.property.value : this._core.current()) + i,\n                        clones = this._core.clones().length,\n                        load = $.proxy(function (i, v) {\n                            this.load(v)\n                        }, this);\n                    //TODO: Need documentation for this new option\n                    if (settings.lazyLoadEager > 0) {\n                        n += settings.lazyLoadEager;\n                        // If the carousel is looping also preload images that are to the \"left\"\n                        if (settings.loop) {\n                            position -= settings.lazyLoadEager;\n                            n++;\n                        }\n                    }\n\n                    if (!settings.center && settings.stagePadding) {\n                        position--;\n                        n += 2;\n                    }\n\n                    while (i++ < n) {\n                        this.load(clones / 2 + this._core.relative(position));\n                        clones && $.each(this._core.clones(this._core.relative(position)), load);\n                        position++;\n                    }\n                }\n            }, this)\n        };\n\n        // set the default options\n        this._core.options = $.extend({}, Lazy.Defaults, this._core.options);\n\n        // register event handler\n        this._core.$element.on(this._handlers);\n    };\n\n    /**\n     * Animate Plugin\n     * @version 2.3.4\n     * @author Bartosz Wojciechowski\n     * @author David Deutsch\n     * @license The MIT License (MIT)\n     */\n\n\n    /**\n     * Creates the animate plugin.\n     * @class The Navigation Plugin\n     * @param {Owl} scope - The Owl Carousel\n     */\n    var Animate = function (scope) {\n        this.core = scope;\n        this.core.options = $.extend({}, Animate.Defaults, this.core.options);\n        this.swapping = true;\n        this.previous = undefined;\n        this.next = undefined;\n\n        this.handlers = {\n            'change.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && e.property.name == 'position') {\n                    this.previous = this.core.current();\n                    this.next = e.property.value;\n                }\n            }, this),\n            'drag.owl.carousel dragged.owl.carousel translated.owl.carousel': $.proxy(function (e) {\n                if (e.namespace) {\n                    this.swapping = e.type == 'translated';\n                }\n            }, this),\n            'translate.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this.swapping && (this.core.options.animateOut || this.core.options.animateIn)) {\n                    this.swap();\n                }\n            }, this)\n        };\n\n        this.core.$element.on(this.handlers);\n    };\n\n    /**\n     * Default options.\n     * @public\n     */\n    Animate.Defaults = {\n        animateOut: false,\n        animateIn: false\n    };\n\n    /**\n     * Toggles the animation classes whenever an translations starts.\n     * @protected\n     * @returns {Boolean|undefined}\n     */\n    Animate.prototype.swap = function () {\n\n        if (this.core.settings.items !== 1) {\n            return;\n        }\n\n        if (!$.support.animation || !$.support.transition) {\n            return;\n        }\n\n        this.core.speed(0);\n\n        var left,\n            clear = $.proxy(this.clear, this),\n            previous = this.core.$stage.children().eq(this.previous),\n            next = this.core.$stage.children().eq(this.next),\n            incoming = this.core.settings.animateIn,\n            outgoing = this.core.settings.animateOut;\n\n        if (this.core.current() === this.previous) {\n            return;\n        }\n\n        if (outgoing) {\n            left = this.core.coordinates(this.previous) - this.core.coordinates(this.next);\n            previous.one($.support.animation.end, clear)\n                .css({'left': left + 'px'})\n                .addClass('animated owl-animated-out')\n                .addClass(outgoing);\n        }\n\n        if (incoming) {\n            next.one($.support.animation.end, clear)\n                .addClass('animated owl-animated-in')\n                .addClass(incoming);\n        }\n    };\n\n    Animate.prototype.clear = function (e) {\n        $(e.target).css({'left': ''})\n            .removeClass('animated owl-animated-out owl-animated-in')\n            .removeClass(this.core.settings.animateIn)\n            .removeClass(this.core.settings.animateOut);\n        this.core.onTransitionEnd();\n    };\n\n    /**\n     * Destroys the plugin.\n     * @public\n     */\n    Animate.prototype.destroy = function () {\n        var handler, property;\n\n        for (handler in this.handlers) {\n            this.core.$element.off(handler, this.handlers[handler]);\n        }\n        for (property in Object.getOwnPropertyNames(this)) {\n            typeof this[property] != 'function' && (this[property] = null);\n        }\n    };\n\n    $.fn.owlCarousel.Constructor.Plugins.Animate = Animate;\n\n\n    /**\n     * Autoplay Plugin\n     * @version 2.3.4\n     * @author Bartosz Wojciechowski\n     * @author Artus Kolanowski\n     * @author David Deutsch\n     * @author Tom De Caluw\u00e9\n     * @license The MIT License (MIT)\n     */\n\n\n    /**\n     * Creates the autoplay plugin.\n     * @class The Autoplay Plugin\n     * @param {Owl} scope - The Owl Carousel\n     */\n    var Autoplay = function (carousel) {\n        /**\n         * Reference to the core.\n         * @protected\n         * @type {Owl}\n         */\n        this._core = carousel;\n\n        /**\n         * The autoplay timeout id.\n         * @type {Number}\n         */\n        this._call = null;\n\n        /**\n         * Depending on the state of the plugin, this variable contains either\n         * the start time of the timer or the current timer value if it's\n         * paused. Since we start in a paused state we initialize the timer\n         * value.\n         * @type {Number}\n         */\n        this._time = 0;\n\n        /**\n         * Stores the timeout currently used.\n         * @type {Number}\n         */\n        this._timeout = 0;\n\n        /**\n         * Indicates whenever the autoplay is paused.\n         * @type {Boolean}\n         */\n        this._paused = true;\n\n        /**\n         * All event handlers.\n         * @protected\n         * @type {Object}\n         */\n        this._handlers = {\n            'changed.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && e.property.name === 'settings') {\n                    if (this._core.settings.autoplay) {\n                        this.play();\n                    } else {\n                        this.stop();\n                    }\n                } else if (e.namespace && e.property.name === 'position' && this._paused) {\n                    // Reset the timer. This code is triggered when the position\n                    // of the carousel was changed through user interaction.\n                    this._time = 0;\n                }\n            }, this),\n            'initialized.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._core.settings.autoplay) {\n                    this.play();\n                }\n            }, this),\n            'play.owl.autoplay': $.proxy(function (e, t, s) {\n                if (e.namespace) {\n                    this.play(t, s);\n                }\n            }, this),\n            'stop.owl.autoplay': $.proxy(function (e) {\n                if (e.namespace) {\n                    this.stop();\n                }\n            }, this),\n            'mouseover.owl.autoplay': $.proxy(function () {\n                if (this._core.settings.autoplayHoverPause && this._core.is('rotating')) {\n                    this.pause();\n                }\n            }, this),\n            'mouseleave.owl.autoplay': $.proxy(function () {\n                if (this._core.settings.autoplayHoverPause && this._core.is('rotating')) {\n                    this.play();\n                }\n            }, this),\n            'touchstart.owl.core': $.proxy(function () {\n                if (this._core.settings.autoplayHoverPause && this._core.is('rotating')) {\n                    this.pause();\n                }\n            }, this),\n            'touchend.owl.core': $.proxy(function () {\n                if (this._core.settings.autoplayHoverPause) {\n                    this.play();\n                }\n            }, this)\n        };\n\n        var eventPassive = ['wheel', 'scroll', 'touchstart', 'touchmove', 'mousewheel'];\n        $.each(eventPassive, function (index, event) {\n            $.event.special[event] = {\n                setup: function (_, ns, handle) {\n                    this.addEventListener(event, handle, {passive: !!ns.indexOf('noPreventDefault')});\n                }\n            };\n        });\n\n        // register event handlers\n        this._core.$element.on(this._handlers);\n\n        // set default options\n        this._core.options = $.extend({}, Autoplay.Defaults, this._core.options);\n    };\n\n    /**\n     * Default options.\n     * @public\n     */\n    Autoplay.Defaults = {\n        autoplay: false,\n        autoplayTimeout: 5000,\n        autoplayHoverPause: false,\n        autoplaySpeed: false\n    };\n\n    /**\n     * Transition to the next slide and set a timeout for the next transition.\n     * @private\n     * @param {Number} [speed] - The animation speed for the animations.\n     */\n    Autoplay.prototype._next = function (speed) {\n        this._call = window.setTimeout(\n            $.proxy(this._next, this, speed),\n            this._timeout * (Math.round(this.read() / this._timeout) + 1) - this.read()\n        );\n\n        if (this._core.is('interacting') || document.hidden) {\n            return;\n        }\n        this._core.next(speed || this._core.settings.autoplaySpeed);\n    }\n\n    /**\n     * Reads the current timer value when the timer is playing.\n     * @public\n     */\n    Autoplay.prototype.read = function () {\n        return new Date().getTime() - this._time;\n    };\n\n    /**\n     * Starts the autoplay.\n     * @public\n     * @param {Number} [timeout] - The interval before the next animation starts.\n     * @param {Number} [speed] - The animation speed for the animations.\n     */\n    Autoplay.prototype.play = function (timeout, speed) {\n        var elapsed;\n\n        if (!this._core.is('rotating')) {\n            this._core.enter('rotating');\n        }\n\n        timeout = timeout || this._core.settings.autoplayTimeout;\n\n        // Calculate the elapsed time since the last transition. If the carousel\n        // wasn't playing this calculation will yield zero.\n        elapsed = Math.min(this._time % (this._timeout || timeout), timeout);\n\n        if (this._paused) {\n            // Start the clock.\n            this._time = this.read();\n            this._paused = false;\n        } else {\n            // Clear the active timeout to allow replacement.\n            window.clearTimeout(this._call);\n        }\n\n        // Adjust the origin of the timer to match the new timeout value.\n        this._time += this.read() % timeout - elapsed;\n\n        this._timeout = timeout;\n        this._call = window.setTimeout($.proxy(this._next, this, speed), timeout - elapsed);\n    };\n\n    /**\n     * Stops the autoplay.\n     * @public\n     */\n    Autoplay.prototype.stop = function () {\n        if (this._core.is('rotating')) {\n            // Reset the clock.\n            this._time = 0;\n            this._paused = true;\n\n            window.clearTimeout(this._call);\n            this._core.leave('rotating');\n        }\n    };\n\n    /**\n     * Pauses the autoplay.\n     * @public\n     */\n    Autoplay.prototype.pause = function () {\n        if (this._core.is('rotating') && !this._paused) {\n            // Pause the clock.\n            this._time = this.read();\n            this._paused = true;\n\n            window.clearTimeout(this._call);\n        }\n    };\n\n    /**\n     * Destroys the plugin.\n     */\n    Autoplay.prototype.destroy = function () {\n        var handler, property;\n\n        this.stop();\n\n        for (handler in this._handlers) {\n            this._core.$element.off(handler, this._handlers[handler]);\n        }\n        for (property in Object.getOwnPropertyNames(this)) {\n            typeof this[property] != 'function' && (this[property] = null);\n        }\n    };\n\n    $.fn.owlCarousel.Constructor.Plugins.autoplay = Autoplay;\n\n\n    /**\n     * Navigation Plugin\n     * @version 2.3.4\n     * @author Artus Kolanowski\n     * @author David Deutsch\n     * @license The MIT License (MIT)\n     */\n\n\n    /**\n     * Creates the navigation plugin.\n     * @class The Navigation Plugin\n     * @param {Owl} carousel - The Owl Carousel.\n     */\n    var Navigation = function (carousel) {\n        /**\n         * Reference to the core.\n         * @protected\n         * @type {Owl}\n         */\n        this._core = carousel;\n\n        /**\n         * Indicates whether the plugin is initialized or not.\n         * @protected\n         * @type {Boolean}\n         */\n        this._initialized = false;\n\n        /**\n         * The current paging indexes.\n         * @protected\n         * @type {Array}\n         */\n        this._pages = [];\n\n        /**\n         * All DOM elements of the user interface.\n         * @protected\n         * @type {Object}\n         */\n        this._controls = {};\n\n        /**\n         * Markup for an indicator.\n         * @protected\n         * @type {Array.<String>}\n         */\n        this._templates = [];\n\n        /**\n         * The carousel element.\n         * @type {jQuery}\n         */\n        this.$element = this._core.$element;\n\n        /**\n         * Overridden methods of the carousel.\n         * @protected\n         * @type {Object}\n         */\n        this._overrides = {\n            next: this._core.next,\n            prev: this._core.prev,\n            to: this._core.to\n        };\n\n        /**\n         * All event handlers.\n         * @protected\n         * @type {Object}\n         */\n        this._handlers = {\n            'prepared.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._core.settings.dotsData) {\n                    this._templates.push('<div class=\"' + this._core.settings.dotClass + '\">' +\n                        $(e.content).find('[data-dot]').addBack('[data-dot]').attr('data-dot') + '</div>');\n                }\n            }, this),\n            'added.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._core.settings.dotsData) {\n                    this._templates.splice(e.position, 0, this._templates.pop());\n                }\n            }, this),\n            'remove.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._core.settings.dotsData) {\n                    this._templates.splice(e.position, 1);\n                }\n            }, this),\n            'changed.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && e.property.name == 'position') {\n                    this.draw();\n                }\n            }, this),\n            'initialized.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && !this._initialized) {\n                    this._core.trigger('initialize', null, 'navigation');\n                    this.initialize();\n                    this.update();\n                    this.draw();\n                    this._initialized = true;\n                    this._core.trigger('initialized', null, 'navigation');\n                }\n            }, this),\n            'refreshed.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._initialized) {\n                    this._core.trigger('refresh', null, 'navigation');\n                    this.update();\n                    this.draw();\n                    this._core.trigger('refreshed', null, 'navigation');\n                }\n            }, this)\n        };\n\n        // set default options\n        this._core.options = $.extend({}, Navigation.Defaults, this._core.options);\n\n        // register event handlers\n        this.$element.on(this._handlers);\n    };\n\n    /**\n     * Default options.\n     * @public\n     * @todo Rename `slideBy` to `navBy`\n     */\n    Navigation.Defaults = {\n        nav: false,\n        navText: [\n            '<span aria-label=\"' + 'Previous' + '\">&#x2039;</span>',\n            '<span aria-label=\"' + 'Next' + '\">&#x203a;</span>'\n        ],\n        navSpeed: false,\n        navElement: 'button type=\"button\" role=\"presentation\"',\n        navContainer: false,\n        navContainerClass: 'owl-nav',\n        navClass: [\n            'owl-prev',\n            'owl-next'\n        ],\n        slideBy: 1,\n        dotClass: 'owl-dot',\n        dotsClass: 'owl-dots',\n        dots: true,\n        dotsEach: false,\n        dotsData: false,\n        dotsSpeed: false,\n        dotsContainer: false\n    };\n\n    /**\n     * Initializes the layout of the plugin and extends the carousel.\n     * @protected\n     */\n    Navigation.prototype.initialize = function () {\n        var override,\n            settings = this._core.settings;\n\n        // create DOM structure for relative navigation\n        this._controls.$relative = (settings.navContainer ? $(settings.navContainer)\n            : $('<div>').addClass(settings.navContainerClass).appendTo(this.$element)).addClass('disabled');\n\n        this._controls.$previous = $('<' + settings.navElement + '>')\n            .addClass(settings.navClass[0])\n            .attr('aria-label', 'previous')\n            .html(settings.navText[0])\n            .prependTo(this._controls.$relative)\n            .on('click', $.proxy(function (e) {\n                this.prev(settings.navSpeed);\n            }, this));\n        this._controls.$next = $('<' + settings.navElement + '>')\n            .addClass(settings.navClass[1])\n            .attr('aria-label', 'next')\n            .html(settings.navText[1])\n            .appendTo(this._controls.$relative)\n            .on('click', $.proxy(function (e) {\n                this.next(settings.navSpeed);\n            }, this));\n\n        // create DOM structure for absolute navigation\n        if (!settings.dotsData) {\n            this._templates = [$('<button type=\"button\" aria-label=\"dot\">')\n                .addClass(settings.dotClass)\n                .append($('<span>'))\n                .prop('outerHTML')];\n        }\n\n        this._controls.$absolute = (settings.dotsContainer ? $(settings.dotsContainer)\n            : $('<div>').addClass(settings.dotsClass).appendTo(this.$element)).addClass('disabled');\n\n        this._controls.$absolute.on('click', 'button', $.proxy(function (e) {\n            var index = $(e.target).parent().is(this._controls.$absolute)\n                ? $(e.target).index() : $(e.target).parent().index();\n\n            e.preventDefault();\n\n            this.to(index, settings.dotsSpeed);\n        }, this));\n\n        /*$el.on('focusin', function() {\n            $(document).off(\".carousel\");\n\n            $(document).on('keydown.carousel', function(e) {\n                if(e.keyCode == 37) {\n                    $el.trigger('prev.owl')\n                }\n                if(e.keyCode == 39) {\n                    $el.trigger('next.owl')\n                }\n            });\n        });*/\n\n        // override public methods of the carousel\n        for (override in this._overrides) {\n            this._core[override] = $.proxy(this[override], this);\n        }\n    };\n\n    /**\n     * Destroys the plugin.\n     * @protected\n     */\n    Navigation.prototype.destroy = function () {\n        var handler, control, property, override, settings;\n        settings = this._core.settings;\n\n        for (handler in this._handlers) {\n            this.$element.off(handler, this._handlers[handler]);\n        }\n        for (control in this._controls) {\n            if (control === '$relative' && settings.navContainer) {\n                this._controls[control].html('');\n            } else {\n                this._controls[control].remove();\n            }\n        }\n        for (override in this.overides) {\n            this._core[override] = this._overrides[override];\n        }\n        for (property in Object.getOwnPropertyNames(this)) {\n            typeof this[property] != 'function' && (this[property] = null);\n        }\n    };\n\n    /**\n     * Updates the internal state.\n     * @protected\n     */\n    Navigation.prototype.update = function () {\n        var i, j, k,\n            lower = this._core.clones().length / 2,\n            upper = lower + this._core.items().length,\n            maximum = this._core.maximum(true),\n            settings = this._core.settings,\n            size = settings.center || settings.autoWidth || settings.dotsData\n                ? 1 : settings.dotsEach || settings.items;\n\n        if (settings.slideBy !== 'page') {\n            settings.slideBy = Math.min(settings.slideBy, settings.items);\n        }\n\n        if (settings.dots || settings.slideBy == 'page') {\n            this._pages = [];\n\n            for (i = lower, j = 0, k = 0; i < upper; i++) {\n                if (j >= size || j === 0) {\n                    this._pages.push({\n                        start: Math.min(maximum, i - lower),\n                        end: i - lower + size - 1\n                    });\n                    if (Math.min(maximum, i - lower) === maximum) {\n                        break;\n                    }\n                    j = 0, ++k;\n                }\n                j += this._core.mergers(this._core.relative(i));\n            }\n        }\n    };\n\n    /**\n     * Draws the user interface.\n     * @todo The option `dotsData` wont work.\n     * @protected\n     */\n    Navigation.prototype.draw = function () {\n        var difference,\n            settings = this._core.settings,\n            disabled = this._core.items().length <= settings.items,\n            index = this._core.relative(this._core.current()),\n            loop = settings.loop || settings.rewind;\n\n        this._controls.$relative.toggleClass('disabled', !settings.nav || disabled);\n\n        if (settings.nav) {\n            this._controls.$previous.toggleClass('disabled', !loop && index <= this._core.minimum(true));\n            this._controls.$next.toggleClass('disabled', !loop && index >= this._core.maximum(true));\n        }\n\n        this._controls.$absolute.toggleClass('disabled', !settings.dots || disabled);\n\n        if (settings.dots) {\n            difference = this._pages.length - this._controls.$absolute.children().length;\n\n            if (settings.dotsData && difference !== 0) {\n                this._controls.$absolute.html(this._templates.join(''));\n            } else if (difference > 0) {\n                this._controls.$absolute.append(new Array(difference + 1).join(this._templates[0]));\n            } else if (difference < 0) {\n                this._controls.$absolute.children().slice(difference).remove();\n            }\n\n            this._controls.$absolute.find('.active').removeClass('active');\n            this._controls.$absolute.children().eq($.inArray(this.current(), this._pages)).addClass('active');\n        }\n    };\n\n    /**\n     * Extends event data.\n     * @protected\n     * @param {Event} event - The event object which gets thrown.\n     */\n    Navigation.prototype.onTrigger = function (event) {\n        var settings = this._core.settings;\n\n        event.page = {\n            index: $.inArray(this.current(), this._pages),\n            count: this._pages.length,\n            size: settings && (settings.center || settings.autoWidth || settings.dotsData\n                ? 1 : settings.dotsEach || settings.items)\n        };\n    };\n\n    /**\n     * Gets the current page position of the carousel.\n     * @protected\n     * @returns {Number}\n     */\n    Navigation.prototype.current = function () {\n        var current = this._core.relative(this._core.current());\n        return $.grep(this._pages, $.proxy(function (page, index) {\n            return page.start <= current && page.end >= current;\n        }, this)).pop();\n    };\n\n    /**\n     * Gets the current succesor/predecessor position.\n     * @protected\n     * @returns {Number}\n     */\n    Navigation.prototype.getPosition = function (successor) {\n        var position, length,\n            settings = this._core.settings;\n\n        if (settings.slideBy == 'page') {\n            position = this._core.relative(this._core.current());\n            successor ? position += settings.items : position -= settings.items;\n        } else {\n            position = this._core.relative(this._core.current());\n            length = this._core.items().length;\n            successor ? position += settings.slideBy : position -= settings.slideBy;\n        }\n\n        return position;\n    };\n\n    /**\n     * Slides to the next item or page.\n     * @public\n     * @param {Number} [speed=false] - The time in milliseconds for the transition.\n     */\n    Navigation.prototype.next = function (speed) {\n        $.proxy(this._overrides.to, this._core)(this.getPosition(true), speed);\n    };\n\n    /**\n     * Slides to the previous item or page.\n     * @public\n     * @param {Number} [speed=false] - The time in milliseconds for the transition.\n     */\n    Navigation.prototype.prev = function (speed) {\n        $.proxy(this._overrides.to, this._core)(this.getPosition(false), speed);\n    };\n\n    /**\n     * Slides to the specified item or page.\n     * @public\n     * @param {Number} position - The position of the item or page.\n     * @param {Number} [speed] - The time in milliseconds for the transition.\n     * @param {Boolean} [standard=false] - Whether to use the standard behaviour or not.\n     */\n    Navigation.prototype.to = function (position, speed, standard) {\n        var length;\n\n        if (!standard && this._pages.length) {\n            length = this._pages.length;\n            $.proxy(this._overrides.to, this._core)(this._pages[((position % length) + length) % length].start, speed);\n        } else {\n            $.proxy(this._overrides.to, this._core)(position, speed);\n        }\n    };\n\n    $.fn.owlCarousel.Constructor.Plugins.Navigation = Navigation;\n\n\n    /**\n     * Hash Plugin\n     * @version 2.3.4\n     * @author Artus Kolanowski\n     * @author David Deutsch\n     * @license The MIT License (MIT)\n     */\n\n\n    /**\n     * Creates the hash plugin.\n     * @class The Hash Plugin\n     * @param {Owl} carousel - The Owl Carousel\n     */\n    var Hash = function (carousel) {\n        /**\n         * Reference to the core.\n         * @protected\n         * @type {Owl}\n         */\n        this._core = carousel;\n\n        /**\n         * Hash index for the items.\n         * @protected\n         * @type {Object}\n         */\n        this._hashes = {};\n\n        /**\n         * The carousel element.\n         * @type {jQuery}\n         */\n        this.$element = this._core.$element;\n\n        /**\n         * All event handlers.\n         * @protected\n         * @type {Object}\n         */\n        this._handlers = {\n            'initialized.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && this._core.settings.startPosition === 'URLHash') {\n                    $(window).trigger('hashchange.owl.navigation');\n                }\n            }, this),\n            'prepared.owl.carousel': $.proxy(function (e) {\n                if (e.namespace) {\n                    var hash = $(e.content).find('[data-hash]').addBack('[data-hash]').attr('data-hash');\n\n                    if (!hash) {\n                        return;\n                    }\n\n                    this._hashes[hash] = e.content;\n                }\n            }, this),\n            'changed.owl.carousel': $.proxy(function (e) {\n                if (e.namespace && e.property.name === 'position') {\n                    var current = this._core.items(this._core.relative(this._core.current())),\n                        hash = $.map(this._hashes, function (item, hash) {\n                            return item === current ? hash : null;\n                        }).join();\n\n                    if (!hash || window.location.hash.slice(1) === hash) {\n                        return;\n                    }\n\n                    window.location.hash = hash;\n                }\n            }, this)\n        };\n\n        // set default options\n        this._core.options = $.extend({}, Hash.Defaults, this._core.options);\n\n        // register the event handlers\n        this.$element.on(this._handlers);\n\n        // register event listener for hash navigation\n        $(window).on('hashchange.owl.navigation', $.proxy(function (e) {\n            var hash = window.location.hash.substring(1),\n                items = this._core.$stage.children(),\n                position = this._hashes[hash] && items.index(this._hashes[hash]);\n\n            if (position === undefined || position === this._core.current()) {\n                return;\n            }\n\n            this._core.to(this._core.relative(position), false, true);\n        }, this));\n    };\n\n    /**\n     * Default options.\n     * @public\n     */\n    Hash.Defaults = {\n        URLhashListener: false\n    };\n\n    /**\n     * Destroys the plugin.\n     * @public\n     */\n    Hash.prototype.destroy = function () {\n        var handler, property;\n\n        $(window).off('hashchange.owl.navigation');\n\n        for (handler in this._handlers) {\n            this._core.$element.off(handler, this._handlers[handler]);\n        }\n        for (property in Object.getOwnPropertyNames(this)) {\n            typeof this[property] != 'function' && (this[property] = null);\n        }\n    };\n\n    $.fn.owlCarousel.Constructor.Plugins.Hash = Hash;\n\n\n    /**\n     * Support Plugin\n     *\n     * @version 2.3.4\n     * @author Vivid Planet Software GmbH\n     * @author Artus Kolanowski\n     * @author David Deutsch\n     * @license The MIT License (MIT)\n     */\n\n\n    var style = $('<support>').get(0).style,\n        prefixes = 'Webkit Moz O ms'.split(' '),\n        events = {\n            transition: {\n                end: {\n                    WebkitTransition: 'webkitTransitionEnd',\n                    MozTransition: 'transitionend',\n                    OTransition: 'oTransitionEnd',\n                    transition: 'transitionend'\n                }\n            },\n            animation: {\n                end: {\n                    WebkitAnimation: 'webkitAnimationEnd',\n                    MozAnimation: 'animationend',\n                    OAnimation: 'oAnimationEnd',\n                    animation: 'animationend'\n                }\n            }\n        },\n        tests = {\n            csstransforms: function () {\n                return !!test('transform');\n            },\n            csstransforms3d: function () {\n                return !!test('perspective');\n            },\n            csstransitions: function () {\n                return !!test('transition');\n            },\n            cssanimations: function () {\n                return !!test('animation');\n            }\n        };\n\n    function test(property, prefixed) {\n        var result = false,\n            upper = property.charAt(0).toUpperCase() + property.slice(1);\n\n        $.each((property + ' ' + prefixes.join(upper + ' ') + upper).split(' '), function (i, property) {\n            if (style[property] !== undefined) {\n                result = prefixed ? property : true;\n                return false;\n            }\n        });\n\n        return result;\n    }\n\n    function prefixed(property) {\n        return test(property, true);\n    }\n\n    if (tests.csstransitions()) {\n        /* jshint -W053 */\n        $.support.transition = new String(prefixed('transition'))\n        $.support.transition.end = events.transition.end[$.support.transition];\n    }\n\n    if (tests.cssanimations()) {\n        /* jshint -W053 */\n        $.support.animation = new String(prefixed('animation'))\n        $.support.animation.end = events.animation.end[$.support.animation];\n    }\n\n    if (tests.csstransforms()) {\n        /* jshint -W053 */\n        $.support.transform = new String(prefixed('transform'));\n        $.support.transform3d = tests.csstransforms3d();\n    }\n\n}));\n","MageBig_WidgetPlus/js/jcountdown.js":"/*! jCountdown jQuery Plugin - v2.0.1 - 2015-10-18\r\n* https://github.com/tomgrohl/jCountdown/\r\n* Copyright (c) 2015 Tom Ellis; Licensed MIT */\r\n(function (factory) {\r\n    if (typeof define === 'function' && define.amd) {\r\n        define([\"jquery\"], factory);\r\n    } else {\r\n        factory(jQuery);\r\n    }\r\n}(function ($) {\r\n\r\n$.fn.countdown = function( method /*, options*/ ) {\r\n\r\n    var msPerHr = 3600000,\r\n        secPerYear = 31557600,\r\n        secPerMonth = 2629800,\r\n        secPerWeek = 604800,\r\n        secPerDay = 86400,\r\n        secPerHr = 3600,\r\n        secPerMin = 60,\r\n        secPerSec = 1,\r\n        rTemplateTokens = /%y|%m|%w|%d|%h|%i|%s|%ty|%tm|%tw|%td|%th|%ti|%ts/g,\r\n        rDigitGlobal = /\\d/g,\r\n        localNumber = function( numToConvert, settings ) {\r\n\r\n            var arr = numToConvert.toString().match(rDigitGlobal),\r\n                localeNumber = \"\";\r\n\r\n            $.each( arr, function(i,num) {\r\n                num = Number(num);\r\n                localeNumber += (\"\"+ settings.digits[num]) || \"\"+num;\r\n            });\r\n\r\n            return localeNumber;\r\n        },\r\n        dateNow = function( $this ) {\r\n            var now = new Date(), // Default to local time\r\n                settings = $this.data(\"jcdData\");\r\n\r\n            if ( !settings ) {\r\n                return new Date();\r\n            }\r\n\r\n            if ( settings.offset !== null ) {\r\n                now = getTimezoneDate( settings.offset );\r\n            }\r\n\r\n            now.setMilliseconds(0);\r\n            return now;\r\n        },\r\n        getTimezoneDate = function( offset ) {\r\n            // Returns date now based on timezone/offset\r\n            var hrs,\r\n                dateMS,\r\n                curHrs,\r\n                tmpDate = new Date();\r\n\r\n            if ( offset !== null ) {\r\n                hrs = offset * msPerHr;\r\n                curHrs = tmpDate.getTime() - ( ( -tmpDate.getTimezoneOffset() / 60 ) * msPerHr ) + hrs;\r\n                dateMS = tmpDate.setTime( curHrs );\r\n            }\r\n\r\n            return new Date( dateMS );\r\n        },\r\n        addEventHandlers = function($element, options) {\r\n\r\n            // Add event handlers where set\r\n            if ( options.onStart ) {\r\n                $element.on(\"start.jcdevt\", options.onStart );\r\n            }\r\n\r\n            if ( options.onChange ) {\r\n                $element.on(\"change.jcdevt\", options.onChange );\r\n            }\r\n\r\n            if ( options.onComplete ) {\r\n                $element.on(\"complete.jcdevt\", options.onComplete );\r\n            }\r\n\r\n            if ( options.onPause ) {\r\n                $element.on(\"pause.jcdevt\", options.onPause );\r\n            }\r\n\r\n            if ( options.onResume ) {\r\n                $element.on(\"resume.jcdevt\", options.onResume );\r\n            }\r\n\r\n            if ( options.onLocaleChange ) {\r\n                $element.on(\"locale.jcdevt\", options.onLocaleChange );\r\n            }\r\n        },\r\n\r\n        generateTemplate = function( settings ) {\r\n            var template = settings.template,\r\n                yearsLeft = settings.yearsLeft,\r\n                monthsLeft = settings.monthsLeft,\r\n                weeksLeft = settings.weeksLeft,\r\n                daysLeft = settings.daysLeft,\r\n                hrsLeft = settings.hrsLeft,\r\n                minsLeft = settings.minsLeft,\r\n                secLeft = settings.secLeft,\r\n                hideYears = false,\r\n                hideMonths = false,\r\n                hideWeeks = false,\r\n                hideDays = false,\r\n                hideHours = false,\r\n                hideMins = false;\r\n\r\n            if (settings.isRTL) {\r\n                template = settings.rtlTemplate;\r\n            }\r\n\r\n            if ( settings.omitZero ) {\r\n\r\n                if ( settings.yearsAndMonths ) {\r\n\r\n                    if( !settings.yearsLeft ) {\r\n                        hideYears = true;\r\n                    }\r\n                    if( !settings.monthsLeft ) {\r\n                        hideMonths = true;\r\n                    }\r\n                }\r\n\r\n                if ( settings.weeks && ( ( settings.yearsAndMonths && hideMonths && !settings.weeksLeft ) || ( !settings.yearsAndMonths && !settings.weeksLeft ) ) ) {\r\n                    hideWeeks = true;\r\n                }\r\n\r\n                if ( hideWeeks && !daysLeft ) {\r\n                    hideDays = true;\r\n                }\r\n\r\n                if ( hideDays && !hrsLeft ) {\r\n                    hideHours = true;\r\n                }\r\n\r\n                if ( hideHours && !minsLeft ) {\r\n                    hideMins = true;\r\n                }\r\n\r\n            }\r\n\r\n            if ( settings.leadingZero ) {\r\n\r\n                if ( yearsLeft < 10 ) {\r\n                    yearsLeft = \"0\" + yearsLeft;\r\n                }\r\n\r\n                if ( monthsLeft < 10 ) {\r\n                    monthsLeft = \"0\" + monthsLeft;\r\n                }\r\n\r\n                if ( weeksLeft < 10 ) {\r\n                    weeksLeft = \"0\" + weeksLeft;\r\n                }\r\n\r\n                if ( daysLeft < 10 ) {\r\n                    daysLeft = \"0\" + daysLeft;\r\n                }\r\n\r\n                if ( hrsLeft < 10 ) {\r\n                    hrsLeft = \"0\" + hrsLeft;\r\n                }\r\n\r\n                if ( minsLeft < 10 ) {\r\n                    minsLeft = \"0\" + minsLeft;\r\n                }\r\n\r\n                if ( secLeft < 10 ) {\r\n                    secLeft = \"0\" + secLeft;\r\n                }\r\n            }\r\n\r\n            yearsLeft = localNumber( yearsLeft, settings );\r\n            monthsLeft = localNumber( monthsLeft, settings );\r\n            weeksLeft = localNumber( weeksLeft, settings );\r\n            daysLeft = localNumber( daysLeft, settings );\r\n            hrsLeft = localNumber( hrsLeft, settings );\r\n            minsLeft = localNumber( minsLeft, settings );\r\n            secLeft = localNumber( secLeft, settings );\r\n\r\n            if ( settings.yearsAndMonths ) {\r\n\r\n                if ( !settings.omitZero || !hideYears  ) {\r\n                    template = template.replace('%y', yearsLeft);\r\n                    template = template.replace('%ty', (yearsLeft == 1 && settings.yearSingularText) ? settings.yearSingularText : settings.yearText);\r\n                }\r\n\r\n                //Only hide months if years is at 0 as well as months\r\n                if ( !settings.omitZero || ( !hideYears && monthsLeft ) || ( !hideYears && !hideMonths ) ) {\r\n                    template = template.replace('%m', monthsLeft);\r\n                    template = template.replace('%tm', (monthsLeft == 1 && settings.monthSingularText) ? settings.monthSingularText : settings.monthText);\r\n                }\r\n            }\r\n\r\n            if ( settings.weeks && !hideWeeks ) {\r\n                template = template.replace('%w', weeksLeft);\r\n                template = template.replace('%tw', (weeksLeft == 1 && settings.weekSingularText) ? settings.weekSingularText : settings.weekText);\r\n\r\n            }\r\n\r\n            if ( !hideDays ) {\r\n                template = template.replace('%d', daysLeft);\r\n                template = template.replace('%td', (daysLeft == 1 && settings.daySingularText) ? settings.daySingularText : settings.dayText);\r\n            }\r\n\r\n            if ( !hideHours ) {\r\n                template = template.replace('%h', hrsLeft);\r\n                template = template.replace('%th', (hrsLeft == 1 && settings.hourSingularText) ? settings.hourSingularText : settings.hourText);\r\n            }\r\n\r\n            if ( !hideMins ) {\r\n                template = template.replace('%i', minsLeft);\r\n                template = template.replace('%ti', (minsLeft == 1 && settings.minSingularText) ? settings.minSingularText : settings.minText);\r\n            }\r\n\r\n            template = template.replace('%s', secLeft);\r\n            template = template.replace('%ts', (secLeft == 1 && settings.secSingularText) ? settings.secSingularText : settings.secText);\r\n\r\n            // Remove un-used tokens\r\n            template = template.replace(rTemplateTokens,'');\r\n\r\n            return template;\r\n        },\r\n        updateCallback = function() {\r\n\r\n            var $this = this,\r\n                template,\r\n                now,\r\n                date,\r\n                timeLeft,\r\n                yearsLeft = 0,\r\n                monthsLeft = 0,\r\n                weeksLeft = 0,\r\n                daysLeft,\r\n                hrsLeft,\r\n                minsLeft,\r\n                secLeft,\r\n                time = \"\",\r\n                diff,\r\n                extractSection = function( numSecs ) {\r\n                    var amount;\r\n\r\n                    amount = Math.floor( diff / numSecs );\r\n                    diff -= amount * numSecs;\r\n\r\n                    return amount;\r\n                },\r\n                settings = $this.data(\"jcdData\");\r\n\r\n            // No settings so return\r\n            if ( !settings ) {\r\n                return false;\r\n            }\r\n\r\n            now = dateNow( $this );\r\n\r\n            if ( null !== settings.serverDiff ) {\r\n                date = new Date( settings.serverDiff + settings.clientdateNow.getTime() );\r\n            }\r\n            else {\r\n                date = settings.dateObj;\r\n            }\r\n\r\n            date.setMilliseconds(0);\r\n\r\n            timeLeft = ( settings.direction === \"down\" ) ? date.getTime() - now.getTime() : now.getTime() - date.getTime();\r\n\r\n            diff = Math.round( timeLeft / 1000 );\r\n\r\n            daysLeft = extractSection( secPerDay );\r\n            hrsLeft = extractSection( secPerHr );\r\n            minsLeft = extractSection( secPerMin );\r\n            secLeft = extractSection( secPerSec );\r\n\r\n            if ( settings.yearsAndMonths ) {\r\n\r\n                //Add days back on so we can calculate years easier\r\n                diff += ( daysLeft * secPerDay );\r\n\r\n                yearsLeft = extractSection( secPerYear );\r\n                monthsLeft = extractSection( secPerMonth );\r\n                daysLeft = extractSection( secPerDay );\r\n            }\r\n\r\n            if ( settings.weeks ) {\r\n                //Add days back on so we can calculate weeks easier\r\n                diff += ( daysLeft * secPerDay );\r\n\r\n                weeksLeft = extractSection( secPerWeek );\r\n                daysLeft = extractSection( secPerDay );\r\n            }\r\n\r\n            /**\r\n             * The following 3 option should never be used together!\r\n             * MAKE them work for any time\r\n             */\r\n\r\n            if ( settings.hoursOnly || settings.minsOnly || settings.secsOnly )\r\n            {\r\n\r\n                if ( settings.yearsAndMonths ) {\r\n                    //Add years, months, weeks and days back on so we can calculate dates easier\r\n                    diff += ( yearsLeft * secPerYear );\r\n                    diff += ( monthsLeft * secPerMonth );\r\n\r\n                    yearsLeft = monthsLeft = 0;\r\n                }\r\n\r\n                if ( settings.weeks ) {\r\n                    diff += ( weeksLeft * secPerWeek );\r\n\r\n                    weeksLeft = 0;\r\n                }\r\n\r\n            }\r\n\r\n            // Assumes you are using dates within a month  ( ~ 30 days )\r\n            // as years and months aren't taken into account\r\n            if ( settings.hoursOnly ) {\r\n\r\n                // Add days back on\r\n                diff += ( daysLeft * secPerDay );\r\n\r\n                // Add hours back on\r\n                diff += ( hrsLeft * secPerHr );\r\n                hrsLeft = extractSection( secPerHr );\r\n\r\n            }\r\n\r\n            // Assumes you are only using dates in the near future ( <= 24 hours )\r\n            // as years and months aren't taken into account\r\n            if ( settings.minsOnly ) {\r\n\r\n\r\n                // Add days back on\r\n                diff += ( daysLeft * secPerDay );\r\n                daysLeft = 0;\r\n\r\n                // Add hours back on\r\n                diff += ( hrsLeft * secPerHr );\r\n                hrsLeft = 0;\r\n\r\n                diff += ( minsLeft * secPerMin );\r\n\r\n                minsLeft = extractSection( secPerMin );\r\n\r\n            }\r\n\r\n            // Assumes you are only using dates in the near future ( <= 60 minutes )\r\n            // as years, months and days aren't taken into account\r\n            if ( settings.secsOnly ) {\r\n\r\n\r\n                // Add days back on\r\n                diff += ( daysLeft * secPerDay );\r\n                daysLeft = 0;\r\n\r\n                // Add hours back on\r\n                diff += ( hrsLeft * secPerHr );\r\n                hrsLeft = 0;\r\n\r\n                // Add minutes back on\r\n                diff += ( minsLeft * secPerMin );\r\n                minsLeft = 0;\r\n\r\n                // Add seconds back on\r\n                diff += secLeft;\r\n\r\n                secLeft = extractSection( secPerSec );\r\n            }\r\n\r\n            settings.yearsLeft = yearsLeft;\r\n            settings.monthsLeft = monthsLeft;\r\n            settings.weeksLeft = weeksLeft;\r\n            settings.daysLeft = daysLeft;\r\n            settings.hrsLeft = hrsLeft;\r\n            settings.minsLeft = minsLeft;\r\n            settings.secLeft = secLeft;\r\n\r\n            $this.data(\"jcdData\", settings);\r\n\r\n            // Check if the countdown has finished\r\n            // We've got the time sections set so we can now do the templating\r\n\r\n            if ( ( settings.direction === \"down\" && ( now < date || settings.minus ) ) || ( settings.direction === \"up\" && ( date < now || settings.minus )  ) ) {\r\n                time = generateTemplate( settings );\r\n            }\r\n            else {\r\n                settings.yearsLeft = settings.monthsLeft = settings.weeksLeft = settings.daysLeft = settings.hrsLeft = settings.minsLeft = settings.secLeft = 0;\r\n\r\n                time = generateTemplate( settings );\r\n                settings.hasCompleted = true;\r\n            }\r\n\r\n            $this.html( time ).triggerMulti(\"change.jcdevt,countChange\", [settings]);\r\n\r\n            if ( settings.hasCompleted ) {\r\n                $this.triggerMulti(\"complete.jcdevt,countComplete\");\r\n                clearInterval( settings.timer );\r\n            }\r\n\r\n        },\r\n        methods = {\r\n            init: function( options ) {\r\n                var opts = $.extend( {}, $.fn.countdown.defaults, options ),\r\n                    testDate,\r\n                    testString,\r\n                    settings = {};\r\n\r\n                return this.each(function() {\r\n\r\n                    var $this = $(this),\r\n                        intervalCallback;\r\n\r\n                    // If this element already has a countdown timer\r\n                    // just change the settings\r\n                    if ( $this.data(\"jcdData\") ) {\r\n                        $this.countdown(\"changeSettings\", options, true);\r\n                        opts = $this.data(\"jcdData\");\r\n                    }\r\n\r\n                    if ( opts.date === null && opts.dataAttr === null ) {\r\n                        $.error(\"No Date passed to jCountdown. date option is required.\");\r\n                        return true;\r\n                    }\r\n\r\n                    if ( opts.date ) {\r\n                        testString = opts.date;\r\n                    } else {\r\n                        testString = $this.attr('data-' + opts.dataAttr);\r\n                    }\r\n\r\n                    testDate = new Date(testString);\r\n\r\n                    if( testDate.toString() === \"Invalid Date\" ) {\r\n                        $.error(\"Invalid Date passed to jCountdown: \" + testString);\r\n                    }\r\n\r\n                    // Setup any event handlers\r\n                    addEventHandlers($this, options);\r\n\r\n                    // Create a settings object based off the plugin options\r\n                    settings = $.extend({}, opts);\r\n\r\n                    // Cache DOM elements for templating\r\n                    settings.dom = {};\r\n\r\n                    settings.dom.$time = $(\"<\"+settings.timeWrapElement+\">\").addClass(settings.timeWrapClass);\r\n                    settings.dom.$text = $(\"<\"+settings.textWrapElement+\">\").addClass(settings.textWrapClass);\r\n\r\n                    settings.clientdateNow = new Date();\r\n                    settings.clientdateNow.setMilliseconds(0);\r\n                    settings.originalHTML = $this.html();\r\n                    settings.dateObj = new Date( testString );\r\n                    settings.dateObj.setMilliseconds(0);\r\n                    settings.hasCompleted = false;\r\n                    settings.timer = 0;\r\n                    settings.yearsLeft = settings.monthsLeft = settings.weeksLeft = settings.daysLeft = settings.hrsLeft = settings.minsLeft = settings.secLeft = 0;\r\n                    settings.difference = null;\r\n\r\n                    // Create a callback for the interval\r\n                    intervalCallback = $.proxy(updateCallback, $this);\r\n                    settings.timer = setInterval(intervalCallback, settings.updateTime);\r\n\r\n                    $this.data(\"jcdData\", settings).triggerMulti(\"start.jcdevt,countStart\", [settings]);\r\n\r\n                    intervalCallback();\r\n\r\n                });\r\n            },\r\n            changeSettings: function( options, internal ) {\r\n\r\n                // Like resume but with resetting/changing options\r\n                return this.each(function() {\r\n                    var $this  = $(this),\r\n                        settings,\r\n                        testDate,\r\n                        func = $.proxy( updateCallback, $this );\r\n\r\n                    if ( !$this.data(\"jcdData\") ) {\r\n                        return true;\r\n                    }\r\n\r\n                    settings = $.extend( {}, $this.data(\"jcdData\"), options );\r\n\r\n                    if ( options.hasOwnProperty(\"date\") ) {\r\n                        testDate = new Date(options.date);\r\n\r\n                        if ( testDate.toString() === \"Invalid Date\" ) {\r\n                            $.error(\"Invalid Date passed to jCountdown: \" + options.date);\r\n                        }\r\n                    }\r\n\r\n                    settings.completed = false;\r\n                    settings.dateObj  = new Date( options.date );\r\n\r\n                    // Clear the timer, as it might not be needed\r\n                    clearInterval( settings.timer );\r\n                    $this.off(\".jcdevt\").data(\"jcdData\", settings);\r\n\r\n                    // As this can be accessed via the init method as well,\r\n                    // we need to check how this method is being accessed\r\n                    if ( !internal ) {\r\n\r\n                        addEventHandlers($this, settings);\r\n\r\n                        settings.timer = setInterval( func, settings.updateTime );\r\n                        $this.data(\"jcdData\", settings);\r\n                        func(); //Needs to run straight away when changing settings\r\n                    }\r\n\r\n                    settings = null;\r\n                });\r\n\r\n            },\r\n            resume: function() {\r\n\r\n                // Resumes a countdown timer\r\n                return this.each(function() {\r\n                    var $this = $(this),\r\n                        settings = $this.data(\"jcdData\"),\r\n                        func = $.proxy( updateCallback, $this );\r\n\r\n                    if ( !settings ) {\r\n                        return true;\r\n                    }\r\n\r\n                    $this.data(\"jcdData\", settings).triggerMulti(\"resume.jcdevt,countResume\", [settings] );\r\n                    // We only want to resume a countdown that hasn't finished\r\n                    if ( !settings.hasCompleted ) {\r\n                        settings.timer = setInterval( func, settings.updateTime );\r\n\r\n                        if ( settings.stopwatch && settings.direction === \"up\" ) {\r\n\r\n                            var t = dateNow( $this ).getTime() - settings.pausedAt.getTime(),\r\n                                d = new Date();\r\n                            d.setTime( settings.dateObj.getTime() + t );\r\n\r\n                            settings.dateObj = d; //This is internal date\r\n                        }\r\n\r\n                        func();\r\n                    }\r\n                });\r\n\r\n            },\r\n            pause: function() {\r\n                // Pause a countdown timer\r\n                return this.each(function() {\r\n                    var $this = $(this),\r\n                        settings = $this.data(\"jcdData\");\r\n\r\n                    if ( !settings ) {\r\n                        return true;\r\n                    }\r\n\r\n                    if ( settings.stopwatch ) {\r\n                        settings.pausedAt = dateNow( $this );\r\n                    }\r\n                    // Clear interval (Will be started on resume)\r\n                    clearInterval( settings.timer );\r\n                    // Trigger pause event handler\r\n                    $this.data(\"jcdData\", settings).triggerMulti(\"pause.jcdevt,countPause\", [settings] );\r\n                });\r\n            },\r\n            complete: function() {\r\n                return this.each(function() {\r\n                    var $this = $(this),\r\n                        settings = $this.data(\"jcdData\");\r\n\r\n                    if ( !settings ) {\r\n                        return true;\r\n                    }\r\n                    // Clear timer\r\n                    clearInterval( settings.timer );\r\n                    settings.hasCompleted = true;\r\n                    // Update setting, trigger complete event handler, then unbind all events\r\n                    // We don\"t delete the settings in case they need to be checked later on\r\n\r\n                    $this.data(\"jcdData\", settings).triggerMulti(\"complete.jcdevt,countComplete\", [settings]);\r\n                });\r\n            },\r\n            destroy: function() {\r\n                return this.each(function() {\r\n                    var $this = $(this),\r\n                        settings = $this.data(\"jcdData\");\r\n\r\n                    if ( !settings ) {\r\n                        return true;\r\n                    }\r\n                    // Clear timer\r\n                    clearInterval( settings.timer );\r\n                    // Unbind all events, remove data and put DOM Element back to its original state (HTML wise)\r\n                    $this.off(\".jcdevt\").removeData(\"jcdData\").html( settings.originalHTML );\r\n                });\r\n            },\r\n            getSettings: function( name ) {\r\n                var $this = $(this),\r\n                    settings = $this.data(\"jcdData\");\r\n\r\n                // If an individual setting is required\r\n                if ( name && settings ) {\r\n                    // If it exists, return it\r\n                    if ( settings.hasOwnProperty( name ) ) {\r\n                        return settings[name];\r\n                    }\r\n                    return undefined;\r\n                }\r\n                // Return all settings or undefined\r\n                return settings;\r\n            },\r\n            changeLocale: function( locale ) {\r\n                var $this = $(this),\r\n                    settings = $this.data(\"jcdData\");\r\n\r\n                // If no locale exists error and return false\r\n                if ( !$.fn.countdown.locale[locale] ) {\r\n                    $.error(\"Locale '\" + locale + \"' does not exist\");\r\n                    return false;\r\n                }\r\n\r\n                $.extend( settings, $.fn.countdown.locale[locale] );\r\n\r\n                $this.data(\"jcdData\", settings).triggerMulti(\"locale.jcdevt,localeChange\", [settings]);\r\n\r\n                return true;\r\n            }\r\n        };\r\n\r\n    if( methods[ method ] ) {\r\n        return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ) );\r\n    } else if ( typeof method === \"object\" || !method ) {\r\n        return methods.init.apply( this, arguments );\r\n    } else {\r\n        $.error(\"Method \"+ method +\" does not exist in the jCountdown Plugin\");\r\n    }\r\n};\r\n\r\n// Expose defaults so we can easily override settings\r\n// Useful for locale plugins\r\n$.fn.countdown.defaults = {\r\n    date: null,\r\n    dataAttr: null,\r\n    updateTime: 1000,\r\n    yearText: 'years',\r\n    monthText: 'months',\r\n    weekText: 'weeks',\r\n    dayText: 'days',\r\n    hourText: 'hours',\r\n    minText: 'mins',\r\n    secText: 'sec',\r\n    yearSingularText: 'year',\r\n    monthSingularText: 'month',\r\n    weekSingularText: 'week',\r\n    daySingularText: 'day',\r\n    hourSingularText: 'hour',\r\n    minSingularText: 'min',\r\n    secSingularText: 'sec',\r\n    digits : [0,1,2,3,4,5,6,7,8,9],\r\n    isRTL: false,\r\n    minus: false,\r\n    onStart: null,\r\n    onChange: null,\r\n    onComplete: null,\r\n    onResume: null,\r\n    onPause: null,\r\n    onLocaleChange: null,\r\n    leadingZero: false,\r\n    offset: null,\r\n    serverDiff:null,\r\n    hoursOnly: false,\r\n    minsOnly: false,\r\n    secsOnly: false,\r\n    weeks: false,\r\n    hours: false,\r\n    yearsAndMonths: false,\r\n    direction: \"down\",\r\n    stopwatch: false,\r\n    omitZero: false,\r\n\r\n    rtlTemplate: '%ts %s : %ti %i : %th %h : %tm %m : %ty %y',\r\n    template: '%y %ty : %m %tm : %h %th : %i %ti : %s %ts'\r\n};\r\n\r\n// Locale cache\r\n$.fn.countdown.locale = [];\r\n\r\n// Store default english locale so we can switch easier\r\n$.fn.countdown.locale.en = {\r\n    yearText: 'years',\r\n    monthText: 'months',\r\n    weekText: 'weeks',\r\n    dayText: 'days',\r\n    hourText: 'hours',\r\n    minText: 'mins',\r\n    secText: 'sec',\r\n    yearSingularText: 'year',\r\n    monthSingularText: 'month',\r\n    weekSingularText: 'week',\r\n    daySingularText: 'day',\r\n    hourSingularText: 'hour',\r\n    minSingularText: 'min',\r\n    secSingularText: 'sec',\r\n    isRTL: false\r\n};\r\n\r\n//\r\n$.fn.triggerMulti = function( eventTypes, extraParameters ) {\r\n    var events = eventTypes.split(\",\");\r\n        \r\n    return this.each(function() {\r\n        var $this = $(this);\r\n\r\n        for ( var i = 0; i < events.length; i++) {\r\n            $this.trigger( events[i], extraParameters );\r\n        }   \r\n    });\r\n};\r\n\r\n}));","MageBig_WidgetPlus/js/videobackground.js":"define([\r\n    \"jquery\",\r\n    \"domReady!\"\r\n], function($){\r\n    \"use strict\";\r\n\r\n    $.widget('magebig.videobackground', {\r\n        options: {\r\n            videoType: 'contain'\r\n        },\r\n\r\n        _create: function() {\r\n            self = this;\r\n            self.initial();\r\n        },\r\n\r\n        initial: function() {\r\n            var elmId = '#' + this.element[0]['id'],\r\n                self = this,\r\n                timer = false,\r\n                videosrc = $(elmId).attr('data-videosrc'),\r\n                videoPlay;\r\n            if (typeof videosrc !== typeof undefined && videosrc !== false) {\r\n                videoPlay = '<video class=\"background\" loop ' + self.options.autoplay + ' ' + self.options.muted + ' ' + self.options.controls\r\n                    + '><source src=\"' + videosrc + '\" type=\"video/mp4\"></video>';\r\n                $(elmId).append(videoPlay).append('<div class=\"playvideo mbi mbi-play-circle\"></div>');\r\n            }\r\n\r\n            var video = $(elmId + ' video'),\r\n                play = video.next('.playvideo');\r\n\r\n            if (video[0].paused) {\r\n                play.addClass('mbi-pause-circle').removeClass('mbi-play-circle');\r\n            } else {\r\n                play.addClass('mbi-play-circle').removeClass('mbi-pause-circle');\r\n            }\r\n\r\n            $(elmId + ' .playvideo').on('click', function(event) {\r\n                event.preventDefault();\r\n                if (video[0].paused) {\r\n                    video[0].play();\r\n                    play.addClass('mbi-pause-circle').removeClass('mbi-play-circle');\r\n                } else {\r\n                    video[0].pause();\r\n                    play.addClass('mbi-play-circle').removeClass('mbi-pause-circle');\r\n                }\r\n            });\r\n\r\n            self.scaleVideo();\r\n\r\n            $(window).on('resize', function() {\r\n                if (timer) clearTimeout(timer);\r\n                timer = setTimeout(function(){\r\n                    self.scaleVideo();\r\n                }, 1000);\r\n            });\r\n        },\r\n\r\n        scaleVideo: function () {\r\n            var self = this;\r\n            var elmId = '#' + this.element[0]['id'];\r\n            var video = $(elmId + ' video');\r\n\r\n            video.bind(\"loadedmetadata\", function () {\r\n                var elmId = '#' + self.element[0]['id'];\r\n                var heightContainer = $(elmId).outerHeight();\r\n                var widthContainer = $(elmId).outerWidth();\r\n\r\n                var widthVideo = this.videoWidth;\r\n                var heightVideo = this.videoHeight;\r\n\r\n                var ratioVideo = widthVideo/heightVideo;\r\n\r\n                if (self.options.videoType == 'contain') {\r\n                    heightVideo = parseInt(heightContainer) + 4;\r\n                    widthVideo = parseInt(heightVideo*ratioVideo);\r\n                    if (widthVideo < widthContainer) {\r\n                        widthVideo = parseInt(widthContainer) + 4;\r\n                        heightVideo = parseInt(widthVideo/ratioVideo);\r\n                    }\r\n                    video.height(heightVideo).width(widthVideo);\r\n                } else if (self.options.videoType == 'fullscreen') {\r\n                    var windowWidth = $(window).width(),\r\n                        windowHeight = $(window).height();\r\n\r\n                    $(elmId).width(windowWidth).height(windowHeight);\r\n\r\n                    heightVideo = parseInt(heightContainer) + 4;\r\n                    widthVideo = parseInt(heightVideo*ratioVideo);\r\n                    if (widthVideo < widthContainer) {\r\n                        widthVideo = parseInt(widthContainer) + 4;\r\n                        heightVideo = parseInt(widthVideo/ratioVideo);\r\n                    }\r\n                    video.height(heightVideo).width(widthVideo);\r\n                }\r\n            });\r\n        }\r\n    });\r\n    return $.magebig.videobackground;\r\n});","MageBig_WidgetPlus/js/product/addtocart-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'mage/apply/main'\n], function (Element, uencProcessor, columnStatusValidator, mage) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare data, that will be inserted as data-mage-init attribute into button. With help of this attribute\n         * Add To * buttons can understand post data and urls\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getDataMageInit: function (row) {\n            return '{\"redirectUrl\": { \"url\" : \"'  + uencProcessor(row['add_to_cart_button'].url) + '\"}}';\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_cart_button']['post_data']);\n        },\n\n        getUenc: function (row) {\n            return JSON.parse(this.getDataPost(row)).data.uenc;\n        },\n\n        getAction: function (row) {\n            return uencProcessor(row['add_to_cart_button'].url);\n        },\n\n        getId: function (row) {\n            return row['id'];\n        },\n\n        getSku: function (row) {\n            return row['extension_attributes'].sku;\n        },\n\n        getFormKey: function (row) {\n            return row['extension_attributes'].form_key;\n        },\n\n        getAddToCartMageInit: function () {\n            mage.apply();\n            // return '{\"catalogAddToCart\": {}}';\n        },\n\n        /**\n         * Check if product has required options.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasRequiredOptions: function (row) {\n            return row['add_to_cart_button']['required_options'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_cart', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","MageBig_WidgetPlus/js/product/list/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/listing',\n    'jquery',\n    'MageBig_WidgetPlus/js/owl.carousel-set',\n    'mage/apply/main',\n    'jquery-ui-modules/tooltip'\n], function (ko, _, Listing, $, owlWidget, mage) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            additionalClasses: '',\n            filteredRows: {},\n            limit: 5,\n            listens: {\n                elems: 'filterRowsFromCache',\n                '${ $.provider }:data.items': 'filterRowsFromServer'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.filteredRows = ko.observable();\n            this.initProductsLimit();\n            this.hideLoader();\n        },\n\n        /**\n         * Initialize product limit\n         * Product limit can be configured through Ui component.\n         * Product limit are present in widget form\n         *\n         * @returns {exports}\n         */\n        initProductsLimit: function () {\n            if (this.source['page_size']) {\n                this.limit = this.source['page_size'];\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Sort and filter rows, that are already in magento storage cache\n         *\n         * @return void\n         */\n        filterRowsFromCache: function () {\n            this._filterRows(this.rows);\n        },\n\n        /**\n         * Sort and filter rows, that are come from backend\n         *\n         * @param {Object} rows\n         */\n        filterRowsFromServer: function (rows) {\n            this._filterRows(rows);\n        },\n\n        /**\n         * Filter rows by limit and sort them\n         *\n         * @param {Array} rows\n         * @private\n         */\n        _filterRows: function (rows) {\n            this.filteredRows(_.sortBy(rows, 'added_at').reverse().slice(0, this.limit));\n        },\n\n        /**\n         * Can retrieve product url\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getUrl: function (row) {\n            return row.url;\n        },\n\n        /**\n         * Get product attribute by code.\n         *\n         * @param {String} code\n         * @return {Object}\n         */\n        getComponentByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                component;\n\n            component = _.filter(elems, function (elem) {\n                return elem.index === code;\n            }, this).pop();\n\n            return component;\n        },\n\n        /**\n         * Init slider\n         */\n        sliderInit: function (index) {\n            var count = this.filteredRows._latestValue.length;\n\n            if (index === count - 1) {\n                setTimeout(function () {\n                    // $(\"form[data-role='tocart-form']\").catalogAddToCart();\n                    var rtl = false;\n                    if ($('body').hasClass('layout-rtl') || $('body').hasClass('rtl')) {\n                        rtl = true;\n                    }\n                    $('.recently-viewed').owlWidget({\n                        \"autoplay\": false,\n                        \"autoplayTimeout\": 5000,\n                        \"items\": 5,\n                        \"margin\": 30,\n                        \"rewind\": true,\n                        \"nav\": true,\n                        \"navText\": ['<i class=\"mbi mbi-chevron-left\"></i>', '<i class=\"mbi mbi-chevron-right\"></i>'],\n                        \"dots\": false,\n                        \"responsive\": {\n                            \"0\": {\"items\": 2},\n                            \"576\": {\"items\": 2},\n                            \"768\": {\"items\": 3},\n                            \"992\": {\"items\": 4},\n                            \"1200\": {\"items\": 5},\n                            \"1600\": {\"items\": 6}\n                        },\n                        \"rtl\": rtl\n                    });\n                    if ($(window).width() > 767) {\n                        $('.mb-tooltip').tooltip({\n                            show: null,\n                            hide: {\n                                delay: 250\n                            },\n                            position: {\n                                my: \"center bottom-30\",\n                                at: \"center top\",\n                                using: function (position, feedback) {\n                                    $(this).css(position);\n                                    $(this).addClass(\"magebig-tooltip\");\n                                }\n                            },\n                            open: function (event, ui) {\n                                ui.tooltip.addClass('in');\n                            },\n                            close: function (event, ui) {\n                                ui.tooltip.removeClass('in');\n                                $(\".ui-helper-hidden-accessible\").remove();\n                            }\n                        });\n                    }\n                }, 1000);\n            }\n        },\n\n        getPercentDiscount: function (row) {\n            var regular_price = row['price_info']['regular_price'],\n                special_price = row['price_info']['final_price'];\n\n            if (regular_price > special_price) {\n                var discount;\n                discount = 100 - parseInt(Math.round((special_price / regular_price) * 100));\n\n                return discount > 0 ? '-' + discount + '%' : false;\n            }\n\n            return false;\n        }\n    });\n});\n","MageBig_AjaxFilter/js/range-slider.js":"/*jshint browser:true jquery:true*/\n/*global alert*/\n\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'jquery/ui-modules/widgets/slider'\n], function ($, priceUtil) {\n    \"use strict\";\n\n    $.widget('magebig.rangeSlider', {\n\n        options: {\n            fromLabel: '[data-role=from-label]',\n            toLabel: '[data-role=to-label]',\n            sliderBar: '[data-role=slider-bar]',\n            applyButton: '[data-role=apply-range]',\n            rate: 1.0000,\n            maxLabelOffset: 0.01\n        },\n\n        _create: function () {\n            this._initSliderValues();\n            this._createSlider();\n            this._refreshDisplay();\n        },\n\n        _initSliderValues: function () {\n            this.rate = parseFloat(this.options.rate);\n            this.from = Math.floor(this.options.currentValue.from * this.rate);\n            this.to = Math.round(this.options.currentValue.to * this.rate);\n            this.minValue = Math.floor(this.options.minValue * this.rate);\n            this.maxValue = Math.round(this.options.maxValue * this.rate);\n        },\n\n        _createSlider: function () {\n            this.element.find(this.options.sliderBar).slider({\n                range: true,\n                min: this.minValue,\n                max: this.maxValue,\n                values: [this.from, this.to],\n                slide: this._onSliderChange.bind(this),\n                step: this.options.step\n            });\n        },\n\n        _onSliderChange: function (ev, ui) {\n            this.from = ui.values[0];\n            this.to = ui.values[1];\n            this._refreshDisplay();\n        },\n\n        _refreshDisplay: function () {\n            if (this.element.find('[data-role=from-label]')) {\n                this.element.find('[data-role=from-label]').html(this._formatLabel(this.from));\n            }\n\n            if (this.element.find('[data-role=to-label]')) {\n                this.element.find('[data-role=to-label]').html(this._formatLabel(this.to - this.options.maxLabelOffset));\n            }\n\n            this._applyRange();\n        },\n\n        _applyRange: function () {\n            var from = this.from * (1 / this.rate),\n                to = this.to * (1 / this.rate),\n                url = this.options.actionUrl,\n                code = this.options.code;\n\n            url += (url.search(/\\?/) != -1) ? '&' : '?';\n            url += code + '=' + from + '-' + to;\n            this.element.find(this.options.applyButton).attr('href', url);\n        },\n\n        _formatLabel: function (value) {\n            var formattedValue = value;\n\n            if (this.options.fieldFormat) {\n                formattedValue = priceUtil.formatPrice(value, this.options.fieldFormat);\n            }\n\n            return formattedValue;\n        }\n    });\n\n    return $.magebig.rangeSlider;\n});\n","MageBig_AjaxFilter/js/ajaxfilter.js":"/**\n * Copyright \u00c2\u00a9 2018 MageBig. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'nanoscroller'\n], function ($) {\n\n    !function (o) {\n        if (o.support.touch = \"ontouchend\" in document, o.support.touch) {\n            var t, e = o.ui.mouse.prototype, u = e._mouseInit, n = e._mouseDestroy;\n\n            function c(o, t) {\n                if (!(o.originalEvent.touches.length > 1)) {\n                    o.preventDefault();\n                    var e = o.originalEvent.changedTouches[0], u = document.createEvent(\"MouseEvents\");\n                    u.initMouseEvent(t, !0, !0, window, 1, e.screenX, e.screenY, e.clientX, e.clientY, !1, !1, !1, !1, 0, null), o.target.dispatchEvent(u)\n                }\n            }\n\n            e._touchStart = function (o) {\n                !t && this._mouseCapture(o.originalEvent.changedTouches[0]) && (t = !0, this._touchMoved = !1, c(o, \"mouseover\"), c(o, \"mousemove\"), c(o, \"mousedown\"))\n            }, e._touchMove = function (o) {\n                t && (this._touchMoved = !0, c(o, \"mousemove\"))\n            }, e._touchEnd = function (o) {\n                t && (c(o, \"mouseup\"), c(o, \"mouseout\"), this._touchMoved || c(o, \"click\"), t = !1)\n            }, e._mouseInit = function () {\n                var t = this;\n                t.element.bind({\n                    touchstart: o.proxy(t, \"_touchStart\"),\n                    touchmove: o.proxy(t, \"_touchMove\"),\n                    touchend: o.proxy(t, \"_touchEnd\")\n                }), u.call(t)\n            }, e._mouseDestroy = function () {\n                var t = this;\n                t.element.unbind({\n                    touchstart: o.proxy(t, \"_touchStart\"),\n                    touchmove: o.proxy(t, \"_touchMove\"),\n                    touchend: o.proxy(t, \"_touchEnd\")\n                }), n.call(t)\n            }\n        }\n    }($);\n\n    $.widget('magebig.ajaxfilter', {\n        options: {\n            enableAjax: true,\n            ajaxSelector: '.filter-current a.action.remove, .filter-options-content a, a.filter-clear, .toolbar-products .pages-items a'\n        },\n\n        _create: function () {\n            var self = this, conf = this.options;\n            this._initBlockHtml();\n            this._defaultEvents();\n            setTimeout(function () {\n                self._updateToolbar();\n            }, 500);\n\n            this._searchTextFilter();\n\n            if (typeof window.history.replaceState === \"function\") {\n                window.history.replaceState({url: document.URL}, document.title);\n\n                setTimeout(function () {\n                    window.onpopstate = function (e) {\n                        if (e.state) {\n                            self._ajaxFilter(e.state.url, true, false);\n                        }\n                    };\n                }, 0)\n            }\n        },\n\n        _initBlockHtml: function () {\n            var self = this, conf = this.options;\n\n            $('.filter-options-item .filter-options-overflow').addClass('nano-content').wrap('<div class=\"nano\"></div>');\n            $('.filter-options-item .nano').nanoScroller();\n\n            this._cloneFilterClear();\n\n            $('[data-role=filter-dropdown]').on('change', function () {\n                var $select = $(this),\n                    actionUrl = $select.val();\n                self.activeCode = $select.data('code');\n                self._ajaxFilter(actionUrl, true, true);\n            });\n            $('[data-role=mb-filter-checkbox] [type=checkbox]').on('change', function () {\n                var $checkbox = $(this),\n                    $elm = $checkbox.parents('[data-role=mb-filter-checkbox]').first(),\n                    code = $elm.data('code'),\n                    actionUrl = $elm.data('action'),\n                    multiSelect = $elm.data('select'),\n                    value = [];\n                if (multiSelect) {\n                    $elm.find('[type=checkbox]:checked').each(function () {\n                        value.push($(this).val());\n                    });\n                } else if ($checkbox.is(':checked')) {\n                    value.push($checkbox.val());\n                    $elm.find('[type=checkbox]:checked').each(function () {\n                        var $this = $(this);\n                        if (!$this.is($checkbox)) {\n                            $this.prop('checked', false);\n                        }\n                    });\n                }\n                if (value.length) {\n                    value = value.join(',');\n                    actionUrl += (actionUrl.search(/\\?/) != -1) ? '&' : '?';\n                    actionUrl += code + '=' + value;\n                }\n                self.activeCode = code;\n                self._ajaxFilter(actionUrl, true, true);\n            });\n        },\n\n        _updateToolbar: function () {\n            var self = this,\n                currURL = document.URL,\n                currURLVars = this.getUrlVars(currURL),\n                params = '?',\n                $currentUrl = window.location.protocol + '//' + window.location.hostname + window.location.pathname;\n\n            $.each(currURLVars, function (index, value) {\n                if (index !== 'p' && index !== 'page') {\n                    params += index + '=' + value + '&';\n                }\n            });\n\n            $('.toolbar.toolbar-products .pages-items a').each(function () {\n                var pageUrl = $(this).attr('href'),\n                    paging = '',\n                    newUrl,\n                    urlVars;\n\n                if (pageUrl.indexOf('p=') > -1 || pageUrl.indexOf('page=') > -1) {\n                    urlVars = self.getUrlVars(pageUrl);\n\n                    $.each(urlVars, function (index, value) {\n                        if (index === 'p' || index === 'page') {\n                            paging = index + '=' + value;\n                        }\n                    });\n\n                    newUrl = $currentUrl + params + paging;\n                    $(this).attr('href', newUrl);\n                }\n            });\n\n            $('.toolbar.toolbar-products').each(function () {\n                var $toolbar = $(this);\n\n                setTimeout(function () {\n                    var toolbarForm = $toolbar.data('mageProductListToolbarForm');\n                    if (toolbarForm) {\n                        toolbarForm.changeUrl = function (paramName, paramValue, defaultValue) {\n                            var decode = window.decodeURIComponent,\n                                urlPaths = this.options.url.split('?'),\n                                baseUrl = urlPaths[0],\n                                urlParams = urlPaths[1] ? urlPaths[1].split('&') : [],\n                                paramData = {},\n                                parameters, i;\n\n                            for (i = 0; i < urlParams.length; i++) {\n                                parameters = urlParams[i].split('=');\n                                paramData[decode(parameters[0])] = parameters[1] !== undefined ?\n                                    decode(parameters[1].replace(/\\+/g, '%20')) : '';\n                            }\n                            paramData[paramName] = paramValue;\n\n                            if (paramValue == defaultValue) {\n                                delete paramData[paramName];\n                            }\n                            paramData = $.param(paramData);\n\n                            var actionUrl = baseUrl + (paramData.length ? '?' + paramData : '');\n                            self._ajaxFilter(actionUrl, true, true);\n                        }\n                    }\n                }, 500);\n            });\n        },\n        _defaultEvents: function () {\n            var self = this, conf = this.options;\n            $(conf.ajaxSelector).on('click', function (e) {\n                e.preventDefault();\n                var $a = $(this);\n                var actionUrl = $a.attr('href');\n                self._ajaxFilter(actionUrl, true, true);\n            });\n        },\n\n        getUrlVars: function (url) {\n            var vars = {};\n            var parts = url.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {\n                vars[key] = value;\n            });\n            return vars;\n        },\n\n        _ajaxFilter: function (actionUrl, needSrollTop, pushState) {\n            var self = this, conf = this.options;\n\n            if ((!actionUrl) || (actionUrl.search('javascript:') == 0) || (actionUrl.search('#') == 0)) {\n                return;\n            }\n\n            if (self.getUrlVars(actionUrl)[\"p\"] == self.getUrlVars(window.location.href)[\"p\"] && pushState) {\n                var tmp = \"p=\" + self.getUrlVars(actionUrl)[\"p\"];\n                actionUrl = actionUrl.replace(tmp, \"\");\n            }\n\n            if (!self.options.enableAjax) {\n                window.location.href = actionUrl;\n                return false;\n            }\n\n            $.ajax({\n                url: actionUrl,\n                type: 'POST',\n                data: {ajax_filter: 1},\n                beforeSend: function () {\n                    $('body').trigger('processStart');\n                },\n                success: function (res) {\n                    if ($.magnificPopup.instance.isOpen) {\n                        $.magnificPopup.close();\n                    }\n                    if (res.catalog_leftnav) {\n                        $('.block.filter').first().replaceWith(res.catalog_leftnav);\n                    }\n                    if (res.category_products) {\n                        res.category_products = decodeURIComponent(res.category_products);\n                        var $listContainer = $('#product-container-wrap');\n                        $listContainer.html(res.category_products);\n\n                        setTimeout(function () {\n                            self._updateToolbar();\n                        }, 0);\n                    }\n                    if (res.page_main_title) {\n                        $('.page-title-wrapper').first().replaceWith(res.page_main_title);\n                    }\n\n                    var urlState;\n\n                    if (res.updated_url) {\n                        urlState = res.updated_url\n                    } else {\n                        urlState = actionUrl;\n                    }\n\n                    if (pushState) {\n                        window.history.pushState({url: urlState}, document.title, urlState);\n                    } else {\n                        var n = history.state;\n                        history.replaceState(n, document.title, urlState);\n                    }\n\n                    self._initBlockHtml();\n                    self._defaultEvents();\n\n                    $('body').trigger('contentUpdated');\n                    setTimeout(function () {\n                        $('body').trigger('reloadAjaxScroll');\n                        if (needSrollTop) {\n                            $('body,html').animate({\n                                scrollTop: $listContainer.offset().top - 100\n                            }, 800);\n                        }\n                    }, 100);\n\n                    $('body').trigger('processStop');\n                },\n                error: function (res) {\n                    $('body').trigger('processStop');\n                    alert('Error in sending ajax request');\n                }\n            }).done(function (res) {\n                $('body').trigger('processStop');\n            });\n        },\n\n        _cloneFilterClear: function () {\n            if (!$('#product-container-wrap .clear-filter-wrap').length) {\n                $('#product-container-wrap').prepend('<div class=\"clear-filter-wrap\"></div>');\n            }\n            if ($('.filter-current').length) {\n                var filter = $('.filter-current').clone().addClass('now-filter-clone');\n                $('.clear-filter-wrap').html(filter);\n            }\n        },\n\n        _searchTextFilter: function () {\n            var self = this;\n            $(\"input.search-filter\").on(\"keyup\", function (ev) {\n                var texto = $(this).val(),\n                    elm = $(this).parents('.filter-options-wrap');\n                self._searchFilter(elm, texto);\n            });\n        },\n\n        _searchFilter: function (elm, texto) {\n            var lista = elm.find('li.item')\n                .hide()\n                .filter(function () {\n                    var item = $(this).text();\n                    var padrao = new RegExp(texto, \"i\");\n\n                    return padrao.test(item);\n                })\n                .show();\n\n        }\n\n    });\n    return $.magebig.ajaxfilter;\n});\n","MageBig_AjaxFilter/js/slider.js":"/*!\n * jQuery UI Slider - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/slider/\n */\ndefine(['jquery','jquery-ui-modules/core','jquery-ui-modules/mouse'],function($,undefined){var numPages=5;$.widget(\"ui.slider\",$.ui.mouse,{version:\"1.10.4\",widgetEventPrefix:\"slide\",options:{animate:false,distance:0,max:100,min:0,orientation:\"horizontal\",range:false,step:1,value:0,values:null,change:null,slide:null,start:null,stop:null},_create:function(){this._keySliding=false;this._mouseSliding=false;this._animateOff=true;this._handleIndex=null;this._detectOrientation();this._mouseInit();this.element.addClass(\"ui-slider\"+\" ui-slider-\"+this.orientation+\" ui-widget\"+\" ui-widget-content\"+\" ui-corner-all\");this._refresh();this._setOption(\"disabled\",this.options.disabled);this._animateOff=false;},_refresh:function(){this._createRange();this._createHandles();this._setupEvents();this._refreshValue();},_createHandles:function(){var i,handleCount,options=this.options,existingHandles=this.element.find(\".ui-slider-handle\").addClass(\"ui-state-default ui-corner-all\"),handle=\"<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>\",handles=[];handleCount=(options.values&&options.values.length)||1;if(existingHandles.length>handleCount){existingHandles.slice(handleCount).remove();existingHandles=existingHandles.slice(0,handleCount);}\n        for(i=existingHandles.length;i<handleCount;i++){handles.push(handle);}\n        this.handles=existingHandles.add($(handles.join(\"\")).appendTo(this.element));this.handle=this.handles.eq(0);this.handles.each(function(i){$(this).data(\"ui-slider-handle-index\",i);});},_createRange:function(){var options=this.options,classes=\"\";if(options.range){if(options.range===true){if(!options.values){options.values=[this._valueMin(),this._valueMin()];}else if(options.values.length&&options.values.length!==2){options.values=[options.values[0],options.values[0]];}else if($.isArray(options.values)){options.values=options.values.slice(0);}}\n        if(!this.range||!this.range.length){this.range=$(\"<div></div>\").appendTo(this.element);classes=\"ui-slider-range\"+\" ui-widget-header ui-corner-all\";}else{this.range.removeClass(\"ui-slider-range-min ui-slider-range-max\").css({\"left\":\"\",\"bottom\":\"\"});}\n        this.range.addClass(classes+\n            ((options.range===\"min\"||options.range===\"max\")?\" ui-slider-range-\"+options.range:\"\"));}else{if(this.range){this.range.remove();}\n        this.range=null;}},_setupEvents:function(){var elements=this.handles.add(this.range).filter(\"a\");this._off(elements);this._on(elements,this._handleEvents);this._hoverable(elements);this._focusable(elements);},_destroy:function(){this.handles.remove();if(this.range){this.range.remove();}\n        this.element.removeClass(\"ui-slider\"+\" ui-slider-horizontal\"+\" ui-slider-vertical\"+\" ui-widget\"+\" ui-widget-content\"+\" ui-corner-all\");this._mouseDestroy();},_mouseCapture:function(event){var position,normValue,distance,closestHandle,index,allowed,offset,mouseOverHandle,that=this,o=this.options;if(o.disabled){return false;}\n        this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()};this.elementOffset=this.element.offset();position={x:event.pageX,y:event.pageY};normValue=this._normValueFromMouse(position);distance=this._valueMax()-this._valueMin()+1;this.handles.each(function(i){var thisDistance=Math.abs(normValue-that.values(i));if((distance>thisDistance)||(distance===thisDistance&&(i===that._lastChangedValue||that.values(i)===o.min))){distance=thisDistance;closestHandle=$(this);index=i;}});allowed=this._start(event,index);if(allowed===false){return false;}\n        this._mouseSliding=true;this._handleIndex=index;closestHandle.addClass(\"ui-state-active\").focus();offset=closestHandle.offset();mouseOverHandle=!$(event.target).parents().addBack().is(\".ui-slider-handle\");this._clickOffset=mouseOverHandle?{left:0,top:0}:{left:event.pageX-offset.left-(closestHandle.width()/ 2),top:event.pageY-offset.top-\n                (closestHandle.height()/ 2)-\n                (parseInt(closestHandle.css(\"borderTopWidth\"),10)||0)-\n                (parseInt(closestHandle.css(\"borderBottomWidth\"),10)||0)+\n                (parseInt(closestHandle.css(\"marginTop\"),10)||0)};if(!this.handles.hasClass(\"ui-state-hover\")){this._slide(event,index,normValue);}\n        this._animateOff=true;return true;},_mouseStart:function(){return true;},_mouseDrag:function(event){var position={x:event.pageX,y:event.pageY},normValue=this._normValueFromMouse(position);this._slide(event,this._handleIndex,normValue);return false;},_mouseStop:function(event){this.handles.removeClass(\"ui-state-active\");this._mouseSliding=false;this._stop(event,this._handleIndex);this._change(event,this._handleIndex);this._handleIndex=null;this._clickOffset=null;this._animateOff=false;return false;},_detectOrientation:function(){this.orientation=(this.options.orientation===\"vertical\")?\"vertical\":\"horizontal\";},_normValueFromMouse:function(position){var pixelTotal,pixelMouse,percentMouse,valueTotal,valueMouse;if(this.orientation===\"horizontal\"){pixelTotal=this.elementSize.width;pixelMouse=position.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0);}else{pixelTotal=this.elementSize.height;pixelMouse=position.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0);}\n        percentMouse=(pixelMouse / pixelTotal);if(percentMouse>1){percentMouse=1;}\n        if(percentMouse<0){percentMouse=0;}\n        if(this.orientation===\"vertical\"){percentMouse=1-percentMouse;}\n        valueTotal=this._valueMax()-this._valueMin();valueMouse=this._valueMin()+percentMouse*valueTotal;return this._trimAlignValue(valueMouse);},_start:function(event,index){var uiHash={handle:this.handles[index],value:this.value()};if(this.options.values&&this.options.values.length){uiHash.value=this.values(index);uiHash.values=this.values();}\n        return this._trigger(\"start\",event,uiHash);},_slide:function(event,index,newVal){var otherVal,newValues,allowed;if(this.options.values&&this.options.values.length){otherVal=this.values(index?0:1);if((this.options.values.length===2&&this.options.range===true)&&((index===0&&newVal>otherVal)||(index===1&&newVal<otherVal))){newVal=otherVal;}\n        if(newVal!==this.values(index)){newValues=this.values();newValues[index]=newVal;allowed=this._trigger(\"slide\",event,{handle:this.handles[index],value:newVal,values:newValues});otherVal=this.values(index?0:1);if(allowed!==false){this.values(index,newVal);}}}else{if(newVal!==this.value()){allowed=this._trigger(\"slide\",event,{handle:this.handles[index],value:newVal});if(allowed!==false){this.value(newVal);}}}},_stop:function(event,index){var uiHash={handle:this.handles[index],value:this.value()};if(this.options.values&&this.options.values.length){uiHash.value=this.values(index);uiHash.values=this.values();}\n        this._trigger(\"stop\",event,uiHash);},_change:function(event,index){if(!this._keySliding&&!this._mouseSliding){var uiHash={handle:this.handles[index],value:this.value()};if(this.options.values&&this.options.values.length){uiHash.value=this.values(index);uiHash.values=this.values();}\n        this._lastChangedValue=index;this._trigger(\"change\",event,uiHash);}},value:function(newValue){if(arguments.length){this.options.value=this._trimAlignValue(newValue);this._refreshValue();this._change(null,0);return;}\n        return this._value();},values:function(index,newValue){var vals,newValues,i;if(arguments.length>1){this.options.values[index]=this._trimAlignValue(newValue);this._refreshValue();this._change(null,index);return;}\n        if(arguments.length){if($.isArray(arguments[0])){vals=this.options.values;newValues=arguments[0];for(i=0;i<vals.length;i+=1){vals[i]=this._trimAlignValue(newValues[i]);this._change(null,i);}\n            this._refreshValue();}else{if(this.options.values&&this.options.values.length){return this._values(index);}else{return this.value();}}}else{return this._values();}},_setOption:function(key,value){var i,valsLength=0;if(key===\"range\"&&this.options.range===true){if(value===\"min\"){this.options.value=this._values(0);this.options.values=null;}else if(value===\"max\"){this.options.value=this._values(this.options.values.length-1);this.options.values=null;}}\n        if($.isArray(this.options.values)){valsLength=this.options.values.length;}\n        $.Widget.prototype._setOption.apply(this,arguments);switch(key){case\"orientation\":this._detectOrientation();this.element.removeClass(\"ui-slider-horizontal ui-slider-vertical\").addClass(\"ui-slider-\"+this.orientation);this._refreshValue();break;case\"value\":this._animateOff=true;this._refreshValue();this._change(null,0);this._animateOff=false;break;case\"values\":this._animateOff=true;this._refreshValue();for(i=0;i<valsLength;i+=1){this._change(null,i);}\n            this._animateOff=false;break;case\"min\":case\"max\":this._animateOff=true;this._refreshValue();this._animateOff=false;break;case\"range\":this._animateOff=true;this._refresh();this._animateOff=false;break;}},_value:function(){var val=this.options.value;val=this._trimAlignValue(val);return val;},_values:function(index){var val,vals,i;if(arguments.length){val=this.options.values[index];val=this._trimAlignValue(val);return val;}else if(this.options.values&&this.options.values.length){vals=this.options.values.slice();for(i=0;i<vals.length;i+=1){vals[i]=this._trimAlignValue(vals[i]);}\n        return vals;}else{return[];}},_trimAlignValue:function(val){if(val<=this._valueMin()){return this._valueMin();}\n        if(val>=this._valueMax()){return this._valueMax();}\n        var step=(this.options.step>0)?this.options.step:1,valModStep=(val-this._valueMin())%step,alignValue=val-valModStep;if(Math.abs(valModStep)*2>=step){alignValue+=(valModStep>0)?step:(-step);}\n        return parseFloat(alignValue.toFixed(5));},_valueMin:function(){return this.options.min;},_valueMax:function(){return this.options.max;},_refreshValue:function(){var lastValPercent,valPercent,value,valueMin,valueMax,oRange=this.options.range,o=this.options,that=this,animate=(!this._animateOff)?o.animate:false,_set={};if(this.options.values&&this.options.values.length){this.handles.each(function(i){valPercent=(that.values(i)-that._valueMin())/(that._valueMax()-that._valueMin())*100;_set[that.orientation===\"horizontal\"?\"left\":\"bottom\"]=valPercent+\"%\";$(this).stop(1,1)[animate?\"animate\":\"css\"](_set,o.animate);if(that.options.range===true){if(that.orientation===\"horizontal\"){if(i===0){that.range.stop(1,1)[animate?\"animate\":\"css\"]({left:valPercent+\"%\"},o.animate);}\n        if(i===1){that.range[animate?\"animate\":\"css\"]({width:(valPercent-lastValPercent)+\"%\"},{queue:false,duration:o.animate});}}else{if(i===0){that.range.stop(1,1)[animate?\"animate\":\"css\"]({bottom:(valPercent)+\"%\"},o.animate);}\n        if(i===1){that.range[animate?\"animate\":\"css\"]({height:(valPercent-lastValPercent)+\"%\"},{queue:false,duration:o.animate});}}}\n        lastValPercent=valPercent;});}else{value=this.value();valueMin=this._valueMin();valueMax=this._valueMax();valPercent=(valueMax!==valueMin)?(value-valueMin)/(valueMax-valueMin)*100:0;_set[this.orientation===\"horizontal\"?\"left\":\"bottom\"]=valPercent+\"%\";this.handle.stop(1,1)[animate?\"animate\":\"css\"](_set,o.animate);if(oRange===\"min\"&&this.orientation===\"horizontal\"){this.range.stop(1,1)[animate?\"animate\":\"css\"]({width:valPercent+\"%\"},o.animate);}\n        if(oRange===\"max\"&&this.orientation===\"horizontal\"){this.range[animate?\"animate\":\"css\"]({width:(100-valPercent)+\"%\"},{queue:false,duration:o.animate});}\n        if(oRange===\"min\"&&this.orientation===\"vertical\"){this.range.stop(1,1)[animate?\"animate\":\"css\"]({height:valPercent+\"%\"},o.animate);}\n        if(oRange===\"max\"&&this.orientation===\"vertical\"){this.range[animate?\"animate\":\"css\"]({height:(100-valPercent)+\"%\"},{queue:false,duration:o.animate});}}},_handleEvents:{keydown:function(event){var allowed,curVal,newVal,step,index=$(event.target).data(\"ui-slider-handle-index\");switch(event.keyCode){case $.ui.keyCode.HOME:case $.ui.keyCode.END:case $.ui.keyCode.PAGE_UP:case $.ui.keyCode.PAGE_DOWN:case $.ui.keyCode.UP:case $.ui.keyCode.RIGHT:case $.ui.keyCode.DOWN:case $.ui.keyCode.LEFT:event.preventDefault();if(!this._keySliding){this._keySliding=true;$(event.target).addClass(\"ui-state-active\");allowed=this._start(event,index);if(allowed===false){return;}}\n            break;}\n            step=this.options.step;if(this.options.values&&this.options.values.length){curVal=newVal=this.values(index);}else{curVal=newVal=this.value();}\n            switch(event.keyCode){case $.ui.keyCode.HOME:newVal=this._valueMin();break;case $.ui.keyCode.END:newVal=this._valueMax();break;case $.ui.keyCode.PAGE_UP:newVal=this._trimAlignValue(curVal+((this._valueMax()-this._valueMin())/ numPages));break;case $.ui.keyCode.PAGE_DOWN:newVal=this._trimAlignValue(curVal-((this._valueMax()-this._valueMin())/ numPages));break;case $.ui.keyCode.UP:case $.ui.keyCode.RIGHT:if(curVal===this._valueMax()){return;}\n                newVal=this._trimAlignValue(curVal+step);break;case $.ui.keyCode.DOWN:case $.ui.keyCode.LEFT:if(curVal===this._valueMin()){return;}\n                newVal=this._trimAlignValue(curVal-step);break;}\n            this._slide(event,index,newVal);},click:function(event){event.preventDefault();},keyup:function(event){var index=$(event.target).data(\"ui-slider-handle-index\");if(this._keySliding){this._keySliding=false;this._stop(event,index);this._change(event,index);$(event.target).removeClass(\"ui-state-active\");}}}});});\n","Magento_Vault/js/customer_account/deleteWidget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modalToggle',\n    'mage/translate'\n], function ($, modalToggle) {\n    'use strict';\n\n    return function (config, deleteButton) {\n        config.buttons = [\n            {\n                text: $.mage.__('Cancel'),\n                class: 'action secondary cancel'\n            }, {\n                text: $.mage.__('Delete'),\n                class: 'action primary',\n\n                /**\n                 * Default action on button click\n                 */\n                click: function (event) { //eslint-disable-line no-unused-vars\n                    $(deleteButton.form).trigger('submit');\n                }\n            }\n        ];\n\n        modalToggle(config, deleteButton);\n    };\n});\n","Magento_Vault/js/view/payment/vault-enabler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\n/* @api */\ndefine(\n    [\n        'uiElement'\n    ],\n    function (\n        Component\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                isActivePaymentTokenEnabler: true\n            },\n\n            /**\n             * @param {String} paymentCode\n             */\n            setPaymentCode: function (paymentCode) {\n                this.paymentCode = paymentCode;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([\n                        'isActivePaymentTokenEnabler'\n                    ]);\n\n                return this;\n            },\n\n            /**\n             * @param {Object} data\n             */\n            visitAdditionalData: function (data) {\n                if (!this.isVaultEnabled()) {\n                    return;\n                }\n\n                if (!('additional_data' in data)) {\n                    data['additional_data'] = {};\n                }\n\n                data['additional_data']['is_active_payment_token_enabler'] = this.isActivePaymentTokenEnabler();\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isVaultEnabled: function () {\n                return typeof window.checkoutConfig.vault[this.paymentCode] !== 'undefined' &&\n                    window.checkoutConfig.vault[this.paymentCode]['is_enabled'] === true;\n            }\n        });\n    }\n);\n","Magento_Vault/js/view/payment/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\n/* @api */\ndefine([\n    'underscore',\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list',\n    'uiLayout',\n    'uiRegistry'\n], function (_, Component, rendererList, layout, registry) {\n    'use strict';\n\n    var vaultGroupName = 'vaultGroup';\n\n    layout([{\n        name: vaultGroupName,\n        component: 'Magento_Checkout/js/model/payment/method-group',\n        alias: 'vault',\n        sortOrder: 10\n    }]);\n\n    registry.get(vaultGroupName, function (vaultGroup) {\n        _.each(window.checkoutConfig.payment.vault, function (config, index) {\n            rendererList.push(\n                {\n                    type: index,\n                    config: config.config,\n                    component: config.component,\n                    group: vaultGroup,\n\n                    /**\n                     * Custom payment method types comparator\n                     * @param {String} typeA\n                     * @param {String} typeB\n                     * @return {Boolean}\n                     */\n                    typeComparatorCallback: function (typeA, typeB) {\n                        // vault token items have the same name as vault payment without index\n                        return typeA.substring(0, typeA.lastIndexOf('_')) === typeB;\n                    }\n                }\n            );\n        });\n    });\n\n    /**\n     * Add view logic here if needed\n     */\n    return Component.extend({});\n});\n","Magento_Vault/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Checkout/js/action/select-payment-method',\n        'Magento_Checkout/js/checkout-data'\n    ],\n    function (Component, selectPaymentMethod, checkoutData) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Vault/payment/form'\n            },\n\n            /**\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([]);\n\n                return this;\n            },\n\n            /**\n             * @returns\n             */\n            selectPaymentMethod: function () {\n                selectPaymentMethod(\n                    {\n                        method: this.getId()\n                    }\n                );\n                checkoutData.setSelectedPaymentMethod(this.getId());\n\n                return true;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getTitle: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getToken: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getId: function () {\n                return this.index;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Get last 4 digits of card\n             * @returns {String}\n             */\n            getMaskedCard: function () {\n                return '';\n            },\n\n            /**\n             * Get expiration date\n             * @returns {String}\n             */\n            getExpirationDate: function () {\n                return '';\n            },\n\n            /**\n             * Get card type\n             * @returns {String}\n             */\n            getCardType: function () {\n                return '';\n            },\n\n            /**\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.ccform.icons[type]\n                    : false;\n            },\n\n            /**\n             * Return state of place order button.\n             *\n             * @return {Boolean}\n             */\n            isButtonActive: function () {\n                return this.isActive() && this.isPlaceOrderActionAllowed();\n            },\n\n            /**\n             * Check if payment is active.\n             *\n             * @return {Boolean}\n             */\n            isActive: function () {\n                return this.isChecked() === this.getId();\n            },\n\n            /**\n             * @returns {*}\n             */\n            getData: function () {\n                var data = {\n                    method: this.getCode()\n                };\n\n                data['additional_data'] = {};\n                data['additional_data']['public_hash'] = this.getToken();\n\n                return data;\n            }\n        });\n    }\n);\n","Magento_ReCaptchaPaypal/js/payflowpro-method-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/payment/additional-validators'\n], function ($, additionalValidators) {\n    'use strict';\n\n    return function (originalComponent) {\n        return originalComponent.extend({\n            /**\n             * Initializes reCaptcha\n             */\n            placeOrder: function () {\n                var original = this._super.bind(this),\n                    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    isEnabledForPaypal = window.checkoutConfig.recaptcha_paypal,\n                    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    paymentFormSelector = $('#co-payment-form'),\n                    startEvent = 'captcha:startExecute',\n                    endEvent = 'captcha:endExecute';\n\n                if (!this.validateHandler() || !additionalValidators.validate() || !isEnabledForPaypal) {\n                    return original();\n                }\n\n                paymentFormSelector.off(endEvent).on(endEvent, function () {\n                    original();\n                    paymentFormSelector.off(endEvent);\n                });\n\n                paymentFormSelector.trigger(startEvent);\n            }\n        });\n    };\n});\n","Magento_ReCaptchaPaypal/js/reCaptchaPaypal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(\n    [\n        'Magento_ReCaptchaFrontendUi/js/reCaptcha',\n        'jquery'\n    ],\n    function (Component, $) {\n        'use strict';\n\n        return Component.extend({\n\n            /**\n             * Recaptcha callback\n             * @param {String} token\n             */\n            reCaptchaCallback: function (token) {\n                this.tokenField.value = token;\n                this.$parentForm.trigger('captcha:endExecute');\n            },\n\n            /**\n             * Initialize parent form.\n             *\n             * @param {Object} parentForm\n             * @param {String} widgetId\n             */\n            initParentForm: function (parentForm, widgetId) {\n                var me = this;\n\n                parentForm.on('captcha:startExecute', function (event) {\n                    if (!me.tokenField.value && me.getIsInvisibleRecaptcha()) {\n                        // eslint-disable-next-line no-undef\n                        grecaptcha.execute(widgetId);\n                        event.preventDefault(event);\n                        event.stopImmediatePropagation();\n                    } else {\n                        me.$parentForm.trigger('captcha:endExecute');\n                    }\n                });\n\n                // Create a virtual token field\n                this.tokenField = $('<input type=\"text\" name=\"token\" style=\"display: none\" />')[0];\n                this.$parentForm = parentForm;\n                parentForm.append(this.tokenField);\n            }\n        });\n    }\n);\n"}
}});
