<?php

namespace Amasty\Xnotif\Controller\Adminhtml\Analytics;

use Magento\Framework\Controller\ResultFactory;
use Magento\Backend\App\Action;

/**
 * Class Index
 */
class Index extends Action
{
    /**
     * Index action
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $resultPage->setActiveMenu('Amasty_Xnotif::analytics');
        $resultPage->getConfig()->getTitle()->prepend(__('Analytics Dashboard'));
        $resultPage->addBreadcrumb(__('Notifications'), __('Analytics Dashboard'));

        return $resultPage;
    }

    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Amasty_Xnotif::analytics');
    }
}
