require.config({"config": {
        "jsbuild":{"Amasty_Reports/amcharts/plugins/export/libs/xlsx/xlsx.js":"// phpcs:ignoreFile\n/* eslint-disable */\n/* xlsx.js (C) 2013-2015 SheetJS -- http://sheetjs.com */\n/* vim: set ts=2: */\n/*jshint -W041 */\n/*jshint funcscope:true, eqnull:true */\nvar XLSX = {};\n(function make_xlsx(XLSX){\nXLSX.version = '0.8.0';\nvar current_codepage = 1200, current_cptable;\nif(typeof module !== \"undefined\" && typeof require !== 'undefined') {\n    if(typeof cptable === 'undefined') cptable = require('./dist/cpexcel');\n    current_cptable = cptable[current_codepage];\n}\nfunction reset_cp() { set_cp(1200); }\nvar set_cp = function(cp) { current_codepage = cp; };\n\nfunction char_codes(data) { var o = []; for(var i = 0, len = data.length; i < len; ++i) o[i] = data.charCodeAt(i); return o; }\nvar debom_xml = function(data) { return data; };\n\nvar _getchar = function _gc1(x) { return String.fromCharCode(x); };\nif(typeof cptable !== 'undefined') {\n    set_cp = function(cp) { current_codepage = cp; current_cptable = cptable[cp]; };\n    debom_xml = function(data) {\n        if(data.charCodeAt(0) === 0xFF && data.charCodeAt(1) === 0xFE) { return cptable.utils.decode(1200, char_codes(data.substr(2))); }\n        return data;\n    };\n    _getchar = function _gc2(x) {\n        if(current_codepage === 1200) return String.fromCharCode(x);\n        return cptable.utils.decode(current_codepage, [x&255,x>>8])[0];\n    };\n}\nvar Base64 = (function make_b64(){\n    var map = \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\";\n    return {\n        encode: function(input, utf8) {\n            var o = \"\";\n            var c1, c2, c3, e1, e2, e3, e4;\n            for(var i = 0; i < input.length; ) {\n                c1 = input.charCodeAt(i++);\n                c2 = input.charCodeAt(i++);\n                c3 = input.charCodeAt(i++);\n                e1 = c1 >> 2;\n                e2 = (c1 & 3) << 4 | c2 >> 4;\n                e3 = (c2 & 15) << 2 | c3 >> 6;\n                e4 = c3 & 63;\n                if (isNaN(c2)) { e3 = e4 = 64; }\n                else if (isNaN(c3)) { e4 = 64; }\n                o += map.charAt(e1) + map.charAt(e2) + map.charAt(e3) + map.charAt(e4);\n            }\n            return o;\n        },\n        decode: function b64_decode(input, utf8) {\n            var o = \"\";\n            var c1, c2, c3;\n            var e1, e2, e3, e4;\n            input = input.replace(/[^A-Za-z0-9\\+\\/\\=]/g, \"\");\n            for(var i = 0; i < input.length;) {\n                e1 = map.indexOf(input.charAt(i++));\n                e2 = map.indexOf(input.charAt(i++));\n                e3 = map.indexOf(input.charAt(i++));\n                e4 = map.indexOf(input.charAt(i++));\n                c1 = e1 << 2 | e2 >> 4;\n                c2 = (e2 & 15) << 4 | e3 >> 2;\n                c3 = (e3 & 3) << 6 | e4;\n                o += String.fromCharCode(c1);\n                if (e3 != 64) { o += String.fromCharCode(c2); }\n                if (e4 != 64) { o += String.fromCharCode(c3); }\n            }\n            return o;\n        }\n    };\n})();\nvar has_buf = (typeof Buffer !== 'undefined');\n\nfunction new_raw_buf(len) {\n    /* jshint -W056 */\n    return new (has_buf ? Buffer : Array)(len);\n    /* jshint +W056 */\n}\n\nfunction s2a(s) {\n    if(has_buf) return new Buffer(s, \"binary\");\n    return s.split(\"\").map(function(x){ return x.charCodeAt(0) & 0xff; });\n}\n\nvar bconcat = function(bufs) { return [].concat.apply([], bufs); };\n\nvar chr0 = /\\u0000/g, chr1 = /[\\u0001-\\u0006]/;\n/* ssf.js (C) 2013-2014 SheetJS -- http://sheetjs.com */\n/*jshint -W041 */\nvar SSF = {};\nvar make_ssf = function make_ssf(SSF){\nSSF.version = '0.8.1';\nfunction _strrev(x) { var o = \"\", i = x.length-1; while(i>=0) o += x.charAt(i--); return o; }\nfunction fill(c,l) { var o = \"\"; while(o.length < l) o+=c; return o; }\nfunction pad0(v,d){var t=\"\"+v; return t.length>=d?t:fill('0',d-t.length)+t;}\nfunction pad_(v,d){var t=\"\"+v;return t.length>=d?t:fill(' ',d-t.length)+t;}\nfunction rpad_(v,d){var t=\"\"+v; return t.length>=d?t:t+fill(' ',d-t.length);}\nfunction pad0r1(v,d){var t=\"\"+Math.round(v); return t.length>=d?t:fill('0',d-t.length)+t;}\nfunction pad0r2(v,d){var t=\"\"+v; return t.length>=d?t:fill('0',d-t.length)+t;}\nvar p2_32 = Math.pow(2,32);\nfunction pad0r(v,d){if(v>p2_32||v<-p2_32) return pad0r1(v,d); var i = Math.round(v); return pad0r2(i,d); }\nfunction isgeneral(s, i) { return s.length >= 7 + i && (s.charCodeAt(i)|32) === 103 && (s.charCodeAt(i+1)|32) === 101 && (s.charCodeAt(i+2)|32) === 110 && (s.charCodeAt(i+3)|32) === 101 && (s.charCodeAt(i+4)|32) === 114 && (s.charCodeAt(i+5)|32) === 97 && (s.charCodeAt(i+6)|32) === 108; }\n/* Options */\nvar opts_fmt = [\n    [\"date1904\", 0],\n    [\"output\", \"\"],\n    [\"WTF\", false]\n];\nfunction fixopts(o){\n    for(var y = 0; y != opts_fmt.length; ++y) if(o[opts_fmt[y][0]]===undefined) o[opts_fmt[y][0]]=opts_fmt[y][1];\n}\nSSF.opts = opts_fmt;\nvar table_fmt = {\n    0:  'General',\n    1:  '0',\n    2:  '0.00',\n    3:  '#,##0',\n    4:  '#,##0.00',\n    9:  '0%',\n    10: '0.00%',\n    11: '0.00E+00',\n    12: '# ?/?',\n    13: '# ??/??',\n    14: 'm/d/yy',\n    15: 'd-mmm-yy',\n    16: 'd-mmm',\n    17: 'mmm-yy',\n    18: 'h:mm AM/PM',\n    19: 'h:mm:ss AM/PM',\n    20: 'h:mm',\n    21: 'h:mm:ss',\n    22: 'm/d/yy h:mm',\n    37: '#,##0 ;(#,##0)',\n    38: '#,##0 ;[Red](#,##0)',\n    39: '#,##0.00;(#,##0.00)',\n    40: '#,##0.00;[Red](#,##0.00)',\n    45: 'mm:ss',\n    46: '[h]:mm:ss',\n    47: 'mmss.0',\n    48: '##0.0E+0',\n    49: '@',\n    56: '\"\u4e0a\u5348/\u4e0b\u5348 \"hh\"\u6642\"mm\"\u5206\"ss\"\u79d2 \"',\n    65535: 'General'\n};\nvar days = [\n    ['Sun', 'Sunday'],\n    ['Mon', 'Monday'],\n    ['Tue', 'Tuesday'],\n    ['Wed', 'Wednesday'],\n    ['Thu', 'Thursday'],\n    ['Fri', 'Friday'],\n    ['Sat', 'Saturday']\n];\nvar months = [\n    ['J', 'Jan', 'January'],\n    ['F', 'Feb', 'February'],\n    ['M', 'Mar', 'March'],\n    ['A', 'Apr', 'April'],\n    ['M', 'May', 'May'],\n    ['J', 'Jun', 'June'],\n    ['J', 'Jul', 'July'],\n    ['A', 'Aug', 'August'],\n    ['S', 'Sep', 'September'],\n    ['O', 'Oct', 'October'],\n    ['N', 'Nov', 'November'],\n    ['D', 'Dec', 'December']\n];\nfunction frac(x, D, mixed) {\n    var sgn = x < 0 ? -1 : 1;\n    var B = x * sgn;\n    var P_2 = 0, P_1 = 1, P = 0;\n    var Q_2 = 1, Q_1 = 0, Q = 0;\n    var A = Math.floor(B);\n    while(Q_1 < D) {\n        A = Math.floor(B);\n        P = A * P_1 + P_2;\n        Q = A * Q_1 + Q_2;\n        if((B - A) < 0.0000000005) break;\n        B = 1 / (B - A);\n        P_2 = P_1; P_1 = P;\n        Q_2 = Q_1; Q_1 = Q;\n    }\n    if(Q > D) { Q = Q_1; P = P_1; }\n    if(Q > D) { Q = Q_2; P = P_2; }\n    if(!mixed) return [0, sgn * P, Q];\n    if(Q===0) throw \"Unexpected state: \"+P+\" \"+P_1+\" \"+P_2+\" \"+Q+\" \"+Q_1+\" \"+Q_2;\n    var q = Math.floor(sgn * P/Q);\n    return [q, sgn*P - q*Q, Q];\n}\nfunction general_fmt_int(v, opts) { return \"\"+v; }\nSSF._general_int = general_fmt_int;\nvar general_fmt_num = (function make_general_fmt_num() {\nvar gnr1 = /\\.(\\d*[1-9])0+$/, gnr2 = /\\.0*$/, gnr4 = /\\.(\\d*[1-9])0+/, gnr5 = /\\.0*[Ee]/, gnr6 = /(E[+-])(\\d)$/;\nfunction gfn2(v) {\n    var w = (v<0?12:11);\n    var o = gfn5(v.toFixed(12)); if(o.length <= w) return o;\n    o = v.toPrecision(10); if(o.length <= w) return o;\n    return v.toExponential(5);\n}\nfunction gfn3(v) {\n    var o = v.toFixed(11).replace(gnr1,\".$1\");\n    if(o.length > (v<0?12:11)) o = v.toPrecision(6);\n    return o;\n}\nfunction gfn4(o) {\n    for(var i = 0; i != o.length; ++i) if((o.charCodeAt(i) | 0x20) === 101) return o.replace(gnr4,\".$1\").replace(gnr5,\"E\").replace(\"e\",\"E\").replace(gnr6,\"$10$2\");\n    return o;\n}\nfunction gfn5(o) {\n    //for(var i = 0; i != o.length; ++i) if(o.charCodeAt(i) === 46) return o.replace(gnr2,\"\").replace(gnr1,\".$1\");\n    //return o;\n    return o.indexOf(\".\") > -1 ? o.replace(gnr2,\"\").replace(gnr1,\".$1\") : o;\n}\nreturn function general_fmt_num(v, opts) {\n    var V = Math.floor(Math.log(Math.abs(v))*Math.LOG10E), o;\n    if(V >= -4 && V <= -1) o = v.toPrecision(10+V);\n    else if(Math.abs(V) <= 9) o = gfn2(v);\n    else if(V === 10) o = v.toFixed(10).substr(0,12);\n    else o = gfn3(v);\n    return gfn5(gfn4(o));\n};})();\nSSF._general_num = general_fmt_num;\nfunction general_fmt(v, opts) {\n    switch(typeof v) {\n        case 'string': return v;\n        case 'boolean': return v ? \"TRUE\" : \"FALSE\";\n        case 'number': return (v|0) === v ? general_fmt_int(v, opts) : general_fmt_num(v, opts);\n    }\n    throw new Error(\"unsupported value in General format: \" + v);\n}\nSSF._general = general_fmt;\nfunction fix_hijri(date, o) { return 0; }\nfunction parse_date_code(v,opts,b2) {\n    if(v > 2958465 || v < 0) return null;\n    var date = (v|0), time = Math.floor(86400 * (v - date)), dow=0;\n    var dout=[];\n    var out={D:date, T:time, u:86400*(v-date)-time,y:0,m:0,d:0,H:0,M:0,S:0,q:0};\n    if(Math.abs(out.u) < 1e-6) out.u = 0;\n    fixopts(opts != null ? opts : (opts=[]));\n    if(opts.date1904) date += 1462;\n    if(out.u > 0.999) {\n        out.u = 0;\n        if(++time == 86400) { time = 0; ++date; }\n    }\n    if(date === 60) {dout = b2 ? [1317,10,29] : [1900,2,29]; dow=3;}\n    else if(date === 0) {dout = b2 ? [1317,8,29] : [1900,1,0]; dow=6;}\n    else {\n        if(date > 60) --date;\n        /* 1 = Jan 1 1900 */\n        var d = new Date(1900,0,1);\n        d.setDate(d.getDate() + date - 1);\n        dout = [d.getFullYear(), d.getMonth()+1,d.getDate()];\n        dow = d.getDay();\n        if(date < 60) dow = (dow + 6) % 7;\n        if(b2) dow = fix_hijri(d, dout);\n    }\n    out.y = dout[0]; out.m = dout[1]; out.d = dout[2];\n    out.S = time % 60; time = Math.floor(time / 60);\n    out.M = time % 60; time = Math.floor(time / 60);\n    out.H = time;\n    out.q = dow;\n    return out;\n}\nSSF.parse_date_code = parse_date_code;\n/*jshint -W086 */\nfunction write_date(type, fmt, val, ss0) {\n    var o=\"\", ss=0, tt=0, y = val.y, out, outl = 0;\n    switch(type) {\n        case 98: /* 'b' buddhist year */\n            y = val.y + 543;\n            /* falls through */\n        case 121: /* 'y' year */\n        switch(fmt.length) {\n            case 1: case 2: out = y % 100; outl = 2; break;\n            default: out = y % 10000; outl = 4; break;\n        } break;\n        case 109: /* 'm' month */\n        switch(fmt.length) {\n            case 1: case 2: out = val.m; outl = fmt.length; break;\n            case 3: return months[val.m-1][1];\n            case 5: return months[val.m-1][0];\n            default: return months[val.m-1][2];\n        } break;\n        case 100: /* 'd' day */\n        switch(fmt.length) {\n            case 1: case 2: out = val.d; outl = fmt.length; break;\n            case 3: return days[val.q][0];\n            default: return days[val.q][1];\n        } break;\n        case 104: /* 'h' 12-hour */\n        switch(fmt.length) {\n            case 1: case 2: out = 1+(val.H+11)%12; outl = fmt.length; break;\n            default: throw 'bad hour format: ' + fmt;\n        } break;\n        case 72: /* 'H' 24-hour */\n        switch(fmt.length) {\n            case 1: case 2: out = val.H; outl = fmt.length; break;\n            default: throw 'bad hour format: ' + fmt;\n        } break;\n        case 77: /* 'M' minutes */\n        switch(fmt.length) {\n            case 1: case 2: out = val.M; outl = fmt.length; break;\n            default: throw 'bad minute format: ' + fmt;\n        } break;\n        case 115: /* 's' seconds */\n        if(val.u === 0) switch(fmt) {\n            case 's': case 'ss': return pad0(val.S, fmt.length);\n            case '.0': case '.00': case '.000':\n        }\n        switch(fmt) {\n            case 's': case 'ss': case '.0': case '.00': case '.000':\n                if(ss0 >= 2) tt = ss0 === 3 ? 1000 : 100;\n                else tt = ss0 === 1 ? 10 : 1;\n                ss = Math.round((tt)*(val.S + val.u));\n                if(ss >= 60*tt) ss = 0;\n                if(fmt === 's') return ss === 0 ? \"0\" : \"\"+ss/tt;\n                o = pad0(ss,2 + ss0);\n                if(fmt === 'ss') return o.substr(0,2);\n                return \".\" + o.substr(2,fmt.length-1);\n            default: throw 'bad second format: ' + fmt;\n        }\n        case 90: /* 'Z' absolute time */\n        switch(fmt) {\n            case '[h]': case '[hh]': out = val.D*24+val.H; break;\n            case '[m]': case '[mm]': out = (val.D*24+val.H)*60+val.M; break;\n            case '[s]': case '[ss]': out = ((val.D*24+val.H)*60+val.M)*60+Math.round(val.S+val.u); break;\n            default: throw 'bad abstime format: ' + fmt;\n        } outl = fmt.length === 3 ? 1 : 2; break;\n        case 101: /* 'e' era */\n            out = y; outl = 1;\n    }\n    if(outl > 0) return pad0(out, outl); else return \"\";\n}\n/*jshint +W086 */\nfunction commaify(s) {\n    if(s.length <= 3) return s;\n    var j = (s.length % 3), o = s.substr(0,j);\n    for(; j!=s.length; j+=3) o+=(o.length > 0 ? \",\" : \"\") + s.substr(j,3);\n    return o;\n}\nvar write_num = (function make_write_num(){\nvar pct1 = /%/g;\nfunction write_num_pct(type, fmt, val){\n    var sfmt = fmt.replace(pct1,\"\"), mul = fmt.length - sfmt.length;\n    return write_num(type, sfmt, val * Math.pow(10,2*mul)) + fill(\"%\",mul);\n}\nfunction write_num_cm(type, fmt, val){\n    var idx = fmt.length - 1;\n    while(fmt.charCodeAt(idx-1) === 44) --idx;\n    return write_num(type, fmt.substr(0,idx), val / Math.pow(10,3*(fmt.length-idx)));\n}\nfunction write_num_exp(fmt, val){\n    var o;\n    var idx = fmt.indexOf(\"E\") - fmt.indexOf(\".\") - 1;\n    if(fmt.match(/^#+0.0E\\+0$/)) {\n        var period = fmt.indexOf(\".\"); if(period === -1) period=fmt.indexOf('E');\n        var ee = Math.floor(Math.log(Math.abs(val))*Math.LOG10E)%period;\n        if(ee < 0) ee += period;\n        o = (val/Math.pow(10,ee)).toPrecision(idx+1+(period+ee)%period);\n        if(o.indexOf(\"e\") === -1) {\n            var fakee = Math.floor(Math.log(Math.abs(val))*Math.LOG10E);\n            if(o.indexOf(\".\") === -1) o = o[0] + \".\" + o.substr(1) + \"E+\" + (fakee - o.length+ee);\n            else o += \"E+\" + (fakee - ee);\n            while(o.substr(0,2) === \"0.\") {\n                o = o[0] + o.substr(2,period) + \".\" + o.substr(2+period);\n                o = o.replace(/^0+([1-9])/,\"$1\").replace(/^0+\\./,\"0.\");\n            }\n            o = o.replace(/\\+-/,\"-\");\n        }\n        o = o.replace(/^([+-]?)(\\d*)\\.(\\d*)[Ee]/,function($$,$1,$2,$3) { return $1 + $2 + $3.substr(0,(period+ee)%period) + \".\" + $3.substr(ee) + \"E\"; });\n    } else o = val.toExponential(idx);\n    if(fmt.match(/E\\+00$/) && o.match(/e[+-]\\d$/)) o = o.substr(0,o.length-1) + \"0\" + o[o.length-1];\n    if(fmt.match(/E\\-/) && o.match(/e\\+/)) o = o.replace(/e\\+/,\"e\");\n    return o.replace(\"e\",\"E\");\n}\nvar frac1 = /# (\\?+)( ?)\\/( ?)(\\d+)/;\nfunction write_num_f1(r, aval, sign) {\n    var den = parseInt(r[4]), rr = Math.round(aval * den), base = Math.floor(rr/den);\n    var myn = (rr - base*den), myd = den;\n    return sign + (base === 0 ? \"\" : \"\"+base) + \" \" + (myn === 0 ? fill(\" \", r[1].length + 1 + r[4].length) : pad_(myn,r[1].length) + r[2] + \"/\" + r[3] + pad0(myd,r[4].length));\n}\nfunction write_num_f2(r, aval, sign) {\n    return sign + (aval === 0 ? \"\" : \"\"+aval) + fill(\" \", r[1].length + 2 + r[4].length);\n}\nvar dec1 = /^#*0*\\.(0+)/;\nvar closeparen = /\\).*[0#]/;\nvar phone = /\\(###\\) ###\\\\?-####/;\nfunction hashq(str) {\n    var o = \"\", cc;\n    for(var i = 0; i != str.length; ++i) switch((cc=str.charCodeAt(i))) {\n        case 35: break;\n        case 63: o+= \" \"; break;\n        case 48: o+= \"0\"; break;\n        default: o+= String.fromCharCode(cc);\n    }\n    return o;\n}\nfunction rnd(val, d) { var dd = Math.pow(10,d); return \"\"+(Math.round(val * dd)/dd); }\nfunction dec(val, d) { return Math.round((val-Math.floor(val))*Math.pow(10,d)); }\nfunction flr(val) { if(val < 2147483647 && val > -2147483648) return \"\"+(val >= 0 ? (val|0) : (val-1|0)); return \"\"+Math.floor(val); }\nfunction write_num_flt(type, fmt, val) {\n    if(type.charCodeAt(0) === 40 && !fmt.match(closeparen)) {\n        var ffmt = fmt.replace(/\\( */,\"\").replace(/ \\)/,\"\").replace(/\\)/,\"\");\n        if(val >= 0) return write_num_flt('n', ffmt, val);\n        return '(' + write_num_flt('n', ffmt, -val) + ')';\n    }\n    if(fmt.charCodeAt(fmt.length - 1) === 44) return write_num_cm(type, fmt, val);\n    if(fmt.indexOf('%') !== -1) return write_num_pct(type, fmt, val);\n    if(fmt.indexOf('E') !== -1) return write_num_exp(fmt, val);\n    if(fmt.charCodeAt(0) === 36) return \"$\"+write_num_flt(type,fmt.substr(fmt[1]==' '?2:1),val);\n    var o, oo;\n    var r, ri, ff, aval = Math.abs(val), sign = val < 0 ? \"-\" : \"\";\n    if(fmt.match(/^00+$/)) return sign + pad0r(aval,fmt.length);\n    if(fmt.match(/^[#?]+$/)) {\n        o = pad0r(val,0); if(o === \"0\") o = \"\";\n        return o.length > fmt.length ? o : hashq(fmt.substr(0,fmt.length-o.length)) + o;\n    }\n    if((r = fmt.match(frac1)) !== null) return write_num_f1(r, aval, sign);\n    if(fmt.match(/^#+0+$/) !== null) return sign + pad0r(aval,fmt.length - fmt.indexOf(\"0\"));\n    if((r = fmt.match(dec1)) !== null) {\n        o = rnd(val, r[1].length).replace(/^([^\\.]+)$/,\"$1.\"+r[1]).replace(/\\.$/,\".\"+r[1]).replace(/\\.(\\d*)$/,function($$, $1) { return \".\" + $1 + fill(\"0\", r[1].length-$1.length); });\n        return fmt.indexOf(\"0.\") !== -1 ? o : o.replace(/^0\\./,\".\");\n    }\n    fmt = fmt.replace(/^#+([0.])/, \"$1\");\n    if((r = fmt.match(/^(0*)\\.(#*)$/)) !== null) {\n        return sign + rnd(aval, r[2].length).replace(/\\.(\\d*[1-9])0*$/,\".$1\").replace(/^(-?\\d*)$/,\"$1.\").replace(/^0\\./,r[1].length?\"0.\":\".\");\n    }\n    if((r = fmt.match(/^#,##0(\\.?)$/)) !== null) return sign + commaify(pad0r(aval,0));\n    if((r = fmt.match(/^#,##0\\.([#0]*0)$/)) !== null) {\n        return val < 0 ? \"-\" + write_num_flt(type, fmt, -val) : commaify(\"\"+(Math.floor(val))) + \".\" + pad0(dec(val, r[1].length),r[1].length);\n    }\n    if((r = fmt.match(/^#,#*,#0/)) !== null) return write_num_flt(type,fmt.replace(/^#,#*,/,\"\"),val);\n    if((r = fmt.match(/^([0#]+)(\\\\?-([0#]+))+$/)) !== null) {\n        o = _strrev(write_num_flt(type, fmt.replace(/[\\\\-]/g,\"\"), val));\n        ri = 0;\n        return _strrev(_strrev(fmt.replace(/\\\\/g,\"\")).replace(/[0#]/g,function(x){return ri<o.length?o[ri++]:x==='0'?'0':\"\";}));\n    }\n    if(fmt.match(phone) !== null) {\n        o = write_num_flt(type, \"##########\", val);\n        return \"(\" + o.substr(0,3) + \") \" + o.substr(3, 3) + \"-\" + o.substr(6);\n    }\n    var oa = \"\";\n    if((r = fmt.match(/^([#0?]+)( ?)\\/( ?)([#0?]+)/)) !== null) {\n        ri = Math.min(r[4].length,7);\n        ff = frac(aval, Math.pow(10,ri)-1, false);\n        o = \"\" + sign;\n        oa = write_num(\"n\", r[1], ff[1]);\n        if(oa[oa.length-1] == \" \") oa = oa.substr(0,oa.length-1) + \"0\";\n        o += oa + r[2] + \"/\" + r[3];\n        oa = rpad_(ff[2],ri);\n        if(oa.length < r[4].length) oa = hashq(r[4].substr(r[4].length-oa.length)) + oa;\n        o += oa;\n        return o;\n    }\n    if((r = fmt.match(/^# ([#0?]+)( ?)\\/( ?)([#0?]+)/)) !== null) {\n        ri = Math.min(Math.max(r[1].length, r[4].length),7);\n        ff = frac(aval, Math.pow(10,ri)-1, true);\n        return sign + (ff[0]||(ff[1] ? \"\" : \"0\")) + \" \" + (ff[1] ? pad_(ff[1],ri) + r[2] + \"/\" + r[3] + rpad_(ff[2],ri): fill(\" \", 2*ri+1 + r[2].length + r[3].length));\n    }\n    if((r = fmt.match(/^[#0?]+$/)) !== null) {\n        o = pad0r(val, 0);\n        if(fmt.length <= o.length) return o;\n        return hashq(fmt.substr(0,fmt.length-o.length)) + o;\n    }\n  if((r = fmt.match(/^([#0?]+)\\.([#0]+)$/)) !== null) {\n        o = \"\" + val.toFixed(Math.min(r[2].length,10)).replace(/([^0])0+$/,\"$1\");\n        ri = o.indexOf(\".\");\n        var lres = fmt.indexOf(\".\") - ri, rres = fmt.length - o.length - lres;\n        return hashq(fmt.substr(0,lres) + o + fmt.substr(fmt.length-rres));\n    }\n    if((r = fmt.match(/^00,000\\.([#0]*0)$/)) !== null) {\n        ri = dec(val, r[1].length);\n        return val < 0 ? \"-\" + write_num_flt(type, fmt, -val) : commaify(flr(val)).replace(/^\\d,\\d{3}$/,\"0$&\").replace(/^\\d*$/,function($$) { return \"00,\" + ($$.length < 3 ? pad0(0,3-$$.length) : \"\") + $$; }) + \".\" + pad0(ri,r[1].length);\n    }\n    switch(fmt) {\n        case \"#,###\": var x = commaify(pad0r(aval,0)); return x !== \"0\" ? sign + x : \"\";\n        default:\n    }\n    throw new Error(\"unsupported format |\" + fmt + \"|\");\n}\nfunction write_num_cm2(type, fmt, val){\n    var idx = fmt.length - 1;\n    while(fmt.charCodeAt(idx-1) === 44) --idx;\n    return write_num(type, fmt.substr(0,idx), val / Math.pow(10,3*(fmt.length-idx)));\n}\nfunction write_num_pct2(type, fmt, val){\n    var sfmt = fmt.replace(pct1,\"\"), mul = fmt.length - sfmt.length;\n    return write_num(type, sfmt, val * Math.pow(10,2*mul)) + fill(\"%\",mul);\n}\nfunction write_num_exp2(fmt, val){\n    var o;\n    var idx = fmt.indexOf(\"E\") - fmt.indexOf(\".\") - 1;\n    if(fmt.match(/^#+0.0E\\+0$/)) {\n        var period = fmt.indexOf(\".\"); if(period === -1) period=fmt.indexOf('E');\n        var ee = Math.floor(Math.log(Math.abs(val))*Math.LOG10E)%period;\n        if(ee < 0) ee += period;\n        o = (val/Math.pow(10,ee)).toPrecision(idx+1+(period+ee)%period);\n        if(!o.match(/[Ee]/)) {\n            var fakee = Math.floor(Math.log(Math.abs(val))*Math.LOG10E);\n            if(o.indexOf(\".\") === -1) o = o[0] + \".\" + o.substr(1) + \"E+\" + (fakee - o.length+ee);\n            else o += \"E+\" + (fakee - ee);\n            o = o.replace(/\\+-/,\"-\");\n        }\n        o = o.replace(/^([+-]?)(\\d*)\\.(\\d*)[Ee]/,function($$,$1,$2,$3) { return $1 + $2 + $3.substr(0,(period+ee)%period) + \".\" + $3.substr(ee) + \"E\"; });\n    } else o = val.toExponential(idx);\n    if(fmt.match(/E\\+00$/) && o.match(/e[+-]\\d$/)) o = o.substr(0,o.length-1) + \"0\" + o[o.length-1];\n    if(fmt.match(/E\\-/) && o.match(/e\\+/)) o = o.replace(/e\\+/,\"e\");\n    return o.replace(\"e\",\"E\");\n}\nfunction write_num_int(type, fmt, val) {\n    if(type.charCodeAt(0) === 40 && !fmt.match(closeparen)) {\n        var ffmt = fmt.replace(/\\( */,\"\").replace(/ \\)/,\"\").replace(/\\)/,\"\");\n        if(val >= 0) return write_num_int('n', ffmt, val);\n        return '(' + write_num_int('n', ffmt, -val) + ')';\n    }\n    if(fmt.charCodeAt(fmt.length - 1) === 44) return write_num_cm2(type, fmt, val);\n    if(fmt.indexOf('%') !== -1) return write_num_pct2(type, fmt, val);\n    if(fmt.indexOf('E') !== -1) return write_num_exp2(fmt, val);\n    if(fmt.charCodeAt(0) === 36) return \"$\"+write_num_int(type,fmt.substr(fmt[1]==' '?2:1),val);\n    var o;\n    var r, ri, ff, aval = Math.abs(val), sign = val < 0 ? \"-\" : \"\";\n    if(fmt.match(/^00+$/)) return sign + pad0(aval,fmt.length);\n    if(fmt.match(/^[#?]+$/)) {\n        o = (\"\"+val); if(val === 0) o = \"\";\n        return o.length > fmt.length ? o : hashq(fmt.substr(0,fmt.length-o.length)) + o;\n    }\n    if((r = fmt.match(frac1)) !== null) return write_num_f2(r, aval, sign);\n    if(fmt.match(/^#+0+$/) !== null) return sign + pad0(aval,fmt.length - fmt.indexOf(\"0\"));\n    if((r = fmt.match(dec1)) !== null) {\n        o = (\"\"+val).replace(/^([^\\.]+)$/,\"$1.\"+r[1]).replace(/\\.$/,\".\"+r[1]).replace(/\\.(\\d*)$/,function($$, $1) { return \".\" + $1 + fill(\"0\", r[1].length-$1.length); });\n        return fmt.indexOf(\"0.\") !== -1 ? o : o.replace(/^0\\./,\".\");\n    }\n    fmt = fmt.replace(/^#+([0.])/, \"$1\");\n    if((r = fmt.match(/^(0*)\\.(#*)$/)) !== null) {\n        return sign + (\"\"+aval).replace(/\\.(\\d*[1-9])0*$/,\".$1\").replace(/^(-?\\d*)$/,\"$1.\").replace(/^0\\./,r[1].length?\"0.\":\".\");\n    }\n    if((r = fmt.match(/^#,##0(\\.?)$/)) !== null) return sign + commaify((\"\"+aval));\n    if((r = fmt.match(/^#,##0\\.([#0]*0)$/)) !== null) {\n        return val < 0 ? \"-\" + write_num_int(type, fmt, -val) : commaify((\"\"+val)) + \".\" + fill('0',r[1].length);\n    }\n    if((r = fmt.match(/^#,#*,#0/)) !== null) return write_num_int(type,fmt.replace(/^#,#*,/,\"\"),val);\n    if((r = fmt.match(/^([0#]+)(\\\\?-([0#]+))+$/)) !== null) {\n        o = _strrev(write_num_int(type, fmt.replace(/[\\\\-]/g,\"\"), val));\n        ri = 0;\n        return _strrev(_strrev(fmt.replace(/\\\\/g,\"\")).replace(/[0#]/g,function(x){return ri<o.length?o[ri++]:x==='0'?'0':\"\";}));\n    }\n    if(fmt.match(phone) !== null) {\n        o = write_num_int(type, \"##########\", val);\n        return \"(\" + o.substr(0,3) + \") \" + o.substr(3, 3) + \"-\" + o.substr(6);\n    }\n    var oa = \"\";\n    if((r = fmt.match(/^([#0?]+)( ?)\\/( ?)([#0?]+)/)) !== null) {\n        ri = Math.min(r[4].length,7);\n        ff = frac(aval, Math.pow(10,ri)-1, false);\n        o = \"\" + sign;\n        oa = write_num(\"n\", r[1], ff[1]);\n        if(oa[oa.length-1] == \" \") oa = oa.substr(0,oa.length-1) + \"0\";\n        o += oa + r[2] + \"/\" + r[3];\n        oa = rpad_(ff[2],ri);\n        if(oa.length < r[4].length) oa = hashq(r[4].substr(r[4].length-oa.length)) + oa;\n        o += oa;\n        return o;\n    }\n    if((r = fmt.match(/^# ([#0?]+)( ?)\\/( ?)([#0?]+)/)) !== null) {\n        ri = Math.min(Math.max(r[1].length, r[4].length),7);\n        ff = frac(aval, Math.pow(10,ri)-1, true);\n        return sign + (ff[0]||(ff[1] ? \"\" : \"0\")) + \" \" + (ff[1] ? pad_(ff[1],ri) + r[2] + \"/\" + r[3] + rpad_(ff[2],ri): fill(\" \", 2*ri+1 + r[2].length + r[3].length));\n    }\n    if((r = fmt.match(/^[#0?]+$/)) !== null) {\n        o = \"\" + val;\n        if(fmt.length <= o.length) return o;\n        return hashq(fmt.substr(0,fmt.length-o.length)) + o;\n    }\n    if((r = fmt.match(/^([#0]+)\\.([#0]+)$/)) !== null) {\n        o = \"\" + val.toFixed(Math.min(r[2].length,10)).replace(/([^0])0+$/,\"$1\");\n        ri = o.indexOf(\".\");\n        var lres = fmt.indexOf(\".\") - ri, rres = fmt.length - o.length - lres;\n        return hashq(fmt.substr(0,lres) + o + fmt.substr(fmt.length-rres));\n    }\n    if((r = fmt.match(/^00,000\\.([#0]*0)$/)) !== null) {\n        return val < 0 ? \"-\" + write_num_int(type, fmt, -val) : commaify(\"\"+val).replace(/^\\d,\\d{3}$/,\"0$&\").replace(/^\\d*$/,function($$) { return \"00,\" + ($$.length < 3 ? pad0(0,3-$$.length) : \"\") + $$; }) + \".\" + pad0(0,r[1].length);\n    }\n    switch(fmt) {\n        case \"#,###\": var x = commaify(\"\"+aval); return x !== \"0\" ? sign + x : \"\";\n        default:\n    }\n    throw new Error(\"unsupported format |\" + fmt + \"|\");\n}\nreturn function write_num(type, fmt, val) {\n    return (val|0) === val ? write_num_int(type, fmt, val) : write_num_flt(type, fmt, val);\n};})();\nfunction split_fmt(fmt) {\n    var out = [];\n    var in_str = false, cc;\n    for(var i = 0, j = 0; i < fmt.length; ++i) switch((cc=fmt.charCodeAt(i))) {\n        case 34: /* '\"' */\n            in_str = !in_str; break;\n        case 95: case 42: case 92: /* '_' '*' '\\\\' */\n            ++i; break;\n        case 59: /* ';' */\n            out[out.length] = fmt.substr(j,i-j);\n            j = i+1;\n    }\n    out[out.length] = fmt.substr(j);\n    if(in_str === true) throw new Error(\"Format |\" + fmt + \"| unterminated string \");\n    return out;\n}\nSSF._split = split_fmt;\nvar abstime = /\\[[HhMmSs]*\\]/;\nfunction eval_fmt(fmt, v, opts, flen) {\n    var out = [], o = \"\", i = 0, c = \"\", lst='t', q, dt, j, cc;\n    var hr='H';\n    /* Tokenize */\n    while(i < fmt.length) {\n        switch((c = fmt[i])) {\n            case 'G': /* General */\n                if(!isgeneral(fmt, i)) throw new Error('unrecognized character ' + c + ' in ' +fmt);\n                out[out.length] = {t:'G', v:'General'}; i+=7; break;\n            case '\"': /* Literal text */\n                for(o=\"\";(cc=fmt.charCodeAt(++i)) !== 34 && i < fmt.length;) o += String.fromCharCode(cc);\n                out[out.length] = {t:'t', v:o}; ++i; break;\n            case '\\\\': var w = fmt[++i], t = (w === \"(\" || w === \")\") ? w : 't';\n                out[out.length] = {t:t, v:w}; ++i; break;\n            case '_': out[out.length] = {t:'t', v:\" \"}; i+=2; break;\n            case '@': /* Text Placeholder */\n                out[out.length] = {t:'T', v:v}; ++i; break;\n            case 'B': case 'b':\n                if(fmt[i+1] === \"1\" || fmt[i+1] === \"2\") {\n          if(dt==null) { dt=parse_date_code(v, opts, fmt[i+1] === \"2\"); if(dt==null) return \"\"; }\n                    out[out.length] = {t:'X', v:fmt.substr(i,2)}; lst = c; i+=2; break;\n                }\n                /* falls through */\n            case 'M': case 'D': case 'Y': case 'H': case 'S': case 'E':\n                c = c.toLowerCase();\n                /* falls through */\n            case 'm': case 'd': case 'y': case 'h': case 's': case 'e': case 'g':\n                if(v < 0) return \"\";\n                if(dt==null) { dt=parse_date_code(v, opts); if(dt==null) return \"\"; }\n                o = c; while(++i<fmt.length && fmt[i].toLowerCase() === c) o+=c;\n                if(c === 'm' && lst.toLowerCase() === 'h') c = 'M'; /* m = minute */\n                if(c === 'h') c = hr;\n                out[out.length] = {t:c, v:o}; lst = c; break;\n            case 'A':\n                q={t:c, v:\"A\"};\n                if(dt==null) dt=parse_date_code(v, opts);\n        if(fmt.substr(i, 3) === \"A/P\") { if(dt!=null) q.v = dt.H >= 12 ? \"P\" : \"A\"; q.t = 'T'; hr='h';i+=3;}\n        else if(fmt.substr(i,5) === \"AM/PM\") { if(dt!=null) q.v = dt.H >= 12 ? \"PM\" : \"AM\"; q.t = 'T'; i+=5; hr='h'; }\n                else { q.t = \"t\"; ++i; }\n                if(dt==null && q.t === 'T') return \"\";\n                out[out.length] = q; lst = c; break;\n            case '[':\n                o = c;\n                while(fmt[i++] !== ']' && i < fmt.length) o += fmt[i];\n                if(o.substr(-1) !== ']') throw 'unterminated \"[\" block: |' + o + '|';\n                if(o.match(abstime)) {\n                    if(dt==null) { dt=parse_date_code(v, opts); if(dt==null) return \"\"; }\n                    out[out.length] = {t:'Z', v:o.toLowerCase()};\n                } else { o=\"\"; }\n                break;\n            /* Numbers */\n            case '.':\n                if(dt != null) {\n                    o = c; while((c=fmt[++i]) === \"0\") o += c;\n                    out[out.length] = {t:'s', v:o}; break;\n                }\n                /* falls through */\n            case '0': case '#':\n                o = c; while(\"0#?.,E+-%\".indexOf(c=fmt[++i]) > -1 || c=='\\\\' && fmt[i+1] == \"-\" && \"0#\".indexOf(fmt[i+2])>-1) o += c;\n                out[out.length] = {t:'n', v:o}; break;\n            case '?':\n                o = c; while(fmt[++i] === c) o+=c;\n                q={t:c, v:o}; out[out.length] = q; lst = c; break;\n            case '*': ++i; if(fmt[i] == ' ' || fmt[i] == '*') ++i; break; // **\n            case '(': case ')': out[out.length] = {t:(flen===1?'t':c), v:c}; ++i; break;\n            case '1': case '2': case '3': case '4': case '5': case '6': case '7': case '8': case '9':\n                o = c; while(\"0123456789\".indexOf(fmt[++i]) > -1) o+=fmt[i];\n                out[out.length] = {t:'D', v:o}; break;\n            case ' ': out[out.length] = {t:c, v:c}; ++i; break;\n            default:\n                if(\",$-+/():!^&'~{}<>=\u20acacfijklopqrtuvwxz\".indexOf(c) === -1) throw new Error('unrecognized character ' + c + ' in ' + fmt);\n                out[out.length] = {t:'t', v:c}; ++i; break;\n        }\n    }\n    var bt = 0, ss0 = 0, ssm;\n    for(i=out.length-1, lst='t'; i >= 0; --i) {\n        switch(out[i].t) {\n            case 'h': case 'H': out[i].t = hr; lst='h'; if(bt < 1) bt = 1; break;\n            case 's':\n                if((ssm=out[i].v.match(/\\.0+$/))) ss0=Math.max(ss0,ssm[0].length-1);\n                if(bt < 3) bt = 3;\n            /* falls through */\n            case 'd': case 'y': case 'M': case 'e': lst=out[i].t; break;\n            case 'm': if(lst === 's') { out[i].t = 'M'; if(bt < 2) bt = 2; } break;\n            case 'X': if(out[i].v === \"B2\");\n                break;\n            case 'Z':\n                if(bt < 1 && out[i].v.match(/[Hh]/)) bt = 1;\n                if(bt < 2 && out[i].v.match(/[Mm]/)) bt = 2;\n                if(bt < 3 && out[i].v.match(/[Ss]/)) bt = 3;\n        }\n    }\n    switch(bt) {\n        case 0: break;\n        case 1:\n            if(dt.u >= 0.5) { dt.u = 0; ++dt.S; }\n            if(dt.S >=  60) { dt.S = 0; ++dt.M; }\n            if(dt.M >=  60) { dt.M = 0; ++dt.H; }\n            break;\n        case 2:\n            if(dt.u >= 0.5) { dt.u = 0; ++dt.S; }\n            if(dt.S >=  60) { dt.S = 0; ++dt.M; }\n            break;\n    }\n    /* replace fields */\n    var nstr = \"\", jj;\n    for(i=0; i < out.length; ++i) {\n        switch(out[i].t) {\n            case 't': case 'T': case ' ': case 'D': break;\n            case 'X': out[i] = undefined; break;\n            case 'd': case 'm': case 'y': case 'h': case 'H': case 'M': case 's': case 'e': case 'b': case 'Z':\n                out[i].v = write_date(out[i].t.charCodeAt(0), out[i].v, dt, ss0);\n                out[i].t = 't'; break;\n            case 'n': case '(': case '?':\n                jj = i+1;\n                while(out[jj] != null && (\n                    (c=out[jj].t) === \"?\" || c === \"D\" ||\n                    (c === \" \" || c === \"t\") && out[jj+1] != null && (out[jj+1].t === '?' || out[jj+1].t === \"t\" && out[jj+1].v === '/') ||\n                    out[i].t === '(' && (c === ' ' || c === 'n' || c === ')') ||\n                    c === 't' && (out[jj].v === '/' || '$\u20ac'.indexOf(out[jj].v) > -1 || out[jj].v === ' ' && out[jj+1] != null && out[jj+1].t == '?')\n                )) {\n                    out[i].v += out[jj].v;\n                    out[jj] = undefined; ++jj;\n                }\n                nstr += out[i].v;\n                i = jj-1; break;\n            case 'G': out[i].t = 't'; out[i].v = general_fmt(v,opts); break;\n        }\n    }\n    var vv = \"\", myv, ostr;\n    if(nstr.length > 0) {\n        myv = (v<0&&nstr.charCodeAt(0) === 45 ? -v : v); /* '-' */\n        ostr = write_num(nstr.charCodeAt(0) === 40 ? '(' : 'n', nstr, myv); /* '(' */\n        jj=ostr.length-1;\n        var decpt = out.length;\n        for(i=0; i < out.length; ++i) if(out[i] != null && out[i].v.indexOf(\".\") > -1) { decpt = i; break; }\n        var lasti=out.length;\n        if(decpt === out.length && ostr.indexOf(\"E\") === -1) {\n            for(i=out.length-1; i>= 0;--i) {\n                if(out[i] == null || 'n?('.indexOf(out[i].t) === -1) continue;\n                if(jj>=out[i].v.length-1) { jj -= out[i].v.length; out[i].v = ostr.substr(jj+1, out[i].v.length); }\n                else if(jj < 0) out[i].v = \"\";\n                else { out[i].v = ostr.substr(0, jj+1); jj = -1; }\n                out[i].t = 't';\n                lasti = i;\n            }\n            if(jj>=0 && lasti<out.length) out[lasti].v = ostr.substr(0,jj+1) + out[lasti].v;\n        }\n        else if(decpt !== out.length && ostr.indexOf(\"E\") === -1) {\n            jj = ostr.indexOf(\".\")-1;\n            for(i=decpt; i>= 0; --i) {\n                if(out[i] == null || 'n?('.indexOf(out[i].t) === -1) continue;\n                j=out[i].v.indexOf(\".\")>-1&&i===decpt?out[i].v.indexOf(\".\")-1:out[i].v.length-1;\n                vv = out[i].v.substr(j+1);\n                for(; j>=0; --j) {\n                    if(jj>=0 && (out[i].v[j] === \"0\" || out[i].v[j] === \"#\")) vv = ostr[jj--] + vv;\n                }\n                out[i].v = vv;\n                out[i].t = 't';\n                lasti = i;\n            }\n            if(jj>=0 && lasti<out.length) out[lasti].v = ostr.substr(0,jj+1) + out[lasti].v;\n            jj = ostr.indexOf(\".\")+1;\n            for(i=decpt; i<out.length; ++i) {\n                if(out[i] == null || 'n?('.indexOf(out[i].t) === -1 && i !== decpt ) continue;\n                j=out[i].v.indexOf(\".\")>-1&&i===decpt?out[i].v.indexOf(\".\")+1:0;\n                vv = out[i].v.substr(0,j);\n                for(; j<out[i].v.length; ++j) {\n                    if(jj<ostr.length) vv += ostr[jj++];\n                }\n                out[i].v = vv;\n                out[i].t = 't';\n                lasti = i;\n            }\n        }\n    }\n    for(i=0; i<out.length; ++i) if(out[i] != null && 'n(?'.indexOf(out[i].t)>-1) {\n        myv = (flen >1 && v < 0 && i>0 && out[i-1].v === \"-\" ? -v:v);\n        out[i].v = write_num(out[i].t, out[i].v, myv);\n        out[i].t = 't';\n    }\n    var retval = \"\";\n    for(i=0; i !== out.length; ++i) if(out[i] != null) retval += out[i].v;\n    return retval;\n}\nSSF._eval = eval_fmt;\nvar cfregex = /\\[[=<>]/;\nvar cfregex2 = /\\[([=<>]*)(-?\\d+\\.?\\d*)\\]/;\nfunction chkcond(v, rr) {\n    if(rr == null) return false;\n    var thresh = parseFloat(rr[2]);\n    switch(rr[1]) {\n        case \"=\":  if(v == thresh) return true; break;\n        case \">\":  if(v >  thresh) return true; break;\n        case \"<\":  if(v <  thresh) return true; break;\n        case \"<>\": if(v != thresh) return true; break;\n        case \">=\": if(v >= thresh) return true; break;\n        case \"<=\": if(v <= thresh) return true; break;\n    }\n    return false;\n}\nfunction choose_fmt(f, v) {\n    var fmt = split_fmt(f);\n    var l = fmt.length, lat = fmt[l-1].indexOf(\"@\");\n    if(l<4 && lat>-1) --l;\n    if(fmt.length > 4) throw \"cannot find right format for |\" + fmt + \"|\";\n    if(typeof v !== \"number\") return [4, fmt.length === 4 || lat>-1?fmt[fmt.length-1]:\"@\"];\n    switch(fmt.length) {\n        case 1: fmt = lat>-1 ? [\"General\", \"General\", \"General\", fmt[0]] : [fmt[0], fmt[0], fmt[0], \"@\"]; break;\n        case 2: fmt = lat>-1 ? [fmt[0], fmt[0], fmt[0], fmt[1]] : [fmt[0], fmt[1], fmt[0], \"@\"]; break;\n        case 3: fmt = lat>-1 ? [fmt[0], fmt[1], fmt[0], fmt[2]] : [fmt[0], fmt[1], fmt[2], \"@\"]; break;\n        case 4: break;\n    }\n    var ff = v > 0 ? fmt[0] : v < 0 ? fmt[1] : fmt[2];\n    if(fmt[0].indexOf(\"[\") === -1 && fmt[1].indexOf(\"[\") === -1) return [l, ff];\n    if(fmt[0].match(cfregex) != null || fmt[1].match(cfregex) != null) {\n        var m1 = fmt[0].match(cfregex2);\n        var m2 = fmt[1].match(cfregex2);\n        return chkcond(v, m1) ? [l, fmt[0]] : chkcond(v, m2) ? [l, fmt[1]] : [l, fmt[m1 != null && m2 != null ? 2 : 1]];\n    }\n    return [l, ff];\n}\nfunction format(fmt,v,o) {\n    fixopts(o != null ? o : (o=[]));\n    var sfmt = \"\";\n    switch(typeof fmt) {\n        case \"string\": sfmt = fmt; break;\n        case \"number\": sfmt = (o.table != null ? o.table : table_fmt)[fmt]; break;\n    }\n    if(isgeneral(sfmt,0)) return general_fmt(v, o);\n    var f = choose_fmt(sfmt, v);\n    if(isgeneral(f[1])) return general_fmt(v, o);\n    if(v === true) v = \"TRUE\"; else if(v === false) v = \"FALSE\";\n    else if(v === \"\" || v == null) return \"\";\n    return eval_fmt(f[1], v, o, f[0]);\n}\nSSF._table = table_fmt;\nSSF.load = function load_entry(fmt, idx) { table_fmt[idx] = fmt; };\nSSF.format = format;\nSSF.get_table = function get_table() { return table_fmt; };\nSSF.load_table = function load_table(tbl) { for(var i=0; i!=0x0188; ++i) if(tbl[i] !== undefined) SSF.load(tbl[i], i); };\n};\nmake_ssf(SSF);\n/* map from xlml named formats to SSF TODO: localize */\nvar XLMLFormatMap = {\n    \"General Number\": \"General\",\n    \"General Date\": SSF._table[22],\n    \"Long Date\": \"dddd, mmmm dd, yyyy\",\n    \"Medium Date\": SSF._table[15],\n    \"Short Date\": SSF._table[14],\n    \"Long Time\": SSF._table[19],\n    \"Medium Time\": SSF._table[18],\n    \"Short Time\": SSF._table[20],\n    \"Currency\": '\"$\"#,##0.00_);[Red]\\\\(\"$\"#,##0.00\\\\)',\n    \"Fixed\": SSF._table[2],\n    \"Standard\": SSF._table[4],\n    \"Percent\": SSF._table[10],\n    \"Scientific\": SSF._table[11],\n    \"Yes/No\": '\"Yes\";\"Yes\";\"No\";@',\n    \"True/False\": '\"True\";\"True\";\"False\";@',\n    \"On/Off\": '\"Yes\";\"Yes\";\"No\";@'\n};\n\nvar DO_NOT_EXPORT_CFB = true;\n/* cfb.js (C) 2013-2014 SheetJS -- http://sheetjs.com */\n/* vim: set ts=2: */\n/*jshint eqnull:true */\n\n/* [MS-CFB] v20130118 */\nvar CFB = (function _CFB(){\nvar exports = {};\nexports.version = '0.10.2';\nfunction parse(file) {\nvar mver = 3; // major version\nvar ssz = 512; // sector size\nvar nmfs = 0; // number of mini FAT sectors\nvar ndfs = 0; // number of DIFAT sectors\nvar dir_start = 0; // first directory sector location\nvar minifat_start = 0; // first mini FAT sector location\nvar difat_start = 0; // first mini FAT sector location\n\nvar fat_addrs = []; // locations of FAT sectors\n\n/* [MS-CFB] 2.2 Compound File Header */\nvar blob = file.slice(0,512);\nprep_blob(blob, 0);\n\n/* major version */\nvar mv = check_get_mver(blob);\nmver = mv[0];\nswitch(mver) {\n    case 3: ssz = 512; break; case 4: ssz = 4096; break;\n    default: throw \"Major Version: Expected 3 or 4 saw \" + mver;\n}\n\n/* reprocess header */\nif(ssz !== 512) { blob = file.slice(0,ssz); prep_blob(blob, 28 /* blob.l */); }\n/* Save header for final object */\nvar header = file.slice(0,ssz);\n\ncheck_shifts(blob, mver);\n\n// Number of Directory Sectors\nvar nds = blob.read_shift(4, 'i');\nif(mver === 3 && nds !== 0) throw '# Directory Sectors: Expected 0 saw ' + nds;\n\n// Number of FAT Sectors\n//var nfs = blob.read_shift(4, 'i');\nblob.l += 4;\n\n// First Directory Sector Location\ndir_start = blob.read_shift(4, 'i');\n\n// Transaction Signature\nblob.l += 4;\n\n// Mini Stream Cutoff Size\nblob.chk('00100000', 'Mini Stream Cutoff Size: ');\n\n// First Mini FAT Sector Location\nminifat_start = blob.read_shift(4, 'i');\n\n// Number of Mini FAT Sectors\nnmfs = blob.read_shift(4, 'i');\n\n// First DIFAT sector location\ndifat_start = blob.read_shift(4, 'i');\n\n// Number of DIFAT Sectors\nndfs = blob.read_shift(4, 'i');\n\n// Grab FAT Sector Locations\nfor(var q, j = 0; j < 109; ++j) { /* 109 = (512 - blob.l)>>>2; */\n    q = blob.read_shift(4, 'i');\n    if(q<0) break;\n    fat_addrs[j] = q;\n}\n\n/** Break the file up into sectors */\nvar sectors = sectorify(file, ssz);\n\nsleuth_fat(difat_start, ndfs, sectors, ssz, fat_addrs);\n\n/** Chains */\nvar sector_list = make_sector_list(sectors, dir_start, fat_addrs, ssz);\n\nsector_list[dir_start].name = \"!Directory\";\nif(nmfs > 0 && minifat_start !== ENDOFCHAIN) sector_list[minifat_start].name = \"!MiniFAT\";\nsector_list[fat_addrs[0]].name = \"!FAT\";\nsector_list.fat_addrs = fat_addrs;\nsector_list.ssz = ssz;\n\n/* [MS-CFB] 2.6.1 Compound File Directory Entry */\nvar files = {}, Paths = [], FileIndex = [], FullPaths = [], FullPathDir = {};\nread_directory(dir_start, sector_list, sectors, Paths, nmfs, files, FileIndex);\n\nbuild_full_paths(FileIndex, FullPathDir, FullPaths, Paths);\n\nvar root_name = Paths.shift();\nPaths.root = root_name;\n\n/* [MS-CFB] 2.6.4 (Unicode 3.0.1 case conversion) */\nvar find_path = make_find_path(FullPaths, Paths, FileIndex, files, root_name);\n\nreturn {\n    raw: {header: header, sectors: sectors},\n    FileIndex: FileIndex,\n    FullPaths: FullPaths,\n    FullPathDir: FullPathDir,\n    find: find_path\n};\n} // parse\n\n/* [MS-CFB] 2.2 Compound File Header -- read up to major version */\nfunction check_get_mver(blob) {\n    // header signature 8\n    blob.chk(HEADER_SIGNATURE, 'Header Signature: ');\n\n    // clsid 16\n    blob.chk(HEADER_CLSID, 'CLSID: ');\n\n    // minor version 2\n    var mver = blob.read_shift(2, 'u');\n\n    return [blob.read_shift(2,'u'), mver];\n}\nfunction check_shifts(blob, mver) {\n    var shift = 0x09;\n\n    // Byte Order\n    blob.chk('feff', 'Byte Order: ');\n\n    // Sector Shift\n    switch((shift = blob.read_shift(2))) {\n        case 0x09: if(mver !== 3) throw 'MajorVersion/SectorShift Mismatch'; break;\n        case 0x0c: if(mver !== 4) throw 'MajorVersion/SectorShift Mismatch'; break;\n        default: throw 'Sector Shift: Expected 9 or 12 saw ' + shift;\n    }\n\n    // Mini Sector Shift\n    blob.chk('0600', 'Mini Sector Shift: ');\n\n    // Reserved\n    blob.chk('000000000000', 'Reserved: ');\n}\n\n/** Break the file up into sectors */\nfunction sectorify(file, ssz) {\n    var nsectors = Math.ceil(file.length/ssz)-1;\n    var sectors = new Array(nsectors);\n    for(var i=1; i < nsectors; ++i) sectors[i-1] = file.slice(i*ssz,(i+1)*ssz);\n    sectors[nsectors-1] = file.slice(nsectors*ssz);\n    return sectors;\n}\n\n/* [MS-CFB] 2.6.4 Red-Black Tree */\nfunction build_full_paths(FI, FPD, FP, Paths) {\n    var i = 0, L = 0, R = 0, C = 0, j = 0, pl = Paths.length;\n    var dad = new Array(pl), q = new Array(pl);\n\n    for(; i < pl; ++i) { dad[i]=q[i]=i; FP[i]=Paths[i]; }\n\n    for(; j < q.length; ++j) {\n        i = q[j];\n        L = FI[i].L; R = FI[i].R; C = FI[i].C;\n        if(dad[i] === i) {\n            if(L !== -1 /*NOSTREAM*/ && dad[L] !== L) dad[i] = dad[L];\n            if(R !== -1 && dad[R] !== R) dad[i] = dad[R];\n        }\n        if(C !== -1 /*NOSTREAM*/) dad[C] = i;\n        if(L !== -1) { dad[L] = dad[i]; q.push(L); }\n        if(R !== -1) { dad[R] = dad[i]; q.push(R); }\n    }\n    for(i=1; i !== pl; ++i) if(dad[i] === i) {\n        if(R !== -1 /*NOSTREAM*/ && dad[R] !== R) dad[i] = dad[R];\n        else if(L !== -1 && dad[L] !== L) dad[i] = dad[L];\n    }\n\n    for(i=1; i < pl; ++i) {\n        if(FI[i].type === 0 /* unknown */) continue;\n        j = dad[i];\n        if(j === 0) FP[i] = FP[0] + \"/\" + FP[i];\n        else while(j !== 0) {\n            FP[i] = FP[j] + \"/\" + FP[i];\n            j = dad[j];\n        }\n        dad[i] = 0;\n    }\n\n    FP[0] += \"/\";\n    for(i=1; i < pl; ++i) {\n        if(FI[i].type !== 2 /* stream */) FP[i] += \"/\";\n        FPD[FP[i]] = FI[i];\n    }\n}\n\n/* [MS-CFB] 2.6.4 */\nfunction make_find_path(FullPaths, Paths, FileIndex, files, root_name) {\n    var UCFullPaths = new Array(FullPaths.length);\n    var UCPaths = new Array(Paths.length), i;\n    for(i = 0; i < FullPaths.length; ++i) UCFullPaths[i] = FullPaths[i].toUpperCase().replace(chr0,'').replace(chr1,'!');\n    for(i = 0; i < Paths.length; ++i) UCPaths[i] = Paths[i].toUpperCase().replace(chr0,'').replace(chr1,'!');\n    return function find_path(path) {\n        var k;\n        if(path.charCodeAt(0) === 47 /* \"/\" */) { k=true; path = root_name + path; }\n        else k = path.indexOf(\"/\") !== -1;\n        var UCPath = path.toUpperCase().replace(chr0,'').replace(chr1,'!');\n        var w = k === true ? UCFullPaths.indexOf(UCPath) : UCPaths.indexOf(UCPath);\n        if(w === -1) return null;\n        return k === true ? FileIndex[w] : files[Paths[w]];\n    };\n}\n\n/** Chase down the rest of the DIFAT chain to build a comprehensive list\n    DIFAT chains by storing the next sector number as the last 32 bytes */\nfunction sleuth_fat(idx, cnt, sectors, ssz, fat_addrs) {\n    var q;\n    if(idx === ENDOFCHAIN) {\n        if(cnt !== 0) throw \"DIFAT chain shorter than expected\";\n    } else if(idx !== -1 /*FREESECT*/) {\n        var sector = sectors[idx], m = (ssz>>>2)-1;\n        for(var i = 0; i < m; ++i) {\n            if((q = __readInt32LE(sector,i*4)) === ENDOFCHAIN) break;\n            fat_addrs.push(q);\n        }\n        sleuth_fat(__readInt32LE(sector,ssz-4),cnt - 1, sectors, ssz, fat_addrs);\n    }\n}\n\n/** Follow the linked list of sectors for a given starting point */\nfunction get_sector_list(sectors, start, fat_addrs, ssz, chkd) {\n    var sl = sectors.length;\n    var buf, buf_chain;\n    if(!chkd) chkd = new Array(sl);\n    var modulus = ssz - 1, j, jj;\n    buf = [];\n    buf_chain = [];\n    for(j=start; j>=0;) {\n        chkd[j] = true;\n        buf[buf.length] = j;\n        buf_chain.push(sectors[j]);\n        var addr = fat_addrs[Math.floor(j*4/ssz)];\n        jj = ((j*4) & modulus);\n        if(ssz < 4 + jj) throw \"FAT boundary crossed: \" + j + \" 4 \"+ssz;\n        j = __readInt32LE(sectors[addr], jj);\n    }\n    return {nodes: buf, data:__toBuffer([buf_chain])};\n}\n\n/** Chase down the sector linked lists */\nfunction make_sector_list(sectors, dir_start, fat_addrs, ssz) {\n    var sl = sectors.length, sector_list = new Array(sl);\n    var chkd = new Array(sl), buf, buf_chain;\n    var modulus = ssz - 1, i, j, k, jj;\n    for(i=0; i < sl; ++i) {\n        buf = [];\n        k = (i + dir_start); if(k >= sl) k-=sl;\n        if(chkd[k] === true) continue;\n        buf_chain = [];\n        for(j=k; j>=0;) {\n            chkd[j] = true;\n            buf[buf.length] = j;\n            buf_chain.push(sectors[j]);\n            var addr = fat_addrs[Math.floor(j*4/ssz)];\n            jj = ((j*4) & modulus);\n            if(ssz < 4 + jj) throw \"FAT boundary crossed: \" + j + \" 4 \"+ssz;\n            j = __readInt32LE(sectors[addr], jj);\n        }\n        sector_list[k] = {nodes: buf, data:__toBuffer([buf_chain])};\n    }\n    return sector_list;\n}\n\n/* [MS-CFB] 2.6.1 Compound File Directory Entry */\nfunction read_directory(dir_start, sector_list, sectors, Paths, nmfs, files, FileIndex) {\n    var blob;\n    var minifat_store = 0, pl = (Paths.length?2:0);\n    var sector = sector_list[dir_start].data;\n    var i = 0, namelen = 0, name, o, ctime, mtime;\n    for(; i < sector.length; i+= 128) {\n        blob = sector.slice(i, i+128);\n        prep_blob(blob, 64);\n        namelen = blob.read_shift(2);\n        if(namelen === 0) continue;\n        name = __utf16le(blob,0,namelen-pl);\n        Paths.push(name);\n        o = {\n            name:  name,\n            type:  blob.read_shift(1),\n            color: blob.read_shift(1),\n            L:     blob.read_shift(4, 'i'),\n            R:     blob.read_shift(4, 'i'),\n            C:     blob.read_shift(4, 'i'),\n            clsid: blob.read_shift(16),\n            state: blob.read_shift(4, 'i')\n        };\n        ctime = blob.read_shift(2) + blob.read_shift(2) + blob.read_shift(2) + blob.read_shift(2);\n        if(ctime !== 0) {\n            o.ctime = ctime; o.ct = read_date(blob, blob.l-8);\n        }\n        mtime = blob.read_shift(2) + blob.read_shift(2) + blob.read_shift(2) + blob.read_shift(2);\n        if(mtime !== 0) {\n            o.mtime = mtime; o.mt = read_date(blob, blob.l-8);\n        }\n        o.start = blob.read_shift(4, 'i');\n        o.size = blob.read_shift(4, 'i');\n        if(o.type === 5) { /* root */\n            minifat_store = o.start;\n            if(nmfs > 0 && minifat_store !== ENDOFCHAIN) sector_list[minifat_store].name = \"!StreamData\";\n            /*minifat_size = o.size;*/\n        } else if(o.size >= 4096 /* MSCSZ */) {\n            o.storage = 'fat';\n            if(sector_list[o.start] === undefined) sector_list[o.start] = get_sector_list(sectors, o.start, sector_list.fat_addrs, sector_list.ssz);\n            sector_list[o.start].name = o.name;\n            o.content = sector_list[o.start].data.slice(0,o.size);\n            prep_blob(o.content, 0);\n        } else {\n            o.storage = 'minifat';\n            if(minifat_store !== ENDOFCHAIN && o.start !== ENDOFCHAIN) {\n                o.content = sector_list[minifat_store].data.slice(o.start*MSSZ,o.start*MSSZ+o.size);\n                prep_blob(o.content, 0);\n            }\n        }\n        files[name] = o;\n        FileIndex.push(o);\n    }\n}\n\nfunction read_date(blob, offset) {\n    return new Date(( ( (__readUInt32LE(blob,offset+4)/1e7)*Math.pow(2,32)+__readUInt32LE(blob,offset)/1e7 ) - 11644473600)*1000);\n}\n\nvar fs;\nfunction readFileSync(filename, options) {\n    if(fs === undefined) fs = require('fs');\n    return parse(fs.readFileSync(filename), options);\n}\n\nfunction readSync(blob, options) {\n    switch(options !== undefined && options.type !== undefined ? options.type : \"base64\") {\n        case \"file\": return readFileSync(blob, options);\n        case \"base64\": return parse(s2a(Base64.decode(blob)), options);\n        case \"binary\": return parse(s2a(blob), options);\n    }\n    return parse(blob);\n}\n\n/** CFB Constants */\nvar MSSZ = 64; /* Mini Sector Size = 1<<6 */\n//var MSCSZ = 4096; /* Mini Stream Cutoff Size */\n/* 2.1 Compound File Sector Numbers and Types */\nvar ENDOFCHAIN = -2;\n/* 2.2 Compound File Header */\nvar HEADER_SIGNATURE = 'd0cf11e0a1b11ae1';\nvar HEADER_CLSID = '00000000000000000000000000000000';\nvar consts = {\n    /* 2.1 Compund File Sector Numbers and Types */\n    MAXREGSECT: -6,\n    DIFSECT: -4,\n    FATSECT: -3,\n    ENDOFCHAIN: ENDOFCHAIN,\n    FREESECT: -1,\n    /* 2.2 Compound File Header */\n    HEADER_SIGNATURE: HEADER_SIGNATURE,\n    HEADER_MINOR_VERSION: '3e00',\n    MAXREGSID: -6,\n    NOSTREAM: -1,\n    HEADER_CLSID: HEADER_CLSID,\n    /* 2.6.1 Compound File Directory Entry */\n    EntryTypes: ['unknown','storage','stream','lockbytes','property','root']\n};\n\nexports.read = readSync;\nexports.parse = parse;\nexports.utils = {\n    ReadShift: ReadShift,\n    CheckField: CheckField,\n    prep_blob: prep_blob,\n    bconcat: bconcat,\n    consts: consts\n};\n\nreturn exports;\n})();\n\nif(typeof require !== 'undefined' && typeof module !== 'undefined' && typeof DO_NOT_EXPORT_CFB === 'undefined') { module.exports = CFB; }\nfunction isval(x) { return x !== undefined && x !== null; }\n\nfunction keys(o) { return Object.keys(o); }\n\nfunction evert_key(obj, key) {\n    var o = [], K = keys(obj);\n    for(var i = 0; i !== K.length; ++i) o[obj[K[i]][key]] = K[i];\n    return o;\n}\n\nfunction evert(obj) {\n    var o = [], K = keys(obj);\n    for(var i = 0; i !== K.length; ++i) o[obj[K[i]]] = K[i];\n    return o;\n}\n\nfunction evert_num(obj) {\n    var o = [], K = keys(obj);\n    for(var i = 0; i !== K.length; ++i) o[obj[K[i]]] = parseInt(K[i],10);\n    return o;\n}\n\nfunction evert_arr(obj) {\n    var o = [], K = keys(obj);\n    for(var i = 0; i !== K.length; ++i) {\n        if(o[obj[K[i]]] == null) o[obj[K[i]]] = [];\n        o[obj[K[i]]].push(K[i]);\n    }\n    return o;\n}\n\n/* TODO: date1904 logic */\nfunction datenum(v, date1904) {\n    if(date1904) v+=1462;\n    var epoch = Date.parse(v);\n    return (epoch + 2209161600000) / (24 * 60 * 60 * 1000);\n}\n\nfunction cc2str(arr) {\n    var o = \"\";\n    for(var i = 0; i != arr.length; ++i) o += String.fromCharCode(arr[i]);\n    return o;\n}\n\nfunction getdata(data) {\n    if(!data) return null;\n    if(data.name.substr(-4) === \".bin\") {\n        if(data.data) return char_codes(data.data);\n        if(data.asNodeBuffer && has_buf) return data.asNodeBuffer();\n        if(data._data && data._data.getContent) return Array.prototype.slice.call(data._data.getContent());\n    } else {\n        if(data.data) return data.name.substr(-4) !== \".bin\" ? debom_xml(data.data) : char_codes(data.data);\n        if(data.asNodeBuffer && has_buf) return debom_xml(data.asNodeBuffer().toString('binary'));\n        if(data.asBinary) return debom_xml(data.asBinary());\n        if(data._data && data._data.getContent) return debom_xml(cc2str(Array.prototype.slice.call(data._data.getContent(),0)));\n    }\n    return null;\n}\n\nfunction safegetzipfile(zip, file) {\n    var f = file; if(zip.files[f]) return zip.files[f];\n    f = file.toLowerCase(); if(zip.files[f]) return zip.files[f];\n    f = f.replace(/\\//g,'\\\\'); if(zip.files[f]) return zip.files[f];\n    return null;\n}\n\nfunction getzipfile(zip, file) {\n    var o = safegetzipfile(zip, file);\n    if(o == null) throw new Error(\"Cannot find file \" + file + \" in zip\");\n    return o;\n}\n\nfunction getzipdata(zip, file, safe) {\n    if(!safe) return getdata(getzipfile(zip, file));\n    if(!file) return null;\n    try { return getzipdata(zip, file); } catch(e) { return null; }\n}\n\nvar _fs, jszip;\nif(typeof JSZip !== 'undefined') jszip = JSZip;\nif (typeof exports !== 'undefined') {\n    if (typeof module !== 'undefined' && module.exports) {\n        if(has_buf && typeof jszip === 'undefined') jszip = require('js'+'zip');\n        if(typeof jszip === 'undefined') jszip = require('./js'+'zip').JSZip;\n        _fs = require('f'+'s');\n    }\n}\nvar attregexg=/([\\w:]+)=((?:\")([^\"]*)(?:\")|(?:')([^']*)(?:'))/g;\nvar tagregex=/<[^>]*>/g;\nvar nsregex=/<\\w*:/, nsregex2 = /<(\\/?)\\w+:/;\nfunction parsexmltag(tag, skip_root) {\n    var z = [];\n    var eq = 0, c = 0;\n    for(; eq !== tag.length; ++eq) if((c = tag.charCodeAt(eq)) === 32 || c === 10 || c === 13) break;\n    if(!skip_root) z[0] = tag.substr(0, eq);\n    if(eq === tag.length) return z;\n    var m = tag.match(attregexg), j=0, w=\"\", v=\"\", i=0, q=\"\", cc=\"\";\n    if(m) for(i = 0; i != m.length; ++i) {\n        cc = m[i];\n        for(c=0; c != cc.length; ++c) if(cc.charCodeAt(c) === 61) break;\n        q = cc.substr(0,c); v = cc.substring(c+2, cc.length-1);\n        for(j=0;j!=q.length;++j) if(q.charCodeAt(j) === 58) break;\n        if(j===q.length) z[q] = v;\n        else z[(j===5 && q.substr(0,5)===\"xmlns\"?\"xmlns\":\"\")+q.substr(j+1)] = v;\n    }\n    return z;\n}\nfunction strip_ns(x) { return x.replace(nsregex2, \"<$1\"); }\n\nvar encodings = {\n    '&quot;': '\"',\n    '&apos;': \"'\",\n    '&gt;': '>',\n    '&lt;': '<',\n    '&amp;': '&'\n};\nvar rencoding = evert(encodings);\nvar rencstr = \"&<>'\\\"\".split(\"\");\n\n// TODO: CP remap (need to read file version to determine OS)\nvar unescapexml = (function() {\n    var encregex = /&[a-z]*;/g, coderegex = /_x([\\da-fA-F]+)_/g;\n    return function unescapexml(text){\n        var s = text + '';\n        return s.replace(encregex, function($$) { return encodings[$$]; }).replace(coderegex,function(m,c) {return String.fromCharCode(parseInt(c,16));});\n    };\n})();\n\nvar decregex=/[&<>'\"]/g, charegex = /[\\u0000-\\u0008\\u000b-\\u001f]/g;\nfunction escapexml(text){\n    var s = text + '';\n    return s.replace(decregex, function(y) { return rencoding[y]; }).replace(charegex,function(s) { return \"_x\" + (\"000\"+s.charCodeAt(0).toString(16)).substr(-4) + \"_\";});\n}\n\n/* TODO: handle codepages */\nvar xlml_fixstr = (function() {\n    var entregex = /&#(\\d+);/g;\n    function entrepl($$,$1) { return String.fromCharCode(parseInt($1,10)); }\n    return function xlml_fixstr(str) { return str.replace(entregex,entrepl); };\n})();\n\nfunction parsexmlbool(value, tag) {\n    switch(value) {\n        case '1': case 'true': case 'TRUE': return true;\n        /* case '0': case 'false': case 'FALSE':*/\n        default: return false;\n    }\n}\n\nvar utf8read = function utf8reada(orig) {\n    var out = \"\", i = 0, c = 0, d = 0, e = 0, f = 0, w = 0;\n    while (i < orig.length) {\n        c = orig.charCodeAt(i++);\n        if (c < 128) { out += String.fromCharCode(c); continue; }\n        d = orig.charCodeAt(i++);\n        if (c>191 && c<224) { out += String.fromCharCode(((c & 31) << 6) | (d & 63)); continue; }\n        e = orig.charCodeAt(i++);\n        if (c < 240) { out += String.fromCharCode(((c & 15) << 12) | ((d & 63) << 6) | (e & 63)); continue; }\n        f = orig.charCodeAt(i++);\n        w = (((c & 7) << 18) | ((d & 63) << 12) | ((e & 63) << 6) | (f & 63))-65536;\n        out += String.fromCharCode(0xD800 + ((w>>>10)&1023));\n        out += String.fromCharCode(0xDC00 + (w&1023));\n    }\n    return out;\n};\n\n\nif(has_buf) {\n    var utf8readb = function utf8readb(data) {\n        var out = new Buffer(2*data.length), w, i, j = 1, k = 0, ww=0, c;\n        for(i = 0; i < data.length; i+=j) {\n            j = 1;\n            if((c=data.charCodeAt(i)) < 128) w = c;\n            else if(c < 224) { w = (c&31)*64+(data.charCodeAt(i+1)&63); j=2; }\n            else if(c < 240) { w=(c&15)*4096+(data.charCodeAt(i+1)&63)*64+(data.charCodeAt(i+2)&63); j=3; }\n            else { j = 4;\n                w = (c & 7)*262144+(data.charCodeAt(i+1)&63)*4096+(data.charCodeAt(i+2)&63)*64+(data.charCodeAt(i+3)&63);\n                w -= 65536; ww = 0xD800 + ((w>>>10)&1023); w = 0xDC00 + (w&1023);\n            }\n            if(ww !== 0) { out[k++] = ww&255; out[k++] = ww>>>8; ww = 0; }\n            out[k++] = w%256; out[k++] = w>>>8;\n        }\n        out.length = k;\n        return out.toString('ucs2');\n    };\n    var corpus = \"foo bar baz\\u00e2\\u0098\\u0083\\u00f0\\u009f\\u008d\\u00a3\";\n    if(utf8read(corpus) == utf8readb(corpus)) utf8read = utf8readb;\n    var utf8readc = function utf8readc(data) { return Buffer(data, 'binary').toString('utf8'); };\n    if(utf8read(corpus) == utf8readc(corpus)) utf8read = utf8readc;\n}\n\n// matches <foo>...</foo> extracts content\nvar matchtag = (function() {\n    var mtcache = {};\n    return function matchtag(f,g) {\n        var t = f+\"|\"+g;\n        if(mtcache[t] !== undefined) return mtcache[t];\n        return (mtcache[t] = new RegExp('<(?:\\\\w+:)?'+f+'(?: xml:space=\"preserve\")?(?:[^>]*)>([^\\u2603]*)</(?:\\\\w+:)?'+f+'>',(g||\"\")));\n    };\n})();\n\nvar vtregex = (function(){ var vt_cache = {};\n    return function vt_regex(bt) {\n        if(vt_cache[bt] !== undefined) return vt_cache[bt];\n        return (vt_cache[bt] = new RegExp(\"<vt:\" + bt + \">(.*?)</vt:\" + bt + \">\", 'g') );\n};})();\nvar vtvregex = /<\\/?vt:variant>/g, vtmregex = /<vt:([^>]*)>(.*)</;\nfunction parseVector(data) {\n    var h = parsexmltag(data);\n\n    var matches = data.match(vtregex(h.baseType))||[];\n    if(matches.length != h.size) throw \"unexpected vector length \" + matches.length + \" != \" + h.size;\n    var res = [];\n    matches.forEach(function(x) {\n        var v = x.replace(vtvregex,\"\").match(vtmregex);\n        res.push({v:v[2], t:v[1]});\n    });\n    return res;\n}\n\nvar wtregex = /(^\\s|\\s$|\\n)/;\nfunction writetag(f,g) {return '<' + f + (g.match(wtregex)?' xml:space=\"preserve\"' : \"\") + '>' + g + '</' + f + '>';}\n\nfunction wxt_helper(h) { return keys(h).map(function(k) { return \" \" + k + '=\"' + h[k] + '\"';}).join(\"\"); }\nfunction writextag(f,g,h) { return '<' + f + (isval(h) ? wxt_helper(h) : \"\") + (isval(g) ? (g.match(wtregex)?' xml:space=\"preserve\"' : \"\") + '>' + g + '</' + f : \"/\") + '>';}\n\nfunction write_w3cdtf(d, t) { try { return d.toISOString().replace(/\\.\\d*/,\"\"); } catch(e) { if(t) throw e; } }\n\nfunction write_vt(s) {\n    switch(typeof s) {\n        case 'string': return writextag('vt:lpwstr', s);\n        case 'number': return writextag((s|0)==s?'vt:i4':'vt:r8', String(s));\n        case 'boolean': return writextag('vt:bool',s?'true':'false');\n    }\n    if(s instanceof Date) return writextag('vt:filetime', write_w3cdtf(s));\n    throw new Error(\"Unable to serialize \" + s);\n}\n\nvar XML_HEADER = '<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\\r\\n';\nvar XMLNS = {\n    'dc': 'http://purl.org/dc/elements/1.1/',\n    'dcterms': 'http://purl.org/dc/terms/',\n    'dcmitype': 'http://purl.org/dc/dcmitype/',\n    'mx': 'http://schemas.microsoft.com/office/mac/excel/2008/main',\n    'r': 'http://schemas.openxmlformats.org/officeDocument/2006/relationships',\n    'sjs': 'http://schemas.openxmlformats.org/package/2006/sheetjs/core-properties',\n    'vt': 'http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes',\n    'xsi': 'http://www.w3.org/2001/XMLSchema-instance',\n    'xsd': 'http://www.w3.org/2001/XMLSchema'\n};\n\nXMLNS.main = [\n    'http://schemas.openxmlformats.org/spreadsheetml/2006/main',\n    'http://purl.oclc.org/ooxml/spreadsheetml/main',\n    'http://schemas.microsoft.com/office/excel/2006/main',\n    'http://schemas.microsoft.com/office/excel/2006/2'\n];\n\nfunction readIEEE754(buf, idx, isLE, nl, ml) {\n    if(isLE === undefined) isLE = true;\n    if(!nl) nl = 8;\n    if(!ml && nl === 8) ml = 52;\n    var e, m, el = nl * 8 - ml - 1, eMax = (1 << el) - 1, eBias = eMax >> 1;\n    var bits = -7, d = isLE ? -1 : 1, i = isLE ? (nl - 1) : 0, s = buf[idx + i];\n\n    i += d;\n    e = s & ((1 << (-bits)) - 1); s >>>= (-bits); bits += el;\n    for (; bits > 0; e = e * 256 + buf[idx + i], i += d, bits -= 8);\n    m = e & ((1 << (-bits)) - 1); e >>>= (-bits); bits += ml;\n    for (; bits > 0; m = m * 256 + buf[idx + i], i += d, bits -= 8);\n    if (e === eMax) return m ? NaN : ((s ? -1 : 1) * Infinity);\n    else if (e === 0) e = 1 - eBias;\n    else { m = m + Math.pow(2, ml); e = e - eBias; }\n    return (s ? -1 : 1) * m * Math.pow(2, e - ml);\n}\n\nvar __toBuffer, ___toBuffer;\n__toBuffer = ___toBuffer = function toBuffer_(bufs) { var x = []; for(var i = 0; i < bufs[0].length; ++i) { x.push.apply(x, bufs[0][i]); } return x; };\nvar __utf16le, ___utf16le;\n__utf16le = ___utf16le = function utf16le_(b,s,e) { var ss=[]; for(var i=s; i<e; i+=2) ss.push(String.fromCharCode(__readUInt16LE(b,i))); return ss.join(\"\"); };\nvar __hexlify, ___hexlify;\n__hexlify = ___hexlify = function hexlify_(b,s,l) { return b.slice(s,(s+l)).map(function(x){return (x<16?\"0\":\"\") + x.toString(16);}).join(\"\"); };\nvar __utf8, ___utf8;\n__utf8 = ___utf8 = function(b,s,e) { var ss=[]; for(var i=s; i<e; i++) ss.push(String.fromCharCode(__readUInt8(b,i))); return ss.join(\"\"); };\nvar __lpstr, ___lpstr;\n__lpstr = ___lpstr = function lpstr_(b,i) { var len = __readUInt32LE(b,i); return len > 0 ? __utf8(b, i+4,i+4+len-1) : \"\";};\nvar __lpwstr, ___lpwstr;\n__lpwstr = ___lpwstr = function lpwstr_(b,i) { var len = 2*__readUInt32LE(b,i); return len > 0 ? __utf8(b, i+4,i+4+len-1) : \"\";};\nvar __double, ___double;\n__double = ___double = function(b, idx) { return readIEEE754(b, idx);};\n\nvar is_buf = function is_buf_a(a) { return Array.isArray(a); };\nif(has_buf) {\n    __utf16le = function utf16le_b(b,s,e) { if(!Buffer.isBuffer(b)) return ___utf16le(b,s,e); return b.toString('utf16le',s,e); };\n    __hexlify = function(b,s,l) { return Buffer.isBuffer(b) ? b.toString('hex',s,s+l) : ___hexlify(b,s,l); };\n    __lpstr = function lpstr_b(b,i) { if(!Buffer.isBuffer(b)) return ___lpstr(b, i); var len = b.readUInt32LE(i); return len > 0 ? b.toString('utf8',i+4,i+4+len-1) : \"\";};\n    __lpwstr = function lpwstr_b(b,i) { if(!Buffer.isBuffer(b)) return ___lpwstr(b, i); var len = 2*b.readUInt32LE(i); return b.toString('utf16le',i+4,i+4+len-1);};\n    __utf8 = function utf8_b(s,e) { return this.toString('utf8',s,e); };\n    __toBuffer = function(bufs) { return (bufs[0].length > 0 && Buffer.isBuffer(bufs[0][0])) ? Buffer.concat(bufs[0]) : ___toBuffer(bufs);};\n    bconcat = function(bufs) { return Buffer.isBuffer(bufs[0]) ? Buffer.concat(bufs) : [].concat.apply([], bufs); };\n    __double = function double_(b,i) { if(Buffer.isBuffer(b)) return b.readDoubleLE(i); return ___double(b,i); };\n    is_buf = function is_buf_b(a) { return Buffer.isBuffer(a) || Array.isArray(a); };\n}\n\n/* from js-xls */\nif(typeof cptable !== 'undefined') {\n    __utf16le = function(b,s,e) { return cptable.utils.decode(1200, b.slice(s,e)); };\n    __utf8 = function(b,s,e) { return cptable.utils.decode(65001, b.slice(s,e)); };\n    __lpstr = function(b,i) { var len = __readUInt32LE(b,i); return len > 0 ? cptable.utils.decode(current_codepage, b.slice(i+4, i+4+len-1)) : \"\";};\n    __lpwstr = function(b,i) { var len = 2*__readUInt32LE(b,i); return len > 0 ? cptable.utils.decode(1200, b.slice(i+4,i+4+len-1)) : \"\";};\n}\n\nvar __readUInt8 = function(b, idx) { return b[idx]; };\nvar __readUInt16LE = function(b, idx) { return b[idx+1]*(1<<8)+b[idx]; };\nvar __readInt16LE = function(b, idx) { var u = b[idx+1]*(1<<8)+b[idx]; return (u < 0x8000) ? u : (0xffff - u + 1) * -1; };\nvar __readUInt32LE = function(b, idx) { return b[idx+3]*(1<<24)+(b[idx+2]<<16)+(b[idx+1]<<8)+b[idx]; };\nvar __readInt32LE = function(b, idx) { return (b[idx+3]<<24)|(b[idx+2]<<16)|(b[idx+1]<<8)|b[idx]; };\n\nvar ___unhexlify = function(s) { return s.match(/../g).map(function(x) { return parseInt(x,16);}); };\nvar __unhexlify = typeof Buffer !== \"undefined\" ? function(s) { return Buffer.isBuffer(s) ? new Buffer(s, 'hex') : ___unhexlify(s); } : ___unhexlify;\n\nfunction ReadShift(size, t) {\n    var o=\"\", oI, oR, oo=[], w, vv, i, loc;\n    switch(t) {\n        case 'dbcs':\n            loc = this.l;\n            if(has_buf && Buffer.isBuffer(this)) o = this.slice(this.l, this.l+2*size).toString(\"utf16le\");\n            else for(i = 0; i != size; ++i) { o+=String.fromCharCode(__readUInt16LE(this, loc)); loc+=2; }\n            size *= 2;\n            break;\n\n        case 'utf8': o = __utf8(this, this.l, this.l + size); break;\n        case 'utf16le': size *= 2; o = __utf16le(this, this.l, this.l + size); break;\n\n        /* [MS-OLEDS] 2.1.4 LengthPrefixedAnsiString */\n        case 'lpstr': o = __lpstr(this, this.l); size = 5 + o.length; break;\n        /* [MS-OLEDS] 2.1.5 LengthPrefixedUnicodeString */\n        case 'lpwstr': o = __lpwstr(this, this.l); size = 5 + o.length; if(o[o.length-1] == '\\u0000') size += 2; break;\n\n        case 'cstr': size = 0; o = \"\";\n            while((w=__readUInt8(this, this.l + size++))!==0) oo.push(_getchar(w));\n            o = oo.join(\"\"); break;\n        case 'wstr': size = 0; o = \"\";\n            while((w=__readUInt16LE(this,this.l +size))!==0){oo.push(_getchar(w));size+=2;}\n            size+=2; o = oo.join(\"\"); break;\n\n        /* sbcs and dbcs support continue records in the SST way TODO codepages */\n        case 'dbcs-cont': o = \"\"; loc = this.l;\n            for(i = 0; i != size; ++i) {\n                if(this.lens && this.lens.indexOf(loc) !== -1) {\n                    w = __readUInt8(this, loc);\n                    this.l = loc + 1;\n                    vv = ReadShift.call(this, size-i, w ? 'dbcs-cont' : 'sbcs-cont');\n                    return oo.join(\"\") + vv;\n                }\n                oo.push(_getchar(__readUInt16LE(this, loc)));\n                loc+=2;\n            } o = oo.join(\"\"); size *= 2; break;\n\n        case 'sbcs-cont': o = \"\"; loc = this.l;\n            for(i = 0; i != size; ++i) {\n                if(this.lens && this.lens.indexOf(loc) !== -1) {\n                    w = __readUInt8(this, loc);\n                    this.l = loc + 1;\n                    vv = ReadShift.call(this, size-i, w ? 'dbcs-cont' : 'sbcs-cont');\n                    return oo.join(\"\") + vv;\n                }\n                oo.push(_getchar(__readUInt8(this, loc)));\n                loc+=1;\n            } o = oo.join(\"\"); break;\n\n        default:\n    switch(size) {\n        case 1: oI = __readUInt8(this, this.l); this.l++; return oI;\n        case 2: oI = (t === 'i' ? __readInt16LE : __readUInt16LE)(this, this.l); this.l += 2; return oI;\n        case 4:\n            if(t === 'i' || (this[this.l+3] & 0x80)===0) { oI = __readInt32LE(this, this.l); this.l += 4; return oI; }\n            else { oR = __readUInt32LE(this, this.l); this.l += 4; return oR; } break;\n        case 8: if(t === 'f') { oR = __double(this, this.l); this.l += 8; return oR; }\n        /* falls through */\n        case 16: o = __hexlify(this, this.l, size); break;\n    }}\n    this.l+=size; return o;\n}\n\nfunction WriteShift(t, val, f) {\n    var size, i;\n    if(f === 'dbcs') {\n        for(i = 0; i != val.length; ++i) this.writeUInt16LE(val.charCodeAt(i), this.l + 2 * i);\n        size = 2 * val.length;\n    } else switch(t) {\n        case  1: size = 1; this[this.l] = val&255; break;\n        case  3: size = 3; this[this.l+2] = val & 255; val >>>= 8; this[this.l+1] = val&255; val >>>= 8; this[this.l] = val&255; break;\n        case  4: size = 4; this.writeUInt32LE(val, this.l); break;\n        case  8: size = 8; if(f === 'f') { this.writeDoubleLE(val, this.l); break; }\n        /* falls through */\n        case 16: break;\n        case -4: size = 4; this.writeInt32LE(val, this.l); break;\n    }\n    this.l += size; return this;\n}\n\nfunction CheckField(hexstr, fld) {\n    var m = __hexlify(this,this.l,hexstr.length>>1);\n    if(m !== hexstr) throw fld + 'Expected ' + hexstr + ' saw ' + m;\n    this.l += hexstr.length>>1;\n}\n\nfunction prep_blob(blob, pos) {\n    blob.l = pos;\n    blob.read_shift = ReadShift;\n    blob.chk = CheckField;\n    blob.write_shift = WriteShift;\n}\n\nfunction parsenoop(blob, length) { blob.l += length; }\n\nfunction writenoop(blob, length) { blob.l += length; }\n\nfunction new_buf(sz) {\n    var o = new_raw_buf(sz);\n    prep_blob(o, 0);\n    return o;\n}\n\n/* [MS-XLSB] 2.1.4 Record */\nfunction recordhopper(data, cb, opts) {\n    var tmpbyte, cntbyte, length;\n    prep_blob(data, data.l || 0);\n    while(data.l < data.length) {\n        var RT = data.read_shift(1);\n        if(RT & 0x80) RT = (RT & 0x7F) + ((data.read_shift(1) & 0x7F)<<7);\n        var R = XLSBRecordEnum[RT] || XLSBRecordEnum[0xFFFF];\n        tmpbyte = data.read_shift(1);\n        length = tmpbyte & 0x7F;\n        for(cntbyte = 1; cntbyte <4 && (tmpbyte & 0x80); ++cntbyte) length += ((tmpbyte = data.read_shift(1)) & 0x7F)<<(7*cntbyte);\n        var d = R.f(data, length, opts);\n        if(cb(d, R, RT)) return;\n    }\n}\n\n/* control buffer usage for fixed-length buffers */\nfunction buf_array() {\n    var bufs = [], blksz = 2048;\n    var newblk = function ba_newblk(sz) {\n        var o = new_buf(sz);\n        prep_blob(o, 0);\n        return o;\n    };\n\n    var curbuf = newblk(blksz);\n\n    var endbuf = function ba_endbuf() {\n        curbuf.length = curbuf.l;\n        if(curbuf.length > 0) bufs.push(curbuf);\n        curbuf = null;\n    };\n\n    var next = function ba_next(sz) {\n        if(sz < curbuf.length - curbuf.l) return curbuf;\n        endbuf();\n        return (curbuf = newblk(Math.max(sz+1, blksz)));\n    };\n\n    var end = function ba_end() {\n        endbuf();\n        return __toBuffer([bufs]);\n    };\n\n    var push = function ba_push(buf) { endbuf(); curbuf = buf; next(blksz); };\n\n    return { next:next, push:push, end:end, _bufs:bufs };\n}\n\nfunction write_record(ba, type, payload, length) {\n    var t = evert_RE[type], l;\n    if(!length) length = XLSBRecordEnum[t].p || (payload||[]).length || 0;\n    l = 1 + (t >= 0x80 ? 1 : 0) + 1 + length;\n    if(length >= 0x80) ++l; if(length >= 0x4000) ++l; if(length >= 0x200000) ++l;\n    var o = ba.next(l);\n    if(t <= 0x7F) o.write_shift(1, t);\n    else {\n        o.write_shift(1, (t & 0x7F) + 0x80);\n        o.write_shift(1, (t >> 7));\n    }\n    for(var i = 0; i != 4; ++i) {\n        if(length >= 0x80) { o.write_shift(1, (length & 0x7F)+0x80); length >>= 7; }\n        else { o.write_shift(1, length); break; }\n    }\n    if(length > 0 && is_buf(payload)) ba.push(payload);\n}\n/* XLS ranges enforced */\nfunction shift_cell_xls(cell, tgt) {\n    if(tgt.s) {\n        if(cell.cRel) cell.c += tgt.s.c;\n        if(cell.rRel) cell.r += tgt.s.r;\n    } else {\n        cell.c += tgt.c;\n        cell.r += tgt.r;\n    }\n    cell.cRel = cell.rRel = 0;\n    while(cell.c >= 0x100) cell.c -= 0x100;\n    while(cell.r >= 0x10000) cell.r -= 0x10000;\n    return cell;\n}\n\nfunction shift_range_xls(cell, range) {\n    cell.s = shift_cell_xls(cell.s, range.s);\n    cell.e = shift_cell_xls(cell.e, range.s);\n    return cell;\n}\n\nvar OFFCRYPTO = {};\nvar make_offcrypto = function(O, _crypto) {\n    var crypto;\n    if(typeof _crypto !== 'undefined') crypto = _crypto;\n    else if(typeof require !== 'undefined') {\n        try { crypto = require('cry'+'pto'); }\n        catch(e) { crypto = null; }\n    }\n\n    O.rc4 = function(key, data) {\n        var S = new Array(256);\n        var c = 0, i = 0, j = 0, t = 0;\n        for(i = 0; i != 256; ++i) S[i] = i;\n        for(i = 0; i != 256; ++i) {\n            j = (j + S[i] + (key[i%key.length]).charCodeAt(0))&255;\n            t = S[i]; S[i] = S[j]; S[j] = t;\n        }\n        i = j = 0; out = Buffer(data.length);\n        for(c = 0; c != data.length; ++c) {\n            i = (i + 1)&255;\n            j = (j + S[i])%256;\n            t = S[i]; S[i] = S[j]; S[j] = t;\n            out[c] = (data[c] ^ S[(S[i]+S[j])&255]);\n        }\n        return out;\n    };\n\n    if(crypto) {\n        O.md5 = function(hex) { return crypto.createHash('md5').update(hex).digest('hex'); };\n    } else {\n        O.md5 = function(hex) { throw \"unimplemented\"; };\n    }\n};\nmake_offcrypto(OFFCRYPTO, typeof crypto !== \"undefined\" ? crypto : undefined);\n\n\n/* [MS-XLSB] 2.5.143 */\nfunction parse_StrRun(data, length) {\n    return { ich: data.read_shift(2), ifnt: data.read_shift(2) };\n}\n\n/* [MS-XLSB] 2.1.7.121 */\nfunction parse_RichStr(data, length) {\n    var start = data.l;\n    var flags = data.read_shift(1);\n    var str = parse_XLWideString(data);\n    var rgsStrRun = [];\n    var z = { t: str, h: str };\n    if((flags & 1) !== 0) { /* fRichStr */\n        /* TODO: formatted string */\n        var dwSizeStrRun = data.read_shift(4);\n        for(var i = 0; i != dwSizeStrRun; ++i) rgsStrRun.push(parse_StrRun(data));\n        z.r = rgsStrRun;\n    }\n    else z.r = \"<t>\" + escapexml(str) + \"</t>\";\n    if((flags & 2) !== 0) { /* fExtStr */\n        /* TODO: phonetic string */\n    }\n    data.l = start + length;\n    return z;\n}\nfunction write_RichStr(str, o) {\n    /* TODO: formatted string */\n    if(o == null) o = new_buf(5+2*str.t.length);\n    o.write_shift(1,0);\n    write_XLWideString(str.t, o);\n    return o;\n}\n\n/* [MS-XLSB] 2.5.9 */\nfunction parse_XLSBCell(data) {\n    var col = data.read_shift(4);\n    var iStyleRef = data.read_shift(2);\n    iStyleRef += data.read_shift(1) <<16;\n    var fPhShow = data.read_shift(1);\n    return { c:col, iStyleRef: iStyleRef };\n}\nfunction write_XLSBCell(cell, o) {\n    if(o == null) o = new_buf(8);\n    o.write_shift(-4, cell.c);\n    o.write_shift(3, cell.iStyleRef === undefined ? cell.iStyleRef : cell.s);\n    o.write_shift(1, 0); /* fPhShow */\n    return o;\n}\n\n\n/* [MS-XLSB] 2.5.21 */\nfunction parse_XLSBCodeName (data, length) { return parse_XLWideString(data, length); }\n\n/* [MS-XLSB] 2.5.166 */\nfunction parse_XLNullableWideString(data) {\n    var cchCharacters = data.read_shift(4);\n    return cchCharacters === 0 || cchCharacters === 0xFFFFFFFF ? \"\" : data.read_shift(cchCharacters, 'dbcs');\n}\nfunction write_XLNullableWideString(data, o) {\n    if(!o) o = new_buf(127);\n    o.write_shift(4, data.length > 0 ? data.length : 0xFFFFFFFF);\n    if(data.length > 0) o.write_shift(0, data, 'dbcs');\n    return o;\n}\n\n/* [MS-XLSB] 2.5.168 */\nfunction parse_XLWideString(data) {\n    var cchCharacters = data.read_shift(4);\n    return cchCharacters === 0 ? \"\" : data.read_shift(cchCharacters, 'dbcs');\n}\nfunction write_XLWideString(data, o) {\n    if(o == null) o = new_buf(4+2*data.length);\n    o.write_shift(4, data.length);\n    if(data.length > 0) o.write_shift(0, data, 'dbcs');\n    return o;\n}\n\n/* [MS-XLSB] 2.5.114 */\nvar parse_RelID = parse_XLNullableWideString;\nvar write_RelID = write_XLNullableWideString;\n\n\n/* [MS-XLSB] 2.5.122 */\n/* [MS-XLS] 2.5.217 */\nfunction parse_RkNumber(data) {\n    var b = data.slice(data.l, data.l+4);\n    var fX100 = b[0] & 1, fInt = b[0] & 2;\n    data.l+=4;\n    b[0] &= 0xFC; // b[0] &= ~3;\n    var RK = fInt === 0 ? __double([0,0,0,0,b[0],b[1],b[2],b[3]],0) : __readInt32LE(b,0)>>2;\n    return fX100 ? RK/100 : RK;\n}\n\n/* [MS-XLSB] 2.5.153 */\nfunction parse_UncheckedRfX(data) {\n    var cell = {s: {}, e: {}};\n    cell.s.r = data.read_shift(4);\n    cell.e.r = data.read_shift(4);\n    cell.s.c = data.read_shift(4);\n    cell.e.c = data.read_shift(4);\n    return cell;\n}\n\nfunction write_UncheckedRfX(r, o) {\n    if(!o) o = new_buf(16);\n    o.write_shift(4, r.s.r);\n    o.write_shift(4, r.e.r);\n    o.write_shift(4, r.s.c);\n    o.write_shift(4, r.e.c);\n    return o;\n}\n\n/* [MS-XLSB] 2.5.171 */\n/* [MS-XLS] 2.5.342 */\nfunction parse_Xnum(data, length) { return data.read_shift(8, 'f'); }\nfunction write_Xnum(data, o) { return (o || new_buf(8)).write_shift(8, 'f', data); }\n\n/* [MS-XLSB] 2.5.198.2 */\nvar BErr = {\n    0x00: \"#NULL!\",\n    0x07: \"#DIV/0!\",\n    0x0F: \"#VALUE!\",\n    0x17: \"#REF!\",\n    0x1D: \"#NAME?\",\n    0x24: \"#NUM!\",\n    0x2A: \"#N/A\",\n    0x2B: \"#GETTING_DATA\",\n    0xFF: \"#WTF?\"\n};\nvar RBErr = evert_num(BErr);\n\n/* [MS-XLSB] 2.4.321 BrtColor */\nfunction parse_BrtColor(data, length) {\n    var out = {};\n    var d = data.read_shift(1);\n    out.fValidRGB = d & 1;\n    out.xColorType = d >>> 1;\n    out.index = data.read_shift(1);\n    out.nTintAndShade = data.read_shift(2, 'i');\n    out.bRed   = data.read_shift(1);\n    out.bGreen = data.read_shift(1);\n    out.bBlue  = data.read_shift(1);\n    out.bAlpha = data.read_shift(1);\n}\n\n/* [MS-XLSB] 2.5.52 */\nfunction parse_FontFlags(data, length) {\n    var d = data.read_shift(1);\n    data.l++;\n    var out = {\n        fItalic: d & 0x2,\n        fStrikeout: d & 0x8,\n        fOutline: d & 0x10,\n        fShadow: d & 0x20,\n        fCondense: d & 0x40,\n        fExtend: d & 0x80\n    };\n    return out;\n}\n/* [MS-OLEPS] 2.2 PropertyType */\n{\n    var VT_EMPTY    = 0x0000;\n    var VT_NULL     = 0x0001;\n    var VT_I2       = 0x0002;\n    var VT_I4       = 0x0003;\n    var VT_R4       = 0x0004;\n    var VT_R8       = 0x0005;\n    var VT_CY       = 0x0006;\n    var VT_DATE     = 0x0007;\n    var VT_BSTR     = 0x0008;\n    var VT_ERROR    = 0x000A;\n    var VT_BOOL     = 0x000B;\n    var VT_VARIANT  = 0x000C;\n    var VT_DECIMAL  = 0x000E;\n    var VT_I1       = 0x0010;\n    var VT_UI1      = 0x0011;\n    var VT_UI2      = 0x0012;\n    var VT_UI4      = 0x0013;\n    var VT_I8       = 0x0014;\n    var VT_UI8      = 0x0015;\n    var VT_INT      = 0x0016;\n    var VT_UINT     = 0x0017;\n    var VT_LPSTR    = 0x001E;\n    var VT_LPWSTR   = 0x001F;\n    var VT_FILETIME = 0x0040;\n    var VT_BLOB     = 0x0041;\n    var VT_STREAM   = 0x0042;\n    var VT_STORAGE  = 0x0043;\n    var VT_STREAMED_Object  = 0x0044;\n    var VT_STORED_Object    = 0x0045;\n    var VT_BLOB_Object      = 0x0046;\n    var VT_CF       = 0x0047;\n    var VT_CLSID    = 0x0048;\n    var VT_VERSIONED_STREAM = 0x0049;\n    var VT_VECTOR   = 0x1000;\n    var VT_ARRAY    = 0x2000;\n\n    var VT_STRING   = 0x0050; // 2.3.3.1.11 VtString\n    var VT_USTR     = 0x0051; // 2.3.3.1.12 VtUnalignedString\n    var VT_CUSTOM   = [VT_STRING, VT_USTR];\n}\n\n/* [MS-OSHARED] 2.3.3.2.2.1 Document Summary Information PIDDSI */\nvar DocSummaryPIDDSI = {\n    0x01: { n: 'CodePage', t: VT_I2 },\n    0x02: { n: 'Category', t: VT_STRING },\n    0x03: { n: 'PresentationFormat', t: VT_STRING },\n    0x04: { n: 'ByteCount', t: VT_I4 },\n    0x05: { n: 'LineCount', t: VT_I4 },\n    0x06: { n: 'ParagraphCount', t: VT_I4 },\n    0x07: { n: 'SlideCount', t: VT_I4 },\n    0x08: { n: 'NoteCount', t: VT_I4 },\n    0x09: { n: 'HiddenCount', t: VT_I4 },\n    0x0a: { n: 'MultimediaClipCount', t: VT_I4 },\n    0x0b: { n: 'Scale', t: VT_BOOL },\n    0x0c: { n: 'HeadingPair', t: VT_VECTOR | VT_VARIANT },\n    0x0d: { n: 'DocParts', t: VT_VECTOR | VT_LPSTR },\n    0x0e: { n: 'Manager', t: VT_STRING },\n    0x0f: { n: 'Company', t: VT_STRING },\n    0x10: { n: 'LinksDirty', t: VT_BOOL },\n    0x11: { n: 'CharacterCount', t: VT_I4 },\n    0x13: { n: 'SharedDoc', t: VT_BOOL },\n    0x16: { n: 'HLinksChanged', t: VT_BOOL },\n    0x17: { n: 'AppVersion', t: VT_I4, p: 'version' },\n    0x1A: { n: 'ContentType', t: VT_STRING },\n    0x1B: { n: 'ContentStatus', t: VT_STRING },\n    0x1C: { n: 'Language', t: VT_STRING },\n    0x1D: { n: 'Version', t: VT_STRING },\n    0xFF: {}\n};\n\n/* [MS-OSHARED] 2.3.3.2.1.1 Summary Information Property Set PIDSI */\nvar SummaryPIDSI = {\n    0x01: { n: 'CodePage', t: VT_I2 },\n    0x02: { n: 'Title', t: VT_STRING },\n    0x03: { n: 'Subject', t: VT_STRING },\n    0x04: { n: 'Author', t: VT_STRING },\n    0x05: { n: 'Keywords', t: VT_STRING },\n    0x06: { n: 'Comments', t: VT_STRING },\n    0x07: { n: 'Template', t: VT_STRING },\n    0x08: { n: 'LastAuthor', t: VT_STRING },\n    0x09: { n: 'RevNumber', t: VT_STRING },\n    0x0A: { n: 'EditTime', t: VT_FILETIME },\n    0x0B: { n: 'LastPrinted', t: VT_FILETIME },\n    0x0C: { n: 'CreatedDate', t: VT_FILETIME },\n    0x0D: { n: 'ModifiedDate', t: VT_FILETIME },\n    0x0E: { n: 'PageCount', t: VT_I4 },\n    0x0F: { n: 'WordCount', t: VT_I4 },\n    0x10: { n: 'CharCount', t: VT_I4 },\n    0x11: { n: 'Thumbnail', t: VT_CF },\n    0x12: { n: 'ApplicationName', t: VT_LPSTR },\n    0x13: { n: 'DocumentSecurity', t: VT_I4 },\n    0xFF: {}\n};\n\n/* [MS-OLEPS] 2.18 */\nvar SpecialProperties = {\n    0x80000000: { n: 'Locale', t: VT_UI4 },\n    0x80000003: { n: 'Behavior', t: VT_UI4 },\n    0x72627262: {}\n};\n\n(function() {\n    for(var y in SpecialProperties) if(SpecialProperties.hasOwnProperty(y))\n    DocSummaryPIDDSI[y] = SummaryPIDSI[y] = SpecialProperties[y];\n})();\n\n/* [MS-XLS] 2.4.63 Country/Region codes */\nvar CountryEnum = {\n    0x0001: \"US\", // United States\n    0x0002: \"CA\", // Canada\n    0x0003: \"\", // Latin America (except Brazil)\n    0x0007: \"RU\", // Russia\n    0x0014: \"EG\", // Egypt\n    0x001E: \"GR\", // Greece\n    0x001F: \"NL\", // Netherlands\n    0x0020: \"BE\", // Belgium\n    0x0021: \"FR\", // France\n    0x0022: \"ES\", // Spain\n    0x0024: \"HU\", // Hungary\n    0x0027: \"IT\", // Italy\n    0x0029: \"CH\", // Switzerland\n    0x002B: \"AT\", // Austria\n    0x002C: \"GB\", // United Kingdom\n    0x002D: \"DK\", // Denmark\n    0x002E: \"SE\", // Sweden\n    0x002F: \"NO\", // Norway\n    0x0030: \"PL\", // Poland\n    0x0031: \"DE\", // Germany\n    0x0034: \"MX\", // Mexico\n    0x0037: \"BR\", // Brazil\n    0x003d: \"AU\", // Australia\n    0x0040: \"NZ\", // New Zealand\n    0x0042: \"TH\", // Thailand\n    0x0051: \"JP\", // Japan\n    0x0052: \"KR\", // Korea\n    0x0054: \"VN\", // Viet Nam\n    0x0056: \"CN\", // China\n    0x005A: \"TR\", // Turkey\n    0x0069: \"JS\", // Ramastan\n    0x00D5: \"DZ\", // Algeria\n    0x00D8: \"MA\", // Morocco\n    0x00DA: \"LY\", // Libya\n    0x015F: \"PT\", // Portugal\n    0x0162: \"IS\", // Iceland\n    0x0166: \"FI\", // Finland\n    0x01A4: \"CZ\", // Czech Republic\n    0x0376: \"TW\", // Taiwan\n    0x03C1: \"LB\", // Lebanon\n    0x03C2: \"JO\", // Jordan\n    0x03C3: \"SY\", // Syria\n    0x03C4: \"IQ\", // Iraq\n    0x03C5: \"KW\", // Kuwait\n    0x03C6: \"SA\", // Saudi Arabia\n    0x03CB: \"AE\", // United Arab Emirates\n    0x03CC: \"IL\", // Israel\n    0x03CE: \"QA\", // Qatar\n    0x03D5: \"IR\", // Iran\n    0xFFFF: \"US\"  // United States\n};\n\n/* [MS-XLS] 2.5.127 */\nvar XLSFillPattern = [\n    null,\n    'solid',\n    'mediumGray',\n    'darkGray',\n    'lightGray',\n    'darkHorizontal',\n    'darkVertical',\n    'darkDown',\n    'darkUp',\n    'darkGrid',\n    'darkTrellis',\n    'lightHorizontal',\n    'lightVertical',\n    'lightDown',\n    'lightUp',\n    'lightGrid',\n    'lightTrellis',\n    'gray125',\n    'gray0625'\n];\n\nfunction rgbify(arr) { return arr.map(function(x) { return [(x>>16)&255,(x>>8)&255,x&255]; }); }\n\n/* [MS-XLS] 2.5.161 */\nvar XLSIcv = rgbify([\n    /* Color Constants */\n    0x000000,\n    0xFFFFFF,\n    0xFF0000,\n    0x00FF00,\n    0x0000FF,\n    0xFFFF00,\n    0xFF00FF,\n    0x00FFFF,\n\n    /* Defaults */\n    0x000000,\n    0xFFFFFF,\n    0xFF0000,\n    0x00FF00,\n    0x0000FF,\n    0xFFFF00,\n    0xFF00FF,\n    0x00FFFF,\n\n    0x800000,\n    0x008000,\n    0x000080,\n    0x808000,\n    0x800080,\n    0x008080,\n    0xC0C0C0,\n    0x808080,\n    0x9999FF,\n    0x993366,\n    0xFFFFCC,\n    0xCCFFFF,\n    0x660066,\n    0xFF8080,\n    0x0066CC,\n    0xCCCCFF,\n\n    0x000080,\n    0xFF00FF,\n    0xFFFF00,\n    0x00FFFF,\n    0x800080,\n    0x800000,\n    0x008080,\n    0x0000FF,\n    0x00CCFF,\n    0xCCFFFF,\n    0xCCFFCC,\n    0xFFFF99,\n    0x99CCFF,\n    0xFF99CC,\n    0xCC99FF,\n    0xFFCC99,\n\n    0x3366FF,\n    0x33CCCC,\n    0x99CC00,\n    0xFFCC00,\n    0xFF9900,\n    0xFF6600,\n    0x666699,\n    0x969696,\n    0x003366,\n    0x339966,\n    0x003300,\n    0x333300,\n    0x993300,\n    0x993366,\n    0x333399,\n    0x333333,\n\n    /* Sheet */\n    0xFFFFFF,\n    0x000000\n]);\n\n/* Parts enumerated in OPC spec, MS-XLSB and MS-XLSX */\n/* 12.3 Part Summary <SpreadsheetML> */\n/* 14.2 Part Summary <DrawingML> */\n/* [MS-XLSX] 2.1 Part Enumerations */\n/* [MS-XLSB] 2.1.7 Part Enumeration */\nvar ct2type = {\n    /* Workbook */\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\": \"workbooks\",\n\n    /* Worksheet */\n    \"application/vnd.ms-excel.binIndexWs\": \"TODO\", /* Binary Index */\n\n    /* Chartsheet */\n    \"application/vnd.ms-excel.chartsheet\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml\": \"TODO\",\n\n    /* Dialogsheet */\n    \"application/vnd.ms-excel.dialogsheet\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml\": \"TODO\",\n\n    /* Macrosheet */\n    \"application/vnd.ms-excel.macrosheet\": \"TODO\",\n    \"application/vnd.ms-excel.macrosheet+xml\": \"TODO\",\n    \"application/vnd.ms-excel.intlmacrosheet\": \"TODO\",\n    \"application/vnd.ms-excel.binIndexMs\": \"TODO\", /* Binary Index */\n\n    /* File Properties */\n    \"application/vnd.openxmlformats-package.core-properties+xml\": \"coreprops\",\n    \"application/vnd.openxmlformats-officedocument.custom-properties+xml\": \"custprops\",\n    \"application/vnd.openxmlformats-officedocument.extended-properties+xml\": \"extprops\",\n\n    /* Custom Data Properties */\n    \"application/vnd.openxmlformats-officedocument.customXmlProperties+xml\": \"TODO\",\n\n    /* Comments */\n    \"application/vnd.ms-excel.comments\": \"comments\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml\": \"comments\",\n\n    /* PivotTable */\n    \"application/vnd.ms-excel.pivotTable\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml\": \"TODO\",\n\n    /* Calculation Chain */\n    \"application/vnd.ms-excel.calcChain\": \"calcchains\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml\": \"calcchains\",\n\n    /* Printer Settings */\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.printerSettings\": \"TODO\",\n\n    /* ActiveX */\n    \"application/vnd.ms-office.activeX\": \"TODO\",\n    \"application/vnd.ms-office.activeX+xml\": \"TODO\",\n\n    /* Custom Toolbars */\n    \"application/vnd.ms-excel.attachedToolbars\": \"TODO\",\n\n    /* External Data Connections */\n    \"application/vnd.ms-excel.connections\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml\": \"TODO\",\n\n    /* External Links */\n    \"application/vnd.ms-excel.externalLink\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml\": \"TODO\",\n\n    /* Metadata */\n    \"application/vnd.ms-excel.sheetMetadata\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml\": \"TODO\",\n\n    /* PivotCache */\n    \"application/vnd.ms-excel.pivotCacheDefinition\": \"TODO\",\n    \"application/vnd.ms-excel.pivotCacheRecords\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml\": \"TODO\",\n\n    /* Query Table */\n    \"application/vnd.ms-excel.queryTable\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml\": \"TODO\",\n\n    /* Shared Workbook */\n    \"application/vnd.ms-excel.userNames\": \"TODO\",\n    \"application/vnd.ms-excel.revisionHeaders\": \"TODO\",\n    \"application/vnd.ms-excel.revisionLog\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml\": \"TODO\",\n\n    /* Single Cell Table */\n    \"application/vnd.ms-excel.tableSingleCells\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml\": \"TODO\",\n\n    /* Slicer */\n    \"application/vnd.ms-excel.slicer\": \"TODO\",\n    \"application/vnd.ms-excel.slicerCache\": \"TODO\",\n    \"application/vnd.ms-excel.slicer+xml\": \"TODO\",\n    \"application/vnd.ms-excel.slicerCache+xml\": \"TODO\",\n\n    /* Sort Map */\n    \"application/vnd.ms-excel.wsSortMap\": \"TODO\",\n\n    /* Table */\n    \"application/vnd.ms-excel.table\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml\": \"TODO\",\n\n    /* Themes */\n    \"application/vnd.openxmlformats-officedocument.theme+xml\": \"themes\",\n\n    /* Timeline */\n    \"application/vnd.ms-excel.Timeline+xml\": \"TODO\", /* verify */\n    \"application/vnd.ms-excel.TimelineCache+xml\": \"TODO\", /* verify */\n\n    /* VBA */\n    \"application/vnd.ms-office.vbaProject\": \"vba\",\n    \"application/vnd.ms-office.vbaProjectSignature\": \"vba\",\n\n    /* Volatile Dependencies */\n    \"application/vnd.ms-office.volatileDependencies\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml\": \"TODO\",\n\n    /* Control Properties */\n    \"application/vnd.ms-excel.controlproperties+xml\": \"TODO\",\n\n    /* Data Model */\n    \"application/vnd.openxmlformats-officedocument.model+data\": \"TODO\",\n\n    /* Survey */\n    \"application/vnd.ms-excel.Survey+xml\": \"TODO\",\n\n    /* Drawing */\n    \"application/vnd.openxmlformats-officedocument.drawing+xml\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.drawingml.chart+xml\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml\": \"TODO\",\n    \"application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml\": \"TODO\",\n\n    /* VML */\n    \"application/vnd.openxmlformats-officedocument.vmlDrawing\": \"TODO\",\n\n    \"application/vnd.openxmlformats-package.relationships+xml\": \"rels\",\n    \"application/vnd.openxmlformats-officedocument.oleObject\": \"TODO\",\n\n    \"sheet\": \"js\"\n};\n\nvar CT_LIST = (function(){\n    var o = {\n        workbooks: {\n            xlsx: \"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\",\n            xlsm: \"application/vnd.ms-excel.sheet.macroEnabled.main+xml\",\n            xlsb: \"application/vnd.ms-excel.sheet.binary.macroEnabled.main\",\n            xltx: \"application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml\"\n        },\n        strs: { /* Shared Strings */\n            xlsx: \"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml\",\n            xlsb: \"application/vnd.ms-excel.sharedStrings\"\n        },\n        sheets: {\n            xlsx: \"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\",\n            xlsb: \"application/vnd.ms-excel.worksheet\"\n        },\n        styles: {/* Styles */\n            xlsx: \"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml\",\n            xlsb: \"application/vnd.ms-excel.styles\"\n        }\n    };\n    keys(o).forEach(function(k) { if(!o[k].xlsm) o[k].xlsm = o[k].xlsx; });\n    keys(o).forEach(function(k){ keys(o[k]).forEach(function(v) { ct2type[o[k][v]] = k; }); });\n    return o;\n})();\n\nvar type2ct = evert_arr(ct2type);\n\nXMLNS.CT = 'http://schemas.openxmlformats.org/package/2006/content-types';\n\nfunction parse_ct(data, opts) {\n    var ctext = {};\n    if(!data || !data.match) return data;\n    var ct = { workbooks: [], sheets: [], calcchains: [], themes: [], styles: [],\n        coreprops: [], extprops: [], custprops: [], strs:[], comments: [], vba: [],\n        TODO:[], rels:[], xmlns: \"\" };\n    (data.match(tagregex)||[]).forEach(function(x) {\n        var y = parsexmltag(x);\n        switch(y[0].replace(nsregex,\"<\")) {\n            case '<?xml': break;\n            case '<Types': ct.xmlns = y['xmlns' + (y[0].match(/<(\\w+):/)||[\"\",\"\"])[1] ]; break;\n            case '<Default': ctext[y.Extension] = y.ContentType; break;\n            case '<Override':\n                if(ct[ct2type[y.ContentType]] !== undefined) ct[ct2type[y.ContentType]].push(y.PartName);\n                else if(opts.WTF) console.error(y);\n                break;\n        }\n    });\n    if(ct.xmlns !== XMLNS.CT) throw new Error(\"Unknown Namespace: \" + ct.xmlns);\n    ct.calcchain = ct.calcchains.length > 0 ? ct.calcchains[0] : \"\";\n    ct.sst = ct.strs.length > 0 ? ct.strs[0] : \"\";\n    ct.style = ct.styles.length > 0 ? ct.styles[0] : \"\";\n    ct.defaults = ctext;\n    delete ct.calcchains;\n    return ct;\n}\n\nvar CTYPE_XML_ROOT = writextag('Types', null, {\n    'xmlns': XMLNS.CT,\n    'xmlns:xsd': XMLNS.xsd,\n    'xmlns:xsi': XMLNS.xsi\n});\n\nvar CTYPE_DEFAULTS = [\n    ['xml', 'application/xml'],\n    ['bin', 'application/vnd.ms-excel.sheet.binary.macroEnabled.main'],\n    ['rels', type2ct.rels[0]]\n].map(function(x) {\n    return writextag('Default', null, {'Extension':x[0], 'ContentType': x[1]});\n});\n\nfunction write_ct(ct, opts) {\n    var o = [], v;\n    o[o.length] = (XML_HEADER);\n    o[o.length] = (CTYPE_XML_ROOT);\n    o = o.concat(CTYPE_DEFAULTS);\n    var f1 = function(w) {\n        if(ct[w] && ct[w].length > 0) {\n            v = ct[w][0];\n            o[o.length] = (writextag('Override', null, {\n                'PartName': (v[0] == '/' ? \"\":\"/\") + v,\n                'ContentType': CT_LIST[w][opts.bookType || 'xlsx']\n            }));\n        }\n    };\n    var f2 = function(w) {\n        ct[w].forEach(function(v) {\n            o[o.length] = (writextag('Override', null, {\n                'PartName': (v[0] == '/' ? \"\":\"/\") + v,\n                'ContentType': CT_LIST[w][opts.bookType || 'xlsx']\n            }));\n        });\n    };\n    var f3 = function(t) {\n        (ct[t]||[]).forEach(function(v) {\n            o[o.length] = (writextag('Override', null, {\n                'PartName': (v[0] == '/' ? \"\":\"/\") + v,\n                'ContentType': type2ct[t][0]\n            }));\n        });\n    };\n    f1('workbooks');\n    f2('sheets');\n    f3('themes');\n    ['strs', 'styles'].forEach(f1);\n    ['coreprops', 'extprops', 'custprops'].forEach(f3);\n    if(o.length>2){ o[o.length] = ('</Types>'); o[1]=o[1].replace(\"/>\",\">\"); }\n    return o.join(\"\");\n}\n/* 9.3.2 OPC Relationships Markup */\nvar RELS = {\n    WB: \"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument\",\n    SHEET: \"http://sheetjs.openxmlformats.org/officeDocument/2006/relationships/officeDocument\"\n};\n\nfunction parse_rels(data, currentFilePath) {\n    if (!data) return data;\n    if (currentFilePath.charAt(0) !== '/') {\n        currentFilePath = '/'+currentFilePath;\n    }\n    var rels = {};\n    var hash = {};\n    var resolveRelativePathIntoAbsolute = function (to) {\n        var toksFrom = currentFilePath.split('/');\n        toksFrom.pop(); // folder path\n        var toksTo = to.split('/');\n        var reversed = [];\n        while (toksTo.length !== 0) {\n            var tokTo = toksTo.shift();\n            if (tokTo === '..') {\n                toksFrom.pop();\n            } else if (tokTo !== '.') {\n                toksFrom.push(tokTo);\n            }\n        }\n        return toksFrom.join('/');\n    };\n\n    data.match(tagregex).forEach(function(x) {\n        var y = parsexmltag(x);\n        /* 9.3.2.2 OPC_Relationships */\n        if (y[0] === '<Relationship') {\n            var rel = {}; rel.Type = y.Type; rel.Target = y.Target; rel.Id = y.Id; rel.TargetMode = y.TargetMode;\n            var canonictarget = y.TargetMode === 'External' ? y.Target : resolveRelativePathIntoAbsolute(y.Target);\n            rels[canonictarget] = rel;\n            hash[y.Id] = rel;\n        }\n    });\n    rels[\"!id\"] = hash;\n    return rels;\n}\n\nXMLNS.RELS = 'http://schemas.openxmlformats.org/package/2006/relationships';\n\nvar RELS_ROOT = writextag('Relationships', null, {\n    //'xmlns:ns0': XMLNS.RELS,\n    'xmlns': XMLNS.RELS\n});\n\n/* TODO */\nfunction write_rels(rels) {\n    var o = [];\n    o[o.length] = (XML_HEADER);\n    o[o.length] = (RELS_ROOT);\n    keys(rels['!id']).forEach(function(rid) { var rel = rels['!id'][rid];\n        o[o.length] = (writextag('Relationship', null, rel));\n    });\n    if(o.length>2){ o[o.length] = ('</Relationships>'); o[1]=o[1].replace(\"/>\",\">\"); }\n    return o.join(\"\");\n}\n/* ECMA-376 Part II 11.1 Core Properties Part */\n/* [MS-OSHARED] 2.3.3.2.[1-2].1 (PIDSI/PIDDSI) */\nvar CORE_PROPS = [\n    [\"cp:category\", \"Category\"],\n    [\"cp:contentStatus\", \"ContentStatus\"],\n    [\"cp:keywords\", \"Keywords\"],\n    [\"cp:lastModifiedBy\", \"LastAuthor\"],\n    [\"cp:lastPrinted\", \"LastPrinted\"],\n    [\"cp:revision\", \"RevNumber\"],\n    [\"cp:version\", \"Version\"],\n    [\"dc:creator\", \"Author\"],\n    [\"dc:description\", \"Comments\"],\n    [\"dc:identifier\", \"Identifier\"],\n    [\"dc:language\", \"Language\"],\n    [\"dc:subject\", \"Subject\"],\n    [\"dc:title\", \"Title\"],\n    [\"dcterms:created\", \"CreatedDate\", 'date'],\n    [\"dcterms:modified\", \"ModifiedDate\", 'date']\n];\n\nXMLNS.CORE_PROPS = \"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\";\nRELS.CORE_PROPS  = 'http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties';\n\nvar CORE_PROPS_REGEX = (function() {\n    var r = new Array(CORE_PROPS.length);\n    for(var i = 0; i < CORE_PROPS.length; ++i) {\n        var f = CORE_PROPS[i];\n        var g = \"(?:\"+ f[0].substr(0,f[0].indexOf(\":\")) +\":)\"+ f[0].substr(f[0].indexOf(\":\")+1);\n        r[i] = new RegExp(\"<\" + g + \"[^>]*>(.*)<\\/\" + g + \">\");\n    }\n    return r;\n})();\n\nfunction parse_core_props(data) {\n    var p = {};\n\n    for(var i = 0; i < CORE_PROPS.length; ++i) {\n        var f = CORE_PROPS[i], cur = data.match(CORE_PROPS_REGEX[i]);\n        if(cur != null && cur.length > 0) p[f[1]] = cur[1];\n        if(f[2] === 'date' && p[f[1]]) p[f[1]] = new Date(p[f[1]]);\n    }\n\n    return p;\n}\n\nvar CORE_PROPS_XML_ROOT = writextag('cp:coreProperties', null, {\n    //'xmlns': XMLNS.CORE_PROPS,\n    'xmlns:cp': XMLNS.CORE_PROPS,\n    'xmlns:dc': XMLNS.dc,\n    'xmlns:dcterms': XMLNS.dcterms,\n    'xmlns:dcmitype': XMLNS.dcmitype,\n    'xmlns:xsi': XMLNS.xsi\n});\n\nfunction cp_doit(f, g, h, o, p) {\n    if(p[f] != null || g == null || g === \"\") return;\n    p[f] = g;\n    o[o.length] = (h ? writextag(f,g,h) : writetag(f,g));\n}\n\nfunction write_core_props(cp, opts) {\n    var o = [XML_HEADER, CORE_PROPS_XML_ROOT], p = {};\n    if(!cp) return o.join(\"\");\n\n\n    if(cp.CreatedDate != null) cp_doit(\"dcterms:created\", typeof cp.CreatedDate === \"string\" ? cp.CreatedDate : write_w3cdtf(cp.CreatedDate, opts.WTF), {\"xsi:type\":\"dcterms:W3CDTF\"}, o, p);\n    if(cp.ModifiedDate != null) cp_doit(\"dcterms:modified\", typeof cp.ModifiedDate === \"string\" ? cp.ModifiedDate : write_w3cdtf(cp.ModifiedDate, opts.WTF), {\"xsi:type\":\"dcterms:W3CDTF\"}, o, p);\n\n    for(var i = 0; i != CORE_PROPS.length; ++i) { var f = CORE_PROPS[i]; cp_doit(f[0], cp[f[1]], null, o, p); }\n    if(o.length>2){ o[o.length] = ('</cp:coreProperties>'); o[1]=o[1].replace(\"/>\",\">\"); }\n    return o.join(\"\");\n}\n/* 15.2.12.3 Extended File Properties Part */\n/* [MS-OSHARED] 2.3.3.2.[1-2].1 (PIDSI/PIDDSI) */\nvar EXT_PROPS = [\n    [\"Application\", \"Application\", \"string\"],\n    [\"AppVersion\", \"AppVersion\", \"string\"],\n    [\"Company\", \"Company\", \"string\"],\n    [\"DocSecurity\", \"DocSecurity\", \"string\"],\n    [\"Manager\", \"Manager\", \"string\"],\n    [\"HyperlinksChanged\", \"HyperlinksChanged\", \"bool\"],\n    [\"SharedDoc\", \"SharedDoc\", \"bool\"],\n    [\"LinksUpToDate\", \"LinksUpToDate\", \"bool\"],\n    [\"ScaleCrop\", \"ScaleCrop\", \"bool\"],\n    [\"HeadingPairs\", \"HeadingPairs\", \"raw\"],\n    [\"TitlesOfParts\", \"TitlesOfParts\", \"raw\"]\n];\n\nXMLNS.EXT_PROPS = \"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties\";\nRELS.EXT_PROPS  = 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties';\n\nfunction parse_ext_props(data, p) {\n    var q = {}; if(!p) p = {};\n\n    EXT_PROPS.forEach(function(f) {\n        switch(f[2]) {\n            case \"string\": p[f[1]] = (data.match(matchtag(f[0]))||[])[1]; break;\n            case \"bool\": p[f[1]] = (data.match(matchtag(f[0]))||[])[1] === \"true\"; break;\n            case \"raw\":\n                var cur = data.match(new RegExp(\"<\" + f[0] + \"[^>]*>(.*)<\\/\" + f[0] + \">\"));\n                if(cur && cur.length > 0) q[f[1]] = cur[1];\n                break;\n        }\n    });\n\n    if(q.HeadingPairs && q.TitlesOfParts) {\n        var v = parseVector(q.HeadingPairs);\n        var j = 0, widx = 0;\n        for(var i = 0; i !== v.length; ++i) {\n            switch(v[i].v) {\n                case \"Worksheets\": widx = j; p.Worksheets = +(v[++i].v); break;\n                case \"Named Ranges\": ++i; break; // TODO: Handle Named Ranges\n            }\n        }\n        var parts = parseVector(q.TitlesOfParts).map(function(x) { return utf8read(x.v); });\n        p.SheetNames = parts.slice(widx, widx + p.Worksheets);\n    }\n    return p;\n}\n\nvar EXT_PROPS_XML_ROOT = writextag('Properties', null, {\n    'xmlns': XMLNS.EXT_PROPS,\n    'xmlns:vt': XMLNS.vt\n});\n\nfunction write_ext_props(cp, opts) {\n    var o = [], p = {}, W = writextag;\n    if(!cp) cp = {};\n    cp.Application = \"SheetJS\";\n    o[o.length] = (XML_HEADER);\n    o[o.length] = (EXT_PROPS_XML_ROOT);\n\n    EXT_PROPS.forEach(function(f) {\n        if(cp[f[1]] === undefined) return;\n        var v;\n        switch(f[2]) {\n            case 'string': v = cp[f[1]]; break;\n            case 'bool': v = cp[f[1]] ? 'true' : 'false'; break;\n        }\n        if(v !== undefined) o[o.length] = (W(f[0], v));\n    });\n\n    /* TODO: HeadingPairs, TitlesOfParts */\n    o[o.length] = (W('HeadingPairs', W('vt:vector', W('vt:variant', '<vt:lpstr>Worksheets</vt:lpstr>')+W('vt:variant', W('vt:i4', String(cp.Worksheets))), {size:2, baseType:\"variant\"})));\n    o[o.length] = (W('TitlesOfParts', W('vt:vector', cp.SheetNames.map(function(s) { return \"<vt:lpstr>\" + s + \"</vt:lpstr>\"; }).join(\"\"), {size: cp.Worksheets, baseType:\"lpstr\"})));\n    if(o.length>2){ o[o.length] = ('</Properties>'); o[1]=o[1].replace(\"/>\",\">\"); }\n    return o.join(\"\");\n}\n/* 15.2.12.2 Custom File Properties Part */\nXMLNS.CUST_PROPS = \"http://schemas.openxmlformats.org/officeDocument/2006/custom-properties\";\nRELS.CUST_PROPS  = 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties';\n\nvar custregex = /<[^>]+>[^<]*/g;\nfunction parse_cust_props(data, opts) {\n    var p = {}, name;\n    var m = data.match(custregex);\n    if(m) for(var i = 0; i != m.length; ++i) {\n        var x = m[i], y = parsexmltag(x);\n        switch(y[0]) {\n            case '<?xml': break;\n            case '<Properties':\n                if(y.xmlns !== XMLNS.CUST_PROPS) throw \"unrecognized xmlns \" + y.xmlns;\n                if(y.xmlnsvt && y.xmlnsvt !== XMLNS.vt) throw \"unrecognized vt \" + y.xmlnsvt;\n                break;\n            case '<property': name = y.name; break;\n            case '</property>': name = null; break;\n            default: if (x.indexOf('<vt:') === 0) {\n                var toks = x.split('>');\n                var type = toks[0].substring(4), text = toks[1];\n                /* 22.4.2.32 (CT_Variant). Omit the binary types from 22.4 (Variant Types) */\n                switch(type) {\n                    case 'lpstr': case 'lpwstr': case 'bstr': case 'lpwstr':\n                        p[name] = unescapexml(text);\n                        break;\n                    case 'bool':\n                        p[name] = parsexmlbool(text, '<vt:bool>');\n                        break;\n                    case 'i1': case 'i2': case 'i4': case 'i8': case 'int': case 'uint':\n                        p[name] = parseInt(text, 10);\n                        break;\n                    case 'r4': case 'r8': case 'decimal':\n                        p[name] = parseFloat(text);\n                        break;\n                    case 'filetime': case 'date':\n                        p[name] = new Date(text);\n                        break;\n                    case 'cy': case 'error':\n                        p[name] = unescapexml(text);\n                        break;\n                    default:\n                        if(typeof console !== 'undefined') console.warn('Unexpected', x, type, toks);\n                }\n            } else if(x.substr(0,2) === \"</\") {\n            } else if(opts.WTF) throw new Error(x);\n        }\n    }\n    return p;\n}\n\nvar CUST_PROPS_XML_ROOT = writextag('Properties', null, {\n    'xmlns': XMLNS.CUST_PROPS,\n    'xmlns:vt': XMLNS.vt\n});\n\nfunction write_cust_props(cp, opts) {\n    var o = [XML_HEADER, CUST_PROPS_XML_ROOT];\n    if(!cp) return o.join(\"\");\n    var pid = 1;\n    keys(cp).forEach(function custprop(k) { ++pid;\n        o[o.length] = (writextag('property', write_vt(cp[k]), {\n            'fmtid': '{D5CDD505-2E9C-101B-9397-08002B2CF9AE}',\n            'pid': pid,\n            'name': k\n        }));\n    });\n    if(o.length>2){ o[o.length] = '</Properties>'; o[1]=o[1].replace(\"/>\",\">\"); }\n    return o.join(\"\");\n}\nfunction xlml_set_prop(Props, tag, val) {\n    /* TODO: Normalize the properties */\n    switch(tag) {\n        case 'Description': tag = 'Comments'; break;\n    }\n    Props[tag] = val;\n}\n\n/* [MS-DTYP] 2.3.3 FILETIME */\n/* [MS-OLEDS] 2.1.3 FILETIME (Packet Version) */\n/* [MS-OLEPS] 2.8 FILETIME (Packet Version) */\nfunction parse_FILETIME(blob) {\n    var dwLowDateTime = blob.read_shift(4), dwHighDateTime = blob.read_shift(4);\n    return new Date(((dwHighDateTime/1e7*Math.pow(2,32) + dwLowDateTime/1e7) - 11644473600)*1000).toISOString().replace(/\\.000/,\"\");\n}\n\n/* [MS-OSHARED] 2.3.3.1.4 Lpstr */\nfunction parse_lpstr(blob, type, pad) {\n    var str = blob.read_shift(0, 'lpstr');\n    if(pad) blob.l += (4 - ((str.length+1) & 3)) & 3;\n    return str;\n}\n\n/* [MS-OSHARED] 2.3.3.1.6 Lpwstr */\nfunction parse_lpwstr(blob, type, pad) {\n    var str = blob.read_shift(0, 'lpwstr');\n    if(pad) blob.l += (4 - ((str.length+1) & 3)) & 3;\n    return str;\n}\n\n\n/* [MS-OSHARED] 2.3.3.1.11 VtString */\n/* [MS-OSHARED] 2.3.3.1.12 VtUnalignedString */\nfunction parse_VtStringBase(blob, stringType, pad) {\n    if(stringType === 0x1F /*VT_LPWSTR*/) return parse_lpwstr(blob);\n    return parse_lpstr(blob, stringType, pad);\n}\n\nfunction parse_VtString(blob, t, pad) { return parse_VtStringBase(blob, t, pad === false ? 0: 4); }\nfunction parse_VtUnalignedString(blob, t) { if(!t) throw new Error(\"dafuq?\"); return parse_VtStringBase(blob, t, 0); }\n\n/* [MS-OSHARED] 2.3.3.1.9 VtVecUnalignedLpstrValue */\nfunction parse_VtVecUnalignedLpstrValue(blob) {\n    var length = blob.read_shift(4);\n    var ret = [];\n    for(var i = 0; i != length; ++i) ret[i] = blob.read_shift(0, 'lpstr');\n    return ret;\n}\n\n/* [MS-OSHARED] 2.3.3.1.10 VtVecUnalignedLpstr */\nfunction parse_VtVecUnalignedLpstr(blob) {\n    return parse_VtVecUnalignedLpstrValue(blob);\n}\n\n/* [MS-OSHARED] 2.3.3.1.13 VtHeadingPair */\nfunction parse_VtHeadingPair(blob) {\n    var headingString = parse_TypedPropertyValue(blob, VT_USTR);\n    var headerParts = parse_TypedPropertyValue(blob, VT_I4);\n    return [headingString, headerParts];\n}\n\n/* [MS-OSHARED] 2.3.3.1.14 VtVecHeadingPairValue */\nfunction parse_VtVecHeadingPairValue(blob) {\n    var cElements = blob.read_shift(4);\n    var out = [];\n    for(var i = 0; i != cElements / 2; ++i) out.push(parse_VtHeadingPair(blob));\n    return out;\n}\n\n/* [MS-OSHARED] 2.3.3.1.15 VtVecHeadingPair */\nfunction parse_VtVecHeadingPair(blob) {\n    // NOTE: When invoked, wType & padding were already consumed\n    return parse_VtVecHeadingPairValue(blob);\n}\n\n/* [MS-OLEPS] 2.18.1 Dictionary (uses 2.17, 2.16) */\nfunction parse_dictionary(blob,CodePage) {\n    var cnt = blob.read_shift(4);\n    var dict = {};\n    for(var j = 0; j != cnt; ++j) {\n        var pid = blob.read_shift(4);\n        var len = blob.read_shift(4);\n        dict[pid] = blob.read_shift(len, (CodePage === 0x4B0 ?'utf16le':'utf8')).replace(chr0,'').replace(chr1,'!');\n    }\n    if(blob.l & 3) blob.l = (blob.l>>2+1)<<2;\n    return dict;\n}\n\n/* [MS-OLEPS] 2.9 BLOB */\nfunction parse_BLOB(blob) {\n    var size = blob.read_shift(4);\n    var bytes = blob.slice(blob.l,blob.l+size);\n    if(size & 3 > 0) blob.l += (4 - (size & 3)) & 3;\n    return bytes;\n}\n\n/* [MS-OLEPS] 2.11 ClipboardData */\nfunction parse_ClipboardData(blob) {\n    // TODO\n    var o = {};\n    o.Size = blob.read_shift(4);\n    //o.Format = blob.read_shift(4);\n    blob.l += o.Size;\n    return o;\n}\n\n/* [MS-OLEPS] 2.14 Vector and Array Property Types */\nfunction parse_VtVector(blob, cb) {\n    /* [MS-OLEPS] 2.14.2 VectorHeader */\n/*  var Length = blob.read_shift(4);\n    var o = [];\n    for(var i = 0; i != Length; ++i) {\n        o.push(cb(blob));\n    }\n    return o;*/\n}\n\n/* [MS-OLEPS] 2.15 TypedPropertyValue */\nfunction parse_TypedPropertyValue(blob, type, _opts) {\n    var t = blob.read_shift(2), ret, opts = _opts||{};\n    blob.l += 2;\n    if(type !== VT_VARIANT)\n    if(t !== type && VT_CUSTOM.indexOf(type)===-1) throw new Error('Expected type ' + type + ' saw ' + t);\n    switch(type === VT_VARIANT ? t : type) {\n        case 0x02 /*VT_I2*/: ret = blob.read_shift(2, 'i'); if(!opts.raw) blob.l += 2; return ret;\n        case 0x03 /*VT_I4*/: ret = blob.read_shift(4, 'i'); return ret;\n        case 0x0B /*VT_BOOL*/: return blob.read_shift(4) !== 0x0;\n        case 0x13 /*VT_UI4*/: ret = blob.read_shift(4); return ret;\n        case 0x1E /*VT_LPSTR*/: return parse_lpstr(blob, t, 4).replace(chr0,'');\n        case 0x1F /*VT_LPWSTR*/: return parse_lpwstr(blob);\n        case 0x40 /*VT_FILETIME*/: return parse_FILETIME(blob);\n        case 0x41 /*VT_BLOB*/: return parse_BLOB(blob);\n        case 0x47 /*VT_CF*/: return parse_ClipboardData(blob);\n        case 0x50 /*VT_STRING*/: return parse_VtString(blob, t, !opts.raw && 4).replace(chr0,'');\n        case 0x51 /*VT_USTR*/: return parse_VtUnalignedString(blob, t, 4).replace(chr0,'');\n        case 0x100C /*VT_VECTOR|VT_VARIANT*/: return parse_VtVecHeadingPair(blob);\n        case 0x101E /*VT_LPSTR*/: return parse_VtVecUnalignedLpstr(blob);\n        default: throw new Error(\"TypedPropertyValue unrecognized type \" + type + \" \" + t);\n    }\n}\n/* [MS-OLEPS] 2.14.2 VectorHeader */\n/*function parse_VTVectorVariant(blob) {\n    var Length = blob.read_shift(4);\n\n    if(Length & 1 !== 0) throw new Error(\"VectorHeader Length=\" + Length + \" must be even\");\n    var o = [];\n    for(var i = 0; i != Length; ++i) {\n        o.push(parse_TypedPropertyValue(blob, VT_VARIANT));\n    }\n    return o;\n}*/\n\n/* [MS-OLEPS] 2.20 PropertySet */\nfunction parse_PropertySet(blob, PIDSI) {\n    var start_addr = blob.l;\n    var size = blob.read_shift(4);\n    var NumProps = blob.read_shift(4);\n    var Props = [], i = 0;\n    var CodePage = 0;\n    var Dictionary = -1, DictObj;\n    for(i = 0; i != NumProps; ++i) {\n        var PropID = blob.read_shift(4);\n        var Offset = blob.read_shift(4);\n        Props[i] = [PropID, Offset + start_addr];\n    }\n    var PropH = {};\n    for(i = 0; i != NumProps; ++i) {\n        if(blob.l !== Props[i][1]) {\n            var fail = true;\n            if(i>0 && PIDSI) switch(PIDSI[Props[i-1][0]].t) {\n                case 0x02 /*VT_I2*/: if(blob.l +2 === Props[i][1]) { blob.l+=2; fail = false; } break;\n                case 0x50 /*VT_STRING*/: if(blob.l <= Props[i][1]) { blob.l=Props[i][1]; fail = false; } break;\n                case 0x100C /*VT_VECTOR|VT_VARIANT*/: if(blob.l <= Props[i][1]) { blob.l=Props[i][1]; fail = false; } break;\n            }\n            if(!PIDSI && blob.l <= Props[i][1]) { fail=false; blob.l = Props[i][1]; }\n            if(fail) throw new Error(\"Read Error: Expected address \" + Props[i][1] + ' at ' + blob.l + ' :' + i);\n        }\n        if(PIDSI) {\n            var piddsi = PIDSI[Props[i][0]];\n            PropH[piddsi.n] = parse_TypedPropertyValue(blob, piddsi.t, {raw:true});\n            if(piddsi.p === 'version') PropH[piddsi.n] = String(PropH[piddsi.n] >> 16) + \".\" + String(PropH[piddsi.n] & 0xFFFF);\n            if(piddsi.n == \"CodePage\") switch(PropH[piddsi.n]) {\n                case 0: PropH[piddsi.n] = 1252;\n                    /* falls through */\n                case 10000: // OSX Roman\n                case 1252: // Windows Latin\n\n                case 874: // SB Windows Thai\n                case 1250: // SB Windows Central Europe\n                case 1251: // SB Windows Cyrillic\n                case 1253: // SB Windows Greek\n                case 1254: // SB Windows Turkish\n                case 1255: // SB Windows Hebrew\n                case 1256: // SB Windows Arabic\n                case 1257: // SB Windows Baltic\n                case 1258: // SB Windows Vietnam\n\n                case 932: // DB Windows Japanese Shift-JIS\n                case 936: // DB Windows Simplified Chinese GBK\n                case 949: // DB Windows Korean\n                case 950: // DB Windows Traditional Chinese Big5\n\n                case 1200: // UTF16LE\n                case 1201: // UTF16BE\n                case 65000: case -536: // UTF-7\n                case 65001: case -535: // UTF-8\n                    set_cp(CodePage = PropH[piddsi.n]); break;\n                default: throw new Error(\"Unsupported CodePage: \" + PropH[piddsi.n]);\n            }\n        } else {\n            if(Props[i][0] === 0x1) {\n                CodePage = PropH.CodePage = parse_TypedPropertyValue(blob, VT_I2);\n                set_cp(CodePage);\n                if(Dictionary !== -1) {\n                    var oldpos = blob.l;\n                    blob.l = Props[Dictionary][1];\n                    DictObj = parse_dictionary(blob,CodePage);\n                    blob.l = oldpos;\n                }\n            } else if(Props[i][0] === 0) {\n                if(CodePage === 0) { Dictionary = i; blob.l = Props[i+1][1]; continue; }\n                DictObj = parse_dictionary(blob,CodePage);\n            } else {\n                var name = DictObj[Props[i][0]];\n                var val;\n                /* [MS-OSHARED] 2.3.3.2.3.1.2 + PROPVARIANT */\n                switch(blob[blob.l]) {\n                    case 0x41 /*VT_BLOB*/: blob.l += 4; val = parse_BLOB(blob); break;\n                    case 0x1E /*VT_LPSTR*/: blob.l += 4; val = parse_VtString(blob, blob[blob.l-4]); break;\n                    case 0x1F /*VT_LPWSTR*/: blob.l += 4; val = parse_VtString(blob, blob[blob.l-4]); break;\n                    case 0x03 /*VT_I4*/: blob.l += 4; val = blob.read_shift(4, 'i'); break;\n                    case 0x13 /*VT_UI4*/: blob.l += 4; val = blob.read_shift(4); break;\n                    case 0x05 /*VT_R8*/: blob.l += 4; val = blob.read_shift(8, 'f'); break;\n                    case 0x0B /*VT_BOOL*/: blob.l += 4; val = parsebool(blob, 4); break;\n                    case 0x40 /*VT_FILETIME*/: blob.l += 4; val = new Date(parse_FILETIME(blob)); break;\n                    default: throw new Error(\"unparsed value: \" + blob[blob.l]);\n                }\n                PropH[name] = val;\n            }\n        }\n    }\n    blob.l = start_addr + size; /* step ahead to skip padding */\n    return PropH;\n}\n\n/* [MS-OLEPS] 2.21 PropertySetStream */\nfunction parse_PropertySetStream(file, PIDSI) {\n    var blob = file.content;\n    prep_blob(blob, 0);\n\n    var NumSets, FMTID0, FMTID1, Offset0, Offset1;\n    blob.chk('feff', 'Byte Order: ');\n\n    var vers = blob.read_shift(2); // TODO: check version\n    var SystemIdentifier = blob.read_shift(4);\n    blob.chk(CFB.utils.consts.HEADER_CLSID, 'CLSID: ');\n    NumSets = blob.read_shift(4);\n    if(NumSets !== 1 && NumSets !== 2) throw \"Unrecognized #Sets: \" + NumSets;\n    FMTID0 = blob.read_shift(16); Offset0 = blob.read_shift(4);\n\n    if(NumSets === 1 && Offset0 !== blob.l) throw \"Length mismatch\";\n    else if(NumSets === 2) { FMTID1 = blob.read_shift(16); Offset1 = blob.read_shift(4); }\n    var PSet0 = parse_PropertySet(blob, PIDSI);\n\n    var rval = { SystemIdentifier: SystemIdentifier };\n    for(var y in PSet0) rval[y] = PSet0[y];\n    //rval.blob = blob;\n    rval.FMTID = FMTID0;\n    //rval.PSet0 = PSet0;\n    if(NumSets === 1) return rval;\n    if(blob.l !== Offset1) throw \"Length mismatch 2: \" + blob.l + \" !== \" + Offset1;\n    var PSet1;\n    try { PSet1 = parse_PropertySet(blob, null); } catch(e) { }\n    for(y in PSet1) rval[y] = PSet1[y];\n    rval.FMTID = [FMTID0, FMTID1]; // TODO: verify FMTID0/1\n    return rval;\n}\n\n\nfunction parsenoop2(blob, length) { blob.read_shift(length); return null; }\n\nfunction parslurp(blob, length, cb) {\n    var arr = [], target = blob.l + length;\n    while(blob.l < target) arr.push(cb(blob, target - blob.l));\n    if(target !== blob.l) throw new Error(\"Slurp error\");\n    return arr;\n}\n\nfunction parslurp2(blob, length, cb) {\n    var arr = [], target = blob.l + length, len = blob.read_shift(2);\n    while(len-- !== 0) arr.push(cb(blob, target - blob.l));\n    if(target !== blob.l) throw new Error(\"Slurp error\");\n    return arr;\n}\n\nfunction parsebool(blob, length) { return blob.read_shift(length) === 0x1; }\n\nfunction parseuint16(blob) { return blob.read_shift(2, 'u'); }\nfunction parseuint16a(blob, length) { return parslurp(blob,length,parseuint16);}\n\n/* --- 2.5 Structures --- */\n\n/* [MS-XLS] 2.5.14 Boolean */\nvar parse_Boolean = parsebool;\n\n/* [MS-XLS] 2.5.10 Bes (boolean or error) */\nfunction parse_Bes(blob) {\n    var v = blob.read_shift(1), t = blob.read_shift(1);\n    return t === 0x01 ? v : v === 0x01;\n}\n\n/* [MS-XLS] 2.5.240 ShortXLUnicodeString */\nfunction parse_ShortXLUnicodeString(blob, length, opts) {\n    var cch = blob.read_shift(1);\n    var width = 1, encoding = 'sbcs-cont';\n    var cp = current_codepage;\n    if(opts && opts.biff >= 8) current_codepage = 1200;\n    if(opts === undefined || opts.biff !== 5) {\n        var fHighByte = blob.read_shift(1);\n        if(fHighByte) { width = 2; encoding = 'dbcs-cont'; }\n    }\n    var o = cch ? blob.read_shift(cch, encoding) : \"\";\n    current_codepage = cp;\n    return o;\n}\n\n/* 2.5.293 XLUnicodeRichExtendedString */\nfunction parse_XLUnicodeRichExtendedString(blob) {\n    var cp = current_codepage;\n    current_codepage = 1200;\n    var cch = blob.read_shift(2), flags = blob.read_shift(1);\n    var fHighByte = flags & 0x1, fExtSt = flags & 0x4, fRichSt = flags & 0x8;\n    var width = 1 + (flags & 0x1); // 0x0 -> utf8, 0x1 -> dbcs\n    var cRun, cbExtRst;\n    var z = {};\n    if(fRichSt) cRun = blob.read_shift(2);\n    if(fExtSt) cbExtRst = blob.read_shift(4);\n    var encoding = (flags & 0x1) ? 'dbcs-cont' : 'sbcs-cont';\n    var msg = cch === 0 ? \"\" : blob.read_shift(cch, encoding);\n    if(fRichSt) blob.l += 4 * cRun; //TODO: parse this\n    if(fExtSt) blob.l += cbExtRst; //TODO: parse this\n    z.t = msg;\n    if(!fRichSt) { z.raw = \"<t>\" + z.t + \"</t>\"; z.r = z.t; }\n    current_codepage = cp;\n    return z;\n}\n\n/* 2.5.296 XLUnicodeStringNoCch */\nfunction parse_XLUnicodeStringNoCch(blob, cch, opts) {\n    var retval;\n    var fHighByte = blob.read_shift(1);\n    if(fHighByte===0) { retval = blob.read_shift(cch, 'sbcs-cont'); }\n    else { retval = blob.read_shift(cch, 'dbcs-cont'); }\n    return retval;\n}\n\n/* 2.5.294 XLUnicodeString */\nfunction parse_XLUnicodeString(blob, length, opts) {\n    var cch = blob.read_shift(opts !== undefined && opts.biff > 0 && opts.biff < 8 ? 1 : 2);\n    if(cch === 0) { blob.l++; return \"\"; }\n    return parse_XLUnicodeStringNoCch(blob, cch, opts);\n}\n/* BIFF5 override */\nfunction parse_XLUnicodeString2(blob, length, opts) {\n    if(opts.biff !== 5 && opts.biff !== 2) return parse_XLUnicodeString(blob, length, opts);\n    var cch = blob.read_shift(1);\n    if(cch === 0) { blob.l++; return \"\"; }\n    return blob.read_shift(cch, 'sbcs-cont');\n}\n\n/* [MS-XLS] 2.5.61 ControlInfo */\nvar parse_ControlInfo = parsenoop;\n\n/* [MS-OSHARED] 2.3.7.6 URLMoniker TODO: flags */\nvar parse_URLMoniker = function(blob, length) {\n    var len = blob.read_shift(4), start = blob.l;\n    var extra = false;\n    if(len > 24) {\n        /* look ahead */\n        blob.l += len - 24;\n        if(blob.read_shift(16) === \"795881f43b1d7f48af2c825dc4852763\") extra = true;\n        blob.l = start;\n    }\n    var url = blob.read_shift((extra?len-24:len)>>1, 'utf16le').replace(chr0,\"\");\n    if(extra) blob.l += 24;\n    return url;\n};\n\n/* [MS-OSHARED] 2.3.7.8 FileMoniker TODO: all fields */\nvar parse_FileMoniker = function(blob, length) {\n    var cAnti = blob.read_shift(2);\n    var ansiLength = blob.read_shift(4);\n    var ansiPath = blob.read_shift(ansiLength, 'cstr');\n    var endServer = blob.read_shift(2);\n    var versionNumber = blob.read_shift(2);\n    var cbUnicodePathSize = blob.read_shift(4);\n    if(cbUnicodePathSize === 0) return ansiPath.replace(/\\\\/g,\"/\");\n    var cbUnicodePathBytes = blob.read_shift(4);\n    var usKeyValue = blob.read_shift(2);\n    var unicodePath = blob.read_shift(cbUnicodePathBytes>>1, 'utf16le').replace(chr0,\"\");\n    return unicodePath;\n};\n\n/* [MS-OSHARED] 2.3.7.2 HyperlinkMoniker TODO: all the monikers */\nvar parse_HyperlinkMoniker = function(blob, length) {\n    var clsid = blob.read_shift(16); length -= 16;\n    switch(clsid) {\n        case \"e0c9ea79f9bace118c8200aa004ba90b\": return parse_URLMoniker(blob, length);\n        case \"0303000000000000c000000000000046\": return parse_FileMoniker(blob, length);\n        default: throw \"unsupported moniker \" + clsid;\n    }\n};\n\n/* [MS-OSHARED] 2.3.7.9 HyperlinkString */\nvar parse_HyperlinkString = function(blob, length) {\n    var len = blob.read_shift(4);\n    var o = blob.read_shift(len, 'utf16le').replace(chr0, \"\");\n    return o;\n};\n\n/* [MS-OSHARED] 2.3.7.1 Hyperlink Object TODO: unify params with XLSX */\nvar parse_Hyperlink = function(blob, length) {\n    var end = blob.l + length;\n    var sVer = blob.read_shift(4);\n    if(sVer !== 2) throw new Error(\"Unrecognized streamVersion: \" + sVer);\n    var flags = blob.read_shift(2);\n    blob.l += 2;\n    var displayName, targetFrameName, moniker, oleMoniker, location, guid, fileTime;\n    if(flags & 0x0010) displayName = parse_HyperlinkString(blob, end - blob.l);\n    if(flags & 0x0080) targetFrameName = parse_HyperlinkString(blob, end - blob.l);\n    if((flags & 0x0101) === 0x0101) moniker = parse_HyperlinkString(blob, end - blob.l);\n    if((flags & 0x0101) === 0x0001) oleMoniker = parse_HyperlinkMoniker(blob, end - blob.l);\n    if(flags & 0x0008) location = parse_HyperlinkString(blob, end - blob.l);\n    if(flags & 0x0020) guid = blob.read_shift(16);\n    if(flags & 0x0040) fileTime = parse_FILETIME(blob, 8);\n    blob.l = end;\n    var target = (targetFrameName||moniker||oleMoniker);\n    if(location) target+=\"#\"+location;\n    return {Target: target};\n};\n\n/* 2.5.178 LongRGBA */\nfunction parse_LongRGBA(blob, length) { var r = blob.read_shift(1), g = blob.read_shift(1), b = blob.read_shift(1), a = blob.read_shift(1); return [r,g,b,a]; }\n\n/* 2.5.177 LongRGB */\nfunction parse_LongRGB(blob, length) { var x = parse_LongRGBA(blob, length); x[3] = 0; return x; }\n\n\n/* --- MS-XLS --- */\n\n/* 2.5.19 */\nfunction parse_XLSCell(blob, length) {\n    var rw = blob.read_shift(2); // 0-indexed\n    var col = blob.read_shift(2);\n    var ixfe = blob.read_shift(2);\n    return {r:rw, c:col, ixfe:ixfe};\n}\n\n/* 2.5.134 */\nfunction parse_frtHeader(blob) {\n    var rt = blob.read_shift(2);\n    var flags = blob.read_shift(2); // TODO: parse these flags\n    blob.l += 8;\n    return {type: rt, flags: flags};\n}\n\n\n\nfunction parse_OptXLUnicodeString(blob, length, opts) { return length === 0 ? \"\" : parse_XLUnicodeString2(blob, length, opts); }\n\n/* 2.5.158 */\nvar HIDEOBJENUM = ['SHOWALL', 'SHOWPLACEHOLDER', 'HIDEALL'];\nvar parse_HideObjEnum = parseuint16;\n\n/* 2.5.344 */\nfunction parse_XTI(blob, length) {\n    var iSupBook = blob.read_shift(2), itabFirst = blob.read_shift(2,'i'), itabLast = blob.read_shift(2,'i');\n    return [iSupBook, itabFirst, itabLast];\n}\n\n/* 2.5.218 */\nfunction parse_RkRec(blob, length) {\n    var ixfe = blob.read_shift(2);\n    var RK = parse_RkNumber(blob);\n    //console.log(\"::\", ixfe, RK,\";;\");\n    return [ixfe, RK];\n}\n\n/* 2.5.1 */\nfunction parse_AddinUdf(blob, length) {\n    blob.l += 4; length -= 4;\n    var l = blob.l + length;\n    var udfName = parse_ShortXLUnicodeString(blob, length);\n    var cb = blob.read_shift(2);\n    l -= blob.l;\n    if(cb !== l) throw \"Malformed AddinUdf: padding = \" + l + \" != \" + cb;\n    blob.l += cb;\n    return udfName;\n}\n\n/* 2.5.209 TODO: Check sizes */\nfunction parse_Ref8U(blob, length) {\n    var rwFirst = blob.read_shift(2);\n    var rwLast = blob.read_shift(2);\n    var colFirst = blob.read_shift(2);\n    var colLast = blob.read_shift(2);\n    return {s:{c:colFirst, r:rwFirst}, e:{c:colLast,r:rwLast}};\n}\n\n/* 2.5.211 */\nfunction parse_RefU(blob, length) {\n    var rwFirst = blob.read_shift(2);\n    var rwLast = blob.read_shift(2);\n    var colFirst = blob.read_shift(1);\n    var colLast = blob.read_shift(1);\n    return {s:{c:colFirst, r:rwFirst}, e:{c:colLast,r:rwLast}};\n}\n\n/* 2.5.207 */\nvar parse_Ref = parse_RefU;\n\n/* 2.5.143 */\nfunction parse_FtCmo(blob, length) {\n    blob.l += 4;\n    var ot = blob.read_shift(2);\n    var id = blob.read_shift(2);\n    var flags = blob.read_shift(2);\n    blob.l+=12;\n    return [id, ot, flags];\n}\n\n/* 2.5.149 */\nfunction parse_FtNts(blob, length) {\n    var out = {};\n    blob.l += 4;\n    blob.l += 16; // GUID TODO\n    out.fSharedNote = blob.read_shift(2);\n    blob.l += 4;\n    return out;\n}\n\n/* 2.5.142 */\nfunction parse_FtCf(blob, length) {\n    var out = {};\n    blob.l += 4;\n    blob.cf = blob.read_shift(2);\n    return out;\n}\n\n/* 2.5.140 - 2.5.154 and friends */\nvar FtTab = {\n    0x15: parse_FtCmo,\n    0x13: parsenoop,                                /* FtLbsData */\n    0x12: function(blob, length) { blob.l += 12; }, /* FtCblsData */\n    0x11: function(blob, length) { blob.l += 8; },  /* FtRboData */\n    0x10: parsenoop,                                /* FtEdoData */\n    0x0F: parsenoop,                                /* FtGboData */\n    0x0D: parse_FtNts,                              /* FtNts */\n    0x0C: function(blob, length) { blob.l += 24; }, /* FtSbs */\n    0x0B: function(blob, length) { blob.l += 10; }, /* FtRbo */\n    0x0A: function(blob, length) { blob.l += 16; }, /* FtCbls */\n    0x09: parsenoop,                                /* FtPictFmla */\n    0x08: function(blob, length) { blob.l += 6; },  /* FtPioGrbit */\n    0x07: parse_FtCf,                               /* FtCf */\n    0x06: function(blob, length) { blob.l += 6; },  /* FtGmo */\n    0x04: parsenoop,                                /* FtMacro */\n    0x00: function(blob, length) { blob.l += 4; }   /* FtEnding */\n};\nfunction parse_FtArray(blob, length, ot) {\n    var s = blob.l;\n    var fts = [];\n    while(blob.l < s + length) {\n        var ft = blob.read_shift(2);\n        blob.l-=2;\n        try {\n            fts.push(FtTab[ft](blob, s + length - blob.l));\n        } catch(e) { blob.l = s + length; return fts; }\n    }\n    if(blob.l != s + length) blob.l = s + length; //throw \"bad Object Ft-sequence\";\n    return fts;\n}\n\n/* 2.5.129 */\nvar parse_FontIndex = parseuint16;\n\n/* --- 2.4 Records --- */\n\n/* 2.4.21 */\nfunction parse_BOF(blob, length) {\n    var o = {};\n    o.BIFFVer = blob.read_shift(2); length -= 2;\n    switch(o.BIFFVer) {\n        case 0x0600: /* BIFF8 */\n        case 0x0500: /* BIFF5 */\n        case 0x0002: case 0x0007: /* BIFF2 */\n            break;\n        default: throw \"Unexpected BIFF Ver \" + o.BIFFVer;\n    }\n    blob.read_shift(length);\n    return o;\n}\n\n\n/* 2.4.146 */\nfunction parse_InterfaceHdr(blob, length) {\n    if(length === 0) return 0x04b0;\n    var q;\n    if((q=blob.read_shift(2))!==0x04b0) throw 'InterfaceHdr codePage ' + q;\n    return 0x04b0;\n}\n\n\n/* 2.4.349 */\nfunction parse_WriteAccess(blob, length, opts) {\n    if(opts.enc) { blob.l += length; return \"\"; }\n    var l = blob.l;\n    // TODO: make sure XLUnicodeString doesnt overrun\n    var UserName = parse_XLUnicodeString(blob, 0, opts);\n    blob.read_shift(length + l - blob.l);\n    return UserName;\n}\n\n/* 2.4.28 */\nfunction parse_BoundSheet8(blob, length, opts) {\n    var pos = blob.read_shift(4);\n    var hidden = blob.read_shift(1) >> 6;\n    var dt = blob.read_shift(1);\n    switch(dt) {\n        case 0: dt = 'Worksheet'; break;\n        case 1: dt = 'Macrosheet'; break;\n        case 2: dt = 'Chartsheet'; break;\n        case 6: dt = 'VBAModule'; break;\n    }\n    var name = parse_ShortXLUnicodeString(blob, 0, opts);\n    if(name.length === 0) name = \"Sheet1\";\n    return { pos:pos, hs:hidden, dt:dt, name:name };\n}\n\n/* 2.4.265 TODO */\nfunction parse_SST(blob, length) {\n    var cnt = blob.read_shift(4);\n    var ucnt = blob.read_shift(4);\n    var strs = [];\n    for(var i = 0; i != ucnt; ++i) {\n        strs.push(parse_XLUnicodeRichExtendedString(blob));\n    }\n    strs.Count = cnt; strs.Unique = ucnt;\n    return strs;\n}\n\n/* 2.4.107 */\nfunction parse_ExtSST(blob, length) {\n    var extsst = {};\n    extsst.dsst = blob.read_shift(2);\n    blob.l += length-2;\n    return extsst;\n}\n\n\n/* 2.4.221 TODO*/\nfunction parse_Row(blob, length) {\n    var rw = blob.read_shift(2), col = blob.read_shift(2), Col = blob.read_shift(2), rht = blob.read_shift(2);\n    blob.read_shift(4); // reserved(2), unused(2)\n    var flags = blob.read_shift(1); // various flags\n    blob.read_shift(1); // reserved\n    blob.read_shift(2); //ixfe, other flags\n    return {r:rw, c:col, cnt:Col-col};\n}\n\n\n/* 2.4.125 */\nfunction parse_ForceFullCalculation(blob, length) {\n    var header = parse_frtHeader(blob);\n    if(header.type != 0x08A3) throw \"Invalid Future Record \" + header.type;\n    var fullcalc = blob.read_shift(4);\n    return fullcalc !== 0x0;\n}\n\n\nvar parse_CompressPictures = parsenoop2; /* 2.4.55 Not interesting */\n\n\n\n/* 2.4.215 rt */\nfunction parse_RecalcId(blob, length) {\n    blob.read_shift(2);\n    return blob.read_shift(4);\n}\n\n/* 2.4.87 */\nfunction parse_DefaultRowHeight (blob, length) {\n    var f = blob.read_shift(2), miyRw;\n    miyRw = blob.read_shift(2); // flags & 0x02 -> hidden, else empty\n    var fl = {Unsynced:f&1,DyZero:(f&2)>>1,ExAsc:(f&4)>>2,ExDsc:(f&8)>>3};\n    return [fl, miyRw];\n}\n\n/* 2.4.345 TODO */\nfunction parse_Window1(blob, length) {\n    var xWn = blob.read_shift(2), yWn = blob.read_shift(2), dxWn = blob.read_shift(2), dyWn = blob.read_shift(2);\n    var flags = blob.read_shift(2), iTabCur = blob.read_shift(2), iTabFirst = blob.read_shift(2);\n    var ctabSel = blob.read_shift(2), wTabRatio = blob.read_shift(2);\n    return { Pos: [xWn, yWn], Dim: [dxWn, dyWn], Flags: flags, CurTab: iTabCur,\n        FirstTab: iTabFirst, Selected: ctabSel, TabRatio: wTabRatio };\n}\n\n/* 2.4.122 TODO */\nfunction parse_Font(blob, length, opts) {\n    blob.l += 14;\n    var name = parse_ShortXLUnicodeString(blob, 0, opts);\n    return name;\n}\n\n/* 2.4.149 */\nfunction parse_LabelSst(blob, length) {\n    var cell = parse_XLSCell(blob);\n    cell.isst = blob.read_shift(4);\n    return cell;\n}\n\n/* 2.4.148 */\nfunction parse_Label(blob, length, opts) {\n    var cell = parse_XLSCell(blob, 6);\n    var str = parse_XLUnicodeString(blob, length-6, opts);\n    cell.val = str;\n    return cell;\n}\n\n/* 2.4.126 Number Formats */\nfunction parse_Format(blob, length, opts) {\n    var ifmt = blob.read_shift(2);\n    var fmtstr = parse_XLUnicodeString2(blob, 0, opts);\n    return [ifmt, fmtstr];\n}\n\n/* 2.4.90 */\nfunction parse_Dimensions(blob, length) {\n    var w = length === 10 ? 2 : 4;\n    var r = blob.read_shift(w), R = blob.read_shift(w),\n        c = blob.read_shift(2), C = blob.read_shift(2);\n    blob.l += 2;\n    return {s: {r:r, c:c}, e: {r:R, c:C}};\n}\n\n/* 2.4.220 */\nfunction parse_RK(blob, length) {\n    var rw = blob.read_shift(2), col = blob.read_shift(2);\n    var rkrec = parse_RkRec(blob);\n    return {r:rw, c:col, ixfe:rkrec[0], rknum:rkrec[1]};\n}\n\n/* 2.4.175 */\nfunction parse_MulRk(blob, length) {\n    var target = blob.l + length - 2;\n    var rw = blob.read_shift(2), col = blob.read_shift(2);\n    var rkrecs = [];\n    while(blob.l < target) rkrecs.push(parse_RkRec(blob));\n    if(blob.l !== target) throw \"MulRK read error\";\n    var lastcol = blob.read_shift(2);\n    if(rkrecs.length != lastcol - col + 1) throw \"MulRK length mismatch\";\n    return {r:rw, c:col, C:lastcol, rkrec:rkrecs};\n}\n\n/* 2.5.20 2.5.249 TODO */\nfunction parse_CellStyleXF(blob, length, style) {\n    var o = {};\n    var a = blob.read_shift(4), b = blob.read_shift(4);\n    var c = blob.read_shift(4), d = blob.read_shift(2);\n    o.patternType = XLSFillPattern[c >> 26];\n    o.icvFore = d & 0x7F;\n    o.icvBack = (d >> 7) & 0x7F;\n    return o;\n}\nfunction parse_CellXF(blob, length) {return parse_CellStyleXF(blob,length,0);}\nfunction parse_StyleXF(blob, length) {return parse_CellStyleXF(blob,length,1);}\n\n/* 2.4.353 TODO: actually do this right */\nfunction parse_XF(blob, length) {\n    var o = {};\n    o.ifnt = blob.read_shift(2); o.ifmt = blob.read_shift(2); o.flags = blob.read_shift(2);\n    o.fStyle = (o.flags >> 2) & 0x01;\n    length -= 6;\n    o.data = parse_CellStyleXF(blob, length, o.fStyle);\n    return o;\n}\n\n/* 2.4.134 */\nfunction parse_Guts(blob, length) {\n    blob.l += 4;\n    var out = [blob.read_shift(2), blob.read_shift(2)];\n    if(out[0] !== 0) out[0]--;\n    if(out[1] !== 0) out[1]--;\n    if(out[0] > 7 || out[1] > 7) throw \"Bad Gutters: \" + out;\n    return out;\n}\n\n/* 2.4.24 */\nfunction parse_BoolErr(blob, length) {\n    var cell = parse_XLSCell(blob, 6);\n    var val = parse_Bes(blob, 2);\n    cell.val = val;\n    cell.t = (val === true || val === false) ? 'b' : 'e';\n    return cell;\n}\n\n/* 2.4.180 Number */\nfunction parse_Number(blob, length) {\n    var cell = parse_XLSCell(blob, 6);\n    var xnum = parse_Xnum(blob, 8);\n    cell.val = xnum;\n    return cell;\n}\n\nvar parse_XLHeaderFooter = parse_OptXLUnicodeString; // TODO: parse 2.4.136\n\n/* 2.4.271 */\nfunction parse_SupBook(blob, length, opts) {\n    var end = blob.l + length;\n    var ctab = blob.read_shift(2);\n    var cch = blob.read_shift(2);\n    var virtPath;\n    if(cch >=0x01 && cch <=0xff) virtPath = parse_XLUnicodeStringNoCch(blob, cch);\n    var rgst = blob.read_shift(end - blob.l);\n    opts.sbcch = cch;\n    return [cch, ctab, virtPath, rgst];\n}\n\n/* 2.4.105 TODO */\nfunction parse_ExternName(blob, length, opts) {\n    var flags = blob.read_shift(2);\n    var body;\n    var o = {\n        fBuiltIn: flags & 0x01,\n        fWantAdvise: (flags >>> 1) & 0x01,\n        fWantPict: (flags >>> 2) & 0x01,\n        fOle: (flags >>> 3) & 0x01,\n        fOleLink: (flags >>> 4) & 0x01,\n        cf: (flags >>> 5) & 0x3FF,\n        fIcon: flags >>> 15 & 0x01\n    };\n    if(opts.sbcch === 0x3A01) body = parse_AddinUdf(blob, length-2);\n    //else throw new Error(\"unsupported SupBook cch: \" + opts.sbcch);\n    o.body = body || blob.read_shift(length-2);\n    return o;\n}\n\n/* 2.4.150 TODO */\nfunction parse_Lbl(blob, length, opts) {\n    if(opts.biff < 8) return parse_Label(blob, length, opts);\n    var target = blob.l + length;\n    var flags = blob.read_shift(2);\n    var chKey = blob.read_shift(1);\n    var cch = blob.read_shift(1);\n    var cce = blob.read_shift(2);\n    blob.l += 2;\n    var itab = blob.read_shift(2);\n    blob.l += 4;\n    var name = parse_XLUnicodeStringNoCch(blob, cch, opts);\n    var rgce = parse_NameParsedFormula(blob, target - blob.l, opts, cce);\n    return {\n        chKey: chKey,\n        Name: name,\n        rgce: rgce\n    };\n}\n\n/* 2.4.106 TODO: verify supbook manipulation */\nfunction parse_ExternSheet(blob, length, opts) {\n    if(opts.biff < 8) return parse_ShortXLUnicodeString(blob, length, opts);\n    var o = parslurp2(blob,length,parse_XTI);\n    var oo = [];\n    if(opts.sbcch === 0x0401) {\n        for(var i = 0; i != o.length; ++i) oo.push(opts.snames[o[i][1]]);\n        return oo;\n    }\n    else return o;\n}\n\n/* 2.4.260 */\nfunction parse_ShrFmla(blob, length, opts) {\n    var ref = parse_RefU(blob, 6);\n    blob.l++;\n    var cUse = blob.read_shift(1);\n    length -= 8;\n    return [parse_SharedParsedFormula(blob, length, opts), cUse];\n}\n\n/* 2.4.4 TODO */\nfunction parse_Array(blob, length, opts) {\n    var ref = parse_Ref(blob, 6);\n    blob.l += 6; length -= 12; /* TODO: fAlwaysCalc */\n    return [ref, parse_ArrayParsedFormula(blob, length, opts, ref)];\n}\n\n/* 2.4.173 */\nfunction parse_MTRSettings(blob, length) {\n    var fMTREnabled = blob.read_shift(4) !== 0x00;\n    var fUserSetThreadCount = blob.read_shift(4) !== 0x00;\n    var cUserThreadCount = blob.read_shift(4);\n    return [fMTREnabled, fUserSetThreadCount, cUserThreadCount];\n}\n\n/* 2.5.186 TODO: BIFF5 */\nfunction parse_NoteSh(blob, length, opts) {\n    if(opts.biff < 8) return;\n    var row = blob.read_shift(2), col = blob.read_shift(2);\n    var flags = blob.read_shift(2), idObj = blob.read_shift(2);\n    var stAuthor = parse_XLUnicodeString2(blob, 0, opts);\n    if(opts.biff < 8) blob.read_shift(1);\n    return [{r:row,c:col}, stAuthor, idObj, flags];\n}\n\n/* 2.4.179 */\nfunction parse_Note(blob, length, opts) {\n    /* TODO: Support revisions */\n    return parse_NoteSh(blob, length, opts);\n}\n\n/* 2.4.168 */\nfunction parse_MergeCells(blob, length) {\n    var merges = [];\n    var cmcs = blob.read_shift(2);\n    while (cmcs--) merges.push(parse_Ref8U(blob,length));\n    return merges;\n}\n\n/* 2.4.181 TODO: parse all the things! */\nfunction parse_Obj(blob, length) {\n    var cmo = parse_FtCmo(blob, 22); // id, ot, flags\n    var fts = parse_FtArray(blob, length-22, cmo[1]);\n    return { cmo: cmo, ft:fts };\n}\n\n/* 2.4.329 TODO: parse properly */\nfunction parse_TxO(blob, length, opts) {\n    var s = blob.l;\ntry {\n    blob.l += 4;\n    var ot = (opts.lastobj||{cmo:[0,0]}).cmo[1];\n    var controlInfo;\n    if([0,5,7,11,12,14].indexOf(ot) == -1) blob.l += 6;\n    else controlInfo = parse_ControlInfo(blob, 6, opts);\n    var cchText = blob.read_shift(2);\n    var cbRuns = blob.read_shift(2);\n    var ifntEmpty = parse_FontIndex(blob, 2);\n    var len = blob.read_shift(2);\n    blob.l += len;\n    //var fmla = parse_ObjFmla(blob, s + length - blob.l);\n\n    var texts = \"\";\n    for(var i = 1; i < blob.lens.length-1; ++i) {\n        if(blob.l-s != blob.lens[i]) throw \"TxO: bad continue record\";\n        var hdr = blob[blob.l];\n        var t = parse_XLUnicodeStringNoCch(blob, blob.lens[i+1]-blob.lens[i]-1);\n        texts += t;\n        if(texts.length >= (hdr ? cchText : 2*cchText)) break;\n    }\n    if(texts.length !== cchText && texts.length !== cchText*2) {\n        throw \"cchText: \" + cchText + \" != \" + texts.length;\n    }\n\n    blob.l = s + length;\n    /* 2.5.272 TxORuns */\n//  var rgTxoRuns = [];\n//  for(var j = 0; j != cbRuns/8-1; ++j) blob.l += 8;\n//  var cchText2 = blob.read_shift(2);\n//  if(cchText2 !== cchText) throw \"TxOLastRun mismatch: \" + cchText2 + \" \" + cchText;\n//  blob.l += 6;\n//  if(s + length != blob.l) throw \"TxO \" + (s + length) + \", at \" + blob.l;\n    return { t: texts };\n} catch(e) { blob.l = s + length; return { t: texts||\"\" }; }\n}\n\n/* 2.4.140 */\nvar parse_HLink = function(blob, length) {\n    var ref = parse_Ref8U(blob, 8);\n    blob.l += 16; /* CLSID */\n    var hlink = parse_Hyperlink(blob, length-24);\n    return [ref, hlink];\n};\n\n/* 2.4.141 */\nvar parse_HLinkTooltip = function(blob, length) {\n    var end = blob.l + length;\n    blob.read_shift(2);\n    var ref = parse_Ref8U(blob, 8);\n    var wzTooltip = blob.read_shift((length-10)/2, 'dbcs-cont');\n    wzTooltip = wzTooltip.replace(chr0,\"\");\n    return [ref, wzTooltip];\n};\n\n/* 2.4.63 */\nfunction parse_Country(blob, length) {\n    var o = [], d;\n    d = blob.read_shift(2); o[0] = CountryEnum[d] || d;\n    d = blob.read_shift(2); o[1] = CountryEnum[d] || d;\n    return o;\n}\n\n/* 2.4.50 ClrtClient */\nfunction parse_ClrtClient(blob, length) {\n    var ccv = blob.read_shift(2);\n    var o = [];\n    while(ccv-->0) o.push(parse_LongRGB(blob, 8));\n    return o;\n}\n\n/* 2.4.188 */\nfunction parse_Palette(blob, length) {\n    var ccv = blob.read_shift(2);\n    var o = [];\n    while(ccv-->0) o.push(parse_LongRGB(blob, 8));\n    return o;\n}\n\n/* 2.4.354 */\nfunction parse_XFCRC(blob, length) {\n    blob.l += 2;\n    var o = {cxfs:0, crc:0};\n    o.cxfs = blob.read_shift(2);\n    o.crc = blob.read_shift(4);\n    return o;\n}\n\n\nvar parse_Style = parsenoop;\nvar parse_StyleExt = parsenoop;\n\nvar parse_ColInfo = parsenoop;\n\nvar parse_Window2 = parsenoop;\n\n\nvar parse_Backup = parsebool; /* 2.4.14 */\nvar parse_Blank = parse_XLSCell; /* 2.4.20 Just the cell */\nvar parse_BottomMargin = parse_Xnum; /* 2.4.27 */\nvar parse_BuiltInFnGroupCount = parseuint16; /* 2.4.30 0x0E or 0x10 but excel 2011 generates 0x11? */\nvar parse_CalcCount = parseuint16; /* 2.4.31 #Iterations */\nvar parse_CalcDelta = parse_Xnum; /* 2.4.32 */\nvar parse_CalcIter = parsebool;  /* 2.4.33 1=iterative calc */\nvar parse_CalcMode = parseuint16; /* 2.4.34 0=manual, 1=auto (def), 2=table */\nvar parse_CalcPrecision = parsebool; /* 2.4.35 */\nvar parse_CalcRefMode = parsenoop2; /* 2.4.36 */\nvar parse_CalcSaveRecalc = parsebool; /* 2.4.37 */\nvar parse_CodePage = parseuint16; /* 2.4.52 */\nvar parse_Compat12 = parsebool; /* 2.4.54 true = no compatibility check */\nvar parse_Date1904 = parsebool; /* 2.4.77 - 1=1904,0=1900 */\nvar parse_DefColWidth = parseuint16; /* 2.4.89 */\nvar parse_DSF = parsenoop2; /* 2.4.94 -- MUST be ignored */\nvar parse_EntExU2 = parsenoop2; /* 2.4.102 -- Explicitly says to ignore */\nvar parse_EOF = parsenoop2; /* 2.4.103 */\nvar parse_Excel9File = parsenoop2; /* 2.4.104 -- Optional and unused */\nvar parse_FeatHdr = parsenoop2; /* 2.4.112 */\nvar parse_FontX = parseuint16; /* 2.4.123 */\nvar parse_Footer = parse_XLHeaderFooter; /* 2.4.124 */\nvar parse_GridSet = parseuint16; /* 2.4.132, =1 */\nvar parse_HCenter = parsebool; /* 2.4.135 sheet centered horizontal on print */\nvar parse_Header = parse_XLHeaderFooter; /* 2.4.136 */\nvar parse_HideObj = parse_HideObjEnum; /* 2.4.139 */\nvar parse_InterfaceEnd = parsenoop2; /* 2.4.145 -- noop */\nvar parse_LeftMargin = parse_Xnum; /* 2.4.151 */\nvar parse_Mms = parsenoop2; /* 2.4.169 -- Explicitly says to ignore */\nvar parse_ObjProtect = parsebool; /* 2.4.183 -- must be 1 if present */\nvar parse_Password = parseuint16; /* 2.4.191 */\nvar parse_PrintGrid = parsebool; /* 2.4.202 */\nvar parse_PrintRowCol = parsebool; /* 2.4.203 */\nvar parse_PrintSize = parseuint16; /* 2.4.204 0:3 */\nvar parse_Prot4Rev = parsebool; /* 2.4.205 */\nvar parse_Prot4RevPass = parseuint16; /* 2.4.206 */\nvar parse_Protect = parsebool; /* 2.4.207 */\nvar parse_RefreshAll = parsebool; /* 2.4.217 -- must be 0 if not template */\nvar parse_RightMargin = parse_Xnum; /* 2.4.219 */\nvar parse_RRTabId = parseuint16a; /* 2.4.241 */\nvar parse_ScenarioProtect = parsebool; /* 2.4.245 */\nvar parse_Scl = parseuint16a; /* 2.4.247 num, den */\nvar parse_String = parse_XLUnicodeString; /* 2.4.268 */\nvar parse_SxBool = parsebool; /* 2.4.274 */\nvar parse_TopMargin = parse_Xnum; /* 2.4.328 */\nvar parse_UsesELFs = parsebool; /* 2.4.337 -- should be 0 */\nvar parse_VCenter = parsebool; /* 2.4.342 */\nvar parse_WinProtect = parsebool; /* 2.4.347 */\nvar parse_WriteProtect = parsenoop; /* 2.4.350 empty record */\n\n\n/* ---- */\nvar parse_VerticalPageBreaks = parsenoop;\nvar parse_HorizontalPageBreaks = parsenoop;\nvar parse_Selection = parsenoop;\nvar parse_Continue = parsenoop;\nvar parse_Pane = parsenoop;\nvar parse_Pls = parsenoop;\nvar parse_DCon = parsenoop;\nvar parse_DConRef = parsenoop;\nvar parse_DConName = parsenoop;\nvar parse_XCT = parsenoop;\nvar parse_CRN = parsenoop;\nvar parse_FileSharing = parsenoop;\nvar parse_Uncalced = parsenoop;\nvar parse_Template = parsenoop;\nvar parse_Intl = parsenoop;\nvar parse_WsBool = parsenoop;\nvar parse_Sort = parsenoop;\nvar parse_Sync = parsenoop;\nvar parse_LPr = parsenoop;\nvar parse_DxGCol = parsenoop;\nvar parse_FnGroupName = parsenoop;\nvar parse_FilterMode = parsenoop;\nvar parse_AutoFilterInfo = parsenoop;\nvar parse_AutoFilter = parsenoop;\nvar parse_Setup = parsenoop;\nvar parse_ScenMan = parsenoop;\nvar parse_SCENARIO = parsenoop;\nvar parse_SxView = parsenoop;\nvar parse_Sxvd = parsenoop;\nvar parse_SXVI = parsenoop;\nvar parse_SxIvd = parsenoop;\nvar parse_SXLI = parsenoop;\nvar parse_SXPI = parsenoop;\nvar parse_DocRoute = parsenoop;\nvar parse_RecipName = parsenoop;\nvar parse_MulBlank = parsenoop;\nvar parse_SXDI = parsenoop;\nvar parse_SXDB = parsenoop;\nvar parse_SXFDB = parsenoop;\nvar parse_SXDBB = parsenoop;\nvar parse_SXNum = parsenoop;\nvar parse_SxErr = parsenoop;\nvar parse_SXInt = parsenoop;\nvar parse_SXString = parsenoop;\nvar parse_SXDtr = parsenoop;\nvar parse_SxNil = parsenoop;\nvar parse_SXTbl = parsenoop;\nvar parse_SXTBRGIITM = parsenoop;\nvar parse_SxTbpg = parsenoop;\nvar parse_ObProj = parsenoop;\nvar parse_SXStreamID = parsenoop;\nvar parse_DBCell = parsenoop;\nvar parse_SXRng = parsenoop;\nvar parse_SxIsxoper = parsenoop;\nvar parse_BookBool = parsenoop;\nvar parse_DbOrParamQry = parsenoop;\nvar parse_OleObjectSize = parsenoop;\nvar parse_SXVS = parsenoop;\nvar parse_BkHim = parsenoop;\nvar parse_MsoDrawingGroup = parsenoop;\nvar parse_MsoDrawing = parsenoop;\nvar parse_MsoDrawingSelection = parsenoop;\nvar parse_PhoneticInfo = parsenoop;\nvar parse_SxRule = parsenoop;\nvar parse_SXEx = parsenoop;\nvar parse_SxFilt = parsenoop;\nvar parse_SxDXF = parsenoop;\nvar parse_SxItm = parsenoop;\nvar parse_SxName = parsenoop;\nvar parse_SxSelect = parsenoop;\nvar parse_SXPair = parsenoop;\nvar parse_SxFmla = parsenoop;\nvar parse_SxFormat = parsenoop;\nvar parse_SXVDEx = parsenoop;\nvar parse_SXFormula = parsenoop;\nvar parse_SXDBEx = parsenoop;\nvar parse_RRDInsDel = parsenoop;\nvar parse_RRDHead = parsenoop;\nvar parse_RRDChgCell = parsenoop;\nvar parse_RRDRenSheet = parsenoop;\nvar parse_RRSort = parsenoop;\nvar parse_RRDMove = parsenoop;\nvar parse_RRFormat = parsenoop;\nvar parse_RRAutoFmt = parsenoop;\nvar parse_RRInsertSh = parsenoop;\nvar parse_RRDMoveBegin = parsenoop;\nvar parse_RRDMoveEnd = parsenoop;\nvar parse_RRDInsDelBegin = parsenoop;\nvar parse_RRDInsDelEnd = parsenoop;\nvar parse_RRDConflict = parsenoop;\nvar parse_RRDDefName = parsenoop;\nvar parse_RRDRstEtxp = parsenoop;\nvar parse_LRng = parsenoop;\nvar parse_CUsr = parsenoop;\nvar parse_CbUsr = parsenoop;\nvar parse_UsrInfo = parsenoop;\nvar parse_UsrExcl = parsenoop;\nvar parse_FileLock = parsenoop;\nvar parse_RRDInfo = parsenoop;\nvar parse_BCUsrs = parsenoop;\nvar parse_UsrChk = parsenoop;\nvar parse_UserBView = parsenoop;\nvar parse_UserSViewBegin = parsenoop; // overloaded\nvar parse_UserSViewEnd = parsenoop;\nvar parse_RRDUserView = parsenoop;\nvar parse_Qsi = parsenoop;\nvar parse_CondFmt = parsenoop;\nvar parse_CF = parsenoop;\nvar parse_DVal = parsenoop;\nvar parse_DConBin = parsenoop;\nvar parse_Lel = parsenoop;\nvar parse_XLSCodeName = parse_XLUnicodeString;\nvar parse_SXFDBType = parsenoop;\nvar parse_ObNoMacros = parsenoop;\nvar parse_Dv = parsenoop;\nvar parse_Index = parsenoop;\nvar parse_Table = parsenoop;\nvar parse_BigName = parsenoop;\nvar parse_ContinueBigName = parsenoop;\nvar parse_WebPub = parsenoop;\nvar parse_QsiSXTag = parsenoop;\nvar parse_DBQueryExt = parsenoop;\nvar parse_ExtString = parsenoop;\nvar parse_TxtQry = parsenoop;\nvar parse_Qsir = parsenoop;\nvar parse_Qsif = parsenoop;\nvar parse_RRDTQSIF = parsenoop;\nvar parse_OleDbConn = parsenoop;\nvar parse_WOpt = parsenoop;\nvar parse_SXViewEx = parsenoop;\nvar parse_SXTH = parsenoop;\nvar parse_SXPIEx = parsenoop;\nvar parse_SXVDTEx = parsenoop;\nvar parse_SXViewEx9 = parsenoop;\nvar parse_ContinueFrt = parsenoop;\nvar parse_RealTimeData = parsenoop;\nvar parse_ChartFrtInfo = parsenoop;\nvar parse_FrtWrapper = parsenoop;\nvar parse_StartBlock = parsenoop;\nvar parse_EndBlock = parsenoop;\nvar parse_StartObject = parsenoop;\nvar parse_EndObject = parsenoop;\nvar parse_CatLab = parsenoop;\nvar parse_YMult = parsenoop;\nvar parse_SXViewLink = parsenoop;\nvar parse_PivotChartBits = parsenoop;\nvar parse_FrtFontList = parsenoop;\nvar parse_SheetExt = parsenoop;\nvar parse_BookExt = parsenoop;\nvar parse_SXAddl = parsenoop;\nvar parse_CrErr = parsenoop;\nvar parse_HFPicture = parsenoop;\nvar parse_Feat = parsenoop;\nvar parse_DataLabExt = parsenoop;\nvar parse_DataLabExtContents = parsenoop;\nvar parse_CellWatch = parsenoop;\nvar parse_FeatHdr11 = parsenoop;\nvar parse_Feature11 = parsenoop;\nvar parse_DropDownObjIds = parsenoop;\nvar parse_ContinueFrt11 = parsenoop;\nvar parse_DConn = parsenoop;\nvar parse_List12 = parsenoop;\nvar parse_Feature12 = parsenoop;\nvar parse_CondFmt12 = parsenoop;\nvar parse_CF12 = parsenoop;\nvar parse_CFEx = parsenoop;\nvar parse_AutoFilter12 = parsenoop;\nvar parse_ContinueFrt12 = parsenoop;\nvar parse_MDTInfo = parsenoop;\nvar parse_MDXStr = parsenoop;\nvar parse_MDXTuple = parsenoop;\nvar parse_MDXSet = parsenoop;\nvar parse_MDXProp = parsenoop;\nvar parse_MDXKPI = parsenoop;\nvar parse_MDB = parsenoop;\nvar parse_PLV = parsenoop;\nvar parse_DXF = parsenoop;\nvar parse_TableStyles = parsenoop;\nvar parse_TableStyle = parsenoop;\nvar parse_TableStyleElement = parsenoop;\nvar parse_NamePublish = parsenoop;\nvar parse_NameCmt = parsenoop;\nvar parse_SortData = parsenoop;\nvar parse_GUIDTypeLib = parsenoop;\nvar parse_FnGrp12 = parsenoop;\nvar parse_NameFnGrp12 = parsenoop;\nvar parse_HeaderFooter = parsenoop;\nvar parse_CrtLayout12 = parsenoop;\nvar parse_CrtMlFrt = parsenoop;\nvar parse_CrtMlFrtContinue = parsenoop;\nvar parse_ShapePropsStream = parsenoop;\nvar parse_TextPropsStream = parsenoop;\nvar parse_RichTextStream = parsenoop;\nvar parse_CrtLayout12A = parsenoop;\nvar parse_Units = parsenoop;\nvar parse_Chart = parsenoop;\nvar parse_Series = parsenoop;\nvar parse_DataFormat = parsenoop;\nvar parse_LineFormat = parsenoop;\nvar parse_MarkerFormat = parsenoop;\nvar parse_AreaFormat = parsenoop;\nvar parse_PieFormat = parsenoop;\nvar parse_AttachedLabel = parsenoop;\nvar parse_SeriesText = parsenoop;\nvar parse_ChartFormat = parsenoop;\nvar parse_Legend = parsenoop;\nvar parse_SeriesList = parsenoop;\nvar parse_Bar = parsenoop;\nvar parse_Line = parsenoop;\nvar parse_Pie = parsenoop;\nvar parse_Area = parsenoop;\nvar parse_Scatter = parsenoop;\nvar parse_CrtLine = parsenoop;\nvar parse_Axis = parsenoop;\nvar parse_Tick = parsenoop;\nvar parse_ValueRange = parsenoop;\nvar parse_CatSerRange = parsenoop;\nvar parse_AxisLine = parsenoop;\nvar parse_CrtLink = parsenoop;\nvar parse_DefaultText = parsenoop;\nvar parse_Text = parsenoop;\nvar parse_ObjectLink = parsenoop;\nvar parse_Frame = parsenoop;\nvar parse_Begin = parsenoop;\nvar parse_End = parsenoop;\nvar parse_PlotArea = parsenoop;\nvar parse_Chart3d = parsenoop;\nvar parse_PicF = parsenoop;\nvar parse_DropBar = parsenoop;\nvar parse_Radar = parsenoop;\nvar parse_Surf = parsenoop;\nvar parse_RadarArea = parsenoop;\nvar parse_AxisParent = parsenoop;\nvar parse_LegendException = parsenoop;\nvar parse_ShtProps = parsenoop;\nvar parse_SerToCrt = parsenoop;\nvar parse_AxesUsed = parsenoop;\nvar parse_SBaseRef = parsenoop;\nvar parse_SerParent = parsenoop;\nvar parse_SerAuxTrend = parsenoop;\nvar parse_IFmtRecord = parsenoop;\nvar parse_Pos = parsenoop;\nvar parse_AlRuns = parsenoop;\nvar parse_BRAI = parsenoop;\nvar parse_SerAuxErrBar = parsenoop;\nvar parse_SerFmt = parsenoop;\nvar parse_Chart3DBarShape = parsenoop;\nvar parse_Fbi = parsenoop;\nvar parse_BopPop = parsenoop;\nvar parse_AxcExt = parsenoop;\nvar parse_Dat = parsenoop;\nvar parse_PlotGrowth = parsenoop;\nvar parse_SIIndex = parsenoop;\nvar parse_GelFrame = parsenoop;\nvar parse_BopPopCustom = parsenoop;\nvar parse_Fbi2 = parsenoop;\n\n/* --- Specific to versions before BIFF8 --- */\nfunction parse_BIFF5String(blob) {\n    var len = blob.read_shift(1);\n    return blob.read_shift(len, 'sbcs-cont');\n}\n\n/* BIFF2_??? where ??? is the name from [XLS] */\nfunction parse_BIFF2STR(blob, length, opts) {\n    var cell = parse_XLSCell(blob, 6);\n    ++blob.l;\n    var str = parse_XLUnicodeString2(blob, length-7, opts);\n    cell.val = str;\n    return cell;\n}\n\nfunction parse_BIFF2NUM(blob, length, opts) {\n    var cell = parse_XLSCell(blob, 6);\n    ++blob.l;\n    var num = parse_Xnum(blob, 8);\n    cell.val = num;\n    return cell;\n}\n\n/* 18.4.1 charset to codepage mapping */\nvar CS2CP = {\n    0:    1252, /* ANSI */\n    1:   65001, /* DEFAULT */\n    2:   65001, /* SYMBOL */\n    77:  10000, /* MAC */\n    128:   932, /* SHIFTJIS */\n    129:   949, /* HANGUL */\n    130:  1361, /* JOHAB */\n    134:   936, /* GB2312 */\n    136:   950, /* CHINESEBIG5 */\n    161:  1253, /* GREEK */\n    162:  1254, /* TURKISH */\n    163:  1258, /* VIETNAMESE */\n    177:  1255, /* HEBREW */\n    178:  1256, /* ARABIC */\n    186:  1257, /* BALTIC */\n    204:  1251, /* RUSSIAN */\n    222:   874, /* THAI */\n    238:  1250, /* EASTEUROPE */\n    255:  1252, /* OEM */\n    69:   6969  /* MISC */\n};\n\n/* Parse a list of <r> tags */\nvar parse_rs = (function parse_rs_factory() {\n    var tregex = matchtag(\"t\"), rpregex = matchtag(\"rPr\"), rregex = /<r>/g, rend = /<\\/r>/, nlregex = /\\r\\n/g;\n    /* 18.4.7 rPr CT_RPrElt */\n    var parse_rpr = function parse_rpr(rpr, intro, outro) {\n        var font = {}, cp = 65001;\n        var m = rpr.match(tagregex), i = 0;\n        if(m) for(;i!=m.length; ++i) {\n            var y = parsexmltag(m[i]);\n            switch(y[0]) {\n                /* 18.8.12 condense CT_BooleanProperty */\n                /* ** not required . */\n                case '<condense': break;\n                /* 18.8.17 extend CT_BooleanProperty */\n                /* ** not required . */\n                case '<extend': break;\n                /* 18.8.36 shadow CT_BooleanProperty */\n                /* ** not required . */\n                case '<shadow':\n                    /* falls through */\n                case '<shadow/>': break;\n\n                /* 18.4.1 charset CT_IntProperty TODO */\n                case '<charset':\n                    if(y.val == '1') break;\n                    cp = CS2CP[parseInt(y.val, 10)];\n                    break;\n\n                /* 18.4.2 outline CT_BooleanProperty TODO */\n                case '<outline':\n                    /* falls through */\n                case '<outline/>': break;\n\n                /* 18.4.5 rFont CT_FontName */\n                case '<rFont': font.name = y.val; break;\n\n                /* 18.4.11 sz CT_FontSize */\n                case '<sz': font.sz = y.val; break;\n\n                /* 18.4.10 strike CT_BooleanProperty */\n                case '<strike':\n                    if(!y.val) break;\n                    /* falls through */\n                case '<strike/>': font.strike = 1; break;\n                case '</strike>': break;\n\n                /* 18.4.13 u CT_UnderlineProperty */\n                case '<u':\n                    if(!y.val) break;\n                    /* falls through */\n                case '<u/>': font.u = 1; break;\n                case '</u>': break;\n\n                /* 18.8.2 b */\n                case '<b':\n                    if(!y.val) break;\n                    /* falls through */\n                case '<b/>': font.b = 1; break;\n                case '</b>': break;\n\n                /* 18.8.26 i */\n                case '<i':\n                    if(!y.val) break;\n                    /* falls through */\n                case '<i/>': font.i = 1; break;\n                case '</i>': break;\n\n                /* 18.3.1.15 color CT_Color TODO: tint, theme, auto, indexed */\n                case '<color':\n                    if(y.rgb) font.color = y.rgb.substr(2,6);\n                    break;\n\n                /* 18.8.18 family ST_FontFamily */\n                case '<family': font.family = y.val; break;\n\n                /* 18.4.14 vertAlign CT_VerticalAlignFontProperty TODO */\n                case '<vertAlign': break;\n\n                /* 18.8.35 scheme CT_FontScheme TODO */\n                case '<scheme': break;\n\n                default:\n                    if(y[0].charCodeAt(1) !== 47) throw 'Unrecognized rich format ' + y[0];\n            }\n        }\n        /* TODO: These should be generated styles, not inline */\n        var style = [];\n        if(font.b) style.push(\"font-weight: bold;\");\n        if(font.i) style.push(\"font-style: italic;\");\n        intro.push('<span style=\"' + style.join(\"\") + '\">');\n        outro.push(\"</span>\");\n        return cp;\n    };\n\n    /* 18.4.4 r CT_RElt */\n    function parse_r(r) {\n        var terms = [[],\"\",[]];\n        /* 18.4.12 t ST_Xstring */\n        var t = r.match(tregex), cp = 65001;\n        if(!isval(t)) return \"\";\n        terms[1] = t[1];\n\n        var rpr = r.match(rpregex);\n        if(isval(rpr)) cp = parse_rpr(rpr[1], terms[0], terms[2]);\n\n        return terms[0].join(\"\") + terms[1].replace(nlregex,'<br/>') + terms[2].join(\"\");\n    }\n    return function parse_rs(rs) {\n        return rs.replace(rregex,\"\").split(rend).map(parse_r).join(\"\");\n    };\n})();\n\n/* 18.4.8 si CT_Rst */\nvar sitregex = /<t[^>]*>([^<]*)<\\/t>/g, sirregex = /<r>/;\nfunction parse_si(x, opts) {\n    var html = opts ? opts.cellHTML : true;\n    var z = {};\n    if(!x) return null;\n    var y;\n    /* 18.4.12 t ST_Xstring (Plaintext String) */\n    if(x.charCodeAt(1) === 116) {\n        z.t = utf8read(unescapexml(x.substr(x.indexOf(\">\")+1).split(/<\\/t>/)[0]));\n        z.r = x;\n        if(html) z.h = z.t;\n    }\n    /* 18.4.4 r CT_RElt (Rich Text Run) */\n    else if((y = x.match(sirregex))) {\n        z.r = x;\n        z.t = utf8read(unescapexml(x.match(sitregex).join(\"\").replace(tagregex,\"\")));\n        if(html) z.h = parse_rs(x);\n    }\n    /* 18.4.3 phoneticPr CT_PhoneticPr (TODO: needed for Asian support) */\n    /* 18.4.6 rPh CT_PhoneticRun (TODO: needed for Asian support) */\n    return z;\n}\n\n/* 18.4 Shared String Table */\nvar sstr0 = /<sst([^>]*)>([\\s\\S]*)<\\/sst>/;\nvar sstr1 = /<(?:si|sstItem)>/g;\nvar sstr2 = /<\\/(?:si|sstItem)>/;\nfunction parse_sst_xml(data, opts) {\n    var s = [], ss;\n    /* 18.4.9 sst CT_Sst */\n    var sst = data.match(sstr0);\n    if(isval(sst)) {\n        ss = sst[2].replace(sstr1,\"\").split(sstr2);\n        for(var i = 0; i != ss.length; ++i) {\n            var o = parse_si(ss[i], opts);\n            if(o != null) s[s.length] = o;\n        }\n        sst = parsexmltag(sst[1]); s.Count = sst.count; s.Unique = sst.uniqueCount;\n    }\n    return s;\n}\n\nRELS.SST = \"http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings\";\nvar straywsregex = /^\\s|\\s$|[\\t\\n\\r]/;\nfunction write_sst_xml(sst, opts) {\n    if(!opts.bookSST) return \"\";\n    var o = [XML_HEADER];\n    o[o.length] = (writextag('sst', null, {\n        xmlns: XMLNS.main[0],\n        count: sst.Count,\n        uniqueCount: sst.Unique\n    }));\n    for(var i = 0; i != sst.length; ++i) { if(sst[i] == null) continue;\n        var s = sst[i];\n        var sitag = \"<si>\";\n        if(s.r) sitag += s.r;\n        else {\n            sitag += \"<t\";\n            if(s.t.match(straywsregex)) sitag += ' xml:space=\"preserve\"';\n            sitag += \">\" + escapexml(s.t) + \"</t>\";\n        }\n        sitag += \"</si>\";\n        o[o.length] = (sitag);\n    }\n    if(o.length>2){ o[o.length] = ('</sst>'); o[1]=o[1].replace(\"/>\",\">\"); }\n    return o.join(\"\");\n}\n/* [MS-XLSB] 2.4.219 BrtBeginSst */\nfunction parse_BrtBeginSst(data, length) {\n    return [data.read_shift(4), data.read_shift(4)];\n}\n\n/* [MS-XLSB] 2.1.7.45 Shared Strings */\nfunction parse_sst_bin(data, opts) {\n    var s = [];\n    var pass = false;\n    recordhopper(data, function hopper_sst(val, R, RT) {\n        switch(R.n) {\n            case 'BrtBeginSst': s.Count = val[0]; s.Unique = val[1]; break;\n            case 'BrtSSTItem': s.push(val); break;\n            case 'BrtEndSst': return true;\n            /* TODO: produce a test case with a future record */\n            case 'BrtFRTBegin': pass = true; break;\n            case 'BrtFRTEnd': pass = false; break;\n            default: if(!pass || opts.WTF) throw new Error(\"Unexpected record \" + RT + \" \" + R.n);\n        }\n    });\n    return s;\n}\n\nfunction write_BrtBeginSst(sst, o) {\n    if(!o) o = new_buf(8);\n    o.write_shift(4, sst.Count);\n    o.write_shift(4, sst.Unique);\n    return o;\n}\n\nvar write_BrtSSTItem = write_RichStr;\n\nfunction write_sst_bin(sst, opts) {\n    var ba = buf_array();\n    write_record(ba, \"BrtBeginSst\", write_BrtBeginSst(sst));\n    for(var i = 0; i < sst.length; ++i) write_record(ba, \"BrtSSTItem\", write_BrtSSTItem(sst[i]));\n    write_record(ba, \"BrtEndSst\");\n    return ba.end();\n}\nfunction _JS2ANSI(str) { if(typeof cptable !== 'undefined') return cptable.utils.encode(1252, str); return str.split(\"\").map(function(x) { return x.charCodeAt(0); }); }\n\n/* [MS-OFFCRYPTO] 2.1.4 Version */\nfunction parse_Version(blob, length) {\n    var o = {};\n    o.Major = blob.read_shift(2);\n    o.Minor = blob.read_shift(2);\n    return o;\n}\n/* [MS-OFFCRYPTO] 2.3.2 Encryption Header */\nfunction parse_EncryptionHeader(blob, length) {\n    var o = {};\n    o.Flags = blob.read_shift(4);\n\n    // Check if SizeExtra is 0x00000000\n    var tmp = blob.read_shift(4);\n    if(tmp !== 0) throw 'Unrecognized SizeExtra: ' + tmp;\n\n    o.AlgID = blob.read_shift(4);\n    switch(o.AlgID) {\n        case 0: case 0x6801: case 0x660E: case 0x660F: case 0x6610: break;\n        default: throw 'Unrecognized encryption algorithm: ' + o.AlgID;\n    }\n    parsenoop(blob, length-12);\n    return o;\n}\n\n/* [MS-OFFCRYPTO] 2.3.3 Encryption Verifier */\nfunction parse_EncryptionVerifier(blob, length) {\n    return parsenoop(blob, length);\n}\n/* [MS-OFFCRYPTO] 2.3.5.1 RC4 CryptoAPI Encryption Header */\nfunction parse_RC4CryptoHeader(blob, length) {\n    var o = {};\n    var vers = o.EncryptionVersionInfo = parse_Version(blob, 4); length -= 4;\n    if(vers.Minor != 2) throw 'unrecognized minor version code: ' + vers.Minor;\n    if(vers.Major > 4 || vers.Major < 2) throw 'unrecognized major version code: ' + vers.Major;\n    o.Flags = blob.read_shift(4); length -= 4;\n    var sz = blob.read_shift(4); length -= 4;\n    o.EncryptionHeader = parse_EncryptionHeader(blob, sz); length -= sz;\n    o.EncryptionVerifier = parse_EncryptionVerifier(blob, length);\n    return o;\n}\n/* [MS-OFFCRYPTO] 2.3.6.1 RC4 Encryption Header */\nfunction parse_RC4Header(blob, length) {\n    var o = {};\n    var vers = o.EncryptionVersionInfo = parse_Version(blob, 4); length -= 4;\n    if(vers.Major != 1 || vers.Minor != 1) throw 'unrecognized version code ' + vers.Major + ' : ' + vers.Minor;\n    o.Salt = blob.read_shift(16);\n    o.EncryptedVerifier = blob.read_shift(16);\n    o.EncryptedVerifierHash = blob.read_shift(16);\n    return o;\n}\n\n/* [MS-OFFCRYPTO] 2.3.7.1 Binary Document Password Verifier Derivation */\nfunction crypto_CreatePasswordVerifier_Method1(Password) {\n    var Verifier = 0x0000, PasswordArray;\n    var PasswordDecoded = _JS2ANSI(Password);\n    var len = PasswordDecoded.length + 1, i, PasswordByte;\n    var Intermediate1, Intermediate2, Intermediate3;\n    PasswordArray = new_raw_buf(len);\n    PasswordArray[0] = PasswordDecoded.length;\n    for(i = 1; i != len; ++i) PasswordArray[i] = PasswordDecoded[i-1];\n    for(i = len-1; i >= 0; --i) {\n        PasswordByte = PasswordArray[i];\n        Intermediate1 = ((Verifier & 0x4000) === 0x0000) ? 0 : 1;\n        Intermediate2 = (Verifier << 1) & 0x7FFF;\n        Intermediate3 = Intermediate1 | Intermediate2;\n        Verifier = Intermediate3 ^ PasswordByte;\n    }\n    return Verifier ^ 0xCE4B;\n}\n\n/* [MS-OFFCRYPTO] 2.3.7.2 Binary Document XOR Array Initialization */\nvar crypto_CreateXorArray_Method1 = (function() {\n    var PadArray = [0xBB, 0xFF, 0xFF, 0xBA, 0xFF, 0xFF, 0xB9, 0x80, 0x00, 0xBE, 0x0F, 0x00, 0xBF, 0x0F, 0x00];\n    var InitialCode = [0xE1F0, 0x1D0F, 0xCC9C, 0x84C0, 0x110C, 0x0E10, 0xF1CE, 0x313E, 0x1872, 0xE139, 0xD40F, 0x84F9, 0x280C, 0xA96A, 0x4EC3];\n    var XorMatrix = [0xAEFC, 0x4DD9, 0x9BB2, 0x2745, 0x4E8A, 0x9D14, 0x2A09, 0x7B61, 0xF6C2, 0xFDA5, 0xEB6B, 0xC6F7, 0x9DCF, 0x2BBF, 0x4563, 0x8AC6, 0x05AD, 0x0B5A, 0x16B4, 0x2D68, 0x5AD0, 0x0375, 0x06EA, 0x0DD4, 0x1BA8, 0x3750, 0x6EA0, 0xDD40, 0xD849, 0xA0B3, 0x5147, 0xA28E, 0x553D, 0xAA7A, 0x44D5, 0x6F45, 0xDE8A, 0xAD35, 0x4A4B, 0x9496, 0x390D, 0x721A, 0xEB23, 0xC667, 0x9CEF, 0x29FF, 0x53FE, 0xA7FC, 0x5FD9, 0x47D3, 0x8FA6, 0x0F6D, 0x1EDA, 0x3DB4, 0x7B68, 0xF6D0, 0xB861, 0x60E3, 0xC1C6, 0x93AD, 0x377B, 0x6EF6, 0xDDEC, 0x45A0, 0x8B40, 0x06A1, 0x0D42, 0x1A84, 0x3508, 0x6A10, 0xAA51, 0x4483, 0x8906, 0x022D, 0x045A, 0x08B4, 0x1168, 0x76B4, 0xED68, 0xCAF1, 0x85C3, 0x1BA7, 0x374E, 0x6E9C, 0x3730, 0x6E60, 0xDCC0, 0xA9A1, 0x4363, 0x86C6, 0x1DAD, 0x3331, 0x6662, 0xCCC4, 0x89A9, 0x0373, 0x06E6, 0x0DCC, 0x1021, 0x2042, 0x4084, 0x8108, 0x1231, 0x2462, 0x48C4];\n    var Ror = function(Byte) { return ((Byte/2) | (Byte*128)) & 0xFF; };\n    var XorRor = function(byte1, byte2) { return Ror(byte1 ^ byte2); };\n    var CreateXorKey_Method1 = function(Password) {\n        var XorKey = InitialCode[Password.length - 1];\n        var CurrentElement = 0x68;\n        for(var i = Password.length-1; i >= 0; --i) {\n            var Char = Password[i];\n            for(var j = 0; j != 7; ++j) {\n                if(Char & 0x40) XorKey ^= XorMatrix[CurrentElement];\n                Char *= 2; --CurrentElement;\n            }\n        }\n        return XorKey;\n    };\n    return function(password) {\n        var Password = _JS2ANSI(password);\n        var XorKey = CreateXorKey_Method1(Password);\n        var Index = Password.length;\n        var ObfuscationArray = new_raw_buf(16);\n        for(var i = 0; i != 16; ++i) ObfuscationArray[i] = 0x00;\n        var Temp, PasswordLastChar, PadIndex;\n        if((Index & 1) === 1) {\n            Temp = XorKey >> 8;\n            ObfuscationArray[Index] = XorRor(PadArray[0], Temp);\n            --Index;\n            Temp = XorKey & 0xFF;\n            PasswordLastChar = Password[Password.length - 1];\n            ObfuscationArray[Index] = XorRor(PasswordLastChar, Temp);\n        }\n        while(Index > 0) {\n            --Index;\n            Temp = XorKey >> 8;\n            ObfuscationArray[Index] = XorRor(Password[Index], Temp);\n            --Index;\n            Temp = XorKey & 0xFF;\n            ObfuscationArray[Index] = XorRor(Password[Index], Temp);\n        }\n        Index = 15;\n        PadIndex = 15 - Password.length;\n        while(PadIndex > 0) {\n            Temp = XorKey >> 8;\n            ObfuscationArray[Index] = XorRor(PadArray[PadIndex], Temp);\n            --Index;\n            --PadIndex;\n            Temp = XorKey & 0xFF;\n            ObfuscationArray[Index] = XorRor(Password[Index], Temp);\n            --Index;\n            --PadIndex;\n        }\n        return ObfuscationArray;\n    };\n})();\n\n/* [MS-OFFCRYPTO] 2.3.7.3 Binary Document XOR Data Transformation Method 1 */\nvar crypto_DecryptData_Method1 = function(password, Data, XorArrayIndex, XorArray, O) {\n    /* If XorArray is set, use it; if O is not set, make changes in-place */\n    if(!O) O = Data;\n    if(!XorArray) XorArray = crypto_CreateXorArray_Method1(password);\n    var Index, Value;\n    for(Index = 0; Index != Data.length; ++Index) {\n        Value = Data[Index];\n        Value ^= XorArray[XorArrayIndex];\n        Value = ((Value>>5) | (Value<<3)) & 0xFF;\n        O[Index] = Value;\n        ++XorArrayIndex;\n    }\n    return [O, XorArrayIndex, XorArray];\n};\n\nvar crypto_MakeXorDecryptor = function(password) {\n    var XorArrayIndex = 0, XorArray = crypto_CreateXorArray_Method1(password);\n    return function(Data) {\n        var O = crypto_DecryptData_Method1(null, Data, XorArrayIndex, XorArray);\n        XorArrayIndex = O[1];\n        return O[0];\n    };\n};\n\n/* 2.5.343 */\nfunction parse_XORObfuscation(blob, length, opts, out) {\n    var o = { key: parseuint16(blob), verificationBytes: parseuint16(blob) };\n    if(opts.password) o.verifier = crypto_CreatePasswordVerifier_Method1(opts.password);\n    out.valid = o.verificationBytes === o.verifier;\n    if(out.valid) out.insitu_decrypt = crypto_MakeXorDecryptor(opts.password);\n    return o;\n}\n\n/* 2.4.117 */\nfunction parse_FilePassHeader(blob, length, oo) {\n    var o = oo || {}; o.Info = blob.read_shift(2); blob.l -= 2;\n    if(o.Info === 1) o.Data = parse_RC4Header(blob, length);\n    else o.Data = parse_RC4CryptoHeader(blob, length);\n    return o;\n}\nfunction parse_FilePass(blob, length, opts) {\n    var o = { Type: blob.read_shift(2) }; /* wEncryptionType */\n    if(o.Type) parse_FilePassHeader(blob, length-2, o);\n    else parse_XORObfuscation(blob, length-2, opts, o);\n    return o;\n}\n\n\nfunction hex2RGB(h) {\n    var o = h.substr(h[0]===\"#\"?1:0,6);\n    return [parseInt(o.substr(0,2),16),parseInt(o.substr(0,2),16),parseInt(o.substr(0,2),16)];\n}\nfunction rgb2Hex(rgb) {\n    for(var i=0,o=1; i!=3; ++i) o = o*256 + (rgb[i]>255?255:rgb[i]<0?0:rgb[i]);\n    return o.toString(16).toUpperCase().substr(1);\n}\n\nfunction rgb2HSL(rgb) {\n    var R = rgb[0]/255, G = rgb[1]/255, B=rgb[2]/255;\n    var M = Math.max(R, G, B), m = Math.min(R, G, B), C = M - m;\n    if(C === 0) return [0, 0, R];\n\n    var H6 = 0, S = 0, L2 = (M + m);\n    S = C / (L2 > 1 ? 2 - L2 : L2);\n    switch(M){\n        case R: H6 = ((G - B) / C + 6)%6; break;\n        case G: H6 = ((B - R) / C + 2); break;\n        case B: H6 = ((R - G) / C + 4); break;\n    }\n    return [H6 / 6, S, L2 / 2];\n}\n\nfunction hsl2RGB(hsl){\n    var H = hsl[0], S = hsl[1], L = hsl[2];\n    var C = S * 2 * (L < 0.5 ? L : 1 - L), m = L - C/2;\n    var rgb = [m,m,m], h6 = 6*H;\n\n    var X;\n    if(S !== 0) switch(h6|0) {\n        case 0: case 6: X = C * h6; rgb[0] += C; rgb[1] += X; break;\n        case 1: X = C * (2 - h6);   rgb[0] += X; rgb[1] += C; break;\n        case 2: X = C * (h6 - 2);   rgb[1] += C; rgb[2] += X; break;\n        case 3: X = C * (4 - h6);   rgb[1] += X; rgb[2] += C; break;\n        case 4: X = C * (h6 - 4);   rgb[2] += C; rgb[0] += X; break;\n        case 5: X = C * (6 - h6);   rgb[2] += X; rgb[0] += C; break;\n    }\n    for(var i = 0; i != 3; ++i) rgb[i] = Math.round(rgb[i]*255);\n    return rgb;\n}\n\n/* 18.8.3 bgColor tint algorithm */\nfunction rgb_tint(hex, tint) {\n    if(tint === 0) return hex;\n    var hsl = rgb2HSL(hex2RGB(hex));\n    if (tint < 0) hsl[2] = hsl[2] * (1 + tint);\n    else hsl[2] = 1 - (1 - hsl[2]) * (1 - tint);\n    return rgb2Hex(hsl2RGB(hsl));\n}\n\n/* 18.3.1.13 width calculations */\nvar DEF_MDW = 7, MAX_MDW = 15, MIN_MDW = 1, MDW = DEF_MDW;\nfunction width2px(width) { return (( width + ((128/MDW)|0)/256 )* MDW )|0; }\nfunction px2char(px) { return (((px - 5)/MDW * 100 + 0.5)|0)/100; }\nfunction char2width(chr) { return (((chr * MDW + 5)/MDW*256)|0)/256; }\nfunction cycle_width(collw) { return char2width(px2char(width2px(collw))); }\nfunction find_mdw(collw, coll) {\n    if(cycle_width(collw) != collw) {\n        for(MDW=DEF_MDW; MDW>MIN_MDW; --MDW) if(cycle_width(collw) === collw) break;\n        if(MDW === MIN_MDW) for(MDW=DEF_MDW+1; MDW<MAX_MDW; ++MDW) if(cycle_width(collw) === collw) break;\n        if(MDW === MAX_MDW) MDW = DEF_MDW;\n    }\n}\n\n/* [MS-EXSPXML3] 2.4.54 ST_enmPattern */\nvar XLMLPatternTypeMap = {\n    \"None\": \"none\",\n    \"Solid\": \"solid\",\n    \"Gray50\": \"mediumGray\",\n    \"Gray75\": \"darkGray\",\n    \"Gray25\": \"lightGray\",\n    \"HorzStripe\": \"darkHorizontal\",\n    \"VertStripe\": \"darkVertical\",\n    \"ReverseDiagStripe\": \"darkDown\",\n    \"DiagStripe\": \"darkUp\",\n    \"DiagCross\": \"darkGrid\",\n    \"ThickDiagCross\": \"darkTrellis\",\n    \"ThinHorzStripe\": \"lightHorizontal\",\n    \"ThinVertStripe\": \"lightVertical\",\n    \"ThinReverseDiagStripe\": \"lightDown\",\n    \"ThinHorzCross\": \"lightGrid\"\n};\n\nvar styles = {}; // shared styles\n\nvar themes = {}; // shared themes\n\n/* 18.8.21 fills CT_Fills */\nfunction parse_fills(t, opts) {\n    styles.Fills = [];\n    var fill = {};\n    t[0].match(tagregex).forEach(function(x) {\n        var y = parsexmltag(x);\n        switch(y[0]) {\n            case '<fills': case '<fills>': case '</fills>': break;\n\n            /* 18.8.20 fill CT_Fill */\n            case '<fill>': break;\n            case '</fill>': styles.Fills.push(fill); fill = {}; break;\n\n            /* 18.8.32 patternFill CT_PatternFill */\n            case '<patternFill':\n                if(y.patternType) fill.patternType = y.patternType;\n                break;\n            case '<patternFill/>': case '</patternFill>': break;\n\n            /* 18.8.3 bgColor CT_Color */\n            case '<bgColor':\n                if(!fill.bgColor) fill.bgColor = {};\n                if(y.indexed) fill.bgColor.indexed = parseInt(y.indexed, 10);\n                if(y.theme) fill.bgColor.theme = parseInt(y.theme, 10);\n                if(y.tint) fill.bgColor.tint = parseFloat(y.tint);\n                /* Excel uses ARGB strings */\n                if(y.rgb) fill.bgColor.rgb = y.rgb.substring(y.rgb.length - 6);\n                break;\n            case '<bgColor/>': case '</bgColor>': break;\n\n            /* 18.8.19 fgColor CT_Color */\n            case '<fgColor':\n                if(!fill.fgColor) fill.fgColor = {};\n                if(y.theme) fill.fgColor.theme = parseInt(y.theme, 10);\n                if(y.tint) fill.fgColor.tint = parseFloat(y.tint);\n                /* Excel uses ARGB strings */\n                if(y.rgb) fill.fgColor.rgb = y.rgb.substring(y.rgb.length - 6);\n                break;\n            case '<fgColor/>': case '</fgColor>': break;\n\n            default: if(opts.WTF) throw 'unrecognized ' + y[0] + ' in fills';\n        }\n    });\n}\n\n/* 18.8.31 numFmts CT_NumFmts */\nfunction parse_numFmts(t, opts) {\n    styles.NumberFmt = [];\n    var k = keys(SSF._table);\n    for(var i=0; i < k.length; ++i) styles.NumberFmt[k[i]] = SSF._table[k[i]];\n    var m = t[0].match(tagregex);\n    for(i=0; i < m.length; ++i) {\n        var y = parsexmltag(m[i]);\n        switch(y[0]) {\n            case '<numFmts': case '</numFmts>': case '<numFmts/>': case '<numFmts>': break;\n            case '<numFmt': {\n                var f=unescapexml(utf8read(y.formatCode)), j=parseInt(y.numFmtId,10);\n                styles.NumberFmt[j] = f; if(j>0) SSF.load(f,j);\n            } break;\n            default: if(opts.WTF) throw 'unrecognized ' + y[0] + ' in numFmts';\n        }\n    }\n}\n\nfunction write_numFmts(NF, opts) {\n    var o = [\"<numFmts>\"];\n    [[5,8],[23,26],[41,44],[63,66],[164,392]].forEach(function(r) {\n        for(var i = r[0]; i <= r[1]; ++i) if(NF[i] !== undefined) o[o.length] = (writextag('numFmt',null,{numFmtId:i,formatCode:escapexml(NF[i])}));\n    });\n    if(o.length === 1) return \"\";\n    o[o.length] = (\"</numFmts>\");\n    o[0] = writextag('numFmts', null, { count:o.length-2 }).replace(\"/>\", \">\");\n    return o.join(\"\");\n}\n\n/* 18.8.10 cellXfs CT_CellXfs */\nfunction parse_cellXfs(t, opts) {\n    styles.CellXf = [];\n    t[0].match(tagregex).forEach(function(x) {\n        var y = parsexmltag(x);\n        switch(y[0]) {\n            case '<cellXfs': case '<cellXfs>': case '<cellXfs/>': case '</cellXfs>': break;\n\n            /* 18.8.45 xf CT_Xf */\n            case '<xf': delete y[0];\n                if(y.numFmtId) y.numFmtId = parseInt(y.numFmtId, 10);\n                if(y.fillId) y.fillId = parseInt(y.fillId, 10);\n                styles.CellXf.push(y); break;\n            case '</xf>': break;\n\n            /* 18.8.1 alignment CT_CellAlignment */\n            case '<alignment': case '<alignment/>': break;\n\n            /* 18.8.33 protection CT_CellProtection */\n            case '<protection': case '</protection>': case '<protection/>': break;\n\n            case '<extLst': case '</extLst>': break;\n            case '<ext': break;\n            default: if(opts.WTF) throw 'unrecognized ' + y[0] + ' in cellXfs';\n        }\n    });\n}\n\nfunction write_cellXfs(cellXfs) {\n    var o = [];\n    o[o.length] = (writextag('cellXfs',null));\n    cellXfs.forEach(function(c) { o[o.length] = (writextag('xf', null, c)); });\n    o[o.length] = (\"</cellXfs>\");\n    if(o.length === 2) return \"\";\n    o[0] = writextag('cellXfs',null, {count:o.length-2}).replace(\"/>\",\">\");\n    return o.join(\"\");\n}\n\n/* 18.8 Styles CT_Stylesheet*/\nvar parse_sty_xml= (function make_pstyx() {\nvar numFmtRegex = /<numFmts([^>]*)>.*<\\/numFmts>/;\nvar cellXfRegex = /<cellXfs([^>]*)>.*<\\/cellXfs>/;\nvar fillsRegex = /<fills([^>]*)>.*<\\/fills>/;\n\nreturn function parse_sty_xml(data, opts) {\n    /* 18.8.39 styleSheet CT_Stylesheet */\n    var t;\n\n    /* numFmts CT_NumFmts ? */\n    if((t=data.match(numFmtRegex))) parse_numFmts(t, opts);\n\n    /* fonts CT_Fonts ? */\n    /*if((t=data.match(/<fonts([^>]*)>.*<\\/fonts>/))) parse_fonts(t, opts);*/\n\n    /* fills CT_Fills */\n    if((t=data.match(fillsRegex))) parse_fills(t, opts);\n\n    /* borders CT_Borders ? */\n    /* cellStyleXfs CT_CellStyleXfs ? */\n\n    /* cellXfs CT_CellXfs ? */\n    if((t=data.match(cellXfRegex))) parse_cellXfs(t, opts);\n\n    /* dxfs CT_Dxfs ? */\n    /* tableStyles CT_TableStyles ? */\n    /* colors CT_Colors ? */\n    /* extLst CT_ExtensionList ? */\n\n    return styles;\n};\n})();\n\nvar STYLES_XML_ROOT = writextag('styleSheet', null, {\n    'xmlns': XMLNS.main[0],\n    'xmlns:vt': XMLNS.vt\n});\n\nRELS.STY = \"http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles\";\n\nfunction write_sty_xml(wb, opts) {\n    var o = [XML_HEADER, STYLES_XML_ROOT], w;\n    if((w = write_numFmts(wb.SSF)) != null) o[o.length] = w;\n    o[o.length] = ('<fonts count=\"1\"><font><sz val=\"12\"/><color theme=\"1\"/><name val=\"Calibri\"/><family val=\"2\"/><scheme val=\"minor\"/></font></fonts>');\n    o[o.length] = ('<fills count=\"2\"><fill><patternFill patternType=\"none\"/></fill><fill><patternFill patternType=\"gray125\"/></fill></fills>');\n    o[o.length] = ('<borders count=\"1\"><border><left/><right/><top/><bottom/><diagonal/></border></borders>');\n    o[o.length] = ('<cellStyleXfs count=\"1\"><xf numFmtId=\"0\" fontId=\"0\" fillId=\"0\" borderId=\"0\"/></cellStyleXfs>');\n    if((w = write_cellXfs(opts.cellXfs))) o[o.length] = (w);\n    o[o.length] = ('<cellStyles count=\"1\"><cellStyle name=\"Normal\" xfId=\"0\" builtinId=\"0\"/></cellStyles>');\n    o[o.length] = ('<dxfs count=\"0\"/>');\n    o[o.length] = ('<tableStyles count=\"0\" defaultTableStyle=\"TableStyleMedium9\" defaultPivotStyle=\"PivotStyleMedium4\"/>');\n\n    if(o.length>2){ o[o.length] = ('</styleSheet>'); o[1]=o[1].replace(\"/>\",\">\"); }\n    return o.join(\"\");\n}\n/* [MS-XLSB] 2.4.651 BrtFmt */\nfunction parse_BrtFmt(data, length) {\n    var ifmt = data.read_shift(2);\n    var stFmtCode = parse_XLWideString(data,length-2);\n    return [ifmt, stFmtCode];\n}\n\n/* [MS-XLSB] 2.4.653 BrtFont TODO */\nfunction parse_BrtFont(data, length) {\n    var out = {flags:{}};\n    out.dyHeight = data.read_shift(2);\n    out.grbit = parse_FontFlags(data, 2);\n    out.bls = data.read_shift(2);\n    out.sss = data.read_shift(2);\n    out.uls = data.read_shift(1);\n    out.bFamily = data.read_shift(1);\n    out.bCharSet = data.read_shift(1);\n    data.l++;\n    out.brtColor = parse_BrtColor(data, 8);\n    out.bFontScheme = data.read_shift(1);\n    out.name = parse_XLWideString(data, length - 21);\n\n    out.flags.Bold = out.bls === 0x02BC;\n    out.flags.Italic = out.grbit.fItalic;\n    out.flags.Strikeout = out.grbit.fStrikeout;\n    out.flags.Outline = out.grbit.fOutline;\n    out.flags.Shadow = out.grbit.fShadow;\n    out.flags.Condense = out.grbit.fCondense;\n    out.flags.Extend = out.grbit.fExtend;\n    out.flags.Sub = out.sss & 0x2;\n    out.flags.Sup = out.sss & 0x1;\n    return out;\n}\n\n/* [MS-XLSB] 2.4.816 BrtXF */\nfunction parse_BrtXF(data, length) {\n    var ixfeParent = data.read_shift(2);\n    var ifmt = data.read_shift(2);\n    parsenoop(data, length-4);\n    return {ixfe:ixfeParent, ifmt:ifmt };\n}\n\n/* [MS-XLSB] 2.1.7.50 Styles */\nfunction parse_sty_bin(data, opts) {\n    styles.NumberFmt = [];\n    for(var y in SSF._table) styles.NumberFmt[y] = SSF._table[y];\n\n    styles.CellXf = [];\n    var state = \"\"; /* TODO: this should be a stack */\n    var pass = false;\n    recordhopper(data, function hopper_sty(val, R, RT) {\n        switch(R.n) {\n            case 'BrtFmt':\n                styles.NumberFmt[val[0]] = val[1]; SSF.load(val[1], val[0]);\n                break;\n            case 'BrtFont': break; /* TODO */\n            case 'BrtKnownFonts': break; /* TODO */\n            case 'BrtFill': break; /* TODO */\n            case 'BrtBorder': break; /* TODO */\n            case 'BrtXF':\n                if(state === \"CELLXFS\") {\n                    styles.CellXf.push(val);\n                }\n                break; /* TODO */\n            case 'BrtStyle': break; /* TODO */\n            case 'BrtDXF': break; /* TODO */\n            case 'BrtMRUColor': break; /* TODO */\n            case 'BrtIndexedColor': break; /* TODO */\n            case 'BrtBeginStyleSheet': break;\n            case 'BrtEndStyleSheet': break;\n            case 'BrtBeginTableStyle': break;\n            case 'BrtTableStyleElement': break;\n            case 'BrtEndTableStyle': break;\n            case 'BrtBeginFmts': state = \"FMTS\"; break;\n            case 'BrtEndFmts': state = \"\"; break;\n            case 'BrtBeginFonts': state = \"FONTS\"; break;\n            case 'BrtEndFonts': state = \"\"; break;\n            case 'BrtACBegin': state = \"ACFONTS\"; break;\n            case 'BrtACEnd': state = \"\"; break;\n            case 'BrtBeginFills': state = \"FILLS\"; break;\n            case 'BrtEndFills': state = \"\"; break;\n            case 'BrtBeginBorders': state = \"BORDERS\"; break;\n            case 'BrtEndBorders': state = \"\"; break;\n            case 'BrtBeginCellStyleXFs': state = \"CELLSTYLEXFS\"; break;\n            case 'BrtEndCellStyleXFs': state = \"\"; break;\n            case 'BrtBeginCellXFs': state = \"CELLXFS\"; break;\n            case 'BrtEndCellXFs': state = \"\"; break;\n            case 'BrtBeginStyles': state = \"STYLES\"; break;\n            case 'BrtEndStyles': state = \"\"; break;\n            case 'BrtBeginDXFs': state = \"DXFS\"; break;\n            case 'BrtEndDXFs': state = \"\"; break;\n            case 'BrtBeginTableStyles': state = \"TABLESTYLES\"; break;\n            case 'BrtEndTableStyles': state = \"\"; break;\n            case 'BrtBeginColorPalette': state = \"COLORPALETTE\"; break;\n            case 'BrtEndColorPalette': state = \"\"; break;\n            case 'BrtBeginIndexedColors': state = \"INDEXEDCOLORS\"; break;\n            case 'BrtEndIndexedColors': state = \"\"; break;\n            case 'BrtBeginMRUColors': state = \"MRUCOLORS\"; break;\n            case 'BrtEndMRUColors': state = \"\"; break;\n            case 'BrtFRTBegin': pass = true; break;\n            case 'BrtFRTEnd': pass = false; break;\n            case 'BrtBeginStyleSheetExt14': break;\n            case 'BrtBeginSlicerStyles': break;\n            case 'BrtEndSlicerStyles': break;\n            case 'BrtBeginTimelineStylesheetExt15': break;\n            case 'BrtEndTimelineStylesheetExt15': break;\n            case 'BrtBeginTimelineStyles': break;\n            case 'BrtEndTimelineStyles': break;\n            case 'BrtEndStyleSheetExt14': break;\n            default: if(!pass || opts.WTF) throw new Error(\"Unexpected record \" + RT + \" \" + R.n);\n        }\n    });\n    return styles;\n}\n\n/* [MS-XLSB] 2.1.7.50 Styles */\nfunction write_sty_bin(data, opts) {\n    var ba = buf_array();\n    write_record(ba, \"BrtBeginStyleSheet\");\n    /* [FMTS] */\n    /* [FONTS] */\n    /* [FILLS] */\n    /* [BORDERS] */\n    /* CELLSTYLEXFS */\n    /* CELLXFS*/\n    /* STYLES */\n    /* DXFS */\n    /* TABLESTYLES */\n    /* [COLORPALETTE] */\n    /* FRTSTYLESHEET*/\n    write_record(ba, \"BrtEndStyleSheet\");\n    return ba.end();\n}\nRELS.THEME = \"http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme\";\n\n/* 20.1.6.2 clrScheme CT_ColorScheme */\nfunction parse_clrScheme(t, opts) {\n    themes.themeElements.clrScheme = [];\n    var color = {};\n    t[0].match(tagregex).forEach(function(x) {\n        var y = parsexmltag(x);\n        switch(y[0]) {\n            case '<a:clrScheme': case '</a:clrScheme>': break;\n\n            /* 20.1.2.3.32 srgbClr CT_SRgbColor */\n            case '<a:srgbClr': color.rgb = y.val; break;\n\n            /* 20.1.2.3.33 sysClr CT_SystemColor */\n            case '<a:sysClr': color.rgb = y.lastClr; break;\n\n            /* 20.1.4.1.9 dk1 (Dark 1) */\n            case '<a:dk1>':\n            case '</a:dk1>':\n            /* 20.1.4.1.10 dk2 (Dark 2) */\n            case '<a:dk2>':\n            case '</a:dk2>':\n            /* 20.1.4.1.22 lt1 (Light 1) */\n            case '<a:lt1>':\n            case '</a:lt1>':\n            /* 20.1.4.1.23 lt2 (Light 2) */\n            case '<a:lt2>':\n            case '</a:lt2>':\n            /* 20.1.4.1.1 accent1 (Accent 1) */\n            case '<a:accent1>':\n            case '</a:accent1>':\n            /* 20.1.4.1.2 accent2 (Accent 2) */\n            case '<a:accent2>':\n            case '</a:accent2>':\n            /* 20.1.4.1.3 accent3 (Accent 3) */\n            case '<a:accent3>':\n            case '</a:accent3>':\n            /* 20.1.4.1.4 accent4 (Accent 4) */\n            case '<a:accent4>':\n            case '</a:accent4>':\n            /* 20.1.4.1.5 accent5 (Accent 5) */\n            case '<a:accent5>':\n            case '</a:accent5>':\n            /* 20.1.4.1.6 accent6 (Accent 6) */\n            case '<a:accent6>':\n            case '</a:accent6>':\n            /* 20.1.4.1.19 hlink (Hyperlink) */\n            case '<a:hlink>':\n            case '</a:hlink>':\n            /* 20.1.4.1.15 folHlink (Followed Hyperlink) */\n            case '<a:folHlink>':\n            case '</a:folHlink>':\n                if (y[0][1] === '/') {\n                    themes.themeElements.clrScheme.push(color);\n                    color = {};\n                } else {\n                    color.name = y[0].substring(3, y[0].length - 1);\n                }\n                break;\n\n            default: if(opts.WTF) throw 'unrecognized ' + y[0] + ' in clrScheme';\n        }\n    });\n}\n\n/* 20.1.4.1.18 fontScheme CT_FontScheme */\nfunction parse_fontScheme(t, opts) { }\n\n/* 20.1.4.1.15 fmtScheme CT_StyleMatrix */\nfunction parse_fmtScheme(t, opts) { }\n\nvar clrsregex = /<a:clrScheme([^>]*)>[^\\u2603]*<\\/a:clrScheme>/;\nvar fntsregex = /<a:fontScheme([^>]*)>[^\\u2603]*<\\/a:fontScheme>/;\nvar fmtsregex = /<a:fmtScheme([^>]*)>[^\\u2603]*<\\/a:fmtScheme>/;\n\n/* 20.1.6.10 themeElements CT_BaseStyles */\nfunction parse_themeElements(data, opts) {\n    themes.themeElements = {};\n\n    var t;\n\n    [\n        /* clrScheme CT_ColorScheme */\n        ['clrScheme', clrsregex, parse_clrScheme],\n        /* fontScheme CT_FontScheme */\n        ['fontScheme', fntsregex, parse_fontScheme],\n        /* fmtScheme CT_StyleMatrix */\n        ['fmtScheme', fmtsregex, parse_fmtScheme]\n    ].forEach(function(m) {\n        if(!(t=data.match(m[1]))) throw m[0] + ' not found in themeElements';\n        m[2](t, opts);\n    });\n}\n\nvar themeltregex = /<a:themeElements([^>]*)>[^\\u2603]*<\\/a:themeElements>/;\n\n/* 14.2.7 Theme Part */\nfunction parse_theme_xml(data, opts) {\n    /* 20.1.6.9 theme CT_OfficeStyleSheet */\n    if(!data || data.length === 0) return themes;\n\n    var t;\n\n    /* themeElements CT_BaseStyles */\n    if(!(t=data.match(themeltregex))) throw 'themeElements not found in theme';\n    parse_themeElements(t[0], opts);\n\n    return themes;\n}\n\nfunction write_theme() { return '<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\\n<a:theme xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" name=\"Office Theme\"><a:themeElements><a:clrScheme name=\"Office\"><a:dk1><a:sysClr val=\"windowText\" lastClr=\"000000\"/></a:dk1><a:lt1><a:sysClr val=\"window\" lastClr=\"FFFFFF\"/></a:lt1><a:dk2><a:srgbClr val=\"1F497D\"/></a:dk2><a:lt2><a:srgbClr val=\"EEECE1\"/></a:lt2><a:accent1><a:srgbClr val=\"4F81BD\"/></a:accent1><a:accent2><a:srgbClr val=\"C0504D\"/></a:accent2><a:accent3><a:srgbClr val=\"9BBB59\"/></a:accent3><a:accent4><a:srgbClr val=\"8064A2\"/></a:accent4><a:accent5><a:srgbClr val=\"4BACC6\"/></a:accent5><a:accent6><a:srgbClr val=\"F79646\"/></a:accent6><a:hlink><a:srgbClr val=\"0000FF\"/></a:hlink><a:folHlink><a:srgbClr val=\"800080\"/></a:folHlink></a:clrScheme><a:fontScheme name=\"Office\"><a:majorFont><a:latin typeface=\"Cambria\"/><a:ea typeface=\"\"/><a:cs typeface=\"\"/><a:font script=\"Jpan\" typeface=\"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af\"/><a:font script=\"Hang\" typeface=\"\ub9d1\uc740 \uace0\ub515\"/><a:font script=\"Hans\" typeface=\"\u5b8b\u4f53\"/><a:font script=\"Hant\" typeface=\"\u65b0\u7d30\u660e\u9ad4\"/><a:font script=\"Arab\" typeface=\"Times New Roman\"/><a:font script=\"Hebr\" typeface=\"Times New Roman\"/><a:font script=\"Thai\" typeface=\"Tahoma\"/><a:font script=\"Ethi\" typeface=\"Nyala\"/><a:font script=\"Beng\" typeface=\"Vrinda\"/><a:font script=\"Gujr\" typeface=\"Shruti\"/><a:font script=\"Khmr\" typeface=\"MoolBoran\"/><a:font script=\"Knda\" typeface=\"Tunga\"/><a:font script=\"Guru\" typeface=\"Raavi\"/><a:font script=\"Cans\" typeface=\"Euphemia\"/><a:font script=\"Cher\" typeface=\"Plantagenet Cherokee\"/><a:font script=\"Yiii\" typeface=\"Microsoft Yi Baiti\"/><a:font script=\"Tibt\" typeface=\"Microsoft Himalaya\"/><a:font script=\"Thaa\" typeface=\"MV Boli\"/><a:font script=\"Deva\" typeface=\"Mangal\"/><a:font script=\"Telu\" typeface=\"Gautami\"/><a:font script=\"Taml\" typeface=\"Latha\"/><a:font script=\"Syrc\" typeface=\"Estrangelo Edessa\"/><a:font script=\"Orya\" typeface=\"Kalinga\"/><a:font script=\"Mlym\" typeface=\"Kartika\"/><a:font script=\"Laoo\" typeface=\"DokChampa\"/><a:font script=\"Sinh\" typeface=\"Iskoola Pota\"/><a:font script=\"Mong\" typeface=\"Mongolian Baiti\"/><a:font script=\"Viet\" typeface=\"Times New Roman\"/><a:font script=\"Uigh\" typeface=\"Microsoft Uighur\"/><a:font script=\"Geor\" typeface=\"Sylfaen\"/></a:majorFont><a:minorFont><a:latin typeface=\"Calibri\"/><a:ea typeface=\"\"/><a:cs typeface=\"\"/><a:font script=\"Jpan\" typeface=\"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af\"/><a:font script=\"Hang\" typeface=\"\ub9d1\uc740 \uace0\ub515\"/><a:font script=\"Hans\" typeface=\"\u5b8b\u4f53\"/><a:font script=\"Hant\" typeface=\"\u65b0\u7d30\u660e\u9ad4\"/><a:font script=\"Arab\" typeface=\"Arial\"/><a:font script=\"Hebr\" typeface=\"Arial\"/><a:font script=\"Thai\" typeface=\"Tahoma\"/><a:font script=\"Ethi\" typeface=\"Nyala\"/><a:font script=\"Beng\" typeface=\"Vrinda\"/><a:font script=\"Gujr\" typeface=\"Shruti\"/><a:font script=\"Khmr\" typeface=\"DaunPenh\"/><a:font script=\"Knda\" typeface=\"Tunga\"/><a:font script=\"Guru\" typeface=\"Raavi\"/><a:font script=\"Cans\" typeface=\"Euphemia\"/><a:font script=\"Cher\" typeface=\"Plantagenet Cherokee\"/><a:font script=\"Yiii\" typeface=\"Microsoft Yi Baiti\"/><a:font script=\"Tibt\" typeface=\"Microsoft Himalaya\"/><a:font script=\"Thaa\" typeface=\"MV Boli\"/><a:font script=\"Deva\" typeface=\"Mangal\"/><a:font script=\"Telu\" typeface=\"Gautami\"/><a:font script=\"Taml\" typeface=\"Latha\"/><a:font script=\"Syrc\" typeface=\"Estrangelo Edessa\"/><a:font script=\"Orya\" typeface=\"Kalinga\"/><a:font script=\"Mlym\" typeface=\"Kartika\"/><a:font script=\"Laoo\" typeface=\"DokChampa\"/><a:font script=\"Sinh\" typeface=\"Iskoola Pota\"/><a:font script=\"Mong\" typeface=\"Mongolian Baiti\"/><a:font script=\"Viet\" typeface=\"Arial\"/><a:font script=\"Uigh\" typeface=\"Microsoft Uighur\"/><a:font script=\"Geor\" typeface=\"Sylfaen\"/></a:minorFont></a:fontScheme><a:fmtScheme name=\"Office\"><a:fillStyleLst><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"50000\"/><a:satMod val=\"300000\"/></a:schemeClr></a:gs><a:gs pos=\"35000\"><a:schemeClr val=\"phClr\"><a:tint val=\"37000\"/><a:satMod val=\"300000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:tint val=\"15000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs></a:gsLst><a:lin ang=\"16200000\" scaled=\"1\"/></a:gradFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"100000\"/><a:shade val=\"100000\"/><a:satMod val=\"130000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:tint val=\"50000\"/><a:shade val=\"100000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs></a:gsLst><a:lin ang=\"16200000\" scaled=\"0\"/></a:gradFill></a:fillStyleLst><a:lnStyleLst><a:ln w=\"9525\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:solidFill><a:schemeClr val=\"phClr\"><a:shade val=\"95000\"/><a:satMod val=\"105000\"/></a:schemeClr></a:solidFill><a:prstDash val=\"solid\"/></a:ln><a:ln w=\"25400\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:prstDash val=\"solid\"/></a:ln><a:ln w=\"38100\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:prstDash val=\"solid\"/></a:ln></a:lnStyleLst><a:effectStyleLst><a:effectStyle><a:effectLst><a:outerShdw blurRad=\"40000\" dist=\"20000\" dir=\"5400000\" rotWithShape=\"0\"><a:srgbClr val=\"000000\"><a:alpha val=\"38000\"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad=\"40000\" dist=\"23000\" dir=\"5400000\" rotWithShape=\"0\"><a:srgbClr val=\"000000\"><a:alpha val=\"35000\"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad=\"40000\" dist=\"23000\" dir=\"5400000\" rotWithShape=\"0\"><a:srgbClr val=\"000000\"><a:alpha val=\"35000\"/></a:srgbClr></a:outerShdw></a:effectLst><a:scene3d><a:camera prst=\"orthographicFront\"><a:rot lat=\"0\" lon=\"0\" rev=\"0\"/></a:camera><a:lightRig rig=\"threePt\" dir=\"t\"><a:rot lat=\"0\" lon=\"0\" rev=\"1200000\"/></a:lightRig></a:scene3d><a:sp3d><a:bevelT w=\"63500\" h=\"25400\"/></a:sp3d></a:effectStyle></a:effectStyleLst><a:bgFillStyleLst><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"40000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs><a:gs pos=\"40000\"><a:schemeClr val=\"phClr\"><a:tint val=\"45000\"/><a:shade val=\"99000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:shade val=\"20000\"/><a:satMod val=\"255000\"/></a:schemeClr></a:gs></a:gsLst><a:path path=\"circle\"><a:fillToRect l=\"50000\" t=\"-80000\" r=\"50000\" b=\"180000\"/></a:path></a:gradFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"80000\"/><a:satMod val=\"300000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:shade val=\"30000\"/><a:satMod val=\"200000\"/></a:schemeClr></a:gs></a:gsLst><a:path path=\"circle\"><a:fillToRect l=\"50000\" t=\"50000\" r=\"50000\" b=\"50000\"/></a:path></a:gradFill></a:bgFillStyleLst></a:fmtScheme></a:themeElements><a:objectDefaults><a:spDef><a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx=\"1\"><a:schemeClr val=\"accent1\"/></a:lnRef><a:fillRef idx=\"3\"><a:schemeClr val=\"accent1\"/></a:fillRef><a:effectRef idx=\"2\"><a:schemeClr val=\"accent1\"/></a:effectRef><a:fontRef idx=\"minor\"><a:schemeClr val=\"lt1\"/></a:fontRef></a:style></a:spDef><a:lnDef><a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx=\"2\"><a:schemeClr val=\"accent1\"/></a:lnRef><a:fillRef idx=\"0\"><a:schemeClr val=\"accent1\"/></a:fillRef><a:effectRef idx=\"1\"><a:schemeClr val=\"accent1\"/></a:effectRef><a:fontRef idx=\"minor\"><a:schemeClr val=\"tx1\"/></a:fontRef></a:style></a:lnDef></a:objectDefaults><a:extraClrSchemeLst/></a:theme>'; }\n/* [MS-XLS] 2.4.326 TODO: payload is a zip file */\nfunction parse_Theme(blob, length) {\n    var dwThemeVersion = blob.read_shift(4);\n    if(dwThemeVersion === 124226) return;\n    blob.l += length-4;\n}\n\n/* 2.5.49 */\nfunction parse_ColorTheme(blob, length) { return blob.read_shift(4); }\n\n/* 2.5.155 */\nfunction parse_FullColorExt(blob, length) {\n    var o = {};\n    o.xclrType = blob.read_shift(2);\n    o.nTintShade = blob.read_shift(2);\n    switch(o.xclrType) {\n        case 0: blob.l += 4; break;\n        case 1: o.xclrValue = parse_IcvXF(blob, 4); break;\n        case 2: o.xclrValue = parse_LongRGBA(blob, 4); break;\n        case 3: o.xclrValue = parse_ColorTheme(blob, 4); break;\n        case 4: blob.l += 4; break;\n    }\n    blob.l += 8;\n    return o;\n}\n\n/* 2.5.164 TODO: read 7 bits*/\nfunction parse_IcvXF(blob, length) {\n    return parsenoop(blob, length);\n}\n\n/* 2.5.280 */\nfunction parse_XFExtGradient(blob, length) {\n    return parsenoop(blob, length);\n}\n\n/* 2.5.108 */\nfunction parse_ExtProp(blob, length) {\n    var extType = blob.read_shift(2);\n    var cb = blob.read_shift(2);\n    var o = [extType];\n    switch(extType) {\n        case 0x04: case 0x05: case 0x07: case 0x08:\n        case 0x09: case 0x0A: case 0x0B: case 0x0D:\n            o[1] = parse_FullColorExt(blob, cb); break;\n        case 0x06: o[1] = parse_XFExtGradient(blob, cb); break;\n        case 0x0E: case 0x0F: o[1] = blob.read_shift(cb === 5 ? 1 : 2); break;\n        default: throw new Error(\"Unrecognized ExtProp type: \" + extType + \" \" + cb);\n    }\n    return o;\n}\n\n/* 2.4.355 */\nfunction parse_XFExt(blob, length) {\n    var end = blob.l + length;\n    blob.l += 2;\n    var ixfe = blob.read_shift(2);\n    blob.l += 2;\n    var cexts = blob.read_shift(2);\n    var ext = [];\n    while(cexts-- > 0) ext.push(parse_ExtProp(blob, end-blob.l));\n    return {ixfe:ixfe, ext:ext};\n}\n\n/* xf is an XF, see parse_XFExt for xfext */\nfunction update_xfext(xf, xfext) {\n    xfext.forEach(function(xfe) {\n        switch(xfe[0]) { /* 2.5.108 extPropData */\n            case 0x04: break; /* foreground color */\n            case 0x05: break; /* background color */\n            case 0x07: case 0x08: case 0x09: case 0x0a: break;\n            case 0x0d: break; /* text color */\n            case 0x0e: break; /* font scheme */\n            default: throw \"bafuq\" + xfe[0].toString(16);\n        }\n    });\n}\n\n/* 18.6 Calculation Chain */\nfunction parse_cc_xml(data, opts) {\n    var d = [];\n    var l = 0, i = 1;\n    (data.match(tagregex)||[]).forEach(function(x) {\n        var y = parsexmltag(x);\n        switch(y[0]) {\n            case '<?xml': break;\n            /* 18.6.2  calcChain CT_CalcChain 1 */\n            case '<calcChain': case '<calcChain>': case '</calcChain>': break;\n            /* 18.6.1  c CT_CalcCell 1 */\n            case '<c': delete y[0]; if(y.i) i = y.i; else y.i = i; d.push(y); break;\n        }\n    });\n    return d;\n}\n\nfunction write_cc_xml(data, opts) { }\n/* [MS-XLSB] 2.6.4.1 */\nfunction parse_BrtCalcChainItem$(data, length) {\n    var out = {};\n    out.i = data.read_shift(4);\n    var cell = {};\n    cell.r = data.read_shift(4);\n    cell.c = data.read_shift(4);\n    out.r = encode_cell(cell);\n    var flags = data.read_shift(1);\n    if(flags & 0x2) out.l = '1';\n    if(flags & 0x8) out.a = '1';\n    return out;\n}\n\n/* 18.6 Calculation Chain */\nfunction parse_cc_bin(data, opts) {\n    var out = [];\n    var pass = false;\n    recordhopper(data, function hopper_cc(val, R, RT) {\n        switch(R.n) {\n            case 'BrtCalcChainItem$': out.push(val); break;\n            case 'BrtBeginCalcChain$': break;\n            case 'BrtEndCalcChain$': break;\n            default: if(!pass || opts.WTF) throw new Error(\"Unexpected record \" + RT + \" \" + R.n);\n        }\n    });\n    return out;\n}\n\nfunction write_cc_bin(data, opts) { }\n\nfunction parse_comments(zip, dirComments, sheets, sheetRels, opts) {\n    for(var i = 0; i != dirComments.length; ++i) {\n        var canonicalpath=dirComments[i];\n        var comments=parse_cmnt(getzipdata(zip, canonicalpath.replace(/^\\//,''), true), canonicalpath, opts);\n        if(!comments || !comments.length) continue;\n        // find the sheets targeted by these comments\n        var sheetNames = keys(sheets);\n        for(var j = 0; j != sheetNames.length; ++j) {\n            var sheetName = sheetNames[j];\n            var rels = sheetRels[sheetName];\n            if(rels) {\n                var rel = rels[canonicalpath];\n                if(rel) insertCommentsIntoSheet(sheetName, sheets[sheetName], comments);\n            }\n        }\n    }\n}\n\nfunction insertCommentsIntoSheet(sheetName, sheet, comments) {\n    comments.forEach(function(comment) {\n        var cell = sheet[comment.ref];\n        if (!cell) {\n            cell = {};\n            sheet[comment.ref] = cell;\n            var range = safe_decode_range(sheet[\"!ref\"]||\"BDWGO1000001:A1\");\n            var thisCell = decode_cell(comment.ref);\n            if(range.s.r > thisCell.r) range.s.r = thisCell.r;\n            if(range.e.r < thisCell.r) range.e.r = thisCell.r;\n            if(range.s.c > thisCell.c) range.s.c = thisCell.c;\n            if(range.e.c < thisCell.c) range.e.c = thisCell.c;\n            var encoded = encode_range(range);\n            if (encoded !== sheet[\"!ref\"]) sheet[\"!ref\"] = encoded;\n        }\n\n        if (!cell.c) cell.c = [];\n        var o = {a: comment.author, t: comment.t, r: comment.r};\n        if(comment.h) o.h = comment.h;\n        cell.c.push(o);\n    });\n}\n\n/* 18.7.3 CT_Comment */\nfunction parse_comments_xml(data, opts) {\n    if(data.match(/<(?:\\w+:)?comments *\\/>/)) return [];\n    var authors = [];\n    var commentList = [];\n    data.match(/<(?:\\w+:)?authors>([^\\u2603]*)<\\/(?:\\w+:)?authors>/)[1].split(/<\\/\\w*:?author>/).forEach(function(x) {\n        if(x === \"\" || x.trim() === \"\") return;\n        authors.push(x.match(/<(?:\\w+:)?author[^>]*>(.*)/)[1]);\n    });\n    (data.match(/<(?:\\w+:)?commentList>([^\\u2603]*)<\\/(?:\\w+:)?commentList>/)||[\"\",\"\"])[1].split(/<\\/\\w*:?comment>/).forEach(function(x, index) {\n        if(x === \"\" || x.trim() === \"\") return;\n        var y = parsexmltag(x.match(/<(?:\\w+:)?comment[^>]*>/)[0]);\n        var comment = { author: y.authorId && authors[y.authorId] ? authors[y.authorId] : undefined, ref: y.ref, guid: y.guid };\n        var cell = decode_cell(y.ref);\n        if(opts.sheetRows && opts.sheetRows <= cell.r) return;\n        var textMatch = x.match(/<text>([^\\u2603]*)<\\/text>/);\n        if (!textMatch || !textMatch[1]) return; // a comment may contain an empty text tag.\n        var rt = parse_si(textMatch[1]);\n        comment.r = rt.r;\n        comment.t = rt.t;\n        if(opts.cellHTML) comment.h = rt.h;\n        commentList.push(comment);\n    });\n    return commentList;\n}\n\nfunction write_comments_xml(data, opts) { }\n/* [MS-XLSB] 2.4.28 BrtBeginComment */\nfunction parse_BrtBeginComment(data, length) {\n    var out = {};\n    out.iauthor = data.read_shift(4);\n    var rfx = parse_UncheckedRfX(data, 16);\n    out.rfx = rfx.s;\n    out.ref = encode_cell(rfx.s);\n    data.l += 16; /*var guid = parse_GUID(data); */\n    return out;\n}\n\n/* [MS-XLSB] 2.4.324 BrtCommentAuthor */\nvar parse_BrtCommentAuthor = parse_XLWideString;\n\n/* [MS-XLSB] 2.4.325 BrtCommentText */\nvar parse_BrtCommentText = parse_RichStr;\n\n/* [MS-XLSB] 2.1.7.8 Comments */\nfunction parse_comments_bin(data, opts) {\n    var out = [];\n    var authors = [];\n    var c = {};\n    var pass = false;\n    recordhopper(data, function hopper_cmnt(val, R, RT) {\n        switch(R.n) {\n            case 'BrtCommentAuthor': authors.push(val); break;\n            case 'BrtBeginComment': c = val; break;\n            case 'BrtCommentText': c.t = val.t; c.h = val.h; c.r = val.r; break;\n            case 'BrtEndComment':\n                c.author = authors[c.iauthor];\n                delete c.iauthor;\n                if(opts.sheetRows && opts.sheetRows <= c.rfx.r) break;\n                delete c.rfx; out.push(c); break;\n            case 'BrtBeginComments': break;\n            case 'BrtEndComments': break;\n            case 'BrtBeginCommentAuthors': break;\n            case 'BrtEndCommentAuthors': break;\n            case 'BrtBeginCommentList': break;\n            case 'BrtEndCommentList': break;\n            default: if(!pass || opts.WTF) throw new Error(\"Unexpected record \" + RT + \" \" + R.n);\n        }\n    });\n    return out;\n}\n\nfunction write_comments_bin(data, opts) { }\n/* TODO: it will be useful to parse the function str */\nvar rc_to_a1 = (function(){\n    var rcregex = /(^|[^A-Za-z])R(\\[?)(-?\\d+|)\\]?C(\\[?)(-?\\d+|)\\]?/g;\n    var rcbase;\n    function rcfunc($$,$1,$2,$3,$4,$5) {\n        var R = $3.length>0?parseInt($3,10)|0:0, C = $5.length>0?parseInt($5,10)|0:0;\n        if(C<0 && $4.length === 0) C=0;\n        if($4.length > 0) C += rcbase.c;\n        if($2.length > 0) R += rcbase.r;\n        return $1 + encode_col(C) + encode_row(R);\n    }\n    return function rc_to_a1(fstr, base) {\n        rcbase = base;\n        return fstr.replace(rcregex, rcfunc);\n    };\n})();\n\n/* --- formula references point to MS-XLS --- */\n/* Small helpers */\nfunction parseread(l) { return function(blob, length) { blob.l+=l; return; }; }\nfunction parseread1(blob, length) { blob.l+=1; return; }\n\n/* Rgce Helpers */\n\n/* 2.5.51 */\nfunction parse_ColRelU(blob, length) {\n    var c = blob.read_shift(2);\n    return [c & 0x3FFF, (c >> 14) & 1, (c >> 15) & 1];\n}\n\n/* 2.5.198.105 */\nfunction parse_RgceArea(blob, length) {\n    var r=blob.read_shift(2), R=blob.read_shift(2);\n    var c=parse_ColRelU(blob, 2);\n    var C=parse_ColRelU(blob, 2);\n    return { s:{r:r, c:c[0], cRel:c[1], rRel:c[2]}, e:{r:R, c:C[0], cRel:C[1], rRel:C[2]} };\n}\n\n/* 2.5.198.105 TODO */\nfunction parse_RgceAreaRel(blob, length) {\n    var r=blob.read_shift(2), R=blob.read_shift(2);\n    var c=parse_ColRelU(blob, 2);\n    var C=parse_ColRelU(blob, 2);\n    return { s:{r:r, c:c[0], cRel:c[1], rRel:c[2]}, e:{r:R, c:C[0], cRel:C[1], rRel:C[2]} };\n}\n\n/* 2.5.198.109 */\nfunction parse_RgceLoc(blob, length) {\n    var r = blob.read_shift(2);\n    var c = parse_ColRelU(blob, 2);\n    return {r:r, c:c[0], cRel:c[1], rRel:c[2]};\n}\n\n/* 2.5.198.111 */\nfunction parse_RgceLocRel(blob, length) {\n    var r = blob.read_shift(2);\n    var cl = blob.read_shift(2);\n    var cRel = (cl & 0x8000) >> 15, rRel = (cl & 0x4000) >> 14;\n    cl &= 0x3FFF;\n    if(cRel !== 0) while(cl >= 0x100) cl -= 0x100;\n    return {r:r,c:cl,cRel:cRel,rRel:rRel};\n}\n\n/* Ptg Tokens */\n\n/* 2.5.198.27 */\nfunction parse_PtgArea(blob, length) {\n    var type = (blob[blob.l++] & 0x60) >> 5;\n    var area = parse_RgceArea(blob, 8);\n    return [type, area];\n}\n\n/* 2.5.198.28 */\nfunction parse_PtgArea3d(blob, length) {\n    var type = (blob[blob.l++] & 0x60) >> 5;\n    var ixti = blob.read_shift(2);\n    var area = parse_RgceArea(blob, 8);\n    return [type, ixti, area];\n}\n\n/* 2.5.198.29 */\nfunction parse_PtgAreaErr(blob, length) {\n    var type = (blob[blob.l++] & 0x60) >> 5;\n    blob.l += 8;\n    return [type];\n}\n/* 2.5.198.30 */\nfunction parse_PtgAreaErr3d(blob, length) {\n    var type = (blob[blob.l++] & 0x60) >> 5;\n    var ixti = blob.read_shift(2);\n    blob.l += 8;\n    return [type, ixti];\n}\n\n/* 2.5.198.31 */\nfunction parse_PtgAreaN(blob, length) {\n    var type = (blob[blob.l++] & 0x60) >> 5;\n    var area = parse_RgceAreaRel(blob, 8);\n    return [type, area];\n}\n\n/* 2.5.198.32 -- ignore this and look in PtgExtraArray for shape + values */\nfunction parse_PtgArray(blob, length) {\n    var type = (blob[blob.l++] & 0x60) >> 5;\n    blob.l += 7;\n    return [type];\n}\n\n/* 2.5.198.33 */\nfunction parse_PtgAttrBaxcel(blob, length) {\n    var bitSemi = blob[blob.l+1] & 0x01; /* 1 = volatile */\n    var bitBaxcel = 1;\n    blob.l += 4;\n    return [bitSemi, bitBaxcel];\n}\n\n/* 2.5.198.34 */\nfunction parse_PtgAttrChoose(blob, length) {\n    blob.l +=2;\n    var offset = blob.read_shift(2);\n    var o = [];\n    /* offset is 1 less than the number of elements */\n    for(var i = 0; i <= offset; ++i) o.push(blob.read_shift(2));\n    return o;\n}\n\n/* 2.5.198.35 */\nfunction parse_PtgAttrGoto(blob, length) {\n    var bitGoto = (blob[blob.l+1] & 0xFF) ? 1 : 0;\n    blob.l += 2;\n    return [bitGoto, blob.read_shift(2)];\n}\n\n/* 2.5.198.36 */\nfunction parse_PtgAttrIf(blob, length) {\n    var bitIf = (blob[blob.l+1] & 0xFF) ? 1 : 0;\n    blob.l += 2;\n    return [bitIf, blob.read_shift(2)];\n}\n\n/* 2.5.198.37 */\nfunction parse_PtgAttrSemi(blob, length) {\n    var bitSemi = (blob[blob.l+1] & 0xFF) ? 1 : 0;\n    blob.l += 4;\n    return [bitSemi];\n}\n\n/* 2.5.198.40 (used by PtgAttrSpace and PtgAttrSpaceSemi) */\nfunction parse_PtgAttrSpaceType(blob, length) {\n    var type = blob.read_shift(1), cch = blob.read_shift(1);\n    return [type, cch];\n}\n\n/* 2.5.198.38 */\nfunction parse_PtgAttrSpace(blob, length) {\n    blob.read_shift(2);\n    return parse_PtgAttrSpaceType(blob, 2);\n}\n\n/* 2.5.198.39 */\nfunction parse_PtgAttrSpaceSemi(blob, length) {\n    blob.read_shift(2);\n    return parse_PtgAttrSpaceType(blob, 2);\n}\n\n/* 2.5.198.84 TODO */\nfunction parse_PtgRef(blob, length) {\n    var ptg = blob[blob.l] & 0x1F;\n    var type = (blob[blob.l] & 0x60)>>5;\n    blob.l += 1;\n    var loc = parse_RgceLoc(blob,4);\n    return [type, loc];\n}\n\n/* 2.5.198.88 TODO */\nfunction parse_PtgRefN(blob, length) {\n    var ptg = blob[blob.l] & 0x1F;\n    var type = (blob[blob.l] & 0x60)>>5;\n    blob.l += 1;\n    var loc = parse_RgceLocRel(blob,4);\n    return [type, loc];\n}\n\n/* 2.5.198.85 TODO */\nfunction parse_PtgRef3d(blob, length) {\n    var ptg = blob[blob.l] & 0x1F;\n    var type = (blob[blob.l] & 0x60)>>5;\n    blob.l += 1;\n    var ixti = blob.read_shift(2); // XtiIndex\n    var loc = parse_RgceLoc(blob,4);\n    return [type, ixti, loc];\n}\n\n\n/* 2.5.198.62 TODO */\nfunction parse_PtgFunc(blob, length) {\n    var ptg = blob[blob.l] & 0x1F;\n    var type = (blob[blob.l] & 0x60)>>5;\n    blob.l += 1;\n    var iftab = blob.read_shift(2);\n    return [FtabArgc[iftab], Ftab[iftab]];\n}\n/* 2.5.198.63 TODO */\nfunction parse_PtgFuncVar(blob, length) {\n    blob.l++;\n    var cparams = blob.read_shift(1), tab = parsetab(blob);\n    return [cparams, (tab[0] === 0 ? Ftab : Cetab)[tab[1]]];\n}\n\nfunction parsetab(blob, length) {\n    return [blob[blob.l+1]>>7, blob.read_shift(2) & 0x7FFF];\n}\n\n/* 2.5.198.41 */\nvar parse_PtgAttrSum = parseread(4);\n/* 2.5.198.43 */\nvar parse_PtgConcat = parseread1;\n\n/* 2.5.198.58 */\nfunction parse_PtgExp(blob, length) {\n    blob.l++;\n    var row = blob.read_shift(2);\n    var col = blob.read_shift(2);\n    return [row, col];\n}\n\n/* 2.5.198.57 */\nfunction parse_PtgErr(blob, length) { blob.l++; return BErr[blob.read_shift(1)]; }\n\n/* 2.5.198.66 TODO */\nfunction parse_PtgInt(blob, length) { blob.l++; return blob.read_shift(2); }\n\n/* 2.5.198.42 */\nfunction parse_PtgBool(blob, length) { blob.l++; return blob.read_shift(1)!==0;}\n\n/* 2.5.198.79 */\nfunction parse_PtgNum(blob, length) { blob.l++; return parse_Xnum(blob, 8); }\n\n/* 2.5.198.89 */\nfunction parse_PtgStr(blob, length) { blob.l++; return parse_ShortXLUnicodeString(blob); }\n\n/* 2.5.192.112 + 2.5.192.11{3,4,5,6,7} */\nfunction parse_SerAr(blob) {\n    var val = [];\n    switch((val[0] = blob.read_shift(1))) {\n        /* 2.5.192.113 */\n        case 0x04: /* SerBool -- boolean */\n            val[1] = parsebool(blob, 1) ? 'TRUE' : 'FALSE';\n            blob.l += 7; break;\n        /* 2.5.192.114 */\n        case 0x10: /* SerErr -- error */\n            val[1] = BErr[blob[blob.l]];\n            blob.l += 8; break;\n        /* 2.5.192.115 */\n        case 0x00: /* SerNil -- honestly, I'm not sure how to reproduce this */\n            blob.l += 8; break;\n        /* 2.5.192.116 */\n        case 0x01: /* SerNum -- Xnum */\n            val[1] = parse_Xnum(blob, 8); break;\n        /* 2.5.192.117 */\n        case 0x02: /* SerStr -- XLUnicodeString (<256 chars) */\n            val[1] = parse_XLUnicodeString(blob); break;\n        // default: throw \"Bad SerAr: \" + val[0]; /* Unreachable */\n    }\n    return val;\n}\n\n/* 2.5.198.61 */\nfunction parse_PtgExtraMem(blob, cce) {\n    var count = blob.read_shift(2);\n    var out = [];\n    for(var i = 0; i != count; ++i) out.push(parse_Ref8U(blob, 8));\n    return out;\n}\n\n/* 2.5.198.59 */\nfunction parse_PtgExtraArray(blob) {\n    var cols = 1 + blob.read_shift(1); //DColByteU\n    var rows = 1 + blob.read_shift(2); //DRw\n    for(var i = 0, o=[]; i != rows && (o[i] = []); ++i)\n        for(var j = 0; j != cols; ++j) o[i][j] = parse_SerAr(blob);\n    return o;\n}\n\n/* 2.5.198.76 */\nfunction parse_PtgName(blob, length) {\n    var type = (blob.read_shift(1) >>> 5) & 0x03;\n    var nameindex = blob.read_shift(4);\n    return [type, 0, nameindex];\n}\n\n/* 2.5.198.77 */\nfunction parse_PtgNameX(blob, length) {\n    var type = (blob.read_shift(1) >>> 5) & 0x03;\n    var ixti = blob.read_shift(2); // XtiIndex\n    var nameindex = blob.read_shift(4);\n    return [type, ixti, nameindex];\n}\n\n/* 2.5.198.70 */\nfunction parse_PtgMemArea(blob, length) {\n    var type = (blob.read_shift(1) >>> 5) & 0x03;\n    blob.l += 4;\n    var cce = blob.read_shift(2);\n    return [type, cce];\n}\n\n/* 2.5.198.72 */\nfunction parse_PtgMemFunc(blob, length) {\n    var type = (blob.read_shift(1) >>> 5) & 0x03;\n    var cce = blob.read_shift(2);\n    return [type, cce];\n}\n\n\n/* 2.5.198.86 */\nfunction parse_PtgRefErr(blob, length) {\n    var type = (blob.read_shift(1) >>> 5) & 0x03;\n    blob.l += 4;\n    return [type];\n}\n\n/* 2.5.198.26 */\nvar parse_PtgAdd = parseread1;\n/* 2.5.198.45 */\nvar parse_PtgDiv = parseread1;\n/* 2.5.198.56 */\nvar parse_PtgEq = parseread1;\n/* 2.5.198.64 */\nvar parse_PtgGe = parseread1;\n/* 2.5.198.65 */\nvar parse_PtgGt = parseread1;\n/* 2.5.198.67 */\nvar parse_PtgIsect = parseread1;\n/* 2.5.198.68 */\nvar parse_PtgLe = parseread1;\n/* 2.5.198.69 */\nvar parse_PtgLt = parseread1;\n/* 2.5.198.74 */\nvar parse_PtgMissArg = parseread1;\n/* 2.5.198.75 */\nvar parse_PtgMul = parseread1;\n/* 2.5.198.78 */\nvar parse_PtgNe = parseread1;\n/* 2.5.198.80 */\nvar parse_PtgParen = parseread1;\n/* 2.5.198.81 */\nvar parse_PtgPercent = parseread1;\n/* 2.5.198.82 */\nvar parse_PtgPower = parseread1;\n/* 2.5.198.83 */\nvar parse_PtgRange = parseread1;\n/* 2.5.198.90 */\nvar parse_PtgSub = parseread1;\n/* 2.5.198.93 */\nvar parse_PtgUminus = parseread1;\n/* 2.5.198.94 */\nvar parse_PtgUnion = parseread1;\n/* 2.5.198.95 */\nvar parse_PtgUplus = parseread1;\n\n/* 2.5.198.71 */\nvar parse_PtgMemErr = parsenoop;\n/* 2.5.198.73 */\nvar parse_PtgMemNoMem = parsenoop;\n/* 2.5.198.87 */\nvar parse_PtgRefErr3d = parsenoop;\n/* 2.5.198.92 */\nvar parse_PtgTbl = parsenoop;\n\n/* 2.5.198.25 */\nvar PtgTypes = {\n    0x01: { n:'PtgExp', f:parse_PtgExp },\n    0x02: { n:'PtgTbl', f:parse_PtgTbl },\n    0x03: { n:'PtgAdd', f:parse_PtgAdd },\n    0x04: { n:'PtgSub', f:parse_PtgSub },\n    0x05: { n:'PtgMul', f:parse_PtgMul },\n    0x06: { n:'PtgDiv', f:parse_PtgDiv },\n    0x07: { n:'PtgPower', f:parse_PtgPower },\n    0x08: { n:'PtgConcat', f:parse_PtgConcat },\n    0x09: { n:'PtgLt', f:parse_PtgLt },\n    0x0A: { n:'PtgLe', f:parse_PtgLe },\n    0x0B: { n:'PtgEq', f:parse_PtgEq },\n    0x0C: { n:'PtgGe', f:parse_PtgGe },\n    0x0D: { n:'PtgGt', f:parse_PtgGt },\n    0x0E: { n:'PtgNe', f:parse_PtgNe },\n    0x0F: { n:'PtgIsect', f:parse_PtgIsect },\n    0x10: { n:'PtgUnion', f:parse_PtgUnion },\n    0x11: { n:'PtgRange', f:parse_PtgRange },\n    0x12: { n:'PtgUplus', f:parse_PtgUplus },\n    0x13: { n:'PtgUminus', f:parse_PtgUminus },\n    0x14: { n:'PtgPercent', f:parse_PtgPercent },\n    0x15: { n:'PtgParen', f:parse_PtgParen },\n    0x16: { n:'PtgMissArg', f:parse_PtgMissArg },\n    0x17: { n:'PtgStr', f:parse_PtgStr },\n    0x1C: { n:'PtgErr', f:parse_PtgErr },\n    0x1D: { n:'PtgBool', f:parse_PtgBool },\n    0x1E: { n:'PtgInt', f:parse_PtgInt },\n    0x1F: { n:'PtgNum', f:parse_PtgNum },\n    0x20: { n:'PtgArray', f:parse_PtgArray },\n    0x21: { n:'PtgFunc', f:parse_PtgFunc },\n    0x22: { n:'PtgFuncVar', f:parse_PtgFuncVar },\n    0x23: { n:'PtgName', f:parse_PtgName },\n    0x24: { n:'PtgRef', f:parse_PtgRef },\n    0x25: { n:'PtgArea', f:parse_PtgArea },\n    0x26: { n:'PtgMemArea', f:parse_PtgMemArea },\n    0x27: { n:'PtgMemErr', f:parse_PtgMemErr },\n    0x28: { n:'PtgMemNoMem', f:parse_PtgMemNoMem },\n    0x29: { n:'PtgMemFunc', f:parse_PtgMemFunc },\n    0x2A: { n:'PtgRefErr', f:parse_PtgRefErr },\n    0x2B: { n:'PtgAreaErr', f:parse_PtgAreaErr },\n    0x2C: { n:'PtgRefN', f:parse_PtgRefN },\n    0x2D: { n:'PtgAreaN', f:parse_PtgAreaN },\n    0x39: { n:'PtgNameX', f:parse_PtgNameX },\n    0x3A: { n:'PtgRef3d', f:parse_PtgRef3d },\n    0x3B: { n:'PtgArea3d', f:parse_PtgArea3d },\n    0x3C: { n:'PtgRefErr3d', f:parse_PtgRefErr3d },\n    0x3D: { n:'PtgAreaErr3d', f:parse_PtgAreaErr3d },\n    0xFF: {}\n};\n/* These are duplicated in the PtgTypes table */\nvar PtgDupes = {\n    0x40: 0x20, 0x60: 0x20,\n    0x41: 0x21, 0x61: 0x21,\n    0x42: 0x22, 0x62: 0x22,\n    0x43: 0x23, 0x63: 0x23,\n    0x44: 0x24, 0x64: 0x24,\n    0x45: 0x25, 0x65: 0x25,\n    0x46: 0x26, 0x66: 0x26,\n    0x47: 0x27, 0x67: 0x27,\n    0x48: 0x28, 0x68: 0x28,\n    0x49: 0x29, 0x69: 0x29,\n    0x4A: 0x2A, 0x6A: 0x2A,\n    0x4B: 0x2B, 0x6B: 0x2B,\n    0x4C: 0x2C, 0x6C: 0x2C,\n    0x4D: 0x2D, 0x6D: 0x2D,\n    0x59: 0x39, 0x79: 0x39,\n    0x5A: 0x3A, 0x7A: 0x3A,\n    0x5B: 0x3B, 0x7B: 0x3B,\n    0x5C: 0x3C, 0x7C: 0x3C,\n    0x5D: 0x3D, 0x7D: 0x3D\n};\n(function(){for(var y in PtgDupes) PtgTypes[y] = PtgTypes[PtgDupes[y]];})();\n\nvar Ptg18 = {};\nvar Ptg19 = {\n    0x01: { n:'PtgAttrSemi', f:parse_PtgAttrSemi },\n    0x02: { n:'PtgAttrIf', f:parse_PtgAttrIf },\n    0x04: { n:'PtgAttrChoose', f:parse_PtgAttrChoose },\n    0x08: { n:'PtgAttrGoto', f:parse_PtgAttrGoto },\n    0x10: { n:'PtgAttrSum', f:parse_PtgAttrSum },\n    0x20: { n:'PtgAttrBaxcel', f:parse_PtgAttrBaxcel },\n    0x40: { n:'PtgAttrSpace', f:parse_PtgAttrSpace },\n    0x41: { n:'PtgAttrSpaceSemi', f:parse_PtgAttrSpaceSemi },\n    0xFF: {}\n};\n\n/* 2.4.127 TODO */\nfunction parse_Formula(blob, length, opts) {\n    var cell = parse_XLSCell(blob, 6);\n    var val = parse_FormulaValue(blob,8);\n    var flags = blob.read_shift(1);\n    blob.read_shift(1);\n    var chn = blob.read_shift(4);\n    var cbf = \"\";\n    if(opts.biff === 5) blob.l += length-20;\n    else cbf = parse_XLSCellParsedFormula(blob, length-20, opts);\n    return {cell:cell, val:val[0], formula:cbf, shared: (flags >> 3) & 1, tt:val[1]};\n}\n\n/* 2.5.133 TODO: how to emit empty strings? */\nfunction parse_FormulaValue(blob) {\n    var b;\n    if(__readUInt16LE(blob,blob.l + 6) !== 0xFFFF) return [parse_Xnum(blob),'n'];\n    switch(blob[blob.l]) {\n        case 0x00: blob.l += 8; return [\"String\", 's'];\n        case 0x01: b = blob[blob.l+2] === 0x1; blob.l += 8; return [b,'b'];\n        case 0x02: b = blob[blob.l+2]; blob.l += 8; return [b,'e'];\n        case 0x03: blob.l += 8; return [\"\",'s'];\n    }\n}\n\n/* 2.5.198.103 */\nfunction parse_RgbExtra(blob, length, rgce, opts) {\n    if(opts.biff < 8) return parsenoop(blob, length);\n    var target = blob.l + length;\n    var o = [];\n    for(var i = 0; i !== rgce.length; ++i) {\n        switch(rgce[i][0]) {\n            case 'PtgArray': /* PtgArray -> PtgExtraArray */\n                rgce[i][1] = parse_PtgExtraArray(blob);\n                o.push(rgce[i][1]);\n                break;\n            case 'PtgMemArea': /* PtgMemArea -> PtgExtraMem */\n                rgce[i][2] = parse_PtgExtraMem(blob, rgce[i][1]);\n                o.push(rgce[i][2]);\n                break;\n            default: break;\n        }\n    }\n    length = target - blob.l;\n    if(length !== 0) o.push(parsenoop(blob, length));\n    return o;\n}\n\n/* 2.5.198.21 */\nfunction parse_NameParsedFormula(blob, length, opts, cce) {\n    var target = blob.l + length;\n    var rgce = parse_Rgce(blob, cce);\n    var rgcb;\n    if(target !== blob.l) rgcb = parse_RgbExtra(blob, target - blob.l, rgce, opts);\n    return [rgce, rgcb];\n}\n\n/* 2.5.198.3 TODO */\nfunction parse_XLSCellParsedFormula(blob, length, opts) {\n    var target = blob.l + length;\n    var rgcb, cce = blob.read_shift(2); // length of rgce\n    if(cce == 0xFFFF) return [[],parsenoop(blob, length-2)];\n    var rgce = parse_Rgce(blob, cce);\n    if(length !== cce + 2) rgcb = parse_RgbExtra(blob, length - cce - 2, rgce, opts);\n    return [rgce, rgcb];\n}\n\n/* 2.5.198.118 TODO */\nfunction parse_SharedParsedFormula(blob, length, opts) {\n    var target = blob.l + length;\n    var rgcb, cce = blob.read_shift(2); // length of rgce\n    var rgce = parse_Rgce(blob, cce);\n    if(cce == 0xFFFF) return [[],parsenoop(blob, length-2)];\n    if(length !== cce + 2) rgcb = parse_RgbExtra(blob, target - cce - 2, rgce, opts);\n    return [rgce, rgcb];\n}\n\n/* 2.5.198.1 TODO */\nfunction parse_ArrayParsedFormula(blob, length, opts, ref) {\n    var target = blob.l + length;\n    var rgcb, cce = blob.read_shift(2); // length of rgce\n    if(cce == 0xFFFF) return [[],parsenoop(blob, length-2)];\n    var rgce = parse_Rgce(blob, cce);\n    if(length !== cce + 2) rgcb = parse_RgbExtra(blob, target - cce - 2, rgce, opts);\n    return [rgce, rgcb];\n}\n\n/* 2.5.198.104 */\nfunction parse_Rgce(blob, length) {\n    var target = blob.l + length;\n    var R, id, ptgs = [];\n    while(target != blob.l) {\n        length = target - blob.l;\n        id = blob[blob.l];\n        R = PtgTypes[id];\n        //console.log(\"ptg\", id, R)\n        if(id === 0x18 || id === 0x19) {\n            id = blob[blob.l + 1];\n            R = (id === 0x18 ? Ptg18 : Ptg19)[id];\n        }\n        if(!R || !R.f) { ptgs.push(parsenoop(blob, length)); }\n        else { ptgs.push([R.n, R.f(blob, length)]); }\n    }\n    return ptgs;\n}\n\nfunction mapper(x) { return x.map(function f2(y) { return y[1];}).join(\",\");}\n\n/* 2.2.2 + Magic TODO */\nfunction stringify_formula(formula, range, cell, supbooks, opts) {\n    if(opts !== undefined && opts.biff === 5) return \"BIFF5??\";\n    var _range = range !== undefined ? range : {s:{c:0, r:0}};\n    var stack = [], e1, e2, type, c, ixti, nameidx, r;\n    if(!formula[0] || !formula[0][0]) return \"\";\n    //console.log(\"--\",cell,formula[0])\n    for(var ff = 0, fflen = formula[0].length; ff < fflen; ++ff) {\n        var f = formula[0][ff];\n        //console.log(\"++\",f, stack)\n        switch(f[0]) {\n        /* 2.2.2.1 Unary Operator Tokens */\n            /* 2.5.198.93 */\n            case 'PtgUminus': stack.push(\"-\" + stack.pop()); break;\n            /* 2.5.198.95 */\n            case 'PtgUplus': stack.push(\"+\" + stack.pop()); break;\n            /* 2.5.198.81 */\n            case 'PtgPercent': stack.push(stack.pop() + \"%\"); break;\n\n        /* 2.2.2.1 Binary Value Operator Token */\n            /* 2.5.198.26 */\n            case 'PtgAdd':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\"+\"+e1);\n                break;\n            /* 2.5.198.90 */\n            case 'PtgSub':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\"-\"+e1);\n                break;\n            /* 2.5.198.75 */\n            case 'PtgMul':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\"*\"+e1);\n                break;\n            /* 2.5.198.45 */\n            case 'PtgDiv':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\"/\"+e1);\n                break;\n            /* 2.5.198.82 */\n            case 'PtgPower':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\"^\"+e1);\n                break;\n            /* 2.5.198.43 */\n            case 'PtgConcat':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\"&\"+e1);\n                break;\n            /* 2.5.198.69 */\n            case 'PtgLt':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\"<\"+e1);\n                break;\n            /* 2.5.198.68 */\n            case 'PtgLe':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\"<=\"+e1);\n                break;\n            /* 2.5.198.56 */\n            case 'PtgEq':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\"=\"+e1);\n                break;\n            /* 2.5.198.64 */\n            case 'PtgGe':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\">=\"+e1);\n                break;\n            /* 2.5.198.65 */\n            case 'PtgGt':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\">\"+e1);\n                break;\n            /* 2.5.198.78 */\n            case 'PtgNe':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\"<>\"+e1);\n                break;\n\n        /* 2.2.2.1 Binary Reference Operator Token */\n            /* 2.5.198.67 */\n            case 'PtgIsect':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\" \"+e1);\n                break;\n            case 'PtgUnion':\n                e1 = stack.pop(); e2 = stack.pop();\n                stack.push(e2+\",\"+e1);\n                break;\n            case 'PtgRange': break;\n\n        /* 2.2.2.3 Control Tokens \"can be ignored\" */\n            /* 2.5.198.34 */\n            case 'PtgAttrChoose': break;\n            /* 2.5.198.35 */\n            case 'PtgAttrGoto': break;\n            /* 2.5.198.36 */\n            case 'PtgAttrIf': break;\n\n\n            /* 2.5.198.84 */\n            case 'PtgRef':\n                type = f[1][0]; c = shift_cell_xls(decode_cell(encode_cell(f[1][1])), _range);\n                stack.push(encode_cell(c));\n                break;\n            /* 2.5.198.88 */\n            case 'PtgRefN':\n                type = f[1][0]; c = shift_cell_xls(decode_cell(encode_cell(f[1][1])), cell);\n                stack.push(encode_cell(c));\n                break;\n            case 'PtgRef3d': // TODO: lots of stuff\n                type = f[1][0]; ixti = f[1][1]; c = shift_cell_xls(f[1][2], _range);\n                stack.push(supbooks[1][ixti+1]+\"!\"+encode_cell(c));\n                break;\n\n        /* Function Call */\n            /* 2.5.198.62 */\n            case 'PtgFunc':\n            /* 2.5.198.63 */\n            case 'PtgFuncVar':\n                /* f[1] = [argc, func] */\n                var argc = f[1][0], func = f[1][1];\n                if(!argc) argc = 0;\n                var args = stack.slice(-argc);\n                stack.length -= argc;\n                if(func === 'User') func = args.shift();\n                stack.push(func + \"(\" + args.join(\",\") + \")\");\n                break;\n\n            /* 2.5.198.42 */\n            case 'PtgBool': stack.push(f[1] ? \"TRUE\" : \"FALSE\"); break;\n            /* 2.5.198.66 */\n            case 'PtgInt': stack.push(f[1]); break;\n            /* 2.5.198.79 TODO: precision? */\n            case 'PtgNum': stack.push(String(f[1])); break;\n            /* 2.5.198.89 */\n            case 'PtgStr': stack.push('\"' + f[1] + '\"'); break;\n            /* 2.5.198.57 */\n            case 'PtgErr': stack.push(f[1]); break;\n            /* 2.5.198.27 TODO: fixed points */\n            case 'PtgArea':\n                type = f[1][0]; r = shift_range_xls(f[1][1], _range);\n                stack.push(encode_range(r));\n                break;\n            /* 2.5.198.28 */\n            case 'PtgArea3d': // TODO: lots of stuff\n                type = f[1][0]; ixti = f[1][1]; r = f[1][2];\n                stack.push(supbooks[1][ixti+1]+\"!\"+encode_range(r));\n                break;\n            /* 2.5.198.41 */\n            case 'PtgAttrSum':\n                stack.push(\"SUM(\" + stack.pop() + \")\");\n                break;\n\n        /* Expression Prefixes */\n            /* 2.5.198.37 */\n            case 'PtgAttrSemi': break;\n\n            /* 2.5.97.60 TODO: do something different for revisions */\n            case 'PtgName':\n                /* f[1] = type, 0, nameindex */\n                nameidx = f[1][2];\n                var lbl = supbooks[0][nameidx];\n                var name = lbl.Name;\n                if(name in XLSXFutureFunctions) name = XLSXFutureFunctions[name];\n                stack.push(name);\n                break;\n\n            /* 2.5.97.61 TODO: do something different for revisions */\n            case 'PtgNameX':\n                /* f[1] = type, ixti, nameindex */\n                var bookidx = f[1][1]; nameidx = f[1][2]; var externbook;\n                /* TODO: Properly handle missing values */\n                if(supbooks[bookidx+1]) externbook = supbooks[bookidx+1][nameidx];\n                else if(supbooks[bookidx-1]) externbook = supbooks[bookidx-1][nameidx];\n                if(!externbook) externbook = {body: \"??NAMEX??\"};\n                stack.push(externbook.body);\n                break;\n\n        /* 2.2.2.4 Display Tokens */\n            /* 2.5.198.80 */\n            case 'PtgParen': stack.push('(' + stack.pop() + ')'); break;\n\n            /* 2.5.198.86 */\n            case 'PtgRefErr': stack.push('#REF!'); break;\n\n        /* */\n            /* 2.5.198.58 TODO */\n            case 'PtgExp':\n                c = {c:f[1][1],r:f[1][0]};\n                var q = {c: cell.c, r:cell.r};\n                if(supbooks.sharedf[encode_cell(c)]) {\n                    var parsedf = (supbooks.sharedf[encode_cell(c)]);\n                    stack.push(stringify_formula(parsedf, _range, q, supbooks, opts));\n                }\n                else {\n                    var fnd = false;\n                    for(e1=0;e1!=supbooks.arrayf.length; ++e1) {\n                        /* TODO: should be something like range_has */\n                        e2 = supbooks.arrayf[e1];\n                        if(c.c < e2[0].s.c || c.c > e2[0].e.c) continue;\n                        if(c.r < e2[0].s.r || c.r > e2[0].e.r) continue;\n                        stack.push(stringify_formula(e2[1], _range, q, supbooks, opts));\n                    }\n                    if(!fnd) stack.push(f[1]);\n                }\n                break;\n\n            /* 2.5.198.32 TODO */\n            case 'PtgArray':\n                stack.push(\"{\" + f[1].map(mapper).join(\";\") + \"}\");\n                break;\n\n        /* 2.2.2.5 Mem Tokens */\n            /* 2.5.198.70 TODO: confirm this is a non-display */\n            case 'PtgMemArea':\n                //stack.push(\"(\" + f[2].map(encode_range).join(\",\") + \")\");\n                break;\n\n            /* 2.5.198.38 TODO */\n            case 'PtgAttrSpace': break;\n\n            /* 2.5.198.92 TODO */\n            case 'PtgTbl': break;\n\n            /* 2.5.198.71 */\n            case 'PtgMemErr': break;\n\n            /* 2.5.198.74 */\n            case 'PtgMissArg':\n                stack.push(\"\");\n                break;\n\n            /* 2.5.198.29 TODO */\n            case 'PtgAreaErr': break;\n\n            /* 2.5.198.31 TODO */\n            case 'PtgAreaN': stack.push(\"\"); break;\n\n            /* 2.5.198.87 TODO */\n            case 'PtgRefErr3d': break;\n\n            /* 2.5.198.72 TODO */\n            case 'PtgMemFunc': break;\n\n            default: throw 'Unrecognized Formula Token: ' + f;\n        }\n        //console.log(\"::\",f, stack)\n    }\n    //console.log(\"--\",stack);\n    return stack[0];\n}\n\n/* [MS-XLSB] 2.5.97.4 CellParsedFormula TODO: use similar logic to js-xls */\nfunction parse_XLSBCellParsedFormula(data, length) {\n    var cce = data.read_shift(4);\n    return parsenoop(data, length-4);\n}\n/* [MS-XLS] 2.5.198.44 */\nvar PtgDataType = {\n    0x1: \"REFERENCE\", // reference to range\n    0x2: \"VALUE\", // single value\n    0x3: \"ARRAY\" // array of values\n};\n\n/* [MS-XLS] 2.5.198.4 */\nvar Cetab = {\n    0x0000: 'BEEP',\n    0x0001: 'OPEN',\n    0x0002: 'OPEN.LINKS',\n    0x0003: 'CLOSE.ALL',\n    0x0004: 'SAVE',\n    0x0005: 'SAVE.AS',\n    0x0006: 'FILE.DELETE',\n    0x0007: 'PAGE.SETUP',\n    0x0008: 'PRINT',\n    0x0009: 'PRINTER.SETUP',\n    0x000A: 'QUIT',\n    0x000B: 'NEW.WINDOW',\n    0x000C: 'ARRANGE.ALL',\n    0x000D: 'WINDOW.SIZE',\n    0x000E: 'WINDOW.MOVE',\n    0x000F: 'FULL',\n    0x0010: 'CLOSE',\n    0x0011: 'RUN',\n    0x0016: 'SET.PRINT.AREA',\n    0x0017: 'SET.PRINT.TITLES',\n    0x0018: 'SET.PAGE.BREAK',\n    0x0019: 'REMOVE.PAGE.BREAK',\n    0x001A: 'FONT',\n    0x001B: 'DISPLAY',\n    0x001C: 'PROTECT.DOCUMENT',\n    0x001D: 'PRECISION',\n    0x001E: 'A1.R1C1',\n    0x001F: 'CALCULATE.NOW',\n    0x0020: 'CALCULATION',\n    0x0022: 'DATA.FIND',\n    0x0023: 'EXTRACT',\n    0x0024: 'DATA.DELETE',\n    0x0025: 'SET.DATABASE',\n    0x0026: 'SET.CRITERIA',\n    0x0027: 'SORT',\n    0x0028: 'DATA.SERIES',\n    0x0029: 'TABLE',\n    0x002A: 'FORMAT.NUMBER',\n    0x002B: 'ALIGNMENT',\n    0x002C: 'STYLE',\n    0x002D: 'BORDER',\n    0x002E: 'CELL.PROTECTION',\n    0x002F: 'COLUMN.WIDTH',\n    0x0030: 'UNDO',\n    0x0031: 'CUT',\n    0x0032: 'COPY',\n    0x0033: 'PASTE',\n    0x0034: 'CLEAR',\n    0x0035: 'PASTE.SPECIAL',\n    0x0036: 'EDIT.DELETE',\n    0x0037: 'INSERT',\n    0x0038: 'FILL.RIGHT',\n    0x0039: 'FILL.DOWN',\n    0x003D: 'DEFINE.NAME',\n    0x003E: 'CREATE.NAMES',\n    0x003F: 'FORMULA.GOTO',\n    0x0040: 'FORMULA.FIND',\n    0x0041: 'SELECT.LAST.CELL',\n    0x0042: 'SHOW.ACTIVE.CELL',\n    0x0043: 'GALLERY.AREA',\n    0x0044: 'GALLERY.BAR',\n    0x0045: 'GALLERY.COLUMN',\n    0x0046: 'GALLERY.LINE',\n    0x0047: 'GALLERY.PIE',\n    0x0048: 'GALLERY.SCATTER',\n    0x0049: 'COMBINATION',\n    0x004A: 'PREFERRED',\n    0x004B: 'ADD.OVERLAY',\n    0x004C: 'GRIDLINES',\n    0x004D: 'SET.PREFERRED',\n    0x004E: 'AXES',\n    0x004F: 'LEGEND',\n    0x0050: 'ATTACH.TEXT',\n    0x0051: 'ADD.ARROW',\n    0x0052: 'SELECT.CHART',\n    0x0053: 'SELECT.PLOT.AREA',\n    0x0054: 'PATTERNS',\n    0x0055: 'MAIN.CHART',\n    0x0056: 'OVERLAY',\n    0x0057: 'SCALE',\n    0x0058: 'FORMAT.LEGEND',\n    0x0059: 'FORMAT.TEXT',\n    0x005A: 'EDIT.REPEAT',\n    0x005B: 'PARSE',\n    0x005C: 'JUSTIFY',\n    0x005D: 'HIDE',\n    0x005E: 'UNHIDE',\n    0x005F: 'WORKSPACE',\n    0x0060: 'FORMULA',\n    0x0061: 'FORMULA.FILL',\n    0x0062: 'FORMULA.ARRAY',\n    0x0063: 'DATA.FIND.NEXT',\n    0x0064: 'DATA.FIND.PREV',\n    0x0065: 'FORMULA.FIND.NEXT',\n    0x0066: 'FORMULA.FIND.PREV',\n    0x0067: 'ACTIVATE',\n    0x0068: 'ACTIVATE.NEXT',\n    0x0069: 'ACTIVATE.PREV',\n    0x006A: 'UNLOCKED.NEXT',\n    0x006B: 'UNLOCKED.PREV',\n    0x006C: 'COPY.PICTURE',\n    0x006D: 'SELECT',\n    0x006E: 'DELETE.NAME',\n    0x006F: 'DELETE.FORMAT',\n    0x0070: 'VLINE',\n    0x0071: 'HLINE',\n    0x0072: 'VPAGE',\n    0x0073: 'HPAGE',\n    0x0074: 'VSCROLL',\n    0x0075: 'HSCROLL',\n    0x0076: 'ALERT',\n    0x0077: 'NEW',\n    0x0078: 'CANCEL.COPY',\n    0x0079: 'SHOW.CLIPBOARD',\n    0x007A: 'MESSAGE',\n    0x007C: 'PASTE.LINK',\n    0x007D: 'APP.ACTIVATE',\n    0x007E: 'DELETE.ARROW',\n    0x007F: 'ROW.HEIGHT',\n    0x0080: 'FORMAT.MOVE',\n    0x0081: 'FORMAT.SIZE',\n    0x0082: 'FORMULA.REPLACE',\n    0x0083: 'SEND.KEYS',\n    0x0084: 'SELECT.SPECIAL',\n    0x0085: 'APPLY.NAMES',\n    0x0086: 'REPLACE.FONT',\n    0x0087: 'FREEZE.PANES',\n    0x0088: 'SHOW.INFO',\n    0x0089: 'SPLIT',\n    0x008A: 'ON.WINDOW',\n    0x008B: 'ON.DATA',\n    0x008C: 'DISABLE.INPUT',\n    0x008E: 'OUTLINE',\n    0x008F: 'LIST.NAMES',\n    0x0090: 'FILE.CLOSE',\n    0x0091: 'SAVE.WORKBOOK',\n    0x0092: 'DATA.FORM',\n    0x0093: 'COPY.CHART',\n    0x0094: 'ON.TIME',\n    0x0095: 'WAIT',\n    0x0096: 'FORMAT.FONT',\n    0x0097: 'FILL.UP',\n    0x0098: 'FILL.LEFT',\n    0x0099: 'DELETE.OVERLAY',\n    0x009B: 'SHORT.MENUS',\n    0x009F: 'SET.UPDATE.STATUS',\n    0x00A1: 'COLOR.PALETTE',\n    0x00A2: 'DELETE.STYLE',\n    0x00A3: 'WINDOW.RESTORE',\n    0x00A4: 'WINDOW.MAXIMIZE',\n    0x00A6: 'CHANGE.LINK',\n    0x00A7: 'CALCULATE.DOCUMENT',\n    0x00A8: 'ON.KEY',\n    0x00A9: 'APP.RESTORE',\n    0x00AA: 'APP.MOVE',\n    0x00AB: 'APP.SIZE',\n    0x00AC: 'APP.MINIMIZE',\n    0x00AD: 'APP.MAXIMIZE',\n    0x00AE: 'BRING.TO.FRONT',\n    0x00AF: 'SEND.TO.BACK',\n    0x00B9: 'MAIN.CHART.TYPE',\n    0x00BA: 'OVERLAY.CHART.TYPE',\n    0x00BB: 'SELECT.END',\n    0x00BC: 'OPEN.MAIL',\n    0x00BD: 'SEND.MAIL',\n    0x00BE: 'STANDARD.FONT',\n    0x00BF: 'CONSOLIDATE',\n    0x00C0: 'SORT.SPECIAL',\n    0x00C1: 'GALLERY.3D.AREA',\n    0x00C2: 'GALLERY.3D.COLUMN',\n    0x00C3: 'GALLERY.3D.LINE',\n    0x00C4: 'GALLERY.3D.PIE',\n    0x00C5: 'VIEW.3D',\n    0x00C6: 'GOAL.SEEK',\n    0x00C7: 'WORKGROUP',\n    0x00C8: 'FILL.GROUP',\n    0x00C9: 'UPDATE.LINK',\n    0x00CA: 'PROMOTE',\n    0x00CB: 'DEMOTE',\n    0x00CC: 'SHOW.DETAIL',\n    0x00CE: 'UNGROUP',\n    0x00CF: 'OBJECT.PROPERTIES',\n    0x00D0: 'SAVE.NEW.OBJECT',\n    0x00D1: 'SHARE',\n    0x00D2: 'SHARE.NAME',\n    0x00D3: 'DUPLICATE',\n    0x00D4: 'APPLY.STYLE',\n    0x00D5: 'ASSIGN.TO.OBJECT',\n    0x00D6: 'OBJECT.PROTECTION',\n    0x00D7: 'HIDE.OBJECT',\n    0x00D8: 'SET.EXTRACT',\n    0x00D9: 'CREATE.PUBLISHER',\n    0x00DA: 'SUBSCRIBE.TO',\n    0x00DB: 'ATTRIBUTES',\n    0x00DC: 'SHOW.TOOLBAR',\n    0x00DE: 'PRINT.PREVIEW',\n    0x00DF: 'EDIT.COLOR',\n    0x00E0: 'SHOW.LEVELS',\n    0x00E1: 'FORMAT.MAIN',\n    0x00E2: 'FORMAT.OVERLAY',\n    0x00E3: 'ON.RECALC',\n    0x00E4: 'EDIT.SERIES',\n    0x00E5: 'DEFINE.STYLE',\n    0x00F0: 'LINE.PRINT',\n    0x00F3: 'ENTER.DATA',\n    0x00F9: 'GALLERY.RADAR',\n    0x00FA: 'MERGE.STYLES',\n    0x00FB: 'EDITION.OPTIONS',\n    0x00FC: 'PASTE.PICTURE',\n    0x00FD: 'PASTE.PICTURE.LINK',\n    0x00FE: 'SPELLING',\n    0x0100: 'ZOOM',\n    0x0103: 'INSERT.OBJECT',\n    0x0104: 'WINDOW.MINIMIZE',\n    0x0109: 'SOUND.NOTE',\n    0x010A: 'SOUND.PLAY',\n    0x010B: 'FORMAT.SHAPE',\n    0x010C: 'EXTEND.POLYGON',\n    0x010D: 'FORMAT.AUTO',\n    0x0110: 'GALLERY.3D.BAR',\n    0x0111: 'GALLERY.3D.SURFACE',\n    0x0112: 'FILL.AUTO',\n    0x0114: 'CUSTOMIZE.TOOLBAR',\n    0x0115: 'ADD.TOOL',\n    0x0116: 'EDIT.OBJECT',\n    0x0117: 'ON.DOUBLECLICK',\n    0x0118: 'ON.ENTRY',\n    0x0119: 'WORKBOOK.ADD',\n    0x011A: 'WORKBOOK.MOVE',\n    0x011B: 'WORKBOOK.COPY',\n    0x011C: 'WORKBOOK.OPTIONS',\n    0x011D: 'SAVE.WORKSPACE',\n    0x0120: 'CHART.WIZARD',\n    0x0121: 'DELETE.TOOL',\n    0x0122: 'MOVE.TOOL',\n    0x0123: 'WORKBOOK.SELECT',\n    0x0124: 'WORKBOOK.ACTIVATE',\n    0x0125: 'ASSIGN.TO.TOOL',\n    0x0127: 'COPY.TOOL',\n    0x0128: 'RESET.TOOL',\n    0x0129: 'CONSTRAIN.NUMERIC',\n    0x012A: 'PASTE.TOOL',\n    0x012E: 'WORKBOOK.NEW',\n    0x0131: 'SCENARIO.CELLS',\n    0x0132: 'SCENARIO.DELETE',\n    0x0133: 'SCENARIO.ADD',\n    0x0134: 'SCENARIO.EDIT',\n    0x0135: 'SCENARIO.SHOW',\n    0x0136: 'SCENARIO.SHOW.NEXT',\n    0x0137: 'SCENARIO.SUMMARY',\n    0x0138: 'PIVOT.TABLE.WIZARD',\n    0x0139: 'PIVOT.FIELD.PROPERTIES',\n    0x013A: 'PIVOT.FIELD',\n    0x013B: 'PIVOT.ITEM',\n    0x013C: 'PIVOT.ADD.FIELDS',\n    0x013E: 'OPTIONS.CALCULATION',\n    0x013F: 'OPTIONS.EDIT',\n    0x0140: 'OPTIONS.VIEW',\n    0x0141: 'ADDIN.MANAGER',\n    0x0142: 'MENU.EDITOR',\n    0x0143: 'ATTACH.TOOLBARS',\n    0x0144: 'VBAActivate',\n    0x0145: 'OPTIONS.CHART',\n    0x0148: 'VBA.INSERT.FILE',\n    0x014A: 'VBA.PROCEDURE.DEFINITION',\n    0x0150: 'ROUTING.SLIP',\n    0x0152: 'ROUTE.DOCUMENT',\n    0x0153: 'MAIL.LOGON',\n    0x0156: 'INSERT.PICTURE',\n    0x0157: 'EDIT.TOOL',\n    0x0158: 'GALLERY.DOUGHNUT',\n    0x015E: 'CHART.TREND',\n    0x0160: 'PIVOT.ITEM.PROPERTIES',\n    0x0162: 'WORKBOOK.INSERT',\n    0x0163: 'OPTIONS.TRANSITION',\n    0x0164: 'OPTIONS.GENERAL',\n    0x0172: 'FILTER.ADVANCED',\n    0x0175: 'MAIL.ADD.MAILER',\n    0x0176: 'MAIL.DELETE.MAILER',\n    0x0177: 'MAIL.REPLY',\n    0x0178: 'MAIL.REPLY.ALL',\n    0x0179: 'MAIL.FORWARD',\n    0x017A: 'MAIL.NEXT.LETTER',\n    0x017B: 'DATA.LABEL',\n    0x017C: 'INSERT.TITLE',\n    0x017D: 'FONT.PROPERTIES',\n    0x017E: 'MACRO.OPTIONS',\n    0x017F: 'WORKBOOK.HIDE',\n    0x0180: 'WORKBOOK.UNHIDE',\n    0x0181: 'WORKBOOK.DELETE',\n    0x0182: 'WORKBOOK.NAME',\n    0x0184: 'GALLERY.CUSTOM',\n    0x0186: 'ADD.CHART.AUTOFORMAT',\n    0x0187: 'DELETE.CHART.AUTOFORMAT',\n    0x0188: 'CHART.ADD.DATA',\n    0x0189: 'AUTO.OUTLINE',\n    0x018A: 'TAB.ORDER',\n    0x018B: 'SHOW.DIALOG',\n    0x018C: 'SELECT.ALL',\n    0x018D: 'UNGROUP.SHEETS',\n    0x018E: 'SUBTOTAL.CREATE',\n    0x018F: 'SUBTOTAL.REMOVE',\n    0x0190: 'RENAME.OBJECT',\n    0x019C: 'WORKBOOK.SCROLL',\n    0x019D: 'WORKBOOK.NEXT',\n    0x019E: 'WORKBOOK.PREV',\n    0x019F: 'WORKBOOK.TAB.SPLIT',\n    0x01A0: 'FULL.SCREEN',\n    0x01A1: 'WORKBOOK.PROTECT',\n    0x01A4: 'SCROLLBAR.PROPERTIES',\n    0x01A5: 'PIVOT.SHOW.PAGES',\n    0x01A6: 'TEXT.TO.COLUMNS',\n    0x01A7: 'FORMAT.CHARTTYPE',\n    0x01A8: 'LINK.FORMAT',\n    0x01A9: 'TRACER.DISPLAY',\n    0x01AE: 'TRACER.NAVIGATE',\n    0x01AF: 'TRACER.CLEAR',\n    0x01B0: 'TRACER.ERROR',\n    0x01B1: 'PIVOT.FIELD.GROUP',\n    0x01B2: 'PIVOT.FIELD.UNGROUP',\n    0x01B3: 'CHECKBOX.PROPERTIES',\n    0x01B4: 'LABEL.PROPERTIES',\n    0x01B5: 'LISTBOX.PROPERTIES',\n    0x01B6: 'EDITBOX.PROPERTIES',\n    0x01B7: 'PIVOT.REFRESH',\n    0x01B8: 'LINK.COMBO',\n    0x01B9: 'OPEN.TEXT',\n    0x01BA: 'HIDE.DIALOG',\n    0x01BB: 'SET.DIALOG.FOCUS',\n    0x01BC: 'ENABLE.OBJECT',\n    0x01BD: 'PUSHBUTTON.PROPERTIES',\n    0x01BE: 'SET.DIALOG.DEFAULT',\n    0x01BF: 'FILTER',\n    0x01C0: 'FILTER.SHOW.ALL',\n    0x01C1: 'CLEAR.OUTLINE',\n    0x01C2: 'FUNCTION.WIZARD',\n    0x01C3: 'ADD.LIST.ITEM',\n    0x01C4: 'SET.LIST.ITEM',\n    0x01C5: 'REMOVE.LIST.ITEM',\n    0x01C6: 'SELECT.LIST.ITEM',\n    0x01C7: 'SET.CONTROL.VALUE',\n    0x01C8: 'SAVE.COPY.AS',\n    0x01CA: 'OPTIONS.LISTS.ADD',\n    0x01CB: 'OPTIONS.LISTS.DELETE',\n    0x01CC: 'SERIES.AXES',\n    0x01CD: 'SERIES.X',\n    0x01CE: 'SERIES.Y',\n    0x01CF: 'ERRORBAR.X',\n    0x01D0: 'ERRORBAR.Y',\n    0x01D1: 'FORMAT.CHART',\n    0x01D2: 'SERIES.ORDER',\n    0x01D3: 'MAIL.LOGOFF',\n    0x01D4: 'CLEAR.ROUTING.SLIP',\n    0x01D5: 'APP.ACTIVATE.MICROSOFT',\n    0x01D6: 'MAIL.EDIT.MAILER',\n    0x01D7: 'ON.SHEET',\n    0x01D8: 'STANDARD.WIDTH',\n    0x01D9: 'SCENARIO.MERGE',\n    0x01DA: 'SUMMARY.INFO',\n    0x01DB: 'FIND.FILE',\n    0x01DC: 'ACTIVE.CELL.FONT',\n    0x01DD: 'ENABLE.TIPWIZARD',\n    0x01DE: 'VBA.MAKE.ADDIN',\n    0x01E0: 'INSERTDATATABLE',\n    0x01E1: 'WORKGROUP.OPTIONS',\n    0x01E2: 'MAIL.SEND.MAILER',\n    0x01E5: 'AUTOCORRECT',\n    0x01E9: 'POST.DOCUMENT',\n    0x01EB: 'PICKLIST',\n    0x01ED: 'VIEW.SHOW',\n    0x01EE: 'VIEW.DEFINE',\n    0x01EF: 'VIEW.DELETE',\n    0x01FD: 'SHEET.BACKGROUND',\n    0x01FE: 'INSERT.MAP.OBJECT',\n    0x01FF: 'OPTIONS.MENONO',\n    0x0205: 'MSOCHECKS',\n    0x0206: 'NORMAL',\n    0x0207: 'LAYOUT',\n    0x0208: 'RM.PRINT.AREA',\n    0x0209: 'CLEAR.PRINT.AREA',\n    0x020A: 'ADD.PRINT.AREA',\n    0x020B: 'MOVE.BRK',\n    0x0221: 'HIDECURR.NOTE',\n    0x0222: 'HIDEALL.NOTES',\n    0x0223: 'DELETE.NOTE',\n    0x0224: 'TRAVERSE.NOTES',\n    0x0225: 'ACTIVATE.NOTES',\n    0x026C: 'PROTECT.REVISIONS',\n    0x026D: 'UNPROTECT.REVISIONS',\n    0x0287: 'OPTIONS.ME',\n    0x028D: 'WEB.PUBLISH',\n    0x029B: 'NEWWEBQUERY',\n    0x02A1: 'PIVOT.TABLE.CHART',\n    0x02F1: 'OPTIONS.SAVE',\n    0x02F3: 'OPTIONS.SPELL',\n    0x0328: 'HIDEALL.INKANNOTS'\n};\n\n/* [MS-XLS] 2.5.198.17 */\nvar Ftab = {\n    0x0000: 'COUNT',\n    0x0001: 'IF',\n    0x0002: 'ISNA',\n    0x0003: 'ISERROR',\n    0x0004: 'SUM',\n    0x0005: 'AVERAGE',\n    0x0006: 'MIN',\n    0x0007: 'MAX',\n    0x0008: 'ROW',\n    0x0009: 'COLUMN',\n    0x000A: 'NA',\n    0x000B: 'NPV',\n    0x000C: 'STDEV',\n    0x000D: 'DOLLAR',\n    0x000E: 'FIXED',\n    0x000F: 'SIN',\n    0x0010: 'COS',\n    0x0011: 'TAN',\n    0x0012: 'ATAN',\n    0x0013: 'PI',\n    0x0014: 'SQRT',\n    0x0015: 'EXP',\n    0x0016: 'LN',\n    0x0017: 'LOG10',\n    0x0018: 'ABS',\n    0x0019: 'INT',\n    0x001A: 'SIGN',\n    0x001B: 'ROUND',\n    0x001C: 'LOOKUP',\n    0x001D: 'INDEX',\n    0x001E: 'REPT',\n    0x001F: 'MID',\n    0x0020: 'LEN',\n    0x0021: 'VALUE',\n    0x0022: 'TRUE',\n    0x0023: 'FALSE',\n    0x0024: 'AND',\n    0x0025: 'OR',\n    0x0026: 'NOT',\n    0x0027: 'MOD',\n    0x0028: 'DCOUNT',\n    0x0029: 'DSUM',\n    0x002A: 'DAVERAGE',\n    0x002B: 'DMIN',\n    0x002C: 'DMAX',\n    0x002D: 'DSTDEV',\n    0x002E: 'VAR',\n    0x002F: 'DVAR',\n    0x0030: 'TEXT',\n    0x0031: 'LINEST',\n    0x0032: 'TREND',\n    0x0033: 'LOGEST',\n    0x0034: 'GROWTH',\n    0x0035: 'GOTO',\n    0x0036: 'HALT',\n    0x0037: 'RETURN',\n    0x0038: 'PV',\n    0x0039: 'FV',\n    0x003A: 'NPER',\n    0x003B: 'PMT',\n    0x003C: 'RATE',\n    0x003D: 'MIRR',\n    0x003E: 'IRR',\n    0x003F: 'RAND',\n    0x0040: 'MATCH',\n    0x0041: 'DATE',\n    0x0042: 'TIME',\n    0x0043: 'DAY',\n    0x0044: 'MONTH',\n    0x0045: 'YEAR',\n    0x0046: 'WEEKDAY',\n    0x0047: 'HOUR',\n    0x0048: 'MINUTE',\n    0x0049: 'SECOND',\n    0x004A: 'NOW',\n    0x004B: 'AREAS',\n    0x004C: 'ROWS',\n    0x004D: 'COLUMNS',\n    0x004E: 'OFFSET',\n    0x004F: 'ABSREF',\n    0x0050: 'RELREF',\n    0x0051: 'ARGUMENT',\n    0x0052: 'SEARCH',\n    0x0053: 'TRANSPOSE',\n    0x0054: 'ERROR',\n    0x0055: 'STEP',\n    0x0056: 'TYPE',\n    0x0057: 'ECHO',\n    0x0058: 'SET.NAME',\n    0x0059: 'CALLER',\n    0x005A: 'DEREF',\n    0x005B: 'WINDOWS',\n    0x005C: 'SERIES',\n    0x005D: 'DOCUMENTS',\n    0x005E: 'ACTIVE.CELL',\n    0x005F: 'SELECTION',\n    0x0060: 'RESULT',\n    0x0061: 'ATAN2',\n    0x0062: 'ASIN',\n    0x0063: 'ACOS',\n    0x0064: 'CHOOSE',\n    0x0065: 'HLOOKUP',\n    0x0066: 'VLOOKUP',\n    0x0067: 'LINKS',\n    0x0068: 'INPUT',\n    0x0069: 'ISREF',\n    0x006A: 'GET.FORMULA',\n    0x006B: 'GET.NAME',\n    0x006C: 'SET.VALUE',\n    0x006D: 'LOG',\n    0x006E: 'EXEC',\n    0x006F: 'CHAR',\n    0x0070: 'LOWER',\n    0x0071: 'UPPER',\n    0x0072: 'PROPER',\n    0x0073: 'LEFT',\n    0x0074: 'RIGHT',\n    0x0075: 'EXACT',\n    0x0076: 'TRIM',\n    0x0077: 'REPLACE',\n    0x0078: 'SUBSTITUTE',\n    0x0079: 'CODE',\n    0x007A: 'NAMES',\n    0x007B: 'DIRECTORY',\n    0x007C: 'FIND',\n    0x007D: 'CELL',\n    0x007E: 'ISERR',\n    0x007F: 'ISTEXT',\n    0x0080: 'ISNUMBER',\n    0x0081: 'ISBLANK',\n    0x0082: 'T',\n    0x0083: 'N',\n    0x0084: 'FOPEN',\n    0x0085: 'FCLOSE',\n    0x0086: 'FSIZE',\n    0x0087: 'FREADLN',\n    0x0088: 'FREAD',\n    0x0089: 'FWRITELN',\n    0x008A: 'FWRITE',\n    0x008B: 'FPOS',\n    0x008C: 'DATEVALUE',\n    0x008D: 'TIMEVALUE',\n    0x008E: 'SLN',\n    0x008F: 'SYD',\n    0x0090: 'DDB',\n    0x0091: 'GET.DEF',\n    0x0092: 'REFTEXT',\n    0x0093: 'TEXTREF',\n    0x0094: 'INDIRECT',\n    0x0095: 'REGISTER',\n    0x0096: 'CALL',\n    0x0097: 'ADD.BAR',\n    0x0098: 'ADD.MENU',\n    0x0099: 'ADD.COMMAND',\n    0x009A: 'ENABLE.COMMAND',\n    0x009B: 'CHECK.COMMAND',\n    0x009C: 'RENAME.COMMAND',\n    0x009D: 'SHOW.BAR',\n    0x009E: 'DELETE.MENU',\n    0x009F: 'DELETE.COMMAND',\n    0x00A0: 'GET.CHART.ITEM',\n    0x00A1: 'DIALOG.BOX',\n    0x00A2: 'CLEAN',\n    0x00A3: 'MDETERM',\n    0x00A4: 'MINVERSE',\n    0x00A5: 'MMULT',\n    0x00A6: 'FILES',\n    0x00A7: 'IPMT',\n    0x00A8: 'PPMT',\n    0x00A9: 'COUNTA',\n    0x00AA: 'CANCEL.KEY',\n    0x00AB: 'FOR',\n    0x00AC: 'WHILE',\n    0x00AD: 'BREAK',\n    0x00AE: 'NEXT',\n    0x00AF: 'INITIATE',\n    0x00B0: 'REQUEST',\n    0x00B1: 'POKE',\n    0x00B2: 'EXECUTE',\n    0x00B3: 'TERMINATE',\n    0x00B4: 'RESTART',\n    0x00B5: 'HELP',\n    0x00B6: 'GET.BAR',\n    0x00B7: 'PRODUCT',\n    0x00B8: 'FACT',\n    0x00B9: 'GET.CELL',\n    0x00BA: 'GET.WORKSPACE',\n    0x00BB: 'GET.WINDOW',\n    0x00BC: 'GET.DOCUMENT',\n    0x00BD: 'DPRODUCT',\n    0x00BE: 'ISNONTEXT',\n    0x00BF: 'GET.NOTE',\n    0x00C0: 'NOTE',\n    0x00C1: 'STDEVP',\n    0x00C2: 'VARP',\n    0x00C3: 'DSTDEVP',\n    0x00C4: 'DVARP',\n    0x00C5: 'TRUNC',\n    0x00C6: 'ISLOGICAL',\n    0x00C7: 'DCOUNTA',\n    0x00C8: 'DELETE.BAR',\n    0x00C9: 'UNREGISTER',\n    0x00CC: 'USDOLLAR',\n    0x00CD: 'FINDB',\n    0x00CE: 'SEARCHB',\n    0x00CF: 'REPLACEB',\n    0x00D0: 'LEFTB',\n    0x00D1: 'RIGHTB',\n    0x00D2: 'MIDB',\n    0x00D3: 'LENB',\n    0x00D4: 'ROUNDUP',\n    0x00D5: 'ROUNDDOWN',\n    0x00D6: 'ASC',\n    0x00D7: 'DBCS',\n    0x00D8: 'RANK',\n    0x00DB: 'ADDRESS',\n    0x00DC: 'DAYS360',\n    0x00DD: 'TODAY',\n    0x00DE: 'VDB',\n    0x00DF: 'ELSE',\n    0x00E0: 'ELSE.IF',\n    0x00E1: 'END.IF',\n    0x00E2: 'FOR.CELL',\n    0x00E3: 'MEDIAN',\n    0x00E4: 'SUMPRODUCT',\n    0x00E5: 'SINH',\n    0x00E6: 'COSH',\n    0x00E7: 'TANH',\n    0x00E8: 'ASINH',\n    0x00E9: 'ACOSH',\n    0x00EA: 'ATANH',\n    0x00EB: 'DGET',\n    0x00EC: 'CREATE.OBJECT',\n    0x00ED: 'VOLATILE',\n    0x00EE: 'LAST.ERROR',\n    0x00EF: 'CUSTOM.UNDO',\n    0x00F0: 'CUSTOM.REPEAT',\n    0x00F1: 'FORMULA.CONVERT',\n    0x00F2: 'GET.LINK.INFO',\n    0x00F3: 'TEXT.BOX',\n    0x00F4: 'INFO',\n    0x00F5: 'GROUP',\n    0x00F6: 'GET.OBJECT',\n    0x00F7: 'DB',\n    0x00F8: 'PAUSE',\n    0x00FB: 'RESUME',\n    0x00FC: 'FREQUENCY',\n    0x00FD: 'ADD.TOOLBAR',\n    0x00FE: 'DELETE.TOOLBAR',\n    0x00FF: 'User',\n    0x0100: 'RESET.TOOLBAR',\n    0x0101: 'EVALUATE',\n    0x0102: 'GET.TOOLBAR',\n    0x0103: 'GET.TOOL',\n    0x0104: 'SPELLING.CHECK',\n    0x0105: 'ERROR.TYPE',\n    0x0106: 'APP.TITLE',\n    0x0107: 'WINDOW.TITLE',\n    0x0108: 'SAVE.TOOLBAR',\n    0x0109: 'ENABLE.TOOL',\n    0x010A: 'PRESS.TOOL',\n    0x010B: 'REGISTER.ID',\n    0x010C: 'GET.WORKBOOK',\n    0x010D: 'AVEDEV',\n    0x010E: 'BETADIST',\n    0x010F: 'GAMMALN',\n    0x0110: 'BETAINV',\n    0x0111: 'BINOMDIST',\n    0x0112: 'CHIDIST',\n    0x0113: 'CHIINV',\n    0x0114: 'COMBIN',\n    0x0115: 'CONFIDENCE',\n    0x0116: 'CRITBINOM',\n    0x0117: 'EVEN',\n    0x0118: 'EXPONDIST',\n    0x0119: 'FDIST',\n    0x011A: 'FINV',\n    0x011B: 'FISHER',\n    0x011C: 'FISHERINV',\n    0x011D: 'FLOOR',\n    0x011E: 'GAMMADIST',\n    0x011F: 'GAMMAINV',\n    0x0120: 'CEILING',\n    0x0121: 'HYPGEOMDIST',\n    0x0122: 'LOGNORMDIST',\n    0x0123: 'LOGINV',\n    0x0124: 'NEGBINOMDIST',\n    0x0125: 'NORMDIST',\n    0x0126: 'NORMSDIST',\n    0x0127: 'NORMINV',\n    0x0128: 'NORMSINV',\n    0x0129: 'STANDARDIZE',\n    0x012A: 'ODD',\n    0x012B: 'PERMUT',\n    0x012C: 'POISSON',\n    0x012D: 'TDIST',\n    0x012E: 'WEIBULL',\n    0x012F: 'SUMXMY2',\n    0x0130: 'SUMX2MY2',\n    0x0131: 'SUMX2PY2',\n    0x0132: 'CHITEST',\n    0x0133: 'CORREL',\n    0x0134: 'COVAR',\n    0x0135: 'FORECAST',\n    0x0136: 'FTEST',\n    0x0137: 'INTERCEPT',\n    0x0138: 'PEARSON',\n    0x0139: 'RSQ',\n    0x013A: 'STEYX',\n    0x013B: 'SLOPE',\n    0x013C: 'TTEST',\n    0x013D: 'PROB',\n    0x013E: 'DEVSQ',\n    0x013F: 'GEOMEAN',\n    0x0140: 'HARMEAN',\n    0x0141: 'SUMSQ',\n    0x0142: 'KURT',\n    0x0143: 'SKEW',\n    0x0144: 'ZTEST',\n    0x0145: 'LARGE',\n    0x0146: 'SMALL',\n    0x0147: 'QUARTILE',\n    0x0148: 'PERCENTILE',\n    0x0149: 'PERCENTRANK',\n    0x014A: 'MODE',\n    0x014B: 'TRIMMEAN',\n    0x014C: 'TINV',\n    0x014E: 'MOVIE.COMMAND',\n    0x014F: 'GET.MOVIE',\n    0x0150: 'CONCATENATE',\n    0x0151: 'POWER',\n    0x0152: 'PIVOT.ADD.DATA',\n    0x0153: 'GET.PIVOT.TABLE',\n    0x0154: 'GET.PIVOT.FIELD',\n    0x0155: 'GET.PIVOT.ITEM',\n    0x0156: 'RADIANS',\n    0x0157: 'DEGREES',\n    0x0158: 'SUBTOTAL',\n    0x0159: 'SUMIF',\n    0x015A: 'COUNTIF',\n    0x015B: 'COUNTBLANK',\n    0x015C: 'SCENARIO.GET',\n    0x015D: 'OPTIONS.LISTS.GET',\n    0x015E: 'ISPMT',\n    0x015F: 'DATEDIF',\n    0x0160: 'DATESTRING',\n    0x0161: 'NUMBERSTRING',\n    0x0162: 'ROMAN',\n    0x0163: 'OPEN.DIALOG',\n    0x0164: 'SAVE.DIALOG',\n    0x0165: 'VIEW.GET',\n    0x0166: 'GETPIVOTDATA',\n    0x0167: 'HYPERLINK',\n    0x0168: 'PHONETIC',\n    0x0169: 'AVERAGEA',\n    0x016A: 'MAXA',\n    0x016B: 'MINA',\n    0x016C: 'STDEVPA',\n    0x016D: 'VARPA',\n    0x016E: 'STDEVA',\n    0x016F: 'VARA',\n    0x0170: 'BAHTTEXT',\n    0x0171: 'THAIDAYOFWEEK',\n    0x0172: 'THAIDIGIT',\n    0x0173: 'THAIMONTHOFYEAR',\n    0x0174: 'THAINUMSOUND',\n    0x0175: 'THAINUMSTRING',\n    0x0176: 'THAISTRINGLENGTH',\n    0x0177: 'ISTHAIDIGIT',\n    0x0178: 'ROUNDBAHTDOWN',\n    0x0179: 'ROUNDBAHTUP',\n    0x017A: 'THAIYEAR',\n    0x017B: 'RTD'\n};\nvar FtabArgc = {\n    0x0002: 1, /* ISNA */\n    0x0003: 1, /* ISERROR */\n    0x000F: 1, /* SIN */\n    0x0010: 1, /* COS */\n    0x0011: 1, /* TAN */\n    0x0012: 1, /* ATAN */\n    0x0014: 1, /* SQRT */\n    0x0015: 1, /* EXP */\n    0x0016: 1, /* LN */\n    0x0017: 1, /* LOG10 */\n    0x0018: 1, /* ABS */\n    0x0019: 1, /* INT */\n    0x001A: 1, /* SIGN */\n    0x001B: 2, /* ROUND */\n    0x001E: 2, /* REPT */\n    0x001F: 3, /* MID */\n    0x0020: 1, /* LEN */\n    0x0021: 1, /* VALUE */\n    0x0026: 1, /* NOT */\n    0x0027: 2, /* MOD */\n    0x0028: 3, /* DCOUNT */\n    0x0029: 3, /* DSUM */\n    0x002A: 3, /* DAVERAGE */\n    0x002B: 3, /* DMIN */\n    0x002C: 3, /* DMAX */\n    0x002D: 3, /* DSTDEV */\n    0x002F: 3, /* DVAR */\n    0x0030: 2, /* TEXT */\n    0x0035: 1, /* GOTO */\n    0x003D: 3, /* MIRR */\n    0x0041: 3, /* DATE */\n    0x0042: 3, /* TIME */\n    0x0043: 1, /* DAY */\n    0x0044: 1, /* MONTH */\n    0x0045: 1, /* YEAR */\n    0x0047: 1, /* HOUR */\n    0x0048: 1, /* MINUTE */\n    0x0049: 1, /* SECOND */\n    0x004B: 1, /* AREAS */\n    0x004C: 1, /* ROWS */\n    0x004D: 1, /* COLUMNS */\n    0x004F: 2, /* ABSREF */\n    0x0050: 2, /* RELREF */\n    0x0053: 1, /* TRANSPOSE */\n    0x0056: 1, /* TYPE */\n    0x005A: 1, /* DEREF */\n    0x0061: 2, /* ATAN2 */\n    0x0062: 1, /* ASIN */\n    0x0063: 1, /* ACOS */\n    0x0069: 1, /* ISREF */\n    0x006F: 1, /* CHAR */\n    0x0070: 1, /* LOWER */\n    0x0071: 1, /* UPPER */\n    0x0072: 1, /* PROPER */\n    0x0075: 2, /* EXACT */\n    0x0076: 1, /* TRIM */\n    0x0077: 4, /* REPLACE */\n    0x0079: 1, /* CODE */\n    0x007E: 1, /* ISERR */\n    0x007F: 1, /* ISTEXT */\n    0x0080: 1, /* ISNUMBER */\n    0x0081: 1, /* ISBLANK */\n    0x0082: 1, /* T */\n    0x0083: 1, /* N */\n    0x0085: 1, /* FCLOSE */\n    0x0086: 1, /* FSIZE */\n    0x0087: 1, /* FREADLN */\n    0x0088: 2, /* FREAD */\n    0x0089: 2, /* FWRITELN */\n    0x008A: 2, /* FWRITE */\n    0x008C: 1, /* DATEVALUE */\n    0x008D: 1, /* TIMEVALUE */\n    0x008E: 3, /* SLN */\n    0x008F: 4, /* SYD */\n    0x00A2: 1, /* CLEAN */\n    0x00A3: 1, /* MDETERM */\n    0x00A4: 1, /* MINVERSE */\n    0x00A5: 2, /* MMULT */\n    0x00AC: 1, /* WHILE */\n    0x00AF: 2, /* INITIATE */\n    0x00B0: 2, /* REQUEST */\n    0x00B1: 3, /* POKE */\n    0x00B2: 2, /* EXECUTE */\n    0x00B3: 1, /* TERMINATE */\n    0x00B8: 1, /* FACT */\n    0x00BD: 3, /* DPRODUCT */\n    0x00BE: 1, /* ISNONTEXT */\n    0x00C3: 3, /* DSTDEVP */\n    0x00C4: 3, /* DVARP */\n    0x00C6: 1, /* ISLOGICAL */\n    0x00C7: 3, /* DCOUNTA */\n    0x00C9: 1, /* UNREGISTER */\n    0x00CF: 4, /* REPLACEB */\n    0x00D2: 3, /* MIDB */\n    0x00D3: 1, /* LENB */\n    0x00D4: 2, /* ROUNDUP */\n    0x00D5: 2, /* ROUNDDOWN */\n    0x00D6: 1, /* ASC */\n    0x00D7: 1, /* DBCS */\n    0x00E5: 1, /* SINH */\n    0x00E6: 1, /* COSH */\n    0x00E7: 1, /* TANH */\n    0x00E8: 1, /* ASINH */\n    0x00E9: 1, /* ACOSH */\n    0x00EA: 1, /* ATANH */\n    0x00EB: 3, /* DGET */\n    0x00F4: 1, /* INFO */\n    0x00FC: 2, /* FREQUENCY */\n    0x0101: 1, /* EVALUATE */\n    0x0105: 1, /* ERROR.TYPE */\n    0x010F: 1, /* GAMMALN */\n    0x0111: 4, /* BINOMDIST */\n    0x0112: 2, /* CHIDIST */\n    0x0113: 2, /* CHIINV */\n    0x0114: 2, /* COMBIN */\n    0x0115: 3, /* CONFIDENCE */\n    0x0116: 3, /* CRITBINOM */\n    0x0117: 1, /* EVEN */\n    0x0118: 3, /* EXPONDIST */\n    0x0119: 3, /* FDIST */\n    0x011A: 3, /* FINV */\n    0x011B: 1, /* FISHER */\n    0x011C: 1, /* FISHERINV */\n    0x011D: 2, /* FLOOR */\n    0x011E: 4, /* GAMMADIST */\n    0x011F: 3, /* GAMMAINV */\n    0x0120: 2, /* CEILING */\n    0x0121: 4, /* HYPGEOMDIST */\n    0x0122: 3, /* LOGNORMDIST */\n    0x0123: 3, /* LOGINV */\n    0x0124: 3, /* NEGBINOMDIST */\n    0x0125: 4, /* NORMDIST */\n    0x0126: 1, /* NORMSDIST */\n    0x0127: 3, /* NORMINV */\n    0x0128: 1, /* NORMSINV */\n    0x0129: 3, /* STANDARDIZE */\n    0x012A: 1, /* ODD */\n    0x012B: 2, /* PERMUT */\n    0x012C: 3, /* POISSON */\n    0x012D: 3, /* TDIST */\n    0x012E: 4, /* WEIBULL */\n    0x012F: 2, /* SUMXMY2 */\n    0x0130: 2, /* SUMX2MY2 */\n    0x0131: 2, /* SUMX2PY2 */\n    0x0132: 2, /* CHITEST */\n    0x0133: 2, /* CORREL */\n    0x0134: 2, /* COVAR */\n    0x0135: 3, /* FORECAST */\n    0x0136: 2, /* FTEST */\n    0x0137: 2, /* INTERCEPT */\n    0x0138: 2, /* PEARSON */\n    0x0139: 2, /* RSQ */\n    0x013A: 2, /* STEYX */\n    0x013B: 2, /* SLOPE */\n    0x013C: 4, /* TTEST */\n    0x0145: 2, /* LARGE */\n    0x0146: 2, /* SMALL */\n    0x0147: 2, /* QUARTILE */\n    0x0148: 2, /* PERCENTILE */\n    0x014B: 2, /* TRIMMEAN */\n    0x014C: 2, /* TINV */\n    0x0151: 2, /* POWER */\n    0x0156: 1, /* RADIANS */\n    0x0157: 1, /* DEGREES */\n    0x015A: 2, /* COUNTIF */\n    0x015B: 1, /* COUNTBLANK */\n    0x015E: 4, /* ISPMT */\n    0x015F: 3, /* DATEDIF */\n    0x0160: 1, /* DATESTRING */\n    0x0161: 2, /* NUMBERSTRING */\n    0x0168: 1, /* PHONETIC */\n    0x0170: 1, /* BAHTTEXT */\n    0x0171: 1, /* THAIDAYOFWEEK */\n    0x0172: 1, /* THAIDIGIT */\n    0x0173: 1, /* THAIMONTHOFYEAR */\n    0x0174: 1, /* THAINUMSOUND */\n    0x0175: 1, /* THAINUMSTRING */\n    0x0176: 1, /* THAISTRINGLENGTH */\n    0x0177: 1, /* ISTHAIDIGIT */\n    0x0178: 1, /* ROUNDBAHTDOWN */\n    0x0179: 1, /* ROUNDBAHTUP */\n    0x017A: 1, /* THAIYEAR */\n    0xFFFF: 0\n};\n/* [MS-XLSX] 2.2.3 Functions */\nvar XLSXFutureFunctions = {\n    \"_xlfn.ACOT\": \"ACOT\",\n    \"_xlfn.ACOTH\": \"ACOTH\",\n    \"_xlfn.AGGREGATE\": \"AGGREGATE\",\n    \"_xlfn.ARABIC\": \"ARABIC\",\n    \"_xlfn.AVERAGEIF\": \"AVERAGEIF\",\n    \"_xlfn.AVERAGEIFS\": \"AVERAGEIFS\",\n    \"_xlfn.BASE\": \"BASE\",\n    \"_xlfn.BETA.DIST\": \"BETA.DIST\",\n    \"_xlfn.BETA.INV\": \"BETA.INV\",\n    \"_xlfn.BINOM.DIST\": \"BINOM.DIST\",\n    \"_xlfn.BINOM.DIST.RANGE\": \"BINOM.DIST.RANGE\",\n    \"_xlfn.BINOM.INV\": \"BINOM.INV\",\n    \"_xlfn.BITAND\": \"BITAND\",\n    \"_xlfn.BITLSHIFT\": \"BITLSHIFT\",\n    \"_xlfn.BITOR\": \"BITOR\",\n    \"_xlfn.BITRSHIFT\": \"BITRSHIFT\",\n    \"_xlfn.BITXOR\": \"BITXOR\",\n    \"_xlfn.CEILING.MATH\": \"CEILING.MATH\",\n    \"_xlfn.CEILING.PRECISE\": \"CEILING.PRECISE\",\n    \"_xlfn.CHISQ.DIST\": \"CHISQ.DIST\",\n    \"_xlfn.CHISQ.DIST.RT\": \"CHISQ.DIST.RT\",\n    \"_xlfn.CHISQ.INV\": \"CHISQ.INV\",\n    \"_xlfn.CHISQ.INV.RT\": \"CHISQ.INV.RT\",\n    \"_xlfn.CHISQ.TEST\": \"CHISQ.TEST\",\n    \"_xlfn.COMBINA\": \"COMBINA\",\n    \"_xlfn.CONFIDENCE.NORM\": \"CONFIDENCE.NORM\",\n    \"_xlfn.CONFIDENCE.T\": \"CONFIDENCE.T\",\n    \"_xlfn.COT\": \"COT\",\n    \"_xlfn.COTH\": \"COTH\",\n    \"_xlfn.COUNTIFS\": \"COUNTIFS\",\n    \"_xlfn.COVARIANCE.P\": \"COVARIANCE.P\",\n    \"_xlfn.COVARIANCE.S\": \"COVARIANCE.S\",\n    \"_xlfn.CSC\": \"CSC\",\n    \"_xlfn.CSCH\": \"CSCH\",\n    \"_xlfn.DAYS\": \"DAYS\",\n    \"_xlfn.DECIMAL\": \"DECIMAL\",\n    \"_xlfn.ECMA.CEILING\": \"ECMA.CEILING\",\n    \"_xlfn.ERF.PRECISE\": \"ERF.PRECISE\",\n    \"_xlfn.ERFC.PRECISE\": \"ERFC.PRECISE\",\n    \"_xlfn.EXPON.DIST\": \"EXPON.DIST\",\n    \"_xlfn.F.DIST\": \"F.DIST\",\n    \"_xlfn.F.DIST.RT\": \"F.DIST.RT\",\n    \"_xlfn.F.INV\": \"F.INV\",\n    \"_xlfn.F.INV.RT\": \"F.INV.RT\",\n    \"_xlfn.F.TEST\": \"F.TEST\",\n    \"_xlfn.FILTERXML\": \"FILTERXML\",\n    \"_xlfn.FLOOR.MATH\": \"FLOOR.MATH\",\n    \"_xlfn.FLOOR.PRECISE\": \"FLOOR.PRECISE\",\n    \"_xlfn.FORMULATEXT\": \"FORMULATEXT\",\n    \"_xlfn.GAMMA\": \"GAMMA\",\n    \"_xlfn.GAMMA.DIST\": \"GAMMA.DIST\",\n    \"_xlfn.GAMMA.INV\": \"GAMMA.INV\",\n    \"_xlfn.GAMMALN.PRECISE\": \"GAMMALN.PRECISE\",\n    \"_xlfn.GAUSS\": \"GAUSS\",\n    \"_xlfn.HYPGEOM.DIST\": \"HYPGEOM.DIST\",\n    \"_xlfn.IFNA\": \"IFNA\",\n    \"_xlfn.IFERROR\": \"IFERROR\",\n    \"_xlfn.IMCOSH\": \"IMCOSH\",\n    \"_xlfn.IMCOT\": \"IMCOT\",\n    \"_xlfn.IMCSC\": \"IMCSC\",\n    \"_xlfn.IMCSCH\": \"IMCSCH\",\n    \"_xlfn.IMSEC\": \"IMSEC\",\n    \"_xlfn.IMSECH\": \"IMSECH\",\n    \"_xlfn.IMSINH\": \"IMSINH\",\n    \"_xlfn.IMTAN\": \"IMTAN\",\n    \"_xlfn.ISFORMULA\": \"ISFORMULA\",\n    \"_xlfn.ISO.CEILING\": \"ISO.CEILING\",\n    \"_xlfn.ISOWEEKNUM\": \"ISOWEEKNUM\",\n    \"_xlfn.LOGNORM.DIST\": \"LOGNORM.DIST\",\n    \"_xlfn.LOGNORM.INV\": \"LOGNORM.INV\",\n    \"_xlfn.MODE.MULT\": \"MODE.MULT\",\n    \"_xlfn.MODE.SNGL\": \"MODE.SNGL\",\n    \"_xlfn.MUNIT\": \"MUNIT\",\n    \"_xlfn.NEGBINOM.DIST\": \"NEGBINOM.DIST\",\n    \"_xlfn.NETWORKDAYS.INTL\": \"NETWORKDAYS.INTL\",\n    \"_xlfn.NIGBINOM\": \"NIGBINOM\",\n    \"_xlfn.NORM.DIST\": \"NORM.DIST\",\n    \"_xlfn.NORM.INV\": \"NORM.INV\",\n    \"_xlfn.NORM.S.DIST\": \"NORM.S.DIST\",\n    \"_xlfn.NORM.S.INV\": \"NORM.S.INV\",\n    \"_xlfn.NUMBERVALUE\": \"NUMBERVALUE\",\n    \"_xlfn.PDURATION\": \"PDURATION\",\n    \"_xlfn.PERCENTILE.EXC\": \"PERCENTILE.EXC\",\n    \"_xlfn.PERCENTILE.INC\": \"PERCENTILE.INC\",\n    \"_xlfn.PERCENTRANK.EXC\": \"PERCENTRANK.EXC\",\n    \"_xlfn.PERCENTRANK.INC\": \"PERCENTRANK.INC\",\n    \"_xlfn.PERMUTATIONA\": \"PERMUTATIONA\",\n    \"_xlfn.PHI\": \"PHI\",\n    \"_xlfn.POISSON.DIST\": \"POISSON.DIST\",\n    \"_xlfn.QUARTILE.EXC\": \"QUARTILE.EXC\",\n    \"_xlfn.QUARTILE.INC\": \"QUARTILE.INC\",\n    \"_xlfn.QUERYSTRING\": \"QUERYSTRING\",\n    \"_xlfn.RANK.AVG\": \"RANK.AVG\",\n    \"_xlfn.RANK.EQ\": \"RANK.EQ\",\n    \"_xlfn.RRI\": \"RRI\",\n    \"_xlfn.SEC\": \"SEC\",\n    \"_xlfn.SECH\": \"SECH\",\n    \"_xlfn.SHEET\": \"SHEET\",\n    \"_xlfn.SHEETS\": \"SHEETS\",\n    \"_xlfn.SKEW.P\": \"SKEW.P\",\n    \"_xlfn.STDEV.P\": \"STDEV.P\",\n    \"_xlfn.STDEV.S\": \"STDEV.S\",\n    \"_xlfn.SUMIFS\": \"SUMIFS\",\n    \"_xlfn.T.DIST\": \"T.DIST\",\n    \"_xlfn.T.DIST.2T\": \"T.DIST.2T\",\n    \"_xlfn.T.DIST.RT\": \"T.DIST.RT\",\n    \"_xlfn.T.INV\": \"T.INV\",\n    \"_xlfn.T.INV.2T\": \"T.INV.2T\",\n    \"_xlfn.T.TEST\": \"T.TEST\",\n    \"_xlfn.UNICHAR\": \"UNICHAR\",\n    \"_xlfn.UNICODE\": \"UNICODE\",\n    \"_xlfn.VAR.P\": \"VAR.P\",\n    \"_xlfn.VAR.S\": \"VAR.S\",\n    \"_xlfn.WEBSERVICE\": \"WEBSERVICE\",\n    \"_xlfn.WEIBULL.DIST\": \"WEIBULL.DIST\",\n    \"_xlfn.WORKDAY.INTL\": \"WORKDAY.INTL\",\n    \"_xlfn.XOR\": \"XOR\",\n    \"_xlfn.Z.TEST\": \"Z.TEST\"\n};\n\nvar strs = {}; // shared strings\nvar _ssfopts = {}; // spreadsheet formatting options\n\nRELS.WS = \"http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet\";\n\nfunction get_sst_id(sst, str) {\n    for(var i = 0, len = sst.length; i < len; ++i) if(sst[i].t === str) { sst.Count ++; return i; }\n    sst[len] = {t:str}; sst.Count ++; sst.Unique ++; return len;\n}\n\nfunction get_cell_style(styles, cell, opts) {\n    var z = opts.revssf[cell.z != null ? cell.z : \"General\"];\n    for(var i = 0, len = styles.length; i != len; ++i) if(styles[i].numFmtId === z) return i;\n    styles[len] = {\n        numFmtId:z,\n        fontId:0,\n        fillId:0,\n        borderId:0,\n        xfId:0,\n        applyNumberFormat:1\n    };\n    return len;\n}\n\nfunction safe_format(p, fmtid, fillid, opts) {\n    try {\n        if(p.t === 'e') p.w = p.w || BErr[p.v];\n        else if(fmtid === 0) {\n            if(p.t === 'n') {\n                if((p.v|0) === p.v) p.w = SSF._general_int(p.v,_ssfopts);\n                else p.w = SSF._general_num(p.v,_ssfopts);\n            }\n            else if(p.t === 'd') {\n                var dd = datenum(p.v);\n                if((dd|0) === dd) p.w = SSF._general_int(dd,_ssfopts);\n                else p.w = SSF._general_num(dd,_ssfopts);\n            }\n            else if(p.v === undefined) return \"\";\n            else p.w = SSF._general(p.v,_ssfopts);\n        }\n        else if(p.t === 'd') p.w = SSF.format(fmtid,datenum(p.v),_ssfopts);\n        else p.w = SSF.format(fmtid,p.v,_ssfopts);\n        if(opts.cellNF) p.z = SSF._table[fmtid];\n    } catch(e) { if(opts.WTF) throw e; }\n    if(fillid) try {\n        p.s = styles.Fills[fillid];\n        if (p.s.fgColor && p.s.fgColor.theme) {\n            p.s.fgColor.rgb = rgb_tint(themes.themeElements.clrScheme[p.s.fgColor.theme].rgb, p.s.fgColor.tint || 0);\n            if(opts.WTF) p.s.fgColor.raw_rgb = themes.themeElements.clrScheme[p.s.fgColor.theme].rgb;\n        }\n        if (p.s.bgColor && p.s.bgColor.theme) {\n            p.s.bgColor.rgb = rgb_tint(themes.themeElements.clrScheme[p.s.bgColor.theme].rgb, p.s.bgColor.tint || 0);\n            if(opts.WTF) p.s.bgColor.raw_rgb = themes.themeElements.clrScheme[p.s.bgColor.theme].rgb;\n        }\n    } catch(e) { if(opts.WTF) throw e; }\n}\nfunction parse_ws_xml_dim(ws, s) {\n    var d = safe_decode_range(s);\n    if(d.s.r<=d.e.r && d.s.c<=d.e.c && d.s.r>=0 && d.s.c>=0) ws[\"!ref\"] = encode_range(d);\n}\nvar mergecregex = /<mergeCell ref=\"[A-Z0-9:]+\"\\s*\\/>/g;\nvar sheetdataregex = /<(?:\\w+:)?sheetData>([^\\u2603]*)<\\/(?:\\w+:)?sheetData>/;\nvar hlinkregex = /<hyperlink[^>]*\\/>/g;\nvar dimregex = /\"(\\w*:\\w*)\"/;\nvar colregex = /<col[^>]*\\/>/g;\n/* 18.3 Worksheets */\nfunction parse_ws_xml(data, opts, rels) {\n    if(!data) return data;\n    /* 18.3.1.99 worksheet CT_Worksheet */\n    var s = {};\n\n    /* 18.3.1.35 dimension CT_SheetDimension ? */\n    var ridx = data.indexOf(\"<dimension\");\n    if(ridx > 0) {\n        var ref = data.substr(ridx,50).match(dimregex);\n        if(ref != null) parse_ws_xml_dim(s, ref[1]);\n    }\n\n    /* 18.3.1.55 mergeCells CT_MergeCells */\n    var mergecells = [];\n    if(data.indexOf(\"</mergeCells>\")!==-1) {\n        var merges = data.match(mergecregex);\n        for(ridx = 0; ridx != merges.length; ++ridx)\n            mergecells[ridx] = safe_decode_range(merges[ridx].substr(merges[ridx].indexOf(\"\\\"\")+1));\n    }\n\n    /* 18.3.1.17 cols CT_Cols */\n    var columns = [];\n    if(opts.cellStyles && data.indexOf(\"</cols>\")!==-1) {\n        /* 18.3.1.13 col CT_Col */\n        var cols = data.match(colregex);\n        parse_ws_xml_cols(columns, cols);\n    }\n\n    var refguess = {s: {r:1000000, c:1000000}, e: {r:0, c:0} };\n\n    /* 18.3.1.80 sheetData CT_SheetData ? */\n    var mtch=data.match(sheetdataregex);\n    if(mtch) parse_ws_xml_data(mtch[1], s, opts, refguess);\n\n    /* 18.3.1.48 hyperlinks CT_Hyperlinks */\n    if(data.indexOf(\"</hyperlinks>\")!==-1) parse_ws_xml_hlinks(s, data.match(hlinkregex), rels);\n\n    if(!s[\"!ref\"] && refguess.e.c >= refguess.s.c && refguess.e.r >= refguess.s.r) s[\"!ref\"] = encode_range(refguess);\n    if(opts.sheetRows > 0 && s[\"!ref\"]) {\n        var tmpref = safe_decode_range(s[\"!ref\"]);\n        if(opts.sheetRows < +tmpref.e.r) {\n            tmpref.e.r = opts.sheetRows - 1;\n            if(tmpref.e.r > refguess.e.r) tmpref.e.r = refguess.e.r;\n            if(tmpref.e.r < tmpref.s.r) tmpref.s.r = tmpref.e.r;\n            if(tmpref.e.c > refguess.e.c) tmpref.e.c = refguess.e.c;\n            if(tmpref.e.c < tmpref.s.c) tmpref.s.c = tmpref.e.c;\n            s[\"!fullref\"] = s[\"!ref\"];\n            s[\"!ref\"] = encode_range(tmpref);\n        }\n    }\n    if(mergecells.length > 0) s[\"!merges\"] = mergecells;\n    if(columns.length > 0) s[\"!cols\"] = columns;\n    return s;\n}\n\nfunction write_ws_xml_merges(merges) {\n    if(merges.length == 0) return \"\";\n    var o = '<mergeCells count=\"' + merges.length + '\">';\n    for(var i = 0; i != merges.length; ++i) o += '<mergeCell ref=\"' + encode_range(merges[i]) + '\"/>';\n    return o + '</mergeCells>';\n}\n\nfunction parse_ws_xml_hlinks(s, data, rels) {\n    for(var i = 0; i != data.length; ++i) {\n        var val = parsexmltag(data[i], true);\n        if(!val.ref) return;\n        var rel = rels ? rels['!id'][val.id] : null;\n        if(rel) {\n            val.Target = rel.Target;\n            if(val.location) val.Target += \"#\"+val.location;\n            val.Rel = rel;\n        } else {\n            val.Target = val.location;\n            rel = {Target: val.location, TargetMode: 'Internal'};\n            val.Rel = rel;\n        }\n        var rng = safe_decode_range(val.ref);\n        for(var R=rng.s.r;R<=rng.e.r;++R) for(var C=rng.s.c;C<=rng.e.c;++C) {\n            var addr = encode_cell({c:C,r:R});\n            if(!s[addr]) s[addr] = {t:\"stub\",v:undefined};\n            s[addr].l = val;\n        }\n    }\n}\n\nfunction parse_ws_xml_cols(columns, cols) {\n    var seencol = false;\n    for(var coli = 0; coli != cols.length; ++coli) {\n        var coll = parsexmltag(cols[coli], true);\n        var colm=parseInt(coll.min, 10)-1, colM=parseInt(coll.max,10)-1;\n        delete coll.min; delete coll.max;\n        if(!seencol && coll.width) { seencol = true; find_mdw(+coll.width, coll); }\n        if(coll.width) {\n            coll.wpx = width2px(+coll.width);\n            coll.wch = px2char(coll.wpx);\n            coll.MDW = MDW;\n        }\n        while(colm <= colM) columns[colm++] = coll;\n    }\n}\n\nfunction write_ws_xml_cols(ws, cols) {\n    var o = [\"<cols>\"], col, width;\n    for(var i = 0; i != cols.length; ++i) {\n        if(!(col = cols[i])) continue;\n        var p = {min:i+1,max:i+1};\n        /* wch (chars), wpx (pixels) */\n        width = -1;\n        if(col.wpx) width = px2char(col.wpx);\n        else if(col.wch) width = col.wch;\n        if(width > -1) { p.width = char2width(width); p.customWidth= 1; }\n        o[o.length] = (writextag('col', null, p));\n    }\n    o[o.length] = \"</cols>\";\n    return o.join(\"\");\n}\n\nfunction write_ws_xml_cell(cell, ref, ws, opts, idx, wb) {\n    if(cell.v === undefined) return \"\";\n    var vv = \"\";\n    var oldt = cell.t, oldv = cell.v;\n    switch(cell.t) {\n        case 'b': vv = cell.v ? \"1\" : \"0\"; break;\n        case 'n': vv = ''+cell.v; break;\n        case 'e': vv = BErr[cell.v]; break;\n        case 'd':\n            if(opts.cellDates) vv = new Date(cell.v).toISOString();\n            else {\n                cell.t = 'n';\n                vv = ''+(cell.v = datenum(cell.v));\n                if(typeof cell.z === 'undefined') cell.z = SSF._table[14];\n            }\n            break;\n        default: vv = cell.v; break;\n    }\n    var v = writetag('v', escapexml(vv)), o = {r:ref};\n    /* TODO: cell style */\n    var os = get_cell_style(opts.cellXfs, cell, opts);\n    if(os !== 0) o.s = os;\n    switch(cell.t) {\n        case 'n': break;\n        case 'd': o.t = \"d\"; break;\n        case 'b': o.t = \"b\"; break;\n        case 'e': o.t = \"e\"; break;\n        default:\n            if(opts.bookSST) {\n                v = writetag('v', ''+get_sst_id(opts.Strings, cell.v));\n                o.t = \"s\"; break;\n            }\n            o.t = \"str\"; break;\n    }\n    if(cell.t != oldt) { cell.t = oldt; cell.v = oldv; }\n    return writextag('c', v, o);\n}\n\nvar parse_ws_xml_data = (function parse_ws_xml_data_factory() {\n    var cellregex = /<(?:\\w+:)?c[ >]/, rowregex = /<\\/(?:\\w+:)?row>/;\n    var rregex = /r=[\"']([^\"']*)[\"']/, isregex = /<is>([\\S\\s]*?)<\\/is>/;\n    var match_v = matchtag(\"v\"), match_f = matchtag(\"f\");\n\nreturn function parse_ws_xml_data(sdata, s, opts, guess) {\n    var ri = 0, x = \"\", cells = [], cref = [], idx = 0, i=0, cc=0, d=\"\", p;\n    var tag, tagr = 0, tagc = 0;\n    var sstr;\n    var fmtid = 0, fillid = 0, do_format = Array.isArray(styles.CellXf), cf;\n    for(var marr = sdata.split(rowregex), mt = 0, marrlen = marr.length; mt != marrlen; ++mt) {\n        x = marr[mt].trim();\n        var xlen = x.length;\n        if(xlen === 0) continue;\n\n        /* 18.3.1.73 row CT_Row */\n        for(ri = 0; ri < xlen; ++ri) if(x.charCodeAt(ri) === 62) break; ++ri;\n        tag = parsexmltag(x.substr(0,ri), true);\n        /* SpreadSheetGear uses implicit r/c */\n        tagr = typeof tag.r !== 'undefined' ? parseInt(tag.r, 10) : tagr+1; tagc = -1;\n        if(opts.sheetRows && opts.sheetRows < tagr) continue;\n        if(guess.s.r > tagr - 1) guess.s.r = tagr - 1;\n        if(guess.e.r < tagr - 1) guess.e.r = tagr - 1;\n\n        /* 18.3.1.4 c CT_Cell */\n        cells = x.substr(ri).split(cellregex);\n        for(ri = typeof tag.r === 'undefined' ? 0 : 1; ri != cells.length; ++ri) {\n            x = cells[ri].trim();\n            if(x.length === 0) continue;\n            cref = x.match(rregex); idx = ri; i=0; cc=0;\n            x = \"<c \" + (x.substr(0,1)==\"<\"?\">\":\"\") + x;\n            if(cref !== null && cref.length === 2) {\n                idx = 0; d=cref[1];\n                for(i=0; i != d.length; ++i) {\n                    if((cc=d.charCodeAt(i)-64) < 1 || cc > 26) break;\n                    idx = 26*idx + cc;\n                }\n                --idx;\n                tagc = idx;\n            } else ++tagc;\n            for(i = 0; i != x.length; ++i) if(x.charCodeAt(i) === 62) break; ++i;\n            tag = parsexmltag(x.substr(0,i), true);\n            if(!tag.r) tag.r = utils.encode_cell({r:tagr-1, c:tagc});\n            d = x.substr(i);\n            p = {t:\"\"};\n\n            if((cref=d.match(match_v))!== null && cref[1] !== '') p.v=unescapexml(cref[1]);\n            if(opts.cellFormula && (cref=d.match(match_f))!== null) p.f=unescapexml(cref[1]);\n\n            /* SCHEMA IS ACTUALLY INCORRECT HERE.  IF A CELL HAS NO T, EMIT \"\" */\n            if(tag.t === undefined && p.v === undefined) {\n                if(!opts.sheetStubs) continue;\n                p.t = \"stub\";\n            }\n            else p.t = tag.t || \"n\";\n            if(guess.s.c > idx) guess.s.c = idx;\n            if(guess.e.c < idx) guess.e.c = idx;\n            /* 18.18.11 t ST_CellType */\n            switch(p.t) {\n                case 'n': p.v = parseFloat(p.v); break;\n                case 's':\n                    sstr = strs[parseInt(p.v, 10)];\n                    p.v = sstr.t;\n                    p.r = sstr.r;\n                    if(opts.cellHTML) p.h = sstr.h;\n                    break;\n                case 'str':\n                    p.t = \"s\";\n                    p.v = (p.v!=null) ? utf8read(p.v) : '';\n                    if(opts.cellHTML) p.h = p.v;\n                    break;\n                case 'inlineStr':\n                    cref = d.match(isregex);\n                    p.t = 's';\n                    if(cref !== null) { sstr = parse_si(cref[1]); p.v = sstr.t; } else p.v = \"\";\n                    break; // inline string\n                case 'b': p.v = parsexmlbool(p.v); break;\n                case 'd':\n                    if(!opts.cellDates) { p.v = datenum(p.v); p.t = 'n'; }\n                    break;\n                /* error string in .v, number in .v */\n                case 'e': p.w = p.v; p.v = RBErr[p.v]; break;\n            }\n            /* formatting */\n            fmtid = fillid = 0;\n            if(do_format && tag.s !== undefined) {\n                cf = styles.CellXf[tag.s];\n                if(cf != null) {\n                    if(cf.numFmtId != null) fmtid = cf.numFmtId;\n                    if(opts.cellStyles && cf.fillId != null) fillid = cf.fillId;\n                }\n            }\n            safe_format(p, fmtid, fillid, opts);\n            s[tag.r] = p;\n        }\n    }\n}; })();\n\nfunction write_ws_xml_data(ws, opts, idx, wb) {\n    var o = [], r = [], range = safe_decode_range(ws['!ref']), cell, ref, rr = \"\", cols = [], R, C;\n    for(C = range.s.c; C <= range.e.c; ++C) cols[C] = encode_col(C);\n    for(R = range.s.r; R <= range.e.r; ++R) {\n        r = [];\n        rr = encode_row(R);\n        for(C = range.s.c; C <= range.e.c; ++C) {\n            ref = cols[C] + rr;\n            if(ws[ref] === undefined) continue;\n            if((cell = write_ws_xml_cell(ws[ref], ref, ws, opts, idx, wb)) != null) r.push(cell);\n        }\n        if(r.length > 0) o[o.length] = (writextag('row', r.join(\"\"), {r:rr}));\n    }\n    return o.join(\"\");\n}\n\nvar WS_XML_ROOT = writextag('worksheet', null, {\n    'xmlns': XMLNS.main[0],\n    'xmlns:r': XMLNS.r\n});\n\nfunction write_ws_xml(idx, opts, wb) {\n    var o = [XML_HEADER, WS_XML_ROOT];\n    var s = wb.SheetNames[idx], sidx = 0, rdata = \"\";\n    var ws = wb.Sheets[s];\n    if(ws === undefined) ws = {};\n    var ref = ws['!ref']; if(ref === undefined) ref = 'A1';\n    o[o.length] = (writextag('dimension', null, {'ref': ref}));\n\n    if(ws['!cols'] !== undefined && ws['!cols'].length > 0) o[o.length] = (write_ws_xml_cols(ws, ws['!cols']));\n    o[sidx = o.length] = '<sheetData/>';\n    if(ws['!ref'] !== undefined) {\n        rdata = write_ws_xml_data(ws, opts, idx, wb);\n        if(rdata.length > 0) o[o.length] = (rdata);\n    }\n    if(o.length>sidx+1) { o[o.length] = ('</sheetData>'); o[sidx]=o[sidx].replace(\"/>\",\">\"); }\n\n    if(ws['!merges'] !== undefined && ws['!merges'].length > 0) o[o.length] = (write_ws_xml_merges(ws['!merges']));\n\n    if(o.length>2) { o[o.length] = ('</worksheet>'); o[1]=o[1].replace(\"/>\",\">\"); }\n    return o.join(\"\");\n}\n\n/* [MS-XLSB] 2.4.718 BrtRowHdr */\nfunction parse_BrtRowHdr(data, length) {\n    var z = [];\n    z.r = data.read_shift(4);\n    data.l += length-4;\n    return z;\n}\n\n/* [MS-XLSB] 2.4.812 BrtWsDim */\nvar parse_BrtWsDim = parse_UncheckedRfX;\nvar write_BrtWsDim = write_UncheckedRfX;\n\n/* [MS-XLSB] 2.4.815 BrtWsProp */\nfunction parse_BrtWsProp(data, length) {\n    var z = {};\n    /* TODO: pull flags */\n    data.l += 19;\n    z.name = parse_XLSBCodeName(data, length - 19);\n    return z;\n}\n\n/* [MS-XLSB] 2.4.303 BrtCellBlank */\nfunction parse_BrtCellBlank(data, length) {\n    var cell = parse_XLSBCell(data);\n    return [cell];\n}\nfunction write_BrtCellBlank(cell, val, o) {\n    if(o == null) o = new_buf(8);\n    return write_XLSBCell(val, o);\n}\n\n\n/* [MS-XLSB] 2.4.304 BrtCellBool */\nfunction parse_BrtCellBool(data, length) {\n    var cell = parse_XLSBCell(data);\n    var fBool = data.read_shift(1);\n    return [cell, fBool, 'b'];\n}\n\n/* [MS-XLSB] 2.4.305 BrtCellError */\nfunction parse_BrtCellError(data, length) {\n    var cell = parse_XLSBCell(data);\n    var fBool = data.read_shift(1);\n    return [cell, fBool, 'e'];\n}\n\n/* [MS-XLSB] 2.4.308 BrtCellIsst */\nfunction parse_BrtCellIsst(data, length) {\n    var cell = parse_XLSBCell(data);\n    var isst = data.read_shift(4);\n    return [cell, isst, 's'];\n}\n\n/* [MS-XLSB] 2.4.310 BrtCellReal */\nfunction parse_BrtCellReal(data, length) {\n    var cell = parse_XLSBCell(data);\n    var value = parse_Xnum(data);\n    return [cell, value, 'n'];\n}\n\n/* [MS-XLSB] 2.4.311 BrtCellRk */\nfunction parse_BrtCellRk(data, length) {\n    var cell = parse_XLSBCell(data);\n    var value = parse_RkNumber(data);\n    return [cell, value, 'n'];\n}\n\n/* [MS-XLSB] 2.4.314 BrtCellSt */\nfunction parse_BrtCellSt(data, length) {\n    var cell = parse_XLSBCell(data);\n    var value = parse_XLWideString(data);\n    return [cell, value, 'str'];\n}\n\n/* [MS-XLSB] 2.4.647 BrtFmlaBool */\nfunction parse_BrtFmlaBool(data, length, opts) {\n    var cell = parse_XLSBCell(data);\n    var value = data.read_shift(1);\n    var o = [cell, value, 'b'];\n    if(opts.cellFormula) {\n        var formula = parse_XLSBCellParsedFormula(data, length-9);\n        o[3] = \"\"; /* TODO */\n    }\n    else data.l += length-9;\n    return o;\n}\n\n/* [MS-XLSB] 2.4.648 BrtFmlaError */\nfunction parse_BrtFmlaError(data, length, opts) {\n    var cell = parse_XLSBCell(data);\n    var value = data.read_shift(1);\n    var o = [cell, value, 'e'];\n    if(opts.cellFormula) {\n        var formula = parse_XLSBCellParsedFormula(data, length-9);\n        o[3] = \"\"; /* TODO */\n    }\n    else data.l += length-9;\n    return o;\n}\n\n/* [MS-XLSB] 2.4.649 BrtFmlaNum */\nfunction parse_BrtFmlaNum(data, length, opts) {\n    var cell = parse_XLSBCell(data);\n    var value = parse_Xnum(data);\n    var o = [cell, value, 'n'];\n    if(opts.cellFormula) {\n        var formula = parse_XLSBCellParsedFormula(data, length - 16);\n        o[3] = \"\"; /* TODO */\n    }\n    else data.l += length-16;\n    return o;\n}\n\n/* [MS-XLSB] 2.4.650 BrtFmlaString */\nfunction parse_BrtFmlaString(data, length, opts) {\n    var start = data.l;\n    var cell = parse_XLSBCell(data);\n    var value = parse_XLWideString(data);\n    var o = [cell, value, 'str'];\n    if(opts.cellFormula) {\n        var formula = parse_XLSBCellParsedFormula(data, start + length - data.l);\n    }\n    else data.l = start + length;\n    return o;\n}\n\n/* [MS-XLSB] 2.4.676 BrtMergeCell */\nvar parse_BrtMergeCell = parse_UncheckedRfX;\n\n/* [MS-XLSB] 2.4.656 BrtHLink */\nfunction parse_BrtHLink(data, length, opts) {\n    var end = data.l + length;\n    var rfx = parse_UncheckedRfX(data, 16);\n    var relId = parse_XLNullableWideString(data);\n    var loc = parse_XLWideString(data);\n    var tooltip = parse_XLWideString(data);\n    var display = parse_XLWideString(data);\n    data.l = end;\n    return {rfx:rfx, relId:relId, loc:loc, tooltip:tooltip, display:display};\n}\n\n/* [MS-XLSB] 2.1.7.61 Worksheet */\nfunction parse_ws_bin(data, opts, rels) {\n    if(!data) return data;\n    if(!rels) rels = {'!id':{}};\n    var s = {};\n\n    var ref;\n    var refguess = {s: {r:1000000, c:1000000}, e: {r:0, c:0} };\n\n    var pass = false, end = false;\n    var row, p, cf, R, C, addr, sstr, rr;\n    var mergecells = [];\n    recordhopper(data, function ws_parse(val, R) {\n        if(end) return;\n        switch(R.n) {\n            case 'BrtWsDim': ref = val; break;\n            case 'BrtRowHdr':\n                row = val;\n                if(opts.sheetRows && opts.sheetRows <= row.r) end=true;\n                rr = encode_row(row.r);\n                break;\n\n            case 'BrtFmlaBool':\n            case 'BrtFmlaError':\n            case 'BrtFmlaNum':\n            case 'BrtFmlaString':\n            case 'BrtCellBool':\n            case 'BrtCellError':\n            case 'BrtCellIsst':\n            case 'BrtCellReal':\n            case 'BrtCellRk':\n            case 'BrtCellSt':\n                p = {t:val[2]};\n                switch(val[2]) {\n                    case 'n': p.v = val[1]; break;\n                    case 's': sstr = strs[val[1]]; p.v = sstr.t; p.r = sstr.r; break;\n                    case 'b': p.v = val[1] ? true : false; break;\n                    case 'e': p.v = val[1]; p.w = BErr[p.v]; break;\n                    case 'str': p.t = 's'; p.v = utf8read(val[1]); break;\n                }\n                if(opts.cellFormula && val.length > 3) p.f = val[3];\n                if((cf = styles.CellXf[val[0].iStyleRef])) safe_format(p,cf.ifmt,null,opts);\n                s[encode_col(C=val[0].c) + rr] = p;\n                if(refguess.s.r > row.r) refguess.s.r = row.r;\n                if(refguess.s.c > C) refguess.s.c = C;\n                if(refguess.e.r < row.r) refguess.e.r = row.r;\n                if(refguess.e.c < C) refguess.e.c = C;\n                break;\n\n            case 'BrtCellBlank': if(!opts.sheetStubs) break;\n                p = {t:'s',v:undefined};\n                s[encode_col(C=val[0].c) + rr] = p;\n                if(refguess.s.r > row.r) refguess.s.r = row.r;\n                if(refguess.s.c > C) refguess.s.c = C;\n                if(refguess.e.r < row.r) refguess.e.r = row.r;\n                if(refguess.e.c < C) refguess.e.c = C;\n                break;\n\n            /* Merge Cells */\n            case 'BrtBeginMergeCells': break;\n            case 'BrtEndMergeCells': break;\n            case 'BrtMergeCell': mergecells.push(val); break;\n\n            case 'BrtHLink':\n                var rel = rels['!id'][val.relId];\n                if(rel) {\n                    val.Target = rel.Target;\n                    if(val.loc) val.Target += \"#\"+val.loc;\n                    val.Rel = rel;\n                }\n                for(R=val.rfx.s.r;R<=val.rfx.e.r;++R) for(C=val.rfx.s.c;C<=val.rfx.e.c;++C) {\n                    addr = encode_cell({c:C,r:R});\n                    if(!s[addr]) s[addr] = {t:'s',v:undefined};\n                    s[addr].l = val;\n                }\n                break;\n\n            case 'BrtArrFmla': break; // TODO\n            case 'BrtShrFmla': break; // TODO\n            case 'BrtBeginSheet': break;\n            case 'BrtWsProp': break; // TODO\n            case 'BrtSheetCalcProp': break; // TODO\n            case 'BrtBeginWsViews': break; // TODO\n            case 'BrtBeginWsView': break; // TODO\n            case 'BrtPane': break; // TODO\n            case 'BrtSel': break; // TODO\n            case 'BrtEndWsView': break; // TODO\n            case 'BrtEndWsViews': break; // TODO\n            case 'BrtACBegin': break; // TODO\n            case 'BrtRwDescent': break; // TODO\n            case 'BrtACEnd': break; // TODO\n            case 'BrtWsFmtInfoEx14': break; // TODO\n            case 'BrtWsFmtInfo': break; // TODO\n            case 'BrtBeginColInfos': break; // TODO\n            case 'BrtColInfo': break; // TODO\n            case 'BrtEndColInfos': break; // TODO\n            case 'BrtBeginSheetData': break; // TODO\n            case 'BrtEndSheetData': break; // TODO\n            case 'BrtSheetProtection': break; // TODO\n            case 'BrtPrintOptions': break; // TODO\n            case 'BrtMargins': break; // TODO\n            case 'BrtPageSetup': break; // TODO\n            case 'BrtFRTBegin': pass = true; break;\n            case 'BrtFRTEnd': pass = false; break;\n            case 'BrtEndSheet': break; // TODO\n            case 'BrtDrawing': break; // TODO\n            case 'BrtLegacyDrawing': break; // TODO\n            case 'BrtLegacyDrawingHF': break; // TODO\n            case 'BrtPhoneticInfo': break; // TODO\n            case 'BrtBeginHeaderFooter': break; // TODO\n            case 'BrtEndHeaderFooter': break; // TODO\n            case 'BrtBrk': break; // TODO\n            case 'BrtBeginRwBrk': break; // TODO\n            case 'BrtEndRwBrk': break; // TODO\n            case 'BrtBeginColBrk': break; // TODO\n            case 'BrtEndColBrk': break; // TODO\n            case 'BrtBeginUserShViews': break; // TODO\n            case 'BrtBeginUserShView': break; // TODO\n            case 'BrtEndUserShView': break; // TODO\n            case 'BrtEndUserShViews': break; // TODO\n            case 'BrtBkHim': break; // TODO\n            case 'BrtBeginOleObjects': break; // TODO\n            case 'BrtOleObject': break; // TODO\n            case 'BrtEndOleObjects': break; // TODO\n            case 'BrtBeginListParts': break; // TODO\n            case 'BrtListPart': break; // TODO\n            case 'BrtEndListParts': break; // TODO\n            case 'BrtBeginSortState': break; // TODO\n            case 'BrtBeginSortCond': break; // TODO\n            case 'BrtEndSortCond': break; // TODO\n            case 'BrtEndSortState': break; // TODO\n            case 'BrtBeginConditionalFormatting': break; // TODO\n            case 'BrtEndConditionalFormatting': break; // TODO\n            case 'BrtBeginCFRule': break; // TODO\n            case 'BrtEndCFRule': break; // TODO\n            case 'BrtBeginDVals': break; // TODO\n            case 'BrtDVal': break; // TODO\n            case 'BrtEndDVals': break; // TODO\n            case 'BrtRangeProtection': break; // TODO\n            case 'BrtBeginDCon': break; // TODO\n            case 'BrtEndDCon': break; // TODO\n            case 'BrtBeginDRefs': break;\n            case 'BrtDRef': break;\n            case 'BrtEndDRefs': break;\n\n            /* ActiveX */\n            case 'BrtBeginActiveXControls': break;\n            case 'BrtActiveX': break;\n            case 'BrtEndActiveXControls': break;\n\n            /* AutoFilter */\n            case 'BrtBeginAFilter': break;\n            case 'BrtEndAFilter': break;\n            case 'BrtBeginFilterColumn': break;\n            case 'BrtBeginFilters': break;\n            case 'BrtFilter': break;\n            case 'BrtEndFilters': break;\n            case 'BrtEndFilterColumn': break;\n            case 'BrtDynamicFilter': break;\n            case 'BrtTop10Filter': break;\n            case 'BrtBeginCustomFilters': break;\n            case 'BrtCustomFilter': break;\n            case 'BrtEndCustomFilters': break;\n\n            /* Smart Tags */\n            case 'BrtBeginSmartTags': break;\n            case 'BrtBeginCellSmartTags': break;\n            case 'BrtBeginCellSmartTag': break;\n            case 'BrtCellSmartTagProperty': break;\n            case 'BrtEndCellSmartTag': break;\n            case 'BrtEndCellSmartTags': break;\n            case 'BrtEndSmartTags': break;\n\n            /* Cell Watch */\n            case 'BrtBeginCellWatches': break;\n            case 'BrtCellWatch': break;\n            case 'BrtEndCellWatches': break;\n\n            /* Table */\n            case 'BrtTable': break;\n\n            /* Ignore Cell Errors */\n            case 'BrtBeginCellIgnoreECs': break;\n            case 'BrtCellIgnoreEC': break;\n            case 'BrtEndCellIgnoreECs': break;\n\n            default: if(!pass || opts.WTF) throw new Error(\"Unexpected record \" + R.n);\n        }\n    }, opts);\n    if(!s[\"!ref\"] && (refguess.s.r < 1000000 || ref.e.r > 0 || ref.e.c > 0 || ref.s.r > 0 || ref.s.c > 0)) s[\"!ref\"] = encode_range(ref);\n    if(opts.sheetRows && s[\"!ref\"]) {\n        var tmpref = safe_decode_range(s[\"!ref\"]);\n        if(opts.sheetRows < +tmpref.e.r) {\n            tmpref.e.r = opts.sheetRows - 1;\n            if(tmpref.e.r > refguess.e.r) tmpref.e.r = refguess.e.r;\n            if(tmpref.e.r < tmpref.s.r) tmpref.s.r = tmpref.e.r;\n            if(tmpref.e.c > refguess.e.c) tmpref.e.c = refguess.e.c;\n            if(tmpref.e.c < tmpref.s.c) tmpref.s.c = tmpref.e.c;\n            s[\"!fullref\"] = s[\"!ref\"];\n            s[\"!ref\"] = encode_range(tmpref);\n        }\n    }\n    if(mergecells.length > 0) s[\"!merges\"] = mergecells;\n    return s;\n}\n\n/* TODO: something useful -- this is a stub */\nfunction write_ws_bin_cell(ba, cell, R, C, opts) {\n    if(cell.v === undefined) return \"\";\n    var vv = \"\";\n    switch(cell.t) {\n        case 'b': vv = cell.v ? \"1\" : \"0\"; break;\n        case 'n': case 'e': vv = ''+cell.v; break;\n        default: vv = cell.v; break;\n    }\n    var o = {r:R, c:C};\n    /* TODO: cell style */\n    o.s = get_cell_style(opts.cellXfs, cell, opts);\n    switch(cell.t) {\n        case 's': case 'str':\n            if(opts.bookSST) {\n                vv = get_sst_id(opts.Strings, cell.v);\n                o.t = \"s\"; break;\n            }\n            o.t = \"str\"; break;\n        case 'n': break;\n        case 'b': o.t = \"b\"; break;\n        case 'e': o.t = \"e\"; break;\n    }\n    write_record(ba, \"BrtCellBlank\", write_BrtCellBlank(cell, o));\n}\n\nfunction write_CELLTABLE(ba, ws, idx, opts, wb) {\n    var range = safe_decode_range(ws['!ref'] || \"A1\"), ref, rr = \"\", cols = [];\n    write_record(ba, 'BrtBeginSheetData');\n    for(var R = range.s.r; R <= range.e.r; ++R) {\n        rr = encode_row(R);\n        /* [ACCELLTABLE] */\n        /* BrtRowHdr */\n        for(var C = range.s.c; C <= range.e.c; ++C) {\n            /* *16384CELL */\n            if(R === range.s.r) cols[C] = encode_col(C);\n            ref = cols[C] + rr;\n            if(!ws[ref]) continue;\n            /* write cell */\n            write_ws_bin_cell(ba, ws[ref], R, C, opts);\n        }\n    }\n    write_record(ba, 'BrtEndSheetData');\n}\n\nfunction write_ws_bin(idx, opts, wb) {\n    var ba = buf_array();\n    var s = wb.SheetNames[idx], ws = wb.Sheets[s] || {};\n    var r = safe_decode_range(ws['!ref'] || \"A1\");\n    write_record(ba, \"BrtBeginSheet\");\n    /* [BrtWsProp] */\n    write_record(ba, \"BrtWsDim\", write_BrtWsDim(r));\n    /* [WSVIEWS2] */\n    /* [WSFMTINFO] */\n    /* *COLINFOS */\n    write_CELLTABLE(ba, ws, idx, opts, wb);\n    /* [BrtSheetCalcProp] */\n    /* [[BrtSheetProtectionIso] BrtSheetProtection] */\n    /* *([BrtRangeProtectionIso] BrtRangeProtection) */\n    /* [SCENMAN] */\n    /* [AUTOFILTER] */\n    /* [SORTSTATE] */\n    /* [DCON] */\n    /* [USERSHVIEWS] */\n    /* [MERGECELLS] */\n    /* [BrtPhoneticInfo] */\n    /* *CONDITIONALFORMATTING */\n    /* [DVALS] */\n    /* *BrtHLink */\n    /* [BrtPrintOptions] */\n    /* [BrtMargins] */\n    /* [BrtPageSetup] */\n    /* [HEADERFOOTER] */\n    /* [RWBRK] */\n    /* [COLBRK] */\n    /* *BrtBigName */\n    /* [CELLWATCHES] */\n    /* [IGNOREECS] */\n    /* [SMARTTAGS] */\n    /* [BrtDrawing] */\n    /* [BrtLegacyDrawing] */\n    /* [BrtLegacyDrawingHF] */\n    /* [BrtBkHim] */\n    /* [OLEOBJECTS] */\n    /* [ACTIVEXCONTROLS] */\n    /* [WEBPUBITEMS] */\n    /* [LISTPARTS] */\n    /* FRTWORKSHEET */\n    write_record(ba, \"BrtEndSheet\");\n    return ba.end();\n}\n/* 18.2.28 (CT_WorkbookProtection) Defaults */\nvar WBPropsDef = [\n    ['allowRefreshQuery', '0'],\n    ['autoCompressPictures', '1'],\n    ['backupFile', '0'],\n    ['checkCompatibility', '0'],\n    ['codeName', ''],\n    ['date1904', '0'],\n    ['dateCompatibility', '1'],\n    //['defaultThemeVersion', '0'],\n    ['filterPrivacy', '0'],\n    ['hidePivotFieldList', '0'],\n    ['promptedSolutions', '0'],\n    ['publishItems', '0'],\n    ['refreshAllConnections', false],\n    ['saveExternalLinkValues', '1'],\n    ['showBorderUnselectedTables', '1'],\n    ['showInkAnnotation', '1'],\n    ['showObjects', 'all'],\n    ['showPivotChartFilter', '0']\n    //['updateLinks', 'userSet']\n];\n\n/* 18.2.30 (CT_BookView) Defaults */\nvar WBViewDef = [\n    ['activeTab', '0'],\n    ['autoFilterDateGrouping', '1'],\n    ['firstSheet', '0'],\n    ['minimized', '0'],\n    ['showHorizontalScroll', '1'],\n    ['showSheetTabs', '1'],\n    ['showVerticalScroll', '1'],\n    ['tabRatio', '600'],\n    ['visibility', 'visible']\n    //window{Height,Width}, {x,y}Window\n];\n\n/* 18.2.19 (CT_Sheet) Defaults */\nvar SheetDef = [\n    ['state', 'visible']\n];\n\n/* 18.2.2  (CT_CalcPr) Defaults */\nvar CalcPrDef = [\n    ['calcCompleted', 'true'],\n    ['calcMode', 'auto'],\n    ['calcOnSave', 'true'],\n    ['concurrentCalc', 'true'],\n    ['fullCalcOnLoad', 'false'],\n    ['fullPrecision', 'true'],\n    ['iterate', 'false'],\n    ['iterateCount', '100'],\n    ['iterateDelta', '0.001'],\n    ['refMode', 'A1']\n];\n\n/* 18.2.3 (CT_CustomWorkbookView) Defaults */\nvar CustomWBViewDef = [\n    ['autoUpdate', 'false'],\n    ['changesSavedWin', 'false'],\n    ['includeHiddenRowCol', 'true'],\n    ['includePrintSettings', 'true'],\n    ['maximized', 'false'],\n    ['minimized', 'false'],\n    ['onlySync', 'false'],\n    ['personalView', 'false'],\n    ['showComments', 'commIndicator'],\n    ['showFormulaBar', 'true'],\n    ['showHorizontalScroll', 'true'],\n    ['showObjects', 'all'],\n    ['showSheetTabs', 'true'],\n    ['showStatusbar', 'true'],\n    ['showVerticalScroll', 'true'],\n    ['tabRatio', '600'],\n    ['xWindow', '0'],\n    ['yWindow', '0']\n];\n\nfunction push_defaults_array(target, defaults) {\n    for(var j = 0; j != target.length; ++j) { var w = target[j];\n        for(var i=0; i != defaults.length; ++i) { var z = defaults[i];\n            if(w[z[0]] == null) w[z[0]] = z[1];\n        }\n    }\n}\nfunction push_defaults(target, defaults) {\n    for(var i = 0; i != defaults.length; ++i) { var z = defaults[i];\n        if(target[z[0]] == null) target[z[0]] = z[1];\n    }\n}\n\nfunction parse_wb_defaults(wb) {\n    push_defaults(wb.WBProps, WBPropsDef);\n    push_defaults(wb.CalcPr, CalcPrDef);\n\n    push_defaults_array(wb.WBView, WBViewDef);\n    push_defaults_array(wb.Sheets, SheetDef);\n\n    _ssfopts.date1904 = parsexmlbool(wb.WBProps.date1904, 'date1904');\n}\n/* 18.2 Workbook */\nvar wbnsregex = /<\\w+:workbook/;\nfunction parse_wb_xml(data, opts) {\n    var wb = { AppVersion:{}, WBProps:{}, WBView:[], Sheets:[], CalcPr:{}, xmlns: \"\" };\n    var pass = false, xmlns = \"xmlns\";\n    data.match(tagregex).forEach(function xml_wb(x) {\n        var y = parsexmltag(x);\n        switch(strip_ns(y[0])) {\n            case '<?xml': break;\n\n            /* 18.2.27 workbook CT_Workbook 1 */\n            case '<workbook':\n                if(x.match(wbnsregex)) xmlns = \"xmlns\" + x.match(/<(\\w+):/)[1];\n                wb.xmlns = y[xmlns];\n                break;\n            case '</workbook>': break;\n\n            /* 18.2.13 fileVersion CT_FileVersion ? */\n            case '<fileVersion': delete y[0]; wb.AppVersion = y; break;\n            case '<fileVersion/>': break;\n\n            /* 18.2.12 fileSharing CT_FileSharing ? */\n            case '<fileSharing': case '<fileSharing/>': break;\n\n            /* 18.2.28 workbookPr CT_WorkbookPr ? */\n            case '<workbookPr': delete y[0]; wb.WBProps = y; break;\n            case '<workbookPr/>': delete y[0]; wb.WBProps = y; break;\n\n            /* 18.2.29 workbookProtection CT_WorkbookProtection ? */\n            case '<workbookProtection': break;\n            case '<workbookProtection/>': break;\n\n            /* 18.2.1  bookViews CT_BookViews ? */\n            case '<bookViews>': case '</bookViews>': break;\n            /* 18.2.30   workbookView CT_BookView + */\n            case '<workbookView': delete y[0]; wb.WBView.push(y); break;\n\n            /* 18.2.20 sheets CT_Sheets 1 */\n            case '<sheets>': case '</sheets>': break; // aggregate sheet\n            /* 18.2.19   sheet CT_Sheet + */\n            case '<sheet': delete y[0]; y.name = utf8read(y.name); wb.Sheets.push(y); break;\n\n            /* 18.2.15 functionGroups CT_FunctionGroups ? */\n            case '<functionGroups': case '<functionGroups/>': break;\n            /* 18.2.14   functionGroup CT_FunctionGroup + */\n            case '<functionGroup': break;\n\n            /* 18.2.9  externalReferences CT_ExternalReferences ? */\n            case '<externalReferences': case '</externalReferences>': case '<externalReferences>': break;\n            /* 18.2.8    externalReference CT_ExternalReference + */\n            case '<externalReference': break;\n\n            /* 18.2.6  definedNames CT_DefinedNames ? */\n            case '<definedNames/>': break;\n            case '<definedNames>': case '<definedNames': pass=true; break;\n            case '</definedNames>': pass=false; break;\n            /* 18.2.5    definedName CT_DefinedName + */\n            case '<definedName': case '<definedName/>': case '</definedName>': break;\n\n            /* 18.2.2  calcPr CT_CalcPr ? */\n            case '<calcPr': delete y[0]; wb.CalcPr = y; break;\n            case '<calcPr/>': delete y[0]; wb.CalcPr = y; break;\n\n            /* 18.2.16 oleSize CT_OleSize ? (ref required) */\n            case '<oleSize': break;\n\n            /* 18.2.4  customWorkbookViews CT_CustomWorkbookViews ? */\n            case '<customWorkbookViews>': case '</customWorkbookViews>': case '<customWorkbookViews': break;\n            /* 18.2.3    customWorkbookView CT_CustomWorkbookView + */\n            case '<customWorkbookView': case '</customWorkbookView>': break;\n\n            /* 18.2.18 pivotCaches CT_PivotCaches ? */\n            case '<pivotCaches>': case '</pivotCaches>': case '<pivotCaches': break;\n            /* 18.2.17 pivotCache CT_PivotCache ? */\n            case '<pivotCache': break;\n\n            /* 18.2.21 smartTagPr CT_SmartTagPr ? */\n            case '<smartTagPr': case '<smartTagPr/>': break;\n\n            /* 18.2.23 smartTagTypes CT_SmartTagTypes ? */\n            case '<smartTagTypes': case '<smartTagTypes>': case '</smartTagTypes>': break;\n            /* 18.2.22   smartTagType CT_SmartTagType ? */\n            case '<smartTagType': break;\n\n            /* 18.2.24 webPublishing CT_WebPublishing ? */\n            case '<webPublishing': case '<webPublishing/>': break;\n\n            /* 18.2.11 fileRecoveryPr CT_FileRecoveryPr ? */\n            case '<fileRecoveryPr': case '<fileRecoveryPr/>': break;\n\n            /* 18.2.26 webPublishObjects CT_WebPublishObjects ? */\n            case '<webPublishObjects>': case '<webPublishObjects': case '</webPublishObjects>': break;\n            /* 18.2.25 webPublishObject CT_WebPublishObject ? */\n            case '<webPublishObject': break;\n\n            /* 18.2.10 extLst CT_ExtensionList ? */\n            case '<extLst>': case '</extLst>': case '<extLst/>': break;\n            /* 18.2.7    ext CT_Extension + */\n            case '<ext': pass=true; break; //TODO: check with versions of excel\n            case '</ext>': pass=false; break;\n\n            /* Others */\n            case '<ArchID': break;\n            case '<AlternateContent': pass=true; break;\n            case '</AlternateContent>': pass=false; break;\n\n            default: if(!pass && opts.WTF) throw 'unrecognized ' + y[0] + ' in workbook';\n        }\n    });\n    if(XMLNS.main.indexOf(wb.xmlns) === -1) throw new Error(\"Unknown Namespace: \" + wb.xmlns);\n\n    parse_wb_defaults(wb);\n\n    return wb;\n}\n\nvar WB_XML_ROOT = writextag('workbook', null, {\n    'xmlns': XMLNS.main[0],\n    //'xmlns:mx': XMLNS.mx,\n    //'xmlns:s': XMLNS.main[0],\n    'xmlns:r': XMLNS.r\n});\n\nfunction safe1904(wb) {\n    /* TODO: store date1904 somewhere else */\n    try { return parsexmlbool(wb.Workbook.WBProps.date1904) ? \"true\" : \"false\"; } catch(e) { return \"false\"; }\n}\n\nfunction write_wb_xml(wb, opts) {\n    var o = [XML_HEADER];\n    o[o.length] = WB_XML_ROOT;\n    o[o.length] = (writextag('workbookPr', null, {date1904:safe1904(wb)}));\n    o[o.length] = \"<sheets>\";\n    for(var i = 0; i != wb.SheetNames.length; ++i)\n        o[o.length] = (writextag('sheet',null,{name:wb.SheetNames[i].substr(0,31), sheetId:\"\"+(i+1), \"r:id\":\"rId\"+(i+1)}));\n    o[o.length] = \"</sheets>\";\n    if(o.length>2){ o[o.length] = '</workbook>'; o[1]=o[1].replace(\"/>\",\">\"); }\n    return o.join(\"\");\n}\n/* [MS-XLSB] 2.4.301 BrtBundleSh */\nfunction parse_BrtBundleSh(data, length) {\n    var z = {};\n    z.hsState = data.read_shift(4); //ST_SheetState\n    z.iTabID = data.read_shift(4);\n    z.strRelID = parse_RelID(data,length-8);\n    z.name = parse_XLWideString(data);\n    return z;\n}\nfunction write_BrtBundleSh(data, o) {\n    if(!o) o = new_buf(127);\n    o.write_shift(4, data.hsState);\n    o.write_shift(4, data.iTabID);\n    write_RelID(data.strRelID, o);\n    write_XLWideString(data.name.substr(0,31), o);\n    return o;\n}\n\n/* [MS-XLSB] 2.4.807 BrtWbProp */\nfunction parse_BrtWbProp(data, length) {\n    data.read_shift(4);\n    var dwThemeVersion = data.read_shift(4);\n    var strName = (length > 8) ? parse_XLWideString(data) : \"\";\n    return [dwThemeVersion, strName];\n}\nfunction write_BrtWbProp(data, o) {\n    if(!o) o = new_buf(8);\n    o.write_shift(4, 0);\n    o.write_shift(4, 0);\n    return o;\n}\n\nfunction parse_BrtFRTArchID$(data, length) {\n    var o = {};\n    data.read_shift(4);\n    o.ArchID = data.read_shift(4);\n    data.l += length - 8;\n    return o;\n}\n\n/* [MS-XLSB] 2.1.7.60 Workbook */\nfunction parse_wb_bin(data, opts) {\n    var wb = { AppVersion:{}, WBProps:{}, WBView:[], Sheets:[], CalcPr:{}, xmlns: \"\" };\n    var pass = false, z;\n\n    recordhopper(data, function hopper_wb(val, R) {\n        switch(R.n) {\n            case 'BrtBundleSh': wb.Sheets.push(val); break;\n\n            case 'BrtBeginBook': break;\n            case 'BrtFileVersion': break;\n            case 'BrtWbProp': break;\n            case 'BrtACBegin': break;\n            case 'BrtAbsPath15': break;\n            case 'BrtACEnd': break;\n            case 'BrtWbFactoid': break;\n            /*case 'BrtBookProtectionIso': break;*/\n            case 'BrtBookProtection': break;\n            case 'BrtBeginBookViews': break;\n            case 'BrtBookView': break;\n            case 'BrtEndBookViews': break;\n            case 'BrtBeginBundleShs': break;\n            case 'BrtEndBundleShs': break;\n            case 'BrtBeginFnGroup': break;\n            case 'BrtEndFnGroup': break;\n            case 'BrtBeginExternals': break;\n            case 'BrtSupSelf': break;\n            case 'BrtSupBookSrc': break;\n            case 'BrtExternSheet': break;\n            case 'BrtEndExternals': break;\n            case 'BrtName': break;\n            case 'BrtCalcProp': break;\n            case 'BrtUserBookView': break;\n            case 'BrtBeginPivotCacheIDs': break;\n            case 'BrtBeginPivotCacheID': break;\n            case 'BrtEndPivotCacheID': break;\n            case 'BrtEndPivotCacheIDs': break;\n            case 'BrtWebOpt': break;\n            case 'BrtFileRecover': break;\n            case 'BrtFileSharing': break;\n            /*case 'BrtBeginWebPubItems': break;\n            case 'BrtBeginWebPubItem': break;\n            case 'BrtEndWebPubItem': break;\n            case 'BrtEndWebPubItems': break;*/\n\n            /* Smart Tags */\n            case 'BrtBeginSmartTagTypes': break;\n            case 'BrtSmartTagType': break;\n            case 'BrtEndSmartTagTypes': break;\n\n            case 'BrtFRTBegin': pass = true; break;\n            case 'BrtFRTArchID$': break;\n            case 'BrtWorkBookPr15': break;\n            case 'BrtFRTEnd': pass = false; break;\n            case 'BrtEndBook': break;\n            default: if(!pass || opts.WTF) throw new Error(\"Unexpected record \" + R.n);\n        }\n    });\n\n    parse_wb_defaults(wb);\n\n    return wb;\n}\n\n/* [MS-XLSB] 2.1.7.60 Workbook */\nfunction write_BUNDLESHS(ba, wb, opts) {\n    write_record(ba, \"BrtBeginBundleShs\");\n    for(var idx = 0; idx != wb.SheetNames.length; ++idx) {\n        var d = { hsState: 0, iTabID: idx+1, strRelID: 'rId' + (idx+1), name: wb.SheetNames[idx] };\n        write_record(ba, \"BrtBundleSh\", write_BrtBundleSh(d));\n    }\n    write_record(ba, \"BrtEndBundleShs\");\n}\n\n/* [MS-XLSB] 2.4.643 BrtFileVersion */\nfunction write_BrtFileVersion(data, o) {\n    if(!o) o = new_buf(127);\n    for(var i = 0; i != 4; ++i) o.write_shift(4, 0);\n    write_XLWideString(\"SheetJS\", o);\n    write_XLWideString(XLSX.version, o);\n    write_XLWideString(XLSX.version, o);\n    write_XLWideString(\"7262\", o);\n    o.length = o.l;\n    return o;\n}\n\n/* [MS-XLSB] 2.1.7.60 Workbook */\nfunction write_BOOKVIEWS(ba, wb, opts) {\n    write_record(ba, \"BrtBeginBookViews\");\n    /* 1*(BrtBookView *FRT) */\n    write_record(ba, \"BrtEndBookViews\");\n}\n\n/* [MS-XLSB] 2.4.302 BrtCalcProp */\nfunction write_BrtCalcProp(data, o) {\n    if(!o) o = new_buf(26);\n    o.write_shift(4,0); /* force recalc */\n    o.write_shift(4,1);\n    o.write_shift(4,0);\n    write_Xnum(0, o);\n    o.write_shift(-4, 1023);\n    o.write_shift(1, 0x33);\n    o.write_shift(1, 0x00);\n    return o;\n}\n\nfunction write_BrtFileRecover(data, o) {\n    if(!o) o = new_buf(1);\n    o.write_shift(1,0);\n    return o;\n}\n\n/* [MS-XLSB] 2.1.7.60 Workbook */\nfunction write_wb_bin(wb, opts) {\n    var ba = buf_array();\n    write_record(ba, \"BrtBeginBook\");\n    write_record(ba, \"BrtFileVersion\", write_BrtFileVersion());\n    /* [[BrtFileSharingIso] BrtFileSharing] */\n    write_record(ba, \"BrtWbProp\", write_BrtWbProp());\n    /* [ACABSPATH] */\n    /* [[BrtBookProtectionIso] BrtBookProtection] */\n    write_BOOKVIEWS(ba, wb, opts);\n    write_BUNDLESHS(ba, wb, opts);\n    /* [FNGROUP] */\n    /* [EXTERNALS] */\n    /* *BrtName */\n    write_record(ba, \"BrtCalcProp\", write_BrtCalcProp());\n    /* [BrtOleSize] */\n    /* *(BrtUserBookView *FRT) */\n    /* [PIVOTCACHEIDS] */\n    /* [BrtWbFactoid] */\n    /* [SMARTTAGTYPES] */\n    /* [BrtWebOpt] */\n    write_record(ba, \"BrtFileRecover\", write_BrtFileRecover());\n    /* [WEBPUBITEMS] */\n    /* [CRERRS] */\n    /* FRTWORKBOOK */\n    write_record(ba, \"BrtEndBook\");\n\n    return ba.end();\n}\nfunction parse_wb(data, name, opts) {\n    return (name.substr(-4)===\".bin\" ? parse_wb_bin : parse_wb_xml)(data, opts);\n}\n\nfunction parse_ws(data, name, opts, rels) {\n    return (name.substr(-4)===\".bin\" ? parse_ws_bin : parse_ws_xml)(data, opts, rels);\n}\n\nfunction parse_sty(data, name, opts) {\n    return (name.substr(-4)===\".bin\" ? parse_sty_bin : parse_sty_xml)(data, opts);\n}\n\nfunction parse_theme(data, name, opts) {\n    return parse_theme_xml(data, opts);\n}\n\nfunction parse_sst(data, name, opts) {\n    return (name.substr(-4)===\".bin\" ? parse_sst_bin : parse_sst_xml)(data, opts);\n}\n\nfunction parse_cmnt(data, name, opts) {\n    return (name.substr(-4)===\".bin\" ? parse_comments_bin : parse_comments_xml)(data, opts);\n}\n\nfunction parse_cc(data, name, opts) {\n    return (name.substr(-4)===\".bin\" ? parse_cc_bin : parse_cc_xml)(data, opts);\n}\n\nfunction write_wb(wb, name, opts) {\n    return (name.substr(-4)===\".bin\" ? write_wb_bin : write_wb_xml)(wb, opts);\n}\n\nfunction write_ws(data, name, opts, wb) {\n    return (name.substr(-4)===\".bin\" ? write_ws_bin : write_ws_xml)(data, opts, wb);\n}\n\nfunction write_sty(data, name, opts) {\n    return (name.substr(-4)===\".bin\" ? write_sty_bin : write_sty_xml)(data, opts);\n}\n\nfunction write_sst(data, name, opts) {\n    return (name.substr(-4)===\".bin\" ? write_sst_bin : write_sst_xml)(data, opts);\n}\n/*\nfunction write_cmnt(data, name, opts) {\n    return (name.substr(-4)===\".bin\" ? write_comments_bin : write_comments_xml)(data, opts);\n}\n\nfunction write_cc(data, name, opts) {\n    return (name.substr(-4)===\".bin\" ? write_cc_bin : write_cc_xml)(data, opts);\n}\n*/\nvar attregexg2=/([\\w:]+)=((?:\")([^\"]*)(?:\")|(?:')([^']*)(?:'))/g;\nvar attregex2=/([\\w:]+)=((?:\")(?:[^\"]*)(?:\")|(?:')(?:[^']*)(?:'))/;\nvar _chr = function(c) { return String.fromCharCode(c); };\nfunction xlml_parsexmltag(tag, skip_root) {\n    var words = tag.split(/\\s+/);\n    var z = []; if(!skip_root) z[0] = words[0];\n    if(words.length === 1) return z;\n    var m = tag.match(attregexg2), y, j, w, i;\n    if(m) for(i = 0; i != m.length; ++i) {\n        y = m[i].match(attregex2);\n        if((j=y[1].indexOf(\":\")) === -1) z[y[1]] = y[2].substr(1,y[2].length-2);\n        else {\n            if(y[1].substr(0,6) === \"xmlns:\") w = \"xmlns\"+y[1].substr(6);\n            else w = y[1].substr(j+1);\n            z[w] = y[2].substr(1,y[2].length-2);\n        }\n    }\n    return z;\n}\nfunction xlml_parsexmltagobj(tag) {\n    var words = tag.split(/\\s+/);\n    var z = {};\n    if(words.length === 1) return z;\n    var m = tag.match(attregexg2), y, j, w, i;\n    if(m) for(i = 0; i != m.length; ++i) {\n        y = m[i].match(attregex2);\n        if((j=y[1].indexOf(\":\")) === -1) z[y[1]] = y[2].substr(1,y[2].length-2);\n        else {\n            if(y[1].substr(0,6) === \"xmlns:\") w = \"xmlns\"+y[1].substr(6);\n            else w = y[1].substr(j+1);\n            z[w] = y[2].substr(1,y[2].length-2);\n        }\n    }\n    return z;\n}\n\n// ----\n\nfunction xlml_format(format, value) {\n    var fmt = XLMLFormatMap[format] || unescapexml(format);\n    if(fmt === \"General\") return SSF._general(value);\n    return SSF.format(fmt, value);\n}\n\nfunction xlml_set_custprop(Custprops, Rn, cp, val) {\n    switch((cp[0].match(/dt:dt=\"([\\w.]+)\"/)||[\"\",\"\"])[1]) {\n        case \"boolean\": val = parsexmlbool(val); break;\n        case \"i2\": case \"int\": val = parseInt(val, 10); break;\n        case \"r4\": case \"float\": val = parseFloat(val); break;\n        case \"date\": case \"dateTime.tz\": val = new Date(val); break;\n        case \"i8\": case \"string\": case \"fixed\": case \"uuid\": case \"bin.base64\": break;\n        default: throw \"bad custprop:\" + cp[0];\n    }\n    Custprops[unescapexml(Rn[3])] = val;\n}\n\nfunction safe_format_xlml(cell, nf, o) {\n    try {\n        if(cell.t === 'e') { cell.w = cell.w || BErr[cell.v]; }\n        else if(nf === \"General\") {\n            if(cell.t === 'n') {\n                if((cell.v|0) === cell.v) cell.w = SSF._general_int(cell.v);\n                else cell.w = SSF._general_num(cell.v);\n            }\n            else cell.w = SSF._general(cell.v);\n        }\n        else cell.w = xlml_format(nf||\"General\", cell.v);\n        if(o.cellNF) cell.z = XLMLFormatMap[nf]||nf||\"General\";\n    } catch(e) { if(o.WTF) throw e; }\n}\n\nfunction process_style_xlml(styles, stag, opts) {\n    if(opts.cellStyles) {\n        if(stag.Interior) {\n            var I = stag.Interior;\n            if(I.Pattern) I.patternType = XLMLPatternTypeMap[I.Pattern] || I.Pattern;\n        }\n    }\n    styles[stag.ID] = stag;\n}\n\n/* TODO: there must exist some form of OSP-blessed spec */\nfunction parse_xlml_data(xml, ss, data, cell, base, styles, csty, row, o) {\n    var nf = \"General\", sid = cell.StyleID, S = {}; o = o || {};\n    var interiors = [];\n    if(sid === undefined && row) sid = row.StyleID;\n    if(sid === undefined && csty) sid = csty.StyleID;\n    while(styles[sid] !== undefined) {\n        if(styles[sid].nf) nf = styles[sid].nf;\n        if(styles[sid].Interior) interiors.push(styles[sid].Interior);\n        if(!styles[sid].Parent) break;\n        sid = styles[sid].Parent;\n    }\n    switch(data.Type) {\n        case 'Boolean':\n            cell.t = 'b';\n            cell.v = parsexmlbool(xml);\n            break;\n        case 'String':\n            cell.t = 's'; cell.r = xlml_fixstr(unescapexml(xml));\n            cell.v = xml.indexOf(\"<\") > -1 ? ss : cell.r;\n            break;\n        case 'DateTime':\n            cell.v = (Date.parse(xml) - new Date(Date.UTC(1899, 11, 30))) / (24 * 60 * 60 * 1000);\n            if(cell.v !== cell.v) cell.v = unescapexml(xml);\n            else if(cell.v >= 1 && cell.v<60) cell.v = cell.v -1;\n            if(!nf || nf == \"General\") nf = \"yyyy-mm-dd\";\n            /* falls through */\n        case 'Number':\n            if(cell.v === undefined) cell.v=+xml;\n            if(!cell.t) cell.t = 'n';\n            break;\n        case 'Error': cell.t = 'e'; cell.v = RBErr[xml]; cell.w = xml; break;\n        default: cell.t = 's'; cell.v = xlml_fixstr(ss); break;\n    }\n    safe_format_xlml(cell, nf, o);\n    if(o.cellFormula != null && cell.Formula) {\n        cell.f = rc_to_a1(unescapexml(cell.Formula), base);\n        cell.Formula = undefined;\n    }\n    if(o.cellStyles) {\n        interiors.forEach(function(x) {\n            if(!S.patternType && x.patternType) S.patternType = x.patternType;\n        });\n        cell.s = S;\n    }\n    cell.ixfe = cell.StyleID !== undefined ? cell.StyleID : 'Default';\n}\n\nfunction xlml_clean_comment(comment) {\n    comment.t = comment.v;\n    comment.v = comment.w = comment.ixfe = undefined;\n}\n\nfunction xlml_normalize(d) {\n    if(has_buf && Buffer.isBuffer(d)) return d.toString('utf8');\n    if(typeof d === 'string') return d;\n    throw \"badf\";\n}\n\n/* TODO: Everything */\nvar xlmlregex = /<(\\/?)([a-z0-9]*:|)(\\w+)[^>]*>/mg;\nfunction parse_xlml_xml(d, opts) {\n    var str = xlml_normalize(d);\n    var Rn;\n    var state = [], tmp;\n    var sheets = {}, sheetnames = [], cursheet = {}, sheetname = \"\";\n    var table = {}, cell = {}, row = {}, dtag, didx;\n    var c = 0, r = 0;\n    var refguess = {s: {r:1000000, c:1000000}, e: {r:0, c:0} };\n    var styles = {}, stag = {};\n    var ss = \"\", fidx = 0;\n    var mergecells = [];\n    var Props = {}, Custprops = {}, pidx = 0, cp = {};\n    var comments = [], comment = {};\n    var cstys = [], csty;\n    xlmlregex.lastIndex = 0;\n    while((Rn = xlmlregex.exec(str))) switch(Rn[3]) {\n        case 'Data':\n            if(state[state.length-1][1]) break;\n            if(Rn[1]==='/') parse_xlml_data(str.slice(didx, Rn.index), ss, dtag, state[state.length-1][0]==\"Comment\"?comment:cell, {c:c,r:r}, styles, cstys[c], row, opts);\n            else { ss = \"\"; dtag = xlml_parsexmltag(Rn[0]); didx = Rn.index + Rn[0].length; }\n            break;\n        case 'Cell':\n            if(Rn[1]==='/'){\n                if(comments.length > 0) cell.c = comments;\n                if((!opts.sheetRows || opts.sheetRows > r) && cell.v !== undefined) cursheet[encode_col(c) + encode_row(r)] = cell;\n                if(cell.HRef) {\n                    cell.l = {Target:cell.HRef, tooltip:cell.HRefScreenTip};\n                    cell.HRef = cell.HRefScreenTip = undefined;\n                }\n                if(cell.MergeAcross || cell.MergeDown) {\n                    var cc = c + (parseInt(cell.MergeAcross,10)|0);\n                    var rr = r + (parseInt(cell.MergeDown,10)|0);\n                    mergecells.push({s:{c:c,r:r},e:{c:cc,r:rr}});\n                }\n                ++c;\n                if(cell.MergeAcross) c += +cell.MergeAcross;\n            } else {\n                cell = xlml_parsexmltagobj(Rn[0]);\n                if(cell.Index) c = +cell.Index - 1;\n                if(c < refguess.s.c) refguess.s.c = c;\n                if(c > refguess.e.c) refguess.e.c = c;\n                if(Rn[0].substr(-2) === \"/>\") ++c;\n                comments = [];\n            }\n            break;\n        case 'Row':\n            if(Rn[1]==='/' || Rn[0].substr(-2) === \"/>\") {\n                if(r < refguess.s.r) refguess.s.r = r;\n                if(r > refguess.e.r) refguess.e.r = r;\n                if(Rn[0].substr(-2) === \"/>\") {\n                    row = xlml_parsexmltag(Rn[0]);\n                    if(row.Index) r = +row.Index - 1;\n                }\n                c = 0; ++r;\n            } else {\n                row = xlml_parsexmltag(Rn[0]);\n                if(row.Index) r = +row.Index - 1;\n            }\n            break;\n        case 'Worksheet': /* TODO: read range from FullRows/FullColumns */\n            if(Rn[1]==='/'){\n                if((tmp=state.pop())[0]!==Rn[3]) throw \"Bad state: \"+tmp;\n                sheetnames.push(sheetname);\n                if(refguess.s.r <= refguess.e.r && refguess.s.c <= refguess.e.c) cursheet[\"!ref\"] = encode_range(refguess);\n                if(mergecells.length) cursheet[\"!merges\"] = mergecells;\n                sheets[sheetname] = cursheet;\n            } else {\n                refguess = {s: {r:1000000, c:1000000}, e: {r:0, c:0} };\n                r = c = 0;\n                state.push([Rn[3], false]);\n                tmp = xlml_parsexmltag(Rn[0]);\n                sheetname = tmp.Name;\n                cursheet = {};\n                mergecells = [];\n            }\n            break;\n        case 'Table':\n            if(Rn[1]==='/'){if((tmp=state.pop())[0]!==Rn[3]) throw \"Bad state: \"+tmp;}\n            else if(Rn[0].slice(-2) == \"/>\") break;\n            else {\n                table = xlml_parsexmltag(Rn[0]);\n                state.push([Rn[3], false]);\n                cstys = [];\n            }\n            break;\n\n        case 'Style':\n            if(Rn[1]==='/') process_style_xlml(styles, stag, opts);\n            else stag = xlml_parsexmltag(Rn[0]);\n            break;\n\n        case 'NumberFormat':\n            stag.nf = xlml_parsexmltag(Rn[0]).Format || \"General\";\n            break;\n\n        case 'Column':\n            if(state[state.length-1][0] !== 'Table') break;\n            csty = xlml_parsexmltag(Rn[0]);\n            cstys[(csty.Index-1||cstys.length)] = csty;\n            for(var i = 0; i < +csty.Span; ++i) cstys[cstys.length] = csty;\n            break;\n\n        case 'NamedRange': break;\n        case 'NamedCell': break;\n        case 'B': break;\n        case 'I': break;\n        case 'U': break;\n        case 'S': break;\n        case 'Sub': break;\n        case 'Sup': break;\n        case 'Span': break;\n        case 'Border': break;\n        case 'Alignment': break;\n        case 'Borders': break;\n        case 'Font':\n            if(Rn[0].substr(-2) === \"/>\") break;\n            else if(Rn[1]===\"/\") ss += str.slice(fidx, Rn.index);\n            else fidx = Rn.index + Rn[0].length;\n            break;\n        case 'Interior':\n            if(!opts.cellStyles) break;\n            stag.Interior = xlml_parsexmltag(Rn[0]);\n            break;\n        case 'Protection': break;\n\n        case 'Author':\n        case 'Title':\n        case 'Description':\n        case 'Created':\n        case 'Keywords':\n        case 'Subject':\n        case 'Category':\n        case 'Company':\n        case 'LastAuthor':\n        case 'LastSaved':\n        case 'LastPrinted':\n        case 'Version':\n        case 'Revision':\n        case 'TotalTime':\n        case 'HyperlinkBase':\n        case 'Manager':\n            if(Rn[0].substr(-2) === \"/>\") break;\n            else if(Rn[1]===\"/\") xlml_set_prop(Props, Rn[3], str.slice(pidx, Rn.index));\n            else pidx = Rn.index + Rn[0].length;\n            break;\n        case 'Paragraphs': break;\n\n        case 'Styles':\n        case 'Workbook':\n            if(Rn[1]==='/'){if((tmp=state.pop())[0]!==Rn[3]) throw \"Bad state: \"+tmp;}\n            else state.push([Rn[3], false]);\n            break;\n\n        case 'Comment':\n            if(Rn[1]==='/'){\n                if((tmp=state.pop())[0]!==Rn[3]) throw \"Bad state: \"+tmp;\n                xlml_clean_comment(comment);\n                comments.push(comment);\n            } else {\n                state.push([Rn[3], false]);\n                tmp = xlml_parsexmltag(Rn[0]);\n                comment = {a:tmp.Author};\n            }\n            break;\n\n        case 'Name': break;\n\n        case 'ComponentOptions':\n        case 'DocumentProperties':\n        case 'CustomDocumentProperties':\n        case 'OfficeDocumentSettings':\n        case 'PivotTable':\n        case 'PivotCache':\n        case 'Names':\n        case 'MapInfo':\n        case 'PageBreaks':\n        case 'QueryTable':\n        case 'DataValidation':\n        case 'AutoFilter':\n        case 'Sorting':\n        case 'Schema':\n        case 'data':\n        case 'ConditionalFormatting':\n        case 'SmartTagType':\n        case 'SmartTags':\n        case 'ExcelWorkbook':\n        case 'WorkbookOptions':\n        case 'WorksheetOptions':\n            if(Rn[1]==='/'){if((tmp=state.pop())[0]!==Rn[3]) throw \"Bad state: \"+tmp;}\n            else if(Rn[0].charAt(Rn[0].length-2) !== '/') state.push([Rn[3], true]);\n            break;\n\n        default:\n            var seen = true;\n            switch(state[state.length-1][0]) {\n                /* OfficeDocumentSettings */\n                case 'OfficeDocumentSettings': switch(Rn[3]) {\n                    case 'AllowPNG': break;\n                    case 'RemovePersonalInformation': break;\n                    case 'DownloadComponents': break;\n                    case 'LocationOfComponents': break;\n                    case 'Colors': break;\n                    case 'Color': break;\n                    case 'Index': break;\n                    case 'RGB': break;\n                    case 'PixelsPerInch': break;\n                    case 'TargetScreenSize': break;\n                    case 'ReadOnlyRecommended': break;\n                    default: seen = false;\n                } break;\n\n                /* ComponentOptions */\n                case 'ComponentOptions': switch(Rn[3]) {\n                    case 'Toolbar': break;\n                    case 'HideOfficeLogo': break;\n                    case 'SpreadsheetAutoFit': break;\n                    case 'Label': break;\n                    case 'Caption': break;\n                    case 'MaxHeight': break;\n                    case 'MaxWidth': break;\n                    case 'NextSheetNumber': break;\n                    default: seen = false;\n                } break;\n\n                /* ExcelWorkbook */\n                case 'ExcelWorkbook': switch(Rn[3]) {\n                    case 'WindowHeight': break;\n                    case 'WindowWidth': break;\n                    case 'WindowTopX': break;\n                    case 'WindowTopY': break;\n                    case 'TabRatio': break;\n                    case 'ProtectStructure': break;\n                    case 'ProtectWindows': break;\n                    case 'ActiveSheet': break;\n                    case 'DisplayInkNotes': break;\n                    case 'FirstVisibleSheet': break;\n                    case 'SupBook': break;\n                    case 'SheetName': break;\n                    case 'SheetIndex': break;\n                    case 'SheetIndexFirst': break;\n                    case 'SheetIndexLast': break;\n                    case 'Dll': break;\n                    case 'AcceptLabelsInFormulas': break;\n                    case 'DoNotSaveLinkValues': break;\n                    case 'Date1904': break;\n                    case 'Iteration': break;\n                    case 'MaxIterations': break;\n                    case 'MaxChange': break;\n                    case 'Path': break;\n                    case 'Xct': break;\n                    case 'Count': break;\n                    case 'SelectedSheets': break;\n                    case 'Calculation': break;\n                    case 'Uncalced': break;\n                    case 'StartupPrompt': break;\n                    case 'Crn': break;\n                    case 'ExternName': break;\n                    case 'Formula': break;\n                    case 'ColFirst': break;\n                    case 'ColLast': break;\n                    case 'WantAdvise': break;\n                    case 'Boolean': break;\n                    case 'Error': break;\n                    case 'Text': break;\n                    case 'OLE': break;\n                    case 'NoAutoRecover': break;\n                    case 'PublishObjects': break;\n                    case 'DoNotCalculateBeforeSave': break;\n                    case 'Number': break;\n                    case 'RefModeR1C1': break;\n                    case 'EmbedSaveSmartTags': break;\n                    default: seen = false;\n                } break;\n\n                /* WorkbookOptions */\n                case 'WorkbookOptions': switch(Rn[3]) {\n                    case 'OWCVersion': break;\n                    case 'Height': break;\n                    case 'Width': break;\n                    default: seen = false;\n                } break;\n\n                /* WorksheetOptions */\n                case 'WorksheetOptions': switch(Rn[3]) {\n                    case 'Unsynced': break;\n                    case 'Visible': break;\n                    case 'Print': break;\n                    case 'Panes': break;\n                    case 'Scale': break;\n                    case 'Pane': break;\n                    case 'Number': break;\n                    case 'Layout': break;\n                    case 'Header': break;\n                    case 'Footer': break;\n                    case 'PageSetup': break;\n                    case 'PageMargins': break;\n                    case 'Selected': break;\n                    case 'ProtectObjects': break;\n                    case 'EnableSelection': break;\n                    case 'ProtectScenarios': break;\n                    case 'ValidPrinterInfo': break;\n                    case 'HorizontalResolution': break;\n                    case 'VerticalResolution': break;\n                    case 'NumberofCopies': break;\n                    case 'ActiveRow': break;\n                    case 'ActiveCol': break;\n                    case 'ActivePane': break;\n                    case 'TopRowVisible': break;\n                    case 'TopRowBottomPane': break;\n                    case 'LeftColumnVisible': break;\n                    case 'LeftColumnRightPane': break;\n                    case 'FitToPage': break;\n                    case 'RangeSelection': break;\n                    case 'PaperSizeIndex': break;\n                    case 'PageLayoutZoom': break;\n                    case 'PageBreakZoom': break;\n                    case 'FilterOn': break;\n                    case 'DoNotDisplayGridlines': break;\n                    case 'SplitHorizontal': break;\n                    case 'SplitVertical': break;\n                    case 'FreezePanes': break;\n                    case 'FrozenNoSplit': break;\n                    case 'FitWidth': break;\n                    case 'FitHeight': break;\n                    case 'CommentsLayout': break;\n                    case 'Zoom': break;\n                    case 'LeftToRight': break;\n                    case 'Gridlines': break;\n                    case 'AllowSort': break;\n                    case 'AllowFilter': break;\n                    case 'AllowInsertRows': break;\n                    case 'AllowDeleteRows': break;\n                    case 'AllowInsertCols': break;\n                    case 'AllowDeleteCols': break;\n                    case 'AllowInsertHyperlinks': break;\n                    case 'AllowFormatCells': break;\n                    case 'AllowSizeCols': break;\n                    case 'AllowSizeRows': break;\n                    case 'NoSummaryRowsBelowDetail': break;\n                    case 'TabColorIndex': break;\n                    case 'DoNotDisplayHeadings': break;\n                    case 'ShowPageLayoutZoom': break;\n                    case 'NoSummaryColumnsRightDetail': break;\n                    case 'BlackAndWhite': break;\n                    case 'DoNotDisplayZeros': break;\n                    case 'DisplayPageBreak': break;\n                    case 'RowColHeadings': break;\n                    case 'DoNotDisplayOutline': break;\n                    case 'NoOrientation': break;\n                    case 'AllowUsePivotTables': break;\n                    case 'ZeroHeight': break;\n                    case 'ViewableRange': break;\n                    case 'Selection': break;\n                    case 'ProtectContents': break;\n                    default: seen = false;\n                } break;\n\n                /* PivotTable */\n                case 'PivotTable': case 'PivotCache': switch(Rn[3]) {\n                    case 'ImmediateItemsOnDrop': break;\n                    case 'ShowPageMultipleItemLabel': break;\n                    case 'CompactRowIndent': break;\n                    case 'Location': break;\n                    case 'PivotField': break;\n                    case 'Orientation': break;\n                    case 'LayoutForm': break;\n                    case 'LayoutSubtotalLocation': break;\n                    case 'LayoutCompactRow': break;\n                    case 'Position': break;\n                    case 'PivotItem': break;\n                    case 'DataType': break;\n                    case 'DataField': break;\n                    case 'SourceName': break;\n                    case 'ParentField': break;\n                    case 'PTLineItems': break;\n                    case 'PTLineItem': break;\n                    case 'CountOfSameItems': break;\n                    case 'Item': break;\n                    case 'ItemType': break;\n                    case 'PTSource': break;\n                    case 'CacheIndex': break;\n                    case 'ConsolidationReference': break;\n                    case 'FileName': break;\n                    case 'Reference': break;\n                    case 'NoColumnGrand': break;\n                    case 'NoRowGrand': break;\n                    case 'BlankLineAfterItems': break;\n                    case 'Hidden': break;\n                    case 'Subtotal': break;\n                    case 'BaseField': break;\n                    case 'MapChildItems': break;\n                    case 'Function': break;\n                    case 'RefreshOnFileOpen': break;\n                    case 'PrintSetTitles': break;\n                    case 'MergeLabels': break;\n                    case 'DefaultVersion': break;\n                    case 'RefreshName': break;\n                    case 'RefreshDate': break;\n                    case 'RefreshDateCopy': break;\n                    case 'VersionLastRefresh': break;\n                    case 'VersionLastUpdate': break;\n                    case 'VersionUpdateableMin': break;\n                    case 'VersionRefreshableMin': break;\n                    case 'Calculation': break;\n                    default: seen = false;\n                } break;\n\n                /* PageBreaks */\n                case 'PageBreaks': switch(Rn[3]) {\n                    case 'ColBreaks': break;\n                    case 'ColBreak': break;\n                    case 'RowBreaks': break;\n                    case 'RowBreak': break;\n                    case 'ColStart': break;\n                    case 'ColEnd': break;\n                    case 'RowEnd': break;\n                    default: seen = false;\n                } break;\n\n                /* AutoFilter */\n                case 'AutoFilter': switch(Rn[3]) {\n                    case 'AutoFilterColumn': break;\n                    case 'AutoFilterCondition': break;\n                    case 'AutoFilterAnd': break;\n                    case 'AutoFilterOr': break;\n                    default: seen = false;\n                } break;\n\n                /* QueryTable */\n                case 'QueryTable': switch(Rn[3]) {\n                    case 'Id': break;\n                    case 'AutoFormatFont': break;\n                    case 'AutoFormatPattern': break;\n                    case 'QuerySource': break;\n                    case 'QueryType': break;\n                    case 'EnableRedirections': break;\n                    case 'RefreshedInXl9': break;\n                    case 'URLString': break;\n                    case 'HTMLTables': break;\n                    case 'Connection': break;\n                    case 'CommandText': break;\n                    case 'RefreshInfo': break;\n                    case 'NoTitles': break;\n                    case 'NextId': break;\n                    case 'ColumnInfo': break;\n                    case 'OverwriteCells': break;\n                    case 'DoNotPromptForFile': break;\n                    case 'TextWizardSettings': break;\n                    case 'Source': break;\n                    case 'Number': break;\n                    case 'Decimal': break;\n                    case 'ThousandSeparator': break;\n                    case 'TrailingMinusNumbers': break;\n                    case 'FormatSettings': break;\n                    case 'FieldType': break;\n                    case 'Delimiters': break;\n                    case 'Tab': break;\n                    case 'Comma': break;\n                    case 'AutoFormatName': break;\n                    case 'VersionLastEdit': break;\n                    case 'VersionLastRefresh': break;\n                    default: seen = false;\n                } break;\n\n                /* Sorting */\n                case 'Sorting':\n                /* ConditionalFormatting */\n                case 'ConditionalFormatting':\n                /* DataValidation */\n                case 'DataValidation': switch(Rn[3]) {\n                    case 'Range': break;\n                    case 'Type': break;\n                    case 'Min': break;\n                    case 'Max': break;\n                    case 'Sort': break;\n                    case 'Descending': break;\n                    case 'Order': break;\n                    case 'CaseSensitive': break;\n                    case 'Value': break;\n                    case 'ErrorStyle': break;\n                    case 'ErrorMessage': break;\n                    case 'ErrorTitle': break;\n                    case 'CellRangeList': break;\n                    case 'InputMessage': break;\n                    case 'InputTitle': break;\n                    case 'ComboHide': break;\n                    case 'InputHide': break;\n                    case 'Condition': break;\n                    case 'Qualifier': break;\n                    case 'UseBlank': break;\n                    case 'Value1': break;\n                    case 'Value2': break;\n                    case 'Format': break;\n                    default: seen = false;\n                } break;\n\n                /* MapInfo (schema) */\n                case 'MapInfo': case 'Schema': case 'data': switch(Rn[3]) {\n                    case 'Map': break;\n                    case 'Entry': break;\n                    case 'Range': break;\n                    case 'XPath': break;\n                    case 'Field': break;\n                    case 'XSDType': break;\n                    case 'FilterOn': break;\n                    case 'Aggregate': break;\n                    case 'ElementType': break;\n                    case 'AttributeType': break;\n                /* These are from xsd (XML Schema Definition) */\n                    case 'schema':\n                    case 'element':\n                    case 'complexType':\n                    case 'datatype':\n                    case 'all':\n                    case 'attribute':\n                    case 'extends': break;\n\n                    case 'row': break;\n                    default: seen = false;\n                } break;\n\n                /* SmartTags (can be anything) */\n                case 'SmartTags': break;\n\n                default: seen = false; break;\n            }\n            if(seen) break;\n            /* CustomDocumentProperties */\n            if(!state[state.length-1][1]) throw 'Unrecognized tag: ' + Rn[3] + \"|\" + state.join(\"|\");\n            if(state[state.length-1][0]==='CustomDocumentProperties') {\n                if(Rn[0].substr(-2) === \"/>\") break;\n                else if(Rn[1]===\"/\") xlml_set_custprop(Custprops, Rn, cp, str.slice(pidx, Rn.index));\n                else { cp = Rn; pidx = Rn.index + Rn[0].length; }\n                break;\n            }\n            if(opts.WTF) throw 'Unrecognized tag: ' + Rn[3] + \"|\" + state.join(\"|\");\n    }\n    var out = {};\n    if(!opts.bookSheets && !opts.bookProps) out.Sheets = sheets;\n    out.SheetNames = sheetnames;\n    out.SSF = SSF.get_table();\n    out.Props = Props;\n    out.Custprops = Custprops;\n    return out;\n}\n\nfunction parse_xlml(data, opts) {\n    fix_read_opts(opts=opts||{});\n    switch(opts.type||\"base64\") {\n        case \"base64\": return parse_xlml_xml(Base64.decode(data), opts);\n        case \"binary\": case \"buffer\": case \"file\": return parse_xlml_xml(data, opts);\n        case \"array\": return parse_xlml_xml(data.map(_chr).join(\"\"), opts);\n    }\n}\n\nfunction write_xlml(wb, opts) { }\n\n/* [MS-OLEDS] 2.3.8 CompObjStream */\nfunction parse_compobj(obj) {\n    var v = {};\n    var o = obj.content;\n\n    /* [MS-OLEDS] 2.3.7 CompObjHeader -- All fields MUST be ignored */\n    var l = 28, m;\n    m = __lpstr(o, l);\n    l += 4 + __readUInt32LE(o,l);\n    v.UserType = m;\n\n    /* [MS-OLEDS] 2.3.1 ClipboardFormatOrAnsiString */\n    m = __readUInt32LE(o,l); l+= 4;\n    switch(m) {\n        case 0x00000000: break;\n        case 0xffffffff: case 0xfffffffe: l+=4; break;\n        default:\n            if(m > 0x190) throw new Error(\"Unsupported Clipboard: \" + m.toString(16));\n            l += m;\n    }\n\n    m = __lpstr(o, l); l += m.length === 0 ? 0 : 5 + m.length; v.Reserved1 = m;\n\n    if((m = __readUInt32LE(o,l)) !== 0x71b2e9f4) return v;\n    throw \"Unsupported Unicode Extension\";\n}\n\n/* 2.4.58 Continue logic */\nfunction slurp(R, blob, length, opts) {\n    var l = length;\n    var bufs = [];\n    var d = blob.slice(blob.l,blob.l+l);\n    if(opts && opts.enc && opts.enc.insitu_decrypt) switch(R.n) {\n    case 'BOF': case 'FilePass': case 'FileLock': case 'InterfaceHdr': case 'RRDInfo': case 'RRDHead': case 'UsrExcl': break;\n    default:\n        if(d.length === 0) break;\n        opts.enc.insitu_decrypt(d);\n    }\n    bufs.push(d);\n    blob.l += l;\n    var next = (XLSRecordEnum[__readUInt16LE(blob,blob.l)]);\n    while(next != null && next.n === 'Continue') {\n        l = __readUInt16LE(blob,blob.l+2);\n        bufs.push(blob.slice(blob.l+4,blob.l+4+l));\n        blob.l += 4+l;\n        next = (XLSRecordEnum[__readUInt16LE(blob, blob.l)]);\n    }\n    var b = bconcat(bufs);\n    prep_blob(b, 0);\n    var ll = 0; b.lens = [];\n    for(var j = 0; j < bufs.length; ++j) { b.lens.push(ll); ll += bufs[j].length; }\n    return R.f(b, b.length, opts);\n}\n\nfunction safe_format_xf(p, opts, date1904) {\n    if(!p.XF) return;\n    try {\n        var fmtid = p.XF.ifmt||0;\n        if(p.t === 'e') { p.w = p.w || BErr[p.v]; }\n        else if(fmtid === 0) {\n            if(p.t === 'n') {\n                if((p.v|0) === p.v) p.w = SSF._general_int(p.v);\n                else p.w = SSF._general_num(p.v);\n            }\n            else p.w = SSF._general(p.v);\n        }\n        else p.w = SSF.format(fmtid,p.v, {date1904:date1904||false});\n        if(opts.cellNF) p.z = SSF._table[fmtid];\n    } catch(e) { if(opts.WTF) throw e; }\n}\n\nfunction make_cell(val, ixfe, t) {\n    return {v:val, ixfe:ixfe, t:t};\n}\n\n// 2.3.2\nfunction parse_workbook(blob, options) {\n    var wb = {opts:{}};\n    var Sheets = {};\n    var out = {};\n    var Directory = {};\n    var found_sheet = false;\n    var range = {};\n    var last_formula = null;\n    var sst = [];\n    var cur_sheet = \"\";\n    var Preamble = {};\n    var lastcell, last_cell, cc, cmnt, rng, rngC, rngR;\n    var shared_formulae = {};\n    var array_formulae = []; /* TODO: something more clever */\n    var temp_val;\n    var country;\n    var cell_valid = true;\n    var XFs = []; /* XF records */\n    var palette = [];\n    var get_rgb = function getrgb(icv) {\n        if(icv < 8) return XLSIcv[icv];\n        if(icv < 64) return palette[icv-8] || XLSIcv[icv];\n        return XLSIcv[icv];\n    };\n    var process_cell_style = function pcs(cell, line) {\n        var xfd = line.XF.data;\n        if(!xfd || !xfd.patternType) return;\n        line.s = {};\n        line.s.patternType = xfd.patternType;\n        var t;\n        if((t = rgb2Hex(get_rgb(xfd.icvFore)))) { line.s.fgColor = {rgb:t}; }\n        if((t = rgb2Hex(get_rgb(xfd.icvBack)))) { line.s.bgColor = {rgb:t}; }\n    };\n    var addcell = function addcell(cell, line, options) {\n        if(!cell_valid) return;\n        if(options.cellStyles && line.XF && line.XF.data) process_cell_style(cell, line);\n        lastcell = cell;\n        last_cell = encode_cell(cell);\n        if(range.s) {\n            if(cell.r < range.s.r) range.s.r = cell.r;\n            if(cell.c < range.s.c) range.s.c = cell.c;\n        }\n        if(range.e) {\n            if(cell.r + 1 > range.e.r) range.e.r = cell.r + 1;\n            if(cell.c + 1 > range.e.c) range.e.c = cell.c + 1;\n        }\n        if(options.sheetRows && lastcell.r >= options.sheetRows) cell_valid = false;\n        else out[last_cell] = line;\n    };\n    var opts = {\n        enc: false, // encrypted\n        sbcch: 0, // cch in the preceding SupBook\n        snames: [], // sheetnames\n        sharedf: shared_formulae, // shared formulae by address\n        arrayf: array_formulae, // array formulae array\n        rrtabid: [], // RRTabId\n        lastuser: \"\", // Last User from WriteAccess\n        biff: 8, // BIFF version\n        codepage: 0, // CP from CodePage record\n        winlocked: 0, // fLockWn from WinProtect\n        wtf: false\n    };\n    if(options.password) opts.password = options.password;\n    var mergecells = [];\n    var objects = [];\n    var supbooks = [[]]; // 1-indexed, will hold extern names\n    var sbc = 0, sbci = 0, sbcli = 0;\n    supbooks.SheetNames = opts.snames;\n    supbooks.sharedf = opts.sharedf;\n    supbooks.arrayf = opts.arrayf;\n    var last_Rn = '';\n    var file_depth = 0; /* TODO: make a real stack */\n\n    /* explicit override for some broken writers */\n    opts.codepage = 1200;\n    set_cp(1200);\n\n    while(blob.l < blob.length - 1) {\n        var s = blob.l;\n        var RecordType = blob.read_shift(2);\n        if(RecordType === 0 && last_Rn === 'EOF') break;\n        var length = (blob.l === blob.length ? 0 : blob.read_shift(2)), y;\n        var R = XLSRecordEnum[RecordType];\n        if(R && R.f) {\n            if(options.bookSheets) {\n                if(last_Rn === 'BoundSheet8' && R.n !== 'BoundSheet8') break;\n            }\n            last_Rn = R.n;\n            if(R.r === 2 || R.r == 12) {\n                var rt = blob.read_shift(2); length -= 2;\n                if(!opts.enc && rt !== RecordType) throw \"rt mismatch\";\n                if(R.r == 12){ blob.l += 10; length -= 10; } // skip FRT\n            }\n            //console.error(R,blob.l,length,blob.length);\n            var val;\n            if(R.n === 'EOF') val = R.f(blob, length, opts);\n            else val = slurp(R, blob, length, opts);\n            var Rn = R.n;\n            /* BIFF5 overrides */\n            if(opts.biff === 5 || opts.biff === 2) switch(Rn) {\n                case 'Lbl': Rn = 'Label'; break;\n            }\n            /* nested switch statements to workaround V8 128 limit */\n            switch(Rn) {\n                /* Workbook Options */\n                case 'Date1904': wb.opts.Date1904 = val; break;\n                case 'WriteProtect': wb.opts.WriteProtect = true; break;\n                case 'FilePass':\n                    if(!opts.enc) blob.l = 0;\n                    opts.enc = val;\n                    if(opts.WTF) console.error(val);\n                    if(!options.password) throw new Error(\"File is password-protected\");\n                    if(val.Type !== 0) throw new Error(\"Encryption scheme unsupported\");\n                    if(!val.valid) throw new Error(\"Password is incorrect\");\n                    break;\n                case 'WriteAccess': opts.lastuser = val; break;\n                case 'FileSharing': break; //TODO\n                case 'CodePage':\n                    /* overrides based on test cases */\n                    if(val === 0x5212) val = 1200;\n                    else if(val === 0x8001) val = 1252;\n                    opts.codepage = val;\n                    set_cp(val);\n                    break;\n                case 'RRTabId': opts.rrtabid = val; break;\n                case 'WinProtect': opts.winlocked = val; break;\n                case 'Template': break; // TODO\n                case 'RefreshAll': wb.opts.RefreshAll = val; break;\n                case 'BookBool': break; // TODO\n                case 'UsesELFs': /* if(val) console.error(\"Unsupported ELFs\"); */ break;\n                case 'MTRSettings': {\n                    if(val[0] && val[1]) throw \"Unsupported threads: \" + val;\n                } break; // TODO: actually support threads\n                case 'CalcCount': wb.opts.CalcCount = val; break;\n                case 'CalcDelta': wb.opts.CalcDelta = val; break;\n                case 'CalcIter': wb.opts.CalcIter = val; break;\n                case 'CalcMode': wb.opts.CalcMode = val; break;\n                case 'CalcPrecision': wb.opts.CalcPrecision = val; break;\n                case 'CalcSaveRecalc': wb.opts.CalcSaveRecalc = val; break;\n                case 'CalcRefMode': opts.CalcRefMode = val; break; // TODO: implement R1C1\n                case 'Uncalced': break;\n                case 'ForceFullCalculation': wb.opts.FullCalc = val; break;\n                case 'WsBool': break; // TODO\n                case 'XF': XFs.push(val); break;\n                case 'ExtSST': break; // TODO\n                case 'BookExt': break; // TODO\n                case 'RichTextStream': break;\n                case 'BkHim': break;\n\n                case 'SupBook': supbooks[++sbc] = [val]; sbci = 0; break;\n                case 'ExternName': supbooks[sbc][++sbci] = val; break;\n                case 'Index': break; // TODO\n                case 'Lbl': supbooks[0][++sbcli] = val; break;\n                case 'ExternSheet': supbooks[sbc] = supbooks[sbc].concat(val); sbci += val.length; break;\n\n                case 'Protect': out[\"!protect\"] = val; break; /* for sheet or book */\n                case 'Password': if(val !== 0 && opts.WTF) console.error(\"Password verifier: \" + val); break;\n                case 'Prot4Rev': case 'Prot4RevPass': break; /*TODO: Revision Control*/\n\n                case 'BoundSheet8': {\n                    Directory[val.pos] = val;\n                    opts.snames.push(val.name);\n                } break;\n                case 'EOF': {\n                    if(--file_depth) break;\n                    if(range.e) {\n                        out[\"!range\"] = range;\n                        if(range.e.r > 0 && range.e.c > 0) {\n                            range.e.r--; range.e.c--;\n                            out[\"!ref\"] = encode_range(range);\n                            range.e.r++; range.e.c++;\n                        }\n                        if(mergecells.length > 0) out[\"!merges\"] = mergecells;\n                        if(objects.length > 0) out[\"!objects\"] = objects;\n                    }\n                    if(cur_sheet === \"\") Preamble = out; else Sheets[cur_sheet] = out;\n                    out = {};\n                } break;\n                case 'BOF': {\n                    if(opts.biff !== 8);\n                    else if(val.BIFFVer === 0x0500) opts.biff = 5;\n                    else if(val.BIFFVer === 0x0002) opts.biff = 2;\n                    else if(val.BIFFVer === 0x0007) opts.biff = 2;\n                    if(file_depth++) break;\n                    cell_valid = true;\n                    out = {};\n                    if(opts.biff === 2) {\n                        if(cur_sheet === \"\") cur_sheet = \"Sheet1\";\n                        range = {s:{r:0,c:0},e:{r:0,c:0}};\n                    }\n                    else cur_sheet = (Directory[s] || {name:\"\"}).name;\n                    mergecells = [];\n                    objects = [];\n                } break;\n                case 'Number': case 'BIFF2NUM': {\n                    temp_val = {ixfe: val.ixfe, XF: XFs[val.ixfe], v:val.val, t:'n'};\n                    if(temp_val.XF) safe_format_xf(temp_val, options, wb.opts.Date1904);\n                    addcell({c:val.c, r:val.r}, temp_val, options);\n                } break;\n                case 'BoolErr': {\n                    temp_val = {ixfe: val.ixfe, XF: XFs[val.ixfe], v:val.val, t:val.t};\n                    if(temp_val.XF) safe_format_xf(temp_val, options, wb.opts.Date1904);\n                    addcell({c:val.c, r:val.r}, temp_val, options);\n                } break;\n                case 'RK': {\n                    temp_val = {ixfe: val.ixfe, XF: XFs[val.ixfe], v:val.rknum, t:'n'};\n                    if(temp_val.XF) safe_format_xf(temp_val, options, wb.opts.Date1904);\n                    addcell({c:val.c, r:val.r}, temp_val, options);\n                } break;\n                case 'MulRk': {\n                    for(var j = val.c; j <= val.C; ++j) {\n                        var ixfe = val.rkrec[j-val.c][0];\n                        temp_val= {ixfe:ixfe, XF:XFs[ixfe], v:val.rkrec[j-val.c][1], t:'n'};\n                        if(temp_val.XF) safe_format_xf(temp_val, options, wb.opts.Date1904);\n                        addcell({c:j, r:val.r}, temp_val, options);\n                    }\n                } break;\n                case 'Formula': {\n                    switch(val.val) {\n                        case 'String': last_formula = val; break;\n                        case 'Array Formula': throw \"Array Formula unsupported\";\n                        default:\n                            temp_val = {v:val.val, ixfe:val.cell.ixfe, t:val.tt};\n                            temp_val.XF = XFs[temp_val.ixfe];\n                            if(options.cellFormula) temp_val.f = \"=\"+stringify_formula(val.formula,range,val.cell,supbooks, opts);\n                            if(temp_val.XF) safe_format_xf(temp_val, options, wb.opts.Date1904);\n                            addcell(val.cell, temp_val, options);\n                            last_formula = val;\n                    }\n                } break;\n                case 'String': {\n                    if(last_formula) {\n                        last_formula.val = val;\n                        temp_val = {v:last_formula.val, ixfe:last_formula.cell.ixfe, t:'s'};\n                        temp_val.XF = XFs[temp_val.ixfe];\n                        if(options.cellFormula) temp_val.f = \"=\"+stringify_formula(last_formula.formula, range, last_formula.cell, supbooks, opts);\n                        if(temp_val.XF) safe_format_xf(temp_val, options, wb.opts.Date1904);\n                        addcell(last_formula.cell, temp_val, options);\n                        last_formula = null;\n                    }\n                } break;\n                case 'Array': {\n                    array_formulae.push(val);\n                } break;\n                case 'ShrFmla': {\n                    if(!cell_valid) break;\n                    //if(options.cellFormula) out[last_cell].f = stringify_formula(val[0], range, lastcell, supbooks, opts);\n                    /* TODO: capture range */\n                    shared_formulae[encode_cell(last_formula.cell)]= val[0];\n                } break;\n                case 'LabelSst':\n                    //temp_val={v:sst[val.isst].t, ixfe:val.ixfe, t:'s'};\n                    temp_val=make_cell(sst[val.isst].t, val.ixfe, 's');\n                    temp_val.XF = XFs[temp_val.ixfe];\n                    if(temp_val.XF) safe_format_xf(temp_val, options, wb.opts.Date1904);\n                    addcell({c:val.c, r:val.r}, temp_val, options);\n                    break;\n                case 'Label': case 'BIFF2STR':\n                    /* Some writers erroneously write Label */\n                    temp_val=make_cell(val.val, val.ixfe, 's');\n                    temp_val.XF = XFs[temp_val.ixfe];\n                    if(temp_val.XF) safe_format_xf(temp_val, options, wb.opts.Date1904);\n                    addcell({c:val.c, r:val.r}, temp_val, options);\n                    break;\n                case 'Dimensions': {\n                    if(file_depth === 1) range = val; /* TODO: stack */\n                } break;\n                case 'SST': {\n                    sst = val;\n                } break;\n                case 'Format': { /* val = [id, fmt] */\n                    SSF.load(val[1], val[0]);\n                } break;\n\n                case 'MergeCells': mergecells = mergecells.concat(val); break;\n\n                case 'Obj': objects[val.cmo[0]] = opts.lastobj = val; break;\n                case 'TxO': opts.lastobj.TxO = val; break;\n\n                case 'HLink': {\n                    for(rngR = val[0].s.r; rngR <= val[0].e.r; ++rngR)\n                        for(rngC = val[0].s.c; rngC <= val[0].e.c; ++rngC)\n                            if(out[encode_cell({c:rngC,r:rngR})])\n                                out[encode_cell({c:rngC,r:rngR})].l = val[1];\n                } break;\n                case 'HLinkTooltip': {\n                    for(rngR = val[0].s.r; rngR <= val[0].e.r; ++rngR)\n                        for(rngC = val[0].s.c; rngC <= val[0].e.c; ++rngC)\n                            if(out[encode_cell({c:rngC,r:rngR})])\n                                out[encode_cell({c:rngC,r:rngR})].l.tooltip = val[1];\n                } break;\n\n                /* Comments */\n                case 'Note': {\n                    if(opts.biff <= 5 && opts.biff >= 2) break; /* TODO: BIFF5 */\n                    cc = out[encode_cell(val[0])];\n                    var noteobj = objects[val[2]];\n                    if(!cc) break;\n                    if(!cc.c) cc.c = [];\n                    cmnt = {a:val[1],t:noteobj.TxO.t};\n                    cc.c.push(cmnt);\n                } break;\n\n                default: switch(R.n) { /* nested */\n                case 'ClrtClient': break;\n                case 'XFExt': update_xfext(XFs[val.ixfe], val.ext); break;\n\n                case 'NameCmt': break;\n                case 'Header': break; // TODO\n                case 'Footer': break; // TODO\n                case 'HCenter': break; // TODO\n                case 'VCenter': break; // TODO\n                case 'Pls': break; // TODO\n                case 'Setup': break; // TODO\n                case 'DefColWidth': break; // TODO\n                case 'GCW': break;\n                case 'LHRecord': break;\n                case 'ColInfo': break; // TODO\n                case 'Row': break; // TODO\n                case 'DBCell': break; // TODO\n                case 'MulBlank': break; // TODO\n                case 'EntExU2': break; // TODO\n                case 'SxView': break; // TODO\n                case 'Sxvd': break; // TODO\n                case 'SXVI': break; // TODO\n                case 'SXVDEx': break; // TODO\n                case 'SxIvd': break; // TODO\n                case 'SXDI': break; // TODO\n                case 'SXLI': break; // TODO\n                case 'SXEx': break; // TODO\n                case 'QsiSXTag': break; // TODO\n                case 'Selection': break;\n                case 'Feat': break;\n                case 'FeatHdr': case 'FeatHdr11': break;\n                case 'Feature11': case 'Feature12': case 'List12': break;\n                case 'Blank': break;\n                case 'Country': country = val; break;\n                case 'RecalcId': break;\n                case 'DefaultRowHeight': case 'DxGCol': break; // TODO: htmlify\n                case 'Fbi': case 'Fbi2': case 'GelFrame': break;\n                case 'Font': break; // TODO\n                case 'XFCRC': break; // TODO\n                case 'Style': break; // TODO\n                case 'StyleExt': break; // TODO\n                case 'Palette': palette = val; break; // TODO\n                case 'Theme': break; // TODO\n                /* Protection */\n                case 'ScenarioProtect': break;\n                case 'ObjProtect': break;\n\n                /* Conditional Formatting */\n                case 'CondFmt12': break;\n\n                /* Table */\n                case 'Table': break; // TODO\n                case 'TableStyles': break; // TODO\n                case 'TableStyle': break; // TODO\n                case 'TableStyleElement': break; // TODO\n\n                /* PivotTable */\n                case 'SXStreamID': break; // TODO\n                case 'SXVS': break; // TODO\n                case 'DConRef': break; // TODO\n                case 'SXAddl': break; // TODO\n                case 'DConBin': break; // TODO\n                case 'DConName': break; // TODO\n                case 'SXPI': break; // TODO\n                case 'SxFormat': break; // TODO\n                case 'SxSelect': break; // TODO\n                case 'SxRule': break; // TODO\n                case 'SxFilt': break; // TODO\n                case 'SxItm': break; // TODO\n                case 'SxDXF': break; // TODO\n\n                /* Scenario Manager */\n                case 'ScenMan': break;\n\n                /* Data Consolidation */\n                case 'DCon': break;\n\n                /* Watched Cell */\n                case 'CellWatch': break;\n\n                /* Print Settings */\n                case 'PrintRowCol': break;\n                case 'PrintGrid': break;\n                case 'PrintSize': break;\n\n                case 'XCT': break;\n                case 'CRN': break;\n\n                case 'Scl': {\n                    //console.log(\"Zoom Level:\", val[0]/val[1],val);\n                } break;\n                case 'SheetExt': {\n\n                } break;\n                case 'SheetExtOptional': {\n\n                } break;\n\n                /* VBA */\n                case 'ObNoMacros': {\n\n                } break;\n                case 'ObProj': {\n\n                } break;\n                case 'CodeName': {\n\n                } break;\n                case 'GUIDTypeLib': {\n\n                } break;\n\n                case 'WOpt': break; // TODO: WTF?\n                case 'PhoneticInfo': break;\n\n                case 'OleObjectSize': break;\n\n                /* Differential Formatting */\n                case 'DXF': case 'DXFN': case 'DXFN12': case 'DXFN12List': case 'DXFN12NoCB': break;\n\n                /* Data Validation */\n                case 'Dv': case 'DVal': break;\n\n                /* Data Series */\n                case 'BRAI': case 'Series': case 'SeriesText': break;\n\n                /* Data Connection */\n                case 'DConn': break;\n                case 'DbOrParamQry': break;\n                case 'DBQueryExt': break;\n\n                /* Formatting */\n                case 'IFmtRecord': break;\n                case 'CondFmt': case 'CF': case 'CF12': case 'CFEx': break;\n\n                /* Explicitly Ignored */\n                case 'Excel9File': break;\n                case 'Units': break;\n                case 'InterfaceHdr': case 'Mms': case 'InterfaceEnd': case 'DSF': case 'BuiltInFnGroupCount':\n                /* View Stuff */\n                case 'Window1': case 'Window2': case 'HideObj': case 'GridSet': case 'Guts':\n                case 'UserBView': case 'UserSViewBegin': case 'UserSViewEnd':\n                case 'Pane': break;\n                default: switch(R.n) { /* nested */\n                /* Chart */\n                case 'Dat':\n                case 'Begin': case 'End':\n                case 'StartBlock': case 'EndBlock':\n                case 'Frame': case 'Area':\n                case 'Axis': case 'AxisLine': case 'Tick': break;\n                case 'AxesUsed':\n                case 'CrtLayout12': case 'CrtLayout12A': case 'CrtLink': case 'CrtLine': case 'CrtMlFrt': case 'CrtMlFrtContinue': break;\n                case 'LineFormat': case 'AreaFormat':\n                case 'Chart': case 'Chart3d': case 'Chart3DBarShape': case 'ChartFormat': case 'ChartFrtInfo': break;\n                case 'PlotArea': case 'PlotGrowth': break;\n                case 'SeriesList': case 'SerParent': case 'SerAuxTrend': break;\n                case 'DataFormat': case 'SerToCrt': case 'FontX': break;\n                case 'CatSerRange': case 'AxcExt': case 'SerFmt': break;\n                case 'ShtProps': break;\n                case 'DefaultText': case 'Text': case 'CatLab': break;\n                case 'DataLabExtContents': break;\n                case 'Legend': case 'LegendException': break;\n                case 'Pie': case 'Scatter': break;\n                case 'PieFormat': case 'MarkerFormat': break;\n                case 'StartObject': case 'EndObject': break;\n                case 'AlRuns': case 'ObjectLink': break;\n                case 'SIIndex': break;\n                case 'AttachedLabel': case 'YMult': break;\n\n                /* Chart Group */\n                case 'Line': case 'Bar': break;\n                case 'Surf': break;\n\n                /* Axis Group */\n                case 'AxisParent': break;\n                case 'Pos': break;\n                case 'ValueRange': break;\n\n                /* Pivot Chart */\n                case 'SXViewEx9': break; // TODO\n                case 'SXViewLink': break;\n                case 'PivotChartBits': break;\n                case 'SBaseRef': break;\n                case 'TextPropsStream': break;\n\n                /* Chart Misc */\n                case 'LnExt': break;\n                case 'MkrExt': break;\n                case 'CrtCoopt': break;\n\n                /* Query Table */\n                case 'Qsi': case 'Qsif': case 'Qsir': case 'QsiSXTag': break;\n                case 'TxtQry': break;\n\n                /* Filter */\n                case 'FilterMode': break;\n                case 'AutoFilter': case 'AutoFilterInfo': break;\n                case 'AutoFilter12': break;\n                case 'DropDownObjIds': break;\n                case 'Sort': break;\n                case 'SortData': break;\n\n                /* Drawing */\n                case 'ShapePropsStream': break;\n                case 'MsoDrawing': case 'MsoDrawingGroup': case 'MsoDrawingSelection': break;\n                case 'ImData': break;\n                /* Pub Stuff */\n                case 'WebPub': case 'AutoWebPub':\n\n                /* Print Stuff */\n                case 'RightMargin': case 'LeftMargin': case 'TopMargin': case 'BottomMargin':\n                case 'HeaderFooter': case 'HFPicture': case 'PLV':\n                case 'HorizontalPageBreaks': case 'VerticalPageBreaks':\n                /* Behavioral */\n                case 'Backup': case 'CompressPictures': case 'Compat12': break;\n\n                /* Should not Happen */\n                case 'Continue': case 'ContinueFrt12': break;\n\n                /* Future Records */\n                case 'FrtFontList': case 'FrtWrapper': break;\n\n                /* BIFF5 records */\n                case 'ExternCount': break;\n                case 'RString': break;\n                case 'TabIdConf': case 'Radar': case 'RadarArea': case 'DropBar': case 'Intl': case 'CoordList': case 'SerAuxErrBar': break;\n\n                default: switch(R.n) { /* nested */\n                /* Miscellaneous */\n                case 'SCENARIO': case 'DConBin': case 'PicF': case 'DataLabExt':\n                case 'Lel': case 'BopPop': case 'BopPopCustom': case 'RealTimeData':\n                case 'Name': break;\n                default: if(options.WTF) throw 'Unrecognized Record ' + R.n;\n            }}}}\n        } else blob.l += length;\n    }\n    var sheetnamesraw = opts.biff === 2 ? ['Sheet1'] : Object.keys(Directory).sort(function(a,b) { return Number(a) - Number(b); }).map(function(x){return Directory[x].name;});\n    var sheetnames = sheetnamesraw.slice();\n    wb.Directory=sheetnamesraw;\n    wb.SheetNames=sheetnamesraw;\n    if(!options.bookSheets) wb.Sheets=Sheets;\n    wb.Preamble=Preamble;\n    wb.Strings = sst;\n    wb.SSF = SSF.get_table();\n    if(opts.enc) wb.Encryption = opts.enc;\n    wb.Metadata = {};\n    if(country !== undefined) wb.Metadata.Country = country;\n    return wb;\n}\n\nfunction parse_xlscfb(cfb, options) {\nif(!options) options = {};\nfix_read_opts(options);\nreset_cp();\nvar CompObj, Summary, Workbook;\nif(cfb.find) {\n    CompObj = cfb.find('!CompObj');\n    Summary = cfb.find('!SummaryInformation');\n    Workbook = cfb.find('/Workbook');\n} else {\n    prep_blob(cfb, 0);\n    Workbook = {content: cfb};\n}\n\nif(!Workbook) Workbook = cfb.find('/Book');\nvar CompObjP, SummaryP, WorkbookP;\n\nif(CompObj) CompObjP = parse_compobj(CompObj);\nif(options.bookProps && !options.bookSheets) WorkbookP = {};\nelse {\n    if(Workbook) WorkbookP = parse_workbook(Workbook.content, options, !!Workbook.find);\n    else throw new Error(\"Cannot find Workbook stream\");\n}\n\nif(cfb.find) parse_props(cfb);\n\nvar props = {};\nfor(var y in cfb.Summary) props[y] = cfb.Summary[y];\nfor(y in cfb.DocSummary) props[y] = cfb.DocSummary[y];\nWorkbookP.Props = WorkbookP.Custprops = props; /* TODO: split up properties */\nif(options.bookFiles) WorkbookP.cfb = cfb;\nWorkbookP.CompObjP = CompObjP;\nreturn WorkbookP;\n}\n\n/* TODO: WTF */\nfunction parse_props(cfb) {\n    /* [MS-OSHARED] 2.3.3.2.2 Document Summary Information Property Set */\n    var DSI = cfb.find('!DocumentSummaryInformation');\n    if(DSI) try { cfb.DocSummary = parse_PropertySetStream(DSI, DocSummaryPIDDSI); } catch(e) {}\n\n    /* [MS-OSHARED] 2.3.3.2.1 Summary Information Property Set*/\n    var SI = cfb.find('!SummaryInformation');\n    if(SI) try { cfb.Summary = parse_PropertySetStream(SI, SummaryPIDSI); } catch(e) {}\n}\n\n/* [MS-XLSB] 2.3 Record Enumeration */\nvar XLSBRecordEnum = {\n    0x0000: { n:\"BrtRowHdr\", f:parse_BrtRowHdr },\n    0x0001: { n:\"BrtCellBlank\", f:parse_BrtCellBlank },\n    0x0002: { n:\"BrtCellRk\", f:parse_BrtCellRk },\n    0x0003: { n:\"BrtCellError\", f:parse_BrtCellError },\n    0x0004: { n:\"BrtCellBool\", f:parse_BrtCellBool },\n    0x0005: { n:\"BrtCellReal\", f:parse_BrtCellReal },\n    0x0006: { n:\"BrtCellSt\", f:parse_BrtCellSt },\n    0x0007: { n:\"BrtCellIsst\", f:parse_BrtCellIsst },\n    0x0008: { n:\"BrtFmlaString\", f:parse_BrtFmlaString },\n    0x0009: { n:\"BrtFmlaNum\", f:parse_BrtFmlaNum },\n    0x000A: { n:\"BrtFmlaBool\", f:parse_BrtFmlaBool },\n    0x000B: { n:\"BrtFmlaError\", f:parse_BrtFmlaError },\n    0x0010: { n:\"BrtFRTArchID$\", f:parse_BrtFRTArchID$ },\n    0x0013: { n:\"BrtSSTItem\", f:parse_RichStr },\n    0x0014: { n:\"BrtPCDIMissing\", f:parsenoop },\n    0x0015: { n:\"BrtPCDINumber\", f:parsenoop },\n    0x0016: { n:\"BrtPCDIBoolean\", f:parsenoop },\n    0x0017: { n:\"BrtPCDIError\", f:parsenoop },\n    0x0018: { n:\"BrtPCDIString\", f:parsenoop },\n    0x0019: { n:\"BrtPCDIDatetime\", f:parsenoop },\n    0x001A: { n:\"BrtPCDIIndex\", f:parsenoop },\n    0x001B: { n:\"BrtPCDIAMissing\", f:parsenoop },\n    0x001C: { n:\"BrtPCDIANumber\", f:parsenoop },\n    0x001D: { n:\"BrtPCDIABoolean\", f:parsenoop },\n    0x001E: { n:\"BrtPCDIAError\", f:parsenoop },\n    0x001F: { n:\"BrtPCDIAString\", f:parsenoop },\n    0x0020: { n:\"BrtPCDIADatetime\", f:parsenoop },\n    0x0021: { n:\"BrtPCRRecord\", f:parsenoop },\n    0x0022: { n:\"BrtPCRRecordDt\", f:parsenoop },\n    0x0023: { n:\"BrtFRTBegin\", f:parsenoop },\n    0x0024: { n:\"BrtFRTEnd\", f:parsenoop },\n    0x0025: { n:\"BrtACBegin\", f:parsenoop },\n    0x0026: { n:\"BrtACEnd\", f:parsenoop },\n    0x0027: { n:\"BrtName\", f:parsenoop },\n    0x0028: { n:\"BrtIndexRowBlock\", f:parsenoop },\n    0x002A: { n:\"BrtIndexBlock\", f:parsenoop },\n    0x002B: { n:\"BrtFont\", f:parse_BrtFont },\n    0x002C: { n:\"BrtFmt\", f:parse_BrtFmt },\n    0x002D: { n:\"BrtFill\", f:parsenoop },\n    0x002E: { n:\"BrtBorder\", f:parsenoop },\n    0x002F: { n:\"BrtXF\", f:parse_BrtXF },\n    0x0030: { n:\"BrtStyle\", f:parsenoop },\n    0x0031: { n:\"BrtCellMeta\", f:parsenoop },\n    0x0032: { n:\"BrtValueMeta\", f:parsenoop },\n    0x0033: { n:\"BrtMdb\", f:parsenoop },\n    0x0034: { n:\"BrtBeginFmd\", f:parsenoop },\n    0x0035: { n:\"BrtEndFmd\", f:parsenoop },\n    0x0036: { n:\"BrtBeginMdx\", f:parsenoop },\n    0x0037: { n:\"BrtEndMdx\", f:parsenoop },\n    0x0038: { n:\"BrtBeginMdxTuple\", f:parsenoop },\n    0x0039: { n:\"BrtEndMdxTuple\", f:parsenoop },\n    0x003A: { n:\"BrtMdxMbrIstr\", f:parsenoop },\n    0x003B: { n:\"BrtStr\", f:parsenoop },\n    0x003C: { n:\"BrtColInfo\", f:parsenoop },\n    0x003E: { n:\"BrtCellRString\", f:parsenoop },\n    0x003F: { n:\"BrtCalcChainItem$\", f:parse_BrtCalcChainItem$ },\n    0x0040: { n:\"BrtDVal\", f:parsenoop },\n    0x0041: { n:\"BrtSxvcellNum\", f:parsenoop },\n    0x0042: { n:\"BrtSxvcellStr\", f:parsenoop },\n    0x0043: { n:\"BrtSxvcellBool\", f:parsenoop },\n    0x0044: { n:\"BrtSxvcellErr\", f:parsenoop },\n    0x0045: { n:\"BrtSxvcellDate\", f:parsenoop },\n    0x0046: { n:\"BrtSxvcellNil\", f:parsenoop },\n    0x0080: { n:\"BrtFileVersion\", f:parsenoop },\n    0x0081: { n:\"BrtBeginSheet\", f:parsenoop },\n    0x0082: { n:\"BrtEndSheet\", f:parsenoop },\n    0x0083: { n:\"BrtBeginBook\", f:parsenoop, p:0 },\n    0x0084: { n:\"BrtEndBook\", f:parsenoop },\n    0x0085: { n:\"BrtBeginWsViews\", f:parsenoop },\n    0x0086: { n:\"BrtEndWsViews\", f:parsenoop },\n    0x0087: { n:\"BrtBeginBookViews\", f:parsenoop },\n    0x0088: { n:\"BrtEndBookViews\", f:parsenoop },\n    0x0089: { n:\"BrtBeginWsView\", f:parsenoop },\n    0x008A: { n:\"BrtEndWsView\", f:parsenoop },\n    0x008B: { n:\"BrtBeginCsViews\", f:parsenoop },\n    0x008C: { n:\"BrtEndCsViews\", f:parsenoop },\n    0x008D: { n:\"BrtBeginCsView\", f:parsenoop },\n    0x008E: { n:\"BrtEndCsView\", f:parsenoop },\n    0x008F: { n:\"BrtBeginBundleShs\", f:parsenoop },\n    0x0090: { n:\"BrtEndBundleShs\", f:parsenoop },\n    0x0091: { n:\"BrtBeginSheetData\", f:parsenoop },\n    0x0092: { n:\"BrtEndSheetData\", f:parsenoop },\n    0x0093: { n:\"BrtWsProp\", f:parse_BrtWsProp },\n    0x0094: { n:\"BrtWsDim\", f:parse_BrtWsDim, p:16 },\n    0x0097: { n:\"BrtPane\", f:parsenoop },\n    0x0098: { n:\"BrtSel\", f:parsenoop },\n    0x0099: { n:\"BrtWbProp\", f:parse_BrtWbProp },\n    0x009A: { n:\"BrtWbFactoid\", f:parsenoop },\n    0x009B: { n:\"BrtFileRecover\", f:parsenoop },\n    0x009C: { n:\"BrtBundleSh\", f:parse_BrtBundleSh },\n    0x009D: { n:\"BrtCalcProp\", f:parsenoop },\n    0x009E: { n:\"BrtBookView\", f:parsenoop },\n    0x009F: { n:\"BrtBeginSst\", f:parse_BrtBeginSst },\n    0x00A0: { n:\"BrtEndSst\", f:parsenoop },\n    0x00A1: { n:\"BrtBeginAFilter\", f:parsenoop },\n    0x00A2: { n:\"BrtEndAFilter\", f:parsenoop },\n    0x00A3: { n:\"BrtBeginFilterColumn\", f:parsenoop },\n    0x00A4: { n:\"BrtEndFilterColumn\", f:parsenoop },\n    0x00A5: { n:\"BrtBeginFilters\", f:parsenoop },\n    0x00A6: { n:\"BrtEndFilters\", f:parsenoop },\n    0x00A7: { n:\"BrtFilter\", f:parsenoop },\n    0x00A8: { n:\"BrtColorFilter\", f:parsenoop },\n    0x00A9: { n:\"BrtIconFilter\", f:parsenoop },\n    0x00AA: { n:\"BrtTop10Filter\", f:parsenoop },\n    0x00AB: { n:\"BrtDynamicFilter\", f:parsenoop },\n    0x00AC: { n:\"BrtBeginCustomFilters\", f:parsenoop },\n    0x00AD: { n:\"BrtEndCustomFilters\", f:parsenoop },\n    0x00AE: { n:\"BrtCustomFilter\", f:parsenoop },\n    0x00AF: { n:\"BrtAFilterDateGroupItem\", f:parsenoop },\n    0x00B0: { n:\"BrtMergeCell\", f:parse_BrtMergeCell },\n    0x00B1: { n:\"BrtBeginMergeCells\", f:parsenoop },\n    0x00B2: { n:\"BrtEndMergeCells\", f:parsenoop },\n    0x00B3: { n:\"BrtBeginPivotCacheDef\", f:parsenoop },\n    0x00B4: { n:\"BrtEndPivotCacheDef\", f:parsenoop },\n    0x00B5: { n:\"BrtBeginPCDFields\", f:parsenoop },\n    0x00B6: { n:\"BrtEndPCDFields\", f:parsenoop },\n    0x00B7: { n:\"BrtBeginPCDField\", f:parsenoop },\n    0x00B8: { n:\"BrtEndPCDField\", f:parsenoop },\n    0x00B9: { n:\"BrtBeginPCDSource\", f:parsenoop },\n    0x00BA: { n:\"BrtEndPCDSource\", f:parsenoop },\n    0x00BB: { n:\"BrtBeginPCDSRange\", f:parsenoop },\n    0x00BC: { n:\"BrtEndPCDSRange\", f:parsenoop },\n    0x00BD: { n:\"BrtBeginPCDFAtbl\", f:parsenoop },\n    0x00BE: { n:\"BrtEndPCDFAtbl\", f:parsenoop },\n    0x00BF: { n:\"BrtBeginPCDIRun\", f:parsenoop },\n    0x00C0: { n:\"BrtEndPCDIRun\", f:parsenoop },\n    0x00C1: { n:\"BrtBeginPivotCacheRecords\", f:parsenoop },\n    0x00C2: { n:\"BrtEndPivotCacheRecords\", f:parsenoop },\n    0x00C3: { n:\"BrtBeginPCDHierarchies\", f:parsenoop },\n    0x00C4: { n:\"BrtEndPCDHierarchies\", f:parsenoop },\n    0x00C5: { n:\"BrtBeginPCDHierarchy\", f:parsenoop },\n    0x00C6: { n:\"BrtEndPCDHierarchy\", f:parsenoop },\n    0x00C7: { n:\"BrtBeginPCDHFieldsUsage\", f:parsenoop },\n    0x00C8: { n:\"BrtEndPCDHFieldsUsage\", f:parsenoop },\n    0x00C9: { n:\"BrtBeginExtConnection\", f:parsenoop },\n    0x00CA: { n:\"BrtEndExtConnection\", f:parsenoop },\n    0x00CB: { n:\"BrtBeginECDbProps\", f:parsenoop },\n    0x00CC: { n:\"BrtEndECDbProps\", f:parsenoop },\n    0x00CD: { n:\"BrtBeginECOlapProps\", f:parsenoop },\n    0x00CE: { n:\"BrtEndECOlapProps\", f:parsenoop },\n    0x00CF: { n:\"BrtBeginPCDSConsol\", f:parsenoop },\n    0x00D0: { n:\"BrtEndPCDSConsol\", f:parsenoop },\n    0x00D1: { n:\"BrtBeginPCDSCPages\", f:parsenoop },\n    0x00D2: { n:\"BrtEndPCDSCPages\", f:parsenoop },\n    0x00D3: { n:\"BrtBeginPCDSCPage\", f:parsenoop },\n    0x00D4: { n:\"BrtEndPCDSCPage\", f:parsenoop },\n    0x00D5: { n:\"BrtBeginPCDSCPItem\", f:parsenoop },\n    0x00D6: { n:\"BrtEndPCDSCPItem\", f:parsenoop },\n    0x00D7: { n:\"BrtBeginPCDSCSets\", f:parsenoop },\n    0x00D8: { n:\"BrtEndPCDSCSets\", f:parsenoop },\n    0x00D9: { n:\"BrtBeginPCDSCSet\", f:parsenoop },\n    0x00DA: { n:\"BrtEndPCDSCSet\", f:parsenoop },\n    0x00DB: { n:\"BrtBeginPCDFGroup\", f:parsenoop },\n    0x00DC: { n:\"BrtEndPCDFGroup\", f:parsenoop },\n    0x00DD: { n:\"BrtBeginPCDFGItems\", f:parsenoop },\n    0x00DE: { n:\"BrtEndPCDFGItems\", f:parsenoop },\n    0x00DF: { n:\"BrtBeginPCDFGRange\", f:parsenoop },\n    0x00E0: { n:\"BrtEndPCDFGRange\", f:parsenoop },\n    0x00E1: { n:\"BrtBeginPCDFGDiscrete\", f:parsenoop },\n    0x00E2: { n:\"BrtEndPCDFGDiscrete\", f:parsenoop },\n    0x00E3: { n:\"BrtBeginPCDSDTupleCache\", f:parsenoop },\n    0x00E4: { n:\"BrtEndPCDSDTupleCache\", f:parsenoop },\n    0x00E5: { n:\"BrtBeginPCDSDTCEntries\", f:parsenoop },\n    0x00E6: { n:\"BrtEndPCDSDTCEntries\", f:parsenoop },\n    0x00E7: { n:\"BrtBeginPCDSDTCEMembers\", f:parsenoop },\n    0x00E8: { n:\"BrtEndPCDSDTCEMembers\", f:parsenoop },\n    0x00E9: { n:\"BrtBeginPCDSDTCEMember\", f:parsenoop },\n    0x00EA: { n:\"BrtEndPCDSDTCEMember\", f:parsenoop },\n    0x00EB: { n:\"BrtBeginPCDSDTCQueries\", f:parsenoop },\n    0x00EC: { n:\"BrtEndPCDSDTCQueries\", f:parsenoop },\n    0x00ED: { n:\"BrtBeginPCDSDTCQuery\", f:parsenoop },\n    0x00EE: { n:\"BrtEndPCDSDTCQuery\", f:parsenoop },\n    0x00EF: { n:\"BrtBeginPCDSDTCSets\", f:parsenoop },\n    0x00F0: { n:\"BrtEndPCDSDTCSets\", f:parsenoop },\n    0x00F1: { n:\"BrtBeginPCDSDTCSet\", f:parsenoop },\n    0x00F2: { n:\"BrtEndPCDSDTCSet\", f:parsenoop },\n    0x00F3: { n:\"BrtBeginPCDCalcItems\", f:parsenoop },\n    0x00F4: { n:\"BrtEndPCDCalcItems\", f:parsenoop },\n    0x00F5: { n:\"BrtBeginPCDCalcItem\", f:parsenoop },\n    0x00F6: { n:\"BrtEndPCDCalcItem\", f:parsenoop },\n    0x00F7: { n:\"BrtBeginPRule\", f:parsenoop },\n    0x00F8: { n:\"BrtEndPRule\", f:parsenoop },\n    0x00F9: { n:\"BrtBeginPRFilters\", f:parsenoop },\n    0x00FA: { n:\"BrtEndPRFilters\", f:parsenoop },\n    0x00FB: { n:\"BrtBeginPRFilter\", f:parsenoop },\n    0x00FC: { n:\"BrtEndPRFilter\", f:parsenoop },\n    0x00FD: { n:\"BrtBeginPNames\", f:parsenoop },\n    0x00FE: { n:\"BrtEndPNames\", f:parsenoop },\n    0x00FF: { n:\"BrtBeginPName\", f:parsenoop },\n    0x0100: { n:\"BrtEndPName\", f:parsenoop },\n    0x0101: { n:\"BrtBeginPNPairs\", f:parsenoop },\n    0x0102: { n:\"BrtEndPNPairs\", f:parsenoop },\n    0x0103: { n:\"BrtBeginPNPair\", f:parsenoop },\n    0x0104: { n:\"BrtEndPNPair\", f:parsenoop },\n    0x0105: { n:\"BrtBeginECWebProps\", f:parsenoop },\n    0x0106: { n:\"BrtEndECWebProps\", f:parsenoop },\n    0x0107: { n:\"BrtBeginEcWpTables\", f:parsenoop },\n    0x0108: { n:\"BrtEndECWPTables\", f:parsenoop },\n    0x0109: { n:\"BrtBeginECParams\", f:parsenoop },\n    0x010A: { n:\"BrtEndECParams\", f:parsenoop },\n    0x010B: { n:\"BrtBeginECParam\", f:parsenoop },\n    0x010C: { n:\"BrtEndECParam\", f:parsenoop },\n    0x010D: { n:\"BrtBeginPCDKPIs\", f:parsenoop },\n    0x010E: { n:\"BrtEndPCDKPIs\", f:parsenoop },\n    0x010F: { n:\"BrtBeginPCDKPI\", f:parsenoop },\n    0x0110: { n:\"BrtEndPCDKPI\", f:parsenoop },\n    0x0111: { n:\"BrtBeginDims\", f:parsenoop },\n    0x0112: { n:\"BrtEndDims\", f:parsenoop },\n    0x0113: { n:\"BrtBeginDim\", f:parsenoop },\n    0x0114: { n:\"BrtEndDim\", f:parsenoop },\n    0x0115: { n:\"BrtIndexPartEnd\", f:parsenoop },\n    0x0116: { n:\"BrtBeginStyleSheet\", f:parsenoop },\n    0x0117: { n:\"BrtEndStyleSheet\", f:parsenoop },\n    0x0118: { n:\"BrtBeginSXView\", f:parsenoop },\n    0x0119: { n:\"BrtEndSXVI\", f:parsenoop },\n    0x011A: { n:\"BrtBeginSXVI\", f:parsenoop },\n    0x011B: { n:\"BrtBeginSXVIs\", f:parsenoop },\n    0x011C: { n:\"BrtEndSXVIs\", f:parsenoop },\n    0x011D: { n:\"BrtBeginSXVD\", f:parsenoop },\n    0x011E: { n:\"BrtEndSXVD\", f:parsenoop },\n    0x011F: { n:\"BrtBeginSXVDs\", f:parsenoop },\n    0x0120: { n:\"BrtEndSXVDs\", f:parsenoop },\n    0x0121: { n:\"BrtBeginSXPI\", f:parsenoop },\n    0x0122: { n:\"BrtEndSXPI\", f:parsenoop },\n    0x0123: { n:\"BrtBeginSXPIs\", f:parsenoop },\n    0x0124: { n:\"BrtEndSXPIs\", f:parsenoop },\n    0x0125: { n:\"BrtBeginSXDI\", f:parsenoop },\n    0x0126: { n:\"BrtEndSXDI\", f:parsenoop },\n    0x0127: { n:\"BrtBeginSXDIs\", f:parsenoop },\n    0x0128: { n:\"BrtEndSXDIs\", f:parsenoop },\n    0x0129: { n:\"BrtBeginSXLI\", f:parsenoop },\n    0x012A: { n:\"BrtEndSXLI\", f:parsenoop },\n    0x012B: { n:\"BrtBeginSXLIRws\", f:parsenoop },\n    0x012C: { n:\"BrtEndSXLIRws\", f:parsenoop },\n    0x012D: { n:\"BrtBeginSXLICols\", f:parsenoop },\n    0x012E: { n:\"BrtEndSXLICols\", f:parsenoop },\n    0x012F: { n:\"BrtBeginSXFormat\", f:parsenoop },\n    0x0130: { n:\"BrtEndSXFormat\", f:parsenoop },\n    0x0131: { n:\"BrtBeginSXFormats\", f:parsenoop },\n    0x0132: { n:\"BrtEndSxFormats\", f:parsenoop },\n    0x0133: { n:\"BrtBeginSxSelect\", f:parsenoop },\n    0x0134: { n:\"BrtEndSxSelect\", f:parsenoop },\n    0x0135: { n:\"BrtBeginISXVDRws\", f:parsenoop },\n    0x0136: { n:\"BrtEndISXVDRws\", f:parsenoop },\n    0x0137: { n:\"BrtBeginISXVDCols\", f:parsenoop },\n    0x0138: { n:\"BrtEndISXVDCols\", f:parsenoop },\n    0x0139: { n:\"BrtEndSXLocation\", f:parsenoop },\n    0x013A: { n:\"BrtBeginSXLocation\", f:parsenoop },\n    0x013B: { n:\"BrtEndSXView\", f:parsenoop },\n    0x013C: { n:\"BrtBeginSXTHs\", f:parsenoop },\n    0x013D: { n:\"BrtEndSXTHs\", f:parsenoop },\n    0x013E: { n:\"BrtBeginSXTH\", f:parsenoop },\n    0x013F: { n:\"BrtEndSXTH\", f:parsenoop },\n    0x0140: { n:\"BrtBeginISXTHRws\", f:parsenoop },\n    0x0141: { n:\"BrtEndISXTHRws\", f:parsenoop },\n    0x0142: { n:\"BrtBeginISXTHCols\", f:parsenoop },\n    0x0143: { n:\"BrtEndISXTHCols\", f:parsenoop },\n    0x0144: { n:\"BrtBeginSXTDMPS\", f:parsenoop },\n    0x0145: { n:\"BrtEndSXTDMPs\", f:parsenoop },\n    0x0146: { n:\"BrtBeginSXTDMP\", f:parsenoop },\n    0x0147: { n:\"BrtEndSXTDMP\", f:parsenoop },\n    0x0148: { n:\"BrtBeginSXTHItems\", f:parsenoop },\n    0x0149: { n:\"BrtEndSXTHItems\", f:parsenoop },\n    0x014A: { n:\"BrtBeginSXTHItem\", f:parsenoop },\n    0x014B: { n:\"BrtEndSXTHItem\", f:parsenoop },\n    0x014C: { n:\"BrtBeginMetadata\", f:parsenoop },\n    0x014D: { n:\"BrtEndMetadata\", f:parsenoop },\n    0x014E: { n:\"BrtBeginEsmdtinfo\", f:parsenoop },\n    0x014F: { n:\"BrtMdtinfo\", f:parsenoop },\n    0x0150: { n:\"BrtEndEsmdtinfo\", f:parsenoop },\n    0x0151: { n:\"BrtBeginEsmdb\", f:parsenoop },\n    0x0152: { n:\"BrtEndEsmdb\", f:parsenoop },\n    0x0153: { n:\"BrtBeginEsfmd\", f:parsenoop },\n    0x0154: { n:\"BrtEndEsfmd\", f:parsenoop },\n    0x0155: { n:\"BrtBeginSingleCells\", f:parsenoop },\n    0x0156: { n:\"BrtEndSingleCells\", f:parsenoop },\n    0x0157: { n:\"BrtBeginList\", f:parsenoop },\n    0x0158: { n:\"BrtEndList\", f:parsenoop },\n    0x0159: { n:\"BrtBeginListCols\", f:parsenoop },\n    0x015A: { n:\"BrtEndListCols\", f:parsenoop },\n    0x015B: { n:\"BrtBeginListCol\", f:parsenoop },\n    0x015C: { n:\"BrtEndListCol\", f:parsenoop },\n    0x015D: { n:\"BrtBeginListXmlCPr\", f:parsenoop },\n    0x015E: { n:\"BrtEndListXmlCPr\", f:parsenoop },\n    0x015F: { n:\"BrtListCCFmla\", f:parsenoop },\n    0x0160: { n:\"BrtListTrFmla\", f:parsenoop },\n    0x0161: { n:\"BrtBeginExternals\", f:parsenoop },\n    0x0162: { n:\"BrtEndExternals\", f:parsenoop },\n    0x0163: { n:\"BrtSupBookSrc\", f:parsenoop },\n    0x0165: { n:\"BrtSupSelf\", f:parsenoop },\n    0x0166: { n:\"BrtSupSame\", f:parsenoop },\n    0x0167: { n:\"BrtSupTabs\", f:parsenoop },\n    0x0168: { n:\"BrtBeginSupBook\", f:parsenoop },\n    0x0169: { n:\"BrtPlaceholderName\", f:parsenoop },\n    0x016A: { n:\"BrtExternSheet\", f:parsenoop },\n    0x016B: { n:\"BrtExternTableStart\", f:parsenoop },\n    0x016C: { n:\"BrtExternTableEnd\", f:parsenoop },\n    0x016E: { n:\"BrtExternRowHdr\", f:parsenoop },\n    0x016F: { n:\"BrtExternCellBlank\", f:parsenoop },\n    0x0170: { n:\"BrtExternCellReal\", f:parsenoop },\n    0x0171: { n:\"BrtExternCellBool\", f:parsenoop },\n    0x0172: { n:\"BrtExternCellError\", f:parsenoop },\n    0x0173: { n:\"BrtExternCellString\", f:parsenoop },\n    0x0174: { n:\"BrtBeginEsmdx\", f:parsenoop },\n    0x0175: { n:\"BrtEndEsmdx\", f:parsenoop },\n    0x0176: { n:\"BrtBeginMdxSet\", f:parsenoop },\n    0x0177: { n:\"BrtEndMdxSet\", f:parsenoop },\n    0x0178: { n:\"BrtBeginMdxMbrProp\", f:parsenoop },\n    0x0179: { n:\"BrtEndMdxMbrProp\", f:parsenoop },\n    0x017A: { n:\"BrtBeginMdxKPI\", f:parsenoop },\n    0x017B: { n:\"BrtEndMdxKPI\", f:parsenoop },\n    0x017C: { n:\"BrtBeginEsstr\", f:parsenoop },\n    0x017D: { n:\"BrtEndEsstr\", f:parsenoop },\n    0x017E: { n:\"BrtBeginPRFItem\", f:parsenoop },\n    0x017F: { n:\"BrtEndPRFItem\", f:parsenoop },\n    0x0180: { n:\"BrtBeginPivotCacheIDs\", f:parsenoop },\n    0x0181: { n:\"BrtEndPivotCacheIDs\", f:parsenoop },\n    0x0182: { n:\"BrtBeginPivotCacheID\", f:parsenoop },\n    0x0183: { n:\"BrtEndPivotCacheID\", f:parsenoop },\n    0x0184: { n:\"BrtBeginISXVIs\", f:parsenoop },\n    0x0185: { n:\"BrtEndISXVIs\", f:parsenoop },\n    0x0186: { n:\"BrtBeginColInfos\", f:parsenoop },\n    0x0187: { n:\"BrtEndColInfos\", f:parsenoop },\n    0x0188: { n:\"BrtBeginRwBrk\", f:parsenoop },\n    0x0189: { n:\"BrtEndRwBrk\", f:parsenoop },\n    0x018A: { n:\"BrtBeginColBrk\", f:parsenoop },\n    0x018B: { n:\"BrtEndColBrk\", f:parsenoop },\n    0x018C: { n:\"BrtBrk\", f:parsenoop },\n    0x018D: { n:\"BrtUserBookView\", f:parsenoop },\n    0x018E: { n:\"BrtInfo\", f:parsenoop },\n    0x018F: { n:\"BrtCUsr\", f:parsenoop },\n    0x0190: { n:\"BrtUsr\", f:parsenoop },\n    0x0191: { n:\"BrtBeginUsers\", f:parsenoop },\n    0x0193: { n:\"BrtEOF\", f:parsenoop },\n    0x0194: { n:\"BrtUCR\", f:parsenoop },\n    0x0195: { n:\"BrtRRInsDel\", f:parsenoop },\n    0x0196: { n:\"BrtRREndInsDel\", f:parsenoop },\n    0x0197: { n:\"BrtRRMove\", f:parsenoop },\n    0x0198: { n:\"BrtRREndMove\", f:parsenoop },\n    0x0199: { n:\"BrtRRChgCell\", f:parsenoop },\n    0x019A: { n:\"BrtRREndChgCell\", f:parsenoop },\n    0x019B: { n:\"BrtRRHeader\", f:parsenoop },\n    0x019C: { n:\"BrtRRUserView\", f:parsenoop },\n    0x019D: { n:\"BrtRRRenSheet\", f:parsenoop },\n    0x019E: { n:\"BrtRRInsertSh\", f:parsenoop },\n    0x019F: { n:\"BrtRRDefName\", f:parsenoop },\n    0x01A0: { n:\"BrtRRNote\", f:parsenoop },\n    0x01A1: { n:\"BrtRRConflict\", f:parsenoop },\n    0x01A2: { n:\"BrtRRTQSIF\", f:parsenoop },\n    0x01A3: { n:\"BrtRRFormat\", f:parsenoop },\n    0x01A4: { n:\"BrtRREndFormat\", f:parsenoop },\n    0x01A5: { n:\"BrtRRAutoFmt\", f:parsenoop },\n    0x01A6: { n:\"BrtBeginUserShViews\", f:parsenoop },\n    0x01A7: { n:\"BrtBeginUserShView\", f:parsenoop },\n    0x01A8: { n:\"BrtEndUserShView\", f:parsenoop },\n    0x01A9: { n:\"BrtEndUserShViews\", f:parsenoop },\n    0x01AA: { n:\"BrtArrFmla\", f:parsenoop },\n    0x01AB: { n:\"BrtShrFmla\", f:parsenoop },\n    0x01AC: { n:\"BrtTable\", f:parsenoop },\n    0x01AD: { n:\"BrtBeginExtConnections\", f:parsenoop },\n    0x01AE: { n:\"BrtEndExtConnections\", f:parsenoop },\n    0x01AF: { n:\"BrtBeginPCDCalcMems\", f:parsenoop },\n    0x01B0: { n:\"BrtEndPCDCalcMems\", f:parsenoop },\n    0x01B1: { n:\"BrtBeginPCDCalcMem\", f:parsenoop },\n    0x01B2: { n:\"BrtEndPCDCalcMem\", f:parsenoop },\n    0x01B3: { n:\"BrtBeginPCDHGLevels\", f:parsenoop },\n    0x01B4: { n:\"BrtEndPCDHGLevels\", f:parsenoop },\n    0x01B5: { n:\"BrtBeginPCDHGLevel\", f:parsenoop },\n    0x01B6: { n:\"BrtEndPCDHGLevel\", f:parsenoop },\n    0x01B7: { n:\"BrtBeginPCDHGLGroups\", f:parsenoop },\n    0x01B8: { n:\"BrtEndPCDHGLGroups\", f:parsenoop },\n    0x01B9: { n:\"BrtBeginPCDHGLGroup\", f:parsenoop },\n    0x01BA: { n:\"BrtEndPCDHGLGroup\", f:parsenoop },\n    0x01BB: { n:\"BrtBeginPCDHGLGMembers\", f:parsenoop },\n    0x01BC: { n:\"BrtEndPCDHGLGMembers\", f:parsenoop },\n    0x01BD: { n:\"BrtBeginPCDHGLGMember\", f:parsenoop },\n    0x01BE: { n:\"BrtEndPCDHGLGMember\", f:parsenoop },\n    0x01BF: { n:\"BrtBeginQSI\", f:parsenoop },\n    0x01C0: { n:\"BrtEndQSI\", f:parsenoop },\n    0x01C1: { n:\"BrtBeginQSIR\", f:parsenoop },\n    0x01C2: { n:\"BrtEndQSIR\", f:parsenoop },\n    0x01C3: { n:\"BrtBeginDeletedNames\", f:parsenoop },\n    0x01C4: { n:\"BrtEndDeletedNames\", f:parsenoop },\n    0x01C5: { n:\"BrtBeginDeletedName\", f:parsenoop },\n    0x01C6: { n:\"BrtEndDeletedName\", f:parsenoop },\n    0x01C7: { n:\"BrtBeginQSIFs\", f:parsenoop },\n    0x01C8: { n:\"BrtEndQSIFs\", f:parsenoop },\n    0x01C9: { n:\"BrtBeginQSIF\", f:parsenoop },\n    0x01CA: { n:\"BrtEndQSIF\", f:parsenoop },\n    0x01CB: { n:\"BrtBeginAutoSortScope\", f:parsenoop },\n    0x01CC: { n:\"BrtEndAutoSortScope\", f:parsenoop },\n    0x01CD: { n:\"BrtBeginConditionalFormatting\", f:parsenoop },\n    0x01CE: { n:\"BrtEndConditionalFormatting\", f:parsenoop },\n    0x01CF: { n:\"BrtBeginCFRule\", f:parsenoop },\n    0x01D0: { n:\"BrtEndCFRule\", f:parsenoop },\n    0x01D1: { n:\"BrtBeginIconSet\", f:parsenoop },\n    0x01D2: { n:\"BrtEndIconSet\", f:parsenoop },\n    0x01D3: { n:\"BrtBeginDatabar\", f:parsenoop },\n    0x01D4: { n:\"BrtEndDatabar\", f:parsenoop },\n    0x01D5: { n:\"BrtBeginColorScale\", f:parsenoop },\n    0x01D6: { n:\"BrtEndColorScale\", f:parsenoop },\n    0x01D7: { n:\"BrtCFVO\", f:parsenoop },\n    0x01D8: { n:\"BrtExternValueMeta\", f:parsenoop },\n    0x01D9: { n:\"BrtBeginColorPalette\", f:parsenoop },\n    0x01DA: { n:\"BrtEndColorPalette\", f:parsenoop },\n    0x01DB: { n:\"BrtIndexedColor\", f:parsenoop },\n    0x01DC: { n:\"BrtMargins\", f:parsenoop },\n    0x01DD: { n:\"BrtPrintOptions\", f:parsenoop },\n    0x01DE: { n:\"BrtPageSetup\", f:parsenoop },\n    0x01DF: { n:\"BrtBeginHeaderFooter\", f:parsenoop },\n    0x01E0: { n:\"BrtEndHeaderFooter\", f:parsenoop },\n    0x01E1: { n:\"BrtBeginSXCrtFormat\", f:parsenoop },\n    0x01E2: { n:\"BrtEndSXCrtFormat\", f:parsenoop },\n    0x01E3: { n:\"BrtBeginSXCrtFormats\", f:parsenoop },\n    0x01E4: { n:\"BrtEndSXCrtFormats\", f:parsenoop },\n    0x01E5: { n:\"BrtWsFmtInfo\", f:parsenoop },\n    0x01E6: { n:\"BrtBeginMgs\", f:parsenoop },\n    0x01E7: { n:\"BrtEndMGs\", f:parsenoop },\n    0x01E8: { n:\"BrtBeginMGMaps\", f:parsenoop },\n    0x01E9: { n:\"BrtEndMGMaps\", f:parsenoop },\n    0x01EA: { n:\"BrtBeginMG\", f:parsenoop },\n    0x01EB: { n:\"BrtEndMG\", f:parsenoop },\n    0x01EC: { n:\"BrtBeginMap\", f:parsenoop },\n    0x01ED: { n:\"BrtEndMap\", f:parsenoop },\n    0x01EE: { n:\"BrtHLink\", f:parse_BrtHLink },\n    0x01EF: { n:\"BrtBeginDCon\", f:parsenoop },\n    0x01F0: { n:\"BrtEndDCon\", f:parsenoop },\n    0x01F1: { n:\"BrtBeginDRefs\", f:parsenoop },\n    0x01F2: { n:\"BrtEndDRefs\", f:parsenoop },\n    0x01F3: { n:\"BrtDRef\", f:parsenoop },\n    0x01F4: { n:\"BrtBeginScenMan\", f:parsenoop },\n    0x01F5: { n:\"BrtEndScenMan\", f:parsenoop },\n    0x01F6: { n:\"BrtBeginSct\", f:parsenoop },\n    0x01F7: { n:\"BrtEndSct\", f:parsenoop },\n    0x01F8: { n:\"BrtSlc\", f:parsenoop },\n    0x01F9: { n:\"BrtBeginDXFs\", f:parsenoop },\n    0x01FA: { n:\"BrtEndDXFs\", f:parsenoop },\n    0x01FB: { n:\"BrtDXF\", f:parsenoop },\n    0x01FC: { n:\"BrtBeginTableStyles\", f:parsenoop },\n    0x01FD: { n:\"BrtEndTableStyles\", f:parsenoop },\n    0x01FE: { n:\"BrtBeginTableStyle\", f:parsenoop },\n    0x01FF: { n:\"BrtEndTableStyle\", f:parsenoop },\n    0x0200: { n:\"BrtTableStyleElement\", f:parsenoop },\n    0x0201: { n:\"BrtTableStyleClient\", f:parsenoop },\n    0x0202: { n:\"BrtBeginVolDeps\", f:parsenoop },\n    0x0203: { n:\"BrtEndVolDeps\", f:parsenoop },\n    0x0204: { n:\"BrtBeginVolType\", f:parsenoop },\n    0x0205: { n:\"BrtEndVolType\", f:parsenoop },\n    0x0206: { n:\"BrtBeginVolMain\", f:parsenoop },\n    0x0207: { n:\"BrtEndVolMain\", f:parsenoop },\n    0x0208: { n:\"BrtBeginVolTopic\", f:parsenoop },\n    0x0209: { n:\"BrtEndVolTopic\", f:parsenoop },\n    0x020A: { n:\"BrtVolSubtopic\", f:parsenoop },\n    0x020B: { n:\"BrtVolRef\", f:parsenoop },\n    0x020C: { n:\"BrtVolNum\", f:parsenoop },\n    0x020D: { n:\"BrtVolErr\", f:parsenoop },\n    0x020E: { n:\"BrtVolStr\", f:parsenoop },\n    0x020F: { n:\"BrtVolBool\", f:parsenoop },\n    0x0210: { n:\"BrtBeginCalcChain$\", f:parsenoop },\n    0x0211: { n:\"BrtEndCalcChain$\", f:parsenoop },\n    0x0212: { n:\"BrtBeginSortState\", f:parsenoop },\n    0x0213: { n:\"BrtEndSortState\", f:parsenoop },\n    0x0214: { n:\"BrtBeginSortCond\", f:parsenoop },\n    0x0215: { n:\"BrtEndSortCond\", f:parsenoop },\n    0x0216: { n:\"BrtBookProtection\", f:parsenoop },\n    0x0217: { n:\"BrtSheetProtection\", f:parsenoop },\n    0x0218: { n:\"BrtRangeProtection\", f:parsenoop },\n    0x0219: { n:\"BrtPhoneticInfo\", f:parsenoop },\n    0x021A: { n:\"BrtBeginECTxtWiz\", f:parsenoop },\n    0x021B: { n:\"BrtEndECTxtWiz\", f:parsenoop },\n    0x021C: { n:\"BrtBeginECTWFldInfoLst\", f:parsenoop },\n    0x021D: { n:\"BrtEndECTWFldInfoLst\", f:parsenoop },\n    0x021E: { n:\"BrtBeginECTwFldInfo\", f:parsenoop },\n    0x0224: { n:\"BrtFileSharing\", f:parsenoop },\n    0x0225: { n:\"BrtOleSize\", f:parsenoop },\n    0x0226: { n:\"BrtDrawing\", f:parsenoop },\n    0x0227: { n:\"BrtLegacyDrawing\", f:parsenoop },\n    0x0228: { n:\"BrtLegacyDrawingHF\", f:parsenoop },\n    0x0229: { n:\"BrtWebOpt\", f:parsenoop },\n    0x022A: { n:\"BrtBeginWebPubItems\", f:parsenoop },\n    0x022B: { n:\"BrtEndWebPubItems\", f:parsenoop },\n    0x022C: { n:\"BrtBeginWebPubItem\", f:parsenoop },\n    0x022D: { n:\"BrtEndWebPubItem\", f:parsenoop },\n    0x022E: { n:\"BrtBeginSXCondFmt\", f:parsenoop },\n    0x022F: { n:\"BrtEndSXCondFmt\", f:parsenoop },\n    0x0230: { n:\"BrtBeginSXCondFmts\", f:parsenoop },\n    0x0231: { n:\"BrtEndSXCondFmts\", f:parsenoop },\n    0x0232: { n:\"BrtBkHim\", f:parsenoop },\n    0x0234: { n:\"BrtColor\", f:parsenoop },\n    0x0235: { n:\"BrtBeginIndexedColors\", f:parsenoop },\n    0x0236: { n:\"BrtEndIndexedColors\", f:parsenoop },\n    0x0239: { n:\"BrtBeginMRUColors\", f:parsenoop },\n    0x023A: { n:\"BrtEndMRUColors\", f:parsenoop },\n    0x023C: { n:\"BrtMRUColor\", f:parsenoop },\n    0x023D: { n:\"BrtBeginDVals\", f:parsenoop },\n    0x023E: { n:\"BrtEndDVals\", f:parsenoop },\n    0x0241: { n:\"BrtSupNameStart\", f:parsenoop },\n    0x0242: { n:\"BrtSupNameValueStart\", f:parsenoop },\n    0x0243: { n:\"BrtSupNameValueEnd\", f:parsenoop },\n    0x0244: { n:\"BrtSupNameNum\", f:parsenoop },\n    0x0245: { n:\"BrtSupNameErr\", f:parsenoop },\n    0x0246: { n:\"BrtSupNameSt\", f:parsenoop },\n    0x0247: { n:\"BrtSupNameNil\", f:parsenoop },\n    0x0248: { n:\"BrtSupNameBool\", f:parsenoop },\n    0x0249: { n:\"BrtSupNameFmla\", f:parsenoop },\n    0x024A: { n:\"BrtSupNameBits\", f:parsenoop },\n    0x024B: { n:\"BrtSupNameEnd\", f:parsenoop },\n    0x024C: { n:\"BrtEndSupBook\", f:parsenoop },\n    0x024D: { n:\"BrtCellSmartTagProperty\", f:parsenoop },\n    0x024E: { n:\"BrtBeginCellSmartTag\", f:parsenoop },\n    0x024F: { n:\"BrtEndCellSmartTag\", f:parsenoop },\n    0x0250: { n:\"BrtBeginCellSmartTags\", f:parsenoop },\n    0x0251: { n:\"BrtEndCellSmartTags\", f:parsenoop },\n    0x0252: { n:\"BrtBeginSmartTags\", f:parsenoop },\n    0x0253: { n:\"BrtEndSmartTags\", f:parsenoop },\n    0x0254: { n:\"BrtSmartTagType\", f:parsenoop },\n    0x0255: { n:\"BrtBeginSmartTagTypes\", f:parsenoop },\n    0x0256: { n:\"BrtEndSmartTagTypes\", f:parsenoop },\n    0x0257: { n:\"BrtBeginSXFilters\", f:parsenoop },\n    0x0258: { n:\"BrtEndSXFilters\", f:parsenoop },\n    0x0259: { n:\"BrtBeginSXFILTER\", f:parsenoop },\n    0x025A: { n:\"BrtEndSXFilter\", f:parsenoop },\n    0x025B: { n:\"BrtBeginFills\", f:parsenoop },\n    0x025C: { n:\"BrtEndFills\", f:parsenoop },\n    0x025D: { n:\"BrtBeginCellWatches\", f:parsenoop },\n    0x025E: { n:\"BrtEndCellWatches\", f:parsenoop },\n    0x025F: { n:\"BrtCellWatch\", f:parsenoop },\n    0x0260: { n:\"BrtBeginCRErrs\", f:parsenoop },\n    0x0261: { n:\"BrtEndCRErrs\", f:parsenoop },\n    0x0262: { n:\"BrtCrashRecErr\", f:parsenoop },\n    0x0263: { n:\"BrtBeginFonts\", f:parsenoop },\n    0x0264: { n:\"BrtEndFonts\", f:parsenoop },\n    0x0265: { n:\"BrtBeginBorders\", f:parsenoop },\n    0x0266: { n:\"BrtEndBorders\", f:parsenoop },\n    0x0267: { n:\"BrtBeginFmts\", f:parsenoop },\n    0x0268: { n:\"BrtEndFmts\", f:parsenoop },\n    0x0269: { n:\"BrtBeginCellXFs\", f:parsenoop },\n    0x026A: { n:\"BrtEndCellXFs\", f:parsenoop },\n    0x026B: { n:\"BrtBeginStyles\", f:parsenoop },\n    0x026C: { n:\"BrtEndStyles\", f:parsenoop },\n    0x0271: { n:\"BrtBigName\", f:parsenoop },\n    0x0272: { n:\"BrtBeginCellStyleXFs\", f:parsenoop },\n    0x0273: { n:\"BrtEndCellStyleXFs\", f:parsenoop },\n    0x0274: { n:\"BrtBeginComments\", f:parsenoop },\n    0x0275: { n:\"BrtEndComments\", f:parsenoop },\n    0x0276: { n:\"BrtBeginCommentAuthors\", f:parsenoop },\n    0x0277: { n:\"BrtEndCommentAuthors\", f:parsenoop },\n    0x0278: { n:\"BrtCommentAuthor\", f:parse_BrtCommentAuthor },\n    0x0279: { n:\"BrtBeginCommentList\", f:parsenoop },\n    0x027A: { n:\"BrtEndCommentList\", f:parsenoop },\n    0x027B: { n:\"BrtBeginComment\", f:parse_BrtBeginComment},\n    0x027C: { n:\"BrtEndComment\", f:parsenoop },\n    0x027D: { n:\"BrtCommentText\", f:parse_BrtCommentText },\n    0x027E: { n:\"BrtBeginOleObjects\", f:parsenoop },\n    0x027F: { n:\"BrtOleObject\", f:parsenoop },\n    0x0280: { n:\"BrtEndOleObjects\", f:parsenoop },\n    0x0281: { n:\"BrtBeginSxrules\", f:parsenoop },\n    0x0282: { n:\"BrtEndSxRules\", f:parsenoop },\n    0x0283: { n:\"BrtBeginActiveXControls\", f:parsenoop },\n    0x0284: { n:\"BrtActiveX\", f:parsenoop },\n    0x0285: { n:\"BrtEndActiveXControls\", f:parsenoop },\n    0x0286: { n:\"BrtBeginPCDSDTCEMembersSortBy\", f:parsenoop },\n    0x0288: { n:\"BrtBeginCellIgnoreECs\", f:parsenoop },\n    0x0289: { n:\"BrtCellIgnoreEC\", f:parsenoop },\n    0x028A: { n:\"BrtEndCellIgnoreECs\", f:parsenoop },\n    0x028B: { n:\"BrtCsProp\", f:parsenoop },\n    0x028C: { n:\"BrtCsPageSetup\", f:parsenoop },\n    0x028D: { n:\"BrtBeginUserCsViews\", f:parsenoop },\n    0x028E: { n:\"BrtEndUserCsViews\", f:parsenoop },\n    0x028F: { n:\"BrtBeginUserCsView\", f:parsenoop },\n    0x0290: { n:\"BrtEndUserCsView\", f:parsenoop },\n    0x0291: { n:\"BrtBeginPcdSFCIEntries\", f:parsenoop },\n    0x0292: { n:\"BrtEndPCDSFCIEntries\", f:parsenoop },\n    0x0293: { n:\"BrtPCDSFCIEntry\", f:parsenoop },\n    0x0294: { n:\"BrtBeginListParts\", f:parsenoop },\n    0x0295: { n:\"BrtListPart\", f:parsenoop },\n    0x0296: { n:\"BrtEndListParts\", f:parsenoop },\n    0x0297: { n:\"BrtSheetCalcProp\", f:parsenoop },\n    0x0298: { n:\"BrtBeginFnGroup\", f:parsenoop },\n    0x0299: { n:\"BrtFnGroup\", f:parsenoop },\n    0x029A: { n:\"BrtEndFnGroup\", f:parsenoop },\n    0x029B: { n:\"BrtSupAddin\", f:parsenoop },\n    0x029C: { n:\"BrtSXTDMPOrder\", f:parsenoop },\n    0x029D: { n:\"BrtCsProtection\", f:parsenoop },\n    0x029F: { n:\"BrtBeginWsSortMap\", f:parsenoop },\n    0x02A0: { n:\"BrtEndWsSortMap\", f:parsenoop },\n    0x02A1: { n:\"BrtBeginRRSort\", f:parsenoop },\n    0x02A2: { n:\"BrtEndRRSort\", f:parsenoop },\n    0x02A3: { n:\"BrtRRSortItem\", f:parsenoop },\n    0x02A4: { n:\"BrtFileSharingIso\", f:parsenoop },\n    0x02A5: { n:\"BrtBookProtectionIso\", f:parsenoop },\n    0x02A6: { n:\"BrtSheetProtectionIso\", f:parsenoop },\n    0x02A7: { n:\"BrtCsProtectionIso\", f:parsenoop },\n    0x02A8: { n:\"BrtRangeProtectionIso\", f:parsenoop },\n    0x0400: { n:\"BrtRwDescent\", f:parsenoop },\n    0x0401: { n:\"BrtKnownFonts\", f:parsenoop },\n    0x0402: { n:\"BrtBeginSXTupleSet\", f:parsenoop },\n    0x0403: { n:\"BrtEndSXTupleSet\", f:parsenoop },\n    0x0404: { n:\"BrtBeginSXTupleSetHeader\", f:parsenoop },\n    0x0405: { n:\"BrtEndSXTupleSetHeader\", f:parsenoop },\n    0x0406: { n:\"BrtSXTupleSetHeaderItem\", f:parsenoop },\n    0x0407: { n:\"BrtBeginSXTupleSetData\", f:parsenoop },\n    0x0408: { n:\"BrtEndSXTupleSetData\", f:parsenoop },\n    0x0409: { n:\"BrtBeginSXTupleSetRow\", f:parsenoop },\n    0x040A: { n:\"BrtEndSXTupleSetRow\", f:parsenoop },\n    0x040B: { n:\"BrtSXTupleSetRowItem\", f:parsenoop },\n    0x040C: { n:\"BrtNameExt\", f:parsenoop },\n    0x040D: { n:\"BrtPCDH14\", f:parsenoop },\n    0x040E: { n:\"BrtBeginPCDCalcMem14\", f:parsenoop },\n    0x040F: { n:\"BrtEndPCDCalcMem14\", f:parsenoop },\n    0x0410: { n:\"BrtSXTH14\", f:parsenoop },\n    0x0411: { n:\"BrtBeginSparklineGroup\", f:parsenoop },\n    0x0412: { n:\"BrtEndSparklineGroup\", f:parsenoop },\n    0x0413: { n:\"BrtSparkline\", f:parsenoop },\n    0x0414: { n:\"BrtSXDI14\", f:parsenoop },\n    0x0415: { n:\"BrtWsFmtInfoEx14\", f:parsenoop },\n    0x0416: { n:\"BrtBeginConditionalFormatting14\", f:parsenoop },\n    0x0417: { n:\"BrtEndConditionalFormatting14\", f:parsenoop },\n    0x0418: { n:\"BrtBeginCFRule14\", f:parsenoop },\n    0x0419: { n:\"BrtEndCFRule14\", f:parsenoop },\n    0x041A: { n:\"BrtCFVO14\", f:parsenoop },\n    0x041B: { n:\"BrtBeginDatabar14\", f:parsenoop },\n    0x041C: { n:\"BrtBeginIconSet14\", f:parsenoop },\n    0x041D: { n:\"BrtDVal14\", f:parsenoop },\n    0x041E: { n:\"BrtBeginDVals14\", f:parsenoop },\n    0x041F: { n:\"BrtColor14\", f:parsenoop },\n    0x0420: { n:\"BrtBeginSparklines\", f:parsenoop },\n    0x0421: { n:\"BrtEndSparklines\", f:parsenoop },\n    0x0422: { n:\"BrtBeginSparklineGroups\", f:parsenoop },\n    0x0423: { n:\"BrtEndSparklineGroups\", f:parsenoop },\n    0x0425: { n:\"BrtSXVD14\", f:parsenoop },\n    0x0426: { n:\"BrtBeginSxview14\", f:parsenoop },\n    0x0427: { n:\"BrtEndSxview14\", f:parsenoop },\n    0x042A: { n:\"BrtBeginPCD14\", f:parsenoop },\n    0x042B: { n:\"BrtEndPCD14\", f:parsenoop },\n    0x042C: { n:\"BrtBeginExtConn14\", f:parsenoop },\n    0x042D: { n:\"BrtEndExtConn14\", f:parsenoop },\n    0x042E: { n:\"BrtBeginSlicerCacheIDs\", f:parsenoop },\n    0x042F: { n:\"BrtEndSlicerCacheIDs\", f:parsenoop },\n    0x0430: { n:\"BrtBeginSlicerCacheID\", f:parsenoop },\n    0x0431: { n:\"BrtEndSlicerCacheID\", f:parsenoop },\n    0x0433: { n:\"BrtBeginSlicerCache\", f:parsenoop },\n    0x0434: { n:\"BrtEndSlicerCache\", f:parsenoop },\n    0x0435: { n:\"BrtBeginSlicerCacheDef\", f:parsenoop },\n    0x0436: { n:\"BrtEndSlicerCacheDef\", f:parsenoop },\n    0x0437: { n:\"BrtBeginSlicersEx\", f:parsenoop },\n    0x0438: { n:\"BrtEndSlicersEx\", f:parsenoop },\n    0x0439: { n:\"BrtBeginSlicerEx\", f:parsenoop },\n    0x043A: { n:\"BrtEndSlicerEx\", f:parsenoop },\n    0x043B: { n:\"BrtBeginSlicer\", f:parsenoop },\n    0x043C: { n:\"BrtEndSlicer\", f:parsenoop },\n    0x043D: { n:\"BrtSlicerCachePivotTables\", f:parsenoop },\n    0x043E: { n:\"BrtBeginSlicerCacheOlapImpl\", f:parsenoop },\n    0x043F: { n:\"BrtEndSlicerCacheOlapImpl\", f:parsenoop },\n    0x0440: { n:\"BrtBeginSlicerCacheLevelsData\", f:parsenoop },\n    0x0441: { n:\"BrtEndSlicerCacheLevelsData\", f:parsenoop },\n    0x0442: { n:\"BrtBeginSlicerCacheLevelData\", f:parsenoop },\n    0x0443: { n:\"BrtEndSlicerCacheLevelData\", f:parsenoop },\n    0x0444: { n:\"BrtBeginSlicerCacheSiRanges\", f:parsenoop },\n    0x0445: { n:\"BrtEndSlicerCacheSiRanges\", f:parsenoop },\n    0x0446: { n:\"BrtBeginSlicerCacheSiRange\", f:parsenoop },\n    0x0447: { n:\"BrtEndSlicerCacheSiRange\", f:parsenoop },\n    0x0448: { n:\"BrtSlicerCacheOlapItem\", f:parsenoop },\n    0x0449: { n:\"BrtBeginSlicerCacheSelections\", f:parsenoop },\n    0x044A: { n:\"BrtSlicerCacheSelection\", f:parsenoop },\n    0x044B: { n:\"BrtEndSlicerCacheSelections\", f:parsenoop },\n    0x044C: { n:\"BrtBeginSlicerCacheNative\", f:parsenoop },\n    0x044D: { n:\"BrtEndSlicerCacheNative\", f:parsenoop },\n    0x044E: { n:\"BrtSlicerCacheNativeItem\", f:parsenoop },\n    0x044F: { n:\"BrtRangeProtection14\", f:parsenoop },\n    0x0450: { n:\"BrtRangeProtectionIso14\", f:parsenoop },\n    0x0451: { n:\"BrtCellIgnoreEC14\", f:parsenoop },\n    0x0457: { n:\"BrtList14\", f:parsenoop },\n    0x0458: { n:\"BrtCFIcon\", f:parsenoop },\n    0x0459: { n:\"BrtBeginSlicerCachesPivotCacheIDs\", f:parsenoop },\n    0x045A: { n:\"BrtEndSlicerCachesPivotCacheIDs\", f:parsenoop },\n    0x045B: { n:\"BrtBeginSlicers\", f:parsenoop },\n    0x045C: { n:\"BrtEndSlicers\", f:parsenoop },\n    0x045D: { n:\"BrtWbProp14\", f:parsenoop },\n    0x045E: { n:\"BrtBeginSXEdit\", f:parsenoop },\n    0x045F: { n:\"BrtEndSXEdit\", f:parsenoop },\n    0x0460: { n:\"BrtBeginSXEdits\", f:parsenoop },\n    0x0461: { n:\"BrtEndSXEdits\", f:parsenoop },\n    0x0462: { n:\"BrtBeginSXChange\", f:parsenoop },\n    0x0463: { n:\"BrtEndSXChange\", f:parsenoop },\n    0x0464: { n:\"BrtBeginSXChanges\", f:parsenoop },\n    0x0465: { n:\"BrtEndSXChanges\", f:parsenoop },\n    0x0466: { n:\"BrtSXTupleItems\", f:parsenoop },\n    0x0468: { n:\"BrtBeginSlicerStyle\", f:parsenoop },\n    0x0469: { n:\"BrtEndSlicerStyle\", f:parsenoop },\n    0x046A: { n:\"BrtSlicerStyleElement\", f:parsenoop },\n    0x046B: { n:\"BrtBeginStyleSheetExt14\", f:parsenoop },\n    0x046C: { n:\"BrtEndStyleSheetExt14\", f:parsenoop },\n    0x046D: { n:\"BrtBeginSlicerCachesPivotCacheID\", f:parsenoop },\n    0x046E: { n:\"BrtEndSlicerCachesPivotCacheID\", f:parsenoop },\n    0x046F: { n:\"BrtBeginConditionalFormattings\", f:parsenoop },\n    0x0470: { n:\"BrtEndConditionalFormattings\", f:parsenoop },\n    0x0471: { n:\"BrtBeginPCDCalcMemExt\", f:parsenoop },\n    0x0472: { n:\"BrtEndPCDCalcMemExt\", f:parsenoop },\n    0x0473: { n:\"BrtBeginPCDCalcMemsExt\", f:parsenoop },\n    0x0474: { n:\"BrtEndPCDCalcMemsExt\", f:parsenoop },\n    0x0475: { n:\"BrtPCDField14\", f:parsenoop },\n    0x0476: { n:\"BrtBeginSlicerStyles\", f:parsenoop },\n    0x0477: { n:\"BrtEndSlicerStyles\", f:parsenoop },\n    0x0478: { n:\"BrtBeginSlicerStyleElements\", f:parsenoop },\n    0x0479: { n:\"BrtEndSlicerStyleElements\", f:parsenoop },\n    0x047A: { n:\"BrtCFRuleExt\", f:parsenoop },\n    0x047B: { n:\"BrtBeginSXCondFmt14\", f:parsenoop },\n    0x047C: { n:\"BrtEndSXCondFmt14\", f:parsenoop },\n    0x047D: { n:\"BrtBeginSXCondFmts14\", f:parsenoop },\n    0x047E: { n:\"BrtEndSXCondFmts14\", f:parsenoop },\n    0x0480: { n:\"BrtBeginSortCond14\", f:parsenoop },\n    0x0481: { n:\"BrtEndSortCond14\", f:parsenoop },\n    0x0482: { n:\"BrtEndDVals14\", f:parsenoop },\n    0x0483: { n:\"BrtEndIconSet14\", f:parsenoop },\n    0x0484: { n:\"BrtEndDatabar14\", f:parsenoop },\n    0x0485: { n:\"BrtBeginColorScale14\", f:parsenoop },\n    0x0486: { n:\"BrtEndColorScale14\", f:parsenoop },\n    0x0487: { n:\"BrtBeginSxrules14\", f:parsenoop },\n    0x0488: { n:\"BrtEndSxrules14\", f:parsenoop },\n    0x0489: { n:\"BrtBeginPRule14\", f:parsenoop },\n    0x048A: { n:\"BrtEndPRule14\", f:parsenoop },\n    0x048B: { n:\"BrtBeginPRFilters14\", f:parsenoop },\n    0x048C: { n:\"BrtEndPRFilters14\", f:parsenoop },\n    0x048D: { n:\"BrtBeginPRFilter14\", f:parsenoop },\n    0x048E: { n:\"BrtEndPRFilter14\", f:parsenoop },\n    0x048F: { n:\"BrtBeginPRFItem14\", f:parsenoop },\n    0x0490: { n:\"BrtEndPRFItem14\", f:parsenoop },\n    0x0491: { n:\"BrtBeginCellIgnoreECs14\", f:parsenoop },\n    0x0492: { n:\"BrtEndCellIgnoreECs14\", f:parsenoop },\n    0x0493: { n:\"BrtDxf14\", f:parsenoop },\n    0x0494: { n:\"BrtBeginDxF14s\", f:parsenoop },\n    0x0495: { n:\"BrtEndDxf14s\", f:parsenoop },\n    0x0499: { n:\"BrtFilter14\", f:parsenoop },\n    0x049A: { n:\"BrtBeginCustomFilters14\", f:parsenoop },\n    0x049C: { n:\"BrtCustomFilter14\", f:parsenoop },\n    0x049D: { n:\"BrtIconFilter14\", f:parsenoop },\n    0x049E: { n:\"BrtPivotCacheConnectionName\", f:parsenoop },\n    0x0800: { n:\"BrtBeginDecoupledPivotCacheIDs\", f:parsenoop },\n    0x0801: { n:\"BrtEndDecoupledPivotCacheIDs\", f:parsenoop },\n    0x0802: { n:\"BrtDecoupledPivotCacheID\", f:parsenoop },\n    0x0803: { n:\"BrtBeginPivotTableRefs\", f:parsenoop },\n    0x0804: { n:\"BrtEndPivotTableRefs\", f:parsenoop },\n    0x0805: { n:\"BrtPivotTableRef\", f:parsenoop },\n    0x0806: { n:\"BrtSlicerCacheBookPivotTables\", f:parsenoop },\n    0x0807: { n:\"BrtBeginSxvcells\", f:parsenoop },\n    0x0808: { n:\"BrtEndSxvcells\", f:parsenoop },\n    0x0809: { n:\"BrtBeginSxRow\", f:parsenoop },\n    0x080A: { n:\"BrtEndSxRow\", f:parsenoop },\n    0x080C: { n:\"BrtPcdCalcMem15\", f:parsenoop },\n    0x0813: { n:\"BrtQsi15\", f:parsenoop },\n    0x0814: { n:\"BrtBeginWebExtensions\", f:parsenoop },\n    0x0815: { n:\"BrtEndWebExtensions\", f:parsenoop },\n    0x0816: { n:\"BrtWebExtension\", f:parsenoop },\n    0x0817: { n:\"BrtAbsPath15\", f:parsenoop },\n    0x0818: { n:\"BrtBeginPivotTableUISettings\", f:parsenoop },\n    0x0819: { n:\"BrtEndPivotTableUISettings\", f:parsenoop },\n    0x081B: { n:\"BrtTableSlicerCacheIDs\", f:parsenoop },\n    0x081C: { n:\"BrtTableSlicerCacheID\", f:parsenoop },\n    0x081D: { n:\"BrtBeginTableSlicerCache\", f:parsenoop },\n    0x081E: { n:\"BrtEndTableSlicerCache\", f:parsenoop },\n    0x081F: { n:\"BrtSxFilter15\", f:parsenoop },\n    0x0820: { n:\"BrtBeginTimelineCachePivotCacheIDs\", f:parsenoop },\n    0x0821: { n:\"BrtEndTimelineCachePivotCacheIDs\", f:parsenoop },\n    0x0822: { n:\"BrtTimelineCachePivotCacheID\", f:parsenoop },\n    0x0823: { n:\"BrtBeginTimelineCacheIDs\", f:parsenoop },\n    0x0824: { n:\"BrtEndTimelineCacheIDs\", f:parsenoop },\n    0x0825: { n:\"BrtBeginTimelineCacheID\", f:parsenoop },\n    0x0826: { n:\"BrtEndTimelineCacheID\", f:parsenoop },\n    0x0827: { n:\"BrtBeginTimelinesEx\", f:parsenoop },\n    0x0828: { n:\"BrtEndTimelinesEx\", f:parsenoop },\n    0x0829: { n:\"BrtBeginTimelineEx\", f:parsenoop },\n    0x082A: { n:\"BrtEndTimelineEx\", f:parsenoop },\n    0x082B: { n:\"BrtWorkBookPr15\", f:parsenoop },\n    0x082C: { n:\"BrtPCDH15\", f:parsenoop },\n    0x082D: { n:\"BrtBeginTimelineStyle\", f:parsenoop },\n    0x082E: { n:\"BrtEndTimelineStyle\", f:parsenoop },\n    0x082F: { n:\"BrtTimelineStyleElement\", f:parsenoop },\n    0x0830: { n:\"BrtBeginTimelineStylesheetExt15\", f:parsenoop },\n    0x0831: { n:\"BrtEndTimelineStylesheetExt15\", f:parsenoop },\n    0x0832: { n:\"BrtBeginTimelineStyles\", f:parsenoop },\n    0x0833: { n:\"BrtEndTimelineStyles\", f:parsenoop },\n    0x0834: { n:\"BrtBeginTimelineStyleElements\", f:parsenoop },\n    0x0835: { n:\"BrtEndTimelineStyleElements\", f:parsenoop },\n    0x0836: { n:\"BrtDxf15\", f:parsenoop },\n    0x0837: { n:\"BrtBeginDxfs15\", f:parsenoop },\n    0x0838: { n:\"brtEndDxfs15\", f:parsenoop },\n    0x0839: { n:\"BrtSlicerCacheHideItemsWithNoData\", f:parsenoop },\n    0x083A: { n:\"BrtBeginItemUniqueNames\", f:parsenoop },\n    0x083B: { n:\"BrtEndItemUniqueNames\", f:parsenoop },\n    0x083C: { n:\"BrtItemUniqueName\", f:parsenoop },\n    0x083D: { n:\"BrtBeginExtConn15\", f:parsenoop },\n    0x083E: { n:\"BrtEndExtConn15\", f:parsenoop },\n    0x083F: { n:\"BrtBeginOledbPr15\", f:parsenoop },\n    0x0840: { n:\"BrtEndOledbPr15\", f:parsenoop },\n    0x0841: { n:\"BrtBeginDataFeedPr15\", f:parsenoop },\n    0x0842: { n:\"BrtEndDataFeedPr15\", f:parsenoop },\n    0x0843: { n:\"BrtTextPr15\", f:parsenoop },\n    0x0844: { n:\"BrtRangePr15\", f:parsenoop },\n    0x0845: { n:\"BrtDbCommand15\", f:parsenoop },\n    0x0846: { n:\"BrtBeginDbTables15\", f:parsenoop },\n    0x0847: { n:\"BrtEndDbTables15\", f:parsenoop },\n    0x0848: { n:\"BrtDbTable15\", f:parsenoop },\n    0x0849: { n:\"BrtBeginDataModel\", f:parsenoop },\n    0x084A: { n:\"BrtEndDataModel\", f:parsenoop },\n    0x084B: { n:\"BrtBeginModelTables\", f:parsenoop },\n    0x084C: { n:\"BrtEndModelTables\", f:parsenoop },\n    0x084D: { n:\"BrtModelTable\", f:parsenoop },\n    0x084E: { n:\"BrtBeginModelRelationships\", f:parsenoop },\n    0x084F: { n:\"BrtEndModelRelationships\", f:parsenoop },\n    0x0850: { n:\"BrtModelRelationship\", f:parsenoop },\n    0x0851: { n:\"BrtBeginECTxtWiz15\", f:parsenoop },\n    0x0852: { n:\"BrtEndECTxtWiz15\", f:parsenoop },\n    0x0853: { n:\"BrtBeginECTWFldInfoLst15\", f:parsenoop },\n    0x0854: { n:\"BrtEndECTWFldInfoLst15\", f:parsenoop },\n    0x0855: { n:\"BrtBeginECTWFldInfo15\", f:parsenoop },\n    0x0856: { n:\"BrtFieldListActiveItem\", f:parsenoop },\n    0x0857: { n:\"BrtPivotCacheIdVersion\", f:parsenoop },\n    0x0858: { n:\"BrtSXDI15\", f:parsenoop },\n    0xFFFF: { n:\"\", f:parsenoop }\n};\n\nvar evert_RE = evert_key(XLSBRecordEnum, 'n');\n\n/* [MS-XLS] 2.3 Record Enumeration */\nvar XLSRecordEnum = {\n    0x0003: { n:\"BIFF2NUM\", f:parse_BIFF2NUM },\n    0x0004: { n:\"BIFF2STR\", f:parse_BIFF2STR },\n    0x0006: { n:\"Formula\", f:parse_Formula },\n    0x0009: { n:'BOF', f:parse_BOF },\n    0x000a: { n:'EOF', f:parse_EOF },\n    0x000c: { n:\"CalcCount\", f:parse_CalcCount },\n    0x000d: { n:\"CalcMode\", f:parse_CalcMode },\n    0x000e: { n:\"CalcPrecision\", f:parse_CalcPrecision },\n    0x000f: { n:\"CalcRefMode\", f:parse_CalcRefMode },\n    0x0010: { n:\"CalcDelta\", f:parse_CalcDelta },\n    0x0011: { n:\"CalcIter\", f:parse_CalcIter },\n    0x0012: { n:\"Protect\", f:parse_Protect },\n    0x0013: { n:\"Password\", f:parse_Password },\n    0x0014: { n:\"Header\", f:parse_Header },\n    0x0015: { n:\"Footer\", f:parse_Footer },\n    0x0017: { n:\"ExternSheet\", f:parse_ExternSheet },\n    0x0018: { n:\"Lbl\", f:parse_Lbl },\n    0x0019: { n:\"WinProtect\", f:parse_WinProtect },\n    0x001a: { n:\"VerticalPageBreaks\", f:parse_VerticalPageBreaks },\n    0x001b: { n:\"HorizontalPageBreaks\", f:parse_HorizontalPageBreaks },\n    0x001c: { n:\"Note\", f:parse_Note },\n    0x001d: { n:\"Selection\", f:parse_Selection },\n    0x0022: { n:\"Date1904\", f:parse_Date1904 },\n    0x0023: { n:\"ExternName\", f:parse_ExternName },\n    0x0026: { n:\"LeftMargin\", f:parse_LeftMargin },\n    0x0027: { n:\"RightMargin\", f:parse_RightMargin },\n    0x0028: { n:\"TopMargin\", f:parse_TopMargin },\n    0x0029: { n:\"BottomMargin\", f:parse_BottomMargin },\n    0x002a: { n:\"PrintRowCol\", f:parse_PrintRowCol },\n    0x002b: { n:\"PrintGrid\", f:parse_PrintGrid },\n    0x002f: { n:\"FilePass\", f:parse_FilePass },\n    0x0031: { n:\"Font\", f:parse_Font },\n    0x0033: { n:\"PrintSize\", f:parse_PrintSize },\n    0x003c: { n:\"Continue\", f:parse_Continue },\n    0x003d: { n:\"Window1\", f:parse_Window1 },\n    0x0040: { n:\"Backup\", f:parse_Backup },\n    0x0041: { n:\"Pane\", f:parse_Pane },\n    0x0042: { n:'CodePage', f:parse_CodePage },\n    0x004d: { n:\"Pls\", f:parse_Pls },\n    0x0050: { n:\"DCon\", f:parse_DCon },\n    0x0051: { n:\"DConRef\", f:parse_DConRef },\n    0x0052: { n:\"DConName\", f:parse_DConName },\n    0x0055: { n:\"DefColWidth\", f:parse_DefColWidth },\n    0x0059: { n:\"XCT\", f:parse_XCT },\n    0x005a: { n:\"CRN\", f:parse_CRN },\n    0x005b: { n:\"FileSharing\", f:parse_FileSharing },\n    0x005c: { n:'WriteAccess', f:parse_WriteAccess },\n    0x005d: { n:\"Obj\", f:parse_Obj },\n    0x005e: { n:\"Uncalced\", f:parse_Uncalced },\n    0x005f: { n:\"CalcSaveRecalc\", f:parse_CalcSaveRecalc },\n    0x0060: { n:\"Template\", f:parse_Template },\n    0x0061: { n:\"Intl\", f:parse_Intl },\n    0x0063: { n:\"ObjProtect\", f:parse_ObjProtect },\n    0x007d: { n:\"ColInfo\", f:parse_ColInfo },\n    0x0080: { n:\"Guts\", f:parse_Guts },\n    0x0081: { n:\"WsBool\", f:parse_WsBool },\n    0x0082: { n:\"GridSet\", f:parse_GridSet },\n    0x0083: { n:\"HCenter\", f:parse_HCenter },\n    0x0084: { n:\"VCenter\", f:parse_VCenter },\n    0x0085: { n:'BoundSheet8', f:parse_BoundSheet8 },\n    0x0086: { n:\"WriteProtect\", f:parse_WriteProtect },\n    0x008c: { n:\"Country\", f:parse_Country },\n    0x008d: { n:\"HideObj\", f:parse_HideObj },\n    0x0090: { n:\"Sort\", f:parse_Sort },\n    0x0092: { n:\"Palette\", f:parse_Palette },\n    0x0097: { n:\"Sync\", f:parse_Sync },\n    0x0098: { n:\"LPr\", f:parse_LPr },\n    0x0099: { n:\"DxGCol\", f:parse_DxGCol },\n    0x009a: { n:\"FnGroupName\", f:parse_FnGroupName },\n    0x009b: { n:\"FilterMode\", f:parse_FilterMode },\n    0x009c: { n:\"BuiltInFnGroupCount\", f:parse_BuiltInFnGroupCount },\n    0x009d: { n:\"AutoFilterInfo\", f:parse_AutoFilterInfo },\n    0x009e: { n:\"AutoFilter\", f:parse_AutoFilter },\n    0x00a0: { n:\"Scl\", f:parse_Scl },\n    0x00a1: { n:\"Setup\", f:parse_Setup },\n    0x00ae: { n:\"ScenMan\", f:parse_ScenMan },\n    0x00af: { n:\"SCENARIO\", f:parse_SCENARIO },\n    0x00b0: { n:\"SxView\", f:parse_SxView },\n    0x00b1: { n:\"Sxvd\", f:parse_Sxvd },\n    0x00b2: { n:\"SXVI\", f:parse_SXVI },\n    0x00b4: { n:\"SxIvd\", f:parse_SxIvd },\n    0x00b5: { n:\"SXLI\", f:parse_SXLI },\n    0x00b6: { n:\"SXPI\", f:parse_SXPI },\n    0x00b8: { n:\"DocRoute\", f:parse_DocRoute },\n    0x00b9: { n:\"RecipName\", f:parse_RecipName },\n    0x00bd: { n:\"MulRk\", f:parse_MulRk },\n    0x00be: { n:\"MulBlank\", f:parse_MulBlank },\n    0x00c1: { n:'Mms', f:parse_Mms },\n    0x00c5: { n:\"SXDI\", f:parse_SXDI },\n    0x00c6: { n:\"SXDB\", f:parse_SXDB },\n    0x00c7: { n:\"SXFDB\", f:parse_SXFDB },\n    0x00c8: { n:\"SXDBB\", f:parse_SXDBB },\n    0x00c9: { n:\"SXNum\", f:parse_SXNum },\n    0x00ca: { n:\"SxBool\", f:parse_SxBool },\n    0x00cb: { n:\"SxErr\", f:parse_SxErr },\n    0x00cc: { n:\"SXInt\", f:parse_SXInt },\n    0x00cd: { n:\"SXString\", f:parse_SXString },\n    0x00ce: { n:\"SXDtr\", f:parse_SXDtr },\n    0x00cf: { n:\"SxNil\", f:parse_SxNil },\n    0x00d0: { n:\"SXTbl\", f:parse_SXTbl },\n    0x00d1: { n:\"SXTBRGIITM\", f:parse_SXTBRGIITM },\n    0x00d2: { n:\"SxTbpg\", f:parse_SxTbpg },\n    0x00d3: { n:\"ObProj\", f:parse_ObProj },\n    0x00d5: { n:\"SXStreamID\", f:parse_SXStreamID },\n    0x00d7: { n:\"DBCell\", f:parse_DBCell },\n    0x00d8: { n:\"SXRng\", f:parse_SXRng },\n    0x00d9: { n:\"SxIsxoper\", f:parse_SxIsxoper },\n    0x00da: { n:\"BookBool\", f:parse_BookBool },\n    0x00dc: { n:\"DbOrParamQry\", f:parse_DbOrParamQry },\n    0x00dd: { n:\"ScenarioProtect\", f:parse_ScenarioProtect },\n    0x00de: { n:\"OleObjectSize\", f:parse_OleObjectSize },\n    0x00e0: { n:\"XF\", f:parse_XF },\n    0x00e1: { n:'InterfaceHdr', f:parse_InterfaceHdr },\n    0x00e2: { n:'InterfaceEnd', f:parse_InterfaceEnd },\n    0x00e3: { n:\"SXVS\", f:parse_SXVS },\n    0x00e5: { n:\"MergeCells\", f:parse_MergeCells },\n    0x00e9: { n:\"BkHim\", f:parse_BkHim },\n    0x00eb: { n:\"MsoDrawingGroup\", f:parse_MsoDrawingGroup },\n    0x00ec: { n:\"MsoDrawing\", f:parse_MsoDrawing },\n    0x00ed: { n:\"MsoDrawingSelection\", f:parse_MsoDrawingSelection },\n    0x00ef: { n:\"PhoneticInfo\", f:parse_PhoneticInfo },\n    0x00f0: { n:\"SxRule\", f:parse_SxRule },\n    0x00f1: { n:\"SXEx\", f:parse_SXEx },\n    0x00f2: { n:\"SxFilt\", f:parse_SxFilt },\n    0x00f4: { n:\"SxDXF\", f:parse_SxDXF },\n    0x00f5: { n:\"SxItm\", f:parse_SxItm },\n    0x00f6: { n:\"SxName\", f:parse_SxName },\n    0x00f7: { n:\"SxSelect\", f:parse_SxSelect },\n    0x00f8: { n:\"SXPair\", f:parse_SXPair },\n    0x00f9: { n:\"SxFmla\", f:parse_SxFmla },\n    0x00fb: { n:\"SxFormat\", f:parse_SxFormat },\n    0x00fc: { n:\"SST\", f:parse_SST },\n    0x00fd: { n:\"LabelSst\", f:parse_LabelSst },\n    0x00ff: { n:\"ExtSST\", f:parse_ExtSST },\n    0x0100: { n:\"SXVDEx\", f:parse_SXVDEx },\n    0x0103: { n:\"SXFormula\", f:parse_SXFormula },\n    0x0122: { n:\"SXDBEx\", f:parse_SXDBEx },\n    0x0137: { n:\"RRDInsDel\", f:parse_RRDInsDel },\n    0x0138: { n:\"RRDHead\", f:parse_RRDHead },\n    0x013b: { n:\"RRDChgCell\", f:parse_RRDChgCell },\n    0x013d: { n:\"RRTabId\", f:parse_RRTabId },\n    0x013e: { n:\"RRDRenSheet\", f:parse_RRDRenSheet },\n    0x013f: { n:\"RRSort\", f:parse_RRSort },\n    0x0140: { n:\"RRDMove\", f:parse_RRDMove },\n    0x014a: { n:\"RRFormat\", f:parse_RRFormat },\n    0x014b: { n:\"RRAutoFmt\", f:parse_RRAutoFmt },\n    0x014d: { n:\"RRInsertSh\", f:parse_RRInsertSh },\n    0x014e: { n:\"RRDMoveBegin\", f:parse_RRDMoveBegin },\n    0x014f: { n:\"RRDMoveEnd\", f:parse_RRDMoveEnd },\n    0x0150: { n:\"RRDInsDelBegin\", f:parse_RRDInsDelBegin },\n    0x0151: { n:\"RRDInsDelEnd\", f:parse_RRDInsDelEnd },\n    0x0152: { n:\"RRDConflict\", f:parse_RRDConflict },\n    0x0153: { n:\"RRDDefName\", f:parse_RRDDefName },\n    0x0154: { n:\"RRDRstEtxp\", f:parse_RRDRstEtxp },\n    0x015f: { n:\"LRng\", f:parse_LRng },\n    0x0160: { n:\"UsesELFs\", f:parse_UsesELFs },\n    0x0161: { n:\"DSF\", f:parse_DSF },\n    0x0191: { n:\"CUsr\", f:parse_CUsr },\n    0x0192: { n:\"CbUsr\", f:parse_CbUsr },\n    0x0193: { n:\"UsrInfo\", f:parse_UsrInfo },\n    0x0194: { n:\"UsrExcl\", f:parse_UsrExcl },\n    0x0195: { n:\"FileLock\", f:parse_FileLock },\n    0x0196: { n:\"RRDInfo\", f:parse_RRDInfo },\n    0x0197: { n:\"BCUsrs\", f:parse_BCUsrs },\n    0x0198: { n:\"UsrChk\", f:parse_UsrChk },\n    0x01a9: { n:\"UserBView\", f:parse_UserBView },\n    0x01aa: { n:\"UserSViewBegin\", f:parse_UserSViewBegin },\n    0x01ab: { n:\"UserSViewEnd\", f:parse_UserSViewEnd },\n    0x01ac: { n:\"RRDUserView\", f:parse_RRDUserView },\n    0x01ad: { n:\"Qsi\", f:parse_Qsi },\n    0x01ae: { n:\"SupBook\", f:parse_SupBook },\n    0x01af: { n:\"Prot4Rev\", f:parse_Prot4Rev },\n    0x01b0: { n:\"CondFmt\", f:parse_CondFmt },\n    0x01b1: { n:\"CF\", f:parse_CF },\n    0x01b2: { n:\"DVal\", f:parse_DVal },\n    0x01b5: { n:\"DConBin\", f:parse_DConBin },\n    0x01b6: { n:\"TxO\", f:parse_TxO },\n    0x01b7: { n:\"RefreshAll\", f:parse_RefreshAll },\n    0x01b8: { n:\"HLink\", f:parse_HLink },\n    0x01b9: { n:\"Lel\", f:parse_Lel },\n    0x01ba: { n:\"CodeName\", f:parse_XLSCodeName },\n    0x01bb: { n:\"SXFDBType\", f:parse_SXFDBType },\n    0x01bc: { n:\"Prot4RevPass\", f:parse_Prot4RevPass },\n    0x01bd: { n:\"ObNoMacros\", f:parse_ObNoMacros },\n    0x01be: { n:\"Dv\", f:parse_Dv },\n    0x01c0: { n:\"Excel9File\", f:parse_Excel9File },\n    0x01c1: { n:\"RecalcId\", f:parse_RecalcId, r:2},\n    0x01c2: { n:\"EntExU2\", f:parse_EntExU2 },\n    0x0200: { n:\"Dimensions\", f:parse_Dimensions },\n    0x0201: { n:\"Blank\", f:parse_Blank },\n    0x0203: { n:\"Number\", f:parse_Number },\n    0x0204: { n:\"Label\", f:parse_Label },\n    0x0205: { n:\"BoolErr\", f:parse_BoolErr },\n    0x0207: { n:\"String\", f:parse_String },\n    0x0208: { n:'Row', f:parse_Row },\n    0x020b: { n:\"Index\", f:parse_Index },\n    0x0221: { n:\"Array\", f:parse_Array },\n    0x0225: { n:\"DefaultRowHeight\", f:parse_DefaultRowHeight },\n    0x0236: { n:\"Table\", f:parse_Table },\n    0x023e: { n:\"Window2\", f:parse_Window2 },\n    0x027e: { n:\"RK\", f:parse_RK },\n    0x0293: { n:\"Style\", f:parse_Style },\n    0x0418: { n:\"BigName\", f:parse_BigName },\n    0x041e: { n:\"Format\", f:parse_Format },\n    0x043c: { n:\"ContinueBigName\", f:parse_ContinueBigName },\n    0x04bc: { n:\"ShrFmla\", f:parse_ShrFmla },\n    0x0800: { n:\"HLinkTooltip\", f:parse_HLinkTooltip },\n    0x0801: { n:\"WebPub\", f:parse_WebPub },\n    0x0802: { n:\"QsiSXTag\", f:parse_QsiSXTag },\n    0x0803: { n:\"DBQueryExt\", f:parse_DBQueryExt },\n    0x0804: { n:\"ExtString\", f:parse_ExtString },\n    0x0805: { n:\"TxtQry\", f:parse_TxtQry },\n    0x0806: { n:\"Qsir\", f:parse_Qsir },\n    0x0807: { n:\"Qsif\", f:parse_Qsif },\n    0x0808: { n:\"RRDTQSIF\", f:parse_RRDTQSIF },\n    0x0809: { n:'BOF', f:parse_BOF },\n    0x080a: { n:\"OleDbConn\", f:parse_OleDbConn },\n    0x080b: { n:\"WOpt\", f:parse_WOpt },\n    0x080c: { n:\"SXViewEx\", f:parse_SXViewEx },\n    0x080d: { n:\"SXTH\", f:parse_SXTH },\n    0x080e: { n:\"SXPIEx\", f:parse_SXPIEx },\n    0x080f: { n:\"SXVDTEx\", f:parse_SXVDTEx },\n    0x0810: { n:\"SXViewEx9\", f:parse_SXViewEx9 },\n    0x0812: { n:\"ContinueFrt\", f:parse_ContinueFrt },\n    0x0813: { n:\"RealTimeData\", f:parse_RealTimeData },\n    0x0850: { n:\"ChartFrtInfo\", f:parse_ChartFrtInfo },\n    0x0851: { n:\"FrtWrapper\", f:parse_FrtWrapper },\n    0x0852: { n:\"StartBlock\", f:parse_StartBlock },\n    0x0853: { n:\"EndBlock\", f:parse_EndBlock },\n    0x0854: { n:\"StartObject\", f:parse_StartObject },\n    0x0855: { n:\"EndObject\", f:parse_EndObject },\n    0x0856: { n:\"CatLab\", f:parse_CatLab },\n    0x0857: { n:\"YMult\", f:parse_YMult },\n    0x0858: { n:\"SXViewLink\", f:parse_SXViewLink },\n    0x0859: { n:\"PivotChartBits\", f:parse_PivotChartBits },\n    0x085a: { n:\"FrtFontList\", f:parse_FrtFontList },\n    0x0862: { n:\"SheetExt\", f:parse_SheetExt },\n    0x0863: { n:\"BookExt\", f:parse_BookExt, r:12},\n    0x0864: { n:\"SXAddl\", f:parse_SXAddl },\n    0x0865: { n:\"CrErr\", f:parse_CrErr },\n    0x0866: { n:\"HFPicture\", f:parse_HFPicture },\n    0x0867: { n:'FeatHdr', f:parse_FeatHdr },\n    0x0868: { n:\"Feat\", f:parse_Feat },\n    0x086a: { n:\"DataLabExt\", f:parse_DataLabExt },\n    0x086b: { n:\"DataLabExtContents\", f:parse_DataLabExtContents },\n    0x086c: { n:\"CellWatch\", f:parse_CellWatch },\n    0x0871: { n:\"FeatHdr11\", f:parse_FeatHdr11 },\n    0x0872: { n:\"Feature11\", f:parse_Feature11 },\n    0x0874: { n:\"DropDownObjIds\", f:parse_DropDownObjIds },\n    0x0875: { n:\"ContinueFrt11\", f:parse_ContinueFrt11 },\n    0x0876: { n:\"DConn\", f:parse_DConn },\n    0x0877: { n:\"List12\", f:parse_List12 },\n    0x0878: { n:\"Feature12\", f:parse_Feature12 },\n    0x0879: { n:\"CondFmt12\", f:parse_CondFmt12 },\n    0x087a: { n:\"CF12\", f:parse_CF12 },\n    0x087b: { n:\"CFEx\", f:parse_CFEx },\n    0x087c: { n:\"XFCRC\", f:parse_XFCRC, r:12 },\n    0x087d: { n:\"XFExt\", f:parse_XFExt, r:12 },\n    0x087e: { n:\"AutoFilter12\", f:parse_AutoFilter12 },\n    0x087f: { n:\"ContinueFrt12\", f:parse_ContinueFrt12 },\n    0x0884: { n:\"MDTInfo\", f:parse_MDTInfo },\n    0x0885: { n:\"MDXStr\", f:parse_MDXStr },\n    0x0886: { n:\"MDXTuple\", f:parse_MDXTuple },\n    0x0887: { n:\"MDXSet\", f:parse_MDXSet },\n    0x0888: { n:\"MDXProp\", f:parse_MDXProp },\n    0x0889: { n:\"MDXKPI\", f:parse_MDXKPI },\n    0x088a: { n:\"MDB\", f:parse_MDB },\n    0x088b: { n:\"PLV\", f:parse_PLV },\n    0x088c: { n:\"Compat12\", f:parse_Compat12, r:12 },\n    0x088d: { n:\"DXF\", f:parse_DXF },\n    0x088e: { n:\"TableStyles\", f:parse_TableStyles, r:12 },\n    0x088f: { n:\"TableStyle\", f:parse_TableStyle },\n    0x0890: { n:\"TableStyleElement\", f:parse_TableStyleElement },\n    0x0892: { n:\"StyleExt\", f:parse_StyleExt },\n    0x0893: { n:\"NamePublish\", f:parse_NamePublish },\n    0x0894: { n:\"NameCmt\", f:parse_NameCmt },\n    0x0895: { n:\"SortData\", f:parse_SortData },\n    0x0896: { n:\"Theme\", f:parse_Theme, r:12 },\n    0x0897: { n:\"GUIDTypeLib\", f:parse_GUIDTypeLib },\n    0x0898: { n:\"FnGrp12\", f:parse_FnGrp12 },\n    0x0899: { n:\"NameFnGrp12\", f:parse_NameFnGrp12 },\n    0x089a: { n:\"MTRSettings\", f:parse_MTRSettings, r:12 },\n    0x089b: { n:\"CompressPictures\", f:parse_CompressPictures },\n    0x089c: { n:\"HeaderFooter\", f:parse_HeaderFooter },\n    0x089d: { n:\"CrtLayout12\", f:parse_CrtLayout12 },\n    0x089e: { n:\"CrtMlFrt\", f:parse_CrtMlFrt },\n    0x089f: { n:\"CrtMlFrtContinue\", f:parse_CrtMlFrtContinue },\n    0x08a3: { n:\"ForceFullCalculation\", f:parse_ForceFullCalculation },\n    0x08a4: { n:\"ShapePropsStream\", f:parse_ShapePropsStream },\n    0x08a5: { n:\"TextPropsStream\", f:parse_TextPropsStream },\n    0x08a6: { n:\"RichTextStream\", f:parse_RichTextStream },\n    0x08a7: { n:\"CrtLayout12A\", f:parse_CrtLayout12A },\n    0x1001: { n:\"Units\", f:parse_Units },\n    0x1002: { n:\"Chart\", f:parse_Chart },\n    0x1003: { n:\"Series\", f:parse_Series },\n    0x1006: { n:\"DataFormat\", f:parse_DataFormat },\n    0x1007: { n:\"LineFormat\", f:parse_LineFormat },\n    0x1009: { n:\"MarkerFormat\", f:parse_MarkerFormat },\n    0x100a: { n:\"AreaFormat\", f:parse_AreaFormat },\n    0x100b: { n:\"PieFormat\", f:parse_PieFormat },\n    0x100c: { n:\"AttachedLabel\", f:parse_AttachedLabel },\n    0x100d: { n:\"SeriesText\", f:parse_SeriesText },\n    0x1014: { n:\"ChartFormat\", f:parse_ChartFormat },\n    0x1015: { n:\"Legend\", f:parse_Legend },\n    0x1016: { n:\"SeriesList\", f:parse_SeriesList },\n    0x1017: { n:\"Bar\", f:parse_Bar },\n    0x1018: { n:\"Line\", f:parse_Line },\n    0x1019: { n:\"Pie\", f:parse_Pie },\n    0x101a: { n:\"Area\", f:parse_Area },\n    0x101b: { n:\"Scatter\", f:parse_Scatter },\n    0x101c: { n:\"CrtLine\", f:parse_CrtLine },\n    0x101d: { n:\"Axis\", f:parse_Axis },\n    0x101e: { n:\"Tick\", f:parse_Tick },\n    0x101f: { n:\"ValueRange\", f:parse_ValueRange },\n    0x1020: { n:\"CatSerRange\", f:parse_CatSerRange },\n    0x1021: { n:\"AxisLine\", f:parse_AxisLine },\n    0x1022: { n:\"CrtLink\", f:parse_CrtLink },\n    0x1024: { n:\"DefaultText\", f:parse_DefaultText },\n    0x1025: { n:\"Text\", f:parse_Text },\n    0x1026: { n:\"FontX\", f:parse_FontX },\n    0x1027: { n:\"ObjectLink\", f:parse_ObjectLink },\n    0x1032: { n:\"Frame\", f:parse_Frame },\n    0x1033: { n:\"Begin\", f:parse_Begin },\n    0x1034: { n:\"End\", f:parse_End },\n    0x1035: { n:\"PlotArea\", f:parse_PlotArea },\n    0x103a: { n:\"Chart3d\", f:parse_Chart3d },\n    0x103c: { n:\"PicF\", f:parse_PicF },\n    0x103d: { n:\"DropBar\", f:parse_DropBar },\n    0x103e: { n:\"Radar\", f:parse_Radar },\n    0x103f: { n:\"Surf\", f:parse_Surf },\n    0x1040: { n:\"RadarArea\", f:parse_RadarArea },\n    0x1041: { n:\"AxisParent\", f:parse_AxisParent },\n    0x1043: { n:\"LegendException\", f:parse_LegendException },\n    0x1044: { n:\"ShtProps\", f:parse_ShtProps },\n    0x1045: { n:\"SerToCrt\", f:parse_SerToCrt },\n    0x1046: { n:\"AxesUsed\", f:parse_AxesUsed },\n    0x1048: { n:\"SBaseRef\", f:parse_SBaseRef },\n    0x104a: { n:\"SerParent\", f:parse_SerParent },\n    0x104b: { n:\"SerAuxTrend\", f:parse_SerAuxTrend },\n    0x104e: { n:\"IFmtRecord\", f:parse_IFmtRecord },\n    0x104f: { n:\"Pos\", f:parse_Pos },\n    0x1050: { n:\"AlRuns\", f:parse_AlRuns },\n    0x1051: { n:\"BRAI\", f:parse_BRAI },\n    0x105b: { n:\"SerAuxErrBar\", f:parse_SerAuxErrBar },\n    0x105c: { n:\"ClrtClient\", f:parse_ClrtClient },\n    0x105d: { n:\"SerFmt\", f:parse_SerFmt },\n    0x105f: { n:\"Chart3DBarShape\", f:parse_Chart3DBarShape },\n    0x1060: { n:\"Fbi\", f:parse_Fbi },\n    0x1061: { n:\"BopPop\", f:parse_BopPop },\n    0x1062: { n:\"AxcExt\", f:parse_AxcExt },\n    0x1063: { n:\"Dat\", f:parse_Dat },\n    0x1064: { n:\"PlotGrowth\", f:parse_PlotGrowth },\n    0x1065: { n:\"SIIndex\", f:parse_SIIndex },\n    0x1066: { n:\"GelFrame\", f:parse_GelFrame },\n    0x1067: { n:\"BopPopCustom\", f:parse_BopPopCustom },\n    0x1068: { n:\"Fbi2\", f:parse_Fbi2 },\n\n    /* These are specified in an older version of the spec */\n    0x0016: { n:\"ExternCount\", f:parsenoop },\n    0x007e: { n:\"RK\", f:parsenoop }, /* Not necessarily same as 0x027e */\n    0x007f: { n:\"ImData\", f:parsenoop },\n    0x0087: { n:\"Addin\", f:parsenoop },\n    0x0088: { n:\"Edg\", f:parsenoop },\n    0x0089: { n:\"Pub\", f:parsenoop },\n    0x0091: { n:\"Sub\", f:parsenoop },\n    0x0094: { n:\"LHRecord\", f:parsenoop },\n    0x0095: { n:\"LHNGraph\", f:parsenoop },\n    0x0096: { n:\"Sound\", f:parsenoop },\n    0x00a9: { n:\"CoordList\", f:parsenoop },\n    0x00ab: { n:\"GCW\", f:parsenoop },\n    0x00bc: { n:\"ShrFmla\", f:parsenoop }, /* Not necessarily same as 0x04bc */\n    0x00c2: { n:\"AddMenu\", f:parsenoop },\n    0x00c3: { n:\"DelMenu\", f:parsenoop },\n    0x00d6: { n:\"RString\", f:parsenoop },\n    0x00df: { n:\"UDDesc\", f:parsenoop },\n    0x00ea: { n:\"TabIdConf\", f:parsenoop },\n    0x0162: { n:\"XL5Modify\", f:parsenoop },\n    0x01a5: { n:\"FileSharing2\", f:parsenoop },\n    0x0218: { n:\"Name\", f:parsenoop },\n    0x0223: { n:\"ExternName\", f:parse_ExternName },\n    0x0231: { n:\"Font\", f:parsenoop },\n    0x0406: { n:\"Formula\", f:parse_Formula },\n    0x086d: { n:\"FeatInfo\", f:parsenoop },\n    0x0873: { n:\"FeatInfo11\", f:parsenoop },\n    0x0881: { n:\"SXAddl12\", f:parsenoop },\n    0x08c0: { n:\"AutoWebPub\", f:parsenoop },\n    0x08c1: { n:\"ListObj\", f:parsenoop },\n    0x08c2: { n:\"ListField\", f:parsenoop },\n    0x08c3: { n:\"ListDV\", f:parsenoop },\n    0x08c4: { n:\"ListCondFmt\", f:parsenoop },\n    0x08c5: { n:\"ListCF\", f:parsenoop },\n    0x08c6: { n:\"FMQry\", f:parsenoop },\n    0x08c7: { n:\"FMSQry\", f:parsenoop },\n    0x08c8: { n:\"PLV\", f:parsenoop }, /* supposedly PLV for Excel 11 */\n    0x08c9: { n:\"LnExt\", f:parsenoop },\n    0x08ca: { n:\"MkrExt\", f:parsenoop },\n    0x08cb: { n:\"CrtCoopt\", f:parsenoop },\n\n    0x0000: {}\n};\n\n\n/* Helper function to call out to ODS parser */\nfunction parse_ods(zip, opts) {\n    if(typeof module !== \"undefined\" && typeof require !== 'undefined' && typeof ODS === 'undefined') ODS = require('./od' + 's');\n    if(typeof ODS === 'undefined' || !ODS.parse_ods) throw new Error(\"Unsupported ODS\");\n    return ODS.parse_ods(zip, opts);\n}\nfunction fix_opts_func(defaults) {\n    return function fix_opts(opts) {\n        for(var i = 0; i != defaults.length; ++i) {\n            var d = defaults[i];\n            if(opts[d[0]] === undefined) opts[d[0]] = d[1];\n            if(d[2] === 'n') opts[d[0]] = Number(opts[d[0]]);\n        }\n    };\n}\n\nvar fix_read_opts = fix_opts_func([\n    ['cellNF', false], /* emit cell number format string as .z */\n    ['cellHTML', true], /* emit html string as .h */\n    ['cellFormula', true], /* emit formulae as .f */\n    ['cellStyles', false], /* emits style/theme as .s */\n    ['cellDates', false], /* emit date cells with type `d` */\n\n    ['sheetStubs', false], /* emit empty cells */\n    ['sheetRows', 0, 'n'], /* read n rows (0 = read all rows) */\n\n    ['bookDeps', false], /* parse calculation chains */\n    ['bookSheets', false], /* only try to get sheet names (no Sheets) */\n    ['bookProps', false], /* only try to get properties (no Sheets) */\n    ['bookFiles', false], /* include raw file structure (keys, files, cfb) */\n    ['bookVBA', false], /* include vba raw data (vbaraw) */\n\n    ['password',''], /* password */\n    ['WTF', false] /* WTF mode (throws errors) */\n]);\n\n\nvar fix_write_opts = fix_opts_func([\n    ['cellDates', false], /* write date cells with type `d` */\n\n    ['bookSST', false], /* Generate Shared String Table */\n\n    ['bookType', 'xlsx'], /* Type of workbook (xlsx/m/b) */\n\n    ['WTF', false] /* WTF mode (throws errors) */\n]);\nfunction safe_parse_wbrels(wbrels, sheets) {\n    if(!wbrels) return 0;\n    try {\n        wbrels = sheets.map(function pwbr(w) { return [w.name, wbrels['!id'][w.id].Target]; });\n    } catch(e) { return null; }\n    return !wbrels || wbrels.length === 0 ? null : wbrels;\n}\n\nfunction safe_parse_ws(zip, path, relsPath, sheet, sheetRels, sheets, opts) {\n    try {\n        sheetRels[sheet]=parse_rels(getzipdata(zip, relsPath, true), path);\n        sheets[sheet]=parse_ws(getzipdata(zip, path),path,opts,sheetRels[sheet]);\n    } catch(e) { if(opts.WTF) throw e; }\n}\n\nvar nodirs = function nodirs(x){return x.substr(-1) != '/';};\nfunction parse_zip(zip, opts) {\n    make_ssf(SSF);\n    opts = opts || {};\n    fix_read_opts(opts);\n    reset_cp();\n\n    /* OpenDocument Part 3 Section 2.2.1 OpenDocument Package */\n    if(safegetzipfile(zip, 'META-INF/manifest.xml')) return parse_ods(zip, opts);\n\n    var entries = keys(zip.files).filter(nodirs).sort();\n    var dir = parse_ct(getzipdata(zip, '[Content_Types].xml'), opts);\n    var xlsb = false;\n    var sheets, binname;\n    if(dir.workbooks.length === 0) {\n        binname = \"xl/workbook.xml\";\n        if(getzipdata(zip,binname, true)) dir.workbooks.push(binname);\n    }\n    if(dir.workbooks.length === 0) {\n        binname = \"xl/workbook.bin\";\n        if(!getzipfile(zip,binname,true)) throw new Error(\"Could not find workbook\");\n        dir.workbooks.push(binname);\n        xlsb = true;\n    }\n    if(dir.workbooks[0].substr(-3) == \"bin\") xlsb = true;\n    if(xlsb) set_cp(1200);\n\n    if(!opts.bookSheets && !opts.bookProps) {\n        strs = [];\n        if(dir.sst) strs=parse_sst(getzipdata(zip, dir.sst.replace(/^\\//,'')), dir.sst, opts);\n\n        styles = {};\n        if(dir.style) styles = parse_sty(getzipdata(zip, dir.style.replace(/^\\//,'')),dir.style, opts);\n\n        themes = {};\n        if(opts.cellStyles && dir.themes.length) themes = parse_theme(getzipdata(zip, dir.themes[0].replace(/^\\//,''), true),dir.themes[0], opts);\n    }\n\n    var wb = parse_wb(getzipdata(zip, dir.workbooks[0].replace(/^\\//,'')), dir.workbooks[0], opts);\n\n    var props = {}, propdata = \"\";\n\n    if(dir.coreprops.length !== 0) {\n        propdata = getzipdata(zip, dir.coreprops[0].replace(/^\\//,''), true);\n        if(propdata) props = parse_core_props(propdata);\n        if(dir.extprops.length !== 0) {\n            propdata = getzipdata(zip, dir.extprops[0].replace(/^\\//,''), true);\n            if(propdata) parse_ext_props(propdata, props);\n        }\n    }\n\n    var custprops = {};\n    if(!opts.bookSheets || opts.bookProps) {\n        if (dir.custprops.length !== 0) {\n            propdata = getzipdata(zip, dir.custprops[0].replace(/^\\//,''), true);\n            if(propdata) custprops = parse_cust_props(propdata, opts);\n        }\n    }\n\n    var out = {};\n    if(opts.bookSheets || opts.bookProps) {\n        if(props.Worksheets && props.SheetNames.length > 0) sheets=props.SheetNames;\n        else if(wb.Sheets) sheets = wb.Sheets.map(function pluck(x){ return x.name; });\n        if(opts.bookProps) { out.Props = props; out.Custprops = custprops; }\n        if(typeof sheets !== 'undefined') out.SheetNames = sheets;\n        if(opts.bookSheets ? out.SheetNames : opts.bookProps) return out;\n    }\n    sheets = {};\n\n    var deps = {};\n    if(opts.bookDeps && dir.calcchain) deps=parse_cc(getzipdata(zip, dir.calcchain.replace(/^\\//,'')),dir.calcchain,opts);\n\n    var i=0;\n    var sheetRels = {};\n    var path, relsPath;\n    if(!props.Worksheets) {\n        var wbsheets = wb.Sheets;\n        props.Worksheets = wbsheets.length;\n        props.SheetNames = [];\n        for(var j = 0; j != wbsheets.length; ++j) {\n            props.SheetNames[j] = wbsheets[j].name;\n        }\n    }\n\n    var wbext = xlsb ? \"bin\" : \"xml\";\n    var wbrelsfile = 'xl/_rels/workbook.' + wbext + '.rels';\n    var wbrels = parse_rels(getzipdata(zip, wbrelsfile, true), wbrelsfile);\n    if(wbrels) wbrels = safe_parse_wbrels(wbrels, wb.Sheets);\n    /* Numbers iOS hack */\n    var nmode = (getzipdata(zip,\"xl/worksheets/sheet.xml\",true))?1:0;\n    for(i = 0; i != props.Worksheets; ++i) {\n        if(wbrels) path = 'xl/' + (wbrels[i][1]).replace(/[\\/]?xl\\//, \"\");\n        else {\n            path = 'xl/worksheets/sheet'+(i+1-nmode)+\".\" + wbext;\n            path = path.replace(/sheet0\\./,\"sheet.\");\n        }\n        relsPath = path.replace(/^(.*)(\\/)([^\\/]*)$/, \"$1/_rels/$3.rels\");\n        safe_parse_ws(zip, path, relsPath, props.SheetNames[i], sheetRels, sheets, opts);\n    }\n\n    if(dir.comments) parse_comments(zip, dir.comments, sheets, sheetRels, opts);\n\n    out = {\n        Directory: dir,\n        Workbook: wb,\n        Props: props,\n        Custprops: custprops,\n        Deps: deps,\n        Sheets: sheets,\n        SheetNames: props.SheetNames,\n        Strings: strs,\n        Styles: styles,\n        Themes: themes,\n        SSF: SSF.get_table()\n    };\n    if(opts.bookFiles) {\n        out.keys = entries;\n        out.files = zip.files;\n    }\n    if(opts.bookVBA) {\n        if(dir.vba.length > 0) out.vbaraw = getzipdata(zip,dir.vba[0],true);\n        else if(dir.defaults.bin === 'application/vnd.ms-office.vbaProject') out.vbaraw = getzipdata(zip,'xl/vbaProject.bin',true);\n    }\n    return out;\n}\nfunction add_rels(rels, rId, f, type, relobj) {\n    if(!relobj) relobj = {};\n    if(!rels['!id']) rels['!id'] = {};\n    relobj.Id = 'rId' + rId;\n    relobj.Type = type;\n    relobj.Target = f;\n    if(rels['!id'][relobj.Id]) throw new Error(\"Cannot rewrite rId \" + rId);\n    rels['!id'][relobj.Id] = relobj;\n    rels[('/' + relobj.Target).replace(\"//\",\"/\")] = relobj;\n}\n\nfunction write_zip(wb, opts) {\n    if(wb && !wb.SSF) {\n        wb.SSF = SSF.get_table();\n    }\n    if(wb && wb.SSF) {\n        make_ssf(SSF); SSF.load_table(wb.SSF);\n        opts.revssf = evert_num(wb.SSF); opts.revssf[wb.SSF[65535]] = 0;\n    }\n    opts.rels = {}; opts.wbrels = {};\n    opts.Strings = []; opts.Strings.Count = 0; opts.Strings.Unique = 0;\n    var wbext = opts.bookType == \"xlsb\" ? \"bin\" : \"xml\";\n    var ct = { workbooks: [], sheets: [], calcchains: [], themes: [], styles: [],\n        coreprops: [], extprops: [], custprops: [], strs:[], comments: [], vba: [],\n        TODO:[], rels:[], xmlns: \"\" };\n    fix_write_opts(opts = opts || {});\n    var zip = new jszip();\n    var f = \"\", rId = 0;\n\n    opts.cellXfs = [];\n    get_cell_style(opts.cellXfs, {}, {revssf:{\"General\":0}});\n\n    f = \"docProps/core.xml\";\n    zip.file(f, write_core_props(wb.Props, opts));\n    ct.coreprops.push(f);\n    add_rels(opts.rels, 2, f, RELS.CORE_PROPS);\n\n    f = \"docProps/app.xml\";\n    if(!wb.Props) wb.Props = {};\n    wb.Props.SheetNames = wb.SheetNames;\n    wb.Props.Worksheets = wb.SheetNames.length;\n    zip.file(f, write_ext_props(wb.Props, opts));\n    ct.extprops.push(f);\n    add_rels(opts.rels, 3, f, RELS.EXT_PROPS);\n\n    if(wb.Custprops !== wb.Props && keys(wb.Custprops||{}).length > 0) {\n        f = \"docProps/custom.xml\";\n        zip.file(f, write_cust_props(wb.Custprops, opts));\n        ct.custprops.push(f);\n        add_rels(opts.rels, 4, f, RELS.CUST_PROPS);\n    }\n\n    f = \"xl/workbook.\" + wbext;\n    zip.file(f, write_wb(wb, f, opts));\n    ct.workbooks.push(f);\n    add_rels(opts.rels, 1, f, RELS.WB);\n\n    for(rId=1;rId <= wb.SheetNames.length; ++rId) {\n        f = \"xl/worksheets/sheet\" + rId + \".\" + wbext;\n        zip.file(f, write_ws(rId-1, f, opts, wb));\n        ct.sheets.push(f);\n        add_rels(opts.wbrels, rId, \"worksheets/sheet\" + rId + \".\" + wbext, RELS.WS);\n    }\n\n    if(opts.Strings != null && opts.Strings.length > 0) {\n        f = \"xl/sharedStrings.\" + wbext;\n        zip.file(f, write_sst(opts.Strings, f, opts));\n        ct.strs.push(f);\n        add_rels(opts.wbrels, ++rId, \"sharedStrings.\" + wbext, RELS.SST);\n    }\n\n    /* TODO: something more intelligent with themes */\n\n    f = \"xl/theme/theme1.xml\";\n    zip.file(f, write_theme());\n    ct.themes.push(f);\n    add_rels(opts.wbrels, ++rId, \"theme/theme1.xml\", RELS.THEME);\n\n    /* TODO: something more intelligent with styles */\n\n    f = \"xl/styles.\" + wbext;\n    zip.file(f, write_sty(wb, f, opts));\n    ct.styles.push(f);\n    add_rels(opts.wbrels, ++rId, \"styles.\" + wbext, RELS.STY);\n\n    zip.file(\"[Content_Types].xml\", write_ct(ct, opts));\n    zip.file('_rels/.rels', write_rels(opts.rels));\n    zip.file('xl/_rels/workbook.' + wbext + '.rels', write_rels(opts.wbrels));\n    return zip;\n}\nfunction firstbyte(f,o) {\n    switch((o||{}).type || \"base64\") {\n        case 'buffer': return f[0];\n        case 'base64': return Base64.decode(f.substr(0,12)).charCodeAt(0);\n        case 'binary': return f.charCodeAt(0);\n        case 'array': return f[0];\n        default: throw new Error(\"Unrecognized type \" + o.type);\n    }\n}\n\nfunction read_zip(data, opts) {\n    var zip, d = data;\n    var o = opts||{};\n    if(!o.type) o.type = (has_buf && Buffer.isBuffer(data)) ? \"buffer\" : \"base64\";\n    switch(o.type) {\n        case \"base64\": zip = new jszip(d, { base64:true }); break;\n        case \"binary\": case \"array\": zip = new jszip(d, { base64:false }); break;\n        case \"buffer\": zip = new jszip(d); break;\n        case \"file\": zip=new jszip(d=_fs.readFileSync(data)); break;\n        default: throw new Error(\"Unrecognized type \" + o.type);\n    }\n    return parse_zip(zip, o);\n}\n\nfunction readSync(data, opts) {\n    var zip, d = data, isfile = false, n;\n    var o = opts||{};\n    if(!o.type) o.type = (has_buf && Buffer.isBuffer(data)) ? \"buffer\" : \"base64\";\n    if(o.type == \"file\") { isfile = true; o.type = \"buffer\"; d = _fs.readFileSync(data); }\n    switch((n = firstbyte(d, o))) {\n        case 0xD0:\n            if(isfile) o.type = \"file\";\n            return parse_xlscfb(CFB.read(data, o), o);\n        case 0x09: return parse_xlscfb(s2a(o.type === 'base64' ? Base64.decode(data) : data), o);\n        case 0x3C: return parse_xlml(d, o);\n        case 0x50:\n            if(isfile) o.type = \"file\";\n            return read_zip(data, opts);\n        default: throw new Error(\"Unsupported file \" + n);\n    }\n}\n\nfunction readFileSync(data, opts) {\n    var o = opts||{}; o.type = 'file';\n    return readSync(data, o);\n}\nfunction write_zip_type(wb, opts) {\n    var o = opts||{};\n    var z = write_zip(wb, o);\n    switch(o.type) {\n        case \"base64\": return z.generate({type:\"base64\"});\n        case \"binary\": return z.generate({type:\"string\"});\n        case \"buffer\": return z.generate({type:\"nodebuffer\"});\n        case \"file\": return _fs.writeFileSync(o.file, z.generate({type:\"nodebuffer\"}));\n        default: throw new Error(\"Unrecognized type \" + o.type);\n    }\n}\n\nfunction writeSync(wb, opts) {\n    var o = opts||{};\n    switch(o.bookType) {\n        case 'xml': return write_xlml(wb, o);\n        default: return write_zip_type(wb, o);\n    }\n}\n\nfunction writeFileSync(wb, filename, opts) {\n    var o = opts||{}; o.type = 'file';\n    o.file = filename;\n    switch(o.file.substr(-5).toLowerCase()) {\n        case '.xlsx': o.bookType = 'xlsx'; break;\n        case '.xlsm': o.bookType = 'xlsm'; break;\n        case '.xlsb': o.bookType = 'xlsb'; break;\n    default: switch(o.file.substr(-4).toLowerCase()) {\n        case '.xls': o.bookType = 'xls'; break;\n        case '.xml': o.bookType = 'xml'; break;\n    }}\n    return writeSync(wb, o);\n}\n\nfunction decode_row(rowstr) { return parseInt(unfix_row(rowstr),10) - 1; }\nfunction encode_row(row) { return \"\" + (row + 1); }\nfunction fix_row(cstr) { return cstr.replace(/([A-Z]|^)(\\d+)$/,\"$1$$$2\"); }\nfunction unfix_row(cstr) { return cstr.replace(/\\$(\\d+)$/,\"$1\"); }\n\nfunction decode_col(colstr) { var c = unfix_col(colstr), d = 0, i = 0; for(; i !== c.length; ++i) d = 26*d + c.charCodeAt(i) - 64; return d - 1; }\nfunction encode_col(col) { var s=\"\"; for(++col; col; col=Math.floor((col-1)/26)) s = String.fromCharCode(((col-1)%26) + 65) + s; return s; }\nfunction fix_col(cstr) { return cstr.replace(/^([A-Z])/,\"$$$1\"); }\nfunction unfix_col(cstr) { return cstr.replace(/^\\$([A-Z])/,\"$1\"); }\n\nfunction split_cell(cstr) { return cstr.replace(/(\\$?[A-Z]*)(\\$?\\d*)/,\"$1,$2\").split(\",\"); }\nfunction decode_cell(cstr) { var splt = split_cell(cstr); return { c:decode_col(splt[0]), r:decode_row(splt[1]) }; }\nfunction encode_cell(cell) { return encode_col(cell.c) + encode_row(cell.r); }\nfunction fix_cell(cstr) { return fix_col(fix_row(cstr)); }\nfunction unfix_cell(cstr) { return unfix_col(unfix_row(cstr)); }\nfunction decode_range(range) { var x =range.split(\":\").map(decode_cell); return {s:x[0],e:x[x.length-1]}; }\nfunction encode_range(cs,ce) {\n    if(ce === undefined || typeof ce === 'number') return encode_range(cs.s, cs.e);\n    if(typeof cs !== 'string') cs = encode_cell(cs); if(typeof ce !== 'string') ce = encode_cell(ce);\n    return cs == ce ? cs : cs + \":\" + ce;\n}\n\nfunction safe_decode_range(range) {\n    var o = {s:{c:0,r:0},e:{c:0,r:0}};\n    var idx = 0, i = 0, cc = 0;\n    var len = range.length;\n    for(idx = 0; i < len; ++i) {\n        if((cc=range.charCodeAt(i)-64) < 1 || cc > 26) break;\n        idx = 26*idx + cc;\n    }\n    o.s.c = --idx;\n\n    for(idx = 0; i < len; ++i) {\n        if((cc=range.charCodeAt(i)-48) < 0 || cc > 9) break;\n        idx = 10*idx + cc;\n    }\n    o.s.r = --idx;\n\n    if(i === len || range.charCodeAt(++i) === 58) { o.e.c=o.s.c; o.e.r=o.s.r; return o; }\n\n    for(idx = 0; i != len; ++i) {\n        if((cc=range.charCodeAt(i)-64) < 1 || cc > 26) break;\n        idx = 26*idx + cc;\n    }\n    o.e.c = --idx;\n\n    for(idx = 0; i != len; ++i) {\n        if((cc=range.charCodeAt(i)-48) < 0 || cc > 9) break;\n        idx = 10*idx + cc;\n    }\n    o.e.r = --idx;\n    return o;\n}\n\nfunction safe_format_cell(cell, v) {\n    if(cell.z !== undefined) try { return (cell.w = SSF.format(cell.z, v)); } catch(e) { }\n    if(!cell.XF) return v;\n    try { return (cell.w = SSF.format(cell.XF.ifmt||0, v)); } catch(e) { return ''+v; }\n}\n\nfunction format_cell(cell, v) {\n    if(cell == null || cell.t == null) return \"\";\n    if(cell.w !== undefined) return cell.w;\n    if(v === undefined) return safe_format_cell(cell, cell.v);\n    return safe_format_cell(cell, v);\n}\n\nfunction sheet_to_json(sheet, opts){\n    var val, row, range, header = 0, offset = 1, r, hdr = [], isempty, R, C, v;\n    var o = opts != null ? opts : {};\n    var raw = o.raw;\n    if(sheet == null || sheet[\"!ref\"] == null) return [];\n    range = o.range !== undefined ? o.range : sheet[\"!ref\"];\n    if(o.header === 1) header = 1;\n    else if(o.header === \"A\") header = 2;\n    else if(Array.isArray(o.header)) header = 3;\n    switch(typeof range) {\n        case 'string': r = safe_decode_range(range); break;\n        case 'number': r = safe_decode_range(sheet[\"!ref\"]); r.s.r = range; break;\n        default: r = range;\n    }\n    if(header > 0) offset = 0;\n    var rr = encode_row(r.s.r);\n    var cols = new Array(r.e.c-r.s.c+1);\n    var out = new Array(r.e.r-r.s.r-offset+1);\n    var outi = 0;\n    for(C = r.s.c; C <= r.e.c; ++C) {\n        cols[C] = encode_col(C);\n        val = sheet[cols[C] + rr];\n        switch(header) {\n            case 1: hdr[C] = C; break;\n            case 2: hdr[C] = cols[C]; break;\n            case 3: hdr[C] = o.header[C - r.s.c]; break;\n            default:\n                if(val === undefined) continue;\n                hdr[C] = format_cell(val);\n        }\n    }\n\n    for (R = r.s.r + offset; R <= r.e.r; ++R) {\n        rr = encode_row(R);\n        isempty = true;\n        if(header === 1) row = [];\n        else {\n            row = {};\n            if(Object.defineProperty) Object.defineProperty(row, '__rowNum__', {value:R, enumerable:false});\n            else row.__rowNum__ = R;\n        }\n        for (C = r.s.c; C <= r.e.c; ++C) {\n            val = sheet[cols[C] + rr];\n            if(val === undefined || val.t === undefined) continue;\n            v = val.v;\n            switch(val.t){\n                case 'e': continue;\n                case 's': break;\n                case 'b': case 'n': break;\n                default: throw 'unrecognized type ' + val.t;\n            }\n            if(v !== undefined) {\n                row[hdr[C]] = raw ? v : format_cell(val,v);\n                isempty = false;\n            }\n        }\n        if(isempty === false || header === 1) out[outi++] = row;\n    }\n    out.length = outi;\n    return out;\n}\n\nfunction sheet_to_row_object_array(sheet, opts) { return sheet_to_json(sheet, opts != null ? opts : {}); }\n\nfunction sheet_to_csv(sheet, opts) {\n    var out = \"\", txt = \"\", qreg = /\"/g;\n    var o = opts == null ? {} : opts;\n    if(sheet == null || sheet[\"!ref\"] == null) return \"\";\n    var r = safe_decode_range(sheet[\"!ref\"]);\n    var FS = o.FS !== undefined ? o.FS : \",\", fs = FS.charCodeAt(0);\n    var RS = o.RS !== undefined ? o.RS : \"\\n\", rs = RS.charCodeAt(0);\n    var row = \"\", rr = \"\", cols = [];\n    var i = 0, cc = 0, val;\n    var R = 0, C = 0;\n    for(C = r.s.c; C <= r.e.c; ++C) cols[C] = encode_col(C);\n    for(R = r.s.r; R <= r.e.r; ++R) {\n        row = \"\";\n        rr = encode_row(R);\n        for(C = r.s.c; C <= r.e.c; ++C) {\n            val = sheet[cols[C] + rr];\n            txt = val !== undefined ? ''+format_cell(val) : \"\";\n            for(i = 0, cc = 0; i !== txt.length; ++i) if((cc = txt.charCodeAt(i)) === fs || cc === rs || cc === 34) {\n                txt = \"\\\"\" + txt.replace(qreg, '\"\"') + \"\\\"\"; break; }\n            row += (C === r.s.c ? \"\" : FS) + txt;\n        }\n        out += row + RS;\n    }\n    return out;\n}\nvar make_csv = sheet_to_csv;\n\nfunction sheet_to_formulae(sheet) {\n    var cmds, y = \"\", x, val=\"\";\n    if(sheet == null || sheet[\"!ref\"] == null) return \"\";\n    var r = safe_decode_range(sheet['!ref']), rr = \"\", cols = [], C;\n    cmds = new Array((r.e.r-r.s.r+1)*(r.e.c-r.s.c+1));\n    var i = 0;\n    for(C = r.s.c; C <= r.e.c; ++C) cols[C] = encode_col(C);\n    for(var R = r.s.r; R <= r.e.r; ++R) {\n        rr = encode_row(R);\n        for(C = r.s.c; C <= r.e.c; ++C) {\n            y = cols[C] + rr;\n            x = sheet[y];\n            val = \"\";\n            if(x === undefined) continue;\n            if(x.f != null) val = x.f;\n            else if(x.w !== undefined) val = \"'\" + x.w;\n            else if(x.v === undefined) continue;\n            else val = \"\"+x.v;\n            cmds[i++] = y + \"=\" + val;\n        }\n    }\n    cmds.length = i;\n    return cmds;\n}\n\nvar utils = {\n    encode_col: encode_col,\n    encode_row: encode_row,\n    encode_cell: encode_cell,\n    encode_range: encode_range,\n    decode_col: decode_col,\n    decode_row: decode_row,\n    split_cell: split_cell,\n    decode_cell: decode_cell,\n    decode_range: decode_range,\n    format_cell: format_cell,\n    get_formulae: sheet_to_formulae,\n    make_csv: sheet_to_csv,\n    make_json: sheet_to_json,\n    make_formulae: sheet_to_formulae,\n    sheet_to_csv: sheet_to_csv,\n    sheet_to_json: sheet_to_json,\n    sheet_to_formulae: sheet_to_formulae,\n    sheet_to_row_object_array: sheet_to_row_object_array\n};\nXLSX.parse_xlscfb = parse_xlscfb;\nXLSX.parse_zip = parse_zip;\nXLSX.read = readSync; //xlsread\nXLSX.readFile = readFileSync; //readFile\nXLSX.readFileSync = readFileSync;\nXLSX.write = writeSync;\nXLSX.writeFile = writeFileSync;\nXLSX.writeFileSync = writeFileSync;\nXLSX.utils = utils;\nXLSX.CFB = CFB;\nXLSX.SSF = SSF;\n})(typeof exports !== 'undefined' ? exports : XLSX);\nvar XLS = XLSX;","Amasty_Reports/amcharts/plugins/export/libs/xlsx/xlsx.min.js":"// phpcs:ignoreFile\n/* eslint-disable */\n/* xlsx.js (C) 2013-2015 SheetJS -- http://sheetjs.com */\nvar XLSX={};(function make_xlsx(XLSX){XLSX.version=\"0.8.0\";var current_codepage=1200,current_cptable;if(typeof module!==\"undefined\"&&typeof require!==\"undefined\"){if(typeof cptable===\"undefined\")cptable=require(\"./dist/cpexcel\");current_cptable=cptable[current_codepage]}function reset_cp(){set_cp(1200)}var set_cp=function(cp){current_codepage=cp};function char_codes(data){var o=[];for(var i=0,len=data.length;i<len;++i)o[i]=data.charCodeAt(i);return o}var debom_xml=function(data){return data};var _getchar=function _gc1(x){return String.fromCharCode(x)};if(typeof cptable!==\"undefined\"){set_cp=function(cp){current_codepage=cp;current_cptable=cptable[cp]};debom_xml=function(data){if(data.charCodeAt(0)===255&&data.charCodeAt(1)===254){return cptable.utils.decode(1200,char_codes(data.substr(2)))}return data};_getchar=function _gc2(x){if(current_codepage===1200)return String.fromCharCode(x);return cptable.utils.decode(current_codepage,[x&255,x>>8])[0]}}var Base64=function make_b64(){var map=\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\";return{encode:function(input,utf8){var o=\"\";var c1,c2,c3,e1,e2,e3,e4;for(var i=0;i<input.length;){c1=input.charCodeAt(i++);c2=input.charCodeAt(i++);c3=input.charCodeAt(i++);e1=c1>>2;e2=(c1&3)<<4|c2>>4;e3=(c2&15)<<2|c3>>6;e4=c3&63;if(isNaN(c2)){e3=e4=64}else if(isNaN(c3)){e4=64}o+=map.charAt(e1)+map.charAt(e2)+map.charAt(e3)+map.charAt(e4)}return o},decode:function b64_decode(input,utf8){var o=\"\";var c1,c2,c3;var e1,e2,e3,e4;input=input.replace(/[^A-Za-z0-9\\+\\/\\=]/g,\"\");for(var i=0;i<input.length;){e1=map.indexOf(input.charAt(i++));e2=map.indexOf(input.charAt(i++));e3=map.indexOf(input.charAt(i++));e4=map.indexOf(input.charAt(i++));c1=e1<<2|e2>>4;c2=(e2&15)<<4|e3>>2;c3=(e3&3)<<6|e4;o+=String.fromCharCode(c1);if(e3!=64){o+=String.fromCharCode(c2)}if(e4!=64){o+=String.fromCharCode(c3)}}return o}}}();var has_buf=typeof Buffer!==\"undefined\";function new_raw_buf(len){return new(has_buf?Buffer:Array)(len)}function s2a(s){if(has_buf)return new Buffer(s,\"binary\");return s.split(\"\").map(function(x){return x.charCodeAt(0)&255})}var bconcat=function(bufs){return[].concat.apply([],bufs)};var chr0=/\\u0000/g,chr1=/[\\u0001-\\u0006]/;var SSF={};var make_ssf=function make_ssf(SSF){SSF.version=\"0.8.1\";function _strrev(x){var o=\"\",i=x.length-1;while(i>=0)o+=x.charAt(i--);return o}function fill(c,l){var o=\"\";while(o.length<l)o+=c;return o}function pad0(v,d){var t=\"\"+v;return t.length>=d?t:fill(\"0\",d-t.length)+t}function pad_(v,d){var t=\"\"+v;return t.length>=d?t:fill(\" \",d-t.length)+t}function rpad_(v,d){var t=\"\"+v;return t.length>=d?t:t+fill(\" \",d-t.length)}function pad0r1(v,d){var t=\"\"+Math.round(v);return t.length>=d?t:fill(\"0\",d-t.length)+t}function pad0r2(v,d){var t=\"\"+v;return t.length>=d?t:fill(\"0\",d-t.length)+t}var p2_32=Math.pow(2,32);function pad0r(v,d){if(v>p2_32||v<-p2_32)return pad0r1(v,d);var i=Math.round(v);return pad0r2(i,d)}function isgeneral(s,i){return s.length>=7+i&&(s.charCodeAt(i)|32)===103&&(s.charCodeAt(i+1)|32)===101&&(s.charCodeAt(i+2)|32)===110&&(s.charCodeAt(i+3)|32)===101&&(s.charCodeAt(i+4)|32)===114&&(s.charCodeAt(i+5)|32)===97&&(s.charCodeAt(i+6)|32)===108}var opts_fmt=[[\"date1904\",0],[\"output\",\"\"],[\"WTF\",false]];function fixopts(o){for(var y=0;y!=opts_fmt.length;++y)if(o[opts_fmt[y][0]]===undefined)o[opts_fmt[y][0]]=opts_fmt[y][1]}SSF.opts=opts_fmt;var table_fmt={0:\"General\",1:\"0\",2:\"0.00\",3:\"#,##0\",4:\"#,##0.00\",9:\"0%\",10:\"0.00%\",11:\"0.00E+00\",12:\"# ?/?\",13:\"# ??/??\",14:\"m/d/yy\",15:\"d-mmm-yy\",16:\"d-mmm\",17:\"mmm-yy\",18:\"h:mm AM/PM\",19:\"h:mm:ss AM/PM\",20:\"h:mm\",21:\"h:mm:ss\",22:\"m/d/yy h:mm\",37:\"#,##0 ;(#,##0)\",38:\"#,##0 ;[Red](#,##0)\",39:\"#,##0.00;(#,##0.00)\",40:\"#,##0.00;[Red](#,##0.00)\",45:\"mm:ss\",46:\"[h]:mm:ss\",47:\"mmss.0\",48:\"##0.0E+0\",49:\"@\",56:'\"\u4e0a\u5348/\u4e0b\u5348 \"hh\"\u6642\"mm\"\u5206\"ss\"\u79d2 \"',65535:\"General\"};var days=[[\"Sun\",\"Sunday\"],[\"Mon\",\"Monday\"],[\"Tue\",\"Tuesday\"],[\"Wed\",\"Wednesday\"],[\"Thu\",\"Thursday\"],[\"Fri\",\"Friday\"],[\"Sat\",\"Saturday\"]];var months=[[\"J\",\"Jan\",\"January\"],[\"F\",\"Feb\",\"February\"],[\"M\",\"Mar\",\"March\"],[\"A\",\"Apr\",\"April\"],[\"M\",\"May\",\"May\"],[\"J\",\"Jun\",\"June\"],[\"J\",\"Jul\",\"July\"],[\"A\",\"Aug\",\"August\"],[\"S\",\"Sep\",\"September\"],[\"O\",\"Oct\",\"October\"],[\"N\",\"Nov\",\"November\"],[\"D\",\"Dec\",\"December\"]];function frac(x,D,mixed){var sgn=x<0?-1:1;var B=x*sgn;var P_2=0,P_1=1,P=0;var Q_2=1,Q_1=0,Q=0;var A=Math.floor(B);while(Q_1<D){A=Math.floor(B);P=A*P_1+P_2;Q=A*Q_1+Q_2;if(B-A<5e-10)break;B=1/(B-A);P_2=P_1;P_1=P;Q_2=Q_1;Q_1=Q}if(Q>D){Q=Q_1;P=P_1}if(Q>D){Q=Q_2;P=P_2}if(!mixed)return[0,sgn*P,Q];if(Q===0)throw\"Unexpected state: \"+P+\" \"+P_1+\" \"+P_2+\" \"+Q+\" \"+Q_1+\" \"+Q_2;var q=Math.floor(sgn*P/Q);return[q,sgn*P-q*Q,Q]}function general_fmt_int(v,opts){return\"\"+v}SSF._general_int=general_fmt_int;var general_fmt_num=function make_general_fmt_num(){var gnr1=/\\.(\\d*[1-9])0+$/,gnr2=/\\.0*$/,gnr4=/\\.(\\d*[1-9])0+/,gnr5=/\\.0*[Ee]/,gnr6=/(E[+-])(\\d)$/;function gfn2(v){var w=v<0?12:11;var o=gfn5(v.toFixed(12));if(o.length<=w)return o;o=v.toPrecision(10);if(o.length<=w)return o;return v.toExponential(5)}function gfn3(v){var o=v.toFixed(11).replace(gnr1,\".$1\");if(o.length>(v<0?12:11))o=v.toPrecision(6);return o}function gfn4(o){for(var i=0;i!=o.length;++i)if((o.charCodeAt(i)|32)===101)return o.replace(gnr4,\".$1\").replace(gnr5,\"E\").replace(\"e\",\"E\").replace(gnr6,\"$10$2\");return o}function gfn5(o){return o.indexOf(\".\")>-1?o.replace(gnr2,\"\").replace(gnr1,\".$1\"):o}return function general_fmt_num(v,opts){var V=Math.floor(Math.log(Math.abs(v))*Math.LOG10E),o;if(V>=-4&&V<=-1)o=v.toPrecision(10+V);else if(Math.abs(V)<=9)o=gfn2(v);else if(V===10)o=v.toFixed(10).substr(0,12);else o=gfn3(v);return gfn5(gfn4(o))}}();SSF._general_num=general_fmt_num;function general_fmt(v,opts){switch(typeof v){case\"string\":return v;case\"boolean\":return v?\"TRUE\":\"FALSE\";case\"number\":return(v|0)===v?general_fmt_int(v,opts):general_fmt_num(v,opts)}throw new Error(\"unsupported value in General format: \"+v)}SSF._general=general_fmt;function fix_hijri(date,o){return 0}function parse_date_code(v,opts,b2){if(v>2958465||v<0)return null;var date=v|0,time=Math.floor(86400*(v-date)),dow=0;var dout=[];var out={D:date,T:time,u:86400*(v-date)-time,y:0,m:0,d:0,H:0,M:0,S:0,q:0};if(Math.abs(out.u)<1e-6)out.u=0;fixopts(opts!=null?opts:opts=[]);if(opts.date1904)date+=1462;if(out.u>.999){out.u=0;if(++time==86400){time=0;++date}}if(date===60){dout=b2?[1317,10,29]:[1900,2,29];dow=3}else if(date===0){dout=b2?[1317,8,29]:[1900,1,0];dow=6}else{if(date>60)--date;var d=new Date(1900,0,1);d.setDate(d.getDate()+date-1);dout=[d.getFullYear(),d.getMonth()+1,d.getDate()];dow=d.getDay();if(date<60)dow=(dow+6)%7;if(b2)dow=fix_hijri(d,dout)}out.y=dout[0];out.m=dout[1];out.d=dout[2];out.S=time%60;time=Math.floor(time/60);out.M=time%60;time=Math.floor(time/60);out.H=time;out.q=dow;return out}SSF.parse_date_code=parse_date_code;function write_date(type,fmt,val,ss0){var o=\"\",ss=0,tt=0,y=val.y,out,outl=0;switch(type){case 98:y=val.y+543;case 121:switch(fmt.length){case 1:case 2:out=y%100;outl=2;break;default:out=y%1e4;outl=4;break}break;case 109:switch(fmt.length){case 1:case 2:out=val.m;outl=fmt.length;break;case 3:return months[val.m-1][1];case 5:return months[val.m-1][0];default:return months[val.m-1][2]}break;case 100:switch(fmt.length){case 1:case 2:out=val.d;outl=fmt.length;break;case 3:return days[val.q][0];default:return days[val.q][1]}break;case 104:switch(fmt.length){case 1:case 2:out=1+(val.H+11)%12;outl=fmt.length;break;default:throw\"bad hour format: \"+fmt}break;case 72:switch(fmt.length){case 1:case 2:out=val.H;outl=fmt.length;break;default:throw\"bad hour format: \"+fmt}break;case 77:switch(fmt.length){case 1:case 2:out=val.M;outl=fmt.length;break;default:throw\"bad minute format: \"+fmt}break;case 115:if(val.u===0)switch(fmt){case\"s\":case\"ss\":return pad0(val.S,fmt.length);case\".0\":case\".00\":case\".000\":}switch(fmt){case\"s\":case\"ss\":case\".0\":case\".00\":case\".000\":if(ss0>=2)tt=ss0===3?1e3:100;else tt=ss0===1?10:1;ss=Math.round(tt*(val.S+val.u));if(ss>=60*tt)ss=0;if(fmt===\"s\")return ss===0?\"0\":\"\"+ss/tt;o=pad0(ss,2+ss0);if(fmt===\"ss\")return o.substr(0,2);return\".\"+o.substr(2,fmt.length-1);default:throw\"bad second format: \"+fmt}case 90:switch(fmt){case\"[h]\":case\"[hh]\":out=val.D*24+val.H;break;case\"[m]\":case\"[mm]\":out=(val.D*24+val.H)*60+val.M;break;case\"[s]\":case\"[ss]\":out=((val.D*24+val.H)*60+val.M)*60+Math.round(val.S+val.u);break;default:throw\"bad abstime format: \"+fmt}outl=fmt.length===3?1:2;break;case 101:out=y;outl=1}if(outl>0)return pad0(out,outl);else return\"\"}function commaify(s){if(s.length<=3)return s;var j=s.length%3,o=s.substr(0,j);for(;j!=s.length;j+=3)o+=(o.length>0?\",\":\"\")+s.substr(j,3);return o}var write_num=function make_write_num(){var pct1=/%/g;function write_num_pct(type,fmt,val){var sfmt=fmt.replace(pct1,\"\"),mul=fmt.length-sfmt.length;return write_num(type,sfmt,val*Math.pow(10,2*mul))+fill(\"%\",mul)}function write_num_cm(type,fmt,val){var idx=fmt.length-1;while(fmt.charCodeAt(idx-1)===44)--idx;return write_num(type,fmt.substr(0,idx),val/Math.pow(10,3*(fmt.length-idx)))}function write_num_exp(fmt,val){var o;var idx=fmt.indexOf(\"E\")-fmt.indexOf(\".\")-1;if(fmt.match(/^#+0.0E\\+0$/)){var period=fmt.indexOf(\".\");if(period===-1)period=fmt.indexOf(\"E\");var ee=Math.floor(Math.log(Math.abs(val))*Math.LOG10E)%period;if(ee<0)ee+=period;o=(val/Math.pow(10,ee)).toPrecision(idx+1+(period+ee)%period);if(o.indexOf(\"e\")===-1){var fakee=Math.floor(Math.log(Math.abs(val))*Math.LOG10E);if(o.indexOf(\".\")===-1)o=o[0]+\".\"+o.substr(1)+\"E+\"+(fakee-o.length+ee);else o+=\"E+\"+(fakee-ee);while(o.substr(0,2)===\"0.\"){o=o[0]+o.substr(2,period)+\".\"+o.substr(2+period);o=o.replace(/^0+([1-9])/,\"$1\").replace(/^0+\\./,\"0.\")}o=o.replace(/\\+-/,\"-\")}o=o.replace(/^([+-]?)(\\d*)\\.(\\d*)[Ee]/,function($$,$1,$2,$3){return $1+$2+$3.substr(0,(period+ee)%period)+\".\"+$3.substr(ee)+\"E\"})}else o=val.toExponential(idx);if(fmt.match(/E\\+00$/)&&o.match(/e[+-]\\d$/))o=o.substr(0,o.length-1)+\"0\"+o[o.length-1];if(fmt.match(/E\\-/)&&o.match(/e\\+/))o=o.replace(/e\\+/,\"e\");return o.replace(\"e\",\"E\")}var frac1=/# (\\?+)( ?)\\/( ?)(\\d+)/;function write_num_f1(r,aval,sign){var den=parseInt(r[4]),rr=Math.round(aval*den),base=Math.floor(rr/den);var myn=rr-base*den,myd=den;return sign+(base===0?\"\":\"\"+base)+\" \"+(myn===0?fill(\" \",r[1].length+1+r[4].length):pad_(myn,r[1].length)+r[2]+\"/\"+r[3]+pad0(myd,r[4].length))}function write_num_f2(r,aval,sign){return sign+(aval===0?\"\":\"\"+aval)+fill(\" \",r[1].length+2+r[4].length)}var dec1=/^#*0*\\.(0+)/;var closeparen=/\\).*[0#]/;var phone=/\\(###\\) ###\\\\?-####/;function hashq(str){var o=\"\",cc;for(var i=0;i!=str.length;++i)switch(cc=str.charCodeAt(i)){case 35:break;case 63:o+=\" \";break;case 48:o+=\"0\";break;default:o+=String.fromCharCode(cc)}return o}function rnd(val,d){var dd=Math.pow(10,d);return\"\"+Math.round(val*dd)/dd}function dec(val,d){return Math.round((val-Math.floor(val))*Math.pow(10,d))}function flr(val){if(val<2147483647&&val>-2147483648)return\"\"+(val>=0?val|0:val-1|0);return\"\"+Math.floor(val)}function write_num_flt(type,fmt,val){if(type.charCodeAt(0)===40&&!fmt.match(closeparen)){var ffmt=fmt.replace(/\\( */,\"\").replace(/ \\)/,\"\").replace(/\\)/,\"\");if(val>=0)return write_num_flt(\"n\",ffmt,val);return\"(\"+write_num_flt(\"n\",ffmt,-val)+\")\"}if(fmt.charCodeAt(fmt.length-1)===44)return write_num_cm(type,fmt,val);if(fmt.indexOf(\"%\")!==-1)return write_num_pct(type,fmt,val);if(fmt.indexOf(\"E\")!==-1)return write_num_exp(fmt,val);if(fmt.charCodeAt(0)===36)return\"$\"+write_num_flt(type,fmt.substr(fmt[1]==\" \"?2:1),val);var o,oo;var r,ri,ff,aval=Math.abs(val),sign=val<0?\"-\":\"\";if(fmt.match(/^00+$/))return sign+pad0r(aval,fmt.length);if(fmt.match(/^[#?]+$/)){o=pad0r(val,0);if(o===\"0\")o=\"\";return o.length>fmt.length?o:hashq(fmt.substr(0,fmt.length-o.length))+o}if((r=fmt.match(frac1))!==null)return write_num_f1(r,aval,sign);if(fmt.match(/^#+0+$/)!==null)return sign+pad0r(aval,fmt.length-fmt.indexOf(\"0\"));if((r=fmt.match(dec1))!==null){o=rnd(val,r[1].length).replace(/^([^\\.]+)$/,\"$1.\"+r[1]).replace(/\\.$/,\".\"+r[1]).replace(/\\.(\\d*)$/,function($$,$1){return\".\"+$1+fill(\"0\",r[1].length-$1.length)});return fmt.indexOf(\"0.\")!==-1?o:o.replace(/^0\\./,\".\")}fmt=fmt.replace(/^#+([0.])/,\"$1\");if((r=fmt.match(/^(0*)\\.(#*)$/))!==null){return sign+rnd(aval,r[2].length).replace(/\\.(\\d*[1-9])0*$/,\".$1\").replace(/^(-?\\d*)$/,\"$1.\").replace(/^0\\./,r[1].length?\"0.\":\".\")}if((r=fmt.match(/^#,##0(\\.?)$/))!==null)return sign+commaify(pad0r(aval,0));if((r=fmt.match(/^#,##0\\.([#0]*0)$/))!==null){return val<0?\"-\"+write_num_flt(type,fmt,-val):commaify(\"\"+Math.floor(val))+\".\"+pad0(dec(val,r[1].length),r[1].length)}if((r=fmt.match(/^#,#*,#0/))!==null)return write_num_flt(type,fmt.replace(/^#,#*,/,\"\"),val);if((r=fmt.match(/^([0#]+)(\\\\?-([0#]+))+$/))!==null){o=_strrev(write_num_flt(type,fmt.replace(/[\\\\-]/g,\"\"),val));ri=0;return _strrev(_strrev(fmt.replace(/\\\\/g,\"\")).replace(/[0#]/g,function(x){return ri<o.length?o[ri++]:x===\"0\"?\"0\":\"\"}))}if(fmt.match(phone)!==null){o=write_num_flt(type,\"##########\",val);return\"(\"+o.substr(0,3)+\") \"+o.substr(3,3)+\"-\"+o.substr(6)}var oa=\"\";if((r=fmt.match(/^([#0?]+)( ?)\\/( ?)([#0?]+)/))!==null){ri=Math.min(r[4].length,7);ff=frac(aval,Math.pow(10,ri)-1,false);o=\"\"+sign;oa=write_num(\"n\",r[1],ff[1]);if(oa[oa.length-1]==\" \")oa=oa.substr(0,oa.length-1)+\"0\";o+=oa+r[2]+\"/\"+r[3];oa=rpad_(ff[2],ri);if(oa.length<r[4].length)oa=hashq(r[4].substr(r[4].length-oa.length))+oa;o+=oa;return o}if((r=fmt.match(/^# ([#0?]+)( ?)\\/( ?)([#0?]+)/))!==null){ri=Math.min(Math.max(r[1].length,r[4].length),7);ff=frac(aval,Math.pow(10,ri)-1,true);return sign+(ff[0]||(ff[1]?\"\":\"0\"))+\" \"+(ff[1]?pad_(ff[1],ri)+r[2]+\"/\"+r[3]+rpad_(ff[2],ri):fill(\" \",2*ri+1+r[2].length+r[3].length))}if((r=fmt.match(/^[#0?]+$/))!==null){o=pad0r(val,0);if(fmt.length<=o.length)return o;return hashq(fmt.substr(0,fmt.length-o.length))+o}if((r=fmt.match(/^([#0?]+)\\.([#0]+)$/))!==null){o=\"\"+val.toFixed(Math.min(r[2].length,10)).replace(/([^0])0+$/,\"$1\");ri=o.indexOf(\".\");var lres=fmt.indexOf(\".\")-ri,rres=fmt.length-o.length-lres;return hashq(fmt.substr(0,lres)+o+fmt.substr(fmt.length-rres))}if((r=fmt.match(/^00,000\\.([#0]*0)$/))!==null){ri=dec(val,r[1].length);return val<0?\"-\"+write_num_flt(type,fmt,-val):commaify(flr(val)).replace(/^\\d,\\d{3}$/,\"0$&\").replace(/^\\d*$/,function($$){return\"00,\"+($$.length<3?pad0(0,3-$$.length):\"\")+$$})+\".\"+pad0(ri,r[1].length)}switch(fmt){case\"#,###\":var x=commaify(pad0r(aval,0));return x!==\"0\"?sign+x:\"\";default:}throw new Error(\"unsupported format |\"+fmt+\"|\")}function write_num_cm2(type,fmt,val){var idx=fmt.length-1;while(fmt.charCodeAt(idx-1)===44)--idx;return write_num(type,fmt.substr(0,idx),val/Math.pow(10,3*(fmt.length-idx)))}function write_num_pct2(type,fmt,val){var sfmt=fmt.replace(pct1,\"\"),mul=fmt.length-sfmt.length;return write_num(type,sfmt,val*Math.pow(10,2*mul))+fill(\"%\",mul)}function write_num_exp2(fmt,val){var o;var idx=fmt.indexOf(\"E\")-fmt.indexOf(\".\")-1;if(fmt.match(/^#+0.0E\\+0$/)){var period=fmt.indexOf(\".\");if(period===-1)period=fmt.indexOf(\"E\");var ee=Math.floor(Math.log(Math.abs(val))*Math.LOG10E)%period;if(ee<0)ee+=period;o=(val/Math.pow(10,ee)).toPrecision(idx+1+(period+ee)%period);if(!o.match(/[Ee]/)){var fakee=Math.floor(Math.log(Math.abs(val))*Math.LOG10E);if(o.indexOf(\".\")===-1)o=o[0]+\".\"+o.substr(1)+\"E+\"+(fakee-o.length+ee);else o+=\"E+\"+(fakee-ee);o=o.replace(/\\+-/,\"-\")}o=o.replace(/^([+-]?)(\\d*)\\.(\\d*)[Ee]/,function($$,$1,$2,$3){return $1+$2+$3.substr(0,(period+ee)%period)+\".\"+$3.substr(ee)+\"E\"})}else o=val.toExponential(idx);if(fmt.match(/E\\+00$/)&&o.match(/e[+-]\\d$/))o=o.substr(0,o.length-1)+\"0\"+o[o.length-1];if(fmt.match(/E\\-/)&&o.match(/e\\+/))o=o.replace(/e\\+/,\"e\");return o.replace(\"e\",\"E\")}function write_num_int(type,fmt,val){if(type.charCodeAt(0)===40&&!fmt.match(closeparen)){var ffmt=fmt.replace(/\\( */,\"\").replace(/ \\)/,\"\").replace(/\\)/,\"\");if(val>=0)return write_num_int(\"n\",ffmt,val);return\"(\"+write_num_int(\"n\",ffmt,-val)+\")\"}if(fmt.charCodeAt(fmt.length-1)===44)return write_num_cm2(type,fmt,val);if(fmt.indexOf(\"%\")!==-1)return write_num_pct2(type,fmt,val);if(fmt.indexOf(\"E\")!==-1)return write_num_exp2(fmt,val);if(fmt.charCodeAt(0)===36)return\"$\"+write_num_int(type,fmt.substr(fmt[1]==\" \"?2:1),val);var o;var r,ri,ff,aval=Math.abs(val),sign=val<0?\"-\":\"\";if(fmt.match(/^00+$/))return sign+pad0(aval,fmt.length);if(fmt.match(/^[#?]+$/)){o=\"\"+val;if(val===0)o=\"\";return o.length>fmt.length?o:hashq(fmt.substr(0,fmt.length-o.length))+o}if((r=fmt.match(frac1))!==null)return write_num_f2(r,aval,sign);if(fmt.match(/^#+0+$/)!==null)return sign+pad0(aval,fmt.length-fmt.indexOf(\"0\"));if((r=fmt.match(dec1))!==null){o=(\"\"+val).replace(/^([^\\.]+)$/,\"$1.\"+r[1]).replace(/\\.$/,\".\"+r[1]).replace(/\\.(\\d*)$/,function($$,$1){return\".\"+$1+fill(\"0\",r[1].length-$1.length)});return fmt.indexOf(\"0.\")!==-1?o:o.replace(/^0\\./,\".\")}fmt=fmt.replace(/^#+([0.])/,\"$1\");if((r=fmt.match(/^(0*)\\.(#*)$/))!==null){return sign+(\"\"+aval).replace(/\\.(\\d*[1-9])0*$/,\".$1\").replace(/^(-?\\d*)$/,\"$1.\").replace(/^0\\./,r[1].length?\"0.\":\".\")}if((r=fmt.match(/^#,##0(\\.?)$/))!==null)return sign+commaify(\"\"+aval);if((r=fmt.match(/^#,##0\\.([#0]*0)$/))!==null){return val<0?\"-\"+write_num_int(type,fmt,-val):commaify(\"\"+val)+\".\"+fill(\"0\",r[1].length)}if((r=fmt.match(/^#,#*,#0/))!==null)return write_num_int(type,fmt.replace(/^#,#*,/,\"\"),val);if((r=fmt.match(/^([0#]+)(\\\\?-([0#]+))+$/))!==null){o=_strrev(write_num_int(type,fmt.replace(/[\\\\-]/g,\"\"),val));ri=0;return _strrev(_strrev(fmt.replace(/\\\\/g,\"\")).replace(/[0#]/g,function(x){return ri<o.length?o[ri++]:x===\"0\"?\"0\":\"\"}))}if(fmt.match(phone)!==null){o=write_num_int(type,\"##########\",val);return\"(\"+o.substr(0,3)+\") \"+o.substr(3,3)+\"-\"+o.substr(6)}var oa=\"\";if((r=fmt.match(/^([#0?]+)( ?)\\/( ?)([#0?]+)/))!==null){ri=Math.min(r[4].length,7);ff=frac(aval,Math.pow(10,ri)-1,false);o=\"\"+sign;oa=write_num(\"n\",r[1],ff[1]);if(oa[oa.length-1]==\" \")oa=oa.substr(0,oa.length-1)+\"0\";o+=oa+r[2]+\"/\"+r[3];oa=rpad_(ff[2],ri);if(oa.length<r[4].length)oa=hashq(r[4].substr(r[4].length-oa.length))+oa;o+=oa;return o}if((r=fmt.match(/^# ([#0?]+)( ?)\\/( ?)([#0?]+)/))!==null){ri=Math.min(Math.max(r[1].length,r[4].length),7);ff=frac(aval,Math.pow(10,ri)-1,true);return sign+(ff[0]||(ff[1]?\"\":\"0\"))+\" \"+(ff[1]?pad_(ff[1],ri)+r[2]+\"/\"+r[3]+rpad_(ff[2],ri):fill(\" \",2*ri+1+r[2].length+r[3].length))}if((r=fmt.match(/^[#0?]+$/))!==null){o=\"\"+val;if(fmt.length<=o.length)return o;return hashq(fmt.substr(0,fmt.length-o.length))+o}if((r=fmt.match(/^([#0]+)\\.([#0]+)$/))!==null){o=\"\"+val.toFixed(Math.min(r[2].length,10)).replace(/([^0])0+$/,\"$1\");ri=o.indexOf(\".\");var lres=fmt.indexOf(\".\")-ri,rres=fmt.length-o.length-lres;return hashq(fmt.substr(0,lres)+o+fmt.substr(fmt.length-rres))}if((r=fmt.match(/^00,000\\.([#0]*0)$/))!==null){return val<0?\"-\"+write_num_int(type,fmt,-val):commaify(\"\"+val).replace(/^\\d,\\d{3}$/,\"0$&\").replace(/^\\d*$/,function($$){return\"00,\"+($$.length<3?pad0(0,3-$$.length):\"\")+$$})+\".\"+pad0(0,r[1].length)}switch(fmt){case\"#,###\":var x=commaify(\"\"+aval);return x!==\"0\"?sign+x:\"\";default:}throw new Error(\"unsupported format |\"+fmt+\"|\")}return function write_num(type,fmt,val){return(val|0)===val?write_num_int(type,fmt,val):write_num_flt(type,fmt,val)}}();function split_fmt(fmt){var out=[];var in_str=false,cc;for(var i=0,j=0;i<fmt.length;++i)switch(cc=fmt.charCodeAt(i)){case 34:in_str=!in_str;break;case 95:case 42:case 92:++i;break;case 59:out[out.length]=fmt.substr(j,i-j);j=i+1}out[out.length]=fmt.substr(j);if(in_str===true)throw new Error(\"Format |\"+fmt+\"| unterminated string \");return out}SSF._split=split_fmt;var abstime=/\\[[HhMmSs]*\\]/;function eval_fmt(fmt,v,opts,flen){var out=[],o=\"\",i=0,c=\"\",lst=\"t\",q,dt,j,cc;var hr=\"H\";while(i<fmt.length){switch(c=fmt[i]){case\"G\":if(!isgeneral(fmt,i))throw new Error(\"unrecognized character \"+c+\" in \"+fmt);out[out.length]={t:\"G\",v:\"General\"};i+=7;break;case'\"':for(o=\"\";(cc=fmt.charCodeAt(++i))!==34&&i<fmt.length;)o+=String.fromCharCode(cc);out[out.length]={t:\"t\",v:o};++i;break;case\"\\\\\":var w=fmt[++i],t=w===\"(\"||w===\")\"?w:\"t\";out[out.length]={t:t,v:w};++i;break;case\"_\":out[out.length]={t:\"t\",v:\" \"};i+=2;break;case\"@\":out[out.length]={t:\"T\",v:v};++i;break;case\"B\":case\"b\":if(fmt[i+1]===\"1\"||fmt[i+1]===\"2\"){if(dt==null){dt=parse_date_code(v,opts,fmt[i+1]===\"2\");if(dt==null)return\"\"}out[out.length]={t:\"X\",v:fmt.substr(i,2)};lst=c;i+=2;break}case\"M\":case\"D\":case\"Y\":case\"H\":case\"S\":case\"E\":c=c.toLowerCase();case\"m\":case\"d\":case\"y\":case\"h\":case\"s\":case\"e\":case\"g\":if(v<0)return\"\";if(dt==null){dt=parse_date_code(v,opts);if(dt==null)return\"\"}o=c;while(++i<fmt.length&&fmt[i].toLowerCase()===c)o+=c;if(c===\"m\"&&lst.toLowerCase()===\"h\")c=\"M\";if(c===\"h\")c=hr;out[out.length]={t:c,v:o};lst=c;break;case\"A\":q={t:c,v:\"A\"};if(dt==null)dt=parse_date_code(v,opts);if(fmt.substr(i,3)===\"A/P\"){if(dt!=null)q.v=dt.H>=12?\"P\":\"A\";q.t=\"T\";hr=\"h\";i+=3}else if(fmt.substr(i,5)===\"AM/PM\"){if(dt!=null)q.v=dt.H>=12?\"PM\":\"AM\";q.t=\"T\";i+=5;hr=\"h\"}else{q.t=\"t\";++i}if(dt==null&&q.t===\"T\")return\"\";out[out.length]=q;lst=c;break;case\"[\":o=c;while(fmt[i++]!==\"]\"&&i<fmt.length)o+=fmt[i];if(o.substr(-1)!==\"]\")throw'unterminated \"[\" block: |'+o+\"|\";if(o.match(abstime)){if(dt==null){dt=parse_date_code(v,opts);if(dt==null)return\"\"}out[out.length]={t:\"Z\",v:o.toLowerCase()}}else{o=\"\"}break;case\".\":if(dt!=null){o=c;while((c=fmt[++i])===\"0\")o+=c;out[out.length]={t:\"s\",v:o};break}case\"0\":case\"#\":o=c;while(\"0#?.,E+-%\".indexOf(c=fmt[++i])>-1||c==\"\\\\\"&&fmt[i+1]==\"-\"&&\"0#\".indexOf(fmt[i+2])>-1)o+=c;out[out.length]={t:\"n\",v:o};break;case\"?\":o=c;while(fmt[++i]===c)o+=c;q={t:c,v:o};out[out.length]=q;lst=c;break;case\"*\":++i;if(fmt[i]==\" \"||fmt[i]==\"*\")++i;break;case\"(\":case\")\":out[out.length]={t:flen===1?\"t\":c,v:c};++i;break;case\"1\":case\"2\":case\"3\":case\"4\":case\"5\":case\"6\":case\"7\":case\"8\":case\"9\":o=c;while(\"0123456789\".indexOf(fmt[++i])>-1)o+=fmt[i];out[out.length]={t:\"D\",v:o};break;case\" \":out[out.length]={t:c,v:c};++i;break;default:if(\",$-+/():!^&'~{}<>=\u20acacfijklopqrtuvwxz\".indexOf(c)===-1)throw new Error(\"unrecognized character \"+c+\" in \"+fmt);out[out.length]={t:\"t\",v:c};++i;break}}var bt=0,ss0=0,ssm;for(i=out.length-1,lst=\"t\";i>=0;--i){switch(out[i].t){case\"h\":case\"H\":out[i].t=hr;lst=\"h\";if(bt<1)bt=1;break;case\"s\":if(ssm=out[i].v.match(/\\.0+$/))ss0=Math.max(ss0,ssm[0].length-1);if(bt<3)bt=3;case\"d\":case\"y\":case\"M\":case\"e\":lst=out[i].t;break;case\"m\":if(lst===\"s\"){out[i].t=\"M\";if(bt<2)bt=2}break;case\"X\":if(out[i].v===\"B2\");break;case\"Z\":if(bt<1&&out[i].v.match(/[Hh]/))bt=1;if(bt<2&&out[i].v.match(/[Mm]/))bt=2;if(bt<3&&out[i].v.match(/[Ss]/))bt=3}}switch(bt){case 0:break;case 1:if(dt.u>=.5){dt.u=0;++dt.S}if(dt.S>=60){dt.S=0;++dt.M}if(dt.M>=60){dt.M=0;++dt.H}break;case 2:if(dt.u>=.5){dt.u=0;++dt.S}if(dt.S>=60){dt.S=0;++dt.M}break}var nstr=\"\",jj;for(i=0;i<out.length;++i){switch(out[i].t){case\"t\":case\"T\":case\" \":case\"D\":break;case\"X\":out[i]=undefined;break;case\"d\":case\"m\":case\"y\":case\"h\":case\"H\":case\"M\":case\"s\":case\"e\":case\"b\":case\"Z\":out[i].v=write_date(out[i].t.charCodeAt(0),out[i].v,dt,ss0);out[i].t=\"t\";break;case\"n\":case\"(\":case\"?\":jj=i+1;while(out[jj]!=null&&((c=out[jj].t)===\"?\"||c===\"D\"||(c===\" \"||c===\"t\")&&out[jj+1]!=null&&(out[jj+1].t===\"?\"||out[jj+1].t===\"t\"&&out[jj+1].v===\"/\")||out[i].t===\"(\"&&(c===\" \"||c===\"n\"||c===\")\")||c===\"t\"&&(out[jj].v===\"/\"||\"$\u20ac\".indexOf(out[jj].v)>-1||out[jj].v===\" \"&&out[jj+1]!=null&&out[jj+1].t==\"?\"))){out[i].v+=out[jj].v;out[jj]=undefined;++jj}nstr+=out[i].v;i=jj-1;break;case\"G\":out[i].t=\"t\";out[i].v=general_fmt(v,opts);break}}var vv=\"\",myv,ostr;if(nstr.length>0){myv=v<0&&nstr.charCodeAt(0)===45?-v:v;ostr=write_num(nstr.charCodeAt(0)===40?\"(\":\"n\",nstr,myv);jj=ostr.length-1;var decpt=out.length;for(i=0;i<out.length;++i)if(out[i]!=null&&out[i].v.indexOf(\".\")>-1){decpt=i;break}var lasti=out.length;if(decpt===out.length&&ostr.indexOf(\"E\")===-1){for(i=out.length-1;i>=0;--i){if(out[i]==null||\"n?(\".indexOf(out[i].t)===-1)continue;if(jj>=out[i].v.length-1){jj-=out[i].v.length;out[i].v=ostr.substr(jj+1,out[i].v.length)}else if(jj<0)out[i].v=\"\";else{out[i].v=ostr.substr(0,jj+1);jj=-1}out[i].t=\"t\";lasti=i}if(jj>=0&&lasti<out.length)out[lasti].v=ostr.substr(0,jj+1)+out[lasti].v}else if(decpt!==out.length&&ostr.indexOf(\"E\")===-1){jj=ostr.indexOf(\".\")-1;for(i=decpt;i>=0;--i){if(out[i]==null||\"n?(\".indexOf(out[i].t)===-1)continue;j=out[i].v.indexOf(\".\")>-1&&i===decpt?out[i].v.indexOf(\".\")-1:out[i].v.length-1;vv=out[i].v.substr(j+1);for(;j>=0;--j){if(jj>=0&&(out[i].v[j]===\"0\"||out[i].v[j]===\"#\"))vv=ostr[jj--]+vv}out[i].v=vv;out[i].t=\"t\";lasti=i}if(jj>=0&&lasti<out.length)out[lasti].v=ostr.substr(0,jj+1)+out[lasti].v;jj=ostr.indexOf(\".\")+1;for(i=decpt;i<out.length;++i){if(out[i]==null||\"n?(\".indexOf(out[i].t)===-1&&i!==decpt)continue;j=out[i].v.indexOf(\".\")>-1&&i===decpt?out[i].v.indexOf(\".\")+1:0;vv=out[i].v.substr(0,j);for(;j<out[i].v.length;++j){if(jj<ostr.length)vv+=ostr[jj++]}out[i].v=vv;out[i].t=\"t\";lasti=i}}}for(i=0;i<out.length;++i)if(out[i]!=null&&\"n(?\".indexOf(out[i].t)>-1){myv=flen>1&&v<0&&i>0&&out[i-1].v===\"-\"?-v:v;out[i].v=write_num(out[i].t,out[i].v,myv);out[i].t=\"t\"}var retval=\"\";for(i=0;i!==out.length;++i)if(out[i]!=null)retval+=out[i].v;return retval}SSF._eval=eval_fmt;var cfregex=/\\[[=<>]/;var cfregex2=/\\[([=<>]*)(-?\\d+\\.?\\d*)\\]/;function chkcond(v,rr){if(rr==null)return false;var thresh=parseFloat(rr[2]);switch(rr[1]){case\"=\":if(v==thresh)return true;break;case\">\":if(v>thresh)return true;break;case\"<\":if(v<thresh)return true;break;case\"<>\":if(v!=thresh)return true;break;case\">=\":if(v>=thresh)return true;break;case\"<=\":if(v<=thresh)return true;break}return false}function choose_fmt(f,v){var fmt=split_fmt(f);var l=fmt.length,lat=fmt[l-1].indexOf(\"@\");if(l<4&&lat>-1)--l;if(fmt.length>4)throw\"cannot find right format for |\"+fmt+\"|\";if(typeof v!==\"number\")return[4,fmt.length===4||lat>-1?fmt[fmt.length-1]:\"@\"];switch(fmt.length){case 1:fmt=lat>-1?[\"General\",\"General\",\"General\",fmt[0]]:[fmt[0],fmt[0],fmt[0],\"@\"];break;case 2:fmt=lat>-1?[fmt[0],fmt[0],fmt[0],fmt[1]]:[fmt[0],fmt[1],fmt[0],\"@\"];break;case 3:fmt=lat>-1?[fmt[0],fmt[1],fmt[0],fmt[2]]:[fmt[0],fmt[1],fmt[2],\"@\"];break;case 4:break}var ff=v>0?fmt[0]:v<0?fmt[1]:fmt[2];if(fmt[0].indexOf(\"[\")===-1&&fmt[1].indexOf(\"[\")===-1)return[l,ff];if(fmt[0].match(cfregex)!=null||fmt[1].match(cfregex)!=null){var m1=fmt[0].match(cfregex2);var m2=fmt[1].match(cfregex2);return chkcond(v,m1)?[l,fmt[0]]:chkcond(v,m2)?[l,fmt[1]]:[l,fmt[m1!=null&&m2!=null?2:1]]}return[l,ff]}function format(fmt,v,o){fixopts(o!=null?o:o=[]);var sfmt=\"\";switch(typeof fmt){case\"string\":sfmt=fmt;break;case\"number\":sfmt=(o.table!=null?o.table:table_fmt)[fmt];break}if(isgeneral(sfmt,0))return general_fmt(v,o);var f=choose_fmt(sfmt,v);if(isgeneral(f[1]))return general_fmt(v,o);if(v===true)v=\"TRUE\";else if(v===false)v=\"FALSE\";else if(v===\"\"||v==null)return\"\";return eval_fmt(f[1],v,o,f[0])}SSF._table=table_fmt;SSF.load=function load_entry(fmt,idx){table_fmt[idx]=fmt};SSF.format=format;SSF.get_table=function get_table(){return table_fmt};SSF.load_table=function load_table(tbl){for(var i=0;i!=392;++i)if(tbl[i]!==undefined)SSF.load(tbl[i],i)}};make_ssf(SSF);var XLMLFormatMap={\"General Number\":\"General\",\"General Date\":SSF._table[22],\"Long Date\":\"dddd, mmmm dd, yyyy\",\"Medium Date\":SSF._table[15],\"Short Date\":SSF._table[14],\"Long Time\":SSF._table[19],\"Medium Time\":SSF._table[18],\"Short Time\":SSF._table[20],Currency:'\"$\"#,##0.00_);[Red]\\\\(\"$\"#,##0.00\\\\)',Fixed:SSF._table[2],Standard:SSF._table[4],Percent:SSF._table[10],Scientific:SSF._table[11],\"Yes/No\":'\"Yes\";\"Yes\";\"No\";@',\"True/False\":'\"True\";\"True\";\"False\";@',\"On/Off\":'\"Yes\";\"Yes\";\"No\";@'};var DO_NOT_EXPORT_CFB=true;var CFB=function _CFB(){var exports={};exports.version=\"0.10.2\";function parse(file){var mver=3;var ssz=512;var nmfs=0;var ndfs=0;var dir_start=0;var minifat_start=0;var difat_start=0;var fat_addrs=[];var blob=file.slice(0,512);prep_blob(blob,0);var mv=check_get_mver(blob);mver=mv[0];switch(mver){case 3:ssz=512;break;case 4:ssz=4096;break;default:throw\"Major Version: Expected 3 or 4 saw \"+mver}if(ssz!==512){blob=file.slice(0,ssz);prep_blob(blob,28)}var header=file.slice(0,ssz);check_shifts(blob,mver);var nds=blob.read_shift(4,\"i\");if(mver===3&&nds!==0)throw\"# Directory Sectors: Expected 0 saw \"+nds;blob.l+=4;dir_start=blob.read_shift(4,\"i\");blob.l+=4;blob.chk(\"00100000\",\"Mini Stream Cutoff Size: \");minifat_start=blob.read_shift(4,\"i\");nmfs=blob.read_shift(4,\"i\");difat_start=blob.read_shift(4,\"i\");ndfs=blob.read_shift(4,\"i\");for(var q,j=0;j<109;++j){q=blob.read_shift(4,\"i\");if(q<0)break;fat_addrs[j]=q}var sectors=sectorify(file,ssz);sleuth_fat(difat_start,ndfs,sectors,ssz,fat_addrs);var sector_list=make_sector_list(sectors,dir_start,fat_addrs,ssz);sector_list[dir_start].name=\"!Directory\";if(nmfs>0&&minifat_start!==ENDOFCHAIN)sector_list[minifat_start].name=\"!MiniFAT\";sector_list[fat_addrs[0]].name=\"!FAT\";sector_list.fat_addrs=fat_addrs;sector_list.ssz=ssz;var files={},Paths=[],FileIndex=[],FullPaths=[],FullPathDir={};read_directory(dir_start,sector_list,sectors,Paths,nmfs,files,FileIndex);build_full_paths(FileIndex,FullPathDir,FullPaths,Paths);var root_name=Paths.shift();Paths.root=root_name;var find_path=make_find_path(FullPaths,Paths,FileIndex,files,root_name);return{raw:{header:header,sectors:sectors},FileIndex:FileIndex,FullPaths:FullPaths,FullPathDir:FullPathDir,find:find_path}}function check_get_mver(blob){blob.chk(HEADER_SIGNATURE,\"Header Signature: \");blob.chk(HEADER_CLSID,\"CLSID: \");var mver=blob.read_shift(2,\"u\");return[blob.read_shift(2,\"u\"),mver]}function check_shifts(blob,mver){var shift=9;blob.chk(\"feff\",\"Byte Order: \");switch(shift=blob.read_shift(2)){case 9:if(mver!==3)throw\"MajorVersion/SectorShift Mismatch\";break;case 12:if(mver!==4)throw\"MajorVersion/SectorShift Mismatch\";break;default:throw\"Sector Shift: Expected 9 or 12 saw \"+shift}blob.chk(\"0600\",\"Mini Sector Shift: \");blob.chk(\"000000000000\",\"Reserved: \")}function sectorify(file,ssz){var nsectors=Math.ceil(file.length/ssz)-1;var sectors=new Array(nsectors);for(var i=1;i<nsectors;++i)sectors[i-1]=file.slice(i*ssz,(i+1)*ssz);sectors[nsectors-1]=file.slice(nsectors*ssz);return sectors}function build_full_paths(FI,FPD,FP,Paths){var i=0,L=0,R=0,C=0,j=0,pl=Paths.length;var dad=new Array(pl),q=new Array(pl);for(;i<pl;++i){dad[i]=q[i]=i;FP[i]=Paths[i]}for(;j<q.length;++j){i=q[j];L=FI[i].L;R=FI[i].R;C=FI[i].C;if(dad[i]===i){if(L!==-1&&dad[L]!==L)dad[i]=dad[L];if(R!==-1&&dad[R]!==R)dad[i]=dad[R]}if(C!==-1)dad[C]=i;if(L!==-1){dad[L]=dad[i];q.push(L)}if(R!==-1){dad[R]=dad[i];q.push(R)}}for(i=1;i!==pl;++i)if(dad[i]===i){if(R!==-1&&dad[R]!==R)dad[i]=dad[R];else if(L!==-1&&dad[L]!==L)dad[i]=dad[L]}for(i=1;i<pl;++i){if(FI[i].type===0)continue;j=dad[i];if(j===0)FP[i]=FP[0]+\"/\"+FP[i];else while(j!==0){FP[i]=FP[j]+\"/\"+FP[i];j=dad[j]}dad[i]=0}FP[0]+=\"/\";for(i=1;i<pl;++i){if(FI[i].type!==2)FP[i]+=\"/\";FPD[FP[i]]=FI[i]}}function make_find_path(FullPaths,Paths,FileIndex,files,root_name){var UCFullPaths=new Array(FullPaths.length);var UCPaths=new Array(Paths.length),i;for(i=0;i<FullPaths.length;++i)UCFullPaths[i]=FullPaths[i].toUpperCase().replace(chr0,\"\").replace(chr1,\"!\");for(i=0;i<Paths.length;++i)UCPaths[i]=Paths[i].toUpperCase().replace(chr0,\"\").replace(chr1,\"!\");return function find_path(path){var k;if(path.charCodeAt(0)===47){k=true;path=root_name+path}else k=path.indexOf(\"/\")!==-1;var UCPath=path.toUpperCase().replace(chr0,\"\").replace(chr1,\"!\");var w=k===true?UCFullPaths.indexOf(UCPath):UCPaths.indexOf(UCPath);if(w===-1)return null;return k===true?FileIndex[w]:files[Paths[w]]}}function sleuth_fat(idx,cnt,sectors,ssz,fat_addrs){var q;if(idx===ENDOFCHAIN){if(cnt!==0)throw\"DIFAT chain shorter than expected\"}else if(idx!==-1){var sector=sectors[idx],m=(ssz>>>2)-1;for(var i=0;i<m;++i){if((q=__readInt32LE(sector,i*4))===ENDOFCHAIN)break;fat_addrs.push(q)}sleuth_fat(__readInt32LE(sector,ssz-4),cnt-1,sectors,ssz,fat_addrs)}}function get_sector_list(sectors,start,fat_addrs,ssz,chkd){var sl=sectors.length;var buf,buf_chain;if(!chkd)chkd=new Array(sl);var modulus=ssz-1,j,jj;buf=[];buf_chain=[];for(j=start;j>=0;){chkd[j]=true;buf[buf.length]=j;buf_chain.push(sectors[j]);var addr=fat_addrs[Math.floor(j*4/ssz)];\njj=j*4&modulus;if(ssz<4+jj)throw\"FAT boundary crossed: \"+j+\" 4 \"+ssz;j=__readInt32LE(sectors[addr],jj)}return{nodes:buf,data:__toBuffer([buf_chain])}}function make_sector_list(sectors,dir_start,fat_addrs,ssz){var sl=sectors.length,sector_list=new Array(sl);var chkd=new Array(sl),buf,buf_chain;var modulus=ssz-1,i,j,k,jj;for(i=0;i<sl;++i){buf=[];k=i+dir_start;if(k>=sl)k-=sl;if(chkd[k]===true)continue;buf_chain=[];for(j=k;j>=0;){chkd[j]=true;buf[buf.length]=j;buf_chain.push(sectors[j]);var addr=fat_addrs[Math.floor(j*4/ssz)];jj=j*4&modulus;if(ssz<4+jj)throw\"FAT boundary crossed: \"+j+\" 4 \"+ssz;j=__readInt32LE(sectors[addr],jj)}sector_list[k]={nodes:buf,data:__toBuffer([buf_chain])}}return sector_list}function read_directory(dir_start,sector_list,sectors,Paths,nmfs,files,FileIndex){var blob;var minifat_store=0,pl=Paths.length?2:0;var sector=sector_list[dir_start].data;var i=0,namelen=0,name,o,ctime,mtime;for(;i<sector.length;i+=128){blob=sector.slice(i,i+128);prep_blob(blob,64);namelen=blob.read_shift(2);if(namelen===0)continue;name=__utf16le(blob,0,namelen-pl);Paths.push(name);o={name:name,type:blob.read_shift(1),color:blob.read_shift(1),L:blob.read_shift(4,\"i\"),R:blob.read_shift(4,\"i\"),C:blob.read_shift(4,\"i\"),clsid:blob.read_shift(16),state:blob.read_shift(4,\"i\")};ctime=blob.read_shift(2)+blob.read_shift(2)+blob.read_shift(2)+blob.read_shift(2);if(ctime!==0){o.ctime=ctime;o.ct=read_date(blob,blob.l-8)}mtime=blob.read_shift(2)+blob.read_shift(2)+blob.read_shift(2)+blob.read_shift(2);if(mtime!==0){o.mtime=mtime;o.mt=read_date(blob,blob.l-8)}o.start=blob.read_shift(4,\"i\");o.size=blob.read_shift(4,\"i\");if(o.type===5){minifat_store=o.start;if(nmfs>0&&minifat_store!==ENDOFCHAIN)sector_list[minifat_store].name=\"!StreamData\"}else if(o.size>=4096){o.storage=\"fat\";if(sector_list[o.start]===undefined)sector_list[o.start]=get_sector_list(sectors,o.start,sector_list.fat_addrs,sector_list.ssz);sector_list[o.start].name=o.name;o.content=sector_list[o.start].data.slice(0,o.size);prep_blob(o.content,0)}else{o.storage=\"minifat\";if(minifat_store!==ENDOFCHAIN&&o.start!==ENDOFCHAIN){o.content=sector_list[minifat_store].data.slice(o.start*MSSZ,o.start*MSSZ+o.size);prep_blob(o.content,0)}}files[name]=o;FileIndex.push(o)}}function read_date(blob,offset){return new Date((__readUInt32LE(blob,offset+4)/1e7*Math.pow(2,32)+__readUInt32LE(blob,offset)/1e7-11644473600)*1e3)}var fs;function readFileSync(filename,options){if(fs===undefined)fs=require(\"fs\");return parse(fs.readFileSync(filename),options)}function readSync(blob,options){switch(options!==undefined&&options.type!==undefined?options.type:\"base64\"){case\"file\":return readFileSync(blob,options);case\"base64\":return parse(s2a(Base64.decode(blob)),options);case\"binary\":return parse(s2a(blob),options)}return parse(blob)}var MSSZ=64;var ENDOFCHAIN=-2;var HEADER_SIGNATURE=\"d0cf11e0a1b11ae1\";var HEADER_CLSID=\"00000000000000000000000000000000\";var consts={MAXREGSECT:-6,DIFSECT:-4,FATSECT:-3,ENDOFCHAIN:ENDOFCHAIN,FREESECT:-1,HEADER_SIGNATURE:HEADER_SIGNATURE,HEADER_MINOR_VERSION:\"3e00\",MAXREGSID:-6,NOSTREAM:-1,HEADER_CLSID:HEADER_CLSID,EntryTypes:[\"unknown\",\"storage\",\"stream\",\"lockbytes\",\"property\",\"root\"]};exports.read=readSync;exports.parse=parse;exports.utils={ReadShift:ReadShift,CheckField:CheckField,prep_blob:prep_blob,bconcat:bconcat,consts:consts};return exports}();if(typeof require!==\"undefined\"&&typeof module!==\"undefined\"&&typeof DO_NOT_EXPORT_CFB===\"undefined\"){module.exports=CFB}function isval(x){return x!==undefined&&x!==null}function keys(o){return Object.keys(o)}function evert_key(obj,key){var o=[],K=keys(obj);for(var i=0;i!==K.length;++i)o[obj[K[i]][key]]=K[i];return o}function evert(obj){var o=[],K=keys(obj);for(var i=0;i!==K.length;++i)o[obj[K[i]]]=K[i];return o}function evert_num(obj){var o=[],K=keys(obj);for(var i=0;i!==K.length;++i)o[obj[K[i]]]=parseInt(K[i],10);return o}function evert_arr(obj){var o=[],K=keys(obj);for(var i=0;i!==K.length;++i){if(o[obj[K[i]]]==null)o[obj[K[i]]]=[];o[obj[K[i]]].push(K[i])}return o}function datenum(v,date1904){if(date1904)v+=1462;var epoch=Date.parse(v);return(epoch+22091616e5)/(24*60*60*1e3)}function cc2str(arr){var o=\"\";for(var i=0;i!=arr.length;++i)o+=String.fromCharCode(arr[i]);return o}function getdata(data){if(!data)return null;if(data.name.substr(-4)===\".bin\"){if(data.data)return char_codes(data.data);if(data.asNodeBuffer&&has_buf)return data.asNodeBuffer();if(data._data&&data._data.getContent)return Array.prototype.slice.call(data._data.getContent())}else{if(data.data)return data.name.substr(-4)!==\".bin\"?debom_xml(data.data):char_codes(data.data);if(data.asNodeBuffer&&has_buf)return debom_xml(data.asNodeBuffer().toString(\"binary\"));if(data.asBinary)return debom_xml(data.asBinary());if(data._data&&data._data.getContent)return debom_xml(cc2str(Array.prototype.slice.call(data._data.getContent(),0)))}return null}function safegetzipfile(zip,file){var f=file;if(zip.files[f])return zip.files[f];f=file.toLowerCase();if(zip.files[f])return zip.files[f];f=f.replace(/\\//g,\"\\\\\");if(zip.files[f])return zip.files[f];return null}function getzipfile(zip,file){var o=safegetzipfile(zip,file);if(o==null)throw new Error(\"Cannot find file \"+file+\" in zip\");return o}function getzipdata(zip,file,safe){if(!safe)return getdata(getzipfile(zip,file));if(!file)return null;try{return getzipdata(zip,file)}catch(e){return null}}var _fs,jszip;if(typeof JSZip!==\"undefined\")jszip=JSZip;if(typeof exports!==\"undefined\"){if(typeof module!==\"undefined\"&&module.exports){if(has_buf&&typeof jszip===\"undefined\")jszip=require(\"js\"+\"zip\");if(typeof jszip===\"undefined\")jszip=require(\"./js\"+\"zip\").JSZip;_fs=require(\"f\"+\"s\")}}var attregexg=/([\\w:]+)=((?:\")([^\"]*)(?:\")|(?:')([^']*)(?:'))/g;var tagregex=/<[^>]*>/g;var nsregex=/<\\w*:/,nsregex2=/<(\\/?)\\w+:/;function parsexmltag(tag,skip_root){var z=[];var eq=0,c=0;for(;eq!==tag.length;++eq)if((c=tag.charCodeAt(eq))===32||c===10||c===13)break;if(!skip_root)z[0]=tag.substr(0,eq);if(eq===tag.length)return z;var m=tag.match(attregexg),j=0,w=\"\",v=\"\",i=0,q=\"\",cc=\"\";if(m)for(i=0;i!=m.length;++i){cc=m[i];for(c=0;c!=cc.length;++c)if(cc.charCodeAt(c)===61)break;q=cc.substr(0,c);v=cc.substring(c+2,cc.length-1);for(j=0;j!=q.length;++j)if(q.charCodeAt(j)===58)break;if(j===q.length)z[q]=v;else z[(j===5&&q.substr(0,5)===\"xmlns\"?\"xmlns\":\"\")+q.substr(j+1)]=v}return z}function strip_ns(x){return x.replace(nsregex2,\"<$1\")}var encodings={\"&quot;\":'\"',\"&apos;\":\"'\",\"&gt;\":\">\",\"&lt;\":\"<\",\"&amp;\":\"&\"};var rencoding=evert(encodings);var rencstr=\"&<>'\\\"\".split(\"\");var unescapexml=function(){var encregex=/&[a-z]*;/g,coderegex=/_x([\\da-fA-F]+)_/g;return function unescapexml(text){var s=text+\"\";return s.replace(encregex,function($$){return encodings[$$]}).replace(coderegex,function(m,c){return String.fromCharCode(parseInt(c,16))})}}();var decregex=/[&<>'\"]/g,charegex=/[\\u0000-\\u0008\\u000b-\\u001f]/g;function escapexml(text){var s=text+\"\";return s.replace(decregex,function(y){return rencoding[y]}).replace(charegex,function(s){return\"_x\"+(\"000\"+s.charCodeAt(0).toString(16)).substr(-4)+\"_\"})}var xlml_fixstr=function(){var entregex=/&#(\\d+);/g;function entrepl($$,$1){return String.fromCharCode(parseInt($1,10))}return function xlml_fixstr(str){return str.replace(entregex,entrepl)}}();function parsexmlbool(value,tag){switch(value){case\"1\":case\"true\":case\"TRUE\":return true;default:return false}}var utf8read=function utf8reada(orig){var out=\"\",i=0,c=0,d=0,e=0,f=0,w=0;while(i<orig.length){c=orig.charCodeAt(i++);if(c<128){out+=String.fromCharCode(c);continue}d=orig.charCodeAt(i++);if(c>191&&c<224){out+=String.fromCharCode((c&31)<<6|d&63);continue}e=orig.charCodeAt(i++);if(c<240){out+=String.fromCharCode((c&15)<<12|(d&63)<<6|e&63);continue}f=orig.charCodeAt(i++);w=((c&7)<<18|(d&63)<<12|(e&63)<<6|f&63)-65536;out+=String.fromCharCode(55296+(w>>>10&1023));out+=String.fromCharCode(56320+(w&1023))}return out};if(has_buf){var utf8readb=function utf8readb(data){var out=new Buffer(2*data.length),w,i,j=1,k=0,ww=0,c;for(i=0;i<data.length;i+=j){j=1;if((c=data.charCodeAt(i))<128)w=c;else if(c<224){w=(c&31)*64+(data.charCodeAt(i+1)&63);j=2}else if(c<240){w=(c&15)*4096+(data.charCodeAt(i+1)&63)*64+(data.charCodeAt(i+2)&63);j=3}else{j=4;w=(c&7)*262144+(data.charCodeAt(i+1)&63)*4096+(data.charCodeAt(i+2)&63)*64+(data.charCodeAt(i+3)&63);w-=65536;ww=55296+(w>>>10&1023);w=56320+(w&1023)}if(ww!==0){out[k++]=ww&255;out[k++]=ww>>>8;ww=0}out[k++]=w%256;out[k++]=w>>>8}out.length=k;return out.toString(\"ucs2\")};var corpus=\"foo bar baz\u00e2\u0098\u0083\u00f0\u009f\u008d\u00a3\";if(utf8read(corpus)==utf8readb(corpus))utf8read=utf8readb;var utf8readc=function utf8readc(data){return Buffer(data,\"binary\").toString(\"utf8\")};if(utf8read(corpus)==utf8readc(corpus))utf8read=utf8readc}var matchtag=function(){var mtcache={};return function matchtag(f,g){var t=f+\"|\"+g;if(mtcache[t]!==undefined)return mtcache[t];return mtcache[t]=new RegExp(\"<(?:\\\\w+:)?\"+f+'(?: xml:space=\"preserve\")?(?:[^>]*)>([^\u2603]*)</(?:\\\\w+:)?'+f+\">\",g||\"\")}}();var vtregex=function(){var vt_cache={};return function vt_regex(bt){if(vt_cache[bt]!==undefined)return vt_cache[bt];return vt_cache[bt]=new RegExp(\"<vt:\"+bt+\">(.*?)</vt:\"+bt+\">\",\"g\")}}();var vtvregex=/<\\/?vt:variant>/g,vtmregex=/<vt:([^>]*)>(.*)</;function parseVector(data){var h=parsexmltag(data);var matches=data.match(vtregex(h.baseType))||[];if(matches.length!=h.size)throw\"unexpected vector length \"+matches.length+\" != \"+h.size;var res=[];matches.forEach(function(x){var v=x.replace(vtvregex,\"\").match(vtmregex);res.push({v:v[2],t:v[1]})});return res}var wtregex=/(^\\s|\\s$|\\n)/;function writetag(f,g){return\"<\"+f+(g.match(wtregex)?' xml:space=\"preserve\"':\"\")+\">\"+g+\"</\"+f+\">\"}function wxt_helper(h){return keys(h).map(function(k){return\" \"+k+'=\"'+h[k]+'\"'}).join(\"\")}function writextag(f,g,h){return\"<\"+f+(isval(h)?wxt_helper(h):\"\")+(isval(g)?(g.match(wtregex)?' xml:space=\"preserve\"':\"\")+\">\"+g+\"</\"+f:\"/\")+\">\"}function write_w3cdtf(d,t){try{return d.toISOString().replace(/\\.\\d*/,\"\")}catch(e){if(t)throw e}}function write_vt(s){switch(typeof s){case\"string\":return writextag(\"vt:lpwstr\",s);case\"number\":return writextag((s|0)==s?\"vt:i4\":\"vt:r8\",String(s));case\"boolean\":return writextag(\"vt:bool\",s?\"true\":\"false\")}if(s instanceof Date)return writextag(\"vt:filetime\",write_w3cdtf(s));throw new Error(\"Unable to serialize \"+s)}var XML_HEADER='<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\\r\\n';var XMLNS={dc:\"http://purl.org/dc/elements/1.1/\",dcterms:\"http://purl.org/dc/terms/\",dcmitype:\"http://purl.org/dc/dcmitype/\",mx:\"http://schemas.microsoft.com/office/mac/excel/2008/main\",r:\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\",sjs:\"http://schemas.openxmlformats.org/package/2006/sheetjs/core-properties\",vt:\"http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes\",xsi:\"http://www.w3.org/2001/XMLSchema-instance\",xsd:\"http://www.w3.org/2001/XMLSchema\"};XMLNS.main=[\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\",\"http://purl.oclc.org/ooxml/spreadsheetml/main\",\"http://schemas.microsoft.com/office/excel/2006/main\",\"http://schemas.microsoft.com/office/excel/2006/2\"];function readIEEE754(buf,idx,isLE,nl,ml){if(isLE===undefined)isLE=true;if(!nl)nl=8;if(!ml&&nl===8)ml=52;var e,m,el=nl*8-ml-1,eMax=(1<<el)-1,eBias=eMax>>1;var bits=-7,d=isLE?-1:1,i=isLE?nl-1:0,s=buf[idx+i];i+=d;e=s&(1<<-bits)-1;s>>>=-bits;bits+=el;for(;bits>0;e=e*256+buf[idx+i],i+=d,bits-=8);m=e&(1<<-bits)-1;e>>>=-bits;bits+=ml;for(;bits>0;m=m*256+buf[idx+i],i+=d,bits-=8);if(e===eMax)return m?NaN:(s?-1:1)*Infinity;else if(e===0)e=1-eBias;else{m=m+Math.pow(2,ml);e=e-eBias}return(s?-1:1)*m*Math.pow(2,e-ml)}var __toBuffer,___toBuffer;__toBuffer=___toBuffer=function toBuffer_(bufs){var x=[];for(var i=0;i<bufs[0].length;++i){x.push.apply(x,bufs[0][i])}return x};var __utf16le,___utf16le;__utf16le=___utf16le=function utf16le_(b,s,e){var ss=[];for(var i=s;i<e;i+=2)ss.push(String.fromCharCode(__readUInt16LE(b,i)));return ss.join(\"\")};var __hexlify,___hexlify;__hexlify=___hexlify=function hexlify_(b,s,l){return b.slice(s,s+l).map(function(x){return(x<16?\"0\":\"\")+x.toString(16)}).join(\"\")};var __utf8,___utf8;__utf8=___utf8=function(b,s,e){var ss=[];for(var i=s;i<e;i++)ss.push(String.fromCharCode(__readUInt8(b,i)));return ss.join(\"\")};var __lpstr,___lpstr;__lpstr=___lpstr=function lpstr_(b,i){var len=__readUInt32LE(b,i);return len>0?__utf8(b,i+4,i+4+len-1):\"\"};var __lpwstr,___lpwstr;__lpwstr=___lpwstr=function lpwstr_(b,i){var len=2*__readUInt32LE(b,i);return len>0?__utf8(b,i+4,i+4+len-1):\"\"};var __double,___double;__double=___double=function(b,idx){return readIEEE754(b,idx)};var is_buf=function is_buf_a(a){return Array.isArray(a)};if(has_buf){__utf16le=function utf16le_b(b,s,e){if(!Buffer.isBuffer(b))return ___utf16le(b,s,e);return b.toString(\"utf16le\",s,e)};__hexlify=function(b,s,l){return Buffer.isBuffer(b)?b.toString(\"hex\",s,s+l):___hexlify(b,s,l)};__lpstr=function lpstr_b(b,i){if(!Buffer.isBuffer(b))return ___lpstr(b,i);var len=b.readUInt32LE(i);return len>0?b.toString(\"utf8\",i+4,i+4+len-1):\"\"};__lpwstr=function lpwstr_b(b,i){if(!Buffer.isBuffer(b))return ___lpwstr(b,i);var len=2*b.readUInt32LE(i);return b.toString(\"utf16le\",i+4,i+4+len-1)};__utf8=function utf8_b(s,e){return this.toString(\"utf8\",s,e)};__toBuffer=function(bufs){return bufs[0].length>0&&Buffer.isBuffer(bufs[0][0])?Buffer.concat(bufs[0]):___toBuffer(bufs)};bconcat=function(bufs){return Buffer.isBuffer(bufs[0])?Buffer.concat(bufs):[].concat.apply([],bufs)};__double=function double_(b,i){if(Buffer.isBuffer(b))return b.readDoubleLE(i);return ___double(b,i)};is_buf=function is_buf_b(a){return Buffer.isBuffer(a)||Array.isArray(a)}}if(typeof cptable!==\"undefined\"){__utf16le=function(b,s,e){return cptable.utils.decode(1200,b.slice(s,e))};__utf8=function(b,s,e){return cptable.utils.decode(65001,b.slice(s,e))};__lpstr=function(b,i){var len=__readUInt32LE(b,i);return len>0?cptable.utils.decode(current_codepage,b.slice(i+4,i+4+len-1)):\"\"};__lpwstr=function(b,i){var len=2*__readUInt32LE(b,i);return len>0?cptable.utils.decode(1200,b.slice(i+4,i+4+len-1)):\"\"}}var __readUInt8=function(b,idx){return b[idx]};var __readUInt16LE=function(b,idx){return b[idx+1]*(1<<8)+b[idx]};var __readInt16LE=function(b,idx){var u=b[idx+1]*(1<<8)+b[idx];return u<32768?u:(65535-u+1)*-1};var __readUInt32LE=function(b,idx){return b[idx+3]*(1<<24)+(b[idx+2]<<16)+(b[idx+1]<<8)+b[idx]};var __readInt32LE=function(b,idx){return b[idx+3]<<24|b[idx+2]<<16|b[idx+1]<<8|b[idx]};var ___unhexlify=function(s){return s.match(/../g).map(function(x){return parseInt(x,16)})};var __unhexlify=typeof Buffer!==\"undefined\"?function(s){return Buffer.isBuffer(s)?new Buffer(s,\"hex\"):___unhexlify(s)}:___unhexlify;function ReadShift(size,t){var o=\"\",oI,oR,oo=[],w,vv,i,loc;switch(t){case\"dbcs\":loc=this.l;if(has_buf&&Buffer.isBuffer(this))o=this.slice(this.l,this.l+2*size).toString(\"utf16le\");else for(i=0;i!=size;++i){o+=String.fromCharCode(__readUInt16LE(this,loc));loc+=2}size*=2;break;case\"utf8\":o=__utf8(this,this.l,this.l+size);break;case\"utf16le\":size*=2;o=__utf16le(this,this.l,this.l+size);break;case\"lpstr\":o=__lpstr(this,this.l);size=5+o.length;break;case\"lpwstr\":o=__lpwstr(this,this.l);size=5+o.length;if(o[o.length-1]==\"\\x00\")size+=2;break;case\"cstr\":size=0;o=\"\";while((w=__readUInt8(this,this.l+size++))!==0)oo.push(_getchar(w));o=oo.join(\"\");break;case\"wstr\":size=0;o=\"\";while((w=__readUInt16LE(this,this.l+size))!==0){oo.push(_getchar(w));size+=2}size+=2;o=oo.join(\"\");break;case\"dbcs-cont\":o=\"\";loc=this.l;for(i=0;i!=size;++i){if(this.lens&&this.lens.indexOf(loc)!==-1){w=__readUInt8(this,loc);this.l=loc+1;vv=ReadShift.call(this,size-i,w?\"dbcs-cont\":\"sbcs-cont\");return oo.join(\"\")+vv}oo.push(_getchar(__readUInt16LE(this,loc)));loc+=2}o=oo.join(\"\");size*=2;break;case\"sbcs-cont\":o=\"\";loc=this.l;for(i=0;i!=size;++i){if(this.lens&&this.lens.indexOf(loc)!==-1){w=__readUInt8(this,loc);this.l=loc+1;vv=ReadShift.call(this,size-i,w?\"dbcs-cont\":\"sbcs-cont\");return oo.join(\"\")+vv}oo.push(_getchar(__readUInt8(this,loc)));loc+=1}o=oo.join(\"\");break;default:switch(size){case 1:oI=__readUInt8(this,this.l);this.l++;return oI;case 2:oI=(t===\"i\"?__readInt16LE:__readUInt16LE)(this,this.l);this.l+=2;return oI;case 4:if(t===\"i\"||(this[this.l+3]&128)===0){oI=__readInt32LE(this,this.l);this.l+=4;return oI}else{oR=__readUInt32LE(this,this.l);this.l+=4;return oR}break;case 8:if(t===\"f\"){oR=__double(this,this.l);this.l+=8;return oR}case 16:o=__hexlify(this,this.l,size);break}}this.l+=size;return o}function WriteShift(t,val,f){var size,i;if(f===\"dbcs\"){for(i=0;i!=val.length;++i)this.writeUInt16LE(val.charCodeAt(i),this.l+2*i);size=2*val.length}else switch(t){case 1:size=1;this[this.l]=val&255;break;case 3:size=3;this[this.l+2]=val&255;val>>>=8;this[this.l+1]=val&255;val>>>=8;this[this.l]=val&255;break;case 4:size=4;this.writeUInt32LE(val,this.l);break;case 8:size=8;if(f===\"f\"){this.writeDoubleLE(val,this.l);break}case 16:break;case-4:size=4;this.writeInt32LE(val,this.l);break}this.l+=size;return this}function CheckField(hexstr,fld){var m=__hexlify(this,this.l,hexstr.length>>1);if(m!==hexstr)throw fld+\"Expected \"+hexstr+\" saw \"+m;this.l+=hexstr.length>>1}function prep_blob(blob,pos){blob.l=pos;blob.read_shift=ReadShift;blob.chk=CheckField;blob.write_shift=WriteShift}function parsenoop(blob,length){blob.l+=length}function writenoop(blob,length){blob.l+=length}function new_buf(sz){var o=new_raw_buf(sz);prep_blob(o,0);return o}function recordhopper(data,cb,opts){var tmpbyte,cntbyte,length;prep_blob(data,data.l||0);while(data.l<data.length){var RT=data.read_shift(1);if(RT&128)RT=(RT&127)+((data.read_shift(1)&127)<<7);var R=XLSBRecordEnum[RT]||XLSBRecordEnum[65535];tmpbyte=data.read_shift(1);length=tmpbyte&127;for(cntbyte=1;cntbyte<4&&tmpbyte&128;++cntbyte)length+=((tmpbyte=data.read_shift(1))&127)<<7*cntbyte;var d=R.f(data,length,opts);if(cb(d,R,RT))return}}function buf_array(){var bufs=[],blksz=2048;var newblk=function ba_newblk(sz){var o=new_buf(sz);prep_blob(o,0);return o};var curbuf=newblk(blksz);var endbuf=function ba_endbuf(){curbuf.length=curbuf.l;if(curbuf.length>0)bufs.push(curbuf);curbuf=null};var next=function ba_next(sz){if(sz<curbuf.length-curbuf.l)return curbuf;endbuf();return curbuf=newblk(Math.max(sz+1,blksz))};var end=function ba_end(){endbuf();return __toBuffer([bufs])};var push=function ba_push(buf){endbuf();curbuf=buf;next(blksz)};return{next:next,push:push,end:end,_bufs:bufs}}function write_record(ba,type,payload,length){var t=evert_RE[type],l;if(!length)length=XLSBRecordEnum[t].p||(payload||[]).length||0;l=1+(t>=128?1:0)+1+length;if(length>=128)++l;if(length>=16384)++l;if(length>=2097152)++l;var o=ba.next(l);if(t<=127)o.write_shift(1,t);else{o.write_shift(1,(t&127)+128);o.write_shift(1,t>>7)}for(var i=0;i!=4;++i){if(length>=128){o.write_shift(1,(length&127)+128);length>>=7}else{o.write_shift(1,length);break}}if(length>0&&is_buf(payload))ba.push(payload)}function shift_cell_xls(cell,tgt){if(tgt.s){if(cell.cRel)cell.c+=tgt.s.c;if(cell.rRel)cell.r+=tgt.s.r}else{cell.c+=tgt.c;cell.r+=tgt.r}cell.cRel=cell.rRel=0;while(cell.c>=256)cell.c-=256;while(cell.r>=65536)cell.r-=65536;return cell}function shift_range_xls(cell,range){cell.s=shift_cell_xls(cell.s,range.s);cell.e=shift_cell_xls(cell.e,range.s);return cell}var OFFCRYPTO={};var make_offcrypto=function(O,_crypto){var crypto;if(typeof _crypto!==\"undefined\")crypto=_crypto;else if(typeof require!==\"undefined\"){try{crypto=require(\"cry\"+\"pto\")}catch(e){crypto=null}}O.rc4=function(key,data){var S=new Array(256);var c=0,i=0,j=0,t=0;for(i=0;i!=256;++i)S[i]=i;for(i=0;i!=256;++i){j=j+S[i]+key[i%key.length].charCodeAt(0)&255;t=S[i];S[i]=S[j];S[j]=t}i=j=0;out=Buffer(data.length);for(c=0;c!=data.length;++c){i=i+1&255;j=(j+S[i])%256;t=S[i];S[i]=S[j];S[j]=t;out[c]=data[c]^S[S[i]+S[j]&255]}return out};if(crypto){O.md5=function(hex){return crypto.createHash(\"md5\").update(hex).digest(\"hex\")}}else{O.md5=function(hex){throw\"unimplemented\"}}};make_offcrypto(OFFCRYPTO,typeof crypto!==\"undefined\"?crypto:undefined);function parse_StrRun(data,length){return{ich:data.read_shift(2),ifnt:data.read_shift(2)}}function parse_RichStr(data,length){var start=data.l;var flags=data.read_shift(1);var str=parse_XLWideString(data);var rgsStrRun=[];var z={t:str,h:str};if((flags&1)!==0){var dwSizeStrRun=data.read_shift(4);for(var i=0;i!=dwSizeStrRun;++i)rgsStrRun.push(parse_StrRun(data));z.r=rgsStrRun}else z.r=\"<t>\"+escapexml(str)+\"</t>\";if((flags&2)!==0){}data.l=start+length;return z}function write_RichStr(str,o){if(o==null)o=new_buf(5+2*str.t.length);o.write_shift(1,0);write_XLWideString(str.t,o);return o}function parse_XLSBCell(data){var col=data.read_shift(4);var iStyleRef=data.read_shift(2);iStyleRef+=data.read_shift(1)<<16;var fPhShow=data.read_shift(1);return{c:col,iStyleRef:iStyleRef}}function write_XLSBCell(cell,o){if(o==null)o=new_buf(8);o.write_shift(-4,cell.c);o.write_shift(3,cell.iStyleRef===undefined?cell.iStyleRef:cell.s);o.write_shift(1,0);return o}function parse_XLSBCodeName(data,length){return parse_XLWideString(data,length)}function parse_XLNullableWideString(data){var cchCharacters=data.read_shift(4);return cchCharacters===0||cchCharacters===4294967295?\"\":data.read_shift(cchCharacters,\"dbcs\")}function write_XLNullableWideString(data,o){if(!o)o=new_buf(127);o.write_shift(4,data.length>0?data.length:4294967295);if(data.length>0)o.write_shift(0,data,\"dbcs\");return o}function parse_XLWideString(data){var cchCharacters=data.read_shift(4);return cchCharacters===0?\"\":data.read_shift(cchCharacters,\"dbcs\")}function write_XLWideString(data,o){if(o==null)o=new_buf(4+2*data.length);o.write_shift(4,data.length);if(data.length>0)o.write_shift(0,data,\"dbcs\");return o}var parse_RelID=parse_XLNullableWideString;var write_RelID=write_XLNullableWideString;function parse_RkNumber(data){var b=data.slice(data.l,data.l+4);var fX100=b[0]&1,fInt=b[0]&2;data.l+=4;b[0]&=252;var RK=fInt===0?__double([0,0,0,0,b[0],b[1],b[2],b[3]],0):__readInt32LE(b,0)>>2;return fX100?RK/100:RK}function parse_UncheckedRfX(data){var cell={s:{},e:{}};cell.s.r=data.read_shift(4);cell.e.r=data.read_shift(4);cell.s.c=data.read_shift(4);cell.e.c=data.read_shift(4);return cell}function write_UncheckedRfX(r,o){if(!o)o=new_buf(16);o.write_shift(4,r.s.r);o.write_shift(4,r.e.r);o.write_shift(4,r.s.c);o.write_shift(4,r.e.c);return o}function parse_Xnum(data,length){return data.read_shift(8,\"f\")}function write_Xnum(data,o){return(o||new_buf(8)).write_shift(8,\"f\",data)}var BErr={0:\"#NULL!\",7:\"#DIV/0!\",15:\"#VALUE!\",23:\"#REF!\",29:\"#NAME?\",36:\"#NUM!\",42:\"#N/A\",43:\"#GETTING_DATA\",255:\"#WTF?\"};var RBErr=evert_num(BErr);function parse_BrtColor(data,length){var out={};var d=data.read_shift(1);out.fValidRGB=d&1;out.xColorType=d>>>1;out.index=data.read_shift(1);out.nTintAndShade=data.read_shift(2,\"i\");out.bRed=data.read_shift(1);out.bGreen=data.read_shift(1);out.bBlue=data.read_shift(1);out.bAlpha=data.read_shift(1)}function parse_FontFlags(data,length){var d=data.read_shift(1);data.l++;var out={fItalic:d&2,fStrikeout:d&8,fOutline:d&16,fShadow:d&32,fCondense:d&64,fExtend:d&128};return out}{var VT_EMPTY=0;var VT_NULL=1;var VT_I2=2;var VT_I4=3;var VT_R4=4;var VT_R8=5;var VT_CY=6;var VT_DATE=7;var VT_BSTR=8;var VT_ERROR=10;var VT_BOOL=11;var VT_VARIANT=12;var VT_DECIMAL=14;var VT_I1=16;var VT_UI1=17;var VT_UI2=18;var VT_UI4=19;var VT_I8=20;var VT_UI8=21;var VT_INT=22;var VT_UINT=23;var VT_LPSTR=30;var VT_LPWSTR=31;var VT_FILETIME=64;var VT_BLOB=65;var VT_STREAM=66;var VT_STORAGE=67;var VT_STREAMED_Object=68;var VT_STORED_Object=69;var VT_BLOB_Object=70;var VT_CF=71;var VT_CLSID=72;var VT_VERSIONED_STREAM=73;var VT_VECTOR=4096;var VT_ARRAY=8192;var VT_STRING=80;var VT_USTR=81;var VT_CUSTOM=[VT_STRING,VT_USTR]}var DocSummaryPIDDSI={1:{n:\"CodePage\",t:VT_I2},2:{n:\"Category\",t:VT_STRING},3:{n:\"PresentationFormat\",t:VT_STRING},4:{n:\"ByteCount\",t:VT_I4},5:{n:\"LineCount\",t:VT_I4},6:{n:\"ParagraphCount\",t:VT_I4},7:{n:\"SlideCount\",t:VT_I4},8:{n:\"NoteCount\",t:VT_I4},9:{n:\"HiddenCount\",t:VT_I4},10:{n:\"MultimediaClipCount\",t:VT_I4},11:{n:\"Scale\",t:VT_BOOL},12:{n:\"HeadingPair\",t:VT_VECTOR|VT_VARIANT},13:{n:\"DocParts\",t:VT_VECTOR|VT_LPSTR},14:{n:\"Manager\",t:VT_STRING},15:{n:\"Company\",t:VT_STRING},16:{n:\"LinksDirty\",t:VT_BOOL},17:{n:\"CharacterCount\",t:VT_I4},19:{n:\"SharedDoc\",t:VT_BOOL},22:{n:\"HLinksChanged\",t:VT_BOOL},23:{n:\"AppVersion\",t:VT_I4,p:\"version\"},26:{n:\"ContentType\",t:VT_STRING},27:{n:\"ContentStatus\",t:VT_STRING},28:{n:\"Language\",t:VT_STRING},29:{n:\"Version\",t:VT_STRING},255:{}};var SummaryPIDSI={1:{n:\"CodePage\",t:VT_I2},2:{n:\"Title\",t:VT_STRING},3:{n:\"Subject\",t:VT_STRING},4:{n:\"Author\",t:VT_STRING},5:{n:\"Keywords\",t:VT_STRING},6:{n:\"Comments\",t:VT_STRING},7:{n:\"Template\",t:VT_STRING},8:{n:\"LastAuthor\",t:VT_STRING},9:{n:\"RevNumber\",t:VT_STRING},10:{n:\"EditTime\",t:VT_FILETIME},11:{n:\"LastPrinted\",t:VT_FILETIME},12:{n:\"CreatedDate\",t:VT_FILETIME},13:{n:\"ModifiedDate\",t:VT_FILETIME},14:{n:\"PageCount\",t:VT_I4},15:{n:\"WordCount\",t:VT_I4},16:{n:\"CharCount\",t:VT_I4},17:{n:\"Thumbnail\",t:VT_CF},18:{n:\"ApplicationName\",t:VT_LPSTR},19:{n:\"DocumentSecurity\",t:VT_I4},255:{}};var SpecialProperties={2147483648:{n:\"Locale\",t:VT_UI4},2147483651:{n:\"Behavior\",t:VT_UI4},1919054434:{}};(function(){for(var y in SpecialProperties)if(SpecialProperties.hasOwnProperty(y))DocSummaryPIDDSI[y]=SummaryPIDSI[y]=SpecialProperties[y]})();var CountryEnum={1:\"US\",2:\"CA\",3:\"\",7:\"RU\",20:\"EG\",30:\"GR\",31:\"NL\",32:\"BE\",33:\"FR\",34:\"ES\",36:\"HU\",39:\"IT\",41:\"CH\",43:\"AT\",44:\"GB\",45:\"DK\",46:\"SE\",47:\"NO\",48:\"PL\",49:\"DE\",52:\"MX\",55:\"BR\",61:\"AU\",64:\"NZ\",66:\"TH\",81:\"JP\",82:\"KR\",84:\"VN\",86:\"CN\",90:\"TR\",105:\"JS\",213:\"DZ\",216:\"MA\",218:\"LY\",351:\"PT\",354:\"IS\",358:\"FI\",420:\"CZ\",886:\"TW\",961:\"LB\",962:\"JO\",963:\"SY\",964:\"IQ\",965:\"KW\",966:\"SA\",971:\"AE\",972:\"IL\",974:\"QA\",981:\"IR\",65535:\"US\"};var XLSFillPattern=[null,\"solid\",\"mediumGray\",\"darkGray\",\"lightGray\",\"darkHorizontal\",\"darkVertical\",\"darkDown\",\"darkUp\",\"darkGrid\",\"darkTrellis\",\"lightHorizontal\",\"lightVertical\",\"lightDown\",\"lightUp\",\"lightGrid\",\"lightTrellis\",\"gray125\",\"gray0625\"];function rgbify(arr){return arr.map(function(x){return[x>>16&255,x>>8&255,x&255]})}var XLSIcv=rgbify([0,16777215,16711680,65280,255,16776960,16711935,65535,0,16777215,16711680,65280,255,16776960,16711935,65535,8388608,32768,128,8421376,8388736,32896,12632256,8421504,10066431,10040166,16777164,13434879,6684774,16744576,26316,13421823,128,16711935,16776960,65535,8388736,8388608,32896,255,52479,13434879,13434828,16777113,10079487,16751052,13408767,16764057,3368703,3394764,10079232,16763904,16750848,16737792,6710937,9868950,13158,3381606,13056,3355392,10040064,10040166,3355545,3355443,16777215,0]);var ct2type={\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\":\"workbooks\",\"application/vnd.ms-excel.binIndexWs\":\"TODO\",\"application/vnd.ms-excel.chartsheet\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml\":\"TODO\",\"application/vnd.ms-excel.dialogsheet\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml\":\"TODO\",\"application/vnd.ms-excel.macrosheet\":\"TODO\",\"application/vnd.ms-excel.macrosheet+xml\":\"TODO\",\"application/vnd.ms-excel.intlmacrosheet\":\"TODO\",\"application/vnd.ms-excel.binIndexMs\":\"TODO\",\"application/vnd.openxmlformats-package.core-properties+xml\":\"coreprops\",\"application/vnd.openxmlformats-officedocument.custom-properties+xml\":\"custprops\",\"application/vnd.openxmlformats-officedocument.extended-properties+xml\":\"extprops\",\"application/vnd.openxmlformats-officedocument.customXmlProperties+xml\":\"TODO\",\"application/vnd.ms-excel.comments\":\"comments\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml\":\"comments\",\"application/vnd.ms-excel.pivotTable\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml\":\"TODO\",\"application/vnd.ms-excel.calcChain\":\"calcchains\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml\":\"calcchains\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.printerSettings\":\"TODO\",\"application/vnd.ms-office.activeX\":\"TODO\",\"application/vnd.ms-office.activeX+xml\":\"TODO\",\"application/vnd.ms-excel.attachedToolbars\":\"TODO\",\"application/vnd.ms-excel.connections\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml\":\"TODO\",\"application/vnd.ms-excel.externalLink\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml\":\"TODO\",\"application/vnd.ms-excel.sheetMetadata\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml\":\"TODO\",\"application/vnd.ms-excel.pivotCacheDefinition\":\"TODO\",\"application/vnd.ms-excel.pivotCacheRecords\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml\":\"TODO\",\"application/vnd.ms-excel.queryTable\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml\":\"TODO\",\"application/vnd.ms-excel.userNames\":\"TODO\",\"application/vnd.ms-excel.revisionHeaders\":\"TODO\",\"application/vnd.ms-excel.revisionLog\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml\":\"TODO\",\"application/vnd.ms-excel.tableSingleCells\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml\":\"TODO\",\"application/vnd.ms-excel.slicer\":\"TODO\",\"application/vnd.ms-excel.slicerCache\":\"TODO\",\"application/vnd.ms-excel.slicer+xml\":\"TODO\",\"application/vnd.ms-excel.slicerCache+xml\":\"TODO\",\"application/vnd.ms-excel.wsSortMap\":\"TODO\",\"application/vnd.ms-excel.table\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.theme+xml\":\"themes\",\"application/vnd.ms-excel.Timeline+xml\":\"TODO\",\"application/vnd.ms-excel.TimelineCache+xml\":\"TODO\",\"application/vnd.ms-office.vbaProject\":\"vba\",\"application/vnd.ms-office.vbaProjectSignature\":\"vba\",\"application/vnd.ms-office.volatileDependencies\":\"TODO\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml\":\"TODO\",\"application/vnd.ms-excel.controlproperties+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.model+data\":\"TODO\",\"application/vnd.ms-excel.Survey+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.drawing+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.drawingml.chart+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml\":\"TODO\",\"application/vnd.openxmlformats-officedocument.vmlDrawing\":\"TODO\",\"application/vnd.openxmlformats-package.relationships+xml\":\"rels\",\"application/vnd.openxmlformats-officedocument.oleObject\":\"TODO\",sheet:\"js\"};var CT_LIST=function(){var o={workbooks:{xlsx:\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\",xlsm:\"application/vnd.ms-excel.sheet.macroEnabled.main+xml\",xlsb:\"application/vnd.ms-excel.sheet.binary.macroEnabled.main\",xltx:\"application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml\"},strs:{xlsx:\"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml\",xlsb:\"application/vnd.ms-excel.sharedStrings\"},sheets:{xlsx:\"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\",xlsb:\"application/vnd.ms-excel.worksheet\"},styles:{xlsx:\"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml\",xlsb:\"application/vnd.ms-excel.styles\"}};keys(o).forEach(function(k){if(!o[k].xlsm)o[k].xlsm=o[k].xlsx});keys(o).forEach(function(k){keys(o[k]).forEach(function(v){ct2type[o[k][v]]=k\n})});return o}();var type2ct=evert_arr(ct2type);XMLNS.CT=\"http://schemas.openxmlformats.org/package/2006/content-types\";function parse_ct(data,opts){var ctext={};if(!data||!data.match)return data;var ct={workbooks:[],sheets:[],calcchains:[],themes:[],styles:[],coreprops:[],extprops:[],custprops:[],strs:[],comments:[],vba:[],TODO:[],rels:[],xmlns:\"\"};(data.match(tagregex)||[]).forEach(function(x){var y=parsexmltag(x);switch(y[0].replace(nsregex,\"<\")){case\"<?xml\":break;case\"<Types\":ct.xmlns=y[\"xmlns\"+(y[0].match(/<(\\w+):/)||[\"\",\"\"])[1]];break;case\"<Default\":ctext[y.Extension]=y.ContentType;break;case\"<Override\":if(ct[ct2type[y.ContentType]]!==undefined)ct[ct2type[y.ContentType]].push(y.PartName);else if(opts.WTF)console.error(y);break}});if(ct.xmlns!==XMLNS.CT)throw new Error(\"Unknown Namespace: \"+ct.xmlns);ct.calcchain=ct.calcchains.length>0?ct.calcchains[0]:\"\";ct.sst=ct.strs.length>0?ct.strs[0]:\"\";ct.style=ct.styles.length>0?ct.styles[0]:\"\";ct.defaults=ctext;delete ct.calcchains;return ct}var CTYPE_XML_ROOT=writextag(\"Types\",null,{xmlns:XMLNS.CT,\"xmlns:xsd\":XMLNS.xsd,\"xmlns:xsi\":XMLNS.xsi});var CTYPE_DEFAULTS=[[\"xml\",\"application/xml\"],[\"bin\",\"application/vnd.ms-excel.sheet.binary.macroEnabled.main\"],[\"rels\",type2ct.rels[0]]].map(function(x){return writextag(\"Default\",null,{Extension:x[0],ContentType:x[1]})});function write_ct(ct,opts){var o=[],v;o[o.length]=XML_HEADER;o[o.length]=CTYPE_XML_ROOT;o=o.concat(CTYPE_DEFAULTS);var f1=function(w){if(ct[w]&&ct[w].length>0){v=ct[w][0];o[o.length]=writextag(\"Override\",null,{PartName:(v[0]==\"/\"?\"\":\"/\")+v,ContentType:CT_LIST[w][opts.bookType||\"xlsx\"]})}};var f2=function(w){ct[w].forEach(function(v){o[o.length]=writextag(\"Override\",null,{PartName:(v[0]==\"/\"?\"\":\"/\")+v,ContentType:CT_LIST[w][opts.bookType||\"xlsx\"]})})};var f3=function(t){(ct[t]||[]).forEach(function(v){o[o.length]=writextag(\"Override\",null,{PartName:(v[0]==\"/\"?\"\":\"/\")+v,ContentType:type2ct[t][0]})})};f1(\"workbooks\");f2(\"sheets\");f3(\"themes\");[\"strs\",\"styles\"].forEach(f1);[\"coreprops\",\"extprops\",\"custprops\"].forEach(f3);if(o.length>2){o[o.length]=\"</Types>\";o[1]=o[1].replace(\"/>\",\">\")}return o.join(\"\")}var RELS={WB:\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument\",SHEET:\"http://sheetjs.openxmlformats.org/officeDocument/2006/relationships/officeDocument\"};function parse_rels(data,currentFilePath){if(!data)return data;if(currentFilePath.charAt(0)!==\"/\"){currentFilePath=\"/\"+currentFilePath}var rels={};var hash={};var resolveRelativePathIntoAbsolute=function(to){var toksFrom=currentFilePath.split(\"/\");toksFrom.pop();var toksTo=to.split(\"/\");var reversed=[];while(toksTo.length!==0){var tokTo=toksTo.shift();if(tokTo===\"..\"){toksFrom.pop()}else if(tokTo!==\".\"){toksFrom.push(tokTo)}}return toksFrom.join(\"/\")};data.match(tagregex).forEach(function(x){var y=parsexmltag(x);if(y[0]===\"<Relationship\"){var rel={};rel.Type=y.Type;rel.Target=y.Target;rel.Id=y.Id;rel.TargetMode=y.TargetMode;var canonictarget=y.TargetMode===\"External\"?y.Target:resolveRelativePathIntoAbsolute(y.Target);rels[canonictarget]=rel;hash[y.Id]=rel}});rels[\"!id\"]=hash;return rels}XMLNS.RELS=\"http://schemas.openxmlformats.org/package/2006/relationships\";var RELS_ROOT=writextag(\"Relationships\",null,{xmlns:XMLNS.RELS});function write_rels(rels){var o=[];o[o.length]=XML_HEADER;o[o.length]=RELS_ROOT;keys(rels[\"!id\"]).forEach(function(rid){var rel=rels[\"!id\"][rid];o[o.length]=writextag(\"Relationship\",null,rel)});if(o.length>2){o[o.length]=\"</Relationships>\";o[1]=o[1].replace(\"/>\",\">\")}return o.join(\"\")}var CORE_PROPS=[[\"cp:category\",\"Category\"],[\"cp:contentStatus\",\"ContentStatus\"],[\"cp:keywords\",\"Keywords\"],[\"cp:lastModifiedBy\",\"LastAuthor\"],[\"cp:lastPrinted\",\"LastPrinted\"],[\"cp:revision\",\"RevNumber\"],[\"cp:version\",\"Version\"],[\"dc:creator\",\"Author\"],[\"dc:description\",\"Comments\"],[\"dc:identifier\",\"Identifier\"],[\"dc:language\",\"Language\"],[\"dc:subject\",\"Subject\"],[\"dc:title\",\"Title\"],[\"dcterms:created\",\"CreatedDate\",\"date\"],[\"dcterms:modified\",\"ModifiedDate\",\"date\"]];XMLNS.CORE_PROPS=\"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\";RELS.CORE_PROPS=\"http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties\";var CORE_PROPS_REGEX=function(){var r=new Array(CORE_PROPS.length);for(var i=0;i<CORE_PROPS.length;++i){var f=CORE_PROPS[i];var g=\"(?:\"+f[0].substr(0,f[0].indexOf(\":\"))+\":)\"+f[0].substr(f[0].indexOf(\":\")+1);r[i]=new RegExp(\"<\"+g+\"[^>]*>(.*)</\"+g+\">\")}return r}();function parse_core_props(data){var p={};for(var i=0;i<CORE_PROPS.length;++i){var f=CORE_PROPS[i],cur=data.match(CORE_PROPS_REGEX[i]);if(cur!=null&&cur.length>0)p[f[1]]=cur[1];if(f[2]===\"date\"&&p[f[1]])p[f[1]]=new Date(p[f[1]])}return p}var CORE_PROPS_XML_ROOT=writextag(\"cp:coreProperties\",null,{\"xmlns:cp\":XMLNS.CORE_PROPS,\"xmlns:dc\":XMLNS.dc,\"xmlns:dcterms\":XMLNS.dcterms,\"xmlns:dcmitype\":XMLNS.dcmitype,\"xmlns:xsi\":XMLNS.xsi});function cp_doit(f,g,h,o,p){if(p[f]!=null||g==null||g===\"\")return;p[f]=g;o[o.length]=h?writextag(f,g,h):writetag(f,g)}function write_core_props(cp,opts){var o=[XML_HEADER,CORE_PROPS_XML_ROOT],p={};if(!cp)return o.join(\"\");if(cp.CreatedDate!=null)cp_doit(\"dcterms:created\",typeof cp.CreatedDate===\"string\"?cp.CreatedDate:write_w3cdtf(cp.CreatedDate,opts.WTF),{\"xsi:type\":\"dcterms:W3CDTF\"},o,p);if(cp.ModifiedDate!=null)cp_doit(\"dcterms:modified\",typeof cp.ModifiedDate===\"string\"?cp.ModifiedDate:write_w3cdtf(cp.ModifiedDate,opts.WTF),{\"xsi:type\":\"dcterms:W3CDTF\"},o,p);for(var i=0;i!=CORE_PROPS.length;++i){var f=CORE_PROPS[i];cp_doit(f[0],cp[f[1]],null,o,p)}if(o.length>2){o[o.length]=\"</cp:coreProperties>\";o[1]=o[1].replace(\"/>\",\">\")}return o.join(\"\")}var EXT_PROPS=[[\"Application\",\"Application\",\"string\"],[\"AppVersion\",\"AppVersion\",\"string\"],[\"Company\",\"Company\",\"string\"],[\"DocSecurity\",\"DocSecurity\",\"string\"],[\"Manager\",\"Manager\",\"string\"],[\"HyperlinksChanged\",\"HyperlinksChanged\",\"bool\"],[\"SharedDoc\",\"SharedDoc\",\"bool\"],[\"LinksUpToDate\",\"LinksUpToDate\",\"bool\"],[\"ScaleCrop\",\"ScaleCrop\",\"bool\"],[\"HeadingPairs\",\"HeadingPairs\",\"raw\"],[\"TitlesOfParts\",\"TitlesOfParts\",\"raw\"]];XMLNS.EXT_PROPS=\"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties\";RELS.EXT_PROPS=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties\";function parse_ext_props(data,p){var q={};if(!p)p={};EXT_PROPS.forEach(function(f){switch(f[2]){case\"string\":p[f[1]]=(data.match(matchtag(f[0]))||[])[1];break;case\"bool\":p[f[1]]=(data.match(matchtag(f[0]))||[])[1]===\"true\";break;case\"raw\":var cur=data.match(new RegExp(\"<\"+f[0]+\"[^>]*>(.*)</\"+f[0]+\">\"));if(cur&&cur.length>0)q[f[1]]=cur[1];break}});if(q.HeadingPairs&&q.TitlesOfParts){var v=parseVector(q.HeadingPairs);var j=0,widx=0;for(var i=0;i!==v.length;++i){switch(v[i].v){case\"Worksheets\":widx=j;p.Worksheets=+v[++i].v;break;case\"Named Ranges\":++i;break}}var parts=parseVector(q.TitlesOfParts).map(function(x){return utf8read(x.v)});p.SheetNames=parts.slice(widx,widx+p.Worksheets)}return p}var EXT_PROPS_XML_ROOT=writextag(\"Properties\",null,{xmlns:XMLNS.EXT_PROPS,\"xmlns:vt\":XMLNS.vt});function write_ext_props(cp,opts){var o=[],p={},W=writextag;if(!cp)cp={};cp.Application=\"SheetJS\";o[o.length]=XML_HEADER;o[o.length]=EXT_PROPS_XML_ROOT;EXT_PROPS.forEach(function(f){if(cp[f[1]]===undefined)return;var v;switch(f[2]){case\"string\":v=cp[f[1]];break;case\"bool\":v=cp[f[1]]?\"true\":\"false\";break}if(v!==undefined)o[o.length]=W(f[0],v)});o[o.length]=W(\"HeadingPairs\",W(\"vt:vector\",W(\"vt:variant\",\"<vt:lpstr>Worksheets</vt:lpstr>\")+W(\"vt:variant\",W(\"vt:i4\",String(cp.Worksheets))),{size:2,baseType:\"variant\"}));o[o.length]=W(\"TitlesOfParts\",W(\"vt:vector\",cp.SheetNames.map(function(s){return\"<vt:lpstr>\"+s+\"</vt:lpstr>\"}).join(\"\"),{size:cp.Worksheets,baseType:\"lpstr\"}));if(o.length>2){o[o.length]=\"</Properties>\";o[1]=o[1].replace(\"/>\",\">\")}return o.join(\"\")}XMLNS.CUST_PROPS=\"http://schemas.openxmlformats.org/officeDocument/2006/custom-properties\";RELS.CUST_PROPS=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties\";var custregex=/<[^>]+>[^<]*/g;function parse_cust_props(data,opts){var p={},name;var m=data.match(custregex);if(m)for(var i=0;i!=m.length;++i){var x=m[i],y=parsexmltag(x);switch(y[0]){case\"<?xml\":break;case\"<Properties\":if(y.xmlns!==XMLNS.CUST_PROPS)throw\"unrecognized xmlns \"+y.xmlns;if(y.xmlnsvt&&y.xmlnsvt!==XMLNS.vt)throw\"unrecognized vt \"+y.xmlnsvt;break;case\"<property\":name=y.name;break;case\"</property>\":name=null;break;default:if(x.indexOf(\"<vt:\")===0){var toks=x.split(\">\");var type=toks[0].substring(4),text=toks[1];switch(type){case\"lpstr\":case\"lpwstr\":case\"bstr\":case\"lpwstr\":p[name]=unescapexml(text);break;case\"bool\":p[name]=parsexmlbool(text,\"<vt:bool>\");break;case\"i1\":case\"i2\":case\"i4\":case\"i8\":case\"int\":case\"uint\":p[name]=parseInt(text,10);break;case\"r4\":case\"r8\":case\"decimal\":p[name]=parseFloat(text);break;case\"filetime\":case\"date\":p[name]=new Date(text);break;case\"cy\":case\"error\":p[name]=unescapexml(text);break;default:if(typeof console!==\"undefined\")console.warn(\"Unexpected\",x,type,toks)}}else if(x.substr(0,2)===\"</\"){}else if(opts.WTF)throw new Error(x)}}return p}var CUST_PROPS_XML_ROOT=writextag(\"Properties\",null,{xmlns:XMLNS.CUST_PROPS,\"xmlns:vt\":XMLNS.vt});function write_cust_props(cp,opts){var o=[XML_HEADER,CUST_PROPS_XML_ROOT];if(!cp)return o.join(\"\");var pid=1;keys(cp).forEach(function custprop(k){++pid;o[o.length]=writextag(\"property\",write_vt(cp[k]),{fmtid:\"{D5CDD505-2E9C-101B-9397-08002B2CF9AE}\",pid:pid,name:k})});if(o.length>2){o[o.length]=\"</Properties>\";o[1]=o[1].replace(\"/>\",\">\")}return o.join(\"\")}function xlml_set_prop(Props,tag,val){switch(tag){case\"Description\":tag=\"Comments\";break}Props[tag]=val}function parse_FILETIME(blob){var dwLowDateTime=blob.read_shift(4),dwHighDateTime=blob.read_shift(4);return new Date((dwHighDateTime/1e7*Math.pow(2,32)+dwLowDateTime/1e7-11644473600)*1e3).toISOString().replace(/\\.000/,\"\")}function parse_lpstr(blob,type,pad){var str=blob.read_shift(0,\"lpstr\");if(pad)blob.l+=4-(str.length+1&3)&3;return str}function parse_lpwstr(blob,type,pad){var str=blob.read_shift(0,\"lpwstr\");if(pad)blob.l+=4-(str.length+1&3)&3;return str}function parse_VtStringBase(blob,stringType,pad){if(stringType===31)return parse_lpwstr(blob);return parse_lpstr(blob,stringType,pad)}function parse_VtString(blob,t,pad){return parse_VtStringBase(blob,t,pad===false?0:4)}function parse_VtUnalignedString(blob,t){if(!t)throw new Error(\"dafuq?\");return parse_VtStringBase(blob,t,0)}function parse_VtVecUnalignedLpstrValue(blob){var length=blob.read_shift(4);var ret=[];for(var i=0;i!=length;++i)ret[i]=blob.read_shift(0,\"lpstr\");return ret}function parse_VtVecUnalignedLpstr(blob){return parse_VtVecUnalignedLpstrValue(blob)}function parse_VtHeadingPair(blob){var headingString=parse_TypedPropertyValue(blob,VT_USTR);var headerParts=parse_TypedPropertyValue(blob,VT_I4);return[headingString,headerParts]}function parse_VtVecHeadingPairValue(blob){var cElements=blob.read_shift(4);var out=[];for(var i=0;i!=cElements/2;++i)out.push(parse_VtHeadingPair(blob));return out}function parse_VtVecHeadingPair(blob){return parse_VtVecHeadingPairValue(blob)}function parse_dictionary(blob,CodePage){var cnt=blob.read_shift(4);var dict={};for(var j=0;j!=cnt;++j){var pid=blob.read_shift(4);var len=blob.read_shift(4);dict[pid]=blob.read_shift(len,CodePage===1200?\"utf16le\":\"utf8\").replace(chr0,\"\").replace(chr1,\"!\")}if(blob.l&3)blob.l=blob.l>>2+1<<2;return dict}function parse_BLOB(blob){var size=blob.read_shift(4);var bytes=blob.slice(blob.l,blob.l+size);if(size&3>0)blob.l+=4-(size&3)&3;return bytes}function parse_ClipboardData(blob){var o={};o.Size=blob.read_shift(4);blob.l+=o.Size;return o}function parse_VtVector(blob,cb){}function parse_TypedPropertyValue(blob,type,_opts){var t=blob.read_shift(2),ret,opts=_opts||{};blob.l+=2;if(type!==VT_VARIANT)if(t!==type&&VT_CUSTOM.indexOf(type)===-1)throw new Error(\"Expected type \"+type+\" saw \"+t);switch(type===VT_VARIANT?t:type){case 2:ret=blob.read_shift(2,\"i\");if(!opts.raw)blob.l+=2;return ret;case 3:ret=blob.read_shift(4,\"i\");return ret;case 11:return blob.read_shift(4)!==0;case 19:ret=blob.read_shift(4);return ret;case 30:return parse_lpstr(blob,t,4).replace(chr0,\"\");case 31:return parse_lpwstr(blob);case 64:return parse_FILETIME(blob);case 65:return parse_BLOB(blob);case 71:return parse_ClipboardData(blob);case 80:return parse_VtString(blob,t,!opts.raw&&4).replace(chr0,\"\");case 81:return parse_VtUnalignedString(blob,t,4).replace(chr0,\"\");case 4108:return parse_VtVecHeadingPair(blob);case 4126:return parse_VtVecUnalignedLpstr(blob);default:throw new Error(\"TypedPropertyValue unrecognized type \"+type+\" \"+t)}}function parse_PropertySet(blob,PIDSI){var start_addr=blob.l;var size=blob.read_shift(4);var NumProps=blob.read_shift(4);var Props=[],i=0;var CodePage=0;var Dictionary=-1,DictObj;for(i=0;i!=NumProps;++i){var PropID=blob.read_shift(4);var Offset=blob.read_shift(4);Props[i]=[PropID,Offset+start_addr]}var PropH={};for(i=0;i!=NumProps;++i){if(blob.l!==Props[i][1]){var fail=true;if(i>0&&PIDSI)switch(PIDSI[Props[i-1][0]].t){case 2:if(blob.l+2===Props[i][1]){blob.l+=2;fail=false}break;case 80:if(blob.l<=Props[i][1]){blob.l=Props[i][1];fail=false}break;case 4108:if(blob.l<=Props[i][1]){blob.l=Props[i][1];fail=false}break}if(!PIDSI&&blob.l<=Props[i][1]){fail=false;blob.l=Props[i][1]}if(fail)throw new Error(\"Read Error: Expected address \"+Props[i][1]+\" at \"+blob.l+\" :\"+i)}if(PIDSI){var piddsi=PIDSI[Props[i][0]];PropH[piddsi.n]=parse_TypedPropertyValue(blob,piddsi.t,{raw:true});if(piddsi.p===\"version\")PropH[piddsi.n]=String(PropH[piddsi.n]>>16)+\".\"+String(PropH[piddsi.n]&65535);if(piddsi.n==\"CodePage\")switch(PropH[piddsi.n]){case 0:PropH[piddsi.n]=1252;case 1e4:case 1252:case 874:case 1250:case 1251:case 1253:case 1254:case 1255:case 1256:case 1257:case 1258:case 932:case 936:case 949:case 950:case 1200:case 1201:case 65e3:case-536:case 65001:case-535:set_cp(CodePage=PropH[piddsi.n]);break;default:throw new Error(\"Unsupported CodePage: \"+PropH[piddsi.n])}}else{if(Props[i][0]===1){CodePage=PropH.CodePage=parse_TypedPropertyValue(blob,VT_I2);set_cp(CodePage);if(Dictionary!==-1){var oldpos=blob.l;blob.l=Props[Dictionary][1];DictObj=parse_dictionary(blob,CodePage);blob.l=oldpos}}else if(Props[i][0]===0){if(CodePage===0){Dictionary=i;blob.l=Props[i+1][1];continue}DictObj=parse_dictionary(blob,CodePage)}else{var name=DictObj[Props[i][0]];var val;switch(blob[blob.l]){case 65:blob.l+=4;val=parse_BLOB(blob);break;case 30:blob.l+=4;val=parse_VtString(blob,blob[blob.l-4]);break;case 31:blob.l+=4;val=parse_VtString(blob,blob[blob.l-4]);break;case 3:blob.l+=4;val=blob.read_shift(4,\"i\");break;case 19:blob.l+=4;val=blob.read_shift(4);break;case 5:blob.l+=4;val=blob.read_shift(8,\"f\");break;case 11:blob.l+=4;val=parsebool(blob,4);break;case 64:blob.l+=4;val=new Date(parse_FILETIME(blob));break;default:throw new Error(\"unparsed value: \"+blob[blob.l])}PropH[name]=val}}}blob.l=start_addr+size;return PropH}function parse_PropertySetStream(file,PIDSI){var blob=file.content;prep_blob(blob,0);var NumSets,FMTID0,FMTID1,Offset0,Offset1;blob.chk(\"feff\",\"Byte Order: \");var vers=blob.read_shift(2);var SystemIdentifier=blob.read_shift(4);blob.chk(CFB.utils.consts.HEADER_CLSID,\"CLSID: \");NumSets=blob.read_shift(4);if(NumSets!==1&&NumSets!==2)throw\"Unrecognized #Sets: \"+NumSets;FMTID0=blob.read_shift(16);Offset0=blob.read_shift(4);if(NumSets===1&&Offset0!==blob.l)throw\"Length mismatch\";else if(NumSets===2){FMTID1=blob.read_shift(16);Offset1=blob.read_shift(4)}var PSet0=parse_PropertySet(blob,PIDSI);var rval={SystemIdentifier:SystemIdentifier};for(var y in PSet0)rval[y]=PSet0[y];rval.FMTID=FMTID0;if(NumSets===1)return rval;if(blob.l!==Offset1)throw\"Length mismatch 2: \"+blob.l+\" !== \"+Offset1;var PSet1;try{PSet1=parse_PropertySet(blob,null)}catch(e){}for(y in PSet1)rval[y]=PSet1[y];rval.FMTID=[FMTID0,FMTID1];return rval}function parsenoop2(blob,length){blob.read_shift(length);return null}function parslurp(blob,length,cb){var arr=[],target=blob.l+length;while(blob.l<target)arr.push(cb(blob,target-blob.l));if(target!==blob.l)throw new Error(\"Slurp error\");return arr}function parslurp2(blob,length,cb){var arr=[],target=blob.l+length,len=blob.read_shift(2);while(len--!==0)arr.push(cb(blob,target-blob.l));if(target!==blob.l)throw new Error(\"Slurp error\");return arr}function parsebool(blob,length){return blob.read_shift(length)===1}function parseuint16(blob){return blob.read_shift(2,\"u\")}function parseuint16a(blob,length){return parslurp(blob,length,parseuint16)}var parse_Boolean=parsebool;function parse_Bes(blob){var v=blob.read_shift(1),t=blob.read_shift(1);return t===1?v:v===1}function parse_ShortXLUnicodeString(blob,length,opts){var cch=blob.read_shift(1);var width=1,encoding=\"sbcs-cont\";var cp=current_codepage;if(opts&&opts.biff>=8)current_codepage=1200;if(opts===undefined||opts.biff!==5){var fHighByte=blob.read_shift(1);if(fHighByte){width=2;encoding=\"dbcs-cont\"}}var o=cch?blob.read_shift(cch,encoding):\"\";current_codepage=cp;return o}function parse_XLUnicodeRichExtendedString(blob){var cp=current_codepage;current_codepage=1200;var cch=blob.read_shift(2),flags=blob.read_shift(1);var fHighByte=flags&1,fExtSt=flags&4,fRichSt=flags&8;var width=1+(flags&1);var cRun,cbExtRst;var z={};if(fRichSt)cRun=blob.read_shift(2);if(fExtSt)cbExtRst=blob.read_shift(4);var encoding=flags&1?\"dbcs-cont\":\"sbcs-cont\";var msg=cch===0?\"\":blob.read_shift(cch,encoding);if(fRichSt)blob.l+=4*cRun;if(fExtSt)blob.l+=cbExtRst;z.t=msg;if(!fRichSt){z.raw=\"<t>\"+z.t+\"</t>\";z.r=z.t}current_codepage=cp;return z}function parse_XLUnicodeStringNoCch(blob,cch,opts){var retval;var fHighByte=blob.read_shift(1);if(fHighByte===0){retval=blob.read_shift(cch,\"sbcs-cont\")}else{retval=blob.read_shift(cch,\"dbcs-cont\")}return retval}function parse_XLUnicodeString(blob,length,opts){var cch=blob.read_shift(opts!==undefined&&opts.biff>0&&opts.biff<8?1:2);if(cch===0){blob.l++;return\"\"}return parse_XLUnicodeStringNoCch(blob,cch,opts)}function parse_XLUnicodeString2(blob,length,opts){if(opts.biff!==5&&opts.biff!==2)return parse_XLUnicodeString(blob,length,opts);var cch=blob.read_shift(1);if(cch===0){blob.l++;return\"\"}return blob.read_shift(cch,\"sbcs-cont\")}var parse_ControlInfo=parsenoop;var parse_URLMoniker=function(blob,length){var len=blob.read_shift(4),start=blob.l;var extra=false;if(len>24){blob.l+=len-24;if(blob.read_shift(16)===\"795881f43b1d7f48af2c825dc4852763\")extra=true;blob.l=start}var url=blob.read_shift((extra?len-24:len)>>1,\"utf16le\").replace(chr0,\"\");if(extra)blob.l+=24;return url};var parse_FileMoniker=function(blob,length){var cAnti=blob.read_shift(2);var ansiLength=blob.read_shift(4);var ansiPath=blob.read_shift(ansiLength,\"cstr\");var endServer=blob.read_shift(2);var versionNumber=blob.read_shift(2);var cbUnicodePathSize=blob.read_shift(4);if(cbUnicodePathSize===0)return ansiPath.replace(/\\\\/g,\"/\");var cbUnicodePathBytes=blob.read_shift(4);var usKeyValue=blob.read_shift(2);var unicodePath=blob.read_shift(cbUnicodePathBytes>>1,\"utf16le\").replace(chr0,\"\");return unicodePath};var parse_HyperlinkMoniker=function(blob,length){var clsid=blob.read_shift(16);length-=16;switch(clsid){case\"e0c9ea79f9bace118c8200aa004ba90b\":return parse_URLMoniker(blob,length);case\"0303000000000000c000000000000046\":return parse_FileMoniker(blob,length);default:throw\"unsupported moniker \"+clsid}};var parse_HyperlinkString=function(blob,length){var len=blob.read_shift(4);var o=blob.read_shift(len,\"utf16le\").replace(chr0,\"\");return o};var parse_Hyperlink=function(blob,length){var end=blob.l+length;var sVer=blob.read_shift(4);if(sVer!==2)throw new Error(\"Unrecognized streamVersion: \"+sVer);var flags=blob.read_shift(2);blob.l+=2;var displayName,targetFrameName,moniker,oleMoniker,location,guid,fileTime;if(flags&16)displayName=parse_HyperlinkString(blob,end-blob.l);if(flags&128)targetFrameName=parse_HyperlinkString(blob,end-blob.l);if((flags&257)===257)moniker=parse_HyperlinkString(blob,end-blob.l);if((flags&257)===1)oleMoniker=parse_HyperlinkMoniker(blob,end-blob.l);if(flags&8)location=parse_HyperlinkString(blob,end-blob.l);if(flags&32)guid=blob.read_shift(16);if(flags&64)fileTime=parse_FILETIME(blob,8);blob.l=end;var target=targetFrameName||moniker||oleMoniker;if(location)target+=\"#\"+location;return{Target:target}};function parse_LongRGBA(blob,length){var r=blob.read_shift(1),g=blob.read_shift(1),b=blob.read_shift(1),a=blob.read_shift(1);return[r,g,b,a]}function parse_LongRGB(blob,length){var x=parse_LongRGBA(blob,length);x[3]=0;return x}function parse_XLSCell(blob,length){var rw=blob.read_shift(2);var col=blob.read_shift(2);var ixfe=blob.read_shift(2);return{r:rw,c:col,ixfe:ixfe}}function parse_frtHeader(blob){var rt=blob.read_shift(2);var flags=blob.read_shift(2);blob.l+=8;return{type:rt,flags:flags}}function parse_OptXLUnicodeString(blob,length,opts){return length===0?\"\":parse_XLUnicodeString2(blob,length,opts)}var HIDEOBJENUM=[\"SHOWALL\",\"SHOWPLACEHOLDER\",\"HIDEALL\"];var parse_HideObjEnum=parseuint16;function parse_XTI(blob,length){var iSupBook=blob.read_shift(2),itabFirst=blob.read_shift(2,\"i\"),itabLast=blob.read_shift(2,\"i\");return[iSupBook,itabFirst,itabLast]}function parse_RkRec(blob,length){var ixfe=blob.read_shift(2);var RK=parse_RkNumber(blob);return[ixfe,RK]}function parse_AddinUdf(blob,length){blob.l+=4;length-=4;var l=blob.l+length;var udfName=parse_ShortXLUnicodeString(blob,length);var cb=blob.read_shift(2);l-=blob.l;if(cb!==l)throw\"Malformed AddinUdf: padding = \"+l+\" != \"+cb;blob.l+=cb;return udfName}function parse_Ref8U(blob,length){var rwFirst=blob.read_shift(2);var rwLast=blob.read_shift(2);var colFirst=blob.read_shift(2);var colLast=blob.read_shift(2);return{s:{c:colFirst,r:rwFirst},e:{c:colLast,r:rwLast}}}function parse_RefU(blob,length){var rwFirst=blob.read_shift(2);var rwLast=blob.read_shift(2);var colFirst=blob.read_shift(1);var colLast=blob.read_shift(1);return{s:{c:colFirst,r:rwFirst},e:{c:colLast,r:rwLast}}}var parse_Ref=parse_RefU;function parse_FtCmo(blob,length){blob.l+=4;var ot=blob.read_shift(2);var id=blob.read_shift(2);var flags=blob.read_shift(2);blob.l+=12;return[id,ot,flags]}function parse_FtNts(blob,length){var out={};blob.l+=4;blob.l+=16;out.fSharedNote=blob.read_shift(2);blob.l+=4;return out}function parse_FtCf(blob,length){var out={};blob.l+=4;blob.cf=blob.read_shift(2);return out}var FtTab={21:parse_FtCmo,19:parsenoop,18:function(blob,length){blob.l+=12},17:function(blob,length){blob.l+=8},16:parsenoop,15:parsenoop,13:parse_FtNts,12:function(blob,length){blob.l+=24},11:function(blob,length){blob.l+=10},10:function(blob,length){blob.l+=16},9:parsenoop,8:function(blob,length){blob.l+=6},7:parse_FtCf,6:function(blob,length){blob.l+=6},4:parsenoop,0:function(blob,length){blob.l+=4}};function parse_FtArray(blob,length,ot){var s=blob.l;var fts=[];while(blob.l<s+length){var ft=blob.read_shift(2);blob.l-=2;try{fts.push(FtTab[ft](blob,s+length-blob.l))}catch(e){blob.l=s+length;return fts}}if(blob.l!=s+length)blob.l=s+length;return fts}var parse_FontIndex=parseuint16;function parse_BOF(blob,length){var o={};o.BIFFVer=blob.read_shift(2);length-=2;switch(o.BIFFVer){case 1536:case 1280:case 2:case 7:break;default:throw\"Unexpected BIFF Ver \"+o.BIFFVer}blob.read_shift(length);return o}function parse_InterfaceHdr(blob,length){if(length===0)return 1200;var q;if((q=blob.read_shift(2))!==1200)throw\"InterfaceHdr codePage \"+q;return 1200}function parse_WriteAccess(blob,length,opts){if(opts.enc){blob.l+=length;return\"\"}var l=blob.l;var UserName=parse_XLUnicodeString(blob,0,opts);blob.read_shift(length+l-blob.l);return UserName}function parse_BoundSheet8(blob,length,opts){var pos=blob.read_shift(4);var hidden=blob.read_shift(1)>>6;var dt=blob.read_shift(1);switch(dt){case 0:dt=\"Worksheet\";break;case 1:dt=\"Macrosheet\";break;case 2:dt=\"Chartsheet\";break;case 6:dt=\"VBAModule\";break}var name=parse_ShortXLUnicodeString(blob,0,opts);if(name.length===0)name=\"Sheet1\";return{pos:pos,hs:hidden,dt:dt,name:name}}function parse_SST(blob,length){var cnt=blob.read_shift(4);var ucnt=blob.read_shift(4);var strs=[];for(var i=0;i!=ucnt;++i){strs.push(parse_XLUnicodeRichExtendedString(blob))}strs.Count=cnt;strs.Unique=ucnt;return strs}function parse_ExtSST(blob,length){var extsst={};extsst.dsst=blob.read_shift(2);blob.l+=length-2;return extsst}function parse_Row(blob,length){var rw=blob.read_shift(2),col=blob.read_shift(2),Col=blob.read_shift(2),rht=blob.read_shift(2);blob.read_shift(4);var flags=blob.read_shift(1);blob.read_shift(1);blob.read_shift(2);return{r:rw,c:col,cnt:Col-col}}function parse_ForceFullCalculation(blob,length){var header=parse_frtHeader(blob);if(header.type!=2211)throw\"Invalid Future Record \"+header.type;var fullcalc=blob.read_shift(4);return fullcalc!==0}var parse_CompressPictures=parsenoop2;function parse_RecalcId(blob,length){blob.read_shift(2);return blob.read_shift(4)}function parse_DefaultRowHeight(blob,length){var f=blob.read_shift(2),miyRw;miyRw=blob.read_shift(2);var fl={Unsynced:f&1,DyZero:(f&2)>>1,ExAsc:(f&4)>>2,ExDsc:(f&8)>>3};return[fl,miyRw]}function parse_Window1(blob,length){var xWn=blob.read_shift(2),yWn=blob.read_shift(2),dxWn=blob.read_shift(2),dyWn=blob.read_shift(2);var flags=blob.read_shift(2),iTabCur=blob.read_shift(2),iTabFirst=blob.read_shift(2);var ctabSel=blob.read_shift(2),wTabRatio=blob.read_shift(2);return{Pos:[xWn,yWn],Dim:[dxWn,dyWn],Flags:flags,CurTab:iTabCur,FirstTab:iTabFirst,Selected:ctabSel,TabRatio:wTabRatio}}function parse_Font(blob,length,opts){blob.l+=14;var name=parse_ShortXLUnicodeString(blob,0,opts);return name}function parse_LabelSst(blob,length){var cell=parse_XLSCell(blob);cell.isst=blob.read_shift(4);return cell}function parse_Label(blob,length,opts){var cell=parse_XLSCell(blob,6);var str=parse_XLUnicodeString(blob,length-6,opts);cell.val=str;return cell}function parse_Format(blob,length,opts){var ifmt=blob.read_shift(2);var fmtstr=parse_XLUnicodeString2(blob,0,opts);return[ifmt,fmtstr]}function parse_Dimensions(blob,length){var w=length===10?2:4;var r=blob.read_shift(w),R=blob.read_shift(w),c=blob.read_shift(2),C=blob.read_shift(2);blob.l+=2;return{s:{r:r,c:c},e:{r:R,c:C}}}function parse_RK(blob,length){var rw=blob.read_shift(2),col=blob.read_shift(2);var rkrec=parse_RkRec(blob);return{r:rw,c:col,ixfe:rkrec[0],rknum:rkrec[1]}}function parse_MulRk(blob,length){var target=blob.l+length-2;var rw=blob.read_shift(2),col=blob.read_shift(2);var rkrecs=[];while(blob.l<target)rkrecs.push(parse_RkRec(blob));if(blob.l!==target)throw\"MulRK read error\";var lastcol=blob.read_shift(2);if(rkrecs.length!=lastcol-col+1)throw\"MulRK length mismatch\";return{r:rw,c:col,C:lastcol,rkrec:rkrecs}}function parse_CellStyleXF(blob,length,style){var o={};var a=blob.read_shift(4),b=blob.read_shift(4);var c=blob.read_shift(4),d=blob.read_shift(2);o.patternType=XLSFillPattern[c>>26];o.icvFore=d&127;o.icvBack=d>>7&127;return o}function parse_CellXF(blob,length){return parse_CellStyleXF(blob,length,0)}function parse_StyleXF(blob,length){return parse_CellStyleXF(blob,length,1)}function parse_XF(blob,length){var o={};o.ifnt=blob.read_shift(2);o.ifmt=blob.read_shift(2);o.flags=blob.read_shift(2);o.fStyle=o.flags>>2&1;length-=6;o.data=parse_CellStyleXF(blob,length,o.fStyle);return o}function parse_Guts(blob,length){blob.l+=4;var out=[blob.read_shift(2),blob.read_shift(2)];if(out[0]!==0)out[0]--;if(out[1]!==0)out[1]--;if(out[0]>7||out[1]>7)throw\"Bad Gutters: \"+out;return out}function parse_BoolErr(blob,length){var cell=parse_XLSCell(blob,6);var val=parse_Bes(blob,2);cell.val=val;cell.t=val===true||val===false?\"b\":\"e\";return cell}function parse_Number(blob,length){var cell=parse_XLSCell(blob,6);var xnum=parse_Xnum(blob,8);cell.val=xnum;return cell}var parse_XLHeaderFooter=parse_OptXLUnicodeString;function parse_SupBook(blob,length,opts){var end=blob.l+length;var ctab=blob.read_shift(2);var cch=blob.read_shift(2);var virtPath;if(cch>=1&&cch<=255)virtPath=parse_XLUnicodeStringNoCch(blob,cch);var rgst=blob.read_shift(end-blob.l);opts.sbcch=cch;return[cch,ctab,virtPath,rgst]}function parse_ExternName(blob,length,opts){var flags=blob.read_shift(2);var body;var o={fBuiltIn:flags&1,fWantAdvise:flags>>>1&1,fWantPict:flags>>>2&1,fOle:flags>>>3&1,fOleLink:flags>>>4&1,cf:flags>>>5&1023,fIcon:flags>>>15&1};if(opts.sbcch===14849)body=parse_AddinUdf(blob,length-2);o.body=body||blob.read_shift(length-2);return o}function parse_Lbl(blob,length,opts){if(opts.biff<8)return parse_Label(blob,length,opts);var target=blob.l+length;var flags=blob.read_shift(2);var chKey=blob.read_shift(1);var cch=blob.read_shift(1);var cce=blob.read_shift(2);blob.l+=2;var itab=blob.read_shift(2);blob.l+=4;var name=parse_XLUnicodeStringNoCch(blob,cch,opts);var rgce=parse_NameParsedFormula(blob,target-blob.l,opts,cce);return{chKey:chKey,Name:name,rgce:rgce}}function parse_ExternSheet(blob,length,opts){if(opts.biff<8)return parse_ShortXLUnicodeString(blob,length,opts);var o=parslurp2(blob,length,parse_XTI);var oo=[];if(opts.sbcch===1025){for(var i=0;i!=o.length;++i)oo.push(opts.snames[o[i][1]]);return oo}else return o}function parse_ShrFmla(blob,length,opts){var ref=parse_RefU(blob,6);blob.l++;var cUse=blob.read_shift(1);length-=8;return[parse_SharedParsedFormula(blob,length,opts),cUse]}function parse_Array(blob,length,opts){var ref=parse_Ref(blob,6);blob.l+=6;length-=12;return[ref,parse_ArrayParsedFormula(blob,length,opts,ref)]}function parse_MTRSettings(blob,length){var fMTREnabled=blob.read_shift(4)!==0;var fUserSetThreadCount=blob.read_shift(4)!==0;var cUserThreadCount=blob.read_shift(4);return[fMTREnabled,fUserSetThreadCount,cUserThreadCount]}function parse_NoteSh(blob,length,opts){if(opts.biff<8)return;var row=blob.read_shift(2),col=blob.read_shift(2);var flags=blob.read_shift(2),idObj=blob.read_shift(2);var stAuthor=parse_XLUnicodeString2(blob,0,opts);if(opts.biff<8)blob.read_shift(1);return[{r:row,c:col},stAuthor,idObj,flags]}function parse_Note(blob,length,opts){return parse_NoteSh(blob,length,opts)}function parse_MergeCells(blob,length){var merges=[];var cmcs=blob.read_shift(2);while(cmcs--)merges.push(parse_Ref8U(blob,length));return merges}function parse_Obj(blob,length){var cmo=parse_FtCmo(blob,22);var fts=parse_FtArray(blob,length-22,cmo[1]);return{cmo:cmo,ft:fts}}function parse_TxO(blob,length,opts){var s=blob.l;try{blob.l+=4;var ot=(opts.lastobj||{cmo:[0,0]}).cmo[1];var controlInfo;if([0,5,7,11,12,14].indexOf(ot)==-1)blob.l+=6;else controlInfo=parse_ControlInfo(blob,6,opts);var cchText=blob.read_shift(2);var cbRuns=blob.read_shift(2);var ifntEmpty=parse_FontIndex(blob,2);var len=blob.read_shift(2);blob.l+=len;var texts=\"\";for(var i=1;i<blob.lens.length-1;++i){if(blob.l-s!=blob.lens[i])throw\"TxO: bad continue record\";var hdr=blob[blob.l];var t=parse_XLUnicodeStringNoCch(blob,blob.lens[i+1]-blob.lens[i]-1);texts+=t;if(texts.length>=(hdr?cchText:2*cchText))break}if(texts.length!==cchText&&texts.length!==cchText*2){throw\"cchText: \"+cchText+\" != \"+texts.length}blob.l=s+length;return{t:texts}}catch(e){blob.l=s+length;return{t:texts||\"\"}}}var parse_HLink=function(blob,length){var ref=parse_Ref8U(blob,8);blob.l+=16;var hlink=parse_Hyperlink(blob,length-24);return[ref,hlink]};var parse_HLinkTooltip=function(blob,length){var end=blob.l+length;blob.read_shift(2);var ref=parse_Ref8U(blob,8);var wzTooltip=blob.read_shift((length-10)/2,\"dbcs-cont\");wzTooltip=wzTooltip.replace(chr0,\"\");return[ref,wzTooltip]};function parse_Country(blob,length){var o=[],d;d=blob.read_shift(2);o[0]=CountryEnum[d]||d;d=blob.read_shift(2);o[1]=CountryEnum[d]||d;return o}function parse_ClrtClient(blob,length){var ccv=blob.read_shift(2);var o=[];while(ccv-->0)o.push(parse_LongRGB(blob,8));return o}function parse_Palette(blob,length){var ccv=blob.read_shift(2);var o=[];while(ccv-->0)o.push(parse_LongRGB(blob,8));return o}function parse_XFCRC(blob,length){blob.l+=2;var o={cxfs:0,crc:0};o.cxfs=blob.read_shift(2);o.crc=blob.read_shift(4);return o}var parse_Style=parsenoop;var parse_StyleExt=parsenoop;var parse_ColInfo=parsenoop;\nvar parse_Window2=parsenoop;var parse_Backup=parsebool;var parse_Blank=parse_XLSCell;var parse_BottomMargin=parse_Xnum;var parse_BuiltInFnGroupCount=parseuint16;var parse_CalcCount=parseuint16;var parse_CalcDelta=parse_Xnum;var parse_CalcIter=parsebool;var parse_CalcMode=parseuint16;var parse_CalcPrecision=parsebool;var parse_CalcRefMode=parsenoop2;var parse_CalcSaveRecalc=parsebool;var parse_CodePage=parseuint16;var parse_Compat12=parsebool;var parse_Date1904=parsebool;var parse_DefColWidth=parseuint16;var parse_DSF=parsenoop2;var parse_EntExU2=parsenoop2;var parse_EOF=parsenoop2;var parse_Excel9File=parsenoop2;var parse_FeatHdr=parsenoop2;var parse_FontX=parseuint16;var parse_Footer=parse_XLHeaderFooter;var parse_GridSet=parseuint16;var parse_HCenter=parsebool;var parse_Header=parse_XLHeaderFooter;var parse_HideObj=parse_HideObjEnum;var parse_InterfaceEnd=parsenoop2;var parse_LeftMargin=parse_Xnum;var parse_Mms=parsenoop2;var parse_ObjProtect=parsebool;var parse_Password=parseuint16;var parse_PrintGrid=parsebool;var parse_PrintRowCol=parsebool;var parse_PrintSize=parseuint16;var parse_Prot4Rev=parsebool;var parse_Prot4RevPass=parseuint16;var parse_Protect=parsebool;var parse_RefreshAll=parsebool;var parse_RightMargin=parse_Xnum;var parse_RRTabId=parseuint16a;var parse_ScenarioProtect=parsebool;var parse_Scl=parseuint16a;var parse_String=parse_XLUnicodeString;var parse_SxBool=parsebool;var parse_TopMargin=parse_Xnum;var parse_UsesELFs=parsebool;var parse_VCenter=parsebool;var parse_WinProtect=parsebool;var parse_WriteProtect=parsenoop;var parse_VerticalPageBreaks=parsenoop;var parse_HorizontalPageBreaks=parsenoop;var parse_Selection=parsenoop;var parse_Continue=parsenoop;var parse_Pane=parsenoop;var parse_Pls=parsenoop;var parse_DCon=parsenoop;var parse_DConRef=parsenoop;var parse_DConName=parsenoop;var parse_XCT=parsenoop;var parse_CRN=parsenoop;var parse_FileSharing=parsenoop;var parse_Uncalced=parsenoop;var parse_Template=parsenoop;var parse_Intl=parsenoop;var parse_WsBool=parsenoop;var parse_Sort=parsenoop;var parse_Sync=parsenoop;var parse_LPr=parsenoop;var parse_DxGCol=parsenoop;var parse_FnGroupName=parsenoop;var parse_FilterMode=parsenoop;var parse_AutoFilterInfo=parsenoop;var parse_AutoFilter=parsenoop;var parse_Setup=parsenoop;var parse_ScenMan=parsenoop;var parse_SCENARIO=parsenoop;var parse_SxView=parsenoop;var parse_Sxvd=parsenoop;var parse_SXVI=parsenoop;var parse_SxIvd=parsenoop;var parse_SXLI=parsenoop;var parse_SXPI=parsenoop;var parse_DocRoute=parsenoop;var parse_RecipName=parsenoop;var parse_MulBlank=parsenoop;var parse_SXDI=parsenoop;var parse_SXDB=parsenoop;var parse_SXFDB=parsenoop;var parse_SXDBB=parsenoop;var parse_SXNum=parsenoop;var parse_SxErr=parsenoop;var parse_SXInt=parsenoop;var parse_SXString=parsenoop;var parse_SXDtr=parsenoop;var parse_SxNil=parsenoop;var parse_SXTbl=parsenoop;var parse_SXTBRGIITM=parsenoop;var parse_SxTbpg=parsenoop;var parse_ObProj=parsenoop;var parse_SXStreamID=parsenoop;var parse_DBCell=parsenoop;var parse_SXRng=parsenoop;var parse_SxIsxoper=parsenoop;var parse_BookBool=parsenoop;var parse_DbOrParamQry=parsenoop;var parse_OleObjectSize=parsenoop;var parse_SXVS=parsenoop;var parse_BkHim=parsenoop;var parse_MsoDrawingGroup=parsenoop;var parse_MsoDrawing=parsenoop;var parse_MsoDrawingSelection=parsenoop;var parse_PhoneticInfo=parsenoop;var parse_SxRule=parsenoop;var parse_SXEx=parsenoop;var parse_SxFilt=parsenoop;var parse_SxDXF=parsenoop;var parse_SxItm=parsenoop;var parse_SxName=parsenoop;var parse_SxSelect=parsenoop;var parse_SXPair=parsenoop;var parse_SxFmla=parsenoop;var parse_SxFormat=parsenoop;var parse_SXVDEx=parsenoop;var parse_SXFormula=parsenoop;var parse_SXDBEx=parsenoop;var parse_RRDInsDel=parsenoop;var parse_RRDHead=parsenoop;var parse_RRDChgCell=parsenoop;var parse_RRDRenSheet=parsenoop;var parse_RRSort=parsenoop;var parse_RRDMove=parsenoop;var parse_RRFormat=parsenoop;var parse_RRAutoFmt=parsenoop;var parse_RRInsertSh=parsenoop;var parse_RRDMoveBegin=parsenoop;var parse_RRDMoveEnd=parsenoop;var parse_RRDInsDelBegin=parsenoop;var parse_RRDInsDelEnd=parsenoop;var parse_RRDConflict=parsenoop;var parse_RRDDefName=parsenoop;var parse_RRDRstEtxp=parsenoop;var parse_LRng=parsenoop;var parse_CUsr=parsenoop;var parse_CbUsr=parsenoop;var parse_UsrInfo=parsenoop;var parse_UsrExcl=parsenoop;var parse_FileLock=parsenoop;var parse_RRDInfo=parsenoop;var parse_BCUsrs=parsenoop;var parse_UsrChk=parsenoop;var parse_UserBView=parsenoop;var parse_UserSViewBegin=parsenoop;var parse_UserSViewEnd=parsenoop;var parse_RRDUserView=parsenoop;var parse_Qsi=parsenoop;var parse_CondFmt=parsenoop;var parse_CF=parsenoop;var parse_DVal=parsenoop;var parse_DConBin=parsenoop;var parse_Lel=parsenoop;var parse_XLSCodeName=parse_XLUnicodeString;var parse_SXFDBType=parsenoop;var parse_ObNoMacros=parsenoop;var parse_Dv=parsenoop;var parse_Index=parsenoop;var parse_Table=parsenoop;var parse_BigName=parsenoop;var parse_ContinueBigName=parsenoop;var parse_WebPub=parsenoop;var parse_QsiSXTag=parsenoop;var parse_DBQueryExt=parsenoop;var parse_ExtString=parsenoop;var parse_TxtQry=parsenoop;var parse_Qsir=parsenoop;var parse_Qsif=parsenoop;var parse_RRDTQSIF=parsenoop;var parse_OleDbConn=parsenoop;var parse_WOpt=parsenoop;var parse_SXViewEx=parsenoop;var parse_SXTH=parsenoop;var parse_SXPIEx=parsenoop;var parse_SXVDTEx=parsenoop;var parse_SXViewEx9=parsenoop;var parse_ContinueFrt=parsenoop;var parse_RealTimeData=parsenoop;var parse_ChartFrtInfo=parsenoop;var parse_FrtWrapper=parsenoop;var parse_StartBlock=parsenoop;var parse_EndBlock=parsenoop;var parse_StartObject=parsenoop;var parse_EndObject=parsenoop;var parse_CatLab=parsenoop;var parse_YMult=parsenoop;var parse_SXViewLink=parsenoop;var parse_PivotChartBits=parsenoop;var parse_FrtFontList=parsenoop;var parse_SheetExt=parsenoop;var parse_BookExt=parsenoop;var parse_SXAddl=parsenoop;var parse_CrErr=parsenoop;var parse_HFPicture=parsenoop;var parse_Feat=parsenoop;var parse_DataLabExt=parsenoop;var parse_DataLabExtContents=parsenoop;var parse_CellWatch=parsenoop;var parse_FeatHdr11=parsenoop;var parse_Feature11=parsenoop;var parse_DropDownObjIds=parsenoop;var parse_ContinueFrt11=parsenoop;var parse_DConn=parsenoop;var parse_List12=parsenoop;var parse_Feature12=parsenoop;var parse_CondFmt12=parsenoop;var parse_CF12=parsenoop;var parse_CFEx=parsenoop;var parse_AutoFilter12=parsenoop;var parse_ContinueFrt12=parsenoop;var parse_MDTInfo=parsenoop;var parse_MDXStr=parsenoop;var parse_MDXTuple=parsenoop;var parse_MDXSet=parsenoop;var parse_MDXProp=parsenoop;var parse_MDXKPI=parsenoop;var parse_MDB=parsenoop;var parse_PLV=parsenoop;var parse_DXF=parsenoop;var parse_TableStyles=parsenoop;var parse_TableStyle=parsenoop;var parse_TableStyleElement=parsenoop;var parse_NamePublish=parsenoop;var parse_NameCmt=parsenoop;var parse_SortData=parsenoop;var parse_GUIDTypeLib=parsenoop;var parse_FnGrp12=parsenoop;var parse_NameFnGrp12=parsenoop;var parse_HeaderFooter=parsenoop;var parse_CrtLayout12=parsenoop;var parse_CrtMlFrt=parsenoop;var parse_CrtMlFrtContinue=parsenoop;var parse_ShapePropsStream=parsenoop;var parse_TextPropsStream=parsenoop;var parse_RichTextStream=parsenoop;var parse_CrtLayout12A=parsenoop;var parse_Units=parsenoop;var parse_Chart=parsenoop;var parse_Series=parsenoop;var parse_DataFormat=parsenoop;var parse_LineFormat=parsenoop;var parse_MarkerFormat=parsenoop;var parse_AreaFormat=parsenoop;var parse_PieFormat=parsenoop;var parse_AttachedLabel=parsenoop;var parse_SeriesText=parsenoop;var parse_ChartFormat=parsenoop;var parse_Legend=parsenoop;var parse_SeriesList=parsenoop;var parse_Bar=parsenoop;var parse_Line=parsenoop;var parse_Pie=parsenoop;var parse_Area=parsenoop;var parse_Scatter=parsenoop;var parse_CrtLine=parsenoop;var parse_Axis=parsenoop;var parse_Tick=parsenoop;var parse_ValueRange=parsenoop;var parse_CatSerRange=parsenoop;var parse_AxisLine=parsenoop;var parse_CrtLink=parsenoop;var parse_DefaultText=parsenoop;var parse_Text=parsenoop;var parse_ObjectLink=parsenoop;var parse_Frame=parsenoop;var parse_Begin=parsenoop;var parse_End=parsenoop;var parse_PlotArea=parsenoop;var parse_Chart3d=parsenoop;var parse_PicF=parsenoop;var parse_DropBar=parsenoop;var parse_Radar=parsenoop;var parse_Surf=parsenoop;var parse_RadarArea=parsenoop;var parse_AxisParent=parsenoop;var parse_LegendException=parsenoop;var parse_ShtProps=parsenoop;var parse_SerToCrt=parsenoop;var parse_AxesUsed=parsenoop;var parse_SBaseRef=parsenoop;var parse_SerParent=parsenoop;var parse_SerAuxTrend=parsenoop;var parse_IFmtRecord=parsenoop;var parse_Pos=parsenoop;var parse_AlRuns=parsenoop;var parse_BRAI=parsenoop;var parse_SerAuxErrBar=parsenoop;var parse_SerFmt=parsenoop;var parse_Chart3DBarShape=parsenoop;var parse_Fbi=parsenoop;var parse_BopPop=parsenoop;var parse_AxcExt=parsenoop;var parse_Dat=parsenoop;var parse_PlotGrowth=parsenoop;var parse_SIIndex=parsenoop;var parse_GelFrame=parsenoop;var parse_BopPopCustom=parsenoop;var parse_Fbi2=parsenoop;function parse_BIFF5String(blob){var len=blob.read_shift(1);return blob.read_shift(len,\"sbcs-cont\")}function parse_BIFF2STR(blob,length,opts){var cell=parse_XLSCell(blob,6);++blob.l;var str=parse_XLUnicodeString2(blob,length-7,opts);cell.val=str;return cell}function parse_BIFF2NUM(blob,length,opts){var cell=parse_XLSCell(blob,6);++blob.l;var num=parse_Xnum(blob,8);cell.val=num;return cell}var CS2CP={0:1252,1:65001,2:65001,77:1e4,128:932,129:949,130:1361,134:936,136:950,161:1253,162:1254,163:1258,177:1255,178:1256,186:1257,204:1251,222:874,238:1250,255:1252,69:6969};var parse_rs=function parse_rs_factory(){var tregex=matchtag(\"t\"),rpregex=matchtag(\"rPr\"),rregex=/<r>/g,rend=/<\\/r>/,nlregex=/\\r\\n/g;var parse_rpr=function parse_rpr(rpr,intro,outro){var font={},cp=65001;var m=rpr.match(tagregex),i=0;if(m)for(;i!=m.length;++i){var y=parsexmltag(m[i]);switch(y[0]){case\"<condense\":break;case\"<extend\":break;case\"<shadow\":case\"<shadow/>\":break;case\"<charset\":if(y.val==\"1\")break;cp=CS2CP[parseInt(y.val,10)];break;case\"<outline\":case\"<outline/>\":break;case\"<rFont\":font.name=y.val;break;case\"<sz\":font.sz=y.val;break;case\"<strike\":if(!y.val)break;case\"<strike/>\":font.strike=1;break;case\"</strike>\":break;case\"<u\":if(!y.val)break;case\"<u/>\":font.u=1;break;case\"</u>\":break;case\"<b\":if(!y.val)break;case\"<b/>\":font.b=1;break;case\"</b>\":break;case\"<i\":if(!y.val)break;case\"<i/>\":font.i=1;break;case\"</i>\":break;case\"<color\":if(y.rgb)font.color=y.rgb.substr(2,6);break;case\"<family\":font.family=y.val;break;case\"<vertAlign\":break;case\"<scheme\":break;default:if(y[0].charCodeAt(1)!==47)throw\"Unrecognized rich format \"+y[0]}}var style=[];if(font.b)style.push(\"font-weight: bold;\");if(font.i)style.push(\"font-style: italic;\");intro.push('<span style=\"'+style.join(\"\")+'\">');outro.push(\"</span>\");return cp};function parse_r(r){var terms=[[],\"\",[]];var t=r.match(tregex),cp=65001;if(!isval(t))return\"\";terms[1]=t[1];var rpr=r.match(rpregex);if(isval(rpr))cp=parse_rpr(rpr[1],terms[0],terms[2]);return terms[0].join(\"\")+terms[1].replace(nlregex,\"<br/>\")+terms[2].join(\"\")}return function parse_rs(rs){return rs.replace(rregex,\"\").split(rend).map(parse_r).join(\"\")}}();var sitregex=/<t[^>]*>([^<]*)<\\/t>/g,sirregex=/<r>/;function parse_si(x,opts){var html=opts?opts.cellHTML:true;var z={};if(!x)return null;var y;if(x.charCodeAt(1)===116){z.t=utf8read(unescapexml(x.substr(x.indexOf(\">\")+1).split(/<\\/t>/)[0]));z.r=x;if(html)z.h=z.t}else if(y=x.match(sirregex)){z.r=x;z.t=utf8read(unescapexml(x.match(sitregex).join(\"\").replace(tagregex,\"\")));if(html)z.h=parse_rs(x)}return z}var sstr0=/<sst([^>]*)>([\\s\\S]*)<\\/sst>/;var sstr1=/<(?:si|sstItem)>/g;var sstr2=/<\\/(?:si|sstItem)>/;function parse_sst_xml(data,opts){var s=[],ss;var sst=data.match(sstr0);if(isval(sst)){ss=sst[2].replace(sstr1,\"\").split(sstr2);for(var i=0;i!=ss.length;++i){var o=parse_si(ss[i],opts);if(o!=null)s[s.length]=o}sst=parsexmltag(sst[1]);s.Count=sst.count;s.Unique=sst.uniqueCount}return s}RELS.SST=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings\";var straywsregex=/^\\s|\\s$|[\\t\\n\\r]/;function write_sst_xml(sst,opts){if(!opts.bookSST)return\"\";var o=[XML_HEADER];o[o.length]=writextag(\"sst\",null,{xmlns:XMLNS.main[0],count:sst.Count,uniqueCount:sst.Unique});for(var i=0;i!=sst.length;++i){if(sst[i]==null)continue;var s=sst[i];var sitag=\"<si>\";if(s.r)sitag+=s.r;else{sitag+=\"<t\";if(s.t.match(straywsregex))sitag+=' xml:space=\"preserve\"';sitag+=\">\"+escapexml(s.t)+\"</t>\"}sitag+=\"</si>\";o[o.length]=sitag}if(o.length>2){o[o.length]=\"</sst>\";o[1]=o[1].replace(\"/>\",\">\")}return o.join(\"\")}function parse_BrtBeginSst(data,length){return[data.read_shift(4),data.read_shift(4)]}function parse_sst_bin(data,opts){var s=[];var pass=false;recordhopper(data,function hopper_sst(val,R,RT){switch(R.n){case\"BrtBeginSst\":s.Count=val[0];s.Unique=val[1];break;case\"BrtSSTItem\":s.push(val);break;case\"BrtEndSst\":return true;case\"BrtFRTBegin\":pass=true;break;case\"BrtFRTEnd\":pass=false;break;default:if(!pass||opts.WTF)throw new Error(\"Unexpected record \"+RT+\" \"+R.n)}});return s}function write_BrtBeginSst(sst,o){if(!o)o=new_buf(8);o.write_shift(4,sst.Count);o.write_shift(4,sst.Unique);return o}var write_BrtSSTItem=write_RichStr;function write_sst_bin(sst,opts){var ba=buf_array();write_record(ba,\"BrtBeginSst\",write_BrtBeginSst(sst));for(var i=0;i<sst.length;++i)write_record(ba,\"BrtSSTItem\",write_BrtSSTItem(sst[i]));write_record(ba,\"BrtEndSst\");return ba.end()}function _JS2ANSI(str){if(typeof cptable!==\"undefined\")return cptable.utils.encode(1252,str);return str.split(\"\").map(function(x){return x.charCodeAt(0)})}function parse_Version(blob,length){var o={};o.Major=blob.read_shift(2);o.Minor=blob.read_shift(2);return o}function parse_EncryptionHeader(blob,length){var o={};o.Flags=blob.read_shift(4);var tmp=blob.read_shift(4);if(tmp!==0)throw\"Unrecognized SizeExtra: \"+tmp;o.AlgID=blob.read_shift(4);switch(o.AlgID){case 0:case 26625:case 26126:case 26127:case 26128:break;default:throw\"Unrecognized encryption algorithm: \"+o.AlgID}parsenoop(blob,length-12);return o}function parse_EncryptionVerifier(blob,length){return parsenoop(blob,length)}function parse_RC4CryptoHeader(blob,length){var o={};var vers=o.EncryptionVersionInfo=parse_Version(blob,4);length-=4;if(vers.Minor!=2)throw\"unrecognized minor version code: \"+vers.Minor;if(vers.Major>4||vers.Major<2)throw\"unrecognized major version code: \"+vers.Major;o.Flags=blob.read_shift(4);length-=4;var sz=blob.read_shift(4);length-=4;o.EncryptionHeader=parse_EncryptionHeader(blob,sz);length-=sz;o.EncryptionVerifier=parse_EncryptionVerifier(blob,length);return o}function parse_RC4Header(blob,length){var o={};var vers=o.EncryptionVersionInfo=parse_Version(blob,4);length-=4;if(vers.Major!=1||vers.Minor!=1)throw\"unrecognized version code \"+vers.Major+\" : \"+vers.Minor;o.Salt=blob.read_shift(16);o.EncryptedVerifier=blob.read_shift(16);o.EncryptedVerifierHash=blob.read_shift(16);return o}function crypto_CreatePasswordVerifier_Method1(Password){var Verifier=0,PasswordArray;var PasswordDecoded=_JS2ANSI(Password);var len=PasswordDecoded.length+1,i,PasswordByte;var Intermediate1,Intermediate2,Intermediate3;PasswordArray=new_raw_buf(len);PasswordArray[0]=PasswordDecoded.length;for(i=1;i!=len;++i)PasswordArray[i]=PasswordDecoded[i-1];for(i=len-1;i>=0;--i){PasswordByte=PasswordArray[i];Intermediate1=(Verifier&16384)===0?0:1;Intermediate2=Verifier<<1&32767;Intermediate3=Intermediate1|Intermediate2;Verifier=Intermediate3^PasswordByte}return Verifier^52811}var crypto_CreateXorArray_Method1=function(){var PadArray=[187,255,255,186,255,255,185,128,0,190,15,0,191,15,0];var InitialCode=[57840,7439,52380,33984,4364,3600,61902,12606,6258,57657,54287,34041,10252,43370,20163];var XorMatrix=[44796,19929,39858,10053,20106,40212,10761,31585,63170,64933,60267,50935,40399,11199,17763,35526,1453,2906,5812,11624,23248,885,1770,3540,7080,14160,28320,56640,55369,41139,20807,41614,21821,43642,17621,28485,56970,44341,19019,38038,14605,29210,60195,50791,40175,10751,21502,43004,24537,18387,36774,3949,7898,15796,31592,63184,47201,24803,49606,37805,14203,28406,56812,17824,35648,1697,3394,6788,13576,27152,43601,17539,35078,557,1114,2228,4456,30388,60776,51953,34243,7079,14158,28316,14128,28256,56512,43425,17251,34502,7597,13105,26210,52420,35241,883,1766,3532,4129,8258,16516,33032,4657,9314,18628];var Ror=function(Byte){return(Byte/2|Byte*128)&255};var XorRor=function(byte1,byte2){return Ror(byte1^byte2)};var CreateXorKey_Method1=function(Password){var XorKey=InitialCode[Password.length-1];var CurrentElement=104;for(var i=Password.length-1;i>=0;--i){var Char=Password[i];for(var j=0;j!=7;++j){if(Char&64)XorKey^=XorMatrix[CurrentElement];Char*=2;--CurrentElement}}return XorKey};return function(password){var Password=_JS2ANSI(password);var XorKey=CreateXorKey_Method1(Password);var Index=Password.length;var ObfuscationArray=new_raw_buf(16);for(var i=0;i!=16;++i)ObfuscationArray[i]=0;var Temp,PasswordLastChar,PadIndex;if((Index&1)===1){Temp=XorKey>>8;ObfuscationArray[Index]=XorRor(PadArray[0],Temp);--Index;Temp=XorKey&255;PasswordLastChar=Password[Password.length-1];ObfuscationArray[Index]=XorRor(PasswordLastChar,Temp)}while(Index>0){--Index;Temp=XorKey>>8;ObfuscationArray[Index]=XorRor(Password[Index],Temp);--Index;Temp=XorKey&255;ObfuscationArray[Index]=XorRor(Password[Index],Temp)}Index=15;PadIndex=15-Password.length;while(PadIndex>0){Temp=XorKey>>8;ObfuscationArray[Index]=XorRor(PadArray[PadIndex],Temp);--Index;--PadIndex;Temp=XorKey&255;ObfuscationArray[Index]=XorRor(Password[Index],Temp);--Index;--PadIndex}return ObfuscationArray}}();var crypto_DecryptData_Method1=function(password,Data,XorArrayIndex,XorArray,O){if(!O)O=Data;if(!XorArray)XorArray=crypto_CreateXorArray_Method1(password);var Index,Value;for(Index=0;Index!=Data.length;++Index){Value=Data[Index];Value^=XorArray[XorArrayIndex];Value=(Value>>5|Value<<3)&255;O[Index]=Value;++XorArrayIndex}return[O,XorArrayIndex,XorArray]};var crypto_MakeXorDecryptor=function(password){var XorArrayIndex=0,XorArray=crypto_CreateXorArray_Method1(password);return function(Data){var O=crypto_DecryptData_Method1(null,Data,XorArrayIndex,XorArray);XorArrayIndex=O[1];return O[0]}};function parse_XORObfuscation(blob,length,opts,out){var o={key:parseuint16(blob),verificationBytes:parseuint16(blob)};if(opts.password)o.verifier=crypto_CreatePasswordVerifier_Method1(opts.password);out.valid=o.verificationBytes===o.verifier;if(out.valid)out.insitu_decrypt=crypto_MakeXorDecryptor(opts.password);return o}function parse_FilePassHeader(blob,length,oo){var o=oo||{};o.Info=blob.read_shift(2);blob.l-=2;if(o.Info===1)o.Data=parse_RC4Header(blob,length);else o.Data=parse_RC4CryptoHeader(blob,length);return o}function parse_FilePass(blob,length,opts){var o={Type:blob.read_shift(2)};if(o.Type)parse_FilePassHeader(blob,length-2,o);else parse_XORObfuscation(blob,length-2,opts,o);return o}function hex2RGB(h){var o=h.substr(h[0]===\"#\"?1:0,6);return[parseInt(o.substr(0,2),16),parseInt(o.substr(0,2),16),parseInt(o.substr(0,2),16)]}function rgb2Hex(rgb){for(var i=0,o=1;i!=3;++i)o=o*256+(rgb[i]>255?255:rgb[i]<0?0:rgb[i]);return o.toString(16).toUpperCase().substr(1)}function rgb2HSL(rgb){var R=rgb[0]/255,G=rgb[1]/255,B=rgb[2]/255;var M=Math.max(R,G,B),m=Math.min(R,G,B),C=M-m;if(C===0)return[0,0,R];var H6=0,S=0,L2=M+m;S=C/(L2>1?2-L2:L2);switch(M){case R:H6=((G-B)/C+6)%6;break;case G:H6=(B-R)/C+2;break;case B:H6=(R-G)/C+4;break}return[H6/6,S,L2/2]}function hsl2RGB(hsl){var H=hsl[0],S=hsl[1],L=hsl[2];var C=S*2*(L<.5?L:1-L),m=L-C/2;var rgb=[m,m,m],h6=6*H;var X;if(S!==0)switch(h6|0){case 0:case 6:X=C*h6;rgb[0]+=C;rgb[1]+=X;break;case 1:X=C*(2-h6);rgb[0]+=X;rgb[1]+=C;break;case 2:X=C*(h6-2);rgb[1]+=C;rgb[2]+=X;break;case 3:X=C*(4-h6);rgb[1]+=X;rgb[2]+=C;break;case 4:X=C*(h6-4);rgb[2]+=C;rgb[0]+=X;break;case 5:X=C*(6-h6);rgb[2]+=X;rgb[0]+=C;break}for(var i=0;i!=3;++i)rgb[i]=Math.round(rgb[i]*255);return rgb}function rgb_tint(hex,tint){if(tint===0)return hex;var hsl=rgb2HSL(hex2RGB(hex));if(tint<0)hsl[2]=hsl[2]*(1+tint);else hsl[2]=1-(1-hsl[2])*(1-tint);return rgb2Hex(hsl2RGB(hsl))}var DEF_MDW=7,MAX_MDW=15,MIN_MDW=1,MDW=DEF_MDW;function width2px(width){return(width+(128/MDW|0)/256)*MDW|0}function px2char(px){return((px-5)/MDW*100+.5|0)/100}function char2width(chr){return((chr*MDW+5)/MDW*256|0)/256}function cycle_width(collw){return char2width(px2char(width2px(collw)))}function find_mdw(collw,coll){if(cycle_width(collw)!=collw){for(MDW=DEF_MDW;MDW>MIN_MDW;--MDW)if(cycle_width(collw)===collw)break;if(MDW===MIN_MDW)for(MDW=DEF_MDW+1;MDW<MAX_MDW;++MDW)if(cycle_width(collw)===collw)break;if(MDW===MAX_MDW)MDW=DEF_MDW}}var XLMLPatternTypeMap={None:\"none\",Solid:\"solid\",Gray50:\"mediumGray\",Gray75:\"darkGray\",Gray25:\"lightGray\",HorzStripe:\"darkHorizontal\",VertStripe:\"darkVertical\",ReverseDiagStripe:\"darkDown\",DiagStripe:\"darkUp\",DiagCross:\"darkGrid\",ThickDiagCross:\"darkTrellis\",ThinHorzStripe:\"lightHorizontal\",ThinVertStripe:\"lightVertical\",ThinReverseDiagStripe:\"lightDown\",ThinHorzCross:\"lightGrid\"};var styles={};var themes={};function parse_fills(t,opts){styles.Fills=[];var fill={};t[0].match(tagregex).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case\"<fills\":case\"<fills>\":case\"</fills>\":break;case\"<fill>\":break;case\"</fill>\":styles.Fills.push(fill);fill={};break;case\"<patternFill\":if(y.patternType)fill.patternType=y.patternType;break;case\"<patternFill/>\":case\"</patternFill>\":break;case\"<bgColor\":if(!fill.bgColor)fill.bgColor={};if(y.indexed)fill.bgColor.indexed=parseInt(y.indexed,10);if(y.theme)fill.bgColor.theme=parseInt(y.theme,10);if(y.tint)fill.bgColor.tint=parseFloat(y.tint);if(y.rgb)fill.bgColor.rgb=y.rgb.substring(y.rgb.length-6);break;case\"<bgColor/>\":case\"</bgColor>\":break;case\"<fgColor\":if(!fill.fgColor)fill.fgColor={};if(y.theme)fill.fgColor.theme=parseInt(y.theme,10);if(y.tint)fill.fgColor.tint=parseFloat(y.tint);if(y.rgb)fill.fgColor.rgb=y.rgb.substring(y.rgb.length-6);break;case\"<fgColor/>\":case\"</fgColor>\":break;default:if(opts.WTF)throw\"unrecognized \"+y[0]+\" in fills\"}})}function parse_numFmts(t,opts){styles.NumberFmt=[];var k=keys(SSF._table);for(var i=0;i<k.length;++i)styles.NumberFmt[k[i]]=SSF._table[k[i]];var m=t[0].match(tagregex);for(i=0;i<m.length;++i){var y=parsexmltag(m[i]);switch(y[0]){case\"<numFmts\":case\"</numFmts>\":case\"<numFmts/>\":case\"<numFmts>\":break;case\"<numFmt\":{var f=unescapexml(utf8read(y.formatCode)),j=parseInt(y.numFmtId,10);styles.NumberFmt[j]=f;if(j>0)SSF.load(f,j)}break;default:if(opts.WTF)throw\"unrecognized \"+y[0]+\" in numFmts\"}}}function write_numFmts(NF,opts){var o=[\"<numFmts>\"];[[5,8],[23,26],[41,44],[63,66],[164,392]].forEach(function(r){for(var i=r[0];i<=r[1];++i)if(NF[i]!==undefined)o[o.length]=writextag(\"numFmt\",null,{numFmtId:i,formatCode:escapexml(NF[i])})});if(o.length===1)return\"\";o[o.length]=\"</numFmts>\";o[0]=writextag(\"numFmts\",null,{count:o.length-2}).replace(\"/>\",\">\");return o.join(\"\")}function parse_cellXfs(t,opts){styles.CellXf=[];t[0].match(tagregex).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case\"<cellXfs\":case\"<cellXfs>\":case\"<cellXfs/>\":case\"</cellXfs>\":break;case\"<xf\":delete y[0];if(y.numFmtId)y.numFmtId=parseInt(y.numFmtId,10);if(y.fillId)y.fillId=parseInt(y.fillId,10);styles.CellXf.push(y);break;case\"</xf>\":break;case\"<alignment\":case\"<alignment/>\":break;case\"<protection\":case\"</protection>\":case\"<protection/>\":break;case\"<extLst\":case\"</extLst>\":break;case\"<ext\":break;default:if(opts.WTF)throw\"unrecognized \"+y[0]+\" in cellXfs\"}})}function write_cellXfs(cellXfs){var o=[];o[o.length]=writextag(\"cellXfs\",null);cellXfs.forEach(function(c){o[o.length]=writextag(\"xf\",null,c)});o[o.length]=\"</cellXfs>\";if(o.length===2)return\"\";o[0]=writextag(\"cellXfs\",null,{count:o.length-2}).replace(\"/>\",\">\");return o.join(\"\")}var parse_sty_xml=function make_pstyx(){var numFmtRegex=/<numFmts([^>]*)>.*<\\/numFmts>/;var cellXfRegex=/<cellXfs([^>]*)>.*<\\/cellXfs>/;var fillsRegex=/<fills([^>]*)>.*<\\/fills>/;return function parse_sty_xml(data,opts){var t;if(t=data.match(numFmtRegex))parse_numFmts(t,opts);if(t=data.match(fillsRegex))parse_fills(t,opts);if(t=data.match(cellXfRegex))parse_cellXfs(t,opts);return styles}}();var STYLES_XML_ROOT=writextag(\"styleSheet\",null,{xmlns:XMLNS.main[0],\"xmlns:vt\":XMLNS.vt});RELS.STY=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles\";function write_sty_xml(wb,opts){var o=[XML_HEADER,STYLES_XML_ROOT],w;if((w=write_numFmts(wb.SSF))!=null)o[o.length]=w;o[o.length]='<fonts count=\"1\"><font><sz val=\"12\"/><color theme=\"1\"/><name val=\"Calibri\"/><family val=\"2\"/><scheme val=\"minor\"/></font></fonts>';o[o.length]='<fills count=\"2\"><fill><patternFill patternType=\"none\"/></fill><fill><patternFill patternType=\"gray125\"/></fill></fills>';o[o.length]='<borders count=\"1\"><border><left/><right/><top/><bottom/><diagonal/></border></borders>';o[o.length]='<cellStyleXfs count=\"1\"><xf numFmtId=\"0\" fontId=\"0\" fillId=\"0\" borderId=\"0\"/></cellStyleXfs>';if(w=write_cellXfs(opts.cellXfs))o[o.length]=w;o[o.length]='<cellStyles count=\"1\"><cellStyle name=\"Normal\" xfId=\"0\" builtinId=\"0\"/></cellStyles>';o[o.length]='<dxfs count=\"0\"/>';o[o.length]='<tableStyles count=\"0\" defaultTableStyle=\"TableStyleMedium9\" defaultPivotStyle=\"PivotStyleMedium4\"/>';if(o.length>2){o[o.length]=\"</styleSheet>\";o[1]=o[1].replace(\"/>\",\">\")}return o.join(\"\")}function parse_BrtFmt(data,length){var ifmt=data.read_shift(2);var stFmtCode=parse_XLWideString(data,length-2);return[ifmt,stFmtCode]}function parse_BrtFont(data,length){var out={flags:{}};out.dyHeight=data.read_shift(2);out.grbit=parse_FontFlags(data,2);out.bls=data.read_shift(2);out.sss=data.read_shift(2);out.uls=data.read_shift(1);out.bFamily=data.read_shift(1);out.bCharSet=data.read_shift(1);data.l++;out.brtColor=parse_BrtColor(data,8);out.bFontScheme=data.read_shift(1);out.name=parse_XLWideString(data,length-21);out.flags.Bold=out.bls===700;out.flags.Italic=out.grbit.fItalic;out.flags.Strikeout=out.grbit.fStrikeout;out.flags.Outline=out.grbit.fOutline;out.flags.Shadow=out.grbit.fShadow;out.flags.Condense=out.grbit.fCondense;out.flags.Extend=out.grbit.fExtend;out.flags.Sub=out.sss&2;out.flags.Sup=out.sss&1;return out}function parse_BrtXF(data,length){var ixfeParent=data.read_shift(2);var ifmt=data.read_shift(2);parsenoop(data,length-4);return{ixfe:ixfeParent,ifmt:ifmt}}function parse_sty_bin(data,opts){styles.NumberFmt=[];for(var y in SSF._table)styles.NumberFmt[y]=SSF._table[y];styles.CellXf=[];var state=\"\";var pass=false;recordhopper(data,function hopper_sty(val,R,RT){switch(R.n){case\"BrtFmt\":styles.NumberFmt[val[0]]=val[1];SSF.load(val[1],val[0]);break;case\"BrtFont\":break;case\"BrtKnownFonts\":break;case\"BrtFill\":break;case\"BrtBorder\":break;case\"BrtXF\":if(state===\"CELLXFS\"){styles.CellXf.push(val)}break;case\"BrtStyle\":break;case\"BrtDXF\":break;case\"BrtMRUColor\":break;case\"BrtIndexedColor\":break;case\"BrtBeginStyleSheet\":break;case\"BrtEndStyleSheet\":break;case\"BrtBeginTableStyle\":break;case\"BrtTableStyleElement\":break;case\"BrtEndTableStyle\":break;case\"BrtBeginFmts\":state=\"FMTS\";break;case\"BrtEndFmts\":state=\"\";break;case\"BrtBeginFonts\":state=\"FONTS\";break;case\"BrtEndFonts\":state=\"\";break;case\"BrtACBegin\":state=\"ACFONTS\";break;case\"BrtACEnd\":state=\"\";break;case\"BrtBeginFills\":state=\"FILLS\";break;case\"BrtEndFills\":state=\"\";break;case\"BrtBeginBorders\":state=\"BORDERS\";break;case\"BrtEndBorders\":state=\"\";break;case\"BrtBeginCellStyleXFs\":state=\"CELLSTYLEXFS\";break;case\"BrtEndCellStyleXFs\":state=\"\";break;case\"BrtBeginCellXFs\":state=\"CELLXFS\";break;case\"BrtEndCellXFs\":state=\"\";break;case\"BrtBeginStyles\":state=\"STYLES\";break;case\"BrtEndStyles\":state=\"\";break;case\"BrtBeginDXFs\":state=\"DXFS\";break;case\"BrtEndDXFs\":state=\"\";break;case\"BrtBeginTableStyles\":state=\"TABLESTYLES\";break;case\"BrtEndTableStyles\":state=\"\";break;case\"BrtBeginColorPalette\":state=\"COLORPALETTE\";break;case\"BrtEndColorPalette\":state=\"\";break;case\"BrtBeginIndexedColors\":state=\"INDEXEDCOLORS\";break;case\"BrtEndIndexedColors\":state=\"\";break;case\"BrtBeginMRUColors\":state=\"MRUCOLORS\";break;case\"BrtEndMRUColors\":state=\"\";break;case\"BrtFRTBegin\":pass=true;break;case\"BrtFRTEnd\":pass=false;break;case\"BrtBeginStyleSheetExt14\":break;case\"BrtBeginSlicerStyles\":break;case\"BrtEndSlicerStyles\":break;case\"BrtBeginTimelineStylesheetExt15\":break;case\"BrtEndTimelineStylesheetExt15\":break;case\"BrtBeginTimelineStyles\":break;case\"BrtEndTimelineStyles\":break;case\"BrtEndStyleSheetExt14\":break;default:if(!pass||opts.WTF)throw new Error(\"Unexpected record \"+RT+\" \"+R.n)}});return styles}function write_sty_bin(data,opts){var ba=buf_array();write_record(ba,\"BrtBeginStyleSheet\");write_record(ba,\"BrtEndStyleSheet\");return ba.end()}RELS.THEME=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme\";function parse_clrScheme(t,opts){themes.themeElements.clrScheme=[];var color={};t[0].match(tagregex).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case\"<a:clrScheme\":case\"</a:clrScheme>\":break;case\"<a:srgbClr\":color.rgb=y.val;break;case\"<a:sysClr\":color.rgb=y.lastClr;break;case\"<a:dk1>\":case\"</a:dk1>\":case\"<a:dk2>\":case\"</a:dk2>\":case\"<a:lt1>\":case\"</a:lt1>\":case\"<a:lt2>\":case\"</a:lt2>\":case\"<a:accent1>\":case\"</a:accent1>\":case\"<a:accent2>\":case\"</a:accent2>\":case\"<a:accent3>\":case\"</a:accent3>\":case\"<a:accent4>\":case\"</a:accent4>\":case\"<a:accent5>\":case\"</a:accent5>\":case\"<a:accent6>\":case\"</a:accent6>\":case\"<a:hlink>\":case\"</a:hlink>\":case\"<a:folHlink>\":case\"</a:folHlink>\":if(y[0][1]===\"/\"){themes.themeElements.clrScheme.push(color);color={}}else{color.name=y[0].substring(3,y[0].length-1)}break;default:if(opts.WTF)throw\"unrecognized \"+y[0]+\" in clrScheme\"}})}function parse_fontScheme(t,opts){}function parse_fmtScheme(t,opts){}var clrsregex=/<a:clrScheme([^>]*)>[^\\u2603]*<\\/a:clrScheme>/;var fntsregex=/<a:fontScheme([^>]*)>[^\\u2603]*<\\/a:fontScheme>/;var fmtsregex=/<a:fmtScheme([^>]*)>[^\\u2603]*<\\/a:fmtScheme>/;function parse_themeElements(data,opts){themes.themeElements={};var t;[[\"clrScheme\",clrsregex,parse_clrScheme],[\"fontScheme\",fntsregex,parse_fontScheme],[\"fmtScheme\",fmtsregex,parse_fmtScheme]].forEach(function(m){if(!(t=data.match(m[1])))throw m[0]+\" not found in themeElements\";m[2](t,opts)})}var themeltregex=/<a:themeElements([^>]*)>[^\\u2603]*<\\/a:themeElements>/;function parse_theme_xml(data,opts){if(!data||data.length===0)return themes;var t;if(!(t=data.match(themeltregex)))throw\"themeElements not found in theme\";parse_themeElements(t[0],opts);return themes}function write_theme(){return'<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\\n<a:theme xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" name=\"Office Theme\"><a:themeElements><a:clrScheme name=\"Office\"><a:dk1><a:sysClr val=\"windowText\" lastClr=\"000000\"/></a:dk1><a:lt1><a:sysClr val=\"window\" lastClr=\"FFFFFF\"/></a:lt1><a:dk2><a:srgbClr val=\"1F497D\"/></a:dk2><a:lt2><a:srgbClr val=\"EEECE1\"/></a:lt2><a:accent1><a:srgbClr val=\"4F81BD\"/></a:accent1><a:accent2><a:srgbClr val=\"C0504D\"/></a:accent2><a:accent3><a:srgbClr val=\"9BBB59\"/></a:accent3><a:accent4><a:srgbClr val=\"8064A2\"/></a:accent4><a:accent5><a:srgbClr val=\"4BACC6\"/></a:accent5><a:accent6><a:srgbClr val=\"F79646\"/></a:accent6><a:hlink><a:srgbClr val=\"0000FF\"/></a:hlink><a:folHlink><a:srgbClr val=\"800080\"/></a:folHlink></a:clrScheme><a:fontScheme name=\"Office\"><a:majorFont><a:latin typeface=\"Cambria\"/><a:ea typeface=\"\"/><a:cs typeface=\"\"/><a:font script=\"Jpan\" typeface=\"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af\"/><a:font script=\"Hang\" typeface=\"\ub9d1\uc740 \uace0\ub515\"/><a:font script=\"Hans\" typeface=\"\u5b8b\u4f53\"/><a:font script=\"Hant\" typeface=\"\u65b0\u7d30\u660e\u9ad4\"/><a:font script=\"Arab\" typeface=\"Times New Roman\"/><a:font script=\"Hebr\" typeface=\"Times New Roman\"/><a:font script=\"Thai\" typeface=\"Tahoma\"/><a:font script=\"Ethi\" typeface=\"Nyala\"/><a:font script=\"Beng\" typeface=\"Vrinda\"/><a:font script=\"Gujr\" typeface=\"Shruti\"/><a:font script=\"Khmr\" typeface=\"MoolBoran\"/><a:font script=\"Knda\" typeface=\"Tunga\"/><a:font script=\"Guru\" typeface=\"Raavi\"/><a:font script=\"Cans\" typeface=\"Euphemia\"/><a:font script=\"Cher\" typeface=\"Plantagenet Cherokee\"/><a:font script=\"Yiii\" typeface=\"Microsoft Yi Baiti\"/><a:font script=\"Tibt\" typeface=\"Microsoft Himalaya\"/><a:font script=\"Thaa\" typeface=\"MV Boli\"/><a:font script=\"Deva\" typeface=\"Mangal\"/><a:font script=\"Telu\" typeface=\"Gautami\"/><a:font script=\"Taml\" typeface=\"Latha\"/><a:font script=\"Syrc\" typeface=\"Estrangelo Edessa\"/><a:font script=\"Orya\" typeface=\"Kalinga\"/><a:font script=\"Mlym\" typeface=\"Kartika\"/><a:font script=\"Laoo\" typeface=\"DokChampa\"/><a:font script=\"Sinh\" typeface=\"Iskoola Pota\"/><a:font script=\"Mong\" typeface=\"Mongolian Baiti\"/><a:font script=\"Viet\" typeface=\"Times New Roman\"/><a:font script=\"Uigh\" typeface=\"Microsoft Uighur\"/><a:font script=\"Geor\" typeface=\"Sylfaen\"/></a:majorFont><a:minorFont><a:latin typeface=\"Calibri\"/><a:ea typeface=\"\"/><a:cs typeface=\"\"/><a:font script=\"Jpan\" typeface=\"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af\"/><a:font script=\"Hang\" typeface=\"\ub9d1\uc740 \uace0\ub515\"/><a:font script=\"Hans\" typeface=\"\u5b8b\u4f53\"/><a:font script=\"Hant\" typeface=\"\u65b0\u7d30\u660e\u9ad4\"/><a:font script=\"Arab\" typeface=\"Arial\"/><a:font script=\"Hebr\" typeface=\"Arial\"/><a:font script=\"Thai\" typeface=\"Tahoma\"/><a:font script=\"Ethi\" typeface=\"Nyala\"/><a:font script=\"Beng\" typeface=\"Vrinda\"/><a:font script=\"Gujr\" typeface=\"Shruti\"/><a:font script=\"Khmr\" typeface=\"DaunPenh\"/><a:font script=\"Knda\" typeface=\"Tunga\"/><a:font script=\"Guru\" typeface=\"Raavi\"/><a:font script=\"Cans\" typeface=\"Euphemia\"/><a:font script=\"Cher\" typeface=\"Plantagenet Cherokee\"/><a:font script=\"Yiii\" typeface=\"Microsoft Yi Baiti\"/><a:font script=\"Tibt\" typeface=\"Microsoft Himalaya\"/><a:font script=\"Thaa\" typeface=\"MV Boli\"/><a:font script=\"Deva\" typeface=\"Mangal\"/><a:font script=\"Telu\" typeface=\"Gautami\"/><a:font script=\"Taml\" typeface=\"Latha\"/><a:font script=\"Syrc\" typeface=\"Estrangelo Edessa\"/><a:font script=\"Orya\" typeface=\"Kalinga\"/><a:font script=\"Mlym\" typeface=\"Kartika\"/><a:font script=\"Laoo\" typeface=\"DokChampa\"/><a:font script=\"Sinh\" typeface=\"Iskoola Pota\"/><a:font script=\"Mong\" typeface=\"Mongolian Baiti\"/><a:font script=\"Viet\" typeface=\"Arial\"/><a:font script=\"Uigh\" typeface=\"Microsoft Uighur\"/><a:font script=\"Geor\" typeface=\"Sylfaen\"/></a:minorFont></a:fontScheme><a:fmtScheme name=\"Office\"><a:fillStyleLst><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"50000\"/><a:satMod val=\"300000\"/></a:schemeClr></a:gs><a:gs pos=\"35000\"><a:schemeClr val=\"phClr\"><a:tint val=\"37000\"/><a:satMod val=\"300000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:tint val=\"15000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs></a:gsLst><a:lin ang=\"16200000\" scaled=\"1\"/></a:gradFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"100000\"/><a:shade val=\"100000\"/><a:satMod val=\"130000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:tint val=\"50000\"/><a:shade val=\"100000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs></a:gsLst><a:lin ang=\"16200000\" scaled=\"0\"/></a:gradFill></a:fillStyleLst><a:lnStyleLst><a:ln w=\"9525\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:solidFill><a:schemeClr val=\"phClr\"><a:shade val=\"95000\"/><a:satMod val=\"105000\"/></a:schemeClr></a:solidFill><a:prstDash val=\"solid\"/></a:ln><a:ln w=\"25400\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:prstDash val=\"solid\"/></a:ln><a:ln w=\"38100\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:prstDash val=\"solid\"/></a:ln></a:lnStyleLst><a:effectStyleLst><a:effectStyle><a:effectLst><a:outerShdw blurRad=\"40000\" dist=\"20000\" dir=\"5400000\" rotWithShape=\"0\"><a:srgbClr val=\"000000\"><a:alpha val=\"38000\"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad=\"40000\" dist=\"23000\" dir=\"5400000\" rotWithShape=\"0\"><a:srgbClr val=\"000000\"><a:alpha val=\"35000\"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad=\"40000\" dist=\"23000\" dir=\"5400000\" rotWithShape=\"0\"><a:srgbClr val=\"000000\"><a:alpha val=\"35000\"/></a:srgbClr></a:outerShdw></a:effectLst><a:scene3d><a:camera prst=\"orthographicFront\"><a:rot lat=\"0\" lon=\"0\" rev=\"0\"/></a:camera><a:lightRig rig=\"threePt\" dir=\"t\"><a:rot lat=\"0\" lon=\"0\" rev=\"1200000\"/></a:lightRig></a:scene3d><a:sp3d><a:bevelT w=\"63500\" h=\"25400\"/></a:sp3d></a:effectStyle></a:effectStyleLst><a:bgFillStyleLst><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"40000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs><a:gs pos=\"40000\"><a:schemeClr val=\"phClr\"><a:tint val=\"45000\"/><a:shade val=\"99000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:shade val=\"20000\"/><a:satMod val=\"255000\"/></a:schemeClr></a:gs></a:gsLst><a:path path=\"circle\"><a:fillToRect l=\"50000\" t=\"-80000\" r=\"50000\" b=\"180000\"/></a:path></a:gradFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"80000\"/><a:satMod val=\"300000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:shade val=\"30000\"/><a:satMod val=\"200000\"/></a:schemeClr></a:gs></a:gsLst><a:path path=\"circle\"><a:fillToRect l=\"50000\" t=\"50000\" r=\"50000\" b=\"50000\"/></a:path></a:gradFill></a:bgFillStyleLst></a:fmtScheme></a:themeElements><a:objectDefaults><a:spDef><a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx=\"1\"><a:schemeClr val=\"accent1\"/></a:lnRef><a:fillRef idx=\"3\"><a:schemeClr val=\"accent1\"/></a:fillRef><a:effectRef idx=\"2\"><a:schemeClr val=\"accent1\"/></a:effectRef><a:fontRef idx=\"minor\"><a:schemeClr val=\"lt1\"/></a:fontRef></a:style></a:spDef><a:lnDef><a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx=\"2\"><a:schemeClr val=\"accent1\"/></a:lnRef><a:fillRef idx=\"0\"><a:schemeClr val=\"accent1\"/></a:fillRef><a:effectRef idx=\"1\"><a:schemeClr val=\"accent1\"/></a:effectRef><a:fontRef idx=\"minor\"><a:schemeClr val=\"tx1\"/></a:fontRef></a:style></a:lnDef></a:objectDefaults><a:extraClrSchemeLst/></a:theme>'\n}function parse_Theme(blob,length){var dwThemeVersion=blob.read_shift(4);if(dwThemeVersion===124226)return;blob.l+=length-4}function parse_ColorTheme(blob,length){return blob.read_shift(4)}function parse_FullColorExt(blob,length){var o={};o.xclrType=blob.read_shift(2);o.nTintShade=blob.read_shift(2);switch(o.xclrType){case 0:blob.l+=4;break;case 1:o.xclrValue=parse_IcvXF(blob,4);break;case 2:o.xclrValue=parse_LongRGBA(blob,4);break;case 3:o.xclrValue=parse_ColorTheme(blob,4);break;case 4:blob.l+=4;break}blob.l+=8;return o}function parse_IcvXF(blob,length){return parsenoop(blob,length)}function parse_XFExtGradient(blob,length){return parsenoop(blob,length)}function parse_ExtProp(blob,length){var extType=blob.read_shift(2);var cb=blob.read_shift(2);var o=[extType];switch(extType){case 4:case 5:case 7:case 8:case 9:case 10:case 11:case 13:o[1]=parse_FullColorExt(blob,cb);break;case 6:o[1]=parse_XFExtGradient(blob,cb);break;case 14:case 15:o[1]=blob.read_shift(cb===5?1:2);break;default:throw new Error(\"Unrecognized ExtProp type: \"+extType+\" \"+cb)}return o}function parse_XFExt(blob,length){var end=blob.l+length;blob.l+=2;var ixfe=blob.read_shift(2);blob.l+=2;var cexts=blob.read_shift(2);var ext=[];while(cexts-->0)ext.push(parse_ExtProp(blob,end-blob.l));return{ixfe:ixfe,ext:ext}}function update_xfext(xf,xfext){xfext.forEach(function(xfe){switch(xfe[0]){case 4:break;case 5:break;case 7:case 8:case 9:case 10:break;case 13:break;case 14:break;default:throw\"bafuq\"+xfe[0].toString(16)}})}function parse_cc_xml(data,opts){var d=[];var l=0,i=1;(data.match(tagregex)||[]).forEach(function(x){var y=parsexmltag(x);switch(y[0]){case\"<?xml\":break;case\"<calcChain\":case\"<calcChain>\":case\"</calcChain>\":break;case\"<c\":delete y[0];if(y.i)i=y.i;else y.i=i;d.push(y);break}});return d}function write_cc_xml(data,opts){}function parse_BrtCalcChainItem$(data,length){var out={};out.i=data.read_shift(4);var cell={};cell.r=data.read_shift(4);cell.c=data.read_shift(4);out.r=encode_cell(cell);var flags=data.read_shift(1);if(flags&2)out.l=\"1\";if(flags&8)out.a=\"1\";return out}function parse_cc_bin(data,opts){var out=[];var pass=false;recordhopper(data,function hopper_cc(val,R,RT){switch(R.n){case\"BrtCalcChainItem$\":out.push(val);break;case\"BrtBeginCalcChain$\":break;case\"BrtEndCalcChain$\":break;default:if(!pass||opts.WTF)throw new Error(\"Unexpected record \"+RT+\" \"+R.n)}});return out}function write_cc_bin(data,opts){}function parse_comments(zip,dirComments,sheets,sheetRels,opts){for(var i=0;i!=dirComments.length;++i){var canonicalpath=dirComments[i];var comments=parse_cmnt(getzipdata(zip,canonicalpath.replace(/^\\//,\"\"),true),canonicalpath,opts);if(!comments||!comments.length)continue;var sheetNames=keys(sheets);for(var j=0;j!=sheetNames.length;++j){var sheetName=sheetNames[j];var rels=sheetRels[sheetName];if(rels){var rel=rels[canonicalpath];if(rel)insertCommentsIntoSheet(sheetName,sheets[sheetName],comments)}}}}function insertCommentsIntoSheet(sheetName,sheet,comments){comments.forEach(function(comment){var cell=sheet[comment.ref];if(!cell){cell={};sheet[comment.ref]=cell;var range=safe_decode_range(sheet[\"!ref\"]||\"BDWGO1000001:A1\");var thisCell=decode_cell(comment.ref);if(range.s.r>thisCell.r)range.s.r=thisCell.r;if(range.e.r<thisCell.r)range.e.r=thisCell.r;if(range.s.c>thisCell.c)range.s.c=thisCell.c;if(range.e.c<thisCell.c)range.e.c=thisCell.c;var encoded=encode_range(range);if(encoded!==sheet[\"!ref\"])sheet[\"!ref\"]=encoded}if(!cell.c)cell.c=[];var o={a:comment.author,t:comment.t,r:comment.r};if(comment.h)o.h=comment.h;cell.c.push(o)})}function parse_comments_xml(data,opts){if(data.match(/<(?:\\w+:)?comments *\\/>/))return[];var authors=[];var commentList=[];data.match(/<(?:\\w+:)?authors>([^\\u2603]*)<\\/(?:\\w+:)?authors>/)[1].split(/<\\/\\w*:?author>/).forEach(function(x){if(x===\"\"||x.trim()===\"\")return;authors.push(x.match(/<(?:\\w+:)?author[^>]*>(.*)/)[1])});(data.match(/<(?:\\w+:)?commentList>([^\\u2603]*)<\\/(?:\\w+:)?commentList>/)||[\"\",\"\"])[1].split(/<\\/\\w*:?comment>/).forEach(function(x,index){if(x===\"\"||x.trim()===\"\")return;var y=parsexmltag(x.match(/<(?:\\w+:)?comment[^>]*>/)[0]);var comment={author:y.authorId&&authors[y.authorId]?authors[y.authorId]:undefined,ref:y.ref,guid:y.guid};var cell=decode_cell(y.ref);if(opts.sheetRows&&opts.sheetRows<=cell.r)return;var textMatch=x.match(/<text>([^\\u2603]*)<\\/text>/);if(!textMatch||!textMatch[1])return;var rt=parse_si(textMatch[1]);comment.r=rt.r;comment.t=rt.t;if(opts.cellHTML)comment.h=rt.h;commentList.push(comment)});return commentList}function write_comments_xml(data,opts){}function parse_BrtBeginComment(data,length){var out={};out.iauthor=data.read_shift(4);var rfx=parse_UncheckedRfX(data,16);out.rfx=rfx.s;out.ref=encode_cell(rfx.s);data.l+=16;return out}var parse_BrtCommentAuthor=parse_XLWideString;var parse_BrtCommentText=parse_RichStr;function parse_comments_bin(data,opts){var out=[];var authors=[];var c={};var pass=false;recordhopper(data,function hopper_cmnt(val,R,RT){switch(R.n){case\"BrtCommentAuthor\":authors.push(val);break;case\"BrtBeginComment\":c=val;break;case\"BrtCommentText\":c.t=val.t;c.h=val.h;c.r=val.r;break;case\"BrtEndComment\":c.author=authors[c.iauthor];delete c.iauthor;if(opts.sheetRows&&opts.sheetRows<=c.rfx.r)break;delete c.rfx;out.push(c);break;case\"BrtBeginComments\":break;case\"BrtEndComments\":break;case\"BrtBeginCommentAuthors\":break;case\"BrtEndCommentAuthors\":break;case\"BrtBeginCommentList\":break;case\"BrtEndCommentList\":break;default:if(!pass||opts.WTF)throw new Error(\"Unexpected record \"+RT+\" \"+R.n)}});return out}function write_comments_bin(data,opts){}var rc_to_a1=function(){var rcregex=/(^|[^A-Za-z])R(\\[?)(-?\\d+|)\\]?C(\\[?)(-?\\d+|)\\]?/g;var rcbase;function rcfunc($$,$1,$2,$3,$4,$5){var R=$3.length>0?parseInt($3,10)|0:0,C=$5.length>0?parseInt($5,10)|0:0;if(C<0&&$4.length===0)C=0;if($4.length>0)C+=rcbase.c;if($2.length>0)R+=rcbase.r;return $1+encode_col(C)+encode_row(R)}return function rc_to_a1(fstr,base){rcbase=base;return fstr.replace(rcregex,rcfunc)}}();function parseread(l){return function(blob,length){blob.l+=l;return}}function parseread1(blob,length){blob.l+=1;return}function parse_ColRelU(blob,length){var c=blob.read_shift(2);return[c&16383,c>>14&1,c>>15&1]}function parse_RgceArea(blob,length){var r=blob.read_shift(2),R=blob.read_shift(2);var c=parse_ColRelU(blob,2);var C=parse_ColRelU(blob,2);return{s:{r:r,c:c[0],cRel:c[1],rRel:c[2]},e:{r:R,c:C[0],cRel:C[1],rRel:C[2]}}}function parse_RgceAreaRel(blob,length){var r=blob.read_shift(2),R=blob.read_shift(2);var c=parse_ColRelU(blob,2);var C=parse_ColRelU(blob,2);return{s:{r:r,c:c[0],cRel:c[1],rRel:c[2]},e:{r:R,c:C[0],cRel:C[1],rRel:C[2]}}}function parse_RgceLoc(blob,length){var r=blob.read_shift(2);var c=parse_ColRelU(blob,2);return{r:r,c:c[0],cRel:c[1],rRel:c[2]}}function parse_RgceLocRel(blob,length){var r=blob.read_shift(2);var cl=blob.read_shift(2);var cRel=(cl&32768)>>15,rRel=(cl&16384)>>14;cl&=16383;if(cRel!==0)while(cl>=256)cl-=256;return{r:r,c:cl,cRel:cRel,rRel:rRel}}function parse_PtgArea(blob,length){var type=(blob[blob.l++]&96)>>5;var area=parse_RgceArea(blob,8);return[type,area]}function parse_PtgArea3d(blob,length){var type=(blob[blob.l++]&96)>>5;var ixti=blob.read_shift(2);var area=parse_RgceArea(blob,8);return[type,ixti,area]}function parse_PtgAreaErr(blob,length){var type=(blob[blob.l++]&96)>>5;blob.l+=8;return[type]}function parse_PtgAreaErr3d(blob,length){var type=(blob[blob.l++]&96)>>5;var ixti=blob.read_shift(2);blob.l+=8;return[type,ixti]}function parse_PtgAreaN(blob,length){var type=(blob[blob.l++]&96)>>5;var area=parse_RgceAreaRel(blob,8);return[type,area]}function parse_PtgArray(blob,length){var type=(blob[blob.l++]&96)>>5;blob.l+=7;return[type]}function parse_PtgAttrBaxcel(blob,length){var bitSemi=blob[blob.l+1]&1;var bitBaxcel=1;blob.l+=4;return[bitSemi,bitBaxcel]}function parse_PtgAttrChoose(blob,length){blob.l+=2;var offset=blob.read_shift(2);var o=[];for(var i=0;i<=offset;++i)o.push(blob.read_shift(2));return o}function parse_PtgAttrGoto(blob,length){var bitGoto=blob[blob.l+1]&255?1:0;blob.l+=2;return[bitGoto,blob.read_shift(2)]}function parse_PtgAttrIf(blob,length){var bitIf=blob[blob.l+1]&255?1:0;blob.l+=2;return[bitIf,blob.read_shift(2)]}function parse_PtgAttrSemi(blob,length){var bitSemi=blob[blob.l+1]&255?1:0;blob.l+=4;return[bitSemi]}function parse_PtgAttrSpaceType(blob,length){var type=blob.read_shift(1),cch=blob.read_shift(1);return[type,cch]}function parse_PtgAttrSpace(blob,length){blob.read_shift(2);return parse_PtgAttrSpaceType(blob,2)}function parse_PtgAttrSpaceSemi(blob,length){blob.read_shift(2);return parse_PtgAttrSpaceType(blob,2)}function parse_PtgRef(blob,length){var ptg=blob[blob.l]&31;var type=(blob[blob.l]&96)>>5;blob.l+=1;var loc=parse_RgceLoc(blob,4);return[type,loc]}function parse_PtgRefN(blob,length){var ptg=blob[blob.l]&31;var type=(blob[blob.l]&96)>>5;blob.l+=1;var loc=parse_RgceLocRel(blob,4);return[type,loc]}function parse_PtgRef3d(blob,length){var ptg=blob[blob.l]&31;var type=(blob[blob.l]&96)>>5;blob.l+=1;var ixti=blob.read_shift(2);var loc=parse_RgceLoc(blob,4);return[type,ixti,loc]}function parse_PtgFunc(blob,length){var ptg=blob[blob.l]&31;var type=(blob[blob.l]&96)>>5;blob.l+=1;var iftab=blob.read_shift(2);return[FtabArgc[iftab],Ftab[iftab]]}function parse_PtgFuncVar(blob,length){blob.l++;var cparams=blob.read_shift(1),tab=parsetab(blob);return[cparams,(tab[0]===0?Ftab:Cetab)[tab[1]]]}function parsetab(blob,length){return[blob[blob.l+1]>>7,blob.read_shift(2)&32767]}var parse_PtgAttrSum=parseread(4);var parse_PtgConcat=parseread1;function parse_PtgExp(blob,length){blob.l++;var row=blob.read_shift(2);var col=blob.read_shift(2);return[row,col]}function parse_PtgErr(blob,length){blob.l++;return BErr[blob.read_shift(1)]}function parse_PtgInt(blob,length){blob.l++;return blob.read_shift(2)}function parse_PtgBool(blob,length){blob.l++;return blob.read_shift(1)!==0}function parse_PtgNum(blob,length){blob.l++;return parse_Xnum(blob,8)}function parse_PtgStr(blob,length){blob.l++;return parse_ShortXLUnicodeString(blob)}function parse_SerAr(blob){var val=[];switch(val[0]=blob.read_shift(1)){case 4:val[1]=parsebool(blob,1)?\"TRUE\":\"FALSE\";blob.l+=7;break;case 16:val[1]=BErr[blob[blob.l]];blob.l+=8;break;case 0:blob.l+=8;break;case 1:val[1]=parse_Xnum(blob,8);break;case 2:val[1]=parse_XLUnicodeString(blob);break}return val}function parse_PtgExtraMem(blob,cce){var count=blob.read_shift(2);var out=[];for(var i=0;i!=count;++i)out.push(parse_Ref8U(blob,8));return out}function parse_PtgExtraArray(blob){var cols=1+blob.read_shift(1);var rows=1+blob.read_shift(2);for(var i=0,o=[];i!=rows&&(o[i]=[]);++i)for(var j=0;j!=cols;++j)o[i][j]=parse_SerAr(blob);return o}function parse_PtgName(blob,length){var type=blob.read_shift(1)>>>5&3;var nameindex=blob.read_shift(4);return[type,0,nameindex]}function parse_PtgNameX(blob,length){var type=blob.read_shift(1)>>>5&3;var ixti=blob.read_shift(2);var nameindex=blob.read_shift(4);return[type,ixti,nameindex]}function parse_PtgMemArea(blob,length){var type=blob.read_shift(1)>>>5&3;blob.l+=4;var cce=blob.read_shift(2);return[type,cce]}function parse_PtgMemFunc(blob,length){var type=blob.read_shift(1)>>>5&3;var cce=blob.read_shift(2);return[type,cce]}function parse_PtgRefErr(blob,length){var type=blob.read_shift(1)>>>5&3;blob.l+=4;return[type]}var parse_PtgAdd=parseread1;var parse_PtgDiv=parseread1;var parse_PtgEq=parseread1;var parse_PtgGe=parseread1;var parse_PtgGt=parseread1;var parse_PtgIsect=parseread1;var parse_PtgLe=parseread1;var parse_PtgLt=parseread1;var parse_PtgMissArg=parseread1;var parse_PtgMul=parseread1;var parse_PtgNe=parseread1;var parse_PtgParen=parseread1;var parse_PtgPercent=parseread1;var parse_PtgPower=parseread1;var parse_PtgRange=parseread1;var parse_PtgSub=parseread1;var parse_PtgUminus=parseread1;var parse_PtgUnion=parseread1;var parse_PtgUplus=parseread1;var parse_PtgMemErr=parsenoop;var parse_PtgMemNoMem=parsenoop;var parse_PtgRefErr3d=parsenoop;var parse_PtgTbl=parsenoop;var PtgTypes={1:{n:\"PtgExp\",f:parse_PtgExp},2:{n:\"PtgTbl\",f:parse_PtgTbl},3:{n:\"PtgAdd\",f:parse_PtgAdd},4:{n:\"PtgSub\",f:parse_PtgSub},5:{n:\"PtgMul\",f:parse_PtgMul},6:{n:\"PtgDiv\",f:parse_PtgDiv},7:{n:\"PtgPower\",f:parse_PtgPower},8:{n:\"PtgConcat\",f:parse_PtgConcat},9:{n:\"PtgLt\",f:parse_PtgLt},10:{n:\"PtgLe\",f:parse_PtgLe},11:{n:\"PtgEq\",f:parse_PtgEq},12:{n:\"PtgGe\",f:parse_PtgGe},13:{n:\"PtgGt\",f:parse_PtgGt},14:{n:\"PtgNe\",f:parse_PtgNe},15:{n:\"PtgIsect\",f:parse_PtgIsect},16:{n:\"PtgUnion\",f:parse_PtgUnion},17:{n:\"PtgRange\",f:parse_PtgRange},18:{n:\"PtgUplus\",f:parse_PtgUplus},19:{n:\"PtgUminus\",f:parse_PtgUminus},20:{n:\"PtgPercent\",f:parse_PtgPercent},21:{n:\"PtgParen\",f:parse_PtgParen},22:{n:\"PtgMissArg\",f:parse_PtgMissArg},23:{n:\"PtgStr\",f:parse_PtgStr},28:{n:\"PtgErr\",f:parse_PtgErr},29:{n:\"PtgBool\",f:parse_PtgBool},30:{n:\"PtgInt\",f:parse_PtgInt},31:{n:\"PtgNum\",f:parse_PtgNum},32:{n:\"PtgArray\",f:parse_PtgArray},33:{n:\"PtgFunc\",f:parse_PtgFunc},34:{n:\"PtgFuncVar\",f:parse_PtgFuncVar},35:{n:\"PtgName\",f:parse_PtgName},36:{n:\"PtgRef\",f:parse_PtgRef},37:{n:\"PtgArea\",f:parse_PtgArea},38:{n:\"PtgMemArea\",f:parse_PtgMemArea},39:{n:\"PtgMemErr\",f:parse_PtgMemErr},40:{n:\"PtgMemNoMem\",f:parse_PtgMemNoMem},41:{n:\"PtgMemFunc\",f:parse_PtgMemFunc},42:{n:\"PtgRefErr\",f:parse_PtgRefErr},43:{n:\"PtgAreaErr\",f:parse_PtgAreaErr},44:{n:\"PtgRefN\",f:parse_PtgRefN},45:{n:\"PtgAreaN\",f:parse_PtgAreaN},57:{n:\"PtgNameX\",f:parse_PtgNameX},58:{n:\"PtgRef3d\",f:parse_PtgRef3d},59:{n:\"PtgArea3d\",f:parse_PtgArea3d},60:{n:\"PtgRefErr3d\",f:parse_PtgRefErr3d},61:{n:\"PtgAreaErr3d\",f:parse_PtgAreaErr3d},255:{}};var PtgDupes={64:32,96:32,65:33,97:33,66:34,98:34,67:35,99:35,68:36,100:36,69:37,101:37,70:38,102:38,71:39,103:39,72:40,104:40,73:41,105:41,74:42,106:42,75:43,107:43,76:44,108:44,77:45,109:45,89:57,121:57,90:58,122:58,91:59,123:59,92:60,124:60,93:61,125:61};(function(){for(var y in PtgDupes)PtgTypes[y]=PtgTypes[PtgDupes[y]]})();var Ptg18={};var Ptg19={1:{n:\"PtgAttrSemi\",f:parse_PtgAttrSemi},2:{n:\"PtgAttrIf\",f:parse_PtgAttrIf},4:{n:\"PtgAttrChoose\",f:parse_PtgAttrChoose},8:{n:\"PtgAttrGoto\",f:parse_PtgAttrGoto},16:{n:\"PtgAttrSum\",f:parse_PtgAttrSum},32:{n:\"PtgAttrBaxcel\",f:parse_PtgAttrBaxcel},64:{n:\"PtgAttrSpace\",f:parse_PtgAttrSpace},65:{n:\"PtgAttrSpaceSemi\",f:parse_PtgAttrSpaceSemi},255:{}};function parse_Formula(blob,length,opts){var cell=parse_XLSCell(blob,6);var val=parse_FormulaValue(blob,8);var flags=blob.read_shift(1);blob.read_shift(1);var chn=blob.read_shift(4);var cbf=\"\";if(opts.biff===5)blob.l+=length-20;else cbf=parse_XLSCellParsedFormula(blob,length-20,opts);return{cell:cell,val:val[0],formula:cbf,shared:flags>>3&1,tt:val[1]}}function parse_FormulaValue(blob){var b;if(__readUInt16LE(blob,blob.l+6)!==65535)return[parse_Xnum(blob),\"n\"];switch(blob[blob.l]){case 0:blob.l+=8;return[\"String\",\"s\"];case 1:b=blob[blob.l+2]===1;blob.l+=8;return[b,\"b\"];case 2:b=blob[blob.l+2];blob.l+=8;return[b,\"e\"];case 3:blob.l+=8;return[\"\",\"s\"]}}function parse_RgbExtra(blob,length,rgce,opts){if(opts.biff<8)return parsenoop(blob,length);var target=blob.l+length;var o=[];for(var i=0;i!==rgce.length;++i){switch(rgce[i][0]){case\"PtgArray\":rgce[i][1]=parse_PtgExtraArray(blob);o.push(rgce[i][1]);break;case\"PtgMemArea\":rgce[i][2]=parse_PtgExtraMem(blob,rgce[i][1]);o.push(rgce[i][2]);break;default:break}}length=target-blob.l;if(length!==0)o.push(parsenoop(blob,length));return o}function parse_NameParsedFormula(blob,length,opts,cce){var target=blob.l+length;var rgce=parse_Rgce(blob,cce);var rgcb;if(target!==blob.l)rgcb=parse_RgbExtra(blob,target-blob.l,rgce,opts);return[rgce,rgcb]}function parse_XLSCellParsedFormula(blob,length,opts){var target=blob.l+length;var rgcb,cce=blob.read_shift(2);if(cce==65535)return[[],parsenoop(blob,length-2)];var rgce=parse_Rgce(blob,cce);if(length!==cce+2)rgcb=parse_RgbExtra(blob,length-cce-2,rgce,opts);return[rgce,rgcb]}function parse_SharedParsedFormula(blob,length,opts){var target=blob.l+length;var rgcb,cce=blob.read_shift(2);var rgce=parse_Rgce(blob,cce);if(cce==65535)return[[],parsenoop(blob,length-2)];if(length!==cce+2)rgcb=parse_RgbExtra(blob,target-cce-2,rgce,opts);return[rgce,rgcb]}function parse_ArrayParsedFormula(blob,length,opts,ref){var target=blob.l+length;var rgcb,cce=blob.read_shift(2);if(cce==65535)return[[],parsenoop(blob,length-2)];var rgce=parse_Rgce(blob,cce);if(length!==cce+2)rgcb=parse_RgbExtra(blob,target-cce-2,rgce,opts);return[rgce,rgcb]}function parse_Rgce(blob,length){var target=blob.l+length;var R,id,ptgs=[];while(target!=blob.l){length=target-blob.l;id=blob[blob.l];R=PtgTypes[id];if(id===24||id===25){id=blob[blob.l+1];R=(id===24?Ptg18:Ptg19)[id]}if(!R||!R.f){ptgs.push(parsenoop(blob,length))}else{ptgs.push([R.n,R.f(blob,length)])}}return ptgs}function mapper(x){return x.map(function f2(y){return y[1]}).join(\",\")}function stringify_formula(formula,range,cell,supbooks,opts){if(opts!==undefined&&opts.biff===5)return\"BIFF5??\";var _range=range!==undefined?range:{s:{c:0,r:0}};var stack=[],e1,e2,type,c,ixti,nameidx,r;if(!formula[0]||!formula[0][0])return\"\";for(var ff=0,fflen=formula[0].length;ff<fflen;++ff){var f=formula[0][ff];switch(f[0]){case\"PtgUminus\":stack.push(\"-\"+stack.pop());break;case\"PtgUplus\":stack.push(\"+\"+stack.pop());break;case\"PtgPercent\":stack.push(stack.pop()+\"%\");break;case\"PtgAdd\":e1=stack.pop();e2=stack.pop();stack.push(e2+\"+\"+e1);break;case\"PtgSub\":e1=stack.pop();e2=stack.pop();stack.push(e2+\"-\"+e1);break;case\"PtgMul\":e1=stack.pop();e2=stack.pop();stack.push(e2+\"*\"+e1);break;case\"PtgDiv\":e1=stack.pop();e2=stack.pop();stack.push(e2+\"/\"+e1);break;case\"PtgPower\":e1=stack.pop();e2=stack.pop();stack.push(e2+\"^\"+e1);break;case\"PtgConcat\":e1=stack.pop();e2=stack.pop();stack.push(e2+\"&\"+e1);break;case\"PtgLt\":e1=stack.pop();e2=stack.pop();stack.push(e2+\"<\"+e1);break;case\"PtgLe\":e1=stack.pop();e2=stack.pop();stack.push(e2+\"<=\"+e1);break;case\"PtgEq\":e1=stack.pop();e2=stack.pop();stack.push(e2+\"=\"+e1);break;case\"PtgGe\":e1=stack.pop();e2=stack.pop();stack.push(e2+\">=\"+e1);break;case\"PtgGt\":e1=stack.pop();e2=stack.pop();stack.push(e2+\">\"+e1);break;case\"PtgNe\":e1=stack.pop();e2=stack.pop();stack.push(e2+\"<>\"+e1);break;case\"PtgIsect\":e1=stack.pop();e2=stack.pop();stack.push(e2+\" \"+e1);break;case\"PtgUnion\":e1=stack.pop();e2=stack.pop();stack.push(e2+\",\"+e1);break;case\"PtgRange\":break;case\"PtgAttrChoose\":break;case\"PtgAttrGoto\":break;case\"PtgAttrIf\":break;case\"PtgRef\":type=f[1][0];c=shift_cell_xls(decode_cell(encode_cell(f[1][1])),_range);stack.push(encode_cell(c));break;case\"PtgRefN\":type=f[1][0];c=shift_cell_xls(decode_cell(encode_cell(f[1][1])),cell);stack.push(encode_cell(c));break;case\"PtgRef3d\":type=f[1][0];ixti=f[1][1];c=shift_cell_xls(f[1][2],_range);stack.push(supbooks[1][ixti+1]+\"!\"+encode_cell(c));break;case\"PtgFunc\":case\"PtgFuncVar\":var argc=f[1][0],func=f[1][1];if(!argc)argc=0;var args=stack.slice(-argc);stack.length-=argc;if(func===\"User\")func=args.shift();stack.push(func+\"(\"+args.join(\",\")+\")\");break;case\"PtgBool\":stack.push(f[1]?\"TRUE\":\"FALSE\");break;case\"PtgInt\":stack.push(f[1]);break;case\"PtgNum\":stack.push(String(f[1]));break;case\"PtgStr\":stack.push('\"'+f[1]+'\"');break;case\"PtgErr\":stack.push(f[1]);break;case\"PtgArea\":type=f[1][0];r=shift_range_xls(f[1][1],_range);stack.push(encode_range(r));break;case\"PtgArea3d\":type=f[1][0];ixti=f[1][1];r=f[1][2];stack.push(supbooks[1][ixti+1]+\"!\"+encode_range(r));break;case\"PtgAttrSum\":stack.push(\"SUM(\"+stack.pop()+\")\");break;case\"PtgAttrSemi\":break;case\"PtgName\":nameidx=f[1][2];var lbl=supbooks[0][nameidx];var name=lbl.Name;if(name in XLSXFutureFunctions)name=XLSXFutureFunctions[name];stack.push(name);break;case\"PtgNameX\":var bookidx=f[1][1];nameidx=f[1][2];var externbook;if(supbooks[bookidx+1])externbook=supbooks[bookidx+1][nameidx];else if(supbooks[bookidx-1])externbook=supbooks[bookidx-1][nameidx];if(!externbook)externbook={body:\"??NAMEX??\"};stack.push(externbook.body);break;case\"PtgParen\":stack.push(\"(\"+stack.pop()+\")\");break;case\"PtgRefErr\":stack.push(\"#REF!\");break;case\"PtgExp\":c={c:f[1][1],r:f[1][0]};var q={c:cell.c,r:cell.r};if(supbooks.sharedf[encode_cell(c)]){var parsedf=supbooks.sharedf[encode_cell(c)];stack.push(stringify_formula(parsedf,_range,q,supbooks,opts))}else{var fnd=false;for(e1=0;e1!=supbooks.arrayf.length;++e1){e2=supbooks.arrayf[e1];if(c.c<e2[0].s.c||c.c>e2[0].e.c)continue;if(c.r<e2[0].s.r||c.r>e2[0].e.r)continue;stack.push(stringify_formula(e2[1],_range,q,supbooks,opts))}if(!fnd)stack.push(f[1])}break;case\"PtgArray\":stack.push(\"{\"+f[1].map(mapper).join(\";\")+\"}\");break;case\"PtgMemArea\":break;case\"PtgAttrSpace\":break;case\"PtgTbl\":break;case\"PtgMemErr\":break;case\"PtgMissArg\":stack.push(\"\");break;case\"PtgAreaErr\":break;case\"PtgAreaN\":stack.push(\"\");break;case\"PtgRefErr3d\":break;case\"PtgMemFunc\":break;default:throw\"Unrecognized Formula Token: \"+f}}return stack[0]}function parse_XLSBCellParsedFormula(data,length){var cce=data.read_shift(4);return parsenoop(data,length-4)}var PtgDataType={1:\"REFERENCE\",2:\"VALUE\",3:\"ARRAY\"};var Cetab={0:\"BEEP\",1:\"OPEN\",2:\"OPEN.LINKS\",3:\"CLOSE.ALL\",4:\"SAVE\",5:\"SAVE.AS\",6:\"FILE.DELETE\",7:\"PAGE.SETUP\",8:\"PRINT\",9:\"PRINTER.SETUP\",10:\"QUIT\",11:\"NEW.WINDOW\",12:\"ARRANGE.ALL\",13:\"WINDOW.SIZE\",14:\"WINDOW.MOVE\",15:\"FULL\",16:\"CLOSE\",17:\"RUN\",22:\"SET.PRINT.AREA\",23:\"SET.PRINT.TITLES\",24:\"SET.PAGE.BREAK\",25:\"REMOVE.PAGE.BREAK\",26:\"FONT\",27:\"DISPLAY\",28:\"PROTECT.DOCUMENT\",29:\"PRECISION\",30:\"A1.R1C1\",31:\"CALCULATE.NOW\",32:\"CALCULATION\",34:\"DATA.FIND\",35:\"EXTRACT\",36:\"DATA.DELETE\",37:\"SET.DATABASE\",38:\"SET.CRITERIA\",39:\"SORT\",40:\"DATA.SERIES\",41:\"TABLE\",42:\"FORMAT.NUMBER\",43:\"ALIGNMENT\",44:\"STYLE\",45:\"BORDER\",46:\"CELL.PROTECTION\",47:\"COLUMN.WIDTH\",48:\"UNDO\",49:\"CUT\",50:\"COPY\",51:\"PASTE\",52:\"CLEAR\",53:\"PASTE.SPECIAL\",54:\"EDIT.DELETE\",55:\"INSERT\",56:\"FILL.RIGHT\",57:\"FILL.DOWN\",61:\"DEFINE.NAME\",62:\"CREATE.NAMES\",63:\"FORMULA.GOTO\",64:\"FORMULA.FIND\",65:\"SELECT.LAST.CELL\",66:\"SHOW.ACTIVE.CELL\",67:\"GALLERY.AREA\",68:\"GALLERY.BAR\",69:\"GALLERY.COLUMN\",70:\"GALLERY.LINE\",71:\"GALLERY.PIE\",72:\"GALLERY.SCATTER\",73:\"COMBINATION\",74:\"PREFERRED\",75:\"ADD.OVERLAY\",76:\"GRIDLINES\",77:\"SET.PREFERRED\",78:\"AXES\",79:\"LEGEND\",80:\"ATTACH.TEXT\",81:\"ADD.ARROW\",82:\"SELECT.CHART\",83:\"SELECT.PLOT.AREA\",84:\"PATTERNS\",85:\"MAIN.CHART\",86:\"OVERLAY\",87:\"SCALE\",88:\"FORMAT.LEGEND\",89:\"FORMAT.TEXT\",90:\"EDIT.REPEAT\",91:\"PARSE\",92:\"JUSTIFY\",93:\"HIDE\",94:\"UNHIDE\",95:\"WORKSPACE\",96:\"FORMULA\",97:\"FORMULA.FILL\",98:\"FORMULA.ARRAY\",99:\"DATA.FIND.NEXT\",100:\"DATA.FIND.PREV\",101:\"FORMULA.FIND.NEXT\",102:\"FORMULA.FIND.PREV\",103:\"ACTIVATE\",104:\"ACTIVATE.NEXT\",105:\"ACTIVATE.PREV\",106:\"UNLOCKED.NEXT\",107:\"UNLOCKED.PREV\",108:\"COPY.PICTURE\",109:\"SELECT\",110:\"DELETE.NAME\",111:\"DELETE.FORMAT\",112:\"VLINE\",113:\"HLINE\",114:\"VPAGE\",115:\"HPAGE\",116:\"VSCROLL\",117:\"HSCROLL\",118:\"ALERT\",119:\"NEW\",120:\"CANCEL.COPY\",121:\"SHOW.CLIPBOARD\",122:\"MESSAGE\",124:\"PASTE.LINK\",125:\"APP.ACTIVATE\",126:\"DELETE.ARROW\",127:\"ROW.HEIGHT\",128:\"FORMAT.MOVE\",129:\"FORMAT.SIZE\",130:\"FORMULA.REPLACE\",131:\"SEND.KEYS\",132:\"SELECT.SPECIAL\",133:\"APPLY.NAMES\",134:\"REPLACE.FONT\",135:\"FREEZE.PANES\",136:\"SHOW.INFO\",137:\"SPLIT\",138:\"ON.WINDOW\",139:\"ON.DATA\",140:\"DISABLE.INPUT\",142:\"OUTLINE\",143:\"LIST.NAMES\",144:\"FILE.CLOSE\",145:\"SAVE.WORKBOOK\",146:\"DATA.FORM\",147:\"COPY.CHART\",148:\"ON.TIME\",149:\"WAIT\",150:\"FORMAT.FONT\",151:\"FILL.UP\",152:\"FILL.LEFT\",153:\"DELETE.OVERLAY\",155:\"SHORT.MENUS\",159:\"SET.UPDATE.STATUS\",161:\"COLOR.PALETTE\",162:\"DELETE.STYLE\",163:\"WINDOW.RESTORE\",164:\"WINDOW.MAXIMIZE\",166:\"CHANGE.LINK\",167:\"CALCULATE.DOCUMENT\",168:\"ON.KEY\",169:\"APP.RESTORE\",170:\"APP.MOVE\",171:\"APP.SIZE\",172:\"APP.MINIMIZE\",173:\"APP.MAXIMIZE\",174:\"BRING.TO.FRONT\",175:\"SEND.TO.BACK\",185:\"MAIN.CHART.TYPE\",186:\"OVERLAY.CHART.TYPE\",187:\"SELECT.END\",188:\"OPEN.MAIL\",189:\"SEND.MAIL\",190:\"STANDARD.FONT\",191:\"CONSOLIDATE\",192:\"SORT.SPECIAL\",193:\"GALLERY.3D.AREA\",194:\"GALLERY.3D.COLUMN\",195:\"GALLERY.3D.LINE\",196:\"GALLERY.3D.PIE\",197:\"VIEW.3D\",198:\"GOAL.SEEK\",199:\"WORKGROUP\",200:\"FILL.GROUP\",201:\"UPDATE.LINK\",202:\"PROMOTE\",203:\"DEMOTE\",204:\"SHOW.DETAIL\",206:\"UNGROUP\",207:\"OBJECT.PROPERTIES\",208:\"SAVE.NEW.OBJECT\",209:\"SHARE\",210:\"SHARE.NAME\",211:\"DUPLICATE\",212:\"APPLY.STYLE\",213:\"ASSIGN.TO.OBJECT\",214:\"OBJECT.PROTECTION\",215:\"HIDE.OBJECT\",216:\"SET.EXTRACT\",217:\"CREATE.PUBLISHER\",218:\"SUBSCRIBE.TO\",219:\"ATTRIBUTES\",220:\"SHOW.TOOLBAR\",222:\"PRINT.PREVIEW\",223:\"EDIT.COLOR\",224:\"SHOW.LEVELS\",225:\"FORMAT.MAIN\",226:\"FORMAT.OVERLAY\",227:\"ON.RECALC\",228:\"EDIT.SERIES\",229:\"DEFINE.STYLE\",240:\"LINE.PRINT\",243:\"ENTER.DATA\",249:\"GALLERY.RADAR\",250:\"MERGE.STYLES\",251:\"EDITION.OPTIONS\",252:\"PASTE.PICTURE\",253:\"PASTE.PICTURE.LINK\",254:\"SPELLING\",256:\"ZOOM\",259:\"INSERT.OBJECT\",260:\"WINDOW.MINIMIZE\",265:\"SOUND.NOTE\",266:\"SOUND.PLAY\",267:\"FORMAT.SHAPE\",268:\"EXTEND.POLYGON\",269:\"FORMAT.AUTO\",272:\"GALLERY.3D.BAR\",273:\"GALLERY.3D.SURFACE\",274:\"FILL.AUTO\",276:\"CUSTOMIZE.TOOLBAR\",277:\"ADD.TOOL\",278:\"EDIT.OBJECT\",279:\"ON.DOUBLECLICK\",280:\"ON.ENTRY\",281:\"WORKBOOK.ADD\",282:\"WORKBOOK.MOVE\",283:\"WORKBOOK.COPY\",284:\"WORKBOOK.OPTIONS\",285:\"SAVE.WORKSPACE\",288:\"CHART.WIZARD\",289:\"DELETE.TOOL\",290:\"MOVE.TOOL\",291:\"WORKBOOK.SELECT\",292:\"WORKBOOK.ACTIVATE\",293:\"ASSIGN.TO.TOOL\",295:\"COPY.TOOL\",296:\"RESET.TOOL\",297:\"CONSTRAIN.NUMERIC\",298:\"PASTE.TOOL\",302:\"WORKBOOK.NEW\",305:\"SCENARIO.CELLS\",306:\"SCENARIO.DELETE\",307:\"SCENARIO.ADD\",308:\"SCENARIO.EDIT\",309:\"SCENARIO.SHOW\",310:\"SCENARIO.SHOW.NEXT\",311:\"SCENARIO.SUMMARY\",312:\"PIVOT.TABLE.WIZARD\",313:\"PIVOT.FIELD.PROPERTIES\",314:\"PIVOT.FIELD\",315:\"PIVOT.ITEM\",316:\"PIVOT.ADD.FIELDS\",318:\"OPTIONS.CALCULATION\",319:\"OPTIONS.EDIT\",320:\"OPTIONS.VIEW\",321:\"ADDIN.MANAGER\",322:\"MENU.EDITOR\",323:\"ATTACH.TOOLBARS\",324:\"VBAActivate\",325:\"OPTIONS.CHART\",328:\"VBA.INSERT.FILE\",330:\"VBA.PROCEDURE.DEFINITION\",336:\"ROUTING.SLIP\",338:\"ROUTE.DOCUMENT\",339:\"MAIL.LOGON\",342:\"INSERT.PICTURE\",343:\"EDIT.TOOL\",344:\"GALLERY.DOUGHNUT\",350:\"CHART.TREND\",352:\"PIVOT.ITEM.PROPERTIES\",354:\"WORKBOOK.INSERT\",355:\"OPTIONS.TRANSITION\",356:\"OPTIONS.GENERAL\",370:\"FILTER.ADVANCED\",373:\"MAIL.ADD.MAILER\",374:\"MAIL.DELETE.MAILER\",375:\"MAIL.REPLY\",376:\"MAIL.REPLY.ALL\",377:\"MAIL.FORWARD\",378:\"MAIL.NEXT.LETTER\",379:\"DATA.LABEL\",380:\"INSERT.TITLE\",381:\"FONT.PROPERTIES\",382:\"MACRO.OPTIONS\",383:\"WORKBOOK.HIDE\",384:\"WORKBOOK.UNHIDE\",385:\"WORKBOOK.DELETE\",386:\"WORKBOOK.NAME\",388:\"GALLERY.CUSTOM\",390:\"ADD.CHART.AUTOFORMAT\",391:\"DELETE.CHART.AUTOFORMAT\",392:\"CHART.ADD.DATA\",393:\"AUTO.OUTLINE\",394:\"TAB.ORDER\",395:\"SHOW.DIALOG\",396:\"SELECT.ALL\",397:\"UNGROUP.SHEETS\",398:\"SUBTOTAL.CREATE\",399:\"SUBTOTAL.REMOVE\",400:\"RENAME.OBJECT\",412:\"WORKBOOK.SCROLL\",413:\"WORKBOOK.NEXT\",414:\"WORKBOOK.PREV\",415:\"WORKBOOK.TAB.SPLIT\",416:\"FULL.SCREEN\",417:\"WORKBOOK.PROTECT\",420:\"SCROLLBAR.PROPERTIES\",421:\"PIVOT.SHOW.PAGES\",422:\"TEXT.TO.COLUMNS\",423:\"FORMAT.CHARTTYPE\",424:\"LINK.FORMAT\",425:\"TRACER.DISPLAY\",430:\"TRACER.NAVIGATE\",431:\"TRACER.CLEAR\",432:\"TRACER.ERROR\",433:\"PIVOT.FIELD.GROUP\",434:\"PIVOT.FIELD.UNGROUP\",435:\"CHECKBOX.PROPERTIES\",436:\"LABEL.PROPERTIES\",437:\"LISTBOX.PROPERTIES\",438:\"EDITBOX.PROPERTIES\",439:\"PIVOT.REFRESH\",440:\"LINK.COMBO\",441:\"OPEN.TEXT\",442:\"HIDE.DIALOG\",443:\"SET.DIALOG.FOCUS\",444:\"ENABLE.OBJECT\",445:\"PUSHBUTTON.PROPERTIES\",446:\"SET.DIALOG.DEFAULT\",447:\"FILTER\",448:\"FILTER.SHOW.ALL\",449:\"CLEAR.OUTLINE\",450:\"FUNCTION.WIZARD\",451:\"ADD.LIST.ITEM\",452:\"SET.LIST.ITEM\",453:\"REMOVE.LIST.ITEM\",454:\"SELECT.LIST.ITEM\",455:\"SET.CONTROL.VALUE\",456:\"SAVE.COPY.AS\",458:\"OPTIONS.LISTS.ADD\",459:\"OPTIONS.LISTS.DELETE\",460:\"SERIES.AXES\",461:\"SERIES.X\",462:\"SERIES.Y\",463:\"ERRORBAR.X\",464:\"ERRORBAR.Y\",465:\"FORMAT.CHART\",466:\"SERIES.ORDER\",467:\"MAIL.LOGOFF\",468:\"CLEAR.ROUTING.SLIP\",469:\"APP.ACTIVATE.MICROSOFT\",470:\"MAIL.EDIT.MAILER\",471:\"ON.SHEET\",472:\"STANDARD.WIDTH\",473:\"SCENARIO.MERGE\",474:\"SUMMARY.INFO\",475:\"FIND.FILE\",476:\"ACTIVE.CELL.FONT\",477:\"ENABLE.TIPWIZARD\",478:\"VBA.MAKE.ADDIN\",480:\"INSERTDATATABLE\",481:\"WORKGROUP.OPTIONS\",482:\"MAIL.SEND.MAILER\",485:\"AUTOCORRECT\",489:\"POST.DOCUMENT\",491:\"PICKLIST\",493:\"VIEW.SHOW\",494:\"VIEW.DEFINE\",495:\"VIEW.DELETE\",509:\"SHEET.BACKGROUND\",510:\"INSERT.MAP.OBJECT\",511:\"OPTIONS.MENONO\",517:\"MSOCHECKS\",518:\"NORMAL\",519:\"LAYOUT\",520:\"RM.PRINT.AREA\",521:\"CLEAR.PRINT.AREA\",522:\"ADD.PRINT.AREA\",523:\"MOVE.BRK\",545:\"HIDECURR.NOTE\",546:\"HIDEALL.NOTES\",547:\"DELETE.NOTE\",548:\"TRAVERSE.NOTES\",549:\"ACTIVATE.NOTES\",620:\"PROTECT.REVISIONS\",621:\"UNPROTECT.REVISIONS\",647:\"OPTIONS.ME\",653:\"WEB.PUBLISH\",667:\"NEWWEBQUERY\",673:\"PIVOT.TABLE.CHART\",753:\"OPTIONS.SAVE\",755:\"OPTIONS.SPELL\",808:\"HIDEALL.INKANNOTS\"};var Ftab={0:\"COUNT\",1:\"IF\",2:\"ISNA\",3:\"ISERROR\",4:\"SUM\",5:\"AVERAGE\",6:\"MIN\",7:\"MAX\",8:\"ROW\",9:\"COLUMN\",10:\"NA\",11:\"NPV\",12:\"STDEV\",13:\"DOLLAR\",14:\"FIXED\",15:\"SIN\",16:\"COS\",17:\"TAN\",18:\"ATAN\",19:\"PI\",20:\"SQRT\",21:\"EXP\",22:\"LN\",23:\"LOG10\",24:\"ABS\",25:\"INT\",26:\"SIGN\",27:\"ROUND\",28:\"LOOKUP\",29:\"INDEX\",30:\"REPT\",31:\"MID\",32:\"LEN\",33:\"VALUE\",34:\"TRUE\",35:\"FALSE\",36:\"AND\",37:\"OR\",38:\"NOT\",39:\"MOD\",40:\"DCOUNT\",41:\"DSUM\",42:\"DAVERAGE\",43:\"DMIN\",44:\"DMAX\",45:\"DSTDEV\",46:\"VAR\",47:\"DVAR\",48:\"TEXT\",49:\"LINEST\",50:\"TREND\",51:\"LOGEST\",52:\"GROWTH\",53:\"GOTO\",54:\"HALT\",55:\"RETURN\",56:\"PV\",57:\"FV\",58:\"NPER\",59:\"PMT\",60:\"RATE\",61:\"MIRR\",62:\"IRR\",63:\"RAND\",64:\"MATCH\",65:\"DATE\",66:\"TIME\",67:\"DAY\",68:\"MONTH\",69:\"YEAR\",70:\"WEEKDAY\",71:\"HOUR\",72:\"MINUTE\",73:\"SECOND\",74:\"NOW\",75:\"AREAS\",76:\"ROWS\",77:\"COLUMNS\",78:\"OFFSET\",79:\"ABSREF\",80:\"RELREF\",81:\"ARGUMENT\",82:\"SEARCH\",83:\"TRANSPOSE\",84:\"ERROR\",85:\"STEP\",86:\"TYPE\",87:\"ECHO\",88:\"SET.NAME\",89:\"CALLER\",90:\"DEREF\",91:\"WINDOWS\",92:\"SERIES\",93:\"DOCUMENTS\",94:\"ACTIVE.CELL\",95:\"SELECTION\",96:\"RESULT\",97:\"ATAN2\",98:\"ASIN\",99:\"ACOS\",100:\"CHOOSE\",101:\"HLOOKUP\",102:\"VLOOKUP\",103:\"LINKS\",104:\"INPUT\",105:\"ISREF\",106:\"GET.FORMULA\",107:\"GET.NAME\",108:\"SET.VALUE\",109:\"LOG\",110:\"EXEC\",111:\"CHAR\",112:\"LOWER\",113:\"UPPER\",114:\"PROPER\",115:\"LEFT\",116:\"RIGHT\",117:\"EXACT\",118:\"TRIM\",119:\"REPLACE\",120:\"SUBSTITUTE\",121:\"CODE\",122:\"NAMES\",123:\"DIRECTORY\",124:\"FIND\",125:\"CELL\",126:\"ISERR\",127:\"ISTEXT\",128:\"ISNUMBER\",129:\"ISBLANK\",130:\"T\",131:\"N\",132:\"FOPEN\",133:\"FCLOSE\",134:\"FSIZE\",135:\"FREADLN\",136:\"FREAD\",137:\"FWRITELN\",138:\"FWRITE\",139:\"FPOS\",140:\"DATEVALUE\",141:\"TIMEVALUE\",142:\"SLN\",143:\"SYD\",144:\"DDB\",145:\"GET.DEF\",146:\"REFTEXT\",147:\"TEXTREF\",148:\"INDIRECT\",149:\"REGISTER\",150:\"CALL\",151:\"ADD.BAR\",152:\"ADD.MENU\",153:\"ADD.COMMAND\",154:\"ENABLE.COMMAND\",155:\"CHECK.COMMAND\",156:\"RENAME.COMMAND\",157:\"SHOW.BAR\",158:\"DELETE.MENU\",159:\"DELETE.COMMAND\",160:\"GET.CHART.ITEM\",161:\"DIALOG.BOX\",162:\"CLEAN\",163:\"MDETERM\",164:\"MINVERSE\",165:\"MMULT\",166:\"FILES\",167:\"IPMT\",168:\"PPMT\",169:\"COUNTA\",170:\"CANCEL.KEY\",171:\"FOR\",172:\"WHILE\",173:\"BREAK\",174:\"NEXT\",175:\"INITIATE\",176:\"REQUEST\",177:\"POKE\",178:\"EXECUTE\",179:\"TERMINATE\",180:\"RESTART\",181:\"HELP\",182:\"GET.BAR\",183:\"PRODUCT\",184:\"FACT\",185:\"GET.CELL\",186:\"GET.WORKSPACE\",187:\"GET.WINDOW\",188:\"GET.DOCUMENT\",189:\"DPRODUCT\",190:\"ISNONTEXT\",191:\"GET.NOTE\",192:\"NOTE\",193:\"STDEVP\",194:\"VARP\",195:\"DSTDEVP\",196:\"DVARP\",197:\"TRUNC\",198:\"ISLOGICAL\",199:\"DCOUNTA\",200:\"DELETE.BAR\",201:\"UNREGISTER\",204:\"USDOLLAR\",205:\"FINDB\",206:\"SEARCHB\",207:\"REPLACEB\",208:\"LEFTB\",209:\"RIGHTB\",210:\"MIDB\",211:\"LENB\",212:\"ROUNDUP\",213:\"ROUNDDOWN\",214:\"ASC\",215:\"DBCS\",216:\"RANK\",219:\"ADDRESS\",220:\"DAYS360\",221:\"TODAY\",222:\"VDB\",223:\"ELSE\",224:\"ELSE.IF\",225:\"END.IF\",226:\"FOR.CELL\",227:\"MEDIAN\",228:\"SUMPRODUCT\",229:\"SINH\",230:\"COSH\",231:\"TANH\",232:\"ASINH\",233:\"ACOSH\",234:\"ATANH\",235:\"DGET\",236:\"CREATE.OBJECT\",237:\"VOLATILE\",238:\"LAST.ERROR\",239:\"CUSTOM.UNDO\",240:\"CUSTOM.REPEAT\",241:\"FORMULA.CONVERT\",242:\"GET.LINK.INFO\",243:\"TEXT.BOX\",244:\"INFO\",245:\"GROUP\",246:\"GET.OBJECT\",247:\"DB\",248:\"PAUSE\",251:\"RESUME\",252:\"FREQUENCY\",253:\"ADD.TOOLBAR\",254:\"DELETE.TOOLBAR\",255:\"User\",256:\"RESET.TOOLBAR\",257:\"EVALUATE\",258:\"GET.TOOLBAR\",259:\"GET.TOOL\",260:\"SPELLING.CHECK\",261:\"ERROR.TYPE\",262:\"APP.TITLE\",263:\"WINDOW.TITLE\",264:\"SAVE.TOOLBAR\",265:\"ENABLE.TOOL\",266:\"PRESS.TOOL\",267:\"REGISTER.ID\",268:\"GET.WORKBOOK\",269:\"AVEDEV\",270:\"BETADIST\",271:\"GAMMALN\",272:\"BETAINV\",273:\"BINOMDIST\",274:\"CHIDIST\",275:\"CHIINV\",276:\"COMBIN\",277:\"CONFIDENCE\",278:\"CRITBINOM\",279:\"EVEN\",280:\"EXPONDIST\",281:\"FDIST\",282:\"FINV\",283:\"FISHER\",284:\"FISHERINV\",285:\"FLOOR\",286:\"GAMMADIST\",287:\"GAMMAINV\",288:\"CEILING\",289:\"HYPGEOMDIST\",290:\"LOGNORMDIST\",291:\"LOGINV\",292:\"NEGBINOMDIST\",293:\"NORMDIST\",294:\"NORMSDIST\",295:\"NORMINV\",296:\"NORMSINV\",297:\"STANDARDIZE\",298:\"ODD\",299:\"PERMUT\",300:\"POISSON\",301:\"TDIST\",302:\"WEIBULL\",303:\"SUMXMY2\",304:\"SUMX2MY2\",305:\"SUMX2PY2\",306:\"CHITEST\",307:\"CORREL\",308:\"COVAR\",309:\"FORECAST\",310:\"FTEST\",311:\"INTERCEPT\",312:\"PEARSON\",313:\"RSQ\",314:\"STEYX\",315:\"SLOPE\",316:\"TTEST\",317:\"PROB\",318:\"DEVSQ\",319:\"GEOMEAN\",320:\"HARMEAN\",321:\"SUMSQ\",322:\"KURT\",323:\"SKEW\",324:\"ZTEST\",325:\"LARGE\",326:\"SMALL\",327:\"QUARTILE\",328:\"PERCENTILE\",329:\"PERCENTRANK\",330:\"MODE\",331:\"TRIMMEAN\",332:\"TINV\",334:\"MOVIE.COMMAND\",335:\"GET.MOVIE\",336:\"CONCATENATE\",337:\"POWER\",338:\"PIVOT.ADD.DATA\",339:\"GET.PIVOT.TABLE\",340:\"GET.PIVOT.FIELD\",341:\"GET.PIVOT.ITEM\",342:\"RADIANS\",343:\"DEGREES\",344:\"SUBTOTAL\",345:\"SUMIF\",346:\"COUNTIF\",347:\"COUNTBLANK\",348:\"SCENARIO.GET\",349:\"OPTIONS.LISTS.GET\",350:\"ISPMT\",351:\"DATEDIF\",352:\"DATESTRING\",353:\"NUMBERSTRING\",354:\"ROMAN\",355:\"OPEN.DIALOG\",356:\"SAVE.DIALOG\",357:\"VIEW.GET\",358:\"GETPIVOTDATA\",359:\"HYPERLINK\",360:\"PHONETIC\",361:\"AVERAGEA\",362:\"MAXA\",363:\"MINA\",364:\"STDEVPA\",365:\"VARPA\",366:\"STDEVA\",367:\"VARA\",368:\"BAHTTEXT\",369:\"THAIDAYOFWEEK\",370:\"THAIDIGIT\",371:\"THAIMONTHOFYEAR\",372:\"THAINUMSOUND\",373:\"THAINUMSTRING\",374:\"THAISTRINGLENGTH\",375:\"ISTHAIDIGIT\",376:\"ROUNDBAHTDOWN\",377:\"ROUNDBAHTUP\",378:\"THAIYEAR\",379:\"RTD\"};\nvar FtabArgc={2:1,3:1,15:1,16:1,17:1,18:1,20:1,21:1,22:1,23:1,24:1,25:1,26:1,27:2,30:2,31:3,32:1,33:1,38:1,39:2,40:3,41:3,42:3,43:3,44:3,45:3,47:3,48:2,53:1,61:3,65:3,66:3,67:1,68:1,69:1,71:1,72:1,73:1,75:1,76:1,77:1,79:2,80:2,83:1,86:1,90:1,97:2,98:1,99:1,105:1,111:1,112:1,113:1,114:1,117:2,118:1,119:4,121:1,126:1,127:1,128:1,129:1,130:1,131:1,133:1,134:1,135:1,136:2,137:2,138:2,140:1,141:1,142:3,143:4,162:1,163:1,164:1,165:2,172:1,175:2,176:2,177:3,178:2,179:1,184:1,189:3,190:1,195:3,196:3,198:1,199:3,201:1,207:4,210:3,211:1,212:2,213:2,214:1,215:1,229:1,230:1,231:1,232:1,233:1,234:1,235:3,244:1,252:2,257:1,261:1,271:1,273:4,274:2,275:2,276:2,277:3,278:3,279:1,280:3,281:3,282:3,283:1,284:1,285:2,286:4,287:3,288:2,289:4,290:3,291:3,292:3,293:4,294:1,295:3,296:1,297:3,298:1,299:2,300:3,301:3,302:4,303:2,304:2,305:2,306:2,307:2,308:2,309:3,310:2,311:2,312:2,313:2,314:2,315:2,316:4,325:2,326:2,327:2,328:2,331:2,332:2,337:2,342:1,343:1,346:2,347:1,350:4,351:3,352:1,353:2,360:1,368:1,369:1,370:1,371:1,372:1,373:1,374:1,375:1,376:1,377:1,378:1,65535:0};var XLSXFutureFunctions={\"_xlfn.ACOT\":\"ACOT\",\"_xlfn.ACOTH\":\"ACOTH\",\"_xlfn.AGGREGATE\":\"AGGREGATE\",\"_xlfn.ARABIC\":\"ARABIC\",\"_xlfn.AVERAGEIF\":\"AVERAGEIF\",\"_xlfn.AVERAGEIFS\":\"AVERAGEIFS\",\"_xlfn.BASE\":\"BASE\",\"_xlfn.BETA.DIST\":\"BETA.DIST\",\"_xlfn.BETA.INV\":\"BETA.INV\",\"_xlfn.BINOM.DIST\":\"BINOM.DIST\",\"_xlfn.BINOM.DIST.RANGE\":\"BINOM.DIST.RANGE\",\"_xlfn.BINOM.INV\":\"BINOM.INV\",\"_xlfn.BITAND\":\"BITAND\",\"_xlfn.BITLSHIFT\":\"BITLSHIFT\",\"_xlfn.BITOR\":\"BITOR\",\"_xlfn.BITRSHIFT\":\"BITRSHIFT\",\"_xlfn.BITXOR\":\"BITXOR\",\"_xlfn.CEILING.MATH\":\"CEILING.MATH\",\"_xlfn.CEILING.PRECISE\":\"CEILING.PRECISE\",\"_xlfn.CHISQ.DIST\":\"CHISQ.DIST\",\"_xlfn.CHISQ.DIST.RT\":\"CHISQ.DIST.RT\",\"_xlfn.CHISQ.INV\":\"CHISQ.INV\",\"_xlfn.CHISQ.INV.RT\":\"CHISQ.INV.RT\",\"_xlfn.CHISQ.TEST\":\"CHISQ.TEST\",\"_xlfn.COMBINA\":\"COMBINA\",\"_xlfn.CONFIDENCE.NORM\":\"CONFIDENCE.NORM\",\"_xlfn.CONFIDENCE.T\":\"CONFIDENCE.T\",\"_xlfn.COT\":\"COT\",\"_xlfn.COTH\":\"COTH\",\"_xlfn.COUNTIFS\":\"COUNTIFS\",\"_xlfn.COVARIANCE.P\":\"COVARIANCE.P\",\"_xlfn.COVARIANCE.S\":\"COVARIANCE.S\",\"_xlfn.CSC\":\"CSC\",\"_xlfn.CSCH\":\"CSCH\",\"_xlfn.DAYS\":\"DAYS\",\"_xlfn.DECIMAL\":\"DECIMAL\",\"_xlfn.ECMA.CEILING\":\"ECMA.CEILING\",\"_xlfn.ERF.PRECISE\":\"ERF.PRECISE\",\"_xlfn.ERFC.PRECISE\":\"ERFC.PRECISE\",\"_xlfn.EXPON.DIST\":\"EXPON.DIST\",\"_xlfn.F.DIST\":\"F.DIST\",\"_xlfn.F.DIST.RT\":\"F.DIST.RT\",\"_xlfn.F.INV\":\"F.INV\",\"_xlfn.F.INV.RT\":\"F.INV.RT\",\"_xlfn.F.TEST\":\"F.TEST\",\"_xlfn.FILTERXML\":\"FILTERXML\",\"_xlfn.FLOOR.MATH\":\"FLOOR.MATH\",\"_xlfn.FLOOR.PRECISE\":\"FLOOR.PRECISE\",\"_xlfn.FORMULATEXT\":\"FORMULATEXT\",\"_xlfn.GAMMA\":\"GAMMA\",\"_xlfn.GAMMA.DIST\":\"GAMMA.DIST\",\"_xlfn.GAMMA.INV\":\"GAMMA.INV\",\"_xlfn.GAMMALN.PRECISE\":\"GAMMALN.PRECISE\",\"_xlfn.GAUSS\":\"GAUSS\",\"_xlfn.HYPGEOM.DIST\":\"HYPGEOM.DIST\",\"_xlfn.IFNA\":\"IFNA\",\"_xlfn.IFERROR\":\"IFERROR\",\"_xlfn.IMCOSH\":\"IMCOSH\",\"_xlfn.IMCOT\":\"IMCOT\",\"_xlfn.IMCSC\":\"IMCSC\",\"_xlfn.IMCSCH\":\"IMCSCH\",\"_xlfn.IMSEC\":\"IMSEC\",\"_xlfn.IMSECH\":\"IMSECH\",\"_xlfn.IMSINH\":\"IMSINH\",\"_xlfn.IMTAN\":\"IMTAN\",\"_xlfn.ISFORMULA\":\"ISFORMULA\",\"_xlfn.ISO.CEILING\":\"ISO.CEILING\",\"_xlfn.ISOWEEKNUM\":\"ISOWEEKNUM\",\"_xlfn.LOGNORM.DIST\":\"LOGNORM.DIST\",\"_xlfn.LOGNORM.INV\":\"LOGNORM.INV\",\"_xlfn.MODE.MULT\":\"MODE.MULT\",\"_xlfn.MODE.SNGL\":\"MODE.SNGL\",\"_xlfn.MUNIT\":\"MUNIT\",\"_xlfn.NEGBINOM.DIST\":\"NEGBINOM.DIST\",\"_xlfn.NETWORKDAYS.INTL\":\"NETWORKDAYS.INTL\",\"_xlfn.NIGBINOM\":\"NIGBINOM\",\"_xlfn.NORM.DIST\":\"NORM.DIST\",\"_xlfn.NORM.INV\":\"NORM.INV\",\"_xlfn.NORM.S.DIST\":\"NORM.S.DIST\",\"_xlfn.NORM.S.INV\":\"NORM.S.INV\",\"_xlfn.NUMBERVALUE\":\"NUMBERVALUE\",\"_xlfn.PDURATION\":\"PDURATION\",\"_xlfn.PERCENTILE.EXC\":\"PERCENTILE.EXC\",\"_xlfn.PERCENTILE.INC\":\"PERCENTILE.INC\",\"_xlfn.PERCENTRANK.EXC\":\"PERCENTRANK.EXC\",\"_xlfn.PERCENTRANK.INC\":\"PERCENTRANK.INC\",\"_xlfn.PERMUTATIONA\":\"PERMUTATIONA\",\"_xlfn.PHI\":\"PHI\",\"_xlfn.POISSON.DIST\":\"POISSON.DIST\",\"_xlfn.QUARTILE.EXC\":\"QUARTILE.EXC\",\"_xlfn.QUARTILE.INC\":\"QUARTILE.INC\",\"_xlfn.QUERYSTRING\":\"QUERYSTRING\",\"_xlfn.RANK.AVG\":\"RANK.AVG\",\"_xlfn.RANK.EQ\":\"RANK.EQ\",\"_xlfn.RRI\":\"RRI\",\"_xlfn.SEC\":\"SEC\",\"_xlfn.SECH\":\"SECH\",\"_xlfn.SHEET\":\"SHEET\",\"_xlfn.SHEETS\":\"SHEETS\",\"_xlfn.SKEW.P\":\"SKEW.P\",\"_xlfn.STDEV.P\":\"STDEV.P\",\"_xlfn.STDEV.S\":\"STDEV.S\",\"_xlfn.SUMIFS\":\"SUMIFS\",\"_xlfn.T.DIST\":\"T.DIST\",\"_xlfn.T.DIST.2T\":\"T.DIST.2T\",\"_xlfn.T.DIST.RT\":\"T.DIST.RT\",\"_xlfn.T.INV\":\"T.INV\",\"_xlfn.T.INV.2T\":\"T.INV.2T\",\"_xlfn.T.TEST\":\"T.TEST\",\"_xlfn.UNICHAR\":\"UNICHAR\",\"_xlfn.UNICODE\":\"UNICODE\",\"_xlfn.VAR.P\":\"VAR.P\",\"_xlfn.VAR.S\":\"VAR.S\",\"_xlfn.WEBSERVICE\":\"WEBSERVICE\",\"_xlfn.WEIBULL.DIST\":\"WEIBULL.DIST\",\"_xlfn.WORKDAY.INTL\":\"WORKDAY.INTL\",\"_xlfn.XOR\":\"XOR\",\"_xlfn.Z.TEST\":\"Z.TEST\"};var strs={};var _ssfopts={};RELS.WS=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet\";function get_sst_id(sst,str){for(var i=0,len=sst.length;i<len;++i)if(sst[i].t===str){sst.Count++;return i}sst[len]={t:str};sst.Count++;sst.Unique++;return len}function get_cell_style(styles,cell,opts){var z=opts.revssf[cell.z!=null?cell.z:\"General\"];for(var i=0,len=styles.length;i!=len;++i)if(styles[i].numFmtId===z)return i;styles[len]={numFmtId:z,fontId:0,fillId:0,borderId:0,xfId:0,applyNumberFormat:1};return len}function safe_format(p,fmtid,fillid,opts){try{if(p.t===\"e\")p.w=p.w||BErr[p.v];else if(fmtid===0){if(p.t===\"n\"){if((p.v|0)===p.v)p.w=SSF._general_int(p.v,_ssfopts);else p.w=SSF._general_num(p.v,_ssfopts)}else if(p.t===\"d\"){var dd=datenum(p.v);if((dd|0)===dd)p.w=SSF._general_int(dd,_ssfopts);else p.w=SSF._general_num(dd,_ssfopts)}else if(p.v===undefined)return\"\";else p.w=SSF._general(p.v,_ssfopts)}else if(p.t===\"d\")p.w=SSF.format(fmtid,datenum(p.v),_ssfopts);else p.w=SSF.format(fmtid,p.v,_ssfopts);if(opts.cellNF)p.z=SSF._table[fmtid]}catch(e){if(opts.WTF)throw e}if(fillid)try{p.s=styles.Fills[fillid];if(p.s.fgColor&&p.s.fgColor.theme){p.s.fgColor.rgb=rgb_tint(themes.themeElements.clrScheme[p.s.fgColor.theme].rgb,p.s.fgColor.tint||0);if(opts.WTF)p.s.fgColor.raw_rgb=themes.themeElements.clrScheme[p.s.fgColor.theme].rgb}if(p.s.bgColor&&p.s.bgColor.theme){p.s.bgColor.rgb=rgb_tint(themes.themeElements.clrScheme[p.s.bgColor.theme].rgb,p.s.bgColor.tint||0);if(opts.WTF)p.s.bgColor.raw_rgb=themes.themeElements.clrScheme[p.s.bgColor.theme].rgb}}catch(e){if(opts.WTF)throw e}}function parse_ws_xml_dim(ws,s){var d=safe_decode_range(s);if(d.s.r<=d.e.r&&d.s.c<=d.e.c&&d.s.r>=0&&d.s.c>=0)ws[\"!ref\"]=encode_range(d)}var mergecregex=/<mergeCell ref=\"[A-Z0-9:]+\"\\s*\\/>/g;var sheetdataregex=/<(?:\\w+:)?sheetData>([^\\u2603]*)<\\/(?:\\w+:)?sheetData>/;var hlinkregex=/<hyperlink[^>]*\\/>/g;var dimregex=/\"(\\w*:\\w*)\"/;var colregex=/<col[^>]*\\/>/g;function parse_ws_xml(data,opts,rels){if(!data)return data;var s={};var ridx=data.indexOf(\"<dimension\");if(ridx>0){var ref=data.substr(ridx,50).match(dimregex);if(ref!=null)parse_ws_xml_dim(s,ref[1])}var mergecells=[];if(data.indexOf(\"</mergeCells>\")!==-1){var merges=data.match(mergecregex);for(ridx=0;ridx!=merges.length;++ridx)mergecells[ridx]=safe_decode_range(merges[ridx].substr(merges[ridx].indexOf('\"')+1))}var columns=[];if(opts.cellStyles&&data.indexOf(\"</cols>\")!==-1){var cols=data.match(colregex);parse_ws_xml_cols(columns,cols)}var refguess={s:{r:1e6,c:1e6},e:{r:0,c:0}};var mtch=data.match(sheetdataregex);if(mtch)parse_ws_xml_data(mtch[1],s,opts,refguess);if(data.indexOf(\"</hyperlinks>\")!==-1)parse_ws_xml_hlinks(s,data.match(hlinkregex),rels);if(!s[\"!ref\"]&&refguess.e.c>=refguess.s.c&&refguess.e.r>=refguess.s.r)s[\"!ref\"]=encode_range(refguess);if(opts.sheetRows>0&&s[\"!ref\"]){var tmpref=safe_decode_range(s[\"!ref\"]);if(opts.sheetRows<+tmpref.e.r){tmpref.e.r=opts.sheetRows-1;if(tmpref.e.r>refguess.e.r)tmpref.e.r=refguess.e.r;if(tmpref.e.r<tmpref.s.r)tmpref.s.r=tmpref.e.r;if(tmpref.e.c>refguess.e.c)tmpref.e.c=refguess.e.c;if(tmpref.e.c<tmpref.s.c)tmpref.s.c=tmpref.e.c;s[\"!fullref\"]=s[\"!ref\"];s[\"!ref\"]=encode_range(tmpref)}}if(mergecells.length>0)s[\"!merges\"]=mergecells;if(columns.length>0)s[\"!cols\"]=columns;return s}function write_ws_xml_merges(merges){if(merges.length==0)return\"\";var o='<mergeCells count=\"'+merges.length+'\">';for(var i=0;i!=merges.length;++i)o+='<mergeCell ref=\"'+encode_range(merges[i])+'\"/>';return o+\"</mergeCells>\"}function parse_ws_xml_hlinks(s,data,rels){for(var i=0;i!=data.length;++i){var val=parsexmltag(data[i],true);if(!val.ref)return;var rel=rels?rels[\"!id\"][val.id]:null;if(rel){val.Target=rel.Target;if(val.location)val.Target+=\"#\"+val.location;val.Rel=rel}else{val.Target=val.location;rel={Target:val.location,TargetMode:\"Internal\"};val.Rel=rel}var rng=safe_decode_range(val.ref);for(var R=rng.s.r;R<=rng.e.r;++R)for(var C=rng.s.c;C<=rng.e.c;++C){var addr=encode_cell({c:C,r:R});if(!s[addr])s[addr]={t:\"stub\",v:undefined};s[addr].l=val}}}function parse_ws_xml_cols(columns,cols){var seencol=false;for(var coli=0;coli!=cols.length;++coli){var coll=parsexmltag(cols[coli],true);var colm=parseInt(coll.min,10)-1,colM=parseInt(coll.max,10)-1;delete coll.min;delete coll.max;if(!seencol&&coll.width){seencol=true;find_mdw(+coll.width,coll)}if(coll.width){coll.wpx=width2px(+coll.width);coll.wch=px2char(coll.wpx);coll.MDW=MDW}while(colm<=colM)columns[colm++]=coll}}function write_ws_xml_cols(ws,cols){var o=[\"<cols>\"],col,width;for(var i=0;i!=cols.length;++i){if(!(col=cols[i]))continue;var p={min:i+1,max:i+1};width=-1;if(col.wpx)width=px2char(col.wpx);else if(col.wch)width=col.wch;if(width>-1){p.width=char2width(width);p.customWidth=1}o[o.length]=writextag(\"col\",null,p)}o[o.length]=\"</cols>\";return o.join(\"\")}function write_ws_xml_cell(cell,ref,ws,opts,idx,wb){if(cell.v===undefined)return\"\";var vv=\"\";var oldt=cell.t,oldv=cell.v;switch(cell.t){case\"b\":vv=cell.v?\"1\":\"0\";break;case\"n\":vv=\"\"+cell.v;break;case\"e\":vv=BErr[cell.v];break;case\"d\":if(opts.cellDates)vv=new Date(cell.v).toISOString();else{cell.t=\"n\";vv=\"\"+(cell.v=datenum(cell.v));if(typeof cell.z===\"undefined\")cell.z=SSF._table[14]}break;default:vv=cell.v;break}var v=writetag(\"v\",escapexml(vv)),o={r:ref};var os=get_cell_style(opts.cellXfs,cell,opts);if(os!==0)o.s=os;switch(cell.t){case\"n\":break;case\"d\":o.t=\"d\";break;case\"b\":o.t=\"b\";break;case\"e\":o.t=\"e\";break;default:if(opts.bookSST){v=writetag(\"v\",\"\"+get_sst_id(opts.Strings,cell.v));o.t=\"s\";break}o.t=\"str\";break}if(cell.t!=oldt){cell.t=oldt;cell.v=oldv}return writextag(\"c\",v,o)}var parse_ws_xml_data=function parse_ws_xml_data_factory(){var cellregex=/<(?:\\w+:)?c[ >]/,rowregex=/<\\/(?:\\w+:)?row>/;var rregex=/r=[\"']([^\"']*)[\"']/,isregex=/<is>([\\S\\s]*?)<\\/is>/;var match_v=matchtag(\"v\"),match_f=matchtag(\"f\");return function parse_ws_xml_data(sdata,s,opts,guess){var ri=0,x=\"\",cells=[],cref=[],idx=0,i=0,cc=0,d=\"\",p;var tag,tagr=0,tagc=0;var sstr;var fmtid=0,fillid=0,do_format=Array.isArray(styles.CellXf),cf;for(var marr=sdata.split(rowregex),mt=0,marrlen=marr.length;mt!=marrlen;++mt){x=marr[mt].trim();var xlen=x.length;if(xlen===0)continue;for(ri=0;ri<xlen;++ri)if(x.charCodeAt(ri)===62)break;++ri;tag=parsexmltag(x.substr(0,ri),true);tagr=typeof tag.r!==\"undefined\"?parseInt(tag.r,10):tagr+1;tagc=-1;if(opts.sheetRows&&opts.sheetRows<tagr)continue;if(guess.s.r>tagr-1)guess.s.r=tagr-1;if(guess.e.r<tagr-1)guess.e.r=tagr-1;cells=x.substr(ri).split(cellregex);for(ri=typeof tag.r===\"undefined\"?0:1;ri!=cells.length;++ri){x=cells[ri].trim();if(x.length===0)continue;cref=x.match(rregex);idx=ri;i=0;cc=0;x=\"<c \"+(x.substr(0,1)==\"<\"?\">\":\"\")+x;if(cref!==null&&cref.length===2){idx=0;d=cref[1];for(i=0;i!=d.length;++i){if((cc=d.charCodeAt(i)-64)<1||cc>26)break;idx=26*idx+cc}--idx;tagc=idx}else++tagc;for(i=0;i!=x.length;++i)if(x.charCodeAt(i)===62)break;++i;tag=parsexmltag(x.substr(0,i),true);if(!tag.r)tag.r=utils.encode_cell({r:tagr-1,c:tagc});d=x.substr(i);p={t:\"\"};if((cref=d.match(match_v))!==null&&cref[1]!==\"\")p.v=unescapexml(cref[1]);if(opts.cellFormula&&(cref=d.match(match_f))!==null)p.f=unescapexml(cref[1]);if(tag.t===undefined&&p.v===undefined){if(!opts.sheetStubs)continue;p.t=\"stub\"}else p.t=tag.t||\"n\";if(guess.s.c>idx)guess.s.c=idx;if(guess.e.c<idx)guess.e.c=idx;switch(p.t){case\"n\":p.v=parseFloat(p.v);break;case\"s\":sstr=strs[parseInt(p.v,10)];p.v=sstr.t;p.r=sstr.r;if(opts.cellHTML)p.h=sstr.h;break;case\"str\":p.t=\"s\";p.v=p.v!=null?utf8read(p.v):\"\";if(opts.cellHTML)p.h=p.v;break;case\"inlineStr\":cref=d.match(isregex);p.t=\"s\";if(cref!==null){sstr=parse_si(cref[1]);p.v=sstr.t}else p.v=\"\";break;case\"b\":p.v=parsexmlbool(p.v);break;case\"d\":if(!opts.cellDates){p.v=datenum(p.v);p.t=\"n\"}break;case\"e\":p.w=p.v;p.v=RBErr[p.v];break}fmtid=fillid=0;if(do_format&&tag.s!==undefined){cf=styles.CellXf[tag.s];if(cf!=null){if(cf.numFmtId!=null)fmtid=cf.numFmtId;if(opts.cellStyles&&cf.fillId!=null)fillid=cf.fillId}}safe_format(p,fmtid,fillid,opts);s[tag.r]=p}}}}();function write_ws_xml_data(ws,opts,idx,wb){var o=[],r=[],range=safe_decode_range(ws[\"!ref\"]),cell,ref,rr=\"\",cols=[],R,C;for(C=range.s.c;C<=range.e.c;++C)cols[C]=encode_col(C);for(R=range.s.r;R<=range.e.r;++R){r=[];rr=encode_row(R);for(C=range.s.c;C<=range.e.c;++C){ref=cols[C]+rr;if(ws[ref]===undefined)continue;if((cell=write_ws_xml_cell(ws[ref],ref,ws,opts,idx,wb))!=null)r.push(cell)}if(r.length>0)o[o.length]=writextag(\"row\",r.join(\"\"),{r:rr})}return o.join(\"\")}var WS_XML_ROOT=writextag(\"worksheet\",null,{xmlns:XMLNS.main[0],\"xmlns:r\":XMLNS.r});function write_ws_xml(idx,opts,wb){var o=[XML_HEADER,WS_XML_ROOT];var s=wb.SheetNames[idx],sidx=0,rdata=\"\";var ws=wb.Sheets[s];if(ws===undefined)ws={};var ref=ws[\"!ref\"];if(ref===undefined)ref=\"A1\";o[o.length]=writextag(\"dimension\",null,{ref:ref});if(ws[\"!cols\"]!==undefined&&ws[\"!cols\"].length>0)o[o.length]=write_ws_xml_cols(ws,ws[\"!cols\"]);o[sidx=o.length]=\"<sheetData/>\";if(ws[\"!ref\"]!==undefined){rdata=write_ws_xml_data(ws,opts,idx,wb);if(rdata.length>0)o[o.length]=rdata}if(o.length>sidx+1){o[o.length]=\"</sheetData>\";o[sidx]=o[sidx].replace(\"/>\",\">\")}if(ws[\"!merges\"]!==undefined&&ws[\"!merges\"].length>0)o[o.length]=write_ws_xml_merges(ws[\"!merges\"]);if(o.length>2){o[o.length]=\"</worksheet>\";o[1]=o[1].replace(\"/>\",\">\")}return o.join(\"\")}function parse_BrtRowHdr(data,length){var z=[];z.r=data.read_shift(4);data.l+=length-4;return z}var parse_BrtWsDim=parse_UncheckedRfX;var write_BrtWsDim=write_UncheckedRfX;function parse_BrtWsProp(data,length){var z={};data.l+=19;z.name=parse_XLSBCodeName(data,length-19);return z}function parse_BrtCellBlank(data,length){var cell=parse_XLSBCell(data);return[cell]}function write_BrtCellBlank(cell,val,o){if(o==null)o=new_buf(8);return write_XLSBCell(val,o)}function parse_BrtCellBool(data,length){var cell=parse_XLSBCell(data);var fBool=data.read_shift(1);return[cell,fBool,\"b\"]}function parse_BrtCellError(data,length){var cell=parse_XLSBCell(data);var fBool=data.read_shift(1);return[cell,fBool,\"e\"]}function parse_BrtCellIsst(data,length){var cell=parse_XLSBCell(data);var isst=data.read_shift(4);return[cell,isst,\"s\"]}function parse_BrtCellReal(data,length){var cell=parse_XLSBCell(data);var value=parse_Xnum(data);return[cell,value,\"n\"]}function parse_BrtCellRk(data,length){var cell=parse_XLSBCell(data);var value=parse_RkNumber(data);return[cell,value,\"n\"]}function parse_BrtCellSt(data,length){var cell=parse_XLSBCell(data);var value=parse_XLWideString(data);return[cell,value,\"str\"]}function parse_BrtFmlaBool(data,length,opts){var cell=parse_XLSBCell(data);var value=data.read_shift(1);var o=[cell,value,\"b\"];if(opts.cellFormula){var formula=parse_XLSBCellParsedFormula(data,length-9);o[3]=\"\"}else data.l+=length-9;return o}function parse_BrtFmlaError(data,length,opts){var cell=parse_XLSBCell(data);var value=data.read_shift(1);var o=[cell,value,\"e\"];if(opts.cellFormula){var formula=parse_XLSBCellParsedFormula(data,length-9);o[3]=\"\"}else data.l+=length-9;return o}function parse_BrtFmlaNum(data,length,opts){var cell=parse_XLSBCell(data);var value=parse_Xnum(data);var o=[cell,value,\"n\"];if(opts.cellFormula){var formula=parse_XLSBCellParsedFormula(data,length-16);o[3]=\"\"}else data.l+=length-16;return o}function parse_BrtFmlaString(data,length,opts){var start=data.l;var cell=parse_XLSBCell(data);var value=parse_XLWideString(data);var o=[cell,value,\"str\"];if(opts.cellFormula){var formula=parse_XLSBCellParsedFormula(data,start+length-data.l)}else data.l=start+length;return o}var parse_BrtMergeCell=parse_UncheckedRfX;function parse_BrtHLink(data,length,opts){var end=data.l+length;var rfx=parse_UncheckedRfX(data,16);var relId=parse_XLNullableWideString(data);var loc=parse_XLWideString(data);var tooltip=parse_XLWideString(data);var display=parse_XLWideString(data);data.l=end;return{rfx:rfx,relId:relId,loc:loc,tooltip:tooltip,display:display}}function parse_ws_bin(data,opts,rels){if(!data)return data;if(!rels)rels={\"!id\":{}};var s={};var ref;var refguess={s:{r:1e6,c:1e6},e:{r:0,c:0}};var pass=false,end=false;var row,p,cf,R,C,addr,sstr,rr;var mergecells=[];recordhopper(data,function ws_parse(val,R){if(end)return;switch(R.n){case\"BrtWsDim\":ref=val;break;case\"BrtRowHdr\":row=val;if(opts.sheetRows&&opts.sheetRows<=row.r)end=true;rr=encode_row(row.r);break;case\"BrtFmlaBool\":case\"BrtFmlaError\":case\"BrtFmlaNum\":case\"BrtFmlaString\":case\"BrtCellBool\":case\"BrtCellError\":case\"BrtCellIsst\":case\"BrtCellReal\":case\"BrtCellRk\":case\"BrtCellSt\":p={t:val[2]};switch(val[2]){case\"n\":p.v=val[1];break;case\"s\":sstr=strs[val[1]];p.v=sstr.t;p.r=sstr.r;break;case\"b\":p.v=val[1]?true:false;break;case\"e\":p.v=val[1];p.w=BErr[p.v];break;case\"str\":p.t=\"s\";p.v=utf8read(val[1]);break}if(opts.cellFormula&&val.length>3)p.f=val[3];if(cf=styles.CellXf[val[0].iStyleRef])safe_format(p,cf.ifmt,null,opts);s[encode_col(C=val[0].c)+rr]=p;if(refguess.s.r>row.r)refguess.s.r=row.r;if(refguess.s.c>C)refguess.s.c=C;if(refguess.e.r<row.r)refguess.e.r=row.r;if(refguess.e.c<C)refguess.e.c=C;break;case\"BrtCellBlank\":if(!opts.sheetStubs)break;p={t:\"s\",v:undefined};s[encode_col(C=val[0].c)+rr]=p;if(refguess.s.r>row.r)refguess.s.r=row.r;if(refguess.s.c>C)refguess.s.c=C;if(refguess.e.r<row.r)refguess.e.r=row.r;if(refguess.e.c<C)refguess.e.c=C;break;case\"BrtBeginMergeCells\":break;case\"BrtEndMergeCells\":break;case\"BrtMergeCell\":mergecells.push(val);break;case\"BrtHLink\":var rel=rels[\"!id\"][val.relId];if(rel){val.Target=rel.Target;if(val.loc)val.Target+=\"#\"+val.loc;val.Rel=rel}for(R=val.rfx.s.r;R<=val.rfx.e.r;++R)for(C=val.rfx.s.c;C<=val.rfx.e.c;++C){addr=encode_cell({c:C,r:R});if(!s[addr])s[addr]={t:\"s\",v:undefined};s[addr].l=val}break;case\"BrtArrFmla\":break;case\"BrtShrFmla\":break;case\"BrtBeginSheet\":break;case\"BrtWsProp\":break;case\"BrtSheetCalcProp\":break;case\"BrtBeginWsViews\":break;case\"BrtBeginWsView\":break;case\"BrtPane\":break;case\"BrtSel\":break;case\"BrtEndWsView\":break;case\"BrtEndWsViews\":break;case\"BrtACBegin\":break;case\"BrtRwDescent\":break;case\"BrtACEnd\":break;case\"BrtWsFmtInfoEx14\":break;case\"BrtWsFmtInfo\":break;case\"BrtBeginColInfos\":break;case\"BrtColInfo\":break;case\"BrtEndColInfos\":break;case\"BrtBeginSheetData\":break;case\"BrtEndSheetData\":break;case\"BrtSheetProtection\":break;case\"BrtPrintOptions\":break;case\"BrtMargins\":break;case\"BrtPageSetup\":break;case\"BrtFRTBegin\":pass=true;break;case\"BrtFRTEnd\":pass=false;break;case\"BrtEndSheet\":break;case\"BrtDrawing\":break;case\"BrtLegacyDrawing\":break;case\"BrtLegacyDrawingHF\":break;case\"BrtPhoneticInfo\":break;case\"BrtBeginHeaderFooter\":break;case\"BrtEndHeaderFooter\":break;case\"BrtBrk\":break;case\"BrtBeginRwBrk\":break;case\"BrtEndRwBrk\":break;case\"BrtBeginColBrk\":break;case\"BrtEndColBrk\":break;case\"BrtBeginUserShViews\":break;case\"BrtBeginUserShView\":break;case\"BrtEndUserShView\":break;case\"BrtEndUserShViews\":break;case\"BrtBkHim\":break;case\"BrtBeginOleObjects\":break;case\"BrtOleObject\":break;case\"BrtEndOleObjects\":break;case\"BrtBeginListParts\":break;case\"BrtListPart\":break;case\"BrtEndListParts\":break;case\"BrtBeginSortState\":break;case\"BrtBeginSortCond\":break;case\"BrtEndSortCond\":break;case\"BrtEndSortState\":break;case\"BrtBeginConditionalFormatting\":break;case\"BrtEndConditionalFormatting\":break;case\"BrtBeginCFRule\":break;case\"BrtEndCFRule\":break;case\"BrtBeginDVals\":break;case\"BrtDVal\":break;case\"BrtEndDVals\":break;case\"BrtRangeProtection\":break;case\"BrtBeginDCon\":break;case\"BrtEndDCon\":break;case\"BrtBeginDRefs\":break;case\"BrtDRef\":break;case\"BrtEndDRefs\":break;case\"BrtBeginActiveXControls\":break;case\"BrtActiveX\":break;case\"BrtEndActiveXControls\":break;case\"BrtBeginAFilter\":break;case\"BrtEndAFilter\":break;case\"BrtBeginFilterColumn\":break;case\"BrtBeginFilters\":break;case\"BrtFilter\":break;case\"BrtEndFilters\":break;case\"BrtEndFilterColumn\":break;case\"BrtDynamicFilter\":break;case\"BrtTop10Filter\":break;case\"BrtBeginCustomFilters\":break;case\"BrtCustomFilter\":break;case\"BrtEndCustomFilters\":break;case\"BrtBeginSmartTags\":break;case\"BrtBeginCellSmartTags\":break;case\"BrtBeginCellSmartTag\":break;case\"BrtCellSmartTagProperty\":break;case\"BrtEndCellSmartTag\":break;case\"BrtEndCellSmartTags\":break;case\"BrtEndSmartTags\":break;case\"BrtBeginCellWatches\":break;case\"BrtCellWatch\":break;case\"BrtEndCellWatches\":break;case\"BrtTable\":break;case\"BrtBeginCellIgnoreECs\":break;case\"BrtCellIgnoreEC\":break;case\"BrtEndCellIgnoreECs\":break;default:if(!pass||opts.WTF)throw new Error(\"Unexpected record \"+R.n)}},opts);if(!s[\"!ref\"]&&(refguess.s.r<1e6||ref.e.r>0||ref.e.c>0||ref.s.r>0||ref.s.c>0))s[\"!ref\"]=encode_range(ref);if(opts.sheetRows&&s[\"!ref\"]){var tmpref=safe_decode_range(s[\"!ref\"]);if(opts.sheetRows<+tmpref.e.r){tmpref.e.r=opts.sheetRows-1;if(tmpref.e.r>refguess.e.r)tmpref.e.r=refguess.e.r;if(tmpref.e.r<tmpref.s.r)tmpref.s.r=tmpref.e.r;if(tmpref.e.c>refguess.e.c)tmpref.e.c=refguess.e.c;if(tmpref.e.c<tmpref.s.c)tmpref.s.c=tmpref.e.c;s[\"!fullref\"]=s[\"!ref\"];s[\"!ref\"]=encode_range(tmpref)}}if(mergecells.length>0)s[\"!merges\"]=mergecells;return s}function write_ws_bin_cell(ba,cell,R,C,opts){if(cell.v===undefined)return\"\";var vv=\"\";switch(cell.t){case\"b\":vv=cell.v?\"1\":\"0\";break;case\"n\":case\"e\":vv=\"\"+cell.v;break;default:vv=cell.v;break}var o={r:R,c:C};o.s=get_cell_style(opts.cellXfs,cell,opts);switch(cell.t){case\"s\":case\"str\":if(opts.bookSST){vv=get_sst_id(opts.Strings,cell.v);o.t=\"s\";break}o.t=\"str\";break;case\"n\":break;case\"b\":o.t=\"b\";break;case\"e\":o.t=\"e\";break}write_record(ba,\"BrtCellBlank\",write_BrtCellBlank(cell,o))}function write_CELLTABLE(ba,ws,idx,opts,wb){var range=safe_decode_range(ws[\"!ref\"]||\"A1\"),ref,rr=\"\",cols=[];write_record(ba,\"BrtBeginSheetData\");for(var R=range.s.r;R<=range.e.r;++R){rr=encode_row(R);for(var C=range.s.c;C<=range.e.c;++C){if(R===range.s.r)cols[C]=encode_col(C);ref=cols[C]+rr;if(!ws[ref])continue;write_ws_bin_cell(ba,ws[ref],R,C,opts)}}write_record(ba,\"BrtEndSheetData\")}function write_ws_bin(idx,opts,wb){var ba=buf_array();var s=wb.SheetNames[idx],ws=wb.Sheets[s]||{};var r=safe_decode_range(ws[\"!ref\"]||\"A1\");write_record(ba,\"BrtBeginSheet\");write_record(ba,\"BrtWsDim\",write_BrtWsDim(r));write_CELLTABLE(ba,ws,idx,opts,wb);write_record(ba,\"BrtEndSheet\");return ba.end()}var WBPropsDef=[[\"allowRefreshQuery\",\"0\"],[\"autoCompressPictures\",\"1\"],[\"backupFile\",\"0\"],[\"checkCompatibility\",\"0\"],[\"codeName\",\"\"],[\"date1904\",\"0\"],[\"dateCompatibility\",\"1\"],[\"filterPrivacy\",\"0\"],[\"hidePivotFieldList\",\"0\"],[\"promptedSolutions\",\"0\"],[\"publishItems\",\"0\"],[\"refreshAllConnections\",false],[\"saveExternalLinkValues\",\"1\"],[\"showBorderUnselectedTables\",\"1\"],[\"showInkAnnotation\",\"1\"],[\"showObjects\",\"all\"],[\"showPivotChartFilter\",\"0\"]];var WBViewDef=[[\"activeTab\",\"0\"],[\"autoFilterDateGrouping\",\"1\"],[\"firstSheet\",\"0\"],[\"minimized\",\"0\"],[\"showHorizontalScroll\",\"1\"],[\"showSheetTabs\",\"1\"],[\"showVerticalScroll\",\"1\"],[\"tabRatio\",\"600\"],[\"visibility\",\"visible\"]];var SheetDef=[[\"state\",\"visible\"]];var CalcPrDef=[[\"calcCompleted\",\"true\"],[\"calcMode\",\"auto\"],[\"calcOnSave\",\"true\"],[\"concurrentCalc\",\"true\"],[\"fullCalcOnLoad\",\"false\"],[\"fullPrecision\",\"true\"],[\"iterate\",\"false\"],[\"iterateCount\",\"100\"],[\"iterateDelta\",\"0.001\"],[\"refMode\",\"A1\"]];var CustomWBViewDef=[[\"autoUpdate\",\"false\"],[\"changesSavedWin\",\"false\"],[\"includeHiddenRowCol\",\"true\"],[\"includePrintSettings\",\"true\"],[\"maximized\",\"false\"],[\"minimized\",\"false\"],[\"onlySync\",\"false\"],[\"personalView\",\"false\"],[\"showComments\",\"commIndicator\"],[\"showFormulaBar\",\"true\"],[\"showHorizontalScroll\",\"true\"],[\"showObjects\",\"all\"],[\"showSheetTabs\",\"true\"],[\"showStatusbar\",\"true\"],[\"showVerticalScroll\",\"true\"],[\"tabRatio\",\"600\"],[\"xWindow\",\"0\"],[\"yWindow\",\"0\"]];function push_defaults_array(target,defaults){for(var j=0;j!=target.length;++j){var w=target[j];for(var i=0;i!=defaults.length;++i){var z=defaults[i];if(w[z[0]]==null)w[z[0]]=z[1]}}}function push_defaults(target,defaults){for(var i=0;i!=defaults.length;++i){var z=defaults[i];if(target[z[0]]==null)target[z[0]]=z[1]}}function parse_wb_defaults(wb){push_defaults(wb.WBProps,WBPropsDef);push_defaults(wb.CalcPr,CalcPrDef);push_defaults_array(wb.WBView,WBViewDef);push_defaults_array(wb.Sheets,SheetDef);_ssfopts.date1904=parsexmlbool(wb.WBProps.date1904,\"date1904\")}var wbnsregex=/<\\w+:workbook/;function parse_wb_xml(data,opts){var wb={AppVersion:{},WBProps:{},WBView:[],Sheets:[],CalcPr:{},xmlns:\"\"};var pass=false,xmlns=\"xmlns\";data.match(tagregex).forEach(function xml_wb(x){var y=parsexmltag(x);switch(strip_ns(y[0])){case\"<?xml\":break;case\"<workbook\":if(x.match(wbnsregex))xmlns=\"xmlns\"+x.match(/<(\\w+):/)[1];wb.xmlns=y[xmlns];break;case\"</workbook>\":break;case\"<fileVersion\":delete y[0];wb.AppVersion=y;break;case\"<fileVersion/>\":break;case\"<fileSharing\":case\"<fileSharing/>\":break;case\"<workbookPr\":delete y[0];wb.WBProps=y;break;case\"<workbookPr/>\":delete y[0];wb.WBProps=y;break;case\"<workbookProtection\":break;case\"<workbookProtection/>\":break;case\"<bookViews>\":case\"</bookViews>\":break;case\"<workbookView\":delete y[0];wb.WBView.push(y);break;case\"<sheets>\":case\"</sheets>\":break;case\"<sheet\":delete y[0];y.name=utf8read(y.name);wb.Sheets.push(y);break;case\"<functionGroups\":case\"<functionGroups/>\":break;case\"<functionGroup\":break;case\"<externalReferences\":case\"</externalReferences>\":case\"<externalReferences>\":break;case\"<externalReference\":break;case\"<definedNames/>\":break;case\"<definedNames>\":case\"<definedNames\":pass=true;break;case\"</definedNames>\":pass=false;break;case\"<definedName\":case\"<definedName/>\":case\"</definedName>\":break;case\"<calcPr\":delete y[0];wb.CalcPr=y;break;case\"<calcPr/>\":delete y[0];wb.CalcPr=y;break;case\"<oleSize\":break;case\"<customWorkbookViews>\":case\"</customWorkbookViews>\":case\"<customWorkbookViews\":break;case\"<customWorkbookView\":case\"</customWorkbookView>\":break;case\"<pivotCaches>\":case\"</pivotCaches>\":case\"<pivotCaches\":break;case\"<pivotCache\":break;case\"<smartTagPr\":case\"<smartTagPr/>\":break;case\"<smartTagTypes\":case\"<smartTagTypes>\":case\"</smartTagTypes>\":break;case\"<smartTagType\":break;case\"<webPublishing\":case\"<webPublishing/>\":break;case\"<fileRecoveryPr\":case\"<fileRecoveryPr/>\":break;case\"<webPublishObjects>\":case\"<webPublishObjects\":case\"</webPublishObjects>\":break;case\"<webPublishObject\":break;case\"<extLst>\":case\"</extLst>\":case\"<extLst/>\":break;case\"<ext\":pass=true;break;case\"</ext>\":pass=false;break;case\"<ArchID\":break;case\"<AlternateContent\":pass=true;break;case\"</AlternateContent>\":pass=false;break;default:if(!pass&&opts.WTF)throw\"unrecognized \"+y[0]+\" in workbook\"}});if(XMLNS.main.indexOf(wb.xmlns)===-1)throw new Error(\"Unknown Namespace: \"+wb.xmlns);parse_wb_defaults(wb);return wb}var WB_XML_ROOT=writextag(\"workbook\",null,{xmlns:XMLNS.main[0],\"xmlns:r\":XMLNS.r});function safe1904(wb){try{return parsexmlbool(wb.Workbook.WBProps.date1904)?\"true\":\"false\"}catch(e){return\"false\"}}function write_wb_xml(wb,opts){var o=[XML_HEADER];o[o.length]=WB_XML_ROOT;o[o.length]=writextag(\"workbookPr\",null,{date1904:safe1904(wb)});o[o.length]=\"<sheets>\";for(var i=0;i!=wb.SheetNames.length;++i)o[o.length]=writextag(\"sheet\",null,{name:wb.SheetNames[i].substr(0,31),sheetId:\"\"+(i+1),\"r:id\":\"rId\"+(i+1)});o[o.length]=\"</sheets>\";if(o.length>2){o[o.length]=\"</workbook>\";o[1]=o[1].replace(\"/>\",\">\")}return o.join(\"\")}function parse_BrtBundleSh(data,length){var z={};z.hsState=data.read_shift(4);z.iTabID=data.read_shift(4);z.strRelID=parse_RelID(data,length-8);z.name=parse_XLWideString(data);return z}function write_BrtBundleSh(data,o){if(!o)o=new_buf(127);o.write_shift(4,data.hsState);o.write_shift(4,data.iTabID);write_RelID(data.strRelID,o);write_XLWideString(data.name.substr(0,31),o);return o}function parse_BrtWbProp(data,length){data.read_shift(4);var dwThemeVersion=data.read_shift(4);var strName=length>8?parse_XLWideString(data):\"\";return[dwThemeVersion,strName]}function write_BrtWbProp(data,o){if(!o)o=new_buf(8);o.write_shift(4,0);o.write_shift(4,0);return o}function parse_BrtFRTArchID$(data,length){var o={};data.read_shift(4);o.ArchID=data.read_shift(4);data.l+=length-8;return o}function parse_wb_bin(data,opts){var wb={AppVersion:{},WBProps:{},WBView:[],Sheets:[],CalcPr:{},xmlns:\"\"};var pass=false,z;recordhopper(data,function hopper_wb(val,R){switch(R.n){case\"BrtBundleSh\":wb.Sheets.push(val);break;case\"BrtBeginBook\":break;case\"BrtFileVersion\":break;case\"BrtWbProp\":break;case\"BrtACBegin\":break;case\"BrtAbsPath15\":break;case\"BrtACEnd\":break;case\"BrtWbFactoid\":break;case\"BrtBookProtection\":break;case\"BrtBeginBookViews\":break;case\"BrtBookView\":break;case\"BrtEndBookViews\":break;case\"BrtBeginBundleShs\":break;case\"BrtEndBundleShs\":break;case\"BrtBeginFnGroup\":break;case\"BrtEndFnGroup\":break;case\"BrtBeginExternals\":break;case\"BrtSupSelf\":break;case\"BrtSupBookSrc\":break;case\"BrtExternSheet\":break;case\"BrtEndExternals\":break;case\"BrtName\":break;case\"BrtCalcProp\":break;case\"BrtUserBookView\":break;case\"BrtBeginPivotCacheIDs\":break;case\"BrtBeginPivotCacheID\":break;case\"BrtEndPivotCacheID\":break;case\"BrtEndPivotCacheIDs\":break;case\"BrtWebOpt\":break;case\"BrtFileRecover\":break;case\"BrtFileSharing\":break;case\"BrtBeginSmartTagTypes\":break;case\"BrtSmartTagType\":break;case\"BrtEndSmartTagTypes\":break;case\"BrtFRTBegin\":pass=true;break;case\"BrtFRTArchID$\":break;case\"BrtWorkBookPr15\":break;case\"BrtFRTEnd\":pass=false;break;case\"BrtEndBook\":break;default:if(!pass||opts.WTF)throw new Error(\"Unexpected record \"+R.n)}});parse_wb_defaults(wb);return wb}function write_BUNDLESHS(ba,wb,opts){write_record(ba,\"BrtBeginBundleShs\");for(var idx=0;idx!=wb.SheetNames.length;++idx){var d={hsState:0,iTabID:idx+1,strRelID:\"rId\"+(idx+1),name:wb.SheetNames[idx]};write_record(ba,\"BrtBundleSh\",write_BrtBundleSh(d))}write_record(ba,\"BrtEndBundleShs\")}function write_BrtFileVersion(data,o){if(!o)o=new_buf(127);for(var i=0;i!=4;++i)o.write_shift(4,0);write_XLWideString(\"SheetJS\",o);write_XLWideString(XLSX.version,o);write_XLWideString(XLSX.version,o);write_XLWideString(\"7262\",o);o.length=o.l;return o}function write_BOOKVIEWS(ba,wb,opts){write_record(ba,\"BrtBeginBookViews\");write_record(ba,\"BrtEndBookViews\")}function write_BrtCalcProp(data,o){if(!o)o=new_buf(26);o.write_shift(4,0);o.write_shift(4,1);o.write_shift(4,0);write_Xnum(0,o);o.write_shift(-4,1023);o.write_shift(1,51);o.write_shift(1,0);return o}function write_BrtFileRecover(data,o){if(!o)o=new_buf(1);o.write_shift(1,0);return o}function write_wb_bin(wb,opts){var ba=buf_array();write_record(ba,\"BrtBeginBook\");write_record(ba,\"BrtFileVersion\",write_BrtFileVersion());write_record(ba,\"BrtWbProp\",write_BrtWbProp());write_BOOKVIEWS(ba,wb,opts);write_BUNDLESHS(ba,wb,opts);write_record(ba,\"BrtCalcProp\",write_BrtCalcProp());write_record(ba,\"BrtFileRecover\",write_BrtFileRecover());write_record(ba,\"BrtEndBook\");return ba.end()}function parse_wb(data,name,opts){return(name.substr(-4)===\".bin\"?parse_wb_bin:parse_wb_xml)(data,opts)}function parse_ws(data,name,opts,rels){return(name.substr(-4)===\".bin\"?parse_ws_bin:parse_ws_xml)(data,opts,rels)}function parse_sty(data,name,opts){return(name.substr(-4)===\".bin\"?parse_sty_bin:parse_sty_xml)(data,opts)}function parse_theme(data,name,opts){return parse_theme_xml(data,opts)}function parse_sst(data,name,opts){return(name.substr(-4)===\".bin\"?parse_sst_bin:parse_sst_xml)(data,opts)}function parse_cmnt(data,name,opts){return(name.substr(-4)===\".bin\"?parse_comments_bin:parse_comments_xml)(data,opts)}function parse_cc(data,name,opts){return(name.substr(-4)===\".bin\"?parse_cc_bin:parse_cc_xml)(data,opts)}function write_wb(wb,name,opts){return(name.substr(-4)===\".bin\"?write_wb_bin:write_wb_xml)(wb,opts)}function write_ws(data,name,opts,wb){return(name.substr(-4)===\".bin\"?write_ws_bin:write_ws_xml)(data,opts,wb)\n}function write_sty(data,name,opts){return(name.substr(-4)===\".bin\"?write_sty_bin:write_sty_xml)(data,opts)}function write_sst(data,name,opts){return(name.substr(-4)===\".bin\"?write_sst_bin:write_sst_xml)(data,opts)}var attregexg2=/([\\w:]+)=((?:\")([^\"]*)(?:\")|(?:')([^']*)(?:'))/g;var attregex2=/([\\w:]+)=((?:\")(?:[^\"]*)(?:\")|(?:')(?:[^']*)(?:'))/;var _chr=function(c){return String.fromCharCode(c)};function xlml_parsexmltag(tag,skip_root){var words=tag.split(/\\s+/);var z=[];if(!skip_root)z[0]=words[0];if(words.length===1)return z;var m=tag.match(attregexg2),y,j,w,i;if(m)for(i=0;i!=m.length;++i){y=m[i].match(attregex2);if((j=y[1].indexOf(\":\"))===-1)z[y[1]]=y[2].substr(1,y[2].length-2);else{if(y[1].substr(0,6)===\"xmlns:\")w=\"xmlns\"+y[1].substr(6);else w=y[1].substr(j+1);z[w]=y[2].substr(1,y[2].length-2)}}return z}function xlml_parsexmltagobj(tag){var words=tag.split(/\\s+/);var z={};if(words.length===1)return z;var m=tag.match(attregexg2),y,j,w,i;if(m)for(i=0;i!=m.length;++i){y=m[i].match(attregex2);if((j=y[1].indexOf(\":\"))===-1)z[y[1]]=y[2].substr(1,y[2].length-2);else{if(y[1].substr(0,6)===\"xmlns:\")w=\"xmlns\"+y[1].substr(6);else w=y[1].substr(j+1);z[w]=y[2].substr(1,y[2].length-2)}}return z}function xlml_format(format,value){var fmt=XLMLFormatMap[format]||unescapexml(format);if(fmt===\"General\")return SSF._general(value);return SSF.format(fmt,value)}function xlml_set_custprop(Custprops,Rn,cp,val){switch((cp[0].match(/dt:dt=\"([\\w.]+)\"/)||[\"\",\"\"])[1]){case\"boolean\":val=parsexmlbool(val);break;case\"i2\":case\"int\":val=parseInt(val,10);break;case\"r4\":case\"float\":val=parseFloat(val);break;case\"date\":case\"dateTime.tz\":val=new Date(val);break;case\"i8\":case\"string\":case\"fixed\":case\"uuid\":case\"bin.base64\":break;default:throw\"bad custprop:\"+cp[0]}Custprops[unescapexml(Rn[3])]=val}function safe_format_xlml(cell,nf,o){try{if(cell.t===\"e\"){cell.w=cell.w||BErr[cell.v]}else if(nf===\"General\"){if(cell.t===\"n\"){if((cell.v|0)===cell.v)cell.w=SSF._general_int(cell.v);else cell.w=SSF._general_num(cell.v)}else cell.w=SSF._general(cell.v)}else cell.w=xlml_format(nf||\"General\",cell.v);if(o.cellNF)cell.z=XLMLFormatMap[nf]||nf||\"General\"}catch(e){if(o.WTF)throw e}}function process_style_xlml(styles,stag,opts){if(opts.cellStyles){if(stag.Interior){var I=stag.Interior;if(I.Pattern)I.patternType=XLMLPatternTypeMap[I.Pattern]||I.Pattern}}styles[stag.ID]=stag}function parse_xlml_data(xml,ss,data,cell,base,styles,csty,row,o){var nf=\"General\",sid=cell.StyleID,S={};o=o||{};var interiors=[];if(sid===undefined&&row)sid=row.StyleID;if(sid===undefined&&csty)sid=csty.StyleID;while(styles[sid]!==undefined){if(styles[sid].nf)nf=styles[sid].nf;if(styles[sid].Interior)interiors.push(styles[sid].Interior);if(!styles[sid].Parent)break;sid=styles[sid].Parent}switch(data.Type){case\"Boolean\":cell.t=\"b\";cell.v=parsexmlbool(xml);break;case\"String\":cell.t=\"s\";cell.r=xlml_fixstr(unescapexml(xml));cell.v=xml.indexOf(\"<\")>-1?ss:cell.r;break;case\"DateTime\":cell.v=(Date.parse(xml)-new Date(Date.UTC(1899,11,30)))/(24*60*60*1e3);if(cell.v!==cell.v)cell.v=unescapexml(xml);else if(cell.v>=1&&cell.v<60)cell.v=cell.v-1;if(!nf||nf==\"General\")nf=\"yyyy-mm-dd\";case\"Number\":if(cell.v===undefined)cell.v=+xml;if(!cell.t)cell.t=\"n\";break;case\"Error\":cell.t=\"e\";cell.v=RBErr[xml];cell.w=xml;break;default:cell.t=\"s\";cell.v=xlml_fixstr(ss);break}safe_format_xlml(cell,nf,o);if(o.cellFormula!=null&&cell.Formula){cell.f=rc_to_a1(unescapexml(cell.Formula),base);cell.Formula=undefined}if(o.cellStyles){interiors.forEach(function(x){if(!S.patternType&&x.patternType)S.patternType=x.patternType});cell.s=S}cell.ixfe=cell.StyleID!==undefined?cell.StyleID:\"Default\"}function xlml_clean_comment(comment){comment.t=comment.v;comment.v=comment.w=comment.ixfe=undefined}function xlml_normalize(d){if(has_buf&&Buffer.isBuffer(d))return d.toString(\"utf8\");if(typeof d===\"string\")return d;throw\"badf\"}var xlmlregex=/<(\\/?)([a-z0-9]*:|)(\\w+)[^>]*>/gm;function parse_xlml_xml(d,opts){var str=xlml_normalize(d);var Rn;var state=[],tmp;var sheets={},sheetnames=[],cursheet={},sheetname=\"\";var table={},cell={},row={},dtag,didx;var c=0,r=0;var refguess={s:{r:1e6,c:1e6},e:{r:0,c:0}};var styles={},stag={};var ss=\"\",fidx=0;var mergecells=[];var Props={},Custprops={},pidx=0,cp={};var comments=[],comment={};var cstys=[],csty;xlmlregex.lastIndex=0;while(Rn=xlmlregex.exec(str))switch(Rn[3]){case\"Data\":if(state[state.length-1][1])break;if(Rn[1]===\"/\")parse_xlml_data(str.slice(didx,Rn.index),ss,dtag,state[state.length-1][0]==\"Comment\"?comment:cell,{c:c,r:r},styles,cstys[c],row,opts);else{ss=\"\";dtag=xlml_parsexmltag(Rn[0]);didx=Rn.index+Rn[0].length}break;case\"Cell\":if(Rn[1]===\"/\"){if(comments.length>0)cell.c=comments;if((!opts.sheetRows||opts.sheetRows>r)&&cell.v!==undefined)cursheet[encode_col(c)+encode_row(r)]=cell;if(cell.HRef){cell.l={Target:cell.HRef,tooltip:cell.HRefScreenTip};cell.HRef=cell.HRefScreenTip=undefined}if(cell.MergeAcross||cell.MergeDown){var cc=c+(parseInt(cell.MergeAcross,10)|0);var rr=r+(parseInt(cell.MergeDown,10)|0);mergecells.push({s:{c:c,r:r},e:{c:cc,r:rr}})}++c;if(cell.MergeAcross)c+=+cell.MergeAcross}else{cell=xlml_parsexmltagobj(Rn[0]);if(cell.Index)c=+cell.Index-1;if(c<refguess.s.c)refguess.s.c=c;if(c>refguess.e.c)refguess.e.c=c;if(Rn[0].substr(-2)===\"/>\")++c;comments=[]}break;case\"Row\":if(Rn[1]===\"/\"||Rn[0].substr(-2)===\"/>\"){if(r<refguess.s.r)refguess.s.r=r;if(r>refguess.e.r)refguess.e.r=r;if(Rn[0].substr(-2)===\"/>\"){row=xlml_parsexmltag(Rn[0]);if(row.Index)r=+row.Index-1}c=0;++r}else{row=xlml_parsexmltag(Rn[0]);if(row.Index)r=+row.Index-1}break;case\"Worksheet\":if(Rn[1]===\"/\"){if((tmp=state.pop())[0]!==Rn[3])throw\"Bad state: \"+tmp;sheetnames.push(sheetname);if(refguess.s.r<=refguess.e.r&&refguess.s.c<=refguess.e.c)cursheet[\"!ref\"]=encode_range(refguess);if(mergecells.length)cursheet[\"!merges\"]=mergecells;sheets[sheetname]=cursheet}else{refguess={s:{r:1e6,c:1e6},e:{r:0,c:0}};r=c=0;state.push([Rn[3],false]);tmp=xlml_parsexmltag(Rn[0]);sheetname=tmp.Name;cursheet={};mergecells=[]}break;case\"Table\":if(Rn[1]===\"/\"){if((tmp=state.pop())[0]!==Rn[3])throw\"Bad state: \"+tmp}else if(Rn[0].slice(-2)==\"/>\")break;else{table=xlml_parsexmltag(Rn[0]);state.push([Rn[3],false]);cstys=[]}break;case\"Style\":if(Rn[1]===\"/\")process_style_xlml(styles,stag,opts);else stag=xlml_parsexmltag(Rn[0]);break;case\"NumberFormat\":stag.nf=xlml_parsexmltag(Rn[0]).Format||\"General\";break;case\"Column\":if(state[state.length-1][0]!==\"Table\")break;csty=xlml_parsexmltag(Rn[0]);cstys[csty.Index-1||cstys.length]=csty;for(var i=0;i<+csty.Span;++i)cstys[cstys.length]=csty;break;case\"NamedRange\":break;case\"NamedCell\":break;case\"B\":break;case\"I\":break;case\"U\":break;case\"S\":break;case\"Sub\":break;case\"Sup\":break;case\"Span\":break;case\"Border\":break;case\"Alignment\":break;case\"Borders\":break;case\"Font\":if(Rn[0].substr(-2)===\"/>\")break;else if(Rn[1]===\"/\")ss+=str.slice(fidx,Rn.index);else fidx=Rn.index+Rn[0].length;break;case\"Interior\":if(!opts.cellStyles)break;stag.Interior=xlml_parsexmltag(Rn[0]);break;case\"Protection\":break;case\"Author\":case\"Title\":case\"Description\":case\"Created\":case\"Keywords\":case\"Subject\":case\"Category\":case\"Company\":case\"LastAuthor\":case\"LastSaved\":case\"LastPrinted\":case\"Version\":case\"Revision\":case\"TotalTime\":case\"HyperlinkBase\":case\"Manager\":if(Rn[0].substr(-2)===\"/>\")break;else if(Rn[1]===\"/\")xlml_set_prop(Props,Rn[3],str.slice(pidx,Rn.index));else pidx=Rn.index+Rn[0].length;break;case\"Paragraphs\":break;case\"Styles\":case\"Workbook\":if(Rn[1]===\"/\"){if((tmp=state.pop())[0]!==Rn[3])throw\"Bad state: \"+tmp}else state.push([Rn[3],false]);break;case\"Comment\":if(Rn[1]===\"/\"){if((tmp=state.pop())[0]!==Rn[3])throw\"Bad state: \"+tmp;xlml_clean_comment(comment);comments.push(comment)}else{state.push([Rn[3],false]);tmp=xlml_parsexmltag(Rn[0]);comment={a:tmp.Author}}break;case\"Name\":break;case\"ComponentOptions\":case\"DocumentProperties\":case\"CustomDocumentProperties\":case\"OfficeDocumentSettings\":case\"PivotTable\":case\"PivotCache\":case\"Names\":case\"MapInfo\":case\"PageBreaks\":case\"QueryTable\":case\"DataValidation\":case\"AutoFilter\":case\"Sorting\":case\"Schema\":case\"data\":case\"ConditionalFormatting\":case\"SmartTagType\":case\"SmartTags\":case\"ExcelWorkbook\":case\"WorkbookOptions\":case\"WorksheetOptions\":if(Rn[1]===\"/\"){if((tmp=state.pop())[0]!==Rn[3])throw\"Bad state: \"+tmp}else if(Rn[0].charAt(Rn[0].length-2)!==\"/\")state.push([Rn[3],true]);break;default:var seen=true;switch(state[state.length-1][0]){case\"OfficeDocumentSettings\":switch(Rn[3]){case\"AllowPNG\":break;case\"RemovePersonalInformation\":break;case\"DownloadComponents\":break;case\"LocationOfComponents\":break;case\"Colors\":break;case\"Color\":break;case\"Index\":break;case\"RGB\":break;case\"PixelsPerInch\":break;case\"TargetScreenSize\":break;case\"ReadOnlyRecommended\":break;default:seen=false}break;case\"ComponentOptions\":switch(Rn[3]){case\"Toolbar\":break;case\"HideOfficeLogo\":break;case\"SpreadsheetAutoFit\":break;case\"Label\":break;case\"Caption\":break;case\"MaxHeight\":break;case\"MaxWidth\":break;case\"NextSheetNumber\":break;default:seen=false}break;case\"ExcelWorkbook\":switch(Rn[3]){case\"WindowHeight\":break;case\"WindowWidth\":break;case\"WindowTopX\":break;case\"WindowTopY\":break;case\"TabRatio\":break;case\"ProtectStructure\":break;case\"ProtectWindows\":break;case\"ActiveSheet\":break;case\"DisplayInkNotes\":break;case\"FirstVisibleSheet\":break;case\"SupBook\":break;case\"SheetName\":break;case\"SheetIndex\":break;case\"SheetIndexFirst\":break;case\"SheetIndexLast\":break;case\"Dll\":break;case\"AcceptLabelsInFormulas\":break;case\"DoNotSaveLinkValues\":break;case\"Date1904\":break;case\"Iteration\":break;case\"MaxIterations\":break;case\"MaxChange\":break;case\"Path\":break;case\"Xct\":break;case\"Count\":break;case\"SelectedSheets\":break;case\"Calculation\":break;case\"Uncalced\":break;case\"StartupPrompt\":break;case\"Crn\":break;case\"ExternName\":break;case\"Formula\":break;case\"ColFirst\":break;case\"ColLast\":break;case\"WantAdvise\":break;case\"Boolean\":break;case\"Error\":break;case\"Text\":break;case\"OLE\":break;case\"NoAutoRecover\":break;case\"PublishObjects\":break;case\"DoNotCalculateBeforeSave\":break;case\"Number\":break;case\"RefModeR1C1\":break;case\"EmbedSaveSmartTags\":break;default:seen=false}break;case\"WorkbookOptions\":switch(Rn[3]){case\"OWCVersion\":break;case\"Height\":break;case\"Width\":break;default:seen=false}break;case\"WorksheetOptions\":switch(Rn[3]){case\"Unsynced\":break;case\"Visible\":break;case\"Print\":break;case\"Panes\":break;case\"Scale\":break;case\"Pane\":break;case\"Number\":break;case\"Layout\":break;case\"Header\":break;case\"Footer\":break;case\"PageSetup\":break;case\"PageMargins\":break;case\"Selected\":break;case\"ProtectObjects\":break;case\"EnableSelection\":break;case\"ProtectScenarios\":break;case\"ValidPrinterInfo\":break;case\"HorizontalResolution\":break;case\"VerticalResolution\":break;case\"NumberofCopies\":break;case\"ActiveRow\":break;case\"ActiveCol\":break;case\"ActivePane\":break;case\"TopRowVisible\":break;case\"TopRowBottomPane\":break;case\"LeftColumnVisible\":break;case\"LeftColumnRightPane\":break;case\"FitToPage\":break;case\"RangeSelection\":break;case\"PaperSizeIndex\":break;case\"PageLayoutZoom\":break;case\"PageBreakZoom\":break;case\"FilterOn\":break;case\"DoNotDisplayGridlines\":break;case\"SplitHorizontal\":break;case\"SplitVertical\":break;case\"FreezePanes\":break;case\"FrozenNoSplit\":break;case\"FitWidth\":break;case\"FitHeight\":break;case\"CommentsLayout\":break;case\"Zoom\":break;case\"LeftToRight\":break;case\"Gridlines\":break;case\"AllowSort\":break;case\"AllowFilter\":break;case\"AllowInsertRows\":break;case\"AllowDeleteRows\":break;case\"AllowInsertCols\":break;case\"AllowDeleteCols\":break;case\"AllowInsertHyperlinks\":break;case\"AllowFormatCells\":break;case\"AllowSizeCols\":break;case\"AllowSizeRows\":break;case\"NoSummaryRowsBelowDetail\":break;case\"TabColorIndex\":break;case\"DoNotDisplayHeadings\":break;case\"ShowPageLayoutZoom\":break;case\"NoSummaryColumnsRightDetail\":break;case\"BlackAndWhite\":break;case\"DoNotDisplayZeros\":break;case\"DisplayPageBreak\":break;case\"RowColHeadings\":break;case\"DoNotDisplayOutline\":break;case\"NoOrientation\":break;case\"AllowUsePivotTables\":break;case\"ZeroHeight\":break;case\"ViewableRange\":break;case\"Selection\":break;case\"ProtectContents\":break;default:seen=false}break;case\"PivotTable\":case\"PivotCache\":switch(Rn[3]){case\"ImmediateItemsOnDrop\":break;case\"ShowPageMultipleItemLabel\":break;case\"CompactRowIndent\":break;case\"Location\":break;case\"PivotField\":break;case\"Orientation\":break;case\"LayoutForm\":break;case\"LayoutSubtotalLocation\":break;case\"LayoutCompactRow\":break;case\"Position\":break;case\"PivotItem\":break;case\"DataType\":break;case\"DataField\":break;case\"SourceName\":break;case\"ParentField\":break;case\"PTLineItems\":break;case\"PTLineItem\":break;case\"CountOfSameItems\":break;case\"Item\":break;case\"ItemType\":break;case\"PTSource\":break;case\"CacheIndex\":break;case\"ConsolidationReference\":break;case\"FileName\":break;case\"Reference\":break;case\"NoColumnGrand\":break;case\"NoRowGrand\":break;case\"BlankLineAfterItems\":break;case\"Hidden\":break;case\"Subtotal\":break;case\"BaseField\":break;case\"MapChildItems\":break;case\"Function\":break;case\"RefreshOnFileOpen\":break;case\"PrintSetTitles\":break;case\"MergeLabels\":break;case\"DefaultVersion\":break;case\"RefreshName\":break;case\"RefreshDate\":break;case\"RefreshDateCopy\":break;case\"VersionLastRefresh\":break;case\"VersionLastUpdate\":break;case\"VersionUpdateableMin\":break;case\"VersionRefreshableMin\":break;case\"Calculation\":break;default:seen=false}break;case\"PageBreaks\":switch(Rn[3]){case\"ColBreaks\":break;case\"ColBreak\":break;case\"RowBreaks\":break;case\"RowBreak\":break;case\"ColStart\":break;case\"ColEnd\":break;case\"RowEnd\":break;default:seen=false}break;case\"AutoFilter\":switch(Rn[3]){case\"AutoFilterColumn\":break;case\"AutoFilterCondition\":break;case\"AutoFilterAnd\":break;case\"AutoFilterOr\":break;default:seen=false}break;case\"QueryTable\":switch(Rn[3]){case\"Id\":break;case\"AutoFormatFont\":break;case\"AutoFormatPattern\":break;case\"QuerySource\":break;case\"QueryType\":break;case\"EnableRedirections\":break;case\"RefreshedInXl9\":break;case\"URLString\":break;case\"HTMLTables\":break;case\"Connection\":break;case\"CommandText\":break;case\"RefreshInfo\":break;case\"NoTitles\":break;case\"NextId\":break;case\"ColumnInfo\":break;case\"OverwriteCells\":break;case\"DoNotPromptForFile\":break;case\"TextWizardSettings\":break;case\"Source\":break;case\"Number\":break;case\"Decimal\":break;case\"ThousandSeparator\":break;case\"TrailingMinusNumbers\":break;case\"FormatSettings\":break;case\"FieldType\":break;case\"Delimiters\":break;case\"Tab\":break;case\"Comma\":break;case\"AutoFormatName\":break;case\"VersionLastEdit\":break;case\"VersionLastRefresh\":break;default:seen=false}break;case\"Sorting\":case\"ConditionalFormatting\":case\"DataValidation\":switch(Rn[3]){case\"Range\":break;case\"Type\":break;case\"Min\":break;case\"Max\":break;case\"Sort\":break;case\"Descending\":break;case\"Order\":break;case\"CaseSensitive\":break;case\"Value\":break;case\"ErrorStyle\":break;case\"ErrorMessage\":break;case\"ErrorTitle\":break;case\"CellRangeList\":break;case\"InputMessage\":break;case\"InputTitle\":break;case\"ComboHide\":break;case\"InputHide\":break;case\"Condition\":break;case\"Qualifier\":break;case\"UseBlank\":break;case\"Value1\":break;case\"Value2\":break;case\"Format\":break;default:seen=false}break;case\"MapInfo\":case\"Schema\":case\"data\":switch(Rn[3]){case\"Map\":break;case\"Entry\":break;case\"Range\":break;case\"XPath\":break;case\"Field\":break;case\"XSDType\":break;case\"FilterOn\":break;case\"Aggregate\":break;case\"ElementType\":break;case\"AttributeType\":break;case\"schema\":case\"element\":case\"complexType\":case\"datatype\":case\"all\":case\"attribute\":case\"extends\":break;case\"row\":break;default:seen=false}break;case\"SmartTags\":break;default:seen=false;break}if(seen)break;if(!state[state.length-1][1])throw\"Unrecognized tag: \"+Rn[3]+\"|\"+state.join(\"|\");if(state[state.length-1][0]===\"CustomDocumentProperties\"){if(Rn[0].substr(-2)===\"/>\")break;else if(Rn[1]===\"/\")xlml_set_custprop(Custprops,Rn,cp,str.slice(pidx,Rn.index));else{cp=Rn;pidx=Rn.index+Rn[0].length}break}if(opts.WTF)throw\"Unrecognized tag: \"+Rn[3]+\"|\"+state.join(\"|\")}var out={};if(!opts.bookSheets&&!opts.bookProps)out.Sheets=sheets;out.SheetNames=sheetnames;out.SSF=SSF.get_table();out.Props=Props;out.Custprops=Custprops;return out}function parse_xlml(data,opts){fix_read_opts(opts=opts||{});switch(opts.type||\"base64\"){case\"base64\":return parse_xlml_xml(Base64.decode(data),opts);case\"binary\":case\"buffer\":case\"file\":return parse_xlml_xml(data,opts);case\"array\":return parse_xlml_xml(data.map(_chr).join(\"\"),opts)}}function write_xlml(wb,opts){}function parse_compobj(obj){var v={};var o=obj.content;var l=28,m;m=__lpstr(o,l);l+=4+__readUInt32LE(o,l);v.UserType=m;m=__readUInt32LE(o,l);l+=4;switch(m){case 0:break;case 4294967295:case 4294967294:l+=4;break;default:if(m>400)throw new Error(\"Unsupported Clipboard: \"+m.toString(16));l+=m}m=__lpstr(o,l);l+=m.length===0?0:5+m.length;v.Reserved1=m;if((m=__readUInt32LE(o,l))!==1907550708)return v;throw\"Unsupported Unicode Extension\"}function slurp(R,blob,length,opts){var l=length;var bufs=[];var d=blob.slice(blob.l,blob.l+l);if(opts&&opts.enc&&opts.enc.insitu_decrypt)switch(R.n){case\"BOF\":case\"FilePass\":case\"FileLock\":case\"InterfaceHdr\":case\"RRDInfo\":case\"RRDHead\":case\"UsrExcl\":break;default:if(d.length===0)break;opts.enc.insitu_decrypt(d)}bufs.push(d);blob.l+=l;var next=XLSRecordEnum[__readUInt16LE(blob,blob.l)];while(next!=null&&next.n===\"Continue\"){l=__readUInt16LE(blob,blob.l+2);bufs.push(blob.slice(blob.l+4,blob.l+4+l));blob.l+=4+l;next=XLSRecordEnum[__readUInt16LE(blob,blob.l)]}var b=bconcat(bufs);prep_blob(b,0);var ll=0;b.lens=[];for(var j=0;j<bufs.length;++j){b.lens.push(ll);ll+=bufs[j].length}return R.f(b,b.length,opts)}function safe_format_xf(p,opts,date1904){if(!p.XF)return;try{var fmtid=p.XF.ifmt||0;if(p.t===\"e\"){p.w=p.w||BErr[p.v]}else if(fmtid===0){if(p.t===\"n\"){if((p.v|0)===p.v)p.w=SSF._general_int(p.v);else p.w=SSF._general_num(p.v)}else p.w=SSF._general(p.v)}else p.w=SSF.format(fmtid,p.v,{date1904:date1904||false});if(opts.cellNF)p.z=SSF._table[fmtid]}catch(e){if(opts.WTF)throw e}}function make_cell(val,ixfe,t){return{v:val,ixfe:ixfe,t:t}}function parse_workbook(blob,options){var wb={opts:{}};var Sheets={};var out={};var Directory={};var found_sheet=false;var range={};var last_formula=null;var sst=[];var cur_sheet=\"\";var Preamble={};var lastcell,last_cell,cc,cmnt,rng,rngC,rngR;var shared_formulae={};var array_formulae=[];var temp_val;var country;var cell_valid=true;var XFs=[];var palette=[];var get_rgb=function getrgb(icv){if(icv<8)return XLSIcv[icv];if(icv<64)return palette[icv-8]||XLSIcv[icv];return XLSIcv[icv]};var process_cell_style=function pcs(cell,line){var xfd=line.XF.data;if(!xfd||!xfd.patternType)return;line.s={};line.s.patternType=xfd.patternType;var t;if(t=rgb2Hex(get_rgb(xfd.icvFore))){line.s.fgColor={rgb:t}}if(t=rgb2Hex(get_rgb(xfd.icvBack))){line.s.bgColor={rgb:t}}};var addcell=function addcell(cell,line,options){if(!cell_valid)return;if(options.cellStyles&&line.XF&&line.XF.data)process_cell_style(cell,line);lastcell=cell;last_cell=encode_cell(cell);if(range.s){if(cell.r<range.s.r)range.s.r=cell.r;if(cell.c<range.s.c)range.s.c=cell.c}if(range.e){if(cell.r+1>range.e.r)range.e.r=cell.r+1;if(cell.c+1>range.e.c)range.e.c=cell.c+1}if(options.sheetRows&&lastcell.r>=options.sheetRows)cell_valid=false;else out[last_cell]=line};var opts={enc:false,sbcch:0,snames:[],sharedf:shared_formulae,arrayf:array_formulae,rrtabid:[],lastuser:\"\",biff:8,codepage:0,winlocked:0,wtf:false};if(options.password)opts.password=options.password;var mergecells=[];var objects=[];var supbooks=[[]];var sbc=0,sbci=0,sbcli=0;supbooks.SheetNames=opts.snames;supbooks.sharedf=opts.sharedf;supbooks.arrayf=opts.arrayf;var last_Rn=\"\";var file_depth=0;opts.codepage=1200;set_cp(1200);while(blob.l<blob.length-1){var s=blob.l;var RecordType=blob.read_shift(2);if(RecordType===0&&last_Rn===\"EOF\")break;var length=blob.l===blob.length?0:blob.read_shift(2),y;var R=XLSRecordEnum[RecordType];if(R&&R.f){if(options.bookSheets){if(last_Rn===\"BoundSheet8\"&&R.n!==\"BoundSheet8\")break}last_Rn=R.n;if(R.r===2||R.r==12){var rt=blob.read_shift(2);length-=2;if(!opts.enc&&rt!==RecordType)throw\"rt mismatch\";if(R.r==12){blob.l+=10;length-=10}}var val;if(R.n===\"EOF\")val=R.f(blob,length,opts);else val=slurp(R,blob,length,opts);var Rn=R.n;if(opts.biff===5||opts.biff===2)switch(Rn){case\"Lbl\":Rn=\"Label\";break}switch(Rn){case\"Date1904\":wb.opts.Date1904=val;break;case\"WriteProtect\":wb.opts.WriteProtect=true;break;case\"FilePass\":if(!opts.enc)blob.l=0;opts.enc=val;if(opts.WTF)console.error(val);if(!options.password)throw new Error(\"File is password-protected\");if(val.Type!==0)throw new Error(\"Encryption scheme unsupported\");if(!val.valid)throw new Error(\"Password is incorrect\");break;case\"WriteAccess\":opts.lastuser=val;break;case\"FileSharing\":break;case\"CodePage\":if(val===21010)val=1200;else if(val===32769)val=1252;opts.codepage=val;set_cp(val);break;case\"RRTabId\":opts.rrtabid=val;break;case\"WinProtect\":opts.winlocked=val;break;case\"Template\":break;case\"RefreshAll\":wb.opts.RefreshAll=val;break;case\"BookBool\":break;case\"UsesELFs\":break;case\"MTRSettings\":{if(val[0]&&val[1])throw\"Unsupported threads: \"+val}break;case\"CalcCount\":wb.opts.CalcCount=val;break;case\"CalcDelta\":wb.opts.CalcDelta=val;break;case\"CalcIter\":wb.opts.CalcIter=val;break;case\"CalcMode\":wb.opts.CalcMode=val;break;case\"CalcPrecision\":wb.opts.CalcPrecision=val;break;case\"CalcSaveRecalc\":wb.opts.CalcSaveRecalc=val;break;case\"CalcRefMode\":opts.CalcRefMode=val;break;case\"Uncalced\":break;case\"ForceFullCalculation\":wb.opts.FullCalc=val;break;case\"WsBool\":break;case\"XF\":XFs.push(val);break;case\"ExtSST\":break;case\"BookExt\":break;case\"RichTextStream\":break;case\"BkHim\":break;case\"SupBook\":supbooks[++sbc]=[val];sbci=0;break;case\"ExternName\":supbooks[sbc][++sbci]=val;break;case\"Index\":break;case\"Lbl\":supbooks[0][++sbcli]=val;break;case\"ExternSheet\":supbooks[sbc]=supbooks[sbc].concat(val);sbci+=val.length;break;case\"Protect\":out[\"!protect\"]=val;break;case\"Password\":if(val!==0&&opts.WTF)console.error(\"Password verifier: \"+val);break;case\"Prot4Rev\":case\"Prot4RevPass\":break;case\"BoundSheet8\":{Directory[val.pos]=val;opts.snames.push(val.name)}break;case\"EOF\":{if(--file_depth)break;if(range.e){out[\"!range\"]=range;if(range.e.r>0&&range.e.c>0){range.e.r--;range.e.c--;out[\"!ref\"]=encode_range(range);range.e.r++;range.e.c++}if(mergecells.length>0)out[\"!merges\"]=mergecells;if(objects.length>0)out[\"!objects\"]=objects}if(cur_sheet===\"\")Preamble=out;else Sheets[cur_sheet]=out;out={}}break;case\"BOF\":{if(opts.biff!==8);else if(val.BIFFVer===1280)opts.biff=5;else if(val.BIFFVer===2)opts.biff=2;else if(val.BIFFVer===7)opts.biff=2;if(file_depth++)break;cell_valid=true;out={};if(opts.biff===2){if(cur_sheet===\"\")cur_sheet=\"Sheet1\";range={s:{r:0,c:0},e:{r:0,c:0}}}else cur_sheet=(Directory[s]||{name:\"\"}).name;mergecells=[];objects=[]}break;case\"Number\":case\"BIFF2NUM\":{temp_val={ixfe:val.ixfe,XF:XFs[val.ixfe],v:val.val,t:\"n\"};if(temp_val.XF)safe_format_xf(temp_val,options,wb.opts.Date1904);addcell({c:val.c,r:val.r},temp_val,options)}break;case\"BoolErr\":{temp_val={ixfe:val.ixfe,XF:XFs[val.ixfe],v:val.val,t:val.t};if(temp_val.XF)safe_format_xf(temp_val,options,wb.opts.Date1904);addcell({c:val.c,r:val.r},temp_val,options)}break;case\"RK\":{temp_val={ixfe:val.ixfe,XF:XFs[val.ixfe],v:val.rknum,t:\"n\"};if(temp_val.XF)safe_format_xf(temp_val,options,wb.opts.Date1904);addcell({c:val.c,r:val.r},temp_val,options)}break;case\"MulRk\":{for(var j=val.c;j<=val.C;++j){var ixfe=val.rkrec[j-val.c][0];temp_val={ixfe:ixfe,XF:XFs[ixfe],v:val.rkrec[j-val.c][1],t:\"n\"};if(temp_val.XF)safe_format_xf(temp_val,options,wb.opts.Date1904);addcell({c:j,r:val.r},temp_val,options)}}break;case\"Formula\":{switch(val.val){case\"String\":last_formula=val;break;case\"Array Formula\":throw\"Array Formula unsupported\";default:temp_val={v:val.val,ixfe:val.cell.ixfe,t:val.tt};temp_val.XF=XFs[temp_val.ixfe];if(options.cellFormula)temp_val.f=\"=\"+stringify_formula(val.formula,range,val.cell,supbooks,opts);if(temp_val.XF)safe_format_xf(temp_val,options,wb.opts.Date1904);addcell(val.cell,temp_val,options);last_formula=val}}break;case\"String\":{if(last_formula){last_formula.val=val;temp_val={v:last_formula.val,ixfe:last_formula.cell.ixfe,t:\"s\"};temp_val.XF=XFs[temp_val.ixfe];if(options.cellFormula)temp_val.f=\"=\"+stringify_formula(last_formula.formula,range,last_formula.cell,supbooks,opts);if(temp_val.XF)safe_format_xf(temp_val,options,wb.opts.Date1904);addcell(last_formula.cell,temp_val,options);last_formula=null}}break;case\"Array\":{array_formulae.push(val)}break;case\"ShrFmla\":{if(!cell_valid)break;shared_formulae[encode_cell(last_formula.cell)]=val[0]}break;case\"LabelSst\":temp_val=make_cell(sst[val.isst].t,val.ixfe,\"s\");temp_val.XF=XFs[temp_val.ixfe];if(temp_val.XF)safe_format_xf(temp_val,options,wb.opts.Date1904);addcell({c:val.c,r:val.r},temp_val,options);break;case\"Label\":case\"BIFF2STR\":temp_val=make_cell(val.val,val.ixfe,\"s\");temp_val.XF=XFs[temp_val.ixfe];if(temp_val.XF)safe_format_xf(temp_val,options,wb.opts.Date1904);addcell({c:val.c,r:val.r},temp_val,options);break;case\"Dimensions\":{if(file_depth===1)range=val}break;case\"SST\":{sst=val}break;case\"Format\":{SSF.load(val[1],val[0])}break;case\"MergeCells\":mergecells=mergecells.concat(val);break;case\"Obj\":objects[val.cmo[0]]=opts.lastobj=val;break;case\"TxO\":opts.lastobj.TxO=val;break;case\"HLink\":{for(rngR=val[0].s.r;rngR<=val[0].e.r;++rngR)for(rngC=val[0].s.c;rngC<=val[0].e.c;++rngC)if(out[encode_cell({c:rngC,r:rngR})])out[encode_cell({c:rngC,r:rngR})].l=val[1]}break;case\"HLinkTooltip\":{for(rngR=val[0].s.r;rngR<=val[0].e.r;++rngR)for(rngC=val[0].s.c;rngC<=val[0].e.c;++rngC)if(out[encode_cell({c:rngC,r:rngR})])out[encode_cell({c:rngC,r:rngR})].l.tooltip=val[1]}break;case\"Note\":{if(opts.biff<=5&&opts.biff>=2)break;cc=out[encode_cell(val[0])];var noteobj=objects[val[2]];if(!cc)break;if(!cc.c)cc.c=[];cmnt={a:val[1],t:noteobj.TxO.t};cc.c.push(cmnt)}break;default:switch(R.n){case\"ClrtClient\":break;case\"XFExt\":update_xfext(XFs[val.ixfe],val.ext);break;case\"NameCmt\":break;case\"Header\":break;case\"Footer\":break;case\"HCenter\":break;case\"VCenter\":break;case\"Pls\":break;case\"Setup\":break;case\"DefColWidth\":break;case\"GCW\":break;case\"LHRecord\":break;case\"ColInfo\":break;case\"Row\":break;case\"DBCell\":break;case\"MulBlank\":break;case\"EntExU2\":break;case\"SxView\":break;case\"Sxvd\":break;case\"SXVI\":break;case\"SXVDEx\":break;case\"SxIvd\":break;case\"SXDI\":break;case\"SXLI\":break;case\"SXEx\":break;case\"QsiSXTag\":break;case\"Selection\":break;case\"Feat\":break;case\"FeatHdr\":case\"FeatHdr11\":break;case\"Feature11\":case\"Feature12\":case\"List12\":break;case\"Blank\":break;case\"Country\":country=val;break;case\"RecalcId\":break;case\"DefaultRowHeight\":case\"DxGCol\":break;case\"Fbi\":case\"Fbi2\":case\"GelFrame\":break;case\"Font\":break;case\"XFCRC\":break;case\"Style\":break;case\"StyleExt\":break;case\"Palette\":palette=val;break;case\"Theme\":break;case\"ScenarioProtect\":break;case\"ObjProtect\":break;case\"CondFmt12\":break;case\"Table\":break;case\"TableStyles\":break;case\"TableStyle\":break;case\"TableStyleElement\":break;case\"SXStreamID\":break;case\"SXVS\":break;case\"DConRef\":break;case\"SXAddl\":break;case\"DConBin\":break;case\"DConName\":break;case\"SXPI\":break;case\"SxFormat\":break;case\"SxSelect\":break;case\"SxRule\":break;case\"SxFilt\":break;case\"SxItm\":break;case\"SxDXF\":break;case\"ScenMan\":break;case\"DCon\":break;case\"CellWatch\":break;case\"PrintRowCol\":break;case\"PrintGrid\":break;case\"PrintSize\":break;case\"XCT\":break;case\"CRN\":break;case\"Scl\":{}break;case\"SheetExt\":{}break;case\"SheetExtOptional\":{}break;case\"ObNoMacros\":{}break;case\"ObProj\":{}break;case\"CodeName\":{}break;case\"GUIDTypeLib\":{}break;case\"WOpt\":break;case\"PhoneticInfo\":break;case\"OleObjectSize\":break;case\"DXF\":case\"DXFN\":case\"DXFN12\":case\"DXFN12List\":case\"DXFN12NoCB\":break;case\"Dv\":case\"DVal\":break;case\"BRAI\":case\"Series\":case\"SeriesText\":break;case\"DConn\":break;case\"DbOrParamQry\":break;case\"DBQueryExt\":break;case\"IFmtRecord\":break;case\"CondFmt\":case\"CF\":case\"CF12\":case\"CFEx\":break;case\"Excel9File\":break;case\"Units\":break;case\"InterfaceHdr\":case\"Mms\":case\"InterfaceEnd\":case\"DSF\":case\"BuiltInFnGroupCount\":case\"Window1\":case\"Window2\":case\"HideObj\":case\"GridSet\":case\"Guts\":case\"UserBView\":case\"UserSViewBegin\":case\"UserSViewEnd\":case\"Pane\":break;default:switch(R.n){case\"Dat\":case\"Begin\":case\"End\":case\"StartBlock\":case\"EndBlock\":case\"Frame\":case\"Area\":case\"Axis\":case\"AxisLine\":case\"Tick\":break;case\"AxesUsed\":case\"CrtLayout12\":case\"CrtLayout12A\":case\"CrtLink\":case\"CrtLine\":case\"CrtMlFrt\":case\"CrtMlFrtContinue\":break;case\"LineFormat\":case\"AreaFormat\":case\"Chart\":case\"Chart3d\":case\"Chart3DBarShape\":case\"ChartFormat\":case\"ChartFrtInfo\":break;case\"PlotArea\":case\"PlotGrowth\":break;case\"SeriesList\":case\"SerParent\":case\"SerAuxTrend\":break;case\"DataFormat\":case\"SerToCrt\":case\"FontX\":break;case\"CatSerRange\":case\"AxcExt\":case\"SerFmt\":break;case\"ShtProps\":break;case\"DefaultText\":case\"Text\":case\"CatLab\":break;case\"DataLabExtContents\":break;case\"Legend\":case\"LegendException\":break;case\"Pie\":case\"Scatter\":break;case\"PieFormat\":case\"MarkerFormat\":break;case\"StartObject\":case\"EndObject\":break;case\"AlRuns\":case\"ObjectLink\":break;case\"SIIndex\":break;case\"AttachedLabel\":case\"YMult\":break;case\"Line\":case\"Bar\":break;case\"Surf\":break;case\"AxisParent\":break;case\"Pos\":break;case\"ValueRange\":break;case\"SXViewEx9\":break;case\"SXViewLink\":break;case\"PivotChartBits\":break;case\"SBaseRef\":break;case\"TextPropsStream\":break;case\"LnExt\":break;case\"MkrExt\":break;case\"CrtCoopt\":break;case\"Qsi\":case\"Qsif\":case\"Qsir\":case\"QsiSXTag\":break;case\"TxtQry\":break;case\"FilterMode\":break;case\"AutoFilter\":case\"AutoFilterInfo\":break;case\"AutoFilter12\":break;case\"DropDownObjIds\":break;case\"Sort\":break;case\"SortData\":break;case\"ShapePropsStream\":break;case\"MsoDrawing\":case\"MsoDrawingGroup\":case\"MsoDrawingSelection\":break;case\"ImData\":break;case\"WebPub\":case\"AutoWebPub\":case\"RightMargin\":case\"LeftMargin\":case\"TopMargin\":case\"BottomMargin\":case\"HeaderFooter\":case\"HFPicture\":case\"PLV\":case\"HorizontalPageBreaks\":case\"VerticalPageBreaks\":case\"Backup\":case\"CompressPictures\":case\"Compat12\":break;case\"Continue\":case\"ContinueFrt12\":break;case\"FrtFontList\":case\"FrtWrapper\":break;case\"ExternCount\":break;case\"RString\":break;case\"TabIdConf\":case\"Radar\":case\"RadarArea\":case\"DropBar\":case\"Intl\":case\"CoordList\":case\"SerAuxErrBar\":break;default:switch(R.n){case\"SCENARIO\":case\"DConBin\":case\"PicF\":case\"DataLabExt\":case\"Lel\":case\"BopPop\":case\"BopPopCustom\":case\"RealTimeData\":case\"Name\":break;default:if(options.WTF)throw\"Unrecognized Record \"+R.n}}}}}else blob.l+=length}var sheetnamesraw=opts.biff===2?[\"Sheet1\"]:Object.keys(Directory).sort(function(a,b){return Number(a)-Number(b)}).map(function(x){return Directory[x].name});var sheetnames=sheetnamesraw.slice();wb.Directory=sheetnamesraw;wb.SheetNames=sheetnamesraw;if(!options.bookSheets)wb.Sheets=Sheets;wb.Preamble=Preamble;wb.Strings=sst;wb.SSF=SSF.get_table();if(opts.enc)wb.Encryption=opts.enc;wb.Metadata={};if(country!==undefined)wb.Metadata.Country=country;return wb}function parse_xlscfb(cfb,options){if(!options)options={};fix_read_opts(options);reset_cp();var CompObj,Summary,Workbook;if(cfb.find){CompObj=cfb.find(\"!CompObj\");Summary=cfb.find(\"!SummaryInformation\");Workbook=cfb.find(\"/Workbook\")}else{prep_blob(cfb,0);Workbook={content:cfb}}if(!Workbook)Workbook=cfb.find(\"/Book\");var CompObjP,SummaryP,WorkbookP;if(CompObj)CompObjP=parse_compobj(CompObj);if(options.bookProps&&!options.bookSheets)WorkbookP={};else{if(Workbook)WorkbookP=parse_workbook(Workbook.content,options,!!Workbook.find);else throw new Error(\"Cannot find Workbook stream\")}if(cfb.find)parse_props(cfb);var props={};for(var y in cfb.Summary)props[y]=cfb.Summary[y];for(y in cfb.DocSummary)props[y]=cfb.DocSummary[y];WorkbookP.Props=WorkbookP.Custprops=props;if(options.bookFiles)WorkbookP.cfb=cfb;WorkbookP.CompObjP=CompObjP;return WorkbookP}function parse_props(cfb){var DSI=cfb.find(\"!DocumentSummaryInformation\");if(DSI)try{cfb.DocSummary=parse_PropertySetStream(DSI,DocSummaryPIDDSI)}catch(e){}var SI=cfb.find(\"!SummaryInformation\");if(SI)try{cfb.Summary=parse_PropertySetStream(SI,SummaryPIDSI)}catch(e){}}var XLSBRecordEnum={0:{n:\"BrtRowHdr\",f:parse_BrtRowHdr},1:{n:\"BrtCellBlank\",f:parse_BrtCellBlank},2:{n:\"BrtCellRk\",f:parse_BrtCellRk},3:{n:\"BrtCellError\",f:parse_BrtCellError},4:{n:\"BrtCellBool\",f:parse_BrtCellBool},5:{n:\"BrtCellReal\",f:parse_BrtCellReal},6:{n:\"BrtCellSt\",f:parse_BrtCellSt},7:{n:\"BrtCellIsst\",f:parse_BrtCellIsst},8:{n:\"BrtFmlaString\",f:parse_BrtFmlaString},9:{n:\"BrtFmlaNum\",f:parse_BrtFmlaNum},10:{n:\"BrtFmlaBool\",f:parse_BrtFmlaBool},11:{n:\"BrtFmlaError\",f:parse_BrtFmlaError},16:{n:\"BrtFRTArchID$\",f:parse_BrtFRTArchID$},19:{n:\"BrtSSTItem\",f:parse_RichStr},20:{n:\"BrtPCDIMissing\",f:parsenoop},21:{n:\"BrtPCDINumber\",f:parsenoop},22:{n:\"BrtPCDIBoolean\",f:parsenoop},23:{n:\"BrtPCDIError\",f:parsenoop},24:{n:\"BrtPCDIString\",f:parsenoop},25:{n:\"BrtPCDIDatetime\",f:parsenoop},26:{n:\"BrtPCDIIndex\",f:parsenoop},27:{n:\"BrtPCDIAMissing\",f:parsenoop},28:{n:\"BrtPCDIANumber\",f:parsenoop},29:{n:\"BrtPCDIABoolean\",f:parsenoop},30:{n:\"BrtPCDIAError\",f:parsenoop},31:{n:\"BrtPCDIAString\",f:parsenoop},32:{n:\"BrtPCDIADatetime\",f:parsenoop},33:{n:\"BrtPCRRecord\",f:parsenoop},34:{n:\"BrtPCRRecordDt\",f:parsenoop},35:{n:\"BrtFRTBegin\",f:parsenoop},36:{n:\"BrtFRTEnd\",f:parsenoop},37:{n:\"BrtACBegin\",f:parsenoop},38:{n:\"BrtACEnd\",f:parsenoop},39:{n:\"BrtName\",f:parsenoop},40:{n:\"BrtIndexRowBlock\",f:parsenoop},42:{n:\"BrtIndexBlock\",f:parsenoop},43:{n:\"BrtFont\",f:parse_BrtFont},44:{n:\"BrtFmt\",f:parse_BrtFmt},45:{n:\"BrtFill\",f:parsenoop},46:{n:\"BrtBorder\",f:parsenoop},47:{n:\"BrtXF\",f:parse_BrtXF},48:{n:\"BrtStyle\",f:parsenoop},49:{n:\"BrtCellMeta\",f:parsenoop},50:{n:\"BrtValueMeta\",f:parsenoop},51:{n:\"BrtMdb\",f:parsenoop},52:{n:\"BrtBeginFmd\",f:parsenoop},53:{n:\"BrtEndFmd\",f:parsenoop},54:{n:\"BrtBeginMdx\",f:parsenoop},55:{n:\"BrtEndMdx\",f:parsenoop},56:{n:\"BrtBeginMdxTuple\",f:parsenoop},57:{n:\"BrtEndMdxTuple\",f:parsenoop},58:{n:\"BrtMdxMbrIstr\",f:parsenoop},59:{n:\"BrtStr\",f:parsenoop},60:{n:\"BrtColInfo\",f:parsenoop},62:{n:\"BrtCellRString\",f:parsenoop},63:{n:\"BrtCalcChainItem$\",f:parse_BrtCalcChainItem$},64:{n:\"BrtDVal\",f:parsenoop},65:{n:\"BrtSxvcellNum\",f:parsenoop},66:{n:\"BrtSxvcellStr\",f:parsenoop},67:{n:\"BrtSxvcellBool\",f:parsenoop},68:{n:\"BrtSxvcellErr\",f:parsenoop},69:{n:\"BrtSxvcellDate\",f:parsenoop},70:{n:\"BrtSxvcellNil\",f:parsenoop},128:{n:\"BrtFileVersion\",f:parsenoop},129:{n:\"BrtBeginSheet\",f:parsenoop},130:{n:\"BrtEndSheet\",f:parsenoop},131:{n:\"BrtBeginBook\",f:parsenoop,p:0},132:{n:\"BrtEndBook\",f:parsenoop},133:{n:\"BrtBeginWsViews\",f:parsenoop},134:{n:\"BrtEndWsViews\",f:parsenoop},135:{n:\"BrtBeginBookViews\",f:parsenoop},136:{n:\"BrtEndBookViews\",f:parsenoop},137:{n:\"BrtBeginWsView\",f:parsenoop},138:{n:\"BrtEndWsView\",f:parsenoop},139:{n:\"BrtBeginCsViews\",f:parsenoop},140:{n:\"BrtEndCsViews\",f:parsenoop},141:{n:\"BrtBeginCsView\",f:parsenoop},142:{n:\"BrtEndCsView\",f:parsenoop},143:{n:\"BrtBeginBundleShs\",f:parsenoop},144:{n:\"BrtEndBundleShs\",f:parsenoop},145:{n:\"BrtBeginSheetData\",f:parsenoop},146:{n:\"BrtEndSheetData\",f:parsenoop},147:{n:\"BrtWsProp\",f:parse_BrtWsProp},148:{n:\"BrtWsDim\",f:parse_BrtWsDim,p:16},151:{n:\"BrtPane\",f:parsenoop},152:{n:\"BrtSel\",f:parsenoop},153:{n:\"BrtWbProp\",f:parse_BrtWbProp},154:{n:\"BrtWbFactoid\",f:parsenoop},155:{n:\"BrtFileRecover\",f:parsenoop},156:{n:\"BrtBundleSh\",f:parse_BrtBundleSh},157:{n:\"BrtCalcProp\",f:parsenoop},158:{n:\"BrtBookView\",f:parsenoop},159:{n:\"BrtBeginSst\",f:parse_BrtBeginSst},160:{n:\"BrtEndSst\",f:parsenoop},161:{n:\"BrtBeginAFilter\",f:parsenoop},162:{n:\"BrtEndAFilter\",f:parsenoop},163:{n:\"BrtBeginFilterColumn\",f:parsenoop},164:{n:\"BrtEndFilterColumn\",f:parsenoop},165:{n:\"BrtBeginFilters\",f:parsenoop},166:{n:\"BrtEndFilters\",f:parsenoop},167:{n:\"BrtFilter\",f:parsenoop},168:{n:\"BrtColorFilter\",f:parsenoop},169:{n:\"BrtIconFilter\",f:parsenoop},170:{n:\"BrtTop10Filter\",f:parsenoop},171:{n:\"BrtDynamicFilter\",f:parsenoop},172:{n:\"BrtBeginCustomFilters\",f:parsenoop},173:{n:\"BrtEndCustomFilters\",f:parsenoop},174:{n:\"BrtCustomFilter\",f:parsenoop},175:{n:\"BrtAFilterDateGroupItem\",f:parsenoop},176:{n:\"BrtMergeCell\",f:parse_BrtMergeCell},177:{n:\"BrtBeginMergeCells\",f:parsenoop},178:{n:\"BrtEndMergeCells\",f:parsenoop},179:{n:\"BrtBeginPivotCacheDef\",f:parsenoop},180:{n:\"BrtEndPivotCacheDef\",f:parsenoop},181:{n:\"BrtBeginPCDFields\",f:parsenoop},182:{n:\"BrtEndPCDFields\",f:parsenoop},183:{n:\"BrtBeginPCDField\",f:parsenoop},184:{n:\"BrtEndPCDField\",f:parsenoop},185:{n:\"BrtBeginPCDSource\",f:parsenoop},186:{n:\"BrtEndPCDSource\",f:parsenoop},187:{n:\"BrtBeginPCDSRange\",f:parsenoop},188:{n:\"BrtEndPCDSRange\",f:parsenoop},189:{n:\"BrtBeginPCDFAtbl\",f:parsenoop},190:{n:\"BrtEndPCDFAtbl\",f:parsenoop},191:{n:\"BrtBeginPCDIRun\",f:parsenoop},192:{n:\"BrtEndPCDIRun\",f:parsenoop},193:{n:\"BrtBeginPivotCacheRecords\",f:parsenoop},194:{n:\"BrtEndPivotCacheRecords\",f:parsenoop},195:{n:\"BrtBeginPCDHierarchies\",f:parsenoop},196:{n:\"BrtEndPCDHierarchies\",f:parsenoop},197:{n:\"BrtBeginPCDHierarchy\",f:parsenoop},198:{n:\"BrtEndPCDHierarchy\",f:parsenoop},199:{n:\"BrtBeginPCDHFieldsUsage\",f:parsenoop},200:{n:\"BrtEndPCDHFieldsUsage\",f:parsenoop},201:{n:\"BrtBeginExtConnection\",f:parsenoop},202:{n:\"BrtEndExtConnection\",f:parsenoop},203:{n:\"BrtBeginECDbProps\",f:parsenoop},204:{n:\"BrtEndECDbProps\",f:parsenoop},205:{n:\"BrtBeginECOlapProps\",f:parsenoop},206:{n:\"BrtEndECOlapProps\",f:parsenoop},207:{n:\"BrtBeginPCDSConsol\",f:parsenoop},208:{n:\"BrtEndPCDSConsol\",f:parsenoop},209:{n:\"BrtBeginPCDSCPages\",f:parsenoop},210:{n:\"BrtEndPCDSCPages\",f:parsenoop},211:{n:\"BrtBeginPCDSCPage\",f:parsenoop},212:{n:\"BrtEndPCDSCPage\",f:parsenoop},213:{n:\"BrtBeginPCDSCPItem\",f:parsenoop},214:{n:\"BrtEndPCDSCPItem\",f:parsenoop},215:{n:\"BrtBeginPCDSCSets\",f:parsenoop},216:{n:\"BrtEndPCDSCSets\",f:parsenoop},217:{n:\"BrtBeginPCDSCSet\",f:parsenoop},218:{n:\"BrtEndPCDSCSet\",f:parsenoop},219:{n:\"BrtBeginPCDFGroup\",f:parsenoop},220:{n:\"BrtEndPCDFGroup\",f:parsenoop},221:{n:\"BrtBeginPCDFGItems\",f:parsenoop},222:{n:\"BrtEndPCDFGItems\",f:parsenoop},223:{n:\"BrtBeginPCDFGRange\",f:parsenoop},224:{n:\"BrtEndPCDFGRange\",f:parsenoop},225:{n:\"BrtBeginPCDFGDiscrete\",f:parsenoop},226:{n:\"BrtEndPCDFGDiscrete\",f:parsenoop},227:{n:\"BrtBeginPCDSDTupleCache\",f:parsenoop},228:{n:\"BrtEndPCDSDTupleCache\",f:parsenoop},229:{n:\"BrtBeginPCDSDTCEntries\",f:parsenoop},230:{n:\"BrtEndPCDSDTCEntries\",f:parsenoop},231:{n:\"BrtBeginPCDSDTCEMembers\",f:parsenoop},232:{n:\"BrtEndPCDSDTCEMembers\",f:parsenoop},233:{n:\"BrtBeginPCDSDTCEMember\",f:parsenoop},234:{n:\"BrtEndPCDSDTCEMember\",f:parsenoop},235:{n:\"BrtBeginPCDSDTCQueries\",f:parsenoop},236:{n:\"BrtEndPCDSDTCQueries\",f:parsenoop},237:{n:\"BrtBeginPCDSDTCQuery\",f:parsenoop},238:{n:\"BrtEndPCDSDTCQuery\",f:parsenoop},239:{n:\"BrtBeginPCDSDTCSets\",f:parsenoop},240:{n:\"BrtEndPCDSDTCSets\",f:parsenoop},241:{n:\"BrtBeginPCDSDTCSet\",f:parsenoop},242:{n:\"BrtEndPCDSDTCSet\",f:parsenoop},243:{n:\"BrtBeginPCDCalcItems\",f:parsenoop},244:{n:\"BrtEndPCDCalcItems\",f:parsenoop},245:{n:\"BrtBeginPCDCalcItem\",f:parsenoop},246:{n:\"BrtEndPCDCalcItem\",f:parsenoop},247:{n:\"BrtBeginPRule\",f:parsenoop},248:{n:\"BrtEndPRule\",f:parsenoop},249:{n:\"BrtBeginPRFilters\",f:parsenoop},250:{n:\"BrtEndPRFilters\",f:parsenoop},251:{n:\"BrtBeginPRFilter\",f:parsenoop},252:{n:\"BrtEndPRFilter\",f:parsenoop},253:{n:\"BrtBeginPNames\",f:parsenoop},254:{n:\"BrtEndPNames\",f:parsenoop},255:{n:\"BrtBeginPName\",f:parsenoop},256:{n:\"BrtEndPName\",f:parsenoop},257:{n:\"BrtBeginPNPairs\",f:parsenoop},258:{n:\"BrtEndPNPairs\",f:parsenoop},259:{n:\"BrtBeginPNPair\",f:parsenoop},260:{n:\"BrtEndPNPair\",f:parsenoop},261:{n:\"BrtBeginECWebProps\",f:parsenoop},262:{n:\"BrtEndECWebProps\",f:parsenoop},263:{n:\"BrtBeginEcWpTables\",f:parsenoop},264:{n:\"BrtEndECWPTables\",f:parsenoop},265:{n:\"BrtBeginECParams\",f:parsenoop},266:{n:\"BrtEndECParams\",f:parsenoop},267:{n:\"BrtBeginECParam\",f:parsenoop},268:{n:\"BrtEndECParam\",f:parsenoop},269:{n:\"BrtBeginPCDKPIs\",f:parsenoop},270:{n:\"BrtEndPCDKPIs\",f:parsenoop},271:{n:\"BrtBeginPCDKPI\",f:parsenoop},272:{n:\"BrtEndPCDKPI\",f:parsenoop},273:{n:\"BrtBeginDims\",f:parsenoop},274:{n:\"BrtEndDims\",f:parsenoop},275:{n:\"BrtBeginDim\",f:parsenoop},276:{n:\"BrtEndDim\",f:parsenoop},277:{n:\"BrtIndexPartEnd\",f:parsenoop},278:{n:\"BrtBeginStyleSheet\",f:parsenoop},279:{n:\"BrtEndStyleSheet\",f:parsenoop},280:{n:\"BrtBeginSXView\",f:parsenoop},281:{n:\"BrtEndSXVI\",f:parsenoop},282:{n:\"BrtBeginSXVI\",f:parsenoop},283:{n:\"BrtBeginSXVIs\",f:parsenoop},284:{n:\"BrtEndSXVIs\",f:parsenoop},285:{n:\"BrtBeginSXVD\",f:parsenoop},286:{n:\"BrtEndSXVD\",f:parsenoop},287:{n:\"BrtBeginSXVDs\",f:parsenoop},288:{n:\"BrtEndSXVDs\",f:parsenoop},289:{n:\"BrtBeginSXPI\",f:parsenoop},290:{n:\"BrtEndSXPI\",f:parsenoop},291:{n:\"BrtBeginSXPIs\",f:parsenoop},292:{n:\"BrtEndSXPIs\",f:parsenoop},293:{n:\"BrtBeginSXDI\",f:parsenoop},294:{n:\"BrtEndSXDI\",f:parsenoop},295:{n:\"BrtBeginSXDIs\",f:parsenoop},296:{n:\"BrtEndSXDIs\",f:parsenoop},297:{n:\"BrtBeginSXLI\",f:parsenoop},298:{n:\"BrtEndSXLI\",f:parsenoop},299:{n:\"BrtBeginSXLIRws\",f:parsenoop},300:{n:\"BrtEndSXLIRws\",f:parsenoop},301:{n:\"BrtBeginSXLICols\",f:parsenoop},302:{n:\"BrtEndSXLICols\",f:parsenoop},303:{n:\"BrtBeginSXFormat\",f:parsenoop},304:{n:\"BrtEndSXFormat\",f:parsenoop},305:{n:\"BrtBeginSXFormats\",f:parsenoop},306:{n:\"BrtEndSxFormats\",f:parsenoop},307:{n:\"BrtBeginSxSelect\",f:parsenoop},308:{n:\"BrtEndSxSelect\",f:parsenoop},309:{n:\"BrtBeginISXVDRws\",f:parsenoop},310:{n:\"BrtEndISXVDRws\",f:parsenoop},311:{n:\"BrtBeginISXVDCols\",f:parsenoop},312:{n:\"BrtEndISXVDCols\",f:parsenoop},313:{n:\"BrtEndSXLocation\",f:parsenoop},314:{n:\"BrtBeginSXLocation\",f:parsenoop},315:{n:\"BrtEndSXView\",f:parsenoop},316:{n:\"BrtBeginSXTHs\",f:parsenoop},317:{n:\"BrtEndSXTHs\",f:parsenoop},318:{n:\"BrtBeginSXTH\",f:parsenoop},319:{n:\"BrtEndSXTH\",f:parsenoop},320:{n:\"BrtBeginISXTHRws\",f:parsenoop},321:{n:\"BrtEndISXTHRws\",f:parsenoop},322:{n:\"BrtBeginISXTHCols\",f:parsenoop},323:{n:\"BrtEndISXTHCols\",f:parsenoop},324:{n:\"BrtBeginSXTDMPS\",f:parsenoop},325:{n:\"BrtEndSXTDMPs\",f:parsenoop},326:{n:\"BrtBeginSXTDMP\",f:parsenoop},327:{n:\"BrtEndSXTDMP\",f:parsenoop},328:{n:\"BrtBeginSXTHItems\",f:parsenoop},329:{n:\"BrtEndSXTHItems\",f:parsenoop},330:{n:\"BrtBeginSXTHItem\",f:parsenoop},331:{n:\"BrtEndSXTHItem\",f:parsenoop},332:{n:\"BrtBeginMetadata\",f:parsenoop},333:{n:\"BrtEndMetadata\",f:parsenoop},334:{n:\"BrtBeginEsmdtinfo\",f:parsenoop},335:{n:\"BrtMdtinfo\",f:parsenoop},336:{n:\"BrtEndEsmdtinfo\",f:parsenoop},337:{n:\"BrtBeginEsmdb\",f:parsenoop},338:{n:\"BrtEndEsmdb\",f:parsenoop},339:{n:\"BrtBeginEsfmd\",f:parsenoop},340:{n:\"BrtEndEsfmd\",f:parsenoop},341:{n:\"BrtBeginSingleCells\",f:parsenoop},342:{n:\"BrtEndSingleCells\",f:parsenoop},343:{n:\"BrtBeginList\",f:parsenoop},344:{n:\"BrtEndList\",f:parsenoop},345:{n:\"BrtBeginListCols\",f:parsenoop},346:{n:\"BrtEndListCols\",f:parsenoop},347:{n:\"BrtBeginListCol\",f:parsenoop},348:{n:\"BrtEndListCol\",f:parsenoop},349:{n:\"BrtBeginListXmlCPr\",f:parsenoop},350:{n:\"BrtEndListXmlCPr\",f:parsenoop},351:{n:\"BrtListCCFmla\",f:parsenoop},352:{n:\"BrtListTrFmla\",f:parsenoop},353:{n:\"BrtBeginExternals\",f:parsenoop},354:{n:\"BrtEndExternals\",f:parsenoop},355:{n:\"BrtSupBookSrc\",f:parsenoop},357:{n:\"BrtSupSelf\",f:parsenoop},358:{n:\"BrtSupSame\",f:parsenoop},359:{n:\"BrtSupTabs\",f:parsenoop},360:{n:\"BrtBeginSupBook\",f:parsenoop},361:{n:\"BrtPlaceholderName\",f:parsenoop},362:{n:\"BrtExternSheet\",f:parsenoop},363:{n:\"BrtExternTableStart\",f:parsenoop},364:{n:\"BrtExternTableEnd\",f:parsenoop},366:{n:\"BrtExternRowHdr\",f:parsenoop},367:{n:\"BrtExternCellBlank\",f:parsenoop},368:{n:\"BrtExternCellReal\",f:parsenoop},369:{n:\"BrtExternCellBool\",f:parsenoop},370:{n:\"BrtExternCellError\",f:parsenoop},371:{n:\"BrtExternCellString\",f:parsenoop},372:{n:\"BrtBeginEsmdx\",f:parsenoop},373:{n:\"BrtEndEsmdx\",f:parsenoop},374:{n:\"BrtBeginMdxSet\",f:parsenoop},375:{n:\"BrtEndMdxSet\",f:parsenoop},376:{n:\"BrtBeginMdxMbrProp\",f:parsenoop},377:{n:\"BrtEndMdxMbrProp\",f:parsenoop},378:{n:\"BrtBeginMdxKPI\",f:parsenoop},379:{n:\"BrtEndMdxKPI\",f:parsenoop},380:{n:\"BrtBeginEsstr\",f:parsenoop},381:{n:\"BrtEndEsstr\",f:parsenoop},382:{n:\"BrtBeginPRFItem\",f:parsenoop},383:{n:\"BrtEndPRFItem\",f:parsenoop},384:{n:\"BrtBeginPivotCacheIDs\",f:parsenoop},385:{n:\"BrtEndPivotCacheIDs\",f:parsenoop},386:{n:\"BrtBeginPivotCacheID\",f:parsenoop},387:{n:\"BrtEndPivotCacheID\",f:parsenoop},388:{n:\"BrtBeginISXVIs\",f:parsenoop},389:{n:\"BrtEndISXVIs\",f:parsenoop},390:{n:\"BrtBeginColInfos\",f:parsenoop},391:{n:\"BrtEndColInfos\",f:parsenoop},392:{n:\"BrtBeginRwBrk\",f:parsenoop},393:{n:\"BrtEndRwBrk\",f:parsenoop},394:{n:\"BrtBeginColBrk\",f:parsenoop},395:{n:\"BrtEndColBrk\",f:parsenoop},396:{n:\"BrtBrk\",f:parsenoop},397:{n:\"BrtUserBookView\",f:parsenoop},398:{n:\"BrtInfo\",f:parsenoop},399:{n:\"BrtCUsr\",f:parsenoop},400:{n:\"BrtUsr\",f:parsenoop},401:{n:\"BrtBeginUsers\",f:parsenoop},403:{n:\"BrtEOF\",f:parsenoop},404:{n:\"BrtUCR\",f:parsenoop},405:{n:\"BrtRRInsDel\",f:parsenoop},406:{n:\"BrtRREndInsDel\",f:parsenoop},407:{n:\"BrtRRMove\",f:parsenoop},408:{n:\"BrtRREndMove\",f:parsenoop},409:{n:\"BrtRRChgCell\",f:parsenoop},410:{n:\"BrtRREndChgCell\",f:parsenoop},411:{n:\"BrtRRHeader\",f:parsenoop},412:{n:\"BrtRRUserView\",f:parsenoop},413:{n:\"BrtRRRenSheet\",f:parsenoop},414:{n:\"BrtRRInsertSh\",f:parsenoop},415:{n:\"BrtRRDefName\",f:parsenoop},416:{n:\"BrtRRNote\",f:parsenoop},417:{n:\"BrtRRConflict\",f:parsenoop},418:{n:\"BrtRRTQSIF\",f:parsenoop},419:{n:\"BrtRRFormat\",f:parsenoop},420:{n:\"BrtRREndFormat\",f:parsenoop},421:{n:\"BrtRRAutoFmt\",f:parsenoop},422:{n:\"BrtBeginUserShViews\",f:parsenoop},423:{n:\"BrtBeginUserShView\",f:parsenoop},424:{n:\"BrtEndUserShView\",f:parsenoop},425:{n:\"BrtEndUserShViews\",f:parsenoop},426:{n:\"BrtArrFmla\",f:parsenoop},427:{n:\"BrtShrFmla\",f:parsenoop},428:{n:\"BrtTable\",f:parsenoop},429:{n:\"BrtBeginExtConnections\",f:parsenoop},430:{n:\"BrtEndExtConnections\",f:parsenoop},431:{n:\"BrtBeginPCDCalcMems\",f:parsenoop},432:{n:\"BrtEndPCDCalcMems\",f:parsenoop},433:{n:\"BrtBeginPCDCalcMem\",f:parsenoop},434:{n:\"BrtEndPCDCalcMem\",f:parsenoop},435:{n:\"BrtBeginPCDHGLevels\",f:parsenoop},436:{n:\"BrtEndPCDHGLevels\",f:parsenoop},437:{n:\"BrtBeginPCDHGLevel\",f:parsenoop},438:{n:\"BrtEndPCDHGLevel\",f:parsenoop},439:{n:\"BrtBeginPCDHGLGroups\",f:parsenoop},440:{n:\"BrtEndPCDHGLGroups\",f:parsenoop},441:{n:\"BrtBeginPCDHGLGroup\",f:parsenoop},442:{n:\"BrtEndPCDHGLGroup\",f:parsenoop},443:{n:\"BrtBeginPCDHGLGMembers\",f:parsenoop},444:{n:\"BrtEndPCDHGLGMembers\",f:parsenoop},445:{n:\"BrtBeginPCDHGLGMember\",f:parsenoop},446:{n:\"BrtEndPCDHGLGMember\",f:parsenoop},447:{n:\"BrtBeginQSI\",f:parsenoop},448:{n:\"BrtEndQSI\",f:parsenoop},449:{n:\"BrtBeginQSIR\",f:parsenoop},450:{n:\"BrtEndQSIR\",f:parsenoop},451:{n:\"BrtBeginDeletedNames\",f:parsenoop},452:{n:\"BrtEndDeletedNames\",f:parsenoop},453:{n:\"BrtBeginDeletedName\",f:parsenoop},454:{n:\"BrtEndDeletedName\",f:parsenoop},455:{n:\"BrtBeginQSIFs\",f:parsenoop},456:{n:\"BrtEndQSIFs\",f:parsenoop},457:{n:\"BrtBeginQSIF\",f:parsenoop},458:{n:\"BrtEndQSIF\",f:parsenoop},459:{n:\"BrtBeginAutoSortScope\",f:parsenoop},460:{n:\"BrtEndAutoSortScope\",f:parsenoop},461:{n:\"BrtBeginConditionalFormatting\",f:parsenoop},462:{n:\"BrtEndConditionalFormatting\",f:parsenoop},463:{n:\"BrtBeginCFRule\",f:parsenoop},464:{n:\"BrtEndCFRule\",f:parsenoop},465:{n:\"BrtBeginIconSet\",f:parsenoop},466:{n:\"BrtEndIconSet\",f:parsenoop},467:{n:\"BrtBeginDatabar\",f:parsenoop},468:{n:\"BrtEndDatabar\",f:parsenoop},469:{n:\"BrtBeginColorScale\",f:parsenoop},470:{n:\"BrtEndColorScale\",f:parsenoop},471:{n:\"BrtCFVO\",f:parsenoop},472:{n:\"BrtExternValueMeta\",f:parsenoop},473:{n:\"BrtBeginColorPalette\",f:parsenoop},474:{n:\"BrtEndColorPalette\",f:parsenoop},475:{n:\"BrtIndexedColor\",f:parsenoop},476:{n:\"BrtMargins\",f:parsenoop},477:{n:\"BrtPrintOptions\",f:parsenoop},478:{n:\"BrtPageSetup\",f:parsenoop},479:{n:\"BrtBeginHeaderFooter\",f:parsenoop},480:{n:\"BrtEndHeaderFooter\",f:parsenoop},481:{n:\"BrtBeginSXCrtFormat\",f:parsenoop},482:{n:\"BrtEndSXCrtFormat\",f:parsenoop},483:{n:\"BrtBeginSXCrtFormats\",f:parsenoop},484:{n:\"BrtEndSXCrtFormats\",f:parsenoop},485:{n:\"BrtWsFmtInfo\",f:parsenoop},486:{n:\"BrtBeginMgs\",f:parsenoop},487:{n:\"BrtEndMGs\",f:parsenoop},488:{n:\"BrtBeginMGMaps\",f:parsenoop},489:{n:\"BrtEndMGMaps\",f:parsenoop},490:{n:\"BrtBeginMG\",f:parsenoop},491:{n:\"BrtEndMG\",f:parsenoop},492:{n:\"BrtBeginMap\",f:parsenoop},493:{n:\"BrtEndMap\",f:parsenoop},494:{n:\"BrtHLink\",f:parse_BrtHLink},495:{n:\"BrtBeginDCon\",f:parsenoop},496:{n:\"BrtEndDCon\",f:parsenoop},497:{n:\"BrtBeginDRefs\",f:parsenoop},498:{n:\"BrtEndDRefs\",f:parsenoop},499:{n:\"BrtDRef\",f:parsenoop},500:{n:\"BrtBeginScenMan\",f:parsenoop},501:{n:\"BrtEndScenMan\",f:parsenoop},502:{n:\"BrtBeginSct\",f:parsenoop},503:{n:\"BrtEndSct\",f:parsenoop},504:{n:\"BrtSlc\",f:parsenoop},505:{n:\"BrtBeginDXFs\",f:parsenoop},506:{n:\"BrtEndDXFs\",f:parsenoop},507:{n:\"BrtDXF\",f:parsenoop},508:{n:\"BrtBeginTableStyles\",f:parsenoop},509:{n:\"BrtEndTableStyles\",f:parsenoop},510:{n:\"BrtBeginTableStyle\",f:parsenoop},511:{n:\"BrtEndTableStyle\",f:parsenoop},512:{n:\"BrtTableStyleElement\",f:parsenoop},513:{n:\"BrtTableStyleClient\",f:parsenoop},514:{n:\"BrtBeginVolDeps\",f:parsenoop},515:{n:\"BrtEndVolDeps\",f:parsenoop},516:{n:\"BrtBeginVolType\",f:parsenoop},517:{n:\"BrtEndVolType\",f:parsenoop},518:{n:\"BrtBeginVolMain\",f:parsenoop},519:{n:\"BrtEndVolMain\",f:parsenoop},520:{n:\"BrtBeginVolTopic\",f:parsenoop},521:{n:\"BrtEndVolTopic\",f:parsenoop},522:{n:\"BrtVolSubtopic\",f:parsenoop},523:{n:\"BrtVolRef\",f:parsenoop},524:{n:\"BrtVolNum\",f:parsenoop},525:{n:\"BrtVolErr\",f:parsenoop},526:{n:\"BrtVolStr\",f:parsenoop},527:{n:\"BrtVolBool\",f:parsenoop},528:{n:\"BrtBeginCalcChain$\",f:parsenoop},529:{n:\"BrtEndCalcChain$\",f:parsenoop},530:{n:\"BrtBeginSortState\",f:parsenoop},531:{n:\"BrtEndSortState\",f:parsenoop},532:{n:\"BrtBeginSortCond\",f:parsenoop},533:{n:\"BrtEndSortCond\",f:parsenoop},534:{n:\"BrtBookProtection\",f:parsenoop},535:{n:\"BrtSheetProtection\",f:parsenoop},536:{n:\"BrtRangeProtection\",f:parsenoop},537:{n:\"BrtPhoneticInfo\",f:parsenoop},538:{n:\"BrtBeginECTxtWiz\",f:parsenoop},539:{n:\"BrtEndECTxtWiz\",f:parsenoop},540:{n:\"BrtBeginECTWFldInfoLst\",f:parsenoop},541:{n:\"BrtEndECTWFldInfoLst\",f:parsenoop},542:{n:\"BrtBeginECTwFldInfo\",f:parsenoop},548:{n:\"BrtFileSharing\",f:parsenoop},549:{n:\"BrtOleSize\",f:parsenoop},550:{n:\"BrtDrawing\",f:parsenoop},551:{n:\"BrtLegacyDrawing\",f:parsenoop},552:{n:\"BrtLegacyDrawingHF\",f:parsenoop},553:{n:\"BrtWebOpt\",f:parsenoop},554:{n:\"BrtBeginWebPubItems\",f:parsenoop},555:{n:\"BrtEndWebPubItems\",f:parsenoop},556:{n:\"BrtBeginWebPubItem\",f:parsenoop},557:{n:\"BrtEndWebPubItem\",f:parsenoop},558:{n:\"BrtBeginSXCondFmt\",f:parsenoop},559:{n:\"BrtEndSXCondFmt\",f:parsenoop},560:{n:\"BrtBeginSXCondFmts\",f:parsenoop},561:{n:\"BrtEndSXCondFmts\",f:parsenoop},562:{n:\"BrtBkHim\",f:parsenoop},564:{n:\"BrtColor\",f:parsenoop},565:{n:\"BrtBeginIndexedColors\",f:parsenoop},566:{n:\"BrtEndIndexedColors\",f:parsenoop},569:{n:\"BrtBeginMRUColors\",f:parsenoop},570:{n:\"BrtEndMRUColors\",f:parsenoop},572:{n:\"BrtMRUColor\",f:parsenoop},573:{n:\"BrtBeginDVals\",f:parsenoop},574:{n:\"BrtEndDVals\",f:parsenoop},577:{n:\"BrtSupNameStart\",f:parsenoop},578:{n:\"BrtSupNameValueStart\",f:parsenoop},579:{n:\"BrtSupNameValueEnd\",f:parsenoop},580:{n:\"BrtSupNameNum\",f:parsenoop},581:{n:\"BrtSupNameErr\",f:parsenoop},582:{n:\"BrtSupNameSt\",f:parsenoop},583:{n:\"BrtSupNameNil\",f:parsenoop},584:{n:\"BrtSupNameBool\",f:parsenoop},585:{n:\"BrtSupNameFmla\",f:parsenoop},586:{n:\"BrtSupNameBits\",f:parsenoop},587:{n:\"BrtSupNameEnd\",f:parsenoop},588:{n:\"BrtEndSupBook\",f:parsenoop},589:{n:\"BrtCellSmartTagProperty\",f:parsenoop},590:{n:\"BrtBeginCellSmartTag\",f:parsenoop},591:{n:\"BrtEndCellSmartTag\",f:parsenoop},592:{n:\"BrtBeginCellSmartTags\",f:parsenoop},593:{n:\"BrtEndCellSmartTags\",f:parsenoop},594:{n:\"BrtBeginSmartTags\",f:parsenoop},595:{n:\"BrtEndSmartTags\",f:parsenoop},596:{n:\"BrtSmartTagType\",f:parsenoop},597:{n:\"BrtBeginSmartTagTypes\",f:parsenoop},598:{n:\"BrtEndSmartTagTypes\",f:parsenoop},599:{n:\"BrtBeginSXFilters\",f:parsenoop},600:{n:\"BrtEndSXFilters\",f:parsenoop},601:{n:\"BrtBeginSXFILTER\",f:parsenoop},602:{n:\"BrtEndSXFilter\",f:parsenoop},603:{n:\"BrtBeginFills\",f:parsenoop},604:{n:\"BrtEndFills\",f:parsenoop},605:{n:\"BrtBeginCellWatches\",f:parsenoop},606:{n:\"BrtEndCellWatches\",f:parsenoop},607:{n:\"BrtCellWatch\",f:parsenoop},608:{n:\"BrtBeginCRErrs\",f:parsenoop},609:{n:\"BrtEndCRErrs\",f:parsenoop},610:{n:\"BrtCrashRecErr\",f:parsenoop},611:{n:\"BrtBeginFonts\",f:parsenoop},612:{n:\"BrtEndFonts\",f:parsenoop},613:{n:\"BrtBeginBorders\",f:parsenoop},614:{n:\"BrtEndBorders\",f:parsenoop},615:{n:\"BrtBeginFmts\",f:parsenoop},616:{n:\"BrtEndFmts\",f:parsenoop},617:{n:\"BrtBeginCellXFs\",f:parsenoop},618:{n:\"BrtEndCellXFs\",f:parsenoop},619:{n:\"BrtBeginStyles\",f:parsenoop},620:{n:\"BrtEndStyles\",f:parsenoop},625:{n:\"BrtBigName\",f:parsenoop},626:{n:\"BrtBeginCellStyleXFs\",f:parsenoop},627:{n:\"BrtEndCellStyleXFs\",f:parsenoop},628:{n:\"BrtBeginComments\",f:parsenoop},629:{n:\"BrtEndComments\",f:parsenoop},630:{n:\"BrtBeginCommentAuthors\",f:parsenoop},631:{n:\"BrtEndCommentAuthors\",f:parsenoop},632:{n:\"BrtCommentAuthor\",f:parse_BrtCommentAuthor},633:{n:\"BrtBeginCommentList\",f:parsenoop},634:{n:\"BrtEndCommentList\",f:parsenoop},635:{n:\"BrtBeginComment\",f:parse_BrtBeginComment},636:{n:\"BrtEndComment\",f:parsenoop},637:{n:\"BrtCommentText\",f:parse_BrtCommentText},638:{n:\"BrtBeginOleObjects\",f:parsenoop},639:{n:\"BrtOleObject\",f:parsenoop},640:{n:\"BrtEndOleObjects\",f:parsenoop},641:{n:\"BrtBeginSxrules\",f:parsenoop},642:{n:\"BrtEndSxRules\",f:parsenoop},643:{n:\"BrtBeginActiveXControls\",f:parsenoop},644:{n:\"BrtActiveX\",f:parsenoop},645:{n:\"BrtEndActiveXControls\",f:parsenoop},646:{n:\"BrtBeginPCDSDTCEMembersSortBy\",f:parsenoop},648:{n:\"BrtBeginCellIgnoreECs\",f:parsenoop},649:{n:\"BrtCellIgnoreEC\",f:parsenoop},650:{n:\"BrtEndCellIgnoreECs\",f:parsenoop},651:{n:\"BrtCsProp\",f:parsenoop},652:{n:\"BrtCsPageSetup\",f:parsenoop},653:{n:\"BrtBeginUserCsViews\",f:parsenoop},654:{n:\"BrtEndUserCsViews\",f:parsenoop},655:{n:\"BrtBeginUserCsView\",f:parsenoop},656:{n:\"BrtEndUserCsView\",f:parsenoop},657:{n:\"BrtBeginPcdSFCIEntries\",f:parsenoop},658:{n:\"BrtEndPCDSFCIEntries\",f:parsenoop},659:{n:\"BrtPCDSFCIEntry\",f:parsenoop},660:{n:\"BrtBeginListParts\",f:parsenoop},661:{n:\"BrtListPart\",f:parsenoop},662:{n:\"BrtEndListParts\",f:parsenoop},663:{n:\"BrtSheetCalcProp\",f:parsenoop},664:{n:\"BrtBeginFnGroup\",f:parsenoop},665:{n:\"BrtFnGroup\",f:parsenoop},666:{n:\"BrtEndFnGroup\",f:parsenoop},667:{n:\"BrtSupAddin\",f:parsenoop},668:{n:\"BrtSXTDMPOrder\",f:parsenoop},669:{n:\"BrtCsProtection\",f:parsenoop},671:{n:\"BrtBeginWsSortMap\",f:parsenoop},672:{n:\"BrtEndWsSortMap\",f:parsenoop},673:{n:\"BrtBeginRRSort\",f:parsenoop},674:{n:\"BrtEndRRSort\",f:parsenoop},675:{n:\"BrtRRSortItem\",f:parsenoop},676:{n:\"BrtFileSharingIso\",f:parsenoop},677:{n:\"BrtBookProtectionIso\",f:parsenoop},678:{n:\"BrtSheetProtectionIso\",f:parsenoop},679:{n:\"BrtCsProtectionIso\",f:parsenoop},680:{n:\"BrtRangeProtectionIso\",f:parsenoop},1024:{n:\"BrtRwDescent\",f:parsenoop},1025:{n:\"BrtKnownFonts\",f:parsenoop},1026:{n:\"BrtBeginSXTupleSet\",f:parsenoop},1027:{n:\"BrtEndSXTupleSet\",f:parsenoop},1028:{n:\"BrtBeginSXTupleSetHeader\",f:parsenoop},1029:{n:\"BrtEndSXTupleSetHeader\",f:parsenoop},1030:{n:\"BrtSXTupleSetHeaderItem\",f:parsenoop},1031:{n:\"BrtBeginSXTupleSetData\",f:parsenoop},1032:{n:\"BrtEndSXTupleSetData\",f:parsenoop},1033:{n:\"BrtBeginSXTupleSetRow\",f:parsenoop},1034:{n:\"BrtEndSXTupleSetRow\",f:parsenoop},1035:{n:\"BrtSXTupleSetRowItem\",f:parsenoop},1036:{n:\"BrtNameExt\",f:parsenoop},1037:{n:\"BrtPCDH14\",f:parsenoop},1038:{n:\"BrtBeginPCDCalcMem14\",f:parsenoop},1039:{n:\"BrtEndPCDCalcMem14\",f:parsenoop},1040:{n:\"BrtSXTH14\",f:parsenoop},1041:{n:\"BrtBeginSparklineGroup\",f:parsenoop},1042:{n:\"BrtEndSparklineGroup\",f:parsenoop},1043:{n:\"BrtSparkline\",f:parsenoop},1044:{n:\"BrtSXDI14\",f:parsenoop},1045:{n:\"BrtWsFmtInfoEx14\",f:parsenoop},1046:{n:\"BrtBeginConditionalFormatting14\",f:parsenoop},1047:{n:\"BrtEndConditionalFormatting14\",f:parsenoop},1048:{n:\"BrtBeginCFRule14\",f:parsenoop},1049:{n:\"BrtEndCFRule14\",f:parsenoop},1050:{n:\"BrtCFVO14\",f:parsenoop},1051:{n:\"BrtBeginDatabar14\",f:parsenoop},1052:{n:\"BrtBeginIconSet14\",f:parsenoop},1053:{n:\"BrtDVal14\",f:parsenoop},1054:{n:\"BrtBeginDVals14\",f:parsenoop},1055:{n:\"BrtColor14\",f:parsenoop},1056:{n:\"BrtBeginSparklines\",f:parsenoop},1057:{n:\"BrtEndSparklines\",f:parsenoop},1058:{n:\"BrtBeginSparklineGroups\",f:parsenoop},1059:{n:\"BrtEndSparklineGroups\",f:parsenoop},1061:{n:\"BrtSXVD14\",f:parsenoop},1062:{n:\"BrtBeginSxview14\",f:parsenoop},1063:{n:\"BrtEndSxview14\",f:parsenoop},1066:{n:\"BrtBeginPCD14\",f:parsenoop},1067:{n:\"BrtEndPCD14\",f:parsenoop},1068:{n:\"BrtBeginExtConn14\",f:parsenoop},1069:{n:\"BrtEndExtConn14\",f:parsenoop},1070:{n:\"BrtBeginSlicerCacheIDs\",f:parsenoop},1071:{n:\"BrtEndSlicerCacheIDs\",f:parsenoop},1072:{n:\"BrtBeginSlicerCacheID\",f:parsenoop},1073:{n:\"BrtEndSlicerCacheID\",f:parsenoop},1075:{n:\"BrtBeginSlicerCache\",f:parsenoop},1076:{n:\"BrtEndSlicerCache\",f:parsenoop},1077:{n:\"BrtBeginSlicerCacheDef\",f:parsenoop},1078:{n:\"BrtEndSlicerCacheDef\",f:parsenoop},1079:{n:\"BrtBeginSlicersEx\",f:parsenoop},1080:{n:\"BrtEndSlicersEx\",f:parsenoop},1081:{n:\"BrtBeginSlicerEx\",f:parsenoop},1082:{n:\"BrtEndSlicerEx\",f:parsenoop},1083:{n:\"BrtBeginSlicer\",f:parsenoop},1084:{n:\"BrtEndSlicer\",f:parsenoop},1085:{n:\"BrtSlicerCachePivotTables\",f:parsenoop},1086:{n:\"BrtBeginSlicerCacheOlapImpl\",f:parsenoop},1087:{n:\"BrtEndSlicerCacheOlapImpl\",f:parsenoop},1088:{n:\"BrtBeginSlicerCacheLevelsData\",f:parsenoop},1089:{n:\"BrtEndSlicerCacheLevelsData\",f:parsenoop},1090:{n:\"BrtBeginSlicerCacheLevelData\",f:parsenoop},1091:{n:\"BrtEndSlicerCacheLevelData\",f:parsenoop},1092:{n:\"BrtBeginSlicerCacheSiRanges\",f:parsenoop},1093:{n:\"BrtEndSlicerCacheSiRanges\",f:parsenoop},1094:{n:\"BrtBeginSlicerCacheSiRange\",f:parsenoop},1095:{n:\"BrtEndSlicerCacheSiRange\",f:parsenoop},1096:{n:\"BrtSlicerCacheOlapItem\",f:parsenoop},1097:{n:\"BrtBeginSlicerCacheSelections\",f:parsenoop},1098:{n:\"BrtSlicerCacheSelection\",f:parsenoop},1099:{n:\"BrtEndSlicerCacheSelections\",f:parsenoop},1100:{n:\"BrtBeginSlicerCacheNative\",f:parsenoop},1101:{n:\"BrtEndSlicerCacheNative\",f:parsenoop},1102:{n:\"BrtSlicerCacheNativeItem\",f:parsenoop},1103:{n:\"BrtRangeProtection14\",f:parsenoop},1104:{n:\"BrtRangeProtectionIso14\",f:parsenoop},1105:{n:\"BrtCellIgnoreEC14\",f:parsenoop},1111:{n:\"BrtList14\",f:parsenoop},1112:{n:\"BrtCFIcon\",f:parsenoop},1113:{n:\"BrtBeginSlicerCachesPivotCacheIDs\",f:parsenoop},1114:{n:\"BrtEndSlicerCachesPivotCacheIDs\",f:parsenoop},1115:{n:\"BrtBeginSlicers\",f:parsenoop},1116:{n:\"BrtEndSlicers\",f:parsenoop},1117:{n:\"BrtWbProp14\",f:parsenoop},1118:{n:\"BrtBeginSXEdit\",f:parsenoop},1119:{n:\"BrtEndSXEdit\",f:parsenoop},1120:{n:\"BrtBeginSXEdits\",f:parsenoop},1121:{n:\"BrtEndSXEdits\",f:parsenoop},1122:{n:\"BrtBeginSXChange\",f:parsenoop},1123:{n:\"BrtEndSXChange\",f:parsenoop},1124:{n:\"BrtBeginSXChanges\",f:parsenoop},1125:{n:\"BrtEndSXChanges\",f:parsenoop},1126:{n:\"BrtSXTupleItems\",f:parsenoop},1128:{n:\"BrtBeginSlicerStyle\",f:parsenoop},1129:{n:\"BrtEndSlicerStyle\",f:parsenoop},1130:{n:\"BrtSlicerStyleElement\",f:parsenoop},1131:{n:\"BrtBeginStyleSheetExt14\",f:parsenoop},1132:{n:\"BrtEndStyleSheetExt14\",f:parsenoop},1133:{n:\"BrtBeginSlicerCachesPivotCacheID\",f:parsenoop},1134:{n:\"BrtEndSlicerCachesPivotCacheID\",f:parsenoop},1135:{n:\"BrtBeginConditionalFormattings\",f:parsenoop},1136:{n:\"BrtEndConditionalFormattings\",f:parsenoop},1137:{n:\"BrtBeginPCDCalcMemExt\",f:parsenoop},1138:{n:\"BrtEndPCDCalcMemExt\",f:parsenoop},1139:{n:\"BrtBeginPCDCalcMemsExt\",f:parsenoop},1140:{n:\"BrtEndPCDCalcMemsExt\",f:parsenoop},1141:{n:\"BrtPCDField14\",f:parsenoop},1142:{n:\"BrtBeginSlicerStyles\",f:parsenoop},1143:{n:\"BrtEndSlicerStyles\",f:parsenoop},1144:{n:\"BrtBeginSlicerStyleElements\",f:parsenoop},1145:{n:\"BrtEndSlicerStyleElements\",f:parsenoop},1146:{n:\"BrtCFRuleExt\",f:parsenoop},1147:{n:\"BrtBeginSXCondFmt14\",f:parsenoop},1148:{n:\"BrtEndSXCondFmt14\",f:parsenoop},1149:{n:\"BrtBeginSXCondFmts14\",f:parsenoop},1150:{n:\"BrtEndSXCondFmts14\",f:parsenoop},1152:{n:\"BrtBeginSortCond14\",f:parsenoop},1153:{n:\"BrtEndSortCond14\",f:parsenoop},1154:{n:\"BrtEndDVals14\",f:parsenoop},1155:{n:\"BrtEndIconSet14\",f:parsenoop},1156:{n:\"BrtEndDatabar14\",f:parsenoop},1157:{n:\"BrtBeginColorScale14\",f:parsenoop},1158:{n:\"BrtEndColorScale14\",f:parsenoop},1159:{n:\"BrtBeginSxrules14\",f:parsenoop},1160:{n:\"BrtEndSxrules14\",f:parsenoop},1161:{n:\"BrtBeginPRule14\",f:parsenoop},1162:{n:\"BrtEndPRule14\",f:parsenoop},1163:{n:\"BrtBeginPRFilters14\",f:parsenoop},1164:{n:\"BrtEndPRFilters14\",f:parsenoop},1165:{n:\"BrtBeginPRFilter14\",f:parsenoop},1166:{n:\"BrtEndPRFilter14\",f:parsenoop},1167:{n:\"BrtBeginPRFItem14\",f:parsenoop},1168:{n:\"BrtEndPRFItem14\",f:parsenoop},1169:{n:\"BrtBeginCellIgnoreECs14\",f:parsenoop},1170:{n:\"BrtEndCellIgnoreECs14\",f:parsenoop},1171:{n:\"BrtDxf14\",f:parsenoop},1172:{n:\"BrtBeginDxF14s\",f:parsenoop},1173:{n:\"BrtEndDxf14s\",f:parsenoop},1177:{n:\"BrtFilter14\",f:parsenoop},1178:{n:\"BrtBeginCustomFilters14\",f:parsenoop},1180:{n:\"BrtCustomFilter14\",f:parsenoop},1181:{n:\"BrtIconFilter14\",f:parsenoop},1182:{n:\"BrtPivotCacheConnectionName\",f:parsenoop},2048:{n:\"BrtBeginDecoupledPivotCacheIDs\",f:parsenoop},2049:{n:\"BrtEndDecoupledPivotCacheIDs\",f:parsenoop},2050:{n:\"BrtDecoupledPivotCacheID\",f:parsenoop},2051:{n:\"BrtBeginPivotTableRefs\",f:parsenoop},2052:{n:\"BrtEndPivotTableRefs\",f:parsenoop},2053:{n:\"BrtPivotTableRef\",f:parsenoop},2054:{n:\"BrtSlicerCacheBookPivotTables\",f:parsenoop},2055:{n:\"BrtBeginSxvcells\",f:parsenoop},2056:{n:\"BrtEndSxvcells\",f:parsenoop},2057:{n:\"BrtBeginSxRow\",f:parsenoop},2058:{n:\"BrtEndSxRow\",f:parsenoop},2060:{n:\"BrtPcdCalcMem15\",f:parsenoop},2067:{n:\"BrtQsi15\",f:parsenoop},2068:{n:\"BrtBeginWebExtensions\",f:parsenoop},2069:{n:\"BrtEndWebExtensions\",f:parsenoop},2070:{n:\"BrtWebExtension\",f:parsenoop},2071:{n:\"BrtAbsPath15\",f:parsenoop},2072:{n:\"BrtBeginPivotTableUISettings\",f:parsenoop},2073:{n:\"BrtEndPivotTableUISettings\",f:parsenoop},2075:{n:\"BrtTableSlicerCacheIDs\",f:parsenoop},2076:{n:\"BrtTableSlicerCacheID\",f:parsenoop},2077:{n:\"BrtBeginTableSlicerCache\",f:parsenoop},2078:{n:\"BrtEndTableSlicerCache\",f:parsenoop},2079:{n:\"BrtSxFilter15\",f:parsenoop},2080:{n:\"BrtBeginTimelineCachePivotCacheIDs\",f:parsenoop},2081:{n:\"BrtEndTimelineCachePivotCacheIDs\",f:parsenoop},2082:{n:\"BrtTimelineCachePivotCacheID\",f:parsenoop},2083:{n:\"BrtBeginTimelineCacheIDs\",f:parsenoop},2084:{n:\"BrtEndTimelineCacheIDs\",f:parsenoop},2085:{n:\"BrtBeginTimelineCacheID\",f:parsenoop},2086:{n:\"BrtEndTimelineCacheID\",f:parsenoop},2087:{n:\"BrtBeginTimelinesEx\",f:parsenoop},2088:{n:\"BrtEndTimelinesEx\",f:parsenoop},2089:{n:\"BrtBeginTimelineEx\",f:parsenoop},2090:{n:\"BrtEndTimelineEx\",f:parsenoop},2091:{n:\"BrtWorkBookPr15\",f:parsenoop},2092:{n:\"BrtPCDH15\",f:parsenoop},2093:{n:\"BrtBeginTimelineStyle\",f:parsenoop},2094:{n:\"BrtEndTimelineStyle\",f:parsenoop},2095:{n:\"BrtTimelineStyleElement\",f:parsenoop},2096:{n:\"BrtBeginTimelineStylesheetExt15\",f:parsenoop},2097:{n:\"BrtEndTimelineStylesheetExt15\",f:parsenoop},2098:{n:\"BrtBeginTimelineStyles\",f:parsenoop},2099:{n:\"BrtEndTimelineStyles\",f:parsenoop},2100:{n:\"BrtBeginTimelineStyleElements\",f:parsenoop},2101:{n:\"BrtEndTimelineStyleElements\",f:parsenoop},2102:{n:\"BrtDxf15\",f:parsenoop},2103:{n:\"BrtBeginDxfs15\",f:parsenoop},2104:{n:\"brtEndDxfs15\",f:parsenoop},2105:{n:\"BrtSlicerCacheHideItemsWithNoData\",f:parsenoop},2106:{n:\"BrtBeginItemUniqueNames\",f:parsenoop},2107:{n:\"BrtEndItemUniqueNames\",f:parsenoop},2108:{n:\"BrtItemUniqueName\",f:parsenoop},2109:{n:\"BrtBeginExtConn15\",f:parsenoop},2110:{n:\"BrtEndExtConn15\",f:parsenoop},2111:{n:\"BrtBeginOledbPr15\",f:parsenoop},2112:{n:\"BrtEndOledbPr15\",f:parsenoop},2113:{n:\"BrtBeginDataFeedPr15\",f:parsenoop},2114:{n:\"BrtEndDataFeedPr15\",f:parsenoop},2115:{n:\"BrtTextPr15\",f:parsenoop},2116:{n:\"BrtRangePr15\",f:parsenoop},2117:{n:\"BrtDbCommand15\",f:parsenoop},2118:{n:\"BrtBeginDbTables15\",f:parsenoop},2119:{n:\"BrtEndDbTables15\",f:parsenoop},2120:{n:\"BrtDbTable15\",f:parsenoop},2121:{n:\"BrtBeginDataModel\",f:parsenoop},2122:{n:\"BrtEndDataModel\",f:parsenoop},2123:{n:\"BrtBeginModelTables\",f:parsenoop},2124:{n:\"BrtEndModelTables\",f:parsenoop},2125:{n:\"BrtModelTable\",f:parsenoop},2126:{n:\"BrtBeginModelRelationships\",f:parsenoop},2127:{n:\"BrtEndModelRelationships\",f:parsenoop},2128:{n:\"BrtModelRelationship\",f:parsenoop},2129:{n:\"BrtBeginECTxtWiz15\",f:parsenoop},2130:{n:\"BrtEndECTxtWiz15\",f:parsenoop},2131:{n:\"BrtBeginECTWFldInfoLst15\",f:parsenoop},2132:{n:\"BrtEndECTWFldInfoLst15\",f:parsenoop},2133:{n:\"BrtBeginECTWFldInfo15\",f:parsenoop},2134:{n:\"BrtFieldListActiveItem\",f:parsenoop},2135:{n:\"BrtPivotCacheIdVersion\",f:parsenoop},2136:{n:\"BrtSXDI15\",f:parsenoop},65535:{n:\"\",f:parsenoop}};\nvar evert_RE=evert_key(XLSBRecordEnum,\"n\");var XLSRecordEnum={3:{n:\"BIFF2NUM\",f:parse_BIFF2NUM},4:{n:\"BIFF2STR\",f:parse_BIFF2STR},6:{n:\"Formula\",f:parse_Formula},9:{n:\"BOF\",f:parse_BOF},10:{n:\"EOF\",f:parse_EOF},12:{n:\"CalcCount\",f:parse_CalcCount},13:{n:\"CalcMode\",f:parse_CalcMode},14:{n:\"CalcPrecision\",f:parse_CalcPrecision},15:{n:\"CalcRefMode\",f:parse_CalcRefMode},16:{n:\"CalcDelta\",f:parse_CalcDelta},17:{n:\"CalcIter\",f:parse_CalcIter},18:{n:\"Protect\",f:parse_Protect},19:{n:\"Password\",f:parse_Password},20:{n:\"Header\",f:parse_Header},21:{n:\"Footer\",f:parse_Footer},23:{n:\"ExternSheet\",f:parse_ExternSheet},24:{n:\"Lbl\",f:parse_Lbl},25:{n:\"WinProtect\",f:parse_WinProtect},26:{n:\"VerticalPageBreaks\",f:parse_VerticalPageBreaks},27:{n:\"HorizontalPageBreaks\",f:parse_HorizontalPageBreaks},28:{n:\"Note\",f:parse_Note},29:{n:\"Selection\",f:parse_Selection},34:{n:\"Date1904\",f:parse_Date1904},35:{n:\"ExternName\",f:parse_ExternName},38:{n:\"LeftMargin\",f:parse_LeftMargin},39:{n:\"RightMargin\",f:parse_RightMargin},40:{n:\"TopMargin\",f:parse_TopMargin},41:{n:\"BottomMargin\",f:parse_BottomMargin},42:{n:\"PrintRowCol\",f:parse_PrintRowCol},43:{n:\"PrintGrid\",f:parse_PrintGrid},47:{n:\"FilePass\",f:parse_FilePass},49:{n:\"Font\",f:parse_Font},51:{n:\"PrintSize\",f:parse_PrintSize},60:{n:\"Continue\",f:parse_Continue},61:{n:\"Window1\",f:parse_Window1},64:{n:\"Backup\",f:parse_Backup},65:{n:\"Pane\",f:parse_Pane},66:{n:\"CodePage\",f:parse_CodePage},77:{n:\"Pls\",f:parse_Pls},80:{n:\"DCon\",f:parse_DCon},81:{n:\"DConRef\",f:parse_DConRef},82:{n:\"DConName\",f:parse_DConName},85:{n:\"DefColWidth\",f:parse_DefColWidth},89:{n:\"XCT\",f:parse_XCT},90:{n:\"CRN\",f:parse_CRN},91:{n:\"FileSharing\",f:parse_FileSharing},92:{n:\"WriteAccess\",f:parse_WriteAccess},93:{n:\"Obj\",f:parse_Obj},94:{n:\"Uncalced\",f:parse_Uncalced},95:{n:\"CalcSaveRecalc\",f:parse_CalcSaveRecalc},96:{n:\"Template\",f:parse_Template},97:{n:\"Intl\",f:parse_Intl},99:{n:\"ObjProtect\",f:parse_ObjProtect},125:{n:\"ColInfo\",f:parse_ColInfo},128:{n:\"Guts\",f:parse_Guts},129:{n:\"WsBool\",f:parse_WsBool},130:{n:\"GridSet\",f:parse_GridSet},131:{n:\"HCenter\",f:parse_HCenter},132:{n:\"VCenter\",f:parse_VCenter},133:{n:\"BoundSheet8\",f:parse_BoundSheet8},134:{n:\"WriteProtect\",f:parse_WriteProtect},140:{n:\"Country\",f:parse_Country},141:{n:\"HideObj\",f:parse_HideObj},144:{n:\"Sort\",f:parse_Sort},146:{n:\"Palette\",f:parse_Palette},151:{n:\"Sync\",f:parse_Sync},152:{n:\"LPr\",f:parse_LPr},153:{n:\"DxGCol\",f:parse_DxGCol},154:{n:\"FnGroupName\",f:parse_FnGroupName},155:{n:\"FilterMode\",f:parse_FilterMode},156:{n:\"BuiltInFnGroupCount\",f:parse_BuiltInFnGroupCount},157:{n:\"AutoFilterInfo\",f:parse_AutoFilterInfo},158:{n:\"AutoFilter\",f:parse_AutoFilter},160:{n:\"Scl\",f:parse_Scl},161:{n:\"Setup\",f:parse_Setup},174:{n:\"ScenMan\",f:parse_ScenMan},175:{n:\"SCENARIO\",f:parse_SCENARIO},176:{n:\"SxView\",f:parse_SxView},177:{n:\"Sxvd\",f:parse_Sxvd},178:{n:\"SXVI\",f:parse_SXVI},180:{n:\"SxIvd\",f:parse_SxIvd},181:{n:\"SXLI\",f:parse_SXLI},182:{n:\"SXPI\",f:parse_SXPI},184:{n:\"DocRoute\",f:parse_DocRoute},185:{n:\"RecipName\",f:parse_RecipName},189:{n:\"MulRk\",f:parse_MulRk},190:{n:\"MulBlank\",f:parse_MulBlank},193:{n:\"Mms\",f:parse_Mms},197:{n:\"SXDI\",f:parse_SXDI},198:{n:\"SXDB\",f:parse_SXDB},199:{n:\"SXFDB\",f:parse_SXFDB},200:{n:\"SXDBB\",f:parse_SXDBB},201:{n:\"SXNum\",f:parse_SXNum},202:{n:\"SxBool\",f:parse_SxBool},203:{n:\"SxErr\",f:parse_SxErr},204:{n:\"SXInt\",f:parse_SXInt},205:{n:\"SXString\",f:parse_SXString},206:{n:\"SXDtr\",f:parse_SXDtr},207:{n:\"SxNil\",f:parse_SxNil},208:{n:\"SXTbl\",f:parse_SXTbl},209:{n:\"SXTBRGIITM\",f:parse_SXTBRGIITM},210:{n:\"SxTbpg\",f:parse_SxTbpg},211:{n:\"ObProj\",f:parse_ObProj},213:{n:\"SXStreamID\",f:parse_SXStreamID},215:{n:\"DBCell\",f:parse_DBCell},216:{n:\"SXRng\",f:parse_SXRng},217:{n:\"SxIsxoper\",f:parse_SxIsxoper},218:{n:\"BookBool\",f:parse_BookBool},220:{n:\"DbOrParamQry\",f:parse_DbOrParamQry},221:{n:\"ScenarioProtect\",f:parse_ScenarioProtect},222:{n:\"OleObjectSize\",f:parse_OleObjectSize},224:{n:\"XF\",f:parse_XF},225:{n:\"InterfaceHdr\",f:parse_InterfaceHdr},226:{n:\"InterfaceEnd\",f:parse_InterfaceEnd},227:{n:\"SXVS\",f:parse_SXVS},229:{n:\"MergeCells\",f:parse_MergeCells},233:{n:\"BkHim\",f:parse_BkHim},235:{n:\"MsoDrawingGroup\",f:parse_MsoDrawingGroup},236:{n:\"MsoDrawing\",f:parse_MsoDrawing},237:{n:\"MsoDrawingSelection\",f:parse_MsoDrawingSelection},239:{n:\"PhoneticInfo\",f:parse_PhoneticInfo},240:{n:\"SxRule\",f:parse_SxRule},241:{n:\"SXEx\",f:parse_SXEx},242:{n:\"SxFilt\",f:parse_SxFilt},244:{n:\"SxDXF\",f:parse_SxDXF},245:{n:\"SxItm\",f:parse_SxItm},246:{n:\"SxName\",f:parse_SxName},247:{n:\"SxSelect\",f:parse_SxSelect},248:{n:\"SXPair\",f:parse_SXPair},249:{n:\"SxFmla\",f:parse_SxFmla},251:{n:\"SxFormat\",f:parse_SxFormat},252:{n:\"SST\",f:parse_SST},253:{n:\"LabelSst\",f:parse_LabelSst},255:{n:\"ExtSST\",f:parse_ExtSST},256:{n:\"SXVDEx\",f:parse_SXVDEx},259:{n:\"SXFormula\",f:parse_SXFormula},290:{n:\"SXDBEx\",f:parse_SXDBEx},311:{n:\"RRDInsDel\",f:parse_RRDInsDel},312:{n:\"RRDHead\",f:parse_RRDHead},315:{n:\"RRDChgCell\",f:parse_RRDChgCell},317:{n:\"RRTabId\",f:parse_RRTabId},318:{n:\"RRDRenSheet\",f:parse_RRDRenSheet},319:{n:\"RRSort\",f:parse_RRSort},320:{n:\"RRDMove\",f:parse_RRDMove},330:{n:\"RRFormat\",f:parse_RRFormat},331:{n:\"RRAutoFmt\",f:parse_RRAutoFmt},333:{n:\"RRInsertSh\",f:parse_RRInsertSh},334:{n:\"RRDMoveBegin\",f:parse_RRDMoveBegin},335:{n:\"RRDMoveEnd\",f:parse_RRDMoveEnd},336:{n:\"RRDInsDelBegin\",f:parse_RRDInsDelBegin},337:{n:\"RRDInsDelEnd\",f:parse_RRDInsDelEnd},338:{n:\"RRDConflict\",f:parse_RRDConflict},339:{n:\"RRDDefName\",f:parse_RRDDefName},340:{n:\"RRDRstEtxp\",f:parse_RRDRstEtxp},351:{n:\"LRng\",f:parse_LRng},352:{n:\"UsesELFs\",f:parse_UsesELFs},353:{n:\"DSF\",f:parse_DSF},401:{n:\"CUsr\",f:parse_CUsr},402:{n:\"CbUsr\",f:parse_CbUsr},403:{n:\"UsrInfo\",f:parse_UsrInfo},404:{n:\"UsrExcl\",f:parse_UsrExcl},405:{n:\"FileLock\",f:parse_FileLock},406:{n:\"RRDInfo\",f:parse_RRDInfo},407:{n:\"BCUsrs\",f:parse_BCUsrs},408:{n:\"UsrChk\",f:parse_UsrChk},425:{n:\"UserBView\",f:parse_UserBView},426:{n:\"UserSViewBegin\",f:parse_UserSViewBegin},427:{n:\"UserSViewEnd\",f:parse_UserSViewEnd},428:{n:\"RRDUserView\",f:parse_RRDUserView},429:{n:\"Qsi\",f:parse_Qsi},430:{n:\"SupBook\",f:parse_SupBook},431:{n:\"Prot4Rev\",f:parse_Prot4Rev},432:{n:\"CondFmt\",f:parse_CondFmt},433:{n:\"CF\",f:parse_CF},434:{n:\"DVal\",f:parse_DVal},437:{n:\"DConBin\",f:parse_DConBin},438:{n:\"TxO\",f:parse_TxO},439:{n:\"RefreshAll\",f:parse_RefreshAll},440:{n:\"HLink\",f:parse_HLink},441:{n:\"Lel\",f:parse_Lel},442:{n:\"CodeName\",f:parse_XLSCodeName},443:{n:\"SXFDBType\",f:parse_SXFDBType},444:{n:\"Prot4RevPass\",f:parse_Prot4RevPass},445:{n:\"ObNoMacros\",f:parse_ObNoMacros},446:{n:\"Dv\",f:parse_Dv},448:{n:\"Excel9File\",f:parse_Excel9File},449:{n:\"RecalcId\",f:parse_RecalcId,r:2},450:{n:\"EntExU2\",f:parse_EntExU2},512:{n:\"Dimensions\",f:parse_Dimensions},513:{n:\"Blank\",f:parse_Blank},515:{n:\"Number\",f:parse_Number},516:{n:\"Label\",f:parse_Label},517:{n:\"BoolErr\",f:parse_BoolErr},519:{n:\"String\",f:parse_String},520:{n:\"Row\",f:parse_Row},523:{n:\"Index\",f:parse_Index},545:{n:\"Array\",f:parse_Array},549:{n:\"DefaultRowHeight\",f:parse_DefaultRowHeight},566:{n:\"Table\",f:parse_Table},574:{n:\"Window2\",f:parse_Window2},638:{n:\"RK\",f:parse_RK},659:{n:\"Style\",f:parse_Style},1048:{n:\"BigName\",f:parse_BigName},1054:{n:\"Format\",f:parse_Format},1084:{n:\"ContinueBigName\",f:parse_ContinueBigName},1212:{n:\"ShrFmla\",f:parse_ShrFmla},2048:{n:\"HLinkTooltip\",f:parse_HLinkTooltip},2049:{n:\"WebPub\",f:parse_WebPub},2050:{n:\"QsiSXTag\",f:parse_QsiSXTag},2051:{n:\"DBQueryExt\",f:parse_DBQueryExt},2052:{n:\"ExtString\",f:parse_ExtString},2053:{n:\"TxtQry\",f:parse_TxtQry},2054:{n:\"Qsir\",f:parse_Qsir},2055:{n:\"Qsif\",f:parse_Qsif},2056:{n:\"RRDTQSIF\",f:parse_RRDTQSIF},2057:{n:\"BOF\",f:parse_BOF},2058:{n:\"OleDbConn\",f:parse_OleDbConn},2059:{n:\"WOpt\",f:parse_WOpt},2060:{n:\"SXViewEx\",f:parse_SXViewEx},2061:{n:\"SXTH\",f:parse_SXTH},2062:{n:\"SXPIEx\",f:parse_SXPIEx},2063:{n:\"SXVDTEx\",f:parse_SXVDTEx},2064:{n:\"SXViewEx9\",f:parse_SXViewEx9},2066:{n:\"ContinueFrt\",f:parse_ContinueFrt},2067:{n:\"RealTimeData\",f:parse_RealTimeData},2128:{n:\"ChartFrtInfo\",f:parse_ChartFrtInfo},2129:{n:\"FrtWrapper\",f:parse_FrtWrapper},2130:{n:\"StartBlock\",f:parse_StartBlock},2131:{n:\"EndBlock\",f:parse_EndBlock},2132:{n:\"StartObject\",f:parse_StartObject},2133:{n:\"EndObject\",f:parse_EndObject},2134:{n:\"CatLab\",f:parse_CatLab},2135:{n:\"YMult\",f:parse_YMult},2136:{n:\"SXViewLink\",f:parse_SXViewLink},2137:{n:\"PivotChartBits\",f:parse_PivotChartBits},2138:{n:\"FrtFontList\",f:parse_FrtFontList},2146:{n:\"SheetExt\",f:parse_SheetExt},2147:{n:\"BookExt\",f:parse_BookExt,r:12},2148:{n:\"SXAddl\",f:parse_SXAddl},2149:{n:\"CrErr\",f:parse_CrErr},2150:{n:\"HFPicture\",f:parse_HFPicture},2151:{n:\"FeatHdr\",f:parse_FeatHdr},2152:{n:\"Feat\",f:parse_Feat},2154:{n:\"DataLabExt\",f:parse_DataLabExt},2155:{n:\"DataLabExtContents\",f:parse_DataLabExtContents},2156:{n:\"CellWatch\",f:parse_CellWatch},2161:{n:\"FeatHdr11\",f:parse_FeatHdr11},2162:{n:\"Feature11\",f:parse_Feature11},2164:{n:\"DropDownObjIds\",f:parse_DropDownObjIds},2165:{n:\"ContinueFrt11\",f:parse_ContinueFrt11},2166:{n:\"DConn\",f:parse_DConn},2167:{n:\"List12\",f:parse_List12},2168:{n:\"Feature12\",f:parse_Feature12},2169:{n:\"CondFmt12\",f:parse_CondFmt12},2170:{n:\"CF12\",f:parse_CF12},2171:{n:\"CFEx\",f:parse_CFEx},2172:{n:\"XFCRC\",f:parse_XFCRC,r:12},2173:{n:\"XFExt\",f:parse_XFExt,r:12},2174:{n:\"AutoFilter12\",f:parse_AutoFilter12},2175:{n:\"ContinueFrt12\",f:parse_ContinueFrt12},2180:{n:\"MDTInfo\",f:parse_MDTInfo},2181:{n:\"MDXStr\",f:parse_MDXStr},2182:{n:\"MDXTuple\",f:parse_MDXTuple},2183:{n:\"MDXSet\",f:parse_MDXSet},2184:{n:\"MDXProp\",f:parse_MDXProp},2185:{n:\"MDXKPI\",f:parse_MDXKPI},2186:{n:\"MDB\",f:parse_MDB},2187:{n:\"PLV\",f:parse_PLV},2188:{n:\"Compat12\",f:parse_Compat12,r:12},2189:{n:\"DXF\",f:parse_DXF},2190:{n:\"TableStyles\",f:parse_TableStyles,r:12},2191:{n:\"TableStyle\",f:parse_TableStyle},2192:{n:\"TableStyleElement\",f:parse_TableStyleElement},2194:{n:\"StyleExt\",f:parse_StyleExt},2195:{n:\"NamePublish\",f:parse_NamePublish},2196:{n:\"NameCmt\",f:parse_NameCmt},2197:{n:\"SortData\",f:parse_SortData},2198:{n:\"Theme\",f:parse_Theme,r:12},2199:{n:\"GUIDTypeLib\",f:parse_GUIDTypeLib},2200:{n:\"FnGrp12\",f:parse_FnGrp12},2201:{n:\"NameFnGrp12\",f:parse_NameFnGrp12},2202:{n:\"MTRSettings\",f:parse_MTRSettings,r:12},2203:{n:\"CompressPictures\",f:parse_CompressPictures},2204:{n:\"HeaderFooter\",f:parse_HeaderFooter},2205:{n:\"CrtLayout12\",f:parse_CrtLayout12},2206:{n:\"CrtMlFrt\",f:parse_CrtMlFrt},2207:{n:\"CrtMlFrtContinue\",f:parse_CrtMlFrtContinue},2211:{n:\"ForceFullCalculation\",f:parse_ForceFullCalculation},2212:{n:\"ShapePropsStream\",f:parse_ShapePropsStream},2213:{n:\"TextPropsStream\",f:parse_TextPropsStream},2214:{n:\"RichTextStream\",f:parse_RichTextStream},2215:{n:\"CrtLayout12A\",f:parse_CrtLayout12A},4097:{n:\"Units\",f:parse_Units},4098:{n:\"Chart\",f:parse_Chart},4099:{n:\"Series\",f:parse_Series},4102:{n:\"DataFormat\",f:parse_DataFormat},4103:{n:\"LineFormat\",f:parse_LineFormat},4105:{n:\"MarkerFormat\",f:parse_MarkerFormat},4106:{n:\"AreaFormat\",f:parse_AreaFormat},4107:{n:\"PieFormat\",f:parse_PieFormat},4108:{n:\"AttachedLabel\",f:parse_AttachedLabel},4109:{n:\"SeriesText\",f:parse_SeriesText},4116:{n:\"ChartFormat\",f:parse_ChartFormat},4117:{n:\"Legend\",f:parse_Legend},4118:{n:\"SeriesList\",f:parse_SeriesList},4119:{n:\"Bar\",f:parse_Bar},4120:{n:\"Line\",f:parse_Line},4121:{n:\"Pie\",f:parse_Pie},4122:{n:\"Area\",f:parse_Area},4123:{n:\"Scatter\",f:parse_Scatter},4124:{n:\"CrtLine\",f:parse_CrtLine},4125:{n:\"Axis\",f:parse_Axis},4126:{n:\"Tick\",f:parse_Tick},4127:{n:\"ValueRange\",f:parse_ValueRange},4128:{n:\"CatSerRange\",f:parse_CatSerRange},4129:{n:\"AxisLine\",f:parse_AxisLine},4130:{n:\"CrtLink\",f:parse_CrtLink},4132:{n:\"DefaultText\",f:parse_DefaultText},4133:{n:\"Text\",f:parse_Text},4134:{n:\"FontX\",f:parse_FontX},4135:{n:\"ObjectLink\",f:parse_ObjectLink},4146:{n:\"Frame\",f:parse_Frame},4147:{n:\"Begin\",f:parse_Begin},4148:{n:\"End\",f:parse_End},4149:{n:\"PlotArea\",f:parse_PlotArea},4154:{n:\"Chart3d\",f:parse_Chart3d},4156:{n:\"PicF\",f:parse_PicF},4157:{n:\"DropBar\",f:parse_DropBar},4158:{n:\"Radar\",f:parse_Radar},4159:{n:\"Surf\",f:parse_Surf},4160:{n:\"RadarArea\",f:parse_RadarArea},4161:{n:\"AxisParent\",f:parse_AxisParent},4163:{n:\"LegendException\",f:parse_LegendException},4164:{n:\"ShtProps\",f:parse_ShtProps},4165:{n:\"SerToCrt\",f:parse_SerToCrt},4166:{n:\"AxesUsed\",f:parse_AxesUsed},4168:{n:\"SBaseRef\",f:parse_SBaseRef},4170:{n:\"SerParent\",f:parse_SerParent},4171:{n:\"SerAuxTrend\",f:parse_SerAuxTrend},4174:{n:\"IFmtRecord\",f:parse_IFmtRecord},4175:{n:\"Pos\",f:parse_Pos},4176:{n:\"AlRuns\",f:parse_AlRuns},4177:{n:\"BRAI\",f:parse_BRAI},4187:{n:\"SerAuxErrBar\",f:parse_SerAuxErrBar},4188:{n:\"ClrtClient\",f:parse_ClrtClient},4189:{n:\"SerFmt\",f:parse_SerFmt},4191:{n:\"Chart3DBarShape\",f:parse_Chart3DBarShape},4192:{n:\"Fbi\",f:parse_Fbi},4193:{n:\"BopPop\",f:parse_BopPop},4194:{n:\"AxcExt\",f:parse_AxcExt},4195:{n:\"Dat\",f:parse_Dat},4196:{n:\"PlotGrowth\",f:parse_PlotGrowth},4197:{n:\"SIIndex\",f:parse_SIIndex},4198:{n:\"GelFrame\",f:parse_GelFrame},4199:{n:\"BopPopCustom\",f:parse_BopPopCustom},4200:{n:\"Fbi2\",f:parse_Fbi2},22:{n:\"ExternCount\",f:parsenoop},126:{n:\"RK\",f:parsenoop},127:{n:\"ImData\",f:parsenoop},135:{n:\"Addin\",f:parsenoop},136:{n:\"Edg\",f:parsenoop},137:{n:\"Pub\",f:parsenoop},145:{n:\"Sub\",f:parsenoop},148:{n:\"LHRecord\",f:parsenoop},149:{n:\"LHNGraph\",f:parsenoop},150:{n:\"Sound\",f:parsenoop},169:{n:\"CoordList\",f:parsenoop},171:{n:\"GCW\",f:parsenoop},188:{n:\"ShrFmla\",f:parsenoop},194:{n:\"AddMenu\",f:parsenoop},195:{n:\"DelMenu\",f:parsenoop},214:{n:\"RString\",f:parsenoop},223:{n:\"UDDesc\",f:parsenoop},234:{n:\"TabIdConf\",f:parsenoop},354:{n:\"XL5Modify\",f:parsenoop},421:{n:\"FileSharing2\",f:parsenoop},536:{n:\"Name\",f:parsenoop},547:{n:\"ExternName\",f:parse_ExternName},561:{n:\"Font\",f:parsenoop},1030:{n:\"Formula\",f:parse_Formula},2157:{n:\"FeatInfo\",f:parsenoop},2163:{n:\"FeatInfo11\",f:parsenoop},2177:{n:\"SXAddl12\",f:parsenoop},2240:{n:\"AutoWebPub\",f:parsenoop},2241:{n:\"ListObj\",f:parsenoop},2242:{n:\"ListField\",f:parsenoop},2243:{n:\"ListDV\",f:parsenoop},2244:{n:\"ListCondFmt\",f:parsenoop},2245:{n:\"ListCF\",f:parsenoop},2246:{n:\"FMQry\",f:parsenoop},2247:{n:\"FMSQry\",f:parsenoop},2248:{n:\"PLV\",f:parsenoop},2249:{n:\"LnExt\",f:parsenoop},2250:{n:\"MkrExt\",f:parsenoop},2251:{n:\"CrtCoopt\",f:parsenoop},0:{}};function parse_ods(zip,opts){if(typeof module!==\"undefined\"&&typeof require!==\"undefined\"&&typeof ODS===\"undefined\")ODS=require(\"./od\"+\"s\");if(typeof ODS===\"undefined\"||!ODS.parse_ods)throw new Error(\"Unsupported ODS\");return ODS.parse_ods(zip,opts)}function fix_opts_func(defaults){return function fix_opts(opts){for(var i=0;i!=defaults.length;++i){var d=defaults[i];if(opts[d[0]]===undefined)opts[d[0]]=d[1];if(d[2]===\"n\")opts[d[0]]=Number(opts[d[0]])}}}var fix_read_opts=fix_opts_func([[\"cellNF\",false],[\"cellHTML\",true],[\"cellFormula\",true],[\"cellStyles\",false],[\"cellDates\",false],[\"sheetStubs\",false],[\"sheetRows\",0,\"n\"],[\"bookDeps\",false],[\"bookSheets\",false],[\"bookProps\",false],[\"bookFiles\",false],[\"bookVBA\",false],[\"password\",\"\"],[\"WTF\",false]]);var fix_write_opts=fix_opts_func([[\"cellDates\",false],[\"bookSST\",false],[\"bookType\",\"xlsx\"],[\"WTF\",false]]);function safe_parse_wbrels(wbrels,sheets){if(!wbrels)return 0;try{wbrels=sheets.map(function pwbr(w){return[w.name,wbrels[\"!id\"][w.id].Target]})}catch(e){return null}return!wbrels||wbrels.length===0?null:wbrels}function safe_parse_ws(zip,path,relsPath,sheet,sheetRels,sheets,opts){try{sheetRels[sheet]=parse_rels(getzipdata(zip,relsPath,true),path);sheets[sheet]=parse_ws(getzipdata(zip,path),path,opts,sheetRels[sheet])}catch(e){if(opts.WTF)throw e}}var nodirs=function nodirs(x){return x.substr(-1)!=\"/\"};function parse_zip(zip,opts){make_ssf(SSF);opts=opts||{};fix_read_opts(opts);reset_cp();if(safegetzipfile(zip,\"META-INF/manifest.xml\"))return parse_ods(zip,opts);var entries=keys(zip.files).filter(nodirs).sort();var dir=parse_ct(getzipdata(zip,\"[Content_Types].xml\"),opts);var xlsb=false;var sheets,binname;if(dir.workbooks.length===0){binname=\"xl/workbook.xml\";if(getzipdata(zip,binname,true))dir.workbooks.push(binname)}if(dir.workbooks.length===0){binname=\"xl/workbook.bin\";if(!getzipfile(zip,binname,true))throw new Error(\"Could not find workbook\");dir.workbooks.push(binname);xlsb=true}if(dir.workbooks[0].substr(-3)==\"bin\")xlsb=true;if(xlsb)set_cp(1200);if(!opts.bookSheets&&!opts.bookProps){strs=[];if(dir.sst)strs=parse_sst(getzipdata(zip,dir.sst.replace(/^\\//,\"\")),dir.sst,opts);styles={};if(dir.style)styles=parse_sty(getzipdata(zip,dir.style.replace(/^\\//,\"\")),dir.style,opts);themes={};if(opts.cellStyles&&dir.themes.length)themes=parse_theme(getzipdata(zip,dir.themes[0].replace(/^\\//,\"\"),true),dir.themes[0],opts)}var wb=parse_wb(getzipdata(zip,dir.workbooks[0].replace(/^\\//,\"\")),dir.workbooks[0],opts);var props={},propdata=\"\";if(dir.coreprops.length!==0){propdata=getzipdata(zip,dir.coreprops[0].replace(/^\\//,\"\"),true);if(propdata)props=parse_core_props(propdata);if(dir.extprops.length!==0){propdata=getzipdata(zip,dir.extprops[0].replace(/^\\//,\"\"),true);if(propdata)parse_ext_props(propdata,props)}}var custprops={};if(!opts.bookSheets||opts.bookProps){if(dir.custprops.length!==0){propdata=getzipdata(zip,dir.custprops[0].replace(/^\\//,\"\"),true);if(propdata)custprops=parse_cust_props(propdata,opts)}}var out={};if(opts.bookSheets||opts.bookProps){if(props.Worksheets&&props.SheetNames.length>0)sheets=props.SheetNames;else if(wb.Sheets)sheets=wb.Sheets.map(function pluck(x){return x.name});if(opts.bookProps){out.Props=props;out.Custprops=custprops}if(typeof sheets!==\"undefined\")out.SheetNames=sheets;if(opts.bookSheets?out.SheetNames:opts.bookProps)return out}sheets={};var deps={};if(opts.bookDeps&&dir.calcchain)deps=parse_cc(getzipdata(zip,dir.calcchain.replace(/^\\//,\"\")),dir.calcchain,opts);var i=0;var sheetRels={};var path,relsPath;if(!props.Worksheets){var wbsheets=wb.Sheets;props.Worksheets=wbsheets.length;props.SheetNames=[];for(var j=0;j!=wbsheets.length;++j){props.SheetNames[j]=wbsheets[j].name}}var wbext=xlsb?\"bin\":\"xml\";var wbrelsfile=\"xl/_rels/workbook.\"+wbext+\".rels\";var wbrels=parse_rels(getzipdata(zip,wbrelsfile,true),wbrelsfile);if(wbrels)wbrels=safe_parse_wbrels(wbrels,wb.Sheets);var nmode=getzipdata(zip,\"xl/worksheets/sheet.xml\",true)?1:0;for(i=0;i!=props.Worksheets;++i){if(wbrels)path=\"xl/\"+wbrels[i][1].replace(/[\\/]?xl\\//,\"\");else{path=\"xl/worksheets/sheet\"+(i+1-nmode)+\".\"+wbext;path=path.replace(/sheet0\\./,\"sheet.\")}relsPath=path.replace(/^(.*)(\\/)([^\\/]*)$/,\"$1/_rels/$3.rels\");safe_parse_ws(zip,path,relsPath,props.SheetNames[i],sheetRels,sheets,opts)}if(dir.comments)parse_comments(zip,dir.comments,sheets,sheetRels,opts);out={Directory:dir,Workbook:wb,Props:props,Custprops:custprops,Deps:deps,Sheets:sheets,SheetNames:props.SheetNames,Strings:strs,Styles:styles,Themes:themes,SSF:SSF.get_table()};if(opts.bookFiles){out.keys=entries;out.files=zip.files}if(opts.bookVBA){if(dir.vba.length>0)out.vbaraw=getzipdata(zip,dir.vba[0],true);else if(dir.defaults.bin===\"application/vnd.ms-office.vbaProject\")out.vbaraw=getzipdata(zip,\"xl/vbaProject.bin\",true)}return out}function add_rels(rels,rId,f,type,relobj){if(!relobj)relobj={};if(!rels[\"!id\"])rels[\"!id\"]={};relobj.Id=\"rId\"+rId;relobj.Type=type;relobj.Target=f;if(rels[\"!id\"][relobj.Id])throw new Error(\"Cannot rewrite rId \"+rId);rels[\"!id\"][relobj.Id]=relobj;rels[(\"/\"+relobj.Target).replace(\"//\",\"/\")]=relobj}function write_zip(wb,opts){if(wb&&!wb.SSF){wb.SSF=SSF.get_table()}if(wb&&wb.SSF){make_ssf(SSF);SSF.load_table(wb.SSF);opts.revssf=evert_num(wb.SSF);opts.revssf[wb.SSF[65535]]=0}opts.rels={};opts.wbrels={};opts.Strings=[];opts.Strings.Count=0;opts.Strings.Unique=0;var wbext=opts.bookType==\"xlsb\"?\"bin\":\"xml\";var ct={workbooks:[],sheets:[],calcchains:[],themes:[],styles:[],coreprops:[],extprops:[],custprops:[],strs:[],comments:[],vba:[],TODO:[],rels:[],xmlns:\"\"};fix_write_opts(opts=opts||{});var zip=new jszip;var f=\"\",rId=0;opts.cellXfs=[];get_cell_style(opts.cellXfs,{},{revssf:{General:0}});f=\"docProps/core.xml\";zip.file(f,write_core_props(wb.Props,opts));ct.coreprops.push(f);add_rels(opts.rels,2,f,RELS.CORE_PROPS);f=\"docProps/app.xml\";if(!wb.Props)wb.Props={};wb.Props.SheetNames=wb.SheetNames;wb.Props.Worksheets=wb.SheetNames.length;zip.file(f,write_ext_props(wb.Props,opts));ct.extprops.push(f);add_rels(opts.rels,3,f,RELS.EXT_PROPS);if(wb.Custprops!==wb.Props&&keys(wb.Custprops||{}).length>0){f=\"docProps/custom.xml\";zip.file(f,write_cust_props(wb.Custprops,opts));ct.custprops.push(f);add_rels(opts.rels,4,f,RELS.CUST_PROPS)}f=\"xl/workbook.\"+wbext;zip.file(f,write_wb(wb,f,opts));ct.workbooks.push(f);add_rels(opts.rels,1,f,RELS.WB);for(rId=1;rId<=wb.SheetNames.length;++rId){f=\"xl/worksheets/sheet\"+rId+\".\"+wbext;zip.file(f,write_ws(rId-1,f,opts,wb));ct.sheets.push(f);add_rels(opts.wbrels,rId,\"worksheets/sheet\"+rId+\".\"+wbext,RELS.WS)}if(opts.Strings!=null&&opts.Strings.length>0){f=\"xl/sharedStrings.\"+wbext;zip.file(f,write_sst(opts.Strings,f,opts));ct.strs.push(f);add_rels(opts.wbrels,++rId,\"sharedStrings.\"+wbext,RELS.SST)}f=\"xl/theme/theme1.xml\";zip.file(f,write_theme());ct.themes.push(f);add_rels(opts.wbrels,++rId,\"theme/theme1.xml\",RELS.THEME);f=\"xl/styles.\"+wbext;zip.file(f,write_sty(wb,f,opts));ct.styles.push(f);add_rels(opts.wbrels,++rId,\"styles.\"+wbext,RELS.STY);zip.file(\"[Content_Types].xml\",write_ct(ct,opts));zip.file(\"_rels/.rels\",write_rels(opts.rels));zip.file(\"xl/_rels/workbook.\"+wbext+\".rels\",write_rels(opts.wbrels));return zip}function firstbyte(f,o){switch((o||{}).type||\"base64\"){case\"buffer\":return f[0];case\"base64\":return Base64.decode(f.substr(0,12)).charCodeAt(0);case\"binary\":return f.charCodeAt(0);case\"array\":return f[0];default:throw new Error(\"Unrecognized type \"+o.type)}}function read_zip(data,opts){var zip,d=data;var o=opts||{};if(!o.type)o.type=has_buf&&Buffer.isBuffer(data)?\"buffer\":\"base64\";switch(o.type){case\"base64\":zip=new jszip(d,{base64:true});break;case\"binary\":case\"array\":zip=new jszip(d,{base64:false});break;case\"buffer\":zip=new jszip(d);break;case\"file\":zip=new jszip(d=_fs.readFileSync(data));break;default:throw new Error(\"Unrecognized type \"+o.type)}return parse_zip(zip,o)}function readSync(data,opts){var zip,d=data,isfile=false,n;var o=opts||{};if(!o.type)o.type=has_buf&&Buffer.isBuffer(data)?\"buffer\":\"base64\";if(o.type==\"file\"){isfile=true;o.type=\"buffer\";d=_fs.readFileSync(data)}switch(n=firstbyte(d,o)){case 208:if(isfile)o.type=\"file\";return parse_xlscfb(CFB.read(data,o),o);case 9:return parse_xlscfb(s2a(o.type===\"base64\"?Base64.decode(data):data),o);case 60:return parse_xlml(d,o);case 80:if(isfile)o.type=\"file\";return read_zip(data,opts);default:throw new Error(\"Unsupported file \"+n)}}function readFileSync(data,opts){var o=opts||{};o.type=\"file\";return readSync(data,o)}function write_zip_type(wb,opts){var o=opts||{};var z=write_zip(wb,o);switch(o.type){case\"base64\":return z.generate({type:\"base64\"});case\"binary\":return z.generate({type:\"string\"});case\"buffer\":return z.generate({type:\"nodebuffer\"});case\"file\":return _fs.writeFileSync(o.file,z.generate({type:\"nodebuffer\"}));default:throw new Error(\"Unrecognized type \"+o.type)}}function writeSync(wb,opts){var o=opts||{};switch(o.bookType){case\"xml\":return write_xlml(wb,o);default:return write_zip_type(wb,o)}}function writeFileSync(wb,filename,opts){var o=opts||{};o.type=\"file\";o.file=filename;switch(o.file.substr(-5).toLowerCase()){case\".xlsx\":o.bookType=\"xlsx\";break;case\".xlsm\":o.bookType=\"xlsm\";break;case\".xlsb\":o.bookType=\"xlsb\";break;default:switch(o.file.substr(-4).toLowerCase()){case\".xls\":o.bookType=\"xls\";break;case\".xml\":o.bookType=\"xml\";break}}return writeSync(wb,o)}function decode_row(rowstr){return parseInt(unfix_row(rowstr),10)-1}function encode_row(row){return\"\"+(row+1)}function fix_row(cstr){return cstr.replace(/([A-Z]|^)(\\d+)$/,\"$1$$$2\")}function unfix_row(cstr){return cstr.replace(/\\$(\\d+)$/,\"$1\")}function decode_col(colstr){var c=unfix_col(colstr),d=0,i=0;for(;i!==c.length;++i)d=26*d+c.charCodeAt(i)-64;return d-1}function encode_col(col){var s=\"\";for(++col;col;col=Math.floor((col-1)/26))s=String.fromCharCode((col-1)%26+65)+s;return s}function fix_col(cstr){return cstr.replace(/^([A-Z])/,\"$$$1\")}function unfix_col(cstr){return cstr.replace(/^\\$([A-Z])/,\"$1\")}function split_cell(cstr){return cstr.replace(/(\\$?[A-Z]*)(\\$?\\d*)/,\"$1,$2\").split(\",\")}function decode_cell(cstr){var splt=split_cell(cstr);return{c:decode_col(splt[0]),r:decode_row(splt[1])}}function encode_cell(cell){return encode_col(cell.c)+encode_row(cell.r)}function fix_cell(cstr){return fix_col(fix_row(cstr))}function unfix_cell(cstr){return unfix_col(unfix_row(cstr))}function decode_range(range){var x=range.split(\":\").map(decode_cell);return{s:x[0],e:x[x.length-1]}}function encode_range(cs,ce){if(ce===undefined||typeof ce===\"number\")return encode_range(cs.s,cs.e);if(typeof cs!==\"string\")cs=encode_cell(cs);if(typeof ce!==\"string\")ce=encode_cell(ce);return cs==ce?cs:cs+\":\"+ce}function safe_decode_range(range){var o={s:{c:0,r:0},e:{c:0,r:0}};var idx=0,i=0,cc=0;var len=range.length;for(idx=0;i<len;++i){if((cc=range.charCodeAt(i)-64)<1||cc>26)break;idx=26*idx+cc}o.s.c=--idx;for(idx=0;i<len;++i){if((cc=range.charCodeAt(i)-48)<0||cc>9)break;idx=10*idx+cc}o.s.r=--idx;if(i===len||range.charCodeAt(++i)===58){o.e.c=o.s.c;o.e.r=o.s.r;return o}for(idx=0;i!=len;++i){if((cc=range.charCodeAt(i)-64)<1||cc>26)break;idx=26*idx+cc}o.e.c=--idx;for(idx=0;i!=len;++i){if((cc=range.charCodeAt(i)-48)<0||cc>9)break;idx=10*idx+cc}o.e.r=--idx;return o}function safe_format_cell(cell,v){if(cell.z!==undefined)try{return cell.w=SSF.format(cell.z,v)}catch(e){}if(!cell.XF)return v;try{return cell.w=SSF.format(cell.XF.ifmt||0,v)}catch(e){return\"\"+v}}function format_cell(cell,v){if(cell==null||cell.t==null)return\"\";if(cell.w!==undefined)return cell.w;if(v===undefined)return safe_format_cell(cell,cell.v);return safe_format_cell(cell,v)}function sheet_to_json(sheet,opts){var val,row,range,header=0,offset=1,r,hdr=[],isempty,R,C,v;var o=opts!=null?opts:{};var raw=o.raw;if(sheet==null||sheet[\"!ref\"]==null)return[];range=o.range!==undefined?o.range:sheet[\"!ref\"];if(o.header===1)header=1;else if(o.header===\"A\")header=2;else if(Array.isArray(o.header))header=3;switch(typeof range){case\"string\":r=safe_decode_range(range);break;case\"number\":r=safe_decode_range(sheet[\"!ref\"]);r.s.r=range;break;default:r=range}if(header>0)offset=0;var rr=encode_row(r.s.r);var cols=new Array(r.e.c-r.s.c+1);var out=new Array(r.e.r-r.s.r-offset+1);var outi=0;for(C=r.s.c;C<=r.e.c;++C){cols[C]=encode_col(C);val=sheet[cols[C]+rr];switch(header){case 1:hdr[C]=C;break;case 2:hdr[C]=cols[C];break;case 3:hdr[C]=o.header[C-r.s.c];break;default:if(val===undefined)continue;hdr[C]=format_cell(val)}}for(R=r.s.r+offset;R<=r.e.r;++R){rr=encode_row(R);isempty=true;if(header===1)row=[];else{row={};if(Object.defineProperty)Object.defineProperty(row,\"__rowNum__\",{value:R,enumerable:false});else row.__rowNum__=R}for(C=r.s.c;C<=r.e.c;++C){val=sheet[cols[C]+rr];if(val===undefined||val.t===undefined)continue;v=val.v;switch(val.t){case\"e\":continue;case\"s\":break;case\"b\":case\"n\":break;default:throw\"unrecognized type \"+val.t}if(v!==undefined){row[hdr[C]]=raw?v:format_cell(val,v);isempty=false}}if(isempty===false||header===1)out[outi++]=row}out.length=outi;return out}function sheet_to_row_object_array(sheet,opts){return sheet_to_json(sheet,opts!=null?opts:{})}function sheet_to_csv(sheet,opts){var out=\"\",txt=\"\",qreg=/\"/g;var o=opts==null?{}:opts;if(sheet==null||sheet[\"!ref\"]==null)return\"\";var r=safe_decode_range(sheet[\"!ref\"]);var FS=o.FS!==undefined?o.FS:\",\",fs=FS.charCodeAt(0);var RS=o.RS!==undefined?o.RS:\"\\n\",rs=RS.charCodeAt(0);var row=\"\",rr=\"\",cols=[];var i=0,cc=0,val;var R=0,C=0;for(C=r.s.c;C<=r.e.c;++C)cols[C]=encode_col(C);for(R=r.s.r;R<=r.e.r;++R){row=\"\";rr=encode_row(R);for(C=r.s.c;C<=r.e.c;++C){val=sheet[cols[C]+rr];txt=val!==undefined?\"\"+format_cell(val):\"\";for(i=0,cc=0;i!==txt.length;++i)if((cc=txt.charCodeAt(i))===fs||cc===rs||cc===34){txt='\"'+txt.replace(qreg,'\"\"')+'\"';break}row+=(C===r.s.c?\"\":FS)+txt}out+=row+RS}return out}var make_csv=sheet_to_csv;function sheet_to_formulae(sheet){var cmds,y=\"\",x,val=\"\";if(sheet==null||sheet[\"!ref\"]==null)return\"\";var r=safe_decode_range(sheet[\"!ref\"]),rr=\"\",cols=[],C;cmds=new Array((r.e.r-r.s.r+1)*(r.e.c-r.s.c+1));var i=0;for(C=r.s.c;C<=r.e.c;++C)cols[C]=encode_col(C);for(var R=r.s.r;R<=r.e.r;++R){rr=encode_row(R);for(C=r.s.c;C<=r.e.c;++C){y=cols[C]+rr;x=sheet[y];val=\"\";if(x===undefined)continue;if(x.f!=null)val=x.f;else if(x.w!==undefined)val=\"'\"+x.w;else if(x.v===undefined)continue;else val=\"\"+x.v;cmds[i++]=y+\"=\"+val}}cmds.length=i;return cmds}var utils={encode_col:encode_col,encode_row:encode_row,encode_cell:encode_cell,encode_range:encode_range,decode_col:decode_col,decode_row:decode_row,split_cell:split_cell,decode_cell:decode_cell,decode_range:decode_range,format_cell:format_cell,get_formulae:sheet_to_formulae,make_csv:sheet_to_csv,make_json:sheet_to_json,make_formulae:sheet_to_formulae,sheet_to_csv:sheet_to_csv,sheet_to_json:sheet_to_json,sheet_to_formulae:sheet_to_formulae,sheet_to_row_object_array:sheet_to_row_object_array};XLSX.parse_xlscfb=parse_xlscfb;XLSX.parse_zip=parse_zip;XLSX.read=readSync;XLSX.readFile=readFileSync;XLSX.readFileSync=readFileSync;XLSX.write=writeSync;XLSX.writeFile=writeFileSync;XLSX.writeFileSync=writeFileSync;XLSX.utils=utils;XLSX.CFB=CFB;XLSX.SSF=SSF})(typeof exports!==\"undefined\"?exports:XLSX);var XLS=XLSX;","Amasty_Reports/amcharts/plugins/export/lang/pt.js":"/*\n ** Vers\u00e3o em Portugu\u00eas\n ** Traduzido por \u00c9lton Reisdorfer\n ** WebSite: http://eltonrst.tk\n ** Facebook : http://facebook.com/elton.reisdorfer\n */\nAmCharts.translations[\"export\"][\"pt\"] = {\n    \"fallback.save.text\": \"CTRL + C para copiar os dados para a \u00e1rea de transfer\u00eancia.\",\n    \"fallback.save.image\": \"Clique Direito -> Salvar imagem como... para salvar a imagem.\",\n\n    \"capturing.delayed.menu.label\": \"{{duration}}\",\n    \"capturing.delayed.menu.title\": \"Clique para cancelar\",\n\n    \"menu.label.print\": \"Imprimir\",\n    \"menu.label.undo\": \"Desfazer\",\n    \"menu.label.redo\": \"Refazer\",\n    \"menu.label.cancel\": \"Cancelar\",\n\n    \"menu.label.save.image\": \"Baixar Como\",\n    \"menu.label.save.data\": \"Salvar Como\",\n\n    \"menu.label.draw\": \"Editar\",\n    \"menu.label.draw.change\": \"Alterar\",\n    \"menu.label.draw.add\": \"Adicionar\",\n    \"menu.label.draw.shapes\": \"Forma\",\n    \"menu.label.draw.colors\": \"Cor\",\n    \"menu.label.draw.widths\": \"Tamanho\",\n    \"menu.label.draw.opacities\": \"Tranpar\u00eancia\",\n    \"menu.label.draw.text\": \"Texto\",\n\n    \"menu.label.draw.modes\": \"Ferramenta\",\n    \"menu.label.draw.modes.pencil\": \"Pincel\",\n    \"menu.label.draw.modes.line\": \"Linha\",\n    \"menu.label.draw.modes.arrow\": \"Seta\",\n\n    \"label.saved.from\": \"Salvar de: \"\n}\n","Amasty_Reports/amcharts/plugins/export/lang/de.js":"AmCharts.translations[ \"export\" ][ \"de\" ] = {\n\t\"fallback.save.text\": \"CTRL + C um die Daten in die Zwischenablage zu kopieren.\",\n\t\"fallback.save.image\": \"Rechtsklick -> Bild speichern unter... um das Bild zu speichern.\",\n\n\t\"capturing.delayed.menu.label\": \"{{duration}}\",\n\t\"capturing.delayed.menu.title\": \"Klicken zum Abbrechen.\",\n\n\t\"menu.label.print\": \"Drucken\",\n\t\"menu.label.undo\": \"R\u00fcckg\u00e4ngig\",\n\t\"menu.label.redo\": \"Wiederherstellen\",\n\t\"menu.label.cancel\": \"Abbrechen\",\n\n\t\"menu.label.save.image\": \"Herunterladen als ...\",\n\t\"menu.label.save.data\": \"Speichern als ...\",\n\n\t\"menu.label.draw\": \"Notieren ...\",\n\t\"menu.label.draw.change\": \"\u00c4ndern ...\",\n\t\"menu.label.draw.add\": \"Hinzuf\u00fcgen ...\",\n\t\"menu.label.draw.shapes\": \"Form ...\",\n\t\"menu.label.draw.colors\": \"Farbe ...\",\n\t\"menu.label.draw.widths\": \"Gr\u00f6\u00dfe ...\",\n\t\"menu.label.draw.opacities\": \"Deckkraft ...\",\n\t\"menu.label.draw.text\": \"Text\",\n\n\t\"menu.label.draw.modes\": \"Modus...\",\n\t\"menu.label.draw.modes.pencil\": \"Stift\",\n\t\"menu.label.draw.modes.line\": \"Linie\",\n\t\"menu.label.draw.modes.arrow\": \"Pfeil\",\n\n\t\"label.saved.from\": \"Gespeichert von: \"\n}","Amasty_Reports/amcharts/plugins/export/lang/fr.js":"AmCharts.translations[ \"export\" ][ \"fr\" ] = {\n    \"fallback.save.text\": \"CTRL + C pour copier dans le presse-papier.\",\n    \"fallback.save.image\": \"Clic-droit -> Enregistrer sous... pour sauvegarder l'image.\",\n\n    \"capturing.delayed.menu.label\": \"{{duration}}\",\n    \"capturing.delayed.menu.title\": \"Cliquez pour annuler\",\n\n    \"menu.label.print\": \"Imprimer\",\n    \"menu.label.undo\": \"Retour\",\n    \"menu.label.redo\": \"Refaire\",\n    \"menu.label.cancel\": \"Annuler\",\n\n    \"menu.label.save.image\": \"T\u00e9l\u00e9chargez en ...\",\n    \"menu.label.save.data\": \"Sauvegarder en ...\",\n\n    \"menu.label.draw\": \"Annoter ...\",\n    \"menu.label.draw.change\": \"Changer le ...\",\n    \"menu.label.draw.add\": \"Ajouter ...\",\n    \"menu.label.draw.shapes\": \"Formes ...\",\n    \"menu.label.draw.colors\": \"Couleurs ...\",\n    \"menu.label.draw.widths\": \"Taille ...\",\n    \"menu.label.draw.opacities\": \"Opacit\u00e9 ...\",\n    \"menu.label.draw.text\": \"Texte\",\n\n    \"menu.label.draw.modes\": \"Mode ...\",\n    \"menu.label.draw.modes.pencil\": \"Crayon\",\n    \"menu.label.draw.modes.line\": \"Ligne\",\n    \"menu.label.draw.modes.arrow\": \"Fl\u00e8che\",\n\n    \"label.saved.from\": \"Sauv\u00e9 de la: \"\n}\n","Amasty_Reports/amcharts/plugins/export/lang/cs.js":"AmCharts.translations[ \"export\" ][ \"cs\" ] = {\n\t\"fallback.save.text\": \"Stiskn\u011bte CTRL + C pro zkop\u00edrov\u00e1n\u00ed dat do schr\u00e1nky.\",\n\t\"fallback.save.image\": \"Klikn\u011bte prav\u00fdm tla\u010d\u00edtkem a zvolte Save picture as... k ulo\u017een\u00ed obr\u00e1zku.\",\n\n\t\"capturing.delayed.menu.label\": \"{{duration}}\",\n\t\"capturing.delayed.menu.title\": \"Kliknut\u00edm zru\u0161\u00edte\",\n\n\t\"menu.label.print\": \"Tisk\",\n\t\"menu.label.undo\": \"Zp\u011bt\",\n\t\"menu.label.redo\": \"Dop\u0159edu\",\n\t\"menu.label.cancel\": \"Zru\u0161it\",\n\n\t\"menu.label.save.image\": \"St\u00e1hnout obr\u00e1zek ...\",\n\t\"menu.label.save.data\": \"St\u00e1hnout data ...\",\n\n\t\"menu.label.draw\": \"Nakreslit ...\",\n\t\"menu.label.draw.change\": \"Zm\u011bnit ...\",\n\t\"menu.label.draw.add\": \"P\u0159idat ...\",\n\t\"menu.label.draw.shapes\": \"Tvar ...\",\n\t\"menu.label.draw.colors\": \"Barva ...\",\n\t\"menu.label.draw.widths\": \"Velikost ...\",\n\t\"menu.label.draw.opacities\": \"Pr\u016fhlednost ...\",\n\t\"menu.label.draw.text\": \"Text\",\n\n\t\"menu.label.draw.modes\": \"Re\u017eim kreslen\u00ed ...\",\n\t\"menu.label.draw.modes.pencil\": \"Tu\u017eka\",\n\t\"menu.label.draw.modes.line\": \"\u010c\u00e1ra\",\n\t\"menu.label.draw.modes.arrow\": \"\u0160ipka\",\n\n\t\"label.saved.from\": \"Ulo\u017eeno ze str\u00e1nky: \"\n}","Amasty_Reports/amcharts/plugins/export/lang/pl.js":"AmCharts.translations[ \"export\" ][ \"pl\" ] = {\n    \"fallback.save.text\": \"Naci\u015bnij CTRL + C by skopiowa\u0107 dane do schowka.\",\n    \"fallback.save.image\": \"Prawy przycisk myszy -> Zapisz obrazek jako... by zapisa\u0107 obrazek.\",\n\n    \"capturing.delayed.menu.label\": \"{{duration}}\",\n    \"capturing.delayed.menu.title\": \"Kliknij by anulowa\u0107\",\n\n    \"menu.label.print\": \"Drukuj\",\n    \"menu.label.undo\": \"Cofnij\",\n    \"menu.label.redo\": \"Przywr\u00f3\u0107\",\n    \"menu.label.cancel\": \"Anuluj\",\n\n    \"menu.label.save.image\": \"Pobierz jako ...\",\n    \"menu.label.save.data\": \"Zapisz jako ...\",\n\n    \"menu.label.draw\": \"Rysuj ...\",\n    \"menu.label.draw.change\": \"Zmie\u0144 ...\",\n    \"menu.label.draw.add\": \"Dodaj ...\",\n    \"menu.label.draw.shapes\": \"Kszta\u0142t ...\",\n    \"menu.label.draw.colors\": \"Kolor ...\",\n    \"menu.label.draw.widths\": \"Rozmiar ...\",\n    \"menu.label.draw.opacities\": \"Prze\u017aroczysto\u015b\u0107 ...\",\n    \"menu.label.draw.text\": \"Tekst\",\n\n    \"menu.label.draw.modes\": \"Tryb ...\",\n    \"menu.label.draw.modes.pencil\": \"O\u0142\u00f3wek\",\n    \"menu.label.draw.modes.line\": \"Linia\",\n    \"menu.label.draw.modes.arrow\": \"Strza\u0142ka\",\n\n    \"label.saved.from\": \"Ocali\u0107 od: \"\n}","Amasty_Reports/amcharts/plugins/export/lang/en.js":"AmCharts.translations[ \"export\" ][ \"en\" ] = {\n\t\"fallback.save.text\": \"CTRL + C to copy the data into the clipboard.\",\n\t\"fallback.save.image\": \"Rightclick -> Save picture as... to save the image.\",\n\n\t\"capturing.delayed.menu.label\": \"{{duration}}\",\n\t\"capturing.delayed.menu.title\": \"Click to cancel\",\n\n\t\"menu.label.print\": \"Print\",\n\t\"menu.label.undo\": \"Undo\",\n\t\"menu.label.redo\": \"Redo\",\n\t\"menu.label.cancel\": \"Cancel\",\n\n\t\"menu.label.save.image\": \"Download as ...\",\n\t\"menu.label.save.data\": \"Save as ...\",\n\n\t\"menu.label.draw\": \"Annotate ...\",\n\t\"menu.label.draw.change\": \"Change ...\",\n\t\"menu.label.draw.add\": \"Add ...\",\n\t\"menu.label.draw.shapes\": \"Shape ...\",\n\t\"menu.label.draw.colors\": \"Color ...\",\n\t\"menu.label.draw.widths\": \"Size ...\",\n\t\"menu.label.draw.opacities\": \"Opacity ...\",\n\t\"menu.label.draw.text\": \"Text\",\n\n\t\"menu.label.draw.modes\": \"Mode ...\",\n\t\"menu.label.draw.modes.pencil\": \"Pencil\",\n\t\"menu.label.draw.modes.line\": \"Line\",\n\t\"menu.label.draw.modes.arrow\": \"Arrow\",\n\n\t\"label.saved.from\": \"Saved from: \"\n}","Amasty_Reports/amcharts/plugins/export/lang/ko.js":"AmCharts.translations[ \"export\" ][ \"ko\" ] = {\n\t\"fallback.save.text\": \"CTRL + C \ub97c \ub20c\ub7ec \ud074\ub9bd\ubcf4\ub4dc\ub85c \ub370\uc774\ud130\ub97c \ubcf5\uc0ac\ud569\ub2c8\ub2e4.\",\n\t\"fallback.save.image\": \"\ub9c8\uc6b0\uc2a4 \uc624\ub978\ucabd \ud074\ub9ad -> \ub2e4\ub978 \uc774\ub984\uc73c\ub85c \uc800\uc7a5... \uc73c\ub85c \uc774\ubbf8\uc9c0\ub97c \uc800\uc7a5\ud569\ub2c8\ub2e4.\",\n\n\t\"capturing.delayed.menu.label\": \"{{duration}}\",\n\t\"capturing.delayed.menu.title\": \"\ucde8\uc18c\ud558\ub824\uba74 \ud074\ub9ad\",\n\n\t\"menu.label.print\": \"\ucd9c\ub825\",\n\t\"menu.label.undo\": \"\uc2e4\ud589 \ucde8\uc18c\",\n\t\"menu.label.redo\": \"\ub2e4\uc2dc \uc2e4\ud589\",\n\t\"menu.label.cancel\": \"\ucde8\uc18c\",\n\n\t\"menu.label.save.image\": \"\ub2e4\uc6b4\ub85c\ub4dc ...\",\n\t\"menu.label.save.data\": \"\ub370\uc774\ud130\ub85c \uc800\uc7a5 ...\",\n\n\t\"menu.label.draw\": \"\uadf8\ub9ac\uae30\",\n\t\"menu.label.draw.change\": \"\ubc14\uafb8\uae30 ...\",\n\t\"menu.label.draw.add\": \"\uc0bd\uc785\ud558\uae30 ...\",\n\t\"menu.label.draw.shapes\": \"\ubaa8\uc591 ...\",\n\t\"menu.label.draw.colors\": \"\uc0c9 \ubcc0\uacbd ...\",\n\t\"menu.label.draw.widths\": \"\ud06c\uae30 \ubcc0\uacbd ...\",\n\t\"menu.label.draw.opacities\": \"\ud22c\uba85\ub3c4 \ubcc0\uacbd ...\",\n\t\"menu.label.draw.text\": \"\ud14d\uc2a4\ud2b8\",\n\n\t\"menu.label.draw.modes\": \"\ubaa8\ub4dc \ubcc0\uacbd ...\",\n\t\"menu.label.draw.modes.pencil\": \"\ud39c\",\n\t\"menu.label.draw.modes.line\": \"\uc120\",\n\t\"menu.label.draw.modes.arrow\": \"\ud654\uc0b4\ud45c\",\n\n    \"label.saved.from\": \"\uc5d0\uc11c \uc800\uc7a5: \"\n}","Amasty_Reports/amcharts/plugins/export/lang/lt.js":"AmCharts.translations[ \"export\" ][ \"lt\" ] = {\n\t\"fallback.save.text\": \"Spauskite CTRL + C jei norite nukopijuoti paveiksliuk\u0105.\",\n\t\"fallback.save.image\": \"Spragtelkite de\u0161in\u012f klavi\u0161\u0105 ir pasirinkite \\\"Save picture as...\\\" jei norite i\u0161saugoti paveiksliuk\u0105.\",\n\n\t\"capturing.delayed.menu.label\": \"{{duration}}\",\n\t\"capturing.delayed.menu.title\": \"Nutraukti\",\n\n\t\"menu.label.print\": \"Spausdinti\",\n\t\"menu.label.undo\": \"At\u0161aukti\",\n\t\"menu.label.redo\": \"Pakartoti\",\n\t\"menu.label.cancel\": \"Nutraukti\",\n\n\t\"menu.label.save.image\": \"Atsisi\u0173sti ...\",\n\t\"menu.label.save.data\": \"I\u0161saugoti ...\",\n\n\t\"menu.label.draw\": \"Anotuoti ...\",\n\t\"menu.label.draw.change\": \"Keisti ...\",\n\t\"menu.label.draw.add\": \"Prid\u0117ti ...\",\n\t\"menu.label.draw.shapes\": \"Ikon\u0117l\u0119 ...\",\n\t\"menu.label.draw.colors\": \"Spalv\u0105 ...\",\n\t\"menu.label.draw.widths\": \"Teptuk\u0105 ...\",\n\t\"menu.label.draw.opacities\": \"Nepermatomumas ...\",\n\t\"menu.label.draw.text\": \"Tekst\u0105\",\n\n\t\"menu.label.draw.modes\": \"Re\u017eimas ...\",\n\t\"menu.label.draw.modes.pencil\": \"Tekst\u0105\",\n\t\"menu.label.draw.modes.line\": \"Linija\",\n\t\"menu.label.draw.modes.arrow\": \"Rodykl\u0117\",\n\n\t\"label.saved.from\": \"I\u0161saugoti nuo: \"\n}","Amasty_Reports/amcharts/plugins/animate/animate.min.js":"!function(){\"use strict\"\nfunction t(t,n,i){return t*(i-n)+n}function n(t){var n=1-t\nreturn n*=n*n*n,1-n}function i(t,n,i,e){this._object=t,this._key=n,this._from=i,this._to=e}function e(t,i,e,r,a){this._finished=!1,this._startTime=null,this._duration=t,this._easing=null==i?n:i,this._onComplete=e,this._tweens=r,this._chart=a}function r(){this._animating=!1,this._animations=[],this._onBeforeFrames=[],this._onAfterFrames=[]\nvar t=this\nthis._raf=function(n){t._onFrame(n)}}function a(t){return t!==t}function u(t,n){for(var i=0;i<t.length;++i)n(t[i])}function o(t,n){for(var i=0;i<t.length;++i)if(t[i]===n)return\nt.push(n)}function l(t,n,i){n[i]||(n[i]=!0,t.push(i))}function s(t,n,i,e){u(e,function(e){var r=i[e]\nnull!=r&&l(t,n,r)})}function h(t,n,i){s(n,i,t,[\"alphaField\",\"valueField\"])}function f(t,n,i){h(t,n,i)}function m(t,n,i){h(t,n,i),s(n,i,t,[\"labelRadiusField\"])}function c(t,n,i){s(n,i,t,[\"alphaField\",\"bulletSizeField\",\"closeField\",\"dashLengthField\",\"errorField\",\"highField\",\"lowField\",\"openField\",\"valueField\"])}function p(t,n,i){c(t,n,i),s(n,i,t,[\"xField\",\"yField\"])}function _(t,n,i,e){u(t,function(t){e(t,n,i)})}function d(t,n,i){s(n,i,t,[\"widthField\"])}function v(t){var n=[],i={}\nreturn\"funnel\"===t.type?f(t,n,i):\"pie\"===t.type?m(t,n,i):\"serial\"===t.type?(d(t.categoryAxis,n,i),_(t.graphs,n,i,c)):\"radar\"===t.type?_(t.graphs,n,i,c):\"xy\"===t.type&&_(t.graphs,n,i,p),n}function y(t){var n={}\nreturn(\"serial\"===t.type||\"radar\"===t.type||\"xy\"===t.type)&&u(t.valueAxes,function(t){null==n[t.id]&&(n[t.id]={minimum:t.minimum,maximum:t.maximum},null==t.minimum&&(t.minimum=t.min),null==t.maximum&&(t.maximum=t.max))}),n}function F(t,n){(\"serial\"===t.type||\"radar\"===t.type||\"xy\"===t.type)&&u(t.valueAxes,function(t){var i=n[t.id]\nnull!=i&&(null==i.minimum&&delete t.minimum,null==i.maximum&&delete t.maximum)})}function g(t){return\"funnel\"===t.type||\"pie\"===t.type?t.titleField:\"serial\"===t.type||\"radar\"===t.type?t.categoryField:void 0}function x(t,n){var i=t[n]\nreturn null==i?null:(i=+i,a(i)?null:i)}function A(t,n){var i=t[n]\nreturn null==i?null:\"\"+i}function w(t,n){var i={}\nreturn u(t,function(t){var e=A(t,n)\nnull!=e&&(i[e]=t)}),i}function T(t,n,e,r){var a=[]\nreturn u(t,function(t){var o=A(t,n)\nif(null!=o&&o in e){var l=e[o]\nu(r,function(n){var e=x(l,n),r=x(t,n)\nnull!=e&&null!=r&&a.push(new i(t,n,e,r))})}}),a}function k(t,n,e){for(var r=[],a=Math.min(t.length,n.length),o=0;a>o;++o){var l=t[o],s=n[o]\nu(e,function(t){var n=x(l,t),e=x(s,t)\nnull!=n&&null!=e&&r.push(new i(s,t,n,e))})}return r}function b(t,n){if(\"xy\"===t.type){var i=v(t)\nreturn k(t.dataProvider,n,i)}var e=g(t),i=v(t),r=w(t.dataProvider,e)\nreturn T(n,e,r,i)}function B(t,n){function i(){F(r,u),null!=n.complete&&n.complete()}var r=this,a=b(r,t),u=y(r)\nr.dataProvider=t\nvar o=new e(n.duration,n.easing,i,a,r)\nreturn P.animate(o),o}if(\"undefined\"==typeof requestAnimationFrame)var C=1e3/60,D=function(t){setTimeout(function(){t((new Date).getTime())},C)}\nelse var D=requestAnimationFrame\ni.prototype.interpolate=function(n){this._object[this._key]=t(n,this._from,this._to)},e.prototype.cancel=function(){this._finished=!0,this._startTime=null,this._duration=null,this._easing=null,this._onComplete=null,this._tweens=null,this._chart=null},e.prototype._onFrame=function(t){if(this._finished)return!0\nif(null===this._startTime)return this._startTime=t,!1\nvar n=t-this._startTime\nreturn n<this._duration?(this._tick(n/this._duration),!1):(this._end(1),this.cancel(),!0)},e.prototype._tick=function(t){t=this._easing(t)\nfor(var n=this._tweens,i=0;i<n.length;++i)n[i].interpolate(t)\no(j,this._chart)},e.prototype._end=function(t){this._tick(t),this._onComplete()},r.prototype.animate=function(t){this._animations.push(t),this._animating||(this._animating=!0,D(this._raf))},r.prototype.onBeforeFrame=function(t){this._onBeforeFrames.push(t)},r.prototype.onAfterFrame=function(t){this._onAfterFrames.push(t)},r.prototype._onFrame=function(t){for(var n=this._onBeforeFrames,i=0;i<n.length;++i)n[i](t)\nfor(var e=this._animations,i=0;i<e.length;++i){var r=e[i]\nr._onFrame(t)&&(e.splice(i,1),--i)}for(var a=this._onAfterFrames,i=0;i<a.length;++i)a[i](t)\n0===e.length?this._animating=!1:D(this._raf)}\nvar P=new r,j=[]\nP.onAfterFrame(function(){for(var t=0;t<j.length;++t)j[t].validateData()\nj.length=0}),AmCharts.addInitHandler(function(t){t.animateData=B},[\"funnel\",\"pie\",\"serial\",\"radar\",\"xy\"])}()\n","Amasty_Reports/amcharts/plugins/responsive/responsive.js":"// phpcs:ignoreFile\n/* eslint-disable */\n/*\nPlugin Name: amCharts Responsive\nDescription: This plugin add responsive functionality to JavaScript Charts and Maps.\nAuthor: Martynas Majeris, amCharts\nContributors: Ohad Schneider\nVersion: 1.0.2\nAuthor URI: http://www.amcharts.com/\n\nCopyright 2015 amCharts\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n\thttp://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\nPlease note that the above license covers only this plugin. It by all means does\nnot apply to any other amCharts products that are covered by different licenses.\n*/\n\n/*global AmCharts*/\n\nAmCharts.addInitHandler( function( chart ) {\n  \"use strict\";\n\n  if ( chart.responsive === undefined || chart.responsive.ready === true || chart.responsive.enabled !== true )\n    return;\n\n  var version = chart.version.split( '.' );\n  if ( ( version.length < 2 ) || Number( version[ 0 ] ) < 3 || ( Number( version[ 0 ] ) === 3 && Number( version[ 1 ] ) < 13 ) )\n    return;\n\n  // a short variable for easy reference\n  var r = chart.responsive;\n\n  r.ready = true;\n  r.currentRules = {};\n  r.overridden = [];\n\n  // defaults per chart type\n  var defaults = {\n\n    /**\n     * AmPie\n     */\n    'pie': [\n\n      /**\n       * Disable legend in certain cases\n       */\n      {\n        \"maxWidth\": 550,\n        \"legendPosition\": \"left\",\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxWidth\": 550,\n        \"legendPosition\": \"right\",\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxWidth\": 150,\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxHeight\": 350,\n        \"legendPosition\": \"top\",\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxHeight\": 350,\n        \"legendPosition\": \"bottom\",\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxHeight\": 150,\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      },\n\n      /**\n       * Narrow chart\n       */\n      {\n        \"maxWidth\": 400,\n        \"overrides\": {\n          \"labelsEnabled\": false\n        }\n      }, {\n        \"maxWidth\": 100,\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      },\n\n      /**\n       * Short chart\n       */\n      {\n        \"maxHeight\": 350,\n        \"overrides\": {\n          \"pullOutRadius\": 0\n        }\n      }, {\n        \"maxHeight\": 200,\n        \"overrides\": {\n          \"titles\": {\n            \"enabled\": false\n          },\n          \"labelsEnabled\": false\n        }\n      },\n\n      /**\n       * Supersmall\n       */\n      {\n        \"maxWidth\": 60,\n        \"overrides\": {\n          \"autoMargins\": false,\n          \"marginTop\": 0,\n          \"marginBottom\": 0,\n          \"marginLeft\": 0,\n          \"marginRight\": 0,\n          \"radius\": \"50%\",\n          \"innerRadius\": 0,\n          \"balloon\": {\n            \"enabled\": false\n          },\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxHeight\": 60,\n        \"overrides\": {\n          \"marginTop\": 0,\n          \"marginBottom\": 0,\n          \"marginLeft\": 0,\n          \"marginRight\": 0,\n          \"radius\": \"50%\",\n          \"innerRadius\": 0,\n          \"balloon\": {\n            \"enabled\": false\n          },\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }\n    ],\n\n    /**\n     * AmFunnel\n     */\n\n    'funnel': [ {\n      \"maxWidth\": 550,\n      \"legendPosition\": \"left\",\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxWidth\": 550,\n      \"legendPosition\": \"right\",\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxWidth\": 150,\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 500,\n      \"legendPosition\": \"top\",\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 500,\n      \"legendPosition\": \"bottom\",\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 150,\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxWidth\": 400,\n      \"overrides\": {\n        \"labelsEnabled\": false,\n        \"marginLeft\": 10,\n        \"marginRight\": 10,\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 350,\n      \"overrides\": {\n        \"pullOutRadius\": 0,\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 300,\n      \"overrides\": {\n        \"titles\": {\n          \"enabled\": false\n        }\n      }\n    } ],\n\n    /**\n     * AmRadar\n     */\n\n    \"radar\": [ {\n      \"maxWidth\": 550,\n      \"legendPosition\": \"left\",\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxWidth\": 550,\n      \"legendPosition\": \"right\",\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxWidth\": 150,\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 350,\n      \"legendPosition\": \"top\",\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 350,\n      \"legendPosition\": \"bottom\",\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 150,\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxWidth\": 300,\n      \"overrides\": {\n        \"labelsEnabled\": false\n      }\n    }, {\n      \"maxWidth\": 200,\n      \"overrides\": {\n        \"autoMargins\": false,\n        \"marginTop\": 0,\n        \"marginBottom\": 0,\n        \"marginLeft\": 0,\n        \"marginRight\": 0,\n        \"radius\": \"50%\",\n        \"titles\": {\n          \"enabled\": false\n        },\n        \"valueAxes\": {\n          \"labelsEnabled\": false,\n          \"radarCategoriesEnabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 300,\n      \"overrides\": {\n        \"labelsEnabled\": false\n      }\n    }, {\n      \"maxHeight\": 200,\n      \"overrides\": {\n        \"autoMargins\": false,\n        \"marginTop\": 0,\n        \"marginBottom\": 0,\n        \"marginLeft\": 0,\n        \"marginRight\": 0,\n        \"radius\": \"50%\",\n        \"titles\": {\n          \"enabled\": false\n        },\n        \"valueAxes\": {\n          \"radarCategoriesEnabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 100,\n      \"overrides\": {\n        \"valueAxes\": {\n          \"labelsEnabled\": false\n        }\n      }\n    } ],\n\n    /**\n     * AmGauge\n     */\n\n    'gauge': [ {\n      \"maxWidth\": 550,\n      \"legendPosition\": \"left\",\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxWidth\": 550,\n      \"legendPosition\": \"right\",\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxWidth\": 150,\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 500,\n      \"legendPosition\": \"top\",\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 500,\n      \"legendPosition\": \"bottom\",\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 150,\n      \"overrides\": {\n        \"legend\": {\n          \"enabled\": false\n        }\n      }\n    }, {\n      \"maxWidth\": 200,\n      \"overrides\": {\n        \"titles\": {\n          \"enabled\": false\n        },\n        \"allLabels\": {\n          \"enabled\": false\n        },\n        \"axes\": {\n          \"labelsEnabled\": false\n        }\n      }\n    }, {\n      \"maxHeight\": 200,\n      \"overrides\": {\n        \"titles\": {\n          \"enabled\": false\n        },\n        \"allLabels\": {\n          \"enabled\": false\n        },\n        \"axes\": {\n          \"labelsEnabled\": false\n        }\n      }\n    } ],\n\n    /**\n     * AmSerial\n     */\n    \"serial\": [\n\n      /**\n       * Disable legend in certain cases\n       */\n      {\n        \"maxWidth\": 550,\n        \"legendPosition\": \"left\",\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxWidth\": 550,\n        \"legendPosition\": \"right\",\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxWidth\": 100,\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxHeight\": 350,\n        \"legendPosition\": \"top\",\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxHeight\": 350,\n        \"legendPosition\": \"bottom\",\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxHeight\": 100,\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      },\n\n\n      /**\n       * Narrow chart\n       */\n      {\n        \"maxWidth\": 350,\n        \"overrides\": {\n          \"autoMarginOffset\": 0,\n          \"graphs\": {\n            \"hideBulletsCount\": 10\n          }\n        }\n      }, {\n        \"maxWidth\": 350,\n        \"rotate\": false,\n        \"overrides\": {\n          \"marginLeft\": 10,\n          \"marginRight\": 10,\n          \"valueAxes\": {\n            \"ignoreAxisWidth\": true,\n            \"inside\": true,\n            \"title\": \"\",\n            \"showFirstLabel\": false,\n            \"showLastLabel\": false\n          },\n          \"graphs\": {\n            \"bullet\": \"none\"\n          }\n        }\n      }, {\n        \"maxWidth\": 350,\n        \"rotate\": true,\n        \"overrides\": {\n          \"marginLeft\": 10,\n          \"marginRight\": 10,\n          \"categoryAxis\": {\n            \"ignoreAxisWidth\": true,\n            \"inside\": true,\n            \"title\": \"\"\n          }\n        }\n      }, {\n        \"maxWidth\": 200,\n        \"rotate\": false,\n        \"overrides\": {\n          \"marginLeft\": 10,\n          \"marginRight\": 10,\n          \"marginTop\": 10,\n          \"marginBottom\": 10,\n          \"categoryAxis\": {\n            \"ignoreAxisWidth\": true,\n            \"labelsEnabled\": false,\n            \"inside\": true,\n            \"title\": \"\",\n            \"guides\": {\n              \"inside\": true\n            }\n          },\n          \"valueAxes\": {\n            \"ignoreAxisWidth\": true,\n            \"labelsEnabled\": false,\n            \"axisAlpha\": 0,\n            \"guides\": {\n              \"label\": \"\"\n            }\n          },\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxWidth\": 200,\n        \"rotate\": true,\n        \"overrides\": {\n          \"chartScrollbar\": {\n            \"scrollbarHeight\": 4,\n            \"graph\": \"\",\n            \"resizeEnabled\": false\n          },\n          \"categoryAxis\": {\n            \"labelsEnabled\": false,\n            \"axisAlpha\": 0,\n            \"guides\": {\n              \"label\": \"\"\n            }\n          },\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxWidth\": 100,\n        \"rotate\": false,\n        \"overrides\": {\n          \"valueAxes\": {\n            \"gridAlpha\": 0\n          }\n        }\n      }, {\n        \"maxWidth\": 100,\n        \"rotate\": true,\n        \"overrides\": {\n          \"categoryAxis\": {\n            \"gridAlpha\": 0\n          }\n        }\n      },\n\n      /**\n       * Short chart\n       */\n      {\n        \"maxHeight\": 300,\n        \"overrides\": {\n          \"autoMarginOffset\": 0,\n          \"graphs\": {\n            \"hideBulletsCount\": 10\n          }\n        }\n      }, {\n        \"maxHeight\": 200,\n        \"rotate\": false,\n        \"overrides\": {\n          \"marginTop\": 10,\n          \"marginBottom\": 10,\n          \"categoryAxis\": {\n            \"ignoreAxisWidth\": true,\n            \"inside\": true,\n            \"title\": \"\",\n            \"showFirstLabel\": false,\n            \"showLastLabel\": false\n          }\n        }\n      }, {\n        \"maxHeight\": 200,\n        \"rotate\": true,\n        \"overrides\": {\n          \"marginTop\": 10,\n          \"marginBottom\": 10,\n          \"valueAxes\": {\n            \"ignoreAxisWidth\": true,\n            \"inside\": true,\n            \"title\": \"\",\n            \"showFirstLabel\": false,\n            \"showLastLabel\": false\n          },\n          \"graphs\": {\n            \"bullet\": \"none\"\n          }\n        }\n      }, {\n        \"maxHeight\": 150,\n        \"rotate\": false,\n        \"overrides\": {\n          \"titles\": {\n            \"enabled\": false\n          },\n          \"chartScrollbar\": {\n            \"scrollbarHeight\": 4,\n            \"graph\": \"\",\n            \"resizeEnabled\": false\n          },\n          \"categoryAxis\": {\n            \"labelsEnabled\": false,\n            \"ignoreAxisWidth\": true,\n            \"axisAlpha\": 0,\n            \"guides\": {\n              \"label\": \"\"\n            }\n          }\n        }\n      }, {\n        \"maxHeight\": 150,\n        \"rotate\": true,\n        \"overrides\": {\n          \"titles\": {\n            \"enabled\": false\n          },\n          \"valueAxes\": {\n            \"labelsEnabled\": false,\n            \"ignoreAxisWidth\": true,\n            \"axisAlpha\": 0,\n            \"guides\": {\n              \"label\": \"\"\n            }\n          }\n        }\n      }, {\n        \"maxHeight\": 100,\n        \"rotate\": false,\n        \"overrides\": {\n          \"valueAxes\": {\n            \"labelsEnabled\": false,\n            \"ignoreAxisWidth\": true,\n            \"axisAlpha\": 0,\n            \"gridAlpha\": 0,\n            \"guides\": {\n              \"label\": \"\"\n            }\n          }\n        }\n      }, {\n        \"maxHeight\": 100,\n        \"rotate\": true,\n        \"overrides\": {\n          \"categoryAxis\": {\n            \"labelsEnabled\": false,\n            \"ignoreAxisWidth\": true,\n            \"axisAlpha\": 0,\n            \"gridAlpha\": 0,\n            \"guides\": {\n              \"label\": \"\"\n            }\n          }\n        }\n      },\n\n      /**\n       * Really small charts: microcharts and sparklines\n       */\n      {\n        \"maxWidth\": 100,\n        \"overrides\": {\n          \"autoMargins\": false,\n          \"marginTop\": 0,\n          \"marginBottom\": 0,\n          \"marginLeft\": 0,\n          \"marginRight\": 0,\n          \"categoryAxis\": {\n            \"labelsEnabled\": false\n          },\n          \"valueAxes\": {\n            \"labelsEnabled\": false\n          }\n        }\n      }, {\n        \"maxHeight\": 100,\n        \"overrides\": {\n          \"autoMargins\": false,\n          \"marginTop\": 0,\n          \"marginBottom\": 0,\n          \"marginLeft\": 0,\n          \"marginRight\": 0,\n          \"categoryAxis\": {\n            \"labelsEnabled\": false\n          },\n          \"valueAxes\": {\n            \"labelsEnabled\": false\n          }\n        }\n      }\n    ],\n\n    /**\n     * AmXY\n     */\n    \"xy\": [\n\n      /**\n       * Disable legend in certain cases\n       */\n      {\n        \"maxWidth\": 550,\n        \"legendPosition\": \"left\",\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxWidth\": 550,\n        \"legendPosition\": \"right\",\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxWidth\": 100,\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxHeight\": 350,\n        \"legendPosition\": \"top\",\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxHeight\": 350,\n        \"legendPosition\": \"bottom\",\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxHeight\": 100,\n        \"overrides\": {\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      },\n\n      /**\n       * Narrow chart\n       */\n      {\n        \"maxWidth\": 250,\n        \"overrides\": {\n          \"autoMarginOffset\": 0,\n          \"autoMargins\": false,\n          \"marginTop\": 0,\n          \"marginBottom\": 0,\n          \"marginLeft\": 0,\n          \"marginRight\": 0,\n          \"valueAxes\": {\n            \"inside\": true,\n            \"title\": \"\",\n            \"showFirstLabel\": false,\n            \"showLastLabel\": false\n          },\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxWidth\": 150,\n        \"overrides\": {\n          \"valueyAxes\": {\n            \"labelsEnabled\": false,\n            \"axisAlpha\": 0,\n            \"gridAlpha\": 0,\n            \"guides\": {\n              \"label\": \"\"\n            }\n          }\n        }\n      },\n\n      /**\n       * Short chart\n       */\n      {\n        \"maxHeight\": 250,\n        \"overrides\": {\n          \"autoMarginOffset\": 0,\n          \"autoMargins\": false,\n          \"marginTop\": 0,\n          \"marginBottom\": 0,\n          \"marginLeft\": 0,\n          \"marginRight\": 0,\n          \"valueAxes\": {\n            \"inside\": true,\n            \"title\": \"\",\n            \"showFirstLabel\": false,\n            \"showLastLabel\": false\n          },\n          \"legend\": {\n            \"enabled\": false\n          }\n        }\n      }, {\n        \"maxWidth\": 150,\n        \"overrides\": {\n          \"valueyAxes\": {\n            \"labelsEnabled\": false,\n            \"axisAlpha\": 0,\n            \"gridAlpha\": 0,\n            \"guides\": {\n              \"label\": \"\"\n            }\n          }\n        }\n      }\n    ],\n\n    /**\n     * AmStock\n     */\n\n    'stock': [ {\n      \"maxWidth\": 500,\n      \"overrides\": {\n        \"dataSetSelector\": {\n          \"position\": \"top\"\n        },\n        \"periodSelector\": {\n          \"position\": \"bottom\"\n        }\n      }\n    }, {\n      \"maxWidth\": 400,\n      \"overrides\": {\n        \"dataSetSelector\": {\n          \"selectText\": \"\",\n          \"compareText\": \"\"\n        },\n        \"periodSelector\": {\n          \"periodsText\": \"\",\n          \"inputFieldsEnabled\": false\n        }\n      }\n    } ],\n\n    /**\n     * AmMap\n     */\n\n    'map': [ {\n      \"maxWidth\": 200,\n      \"overrides\": {\n        \"zoomControl\": {\n          \"zoomControlEnabled\": false\n        },\n        \"smallMap\": {\n          \"enabled\": false\n        },\n        \"valueLegend\": {\n          \"enabled\": false\n        },\n        \"dataProvider\": {\n          \"areas\": {\n            \"descriptionWindowWidth\": 160,\n            \"descriptionWindowRight\": 10,\n            \"descriptionWindowTop\": 10\n          },\n          \"images\": {\n            \"descriptionWindowWidth\": 160,\n            \"descriptionWindowRight\": 10,\n            \"descriptionWindowTop\": 10\n          },\n          \"lines\": {\n            \"descriptionWindowWidth\": 160,\n            \"descriptionWindowRight\": 10,\n            \"descriptionWindowTop\": 10\n          }\n        }\n      }\n    }, {\n      \"maxWidth\": 150,\n      \"overrides\": {\n        \"dataProvider\": {\n          \"areas\": {\n            \"descriptionWindowWidth\": 110,\n            \"descriptionWindowRight\": 10,\n            \"descriptionWindowTop\": 10\n          },\n          \"images\": {\n            \"descriptionWindowWidth\": 110,\n            \"descriptionWindowRight\": 10,\n            \"descriptionWindowTop\": 10\n          },\n          \"lines\": {\n            \"descriptionWindowWidth\": 110,\n            \"descriptionWindowLeft\": 10,\n            \"descriptionWindowRight\": 10\n          }\n        }\n      }\n    }, {\n      \"maxHeight\": 200,\n      \"overrides\": {\n        \"zoomControl\": {\n          \"zoomControlEnabled\": false\n        },\n        \"smallMap\": {\n          \"enabled\": false\n        },\n        \"valueLegend\": {\n          \"enabled\": false\n        },\n        \"dataProvider\": {\n          \"areas\": {\n            \"descriptionWindowHeight\": 160,\n            \"descriptionWindowRight\": 10,\n            \"descriptionWindowTop\": 10\n          },\n          \"images\": {\n            \"descriptionWindowHeight\": 160,\n            \"descriptionWindowRight\": 10,\n            \"descriptionWindowTop\": 10\n          },\n          \"lines\": {\n            \"descriptionWindowHeight\": 160,\n            \"descriptionWindowRight\": 10,\n            \"descriptionWindowTop\": 10\n          }\n        }\n      }\n    }, {\n      \"maxHeight\": 150,\n      \"overrides\": {\n        \"dataProvider\": {\n          \"areas\": {\n            \"descriptionWindowHeight\": 110,\n            \"descriptionWindowRight\": 10,\n            \"descriptionWindowTop\": 10\n          },\n          \"images\": {\n            \"descriptionWindowHeight\": 110,\n            \"descriptionWindowRight\": 10,\n            \"descriptionWindowTop\": 10\n          },\n          \"lines\": {\n            \"descriptionWindowHeight\": 110,\n            \"descriptionWindowLeft\": 10,\n            \"descriptionWindowRight\": 10\n          }\n        }\n      }\n    } ]\n  };\n\n  var isNullOrUndefined = function( obj ) {\n    return ( obj === null ) || ( obj === undefined );\n  };\n\n  var isArray = function( obj ) {\n    return ( !isNullOrUndefined( obj ) && Object.prototype.toString.call( obj ) === '[object Array]' );\n  };\n\n  var isObject = function( obj ) {\n    return ( obj !== null && typeof obj === 'object' ); //the null check is necessary - recall that typeof null === 'object' !\n  };\n\n  var findArrayObjectById = function( arr, id ) {\n    for ( var i = 0; i < arr.length; i++ ) {\n      if ( isObject( arr[ i ] ) && arr[ i ].id === id )\n        return arr[ i ];\n    }\n    return undefined; //we can use undefined as it doesn't have an Id property and so will never be the desired object from the array\n  };\n\n  var cloneWithoutPrototypes = function( obj ) {\n    if ( !isObject( obj ) ) {\n      return obj;\n    }\n\n    if ( isArray( obj ) ) {\n      return obj.slice(); //effectively clones the array\n    }\n\n    var clone = {}; //here is where we lose the prototype\n    for ( var property in obj ) {\n      if ( Object.prototype.hasOwnProperty.call( obj, property ) ) {\n        clone[ property ] = cloneWithoutPrototypes( obj[ property ] );\n      }\n    }\n    return clone;\n  };\n\n  var originalValueRetainerPrefix = '{F0578839-A214-4E2D-8D1B-44941ECE8332}_';\n  var noOriginalPropertyStub = {};\n\n  var overrideProperty = function( object, property, overrideValue ) {\n\n    var originalValueRetainerProperty = originalValueRetainerPrefix + property;\n    if ( !( originalValueRetainerProperty in object ) ) {\n      object[ originalValueRetainerProperty ] = ( property in object ) ? object[ property ] : noOriginalPropertyStub;\n    }\n\n    object[ property ] = cloneWithoutPrototypes( overrideValue );\n\n    r.overridden.push( {\n      object: object,\n      property: property\n    } );\n  };\n\n  var restoreOriginalProperty = function( object, property ) {\n    var originalValue = object[ originalValueRetainerPrefix + property ];\n    if ( originalValue === noOriginalPropertyStub ) {\n      delete object[ property ];\n    } else {\n      object[ property ] = originalValue;\n    }\n  };\n\n  var restoreOriginals = function() {\n    while ( r.overridden.length > 0 ) {\n      var override = r.overridden.pop();\n      restoreOriginalProperty( override.object, override.property );\n    }\n  };\n\n  var redrawChart = function() {\n    chart.dataChanged = true;\n    if ( chart.type !== 'xy' ) {\n      chart.marginsUpdated = false;\n    }\n    chart.zoomOutOnDataUpdate = false;\n    chart.validateNow( true );\n    restoreOriginalProperty( chart, 'zoomOutOnDataUpdate' );\n  };\n\n  var applyConfig = function( current, override ) {\n    if ( isNullOrUndefined( override ) ) {\n      return;\n    }\n\n    for ( var property in override ) {\n      if ( !Object.prototype.hasOwnProperty.call( override, property ) ) {\n        continue;\n      }\n\n      var currentValue = current[ property ];\n      var overrideValue = override[ property ];\n\n      //property doesn't exist on current object or it exists as null/undefined => completely override it\n      if ( isNullOrUndefined( currentValue ) ) {\n        overrideProperty( current, property, overrideValue );\n        continue;\n      }\n\n      //current value is an array => override method depends on override form\n      if ( isArray( currentValue ) ) {\n\n        //override value is an array => override method depends on array elements\n        if ( isArray( overrideValue ) ) {\n\n          //current value is an array of non-objects => override the entire array\n          //we assume a uniformly-typed array, so checking the first value should suffice\n          if ( ( currentValue.length > 0 && !isObject( currentValue[ 0 ] ) ) || ( overrideValue.length > 0 && !isObject( overrideValue[ 0 ] ) ) ) {\n            overrideProperty( current, property, overrideValue );\n            continue;\n          }\n\n          var idPresentOnAllOverrideElements = true;\n          for ( var k = 0; k < overrideValue.length; k++ ) {\n            if ( isNullOrUndefined( overrideValue[ k ] ) || isNullOrUndefined( overrideValue[ k ].id ) ) {\n              idPresentOnAllOverrideElements = false;\n              break;\n            }\n          }\n\n          //Id property is present on all override elements => override elements by ID\n          if ( idPresentOnAllOverrideElements ) {\n            for ( var i = 0; i < overrideValue.length; i++ ) {\n              var correspondingCurrentElement = findArrayObjectById( currentValue, overrideValue[ i ].id );\n              if ( correspondingCurrentElement === undefined ) {\n                throw ( 'could not find element to override in \"' + property + '\" with ID: ' + overrideValue[ i ].id );\n              }\n              applyConfig( correspondingCurrentElement, overrideValue[ i ] );\n            }\n            continue;\n          }\n\n          //Id property is not set on all override elements and there aren't too many overrides => override objects by their index\n          if ( overrideValue.length <= currentValue.length ) {\n            for ( var l = 0; l < overrideValue.length; l++ ) {\n              applyConfig( currentValue[ l ], overrideValue[ l ] );\n            }\n            continue;\n          }\n\n          throw 'too many index-based overrides specified for object array property: ' + property;\n        }\n\n        // override value is a single object => override all current array objects with that object\n        if ( isObject( overrideValue ) ) {\n          for ( var j = 0; j < currentValue.length; j++ ) {\n            applyConfig( currentValue[ j ], overrideValue );\n          }\n          continue;\n        }\n\n        throw ( 'non-object override detected for array property: ' + property );\n      }\n\n      if ( isObject( currentValue ) ) {\n        applyConfig( currentValue, overrideValue );\n        continue;\n      }\n\n      //if we reached this point, the property is defined on the current object but is not an object => override it\n      overrideProperty( current, property, overrideValue );\n    }\n  };\n\n  var checkRules = function() {\n\n    var width = chart.divRealWidth;\n    var height = chart.divRealHeight;\n\n    // do nothing if the container is hidden (has no size)\n    if ( width === 0 || height === 0 )\n      return;\n\n    // update current rules\n    var rulesChanged = false;\n    for ( var i = 0; i < r.rules.length; i++ ) {\n      var rule = r.rules[ i ];\n\n      var ruleMatches =\n        ( rule.minWidth === undefined || ( rule.minWidth <= width ) ) && ( rule.maxWidth === undefined || ( rule.maxWidth >= width ) ) &&\n        ( rule.minHeight === undefined || ( rule.minHeight <= height ) ) && ( rule.maxHeight === undefined || ( rule.maxHeight >= height ) ) &&\n        ( rule.rotate === undefined || ( rule.rotate === true && chart.rotate === true ) || ( rule.rotate === false && ( chart.rotate === undefined || chart.rotate === false ) ) ) &&\n        ( rule.legendPosition === undefined || ( chart.legend !== undefined && chart.legend.position !== undefined && chart.legend.position === rule.legendPosition ) );\n\n      if ( ruleMatches ) {\n        if ( r.currentRules[ i ] === undefined ) {\n          r.currentRules[ i ] = true;\n          rulesChanged = true;\n        }\n      } else if ( r.currentRules[ i ] !== undefined ) {\n        r.currentRules[ i ] = undefined;\n        rulesChanged = true;\n      }\n    }\n\n    if ( !rulesChanged )\n      return;\n\n    restoreOriginals();\n\n    for ( var key in r.currentRules ) {\n      if ( !Object.prototype.hasOwnProperty.call( r.currentRules, key ) ) {\n        continue;\n      }\n\n      if ( r.currentRules[ key ] !== undefined ) {\n        if ( isNullOrUndefined( r.rules[ key ] ) ) {\n          throw 'null or undefined rule in index: ' + key;\n        }\n        applyConfig( chart, r.rules[ key ].overrides );\n      }\n    }\n\n    // TODO - re-apply zooms/slices as necessary\n\n    redrawChart();\n  };\n\n  defaults.gantt = defaults.serial;\n\n  if ( !isArray( r.rules ) ) {\n    r.rules = defaults[ chart.type ];\n  } else if ( r.addDefaultRules !== false ) {\n    r.rules = defaults[ chart.type ].concat( r.rules );\n  }\n\n  //retain original zoomOutOnDataUpdate value\n  overrideProperty( chart, 'zoomOutOnDataUpdate', chart.zoomOutOnDataUpdate );\n\n  chart.addListener( 'resized', checkRules );\n  chart.addListener( 'init', checkRules );\n\n}, [ 'pie', 'serial', 'xy', 'funnel', 'radar', 'gauge', 'gantt', 'stock', 'map' ] );\n","Amasty_Reports/amcharts/plugins/responsive/responsive.min.js":"\ufeff// phpcs:ignoreFile\n/* eslint-disable */\nAmCharts.addInitHandler(function(n){\"use strict\";var u,t;if(n.responsive!==undefined&&n.responsive.ready!==!0&&n.responsive.enabled===!0&&(u=n.version.split(\".\"),!(u.length<2)&&!(Number(u[0])<3)&&(Number(u[0])!==3||!(Number(u[1])<13)))){t=n.responsive;t.ready=!0;t.currentRules={};t.overridden=[];var e={pie:[{maxWidth:550,legendPosition:\"left\",overrides:{legend:{enabled:!1}}},{maxWidth:550,legendPosition:\"right\",overrides:{legend:{enabled:!1}}},{maxWidth:150,overrides:{legend:{enabled:!1}}},{maxHeight:350,legendPosition:\"top\",overrides:{legend:{enabled:!1}}},{maxHeight:350,legendPosition:\"bottom\",overrides:{legend:{enabled:!1}}},{maxHeight:150,overrides:{legend:{enabled:!1}}},{maxWidth:400,overrides:{labelsEnabled:!1}},{maxWidth:100,overrides:{legend:{enabled:!1}}},{maxHeight:350,overrides:{pullOutRadius:0}},{maxHeight:200,overrides:{titles:{enabled:!1},labelsEnabled:!1}},{maxWidth:60,overrides:{autoMargins:!1,marginTop:0,marginBottom:0,marginLeft:0,marginRight:0,radius:\"50%\",innerRadius:0,balloon:{enabled:!1},legend:{enabled:!1}}},{maxHeight:60,overrides:{marginTop:0,marginBottom:0,marginLeft:0,marginRight:0,radius:\"50%\",innerRadius:0,balloon:{enabled:!1},legend:{enabled:!1}}}],funnel:[{maxWidth:550,legendPosition:\"left\",overrides:{legend:{enabled:!1}}},{maxWidth:550,legendPosition:\"right\",overrides:{legend:{enabled:!1}}},{maxWidth:150,overrides:{legend:{enabled:!1}}},{maxHeight:500,legendPosition:\"top\",overrides:{legend:{enabled:!1}}},{maxHeight:500,legendPosition:\"bottom\",overrides:{legend:{enabled:!1}}},{maxHeight:150,overrides:{legend:{enabled:!1}}},{maxWidth:400,overrides:{labelsEnabled:!1,marginLeft:10,marginRight:10,legend:{enabled:!1}}},{maxHeight:350,overrides:{pullOutRadius:0,legend:{enabled:!1}}},{maxHeight:300,overrides:{titles:{enabled:!1}}}],radar:[{maxWidth:550,legendPosition:\"left\",overrides:{legend:{enabled:!1}}},{maxWidth:550,legendPosition:\"right\",overrides:{legend:{enabled:!1}}},{maxWidth:150,overrides:{legend:{enabled:!1}}},{maxHeight:350,legendPosition:\"top\",overrides:{legend:{enabled:!1}}},{maxHeight:350,legendPosition:\"bottom\",overrides:{legend:{enabled:!1}}},{maxHeight:150,overrides:{legend:{enabled:!1}}},{maxWidth:300,overrides:{labelsEnabled:!1}},{maxWidth:200,overrides:{autoMargins:!1,marginTop:0,marginBottom:0,marginLeft:0,marginRight:0,radius:\"50%\",titles:{enabled:!1},valueAxes:{labelsEnabled:!1,radarCategoriesEnabled:!1}}},{maxHeight:300,overrides:{labelsEnabled:!1}},{maxHeight:200,overrides:{autoMargins:!1,marginTop:0,marginBottom:0,marginLeft:0,marginRight:0,radius:\"50%\",titles:{enabled:!1},valueAxes:{radarCategoriesEnabled:!1}}},{maxHeight:100,overrides:{valueAxes:{labelsEnabled:!1}}}],gauge:[{maxWidth:550,legendPosition:\"left\",overrides:{legend:{enabled:!1}}},{maxWidth:550,legendPosition:\"right\",overrides:{legend:{enabled:!1}}},{maxWidth:150,overrides:{legend:{enabled:!1}}},{maxHeight:500,legendPosition:\"top\",overrides:{legend:{enabled:!1}}},{maxHeight:500,legendPosition:\"bottom\",overrides:{legend:{enabled:!1}}},{maxHeight:150,overrides:{legend:{enabled:!1}}},{maxWidth:200,overrides:{titles:{enabled:!1},allLabels:{enabled:!1},axes:{labelsEnabled:!1}}},{maxHeight:200,overrides:{titles:{enabled:!1},allLabels:{enabled:!1},axes:{labelsEnabled:!1}}}],serial:[{maxWidth:550,legendPosition:\"left\",overrides:{legend:{enabled:!1}}},{maxWidth:550,legendPosition:\"right\",overrides:{legend:{enabled:!1}}},{maxWidth:100,overrides:{legend:{enabled:!1}}},{maxHeight:350,legendPosition:\"top\",overrides:{legend:{enabled:!1}}},{maxHeight:350,legendPosition:\"bottom\",overrides:{legend:{enabled:!1}}},{maxHeight:100,overrides:{legend:{enabled:!1}}},{maxWidth:350,overrides:{autoMarginOffset:0,graphs:{hideBulletsCount:10}}},{maxWidth:350,rotate:!1,overrides:{marginLeft:10,marginRight:10,valueAxes:{ignoreAxisWidth:!0,inside:!0,title:\"\",showFirstLabel:!1,showLastLabel:!1},graphs:{bullet:\"none\"}}},{maxWidth:350,rotate:!0,overrides:{marginLeft:10,marginRight:10,categoryAxis:{ignoreAxisWidth:!0,inside:!0,title:\"\"}}},{maxWidth:200,rotate:!1,overrides:{marginLeft:10,marginRight:10,marginTop:10,marginBottom:10,categoryAxis:{ignoreAxisWidth:!0,labelsEnabled:!1,inside:!0,title:\"\",guides:{inside:!0}},valueAxes:{ignoreAxisWidth:!0,labelsEnabled:!1,axisAlpha:0,guides:{label:\"\"}},legend:{enabled:!1}}},{maxWidth:200,rotate:!0,overrides:{chartScrollbar:{scrollbarHeight:4,graph:\"\",resizeEnabled:!1},categoryAxis:{labelsEnabled:!1,axisAlpha:0,guides:{label:\"\"}},legend:{enabled:!1}}},{maxWidth:100,rotate:!1,overrides:{valueAxes:{gridAlpha:0}}},{maxWidth:100,rotate:!0,overrides:{categoryAxis:{gridAlpha:0}}},{maxHeight:300,overrides:{autoMarginOffset:0,graphs:{hideBulletsCount:10}}},{maxHeight:200,rotate:!1,overrides:{marginTop:10,marginBottom:10,categoryAxis:{ignoreAxisWidth:!0,inside:!0,title:\"\",showFirstLabel:!1,showLastLabel:!1}}},{maxHeight:200,rotate:!0,overrides:{marginTop:10,marginBottom:10,valueAxes:{ignoreAxisWidth:!0,inside:!0,title:\"\",showFirstLabel:!1,showLastLabel:!1},graphs:{bullet:\"none\"}}},{maxHeight:150,rotate:!1,overrides:{titles:{enabled:!1},chartScrollbar:{scrollbarHeight:4,graph:\"\",resizeEnabled:!1},categoryAxis:{labelsEnabled:!1,ignoreAxisWidth:!0,axisAlpha:0,guides:{label:\"\"}}}},{maxHeight:150,rotate:!0,overrides:{titles:{enabled:!1},valueAxes:{labelsEnabled:!1,ignoreAxisWidth:!0,axisAlpha:0,guides:{label:\"\"}}}},{maxHeight:100,rotate:!1,overrides:{valueAxes:{labelsEnabled:!1,ignoreAxisWidth:!0,axisAlpha:0,gridAlpha:0,guides:{label:\"\"}}}},{maxHeight:100,rotate:!0,overrides:{categoryAxis:{labelsEnabled:!1,ignoreAxisWidth:!0,axisAlpha:0,gridAlpha:0,guides:{label:\"\"}}}},{maxWidth:100,overrides:{autoMargins:!1,marginTop:0,marginBottom:0,marginLeft:0,marginRight:0,categoryAxis:{labelsEnabled:!1},valueAxes:{labelsEnabled:!1}}},{maxHeight:100,overrides:{autoMargins:!1,marginTop:0,marginBottom:0,marginLeft:0,marginRight:0,categoryAxis:{labelsEnabled:!1},valueAxes:{labelsEnabled:!1}}}],xy:[{maxWidth:550,legendPosition:\"left\",overrides:{legend:{enabled:!1}}},{maxWidth:550,legendPosition:\"right\",overrides:{legend:{enabled:!1}}},{maxWidth:100,overrides:{legend:{enabled:!1}}},{maxHeight:350,legendPosition:\"top\",overrides:{legend:{enabled:!1}}},{maxHeight:350,legendPosition:\"bottom\",overrides:{legend:{enabled:!1}}},{maxHeight:100,overrides:{legend:{enabled:!1}}},{maxWidth:250,overrides:{autoMarginOffset:0,autoMargins:!1,marginTop:0,marginBottom:0,marginLeft:0,marginRight:0,valueAxes:{inside:!0,title:\"\",showFirstLabel:!1,showLastLabel:!1},legend:{enabled:!1}}},{maxWidth:150,overrides:{valueyAxes:{labelsEnabled:!1,axisAlpha:0,gridAlpha:0,guides:{label:\"\"}}}},{maxHeight:250,overrides:{autoMarginOffset:0,autoMargins:!1,marginTop:0,marginBottom:0,marginLeft:0,marginRight:0,valueAxes:{inside:!0,title:\"\",showFirstLabel:!1,showLastLabel:!1},legend:{enabled:!1}}},{maxWidth:150,overrides:{valueyAxes:{labelsEnabled:!1,axisAlpha:0,gridAlpha:0,guides:{label:\"\"}}}}],stock:[{maxWidth:500,overrides:{dataSetSelector:{position:\"top\"},periodSelector:{position:\"bottom\"}}},{maxWidth:400,overrides:{dataSetSelector:{selectText:\"\",compareText:\"\"},periodSelector:{periodsText:\"\",inputFieldsEnabled:!1}}}],map:[{maxWidth:200,overrides:{zoomControl:{zoomControlEnabled:!1},smallMap:{enabled:!1},valueLegend:{enabled:!1},dataProvider:{areas:{descriptionWindowWidth:160,descriptionWindowRight:10,descriptionWindowTop:10},images:{descriptionWindowWidth:160,descriptionWindowRight:10,descriptionWindowTop:10},lines:{descriptionWindowWidth:160,descriptionWindowRight:10,descriptionWindowTop:10}}}},{maxWidth:150,overrides:{dataProvider:{areas:{descriptionWindowWidth:110,descriptionWindowRight:10,descriptionWindowTop:10},images:{descriptionWindowWidth:110,descriptionWindowRight:10,descriptionWindowTop:10},lines:{descriptionWindowWidth:110,descriptionWindowLeft:10,descriptionWindowRight:10}}}},{maxHeight:200,overrides:{zoomControl:{zoomControlEnabled:!1},smallMap:{enabled:!1},valueLegend:{enabled:!1},dataProvider:{areas:{descriptionWindowHeight:160,descriptionWindowRight:10,descriptionWindowTop:10},images:{descriptionWindowHeight:160,descriptionWindowRight:10,descriptionWindowTop:10},lines:{descriptionWindowHeight:160,descriptionWindowRight:10,descriptionWindowTop:10}}}},{maxHeight:150,overrides:{dataProvider:{areas:{descriptionWindowHeight:110,descriptionWindowRight:10,descriptionWindowTop:10},images:{descriptionWindowHeight:110,descriptionWindowRight:10,descriptionWindowTop:10},lines:{descriptionWindowHeight:110,descriptionWindowLeft:10,descriptionWindowRight:10}}}}]},i=function(n){return n===null||n===undefined},o=function(n){return!i(n)&&Object.prototype.toString.call(n)===\"[object Array]\"},r=function(n){return n!==null&&typeof n==\"object\"},y=function(n,t){for(var i=0;i<n.length;i++)if(r(n[i])&&n[i].id===t)return n[i];return undefined},h=function(n){var i,t;if(!r(n))return n;if(o(n))return n.slice();i={};for(t in n)Object.prototype.hasOwnProperty.call(n,t)&&(i[t]=h(n[t]));return i},c=\"{F0578839-A214-4E2D-8D1B-44941ECE8332}_\",l={},s=function(n,i,r){var u=c+i;u in n||(n[u]=i in n?n[i]:l);n[i]=h(r);t.overridden.push({object:n,property:i})},a=function(n,t){var i=n[c+t];i===l?delete n[t]:n[t]=i},p=function(){while(t.overridden.length>0){var n=t.overridden.pop();a(n.object,n.property)}},w=function(){n.dataChanged=!0;n.type!==\"xy\"&&(n.marginsUpdated=!1);n.zoomOutOnDataUpdate=!1;n.validateNow(!0);a(n,\"zoomOutOnDataUpdate\")},f=function(n,t){var h,e,u,p,l,c,w,a,v;if(!i(t))for(h in t)if(Object.prototype.hasOwnProperty.call(t,h)){if(e=n[h],u=t[h],i(e)){s(n,h,u);continue}if(o(e)){if(o(u)){if(e.length>0&&!r(e[0])||u.length>0&&!r(u[0])){s(n,h,u);continue}for(p=!0,l=0;l<u.length;l++)if(i(u[l])||i(u[l].id)){p=!1;break}if(p){for(c=0;c<u.length;c++){if(w=y(e,u[c].id),w===undefined)throw'could not find element to override in \"'+h+'\" with ID: '+u[c].id;f(w,u[c])}continue}if(u.length<=e.length){for(a=0;a<u.length;a++)f(e[a],u[a]);continue}throw\"too many index-based overrides specified for object array property: \"+h;}if(r(u)){for(v=0;v<e.length;v++)f(e[v],u);continue}throw\"non-object override detected for array property: \"+h;}if(r(e)){f(e,u);continue}s(n,h,u)}},v=function(){var s=n.divRealWidth,h=n.divRealHeight,o,u,r,c,e;if(s!==0&&h!==0){for(o=!1,u=0;u<t.rules.length;u++)r=t.rules[u],c=(r.minWidth===undefined||r.minWidth<=s)&&(r.maxWidth===undefined||r.maxWidth>=s)&&(r.minHeight===undefined||r.minHeight<=h)&&(r.maxHeight===undefined||r.maxHeight>=h)&&(r.rotate===undefined||r.rotate===!0&&n.rotate===!0||r.rotate===!1&&(n.rotate===undefined||n.rotate===!1))&&(r.legendPosition===undefined||n.legend!==undefined&&n.legend.position!==undefined&&n.legend.position===r.legendPosition),c?t.currentRules[u]===undefined&&(t.currentRules[u]=!0,o=!0):t.currentRules[u]!==undefined&&(t.currentRules[u]=undefined,o=!0);if(o){p();for(e in t.currentRules)if(Object.prototype.hasOwnProperty.call(t.currentRules,e)&&t.currentRules[e]!==undefined){if(i(t.rules[e]))throw\"null or undefined rule in index: \"+e;f(n,t.rules[e].overrides)}w()}}};e.gantt=e.serial;o(t.rules)?t.addDefaultRules!==!1&&(t.rules=e[n.type].concat(t.rules)):t.rules=e[n.type];s(n,\"zoomOutOnDataUpdate\",n.zoomOutOnDataUpdate);n.addListener(\"resized\",v);n.addListener(\"init\",v)}},[\"pie\",\"serial\",\"xy\",\"funnel\",\"radar\",\"gauge\",\"gantt\",\"stock\",\"map\"]);\n//# sourceMappingURL=responsive.min.js.map\n","Amasty_Reports/amcharts/themes/black.js":"AmCharts.themes.black = {\n\n\tthemeName: \"black\",\n\n\tAmChart: {\n\t\tcolor: \"#e7e7e7\",\n\t\tbackgroundColor: \"#222222\"\n\t},\n\n\tAmCoordinateChart: {\n\t\tcolors: [\"#de4c4f\", \"#d8854f\", \"#eea638\", \"#a7a737\", \"#86a965\", \"#8aabb0\", \"#69c8ff\", \"#cfd27e\", \"#9d9888\", \"#916b8a\", \"#724887\", \"#7256bc\"]\n\t},\n\n\tAmStockChart: {\n\t\tcolors: [\"#de4c4f\", \"#d8854f\", \"#eea638\", \"#a7a737\", \"#86a965\", \"#8aabb0\", \"#69c8ff\", \"#cfd27e\", \"#9d9888\", \"#916b8a\", \"#724887\", \"#7256bc\"]\n\t},\n\n\tAmSlicedChart: {\n\t\toutlineAlpha: 1,\n\t\toutlineThickness: 2,\n\t\tlabelTickColor: \"#FFFFFF\",\n\t\tlabelTickAlpha: 0.3,\n\t\tcolors: [\"#de4c4f\", \"#d8854f\", \"#eea638\", \"#a7a737\", \"#86a965\", \"#8aabb0\", \"#69c8ff\", \"#cfd27e\", \"#9d9888\", \"#916b8a\", \"#724887\", \"#7256bc\"]\n\t},\n\n\tAmRectangularChart: {\n\t\tzoomOutButtonColor: \"#FFFFFF\",\n\t\tzoomOutButtonRollOverAlpha: 0.15,\n\t\tzoomOutButtonImage: \"lensWhite\"\n\t},\n\n\tAxisBase: {\n\t\taxisColor: \"#FFFFFF\",\n\t\taxisAlpha: 0.3,\n\t\tgridAlpha: 0.1,\n\t\tgridColor: \"#FFFFFF\",\n\t\tdashLength: 3\n\t},\n\n\tChartScrollbar: {\n\t\tbackgroundColor: \"#000000\",\n\t\tbackgroundAlpha: 0.2,\n\t\tgraphFillAlpha: 0.2,\n\t\tgraphLineAlpha: 0,\n\t\tgraphFillColor: \"#FFFFFF\",\n\t\tselectedGraphFillColor: \"#FFFFFF\",\n\t\tselectedGraphFillAlpha: 0.4,\n\t\tselectedGraphLineColor: \"#FFFFFF\",\n\t\tselectedBackgroundColor: \"#FFFFFF\",\n\t\tselectedBackgroundAlpha: 0.09,\n\t\tgridAlpha: 0.15\n\t},\n\n\tChartCursor: {\n\t\tcursorColor: \"#FFFFFF\",\n\t\tcolor: \"#000000\",\n\t\tcursorAlpha: 0.5\n\t},\n\n\tAmLegend: {\n\t\tcolor: \"#e7e7e7\"\n\t},\n\n\tAmGraph: {\n\t\tlineAlpha: 0.9\n\t},\n\n\n\tGaugeArrow: {\n\t\tcolor: \"#FFFFFF\",\n\t\talpha: 0.8,\n\t\tnailAlpha: 0,\n\t\tinnerRadius: \"40%\",\n\t\tnailRadius: 15,\n\t\tstartWidth: 15,\n\t\tborderAlpha: 0.8,\n\t\tnailBorderAlpha: 0\n\t},\n\n\tGaugeAxis: {\n\t\ttickColor: \"#FFFFFF\",\n\t\ttickAlpha: 1,\n\t\ttickLength: 15,\n\t\tminorTickLength: 8,\n\t\taxisThickness: 3,\n\t\taxisColor: \"#FFFFFF\",\n\t\taxisAlpha: 1,\n\t\tbandAlpha: 0.8\n\t},\n\n\tTrendLine: {\n\t\tlineColor: \"#c03246\",\n\t\tlineAlpha: 0.8\n\t},\n\n\t// ammap\n\tAreasSettings: {\n\t\talpha: 0.8,\n\t\tcolor: \"#666666\",\n\t\tcolorSolid: \"#000000\",\n\t\tunlistedAreasAlpha: 0.4,\n\t\tunlistedAreasColor: \"#555555\",\n\t\toutlineColor: \"#000000\",\n\t\toutlineAlpha: 0.5,\n\t\toutlineThickness: 0.5,\n\t\trollOverBrightness: 30,\n\t\tslectedBrightness: 50,\n\t\trollOverOutlineColor: \"#000000\",\n\t\tselectedOutlineColor: \"#000000\",\n\t\tunlistedAreasOutlineColor: \"#000000\",\n\t\tunlistedAreasOutlineAlpha: 0.5\n\t},\n\n\tLinesSettings: {\n\t\tcolor: \"#555555\",\n\t\talpha: 0.8\n\t},\n\n\tImagesSettings: {\n\t\talpha: 0.8,\n\t\tlabelColor: \"#FFFFFF\",\n\t\tcolor: \"#FFFFFF\",\n\t\tlabelRollOverColor: \"#3c5bdc\"\n\t},\n\n\tZoomControl: {\n\t\tbuttonFillAlpha: 0.4\n\t},\n\n\tSmallMap: {\n\t\tmapColor: \"#444444\",\n\t\trectangleColor: \"#666666\",\n\t\tbackgroundColor: \"#000000\",\n\t\tbackgroundAlpha: 0.5,\n\t\tborderColor:\"#555555\",\n\t\tborderThickness: 1,\n\t\tborderAlpha: 0.8\n\t},\n\n\t// the defaults below are set using CSS syntax, you can use any existing css property\n\t// if you don't use Stock chart, you can delete lines below\n\tPeriodSelector: {\n\t\tcolor: \"#e7e7e7\"\n\t},\n\n\tPeriodButton: {\n\t\tcolor: \"#e7e7e7\",\n\t\tbackground: \"transparent\",\n\t\topacity: 0.7,\n\t\tborder: \"1px solid rgba(255, 255, 255, .15)\",\n\t\tMozBorderRadius: \"5px\",\n\t\tborderRadius: \"5px\",\n\t\tmargin: \"1px\",\n\t\toutline: \"none\",\n\t\tboxSizing: \"border-box\"\n\t},\n\n\tPeriodButtonSelected: {\n\t\tcolor: \"#e7e7e7\",\n\t\tbackgroundColor: \"rgba(255, 255, 255, 0.1)\",\n\t\tborder: \"1px solid rgba(255, 255, 255, .3)\",\n\t\tMozBorderRadius: \"5px\",\n\t\tborderRadius: \"5px\",\n\t\tmargin: \"1px\",\n\t\toutline: \"none\",\n\t\topacity: 1,\n\t\tboxSizing: \"border-box\"\n\t},\n\n\tPeriodInputField: {\n\t\tcolor: \"#e7e7e7\",\n\t\tbackground: \"transparent\",\n\t\tborder: \"1px solid rgba(255, 255, 255, .15)\",\n\t\toutline: \"none\"\n\t},\n\n\tDataSetSelector: {\n\t\tcolor: \"#e7e7e7\",\n\t\tselectedBackgroundColor: \"rgba(255, 255, 255, .25)\",\n\t\trollOverBackgroundColor: \"rgba(255, 255, 255, .15)\"\n\t},\n\n\tDataSetCompareList: {\n\t\tcolor: \"#e7e7e7\",\n\t\tlineHeight: \"100%\",\n\t\tboxSizing: \"initial\",\n\t\twebkitBoxSizing: \"initial\",\n\t\tborder: \"1px solid rgba(255, 255, 255, .15)\"\n\t},\n\n\tDataSetSelect: {\n\t\tborder: \"1px solid rgba(255, 255, 255, .15)\",\n\t\toutline: \"none\"\n\t}\n\n};","Amasty_Reports/amcharts/themes/light.js":"AmCharts.themes.light = {\n\n\tthemeName:\"light\",\n\n\tAmChart: {\n\t\tcolor: \"#000000\", backgroundColor: \"#FFFFFF\"\n\t},\n\n\tAmCoordinateChart: {\n\t\tcolors: [\"#67b7dc\", \"#fdd400\", \"#84b761\", \"#cc4748\", \"#cd82ad\", \"#2f4074\", \"#448e4d\", \"#b7b83f\", \"#b9783f\", \"#b93e3d\", \"#913167\"]\n\t},\n\n\tAmStockChart: {\n\t\tcolors: [\"#67b7dc\", \"#fdd400\", \"#84b761\", \"#cc4748\", \"#cd82ad\", \"#2f4074\", \"#448e4d\", \"#b7b83f\", \"#b9783f\", \"#b93e3d\", \"#913167\"]\n\t},\n\n\tAmSlicedChart: {\n\t\tcolors: [\"#67b7dc\", \"#fdd400\", \"#84b761\", \"#cc4748\", \"#cd82ad\", \"#2f4074\", \"#448e4d\", \"#b7b83f\", \"#b9783f\", \"#b93e3d\", \"#913167\"],\n\t\toutlineAlpha: 1,\n\t\toutlineThickness: 2,\n\t\tlabelTickColor: \"#000000\",\n\t\tlabelTickAlpha: 0.3\n\t},\n\n\tAmRectangularChart: {\n\t\tzoomOutButtonColor: '#000000',\n\t\tzoomOutButtonRollOverAlpha: 0.15,\n\t\tzoomOutButtonImage: \"lens\"\n\t},\n\n\tAxisBase: {\n\t\taxisColor: \"#000000\",\n\t\taxisAlpha: 0.3,\n\t\tgridAlpha: 0.1,\n\t\tgridColor: \"#000000\"\n\t},\n\n\tChartScrollbar: {\n\t\tbackgroundColor: \"#000000\",\n\t\tbackgroundAlpha: 0.12,\n\t\tgraphFillAlpha: 0.5,\n\t\tgraphLineAlpha: 0,\n\t\tselectedBackgroundColor: \"#FFFFFF\",\n\t\tselectedBackgroundAlpha: 0.4,\n\t\tgridAlpha: 0.15\n\t},\n\n\tChartCursor: {\n\t\tcursorColor: \"#000000\",\n\t\tcolor: \"#FFFFFF\",\n\t\tcursorAlpha: 0.5\n\t},\n\n\tAmLegend: {\n\t\tcolor: \"#000000\"\n\t},\n\n\tAmGraph: {\n\t\tlineAlpha: 0.9\n\t},\n\tGaugeArrow: {\n\t\tcolor: \"#000000\",\n\t\talpha: 0.8,\n\t\tnailAlpha: 0,\n\t\tinnerRadius: \"40%\",\n\t\tnailRadius: 15,\n\t\tstartWidth: 15,\n\t\tborderAlpha: 0.8,\n\t\tnailBorderAlpha: 0\n\t},\n\n\tGaugeAxis: {\n\t\ttickColor: \"#000000\",\n\t\ttickAlpha: 1,\n\t\ttickLength: 15,\n\t\tminorTickLength: 8,\n\t\taxisThickness: 3,\n\t\taxisColor: '#000000',\n\t\taxisAlpha: 1,\n\t\tbandAlpha: 0.8\n\t},\n\n\tTrendLine: {\n\t\tlineColor: \"#c03246\",\n\t\tlineAlpha: 0.8\n\t},\n\n\t// ammap\n\tAreasSettings: {\n\t\talpha: 0.8,\n\t\tcolor: \"#67b7dc\",\n\t\tcolorSolid: \"#003767\",\n\t\tunlistedAreasAlpha: 0.4,\n\t\tunlistedAreasColor: \"#000000\",\n\t\toutlineColor: \"#FFFFFF\",\n\t\toutlineAlpha: 0.5,\n\t\toutlineThickness: 0.5,\n\t\trollOverColor: \"#3c5bdc\",\n\t\trollOverOutlineColor: \"#FFFFFF\",\n\t\tselectedOutlineColor: \"#FFFFFF\",\n\t\tselectedColor: \"#f15135\",\n\t\tunlistedAreasOutlineColor: \"#FFFFFF\",\n\t\tunlistedAreasOutlineAlpha: 0.5\n\t},\n\n\tLinesSettings: {\n\t\tcolor: \"#000000\",\n\t\talpha: 0.8\n\t},\n\n\tImagesSettings: {\n\t\talpha: 0.8,\n\t\tlabelColor: \"#000000\",\n\t\tcolor: \"#000000\",\n\t\tlabelRollOverColor: \"#3c5bdc\"\n\t},\n\n\tZoomControl: {\n\t\tbuttonFillAlpha:0.7,\n\t\tbuttonIconColor:\"#a7a7a7\"\n\t},\n\n\tSmallMap: {\n\t\tmapColor: \"#000000\",\n\t\trectangleColor: \"#f15135\",\n\t\tbackgroundColor: \"#FFFFFF\",\n\t\tbackgroundAlpha: 0.7,\n\t\tborderThickness: 1,\n\t\tborderAlpha: 0.8\n\t},\n\n\t// the defaults below are set using CSS syntax, you can use any existing css property\n\t// if you don't use Stock chart, you can delete lines below\n\tPeriodSelector: {\n\t\tcolor: \"#000000\"\n\t},\n\n\tPeriodButton: {\n\t\tcolor: \"#000000\",\n\t\tbackground: \"transparent\",\n\t\topacity: 0.7,\n\t\tborder: \"1px solid rgba(0, 0, 0, .3)\",\n\t\tMozBorderRadius: \"5px\",\n\t\tborderRadius: \"5px\",\n\t\tmargin: \"1px\",\n\t\toutline: \"none\",\n\t\tboxSizing: \"border-box\"\n\t},\n\n\tPeriodButtonSelected: {\n\t\tcolor: \"#000000\",\n\t\tbackgroundColor: \"#b9cdf5\",\n\t\tborder: \"1px solid rgba(0, 0, 0, .3)\",\n\t\tMozBorderRadius: \"5px\",\n\t\tborderRadius: \"5px\",\n\t\tmargin: \"1px\",\n\t\toutline: \"none\",\n\t\topacity: 1,\n\t\tboxSizing: \"border-box\"\n\t},\n\n\tPeriodInputField: {\n\t\tcolor: \"#000000\",\n\t\tbackground: \"transparent\",\n\t\tborder: \"1px solid rgba(0, 0, 0, .3)\",\n\t\toutline: \"none\"\n\t},\n\n\tDataSetSelector: {\n\n\t\tcolor: \"#000000\",\n\t\tselectedBackgroundColor: \"#b9cdf5\",\n\t\trollOverBackgroundColor: \"#a8b0e4\"\n\t},\n\n\tDataSetCompareList: {\n\t\tcolor: \"#000000\",\n\t\tlineHeight: \"100%\",\n\t\tboxSizing: \"initial\",\n\t\twebkitBoxSizing: \"initial\",\n\t\tborder: \"1px solid rgba(0, 0, 0, .3)\"\n\t},\n\n\tDataSetSelect: {\n\t\tborder: \"1px solid rgba(0, 0, 0, .3)\",\n\t\toutline: \"none\"\n\t}\n\n};","Amasty_Reports/amcharts/themes/dark.js":"AmCharts.themes.dark = {\n\n\tthemeName: \"dark\",\n\n\tAmChart: {\n\t\tcolor: \"#e7e7e7\", backgroundColor: \"#282828\"\n\t},\n\n\tAmCoordinateChart: {\n\t\tcolors: [\"#ae85c9\", \"#aab9f7\", \"#b6d2ff\", \"#c9e6f2\", \"#c9f0e1\", \"#e8d685\", \"#e0ad63\", \"#d48652\", \"#d27362\", \"#495fba\", \"#7a629b\", \"#8881cc\"]\n\t},\n\n\tAmStockChart: {\n\t\tcolors: [\"#639dbd\", \"#e8d685\", \"#ae85c9\", \"#c9f0e1\", \"#d48652\", \"#629b6d\", \"#719dc3\", \"#719dc3\"]\n\t},\n\n\tAmSlicedChart: {\n\t\toutlineAlpha: 1,\n\t\toutlineThickness: 2,\n\t\tlabelTickColor: \"#FFFFFF\",\n\t\tlabelTickAlpha: 0.3,\n\t\tcolors: [\"#495fba\", \"#e8d685\", \"#ae85c9\", \"#c9f0e1\", \"#d48652\", \"#629b6d\", \"#719dc3\", \"#719dc3\"]\n\t},\n\n\tAmRectangularChart: {\n\t\tzoomOutButtonColor: '#FFFFFF',\n\t\tzoomOutButtonRollOverAlpha: 0.15,\n\t\tzoomOutButtonImage: \"lensWhite\"\n\t},\n\n\tAxisBase: {\n\t\taxisColor: \"#FFFFFF\",\n\t\taxisAlpha: 0.3,\n\t\tgridAlpha: 0.1,\n\t\tgridColor: \"#FFFFFF\",\n\t\tdashLength: 3\n\t},\n\n\tChartScrollbar: {\n\t\tbackgroundColor: \"#000000\",\n\t\tbackgroundAlpha: 0.2,\n\t\tgraphFillAlpha: 0.2,\n\t\tgraphLineAlpha: 0,\n\t\tgraphFillColor: \"#FFFFFF\",\n\t\tselectedGraphFillColor: \"#FFFFFF\",\n\t\tselectedGraphFillAlpha: 0.4,\n\t\tselectedGraphLineColor: \"#FFFFFF\",\n\t\tselectedBackgroundColor: \"#FFFFFF\",\n\t\tselectedBackgroundAlpha: 0.09,\n\t\tgridAlpha: 0.15\n\t},\n\n\tChartCursor: {\n\t\tcursorColor: \"#FFFFFF\",\n\t\tcolor: \"#000000\",\n\t\tcursorAlpha: 0.5\n\t},\n\n\tAmLegend: {\n\t\tcolor: \"#e7e7e7\"\n\t},\n\n\tAmGraph: {\n\t\tlineAlpha: 0.9\n\t},\n\n\n\tGaugeArrow: {\n\t\tcolor: \"#FFFFFF\",\n\t\talpha: 0.8,\n\t\tnailAlpha: 0,\n\t\tinnerRadius: \"40%\",\n\t\tnailRadius: 15,\n\t\tstartWidth: 15,\n\t\tborderAlpha: 0.8,\n\t\tnailBorderAlpha: 0\n\t},\n\n\tGaugeAxis: {\n\t\ttickColor: \"#FFFFFF\",\n\t\ttickAlpha: 1,\n\t\ttickLength: 15,\n\t\tminorTickLength: 8,\n\t\taxisThickness: 3,\n\t\taxisColor: '#FFFFFF',\n\t\taxisAlpha: 1,\n\t\tbandAlpha: 0.8\n\t},\n\n\tTrendLine: {\n\t\tlineColor: \"#c03246\",\n\t\tlineAlpha: 0.8\n\t},\n\n\t// ammap\n\tAreasSettings: {\n\t\talpha: 0.8,\n\t\tcolor: \"#FFFFFF\",\n\t\tcolorSolid: \"#000000\",\n\t\tunlistedAreasAlpha: 0.4,\n\t\tunlistedAreasColor: \"#FFFFFF\",\n\t\toutlineColor: \"#000000\",\n\t\toutlineAlpha: 0.5,\n\t\toutlineThickness: 0.5,\n\t\trollOverColor: \"#3c5bdc\",\n\t\trollOverOutlineColor: \"#000000\",\n\t\tselectedOutlineColor: \"#000000\",\n\t\tselectedColor: \"#f15135\",\n\t\tunlistedAreasOutlineColor: \"#000000\",\n\t\tunlistedAreasOutlineAlpha: 0.5\n\t},\n\n\tLinesSettings: {\n\t\tcolor: \"#FFFFFF\",\n\t\talpha: 0.8\n\t},\n\n\tImagesSettings: {\n\t\talpha: 0.8,\n\t\tlabelColor: \"#FFFFFF\",\n\t\tcolor: \"#FFFFFF\",\n\t\tlabelRollOverColor: \"#3c5bdc\"\n\t},\n\n\tZoomControl: {\n\t\tbuttonFillAlpha:0.7,\n\t\tbuttonIconColor:\"#494949\"\n\t},\n\n\tSmallMap: {\n\t\tmapColor: \"#FFFFFF\",\n\t\trectangleColor: \"#FFFFFF\",\n\t\tbackgroundColor: \"#000000\",\n\t\tbackgroundAlpha: 0.7,\n\t\tborderThickness: 1,\n\t\tborderAlpha: 0.8\n\t},\n\n\t// the defaults below are set using CSS syntax, you can use any existing css property\n\t// if you don't use Stock chart, you can delete lines below\n\tPeriodSelector: {\n\t\tcolor: \"#e7e7e7\"\n\t},\n\n\tPeriodButton: {\n\t\tcolor: \"#e7e7e7\",\n\t\tbackground: \"transparent\",\n\t\topacity: 0.7,\n\t\tborder: \"1px solid rgba(255, 255, 255, .15)\",\n\t\tMozBorderRadius: \"5px\",\n\t\tborderRadius: \"5px\",\n\t\tmargin: \"1px\",\n\t\toutline: \"none\",\n\t\tboxSizing: \"border-box\"\n\t},\n\n\tPeriodButtonSelected: {\n\t\tcolor: \"#e7e7e7\",\n\t\tbackgroundColor: \"rgba(255, 255, 255, 0.1)\",\n\t\tborder: \"1px solid rgba(255, 255, 255, .3)\",\n\t\tMozBorderRadius: \"5px\",\n\t\tborderRadius: \"5px\",\n\t\tmargin: \"1px\",\n\t\toutline: \"none\",\n\t\topacity: 1,\n\t\tboxSizing: \"border-box\"\n\t},\n\n\tPeriodInputField: {\n\t\tcolor: \"#e7e7e7\",\n\t\tbackground: \"transparent\",\n\t\tborder: \"1px solid rgba(255, 255, 255, .15)\",\n\t\toutline: \"none\"\n\t},\n\n\tDataSetSelector: {\n\t\tcolor: \"#e7e7e7\",\n\t\tselectedBackgroundColor: \"rgba(255, 255, 255, .25)\",\n\t\trollOverBackgroundColor: \"rgba(255, 255, 255, .15)\"\n\t},\n\n\tDataSetCompareList: {\n\t\tcolor: \"#e7e7e7\",\n\t\tlineHeight: \"100%\",\n\t\tboxSizing: \"initial\",\n\t\twebkitBoxSizing: \"initial\",\n\t\tborder: \"1px solid rgba(255, 255, 255, .15)\"\n\t},\n\n\tDataSetSelect: {\n\t\tborder: \"1px solid rgba(255, 255, 255, .15)\",\n\t\toutline: \"none\"\n\t}\n\n};","Amasty_Reports/amcharts/themes/patterns.js":"AmCharts.themes.patterns = {\n\n\tthemeName:\"patterns\",\n\n\tAmChart: {\n\t\tcolor: \"#000000\", backgroundColor: \"#FFFFFF\"\n\t},\n\n\tAmCoordinateChart: {\n\t\tcolors:[\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\"],\n\t\tpatterns:[\n\t\t{\"url\":\"patterns/black/pattern1.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern2.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern3.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern4.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern5.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern6.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern7.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern8.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern9.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern10.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern11.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern12.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern13.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern14.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern15.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern16.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern17.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern18.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern19.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern20.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern21.png\", \"width\":4, \"height\":4}]\n\t},\n\n\n\tAmStockChart: {\n\t\tcolors:[\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\"]\n\t},\n\n\tAmPieChart: {\n\t\tdepth3D:0,\n\t\tangle:0,\n\t\tlabelRadius:10\n\t},\n\n\tAmSlicedChart: {\n\t\toutlineAlpha: 0.3,\n\t\tcolors:[\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\",\"#000000\"],\n\t\toutlineThickness: 1,\n\t\toutlineColor:\"#000000\",\n\t\tlabelTickColor: \"#000000\",\n\t\tlabelTickAlpha: 0.3,\n\t\tpatterns:[\n\t\t{\"url\":\"patterns/black/pattern1.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern2.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern3.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern4.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern5.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern6.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern7.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern8.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern9.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern10.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern11.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern12.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern13.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern14.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern15.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern16.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern17.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern18.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern19.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern20.png\", \"width\":4, \"height\":4},\n\t\t{\"url\":\"patterns/black/pattern21.png\", \"width\":4, \"height\":4}]\n\t},\n\n\tAmRectangularChart: {\n\t\tzoomOutButtonColor: '#000000',\n\t\tzoomOutButtonRollOverAlpha: 0.15,\n\t\tzoomOutButtonImage: \"lens\"\n\t},\n\n\n\n\tAxisBase: {\n\t\taxisColor: \"#000000\",\n\t\taxisAlpha: 0.3,\n\t\tgridAlpha: 0.05,\n\t\tgridColor: \"#000000\"\n\t},\n\n\tChartScrollbar: {\n\t\tbackgroundColor: \"#000000\",\n\t\tbackgroundAlpha: 0.13,\n\t\tgraphFillAlpha: 0.4,\n\t\tselectedGraphFillAlpha: 0.7,\n\t\tgraphLineAlpha: 0,\n\t\tselectedBackgroundColor: \"#FFFFFF\",\n\t\tselectedBackgroundAlpha: 0.9,\n\t\tgridAlpha: 0.15\n\t},\n\n\tChartCursor: {\n\t\tcursorColor: \"#000000\",\n\t\tcolor: \"#FFFFFF\",\n\t\tcursorAlpha: 0.5\n\t},\n\n\tAmLegend: {\n\t\tcolor: \"#000000\",\n\t\tmarkerBorderAlpha:0.1,\n\t\tmarkerSize:20,\n\t\tswitchColor:\"#000000\"\n\t},\n\n\tAmGraph: {\n\t\tlineAlpha: 0.4,\n\t\tfillAlphas:0.5\n\t},\n\n\tAmAngularGauge:{\n\t\tfaceAlpha:0.5,\n\t\tfacePattern:{\"url\":\"patterns/black/pattern1.png\", \"width\":4, \"height\":4}\n\t},\n\n\n\tGaugeArrow: {\n\t\tcolor: \"#000000\",\n\t\talpha: 1,\n\t\tnailAlpha: 1,\n\t\tinnerRadius: \"0%\",\n\t\tnailRadius: 15,\n\t\tstartWidth: 15,\n\t\tborderAlpha: 1,\n\t\tradius:\"70%\",\n\t\tnailBorderAlpha: 1\n\t},\n\n\tGaugeAxis: {\n\t\ttickColor: \"#000000\",\n\t\ttickAlpha: 1,\n\t\ttickLength: 15,\n\t\tminorTickLength: 8,\n\t\taxisThickness: 1,\n\t\taxisColor: '#000000',\n\t\taxisAlpha: 1,\n\t\tbandAlpha: 1\n\t},\n\n\tTrendLine: {\n\t\tlineColor: \"#c03246\",\n\t\tlineAlpha: 0.8\n\t},\n\n\t// ammap\n\tAreasSettings: {\n\t\talpha: 0.8,\n\t\tcolor: \"#000000\",\n\t\tcolorSolid: \"#000000\",\n\t\tunlistedAreasAlpha: 0.4,\n\t\tunlistedAreasColor: \"#000000\",\n\t\toutlineColor: \"#FFFFFF\",\n\t\toutlineAlpha: 0.5,\n\t\toutlineThickness: 0.5,\n\t\trollOverColor: \"#3c5bdc\",\n\t\trollOverOutlineColor: \"#FFFFFF\",\n\t\tselectedOutlineColor: \"#FFFFFF\",\n\t\tselectedColor: \"#f15135\",\n\t\tunlistedAreasOutlineColor: \"#FFFFFF\",\n\t\tunlistedAreasOutlineAlpha: 0.5\n\t},\n\n\tLinesSettings: {\n\t\tcolor: \"#000000\",\n\t\talpha: 0.8\n\t},\n\n\tImagesSettings: {\n\t\talpha: 0.8,\n\t\tlabelColor: \"#000000\",\n\t\tcolor: \"#000000\",\n\t\tlabelRollOverColor: \"#3c5bdc\"\n\t},\n\n\tZoomControl: {\n\t\tbuttonRollOverColor: \"#3c5bdc\",\n\t\tbuttonFillColor: \"#f15135\",\n\t\tbuttonFillAlpha: 0.8\n\t},\n\n\tSmallMap: {\n\t\tmapColor: \"#000000\",\n\t\trectangleColor: \"#FFFFFF\",\n\t\tbackgroundColor: \"#FFFFFF\",\n\t\tbackgroundAlpha: 0.7,\n\t\tborderThickness: 1,\n\t\tborderAlpha: 0.8\n\t},\n\n\t// the defaults below are set using CSS syntax, you can use any existing css property\n\t// if you don't use Stock chart, you can delete lines below\n\tPeriodSelector: {\n\t\tcolor: \"#000000\"\n\t},\n\n\tPeriodButton: {\n\t\tcolor: \"#000000\",\n\t\tbackground: \"transparent\",\n\t\topacity: 0.7,\n\t\tborder: \"1px solid rgba(0, 0, 0, .3)\",\n\t\tMozBorderRadius: \"5px\",\n\t\tborderRadius: \"5px\",\n\t\tmargin: \"1px\",\n\t\toutline: \"none\",\n\t\tboxSizing: \"border-box\"\n\t},\n\n\tPeriodButtonSelected: {\n\t\tcolor: \"#000000\",\n\t\tbackgroundColor: \"rgba(0, 0, 0, 0.1)\",\n\t\tborder: \"1px solid rgba(0, 0, 0, .3)\",\n\t\tMozBorderRadius: \"5px\",\n\t\tborderRadius: \"5px\",\n\t\tmargin: \"1px\",\n\t\toutline: \"none\",\n\t\topacity: 1,\n\t\tboxSizing: \"border-box\"\n\t},\n\n\tPeriodInputField: {\n\t\tcolor: \"#000000\",\n\t\tbackground: \"transparent\",\n\t\tborder: \"1px solid rgba(0, 0, 0, .3)\",\n\t\toutline: \"none\"\n\t},\n\n\tDataSetSelector: {\n\t\tcolor: \"#000000\",\n\t\tselectedBackgroundColor: \"rgba(0, 0, 0, .25)\",\n\t\trollOverBackgroundColor: \"rgba(0, 0, 0, .15)\"\n\t},\n\n\tDataSetCompareList: {\n\t\tcolor: \"#000000\",\n\t\tlineHeight: \"100%\",\n\t\tboxSizing: \"initial\",\n\t\twebkitBoxSizing: \"initial\",\n\t\tborder: \"1px solid rgba(0, 0, 0, .3)\"\n\t},\n\n\tDataSetSelect: {\n\t\tborder: \"1px solid rgba(0, 0, 0, .3)\",\n\t\toutline: \"none\"\n\t}\n\n};","Amasty_Reports/amcharts/themes/chalk.js":"AmCharts.themes.chalk = {\n\n\tthemeName: \"chalk\",\n\n\tAmChart: {\n\t\tcolor: \"#e7e7e7\",\n\t\tfontFamily: \"Covered By Your Grace\",\n\t\tfontSize: 18,\n\t\thandDrawn: true,\n\t\tbackgroundColor: \"#282828\"\n\t},\n\n\tAmCoordinateChart: {\n\t\tcolors: [\"#FFFFFF\", \"#e384a6\", \"#f4d499\", \"#4d90d6\", \"#c7e38c\", \"#9986c8\", \"#edf28c\", \"#ffd1d4\", \"#5ee1dc\", \"#b0eead\", \"#fef85a\", \"#8badd2\"]\n\t},\n\n\tAmSlicedChart: {\n\t\toutlineAlpha: 1,\n\t\tlabelTickColor: \"#FFFFFF\",\n\t\tlabelTickAlpha: 0.3,\n\t\tcolors: [\"#FFFFFF\", \"#e384a6\", \"#f4d499\", \"#4d90d6\", \"#c7e38c\", \"#9986c8\", \"#edf28c\", \"#ffd1d4\", \"#5ee1dc\", \"#b0eead\", \"#fef85a\", \"#8badd2\"]\n\t},\n\n\tAmStockChart: {\n\t\tcolors: [\"#FFFFFF\", \"#e384a6\", \"#f4d499\", \"#4d90d6\", \"#c7e38c\", \"#9986c8\", \"#edf28c\", \"#ffd1d4\", \"#5ee1dc\", \"#b0eead\", \"#fef85a\", \"#8badd2\"]\n\t},\n\n\tAmRectangularChart: {\n\t\tzoomOutButtonColor: '#FFFFFF',\n\t\tzoomOutButtonRollOverAlpha: 0.15,\n\t\tzoomOutButtonImage: \"lensWhite\"\n\t},\n\n\tAxisBase: {\n\t\taxisColor: \"#FFFFFF\",\n\t\tgridColor: \"#FFFFFF\"\n\t},\n\n\tChartScrollbar: {\n\t\tbackgroundColor: \"#FFFFFF\",\n\t\tbackgroundAlpha: 0.2,\n\t\tgraphFillAlpha: 0.5,\n\t\tgraphLineAlpha: 0,\n\t\tselectedBackgroundColor: \"#000000\",\n\t\tselectedBackgroundAlpha: 0.25,\n\t\tfontSize: 15,\n\t\tgridAlpha: 0.15\n\t},\n\n\tChartCursor: {\n\t\tcursorColor: \"#FFFFFF\",\n\t\tcolor: \"#000000\"\n\t},\n\n\tAmLegend: {\n\t\tcolor: \"#e7e7e7\",\n\t\tmarkerSize: 20\n\t},\n\n\tAmGraph: {\n\t\tlineAlpha: 0.8\n\t},\n\n\n\tGaugeArrow: {\n\t\tcolor: \"#FFFFFF\",\n\t\talpha: 0.1,\n\t\tnailAlpha: 0,\n\t\tinnerRadius: \"40%\",\n\t\tnailRadius: 15,\n\t\tstartWidth: 15,\n\t\tborderAlpha: 0.8,\n\t\tnailBorderAlpha: 0\n\t},\n\n\tGaugeAxis: {\n\t\ttickColor: \"#FFFFFF\",\n\t\ttickAlpha: 0.8,\n\t\ttickLength: 15,\n\t\tminorTickLength: 8,\n\t\taxisThickness: 3,\n\t\taxisColor: '#FFFFFF',\n\t\taxisAlpha: 0.8,\n\t\tbandAlpha: 0.4\n\t},\n\n\tTrendLine: {\n\t\tlineColor: \"#c03246\",\n\t\tlineAlpha: 0.8\n\t},\n\n\t// ammap\n\tAmMap: {\n\t\thandDrawn: false\n\t},\n\n\tAreasSettings: {\n\t\talpha: 0.8,\n\t\tcolor: \"#FFFFFF\",\n\t\tcolorSolid: \"#000000\",\n\t\tunlistedAreasAlpha: 0.4,\n\t\tunlistedAreasColor: \"#FFFFFF\",\n\t\toutlineColor: \"#000000\",\n\t\toutlineAlpha: 0.5,\n\t\toutlineThickness: 0.5,\n\t\trollOverColor: \"#4d90d6\",\n\t\trollOverOutlineColor: \"#000000\",\n\t\tselectedOutlineColor: \"#000000\",\n\t\tselectedColor: \"#e384a6\",\n\t\tunlistedAreasOutlineColor: \"#000000\",\n\t\tunlistedAreasOutlineAlpha: 0.5\n\t},\n\n\tLinesSettings: {\n\t\tcolor: \"#FFFFFF\",\n\t\talpha: 0.8\n\t},\n\n\tImagesSettings: {\n\t\talpha: 0.8,\n\t\tlabelFontSize: 16,\n\t\tlabelColor: \"#FFFFFF\",\n\t\tcolor: \"#FFFFFF\",\n\t\tlabelRollOverColor: \"#4d90d6\"\n\t},\n\n\tZoomControl: {\n\t\tbuttonRollOverColor: \"#4d90d6\",\n\t\tbuttonFillColor: \"#e384a6\",\n\t\tbuttonFillAlpha: 0.8\n\t},\n\n\tSmallMap: {\n\t\tmapColor: \"#FFFFFF\",\n\t\trectangleColor: \"#FFFFFF\",\n\t\tbackgroundColor: \"#000000\",\n\t\tbackgroundAlpha: 0.7,\n\t\tborderThickness: 1,\n\t\tborderAlpha: 0.8\n\t},\n\n\n\t// the defaults below are set using CSS syntax, you can use any existing css property\n\t// if you don't use Stock chart, you can delete lines below\n\tPeriodSelector: {\n\t\tfontFamily: \"Covered By Your Grace\",\n\t\tfontSize:\"16px\",\n\t\tcolor: \"#e7e7e7\"\n\t},\n\n\tPeriodButton: {\n\t\tfontFamily: \"Covered By Your Grace\",\n\t\tfontSize:\"16px\",\n\t\tcolor: \"#e7e7e7\",\n\t\tbackground: \"transparent\",\n\t\topacity: 0.7,\n\t\tborder: \"1px solid rgba(255, 255, 255, .15)\",\n\t\tMozBorderRadius: \"5px\",\n\t\tborderRadius: \"5px\",\n\t\tmargin: \"1px\",\n\t\toutline: \"none\",\n\t\tboxSizing: \"border-box\"\n\t},\n\n\tPeriodButtonSelected: {\n\t\tfontFamily: \"Covered By Your Grace\",\n\t\tfontSize:\"16px\",\n\t\tcolor: \"#e7e7e7\",\n\t\tbackgroundColor: \"rgba(255, 255, 255, 0.1)\",\n\t\tborder: \"1px solid rgba(255, 255, 255, .3)\",\n\t\tMozBorderRadius: \"5px\",\n\t\tborderRadius: \"5px\",\n\t\tmargin: \"1px\",\n\t\toutline: \"none\",\n\t\topacity: 1,\n\t\tboxSizing: \"border-box\"\n\t},\n\n\tPeriodInputField: {\n\t\tfontFamily: \"Covered By Your Grace\",\n\t\tfontSize:\"16px\",\n\t\tcolor: \"#e7e7e7\",\n\t\tbackground: \"transparent\",\n\t\tborder: \"1px solid rgba(255, 255, 255, .15)\",\n\t\toutline: \"none\"\n\t},\n\n\tDataSetSelector: {\n\t\tfontFamily: \"Covered By Your Grace\",\n\t\tfontSize:\"16px\",\n\t\tcolor: \"#e7e7e7\",\n\t\tselectedBackgroundColor: \"rgba(255, 255, 255, .25)\",\n\t\trollOverBackgroundColor: \"rgba(255, 255, 255, .15)\"\n\t},\n\n\tDataSetCompareList: {\n\t\tfontFamily: \"Covered By Your Grace\",\n\t\tfontSize:\"16px\",\n\t\tcolor: \"#e7e7e7\",\n\t\tlineHeight: \"100%\",\n\t\tboxSizing: \"initial\",\n\t\twebkitBoxSizing: \"initial\",\n\t\tborder: \"1px solid rgba(255, 255, 255, .15)\"\n\t},\n\n\tDataSetSelect: {\n\t\tfontFamily: \"Covered By Your Grace\",\n\t\tfontSize:\"16px\",\n\t\tborder: \"1px solid rgba(255, 255, 255, .15)\",\n\t\toutline: \"none\"\n\t}\n\n};","Magento_AdobeStockAdminUi/js/connection.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'uiComponent',\n    'jquery'\n], function (ko, Component, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_AdobeStockAdminUi/connection',\n            connectionFailedMessage: 'Connection test failed.',\n            emptyApiKeyMessage: 'Please fill the \"API Key (Client ID)\" field for a connection test',\n            apiKeyInputId: 'system_adobe_stock_integration_api_key',\n            url: '',\n            success: false,\n            message: '',\n            visible: false\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'success',\n                    'message',\n                    'visible'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.messageClass = ko.computed(function () {\n                return 'message-validation message message-' + (this.success() ? 'success' : 'error');\n            }, this);\n\n            if (!this.success()) {\n                this.showMessage(false, this.connectionFailedMessage);\n            }\n        },\n\n        /**\n         * @param {bool} success\n         * @param {String} message\n         */\n        showMessage: function (success, message) {\n            this.message(message);\n            this.success(success);\n            this.visible(true);\n        },\n\n        /**\n         * Send request to server to test connection to Adobe Stock API and display the result\n         */\n        testConnection: function () {\n            var apiKey = document.getElementById(this.apiKeyInputId).value;\n\n            if (apiKey.length === 0) {\n                this.showMessage(false, this.emptyApiKeyMessage);\n\n                return;\n            }\n\n            this.visible(false);\n\n            $.ajax({\n                type: 'POST',\n                url: this.url,\n                dataType: 'json',\n                data: {\n                    'api_key': apiKey\n                },\n                success: function (response) {\n                    this.showMessage(response.success === true, response.message);\n                }.bind(this),\n                error: function () {\n                    this.showMessage(false, this.connectionFailedMessage);\n                }.bind(this)\n            });\n        }\n    });\n});\n","Magento_InventoryGroupedProductAdminUi/js/form/element/grid-column-quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column'\n], function ($t, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryGroupedProductAdminUi/grid/column/quantity-per-source',\n            itemsToDisplay: 3,\n            showFullListDescription: $t('Show more...')\n        },\n\n        /**\n         * Get source items from product data.\n         *\n         * @param {Object} rowData\n         * @returns {Array}\n         */\n        getSourceItemsData: function (rowData) {\n            return rowData['quantity_per_source'];\n        }\n    });\n});\n","Magento_InventoryGroupedProductAdminUi/js/form/element/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function ($t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_InventoryGroupedProductAdminUi/dynamic-rows/cells/cell-source',\n            itemsToDisplay: 3,\n            isFullList: true,\n            showFullListDescription: $t('Show more...'),\n            listens: {\n                value: 'updateItems'\n            }\n        },\n\n        /**\n         * Observe elements.\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['items', 'isFullList']);\n\n            return this;\n        },\n\n        /**\n         * Prepare data to use.\n         *\n         * @param {Object} data\n         * @private\n         */\n        updateItems: function (data) {\n            this.isFullList(data.length > this.itemsToDisplay);\n            this.isFullList() ? this.items(data.slice(0, this.itemsToDisplay)) : this.items(data);\n        }\n    });\n});\n","Magento_InventoryInStorePickupAdminUi/js/form/components/fieldset.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'ko'\n], function (Fieldset, ko) {\n    'use strict';\n\n    /**\n     * TODO Remove when issue is resolved in core.\n     * @see Please check issue in core for more details: https://github.com/magento/magento2/issues/22067.\n     */\n    return Fieldset.extend(ko).extend(\n        {\n            /**\n             * Convert `visible` value from string ('1', '0') to bool (true, false)\n             */\n            initialize: function () {\n                this._super();\n\n                // eslint-disable-next-line vars-on-top\n                var visible = this.visible;\n\n                this.visible = ko.computed({\n                    /**\n                     * @returns {Boolean}\n                     */\n                    read: function () {\n                        return visible();\n                    },\n\n                    /**\n                     * @param {String} value\n                     */\n                    write: function (value) {\n                        value = Boolean(value) === value ? value : Boolean(parseInt(value, 10));\n                        visible(value);\n                    },\n                    owner: this\n                });\n                this.visible(visible());\n            }\n        }\n    );\n});\n","Magento_InventoryInStorePickupAdminUi/js/form/element/conditional-required.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'ko',\n    'underscore',\n    'mageUtils'\n], function (uiElement, ko, _, utils) {\n    'use strict';\n\n    /**\n     * Provide possibility to make field required by dependency on other field value.\n     */\n    return uiElement.extend(\n        {\n            /**\n             * Convert `required` value from string ('1', '0') to bool (true, false)\n             */\n            initialize: function () {\n                this._super();\n\n                // eslint-disable-next-line vars-on-top\n                var required = this.required;\n\n                this.required = ko.computed({\n                    /**\n                     * @returns {Boolean}\n                     */\n                    read: function () {\n                        return required();\n                    },\n\n                    /**\n                     * @param {String|Boolean} value\n                     */\n                    write: function (value) {\n                        value = Boolean(value) === value ? value : Boolean(parseInt(value, 10));\n\n                        if (required() !== value) {\n                            required(value);\n                            this.setValidation('required-entry', required());\n                        }\n                    },\n                    owner: this\n                });\n                this.required(required());\n            },\n\n            /**\n             * @param {(String|Object)} rule\n             * @param {(Object|Boolean)} [options]\n             * @returns {Abstract} Chainable.\n             */\n            setValidation: function (rule, options) {\n                var rules = utils.copy(this.validation),\n                    changed;\n\n                if (_.isObject(rule)) {\n                    _.extend(this.validation, rule);\n                } else {\n                    this.validation[rule] = options;\n                }\n\n                changed = !utils.compare(rules, this.validation).equal;\n\n                if (changed) {\n                    this.required(!!this.validation['required-entry']);\n                    this.validate();\n                }\n\n                return this;\n            }\n        }\n    );\n});\n","Magento_AsynchronousOperations/js/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form',\n    'uiRegistry'\n], function (Insert, registry) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            modalProvider: '${ $.parentName }',\n            titlePrefix: '',\n            imports: {\n                changeModalTitle: '${ $.modalProvider }:state'\n            },\n            listens: {\n                responseData: 'afterRetry'\n            },\n            modules: {\n                modal: '${ $.modalProvider }',\n                notificationListing: '${ $.columnsProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            var modalTitleProvider;\n\n            this._super();\n            modalTitleProvider = this.modalTitleProvider.split(':');\n            this.modalTitleTarget = modalTitleProvider[0];\n            this.modalTitlePath = modalTitleProvider[1];\n        },\n\n        /**\n         * Change modal title.\n         *\n         * @param {Boolean} change\n         */\n        changeModalTitle: function (change) {\n            if (change) {\n                registry.get(this.modalTitleTarget, function (target) {\n                    this.modal().setTitle(this.titlePrefix + target.get(this.modalTitlePath));\n                }.bind(this));\n            } else {\n                this.modal().setTitle('');\n            }\n        },\n\n        /**\n         * Action after retry operation.\n         *\n         * @param {Object} data\n         */\n        afterRetry: function (data) {\n            if (!data.error) {\n                this.modal().closeModal();\n                this.notificationListing().reload();\n            }\n        }\n    });\n});\n","Magento_AsynchronousOperations/js/form/error.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        /** @inheritdoc */\n        onUpdate: function () {\n            this.bubble('update', this.hasChanged());\n        }\n    });\n});\n","Magento_AsynchronousOperations/js/grid/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_AdminNotification/js/grid/listing',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate',\n    'underscore',\n    'jquery'\n], function (Listing, uiAlert, $t, _, $) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            isAllowed: true,\n            ajaxSettings: {\n                method: 'POST',\n                data: {},\n                url: '${ $.dismissUrl }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            _.bindAll(this, 'reload', 'onError');\n\n            return this._super();\n        },\n\n        /**\n         * Dismiss all items.\n         */\n        dismissAll: function () {\n            var toDismiss = [];\n\n            _.each(this.rows, function (row) {\n                if (row.dismiss) {\n                    toDismiss.push(row.uuid);\n                }\n            });\n            toDismiss.length && this.dismiss(toDismiss);\n        },\n\n        /**\n         * Dismiss action.\n         *\n         * @param {Array} items\n         */\n        dismiss: function (items) {\n            var config = _.extend({}, this.ajaxSettings);\n\n            config.data.uuid = items;\n            this.showLoader();\n\n            $.ajax(config)\n                .done(this.reload)\n                .fail(this.onError);\n        },\n\n        /**\n         * Success callback for dismiss request.\n         */\n        reload: function () {\n            this.source.reload({\n                refresh: true\n            });\n        },\n\n        /**\n         * Error callback for dismiss request.\n         *\n         * @param {Object} xhr\n         */\n        onError: function (xhr) {\n            this.hideLoader();\n\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            uiAlert({\n                content: $t('Something went wrong.')\n            });\n        }\n    });\n});\n","Magento_PageBuilderAdminAnalytics/js/page-builder/event-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['underscore'], function (_) {\n    'use strict';\n\n    return {\n\n        /**\n         * Sets up event attributes and action depending on name and args\n         *\n         * @param {String} name\n         * @param {Array} args\n         */\n\n        build: function (name, args) {\n            var action = '',\n                eventAttributes = {},\n                event;\n\n            if (_.isUndefined(args)) {\n                return;\n            }\n\n            switch (name) {\n                case 'contentType:duplicateAfter':\n                    action = 'duplicate';\n                    break;\n\n                case 'contentType:removeAfter':\n                    action = 'remove';\n                    break;\n\n                case 'contentType:createAfter':\n                    action = 'create';\n                    break;\n\n                case 'contentType:editBefore':\n                    action = 'edit';\n                    break;\n\n                case 'contentType:visibilityAfter':\n                    action = args.visibility ? 'show' : 'hide';\n                    break;\n\n                default:\n                    break;\n            }\n\n            if (!_.isUndefined(args.contentType)) {\n                eventAttributes = args.contentType.config;\n            } else if (!_.isUndefined(args.originalContentType)) {\n                eventAttributes = args.originalContentType.config;\n            }\n\n            if (action !== '' && !_.isEmpty(eventAttributes)) {\n                event = {\n                    element: eventAttributes.label,\n                    type: eventAttributes.name,\n                    action: action,\n                    widget: {\n                        name: eventAttributes.form,\n                        type: eventAttributes['menu_section']\n                    },\n                    feature: 'page-builder-tracker'\n                };\n            }\n\n            return event;\n        }\n    };\n});\n","Magento_PageBuilderAdminAnalytics/js/page-builder/events-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['underscore', 'Magento_PageBuilderAdminAnalytics/js/page-builder/event-builder'],\n    function (_, EventBuilder) {\n        'use strict';\n\n        return function (target) {\n            var originalTarget = target.trigger,\n                isAdminAnalyticsEnabled,\n                event,\n                hasPageBuilderBeenUsed = false,\n                delayedPush;\n\n            /**\n             * Invokes custom code to track information regarding Page Builder usage\n             *\n             * @param {String} name\n             * @param {Array} args\n             */\n\n            target.trigger = function (name, args) {\n                originalTarget.apply(originalTarget, [name, args]);\n                isAdminAnalyticsEnabled =\n                    !_.isUndefined(window.digitalData) &&\n                    !_.isUndefined(window._satellite);\n\n                if (!hasPageBuilderBeenUsed && name.indexOf('stage:fullScreenModeChangeAfter') !== -1 &&\n                    args.fullScreen && isAdminAnalyticsEnabled\n                ) {\n                    hasPageBuilderBeenUsed = true;\n                    window.digitalData.page.url = window.location.href;\n                    window.digitalData.page.attributes = {\n                        editedWithPageBuilder: 'true'\n                    };\n                    window._satellite.track('page');\n                }\n\n                event = EventBuilder.build(name, args);\n\n                if (isAdminAnalyticsEnabled && !_.isUndefined(window.digitalData.event) && !_.isUndefined(event)) {\n                    delayedPush = setInterval(function (object) {\n                        if (_.isArray(window.digitalData.event)) {\n                            window.digitalData.event.push(object);\n                            window._satellite.track('event');\n                            clearInterval(delayedPush);\n                        }\n                    }, 500, event);\n                }\n            };\n\n            return target;\n        };\n    });\n","Magento_Customer/js/form/components/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form'\n], function (Insert) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            listens: {\n                responseData: 'onResponse'\n            },\n            modules: {\n                addressListing: '${ $.addressListingProvider }',\n                addressModal: '${ $.addressModalProvider }'\n            }\n        },\n\n        /**\n         * Close modal, reload customer address listing and save customer address\n         *\n         * @param {Object} responseData\n         */\n        onResponse: function (responseData) {\n            var data;\n\n            if (!responseData.error) {\n                this.addressModal().closeModal();\n                this.addressListing().reload({\n                    refresh: true\n                });\n                data = this.externalSource().get('data');\n                this.saveAddress(responseData, data);\n            }\n        },\n\n        /**\n         * Save customer address to customer form data source\n         *\n         * @param {Object} responseData\n         * @param {Object} data - customer address\n         */\n        saveAddress: function (responseData, data) {\n            data['entity_id'] = responseData.data['entity_id'];\n\n            if (parseFloat(data['default_billing'])) {\n                this.source.set('data.default_billing_address', data);\n            } else if (\n                parseFloat(this.source.get('data.default_billing_address')['entity_id']) === data['entity_id']\n            ) {\n                this.source.set('data.default_billing_address', []);\n            }\n\n            if (parseFloat(data['default_shipping'])) {\n                this.source.set('data.default_shipping_address', data);\n            } else if (\n                parseFloat(this.source.get('data.default_shipping_address')['entity_id']) === data['entity_id']\n            ) {\n                this.source.set('data.default_shipping_address', []);\n            }\n        },\n\n        /**\n         * Event method that closes \"Edit customer address\" modal and refreshes grid after customer address\n         * was removed through \"Delete\" button on the \"Edit customer address\" modal\n         *\n         * @param {String} id - customer address ID to delete\n         */\n        onAddressDelete: function (id) {\n            this.addressModal().closeModal();\n            this.addressListing().reload({\n                refresh: true\n            });\n            this.addressListing()._delete([parseFloat(id)]);\n        }\n    });\n});\n","Magento_Customer/js/form/components/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/form/form',\n    'underscore',\n    'mage/translate'\n], function ($, uiAlert, uiConfirm, Form, _, $t) {\n    'use strict';\n\n    return Form.extend({\n        defaults: {\n            deleteConfirmationMessage: '',\n            ajaxSettings: {\n                method: 'POST',\n                dataType: 'json'\n            }\n        },\n\n        /**\n         * Delete customer address by provided url.\n         * Will call confirmation message to be sure that user is really wants to delete this address\n         *\n         * @param {String} url - ajax url\n         */\n        deleteAddress: function (url) {\n            var that = this;\n\n            uiConfirm({\n                content: this.deleteConfirmationMessage,\n                actions: {\n                    /** @inheritdoc */\n                    confirm: function () {\n                        that._delete(url);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Perform asynchronous DELETE request to server.\n         * @param {String} url - ajax url\n         * @returns {Deferred}\n         */\n        _delete: function (url) {\n            var settings = _.extend({}, this.ajaxSettings, {\n                    url: url,\n                    data: {\n                        'form_key': window.FORM_KEY\n                    }\n                }),\n                that = this;\n\n            $('body').trigger('processStart');\n\n            return $.ajax(settings)\n                .done(function (response) {\n                    if (response.error) {\n                        uiAlert({\n                            content: response.message\n                        });\n                    } else {\n                        that.trigger('deleteAddressAction', that.source.get('data.entity_id'));\n                    }\n                })\n                .fail(function () {\n                    uiAlert({\n                        content: $t('Sorry, there has been an error processing your request. Please try again later.')\n                    });\n                })\n                .always(function () {\n                    $('body').trigger('processStop');\n                });\n\n        }\n    });\n});\n","Magento_Customer/js/form/components/insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-listing',\n    'underscore'\n], function (Insert, _) {\n    'use strict';\n\n    return Insert.extend({\n\n        /**\n         * On action call\n         *\n         * @param {Object} data - customer address and actions\n         */\n        onAction: function (data) {\n            this[data.action + 'Action'].call(this, data.data);\n        },\n\n        /**\n         * On mass action call\n         *\n         * @param {Object} data - customer address\n         */\n        onMassAction: function (data) {\n            this[data.action + 'Massaction'].call(this, data.data);\n        },\n\n        /**\n         * Set default billing address\n         *\n         * @param {Object} data - customer address\n         */\n        setDefaultBillingAction: function (data) {\n            this.source.set('data.default_billing_address', data);\n        },\n\n        /**\n         * Set default shipping address\n         *\n         * @param {Object} data - customer address\n         */\n        setDefaultShippingAction: function (data) {\n            this.source.set('data.default_shipping_address', data);\n        },\n\n        /**\n         * Delete customer address\n         *\n         * @param {Object} data - customer address\n         */\n        deleteAction: function (data) {\n            this._delete([parseFloat(data[data['id_field_name']])]);\n        },\n\n        /**\n         * Mass action delete\n         *\n         * @param {Object} data - customer address\n         */\n        deleteMassaction: function (data) {\n            var ids = data.selected || this.selections().selected();\n\n            ids = _.map(ids, function (val) {\n                return parseFloat(val);\n            });\n\n            this._delete(ids);\n        },\n\n        /**\n         * Delete customer address and selections by provided ids.\n         *\n         * @param {Array} ids\n         */\n        _delete: function (ids) {\n            var defaultShippingId = parseFloat(this.source.get('data.default_shipping_address.entity_id')),\n                defaultBillingId = parseFloat(this.source.get('data.default_billing_address.entity_id'));\n\n            if (ids.indexOf(defaultShippingId) !== -1) {\n                this.source.set('data.default_shipping_address', []);\n            }\n\n            if (ids.indexOf(defaultBillingId) !== -1) {\n                this.source.set('data.default_billing_address', []);\n            }\n\n            _.each(ids, function (id) {\n                this.selections().deselect(id.toString(), false);\n            }, this);\n        }\n    });\n});\n","Magento_Customer/js/form/element/website.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/website',\n    'uiRegistry'\n], function (Website, registry) {\n    'use strict';\n\n    return Website.extend({\n        /**\n         * On value change handler.\n         *\n         * @param {String} value\n         */\n        onUpdate: function (value) {\n            var groupIdFieldKey = 'group_id',\n                sendEmailStoreIdFieldKey = 'sendemail_store_id',\n                groupId = registry.get('index = ' + groupIdFieldKey),\n                sendEmailStoreId = registry.get('index = ' + sendEmailStoreIdFieldKey),\n                option = this.getOption(value);\n\n            if (groupId) {\n                groupId.value(option[groupIdFieldKey]);\n            }\n\n            if (sendEmailStoreId && option['default_store_view_id']) {\n                sendEmailStoreId.value(option['default_store_view_id']);\n            }\n            return this._super();\n        }\n    });\n});\n","Magento_Customer/js/form/element/country.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/country'\n], function (Country) {\n    'use strict';\n\n    return Country.extend({\n        defaults: {\n            countryScope: 'data.country'\n        },\n\n        /**\n         * Set country to customer address form\n         *\n         * @param {String} value - country\n         */\n        setDifferedFromDefault: function (value) {\n            this._super();\n\n            if (value) {\n                this.source.set(this.countryScope, this.indexedOptions[value].label);\n            }\n        }\n    });\n});\n","Magento_Customer/js/form/element/region.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/region'\n], function (Region) {\n    'use strict';\n\n    return Region.extend({\n        defaults: {\n            regionScope: 'data.region'\n        },\n\n        /**\n         * Set region to customer address form\n         *\n         * @param {String} value - region\n         */\n        setDifferedFromDefault: function (value) {\n            this._super();\n\n            if (parseFloat(value)) {\n                this.source.set(this.regionScope, this.indexedOptions[value].label);\n            }\n        }\n    });\n});\n","Magento_Customer/js/bootstrap/customer-post-action.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'Magento_Customer/edit/post-wrapper'\n]);\n","Magento_Customer/js/address/default-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/button',\n    'underscore'\n], function (Button, _) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            entityId: null,\n            parentId: null,\n            listens: {\n                entity: 'changeVisibility'\n            }\n        },\n\n        /**\n         * Apply action on target component,\n         * but previously create this component from template if it is not existed\n         *\n         * @param {Object} action - action configuration\n         */\n        applyAction: function (action) {\n            if (action.params && action.params[0]) {\n                action.params[0]['entity_id'] = this.entityId;\n                action.params[0]['parent_id'] = this.parentId;\n            } else {\n                action.params = [{\n                    'entity_id': this.entityId,\n                    'parent_id': this.parentId\n                }];\n            }\n\n            this._super();\n        },\n\n        /**\n         * Change visibility of the default address shipping/billing blocks\n         *\n         * @param {Object} entity - customer address\n         */\n        changeVisibility: function (entity) {\n            this.visible(!_.isEmpty(entity));\n        }\n    });\n});\n","Magento_Customer/js/grid/massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/massactions',\n    'Magento_Ui/js/modal/alert',\n    'underscore',\n    'jquery',\n    'mage/translate'\n], function (Massactions, uiAlert, _, $, $t) {\n    'use strict';\n\n    return Massactions.extend({\n        defaults: {\n            ajaxSettings: {\n                method: 'POST',\n                dataType: 'json'\n            },\n            listens: {\n                massaction: 'onAction'\n            }\n        },\n\n        /**\n         * Reload customer addresses listing\n         *\n         * @param {Object} data\n         */\n        onAction: function (data) {\n            if (data.action === 'delete') {\n                this.source.reload({\n                    refresh: true\n                });\n            }\n        },\n\n        /**\n         * Default action callback. Send selections data\n         * via POST request.\n         *\n         * @param {Object} action - Action data.\n         * @param {Object} data - Selections data.\n         */\n        defaultCallback: function (action, data) {\n            var itemsType, selections;\n\n            if (action.isAjax) {\n                itemsType = data.excludeMode ? 'excluded' : 'selected';\n                selections = {};\n\n                selections[itemsType] = data[itemsType];\n\n                if (!selections[itemsType].length) {\n                    selections[itemsType] = false;\n                }\n\n                _.extend(selections, data.params || {});\n\n                this.request(action.url, selections).done(function (response) {\n                    if (!response.error) {\n                        this.trigger('massaction', {\n                            action: action.type,\n                            data: selections\n                        });\n                    }\n                }.bind(this));\n            } else {\n                this._super();\n            }\n        },\n\n        /**\n         * Send customer address listing mass action ajax request\n         *\n         * @param {String} href\n         * @param {Object} data\n         */\n        request: function (href, data) {\n            var settings = _.extend({}, this.ajaxSettings, {\n                url: href,\n                data: data\n            });\n\n            $('body').trigger('processStart');\n\n            return $.ajax(settings)\n                .done(function (response) {\n                    if (response.error) {\n                        uiAlert({\n                            content: response.message\n                        });\n                    }\n                })\n                .fail(function () {\n                    uiAlert({\n                        content: $t('Sorry, there has been an error processing your request. Please try again later.')\n                    });\n                })\n                .always(function () {\n                    $('body').trigger('processStop');\n                });\n        }\n    });\n});\n","Magento_Customer/js/grid/columns/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/actions',\n    'Magento_Ui/js/modal/alert',\n    'underscore',\n    'jquery',\n    'mage/translate'\n], function (Actions, uiAlert, _, $, $t) {\n    'use strict';\n\n    return Actions.extend({\n        defaults: {\n            ajaxSettings: {\n                method: 'POST',\n                dataType: 'json'\n            },\n            listens: {\n                action: 'onAction'\n            },\n            ignoreTmpls: {\n                fieldAction: true,\n                options: true,\n                action: true\n            }\n        },\n\n        /**\n         * Reload customer address listing data source after customer address delete action\n         *\n         * @param {Object} data\n         */\n        onAction: function (data) {\n            if (data.action === 'delete') {\n                this.source().reload({\n                    refresh: true\n                });\n            }\n        },\n\n        /**\n         * Default action callback. Redirects to\n         * the specified in action's data url.\n         *\n         * @param {String} actionIndex - Action's identifier.\n         * @param {(Number|String)} recordId - Id of the record associated\n         *      with a specified action.\n         * @param {Object} action - Action's data.\n         */\n        defaultCallback: function (actionIndex, recordId, action) {\n            if (action.isAjax) {\n                this.request(action.href).done(function (response) {\n                    var data;\n\n                    if (!response.error) {\n                        data = _.findWhere(this.rows, {\n                            _rowIndex: action.rowIndex\n                        });\n\n                        this.trigger('action', {\n                            action: actionIndex,\n                            data: data\n                        });\n                    }\n                }.bind(this));\n\n            } else {\n                this._super();\n            }\n        },\n\n        /**\n         * Send customer address listing ajax request\n         *\n         * @param {String} href\n         */\n        request: function (href) {\n            var settings = _.extend({}, this.ajaxSettings, {\n                url: href,\n                data: {\n                    'form_key': window.FORM_KEY\n                }\n            });\n\n            $('body').trigger('processStart');\n\n            return $.ajax(settings)\n                .done(function (response) {\n                    if (response.error) {\n                        uiAlert({\n                            content: response.message\n                        });\n                    }\n                })\n                .fail(function () {\n                    uiAlert({\n                        content: $t('Sorry, there has been an error processing your request. Please try again later.')\n                    });\n                })\n                .always(function () {\n                    $('body').trigger('processStop');\n                });\n        }\n    });\n});\n","Magento_Customer/js/grid/filters/filters.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/filters/filters'\n], function (Filters) {\n    'use strict';\n\n    return Filters.extend({\n        defaults: {\n            chipsConfig: {\n                name: '${ $.name }_chips',\n                provider: '${ $.chipsConfig.name }',\n                component: 'Magento_Customer/js/grid/filters/chips'\n            }\n        }\n    });\n});\n","Magento_Customer/js/grid/filters/chips.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/filters/chips'\n], function (Chips) {\n    'use strict';\n\n    return Chips.extend({\n\n        /**\n         * Clear previous filters while initializing element to prevent filters sharing between customers\n         *\n         * @param {Object} elem\n         */\n        initElement: function (elem) {\n            this.clear();\n            this._super(elem);\n        }\n    });\n});\n","Magento_Customer/edit/post-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function ($, confirm) {\n    'use strict';\n\n    /**\n     * @param {String} url\n     * @returns {Object}\n     */\n    function getForm(url) {\n        return $('<form>', {\n            'action': url,\n            'method': 'POST'\n        }).append($('<input>', {\n            'name': 'form_key',\n            'value': window.FORM_KEY,\n            'type': 'hidden'\n        }));\n    }\n\n    $('#customer-edit-delete-button').on('click', function () {\n        var msg = $.mage.__('Are you sure you want to do this?'),\n            url = $('#customer-edit-delete-button').data('url');\n\n        confirm({\n            'content': msg,\n            'actions': {\n\n                /**\n                 * 'Confirm' action handler.\n                 */\n                confirm: function () {\n                    getForm(url).appendTo('body').submit();\n                }\n            }\n        });\n\n        return false;\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/attribute/edit/inventory/toggle/toggle-editability.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    $('[data-role=toggle-editability]').on('change', function () {\n        var useConfigSettings = $(this),\n            field = useConfigSettings.parents('.field'),\n            someEditable = $('input[type!=\"checkbox\"], select, textarea', field);\n\n        someEditable.prop('disabled', useConfigSettings.prop('checked'));\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/attribute/edit/inventory/toggle/toggle-editability-all.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    $('[data-role=toggle-editability-all]').on('change', function () {\n        var toggler = $(this),\n            field = toggler.parents('.field'),\n            someEditable = $('input[type!=\"checkbox\"], select, textarea', field),\n            someEditableCheckboxes = $('input[type=\"checkbox\"]', field).not(toggler);\n\n        if (someEditableCheckboxes.length) {\n            someEditable.prop('disabled', !toggler.prop('checked') || someEditableCheckboxes.prop('checked'));\n            someEditableCheckboxes.prop('disabled', !toggler.prop('checked'));\n        } else {\n            someEditable.prop('disabled', !toggler.prop('checked'));\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_CatalogInventory/js/components/qty-validator-changer'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            links: {\n                value: false\n            }\n        },\n\n        /** @inheritdoc */\n        getInitialValue: function () {\n            var values = [this.source.get(this.dataScope), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /** @inheritdoc */\n        setDifferedFromDefault: function () {\n            var initialValue;\n\n            this._super();\n            initialValue = this.source.data.product['current_product_id'] !== null ? this.initialValue : 0;\n\n            if (this.value() &&\n                parseFloat(initialValue) !== parseFloat(this.value())\n            ) {\n                this.source.set(this.dataScope, this.value());\n            } else {\n                this.source.remove(this.dataScope);\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/source-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'uiRegistry',\n    'underscore'\n], function (Fieldset, registry, _) {\n    'use strict';\n\n    return Fieldset.extend({\n        defaults: {\n            advancedInventoryButtonIndex: '',\n            imports: {\n                onStockChange: '${ $.provider }:data.product.stock_data.manage_stock'\n            }\n        },\n\n        /**\n         * \"Advanced Inventory\" button should stay active in any case.\n         *\n         * @param {Integer} canManageStock\n         */\n        onStockChange: function (canManageStock) {\n            var advancedInventoryButton = registry.get('index = ' + this.advancedInventoryButtonIndex);\n\n            if (canManageStock === 0) {\n                if (!_.isUndefined(advancedInventoryButton)) {\n                    advancedInventoryButton.disabled(false);\n                }\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/stock-status.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            links: {\n                linkedValue: false\n            }\n        },\n\n        /** @inheritdoc */\n        getInitialValue: function () {\n            var values = [this.source.get(this.dataScope), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /** @inheritdoc */\n        setDifferedFromDefault: function () {\n            this._super();\n\n            if (parseFloat(this.initialValue) !== parseFloat(this.value())) {\n                this.source.set(this.dataScope, this.value());\n            } else {\n                this.source.remove(this.dataScope);\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/sources/qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_CatalogInventory/js/components/qty-validator-changer'\n], function (Validator) {\n    'use strict';\n\n    return Validator.extend({\n\n        /**\n         * Set default value for source quantity, depends on 'Use Decimal\" value.\n         *\n         * @param {Integer} isDecimal\n         * @returns void\n         */\n        setDefaultValue: function (isDecimal) {\n            if (!this.value()) {\n                isDecimal ? this.value('0.0') : this.value('0');\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/grid/cell/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryCatalogAdminUi/product/grid/cell/source-items.html',\n            itemsToDisplay: 5\n        },\n\n        /**\n         * Get source items data (source name and qty)\n         *\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourceItemsData: function (record) {\n            return record[this.index] ? record[this.index] : [];\n        },\n\n        /**\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourceItemsDataCut: function (record) {\n            return this.getSourceItemsData(record).slice(0, this.itemsToDisplay);\n        }\n    });\n});\n","Magento_InventoryInStorePickupSalesAdminUi/order/create/trigger-shipping-method-update.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(\n    [\n        'jquery',\n        'Magento_Sales/order/create/form'\n    ],\n    function ($) {\n        'use strict';\n\n        return function () {\n            var storePickupCheckbox = $('#s_method_instore_pickup');\n\n            if (storePickupCheckbox.length && storePickupCheckbox.prop('checked')) {\n                window.order.setShippingMethod(storePickupCheckbox.val());\n            }\n        };\n    }\n);\n","Magento_InventoryInStorePickupSalesAdminUi/order/create/scripts-mixin.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(\n    [\n        'jquery',\n        'prototype'\n    ],\n    function (jQuery) {\n        'use strict';\n\n        return function () {\n            var STORE_PICKUP_METHOD = 'instore_pickup',\n                SOURCES_FIELD_SELECTOR = '#shipping_form_pickup_location_source',\n                SAME_AS_BILLING_SELECTOR = '#order-shipping_same_as_billing',\n                CUSTOMER_SHIPPING_ADDRESS_ID_SELECTOR = '#order-shipping_address_customer_address_id',\n                CUSTOMER_ADDRESS_SAVE_IN_ADDRESS_BOOK_SELECTOR = '#order-shipping_address_save_in_address_book',\n                IN_STORE_PICKUP_CHECKBOX_SELECTOR = '#s_method_instore_pickup';\n\n            /**\n             * Display sources dropdown field;\n             * And vice-versa\n             *\n             * @param {Boolean} isStorePickup\n             */\n            function setStorePickupMethod(isStorePickup) {\n                var sourcesInput = jQuery(SOURCES_FIELD_SELECTOR),\n                    shippingAddressSaveInAddressBook = jQuery(CUSTOMER_ADDRESS_SAVE_IN_ADDRESS_BOOK_SELECTOR);\n\n                if (isStorePickup) {\n                    shippingAddressSaveInAddressBook.prop('checked', false);\n                    sourcesInput.show();\n\n                    return;\n                }\n                window.order.disableShippingAddress(jQuery(SAME_AS_BILLING_SELECTOR).prop('checked'));\n                sourcesInput.hide();\n            }\n\n            /**\n             * Verify is store pickup delivery method is checked.\n             */\n            function isStorePickupSelected() {\n                var storePickupCheckbox = jQuery(IN_STORE_PICKUP_CHECKBOX_SELECTOR);\n\n                return storePickupCheckbox.length && storePickupCheckbox.prop('checked');\n            }\n\n            /**\n             * Always disable unwanted shipping address fields in case store pickup is selected.\n             */\n            window.AdminOrder.prototype.disableShippingAddress =\n                window.AdminOrder.prototype.disableShippingAddress.wrap(function (proceed, flag) {\n                    var shippingAddressId = jQuery(CUSTOMER_SHIPPING_ADDRESS_ID_SELECTOR),\n                        theSameAsBillingCheckBox = jQuery(SAME_AS_BILLING_SELECTOR),\n                        shippingAddressSaveInAddressBook = jQuery(CUSTOMER_ADDRESS_SAVE_IN_ADDRESS_BOOK_SELECTOR);\n\n                    proceed(flag);\n\n                    if (isStorePickupSelected()) {\n                        shippingAddressId.prop('disabled', true);\n                        theSameAsBillingCheckBox.prop('disabled', true);\n                        shippingAddressSaveInAddressBook.prop('disabled', true);\n                    }\n                });\n\n            /**\n             * Set shipping method override\n             *\n             * @param {String} method\n             */\n            window.AdminOrder.prototype.setShippingMethod = function (method) {\n                var data = {},\n                    areas = [\n                        'shipping_method',\n                        'totals',\n                        'billing_method',\n                        'shipping_address'\n                    ];\n\n                data['order[shipping_method]'] = method;\n\n                if (method === STORE_PICKUP_METHOD) {\n                    data = this.serializeData(this.shippingAddressContainer).toObject();\n                    data['order[shipping_method]'] = method;\n                    data['shipping_as_billing'] = 0;\n                    data['save_in_address_book'] = 0;\n                    this.shippingAsBilling = 0;\n                    this.saveInAddressBook = 0;\n                }\n\n                this.loadArea(areas, true, data).then(\n                    function () {\n                        setStorePickupMethod(method === STORE_PICKUP_METHOD);\n                    }\n                );\n            };\n\n            /**\n             * Replace shipping method area.\n             * Restore store pickup shipping method if it was already selected.\n             */\n            window.AdminOrder.prototype.resetShippingMethod = function () {\n                var storePickupCheckbox = jQuery(IN_STORE_PICKUP_CHECKBOX_SELECTOR);\n\n                if (!this.isOnlyVirtualProduct) {\n                    /* eslint-disable no-undef */\n                    $(this.getAreaId('shipping_method')).update(this.shippingTemplate);\n\n                    if (isStorePickupSelected()) {\n                        window.order.setShippingMethod(storePickupCheckbox.val());\n                    }\n                }\n            };\n        };\n    }\n);\n","MageBig_SmartMenu/js/form/element/options.js":"define(['underscore', 'uiRegistry', 'Magento_Ui/js/form/element/select', 'jquery', 'domReady!'], function(_, uiRegistry, select, $) {\r\n    'use strict';\r\n    return select.extend({\r\n        /**\r\n         * Init\r\n         */\r\n        initialize: function() {\r\n            this._super();\r\n            var value = this.value();\r\n            this.fieldDepend(value, 'smartmenu_cat_column');\r\n            this.fieldDepend(value, 'smartmenu_static_top');\r\n            this.fieldDepend(value, 'smartmenu_static_bottom');\r\n            this.fieldDepend(value, 'smartmenu_block_left');\r\n            this.fieldDepend(value, 'smartmenu_static_left');\r\n            this.fieldDepend(value, 'smartmenu_block_right');\r\n            this.fieldDepend(value, 'smartmenu_static_right');\r\n            return this;\r\n        },\r\n        /**\r\n         * On value change handler.\r\n         *\r\n         * @param {String} value\r\n         */\r\n        onUpdate: function(value) {\r\n            this.fieldDepend(value, 'smartmenu_cat_column');\r\n            this.fieldDepend(value, 'smartmenu_static_top');\r\n            this.fieldDepend(value, 'smartmenu_static_bottom');\r\n            this.fieldDepend(value, 'smartmenu_block_left');\r\n            this.fieldDepend(value, 'smartmenu_static_left');\r\n            this.fieldDepend(value, 'smartmenu_block_right');\r\n            this.fieldDepend(value, 'smartmenu_static_right');\r\n            return this._super();\r\n        },\r\n        /**\r\n         * Update field dependency\r\n         *\r\n         * @param {String} value\r\n         */\r\n        fieldDepend: function(value, field) {\r\n            setTimeout(function () {\r\n                var fieldIndex = uiRegistry.get('index = ' + field);\r\n                if (fieldIndex.visibleValue != 'undefined') {\r\n                    if (value == fieldIndex.visibleValue) {\r\n                        fieldIndex.show();\r\n                    } else {\r\n                        fieldIndex.hide();\r\n                    }\r\n                }\r\n            });\r\n            return this;\r\n        }\r\n    });\r\n});","js/theme.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine('globalNavigationScroll', [\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var win = $(window),\n        subMenuClass = '.submenu',\n        fixedClassName = '_fixed',\n        menu = $('.menu-wrapper'),\n        content = $('.page-wrapper'),\n        menuItems = $('#nav').children('li'),\n        winHeight,\n        menuHeight = menu.height(),\n        menuScrollMax = 0,\n        submenuHeight = 0,\n        contentHeight,\n        winTop = 0,\n        winTopLast = 0,\n        scrollStep = 0,\n        nextTop = 0;\n\n    /**\n     * Check if menu is fixed\n     * @returns {Boolean}\n     */\n    function isMenuFixed() {\n        return menuHeight < contentHeight && contentHeight > winHeight;\n    }\n\n    /**\n     * Check if class exist than add or do nothing\n     * @param {jQuery} el\n     * @param {String} $class\n     */\n    function checkAddClass(el, $class) {\n        if (!el.hasClass($class)) {\n            el.addClass($class);\n        }\n    }\n\n    /**\n     * Check if class exist than remove or do nothing\n     * @param {jQuery} el\n     * @param {String} $class\n     */\n    function checkRemoveClass(el, $class) {\n        if (el.hasClass($class)) {\n            el.removeClass($class);\n        }\n    }\n\n    /**\n     * Calculate and apply menu position\n     */\n    function positionMenu() {\n\n        //  Spotting positions and heights\n        winHeight = win.height();\n        contentHeight = content.height();\n        winTop = win.scrollTop();\n        scrollStep = winTop - winTopLast;\n\n        if (isMenuFixed()) { // fixed menu cases\n\n            checkAddClass(menu, fixedClassName);\n\n            if (menuHeight > winHeight) { // smart scroll cases\n\n                if (winTop > winTopLast) { //eslint-disable-line max-depth\n\n                    menuScrollMax = menuHeight - winHeight;\n\n                    nextTop < menuScrollMax - scrollStep ?\n                        nextTop += scrollStep : nextTop = menuScrollMax;\n\n                    menu.css('top', -nextTop);\n\n                } else if (winTop <= winTopLast) { // scroll up\n\n                    nextTop > -scrollStep ?\n                        nextTop += scrollStep : nextTop = 0;\n\n                    menu.css('top', -nextTop);\n\n                }\n\n            }\n\n        } else { // static menu cases\n            checkRemoveClass(menu, fixedClassName);\n            menu.css('top', 'auto');\n        }\n\n        //  Save previous window scrollTop\n        winTopLast = winTop;\n\n    }\n\n    positionMenu(); // page start calculation\n\n    //  Change position on scroll\n    win.on('scroll', function () {\n        positionMenu();\n    });\n\n    win.on('resize', function () {\n\n        winHeight = win.height();\n\n        //  Reset position if fixed and out of smart scroll\n        if (menuHeight < contentHeight && menuHeight <= winHeight) {\n            menu.removeAttr('style');\n            menuItems.off();\n        }\n\n    });\n\n    //  Add event to menuItems to check submenu overlap\n    menuItems.on('click', function () {\n\n        var submenu = $(this).children(subMenuClass),\n            delta,\n            logo = $('.logo')[0].offsetHeight;\n\n        submenuHeight = submenu.height();\n\n        if (submenuHeight > menuHeight && menuHeight + logo > winHeight) {\n            menu.height(submenuHeight - logo);\n            delta = -menu.position().top;\n            window.scrollTo(0, 0);\n            positionMenu();\n            window.scrollTo(0, delta);\n            positionMenu();\n            menuHeight = submenuHeight;\n        }\n    });\n\n});\n\ndefine('globalNavigation', [\n    'jquery',\n    'jquery/ui',\n    'globalNavigationScroll'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.globalNavigation', {\n        options: {\n            selectors: {\n                menu: '#nav',\n                currentItem: '._current',\n                topLevelItem: '.level-0',\n                topLevelHref: '> a',\n                subMenu: '> .submenu',\n                closeSubmenuBtn: '[data-role=\"close-submenu\"]'\n            },\n            overlayTmpl: '<div class=\"admin__menu-overlay\"></div>'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var selectors = this.options.selectors;\n\n            this.menu = this.element;\n            this.menuLinks = $(selectors.topLevelHref, selectors.topLevelItem);\n            this.closeActions = $(selectors.closeSubmenuBtn);\n\n            this._initOverlay()\n                ._bind();\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _initOverlay: function () {\n            this.overlay = $(this.options.overlayTmpl).appendTo('body').hide(0);\n\n            return this;\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            var focus = this._focus.bind(this),\n                open = this._open.bind(this),\n                blur = this._blur.bind(this),\n                keyboard = this._keyboard.bind(this);\n\n            this.menuLinks\n                .on('focus', focus)\n                .on('click', open);\n\n            this.menuLinks.last().on('blur', blur);\n\n            this.closeActions.on('keydown', keyboard);\n        },\n\n        /**\n         * Remove active class from current menu item\n         * Turn back active class to current page menu item\n         */\n        _blur: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = $(e.target).closest(selectors.topLevelItem),\n                currentItem = $(selectors.menu).find(selectors.currentItem);\n\n            menuItem.removeClass('_active');\n            currentItem.addClass('_active');\n        },\n\n        /**\n         * Add focus to active menu item\n         */\n        _keyboard: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = $(e.target).closest(selectors.topLevelItem);\n\n            if (e.which === 13) {\n                this._close(e);\n                $(selectors.topLevelHref, menuItem).trigger('focus');\n            }\n        },\n\n        /**\n         * Toggle active state on focus\n         */\n        _focus: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = $(e.target).closest(selectors.topLevelItem);\n\n            menuItem.addClass('_active')\n                .siblings(selectors.topLevelItem)\n                .removeClass('_active');\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _closeSubmenu: function (e) {\n            var selectors = this.options.selectors,\n                currentItem = $(selectors.menu).find(selectors.currentItem);\n\n            this._close(e);\n\n            currentItem.addClass('_active');\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _open: function (e) {\n            var selectors = this.options.selectors,\n                menuItemSelector = selectors.topLevelItem,\n                menuItem = $(e.target).closest(menuItemSelector),\n                subMenu = $(selectors.subMenu, menuItem),\n                close = this._closeSubmenu.bind(this),\n                closeBtn = subMenu.find(selectors.closeSubmenuBtn);\n\n            if (subMenu.length) {\n                e.preventDefault();\n            }\n            closeBtn.on('click', close);\n\n            if ($(menuItem).hasClass('_show')) {\n                closeBtn.trigger('click');\n            } else {\n                menuItem.addClass('_show')\n                    .siblings(menuItemSelector)\n                    .removeClass('_show');\n                subMenu.attr('aria-expanded', 'true');\n                this.overlay.show(0).on('click', close);\n                this.menuLinks.last().off('blur');\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _close: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = this.menu.find(selectors.topLevelItem + '._show'),\n                subMenu = $(selectors.subMenu, menuItem),\n                closeBtn = subMenu.find(selectors.closeSubmenuBtn),\n                blur = this._blur.bind(this);\n\n            e.preventDefault();\n\n            this.overlay.hide(0).off('click');\n\n            this.menuLinks.last().on('blur', blur);\n\n            closeBtn.off('click');\n\n            subMenu.attr('aria-expanded', 'false');\n\n            menuItem.removeClass('_show _active');\n        }\n    });\n\n    return $.mage.globalNavigation;\n});\n\ndefine('globalSearch', [\n    'jquery',\n    'Magento_Ui/js/lib/key-codes',\n    'jquery-ui-modules/widget'\n], function ($, keyCodes) {\n    'use strict';\n\n    $.widget('mage.globalSearch', {\n        options: {\n            field: '.search-global-field',\n            fieldActiveClass: '_active',\n            input: '#search-global'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.field = $(this.options.field);\n            this.input = $(this.options.input);\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.input.on('blur.resetGlobalSearchForm', function () {\n                if (!self.input.val()) {\n                    self.field.removeClass(self.options.fieldActiveClass);\n                }\n            });\n\n            this.input.on('focus.activateGlobalSearchForm', function () {\n                self.field.addClass(self.options.fieldActiveClass);\n            });\n\n            $(document).on('keydown.activateGlobalSearchForm', function (event) {\n                var inputs = [\n                    'input',\n                    'select',\n                    'textarea'\n                ];\n\n                if (keyCodes[event.which] !== 'forwardSlashKey' ||\n                    inputs.indexOf(event.target.tagName.toLowerCase()) !== -1 ||\n                    event.target.isContentEditable\n                ) {\n                    return;\n                }\n\n                event.preventDefault();\n\n                self.input.focus();\n            });\n        }\n    });\n\n    return $.mage.globalSearch;\n});\n\ndefine('modalPopup', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.modalPopup', {\n        options: {\n            popup: '.popup',\n            btnDismiss: '[data-dismiss=\"popup\"]',\n            btnHide: '[data-hide=\"popup\"]'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.fade = this.element;\n            this.popup = $(this.options.popup, this.fade);\n            this.btnDismiss = $(this.options.btnDismiss, this.popup);\n            this.btnHide = $(this.options.btnHide, this.popup);\n\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.btnDismiss\n                .on('click.dismissModalPopup', function () {\n                    self.fade.remove();\n                });\n\n            this.btnHide\n                .on('click.hideModalPopup', function () {\n                    self.fade.hide();\n                });\n        }\n    });\n\n    return $.mage.modalPopup;\n});\n\ndefine('useDefault', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.useDefault', {\n        options: {\n            field: '.field',\n            useDefault: '.use-default',\n            checkbox: '.use-default-control',\n            label: '.use-default-label'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.el = this.element;\n            this.field = $(this.el).closest(this.options.field);\n            this.useDefault = $(this.options.useDefault, this.field);\n            this.checkbox = $(this.options.checkbox, this.useDefault);\n            this.label = $(this.options.label, this.useDefault);\n            this.origValue = this.el.attr('data-store-label');\n\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.el.on(\n                    'change.toggleUseDefaultVisibility keyup.toggleUseDefaultVisibility',\n                    $.proxy(this._toggleUseDefaultVisibility, this)\n                ).trigger('change.toggleUseDefaultVisibility');\n\n            this.checkboxon('change.setOrigValue', function () {\n                if ($(this).prop('checked')) {\n                    self.el\n                        .val(self.origValue)\n                        .trigger('change.toggleUseDefaultVisibility');\n\n                    $(this).prop('checked', false);\n                }\n            });\n        },\n\n        /**\n         * @private\n         */\n        _toggleUseDefaultVisibility: function () {\n            var curValue = this.el.val(),\n                origValue = this.origValue;\n\n            this[curValue != origValue ? '_show' : '_hide'](); //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @private\n         */\n        _show: function () {\n            this.useDefault.show();\n        },\n\n        /**\n         * @private\n         */\n        _hide: function () {\n            this.useDefault.hide();\n        }\n    });\n\n    return $.mage.useDefault;\n});\n\ndefine('loadingPopup', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.loadingPopup', {\n        options: {\n            message: 'Please wait...',\n            timeout: 5000,\n            timeoutId: null,\n            callback: null,\n            template: null\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.template =\n                '<div class=\"popup popup-loading\">' +\n                '<div class=\"popup-inner\">' + this.options.message + '</div>' +\n                '</div>';\n\n            this.popup = $(this.template);\n\n            this._show();\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.element\n                .on('showLoadingPopup', function () {\n                    self._show();\n                })\n                .on('hideLoadingPopup', function () {\n                    self._hide();\n                });\n        },\n\n        /**\n         * @private\n         */\n        _show: function () {\n            var options = this.options,\n                timeout = options.timeout;\n\n            $('body').trigger('processStart');\n\n            if (timeout) {\n                options.timeoutId = setTimeout(this._delayedHide.bind(this), timeout);\n            }\n        },\n\n        /**\n         * @private\n         */\n        _hide: function () {\n            $('body').trigger('processStop');\n        },\n\n        /**\n         * @private\n         */\n        _delayedHide: function () {\n            this._hide();\n\n            this.options.callback && this.options.callback();\n\n            this.options.timeoutId && clearTimeout(this.options.timeoutId);\n        }\n    });\n\n    return $.mage.loadingPopup;\n});\n\ndefine('collapsable', [\n    'jquery',\n    'jquery/ui',\n    'jquery/jquery.tabs'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.collapsable', {\n        options: {\n            parent: null,\n            openedClass: 'opened',\n            wrapper: '.fieldset-wrapper'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._events();\n        },\n\n        /** @inheritdoc */\n        _events: function () {\n            var self = this;\n\n            this.element\n                .on('show.bs.collapse', function (e) {\n                    var fieldsetWrapper = $(this).closest(self.options.wrapper);\n\n                    fieldsetWrapper.addClass(self.options.openedClass);\n                    e.stopPropagation();\n                })\n                .on('hide.bs.collapse', function (e) {\n                    var fieldsetWrapper = $(this).closest(self.options.wrapper);\n\n                    fieldsetWrapper.removeClass(self.options.openedClass);\n                    e.stopPropagation();\n                });\n        }\n    });\n\n    return $.mage.collapsable;\n});\n\ndefine('js/theme', [\n    'jquery',\n    'mage/smart-keyboard-handler',\n    'mage/ie-class-fixer',\n    'collapsable',\n    'domReady!'\n], function ($, keyboardHandler) {\n    'use strict';\n\n    /* @TODO refactor collapsible as widget and avoid logic binding with such a general selectors */\n    $('.collapse').collapsable();\n\n    $.each($('.entry-edit'), function (i, entry) {\n        $('.collapse:first', entry).filter(function () {\n            return $(this).data('collapsed') !== true;\n        }).collapse('show');\n    });\n\n    keyboardHandler.apply();\n});\n","Magento_UrlRewrite/js/url-rewrite-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/backend/form',\n    'mage/backend/validation'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).form().validation({\n            validationUrl: data.url\n        });\n    };\n});\n","Magento_Shipping/order/packaging.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['prototype'], function () {\n\n    window.Packaging = Class.create();\n    Packaging.prototype = {\n        /**\n         * Initialize object\n         */\n        initialize: function (params) {\n            this.packageIncrement = 0;\n            this.packages = [];\n            this.itemsAll = [];\n            this.createLabelUrl = params.createLabelUrl ? params.createLabelUrl : null;\n            this.itemsGridUrl = params.itemsGridUrl ? params.itemsGridUrl : null;\n            this.errorQtyOverLimit = params.errorQtyOverLimit;\n            this.titleDisabledSaveBtn = params.titleDisabledSaveBtn;\n            this.window = $('packaging_window');\n            this.messages = this.window.select('.message-warning')[0];\n            this.packagesContent = $('packages_content');\n            this.template = $('package_template');\n            this.paramsCreateLabelRequest = {};\n            this.validationErrorMsg = params.validationErrorMsg;\n\n            this.defaultItemsQty            = params.shipmentItemsQty ? params.shipmentItemsQty : null;\n            this.defaultItemsPrice          = params.shipmentItemsPrice ? params.shipmentItemsPrice : null;\n            this.defaultItemsName           = params.shipmentItemsName ? params.shipmentItemsName : null;\n            this.defaultItemsWeight         = params.shipmentItemsWeight ? params.shipmentItemsWeight : null;\n            this.defaultItemsProductId      = params.shipmentItemsProductId ? params.shipmentItemsProductId : null;\n            this.defaultItemsOrderItemId    = params.shipmentItemsOrderItemId ? params.shipmentItemsOrderItemId : null;\n\n            this.shippingInformation = params.shippingInformation ? params.shippingInformation : null;\n            this.thisPage           = params.thisPage ? params.thisPage : null;\n            this.customizableContainers = params.customizable ? params.customizable : [];\n\n            this.eps = 0.000001;\n        },\n\n        /**\n         * Get Package Id\n         */\n        getPackageId: function (packageBlock) {\n            return packageBlock.id.match(/\\d{0,}$/)[0];\n        },\n\n        //******************** Setters **********************************//\n        setLabelCreatedCallback: function (callback) {\n            this.labelCreatedCallback = callback;\n        },\n        setCancelCallback: function (callback) {\n            this.cancelCallback = callback;\n        },\n        setConfirmPackagingCallback: function (callback) {\n            this.confirmPackagingCallback = callback;\n        },\n        setItemQtyCallback: function (callback) {\n            this.itemQtyCallback = callback;\n        },\n        setCreateLabelUrl: function (url) {\n            this.createLabelUrl = url;\n        },\n        setParamsCreateLabelRequest: function (params) {\n            Object.extend(this.paramsCreateLabelRequest, params);\n        },\n        //******************** End Setters *******************************//\n\n        showWindow: function () {\n            if (this.packagesContent.childElements().length == 0) {\n                this.newPackage();\n            }\n            jQuery(this.window).modal('openModal');\n        },\n\n        cancelPackaging: function () {\n            if (Object.isFunction(this.cancelCallback)) {\n                this.cancelCallback();\n            }\n        },\n\n        confirmPackaging: function (params) {\n            if (Object.isFunction(this.confirmPackagingCallback)) {\n                this.confirmPackagingCallback();\n            }\n        },\n\n        checkAllItems: function (headCheckbox) {\n            $(headCheckbox).up('table').select('tbody input[type=\"checkbox\"]').each(function (checkbox) {\n                checkbox.checked = headCheckbox.checked;\n                this._observeQty.call(checkbox);\n            }.bind(this));\n        },\n\n        cleanPackages: function () {\n            this.packagesContent.update();\n            this.packages = [];\n            this.itemsAll = [];\n            this.packageIncrement = 0;\n            this._setAllItemsPackedState();\n            this.messages.hide().update();\n        },\n\n        sendCreateLabelRequest: function () {\n            var self = this;\n\n            if (!this.validate()) {\n                this.messages.show().update(this.validationErrorMsg);\n\n                return;\n            }\n            this.messages.hide().update();\n\n            if (this.createLabelUrl) {\n                var weight, length, width, height = null;\n                var packagesParams = [];\n\n                this.packagesContent.childElements().each(function (pack) {\n                    var packageId = this.getPackageId(pack);\n\n                    weight = parseFloat(pack.select('input[name=\"container_weight\"]')[0].value);\n                    length = parseFloat(pack.select('input[name=\"container_length\"]')[0].value);\n                    width = parseFloat(pack.select('input[name=\"container_width\"]')[0].value);\n                    height = parseFloat(pack.select('input[name=\"container_height\"]')[0].value);\n                    packagesParams[packageId] = {\n                        container:                  pack.select('select[name=\"package_container\"]')[0].value,\n                        customs_value:              parseFloat(pack.select('input[name=\"package_customs_value\"]')[0].value, 10),\n                        weight:                     isNaN(weight) ? '' : weight,\n                        length:                     isNaN(length) ? '' : length,\n                        width:                      isNaN(width) ? '' : width,\n                        height:                     isNaN(height) ? '' : height,\n                        weight_units:               pack.select('select[name=\"container_weight_units\"]')[0].value,\n                        dimension_units:            pack.select('select[name=\"container_dimension_units\"]')[0].value\n                    };\n\n                    if (isNaN(packagesParams[packageId]['customs_value'])) {\n                        packagesParams[packageId]['customs_value'] = 0;\n                    }\n\n                    if ('undefined' != typeof pack.select('select[name=\"package_size\"]')[0]) {\n                        if ('' != pack.select('select[name=\"package_size\"]')[0].value) {\n                            packagesParams[packageId]['size'] = pack.select('select[name=\"package_size\"]')[0].value;\n                        }\n                    }\n\n                    if ('undefined' != typeof pack.select('input[name=\"container_girth\"]')[0]) {\n                        if ('' != pack.select('input[name=\"container_girth\"]')[0].value) {\n                            packagesParams[packageId]['girth'] = pack.select('input[name=\"container_girth\"]')[0].value;\n                            packagesParams[packageId]['girth_dimension_units'] = pack.select('select[name=\"container_girth_dimension_units\"]')[0].value;\n                        }\n                    }\n\n                    if ('undefined' != typeof pack.select('select[name=\"content_type\"]')[0] && 'undefined' != typeof pack.select('input[name=\"content_type_other\"]')[0]) {\n                        packagesParams[packageId]['content_type'] = pack.select('select[name=\"content_type\"]')[0].value;\n                        packagesParams[packageId]['content_type_other'] = pack.select('input[name=\"content_type_other\"]')[0].value;\n                    } else {\n                        packagesParams[packageId]['content_type'] = '';\n                        packagesParams[packageId]['content_type_other'] = '';\n                    }\n                    var deliveryConfirmation = pack.select('select[name=\"delivery_confirmation_types\"]');\n\n                    if (deliveryConfirmation.length) {\n                        packagesParams[packageId]['delivery_confirmation'] =  deliveryConfirmation[0].value;\n                    }\n                }.bind(this));\n\n                for (var packageId in this.packages) {\n                    if (!isNaN(packageId)) {\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[container]']              = packagesParams[packageId]['container'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[weight]']                 = packagesParams[packageId]['weight'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[customs_value]']          = packagesParams[packageId]['customs_value'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[length]']                 = packagesParams[packageId]['length'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[width]']                  = packagesParams[packageId]['width'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[height]']                 = packagesParams[packageId]['height'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[weight_units]']           = packagesParams[packageId]['weight_units'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[dimension_units]']        = packagesParams[packageId]['dimension_units'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[content_type]']           = packagesParams[packageId]['content_type'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[content_type_other]']     = packagesParams[packageId]['content_type_other'];\n\n                        if ('undefined' != typeof packagesParams[packageId]['size']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[size]'] = packagesParams[packageId]['size'];\n                        }\n\n                        if ('undefined' != typeof packagesParams[packageId]['girth']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[girth]'] = packagesParams[packageId]['girth'];\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[girth_dimension_units]'] = packagesParams[packageId]['girth_dimension_units'];\n                        }\n\n                        if ('undefined' != typeof packagesParams[packageId]['delivery_confirmation']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[delivery_confirmation]']  = packagesParams[packageId]['delivery_confirmation'];\n                        }\n\n                        for (var packedItemId in this.packages[packageId]['items']) {\n                            if (!isNaN(packedItemId)) {\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][qty]']           = this.packages[packageId]['items'][packedItemId]['qty'];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][customs_value]'] = this.packages[packageId]['items'][packedItemId]['customs_value'];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][price]']         = self.defaultItemsPrice[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][name]']          = self.defaultItemsName[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][weight]']        = self.defaultItemsWeight[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][product_id]']    = self.defaultItemsProductId[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][order_item_id]'] = self.defaultItemsOrderItemId[packedItemId];\n                            }\n                        }\n                    }\n                }\n\n                new Ajax.Request(this.createLabelUrl, {\n                    parameters: this.paramsCreateLabelRequest,\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response.isJSON()) {\n                            response = response.evalJSON();\n\n                            if (response.error) {\n                                this.messages.show().innerHTML = response.message;\n                            } else if (response.ok && Object.isFunction(this.labelCreatedCallback)) {\n                                this.labelCreatedCallback(response);\n                            }\n                        }\n                    }.bind(this)\n                });\n\n                if (this.paramsCreateLabelRequest['code'] &&\n                    this.paramsCreateLabelRequest['carrier_title'] &&\n                    this.paramsCreateLabelRequest['method_title'] &&\n                    this.paramsCreateLabelRequest['price']\n                ) {\n                    var a = this.paramsCreateLabelRequest['code'];\n                    var b = this.paramsCreateLabelRequest['carrier_title'];\n                    var c = this.paramsCreateLabelRequest['method_title'];\n                    var d = this.paramsCreateLabelRequest['price'];\n\n                    this.paramsCreateLabelRequest = {};\n                    this.paramsCreateLabelRequest['code']           = a;\n                    this.paramsCreateLabelRequest['carrier_title']  = b;\n                    this.paramsCreateLabelRequest['method_title']   = c;\n                    this.paramsCreateLabelRequest['price']          = d;\n                } else {\n                    this.paramsCreateLabelRequest = {};\n                }\n            }\n        },\n\n        validate: function () {\n            var dimensionElements = $('packaging_window').select(\n                'input[name=container_length],input[name=container_width],input[name=container_height],input[name=container_girth]:not(\"._disabled\")'\n            );\n            var callback = null;\n\n            if (dimensionElements.any(function (element) {\n                return !!element.value;\n            })) {\n                callback = function (element) {\n                    $(element).addClassName('required-entry');\n                };\n            } else {\n                callback = function (element) {\n                    $(element).removeClassName('required-entry');\n                };\n            }\n            dimensionElements.each(callback);\n\n            return result = $$('[id^=\"package_block_\"] input').collect(function (element) {\n                return this.validateElement(element);\n            }, this).all();\n        },\n\n        validateElement: function (elm) {\n            var cn = $w(elm.className);\n\n            return result = cn.all(function (value) {\n                var v = Validation.get(value);\n\n                if (Validation.isVisible(elm) && !v.test($F(elm), elm)) {\n                    $(elm).addClassName('validation-failed');\n\n                    return false;\n                }\n                $(elm).removeClassName('validation-failed');\n\n                return true;\n\n            });\n        },\n\n        validateCustomsValue: function () {\n            var items = [];\n            var isValid = true;\n            var itemsPrepare = [];\n            var itemsPacked = [];\n\n            this.packagesContent.childElements().each(function (pack) {\n                itemsPrepare = pack.select('[data-role=\"package-items\"]')[0];\n\n                if (itemsPrepare) {\n                    items = items.concat(itemsPrepare.select('.grid tbody tr'));\n                }\n                itemsPacked = pack.select('.package_items')[0];\n\n                if (itemsPacked) {\n                    items = items.concat(itemsPacked.select('.grid tbody tr'));\n                }\n            });\n\n            items.each(function (item) {\n                var itemCustomsValue = item.select('[name=\"customs_value\"]')[0];\n\n                if (!this.validateElement(itemCustomsValue)) {\n                    isValid = false;\n                }\n            }.bind(this));\n\n            if (isValid) {\n                this.messages.hide().update();\n            } else {\n                this.messages.show().update(this.validationErrorMsg);\n            }\n\n            return isValid;\n        },\n\n        newPackage: function () {\n            var pack = this.template.cloneNode(true);\n\n            pack.id = 'package_block_' + ++this.packageIncrement;\n            pack.addClassName('package-block');\n            pack.select('[data-role=package-number]')[0].update(this.packageIncrement);\n            this.packagesContent.insert({\n                top: pack\n            });\n            pack.select('[data-action=package-save-items]')[0].hide();\n            pack.show();\n        },\n\n        deletePackage: function (obj) {\n            var pack = $(obj).up('[id^=\"package_block\"]');\n\n            var packItems = pack.select('.package_items')[0];\n            var packageId = this.getPackageId(pack);\n\n            delete this.packages[packageId];\n            pack.remove();\n            this.messages.hide().update();\n            this._setAllItemsPackedState();\n        },\n\n        deleteItem: function (obj) {\n            var item = $(obj).up('tr');\n            var itemId = item.select('[type=\"checkbox\"]')[0].value;\n            var pack = $(obj).up('[id^=\"package_block\"]');\n            var packItems = pack.select('.package_items')[0];\n            var packageId = this.getPackageId(pack);\n\n            delete this.packages[packageId]['items'][itemId];\n\n            if (item.offsetParent.rows.length <= 2) { /* head + this last row */\n                $(packItems).hide();\n            }\n            item.remove();\n            this.messages.hide().update();\n            this._recalcContainerWeightAndCustomsValue(packItems);\n            this._setAllItemsPackedState();\n        },\n\n        recalcContainerWeightAndCustomsValue: function (obj) {\n            var pack = $(obj).up('[id^=\"package_block\"]');\n            var packItems = pack.select('.package_items')[0];\n\n            if (packItems) {\n                if (!this.validateCustomsValue()) {\n                    return;\n                }\n                this._recalcContainerWeightAndCustomsValue(packItems);\n            }\n        },\n\n        getItemsForPack: function (obj) {\n            if (this.itemsGridUrl) {\n                var parameters = $H({\n                    'shipment_id': this.shipmentId\n                });\n                var packageBlock = $(obj).up('[id^=\"package_block\"]');\n                var packagePrapare = packageBlock.select('[data-role=package-items]')[0];\n                var packagePrapareGrid = packagePrapare.select('.grid_prepare')[0];\n\n                new Ajax.Request(this.itemsGridUrl, {\n                    parameters: parameters,\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response) {\n                            packagePrapareGrid.update(response);\n                            this.processPackagePrepare(packagePrapareGrid);\n\n                            if (packagePrapareGrid.select('.grid tbody tr').length) {\n                                packageBlock.select('[data-action=package-add-items]')[0].hide();\n                                packageBlock.select('[data-action=package-save-items]')[0].show();\n                                packagePrapare.show();\n                            } else {\n                                packagePrapareGrid.update();\n                            }\n                        }\n                    }.bind(this)\n                });\n            }\n        },\n\n        getPackedItemsQty: function () {\n            var items = [];\n\n            for (var packageId in this.packages) {\n                if (!isNaN(packageId)) {\n                    for (var packedItemId in this.packages[packageId]['items']) {\n                        if (!isNaN(packedItemId)) {\n                            if (items[packedItemId]) {\n                                items[packedItemId] += this.packages[packageId]['items'][packedItemId]['qty'];\n                            } else {\n                                items[packedItemId] = this.packages[packageId]['items'][packedItemId]['qty'];\n                            }\n                        }\n                    }\n                }\n            }\n\n            return items;\n        },\n\n        _parseQty: function (obj) {\n            var qty = $(obj).hasClassName('qty-decimal') ? parseFloat(obj.value) : parseInt(obj.value);\n\n            if (isNaN(qty) || qty <= 0) {\n                qty = 1;\n            }\n\n            return qty;\n        },\n\n        packItems: function (obj) {\n            var anySelected = false;\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n            var packageId = this.getPackageId(packageBlock);\n            var packagePrepare = packageBlock.select('[data-role=package-items]')[0];\n            var packagePrepareGrid = packagePrepare.select('.grid_prepare')[0];\n\n            // check for exceeds the total shipped quantity\n            var checkExceedsQty = false;\n\n            this.messages.hide().update();\n            packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                var checkbox = item.select('[type=\"checkbox\"]')[0];\n                var itemId = checkbox.value;\n                var qtyValue  = this._parseQty(item.select('[name=\"qty\"]')[0]);\n\n                item.select('[name=\"qty\"]')[0].value = qtyValue;\n\n                if (checkbox.checked && this._checkExceedsQty(itemId, qtyValue)) {\n                    this.messages.show().update(this.errorQtyOverLimit);\n                    checkExceedsQty = true;\n                }\n            }.bind(this));\n\n            if (checkExceedsQty) {\n                return;\n            }\n\n            if (!this.validateCustomsValue()) {\n                return;\n            }\n\n            // prepare items for packing\n            packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                var checkbox = item.select('[type=\"checkbox\"]')[0];\n\n                if (checkbox.checked) {\n                    var qty  = item.select('[name=\"qty\"]')[0];\n                    var qtyValue  = this._parseQty(qty);\n\n                    item.select('[name=\"qty\"]')[0].value = qtyValue;\n                    anySelected = true;\n                    qty.disabled = 'disabled';\n                    checkbox.disabled = 'disabled';\n                    packagePrepareGrid.select('.grid th [type=\"checkbox\"]')[0].up('th label').hide();\n                    item.select('[data-action=package-delete-item]')[0].show();\n                } else {\n                    item.remove();\n                }\n            }.bind(this));\n\n            // packing items\n            if (anySelected) {\n                var packItems = packageBlock.select('.package_items')[0];\n\n                if (!packItems) {\n                    packagePrepare.insert(new Element('div').addClassName('grid_prepare'));\n                    packagePrepare.insert({\n                        after: packagePrepareGrid\n                    });\n                    packItems = packagePrepareGrid.removeClassName('grid_prepare').addClassName('package_items');\n                    packItems.select('.grid tbody tr').each(function (item) {\n                        var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                        var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                        qtyValue = qtyValue <= 0 ? 1 : qtyValue;\n\n                        if ('undefined' == typeof this.packages[packageId]) {\n                            this.packages[packageId] = {\n                                'items': [], 'params': {}\n                            };\n                        }\n\n                        if ('undefined' == typeof this.packages[packageId]['items'][itemId]) {\n                            this.packages[packageId]['items'][itemId] = {};\n                            this.packages[packageId]['items'][itemId]['qty'] = qtyValue;\n                        } else {\n                            this.packages[packageId]['items'][itemId]['qty'] += qtyValue;\n                        }\n                    }.bind(this));\n                } else {\n                    packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                        var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                        var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                        qtyValue = qtyValue <= 0 ? 1 : qtyValue;\n\n                        if ('undefined' == typeof this.packages[packageId]['items'][itemId]) {\n                            this.packages[packageId]['items'][itemId] = {};\n                            this.packages[packageId]['items'][itemId]['qty'] = qtyValue;\n                            packItems.select('.grid tbody')[0].insert(item);\n                        } else {\n                            this.packages[packageId]['items'][itemId]['qty'] += qtyValue;\n                            var packItem = packItems.select('[type=\"checkbox\"][value=\"' + itemId + '\"]')[0].up('tr').select('[name=\"qty\"]')[0];\n\n                            packItem.value = this.packages[packageId]['items'][itemId]['qty'];\n                        }\n                    }.bind(this));\n                    packagePrepareGrid.update();\n                }\n                $(packItems).show();\n                this._recalcContainerWeightAndCustomsValue(packItems);\n            } else {\n                packagePrepareGrid.update();\n            }\n\n            // show/hide disable/enable\n            packagePrepare.hide();\n            packageBlock.select('[data-action=package-save-items]')[0].hide();\n            packageBlock.select('[data-action=package-add-items]')[0].show();\n            this._setAllItemsPackedState();\n        },\n\n        validateItemQty: function (itemId, qty) {\n            return this.defaultItemsQty[itemId] < qty ? this.defaultItemsQty[itemId] : qty;\n        },\n\n        changeMeasures: function (obj) {\n            var incr = 0;\n            var incrSelected = 0;\n\n            obj.childElements().each(function (option) {\n                if (option.selected) {\n                    incrSelected = incr;\n                }\n                incr++;\n            });\n\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n\n            packageBlock.select('.measures').each(function (item) {\n                if (item.name != obj.name) {\n                    var incr = 0;\n\n                    item.select('option').each(function (option) {\n                        if (incr == incrSelected) {\n                            item.value = option.value;\n                            //option.selected = true\n                        }\n                        incr++;\n                    });\n                }\n            });\n\n        },\n\n        checkSizeAndGirthParameter: function (obj, enabled) {\n            if (enabled == 0) {\n                return;\n            }\n            var currentNode = obj;\n\n            while (currentNode.nodeName != 'TBODY') {\n                currentNode = currentNode.parentNode;\n            }\n\n            if (!currentNode) {\n                return;\n            }\n\n            var packageSize = currentNode.select('select[name=package_size]');\n            var packageContainer = currentNode.select('select[name=package_container]');\n            var packageGirth = currentNode.select('input[name=container_girth]');\n            var packageGirthDimensionUnits = currentNode.select('select[name=container_girth_dimension_units]');\n\n            if (packageSize.length <= 0) {\n                return;\n            }\n\n            var girthEnabled = packageContainer[0].value == 'NONRECTANGULAR' || packageContainer[0].value == 'VARIABLE';\n\n            if (!girthEnabled) {\n                packageGirth[0].value = '';\n                packageGirth[0].disable();\n                packageGirth[0].addClassName('_disabled');\n                packageGirthDimensionUnits[0].disable();\n                packageGirthDimensionUnits[0].addClassName('_disabled');\n            } else {\n                packageGirth[0].enable();\n                packageGirth[0].removeClassName('_disabled');\n                packageGirthDimensionUnits[0].enable();\n                packageGirthDimensionUnits[0].removeClassName('_disabled');\n            }\n\n            var sizeEnabled = packageContainer[0].value == 'NONRECTANGULAR' || packageContainer[0].value == 'RECTANGULAR' ||\n                packageContainer[0].value == 'VARIABLE';\n\n            if (!sizeEnabled) {\n                option = document.createElement('OPTION');\n                option.value = '';\n                option.text = '';\n                packageSize[0].options.add(option);\n                packageSize[0].value = '';\n                packageSize[0].disable();\n                packageSize[0].addClassName('_disabled');\n            } else {\n                for (i = 0; i < packageSize[0].length; i++) {\n                    if (packageSize[0].options[i].value == '') {\n                        packageSize[0].removeChild(packageSize[0].options[i]);\n                    }\n                }\n                packageSize[0].enable();\n                packageSize[0].removeClassName('_disabled');\n            }\n        },\n\n        changeContainerType: function (obj) {\n            if (this.customizableContainers.length <= 0) {\n                return;\n            }\n\n            var disable = true;\n\n            for (var i in this.customizableContainers) {\n                if (this.customizableContainers[i] == obj.value) {\n                    disable = false;\n                    break;\n                }\n            }\n\n            var currentNode = obj;\n\n            while (currentNode.nodeName != 'TBODY') {\n                currentNode = currentNode.parentNode;\n            }\n\n            if (!currentNode) {\n                return;\n            }\n\n            $(currentNode).select(\n                'input[name=container_length],input[name=container_width],input[name=container_height],select[name=container_dimension_units]'\n            ).each(function (inputElement) {\n                if (disable) {\n                    Form.Element.disable(inputElement);\n                    inputElement.addClassName('_disabled');\n\n                    if (inputElement.nodeName == 'INPUT') {\n                        $(inputElement).value = '';\n                    }\n                } else {\n                    Form.Element.enable(inputElement);\n                    inputElement.removeClassName('_disabled');\n                }\n            });\n        },\n\n        changeContentTypes: function (obj) {\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n            var contentType = packageBlock.select('[name=content_type]')[0];\n            var contentTypeOther = packageBlock.select('[name=content_type_other]')[0];\n\n            if (contentType.value == 'OTHER') {\n                Form.Element.enable(contentTypeOther);\n                contentTypeOther.removeClassName('_disabled');\n            } else {\n                Form.Element.disable(contentTypeOther);\n                contentTypeOther.addClassName('_disabled');\n            }\n\n        },\n\n        //******************** Private functions **********************************//\n        _getItemsCount: function (items) {\n            var count = 0;\n\n            items.each(function (itemCount) {\n                if (!isNaN(itemCount)) {\n                    count += parseFloat(itemCount);\n                }\n            });\n\n            return count;\n        },\n\n        /**\n         * Show/hide disable/enable buttons in case of all items packed state\n         */\n        _setAllItemsPackedState: function () {\n            var addPackageBtn = $$('[data-action=add-packages]')[0];\n            var savePackagesBtn = $$('[data-action=save-packages]')[0];\n\n            if (this._getItemsCount(this.itemsAll) > 0 &&\n                    this._checkExceedsQtyFinal(this._getItemsCount(this.getPackedItemsQty()), this._getItemsCount(this.itemsAll))\n            ) {\n                this.packagesContent.select('[data-action=package-add-items]').each(function (button) {\n                    button.disabled = 'disabled';\n                    button.addClassName('_disabled');\n                });\n                addPackageBtn.addClassName('_disabled');\n                Form.Element.disable(addPackageBtn);\n                savePackagesBtn.removeClassName('_disabled');\n                Form.Element.enable(savePackagesBtn);\n                savePackagesBtn.title = '';\n\n                // package number recalculation\n                var packagesRecalc = [];\n\n                this.packagesContent.childElements().each(function (pack) {\n                    if (!pack.select('.package_items .grid tbody tr').length) {\n                        pack.remove();\n                    }\n                });\n                var packagesCount = this.packagesContent.childElements().length;\n\n                this.packageIncrement = packagesCount;\n                this.packagesContent.childElements().each(function (pack) {\n                    var packageId = this.getPackageId(pack);\n\n                    pack.id = 'package_block_' + packagesCount;\n                    pack.select('[data-role=package-number]')[0].update(packagesCount);\n                    packagesRecalc[packagesCount] = this.packages[packageId];\n                    --packagesCount;\n                }.bind(this));\n                this.packages = packagesRecalc;\n\n            } else {\n                this.packagesContent.select('[data-action=package-add-items]').each(function (button) {\n                    button.removeClassName('_disabled');\n                    Form.Element.enable(button);\n                });\n                addPackageBtn.removeClassName('_disabled');\n                Form.Element.enable(addPackageBtn);\n                savePackagesBtn.addClassName('_disabled');\n                Form.Element.disable(savePackagesBtn);\n                savePackagesBtn.title = this.titleDisabledSaveBtn;\n            }\n        },\n\n        processPackagePrepare: function (packagePrepare) {\n            var itemsAll = [],\n                qty,\n                itemId,\n                qtyValue = 0,\n                value = 1;\n\n            packagePrepare.select('.grid tbody tr').each(function (item) {\n                qty = item.select('[name=\"qty\"]')[0],\n                    itemId = item.select('[type=\"checkbox\"]')[0].value,\n                    qtyValue = parseFloat(qty.value);\n\n                if (Object.isFunction(this.itemQtyCallback)) {\n                    value = this.itemQtyCallback(itemId);\n\n                    if (typeof value !== 'undefined') {\n                        qtyValue = parseFloat(value);\n                        qtyValue = this.validateItemQty(itemId, qtyValue);\n                        qty.value = qtyValue;\n                    }\n                } else {\n                    value = item.select('[name=\"qty\"]')[0].value;\n                    qtyValue = typeof value == 'string' && value.length == 0 ? 0 : parseFloat(value);\n\n                    if (isNaN(qtyValue) || qtyValue < 0) {\n                        qtyValue = 1;\n                    }\n                }\n\n                if (qtyValue == 0) {\n                    item.remove();\n\n                    return;\n                }\n                var packedItems = this.getPackedItemsQty();\n\n                itemsAll[itemId] = qtyValue;\n\n                for (var packedItemId in packedItems) {\n                    if (!isNaN(packedItemId)) {\n                        var packedQty = packedItems[packedItemId];\n\n                        if (itemId == packedItemId) {\n                            if (qtyValue == packedQty || qtyValue <= packedQty) {\n                                item.remove();\n                            } else if (qtyValue > packedQty) {\n                                /* fix float number precision */\n                                qty.value = Number(Number(Math.round(qtyValue - packedQty + 'e+4') + 'e-4').toFixed(4));\n                            }\n                        }\n                    }\n                }\n            }.bind(this));\n\n            if (!this.itemsAll.length) {\n                this.itemsAll = itemsAll;\n            }\n\n            packagePrepare.select('tbody input[type=\"checkbox\"]').each(function (item) {\n                $(item).observe('change', this._observeQty);\n                this._observeQty.call(item);\n            }.bind(this));\n        },\n\n        _observeQty: function () {\n            /** this = input[type=\"checkbox\"] */\n            var tr  = jQuery(this).closest('tr')[0],\n                qty = $(tr.cells[tr.cells.length - 1]).select('input[name=\"qty\"]')[0];\n\n            if (qty.disabled = !this.checked) {\n                $(qty).addClassName('_disabled');\n            } else {\n                $(qty).removeClassName('_disabled');\n            }\n        },\n\n        _checkExceedsQty: function (itemId, qty) {\n            var packedItemQty = this.getPackedItemsQty()[itemId] ? this.getPackedItemsQty()[itemId] : 0;\n            var allItemQty = this.itemsAll[itemId];\n\n            return qty * (1 - this.eps) > allItemQty *  (1 + this.eps)  - packedItemQty * (1 - this.eps);\n        },\n\n        _checkExceedsQtyFinal: function (checkOne, defQty) {\n            return checkOne * (1 + this.eps) >= defQty * (1 - this.eps);\n        },\n\n        _recalcContainerWeightAndCustomsValue: function (container) {\n            var packageBlock = container.up('[id^=\"package_block\"]');\n            var packageId = this.getPackageId(packageBlock);\n            var containerWeight = packageBlock.select('[name=\"container_weight\"]')[0];\n            var containerCustomsValue = packageBlock.select('[name=\"package_customs_value\"]')[0];\n\n            containerWeight.value = 0;\n            containerCustomsValue.value = 0;\n            container.select('.grid tbody tr').each(function (item) {\n                var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                if (isNaN(qtyValue) || qtyValue <= 0) {\n                    qtyValue = 1;\n                    item.select('[name=\"qty\"]')[0].value = qtyValue;\n                }\n                var itemWeight = parseFloat(this._getElementText(item.select('[data-role=item-weight]')[0]));\n\n                containerWeight.value = parseFloat(containerWeight.value) + itemWeight * qtyValue;\n                var itemCustomsValue = parseFloat(item.select('[name=\"customs_value\"]')[0].value) || 0;\n\n                containerCustomsValue.value = parseFloat(containerCustomsValue.value) + itemCustomsValue * qtyValue;\n                this.packages[packageId]['items'][itemId]['customs_value'] = itemCustomsValue;\n            }.bind(this));\n            containerWeight.value = parseFloat(parseFloat(Math.round(containerWeight.value + 'e+4') + 'e-4').toFixed(4));\n            containerCustomsValue.value = parseFloat(Math.round(containerCustomsValue.value + 'e+2') + 'e-2').toFixed(2);\n\n            if (containerCustomsValue.value == 0) {\n                containerCustomsValue.value = '';\n            }\n        },\n\n        _getElementText: function (el) {\n            if ('string' == typeof el.textContent) {\n                return el.textContent;\n            }\n\n            if ('string' == typeof el.innerText) {\n                return el.innerText;\n            }\n\n            return el.innerHTML.replace(/<[^>]*>/g, '');\n        }\n        //******************** End Private functions ******************************//\n    };\n\n});\n","Magento_Shipping/js/packages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, modal, $t) {\n    'use strict';\n\n    return function (config, element) {\n        config.buttons = [\n            {\n                text: $t('Print'),\n                'class': 'action action-primary',\n\n                /**\n                 * Click handler\n                 */\n                click: function () {\n                    window.location.href = this.options.url;\n                }\n            }, {\n                text: $t('Cancel'),\n                'class': 'action action-secondary',\n\n                /**\n                 * Click handler\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }\n        ];\n        modal(config, element);\n    };\n});\n","WeSupply_Toolbox/js/massUpdater.js":"define([\n\t'jquery',\n    'mage/translate'\n], function ($) {\n\t\"use strict\";\n\n\tvar massUpdater = massUpdater || {};\n\n    massUpdater.updateButton = $('#massupdate-btn');\n    massUpdater.formKey = $('#massupdate_form_key');\n    massUpdater.msgContainer = $('.massupdate-msg');\n    massUpdater.progressContainer = $('.massupdate-progress');\n    massUpdater.percentBar = $('.massupdate-progress .bar');\n    massUpdater.orderNumber = 0;\n    massUpdater.batchSize = 1000;\n\n    massUpdater.totalOrders = 0;\n    massUpdater.step = 0;\n    massUpdater.percent = 0;\n    massUpdater.ordersFetched = 0;\n\n    massUpdater.initialize = function (orderNumbersUrl, ordersUpdateUrl, batchSize) {\n\t\tvar that = this;\n\t\tthat.orderNumbersUrl = orderNumbersUrl;\n\t\tthat.ordersUpdateUrl = ordersUpdateUrl;\n        that.batchSize = parseInt(batchSize);\n\t\tthat.getOrderNumber();\n\t\tthat.updateButton.click(function() {\n\t\t\tthat.disableButton();\n            that.showProgress();\n            that.totalOrders = that.orderNumber;\n            that.step = 0;\n            that.percent = 0;\n            that.ordersFetched = 0;\n            that.startUpdate();\n\t\t});\n\t};\n\n    massUpdater.enableButton = function() {\n        massUpdater.updateButton.prop('disabled', false);\n\t};\n\n    massUpdater.disableButton = function() {\n        massUpdater.updateButton.prop('disabled', true);\n    };\n\n    massUpdater.appendMessage = function (message) {\n        massUpdater.msgContainer.append(\"<p>\" + message + \"</p>\");\n    };\n\n    massUpdater.showProgress = function () {\n        massUpdater.progressContainer.show();\n    };\n\n    massUpdater.updateProgress = function(percent) {\n        var percentValue = percent + \"%\";\n        massUpdater.percentBar.css('width', percentValue);\n        massUpdater.percentBar.html(percentValue);\n    };\n\n    massUpdater.getOrderNumber = function() {\n        var that = this;\n        $.ajax({\n            url: that.orderNumbersUrl,\n            data: {\n                'form_key' : that.formKey.val()\n            },\n            type: \"POST\",\n            dataType: 'json'\n        }).done(function (data) {\n            if (data.success) {\n                that.orderNumber = data.ordersNr;\n                that.appendMessage(\"Orders found: \" + that.orderNumber);\n                that.appendMessage(\"Click on the Run Mass Update Button to start the process.\");\n                if (that.orderNumber) {\n                    that.enableButton();\n                }\n            } else {\n                that.appendMessage(data.msg);\n            }\n        });\n\t};\n\n    massUpdater.startUpdate = function() {\n        var that = this;\n        if (that.totalOrders > 0) {\n            $.ajax({\n                url: that.ordersUpdateUrl,\n                data: {\n                    'form_key' : that.formKey.val(),\n                    'limit' : that.batchSize,\n                    'offset' : that.step\n                },\n                type: \"POST\",\n                dataType: 'json'\n            }).done(function (data) {\n\n                if (that.totalOrders < that.batchSize){\n                    that.ordersFetched += that.totalOrders;\n                } else {\n                    that.ordersFetched += that.batchSize;\n                }\n\n                that.percent = parseInt((100 * that.ordersFetched) / that.orderNumber);\n                that.updateProgress(that.percent);\n                that.totalOrders -= that.batchSize;\n                that.step = that.step+1;\n\n                if (data.success) {\n                    that.appendMessage(that.ordersFetched + \" orders already updated ...\");\n                } else {\n                    that.appendMessage(data.msg);\n                }\n\n                that.startUpdate();\n            });\n        } else {\n            that.enableButton();\n            that.appendMessage(\"Mass Update is finalized.\");\n        }\n    };\n\n    return massUpdater;\n});","WeSupply_Toolbox/js/order/view/wsExternalLinks.js":"define([\n    'jquery'\n], function ($) {\n    'use strict';\n    var wsExternalLinks = wsExternalLinks || {};\n\n    wsExternalLinks.init = function()\n    {\n        this.externalLinksBtn = $('#ws_external_links_btn');\n        this.wrapperId = 'ws_external_links_wrapper';\n\n        this.prepareLinkOptions(this.externalLinksBtn.data('ws-links') ?? {});\n\n        this.createBtnWrapper();\n        if (wsExternalLinks.links.length) {\n            this.appendLinks();\n\n            this.optionsWrapper = $('#' + this.wrapperId);\n            this.EventObserver();\n        }\n    };\n\n    wsExternalLinks.prepareLinkOptions = function(options)\n    {\n        wsExternalLinks.links = [];\n        $.each(options, function(linkId, data) {\n            wsExternalLinks.links.push('<a href=\"' + data.url + '\" target=\"_blank\" title=\"' + data.title + '\">' + data.title + '</a>');\n        });\n    };\n\n    wsExternalLinks.createBtnWrapper = function()\n    {\n        wsExternalLinks.externalLinksBtn\n            .wrapAll('<div id=\"' + wsExternalLinks.wrapperId + '\" class=\"ws-external-links-wrapper\"></div>');\n    };\n\n    wsExternalLinks.appendLinks = function()\n    {\n        var html =  '<ul class=\"dropdown-menu\">\\n';\n        $.each(wsExternalLinks.links, function(index, link) {\n            html += '<li><span>' + link + '</span></li>\\n';\n        });\n        html += '</ul>';\n\n        $('#'  +wsExternalLinks.wrapperId).addClass('has-children').append(html);\n    };\n\n    wsExternalLinks.EventObserver = function()\n    {\n        wsExternalLinks.optionsWrapper.on('mouseenter', function(ev) {\n            $(ev.currentTarget).addClass('active')\n                .find('.dropdown-menu').show();\n        });\n        wsExternalLinks.optionsWrapper.on('mouseleave', function(ev) {\n            $(ev.currentTarget).removeClass('active')\n                .find('.dropdown-menu').hide();\n        });\n\n        $(window).scroll(function () {\n            var scroll = $(window).scrollTop();\n            if ($(window).scrollTop()) {\n                $('.page-actions-inner').addClass('moved');\n            } else {\n                $('.page-actions-inner').removeClass('moved');\n            }\n        });\n    };\n\n    return wsExternalLinks;\n});\n","MageBig_MbFrame/js/jquery.minicolors.js":"/*\n * jQuery MiniColors: A tiny color picker built on jQuery\n *\n * Copyright: Cory LaViska for A Beautiful Site, LLC: http://www.abeautifulsite.net/\n *\n * Contribute: https://github.com/claviska/jquery-minicolors\n *\n * @license: http://opensource.org/licenses/MIT\n *\n */\n(function (factory) {\n    /* jshint ignore:start */\n    if (typeof define === 'function' && define.amd) {\n        // AMD. Register as an anonymous module.\n        define(['jquery'], factory);\n    } else if (typeof exports === 'object') {\n        // Node/CommonJS\n        module.exports = factory(require('jquery'));\n    } else {\n        // Browser globals\n        factory(jQuery);\n    }\n    /* jshint ignore:end */\n}(function ($) {\n\n    'use strict';\n\n    // Defaults\n    $.minicolors = {\n        defaults: {\n            animationSpeed: 50,\n            animationEasing: 'swing',\n            change: null,\n            changeDelay: 0,\n            control: 'hue',\n            dataUris: true,\n            defaultValue: '',\n            format: 'hex',\n            hide: null,\n            hideSpeed: 100,\n            inline: false,\n            keywords: '',\n            letterCase: 'lowercase',\n            opacity: false,\n            position: 'bottom left',\n            show: null,\n            showSpeed: 100,\n            theme: 'default',\n            swatches: []\n        }\n    };\n\n    // Public methods\n    $.extend($.fn, {\n        minicolors: function(method, data) {\n\n            switch(method) {\n\n                // Destroy the control\n                case 'destroy':\n                    $(this).each( function() {\n                        destroy($(this));\n                    });\n                    return $(this);\n\n                // Hide the color picker\n                case 'hide':\n                    hide();\n                    return $(this);\n\n                // Get/set opacity\n                case 'opacity':\n                    // Getter\n                    if( data === undefined ) {\n                        // Getter\n                        return $(this).attr('data-opacity');\n                    } else {\n                        // Setter\n                        $(this).each( function() {\n                            updateFromInput($(this).attr('data-opacity', data));\n                        });\n                    }\n                    return $(this);\n\n                // Get an RGB(A) object based on the current color/opacity\n                case 'rgbObject':\n                    return rgbObject($(this), method === 'rgbaObject');\n\n                // Get an RGB(A) string based on the current color/opacity\n                case 'rgbString':\n                case 'rgbaString':\n                    return rgbString($(this), method === 'rgbaString');\n\n                // Get/set settings on the fly\n                case 'settings':\n                    if( data === undefined ) {\n                        return $(this).data('minicolors-settings');\n                    } else {\n                        // Setter\n                        $(this).each( function() {\n                            var settings = $(this).data('minicolors-settings') || {};\n                            destroy($(this));\n                            $(this).minicolors($.extend(true, settings, data));\n                        });\n                    }\n                    return $(this);\n\n                // Show the color picker\n                case 'show':\n                    show( $(this).eq(0) );\n                    return $(this);\n\n                // Get/set the hex color value\n                case 'value':\n                    if( data === undefined ) {\n                        // Getter\n                        return $(this).val();\n                    } else {\n                        // Setter\n                        $(this).each( function() {\n                            if( typeof(data) === 'object' && typeof(data) !== null ) {\n                                if( data.opacity ) {\n                                    $(this).attr('data-opacity', keepWithin(data.opacity, 0, 1));\n                                }\n                                if( data.color ) {\n                                    $(this).val(data.color);\n                                }\n                            } else {\n                                $(this).val(data);\n                            }\n                            updateFromInput($(this));\n                        });\n                    }\n                    return $(this);\n\n                // Initializes the control\n                default:\n                    if( method !== 'create' ) data = method;\n                    $(this).each( function() {\n                        init($(this), data);\n                    });\n                    return $(this);\n\n            }\n\n        }\n    });\n\n    // Initialize input elements\n    function init(input, settings) {\n\n        var minicolors = $('<div class=\"minicolors\" />'),\n            defaults = $.minicolors.defaults,\n            size,\n            swatches,\n            swatch,\n            panel,\n            i;\n\n        // Do nothing if already initialized\n        $(input).attr('autocomplete','off');\n        if( input.data('minicolors-initialized') ) return;\n\n        // Handle settings\n        settings = $.extend(true, {}, defaults, settings);\n\n        // The wrapper\n        minicolors\n            .addClass('minicolors-theme-' + settings.theme)\n            .toggleClass('minicolors-with-opacity', settings.opacity)\n            .toggleClass('minicolors-no-data-uris', settings.dataUris !== true);\n\n        // Custom positioning\n        if( settings.position !== undefined ) {\n            $.each(settings.position.split(' '), function() {\n                minicolors.addClass('minicolors-position-' + this);\n            });\n        }\n\n        // Input size\n        if( settings.format === 'rgb' ) {\n            size = settings.opacity ? '25' : '20';\n        } else {\n            size = settings.keywords ? '11' : '7';\n        }\n\n        // The input\n        input\n            .addClass('minicolors-input')\n            .data('minicolors-initialized', false)\n            .data('minicolors-settings', settings)\n            .prop('size', size)\n            .wrap(minicolors)\n            .after(\n                '<div class=\"minicolors-panel minicolors-slider-' + settings.control + '\">' +\n                '<div class=\"minicolors-slider minicolors-sprite\">' +\n                '<div class=\"minicolors-picker\"></div>' +\n                '</div>' +\n                '<div class=\"minicolors-opacity-slider minicolors-sprite\">' +\n                '<div class=\"minicolors-picker\"></div>' +\n                '</div>' +\n                '<div class=\"minicolors-grid minicolors-sprite\">' +\n                '<div class=\"minicolors-grid-inner\"></div>' +\n                '<div class=\"minicolors-picker\"><div></div></div>' +\n                '</div>' +\n                '</div>'\n            );\n\n        // The swatch\n        if( !settings.inline ) {\n            input.after('<span class=\"minicolors-swatch minicolors-sprite minicolors-input-swatch\"><span class=\"minicolors-swatch-color\"></span></span>');\n            input.next('.minicolors-input-swatch').on('click', function(event) {\n                event.preventDefault();\n                input.focus();\n            });\n        }\n\n        // Prevent text selection in IE\n        panel = input.parent().find('.minicolors-panel');\n        panel.on('selectstart', function() { return false; }).end();\n\n        // Swatches\n        if (settings.swatches && settings.swatches.length !== 0) {\n            if (settings.swatches.length > 7) {\n                settings.swatches.length = 7;\n            }\n            panel.addClass('minicolors-with-swatches');\n            swatches = $('<ul class=\"minicolors-swatches\"></ul>')\n                .appendTo(panel);\n            for(i = 0; i < settings.swatches.length; ++i) {\n                swatch = settings.swatches[i];\n                swatch = isRgb(swatch) ? parseRgb(swatch, true) : hex2rgb(parseHex(swatch, true));\n                $('<li class=\"minicolors-swatch minicolors-sprite\"><span class=\"minicolors-swatch-color\"></span></li>')\n                    .appendTo(swatches)\n                    .data('swatch-color', settings.swatches[i])\n                    .find('.minicolors-swatch-color')\n                    .css({\n                        backgroundColor: rgb2hex(swatch),\n                        opacity: swatch.a\n                    });\n                settings.swatches[i] = swatch;\n            }\n\n        }\n\n        // Inline controls\n        if( settings.inline ) input.parent().addClass('minicolors-inline');\n\n        updateFromInput(input, false);\n\n        input.data('minicolors-initialized', true);\n\n    }\n\n    // Returns the input back to its original state\n    function destroy(input) {\n\n        var minicolors = input.parent();\n\n        // Revert the input element\n        input\n            .removeData('minicolors-initialized')\n            .removeData('minicolors-settings')\n            .removeProp('size')\n            .removeClass('minicolors-input');\n\n        // Remove the wrap and destroy whatever remains\n        minicolors.before(input).remove();\n\n    }\n\n    // Shows the specified dropdown panel\n    function show(input) {\n\n        var minicolors = input.parent(),\n            panel = minicolors.find('.minicolors-panel'),\n            settings = input.data('minicolors-settings');\n\n        // Do nothing if uninitialized, disabled, inline, or already open\n        if( !input.data('minicolors-initialized') ||\n            input.prop('disabled') ||\n            minicolors.hasClass('minicolors-inline') ||\n            minicolors.hasClass('minicolors-focus')\n        ) return;\n\n        hide();\n\n        minicolors.addClass('minicolors-focus');\n        panel\n            .stop(true, true)\n            .fadeIn(settings.showSpeed, function() {\n                if( settings.show ) settings.show.call(input.get(0));\n            });\n\n    }\n\n    // Hides all dropdown panels\n    function hide() {\n\n        $('.minicolors-focus').each( function() {\n\n            var minicolors = $(this),\n                input = minicolors.find('.minicolors-input'),\n                panel = minicolors.find('.minicolors-panel'),\n                settings = input.data('minicolors-settings');\n\n            panel.fadeOut(settings.hideSpeed, function() {\n                if( settings.hide ) settings.hide.call(input.get(0));\n                minicolors.removeClass('minicolors-focus');\n            });\n\n        });\n    }\n\n    // Moves the selected picker\n    function move(target, event, animate) {\n\n        var input = target.parents('.minicolors').find('.minicolors-input'),\n            settings = input.data('minicolors-settings'),\n            picker = target.find('[class$=-picker]'),\n            offsetX = target.offset().left,\n            offsetY = target.offset().top,\n            x = Math.round(event.pageX - offsetX),\n            y = Math.round(event.pageY - offsetY),\n            duration = animate ? settings.animationSpeed : 0,\n            wx, wy, r, phi;\n\n        // Touch support\n        if( event.originalEvent.changedTouches ) {\n            x = event.originalEvent.changedTouches[0].pageX - offsetX;\n            y = event.originalEvent.changedTouches[0].pageY - offsetY;\n        }\n\n        // Constrain picker to its container\n        if( x < 0 ) x = 0;\n        if( y < 0 ) y = 0;\n        if( x > target.width() ) x = target.width();\n        if( y > target.height() ) y = target.height();\n\n        // Constrain color wheel values to the wheel\n        if( target.parent().is('.minicolors-slider-wheel') && picker.parent().is('.minicolors-grid') ) {\n            wx = 75 - x;\n            wy = 75 - y;\n            r = Math.sqrt(wx * wx + wy * wy);\n            phi = Math.atan2(wy, wx);\n            if( phi < 0 ) phi += Math.PI * 2;\n            if( r > 75 ) {\n                r = 75;\n                x = 75 - (75 * Math.cos(phi));\n                y = 75 - (75 * Math.sin(phi));\n            }\n            x = Math.round(x);\n            y = Math.round(y);\n        }\n\n        // Move the picker\n        if( target.is('.minicolors-grid') ) {\n            picker\n                .stop(true)\n                .animate({\n                    top: y + 'px',\n                    left: x + 'px'\n                }, duration, settings.animationEasing, function() {\n                    updateFromControl(input, target);\n                });\n        } else {\n            picker\n                .stop(true)\n                .animate({\n                    top: y + 'px'\n                }, duration, settings.animationEasing, function() {\n                    updateFromControl(input, target);\n                });\n        }\n\n    }\n\n    // Sets the input based on the color picker values\n    function updateFromControl(input, target) {\n\n        function getCoords(picker, container) {\n\n            var left, top;\n            if( !picker.length || !container ) return null;\n            left = picker.offset().left;\n            top = picker.offset().top;\n\n            return {\n                x: left - container.offset().left + (picker.outerWidth() / 2),\n                y: top - container.offset().top + (picker.outerHeight() / 2)\n            };\n\n        }\n\n        var hue, saturation, brightness, x, y, r, phi,\n\n            hex = input.val(),\n            opacity = input.attr('data-opacity'),\n\n            // Helpful references\n            minicolors = input.parent(),\n            settings = input.data('minicolors-settings'),\n            swatch = minicolors.find('.minicolors-input-swatch'),\n\n            // Panel objects\n            grid = minicolors.find('.minicolors-grid'),\n            slider = minicolors.find('.minicolors-slider'),\n            opacitySlider = minicolors.find('.minicolors-opacity-slider'),\n\n            // Picker objects\n            gridPicker = grid.find('[class$=-picker]'),\n            sliderPicker = slider.find('[class$=-picker]'),\n            opacityPicker = opacitySlider.find('[class$=-picker]'),\n\n            // Picker positions\n            gridPos = getCoords(gridPicker, grid),\n            sliderPos = getCoords(sliderPicker, slider),\n            opacityPos = getCoords(opacityPicker, opacitySlider);\n\n        // Handle colors\n        if( target.is('.minicolors-grid, .minicolors-slider, .minicolors-opacity-slider') ) {\n\n            // Determine HSB values\n            switch(settings.control) {\n\n                case 'wheel':\n                    // Calculate hue, saturation, and brightness\n                    x = (grid.width() / 2) - gridPos.x;\n                    y = (grid.height() / 2) - gridPos.y;\n                    r = Math.sqrt(x * x + y * y);\n                    phi = Math.atan2(y, x);\n                    if( phi < 0 ) phi += Math.PI * 2;\n                    if( r > 75 ) {\n                        r = 75;\n                        gridPos.x = 69 - (75 * Math.cos(phi));\n                        gridPos.y = 69 - (75 * Math.sin(phi));\n                    }\n                    saturation = keepWithin(r / 0.75, 0, 100);\n                    hue = keepWithin(phi * 180 / Math.PI, 0, 360);\n                    brightness = keepWithin(100 - Math.floor(sliderPos.y * (100 / slider.height())), 0, 100);\n                    hex = hsb2hex({\n                        h: hue,\n                        s: saturation,\n                        b: brightness\n                    });\n\n                    // Update UI\n                    slider.css('backgroundColor', hsb2hex({ h: hue, s: saturation, b: 100 }));\n                    break;\n\n                case 'saturation':\n                    // Calculate hue, saturation, and brightness\n                    hue = keepWithin(parseInt(gridPos.x * (360 / grid.width()), 10), 0, 360);\n                    saturation = keepWithin(100 - Math.floor(sliderPos.y * (100 / slider.height())), 0, 100);\n                    brightness = keepWithin(100 - Math.floor(gridPos.y * (100 / grid.height())), 0, 100);\n                    hex = hsb2hex({\n                        h: hue,\n                        s: saturation,\n                        b: brightness\n                    });\n\n                    // Update UI\n                    slider.css('backgroundColor', hsb2hex({ h: hue, s: 100, b: brightness }));\n                    minicolors.find('.minicolors-grid-inner').css('opacity', saturation / 100);\n                    break;\n\n                case 'brightness':\n                    // Calculate hue, saturation, and brightness\n                    hue = keepWithin(parseInt(gridPos.x * (360 / grid.width()), 10), 0, 360);\n                    saturation = keepWithin(100 - Math.floor(gridPos.y * (100 / grid.height())), 0, 100);\n                    brightness = keepWithin(100 - Math.floor(sliderPos.y * (100 / slider.height())), 0, 100);\n                    hex = hsb2hex({\n                        h: hue,\n                        s: saturation,\n                        b: brightness\n                    });\n\n                    // Update UI\n                    slider.css('backgroundColor', hsb2hex({ h: hue, s: saturation, b: 100 }));\n                    minicolors.find('.minicolors-grid-inner').css('opacity', 1 - (brightness / 100));\n                    break;\n\n                default:\n                    // Calculate hue, saturation, and brightness\n                    hue = keepWithin(360 - parseInt(sliderPos.y * (360 / slider.height()), 10), 0, 360);\n                    saturation = keepWithin(Math.floor(gridPos.x * (100 / grid.width())), 0, 100);\n                    brightness = keepWithin(100 - Math.floor(gridPos.y * (100 / grid.height())), 0, 100);\n                    hex = hsb2hex({\n                        h: hue,\n                        s: saturation,\n                        b: brightness\n                    });\n\n                    // Update UI\n                    grid.css('backgroundColor', hsb2hex({ h: hue, s: 100, b: 100 }));\n                    break;\n\n            }\n\n            // Handle opacity\n            if( settings.opacity ) {\n                opacity = parseFloat(1 - (opacityPos.y / opacitySlider.height())).toFixed(2);\n            } else {\n                opacity = 1;\n            }\n\n            updateInput(input, hex, opacity);\n        }\n        else {\n            // Set swatch color\n            swatch.find('span').css({\n                backgroundColor: hex,\n                opacity: opacity\n            });\n\n            // Handle change event\n            doChange(input, hex, opacity);\n        }\n    }\n\n    // Sets the value of the input and does the appropriate conversions\n    // to respect settings, also updates the swatch\n    function updateInput(input, value, opacity) {\n        var rgb,\n\n            // Helpful references\n            minicolors = input.parent(),\n            settings = input.data('minicolors-settings'),\n            swatch = minicolors.find('.minicolors-input-swatch');\n\n        if( settings.opacity ) input.attr('data-opacity', opacity);\n\n        // Set color string\n        if( settings.format === 'rgb' ) {\n            // Returns RGB(A) string\n\n            // Checks for input format and does the conversion\n            if ( isRgb(value) ) {\n                rgb = parseRgb(value, true);\n            }\n            else {\n                rgb = hex2rgb(parseHex(value, true));\n            }\n\n            opacity = input.attr('data-opacity') === '' ? 1 : keepWithin( parseFloat( input.attr('data-opacity') ).toFixed(2), 0, 1 );\n            if( isNaN( opacity ) || !settings.opacity ) opacity = 1;\n\n            if( input.minicolors('rgbObject').a <= 1 && rgb && settings.opacity) {\n                // Set RGBA string if alpha\n                if (parseFloat( opacity ) == 1) {\n                    value = rgb2hex(rgb);\n                } else if (parseFloat( opacity ) == 0) {\n                    value = 'transparent';\n                } else {\n                    value = 'rgba(' + rgb.r + ', ' + rgb.g + ', ' + rgb.b + ', ' + parseFloat( opacity ) + ')';\n                }\n            } else {\n                // Set RGB string (alpha = 1)\n                value = 'rgb(' + rgb.r + ', ' + rgb.g + ', ' + rgb.b + ')';\n            }\n        } else {\n            // Returns hex color\n\n            // Checks for input format and does the conversion\n            if ( isRgb(value) ) {\n                value = rgbString2hex(value);\n            }\n\n            value = convertCase( value, settings.letterCase );\n        }\n\n        // Update value from picker\n        input.val( value );\n\n        // Set swatch color\n        swatch.find('span').css({\n            backgroundColor: value,\n            opacity: opacity\n        });\n\n        // Handle change event\n        doChange(input, value, opacity);\n    }\n\n    // Sets the color picker values from the input\n    function updateFromInput(input, preserveInputValue) {\n\n        var hex,\n            hsb,\n            opacity,\n            keywords,\n            alpha,\n            value,\n            x, y, r, phi,\n\n            // Helpful references\n            minicolors = input.parent(),\n            settings = input.data('minicolors-settings'),\n            swatch = minicolors.find('.minicolors-input-swatch'),\n\n            // Panel objects\n            grid = minicolors.find('.minicolors-grid'),\n            slider = minicolors.find('.minicolors-slider'),\n            opacitySlider = minicolors.find('.minicolors-opacity-slider'),\n\n            // Picker objects\n            gridPicker = grid.find('[class$=-picker]'),\n            sliderPicker = slider.find('[class$=-picker]'),\n            opacityPicker = opacitySlider.find('[class$=-picker]');\n\n        // Determine hex/HSB values\n        if( isRgb(input.val()) ) {\n            // If input value is a rgb(a) string, convert it to hex color and update opacity\n            hex = rgbString2hex(input.val());\n            alpha = keepWithin(parseFloat(getAlpha(input.val())).toFixed(2), 0, 1);\n            if( alpha ) {\n                input.attr('data-opacity', alpha);\n            }\n        } else {\n            hex = convertCase(parseHex(input.val(), true), settings.letterCase);\n        }\n\n        if( !hex ){\n            hex = convertCase(parseInput(settings.defaultValue, true), settings.letterCase);\n        }\n        hsb = hex2hsb(hex);\n\n        // Get array of lowercase keywords\n        keywords = !settings.keywords ? [] : $.map(settings.keywords.split(','), function(a) {\n            return $.trim(a.toLowerCase());\n        });\n\n        // Set color string\n        if( input.val() !== '' && $.inArray(input.val().toLowerCase(), keywords) > -1 ) {\n            value = convertCase(input.val());\n        } else {\n            value = isRgb(input.val()) ? parseRgb(input.val()) : hex;\n        }\n\n        // Update input value\n        if( !preserveInputValue ) input.val(value);\n\n        // Determine opacity value\n        if( settings.opacity ) {\n            // Get from data-opacity attribute and keep within 0-1 range\n            opacity = input.attr('data-opacity') === '' ? 1 : keepWithin(parseFloat(input.attr('data-opacity')).toFixed(2), 0, 1);\n            if( isNaN(opacity) ) opacity = 1;\n            input.attr('data-opacity', opacity);\n            swatch.find('span').css('opacity', opacity);\n\n            // Set opacity picker position\n            y = keepWithin(opacitySlider.height() - (opacitySlider.height() * opacity), 0, opacitySlider.height());\n            opacityPicker.css('top', y + 'px');\n        }\n\n        // Set opacity to zero if input value is transparent\n        if( input.val().toLowerCase() === 'transparent' ) {\n            swatch.find('span').css('opacity', 0);\n        }\n\n        // Update swatch\n        swatch.find('span').css('backgroundColor', hex);\n\n        // Determine picker locations\n        switch(settings.control) {\n\n            case 'wheel':\n                // Set grid position\n                r = keepWithin(Math.ceil(hsb.s * 0.75), 0, grid.height() / 2);\n                phi = hsb.h * Math.PI / 180;\n                x = keepWithin(75 - Math.cos(phi) * r, 0, grid.width());\n                y = keepWithin(75 - Math.sin(phi) * r, 0, grid.height());\n                gridPicker.css({\n                    top: y + 'px',\n                    left: x + 'px'\n                });\n\n                // Set slider position\n                y = 150 - (hsb.b / (100 / grid.height()));\n                if( hex === '' ) y = 0;\n                sliderPicker.css('top', y + 'px');\n\n                // Update panel color\n                slider.css('backgroundColor', hsb2hex({ h: hsb.h, s: hsb.s, b: 100 }));\n                break;\n\n            case 'saturation':\n                // Set grid position\n                x = keepWithin((5 * hsb.h) / 12, 0, 150);\n                y = keepWithin(grid.height() - Math.ceil(hsb.b / (100 / grid.height())), 0, grid.height());\n                gridPicker.css({\n                    top: y + 'px',\n                    left: x + 'px'\n                });\n\n                // Set slider position\n                y = keepWithin(slider.height() - (hsb.s * (slider.height() / 100)), 0, slider.height());\n                sliderPicker.css('top', y + 'px');\n\n                // Update UI\n                slider.css('backgroundColor', hsb2hex({ h: hsb.h, s: 100, b: hsb.b }));\n              