require.config({"config": {
        "jsbuild":{"jquery/jstree/jquery.jstree.js":"/*globals jQuery, define, module, exports, require, window, document, postMessage */\n(function (factory) {\n    \"use strict\";\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery'], factory);\n    }\n    else if(typeof module !== 'undefined' && module.exports) {\n        module.exports = factory(require('jquery'));\n    }\n    else {\n        factory(jQuery);\n    }\n}(function ($, undefined) {\n    \"use strict\";\n    /*!\n * jsTree 3.3.12\n * http://jstree.com/\n *\n * Copyright (c) 2014 Ivan Bozhanov (http://vakata.com)\n *\n * Licensed same as jquery - under the terms of the MIT License\n *   http://www.opensource.org/licenses/mit-license.php\n */\n    /*!\n * if using jslint please allow for the jQuery global and use following options:\n * jslint: loopfunc: true, browser: true, ass: true, bitwise: true, continue: true, nomen: true, plusplus: true, regexp: true, unparam: true, todo: true, white: true\n */\n    /*jshint -W083 */\n\n    // prevent another load? maybe there is a better way?\n    if($.jstree) {\n        return;\n    }\n\n    /**\n     * ### jsTree core functionality\n     */\n\n        // internal variables\n    var instance_counter = 0,\n        ccp_node = false,\n        ccp_mode = false,\n        ccp_inst = false,\n        themes_loaded = [],\n        src = $('script:last').attr('src'),\n        document = window.document; // local variable is always faster to access then a global\n\n    var setImmediate = window.setImmediate;\n    var Promise = window.Promise;\n    if (!setImmediate && Promise) {\n        // Good enough approximation of setImmediate\n        setImmediate = function (cb, arg) {\n            Promise.resolve(arg).then(cb);\n        };\n    }\n\n    /**\n     * holds all jstree related functions and variables, including the actual class and methods to create, access and manipulate instances.\n     * @name $.jstree\n     */\n    $.jstree = {\n        /**\n         * specifies the jstree version in use\n         * @name $.jstree.version\n         */\n        version : '3.3.12',\n        /**\n         * holds all the default options used when creating new instances\n         * @name $.jstree.defaults\n         */\n        defaults : {\n            /**\n             * configure which plugins will be active on an instance. Should be an array of strings, where each element is a plugin name. The default is `[]`\n             * @name $.jstree.defaults.plugins\n             */\n            plugins : []\n        },\n        /**\n         * stores all loaded jstree plugins (used internally)\n         * @name $.jstree.plugins\n         */\n        plugins : {},\n        path : src && src.indexOf('/') !== -1 ? src.replace(/\\/[^\\/]+$/,'') : '',\n        idregex : /[\\\\:&!^|()\\[\\]<>@*'+~#\";.,=\\- \\/${}%?`]/g,\n        root : '#'\n    };\n\n    /**\n     * creates a jstree instance\n     * @name $.jstree.create(el [, options])\n     * @param {DOMElement|jQuery|String} el the element to create the instance on, can be jQuery extended or a selector\n     * @param {Object} options options for this instance (extends `$.jstree.defaults`)\n     * @return {jsTree} the new instance\n     */\n    $.jstree.create = function (el, options) {\n        var tmp = new $.jstree.core(++instance_counter),\n            opt = options;\n        options = $.extend(true, {}, $.jstree.defaults, options);\n        if(opt && opt.plugins) {\n            options.plugins = opt.plugins;\n        }\n        $.each(options.plugins, function (i, k) {\n            if(i !== 'core') {\n                tmp = tmp.plugin(k, options[k]);\n            }\n        });\n        $(el).data('jstree', tmp);\n        tmp.init(el, options);\n        return tmp;\n    };\n    /**\n     * remove all traces of jstree from the DOM and destroy all instances\n     * @name $.jstree.destroy()\n     */\n    $.jstree.destroy = function () {\n        $('.jstree:jstree').jstree('destroy');\n        $(document).off('.jstree');\n    };\n    /**\n     * the jstree class constructor, used only internally\n     * @private\n     * @name $.jstree.core(id)\n     * @param {Number} id this instance's index\n     */\n    $.jstree.core = function (id) {\n        this._id = id;\n        this._cnt = 0;\n        this._wrk = null;\n        this._data = {\n            core : {\n                themes : {\n                    name : false,\n                    dots : false,\n                    icons : false,\n                    ellipsis : false\n                },\n                selected : [],\n                last_error : {},\n                working : false,\n                worker_queue : [],\n                focused : null\n            }\n        };\n    };\n    /**\n     * get a reference to an existing instance\n     *\n     * __Examples__\n     *\n     *\t// provided a container with an ID of \"tree\", and a nested node with an ID of \"branch\"\n     *\t// all of there will return the same instance\n     *\t$.jstree.reference('tree');\n     *\t$.jstree.reference('#tree');\n     *\t$.jstree.reference($('#tree'));\n     *\t$.jstree.reference(document.getElementByID('tree'));\n     *\t$.jstree.reference('branch');\n     *\t$.jstree.reference('#branch');\n     *\t$.jstree.reference($('#branch'));\n     *\t$.jstree.reference(document.getElementByID('branch'));\n     *\n     * @name $.jstree.reference(needle)\n     * @param {DOMElement|jQuery|String} needle\n     * @return {jsTree|null} the instance or `null` if not found\n     */\n    $.jstree.reference = function (needle) {\n        var tmp = null,\n            obj = null;\n        if(needle && needle.id && (!needle.tagName || !needle.nodeType)) { needle = needle.id; }\n\n        if(!obj || !obj.length) {\n            try { obj = $(needle); } catch (ignore) { }\n        }\n        if(!obj || !obj.length) {\n            try { obj = $('#' + needle.replace($.jstree.idregex,'\\\\$&')); } catch (ignore) { }\n        }\n        if(obj && obj.length && (obj = obj.closest('.jstree')).length && (obj = obj.data('jstree'))) {\n            tmp = obj;\n        }\n        else {\n            $('.jstree').each(function () {\n                var inst = $(this).data('jstree');\n                if(inst && inst._model.data[needle]) {\n                    tmp = inst;\n                    return false;\n                }\n            });\n        }\n        return tmp;\n    };\n    /**\n     * Create an instance, get an instance or invoke a command on a instance.\n     *\n     * If there is no instance associated with the current node a new one is created and `arg` is used to extend `$.jstree.defaults` for this new instance. There would be no return value (chaining is not broken).\n     *\n     * If there is an existing instance and `arg` is a string the command specified by `arg` is executed on the instance, with any additional arguments passed to the function. If the function returns a value it will be returned (chaining could break depending on function).\n     *\n     * If there is an existing instance and `arg` is not a string the instance itself is returned (similar to `$.jstree.reference`).\n     *\n     * In any other case - nothing is returned and chaining is not broken.\n     *\n     * __Examples__\n     *\n     *\t$('#tree1').jstree(); // creates an instance\n     *\t$('#tree2').jstree({ plugins : [] }); // create an instance with some options\n     *\t$('#tree1').jstree('open_node', '#branch_1'); // call a method on an existing instance, passing additional arguments\n     *\t$('#tree2').jstree(); // get an existing instance (or create an instance)\n     *\t$('#tree2').jstree(true); // get an existing instance (will not create new instance)\n     *\t$('#branch_1').jstree().select_node('#branch_1'); // get an instance (using a nested element and call a method)\n     *\n     * @name $().jstree([arg])\n     * @param {String|Object} arg\n     * @return {Mixed}\n     */\n    $.fn.jstree = function (arg) {\n        // check for string argument\n        var is_method\t= (typeof arg === 'string'),\n            args\t\t= Array.prototype.slice.call(arguments, 1),\n            result\t\t= null;\n        if(arg === true && !this.length) { return false; }\n        this.each(function () {\n            // get the instance (if there is one) and method (if it exists)\n            var instance = $.jstree.reference(this),\n                method = is_method && instance ? instance[arg] : null;\n            // if calling a method, and method is available - execute on the instance\n            result = is_method && method ?\n                method.apply(instance, args) :\n                null;\n            // if there is no instance and no method is being called - create one\n            if(!instance && !is_method && (arg === undefined || $.isPlainObject(arg))) {\n                $.jstree.create(this, arg);\n            }\n            // if there is an instance and no method is called - return the instance\n            if( (instance && !is_method) || arg === true ) {\n                result = instance || false;\n            }\n            // if there was a method call which returned a result - break and return the value\n            if(result !== null && result !== undefined) {\n                return false;\n            }\n        });\n        // if there was a method call with a valid return value - return that, otherwise continue the chain\n        return result !== null && result !== undefined ?\n            result : this;\n    };\n    /**\n     * used to find elements containing an instance\n     *\n     * __Examples__\n     *\n     *\t$('div:jstree').each(function () {\n     *\t\t$(this).jstree('destroy');\n     *\t});\n     *\n     * @name $(':jstree')\n     * @return {jQuery}\n     */\n    $.expr.pseudos.jstree = $.expr.createPseudo(function(search) {\n        return function(a) {\n            return $(a).hasClass('jstree') &&\n                $(a).data('jstree') !== undefined;\n        };\n    });\n\n    /**\n     * stores all defaults for the core\n     * @name $.jstree.defaults.core\n     */\n    $.jstree.defaults.core = {\n        /**\n         * data configuration\n         *\n         * If left as `false` the HTML inside the jstree container element is used to populate the tree (that should be an unordered list with list items).\n         *\n         * You can also pass in a HTML string or a JSON array here.\n         *\n         * It is possible to pass in a standard jQuery-like AJAX config and jstree will automatically determine if the response is JSON or HTML and use that to populate the tree.\n         * In addition to the standard jQuery ajax options here you can supply functions for `data` and `url`, the functions will be run in the current instance's scope and a param will be passed indicating which node is being loaded, the return value of those functions will be used.\n         *\n         * The last option is to specify a function, that function will receive the node being loaded as argument and a second param which is a function which should be called with the result.\n         *\n         * __Examples__\n         *\n         *\t// AJAX\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'data' : {\n         *\t\t\t\t'url' : '/get/children/',\n         *\t\t\t\t'data' : function (node) {\n         *\t\t\t\t\treturn { 'id' : node.id };\n         *\t\t\t\t}\n         *\t\t\t}\n         *\t\t});\n         *\n         *\t// direct data\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'data' : [\n         *\t\t\t\t'Simple root node',\n         *\t\t\t\t{\n         *\t\t\t\t\t'id' : 'node_2',\n         *\t\t\t\t\t'text' : 'Root node with options',\n         *\t\t\t\t\t'state' : { 'opened' : true, 'selected' : true },\n         *\t\t\t\t\t'children' : [ { 'text' : 'Child 1' }, 'Child 2']\n         *\t\t\t\t}\n         *\t\t\t]\n         *\t\t}\n         *\t});\n         *\n         *\t// function\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'data' : function (obj, callback) {\n         *\t\t\t\tcallback.call(this, ['Root 1', 'Root 2']);\n         *\t\t\t}\n         *\t\t});\n         *\n         * @name $.jstree.defaults.core.data\n         */\n        data\t\t\t: false,\n        /**\n         * configure the various strings used throughout the tree\n         *\n         * You can use an object where the key is the string you need to replace and the value is your replacement.\n         * Another option is to specify a function which will be called with an argument of the needed string and should return the replacement.\n         * If left as `false` no replacement is made.\n         *\n         * __Examples__\n         *\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'strings' : {\n         *\t\t\t\t'Loading ...' : 'Please wait ...'\n         *\t\t\t}\n         *\t\t}\n         *\t});\n         *\n         * @name $.jstree.defaults.core.strings\n         */\n        strings\t\t\t: false,\n        /**\n         * determines what happens when a user tries to modify the structure of the tree\n         * If left as `false` all operations like create, rename, delete, move or copy are prevented.\n         * You can set this to `true` to allow all interactions or use a function to have better control.\n         *\n         * __Examples__\n         *\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'check_callback' : function (operation, node, node_parent, node_position, more) {\n         *\t\t\t\t// operation can be 'create_node', 'rename_node', 'delete_node', 'move_node', 'copy_node' or 'edit'\n         *\t\t\t\t// in case of 'rename_node' node_position is filled with the new node name\n         *\t\t\t\treturn operation === 'rename_node' ? true : false;\n         *\t\t\t}\n         *\t\t}\n         *\t});\n         *\n         * @name $.jstree.defaults.core.check_callback\n         */\n        check_callback\t: false,\n        /**\n         * a callback called with a single object parameter in the instance's scope when something goes wrong (operation prevented, ajax failed, etc)\n         * @name $.jstree.defaults.core.error\n         */\n        error\t\t\t: $.noop,\n        /**\n         * the open / close animation duration in milliseconds - set this to `false` to disable the animation (default is `200`)\n         * @name $.jstree.defaults.core.animation\n         */\n        animation\t\t: 200,\n        /**\n         * a boolean indicating if multiple nodes can be selected\n         * @name $.jstree.defaults.core.multiple\n         */\n        multiple\t\t: true,\n        /**\n         * theme configuration object\n         * @name $.jstree.defaults.core.themes\n         */\n        themes\t\t\t: {\n            /**\n             * the name of the theme to use (if left as `false` the default theme is used)\n             * @name $.jstree.defaults.core.themes.name\n             */\n            name\t\t\t: false,\n            /**\n             * the URL of the theme's CSS file, leave this as `false` if you have manually included the theme CSS (recommended). You can set this to `true` too which will try to autoload the theme.\n             * @name $.jstree.defaults.core.themes.url\n             */\n            url\t\t\t\t: false,\n            /**\n             * the location of all jstree themes - only used if `url` is set to `true`\n             * @name $.jstree.defaults.core.themes.dir\n             */\n            dir\t\t\t\t: false,\n            /**\n             * a boolean indicating if connecting dots are shown\n             * @name $.jstree.defaults.core.themes.dots\n             */\n            dots\t\t\t: true,\n            /**\n             * a boolean indicating if node icons are shown\n             * @name $.jstree.defaults.core.themes.icons\n             */\n            icons\t\t\t: true,\n            /**\n             * a boolean indicating if node ellipsis should be shown - this only works with a fixed with on the container\n             * @name $.jstree.defaults.core.themes.ellipsis\n             */\n            ellipsis\t\t: false,\n            /**\n             * a boolean indicating if the tree background is striped\n             * @name $.jstree.defaults.core.themes.stripes\n             */\n            stripes\t\t\t: false,\n            /**\n             * a string (or boolean `false`) specifying the theme variant to use (if the theme supports variants)\n             * @name $.jstree.defaults.core.themes.variant\n             */\n            variant\t\t\t: false,\n            /**\n             * a boolean specifying if a reponsive version of the theme should kick in on smaller screens (if the theme supports it). Defaults to `false`.\n             * @name $.jstree.defaults.core.themes.responsive\n             */\n            responsive\t\t: false\n        },\n        /**\n         * if left as `true` all parents of all selected nodes will be opened once the tree loads (so that all selected nodes are visible to the user)\n         * @name $.jstree.defaults.core.expand_selected_onload\n         */\n        expand_selected_onload : true,\n        /**\n         * if left as `true` web workers will be used to parse incoming JSON data where possible, so that the UI will not be blocked by large requests. Workers are however about 30% slower. Defaults to `true`\n         * @name $.jstree.defaults.core.worker\n         */\n        worker : true,\n        /**\n         * Force node text to plain text (and escape HTML). Defaults to `false`\n         * @name $.jstree.defaults.core.force_text\n         */\n        force_text : false,\n        /**\n         * Should the node be toggled if the text is double clicked. Defaults to `true`\n         * @name $.jstree.defaults.core.dblclick_toggle\n         */\n        dblclick_toggle : true,\n        /**\n         * Should the loaded nodes be part of the state. Defaults to `false`\n         * @name $.jstree.defaults.core.loaded_state\n         */\n        loaded_state : false,\n        /**\n         * Should the last active node be focused when the tree container is blurred and the focused again. This helps working with screen readers. Defaults to `true`\n         * @name $.jstree.defaults.core.restore_focus\n         */\n        restore_focus : true,\n        /**\n         * Force to compute and set \"aria-setsize\" and \"aria-posinset\" explicitly for each treeitem.\n         * Some browsers may compute incorrect elements position and produce wrong announcements for screen readers. Defaults to `false`\n         * @name $.jstree.defaults.core.compute_elements_positions\n         */\n        compute_elements_positions : false,\n        /**\n         * Default keyboard shortcuts (an object where each key is the button name or combo - like 'enter', 'ctrl-space', 'p', etc and the value is the function to execute in the instance's scope)\n         * @name $.jstree.defaults.core.keyboard\n         */\n        keyboard : {\n            'ctrl-space': function (e) {\n                // aria defines space only with Ctrl\n                e.type = \"click\";\n                $(e.currentTarget).trigger(e);\n            },\n            'enter': function (e) {\n                // enter\n                e.type = \"click\";\n                $(e.currentTarget).trigger(e);\n            },\n            'left': function (e) {\n                // left\n                e.preventDefault();\n                if(this.is_open(e.currentTarget)) {\n                    this.close_node(e.currentTarget);\n                }\n                else {\n                    var o = this.get_parent(e.currentTarget);\n                    if(o && o.id !== $.jstree.root) { this.get_node(o, true).children('.jstree-anchor').trigger('focus'); }\n                }\n            },\n            'up': function (e) {\n                // up\n                e.preventDefault();\n                var o = this.get_prev_dom(e.currentTarget);\n                if(o && o.length) { o.children('.jstree-anchor').trigger('focus'); }\n            },\n            'right': function (e) {\n                // right\n                e.preventDefault();\n                if(this.is_closed(e.currentTarget)) {\n                    this.open_node(e.currentTarget, function (o) { this.get_node(o, true).children('.jstree-anchor').trigger('focus'); });\n                }\n                else if (this.is_open(e.currentTarget)) {\n                    var o = this.get_node(e.currentTarget, true).children('.jstree-children')[0];\n                    if(o) { $(this._firstChild(o)).children('.jstree-anchor').trigger('focus'); }\n                }\n            },\n            'down': function (e) {\n                // down\n                e.preventDefault();\n                var o = this.get_next_dom(e.currentTarget);\n                if(o && o.length) { o.children('.jstree-anchor').trigger('focus'); }\n            },\n            '*': function (e) {\n                // aria defines * on numpad as open_all - not very common\n                this.open_all();\n            },\n            'home': function (e) {\n                // home\n                e.preventDefault();\n                var o = this._firstChild(this.get_container_ul()[0]);\n                if(o) { $(o).children('.jstree-anchor').filter(':visible').trigger('focus'); }\n            },\n            'end': function (e) {\n                // end\n                e.preventDefault();\n                this.element.find('.jstree-anchor').filter(':visible').last().trigger('focus');\n            },\n            'f2': function (e) {\n                // f2 - safe to include - if check_callback is false it will fail\n                e.preventDefault();\n                this.edit(e.currentTarget);\n            }\n        }\n    };\n    $.jstree.core.prototype = {\n        /**\n         * used to decorate an instance with a plugin. Used internally.\n         * @private\n         * @name plugin(deco [, opts])\n         * @param  {String} deco the plugin to decorate with\n         * @param  {Object} opts options for the plugin\n         * @return {jsTree}\n         */\n        plugin : function (deco, opts) {\n            var Child = $.jstree.plugins[deco];\n            if(Child) {\n                this._data[deco] = {};\n                Child.prototype = this;\n                return new Child(opts, this);\n            }\n            return this;\n        },\n        /**\n         * initialize the instance. Used internally.\n         * @private\n         * @name init(el, optons)\n         * @param {DOMElement|jQuery|String} el the element we are transforming\n         * @param {Object} options options for this instance\n         * @trigger init.jstree, loading.jstree, loaded.jstree, ready.jstree, changed.jstree\n         */\n        init : function (el, options) {\n            this._model = {\n                data : {},\n                changed : [],\n                force_full_redraw : false,\n                redraw_timeout : false,\n                default_state : {\n                    loaded : true,\n                    opened : false,\n                    selected : false,\n                    disabled : false\n                }\n            };\n            this._model.data[$.jstree.root] = {\n                id : $.jstree.root,\n                parent : null,\n                parents : [],\n                children : [],\n                children_d : [],\n                state : { loaded : false }\n            };\n\n            this.element = $(el).addClass('jstree jstree-' + this._id);\n            this.settings = options;\n\n            this._data.core.ready = false;\n            this._data.core.loaded = false;\n            this._data.core.rtl = (this.element.css(\"direction\") === \"rtl\");\n            this.element[this._data.core.rtl ? 'addClass' : 'removeClass'](\"jstree-rtl\");\n            this.element.attr('role','tree');\n            if(this.settings.core.multiple) {\n                this.element.attr('aria-multiselectable', true);\n            }\n            if(!this.element.attr('tabindex')) {\n                this.element.attr('tabindex','0');\n            }\n\n            this.bind();\n            /**\n             * triggered after all events are bound\n             * @event\n             * @name init.jstree\n             */\n            this.trigger(\"init\");\n\n            this._data.core.original_container_html = this.element.find(\" > ul > li\").clone(true);\n            this._data.core.original_container_html\n                .find(\"li\").addBack()\n                .contents().filter(function() {\n                return this.nodeType === 3 && (!this.nodeValue || /^\\s+$/.test(this.nodeValue));\n            })\n                .remove();\n            this.element.html(\"<\"+\"ul class='jstree-container-ul jstree-children' role='group'><\"+\"li id='j\"+this._id+\"_loading' class='jstree-initial-node jstree-loading jstree-leaf jstree-last' role='none'><i class='jstree-icon jstree-ocl'></i><\"+\"a class='jstree-anchor' role='treeitem' href='#'><i class='jstree-icon jstree-themeicon-hidden'></i>\" + this.get_string(\"Loading ...\") + \"</a></li></ul>\");\n            this.element.attr('aria-activedescendant','j' + this._id + '_loading');\n            this._data.core.li_height = this.get_container_ul().children(\"li\").first().outerHeight() || 24;\n            this._data.core.node = this._create_prototype_node();\n            /**\n             * triggered after the loading text is shown and before loading starts\n             * @event\n             * @name loading.jstree\n             */\n            this.trigger(\"loading\");\n            this.load_node($.jstree.root);\n        },\n        /**\n         * destroy an instance\n         * @name destroy()\n         * @param  {Boolean} keep_html if not set to `true` the container will be emptied, otherwise the current DOM elements will be kept intact\n         */\n        destroy : function (keep_html) {\n            /**\n             * triggered before the tree is destroyed\n             * @event\n             * @name destroy.jstree\n             */\n            this.trigger(\"destroy\");\n            if(this._wrk) {\n                try {\n                    window.URL.revokeObjectURL(this._wrk);\n                    this._wrk = null;\n                }\n                catch (ignore) { }\n            }\n            if(!keep_html) { this.element.empty(); }\n            this.teardown();\n        },\n        /**\n         * Create a prototype node\n         * @name _create_prototype_node()\n         * @return {DOMElement}\n         */\n        _create_prototype_node : function () {\n            var _node = document.createElement('LI'), _temp1, _temp2;\n            _node.setAttribute('role', 'none');\n            _temp1 = document.createElement('I');\n            _temp1.className = 'jstree-icon jstree-ocl';\n            _temp1.setAttribute('role', 'presentation');\n            _node.appendChild(_temp1);\n            _temp1 = document.createElement('A');\n            _temp1.className = 'jstree-anchor';\n            _temp1.setAttribute('href','#');\n            _temp1.setAttribute('tabindex','-1');\n            _temp1.setAttribute('role', 'treeitem');\n            _temp2 = document.createElement('I');\n            _temp2.className = 'jstree-icon jstree-themeicon';\n            _temp2.setAttribute('role', 'presentation');\n            _temp1.appendChild(_temp2);\n            _node.appendChild(_temp1);\n            _temp1 = _temp2 = null;\n\n            return _node;\n        },\n        _kbevent_to_func : function (e) {\n            var keys = {\n                8: \"Backspace\", 9: \"Tab\", 13: \"Enter\", 19: \"Pause\", 27: \"Esc\",\n                32: \"Space\", 33: \"PageUp\", 34: \"PageDown\", 35: \"End\", 36: \"Home\",\n                37: \"Left\", 38: \"Up\", 39: \"Right\", 40: \"Down\", 44: \"Print\", 45: \"Insert\",\n                46: \"Delete\", 96: \"Numpad0\", 97: \"Numpad1\", 98: \"Numpad2\", 99 : \"Numpad3\",\n                100: \"Numpad4\", 101: \"Numpad5\", 102: \"Numpad6\", 103: \"Numpad7\",\n                104: \"Numpad8\", 105: \"Numpad9\", '-13': \"NumpadEnter\", 112: \"F1\",\n                113: \"F2\", 114: \"F3\", 115: \"F4\", 116: \"F5\", 117: \"F6\", 118: \"F7\",\n                119: \"F8\", 120: \"F9\", 121: \"F10\", 122: \"F11\", 123: \"F12\", 144: \"Numlock\",\n                145: \"Scrolllock\", 16: 'Shift', 17: 'Ctrl', 18: 'Alt',\n                48: '0',  49: '1',  50: '2',  51: '3',  52: '4', 53:  '5',\n                54: '6',  55: '7',  56: '8',  57: '9',  59: ';',  61: '=', 65:  'a',\n                66: 'b',  67: 'c',  68: 'd',  69: 'e',  70: 'f',  71: 'g', 72:  'h',\n                73: 'i',  74: 'j',  75: 'k',  76: 'l',  77: 'm',  78: 'n', 79:  'o',\n                80: 'p',  81: 'q',  82: 'r',  83: 's',  84: 't',  85: 'u', 86:  'v',\n                87: 'w',  88: 'x',  89: 'y',  90: 'z', 107: '+', 109: '-', 110: '.',\n                186: ';', 187: '=', 188: ',', 189: '-', 190: '.', 191: '/', 192: '`',\n                219: '[', 220: '\\\\',221: ']', 222: \"'\", 111: '/', 106: '*', 173: '-'\n            };\n            var parts = [];\n            if (e.ctrlKey) { parts.push('ctrl'); }\n            if (e.altKey) { parts.push('alt'); }\n            if (e.shiftKey) { parts.push('shift'); }\n            parts.push(keys[e.which] || e.which);\n            parts = parts.sort().join('-').toLowerCase();\n            if (parts === 'shift-shift' || parts === 'ctrl-ctrl' || parts === 'alt-alt') {\n                return null;\n            }\n\n            var kb = this.settings.core.keyboard, i, tmp;\n            for (i in kb) {\n                if (kb.hasOwnProperty(i)) {\n                    tmp = i;\n                    if (tmp !== '-' && tmp !== '+') {\n                        tmp = tmp.replace('--', '-MINUS').replace('+-', '-MINUS').replace('++', '-PLUS').replace('-+', '-PLUS');\n                        tmp = tmp.split(/-|\\+/).sort().join('-').replace('MINUS', '-').replace('PLUS', '+').toLowerCase();\n                    }\n                    if (tmp === parts) {\n                        return kb[i];\n                    }\n                }\n            }\n            return null;\n        },\n        /**\n         * part of the destroying of an instance. Used internally.\n         * @private\n         * @name teardown()\n         */\n        teardown : function () {\n            this.unbind();\n            this.element\n                .removeClass('jstree')\n                .removeData('jstree')\n                .find(\"[class^='jstree']\")\n                .addBack()\n                .attr(\"class\", function () { return this.className.replace(/jstree[^ ]*|$/ig,''); });\n            this.element = null;\n        },\n        /**\n         * bind all events. Used internally.\n         * @private\n         * @name bind()\n         */\n        bind : function () {\n            var word = '',\n                tout = null,\n                was_click = 0;\n            this.element\n                .on(\"dblclick.jstree\", function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(document.selection && document.selection.empty) {\n                        document.selection.empty();\n                    }\n                    else {\n                        if(window.getSelection) {\n                            var sel = window.getSelection();\n                            try {\n                                sel.removeAllRanges();\n                                sel.collapse();\n                            } catch (ignore) { }\n                        }\n                    }\n                })\n                .on(\"mousedown.jstree\", function (e) {\n                    if(e.target === this.element[0]) {\n                        e.preventDefault(); // prevent losing focus when clicking scroll arrows (FF, Chrome)\n                        was_click = +(new Date()); // ie does not allow to prevent losing focus\n                    }\n                }.bind(this))\n                .on(\"mousedown.jstree\", \".jstree-ocl\", function (e) {\n                    e.preventDefault(); // prevent any node inside from losing focus when clicking the open/close icon\n                })\n                .on(\"click.jstree\", \".jstree-ocl\", function (e) {\n                    this.toggle_node(e.target);\n                }.bind(this))\n                .on(\"dblclick.jstree\", \".jstree-anchor\", function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(this.settings.core.dblclick_toggle) {\n                        this.toggle_node(e.target);\n                    }\n                }.bind(this))\n                .on(\"click.jstree\", \".jstree-anchor\", function (e) {\n                    e.preventDefault();\n                    if(e.currentTarget !== document.activeElement) { $(e.currentTarget).trigger('focus'); }\n                    this.activate_node(e.currentTarget, e);\n                }.bind(this))\n                .on('keydown.jstree', '.jstree-anchor', function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(this._data.core.rtl) {\n                        if(e.which === 37) { e.which = 39; }\n                        else if(e.which === 39) { e.which = 37; }\n                    }\n                    var f = this._kbevent_to_func(e);\n                    if (f) {\n                        var r = f.call(this, e);\n                        if (r === false || r === true) {\n                            return r;\n                        }\n                    }\n                }.bind(this))\n                .on(\"load_node.jstree\", function (e, data) {\n                    if(data.status) {\n                        if(data.node.id === $.jstree.root && !this._data.core.loaded) {\n                            this._data.core.loaded = true;\n                            if(this._firstChild(this.get_container_ul()[0])) {\n                                this.element.attr('aria-activedescendant',this._firstChild(this.get_container_ul()[0]).id);\n                            }\n                            /**\n                             * triggered after the root node is loaded for the first time\n                             * @event\n                             * @name loaded.jstree\n                             */\n                            this.trigger(\"loaded\");\n                        }\n                        if(!this._data.core.ready) {\n                            setTimeout(function() {\n                                if(this.element && !this.get_container_ul().find('.jstree-loading').length) {\n                                    this._data.core.ready = true;\n                                    if(this._data.core.selected.length) {\n                                        if(this.settings.core.expand_selected_onload) {\n                                            var tmp = [], i, j;\n                                            for(i = 0, j = this._data.core.selected.length; i < j; i++) {\n                                                tmp = tmp.concat(this._model.data[this._data.core.selected[i]].parents);\n                                            }\n                                            tmp = $.vakata.array_unique(tmp);\n                                            for(i = 0, j = tmp.length; i < j; i++) {\n                                                this.open_node(tmp[i], false, 0);\n                                            }\n                                        }\n                                        this.trigger('changed', { 'action' : 'ready', 'selected' : this._data.core.selected });\n                                    }\n                                    /**\n                                     * triggered after all nodes are finished loading\n                                     * @event\n                                     * @name ready.jstree\n                                     */\n                                    this.trigger(\"ready\");\n                                }\n                            }.bind(this), 0);\n                        }\n                    }\n                }.bind(this))\n                // quick searching when the tree is focused\n                .on('keypress.jstree', function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(tout) { clearTimeout(tout); }\n                    tout = setTimeout(function () {\n                        word = '';\n                    }, 500);\n\n                    var chr = String.fromCharCode(e.which).toLowerCase(),\n                        col = this.element.find('.jstree-anchor').filter(':visible'),\n                        ind = col.index(document.activeElement) || 0,\n                        end = false;\n                    word += chr;\n\n                    // match for whole word from current node down (including the current node)\n                    if(word.length > 1) {\n                        col.slice(ind).each(function (i, v) {\n                            if($(v).text().toLowerCase().indexOf(word) === 0) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n\n                        // match for whole word from the beginning of the tree\n                        col.slice(0, ind).each(function (i, v) {\n                            if($(v).text().toLowerCase().indexOf(word) === 0) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n                    }\n                    // list nodes that start with that letter (only if word consists of a single char)\n                    if(new RegExp('^' + chr.replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g, '\\\\$&') + '+$').test(word)) {\n                        // search for the next node starting with that letter\n                        col.slice(ind + 1).each(function (i, v) {\n                            if($(v).text().toLowerCase().charAt(0) === chr) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n\n                        // search from the beginning\n                        col.slice(0, ind + 1).each(function (i, v) {\n                            if($(v).text().toLowerCase().charAt(0) === chr) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n                    }\n                }.bind(this))\n                // THEME RELATED\n                .on(\"init.jstree\", function () {\n                    var s = this.settings.core.themes;\n                    this._data.core.themes.dots\t\t\t= s.dots;\n                    this._data.core.themes.stripes\t\t= s.stripes;\n                    this._data.core.themes.icons\t\t= s.icons;\n                    this._data.core.themes.ellipsis\t\t= s.ellipsis;\n                    this.set_theme(s.name || \"default\", s.url);\n                    this.set_theme_variant(s.variant);\n                }.bind(this))\n                .on(\"loading.jstree\", function () {\n                    this[ this._data.core.themes.dots ? \"show_dots\" : \"hide_dots\" ]();\n                    this[ this._data.core.themes.icons ? \"show_icons\" : \"hide_icons\" ]();\n                    this[ this._data.core.themes.stripes ? \"show_stripes\" : \"hide_stripes\" ]();\n                    this[ this._data.core.themes.ellipsis ? \"show_ellipsis\" : \"hide_ellipsis\" ]();\n                }.bind(this))\n                .on('blur.jstree', '.jstree-anchor', function (e) {\n                    this._data.core.focused = null;\n                    $(e.currentTarget).filter('.jstree-hovered').trigger('mouseleave');\n                    this.element.attr('tabindex', '0');\n                }.bind(this))\n                .on('focus.jstree', '.jstree-anchor', function (e) {\n                    var tmp = this.get_node(e.currentTarget);\n                    if(tmp && tmp.id) {\n                        this._data.core.focused = tmp.id;\n                    }\n                    this.element.find('.jstree-hovered').not(e.currentTarget).trigger('mouseleave');\n                    $(e.currentTarget).trigger('mouseenter');\n                    this.element.attr('tabindex', '-1');\n                }.bind(this))\n                .on('focus.jstree', function () {\n                    if(+(new Date()) - was_click > 500 && !this._data.core.focused && this.settings.core.restore_focus) {\n                        was_click = 0;\n                        var act = this.get_node(this.element.attr('aria-activedescendant'), true);\n                        if(act) {\n                            act.find('> .jstree-anchor').trigger('focus');\n                        }\n                    }\n                }.bind(this))\n                .on('mouseenter.jstree', '.jstree-anchor', function (e) {\n                    this.hover_node(e.currentTarget);\n                }.bind(this))\n                .on('mouseleave.jstree', '.jstree-anchor', function (e) {\n                    this.dehover_node(e.currentTarget);\n                }.bind(this));\n        },\n        /**\n         * part of the destroying of an instance. Used internally.\n         * @private\n         * @name unbind()\n         */\n        unbind : function () {\n            this.element.off('.jstree');\n            $(document).off('.jstree-' + this._id);\n        },\n        /**\n         * trigger an event. Used internally.\n         * @private\n         * @name trigger(ev [, data])\n         * @param  {String} ev the name of the event to trigger\n         * @param  {Object} data additional data to pass with the event\n         */\n        trigger : function (ev, data) {\n            if(!data) {\n                data = {};\n            }\n            data.instance = this;\n            this.element.triggerHandler(ev.replace('.jstree','') + '.jstree', data);\n        },\n        /**\n         * returns the jQuery extended instance container\n         * @name get_container()\n         * @return {jQuery}\n         */\n        get_container : function () {\n            return this.element;\n        },\n        /**\n         * returns the jQuery extended main UL node inside the instance container. Used internally.\n         * @private\n         * @name get_container_ul()\n         * @return {jQuery}\n         */\n        get_container_ul : function () {\n            return this.element.children(\".jstree-children\").first();\n        },\n        /**\n         * gets string replacements (localization). Used internally.\n         * @private\n         * @name get_string(key)\n         * @param  {String} key\n         * @return {String}\n         */\n        get_string : function (key) {\n            var a = this.settings.core.strings;\n            if($.vakata.is_function(a)) { return a.call(this, key); }\n            if(a && a[key]) { return a[key]; }\n            return key;\n        },\n        /**\n         * gets the first child of a DOM node. Used internally.\n         * @private\n         * @name _firstChild(dom)\n         * @param  {DOMElement} dom\n         * @return {DOMElement}\n         */\n        _firstChild : function (dom) {\n            dom = dom ? dom.firstChild : null;\n            while(dom !== null && dom.nodeType !== 1) {\n                dom = dom.nextSibling;\n            }\n            return dom;\n        },\n        /**\n         * gets the next sibling of a DOM node. Used internally.\n         * @private\n         * @name _nextSibling(dom)\n         * @param  {DOMElement} dom\n         * @return {DOMElement}\n         */\n        _nextSibling : function (dom) {\n            dom = dom ? dom.nextSibling : null;\n            while(dom !== null && dom.nodeType !== 1) {\n                dom = dom.nextSibling;\n            }\n            return dom;\n        },\n        /**\n         * gets the previous sibling of a DOM node. Used internally.\n         * @private\n         * @name _previousSibling(dom)\n         * @param  {DOMElement} dom\n         * @return {DOMElement}\n         */\n        _previousSibling : function (dom) {\n            dom = dom ? dom.previousSibling : null;\n            while(dom !== null && dom.nodeType !== 1) {\n                dom = dom.previousSibling;\n            }\n            return dom;\n        },\n        /**\n         * get the JSON representation of a node (or the actual jQuery extended DOM node) by using any input (child DOM element, ID string, selector, etc)\n         * @name get_node(obj [, as_dom])\n         * @param  {mixed} obj\n         * @param  {Boolean} as_dom\n         * @return {Object|jQuery}\n         */\n        get_node : function (obj, as_dom) {\n            if(obj && obj.id) {\n                obj = obj.id;\n            }\n            if (obj instanceof $ && obj.length && obj[0].id) {\n                obj = obj[0].id;\n            }\n            var dom;\n            try {\n                if(this._model.data[obj]) {\n                    obj = this._model.data[obj];\n                }\n                else if(typeof obj === \"string\" && this._model.data[obj.replace(/^#/, '')]) {\n                    obj = this._model.data[obj.replace(/^#/, '')];\n                }\n                else if(typeof obj === \"string\" && (dom = $('#' + obj.replace($.jstree.idregex,'\\\\$&'), this.element)).length && this._model.data[dom.closest('.jstree-node').attr('id')]) {\n                    obj = this._model.data[dom.closest('.jstree-node').attr('id')];\n                }\n                else if((dom = this.element.find(obj)).length && this._model.data[dom.closest('.jstree-node').attr('id')]) {\n                    obj = this._model.data[dom.closest('.jstree-node').attr('id')];\n                }\n                else if((dom = this.element.find(obj)).length && dom.hasClass('jstree')) {\n                    obj = this._model.data[$.jstree.root];\n                }\n                else {\n                    return false;\n                }\n\n                if(as_dom) {\n                    obj = obj.id === $.jstree.root ? this.element : $('#' + obj.id.replace($.jstree.idregex,'\\\\$&'), this.element);\n                }\n                return obj;\n            } catch (ex) { return false; }\n        },\n        /**\n         * get the path to a node, either consisting of node texts, or of node IDs, optionally glued together (otherwise an array)\n         * @name get_path(obj [, glue, ids])\n         * @param  {mixed} obj the node\n         * @param  {String} glue if you want the path as a string - pass the glue here (for example '/'), if a falsy value is supplied here, an array is returned\n         * @param  {Boolean} ids if set to true build the path using ID, otherwise node text is used\n         * @return {mixed}\n         */\n        get_path : function (obj, glue, ids) {\n            obj = obj.parents ? obj : this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root || !obj.parents) {\n                return false;\n            }\n            var i, j, p = [];\n            p.push(ids ? obj.id : obj.text);\n            for(i = 0, j = obj.parents.length; i < j; i++) {\n                p.push(ids ? obj.parents[i] : this.get_text(obj.parents[i]));\n            }\n            p = p.reverse().slice(1);\n            return glue ? p.join(glue) : p;\n        },\n        /**\n         * get the next visible node that is below the `obj` node. If `strict` is set to `true` only sibling nodes are returned.\n         * @name get_next_dom(obj [, strict])\n         * @param  {mixed} obj\n         * @param  {Boolean} strict\n         * @return {jQuery}\n         */\n        get_next_dom : function (obj, strict) {\n            var tmp;\n            obj = this.get_node(obj, true);\n            if(obj[0] === this.element[0]) {\n                tmp = this._firstChild(this.get_container_ul()[0]);\n                while (tmp && tmp.offsetHeight === 0) {\n                    tmp = this._nextSibling(tmp);\n                }\n                return tmp ? $(tmp) : false;\n            }\n            if(!obj || !obj.length) {\n                return false;\n            }\n            if(strict) {\n                tmp = obj[0];\n                do {\n                    tmp = this._nextSibling(tmp);\n                } while (tmp && tmp.offsetHeight === 0);\n                return tmp ? $(tmp) : false;\n            }\n            if(obj.hasClass(\"jstree-open\")) {\n                tmp = this._firstChild(obj.children('.jstree-children')[0]);\n                while (tmp && tmp.offsetHeight === 0) {\n                    tmp = this._nextSibling(tmp);\n                }\n                if(tmp !== null) {\n                    return $(tmp);\n                }\n            }\n            tmp = obj[0];\n            do {\n                tmp = this._nextSibling(tmp);\n            } while (tmp && tmp.offsetHeight === 0);\n            if(tmp !== null) {\n                return $(tmp);\n            }\n            return obj.parentsUntil(\".jstree\",\".jstree-node\").nextAll(\".jstree-node:visible\").first();\n        },\n        /**\n         * get the previous visible node that is above the `obj` node. If `strict` is set to `true` only sibling nodes are returned.\n         * @name get_prev_dom(obj [, strict])\n         * @param  {mixed} obj\n         * @param  {Boolean} strict\n         * @return {jQuery}\n         */\n        get_prev_dom : function (obj, strict) {\n            var tmp;\n            obj = this.get_node(obj, true);\n            if(obj[0] === this.element[0]) {\n                tmp = this.get_container_ul()[0].lastChild;\n                while (tmp && tmp.offsetHeight === 0) {\n                    tmp = this._previousSibling(tmp);\n                }\n                return tmp ? $(tmp) : false;\n            }\n            if(!obj || !obj.length) {\n                return false;\n            }\n            if(strict) {\n                tmp = obj[0];\n                do {\n                    tmp = this._previousSibling(tmp);\n                } while (tmp && tmp.offsetHeight === 0);\n                return tmp ? $(tmp) : false;\n            }\n            tmp = obj[0];\n            do {\n                tmp = this._previousSibling(tmp);\n            } while (tmp && tmp.offsetHeight === 0);\n            if(tmp !== null) {\n                obj = $(tmp);\n                while(obj.hasClass(\"jstree-open\")) {\n                    obj = obj.children(\".jstree-children\").first().children(\".jstree-node:visible:last\");\n                }\n                return obj;\n            }\n            tmp = obj[0].parentNode.parentNode;\n            return tmp && tmp.className && tmp.className.indexOf('jstree-node') !== -1 ? $(tmp) : false;\n        },\n        /**\n         * get the parent ID of a node\n         * @name get_parent(obj)\n         * @param  {mixed} obj\n         * @return {String}\n         */\n        get_parent : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            return obj.parent;\n        },\n        /**\n         * get a jQuery collection of all the children of a node (node must be rendered), returns false on error\n         * @name get_children_dom(obj)\n         * @param  {mixed} obj\n         * @return {jQuery}\n         */\n        get_children_dom : function (obj) {\n            obj = this.get_node(obj, true);\n            if(obj[0] === this.element[0]) {\n                return this.get_container_ul().children(\".jstree-node\");\n            }\n            if(!obj || !obj.length) {\n                return false;\n            }\n            return obj.children(\".jstree-children\").children(\".jstree-node\");\n        },\n        /**\n         * checks if a node has children\n         * @name is_parent(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_parent : function (obj) {\n            obj = this.get_node(obj);\n            return obj && (obj.state.loaded === false || obj.children.length > 0);\n        },\n        /**\n         * checks if a node is loaded (its children are available)\n         * @name is_loaded(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_loaded : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state.loaded;\n        },\n        /**\n         * check if a node is currently loading (fetching children)\n         * @name is_loading(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_loading : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state && obj.state.loading;\n        },\n        /**\n         * check if a node is opened\n         * @name is_open(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_open : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state.opened;\n        },\n        /**\n         * check if a node is in a closed state\n         * @name is_closed(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_closed : function (obj) {\n            obj = this.get_node(obj);\n            return obj && this.is_parent(obj) && !obj.state.opened;\n        },\n        /**\n         * check if a node has no children\n         * @name is_leaf(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_leaf : function (obj) {\n            return !this.is_parent(obj);\n        },\n        /**\n         * loads a node (fetches its children using the `core.data` setting). Multiple nodes can be passed to by using an array.\n         * @name load_node(obj [, callback])\n         * @param  {mixed} obj\n         * @param  {function} callback a function to be executed once loading is complete, the function is executed in the instance's scope and receives two arguments - the node and a boolean status\n         * @return {Boolean}\n         * @trigger load_node.jstree\n         */\n        load_node : function (obj, callback) {\n            var k, l, i, j, c;\n            if($.vakata.is_array(obj)) {\n                this._load_nodes(obj.slice(), callback);\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj) {\n                if(callback) { callback.call(this, obj, false); }\n                return false;\n            }\n            // if(obj.state.loading) { } // the node is already loading - just wait for it to load and invoke callback? but if called implicitly it should be loaded again?\n            if(obj.state.loaded) {\n                obj.state.loaded = false;\n                for(i = 0, j = obj.parents.length; i < j; i++) {\n                    this._model.data[obj.parents[i]].children_d = $.vakata.array_filter(this._model.data[obj.parents[i]].children_d, function (v) {\n                        return $.inArray(v, obj.children_d) === -1;\n                    });\n                }\n                for(k = 0, l = obj.children_d.length; k < l; k++) {\n                    if(this._model.data[obj.children_d[k]].state.selected) {\n                        c = true;\n                    }\n                    delete this._model.data[obj.children_d[k]];\n                }\n                if (c) {\n                    this._data.core.selected = $.vakata.array_filter(this._data.core.selected, function (v) {\n                        return $.inArray(v, obj.children_d) === -1;\n                    });\n                }\n                obj.children = [];\n                obj.children_d = [];\n                if(c) {\n                    this.trigger('changed', { 'action' : 'load_node', 'node' : obj, 'selected' : this._data.core.selected });\n                }\n            }\n            obj.state.failed = false;\n            obj.state.loading = true;\n            this.get_node(obj, true).addClass(\"jstree-loading\").attr('aria-busy',true);\n            this._load_node(obj, function (status) {\n                obj = this._model.data[obj.id];\n                obj.state.loading = false;\n                obj.state.loaded = status;\n                obj.state.failed = !obj.state.loaded;\n                var dom = this.get_node(obj, true), i = 0, j = 0, m = this._model.data, has_children = false;\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    if(m[obj.children[i]] && !m[obj.children[i]].state.hidden) {\n                        has_children = true;\n                        break;\n                    }\n                }\n                if(obj.state.loaded && dom && dom.length) {\n                    dom.removeClass('jstree-closed jstree-open jstree-leaf');\n                    if (!has_children) {\n                        dom.addClass('jstree-leaf');\n                    }\n                    else {\n                        if (obj.id !== '#') {\n                            dom.addClass(obj.state.opened ? 'jstree-open' : 'jstree-closed');\n                        }\n                    }\n                }\n                dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                /**\n                 * triggered after a node is loaded\n                 * @event\n                 * @name load_node.jstree\n                 * @param {Object} node the node that was loading\n                 * @param {Boolean} status was the node loaded successfully\n                 */\n                this.trigger('load_node', { \"node\" : obj, \"status\" : status });\n                if(callback) {\n                    callback.call(this, obj, status);\n                }\n            }.bind(this));\n            return true;\n        },\n        /**\n         * load an array of nodes (will also load unavailable nodes as soon as they appear in the structure). Used internally.\n         * @private\n         * @name _load_nodes(nodes [, callback])\n         * @param  {array} nodes\n         * @param  {function} callback a function to be executed once loading is complete, the function is executed in the instance's scope and receives one argument - the array passed to _load_nodes\n         */\n        _load_nodes : function (nodes, callback, is_callback, force_reload) {\n            var r = true,\n                c = function () { this._load_nodes(nodes, callback, true); },\n                m = this._model.data, i, j, tmp = [];\n            for(i = 0, j = nodes.length; i < j; i++) {\n                if(m[nodes[i]] && ( (!m[nodes[i]].state.loaded && !m[nodes[i]].state.failed) || (!is_callback && force_reload) )) {\n                    if(!this.is_loading(nodes[i])) {\n                        this.load_node(nodes[i], c);\n                    }\n                    r = false;\n                }\n            }\n            if(r) {\n                for(i = 0, j = nodes.length; i < j; i++) {\n                    if(m[nodes[i]] && m[nodes[i]].state.loaded) {\n                        tmp.push(nodes[i]);\n                    }\n                }\n                if(callback && !callback.done) {\n                    callback.call(this, tmp);\n                    callback.done = true;\n                }\n            }\n        },\n        /**\n         * loads all unloaded nodes\n         * @name load_all([obj, callback])\n         * @param {mixed} obj the node to load recursively, omit to load all nodes in the tree\n         * @param {function} callback a function to be executed once loading all the nodes is complete,\n         * @trigger load_all.jstree\n         */\n        load_all : function (obj, callback) {\n            if(!obj) { obj = $.jstree.root; }\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var to_load = [],\n                m = this._model.data,\n                c = m[obj.id].children_d,\n                i, j;\n            if(obj.state && !obj.state.loaded) {\n                to_load.push(obj.id);\n            }\n            for(i = 0, j = c.length; i < j; i++) {\n                if(m[c[i]] && m[c[i]].state && !m[c[i]].state.loaded) {\n                    to_load.push(c[i]);\n                }\n            }\n            if(to_load.length) {\n                this._load_nodes(to_load, function () {\n                    this.load_all(obj, callback);\n                });\n            }\n            else {\n                /**\n                 * triggered after a load_all call completes\n                 * @event\n                 * @name load_all.jstree\n                 * @param {Object} node the recursively loaded node\n                 */\n                if(callback) { callback.call(this, obj); }\n                this.trigger('load_all', { \"node\" : obj });\n            }\n        },\n        /**\n         * handles the actual loading of a node. Used only internally.\n         * @private\n         * @name _load_node(obj [, callback])\n         * @param  {mixed} obj\n         * @param  {function} callback a function to be executed once loading is complete, the function is executed in the instance's scope and receives one argument - a boolean status\n         * @return {Boolean}\n         */\n        _load_node : function (obj, callback) {\n            var s = this.settings.core.data, t;\n            var notTextOrCommentNode = function notTextOrCommentNode () {\n                return this.nodeType !== 3 && this.nodeType !== 8;\n            };\n            // use original HTML\n            if(!s) {\n                if(obj.id === $.jstree.root) {\n                    return this._append_html_data(obj, this._data.core.original_container_html.clone(true), function (status) {\n                        callback.call(this, status);\n                    });\n                }\n                else {\n                    return callback.call(this, false);\n                }\n                // return callback.call(this, obj.id === $.jstree.root ? this._append_html_data(obj, this._data.core.original_container_html.clone(true)) : false);\n            }\n            if($.vakata.is_function(s)) {\n                return s.call(this, obj, function (d) {\n                    if(d === false) {\n                        callback.call(this, false);\n                    }\n                    else {\n                        this[typeof d === 'string' ? '_append_html_data' : '_append_json_data'](obj, typeof d === 'string' ? $($.parseHTML(d)).filter(notTextOrCommentNode) : d, function (status) {\n                            callback.call(this, status);\n                        });\n                    }\n                    // return d === false ? callback.call(this, false) : callback.call(this, this[typeof d === 'string' ? '_append_html_data' : '_append_json_data'](obj, typeof d === 'string' ? $(d) : d));\n                }.bind(this));\n            }\n            if(typeof s === 'object') {\n                if(s.url) {\n                    s = $.extend(true, {}, s);\n                    if($.vakata.is_function(s.url)) {\n                        s.url = s.url.call(this, obj);\n                    }\n                    if($.vakata.is_function(s.data)) {\n                        s.data = s.data.call(this, obj);\n                    }\n                    return $.ajax(s)\n                        .done(function (d,t,x) {\n                            var type = x.getResponseHeader('Content-Type');\n                            if((type && type.indexOf('json') !== -1) || typeof d === \"object\") {\n                                return this._append_json_data(obj, d, function (status) { callback.call(this, status); });\n                                //return callback.call(this, this._append_json_data(obj, d));\n                            }\n                            if((type && type.indexOf('html') !== -1) || typeof d === \"string\") {\n                                return this._append_html_data(obj, $($.parseHTML(d)).filter(notTextOrCommentNode), function (status) { callback.call(this, status); });\n                                // return callback.call(this, this._append_html_data(obj, $(d)));\n                            }\n                            this._data.core.last_error = { 'error' : 'ajax', 'plugin' : 'core', 'id' : 'core_04', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id, 'xhr' : x }) };\n                            this.settings.core.error.call(this, this._data.core.last_error);\n                            return callback.call(this, false);\n                        }.bind(this))\n                        .fail(function (f) {\n                            this._data.core.last_error = { 'error' : 'ajax', 'plugin' : 'core', 'id' : 'core_04', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id, 'xhr' : f }) };\n                            callback.call(this, false);\n                            this.settings.core.error.call(this, this._data.core.last_error);\n                        }.bind(this));\n                }\n                if ($.vakata.is_array(s)) {\n                    t = $.extend(true, [], s);\n                } else if ($.isPlainObject(s)) {\n                    t = $.extend(true, {}, s);\n                } else {\n                    t = s;\n                }\n                if(obj.id === $.jstree.root) {\n                    return this._append_json_data(obj, t, function (status) {\n                        callback.call(this, status);\n                    });\n                }\n                else {\n                    this._data.core.last_error = { 'error' : 'nodata', 'plugin' : 'core', 'id' : 'core_05', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id }) };\n                    this.settings.core.error.call(this, this._data.core.last_error);\n                    return callback.call(this, false);\n                }\n                //return callback.call(this, (obj.id === $.jstree.root ? this._append_json_data(obj, t) : false) );\n            }\n            if(typeof s === 'string') {\n                if(obj.id === $.jstree.root) {\n                    return this._append_html_data(obj, $($.parseHTML(s)).filter(notTextOrCommentNode), function (status) {\n                        callback.call(this, status);\n                    });\n                }\n                else {\n                    this._data.core.last_error = { 'error' : 'nodata', 'plugin' : 'core', 'id' : 'core_06', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id }) };\n                    this.settings.core.error.call(this, this._data.core.last_error);\n                    return callback.call(this, false);\n                }\n                //return callback.call(this, (obj.id === $.jstree.root ? this._append_html_data(obj, $(s)) : false) );\n            }\n            return callback.call(this, false);\n        },\n        /**\n         * adds a node to the list of nodes to redraw. Used only internally.\n         * @private\n         * @name _node_changed(obj [, callback])\n         * @param  {mixed} obj\n         */\n        _node_changed : function (obj) {\n            obj = this.get_node(obj);\n            if (obj && $.inArray(obj.id, this._model.changed) === -1) {\n                this._model.changed.push(obj.id);\n            }\n        },\n        /**\n         * appends HTML content to the tree. Used internally.\n         * @private\n         * @name _append_html_data(obj, data)\n         * @param  {mixed} obj the node to append to\n         * @param  {String} data the HTML string to parse and append\n         * @trigger model.jstree, changed.jstree\n         */\n        _append_html_data : function (dom, data, cb) {\n            dom = this.get_node(dom);\n            dom.children = [];\n            dom.children_d = [];\n            var dat = data.is('ul') ? data.children() : data,\n                par = dom.id,\n                chd = [],\n                dpc = [],\n                m = this._model.data,\n                p = m[par],\n                s = this._data.core.selected.length,\n                tmp, i, j;\n            dat.each(function (i, v) {\n                tmp = this._parse_model_from_html($(v), par, p.parents.concat());\n                if(tmp) {\n                    chd.push(tmp);\n                    dpc.push(tmp);\n                    if(m[tmp].children_d.length) {\n                        dpc = dpc.concat(m[tmp].children_d);\n                    }\n                }\n            }.bind(this));\n            p.children = chd;\n            p.children_d = dpc;\n            for(i = 0, j = p.parents.length; i < j; i++) {\n                m[p.parents[i]].children_d = m[p.parents[i]].children_d.concat(dpc);\n            }\n            /**\n             * triggered when new data is inserted to the tree model\n             * @event\n             * @name model.jstree\n             * @param {Array} nodes an array of node IDs\n             * @param {String} parent the parent ID of the nodes\n             */\n            this.trigger('model', { \"nodes\" : dpc, 'parent' : par });\n            if(par !== $.jstree.root) {\n                this._node_changed(par);\n                this.redraw();\n            }\n            else {\n                this.get_container_ul().children('.jstree-initial-node').remove();\n                this.redraw(true);\n            }\n            if(this._data.core.selected.length !== s) {\n                this.trigger('changed', { 'action' : 'model', 'selected' : this._data.core.selected });\n            }\n            cb.call(this, true);\n        },\n        /**\n         * appends JSON content to the tree. Used internally.\n         * @private\n         * @name _append_json_data(obj, data)\n         * @param  {mixed} obj the node to append to\n         * @param  {String} data the JSON object to parse and append\n         * @param  {Boolean} force_processing internal param - do not set\n         * @trigger model.jstree, changed.jstree\n         */\n        _append_json_data : function (dom, data, cb, force_processing) {\n            if(this.element === null) { return; }\n            dom = this.get_node(dom);\n            dom.children = [];\n            dom.children_d = [];\n            // *%$@!!!\n            if(data.d) {\n                data = data.d;\n                if(typeof data === \"string\") {\n                    data = JSON.parse(data);\n                }\n            }\n            if(!$.vakata.is_array(data)) { data = [data]; }\n            var w = null,\n                args = {\n                    'df'\t: this._model.default_state,\n                    'dat'\t: data,\n                    'par'\t: dom.id,\n                    'm'\t\t: this._model.data,\n                    't_id'\t: this._id,\n                    't_cnt'\t: this._cnt,\n                    'sel'\t: this._data.core.selected\n                },\n                inst = this,\n                func = function (data, undefined) {\n                    if(data.data) { data = data.data; }\n                    var dat = data.dat,\n                        par = data.par,\n                        chd = [],\n                        dpc = [],\n                        add = [],\n                        df = data.df,\n                        t_id = data.t_id,\n                        t_cnt = data.t_cnt,\n                        m = data.m,\n                        p = m[par],\n                        sel = data.sel,\n                        tmp, i, j, rslt,\n                        parse_flat = function (d, p, ps) {\n                            if(!ps) { ps = []; }\n                            else { ps = ps.concat(); }\n                            if(p) { ps.unshift(p); }\n                            var tid = d.id.toString(),\n                                i, j, c, e,\n                                tmp = {\n                                    id\t\t\t: tid,\n                                    text\t\t: d.text || '',\n                                    icon\t\t: d.icon !== undefined ? d.icon : true,\n                                    parent\t\t: p,\n                                    parents\t\t: ps,\n                                    children\t: d.children || [],\n                                    children_d\t: d.children_d || [],\n                                    data\t\t: d.data,\n                                    state\t\t: { },\n                                    li_attr\t\t: { id : false },\n                                    a_attr\t\t: { href : '#' },\n                                    original\t: false\n                                };\n                            for(i in df) {\n                                if(df.hasOwnProperty(i)) {\n                                    tmp.state[i] = df[i];\n                                }\n                            }\n                            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                                tmp.icon = d.data.jstree.icon;\n                            }\n                            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                                tmp.icon = true;\n                            }\n                            if(d && d.data) {\n                                tmp.data = d.data;\n                                if(d.data.jstree) {\n                                    for(i in d.data.jstree) {\n                                        if(d.data.jstree.hasOwnProperty(i)) {\n                                            tmp.state[i] = d.data.jstree[i];\n                                        }\n                                    }\n                                }\n                            }\n                            if(d && typeof d.state === 'object') {\n                                for (i in d.state) {\n                                    if(d.state.hasOwnProperty(i)) {\n                                        tmp.state[i] = d.state[i];\n                                    }\n                                }\n                            }\n                            if(d && typeof d.li_attr === 'object') {\n                                for (i in d.li_attr) {\n                                    if(d.li_attr.hasOwnProperty(i)) {\n                                        tmp.li_attr[i] = d.li_attr[i];\n                                    }\n                                }\n                            }\n                            if(!tmp.li_attr.id) {\n                                tmp.li_attr.id = tid;\n                            }\n                            if(d && typeof d.a_attr === 'object') {\n                                for (i in d.a_attr) {\n                                    if(d.a_attr.hasOwnProperty(i)) {\n                                        tmp.a_attr[i] = d.a_attr[i];\n                                    }\n                                }\n                            }\n                            if(d && d.children && d.children === true) {\n                                tmp.state.loaded = false;\n                                tmp.children = [];\n                                tmp.children_d = [];\n                            }\n                            m[tmp.id] = tmp;\n                            for(i = 0, j = tmp.children.length; i < j; i++) {\n                                c = parse_flat(m[tmp.children[i]], tmp.id, ps);\n                                e = m[c];\n                                tmp.children_d.push(c);\n                                if(e.children_d.length) {\n                                    tmp.children_d = tmp.children_d.concat(e.children_d);\n                                }\n                            }\n                            delete d.data;\n                            delete d.children;\n                            m[tmp.id].original = d;\n                            if(tmp.state.selected) {\n                                add.push(tmp.id);\n                            }\n                            return tmp.id;\n                        },\n                        parse_nest = function (d, p, ps) {\n                            if(!ps) { ps = []; }\n                            else { ps = ps.concat(); }\n                            if(p) { ps.unshift(p); }\n                            var tid = false, i, j, c, e, tmp;\n                            do {\n                                tid = 'j' + t_id + '_' + (++t_cnt);\n                            } while(m[tid]);\n\n                            tmp = {\n                                id\t\t\t: false,\n                                text\t\t: typeof d === 'string' ? d : '',\n                                icon\t\t: typeof d === 'object' && d.icon !== undefined ? d.icon : true,\n                                parent\t\t: p,\n                                parents\t\t: ps,\n                                children\t: [],\n                                children_d\t: [],\n                                data\t\t: null,\n                                state\t\t: { },\n                                li_attr\t\t: { id : false },\n                                a_attr\t\t: { href : '#' },\n                                original\t: false\n                            };\n                            for(i in df) {\n                                if(df.hasOwnProperty(i)) {\n                                    tmp.state[i] = df[i];\n                                }\n                            }\n                            if(d && d.id) { tmp.id = d.id.toString(); }\n                            if(d && d.text) { tmp.text = d.text; }\n                            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                                tmp.icon = d.data.jstree.icon;\n                            }\n                            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                                tmp.icon = true;\n                            }\n                            if(d && d.data) {\n                                tmp.data = d.data;\n                                if(d.data.jstree) {\n                                    for(i in d.data.jstree) {\n                                        if(d.data.jstree.hasOwnProperty(i)) {\n                                            tmp.state[i] = d.data.jstree[i];\n                                        }\n                                    }\n                                }\n                            }\n                            if(d && typeof d.state === 'object') {\n                                for (i in d.state) {\n                                    if(d.state.hasOwnProperty(i)) {\n                                        tmp.state[i] = d.state[i];\n                                    }\n                                }\n                            }\n                            if(d && typeof d.li_attr === 'object') {\n                                for (i in d.li_attr) {\n                                    if(d.li_attr.hasOwnProperty(i)) {\n                                        tmp.li_attr[i] = d.li_attr[i];\n                                    }\n                                }\n                            }\n                            if(tmp.li_attr.id && !tmp.id) {\n                                tmp.id = tmp.li_attr.id.toString();\n                            }\n                            if(!tmp.id) {\n                                tmp.id = tid;\n                            }\n                            if(!tmp.li_attr.id) {\n                                tmp.li_attr.id = tmp.id;\n                            }\n                            if(d && typeof d.a_attr === 'object') {\n                                for (i in d.a_attr) {\n                                    if(d.a_attr.hasOwnProperty(i)) {\n                                        tmp.a_attr[i] = d.a_attr[i];\n                                    }\n                                }\n                            }\n                            if(d && d.children && d.children.length) {\n                                for(i = 0, j = d.children.length; i < j; i++) {\n                                    c = parse_nest(d.children[i], tmp.id, ps);\n                                    e = m[c];\n                                    tmp.children.push(c);\n                                    if(e.children_d.length) {\n                                        tmp.children_d = tmp.children_d.concat(e.children_d);\n                                    }\n                                }\n                                tmp.children_d = tmp.children_d.concat(tmp.children);\n                            }\n                            if(d && d.children && d.children === true) {\n                                tmp.state.loaded = false;\n                                tmp.children = [];\n                                tmp.children_d = [];\n                            }\n                            delete d.data;\n                            delete d.children;\n                            tmp.original = d;\n                            m[tmp.id] = tmp;\n                            if(tmp.state.selected) {\n                                add.push(tmp.id);\n                            }\n                            return tmp.id;\n                        };\n\n                    if(dat.length && dat[0].id !== undefined && dat[0].parent !== undefined) {\n                        // Flat JSON support (for easy import from DB):\n                        // 1) convert to object (foreach)\n                        for(i = 0, j = dat.length; i < j; i++) {\n                            if(!dat[i].children) {\n                                dat[i].children = [];\n                            }\n                            if(!dat[i].state) {\n                                dat[i].state = {};\n                            }\n                            m[dat[i].id.toString()] = dat[i];\n                        }\n                        // 2) populate children (foreach)\n                        for(i = 0, j = dat.length; i < j; i++) {\n                            if (!m[dat[i].parent.toString()]) {\n                                if (typeof inst !== \"undefined\") {\n                                    inst._data.core.last_error = { 'error' : 'parse', 'plugin' : 'core', 'id' : 'core_07', 'reason' : 'Node with invalid parent', 'data' : JSON.stringify({ 'id' : dat[i].id.toString(), 'parent' : dat[i].parent.toString() }) };\n                                    inst.settings.core.error.call(inst, inst._data.core.last_error);\n                                }\n                                continue;\n                            }\n\n                            m[dat[i].parent.toString()].children.push(dat[i].id.toString());\n                            // populate parent.children_d\n                            p.children_d.push(dat[i].id.toString());\n                        }\n                        // 3) normalize && populate parents and children_d with recursion\n                        for(i = 0, j = p.children.length; i < j; i++) {\n                            tmp = parse_flat(m[p.children[i]], par, p.parents.concat());\n                            dpc.push(tmp);\n                            if(m[tmp].children_d.length) {\n                                dpc = dpc.concat(m[tmp].children_d);\n                            }\n                        }\n                        for(i = 0, j = p.parents.length; i < j; i++) {\n                            m[p.parents[i]].children_d = m[p.parents[i]].children_d.concat(dpc);\n                        }\n                        // ?) three_state selection - p.state.selected && t - (if three_state foreach(dat => ch) -> foreach(parents) if(parent.selected) child.selected = true;\n                        rslt = {\n                            'cnt' : t_cnt,\n                            'mod' : m,\n                            'sel' : sel,\n                            'par' : par,\n                            'dpc' : dpc,\n                            'add' : add\n                        };\n                    }\n                    else {\n                        for(i = 0, j = dat.length; i < j; i++) {\n                            tmp = parse_nest(dat[i], par, p.parents.concat());\n                            if(tmp) {\n                                chd.push(tmp);\n                                dpc.push(tmp);\n                                if(m[tmp].children_d.length) {\n                                    dpc = dpc.concat(m[tmp].children_d);\n                                }\n                            }\n                        }\n                        p.children = chd;\n                        p.children_d = dpc;\n                        for(i = 0, j = p.parents.length; i < j; i++) {\n                            m[p.parents[i]].children_d = m[p.parents[i]].children_d.concat(dpc);\n                        }\n                        rslt = {\n                            'cnt' : t_cnt,\n                            'mod' : m,\n                            'sel' : sel,\n                            'par' : par,\n                            'dpc' : dpc,\n                            'add' : add\n                        };\n                    }\n                    if(typeof window === 'undefined' || typeof window.document === 'undefined') {\n                        postMessage(rslt);\n                    }\n                    else {\n                        return rslt;\n                    }\n                },\n                rslt = function (rslt, worker) {\n                    if(this.element === null) { return; }\n                    this._cnt = rslt.cnt;\n                    var i, m = this._model.data;\n                    for (i in m) {\n                        if (m.hasOwnProperty(i) && m[i].state && m[i].state.loading && rslt.mod[i]) {\n                            rslt.mod[i].state.loading = true;\n                        }\n                    }\n                    this._model.data = rslt.mod; // breaks the reference in load_node - careful\n\n                    if(worker) {\n                        var j, a = rslt.add, r = rslt.sel, s = this._data.core.selected.slice();\n                        m = this._model.data;\n                        // if selection was changed while calculating in worker\n                        if(r.length !== s.length || $.vakata.array_unique(r.concat(s)).length !== r.length) {\n                            // deselect nodes that are no longer selected\n                            for(i = 0, j = r.length; i < j; i++) {\n                                if($.inArray(r[i], a) === -1 && $.inArray(r[i], s) === -1) {\n                                    m[r[i]].state.selected = false;\n                                }\n                            }\n                            // select nodes that were selected in the mean time\n                            for(i = 0, j = s.length; i < j; i++) {\n                                if($.inArray(s[i], r) === -1) {\n                                    m[s[i]].state.selected = true;\n                                }\n                            }\n                        }\n                    }\n                    if(rslt.add.length) {\n                        this._data.core.selected = this._data.core.selected.concat(rslt.add);\n                    }\n\n                    this.trigger('model', { \"nodes\" : rslt.dpc, 'parent' : rslt.par });\n\n                    if(rslt.par !== $.jstree.root) {\n                        this._node_changed(rslt.par);\n                        this.redraw();\n                    }\n                    else {\n                        // this.get_container_ul().children('.jstree-initial-node').remove();\n                        this.redraw(true);\n                    }\n                    if(rslt.add.length) {\n                        this.trigger('changed', { 'action' : 'model', 'selected' : this._data.core.selected });\n                    }\n\n                    // If no worker, try to mimic worker behavioour, by invoking cb asynchronously\n                    if (!worker && setImmediate) {\n                        setImmediate(function(){\n                            cb.call(inst, true);\n                        });\n                    }\n                    else {\n                        cb.call(inst, true);\n                    }\n                };\n            if(this.settings.core.worker && window.Blob && window.URL && window.Worker) {\n                try {\n                    if(this._wrk === null) {\n                        this._wrk = window.URL.createObjectURL(\n                            new window.Blob(\n                                ['self.onmessage = ' + func.toString()],\n                                {type:\"text/javascript\"}\n                            )\n                        );\n                    }\n                    if(!this._data.core.working || force_processing) {\n                        this._data.core.working = true;\n                        w = new window.Worker(this._wrk);\n                        w.onmessage = function (e) {\n                            rslt.call(this, e.data, true);\n                            try { w.terminate(); w = null; } catch(ignore) { }\n                            if(this._data.core.worker_queue.length) {\n                                this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                            }\n                            else {\n                                this._data.core.working = false;\n                            }\n                        }.bind(this);\n                        if(!args.par) {\n                            if(this._data.core.worker_queue.length) {\n                                this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                            }\n                            else {\n                                this._data.core.working = false;\n                            }\n                        }\n                        else {\n                            w.postMessage(args);\n                        }\n                    }\n                    else {\n                        this._data.core.worker_queue.push([dom, data, cb, true]);\n                    }\n                }\n                catch(e) {\n                    rslt.call(this, func(args), false);\n                    if(this._data.core.worker_queue.length) {\n                        this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                    }\n                    else {\n                        this._data.core.working = false;\n                    }\n                }\n            }\n            else {\n                rslt.call(this, func(args), false);\n            }\n        },\n        /**\n         * parses a node from a jQuery object and appends them to the in memory tree model. Used internally.\n         * @private\n         * @name _parse_model_from_html(d [, p, ps])\n         * @param  {jQuery} d the jQuery object to parse\n         * @param  {String} p the parent ID\n         * @param  {Array} ps list of all parents\n         * @return {String} the ID of the object added to the model\n         */\n        _parse_model_from_html : function (d, p, ps) {\n            if(!ps) { ps = []; }\n            else { ps = [].concat(ps); }\n            if(p) { ps.unshift(p); }\n            var c, e, m = this._model.data,\n                data = {\n                    id\t\t\t: false,\n                    text\t\t: false,\n                    icon\t\t: true,\n                    parent\t\t: p,\n                    parents\t\t: ps,\n                    children\t: [],\n                    children_d\t: [],\n                    data\t\t: null,\n                    state\t\t: { },\n                    li_attr\t\t: { id : false },\n                    a_attr\t\t: { href : '#' },\n                    original\t: false\n                }, i, tmp, tid;\n            for(i in this._model.default_state) {\n                if(this._model.default_state.hasOwnProperty(i)) {\n                    data.state[i] = this._model.default_state[i];\n                }\n            }\n            tmp = $.vakata.attributes(d, true);\n            $.each(tmp, function (i, v) {\n                v = $.vakata.trim(v);\n                if(!v.length) { return true; }\n                data.li_attr[i] = v;\n                if(i === 'id') {\n                    data.id = v.toString();\n                }\n            });\n            tmp = d.children('a').first();\n            if(tmp.length) {\n                tmp = $.vakata.attributes(tmp, true);\n                $.each(tmp, function (i, v) {\n                    v = $.vakata.trim(v);\n                    if(v.length) {\n                        data.a_attr[i] = v;\n                    }\n                });\n            }\n            tmp = d.children(\"a\").first().length ? d.children(\"a\").first().clone() : d.clone();\n            tmp.children(\"ins, i, ul\").remove();\n            tmp = tmp.html();\n            tmp = $('<div></div>').html(tmp);\n            data.text = this.settings.core.force_text ? tmp.text() : tmp.html();\n            tmp = d.data();\n            data.data = tmp ? $.extend(true, {}, tmp) : null;\n            data.state.opened = d.hasClass('jstree-open');\n            data.state.selected = d.children('a').hasClass('jstree-clicked');\n            data.state.disabled = d.children('a').hasClass('jstree-disabled');\n            if(data.data && data.data.jstree) {\n                for(i in data.data.jstree) {\n                    if(data.data.jstree.hasOwnProperty(i)) {\n                        data.state[i] = data.data.jstree[i];\n                    }\n                }\n            }\n            tmp = d.children(\"a\").children(\".jstree-themeicon\");\n            if(tmp.length) {\n                data.icon = tmp.hasClass('jstree-themeicon-hidden') ? false : tmp.attr('rel');\n            }\n            if(data.state.icon !== undefined) {\n                data.icon = data.state.icon;\n            }\n            if(data.icon === undefined || data.icon === null || data.icon === \"\") {\n                data.icon = true;\n            }\n            tmp = d.children(\"ul\").children(\"li\");\n            do {\n                tid = 'j' + this._id + '_' + (++this._cnt);\n            } while(m[tid]);\n            data.id = data.li_attr.id ? data.li_attr.id.toString() : tid;\n            if(tmp.length) {\n                tmp.each(function (i, v) {\n                    c = this._parse_model_from_html($(v), data.id, ps);\n                    e = this._model.data[c];\n                    data.children.push(c);\n                    if(e.children_d.length) {\n                        data.children_d = data.children_d.concat(e.children_d);\n                    }\n                }.bind(this));\n                data.children_d = data.children_d.concat(data.children);\n            }\n            else {\n                if(d.hasClass('jstree-closed')) {\n                    data.state.loaded = false;\n                }\n            }\n            if(data.li_attr['class']) {\n                data.li_attr['class'] = data.li_attr['class'].replace('jstree-closed','').replace('jstree-open','');\n            }\n            if(data.a_attr['class']) {\n                data.a_attr['class'] = data.a_attr['class'].replace('jstree-clicked','').replace('jstree-disabled','');\n            }\n            m[data.id] = data;\n            if(data.state.selected) {\n                this._data.core.selected.push(data.id);\n            }\n            return data.id;\n        },\n        /**\n         * parses a node from a JSON object (used when dealing with flat data, which has no nesting of children, but has id and parent properties) and appends it to the in memory tree model. Used internally.\n         * @private\n         * @name _parse_model_from_flat_json(d [, p, ps])\n         * @param  {Object} d the JSON object to parse\n         * @param  {String} p the parent ID\n         * @param  {Array} ps list of all parents\n         * @return {String} the ID of the object added to the model\n         */\n        _parse_model_from_flat_json : function (d, p, ps) {\n            if(!ps) { ps = []; }\n            else { ps = ps.concat(); }\n            if(p) { ps.unshift(p); }\n            var tid = d.id.toString(),\n                m = this._model.data,\n                df = this._model.default_state,\n                i, j, c, e,\n                tmp = {\n                    id\t\t\t: tid,\n                    text\t\t: d.text || '',\n                    icon\t\t: d.icon !== undefined ? d.icon : true,\n                    parent\t\t: p,\n                    parents\t\t: ps,\n                    children\t: d.children || [],\n                    children_d\t: d.children_d || [],\n                    data\t\t: d.data,\n                    state\t\t: { },\n                    li_attr\t\t: { id : false },\n                    a_attr\t\t: { href : '#' },\n                    original\t: false\n                };\n            for(i in df) {\n                if(df.hasOwnProperty(i)) {\n                    tmp.state[i] = df[i];\n                }\n            }\n            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                tmp.icon = d.data.jstree.icon;\n            }\n            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                tmp.icon = true;\n            }\n            if(d && d.data) {\n                tmp.data = d.data;\n                if(d.data.jstree) {\n                    for(i in d.data.jstree) {\n                        if(d.data.jstree.hasOwnProperty(i)) {\n                            tmp.state[i] = d.data.jstree[i];\n                        }\n                    }\n                }\n            }\n            if(d && typeof d.state === 'object') {\n                for (i in d.state) {\n                    if(d.state.hasOwnProperty(i)) {\n                        tmp.state[i] = d.state[i];\n                    }\n                }\n            }\n            if(d && typeof d.li_attr === 'object') {\n                for (i in d.li_attr) {\n                    if(d.li_attr.hasOwnProperty(i)) {\n                        tmp.li_attr[i] = d.li_attr[i];\n                    }\n                }\n            }\n            if(!tmp.li_attr.id) {\n                tmp.li_attr.id = tid;\n            }\n            if(d && typeof d.a_attr === 'object') {\n                for (i in d.a_attr) {\n                    if(d.a_attr.hasOwnProperty(i)) {\n                        tmp.a_attr[i] = d.a_attr[i];\n                    }\n                }\n            }\n            if(d && d.children && d.children === true) {\n                tmp.state.loaded = false;\n                tmp.children = [];\n                tmp.children_d = [];\n            }\n            m[tmp.id] = tmp;\n            for(i = 0, j = tmp.children.length; i < j; i++) {\n                c = this._parse_model_from_flat_json(m[tmp.children[i]], tmp.id, ps);\n                e = m[c];\n                tmp.children_d.push(c);\n                if(e.children_d.length) {\n                    tmp.children_d = tmp.children_d.concat(e.children_d);\n                }\n            }\n            delete d.data;\n            delete d.children;\n            m[tmp.id].original = d;\n            if(tmp.state.selected) {\n                this._data.core.selected.push(tmp.id);\n            }\n            return tmp.id;\n        },\n        /**\n         * parses a node from a JSON object and appends it to the in memory tree model. Used internally.\n         * @private\n         * @name _parse_model_from_json(d [, p, ps])\n         * @param  {Object} d the JSON object to parse\n         * @param  {String} p the parent ID\n         * @param  {Array} ps list of all parents\n         * @return {String} the ID of the object added to the model\n         */\n        _parse_model_from_json : function (d, p, ps) {\n            if(!ps) { ps = []; }\n            else { ps = ps.concat(); }\n            if(p) { ps.unshift(p); }\n            var tid = false, i, j, c, e, m = this._model.data, df = this._model.default_state, tmp;\n            do {\n                tid = 'j' + this._id + '_' + (++this._cnt);\n            } while(m[tid]);\n\n            tmp = {\n                id\t\t\t: false,\n                text\t\t: typeof d === 'string' ? d : '',\n                icon\t\t: typeof d === 'object' && d.icon !== undefined ? d.icon : true,\n                parent\t\t: p,\n                parents\t\t: ps,\n                children\t: [],\n                children_d\t: [],\n                data\t\t: null,\n                state\t\t: { },\n                li_attr\t\t: { id : false },\n                a_attr\t\t: { href : '#' },\n                original\t: false\n            };\n            for(i in df) {\n                if(df.hasOwnProperty(i)) {\n                    tmp.state[i] = df[i];\n                }\n            }\n            if(d && d.id) { tmp.id = d.id.toString(); }\n            if(d && d.text) { tmp.text = d.text; }\n            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                tmp.icon = d.data.jstree.icon;\n            }\n            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                tmp.icon = true;\n            }\n            if(d && d.data) {\n                tmp.data = d.data;\n                if(d.data.jstree) {\n                    for(i in d.data.jstree) {\n                        if(d.data.jstree.hasOwnProperty(i)) {\n                            tmp.state[i] = d.data.jstree[i];\n                        }\n                    }\n                }\n            }\n            if(d && typeof d.state === 'object') {\n                for (i in d.state) {\n                    if(d.state.hasOwnProperty(i)) {\n                        tmp.state[i] = d.state[i];\n                    }\n                }\n            }\n            if(d && typeof d.li_attr === 'object') {\n                for (i in d.li_attr) {\n                    if(d.li_attr.hasOwnProperty(i)) {\n                        tmp.li_attr[i] = d.li_attr[i];\n                    }\n                }\n            }\n            if(tmp.li_attr.id && !tmp.id) {\n                tmp.id = tmp.li_attr.id.toString();\n            }\n            if(!tmp.id) {\n                tmp.id = tid;\n            }\n            if(!tmp.li_attr.id) {\n                tmp.li_attr.id = tmp.id;\n            }\n            if(d && typeof d.a_attr === 'object') {\n                for (i in d.a_attr) {\n                    if(d.a_attr.hasOwnProperty(i)) {\n                        tmp.a_attr[i] = d.a_attr[i];\n                    }\n                }\n            }\n            if(d && d.children && d.children.length) {\n                for(i = 0, j = d.children.length; i < j; i++) {\n                    c = this._parse_model_from_json(d.children[i], tmp.id, ps);\n                    e = m[c];\n                    tmp.children.push(c);\n                    if(e.children_d.length) {\n                        tmp.children_d = tmp.children_d.concat(e.children_d);\n                    }\n                }\n                tmp.children_d = tmp.children.concat(tmp.children_d);\n            }\n            if(d && d.children && d.children === true) {\n                tmp.state.loaded = false;\n                tmp.children = [];\n                tmp.children_d = [];\n            }\n            delete d.data;\n            delete d.children;\n            tmp.original = d;\n            m[tmp.id] = tmp;\n            if(tmp.state.selected) {\n                this._data.core.selected.push(tmp.id);\n            }\n            return tmp.id;\n        },\n        /**\n         * redraws all nodes that need to be redrawn. Used internally.\n         * @private\n         * @name _redraw()\n         * @trigger redraw.jstree\n         */\n        _redraw : function () {\n            var nodes = this._model.force_full_redraw ? this._model.data[$.jstree.root].children.concat([]) : this._model.changed.concat([]),\n                f = document.createElement('UL'), tmp, i, j, fe = this._data.core.focused;\n            for(i = 0, j = nodes.length; i < j; i++) {\n                tmp = this.redraw_node(nodes[i], true, this._model.force_full_redraw);\n                if(tmp && this._model.force_full_redraw) {\n                    f.appendChild(tmp);\n                }\n            }\n            if(this._model.force_full_redraw) {\n                f.className = this.get_container_ul()[0].className;\n                f.setAttribute('role','group');\n                this.element.empty().append(f);\n                //this.get_container_ul()[0].appendChild(f);\n            }\n            if(fe !== null && this.settings.core.restore_focus) {\n                tmp = this.get_node(fe, true);\n                if(tmp && tmp.length && tmp.children('.jstree-anchor')[0] !== document.activeElement) {\n                    tmp.children('.jstree-anchor').trigger('focus');\n                }\n                else {\n                    this._data.core.focused = null;\n                }\n            }\n            this._model.force_full_redraw = false;\n            this._model.changed = [];\n            /**\n             * triggered after nodes are redrawn\n             * @event\n             * @name redraw.jstree\n             * @param {array} nodes the redrawn nodes\n             */\n            this.trigger('redraw', { \"nodes\" : nodes });\n        },\n        /**\n         * redraws all nodes that need to be redrawn or optionally - the whole tree\n         * @name redraw([full])\n         * @param {Boolean} full if set to `true` all nodes are redrawn.\n         */\n        redraw : function (full) {\n            if(full) {\n                this._model.force_full_redraw = true;\n            }\n            //if(this._model.redraw_timeout) {\n            //\tclearTimeout(this._model.redraw_timeout);\n            //}\n            //this._model.redraw_timeout = setTimeout($.proxy(this._redraw, this),0);\n            this._redraw();\n        },\n        /**\n         * redraws a single node's children. Used internally.\n         * @private\n         * @name draw_children(node)\n         * @param {mixed} node the node whose children will be redrawn\n         */\n        draw_children : function (node) {\n            var obj = this.get_node(node),\n                i = false,\n                j = false,\n                k = false,\n                d = document;\n            if(!obj) { return false; }\n            if(obj.id === $.jstree.root) { return this.redraw(true); }\n            node = this.get_node(node, true);\n            if(!node || !node.length) { return false; } // TODO: quick toggle\n\n            node.children('.jstree-children').remove();\n            node = node[0];\n            if(obj.children.length && obj.state.loaded) {\n                k = d.createElement('UL');\n                k.setAttribute('role', 'group');\n                k.className = 'jstree-children';\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    k.appendChild(this.redraw_node(obj.children[i], true, true));\n                }\n                node.appendChild(k);\n            }\n        },\n        /**\n         * redraws a single node. Used internally.\n         * @private\n         * @name redraw_node(node, deep, is_callback, force_render)\n         * @param {mixed} node the node to redraw\n         * @param {Boolean} deep should child nodes be redrawn too\n         * @param {Boolean} is_callback is this a recursion call\n         * @param {Boolean} force_render should children of closed parents be drawn anyway\n         */\n        redraw_node : function (node, deep, is_callback, force_render) {\n            var obj = this.get_node(node),\n                par = false,\n                ind = false,\n                old = false,\n                i = false,\n                j = false,\n                k = false,\n                c = '',\n                d = document,\n                m = this._model.data,\n                f = false,\n                s = false,\n                tmp = null,\n                t = 0,\n                l = 0,\n                has_children = false,\n                last_sibling = false;\n            if(!obj) { return false; }\n            if(obj.id === $.jstree.root) {  return this.redraw(true); }\n            deep = deep || obj.children.length === 0;\n            node = !document.querySelector ? document.getElementById(obj.id) : this.element[0].querySelector('#' + (\"0123456789\".indexOf(obj.id[0]) !== -1 ? '\\\\3' + obj.id[0] + ' ' + obj.id.substr(1).replace($.jstree.idregex,'\\\\$&') : obj.id.replace($.jstree.idregex,'\\\\$&')) ); //, this.element);\n            if(!node) {\n                deep = true;\n                //node = d.createElement('LI');\n                if(!is_callback) {\n                    par = obj.parent !== $.jstree.root ? $('#' + obj.parent.replace($.jstree.idregex,'\\\\$&'), this.element)[0] : null;\n                    if(par !== null && (!par || !m[obj.parent].state.opened)) {\n                        return false;\n                    }\n                    ind = $.inArray(obj.id, par === null ? m[$.jstree.root].children : m[obj.parent].children);\n                }\n            }\n            else {\n                node = $(node);\n                if(!is_callback) {\n                    par = node.parent().parent()[0];\n                    if(par === this.element[0]) {\n                        par = null;\n                    }\n                    ind = node.index();\n                }\n                // m[obj.id].data = node.data(); // use only node's data, no need to touch jquery storage\n                if(!deep && obj.children.length && !node.children('.jstree-children').length) {\n                    deep = true;\n                }\n                if(!deep) {\n                    old = node.children('.jstree-children')[0];\n                }\n                f = node.children('.jstree-anchor')[0] === document.activeElement;\n                node.remove();\n                //node = d.createElement('LI');\n                //node = node[0];\n            }\n            node = this._data.core.node.cloneNode(true);\n            // node is DOM, deep is boolean\n\n            c = 'jstree-node ';\n            for(i in obj.li_attr) {\n                if(obj.li_attr.hasOwnProperty(i)) {\n                    if(i === 'id') { continue; }\n                    if(i !== 'class') {\n                        node.setAttribute(i, obj.li_attr[i]);\n                    }\n                    else {\n                        c += obj.li_attr[i];\n                    }\n                }\n            }\n            if(!obj.a_attr.id) {\n                obj.a_attr.id = obj.id + '_anchor';\n            }\n            node.childNodes[1].setAttribute('aria-selected', !!obj.state.selected);\n            node.childNodes[1].setAttribute('aria-level', obj.parents.length);\n            if(this.settings.core.compute_elements_positions) {\n                node.childNodes[1].setAttribute('aria-setsize', m[obj.parent].children.length);\n                node.childNodes[1].setAttribute('aria-posinset', m[obj.parent].children.indexOf(obj.id) + 1);\n            }\n            if(obj.state.disabled) {\n                node.childNodes[1].setAttribute('aria-disabled', true);\n            }\n\n            for(i = 0, j = obj.children.length; i < j; i++) {\n                if(!m[obj.children[i]].state.hidden) {\n                    has_children = true;\n                    break;\n                }\n            }\n            if(obj.parent !== null && m[obj.parent] && !obj.state.hidden) {\n                i = $.inArray(obj.id, m[obj.parent].children);\n                last_sibling = obj.id;\n                if(i !== -1) {\n                    i++;\n                    for(j = m[obj.parent].children.length; i < j; i++) {\n                        if(!m[m[obj.parent].children[i]].state.hidden) {\n                            last_sibling = m[obj.parent].children[i];\n                        }\n                        if(last_sibling !== obj.id) {\n                            break;\n                        }\n                    }\n                }\n            }\n\n            if(obj.state.hidden) {\n                c += ' jstree-hidden';\n            }\n            if (obj.state.loading) {\n                c += ' jstree-loading';\n            }\n            if(obj.state.loaded && !has_children) {\n                c += ' jstree-leaf';\n            }\n            else {\n                c += obj.state.opened && obj.state.loaded ? ' jstree-open' : ' jstree-closed';\n                node.childNodes[1].setAttribute('aria-expanded', (obj.state.opened && obj.state.loaded) );\n            }\n            if(last_sibling === obj.id) {\n                c += ' jstree-last';\n            }\n            node.id = obj.id;\n            node.className = c;\n            c = ( obj.state.selected ? ' jstree-clicked' : '') + ( obj.state.disabled ? ' jstree-disabled' : '');\n            for(j in obj.a_attr) {\n                if(obj.a_attr.hasOwnProperty(j)) {\n                    if(j === 'href' && obj.a_attr[j] === '#') { continue; }\n                    if(j !== 'class') {\n                        node.childNodes[1].setAttribute(j, obj.a_attr[j]);\n                    }\n                    else {\n                        c += ' ' + obj.a_attr[j];\n                    }\n                }\n            }\n            if(c.length) {\n                node.childNodes[1].className = 'jstree-anchor ' + c;\n            }\n            if((obj.icon && obj.icon !== true) || obj.icon === false) {\n                if(obj.icon === false) {\n                    node.childNodes[1].childNodes[0].className += ' jstree-themeicon-hidden';\n                }\n                else if(obj.icon.indexOf('/') === -1 && obj.icon.indexOf('.') === -1) {\n                    node.childNodes[1].childNodes[0].className += ' ' + obj.icon + ' jstree-themeicon-custom';\n                }\n                else {\n                    node.childNodes[1].childNodes[0].style.backgroundImage = 'url(\"'+obj.icon+'\")';\n                    node.childNodes[1].childNodes[0].style.backgroundPosition = 'center center';\n                    node.childNodes[1].childNodes[0].style.backgroundSize = 'auto';\n                    node.childNodes[1].childNodes[0].className += ' jstree-themeicon-custom';\n                }\n            }\n\n            if(this.settings.core.force_text) {\n                node.childNodes[1].appendChild(d.createTextNode(obj.text));\n            }\n            else {\n                node.childNodes[1].innerHTML += obj.text;\n            }\n\n\n            if(deep && obj.children.length && (obj.state.opened || force_render) && obj.state.loaded) {\n                k = d.createElement('UL');\n                k.setAttribute('role', 'group');\n                k.className = 'jstree-children';\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    k.appendChild(this.redraw_node(obj.children[i], deep, true));\n                }\n                node.appendChild(k);\n            }\n            if(old) {\n                node.appendChild(old);\n            }\n            if(!is_callback) {\n                // append back using par / ind\n                if(!par) {\n                    par = this.element[0];\n                }\n                for(i = 0, j = par.childNodes.length; i < j; i++) {\n                    if(par.childNodes[i] && par.childNodes[i].className && par.childNodes[i].className.indexOf('jstree-children') !== -1) {\n                        tmp = par.childNodes[i];\n                        break;\n                    }\n                }\n                if(!tmp) {\n                    tmp = d.createElement('UL');\n                    tmp.setAttribute('role', 'group');\n                    tmp.className = 'jstree-children';\n                    par.appendChild(tmp);\n                }\n                par = tmp;\n\n                if(ind < par.childNodes.length) {\n                    par.insertBefore(node, par.childNodes[ind]);\n                }\n                else {\n                    par.appendChild(node);\n                }\n                if(f) {\n                    t = this.element[0].scrollTop;\n                    l = this.element[0].scrollLeft;\n                    node.childNodes[1].focus();\n                    this.element[0].scrollTop = t;\n                    this.element[0].scrollLeft = l;\n                }\n            }\n            if(obj.state.opened && !obj.state.loaded) {\n                obj.state.opened = false;\n                setTimeout(function () {\n                    this.open_node(obj.id, false, 0);\n                }.bind(this), 0);\n            }\n            return node;\n        },\n        /**\n         * opens a node, revealing its children. If the node is not loaded it will be loaded and opened once ready.\n         * @name open_node(obj [, callback, animation])\n         * @param {mixed} obj the node to open\n         * @param {Function} callback a function to execute once the node is opened\n         * @param {Number} animation the animation duration in milliseconds when opening the node (overrides the `core.animation` setting). Use `false` for no animation.\n         * @trigger open_node.jstree, after_open.jstree, before_open.jstree\n         */\n        open_node : function (obj, callback, animation) {\n            var t1, t2, d, t;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.open_node(obj[t1], callback, animation);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            animation = animation === undefined ? this.settings.core.animation : animation;\n            if(!this.is_closed(obj)) {\n                if(callback) {\n                    callback.call(this, obj, false);\n                }\n                return false;\n            }\n            if(!this.is_loaded(obj)) {\n                if(this.is_loading(obj)) {\n                    return setTimeout(function () {\n                        this.open_node(obj, callback, animation);\n                    }.bind(this), 500);\n                }\n                this.load_node(obj, function (o, ok) {\n                    return ok ? this.open_node(o, callback, animation) : (callback ? callback.call(this, o, false) : false);\n                });\n            }\n            else {\n                d = this.get_node(obj, true);\n                t = this;\n                if(d.length) {\n                    if(animation && d.children(\".jstree-children\").length) {\n                        d.children(\".jstree-children\").stop(true, true);\n                    }\n                    if(obj.children.length && !this._firstChild(d.children('.jstree-children')[0])) {\n                        this.draw_children(obj);\n                        //d = this.get_node(obj, true);\n                    }\n                    if(!animation) {\n                        this.trigger('before_open', { \"node\" : obj });\n                        d[0].className = d[0].className.replace('jstree-closed', 'jstree-open');\n                        d[0].childNodes[1].setAttribute(\"aria-expanded\", true);\n                    }\n                    else {\n                        this.trigger('before_open', { \"node\" : obj });\n                        d\n                            .children(\".jstree-children\").css(\"display\",\"none\").end()\n                            .removeClass(\"jstree-closed\").addClass(\"jstree-open\")\n                            .children('.jstree-anchor').attr(\"aria-expanded\", true).end()\n                            .children(\".jstree-children\").stop(true, true)\n                            .slideDown(animation, function () {\n                                this.style.display = \"\";\n                                if (t.element) {\n                                    t.trigger(\"after_open\", { \"node\" : obj });\n                                }\n                            });\n                    }\n                }\n                obj.state.opened = true;\n                if(callback) {\n                    callback.call(this, obj, true);\n                }\n                if(!d.length) {\n                    /**\n                     * triggered when a node is about to be opened (if the node is supposed to be in the DOM, it will be, but it won't be visible yet)\n                     * @event\n                     * @name before_open.jstree\n                     * @param {Object} node the opened node\n                     */\n                    this.trigger('before_open', { \"node\" : obj });\n                }\n                /**\n                 * triggered when a node is opened (if there is an animation it will not be completed yet)\n                 * @event\n                 * @name open_node.jstree\n                 * @param {Object} node the opened node\n                 */\n                this.trigger('open_node', { \"node\" : obj });\n                if(!animation || !d.length) {\n                    /**\n                     * triggered when a node is opened and the animation is complete\n                     * @event\n                     * @name after_open.jstree\n                     * @param {Object} node the opened node\n                     */\n                    this.trigger(\"after_open\", { \"node\" : obj });\n                }\n                return true;\n            }\n        },\n        /**\n         * opens every parent of a node (node should be loaded)\n         * @name _open_to(obj)\n         * @param {mixed} obj the node to reveal\n         * @private\n         */\n        _open_to : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            var i, j, p = obj.parents;\n            for(i = 0, j = p.length; i < j; i+=1) {\n                if(i !== $.jstree.root) {\n                    this.open_node(p[i], false, 0);\n                }\n            }\n            return $('#' + obj.id.replace($.jstree.idregex,'\\\\$&'), this.element);\n        },\n        /**\n         * closes a node, hiding its children\n         * @name close_node(obj [, animation])\n         * @param {mixed} obj the node to close\n         * @param {Number} animation the animation duration in milliseconds when closing the node (overrides the `core.animation` setting). Use `false` for no animation.\n         * @trigger close_node.jstree, after_close.jstree\n         */\n        close_node : function (obj, animation) {\n            var t1, t2, t, d;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.close_node(obj[t1], animation);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            if(this.is_closed(obj)) {\n                return false;\n            }\n            animation = animation === undefined ? this.settings.core.animation : animation;\n            t = this;\n            d = this.get_node(obj, true);\n\n            obj.state.opened = false;\n            /**\n             * triggered when a node is closed (if there is an animation it will not be complete yet)\n             * @event\n             * @name close_node.jstree\n             * @param {Object} node the closed node\n             */\n            this.trigger('close_node',{ \"node\" : obj });\n            if(!d.length) {\n                /**\n                 * triggered when a node is closed and the animation is complete\n                 * @event\n                 * @name after_close.jstree\n                 * @param {Object} node the closed node\n                 */\n                this.trigger(\"after_close\", { \"node\" : obj });\n            }\n            else {\n                if(!animation) {\n                    d[0].className = d[0].className.replace('jstree-open', 'jstree-closed');\n                    d.children('.jstree-anchor').attr(\"aria-expanded\", false);\n                    d.children('.jstree-children').remove();\n                    this.trigger(\"after_close\", { \"node\" : obj });\n                }\n                else {\n                    d\n                        .children(\".jstree-children\").attr(\"style\",\"display:block !important\").end()\n                        .removeClass(\"jstree-open\").addClass(\"jstree-closed\")\n                        .children('.jstree-anchor').attr(\"aria-expanded\", false).end()\n                        .children(\".jstree-children\").stop(true, true).slideUp(animation, function () {\n                        this.style.display = \"\";\n                        d.children('.jstree-children').remove();\n                        if (t.element) {\n                            t.trigger(\"after_close\", { \"node\" : obj });\n                        }\n                    });\n                }\n            }\n        },\n        /**\n         * toggles a node - closing it if it is open, opening it if it is closed\n         * @name toggle_node(obj)\n         * @param {mixed} obj the node to toggle\n         */\n        toggle_node : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.toggle_node(obj[t1]);\n                }\n                return true;\n            }\n            if(this.is_closed(obj)) {\n                return this.open_node(obj);\n            }\n            if(this.is_open(obj)) {\n                return this.close_node(obj);\n            }\n        },\n        /**\n         * opens all nodes within a node (or the tree), revealing their children. If the node is not loaded it will be loaded and opened once ready.\n         * @name open_all([obj, animation, original_obj])\n         * @param {mixed} obj the node to open recursively, omit to open all nodes in the tree\n         * @param {Number} animation the animation duration in milliseconds when opening the nodes, the default is no animation\n         * @param {jQuery} reference to the node that started the process (internal use)\n         * @trigger open_all.jstree\n         */\n        open_all : function (obj, animation, original_obj) {\n            if(!obj) { obj = $.jstree.root; }\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var dom = obj.id === $.jstree.root ? this.get_container_ul() : this.get_node(obj, true), i, j, _this;\n            if(!dom.length) {\n                for(i = 0, j = obj.children_d.length; i < j; i++) {\n                    if(this.is_closed(this._model.data[obj.children_d[i]])) {\n                        this._model.data[obj.children_d[i]].state.opened = true;\n                    }\n                }\n                return this.trigger('open_all', { \"node\" : obj });\n            }\n            original_obj = original_obj || dom;\n            _this = this;\n            dom = this.is_closed(obj) ? dom.find('.jstree-closed').addBack() : dom.find('.jstree-closed');\n            dom.each(function () {\n                _this.open_node(\n                    this,\n                    function(node, status) { if(status && this.is_parent(node)) { this.open_all(node, animation, original_obj); } },\n                    animation || 0\n                );\n            });\n            if(original_obj.find('.jstree-closed').length === 0) {\n                /**\n                 * triggered when an `open_all` call completes\n                 * @event\n                 * @name open_all.jstree\n                 * @param {Object} node the opened node\n                 */\n                this.trigger('open_all', { \"node\" : this.get_node(original_obj) });\n            }\n        },\n        /**\n         * closes all nodes within a node (or the tree), revealing their children\n         * @name close_all([obj, animation])\n         * @param {mixed} obj the node to close recursively, omit to close all nodes in the tree\n         * @param {Number} animation the animation duration in milliseconds when closing the nodes, the default is no animation\n         * @trigger close_all.jstree\n         */\n        close_all : function (obj, animation) {\n            if(!obj) { obj = $.jstree.root; }\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var dom = obj.id === $.jstree.root ? this.get_container_ul() : this.get_node(obj, true),\n                _this = this, i, j;\n            if(dom.length) {\n                dom = this.is_open(obj) ? dom.find('.jstree-open').addBack() : dom.find('.jstree-open');\n                $(dom.get().reverse()).each(function () { _this.close_node(this, animation || 0); });\n            }\n            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                this._model.data[obj.children_d[i]].state.opened = false;\n            }\n            /**\n             * triggered when an `close_all` call completes\n             * @event\n             * @name close_all.jstree\n             * @param {Object} node the closed node\n             */\n            this.trigger('close_all', { \"node\" : obj });\n        },\n        /**\n         * checks if a node is disabled (not selectable)\n         * @name is_disabled(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_disabled : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state && obj.state.disabled;\n        },\n        /**\n         * enables a node - so that it can be selected\n         * @name enable_node(obj)\n         * @param {mixed} obj the node to enable\n         * @trigger enable_node.jstree\n         */\n        enable_node : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.enable_node(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            obj.state.disabled = false;\n            this.get_node(obj,true).children('.jstree-anchor').removeClass('jstree-disabled').attr('aria-disabled', false);\n            /**\n             * triggered when an node is enabled\n             * @event\n             * @name enable_node.jstree\n             * @param {Object} node the enabled node\n             */\n            this.trigger('enable_node', { 'node' : obj });\n        },\n        /**\n         * disables a node - so that it can not be selected\n         * @name disable_node(obj)\n         * @param {mixed} obj the node to disable\n         * @trigger disable_node.jstree\n         */\n        disable_node : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.disable_node(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            obj.state.disabled = true;\n            this.get_node(obj,true).children('.jstree-anchor').addClass('jstree-disabled').attr('aria-disabled', true);\n            /**\n             * triggered when an node is disabled\n             * @event\n             * @name disable_node.jstree\n             * @param {Object} node the disabled node\n             */\n            this.trigger('disable_node', { 'node' : obj });\n        },\n        /**\n         * determines if a node is hidden\n         * @name is_hidden(obj)\n         * @param {mixed} obj the node\n         */\n        is_hidden : function (obj) {\n            obj = this.get_node(obj);\n            return obj.state.hidden === true;\n        },\n        /**\n         * hides a node - it is still in the structure but will not be visible\n         * @name hide_node(obj)\n         * @param {mixed} obj the node to hide\n         * @param {Boolean} skip_redraw internal parameter controlling if redraw is called\n         * @trigger hide_node.jstree\n         */\n        hide_node : function (obj, skip_redraw) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.hide_node(obj[t1], true);\n                }\n                if (!skip_redraw) {\n                    this.redraw();\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            if(!obj.state.hidden) {\n                obj.state.hidden = true;\n                this._node_changed(obj.parent);\n                if(!skip_redraw) {\n                    this.redraw();\n                }\n                /**\n                 * triggered when an node is hidden\n                 * @event\n                 * @name hide_node.jstree\n                 * @param {Object} node the hidden node\n                 */\n                this.trigger('hide_node', { 'node' : obj });\n            }\n        },\n        /**\n         * shows a node\n         * @name show_node(obj)\n         * @param {mixed} obj the node to show\n         * @param {Boolean} skip_redraw internal parameter controlling if redraw is called\n         * @trigger show_node.jstree\n         */\n        show_node : function (obj, skip_redraw) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.show_node(obj[t1], true);\n                }\n                if (!skip_redraw) {\n                    this.redraw();\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            if(obj.state.hidden) {\n                obj.state.hidden = false;\n                this._node_changed(obj.parent);\n                if(!skip_redraw) {\n                    this.redraw();\n                }\n                /**\n                 * triggered when an node is shown\n                 * @event\n                 * @name show_node.jstree\n                 * @param {Object} node the shown node\n                 */\n                this.trigger('show_node', { 'node' : obj });\n            }\n        },\n        /**\n         * hides all nodes\n         * @name hide_all()\n         * @trigger hide_all.jstree\n         */\n        hide_all : function (skip_redraw) {\n            var i, m = this._model.data, ids = [];\n            for(i in m) {\n                if(m.hasOwnProperty(i) && i !== $.jstree.root && !m[i].state.hidden) {\n                    m[i].state.hidden = true;\n                    ids.push(i);\n                }\n            }\n            this._model.force_full_redraw = true;\n            if(!skip_redraw) {\n                this.redraw();\n            }\n            /**\n             * triggered when all nodes are hidden\n             * @event\n             * @name hide_all.jstree\n             * @param {Array} nodes the IDs of all hidden nodes\n             */\n            this.trigger('hide_all', { 'nodes' : ids });\n            return ids;\n        },\n        /**\n         * shows all nodes\n         * @name show_all()\n         * @trigger show_all.jstree\n         */\n        show_all : function (skip_redraw) {\n            var i, m = this._model.data, ids = [];\n            for(i in m) {\n                if(m.hasOwnProperty(i) && i !== $.jstree.root && m[i].state.hidden) {\n                    m[i].state.hidden = false;\n                    ids.push(i);\n                }\n            }\n            this._model.force_full_redraw = true;\n            if(!skip_redraw) {\n                this.redraw();\n            }\n            /**\n             * triggered when all nodes are shown\n             * @event\n             * @name show_all.jstree\n             * @param {Array} nodes the IDs of all shown nodes\n             */\n            this.trigger('show_all', { 'nodes' : ids });\n            return ids;\n        },\n        /**\n         * called when a node is selected by the user. Used internally.\n         * @private\n         * @name activate_node(obj, e)\n         * @param {mixed} obj the node\n         * @param {Object} e the related event\n         * @trigger activate_node.jstree, changed.jstree\n         */\n        activate_node : function (obj, e) {\n            if(this.is_disabled(obj)) {\n                return false;\n            }\n            if(!e || typeof e !== 'object') {\n                e = {};\n            }\n\n            // ensure last_clicked is still in the DOM, make it fresh (maybe it was moved?) and make sure it is still selected, if not - make last_clicked the last selected node\n            this._data.core.last_clicked = this._data.core.last_clicked && this._data.core.last_clicked.id !== undefined ? this.get_node(this._data.core.last_clicked.id) : null;\n            if(this._data.core.last_clicked && !this._data.core.last_clicked.state.selected) { this._data.core.last_clicked = null; }\n            if(!this._data.core.last_clicked && this._data.core.selected.length) { this._data.core.last_clicked = this.get_node(this._data.core.selected[this._data.core.selected.length - 1]); }\n\n            if(!this.settings.core.multiple || (!e.metaKey && !e.ctrlKey && !e.shiftKey) || (e.shiftKey && (!this._data.core.last_clicked || !this.get_parent(obj) || this.get_parent(obj) !== this._data.core.last_clicked.parent ) )) {\n                if(!this.settings.core.multiple && (e.metaKey || e.ctrlKey || e.shiftKey) && this.is_selected(obj)) {\n                    this.deselect_node(obj, false, e);\n                }\n                else {\n                    this.deselect_all(true);\n                    this.select_node(obj, false, false, e);\n                    this._data.core.last_clicked = this.get_node(obj);\n                }\n            }\n            else {\n                if(e.shiftKey) {\n                    var o = this.get_node(obj).id,\n                        l = this._data.core.last_clicked.id,\n                        p = this.get_node(this._data.core.last_clicked.parent).children,\n                        c = false,\n                        i, j;\n                    for(i = 0, j = p.length; i < j; i += 1) {\n                        // separate IFs work whem o and l are the same\n                        if(p[i] === o) {\n                            c = !c;\n                        }\n                        if(p[i] === l) {\n                            c = !c;\n                        }\n                        if(!this.is_disabled(p[i]) && (c || p[i] === o || p[i] === l)) {\n                            if (!this.is_hidden(p[i])) {\n                                this.select_node(p[i], true, false, e);\n                            }\n                        }\n                        else {\n                            this.deselect_node(p[i], true, e);\n                        }\n                    }\n                    this.trigger('changed', { 'action' : 'select_node', 'node' : this.get_node(obj), 'selected' : this._data.core.selected, 'event' : e });\n                }\n                else {\n                    if(!this.is_selected(obj)) {\n                        this.select_node(obj, false, false, e);\n                    }\n                    else {\n                        this.deselect_node(obj, false, e);\n                    }\n                }\n            }\n            /**\n             * triggered when an node is clicked or intercated with by the user\n             * @event\n             * @name activate_node.jstree\n             * @param {Object} node\n             * @param {Object} event the ooriginal event (if any) which triggered the call (may be an empty object)\n             */\n            this.trigger('activate_node', { 'node' : this.get_node(obj), 'event' : e });\n        },\n        /**\n         * applies the hover state on a node, called when a node is hovered by the user. Used internally.\n         * @private\n         * @name hover_node(obj)\n         * @param {mixed} obj\n         * @trigger hover_node.jstree\n         */\n        hover_node : function (obj) {\n            obj = this.get_node(obj, true);\n            if(!obj || !obj.length || obj.children('.jstree-hovered').length) {\n                return false;\n            }\n            var o = this.element.find('.jstree-hovered'), t = this.element;\n            if(o && o.length) { this.dehover_node(o); }\n\n            obj.children('.jstree-anchor').addClass('jstree-hovered');\n            /**\n             * triggered when an node is hovered\n             * @event\n             * @name hover_node.jstree\n             * @param {Object} node\n             */\n            this.trigger('hover_node', { 'node' : this.get_node(obj) });\n            setTimeout(function () { t.attr('aria-activedescendant', obj[0].id); }, 0);\n        },\n        /**\n         * removes the hover state from a nodecalled when a node is no longer hovered by the user. Used internally.\n         * @private\n         * @name dehover_node(obj)\n         * @param {mixed} obj\n         * @trigger dehover_node.jstree\n         */\n        dehover_node : function (obj) {\n            obj = this.get_node(obj, true);\n            if(!obj || !obj.length || !obj.children('.jstree-hovered').length) {\n                return false;\n            }\n            obj.children('.jstree-anchor').removeClass('jstree-hovered');\n            /**\n             * triggered when an node is no longer hovered\n             * @event\n             * @name dehover_node.jstree\n             * @param {Object} node\n             */\n            this.trigger('dehover_node', { 'node' : this.get_node(obj) });\n        },\n        /**\n         * select a node\n         * @name select_node(obj [, supress_event, prevent_open])\n         * @param {mixed} obj an array can be used to select multiple nodes\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @param {Boolean} prevent_open if set to `true` parents of the selected node won't be opened\n         * @trigger select_node.jstree, changed.jstree\n         */\n        select_node : function (obj, supress_event, prevent_open, e) {\n            var dom, t1, t2, th;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.select_node(obj[t1], supress_event, prevent_open, e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(!obj.state.selected) {\n                obj.state.selected = true;\n                this._data.core.selected.push(obj.id);\n                if(!prevent_open) {\n                    dom = this._open_to(obj);\n                }\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').addClass('jstree-clicked').attr('aria-selected', true);\n                }\n                /**\n                 * triggered when an node is selected\n                 * @event\n                 * @name select_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this select_node\n                 */\n                this.trigger('select_node', { 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                if(!supress_event) {\n                    /**\n                     * triggered when selection changes\n                     * @event\n                     * @name changed.jstree\n                     * @param {Object} node\n                     * @param {Object} action the action that caused the selection to change\n                     * @param {Array} selected the current selection\n                     * @param {Object} event the event (if any) that triggered this changed event\n                     */\n                    this.trigger('changed', { 'action' : 'select_node', 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                }\n            }\n        },\n        /**\n         * deselect a node\n         * @name deselect_node(obj [, supress_event])\n         * @param {mixed} obj an array can be used to deselect multiple nodes\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @trigger deselect_node.jstree, changed.jstree\n         */\n        deselect_node : function (obj, supress_event, e) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.deselect_node(obj[t1], supress_event, e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(obj.state.selected) {\n                obj.state.selected = false;\n                this._data.core.selected = $.vakata.array_remove_item(this._data.core.selected, obj.id);\n                if(dom.length) {\n                    dom.children('.jstree-anchor').removeClass('jstree-clicked').attr('aria-selected', false);\n                }\n                /**\n                 * triggered when an node is deselected\n                 * @event\n                 * @name deselect_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this deselect_node\n                 */\n                this.trigger('deselect_node', { 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                if(!supress_event) {\n                    this.trigger('changed', { 'action' : 'deselect_node', 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                }\n            }\n        },\n        /**\n         * select all nodes in the tree\n         * @name select_all([supress_event])\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @trigger select_all.jstree, changed.jstree\n         */\n        select_all : function (supress_event) {\n            var tmp = this._data.core.selected.concat([]), i, j;\n            this._data.core.selected = this._model.data[$.jstree.root].children_d.concat();\n            for(i = 0, j = this._data.core.selected.length; i < j; i++) {\n                if(this._model.data[this._data.core.selected[i]]) {\n                    this._model.data[this._data.core.selected[i]].state.selected = true;\n                }\n            }\n            this.redraw(true);\n            /**\n             * triggered when all nodes are selected\n             * @event\n             * @name select_all.jstree\n             * @param {Array} selected the current selection\n             */\n            this.trigger('select_all', { 'selected' : this._data.core.selected });\n            if(!supress_event) {\n                this.trigger('changed', { 'action' : 'select_all', 'selected' : this._data.core.selected, 'old_selection' : tmp });\n            }\n        },\n        /**\n         * deselect all selected nodes\n         * @name deselect_all([supress_event])\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @trigger deselect_all.jstree, changed.jstree\n         */\n        deselect_all : function (supress_event) {\n            var tmp = this._data.core.selected.concat([]), i, j;\n            for(i = 0, j = this._data.core.selected.length; i < j; i++) {\n                if(this._model.data[this._data.core.selected[i]]) {\n                    this._model.data[this._data.core.selected[i]].state.selected = false;\n                }\n            }\n            this._data.core.selected = [];\n            this.element.find('.jstree-clicked').removeClass('jstree-clicked').attr('aria-selected', false);\n            /**\n             * triggered when all nodes are deselected\n             * @event\n             * @name deselect_all.jstree\n             * @param {Object} node the previous selection\n             * @param {Array} selected the current selection\n             */\n            this.trigger('deselect_all', { 'selected' : this._data.core.selected, 'node' : tmp });\n            if(!supress_event) {\n                this.trigger('changed', { 'action' : 'deselect_all', 'selected' : this._data.core.selected, 'old_selection' : tmp });\n            }\n        },\n        /**\n         * checks if a node is selected\n         * @name is_selected(obj)\n         * @param  {mixed}  obj\n         * @return {Boolean}\n         */\n        is_selected : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            return obj.state.selected;\n        },\n        /**\n         * get an array of all selected nodes\n         * @name get_selected([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         */\n        get_selected : function (full) {\n            return full ? $.map(this._data.core.selected, function (i) { return this.get_node(i); }.bind(this)) : this._data.core.selected.slice();\n        },\n        /**\n         * get an array of all top level selected nodes (ignoring children of selected nodes)\n         * @name get_top_selected([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         */\n        get_top_selected : function (full) {\n            var tmp = this.get_selected(true),\n                obj = {}, i, j, k, l;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                obj[tmp[i].id] = tmp[i];\n            }\n            for(i = 0, j = tmp.length; i < j; i++) {\n                for(k = 0, l = tmp[i].children_d.length; k < l; k++) {\n                    if(obj[tmp[i].children_d[k]]) {\n                        delete obj[tmp[i].children_d[k]];\n                    }\n                }\n            }\n            tmp = [];\n            for(i in obj) {\n                if(obj.hasOwnProperty(i)) {\n                    tmp.push(i);\n                }\n            }\n            return full ? $.map(tmp, function (i) { return this.get_node(i); }.bind(this)) : tmp;\n        },\n        /**\n         * get an array of all bottom level selected nodes (ignoring selected parents)\n         * @name get_bottom_selected([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         */\n        get_bottom_selected : function (full) {\n            var tmp = this.get_selected(true),\n                obj = [], i, j;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                if(!tmp[i].children.length) {\n                    obj.push(tmp[i].id);\n                }\n            }\n            return full ? $.map(obj, function (i) { return this.get_node(i); }.bind(this)) : obj;\n        },\n        /**\n         * gets the current state of the tree so that it can be restored later with `set_state(state)`. Used internally.\n         * @name get_state()\n         * @private\n         * @return {Object}\n         */\n        get_state : function () {\n            var state\t= {\n                'core' : {\n                    'open' : [],\n                    'loaded' : [],\n                    'scroll' : {\n                        'left' : this.element.scrollLeft(),\n                        'top' : this.element.scrollTop()\n                    },\n                    /*!\n\t\t\t\t\t'themes' : {\n\t\t\t\t\t\t'name' : this.get_theme(),\n\t\t\t\t\t\t'icons' : this._data.core.themes.icons,\n\t\t\t\t\t\t'dots' : this._data.core.themes.dots\n\t\t\t\t\t},\n\t\t\t\t\t*/\n                    'selected' : []\n                }\n            }, i;\n            for(i in this._model.data) {\n                if(this._model.data.hasOwnProperty(i)) {\n                    if(i !== $.jstree.root) {\n                        if(this._model.data[i].state.loaded && this.settings.core.loaded_state) {\n                            state.core.loaded.push(i);\n                        }\n                        if(this._model.data[i].state.opened) {\n                            state.core.open.push(i);\n                        }\n                        if(this._model.data[i].state.selected) {\n                            state.core.selected.push(i);\n                        }\n                    }\n                }\n            }\n            return state;\n        },\n        /**\n         * sets the state of the tree. Used internally.\n         * @name set_state(state [, callback])\n         * @private\n         * @param {Object} state the state to restore. Keep in mind this object is passed by reference and jstree will modify it.\n         * @param {Function} callback an optional function to execute once the state is restored.\n         * @trigger set_state.jstree\n         */\n        set_state : function (state, callback) {\n            if(state) {\n                if(state.core && state.core.selected && state.core.initial_selection === undefined) {\n                    state.core.initial_selection = this._data.core.selected.concat([]).sort().join(',');\n                }\n                if(state.core) {\n                    var res, n, t, _this, i;\n                    if(state.core.loaded) {\n                        if(!this.settings.core.loaded_state || !$.vakata.is_array(state.core.loaded) || !state.core.loaded.length) {\n                            delete state.core.loaded;\n                            this.set_state(state, callback);\n                        }\n                        else {\n                            this._load_nodes(state.core.loaded, function (nodes) {\n                                delete state.core.loaded;\n                                this.set_state(state, callback);\n                            });\n                        }\n                        return false;\n                    }\n                    if(state.core.open) {\n                        if(!$.vakata.is_array(state.core.open) || !state.core.open.length) {\n                            delete state.core.open;\n                            this.set_state(state, callback);\n                        }\n                        else {\n                            this._load_nodes(state.core.open, function (nodes) {\n                                this.open_node(nodes, false, 0);\n                                delete state.core.open;\n                                this.set_state(state, callback);\n                            });\n                        }\n                        return false;\n                    }\n                    if(state.core.scroll) {\n                        if(state.core.scroll && state.core.scroll.left !== undefined) {\n                            this.element.scrollLeft(state.core.scroll.left);\n                        }\n                        if(state.core.scroll && state.core.scroll.top !== undefined) {\n                            this.element.scrollTop(state.core.scroll.top);\n                        }\n                        delete state.core.scroll;\n                        this.set_state(state, callback);\n                        return false;\n                    }\n                    if(state.core.selected) {\n                        _this = this;\n                        if (state.core.initial_selection === undefined ||\n                            state.core.initial_selection === this._data.core.selected.concat([]).sort().join(',')\n                        ) {\n                            this.deselect_all();\n                            $.each(state.core.selected, function (i, v) {\n                                _this.select_node(v, false, true);\n                            });\n                        }\n                        delete state.core.initial_selection;\n                        delete state.core.selected;\n                        this.set_state(state, callback);\n                        return false;\n                    }\n                    for(i in state) {\n                        if(state.hasOwnProperty(i) && i !== \"core\" && $.inArray(i, this.settings.plugins) === -1) {\n                            delete state[i];\n                        }\n                    }\n                    if($.isEmptyObject(state.core)) {\n                        delete state.core;\n                        this.set_state(state, callback);\n                        return false;\n                    }\n                }\n                if($.isEmptyObject(state)) {\n                    state = null;\n                    if(callback) { callback.call(this); }\n                    /**\n                     * triggered when a `set_state` call completes\n                     * @event\n                     * @name set_state.jstree\n                     */\n                    this.trigger('set_state');\n                    return false;\n                }\n                return true;\n            }\n            return false;\n        },\n        /**\n         * refreshes the tree - all nodes are reloaded with calls to `load_node`.\n         * @name refresh()\n         * @param {Boolean} skip_loading an option to skip showing the loading indicator\n         * @param {Mixed} forget_state if set to `true` state will not be reapplied, if set to a function (receiving the current state as argument) the result of that function will be used as state\n         * @trigger refresh.jstree\n         */\n        refresh : function (skip_loading, forget_state) {\n            this._data.core.state = forget_state === true ? {} : this.get_state();\n            if(forget_state && $.vakata.is_function(forget_state)) { this._data.core.state = forget_state.call(this, this._data.core.state); }\n            this._cnt = 0;\n            this._model.data = {};\n            this._model.data[$.jstree.root] = {\n                id : $.jstree.root,\n                parent : null,\n                parents : [],\n                children : [],\n                children_d : [],\n                state : { loaded : false }\n            };\n            this._data.core.selected = [];\n            this._data.core.last_clicked = null;\n            this._data.core.focused = null;\n\n            var c = this.get_container_ul()[0].className;\n            if(!skip_loading) {\n                this.element.html(\"<\"+\"ul class='\"+c+\"' role='group'><\"+\"li class='jstree-initial-node jstree-loading jstree-leaf jstree-last' role='none' id='j\"+this._id+\"_loading'><i class='jstree-icon jstree-ocl'></i><\"+\"a class='jstree-anchor' role='treeitem' href='#'><i class='jstree-icon jstree-themeicon-hidden'></i>\" + this.get_string(\"Loading ...\") + \"</a></li></ul>\");\n                this.element.attr('aria-activedescendant','j'+this._id+'_loading');\n            }\n            this.load_node($.jstree.root, function (o, s) {\n                if(s) {\n                    this.get_container_ul()[0].className = c;\n                    if(this._firstChild(this.get_container_ul()[0])) {\n                        this.element.attr('aria-activedescendant',this._firstChild(this.get_container_ul()[0]).id);\n                    }\n                    this.set_state($.extend(true, {}, this._data.core.state), function () {\n                        /**\n                         * triggered when a `refresh` call completes\n                         * @event\n                         * @name refresh.jstree\n                         */\n                        this.trigger('refresh');\n                    });\n                }\n                this._data.core.state = null;\n            });\n        },\n        /**\n         * refreshes a node in the tree (reload its children) all opened nodes inside that node are reloaded with calls to `load_node`.\n         * @name refresh_node(obj)\n         * @param  {mixed} obj the node\n         * @trigger refresh_node.jstree\n         */\n        refresh_node : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            var opened = [], to_load = [], s = this._data.core.selected.concat([]);\n            to_load.push(obj.id);\n            if(obj.state.opened === true) { opened.push(obj.id); }\n            this.get_node(obj, true).find('.jstree-open').each(function() { to_load.push(this.id); opened.push(this.id); });\n            this._load_nodes(to_load, function (nodes) {\n                this.open_node(opened, false, 0);\n                this.select_node(s);\n                /**\n                 * triggered when a node is refreshed\n                 * @event\n                 * @name refresh_node.jstree\n                 * @param {Object} node - the refreshed node\n                 * @param {Array} nodes - an array of the IDs of the nodes that were reloaded\n                 */\n                this.trigger('refresh_node', { 'node' : obj, 'nodes' : nodes });\n            }.bind(this), false, true);\n        },\n        /**\n         * set (change) the ID of a node\n         * @name set_id(obj, id)\n         * @param  {mixed} obj the node\n         * @param  {String} id the new ID\n         * @return {Boolean}\n         * @trigger set_id.jstree\n         */\n        set_id : function (obj, id) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            var i, j, m = this._model.data, old = obj.id;\n            id = id.toString();\n            // update parents (replace current ID with new one in children and children_d)\n            m[obj.parent].children[$.inArray(obj.id, m[obj.parent].children)] = id;\n            for(i = 0, j = obj.parents.length; i < j; i++) {\n                m[obj.parents[i]].children_d[$.inArray(obj.id, m[obj.parents[i]].children_d)] = id;\n            }\n            // update children (replace current ID with new one in parent and parents)\n            for(i = 0, j = obj.children.length; i < j; i++) {\n                m[obj.children[i]].parent = id;\n            }\n            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                m[obj.children_d[i]].parents[$.inArray(obj.id, m[obj.children_d[i]].parents)] = id;\n            }\n            i = $.inArray(obj.id, this._data.core.selected);\n            if(i !== -1) { this._data.core.selected[i] = id; }\n            // update model and obj itself (obj.id, this._model.data[KEY])\n            i = this.get_node(obj.id, true);\n            if(i) {\n                i.attr('id', id); //.children('.jstree-anchor').attr('id', id + '_anchor').end().attr('aria-labelledby', id + '_anchor');\n                if(this.element.attr('aria-activedescendant') === obj.id) {\n                    this.element.attr('aria-activedescendant', id);\n                }\n            }\n            delete m[obj.id];\n            obj.id = id;\n            obj.li_attr.id = id;\n            m[id] = obj;\n            /**\n             * triggered when a node id value is changed\n             * @event\n             * @name set_id.jstree\n             * @param {Object} node\n             * @param {String} old the old id\n             */\n            this.trigger('set_id',{ \"node\" : obj, \"new\" : obj.id, \"old\" : old });\n            return true;\n        },\n        /**\n         * get the text value of a node\n         * @name get_text(obj)\n         * @param  {mixed} obj the node\n         * @return {String}\n         */\n        get_text : function (obj) {\n            obj = this.get_node(obj);\n            return (!obj || obj.id === $.jstree.root) ? false : obj.text;\n        },\n        /**\n         * set the text value of a node. Used internally, please use `rename_node(obj, val)`.\n         * @private\n         * @name set_text(obj, val)\n         * @param  {mixed} obj the node, you can pass an array to set the text on multiple nodes\n         * @param  {String} val the new text value\n         * @return {Boolean}\n         * @trigger set_text.jstree\n         */\n        set_text : function (obj, val) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.set_text(obj[t1], val);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            obj.text = val;\n            if(this.get_node(obj, true).length) {\n                this.redraw_node(obj.id);\n            }\n            /**\n             * triggered when a node text value is changed\n             * @event\n             * @name set_text.jstree\n             * @param {Object} obj\n             * @param {String} text the new value\n             */\n            this.trigger('set_text',{ \"obj\" : obj, \"text\" : val });\n            return true;\n        },\n        /**\n         * gets a JSON representation of a node (or the whole tree)\n         * @name get_json([obj, options])\n         * @param  {mixed} obj\n         * @param  {Object} options\n         * @param  {Boolean} options.no_state do not return state information\n         * @param  {Boolean} options.no_id do not return ID\n         * @param  {Boolean} options.no_children do not include children\n         * @param  {Boolean} options.no_data do not include node data\n         * @param  {Boolean} options.no_li_attr do not include LI attributes\n         * @param  {Boolean} options.no_a_attr do not include A attributes\n         * @param  {Boolean} options.flat return flat JSON instead of nested\n         * @return {Object}\n         */\n        get_json : function (obj, options, flat) {\n            obj = this.get_node(obj || $.jstree.root);\n            if(!obj) { return false; }\n            if(options && options.flat && !flat) { flat = []; }\n            var tmp = {\n                'id' : obj.id,\n                'text' : obj.text,\n                'icon' : this.get_icon(obj),\n                'li_attr' : $.extend(true, {}, obj.li_attr),\n                'a_attr' : $.extend(true, {}, obj.a_attr),\n                'state' : {},\n                'data' : options && options.no_data ? false : $.extend(true, $.vakata.is_array(obj.data)?[]:{}, obj.data)\n                //( this.get_node(obj, true).length ? this.get_node(obj, true).data() : obj.data ),\n            }, i, j;\n            if(options && options.flat) {\n                tmp.parent = obj.parent;\n            }\n            else {\n                tmp.children = [];\n            }\n            if(!options || !options.no_state) {\n                for(i in obj.state) {\n                    if(obj.state.hasOwnProperty(i)) {\n                        tmp.state[i] = obj.state[i];\n                    }\n                }\n            } else {\n                delete tmp.state;\n            }\n            if(options && options.no_li_attr) {\n                delete tmp.li_attr;\n            }\n            if(options && options.no_a_attr) {\n                delete tmp.a_attr;\n            }\n            if(options && options.no_id) {\n                delete tmp.id;\n                if(tmp.li_attr && tmp.li_attr.id) {\n                    delete tmp.li_attr.id;\n                }\n                if(tmp.a_attr && tmp.a_attr.id) {\n                    delete tmp.a_attr.id;\n                }\n            }\n            if(options && options.flat && obj.id !== $.jstree.root) {\n                flat.push(tmp);\n            }\n            if(!options || !options.no_children) {\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    if(options && options.flat) {\n                        this.get_json(obj.children[i], options, flat);\n                    }\n                    else {\n                        tmp.children.push(this.get_json(obj.children[i], options));\n                    }\n                }\n            }\n            return options && options.flat ? flat : (obj.id === $.jstree.root ? tmp.children : tmp);\n        },\n        /**\n         * create a new node (do not confuse with load_node)\n         * @name create_node([par, node, pos, callback, is_loaded])\n         * @param  {mixed}   par       the parent node (to create a root node use either \"#\" (string) or `null`)\n         * @param  {mixed}   node      the data for the new node (a valid JSON object, or a simple string with the name)\n         * @param  {mixed}   pos       the index at which to insert the node, \"first\" and \"last\" are also supported, default is \"last\"\n         * @param  {Function} callback a function to be called once the node is created\n         * @param  {Boolean} is_loaded internal argument indicating if the parent node was succesfully loaded\n         * @return {String}            the ID of the newly create node\n         * @trigger model.jstree, create_node.jstree\n         */\n        create_node : function (par, node, pos, callback, is_loaded) {\n            if(par === null) { par = $.jstree.root; }\n            par = this.get_node(par);\n            if(!par) { return false; }\n            pos = pos === undefined ? \"last\" : pos;\n            if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                return this.load_node(par, function () { this.create_node(par, node, pos, callback, true); });\n            }\n            if(!node) { node = { \"text\" : this.get_string('New node') }; }\n            if(typeof node === \"string\") {\n                node = { \"text\" : node };\n            } else {\n                node = $.extend(true, {}, node);\n            }\n            if(node.text === undefined) { node.text = this.get_string('New node'); }\n            var tmp, dpc, i, j;\n\n            if(par.id === $.jstree.root) {\n                if(pos === \"before\") { pos = \"first\"; }\n                if(pos === \"after\") { pos = \"last\"; }\n            }\n            switch(pos) {\n                case \"before\":\n                    tmp = this.get_node(par.parent);\n                    pos = $.inArray(par.id, tmp.children);\n                    par = tmp;\n                    break;\n                case \"after\" :\n                    tmp = this.get_node(par.parent);\n                    pos = $.inArray(par.id, tmp.children) + 1;\n                    par = tmp;\n                    break;\n                case \"inside\":\n                case \"first\":\n                    pos = 0;\n                    break;\n                case \"last\":\n                    pos = par.children.length;\n                    break;\n                default:\n                    if(!pos) { pos = 0; }\n                    break;\n            }\n            if(pos > par.children.length) { pos = par.children.length; }\n            if(!node.id) { node.id = true; }\n            if(!this.check(\"create_node\", node, par, pos)) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            if(node.id === true) { delete node.id; }\n            node = this._parse_model_from_json(node, par.id, par.parents.concat());\n            if(!node) { return false; }\n            tmp = this.get_node(node);\n            dpc = [];\n            dpc.push(node);\n            dpc = dpc.concat(tmp.children_d);\n            this.trigger('model', { \"nodes\" : dpc, \"parent\" : par.id });\n\n            par.children_d = par.children_d.concat(dpc);\n            for(i = 0, j = par.parents.length; i < j; i++) {\n                this._model.data[par.parents[i]].children_d = this._model.data[par.parents[i]].children_d.concat(dpc);\n            }\n            node = tmp;\n            tmp = [];\n            for(i = 0, j = par.children.length; i < j; i++) {\n                tmp[i >= pos ? i+1 : i] = par.children[i];\n            }\n            tmp[pos] = node.id;\n            par.children = tmp;\n\n            this.redraw_node(par, true);\n            /**\n             * triggered when a node is created\n             * @event\n             * @name create_node.jstree\n             * @param {Object} node\n             * @param {String} parent the parent's ID\n             * @param {Number} position the position of the new node among the parent's children\n             */\n            this.trigger('create_node', { \"node\" : this.get_node(node), \"parent\" : par.id, \"position\" : pos });\n            if(callback) { callback.call(this, this.get_node(node)); }\n            return node.id;\n        },\n        /**\n         * set the text value of a node\n         * @name rename_node(obj, val)\n         * @param  {mixed} obj the node, you can pass an array to rename multiple nodes to the same name\n         * @param  {String} val the new text value\n         * @return {Boolean}\n         * @trigger rename_node.jstree\n         */\n        rename_node : function (obj, val) {\n            var t1, t2, old;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.rename_node(obj[t1], val);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            old = obj.text;\n            if(!this.check(\"rename_node\", obj, this.get_parent(obj), val)) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            this.set_text(obj, val); // .apply(this, Array.prototype.slice.call(arguments))\n            /**\n             * triggered when a node is renamed\n             * @event\n             * @name rename_node.jstree\n             * @param {Object} node\n             * @param {String} text the new value\n             * @param {String} old the old value\n             */\n            this.trigger('rename_node', { \"node\" : obj, \"text\" : val, \"old\" : old });\n            return true;\n        },\n        /**\n         * remove a node\n         * @name delete_node(obj)\n         * @param  {mixed} obj the node, you can pass an array to delete multiple nodes\n         * @return {Boolean}\n         * @trigger delete_node.jstree, changed.jstree\n         */\n        delete_node : function (obj) {\n            var t1, t2, par, pos, tmp, i, j, k, l, c, top, lft;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.delete_node(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            par = this.get_node(obj.parent);\n            pos = $.inArray(obj.id, par.children);\n            c = false;\n            if(!this.check(\"delete_node\", obj, par, pos)) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            if(pos !== -1) {\n                par.children = $.vakata.array_remove(par.children, pos);\n            }\n            tmp = obj.children_d.concat([]);\n            tmp.push(obj.id);\n            for(i = 0, j = obj.parents.length; i < j; i++) {\n                this._model.data[obj.parents[i]].children_d = $.vakata.array_filter(this._model.data[obj.parents[i]].children_d, function (v) {\n                    return $.inArray(v, tmp) === -1;\n                });\n            }\n            for(k = 0, l = tmp.length; k < l; k++) {\n                if(this._model.data[tmp[k]].state.selected) {\n                    c = true;\n                    break;\n                }\n            }\n            if (c) {\n                this._data.core.selected = $.vakata.array_filter(this._data.core.selected, function (v) {\n                    return $.inArray(v, tmp) === -1;\n                });\n            }\n            /**\n             * triggered when a node is deleted\n             * @event\n             * @name delete_node.jstree\n             * @param {Object} node\n             * @param {String} parent the parent's ID\n             */\n            this.trigger('delete_node', { \"node\" : obj, \"parent\" : par.id });\n            if(c) {\n                this.trigger('changed', { 'action' : 'delete_node', 'node' : obj, 'selected' : this._data.core.selected, 'parent' : par.id });\n            }\n            for(k = 0, l = tmp.length; k < l; k++) {\n                delete this._model.data[tmp[k]];\n            }\n            if($.inArray(this._data.core.focused, tmp) !== -1) {\n                this._data.core.focused = null;\n                top = this.element[0].scrollTop;\n                lft = this.element[0].scrollLeft;\n                if(par.id === $.jstree.root) {\n                    if (this._model.data[$.jstree.root].children[0]) {\n                        this.get_node(this._model.data[$.jstree.root].children[0], true).children('.jstree-anchor').triger('focus');\n                    }\n                }\n                else {\n                    this.get_node(par, true).children('.jstree-anchor').trigger('focus');\n                }\n                this.element[0].scrollTop  = top;\n                this.element[0].scrollLeft = lft;\n            }\n            this.redraw_node(par, true);\n            return true;\n        },\n        /**\n         * check if an operation is premitted on the tree. Used internally.\n         * @private\n         * @name check(chk, obj, par, pos)\n         * @param  {String} chk the operation to check, can be \"create_node\", \"rename_node\", \"delete_node\", \"copy_node\" or \"move_node\"\n         * @param  {mixed} obj the node\n         * @param  {mixed} par the parent\n         * @param  {mixed} pos the position to insert at, or if \"rename_node\" - the new name\n         * @param  {mixed} more some various additional information, for example if a \"move_node\" operations is triggered by DND this will be the hovered node\n         * @return {Boolean}\n         */\n        check : function (chk, obj, par, pos, more) {\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            par = par && par.id ? par : this.get_node(par);\n            var tmp = chk.match(/^move_node|copy_node|create_node$/i) ? par : obj,\n                chc = this.settings.core.check_callback;\n            if(chk === \"move_node\" || chk === \"copy_node\") {\n                if((!more || !more.is_multi) && (chk === \"move_node\" && $.inArray(obj.id, par.children) === pos)) {\n                    this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_08', 'reason' : 'Moving node to its current position', 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    return false;\n                }\n                if((!more || !more.is_multi) && (obj.id === par.id || (chk === \"move_node\" && $.inArray(obj.id, par.children) === pos) || $.inArray(par.id, obj.children_d) !== -1)) {\n                    this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_01', 'reason' : 'Moving parent inside child', 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    return false;\n                }\n            }\n            if(tmp && tmp.data) { tmp = tmp.data; }\n            if(tmp && tmp.functions && (tmp.functions[chk] === false || tmp.functions[chk] === true)) {\n                if(tmp.functions[chk] === false) {\n                    this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_02', 'reason' : 'Node data prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                }\n                return tmp.functions[chk];\n            }\n            if(chc === false || ($.vakata.is_function(chc) && chc.call(this, chk, obj, par, pos, more) === false) || (chc && chc[chk] === false)) {\n                this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_03', 'reason' : 'User config for core.check_callback prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                return false;\n            }\n            return true;\n        },\n        /**\n         * get the last error\n         * @name last_error()\n         * @return {Object}\n         */\n        last_error : function () {\n            return this._data.core.last_error;\n        },\n        /**\n         * move a node to a new parent\n         * @name move_node(obj, par [, pos, callback, is_loaded])\n         * @param  {mixed} obj the node to move, pass an array to move multiple nodes\n         * @param  {mixed} par the new parent\n         * @param  {mixed} pos the position to insert at (besides integer values, \"first\" and \"last\" are supported, as well as \"before\" and \"after\"), defaults to integer `0`\n         * @param  {function} callback a function to call once the move is completed, receives 3 arguments - the node, the new parent and the position\n         * @param  {Boolean} is_loaded internal parameter indicating if the parent node has been loaded\n         * @param  {Boolean} skip_redraw internal parameter indicating if the tree should be redrawn\n         * @param  {Boolean} instance internal parameter indicating if the node comes from another instance\n         * @trigger move_node.jstree\n         */\n        move_node : function (obj, par, pos, callback, is_loaded, skip_redraw, origin) {\n            var t1, t2, old_par, old_pos, new_par, old_ins, is_multi, dpc, tmp, i, j, k, l, p;\n\n            par = this.get_node(par);\n            pos = pos === undefined ? 0 : pos;\n            if(!par) { return false; }\n            if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                return this.load_node(par, function () { this.move_node(obj, par, pos, callback, true, false, origin); });\n            }\n\n            if($.vakata.is_array(obj)) {\n                if(obj.length === 1) {\n                    obj = obj[0];\n                }\n                else {\n                    //obj = obj.slice();\n                    for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                        if((tmp = this.move_node(obj[t1], par, pos, callback, is_loaded, false, origin))) {\n                            par = tmp;\n                            pos = \"after\";\n                        }\n                    }\n                    this.redraw();\n                    return true;\n                }\n            }\n            obj = obj && obj.id ? obj : this.get_node(obj);\n\n            if(!obj || obj.id === $.jstree.root) { return false; }\n\n            old_par = (obj.parent || $.jstree.root).toString();\n            new_par = (!pos.toString().match(/^(before|after)$/) || par.id === $.jstree.root) ? par : this.get_node(par.parent);\n            old_ins = origin ? origin : (this._model.data[obj.id] ? this : $.jstree.reference(obj.id));\n            is_multi = !old_ins || !old_ins._id || (this._id !== old_ins._id);\n            old_pos = old_ins && old_ins._id && old_par && old_ins._model.data[old_par] && old_ins._model.data[old_par].children ? $.inArray(obj.id, old_ins._model.data[old_par].children) : -1;\n            if(old_ins && old_ins._id) {\n                obj = old_ins._model.data[obj.id];\n            }\n\n            if(is_multi) {\n                if((tmp = this.copy_node(obj, par, pos, callback, is_loaded, false, origin))) {\n                    if(old_ins) { old_ins.delete_node(obj); }\n                    return tmp;\n                }\n                return false;\n            }\n            //var m = this._model.data;\n            if(par.id === $.jstree.root) {\n                if(pos === \"before\") { pos = \"first\"; }\n                if(pos === \"after\") { pos = \"last\"; }\n            }\n            switch(pos) {\n                case \"before\":\n                    pos = $.inArray(par.id, new_par.children);\n                    break;\n                case \"after\" :\n                    pos = $.inArray(par.id, new_par.children) + 1;\n                    break;\n                case \"inside\":\n                case \"first\":\n                    pos = 0;\n                    break;\n                case \"last\":\n                    pos = new_par.children.length;\n                    break;\n                default:\n                    if(!pos) { pos = 0; }\n                    break;\n            }\n            if(pos > new_par.children.length) { pos = new_par.children.length; }\n            if(!this.check(\"move_node\", obj, new_par, pos, { 'core' : true, 'origin' : origin, 'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id) })) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            if(obj.parent === new_par.id) {\n                dpc = new_par.children.concat();\n                tmp = $.inArray(obj.id, dpc);\n                if(tmp !== -1) {\n                    dpc = $.vakata.array_remove(dpc, tmp);\n                    if(pos > tmp) { pos--; }\n                }\n                tmp = [];\n                for(i = 0, j = dpc.length; i < j; i++) {\n                    tmp[i >= pos ? i+1 : i] = dpc[i];\n                }\n                tmp[pos] = obj.id;\n                new_par.children = tmp;\n                this._node_changed(new_par.id);\n                this.redraw(new_par.id === $.jstree.root);\n            }\n            else {\n                // clean old parent and up\n                tmp = obj.children_d.concat();\n                tmp.push(obj.id);\n                for(i = 0, j = obj.parents.length; i < j; i++) {\n                    dpc = [];\n                    p = old_ins._model.data[obj.parents[i]].children_d;\n                    for(k = 0, l = p.length; k < l; k++) {\n                        if($.inArray(p[k], tmp) === -1) {\n                            dpc.push(p[k]);\n                        }\n                    }\n                    old_ins._model.data[obj.parents[i]].children_d = dpc;\n                }\n                old_ins._model.data[old_par].children = $.vakata.array_remove_item(old_ins._model.data[old_par].children, obj.id);\n\n                // insert into new parent and up\n                for(i = 0, j = new_par.parents.length; i < j; i++) {\n                    this._model.data[new_par.parents[i]].children_d = this._model.data[new_par.parents[i]].children_d.concat(tmp);\n                }\n                dpc = [];\n                for(i = 0, j = new_par.children.length; i < j; i++) {\n                    dpc[i >= pos ? i+1 : i] = new_par.children[i];\n                }\n                dpc[pos] = obj.id;\n                new_par.children = dpc;\n                new_par.children_d.push(obj.id);\n                new_par.children_d = new_par.children_d.concat(obj.children_d);\n\n                // update object\n                obj.parent = new_par.id;\n                tmp = new_par.parents.concat();\n                tmp.unshift(new_par.id);\n                p = obj.parents.length;\n                obj.parents = tmp;\n\n                // update object children\n                tmp = tmp.concat();\n                for(i = 0, j = obj.children_d.length; i < j; i++) {\n                    this._model.data[obj.children_d[i]].parents = this._model.data[obj.children_d[i]].parents.slice(0,p*-1);\n                    Array.prototype.push.apply(this._model.data[obj.children_d[i]].parents, tmp);\n                }\n\n                if(old_par === $.jstree.root || new_par.id === $.jstree.root) {\n                    this._model.force_full_redraw = true;\n                }\n                if(!this._model.force_full_redraw) {\n                    this._node_changed(old_par);\n                    this._node_changed(new_par.id);\n                }\n                if(!skip_redraw) {\n                    this.redraw();\n                }\n            }\n            if(callback) { callback.call(this, obj, new_par, pos); }\n            /**\n             * triggered when a node is moved\n             * @event\n             * @name move_node.jstree\n             * @param {Object} node\n             * @param {String} parent the parent's ID\n             * @param {Number} position the position of the node among the parent's children\n             * @param {String} old_parent the old parent of the node\n             * @param {Number} old_position the old position of the node\n             * @param {Boolean} is_multi do the node and new parent belong to different instances\n             * @param {jsTree} old_instance the instance the node came from\n             * @param {jsTree} new_instance the instance of the new parent\n             */\n            this.trigger('move_node', { \"node\" : obj, \"parent\" : new_par.id, \"position\" : pos, \"old_parent\" : old_par, \"old_position\" : old_pos, 'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id), 'old_instance' : old_ins, 'new_instance' : this });\n            return obj.id;\n        },\n        /**\n         * copy a node to a new parent\n         * @name copy_node(obj, par [, pos, callback, is_loaded])\n         * @param  {mixed} obj the node to copy, pass an array to copy multiple nodes\n         * @param  {mixed} par the new parent\n         * @param  {mixed} pos the position to insert at (besides integer values, \"first\" and \"last\" are supported, as well as \"before\" and \"after\"), defaults to integer `0`\n         * @param  {function} callback a function to call once the move is completed, receives 3 arguments - the node, the new parent and the position\n         * @param  {Boolean} is_loaded internal parameter indicating if the parent node has been loaded\n         * @param  {Boolean} skip_redraw internal parameter indicating if the tree should be redrawn\n         * @param  {Boolean} instance internal parameter indicating if the node comes from another instance\n         * @trigger model.jstree copy_node.jstree\n         */\n        copy_node : function (obj, par, pos, callback, is_loaded, skip_redraw, origin) {\n            var t1, t2, dpc, tmp, i, j, node, old_par, new_par, old_ins, is_multi;\n\n            par = this.get_node(par);\n            pos = pos === undefined ? 0 : pos;\n            if(!par) { return false; }\n            if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                return this.load_node(par, function () { this.copy_node(obj, par, pos, callback, true, false, origin); });\n            }\n\n            if($.vakata.is_array(obj)) {\n                if(obj.length === 1) {\n                    obj = obj[0];\n                }\n                else {\n                    //obj = obj.slice();\n                    for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                        if((tmp = this.copy_node(obj[t1], par, pos, callback, is_loaded, true, origin))) {\n                            par = tmp;\n                            pos = \"after\";\n                        }\n                    }\n                    this.redraw();\n                    return true;\n                }\n            }\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n\n            old_par = (obj.parent || $.jstree.root).toString();\n            new_par = (!pos.toString().match(/^(before|after)$/) || par.id === $.jstree.root) ? par : this.get_node(par.parent);\n            old_ins = origin ? origin : (this._model.data[obj.id] ? this : $.jstree.reference(obj.id));\n            is_multi = !old_ins || !old_ins._id || (this._id !== old_ins._id);\n\n            if(old_ins && old_ins._id) {\n                obj = old_ins._model.data[obj.id];\n            }\n\n            if(par.id === $.jstree.root) {\n                if(pos === \"before\") { pos = \"first\"; }\n                if(pos === \"after\") { pos = \"last\"; }\n            }\n            switch(pos) {\n                case \"before\":\n                    pos = $.inArray(par.id, new_par.children);\n                    break;\n                case \"after\" :\n                    pos = $.inArray(par.id, new_par.children) + 1;\n                    break;\n                case \"inside\":\n                case \"first\":\n                    pos = 0;\n                    break;\n                case \"last\":\n                    pos = new_par.children.length;\n                    break;\n                default:\n                    if(!pos) { pos = 0; }\n                    break;\n            }\n            if(pos > new_par.children.length) { pos = new_par.children.length; }\n            if(!this.check(\"copy_node\", obj, new_par, pos, { 'core' : true, 'origin' : origin, 'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id) })) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            node = old_ins ? old_ins.get_json(obj, { no_id : true, no_data : true, no_state : true }) : obj;\n            if(!node) { return false; }\n            if(node.id === true) { delete node.id; }\n            node = this._parse_model_from_json(node, new_par.id, new_par.parents.concat());\n            if(!node) { return false; }\n            tmp = this.get_node(node);\n            if(obj && obj.state && obj.state.loaded === false) { tmp.state.loaded = false; }\n            dpc = [];\n            dpc.push(node);\n            dpc = dpc.concat(tmp.children_d);\n            this.trigger('model', { \"nodes\" : dpc, \"parent\" : new_par.id });\n\n            // insert into new parent and up\n            for(i = 0, j = new_par.parents.length; i < j; i++) {\n                this._model.data[new_par.parents[i]].children_d = this._model.data[new_par.parents[i]].children_d.concat(dpc);\n            }\n            dpc = [];\n            for(i = 0, j = new_par.children.length; i < j; i++) {\n                dpc[i >= pos ? i+1 : i] = new_par.children[i];\n            }\n            dpc[pos] = tmp.id;\n            new_par.children = dpc;\n            new_par.children_d.push(tmp.id);\n            new_par.children_d = new_par.children_d.concat(tmp.children_d);\n\n            if(new_par.id === $.jstree.root) {\n                this._model.force_full_redraw = true;\n            }\n            if(!this._model.force_full_redraw) {\n                this._node_changed(new_par.id);\n            }\n            if(!skip_redraw) {\n                this.redraw(new_par.id === $.jstree.root);\n            }\n            if(callback) { callback.call(this, tmp, new_par, pos); }\n            /**\n             * triggered when a node is copied\n             * @event\n             * @name copy_node.jstree\n             * @param {Object} node the copied node\n             * @param {Object} original the original node\n             * @param {String} parent the parent's ID\n             * @param {Number} position the position of the node among the parent's children\n             * @param {String} old_parent the old parent of the node\n             * @param {Number} old_position the position of the original node\n             * @param {Boolean} is_multi do the node and new parent belong to different instances\n             * @param {jsTree} old_instance the instance the node came from\n             * @param {jsTree} new_instance the instance of the new parent\n             */\n            this.trigger('copy_node', { \"node\" : tmp, \"original\" : obj, \"parent\" : new_par.id, \"position\" : pos, \"old_parent\" : old_par, \"old_position\" : old_ins && old_ins._id && old_par && old_ins._model.data[old_par] && old_ins._model.data[old_par].children ? $.inArray(obj.id, old_ins._model.data[old_par].children) : -1,'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id), 'old_instance' : old_ins, 'new_instance' : this });\n            return tmp.id;\n        },\n        /**\n         * cut a node (a later call to `paste(obj)` would move the node)\n         * @name cut(obj)\n         * @param  {mixed} obj multiple objects can be passed using an array\n         * @trigger cut.jstree\n         */\n        cut : function (obj) {\n            if(!obj) { obj = this._data.core.selected.concat(); }\n            if(!$.vakata.is_array(obj)) { obj = [obj]; }\n            if(!obj.length) { return false; }\n            var tmp = [], o, t1, t2;\n            for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                o = this.get_node(obj[t1]);\n                if(o && o.id && o.id !== $.jstree.root) { tmp.push(o); }\n            }\n            if(!tmp.length) { return false; }\n            ccp_node = tmp;\n            ccp_inst = this;\n            ccp_mode = 'move_node';\n            /**\n             * triggered when nodes are added to the buffer for moving\n             * @event\n             * @name cut.jstree\n             * @param {Array} node\n             */\n            this.trigger('cut', { \"node\" : obj });\n        },\n        /**\n         * copy a node (a later call to `paste(obj)` would copy the node)\n         * @name copy(obj)\n         * @param  {mixed} obj multiple objects can be passed using an array\n         * @trigger copy.jstree\n         */\n        copy : function (obj) {\n            if(!obj) { obj = this._data.core.selected.concat(); }\n            if(!$.vakata.is_array(obj)) { obj = [obj]; }\n            if(!obj.length) { return false; }\n            var tmp = [], o, t1, t2;\n            for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                o = this.get_node(obj[t1]);\n                if(o && o.id && o.id !== $.jstree.root) { tmp.push(o); }\n            }\n            if(!tmp.length) { return false; }\n            ccp_node = tmp;\n            ccp_inst = this;\n            ccp_mode = 'copy_node';\n            /**\n             * triggered when nodes are added to the buffer for copying\n             * @event\n             * @name copy.jstree\n             * @param {Array} node\n             */\n            this.trigger('copy', { \"node\" : obj });\n        },\n        /**\n         * get the current buffer (any nodes that are waiting for a paste operation)\n         * @name get_buffer()\n         * @return {Object} an object consisting of `mode` (\"copy_node\" or \"move_node\"), `node` (an array of objects) and `inst` (the instance)\n         */\n        get_buffer : function () {\n            return { 'mode' : ccp_mode, 'node' : ccp_node, 'inst' : ccp_inst };\n        },\n        /**\n         * check if there is something in the buffer to paste\n         * @name can_paste()\n         * @return {Boolean}\n         */\n        can_paste : function () {\n            return ccp_mode !== false && ccp_node !== false; // && ccp_inst._model.data[ccp_node];\n        },\n        /**\n         * copy or move the previously cut or copied nodes to a new parent\n         * @name paste(obj [, pos])\n         * @param  {mixed} obj the new parent\n         * @param  {mixed} pos the position to insert at (besides integer, \"first\" and \"last\" are supported), defaults to integer `0`\n         * @trigger paste.jstree\n         */\n        paste : function (obj, pos) {\n            obj = this.get_node(obj);\n            if(!obj || !ccp_mode || !ccp_mode.match(/^(copy_node|move_node)$/) || !ccp_node) { return false; }\n            if(this[ccp_mode](ccp_node, obj, pos, false, false, false, ccp_inst)) {\n                /**\n                 * triggered when paste is invoked\n                 * @event\n                 * @name paste.jstree\n                 * @param {String} parent the ID of the receiving node\n                 * @param {Array} node the nodes in the buffer\n                 * @param {String} mode the performed operation - \"copy_node\" or \"move_node\"\n                 */\n                this.trigger('paste', { \"parent\" : obj.id, \"node\" : ccp_node, \"mode\" : ccp_mode });\n            }\n            ccp_node = false;\n            ccp_mode = false;\n            ccp_inst = false;\n        },\n        /**\n         * clear the buffer of previously copied or cut nodes\n         * @name clear_buffer()\n         * @trigger clear_buffer.jstree\n         */\n        clear_buffer : function () {\n            ccp_node = false;\n            ccp_mode = false;\n            ccp_inst = false;\n            /**\n             * triggered when the copy / cut buffer is cleared\n             * @event\n             * @name clear_buffer.jstree\n             */\n            this.trigger('clear_buffer');\n        },\n        /**\n         * put a node in edit mode (input field to rename the node)\n         * @name edit(obj [, default_text, callback])\n         * @param  {mixed} obj\n         * @param  {String} default_text the text to populate the input with (if omitted or set to a non-string value the node's text value is used)\n         * @param  {Function} callback a function to be called once the text box is blurred, it is called in the instance's scope and receives the node, a status parameter (true if the rename is successful, false otherwise), a boolean indicating if the user cancelled the edit and the original unescaped value provided by the user. You can also access the node's title using .text\n         */\n        edit : function (obj, default_text, callback) {\n            var rtl, w, a, s, t, h1, h2, fn, tmp, cancel = false;\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            if(!this.check(\"edit\", obj, this.get_parent(obj))) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            tmp = obj;\n            default_text = typeof default_text === 'string' ? default_text : obj.text;\n            this.set_text(obj, \"\");\n            obj = this._open_to(obj);\n            tmp.text = default_text;\n\n            rtl = this._data.core.rtl;\n            w  = this.element.width();\n            this._data.core.focused = tmp.id;\n            a  = obj.children('.jstree-anchor').trigger('focus');\n            s  = $('<span></span>');\n            /*!\n\t\t\toi = obj.children(\"i:visible\"),\n\t\t\tai = a.children(\"i:visible\"),\n\t\t\tw1 = oi.width() * oi.length,\n\t\t\tw2 = ai.width() * ai.length,\n\t\t\t*/\n            t  = default_text;\n            h1 = $(\"<\"+\"div></div>\", { css : { \"position\" : \"absolute\", \"top\" : \"-200px\", \"left\" : (rtl ? \"0px\" : \"-1000px\"), \"visibility\" : \"hidden\" } }).appendTo(document.body);\n            h2 = $(\"<\"+\"input />\", {\n                \"value\" : t,\n                \"class\" : \"jstree-rename-input\",\n                // \"size\" : t.length,\n                \"css\" : {\n                    \"padding\" : \"0\",\n                    \"border\" : \"1px solid silver\",\n                    \"box-sizing\" : \"border-box\",\n                    \"display\" : \"inline-block\",\n                    \"height\" : (this._data.core.li_height) + \"px\",\n                    \"lineHeight\" : (this._data.core.li_height) + \"px\",\n                    \"width\" : \"150px\" // will be set a bit further down\n                },\n                \"blur\" : function (e) {\n                    e.stopImmediatePropagation();\n                    e.preventDefault();\n                    var i = s.children(\".jstree-rename-input\"),\n                        v = i.val(),\n                        f = this.settings.core.force_text,\n                        nv;\n                    if(v === \"\") { v = t; }\n                    h1.remove();\n                    s.replaceWith(a);\n                    s.remove();\n                    t = f ? t : $('<div></div>').append($.parseHTML(t)).html();\n                    obj = this.get_node(obj);\n                    this.set_text(obj, t);\n                    nv = !!this.rename_node(obj, f ? $('<div></div>').text(v).text() : $('<div></div>').append($.parseHTML(v)).html());\n                    if(!nv) {\n                        this.set_text(obj, t); // move this up? and fix #483\n                    }\n                    this._data.core.focused = tmp.id;\n                    setTimeout(function () {\n                        var node = this.get_node(tmp.id, true);\n                        if(node.length) {\n                            this._data.core.focused = tmp.id;\n                            node.children('.jstree-anchor').trigger('focus');\n                        }\n                    }.bind(this), 0);\n                    if(callback) {\n                        callback.call(this, tmp, nv, cancel, v);\n                    }\n                    h2 = null;\n                }.bind(this),\n                \"keydown\" : function (e) {\n                    var key = e.which;\n                    if(key === 27) {\n                        cancel = true;\n                        this.value = t;\n                    }\n                    if(key === 27 || key === 13 || key === 37 || key === 38 || key === 39 || key === 40 || key === 32) {\n                        e.stopImmediatePropagation();\n                    }\n                    if(key === 27 || key === 13) {\n                        e.preventDefault();\n                        this.blur();\n                    }\n                },\n                \"click\" : function (e) { e.stopImmediatePropagation(); },\n                \"mousedown\" : function (e) { e.stopImmediatePropagation(); },\n                \"keyup\" : function (e) {\n                    h2.width(Math.min(h1.text(\"pW\" + this.value).width(),w));\n                },\n                \"keypress\" : function(e) {\n                    if(e.which === 13) { return false; }\n                }\n            });\n            fn = {\n                fontFamily\t\t: a.css('fontFamily')\t\t|| '',\n                fontSize\t\t: a.css('fontSize')\t\t\t|| '',\n                fontWeight\t\t: a.css('fontWeight')\t\t|| '',\n                fontStyle\t\t: a.css('fontStyle')\t\t|| '',\n                fontStretch\t\t: a.css('fontStretch')\t\t|| '',\n                fontVariant\t\t: a.css('fontVariant')\t\t|| '',\n                letterSpacing\t: a.css('letterSpacing')\t|| '',\n                wordSpacing\t\t: a.css('wordSpacing')\t\t|| ''\n            };\n            s.attr('class', a.attr('class')).append(a.contents().clone()).append(h2);\n            a.replaceWith(s);\n            h1.css(fn);\n            h2.css(fn).width(Math.min(h1.text(\"pW\" + h2[0].value).width(),w))[0].select();\n            $(document).one('mousedown.jstree touchstart.jstree dnd_start.vakata', function (e) {\n                if (h2 && e.target !== h2) {\n                    $(h2).trigger('blur');\n                }\n            });\n        },\n\n\n        /**\n         * changes the theme\n         * @name set_theme(theme_name [, theme_url])\n         * @param {String} theme_name the name of the new theme to apply\n         * @param {mixed} theme_url  the location of the CSS file for this theme. Omit or set to `false` if you manually included the file. Set to `true` to autoload from the `core.themes.dir` directory.\n         * @trigger set_theme.jstree\n         */\n        set_theme : function (theme_name, theme_url) {\n            if(!theme_name) { return false; }\n            if(theme_url === true) {\n                var dir = this.settings.core.themes.dir;\n                if(!dir) { dir = $.jstree.path + '/themes'; }\n                theme_url = dir + '/' + theme_name + '/style.css';\n            }\n            if(theme_url && $.inArray(theme_url, themes_loaded) === -1) {\n                $('head').append('<'+'link rel=\"stylesheet\" href=\"' + theme_url + '\" type=\"text/css\" />');\n                themes_loaded.push(theme_url);\n            }\n            if(this._data.core.themes.name) {\n                this.element.removeClass('jstree-' + this._data.core.themes.name);\n            }\n            this._data.core.themes.name = theme_name;\n            this.element.addClass('jstree-' + theme_name);\n            this.element[this.settings.core.themes.responsive ? 'addClass' : 'removeClass' ]('jstree-' + theme_name + '-responsive');\n            /**\n             * triggered when a theme is set\n             * @event\n             * @name set_theme.jstree\n             * @param {String} theme the new theme\n             */\n            this.trigger('set_theme', { 'theme' : theme_name });\n        },\n        /**\n         * gets the name of the currently applied theme name\n         * @name get_theme()\n         * @return {String}\n         */\n        get_theme : function () { return this._data.core.themes.name; },\n        /**\n         * changes the theme variant (if the theme has variants)\n         * @name set_theme_variant(variant_name)\n         * @param {String|Boolean} variant_name the variant to apply (if `false` is used the current variant is removed)\n         */\n        set_theme_variant : function (variant_name) {\n            if(this._data.core.themes.variant) {\n                this.element.removeClass('jstree-' + this._data.core.themes.name + '-' + this._data.core.themes.variant);\n            }\n            this._data.core.themes.variant = variant_name;\n            if(variant_name) {\n                this.element.addClass('jstree-' + this._data.core.themes.name + '-' + this._data.core.themes.variant);\n            }\n        },\n        /**\n         * gets the name of the currently applied theme variant\n         * @name get_theme()\n         * @return {String}\n         */\n        get_theme_variant : function () { return this._data.core.themes.variant; },\n        /**\n         * shows a striped background on the container (if the theme supports it)\n         * @name show_stripes()\n         */\n        show_stripes : function () {\n            this._data.core.themes.stripes = true;\n            this.get_container_ul().addClass(\"jstree-striped\");\n            /**\n             * triggered when stripes are shown\n             * @event\n             * @name show_stripes.jstree\n             */\n            this.trigger('show_stripes');\n        },\n        /**\n         * hides the striped background on the container\n         * @name hide_stripes()\n         */\n        hide_stripes : function () {\n            this._data.core.themes.stripes = false;\n            this.get_container_ul().removeClass(\"jstree-striped\");\n            /**\n             * triggered when stripes are hidden\n             * @event\n             * @name hide_stripes.jstree\n             */\n            this.trigger('hide_stripes');\n        },\n        /**\n         * toggles the striped background on the container\n         * @name toggle_stripes()\n         */\n        toggle_stripes : function () { if(this._data.core.themes.stripes) { this.hide_stripes(); } else { this.show_stripes(); } },\n        /**\n         * shows the connecting dots (if the theme supports it)\n         * @name show_dots()\n         */\n        show_dots : function () {\n            this._data.core.themes.dots = true;\n            this.get_container_ul().removeClass(\"jstree-no-dots\");\n            /**\n             * triggered when dots are shown\n             * @event\n             * @name show_dots.jstree\n             */\n            this.trigger('show_dots');\n        },\n        /**\n         * hides the connecting dots\n         * @name hide_dots()\n         */\n        hide_dots : function () {\n            this._data.core.themes.dots = false;\n            this.get_container_ul().addClass(\"jstree-no-dots\");\n            /**\n             * triggered when dots are hidden\n             * @event\n             * @name hide_dots.jstree\n             */\n            this.trigger('hide_dots');\n        },\n        /**\n         * toggles the connecting dots\n         * @name toggle_dots()\n         */\n        toggle_dots : function () { if(this._data.core.themes.dots) { this.hide_dots(); } else { this.show_dots(); } },\n        /**\n         * show the node icons\n         * @name show_icons()\n         */\n        show_icons : function () {\n            this._data.core.themes.icons = true;\n            this.get_container_ul().removeClass(\"jstree-no-icons\");\n            /**\n             * triggered when icons are shown\n             * @event\n             * @name show_icons.jstree\n             */\n            this.trigger('show_icons');\n        },\n        /**\n         * hide the node icons\n         * @name hide_icons()\n         */\n        hide_icons : function () {\n            this._data.core.themes.icons = false;\n            this.get_container_ul().addClass(\"jstree-no-icons\");\n            /**\n             * triggered when icons are hidden\n             * @event\n             * @name hide_icons.jstree\n             */\n            this.trigger('hide_icons');\n        },\n        /**\n         * toggle the node icons\n         * @name toggle_icons()\n         */\n        toggle_icons : function () { if(this._data.core.themes.icons) { this.hide_icons(); } else { this.show_icons(); } },\n        /**\n         * show the node ellipsis\n         * @name show_icons()\n         */\n        show_ellipsis : function () {\n            this._data.core.themes.ellipsis = true;\n            this.get_container_ul().addClass(\"jstree-ellipsis\");\n            /**\n             * triggered when ellisis is shown\n             * @event\n             * @name show_ellipsis.jstree\n             */\n            this.trigger('show_ellipsis');\n        },\n        /**\n         * hide the node ellipsis\n         * @name hide_ellipsis()\n         */\n        hide_ellipsis : function () {\n            this._data.core.themes.ellipsis = false;\n            this.get_container_ul().removeClass(\"jstree-ellipsis\");\n            /**\n             * triggered when ellisis is hidden\n             * @event\n             * @name hide_ellipsis.jstree\n             */\n            this.trigger('hide_ellipsis');\n        },\n        /**\n         * toggle the node ellipsis\n         * @name toggle_icons()\n         */\n        toggle_ellipsis : function () { if(this._data.core.themes.ellipsis) { this.hide_ellipsis(); } else { this.show_ellipsis(); } },\n        /**\n         * set the node icon for a node\n         * @name set_icon(obj, icon)\n         * @param {mixed} obj\n         * @param {String} icon the new icon - can be a path to an icon or a className, if using an image that is in the current directory use a `./` prefix, otherwise it will be detected as a class\n         */\n        set_icon : function (obj, icon) {\n            var t1, t2, dom, old;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.set_icon(obj[t1], icon);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            old = obj.icon;\n            obj.icon = icon === true || icon === null || icon === undefined || icon === '' ? true : icon;\n            dom = this.get_node(obj, true).children(\".jstree-anchor\").children(\".jstree-themeicon\");\n            if(icon === false) {\n                dom.removeClass('jstree-themeicon-custom ' + old).css(\"background\",\"\").removeAttr(\"rel\");\n                this.hide_icon(obj);\n            }\n            else if(icon === true || icon === null || icon === undefined || icon === '') {\n                dom.removeClass('jstree-themeicon-custom ' + old).css(\"background\",\"\").removeAttr(\"rel\");\n                if(old === false) { this.show_icon(obj); }\n            }\n            else if(icon.indexOf(\"/\") === -1 && icon.indexOf(\".\") === -1) {\n                dom.removeClass(old).css(\"background\",\"\");\n                dom.addClass(icon + ' jstree-themeicon-custom').attr(\"rel\",icon);\n                if(old === false) { this.show_icon(obj); }\n            }\n            else {\n                dom.removeClass(old).css(\"background\",\"\");\n                dom.addClass('jstree-themeicon-custom').css(\"background\", \"url('\" + icon + \"') center center no-repeat\").attr(\"rel\",icon);\n                if(old === false) { this.show_icon(obj); }\n            }\n            return true;\n        },\n        /**\n         * get the node icon for a node\n         * @name get_icon(obj)\n         * @param {mixed} obj\n         * @return {String}\n         */\n        get_icon : function (obj) {\n            obj = this.get_node(obj);\n            return (!obj || obj.id === $.jstree.root) ? false : obj.icon;\n        },\n        /**\n         * hide the icon on an individual node\n         * @name hide_icon(obj)\n         * @param {mixed} obj\n         */\n        hide_icon : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.hide_icon(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj === $.jstree.root) { return false; }\n            obj.icon = false;\n            this.get_node(obj, true).children(\".jstree-anchor\").children(\".jstree-themeicon\").addClass('jstree-themeicon-hidden');\n            return true;\n        },\n        /**\n         * show the icon on an individual node\n         * @name show_icon(obj)\n         * @param {mixed} obj\n         */\n        show_icon : function (obj) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.show_icon(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj === $.jstree.root) { return false; }\n            dom = this.get_node(obj, true);\n            obj.icon = dom.length ? dom.children(\".jstree-anchor\").children(\".jstree-themeicon\").attr('rel') : true;\n            if(!obj.icon) { obj.icon = true; }\n            dom.children(\".jstree-anchor\").children(\".jstree-themeicon\").removeClass('jstree-themeicon-hidden');\n            return true;\n        }\n    };\n\n    // helpers\n    $.vakata = {};\n    // collect attributes\n    $.vakata.attributes = function(node, with_values) {\n        node = $(node)[0];\n        var attr = with_values ? {} : [];\n        if(node && node.attributes) {\n            $.each(node.attributes, function (i, v) {\n                if($.inArray(v.name.toLowerCase(),['style','contenteditable','hasfocus','tabindex']) !== -1) { return; }\n                if(v.value !== null && $.vakata.trim(v.value) !== '') {\n                    if(with_values) { attr[v.name] = v.value; }\n                    else { attr.push(v.name); }\n                }\n            });\n        }\n        return attr;\n    };\n    $.vakata.array_unique = function(array) {\n        var a = [], i, j, l, o = {};\n        for(i = 0, l = array.length; i < l; i++) {\n            if(o[array[i]] === undefined) {\n                a.push(array[i]);\n                o[array[i]] = true;\n            }\n        }\n        return a;\n    };\n    // remove item from array\n    $.vakata.array_remove = function(array, from) {\n        array.splice(from, 1);\n        return array;\n        //var rest = array.slice((to || from) + 1 || array.length);\n        //array.length = from < 0 ? array.length + from : from;\n        //array.push.apply(array, rest);\n        //return array;\n    };\n    // remove item from array\n    $.vakata.array_remove_item = function(array, item) {\n        var tmp = $.inArray(item, array);\n        return tmp !== -1 ? $.vakata.array_remove(array, tmp) : array;\n    };\n    $.vakata.array_filter = function(c,a,b,d,e) {\n        if (c.filter) {\n            return c.filter(a, b);\n        }\n        d=[];\n        for (e in c) {\n            if (~~e+''===e+'' && e>=0 && a.call(b,c[e],+e,c)) {\n                d.push(c[e]);\n            }\n        }\n        return d;\n    };\n    $.vakata.trim = function (text) {\n        return String.prototype.trim ?\n            String.prototype.trim.call(text.toString()) :\n            text.toString().replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n    };\n    $.vakata.is_function = function(obj) {\n        return typeof obj === \"function\" && typeof obj.nodeType !== \"number\";\n    };\n    $.vakata.is_array = Array.isArray || function (obj) {\n        return Object.prototype.toString.call(obj) === \"[object Array]\";\n    };\n\n    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_objects/Function/bind#polyfill\n    if (!Function.prototype.bind) {\n        Function.prototype.bind = function () {\n            var thatFunc = this, thatArg = arguments[0];\n            var args = Array.prototype.slice.call(arguments, 1);\n            if (typeof thatFunc !== 'function') {\n                // closest thing possible to the ECMAScript 5\n                // internal IsCallable function\n                throw new TypeError('Function.prototype.bind - what is trying to be bound is not callable');\n            }\n            return function(){\n                var funcArgs = args.concat(Array.prototype.slice.call(arguments));\n                return thatFunc.apply(thatArg, funcArgs);\n            };\n        };\n    }\n\n\n    /**\n     * ### Changed plugin\n     *\n     * This plugin adds more information to the `changed.jstree` event. The new data is contained in the `changed` event data property, and contains a lists of `selected` and `deselected` nodes.\n     */\n\n    $.jstree.plugins.changed = function (options, parent) {\n        var last = [];\n        this.trigger = function (ev, data) {\n            var i, j;\n            if(!data) {\n                data = {};\n            }\n            if(ev.replace('.jstree','') === 'changed') {\n                data.changed = { selected : [], deselected : [] };\n                var tmp = {};\n                for(i = 0, j = last.length; i < j; i++) {\n                    tmp[last[i]] = 1;\n                }\n                for(i = 0, j = data.selected.length; i < j; i++) {\n                    if(!tmp[data.selected[i]]) {\n                        data.changed.selected.push(data.selected[i]);\n                    }\n                    else {\n                        tmp[data.selected[i]] = 2;\n                    }\n                }\n                for(i = 0, j = last.length; i < j; i++) {\n                    if(tmp[last[i]] === 1) {\n                        data.changed.deselected.push(last[i]);\n                    }\n                }\n                last = data.selected.slice();\n            }\n            /**\n             * triggered when selection changes (the \"changed\" plugin enhances the original event with more data)\n             * @event\n             * @name changed.jstree\n             * @param {Object} node\n             * @param {Object} action the action that caused the selection to change\n             * @param {Array} selected the current selection\n             * @param {Object} changed an object containing two properties `selected` and `deselected` - both arrays of node IDs, which were selected or deselected since the last changed event\n             * @param {Object} event the event (if any) that triggered this changed event\n             * @plugin changed\n             */\n            parent.trigger.call(this, ev, data);\n        };\n        this.refresh = function (skip_loading, forget_state) {\n            last = [];\n            return parent.refresh.apply(this, arguments);\n        };\n    };\n\n    /**\n     * ### Checkbox plugin\n     *\n     * This plugin renders checkbox icons in front of each node, making multiple selection much easier.\n     * It also supports tri-state behavior, meaning that if a node has a few of its children checked it will be rendered as undetermined, and state will be propagated up.\n     */\n\n    var _i = document.createElement('I');\n    _i.className = 'jstree-icon jstree-checkbox';\n    _i.setAttribute('role', 'presentation');\n    /**\n     * stores all defaults for the checkbox plugin\n     * @name $.jstree.defaults.checkbox\n     * @plugin checkbox\n     */\n    $.jstree.defaults.checkbox = {\n        /**\n         * a boolean indicating if checkboxes should be visible (can be changed at a later time using `show_checkboxes()` and `hide_checkboxes`). Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.visible\n         * @plugin checkbox\n         */\n        visible\t\t\t\t: true,\n        /**\n         * a boolean indicating if checkboxes should cascade down and have an undetermined state. Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.three_state\n         * @plugin checkbox\n         */\n        three_state\t\t\t: true,\n        /**\n         * a boolean indicating if clicking anywhere on the node should act as clicking on the checkbox. Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.whole_node\n         * @plugin checkbox\n         */\n        whole_node\t\t\t: true,\n        /**\n         * a boolean indicating if the selected style of a node should be kept, or removed. Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.keep_selected_style\n         * @plugin checkbox\n         */\n        keep_selected_style\t: true,\n        /**\n         * This setting controls how cascading and undetermined nodes are applied.\n         * If 'up' is in the string - cascading up is enabled, if 'down' is in the string - cascading down is enabled, if 'undetermined' is in the string - undetermined nodes will be used.\n         * If `three_state` is set to `true` this setting is automatically set to 'up+down+undetermined'. Defaults to ''.\n         * @name $.jstree.defaults.checkbox.cascade\n         * @plugin checkbox\n         */\n        cascade\t\t\t\t: '',\n        /**\n         * This setting controls if checkbox are bound to the general tree selection or to an internal array maintained by the checkbox plugin. Defaults to `true`, only set to `false` if you know exactly what you are doing.\n         * @name $.jstree.defaults.checkbox.tie_selection\n         * @plugin checkbox\n         */\n        tie_selection\t\t: true,\n\n        /**\n         * This setting controls if cascading down affects disabled checkboxes\n         * @name $.jstree.defaults.checkbox.cascade_to_disabled\n         * @plugin checkbox\n         */\n        cascade_to_disabled : true,\n\n        /**\n         * This setting controls if cascading down affects hidden checkboxes\n         * @name $.jstree.defaults.checkbox.cascade_to_hidden\n         * @plugin checkbox\n         */\n        cascade_to_hidden : true\n    };\n    $.jstree.plugins.checkbox = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n            this._data.checkbox.uto = false;\n            this._data.checkbox.selected = [];\n            if(this.settings.checkbox.three_state) {\n                this.settings.checkbox.cascade = 'up+down+undetermined';\n            }\n            this.element\n                .on(\"init.jstree\", function () {\n                    this._data.checkbox.visible = this.settings.checkbox.visible;\n                    if(!this.settings.checkbox.keep_selected_style) {\n                        this.element.addClass('jstree-checkbox-no-clicked');\n                    }\n                    if(this.settings.checkbox.tie_selection) {\n                        this.element.addClass('jstree-checkbox-selection');\n                    }\n                }.bind(this))\n                .on(\"loading.jstree\", function () {\n                    this[ this._data.checkbox.visible ? 'show_checkboxes' : 'hide_checkboxes' ]();\n                }.bind(this));\n            if(this.settings.checkbox.cascade.indexOf('undetermined') !== -1) {\n                this.element\n                    .on('changed.jstree uncheck_node.jstree check_node.jstree uncheck_all.jstree check_all.jstree move_node.jstree copy_node.jstree redraw.jstree open_node.jstree', function () {\n                        // only if undetermined is in setting\n                        if(this._data.checkbox.uto) { clearTimeout(this._data.checkbox.uto); }\n                        this._data.checkbox.uto = setTimeout(this._undetermined.bind(this), 50);\n                    }.bind(this));\n            }\n            if(!this.settings.checkbox.tie_selection) {\n                this.element\n                    .on('model.jstree', function (e, data) {\n                        var m = this._model.data,\n                            p = m[data.parent],\n                            dpc = data.nodes,\n                            i, j;\n                        for(i = 0, j = dpc.length; i < j; i++) {\n                            m[dpc[i]].state.checked = m[dpc[i]].state.checked || (m[dpc[i]].original && m[dpc[i]].original.state && m[dpc[i]].original.state.checked);\n                            if(m[dpc[i]].state.checked) {\n                                this._data.checkbox.selected.push(dpc[i]);\n                            }\n                        }\n                    }.bind(this));\n            }\n            if(this.settings.checkbox.cascade.indexOf('up') !== -1 || this.settings.checkbox.cascade.indexOf('down') !== -1) {\n                this.element\n                    .on('model.jstree', function (e, data) {\n                        var m = this._model.data,\n                            p = m[data.parent],\n                            dpc = data.nodes,\n                            chd = [],\n                            c, i, j, k, l, tmp, s = this.settings.checkbox.cascade, t = this.settings.checkbox.tie_selection;\n\n                        if(s.indexOf('down') !== -1) {\n                            // apply down\n                            if(p.state[ t ? 'selected' : 'checked' ]) {\n                                for(i = 0, j = dpc.length; i < j; i++) {\n                                    m[dpc[i]].state[ t ? 'selected' : 'checked' ] = true;\n                                }\n\n                                this._data[ t ? 'core' : 'checkbox' ].selected = this._data[ t ? 'core' : 'checkbox' ].selected.concat(dpc);\n                            }\n                            else {\n                                for(i = 0, j = dpc.length; i < j; i++) {\n                                    if(m[dpc[i]].state[ t ? 'selected' : 'checked' ]) {\n                                        for(k = 0, l = m[dpc[i]].children_d.length; k < l; k++) {\n                                            m[m[dpc[i]].children_d[k]].state[ t ? 'selected' : 'checked' ] = true;\n                                        }\n                                        this._data[ t ? 'core' : 'checkbox' ].selected = this._data[ t ? 'core' : 'checkbox' ].selected.concat(m[dpc[i]].children_d);\n                                    }\n                                }\n                            }\n                        }\n\n                        if(s.indexOf('up') !== -1) {\n                            // apply up\n                            for(i = 0, j = p.children_d.length; i < j; i++) {\n                                if(!m[p.children_d[i]].children.length) {\n                                    chd.push(m[p.children_d[i]].parent);\n                                }\n                            }\n                            chd = $.vakata.array_unique(chd);\n                            for(k = 0, l = chd.length; k < l; k++) {\n                                p = m[chd[k]];\n                                while(p && p.id !== $.jstree.root) {\n                                    c = 0;\n                                    for(i = 0, j = p.children.length; i < j; i++) {\n                                        c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                                    }\n                                    if(c === j) {\n                                        p.state[ t ? 'selected' : 'checked' ] = true;\n                                        this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                        tmp = this.get_node(p, true);\n                                        if(tmp && tmp.length) {\n                                            tmp.attr('aria-selected', true).children('.jstree-anchor').addClass( t ? 'jstree-clicked' : 'jstree-checked');\n                                        }\n                                    }\n                                    else {\n                                        break;\n                                    }\n                                    p = this.get_node(p.parent);\n                                }\n                            }\n                        }\n\n                        this._data[ t ? 'core' : 'checkbox' ].selected = $.vakata.array_unique(this._data[ t ? 'core' : 'checkbox' ].selected);\n                    }.bind(this))\n                    .on(this.settings.checkbox.tie_selection ? 'select_node.jstree' : 'check_node.jstree', function (e, data) {\n                        var self = this,\n                            obj = data.node,\n                            m = this._model.data,\n                            par = this.get_node(obj.parent),\n                            i, j, c, tmp, s = this.settings.checkbox.cascade, t = this.settings.checkbox.tie_selection,\n                            sel = {}, cur = this._data[ t ? 'core' : 'checkbox' ].selected;\n\n                        for (i = 0, j = cur.length; i < j; i++) {\n                            sel[cur[i]] = true;\n                        }\n\n                        // apply down\n                        if(s.indexOf('down') !== -1) {\n                            //this._data[ t ? 'core' : 'checkbox' ].selected = $.vakata.array_unique(this._data[ t ? 'core' : 'checkbox' ].selected.concat(obj.children_d));\n                            var selectedIds = this._cascade_new_checked_state(obj.id, true);\n                            var temp = obj.children_d.concat(obj.id);\n                            for (i = 0, j = temp.length; i < j; i++) {\n                                if (selectedIds.indexOf(temp[i]) > -1) {\n                                    sel[temp[i]] = true;\n                                }\n                                else {\n                                    delete sel[temp[i]];\n                                }\n                            }\n                        }\n\n                        // apply up\n                        if(s.indexOf('up') !== -1) {\n                            while(par && par.id !== $.jstree.root) {\n                                c = 0;\n                                for(i = 0, j = par.children.length; i < j; i++) {\n                                    c += m[par.children[i]].state[ t ? 'selected' : 'checked' ];\n                                }\n                                if(c === j) {\n                                    par.state[ t ? 'selected' : 'checked' ] = true;\n                                    sel[par.id] = true;\n                                    //this._data[ t ? 'core' : 'checkbox' ].selected.push(par.id);\n                                    tmp = this.get_node(par, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                                else {\n                                    break;\n                                }\n                                par = this.get_node(par.parent);\n                            }\n                        }\n\n                        cur = [];\n                        for (i in sel) {\n                            if (sel.hasOwnProperty(i)) {\n                                cur.push(i);\n                            }\n                        }\n                        this._data[ t ? 'core' : 'checkbox' ].selected = cur;\n                    }.bind(this))\n                    .on(this.settings.checkbox.tie_selection ? 'deselect_all.jstree' : 'uncheck_all.jstree', function (e, data) {\n                        var obj = this.get_node($.jstree.root),\n                            m = this._model.data,\n                            i, j, tmp;\n                        for(i = 0, j = obj.children_d.length; i < j; i++) {\n                            tmp = m[obj.children_d[i]];\n                            if(tmp && tmp.original && tmp.original.state && tmp.original.state.undetermined) {\n                                tmp.original.state.undetermined = false;\n                            }\n                        }\n                    }.bind(this))\n                    .on(this.settings.checkbox.tie_selection ? 'deselect_node.jstree' : 'uncheck_node.jstree', function (e, data) {\n                        var self = this,\n                            obj = data.node,\n                            dom = this.get_node(obj, true),\n                            i, j, tmp, s = this.settings.checkbox.cascade, t = this.settings.checkbox.tie_selection,\n                            cur = this._data[ t ? 'core' : 'checkbox' ].selected, sel = {},\n                            stillSelectedIds = [],\n                            allIds = obj.children_d.concat(obj.id);\n\n                        // apply down\n                        if(s.indexOf('down') !== -1) {\n                            var selectedIds = this._cascade_new_checked_state(obj.id, false);\n\n                            cur = $.vakata.array_filter(cur, function(id) {\n                                return allIds.indexOf(id) === -1 || selectedIds.indexOf(id) > -1;\n                            });\n                        }\n\n                        // only apply up if cascade up is enabled and if this node is not selected\n                        // (if all child nodes are disabled and cascade_to_disabled === false then this node will till be selected).\n                        if(s.indexOf('up') !== -1 && cur.indexOf(obj.id) === -1) {\n                            for(i = 0, j = obj.parents.length; i < j; i++) {\n                                tmp = this._model.data[obj.parents[i]];\n                                tmp.state[ t ? 'selected' : 'checked' ] = false;\n                                if(tmp && tmp.original && tmp.original.state && tmp.original.state.undetermined) {\n                                    tmp.original.state.undetermined = false;\n                                }\n                                tmp = this.get_node(obj.parents[i], true);\n                                if(tmp && tmp.length) {\n                                    tmp.attr('aria-selected', false).children('.jstree-anchor').removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                }\n                            }\n\n                            cur = $.vakata.array_filter(cur, function(id) {\n                                return obj.parents.indexOf(id) === -1;\n                            });\n                        }\n\n                        this._data[ t ? 'core' : 'checkbox' ].selected = cur;\n                    }.bind(this));\n            }\n            if(this.settings.checkbox.cascade.indexOf('up') !== -1) {\n                this.element\n                    .on('delete_node.jstree', function (e, data) {\n                        // apply up (whole handler)\n                        var p = this.get_node(data.parent),\n                            m = this._model.data,\n                            i, j, c, tmp, t = this.settings.checkbox.tie_selection;\n                        while(p && p.id !== $.jstree.root && !p.state[ t ? 'selected' : 'checked' ]) {\n                            c = 0;\n                            for(i = 0, j = p.children.length; i < j; i++) {\n                                c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                            }\n                            if(j > 0 && c === j) {\n                                p.state[ t ? 'selected' : 'checked' ] = true;\n                                this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                tmp = this.get_node(p, true);\n                                if(tmp && tmp.length) {\n                                    tmp.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                }\n                            }\n                            else {\n                                break;\n                            }\n                            p = this.get_node(p.parent);\n                        }\n                    }.bind(this))\n                    .on('move_node.jstree', function (e, data) {\n                        // apply up (whole handler)\n                        var is_multi = data.is_multi,\n                            old_par = data.old_parent,\n                            new_par = this.get_node(data.parent),\n                            m = this._model.data,\n                            p, c, i, j, tmp, t = this.settings.checkbox.tie_selection;\n                        if(!is_multi) {\n                            p = this.get_node(old_par);\n                            while(p && p.id !== $.jstree.root && !p.state[ t ? 'selected' : 'checked' ]) {\n                                c = 0;\n                                for(i = 0, j = p.children.length; i < j; i++) {\n                                    c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                                }\n                                if(j > 0 && c === j) {\n                                    p.state[ t ? 'selected' : 'checked' ] = true;\n                                    this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                    tmp = this.get_node(p, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                                else {\n                                    break;\n                                }\n                                p = this.get_node(p.parent);\n                            }\n                        }\n                        p = new_par;\n                        while(p && p.id !== $.jstree.root) {\n                            c = 0;\n                            for(i = 0, j = p.children.length; i < j; i++) {\n                                c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                            }\n                            if(c === j) {\n                                if(!p.state[ t ? 'selected' : 'checked' ]) {\n                                    p.state[ t ? 'selected' : 'checked' ] = true;\n                                    this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                    tmp = this.get_node(p, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                            }\n                            else {\n                                if(p.state[ t ? 'selected' : 'checked' ]) {\n                                    p.state[ t ? 'selected' : 'checked' ] = false;\n                                    this._data[ t ? 'core' : 'checkbox' ].selected = $.vakata.array_remove_item(this._data[ t ? 'core' : 'checkbox' ].selected, p.id);\n                                    tmp = this.get_node(p, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.attr('aria-selected', false).children('.jstree-anchor').removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                                else {\n                                    break;\n                                }\n                            }\n                            p = this.get_node(p.parent);\n                        }\n                    }.bind(this));\n            }\n        };\n        /**\n         * get an array of all nodes whose state is \"undetermined\"\n         * @name get_undetermined([full])\n         * @param  {boolean} full: if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_undetermined = function (full) {\n            if (this.settings.checkbox.cascade.indexOf('undetermined') === -1) {\n                return [];\n            }\n            var i, j, k, l, o = {}, m = this._model.data, t = this.settings.checkbox.tie_selection, s = this._data[ t ? 'core' : 'checkbox' ].selected, p = [], tt = this, r = [];\n            for(i = 0, j = s.length; i < j; i++) {\n                if(m[s[i]] && m[s[i]].parents) {\n                    for(k = 0, l = m[s[i]].parents.length; k < l; k++) {\n                        if(o[m[s[i]].parents[k]] !== undefined) {\n                            break;\n                        }\n                        if(m[s[i]].parents[k] !== $.jstree.root) {\n                            o[m[s[i]].parents[k]] = true;\n                            p.push(m[s[i]].parents[k]);\n                        }\n                    }\n                }\n            }\n            // attempt for server side undetermined state\n            this.element.find('.jstree-closed').not(':has(.jstree-children)')\n                .each(function () {\n                    var tmp = tt.get_node(this), tmp2;\n\n                    if(!tmp) { return; }\n\n                    if(!tmp.state.loaded) {\n                        if(tmp.original && tmp.original.state && tmp.original.state.undetermined && tmp.original.state.undetermined === true) {\n                            if(o[tmp.id] === undefined && tmp.id !== $.jstree.root) {\n                                o[tmp.id] = true;\n                                p.push(tmp.id);\n                            }\n                            for(k = 0, l = tmp.parents.length; k < l; k++) {\n                                if(o[tmp.parents[k]] === undefined && tmp.parents[k] !== $.jstree.root) {\n                                    o[tmp.parents[k]] = true;\n                                    p.push(tmp.parents[k]);\n                                }\n                            }\n                        }\n                    }\n                    else {\n                        for(i = 0, j = tmp.children_d.length; i < j; i++) {\n                            tmp2 = m[tmp.children_d[i]];\n                            if(!tmp2.state.loaded && tmp2.original && tmp2.original.state && tmp2.original.state.undetermined && tmp2.original.state.undetermined === true) {\n                                if(o[tmp2.id] === undefined && tmp2.id !== $.jstree.root) {\n                                    o[tmp2.id] = true;\n                                    p.push(tmp2.id);\n                                }\n                                for(k = 0, l = tmp2.parents.length; k < l; k++) {\n                                    if(o[tmp2.parents[k]] === undefined && tmp2.parents[k] !== $.jstree.root) {\n                                        o[tmp2.parents[k]] = true;\n                                        p.push(tmp2.parents[k]);\n                                    }\n                                }\n                            }\n                        }\n                    }\n                });\n            for (i = 0, j = p.length; i < j; i++) {\n                if(!m[p[i]].state[ t ? 'selected' : 'checked' ]) {\n                    r.push(full ? m[p[i]] : p[i]);\n                }\n            }\n            return r;\n        };\n        /**\n         * set the undetermined state where and if necessary. Used internally.\n         * @private\n         * @name _undetermined()\n         * @plugin checkbox\n         */\n        this._undetermined = function () {\n            if(this.element === null) { return; }\n            var p = this.get_undetermined(false), i, j, s;\n\n            this.element.find('.jstree-undetermined').removeClass('jstree-undetermined');\n            for (i = 0, j = p.length; i < j; i++) {\n                s = this.get_node(p[i], true);\n                if(s && s.length) {\n                    s.children('.jstree-anchor').children('.jstree-checkbox').addClass('jstree-undetermined');\n                }\n            }\n        };\n        this.redraw_node = function(obj, deep, is_callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if(obj) {\n                var i, j, tmp = null, icon = null;\n                for(i = 0, j = obj.childNodes.length; i < j; i++) {\n                    if(obj.childNodes[i] && obj.childNodes[i].className && obj.childNodes[i].className.indexOf(\"jstree-anchor\") !== -1) {\n                        tmp = obj.childNodes[i];\n                        break;\n                    }\n                }\n                if(tmp) {\n                    if(!this.settings.checkbox.tie_selection && this._model.data[obj.id].state.checked) { tmp.className += ' jstree-checked'; }\n                    icon = _i.cloneNode(false);\n                    if(this._model.data[obj.id].state.checkbox_disabled) { icon.className += ' jstree-checkbox-disabled'; }\n                    tmp.insertBefore(icon, tmp.childNodes[0]);\n                }\n            }\n            if(!is_callback && this.settings.checkbox.cascade.indexOf('undetermined') !== -1) {\n                if(this._data.checkbox.uto) { clearTimeout(this._data.checkbox.uto); }\n                this._data.checkbox.uto = setTimeout(this._undetermined.bind(this), 50);\n            }\n            return obj;\n        };\n        /**\n         * show the node checkbox icons\n         * @name show_checkboxes()\n         * @plugin checkbox\n         */\n        this.show_checkboxes = function () { this._data.core.themes.checkboxes = true; this.get_container_ul().removeClass(\"jstree-no-checkboxes\"); };\n        /**\n         * hide the node checkbox icons\n         * @name hide_checkboxes()\n         * @plugin checkbox\n         */\n        this.hide_checkboxes = function () { this._data.core.themes.checkboxes = false; this.get_container_ul().addClass(\"jstree-no-checkboxes\"); };\n        /**\n         * toggle the node icons\n         * @name toggle_checkboxes()\n         * @plugin checkbox\n         */\n        this.toggle_checkboxes = function () { if(this._data.core.themes.checkboxes) { this.hide_checkboxes(); } else { this.show_checkboxes(); } };\n        /**\n         * checks if a node is in an undetermined state\n         * @name is_undetermined(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        this.is_undetermined = function (obj) {\n            obj = this.get_node(obj);\n            var s = this.settings.checkbox.cascade, i, j, t = this.settings.checkbox.tie_selection, d = this._data[ t ? 'core' : 'checkbox' ].selected, m = this._model.data;\n            if(!obj || obj.state[ t ? 'selected' : 'checked' ] === true || s.indexOf('undetermined') === -1 || (s.indexOf('down') === -1 && s.indexOf('up') === -1)) {\n                return false;\n            }\n            if(!obj.state.loaded && obj.original.state.undetermined === true) {\n                return true;\n            }\n            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                if($.inArray(obj.children_d[i], d) !== -1 || (!m[obj.children_d[i]].state.loaded && m[obj.children_d[i]].original.state.undetermined)) {\n                    return true;\n                }\n            }\n            return false;\n        };\n        /**\n         * disable a node's checkbox\n         * @name disable_checkbox(obj)\n         * @param {mixed} obj an array can be used too\n         * @trigger disable_checkbox.jstree\n         * @plugin checkbox\n         */\n        this.disable_checkbox = function (obj) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.disable_checkbox(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(!obj.state.checkbox_disabled) {\n                obj.state.checkbox_disabled = true;\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').children('.jstree-checkbox').addClass('jstree-checkbox-disabled');\n                }\n                /**\n                 * triggered when an node's checkbox is disabled\n                 * @event\n                 * @name disable_checkbox.jstree\n                 * @param {Object} node\n                 * @plugin checkbox\n                 */\n                this.trigger('disable_checkbox', { 'node' : obj });\n            }\n        };\n        /**\n         * enable a node's checkbox\n         * @name enable_checkbox(obj)\n         * @param {mixed} obj an array can be used too\n         * @trigger enable_checkbox.jstree\n         * @plugin checkbox\n         */\n        this.enable_checkbox = function (obj) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.enable_checkbox(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(obj.state.checkbox_disabled) {\n                obj.state.checkbox_disabled = false;\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').children('.jstree-checkbox').removeClass('jstree-checkbox-disabled');\n                }\n                /**\n                 * triggered when an node's checkbox is enabled\n                 * @event\n                 * @name enable_checkbox.jstree\n                 * @param {Object} node\n                 * @plugin checkbox\n                 */\n                this.trigger('enable_checkbox', { 'node' : obj });\n            }\n        };\n\n        this.activate_node = function (obj, e) {\n            if($(e.target).hasClass('jstree-checkbox-disabled')) {\n                return false;\n            }\n            if(this.settings.checkbox.tie_selection && (this.settings.checkbox.whole_node || $(e.target).hasClass('jstree-checkbox'))) {\n                e.ctrlKey = true;\n            }\n            if(this.settings.checkbox.tie_selection || (!this.settings.checkbox.whole_node && !$(e.target).hasClass('jstree-checkbox'))) {\n                return parent.activate_node.call(this, obj, e);\n            }\n            if(this.is_disabled(obj)) {\n                return false;\n            }\n            if(this.is_checked(obj)) {\n                this.uncheck_node(obj, e);\n            }\n            else {\n                this.check_node(obj, e);\n            }\n            this.trigger('activate_node', { 'node' : this.get_node(obj) });\n        };\n\n        /**\n         * Cascades checked state to a node and all its descendants. This function does NOT affect hidden and disabled nodes (or their descendants).\n         * However if these unaffected nodes are already selected their ids will be included in the returned array.\n         * @private\n         * @name _cascade_new_checked_state(id, checkedState)\n         * @param {string} id the node ID\n         * @param {bool} checkedState should the nodes be checked or not\n         * @returns {Array} Array of all node id's (in this tree branch) that are checked.\n         */\n        this._cascade_new_checked_state = function (id, checkedState) {\n            var self = this;\n            var t = this.settings.checkbox.tie_selection;\n            var node = this._model.data[id];\n            var selectedNodeIds = [];\n            var selectedChildrenIds = [], i, j, selectedChildIds;\n\n            if (\n                (this.settings.checkbox.cascade_to_disabled || !node.state.disabled) &&\n                (this.settings.checkbox.cascade_to_hidden || !node.state.hidden)\n            ) {\n                //First try and check/uncheck the children\n                if (node.children) {\n                    for (i = 0, j = node.children.length; i < j; i++) {\n                        var childId = node.children[i];\n                        selectedChildIds = self._cascade_new_checked_state(childId, checkedState);\n                        selectedNodeIds = selectedNodeIds.concat(selectedChildIds);\n                        if (selectedChildIds.indexOf(childId) > -1) {\n                            selectedChildrenIds.push(childId);\n                        }\n                    }\n                }\n\n                var dom = self.get_node(node, true);\n\n                //A node's state is undetermined if some but not all of it's children are checked/selected .\n                var undetermined = selectedChildrenIds.length > 0 && selectedChildrenIds.length < node.children.length;\n\n                if(node.original && node.original.state && node.original.state.undetermined) {\n                    node.original.state.undetermined = undetermined;\n                }\n\n                //If a node is undetermined then remove selected class\n                if (undetermined) {\n                    node.state[ t ? 'selected' : 'checked' ] = false;\n                    dom.attr('aria-selected', false).children('.jstree-anchor').removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                }\n                    //Otherwise, if the checkedState === true (i.e. the node is being checked now) and all of the node's children are checked (if it has any children),\n                //check the node and style it correctly.\n                else if (checkedState && selectedChildrenIds.length === node.children.length) {\n                    node.state[ t ? 'selected' : 'checked' ] = checkedState;\n                    selectedNodeIds.push(node.id);\n\n                    dom.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                }\n                else {\n                    node.state[ t ? 'selected' : 'checked' ] = false;\n                    dom.attr('aria-selected', false).children('.jstree-anchor').removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                }\n            }\n            else {\n                selectedChildIds = this.get_checked_descendants(id);\n\n                if (node.state[ t ? 'selected' : 'checked' ]) {\n                    selectedChildIds.push(node.id);\n                }\n\n                selectedNodeIds = selectedNodeIds.concat(selectedChildIds);\n            }\n\n            return selectedNodeIds;\n        };\n\n        /**\n         * Gets ids of nodes selected in branch (of tree) specified by id (does not include the node specified by id)\n         * @name get_checked_descendants(obj)\n         * @param {string} id the node ID\n         * @return {Array} array of IDs\n         * @plugin checkbox\n         */\n        this.get_checked_descendants = function (id) {\n            var self = this;\n            var t = self.settings.checkbox.tie_selection;\n            var node = self._model.data[id];\n\n            return $.vakata.array_filter(node.children_d, function(_id) {\n                return self._model.data[_id].state[ t ? 'selected' : 'checked' ];\n            });\n        };\n\n        /**\n         * check a node (only if tie_selection in checkbox settings is false, otherwise select_node will be called internally)\n         * @name check_node(obj)\n         * @param {mixed} obj an array can be used to check multiple nodes\n         * @trigger check_node.jstree\n         * @plugin checkbox\n         */\n        this.check_node = function (obj, e) {\n            if(this.settings.checkbox.tie_selection) { return this.select_node(obj, false, true, e); }\n            var dom, t1, t2, th;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.check_node(obj[t1], e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(!obj.state.checked) {\n                obj.state.checked = true;\n                this._data.checkbox.selected.push(obj.id);\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').addClass('jstree-checked');\n                }\n                /**\n                 * triggered when an node is checked (only if tie_selection in checkbox settings is false)\n                 * @event\n                 * @name check_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this check_node\n                 * @plugin checkbox\n                 */\n                this.trigger('check_node', { 'node' : obj, 'selected' : this._data.checkbox.selected, 'event' : e });\n            }\n        };\n        /**\n         * uncheck a node (only if tie_selection in checkbox settings is false, otherwise deselect_node will be called internally)\n         * @name uncheck_node(obj)\n         * @param {mixed} obj an array can be used to uncheck multiple nodes\n         * @trigger uncheck_node.jstree\n         * @plugin checkbox\n         */\n        this.uncheck_node = function (obj, e) {\n            if(this.settings.checkbox.tie_selection) { return this.deselect_node(obj, false, e); }\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.uncheck_node(obj[t1], e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(obj.state.checked) {\n                obj.state.checked = false;\n                this._data.checkbox.selected = $.vakata.array_remove_item(this._data.checkbox.selected, obj.id);\n                if(dom.length) {\n                    dom.children('.jstree-anchor').removeClass('jstree-checked');\n                }\n                /**\n                 * triggered when an node is unchecked (only if tie_selection in checkbox settings is false)\n                 * @event\n                 * @name uncheck_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this uncheck_node\n                 * @plugin checkbox\n                 */\n                this.trigger('uncheck_node', { 'node' : obj, 'selected' : this._data.checkbox.selected, 'event' : e });\n            }\n        };\n\n        /**\n         * checks all nodes in the tree (only if tie_selection in checkbox settings is false, otherwise select_all will be called internally)\n         * @name check_all()\n         * @trigger check_all.jstree, changed.jstree\n         * @plugin checkbox\n         */\n        this.check_all = function () {\n            if(this.settings.checkbox.tie_selection) { return this.select_all(); }\n            var tmp = this._data.checkbox.selected.concat([]), i, j;\n            this._data.checkbox.selected = this._model.data[$.jstree.root].children_d.concat();\n            for(i = 0, j = this._data.checkbox.selected.length; i < j; i++) {\n                if(this._model.data[this._data.checkbox.selected[i]]) {\n                    this._model.data[this._data.checkbox.selected[i]].state.checked = true;\n                }\n            }\n            this.redraw(true);\n            /**\n             * triggered when all nodes are checked (only if tie_selection in checkbox settings is false)\n             * @event\n             * @name check_all.jstree\n             * @param {Array} selected the current selection\n             * @plugin checkbox\n             */\n            this.trigger('check_all', { 'selected' : this._data.checkbox.selected });\n        };\n        /**\n         * uncheck all checked nodes (only if tie_selection in checkbox settings is false, otherwise deselect_all will be called internally)\n         * @name uncheck_all()\n         * @trigger uncheck_all.jstree\n         * @plugin checkbox\n         */\n        this.uncheck_all = function () {\n            if(this.settings.checkbox.tie_selection) { return this.deselect_all(); }\n            var tmp = this._data.checkbox.selected.concat([]), i, j;\n            for(i = 0, j = this._data.checkbox.selected.length; i < j; i++) {\n                if(this._model.data[this._data.checkbox.selected[i]]) {\n                    this._model.data[this._data.checkbox.selected[i]].state.checked = false;\n                }\n            }\n            this._data.checkbox.selected = [];\n            this.element.find('.jstree-checked').removeClass('jstree-checked');\n            /**\n             * triggered when all nodes are unchecked (only if tie_selection in checkbox settings is false)\n             * @event\n             * @name uncheck_all.jstree\n             * @param {Object} node the previous selection\n             * @param {Array} selected the current selection\n             * @plugin checkbox\n             */\n            this.trigger('uncheck_all', { 'selected' : this._data.checkbox.selected, 'node' : tmp });\n        };\n        /**\n         * checks if a node is checked (if tie_selection is on in the settings this function will return the same as is_selected)\n         * @name is_checked(obj)\n         * @param  {mixed}  obj\n         * @return {Boolean}\n         * @plugin checkbox\n         */\n        this.is_checked = function (obj) {\n            if(this.settings.checkbox.tie_selection) { return this.is_selected(obj); }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            return obj.state.checked;\n        };\n        /**\n         * get an array of all checked nodes (if tie_selection is on in the settings this function will return the same as get_selected)\n         * @name get_checked([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_checked = function (full) {\n            if(this.settings.checkbox.tie_selection) { return this.get_selected(full); }\n            return full ? $.map(this._data.checkbox.selected, function (i) { return this.get_node(i); }.bind(this)) : this._data.checkbox.selected.slice();\n        };\n        /**\n         * get an array of all top level checked nodes (ignoring children of checked nodes) (if tie_selection is on in the settings this function will return the same as get_top_selected)\n         * @name get_top_checked([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_top_checked = function (full) {\n            if(this.settings.checkbox.tie_selection) { return this.get_top_selected(full); }\n            var tmp = this.get_checked(true),\n                obj = {}, i, j, k, l;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                obj[tmp[i].id] = tmp[i];\n            }\n            for(i = 0, j = tmp.length; i < j; i++) {\n                for(k = 0, l = tmp[i].children_d.length; k < l; k++) {\n                    if(obj[tmp[i].children_d[k]]) {\n                        delete obj[tmp[i].children_d[k]];\n                    }\n                }\n            }\n            tmp = [];\n            for(i in obj) {\n                if(obj.hasOwnProperty(i)) {\n                    tmp.push(i);\n                }\n            }\n            return full ? $.map(tmp, function (i) { return this.get_node(i); }.bind(this)) : tmp;\n        };\n        /**\n         * get an array of all bottom level checked nodes (ignoring selected parents) (if tie_selection is on in the settings this function will return the same as get_bottom_selected)\n         * @name get_bottom_checked([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_bottom_checked = function (full) {\n            if(this.settings.checkbox.tie_selection) { return this.get_bottom_selected(full); }\n            var tmp = this.get_checked(true),\n                obj = [], i, j;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                if(!tmp[i].children.length) {\n                    obj.push(tmp[i].id);\n                }\n            }\n            return full ? $.map(obj, function (i) { return this.get_node(i); }.bind(this)) : obj;\n        };\n        this.load_node = function (obj, callback) {\n            var k, l, i, j, c, tmp;\n            if(!$.vakata.is_array(obj) && !this.settings.checkbox.tie_selection) {\n                tmp = this.get_node(obj);\n                if(tmp && tmp.state.loaded) {\n                    for(k = 0, l = tmp.children_d.length; k < l; k++) {\n                        if(this._model.data[tmp.children_d[k]].state.checked) {\n                            c = true;\n                            this._data.checkbox.selected = $.vakata.array_remove_item(this._data.checkbox.selected, tmp.children_d[k]);\n                        }\n                    }\n                }\n            }\n            return parent.load_node.apply(this, arguments);\n        };\n        this.get_state = function () {\n            var state = parent.get_state.apply(this, arguments);\n            if(this.settings.checkbox.tie_selection) { return state; }\n            state.checkbox = this._data.checkbox.selected.slice();\n            return state;\n        };\n        this.set_state = function (state, callback) {\n            var res = parent.set_state.apply(this, arguments);\n            if(res && state.checkbox) {\n                if(!this.settings.checkbox.tie_selection) {\n                    this.uncheck_all();\n                    var _this = this;\n                    $.each(state.checkbox, function (i, v) {\n                        _this.check_node(v);\n                    });\n                }\n                delete state.checkbox;\n                this.set_state(state, callback);\n                return false;\n            }\n            return res;\n        };\n        this.refresh = function (skip_loading, forget_state) {\n            if(this.settings.checkbox.tie_selection) {\n                this._data.checkbox.selected = [];\n            }\n            return parent.refresh.apply(this, arguments);\n        };\n    };\n\n    // include the checkbox plugin by default\n    // $.jstree.defaults.plugins.push(\"checkbox\");\n\n\n    /**\n     * ### Conditionalselect plugin\n     *\n     * This plugin allows defining a callback to allow or deny node selection by user input (activate node method).\n     */\n\n    /**\n     * a callback (function) which is invoked in the instance's scope and receives two arguments - the node and the event that triggered the `activate_node` call. Returning false prevents working with the node, returning true allows invoking activate_node. Defaults to returning `true`.\n     * @name $.jstree.defaults.checkbox.visible\n     * @plugin checkbox\n     */\n    $.jstree.defaults.conditionalselect = function () { return true; };\n    $.jstree.plugins.conditionalselect = function (options, parent) {\n        // own function\n        this.activate_node = function (obj, e) {\n            if(this.settings.conditionalselect.call(this, this.get_node(obj), e)) {\n                return parent.activate_node.call(this, obj, e);\n            }\n        };\n    };\n\n\n    /**\n     * ### Contextmenu plugin\n     *\n     * Shows a context menu when a node is right-clicked.\n     */\n\n    /**\n     * stores all defaults for the contextmenu plugin\n     * @name $.jstree.defaults.contextmenu\n     * @plugin contextmenu\n     */\n    $.jstree.defaults.contextmenu = {\n        /**\n         * a boolean indicating if the node should be selected when the context menu is invoked on it. Defaults to `true`.\n         * @name $.jstree.defaults.contextmenu.select_node\n         * @plugin contextmenu\n         */\n        select_node : true,\n        /**\n         * a boolean indicating if the menu should be shown aligned with the node. Defaults to `true`, otherwise the mouse coordinates are used.\n         * @name $.jstree.defaults.contextmenu.show_at_node\n         * @plugin contextmenu\n         */\n        show_at_node : true,\n        /**\n         * an object of actions, or a function that accepts a node and a callback function and calls the callback function with an object of actions available for that node (you can also return the items too).\n         *\n         * Each action consists of a key (a unique name) and a value which is an object with the following properties (only label and action are required). Once a menu item is activated the `action` function will be invoked with an object containing the following keys: item - the contextmenu item definition as seen below, reference - the DOM node that was used (the tree node), element - the contextmenu DOM element, position - an object with x/y properties indicating the position of the menu.\n         *\n         * * `separator_before` - a boolean indicating if there should be a separator before this item\n         * * `separator_after` - a boolean indicating if there should be a separator after this item\n         * * `_disabled` - a boolean indicating if this action should be disabled\n         * * `label` - a string - the name of the action (could be a function returning a string)\n         * * `title` - a string - an optional tooltip for the item\n         * * `action` - a function to be executed if this item is chosen, the function will receive\n         * * `icon` - a string, can be a path to an icon or a className, if using an image that is in the current directory use a `./` prefix, otherwise it will be detected as a class\n         * * `shortcut` - keyCode which will trigger the action if the menu is open (for example `113` for rename, which equals F2)\n         * * `shortcut_label` - shortcut label (like for example `F2` for rename)\n         * * `submenu` - an object with the same structure as $.jstree.defaults.contextmenu.items which can be used to create a submenu - each key will be rendered as a separate option in a submenu that will appear once the current item is hovered\n         *\n         * @name $.jstree.defaults.contextmenu.items\n         * @plugin contextmenu\n         */\n        items : function (o, cb) { // Could be an object directly\n            return {\n                \"create\" : {\n                    \"separator_before\"\t: false,\n                    \"separator_after\"\t: true,\n                    \"_disabled\"\t\t\t: false, //(this.check(\"create_node\", data.reference, {}, \"last\")),\n                    \"label\"\t\t\t\t: \"Create\",\n                    \"action\"\t\t\t: function (data) {\n                        var inst = $.jstree.reference(data.reference),\n                            obj = inst.get_node(data.reference);\n                        inst.create_node(obj, {}, \"last\", function (new_node) {\n                            try {\n                                inst.edit(new_node);\n                            } catch (ex) {\n                                setTimeout(function () { inst.edit(new_node); },0);\n                            }\n                        });\n                    }\n                },\n                \"rename\" : {\n                    \"separator_before\"\t: false,\n                    \"separator_after\"\t: false,\n                    \"_disabled\"\t\t\t: false, //(this.check(\"rename_node\", data.reference, this.get_parent(data.reference), \"\")),\n                    \"label\"\t\t\t\t: \"Rename\",\n                    /*!\n\t\t\t\t\t\"shortcut\"\t\t\t: 113,\n\t\t\t\t\t\"shortcut_label\"\t: 'F2',\n\t\t\t\t\t\"icon\"\t\t\t\t: \"glyphicon glyphicon-leaf\",\n\t\t\t\t\t*/\n                    \"action\"\t\t\t: function (data) {\n                        var inst = $.jstree.reference(data.reference),\n                            obj = inst.get_node(data.reference);\n                        inst.edit(obj);\n                    }\n                },\n                \"remove\" : {\n                    \"separator_before\"\t: false,\n                    \"icon\"\t\t\t\t: false,\n                    \"separator_after\"\t: false,\n                    \"_disabled\"\t\t\t: false, //(this.check(\"delete_node\", data.reference, this.get_parent(data.reference), \"\")),\n                    \"label\"\t\t\t\t: \"Delete\",\n                    \"action\"\t\t\t: function (data) {\n                        var inst = $.jstree.reference(data.reference),\n                            obj = inst.get_node(data.reference);\n                        if(inst.is_selected(obj)) {\n                            inst.delete_node(inst.get_selected());\n                        }\n                        else {\n                            inst.delete_node(obj);\n                        }\n                    }\n                },\n                \"ccp\" : {\n                    \"separator_before\"\t: true,\n                    \"icon\"\t\t\t\t: false,\n                    \"separator_after\"\t: false,\n                    \"label\"\t\t\t\t: \"Edit\",\n                    \"action\"\t\t\t: false,\n                    \"submenu\" : {\n                        \"cut\" : {\n                            \"separator_before\"\t: false,\n                            \"separator_after\"\t: false,\n                            \"label\"\t\t\t\t: \"Cut\",\n                            \"action\"\t\t\t: function (data) {\n                                var inst = $.jstree.reference(data.reference),\n                                    obj = inst.get_node(data.reference);\n                                if(inst.is_selected(obj)) {\n                                    inst.cut(inst.get_top_selected());\n                                }\n                                else {\n                                    inst.cut(obj);\n                                }\n                            }\n                        },\n                        \"copy\" : {\n                            \"separator_before\"\t: false,\n                            \"icon\"\t\t\t\t: false,\n                            \"separator_after\"\t: false,\n                            \"label\"\t\t\t\t: \"Copy\",\n                            \"action\"\t\t\t: function (data) {\n                                var inst = $.jstree.reference(data.reference),\n                                    obj = inst.get_node(data.reference);\n                                if(inst.is_selected(obj)) {\n                                    inst.copy(inst.get_top_selected());\n                                }\n                                else {\n                                    inst.copy(obj);\n                                }\n                            }\n                        },\n                        \"paste\" : {\n                            \"separator_before\"\t: false,\n                            \"icon\"\t\t\t\t: false,\n                            \"_disabled\"\t\t\t: function (data) {\n                                return !$.jstree.reference(data.reference).can_paste();\n                            },\n                            \"separator_after\"\t: false,\n                            \"label\"\t\t\t\t: \"Paste\",\n                            \"action\"\t\t\t: function (data) {\n                                var inst = $.jstree.reference(data.reference),\n                                    obj = inst.get_node(data.reference);\n                                inst.paste(obj);\n                            }\n                        }\n                    }\n                }\n            };\n        }\n    };\n\n    $.jstree.plugins.contextmenu = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n\n            var last_ts = 0, cto = null, ex, ey;\n            this.element\n                .on(\"init.jstree loading.jstree ready.jstree\", function () {\n                    this.get_container_ul().addClass('jstree-contextmenu');\n                }.bind(this))\n                .on(\"contextmenu.jstree\", \".jstree-anchor\", function (e, data) {\n                    if (e.target.tagName.toLowerCase() === 'input') {\n                        return;\n                    }\n                    e.preventDefault();\n                    last_ts = e.ctrlKey ? +new Date() : 0;\n                    if(data || cto) {\n                        last_ts = (+new Date()) + 10000;\n                    }\n                    if(cto) {\n                        clearTimeout(cto);\n                    }\n                    if(!this.is_loading(e.currentTarget)) {\n                        this.show_contextmenu(e.currentTarget, e.pageX, e.pageY, e);\n                    }\n                }.bind(this))\n                .on(\"click.jstree\", \".jstree-anchor\", function (e) {\n                    if(this._data.contextmenu.visible && (!last_ts || (+new Date()) - last_ts > 250)) { // work around safari & macOS ctrl+click\n                        $.vakata.context.hide();\n                    }\n                    last_ts = 0;\n                }.bind(this))\n                .on(\"touchstart.jstree\", \".jstree-anchor\", function (e) {\n                    if(!e.originalEvent || !e.originalEvent.changedTouches || !e.originalEvent.changedTouches[0]) {\n                        return;\n                    }\n                    ex = e.originalEvent.changedTouches[0].clientX;\n                    ey = e.originalEvent.changedTouches[0].clientY;\n                    cto = setTimeout(function () {\n                        $(e.currentTarget).trigger('contextmenu', true);\n                    }, 750);\n                })\n                .on('touchmove.vakata.jstree', function (e) {\n                    if(cto && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0] && (Math.abs(ex - e.originalEvent.changedTouches[0].clientX) > 10 || Math.abs(ey - e.originalEvent.changedTouches[0].clientY) > 10)) {\n                        clearTimeout(cto);\n                        $.vakata.context.hide();\n                    }\n                })\n                .on('touchend.vakata.jstree', function (e) {\n                    if(cto) {\n                        clearTimeout(cto);\n                    }\n                });\n\n            /*!\n\t\t\tif(!('oncontextmenu' in document.body) && ('ontouchstart' in document.body)) {\n\t\t\t\tvar el = null, tm = null;\n\t\t\t\tthis.element\n\t\t\t\t\t.on(\"touchstart\", \".jstree-anchor\", function (e) {\n\t\t\t\t\t\tel = e.currentTarget;\n\t\t\t\t\t\ttm = +new Date();\n\t\t\t\t\t\t$(document).one(\"touchend\", function (e) {\n\t\t\t\t\t\t\te.target = document.elementFromPoint(e.originalEvent.targetTouches[0].pageX - window.pageXOffset, e.originalEvent.targetTouches[0].pageY - window.pageYOffset);\n\t\t\t\t\t\t\te.currentTarget = e.target;\n\t\t\t\t\t\t\ttm = ((+(new Date())) - tm);\n\t\t\t\t\t\t\tif(e.target === el && tm > 600 && tm < 1000) {\n\t\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t\t\t$(el).trigger('contextmenu', e);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tel = null;\n\t\t\t\t\t\t\ttm = null;\n\t\t\t\t\t\t});\n\t\t\t\t\t});\n\t\t\t}\n\t\t\t*/\n            $(document).on(\"context_hide.vakata.jstree\", function (e, data) {\n                this._data.contextmenu.visible = false;\n                $(data.reference).removeClass('jstree-context');\n            }.bind(this));\n        };\n        this.teardown = function () {\n            if(this._data.contextmenu.visible) {\n                $.vakata.context.hide();\n            }\n            $(document).off(\"context_hide.vakata.jstree\");\n            parent.teardown.call(this);\n        };\n\n        /**\n         * prepare and show the context menu for a node\n         * @name show_contextmenu(obj [, x, y])\n         * @param {mixed} obj the node\n         * @param {Number} x the x-coordinate relative to the document to show the menu at\n         * @param {Number} y the y-coordinate relative to the document to show the menu at\n         * @param {Object} e the event if available that triggered the contextmenu\n         * @plugin contextmenu\n         * @trigger show_contextmenu.jstree\n         */\n        this.show_contextmenu = function (obj, x, y, e) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            var s = this.settings.contextmenu,\n                d = this.get_node(obj, true),\n                a = d.children(\".jstree-anchor\"),\n                o = false,\n                i = false;\n            if(s.show_at_node || x === undefined || y === undefined) {\n                o = a.offset();\n                x = o.left;\n                y = o.top + this._data.core.li_height;\n            }\n            if(this.settings.contextmenu.select_node && !this.is_selected(obj)) {\n                this.activate_node(obj, e);\n            }\n\n            i = s.items;\n            if($.vakata.is_function(i)) {\n                i = i.call(this, obj, function (i) {\n                    this._show_contextmenu(obj, x, y, i);\n                }.bind(this));\n            }\n            if($.isPlainObject(i)) {\n                this._show_contextmenu(obj, x, y, i);\n            }\n        };\n        /**\n         * show the prepared context menu for a node\n         * @name _show_contextmenu(obj, x, y, i)\n         * @param {mixed} obj the node\n         * @param {Number} x the x-coordinate relative to the document to show the menu at\n         * @param {Number} y the y-coordinate relative to the document to show the menu at\n         * @param {Number} i the object of items to show\n         * @plugin contextmenu\n         * @trigger show_contextmenu.jstree\n         * @private\n         */\n        this._show_contextmenu = function (obj, x, y, i) {\n            var d = this.get_node(obj, true),\n                a = d.children(\".jstree-anchor\");\n            $(document).one(\"context_show.vakata.jstree\", function (e, data) {\n                var cls = 'jstree-contextmenu jstree-' + this.get_theme() + '-contextmenu';\n                $(data.element).addClass(cls);\n                a.addClass('jstree-context');\n            }.bind(this));\n            this._data.contextmenu.visible = true;\n            $.vakata.context.show(a, { 'x' : x, 'y' : y }, i);\n            /**\n             * triggered when the contextmenu is shown for a node\n             * @event\n             * @name show_contextmenu.jstree\n             * @param {Object} node the node\n             * @param {Number} x the x-coordinate of the menu relative to the document\n             * @param {Number} y the y-coordinate of the menu relative to the document\n             * @plugin contextmenu\n             */\n            this.trigger('show_contextmenu', { \"node\" : obj, \"x\" : x, \"y\" : y });\n        };\n    };\n\n    // contextmenu helper\n    (function ($) {\n        var right_to_left = false,\n            vakata_context = {\n                element\t\t: false,\n                reference\t: false,\n                position_x\t: 0,\n                position_y\t: 0,\n                items\t\t: [],\n                html\t\t: \"\",\n                is_visible\t: false\n            };\n\n        $.vakata.context = {\n            settings : {\n                hide_onmouseleave\t: 0,\n                icons\t\t\t\t: true\n            },\n            _trigger : function (event_name) {\n                $(document).triggerHandler(\"context_\" + event_name + \".vakata\", {\n                    \"reference\"\t: vakata_context.reference,\n                    \"element\"\t: vakata_context.element,\n                    \"position\"\t: {\n                        \"x\" : vakata_context.position_x,\n                        \"y\" : vakata_context.position_y\n                    }\n                });\n            },\n            _execute : function (i) {\n                i = vakata_context.items[i];\n                return i && (!i._disabled || ($.vakata.is_function(i._disabled) && !i._disabled({ \"item\" : i, \"reference\" : vakata_context.reference, \"element\" : vakata_context.element }))) && i.action ? i.action.call(null, {\n                    \"item\"\t\t: i,\n                    \"reference\"\t: vakata_context.reference,\n                    \"element\"\t: vakata_context.element,\n                    \"position\"\t: {\n                        \"x\" : vakata_context.position_x,\n                        \"y\" : vakata_context.position_y\n                    }\n                }) : false;\n            },\n            _parse : function (o, is_callback) {\n                if(!o) { return false; }\n                if(!is_callback) {\n                    vakata_context.html\t\t= \"\";\n                    vakata_context.items\t= [];\n                }\n                var str = \"\",\n                    sep = false,\n                    tmp;\n\n                if(is_callback) { str += \"<\"+\"ul>\"; }\n                $.each(o, function (i, val) {\n                    if(!val) { return true; }\n                    vakata_context.items.push(val);\n                    if(!sep && val.separator_before) {\n                        str += \"<\"+\"li class='vakata-context-separator'><\"+\"a href='#' \" + ($.vakata.context.settings.icons ? '' : 'class=\"vakata-context-no-icons\"') + \">&#160;<\"+\"/a><\"+\"/li>\";\n                    }\n                    sep = false;\n                    str += \"<\"+\"li class='\" + (val._class || \"\") + (val._disabled === true || ($.vakata.is_function(val._disabled) && val._disabled({ \"item\" : val, \"reference\" : vakata_context.reference, \"element\" : vakata_context.element })) ? \" vakata-contextmenu-disabled \" : \"\") + \"' \"+(val.shortcut?\" data-shortcut='\"+val.shortcut+\"' \":'')+\">\";\n                    str += \"<\"+\"a href='#' rel='\" + (vakata_context.items.length - 1) + \"' \" + (val.title ? \"title='\" + val.title + \"'\" : \"\") + \">\";\n                    if($.vakata.context.settings.icons) {\n                        str += \"<\"+\"i \";\n                        if(val.icon) {\n                            if(val.icon.indexOf(\"/\") !== -1 || val.icon.indexOf(\".\") !== -1) { str += \" style='background:url(\\\"\" + val.icon + \"\\\") center center no-repeat' \"; }\n                            else { str += \" class='\" + val.icon + \"' \"; }\n                        }\n                        str += \"><\"+\"/i><\"+\"span class='vakata-contextmenu-sep'>&#160;<\"+\"/span>\";\n                    }\n                    str += ($.vakata.is_function(val.label) ? val.label({ \"item\" : i, \"reference\" : vakata_context.reference, \"element\" : vakata_context.element }) : val.label) + (val.shortcut?' <span class=\"vakata-contextmenu-shortcut vakata-contextmenu-shortcut-'+val.shortcut+'\">'+ (val.shortcut_label || '') +'</span>':'') + \"<\"+\"/a>\";\n                    if(val.submenu) {\n                        tmp = $.vakata.context._parse(val.submenu, true);\n                        if(tmp) { str += tmp; }\n                    }\n                    str += \"<\"+\"/li>\";\n                    if(val.separator_after) {\n                        str += \"<\"+\"li class='vakata-context-separator'><\"+\"a href='#' \" + ($.vakata.context.settings.icons ? '' : 'class=\"vakata-context-no-icons\"') + \">&#160;<\"+\"/a><\"+\"/li>\";\n                        sep = true;\n                    }\n                });\n                str  = str.replace(/<li class\\='vakata-context-separator'\\><\\/li\\>$/,\"\");\n                if(is_callback) { str += \"</ul>\"; }\n                /**\n                 * triggered on the document when the contextmenu is parsed (HTML is built)\n                 * @event\n                 * @plugin contextmenu\n                 * @name context_parse.vakata\n                 * @param {jQuery} reference the element that was right clicked\n                 * @param {jQuery} element the DOM element of the menu itself\n                 * @param {Object} position the x & y coordinates of the menu\n                 */\n                if(!is_callback) { vakata_context.html = str; $.vakata.context._trigger(\"parse\"); }\n                return str.length > 10 ? str : false;\n            },\n            _show_submenu : function (o) {\n                o = $(o);\n                if(!o.length || !o.children(\"ul\").length) { return; }\n                var e = o.children(\"ul\"),\n                    xl = o.offset().left,\n                    x = xl + o.outerWidth(),\n                    y = o.offset().top,\n                    w = e.width(),\n                    h = e.height(),\n                    dw = $(window).width() + $(window).scrollLeft(),\n                    dh = $(window).height() + $(window).scrollTop();\n                // \u043c\u043e\u0436\u0435 \u0434\u0430 \u0441\u0435 \u0441\u043f\u0435\u0441\u0442\u0438 \u0435 \u0435\u0434\u043d\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 - \u0434\u0430\u043b\u0438 \u043d\u044f\u043c\u0430 \u043d\u044f\u043a\u043e\u0439 \u043e\u0442 \u043a\u043b\u0430\u0441\u043e\u0432\u0435\u0442\u0435 \u0432\u0435\u0447\u0435 \u043d\u0430\u0433\u043e\u0440\u0435\n                if(right_to_left) {\n                    o[x - (w + 10 + o.outerWidth()) < 0 ? \"addClass\" : \"removeClass\"](\"vakata-context-left\");\n                }\n                else {\n                    o[x + w > dw  && xl > dw - x ? \"addClass\" : \"removeClass\"](\"vakata-context-right\");\n                }\n                if(y + h + 10 > dh) {\n                    e.css(\"bottom\",\"-1px\");\n                }\n\n                //if does not fit - stick it to the side\n                if (o.hasClass('vakata-context-right')) {\n                    if (xl < w) {\n                        e.css(\"margin-right\", xl - w);\n                    }\n                } else {\n                    if (dw - x < w) {\n                        e.css(\"margin-left\", dw - x - w);\n                    }\n                }\n\n                e.show();\n            },\n            show : function (reference, position, data) {\n                var o, e, x, y, w, h, dw, dh, cond = true;\n                if(vakata_context.element && vakata_context.element.length) {\n                    vakata_context.element.width('');\n                }\n                switch(cond) {\n                    case (!position && !reference):\n                        return false;\n                    case (!!position && !!reference):\n                        vakata_context.reference\t= reference;\n                        vakata_context.position_x\t= position.x;\n                        vakata_context.position_y\t= position.y;\n                        break;\n                    case (!position && !!reference):\n                        vakata_context.reference\t= reference;\n                        o = reference.offset();\n                        vakata_context.position_x\t= o.left + reference.outerHeight();\n                        vakata_context.position_y\t= o.top;\n                        break;\n                    case (!!position && !reference):\n                        vakata_context.position_x\t= position.x;\n                        vakata_context.position_y\t= position.y;\n                        break;\n                }\n                if(!!reference && !data && $(reference).data('vakata_contextmenu')) {\n                    data = $(reference).data('vakata_contextmenu');\n                }\n                if($.vakata.context._parse(data)) {\n                    vakata_context.element.html(vakata_context.html);\n                }\n                if(vakata_context.items.length) {\n                    vakata_context.element.appendTo(document.body);\n                    e = vakata_context.element;\n                    x = vakata_context.position_x;\n                    y = vakata_context.position_y;\n                    w = e.width();\n                    h = e.height();\n                    dw = $(window).width() + $(window).scrollLeft();\n                    dh = $(window).height() + $(window).scrollTop();\n                    if(right_to_left) {\n                        x -= (e.outerWidth() - $(reference).outerWidth());\n                        if(x < $(window).scrollLeft() + 20) {\n                            x = $(window).scrollLeft() + 20;\n                        }\n                    }\n                    if(x + w + 20 > dw) {\n                        x = dw - (w + 20);\n                    }\n                    if(y + h + 20 > dh) {\n                        y = dh - (h + 20);\n                    }\n\n                    vakata_context.element\n                        .css({ \"left\" : x, \"top\" : y })\n                        .show()\n                        .find('a').first().trigger('focus').parent().addClass(\"vakata-context-hover\");\n                    vakata_context.is_visible = true;\n                    /**\n                     * triggered on the document when the contextmenu is shown\n                     * @event\n                     * @plugin contextmenu\n                     * @name context_show.vakata\n                     * @param {jQuery} reference the element that was right clicked\n                     * @param {jQuery} element the DOM element of the menu itself\n                     * @param {Object} position the x & y coordinates of the menu\n                     */\n                    $.vakata.context._trigger(\"show\");\n                }\n            },\n            hide : function () {\n                if(vakata_context.is_visible) {\n                    vakata_context.element.hide().find(\"ul\").hide().end().find(':focus').trigger('blur').end().detach();\n                    vakata_context.is_visible = false;\n                    /**\n                     * triggered on the document when the contextmenu is hidden\n                     * @event\n                     * @plugin contextmenu\n                     * @name context_hide.vakata\n                     * @param {jQuery} reference the element that was right clicked\n                     * @param {jQuery} element the DOM element of the menu itself\n                     * @param {Object} position the x & y coordinates of the menu\n                     */\n                    $.vakata.context._trigger(\"hide\");\n                }\n            }\n        };\n        $(function () {\n            right_to_left = $(document.body).css(\"direction\") === \"rtl\";\n            var to = false;\n\n            vakata_context.element = $(\"<ul class='vakata-context'></ul>\");\n            vakata_context.element\n                .on(\"mouseenter\", \"li\", function (e) {\n                    e.stopImmediatePropagation();\n\n                    if($.contains(this, e.relatedTarget)) {\n                        // \u043f\u0440\u0435\u043c\u0430\u0445\u043d\u0430\u0442\u043e \u0437\u0430\u0440\u0430\u0434\u0438 delegate mouseleave \u043f\u043e-\u0434\u043e\u043b\u0443\n                        // $(this).find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\");\n                        return;\n                    }\n\n                    if(to) { clearTimeout(to); }\n                    vakata_context.element.find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").end();\n\n                    $(this)\n                        .siblings().find(\"ul\").hide().end().end()\n                        .parentsUntil(\".vakata-context\", \"li\").addBack().addClass(\"vakata-context-hover\");\n                    $.vakata.context._show_submenu(this);\n                })\n                // \u0442\u0435\u0441\u0442\u043e\u0432\u043e - \u0434\u0430\u043b\u0438 \u043d\u0435 \u043d\u0430\u0442\u043e\u0432\u0430\u0440\u0432\u0430?\n                .on(\"mouseleave\", \"li\", function (e) {\n                    if($.contains(this, e.relatedTarget)) { return; }\n                    $(this).find(\".vakata-context-hover\").addBack().removeClass(\"vakata-context-hover\");\n                })\n                .on(\"mouseleave\", function (e) {\n                    $(this).find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\");\n                    if($.vakata.context.settings.hide_onmouseleave) {\n                        to = setTimeout(\n                            (function (t) {\n                                return function () { $.vakata.context.hide(); };\n                            }(this)), $.vakata.context.settings.hide_onmouseleave);\n                    }\n                })\n                .on(\"click\", \"a\", function (e) {\n                    e.preventDefault();\n                    //})\n                    //.on(\"mouseup\", \"a\", function (e) {\n                    if(!$(this).trigger('blur').parent().hasClass(\"vakata-context-disabled\") && $.vakata.context._execute($(this).attr(\"rel\")) !== false) {\n                        $.vakata.context.hide();\n                    }\n                })\n                .on('keydown', 'a', function (e) {\n                    var o = null;\n                    switch(e.which) {\n                        case 13:\n                        case 32:\n                            e.type = \"click\";\n                            e.preventDefault();\n                            $(e.currentTarget).trigger(e);\n                            break;\n                        case 37:\n                            if(vakata_context.is_visible) {\n                                vakata_context.element.find(\".vakata-context-hover\").last().closest(\"li\").first().find(\"ul\").hide().find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").end().end().children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 38:\n                            if(vakata_context.is_visible) {\n                                o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").prevAll(\"li:not(.vakata-context-separator)\").first();\n                                if(!o.length) { o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\"li:not(.vakata-context-separator)\").last(); }\n                                o.addClass(\"vakata-context-hover\").children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 39:\n                            if(vakata_context.is_visible) {\n                                vakata_context.element.find(\".vakata-context-hover\").last().children(\"ul\").show().children(\"li:not(.vakata-context-separator)\").removeClass(\"vakata-context-hover\").first().addClass(\"vakata-context-hover\").children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 40:\n                            if(vakata_context.is_visible) {\n                                o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").nextAll(\"li:not(.vakata-context-separator)\").first();\n                                if(!o.length) { o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\"li:not(.vakata-context-separator)\").first(); }\n                                o.addClass(\"vakata-context-hover\").children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 27:\n                            $.vakata.context.hide();\n                            e.preventDefault();\n                            break;\n                        default:\n                            //console.log(e.which);\n                            break;\n                    }\n                })\n                .on('keydown', function (e) {\n                    e.preventDefault();\n                    var a = vakata_context.element.find('.vakata-contextmenu-shortcut-' + e.which).parent();\n                    if(a.parent().not('.vakata-context-disabled')) {\n                        a.trigger('click');\n                    }\n                });\n\n            $(document)\n                .on(\"mousedown.vakata.jstree\", function (e) {\n                    if(vakata_context.is_visible && vakata_context.element[0] !== e.target  && !$.contains(vakata_context.element[0], e.target)) {\n                        $.vakata.context.hide();\n                    }\n                })\n                .on(\"context_show.vakata.jstree\", function (e, data) {\n                    vakata_context.element.find(\"li:has(ul)\").children(\"a\").addClass(\"vakata-context-parent\");\n                    if(right_to_left) {\n                        vakata_context.element.addClass(\"vakata-context-rtl\").css(\"direction\", \"rtl\");\n                    }\n                    // also apply a RTL class?\n                    vakata_context.element.find(\"ul\").hide().end();\n                });\n        });\n    }($));\n    // $.jstree.defaults.plugins.push(\"contextmenu\");\n\n\n    /**\n     * ### Drag'n'drop plugin\n     *\n     * Enables dragging and dropping of nodes in the tree, resulting in a move or copy operations.\n     */\n\n    /**\n     * stores all defaults for the drag'n'drop plugin\n     * @name $.jstree.defaults.dnd\n     * @plugin dnd\n     */\n    $.jstree.defaults.dnd = {\n        /**\n         * a boolean indicating if a copy should be possible while dragging (by pressint the meta key or Ctrl). Defaults to `true`.\n         * @name $.jstree.defaults.dnd.copy\n         * @plugin dnd\n         */\n        copy : true,\n        /**\n         * a number indicating how long a node should remain hovered while dragging to be opened. Defaults to `500`.\n         * @name $.jstree.defaults.dnd.open_timeout\n         * @plugin dnd\n         */\n        open_timeout : 500,\n        /**\n         * a function invoked each time a node is about to be dragged, invoked in the tree's scope and receives the nodes about to be dragged as an argument (array) and the event that started the drag - return `false` to prevent dragging\n         * @name $.jstree.defaults.dnd.is_draggable\n         * @plugin dnd\n         */\n        is_draggable : true,\n        /**\n         * a boolean indicating if checks should constantly be made while the user is dragging the node (as opposed to checking only on drop), default is `true`\n         * @name $.jstree.defaults.dnd.check_while_dragging\n         * @plugin dnd\n         */\n        check_while_dragging : true,\n        /**\n         * a boolean indicating if nodes from this tree should only be copied with dnd (as opposed to moved), default is `false`\n         * @name $.jstree.defaults.dnd.always_copy\n         * @plugin dnd\n         */\n        always_copy : false,\n        /**\n         * when dropping a node \"inside\", this setting indicates the position the node should go to - it can be an integer or a string: \"first\" (same as 0) or \"last\", default is `0`\n         * @name $.jstree.defaults.dnd.inside_pos\n         * @plugin dnd\n         */\n        inside_pos : 0,\n        /**\n         * when starting the drag on a node that is selected this setting controls if all selected nodes are dragged or only the single node, default is `true`, which means all selected nodes are dragged when the drag is started on a selected node\n         * @name $.jstree.defaults.dnd.drag_selection\n         * @plugin dnd\n         */\n        drag_selection : true,\n        /**\n         * controls whether dnd works on touch devices. If left as boolean true dnd will work the same as in desktop browsers, which in some cases may impair scrolling. If set to boolean false dnd will not work on touch devices. There is a special third option - string \"selected\" which means only selected nodes can be dragged on touch devices.\n         * @name $.jstree.defaults.dnd.touch\n         * @plugin dnd\n         */\n        touch : true,\n        /**\n         * controls whether items can be dropped anywhere on the node, not just on the anchor, by default only the node anchor is a valid drop target. Works best with the wholerow plugin. If enabled on mobile depending on the interface it might be hard for the user to cancel the drop, since the whole tree container will be a valid drop target.\n         * @name $.jstree.defaults.dnd.large_drop_target\n         * @plugin dnd\n         */\n        large_drop_target : false,\n        /**\n         * controls whether a drag can be initiated from any part of the node and not just the text/icon part, works best with the wholerow plugin. Keep in mind it can cause problems with tree scrolling on mobile depending on the interface - in that case set the touch option to \"selected\".\n         * @name $.jstree.defaults.dnd.large_drag_target\n         * @plugin dnd\n         */\n        large_drag_target : false,\n        /**\n         * controls whether use HTML5 dnd api instead of classical. That will allow better integration of dnd events with other HTML5 controls.\n         * @reference http://caniuse.com/#feat=dragndrop\n         * @name $.jstree.defaults.dnd.use_html5\n         * @plugin dnd\n         */\n        use_html5: false\n    };\n    var drg, elm;\n    // TODO: now check works by checking for each node individually, how about max_children, unique, etc?\n    $.jstree.plugins.dnd = function (options, parent) {\n        this.init = function (el, options) {\n            parent.init.call(this, el, options);\n            this.settings.dnd.use_html5 = this.settings.dnd.use_html5 && ('draggable' in document.createElement('span'));\n        };\n        this.bind = function () {\n            parent.bind.call(this);\n\n            this.element\n                .on(this.settings.dnd.use_html5 ? 'dragstart.jstree' : 'mousedown.jstree touchstart.jstree', this.settings.dnd.large_drag_target ? '.jstree-node' : '.jstree-anchor', function (e) {\n                    if(this.settings.dnd.large_drag_target && $(e.target).closest('.jstree-node')[0] !== e.currentTarget) {\n                        return true;\n                    }\n                    if(e.type === \"touchstart\" && (!this.settings.dnd.touch || (this.settings.dnd.touch === 'selected' && !$(e.currentTarget).closest('.jstree-node').children('.jstree-anchor').hasClass('jstree-clicked')))) {\n                        return true;\n                    }\n                    var obj = this.get_node(e.target),\n                        mlt = this.is_selected(obj) && this.settings.dnd.drag_selection ? this.get_top_selected().length : 1,\n                        txt = (mlt > 1 ? mlt + ' ' + this.get_string('nodes') : this.get_text(e.currentTarget));\n                    if(this.settings.core.force_text) {\n                        txt = $.vakata.html.escape(txt);\n                    }\n                    if(obj && obj.id && obj.id !== $.jstree.root && (e.which === 1 || e.type === \"touchstart\" || e.type === \"dragstart\") &&\n                        (this.settings.dnd.is_draggable === true || ($.vakata.is_function(this.settings.dnd.is_draggable) && this.settings.dnd.is_draggable.call(this, (mlt > 1 ? this.get_top_selected(true) : [obj]), e)))\n                    ) {\n                        drg = { 'jstree' : true, 'origin' : this, 'obj' : this.get_node(obj,true), 'nodes' : mlt > 1 ? this.get_top_selected() : [obj.id] };\n                        elm = e.currentTarget;\n                        if (this.settings.dnd.use_html5) {\n                            $.vakata.dnd._trigger('start', e, { 'helper': $(), 'element': elm, 'data': drg });\n                        } else {\n                            this.element.trigger('mousedown.jstree');\n                            return $.vakata.dnd.start(e, drg, '<div id=\"jstree-dnd\" class=\"jstree-' + this.get_theme() + ' jstree-' + this.get_theme() + '-' + this.get_theme_variant() + ' ' + ( this.settings.core.themes.responsive ? ' jstree-dnd-responsive' : '' ) + '\"><i class=\"jstree-icon jstree-er\"></i>' + txt + '<ins class=\"jstree-copy\">+</ins></div>');\n                        }\n                    }\n                }.bind(this));\n            if (this.settings.dnd.use_html5) {\n                this.element\n                    .on('dragover.jstree', function (e) {\n                        e.preventDefault();\n                        $.vakata.dnd._trigger('move', e, { 'helper': $(), 'element': elm, 'data': drg });\n                        return false;\n                    })\n                    //.on('dragenter.jstree', this.settings.dnd.large_drop_target ? '.jstree-node' : '.jstree-anchor', $.proxy(function (e) {\n                    //\t\te.preventDefault();\n                    //\t\t$.vakata.dnd._trigger('move', e, { 'helper': $(), 'element': elm, 'data': drg });\n                    //\t\treturn false;\n                    //\t}, this))\n                    .on('drop.jstree', function (e) {\n                        e.preventDefault();\n                        $.vakata.dnd._trigger('stop', e, { 'helper': $(), 'element': elm, 'data': drg });\n                        return false;\n                    }.bind(this));\n            }\n        };\n        this.redraw_node = function(obj, deep, callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if (obj && this.settings.dnd.use_html5) {\n                if (this.settings.dnd.large_drag_target) {\n                    obj.setAttribute('draggable', true);\n                } else {\n                    var i, j, tmp = null;\n                    for(i = 0, j = obj.childNodes.length; i < j; i++) {\n                        if(obj.childNodes[i] && obj.childNodes[i].className && obj.childNodes[i].className.indexOf(\"jstree-anchor\") !== -1) {\n                            tmp = obj.childNodes[i];\n                            break;\n                        }\n                    }\n                    if(tmp) {\n                        tmp.setAttribute('draggable', true);\n                    }\n                }\n            }\n            return obj;\n        };\n    };\n\n    $(function() {\n        // bind only once for all instances\n        var lastmv = false,\n            laster = false,\n            lastev = false,\n            opento = false,\n            marker = $('<div id=\"jstree-marker\">&#160;</div>').hide(); //.appendTo('body');\n\n        $(document)\n            .on('dragover.vakata.jstree', function (e) {\n                if (elm) {\n                    $.vakata.dnd._trigger('move', e, { 'helper': $(), 'element': elm, 'data': drg });\n                }\n            })\n            .on('drop.vakata.jstree', function (e) {\n                if (elm) {\n                    $.vakata.dnd._trigger('stop', e, { 'helper': $(), 'element': elm, 'data': drg });\n                    elm = null;\n                    drg = null;\n                }\n            })\n            .on('dnd_start.vakata.jstree', function (e, data) {\n                lastmv = false;\n                lastev = false;\n                if(!data || !data.data || !data.data.jstree) { return; }\n                marker.appendTo(document.body); //.show();\n            })\n            .on('dnd_move.vakata.jstree', function (e, data) {\n                var isDifferentNode = data.event.target !== lastev.target;\n                if(opento) {\n                    if (!data.event || data.event.type !== 'dragover' || isDifferentNode) {\n                        clearTimeout(opento);\n                    }\n                }\n                if(!data || !data.data || !data.data.jstree) { return; }\n\n                // if we are hovering the marker image do nothing (can happen on \"inside\" drags)\n                if(data.event.target.id && data.event.target.id === 'jstree-marker') {\n                    return;\n                }\n                lastev = data.event;\n\n                var ins = $.jstree.reference(data.event.target),\n                    ref = false,\n                    off = false,\n                    rel = false,\n                    tmp, l, t, h, p, i, o, ok, t1, t2, op, ps, pr, ip, tm, is_copy, pn, c;\n                // if we are over an instance\n                if(ins && ins._data && ins._data.dnd) {\n                    marker.attr('class', 'jstree-' + ins.get_theme() + ( ins.settings.core.themes.responsive ? ' jstree-dnd-responsive' : '' ));\n                    is_copy = data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey)));\n                    data.helper\n                        .children().attr('class', 'jstree-' + ins.get_theme() + ' jstree-' + ins.get_theme() + '-' + ins.get_theme_variant() + ' ' + ( ins.settings.core.themes.responsive ? ' jstree-dnd-responsive' : '' ))\n                        .find('.jstree-copy').first()[ is_copy ? 'show' : 'hide' ]();\n\n                    // if are hovering the container itself add a new root node\n                    //console.log(data.event);\n                    if( (data.event.target === ins.element[0] || data.event.target === ins.get_container_ul()[0]) && ins.get_container_ul().children().length === 0) {\n                        ok = true;\n                        for(t1 = 0, t2 = data.data.nodes.length; t1 < t2; t1++) {\n                            ok = ok && ins.check( (data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey)) ) ? \"copy_node\" : \"move_node\"), (data.data.origin && data.data.origin !== ins ? data.data.origin.get_node(data.data.nodes[t1]) : data.data.nodes[t1]), $.jstree.root, 'last', { 'dnd' : true, 'ref' : ins.get_node($.jstree.root), 'pos' : 'i', 'origin' : data.data.origin, 'is_multi' : (data.data.origin && data.data.origin !== ins), 'is_foreign' : (!data.data.origin) });\n                            if(!ok) { break; }\n                        }\n                        if(ok) {\n                            lastmv = { 'ins' : ins, 'par' : $.jstree.root, 'pos' : 'last' };\n                            marker.hide();\n                            data.helper.find('.jstree-icon').first().removeClass('jstree-er').addClass('jstree-ok');\n                            if (data.event.originalEvent && data.event.originalEvent.dataTransfer) {\n                                data.event.originalEvent.dataTransfer.dropEffect = is_copy ? 'copy' : 'move';\n                            }\n                            return;\n                        }\n                    }\n                    else {\n                        // if we are hovering a tree node\n                        ref = ins.settings.dnd.large_drop_target ? $(data.event.target).closest('.jstree-node').children('.jstree-anchor') : $(data.event.target).closest('.jstree-anchor');\n                        if(ref && ref.length && ref.parent().is('.jstree-closed, .jstree-open, .jstree-leaf')) {\n                            off = ref.offset();\n                            rel = (data.event.pageY !== undefined ? data.event.pageY : data.event.originalEvent.pageY) - off.top;\n                            h = ref.outerHeight();\n                            if(rel < h / 3) {\n                                o = ['b', 'i', 'a'];\n                            }\n                            else if(rel > h - h / 3) {\n                                o = ['a', 'i', 'b'];\n                            }\n                            else {\n                                o = rel > h / 2 ? ['i', 'a', 'b'] : ['i', 'b', 'a'];\n                            }\n                            $.each(o, function (j, v) {\n                                switch(v) {\n                                    case 'b':\n                                        l = off.left - 6;\n                                        t = off.top;\n                                        p = ins.get_parent(ref);\n                                        i = ref.parent().index();\n                                        c = 'jstree-below';\n                                        break;\n                                    case 'i':\n                                        ip = ins.settings.dnd.inside_pos;\n                                        tm = ins.get_node(ref.parent());\n                                        l = off.left - 2;\n                                        t = off.top + h / 2 + 1;\n                                        p = tm.id;\n                                        i = ip === 'first' ? 0 : (ip === 'last' ? tm.children.length : Math.min(ip, tm.children.length));\n                                        c = 'jstree-inside';\n                                        break;\n                                    case 'a':\n                                        l = off.left - 6;\n                                        t = off.top + h;\n                                        p = ins.get_parent(ref);\n                                        i = ref.parent().index() + 1;\n                                        c = 'jstree-above';\n                                        break;\n                                }\n                                ok = true;\n                                for(t1 = 0, t2 = data.data.nodes.length; t1 < t2; t1++) {\n                                    op = data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey))) ? \"copy_node\" : \"move_node\";\n                                    ps = i;\n                                    if(op === \"move_node\" && v === 'a' && (data.data.origin && data.data.origin === ins) && p === ins.get_parent(data.data.nodes[t1])) {\n                                        pr = ins.get_node(p);\n                                        if(ps > $.inArray(data.data.nodes[t1], pr.children)) {\n                                            ps -= 1;\n                                        }\n                                    }\n                                    ok = ok && ( (ins && ins.settings && ins.settings.dnd && ins.settings.dnd.check_while_dragging === false) || ins.check(op, (data.data.origin && data.data.origin !== ins ? data.data.origin.get_node(data.data.nodes[t1]) : data.data.nodes[t1]), p, ps, { 'dnd' : true, 'ref' : ins.get_node(ref.parent()), 'pos' : v, 'origin' : data.data.origin, 'is_multi' : (data.data.origin && data.data.origin !== ins), 'is_foreign' : (!data.data.origin) }) );\n                                    if(!ok) {\n                                        if(ins && ins.last_error) { laster = ins.last_error(); }\n                                        break;\n                                    }\n                                }\n                                if(v === 'i' && ref.parent().is('.jstree-closed') && ins.settings.dnd.open_timeout) {\n                                    if (!data.event || data.event.type !== 'dragover' || isDifferentNode) {\n                                        if (opento) { clearTimeout(opento); }\n                                        opento = setTimeout((function (x, z) { return function () { x.open_node(z); }; }(ins, ref)), ins.settings.dnd.open_timeout);\n                                    }\n                                }\n                                if(ok) {\n                                    pn = ins.get_node(p, true);\n                                    if (!pn.hasClass('.jstree-dnd-parent')) {\n                                        $('.jstree-dnd-parent').removeClass('jstree-dnd-parent');\n                                        pn.addClass('jstree-dnd-parent');\n                                    }\n                                    lastmv = { 'ins' : ins, 'par' : p, 'pos' : v === 'i' && ip === 'last' && i === 0 && !ins.is_loaded(tm) ? 'last' : i };\n                                    marker.css({ 'left' : l + 'px', 'top' : t + 'px' }).show();\n                                    marker.removeClass('jstree-above jstree-inside jstree-below').addClass(c);\n                                    data.helper.find('.jstree-icon').first().removeClass('jstree-er').addClass('jstree-ok');\n                                    if (data.event.originalEvent && data.event.originalEvent.dataTransfer) {\n                                        data.event.originalEvent.dataTransfer.dropEffect = is_copy ? 'copy' : 'move';\n                                    }\n                                    laster = {};\n                                    o = true;\n                                    return false;\n                                }\n                            });\n                            if(o === true) { return; }\n                        }\n                    }\n                }\n                $('.jstree-dnd-parent').removeClass('jstree-dnd-parent');\n                lastmv = false;\n                data.helper.find('.jstree-icon').removeClass('jstree-ok').addClass('jstree-er');\n                if (data.event.originalEvent && data.event.originalEvent.dataTransfer) {\n                    //data.event.originalEvent.dataTransfer.dropEffect = 'none';\n                }\n                marker.hide();\n            })\n            .on('dnd_scroll.vakata.jstree', function (e, data) {\n                if(!data || !data.data || !data.data.jstree) { return; }\n                marker.hide();\n                lastmv = false;\n                lastev = false;\n                data.helper.find('.jstree-icon').first().removeClass('jstree-ok').addClass('jstree-er');\n            })\n            .on('dnd_stop.vakata.jstree', function (e, data) {\n                $('.jstree-dnd-parent').removeClass('jstree-dnd-parent');\n                if(opento) { clearTimeout(opento); }\n                if(!data || !data.data || !data.data.jstree) { return; }\n                marker.hide().detach();\n                var i, j, nodes = [];\n                if(lastmv) {\n                    for(i = 0, j = data.data.nodes.length; i < j; i++) {\n                        nodes[i] = data.data.origin ? data.data.origin.get_node(data.data.nodes[i]) : data.data.nodes[i];\n                    }\n                    lastmv.ins[ data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey))) ? 'copy_node' : 'move_node' ](nodes, lastmv.par, lastmv.pos, false, false, false, data.data.origin);\n                }\n                else {\n                    i = $(data.event.target).closest('.jstree');\n                    if(i.length && laster && laster.error && laster.error === 'check') {\n                        i = i.jstree(true);\n                        if(i) {\n                            i.settings.core.error.call(this, laster);\n                        }\n                    }\n                }\n                lastev = false;\n                lastmv = false;\n            })\n            .on('keyup.jstree keydown.jstree', function (e, data) {\n                data = $.vakata.dnd._get();\n                if(data && data.data && data.data.jstree) {\n                    if (e.type === \"keyup\" && e.which === 27) {\n                        if (opento) { clearTimeout(opento); }\n                        lastmv = false;\n                        laster = false;\n                        lastev = false;\n                        opento = false;\n                        marker.hide().detach();\n                        $.vakata.dnd._clean();\n                    } else {\n                        data.helper.find('.jstree-copy').first()[ data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (e.metaKey || e.ctrlKey))) ? 'show' : 'hide' ]();\n                        if(lastev) {\n                            lastev.metaKey = e.metaKey;\n                            lastev.ctrlKey = e.ctrlKey;\n                            $.vakata.dnd._trigger('move', lastev);\n                        }\n                    }\n                }\n            });\n    });\n\n    // helpers\n    (function ($) {\n        $.vakata.html = {\n            div : $('<div></div>'),\n            escape : function (str) {\n                return $.vakata.html.div.text(str).html();\n            },\n            strip : function (str) {\n                return $.vakata.html.div.empty().append($.parseHTML(str)).text();\n            }\n        };\n        // private variable\n        var vakata_dnd = {\n            element\t: false,\n            target\t: false,\n            is_down\t: false,\n            is_drag\t: false,\n            helper\t: false,\n            helper_w: 0,\n            data\t: false,\n            init_x\t: 0,\n            init_y\t: 0,\n            scroll_l: 0,\n            scroll_t: 0,\n            scroll_e: false,\n            scroll_i: false,\n            is_touch: false\n        };\n        $.vakata.dnd = {\n            settings : {\n                scroll_speed\t\t: 10,\n                scroll_proximity\t: 20,\n                helper_left\t\t\t: 5,\n                helper_top\t\t\t: 10,\n                threshold\t\t\t: 5,\n                threshold_touch\t\t: 10\n            },\n            _trigger : function (event_name, e, data) {\n                if (data === undefined) {\n                    data = $.vakata.dnd._get();\n                }\n                data.event = e;\n                $(document).triggerHandler(\"dnd_\" + event_name + \".vakata\", data);\n            },\n            _get : function () {\n                return {\n                    \"data\"\t\t: vakata_dnd.data,\n                    \"element\"\t: vakata_dnd.element,\n                    \"helper\"\t: vakata_dnd.helper\n                };\n            },\n            _clean : function () {\n                if(vakata_dnd.helper) { vakata_dnd.helper.remove(); }\n                if(vakata_dnd.scroll_i) { clearInterval(vakata_dnd.scroll_i); vakata_dnd.scroll_i = false; }\n                vakata_dnd = {\n                    element\t: false,\n                    target\t: false,\n                    is_down\t: false,\n                    is_drag\t: false,\n                    helper\t: false,\n                    helper_w: 0,\n                    data\t: false,\n                    init_x\t: 0,\n                    init_y\t: 0,\n                    scroll_l: 0,\n                    scroll_t: 0,\n                    scroll_e: false,\n                    scroll_i: false,\n                    is_touch: false\n                };\n                elm = null;\n                $(document).off(\"mousemove.vakata.jstree touchmove.vakata.jstree\", $.vakata.dnd.drag);\n                $(document).off(\"mouseup.vakata.jstree touchend.vakata.jstree\", $.vakata.dnd.stop);\n            },\n            _scroll : function (init_only) {\n                if(!vakata_dnd.scroll_e || (!vakata_dnd.scroll_l && !vakata_dnd.scroll_t)) {\n                    if(vakata_dnd.scroll_i) { clearInterval(vakata_dnd.scroll_i); vakata_dnd.scroll_i = false; }\n                    return false;\n                }\n                if(!vakata_dnd.scroll_i) {\n                    vakata_dnd.scroll_i = setInterval($.vakata.dnd._scroll, 100);\n                    return false;\n                }\n                if(init_only === true) { return false; }\n\n                var i = vakata_dnd.scroll_e.scrollTop(),\n                    j = vakata_dnd.scroll_e.scrollLeft();\n                vakata_dnd.scroll_e.scrollTop(i + vakata_dnd.scroll_t * $.vakata.dnd.settings.scroll_speed);\n                vakata_dnd.scroll_e.scrollLeft(j + vakata_dnd.scroll_l * $.vakata.dnd.settings.scroll_speed);\n                if(i !== vakata_dnd.scroll_e.scrollTop() || j !== vakata_dnd.scroll_e.scrollLeft()) {\n                    /**\n                     * triggered on the document when a drag causes an element to scroll\n                     * @event\n                     * @plugin dnd\n                     * @name dnd_scroll.vakata\n                     * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                     * @param {DOM} element the DOM element being dragged\n                     * @param {jQuery} helper the helper shown next to the mouse\n                     * @param {jQuery} event the element that is scrolling\n                     */\n                    $.vakata.dnd._trigger(\"scroll\", vakata_dnd.scroll_e);\n                }\n            },\n            start : function (e, data, html) {\n                if(e.type === \"touchstart\" && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0]) {\n                    e.pageX = e.originalEvent.changedTouches[0].pageX;\n                    e.pageY = e.originalEvent.changedTouches[0].pageY;\n                    e.target = document.elementFromPoint(e.originalEvent.changedTouches[0].pageX - window.pageXOffset, e.originalEvent.changedTouches[0].pageY - window.pageYOffset);\n                }\n                if(vakata_dnd.is_drag) { $.vakata.dnd.stop({}); }\n                try {\n                    e.currentTarget.unselectable = \"on\";\n                    e.currentTarget.onselectstart = function() { return false; };\n                    if(e.currentTarget.style) {\n                        e.currentTarget.style.touchAction = \"none\";\n                        e.currentTarget.style.msTouchAction = \"none\";\n                        e.currentTarget.style.MozUserSelect = \"none\";\n                    }\n                } catch(ignore) { }\n                vakata_dnd.init_x\t= e.pageX;\n                vakata_dnd.init_y\t= e.pageY;\n                vakata_dnd.data\t\t= data;\n                vakata_dnd.is_down\t= true;\n                vakata_dnd.element\t= e.currentTarget;\n                vakata_dnd.target\t= e.target;\n                vakata_dnd.is_touch\t= e.type === \"touchstart\";\n                if(html !== false) {\n                    vakata_dnd.helper = $(\"<div id='vakata-dnd'></div>\").html(html).css({\n                        \"display\"\t\t: \"block\",\n                        \"margin\"\t\t: \"0\",\n                        \"padding\"\t\t: \"0\",\n                        \"position\"\t\t: \"absolute\",\n                        \"top\"\t\t\t: \"-2000px\",\n                        \"lineHeight\"\t: \"16px\",\n                        \"zIndex\"\t\t: \"10000\"\n                    });\n                }\n                $(document).on(\"mousemove.vakata.jstree touchmove.vakata.jstree\", $.vakata.dnd.drag);\n                $(document).on(\"mouseup.vakata.jstree touchend.vakata.jstree\", $.vakata.dnd.stop);\n                return false;\n            },\n            drag : function (e) {\n                if(e.type === \"touchmove\" && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0]) {\n                    e.pageX = e.originalEvent.changedTouches[0].pageX;\n                    e.pageY = e.originalEvent.changedTouches[0].pageY;\n                    e.target = document.elementFromPoint(e.originalEvent.changedTouches[0].pageX - window.pageXOffset, e.originalEvent.changedTouches[0].pageY - window.pageYOffset);\n                }\n                if(!vakata_dnd.is_down) { return; }\n                if(!vakata_dnd.is_drag) {\n                    if(\n                        Math.abs(e.pageX - vakata_dnd.init_x) > (vakata_dnd.is_touch ? $.vakata.dnd.settings.threshold_touch : $.vakata.dnd.settings.threshold) ||\n                        Math.abs(e.pageY - vakata_dnd.init_y) > (vakata_dnd.is_touch ? $.vakata.dnd.settings.threshold_touch : $.vakata.dnd.settings.threshold)\n                    ) {\n                        if(vakata_dnd.helper) {\n                            vakata_dnd.helper.appendTo(document.body);\n                            vakata_dnd.helper_w = vakata_dnd.helper.outerWidth();\n                        }\n                        vakata_dnd.is_drag = true;\n                        $(vakata_dnd.target).one('click.vakata', false);\n                        /**\n                         * triggered on the document when a drag starts\n                         * @event\n                         * @plugin dnd\n                         * @name dnd_start.vakata\n                         * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                         * @param {DOM} element the DOM element being dragged\n                         * @param {jQuery} helper the helper shown next to the mouse\n                         * @param {Object} event the event that caused the start (probably mousemove)\n                         */\n                        $.vakata.dnd._trigger(\"start\", e);\n                    }\n                    else { return; }\n                }\n\n                var d  = false, w  = false,\n                    dh = false, wh = false,\n                    dw = false, ww = false,\n                    dt = false, dl = false,\n                    ht = false, hl = false;\n\n                vakata_dnd.scroll_t = 0;\n                vakata_dnd.scroll_l = 0;\n                vakata_dnd.scroll_e = false;\n                $($(e.target).parentsUntil(\"body\").addBack().get().reverse())\n                    .filter(function () {\n                        return\t(/^auto|scroll$/).test($(this).css(\"overflow\")) &&\n                            (this.scrollHeight > this.offsetHeight || this.scrollWidth > this.offsetWidth);\n                    })\n                    .each(function () {\n                        var t = $(this), o = t.offset();\n                        if(this.scrollHeight > this.offsetHeight) {\n                            if(o.top + t.height() - e.pageY < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_t = 1; }\n                            if(e.pageY - o.top < $.vakata.dnd.settings.scroll_proximity)\t\t\t\t{ vakata_dnd.scroll_t = -1; }\n                        }\n                        if(this.scrollWidth > this.offsetWidth) {\n                            if(o.left + t.width() - e.pageX < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_l = 1; }\n                            if(e.pageX - o.left < $.vakata.dnd.settings.scroll_proximity)\t\t\t\t{ vakata_dnd.scroll_l = -1; }\n                        }\n                        if(vakata_dnd.scroll_t || vakata_dnd.scroll_l) {\n                            vakata_dnd.scroll_e = $(this);\n                            return false;\n                        }\n                    });\n\n                if(!vakata_dnd.scroll_e) {\n                    d  = $(document); w = $(window);\n                    dh = d.height(); wh = w.height();\n                    dw = d.width(); ww = w.width();\n                    dt = d.scrollTop(); dl = d.scrollLeft();\n                    if(dh > wh && e.pageY - dt < $.vakata.dnd.settings.scroll_proximity)\t\t{ vakata_dnd.scroll_t = -1;  }\n                    if(dh > wh && wh - (e.pageY - dt) < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_t = 1; }\n                    if(dw > ww && e.pageX - dl < $.vakata.dnd.settings.scroll_proximity)\t\t{ vakata_dnd.scroll_l = -1; }\n                    if(dw > ww && ww - (e.pageX - dl) < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_l = 1; }\n                    if(vakata_dnd.scroll_t || vakata_dnd.scroll_l) {\n                        vakata_dnd.scroll_e = d;\n                    }\n                }\n                if(vakata_dnd.scroll_e) { $.vakata.dnd._scroll(true); }\n\n                if(vakata_dnd.helper) {\n                    ht = parseInt(e.pageY + $.vakata.dnd.settings.helper_top, 10);\n                    hl = parseInt(e.pageX + $.vakata.dnd.settings.helper_left, 10);\n                    if(dh && ht + 25 > dh) { ht = dh - 50; }\n                    if(dw && hl + vakata_dnd.helper_w > dw) { hl = dw - (vakata_dnd.helper_w + 2); }\n                    vakata_dnd.helper.css({\n                        left\t: hl + \"px\",\n                        top\t\t: ht + \"px\"\n                    });\n                }\n                /**\n                 * triggered on the document when a drag is in progress\n                 * @event\n                 * @plugin dnd\n                 * @name dnd_move.vakata\n                 * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                 * @param {DOM} element the DOM element being dragged\n                 * @param {jQuery} helper the helper shown next to the mouse\n                 * @param {Object} event the event that caused this to trigger (most likely mousemove)\n                 */\n                $.vakata.dnd._trigger(\"move\", e);\n                return false;\n            },\n            stop : function (e) {\n                if(e.type === \"touchend\" && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0]) {\n                    e.pageX = e.originalEvent.changedTouches[0].pageX;\n                    e.pageY = e.originalEvent.changedTouches[0].pageY;\n                    e.target = document.elementFromPoint(e.originalEvent.changedTouches[0].pageX - window.pageXOffset, e.originalEvent.changedTouches[0].pageY - window.pageYOffset);\n                }\n                if(vakata_dnd.is_drag) {\n                    /**\n                     * triggered on the document when a drag stops (the dragged element is dropped)\n                     * @event\n                     * @plugin dnd\n                     * @name dnd_stop.vakata\n                     * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                     * @param {DOM} element the DOM element being dragged\n                     * @param {jQuery} helper the helper shown next to the mouse\n                     * @param {Object} event the event that caused the stop\n                     */\n                    if (e.target !== vakata_dnd.target) {\n                        $(vakata_dnd.target).off('click.vakata');\n                    }\n                    $.vakata.dnd._trigger(\"stop\", e);\n                }\n                else {\n                    if(e.type === \"touchend\" && e.target === vakata_dnd.target) {\n                        var to = setTimeout(function () { $(e.target).trigger('click'); }, 100);\n                        $(e.target).one('click', function() { if(to) { clearTimeout(to); } });\n                    }\n                }\n                $.vakata.dnd._clean();\n                return false;\n            }\n        };\n    }($));\n\n    // include the dnd plugin by default\n    // $.jstree.defaults.plugins.push(\"dnd\");\n\n\n    /**\n     * ### Massload plugin\n     *\n     * Adds massload functionality to jsTree, so that multiple nodes can be loaded in a single request (only useful with lazy loading).\n     */\n\n    /**\n     * massload configuration\n     *\n     * It is possible to set this to a standard jQuery-like AJAX config.\n     * In addition to the standard jQuery ajax options here you can supply functions for `data` and `url`, the functions will be run in the current instance's scope and a param will be passed indicating which node IDs need to be loaded, the return value of those functions will be used.\n     *\n     * You can also set this to a function, that function will receive the node IDs being loaded as argument and a second param which is a function (callback) which should be called with the result.\n     *\n     * Both the AJAX and the function approach rely on the same return value - an object where the keys are the node IDs, and the value is the children of that node as an array.\n     *\n     *\t{\n     *\t\t\"id1\" : [{ \"text\" : \"Child of ID1\", \"id\" : \"c1\" }, { \"text\" : \"Another child of ID1\", \"id\" : \"c2\" }],\n     *\t\t\"id2\" : [{ \"text\" : \"Child of ID2\", \"id\" : \"c3\" }]\n     *\t}\n     *\n     * @name $.jstree.defaults.massload\n     * @plugin massload\n     */\n    $.jstree.defaults.massload = null;\n    $.jstree.plugins.massload = function (options, parent) {\n        this.init = function (el, options) {\n            this._data.massload = {};\n            parent.init.call(this, el, options);\n        };\n        this._load_nodes = function (nodes, callback, is_callback, force_reload) {\n            var s = this.settings.massload,\n                toLoad = [],\n                m = this._model.data,\n                i, j, dom;\n            if (!is_callback) {\n                for(i = 0, j = nodes.length; i < j; i++) {\n                    if(!m[nodes[i]] || ( (!m[nodes[i]].state.loaded && !m[nodes[i]].state.failed) || force_reload) ) {\n                        toLoad.push(nodes[i]);\n                        dom = this.get_node(nodes[i], true);\n                        if (dom && dom.length) {\n                            dom.addClass(\"jstree-loading\").attr('aria-busy',true);\n                        }\n                    }\n                }\n                this._data.massload = {};\n                if (toLoad.length) {\n                    if($.vakata.is_function(s)) {\n                        return s.call(this, toLoad, function (data) {\n                            var i, j;\n                            if(data) {\n                                for(i in data) {\n                                    if(data.hasOwnProperty(i)) {\n                                        this._data.massload[i] = data[i];\n                                    }\n                                }\n                            }\n                            for(i = 0, j = nodes.length; i < j; i++) {\n                                dom = this.get_node(nodes[i], true);\n                                if (dom && dom.length) {\n                                    dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                                }\n                            }\n                            parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n                        }.bind(this));\n                    }\n                    if(typeof s === 'object' && s && s.url) {\n                        s = $.extend(true, {}, s);\n                        if($.vakata.is_function(s.url)) {\n                            s.url = s.url.call(this, toLoad);\n                        }\n                        if($.vakata.is_function(s.data)) {\n                            s.data = s.data.call(this, toLoad);\n                        }\n                        return $.ajax(s)\n                            .done(function (data,t,x) {\n                                var i, j;\n                                if(data) {\n                                    for(i in data) {\n                                        if(data.hasOwnProperty(i)) {\n                                            this._data.massload[i] = data[i];\n                                        }\n                                    }\n                                }\n                                for(i = 0, j = nodes.length; i < j; i++) {\n                                    dom = this.get_node(nodes[i], true);\n                                    if (dom && dom.length) {\n                                        dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                                    }\n                                }\n                                parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n                            }.bind(this))\n                            .fail(function (f) {\n                                parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n                            }.bind(this));\n                    }\n                }\n            }\n            return parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n        };\n        this._load_node = function (obj, callback) {\n            var data = this._data.massload[obj.id],\n                rslt = null, dom;\n            if(data) {\n                rslt = this[typeof data === 'string' ? '_append_html_data' : '_append_json_data'](\n                    obj,\n                    typeof data === 'string' ? $($.parseHTML(data)).filter(function () { return this.nodeType !== 3; }) : data,\n                    function (status) { callback.call(this, status); }\n                );\n                dom = this.get_node(obj.id, true);\n                if (dom && dom.length) {\n                    dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                }\n                delete this._data.massload[obj.id];\n                return rslt;\n            }\n            return parent._load_node.call(this, obj, callback);\n        };\n    };\n\n\n    /**\n     * ### Search plugin\n     *\n     * Adds search functionality to jsTree.\n     */\n\n    /**\n     * stores all defaults for the search plugin\n     * @name $.jstree.defaults.search\n     * @plugin search\n     */\n    $.jstree.defaults.search = {\n        /**\n         * a jQuery-like AJAX config, which jstree uses if a server should be queried for results.\n         *\n         * A `str` (which is the search string) parameter will be added with the request, an optional `inside` parameter will be added if the search is limited to a node id. The expected result is a JSON array with nodes that need to be opened so that matching nodes will be revealed.\n         * Leave this setting as `false` to not query the server. You can also set this to a function, which will be invoked in the instance's scope and receive 3 parameters - the search string, the callback to call with the array of nodes to load, and the optional node ID to limit the search to\n         * @name $.jstree.defaults.search.ajax\n         * @plugin search\n         */\n        ajax : false,\n        /**\n         * Indicates if the search should be fuzzy or not (should `chnd3` match `child node 3`). Default is `false`.\n         * @name $.jstree.defaults.search.fuzzy\n         * @plugin search\n         */\n        fuzzy : false,\n        /**\n         * Indicates if the search should be case sensitive. Default is `false`.\n         * @name $.jstree.defaults.search.case_sensitive\n         * @plugin search\n         */\n        case_sensitive : false,\n        /**\n         * Indicates if the tree should be filtered (by default) to show only matching nodes (keep in mind this can be a heavy on large trees in old browsers).\n         * This setting can be changed at runtime when calling the search method. Default is `false`.\n         * @name $.jstree.defaults.search.show_only_matches\n         * @plugin search\n         */\n        show_only_matches : false,\n        /**\n         * Indicates if the children of matched element are shown (when show_only_matches is true)\n         * This setting can be changed at runtime when calling the search method. Default is `false`.\n         * @name $.jstree.defaults.search.show_only_matches_children\n         * @plugin search\n         */\n        show_only_matches_children : false,\n        /**\n         * Indicates if all nodes opened to reveal the search result, should be closed when the search is cleared or a new search is performed. Default is `true`.\n         * @name $.jstree.defaults.search.close_opened_onclear\n         * @plugin search\n         */\n        close_opened_onclear : true,\n        /**\n         * Indicates if only leaf nodes should be included in search results. Default is `false`.\n         * @name $.jstree.defaults.search.search_leaves_only\n         * @plugin search\n         */\n        search_leaves_only : false,\n        /**\n         * If set to a function it wil be called in the instance's scope with two arguments - search string and node (where node will be every node in the structure, so use with caution).\n         * If the function returns a truthy value the node will be considered a match (it might not be displayed if search_only_leaves is set to true and the node is not a leaf). Default is `false`.\n         * @name $.jstree.defaults.search.search_callback\n         * @plugin search\n         */\n        search_callback : false\n    };\n\n    $.jstree.plugins.search = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n\n            this._data.search.str = \"\";\n            this._data.search.dom = $();\n            this._data.search.res = [];\n            this._data.search.opn = [];\n            this._data.search.som = false;\n            this._data.search.smc = false;\n            this._data.search.hdn = [];\n\n            this.element\n                .on(\"search.jstree\", function (e, data) {\n                    if(this._data.search.som && data.res.length) {\n                        var m = this._model.data, i, j, p = [], k, l;\n                        for(i = 0, j = data.res.length; i < j; i++) {\n                            if(m[data.res[i]] && !m[data.res[i]].state.hidden) {\n                                p.push(data.res[i]);\n                                p = p.concat(m[data.res[i]].parents);\n                                if(this._data.search.smc) {\n                                    for (k = 0, l = m[data.res[i]].children_d.length; k < l; k++) {\n                                        if (m[m[data.res[i]].children_d[k]] && !m[m[data.res[i]].children_d[k]].state.hidden) {\n                                            p.push(m[data.res[i]].children_d[k]);\n                                        }\n                                    }\n                                }\n                            }\n                        }\n                        p = $.vakata.array_remove_item($.vakata.array_unique(p), $.jstree.root);\n                        this._data.search.hdn = this.hide_all(true);\n                        this.show_node(p, true);\n                        this.redraw(true);\n                    }\n                }.bind(this))\n                .on(\"clear_search.jstree\", function (e, data) {\n                    if(this._data.search.som && data.res.length) {\n                        this.show_node(this._data.search.hdn, true);\n                        this.redraw(true);\n                    }\n                }.bind(this));\n        };\n        /**\n         * used to search the tree nodes for a given string\n         * @name search(str [, skip_async])\n         * @param {String} str the search string\n         * @param {Boolean} skip_async if set to true server will not be queried even if configured\n         * @param {Boolean} show_only_matches if set to true only matching nodes will be shown (keep in mind this can be very slow on large trees or old browsers)\n         * @param {mixed} inside an optional node to whose children to limit the search\n         * @param {Boolean} append if set to true the results of this search are appended to the previous search\n         * @plugin search\n         * @trigger search.jstree\n         */\n        this.search = function (str, skip_async, show_only_matches, inside, append, show_only_matches_children) {\n            if(str === false || $.vakata.trim(str.toString()) === \"\") {\n                return this.clear_search();\n            }\n            inside = this.get_node(inside);\n            inside = inside && inside.id ? inside.id : null;\n            str = str.toString();\n            var s = this.settings.search,\n                a = s.ajax ? s.ajax : false,\n                m = this._model.data,\n                f = null,\n                r = [],\n                p = [], i, j;\n            if(this._data.search.res.length && !append) {\n                this.clear_search();\n            }\n            if(show_only_matches === undefined) {\n                show_only_matches = s.show_only_matches;\n            }\n            if(show_only_matches_children === undefined) {\n                show_only_matches_children = s.show_only_matches_children;\n            }\n            if(!skip_async && a !== false) {\n                if($.vakata.is_function(a)) {\n                    return a.call(this, str, function (d) {\n                        if(d && d.d) { d = d.d; }\n                        this._load_nodes(!$.vakata.is_array(d) ? [] : $.vakata.array_unique(d), function () {\n                            this.search(str, true, show_only_matches, inside, append, show_only_matches_children);\n                        });\n                    }.bind(this), inside);\n                }\n                else {\n                    a = $.extend({}, a);\n                    if(!a.data) { a.data = {}; }\n                    a.data.str = str;\n                    if(inside) {\n                        a.data.inside = inside;\n                    }\n                    if (this._data.search.lastRequest) {\n                        this._data.search.lastRequest.abort();\n                    }\n                    this._data.search.lastRequest = $.ajax(a)\n                        .fail(function () {\n                            this._data.core.last_error = { 'error' : 'ajax', 'plugin' : 'search', 'id' : 'search_01', 'reason' : 'Could not load search parents', 'data' : JSON.stringify(a) };\n                            this.settings.core.error.call(this, this._data.core.last_error);\n                        }.bind(this))\n                        .done(function (d) {\n                            if(d && d.d) { d = d.d; }\n                            this._load_nodes(!$.vakata.is_array(d) ? [] : $.vakata.array_unique(d), function () {\n                                this.search(str, true, show_only_matches, inside, append, show_only_matches_children);\n                            });\n                        }.bind(this));\n                    return this._data.search.lastRequest;\n                }\n            }\n            if(!append) {\n                this._data.search.str = str;\n                this._data.search.dom = $();\n                this._data.search.res = [];\n                this._data.search.opn = [];\n                this._data.search.som = show_only_matches;\n                this._data.search.smc = show_only_matches_children;\n            }\n\n            f = new $.vakata.search(str, true, { caseSensitive : s.case_sensitive, fuzzy : s.fuzzy });\n            $.each(m[inside ? inside : $.jstree.root].children_d, function (ii, i) {\n                var v = m[i];\n                if(v.text && !v.state.hidden && (!s.search_leaves_only || (v.state.loaded && v.children.length === 0)) && ( (s.search_callback && s.search_callback.call(this, str, v)) || (!s.search_callback && f.search(v.text).isMatch) ) ) {\n                    r.push(i);\n                    p = p.concat(v.parents);\n                }\n            });\n            if(r.length) {\n                p = $.vakata.array_unique(p);\n                for(i = 0, j = p.length; i < j; i++) {\n                    if(p[i] !== $.jstree.root && m[p[i]] && this.open_node(p[i], null, 0) === true) {\n                        this._data.search.opn.push(p[i]);\n                    }\n                }\n                if(!append) {\n                    this._data.search.dom = $(this.element[0].querySelectorAll('#' + $.map(r, function (v) { return \"0123456789\".indexOf(v[0]) !== -1 ? '\\\\3' + v[0] + ' ' + v.substr(1).replace($.jstree.idregex,'\\\\$&') : v.replace($.jstree.idregex,'\\\\$&'); }).join(', #')));\n                    this._data.search.res = r;\n                }\n                else {\n                    this._data.search.dom = this._data.search.dom.add($(this.element[0].querySelectorAll('#' + $.map(r, function (v) { return \"0123456789\".indexOf(v[0]) !== -1 ? '\\\\3' + v[0] + ' ' + v.substr(1).replace($.jstree.idregex,'\\\\$&') : v.replace($.jstree.idregex,'\\\\$&'); }).join(', #'))));\n                    this._data.search.res = $.vakata.array_unique(this._data.search.res.concat(r));\n                }\n                this._data.search.dom.children(\".jstree-anchor\").addClass('jstree-search');\n            }\n            /**\n             * triggered after search is complete\n             * @event\n             * @name search.jstree\n             * @param {jQuery} nodes a jQuery collection of matching nodes\n             * @param {String} str the search string\n             * @param {Array} res a collection of objects represeing the matching nodes\n             * @plugin search\n             */\n            this.trigger('search', { nodes : this._data.search.dom, str : str, res : this._data.search.res, show_only_matches : show_only_matches });\n        };\n        /**\n         * used to clear the last search (removes classes and shows all nodes if filtering is on)\n         * @name clear_search()\n         * @plugin search\n         * @trigger clear_search.jstree\n         */\n        this.clear_search = function () {\n            if(this.settings.search.close_opened_onclear) {\n                this.close_node(this._data.search.opn, 0);\n            }\n            /**\n             * triggered after search is complete\n             * @event\n             * @name clear_search.jstree\n             * @param {jQuery} nodes a jQuery collection of matching nodes (the result from the last search)\n             * @param {String} str the search string (the last search string)\n             * @param {Array} res a collection of objects represeing the matching nodes (the result from the last search)\n             * @plugin search\n             */\n            this.trigger('clear_search', { 'nodes' : this._data.search.dom, str : this._data.search.str, res : this._data.search.res });\n            if(this._data.search.res.length) {\n                this._data.search.dom = $(this.element[0].querySelectorAll('#' + $.map(this._data.search.res, function (v) {\n                    return \"0123456789\".indexOf(v[0]) !== -1 ? '\\\\3' + v[0] + ' ' + v.substr(1).replace($.jstree.idregex,'\\\\$&') : v.replace($.jstree.idregex,'\\\\$&');\n                }).join(', #')));\n                this._data.search.dom.children(\".jstree-anchor\").removeClass(\"jstree-search\");\n            }\n            this._data.search.str = \"\";\n            this._data.search.res = [];\n            this._data.search.opn = [];\n            this._data.search.dom = $();\n        };\n\n        this.redraw_node = function(obj, deep, callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if(obj) {\n                if($.inArray(obj.id, this._data.search.res) !== -1) {\n                    var i, j, tmp = null;\n                    for(i = 0, j = obj.childNodes.length; i < j; i++) {\n                        if(obj.childNodes[i] && obj.childNodes[i].className && obj.childNodes[i].className.indexOf(\"jstree-anchor\") !== -1) {\n                            tmp = obj.childNodes[i];\n                            break;\n                        }\n                    }\n                    if(tmp) {\n                        tmp.className += ' jstree-search';\n                    }\n                }\n            }\n            return obj;\n        };\n    };\n\n    // helpers\n    (function ($) {\n        // from http://kiro.me/projects/fuse.html\n        $.vakata.search = function(pattern, txt, options) {\n            options = options || {};\n            options = $.extend({}, $.vakata.search.defaults, options);\n            if(options.fuzzy !== false) {\n                options.fuzzy = true;\n            }\n            pattern = options.caseSensitive ? pattern : pattern.toLowerCase();\n            var MATCH_LOCATION\t= options.location,\n                MATCH_DISTANCE\t= options.distance,\n                MATCH_THRESHOLD\t= options.threshold,\n                patternLen = pattern.length,\n                matchmask, pattern_alphabet, match_bitapScore, search;\n            if(patternLen > 32) {\n                options.fuzzy = false;\n            }\n            if(options.fuzzy) {\n                matchmask = 1 << (patternLen - 1);\n                pattern_alphabet = (function () {\n                    var mask = {},\n                        i = 0;\n                    for (i = 0; i < patternLen; i++) {\n                        mask[pattern.charAt(i)] = 0;\n                    }\n                    for (i = 0; i < patternLen; i++) {\n                        mask[pattern.charAt(i)] |= 1 << (patternLen - i - 1);\n                    }\n                    return mask;\n                }());\n                match_bitapScore = function (e, x) {\n                    var accuracy = e / patternLen,\n                        proximity = Math.abs(MATCH_LOCATION - x);\n                    if(!MATCH_DISTANCE) {\n                        return proximity ? 1.0 : accuracy;\n                    }\n                    return accuracy + (proximity / MATCH_DISTANCE);\n                };\n            }\n            search = function (text) {\n                text = options.caseSensitive ? text : text.toLowerCase();\n                if(pattern === text || text.indexOf(pattern) !== -1) {\n                    return {\n                        isMatch: true,\n                        score: 0\n                    };\n                }\n                if(!options.fuzzy) {\n                    return {\n                        isMatch: false,\n                        score: 1\n                    };\n                }\n                var i, j,\n                    textLen = text.length,\n                    scoreThreshold = MATCH_THRESHOLD,\n                    bestLoc = text.indexOf(pattern, MATCH_LOCATION),\n                    binMin, binMid,\n                    binMax = patternLen + textLen,\n                    lastRd, start, finish, rd, charMatch,\n                    score = 1,\n                    locations = [];\n                if (bestLoc !== -1) {\n                    scoreThreshold = Math.min(match_bitapScore(0, bestLoc), scoreThreshold);\n                    bestLoc = text.lastIndexOf(pattern, MATCH_LOCATION + patternLen);\n                    if (bestLoc !== -1) {\n                        scoreThreshold = Math.min(match_bitapScore(0, bestLoc), scoreThreshold);\n                    }\n                }\n                bestLoc = -1;\n                for (i = 0; i < patternLen; i++) {\n                    binMin = 0;\n                    binMid = binMax;\n                    while (binMin < binMid) {\n                        if (match_bitapScore(i, MATCH_LOCATION + binMid) <= scoreThreshold) {\n                            binMin = binMid;\n                        } else {\n                            binMax = binMid;\n                        }\n                        binMid = Math.floor((binMax - binMin) / 2 + binMin);\n                    }\n                    binMax = binMid;\n                    start = Math.max(1, MATCH_LOCATION - binMid + 1);\n                    finish = Math.min(MATCH_LOCATION + binMid, textLen) + patternLen;\n                    rd = new Array(finish + 2);\n                    rd[finish + 1] = (1 << i) - 1;\n                    for (j = finish; j >= start; j--) {\n                        charMatch = pattern_alphabet[text.charAt(j - 1)];\n                        if (i === 0) {\n                            rd[j] = ((rd[j + 1] << 1) | 1) & charMatch;\n                        } else {\n                            rd[j] = ((rd[j + 1] << 1) | 1) & charMatch | (((lastRd[j + 1] | lastRd[j]) << 1) | 1) | lastRd[j + 1];\n                        }\n                        if (rd[j] & matchmask) {\n                            score = match_bitapScore(i, j - 1);\n                            if (score <= scoreThreshold) {\n                                scoreThreshold = score;\n                                bestLoc = j - 1;\n                                locations.push(bestLoc);\n                                if (bestLoc > MATCH_LOCATION) {\n                                    start = Math.max(1, 2 * MATCH_LOCATION - bestLoc);\n                                } else {\n                                    break;\n                                }\n                            }\n                        }\n                    }\n                    if (match_bitapScore(i + 1, MATCH_LOCATION) > scoreThreshold) {\n                        break;\n                    }\n                    lastRd = rd;\n                }\n                return {\n                    isMatch: bestLoc >= 0,\n                    score: score\n                };\n            };\n            return txt === true ? { 'search' : search } : search(txt);\n        };\n        $.vakata.search.defaults = {\n            location : 0,\n            distance : 100,\n            threshold : 0.6,\n            fuzzy : false,\n            caseSensitive : false\n        };\n    }($));\n\n    // include the search plugin by default\n    // $.jstree.defaults.plugins.push(\"search\");\n\n\n    /**\n     * ### Sort plugin\n     *\n     * Automatically sorts all siblings in the tree according to a sorting function.\n     */\n\n    /**\n     * the settings function used to sort the nodes.\n     * It is executed in the tree's context, accepts two nodes as arguments and should return `1` or `-1`.\n     * @name $.jstree.defaults.sort\n     * @plugin sort\n     */\n    $.jstree.defaults.sort = function (a, b) {\n        //return this.get_type(a) === this.get_type(b) ? (this.get_text(a) > this.get_text(b) ? 1 : -1) : this.get_type(a) >= this.get_type(b);\n        return this.get_text(a) > this.get_text(b) ? 1 : -1;\n    };\n    $.jstree.plugins.sort = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n            this.element\n                .on(\"model.jstree\", function (e, data) {\n                    this.sort(data.parent, true);\n                }.bind(this))\n                .on(\"rename_node.jstree create_node.jstree\", function (e, data) {\n                    this.sort(data.parent || data.node.parent, false);\n                    this.redraw_node(data.parent || data.node.parent, true);\n                }.bind(this))\n                .on(\"move_node.jstree copy_node.jstree\", function (e, data) {\n                    this.sort(data.parent, false);\n                    this.redraw_node(data.parent, true);\n                }.bind(this));\n        };\n        /**\n         * used to sort a node's children\n         * @private\n         * @name sort(obj [, deep])\n         * @param  {mixed} obj the node\n         * @param {Boolean} deep if set to `true` nodes are sorted recursively.\n         * @plugin sort\n         * @trigger search.jstree\n         */\n        this.sort = function (obj, deep) {\n            var i, j;\n            obj = this.get_node(obj);\n            if(obj && obj.children && obj.children.length) {\n                obj.children.sort(this.settings.sort.bind(this));\n                if(deep) {\n                    for(i = 0, j = obj.children_d.length; i < j; i++) {\n                        this.sort(obj.children_d[i], false);\n                    }\n                }\n            }\n        };\n    };\n\n    // include the sort plugin by default\n    // $.jstree.defaults.plugins.push(\"sort\");\n\n    /**\n     * ### State plugin\n     *\n     * Saves the state of the tree (selected nodes, opened nodes) on the user's computer using available options (localStorage, cookies, etc)\n     */\n\n    var to = false;\n    /**\n     * stores all defaults for the state plugin\n     * @name $.jstree.defaults.state\n     * @plugin state\n     */\n    $.jstree.defaults.state = {\n        /**\n         * A string for the key to use when saving the current tree (change if using multiple trees in your project). Defaults to `jstree`.\n         * @name $.jstree.defaults.state.key\n         * @plugin state\n         */\n        key\t\t: 'jstree',\n        /**\n         * A space separated list of events that trigger a state save. Defaults to `changed.jstree open_node.jstree close_node.jstree`.\n         * @name $.jstree.defaults.state.events\n         * @plugin state\n         */\n        events\t: 'changed.jstree open_node.jstree close_node.jstree check_node.jstree uncheck_node.jstree',\n        /**\n         * Time in milliseconds after which the state will expire. Defaults to 'false' meaning - no expire.\n         * @name $.jstree.defaults.state.ttl\n         * @plugin state\n         */\n        ttl\t\t: false,\n        /**\n         * A function that will be executed prior to restoring state with one argument - the state object. Can be used to clear unwanted parts of the state.\n         * @name $.jstree.defaults.state.filter\n         * @plugin state\n         */\n        filter\t: false,\n        /**\n         * Should loaded nodes be restored (setting this to true means that it is possible that the whole tree will be loaded for some users - use with caution). Defaults to `false`\n         * @name $.jstree.defaults.state.preserve_loaded\n         * @plugin state\n         */\n        preserve_loaded : false\n    };\n    $.jstree.plugins.state = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n            var bind = function () {\n                this.element.on(this.settings.state.events, function () {\n                    if(to) { clearTimeout(to); }\n                    to = setTimeout(function () { this.save_state(); }.bind(this), 100);\n                }.bind(this));\n                /**\n                 * triggered when the state plugin is finished restoring the state (and immediately after ready if there is no state to restore).\n                 * @event\n                 * @name state_ready.jstree\n                 * @plugin state\n                 */\n                this.trigger('state_ready');\n            }.bind(this);\n            this.element\n                .on(\"ready.jstree\", function (e, data) {\n                    this.element.one(\"restore_state.jstree\", bind);\n                    if(!this.restore_state()) { bind(); }\n                }.bind(this));\n        };\n        /**\n         * save the state\n         * @name save_state()\n         * @plugin state\n         */\n        this.save_state = function () {\n            var tm = this.get_state();\n            if (!this.settings.state.preserve_loaded) {\n                delete tm.core.loaded;\n            }\n            var st = { 'state' : tm, 'ttl' : this.settings.state.ttl, 'sec' : +(new Date()) };\n            $.vakata.storage.set(this.settings.state.key, JSON.stringify(st));\n        };\n        /**\n         * restore the state from the user's computer\n         * @name restore_state()\n         * @plugin state\n         */\n        this.restore_state = function () {\n            var k = $.vakata.storage.get(this.settings.state.key);\n            if(!!k) { try { k = JSON.parse(k); } catch(ex) { return false; } }\n            if(!!k && k.ttl && k.sec && +(new Date()) - k.sec > k.ttl) { return false; }\n            if(!!k && k.state) { k = k.state; }\n            if(!!k && $.vakata.is_function(this.settings.state.filter)) { k = this.settings.state.filter.call(this, k); }\n            if(!!k) {\n                if (!this.settings.state.preserve_loaded) {\n                    delete k.core.loaded;\n                }\n                this.element.one(\"set_state.jstree\", function (e, data) { data.instance.trigger('restore_state', { 'state' : $.extend(true, {}, k) }); });\n                this.set_state(k);\n                return true;\n            }\n            return false;\n        };\n        /**\n         * clear the state on the user's computer\n         * @name clear_state()\n         * @plugin state\n         */\n        this.clear_state = function () {\n            return $.vakata.storage.del(this.settings.state.key);\n        };\n    };\n\n    (function ($, undefined) {\n        $.vakata.storage = {\n            // simply specifying the functions in FF throws an error\n            set : function (key, val) { return window.localStorage.setItem(key, val); },\n            get : function (key) { return window.localStorage.getItem(key); },\n            del : function (key) { return window.localStorage.removeItem(key); }\n        };\n    }($));\n\n    // include the state plugin by default\n    // $.jstree.defaults.plugins.push(\"state\");\n\n    /**\n     * ### Types plugin\n     *\n     * Makes it possible to add predefined types for groups of nodes, which make it possible to easily control nesting rules and icon for each group.\n     */\n\n    /**\n     * An object storing all types as key value pairs, where the key is the type name and the value is an object that could contain following keys (all optional).\n     *\n     * * `max_children` the maximum number of immediate children this node type can have. Do not specify or set to `-1` for unlimited.\n     * * `max_depth` the maximum number of nesting this node type can have. A value of `1` would mean that the node can have children, but no grandchildren. Do not specify or set to `-1` for unlimited.\n     * * `valid_children` an array of node type strings, that nodes of this type can have as children. Do not specify or set to `-1` for no limits.\n     * * `icon` a string - can be a path to an icon or a className, if using an image that is in the current directory use a `./` prefix, otherwise it will be detected as a class. Omit to use the default icon from your theme.\n     * * `li_attr` an object of values which will be used to add HTML attributes on the resulting LI DOM node (merged with the node's own data)\n     * * `a_attr` an object of values which will be used to add HTML attributes on the resulting A DOM node (merged with the node's own data)\n     *\n     * There are two predefined types:\n     *\n     * * `#` represents the root of the tree, for example `max_children` would control the maximum number of root nodes.\n     * * `default` represents the default node - any settings here will be applied to all nodes that do not have a type specified.\n     *\n     * @name $.jstree.defaults.types\n     * @plugin types\n     */\n    $.jstree.defaults.types = {\n        'default' : {}\n    };\n    $.jstree.defaults.types[$.jstree.root] = {};\n\n    $.jstree.plugins.types = function (options, parent) {\n        this.init = function (el, options) {\n            var i, j;\n            if(options && options.types && options.types['default']) {\n                for(i in options.types) {\n                    if(i !== \"default\" && i !== $.jstree.root && options.types.hasOwnProperty(i)) {\n                        for(j in options.types['default']) {\n                            if(options.types['default'].hasOwnProperty(j) && options.types[i][j] === undefined) {\n                                options.types[i][j] = options.types['default'][j];\n                            }\n                        }\n                    }\n                }\n            }\n            parent.init.call(this, el, options);\n            this._model.data[$.jstree.root].type = $.jstree.root;\n        };\n        this.refresh = function (skip_loading, forget_state) {\n            parent.refresh.call(this, skip_loading, forget_state);\n            this._model.data[$.jstree.root].type = $.jstree.root;\n        };\n        this.bind = function () {\n            this.element\n                .on('model.jstree', function (e, data) {\n                    var m = this._model.data,\n                        dpc = data.nodes,\n                        t = this.settings.types,\n                        i, j, c = 'default', k;\n                    for(i = 0, j = dpc.length; i < j; i++) {\n                        c = 'default';\n                        if(m[dpc[i]].original && m[dpc[i]].original.type && t[m[dpc[i]].original.type]) {\n                            c = m[dpc[i]].original.type;\n                        }\n                        if(m[dpc[i]].data && m[dpc[i]].data.jstree && m[dpc[i]].data.jstree.type && t[m[dpc[i]].data.jstree.type]) {\n                            c = m[dpc[i]].data.jstree.type;\n                        }\n                        m[dpc[i]].type = c;\n                        if(m[dpc[i]].icon === true && t[c].icon !== undefined) {\n                            m[dpc[i]].icon = t[c].icon;\n                        }\n                        if(t[c].li_attr !== undefined && typeof t[c].li_attr === 'object') {\n                            for (k in t[c].li_attr) {\n                                if (t[c].li_attr.hasOwnProperty(k)) {\n                                    if (k === 'id') {\n                                        continue;\n                                    }\n                                    else if (m[dpc[i]].li_attr[k] === undefined) {\n                                        m[dpc[i]].li_attr[k] = t[c].li_attr[k];\n                                    }\n                                    else if (k === 'class') {\n                                        m[dpc[i]].li_attr['class'] = t[c].li_attr['class'] + ' ' + m[dpc[i]].li_attr['class'];\n                                    }\n                                }\n                            }\n                        }\n                        if(t[c].a_attr !== undefined && typeof t[c].a_attr === 'object') {\n                            for (k in t[c].a_attr) {\n                                if (t[c].a_attr.hasOwnProperty(k)) {\n                                    if (k === 'id') {\n                                        continue;\n                                    }\n                                    else if (m[dpc[i]].a_attr[k] === undefined) {\n                                        m[dpc[i]].a_attr[k] = t[c].a_attr[k];\n                                    }\n                                    else if (k === 'href' && m[dpc[i]].a_attr[k] === '#') {\n                                        m[dpc[i]].a_attr['href'] = t[c].a_attr['href'];\n                                    }\n                                    else if (k === 'class') {\n                                        m[dpc[i]].a_attr['class'] = t[c].a_attr['class'] + ' ' + m[dpc[i]].a_attr['class'];\n                                    }\n                                }\n                            }\n                        }\n                    }\n                    m[$.jstree.root].type = $.jstree.root;\n                }.bind(this));\n            parent.bind.call(this);\n        };\n        this.get_json = function (obj, options, flat) {\n            var i, j,\n                m = this._model.data,\n                opt = options ? $.extend(true, {}, options, {no_id:false}) : {},\n                tmp = parent.get_json.call(this, obj, opt, flat);\n            if(tmp === false) { return false; }\n            if($.vakata.is_array(tmp)) {\n                for(i = 0, j = tmp.length; i < j; i++) {\n                    tmp[i].type = tmp[i].id && m[tmp[i].id] && m[tmp[i].id].type ? m[tmp[i].id].type : \"default\";\n                    if(options && options.no_id) {\n                        delete tmp[i].id;\n                        if(tmp[i].li_attr && tmp[i].li_attr.id) {\n                            delete tmp[i].li_attr.id;\n                        }\n                        if(tmp[i].a_attr && tmp[i].a_attr.id) {\n                            delete tmp[i].a_attr.id;\n                        }\n                    }\n                }\n            }\n            else {\n                tmp.type = tmp.id && m[tmp.id] && m[tmp.id].type ? m[tmp.id].type : \"default\";\n                if(options && options.no_id) {\n                    tmp = this._delete_ids(tmp);\n                }\n            }\n            return tmp;\n        };\n        this._delete_ids = function (tmp) {\n            if($.vakata.is_array(tmp)) {\n                for(var i = 0, j = tmp.length; i < j; i++) {\n                    tmp[i] = this._delete_ids(tmp[i]);\n                }\n                return tmp;\n            }\n            delete tmp.id;\n            if(tmp.li_attr && tmp.li_attr.id) {\n                delete tmp.li_attr.id;\n            }\n            if(tmp.a_attr && tmp.a_attr.id) {\n                delete tmp.a_attr.id;\n            }\n            if(tmp.children && $.vakata.is_array(tmp.children)) {\n                tmp.children = this._delete_ids(tmp.children);\n            }\n            return tmp;\n        };\n        this.check = function (chk, obj, par, pos, more) {\n            if(parent.check.call(this, chk, obj, par, pos, more) === false) { return false; }\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            par = par && par.id ? par : this.get_node(par);\n            var m = obj && obj.id ? (more && more.origin ? more.origin : $.jstree.reference(obj.id)) : null, tmp, d, i, j;\n            m = m && m._model && m._model.data ? m._model.data : null;\n            switch(chk) {\n                case \"create_node\":\n                case \"move_node\":\n                case \"copy_node\":\n                    if(chk !== 'move_node' || $.inArray(obj.id, par.children) === -1) {\n                        tmp = this.get_rules(par);\n                        if(tmp.max_children !== undefined && tmp.max_children !== -1 && tmp.max_children === par.children.length) {\n                            this._data.core.last_error = { 'error' : 'check', 'plugin' : 'types', 'id' : 'types_01', 'reason' : 'max_children prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                            return false;\n                        }\n                        if(tmp.valid_children !== undefined && tmp.valid_children !== -1 && $.inArray((obj.type || 'default'), tmp.valid_children) === -1) {\n                            this._data.core.last_error = { 'error' : 'check', 'plugin' : 'types', 'id' : 'types_02', 'reason' : 'valid_children prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                            return false;\n                        }\n                        if(m && obj.children_d && obj.parents) {\n                            d = 0;\n                            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                                d = Math.max(d, m[obj.children_d[i]].parents.length);\n                            }\n                            d = d - obj.parents.length + 1;\n                        }\n                        if(d <= 0 || d === undefined) { d = 1; }\n                        do {\n                            if(tmp.max_depth !== undefined && tmp.max_depth !== -1 && tmp.max_depth < d) {\n                                this._data.core.last_error = { 'error' : 'check', 'plugin' : 'types', 'id' : 'types_03', 'reason' : 'max_depth prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                                return false;\n                            }\n                            par = this.get_node(par.parent);\n                            tmp = this.get_rules(par);\n                            d++;\n                        } while(par);\n                    }\n                    break;\n            }\n            return true;\n        };\n        /**\n         * used to retrieve the type settings object for a node\n         * @name get_rules(obj)\n         * @param {mixed} obj the node to find the rules for\n         * @return {Object}\n         * @plugin types\n         */\n        this.get_rules = function (obj) {\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var tmp = this.get_type(obj, true);\n            if(tmp.max_depth === undefined) { tmp.max_depth = -1; }\n            if(tmp.max_children === undefined) { tmp.max_children = -1; }\n            if(tmp.valid_children === undefined) { tmp.valid_children = -1; }\n            return tmp;\n        };\n        /**\n         * used to retrieve the type string or settings object for a node\n         * @name get_type(obj [, rules])\n         * @param {mixed} obj the node to find the rules for\n         * @param {Boolean} rules if set to `true` instead of a string the settings object will be returned\n         * @return {String|Object}\n         * @plugin types\n         */\n        this.get_type = function (obj, rules) {\n            obj = this.get_node(obj);\n            return (!obj) ? false : ( rules ? $.extend({ 'type' : obj.type }, this.settings.types[obj.type]) : obj.type);\n        };\n        /**\n         * used to change a node's type\n         * @name set_type(obj, type)\n         * @param {mixed} obj the node to change\n         * @param {String} type the new type\n         * @plugin types\n         */\n        this.set_type = function (obj, type) {\n            var m = this._model.data, t, t1, t2, old_type, old_icon, k, d, a;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.set_type(obj[t1], type);\n                }\n                return true;\n            }\n            t = this.settings.types;\n            obj = this.get_node(obj);\n            if(!t[type] || !obj) { return false; }\n            d = this.get_node(obj, true);\n            if (d && d.length) {\n                a = d.children('.jstree-anchor');\n            }\n            old_type = obj.type;\n            old_icon = this.get_icon(obj);\n            obj.type = type;\n            if(old_icon === true || !t[old_type] || (t[old_type].icon !== undefined && old_icon === t[old_type].icon)) {\n                this.set_icon(obj, t[type].icon !== undefined ? t[type].icon : true);\n            }\n\n            // remove old type props\n            if(t[old_type] && t[old_type].li_attr !== undefined && typeof t[old_type].li_attr === 'object') {\n                for (k in t[old_type].li_attr) {\n                    if (t[old_type].li_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].li_attr['class'] = (m[obj.id].li_attr['class'] || '').replace(t[old_type].li_attr[k], '');\n                            if (d) { d.removeClass(t[old_type].li_attr[k]); }\n                        }\n                        else if (m[obj.id].li_attr[k] === t[old_type].li_attr[k]) {\n                            m[obj.id].li_attr[k] = null;\n                            if (d) { d.removeAttr(k); }\n                        }\n                    }\n                }\n            }\n            if(t[old_type] && t[old_type].a_attr !== undefined && typeof t[old_type].a_attr === 'object') {\n                for (k in t[old_type].a_attr) {\n                    if (t[old_type].a_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].a_attr['class'] = (m[obj.id].a_attr['class'] || '').replace(t[old_type].a_attr[k], '');\n                            if (a) { a.removeClass(t[old_type].a_attr[k]); }\n                        }\n                        else if (m[obj.id].a_attr[k] === t[old_type].a_attr[k]) {\n                            if (k === 'href') {\n                                m[obj.id].a_attr[k] = '#';\n                                if (a) { a.attr('href', '#'); }\n                            }\n                            else {\n                                delete m[obj.id].a_attr[k];\n                                if (a) { a.removeAttr(k); }\n                            }\n                        }\n                    }\n                }\n            }\n\n            // add new props\n            if(t[type].li_attr !== undefined && typeof t[type].li_attr === 'object') {\n                for (k in t[type].li_attr) {\n                    if (t[type].li_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (m[obj.id].li_attr[k] === undefined) {\n                            m[obj.id].li_attr[k] = t[type].li_attr[k];\n                            if (d) {\n                                if (k === 'class') {\n                                    d.addClass(t[type].li_attr[k]);\n                                }\n                                else {\n                                    d.attr(k, t[type].li_attr[k]);\n                                }\n                            }\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].li_attr['class'] = t[type].li_attr[k] + ' ' + m[obj.id].li_attr['class'];\n                            if (d) { d.addClass(t[type].li_attr[k]); }\n                        }\n                    }\n                }\n            }\n            if(t[type].a_attr !== undefined && typeof t[type].a_attr === 'object') {\n                for (k in t[type].a_attr) {\n                    if (t[type].a_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (m[obj.id].a_attr[k] === undefined) {\n                            m[obj.id].a_attr[k] = t[type].a_attr[k];\n                            if (a) {\n                                if (k === 'class') {\n                                    a.addClass(t[type].a_attr[k]);\n                                }\n                                else {\n                                    a.attr(k, t[type].a_attr[k]);\n                                }\n                            }\n                        }\n                        else if (k === 'href' && m[obj.id].a_attr[k] === '#') {\n                            m[obj.id].a_attr['href'] = t[type].a_attr['href'];\n                            if (a) { a.attr('href', t[type].a_attr['href']); }\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].a_attr['class'] = t[type].a_attr['class'] + ' ' + m[obj.id].a_attr['class'];\n                            if (a) { a.addClass(t[type].a_attr[k]); }\n                        }\n                    }\n                }\n            }\n\n            return true;\n        };\n    };\n    // include the types plugin by default\n    // $.jstree.defaults.plugins.push(\"types\");\n\n\n    /**\n     * ### Unique plugin\n     *\n     * Enforces that no nodes with the same name can coexist as siblings.\n     */\n\n    /**\n     * stores all defaults for the unique plugin\n     * @name $.jstree.defaults.unique\n     * @plugin unique\n     */\n    $.jstree.defaults.unique = {\n        /**\n         * Indicates if the comparison should be case sensitive. Default is `false`.\n         * @name $.jstree.defaults.unique.case_sensitive\n         * @plugin unique\n         */\n        case_sensitive : false,\n        /**\n         * Indicates if white space should be trimmed before the comparison. Default is `false`.\n         * @name $.jstree.defaults.unique.trim_whitespace\n         * @plugin unique\n         */\n        trim_whitespace : false,\n        /**\n         * A callback executed in the instance's scope when a new node is created and the name is already taken, the two arguments are the conflicting name and the counter. The default will produce results like `New node (2)`.\n         * @name $.jstree.defaults.unique.duplicate\n         * @plugin unique\n         */\n        duplicate : function (name, counter) {\n            return name + ' (' + counter + ')';\n        }\n    };\n\n    $.jstree.plugins.unique = function (options, parent) {\n        this.check = function (chk, obj, par, pos, more) {\n            if(parent.check.call(this, chk, obj, par, pos, more) === false) { return false; }\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            par = par && par.id ? par : this.get_node(par);\n            if(!par || !par.children) { return true; }\n            var n = chk === \"rename_node\" ? pos : obj.text,\n                c = [],\n                s = this.settings.unique.case_sensitive,\n                w = this.settings.unique.trim_whitespace,\n                m = this._model.data, i, j, t;\n            for(i = 0, j = par.children.length; i < j; i++) {\n                t = m[par.children[i]].text;\n                if (!s) {\n                    t = t.toLowerCase();\n                }\n                if (w) {\n                    t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                }\n                c.push(t);\n            }\n            if(!s) { n = n.toLowerCase(); }\n            if (w) { n = n.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, ''); }\n            switch(chk) {\n                case \"delete_node\":\n                    return true;\n                case \"rename_node\":\n                    t = obj.text || '';\n                    if (!s) {\n                        t = t.toLowerCase();\n                    }\n                    if (w) {\n                        t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                    }\n                    i = ($.inArray(n, c) === -1 || (obj.text && t === n));\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_01', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    }\n                    return i;\n                case \"create_node\":\n                    i = ($.inArray(n, c) === -1);\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_04', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    }\n                    return i;\n                case \"copy_node\":\n                    i = ($.inArray(n, c) === -1);\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_02', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    }\n                    return i;\n                case \"move_node\":\n                    i = ( (obj.parent === par.id && (!more || !more.is_multi)) || $.inArray(n, c) === -1);\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_03', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    }\n                    return i;\n            }\n            return true;\n        };\n        this.create_node = function (par, node, pos, callback, is_loaded) {\n            if(!node || node.text === undefined) {\n                if(par === null) {\n                    par = $.jstree.root;\n                }\n                par = this.get_node(par);\n                if(!par) {\n                    return parent.create_node.call(this, par, node, pos, callback, is_loaded);\n                }\n                pos = pos === undefined ? \"last\" : pos;\n                if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                    return parent.create_node.call(this, par, node, pos, callback, is_loaded);\n                }\n                if(!node) { node = {}; }\n                var tmp, n, dpc, i, j, m = this._model.data, s = this.settings.unique.case_sensitive, w = this.settings.unique.trim_whitespace, cb = this.settings.unique.duplicate, t;\n                n = tmp = this.get_string('New node');\n                dpc = [];\n                for(i = 0, j = par.children.length; i < j; i++) {\n                    t = m[par.children[i]].text;\n                    if (!s) {\n                        t = t.toLowerCase();\n                    }\n                    if (w) {\n                        t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                    }\n                    dpc.push(t);\n                }\n                i = 1;\n                t = n;\n                if (!s) {\n                    t = t.toLowerCase();\n                }\n                if (w) {\n                    t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                }\n                while($.inArray(t, dpc) !== -1) {\n                    n = cb.call(this, tmp, (++i)).toString();\n                    t = n;\n                    if (!s) {\n                        t = t.toLowerCase();\n                    }\n                    if (w) {\n                        t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                    }\n                }\n                node.text = n;\n            }\n            return parent.create_node.call(this, par, node, pos, callback, is_loaded);\n        };\n    };\n\n    // include the unique plugin by default\n    // $.jstree.defaults.plugins.push(\"unique\");\n\n\n    /**\n     * ### Wholerow plugin\n     *\n     * Makes each node appear block level. Making selection easier. May cause slow down for large trees in old browsers.\n     */\n\n    var div = document.createElement('DIV');\n    div.setAttribute('unselectable','on');\n    div.setAttribute('role','presentation');\n    div.className = 'jstree-wholerow';\n    div.innerHTML = '&#160;';\n    $.jstree.plugins.wholerow = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n\n            this.element\n                .on('ready.jstree set_state.jstree', function () {\n                    this.hide_dots();\n                }.bind(this))\n                .on(\"init.jstree loading.jstree ready.jstree\", function () {\n                    //div.style.height = this._data.core.li_height + 'px';\n                    this.get_container_ul().addClass('jstree-wholerow-ul');\n                }.bind(this))\n                .on(\"deselect_all.jstree\", function (e, data) {\n                    this.element.find('.jstree-wholerow-clicked').removeClass('jstree-wholerow-clicked');\n                }.bind(this))\n                .on(\"changed.jstree\", function (e, data) {\n                    this.element.find('.jstree-wholerow-clicked').removeClass('jstree-wholerow-clicked');\n                    var tmp = false, i, j;\n                    for(i = 0, j = data.selected.length; i < j; i++) {\n                        tmp = this.get_node(data.selected[i], true);\n                        if(tmp && tmp.length) {\n                            tmp.children('.jstree-wholerow').addClass('jstree-wholerow-clicked');\n                        }\n                    }\n                }.bind(this))\n                .on(\"open_node.jstree\", function (e, data) {\n                    this.get_node(data.node, true).find('.jstree-clicked').parent().children('.jstree-wholerow').addClass('jstree-wholerow-clicked');\n                }.bind(this))\n                .on(\"hover_node.jstree dehover_node.jstree\", function (e, data) {\n                    if(e.type === \"hover_node\" && this.is_disabled(data.node)) { return; }\n                    this.get_node(data.node, true).children('.jstree-wholerow')[e.type === \"hover_node\"?\"addClass\":\"removeClass\"]('jstree-wholerow-hovered');\n                }.bind(this))\n                .on(\"contextmenu.jstree\", \".jstree-wholerow\", function (e) {\n                    if (this._data.contextmenu) {\n                        e.preventDefault();\n                        var tmp = $.Event('contextmenu', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey, pageX : e.pageX, pageY : e.pageY });\n                        $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp);\n                    }\n                }.bind(this))\n                /*!\n\t\t\t\t.on(\"mousedown.jstree touchstart.jstree\", \".jstree-wholerow\", function (e) {\n\t\t\t\t\t\tif(e.target === e.currentTarget) {\n\t\t\t\t\t\t\tvar a = $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\");\n\t\t\t\t\t\t\te.target = a[0];\n\t\t\t\t\t\t\ta.trigger(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t})\n\t\t\t\t*/\n                .on(\"click.jstree\", \".jstree-wholerow\", function (e) {\n                    e.stopImmediatePropagation();\n                    var tmp = $.Event('click', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey });\n                    $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp).trigger('focus');\n                })\n                .on(\"dblclick.jstree\", \".jstree-wholerow\", function (e) {\n                    e.stopImmediatePropagation();\n                    var tmp = $.Event('dblclick', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey });\n                    $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp).trigger('focus');\n                })\n                .on(\"click.jstree\", \".jstree-leaf > .jstree-ocl\", function (e) {\n                    e.stopImmediatePropagation();\n                    var tmp = $.Event('click', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey });\n                    $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp).trigger('focus');\n                }.bind(this))\n                .on(\"mouseover.jstree\", \".jstree-wholerow, .jstree-icon\", function (e) {\n                    e.stopImmediatePropagation();\n                    if(!this.is_disabled(e.currentTarget)) {\n                        this.hover_node(e.currentTarget);\n                    }\n                    return false;\n                }.bind(this))\n                .on(\"mouseleave.jstree\", \".jstree-node\", function (e) {\n                    this.dehover_node(e.currentTarget);\n                }.bind(this));\n        };\n        this.teardown = function () {\n            if(this.settings.wholerow) {\n                this.element.find(\".jstree-wholerow\").remove();\n            }\n            parent.teardown.call(this);\n        };\n        this.redraw_node = function(obj, deep, callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if(obj) {\n                var tmp = div.cloneNode(true);\n                //tmp.style.height = this._data.core.li_height + 'px';\n                if($.inArray(obj.id, this._data.core.selected) !== -1) { tmp.className += ' jstree-wholerow-clicked'; }\n                if(this._data.core.focused && this._data.core.focused === obj.id) { tmp.className += ' jstree-wholerow-hovered'; }\n                obj.insertBefore(tmp, obj.childNodes[0]);\n            }\n            return obj;\n        };\n    };\n    // include the wholerow plugin by default\n    // $.jstree.defaults.plugins.push(\"wholerow\");\n    if(window.customElements && Object && Object.create) {\n        var proto = Object.create(HTMLElement.prototype);\n        proto.createdCallback = function () {\n            var c = { core : {}, plugins : [] }, i;\n            for(i in $.jstree.plugins) {\n                if($.jstree.plugins.hasOwnProperty(i) && this.attributes[i]) {\n                    c.plugins.push(i);\n                    if(this.getAttribute(i) && JSON.parse(this.getAttribute(i))) {\n                        c[i] = JSON.parse(this.getAttribute(i));\n                    }\n                }\n            }\n            for(i in $.jstree.defaults.core) {\n                if($.jstree.defaults.core.hasOwnProperty(i) && this.attributes[i]) {\n                    c.core[i] = JSON.parse(this.getAttribute(i)) || this.getAttribute(i);\n                }\n            }\n            $(this).jstree(c);\n        };\n        // proto.attributeChangedCallback = function (name, previous, value) { };\n        try {\n            window.customElements.define(\"vakata-jstree\", function() {}, { prototype: proto });\n        } catch (ignore) { }\n    }\n\n}));\n","Magento_CurrencySymbol/js/symbols-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element)\n            .mage('form')\n            .mage('validation');\n\n        /**\n         * Toggle the field to use the default value\n         *\n         * @param {String} code\n         * @param {String} value\n         */\n        function toggleUseDefault(code, value) {\n            var checkbox = $('#custom_currency_symbol_inherit' + code),\n                input = $('#custom_currency_symbol' + code);\n\n            if (checkbox.is(':checked')) {\n                input.val(value);\n                input.prop('disabled', true);\n            } else {\n                input.prop('disabled', false);\n            }\n        }\n\n        window.toggleUseDefault = toggleUseDefault;\n    };\n});\n","Magento_Eav/js/input-types.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    return function (config) {\n        $('select#frontend_input').each(function () {\n            var select = $(this),\n                currentValue = select.find('option:selected').val(),\n                compatibleTypes = config.inputTypes,\n                enabledTypes = [],\n                iterator,\n                warning = $('<label>')\n                    .hide()\n                    .text($.mage.__('These changes affect all related products.'))\n                    .addClass('mage-error')\n                    .attr({\n                        generated: true, for: select.attr('id')\n                    }),\n                hint = $('<p>')\n                    .hide()\n                    .addClass('note')\n                    .attr({\n                        generated: true\n                    }),\n                hints = config.hints,\n\n            /**\n             * Toggle hint about changes types\n             */\n            toggleWarning = function () {\n                if (select.find('option:selected').val() === currentValue) {\n                    warning.hide();\n                } else {\n                    warning.show();\n                }\n            },\n\n            /**\n             * Toggle hint\n             */\n            toggleHint = function () {\n                if (typeof hints[select.find('option:selected').val()] !== 'undefined') {\n                    select.after(hint.show().text(hints[select.find('option:selected').val()]));\n                } else {\n                    hint.hide();\n                }\n            },\n\n            /**\n             * Remove unsupported options\n             */\n            removeOption = function () {\n                if (!~enabledTypes.indexOf($(this).val())) {\n                    $(this).remove();\n                }\n            };\n\n            // find enabled types for switching dor current input type\n            for (iterator = 0; iterator < compatibleTypes.length; iterator++) {\n                if (compatibleTypes[iterator].indexOf(currentValue) >= 0) {\n                    enabledTypes = compatibleTypes[iterator];\n                }\n            }\n\n            // Check current type (allow only compatible types)\n            if (~enabledTypes.indexOf(currentValue)) {\n                // Enable select and keep only available options (all other will be removed)\n                select.prop('disabled', false).find('option').each(removeOption);\n                // Add warning on page and event for show/hide it\n                select.after(warning).on('change', toggleWarning);\n            }\n            //bind hint toggling on change event\n            select.on('change', toggleHint);\n            //show hint for currently selected value\n            toggleHint();\n        });\n    };\n});\n","vimeo/player.min.js":"/*! @vimeo/player v2.16.4 | (c) 2022 Vimeo | MIT License | https://github.com/vimeo/player.js */\n!function(e,t){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=t():\"function\"==typeof define&&define.amd?define(t):((e=\"undefined\"!=typeof globalThis?globalThis:e||self).Vimeo=e.Vimeo||{},e.Vimeo.Player=t())}(this,function(){\"use strict\";function r(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,\"value\"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var e=\"undefined\"!=typeof global&&\"[object global]\"==={}.toString.call(global);function i(e,t){return 0===e.indexOf(t.toLowerCase())?e:\"\".concat(t.toLowerCase()).concat(e.substr(0,1).toUpperCase()).concat(e.substr(1))}function l(e){return/^(https?:)?\\/\\/((player|www)\\.)?vimeo\\.com(?=$|\\/)/.test(e)}function u(e){var t=0<arguments.length&&void 0!==e?e:{},n=t.id,e=t.url,t=n||e;if(!t)throw new Error(\"An id or url must be passed, either in an options object or as a data-vimeo-id or data-vimeo-url attribute.\");if(e=t,!isNaN(parseFloat(e))&&isFinite(e)&&Math.floor(e)==e)return\"https://vimeo.com/\".concat(t);if(l(t))return t.replace(\"http:\",\"https:\");if(n)throw new TypeError(\"\u201c\".concat(n,\"\u201d is not a valid video id.\"));throw new TypeError(\"\u201c\".concat(t,\"\u201d is not a vimeo.com url.\"))}var t=void 0!==Array.prototype.indexOf,Player=\"undefined\"!=typeof window&&void 0!==window.postMessage;if(!(e||t&&Player))throw new Error(\"Sorry, the Vimeo Player API is not available in this browser.\");var n,o,a=\"undefined\"!=typeof globalThis?globalThis:\"undefined\"!=typeof window?window:\"undefined\"!=typeof global?global:\"undefined\"!=typeof self?self:{};function c(){if(void 0===this)throw new TypeError(\"Constructor WeakMap requires 'new'\");if(o(this,\"_id\",\"_WeakMap_\"+f()+\".\"+f()),0<arguments.length)throw new TypeError(\"WeakMap iterable is not supported\")}function s(e,t){if(!d(e)||!n.call(e,\"_id\"))throw new TypeError(t+\" method called on incompatible receiver \"+typeof e)}function f(){return Math.random().toString().substring(2)}function d(e){return Object(e)===e}(Player=\"undefined\"!=typeof self?self:\"undefined\"!=typeof window?window:a).WeakMap||(n=Object.prototype.hasOwnProperty,Player.WeakMap=((o=function(e,t,n){Object.defineProperty?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:n}):e[t]=n})(c.prototype,\"delete\",function(e){if(s(this,\"delete\"),!d(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)&&(delete e[this._id],!0)}),o(c.prototype,\"get\",function(e){if(s(this,\"get\"),d(e)){var t=e[this._id];return t&&t[0]===e?t[1]:void 0}}),o(c.prototype,\"has\",function(e){if(s(this,\"has\"),!d(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)}),o(c.prototype,\"set\",function(e,t){if(s(this,\"set\"),!d(e))throw new TypeError(\"Invalid value used as weak map key\");var n=e[this._id];return n&&n[0]===e?n[1]=t:o(e,this._id,[e,t]),this}),o(c,\"_polyfill\",!0),c));var h,m=(function(e){var t,n,r;r=function(){var t,n,r,o,i,e=Object.prototype.toString,a=\"undefined\"!=typeof setImmediate?function(e){return setImmediate(e)}:setTimeout;try{Object.defineProperty({},\"x\",{}),t=function(e,t,n,r){return Object.defineProperty(e,t,{value:n,writable:!0,configurable:!1!==r})}}catch(e){t=function(e,t,n){return e[t]=n,e}}function u(e,t){this.fn=e,this.self=t,this.next=void 0}function l(e,t){y.add(e,t),n=n||a(y.drain)}function c(e){var t,n=typeof e;return\"function\"==typeof(t=null!=e&&(\"object\"==n||\"function\"==n)?e.then:t)&&t}function s(){for(var e=0;e<this.chain.length;e++)!function(e,t,n){var r,o;try{!1===t?n.reject(e.msg):(r=!0===t?e.msg:t.call(void 0,e.msg))===n.promise?n.reject(TypeError(\"Promise-chain cycle\")):(o=c(r))?o.call(r,n.resolve,n.reject):n.resolve(r)}catch(e){n.reject(e)}}(this,1===this.state?this.chain[e].success:this.chain[e].failure,this.chain[e]);this.chain.length=0}function f(e){var n,r=this;if(!r.triggered){r.triggered=!0,r.def&&(r=r.def);try{(n=c(e))?l(function(){var t=new m(r);try{n.call(e,function(){f.apply(t,arguments)},function(){d.apply(t,arguments)})}catch(e){d.call(t,e)}}):(r.msg=e,r.state=1,0<r.chain.length&&l(s,r))}catch(e){d.call(new m(r),e)}}}function d(e){var t=this;t.triggered||(t.triggered=!0,(t=t.def?t.def:t).msg=e,t.state=2,0<t.chain.length&&l(s,t))}function h(e,n,r,o){for(var t=0;t<n.length;t++)!function(t){e.resolve(n[t]).then(function(e){r(t,e)},o)}(t)}function m(e){this.def=e,this.triggered=!1}function v(e){this.promise=e,this.state=0,this.triggered=!1,this.chain=[],this.msg=void 0}function p(e){if(\"function\"!=typeof e)throw TypeError(\"Not a function\");if(0!==this.__NPO__)throw TypeError(\"Not a promise\");this.__NPO__=1;var r=new v(this);this.then=function(e,t){var n={success:\"function\"!=typeof e||e,failure:\"function\"==typeof t&&t};return n.promise=new this.constructor(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");n.resolve=e,n.reject=t}),r.chain.push(n),0!==r.state&&l(s,r),n.promise},this.catch=function(e){return this.then(void 0,e)};try{e.call(void 0,function(e){f.call(r,e)},function(e){d.call(r,e)})}catch(e){d.call(r,e)}}var y={add:function(e,t){i=new u(e,t),o?o.next=i:r=i,o=i,i=void 0},drain:function(){var e=r;for(r=o=n=void 0;e;)e.fn.call(e.self),e=e.next}},g=t({},\"constructor\",p,!1);return t(p.prototype=g,\"__NPO__\",0,!1),t(p,\"resolve\",function(n){return n&&\"object\"==typeof n&&1===n.__NPO__?n:new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");e(n)})}),t(p,\"reject\",function(n){return new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");t(n)})}),t(p,\"all\",function(t){var a=this;return\"[object Array]\"!=e.call(t)?a.reject(TypeError(\"Not an array\")):0===t.length?a.resolve([]):new a(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");var r=t.length,o=Array(r),i=0;h(a,t,function(e,t){o[e]=t,++i===r&&n(o)},e)})}),t(p,\"race\",function(t){var r=this;return\"[object Array]\"!=e.call(t)?r.reject(TypeError(\"Not an array\")):new r(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");h(r,t,function(e,t){n(t)},e)})}),p},(n=a)[t=\"Promise\"]=n[t]||r(),e.exports&&(e.exports=n[t])}(h={exports:{}}),h.exports),v=new WeakMap;function p(e,t,n){var r=v.get(e.element)||{};t in r||(r[t]=[]),r[t].push(n),v.set(e.element,r)}function y(e,t){return(v.get(e.element)||{})[t]||[]}function g(e,t,n){var r=v.get(e.element)||{};if(!r[t])return!0;if(!n)return r[t]=[],v.set(e.element,r),!0;n=r[t].indexOf(n);return-1!==n&&r[t].splice(n,1),v.set(e.element,r),r[t]&&0===r[t].length}var w=[\"autopause\",\"autoplay\",\"background\",\"byline\",\"color\",\"controls\",\"dnt\",\"height\",\"id\",\"interactive_params\",\"keyboard\",\"loop\",\"maxheight\",\"maxwidth\",\"muted\",\"playsinline\",\"portrait\",\"responsive\",\"speed\",\"texttrack\",\"title\",\"transparent\",\"url\",\"width\"];function b(r,e){return w.reduce(function(e,t){var n=r.getAttribute(\"data-vimeo-\".concat(t));return!n&&\"\"!==n||(e[t]=\"\"===n?1:n),e},1<arguments.length&&void 0!==e?e:{})}function k(e,t){var n=e.html;if(!t)throw new TypeError(\"An element must be provided\");if(null!==t.getAttribute(\"data-vimeo-initialized\"))return t.querySelector(\"iframe\");e=document.createElement(\"div\");return e.innerHTML=n,t.appendChild(e.firstChild),t.setAttribute(\"data-vimeo-initialized\",\"true\"),t.querySelector(\"iframe\")}function E(i,e,t){var a=1<arguments.length&&void 0!==e?e:{},u=2<arguments.length?t:void 0;return new Promise(function(t,n){if(!l(i))throw new TypeError(\"\u201c\".concat(i,\"\u201d is not a vimeo.com url.\"));var e,r=\"https://vimeo.com/api/oembed.json?url=\".concat(encodeURIComponent(i));for(e in a)a.hasOwnProperty(e)&&(r+=\"&\".concat(e,\"=\").concat(encodeURIComponent(a[e])));var o=new(\"XDomainRequest\"in window?XDomainRequest:XMLHttpRequest);o.open(\"GET\",r,!0),o.onload=function(){if(404!==o.status)if(403!==o.status)try{var e=JSON.parse(o.responseText);if(403===e.domain_status_code)return k(e,u),void n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));t(e)}catch(e){n(e)}else n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));else n(new Error(\"\u201c\".concat(i,\"\u201d was not found.\")))},o.onerror=function(){var e=o.status?\" (\".concat(o.status,\")\"):\"\";n(new Error(\"There was an error fetching the embed code from Vimeo\".concat(e,\".\")))},o.send()})}function T(e){function n(e){\"console\"in window&&console.error&&console.error(\"There was an error creating an embed: \".concat(e))}e=0<arguments.length&&void 0!==e?e:document,e=[].slice.call(e.querySelectorAll(\"[data-vimeo-id], [data-vimeo-url]\"));e.forEach(function(t){try{if(null!==t.getAttribute(\"data-vimeo-defer\"))return;var e=b(t);E(u(e),e,t).then(function(e){return k(e,t)}).catch(n)}catch(e){n(e)}})}function P(e){if(\"string\"==typeof e)try{e=JSON.parse(e)}catch(e){return console.warn(e),{}}return e}function _(e,t,n){e.element.contentWindow&&e.element.contentWindow.postMessage&&(t={method:t},void 0!==n&&(t.value=n),8<=(n=parseFloat(navigator.userAgent.toLowerCase().replace(/^.*msie (\\d+).*$/,\"$1\")))&&n<10&&(t=JSON.stringify(t)),e.element.contentWindow.postMessage(t,e.origin))}function M(n,r){var t,e,o,i,a=[];(r=P(r)).event?(\"error\"===r.event&&y(n,r.data.method).forEach(function(e){var t=new Error(r.data.message);t.name=r.data.name,e.reject(t),g(n,r.data.method,e)}),a=y(n,\"event:\".concat(r.event)),t=r.data):r.method&&(e=n,o=r.method,(i=!((i=y(e,o)).length<1)&&(i=i.shift(),g(e,o,i),i))&&(a.push(i),t=r.value)),a.forEach(function(e){try{if(\"function\"==typeof e)return void e.call(n,t);e.resolve(t)}catch(e){}})}var N,F,x,C=new WeakMap,j=new WeakMap,A={},Player=function(){function Player(i){var e,a=this,t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(!function(e,t){if(!(e instanceof t))throw new TypeError(\"Cannot call a class as a function\")}(this,Player),window.jQuery&&i instanceof jQuery&&(1<i.length&&window.console&&console.warn&&console.warn(\"A jQuery object with multiple elements was passed, using the first element.\"),i=i[0]),\"undefined\"!=typeof document&&\"string\"==typeof i&&(i=document.getElementById(i)),e=i,!Boolean(e&&1===e.nodeType&&\"nodeName\"in e&&e.ownerDocument&&e.ownerDocument.defaultView))throw new TypeError(\"You must pass either a valid element or a valid id.\");if(\"IFRAME\"===i.nodeName||(r=i.querySelector(\"iframe\"))&&(i=r),\"IFRAME\"===i.nodeName&&!l(i.getAttribute(\"src\")||\"\"))throw new Error(\"The player element passed isn\u2019t a Vimeo embed.\");if(C.has(i))return C.get(i);this._window=i.ownerDocument.defaultView,this.element=i,this.origin=\"*\";var n,r=new m(function(r,o){var e;a._onMessage=function(e){if(l(e.origin)&&a.element.contentWindow===e.source){\"*\"===a.origin&&(a.origin=e.origin);var t=P(e.data);if(t&&\"error\"===t.event&&t.data&&\"ready\"===t.data.method){var n=new Error(t.data.message);return n.name=t.data.name,void o(n)}e=t&&\"ready\"===t.event,n=t&&\"ping\"===t.method;if(e||n)return a.element.setAttribute(\"data-ready\",\"true\"),void r();M(a,t)}},a._window.addEventListener(\"message\",a._onMessage),\"IFRAME\"!==a.element.nodeName&&E(u(e=b(i,t)),e,i).then(function(e){var t,n,r=k(e,i);return a.element=r,a._originalElement=i,t=i,n=r,r=v.get(t),v.set(n,r),v.delete(t),C.set(a.element,a),e}).catch(o)});return j.set(this,r),C.set(this.element,this),\"IFRAME\"===this.element.nodeName&&_(this,\"ping\"),A.isEnabled&&(n=function(){return A.exit()},this.fullscreenchangeHandler=function(){(A.isFullscreen?p:g)(a,\"event:exitFullscreen\",n),a.ready().then(function(){_(a,\"fullscreenchange\",A.isFullscreen)})},A.on(\"fullscreenchange\",this.fullscreenchangeHandler)),this}var e,t,n;return e=Player,(t=[{key:\"callMethod\",value:function(n){var r=this,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};return new m(function(e,t){return r.ready().then(function(){p(r,n,{resolve:e,reject:t}),_(r,n,o)}).catch(t)})}},{key:\"get\",value:function(n){var r=this;return new m(function(e,t){return n=i(n,\"get\"),r.ready().then(function(){p(r,n,{resolve:e,reject:t}),_(r,n)}).catch(t)})}},{key:\"set\",value:function(n,r){var o=this;return new m(function(e,t){if(n=i(n,\"set\"),null==r)throw new TypeError(\"There must be a value to set.\");return o.ready().then(function(){p(o,n,{resolve:e,reject:t}),_(o,n,r)}).catch(t)})}},{key:\"on\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(!t)throw new TypeError(\"You must pass a callback function.\");if(\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");0===y(this,\"event:\".concat(e)).length&&this.callMethod(\"addEventListener\",e).catch(function(){}),p(this,\"event:\".concat(e),t)}},{key:\"off\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(t&&\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");g(this,\"event:\".concat(e),t)&&this.callMethod(\"removeEventListener\",e).catch(function(e){})}},{key:\"loadVideo\",value:function(e){return this.callMethod(\"loadVideo\",e)}},{key:\"ready\",value:function(){var e=j.get(this)||new m(function(e,t){t(new Error(\"Unknown player. Probably unloaded.\"))});return m.resolve(e)}},{key:\"addCuePoint\",value:function(e){return this.callMethod(\"addCuePoint\",{time:e,data:1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}})}},{key:\"removeCuePoint\",value:function(e){return this.callMethod(\"removeCuePoint\",e)}},{key:\"enableTextTrack\",value:function(e,t){if(!e)throw new TypeError(\"You must pass a language.\");return this.callMethod(\"enableTextTrack\",{language:e,kind:t})}},{key:\"disableTextTrack\",value:function(){return this.callMethod(\"disableTextTrack\")}},{key:\"pause\",value:function(){return this.callMethod(\"pause\")}},{key:\"play\",value:function(){return this.callMethod(\"play\")}},{key:\"requestFullscreen\",value:function(){return A.isEnabled?A.request(this.element):this.callMethod(\"requestFullscreen\")}},{key:\"exitFullscreen\",value:function(){return A.isEnabled?A.exit():this.callMethod(\"exitFullscreen\")}},{key:\"getFullscreen\",value:function(){return A.isEnabled?m.resolve(A.isFullscreen):this.get(\"fullscreen\")}},{key:\"requestPictureInPicture\",value:function(){return this.callMethod(\"requestPictureInPicture\")}},{key:\"exitPictureInPicture\",value:function(){return this.callMethod(\"exitPictureInPicture\")}},{key:\"getPictureInPicture\",value:function(){return this.get(\"pictureInPicture\")}},{key:\"unload\",value:function(){return this.callMethod(\"unload\")}},{key:\"destroy\",value:function(){var n=this;return new m(function(e){var t;j.delete(n),C.delete(n.element),n._originalElement&&(C.delete(n._originalElement),n._originalElement.removeAttribute(\"data-vimeo-initialized\")),n.element&&\"IFRAME\"===n.element.nodeName&&n.element.parentNode&&(n.element.parentNode.parentNode&&n._originalElement&&n._originalElement!==n.element.parentNode?n.element.parentNode.parentNode.removeChild(n.element.parentNode):n.element.parentNode.removeChild(n.element)),n.element&&\"DIV\"===n.element.nodeName&&n.element.parentNode&&(n.element.removeAttribute(\"data-vimeo-initialized\"),(t=n.element.querySelector(\"iframe\"))&&t.parentNode&&(t.parentNode.parentNode&&n._originalElement&&n._originalElement!==t.parentNode?t.parentNode.parentNode.removeChild(t.parentNode):t.parentNode.removeChild(t))),n._window.removeEventListener(\"message\",n._onMessage),A.isEnabled&&A.off(\"fullscreenchange\",n.fullscreenchangeHandler),e()})}},{key:\"getAutopause\",value:function(){return this.get(\"autopause\")}},{key:\"setAutopause\",value:function(e){return this.set(\"autopause\",e)}},{key:\"getBuffered\",value:function(){return this.get(\"buffered\")}},{key:\"getCameraProps\",value:function(){return this.get(\"cameraProps\")}},{key:\"setCameraProps\",value:function(e){return this.set(\"cameraProps\",e)}},{key:\"getChapters\",value:function(){return this.get(\"chapters\")}},{key:\"getCurrentChapter\",value:function(){return this.get(\"currentChapter\")}},{key:\"getColor\",value:function(){return this.get(\"color\")}},{key:\"setColor\",value:function(e){return this.set(\"color\",e)}},{key:\"getCuePoints\",value:function(){return this.get(\"cuePoints\")}},{key:\"getCurrentTime\",value:function(){return this.get(\"currentTime\")}},{key:\"setCurrentTime\",value:function(e){return this.set(\"currentTime\",e)}},{key:\"getDuration\",value:function(){return this.get(\"duration\")}},{key:\"getEnded\",value:function(){return this.get(\"ended\")}},{key:\"getLoop\",value:function(){return this.get(\"loop\")}},{key:\"setLoop\",value:function(e){return this.set(\"loop\",e)}},{key:\"setMuted\",value:function(e){return this.set(\"muted\",e)}},{key:\"getMuted\",value:function(){return this.get(\"muted\")}},{key:\"getPaused\",value:function(){return this.get(\"paused\")}},{key:\"getPlaybackRate\",value:function(){return this.get(\"playbackRate\")}},{key:\"setPlaybackRate\",value:function(e){return this.set(\"playbackRate\",e)}},{key:\"getPlayed\",value:function(){return this.get(\"played\")}},{key:\"getQualities\",value:function(){return this.get(\"qualities\")}},{key:\"getQuality\",value:function(){return this.get(\"quality\")}},{key:\"setQuality\",value:function(e){return this.set(\"quality\",e)}},{key:\"getSeekable\",value:function(){return this.get(\"seekable\")}},{key:\"getSeeking\",value:function(){return this.get(\"seeking\")}},{key:\"getTextTracks\",value:function(){return this.get(\"textTracks\")}},{key:\"getVideoEmbedCode\",value:function(){return this.get(\"videoEmbedCode\")}},{key:\"getVideoId\",value:function(){return this.get(\"videoId\")}},{key:\"getVideoTitle\",value:function(){return this.get(\"videoTitle\")}},{key:\"getVideoWidth\",value:function(){return this.get(\"videoWidth\")}},{key:\"getVideoHeight\",value:function(){return this.get(\"videoHeight\")}},{key:\"getVideoUrl\",value:function(){return this.get(\"videoUrl\")}},{key:\"getVolume\",value:function(){return this.get(\"volume\")}},{key:\"setVolume\",value:function(e){return this.set(\"volume\",e)}}])&&r(e.prototype,t),n&&r(e,n),Player}();return e||(N=function(){for(var e,t=[[\"requestFullscreen\",\"exitFullscreen\",\"fullscreenElement\",\"fullscreenEnabled\",\"fullscreenchange\",\"fullscreenerror\"],[\"webkitRequestFullscreen\",\"webkitExitFullscreen\",\"webkitFullscreenElement\",\"webkitFullscreenEnabled\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"webkitRequestFullScreen\",\"webkitCancelFullScreen\",\"webkitCurrentFullScreenElement\",\"webkitCancelFullScreen\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"mozRequestFullScreen\",\"mozCancelFullScreen\",\"mozFullScreenElement\",\"mozFullScreenEnabled\",\"mozfullscreenchange\",\"mozfullscreenerror\"],[\"msRequestFullscreen\",\"msExitFullscreen\",\"msFullscreenElement\",\"msFullscreenEnabled\",\"MSFullscreenChange\",\"MSFullscreenError\"]],n=0,r=t.length,o={};n<r;n++)if((e=t[n])&&e[1]in document){for(n=0;n<e.length;n++)o[t[0][n]]=e[n];return o}return!1}(),F={fullscreenchange:N.fullscreenchange,fullscreenerror:N.fullscreenerror},x={request:function(o){return new Promise(function(e,t){function n(){x.off(\"fullscreenchange\",n),e()}x.on(\"fullscreenchange\",n);var r=(o=o||document.documentElement)[N.requestFullscreen]();r instanceof Promise&&r.then(n).catch(t)})},exit:function(){return new Promise(function(t,e){var n,r;x.isFullscreen?(n=function e(){x.off(\"fullscreenchange\",e),t()},x.on(\"fullscreenchange\",n),(r=document[N.exitFullscreen]())instanceof Promise&&r.then(n).catch(e)):t()})},on:function(e,t){e=F[e];e&&document.addEventListener(e,t)},off:function(e,t){e=F[e];e&&document.removeEventListener(e,t)}},Object.defineProperties(x,{isFullscreen:{get:function(){return Boolean(document[N.fullscreenElement])}},element:{enumerable:!0,get:function(){return document[N.fullscreenElement]}},isEnabled:{enumerable:!0,get:function(){return Boolean(document[N.fullscreenEnabled])}}}),A=x,T(),function(e){var r=0<arguments.length&&void 0!==e?e:document;window.VimeoPlayerResizeEmbeds_||(window.VimeoPlayerResizeEmbeds_=!0,window.addEventListener(\"message\",function(e){if(l(e.origin)&&e.data&&\"spacechange\"===e.data.event)for(var t=r.querySelectorAll(\"iframe\"),n=0;n<t.length;n++)if(t[n].contentWindow===e.source){t[n].parentElement.style.paddingBottom=\"\".concat(e.data.data[0].bottom,\"px\");break}}))}()),Player});\n","vimeo/vimeo-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'vimeo'\n], function (Player) {\n    'use strict';\n\n    window.Vimeo = window.Vimeo || {\n        'Player': Player\n    };\n});\n","knockoutjs/knockout-repeat.js":"// REPEAT binding for Knockout http://knockoutjs.com/\n// (c) Michael Best\n// License: MIT (http://www.opensource.org/licenses/mit-license.php)\n// Version 2.1.0\n\n(function(factory) {\n    if (typeof define === 'function' && define.amd) {\n        // [1] AMD anonymous module\n        define(['knockout'], factory);\n    } else if (typeof exports === 'object') {\n        // [2] commonJS\n        factory(require('knockout'));\n    } else {\n        // [3] No module loader (plain <script> tag) - put directly in global namespace\n        factory(window.ko);\n    }\n})(function(ko) {\n\nif (!ko.virtualElements)\n    throw Error('Repeat requires at least Knockout 2.1');\n\nvar ko_bindingFlags = ko.bindingFlags || {};\nvar ko_unwrap = ko.utils.unwrapObservable;\n\nvar koProtoName = '__ko_proto__';\n\nif (ko.version >= \"3.0.0\") {\n    // In Knockout 3.0.0, use the node preprocessor to replace a node with a repeat binding with a virtual element\n    var provider = ko.bindingProvider.instance, previousPreprocessFn = provider.preprocessNode;\n    provider.preprocessNode = function(node) {\n        var newNodes, nodeBinding;\n        if (!previousPreprocessFn || !(newNodes = previousPreprocessFn.call(this, node))) {\n            if (node.nodeType === 1 && (nodeBinding = node.getAttribute('data-bind'))) {\n                if (/^\\s*repeat\\s*:/.test(nodeBinding)) {\n                    var leadingComment = node.ownerDocument.createComment('ko ' + nodeBinding),\n                        trailingComment = node.ownerDocument.createComment('/ko');\n                    node.parentNode.insertBefore(leadingComment, node);\n                    node.parentNode.insertBefore(trailingComment, node.nextSibling);\n                    node.removeAttribute('data-bind');\n                    newNodes = [leadingComment, node, trailingComment];\n                }\n            }\n        }\n        return newNodes;\n    };\n}\n\nko.virtualElements.allowedBindings.repeat = true;\nko.bindingHandlers.repeat = {\n    flags: ko_bindingFlags.contentBind | ko_bindingFlags.canUseVirtual,\n    init: function(element, valueAccessor, allBindingsAccessor, xxx, bindingContext) {\n\n        // Read and set fixed options--these options cannot be changed\n        var repeatParam = ko_unwrap(valueAccessor());\n        if (repeatParam && typeof repeatParam == 'object' && !('length' in repeatParam)) {\n            var repeatIndex = repeatParam.index,\n                repeatData = repeatParam.item,\n                repeatStep = repeatParam.step,\n                repeatReversed = repeatParam.reverse,\n                repeatBind = repeatParam.bind,\n                repeatInit = repeatParam.init,\n                repeatUpdate = repeatParam.update;\n        }\n        // Set default values for options that need it\n        repeatIndex = repeatIndex || '$index';\n        repeatData = repeatData || ko.bindingHandlers.repeat.itemName || '$item';\n        repeatStep = repeatStep || 1;\n        repeatReversed = repeatReversed || false;\n\n        var parent = element.parentNode, placeholder;\n        if (element.nodeType == 8) {    // virtual element\n            // Extract the \"children\" and find the single element node\n            var childNodes = ko.utils.arrayFilter(ko.virtualElements.childNodes(element), function(node) { return node.nodeType == 1;});\n            if (childNodes.length !== 1) {\n                throw Error(\"Repeat binding requires a single element to repeat\");\n            }\n            ko.virtualElements.emptyNode(element);\n\n            // The placeholder is the closing comment normally, or the opening comment if reversed\n            placeholder = repeatReversed ? element : element.nextSibling;\n            // The element to repeat is the contained element\n            element = childNodes[0];\n        } else {    // regular element\n            // First clean the element node and remove node's binding\n            var origBindString = element.getAttribute('data-bind');\n            ko.cleanNode(element);\n            element.removeAttribute('data-bind');\n\n            // Original element is no longer needed: delete it and create a placeholder comment\n            placeholder = element.ownerDocument.createComment('ko_repeatplaceholder ' + origBindString);\n            parent.replaceChild(placeholder, element);\n        }\n\n        // extract and remove a data-repeat-bind attribute, if present\n        if (!repeatBind) {\n            repeatBind = element.getAttribute('data-repeat-bind');\n            if (repeatBind) {\n                element.removeAttribute('data-repeat-bind');\n            }\n        }\n\n        // Make a copy of the element node to be copied for each repetition\n        var cleanNode = element.cloneNode(true);\n        if (typeof repeatBind == \"string\") {\n            cleanNode.setAttribute('data-bind', repeatBind);\n            repeatBind = null;\n        }\n\n        // Set up persistent data\n        var lastRepeatCount = 0,\n            notificationObservable = ko.observable(),\n            repeatArray, arrayObservable;\n\n        if (repeatInit) {\n            repeatInit(parent);\n        }\n\n        var subscribable = ko.computed(function() {\n            function makeArrayItemAccessor(index) {\n                var f = function(newValue) {\n                    var item = repeatArray[index];\n                    // Reading the value of the item\n                    if (!arguments.length) {\n                        notificationObservable();   // for dependency tracking\n                        return ko_unwrap(item);\n                    }\n                    // Writing a value to the item\n                    if (ko.isObservable(item)) {\n                        item(newValue);\n                    } else if (arrayObservable && arrayObservable.splice) {\n                        arrayObservable.splice(index, 1, newValue);\n                    } else {\n                        repeatArray[index] = newValue;\n                    }\n                    return this;\n                };\n                // Pretend that our accessor function is an observable\n                f[koProtoName] = ko.observable;\n                return f;\n            }\n\n            function makeBinding(item, index, context) {\n                return repeatArray\n                    ? function() { return repeatBind.call(bindingContext.$data, item, index, context); }\n                    : function() { return repeatBind.call(bindingContext.$data, index, context); }\n            }\n\n            // Read and set up variable options--these options can change and will update the binding\n            var paramObservable = valueAccessor(), repeatParam = ko_unwrap(paramObservable), repeatCount = 0;\n            if (repeatParam && typeof repeatParam == 'object') {\n                if ('length' in repeatParam) {\n                    repeatArray = repeatParam;\n                    repeatCount = repeatArray.length;\n                } else {\n                    if ('foreach' in repeatParam) {\n                        repeatArray = ko_unwrap(paramObservable = repeatParam.foreach);\n                        if (repeatArray && typeof repeatArray == 'object' && 'length' in repeatArray) {\n                            repeatCount = repeatArray.length || 0;\n                        } else {\n                            repeatCount = repeatArray || 0;\n                            repeatArray = null;\n                        }\n                    }\n                    // If a count value is provided (>0), always output that number of items\n                    if ('count' in repeatParam)\n                        repeatCount = ko_unwrap(repeatParam.count) || repeatCount;\n                    // If a limit is provided, don't output more than the limit\n                    if ('limit' in repeatParam)\n                        repeatCount = Math.min(repeatCount, ko_unwrap(repeatParam.limit)) || repeatCount;\n                }\n                arrayObservable = repeatArray && ko.isObservable(paramObservable) ? paramObservable : null;\n            } else {\n                repeatCount = repeatParam || 0;\n            }\n\n            // Remove nodes from end if array is shorter\n            for (; lastRepeatCount > repeatCount; lastRepeatCount-=repeatStep) {\n                ko.removeNode(repeatReversed ? placeholder.nextSibling : placeholder.previousSibling);\n            }\n\n            // Notify existing nodes of change\n            notificationObservable.notifySubscribers();\n\n            // Add nodes to end if array is longer (also initially populates nodes)\n            for (; lastRepeatCount < repeatCount; lastRepeatCount+=repeatStep) {\n                // Clone node and add to document\n                var newNode = cleanNode.cloneNode(true);\n                parent.insertBefore(newNode, repeatReversed ? placeholder.nextSibling : placeholder);\n                newNode.setAttribute('data-repeat-index', lastRepeatCount);\n\n                // Apply bindings to inserted node\n                if (repeatArray && repeatData == '$data') {\n                    var newContext = bindingContext.createChildContext(makeArrayItemAccessor(lastRepeatCount));\n                } else {\n                    var newContext = bindingContext.extend();\n                    if (repeatArray)\n                        newContext[repeatData] = makeArrayItemAccessor(lastRepeatCount);\n                }\n                newContext[repeatIndex] = lastRepeatCount;\n                if (repeatBind) {\n                    var result = ko.applyBindingsToNode(newNode, makeBinding(newContext[repeatData], lastRepeatCount, newContext), newContext, true),\n                        shouldBindDescendants = result && result.shouldBindDescendants;\n                }\n                if (!repeatBind || (result && shouldBindDescendants !== false)) {\n                    ko.applyBindings(newContext, newNode);\n                }\n            }\n            if (repeatUpdate) {\n                repeatUpdate(parent);\n            }\n        }, null, {disposeWhenNodeIsRemoved: placeholder});\n\n        return { controlsDescendantBindings: true, subscribable: subscribable };\n    }\n};\n});","knockoutjs/knockout-es5.js":"/*!\n * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5\n * Copyright (c) Steve Sanderson\n * MIT license\n */\n\n(function(global, undefined) {\n  'use strict';\n\n  var ko;\n\n  // Model tracking\n  // --------------\n  //\n  // This is the central feature of Knockout-ES5. We augment model objects by converting properties\n  // into ES5 getter/setter pairs that read/write an underlying Knockout observable. This means you can\n  // use plain JavaScript syntax to read/write the property while still getting the full benefits of\n  // Knockout's automatic dependency detection and notification triggering.\n  //\n  // For comparison, here's Knockout ES3-compatible syntax:\n  //\n  //     var firstNameLength = myModel.user().firstName().length; // Read\n  //     myModel.user().firstName('Bert'); // Write\n  //\n  // ... versus Knockout-ES5 syntax:\n  //\n  //     var firstNameLength = myModel.user.firstName.length; // Read\n  //     myModel.user.firstName = 'Bert'; // Write\n\n  // `ko.track(model)` converts each property on the given model object into a getter/setter pair that\n  // wraps a Knockout observable. Optionally specify an array of property names to wrap; otherwise we\n  // wrap all properties. If any of the properties are already observables, we replace them with\n  // ES5 getter/setter pairs that wrap your original observable instances. In the case of readonly\n  // ko.computed properties, we simply do not define a setter (so attempted writes will be ignored,\n  // which is how ES5 readonly properties normally behave).\n  //\n  // By design, this does *not* recursively walk child object properties, because making literally\n  // everything everywhere independently observable is usually unhelpful. When you do want to track\n  // child object properties independently, define your own class for those child objects and put\n  // a separate ko.track call into its constructor --- this gives you far more control.\n  /**\n   * @param {object} obj\n   * @param {object|array.<string>} propertyNamesOrSettings\n   * @param {boolean} propertyNamesOrSettings.deep Use deep track.\n   * @param {array.<string>} propertyNamesOrSettings.fields Array of property names to wrap.\n   * todo: @param {array.<string>} propertyNamesOrSettings.exclude Array of exclude property names to wrap.\n   * todo: @param {function(string, *):boolean} propertyNamesOrSettings.filter Function to filter property \n   *   names to wrap. A function that takes ... params\n   * @return {object}\n   */\n  function track(obj, propertyNamesOrSettings) {\n    if (!obj || typeof obj !== 'object') {\n      throw new Error('When calling ko.track, you must pass an object as the first parameter.');\n    }\n\n    var propertyNames;\n\n    if ( isPlainObject(propertyNamesOrSettings) ) {\n      // defaults\n      propertyNamesOrSettings.deep = propertyNamesOrSettings.deep || false;\n      propertyNamesOrSettings.fields = propertyNamesOrSettings.fields || Object.getOwnPropertyNames(obj);\n      propertyNamesOrSettings.lazy = propertyNamesOrSettings.lazy || false;\n\n      wrap(obj, propertyNamesOrSettings.fields, propertyNamesOrSettings);\n    } else {\n      propertyNames = propertyNamesOrSettings || Object.getOwnPropertyNames(obj);\n      wrap(obj, propertyNames, {});\n    }\n\n    return obj;\n  }\n\n  // fix for ie\n  var rFunctionName = /^function\\s*([^\\s(]+)/;\n  function getFunctionName( ctor ){\n    if (ctor.name) {\n      return ctor.name;\n    }\n    return (ctor.toString().trim().match( rFunctionName ) || [])[1];\n  }\n\n  function canTrack(obj) {\n    return obj && typeof obj === 'object' && getFunctionName(obj.constructor) === 'Object';\n  }\n\n  function createPropertyDescriptor(originalValue, prop, map) {\n    var isObservable = ko.isObservable(originalValue);\n    var isArray = !isObservable && Array.isArray(originalValue);\n    var observable = isObservable ? originalValue\n        : isArray ? ko.observableArray(originalValue)\n        : ko.observable(originalValue);\n\n    map[prop] = function () { return observable; };\n\n    // add check in case the object is already an observable array\n    if (isArray || (isObservable && 'push' in observable)) {\n      notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n    }\n\n    return {\n      configurable: true,\n      enumerable: true,\n      get: observable,\n      set: ko.isWriteableObservable(observable) ? observable : undefined\n    };\n  }\n\n  function createLazyPropertyDescriptor(originalValue, prop, map) {\n    if (ko.isObservable(originalValue)) {\n      // no need to be lazy if we already have an observable\n      return createPropertyDescriptor(originalValue, prop, map);\n    }\n\n    var observable;\n\n    function getOrCreateObservable(value, writing) {\n      if (observable) {\n        return writing ? observable(value) : observable;\n      }\n\n      if (Array.isArray(value)) {\n        observable = ko.observableArray(value);\n        notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n        return observable;\n      }\n\n      return (observable = ko.observable(value));\n    }\n\n    map[prop] = function () { return getOrCreateObservable(originalValue); };\n    return {\n      configurable: true,\n      enumerable: true,\n      get: function () { return getOrCreateObservable(originalValue)(); },\n      set: function (value) { getOrCreateObservable(value, true); }\n    };\n  }\n\n  function wrap(obj, props, options) {\n    if (!props.length) {\n      return;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, true);\n    var descriptors = {};\n\n    props.forEach(function (prop) {\n      // Skip properties that are already tracked\n      if (prop in allObservablesForObject) {\n        return;\n      }\n\n      // Skip properties where descriptor can't be redefined\n      if (Object.getOwnPropertyDescriptor(obj, prop).configurable === false){\n        return;\n      }\n\n      var originalValue = obj[prop];\n      descriptors[prop] = (options.lazy ? createLazyPropertyDescriptor : createPropertyDescriptor)\n        (originalValue, prop, allObservablesForObject);\n\n      if (options.deep && canTrack(originalValue)) {\n        wrap(originalValue, Object.keys(originalValue), options);\n      }\n    });\n\n    Object.defineProperties(obj, descriptors);\n  }\n\n  function isPlainObject( obj ){\n    return !!obj && typeof obj === 'object' && obj.constructor === Object;\n  }\n\n  // Lazily created by `getAllObservablesForObject` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var objectToObservableMap;\n\n  // Gets or creates the hidden internal key-value collection of observables corresponding to\n  // properties on the model object.\n  function getAllObservablesForObject(obj, createIfNotDefined) {\n    if (!objectToObservableMap) {\n      objectToObservableMap = weakMapFactory();\n    }\n\n    var result = objectToObservableMap.get(obj);\n    if (!result && createIfNotDefined) {\n      result = {};\n      objectToObservableMap.set(obj, result);\n    }\n    return result;\n  }\n\n  // Removes the internal references to observables mapped to the specified properties\n  // or the entire object reference if no properties are passed in. This allows the\n  // observables to be replaced and tracked again.\n  function untrack(obj, propertyNames) {\n    if (!objectToObservableMap) {\n      return;\n    }\n\n    if (arguments.length === 1) {\n      objectToObservableMap['delete'](obj);\n    } else {\n      var allObservablesForObject = getAllObservablesForObject(obj, false);\n      if (allObservablesForObject) {\n        propertyNames.forEach(function(propertyName) {\n          delete allObservablesForObject[propertyName];\n        });\n      }\n    }\n  }\n\n  // Computed properties\n  // -------------------\n  //\n  // The preceding code is already sufficient to upgrade ko.computed model properties to ES5\n  // getter/setter pairs (or in the case of readonly ko.computed properties, just a getter).\n  // These then behave like a regular property with a getter function, except they are smarter:\n  // your evaluator is only invoked when one of its dependencies changes. The result is cached\n  // and used for all evaluations until the next time a dependency changes).\n  //\n  // However, instead of forcing developers to declare a ko.computed property explicitly, it's\n  // nice to offer a utility function that declares a computed getter directly.\n\n  // Implements `ko.defineProperty`\n  function defineComputedProperty(obj, propertyName, evaluatorOrOptions) {\n    var ko = this,\n      computedOptions = { owner: obj, deferEvaluation: true };\n\n    if (typeof evaluatorOrOptions === 'function') {\n      computedOptions.read = evaluatorOrOptions;\n    } else {\n      if ('value' in evaluatorOrOptions) {\n        throw new Error('For ko.defineProperty, you must not specify a \"value\" for the property. ' +\n                        'You must provide a \"get\" function.');\n      }\n\n      if (typeof evaluatorOrOptions.get !== 'function') {\n        throw new Error('For ko.defineProperty, the third parameter must be either an evaluator function, ' +\n                        'or an options object containing a function called \"get\".');\n      }\n\n      computedOptions.read = evaluatorOrOptions.get;\n      computedOptions.write = evaluatorOrOptions.set;\n    }\n\n    obj[propertyName] = ko.computed(computedOptions);\n    track.call(ko, obj, [propertyName]);\n    return obj;\n  }\n\n  // Array handling\n  // --------------\n  //\n  // Arrays are special, because unlike other property types, they have standard mutator functions\n  // (`push`/`pop`/`splice`/etc.) and it's desirable to trigger a change notification whenever one of\n  // those mutator functions is invoked.\n  //\n  // Traditionally, Knockout handles this by putting special versions of `push`/`pop`/etc. on observable\n  // arrays that mutate the underlying array and then trigger a notification. That approach doesn't\n  // work for Knockout-ES5 because properties now return the underlying arrays, so the mutator runs\n  // in the context of the underlying array, not any particular observable:\n  //\n  //     // Operates on the underlying array value\n  //     myModel.someCollection.push('New value');\n  //\n  // To solve this, Knockout-ES5 detects array values, and modifies them as follows:\n  //  1. Associates a hidden subscribable with each array instance that it encounters\n  //  2. Intercepts standard mutators (`push`/`pop`/etc.) and makes them trigger the subscribable\n  // Then, for model properties whose values are arrays, the property's underlying observable\n  // subscribes to the array subscribable, so it can trigger a change notification after mutation.\n\n  // Given an observable that underlies a model property, watch for any array value that might\n  // be assigned as the property value, and hook into its change events\n  function notifyWhenPresentOrFutureArrayValuesMutate(ko, observable) {\n    var watchingArraySubscription = null;\n    ko.computed(function () {\n      // Unsubscribe to any earlier array instance\n      if (watchingArraySubscription) {\n        watchingArraySubscription.dispose();\n        watchingArraySubscription = null;\n      }\n\n      // Subscribe to the new array instance\n      var newArrayInstance = observable();\n      if (newArrayInstance instanceof Array) {\n        watchingArraySubscription = startWatchingArrayInstance(ko, observable, newArrayInstance);\n      }\n    });\n  }\n\n  // Listens for array mutations, and when they happen, cause the observable to fire notifications.\n  // This is used to make model properties of type array fire notifications when the array changes.\n  // Returns a subscribable that can later be disposed.\n  function startWatchingArrayInstance(ko, observable, arrayInstance) {\n    var subscribable = getSubscribableForArray(ko, arrayInstance);\n    return subscribable.subscribe(observable);\n  }\n\n  // Lazily created by `getSubscribableForArray` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var arraySubscribablesMap;\n\n  // Gets or creates a subscribable that fires after each array mutation\n  function getSubscribableForArray(ko, arrayInstance) {\n    if (!arraySubscribablesMap) {\n      arraySubscribablesMap = weakMapFactory();\n    }\n\n    var subscribable = arraySubscribablesMap.get(arrayInstance);\n    if (!subscribable) {\n      subscribable = new ko.subscribable();\n      arraySubscribablesMap.set(arrayInstance, subscribable);\n\n      var notificationPauseSignal = {};\n      wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal);\n      addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal);\n    }\n\n    return subscribable;\n  }\n\n  // After each array mutation, fires a notification on the given subscribable\n  function wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal) {\n    ['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'].forEach(function(fnName) {\n      var origMutator = arrayInstance[fnName];\n      arrayInstance[fnName] = function() {\n        var result = origMutator.apply(this, arguments);\n        if (notificationPauseSignal.pause !== true) {\n          subscribable.notifySubscribers(this);\n        }\n        return result;\n      };\n    });\n  }\n\n  // Adds Knockout's additional array mutation functions to the array\n  function addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal) {\n    ['remove', 'removeAll', 'destroy', 'destroyAll', 'replace'].forEach(function(fnName) {\n      // Make it a non-enumerable property for consistency with standard Array functions\n      Object.defineProperty(arrayInstance, fnName, {\n        enumerable: false,\n        value: function() {\n          var result;\n\n          // These additional array mutators are built using the underlying push/pop/etc.\n          // mutators, which are wrapped to trigger notifications. But we don't want to\n          // trigger multiple notifications, so pause the push/pop/etc. wrappers and\n          // delivery only one notification at the end of the process.\n          notificationPauseSignal.pause = true;\n          try {\n            // Creates a temporary observableArray that can perform the operation.\n            result = ko.observableArray.fn[fnName].apply(ko.observableArray(arrayInstance), arguments);\n          }\n          finally {\n            notificationPauseSignal.pause = false;\n          }\n          subscribable.notifySubscribers(arrayInstance);\n          return result;\n        }\n      });\n    });\n  }\n\n  // Static utility functions\n  // ------------------------\n  //\n  // Since Knockout-ES5 sets up properties that return values, not observables, you can't\n  // trivially subscribe to the underlying observables (e.g., `someProperty.subscribe(...)`),\n  // or tell them that object values have mutated, etc. To handle this, we set up some\n  // extra utility functions that can return or work with the underlying observables.\n\n  // Returns the underlying observable associated with a model property (or `null` if the\n  // model or property doesn't exist, or isn't associated with an observable). This means\n  // you can subscribe to the property, e.g.:\n  //\n  //     ko.getObservable(model, 'propertyName')\n  //       .subscribe(function(newValue) { ... });\n  function getObservable(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return null;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    if (allObservablesForObject && propertyName in allObservablesForObject) {\n      return allObservablesForObject[propertyName]();\n    }\n\n    return null;\n  }\n  \n  // Returns a boolean indicating whether the property on the object has an underlying\n  // observables. This does the check in a way not to create an observable if the\n  // object was created with lazily created observables\n  function isTracked(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return false;\n    }\n    \n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    return !!allObservablesForObject && propertyName in allObservablesForObject;\n  }\n\n  // Causes a property's associated observable to fire a change notification. Useful when\n  // the property value is a complex object and you've modified a child property.\n  function valueHasMutated(obj, propertyName) {\n    var observable = getObservable(obj, propertyName);\n\n    if (observable) {\n      observable.valueHasMutated();\n    }\n  }\n\n  // Module initialisation\n  // ---------------------\n  //\n  // When this script is first evaluated, it works out what kind of module loading scenario\n  // it is in (Node.js or a browser `<script>` tag), stashes a reference to its dependencies\n  // (currently that's just the WeakMap shim), and then finally attaches itself to whichever\n  // instance of Knockout.js it can find.\n\n  // A function that returns a new ES6-compatible WeakMap instance (using ES5 shim if needed).\n  // Instantiated by prepareExports, accounting for which module loader is being used.\n  var weakMapFactory;\n\n  // Extends a Knockout instance with Knockout-ES5 functionality\n  function attachToKo(ko) {\n    ko.track = track;\n    ko.untrack = untrack;\n    ko.getObservable = getObservable;\n    ko.valueHasMutated = valueHasMutated;\n    ko.defineProperty = defineComputedProperty;\n\n    // todo: test it, maybe added it to ko. directly\n    ko.es5 = {\n      getAllObservablesForObject: getAllObservablesForObject,\n      notifyWhenPresentOrFutureArrayValuesMutate: notifyWhenPresentOrFutureArrayValuesMutate,\n      isTracked: isTracked\n    };\n  }\n\n  // Determines which module loading scenario we're in, grabs dependencies, and attaches to KO\n  function prepareExports() {\n    if (typeof exports === 'object' && typeof module === 'object') {\n      // Node.js case - load KO and WeakMap modules synchronously\n      ko = require('knockout');\n      var WM = require('../lib/weakmap');\n      attachToKo(ko);\n      weakMapFactory = function() { return new WM(); };\n      module.exports = ko;\n    } else if (typeof define === 'function' && define.amd) {\n      define(['knockout'], function(koModule) {\n        ko = koModule;\n        attachToKo(koModule);\n        weakMapFactory = function() { return new global.WeakMap(); };\n        return koModule;\n      });\n    } else if ('ko' in global) {\n      // Non-module case - attach to the global instance, and assume a global WeakMap constructor\n      ko = global.ko;\n      attachToKo(global.ko);\n      weakMapFactory = function() { return new global.WeakMap(); };\n    }\n  }\n\n  prepareExports();\n\n})(this);","knockoutjs/knockout-fast-foreach.js":"/*!\n  Knockout Fast Foreach v0.4.1 (2015-07-17T14:06:15.974Z)\n  By: Brian M Hunt (C) 2015\n  License: MIT\n\n  Adds `fastForEach` to `ko.bindingHandlers`.\n*/\n(function (root, factory) {\n  if (typeof define === 'function' && define.amd) {\n    define(['knockout'], factory);\n  } else if (typeof exports === 'object') {\n    module.exports = factory(require('knockout'));\n  } else {\n    root.KnockoutFastForeach = factory(root.ko);\n  }\n}(this, function (ko) {\n  \"use strict\";\n// index.js\n// --------\n// Fast For Each\n//\n// Employing sound techniques to make a faster Knockout foreach binding.\n// --------\n\n//      Utilities\n\n// from https://github.com/jonschlinkert/is-plain-object\nfunction isPlainObject(o) {\n  return !!o && typeof o === 'object' && o.constructor === Object;\n}\n\n// From knockout/src/virtualElements.js\nvar commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\nvar startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\nvar supportsDocumentFragment = document && typeof document.createDocumentFragment === \"function\";\nfunction isVirtualNode(node) {\n  return (node.nodeType === 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n}\n\n\n// Get a copy of the (possibly virtual) child nodes of the given element,\n// put them into a container, then empty the given node.\nfunction makeTemplateNode(sourceNode) {\n  var container = document.createElement(\"div\");\n  var parentNode;\n  if (sourceNode.content) {\n    // For e.g. <template> tags\n    parentNode = sourceNode.content;\n  } else if (sourceNode.tagName === 'SCRIPT') {\n    parentNode = document.createElement(\"div\");\n    parentNode.innerHTML = sourceNode.text;\n  } else {\n    // Anything else e.g. <div>\n    parentNode = sourceNode;\n  }\n  ko.utils.arrayForEach(ko.virtualElements.childNodes(parentNode), function (child) {\n    // FIXME - This cloneNode could be expensive; we may prefer to iterate over the\n    // parentNode children in reverse (so as not to foul the indexes as childNodes are\n    // removed from parentNode when inserted into the container)\n    if (child) {\n      container.insertBefore(child.cloneNode(true), null);\n    }\n  });\n  return container;\n}\n\nfunction insertAllAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode) {\n  var frag, len, i;\n  // poor man's node and array check, should be enough for this\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\" && typeof nodeOrNodeArrayToInsert.length === \"undefined\") {\n    throw new Error(\"Expected a single node or a node array\");\n  }\n\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\") {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode);\n    return;\n  }\n\n  if (nodeOrNodeArrayToInsert.length === 1) {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert[0], insertAfterNode);\n    return;\n  }\n\n  if (supportsDocumentFragment) {\n    frag = document.createDocumentFragment();\n\n    for (i = 0, len = nodeOrNodeArrayToInsert.length; i !== len; ++i) {\n      frag.appendChild(nodeOrNodeArrayToInsert[i]);\n    }\n    ko.virtualElements.insertAfter(containerNode, frag, insertAfterNode);\n  } else {\n    // Nodes are inserted in reverse order - pushed down immediately after\n    // the last node for the previous item or as the first node of element.\n    for (i = nodeOrNodeArrayToInsert.length - 1; i >= 0; --i) {\n      var child = nodeOrNodeArrayToInsert[i];\n      if (!child) {\n        return;\n      }\n      ko.virtualElements.insertAfter(containerNode, child, insertAfterNode);\n    }\n  }\n}\n\n// Mimic a KO change item 'add'\nfunction valueToChangeAddItem(value, index) {\n  return {\n    status: 'added',\n    value: value,\n    index: index\n  };\n}\n\nfunction isAdditionAdjacentToLast(changeIndex, arrayChanges) {\n  return changeIndex > 0 &&\n    changeIndex < arrayChanges.length &&\n    arrayChanges[changeIndex].status === \"added\" &&\n    arrayChanges[changeIndex - 1].status === \"added\" &&\n    arrayChanges[changeIndex - 1].index === arrayChanges[changeIndex].index - 1;\n}\n\nfunction FastForEach(spec) {\n  this.element = spec.element;\n  this.container = isVirtualNode(this.element) ?\n                   this.element.parentNode : this.element;\n  this.$context = spec.$context;\n  this.data = spec.data;\n  this.as = spec.as;\n  this.noContext = spec.noContext;\n  this.templateNode = makeTemplateNode(\n    spec.name ? document.getElementById(spec.name).cloneNode(true) : spec.element\n  );\n  this.afterQueueFlush = spec.afterQueueFlush;\n  this.beforeQueueFlush = spec.beforeQueueFlush;\n  this.changeQueue = [];\n  this.lastNodesList = [];\n  this.indexesToDelete = [];\n  this.rendering_queued = false;\n\n  // Remove existing content.\n  ko.virtualElements.emptyNode(this.element);\n\n  // Prime content\n  var primeData = ko.unwrap(this.data);\n  if (primeData.map) {\n    this.onArrayChange(primeData.map(valueToChangeAddItem));\n  }\n\n  // Watch for changes\n  if (ko.isObservable(this.data)) {\n    if (!this.data.indexOf) {\n      // Make sure the observable is trackable.\n      this.data = this.data.extend({trackArrayChanges: true});\n    }\n    this.changeSubs = this.data.subscribe(this.onArrayChange, this, 'arrayChange');\n  }\n}\n\n\nFastForEach.animateFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame ||\n  window.mozRequestAnimationFrame || window.msRequestAnimationFrame ||\n  function(cb) { return window.setTimeout(cb, 1000 / 60); };\n\n\nFastForEach.prototype.dispose = function () {\n  if (this.changeSubs) {\n    this.changeSubs.dispose();\n  }\n};\n\n\n// If the array changes we register the change.\nFastForEach.prototype.onArrayChange = function (changeSet) {\n  var self = this;\n  var changeMap = {\n    added: [],\n    deleted: []\n  };\n  for (var i = 0, len = changeSet.length; i < len; i++) {\n    // the change is appended to a last change info object when both are 'added' and have indexes next to each other\n    // here I presume that ko is sending changes in monotonic order (in index variable) which happens to be true, tested with push and splice with multiple pushed values\n    if (isAdditionAdjacentToLast(i, changeSet)) {\n      var batchValues = changeMap.added[changeMap.added.length - 1].values;\n      if (!batchValues) {\n        // transform the last addition into a batch addition object\n        var lastAddition = changeMap.added.pop();\n        var batchAddition = {\n          isBatch: true,\n          status: 'added',\n          index: lastAddition.index,\n          values: [lastAddition.value]\n        };\n        batchValues = batchAddition.values;\n        changeMap.added.push(batchAddition);\n      }\n      batchValues.push(changeSet[i].value);\n    } else {\n      changeMap[changeSet[i].status].push(changeSet[i]);\n    }\n  }\n  if (changeMap.deleted.length > 0) {\n    this.changeQueue.push.apply(this.changeQueue, changeMap.deleted);\n    this.changeQueue.push({status: 'clearDeletedIndexes'});\n  }\n  this.changeQueue.push.apply(this.changeQueue, changeMap.added);\n  // Once a change is registered, the ticking count-down starts for the processQueue.\n  if (this.changeQueue.length > 0 && !this.rendering_queued) {\n    this.rendering_queued = true;\n    FastForEach.animateFrame.call(window, function () { self.processQueue(); });\n  }\n};\n\n\n// Reflect all the changes in the queue in the DOM, then wipe the queue.\nFastForEach.prototype.processQueue = function () {\n  var self = this;\n\n  // Callback so folks can do things before the queue flush.\n  if (typeof this.beforeQueueFlush === 'function') {\n    this.beforeQueueFlush(this.changeQueue);\n  }\n\n  ko.utils.arrayForEach(this.changeQueue, function (changeItem) {\n    // console.log(self.data(), \"CI\", JSON.stringify(changeItem, null, 2), JSON.stringify($(self.element).text()))\n    self[changeItem.status](changeItem);\n    // console.log(\"  ==> \", JSON.stringify($(self.element).text()))\n  });\n  this.rendering_queued = false;\n  // Callback so folks can do things.\n  if (typeof this.afterQueueFlush === 'function') {\n    this.afterQueueFlush(this.changeQueue);\n  }\n  this.changeQueue = [];\n};\n\n\n// Process a changeItem with {status: 'added', ...}\nFastForEach.prototype.added = function (changeItem) {\n  var index = changeItem.index;\n  var valuesToAdd = changeItem.isBatch ? changeItem.values : [changeItem.value];\n  var referenceElement = this.lastNodesList[index - 1] || null;\n  // gather all childnodes for a possible batch insertion\n  var allChildNodes = [];\n\n  for (var i = 0, len = valuesToAdd.length; i < len; ++i) {\n    var templateClone = this.templateNode.cloneNode(true);\n    var childContext;\n\n    if (this.noContext) {\n      childContext = this.$context.extend({\n        '$item': valuesToAdd[i]\n      });\n    } else {\n      childContext = this.$context.createChildContext(valuesToAdd[i], this.as || null);\n    }\n\n    // apply bindings first, and then process child nodes, because bindings can add childnodes\n    ko.applyBindingsToDescendants(childContext, templateClone);\n\n    var childNodes = ko.virtualElements.childNodes(templateClone);\n    // Note discussion at https://github.com/angular/angular.js/issues/7851\n    allChildNodes.push.apply(allChildNodes, Array.prototype.slice.call(childNodes));\n    this.lastNodesList.splice(index + i, 0, childNodes[childNodes.length - 1]);\n  }\n\n  insertAllAfter(this.element, allChildNodes, referenceElement);\n};\n\n\n// Process a changeItem with {status: 'deleted', ...}\nFastForEach.prototype.deleted = function (changeItem) {\n  var index = changeItem.index;\n  var ptr = this.lastNodesList[index],\n      // We use this.element because that will be the last previous node\n      // for virtual element lists.\n      lastNode = this.lastNodesList[index - 1] || this.element;\n  do {\n    ptr = ptr.previousSibling;\n    ko.removeNode((ptr && ptr.nextSibling) || ko.virtualElements.firstChild(this.element));\n  } while (ptr && ptr !== lastNode);\n  // The \"last node\" in the DOM from which we begin our delets of the next adjacent node is\n  // now the sibling that preceded the first node of this item.\n  this.lastNodesList[index] = this.lastNodesList[index - 1];\n  this.indexesToDelete.push(index);\n};\n\n\n// We batch our deletion of item indexes in our parallel array.\n// See brianmhunt/knockout-fast-foreach#6/#8\nFastForEach.prototype.clearDeletedIndexes = function () {\n  // We iterate in reverse on the presumption (following the unit tests) that KO's diff engine\n  // processes diffs (esp. deletes) monotonically ascending i.e. from index 0 -> N.\n  for (var i = this.indexesToDelete.length - 1; i >= 0; --i) {\n    this.lastNodesList.splice(this.indexesToDelete[i], 1);\n  }\n  this.indexesToDelete = [];\n};\n\n\nko.bindingHandlers.fastForEach = {\n  // Valid valueAccessors:\n  //    []\n  //    ko.observable([])\n  //    ko.observableArray([])\n  //    ko.computed\n  //    {data: array, name: string, as: string}\n  init: function init(element, valueAccessor, bindings, vm, context) {\n    var value = valueAccessor(),\n        ffe;\n    if (isPlainObject(value)) {\n      value.element = value.element || element;\n      value.$context = context;\n      ffe = new FastForEach(value);\n    } else {\n      ffe = new FastForEach({\n        element: element,\n        data: ko.unwrap(context.$rawData) === value ? context.$rawData : value,\n        $context: context\n      });\n    }\n    ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n      ffe.dispose();\n    });\n    return {controlsDescendantBindings: true};\n  },\n\n  // Export for testing, debugging, and overloading.\n  FastForEach: FastForEach\n};\n\nko.virtualElements.allowedBindings.fastForEach = true;\n}));","knockoutjs/knockout.js":"/*!\n * Knockout JavaScript library v3.5.1\n * (c) The Knockout.js team - http://knockoutjs.com/\n * License: MIT (http://www.opensource.org/licenses/mit-license.php)\n */\n\n(function(){\n    var DEBUG=true;\n    (function(undefined){\n        // (0, eval)('this') is a robust way of getting a reference to the global object\n        // For details, see http://stackoverflow.com/questions/14119988/return-this-0-evalthis/14120023#14120023\n        var window = this || (0, eval)('this'),\n            document = window['document'],\n            navigator = window['navigator'],\n            jQueryInstance = window[\"jQuery\"],\n            JSON = window[\"JSON\"];\n\n        if (!jQueryInstance && typeof jQuery !== \"undefined\") {\n            jQueryInstance = jQuery;\n        }\n        (function(factory) {\n            // Support three module loading scenarios\n            if (typeof define === 'function' && define['amd']) {\n                // [1] AMD anonymous module\n                define(['exports', 'require'], factory);\n            } else if (typeof exports === 'object' && typeof module === 'object') {\n                // [2] CommonJS/Node.js\n                factory(module['exports'] || exports);  // module.exports is for Node.js\n            } else {\n                // [3] No module loader (plain <script> tag) - put directly in global namespace\n                factory(window['ko'] = {});\n            }\n        }(function(koExports, amdRequire){\n// Internally, all KO objects are attached to koExports (even the non-exported ones whose names will be minified by the closure compiler).\n// In the future, the following \"ko\" variable may be made distinct from \"koExports\" so that private objects are not externally reachable.\n            var ko = typeof koExports !== 'undefined' ? koExports : {};\n// Google Closure Compiler helpers (used only to make the minified file smaller)\n            ko.exportSymbol = function(koPath, object) {\n                var tokens = koPath.split(\".\");\n\n                // In the future, \"ko\" may become distinct from \"koExports\" (so that non-exported objects are not reachable)\n                // At that point, \"target\" would be set to: (typeof koExports !== \"undefined\" ? koExports : ko)\n                var target = ko;\n\n                for (var i = 0; i < tokens.length - 1; i++)\n                    target = target[tokens[i]];\n                target[tokens[tokens.length - 1]] = object;\n            };\n            ko.exportProperty = function(owner, publicName, object) {\n                owner[publicName] = object;\n            };\n            ko.version = \"3.5.1\";\n\n            ko.exportSymbol('version', ko.version);\n// For any options that may affect various areas of Knockout and aren't directly associated with data binding.\n            ko.options = {\n                'deferUpdates': false,\n                'useOnlyNativeEvents': false,\n                'foreachHidesDestroyed': false\n            };\n\n//ko.exportSymbol('options', ko.options);   // 'options' isn't minified\n            ko.utils = (function () {\n                var hasOwnProperty = Object.prototype.hasOwnProperty;\n\n                function objectForEach(obj, action) {\n                    for (var prop in obj) {\n                        if (hasOwnProperty.call(obj, prop)) {\n                            action(prop, obj[prop]);\n                        }\n                    }\n                }\n\n                function extend(target, source) {\n                    if (source) {\n                        for(var prop in source) {\n                            if(hasOwnProperty.call(source, prop)) {\n                                target[prop] = source[prop];\n                            }\n                        }\n                    }\n                    return target;\n                }\n\n                function setPrototypeOf(obj, proto) {\n                    obj.__proto__ = proto;\n                    return obj;\n                }\n\n                var canSetPrototype = ({ __proto__: [] } instanceof Array);\n                var canUseSymbols = !DEBUG && typeof Symbol === 'function';\n\n                // Represent the known event types in a compact way, then at runtime transform it into a hash with event name as key (for fast lookup)\n                var knownEvents = {}, knownEventTypesByEventName = {};\n                var keyEventTypeName = (navigator && /Firefox\\/2/i.test(navigator.userAgent)) ? 'KeyboardEvent' : 'UIEvents';\n                knownEvents[keyEventTypeName] = ['keyup', 'keydown', 'keypress'];\n                knownEvents['MouseEvents'] = ['click', 'dblclick', 'mousedown', 'mouseup', 'mousemove', 'mouseover', 'mouseout', 'mouseenter', 'mouseleave'];\n                objectForEach(knownEvents, function(eventType, knownEventsForType) {\n                    if (knownEventsForType.length) {\n                        for (var i = 0, j = knownEventsForType.length; i < j; i++)\n                            knownEventTypesByEventName[knownEventsForType[i]] = eventType;\n                    }\n                });\n                var eventsThatMustBeRegisteredUsingAttachEvent = { 'propertychange': true }; // Workaround for an IE9 issue - https://github.com/SteveSanderson/knockout/issues/406\n\n                // Detect IE versions for bug workarounds (uses IE conditionals, not UA string, for robustness)\n                // Note that, since IE 10 does not support conditional comments, the following logic only detects IE < 10.\n                // Currently this is by design, since IE 10+ behaves correctly when treated as a standard browser.\n                // If there is a future need to detect specific versions of IE10+, we will amend this.\n                var ieVersion = document && (function() {\n                    var version = 3, div = document.createElement('div'), iElems = div.getElementsByTagName('i');\n\n                    // Keep constructing conditional HTML blocks until we hit one that resolves to an empty fragment\n                    while (\n                        div.innerHTML = '<!--[if gt IE ' + (++version) + ']><i></i><![endif]-->',\n                            iElems[0]\n                        ) {}\n                    return version > 4 ? version : undefined;\n                }());\n                var isIe6 = ieVersion === 6,\n                    isIe7 = ieVersion === 7;\n\n                function isClickOnCheckableElement(element, eventType) {\n                    if ((ko.utils.tagNameLower(element) !== \"input\") || !element.type) return false;\n                    if (eventType.toLowerCase() != \"click\") return false;\n                    var inputType = element.type;\n                    return (inputType == \"checkbox\") || (inputType == \"radio\");\n                }\n\n                // For details on the pattern for changing node classes\n                // see: https://github.com/knockout/knockout/issues/1597\n                var cssClassNameRegex = /\\S+/g;\n\n                var jQueryEventAttachName;\n\n                function toggleDomNodeCssClass(node, classNames, shouldHaveClass) {\n                    var addOrRemoveFn;\n                    if (classNames) {\n                        if (typeof node.classList === 'object') {\n                            addOrRemoveFn = node.classList[shouldHaveClass ? 'add' : 'remove'];\n                            ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                                addOrRemoveFn.call(node.classList, className);\n                            });\n                        } else if (typeof node.className['baseVal'] === 'string') {\n                            // SVG tag .classNames is an SVGAnimatedString instance\n                            toggleObjectClassPropertyString(node.className, 'baseVal', classNames, shouldHaveClass);\n                        } else {\n                            // node.className ought to be a string.\n                            toggleObjectClassPropertyString(node, 'className', classNames, shouldHaveClass);\n                        }\n                    }\n                }\n\n                function toggleObjectClassPropertyString(obj, prop, classNames, shouldHaveClass) {\n                    // obj/prop is either a node/'className' or a SVGAnimatedString/'baseVal'.\n                    var currentClassNames = obj[prop].match(cssClassNameRegex) || [];\n                    ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                        ko.utils.addOrRemoveItem(currentClassNames, className, shouldHaveClass);\n                    });\n                    obj[prop] = currentClassNames.join(\" \");\n                }\n\n                return {\n                    fieldsIncludedWithJsonPost: ['authenticity_token', /^__RequestVerificationToken(_.*)?$/],\n\n                    arrayForEach: function (array, action, actionOwner) {\n                        for (var i = 0, j = array.length; i < j; i++) {\n                            action.call(actionOwner, array[i], i, array);\n                        }\n                    },\n\n                    arrayIndexOf: typeof Array.prototype.indexOf == \"function\"\n                        ? function (array, item) {\n                            return Array.prototype.indexOf.call(array, item);\n                        }\n                        : function (array, item) {\n                            for (var i = 0, j = array.length; i < j; i++) {\n                                if (array[i] === item)\n                                    return i;\n                            }\n                            return -1;\n                        },\n\n                    arrayFirst: function (array, predicate, predicateOwner) {\n                        for (var i = 0, j = array.length; i < j; i++) {\n                            if (predicate.call(predicateOwner, array[i], i, array))\n                                return array[i];\n                        }\n                        return undefined;\n                    },\n\n                    arrayRemoveItem: function (array, itemToRemove) {\n                        var index = ko.utils.arrayIndexOf(array, itemToRemove);\n                        if (index > 0) {\n                            array.splice(index, 1);\n                        }\n                        else if (index === 0) {\n                            array.shift();\n                        }\n                    },\n\n                    arrayGetDistinctValues: function (array) {\n                        var result = [];\n                        if (array) {\n                            ko.utils.arrayForEach(array, function(item) {\n                                if (ko.utils.arrayIndexOf(result, item) < 0)\n                                    result.push(item);\n                            });\n                        }\n                        return result;\n                    },\n\n                    arrayMap: function (array, mapping, mappingOwner) {\n                        var result = [];\n                        if (array) {\n                            for (var i = 0, j = array.length; i < j; i++)\n                                result.push(mapping.call(mappingOwner, array[i], i));\n                        }\n                        return result;\n                    },\n\n                    arrayFilter: function (array, predicate, predicateOwner) {\n                        var result = [];\n                        if (array) {\n                            for (var i = 0, j = array.length; i < j; i++)\n                                if (predicate.call(predicateOwner, array[i], i))\n                                    result.push(array[i]);\n                        }\n                        return result;\n                    },\n\n                    arrayPushAll: function (array, valuesToPush) {\n                        if (valuesToPush instanceof Array)\n                            array.push.apply(array, valuesToPush);\n                        else\n                            for (var i = 0, j = valuesToPush.length; i < j; i++)\n                                array.push(valuesToPush[i]);\n                        return array;\n                    },\n\n                    addOrRemoveItem: function(array, value, included) {\n                        var existingEntryIndex = ko.utils.arrayIndexOf(ko.utils.peekObservable(array), value);\n                        if (existingEntryIndex < 0) {\n                            if (included)\n                                array.push(value);\n                        } else {\n                            if (!included)\n                                array.splice(existingEntryIndex, 1);\n                        }\n                    },\n\n                    canSetPrototype: canSetPrototype,\n\n                    extend: extend,\n\n                    setPrototypeOf: setPrototypeOf,\n\n                    setPrototypeOfOrExtend: canSetPrototype ? setPrototypeOf : extend,\n\n                    objectForEach: objectForEach,\n\n                    objectMap: function(source, mapping, mappingOwner) {\n                        if (!source)\n                            return source;\n                        var target = {};\n                        for (var prop in source) {\n                            if (hasOwnProperty.call(source, prop)) {\n                                target[prop] = mapping.call(mappingOwner, source[prop], prop, source);\n                            }\n                        }\n                        return target;\n                    },\n\n                    emptyDomNode: function (domNode) {\n                        while (domNode.firstChild) {\n                            ko.removeNode(domNode.firstChild);\n                        }\n                    },\n\n                    moveCleanedNodesToContainerElement: function(nodes) {\n                        // Ensure it's a real array, as we're about to reparent the nodes and\n                        // we don't want the underlying collection to change while we're doing that.\n                        var nodesArray = ko.utils.makeArray(nodes);\n                        var templateDocument = (nodesArray[0] && nodesArray[0].ownerDocument) || document;\n\n                        var container = templateDocument.createElement('div');\n                        for (var i = 0, j = nodesArray.length; i < j; i++) {\n                            container.appendChild(ko.cleanNode(nodesArray[i]));\n                        }\n                        return container;\n                    },\n\n                    cloneNodes: function (nodesArray, shouldCleanNodes) {\n                        for (var i = 0, j = nodesArray.length, newNodesArray = []; i < j; i++) {\n                            var clonedNode = nodesArray[i].cloneNode(true);\n                            newNodesArray.push(shouldCleanNodes ? ko.cleanNode(clonedNode) : clonedNode);\n                        }\n                        return newNodesArray;\n                    },\n\n                    setDomNodeChildren: function (domNode, childNodes) {\n                        ko.utils.emptyDomNode(domNode);\n                        if (childNodes) {\n                            for (var i = 0, j = childNodes.length; i < j; i++)\n                                domNode.appendChild(childNodes[i]);\n                        }\n                    },\n\n                    replaceDomNodes: function (nodeToReplaceOrNodeArray, newNodesArray) {\n                        var nodesToReplaceArray = nodeToReplaceOrNodeArray.nodeType ? [nodeToReplaceOrNodeArray] : nodeToReplaceOrNodeArray;\n                        if (nodesToReplaceArray.length > 0) {\n                            var insertionPoint = nodesToReplaceArray[0];\n                            var parent = insertionPoint.parentNode;\n                            for (var i = 0, j = newNodesArray.length; i < j; i++)\n                                parent.insertBefore(newNodesArray[i], insertionPoint);\n                            for (var i = 0, j = nodesToReplaceArray.length; i < j; i++) {\n                                ko.removeNode(nodesToReplaceArray[i]);\n                            }\n                        }\n                    },\n\n                    fixUpContinuousNodeArray: function(continuousNodeArray, parentNode) {\n                        // Before acting on a set of nodes that were previously outputted by a template function, we have to reconcile\n                        // them against what is in the DOM right now. It may be that some of the nodes have already been removed, or that\n                        // new nodes might have been inserted in the middle, for example by a binding. Also, there may previously have been\n                        // leading comment nodes (created by rewritten string-based templates) that have since been removed during binding.\n                        // So, this function translates the old \"map\" output array into its best guess of the set of current DOM nodes.\n                        //\n                        // Rules:\n                        //   [A] Any leading nodes that have been removed should be ignored\n                        //       These most likely correspond to memoization nodes that were already removed during binding\n                        //       See https://github.com/knockout/knockout/pull/440\n                        //   [B] Any trailing nodes that have been remove should be ignored\n                        //       This prevents the code here from adding unrelated nodes to the array while processing rule [C]\n                        //       See https://github.com/knockout/knockout/pull/1903\n                        //   [C] We want to output a continuous series of nodes. So, ignore any nodes that have already been removed,\n                        //       and include any nodes that have been inserted among the previous collection\n\n                        if (continuousNodeArray.length) {\n                            // The parent node can be a virtual element; so get the real parent node\n                            parentNode = (parentNode.nodeType === 8 && parentNode.parentNode) || parentNode;\n\n                            // Rule [A]\n                            while (continuousNodeArray.length && continuousNodeArray[0].parentNode !== parentNode)\n                                continuousNodeArray.splice(0, 1);\n\n                            // Rule [B]\n                            while (continuousNodeArray.length > 1 && continuousNodeArray[continuousNodeArray.length - 1].parentNode !== parentNode)\n                                continuousNodeArray.length--;\n\n                            // Rule [C]\n                            if (continuousNodeArray.length > 1) {\n                                var current = continuousNodeArray[0], last = continuousNodeArray[continuousNodeArray.length - 1];\n                                // Replace with the actual new continuous node set\n                                continuousNodeArray.length = 0;\n                                while (current !== last) {\n                                    continuousNodeArray.push(current);\n                                    current = current.nextSibling;\n                                }\n                                continuousNodeArray.push(last);\n                            }\n                        }\n                        return continuousNodeArray;\n                    },\n\n                    setOptionNodeSelectionState: function (optionNode, isSelected) {\n                        // IE6 sometimes throws \"unknown error\" if you try to write to .selected directly, whereas Firefox struggles with setAttribute. Pick one based on browser.\n                        if (ieVersion < 7)\n                            optionNode.setAttribute(\"selected\", isSelected);\n                        else\n                            optionNode.selected = isSelected;\n                    },\n\n                    stringTrim: function (string) {\n                        return string === null || string === undefined ? '' :\n                            string.trim ?\n                                string.trim() :\n                                string.toString().replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, '');\n                    },\n\n                    stringStartsWith: function (string, startsWith) {\n                        string = string || \"\";\n                        if (startsWith.length > string.length)\n                            return false;\n                        return string.substring(0, startsWith.length) === startsWith;\n                    },\n\n                    domNodeIsContainedBy: function (node, containedByNode) {\n                        if (node === containedByNode)\n                            return true;\n                        if (node.nodeType === 11)\n                            return false; // Fixes issue #1162 - can't use node.contains for document fragments on IE8\n                        if (containedByNode.contains)\n                            return containedByNode.contains(node.nodeType !== 1 ? node.parentNode : node);\n                        if (containedByNode.compareDocumentPosition)\n                            return (containedByNode.compareDocumentPosition(node) & 16) == 16;\n                        while (node && node != containedByNode) {\n                            node = node.parentNode;\n                        }\n                        return !!node;\n                    },\n\n                    domNodeIsAttachedToDocument: function (node) {\n                        return ko.utils.domNodeIsContainedBy(node, node.ownerDocument.documentElement);\n                    },\n\n                    anyDomNodeIsAttachedToDocument: function(nodes) {\n                        return !!ko.utils.arrayFirst(nodes, ko.utils.domNodeIsAttachedToDocument);\n                    },\n\n                    tagNameLower: function(element) {\n                        // For HTML elements, tagName will always be upper case; for XHTML elements, it'll be lower case.\n                        // Possible future optimization: If we know it's an element from an XHTML document (not HTML),\n                        // we don't need to do the .toLowerCase() as it will always be lower case anyway.\n                        return element && element.tagName && element.tagName.toLowerCase();\n                    },\n\n                    catchFunctionErrors: function (delegate) {\n                        return ko['onError'] ? function () {\n                            try {\n                                return delegate.apply(this, arguments);\n                            } catch (e) {\n                                ko['onError'] && ko['onError'](e);\n                                throw e;\n                            }\n                        } : delegate;\n                    },\n\n                    setTimeout: function (handler, timeout) {\n                        return setTimeout(ko.utils.catchFunctionErrors(handler), timeout);\n                    },\n\n                    deferError: function (error) {\n                        setTimeout(function () {\n                            ko['onError'] && ko['onError'](error);\n                            throw error;\n                        }, 0);\n                    },\n\n                    registerEventHandler: function (element, eventType, handler) {\n                        var wrappedHandler = ko.utils.catchFunctionErrors(handler);\n\n                        var mustUseAttachEvent = eventsThatMustBeRegisteredUsingAttachEvent[eventType];\n                        if (!ko.options['useOnlyNativeEvents'] && !mustUseAttachEvent && jQueryInstance) {\n                            if (!jQueryEventAttachName) {\n                                jQueryEventAttachName = (typeof jQueryInstance(element)['on'] == 'function') ? 'on' : 'bind';\n                            }\n                            jQueryInstance(element)[jQueryEventAttachName](eventType, wrappedHandler);\n                        } else if (!mustUseAttachEvent && typeof element.addEventListener == \"function\")\n                            element.addEventListener(eventType, wrappedHandler, false);\n                        else if (typeof element.attachEvent != \"undefined\") {\n                            var attachEventHandler = function (event) { wrappedHandler.call(element, event); },\n                                attachEventName = \"on\" + eventType;\n                            element.attachEvent(attachEventName, attachEventHandler);\n\n                            // IE does not dispose attachEvent handlers automatically (unlike with addEventListener)\n                            // so to avoid leaks, we have to remove them manually. See bug #856\n                            ko.utils.domNodeDisposal.addDisposeCallback(element, function() {\n                                element.detachEvent(attachEventName, attachEventHandler);\n                            });\n                        } else\n                            throw new Error(\"Browser doesn't support addEventListener or attachEvent\");\n                    },\n\n                    triggerEvent: function (element, eventType) {\n                        if (!(element && element.nodeType))\n                            throw new Error(\"element must be a DOM node when calling triggerEvent\");\n\n                        // For click events on checkboxes and radio buttons, jQuery toggles the element checked state *after* the\n                        // event handler runs instead of *before*. (This was fixed in 1.9 for checkboxes but not for radio buttons.)\n                        // IE doesn't change the checked state when you trigger the click event using \"fireEvent\".\n                        // In both cases, we'll use the click method instead.\n                        var useClickWorkaround = isClickOnCheckableElement(element, eventType);\n\n                        if (!ko.options['useOnlyNativeEvents'] && jQueryInstance && !useClickWorkaround) {\n                            jQueryInstance(element)['trigger'](eventType);\n                        } else if (typeof document.createEvent == \"function\") {\n                            if (typeof element.dispatchEvent == \"function\") {\n                                var eventCategory = knownEventTypesByEventName[eventType] || \"HTMLEvents\";\n                                var event = document.createEvent(eventCategory);\n                                event.initEvent(eventType, true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, element);\n                                element.dispatchEvent(event);\n                            }\n                            else\n                                throw new Error(\"The supplied element doesn't support dispatchEvent\");\n                        } else if (useClickWorkaround && element.click) {\n                            element.click();\n                        } else if (typeof element.fireEvent != \"undefined\") {\n                            element.fireEvent(\"on\" + eventType);\n                        } else {\n                            throw new Error(\"Browser doesn't support triggering events\");\n                        }\n                    },\n\n                    unwrapObservable: function (value) {\n                        return ko.isObservable(value) ? value() : value;\n                    },\n\n                    peekObservable: function (value) {\n                        return ko.isObservable(value) ? value.peek() : value;\n                    },\n\n                    toggleDomNodeCssClass: toggleDomNodeCssClass,\n\n                    setTextContent: function(element, textContent) {\n                        var value = ko.utils.unwrapObservable(textContent);\n                        if ((value === null) || (value === undefined))\n                            value = \"\";\n\n                        // We need there to be exactly one child: a text node.\n                        // If there are no children, more than one, or if it's not a text node,\n                        // we'll clear everything and create a single text node.\n                        var innerTextNode = ko.virtualElements.firstChild(element);\n                        if (!innerTextNode || innerTextNode.nodeType != 3 || ko.virtualElements.nextSibling(innerTextNode)) {\n                            ko.virtualElements.setDomNodeChildren(element, [element.ownerDocument.createTextNode(value)]);\n                        } else {\n                            innerTextNode.data = value;\n                        }\n\n                        ko.utils.forceRefresh(element);\n                    },\n\n                    setElementName: function(element, name) {\n                        element.name = name;\n\n                        // Workaround IE 6/7 issue\n                        // - https://github.com/SteveSanderson/knockout/issues/197\n                        // - http://www.matts411.com/post/setting_the_name_attribute_in_ie_dom/\n                        if (ieVersion <= 7) {\n                            try {\n                                var escapedName = element.name.replace(/[&<>'\"]/g, function(r){ return \"&#\" + r.charCodeAt(0) + \";\"; });\n                                element.mergeAttributes(document.createElement(\"<input name='\" + escapedName + \"'/>\"), false);\n                            }\n                            catch(e) {} // For IE9 with doc mode \"IE9 Standards\" and browser mode \"IE9 Compatibility View\"\n                        }\n                    },\n\n                    forceRefresh: function(node) {\n                        // Workaround for an IE9 rendering bug - https://github.com/SteveSanderson/knockout/issues/209\n                        if (ieVersion >= 9) {\n                            // For text nodes and comment nodes (most likely virtual elements), we will have to refresh the container\n                            var elem = node.nodeType == 1 ? node : node.parentNode;\n                            if (elem.style)\n                                elem.style.zoom = elem.style.zoom;\n                        }\n                    },\n\n                    ensureSelectElementIsRenderedCorrectly: function(selectElement) {\n                        // Workaround for IE9 rendering bug - it doesn't reliably display all the text in dynamically-added select boxes unless you force it to re-render by updating the width.\n                        // (See https://github.com/SteveSanderson/knockout/issues/312, http://stackoverflow.com/questions/5908494/select-only-shows-first-char-of-selected-option)\n                        // Also fixes IE7 and IE8 bug that causes selects to be zero width if enclosed by 'if' or 'with'. (See issue #839)\n                        if (ieVersion) {\n                            var originalWidth = selectElement.style.width;\n                            selectElement.style.width = 0;\n                            selectElement.style.width = originalWidth;\n                        }\n                    },\n\n                    range: function (min, max) {\n                        min = ko.utils.unwrapObservable(min);\n                        max = ko.utils.unwrapObservable(max);\n                        var result = [];\n                        for (var i = min; i <= max; i++)\n                            result.push(i);\n                        return result;\n                    },\n\n                    makeArray: function(arrayLikeObject) {\n                        var result = [];\n                        for (var i = 0, j = arrayLikeObject.length; i < j; i++) {\n                            result.push(arrayLikeObject[i]);\n                        };\n                        return result;\n                    },\n\n                    createSymbolOrString: function(identifier) {\n                        return canUseSymbols ? Symbol(identifier) : identifier;\n                    },\n\n                    isIe6 : isIe6,\n                    isIe7 : isIe7,\n                    ieVersion : ieVersion,\n\n                    getFormFields: function(form, fieldName) {\n                        var fields = ko.utils.makeArray(form.getElementsByTagName(\"input\")).concat(ko.utils.makeArray(form.getElementsByTagName(\"textarea\")));\n                        var isMatchingField = (typeof fieldName == 'string')\n                            ? function(field) { return field.name === fieldName }\n                            : function(field) { return fieldName.test(field.name) }; // Treat fieldName as regex or object containing predicate\n                        var matches = [];\n                        for (var i = fields.length - 1; i >= 0; i--) {\n                            if (isMatchingField(fields[i]))\n                                matches.push(fields[i]);\n                        };\n                        return matches;\n                    },\n\n                    parseJson: function (jsonString) {\n                        if (typeof jsonString == \"string\") {\n                            jsonString = ko.utils.stringTrim(jsonString);\n                            if (jsonString) {\n                                if (JSON && JSON.parse) // Use native parsing where available\n                                    return JSON.parse(jsonString);\n                                return (new Function(\"return \" + jsonString))(); // Fallback on less safe parsing for older browsers\n                            }\n                        }\n                        return null;\n                    },\n\n                    stringifyJson: function (data, replacer, space) {   // replacer and space are optional\n                        if (!JSON || !JSON.stringify)\n                            throw new Error(\"Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js\");\n                        return JSON.stringify(ko.utils.unwrapObservable(data), replacer, space);\n                    },\n\n                    postJson: function (urlOrForm, data, options) {\n                        options = options || {};\n                        var params = options['params'] || {};\n                        var includeFields = options['includeFields'] || this.fieldsIncludedWithJsonPost;\n                        var url = urlOrForm;\n\n                        // If we were given a form, use its 'action' URL and pick out any requested field values\n                        if((typeof urlOrForm == 'object') && (ko.utils.tagNameLower(urlOrForm) === \"form\")) {\n                            var originalForm = urlOrForm;\n                            url = originalForm.action;\n                            for (var i = includeFields.length - 1; i >= 0; i--) {\n                                var fields = ko.utils.getFormFields(originalForm, includeFields[i]);\n                                for (var j = fields.length - 1; j >= 0; j--)\n                                    params[fields[j].name] = fields[j].value;\n                            }\n                        }\n\n                        data = ko.utils.unwrapObservable(data);\n                        var form = document.createElement(\"form\");\n                        form.style.display = \"none\";\n                        form.action = url;\n                        form.method = \"post\";\n                        for (var key in data) {\n                            // Since 'data' this is a model object, we include all properties including those inherited from its prototype\n                            var input = document.createElement(\"input\");\n                            input.type = \"hidden\";\n                            input.name = key;\n                            input.value = ko.utils.stringifyJson(ko.utils.unwrapObservable(data[key]));\n                            form.appendChild(input);\n                        }\n                        objectForEach(params, function(key, value) {\n                            var input = document.createElement(\"input\");\n                            input.type = \"hidden\";\n                            input.name = key;\n                            input.value = value;\n                            form.appendChild(input);\n                        });\n                        document.body.appendChild(form);\n                        options['submitter'] ? options['submitter'](form) : form.submit();\n                        setTimeout(function () { form.parentNode.removeChild(form); }, 0);\n                    }\n                }\n            }());\n\n            ko.exportSymbol('utils', ko.utils);\n            ko.exportSymbol('utils.arrayForEach', ko.utils.arrayForEach);\n            ko.exportSymbol('utils.arrayFirst', ko.utils.arrayFirst);\n            ko.exportSymbol('utils.arrayFilter', ko.utils.arrayFilter);\n            ko.exportSymbol('utils.arrayGetDistinctValues', ko.utils.arrayGetDistinctValues);\n            ko.exportSymbol('utils.arrayIndexOf', ko.utils.arrayIndexOf);\n            ko.exportSymbol('utils.arrayMap', ko.utils.arrayMap);\n            ko.exportSymbol('utils.arrayPushAll', ko.utils.arrayPushAll);\n            ko.exportSymbol('utils.arrayRemoveItem', ko.utils.arrayRemoveItem);\n            ko.exportSymbol('utils.cloneNodes', ko.utils.cloneNodes);\n            ko.exportSymbol('utils.createSymbolOrString', ko.utils.createSymbolOrString);\n            ko.exportSymbol('utils.extend', ko.utils.extend);\n            ko.exportSymbol('utils.fieldsIncludedWithJsonPost', ko.utils.fieldsIncludedWithJsonPost);\n            ko.exportSymbol('utils.getFormFields', ko.utils.getFormFields);\n            ko.exportSymbol('utils.objectMap', ko.utils.objectMap);\n            ko.exportSymbol('utils.peekObservable', ko.utils.peekObservable);\n            ko.exportSymbol('utils.postJson', ko.utils.postJson);\n            ko.exportSymbol('utils.parseJson', ko.utils.parseJson);\n            ko.exportSymbol('utils.registerEventHandler', ko.utils.registerEventHandler);\n            ko.exportSymbol('utils.stringifyJson', ko.utils.stringifyJson);\n            ko.exportSymbol('utils.range', ko.utils.range);\n            ko.exportSymbol('utils.toggleDomNodeCssClass', ko.utils.toggleDomNodeCssClass);\n            ko.exportSymbol('utils.triggerEvent', ko.utils.triggerEvent);\n            ko.exportSymbol('utils.unwrapObservable', ko.utils.unwrapObservable);\n            ko.exportSymbol('utils.objectForEach', ko.utils.objectForEach);\n            ko.exportSymbol('utils.addOrRemoveItem', ko.utils.addOrRemoveItem);\n            ko.exportSymbol('utils.setTextContent', ko.utils.setTextContent);\n            ko.exportSymbol('unwrap', ko.utils.unwrapObservable); // Convenient shorthand, because this is used so commonly\n\n            if (!Function.prototype['bind']) {\n                // Function.prototype.bind is a standard part of ECMAScript 5th Edition (December 2009, http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf)\n                // In case the browser doesn't implement it natively, provide a JavaScript implementation. This implementation is based on the one in prototype.js\n                Function.prototype['bind'] = function (object) {\n                    var originalFunction = this;\n                    if (arguments.length === 1) {\n                        return function () {\n                            return originalFunction.apply(object, arguments);\n                        };\n                    } else {\n                        var partialArgs = Array.prototype.slice.call(arguments, 1);\n                        return function () {\n                            var args = partialArgs.slice(0);\n                            args.push.apply(args, arguments);\n                            return originalFunction.apply(object, args);\n                        };\n                    }\n                };\n            }\n\n            ko.utils.domData = new (function () {\n                var uniqueId = 0;\n                var dataStoreKeyExpandoPropertyName = \"__ko__\" + (new Date).getTime();\n                var dataStore = {};\n\n                var getDataForNode, clear;\n                if (!ko.utils.ieVersion) {\n                    // We considered using WeakMap, but it has a problem in IE 11 and Edge that prevents using\n                    // it cross-window, so instead we just store the data directly on the node.\n                    // See https://github.com/knockout/knockout/issues/2141\n                    getDataForNode = function (node, createIfNotFound) {\n                        var dataForNode = node[dataStoreKeyExpandoPropertyName];\n                        if (!dataForNode && createIfNotFound) {\n                            dataForNode = node[dataStoreKeyExpandoPropertyName] = {};\n                        }\n                        return dataForNode;\n                    };\n                    clear = function (node) {\n                        if (node[dataStoreKeyExpandoPropertyName]) {\n                            delete node[dataStoreKeyExpandoPropertyName];\n                            return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n                        }\n                        return false;\n                    };\n                } else {\n                    // Old IE versions have memory issues if you store objects on the node, so we use a\n                    // separate data storage and link to it from the node using a string key.\n                    getDataForNode = function (node, createIfNotFound) {\n                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n                        var hasExistingDataStore = dataStoreKey && (dataStoreKey !== \"null\") && dataStore[dataStoreKey];\n                        if (!hasExistingDataStore) {\n                            if (!createIfNotFound)\n                                return undefined;\n                            dataStoreKey = node[dataStoreKeyExpandoPropertyName] = \"ko\" + uniqueId++;\n                            dataStore[dataStoreKey] = {};\n                        }\n                        return dataStore[dataStoreKey];\n                    };\n                    clear = function (node) {\n                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n                        if (dataStoreKey) {\n                            delete dataStore[dataStoreKey];\n                            node[dataStoreKeyExpandoPropertyName] = null;\n                            return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n                        }\n                        return false;\n                    };\n                }\n\n                return {\n                    get: function (node, key) {\n                        var dataForNode = getDataForNode(node, false);\n                        return dataForNode && dataForNode[key];\n                    },\n                    set: function (node, key, value) {\n                        // Make sure we don't actually create a new domData key if we are actually deleting a value\n                        var dataForNode = getDataForNode(node, value !== undefined /* createIfNotFound */);\n                        dataForNode && (dataForNode[key] = value);\n                    },\n                    getOrSet: function (node, key, value) {\n                        var dataForNode = getDataForNode(node, true /* createIfNotFound */);\n                        return dataForNode[key] || (dataForNode[key] = value);\n                    },\n                    clear: clear,\n\n                    nextKey: function () {\n                        return (uniqueId++) + dataStoreKeyExpandoPropertyName;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('utils.domData', ko.utils.domData);\n            ko.exportSymbol('utils.domData.clear', ko.utils.domData.clear); // Exporting only so specs can clear up after themselves fully\n\n            ko.utils.domNodeDisposal = new (function () {\n                var domDataKey = ko.utils.domData.nextKey();\n                var cleanableNodeTypes = { 1: true, 8: true, 9: true };       // Element, Comment, Document\n                var cleanableNodeTypesWithDescendants = { 1: true, 9: true }; // Element, Document\n\n                function getDisposeCallbacksCollection(node, createIfNotFound) {\n                    var allDisposeCallbacks = ko.utils.domData.get(node, domDataKey);\n                    if ((allDisposeCallbacks === undefined) && createIfNotFound) {\n                        allDisposeCallbacks = [];\n                        ko.utils.domData.set(node, domDataKey, allDisposeCallbacks);\n                    }\n                    return allDisposeCallbacks;\n                }\n                function destroyCallbacksCollection(node) {\n                    ko.utils.domData.set(node, domDataKey, undefined);\n                }\n\n                function cleanSingleNode(node) {\n                    // Run all the dispose callbacks\n                    var callbacks = getDisposeCallbacksCollection(node, false);\n                    if (callbacks) {\n                        callbacks = callbacks.slice(0); // Clone, as the array may be modified during iteration (typically, callbacks will remove themselves)\n                        for (var i = 0; i < callbacks.length; i++)\n                            callbacks[i](node);\n                    }\n\n                    // Erase the DOM data\n                    ko.utils.domData.clear(node);\n\n                    // Perform cleanup needed by external libraries (currently only jQuery, but can be extended)\n                    ko.utils.domNodeDisposal[\"cleanExternalData\"](node);\n\n                    // Clear any immediate-child comment nodes, as these wouldn't have been found by\n                    // node.getElementsByTagName(\"*\") in cleanNode() (comment nodes aren't elements)\n                    if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                        cleanNodesInList(node.childNodes, true/*onlyComments*/);\n                    }\n                }\n\n                function cleanNodesInList(nodeList, onlyComments) {\n                    var cleanedNodes = [], lastCleanedNode;\n                    for (var i = 0; i < nodeList.length; i++) {\n                        if (!onlyComments || nodeList[i].nodeType === 8) {\n                            cleanSingleNode(cleanedNodes[cleanedNodes.length] = lastCleanedNode = nodeList[i]);\n                            if (nodeList[i] !== lastCleanedNode) {\n                                while (i-- && ko.utils.arrayIndexOf(cleanedNodes, nodeList[i]) == -1) {}\n                            }\n                        }\n                    }\n                }\n\n                return {\n                    addDisposeCallback : function(node, callback) {\n                        if (typeof callback != \"function\")\n                            throw new Error(\"Callback must be a function\");\n                        getDisposeCallbacksCollection(node, true).push(callback);\n                    },\n\n                    removeDisposeCallback : function(node, callback) {\n                        var callbacksCollection = getDisposeCallbacksCollection(node, false);\n                        if (callbacksCollection) {\n                            ko.utils.arrayRemoveItem(callbacksCollection, callback);\n                            if (callbacksCollection.length == 0)\n                                destroyCallbacksCollection(node);\n                        }\n                    },\n\n                    cleanNode : function(node) {\n                        ko.dependencyDetection.ignore(function () {\n                            // First clean this node, where applicable\n                            if (cleanableNodeTypes[node.nodeType]) {\n                                cleanSingleNode(node);\n\n                                // ... then its descendants, where applicable\n                                if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                                    cleanNodesInList(node.getElementsByTagName(\"*\"));\n                                }\n                            }\n                        });\n\n                        return node;\n                    },\n\n                    removeNode : function(node) {\n                        ko.cleanNode(node);\n                        if (node.parentNode)\n                            node.parentNode.removeChild(node);\n                    },\n\n                    \"cleanExternalData\" : function (node) {\n                        // Special support for jQuery here because it's so commonly used.\n                        // Many jQuery plugins (including jquery.tmpl) store data using jQuery's equivalent of domData\n                        // so notify it to tear down any resources associated with the node & descendants here.\n                        if (jQueryInstance && (typeof jQueryInstance['cleanData'] == \"function\"))\n                            jQueryInstance['cleanData']([node]);\n                    }\n                };\n            })();\n            ko.cleanNode = ko.utils.domNodeDisposal.cleanNode; // Shorthand name for convenience\n            ko.removeNode = ko.utils.domNodeDisposal.removeNode; // Shorthand name for convenience\n            ko.exportSymbol('cleanNode', ko.cleanNode);\n            ko.exportSymbol('removeNode', ko.removeNode);\n            ko.exportSymbol('utils.domNodeDisposal', ko.utils.domNodeDisposal);\n            ko.exportSymbol('utils.domNodeDisposal.addDisposeCallback', ko.utils.domNodeDisposal.addDisposeCallback);\n            ko.exportSymbol('utils.domNodeDisposal.removeDisposeCallback', ko.utils.domNodeDisposal.removeDisposeCallback);\n            (function () {\n                var none = [0, \"\", \"\"],\n                    table = [1, \"<table>\", \"</table>\"],\n                    tbody = [2, \"<table><tbody>\", \"</tbody></table>\"],\n                    tr = [3, \"<table><tbody><tr>\", \"</tr></tbody></table>\"],\n                    select = [1, \"<select multiple='multiple'>\", \"</select>\"],\n                    lookup = {\n                        'thead': table,\n                        'tbody': table,\n                        'tfoot': table,\n                        'tr': tbody,\n                        'td': tr,\n                        'th': tr,\n                        'option': select,\n                        'optgroup': select\n                    },\n\n                    // This is needed for old IE if you're *not* using either jQuery or innerShiv. Doesn't affect other cases.\n                    mayRequireCreateElementHack = ko.utils.ieVersion <= 8;\n\n                function getWrap(tags) {\n                    var m = tags.match(/^(?:<!--.*?-->\\s*?)*?<([a-z]+)[\\s>]/);\n                    return (m && lookup[m[1]]) || none;\n                }\n\n                function simpleHtmlParse(html, documentContext) {\n                    documentContext || (documentContext = document);\n                    var windowContext = documentContext['parentWindow'] || documentContext['defaultView'] || window;\n\n                    // Based on jQuery's \"clean\" function, but only accounting for table-related elements.\n                    // If you have referenced jQuery, this won't be used anyway - KO will use jQuery's \"clean\" function directly\n\n                    // Note that there's still an issue in IE < 9 whereby it will discard comment nodes that are the first child of\n                    // a descendant node. For example: \"<div><!-- mycomment -->abc</div>\" will get parsed as \"<div>abc</div>\"\n                    // This won't affect anyone who has referenced jQuery, and there's always the workaround of inserting a dummy node\n                    // (possibly a text node) in front of the comment. So, KO does not attempt to workaround this IE issue automatically at present.\n\n                    // Trim whitespace, otherwise indexOf won't work as expected\n                    var tags = ko.utils.stringTrim(html).toLowerCase(), div = documentContext.createElement(\"div\"),\n                        wrap = getWrap(tags),\n                        depth = wrap[0];\n\n                    // Go to html and back, then peel off extra wrappers\n                    // Note that we always prefix with some dummy text, because otherwise, IE<9 will strip out leading comment nodes in descendants. Total madness.\n                    var markup = \"ignored<div>\" + wrap[1] + html + wrap[2] + \"</div>\";\n                    if (typeof windowContext['innerShiv'] == \"function\") {\n                        // Note that innerShiv is deprecated in favour of html5shiv. We should consider adding\n                        // support for html5shiv (except if no explicit support is needed, e.g., if html5shiv\n                        // somehow shims the native APIs so it just works anyway)\n                        div.appendChild(windowContext['innerShiv'](markup));\n                    } else {\n                        if (mayRequireCreateElementHack) {\n                            // The document.createElement('my-element') trick to enable custom elements in IE6-8\n                            // only works if we assign innerHTML on an element associated with that document.\n                            documentContext.body.appendChild(div);\n                        }\n\n                        div.innerHTML = markup;\n\n                        if (mayRequireCreateElementHack) {\n                            div.parentNode.removeChild(div);\n                        }\n                    }\n\n                    // Move to the right depth\n                    while (depth--)\n                        div = div.lastChild;\n\n                    return ko.utils.makeArray(div.lastChild.childNodes);\n                }\n\n                function jQueryHtmlParse(html, documentContext) {\n                    // jQuery's \"parseHTML\" function was introduced in jQuery 1.8.0 and is a documented public API.\n                    if (jQueryInstance['parseHTML']) {\n                        return jQueryInstance['parseHTML'](html, documentContext) || []; // Ensure we always return an array and never null\n                    } else {\n                        // For jQuery < 1.8.0, we fall back on the undocumented internal \"clean\" function.\n                        var elems = jQueryInstance['clean']([html], documentContext);\n\n                        // As of jQuery 1.7.1, jQuery parses the HTML by appending it to some dummy parent nodes held in an in-memory document fragment.\n                        // Unfortunately, it never clears the dummy parent nodes from the document fragment, so it leaks memory over time.\n                        // Fix this by finding the top-most dummy parent element, and detaching it from its owner fragment.\n                        if (elems && elems[0]) {\n                            // Find the top-most parent element that's a direct child of a document fragment\n                            var elem = elems[0];\n                            while (elem.parentNode && elem.parentNode.nodeType !== 11 /* i.e., DocumentFragment */)\n                                elem = elem.parentNode;\n                            // ... then detach it\n                            if (elem.parentNode)\n                                elem.parentNode.removeChild(elem);\n                        }\n\n                        return elems;\n                    }\n                }\n\n                ko.utils.parseHtmlFragment = function(html, documentContext) {\n                    return jQueryInstance ?\n                        jQueryHtmlParse(html, documentContext) :   // As below, benefit from jQuery's optimisations where possible\n                        simpleHtmlParse(html, documentContext);  // ... otherwise, this simple logic will do in most common cases.\n                };\n\n                ko.utils.parseHtmlForTemplateNodes = function(html, documentContext) {\n                    var nodes = ko.utils.parseHtmlFragment(html, documentContext);\n                    return (nodes.length && nodes[0].parentElement) || ko.utils.moveCleanedNodesToContainerElement(nodes);\n                };\n\n                ko.utils.setHtml = function(node, html) {\n                    ko.utils.emptyDomNode(node);\n\n                    // There's no legitimate reason to display a stringified observable without unwrapping it, so we'll unwrap it\n                    html = ko.utils.unwrapObservable(html);\n\n                    if ((html !== null) && (html !== undefined)) {\n                        if (typeof html != 'string')\n                            html = html.toString();\n\n                        // jQuery contains a lot of sophisticated code to parse arbitrary HTML fragments,\n                        // for example <tr> elements which are not normally allowed to exist on their own.\n                        // If you've referenced jQuery we'll use that rather than duplicating its code.\n                        if (jQueryInstance) {\n                            jQueryInstance(node)['html'](html);\n                        } else {\n                            // ... otherwise, use KO's own parsing logic.\n                            var parsedNodes = ko.utils.parseHtmlFragment(html, node.ownerDocument);\n                            for (var i = 0; i < parsedNodes.length; i++)\n                                node.appendChild(parsedNodes[i]);\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('utils.parseHtmlFragment', ko.utils.parseHtmlFragment);\n            ko.exportSymbol('utils.setHtml', ko.utils.setHtml);\n\n            ko.memoization = (function () {\n                var memos = {};\n\n                function randomMax8HexChars() {\n                    return (((1 + Math.random()) * 0x100000000) | 0).toString(16).substring(1);\n                }\n                function generateRandomId() {\n                    return randomMax8HexChars() + randomMax8HexChars();\n                }\n                function findMemoNodes(rootNode, appendToArray) {\n                    if (!rootNode)\n                        return;\n                    if (rootNode.nodeType == 8) {\n                        var memoId = ko.memoization.parseMemoText(rootNode.nodeValue);\n                        if (memoId != null)\n                            appendToArray.push({ domNode: rootNode, memoId: memoId });\n                    } else if (rootNode.nodeType == 1) {\n                        for (var i = 0, childNodes = rootNode.childNodes, j = childNodes.length; i < j; i++)\n                            findMemoNodes(childNodes[i], appendToArray);\n                    }\n                }\n\n                return {\n                    memoize: function (callback) {\n                        if (typeof callback != \"function\")\n                            throw new Error(\"You can only pass a function to ko.memoization.memoize()\");\n                        var memoId = generateRandomId();\n                        memos[memoId] = callback;\n                        return \"<!--[ko_memo:\" + memoId + \"]-->\";\n                    },\n\n                    unmemoize: function (memoId, callbackParams) {\n                        var callback = memos[memoId];\n                        if (callback === undefined)\n                            throw new Error(\"Couldn't find any memo with ID \" + memoId + \". Perhaps it's already been unmemoized.\");\n                        try {\n                            callback.apply(null, callbackParams || []);\n                            return true;\n                        }\n                        finally { delete memos[memoId]; }\n                    },\n\n                    unmemoizeDomNodeAndDescendants: function (domNode, extraCallbackParamsArray) {\n                        var memos = [];\n                        findMemoNodes(domNode, memos);\n                        for (var i = 0, j = memos.length; i < j; i++) {\n                            var node = memos[i].domNode;\n                            var combinedParams = [node];\n                            if (extraCallbackParamsArray)\n                                ko.utils.arrayPushAll(combinedParams, extraCallbackParamsArray);\n                            ko.memoization.unmemoize(memos[i].memoId, combinedParams);\n                            node.nodeValue = \"\"; // Neuter this node so we don't try to unmemoize it again\n                            if (node.parentNode)\n                                node.parentNode.removeChild(node); // If possible, erase it totally (not always possible - someone else might just hold a reference to it then call unmemoizeDomNodeAndDescendants again)\n                        }\n                    },\n\n                    parseMemoText: function (memoText) {\n                        var match = memoText.match(/^\\[ko_memo\\:(.*?)\\]$/);\n                        return match ? match[1] : null;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('memoization', ko.memoization);\n            ko.exportSymbol('memoization.memoize', ko.memoization.memoize);\n            ko.exportSymbol('memoization.unmemoize', ko.memoization.unmemoize);\n            ko.exportSymbol('memoization.parseMemoText', ko.memoization.parseMemoText);\n            ko.exportSymbol('memoization.unmemoizeDomNodeAndDescendants', ko.memoization.unmemoizeDomNodeAndDescendants);\n            ko.tasks = (function () {\n                var scheduler,\n                    taskQueue = [],\n                    taskQueueLength = 0,\n                    nextHandle = 1,\n                    nextIndexToProcess = 0;\n\n                if (window['MutationObserver']) {\n                    // Chrome 27+, Firefox 14+, IE 11+, Opera 15+, Safari 6.1+\n                    // From https://github.com/petkaantonov/bluebird * Copyright (c) 2014 Petka Antonov * License: MIT\n                    scheduler = (function (callback) {\n                        var div = document.createElement(\"div\");\n                        new MutationObserver(callback).observe(div, {attributes: true});\n                        return function () { div.classList.toggle(\"foo\"); };\n                    })(scheduledProcess);\n                } else if (document && \"onreadystatechange\" in document.createElement(\"script\")) {\n                    // IE 6-10\n                    // From https://github.com/YuzuJS/setImmediate * Copyright (c) 2012 Barnesandnoble.com, llc, Donavon West, and Domenic Denicola * License: MIT\n                    scheduler = function (callback) {\n                        var script = document.createElement(\"script\");\n                        script.onreadystatechange = function () {\n                            script.onreadystatechange = null;\n                            document.documentElement.removeChild(script);\n                            script = null;\n                            callback();\n                        };\n                        document.documentElement.appendChild(script);\n                    };\n                } else {\n                    scheduler = function (callback) {\n                        setTimeout(callback, 0);\n                    };\n                }\n\n                function processTasks() {\n                    if (taskQueueLength) {\n                        // Each mark represents the end of a logical group of tasks and the number of these groups is\n                        // limited to prevent unchecked recursion.\n                        var mark = taskQueueLength, countMarks = 0;\n\n                        // nextIndexToProcess keeps track of where we are in the queue; processTasks can be called recursively without issue\n                        for (var task; nextIndexToProcess < taskQueueLength; ) {\n                            if (task = taskQueue[nextIndexToProcess++]) {\n                                if (nextIndexToProcess > mark) {\n                                    if (++countMarks >= 5000) {\n                                        nextIndexToProcess = taskQueueLength;   // skip all tasks remaining in the queue since any of them could be causing the recursion\n                                        ko.utils.deferError(Error(\"'Too much recursion' after processing \" + countMarks + \" task groups.\"));\n                                        break;\n                                    }\n                                    mark = taskQueueLength;\n                                }\n                                try {\n                                    task();\n                                } catch (ex) {\n                                    ko.utils.deferError(ex);\n                                }\n                            }\n                        }\n                    }\n                }\n\n                function scheduledProcess() {\n                    processTasks();\n\n                    // Reset the queue\n                    nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n                }\n\n                function scheduleTaskProcessing() {\n                    ko.tasks['scheduler'](scheduledProcess);\n                }\n\n                var tasks = {\n                    'scheduler': scheduler,     // Allow overriding the scheduler\n\n                    schedule: function (func) {\n                        if (!taskQueueLength) {\n                            scheduleTaskProcessing();\n                        }\n\n                        taskQueue[taskQueueLength++] = func;\n                        return nextHandle++;\n                    },\n\n                    cancel: function (handle) {\n                        var index = handle - (nextHandle - taskQueueLength);\n                        if (index >= nextIndexToProcess && index < taskQueueLength) {\n                            taskQueue[index] = null;\n                        }\n                    },\n\n                    // For testing only: reset the queue and return the previous queue length\n                    'resetForTesting': function () {\n                        var length = taskQueueLength - nextIndexToProcess;\n                        nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n                        return length;\n                    },\n\n                    runEarly: processTasks\n                };\n\n                return tasks;\n            })();\n\n            ko.exportSymbol('tasks', ko.tasks);\n            ko.exportSymbol('tasks.schedule', ko.tasks.schedule);\n//ko.exportSymbol('tasks.cancel', ko.tasks.cancel);  \"cancel\" isn't minified\n            ko.exportSymbol('tasks.runEarly', ko.tasks.runEarly);\n            ko.extenders = {\n                'throttle': function(target, timeout) {\n                    // Throttling means two things:\n\n                    // (1) For dependent observables, we throttle *evaluations* so that, no matter how fast its dependencies\n                    //     notify updates, the target doesn't re-evaluate (and hence doesn't notify) faster than a certain rate\n                    target['throttleEvaluation'] = timeout;\n\n                    // (2) For writable targets (observables, or writable dependent observables), we throttle *writes*\n                    //     so the target cannot change value synchronously or faster than a certain rate\n                    var writeTimeoutInstance = null;\n                    return ko.dependentObservable({\n                        'read': target,\n                        'write': function(value) {\n                            clearTimeout(writeTimeoutInstance);\n                            writeTimeoutInstance = ko.utils.setTimeout(function() {\n                                target(value);\n                            }, timeout);\n                        }\n                    });\n                },\n\n                'rateLimit': function(target, options) {\n                    var timeout, method, limitFunction;\n\n                    if (typeof options == 'number') {\n                        timeout = options;\n                    } else {\n                        timeout = options['timeout'];\n                        method = options['method'];\n                    }\n\n                    // rateLimit supersedes deferred updates\n                    target._deferUpdates = false;\n\n                    limitFunction = typeof method == 'function' ? method : method == 'notifyWhenChangesStop' ?  debounce : throttle;\n                    target.limit(function(callback) {\n                        return limitFunction(callback, timeout, options);\n                    });\n                },\n\n                'deferred': function(target, options) {\n                    if (options !== true) {\n                        throw new Error('The \\'deferred\\' extender only accepts the value \\'true\\', because it is not supported to turn deferral off once enabled.')\n                    }\n\n                    if (!target._deferUpdates) {\n                        target._deferUpdates = true;\n                        target.limit(function (callback) {\n                            var handle,\n                                ignoreUpdates = false;\n                            return function () {\n                                if (!ignoreUpdates) {\n                                    ko.tasks.cancel(handle);\n                                    handle = ko.tasks.schedule(callback);\n\n                                    try {\n                                        ignoreUpdates = true;\n                                        target['notifySubscribers'](undefined, 'dirty');\n                                    } finally {\n                                        ignoreUpdates = false;\n                                    }\n                                }\n                            };\n                        });\n                    }\n                },\n\n                'notify': function(target, notifyWhen) {\n                    target[\"equalityComparer\"] = notifyWhen == \"always\" ?\n                        null :  // null equalityComparer means to always notify\n                        valuesArePrimitiveAndEqual;\n                }\n            };\n\n            var primitiveTypes = { 'undefined':1, 'boolean':1, 'number':1, 'string':1 };\n            function valuesArePrimitiveAndEqual(a, b) {\n                var oldValueIsPrimitive = (a === null) || (typeof(a) in primitiveTypes);\n                return oldValueIsPrimitive ? (a === b) : false;\n            }\n\n            function throttle(callback, timeout) {\n                var timeoutInstance;\n                return function () {\n                    if (!timeoutInstance) {\n                        timeoutInstance = ko.utils.setTimeout(function () {\n                            timeoutInstance = undefined;\n                            callback();\n                        }, timeout);\n                    }\n                };\n            }\n\n            function debounce(callback, timeout) {\n                var timeoutInstance;\n                return function () {\n                    clearTimeout(timeoutInstance);\n                    timeoutInstance = ko.utils.setTimeout(callback, timeout);\n                };\n            }\n\n            function applyExtenders(requestedExtenders) {\n                var target = this;\n                if (requestedExtenders) {\n                    ko.utils.objectForEach(requestedExtenders, function(key, value) {\n                        var extenderHandler = ko.extenders[key];\n                        if (typeof extenderHandler == 'function') {\n                            target = extenderHandler(target, value) || target;\n                        }\n                    });\n                }\n                return target;\n            }\n\n            ko.exportSymbol('extenders', ko.extenders);\n\n            ko.subscription = function (target, callback, disposeCallback) {\n                this._target = target;\n                this._callback = callback;\n                this._disposeCallback = disposeCallback;\n                this._isDisposed = false;\n                this._node = null;\n                this._domNodeDisposalCallback = null;\n                ko.exportProperty(this, 'dispose', this.dispose);\n                ko.exportProperty(this, 'disposeWhenNodeIsRemoved', this.disposeWhenNodeIsRemoved);\n            };\n            ko.subscription.prototype.dispose = function () {\n                var self = this;\n                if (!self._isDisposed) {\n                    if (self._domNodeDisposalCallback) {\n                        ko.utils.domNodeDisposal.removeDisposeCallback(self._node, self._domNodeDisposalCallback);\n                    }\n                    self._isDisposed = true;\n                    self._disposeCallback();\n\n                    self._target = self._callback = self._disposeCallback = self._node = self._domNodeDisposalCallback = null;\n                }\n            };\n            ko.subscription.prototype.disposeWhenNodeIsRemoved = function (node) {\n                this._node = node;\n                ko.utils.domNodeDisposal.addDisposeCallback(node, this._domNodeDisposalCallback = this.dispose.bind(this));\n            };\n\n            ko.subscribable = function () {\n                ko.utils.setPrototypeOfOrExtend(this, ko_subscribable_fn);\n                ko_subscribable_fn.init(this);\n            }\n\n            var defaultEvent = \"change\";\n\n// Moved out of \"limit\" to avoid the extra closure\n            function limitNotifySubscribers(value, event) {\n                if (!event || event === defaultEvent) {\n                    this._limitChange(value);\n                } else if (event === 'beforeChange') {\n                    this._limitBeforeChange(value);\n                } else {\n                    this._origNotifySubscribers(value, event);\n                }\n            }\n\n            var ko_subscribable_fn = {\n                init: function(instance) {\n                    instance._subscriptions = { \"change\": [] };\n                    instance._versionNumber = 1;\n                },\n\n                subscribe: function (callback, callbackTarget, event) {\n                    var self = this;\n\n                    event = event || defaultEvent;\n                    var boundCallback = callbackTarget ? callback.bind(callbackTarget) : callback;\n\n                    var subscription = new ko.subscription(self, boundCallback, function () {\n                        ko.utils.arrayRemoveItem(self._subscriptions[event], subscription);\n                        if (self.afterSubscriptionRemove)\n                            self.afterSubscriptionRemove(event);\n                    });\n\n                    if (self.beforeSubscriptionAdd)\n                        self.beforeSubscriptionAdd(event);\n\n                    if (!self._subscriptions[event])\n                        self._subscriptions[event] = [];\n                    self._subscriptions[event].push(subscription);\n\n                    return subscription;\n                },\n\n                \"notifySubscribers\": function (valueToNotify, event) {\n                    event = event || defaultEvent;\n                    if (event === defaultEvent) {\n                        this.updateVersion();\n                    }\n                    if (this.hasSubscriptionsForEvent(event)) {\n                        var subs = event === defaultEvent && this._changeSubscriptions || this._subscriptions[event].slice(0);\n                        try {\n                            ko.dependencyDetection.begin(); // Begin suppressing dependency detection (by setting the top frame to undefined)\n                            for (var i = 0, subscription; subscription = subs[i]; ++i) {\n                                // In case a subscription was disposed during the arrayForEach cycle, check\n                                // for isDisposed on each subscription before invoking its callback\n                                if (!subscription._isDisposed)\n                                    subscription._callback(valueToNotify);\n                            }\n                        } finally {\n                            ko.dependencyDetection.end(); // End suppressing dependency detection\n                        }\n                    }\n                },\n\n                getVersion: function () {\n                    return this._versionNumber;\n                },\n\n                hasChanged: function (versionToCheck) {\n                    return this.getVersion() !== versionToCheck;\n                },\n\n                updateVersion: function () {\n                    ++this._versionNumber;\n                },\n\n                limit: function(limitFunction) {\n                    var self = this, selfIsObservable = ko.isObservable(self),\n                        ignoreBeforeChange, notifyNextChange, previousValue, pendingValue, didUpdate,\n                        beforeChange = 'beforeChange';\n\n                    if (!self._origNotifySubscribers) {\n                        self._origNotifySubscribers = self[\"notifySubscribers\"];\n                        self[\"notifySubscribers\"] = limitNotifySubscribers;\n                    }\n\n                    var finish = limitFunction(function() {\n                        self._notificationIsPending = false;\n\n                        // If an observable provided a reference to itself, access it to get the latest value.\n                        // This allows computed observables to delay calculating their value until needed.\n                        if (selfIsObservable && pendingValue === self) {\n                            pendingValue = self._evalIfChanged ? self._evalIfChanged() : self();\n                        }\n                        var shouldNotify = notifyNextChange || (didUpdate && self.isDifferent(previousValue, pendingValue));\n\n                        didUpdate = notifyNextChange = ignoreBeforeChange = false;\n\n                        if (shouldNotify) {\n                            self._origNotifySubscribers(previousValue = pendingValue);\n                        }\n                    });\n\n                    self._limitChange = function(value, isDirty) {\n                        if (!isDirty || !self._notificationIsPending) {\n                            didUpdate = !isDirty;\n                        }\n                        self._changeSubscriptions = self._subscriptions[defaultEvent].slice(0);\n                        self._notificationIsPending = ignoreBeforeChange = true;\n                        pendingValue = value;\n                        finish();\n                    };\n                    self._limitBeforeChange = function(value) {\n                        if (!ignoreBeforeChange) {\n                            previousValue = value;\n                            self._origNotifySubscribers(value, beforeChange);\n                        }\n                    };\n                    self._recordUpdate = function() {\n                        didUpdate = true;\n                    };\n                    self._notifyNextChangeIfValueIsDifferent = function() {\n                        if (self.isDifferent(previousValue, self.peek(true /*evaluate*/))) {\n                            notifyNextChange = true;\n                        }\n                    };\n                },\n\n                hasSubscriptionsForEvent: function(event) {\n                    return this._subscriptions[event] && this._subscriptions[event].length;\n                },\n\n                getSubscriptionsCount: function (event) {\n                    if (event) {\n                        return this._subscriptions[event] && this._subscriptions[event].length || 0;\n                    } else {\n                        var total = 0;\n                        ko.utils.objectForEach(this._subscriptions, function(eventName, subscriptions) {\n                            if (eventName !== 'dirty')\n                                total += subscriptions.length;\n                        });\n                        return total;\n                    }\n                },\n\n                isDifferent: function(oldValue, newValue) {\n                    return !this['equalityComparer'] || !this['equalityComparer'](oldValue, newValue);\n                },\n\n                toString: function() {\n                    return '[object Object]'\n                },\n\n                extend: applyExtenders\n            };\n\n            ko.exportProperty(ko_subscribable_fn, 'init', ko_subscribable_fn.init);\n            ko.exportProperty(ko_subscribable_fn, 'subscribe', ko_subscribable_fn.subscribe);\n            ko.exportProperty(ko_subscribable_fn, 'extend', ko_subscribable_fn.extend);\n            ko.exportProperty(ko_subscribable_fn, 'getSubscriptionsCount', ko_subscribable_fn.getSubscriptionsCount);\n\n// For browsers that support proto assignment, we overwrite the prototype of each\n// observable instance. Since observables are functions, we need Function.prototype\n// to still be in the prototype chain.\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(ko_subscribable_fn, Function.prototype);\n            }\n\n            ko.subscribable['fn'] = ko_subscribable_fn;\n\n\n            ko.isSubscribable = function (instance) {\n                return instance != null && typeof instance.subscribe == \"function\" && typeof instance[\"notifySubscribers\"] == \"function\";\n            };\n\n            ko.exportSymbol('subscribable', ko.subscribable);\n            ko.exportSymbol('isSubscribable', ko.isSubscribable);\n\n            ko.computedContext = ko.dependencyDetection = (function () {\n                var outerFrames = [],\n                    currentFrame,\n                    lastId = 0;\n\n                // Return a unique ID that can be assigned to an observable for dependency tracking.\n                // Theoretically, you could eventually overflow the number storage size, resulting\n                // in duplicate IDs. But in JavaScript, the largest exact integral value is 2^53\n                // or 9,007,199,254,740,992. If you created 1,000,000 IDs per second, it would\n                // take over 285 years to reach that number.\n                // Reference http://blog.vjeux.com/2010/javascript/javascript-max_int-number-limits.html\n                function getId() {\n                    return ++lastId;\n                }\n\n                function begin(options) {\n                    outerFrames.push(currentFrame);\n                    currentFrame = options;\n                }\n\n                function end() {\n                    currentFrame = outerFrames.pop();\n                }\n\n                return {\n                    begin: begin,\n\n                    end: end,\n\n                    registerDependency: function (subscribable) {\n                        if (currentFrame) {\n                            if (!ko.isSubscribable(subscribable))\n                                throw new Error(\"Only subscribable things can act as dependencies\");\n                            currentFrame.callback.call(currentFrame.callbackTarget, subscribable, subscribable._id || (subscribable._id = getId()));\n                        }\n                    },\n\n                    ignore: function (callback, callbackTarget, callbackArgs) {\n                        try {\n                            begin();\n                            return callback.apply(callbackTarget, callbackArgs || []);\n                        } finally {\n                            end();\n                        }\n                    },\n\n                    getDependenciesCount: function () {\n                        if (currentFrame)\n                            return currentFrame.computed.getDependenciesCount();\n                    },\n\n                    getDependencies: function () {\n                        if (currentFrame)\n                            return currentFrame.computed.getDependencies();\n                    },\n\n                    isInitial: function() {\n                        if (currentFrame)\n                            return currentFrame.isInitial;\n                    },\n\n                    computed: function() {\n                        if (currentFrame)\n                            return currentFrame.computed;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('computedContext', ko.computedContext);\n            ko.exportSymbol('computedContext.getDependenciesCount', ko.computedContext.getDependenciesCount);\n            ko.exportSymbol('computedContext.getDependencies', ko.computedContext.getDependencies);\n            ko.exportSymbol('computedContext.isInitial', ko.computedContext.isInitial);\n            ko.exportSymbol('computedContext.registerDependency', ko.computedContext.registerDependency);\n\n            ko.exportSymbol('ignoreDependencies', ko.ignoreDependencies = ko.dependencyDetection.ignore);\n            var observableLatestValue = ko.utils.createSymbolOrString('_latestValue');\n\n            ko.observable = function (initialValue) {\n                function observable() {\n                    if (arguments.length > 0) {\n                        // Write\n\n                        // Ignore writes if the value hasn't changed\n                        if (observable.isDifferent(observable[observableLatestValue], arguments[0])) {\n                            observable.valueWillMutate();\n                            observable[observableLatestValue] = arguments[0];\n                            observable.valueHasMutated();\n                        }\n                        return this; // Permits chained assignments\n                    }\n                    else {\n                        // Read\n                        ko.dependencyDetection.registerDependency(observable); // The caller only needs to be notified of changes if they did a \"read\" operation\n                        return observable[observableLatestValue];\n                    }\n                }\n\n                observable[observableLatestValue] = initialValue;\n\n                // Inherit from 'subscribable'\n                if (!ko.utils.canSetPrototype) {\n                    // 'subscribable' won't be on the prototype chain unless we put it there directly\n                    ko.utils.extend(observable, ko.subscribable['fn']);\n                }\n                ko.subscribable['fn'].init(observable);\n\n                // Inherit from 'observable'\n                ko.utils.setPrototypeOfOrExtend(observable, observableFn);\n\n                if (ko.options['deferUpdates']) {\n                    ko.extenders['deferred'](observable, true);\n                }\n\n                return observable;\n            }\n\n// Define prototype for observables\n            var observableFn = {\n                'equalityComparer': valuesArePrimitiveAndEqual,\n                peek: function() { return this[observableLatestValue]; },\n                valueHasMutated: function () {\n                    this['notifySubscribers'](this[observableLatestValue], 'spectate');\n                    this['notifySubscribers'](this[observableLatestValue]);\n                },\n                valueWillMutate: function () { this['notifySubscribers'](this[observableLatestValue], 'beforeChange'); }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observable constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(observableFn, ko.subscribable['fn']);\n            }\n\n            var protoProperty = ko.observable.protoProperty = '__ko_proto__';\n            observableFn[protoProperty] = ko.observable;\n\n            ko.isObservable = function (instance) {\n                var proto = typeof instance == 'function' && instance[protoProperty];\n                if (proto && proto !== observableFn[protoProperty] && proto !== ko.computed['fn'][protoProperty]) {\n                    throw Error(\"Invalid object that looks like an observable; possibly from another Knockout instance\");\n                }\n                return !!proto;\n            };\n\n            ko.isWriteableObservable = function (instance) {\n                return (typeof instance == 'function' && (\n                    (instance[protoProperty] === observableFn[protoProperty]) ||  // Observable\n                    (instance[protoProperty] === ko.computed['fn'][protoProperty] && instance.hasWriteFunction)));   // Writable computed observable\n            };\n\n            ko.exportSymbol('observable', ko.observable);\n            ko.exportSymbol('isObservable', ko.isObservable);\n            ko.exportSymbol('isWriteableObservable', ko.isWriteableObservable);\n            ko.exportSymbol('isWritableObservable', ko.isWriteableObservable);\n            ko.exportSymbol('observable.fn', observableFn);\n            ko.exportProperty(observableFn, 'peek', observableFn.peek);\n            ko.exportProperty(observableFn, 'valueHasMutated', observableFn.valueHasMutated);\n            ko.exportProperty(observableFn, 'valueWillMutate', observableFn.valueWillMutate);\n            ko.observableArray = function (initialValues) {\n                initialValues = initialValues || [];\n\n                if (typeof initialValues != 'object' || !('length' in initialValues))\n                    throw new Error(\"The argument passed when initializing an observable array must be an array, or null, or undefined.\");\n\n                var result = ko.observable(initialValues);\n                ko.utils.setPrototypeOfOrExtend(result, ko.observableArray['fn']);\n                return result.extend({'trackArrayChanges':true});\n            };\n\n            ko.observableArray['fn'] = {\n                'remove': function (valueOrPredicate) {\n                    var underlyingArray = this.peek();\n                    var removedValues = [];\n                    var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n                    for (var i = 0; i < underlyingArray.length; i++) {\n                        var value = underlyingArray[i];\n                        if (predicate(value)) {\n                            if (removedValues.length === 0) {\n                                this.valueWillMutate();\n                            }\n                            if (underlyingArray[i] !== value) {\n                                throw Error(\"Array modified during remove; cannot remove item\");\n                            }\n                            removedValues.push(value);\n                            underlyingArray.splice(i, 1);\n                            i--;\n                        }\n                    }\n                    if (removedValues.length) {\n                        this.valueHasMutated();\n                    }\n                    return removedValues;\n                },\n\n                'removeAll': function (arrayOfValues) {\n                    // If you passed zero args, we remove everything\n                    if (arrayOfValues === undefined) {\n                        var underlyingArray = this.peek();\n                        var allValues = underlyingArray.slice(0);\n                        this.valueWillMutate();\n                        underlyingArray.splice(0, underlyingArray.length);\n                        this.valueHasMutated();\n                        return allValues;\n                    }\n                    // If you passed an arg, we interpret it as an array of entries to remove\n                    if (!arrayOfValues)\n                        return [];\n                    return this['remove'](function (value) {\n                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n                    });\n                },\n\n                'destroy': function (valueOrPredicate) {\n                    var underlyingArray = this.peek();\n                    var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n                    this.valueWillMutate();\n                    for (var i = underlyingArray.length - 1; i >= 0; i--) {\n                        var value = underlyingArray[i];\n                        if (predicate(value))\n                            value[\"_destroy\"] = true;\n                    }\n                    this.valueHasMutated();\n                },\n\n                'destroyAll': function (arrayOfValues) {\n                    // If you passed zero args, we destroy everything\n                    if (arrayOfValues === undefined)\n                        return this['destroy'](function() { return true });\n\n                    // If you passed an arg, we interpret it as an array of entries to destroy\n                    if (!arrayOfValues)\n                        return [];\n                    return this['destroy'](function (value) {\n                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n                    });\n                },\n\n                'indexOf': function (item) {\n                    var underlyingArray = this();\n                    return ko.utils.arrayIndexOf(underlyingArray, item);\n                },\n\n                'replace': function(oldItem, newItem) {\n                    var index = this['indexOf'](oldItem);\n                    if (index >= 0) {\n                        this.valueWillMutate();\n                        this.peek()[index] = newItem;\n                        this.valueHasMutated();\n                    }\n                },\n\n                'sorted': function (compareFunction) {\n                    var arrayCopy = this().slice(0);\n                    return compareFunction ? arrayCopy.sort(compareFunction) : arrayCopy.sort();\n                },\n\n                'reversed': function () {\n                    return this().slice(0).reverse();\n                }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observableArray constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(ko.observableArray['fn'], ko.observable['fn']);\n            }\n\n// Populate ko.observableArray.fn with read/write functions from native arrays\n// Important: Do not add any additional functions here that may reasonably be used to *read* data from the array\n// because we'll eval them without causing subscriptions, so ko.computed output could end up getting stale\n            ko.utils.arrayForEach([\"pop\", \"push\", \"reverse\", \"shift\", \"sort\", \"splice\", \"unshift\"], function (methodName) {\n                ko.observableArray['fn'][methodName] = function () {\n                    // Use \"peek\" to avoid creating a subscription in any computed that we're executing in the context of\n                    // (for consistency with mutating regular observables)\n                    var underlyingArray = this.peek();\n                    this.valueWillMutate();\n                    this.cacheDiffForKnownOperation(underlyingArray, methodName, arguments);\n                    var methodCallResult = underlyingArray[methodName].apply(underlyingArray, arguments);\n                    this.valueHasMutated();\n                    // The native sort and reverse methods return a reference to the array, but it makes more sense to return the observable array instead.\n                    return methodCallResult === underlyingArray ? this : methodCallResult;\n                };\n            });\n\n// Populate ko.observableArray.fn with read-only functions from native arrays\n            ko.utils.arrayForEach([\"slice\"], function (methodName) {\n                ko.observableArray['fn'][methodName] = function () {\n                    var underlyingArray = this();\n                    return underlyingArray[methodName].apply(underlyingArray, arguments);\n                };\n            });\n\n            ko.isObservableArray = function (instance) {\n                return ko.isObservable(instance)\n                    && typeof instance[\"remove\"] == \"function\"\n                    && typeof instance[\"push\"] == \"function\";\n            };\n\n            ko.exportSymbol('observableArray', ko.observableArray);\n            ko.exportSymbol('isObservableArray', ko.isObservableArray);\n            var arrayChangeEventName = 'arrayChange';\n            ko.extenders['trackArrayChanges'] = function(target, options) {\n                // Use the provided options--each call to trackArrayChanges overwrites the previously set options\n                target.compareArrayOptions = {};\n                if (options && typeof options == \"object\") {\n                    ko.utils.extend(target.compareArrayOptions, options);\n                }\n                target.compareArrayOptions['sparse'] = true;\n\n                // Only modify the target observable once\n                if (target.cacheDiffForKnownOperation) {\n                    return;\n                }\n                var trackingChanges = false,\n                    cachedDiff = null,\n                    changeSubscription,\n                    spectateSubscription,\n                    pendingChanges = 0,\n                    previousContents,\n                    underlyingBeforeSubscriptionAddFunction = target.beforeSubscriptionAdd,\n                    underlyingAfterSubscriptionRemoveFunction = target.afterSubscriptionRemove;\n\n                // Watch \"subscribe\" calls, and for array change events, ensure change tracking is enabled\n                target.beforeSubscriptionAdd = function (event) {\n                    if (underlyingBeforeSubscriptionAddFunction) {\n                        underlyingBeforeSubscriptionAddFunction.call(target, event);\n                    }\n                    if (event === arrayChangeEventName) {\n                        trackChanges();\n                    }\n                };\n                // Watch \"dispose\" calls, and for array change events, ensure change tracking is disabled when all are disposed\n                target.afterSubscriptionRemove = function (event) {\n                    if (underlyingAfterSubscriptionRemoveFunction) {\n                        underlyingAfterSubscriptionRemoveFunction.call(target, event);\n                    }\n                    if (event === arrayChangeEventName && !target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                        if (changeSubscription) {\n                            changeSubscription.dispose();\n                        }\n                        if (spectateSubscription) {\n                            spectateSubscription.dispose();\n                        }\n                        spectateSubscription = changeSubscription = null;\n                        trackingChanges = false;\n                        previousContents = undefined;\n                    }\n                };\n\n                function trackChanges() {\n                    if (trackingChanges) {\n                        // Whenever there's a new subscription and there are pending notifications, make sure all previous\n                        // subscriptions are notified of the change so that all subscriptions are in sync.\n                        notifyChanges();\n                        return;\n                    }\n\n                    trackingChanges = true;\n\n                    // Track how many times the array actually changed value\n                    spectateSubscription = target.subscribe(function () {\n                        ++pendingChanges;\n                    }, null, \"spectate\");\n\n                    // Each time the array changes value, capture a clone so that on the next\n                    // change it's possible to produce a diff\n                    previousContents = [].concat(target.peek() || []);\n                    cachedDiff = null;\n                    changeSubscription = target.subscribe(notifyChanges);\n\n                    function notifyChanges() {\n                        if (pendingChanges) {\n                            // Make a copy of the current contents and ensure it's an array\n                            var currentContents = [].concat(target.peek() || []), changes;\n\n                            // Compute the diff and issue notifications, but only if someone is listening\n                            if (target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                                changes = getChanges(previousContents, currentContents);\n                            }\n\n                            // Eliminate references to the old, removed items, so they can be GCed\n                            previousContents = currentContents;\n                            cachedDiff = null;\n                            pendingChanges = 0;\n\n                            if (changes && changes.length) {\n                                target['notifySubscribers'](changes, arrayChangeEventName);\n                            }\n                        }\n                    }\n                }\n\n                function getChanges(previousContents, currentContents) {\n                    // We try to re-use cached diffs.\n                    // The scenarios where pendingChanges > 1 are when using rate limiting or deferred updates,\n                    // which without this check would not be compatible with arrayChange notifications. Normally,\n                    // notifications are issued immediately so we wouldn't be queueing up more than one.\n                    if (!cachedDiff || pendingChanges > 1) {\n                        cachedDiff = ko.utils.compareArrays(previousContents, currentContents, target.compareArrayOptions);\n                    }\n\n                    return cachedDiff;\n                }\n\n                target.cacheDiffForKnownOperation = function(rawArray, operationName, args) {\n                    // Only run if we're currently tracking changes for this observable array\n                    // and there aren't any pending deferred notifications.\n                    if (!trackingChanges || pendingChanges) {\n                        return;\n                    }\n                    var diff = [],\n                        arrayLength = rawArray.length,\n                        argsLength = args.length,\n                        offset = 0;\n\n                    function pushDiff(status, value, index) {\n                        return diff[diff.length] = { 'status': status, 'value': value, 'index': index };\n                    }\n                    switch (operationName) {\n                        case 'push':\n                            offset = arrayLength;\n                        case 'unshift':\n                            for (var index = 0; index < argsLength; index++) {\n                                pushDiff('added', args[index], offset + index);\n                            }\n                            break;\n\n                        case 'pop':\n                            offset = arrayLength - 1;\n                        case 'shift':\n                            if (arrayLength) {\n                                pushDiff('deleted', rawArray[offset], offset);\n                            }\n                            break;\n\n                        case 'splice':\n                            // Negative start index means 'from end of array'. After that we clamp to [0...arrayLength].\n                            // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice\n                            var startIndex = Math.min(Math.max(0, args[0] < 0 ? arrayLength + args[0] : args[0]), arrayLength),\n                                endDeleteIndex = argsLength === 1 ? arrayLength : Math.min(startIndex + (args[1] || 0), arrayLength),\n                                endAddIndex = startIndex + argsLength - 2,\n                                endIndex = Math.max(endDeleteIndex, endAddIndex),\n                                additions = [], deletions = [];\n                            for (var index = startIndex, argsIndex = 2; index < endIndex; ++index, ++argsIndex) {\n                                if (index < endDeleteIndex)\n                                    deletions.push(pushDiff('deleted', rawArray[index], index));\n                                if (index < endAddIndex)\n                                    additions.push(pushDiff('added', args[argsIndex], index));\n                            }\n                            ko.utils.findMovesInArrayComparison(deletions, additions);\n                            break;\n\n                        default:\n                            return;\n                    }\n                    cachedDiff = diff;\n                };\n            };\n            var computedState = ko.utils.createSymbolOrString('_state');\n\n            ko.computed = ko.dependentObservable = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget, options) {\n                if (typeof evaluatorFunctionOrOptions === \"object\") {\n                    // Single-parameter syntax - everything is on this \"options\" param\n                    options = evaluatorFunctionOrOptions;\n                } else {\n                    // Multi-parameter syntax - construct the options according to the params passed\n                    options = options || {};\n                    if (evaluatorFunctionOrOptions) {\n                        options[\"read\"] = evaluatorFunctionOrOptions;\n                    }\n                }\n                if (typeof options[\"read\"] != \"function\")\n                    throw Error(\"Pass a function that returns the value of the ko.computed\");\n\n                var writeFunction = options[\"write\"];\n                var state = {\n                    latestValue: undefined,\n                    isStale: true,\n                    isDirty: true,\n                    isBeingEvaluated: false,\n                    suppressDisposalUntilDisposeWhenReturnsFalse: false,\n                    isDisposed: false,\n                    pure: false,\n                    isSleeping: false,\n                    readFunction: options[\"read\"],\n                    evaluatorFunctionTarget: evaluatorFunctionTarget || options[\"owner\"],\n                    disposeWhenNodeIsRemoved: options[\"disposeWhenNodeIsRemoved\"] || options.disposeWhenNodeIsRemoved || null,\n                    disposeWhen: options[\"disposeWhen\"] || options.disposeWhen,\n                    domNodeDisposalCallback: null,\n                    dependencyTracking: {},\n                    dependenciesCount: 0,\n                    evaluationTimeoutInstance: null\n                };\n\n                function computedObservable() {\n                    if (arguments.length > 0) {\n                        if (typeof writeFunction === \"function\") {\n                            // Writing a value\n                            writeFunction.apply(state.evaluatorFunctionTarget, arguments);\n                        } else {\n                            throw new Error(\"Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.\");\n                        }\n                        return this; // Permits chained assignments\n                    } else {\n                        // Reading the value\n                        if (!state.isDisposed) {\n                            ko.dependencyDetection.registerDependency(computedObservable);\n                        }\n                        if (state.isDirty || (state.isSleeping && computedObservable.haveDependenciesChanged())) {\n                            computedObservable.evaluateImmediate();\n                        }\n                        return state.latestValue;\n                    }\n                }\n\n                computedObservable[computedState] = state;\n                computedObservable.hasWriteFunction = typeof writeFunction === \"function\";\n\n                // Inherit from 'subscribable'\n                if (!ko.utils.canSetPrototype) {\n                    // 'subscribable' won't be on the prototype chain unless we put it there directly\n                    ko.utils.extend(computedObservable, ko.subscribable['fn']);\n                }\n                ko.subscribable['fn'].init(computedObservable);\n\n                // Inherit from 'computed'\n                ko.utils.setPrototypeOfOrExtend(computedObservable, computedFn);\n\n                if (options['pure']) {\n                    state.pure = true;\n                    state.isSleeping = true;     // Starts off sleeping; will awake on the first subscription\n                    ko.utils.extend(computedObservable, pureComputedOverrides);\n                } else if (options['deferEvaluation']) {\n                    ko.utils.extend(computedObservable, deferEvaluationOverrides);\n                }\n\n                if (ko.options['deferUpdates']) {\n                    ko.extenders['deferred'](computedObservable, true);\n                }\n\n                if (DEBUG) {\n                    // #1731 - Aid debugging by exposing the computed's options\n                    computedObservable[\"_options\"] = options;\n                }\n\n                if (state.disposeWhenNodeIsRemoved) {\n                    // Since this computed is associated with a DOM node, and we don't want to dispose the computed\n                    // until the DOM node is *removed* from the document (as opposed to never having been in the document),\n                    // we'll prevent disposal until \"disposeWhen\" first returns false.\n                    state.suppressDisposalUntilDisposeWhenReturnsFalse = true;\n\n                    // disposeWhenNodeIsRemoved: true can be used to opt into the \"only dispose after first false result\"\n                    // behaviour even if there's no specific node to watch. In that case, clear the option so we don't try\n                    // to watch for a non-node's disposal. This technique is intended for KO's internal use only and shouldn't\n                    // be documented or used by application code, as it's likely to change in a future version of KO.\n                    if (!state.disposeWhenNodeIsRemoved.nodeType) {\n                        state.disposeWhenNodeIsRemoved = null;\n                    }\n                }\n\n                // Evaluate, unless sleeping or deferEvaluation is true\n                if (!state.isSleeping && !options['deferEvaluation']) {\n                    computedObservable.evaluateImmediate();\n                }\n\n                // Attach a DOM node disposal callback so that the computed will be proactively disposed as soon as the node is\n                // removed using ko.removeNode. But skip if isActive is false (there will never be any dependencies to dispose).\n                if (state.disposeWhenNodeIsRemoved && computedObservable.isActive()) {\n                    ko.utils.domNodeDisposal.addDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback = function () {\n                        computedObservable.dispose();\n                    });\n                }\n\n                return computedObservable;\n            };\n\n// Utility function that disposes a given dependencyTracking entry\n            function computedDisposeDependencyCallback(id, entryToDispose) {\n                if (entryToDispose !== null && entryToDispose.dispose) {\n                    entryToDispose.dispose();\n                }\n            }\n\n// This function gets called each time a dependency is detected while evaluating a computed.\n// It's factored out as a shared function to avoid creating unnecessary function instances during evaluation.\n            function computedBeginDependencyDetectionCallback(subscribable, id) {\n                var computedObservable = this.computedObservable,\n                    state = computedObservable[computedState];\n                if (!state.isDisposed) {\n                    if (this.disposalCount && this.disposalCandidates[id]) {\n                        // Don't want to dispose this subscription, as it's still being used\n                        computedObservable.addDependencyTracking(id, subscribable, this.disposalCandidates[id]);\n                        this.disposalCandidates[id] = null; // No need to actually delete the property - disposalCandidates is a transient object anyway\n                        --this.disposalCount;\n                    } else if (!state.dependencyTracking[id]) {\n                        // Brand new subscription - add it\n                        computedObservable.addDependencyTracking(id, subscribable, state.isSleeping ? { _target: subscribable } : computedObservable.subscribeToDependency(subscribable));\n                    }\n                    // If the observable we've accessed has a pending notification, ensure we get notified of the actual final value (bypass equality checks)\n                    if (subscribable._notificationIsPending) {\n                        subscribable._notifyNextChangeIfValueIsDifferent();\n                    }\n                }\n            }\n\n            var computedFn = {\n                \"equalityComparer\": valuesArePrimitiveAndEqual,\n                getDependenciesCount: function () {\n                    return this[computedState].dependenciesCount;\n                },\n                getDependencies: function () {\n                    var dependencyTracking = this[computedState].dependencyTracking, dependentObservables = [];\n\n                    ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                        dependentObservables[dependency._order] = dependency._target;\n                    });\n\n                    return dependentObservables;\n                },\n                hasAncestorDependency: function (obs) {\n                    if (!this[computedState].dependenciesCount) {\n                        return false;\n                    }\n                    var dependencies = this.getDependencies();\n                    if (ko.utils.arrayIndexOf(dependencies, obs) !== -1) {\n                        return true;\n                    }\n                    return !!ko.utils.arrayFirst(dependencies, function (dep) {\n                        return dep.hasAncestorDependency && dep.hasAncestorDependency(obs);\n                    });\n                },\n                addDependencyTracking: function (id, target, trackingObj) {\n                    if (this[computedState].pure && target === this) {\n                        throw Error(\"A 'pure' computed must not be called recursively\");\n                    }\n\n                    this[computedState].dependencyTracking[id] = trackingObj;\n                    trackingObj._order = this[computedState].dependenciesCount++;\n                    trackingObj._version = target.getVersion();\n                },\n                haveDependenciesChanged: function () {\n                    var id, dependency, dependencyTracking = this[computedState].dependencyTracking;\n                    for (id in dependencyTracking) {\n                        if (Object.prototype.hasOwnProperty.call(dependencyTracking, id)) {\n                            dependency = dependencyTracking[id];\n                            if ((this._evalDelayed && dependency._target._notificationIsPending) || dependency._target.hasChanged(dependency._version)) {\n                                return true;\n                            }\n                        }\n                    }\n                },\n                markDirty: function () {\n                    // Process \"dirty\" events if we can handle delayed notifications\n                    if (this._evalDelayed && !this[computedState].isBeingEvaluated) {\n                        this._evalDelayed(false /*isChange*/);\n                    }\n                },\n                isActive: function () {\n                    var state = this[computedState];\n                    return state.isDirty || state.dependenciesCount > 0;\n                },\n                respondToChange: function () {\n                    // Ignore \"change\" events if we've already scheduled a delayed notification\n                    if (!this._notificationIsPending) {\n                        this.evaluatePossiblyAsync();\n                    } else if (this[computedState].isDirty) {\n                        this[computedState].isStale = true;\n                    }\n                },\n                subscribeToDependency: function (target) {\n                    if (target._deferUpdates) {\n                        var dirtySub = target.subscribe(this.markDirty, this, 'dirty'),\n                            changeSub = target.subscribe(this.respondToChange, this);\n                        return {\n                            _target: target,\n                            dispose: function () {\n                                dirtySub.dispose();\n                                changeSub.dispose();\n                            }\n                        };\n                    } else {\n                        return target.subscribe(this.evaluatePossiblyAsync, this);\n                    }\n                },\n                evaluatePossiblyAsync: function () {\n                    var computedObservable = this,\n                        throttleEvaluationTimeout = computedObservable['throttleEvaluation'];\n                    if (throttleEvaluationTimeout && throttleEvaluationTimeout >= 0) {\n                        clearTimeout(this[computedState].evaluationTimeoutInstance);\n                        this[computedState].evaluationTimeoutInstance = ko.utils.setTimeout(function () {\n                            computedObservable.evaluateImmediate(true /*notifyChange*/);\n                        }, throttleEvaluationTimeout);\n                    } else if (computedObservable._evalDelayed) {\n                        computedObservable._evalDelayed(true /*isChange*/);\n                    } else {\n                        computedObservable.evaluateImmediate(true /*notifyChange*/);\n                    }\n                },\n                evaluateImmediate: function (notifyChange) {\n                    var computedObservable = this,\n                        state = computedObservable[computedState],\n                        disposeWhen = state.disposeWhen,\n                        changed = false;\n\n                    if (state.isBeingEvaluated) {\n                        // If the evaluation of a ko.computed causes side effects, it's possible that it will trigger its own re-evaluation.\n                        // This is not desirable (it's hard for a developer to realise a chain of dependencies might cause this, and they almost\n                        // certainly didn't intend infinite re-evaluations). So, for predictability, we simply prevent ko.computeds from causing\n                        // their own re-evaluation. Further discussion at https://github.com/SteveSanderson/knockout/pull/387\n                        return;\n                    }\n\n                    // Do not evaluate (and possibly capture new dependencies) if disposed\n                    if (state.isDisposed) {\n                        return;\n                    }\n\n                    if (state.disposeWhenNodeIsRemoved && !ko.utils.domNodeIsAttachedToDocument(state.disposeWhenNodeIsRemoved) || disposeWhen && disposeWhen()) {\n                        // See comment above about suppressDisposalUntilDisposeWhenReturnsFalse\n                        if (!state.suppressDisposalUntilDisposeWhenReturnsFalse) {\n                            computedObservable.dispose();\n                            return;\n                        }\n                    } else {\n                        // It just did return false, so we can stop suppressing now\n                        state.suppressDisposalUntilDisposeWhenReturnsFalse = false;\n                    }\n\n                    state.isBeingEvaluated = true;\n                    try {\n                        changed = this.evaluateImmediate_CallReadWithDependencyDetection(notifyChange);\n                    } finally {\n                        state.isBeingEvaluated = false;\n                    }\n\n                    return changed;\n                },\n                evaluateImmediate_CallReadWithDependencyDetection: function (notifyChange) {\n                    // This function is really just part of the evaluateImmediate logic. You would never call it from anywhere else.\n                    // Factoring it out into a separate function means it can be independent of the try/catch block in evaluateImmediate,\n                    // which contributes to saving about 40% off the CPU overhead of computed evaluation (on V8 at least).\n\n                    var computedObservable = this,\n                        state = computedObservable[computedState],\n                        changed = false;\n\n                    // Initially, we assume that none of the subscriptions are still being used (i.e., all are candidates for disposal).\n                    // Then, during evaluation, we cross off any that are in fact still being used.\n                    var isInitial = state.pure ? undefined : !state.dependenciesCount,   // If we're evaluating when there are no previous dependencies, it must be the first time\n                        dependencyDetectionContext = {\n                            computedObservable: computedObservable,\n                            disposalCandidates: state.dependencyTracking,\n                            disposalCount: state.dependenciesCount\n                        };\n\n                    ko.dependencyDetection.begin({\n                        callbackTarget: dependencyDetectionContext,\n                        callback: computedBeginDependencyDetectionCallback,\n                        computed: computedObservable,\n                        isInitial: isInitial\n                    });\n\n                    state.dependencyTracking = {};\n                    state.dependenciesCount = 0;\n\n                    var newValue = this.evaluateImmediate_CallReadThenEndDependencyDetection(state, dependencyDetectionContext);\n\n                    if (!state.dependenciesCount) {\n                        computedObservable.dispose();\n                        changed = true; // When evaluation causes a disposal, make sure all dependent computeds get notified so they'll see the new state\n                    } else {\n                        changed = computedObservable.isDifferent(state.latestValue, newValue);\n                    }\n\n                    if (changed) {\n                        if (!state.isSleeping) {\n                            computedObservable[\"notifySubscribers\"](state.latestValue, \"beforeChange\");\n                        } else {\n                            computedObservable.updateVersion();\n                        }\n\n                        state.latestValue = newValue;\n                        if (DEBUG) computedObservable._latestValue = newValue;\n\n                        computedObservable[\"notifySubscribers\"](state.latestValue, \"spectate\");\n\n                        if (!state.isSleeping && notifyChange) {\n                            computedObservable[\"notifySubscribers\"](state.latestValue);\n                        }\n                        if (computedObservable._recordUpdate) {\n                            computedObservable._recordUpdate();\n                        }\n                    }\n\n                    if (isInitial) {\n                        computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n                    }\n\n                    return changed;\n                },\n                evaluateImmediate_CallReadThenEndDependencyDetection: function (state, dependencyDetectionContext) {\n                    // This function is really part of the evaluateImmediate_CallReadWithDependencyDetection logic.\n                    // You'd never call it from anywhere else. Factoring it out means that evaluateImmediate_CallReadWithDependencyDetection\n                    // can be independent of try/finally blocks, which contributes to saving about 40% off the CPU\n                    // overhead of computed evaluation (on V8 at least).\n\n                    try {\n                        var readFunction = state.readFunction;\n                        return state.evaluatorFunctionTarget ? readFunction.call(state.evaluatorFunctionTarget) : readFunction();\n                    } finally {\n                        ko.dependencyDetection.end();\n\n                        // For each subscription no longer being used, remove it from the active subscriptions list and dispose it\n                        if (dependencyDetectionContext.disposalCount && !state.isSleeping) {\n                            ko.utils.objectForEach(dependencyDetectionContext.disposalCandidates, computedDisposeDependencyCallback);\n                        }\n\n                        state.isStale = state.isDirty = false;\n                    }\n                },\n                peek: function (evaluate) {\n                    // By default, peek won't re-evaluate, except while the computed is sleeping or to get the initial value when \"deferEvaluation\" is set.\n                    // Pass in true to evaluate if needed.\n                    var state = this[computedState];\n                    if ((state.isDirty && (evaluate || !state.dependenciesCount)) || (state.isSleeping && this.haveDependenciesChanged())) {\n                        this.evaluateImmediate();\n                    }\n                    return state.latestValue;\n                },\n                limit: function (limitFunction) {\n                    // Override the limit function with one that delays evaluation as well\n                    ko.subscribable['fn'].limit.call(this, limitFunction);\n                    this._evalIfChanged = function () {\n                        if (!this[computedState].isSleeping) {\n                            if (this[computedState].isStale) {\n                                this.evaluateImmediate();\n                            } else {\n                                this[computedState].isDirty = false;\n                            }\n                        }\n                        return this[computedState].latestValue;\n                    };\n                    this._evalDelayed = function (isChange) {\n                        this._limitBeforeChange(this[computedState].latestValue);\n\n                        // Mark as dirty\n                        this[computedState].isDirty = true;\n                        if (isChange) {\n                            this[computedState].isStale = true;\n                        }\n\n                        // Pass the observable to the \"limit\" code, which will evaluate it when\n                        // it's time to do the notification.\n                        this._limitChange(this, !isChange /* isDirty */);\n                    };\n                },\n                dispose: function () {\n                    var state = this[computedState];\n                    if (!state.isSleeping && state.dependencyTracking) {\n                        ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                            if (dependency.dispose)\n                                dependency.dispose();\n                        });\n                    }\n                    if (state.disposeWhenNodeIsRemoved && state.domNodeDisposalCallback) {\n                        ko.utils.domNodeDisposal.removeDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback);\n                    }\n                    state.dependencyTracking = undefined;\n                    state.dependenciesCount = 0;\n                    state.isDisposed = true;\n                    state.isStale = false;\n                    state.isDirty = false;\n                    state.isSleeping = false;\n                    state.disposeWhenNodeIsRemoved = undefined;\n                    state.disposeWhen = undefined;\n                    state.readFunction = undefined;\n                    if (!this.hasWriteFunction) {\n                        state.evaluatorFunctionTarget = undefined;\n                    }\n                }\n            };\n\n            var pureComputedOverrides = {\n                beforeSubscriptionAdd: function (event) {\n                    // If asleep, wake up the computed by subscribing to any dependencies.\n                    var computedObservable = this,\n                        state = computedObservable[computedState];\n                    if (!state.isDisposed && state.isSleeping && event == 'change') {\n                        state.isSleeping = false;\n                        if (state.isStale || computedObservable.haveDependenciesChanged()) {\n                            state.dependencyTracking = null;\n                            state.dependenciesCount = 0;\n                            if (computedObservable.evaluateImmediate()) {\n                                computedObservable.updateVersion();\n                            }\n                        } else {\n                            // First put the dependencies in order\n                            var dependenciesOrder = [];\n                            ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                                dependenciesOrder[dependency._order] = id;\n                            });\n                            // Next, subscribe to each one\n                            ko.utils.arrayForEach(dependenciesOrder, function (id, order) {\n                                var dependency = state.dependencyTracking[id],\n                                    subscription = computedObservable.subscribeToDependency(dependency._target);\n                                subscription._order = order;\n                                subscription._version = dependency._version;\n                                state.dependencyTracking[id] = subscription;\n                            });\n                            // Waking dependencies may have triggered effects\n                            if (computedObservable.haveDependenciesChanged()) {\n                                if (computedObservable.evaluateImmediate()) {\n                                    computedObservable.updateVersion();\n                                }\n                            }\n                        }\n\n                        if (!state.isDisposed) {     // test since evaluating could trigger disposal\n                            computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n                        }\n                    }\n                },\n                afterSubscriptionRemove: function (event) {\n                    var state = this[computedState];\n                    if (!state.isDisposed && event == 'change' && !this.hasSubscriptionsForEvent('change')) {\n                        ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                            if (dependency.dispose) {\n                                state.dependencyTracking[id] = {\n                                    _target: dependency._target,\n                                    _order: dependency._order,\n                                    _version: dependency._version\n                                };\n                                dependency.dispose();\n                            }\n                        });\n                        state.isSleeping = true;\n                        this[\"notifySubscribers\"](undefined, \"asleep\");\n                    }\n                },\n                getVersion: function () {\n                    // Because a pure computed is not automatically updated while it is sleeping, we can't\n                    // simply return the version number. Instead, we check if any of the dependencies have\n                    // changed and conditionally re-evaluate the computed observable.\n                    var state = this[computedState];\n                    if (state.isSleeping && (state.isStale || this.haveDependenciesChanged())) {\n                        this.evaluateImmediate();\n                    }\n                    return ko.subscribable['fn'].getVersion.call(this);\n                }\n            };\n\n            var deferEvaluationOverrides = {\n                beforeSubscriptionAdd: function (event) {\n                    // This will force a computed with deferEvaluation to evaluate when the first subscription is registered.\n                    if (event == 'change' || event == 'beforeChange') {\n                        this.peek();\n                    }\n                }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.computed constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(computedFn, ko.subscribable['fn']);\n            }\n\n// Set the proto values for ko.computed\n            var protoProp = ko.observable.protoProperty; // == \"__ko_proto__\"\n            computedFn[protoProp] = ko.computed;\n\n            ko.isComputed = function (instance) {\n                return (typeof instance == 'function' && instance[protoProp] === computedFn[protoProp]);\n            };\n\n            ko.isPureComputed = function (instance) {\n                return ko.isComputed(instance) && instance[computedState] && instance[computedState].pure;\n            };\n\n            ko.exportSymbol('computed', ko.computed);\n            ko.exportSymbol('dependentObservable', ko.computed);    // export ko.dependentObservable for backwards compatibility (1.x)\n            ko.exportSymbol('isComputed', ko.isComputed);\n            ko.exportSymbol('isPureComputed', ko.isPureComputed);\n            ko.exportSymbol('computed.fn', computedFn);\n            ko.exportProperty(computedFn, 'peek', computedFn.peek);\n            ko.exportProperty(computedFn, 'dispose', computedFn.dispose);\n            ko.exportProperty(computedFn, 'isActive', computedFn.isActive);\n            ko.exportProperty(computedFn, 'getDependenciesCount', computedFn.getDependenciesCount);\n            ko.exportProperty(computedFn, 'getDependencies', computedFn.getDependencies);\n\n            ko.pureComputed = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget) {\n                if (typeof evaluatorFunctionOrOptions === 'function') {\n                    return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget, {'pure':true});\n                } else {\n                    evaluatorFunctionOrOptions = ko.utils.extend({}, evaluatorFunctionOrOptions);   // make a copy of the parameter object\n                    evaluatorFunctionOrOptions['pure'] = true;\n                    return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget);\n                }\n            }\n            ko.exportSymbol('pureComputed', ko.pureComputed);\n\n            (function() {\n                var maxNestedObservableDepth = 10; // Escape the (unlikely) pathological case where an observable's current value is itself (or similar reference cycle)\n\n                ko.toJS = function(rootObject) {\n                    if (arguments.length == 0)\n                        throw new Error(\"When calling ko.toJS, pass the object you want to convert.\");\n\n                    // We just unwrap everything at every level in the object graph\n                    return mapJsObjectGraph(rootObject, function(valueToMap) {\n                        // Loop because an observable's value might in turn be another observable wrapper\n                        for (var i = 0; ko.isObservable(valueToMap) && (i < maxNestedObservableDepth); i++)\n                            valueToMap = valueToMap();\n                        return valueToMap;\n                    });\n                };\n\n                ko.toJSON = function(rootObject, replacer, space) {     // replacer and space are optional\n                    var plainJavaScriptObject = ko.toJS(rootObject);\n                    return ko.utils.stringifyJson(plainJavaScriptObject, replacer, space);\n                };\n\n                function mapJsObjectGraph(rootObject, mapInputCallback, visitedObjects) {\n                    visitedObjects = visitedObjects || new objectLookup();\n\n                    rootObject = mapInputCallback(rootObject);\n                    var canHaveProperties = (typeof rootObject == \"object\") && (rootObject !== null) && (rootObject !== undefined) && (!(rootObject instanceof RegExp)) && (!(rootObject instanceof Date)) && (!(rootObject instanceof String)) && (!(rootObject instanceof Number)) && (!(rootObject instanceof Boolean));\n                    if (!canHaveProperties)\n                        return rootObject;\n\n                    var outputProperties = rootObject instanceof Array ? [] : {};\n                    visitedObjects.save(rootObject, outputProperties);\n\n                    visitPropertiesOrArrayEntries(rootObject, function(indexer) {\n                        var propertyValue = mapInputCallback(rootObject[indexer]);\n\n                        switch (typeof propertyValue) {\n                            case \"boolean\":\n                            case \"number\":\n                            case \"string\":\n                            case \"function\":\n                                outputProperties[indexer] = propertyValue;\n                                break;\n                            case \"object\":\n                            case \"undefined\":\n                                var previouslyMappedValue = visitedObjects.get(propertyValue);\n                                outputProperties[indexer] = (previouslyMappedValue !== undefined)\n                                    ? previouslyMappedValue\n                                    : mapJsObjectGraph(propertyValue, mapInputCallback, visitedObjects);\n                                break;\n                        }\n                    });\n\n                    return outputProperties;\n                }\n\n                function visitPropertiesOrArrayEntries(rootObject, visitorCallback) {\n                    if (rootObject instanceof Array) {\n                        for (var i = 0; i < rootObject.length; i++)\n                            visitorCallback(i);\n\n                        // For arrays, also respect toJSON property for custom mappings (fixes #278)\n                        if (typeof rootObject['toJSON'] == 'function')\n                            visitorCallback('toJSON');\n                    } else {\n                        for (var propertyName in rootObject) {\n                            visitorCallback(propertyName);\n                        }\n                    }\n                };\n\n                function objectLookup() {\n                    this.keys = [];\n                    this.values = [];\n                };\n\n                objectLookup.prototype = {\n                    constructor: objectLookup,\n                    save: function(key, value) {\n                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n                        if (existingIndex >= 0)\n                            this.values[existingIndex] = value;\n                        else {\n                            this.keys.push(key);\n                            this.values.push(value);\n                        }\n                    },\n                    get: function(key) {\n                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n                        return (existingIndex >= 0) ? this.values[existingIndex] : undefined;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('toJS', ko.toJS);\n            ko.exportSymbol('toJSON', ko.toJSON);\n            ko.when = function(predicate, callback, context) {\n                function kowhen (resolve) {\n                    var observable = ko.pureComputed(predicate, context).extend({notify:'always'});\n                    var subscription = observable.subscribe(function(value) {\n                        if (value) {\n                            subscription.dispose();\n                            resolve(value);\n                        }\n                    });\n                    // In case the initial value is true, process it right away\n                    observable['notifySubscribers'](observable.peek());\n\n                    return subscription;\n                }\n                if (typeof Promise === \"function\" && !callback) {\n                    return new Promise(kowhen);\n                } else {\n                    return kowhen(callback.bind(context));\n                }\n            };\n\n            ko.exportSymbol('when', ko.when);\n            (function () {\n                var hasDomDataExpandoProperty = '__ko__hasDomDataOptionValue__';\n\n                // Normally, SELECT elements and their OPTIONs can only take value of type 'string' (because the values\n                // are stored on DOM attributes). ko.selectExtensions provides a way for SELECTs/OPTIONs to have values\n                // that are arbitrary objects. This is very convenient when implementing things like cascading dropdowns.\n                ko.selectExtensions = {\n                    readValue : function(element) {\n                        switch (ko.utils.tagNameLower(element)) {\n                            case 'option':\n                                if (element[hasDomDataExpandoProperty] === true)\n                                    return ko.utils.domData.get(element, ko.bindingHandlers.options.optionValueDomDataKey);\n                                return ko.utils.ieVersion <= 7\n                                    ? (element.getAttributeNode('value') && element.getAttributeNode('value').specified ? element.value : element.text)\n                                    : element.value;\n                            case 'select':\n                                return element.selectedIndex >= 0 ? ko.selectExtensions.readValue(element.options[element.selectedIndex]) : undefined;\n                            default:\n                                return element.value;\n                        }\n                    },\n\n                    writeValue: function(element, value, allowUnset) {\n                        switch (ko.utils.tagNameLower(element)) {\n                            case 'option':\n                                if (typeof value === \"string\") {\n                                    ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, undefined);\n                                    if (hasDomDataExpandoProperty in element) { // IE <= 8 throws errors if you delete non-existent properties from a DOM node\n                                        delete element[hasDomDataExpandoProperty];\n                                    }\n                                    element.value = value;\n                                }\n                                else {\n                                    // Store arbitrary object using DomData\n                                    ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, value);\n                                    element[hasDomDataExpandoProperty] = true;\n\n                                    // Special treatment of numbers is just for backward compatibility. KO 1.2.1 wrote numerical values to element.value.\n                                    element.value = typeof value === \"number\" ? value : \"\";\n                                }\n                                break;\n                            case 'select':\n                                if (value === \"\" || value === null)       // A blank string or null value will select the caption\n                                    value = undefined;\n                                var selection = -1;\n                                for (var i = 0, n = element.options.length, optionValue; i < n; ++i) {\n                                    optionValue = ko.selectExtensions.readValue(element.options[i]);\n                                    // Include special check to handle selecting a caption with a blank string value\n                                    if (optionValue == value || (optionValue === \"\" && value === undefined)) {\n                                        selection = i;\n                                        break;\n                                    }\n                                }\n                                if (allowUnset || selection >= 0 || (value === undefined && element.size > 1)) {\n                                    element.selectedIndex = selection;\n                                    if (ko.utils.ieVersion === 6) {\n                                        // Workaround for IE6 bug: It won't reliably apply values to SELECT nodes during the same execution thread\n                                        // right after you've changed the set of OPTION nodes on it. So for that node type, we'll schedule a second thread\n                                        // to apply the value as well.\n                                        ko.utils.setTimeout(function () {\n                                            element.selectedIndex = selection;\n                                        }, 0);\n                                    }\n                                }\n                                break;\n                            default:\n                                if ((value === null) || (value === undefined))\n                                    value = \"\";\n                                element.value = value;\n                                break;\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('selectExtensions', ko.selectExtensions);\n            ko.exportSymbol('selectExtensions.readValue', ko.selectExtensions.readValue);\n            ko.exportSymbol('selectExtensions.writeValue', ko.selectExtensions.writeValue);\n            ko.expressionRewriting = (function () {\n                var javaScriptReservedWords = [\"true\", \"false\", \"null\", \"undefined\"];\n\n                // Matches something that can be assigned to--either an isolated identifier or something ending with a property accessor\n                // This is designed to be simple and avoid false negatives, but could produce false positives (e.g., a+b.c).\n                // This also will not properly handle nested brackets (e.g., obj1[obj2['prop']]; see #911).\n                var javaScriptAssignmentTarget = /^(?:[$_a-z][$\\w]*|(.+)(\\.\\s*[$_a-z][$\\w]*|\\[.+\\]))$/i;\n\n                function getWriteableValue(expression) {\n                    if (ko.utils.arrayIndexOf(javaScriptReservedWords, expression) >= 0)\n                        return false;\n                    var match = expression.match(javaScriptAssignmentTarget);\n                    return match === null ? false : match[1] ? ('Object(' + match[1] + ')' + match[2]) : expression;\n                }\n\n                // The following regular expressions will be used to split an object-literal string into tokens\n\n                var specials = ',\"\\'`{}()/:[\\\\]',    // These characters have special meaning to the parser and must not appear in the middle of a token, except as part of a string.\n                    // Create the actual regular expression by or-ing the following regex strings. The order is important.\n                    bindingToken = RegExp([\n                        // These match strings, either with double quotes, single quotes, or backticks\n                        '\"(?:\\\\\\\\.|[^\"])*\"',\n                        \"'(?:\\\\\\\\.|[^'])*'\",\n                        \"`(?:\\\\\\\\.|[^`])*`\",\n                        // Match C style comments\n                        \"/\\\\*(?:[^*]|\\\\*+[^*/])*\\\\*+/\",\n                        // Match C++ style comments\n                        \"//.*\\n\",\n                        // Match a regular expression (text enclosed by slashes), but will also match sets of divisions\n                        // as a regular expression (this is handled by the parsing loop below).\n                        '/(?:\\\\\\\\.|[^/])+/\\w*',\n                        // Match text (at least two characters) that does not contain any of the above special characters,\n                        // although some of the special characters are allowed to start it (all but the colon and comma).\n                        // The text can contain spaces, but leading or trailing spaces are skipped.\n                        '[^\\\\s:,/][^' + specials + ']*[^\\\\s' + specials + ']',\n                        // Match any non-space character not matched already. This will match colons and commas, since they're\n                        // not matched by \"everyThingElse\", but will also match any other single character that wasn't already\n                        // matched (for example: in \"a: 1, b: 2\", each of the non-space characters will be matched by oneNotSpace).\n                        '[^\\\\s]'\n                    ].join('|'), 'g'),\n\n                    // Match end of previous token to determine whether a slash is a division or regex.\n                    divisionLookBehind = /[\\])\"'A-Za-z0-9_$]+$/,\n                    keywordRegexLookBehind = {'in':1,'return':1,'typeof':1};\n\n                function parseObjectLiteral(objectLiteralString) {\n                    // Trim leading and trailing spaces from the string\n                    var str = ko.utils.stringTrim(objectLiteralString);\n\n                    // Trim braces '{' surrounding the whole object literal\n                    if (str.charCodeAt(0) === 123) str = str.slice(1, -1);\n\n                    // Add a newline to correctly match a C++ style comment at the end of the string and\n                    // add a comma so that we don't need a separate code block to deal with the last item\n                    str += \"\\n,\";\n\n                    // Split into tokens\n                    var result = [], toks = str.match(bindingToken), key, values = [], depth = 0;\n\n                    if (toks.length > 1) {\n                        for (var i = 0, tok; tok = toks[i]; ++i) {\n                            var c = tok.charCodeAt(0);\n                            // A comma signals the end of a key/value pair if depth is zero\n                            if (c === 44) { // \",\"\n                                if (depth <= 0) {\n                                    result.push((key && values.length) ? {key: key, value: values.join('')} : {'unknown': key || values.join('')});\n                                    key = depth = 0;\n                                    values = [];\n                                    continue;\n                                }\n                                // Simply skip the colon that separates the name and value\n                            } else if (c === 58) { // \":\"\n                                if (!depth && !key && values.length === 1) {\n                                    key = values.pop();\n                                    continue;\n                                }\n                                // Comments: skip them\n                            } else if (c === 47 && tok.length > 1 && (tok.charCodeAt(1) === 47 || tok.charCodeAt(1) === 42)) {  // \"//\" or \"/*\"\n                                continue;\n                                // A set of slashes is initially matched as a regular expression, but could be division\n                            } else if (c === 47 && i && tok.length > 1) {  // \"/\"\n                                // Look at the end of the previous token to determine if the slash is actually division\n                                var match = toks[i-1].match(divisionLookBehind);\n                                if (match && !keywordRegexLookBehind[match[0]]) {\n                                    // The slash is actually a division punctuator; re-parse the remainder of the string (not including the slash)\n                                    str = str.substr(str.indexOf(tok) + 1);\n                                    toks = str.match(bindingToken);\n                                    i = -1;\n                                    // Continue with just the slash\n                                    tok = '/';\n                                }\n                                // Increment depth for parentheses, braces, and brackets so that interior commas are ignored\n                            } else if (c === 40 || c === 123 || c === 91) { // '(', '{', '['\n                                ++depth;\n                            } else if (c === 41 || c === 125 || c === 93) { // ')', '}', ']'\n                                --depth;\n                                // The key will be the first token; if it's a string, trim the quotes\n                            } else if (!key && !values.length && (c === 34 || c === 39)) { // '\"', \"'\"\n                                tok = tok.slice(1, -1);\n                            }\n                            values.push(tok);\n                        }\n                        if (depth > 0) {\n                            throw Error(\"Unbalanced parentheses, braces, or brackets\");\n                        }\n                    }\n                    return result;\n                }\n\n                // Two-way bindings include a write function that allow the handler to update the value even if it's not an observable.\n                var twoWayBindings = {};\n\n                function preProcessBindings(bindingsStringOrKeyValueArray, bindingOptions) {\n                    bindingOptions = bindingOptions || {};\n\n                    function processKeyValue(key, val) {\n                        var writableVal;\n                        function callPreprocessHook(obj) {\n                            return (obj && obj['preprocess']) ? (val = obj['preprocess'](val, key, processKeyValue)) : true;\n                        }\n                        if (!bindingParams) {\n                            if (!callPreprocessHook(ko['getBindingHandler'](key)))\n                                return;\n\n                            if (twoWayBindings[key] && (writableVal = getWriteableValue(val))) {\n                                // For two-way bindings, provide a write method in case the value\n                                // isn't a writable observable.\n                                var writeKey = typeof twoWayBindings[key] == 'string' ? twoWayBindings[key] : key;\n                                propertyAccessorResultStrings.push(\"'\" + writeKey + \"':function(_z){\" + writableVal + \"=_z}\");\n                            }\n                        }\n                        // Values are wrapped in a function so that each value can be accessed independently\n                        if (makeValueAccessors) {\n                            val = 'function(){return ' + val + ' }';\n                        }\n                        resultStrings.push(\"'\" + key + \"':\" + val);\n                    }\n\n                    var resultStrings = [],\n                        propertyAccessorResultStrings = [],\n                        makeValueAccessors = bindingOptions['valueAccessors'],\n                        bindingParams = bindingOptions['bindingParams'],\n                        keyValueArray = typeof bindingsStringOrKeyValueArray === \"string\" ?\n                            parseObjectLiteral(bindingsStringOrKeyValueArray) : bindingsStringOrKeyValueArray;\n\n                    ko.utils.arrayForEach(keyValueArray, function(keyValue) {\n                        processKeyValue(keyValue.key || keyValue['unknown'], keyValue.value);\n                    });\n\n                    if (propertyAccessorResultStrings.length)\n                        processKeyValue('_ko_property_writers', \"{\" + propertyAccessorResultStrings.join(\",\") + \" }\");\n\n                    return resultStrings.join(\",\");\n                }\n\n                return {\n                    bindingRewriteValidators: [],\n\n                    twoWayBindings: twoWayBindings,\n\n                    parseObjectLiteral: parseObjectLiteral,\n\n                    preProcessBindings: preProcessBindings,\n\n                    keyValueArrayContainsKey: function(keyValueArray, key) {\n                        for (var i = 0; i < keyValueArray.length; i++)\n                            if (keyValueArray[i]['key'] == key)\n                                return true;\n                        return false;\n                    },\n\n                    // Internal, private KO utility for updating model properties from within bindings\n                    // property:            If the property being updated is (or might be) an observable, pass it here\n                    //                      If it turns out to be a writable observable, it will be written to directly\n                    // allBindings:         An object with a get method to retrieve bindings in the current execution context.\n                    //                      This will be searched for a '_ko_property_writers' property in case you're writing to a non-observable\n                    // key:                 The key identifying the property to be written. Example: for { hasFocus: myValue }, write to 'myValue' by specifying the key 'hasFocus'\n                    // value:               The value to be written\n                    // checkIfDifferent:    If true, and if the property being written is a writable observable, the value will only be written if\n                    //                      it is !== existing value on that writable observable\n                    writeValueToProperty: function(property, allBindings, key, value, checkIfDifferent) {\n                        if (!property || !ko.isObservable(property)) {\n                            var propWriters = allBindings.get('_ko_property_writers');\n                            if (propWriters && propWriters[key])\n                                propWriters[key](value);\n                        } else if (ko.isWriteableObservable(property) && (!checkIfDifferent || property.peek() !== value)) {\n                            property(value);\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('expressionRewriting', ko.expressionRewriting);\n            ko.exportSymbol('expressionRewriting.bindingRewriteValidators', ko.expressionRewriting.bindingRewriteValidators);\n            ko.exportSymbol('expressionRewriting.parseObjectLiteral', ko.expressionRewriting.parseObjectLiteral);\n            ko.exportSymbol('expressionRewriting.preProcessBindings', ko.expressionRewriting.preProcessBindings);\n\n// Making bindings explicitly declare themselves as \"two way\" isn't ideal in the long term (it would be better if\n// all bindings could use an official 'property writer' API without needing to declare that they might). However,\n// since this is not, and has never been, a public API (_ko_property_writers was never documented), it's acceptable\n// as an internal implementation detail in the short term.\n// For those developers who rely on _ko_property_writers in their custom bindings, we expose _twoWayBindings as an\n// undocumented feature that makes it relatively easy to upgrade to KO 3.0. However, this is still not an official\n// public API, and we reserve the right to remove it at any time if we create a real public property writers API.\n            ko.exportSymbol('expressionRewriting._twoWayBindings', ko.expressionRewriting.twoWayBindings);\n\n// For backward compatibility, define the following aliases. (Previously, these function names were misleading because\n// they referred to JSON specifically, even though they actually work with arbitrary JavaScript object literal expressions.)\n            ko.exportSymbol('jsonExpressionRewriting', ko.expressionRewriting);\n            ko.exportSymbol('jsonExpressionRewriting.insertPropertyAccessorsIntoJson', ko.expressionRewriting.preProcessBindings);\n            (function() {\n                // \"Virtual elements\" is an abstraction on top of the usual DOM API which understands the notion that comment nodes\n                // may be used to represent hierarchy (in addition to the DOM's natural hierarchy).\n                // If you call the DOM-manipulating functions on ko.virtualElements, you will be able to read and write the state\n                // of that virtual hierarchy\n                //\n                // The point of all this is to support containerless templates (e.g., <!-- ko foreach:someCollection -->blah<!-- /ko -->)\n                // without having to scatter special cases all over the binding and templating code.\n\n                // IE 9 cannot reliably read the \"nodeValue\" property of a comment node (see https://github.com/SteveSanderson/knockout/issues/186)\n                // but it does give them a nonstandard alternative property called \"text\" that it can read reliably. Other browsers don't have that property.\n                // So, use node.text where available, and node.nodeValue elsewhere\n                var commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\n\n                var startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\n                var endCommentRegex =   commentNodesHaveTextProperty ? /^<!--\\s*\\/ko\\s*-->$/ : /^\\s*\\/ko\\s*$/;\n                var htmlTagsWithOptionallyClosingChildren = { 'ul': true, 'ol': true };\n\n                function isStartComment(node) {\n                    return (node.nodeType == 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n                }\n\n                function isEndComment(node) {\n                    return (node.nodeType == 8) && endCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n                }\n\n                function isUnmatchedEndComment(node) {\n                    return isEndComment(node) && !(ko.utils.domData.get(node, matchedEndCommentDataKey));\n                }\n\n                var matchedEndCommentDataKey = \"__ko_matchedEndComment__\"\n\n                function getVirtualChildren(startComment, allowUnbalanced) {\n                    var currentNode = startComment;\n                    var depth = 1;\n                    var children = [];\n                    while (currentNode = currentNode.nextSibling) {\n                        if (isEndComment(currentNode)) {\n                            ko.utils.domData.set(currentNode, matchedEndCommentDataKey, true);\n                            depth--;\n                            if (depth === 0)\n                                return children;\n                        }\n\n                        children.push(currentNode);\n\n                        if (isStartComment(currentNode))\n                            depth++;\n                    }\n                    if (!allowUnbalanced)\n                        throw new Error(\"Cannot find closing comment tag to match: \" + startComment.nodeValue);\n                    return null;\n                }\n\n                function getMatchingEndComment(startComment, allowUnbalanced) {\n                    var allVirtualChildren = getVirtualChildren(startComment, allowUnbalanced);\n                    if (allVirtualChildren) {\n                        if (allVirtualChildren.length > 0)\n                            return allVirtualChildren[allVirtualChildren.length - 1].nextSibling;\n                        return startComment.nextSibling;\n                    } else\n                        return null; // Must have no matching end comment, and allowUnbalanced is true\n                }\n\n                function getUnbalancedChildTags(node) {\n                    // e.g., from <div>OK</div><!-- ko blah --><span>Another</span>, returns: <!-- ko blah --><span>Another</span>\n                    //       from <div>OK</div><!-- /ko --><!-- /ko -->,             returns: <!-- /ko --><!-- /ko -->\n                    var childNode = node.firstChild, captureRemaining = null;\n                    if (childNode) {\n                        do {\n                            if (captureRemaining)                   // We already hit an unbalanced node and are now just scooping up all subsequent nodes\n                                captureRemaining.push(childNode);\n                            else if (isStartComment(childNode)) {\n                                var matchingEndComment = getMatchingEndComment(childNode, /* allowUnbalanced: */ true);\n                                if (matchingEndComment)             // It's a balanced tag, so skip immediately to the end of this virtual set\n                                    childNode = matchingEndComment;\n                                else\n                                    captureRemaining = [childNode]; // It's unbalanced, so start capturing from this point\n                            } else if (isEndComment(childNode)) {\n                                captureRemaining = [childNode];     // It's unbalanced (if it wasn't, we'd have skipped over it already), so start capturing\n                            }\n                        } while (childNode = childNode.nextSibling);\n                    }\n                    return captureRemaining;\n                }\n\n                ko.virtualElements = {\n                    allowedBindings: {},\n\n                    childNodes: function(node) {\n                        return isStartComment(node) ? getVirtualChildren(node) : node.childNodes;\n                    },\n\n                    emptyNode: function(node) {\n                        if (!isStartComment(node))\n                            ko.utils.emptyDomNode(node);\n                        else {\n                            var virtualChildren = ko.virtualElements.childNodes(node);\n                            for (var i = 0, j = virtualChildren.length; i < j; i++)\n                                ko.removeNode(virtualChildren[i]);\n                        }\n                    },\n\n                    setDomNodeChildren: function(node, childNodes) {\n                        if (!isStartComment(node))\n                            ko.utils.setDomNodeChildren(node, childNodes);\n                        else {\n                            ko.virtualElements.emptyNode(node);\n                            var endCommentNode = node.nextSibling; // Must be the next sibling, as we just emptied the children\n                            for (var i = 0, j = childNodes.length; i < j; i++)\n                                endCommentNode.parentNode.insertBefore(childNodes[i], endCommentNode);\n                        }\n                    },\n\n                    prepend: function(containerNode, nodeToPrepend) {\n                        var insertBeforeNode;\n\n                        if (isStartComment(containerNode)) {\n                            // Start comments must always have a parent and at least one following sibling (the end comment)\n                            insertBeforeNode = containerNode.nextSibling;\n                            containerNode = containerNode.parentNode;\n                        } else {\n                            insertBeforeNode = containerNode.firstChild;\n                        }\n\n                        if (!insertBeforeNode) {\n                            containerNode.appendChild(nodeToPrepend);\n                        } else if (nodeToPrepend !== insertBeforeNode) {       // IE will sometimes crash if you try to insert a node before itself\n                            containerNode.insertBefore(nodeToPrepend, insertBeforeNode);\n                        }\n                    },\n\n                    insertAfter: function(containerNode, nodeToInsert, insertAfterNode) {\n                        if (!insertAfterNode) {\n                            ko.virtualElements.prepend(containerNode, nodeToInsert);\n                        } else {\n                            // Children of start comments must always have a parent and at least one following sibling (the end comment)\n                            var insertBeforeNode = insertAfterNode.nextSibling;\n\n                            if (isStartComment(containerNode)) {\n                                containerNode = containerNode.parentNode;\n                            }\n\n                            if (!insertBeforeNode) {\n                                containerNode.appendChild(nodeToInsert);\n                            } else if (nodeToInsert !== insertBeforeNode) {       // IE will sometimes crash if you try to insert a node before itself\n                                containerNode.insertBefore(nodeToInsert, insertBeforeNode);\n                            }\n                        }\n                    },\n\n                    firstChild: function(node) {\n                        if (!isStartComment(node)) {\n                            if (node.firstChild && isEndComment(node.firstChild)) {\n                                throw new Error(\"Found invalid end comment, as the first child of \" + node);\n                            }\n                            return node.firstChild;\n                        } else if (!node.nextSibling || isEndComment(node.nextSibling)) {\n                            return null;\n                        } else {\n                            return node.nextSibling;\n                        }\n                    },\n\n                    nextSibling: function(node) {\n                        if (isStartComment(node)) {\n                            node = getMatchingEndComment(node);\n                        }\n\n                        if (node.nextSibling && isEndComment(node.nextSibling)) {\n                            if (isUnmatchedEndComment(node.nextSibling)) {\n                                throw Error(\"Found end comment without a matching opening comment, as child of \" + node);\n                            } else {\n                                return null;\n                            }\n                        } else {\n                            return node.nextSibling;\n                        }\n                    },\n\n                    hasBindingValue: isStartComment,\n\n                    virtualNodeBindingValue: function(node) {\n                        var regexMatch = (commentNodesHaveTextProperty ? node.text : node.nodeValue).match(startCommentRegex);\n                        return regexMatch ? regexMatch[1] : null;\n                    },\n\n                    normaliseVirtualElementDomStructure: function(elementVerified) {\n                        // Workaround for https://github.com/SteveSanderson/knockout/issues/155\n                        // (IE <= 8 or IE 9 quirks mode parses your HTML weirdly, treating closing </li> tags as if they don't exist, thereby moving comment nodes\n                        // that are direct descendants of <ul> into the preceding <li>)\n                        if (!htmlTagsWithOptionallyClosingChildren[ko.utils.tagNameLower(elementVerified)])\n                            return;\n\n                        // Scan immediate children to see if they contain unbalanced comment tags. If they do, those comment tags\n                        // must be intended to appear *after* that child, so move them there.\n                        var childNode = elementVerified.firstChild;\n                        if (childNode) {\n                            do {\n                                if (childNode.nodeType === 1) {\n                                    var unbalancedTags = getUnbalancedChildTags(childNode);\n                                    if (unbalancedTags) {\n                                        // Fix up the DOM by moving the unbalanced tags to where they most likely were intended to be placed - *after* the child\n                                        var nodeToInsertBefore = childNode.nextSibling;\n                                        for (var i = 0; i < unbalancedTags.length; i++) {\n                                            if (nodeToInsertBefore)\n                                                elementVerified.insertBefore(unbalancedTags[i], nodeToInsertBefore);\n                                            else\n                                                elementVerified.appendChild(unbalancedTags[i]);\n                                        }\n                                    }\n                                }\n                            } while (childNode = childNode.nextSibling);\n                        }\n                    }\n                };\n            })();\n            ko.exportSymbol('virtualElements', ko.virtualElements);\n            ko.exportSymbol('virtualElements.allowedBindings', ko.virtualElements.allowedBindings);\n            ko.exportSymbol('virtualElements.emptyNode', ko.virtualElements.emptyNode);\n//ko.exportSymbol('virtualElements.firstChild', ko.virtualElements.firstChild);     // firstChild is not minified\n            ko.exportSymbol('virtualElements.insertAfter', ko.virtualElements.insertAfter);\n//ko.exportSymbol('virtualElements.nextSibling', ko.virtualElements.nextSibling);   // nextSibling is not minified\n            ko.exportSymbol('virtualElements.prepend', ko.virtualElements.prepend);\n            ko.exportSymbol('virtualElements.setDomNodeChildren', ko.virtualElements.setDomNodeChildren);\n            (function() {\n                var defaultBindingAttributeName = \"data-bind\";\n\n                ko.bindingProvider = function() {\n                    this.bindingCache = {};\n                };\n\n                ko.utils.extend(ko.bindingProvider.prototype, {\n                    'nodeHasBindings': function(node) {\n                        switch (node.nodeType) {\n                            case 1: // Element\n                                return node.getAttribute(defaultBindingAttributeName) != null\n                                    || ko.components['getComponentNameForNode'](node);\n                            case 8: // Comment node\n                                return ko.virtualElements.hasBindingValue(node);\n                            default: return false;\n                        }\n                    },\n\n                    'getBindings': function(node, bindingContext) {\n                        var bindingsString = this['getBindingsString'](node, bindingContext),\n                            parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node) : null;\n                        return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ false);\n                    },\n\n                    'getBindingAccessors': function(node, bindingContext) {\n                        var bindingsString = this['getBindingsString'](node, bindingContext),\n                            parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node, { 'valueAccessors': true }) : null;\n                        return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ true);\n                    },\n\n                    // The following function is only used internally by this default provider.\n                    // It's not part of the interface definition for a general binding provider.\n                    'getBindingsString': function(node, bindingContext) {\n                        switch (node.nodeType) {\n                            case 1: return node.getAttribute(defaultBindingAttributeName);   // Element\n                            case 8: return ko.virtualElements.virtualNodeBindingValue(node); // Comment node\n                            default: return null;\n                        }\n                    },\n\n                    // The following function is only used internally by this default provider.\n                    // It's not part of the interface definition for a general binding provider.\n                    'parseBindingsString': function(bindingsString, bindingContext, node, options) {\n                        try {\n                            var bindingFunction = createBindingsStringEvaluatorViaCache(bindingsString, this.bindingCache, options);\n                            return bindingFunction(bindingContext, node);\n                        } catch (ex) {\n                            ex.message = \"Unable to parse bindings.\\nBindings value: \" + bindingsString + \"\\nMessage: \" + ex.message;\n                            throw ex;\n                        }\n                    }\n                });\n\n                ko.bindingProvider['instance'] = new ko.bindingProvider();\n\n                function createBindingsStringEvaluatorViaCache(bindingsString, cache, options) {\n                    var cacheKey = bindingsString + (options && options['valueAccessors'] || '');\n                    return cache[cacheKey]\n                        || (cache[cacheKey] = createBindingsStringEvaluator(bindingsString, options));\n                }\n\n                function createBindingsStringEvaluator(bindingsString, options) {\n                    // Build the source for a function that evaluates \"expression\"\n                    // For each scope variable, add an extra level of \"with\" nesting\n                    // Example result: with(sc1) { with(sc0) { return (expression) } }\n                    var rewrittenBindings = ko.expressionRewriting.preProcessBindings(bindingsString, options),\n                        functionBody = \"with($context){with($data||{}){return{\" + rewrittenBindings + \"}}}\";\n                    return new Function(\"$context\", \"$element\", functionBody);\n                }\n            })();\n\n            ko.exportSymbol('bindingProvider', ko.bindingProvider);\n            (function () {\n                // Hide or don't minify context properties, see https://github.com/knockout/knockout/issues/2294\n                var contextSubscribable = ko.utils.createSymbolOrString('_subscribable');\n                var contextAncestorBindingInfo = ko.utils.createSymbolOrString('_ancestorBindingInfo');\n                var contextDataDependency = ko.utils.createSymbolOrString('_dataDependency');\n\n                ko.bindingHandlers = {};\n\n                // The following element types will not be recursed into during binding.\n                var bindingDoesNotRecurseIntoElementTypes = {\n                    // Don't want bindings that operate on text nodes to mutate <script> and <textarea> contents,\n                    // because it's unexpected and a potential XSS issue.\n                    // Also bindings should not operate on <template> elements since this breaks in Internet Explorer\n                    // and because such elements' contents are always intended to be bound in a different context\n                    // from where they appear in the document.\n                    'script': true,\n                    'textarea': true,\n                    'template': true\n                };\n\n                // Use an overridable method for retrieving binding handlers so that plugins may support dynamically created handlers\n                ko['getBindingHandler'] = function(bindingKey) {\n                    return ko.bindingHandlers[bindingKey];\n                };\n\n                var inheritParentVm = {};\n\n                // The ko.bindingContext constructor is only called directly to create the root context. For child\n                // contexts, use bindingContext.createChildContext or bindingContext.extend.\n                ko.bindingContext = function(dataItemOrAccessor, parentContext, dataItemAlias, extendCallback, options) {\n\n                    // The binding context object includes static properties for the current, parent, and root view models.\n                    // If a view model is actually stored in an observable, the corresponding binding context object, and\n                    // any child contexts, must be updated when the view model is changed.\n                    function updateContext() {\n                        // Most of the time, the context will directly get a view model object, but if a function is given,\n                        // we call the function to retrieve the view model. If the function accesses any observables or returns\n                        // an observable, the dependency is tracked, and those observables can later cause the binding\n                        // context to be updated.\n                        var dataItemOrObservable = isFunc ? realDataItemOrAccessor() : realDataItemOrAccessor,\n                            dataItem = ko.utils.unwrapObservable(dataItemOrObservable);\n\n                        if (parentContext) {\n                            // Copy $root and any custom properties from the parent context\n                            ko.utils.extend(self, parentContext);\n\n                            // Copy Symbol properties\n                            if (contextAncestorBindingInfo in parentContext) {\n                                self[contextAncestorBindingInfo] = parentContext[contextAncestorBindingInfo];\n                            }\n                        } else {\n                            self['$parents'] = [];\n                            self['$root'] = dataItem;\n\n                            // Export 'ko' in the binding context so it will be available in bindings and templates\n                            // even if 'ko' isn't exported as a global, such as when using an AMD loader.\n                            // See https://github.com/SteveSanderson/knockout/issues/490\n                            self['ko'] = ko;\n                        }\n\n                        self[contextSubscribable] = subscribable;\n\n                        if (shouldInheritData) {\n                            dataItem = self['$data'];\n                        } else {\n                            self['$rawData'] = dataItemOrObservable;\n                            self['$data'] = dataItem;\n                        }\n\n                        if (dataItemAlias)\n                            self[dataItemAlias] = dataItem;\n\n                        // The extendCallback function is provided when creating a child context or extending a context.\n                        // It handles the specific actions needed to finish setting up the binding context. Actions in this\n                        // function could also add dependencies to this binding context.\n                        if (extendCallback)\n                            extendCallback(self, parentContext, dataItem);\n\n                        // When a \"parent\" context is given and we don't already have a dependency on its context, register a dependency on it.\n                        // Thus whenever the parent context is updated, this context will also be updated.\n                        if (parentContext && parentContext[contextSubscribable] && !ko.computedContext.computed().hasAncestorDependency(parentContext[contextSubscribable])) {\n                            parentContext[contextSubscribable]();\n                        }\n\n                        if (dataDependency) {\n                            self[contextDataDependency] = dataDependency;\n                        }\n\n                        return self['$data'];\n                    }\n\n                    var self = this,\n                        shouldInheritData = dataItemOrAccessor === inheritParentVm,\n                        realDataItemOrAccessor = shouldInheritData ? undefined : dataItemOrAccessor,\n                        isFunc = typeof(realDataItemOrAccessor) == \"function\" && !ko.isObservable(realDataItemOrAccessor),\n                        nodes,\n                        subscribable,\n                        dataDependency = options && options['dataDependency'];\n\n                    if (options && options['exportDependencies']) {\n                        // The \"exportDependencies\" option means that the calling code will track any dependencies and re-create\n                        // the binding context when they change.\n                        updateContext();\n                    } else {\n                        subscribable = ko.pureComputed(updateContext);\n                        subscribable.peek();\n\n                        // At this point, the binding context has been initialized, and the \"subscribable\" computed observable is\n                        // subscribed to any observables that were accessed in the process. If there is nothing to track, the\n                        // computed will be inactive, and we can safely throw it away. If it's active, the computed is stored in\n                        // the context object.\n                        if (subscribable.isActive()) {\n                            // Always notify because even if the model ($data) hasn't changed, other context properties might have changed\n                            subscribable['equalityComparer'] = null;\n                        } else {\n                            self[contextSubscribable] = undefined;\n                        }\n                    }\n                }\n\n                // Extend the binding context hierarchy with a new view model object. If the parent context is watching\n                // any observables, the new child context will automatically get a dependency on the parent context.\n                // But this does not mean that the $data value of the child context will also get updated. If the child\n                // view model also depends on the parent view model, you must provide a function that returns the correct\n                // view model on each update.\n                ko.bindingContext.prototype['createChildContext'] = function (dataItemOrAccessor, dataItemAlias, extendCallback, options) {\n                    if (!options && dataItemAlias && typeof dataItemAlias == \"object\") {\n                        options = dataItemAlias;\n                        dataItemAlias = options['as'];\n                        extendCallback = options['extend'];\n                    }\n\n                    if (dataItemAlias && options && options['noChildContext']) {\n                        var isFunc = typeof(dataItemOrAccessor) == \"function\" && !ko.isObservable(dataItemOrAccessor);\n                        return new ko.bindingContext(inheritParentVm, this, null, function (self) {\n                            if (extendCallback)\n                                extendCallback(self);\n                            self[dataItemAlias] = isFunc ? dataItemOrAccessor() : dataItemOrAccessor;\n                        }, options);\n                    }\n\n                    return new ko.bindingContext(dataItemOrAccessor, this, dataItemAlias, function (self, parentContext) {\n                        // Extend the context hierarchy by setting the appropriate pointers\n                        self['$parentContext'] = parentContext;\n                        self['$parent'] = parentContext['$data'];\n                        self['$parents'] = (parentContext['$parents'] || []).slice(0);\n                        self['$parents'].unshift(self['$parent']);\n                        if (extendCallback)\n                            extendCallback(self);\n                    }, options);\n                };\n\n                // Extend the binding context with new custom properties. This doesn't change the context hierarchy.\n                // Similarly to \"child\" contexts, provide a function here to make sure that the correct values are set\n                // when an observable view model is updated.\n                ko.bindingContext.prototype['extend'] = function(properties, options) {\n                    return new ko.bindingContext(inheritParentVm, this, null, function(self, parentContext) {\n                        ko.utils.extend(self, typeof(properties) == \"function\" ? properties(self) : properties);\n                    }, options);\n                };\n\n                var boundElementDomDataKey = ko.utils.domData.nextKey();\n\n                function asyncContextDispose(node) {\n                    var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey),\n                        asyncContext = bindingInfo && bindingInfo.asyncContext;\n                    if (asyncContext) {\n                        bindingInfo.asyncContext = null;\n                        asyncContext.notifyAncestor();\n                    }\n                }\n                function AsyncCompleteContext(node, bindingInfo, ancestorBindingInfo) {\n                    this.node = node;\n                    this.bindingInfo = bindingInfo;\n                    this.asyncDescendants = [];\n                    this.childrenComplete = false;\n\n                    if (!bindingInfo.asyncContext) {\n                        ko.utils.domNodeDisposal.addDisposeCallback(node, asyncContextDispose);\n                    }\n\n                    if (ancestorBindingInfo && ancestorBindingInfo.asyncContext) {\n                        ancestorBindingInfo.asyncContext.asyncDescendants.push(node);\n                        this.ancestorBindingInfo = ancestorBindingInfo;\n                    }\n                }\n                AsyncCompleteContext.prototype.notifyAncestor = function () {\n                    if (this.ancestorBindingInfo && this.ancestorBindingInfo.asyncContext) {\n                        this.ancestorBindingInfo.asyncContext.descendantComplete(this.node);\n                    }\n                };\n                AsyncCompleteContext.prototype.descendantComplete = function (node) {\n                    ko.utils.arrayRemoveItem(this.asyncDescendants, node);\n                    if (!this.asyncDescendants.length && this.childrenComplete) {\n                        this.completeChildren();\n                    }\n                };\n                AsyncCompleteContext.prototype.completeChildren = function () {\n                    this.childrenComplete = true;\n                    if (this.bindingInfo.asyncContext && !this.asyncDescendants.length) {\n                        this.bindingInfo.asyncContext = null;\n                        ko.utils.domNodeDisposal.removeDisposeCallback(this.node, asyncContextDispose);\n                        ko.bindingEvent.notify(this.node, ko.bindingEvent.descendantsComplete);\n                        this.notifyAncestor();\n                    }\n                };\n\n                ko.bindingEvent = {\n                    childrenComplete: \"childrenComplete\",\n                    descendantsComplete : \"descendantsComplete\",\n\n                    subscribe: function (node, event, callback, context, options) {\n                        var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n                        if (!bindingInfo.eventSubscribable) {\n                            bindingInfo.eventSubscribable = new ko.subscribable;\n                        }\n                        if (options && options['notifyImmediately'] && bindingInfo.notifiedEvents[event]) {\n                            ko.dependencyDetection.ignore(callback, context, [node]);\n                        }\n                        return bindingInfo.eventSubscribable.subscribe(callback, context, event);\n                    },\n\n                    notify: function (node, event) {\n                        var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey);\n                        if (bindingInfo) {\n                            bindingInfo.notifiedEvents[event] = true;\n                            if (bindingInfo.eventSubscribable) {\n                                bindingInfo.eventSubscribable['notifySubscribers'](node, event);\n                            }\n                            if (event == ko.bindingEvent.childrenComplete) {\n                                if (bindingInfo.asyncContext) {\n                                    bindingInfo.asyncContext.completeChildren();\n                                } else if (bindingInfo.asyncContext === undefined && bindingInfo.eventSubscribable && bindingInfo.eventSubscribable.hasSubscriptionsForEvent(ko.bindingEvent.descendantsComplete)) {\n                                    // It's currently an error to register a descendantsComplete handler for a node that was never registered as completing asynchronously.\n                                    // That's because without the asyncContext, we don't have a way to know that all descendants have completed.\n                                    throw new Error(\"descendantsComplete event not supported for bindings on this node\");\n                                }\n                            }\n                        }\n                    },\n\n                    startPossiblyAsyncContentBinding: function (node, bindingContext) {\n                        var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n\n                        if (!bindingInfo.asyncContext) {\n                            bindingInfo.asyncContext = new AsyncCompleteContext(node, bindingInfo, bindingContext[contextAncestorBindingInfo]);\n                        }\n\n                        // If the provided context was already extended with this node's binding info, just return the extended context\n                        if (bindingContext[contextAncestorBindingInfo] == bindingInfo) {\n                            return bindingContext;\n                        }\n\n                        return bindingContext['extend'](function (ctx) {\n                            ctx[contextAncestorBindingInfo] = bindingInfo;\n                        });\n                    }\n                };\n\n                // Returns the valueAccessor function for a binding value\n                function makeValueAccessor(value) {\n                    return function() {\n                        return value;\n                    };\n                }\n\n                // Returns the value of a valueAccessor function\n                function evaluateValueAccessor(valueAccessor) {\n                    return valueAccessor();\n                }\n\n                // Given a function that returns bindings, create and return a new object that contains\n                // binding value-accessors functions. Each accessor function calls the original function\n                // so that it always gets the latest value and all dependencies are captured. This is used\n                // by ko.applyBindingsToNode and getBindingsAndMakeAccessors.\n                function makeAccessorsFromFunction(callback) {\n                    return ko.utils.objectMap(ko.dependencyDetection.ignore(callback), function(value, key) {\n                        return function() {\n                            return callback()[key];\n                        };\n                    });\n                }\n\n                // Given a bindings function or object, create and return a new object that contains\n                // binding value-accessors functions. This is used by ko.applyBindingsToNode.\n                function makeBindingAccessors(bindings, context, node) {\n                    if (typeof bindings === 'function') {\n                        return makeAccessorsFromFunction(bindings.bind(null, context, node));\n                    } else {\n                        return ko.utils.objectMap(bindings, makeValueAccessor);\n                    }\n                }\n\n                // This function is used if the binding provider doesn't include a getBindingAccessors function.\n                // It must be called with 'this' set to the provider instance.\n                function getBindingsAndMakeAccessors(node, context) {\n                    return makeAccessorsFromFunction(this['getBindings'].bind(this, node, context));\n                }\n\n                function validateThatBindingIsAllowedForVirtualElements(bindingName) {\n                    var validator = ko.virtualElements.allowedBindings[bindingName];\n                    if (!validator)\n                        throw new Error(\"The binding '\" + bindingName + \"' cannot be used with virtual elements\")\n                }\n\n                function applyBindingsToDescendantsInternal(bindingContext, elementOrVirtualElement) {\n                    var nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n\n                    if (nextInQueue) {\n                        var currentChild,\n                            provider = ko.bindingProvider['instance'],\n                            preprocessNode = provider['preprocessNode'];\n\n                        // Preprocessing allows a binding provider to mutate a node before bindings are applied to it. For example it's\n                        // possible to insert new siblings after it, and/or replace the node with a different one. This can be used to\n                        // implement custom binding syntaxes, such as {{ value }} for string interpolation, or custom element types that\n                        // trigger insertion of <template> contents at that point in the document.\n                        if (preprocessNode) {\n                            while (currentChild = nextInQueue) {\n                                nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                                preprocessNode.call(provider, currentChild);\n                            }\n                            // Reset nextInQueue for the next loop\n                            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n                        }\n\n                        while (currentChild = nextInQueue) {\n                            // Keep a record of the next child *before* applying bindings, in case the binding removes the current child from its position\n                            nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                            applyBindingsToNodeAndDescendantsInternal(bindingContext, currentChild);\n                        }\n                    }\n                    ko.bindingEvent.notify(elementOrVirtualElement, ko.bindingEvent.childrenComplete);\n                }\n\n                function applyBindingsToNodeAndDescendantsInternal(bindingContext, nodeVerified) {\n                    var bindingContextForDescendants = bindingContext;\n\n                    var isElement = (nodeVerified.nodeType === 1);\n                    if (isElement) // Workaround IE <= 8 HTML parsing weirdness\n                        ko.virtualElements.normaliseVirtualElementDomStructure(nodeVerified);\n\n                    // Perf optimisation: Apply bindings only if...\n                    // (1) We need to store the binding info for the node (all element nodes)\n                    // (2) It might have bindings (e.g., it has a data-bind attribute, or it's a marker for a containerless template)\n                    var shouldApplyBindings = isElement || ko.bindingProvider['instance']['nodeHasBindings'](nodeVerified);\n                    if (shouldApplyBindings)\n                        bindingContextForDescendants = applyBindingsToNodeInternal(nodeVerified, null, bindingContext)['bindingContextForDescendants'];\n\n                    if (bindingContextForDescendants && !bindingDoesNotRecurseIntoElementTypes[ko.utils.tagNameLower(nodeVerified)]) {\n                        applyBindingsToDescendantsInternal(bindingContextForDescendants, nodeVerified);\n                    }\n                }\n\n                function topologicalSortBindings(bindings) {\n                    // Depth-first sort\n                    var result = [],                // The list of key/handler pairs that we will return\n                        bindingsConsidered = {},    // A temporary record of which bindings are already in 'result'\n                        cyclicDependencyStack = []; // Keeps track of a depth-search so that, if there's a cycle, we know which bindings caused it\n                    ko.utils.objectForEach(bindings, function pushBinding(bindingKey) {\n                        if (!bindingsConsidered[bindingKey]) {\n                            var binding = ko['getBindingHandler'](bindingKey);\n                            if (binding) {\n                                // First add dependencies (if any) of the current binding\n                                if (binding['after']) {\n                                    cyclicDependencyStack.push(bindingKey);\n                                    ko.utils.arrayForEach(binding['after'], function(bindingDependencyKey) {\n                                        if (bindings[bindingDependencyKey]) {\n                                            if (ko.utils.arrayIndexOf(cyclicDependencyStack, bindingDependencyKey) !== -1) {\n                                                throw Error(\"Cannot combine the following bindings, because they have a cyclic dependency: \" + cyclicDependencyStack.join(\", \"));\n                                            } else {\n                                                pushBinding(bindingDependencyKey);\n                                            }\n                                        }\n                                    });\n                                    cyclicDependencyStack.length--;\n                                }\n                                // Next add the current binding\n                                result.push({ key: bindingKey, handler: binding });\n                            }\n                            bindingsConsidered[bindingKey] = true;\n                        }\n                    });\n\n                    return result;\n                }\n\n                function applyBindingsToNodeInternal(node, sourceBindings, bindingContext) {\n                    var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n\n                    // Prevent multiple applyBindings calls for the same node, except when a binding value is specified\n                    var alreadyBound = bindingInfo.alreadyBound;\n                    if (!sourceBindings) {\n                        if (alreadyBound) {\n                            throw Error(\"You cannot apply bindings multiple times to the same element.\");\n                        }\n                        bindingInfo.alreadyBound = true;\n                    }\n                    if (!alreadyBound) {\n                        bindingInfo.context = bindingContext;\n                    }\n                    if (!bindingInfo.notifiedEvents) {\n                        bindingInfo.notifiedEvents = {};\n                    }\n\n                    // Use bindings if given, otherwise fall back on asking the bindings provider to give us some bindings\n                    var bindings;\n                    if (sourceBindings && typeof sourceBindings !== 'function') {\n                        bindings = sourceBindings;\n                    } else {\n                        var provider = ko.bindingProvider['instance'],\n                            getBindings = provider['getBindingAccessors'] || getBindingsAndMakeAccessors;\n\n                        // Get the binding from the provider within a computed observable so that we can update the bindings whenever\n                        // the binding context is updated or if the binding provider accesses observables.\n                        var bindingsUpdater = ko.dependentObservable(\n                            function() {\n                                bindings = sourceBindings ? sourceBindings(bindingContext, node) : getBindings.call(provider, node, bindingContext);\n                                // Register a dependency on the binding context to support observable view models.\n                                if (bindings) {\n                                    if (bindingContext[contextSubscribable]) {\n                                        bindingContext[contextSubscribable]();\n                                    }\n                                    if (bindingContext[contextDataDependency]) {\n                                        bindingContext[contextDataDependency]();\n                                    }\n                                }\n                                return bindings;\n                            },\n                            null, { disposeWhenNodeIsRemoved: node }\n                        );\n\n                        if (!bindings || !bindingsUpdater.isActive())\n                            bindingsUpdater = null;\n                    }\n\n                    var contextToExtend = bindingContext;\n                    var bindingHandlerThatControlsDescendantBindings;\n                    if (bindings) {\n                        // Return the value accessor for a given binding. When bindings are static (won't be updated because of a binding\n                        // context update), just return the value accessor from the binding. Otherwise, return a function that always gets\n                        // the latest binding value and registers a dependency on the binding updater.\n                        var getValueAccessor = bindingsUpdater\n                            ? function(bindingKey) {\n                                return function() {\n                                    return evaluateValueAccessor(bindingsUpdater()[bindingKey]);\n                                };\n                            } : function(bindingKey) {\n                                return bindings[bindingKey];\n                            };\n\n                        // Use of allBindings as a function is maintained for backwards compatibility, but its use is deprecated\n                        function allBindings() {\n                            return ko.utils.objectMap(bindingsUpdater ? bindingsUpdater() : bindings, evaluateValueAccessor);\n                        }\n                        // The following is the 3.x allBindings API\n                        allBindings['get'] = function(key) {\n                            return bindings[key] && evaluateValueAccessor(getValueAccessor(key));\n                        };\n                        allBindings['has'] = function(key) {\n                            return key in bindings;\n                        };\n\n                        if (ko.bindingEvent.childrenComplete in bindings) {\n                            ko.bindingEvent.subscribe(node, ko.bindingEvent.childrenComplete, function () {\n                                var callback = evaluateValueAccessor(bindings[ko.bindingEvent.childrenComplete]);\n                                if (callback) {\n                                    var nodes = ko.virtualElements.childNodes(node);\n                                    if (nodes.length) {\n                                        callback(nodes, ko.dataFor(nodes[0]));\n                                    }\n                                }\n                            });\n                        }\n\n                        if (ko.bindingEvent.descendantsComplete in bindings) {\n                            contextToExtend = ko.bindingEvent.startPossiblyAsyncContentBinding(node, bindingContext);\n                            ko.bindingEvent.subscribe(node, ko.bindingEvent.descendantsComplete, function () {\n                                var callback = evaluateValueAccessor(bindings[ko.bindingEvent.descendantsComplete]);\n                                if (callback && ko.virtualElements.firstChild(node)) {\n                                    callback(node);\n                                }\n                            });\n                        }\n\n                        // First put the bindings into the right order\n                        var orderedBindings = topologicalSortBindings(bindings);\n\n                        // Go through the sorted bindings, calling init and update for each\n                        ko.utils.arrayForEach(orderedBindings, function(bindingKeyAndHandler) {\n                            // Note that topologicalSortBindings has already filtered out any nonexistent binding handlers,\n                            // so bindingKeyAndHandler.handler will always be nonnull.\n                            var handlerInitFn = bindingKeyAndHandler.handler[\"init\"],\n                                handlerUpdateFn = bindingKeyAndHandler.handler[\"update\"],\n                                bindingKey = bindingKeyAndHandler.key;\n\n                            if (node.nodeType === 8) {\n                                validateThatBindingIsAllowedForVirtualElements(bindingKey);\n                            }\n\n                            try {\n                                // Run init, ignoring any dependencies\n                                if (typeof handlerInitFn == \"function\") {\n                                    ko.dependencyDetection.ignore(function() {\n                                        var initResult = handlerInitFn(node, getValueAccessor(bindingKey), allBindings, contextToExtend['$data'], contextToExtend);\n\n                                        // If this binding handler claims to control descendant bindings, make a note of this\n                                        if (initResult && initResult['controlsDescendantBindings']) {\n                                            if (bindingHandlerThatControlsDescendantBindings !== undefined)\n                                                throw new Error(\"Multiple bindings (\" + bindingHandlerThatControlsDescendantBindings + \" and \" + bindingKey + \") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.\");\n                                            bindingHandlerThatControlsDescendantBindings = bindingKey;\n                                        }\n                                    });\n                                }\n\n                                // Run update in its own computed wrapper\n                                if (typeof handlerUpdateFn == \"function\") {\n                                    ko.dependentObservable(\n                                        function() {\n                                            handlerUpdateFn(node, getValueAccessor(bindingKey), allBindings, contextToExtend['$data'], contextToExtend);\n                                        },\n                                        null,\n                                        { disposeWhenNodeIsRemoved: node }\n                                    );\n                                }\n                            } catch (ex) {\n                                ex.message = \"Unable to process binding \\\"\" + bindingKey + \": \" + bindings[bindingKey] + \"\\\"\\nMessage: \" + ex.message;\n                                throw ex;\n                            }\n                        });\n                    }\n\n                    var shouldBindDescendants = bindingHandlerThatControlsDescendantBindings === undefined;\n                    return {\n                        'shouldBindDescendants': shouldBindDescendants,\n                        'bindingContextForDescendants': shouldBindDescendants && contextToExtend\n                    };\n                };\n\n                ko.storedBindingContextForNode = function (node) {\n                    var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey);\n                    return bindingInfo && bindingInfo.context;\n                }\n\n                function getBindingContext(viewModelOrBindingContext, extendContextCallback) {\n                    return viewModelOrBindingContext && (viewModelOrBindingContext instanceof ko.bindingContext)\n                        ? viewModelOrBindingContext\n                        : new ko.bindingContext(viewModelOrBindingContext, undefined, undefined, extendContextCallback);\n                }\n\n                ko.applyBindingAccessorsToNode = function (node, bindings, viewModelOrBindingContext) {\n                    if (node.nodeType === 1) // If it's an element, workaround IE <= 8 HTML parsing weirdness\n                        ko.virtualElements.normaliseVirtualElementDomStructure(node);\n                    return applyBindingsToNodeInternal(node, bindings, getBindingContext(viewModelOrBindingContext));\n                };\n\n                ko.applyBindingsToNode = function (node, bindings, viewModelOrBindingContext) {\n                    var context = getBindingContext(viewModelOrBindingContext);\n                    return ko.applyBindingAccessorsToNode(node, makeBindingAccessors(bindings, context, node), context);\n                };\n\n                ko.applyBindingsToDescendants = function(viewModelOrBindingContext, rootNode) {\n                    if (rootNode.nodeType === 1 || rootNode.nodeType === 8)\n                        applyBindingsToDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode);\n                };\n\n                ko.applyBindings = function (viewModelOrBindingContext, rootNode, extendContextCallback) {\n                    // If jQuery is loaded after Knockout, we won't initially have access to it. So save it here.\n                    if (!jQueryInstance && window['jQuery']) {\n                        jQueryInstance = window['jQuery'];\n                    }\n\n                    if (arguments.length < 2) {\n                        rootNode = document.body;\n                        if (!rootNode) {\n                            throw Error(\"ko.applyBindings: could not find document.body; has the document been loaded?\");\n                        }\n                    } else if (!rootNode || (rootNode.nodeType !== 1 && rootNode.nodeType !== 8)) {\n                        throw Error(\"ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node\");\n                    }\n\n                    applyBindingsToNodeAndDescendantsInternal(getBindingContext(viewModelOrBindingContext, extendContextCallback), rootNode);\n                };\n\n                // Retrieving binding context from arbitrary nodes\n                ko.contextFor = function(node) {\n                    // We can only do something meaningful for elements and comment nodes (in particular, not text nodes, as IE can't store domdata for them)\n                    if (node && (node.nodeType === 1 || node.nodeType === 8)) {\n                        return ko.storedBindingContextForNode(node);\n                    }\n                    return undefined;\n                };\n                ko.dataFor = function(node) {\n                    var context = ko.contextFor(node);\n                    return context ? context['$data'] : undefined;\n                };\n\n                ko.exportSymbol('bindingHandlers', ko.bindingHandlers);\n                ko.exportSymbol('bindingEvent', ko.bindingEvent);\n                ko.exportSymbol('bindingEvent.subscribe', ko.bindingEvent.subscribe);\n                ko.exportSymbol('bindingEvent.startPossiblyAsyncContentBinding', ko.bindingEvent.startPossiblyAsyncContentBinding);\n                ko.exportSymbol('applyBindings', ko.applyBindings);\n                ko.exportSymbol('applyBindingsToDescendants', ko.applyBindingsToDescendants);\n                ko.exportSymbol('applyBindingAccessorsToNode', ko.applyBindingAccessorsToNode);\n                ko.exportSymbol('applyBindingsToNode', ko.applyBindingsToNode);\n                ko.exportSymbol('contextFor', ko.contextFor);\n                ko.exportSymbol('dataFor', ko.dataFor);\n            })();\n            (function(undefined) {\n                var loadingSubscribablesCache = {}, // Tracks component loads that are currently in flight\n                    loadedDefinitionsCache = {};    // Tracks component loads that have already completed\n\n                ko.components = {\n                    get: function(componentName, callback) {\n                        var cachedDefinition = getObjectOwnProperty(loadedDefinitionsCache, componentName);\n                        if (cachedDefinition) {\n                            // It's already loaded and cached. Reuse the same definition object.\n                            // Note that for API consistency, even cache hits complete asynchronously by default.\n                            // You can bypass this by putting synchronous:true on your component config.\n                            if (cachedDefinition.isSynchronousComponent) {\n                                ko.dependencyDetection.ignore(function() { // See comment in loaderRegistryBehaviors.js for reasoning\n                                    callback(cachedDefinition.definition);\n                                });\n                            } else {\n                                ko.tasks.schedule(function() { callback(cachedDefinition.definition); });\n                            }\n                        } else {\n                            // Join the loading process that is already underway, or start a new one.\n                            loadComponentAndNotify(componentName, callback);\n                        }\n                    },\n\n                    clearCachedDefinition: function(componentName) {\n                        delete loadedDefinitionsCache[componentName];\n                    },\n\n                    _getFirstResultFromLoaders: getFirstResultFromLoaders\n                };\n\n                function getObjectOwnProperty(obj, propName) {\n                    return Object.prototype.hasOwnProperty.call(obj, propName) ? obj[propName] : undefined;\n                }\n\n                function loadComponentAndNotify(componentName, callback) {\n                    var subscribable = getObjectOwnProperty(loadingSubscribablesCache, componentName),\n                        completedAsync;\n                    if (!subscribable) {\n                        // It's not started loading yet. Start loading, and when it's done, move it to loadedDefinitionsCache.\n                        subscribable = loadingSubscribablesCache[componentName] = new ko.subscribable();\n                        subscribable.subscribe(callback);\n\n                        beginLoadingComponent(componentName, function(definition, config) {\n                            var isSynchronousComponent = !!(config && config['synchronous']);\n                            loadedDefinitionsCache[componentName] = { definition: definition, isSynchronousComponent: isSynchronousComponent };\n                            delete loadingSubscribablesCache[componentName];\n\n                            // For API consistency, all loads complete asynchronously. However we want to avoid\n                            // adding an extra task schedule if it's unnecessary (i.e., the completion is already\n                            // async).\n                            //\n                            // You can bypass the 'always asynchronous' feature by putting the synchronous:true\n                            // flag on your component configuration when you register it.\n                            if (completedAsync || isSynchronousComponent) {\n                                // Note that notifySubscribers ignores any dependencies read within the callback.\n                                // See comment in loaderRegistryBehaviors.js for reasoning\n                                subscribable['notifySubscribers'](definition);\n                            } else {\n                                ko.tasks.schedule(function() {\n                                    subscribable['notifySubscribers'](definition);\n                                });\n                            }\n                        });\n                        completedAsync = true;\n                    } else {\n                        subscribable.subscribe(callback);\n                    }\n                }\n\n                function beginLoadingComponent(componentName, callback) {\n                    getFirstResultFromLoaders('getConfig', [componentName], function(config) {\n                        if (config) {\n                            // We have a config, so now load its definition\n                            getFirstResultFromLoaders('loadComponent', [componentName, config], function(definition) {\n                                callback(definition, config);\n                            });\n                        } else {\n                            // The component has no config - it's unknown to all the loaders.\n                            // Note that this is not an error (e.g., a module loading error) - that would abort the\n                            // process and this callback would not run. For this callback to run, all loaders must\n                            // have confirmed they don't know about this component.\n                            callback(null, null);\n                        }\n                    });\n                }\n\n                function getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders) {\n                    // On the first call in the stack, start with the full set of loaders\n                    if (!candidateLoaders) {\n                        candidateLoaders = ko.components['loaders'].slice(0); // Use a copy, because we'll be mutating this array\n                    }\n\n                    // Try the next candidate\n                    var currentCandidateLoader = candidateLoaders.shift();\n                    if (currentCandidateLoader) {\n                        var methodInstance = currentCandidateLoader[methodName];\n                        if (methodInstance) {\n                            var wasAborted = false,\n                                synchronousReturnValue = methodInstance.apply(currentCandidateLoader, argsExceptCallback.concat(function(result) {\n                                    if (wasAborted) {\n                                        callback(null);\n                                    } else if (result !== null) {\n                                        // This candidate returned a value. Use it.\n                                        callback(result);\n                                    } else {\n                                        // Try the next candidate\n                                        getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                                    }\n                                }));\n\n                            // Currently, loaders may not return anything synchronously. This leaves open the possibility\n                            // that we'll extend the API to support synchronous return values in the future. It won't be\n                            // a breaking change, because currently no loader is allowed to return anything except undefined.\n                            if (synchronousReturnValue !== undefined) {\n                                wasAborted = true;\n\n                                // Method to suppress exceptions will remain undocumented. This is only to keep\n                                // KO's specs running tidily, since we can observe the loading got aborted without\n                                // having exceptions cluttering up the console too.\n                                if (!currentCandidateLoader['suppressLoaderExceptions']) {\n                                    throw new Error('Component loaders must supply values by invoking the callback, not by returning values synchronously.');\n                                }\n                            }\n                        } else {\n                            // This candidate doesn't have the relevant handler. Synchronously move on to the next one.\n                            getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                        }\n                    } else {\n                        // No candidates returned a value\n                        callback(null);\n                    }\n                }\n\n                // Reference the loaders via string name so it's possible for developers\n                // to replace the whole array by assigning to ko.components.loaders\n                ko.components['loaders'] = [];\n\n                ko.exportSymbol('components', ko.components);\n                ko.exportSymbol('components.get', ko.components.get);\n                ko.exportSymbol('components.clearCachedDefinition', ko.components.clearCachedDefinition);\n            })();\n            (function(undefined) {\n\n                // The default loader is responsible for two things:\n                // 1. Maintaining the default in-memory registry of component configuration objects\n                //    (i.e., the thing you're writing to when you call ko.components.register(someName, ...))\n                // 2. Answering requests for components by fetching configuration objects\n                //    from that default in-memory registry and resolving them into standard\n                //    component definition objects (of the form { createViewModel: ..., template: ... })\n                // Custom loaders may override either of these facilities, i.e.,\n                // 1. To supply configuration objects from some other source (e.g., conventions)\n                // 2. Or, to resolve configuration objects by loading viewmodels/templates via arbitrary logic.\n\n                var defaultConfigRegistry = {};\n\n                ko.components.register = function(componentName, config) {\n                    if (!config) {\n                        throw new Error('Invalid configuration for ' + componentName);\n                    }\n\n                    if (ko.components.isRegistered(componentName)) {\n                        throw new Error('Component ' + componentName + ' is already registered');\n                    }\n\n                    defaultConfigRegistry[componentName] = config;\n                };\n\n                ko.components.isRegistered = function(componentName) {\n                    return Object.prototype.hasOwnProperty.call(defaultConfigRegistry, componentName);\n                };\n\n                ko.components.unregister = function(componentName) {\n                    delete defaultConfigRegistry[componentName];\n                    ko.components.clearCachedDefinition(componentName);\n                };\n\n                ko.components.defaultLoader = {\n                    'getConfig': function(componentName, callback) {\n                        var result = ko.components.isRegistered(componentName)\n                            ? defaultConfigRegistry[componentName]\n                            : null;\n                        callback(result);\n                    },\n\n                    'loadComponent': function(componentName, config, callback) {\n                        var errorCallback = makeErrorCallback(componentName);\n                        possiblyGetConfigFromAmd(errorCallback, config, function(loadedConfig) {\n                            resolveConfig(componentName, errorCallback, loadedConfig, callback);\n                        });\n                    },\n\n                    'loadTemplate': function(componentName, templateConfig, callback) {\n                        resolveTemplate(makeErrorCallback(componentName), templateConfig, callback);\n                    },\n\n                    'loadViewModel': function(componentName, viewModelConfig, callback) {\n                        resolveViewModel(makeErrorCallback(componentName), viewModelConfig, callback);\n                    }\n                };\n\n                var createViewModelKey = 'createViewModel';\n\n                // Takes a config object of the form { template: ..., viewModel: ... }, and asynchronously convert it\n                // into the standard component definition format:\n                //    { template: <ArrayOfDomNodes>, createViewModel: function(params, componentInfo) { ... } }.\n                // Since both template and viewModel may need to be resolved asynchronously, both tasks are performed\n                // in parallel, and the results joined when both are ready. We don't depend on any promises infrastructure,\n                // so this is implemented manually below.\n                function resolveConfig(componentName, errorCallback, config, callback) {\n                    var result = {},\n                        makeCallBackWhenZero = 2,\n                        tryIssueCallback = function() {\n                            if (--makeCallBackWhenZero === 0) {\n                                callback(result);\n                            }\n                        },\n                        templateConfig = config['template'],\n                        viewModelConfig = config['viewModel'];\n\n                    if (templateConfig) {\n                        possiblyGetConfigFromAmd(errorCallback, templateConfig, function(loadedConfig) {\n                            ko.components._getFirstResultFromLoaders('loadTemplate', [componentName, loadedConfig], function(resolvedTemplate) {\n                                result['template'] = resolvedTemplate;\n                                tryIssueCallback();\n                            });\n                        });\n                    } else {\n                        tryIssueCallback();\n                    }\n\n                    if (viewModelConfig) {\n                        possiblyGetConfigFromAmd(errorCallback, viewModelConfig, function(loadedConfig) {\n                            ko.components._getFirstResultFromLoaders('loadViewModel', [componentName, loadedConfig], function(resolvedViewModel) {\n                                result[createViewModelKey] = resolvedViewModel;\n                                tryIssueCallback();\n                            });\n                        });\n                    } else {\n                        tryIssueCallback();\n                    }\n                }\n\n                function resolveTemplate(errorCallback, templateConfig, callback) {\n                    if (typeof templateConfig === 'string') {\n                        // Markup - parse it\n                        callback(ko.utils.parseHtmlFragment(templateConfig));\n                    } else if (templateConfig instanceof Array) {\n                        // Assume already an array of DOM nodes - pass through unchanged\n                        callback(templateConfig);\n                    } else if (isDocumentFragment(templateConfig)) {\n                        // Document fragment - use its child nodes\n                        callback(ko.utils.makeArray(templateConfig.childNodes));\n                    } else if (templateConfig['element']) {\n                        var element = templateConfig['element'];\n                        if (isDomElement(element)) {\n                            // Element instance - copy its child nodes\n                            callback(cloneNodesFromTemplateSourceElement(element));\n                        } else if (typeof element === 'string') {\n                            // Element ID - find it, then copy its child nodes\n                            var elemInstance = document.getElementById(element);\n                            if (elemInstance) {\n                                callback(cloneNodesFromTemplateSourceElement(elemInstance));\n                            } else {\n                                errorCallback('Cannot find element with ID ' + element);\n                            }\n                        } else {\n                            errorCallback('Unknown element type: ' + element);\n                        }\n                    } else {\n                        errorCallback('Unknown template value: ' + templateConfig);\n                    }\n                }\n\n                function resolveViewModel(errorCallback, viewModelConfig, callback) {\n                    if (typeof viewModelConfig === 'function') {\n                        // Constructor - convert to standard factory function format\n                        // By design, this does *not* supply componentInfo to the constructor, as the intent is that\n                        // componentInfo contains non-viewmodel data (e.g., the component's element) that should only\n                        // be used in factory functions, not viewmodel constructors.\n                        callback(function (params /*, componentInfo */) {\n                            return new viewModelConfig(params);\n                        });\n                    } else if (typeof viewModelConfig[createViewModelKey] === 'function') {\n                        // Already a factory function - use it as-is\n                        callback(viewModelConfig[createViewModelKey]);\n                    } else if ('instance' in viewModelConfig) {\n                        // Fixed object instance - promote to createViewModel format for API consistency\n                        var fixedInstance = viewModelConfig['instance'];\n                        callback(function (params, componentInfo) {\n                            return fixedInstance;\n                        });\n                    } else if ('viewModel' in viewModelConfig) {\n                        // Resolved AMD module whose value is of the form { viewModel: ... }\n                        resolveViewModel(errorCallback, viewModelConfig['viewModel'], callback);\n                    } else {\n                        errorCallback('Unknown viewModel value: ' + viewModelConfig);\n                    }\n                }\n\n                function cloneNodesFromTemplateSourceElement(elemInstance) {\n                    switch (ko.utils.tagNameLower(elemInstance)) {\n                        case 'script':\n                            return ko.utils.parseHtmlFragment(elemInstance.text);\n                        case 'textarea':\n                            return ko.utils.parseHtmlFragment(elemInstance.value);\n                        case 'template':\n                            // For browsers with proper <template> element support (i.e., where the .content property\n                            // gives a document fragment), use that document fragment.\n                            if (isDocumentFragment(elemInstance.content)) {\n                                return ko.utils.cloneNodes(elemInstance.content.childNodes);\n                            }\n                    }\n\n                    // Regular elements such as <div>, and <template> elements on old browsers that don't really\n                    // understand <template> and just treat it as a regular container\n                    return ko.utils.cloneNodes(elemInstance.childNodes);\n                }\n\n                function isDomElement(obj) {\n                    if (window['HTMLElement']) {\n                        return obj instanceof HTMLElement;\n                    } else {\n                        return obj && obj.tagName && obj.nodeType === 1;\n                    }\n                }\n\n                function isDocumentFragment(obj) {\n                    if (window['DocumentFragment']) {\n                        return obj instanceof DocumentFragment;\n                    } else {\n                        return obj && obj.nodeType === 11;\n                    }\n                }\n\n                function possiblyGetConfigFromAmd(errorCallback, config, callback) {\n                    if (typeof config['require'] === 'string') {\n                        // The config is the value of an AMD module\n                        if (amdRequire || window['require']) {\n                            (amdRequire || window['require'])([config['require']], function (module) {\n                                if (module && typeof module === 'object' && module.__esModule && module.default) {\n                                    module = module.default;\n                                }\n                                callback(module);\n                            });\n                        } else {\n                            errorCallback('Uses require, but no AMD loader is present');\n                        }\n                    } else {\n                        callback(config);\n                    }\n                }\n\n                function makeErrorCallback(componentName) {\n                    return function (message) {\n                        throw new Error('Component \\'' + componentName + '\\': ' + message);\n                    };\n                }\n\n                ko.exportSymbol('components.register', ko.components.register);\n                ko.exportSymbol('components.isRegistered', ko.components.isRegistered);\n                ko.exportSymbol('components.unregister', ko.components.unregister);\n\n                // Expose the default loader so that developers can directly ask it for configuration\n                // or to resolve configuration\n                ko.exportSymbol('components.defaultLoader', ko.components.defaultLoader);\n\n                // By default, the default loader is the only registered component loader\n                ko.components['loaders'].push(ko.components.defaultLoader);\n\n                // Privately expose the underlying config registry for use in old-IE shim\n                ko.components._allRegisteredComponents = defaultConfigRegistry;\n            })();\n            (function (undefined) {\n                // Overridable API for determining which component name applies to a given node. By overriding this,\n                // you can for example map specific tagNames to components that are not preregistered.\n                ko.components['getComponentNameForNode'] = function(node) {\n                    var tagNameLower = ko.utils.tagNameLower(node);\n                    if (ko.components.isRegistered(tagNameLower)) {\n                        // Try to determine that this node can be considered a *custom* element; see https://github.com/knockout/knockout/issues/1603\n                        if (tagNameLower.indexOf('-') != -1 || ('' + node) == \"[object HTMLUnknownElement]\" || (ko.utils.ieVersion <= 8 && node.tagName === tagNameLower)) {\n                            return tagNameLower;\n                        }\n                    }\n                };\n\n                ko.components.addBindingsForCustomElement = function(allBindings, node, bindingContext, valueAccessors) {\n                    // Determine if it's really a custom element matching a component\n                    if (node.nodeType === 1) {\n                        var componentName = ko.components['getComponentNameForNode'](node);\n                        if (componentName) {\n                            // It does represent a component, so add a component binding for it\n                            allBindings = allBindings || {};\n\n                            if (allBindings['component']) {\n                                // Avoid silently overwriting some other 'component' binding that may already be on the element\n                                throw new Error('Cannot use the \"component\" binding on a custom element matching a component');\n                            }\n\n                            var componentBindingValue = { 'name': componentName, 'params': getComponentParamsFromCustomElement(node, bindingContext) };\n\n                            allBindings['component'] = valueAccessors\n                                ? function() { return componentBindingValue; }\n                                : componentBindingValue;\n                        }\n                    }\n\n                    return allBindings;\n                }\n\n                var nativeBindingProviderInstance = new ko.bindingProvider();\n\n                function getComponentParamsFromCustomElement(elem, bindingContext) {\n                    var paramsAttribute = elem.getAttribute('params');\n\n                    if (paramsAttribute) {\n                        var params = nativeBindingProviderInstance['parseBindingsString'](paramsAttribute, bindingContext, elem, { 'valueAccessors': true, 'bindingParams': true }),\n                            rawParamComputedValues = ko.utils.objectMap(params, function(paramValue, paramName) {\n                                return ko.computed(paramValue, null, { disposeWhenNodeIsRemoved: elem });\n                            }),\n                            result = ko.utils.objectMap(rawParamComputedValues, function(paramValueComputed, paramName) {\n                                var paramValue = paramValueComputed.peek();\n                                // Does the evaluation of the parameter value unwrap any observables?\n                                if (!paramValueComputed.isActive()) {\n                                    // No it doesn't, so there's no need for any computed wrapper. Just pass through the supplied value directly.\n                                    // Example: \"someVal: firstName, age: 123\" (whether or not firstName is an observable/computed)\n                                    return paramValue;\n                                } else {\n                                    // Yes it does. Supply a computed property that unwraps both the outer (binding expression)\n                                    // level of observability, and any inner (resulting model value) level of observability.\n                                    // This means the component doesn't have to worry about multiple unwrapping. If the value is a\n                                    // writable observable, the computed will also be writable and pass the value on to the observable.\n                                    return ko.computed({\n                                        'read': function() {\n                                            return ko.utils.unwrapObservable(paramValueComputed());\n                                        },\n                                        'write': ko.isWriteableObservable(paramValue) && function(value) {\n                                            paramValueComputed()(value);\n                                        },\n                                        disposeWhenNodeIsRemoved: elem\n                                    });\n                                }\n                            });\n\n                        // Give access to the raw computeds, as long as that wouldn't overwrite any custom param also called '$raw'\n                        // This is in case the developer wants to react to outer (binding) observability separately from inner\n                        // (model value) observability, or in case the model value observable has subobservables.\n                        if (!Object.prototype.hasOwnProperty.call(result, '$raw')) {\n                            result['$raw'] = rawParamComputedValues;\n                        }\n\n                        return result;\n                    } else {\n                        // For consistency, absence of a \"params\" attribute is treated the same as the presence of\n                        // any empty one. Otherwise component viewmodels need special code to check whether or not\n                        // 'params' or 'params.$raw' is null/undefined before reading subproperties, which is annoying.\n                        return { '$raw': {} };\n                    }\n                }\n\n                // --------------------------------------------------------------------------------\n                // Compatibility code for older (pre-HTML5) IE browsers\n\n                if (ko.utils.ieVersion < 9) {\n                    // Whenever you preregister a component, enable it as a custom element in the current document\n                    ko.components['register'] = (function(originalFunction) {\n                        return function(componentName) {\n                            document.createElement(componentName); // Allows IE<9 to parse markup containing the custom element\n                            return originalFunction.apply(this, arguments);\n                        }\n                    })(ko.components['register']);\n\n                    // Whenever you create a document fragment, enable all preregistered component names as custom elements\n                    // This is needed to make innerShiv/jQuery HTML parsing correctly handle the custom elements\n                    document.createDocumentFragment = (function(originalFunction) {\n                        return function() {\n                            var newDocFrag = originalFunction(),\n                                allComponents = ko.components._allRegisteredComponents;\n                            for (var componentName in allComponents) {\n                                if (Object.prototype.hasOwnProperty.call(allComponents, componentName)) {\n                                    newDocFrag.createElement(componentName);\n                                }\n                            }\n                            return newDocFrag;\n                        };\n                    })(document.createDocumentFragment);\n                }\n            })();(function(undefined) {\n                var componentLoadingOperationUniqueId = 0;\n\n                ko.bindingHandlers['component'] = {\n                    'init': function(element, valueAccessor, ignored1, ignored2, bindingContext) {\n                        var currentViewModel,\n                            currentLoadingOperationId,\n                            afterRenderSub,\n                            disposeAssociatedComponentViewModel = function () {\n                                var currentViewModelDispose = currentViewModel && currentViewModel['dispose'];\n                                if (typeof currentViewModelDispose === 'function') {\n                                    currentViewModelDispose.call(currentViewModel);\n                                }\n                                if (afterRenderSub) {\n                                    afterRenderSub.dispose();\n                                }\n                                afterRenderSub = null;\n                                currentViewModel = null;\n                                // Any in-flight loading operation is no longer relevant, so make sure we ignore its completion\n                                currentLoadingOperationId = null;\n                            },\n                            originalChildNodes = ko.utils.makeArray(ko.virtualElements.childNodes(element));\n\n                        ko.virtualElements.emptyNode(element);\n                        ko.utils.domNodeDisposal.addDisposeCallback(element, disposeAssociatedComponentViewModel);\n\n                        ko.computed(function () {\n                            var value = ko.utils.unwrapObservable(valueAccessor()),\n                                componentName, componentParams;\n\n                            if (typeof value === 'string') {\n                                componentName = value;\n                            } else {\n                                componentName = ko.utils.unwrapObservable(value['name']);\n                                componentParams = ko.utils.unwrapObservable(value['params']);\n                            }\n\n                            if (!componentName) {\n                                throw new Error('No component name specified');\n                            }\n\n                            var asyncContext = ko.bindingEvent.startPossiblyAsyncContentBinding(element, bindingContext);\n\n                            var loadingOperationId = currentLoadingOperationId = ++componentLoadingOperationUniqueId;\n                            ko.components.get(componentName, function(componentDefinition) {\n                                // If this is not the current load operation for this element, ignore it.\n                                if (currentLoadingOperationId !== loadingOperationId) {\n                                    return;\n                                }\n\n                                // Clean up previous state\n                                disposeAssociatedComponentViewModel();\n\n                                // Instantiate and bind new component. Implicitly this cleans any old DOM nodes.\n                                if (!componentDefinition) {\n                                    throw new Error('Unknown component \\'' + componentName + '\\'');\n                                }\n                                cloneTemplateIntoElement(componentName, componentDefinition, element);\n\n                                var componentInfo = {\n                                    'element': element,\n                                    'templateNodes': originalChildNodes\n                                };\n\n                                var componentViewModel = createViewModel(componentDefinition, componentParams, componentInfo),\n                                    childBindingContext = asyncContext['createChildContext'](componentViewModel, {\n                                        'extend': function(ctx) {\n                                            ctx['$component'] = componentViewModel;\n                                            ctx['$componentTemplateNodes'] = originalChildNodes;\n                                        }\n                                    });\n\n                                if (componentViewModel && componentViewModel['koDescendantsComplete']) {\n                                    afterRenderSub = ko.bindingEvent.subscribe(element, ko.bindingEvent.descendantsComplete, componentViewModel['koDescendantsComplete'], componentViewModel);\n                                }\n\n                                currentViewModel = componentViewModel;\n                                ko.applyBindingsToDescendants(childBindingContext, element);\n                            });\n                        }, null, { disposeWhenNodeIsRemoved: element });\n\n                        return { 'controlsDescendantBindings': true };\n                    }\n                };\n\n                ko.virtualElements.allowedBindings['component'] = true;\n\n                function cloneTemplateIntoElement(componentName, componentDefinition, element) {\n                    var template = componentDefinition['template'];\n                    if (!template) {\n                        throw new Error('Component \\'' + componentName + '\\' has no template');\n                    }\n\n                    var clonedNodesArray = ko.utils.cloneNodes(template);\n                    ko.virtualElements.setDomNodeChildren(element, clonedNodesArray);\n                }\n\n                function createViewModel(componentDefinition, componentParams, componentInfo) {\n                    var componentViewModelFactory = componentDefinition['createViewModel'];\n                    return componentViewModelFactory\n                        ? componentViewModelFactory.call(componentDefinition, componentParams, componentInfo)\n                        : componentParams; // Template-only component\n                }\n\n            })();\n            var attrHtmlToJavaScriptMap = { 'class': 'className', 'for': 'htmlFor' };\n            ko.bindingHandlers['attr'] = {\n                'update': function(element, valueAccessor, allBindings) {\n                    var value = ko.utils.unwrapObservable(valueAccessor()) || {};\n                    ko.utils.objectForEach(value, function(attrName, attrValue) {\n                        attrValue = ko.utils.unwrapObservable(attrValue);\n\n                        // Find the namespace of this attribute, if any.\n                        var prefixLen = attrName.indexOf(':');\n                        var namespace = \"lookupNamespaceURI\" in element && prefixLen > 0 && element.lookupNamespaceURI(attrName.substr(0, prefixLen));\n\n                        // To cover cases like \"attr: { checked:someProp }\", we want to remove the attribute entirely\n                        // when someProp is a \"no value\"-like value (strictly null, false, or undefined)\n                        // (because the absence of the \"checked\" attr is how to mark an element as not checked, etc.)\n                        var toRemove = (attrValue === false) || (attrValue === null) || (attrValue === undefined);\n                        if (toRemove) {\n                            namespace ? element.removeAttributeNS(namespace, attrName) : element.removeAttribute(attrName);\n                        } else {\n                            attrValue = attrValue.toString();\n                        }\n\n                        // In IE <= 7 and IE8 Quirks Mode, you have to use the JavaScript property name instead of the\n                        // HTML attribute name for certain attributes. IE8 Standards Mode supports the correct behavior,\n                        // but instead of figuring out the mode, we'll just set the attribute through the JavaScript\n                        // property for IE <= 8.\n                        if (ko.utils.ieVersion <= 8 && attrName in attrHtmlToJavaScriptMap) {\n                            attrName = attrHtmlToJavaScriptMap[attrName];\n                            if (toRemove)\n                                element.removeAttribute(attrName);\n                            else\n                                element[attrName] = attrValue;\n                        } else if (!toRemove) {\n                            namespace ? element.setAttributeNS(namespace, attrName, attrValue) : element.setAttribute(attrName, attrValue);\n                        }\n\n                        // Treat \"name\" specially - although you can think of it as an attribute, it also needs\n                        // special handling on older versions of IE (https://github.com/SteveSanderson/knockout/pull/333)\n                        // Deliberately being case-sensitive here because XHTML would regard \"Name\" as a different thing\n                        // entirely, and there's no strong reason to allow for such casing in HTML.\n                        if (attrName === \"name\") {\n                            ko.utils.setElementName(element, toRemove ? \"\" : attrValue);\n                        }\n                    });\n                }\n            };\n            (function() {\n\n                ko.bindingHandlers['checked'] = {\n                    'after': ['value', 'attr'],\n                    'init': function (element, valueAccessor, allBindings) {\n                        var checkedValue = ko.pureComputed(function() {\n                            // Treat \"value\" like \"checkedValue\" when it is included with \"checked\" binding\n                            if (allBindings['has']('checkedValue')) {\n                                return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n                            } else if (useElementValue) {\n                                if (allBindings['has']('value')) {\n                                    return ko.utils.unwrapObservable(allBindings.get('value'));\n                                } else {\n                                    return element.value;\n                                }\n                            }\n                        });\n\n                        function updateModel() {\n                            // This updates the model value from the view value.\n                            // It runs in response to DOM events (click) and changes in checkedValue.\n                            var isChecked = element.checked,\n                                elemValue = checkedValue();\n\n                            // When we're first setting up this computed, don't change any model state.\n                            if (ko.computedContext.isInitial()) {\n                                return;\n                            }\n\n                            // We can ignore unchecked radio buttons, because some other radio\n                            // button will be checked, and that one can take care of updating state.\n                            // Also ignore value changes to an already unchecked checkbox.\n                            if (!isChecked && (isRadio || ko.computedContext.getDependenciesCount())) {\n                                return;\n                            }\n\n                            var modelValue = ko.dependencyDetection.ignore(valueAccessor);\n                            if (valueIsArray) {\n                                var writableValue = rawValueIsNonArrayObservable ? modelValue.peek() : modelValue,\n                                    saveOldValue = oldElemValue;\n                                oldElemValue = elemValue;\n\n                                if (saveOldValue !== elemValue) {\n                                    // When we're responding to the checkedValue changing, and the element is\n                                    // currently checked, replace the old elem value with the new elem value\n                                    // in the model array.\n                                    if (isChecked) {\n                                        ko.utils.addOrRemoveItem(writableValue, elemValue, true);\n                                        ko.utils.addOrRemoveItem(writableValue, saveOldValue, false);\n                                    }\n                                } else {\n                                    // When we're responding to the user having checked/unchecked a checkbox,\n                                    // add/remove the element value to the model array.\n                                    ko.utils.addOrRemoveItem(writableValue, elemValue, isChecked);\n                                }\n\n                                if (rawValueIsNonArrayObservable && ko.isWriteableObservable(modelValue)) {\n                                    modelValue(writableValue);\n                                }\n                            } else {\n                                if (isCheckbox) {\n                                    if (elemValue === undefined) {\n                                        elemValue = isChecked;\n                                    } else if (!isChecked) {\n                                        elemValue = undefined;\n                                    }\n                                }\n                                ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n                            }\n                        };\n\n                        function updateView() {\n                            // This updates the view value from the model value.\n                            // It runs in response to changes in the bound (checked) value.\n                            var modelValue = ko.utils.unwrapObservable(valueAccessor()),\n                                elemValue = checkedValue();\n\n                            if (valueIsArray) {\n                                // When a checkbox is bound to an array, being checked represents its value being present in that array\n                                element.checked = ko.utils.arrayIndexOf(modelValue, elemValue) >= 0;\n                                oldElemValue = elemValue;\n                            } else if (isCheckbox && elemValue === undefined) {\n                                // When a checkbox is bound to any other value (not an array) and \"checkedValue\" is not defined,\n                                // being checked represents the value being trueish\n                                element.checked = !!modelValue;\n                            } else {\n                                // Otherwise, being checked means that the checkbox or radio button's value corresponds to the model value\n                                element.checked = (checkedValue() === modelValue);\n                            }\n                        };\n\n                        var isCheckbox = element.type == \"checkbox\",\n                            isRadio = element.type == \"radio\";\n\n                        // Only bind to check boxes and radio buttons\n                        if (!isCheckbox && !isRadio) {\n                            return;\n                        }\n\n                        var rawValue = valueAccessor(),\n                            valueIsArray = isCheckbox && (ko.utils.unwrapObservable(rawValue) instanceof Array),\n                            rawValueIsNonArrayObservable = !(valueIsArray && rawValue.push && rawValue.splice),\n                            useElementValue = isRadio || valueIsArray,\n                            oldElemValue = valueIsArray ? checkedValue() : undefined;\n\n                        // IE 6 won't allow radio buttons to be selected unless they have a name\n                        if (isRadio && !element.name)\n                            ko.bindingHandlers['uniqueName']['init'](element, function() { return true });\n\n                        // Set up two computeds to update the binding:\n\n                        // The first responds to changes in the checkedValue value and to element clicks\n                        ko.computed(updateModel, null, { disposeWhenNodeIsRemoved: element });\n                        ko.utils.registerEventHandler(element, \"click\", updateModel);\n\n                        // The second responds to changes in the model value (the one associated with the checked binding)\n                        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n\n                        rawValue = undefined;\n                    }\n                };\n                ko.expressionRewriting.twoWayBindings['checked'] = true;\n\n                ko.bindingHandlers['checkedValue'] = {\n                    'update': function (element, valueAccessor) {\n                        element.value = ko.utils.unwrapObservable(valueAccessor());\n                    }\n                };\n\n            })();var classesWrittenByBindingKey = '__ko__cssValue';\n            ko.bindingHandlers['class'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.stringTrim(ko.utils.unwrapObservable(valueAccessor()));\n                    ko.utils.toggleDomNodeCssClass(element, element[classesWrittenByBindingKey], false);\n                    element[classesWrittenByBindingKey] = value;\n                    ko.utils.toggleDomNodeCssClass(element, value, true);\n                }\n            };\n\n            ko.bindingHandlers['css'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    if (value !== null && typeof value == \"object\") {\n                        ko.utils.objectForEach(value, function(className, shouldHaveClass) {\n                            shouldHaveClass = ko.utils.unwrapObservable(shouldHaveClass);\n                            ko.utils.toggleDomNodeCssClass(element, className, shouldHaveClass);\n                        });\n                    } else {\n                        ko.bindingHandlers['class']['update'](element, valueAccessor);\n                    }\n                }\n            };\n            ko.bindingHandlers['enable'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    if (value && element.disabled)\n                        element.removeAttribute(\"disabled\");\n                    else if ((!value) && (!element.disabled))\n                        element.disabled = true;\n                }\n            };\n\n            ko.bindingHandlers['disable'] = {\n                'update': function (element, valueAccessor) {\n                    ko.bindingHandlers['enable']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n                }\n            };\n// For certain common events (currently just 'click'), allow a simplified data-binding syntax\n// e.g. click:handler instead of the usual full-length event:{click:handler}\n            function makeEventHandlerShortcut(eventName) {\n                ko.bindingHandlers[eventName] = {\n                    'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                        var newValueAccessor = function () {\n                            var result = {};\n                            result[eventName] = valueAccessor();\n                            return result;\n                        };\n                        return ko.bindingHandlers['event']['init'].call(this, element, newValueAccessor, allBindings, viewModel, bindingContext);\n                    }\n                }\n            }\n\n            ko.bindingHandlers['event'] = {\n                'init' : function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    var eventsToHandle = valueAccessor() || {};\n                    ko.utils.objectForEach(eventsToHandle, function(eventName) {\n                        if (typeof eventName == \"string\") {\n                            ko.utils.registerEventHandler(element, eventName, function (event) {\n                                var handlerReturnValue;\n                                var handlerFunction = valueAccessor()[eventName];\n                                if (!handlerFunction)\n                                    return;\n\n                                try {\n                                    // Take all the event args, and prefix with the viewmodel\n                                    var argsForHandler = ko.utils.makeArray(arguments);\n                                    viewModel = bindingContext['$data'];\n                                    argsForHandler.unshift(viewModel);\n                                    handlerReturnValue = handlerFunction.apply(viewModel, argsForHandler);\n                                } finally {\n                                    if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                                        if (event.preventDefault)\n                                            event.preventDefault();\n                                        else\n                                            event.returnValue = false;\n                                    }\n                                }\n\n                                var bubble = allBindings.get(eventName + 'Bubble') !== false;\n                                if (!bubble) {\n                                    event.cancelBubble = true;\n                                    if (event.stopPropagation)\n                                        event.stopPropagation();\n                                }\n                            });\n                        }\n                    });\n                }\n            };\n// \"foreach: someExpression\" is equivalent to \"template: { foreach: someExpression }\"\n// \"foreach: { data: someExpression, afterAdd: myfn }\" is equivalent to \"template: { foreach: someExpression, afterAdd: myfn }\"\n            ko.bindingHandlers['foreach'] = {\n                makeTemplateValueAccessor: function(valueAccessor) {\n                    return function() {\n                        var modelValue = valueAccessor(),\n                            unwrappedValue = ko.utils.peekObservable(modelValue);    // Unwrap without setting a dependency here\n\n                        // If unwrappedValue is the array, pass in the wrapped value on its own\n                        // The value will be unwrapped and tracked within the template binding\n                        // (See https://github.com/SteveSanderson/knockout/issues/523)\n                        if ((!unwrappedValue) || typeof unwrappedValue.length == \"number\")\n                            return { 'foreach': modelValue, 'templateEngine': ko.nativeTemplateEngine.instance };\n\n                        // If unwrappedValue.data is the array, preserve all relevant options and unwrap again value so we get updates\n                        ko.utils.unwrapObservable(modelValue);\n                        return {\n                            'foreach': unwrappedValue['data'],\n                            'as': unwrappedValue['as'],\n                            'noChildContext': unwrappedValue['noChildContext'],\n                            'includeDestroyed': unwrappedValue['includeDestroyed'],\n                            'afterAdd': unwrappedValue['afterAdd'],\n                            'beforeRemove': unwrappedValue['beforeRemove'],\n                            'afterRender': unwrappedValue['afterRender'],\n                            'beforeMove': unwrappedValue['beforeMove'],\n                            'afterMove': unwrappedValue['afterMove'],\n                            'templateEngine': ko.nativeTemplateEngine.instance\n                        };\n                    };\n                },\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    return ko.bindingHandlers['template']['init'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor));\n                },\n                'update': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    return ko.bindingHandlers['template']['update'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor), allBindings, viewModel, bindingContext);\n                }\n            };\n            ko.expressionRewriting.bindingRewriteValidators['foreach'] = false; // Can't rewrite control flow bindings\n            ko.virtualElements.allowedBindings['foreach'] = true;\n            var hasfocusUpdatingProperty = '__ko_hasfocusUpdating';\n            var hasfocusLastValue = '__ko_hasfocusLastValue';\n            ko.bindingHandlers['hasfocus'] = {\n                'init': function(element, valueAccessor, allBindings) {\n                    var handleElementFocusChange = function(isFocused) {\n                        // Where possible, ignore which event was raised and determine focus state using activeElement,\n                        // as this avoids phantom focus/blur events raised when changing tabs in modern browsers.\n                        // However, not all KO-targeted browsers (Firefox 2) support activeElement. For those browsers,\n                        // prevent a loss of focus when changing tabs/windows by setting a flag that prevents hasfocus\n                        // from calling 'blur()' on the element when it loses focus.\n                        // Discussion at https://github.com/SteveSanderson/knockout/pull/352\n                        element[hasfocusUpdatingProperty] = true;\n                        var ownerDoc = element.ownerDocument;\n                        if (\"activeElement\" in ownerDoc) {\n                            var active;\n                            try {\n                                active = ownerDoc.activeElement;\n                            } catch(e) {\n                                // IE9 throws if you access activeElement during page load (see issue #703)\n                                active = ownerDoc.body;\n                            }\n                            isFocused = (active === element);\n                        }\n                        var modelValue = valueAccessor();\n                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'hasfocus', isFocused, true);\n\n                        //cache the latest value, so we can avoid unnecessarily calling focus/blur in the update function\n                        element[hasfocusLastValue] = isFocused;\n                        element[hasfocusUpdatingProperty] = false;\n                    };\n                    var handleElementFocusIn = handleElementFocusChange.bind(null, true);\n                    var handleElementFocusOut = handleElementFocusChange.bind(null, false);\n\n                    ko.utils.registerEventHandler(element, \"focus\", handleElementFocusIn);\n                    ko.utils.registerEventHandler(element, \"focusin\", handleElementFocusIn); // For IE\n                    ko.utils.registerEventHandler(element, \"blur\",  handleElementFocusOut);\n                    ko.utils.registerEventHandler(element, \"focusout\",  handleElementFocusOut); // For IE\n\n                    // Assume element is not focused (prevents \"blur\" being called initially)\n                    element[hasfocusLastValue] = false;\n                },\n                'update': function(element, valueAccessor) {\n                    var value = !!ko.utils.unwrapObservable(valueAccessor());\n\n                    if (!element[hasfocusUpdatingProperty] && element[hasfocusLastValue] !== value) {\n                        value ? element.focus() : element.blur();\n\n                        // In IE, the blur method doesn't always cause the element to lose focus (for example, if the window is not in focus).\n                        // Setting focus to the body element does seem to be reliable in IE, but should only be used if we know that the current\n                        // element was focused already.\n                        if (!value && element[hasfocusLastValue]) {\n                            element.ownerDocument.body.focus();\n                        }\n\n                        // For IE, which doesn't reliably fire \"focus\" or \"blur\" events synchronously\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, value ? \"focusin\" : \"focusout\"]);\n                    }\n                }\n            };\n            ko.expressionRewriting.twoWayBindings['hasfocus'] = true;\n\n            ko.bindingHandlers['hasFocus'] = ko.bindingHandlers['hasfocus']; // Make \"hasFocus\" an alias\n            ko.expressionRewriting.twoWayBindings['hasFocus'] = 'hasfocus';\n            ko.bindingHandlers['html'] = {\n                'init': function() {\n                    // Prevent binding on the dynamically-injected HTML (as developers are unlikely to expect that, and it has security implications)\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor) {\n                    // setHtml will unwrap the value if needed\n                    ko.utils.setHtml(element, valueAccessor());\n                }\n            };\n            (function () {\n\n// Makes a binding like with or if\n                function makeWithIfBinding(bindingKey, isWith, isNot) {\n                    ko.bindingHandlers[bindingKey] = {\n                        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                            var didDisplayOnLastUpdate, savedNodes, contextOptions = {}, completeOnRender, needAsyncContext, renderOnEveryChange;\n\n                            if (isWith) {\n                                var as = allBindings.get('as'), noChildContext = allBindings.get('noChildContext');\n                                renderOnEveryChange = !(as && noChildContext);\n                                contextOptions = { 'as': as, 'noChildContext': noChildContext, 'exportDependencies': renderOnEveryChange };\n                            }\n\n                            completeOnRender = allBindings.get(\"completeOn\") == \"render\";\n                            needAsyncContext = completeOnRender || allBindings['has'](ko.bindingEvent.descendantsComplete);\n\n                            ko.computed(function() {\n                                var value = ko.utils.unwrapObservable(valueAccessor()),\n                                    shouldDisplay = !isNot !== !value, // equivalent to isNot ? !value : !!value,\n                                    isInitial = !savedNodes,\n                                    childContext;\n\n                                if (!renderOnEveryChange && shouldDisplay === didDisplayOnLastUpdate) {\n                                    return;\n                                }\n\n                                if (needAsyncContext) {\n                                    bindingContext = ko.bindingEvent.startPossiblyAsyncContentBinding(element, bindingContext);\n                                }\n\n                                if (shouldDisplay) {\n                                    if (!isWith || renderOnEveryChange) {\n                                        contextOptions['dataDependency'] = ko.computedContext.computed();\n                                    }\n\n                                    if (isWith) {\n                                        childContext = bindingContext['createChildContext'](typeof value == \"function\" ? value : valueAccessor, contextOptions);\n                                    } else if (ko.computedContext.getDependenciesCount()) {\n                                        childContext = bindingContext['extend'](null, contextOptions);\n                                    } else {\n                                        childContext = bindingContext;\n                                    }\n                                }\n\n                                // Save a copy of the inner nodes on the initial update, but only if we have dependencies.\n                                if (isInitial && ko.computedContext.getDependenciesCount()) {\n                                    savedNodes = ko.utils.cloneNodes(ko.virtualElements.childNodes(element), true /* shouldCleanNodes */);\n                                }\n\n                                if (shouldDisplay) {\n                                    if (!isInitial) {\n                                        ko.virtualElements.setDomNodeChildren(element, ko.utils.cloneNodes(savedNodes));\n                                    }\n\n                                    ko.applyBindingsToDescendants(childContext, element);\n                                } else {\n                                    ko.virtualElements.emptyNode(element);\n\n                                    if (!completeOnRender) {\n                                        ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                                    }\n                                }\n\n                                didDisplayOnLastUpdate = shouldDisplay;\n\n                            }, null, { disposeWhenNodeIsRemoved: element });\n\n                            return { 'controlsDescendantBindings': true };\n                        }\n                    };\n                    ko.expressionRewriting.bindingRewriteValidators[bindingKey] = false; // Can't rewrite control flow bindings\n                    ko.virtualElements.allowedBindings[bindingKey] = true;\n                }\n\n// Construct the actual binding handlers\n                makeWithIfBinding('if');\n                makeWithIfBinding('ifnot', false /* isWith */, true /* isNot */);\n                makeWithIfBinding('with', true /* isWith */);\n\n            })();ko.bindingHandlers['let'] = {\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    // Make a modified binding context, with extra properties, and apply it to descendant elements\n                    var innerContext = bindingContext['extend'](valueAccessor);\n                    ko.applyBindingsToDescendants(innerContext, element);\n\n                    return { 'controlsDescendantBindings': true };\n                }\n            };\n            ko.virtualElements.allowedBindings['let'] = true;\n            var captionPlaceholder = {};\n            ko.bindingHandlers['options'] = {\n                'init': function(element) {\n                    if (ko.utils.tagNameLower(element) !== \"select\")\n                        throw new Error(\"options binding applies only to SELECT elements\");\n\n                    // Remove all existing <option>s.\n                    while (element.length > 0) {\n                        element.remove(0);\n                    }\n\n                    // Ensures that the binding processor doesn't try to bind the options\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor, allBindings) {\n                    function selectedOptions() {\n                        return ko.utils.arrayFilter(element.options, function (node) { return node.selected; });\n                    }\n\n                    var selectWasPreviouslyEmpty = element.length == 0,\n                        multiple = element.multiple,\n                        previousScrollTop = (!selectWasPreviouslyEmpty && multiple) ? element.scrollTop : null,\n                        unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n                        valueAllowUnset = allBindings.get('valueAllowUnset') && allBindings['has']('value'),\n                        includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n                        arrayToDomNodeChildrenOptions = {},\n                        captionValue,\n                        filteredArray,\n                        previousSelectedValues = [];\n\n                    if (!valueAllowUnset) {\n                        if (multiple) {\n                            previousSelectedValues = ko.utils.arrayMap(selectedOptions(), ko.selectExtensions.readValue);\n                        } else if (element.selectedIndex >= 0) {\n                            previousSelectedValues.push(ko.selectExtensions.readValue(element.options[element.selectedIndex]));\n                        }\n                    }\n\n                    if (unwrappedArray) {\n                        if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                            unwrappedArray = [unwrappedArray];\n\n                        // Filter out any entries marked as destroyed\n                        filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                            return includeDestroyed || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n                        });\n\n                        // If caption is included, add it to the array\n                        if (allBindings['has']('optionsCaption')) {\n                            captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                            // If caption value is null or undefined, don't show a caption\n                            if (captionValue !== null && captionValue !== undefined) {\n                                filteredArray.unshift(captionPlaceholder);\n                            }\n                        }\n                    } else {\n                        // If a falsy value is provided (e.g. null), we'll simply empty the select element\n                    }\n\n                    function applyToObject(object, predicate, defaultValue) {\n                        var predicateType = typeof predicate;\n                        if (predicateType == \"function\")    // Given a function; run it against the data value\n                            return predicate(object);\n                        else if (predicateType == \"string\") // Given a string; treat it as a property name on the data value\n                            return object[predicate];\n                        else                                // Given no optionsText arg; use the data value itself\n                            return defaultValue;\n                    }\n\n                    // The following functions can run at two different times:\n                    // The first is when the whole array is being updated directly from this binding handler.\n                    // The second is when an observable value for a specific array entry is updated.\n                    // oldOptions will be empty in the first case, but will be filled with the previously generated option in the second.\n                    var itemUpdate = false;\n                    function optionForArrayItem(arrayEntry, index, oldOptions) {\n                        if (oldOptions.length) {\n                            previousSelectedValues = !valueAllowUnset && oldOptions[0].selected ? [ ko.selectExtensions.readValue(oldOptions[0]) ] : [];\n                            itemUpdate = true;\n                        }\n                        var option = element.ownerDocument.createElement(\"option\");\n                        if (arrayEntry === captionPlaceholder) {\n                            ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                            ko.selectExtensions.writeValue(option, undefined);\n                        } else {\n                            // Apply a value to the option element\n                            var optionValue = applyToObject(arrayEntry, allBindings.get('optionsValue'), arrayEntry);\n                            ko.selectExtensions.writeValue(option, ko.utils.unwrapObservable(optionValue));\n\n                            // Apply some text to the option element\n                            var optionText = applyToObject(arrayEntry, allBindings.get('optionsText'), optionValue);\n                            ko.utils.setTextContent(option, optionText);\n                        }\n                        return [option];\n                    }\n\n                    // By using a beforeRemove callback, we delay the removal until after new items are added. This fixes a selection\n                    // problem in IE<=8 and Firefox. See https://github.com/knockout/knockout/issues/1208\n                    arrayToDomNodeChildrenOptions['beforeRemove'] =\n                        function (option) {\n                            element.removeChild(option);\n                        };\n\n                    function setSelectionCallback(arrayEntry, newOptions) {\n                        if (itemUpdate && valueAllowUnset) {\n                            // The model value is authoritative, so make sure its value is the one selected\n                            ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                        } else if (previousSelectedValues.length) {\n                            // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                            // That's why we first added them without selection. Now it's time to set the selection.\n                            var isSelected = ko.utils.arrayIndexOf(previousSelectedValues, ko.selectExtensions.readValue(newOptions[0])) >= 0;\n                            ko.utils.setOptionNodeSelectionState(newOptions[0], isSelected);\n\n                            // If this option was changed from being selected during a single-item update, notify the change\n                            if (itemUpdate && !isSelected) {\n                                ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                            }\n                        }\n                    }\n\n                    var callback = setSelectionCallback;\n                    if (allBindings['has']('optionsAfterRender') && typeof allBindings.get('optionsAfterRender') == \"function\") {\n                        callback = function(arrayEntry, newOptions) {\n                            setSelectionCallback(arrayEntry, newOptions);\n                            ko.dependencyDetection.ignore(allBindings.get('optionsAfterRender'), null, [newOptions[0], arrayEntry !== captionPlaceholder ? arrayEntry : undefined]);\n                        }\n                    }\n\n                    ko.utils.setDomNodeChildrenFromArrayMapping(element, filteredArray, optionForArrayItem, arrayToDomNodeChildrenOptions, callback);\n\n                    if (!valueAllowUnset) {\n                        // Determine if the selection has changed as a result of updating the options list\n                        var selectionChanged;\n                        if (multiple) {\n                            // For a multiple-select box, compare the new selection count to the previous one\n                            // But if nothing was selected before, the selection can't have changed\n                            selectionChanged = previousSelectedValues.length && selectedOptions().length < previousSelectedValues.length;\n                        } else {\n                            // For a single-select box, compare the current value to the previous value\n                            // But if nothing was selected before or nothing is selected now, just look for a change in selection\n                            selectionChanged = (previousSelectedValues.length && element.selectedIndex >= 0)\n                                ? (ko.selectExtensions.readValue(element.options[element.selectedIndex]) !== previousSelectedValues[0])\n                                : (previousSelectedValues.length || element.selectedIndex >= 0);\n                        }\n\n                        // Ensure consistency between model value and selected option.\n                        // If the dropdown was changed so that selection is no longer the same,\n                        // notify the value or selectedOptions binding.\n                        if (selectionChanged) {\n                            ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                        }\n                    }\n\n                    if (valueAllowUnset || ko.computedContext.isInitial()) {\n                        ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                    }\n\n                    // Workaround for IE bug\n                    ko.utils.ensureSelectElementIsRenderedCorrectly(element);\n\n                    if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20)\n                        element.scrollTop = previousScrollTop;\n                }\n            };\n            ko.bindingHandlers['options'].optionValueDomDataKey = ko.utils.domData.nextKey();\n            ko.bindingHandlers['selectedOptions'] = {\n                'init': function (element, valueAccessor, allBindings) {\n                    function updateFromView() {\n                        var value = valueAccessor(), valueToWrite = [];\n                        ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                            if (node.selected)\n                                valueToWrite.push(ko.selectExtensions.readValue(node));\n                        });\n                        ko.expressionRewriting.writeValueToProperty(value, allBindings, 'selectedOptions', valueToWrite);\n                    }\n\n                    function updateFromModel() {\n                        var newValue = ko.utils.unwrapObservable(valueAccessor()),\n                            previousScrollTop = element.scrollTop;\n\n                        if (newValue && typeof newValue.length == \"number\") {\n                            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                                var isSelected = ko.utils.arrayIndexOf(newValue, ko.selectExtensions.readValue(node)) >= 0;\n                                if (node.selected != isSelected) {      // This check prevents flashing of the select element in IE\n                                    ko.utils.setOptionNodeSelectionState(node, isSelected);\n                                }\n                            });\n                        }\n\n                        element.scrollTop = previousScrollTop;\n                    }\n\n                    if (ko.utils.tagNameLower(element) != \"select\") {\n                        throw new Error(\"selectedOptions binding applies only to SELECT elements\");\n                    }\n\n                    var updateFromModelComputed;\n                    ko.bindingEvent.subscribe(element, ko.bindingEvent.childrenComplete, function () {\n                        if (!updateFromModelComputed) {\n                            ko.utils.registerEventHandler(element, \"change\", updateFromView);\n                            updateFromModelComputed = ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                        } else {\n                            updateFromView();\n                        }\n                    }, null, { 'notifyImmediately': true });\n                },\n                'update': function() {} // Keep for backwards compatibility with code that may have wrapped binding\n            };\n            ko.expressionRewriting.twoWayBindings['selectedOptions'] = true;\n            ko.bindingHandlers['style'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor() || {});\n                    ko.utils.objectForEach(value, function(styleName, styleValue) {\n                        styleValue = ko.utils.unwrapObservable(styleValue);\n\n                        if (styleValue === null || styleValue === undefined || styleValue === false) {\n                            // Empty string removes the value, whereas null/undefined have no effect\n                            styleValue = \"\";\n                        }\n\n                        if (jQueryInstance) {\n                            jQueryInstance(element)['css'](styleName, styleValue);\n                        } else if (/^--/.test(styleName)) {\n                            // Is styleName a custom CSS property?\n                            element.style.setProperty(styleName, styleValue);\n                        } else {\n                            styleName = styleName.replace(/-(\\w)/g, function (all, letter) {\n                                return letter.toUpperCase();\n                            });\n\n                            var previousStyle = element.style[styleName];\n                            element.style[styleName] = styleValue;\n\n                            if (styleValue !== previousStyle && element.style[styleName] == previousStyle && !isNaN(styleValue)) {\n                                element.style[styleName] = styleValue + \"px\";\n                            }\n                        }\n                    });\n                }\n            };\n            ko.bindingHandlers['submit'] = {\n                'init': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    if (typeof valueAccessor() != \"function\")\n                        throw new Error(\"The value for a submit binding must be a function\");\n                    ko.utils.registerEventHandler(element, \"submit\", function (event) {\n                        var handlerReturnValue;\n                        var value = valueAccessor();\n                        try { handlerReturnValue = value.call(bindingContext['$data'], element); }\n                        finally {\n                            if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                                if (event.preventDefault)\n                                    event.preventDefault();\n                                else\n                                    event.returnValue = false;\n                            }\n                        }\n                    });\n                }\n            };\n            ko.bindingHandlers['text'] = {\n                'init': function() {\n                    // Prevent binding on the dynamically-injected text node (as developers are unlikely to expect that, and it has security implications).\n                    // It should also make things faster, as we no longer have to consider whether the text node might be bindable.\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor) {\n                    ko.utils.setTextContent(element, valueAccessor());\n                }\n            };\n            ko.virtualElements.allowedBindings['text'] = true;\n            (function () {\n\n                if (window && window.navigator) {\n                    var parseVersion = function (matches) {\n                        if (matches) {\n                            return parseFloat(matches[1]);\n                        }\n                    };\n\n                    // Detect various browser versions because some old versions don't fully support the 'input' event\n                    var userAgent = window.navigator.userAgent,\n                        operaVersion, chromeVersion, safariVersion, firefoxVersion, ieVersion, edgeVersion;\n\n                    (operaVersion = window.opera && window.opera.version && parseInt(window.opera.version()))\n                    || (edgeVersion = parseVersion(userAgent.match(/Edge\\/([^ ]+)$/)))\n                    || (chromeVersion = parseVersion(userAgent.match(/Chrome\\/([^ ]+)/)))\n                    || (safariVersion = parseVersion(userAgent.match(/Version\\/([^ ]+) Safari/)))\n                    || (firefoxVersion = parseVersion(userAgent.match(/Firefox\\/([^ ]+)/)))\n                    || (ieVersion = ko.utils.ieVersion || parseVersion(userAgent.match(/MSIE ([^ ]+)/)))      // Detects up to IE 10\n                    || (ieVersion = parseVersion(userAgent.match(/rv:([^ )]+)/)));      // Detects IE 11\n                }\n\n// IE 8 and 9 have bugs that prevent the normal events from firing when the value changes.\n// But it does fire the 'selectionchange' event on many of those, presumably because the\n// cursor is moving and that counts as the selection changing. The 'selectionchange' event is\n// fired at the document level only and doesn't directly indicate which element changed. We\n// set up just one event handler for the document and use 'activeElement' to determine which\n// element was changed.\n                if (ieVersion >= 8 && ieVersion < 10) {\n                    var selectionChangeRegisteredName = ko.utils.domData.nextKey(),\n                        selectionChangeHandlerName = ko.utils.domData.nextKey();\n                    var selectionChangeHandler = function(event) {\n                        var target = this.activeElement,\n                            handler = target && ko.utils.domData.get(target, selectionChangeHandlerName);\n                        if (handler) {\n                            handler(event);\n                        }\n                    };\n                    var registerForSelectionChangeEvent = function (element, handler) {\n                        var ownerDoc = element.ownerDocument;\n                        if (!ko.utils.domData.get(ownerDoc, selectionChangeRegisteredName)) {\n                            ko.utils.domData.set(ownerDoc, selectionChangeRegisteredName, true);\n                            ko.utils.registerEventHandler(ownerDoc, 'selectionchange', selectionChangeHandler);\n                        }\n                        ko.utils.domData.set(element, selectionChangeHandlerName, handler);\n                    };\n                }\n\n                ko.bindingHandlers['textInput'] = {\n                    'init': function (element, valueAccessor, allBindings) {\n\n                        var previousElementValue = element.value,\n                            timeoutHandle,\n                            elementValueBeforeEvent;\n\n                        var updateModel = function (event) {\n                            clearTimeout(timeoutHandle);\n                            elementValueBeforeEvent = timeoutHandle = undefined;\n\n                            var elementValue = element.value;\n                            if (previousElementValue !== elementValue) {\n                                // Provide a way for tests to know exactly which event was processed\n                                if (DEBUG && event) element['_ko_textInputProcessedEvent'] = event.type;\n                                previousElementValue = elementValue;\n                                ko.expressionRewriting.writeValueToProperty(valueAccessor(), allBindings, 'textInput', elementValue);\n                            }\n                        };\n\n                        var deferUpdateModel = function (event) {\n                            if (!timeoutHandle) {\n                                // The elementValueBeforeEvent variable is set *only* during the brief gap between an\n                                // event firing and the updateModel function running. This allows us to ignore model\n                                // updates that are from the previous state of the element, usually due to techniques\n                                // such as rateLimit. Such updates, if not ignored, can cause keystrokes to be lost.\n                                elementValueBeforeEvent = element.value;\n                                var handler = DEBUG ? updateModel.bind(element, {type: event.type}) : updateModel;\n                                timeoutHandle = ko.utils.setTimeout(handler, 4);\n                            }\n                        };\n\n                        // IE9 will mess up the DOM if you handle events synchronously which results in DOM changes (such as other bindings);\n                        // so we'll make sure all updates are asynchronous\n                        var ieUpdateModel = ko.utils.ieVersion == 9 ? deferUpdateModel : updateModel,\n                            ourUpdate = false;\n\n                        var updateView = function () {\n                            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                            if (modelValue === null || modelValue === undefined) {\n                                modelValue = '';\n                            }\n\n                            if (elementValueBeforeEvent !== undefined && modelValue === elementValueBeforeEvent) {\n                                ko.utils.setTimeout(updateView, 4);\n                                return;\n                            }\n\n                            // Update the element only if the element and model are different. On some browsers, updating the value\n                            // will move the cursor to the end of the input, which would be bad while the user is typing.\n                            if (element.value !== modelValue) {\n                                ourUpdate = true;  // Make sure we ignore events (propertychange) that result from updating the value\n                                element.value = modelValue;\n                                ourUpdate = false;\n                                previousElementValue = element.value; // In case the browser changes the value (see #2281)\n                            }\n                        };\n\n                        var onEvent = function (event, handler) {\n                            ko.utils.registerEventHandler(element, event, handler);\n                        };\n\n                        if (DEBUG && ko.bindingHandlers['textInput']['_forceUpdateOn']) {\n                            // Provide a way for tests to specify exactly which events are bound\n                            ko.utils.arrayForEach(ko.bindingHandlers['textInput']['_forceUpdateOn'], function(eventName) {\n                                if (eventName.slice(0,5) == 'after') {\n                                    onEvent(eventName.slice(5), deferUpdateModel);\n                                } else {\n                                    onEvent(eventName, updateModel);\n                                }\n                            });\n                        } else {\n                            if (ieVersion) {\n                                // All versions (including 11) of Internet Explorer have a bug that they don't generate an input or propertychange event when ESC is pressed\n                                onEvent('keypress', updateModel);\n                            }\n                            if (ieVersion < 11) {\n                                // Internet Explorer <= 8 doesn't support the 'input' event, but does include 'propertychange' that fires whenever\n                                // any property of an element changes. Unlike 'input', it also fires if a property is changed from JavaScript code,\n                                // but that's an acceptable compromise for this binding. IE 9 and 10 support 'input', but since they don't always\n                                // fire it when using autocomplete, we'll use 'propertychange' for them also.\n                                onEvent('propertychange', function(event) {\n                                    if (!ourUpdate && event.propertyName === 'value') {\n                                        ieUpdateModel(event);\n                                    }\n                                });\n                            }\n                            if (ieVersion == 8) {\n                                // IE 8 has a bug where it fails to fire 'propertychange' on the first update following a value change from\n                                // JavaScript code. It also doesn't fire if you clear the entire value. To fix this, we bind to the following\n                                // events too.\n                                onEvent('keyup', updateModel);      // A single keystoke\n                                onEvent('keydown', updateModel);    // The first character when a key is held down\n                            }\n                            if (registerForSelectionChangeEvent) {\n                                // Internet Explorer 9 doesn't fire the 'input' event when deleting text, including using\n                                // the backspace, delete, or ctrl-x keys, clicking the 'x' to clear the input, dragging text\n                                // out of the field, and cutting or deleting text using the context menu. 'selectionchange'\n                                // can detect all of those except dragging text out of the field, for which we use 'dragend'.\n                                // These are also needed in IE8 because of the bug described above.\n                                registerForSelectionChangeEvent(element, ieUpdateModel);  // 'selectionchange' covers cut, paste, drop, delete, etc.\n                                onEvent('dragend', deferUpdateModel);\n                            }\n\n                            if (!ieVersion || ieVersion >= 9) {\n                                // All other supported browsers support the 'input' event, which fires whenever the content of the element is changed\n                                // through the user interface.\n                                onEvent('input', ieUpdateModel);\n                            }\n\n                            if (safariVersion < 5 && ko.utils.tagNameLower(element) === \"textarea\") {\n                                // Safari <5 doesn't fire the 'input' event for <textarea> elements (it does fire 'textInput'\n                                // but only when typing). So we'll just catch as much as we can with keydown, cut, and paste.\n                                onEvent('keydown', deferUpdateModel);\n                                onEvent('paste', deferUpdateModel);\n                                onEvent('cut', deferUpdateModel);\n                            } else if (operaVersion < 11) {\n                                // Opera 10 doesn't always fire the 'input' event for cut, paste, undo & drop operations.\n                                // We can try to catch some of those using 'keydown'.\n                                onEvent('keydown', deferUpdateModel);\n                            } else if (firefoxVersion < 4.0) {\n                                // Firefox <= 3.6 doesn't fire the 'input' event when text is filled in through autocomplete\n                                onEvent('DOMAutoComplete', updateModel);\n\n                                // Firefox <=3.5 doesn't fire the 'input' event when text is dropped into the input.\n                                onEvent('dragdrop', updateModel);       // <3.5\n                                onEvent('drop', updateModel);           // 3.5\n                            } else if (edgeVersion && element.type === \"number\") {\n                                // Microsoft Edge doesn't fire 'input' or 'change' events for number inputs when\n                                // the value is changed via the up / down arrow keys\n                                onEvent('keydown', deferUpdateModel);\n                            }\n                        }\n\n                        // Bind to the change event so that we can catch programmatic updates of the value that fire this event.\n                        onEvent('change', updateModel);\n\n                        // To deal with browsers that don't notify any kind of event for some changes (IE, Safari, etc.)\n                        onEvent('blur', updateModel);\n\n                        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n                    }\n                };\n                ko.expressionRewriting.twoWayBindings['textInput'] = true;\n\n// textinput is an alias for textInput\n                ko.bindingHandlers['textinput'] = {\n                    // preprocess is the only way to set up a full alias\n                    'preprocess': function (value, name, addBinding) {\n                        addBinding('textInput', value);\n                    }\n                };\n\n            })();ko.bindingHandlers['uniqueName'] = {\n                'init': function (element, valueAccessor) {\n                    if (valueAccessor()) {\n                        var name = \"ko_unique_\" + (++ko.bindingHandlers['uniqueName'].currentIndex);\n                        ko.utils.setElementName(element, name);\n                    }\n                }\n            };\n            ko.bindingHandlers['uniqueName'].currentIndex = 0;\n            ko.bindingHandlers['using'] = {\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    var options;\n\n                    if (allBindings['has']('as')) {\n                        options = { 'as': allBindings.get('as'), 'noChildContext': allBindings.get('noChildContext') };\n                    }\n\n                    var innerContext = bindingContext['createChildContext'](valueAccessor, options);\n                    ko.applyBindingsToDescendants(innerContext, element);\n\n                    return { 'controlsDescendantBindings': true };\n                }\n            };\n            ko.virtualElements.allowedBindings['using'] = true;\n            ko.bindingHandlers['value'] = {\n                'init': function (element, valueAccessor, allBindings) {\n                    var tagName = ko.utils.tagNameLower(element),\n                        isInputElement = tagName == \"input\";\n\n                    // If the value binding is placed on a radio/checkbox, then just pass through to checkedValue and quit\n                    if (isInputElement && (element.type == \"checkbox\" || element.type == \"radio\")) {\n                        ko.applyBindingAccessorsToNode(element, { 'checkedValue': valueAccessor });\n                        return;\n                    }\n\n                    var eventsToCatch = [];\n                    var requestedEventsToCatch = allBindings.get(\"valueUpdate\");\n                    var propertyChangedFired = false;\n                    var elementValueBeforeEvent = null;\n\n                    if (requestedEventsToCatch) {\n                        // Allow both individual event names, and arrays of event names\n                        if (typeof requestedEventsToCatch == \"string\") {\n                            eventsToCatch = [requestedEventsToCatch];\n                        } else {\n                            eventsToCatch = ko.utils.arrayGetDistinctValues(requestedEventsToCatch);\n                        }\n                        ko.utils.arrayRemoveItem(eventsToCatch, \"change\");  // We'll subscribe to \"change\" events later\n                    }\n\n                    var valueUpdateHandler = function() {\n                        elementValueBeforeEvent = null;\n                        propertyChangedFired = false;\n                        var modelValue = valueAccessor();\n                        var elementValue = ko.selectExtensions.readValue(element);\n                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'value', elementValue);\n                    }\n\n                    // Workaround for https://github.com/SteveSanderson/knockout/issues/122\n                    // IE doesn't fire \"change\" events on textboxes if the user selects a value from its autocomplete list\n                    var ieAutoCompleteHackNeeded = ko.utils.ieVersion && isInputElement && element.type == \"text\"\n                        && element.autocomplete != \"off\" && (!element.form || element.form.autocomplete != \"off\");\n                    if (ieAutoCompleteHackNeeded && ko.utils.arrayIndexOf(eventsToCatch, \"propertychange\") == -1) {\n                        ko.utils.registerEventHandler(element, \"propertychange\", function () { propertyChangedFired = true });\n                        ko.utils.registerEventHandler(element, \"focus\", function () { propertyChangedFired = false });\n                        ko.utils.registerEventHandler(element, \"blur\", function() {\n                            if (propertyChangedFired) {\n                                valueUpdateHandler();\n                            }\n                        });\n                    }\n\n                    ko.utils.arrayForEach(eventsToCatch, function(eventName) {\n                        // The syntax \"after<eventname>\" means \"run the handler asynchronously after the event\"\n                        // This is useful, for example, to catch \"keydown\" events after the browser has updated the control\n                        // (otherwise, ko.selectExtensions.readValue(this) will receive the control's value *before* the key event)\n                        var handler = valueUpdateHandler;\n                        if (ko.utils.stringStartsWith(eventName, \"after\")) {\n                            handler = function() {\n                                // The elementValueBeforeEvent variable is non-null *only* during the brief gap between\n                                // a keyX event firing and the valueUpdateHandler running, which is scheduled to happen\n                                // at the earliest asynchronous opportunity. We store this temporary information so that\n                                // if, between keyX and valueUpdateHandler, the underlying model value changes separately,\n                                // we can overwrite that model value change with the value the user just typed. Otherwise,\n                                // techniques like rateLimit can trigger model changes at critical moments that will\n                                // override the user's inputs, causing keystrokes to be lost.\n                                elementValueBeforeEvent = ko.selectExtensions.readValue(element);\n                                ko.utils.setTimeout(valueUpdateHandler, 0);\n                            };\n                            eventName = eventName.substring(\"after\".length);\n                        }\n                        ko.utils.registerEventHandler(element, eventName, handler);\n                    });\n\n                    var updateFromModel;\n\n                    if (isInputElement && element.type == \"file\") {\n                        // For file input elements, can only write the empty string\n                        updateFromModel = function () {\n                            var newValue = ko.utils.unwrapObservable(valueAccessor());\n                            if (newValue === null || newValue === undefined || newValue === \"\") {\n                                element.value = \"\";\n                            } else {\n                                ko.dependencyDetection.ignore(valueUpdateHandler);  // reset the model to match the element\n                            }\n                        }\n                    } else {\n                        updateFromModel = function () {\n                            var newValue = ko.utils.unwrapObservable(valueAccessor());\n                            var elementValue = ko.selectExtensions.readValue(element);\n\n                            if (elementValueBeforeEvent !== null && newValue === elementValueBeforeEvent) {\n                                ko.utils.setTimeout(updateFromModel, 0);\n                                return;\n                            }\n\n                            var valueHasChanged = newValue !== elementValue;\n\n                            if (valueHasChanged || elementValue === undefined) {\n                                if (tagName === \"select\") {\n                                    var allowUnset = allBindings.get('valueAllowUnset');\n                                    ko.selectExtensions.writeValue(element, newValue, allowUnset);\n                                    if (!allowUnset && newValue !== ko.selectExtensions.readValue(element)) {\n                                        // If you try to set a model value that can't be represented in an already-populated dropdown, reject that change,\n                                        // because you're not allowed to have a model value that disagrees with a visible UI selection.\n                                        ko.dependencyDetection.ignore(valueUpdateHandler);\n                                    }\n                                } else {\n                                    ko.selectExtensions.writeValue(element, newValue);\n                                }\n                            }\n                        };\n                    }\n\n                    if (tagName === \"select\") {\n                        var updateFromModelComputed;\n                        ko.bindingEvent.subscribe(element, ko.bindingEvent.childrenComplete, function () {\n                            if (!updateFromModelComputed) {\n                                ko.utils.registerEventHandler(element, \"change\", valueUpdateHandler);\n                                updateFromModelComputed = ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                            } else if (allBindings.get('valueAllowUnset')) {\n                                updateFromModel();\n                            } else {\n                                valueUpdateHandler();\n                            }\n                        }, null, { 'notifyImmediately': true });\n                    } else {\n                        ko.utils.registerEventHandler(element, \"change\", valueUpdateHandler);\n                        ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                    }\n                },\n                'update': function() {} // Keep for backwards compatibility with code that may have wrapped value binding\n            };\n            ko.expressionRewriting.twoWayBindings['value'] = true;\n            ko.bindingHandlers['visible'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    var isCurrentlyVisible = !(element.style.display == \"none\");\n                    if (value && !isCurrentlyVisible)\n                        element.style.display = \"\";\n                    else if ((!value) && isCurrentlyVisible)\n                        element.style.display = \"none\";\n                }\n            };\n\n            ko.bindingHandlers['hidden'] = {\n                'update': function (element, valueAccessor) {\n                    ko.bindingHandlers['visible']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n                }\n            };\n// 'click' is just a shorthand for the usual full-length event:{click:handler}\n            makeEventHandlerShortcut('click');\n// If you want to make a custom template engine,\n//\n// [1] Inherit from this class (like ko.nativeTemplateEngine does)\n// [2] Override 'renderTemplateSource', supplying a function with this signature:\n//\n//        function (templateSource, bindingContext, options) {\n//            // - templateSource.text() is the text of the template you should render\n//            // - bindingContext.$data is the data you should pass into the template\n//            //   - you might also want to make bindingContext.$parent, bindingContext.$parents,\n//            //     and bindingContext.$root available in the template too\n//            // - options gives you access to any other properties set on \"data-bind: { template: options }\"\n//            // - templateDocument is the document object of the template\n//            //\n//            // Return value: an array of DOM nodes\n//        }\n//\n// [3] Override 'createJavaScriptEvaluatorBlock', supplying a function with this signature:\n//\n//        function (script) {\n//            // Return value: Whatever syntax means \"Evaluate the JavaScript statement 'script' and output the result\"\n//            //               For example, the jquery.tmpl template engine converts 'someScript' to '${ someScript }'\n//        }\n//\n//     This is only necessary if you want to allow data-bind attributes to reference arbitrary template variables.\n//     If you don't want to allow that, you can set the property 'allowTemplateRewriting' to false (like ko.nativeTemplateEngine does)\n//     and then you don't need to override 'createJavaScriptEvaluatorBlock'.\n\n            ko.templateEngine = function () { };\n\n            ko.templateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n                throw new Error(\"Override renderTemplateSource\");\n            };\n\n            ko.templateEngine.prototype['createJavaScriptEvaluatorBlock'] = function (script) {\n                throw new Error(\"Override createJavaScriptEvaluatorBlock\");\n            };\n\n            ko.templateEngine.prototype['makeTemplateSource'] = function(template, templateDocument) {\n                // Named template\n                if (typeof template == \"string\") {\n                    templateDocument = templateDocument || document;\n                    var elem = templateDocument.getElementById(template);\n                    if (!elem)\n                        throw new Error(\"Cannot find template with ID \" + template);\n                    return new ko.templateSources.domElement(elem);\n                } else if ((template.nodeType == 1) || (template.nodeType == 8)) {\n                    // Anonymous template\n                    return new ko.templateSources.anonymousTemplate(template);\n                } else\n                    throw new Error(\"Unknown template type: \" + template);\n            };\n\n            ko.templateEngine.prototype['renderTemplate'] = function (template, bindingContext, options, templateDocument) {\n                var templateSource = this['makeTemplateSource'](template, templateDocument);\n                return this['renderTemplateSource'](templateSource, bindingContext, options, templateDocument);\n            };\n\n            ko.templateEngine.prototype['isTemplateRewritten'] = function (template, templateDocument) {\n                // Skip rewriting if requested\n                if (this['allowTemplateRewriting'] === false)\n                    return true;\n                return this['makeTemplateSource'](template, templateDocument)['data'](\"isRewritten\");\n            };\n\n            ko.templateEngine.prototype['rewriteTemplate'] = function (template, rewriterCallback, templateDocument) {\n                var templateSource = this['makeTemplateSource'](template, templateDocument);\n                var rewritten = rewriterCallback(templateSource['text']());\n                templateSource['text'](rewritten);\n                templateSource['data'](\"isRewritten\", true);\n            };\n\n            ko.exportSymbol('templateEngine', ko.templateEngine);\n\n            ko.templateRewriting = (function () {\n                var memoizeDataBindingAttributeSyntaxRegex = /(<([a-z]+\\d*)(?:\\s+(?!data-bind\\s*=\\s*)[a-z0-9\\-]+(?:=(?:\\\"[^\\\"]*\\\"|\\'[^\\']*\\'|[^>]*))?)*\\s+)data-bind\\s*=\\s*([\"'])([\\s\\S]*?)\\3/gi;\n                var memoizeVirtualContainerBindingSyntaxRegex = /<!--\\s*ko\\b\\s*([\\s\\S]*?)\\s*-->/g;\n\n                function validateDataBindValuesForRewriting(keyValueArray) {\n                    var allValidators = ko.expressionRewriting.bindingRewriteValidators;\n                    for (var i = 0; i < keyValueArray.length; i++) {\n                        var key = keyValueArray[i]['key'];\n                        if (Object.prototype.hasOwnProperty.call(allValidators, key)) {\n                            var validator = allValidators[key];\n\n                            if (typeof validator === \"function\") {\n                                var possibleErrorMessage = validator(keyValueArray[i]['value']);\n                                if (possibleErrorMessage)\n                                    throw new Error(possibleErrorMessage);\n                            } else if (!validator) {\n                                throw new Error(\"This template engine does not support the '\" + key + \"' binding within its templates\");\n                            }\n                        }\n                    }\n                }\n\n                function constructMemoizedTagReplacement(dataBindAttributeValue, tagToRetain, nodeName, templateEngine) {\n                    var dataBindKeyValueArray = ko.expressionRewriting.parseObjectLiteral(dataBindAttributeValue);\n                    validateDataBindValuesForRewriting(dataBindKeyValueArray);\n                    var rewrittenDataBindAttributeValue = ko.expressionRewriting.preProcessBindings(dataBindKeyValueArray, {'valueAccessors':true});\n\n                    // For no obvious reason, Opera fails to evaluate rewrittenDataBindAttributeValue unless it's wrapped in an additional\n                    // anonymous function, even though Opera's built-in debugger can evaluate it anyway. No other browser requires this\n                    // extra indirection.\n                    var applyBindingsToNextSiblingScript =\n                        \"ko.__tr_ambtns(function($context,$element){return(function(){return{ \" + rewrittenDataBindAttributeValue + \" } })()},'\" + nodeName.toLowerCase() + \"')\";\n                    return templateEngine['createJavaScriptEvaluatorBlock'](applyBindingsToNextSiblingScript) + tagToRetain;\n                }\n\n                return {\n                    ensureTemplateIsRewritten: function (template, templateEngine, templateDocument) {\n                        if (!templateEngine['isTemplateRewritten'](template, templateDocument))\n                            templateEngine['rewriteTemplate'](template, function (htmlString) {\n                                return ko.templateRewriting.memoizeBindingAttributeSyntax(htmlString, templateEngine);\n                            }, templateDocument);\n                    },\n\n                    memoizeBindingAttributeSyntax: function (htmlString, templateEngine) {\n                        return htmlString.replace(memoizeDataBindingAttributeSyntaxRegex, function () {\n                            return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[4], /* tagToRetain: */ arguments[1], /* nodeName: */ arguments[2], templateEngine);\n                        }).replace(memoizeVirtualContainerBindingSyntaxRegex, function() {\n                            return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[1], /* tagToRetain: */ \"<!-- ko -->\", /* nodeName: */ \"#comment\", templateEngine);\n                        });\n                    },\n\n                    applyMemoizedBindingsToNextSibling: function (bindings, nodeName) {\n                        return ko.memoization.memoize(function (domNode, bindingContext) {\n                            var nodeToBind = domNode.nextSibling;\n                            if (nodeToBind && nodeToBind.nodeName.toLowerCase() === nodeName) {\n                                ko.applyBindingAccessorsToNode(nodeToBind, bindings, bindingContext);\n                            }\n                        });\n                    }\n                }\n            })();\n\n\n// Exported only because it has to be referenced by string lookup from within rewritten template\n            ko.exportSymbol('__tr_ambtns', ko.templateRewriting.applyMemoizedBindingsToNextSibling);\n            (function() {\n                // A template source represents a read/write way of accessing a template. This is to eliminate the need for template loading/saving\n                // logic to be duplicated in every template engine (and means they can all work with anonymous templates, etc.)\n                //\n                // Two are provided by default:\n                //  1. ko.templateSources.domElement       - reads/writes the text content of an arbitrary DOM element\n                //  2. ko.templateSources.anonymousElement - uses ko.utils.domData to read/write text *associated* with the DOM element, but\n                //                                           without reading/writing the actual element text content, since it will be overwritten\n                //                                           with the rendered template output.\n                // You can implement your own template source if you want to fetch/store templates somewhere other than in DOM elements.\n                // Template sources need to have the following functions:\n                //   text() \t\t\t- returns the template text from your storage location\n                //   text(value)\t\t- writes the supplied template text to your storage location\n                //   data(key)\t\t\t- reads values stored using data(key, value) - see below\n                //   data(key, value)\t- associates \"value\" with this template and the key \"key\". Is used to store information like \"isRewritten\".\n                //\n                // Optionally, template sources can also have the following functions:\n                //   nodes()            - returns a DOM element containing the nodes of this template, where available\n                //   nodes(value)       - writes the given DOM element to your storage location\n                // If a DOM element is available for a given template source, template engines are encouraged to use it in preference over text()\n                // for improved speed. However, all templateSources must supply text() even if they don't supply nodes().\n                //\n                // Once you've implemented a templateSource, make your template engine use it by subclassing whatever template engine you were\n                // using and overriding \"makeTemplateSource\" to return an instance of your custom template source.\n\n                ko.templateSources = {};\n\n                // ---- ko.templateSources.domElement -----\n\n                // template types\n                var templateScript = 1,\n                    templateTextArea = 2,\n                    templateTemplate = 3,\n                    templateElement = 4;\n\n                ko.templateSources.domElement = function(element) {\n                    this.domElement = element;\n\n                    if (element) {\n                        var tagNameLower = ko.utils.tagNameLower(element);\n                        this.templateType =\n                            tagNameLower === \"script\" ? templateScript :\n                                tagNameLower === \"textarea\" ? templateTextArea :\n                                    // For browsers with proper <template> element support, where the .content property gives a document fragment\n                                    tagNameLower == \"template\" && element.content && element.content.nodeType === 11 ? templateTemplate :\n                                        templateElement;\n                    }\n                }\n\n                ko.templateSources.domElement.prototype['text'] = function(/* valueToWrite */) {\n                    var elemContentsProperty = this.templateType === templateScript ? \"text\"\n                        : this.templateType === templateTextArea ? \"value\"\n                            : \"innerHTML\";\n\n                    if (arguments.length == 0) {\n                        return this.domElement[elemContentsProperty];\n                    } else {\n                        var valueToWrite = arguments[0];\n                        if (elemContentsProperty === \"innerHTML\")\n                            ko.utils.setHtml(this.domElement, valueToWrite);\n                        else\n                            this.domElement[elemContentsProperty] = valueToWrite;\n                    }\n                };\n\n                var dataDomDataPrefix = ko.utils.domData.nextKey() + \"_\";\n                ko.templateSources.domElement.prototype['data'] = function(key /*, valueToWrite */) {\n                    if (arguments.length === 1) {\n                        return ko.utils.domData.get(this.domElement, dataDomDataPrefix + key);\n                    } else {\n                        ko.utils.domData.set(this.domElement, dataDomDataPrefix + key, arguments[1]);\n                    }\n                };\n\n                var templatesDomDataKey = ko.utils.domData.nextKey();\n                function getTemplateDomData(element) {\n                    return ko.utils.domData.get(element, templatesDomDataKey) || {};\n                }\n                function setTemplateDomData(element, data) {\n                    ko.utils.domData.set(element, templatesDomDataKey, data);\n                }\n\n                ko.templateSources.domElement.prototype['nodes'] = function(/* valueToWrite */) {\n                    var element = this.domElement;\n                    if (arguments.length == 0) {\n                        var templateData = getTemplateDomData(element),\n                            nodes = templateData.containerData || (\n                                this.templateType === templateTemplate ? element.content :\n                                    this.templateType === templateElement ? element :\n                                        undefined);\n                        if (!nodes || templateData.alwaysCheckText) {\n                            // If the template is associated with an element that stores the template as text,\n                            // parse and cache the nodes whenever there's new text content available. This allows\n                            // the user to update the template content by updating the text of template node.\n                            var text = this['text']();\n                            if (text && text !== templateData.textData) {\n                                nodes = ko.utils.parseHtmlForTemplateNodes(text, element.ownerDocument);\n                                setTemplateDomData(element, {containerData: nodes, textData: text, alwaysCheckText: true});\n                            }\n                        }\n                        return nodes;\n                    } else {\n                        var valueToWrite = arguments[0];\n                        if (this.templateType !== undefined) {\n                            this['text'](\"\");   // clear the text from the node\n                        }\n                        setTemplateDomData(element, {containerData: valueToWrite});\n                    }\n                };\n\n                // ---- ko.templateSources.anonymousTemplate -----\n                // Anonymous templates are normally saved/retrieved as DOM nodes through \"nodes\".\n                // For compatibility, you can also read \"text\"; it will be serialized from the nodes on demand.\n                // Writing to \"text\" is still supported, but then the template data will not be available as DOM nodes.\n\n                ko.templateSources.anonymousTemplate = function(element) {\n                    this.domElement = element;\n                }\n                ko.templateSources.anonymousTemplate.prototype = new ko.templateSources.domElement();\n                ko.templateSources.anonymousTemplate.prototype.constructor = ko.templateSources.anonymousTemplate;\n                ko.templateSources.anonymousTemplate.prototype['text'] = function(/* valueToWrite */) {\n                    if (arguments.length == 0) {\n                        var templateData = getTemplateDomData(this.domElement);\n                        if (templateData.textData === undefined && templateData.containerData)\n                            templateData.textData = templateData.containerData.innerHTML;\n                        return templateData.textData;\n                    } else {\n                        var valueToWrite = arguments[0];\n                        setTemplateDomData(this.domElement, {textData: valueToWrite});\n                    }\n                };\n\n                ko.exportSymbol('templateSources', ko.templateSources);\n                ko.exportSymbol('templateSources.domElement', ko.templateSources.domElement);\n                ko.exportSymbol('templateSources.anonymousTemplate', ko.templateSources.anonymousTemplate);\n            })();\n            (function () {\n                var _templateEngine;\n                ko.setTemplateEngine = function (templateEngine) {\n                    if ((templateEngine != undefined) && !(templateEngine instanceof ko.templateEngine))\n                        throw new Error(\"templateEngine must inherit from ko.templateEngine\");\n                    _templateEngine = templateEngine;\n                }\n\n                function invokeForEachNodeInContinuousRange(firstNode, lastNode, action) {\n                    var node, nextInQueue = firstNode, firstOutOfRangeNode = ko.virtualElements.nextSibling(lastNode);\n                    while (nextInQueue && ((node = nextInQueue) !== firstOutOfRangeNode)) {\n                        nextInQueue = ko.virtualElements.nextSibling(node);\n                        action(node, nextInQueue);\n                    }\n                }\n\n                function activateBindingsOnContinuousNodeArray(continuousNodeArray, bindingContext) {\n                    // To be used on any nodes that have been rendered by a template and have been inserted into some parent element\n                    // Walks through continuousNodeArray (which *must* be continuous, i.e., an uninterrupted sequence of sibling nodes, because\n                    // the algorithm for walking them relies on this), and for each top-level item in the virtual-element sense,\n                    // (1) Does a regular \"applyBindings\" to associate bindingContext with this node and to activate any non-memoized bindings\n                    // (2) Unmemoizes any memos in the DOM subtree (e.g., to activate bindings that had been memoized during template rewriting)\n\n                    if (continuousNodeArray.length) {\n                        var firstNode = continuousNodeArray[0],\n                            lastNode = continuousNodeArray[continuousNodeArray.length - 1],\n                            parentNode = firstNode.parentNode,\n                            provider = ko.bindingProvider['instance'],\n                            preprocessNode = provider['preprocessNode'];\n\n                        if (preprocessNode) {\n                            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node, nextNodeInRange) {\n                                var nodePreviousSibling = node.previousSibling;\n                                var newNodes = preprocessNode.call(provider, node);\n                                if (newNodes) {\n                                    if (node === firstNode)\n                                        firstNode = newNodes[0] || nextNodeInRange;\n                                    if (node === lastNode)\n                                        lastNode = newNodes[newNodes.length - 1] || nodePreviousSibling;\n                                }\n                            });\n\n                            // Because preprocessNode can change the nodes, including the first and last nodes, update continuousNodeArray to match.\n                            // We need the full set, including inner nodes, because the unmemoize step might remove the first node (and so the real\n                            // first node needs to be in the array).\n                            continuousNodeArray.length = 0;\n                            if (!firstNode) { // preprocessNode might have removed all the nodes, in which case there's nothing left to do\n                                return;\n                            }\n                            if (firstNode === lastNode) {\n                                continuousNodeArray.push(firstNode);\n                            } else {\n                                continuousNodeArray.push(firstNode, lastNode);\n                                ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                            }\n                        }\n\n                        // Need to applyBindings *before* unmemoziation, because unmemoization might introduce extra nodes (that we don't want to re-bind)\n                        // whereas a regular applyBindings won't introduce new memoized nodes\n                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                            if (node.nodeType === 1 || node.nodeType === 8)\n                                ko.applyBindings(bindingContext, node);\n                        });\n                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                            if (node.nodeType === 1 || node.nodeType === 8)\n                                ko.memoization.unmemoizeDomNodeAndDescendants(node, [bindingContext]);\n                        });\n\n                        // Make sure any changes done by applyBindings or unmemoize are reflected in the array\n                        ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                    }\n                }\n\n                function getFirstNodeFromPossibleArray(nodeOrNodeArray) {\n                    return nodeOrNodeArray.nodeType ? nodeOrNodeArray\n                        : nodeOrNodeArray.length > 0 ? nodeOrNodeArray[0]\n                            : null;\n                }\n\n                function executeTemplate(targetNodeOrNodeArray, renderMode, template, bindingContext, options) {\n                    options = options || {};\n                    var firstTargetNode = targetNodeOrNodeArray && getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                    var templateDocument = (firstTargetNode || template || {}).ownerDocument;\n                    var templateEngineToUse = (options['templateEngine'] || _templateEngine);\n                    ko.templateRewriting.ensureTemplateIsRewritten(template, templateEngineToUse, templateDocument);\n                    var renderedNodesArray = templateEngineToUse['renderTemplate'](template, bindingContext, options, templateDocument);\n\n                    // Loosely check result is an array of DOM nodes\n                    if ((typeof renderedNodesArray.length != \"number\") || (renderedNodesArray.length > 0 && typeof renderedNodesArray[0].nodeType != \"number\"))\n                        throw new Error(\"Template engine must return an array of DOM nodes\");\n\n                    var haveAddedNodesToParent = false;\n                    switch (renderMode) {\n                        case \"replaceChildren\":\n                            ko.virtualElements.setDomNodeChildren(targetNodeOrNodeArray, renderedNodesArray);\n                            haveAddedNodesToParent = true;\n                            break;\n                        case \"replaceNode\":\n                            ko.utils.replaceDomNodes(targetNodeOrNodeArray, renderedNodesArray);\n                            haveAddedNodesToParent = true;\n                            break;\n                        case \"ignoreTargetNode\": break;\n                        default:\n                            throw new Error(\"Unknown renderMode: \" + renderMode);\n                    }\n\n                    if (haveAddedNodesToParent) {\n                        activateBindingsOnContinuousNodeArray(renderedNodesArray, bindingContext);\n                        if (options['afterRender']) {\n                            ko.dependencyDetection.ignore(options['afterRender'], null, [renderedNodesArray, bindingContext[options['as'] || '$data']]);\n                        }\n                        if (renderMode == \"replaceChildren\") {\n                            ko.bindingEvent.notify(targetNodeOrNodeArray, ko.bindingEvent.childrenComplete);\n                        }\n                    }\n\n                    return renderedNodesArray;\n                }\n\n                function resolveTemplateName(template, data, context) {\n                    // The template can be specified as:\n                    if (ko.isObservable(template)) {\n                        // 1. An observable, with string value\n                        return template();\n                    } else if (typeof template === 'function') {\n                        // 2. A function of (data, context) returning a string\n                        return template(data, context);\n                    } else {\n                        // 3. A string\n                        return template;\n                    }\n                }\n\n                ko.renderTemplate = function (template, dataOrBindingContext, options, targetNodeOrNodeArray, renderMode) {\n                    options = options || {};\n                    if ((options['templateEngine'] || _templateEngine) == undefined)\n                        throw new Error(\"Set a template engine before calling renderTemplate\");\n                    renderMode = renderMode || \"replaceChildren\";\n\n                    if (targetNodeOrNodeArray) {\n                        var firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n\n                        var whenToDispose = function () { return (!firstTargetNode) || !ko.utils.domNodeIsAttachedToDocument(firstTargetNode); }; // Passive disposal (on next evaluation)\n                        var activelyDisposeWhenNodeIsRemoved = (firstTargetNode && renderMode == \"replaceNode\") ? firstTargetNode.parentNode : firstTargetNode;\n\n                        return ko.dependentObservable( // So the DOM is automatically updated when any dependency changes\n                            function () {\n                                // Ensure we've got a proper binding context to work with\n                                var bindingContext = (dataOrBindingContext && (dataOrBindingContext instanceof ko.bindingContext))\n                                    ? dataOrBindingContext\n                                    : new ko.bindingContext(dataOrBindingContext, null, null, null, { \"exportDependencies\": true });\n\n                                var templateName = resolveTemplateName(template, bindingContext['$data'], bindingContext),\n                                    renderedNodesArray = executeTemplate(targetNodeOrNodeArray, renderMode, templateName, bindingContext, options);\n\n                                if (renderMode == \"replaceNode\") {\n                                    targetNodeOrNodeArray = renderedNodesArray;\n                                    firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                                }\n                            },\n                            null,\n                            { disposeWhen: whenToDispose, disposeWhenNodeIsRemoved: activelyDisposeWhenNodeIsRemoved }\n                        );\n                    } else {\n                        // We don't yet have a DOM node to evaluate, so use a memo and render the template later when there is a DOM node\n                        return ko.memoization.memoize(function (domNode) {\n                            ko.renderTemplate(template, dataOrBindingContext, options, domNode, \"replaceNode\");\n                        });\n                    }\n                };\n\n                ko.renderTemplateForEach = function (template, arrayOrObservableArray, options, targetNode, parentBindingContext) {\n                    // Since setDomNodeChildrenFromArrayMapping always calls executeTemplateForArrayItem and then\n                    // activateBindingsCallback for added items, we can store the binding context in the former to use in the latter.\n                    var arrayItemContext, asName = options['as'];\n\n                    // This will be called by setDomNodeChildrenFromArrayMapping to get the nodes to add to targetNode\n                    var executeTemplateForArrayItem = function (arrayValue, index) {\n                        // Support selecting template as a function of the data being rendered\n                        arrayItemContext = parentBindingContext['createChildContext'](arrayValue, {\n                            'as': asName,\n                            'noChildContext': options['noChildContext'],\n                            'extend': function(context) {\n                                context['$index'] = index;\n                                if (asName) {\n                                    context[asName + \"Index\"] = index;\n                                }\n                            }\n                        });\n\n                        var templateName = resolveTemplateName(template, arrayValue, arrayItemContext);\n                        return executeTemplate(targetNode, \"ignoreTargetNode\", templateName, arrayItemContext, options);\n                    };\n\n                    // This will be called whenever setDomNodeChildrenFromArrayMapping has added nodes to targetNode\n                    var activateBindingsCallback = function(arrayValue, addedNodesArray, index) {\n                        activateBindingsOnContinuousNodeArray(addedNodesArray, arrayItemContext);\n                        if (options['afterRender'])\n                            options['afterRender'](addedNodesArray, arrayValue);\n\n                        // release the \"cache\" variable, so that it can be collected by\n                        // the GC when its value isn't used from within the bindings anymore.\n                        arrayItemContext = null;\n                    };\n\n                    var setDomNodeChildrenFromArrayMapping = function (newArray, changeList) {\n                        // Call setDomNodeChildrenFromArrayMapping, ignoring any observables unwrapped within (most likely from a callback function).\n                        // If the array items are observables, though, they will be unwrapped in executeTemplateForArrayItem and managed within setDomNodeChildrenFromArrayMapping.\n                        ko.dependencyDetection.ignore(ko.utils.setDomNodeChildrenFromArrayMapping, null, [targetNode, newArray, executeTemplateForArrayItem, options, activateBindingsCallback, changeList]);\n                        ko.bindingEvent.notify(targetNode, ko.bindingEvent.childrenComplete);\n                    };\n\n                    var shouldHideDestroyed = (options['includeDestroyed'] === false) || (ko.options['foreachHidesDestroyed'] && !options['includeDestroyed']);\n\n                    if (!shouldHideDestroyed && !options['beforeRemove'] && ko.isObservableArray(arrayOrObservableArray)) {\n                        setDomNodeChildrenFromArrayMapping(arrayOrObservableArray.peek());\n\n                        var subscription = arrayOrObservableArray.subscribe(function (changeList) {\n                            setDomNodeChildrenFromArrayMapping(arrayOrObservableArray(), changeList);\n                        }, null, \"arrayChange\");\n                        subscription.disposeWhenNodeIsRemoved(targetNode);\n\n                        return subscription;\n                    } else {\n                        return ko.dependentObservable(function () {\n                            var unwrappedArray = ko.utils.unwrapObservable(arrayOrObservableArray) || [];\n                            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                                unwrappedArray = [unwrappedArray];\n\n                            if (shouldHideDestroyed) {\n                                // Filter out any entries marked as destroyed\n                                unwrappedArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                                    return item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n                                });\n                            }\n                            setDomNodeChildrenFromArrayMapping(unwrappedArray);\n\n                        }, null, { disposeWhenNodeIsRemoved: targetNode });\n                    }\n                };\n\n                var templateComputedDomDataKey = ko.utils.domData.nextKey();\n                function disposeOldComputedAndStoreNewOne(element, newComputed) {\n                    var oldComputed = ko.utils.domData.get(element, templateComputedDomDataKey);\n                    if (oldComputed && (typeof(oldComputed.dispose) == 'function'))\n                        oldComputed.dispose();\n                    ko.utils.domData.set(element, templateComputedDomDataKey, (newComputed && (!newComputed.isActive || newComputed.isActive())) ? newComputed : undefined);\n                }\n\n                var cleanContainerDomDataKey = ko.utils.domData.nextKey();\n                ko.bindingHandlers['template'] = {\n                    'init': function(element, valueAccessor) {\n                        // Support anonymous templates\n                        var bindingValue = ko.utils.unwrapObservable(valueAccessor());\n                        if (typeof bindingValue == \"string\" || 'name' in bindingValue) {\n                            // It's a named template - clear the element\n                            ko.virtualElements.emptyNode(element);\n                        } else if ('nodes' in bindingValue) {\n                            // We've been given an array of DOM nodes. Save them as the template source.\n                            // There is no known use case for the node array being an observable array (if the output\n                            // varies, put that behavior *into* your template - that's what templates are for), and\n                            // the implementation would be a mess, so assert that it's not observable.\n                            var nodes = bindingValue['nodes'] || [];\n                            if (ko.isObservable(nodes)) {\n                                throw new Error('The \"nodes\" option must be a plain, non-observable array.');\n                            }\n\n                            // If the nodes are already attached to a KO-generated container, we reuse that container without moving the\n                            // elements to a new one (we check only the first node, as the nodes are always moved together)\n                            var container = nodes[0] && nodes[0].parentNode;\n                            if (!container || !ko.utils.domData.get(container, cleanContainerDomDataKey)) {\n                                container = ko.utils.moveCleanedNodesToContainerElement(nodes);\n                                ko.utils.domData.set(container, cleanContainerDomDataKey, true);\n                            }\n\n                            new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n                        } else {\n                            // It's an anonymous template - store the element contents, then clear the element\n                            var templateNodes = ko.virtualElements.childNodes(element);\n                            if (templateNodes.length > 0) {\n                                var container = ko.utils.moveCleanedNodesToContainerElement(templateNodes); // This also removes the nodes from their current parent\n                                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n                            } else {\n                                throw new Error(\"Anonymous template defined, but no template content was provided\");\n                            }\n                        }\n                        return { 'controlsDescendantBindings': true };\n                    },\n                    'update': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                        var value = valueAccessor(),\n                            options = ko.utils.unwrapObservable(value),\n                            shouldDisplay = true,\n                            templateComputed = null,\n                            template;\n\n                        if (typeof options == \"string\") {\n                            template = value;\n                            options = {};\n                        } else {\n                            template = 'name' in options ? options['name'] : element;\n\n                            // Support \"if\"/\"ifnot\" conditions\n                            if ('if' in options)\n                                shouldDisplay = ko.utils.unwrapObservable(options['if']);\n                            if (shouldDisplay && 'ifnot' in options)\n                                shouldDisplay = !ko.utils.unwrapObservable(options['ifnot']);\n\n                            // Don't show anything if an empty name is given (see #2446)\n                            if (shouldDisplay && !template) {\n                                shouldDisplay = false;\n                            }\n                        }\n\n                        if ('foreach' in options) {\n                            // Render once for each data point (treating data set as empty if shouldDisplay==false)\n                            var dataArray = (shouldDisplay && options['foreach']) || [];\n                            templateComputed = ko.renderTemplateForEach(template, dataArray, options, element, bindingContext);\n                        } else if (!shouldDisplay) {\n                            ko.virtualElements.emptyNode(element);\n                        } else {\n                            // Render once for this single data point (or use the viewModel if no data was provided)\n                            var innerBindingContext = bindingContext;\n                            if ('data' in options) {\n                                innerBindingContext = bindingContext['createChildContext'](options['data'], {\n                                    'as': options['as'],\n                                    'noChildContext': options['noChildContext'],\n                                    'exportDependencies': true\n                                });\n                            }\n                            templateComputed = ko.renderTemplate(template, innerBindingContext, options, element);\n                        }\n\n                        // It only makes sense to have a single template computed per element (otherwise which one should have its output displayed?)\n                        disposeOldComputedAndStoreNewOne(element, templateComputed);\n                    }\n                };\n\n                // Anonymous templates can't be rewritten. Give a nice error message if you try to do it.\n                ko.expressionRewriting.bindingRewriteValidators['template'] = function(bindingValue) {\n                    var parsedBindingValue = ko.expressionRewriting.parseObjectLiteral(bindingValue);\n\n                    if ((parsedBindingValue.length == 1) && parsedBindingValue[0]['unknown'])\n                        return null; // It looks like a string literal, not an object literal, so treat it as a named template (which is allowed for rewriting)\n\n                    if (ko.expressionRewriting.keyValueArrayContainsKey(parsedBindingValue, \"name\"))\n                        return null; // Named templates can be rewritten, so return \"no error\"\n                    return \"This template engine does not support anonymous templates nested within its templates\";\n                };\n\n                ko.virtualElements.allowedBindings['template'] = true;\n            })();\n\n            ko.exportSymbol('setTemplateEngine', ko.setTemplateEngine);\n            ko.exportSymbol('renderTemplate', ko.renderTemplate);\n// Go through the items that have been added and deleted and try to find matches between them.\n            ko.utils.findMovesInArrayComparison = function (left, right, limitFailedCompares) {\n                if (left.length && right.length) {\n                    var failedCompares, l, r, leftItem, rightItem;\n                    for (failedCompares = l = 0; (!limitFailedCompares || failedCompares < limitFailedCompares) && (leftItem = left[l]); ++l) {\n                        for (r = 0; rightItem = right[r]; ++r) {\n                            if (leftItem['value'] === rightItem['value']) {\n                                leftItem['moved'] = rightItem['index'];\n                                rightItem['moved'] = leftItem['index'];\n                                right.splice(r, 1);         // This item is marked as moved; so remove it from right list\n                                failedCompares = r = 0;     // Reset failed compares count because we're checking for consecutive failures\n                                break;\n                            }\n                        }\n                        failedCompares += r;\n                    }\n                }\n            };\n\n            ko.utils.compareArrays = (function () {\n                var statusNotInOld = 'added', statusNotInNew = 'deleted';\n\n                // Simple calculation based on Levenshtein distance.\n                function compareArrays(oldArray, newArray, options) {\n                    // For backward compatibility, if the third arg is actually a bool, interpret\n                    // it as the old parameter 'dontLimitMoves'. Newer code should use { dontLimitMoves: true }.\n                    options = (typeof options === 'boolean') ? { 'dontLimitMoves': options } : (options || {});\n                    oldArray = oldArray || [];\n                    newArray = newArray || [];\n\n                    if (oldArray.length < newArray.length)\n                        return compareSmallArrayToBigArray(oldArray, newArray, statusNotInOld, statusNotInNew, options);\n                    else\n                        return compareSmallArrayToBigArray(newArray, oldArray, statusNotInNew, statusNotInOld, options);\n                }\n\n                function compareSmallArrayToBigArray(smlArray, bigArray, statusNotInSml, statusNotInBig, options) {\n                    var myMin = Math.min,\n                        myMax = Math.max,\n                        editDistanceMatrix = [],\n                        smlIndex, smlIndexMax = smlArray.length,\n                        bigIndex, bigIndexMax = bigArray.length,\n                        compareRange = (bigIndexMax - smlIndexMax) || 1,\n                        maxDistance = smlIndexMax + bigIndexMax + 1,\n                        thisRow, lastRow,\n                        bigIndexMaxForRow, bigIndexMinForRow;\n\n                    for (smlIndex = 0; smlIndex <= smlIndexMax; smlIndex++) {\n                        lastRow = thisRow;\n                        editDistanceMatrix.push(thisRow = []);\n                        bigIndexMaxForRow = myMin(bigIndexMax, smlIndex + compareRange);\n                        bigIndexMinForRow = myMax(0, smlIndex - 1);\n                        for (bigIndex = bigIndexMinForRow; bigIndex <= bigIndexMaxForRow; bigIndex++) {\n                            if (!bigIndex)\n                                thisRow[bigIndex] = smlIndex + 1;\n                            else if (!smlIndex)  // Top row - transform empty array into new array via additions\n                                thisRow[bigIndex] = bigIndex + 1;\n                            else if (smlArray[smlIndex - 1] === bigArray[bigIndex - 1])\n                                thisRow[bigIndex] = lastRow[bigIndex - 1];                  // copy value (no edit)\n                            else {\n                                var northDistance = lastRow[bigIndex] || maxDistance;       // not in big (deletion)\n                                var westDistance = thisRow[bigIndex - 1] || maxDistance;    // not in small (addition)\n                                thisRow[bigIndex] = myMin(northDistance, westDistance) + 1;\n                            }\n                        }\n                    }\n\n                    var editScript = [], meMinusOne, notInSml = [], notInBig = [];\n                    for (smlIndex = smlIndexMax, bigIndex = bigIndexMax; smlIndex || bigIndex;) {\n                        meMinusOne = editDistanceMatrix[smlIndex][bigIndex] - 1;\n                        if (bigIndex && meMinusOne === editDistanceMatrix[smlIndex][bigIndex-1]) {\n                            notInSml.push(editScript[editScript.length] = {     // added\n                                'status': statusNotInSml,\n                                'value': bigArray[--bigIndex],\n                                'index': bigIndex });\n                        } else if (smlIndex && meMinusOne === editDistanceMatrix[smlIndex - 1][bigIndex]) {\n                            notInBig.push(editScript[editScript.length] = {     // deleted\n                                'status': statusNotInBig,\n                                'value': smlArray[--smlIndex],\n                                'index': smlIndex });\n                        } else {\n                            --bigIndex;\n                            --smlIndex;\n                            if (!options['sparse']) {\n                                editScript.push({\n                                    'status': \"retained\",\n                                    'value': bigArray[bigIndex] });\n                            }\n                        }\n                    }\n\n                    // Set a limit on the number of consecutive non-matching comparisons; having it a multiple of\n                    // smlIndexMax keeps the time complexity of this algorithm linear.\n                    ko.utils.findMovesInArrayComparison(notInBig, notInSml, !options['dontLimitMoves'] && smlIndexMax * 10);\n\n                    return editScript.reverse();\n                }\n\n                return compareArrays;\n            })();\n\n            ko.exportSymbol('utils.compareArrays', ko.utils.compareArrays);\n            (function () {\n                // Objective:\n                // * Given an input array, a container DOM node, and a function from array elements to arrays of DOM nodes,\n                //   map the array elements to arrays of DOM nodes, concatenate together all these arrays, and use them to populate the container DOM node\n                // * Next time we're given the same combination of things (with the array possibly having mutated), update the container DOM node\n                //   so that its children is again the concatenation of the mappings of the array elements, but don't re-map any array elements that we\n                //   previously mapped - retain those nodes, and just insert/delete other ones\n\n                // \"callbackAfterAddingNodes\" will be invoked after any \"mapping\"-generated nodes are inserted into the container node\n                // You can use this, for example, to activate bindings on those nodes.\n\n                function mapNodeAndRefreshWhenChanged(containerNode, mapping, valueToMap, callbackAfterAddingNodes, index) {\n                    // Map this array value inside a dependentObservable so we re-map when any dependency changes\n                    var mappedNodes = [];\n                    var dependentObservable = ko.dependentObservable(function() {\n                        var newMappedNodes = mapping(valueToMap, index, ko.utils.fixUpContinuousNodeArray(mappedNodes, containerNode)) || [];\n\n                        // On subsequent evaluations, just replace the previously-inserted DOM nodes\n                        if (mappedNodes.length > 0) {\n                            ko.utils.replaceDomNodes(mappedNodes, newMappedNodes);\n                            if (callbackAfterAddingNodes)\n                                ko.dependencyDetection.ignore(callbackAfterAddingNodes, null, [valueToMap, newMappedNodes, index]);\n                        }\n\n                        // Replace the contents of the mappedNodes array, thereby updating the record\n                        // of which nodes would be deleted if valueToMap was itself later removed\n                        mappedNodes.length = 0;\n                        ko.utils.arrayPushAll(mappedNodes, newMappedNodes);\n                    }, null, { disposeWhenNodeIsRemoved: containerNode, disposeWhen: function() { return !ko.utils.anyDomNodeIsAttachedToDocument(mappedNodes); } });\n                    return { mappedNodes : mappedNodes, dependentObservable : (dependentObservable.isActive() ? dependentObservable : undefined) };\n                }\n\n                var lastMappingResultDomDataKey = ko.utils.domData.nextKey(),\n                    deletedItemDummyValue = ko.utils.domData.nextKey();\n\n                ko.utils.setDomNodeChildrenFromArrayMapping = function (domNode, array, mapping, options, callbackAfterAddingNodes, editScript) {\n                    array = array || [];\n                    if (typeof array.length == \"undefined\") // Coerce single value into array\n                        array = [array];\n\n                    options = options || {};\n                    var lastMappingResult = ko.utils.domData.get(domNode, lastMappingResultDomDataKey);\n                    var isFirstExecution = !lastMappingResult;\n\n                    // Build the new mapping result\n                    var newMappingResult = [];\n                    var lastMappingResultIndex = 0;\n                    var currentArrayIndex = 0;\n\n                    var nodesToDelete = [];\n                    var itemsToMoveFirstIndexes = [];\n                    var itemsForBeforeRemoveCallbacks = [];\n                    var itemsForMoveCallbacks = [];\n                    var itemsForAfterAddCallbacks = [];\n                    var mapData;\n                    var countWaitingForRemove = 0;\n\n                    function itemAdded(value) {\n                        mapData = { arrayEntry: value, indexObservable: ko.observable(currentArrayIndex++) };\n                        newMappingResult.push(mapData);\n                        if (!isFirstExecution) {\n                            itemsForAfterAddCallbacks.push(mapData);\n                        }\n                    }\n\n                    function itemMovedOrRetained(oldPosition) {\n                        mapData = lastMappingResult[oldPosition];\n                        if (currentArrayIndex !== mapData.indexObservable.peek())\n                            itemsForMoveCallbacks.push(mapData);\n                        // Since updating the index might change the nodes, do so before calling fixUpContinuousNodeArray\n                        mapData.indexObservable(currentArrayIndex++);\n                        ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode);\n                        newMappingResult.push(mapData);\n                    }\n\n                    function callCallback(callback, items) {\n                        if (callback) {\n                            for (var i = 0, n = items.length; i < n; i++) {\n                                ko.utils.arrayForEach(items[i].mappedNodes, function(node) {\n                                    callback(node, i, items[i].arrayEntry);\n                                });\n                            }\n                        }\n                    }\n\n                    if (isFirstExecution) {\n                        ko.utils.arrayForEach(array, itemAdded);\n                    } else {\n                        if (!editScript || (lastMappingResult && lastMappingResult['_countWaitingForRemove'])) {\n                            // Compare the provided array against the previous one\n                            var lastArray = ko.utils.arrayMap(lastMappingResult, function (x) { return x.arrayEntry; }),\n                                compareOptions = {\n                                    'dontLimitMoves': options['dontLimitMoves'],\n                                    'sparse': true\n                                };\n                            editScript = ko.utils.compareArrays(lastArray, array, compareOptions);\n                        }\n\n                        for (var i = 0, editScriptItem, movedIndex, itemIndex; editScriptItem = editScript[i]; i++) {\n                            movedIndex = editScriptItem['moved'];\n                            itemIndex = editScriptItem['index'];\n                            switch (editScriptItem['status']) {\n                                case \"deleted\":\n                                    while (lastMappingResultIndex < itemIndex) {\n                                        itemMovedOrRetained(lastMappingResultIndex++);\n                                    }\n                                    if (movedIndex === undefined) {\n                                        mapData = lastMappingResult[lastMappingResultIndex];\n\n                                        // Stop tracking changes to the mapping for these nodes\n                                        if (mapData.dependentObservable) {\n                                            mapData.dependentObservable.dispose();\n                                            mapData.dependentObservable = undefined;\n                                        }\n\n                                        // Queue these nodes for later removal\n                                        if (ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode).length) {\n                                            if (options['beforeRemove']) {\n                                                newMappingResult.push(mapData);\n                                                countWaitingForRemove++;\n                                                if (mapData.arrayEntry === deletedItemDummyValue) {\n                                                    mapData = null;\n                                                } else {\n                                                    itemsForBeforeRemoveCallbacks.push(mapData);\n                                                }\n                                            }\n                                            if (mapData) {\n                                                nodesToDelete.push.apply(nodesToDelete, mapData.mappedNodes);\n                                            }\n                                        }\n                                    }\n                                    lastMappingResultIndex++;\n                                    break;\n\n                                case \"added\":\n                                    while (currentArrayIndex < itemIndex) {\n                                        itemMovedOrRetained(lastMappingResultIndex++);\n                                    }\n                                    if (movedIndex !== undefined) {\n                                        itemsToMoveFirstIndexes.push(newMappingResult.length);\n                                        itemMovedOrRetained(movedIndex);\n                                    } else {\n                                        itemAdded(editScriptItem['value']);\n                                    }\n                                    break;\n                            }\n                        }\n\n                        while (currentArrayIndex < array.length) {\n                            itemMovedOrRetained(lastMappingResultIndex++);\n                        }\n\n                        // Record that the current view may still contain deleted items\n                        // because it means we won't be able to use a provided editScript.\n                        newMappingResult['_countWaitingForRemove'] = countWaitingForRemove;\n                    }\n\n                    // Store a copy of the array items we just considered so we can difference it next time\n                    ko.utils.domData.set(domNode, lastMappingResultDomDataKey, newMappingResult);\n\n                    // Call beforeMove first before any changes have been made to the DOM\n                    callCallback(options['beforeMove'], itemsForMoveCallbacks);\n\n                    // Next remove nodes for deleted items (or just clean if there's a beforeRemove callback)\n                    ko.utils.arrayForEach(nodesToDelete, options['beforeRemove'] ? ko.cleanNode : ko.removeNode);\n\n                    var i, j, lastNode, nodeToInsert, mappedNodes, activeElement;\n\n                    // Since most browsers remove the focus from an element when it's moved to another location,\n                    // save the focused element and try to restore it later.\n                    try {\n                        activeElement = domNode.ownerDocument.activeElement;\n                    } catch(e) {\n                        // IE9 throws if you access activeElement during page load (see issue #703)\n                    }\n\n                    // Try to reduce overall moved nodes by first moving the ones that were marked as moved by the edit script\n                    if (itemsToMoveFirstIndexes.length) {\n                        while ((i = itemsToMoveFirstIndexes.shift()) != undefined) {\n                            mapData = newMappingResult[i];\n                            for (lastNode = undefined; i; ) {\n                                if ((mappedNodes = newMappingResult[--i].mappedNodes) && mappedNodes.length) {\n                                    lastNode = mappedNodes[mappedNodes.length-1];\n                                    break;\n                                }\n                            }\n                            for (j = 0; nodeToInsert = mapData.mappedNodes[j]; lastNode = nodeToInsert, j++) {\n                                ko.virtualElements.insertAfter(domNode, nodeToInsert, lastNode);\n                            }\n                        }\n                    }\n\n                    // Next add/reorder the remaining items (will include deleted items if there's a beforeRemove callback)\n                    for (i = 0; mapData = newMappingResult[i]; i++) {\n                        // Get nodes for newly added items\n                        if (!mapData.mappedNodes)\n                            ko.utils.extend(mapData, mapNodeAndRefreshWhenChanged(domNode, mapping, mapData.arrayEntry, callbackAfterAddingNodes, mapData.indexObservable));\n\n                        // Put nodes in the right place if they aren't there already\n                        for (j = 0; nodeToInsert = mapData.mappedNodes[j]; lastNode = nodeToInsert, j++) {\n                            ko.virtualElements.insertAfter(domNode, nodeToInsert, lastNode);\n                        }\n\n                        // Run the callbacks for newly added nodes (for example, to apply bindings, etc.)\n                        if (!mapData.initialized && callbackAfterAddingNodes) {\n                            callbackAfterAddingNodes(mapData.arrayEntry, mapData.mappedNodes, mapData.indexObservable);\n                            mapData.initialized = true;\n                            lastNode = mapData.mappedNodes[mapData.mappedNodes.length - 1];     // get the last node again since it may have been changed by a preprocessor\n                        }\n                    }\n\n                    // Restore the focused element if it had lost focus\n                    if (activeElement && domNode.ownerDocument.activeElement != activeElement) {\n                        activeElement.focus();\n                    }\n\n                    // If there's a beforeRemove callback, call it after reordering.\n                    // Note that we assume that the beforeRemove callback will usually be used to remove the nodes using\n                    // some sort of animation, which is why we first reorder the nodes that will be removed. If the\n                    // callback instead removes the nodes right away, it would be more efficient to skip reordering them.\n                    // Perhaps we'll make that change in the future if this scenario becomes more common.\n                    callCallback(options['beforeRemove'], itemsForBeforeRemoveCallbacks);\n\n                    // Replace the stored values of deleted items with a dummy value. This provides two benefits: it marks this item\n                    // as already \"removed\" so we won't call beforeRemove for it again, and it ensures that the item won't match up\n                    // with an actual item in the array and appear as \"retained\" or \"moved\".\n                    for (i = 0; i < itemsForBeforeRemoveCallbacks.length; ++i) {\n                        itemsForBeforeRemoveCallbacks[i].arrayEntry = deletedItemDummyValue;\n                    }\n\n                    // Finally call afterMove and afterAdd callbacks\n                    callCallback(options['afterMove'], itemsForMoveCallbacks);\n                    callCallback(options['afterAdd'], itemsForAfterAddCallbacks);\n                }\n            })();\n\n            ko.exportSymbol('utils.setDomNodeChildrenFromArrayMapping', ko.utils.setDomNodeChildrenFromArrayMapping);\n            ko.nativeTemplateEngine = function () {\n                this['allowTemplateRewriting'] = false;\n            }\n\n            ko.nativeTemplateEngine.prototype = new ko.templateEngine();\n            ko.nativeTemplateEngine.prototype.constructor = ko.nativeTemplateEngine;\n            ko.nativeTemplateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n                var useNodesIfAvailable = !(ko.utils.ieVersion < 9), // IE<9 cloneNode doesn't work properly\n                    templateNodesFunc = useNodesIfAvailable ? templateSource['nodes'] : null,\n                    templateNodes = templateNodesFunc ? templateSource['nodes']() : null;\n\n                if (templateNodes) {\n                    return ko.utils.makeArray(templateNodes.cloneNode(true).childNodes);\n                } else {\n                    var templateText = templateSource['text']();\n                    return ko.utils.parseHtmlFragment(templateText, templateDocument);\n                }\n            };\n\n            ko.nativeTemplateEngine.instance = new ko.nativeTemplateEngine();\n            ko.setTemplateEngine(ko.nativeTemplateEngine.instance);\n\n            ko.exportSymbol('nativeTemplateEngine', ko.nativeTemplateEngine);\n            (function() {\n                ko.jqueryTmplTemplateEngine = function () {\n                    // Detect which version of jquery-tmpl you're using. Unfortunately jquery-tmpl\n                    // doesn't expose a version number, so we have to infer it.\n                    // Note that as of Knockout 1.3, we only support jQuery.tmpl 1.0.0pre and later,\n                    // which KO internally refers to as version \"2\", so older versions are no longer detected.\n                    var jQueryTmplVersion = this.jQueryTmplVersion = (function() {\n                        if (!jQueryInstance || !(jQueryInstance['tmpl']))\n                            return 0;\n                        // Since it exposes no official version number, we use our own numbering system. To be updated as jquery-tmpl evolves.\n                        try {\n                            if (jQueryInstance['tmpl']['tag']['tmpl']['open'].toString().indexOf('__') >= 0) {\n                                // Since 1.0.0pre, custom tags should append markup to an array called \"__\"\n                                return 2; // Final version of jquery.tmpl\n                            }\n                        } catch(ex) { /* Apparently not the version we were looking for */ }\n\n                        return 1; // Any older version that we don't support\n                    })();\n\n                    function ensureHasReferencedJQueryTemplates() {\n                        if (jQueryTmplVersion < 2)\n                            throw new Error(\"Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.\");\n                    }\n\n                    function executeTemplate(compiledTemplate, data, jQueryTemplateOptions) {\n                        return jQueryInstance['tmpl'](compiledTemplate, data, jQueryTemplateOptions);\n                    }\n\n                    this['renderTemplateSource'] = function(templateSource, bindingContext, options, templateDocument) {\n                        templateDocument = templateDocument || document;\n                        options = options || {};\n                        ensureHasReferencedJQueryTemplates();\n\n                        // Ensure we have stored a precompiled version of this template (don't want to reparse on every render)\n                        var precompiled = templateSource['data']('precompiled');\n                        if (!precompiled) {\n                            var templateText = templateSource['text']() || \"\";\n                            // Wrap in \"with($whatever.koBindingContext) { ... }\"\n                            templateText = \"{{ko_with $item.koBindingContext}}\" + templateText + \"{{/ko_with}}\";\n\n                            precompiled = jQueryInstance['template'](null, templateText);\n                            templateSource['data']('precompiled', precompiled);\n                        }\n\n                        var data = [bindingContext['$data']]; // Prewrap the data in an array to stop jquery.tmpl from trying to unwrap any arrays\n                        var jQueryTemplateOptions = jQueryInstance['extend']({ 'koBindingContext': bindingContext }, options['templateOptions']);\n\n                        var resultNodes = executeTemplate(precompiled, data, jQueryTemplateOptions);\n                        resultNodes['appendTo'](templateDocument.createElement(\"div\")); // Using \"appendTo\" forces jQuery/jQuery.tmpl to perform necessary cleanup work\n\n                        jQueryInstance['fragments'] = {}; // Clear jQuery's fragment cache to avoid a memory leak after a large number of template renders\n                        return resultNodes;\n                    };\n\n                    this['createJavaScriptEvaluatorBlock'] = function(script) {\n                        return \"{{ko_code ((function() { return \" + script + \" })()) }}\";\n                    };\n\n                    this['addTemplate'] = function(templateName, templateMarkup) {\n                        document.write(\"<script type='text/html' id='\" + templateName + \"'>\" + templateMarkup + \"<\" + \"/script>\");\n                    };\n\n                    if (jQueryTmplVersion > 0) {\n                        jQueryInstance['tmpl']['tag']['ko_code'] = {\n                            open: \"__.push($1 || '');\"\n                        };\n                        jQueryInstance['tmpl']['tag']['ko_with'] = {\n                            open: \"with($1) {\",\n                            close: \"} \"\n                        };\n                    }\n                };\n\n                ko.jqueryTmplTemplateEngine.prototype = new ko.templateEngine();\n                ko.jqueryTmplTemplateEngine.prototype.constructor = ko.jqueryTmplTemplateEngine;\n\n                // Use this one by default *only if jquery.tmpl is referenced*\n                var jqueryTmplTemplateEngineInstance = new ko.jqueryTmplTemplateEngine();\n                if (jqueryTmplTemplateEngineInstance.jQueryTmplVersion > 0)\n                    ko.setTemplateEngine(jqueryTmplTemplateEngineInstance);\n\n                ko.exportSymbol('jqueryTmplTemplateEngine', ko.jqueryTmplTemplateEngine);\n            })();\n        }));\n    }());\n})();\n","Amasty_Reports/vendor/amcharts4/animated.min.js":"/**\n * @license\n * Copyright (c) 2018 amCharts (Antanas Marcelionis, Martynas Majeris)\n *\n * This sofware is provided under multiple licenses. Please see below for\n * links to appropriate usage.\n *\n * Free amCharts linkware license. Details and conditions:\n * https://github.com/amcharts/amcharts4/blob/master/LICENSE\n *\n * One of the amCharts commercial licenses. Details and pricing:\n * https://www.amcharts.com/online-store/\n * https://www.amcharts.com/online-store/licenses-explained/\n *\n * If in doubt, contact amCharts at contact@amcharts.com\n *\n * PLEASE DO NOT REMOVE THIS COPYRIGHT NOTICE.\n * @hidden\n */\nam4internal_webpackJsonp([\"ab45\"],{lhmh:function(t,e,a){\"use strict\";Object.defineProperty(e,\"__esModule\",{value:!0});var i=a(\"01H4\"),n=function(t){Object(i.a)(t,\"SpriteState\")&&(t.transitionDuration=400),Object(i.a)(t,\"Component\")&&(t.rangeChangeDuration=700,t.interpolationDuration=700,t.sequencedInterpolation=!1,Object(i.a)(t,\"SankeyDiagram\")&&(t.sequencedInterpolation=!0),Object(i.a)(t,\"FunnelSeries\")&&(t.sequencedInterpolation=!0)),Object(i.a)(t,\"Chart\")&&(t.defaultState.transitionDuration=2e3,t.hiddenState.transitionDuration=1e3),Object(i.a)(t,\"Tooltip\")&&(t.animationDuration=400,t.defaultState.transitionDuration=400,t.hiddenState.transitionDuration=400),Object(i.a)(t,\"Scrollbar\")&&(t.animationDuration=700),Object(i.a)(t,\"Series\")&&(t.defaultState.transitionDuration=1e3,t.hiddenState.transitionDuration=700,t.hiddenState.properties.opacity=1,t.showOnInit=!0),Object(i.a)(t,\"MapSeries\")&&(t.hiddenState.properties.opacity=0),Object(i.a)(t,\"PercentSeries\")&&(t.hiddenState.properties.opacity=0),Object(i.a)(t,\"FunnelSlice\")&&(t.defaultState.transitionDuration=800,t.hiddenState.transitionDuration=1e3,t.hiddenState.properties.opacity=1),Object(i.a)(t,\"Slice\")&&(t.defaultState.transitionDuration=700,t.hiddenState.transitionDuration=1e3,t.hiddenState.properties.opacity=1),Object(i.a)(t,\"Preloader\")&&(t.hiddenState.transitionDuration=2e3),Object(i.a)(t,\"Column\")&&(t.defaultState.transitionDuration=700,t.hiddenState.transitionDuration=1e3,t.hiddenState.properties.opacity=1),Object(i.a)(t,\"Column3D\")&&(t.hiddenState.properties.opacity=0)};window.am4themes_animated=n}},[\"lhmh\"]);\n//# sourceMappingURL=animated.js.map"}
}});
