<?php

namespace Amasty\Xnotif\Api\Analytics;

use Amasty\Xnotif\Api\Analytics\Data\StockInterface;

/**
 * @api
 */
interface StockRepositoryInterface
{
    /**
     * Save
     *
     * @param StockInterface $stock
     * @return StockInterface
     */
    public function save(StockInterface $stock);

    /**
     * Get by id
     *
     * @param int $id
     * @return StockInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($id);

    /**
     * Delete
     *
     * @param StockInterface $stock
     * @return bool true on success
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(StockInterface $stock);

    /**
     * Delete by id
     *
     * @param int $id
     * @return bool true on success
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($id);

    /**
     * Lists
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \Magento\Framework\Api\SearchResultsInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria);
}
