<?php
/**
 * Frenet Shipping Gateway
 *
 * @category Frenet
 *
 * @author Tiago Sampaio <tiago@tiagosampaio.com>
 * @link https://github.com/tiagosampaio
 * @link https://tiagosampaio.com
 *
 * Copyright (c) 2020.
 */

declare(strict_types = 1);

namespace Frenet\Shipping\Model\Formatters;

/**
 * Class PostcodeNormalizer
 */
class PostcodeNormalizer
{
    /**
     * @param string $postcode
     *
     * @return string
     */
    public function format(string $postcode = null)
    {
        $postcode = preg_replace('/[^0-9]/', "", "".$postcode);
        $postcode = str_pad($postcode, 8, '0', STR_PAD_LEFT);

        return $postcode;
    }
}
