<?php
/**
 * Solucoes
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Solucoes.com license that is
 * available through the world-wide-web at this URL:
 * https://www.solucoes.com/LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Solucoes
 * @package     Solucoes_BannerSlider
 * @copyright   Copyright (c) Solucoes (https://www.solucoes.com/)
 * @license     https://www.solucoes.com/LICENSE.txt
 */

namespace Solucoes\BannerSlider\Controller\Adminhtml\Slider;

use Exception;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Helper\Js;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Registry;
use Magento\Framework\Stdlib\DateTime\Filter\Date;
use Solucoes\BannerSlider\Controller\Adminhtml\Slider;
use Solucoes\BannerSlider\Model\SliderFactory;
use RuntimeException;
use Zend_Filter_Input;

/**
 * Class Save
 * @package Solucoes\BannerSlider\Controller\Adminhtml\Slider
 */
class Save extends Slider
{
    /**
     * JS helper
     *
     * @var Js
     */
    protected $jsHelper;

    /**
     * Date filter
     *
     * @var Date
     */
    protected $_dateFilter;

    /**
     * Save constructor.
     *
     * @param Js $jsHelper
     * @param SliderFactory $sliderFactory
     * @param Registry $registry
     * @param Context $context
     * @param Date $dateFilter
     */
    public function __construct(
        Js $jsHelper,
        SliderFactory $sliderFactory,
        Registry $registry,
        Context $context,
        Date $dateFilter
    ) {
        $this->jsHelper = $jsHelper;
        $this->_dateFilter = $dateFilter;

        parent::__construct($sliderFactory, $registry, $context);
    }

    /**
     * @return ResponseInterface|Redirect|ResultInterface
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();

        if ($this->getRequest()->getPost('slider')) {
            $data = $this->_filterData($this->getRequest()->getPost('slider'));
            $slider = $this->initSlider();

            $banners = $this->getRequest()->getPost('banners', -1);
            if ($banners != -1) {
                $slider->setBannersData($this->jsHelper->decodeGridSerializedInput($banners));
            }
            $slider->addData($data);

            $this->_eventManager->dispatch(
                'mpbannerslider_slider_prepare_save',
                [
                    'slider'  => $slider,
                    'request' => $this->getRequest()
                ]
            );

            try {
                $slider->save();
                $this->messageManager->addSuccess(__('The Slider has been saved.'));
                $this->_session->setSolucoesBannerSliderSliderData(false);
                if ($this->getRequest()->getParam('back')) {
                    $resultRedirect->setPath(
                        'mpbannerslider/*/edit',
                        [
                            'slider_id' => $slider->getId(),
                            '_current'  => true
                        ]
                    );

                    return $resultRedirect;
                }
                $resultRedirect->setPath('mpbannerslider/*/');

                return $resultRedirect;
            } catch (RuntimeException $e) {
                $this->messageManager->addError($e->getMessage());
            } catch (Exception $e) {
                $this->messageManager->addException($e, __('Something went wrong while saving the Slider.'));
            }

            $this->_getSession()->setSolucoesBannerSliderSliderData($data);
            $resultRedirect->setPath(
                'mpbannerslider/*/edit',
                [
                    'slider_id' => $slider->getId(),
                    '_current'  => true
                ]
            );

            return $resultRedirect;
        }

        $resultRedirect->setPath('mpbannerslider/*/');

        return $resultRedirect;
    }

    /**
     * filter values
     *
     * @param array $data
     *
     * @return array
     */
    protected function _filterData($data)
    {
        $inputFilter = new Zend_Filter_Input(['from_date' => $this->_dateFilter,], [], $data);
        $data = $inputFilter->getUnescaped();

        if (isset($data['responsive_items'])) {
            unset($data['responsive_items']['__empty']);
        }

        if ($this->getRequest()->getParam('banners')) {
            $data['banner_ids'] = $this->getRequest()->getParam('banners');
        }

        return $data;
    }
}
