require.config({"config": {
        "jsbuild":{"mage/backend/action-link.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.actionLink', {\n        /**\n         * Button creation\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Bind handler on button click\n         * @protected\n         */\n        _bind: function () {\n            var keyCode = $.ui.keyCode;\n\n            this._on({\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                mousedown: function (e) {\n                    this._stopPropogation(e);\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                mouseup: function (e) {\n                    this._stopPropogation(e);\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                click: function (e) {\n                    this._stopPropogation(e);\n                    this._triggerEvent();\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                keydown: function (e) {\n                    switch (e.keyCode) {\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            this._stopPropogation(e);\n                            this._triggerEvent();\n                            break;\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                keyup: function (e) {\n                    switch (e.keyCode) {\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            this._stopPropogation(e);\n                            break;\n                    }\n                }\n            });\n        },\n\n        /**\n         * @param {Object} e - event object\n         * @private\n         */\n        _stopPropogation: function (e) {\n            e.stopImmediatePropagation();\n            e.preventDefault();\n        },\n\n        /**\n         * @private\n         */\n        _triggerEvent: function () {\n            $(this.options.related || this.element)\n                .trigger(this.options.event, this.options.eventData ? [this.options.eventData] : [{}]);\n        }\n    });\n\n    return $.mage.actionLink;\n});\n","mage/backend/menu.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.menu', {\n        widgetEventPrefix: 'menu',\n        version: '1.10.1',\n        defaultElement: '<ul>',\n        delay: 300,\n        options: {\n            icons: {\n                submenu: 'ui-icon-carat-1-e'\n            },\n            menus: 'ul',\n            position: {\n                my: 'left top',\n                at: 'right top'\n            },\n            role: 'menu',\n\n            // callbacks\n            blur: null,\n            focus: null,\n            select: null\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.activeMenu = this.element;\n            // flag used to prevent firing of the click handler\n            // as the event bubbles up through nested menus\n            this.mouseHandled = false;\n            this.element\n                .uniqueId()\n                .addClass('ui-menu ui-widget ui-widget-content ui-corner-all')\n                .toggleClass('ui-menu-icons', !!this.element.find('.ui-icon').length)\n                .attr({\n                    role: this.options.role,\n                    tabIndex: 0\n                })\n                // need to catch all clicks on disabled menu\n                // not possible through _on\n                .on('click' + this.eventNamespace, $.proxy(function (event) {\n                    if (this.options.disabled) {\n                        event.preventDefault();\n                    }\n                }, this));\n\n            if (this.options.disabled) {\n                this.element\n                    .addClass('ui-state-disabled')\n                    .attr('aria-disabled', 'true');\n            }\n\n            this._on({\n                /**\n                 * Prevent focus from sticking to links inside menu after clicking\n                 * them (focus should always stay on UL during navigation).\n                 */\n                'mousedown .ui-menu-item > a': function (event) {\n                    event.preventDefault();\n                },\n\n                /**\n                 * Prevent focus from sticking to links inside menu after clicking\n                 * them (focus should always stay on UL during navigation).\n                 */\n                'click .ui-state-disabled > a': function (event) {\n                    event.preventDefault();\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'click .ui-menu-item:has(a)': function (event) {\n                    var target = $(event.target).closest('.ui-menu-item');\n\n                    if (!this.mouseHandled && target.not('.ui-state-disabled').length) {\n                        this.mouseHandled = true;\n\n                        this.select(event);\n                        // Open submenu on click\n                        if (target.has('.ui-menu').length) {\n                            this.expand(event);\n                        } else if (!this.element.is(':focus')) {\n                            // Redirect focus to the menu\n                            this.element.trigger('focus', [true]);\n\n                            // If the active item is on the top level, let it stay active.\n                            // Otherwise, blur the active item since it is no longer visible.\n                            if (this.active && this.active.parents('.ui-menu').length === 1) { //eslint-disable-line\n                                clearTimeout(this.timer);\n                            }\n                        }\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'mouseenter .ui-menu-item': function (event) {\n                    var target = $(event.currentTarget);\n\n                    // Remove ui-state-active class from siblings of the newly focused menu item\n                    // to avoid a jump caused by adjacent elements both having a class with a border\n                    target.siblings().children('.ui-state-active').removeClass('ui-state-active');\n                    this.focus(event, target);\n                },\n                mouseleave: 'collapseAll',\n                'mouseleave .ui-menu': 'collapseAll',\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {*} keepActiveItem\n                 */\n                focus: function (event, keepActiveItem) {\n                    // If there's already an active item, keep it active\n                    // If not, activate the first item\n                    var item = this.active || this.element.children('.ui-menu-item').eq(0);\n\n                    if (!keepActiveItem) {\n                        this.focus(event, item);\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                blur: function (event) {\n                    this._delay(function () {\n                        if (!$.contains(this.element[0], this.document[0].activeElement)) {\n                            this.collapseAll(event);\n                        }\n                    });\n                },\n                keydown: '_keydown'\n            });\n\n            this.refresh();\n\n            // Clicks outside of a menu collapse any open menus\n            this._on(this.document, {\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                click: function (event) {\n                    if (!$(event.target).closest('.ui-menu').length) {\n                        this.collapseAll(event);\n                    }\n\n                    // Reset the mouseHandled flag\n                    this.mouseHandled = false;\n                }\n            });\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            // Destroy (sub)menus\n            this.element\n                .removeAttr('aria-activedescendant')\n                .find('.ui-menu').addBack()\n                .removeClass('ui-menu ui-widget ui-widget-content ui-corner-all ui-menu-icons')\n                .removeAttr('role')\n                .removeAttr('tabIndex')\n                .removeAttr('aria-labelledby')\n                .removeAttr('aria-expanded')\n                .removeAttr('aria-hidden')\n                .removeAttr('aria-disabled')\n                .removeUniqueId()\n                .show();\n\n            // Destroy menu items\n            this.element.find('.ui-menu-item')\n                .removeClass('ui-menu-item')\n                .removeAttr('role')\n                .removeAttr('aria-disabled')\n                .children('a')\n                .removeUniqueId()\n                .removeClass('ui-corner-all ui-state-hover')\n                .removeAttr('tabIndex')\n                .removeAttr('role')\n                .removeAttr('aria-haspopup')\n                .children().each(function () {\n                    var elem = $(this);\n\n                    if (elem.data('ui-menu-submenu-carat')) {\n                        elem.remove();\n                    }\n                });\n\n            // Destroy menu dividers\n            this.element.find('.ui-menu-divider').removeClass('ui-menu-divider ui-widget-content');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _keydown: function (event) {\n            var match, prev, character, skip, regex,\n                preventDefault = true;\n\n            /**\n             * @param {String} value\n             */\n            function escape(value) {\n                return value.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, '\\\\$&');\n            }\n\n            switch (event.keyCode) {\n                case $.ui.keyCode.PAGE_UP:\n                    this.previousPage(event);\n                    break;\n\n                case $.ui.keyCode.PAGE_DOWN:\n                    this.nextPage(event);\n                    break;\n\n                case $.ui.keyCode.HOME:\n                    this._move('first', 'first', event);\n                    break;\n\n                case $.ui.keyCode.END:\n                    this._move('last', 'last', event);\n                    break;\n\n                case $.ui.keyCode.UP:\n                    this.previous(event);\n                    break;\n\n                case $.ui.keyCode.DOWN:\n                    this.next(event);\n                    break;\n\n                case $.ui.keyCode.LEFT:\n                    this.collapse(event);\n                    break;\n\n                case $.ui.keyCode.RIGHT:\n                    if (this.active && !this.active.is('.ui-state-disabled')) {\n                        this.expand(event);\n                    }\n                    break;\n\n                case $.ui.keyCode.ENTER:\n                case $.ui.keyCode.SPACE:\n                    this._activate(event);\n                    break;\n\n                case $.ui.keyCode.ESCAPE:\n                    this.collapse(event);\n                    break;\n\n                default:\n                    preventDefault = false;\n                    prev = this.previousFilter || '';\n                    character = String.fromCharCode(event.keyCode);\n                    skip = false;\n\n                    clearTimeout(this.filterTimer);\n\n                    if (character === prev) {\n                        skip = true;\n                    } else {\n                        character = prev + character;\n                    }\n\n                    regex = new RegExp('^' + escape(character), 'i');\n                    match = this.activeMenu.children('.ui-menu-item').filter(function () {\n                        return regex.test($(this).children('a').text());\n                    });\n                    match = skip && match.index(this.active.next()) !== -1 ?\n                        this.active.nextAll('.ui-menu-item') :\n                        match;\n\n                    // If no matches on the current filter, reset to the last character pressed\n                    // to move down the menu to the first item that starts with that character\n                    if (!match.length) {\n                        character = String.fromCharCode(event.keyCode);\n                        regex = new RegExp('^' + escape(character), 'i');\n                        match = this.activeMenu.children('.ui-menu-item').filter(function () {\n                            return regex.test($(this).children('a').text());\n                        });\n                    }\n\n                    if (match.length) {\n                        this.focus(event, match);\n\n                        if (match.length > 1) { //eslint-disable-line max-depth\n                            this.previousFilter = character;\n                            this.filterTimer = this._delay(function () {\n                                delete this.previousFilter;\n                            }, 1000);\n                        } else {\n                            delete this.previousFilter;\n                        }\n                    } else {\n                        delete this.previousFilter;\n                    }\n            }\n\n            if (preventDefault) {\n                event.preventDefault();\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _activate: function (event) {\n            if (!this.active.is('.ui-state-disabled')) {\n                if (this.active.children('a[aria-haspopup=\"true\"]').length) {\n                    this.expand(event);\n                } else {\n                    this.select(event);\n                }\n            }\n        },\n\n        /**\n         * Refresh.\n         */\n        refresh: function () {\n            var menus,\n                icon = this.options.icons.submenu,\n                submenus = this.element.find(this.options.menus);\n\n            // Initialize nested menus\n            submenus.filter(':not(.ui-menu)')\n                .addClass('ui-menu ui-widget ui-widget-content ui-corner-all')\n                .hide()\n                .attr({\n                    role: this.options.role,\n                    'aria-hidden': 'true',\n                    'aria-expanded': 'false'\n                })\n                .each(function () {\n                    var menu = $(this),\n                        item = menu.prev('a'),\n                        submenuCarat = $('<span>')\n                            .addClass('ui-menu-icon ui-icon ' + icon)\n                            .data('ui-menu-submenu-carat', true);\n\n                    item\n                        .attr('aria-haspopup', 'true')\n                        .prepend(submenuCarat);\n                    menu.attr('aria-labelledby', item.attr('id'));\n                });\n\n            menus = submenus.add(this.element);\n\n            // Don't refresh list items that are already adapted\n            menus.children(':not(.ui-menu-item):has(a)')\n                .addClass('ui-menu-item')\n                .attr('role', 'presentation')\n                .children('a')\n                .uniqueId()\n                .addClass('ui-corner-all')\n                .attr({\n                    tabIndex: -1,\n                    role: this._itemRole()\n                });\n\n            // Initialize unlinked menu-items containing spaces and/or dashes only as dividers\n            menus.children(':not(.ui-menu-item)').each(function () {\n                var item = $(this);\n\n                // hyphen, em dash, en dash\n                if (!/[^\\-\\u2014\\u2013\\s]/.test(item.text())) {\n                    item.addClass('ui-widget-content ui-menu-divider');\n                }\n            });\n\n            // Add aria-disabled attribute to any disabled menu item\n            menus.children('.ui-state-disabled').attr('aria-disabled', 'true');\n\n            // If the active item has been removed, blur the menu\n            if (this.active && !$.contains(this.element[0], this.active[0])) {\n                this.blur();\n            }\n        },\n\n        /**\n         * @return {*}\n         * @private\n         */\n        _itemRole: function () {\n            return {\n                menu: 'menuitem',\n                listbox: 'option'\n            }[this.options.role];\n        },\n\n        /**\n         * @param {String} key\n         * @param {*} value\n         * @private\n         */\n        _setOption: function (key, value) {\n            if (key === 'icons') {\n                this.element.find('.ui-menu-icon')\n                    .removeClass(this.options.icons.submenu)\n                    .addClass(value.submenu);\n            }\n            this._super(key, value);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} item\n         */\n        focus: function (event, item) {\n            var nested, focused;\n\n            this.blur(event, event && event.type === 'focus');\n\n            this._scrollIntoView(item);\n\n            this.active = item.first();\n            focused = this.active.children('a').addClass('ui-state-focus');\n            // Only update aria-activedescendant if there's a role\n            // otherwise we assume focus is managed elsewhere\n            if (this.options.role) {\n                this.element.attr('aria-activedescendant', focused.attr('id'));\n            }\n\n            // Highlight active parent menu item, if any\n            this.active\n                .parent()\n                .closest('.ui-menu-item')\n                .children('a:first')\n                .addClass('ui-state-active');\n\n            if (event && event.type === 'keydown') {\n                this._close();\n            } else {\n                this.timer = this._delay(function () {\n                    this._close();\n                }, this.delay);\n            }\n\n            nested = item.children('.ui-menu');\n\n            if (nested.length && /^mouse/.test(event.type)) {\n                this._startOpening(nested);\n            }\n            this.activeMenu = item.parent();\n\n            this._trigger('focus', event, {\n                item: item\n            });\n        },\n\n        /**\n         * @param {Object} item\n         * @private\n         */\n        _scrollIntoView: function (item) {\n            var borderTop, paddingTop, offset, scroll, elementHeight, itemHeight;\n\n            if (this._hasScroll()) {\n                borderTop = parseFloat($.css(this.activeMenu[0], 'borderTopWidth')) || 0;\n                paddingTop = parseFloat($.css(this.activeMenu[0], 'paddingTop')) || 0;\n                offset = item.offset().top - this.activeMenu.offset().top - borderTop - paddingTop;\n                scroll = this.activeMenu.scrollTop();\n                elementHeight = this.activeMenu.height();\n                itemHeight = item.height();\n\n                if (offset < 0) {\n                    this.activeMenu.scrollTop(scroll + offset);\n                } else if (offset + itemHeight > elementHeight) {\n                    this.activeMenu.scrollTop(scroll + offset - elementHeight + itemHeight);\n                }\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {*} fromFocus\n         */\n        blur: function (event, fromFocus) {\n            if (!fromFocus) {\n                clearTimeout(this.timer);\n            }\n\n            if (!this.active) {\n                return;\n            }\n\n            this.active.children('a').removeClass('ui-state-focus');\n            this.active = null;\n\n            this._trigger('blur', event, {\n                item: this.active\n            });\n        },\n\n        /**\n         * @param {*} submenu\n         * @private\n         */\n        _startOpening: function (submenu) {\n            clearTimeout(this.timer);\n\n            // Don't open if already open fixes a Firefox bug that caused a .5 pixel\n            // shift in the submenu position when mousing over the carat icon\n            if (submenu.attr('aria-hidden') !== 'true') {\n                return;\n            }\n\n            this.timer = this._delay(function () {\n                this._close();\n                this._open(submenu);\n            }, this.delay);\n        },\n\n        /**\n         * @param {*} submenu\n         * @private\n         */\n        _open: function (submenu) {\n            var position = $.extend({\n                of: this.active\n            }, this.options.position);\n\n            clearTimeout(this.timer);\n            this.element.find('.ui-menu').not(submenu.parents('.ui-menu'))\n                .hide()\n                .attr('aria-hidden', 'true');\n\n            submenu\n                .show()\n                .removeAttr('aria-hidden')\n                .attr('aria-expanded', 'true')\n                .position(position);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {*} all\n         */\n        collapseAll: function (event, all) {\n            clearTimeout(this.timer);\n            this.timer = this._delay(function () {\n                // If we were passed an event, look for the submenu that contains the event\n                var currentMenu = all ? this.element :\n                    $(event && event.target).closest(this.element.find('.ui-menu'));\n\n                // If we found no valid submenu ancestor, use the main menu to close all sub menus anyway\n                if (!currentMenu.length) {\n                    currentMenu = this.element;\n                }\n\n                this._close(currentMenu);\n\n                this.blur(event);\n                this.activeMenu = currentMenu;\n            }, this.delay);\n        },\n\n        // With no arguments, closes the currently active menu - if nothing is active\n        // it closes all menus.  If passed an argument, it will search for menus BELOW\n        /**\n         * With no arguments, closes the currently active menu - if nothing is active\n         * it closes all menus.  If passed an argument, it will search for menus BELOW.\n         *\n         * @param {*} startMenu\n         * @private\n         */\n        _close: function (startMenu) {\n            if (!startMenu) {\n                startMenu = this.active ? this.active.parent() : this.element;\n            }\n\n            startMenu\n                .find('.ui-menu')\n                .hide()\n                .attr('aria-hidden', 'true')\n                .attr('aria-expanded', 'false')\n                .end()\n                .find('a.ui-state-active')\n                .removeClass('ui-state-active');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        collapse: function (event) {\n            var newItem = this.active &&\n                this.active.parent().closest('.ui-menu-item', this.element);\n\n            if (newItem && newItem.length) {\n                this._close();\n                this.focus(event, newItem);\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        expand: function (event) {\n            var newItem = this.active &&\n                this.active\n                    .children('.ui-menu ')\n                    .children('.ui-menu-item')\n                    .first();\n\n            if (newItem && newItem.length) {\n                this._open(newItem.parent());\n\n                // Delay so Firefox will not hide activedescendant change in expanding submenu from AT\n                this._delay(function () {\n                    this.focus(event, newItem);\n                });\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        next: function (event) {\n            this._move('next', 'first', event);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        previous: function (event) {\n            this._move('prev', 'last', event);\n        },\n\n        /**\n         * @return {null|Boolean}\n         */\n        isFirstItem: function () {\n            return this.active && !this.active.prevAll('.ui-menu-item').length;\n        },\n\n        /**\n         * @return {null|Boolean}\n         */\n        isLastItem: function () {\n            return this.active && !this.active.nextAll('.ui-menu-item').length;\n        },\n\n        /**\n         * @param {*} direction\n         * @param {*} filter\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _move: function (direction, filter, event) {\n            var next;\n\n            if (this.active) {\n                if (direction === 'first' || direction === 'last') {\n                    next = this.active\n                        [direction === 'first' ? 'prevAll' : 'nextAll']('.ui-menu-item')\n                        .eq(-1);\n                } else {\n                    next = this.active\n                        [direction + 'All']('.ui-menu-item')\n                        .eq(0);\n                }\n            }\n\n            if (!next || !next.length || !this.active) {\n                next = this.activeMenu.children('.ui-menu-item')[filter]();\n            }\n\n            this.focus(event, next);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        nextPage: function (event) {\n            var item, base, height;\n\n            if (!this.active) {\n                this.next(event);\n\n                return;\n            }\n\n            if (this.isLastItem()) {\n                return;\n            }\n\n            if (this._hasScroll()) {\n                base = this.active.offset().top;\n                height = this.element.height();\n                this.active.nextAll('.ui-menu-item').each(function () {\n                    item = $(this);\n\n                    return item.offset().top - base - height < 0;\n                });\n\n                this.focus(event, item);\n            } else {\n                this.focus(event, this.activeMenu.children('.ui-menu-item')\n                    [!this.active ? 'first' : 'last']());\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        previousPage: function (event) {\n            var item, base, height;\n\n            if (!this.active) {\n                this.next(event);\n\n                return;\n            }\n\n            if (this.isFirstItem()) {\n                return;\n            }\n\n            if (this._hasScroll()) {\n                base = this.active.offset().top;\n                height = this.element.height();\n                this.active.prevAll('.ui-menu-item').each(function () {\n                    item = $(this);\n\n                    return item.offset().top - base + height > 0;\n                });\n\n                this.focus(event, item);\n            } else {\n                this.focus(event, this.activeMenu.children('.ui-menu-item').first());\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         * @private\n         */\n        _hasScroll: function () {\n            return this.element.outerHeight() < this.element.prop('scrollHeight');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        select: function (event) {\n            // TODO: It should never be possible to not have an active item at this\n            // point, but the tests don't trigger mouseenter before click.\n            var ui;\n\n            this.active = this.active || $(event.target).closest('.ui-menu-item');\n            ui = {\n                item: this.active\n            };\n\n            if (!this.active.has('.ui-menu').length) {\n                this.collapseAll(event, true);\n            }\n            this._trigger('select', event, ui);\n        }\n    });\n\n    return $.mage.menu;\n});\n","mage/backend/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.form', {\n        options: {\n            handlersData: {\n                save: {},\n                saveAndContinueEdit: {\n                    action: {\n                        args: {\n                            back: 'edit'\n                        }\n                    }\n                },\n                preview: {\n                    target: '_blank'\n                }\n            }\n        },\n\n        /**\n         * Form creation\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Set form attributes to initial state\n         * @protected\n         */\n        _rollback: function () {\n            if (this.oldAttributes) {\n                this.element.prop(this.oldAttributes);\n            }\n        },\n\n        /**\n         * Check if field value is changed\n         * @protected\n         * @param {Object} e - event object\n         */\n        _changesObserver: function (e) {\n            var target = $(e.target),\n                changed;\n\n            if (e.type === 'focus' || e.type === 'focusin') {\n                this.currentField = {\n                    statuses: {\n                        checked: target.is(':checked'),\n                        selected: target.is(':selected')\n                    },\n                    val: target.val()\n                };\n\n            } else {\n                if (this.currentField) { //eslint-disable-line no-lonely-if\n                    changed = target.val() !== this.currentField.val ||\n                        target.is(':checked') !== this.currentField.statuses.checked ||\n                        target.is(':selected') !== this.currentField.statuses.selected;\n\n                    if (changed) { //eslint-disable-line max-depth\n                        target.trigger('changed');\n                    }\n                }\n            }\n        },\n\n        /**\n         * Get array with handler names\n         * @protected\n         * @return {Array} Array of handler names\n         */\n        _getHandlers: function () {\n            var handlers = [];\n\n            $.each(this.options.handlersData, function (key) {\n                handlers.push(key);\n            });\n\n            return handlers;\n        },\n\n        /**\n         * Store initial value of form attribute\n         * @param {String} attrName - name of attribute\n         * @protected\n         */\n        _storeAttribute: function (attrName) {\n            var prop;\n\n            this.oldAttributes = this.oldAttributes || {};\n\n            if (!this.oldAttributes[attrName]) {\n                prop = this.element.attr(attrName);\n                this.oldAttributes[attrName] = prop ? prop : '';\n            }\n        },\n\n        /**\n         * Bind handlers\n         * @protected\n         */\n        _bind: function () {\n            this.element\n                .on(this._getHandlers().join(' '), $.proxy(this._submit, this))\n                .on('focus blur focusin focusout', $.proxy(this._changesObserver, this));\n        },\n\n        /**\n         * Get action url for form\n         * @param {Object|String} data - object with parameters for action url or url string\n         * @return {String} action url\n         */\n        _getActionUrl: function (data) {\n            if (typeof data === 'object') {\n                return this._buildURL(this.oldAttributes.action, data.args);\n            }\n\n            return typeof data === 'string' ? data : this.oldAttributes.action;\n        },\n\n        /**\n         * Add additional parameters into URL\n         * @param {String} url - original url\n         * @param {Object} params - object with parameters for action url\n         * @return {String} action url\n         * @private\n         */\n        _buildURL: function (url, params) {\n            var concat = /\\?/.test(url) ? ['&', '='] : ['/', '/'];\n\n            url = url.replace(/[\\/&]+$/, '');\n            $.each(params, function (key, value) {\n                url += concat[0] + key + concat[1] + window.encodeURIComponent(value);\n            });\n\n            return url + (concat[0] === '/' ? '/' : '');\n        },\n\n        /**\n         * Prepare data for form attributes\n         * @protected\n         * @param {Object} data\n         * @return {Object}\n         */\n        _processData: function (data) {\n            $.each(data, $.proxy(function (attrName, attrValue) {\n                this._storeAttribute(attrName);\n\n                if (attrName === 'action') {\n                    data[attrName] = this._getActionUrl(attrValue);\n                }\n            }, this));\n\n            return data;\n        },\n\n        /**\n         * Get additional data before form submit\n         * @protected\n         * @param {String} handlerName\n         * @param {Object} data\n         */\n        _beforeSubmit: function (handlerName, data) {\n            var submitData = {},\n                event = new $.Event('beforeSubmit');\n\n            this.element.trigger(event, [submitData, handlerName]);\n            data = $.extend(\n                true, {},\n                this.options.handlersData[handlerName] || {},\n                submitData,\n                data\n            );\n            this.element.prop(this._processData(data));\n\n            return !event.isDefaultPrevented();\n        },\n\n        /**\n         * Submit the form\n         * @param {Object} e - event object\n         * @param {Object} data - event data object\n         */\n        _submit: function (e, data) {\n            this._rollback();\n\n            if (this._beforeSubmit(e.type, data) !== false) {\n                this.element.trigger('submit', e);\n            }\n        }\n    });\n\n    return $.mage.form;\n});\n","mage/backend/editablemultiselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\n/* global EditableMultiselect */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'jquery/editableMultiselect/js/jquery.editable',\n    'jquery/editableMultiselect/js/jquery.multiselect'\n], function ($, alert, confirm) {\n    /**\n     * Editable multiselect wrapper for multiselects\n     * This class is defined in global scope ('var' is not needed).\n     *\n     *  @param {Object} settings - settings object.\n     *  @param {String} settings.add_button_caption - caption of the 'Add New Value' button\n     *  @param {String} settings.new_url - URL to which new request has to be submitted\n     *  @param {String} settings.save_url - URL to which save request has to be submitted\n     *  @param {String} settings.delete_url - URL to which delete request has to be submitted\n     *  @param {String} settings.delete_confirm_message - confirmation message that is shown to user during\n     *      delete operation\n     *  @param {String} settings.target_select_id - HTML ID of target select element\n     *  @param {Hash} settings.submit_data - extra parameters to send with new/edit/delete requests\n     *  @param {String} settings.entity_value_name - name of the request parameter that represents select option text\n     *  @param {String} settings.entity_id_name - name of the request parameter that represents select option value\n     *  @param {Boolean} settings.is_entry_editable - flag that shows if user can add/edit/remove data\n     *\n     * @constructor\n     */\n    window.EditableMultiselect = function (settings) {\n\n        this.settings = settings || {};\n        this.addButtonCaption = this.settings['add_button_caption'] || 'Add new value';\n        this.newUrl = this.settings['new_url'];\n        this.saveUrl = this.settings['save_url'];\n        this.deleteUrl = this.settings['delete_url'];\n        this.deleteConfirmMessage = this.settings['delete_confirm_message'];\n        this.targetSelectId = this.settings['target_select_id'];\n        this.submitData = this.settings['submit_data'] || {};\n        this.entityIdName = this.settings['entity_id_name'] || 'entity_id';\n        this.entityValueName = this.settings['entity_value_name'] || 'entity_value';\n        this.isEntityEditable = this.settings['is_entity_editable'] || false;\n\n        /**\n         * Initialize editable multiselect (make it visible in UI)\n         */\n        EditableMultiselect.prototype.init = function () {\n            var self = this,\n                mselectOptions = {\n                    addText: this.addButtonCaption,\n\n                    /**\n                     * @param {*} value\n                     * @param {*} options\n                     */\n                    mselectInputSubmitCallback: function (value, options) {\n                        self.createEntity(value, options);\n                    }\n                },\n                mselectList;\n\n            if (!this.isEntityEditable) {\n                // Override default layout of editable multiselect\n                mselectOptions.layout = '<section class=\"block %mselectListClass%\">' +\n                    '<div class=\"block-content\"><div class=\"%mselectItemsWrapperClass%\">' +\n                    '%items%' +\n                    '</div></div>' +\n                    '<div class=\"%mselectInputContainerClass%\">' +\n                    '<input type=\"text\" class=\"%mselectInputClass%\" title=\"%inputTitle%\"/>' +\n                    '<span class=\"%mselectButtonCancelClass%\" title=\"%cancelText%\"></span>' +\n                    '<span class=\"%mselectButtonSaveClass%\" title=\"Add\"></span>' +\n                    '</div>' +\n                    '</section>';\n            }\n\n            $('#' + this.targetSelectId).multiselect(mselectOptions);\n\n            // Make multiselect editable if needed\n            if (this.isEntityEditable) {\n                this.makeMultiselectEditable();\n\n                // Root element of HTML markup that represents select element in UI\n                mselectList = $('#' + this.targetSelectId).next();\n                this.attachEventsToControls(mselectList);\n            }\n        };\n\n        /**\n         * Attach required event handlers to control elements of editable multiselect\n         *\n         * @param {Object} mselectList\n         */\n        EditableMultiselect.prototype.attachEventsToControls = function (mselectList) {\n            mselectList.on('click.mselect-delete', '.mselect-delete', {\n                container: this\n            }, function (event) {\n                // Pass the clicked button to container\n                event.data.container.deleteEntity({\n                    'delete_button': this\n                });\n            });\n\n            mselectList.on('click.mselect-checked', '.mselect-list-item input', {\n                container: this\n            }, function (event) {\n                var el = $(this),\n                    checkedClassName = 'mselect-checked';\n\n                el[el.is(':checked') ? 'addClass' : 'removeClass'](checkedClassName);\n                event.data.container.makeMultiselectEditable();\n            });\n\n            mselectList.on('click.mselect-edit', '.mselect-edit', {\n                container: this\n            }, function (event) {\n                event.data.container.makeMultiselectEditable();\n                $(this).parent().find('label span').trigger('dblclick');\n            });\n        };\n\n        /**\n         * Make multiselect editable\n         */\n        EditableMultiselect.prototype.makeMultiselectEditable = function () {\n            var entityIdName = this.entityIdName,\n                entityValueName = this.entityValueName,\n                selectList = $('#' + this.targetSelectId).next();\n\n            selectList.find('.mselect-list-item:not(.mselect-list-item-not-editable) label span').editable(this.saveUrl,\n            {\n                type: 'text',\n                submit: '<button class=\"mselect-save\" title=\"Save\" type=\"submit\"></button>',\n                cancel: '<span class=\"mselect-cancel\" title=\"Cancel\"></span>',\n                event: 'dblclick',\n                placeholder: '',\n\n                /**\n                 * Is checked.\n                 */\n                isChecked: function () {\n                    var that = $(this),\n                        checked;\n\n                    if (!that.closest('.mselect-list-item').hasClass('mselect-disabled')) {\n                        checked = that.parent().find('[type=checkbox]').prop('disabled');\n                        that.parent().find('[type=checkbox]').prop({\n                            disabled: !checked\n                        });\n                    }\n                },\n\n                /**\n                 * @param {*} value\n                 * @param {Object} sett\n                 * @return {*}\n                 */\n                data: function (value, sett) {\n                    var retval;\n\n                    sett.isChecked.apply(this, [sett]);\n\n                    if (typeof value === 'string') {\n                        retval = value.unescapeHTML();\n\n                        return retval;\n                    }\n\n                    return value;\n                },\n                submitdata: this.submitData,\n                onblur: 'cancel',\n                name: entityValueName,\n                ajaxoptions: {\n                    dataType: 'json'\n                },\n\n                /**\n                 * @param {Object} sett\n                 * @param {*} original\n                 */\n                onsubmit: function (sett, original) {\n                    var select = $(original).closest('.mselect-list').prev(),\n                        current = $(original).closest('.mselect-list-item').index(),\n                        entityId = select.find('option').eq(current).val(),\n                        entityInfo = {};\n\n                    entityInfo[entityIdName] = entityId;\n                    sett.submitdata = $.extend(sett.submitdata || {}, entityInfo);\n                },\n\n                /**\n                 * @param {Object} result\n                 * @param {Object} sett\n                 */\n                callback: function (result, sett) {\n                    var select, current;\n\n                    sett.isChecked.apply(this, [sett]);\n                    select = $(this).closest('.mselect-list').prev();\n                    current = $(this).closest('.mselect-list-item').index();\n\n                    if (result.success) {\n                        if (typeof result[entityValueName] === 'string') {\n                            select.find('option').eq(current).val(result[entityIdName]).text(result[entityValueName]);\n                            $(this).html(result[entityValueName].escapeHTML());\n                        }\n                    } else {\n                        alert({\n                            content: result['error_message']\n                        });\n                    }\n                }\n            });\n        };\n\n        /**\n         * Callback function that is called when admin adds new value to select\n         *\n         * @param {*} value\n         * @param {Object} options - list of settings of multiselect\n         */\n        EditableMultiselect.prototype.createEntity = function (value, options) {\n            var select, entityIdName, entityValueName, entityInfo, postData, ajaxOptions;\n\n            if (!value) {\n                return;\n            }\n\n            select = $('#' + this.targetSelectId),\n            entityIdName = this.entityIdName,\n            entityValueName = this.entityValueName,\n            entityInfo = {};\n            entityInfo[entityIdName] = null;\n            entityInfo[entityValueName] = value;\n\n            postData = $.extend(entityInfo, this.submitData);\n\n            ajaxOptions = {\n                type: 'POST',\n                data: postData,\n                dataType: 'json',\n                url: this.newUrl,\n\n                /**\n                 * @param {Object} result\n                 */\n                success: function (result) {\n                    var resultEntityValueName, mselectItemHtml, sectionBlock, itemsWrapper, inputSelector;\n\n                    if (result.success) {\n                        resultEntityValueName = '';\n\n                        if (typeof result[entityValueName] === 'string') {\n                            resultEntityValueName = result[entityValueName].escapeHTML();\n                        } else {\n                            resultEntityValueName = result[entityValueName];\n                        }\n                        // Add item to initial select element\n                        select.append('<option value=\"' + result[entityIdName] + '\" selected=\"selected\">' +\n                        resultEntityValueName + '</option>');\n                        // Add editable multiselect item\n                        mselectItemHtml = $(options.item.replace(/%value%|%label%/gi, resultEntityValueName)\n                            .replace(/%mselectDisabledClass%|%iseditable%|%isremovable%/gi, '')\n                            .replace(/%mselectListItemClass%/gi, options.mselectListItemClass))\n                            .find('[type=checkbox]')\n                            .addClass(options.mselectCheckedClass)\n                            .prop('checked', true)\n                            .end();\n                        sectionBlock = select.nextAll('section.block:first');\n                        itemsWrapper = sectionBlock.find('.' + options.mselectItemsWrapperClass + '');\n\n                        if (itemsWrapper.children('.' + options.mselectListItemClass + '').length) {\n                            itemsWrapper.children('.' + options.mselectListItemClass + ':last').after(mselectItemHtml);\n                        } else {\n                            itemsWrapper.prepend(mselectItemHtml);\n                        }\n                        // Trigger blur event on input field, that is used to add new value, to hide it\n                        inputSelector = '.' + options.mselectInputContainerClass + ' [type=text].' +\n                            options.mselectInputClass + '';\n                        sectionBlock.find(inputSelector).trigger('blur');\n                    } else {\n                        alert({\n                            content: result['error_message']\n                        });\n                    }\n                }\n            };\n            $.ajax(ajaxOptions);\n        };\n\n        /**\n         * Callback function that is called when user tries to delete value from select\n         *\n         * @param {Object} options\n         */\n        EditableMultiselect.prototype.deleteEntity = function (options) {\n            var self = this;\n\n            if (options['delete_button']) {\n                confirm({\n                    content: this.deleteConfirmMessage,\n                    actions: {\n                        /**\n                         * Confirm.\n                         */\n                        confirm: function () {\n                            // Button that has been clicked\n                            var deleteButton = $(options['delete_button']),\n                                index = deleteButton.parent().index(),\n                                select = deleteButton.closest('.mselect-list').prev(),\n                                entityId = select.find('option').eq(index).val(),\n                                entityInfo = {},\n                                postData, ajaxOptions;\n\n                            entityInfo[self.entityIdName] = entityId;\n                            postData = $.extend(entityInfo, self.submitData);\n\n                            ajaxOptions = {\n                                type: 'POST',\n                                data: postData,\n                                dataType: 'json',\n                                url: self.deleteUrl,\n\n                                /**\n                                 * @param {Object} result\n                                 */\n                                success: function (result) {\n                                    if (result.success) {\n                                        deleteButton.parent().remove();\n                                        select.find('option').eq(index).remove();\n                                    } else {\n                                        alert({\n                                            content: result['error_message']\n                                        });\n                                    }\n                                }\n                            };\n                            $.ajax(ajaxOptions);\n                        }\n                    }\n                });\n            }\n        };\n    };\n});\n","mage/msie/file-reader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Init \"readAsBinaryString\" function for FileReader class.\n     * It need for IE11\n     * @param {Blob} fileData\n     */\n    var readAsBinaryStringIEFunc = function (fileData) {\n        var binary = '',\n            self = this,\n            reader = new FileReader();\n\n        /**\n         * Read file as binary string\n         */\n        reader.onload = function () {\n            var bytes, length, index;\n\n            /* eslint-disable no-undef */\n            bytes = new Uint8Array(reader.result);\n            /* eslint-enable */\n            length = bytes.length;\n\n            for (index = 0; index < length; index++) {\n                binary += String.fromCharCode(bytes[index]);\n            }\n            //self.result  - readonly so assign binary\n            self.content = binary;\n            $(self).trigger('onload');\n        };\n        reader.readAsArrayBuffer(fileData);\n    };\n\n    if (typeof FileReader.prototype.readAsBinaryString === 'undefined') {\n        FileReader.prototype.readAsBinaryString = readAsBinaryStringIEFunc;\n    }\n});\n","mage/requirejs/text.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* inspired by http://github.com/requirejs/text */\n/*global XDomainRequest */\n\ndefine(['module'], function (module) {\n    'use strict';\n\n    var xmlRegExp = /^\\s*<\\?xml(\\s)+version=[\\'\\\"](\\d)*.(\\d)*[\\'\\\"](\\s)*\\?>/im,\n        bodyRegExp = /<body[^>]*>\\s*([\\s\\S]+)\\s*<\\/body>/im,\n        stripReg = /!strip$/i,\n        defaultConfig = module.config && module.config() || {};\n\n    /**\n     * Strips <?xml ...?> declarations so that external SVG and XML documents can be\n     * added to a document without worry.\n     * Also, if the string is an HTML document, only the part inside the body tag is returned.\n     *\n     * @param {String} external\n     * @returns {String}\n     */\n    function stripContent(external) {\n        var matches;\n\n        if (!external) {\n            return '';\n        }\n\n        matches = external.match(bodyRegExp);\n        external = matches ?\n            matches[1] :\n            external.replace(xmlRegExp, '');\n\n        return external;\n    }\n\n    /**\n     * Checks that url match current location\n     *\n     * @param {String} url\n     * @returns {Boolean}\n     */\n    function sameDomain(url) {\n        var uProtocol, uHostName, uPort,\n            xdRegExp = /^([\\w:]+)?\\/\\/([^\\/\\\\]+)/i,\n            location = window.location,\n            match = xdRegExp.exec(url);\n\n        if (!match) {\n            return true;\n        }\n        uProtocol = match[1];\n        uHostName = match[2];\n\n        uHostName = uHostName.split(':');\n        uPort = uHostName[1] || '';\n        uHostName = uHostName[0];\n\n        return (!uProtocol || uProtocol === location.protocol) &&\n            (!uHostName || uHostName.toLowerCase() === location.hostname.toLowerCase()) &&\n            (!uPort && !uHostName || uPort === location.port);\n    }\n\n    /**\n     * @returns {XMLHttpRequest|XDomainRequest|null}\n     */\n    function createRequest(url) {\n        var xhr = new XMLHttpRequest();\n\n        if (!sameDomain(url) && typeof XDomainRequest !== 'undefined') {\n            xhr = new XDomainRequest();\n        }\n\n        return xhr;\n    }\n\n    /**\n     * XHR requester. Returns value to callback.\n     *\n     * @param {String} url\n     * @param {Function} callback\n     * @param {Function} fail\n     * @param {Object} headers\n     */\n    function getContent(url, callback, fail, headers) {\n        var xhr = createRequest(url),\n            header;\n\n        xhr.open('GET', url);\n\n        /*eslint-disable max-depth */\n        if ('setRequestHeader' in xhr && headers) {\n            for (header in headers) {\n                if (headers.hasOwnProperty(header)) {\n                    xhr.setRequestHeader(header.toLowerCase(), headers[header]);\n                }\n            }\n        }\n\n        /**\n         * @inheritdoc\n         */\n        xhr.onreadystatechange = function () {\n            var status, err;\n\n            //Do not explicitly handle errors, those should be\n            //visible via console output in the browser.\n            if (xhr.readyState === 4) {\n                status = xhr.status || 0;\n\n                if (status > 399 && status < 600) {\n                    //An http 4xx or 5xx error. Signal an error.\n                    err = new Error(url + ' HTTP status: ' + status);\n                    err.xhr = xhr;\n\n                    if (fail) {\n                        fail(err);\n                    }\n                } else {\n                    callback(xhr.responseText);\n\n                    if (defaultConfig.onXhrComplete) {\n                        defaultConfig.onXhrComplete(xhr, url);\n                    }\n                }\n            }\n        };\n\n        /*eslint-enable max-depth */\n\n        if (defaultConfig.onXhr) {\n            defaultConfig.onXhr(xhr, url);\n        }\n\n        xhr.send();\n    }\n\n    /**\n     * Main method used by RequireJs.\n     *\n     * @param {String} name - has format: some.module.filext!strip\n     * @param {Function} req\n     * @param {Function|undefined} onLoad\n     */\n    function loadContent(name, req, onLoad) {\n\n        var toStrip = stripReg.test(name),\n            url = req.toUrl(name.replace(stripReg, '')),\n            headers = defaultConfig.headers;\n\n        getContent(url, function (content) {\n                content = toStrip ? stripContent(content) : content;\n                onLoad(content);\n            }, onLoad.error, headers);\n    }\n\n    return {\n        load: loadContent,\n        get: getContent\n    };\n});\n","mage/requirejs/resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'domReady!'\n], function (_) {\n    'use strict';\n\n    var context = require.s.contexts._,\n        execCb = context.execCb,\n        registry = context.registry,\n        callbacks = [],\n        retries = 10,\n        updateDelay = 1,\n        ready,\n        update;\n\n    /**\n     * Checks if provided callback already exists in the callbacks list.\n     *\n     * @param {Object} callback - Callback object to be checked.\n     * @returns {Boolean}\n     */\n    function isSubscribed(callback) {\n        return !!_.findWhere(callbacks, callback);\n    }\n\n    /**\n     * Checks if provided module is rejected during load.\n     *\n     * @param {Object} module - Module to be checked.\n     * @return {Boolean}\n     */\n    function isRejected(module) {\n        return registry[module.id] && (registry[module.id].inited || registry[module.id].error);\n    }\n\n    /**\n     * Checks if provided module had path fallback triggered.\n     *\n     * @param {Object} module - Module to be checked.\n     * @return {Boolean}\n     */\n    function isPathFallback(module) {\n        return registry[module.id] && registry[module.id].events.error;\n    }\n\n    /**\n     * Checks if provided module has unresolved dependencies.\n     *\n     * @param {Object} module - Module to be checked.\n     * @returns {Boolean}\n     */\n    function isPending(module) {\n        if (!module.depCount) {\n            return false;\n        }\n\n        return module.depCount >\n            _.filter(module.depMaps, isRejected).length + _.filter(module.depMaps, isPathFallback).length;\n    }\n\n    /**\n     * Checks if requirejs's registry object contains pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function hasPending() {\n        return _.some(registry, isPending);\n    }\n\n    /**\n     * Checks if 'resolver' module is in ready\n     * state and that there are no pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function isReady() {\n        return ready && !hasPending();\n    }\n\n    /**\n     * Invokes provided callback handler.\n     *\n     * @param {Object} callback\n     */\n    function invoke(callback) {\n        callback.handler.call(callback.ctx);\n    }\n\n    /**\n     * Sets 'resolver' module to a ready state\n     * and invokes pending callbacks.\n     */\n    function resolve() {\n        ready = true;\n\n        callbacks.splice(0).forEach(invoke);\n    }\n\n    /**\n     * Drops 'ready' flag and runs the update process.\n     */\n    function tick() {\n        ready = false;\n\n        update(retries);\n    }\n\n    /**\n     * Adds callback which will be invoked\n     * when all of the pending modules are initiated.\n     *\n     * @param {Function} handler - 'Ready' event handler function.\n     * @param {Object} [ctx] - Optional context with which handler\n     *      will be invoked.\n     */\n    function subscribe(handler, ctx) {\n        var callback = {\n            handler: handler,\n            ctx: ctx\n        };\n\n        if (!isSubscribed(callback)) {\n            callbacks.push(callback);\n\n            if (isReady()) {\n                _.defer(tick);\n            }\n        }\n    }\n\n    /**\n     * Checks for all modules to be initiated\n     * and invokes pending callbacks if it's so.\n     *\n     * @param {Number} [retry] - Number of retries\n     *      that will be used to repeat the 'update' function\n     *      invokation in case if there are no pending requests.\n     */\n    update = _.debounce(function (retry) {\n        if (!hasPending()) {\n            retry ? update(--retry) : resolve();\n        }\n    }, updateDelay);\n\n    /**\n     * Overrides requirejs's original 'execCb' method\n     * in order to track pending modules.\n     *\n     * @returns {*} Result of original method call.\n     */\n    context.execCb = function () {\n        var exported = execCb.apply(context, arguments);\n\n        tick();\n\n        return exported;\n    };\n\n    return subscribe;\n});\n","mage/requirejs/baseUrlResolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Sample configuration:\n *\n require.config({\n        \"config\": {\n            \"baseUrlInterceptor\": {\n                \"Magento_Ui/js/lib/knockout/bindings/collapsible.js\": \"../../../../frontend/Magento/luma/en_US/\"\n            }\n        }\n    });\n */\n\n/* global jsSuffixRegExp */\n/* eslint-disable max-depth */\ndefine('baseUrlInterceptor', [\n    'module'\n], function (module) {\n    'use strict';\n\n    /**\n     * RequireJS Context object\n     */\n    var ctx = require.s.contexts._,\n\n        /**\n         * Original function\n         *\n         * @type {Function}\n         */\n        origNameToUrl = ctx.nameToUrl,\n\n        /**\n         * Original function\n         *\n         * @type {Function}\n         */\n        newContextConstr = require.s.newContext;\n\n    /**\n     * Remove dots from URL\n     *\n     * @param {Array} ary\n     */\n    function trimDots(ary) {\n        var i, part, length = ary.length;\n\n        for (i = 0; i < length; i++) {\n            part = ary[i];\n\n            if (part === '.') {\n                ary.splice(i, 1);\n                i -= 1;\n            } else if (part === '..') {\n                if (i === 1 && (ary[2] === '..' || ary[0] === '..')) {\n                    //End of the line. Keep at least one non-dot\n                    //path segment at the front so it can be mapped\n                    //correctly to disk. Otherwise, there is likely\n                    //no path mapping for a path starting with '..'.\n                    //This can still fail, but catches the most reasonable\n                    //uses of ..\n                    break;\n                } else if (i > 0) {\n                    ary.splice(i - 1, 2);\n                    i -= 2;\n                }\n            }\n        }\n    }\n\n    /**\n     * Normalize URL string (remove '/../')\n     *\n     * @param {String} name\n     * @param {String} baseName\n     * @param {Object} applyMap\n     * @param {Object} localContext\n     * @returns {*}\n     */\n    function normalize(name, baseName, applyMap, localContext) {\n        var lastIndex,\n            baseParts = baseName && baseName.split('/'),\n            normalizedBaseParts = baseParts;\n\n        //Adjust any relative paths.\n        if (name && name.charAt(0) === '.') {\n            //If have a base name, try to normalize against it,\n            //otherwise, assume it is a top-level require that will\n            //be relative to baseUrl in the end.\n            if (baseName) {\n                //Convert baseName to array, and lop off the last part,\n                //so that . matches that 'directory' and not name of the baseName's\n                //module. For instance, baseName of 'one/two/three', maps to\n                //'one/two/three.js', but we want the directory, 'one/two' for\n                //this normalization.\n                normalizedBaseParts = baseParts.slice(0, baseParts.length - 1);\n                name = name.split('/');\n                lastIndex = name.length - 1;\n\n                // If wanting node ID compatibility, strip .js from end\n                // of IDs. Have to do this here, and not in nameToUrl\n                // because node allows either .js or non .js to map\n                // to same file.\n                if (localContext.nodeIdCompat && jsSuffixRegExp.test(name[lastIndex])) {\n                    name[lastIndex] = name[lastIndex].replace(jsSuffixRegExp, '');\n                }\n\n                name = normalizedBaseParts.concat(name);\n                trimDots(name);\n                name = name.join('/');\n            } else if (name.indexOf('./') === 0) {\n                // No baseName, so this is ID is resolved relative\n                // to baseUrl, pull off the leading dot.\n                name = name.substring(2);\n            }\n        }\n\n        return name;\n    }\n\n    /**\n     * Get full url.\n     *\n     * @param {Object} context\n     * @param {String} url\n     * @return {String}\n     */\n    function getUrl(context, url) {\n        var baseUrl = context.config.baseUrl,\n            newConfig = context.config,\n            modulePath = url.replace(baseUrl, ''),\n            newBaseUrl,\n            rewrite = module.config()[modulePath];\n\n        if (!rewrite) {\n            return url;\n        }\n\n        newBaseUrl = normalize(rewrite, baseUrl, undefined, newConfig);\n\n        return newBaseUrl + modulePath;\n    }\n\n    /**\n     * Replace original function.\n     *\n     * @returns {*}\n     */\n    ctx.nameToUrl = function () {\n        return getUrl(ctx, origNameToUrl.apply(ctx, arguments));\n    };\n\n    /**\n     * Replace original function.\n     *\n     * @return {*}\n     */\n    require.s.newContext = function () {\n        var newCtx = newContextConstr.apply(require.s, arguments),\n            newOrigNameToUrl = newCtx.nameToUrl;\n\n        /**\n         * New implementation of native function.\n         *\n         * @returns {String}\n         */\n        newCtx.nameToUrl = function () {\n            return getUrl(newCtx, newOrigNameToUrl.apply(newCtx, arguments));\n        };\n\n        return newCtx;\n    };\n});\n\nrequire(['baseUrlInterceptor'], function () {\n    'use strict';\n\n});\n","Magento_Variable/variables.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Variables, updateElementAtCursor, MagentovariablePlugin, Base64 */\ndefine([\n    'jquery',\n    'mage/backend/notification',\n    'mage/translate',\n    'wysiwygAdapter',\n    'uiRegistry',\n    'mage/apply/main',\n    'mageUtils',\n    'Magento_Variable/js/config-directive-generator',\n    'Magento_Variable/js/custom-directive-generator',\n    'Magento_Ui/js/lib/spinner',\n    'jquery/ui',\n    'prototype',\n    'mage/adminhtml/tools'\n], function (jQuery, notification, $t, wysiwyg, registry, mageApply, utils, configGenerator, customGenerator, loader) {\n    'use strict';\n\n    window.Variables = {\n        textareaElementId: null,\n        variablesContent: null,\n        dialogWindow: null,\n        dialogWindowId: 'variables-chooser',\n        overlayShowEffectOptions: null,\n        overlayHideEffectOptions: null,\n        insertFunction: 'Variables.insertVariable',\n        selectedPlaceholder: null,\n        isEditMode: null,\n        editor: null,\n\n        /**\n         * Initialize Variables handler.\n         *\n         * @param {*} textareaElementId\n         * @param {Function} insertFunction\n         * @param {Object} editor\n         * @param {Object} selectedPlaceholder\n         */\n        init: function (textareaElementId, insertFunction, editor, selectedPlaceholder) {\n            if ($(textareaElementId)) {\n                this.textareaElementId = textareaElementId;\n            }\n\n            if (insertFunction) {\n                this.insertFunction = insertFunction;\n            }\n\n            if (selectedPlaceholder) {\n                this.selectedPlaceholder = selectedPlaceholder;\n            }\n\n            if (editor) {\n                this.editor = editor;\n            }\n        },\n\n        /**\n         * Reset data.\n         */\n        resetData: function () {\n            this.variablesContent = null;\n            this.dialogWindow = null;\n        },\n\n        /**\n         * Open variables chooser slideout.\n         *\n         * @param {Object} variables\n         */\n        openVariableChooser: function (variables) {\n            if (variables) {\n                this.openDialogWindow(variables);\n            }\n        },\n\n        /**\n         * Close variables chooser slideout dialog window.\n         */\n        closeDialogWindow: function () {\n            jQuery('#' + this.dialogWindowId).modal('closeModal');\n        },\n\n        /**\n         * Init ui component grid on the form\n         *\n         * @return void\n         */\n        initUiGrid: function () {\n            mageApply.apply(document.getElementById(this.dialogWindow));\n            jQuery('#' + this.dialogWindowId).applyBindings();\n            loader.get('variables_modal.variables_modal.variables').hide();\n        },\n\n        /**\n         * Open slideout dialog window.\n         *\n         * @param {*} variablesContent\n         * @param {Object} selectedElement\n         */\n        openDialogWindow: function (variablesContent, selectedElement) {\n\n            var html = utils.copy(variablesContent),\n                self = this;\n\n            jQuery('<div id=\"' + this.dialogWindowId + '\">' + html + '</div>').modal({\n                title: self.isEditMode ? $t('Edit Variable') : $t('Insert Variable'),\n                type: 'slide',\n                buttons: self.getButtonsConfig(self.isEditMode),\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} modal\n                 */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                    registry.get(\n                        'variables_modal.variables_modal.variables.variable_selector',\n                        function (radioSelect) {\n                            radioSelect.selectedVariableCode('');\n                        }\n                    );\n                }\n            });\n\n            this.selectedPlaceholder = selectedElement;\n\n            this.addNotAvailableMessage(selectedElement);\n\n            jQuery('#' + this.dialogWindowId).modal('openModal');\n\n            if (typeof selectedElement !== 'undefined') {\n                registry.get(\n                    'variables_modal.variables_modal.variables.variable_selector',\n                    function (radioSelect) {\n                        radioSelect.selectedVariableCode(MagentovariablePlugin.getElementVariablePath(selectedElement));\n                    }\n                );\n            }\n        },\n\n        /**\n         * Add message to slide out that variable is no longer available\n         *\n         * @param {Object} selectedElement\n         */\n        addNotAvailableMessage: function (selectedElement) {\n            var name,\n                msg,\n                variablePath,\n                $wrapper,\n                lostVariableClass = 'magento-placeholder-error';\n\n            if (\n                this.isEditMode &&\n                typeof selectedElement !== 'undefined' &&\n                jQuery(selectedElement).hasClass(lostVariableClass)\n            ) {\n\n                variablePath = MagentovariablePlugin.getElementVariablePath(selectedElement);\n                name = variablePath.split(':');\n                msg = $t('The variable %1 is no longer available. Select a different variable.')\n                    .replace('%1', name[1]);\n\n                jQuery('body').notification('clear')\n                    .notification('add', {\n                        error: true,\n                        message: msg,\n\n                        /**\n                         * @param {String} message\n                         */\n                        insertMethod: function (message) {\n                            $wrapper = jQuery('<div></div>').html(message);\n\n                            jQuery('.modal-header .page-main-actions').after($wrapper);\n                        }\n                    });\n            }\n        },\n\n        /**\n         * Get selected variable directive.\n         *\n         * @returns {*}\n         */\n        getVariableCode: function () {\n            var code = registry.get('variables_modal.variables_modal.variables.variable_selector')\n                    .selectedVariableCode(),\n                directive = code;\n\n            // processing switch here as content must contain only path/code without type\n            if (typeof code !== 'undefined') {\n                if (code.match('^default:')) {\n                    directive = configGenerator.processConfig(code.replace('default:', ''));\n                } else if (code.match('^custom:')) {\n                    directive = customGenerator.processConfig(code.replace('custom:', ''));\n                }\n\n                return directive;\n            }\n        },\n\n        /**\n         * Get buttons configuration for slideout dialog.\n         *\n         * @param {Boolean} isEditMode\n         *\n         * @returns {Array}\n         */\n        getButtonsConfig: function (isEditMode) {\n\n            var self = this,\n                buttonsData;\n\n            buttonsData = [\n                {\n\n                    text: $t('Cancel'),\n                    'class': 'action-scalable cancel',\n\n                    /**\n                     * @param {jQuery.Event} event\n                     */\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                },\n                {\n\n                    text: isEditMode ? $t('Save') : $t('Insert Variable'),\n                    class: 'action-primary ' + (isEditMode ? '' : 'disabled'),\n                    attr: {\n                        'id': 'insert_variable'\n                    },\n\n                    /**\n                     * Insert Variable\n                     */\n                    click: function () {\n                        self.insertVariable(self.getVariableCode());\n                    }\n                }\n            ];\n\n            return buttonsData;\n        },\n\n        /**\n         * Prepare variables row.\n         *\n         * @param {String} varValue\n         * @param {*} varLabel\n         * @return {String}\n         * @deprecated This method isn't relevant after ui changes\n         */\n        prepareVariableRow: function (varValue, varLabel) {\n            var value = varValue.replace(/\"/g, '&quot;').replace(/'/g, '\\\\&#39;');\n\n            return '<a href=\"#\" onclick=\"' +\n                this.insertFunction +\n                '(\\'' +\n                value +\n                '\\');return false;\">' +\n                varLabel +\n                '</a>';\n        },\n\n        /**\n         * Insert variable into WYSIWYG editor.\n         *\n         * @param {*} value\n         * @return {Object}\n         */\n        insertVariable: function (value) {\n            var windowId = this.dialogWindowId,\n                textareaElm, scrollPos, wysiwygEditorFocused;\n\n            jQuery('#' + windowId).modal('closeModal');\n            textareaElm = $(this.textareaElementId);\n\n            //to support switching between wysiwyg editors\n            wysiwygEditorFocused = wysiwyg && wysiwyg.activeEditor();\n\n            if (wysiwygEditorFocused && wysiwyg.get(this.textareaElementId)) {\n                if (jQuery(this.selectedPlaceholder).hasClass('magento-placeholder')) {\n                    wysiwyg.setCaretOnElement(this.selectedPlaceholder, 1);\n                }\n                wysiwyg.insertContent(value, false);\n\n                if (this.selectedPlaceholder && jQuery(this.selectedPlaceholder).hasClass('magento-placeholder')) {\n                    this.selectedPlaceholder.remove();\n                }\n\n            } else if (textareaElm) {\n                scrollPos = textareaElm.scrollTop;\n                updateElementAtCursor(textareaElm, value);\n                textareaElm.focus();\n                textareaElm.scrollTop = scrollPos;\n                jQuery(textareaElm).trigger('change');\n                textareaElm = null;\n            }\n\n            return this;\n        }\n\n    };\n\n    window.MagentovariablePlugin = {\n        editor: null,\n        variables: null,\n        textareaId: null,\n\n        /**\n         * Bind editor.\n         *\n         * @param {*} editor\n         */\n        setEditor: function (editor) {\n            this.editor = editor;\n        },\n\n        /**\n         * Load variables chooser.\n         *\n         * @param {String} url\n         * @param {*} textareaId\n         * @param {Object} selectedElement\n         *\n         * @return {Object}\n         */\n        loadChooser: function (url, textareaId, selectedElement) {\n            this.textareaId = textareaId;\n\n            new Ajax.Request(url, {\n                parameters: {},\n                onComplete: function (transport) {\n                    Variables.init(this.textareaId, 'MagentovariablePlugin.insertVariable', this.editor);\n                    Variables.isEditMode = !!this.getElementVariablePath(selectedElement);\n                    this.variablesContent = transport.responseText;\n                    Variables.openDialogWindow(this.variablesContent, selectedElement);\n                    Variables.initUiGrid();\n                }.bind(this)\n            });\n\n            return this;\n        },\n\n        /**\n         * Open variables chooser window.\n         *\n         * @param {*} variables\n         * @deprecated This method isn't relevant after ui changes\n         */\n        openChooser: function (variables) {\n            Variables.openVariableChooser(variables);\n        },\n\n        /**\n         * Insert variable.\n         *\n         * @param {*} value\n         *\n         * @return {Object}\n         */\n        insertVariable: function (value) {\n            if (this.textareaId) {\n                Variables.init(this.textareaId);\n                Variables.insertVariable(value);\n            } else {\n                Variables.closeDialogWindow();\n                Variables.insertVariable(value);\n            }\n\n            return this;\n        },\n\n        /**\n         * Get element variable path.\n         *\n         * @param {Object} element\n         * @returns {String}\n         */\n        getElementVariablePath: function (element) {\n            var type, code;\n\n            if (!element || !jQuery(element).hasClass('magento-variable')) {\n                return '';\n            }\n            type = jQuery(element).hasClass('magento-custom-var') ? 'custom' : 'default';\n            code = Base64.idDecode(element.getAttribute('id'));\n\n            return type + ':' + code;\n        }\n    };\n});\n","Magento_Variable/js/custom-directive-generator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return _.extend({\n        directiveTemplate: '{{customVar code=%s}}',\n\n        /**\n         * @param {String} path\n         * @return {String}\n         */\n        processConfig: function (path) {\n            return this.directiveTemplate.replace('%s', path);\n        }\n\n    });\n\n});\n","Magento_Variable/js/config-directive-generator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return _.extend({\n        directiveTemplate: '{{config path=\"%s\"}}',\n\n        /**\n         * @param {String} path\n         * @return {String}\n         */\n        processConfig: function (path) {\n            return this.directiveTemplate.replace('%s', path);\n\n        }\n\n    });\n\n});\n","Magento_Variable/js/grid/columns/radioselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column',\n    'jquery'\n], function (_, $t, Column, jQuery) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Variable/grid/cells/radioselect',\n            draggable: false,\n            sortable: false,\n            selectedVariableCode: null,\n            selectedVariableType: null\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(['selectedVariableCode']);\n\n            return this;\n        },\n\n        /**\n         * Remove disable class from Insert Variable button after Variable has been chosen.\n         *\n         * @return {Boolean}\n         */\n        selectVariable: function () {\n            if (jQuery('#insert_variable').hasClass('disabled')) {\n                jQuery('#insert_variable').removeClass('disabled');\n            }\n\n            return true;\n        }\n    });\n});\n","Magento_User/js/roles-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.rolesTree', {\n        options: {\n            treeInitData: {},\n            editFormSelector: '',\n            resourceFieldName: 'resource[]',\n            checkboxVisible: true\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.element.jstree({\n                plugins: ['checkbox'],\n                checkbox: {\n                    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    three_state: false,\n                    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    visible: this.options.checkboxVisible,\n                    cascade: 'undetermined'\n                },\n                core: {\n                    data: this.options.treeInitData,\n                    themes: {\n                        dots: false\n                    }\n                }\n            });\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            this.element.jstree('destroy');\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this.element.on('select_node.jstree', $.proxy(this._selectChildNodes, this));\n            this.element.on('deselect_node.jstree', $.proxy(this._deselectChildNodes, this));\n            this.element.on('changed.jstree', $.proxy(this._changedNode, this));\n        },\n\n        /**\n         * @param {Event} event\n         * @param {Object} selected\n         * @private\n         */\n        _selectChildNodes: function (event, selected) {\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            selected.instance.open_node(selected.node);\n            selected.node.children.each(function (id) {\n                var selector = '[id=\"' + id + '\"]';\n\n                selected.instance.select_node(\n                    selected.instance.get_node($(selector), false)\n                );\n            });\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n        },\n\n        /**\n         * @param {Event} event\n         * @param {Object} selected\n         * @private\n         */\n        _deselectChildNodes: function (event, selected) {\n            selected.node.children.each(function (id) {\n                var selector = '[id=\"' + id + '\"]';\n\n                // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                selected.instance.deselect_node(\n                    selected.instance.get_node($(selector), false)\n                );\n                // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n            });\n        },\n\n        /**\n         * Add selected resources to form to be send later\n         *\n         * @param {Event} event\n         * @param {Object} selected\n         * @private\n         */\n        _changedNode: function (event, selected) {\n            var form = $(this.options.editFormSelector),\n                fieldName = this.options.resourceFieldName,\n                items = selected.selected.concat($(this.element).jstree('get_undetermined'));\n\n            if (this.options.editFormSelector === '') {\n                return;\n            }\n            form.find('input[name=\"' + this.options.resourceFieldName +  '\"]').remove();\n            items.each(function (id) {\n                $('<input>', {\n                    type: 'hidden',\n                    name: fieldName,\n                    value: id\n                }).appendTo(form);\n            });\n        }\n    });\n\n    return $.mage.rolesTree;\n});\n","Magento_User/js/delete-user-account.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var postData;\n\n    return function (params, elem) {\n\n        elem.on('click', function () {\n\n            postData = {\n                'data': {\n                    'user_id': params.objId,\n                    'current_password': $('[name=\"current_password\"]').val()\n                }\n            };\n\n            if ($.validator.validateElement($('[name=\"current_password\"]'))) {\n                window.deleteConfirm(params.message, params.url, postData);\n            }\n        });\n    };\n});\n","Magento_InventoryLowQuantityNotificationAdminUi/js/components/notify-stock-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (AbstractField) {\n    'use strict';\n\n    return AbstractField.extend({\n        defaults: {\n            notifyStockQtyUseDefault: '',\n            manageStock: '',\n            listens: {\n                notifyStockQtyUseDefault: 'onChange',\n                manageStock: 'onChange'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['notifyStockQtyUseDefault', 'manageStock']);\n        },\n\n        /**\n         * Disable input when Manage Stock switched off or Notify Quantity Use Default\n         */\n        onChange: function () {\n            this.disabled(\n                this.notifyStockQtyUseDefault() ||\n                this.manageStock()\n            );\n        }\n    });\n});\n","Magento_InventoryLowQuantityNotificationAdminUi/js/components/use-config-settings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (checkbox) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: '',\n            linkedValue: ''\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig', 'linkedValue']);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        'onCheckedChanged': function (newChecked) {\n            if (newChecked) {\n                this.linkedValue(this.valueFromConfig());\n            }\n\n            this._super(newChecked);\n        },\n\n        /**\n         * @returns {String}\n         */\n        getInitialValue: function () {\n            var values = [this.value(), this.default],\n                value;\n\n            values.some(function (v) {\n                value = v || !!v;\n\n                return value;\n            });\n\n            return this.normalizeData(value);\n        }\n    });\n});\n","chartjs/Chart.min.js":"/*!\n * Chart.js v3.3.2\n * https://www.chartjs.org\n * (c) 2021 Chart.js Contributors\n * Released under the MIT License\n */\n!function(t,e){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=e():\"function\"==typeof define&&define.amd?define(e):(t=\"undefined\"!=typeof globalThis?globalThis:t||self).Chart=e()}(this,(function(){\"use strict\";const t=\"undefined\"==typeof window?function(t){return t()}:window.requestAnimationFrame;function e(e,i,n){const o=n||(t=>Array.prototype.slice.call(t));let s=!1,a=[];return function(...n){a=o(n),s||(s=!0,t.call(window,(()=>{s=!1,e.apply(i,a)})))}}function i(t,e){let i;return function(){return e?(clearTimeout(i),i=setTimeout(t,e)):t(),e}}const n=t=>\"start\"===t?\"left\":\"end\"===t?\"right\":\"center\",o=(t,e,i)=>\"start\"===t?e:\"end\"===t?i:(e+i)/2,s=(t,e,i)=>\"right\"===t?i:\"center\"===t?(e+i)/2:e;var a=new class{constructor(){this._request=null,this._charts=new Map,this._running=!1,this._lastDate=void 0}_notify(t,e,i,n){const o=e.listeners[n],s=e.duration;o.forEach((n=>n({chart:t,initial:e.initial,numSteps:s,currentStep:Math.min(i-e.start,s)})))}_refresh(){const e=this;e._request||(e._running=!0,e._request=t.call(window,(()=>{e._update(),e._request=null,e._running&&e._refresh()})))}_update(t=Date.now()){const e=this;let i=0;e._charts.forEach(((n,o)=>{if(!n.running||!n.items.length)return;const s=n.items;let a,r=s.length-1,l=!1;for(;r>=0;--r)a=s[r],a._active?(a._total>n.duration&&(n.duration=a._total),a.tick(t),l=!0):(s[r]=s[s.length-1],s.pop());l&&(o.draw(),e._notify(o,n,t,\"progress\")),s.length||(n.running=!1,e._notify(o,n,t,\"complete\"),n.initial=!1),i+=s.length})),e._lastDate=t,0===i&&(e._running=!1)}_getAnims(t){const e=this._charts;let i=e.get(t);return i||(i={running:!1,initial:!0,items:[],listeners:{complete:[],progress:[]}},e.set(t,i)),i}listen(t,e,i){this._getAnims(t).listeners[e].push(i)}add(t,e){e&&e.length&&this._getAnims(t).items.push(...e)}has(t){return this._getAnims(t).items.length>0}start(t){const e=this._charts.get(t);e&&(e.running=!0,e.start=Date.now(),e.duration=e.items.reduce(((t,e)=>Math.max(t,e._duration)),0),this._refresh())}running(t){if(!this._running)return!1;const e=this._charts.get(t);return!!(e&&e.running&&e.items.length)}stop(t){const e=this._charts.get(t);if(!e||!e.items.length)return;const i=e.items;let n=i.length-1;for(;n>=0;--n)i[n].cancel();e.items=[],this._notify(t,e,Date.now(),\"complete\")}remove(t){return this._charts.delete(t)}};\n/*!\n * @kurkle/color v0.1.9\n * https://github.com/kurkle/color#readme\n * (c) 2020 Jukka Kurkela\n * Released under the MIT License\n */const r={0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9,A:10,B:11,C:12,D:13,E:14,F:15,a:10,b:11,c:12,d:13,e:14,f:15},l=\"0123456789ABCDEF\",c=t=>l[15&t],h=t=>l[(240&t)>>4]+l[15&t],d=t=>(240&t)>>4==(15&t);function u(t){var e=function(t){return d(t.r)&&d(t.g)&&d(t.b)&&d(t.a)}(t)?c:h;return t?\"#\"+e(t.r)+e(t.g)+e(t.b)+(t.a<255?e(t.a):\"\"):t}function f(t){return t+.5|0}const g=(t,e,i)=>Math.max(Math.min(t,i),e);function p(t){return g(f(2.55*t),0,255)}function m(t){return g(f(255*t),0,255)}function x(t){return g(f(t/2.55)/100,0,1)}function b(t){return g(f(100*t),0,100)}const _=/^rgba?\\(\\s*([-+.\\d]+)(%)?[\\s,]+([-+.e\\d]+)(%)?[\\s,]+([-+.e\\d]+)(%)?(?:[\\s,/]+([-+.e\\d]+)(%)?)?\\s*\\)$/;const y=/^(hsla?|hwb|hsv)\\(\\s*([-+.e\\d]+)(?:deg)?[\\s,]+([-+.e\\d]+)%[\\s,]+([-+.e\\d]+)%(?:[\\s,]+([-+.e\\d]+)(%)?)?\\s*\\)$/;function v(t,e,i){const n=e*Math.min(i,1-i),o=(e,o=(e+t/30)%12)=>i-n*Math.max(Math.min(o-3,9-o,1),-1);return[o(0),o(8),o(4)]}function w(t,e,i){const n=(n,o=(n+t/60)%6)=>i-i*e*Math.max(Math.min(o,4-o,1),0);return[n(5),n(3),n(1)]}function M(t,e,i){const n=v(t,1,.5);let o;for(e+i>1&&(o=1/(e+i),e*=o,i*=o),o=0;o<3;o++)n[o]*=1-e-i,n[o]+=e;return n}function k(t){const e=t.r/255,i=t.g/255,n=t.b/255,o=Math.max(e,i,n),s=Math.min(e,i,n),a=(o+s)/2;let r,l,c;return o!==s&&(c=o-s,l=a>.5?c/(2-o-s):c/(o+s),r=o===e?(i-n)/c+(i<n?6:0):o===i?(n-e)/c+2:(e-i)/c+4,r=60*r+.5),[0|r,l||0,a]}function S(t,e,i,n){return(Array.isArray(e)?t(e[0],e[1],e[2]):t(e,i,n)).map(m)}function P(t,e,i){return S(v,t,e,i)}function D(t){return(t%360+360)%360}function C(t){const e=y.exec(t);let i,n=255;if(!e)return;e[5]!==i&&(n=e[6]?p(+e[5]):m(+e[5]));const o=D(+e[2]),s=+e[3]/100,a=+e[4]/100;return i=\"hwb\"===e[1]?function(t,e,i){return S(M,t,e,i)}(o,s,a):\"hsv\"===e[1]?function(t,e,i){return S(w,t,e,i)}(o,s,a):P(o,s,a),{r:i[0],g:i[1],b:i[2],a:n}}const O={x:\"dark\",Z:\"light\",Y:\"re\",X:\"blu\",W:\"gr\",V:\"medium\",U:\"slate\",A:\"ee\",T:\"ol\",S:\"or\",B:\"ra\",C:\"lateg\",D:\"ights\",R:\"in\",Q:\"turquois\",E:\"hi\",P:\"ro\",O:\"al\",N:\"le\",M:\"de\",L:\"yello\",F:\"en\",K:\"ch\",G:\"arks\",H:\"ea\",I:\"ightg\",J:\"wh\"},T={OiceXe:\"f0f8ff\",antiquewEte:\"faebd7\",aqua:\"ffff\",aquamarRe:\"7fffd4\",azuY:\"f0ffff\",beige:\"f5f5dc\",bisque:\"ffe4c4\",black:\"0\",blanKedOmond:\"ffebcd\",Xe:\"ff\",XeviTet:\"8a2be2\",bPwn:\"a52a2a\",burlywood:\"deb887\",caMtXe:\"5f9ea0\",KartYuse:\"7fff00\",KocTate:\"d2691e\",cSO:\"ff7f50\",cSnflowerXe:\"6495ed\",cSnsilk:\"fff8dc\",crimson:\"dc143c\",cyan:\"ffff\",xXe:\"8b\",xcyan:\"8b8b\",xgTMnPd:\"b8860b\",xWay:\"a9a9a9\",xgYF:\"6400\",xgYy:\"a9a9a9\",xkhaki:\"bdb76b\",xmagFta:\"8b008b\",xTivegYF:\"556b2f\",xSange:\"ff8c00\",xScEd:\"9932cc\",xYd:\"8b0000\",xsOmon:\"e9967a\",xsHgYF:\"8fbc8f\",xUXe:\"483d8b\",xUWay:\"2f4f4f\",xUgYy:\"2f4f4f\",xQe:\"ced1\",xviTet:\"9400d3\",dAppRk:\"ff1493\",dApskyXe:\"bfff\",dimWay:\"696969\",dimgYy:\"696969\",dodgerXe:\"1e90ff\",fiYbrick:\"b22222\",flSOwEte:\"fffaf0\",foYstWAn:\"228b22\",fuKsia:\"ff00ff\",gaRsbSo:\"dcdcdc\",ghostwEte:\"f8f8ff\",gTd:\"ffd700\",gTMnPd:\"daa520\",Way:\"808080\",gYF:\"8000\",gYFLw:\"adff2f\",gYy:\"808080\",honeyMw:\"f0fff0\",hotpRk:\"ff69b4\",RdianYd:\"cd5c5c\",Rdigo:\"4b0082\",ivSy:\"fffff0\",khaki:\"f0e68c\",lavFMr:\"e6e6fa\",lavFMrXsh:\"fff0f5\",lawngYF:\"7cfc00\",NmoncEffon:\"fffacd\",ZXe:\"add8e6\",ZcSO:\"f08080\",Zcyan:\"e0ffff\",ZgTMnPdLw:\"fafad2\",ZWay:\"d3d3d3\",ZgYF:\"90ee90\",ZgYy:\"d3d3d3\",ZpRk:\"ffb6c1\",ZsOmon:\"ffa07a\",ZsHgYF:\"20b2aa\",ZskyXe:\"87cefa\",ZUWay:\"778899\",ZUgYy:\"778899\",ZstAlXe:\"b0c4de\",ZLw:\"ffffe0\",lime:\"ff00\",limegYF:\"32cd32\",lRF:\"faf0e6\",magFta:\"ff00ff\",maPon:\"800000\",VaquamarRe:\"66cdaa\",VXe:\"cd\",VScEd:\"ba55d3\",VpurpN:\"9370db\",VsHgYF:\"3cb371\",VUXe:\"7b68ee\",VsprRggYF:\"fa9a\",VQe:\"48d1cc\",VviTetYd:\"c71585\",midnightXe:\"191970\",mRtcYam:\"f5fffa\",mistyPse:\"ffe4e1\",moccasR:\"ffe4b5\",navajowEte:\"ffdead\",navy:\"80\",Tdlace:\"fdf5e6\",Tive:\"808000\",TivedBb:\"6b8e23\",Sange:\"ffa500\",SangeYd:\"ff4500\",ScEd:\"da70d6\",pOegTMnPd:\"eee8aa\",pOegYF:\"98fb98\",pOeQe:\"afeeee\",pOeviTetYd:\"db7093\",papayawEp:\"ffefd5\",pHKpuff:\"ffdab9\",peru:\"cd853f\",pRk:\"ffc0cb\",plum:\"dda0dd\",powMrXe:\"b0e0e6\",purpN:\"800080\",YbeccapurpN:\"663399\",Yd:\"ff0000\",Psybrown:\"bc8f8f\",PyOXe:\"4169e1\",saddNbPwn:\"8b4513\",sOmon:\"fa8072\",sandybPwn:\"f4a460\",sHgYF:\"2e8b57\",sHshell:\"fff5ee\",siFna:\"a0522d\",silver:\"c0c0c0\",skyXe:\"87ceeb\",UXe:\"6a5acd\",UWay:\"708090\",UgYy:\"708090\",snow:\"fffafa\",sprRggYF:\"ff7f\",stAlXe:\"4682b4\",tan:\"d2b48c\",teO:\"8080\",tEstN:\"d8bfd8\",tomato:\"ff6347\",Qe:\"40e0d0\",viTet:\"ee82ee\",JHt:\"f5deb3\",wEte:\"ffffff\",wEtesmoke:\"f5f5f5\",Lw:\"ffff00\",LwgYF:\"9acd32\"};let A;function L(t){A||(A=function(){const t={},e=Object.keys(T),i=Object.keys(O);let n,o,s,a,r;for(n=0;n<e.length;n++){for(a=r=e[n],o=0;o<i.length;o++)s=i[o],r=r.replace(s,O[s]);s=parseInt(T[a],16),t[r]=[s>>16&255,s>>8&255,255&s]}return t}(),A.transparent=[0,0,0,0]);const e=A[t.toLowerCase()];return e&&{r:e[0],g:e[1],b:e[2],a:4===e.length?e[3]:255}}function R(t,e,i){if(t){let n=k(t);n[e]=Math.max(0,Math.min(n[e]+n[e]*i,0===e?360:1)),n=P(n),t.r=n[0],t.g=n[1],t.b=n[2]}}function E(t,e){return t?Object.assign(e||{},t):t}function I(t){var e={r:0,g:0,b:0,a:255};return Array.isArray(t)?t.length>=3&&(e={r:t[0],g:t[1],b:t[2],a:255},t.length>3&&(e.a=m(t[3]))):(e=E(t,{r:0,g:0,b:0,a:1})).a=m(e.a),e}function z(t){return\"r\"===t.charAt(0)?function(t){const e=_.exec(t);let i,n,o,s=255;if(e){if(e[7]!==i){const t=+e[7];s=255&(e[8]?p(t):255*t)}return i=+e[1],n=+e[3],o=+e[5],i=255&(e[2]?p(i):i),n=255&(e[4]?p(n):n),o=255&(e[6]?p(o):o),{r:i,g:n,b:o,a:s}}}(t):C(t)}class F{constructor(t){if(t instanceof F)return t;const e=typeof t;let i;var n,o,s;\"object\"===e?i=I(t):\"string\"===e&&(s=(n=t).length,\"#\"===n[0]&&(4===s||5===s?o={r:255&17*r[n[1]],g:255&17*r[n[2]],b:255&17*r[n[3]],a:5===s?17*r[n[4]]:255}:7!==s&&9!==s||(o={r:r[n[1]]<<4|r[n[2]],g:r[n[3]]<<4|r[n[4]],b:r[n[5]]<<4|r[n[6]],a:9===s?r[n[7]]<<4|r[n[8]]:255})),i=o||L(t)||z(t)),this._rgb=i,this._valid=!!i}get valid(){return this._valid}get rgb(){var t=E(this._rgb);return t&&(t.a=x(t.a)),t}set rgb(t){this._rgb=I(t)}rgbString(){return this._valid?(t=this._rgb)&&(t.a<255?`rgba(${t.r}, ${t.g}, ${t.b}, ${x(t.a)})`:`rgb(${t.r}, ${t.g}, ${t.b})`):this._rgb;var t}hexString(){return this._valid?u(this._rgb):this._rgb}hslString(){return this._valid?function(t){if(!t)return;const e=k(t),i=e[0],n=b(e[1]),o=b(e[2]);return t.a<255?`hsla(${i}, ${n}%, ${o}%, ${x(t.a)})`:`hsl(${i}, ${n}%, ${o}%)`}(this._rgb):this._rgb}mix(t,e){const i=this;if(t){const n=i.rgb,o=t.rgb;let s;const a=e===s?.5:e,r=2*a-1,l=n.a-o.a,c=((r*l==-1?r:(r+l)/(1+r*l))+1)/2;s=1-c,n.r=255&c*n.r+s*o.r+.5,n.g=255&c*n.g+s*o.g+.5,n.b=255&c*n.b+s*o.b+.5,n.a=a*n.a+(1-a)*o.a,i.rgb=n}return i}clone(){return new F(this.rgb)}alpha(t){return this._rgb.a=m(t),this}clearer(t){return this._rgb.a*=1-t,this}greyscale(){const t=this._rgb,e=f(.3*t.r+.59*t.g+.11*t.b);return t.r=t.g=t.b=e,this}opaquer(t){return this._rgb.a*=1+t,this}negate(){const t=this._rgb;return t.r=255-t.r,t.g=255-t.g,t.b=255-t.b,this}lighten(t){return R(this._rgb,2,t),this}darken(t){return R(this._rgb,2,-t),this}saturate(t){return R(this._rgb,1,t),this}desaturate(t){return R(this._rgb,1,-t),this}rotate(t){return function(t,e){var i=k(t);i[0]=D(i[0]+e),i=P(i),t.r=i[0],t.g=i[1],t.b=i[2]}(this._rgb,t),this}}function V(t){return new F(t)}const B=t=>t instanceof CanvasGradient||t instanceof CanvasPattern;function W(t){return B(t)?t:V(t)}function H(t){return B(t)?t:V(t).saturate(.5).darken(.1).hexString()}function N(){}const j=function(){let t=0;return function(){return t++}}();function $(t){return null==t}function Y(t){if(Array.isArray&&Array.isArray(t))return!0;const e=Object.prototype.toString.call(t);return\"[object\"===e.substr(0,7)&&\"Array]\"===e.substr(-6)}function U(t){return null!==t&&\"[object Object]\"===Object.prototype.toString.call(t)}const X=t=>(\"number\"==typeof t||t instanceof Number)&&isFinite(+t);function q(t,e){return X(t)?t:e}function K(t,e){return void 0===t?e:t}const G=(t,e)=>\"string\"==typeof t&&t.endsWith(\"%\")?parseFloat(t)/100:t/e,Z=(t,e)=>\"string\"==typeof t&&t.endsWith(\"%\")?parseFloat(t)/100*e:+t;function Q(t,e,i){if(t&&\"function\"==typeof t.call)return t.apply(i,e)}function J(t,e,i,n){let o,s,a;if(Y(t))if(s=t.length,n)for(o=s-1;o>=0;o--)e.call(i,t[o],o);else for(o=0;o<s;o++)e.call(i,t[o],o);else if(U(t))for(a=Object.keys(t),s=a.length,o=0;o<s;o++)e.call(i,t[a[o]],a[o])}function tt(t,e){let i,n,o,s;if(!t||!e||t.length!==e.length)return!1;for(i=0,n=t.length;i<n;++i)if(o=t[i],s=e[i],o.datasetIndex!==s.datasetIndex||o.index!==s.index)return!1;return!0}function et(t){if(Y(t))return t.map(et);if(U(t)){const e=Object.create(null),i=Object.keys(t),n=i.length;let o=0;for(;o<n;++o)e[i[o]]=et(t[i[o]]);return e}return t}function it(t){return-1===[\"__proto__\",\"prototype\",\"constructor\"].indexOf(t)}function nt(t,e,i,n){if(!it(t))return;const o=e[t],s=i[t];U(o)&&U(s)?ot(o,s,n):e[t]=et(s)}function ot(t,e,i){const n=Y(e)?e:[e],o=n.length;if(!U(t))return t;const s=(i=i||{}).merger||nt;for(let a=0;a<o;++a){if(!U(e=n[a]))continue;const o=Object.keys(e);for(let n=0,a=o.length;n<a;++n)s(o[n],t,e,i)}return t}function st(t,e){return ot(t,e,{merger:at})}function at(t,e,i){if(!it(t))return;const n=e[t],o=i[t];U(n)&&U(o)?st(n,o):Object.prototype.hasOwnProperty.call(e,t)||(e[t]=et(o))}function rt(t,e){const i=t.indexOf(\".\",e);return-1===i?t.length:i}function lt(t,e){if(\"\"===e)return t;let i=0,n=rt(e,i);for(;t&&n>i;)t=t[e.substr(i,n-i)],i=n+1,n=rt(e,i);return t}function ct(t){return t.charAt(0).toUpperCase()+t.slice(1)}const ht=t=>void 0!==t,dt=t=>\"function\"==typeof t,ut=(t,e)=>{if(t.size!==e.size)return!1;for(const i of t)if(!e.has(i))return!1;return!0},ft=Object.create(null),gt=Object.create(null);function pt(t,e){if(!e)return t;const i=e.split(\".\");for(let e=0,n=i.length;e<n;++e){const n=i[e];t=t[n]||(t[n]=Object.create(null))}return t}function mt(t,e,i){return\"string\"==typeof e?ot(pt(t,e),i):ot(pt(t,\"\"),e)}var xt=new class{constructor(t){this.animation=void 0,this.backgroundColor=\"rgba(0,0,0,0.1)\",this.borderColor=\"rgba(0,0,0,0.1)\",this.color=\"#666\",this.datasets={},this.devicePixelRatio=t=>t.chart.platform.getDevicePixelRatio(),this.elements={},this.events=[\"mousemove\",\"mouseout\",\"click\",\"touchstart\",\"touchmove\"],this.font={family:\"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif\",size:12,style:\"normal\",lineHeight:1.2,weight:null},this.hover={},this.hoverBackgroundColor=(t,e)=>H(e.backgroundColor),this.hoverBorderColor=(t,e)=>H(e.borderColor),this.hoverColor=(t,e)=>H(e.color),this.indexAxis=\"x\",this.interaction={mode:\"nearest\",intersect:!0},this.maintainAspectRatio=!0,this.onHover=null,this.onClick=null,this.parsing=!0,this.plugins={},this.responsive=!0,this.scale=void 0,this.scales={},this.showLine=!0,this.describe(t)}set(t,e){return mt(this,t,e)}get(t){return pt(this,t)}describe(t,e){return mt(gt,t,e)}override(t,e){return mt(ft,t,e)}route(t,e,i,n){const o=pt(this,t),s=pt(this,i),a=\"_\"+e;Object.defineProperties(o,{[a]:{value:o[e],writable:!0},[e]:{enumerable:!0,get(){const t=this[a],e=s[n];return U(t)?Object.assign({},e,t):K(t,e)},set(t){this[a]=t}}})}}({_scriptable:t=>!t.startsWith(\"on\"),_indexable:t=>\"events\"!==t,hover:{_fallback:\"interaction\"},interaction:{_scriptable:!1,_indexable:!1}});const bt=Math.PI,_t=2*bt,yt=_t+bt,vt=Number.POSITIVE_INFINITY,wt=bt/180,Mt=bt/2,kt=bt/4,St=2*bt/3,Pt=Math.log10,Dt=Math.sign;function Ct(t){const e=Math.pow(10,Math.floor(Pt(t))),i=t/e;return(i<=1?1:i<=2?2:i<=5?5:10)*e}function Ot(t){const e=[],i=Math.sqrt(t);let n;for(n=1;n<i;n++)t%n==0&&(e.push(n),e.push(t/n));return i===(0|i)&&e.push(i),e.sort(((t,e)=>t-e)).pop(),e}function Tt(t){return!isNaN(parseFloat(t))&&isFinite(t)}function At(t,e,i){return Math.abs(t-e)<i}function Lt(t,e){const i=Math.round(t);return i-e<=t&&i+e>=t}function Rt(t,e,i){let n,o,s;for(n=0,o=t.length;n<o;n++)s=t[n][i],isNaN(s)||(e.min=Math.min(e.min,s),e.max=Math.max(e.max,s))}function Et(t){return t*(bt/180)}function It(t){return t*(180/bt)}function zt(t){if(!X(t))return;let e=1,i=0;for(;Math.round(t*e)/e!==t;)e*=10,i++;return i}function Ft(t,e){const i=e.x-t.x,n=e.y-t.y,o=Math.sqrt(i*i+n*n);let s=Math.atan2(n,i);return s<-.5*bt&&(s+=_t),{angle:s,distance:o}}function Vt(t,e){return Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2))}function Bt(t,e){return(t-e+yt)%_t-bt}function Wt(t){return(t%_t+_t)%_t}function Ht(t,e,i,n){const o=Wt(t),s=Wt(e),a=Wt(i),r=Wt(s-o),l=Wt(a-o),c=Wt(o-s),h=Wt(o-a);return o===s||o===a||n&&s===a||r>l&&c<h}function Nt(t,e,i){return Math.max(e,Math.min(i,t))}function jt(t){return Nt(t,-32768,32767)}function $t(t){return!t||$(t.size)||$(t.family)?null:(t.style?t.style+\" \":\"\")+(t.weight?t.weight+\" \":\"\")+t.size+\"px \"+t.family}function Yt(t,e,i,n,o){let s=e[o];return s||(s=e[o]=t.measureText(o).width,i.push(o)),s>n&&(n=s),n}function Ut(t,e,i,n){let o=(n=n||{}).data=n.data||{},s=n.garbageCollect=n.garbageCollect||[];n.font!==e&&(o=n.data={},s=n.garbageCollect=[],n.font=e),t.save(),t.font=e;let a=0;const r=i.length;let l,c,h,d,u;for(l=0;l<r;l++)if(d=i[l],null!=d&&!0!==Y(d))a=Yt(t,o,s,a,d);else if(Y(d))for(c=0,h=d.length;c<h;c++)u=d[c],null==u||Y(u)||(a=Yt(t,o,s,a,u));t.restore();const f=s.length/2;if(f>i.length){for(l=0;l<f;l++)delete o[s[l]];s.splice(0,f)}return a}function Xt(t,e,i){const n=t.currentDevicePixelRatio,o=0!==i?Math.max(i/2,.5):0;return Math.round((e-o)*n)/n+o}function qt(t,e){(e=e||t.getContext(\"2d\")).save(),e.resetTransform(),e.clearRect(0,0,t.width,t.height),e.restore()}function Kt(t,e,i,n){let o,s,a,r,l;const c=e.pointStyle,h=e.rotation,d=e.radius;let u=(h||0)*wt;if(c&&\"object\"==typeof c&&(o=c.toString(),\"[object HTMLImageElement]\"===o||\"[object HTMLCanvasElement]\"===o))return t.save(),t.translate(i,n),t.rotate(u),t.drawImage(c,-c.width/2,-c.height/2,c.width,c.height),void t.restore();if(!(isNaN(d)||d<=0)){switch(t.beginPath(),c){default:t.arc(i,n,d,0,_t),t.closePath();break;case\"triangle\":t.moveTo(i+Math.sin(u)*d,n-Math.cos(u)*d),u+=St,t.lineTo(i+Math.sin(u)*d,n-Math.cos(u)*d),u+=St,t.lineTo(i+Math.sin(u)*d,n-Math.cos(u)*d),t.closePath();break;case\"rectRounded\":l=.516*d,r=d-l,s=Math.cos(u+kt)*r,a=Math.sin(u+kt)*r,t.arc(i-s,n-a,l,u-bt,u-Mt),t.arc(i+a,n-s,l,u-Mt,u),t.arc(i+s,n+a,l,u,u+Mt),t.arc(i-a,n+s,l,u+Mt,u+bt),t.closePath();break;case\"rect\":if(!h){r=Math.SQRT1_2*d,t.rect(i-r,n-r,2*r,2*r);break}u+=kt;case\"rectRot\":s=Math.cos(u)*d,a=Math.sin(u)*d,t.moveTo(i-s,n-a),t.lineTo(i+a,n-s),t.lineTo(i+s,n+a),t.lineTo(i-a,n+s),t.closePath();break;case\"crossRot\":u+=kt;case\"cross\":s=Math.cos(u)*d,a=Math.sin(u)*d,t.moveTo(i-s,n-a),t.lineTo(i+s,n+a),t.moveTo(i+a,n-s),t.lineTo(i-a,n+s);break;case\"star\":s=Math.cos(u)*d,a=Math.sin(u)*d,t.moveTo(i-s,n-a),t.lineTo(i+s,n+a),t.moveTo(i+a,n-s),t.lineTo(i-a,n+s),u+=kt,s=Math.cos(u)*d,a=Math.sin(u)*d,t.moveTo(i-s,n-a),t.lineTo(i+s,n+a),t.moveTo(i+a,n-s),t.lineTo(i-a,n+s);break;case\"line\":s=Math.cos(u)*d,a=Math.sin(u)*d,t.moveTo(i-s,n-a),t.lineTo(i+s,n+a);break;case\"dash\":t.moveTo(i,n),t.lineTo(i+Math.cos(u)*d,n+Math.sin(u)*d)}t.fill(),e.borderWidth>0&&t.stroke()}}function Gt(t,e,i){return i=i||.5,t&&t.x>e.left-i&&t.x<e.right+i&&t.y>e.top-i&&t.y<e.bottom+i}function Zt(t,e){t.save(),t.beginPath(),t.rect(e.left,e.top,e.right-e.left,e.bottom-e.top),t.clip()}function Qt(t){t.restore()}function Jt(t,e,i,n,o){if(!e)return t.lineTo(i.x,i.y);if(\"middle\"===o){const n=(e.x+i.x)/2;t.lineTo(n,e.y),t.lineTo(n,i.y)}else\"after\"===o!=!!n?t.lineTo(e.x,i.y):t.lineTo(i.x,e.y);t.lineTo(i.x,i.y)}function te(t,e,i,n){if(!e)return t.lineTo(i.x,i.y);t.bezierCurveTo(n?e.cp1x:e.cp2x,n?e.cp1y:e.cp2y,n?i.cp2x:i.cp1x,n?i.cp2y:i.cp1y,i.x,i.y)}function ee(t,e,i,n,o,s={}){const a=Y(e)?e:[e],r=s.strokeWidth>0&&\"\"!==s.strokeColor;let l,c;for(t.save(),s.translation&&t.translate(s.translation[0],s.translation[1]),$(s.rotation)||t.rotate(s.rotation),t.font=o.string,s.color&&(t.fillStyle=s.color),s.textAlign&&(t.textAlign=s.textAlign),s.textBaseline&&(t.textBaseline=s.textBaseline),l=0;l<a.length;++l){if(c=a[l],r&&(s.strokeColor&&(t.strokeStyle=s.strokeColor),$(s.strokeWidth)||(t.lineWidth=s.strokeWidth),t.strokeText(c,i,n,s.maxWidth)),t.fillText(c,i,n,s.maxWidth),s.strikethrough||s.underline){const e=t.measureText(c),o=i-e.actualBoundingBoxLeft,a=i+e.actualBoundingBoxRight,r=n-e.actualBoundingBoxAscent,l=n+e.actualBoundingBoxDescent,h=s.strikethrough?(r+l)/2:l;t.strokeStyle=t.fillStyle,t.beginPath(),t.lineWidth=s.decorationWidth||2,t.moveTo(o,h),t.lineTo(a,h),t.stroke()}n+=o.lineHeight}t.restore()}function ie(t,e){const{x:i,y:n,w:o,h:s,radius:a}=e;t.arc(i+a.topLeft,n+a.topLeft,a.topLeft,-Mt,bt,!0),t.lineTo(i,n+s-a.bottomLeft),t.arc(i+a.bottomLeft,n+s-a.bottomLeft,a.bottomLeft,bt,Mt,!0),t.lineTo(i+o-a.bottomRight,n+s),t.arc(i+o-a.bottomRight,n+s-a.bottomRight,a.bottomRight,Mt,0,!0),t.lineTo(i+o,n+a.topRight),t.arc(i+o-a.topRight,n+a.topRight,a.topRight,0,-Mt,!0),t.lineTo(i+a.topLeft,n)}function ne(t,e,i){i=i||(i=>t[i]<e);let n,o=t.length-1,s=0;for(;o-s>1;)n=s+o>>1,i(n)?s=n:o=n;return{lo:s,hi:o}}const oe=(t,e,i)=>ne(t,i,(n=>t[n][e]<i)),se=(t,e,i)=>ne(t,i,(n=>t[n][e]>=i));function ae(t,e,i){let n=0,o=t.length;for(;n<o&&t[n]<e;)n++;for(;o>n&&t[o-1]>i;)o--;return n>0||o<t.length?t.slice(n,o):t}const re=[\"push\",\"pop\",\"shift\",\"splice\",\"unshift\"];function le(t,e){t._chartjs?t._chartjs.listeners.push(e):(Object.defineProperty(t,\"_chartjs\",{configurable:!0,enumerable:!1,value:{listeners:[e]}}),re.forEach((e=>{const i=\"_onData\"+ct(e),n=t[e];Object.defineProperty(t,e,{configurable:!0,enumerable:!1,value(...e){const o=n.apply(this,e);return t._chartjs.listeners.forEach((t=>{\"function\"==typeof t[i]&&t[i](...e)})),o}})})))}function ce(t,e){const i=t._chartjs;if(!i)return;const n=i.listeners,o=n.indexOf(e);-1!==o&&n.splice(o,1),n.length>0||(re.forEach((e=>{delete t[e]})),delete t._chartjs)}function he(t){const e=new Set;let i,n;for(i=0,n=t.length;i<n;++i)e.add(t[i]);if(e.size===n)return t;const o=[];return e.forEach((t=>{o.push(t)})),o}function de(t){let e=t.parentNode;return e&&\"[object ShadowRoot]\"===e.toString()&&(e=e.host),e}function ue(t,e,i){let n;return\"string\"==typeof t?(n=parseInt(t,10),-1!==t.indexOf(\"%\")&&(n=n/100*e.parentNode[i])):n=t,n}const fe=t=>window.getComputedStyle(t,null);function ge(t,e){return fe(t).getPropertyValue(e)}const pe=[\"top\",\"right\",\"bottom\",\"left\"];function me(t,e,i){const n={};i=i?\"-\"+i:\"\";for(let o=0;o<4;o++){const s=pe[o];n[s]=parseFloat(t[e+\"-\"+s+i])||0}return n.width=n.left+n.right,n.height=n.top+n.bottom,n}function xe(t,e){const{canvas:i,currentDevicePixelRatio:n}=e,o=fe(i),s=\"border-box\"===o.boxSizing,a=me(o,\"padding\"),r=me(o,\"border\",\"width\"),{x:l,y:c,box:h}=function(t,e){const i=t.native||t,n=i.touches,o=n&&n.length?n[0]:i,{offsetX:s,offsetY:a}=o;let r,l,c=!1;if(((t,e,i)=>(t>0||e>0)&&(!i||!i.shadowRoot))(s,a,i.target))r=s,l=a;else{const t=e.getBoundingClientRect();r=o.clientX-t.left,l=o.clientY-t.top,c=!0}return{x:r,y:l,box:c}}(t,i),d=a.left+(h&&r.left),u=a.top+(h&&r.top);let{width:f,height:g}=e;return s&&(f-=a.width+r.width,g-=a.height+r.height),{x:Math.round((l-d)/f*i.width/n),y:Math.round((c-u)/g*i.height/n)}}const be=t=>Math.round(10*t)/10;function _e(t,e,i,n){const o=fe(t),s=me(o,\"margin\"),a=ue(o.maxWidth,t,\"clientWidth\")||vt,r=ue(o.maxHeight,t,\"clientHeight\")||vt,l=function(t,e,i){let n,o;if(void 0===e||void 0===i){const s=de(t);if(s){const t=s.getBoundingClientRect(),a=fe(s),r=me(a,\"border\",\"width\"),l=me(a,\"padding\");e=t.width-l.width-r.width,i=t.height-l.height-r.height,n=ue(a.maxWidth,s,\"clientWidth\"),o=ue(a.maxHeight,s,\"clientHeight\")}else e=t.clientWidth,i=t.clientHeight}return{width:e,height:i,maxWidth:n||vt,maxHeight:o||vt}}(t,e,i);let{width:c,height:h}=l;if(\"content-box\"===o.boxSizing){const t=me(o,\"border\",\"width\"),e=me(o,\"padding\");c-=e.width+t.width,h-=e.height+t.height}return c=Math.max(0,c-s.width),h=Math.max(0,n?Math.floor(c/n):h-s.height),c=be(Math.min(c,a,l.maxWidth)),h=be(Math.min(h,r,l.maxHeight)),c&&!h&&(h=be(c/2)),{width:c,height:h}}function ye(t,e,i){const n=e||1,o=Math.floor(t.height*n),s=Math.floor(t.width*n);t.height=o/n,t.width=s/n;const a=t.canvas;return a.style&&(i||!a.style.height&&!a.style.width)&&(a.style.height=`${t.height}px`,a.style.width=`${t.width}px`),(t.currentDevicePixelRatio!==n||a.height!==o||a.width!==s)&&(t.currentDevicePixelRatio=n,a.height=o,a.width=s,t.ctx.setTransform(n,0,0,n,0,0),!0)}const ve=function(){let t=!1;try{const e={get passive(){return t=!0,!1}};window.addEventListener(\"test\",null,e),window.removeEventListener(\"test\",null,e)}catch(t){}return t}();function we(t,e){const i=ge(t,e),n=i&&i.match(/^(\\d+)(\\.\\d+)?px$/);return n?+n[1]:void 0}function Me(t,e){return\"native\"in t?{x:t.x,y:t.y}:xe(t,e)}function ke(t,e,i,n){const{controller:o,data:s,_sorted:a}=t,r=o._cachedMeta.iScale;if(r&&e===r.axis&&a&&s.length){const t=r._reversePixels?se:oe;if(!n)return t(s,e,i);if(o._sharedOptions){const n=s[0],o=\"function\"==typeof n.getRange&&n.getRange(e);if(o){const n=t(s,e,i-o),a=t(s,e,i+o);return{lo:n.lo,hi:a.hi}}}}return{lo:0,hi:s.length-1}}function Se(t,e,i,n,o){const s=t.getSortedVisibleDatasetMetas(),a=i[e];for(let t=0,i=s.length;t<i;++t){const{index:i,data:r}=s[t],{lo:l,hi:c}=ke(s[t],e,a,o);for(let t=l;t<=c;++t){const e=r[t];e.skip||n(e,i,t)}}}function Pe(t,e,i,n){const o=[];if(!Gt(e,t.chartArea,t._minPadding))return o;return Se(t,i,e,(function(t,i,s){t.inRange(e.x,e.y,n)&&o.push({element:t,datasetIndex:i,index:s})}),!0),o}function De(t,e,i,n,o){const s=function(t){const e=-1!==t.indexOf(\"x\"),i=-1!==t.indexOf(\"y\");return function(t,n){const o=e?Math.abs(t.x-n.x):0,s=i?Math.abs(t.y-n.y):0;return Math.sqrt(Math.pow(o,2)+Math.pow(s,2))}}(i);let a=Number.POSITIVE_INFINITY,r=[];if(!Gt(e,t.chartArea,t._minPadding))return r;return Se(t,i,e,(function(i,l,c){if(n&&!i.inRange(e.x,e.y,o))return;const h=i.getCenterPoint(o);if(!Gt(h,t.chartArea,t._minPadding))return;const d=s(e,h);d<a?(r=[{element:i,datasetIndex:l,index:c}],a=d):d===a&&r.push({element:i,datasetIndex:l,index:c})})),r}function Ce(t,e,i,n){const o=Me(e,t),s=[],a=i.axis,r=\"x\"===a?\"inXRange\":\"inYRange\";let l=!1;return function(t,e){const i=t.getSortedVisibleDatasetMetas();let n,o,s;for(let t=0,a=i.length;t<a;++t){({index:n,data:o}=i[t]);for(let t=0,i=o.length;t<i;++t)s=o[t],s.skip||e(s,n,t)}}(t,((t,e,i)=>{t[r](o[a],n)&&s.push({element:t,datasetIndex:e,index:i}),t.inRange(o.x,o.y,n)&&(l=!0)})),i.intersect&&!l?[]:s}var Oe={modes:{index(t,e,i,n){const o=Me(e,t),s=i.axis||\"x\",a=i.intersect?Pe(t,o,s,n):De(t,o,s,!1,n),r=[];return a.length?(t.getSortedVisibleDatasetMetas().forEach((t=>{const e=a[0].index,i=t.data[e];i&&!i.skip&&r.push({element:i,datasetIndex:t.index,index:e})})),r):[]},dataset(t,e,i,n){const o=Me(e,t),s=i.axis||\"xy\";let a=i.intersect?Pe(t,o,s,n):De(t,o,s,!1,n);if(a.length>0){const e=a[0].datasetIndex,i=t.getDatasetMeta(e).data;a=[];for(let t=0;t<i.length;++t)a.push({element:i[t],datasetIndex:e,index:t})}return a},point:(t,e,i,n)=>Pe(t,Me(e,t),i.axis||\"xy\",n),nearest:(t,e,i,n)=>De(t,Me(e,t),i.axis||\"xy\",i.intersect,n),x:(t,e,i,n)=>(i.axis=\"x\",Ce(t,e,i,n)),y:(t,e,i,n)=>(i.axis=\"y\",Ce(t,e,i,n))}};const Te=new RegExp(/^(normal|(\\d+(?:\\.\\d+)?)(px|em|%)?)$/),Ae=new RegExp(/^(normal|italic|initial|inherit|unset|(oblique( -?[0-9]?[0-9]deg)?))$/);function Le(t,e){const i=(\"\"+t).match(Te);if(!i||\"normal\"===i[1])return 1.2*e;switch(t=+i[2],i[3]){case\"px\":return t;case\"%\":t/=100}return e*t}function Re(t,e){const i={},n=U(e),o=n?Object.keys(e):e,s=U(t)?n?i=>K(t[i],t[e[i]]):e=>t[e]:()=>t;for(const t of o)i[t]=+s(t)||0;return i}function Ee(t){return Re(t,{top:\"y\",right:\"x\",bottom:\"y\",left:\"x\"})}function Ie(t){return Re(t,[\"topLeft\",\"topRight\",\"bottomLeft\",\"bottomRight\"])}function ze(t){const e=Ee(t);return e.width=e.left+e.right,e.height=e.top+e.bottom,e}function Fe(t,e){t=t||{},e=e||xt.font;let i=K(t.size,e.size);\"string\"==typeof i&&(i=parseInt(i,10));let n=K(t.style,e.style);n&&!(\"\"+n).match(Ae)&&(console.warn('Invalid font style specified: \"'+n+'\"'),n=\"\");const o={family:K(t.family,e.family),lineHeight:Le(K(t.lineHeight,e.lineHeight),i),size:i,style:n,weight:K(t.weight,e.weight),string:\"\"};return o.string=$t(o),o}function Ve(t,e,i,n){let o,s,a,r=!0;for(o=0,s=t.length;o<s;++o)if(a=t[o],void 0!==a&&(void 0!==e&&\"function\"==typeof a&&(a=a(e),r=!1),void 0!==i&&Y(a)&&(a=a[i%a.length],r=!1),void 0!==a))return n&&!r&&(n.cacheable=!1),a}function Be(t,e){const{min:i,max:n}=t;return{min:i-Math.abs(Z(e,i)),max:n+Z(e,n)}}const We=[\"left\",\"top\",\"right\",\"bottom\"];function He(t,e){return t.filter((t=>t.pos===e))}function Ne(t,e){return t.filter((t=>-1===We.indexOf(t.pos)&&t.box.axis===e))}function je(t,e){return t.sort(((t,i)=>{const n=e?i:t,o=e?t:i;return n.weight===o.weight?n.index-o.index:n.weight-o.weight}))}function $e(t,e,i,n){return Math.max(t[i],e[i])+Math.max(t[n],e[n])}function Ye(t,e){t.top=Math.max(t.top,e.top),t.left=Math.max(t.left,e.left),t.bottom=Math.max(t.bottom,e.bottom),t.right=Math.max(t.right,e.right)}function Ue(t,e,i){const n=i.box,o=t.maxPadding;U(i.pos)||(i.size&&(t[i.pos]-=i.size),i.size=i.horizontal?n.height:n.width,t[i.pos]+=i.size),n.getPadding&&Ye(o,n.getPadding());const s=Math.max(0,e.outerWidth-$e(o,t,\"left\",\"right\")),a=Math.max(0,e.outerHeight-$e(o,t,\"top\",\"bottom\")),r=s!==t.w,l=a!==t.h;return t.w=s,t.h=a,i.horizontal?{same:r,other:l}:{same:l,other:r}}function Xe(t,e){const i=e.maxPadding;function n(t){const n={left:0,top:0,right:0,bottom:0};return t.forEach((t=>{n[t]=Math.max(e[t],i[t])})),n}return n(t?[\"left\",\"right\"]:[\"top\",\"bottom\"])}function qe(t,e,i){const n=[];let o,s,a,r,l,c;for(o=0,s=t.length,l=0;o<s;++o){a=t[o],r=a.box,r.update(a.width||e.w,a.height||e.h,Xe(a.horizontal,e));const{same:s,other:h}=Ue(e,i,a);l|=s&&n.length,c=c||h,r.fullSize||n.push(a)}return l&&qe(n,e,i)||c}function Ke(t,e,i){const n=i.padding;let o,s,a,r,l=e.x,c=e.y;for(o=0,s=t.length;o<s;++o)a=t[o],r=a.box,a.horizontal?(r.left=r.fullSize?n.left:e.left,r.right=r.fullSize?i.outerWidth-n.right:e.left+e.w,r.top=c,r.bottom=c+r.height,r.width=r.right-r.left,c=r.bottom):(r.left=l,r.right=l+r.width,r.top=r.fullSize?n.top:e.top,r.bottom=r.fullSize?i.outerHeight-n.right:e.top+e.h,r.height=r.bottom-r.top,l=r.right);e.x=l,e.y=c}xt.set(\"layout\",{padding:{top:0,right:0,bottom:0,left:0}});var Ge={addBox(t,e){t.boxes||(t.boxes=[]),e.fullSize=e.fullSize||!1,e.position=e.position||\"top\",e.weight=e.weight||0,e._layers=e._layers||function(){return[{z:0,draw(t){e.draw(t)}}]},t.boxes.push(e)},removeBox(t,e){const i=t.boxes?t.boxes.indexOf(e):-1;-1!==i&&t.boxes.splice(i,1)},configure(t,e,i){e.fullSize=i.fullSize,e.position=i.position,e.weight=i.weight},update(t,e,i,n){if(!t)return;const o=ze(t.options.layout.padding),s=Math.max(e-o.width,0),a=Math.max(i-o.height,0),r=function(t){const e=function(t){const e=[];let i,n,o;for(i=0,n=(t||[]).length;i<n;++i)o=t[i],e.push({index:i,box:o,pos:o.position,horizontal:o.isHorizontal(),weight:o.weight});return e}(t),i=je(e.filter((t=>t.box.fullSize)),!0),n=je(He(e,\"left\"),!0),o=je(He(e,\"right\")),s=je(He(e,\"top\"),!0),a=je(He(e,\"bottom\")),r=Ne(e,\"x\"),l=Ne(e,\"y\");return{fullSize:i,leftAndTop:n.concat(s),rightAndBottom:o.concat(l).concat(a).concat(r),chartArea:He(e,\"chartArea\"),vertical:n.concat(o).concat(l),horizontal:s.concat(a).concat(r)}}(t.boxes),l=r.vertical,c=r.horizontal;J(t.boxes,(t=>{\"function\"==typeof t.beforeLayout&&t.beforeLayout()}));const h=l.reduce(((t,e)=>e.box.options&&!1===e.box.options.display?t:t+1),0)||1,d=Object.freeze({outerWidth:e,outerHeight:i,padding:o,availableWidth:s,availableHeight:a,vBoxMaxWidth:s/2/h,hBoxMaxHeight:a/2}),u=Object.assign({},o);Ye(u,ze(n));const f=Object.assign({maxPadding:u,w:s,h:a,x:o.left,y:o.top},o);!function(t,e){let i,n,o;for(i=0,n=t.length;i<n;++i)o=t[i],o.horizontal?(o.width=o.box.fullSize&&e.availableWidth,o.height=e.hBoxMaxHeight):(o.width=e.vBoxMaxWidth,o.height=o.box.fullSize&&e.availableHeight)}(l.concat(c),d),qe(r.fullSize,f,d),qe(l,f,d),qe(c,f,d)&&qe(l,f,d),function(t){const e=t.maxPadding;function i(i){const n=Math.max(e[i]-t[i],0);return t[i]+=n,n}t.y+=i(\"top\"),t.x+=i(\"left\"),i(\"right\"),i(\"bottom\")}(f),Ke(r.leftAndTop,f,d),f.x+=f.w,f.y+=f.h,Ke(r.rightAndBottom,f,d),t.chartArea={left:f.left,top:f.top,right:f.left+f.w,bottom:f.top+f.h,height:f.h,width:f.w},J(r.chartArea,(e=>{const i=e.box;Object.assign(i,t.chartArea),i.update(f.w,f.h)}))}};class Ze{acquireContext(t,e){}releaseContext(t){return!1}addEventListener(t,e,i){}removeEventListener(t,e,i){}getDevicePixelRatio(){return 1}getMaximumSize(t,e,i,n){return e=Math.max(0,e||t.width),i=i||t.height,{width:e,height:Math.max(0,n?Math.floor(e/n):i)}}isAttached(t){return!0}}class Qe extends Ze{acquireContext(t){return t&&t.getContext&&t.getContext(\"2d\")||null}}const Je={touchstart:\"mousedown\",touchmove:\"mousemove\",touchend:\"mouseup\",pointerenter:\"mouseenter\",pointerdown:\"mousedown\",pointermove:\"mousemove\",pointerup:\"mouseup\",pointerleave:\"mouseout\",pointerout:\"mouseout\"},ti=t=>null===t||\"\"===t;const ei=!!ve&&{passive:!0};function ii(t,e,i){t.canvas.removeEventListener(e,i,ei)}function ni(t,e,i){const n=t.canvas,o=n&&de(n)||n,s=new MutationObserver((t=>{const e=de(o);t.forEach((t=>{for(let n=0;n<t.addedNodes.length;n++){const s=t.addedNodes[n];s!==o&&s!==e||i(t.target)}}))}));return s.observe(document,{childList:!0,subtree:!0}),s}function oi(t,e,i){const n=t.canvas,o=n&&de(n);if(!o)return;const s=new MutationObserver((t=>{t.forEach((t=>{for(let e=0;e<t.removedNodes.length;e++)if(t.removedNodes[e]===n){i();break}}))}));return s.observe(o,{childList:!0}),s}const si=new Map;let ai=0;function ri(){const t=window.devicePixelRatio;t!==ai&&(ai=t,si.forEach(((e,i)=>{i.currentDevicePixelRatio!==t&&e()})))}function li(t,i,n){const o=t.canvas,s=o&&de(o);if(!s)return;const a=e(((t,e)=>{const i=s.clientWidth;n(t,e),i<s.clientWidth&&n()}),window),r=new ResizeObserver((t=>{const e=t[0],i=e.contentRect.width,n=e.contentRect.height;0===i&&0===n||a(i,n)}));return r.observe(s),function(t,e){si.size||window.addEventListener(\"resize\",ri),si.set(t,e)}(t,a),r}function ci(t,e,i){i&&i.disconnect(),\"resize\"===e&&function(t){si.delete(t),si.size||window.removeEventListener(\"resize\",ri)}(t)}function hi(t,i,n){const o=t.canvas,s=e((e=>{null!==t.ctx&&n(function(t,e){const i=Je[t.type]||t.type,{x:n,y:o}=xe(t,e);return{type:i,chart:e,native:t,x:void 0!==n?n:null,y:void 0!==o?o:null}}(e,t))}),t,(t=>{const e=t[0];return[e,e.offsetX,e.offsetY]}));return function(t,e,i){t.addEventListener(e,i,ei)}(o,i,s),s}class di extends Ze{acquireContext(t,e){const i=t&&t.getContext&&t.getContext(\"2d\");return i&&i.canvas===t?(function(t,e){const i=t.style,n=t.getAttribute(\"height\"),o=t.getAttribute(\"width\");if(t.$chartjs={initial:{height:n,width:o,style:{display:i.display,height:i.height,width:i.width}}},i.display=i.display||\"block\",i.boxSizing=i.boxSizing||\"border-box\",ti(o)){const e=we(t,\"width\");void 0!==e&&(t.width=e)}if(ti(n))if(\"\"===t.style.height)t.height=t.width/(e||2);else{const e=we(t,\"height\");void 0!==e&&(t.height=e)}}(t,e),i):null}releaseContext(t){const e=t.canvas;if(!e.$chartjs)return!1;const i=e.$chartjs.initial;[\"height\",\"width\"].forEach((t=>{const n=i[t];$(n)?e.removeAttribute(t):e.setAttribute(t,n)}));const n=i.style||{};return Object.keys(n).forEach((t=>{e.style[t]=n[t]})),e.width=e.width,delete e.$chartjs,!0}addEventListener(t,e,i){this.removeEventListener(t,e);const n=t.$proxies||(t.$proxies={}),o={attach:ni,detach:oi,resize:li}[e]||hi;n[e]=o(t,e,i)}removeEventListener(t,e){const i=t.$proxies||(t.$proxies={}),n=i[e];if(!n)return;({attach:ci,detach:ci,resize:ci}[e]||ii)(t,e,n),i[e]=void 0}getDevicePixelRatio(){return window.devicePixelRatio}getMaximumSize(t,e,i,n){return _e(t,e,i,n)}isAttached(t){const e=de(t);return!(!e||!de(e))}}var ui=Object.freeze({__proto__:null,BasePlatform:Ze,BasicPlatform:Qe,DomPlatform:di});const fi=t=>0===t||1===t,gi=(t,e,i)=>-Math.pow(2,10*(t-=1))*Math.sin((t-e)*_t/i),pi=(t,e,i)=>Math.pow(2,-10*t)*Math.sin((t-e)*_t/i)+1,mi={linear:t=>t,easeInQuad:t=>t*t,easeOutQuad:t=>-t*(t-2),easeInOutQuad:t=>(t/=.5)<1?.5*t*t:-.5*(--t*(t-2)-1),easeInCubic:t=>t*t*t,easeOutCubic:t=>(t-=1)*t*t+1,easeInOutCubic:t=>(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2),easeInQuart:t=>t*t*t*t,easeOutQuart:t=>-((t-=1)*t*t*t-1),easeInOutQuart:t=>(t/=.5)<1?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2),easeInQuint:t=>t*t*t*t*t,easeOutQuint:t=>(t-=1)*t*t*t*t+1,easeInOutQuint:t=>(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2),easeInSine:t=>1-Math.cos(t*Mt),easeOutSine:t=>Math.sin(t*Mt),easeInOutSine:t=>-.5*(Math.cos(bt*t)-1),easeInExpo:t=>0===t?0:Math.pow(2,10*(t-1)),easeOutExpo:t=>1===t?1:1-Math.pow(2,-10*t),easeInOutExpo:t=>fi(t)?t:t<.5?.5*Math.pow(2,10*(2*t-1)):.5*(2-Math.pow(2,-10*(2*t-1))),easeInCirc:t=>t>=1?t:-(Math.sqrt(1-t*t)-1),easeOutCirc:t=>Math.sqrt(1-(t-=1)*t),easeInOutCirc:t=>(t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1),easeInElastic:t=>fi(t)?t:gi(t,.075,.3),easeOutElastic:t=>fi(t)?t:pi(t,.075,.3),easeInOutElastic(t){const e=.1125;return fi(t)?t:t<.5?.5*gi(2*t,e,.45):.5+.5*pi(2*t-1,e,.45)},easeInBack(t){const e=1.70158;return t*t*((e+1)*t-e)},easeOutBack(t){const e=1.70158;return(t-=1)*t*((e+1)*t+e)+1},easeInOutBack(t){let e=1.70158;return(t/=.5)<1?t*t*((1+(e*=1.525))*t-e)*.5:.5*((t-=2)*t*((1+(e*=1.525))*t+e)+2)},easeInBounce:t=>1-mi.easeOutBounce(1-t),easeOutBounce(t){const e=7.5625,i=2.75;return t<1/i?e*t*t:t<2/i?e*(t-=1.5/i)*t+.75:t<2.5/i?e*(t-=2.25/i)*t+.9375:e*(t-=2.625/i)*t+.984375},easeInOutBounce:t=>t<.5?.5*mi.easeInBounce(2*t):.5*mi.easeOutBounce(2*t-1)+.5},xi=\"transparent\",bi={boolean:(t,e,i)=>i>.5?e:t,color(t,e,i){const n=W(t||xi),o=n.valid&&W(e||xi);return o&&o.valid?o.mix(n,i).hexString():e},number:(t,e,i)=>t+(e-t)*i};class _i{constructor(t,e,i,n){const o=e[i];n=Ve([t.to,n,o,t.from]);const s=Ve([t.from,o,n]);this._active=!0,this._fn=t.fn||bi[t.type||typeof s],this._easing=mi[t.easing]||mi.linear,this._start=Math.floor(Date.now()+(t.delay||0)),this._duration=this._total=Math.floor(t.duration),this._loop=!!t.loop,this._target=e,this._prop=i,this._from=s,this._to=n,this._promises=void 0}active(){return this._active}update(t,e,i){const n=this;if(n._active){n._notify(!1);const o=n._target[n._prop],s=i-n._start,a=n._duration-s;n._start=i,n._duration=Math.floor(Math.max(a,t.duration)),n._total+=s,n._loop=!!t.loop,n._to=Ve([t.to,e,o,t.from]),n._from=Ve([t.from,o,e])}}cancel(){const t=this;t._active&&(t.tick(Date.now()),t._active=!1,t._notify(!1))}tick(t){const e=this,i=t-e._start,n=e._duration,o=e._prop,s=e._from,a=e._loop,r=e._to;let l;if(e._active=s!==r&&(a||i<n),!e._active)return e._target[o]=r,void e._notify(!0);i<0?e._target[o]=s:(l=i/n%2,l=a&&l>1?2-l:l,l=e._easing(Math.min(1,Math.max(0,l))),e._target[o]=e._fn(s,r,l))}wait(){const t=this._promises||(this._promises=[]);return new Promise(((e,i)=>{t.push({res:e,rej:i})}))}_notify(t){const e=t?\"res\":\"rej\",i=this._promises||[];for(let t=0;t<i.length;t++)i[t][e]()}}xt.set(\"animation\",{delay:void 0,duration:1e3,easing:\"easeOutQuart\",fn:void 0,from:void 0,loop:void 0,to:void 0,type:void 0});const yi=Object.keys(xt.animation);xt.describe(\"animation\",{_fallback:!1,_indexable:!1,_scriptable:t=>\"onProgress\"!==t&&\"onComplete\"!==t&&\"fn\"!==t}),xt.set(\"animations\",{colors:{type:\"color\",properties:[\"color\",\"borderColor\",\"backgroundColor\"]},numbers:{type:\"number\",properties:[\"x\",\"y\",\"borderWidth\",\"radius\",\"tension\"]}}),xt.describe(\"animations\",{_fallback:\"animation\"}),xt.set(\"transitions\",{active:{animation:{duration:400}},resize:{animation:{duration:0}},show:{animations:{colors:{from:\"transparent\"},visible:{type:\"boolean\",duration:0}}},hide:{animations:{colors:{to:\"transparent\"},visible:{type:\"boolean\",easing:\"linear\",fn:t=>0|t}}}});class vi{constructor(t,e){this._chart=t,this._properties=new Map,this.configure(e)}configure(t){if(!U(t))return;const e=this._properties;Object.getOwnPropertyNames(t).forEach((i=>{const n=t[i];if(!U(n))return;const o={};for(const t of yi)o[t]=n[t];(Y(n.properties)&&n.properties||[i]).forEach((t=>{t!==i&&e.has(t)||e.set(t,o)}))}))}_animateOptions(t,e){const i=e.options,n=function(t,e){if(!e)return;let i=t.options;if(!i)return void(t.options=e);i.$shared&&(t.options=i=Object.assign({},i,{$shared:!1,$animations:{}}));return i}(t,i);if(!n)return[];const o=this._createAnimations(n,i);return i.$shared&&function(t,e){const i=[],n=Object.keys(e);for(let e=0;e<n.length;e++){const o=t[n[e]];o&&o.active()&&i.push(o.wait())}return Promise.all(i)}(t.options.$animations,i).then((()=>{t.options=i}),(()=>{})),o}_createAnimations(t,e){const i=this._properties,n=[],o=t.$animations||(t.$animations={}),s=Object.keys(e),a=Date.now();let r;for(r=s.length-1;r>=0;--r){const l=s[r];if(\"$\"===l.charAt(0))continue;if(\"options\"===l){n.push(...this._animateOptions(t,e));continue}const c=e[l];let h=o[l];const d=i.get(l);if(h){if(d&&h.active()){h.update(d,c,a);continue}h.cancel()}d&&d.duration?(o[l]=h=new _i(d,t,l,c),n.push(h)):t[l]=c}return n}update(t,e){if(0===this._properties.size)return void Object.assign(t,e);const i=this._createAnimations(t,e);return i.length?(a.add(this._chart,i),!0):void 0}}function wi(t,e){const i=t&&t.options||{},n=i.reverse,o=void 0===i.min?e:0,s=void 0===i.max?e:0;return{start:n?s:o,end:n?o:s}}function Mi(t,e){const i=[],n=t._getSortedDatasetMetas(e);let o,s;for(o=0,s=n.length;o<s;++o)i.push(n[o].index);return i}function ki(t,e,i,n){const o=t.keys,s=\"single\"===n.mode;let a,r,l,c;if(null!==e){for(a=0,r=o.length;a<r;++a){if(l=+o[a],l===i){if(n.all)continue;break}c=t.values[l],X(c)&&(s||0===e||Dt(e)===Dt(c))&&(e+=c)}return e}}function Si(t,e){const i=t&&t.options.stacked;return i||void 0===i&&void 0!==e.stack}function Pi(t,e,i){const n=t[e]||(t[e]={});return n[i]||(n[i]={})}function Di(t,e,i){for(const n of e.getMatchingVisibleMetas(\"bar\").reverse()){const e=t[n.index];if(i&&e>0||!i&&e<0)return n.index}return null}function Ci(t,e){const{chart:i,_cachedMeta:n}=t,o=i._stacks||(i._stacks={}),{iScale:s,vScale:a,index:r}=n,l=s.axis,c=a.axis,h=function(t,e,i){return`${t.id}.${e.id}.${i.stack||i.type}`}(s,a,n),d=e.length;let u;for(let t=0;t<d;++t){const i=e[t],{[l]:n,[c]:s}=i;u=(i._stacks||(i._stacks={}))[c]=Pi(o,h,n),u[r]=s,u._top=Di(u,a,!0),u._bottom=Di(u,a,!1)}}function Oi(t,e){const i=t.scales;return Object.keys(i).filter((t=>i[t].axis===e)).shift()}function Ti(t,e){const i=t.vScale&&t.vScale.axis;if(i){e=e||t._parsed;for(const n of e){const e=n._stacks;if(!e||void 0===e[i]||void 0===e[i][t.index])return;delete e[i][t.index]}}}const Ai=t=>\"reset\"===t||\"none\"===t,Li=(t,e)=>e?t:Object.assign({},t);class Ri{constructor(t,e){this.chart=t,this._ctx=t.ctx,this.index=e,this._cachedDataOpts={},this._cachedMeta=this.getMeta(),this._type=this._cachedMeta.type,this.options=void 0,this._parsing=!1,this._data=void 0,this._objectData=void 0,this._sharedOptions=void 0,this._drawStart=void 0,this._drawCount=void 0,this.enableOptionSharing=!1,this.$context=void 0,this._syncList=[],this.initialize()}initialize(){const t=this,e=t._cachedMeta;t.configure(),t.linkScales(),e._stacked=Si(e.vScale,e),t.addElements()}updateIndex(t){this.index!==t&&Ti(this._cachedMeta),this.index=t}linkScales(){const t=this,e=t.chart,i=t._cachedMeta,n=t.getDataset(),o=(t,e,i,n)=>\"x\"===t?e:\"r\"===t?n:i,s=i.xAxisID=K(n.xAxisID,Oi(e,\"x\")),a=i.yAxisID=K(n.yAxisID,Oi(e,\"y\")),r=i.rAxisID=K(n.rAxisID,Oi(e,\"r\")),l=i.indexAxis,c=i.iAxisID=o(l,s,a,r),h=i.vAxisID=o(l,a,s,r);i.xScale=t.getScaleForId(s),i.yScale=t.getScaleForId(a),i.rScale=t.getScaleForId(r),i.iScale=t.getScaleForId(c),i.vScale=t.getScaleForId(h)}getDataset(){return this.chart.data.datasets[this.index]}getMeta(){return this.chart.getDatasetMeta(this.index)}getScaleForId(t){return this.chart.scales[t]}_getOtherScale(t){const e=this._cachedMeta;return t===e.iScale?e.vScale:e.iScale}reset(){this._update(\"reset\")}_destroy(){const t=this._cachedMeta;this._data&&ce(this._data,this),t._stacked&&Ti(t)}_dataCheck(){const t=this,e=t.getDataset(),i=e.data||(e.data=[]),n=t._data;if(U(i))t._data=function(t){const e=Object.keys(t),i=new Array(e.length);let n,o,s;for(n=0,o=e.length;n<o;++n)s=e[n],i[n]={x:s,y:t[s]};return i}(i);else if(n!==i){if(n){ce(n,t);const e=t._cachedMeta;Ti(e),e._parsed=[]}i&&Object.isExtensible(i)&&le(i,t),t._syncList=[],t._data=i}}addElements(){const t=this,e=t._cachedMeta;t._dataCheck(),t.datasetElementType&&(e.dataset=new t.datasetElementType)}buildOrUpdateElements(t){const e=this,i=e._cachedMeta,n=e.getDataset();let o=!1;e._dataCheck();const s=i._stacked;i._stacked=Si(i.vScale,i),i.stack!==n.stack&&(o=!0,Ti(i),i.stack=n.stack),e._resyncElements(t),(o||s!==i._stacked)&&Ci(e,i._parsed)}configure(){const t=this,e=t.chart.config,i=e.datasetScopeKeys(t._type),n=e.getOptionScopes(t.getDataset(),i,!0);t.options=e.createResolver(n,t.getContext()),t._parsing=t.options.parsing}parse(t,e){const i=this,{_cachedMeta:n,_data:o}=i,{iScale:s,_stacked:a}=n,r=s.axis;let l,c,h,d=0===t&&e===o.length||n._sorted,u=t>0&&n._parsed[t-1];if(!1===i._parsing)n._parsed=o,n._sorted=!0,h=o;else{h=Y(o[t])?i.parseArrayData(n,o,t,e):U(o[t])?i.parseObjectData(n,o,t,e):i.parsePrimitiveData(n,o,t,e);const s=()=>null===c[r]||u&&c[r]<u[r];for(l=0;l<e;++l)n._parsed[l+t]=c=h[l],d&&(s()&&(d=!1),u=c);n._sorted=d}a&&Ci(i,h)}parsePrimitiveData(t,e,i,n){const{iScale:o,vScale:s}=t,a=o.axis,r=s.axis,l=o.getLabels(),c=o===s,h=new Array(n);let d,u,f;for(d=0,u=n;d<u;++d)f=d+i,h[d]={[a]:c||o.parse(l[f],f),[r]:s.parse(e[f],f)};return h}parseArrayData(t,e,i,n){const{xScale:o,yScale:s}=t,a=new Array(n);let r,l,c,h;for(r=0,l=n;r<l;++r)c=r+i,h=e[c],a[r]={x:o.parse(h[0],c),y:s.parse(h[1],c)};return a}parseObjectData(t,e,i,n){const{xScale:o,yScale:s}=t,{xAxisKey:a=\"x\",yAxisKey:r=\"y\"}=this._parsing,l=new Array(n);let c,h,d,u;for(c=0,h=n;c<h;++c)d=c+i,u=e[d],l[c]={x:o.parse(lt(u,a),d),y:s.parse(lt(u,r),d)};return l}getParsed(t){return this._cachedMeta._parsed[t]}getDataElement(t){return this._cachedMeta.data[t]}applyStack(t,e,i){const n=this.chart,o=this._cachedMeta,s=e[t.axis];return ki({keys:Mi(n,!0),values:e._stacks[t.axis]},s,o.index,{mode:i})}updateRangeFromParsed(t,e,i,n){const o=i[e.axis];let s=null===o?NaN:o;const a=n&&i._stacks[e.axis];n&&a&&(n.values=a,t.min=Math.min(t.min,s),t.max=Math.max(t.max,s),s=ki(n,o,this._cachedMeta.index,{all:!0})),t.min=Math.min(t.min,s),t.max=Math.max(t.max,s)}getMinMax(t,e){const i=this,n=i._cachedMeta,o=n._parsed,s=n._sorted&&t===n.iScale,a=o.length,r=i._getOtherScale(t),l=e&&n._stacked&&{keys:Mi(i.chart,!0),values:null},c={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY},{min:h,max:d}=function(t){const{min:e,max:i,minDefined:n,maxDefined:o}=t.getUserBounds();return{min:n?e:Number.NEGATIVE_INFINITY,max:o?i:Number.POSITIVE_INFINITY}}(r);let u,f,g,p;function m(){return g=o[u],f=g[t.axis],p=g[r.axis],!X(f)||h>p||d<p}for(u=0;u<a&&(m()||(i.updateRangeFromParsed(c,t,g,l),!s));++u);if(s)for(u=a-1;u>=0;--u)if(!m()){i.updateRangeFromParsed(c,t,g,l);break}return c}getAllParsedValues(t){const e=this._cachedMeta._parsed,i=[];let n,o,s;for(n=0,o=e.length;n<o;++n)s=e[n][t.axis],X(s)&&i.push(s);return i}getMaxOverflow(){return!1}getLabelAndValue(t){const e=this._cachedMeta,i=e.iScale,n=e.vScale,o=this.getParsed(t);return{label:i?\"\"+i.getLabelForValue(o[i.axis]):\"\",value:n?\"\"+n.getLabelForValue(o[n.axis]):\"\"}}_update(t){const e=this,i=e._cachedMeta;e.configure(),e._cachedDataOpts={},e.update(t||\"default\"),i._clip=function(t){let e,i,n,o;return U(t)?(e=t.top,i=t.right,n=t.bottom,o=t.left):e=i=n=o=t,{top:e,right:i,bottom:n,left:o}}(K(e.options.clip,function(t,e,i){if(!1===i)return!1;const n=wi(t,i),o=wi(e,i);return{top:o.end,right:n.end,bottom:o.start,left:n.start}}(i.xScale,i.yScale,e.getMaxOverflow())))}update(t){}draw(){const t=this,e=t._ctx,i=t.chart,n=t._cachedMeta,o=n.data||[],s=i.chartArea,a=[],r=t._drawStart||0,l=t._drawCount||o.length-r;let c;for(n.dataset&&n.dataset.draw(e,s,r,l),c=r;c<r+l;++c){const t=o[c];t.active?a.push(t):t.draw(e,s)}for(c=0;c<a.length;++c)a[c].draw(e,s)}getStyle(t,e){const i=e?\"active\":\"default\";return void 0===t&&this._cachedMeta.dataset?this.resolveDatasetElementOptions(i):this.resolveDataElementOptions(t||0,i)}getContext(t,e,i){const n=this,o=n.getDataset();let s;if(t>=0&&t<n._cachedMeta.data.length){const e=n._cachedMeta.data[t];s=e.$context||(e.$context=function(t,e,i){return Object.assign(Object.create(t),{active:!1,dataIndex:e,parsed:void 0,raw:void 0,element:i,index:e,mode:\"default\",type:\"data\"})}(n.getContext(),t,e)),s.parsed=n.getParsed(t),s.raw=o.data[t],s.index=s.dataIndex=t}else s=n.$context||(n.$context=function(t,e){return Object.assign(Object.create(t),{active:!1,dataset:void 0,datasetIndex:e,index:e,mode:\"default\",type:\"dataset\"})}(n.chart.getContext(),n.index)),s.dataset=o,s.index=s.datasetIndex=n.index;return s.active=!!e,s.mode=i,s}resolveDatasetElementOptions(t){return this._resolveElementOptions(this.datasetElementType.id,t)}resolveDataElementOptions(t,e){return this._resolveElementOptions(this.dataElementType.id,e,t)}_resolveElementOptions(t,e=\"default\",i){const n=this,o=\"active\"===e,s=n._cachedDataOpts,a=t+\"-\"+e,r=s[a],l=n.enableOptionSharing&&ht(i);if(r)return Li(r,l);const c=n.chart.config,h=c.datasetElementScopeKeys(n._type,t),d=o?[`${t}Hover`,\"hover\",t,\"\"]:[t,\"\"],u=c.getOptionScopes(n.getDataset(),h),f=Object.keys(xt.elements[t]),g=c.resolveNamedOptions(u,f,(()=>n.getContext(i,o)),d);return g.$shared&&(g.$shared=l,s[a]=Object.freeze(Li(g,l))),g}_resolveAnimations(t,e,i){const n=this,o=n.chart,s=n._cachedDataOpts,a=`animation-${e}`,r=s[a];if(r)return r;let l;if(!1!==o.options.animation){const o=n.chart.config,s=o.datasetAnimationScopeKeys(n._type,e),a=o.getOptionScopes(n.getDataset(),s);l=o.createResolver(a,n.getContext(t,i,e))}const c=new vi(o,l&&l.animations);return l&&l._cacheable&&(s[a]=Object.freeze(c)),c}getSharedOptions(t){if(t.$shared)return this._sharedOptions||(this._sharedOptions=Object.assign({},t))}includeOptions(t,e){return!e||Ai(t)||this.chart._animationsDisabled}updateElement(t,e,i,n){Ai(n)?Object.assign(t,i):this._resolveAnimations(e,n).update(t,i)}updateSharedOptions(t,e,i){t&&!Ai(e)&&this._resolveAnimations(void 0,e).update(t,i)}_setStyle(t,e,i,n){t.active=n;const o=this.getStyle(e,n);this._resolveAnimations(e,i,n).update(t,{options:!n&&this.getSharedOptions(o)||o})}removeHoverStyle(t,e,i){this._setStyle(t,i,\"active\",!1)}setHoverStyle(t,e,i){this._setStyle(t,i,\"active\",!0)}_removeDatasetHoverStyle(){const t=this._cachedMeta.dataset;t&&this._setStyle(t,void 0,\"active\",!1)}_setDatasetHoverStyle(){const t=this._cachedMeta.dataset;t&&this._setStyle(t,void 0,\"active\",!0)}_resyncElements(t){const e=this,i=e._data,n=e._cachedMeta.data;for(const[t,i,n]of e._syncList)e[t](i,n);e._syncList=[];const o=n.length,s=i.length,a=Math.min(s,o);a&&e.parse(0,a),s>o?e._insertElements(o,s-o,t):s<o&&e._removeElements(s,o-s)}_insertElements(t,e,i=!0){const n=this,o=n._cachedMeta,s=o.data,a=t+e;let r;const l=t=>{for(t.length+=e,r=t.length-1;r>=a;r--)t[r]=t[r-e]};for(l(s),r=t;r<a;++r)s[r]=new n.dataElementType;n._parsing&&l(o._parsed),n.parse(t,e),i&&n.updateElements(s,t,e,\"reset\")}updateElements(t,e,i,n){}_removeElements(t,e){const i=this._cachedMeta;if(this._parsing){const n=i._parsed.splice(t,e);i._stacked&&Ti(i,n)}i.data.splice(t,e)}_onDataPush(){const t=arguments.length;this._syncList.push([\"_insertElements\",this.getDataset().data.length-t,t])}_onDataPop(){this._syncList.push([\"_removeElements\",this._cachedMeta.data.length-1,1])}_onDataShift(){this._syncList.push([\"_removeElements\",0,1])}_onDataSplice(t,e){this._syncList.push([\"_removeElements\",t,e]),this._syncList.push([\"_insertElements\",t,arguments.length-2])}_onDataUnshift(){this._syncList.push([\"_insertElements\",0,arguments.length])}}Ri.defaults={},Ri.prototype.datasetElementType=null,Ri.prototype.dataElementType=null;class Ei{constructor(){this.x=void 0,this.y=void 0,this.active=!1,this.options=void 0,this.$animations=void 0}tooltipPosition(t){const{x:e,y:i}=this.getProps([\"x\",\"y\"],t);return{x:e,y:i}}hasValue(){return Tt(this.x)&&Tt(this.y)}getProps(t,e){const i=this,n=this.$animations;if(!e||!n)return i;const o={};return t.forEach((t=>{o[t]=n[t]&&n[t].active()?n[t]._to:i[t]})),o}}Ei.defaults={},Ei.defaultRoutes=void 0;const Ii=new Map;function zi(t,e,i){return function(t,e){e=e||{};const i=t+JSON.stringify(e);let n=Ii.get(i);return n||(n=new Intl.NumberFormat(t,e),Ii.set(i,n)),n}(e,i).format(t)}const Fi={values:t=>Y(t)?t:\"\"+t,numeric(t,e,i){if(0===t)return\"0\";const n=this.chart.options.locale;let o,s=t;if(i.length>1){const e=Math.max(Math.abs(i[0].value),Math.abs(i[i.length-1].value));(e<1e-4||e>1e15)&&(o=\"scientific\"),s=function(t,e){let i=e.length>3?e[2].value-e[1].value:e[1].value-e[0].value;Math.abs(i)>=1&&t!==Math.floor(t)&&(i=t-Math.floor(t));return i}(t,i)}const a=Pt(Math.abs(s)),r=Math.max(Math.min(-1*Math.floor(a),20),0),l={notation:o,minimumFractionDigits:r,maximumFractionDigits:r};return Object.assign(l,this.options.ticks.format),zi(t,n,l)},logarithmic(t,e,i){if(0===t)return\"0\";const n=t/Math.pow(10,Math.floor(Pt(t)));return 1===n||2===n||5===n?Fi.numeric.call(this,t,e,i):\"\"}};var Vi={formatters:Fi};function Bi(t,e){const i=t.options.ticks,n=i.maxTicksLimit||function(t){const e=t.options.offset,i=t._tickSize(),n=t._length/i+(e?0:1),o=t._maxLength/i;return Math.floor(Math.min(n,o))}(t),o=i.major.enabled?function(t){const e=[];let i,n;for(i=0,n=t.length;i<n;i++)t[i].major&&e.push(i);return e}(e):[],s=o.length,a=o[0],r=o[s-1],l=[];if(s>n)return function(t,e,i,n){let o,s=0,a=i[0];for(n=Math.ceil(n),o=0;o<t.length;o++)o===a&&(e.push(t[o]),s++,a=i[s*n])}(e,l,o,s/n),l;const c=function(t,e,i){const n=function(t){const e=t.length;let i,n;if(e<2)return!1;for(n=t[0],i=1;i<e;++i)if(t[i]-t[i-1]!==n)return!1;return n}(t),o=e.length/i;if(!n)return Math.max(o,1);const s=Ot(n);for(let t=0,e=s.length-1;t<e;t++){const e=s[t];if(e>o)return e}return Math.max(o,1)}(o,e,n);if(s>0){let t,i;const n=s>1?Math.round((r-a)/(s-1)):null;for(Wi(e,l,c,$(n)?0:a-n,a),t=0,i=s-1;t<i;t++)Wi(e,l,c,o[t],o[t+1]);return Wi(e,l,c,r,$(n)?e.length:r+n),l}return Wi(e,l,c),l}function Wi(t,e,i,n,o){const s=K(n,0),a=Math.min(K(o,t.length),t.length);let r,l,c,h=0;for(i=Math.ceil(i),o&&(r=o-n,i=r/Math.floor(r/i)),c=s;c<0;)h++,c=Math.round(s+h*i);for(l=Math.max(s,0);l<a;l++)l===c&&(e.push(t[l]),h++,c=Math.round(s+h*i))}xt.set(\"scale\",{display:!0,offset:!1,reverse:!1,beginAtZero:!1,bounds:\"ticks\",grace:0,grid:{display:!0,lineWidth:1,drawBorder:!0,drawOnChartArea:!0,drawTicks:!0,tickLength:8,tickWidth:(t,e)=>e.lineWidth,tickColor:(t,e)=>e.color,offset:!1,borderDash:[],borderDashOffset:0,borderWidth:1},title:{display:!1,text:\"\",padding:{top:4,bottom:4}},ticks:{minRotation:0,maxRotation:50,mirror:!1,textStrokeWidth:0,textStrokeColor:\"\",padding:3,display:!0,autoSkip:!0,autoSkipPadding:3,labelOffset:0,callback:Vi.formatters.values,minor:{},major:{},align:\"center\",crossAlign:\"near\",showLabelBackdrop:!1,backdropColor:\"rgba(255, 255, 255, 0.75)\",backdropPadding:2}}),xt.route(\"scale.ticks\",\"color\",\"\",\"color\"),xt.route(\"scale.grid\",\"color\",\"\",\"borderColor\"),xt.route(\"scale.grid\",\"borderColor\",\"\",\"borderColor\"),xt.route(\"scale.title\",\"color\",\"\",\"color\"),xt.describe(\"scale\",{_fallback:!1,_scriptable:t=>!t.startsWith(\"before\")&&!t.startsWith(\"after\")&&\"callback\"!==t&&\"parser\"!==t,_indexable:t=>\"borderDash\"!==t&&\"tickBorderDash\"!==t}),xt.describe(\"scales\",{_fallback:\"scale\"});const Hi=(t,e,i)=>\"top\"===e||\"left\"===e?t[e]+i:t[e]-i;function Ni(t,e){const i=[],n=t.length/e,o=t.length;let s=0;for(;s<o;s+=n)i.push(t[Math.floor(s)]);return i}function ji(t,e,i){const n=t.ticks.length,o=Math.min(e,n-1),s=t._startPixel,a=t._endPixel,r=1e-6;let l,c=t.getPixelForTick(o);if(!(i&&(l=1===n?Math.max(c-s,a-c):0===e?(t.getPixelForTick(1)-c)/2:(c-t.getPixelForTick(o-1))/2,c+=o<e?l:-l,c<s-r||c>a+r)))return c}function $i(t){return t.drawTicks?t.tickLength:0}function Yi(t,e){if(!t.display)return 0;const i=Fe(t.font,e),n=ze(t.padding);return(Y(t.text)?t.text.length:1)*i.lineHeight+n.height}function Ui(t,e,i){let o=n(t);return(i&&\"right\"!==e||!i&&\"right\"===e)&&(o=(t=>\"left\"===t?\"right\":\"right\"===t?\"left\":t)(o)),o}class Xi extends Ei{constructor(t){super(),this.id=t.id,this.type=t.type,this.options=void 0,this.ctx=t.ctx,this.chart=t.chart,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.width=void 0,this.height=void 0,this._margins={left:0,right:0,top:0,bottom:0},this.maxWidth=void 0,this.maxHeight=void 0,this.paddingTop=void 0,this.paddingBottom=void 0,this.paddingLeft=void 0,this.paddingRight=void 0,this.axis=void 0,this.labelRotation=void 0,this.min=void 0,this.max=void 0,this._range=void 0,this.ticks=[],this._gridLineItems=null,this._labelItems=null,this._labelSizes=null,this._length=0,this._maxLength=0,this._longestTextCache={},this._startPixel=void 0,this._endPixel=void 0,this._reversePixels=!1,this._userMax=void 0,this._userMin=void 0,this._suggestedMax=void 0,this._suggestedMin=void 0,this._ticksLength=0,this._borderValue=0,this._cache={},this._dataLimitsCached=!1,this.$context=void 0}init(t){const e=this;e.options=t.setContext(e.getContext()),e.axis=t.axis,e._userMin=e.parse(t.min),e._userMax=e.parse(t.max),e._suggestedMin=e.parse(t.suggestedMin),e._suggestedMax=e.parse(t.suggestedMax)}parse(t,e){return t}getUserBounds(){let{_userMin:t,_userMax:e,_suggestedMin:i,_suggestedMax:n}=this;return t=q(t,Number.POSITIVE_INFINITY),e=q(e,Number.NEGATIVE_INFINITY),i=q(i,Number.POSITIVE_INFINITY),n=q(n,Number.NEGATIVE_INFINITY),{min:q(t,i),max:q(e,n),minDefined:X(t),maxDefined:X(e)}}getMinMax(t){const e=this;let i,{min:n,max:o,minDefined:s,maxDefined:a}=e.getUserBounds();if(s&&a)return{min:n,max:o};const r=e.getMatchingVisibleMetas();for(let l=0,c=r.length;l<c;++l)i=r[l].controller.getMinMax(e,t),s||(n=Math.min(n,i.min)),a||(o=Math.max(o,i.max));return{min:q(n,q(o,n)),max:q(o,q(n,o))}}getPadding(){const t=this;return{left:t.paddingLeft||0,top:t.paddingTop||0,right:t.paddingRight||0,bottom:t.paddingBottom||0}}getTicks(){return this.ticks}getLabels(){const t=this.chart.data;return this.options.labels||(this.isHorizontal()?t.xLabels:t.yLabels)||t.labels||[]}beforeLayout(){this._cache={},this._dataLimitsCached=!1}beforeUpdate(){Q(this.options.beforeUpdate,[this])}update(t,e,i){const n=this,o=n.options.ticks,s=o.sampleSize;n.beforeUpdate(),n.maxWidth=t,n.maxHeight=e,n._margins=i=Object.assign({left:0,right:0,top:0,bottom:0},i),n.ticks=null,n._labelSizes=null,n._gridLineItems=null,n._labelItems=null,n.beforeSetDimensions(),n.setDimensions(),n.afterSetDimensions(),n._maxLength=n.isHorizontal()?n.width+i.left+i.right:n.height+i.top+i.bottom,n._dataLimitsCached||(n.beforeDataLimits(),n.determineDataLimits(),n.afterDataLimits(),n._range=Be(n,n.options.grace),n._dataLimitsCached=!0),n.beforeBuildTicks(),n.ticks=n.buildTicks()||[],n.afterBuildTicks();const a=s<n.ticks.length;n._convertTicksToLabels(a?Ni(n.ticks,s):n.ticks),n.configure(),n.beforeCalculateLabelRotation(),n.calculateLabelRotation(),n.afterCalculateLabelRotation(),o.display&&(o.autoSkip||\"auto\"===o.source)&&(n.ticks=Bi(n,n.ticks),n._labelSizes=null),a&&n._convertTicksToLabels(n.ticks),n.beforeFit(),n.fit(),n.afterFit(),n.afterUpdate()}configure(){const t=this;let e,i,n=t.options.reverse;t.isHorizontal()?(e=t.left,i=t.right):(e=t.top,i=t.bottom,n=!n),t._startPixel=e,t._endPixel=i,t._reversePixels=n,t._length=i-e,t._alignToPixels=t.options.alignToPixels}afterUpdate(){Q(this.options.afterUpdate,[this])}beforeSetDimensions(){Q(this.options.beforeSetDimensions,[this])}setDimensions(){const t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height),t.paddingLeft=0,t.paddingTop=0,t.paddingRight=0,t.paddingBottom=0}afterSetDimensions(){Q(this.options.afterSetDimensions,[this])}_callHooks(t){const e=this;e.chart.notifyPlugins(t,e.getContext()),Q(e.options[t],[e])}beforeDataLimits(){this._callHooks(\"beforeDataLimits\")}determineDataLimits(){}afterDataLimits(){this._callHooks(\"afterDataLimits\")}beforeBuildTicks(){this._callHooks(\"beforeBuildTicks\")}buildTicks(){return[]}afterBuildTicks(){this._callHooks(\"afterBuildTicks\")}beforeTickToLabelConversion(){Q(this.options.beforeTickToLabelConversion,[this])}generateTickLabels(t){const e=this,i=e.options.ticks;let n,o,s;for(n=0,o=t.length;n<o;n++)s=t[n],s.label=Q(i.callback,[s.value,n,t],e);for(n=0;n<o;n++)$(t[n].label)&&(t.splice(n,1),o--,n--)}afterTickToLabelConversion(){Q(this.options.afterTickToLabelConversion,[this])}beforeCalculateLabelRotation(){Q(this.options.beforeCalculateLabelRotation,[this])}calculateLabelRotation(){const t=this,e=t.options,i=e.ticks,n=t.ticks.length,o=i.minRotation||0,s=i.maxRotation;let a,r,l,c=o;if(!t._isVisible()||!i.display||o>=s||n<=1||!t.isHorizontal())return void(t.labelRotation=o);const h=t._getLabelSizes(),d=h.widest.width,u=h.highest.height,f=Nt(t.chart.width-d,0,t.maxWidth);a=e.offset?t.maxWidth/n:f/(n-1),d+6>a&&(a=f/(n-(e.offset?.5:1)),r=t.maxHeight-$i(e.grid)-i.padding-Yi(e.title,t.chart.options.font),l=Math.sqrt(d*d+u*u),c=It(Math.min(Math.asin(Math.min((h.highest.height+6)/a,1)),Math.asin(Math.min(r/l,1))-Math.asin(u/l))),c=Math.max(o,Math.min(s,c))),t.labelRotation=c}afterCalculateLabelRotation(){Q(this.options.afterCalculateLabelRotation,[this])}beforeFit(){Q(this.options.beforeFit,[this])}fit(){const t=this,e={width:0,height:0},{chart:i,options:{ticks:n,title:o,grid:s}}=t,a=t._isVisible(),r=t.isHorizontal();if(a){const a=Yi(o,i.options.font);if(r?(e.width=t.maxWidth,e.height=$i(s)+a):(e.height=t.maxHeight,e.width=$i(s)+a),n.display&&t.ticks.length){const{first:i,last:o,widest:s,highest:a}=t._getLabelSizes(),l=2*n.padding,c=Et(t.labelRotation),h=Math.cos(c),d=Math.sin(c);if(r){const i=n.mirror?0:d*s.width+h*a.height;e.height=Math.min(t.maxHeight,e.height+i+l)}else{const i=n.mirror?0:h*s.width+d*a.height;e.width=Math.min(t.maxWidth,e.width+i+l)}t._calculatePadding(i,o,d,h)}}t._handleMargins(),r?(t.width=t._length=i.width-t._margins.left-t._margins.right,t.height=e.height):(t.width=e.width,t.height=t._length=i.height-t._margins.top-t._margins.bottom)}_calculatePadding(t,e,i,n){const o=this,{ticks:{align:s,padding:a},position:r}=o.options,l=0!==o.labelRotation,c=\"top\"!==r&&\"x\"===o.axis;if(o.isHorizontal()){const r=o.getPixelForTick(0)-o.left,h=o.right-o.getPixelForTick(o.ticks.length-1);let d=0,u=0;l?c?(d=n*t.width,u=i*e.height):(d=i*t.height,u=n*e.width):\"start\"===s?u=e.width:\"end\"===s?d=t.width:(d=t.width/2,u=e.width/2),o.paddingLeft=Math.max((d-r+a)*o.width/(o.width-r),0),o.paddingRight=Math.max((u-h+a)*o.width/(o.width-h),0)}else{let i=e.height/2,n=t.height/2;\"start\"===s?(i=0,n=t.height):\"end\"===s&&(i=e.height,n=0),o.paddingTop=i+a,o.paddingBottom=n+a}}_handleMargins(){const t=this;t._margins&&(t._margins.left=Math.max(t.paddingLeft,t._margins.left),t._margins.top=Math.max(t.paddingTop,t._margins.top),t._margins.right=Math.max(t.paddingRight,t._margins.right),t._margins.bottom=Math.max(t.paddingBottom,t._margins.bottom))}afterFit(){Q(this.options.afterFit,[this])}isHorizontal(){const{axis:t,position:e}=this.options;return\"top\"===e||\"bottom\"===e||\"x\"===t}isFullSize(){return this.options.fullSize}_convertTicksToLabels(t){const e=this;e.beforeTickToLabelConversion(),e.generateTickLabels(t),e.afterTickToLabelConversion()}_getLabelSizes(){const t=this;let e=t._labelSizes;if(!e){const i=t.options.ticks.sampleSize;let n=t.ticks;i<n.length&&(n=Ni(n,i)),t._labelSizes=e=t._computeLabelSizes(n,n.length)}return e}_computeLabelSizes(t,e){const{ctx:i,_longestTextCache:n}=this,o=[],s=[];let a,r,l,c,h,d,u,f,g,p,m,x=0,b=0;for(a=0;a<e;++a){if(c=t[a].label,h=this._resolveTickFontOptions(a),i.font=d=h.string,u=n[d]=n[d]||{data:{},gc:[]},f=h.lineHeight,g=p=0,$(c)||Y(c)){if(Y(c))for(r=0,l=c.length;r<l;++r)m=c[r],$(m)||Y(m)||(g=Yt(i,u.data,u.gc,g,m),p+=f)}else g=Yt(i,u.data,u.gc,g,c),p=f;o.push(g),s.push(p),x=Math.max(g,x),b=Math.max(p,b)}!function(t,e){J(t,(t=>{const i=t.gc,n=i.length/2;let o;if(n>e){for(o=0;o<n;++o)delete t.data[i[o]];i.splice(0,n)}}))}(n,e);const _=o.indexOf(x),y=s.indexOf(b),v=t=>({width:o[t]||0,height:s[t]||0});return{first:v(0),last:v(e-1),widest:v(_),highest:v(y),widths:o,heights:s}}getLabelForValue(t){return t}getPixelForValue(t,e){return NaN}getValueForPixel(t){}getPixelForTick(t){const e=this.ticks;return t<0||t>e.length-1?null:this.getPixelForValue(e[t].value)}getPixelForDecimal(t){const e=this;e._reversePixels&&(t=1-t);const i=e._startPixel+t*e._length;return jt(e._alignToPixels?Xt(e.chart,i,0):i)}getDecimalForPixel(t){const e=(t-this._startPixel)/this._length;return this._reversePixels?1-e:e}getBasePixel(){return this.getPixelForValue(this.getBaseValue())}getBaseValue(){const{min:t,max:e}=this;return t<0&&e<0?e:t>0&&e>0?t:0}getContext(t){const e=this,i=e.ticks||[];if(t>=0&&t<i.length){const n=i[t];return n.$context||(n.$context=function(t,e,i){return Object.assign(Object.create(t),{tick:i,index:e,type:\"tick\"})}(e.getContext(),t,n))}return e.$context||(e.$context=(n=e.chart.getContext(),o=e,Object.assign(Object.create(n),{scale:o,type:\"scale\"})));var n,o}_tickSize(){const t=this,e=t.options.ticks,i=Et(t.labelRotation),n=Math.abs(Math.cos(i)),o=Math.abs(Math.sin(i)),s=t._getLabelSizes(),a=e.autoSkipPadding||0,r=s?s.widest.width+a:0,l=s?s.highest.height+a:0;return t.isHorizontal()?l*n>r*o?r/n:l/o:l*o<r*n?l/n:r/o}_isVisible(){const t=this.options.display;return\"auto\"!==t?!!t:this.getMatchingVisibleMetas().length>0}_computeGridLineItems(t){const e=this,i=e.axis,n=e.chart,o=e.options,{grid:s,position:a}=o,r=s.offset,l=e.isHorizontal(),c=e.ticks.length+(r?1:0),h=$i(s),d=[],u=s.setContext(e.getContext()),f=u.drawBorder?u.borderWidth:0,g=f/2,p=function(t){return Xt(n,t,f)};let m,x,b,_,y,v,w,M,k,S,P,D;if(\"top\"===a)m=p(e.bottom),v=e.bottom-h,M=m-g,S=p(t.top)+g,D=t.bottom;else if(\"bottom\"===a)m=p(e.top),S=t.top,D=p(t.bottom)-g,v=m+g,M=e.top+h;else if(\"left\"===a)m=p(e.right),y=e.right-h,w=m-g,k=p(t.left)+g,P=t.right;else if(\"right\"===a)m=p(e.left),k=t.left,P=p(t.right)-g,y=m+g,w=e.left+h;else if(\"x\"===i){if(\"center\"===a)m=p((t.top+t.bottom)/2+.5);else if(U(a)){const t=Object.keys(a)[0],i=a[t];m=p(e.chart.scales[t].getPixelForValue(i))}S=t.top,D=t.bottom,v=m+g,M=v+h}else if(\"y\"===i){if(\"center\"===a)m=p((t.left+t.right)/2);else if(U(a)){const t=Object.keys(a)[0],i=a[t];m=p(e.chart.scales[t].getPixelForValue(i))}y=m-g,w=y-h,k=t.left,P=t.right}for(x=0;x<c;++x){const t=s.setContext(e.getContext(x)),i=t.lineWidth,o=t.color,a=s.borderDash||[],c=t.borderDashOffset,h=t.tickWidth,u=t.tickColor,f=t.tickBorderDash||[],g=t.tickBorderDashOffset;b=ji(e,x,r),void 0!==b&&(_=Xt(n,b,i),l?y=w=k=P=_:v=M=S=D=_,d.push({tx1:y,ty1:v,tx2:w,ty2:M,x1:k,y1:S,x2:P,y2:D,width:i,color:o,borderDash:a,borderDashOffset:c,tickWidth:h,tickColor:u,tickBorderDash:f,tickBorderDashOffset:g}))}return e._ticksLength=c,e._borderValue=m,d}_computeLabelItems(t){const e=this,i=e.axis,n=e.options,{position:o,ticks:s}=n,a=e.isHorizontal(),r=e.ticks,{align:l,crossAlign:c,padding:h,mirror:d}=s,u=$i(n.grid),f=u+h,g=d?-h:f,p=-Et(e.labelRotation),m=[];let x,b,_,y,v,w,M,k,S,P,D,C,O=\"middle\";if(\"top\"===o)w=e.bottom-g,M=e._getXAxisLabelAlignment();else if(\"bottom\"===o)w=e.top+g,M=e._getXAxisLabelAlignment();else if(\"left\"===o){const t=e._getYAxisLabelAlignment(u);M=t.textAlign,v=t.x}else if(\"right\"===o){const t=e._getYAxisLabelAlignment(u);M=t.textAlign,v=t.x}else if(\"x\"===i){if(\"center\"===o)w=(t.top+t.bottom)/2+f;else if(U(o)){const t=Object.keys(o)[0],i=o[t];w=e.chart.scales[t].getPixelForValue(i)+f}M=e._getXAxisLabelAlignment()}else if(\"y\"===i){if(\"center\"===o)v=(t.left+t.right)/2-f;else if(U(o)){const t=Object.keys(o)[0],i=o[t];v=e.chart.scales[t].getPixelForValue(i)}M=e._getYAxisLabelAlignment(u).textAlign}\"y\"===i&&(\"start\"===l?O=\"top\":\"end\"===l&&(O=\"bottom\"));const T=e._getLabelSizes();for(x=0,b=r.length;x<b;++x){_=r[x],y=_.label;const t=s.setContext(e.getContext(x));k=e.getPixelForTick(x)+s.labelOffset,S=e._resolveTickFontOptions(x),P=S.lineHeight,D=Y(y)?y.length:1;const i=D/2,n=t.color,l=t.textStrokeColor,h=t.textStrokeWidth;let u;if(a?(v=k,C=\"top\"===o?\"near\"===c||0!==p?-D*P+P/2:\"center\"===c?-T.highest.height/2-i*P+P:-T.highest.height+P/2:\"near\"===c||0!==p?P/2:\"center\"===c?T.highest.height/2-i*P:T.highest.height-D*P,d&&(C*=-1)):(w=k,C=(1-D)*P/2),t.showLabelBackdrop){const e=ze(t.backdropPadding),i=T.heights[x],n=T.widths[x];let o=w+C-e.top,s=v-e.left;switch(O){case\"middle\":o-=i/2;break;case\"bottom\":o-=i}switch(M){case\"center\":s-=n/2;break;case\"right\":s-=n}u={left:s,top:o,width:n+e.width,height:i+e.height,color:t.backdropColor}}m.push({rotation:p,label:y,font:S,color:n,strokeColor:l,strokeWidth:h,textOffset:C,textAlign:M,textBaseline:O,translation:[v,w],backdrop:u})}return m}_getXAxisLabelAlignment(){const{position:t,ticks:e}=this.options;if(-Et(this.labelRotation))return\"top\"===t?\"left\":\"right\";let i=\"center\";return\"start\"===e.align?i=\"left\":\"end\"===e.align&&(i=\"right\"),i}_getYAxisLabelAlignment(t){const e=this,{position:i,ticks:{crossAlign:n,mirror:o,padding:s}}=e.options,a=t+s,r=e._getLabelSizes().widest.width;let l,c;return\"left\"===i?o?(l=\"left\",c=e.right+s):(c=e.right-a,\"near\"===n?l=\"right\":\"center\"===n?(l=\"center\",c-=r/2):(l=\"left\",c=e.left)):\"right\"===i?o?(l=\"right\",c=e.left+s):(c=e.left+a,\"near\"===n?l=\"left\":\"center\"===n?(l=\"center\",c+=r/2):(l=\"right\",c=e.right)):l=\"right\",{textAlign:l,x:c}}_computeLabelArea(){const t=this;if(t.options.ticks.mirror)return;const e=t.chart,i=t.options.position;return\"left\"===i||\"right\"===i?{top:0,left:t.left,bottom:e.height,right:t.right}:\"top\"===i||\"bottom\"===i?{top:t.top,left:0,bottom:t.bottom,right:e.width}:void 0}drawBackground(){const{ctx:t,options:{backgroundColor:e},left:i,top:n,width:o,height:s}=this;e&&(t.save(),t.fillStyle=e,t.fillRect(i,n,o,s),t.restore())}getLineWidthForValue(t){const e=this,i=e.options.grid;if(!e._isVisible()||!i.display)return 0;const n=e.ticks.findIndex((e=>e.value===t));if(n>=0){return i.setContext(e.getContext(n)).lineWidth}return 0}drawGrid(t){const e=this,i=e.options.grid,n=e.ctx,o=e._gridLineItems||(e._gridLineItems=e._computeGridLineItems(t));let s,a;const r=(t,e,i)=>{i.width&&i.color&&(n.save(),n.lineWidth=i.width,n.strokeStyle=i.color,n.setLineDash(i.borderDash||[]),n.lineDashOffset=i.borderDashOffset,n.beginPath(),n.moveTo(t.x,t.y),n.lineTo(e.x,e.y),n.stroke(),n.restore())};if(i.display)for(s=0,a=o.length;s<a;++s){const t=o[s];i.drawOnChartArea&&r({x:t.x1,y:t.y1},{x:t.x2,y:t.y2},t),i.drawTicks&&r({x:t.tx1,y:t.ty1},{x:t.tx2,y:t.ty2},{color:t.tickColor,width:t.tickWidth,borderDash:t.tickBorderDash,borderDashOffset:t.tickBorderDashOffset})}}drawBorder(){const t=this,{chart:e,ctx:i,options:{grid:n}}=t,o=n.setContext(t.getContext()),s=n.drawBorder?o.borderWidth:0;if(!s)return;const a=n.setContext(t.getContext(0)).lineWidth,r=t._borderValue;let l,c,h,d;t.isHorizontal()?(l=Xt(e,t.left,s)-s/2,c=Xt(e,t.right,a)+a/2,h=d=r):(h=Xt(e,t.top,s)-s/2,d=Xt(e,t.bottom,a)+a/2,l=c=r),i.save(),i.lineWidth=o.borderWidth,i.strokeStyle=o.borderColor,i.beginPath(),i.moveTo(l,h),i.lineTo(c,d),i.stroke(),i.restore()}drawLabels(t){const e=this;if(!e.options.ticks.display)return;const i=e.ctx,n=e._computeLabelArea();n&&Zt(i,n);const o=e._labelItems||(e._labelItems=e._computeLabelItems(t));let s,a;for(s=0,a=o.length;s<a;++s){const t=o[s],e=t.font,n=t.label;t.backdrop&&(i.fillStyle=t.backdrop.color,i.fillRect(t.backdrop.left,t.backdrop.top,t.backdrop.width,t.backdrop.height)),ee(i,n,0,t.textOffset,e,t)}n&&Qt(i)}drawTitle(){const{ctx:t,options:{position:e,title:i,reverse:n}}=this;if(!i.display)return;const s=Fe(i.font),a=ze(i.padding),r=i.align;let l=s.lineHeight/2;\"bottom\"===e?(l+=a.bottom,Y(i.text)&&(l+=s.lineHeight*(i.text.length-1))):l+=a.top;const{titleX:c,titleY:h,maxWidth:d,rotation:u}=function(t,e,i,n){const{top:s,left:a,bottom:r,right:l}=t;let c,h,d,u=0;return t.isHorizontal()?(h=o(n,a,l),d=Hi(t,i,e),c=l-a):(h=Hi(t,i,e),d=o(n,r,s),u=\"left\"===i?-Mt:Mt),{titleX:h,titleY:d,maxWidth:c,rotation:u}}(this,l,e,r);ee(t,i.text,0,0,s,{color:i.color,maxWidth:d,rotation:u,textAlign:Ui(r,e,n),textBaseline:\"middle\",translation:[c,h]})}draw(t){const e=this;e._isVisible()&&(e.drawBackground(),e.drawGrid(t),e.drawBorder(),e.drawTitle(),e.drawLabels(t))}_layers(){const t=this,e=t.options,i=e.ticks&&e.ticks.z||0,n=e.grid&&e.grid.z||0;return t._isVisible()&&t.draw===Xi.prototype.draw?[{z:n,draw(e){t.drawBackground(),t.drawGrid(e),t.drawTitle()}},{z:n+1,draw(){t.drawBorder()}},{z:i,draw(e){t.drawLabels(e)}}]:[{z:i,draw(e){t.draw(e)}}]}getMatchingVisibleMetas(t){const e=this,i=e.chart.getSortedVisibleDatasetMetas(),n=e.axis+\"AxisID\",o=[];let s,a;for(s=0,a=i.length;s<a;++s){const a=i[s];a[n]!==e.id||t&&a.type!==t||o.push(a)}return o}_resolveTickFontOptions(t){return Fe(this.options.ticks.setContext(this.getContext(t)).font)}_maxDigits(){const t=this,e=t._resolveTickFontOptions(0).lineHeight;return(t.isHorizontal()?t.width:t.height)/e}}function qi(t,e=[\"\"],i=t,n,o=(()=>t[0])){ht(n)||(n=an(\"_fallback\",t));const s={[Symbol.toStringTag]:\"Object\",_cacheable:!0,_scopes:t,_rootScopes:i,_fallback:n,_getTarget:o,override:o=>qi([o,...t],e,i,n)};return new Proxy(s,{deleteProperty:(e,i)=>(delete e[i],delete e._keys,delete t[0][i],!0),get:(i,n)=>Ji(i,n,(()=>function(t,e,i,n){let o;for(const s of e)if(o=an(Zi(s,t),i),ht(o))return Qi(t,o)?on(i,n,t,o):o}(n,e,t,i))),getOwnPropertyDescriptor:(t,e)=>Reflect.getOwnPropertyDescriptor(t._scopes[0],e),getPrototypeOf:()=>Reflect.getPrototypeOf(t[0]),has:(t,e)=>rn(t).includes(e),ownKeys:t=>rn(t),set:(t,e,i)=>((t._storage||(t._storage=o()))[e]=i,delete t[e],delete t._keys,!0)})}function Ki(t,e,i,n){const o={_cacheable:!1,_proxy:t,_context:e,_subProxy:i,_stack:new Set,_descriptors:Gi(t,n),setContext:e=>Ki(t,e,i,n),override:o=>Ki(t.override(o),e,i,n)};return new Proxy(o,{deleteProperty:(e,i)=>(delete e[i],delete t[i],!0),get:(t,e,i)=>Ji(t,e,(()=>function(t,e,i){const{_proxy:n,_context:o,_subProxy:s,_descriptors:a}=t;let r=n[e];dt(r)&&a.isScriptable(e)&&(r=function(t,e,i,n){const{_proxy:o,_context:s,_subProxy:a,_stack:r}=i;if(r.has(t))throw new Error(\"Recursion detected: \"+[...r].join(\"->\")+\"->\"+t);r.add(t),e=e(s,a||n),r.delete(t),U(e)&&(e=on(o._scopes,o,t,e));return e}(e,r,t,i));Y(r)&&r.length&&(r=function(t,e,i,n){const{_proxy:o,_context:s,_subProxy:a,_descriptors:r}=i;if(ht(s.index)&&n(t))e=e[s.index%e.length];else if(U(e[0])){const i=e,n=o._scopes.filter((t=>t!==i));e=[];for(const l of i){const i=on(n,o,t,l);e.push(Ki(i,s,a&&a[t],r))}}return e}(e,r,t,a.isIndexable));Qi(e,r)&&(r=Ki(r,o,s&&s[e],a));return r}(t,e,i))),getOwnPropertyDescriptor:(e,i)=>e._descriptors.allKeys?Reflect.has(t,i)?{enumerable:!0,configurable:!0}:void 0:Reflect.getOwnPropertyDescriptor(t,i),getPrototypeOf:()=>Reflect.getPrototypeOf(t),has:(e,i)=>Reflect.has(t,i),ownKeys:()=>Reflect.ownKeys(t),set:(e,i,n)=>(t[i]=n,delete e[i],!0)})}function Gi(t,e={scriptable:!0,indexable:!0}){const{_scriptable:i=e.scriptable,_indexable:n=e.indexable,_allKeys:o=e.allKeys}=t;return{allKeys:o,scriptable:i,indexable:n,isScriptable:dt(i)?i:()=>i,isIndexable:dt(n)?n:()=>n}}const Zi=(t,e)=>t?t+ct(e):e,Qi=(t,e)=>U(e)&&\"adapters\"!==t;function Ji(t,e,i){let n=t[e];return ht(n)||(n=i(),ht(n)&&(t[e]=n)),n}function tn(t,e,i){return dt(t)?t(e,i):t}const en=(t,e)=>!0===t?e:\"string\"==typeof t?lt(e,t):void 0;function nn(t,e,i,n){for(const o of e){const e=en(i,o);if(e){t.add(e);const o=tn(e._fallback,i,e);if(ht(o)&&o!==i&&o!==n)return o}else if(!1===e&&ht(n)&&i!==n)return null}return!1}function on(t,e,i,n){const o=e._rootScopes,s=tn(e._fallback,i,n),a=[...t,...o],r=new Set;r.add(n);let l=sn(r,a,i,s||i);return null!==l&&((!ht(s)||s===i||(l=sn(r,a,s,l),null!==l))&&qi([...r],[\"\"],o,s,(()=>function(t,e,i){const n=t._getTarget();e in n||(n[e]={});const o=n[e];if(Y(o)&&U(i))return i;return o}(e,i,n))))}function sn(t,e,i,n){for(;i;)i=nn(t,e,i,n);return i}function an(t,e){for(const i of e){if(!i)continue;const e=i[t];if(ht(e))return e}}function rn(t){let e=t._keys;return e||(e=t._keys=function(t){const e=new Set;for(const i of t)for(const t of Object.keys(i).filter((t=>!t.startsWith(\"_\"))))e.add(t);return[...e]}(t._scopes)),e}const ln=Number.EPSILON||1e-14,cn=(t,e)=>e<t.length&&!t[e].skip&&t[e],hn=t=>\"x\"===t?\"y\":\"x\";function dn(t,e,i,n){const o=t.skip?e:t,s=e,a=i.skip?e:i,r=Vt(s,o),l=Vt(a,s);let c=r/(r+l),h=l/(r+l);c=isNaN(c)?0:c,h=isNaN(h)?0:h;const d=n*c,u=n*h;return{previous:{x:s.x-d*(a.x-o.x),y:s.y-d*(a.y-o.y)},next:{x:s.x+u*(a.x-o.x),y:s.y+u*(a.y-o.y)}}}function un(t,e=\"x\"){const i=hn(e),n=t.length,o=Array(n).fill(0),s=Array(n);let a,r,l,c=cn(t,0);for(a=0;a<n;++a)if(r=l,l=c,c=cn(t,a+1),l){if(c){const t=c[e]-l[e];o[a]=0!==t?(c[i]-l[i])/t:0}s[a]=r?c?Dt(o[a-1])!==Dt(o[a])?0:(o[a-1]+o[a])/2:o[a-1]:o[a]}!function(t,e,i){const n=t.length;let o,s,a,r,l,c=cn(t,0);for(let h=0;h<n-1;++h)l=c,c=cn(t,h+1),l&&c&&(At(e[h],0,ln)?i[h]=i[h+1]=0:(o=i[h]/e[h],s=i[h+1]/e[h],r=Math.pow(o,2)+Math.pow(s,2),r<=9||(a=3/Math.sqrt(r),i[h]=o*a*e[h],i[h+1]=s*a*e[h])))}(t,o,s),function(t,e,i=\"x\"){const n=hn(i),o=t.length;let s,a,r,l=cn(t,0);for(let c=0;c<o;++c){if(a=r,r=l,l=cn(t,c+1),!r)continue;const o=r[i],h=r[n];a&&(s=(o-a[i])/3,r[`cp1${i}`]=o-s,r[`cp1${n}`]=h-s*e[c]),l&&(s=(l[i]-o)/3,r[`cp2${i}`]=o+s,r[`cp2${n}`]=h+s*e[c])}}(t,s,e)}function fn(t,e,i){return Math.max(Math.min(t,i),e)}function gn(t,e,i,n,o){let s,a,r,l;if(e.spanGaps&&(t=t.filter((t=>!t.skip))),\"monotone\"===e.cubicInterpolationMode)un(t,o);else{let i=n?t[t.length-1]:t[0];for(s=0,a=t.length;s<a;++s)r=t[s],l=dn(i,r,t[Math.min(s+1,a-(n?0:1))%a],e.tension),r.cp1x=l.previous.x,r.cp1y=l.previous.y,r.cp2x=l.next.x,r.cp2y=l.next.y,i=r}e.capBezierPoints&&function(t,e){let i,n,o,s,a,r=Gt(t[0],e);for(i=0,n=t.length;i<n;++i)a=s,s=r,r=i<n-1&&Gt(t[i+1],e),s&&(o=t[i],a&&(o.cp1x=fn(o.cp1x,e.left,e.right),o.cp1y=fn(o.cp1y,e.top,e.bottom)),r&&(o.cp2x=fn(o.cp2x,e.left,e.right),o.cp2y=fn(o.cp2y,e.top,e.bottom)))}(t,i)}function pn(t,e,i,n){return{x:t.x+i*(e.x-t.x),y:t.y+i*(e.y-t.y)}}function mn(t,e,i,n){return{x:t.x+i*(e.x-t.x),y:\"middle\"===n?i<.5?t.y:e.y:\"after\"===n?i<1?t.y:e.y:i>0?e.y:t.y}}function xn(t,e,i,n){const o={x:t.cp2x,y:t.cp2y},s={x:e.cp1x,y:e.cp1y},a=pn(t,o,i),r=pn(o,s,i),l=pn(s,e,i),c=pn(a,r,i),h=pn(r,l,i);return pn(c,h,i)}function bn(t,e,i){return t?function(t,e){return{x:i=>t+t+e-i,setWidth(t){e=t},textAlign:t=>\"center\"===t?t:\"right\"===t?\"left\":\"right\",xPlus:(t,e)=>t-e,leftForLtr:(t,e)=>t-e}}(e,i):{x:t=>t,setWidth(t){},textAlign:t=>t,xPlus:(t,e)=>t+e,leftForLtr:(t,e)=>t}}function _n(t,e){let i,n;\"ltr\"!==e&&\"rtl\"!==e||(i=t.canvas.style,n=[i.getPropertyValue(\"direction\"),i.getPropertyPriority(\"direction\")],i.setProperty(\"direction\",e,\"important\"),t.prevTextDirection=n)}function yn(t,e){void 0!==e&&(delete t.prevTextDirection,t.canvas.style.setProperty(\"direction\",e[0],e[1]))}function vn(t){return\"angle\"===t?{between:Ht,compare:Bt,normalize:Wt}:{between:(t,e,i)=>t>=Math.min(e,i)&&t<=Math.max(i,e),compare:(t,e)=>t-e,normalize:t=>t}}function wn({start:t,end:e,count:i,loop:n,style:o}){return{start:t%i,end:e%i,loop:n&&(e-t+1)%i==0,style:o}}function Mn(t,e,i){if(!i)return[t];const{property:n,start:o,end:s}=i,a=e.length,{compare:r,between:l,normalize:c}=vn(n),{start:h,end:d,loop:u,style:f}=function(t,e,i){const{property:n,start:o,end:s}=i,{between:a,normalize:r}=vn(n),l=e.length;let c,h,{start:d,end:u,loop:f}=t;if(f){for(d+=l,u+=l,c=0,h=l;c<h&&a(r(e[d%l][n]),o,s);++c)d--,u--;d%=l,u%=l}return u<d&&(u+=l),{start:d,end:u,loop:f,style:t.style}}(t,e,i),g=[];let p,m,x,b=!1,_=null;const y=()=>b||l(o,x,p)&&0!==r(o,x),v=()=>!b||0===r(s,p)||l(s,x,p);for(let t=h,i=h;t<=d;++t)m=e[t%a],m.skip||(p=c(m[n]),p!==x&&(b=l(p,o,s),null===_&&y()&&(_=0===r(p,o)?t:i),null!==_&&v()&&(g.push(wn({start:_,end:t,loop:u,count:a,style:f})),_=null),i=t,x=p));return null!==_&&g.push(wn({start:_,end:d,loop:u,count:a,style:f})),g}function kn(t,e){const i=[],n=t.segments;for(let o=0;o<n.length;o++){const s=Mn(n[o],t.points,e);s.length&&i.push(...s)}return i}function Sn(t,e){const i=t.points,n=t.options.spanGaps,o=i.length;if(!o)return[];const s=!!t._loop,{start:a,end:r}=function(t,e,i,n){let o=0,s=e-1;if(i&&!n)for(;o<e&&!t[o].skip;)o++;for(;o<e&&t[o].skip;)o++;for(o%=e,i&&(s+=o);s>o&&t[s%e].skip;)s--;return s%=e,{start:o,end:s}}(i,o,s,n);if(!0===n)return Pn([{start:a,end:r,loop:s}],i,e);return Pn(function(t,e,i,n){const o=t.length,s=[];let a,r=e,l=t[e];for(a=e+1;a<=i;++a){const i=t[a%o];i.skip||i.stop?l.skip||(n=!1,s.push({start:e%o,end:(a-1)%o,loop:n}),e=r=i.stop?a:null):(r=a,l.skip&&(e=a)),l=i}return null!==r&&s.push({start:e%o,end:r%o,loop:n}),s}(i,a,r<a?r+o:r,!!t._fullLoop&&0===a&&r===o-1),i,e)}function Pn(t,e,i){return i&&i.setContext&&e?function(t,e,i){const n=e.length,o=[];let s=t[0].start,a=s;for(const r of t){let t,l,c=e[s%n];for(a=s+1;a<=r.end;a++){const h=e[a%n];l=Dn(i.setContext({type:\"segment\",p0:c,p1:h})),Cn(l,t)&&(o.push({start:s,end:a-1,loop:r.loop,style:t}),t=l,s=a-1),c=h,t=l}s<a-1&&(o.push({start:s,end:a-1,loop:r.loop,style:l}),s=a-1)}return o}(t,e,i):t}function Dn(t){return{backgroundColor:t.backgroundColor,borderCapStyle:t.borderCapStyle,borderDash:t.borderDash,borderDashOffset:t.borderDashOffset,borderJoinStyle:t.borderJoinStyle,borderWidth:t.borderWidth,borderColor:t.borderColor}}function Cn(t,e){return e&&JSON.stringify(t)!==JSON.stringify(e)}var On=Object.freeze({__proto__:null,easingEffects:mi,color:W,getHoverColor:H,noop:N,uid:j,isNullOrUndef:$,isArray:Y,isObject:U,isFinite:X,finiteOrDefault:q,valueOrDefault:K,toPercentage:G,toDimension:Z,callback:Q,each:J,_elementsEqual:tt,clone:et,_merger:nt,merge:ot,mergeIf:st,_mergerIf:at,_deprecated:function(t,e,i,n){void 0!==e&&console.warn(t+': \"'+i+'\" is deprecated. Please use \"'+n+'\" instead')},resolveObjectKey:lt,_capitalize:ct,defined:ht,isFunction:dt,setsEqual:ut,toFontString:$t,_measureText:Yt,_longestText:Ut,_alignPixel:Xt,clearCanvas:qt,drawPoint:Kt,_isPointInArea:Gt,clipArea:Zt,unclipArea:Qt,_steppedLineTo:Jt,_bezierCurveTo:te,renderText:ee,addRoundedRectPath:ie,_lookup:ne,_lookupByKey:oe,_rlookupByKey:se,_filterBetween:ae,listenArrayEvents:le,unlistenArrayEvents:ce,_arrayUnique:he,_createResolver:qi,_attachContext:Ki,_descriptors:Gi,splineCurve:dn,splineCurveMonotone:un,_updateBezierControlPoints:gn,_getParentNode:de,getStyle:ge,getRelativePosition:xe,getMaximumSize:_e,retinaScale:ye,supportsEventListenerOptions:ve,readUsedSize:we,fontString:function(t,e,i){return e+\" \"+t+\"px \"+i},requestAnimFrame:t,throttled:e,debounce:i,_toLeftRightCenter:n,_alignStartEnd:o,_textX:s,_pointInLine:pn,_steppedInterpolation:mn,_bezierInterpolation:xn,formatNumber:zi,toLineHeight:Le,_readValueToProps:Re,toTRBL:Ee,toTRBLCorners:Ie,toPadding:ze,toFont:Fe,resolve:Ve,_addGrace:Be,PI:bt,TAU:_t,PITAU:yt,INFINITY:vt,RAD_PER_DEG:wt,HALF_PI:Mt,QUARTER_PI:kt,TWO_THIRDS_PI:St,log10:Pt,sign:Dt,niceNum:Ct,_factorize:Ot,isNumber:Tt,almostEquals:At,almostWhole:Lt,_setMinAndMaxByKey:Rt,toRadians:Et,toDegrees:It,_decimalPlaces:zt,getAngleFromPoint:Ft,distanceBetweenPoints:Vt,_angleDiff:Bt,_normalizeAngle:Wt,_angleBetween:Ht,_limitValue:Nt,_int16Range:jt,getRtlAdapter:bn,overrideTextDirection:_n,restoreTextDirection:yn,_boundSegment:Mn,_boundSegments:kn,_computeSegments:Sn});class Tn{constructor(t,e,i){this.type=t,this.scope=e,this.override=i,this.items=Object.create(null)}isForType(t){return Object.prototype.isPrototypeOf.call(this.type.prototype,t.prototype)}register(t){const e=this,i=Object.getPrototypeOf(t);let n;(function(t){return\"id\"in t&&\"defaults\"in t})(i)&&(n=e.register(i));const o=e.items,s=t.id,a=e.scope+\".\"+s;if(!s)throw new Error(\"class does not have id: \"+t);return s in o||(o[s]=t,function(t,e,i){const n=ot(Object.create(null),[i?xt.get(i):{},xt.get(e),t.defaults]);xt.set(e,n),t.defaultRoutes&&function(t,e){Object.keys(e).forEach((i=>{const n=i.split(\".\"),o=n.pop(),s=[t].concat(n).join(\".\"),a=e[i].split(\".\"),r=a.pop(),l=a.join(\".\");xt.route(s,o,l,r)}))}(e,t.defaultRoutes);t.descriptors&&xt.describe(e,t.descriptors)}(t,a,n),e.override&&xt.override(t.id,t.overrides)),a}get(t){return this.items[t]}unregister(t){const e=this.items,i=t.id,n=this.scope;i in e&&delete e[i],n&&i in xt[n]&&(delete xt[n][i],this.override&&delete ft[i])}}var An=new class{constructor(){this.controllers=new Tn(Ri,\"datasets\",!0),this.elements=new Tn(Ei,\"elements\"),this.plugins=new Tn(Object,\"plugins\"),this.scales=new Tn(Xi,\"scales\"),this._typedRegistries=[this.controllers,this.scales,this.elements]}add(...t){this._each(\"register\",t)}remove(...t){this._each(\"unregister\",t)}addControllers(...t){this._each(\"register\",t,this.controllers)}addElements(...t){this._each(\"register\",t,this.elements)}addPlugins(...t){this._each(\"register\",t,this.plugins)}addScales(...t){this._each(\"register\",t,this.scales)}getController(t){return this._get(t,this.controllers,\"controller\")}getElement(t){return this._get(t,this.elements,\"element\")}getPlugin(t){return this._get(t,this.plugins,\"plugin\")}getScale(t){return this._get(t,this.scales,\"scale\")}removeControllers(...t){this._each(\"unregister\",t,this.controllers)}removeElements(...t){this._each(\"unregister\",t,this.elements)}removePlugins(...t){this._each(\"unregister\",t,this.plugins)}removeScales(...t){this._each(\"unregister\",t,this.scales)}_each(t,e,i){const n=this;[...e].forEach((e=>{const o=i||n._getRegistryForType(e);i||o.isForType(e)||o===n.plugins&&e.id?n._exec(t,o,e):J(e,(e=>{const o=i||n._getRegistryForType(e);n._exec(t,o,e)}))}))}_exec(t,e,i){const n=ct(t);Q(i[\"before\"+n],[],i),e[t](i),Q(i[\"after\"+n],[],i)}_getRegistryForType(t){for(let e=0;e<this._typedRegistries.length;e++){const i=this._typedRegistries[e];if(i.isForType(t))return i}return this.plugins}_get(t,e,i){const n=e.get(t);if(void 0===n)throw new Error('\"'+t+'\" is not a registered '+i+\".\");return n}};class Ln{constructor(){this._init=[]}notify(t,e,i,n){const o=this;\"beforeInit\"===e&&(o._init=o._createDescriptors(t,!0),o._notify(o._init,t,\"install\"));const s=n?o._descriptors(t).filter(n):o._descriptors(t),a=o._notify(s,t,e,i);return\"destroy\"===e&&(o._notify(s,t,\"stop\"),o._notify(o._init,t,\"uninstall\")),a}_notify(t,e,i,n){n=n||{};for(const o of t){const t=o.plugin;if(!1===Q(t[i],[e,n,o.options],t)&&n.cancelable)return!1}return!0}invalidate(){$(this._cache)||(this._oldCache=this._cache,this._cache=void 0)}_descriptors(t){if(this._cache)return this._cache;const e=this._cache=this._createDescriptors(t);return this._notifyStateChanges(t),e}_createDescriptors(t,e){const i=t&&t.config,n=K(i.options&&i.options.plugins,{}),o=function(t){const e=[],i=Object.keys(An.plugins.items);for(let t=0;t<i.length;t++)e.push(An.getPlugin(i[t]));const n=t.plugins||[];for(let t=0;t<n.length;t++){const i=n[t];-1===e.indexOf(i)&&e.push(i)}return e}(i);return!1!==n||e?function(t,e,i,n){const o=[],s=t.getContext();for(let a=0;a<e.length;a++){const r=e[a],l=Rn(i[r.id],n);null!==l&&o.push({plugin:r,options:En(t.config,r,l,s)})}return o}(t,o,n,e):[]}_notifyStateChanges(t){const e=this._oldCache||[],i=this._cache,n=(t,e)=>t.filter((t=>!e.some((e=>t.plugin.id===e.plugin.id))));this._notify(n(e,i),t,\"stop\"),this._notify(n(i,e),t,\"start\")}}function Rn(t,e){return e||!1!==t?!0===t?{}:t:null}function En(t,e,i,n){const o=t.pluginScopeKeys(e),s=t.getOptionScopes(i,o);return t.createResolver(s,n,[\"\"],{scriptable:!1,indexable:!1,allKeys:!0})}function In(t,e){const i=xt.datasets[t]||{};return((e.datasets||{})[t]||{}).indexAxis||e.indexAxis||i.indexAxis||\"x\"}function zn(t,e){return\"x\"===t||\"y\"===t?t:e.axis||(\"top\"===(i=e.position)||\"bottom\"===i?\"x\":\"left\"===i||\"right\"===i?\"y\":void 0)||t.charAt(0).toLowerCase();var i}function Fn(t){const e=t.options||(t.options={});e.plugins=K(e.plugins,{}),e.scales=function(t,e){const i=ft[t.type]||{scales:{}},n=e.scales||{},o=In(t.type,e),s=Object.create(null),a=Object.create(null);return Object.keys(n).forEach((t=>{const e=n[t],r=zn(t,e),l=function(t,e){return t===e?\"_index_\":\"_value_\"}(r,o),c=i.scales||{};s[r]=s[r]||t,a[t]=st(Object.create(null),[{axis:r},e,c[r],c[l]])})),t.data.datasets.forEach((i=>{const o=i.type||t.type,r=i.indexAxis||In(o,e),l=(ft[o]||{}).scales||{};Object.keys(l).forEach((t=>{const e=function(t,e){let i=t;return\"_index_\"===t?i=e:\"_value_\"===t&&(i=\"x\"===e?\"y\":\"x\"),i}(t,r),o=i[e+\"AxisID\"]||s[e]||e;a[o]=a[o]||Object.create(null),st(a[o],[{axis:e},n[o],l[t]])}))})),Object.keys(a).forEach((t=>{const e=a[t];st(e,[xt.scales[e.type],xt.scale])})),a}(t,e)}function Vn(t){return(t=t||{}).datasets=t.datasets||[],t.labels=t.labels||[],t}const Bn=new Map,Wn=new Set;function Hn(t,e){let i=Bn.get(t);return i||(i=e(),Bn.set(t,i),Wn.add(i)),i}const Nn=(t,e,i)=>{const n=lt(e,i);void 0!==n&&t.add(n)};class jn{constructor(t){this._config=function(t){return(t=t||{}).data=Vn(t.data),Fn(t),t}(t),this._scopeCache=new Map,this._resolverCache=new Map}get type(){return this._config.type}set type(t){this._config.type=t}get data(){return this._config.data}set data(t){this._config.data=Vn(t)}get options(){return this._config.options}set options(t){this._config.options=t}get plugins(){return this._config.plugins}update(){const t=this._config;this.clearCache(),Fn(t)}clearCache(){this._scopeCache.clear(),this._resolverCache.clear()}datasetScopeKeys(t){return Hn(t,(()=>[[`datasets.${t}`,\"\"]]))}datasetAnimationScopeKeys(t,e){return Hn(`${t}.transition.${e}`,(()=>[[`datasets.${t}.transitions.${e}`,`transitions.${e}`],[`datasets.${t}`,\"\"]]))}datasetElementScopeKeys(t,e){return Hn(`${t}-${e}`,(()=>[[`datasets.${t}.elements.${e}`,`datasets.${t}`,`elements.${e}`,\"\"]]))}pluginScopeKeys(t){const e=t.id;return Hn(`${this.type}-plugin-${e}`,(()=>[[`plugins.${e}`,...t.additionalOptionScopes||[]]]))}_cachedScopes(t,e){const i=this._scopeCache;let n=i.get(t);return n&&!e||(n=new Map,i.set(t,n)),n}getOptionScopes(t,e,i){const{options:n,type:o}=this,s=this._cachedScopes(t,i),a=s.get(e);if(a)return a;const r=new Set;e.forEach((e=>{t&&(r.add(t),e.forEach((e=>Nn(r,t,e)))),e.forEach((t=>Nn(r,n,t))),e.forEach((t=>Nn(r,ft[o]||{},t))),e.forEach((t=>Nn(r,xt,t))),e.forEach((t=>Nn(r,gt,t)))}));const l=[...r];return Wn.has(e)&&s.set(e,l),l}chartOptionScopes(){const{options:t,type:e}=this;return[t,ft[e]||{},xt.datasets[e]||{},{type:e},xt,gt]}resolveNamedOptions(t,e,i,n=[\"\"]){const o={$shared:!0},{resolver:s,subPrefixes:a}=$n(this._resolverCache,t,n);let r=s;if(function(t,e){const{isScriptable:i,isIndexable:n}=Gi(t);for(const o of e)if(i(o)&&dt(t[o])||n(o)&&Y(t[o]))return!0;return!1}(s,e)){o.$shared=!1;r=Ki(s,i=dt(i)?i():i,this.createResolver(t,i,a))}for(const t of e)o[t]=r[t];return o}createResolver(t,e,i=[\"\"],n){const{resolver:o}=$n(this._resolverCache,t,i);return U(e)?Ki(o,e,void 0,n):o}}function $n(t,e,i){let n=t.get(e);n||(n=new Map,t.set(e,n));const o=i.join();let s=n.get(o);if(!s){s={resolver:qi(e,i),subPrefixes:i.filter((t=>!t.toLowerCase().includes(\"hover\")))},n.set(o,s)}return s}const Yn=[\"top\",\"bottom\",\"left\",\"right\",\"chartArea\"];function Un(t,e){return\"top\"===t||\"bottom\"===t||-1===Yn.indexOf(t)&&\"x\"===e}function Xn(t,e){return function(i,n){return i[t]===n[t]?i[e]-n[e]:i[t]-n[t]}}function qn(t){const e=t.chart,i=e.options.animation;e.notifyPlugins(\"afterRender\"),Q(i&&i.onComplete,[t],e)}function Kn(t){const e=t.chart,i=e.options.animation;Q(i&&i.onProgress,[t],e)}function Gn(){return\"undefined\"!=typeof window&&\"undefined\"!=typeof document}function Zn(t){return Gn()&&\"string\"==typeof t?t=document.getElementById(t):t&&t.length&&(t=t[0]),t&&t.canvas&&(t=t.canvas),t}const Qn={},Jn=t=>{const e=Zn(t);return Object.values(Qn).filter((t=>t.canvas===e)).pop()};class to{constructor(t,e){const n=this;this.config=e=new jn(e);const o=Zn(t),s=Jn(o);if(s)throw new Error(\"Canvas is already in use. Chart with ID '\"+s.id+\"' must be destroyed before the canvas can be reused.\");const r=e.createResolver(e.chartOptionScopes(),n.getContext());this.platform=n._initializePlatform(o,e);const l=n.platform.acquireContext(o,r.aspectRatio),c=l&&l.canvas,h=c&&c.height,d=c&&c.width;this.id=j(),this.ctx=l,this.canvas=c,this.width=d,this.height=h,this._options=r,this._aspectRatio=this.aspectRatio,this._layers=[],this._metasets=[],this._stacks=void 0,this.boxes=[],this.currentDevicePixelRatio=void 0,this.chartArea=void 0,this._active=[],this._lastEvent=void 0,this._listeners={},this._responsiveListeners=void 0,this._sortedMetasets=[],this.scales={},this.scale=void 0,this._plugins=new Ln,this.$proxies={},this._hiddenIndices={},this.attached=!1,this._animationsDisabled=void 0,this.$context=void 0,this._doResize=i((()=>this.update(\"resize\")),r.resizeDelay||0),Qn[n.id]=n,l&&c?(a.listen(n,\"complete\",qn),a.listen(n,\"progress\",Kn),n._initialize(),n.attached&&n.update()):console.error(\"Failed to create chart: can't acquire context from the given item\")}get aspectRatio(){const{options:{aspectRatio:t,maintainAspectRatio:e},width:i,height:n,_aspectRatio:o}=this;return $(t)?e&&o?o:n?i/n:null:t}get data(){return this.config.data}set data(t){this.config.data=t}get options(){return this._options}set options(t){this.config.options=t}_initialize(){const t=this;return t.notifyPlugins(\"beforeInit\"),t.options.responsive?t.resize():ye(t,t.options.devicePixelRatio),t.bindEvents(),t.notifyPlugins(\"afterInit\"),t}_initializePlatform(t,e){return e.platform?new e.platform:!Gn()||\"undefined\"!=typeof OffscreenCanvas&&t instanceof OffscreenCanvas?new Qe:new di}clear(){return qt(this.canvas,this.ctx),this}stop(){return a.stop(this),this}resize(t,e){a.running(this)?this._resizeBeforeDraw={width:t,height:e}:this._resize(t,e)}_resize(t,e){const i=this,n=i.options,o=i.canvas,s=n.maintainAspectRatio&&i.aspectRatio,a=i.platform.getMaximumSize(o,t,e,s),r=n.devicePixelRatio||i.platform.getDevicePixelRatio();i.width=a.width,i.height=a.height,i._aspectRatio=i.aspectRatio,ye(i,r,!0)&&(i.notifyPlugins(\"resize\",{size:a}),Q(n.onResize,[i,a],i),i.attached&&i._doResize()&&i.render())}ensureScalesHaveIDs(){J(this.options.scales||{},((t,e)=>{t.id=e}))}buildOrUpdateScales(){const t=this,e=t.options,i=e.scales,n=t.scales,o=Object.keys(n).reduce(((t,e)=>(t[e]=!1,t)),{});let s=[];i&&(s=s.concat(Object.keys(i).map((t=>{const e=i[t],n=zn(t,e),o=\"r\"===n,s=\"x\"===n;return{options:e,dposition:o?\"chartArea\":s?\"bottom\":\"left\",dtype:o?\"radialLinear\":s?\"category\":\"linear\"}})))),J(s,(i=>{const s=i.options,a=s.id,r=zn(a,s),l=K(s.type,i.dtype);void 0!==s.position&&Un(s.position,r)===Un(i.dposition)||(s.position=i.dposition),o[a]=!0;let c=null;if(a in n&&n[a].type===l)c=n[a];else{c=new(An.getScale(l))({id:a,type:l,ctx:t.ctx,chart:t}),n[c.id]=c}c.init(s,e)})),J(o,((t,e)=>{t||delete n[e]})),J(n,(e=>{Ge.configure(t,e,e.options),Ge.addBox(t,e)}))}_updateMetasets(){const t=this,e=t._metasets,i=t.data.datasets.length,n=e.length;if(e.sort(((t,e)=>t.index-e.index)),n>i){for(let e=i;e<n;++e)t._destroyDatasetMeta(e);e.splice(i,n-i)}t._sortedMetasets=e.slice(0).sort(Xn(\"order\",\"index\"))}_removeUnreferencedMetasets(){const t=this,{_metasets:e,data:{datasets:i}}=t;e.length>i.length&&delete t._stacks,e.forEach(((e,n)=>{0===i.filter((t=>t===e._dataset)).length&&t._destroyDatasetMeta(n)}))}buildOrUpdateControllers(){const t=this,e=[],i=t.data.datasets;let n,o;for(t._removeUnreferencedMetasets(),n=0,o=i.length;n<o;n++){const o=i[n];let s=t.getDatasetMeta(n);const a=o.type||t.config.type;if(s.type&&s.type!==a&&(t._destroyDatasetMeta(n),s=t.getDatasetMeta(n)),s.type=a,s.indexAxis=o.indexAxis||In(a,t.options),s.order=o.order||0,s.index=n,s.label=\"\"+o.label,s.visible=t.isDatasetVisible(n),s.controller)s.controller.updateIndex(n),s.controller.linkScales();else{const i=An.getController(a),{datasetElementType:o,dataElementType:r}=xt.datasets[a];Object.assign(i.prototype,{dataElementType:An.getElement(r),datasetElementType:o&&An.getElement(o)}),s.controller=new i(t,n),e.push(s.controller)}}return t._updateMetasets(),e}_resetElements(){const t=this;J(t.data.datasets,((e,i)=>{t.getDatasetMeta(i).controller.reset()}),t)}reset(){this._resetElements(),this.notifyPlugins(\"reset\")}update(t){const e=this,i=e.config;i.update(),e._options=i.createResolver(i.chartOptionScopes(),e.getContext()),J(e.scales,(t=>{Ge.removeBox(e,t)}));const n=e._animationsDisabled=!e.options.animation;e.ensureScalesHaveIDs(),e.buildOrUpdateScales();const o=new Set(Object.keys(e._listeners)),s=new Set(e.options.events);if(ut(o,s)&&!!this._responsiveListeners===e.options.responsive||(e.unbindEvents(),e.bindEvents()),e._plugins.invalidate(),!1===e.notifyPlugins(\"beforeUpdate\",{mode:t,cancelable:!0}))return;const a=e.buildOrUpdateControllers();e.notifyPlugins(\"beforeElementsUpdate\");let r=0;for(let t=0,i=e.data.datasets.length;t<i;t++){const{controller:i}=e.getDatasetMeta(t),o=!n&&-1===a.indexOf(i);i.buildOrUpdateElements(o),r=Math.max(+i.getMaxOverflow(),r)}e._minPadding=r,e._updateLayout(r),n||J(a,(t=>{t.reset()})),e._updateDatasets(t),e.notifyPlugins(\"afterUpdate\",{mode:t}),e._layers.sort(Xn(\"z\",\"_idx\")),e._lastEvent&&e._eventHandler(e._lastEvent,!0),e.render()}_updateLayout(t){const e=this;if(!1===e.notifyPlugins(\"beforeLayout\",{cancelable:!0}))return;Ge.update(e,e.width,e.height,t);const i=e.chartArea,n=i.width<=0||i.height<=0;e._layers=[],J(e.boxes,(t=>{n&&\"chartArea\"===t.position||(t.configure&&t.configure(),e._layers.push(...t._layers()))}),e),e._layers.forEach(((t,e)=>{t._idx=e})),e.notifyPlugins(\"afterLayout\")}_updateDatasets(t){const e=this,i=\"function\"==typeof t;if(!1!==e.notifyPlugins(\"beforeDatasetsUpdate\",{mode:t,cancelable:!0})){for(let n=0,o=e.data.datasets.length;n<o;++n)e._updateDataset(n,i?t({datasetIndex:n}):t);e.notifyPlugins(\"afterDatasetsUpdate\",{mode:t})}}_updateDataset(t,e){const i=this,n=i.getDatasetMeta(t),o={meta:n,index:t,mode:e,cancelable:!0};!1!==i.notifyPlugins(\"beforeDatasetUpdate\",o)&&(n.controller._update(e),o.cancelable=!1,i.notifyPlugins(\"afterDatasetUpdate\",o))}render(){const t=this;!1!==t.notifyPlugins(\"beforeRender\",{cancelable:!0})&&(a.has(t)?t.attached&&!a.running(t)&&a.start(t):(t.draw(),qn({chart:t})))}draw(){const t=this;let e;if(t._resizeBeforeDraw){const{width:e,height:i}=t._resizeBeforeDraw;t._resize(e,i),t._resizeBeforeDraw=null}if(t.clear(),t.width<=0||t.height<=0)return;if(!1===t.notifyPlugins(\"beforeDraw\",{cancelable:!0}))return;const i=t._layers;for(e=0;e<i.length&&i[e].z<=0;++e)i[e].draw(t.chartArea);for(t._drawDatasets();e<i.length;++e)i[e].draw(t.chartArea);t.notifyPlugins(\"afterDraw\")}_getSortedDatasetMetas(t){const e=this._sortedMetasets,i=[];let n,o;for(n=0,o=e.length;n<o;++n){const o=e[n];t&&!o.visible||i.push(o)}return i}getSortedVisibleDatasetMetas(){return this._getSortedDatasetMetas(!0)}_drawDatasets(){const t=this;if(!1===t.notifyPlugins(\"beforeDatasetsDraw\",{cancelable:!0}))return;const e=t.getSortedVisibleDatasetMetas();for(let i=e.length-1;i>=0;--i)t._drawDataset(e[i]);t.notifyPlugins(\"afterDatasetsDraw\")}_drawDataset(t){const e=this,i=e.ctx,n=t._clip,o=e.chartArea,s={meta:t,index:t.index,cancelable:!0};!1!==e.notifyPlugins(\"beforeDatasetDraw\",s)&&(Zt(i,{left:!1===n.left?0:o.left-n.left,right:!1===n.right?e.width:o.right+n.right,top:!1===n.top?0:o.top-n.top,bottom:!1===n.bottom?e.height:o.bottom+n.bottom}),t.controller.draw(),Qt(i),s.cancelable=!1,e.notifyPlugins(\"afterDatasetDraw\",s))}getElementsAtEventForMode(t,e,i,n){const o=Oe.modes[e];return\"function\"==typeof o?o(this,t,i,n):[]}getDatasetMeta(t){const e=this.data.datasets[t],i=this._metasets;let n=i.filter((t=>t&&t._dataset===e)).pop();return n||(n={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null,order:e&&e.order||0,index:t,_dataset:e,_parsed:[],_sorted:!1},i.push(n)),n}getContext(){return this.$context||(this.$context={chart:this,type:\"chart\"})}getVisibleDatasetCount(){return this.getSortedVisibleDatasetMetas().length}isDatasetVisible(t){const e=this.data.datasets[t];if(!e)return!1;const i=this.getDatasetMeta(t);return\"boolean\"==typeof i.hidden?!i.hidden:!e.hidden}setDatasetVisibility(t,e){this.getDatasetMeta(t).hidden=!e}toggleDataVisibility(t){this._hiddenIndices[t]=!this._hiddenIndices[t]}getDataVisibility(t){return!this._hiddenIndices[t]}_updateDatasetVisibility(t,e){const i=this,n=e?\"show\":\"hide\",o=i.getDatasetMeta(t),s=o.controller._resolveAnimations(void 0,n);i.setDatasetVisibility(t,e),s.update(o,{visible:e}),i.update((e=>e.datasetIndex===t?n:void 0))}hide(t){this._updateDatasetVisibility(t,!1)}show(t){this._updateDatasetVisibility(t,!0)}_destroyDatasetMeta(t){const e=this,i=e._metasets&&e._metasets[t];i&&i.controller&&(i.controller._destroy(),delete e._metasets[t])}destroy(){const t=this,{canvas:e,ctx:i}=t;let n,o;for(t.stop(),a.remove(t),n=0,o=t.data.datasets.length;n<o;++n)t._destroyDatasetMeta(n);t.config.clearCache(),e&&(t.unbindEvents(),qt(e,i),t.platform.releaseContext(i),t.canvas=null,t.ctx=null),t.notifyPlugins(\"destroy\"),delete Qn[t.id]}toBase64Image(...t){return this.canvas.toDataURL(...t)}bindEvents(){this.bindUserEvents(),this.options.responsive?this.bindResponsiveEvents():this.attached=!0}bindUserEvents(){const t=this,e=t._listeners,i=t.platform,n=function(e,i,n){e.offsetX=i,e.offsetY=n,t._eventHandler(e)};J(t.options.events,(o=>((n,o)=>{i.addEventListener(t,n,o),e[n]=o})(o,n)))}bindResponsiveEvents(){const t=this;t._responsiveListeners||(t._responsiveListeners={});const e=t._responsiveListeners,i=t.platform,n=(n,o)=>{i.addEventListener(t,n,o),e[n]=o},o=(n,o)=>{e[n]&&(i.removeEventListener(t,n,o),delete e[n])},s=(e,i)=>{t.canvas&&t.resize(e,i)};let a;const r=()=>{o(\"attach\",r),t.attached=!0,t.resize(),n(\"resize\",s),n(\"detach\",a)};a=()=>{t.attached=!1,o(\"resize\",s),n(\"attach\",r)},i.isAttached(t.canvas)?r():a()}unbindEvents(){const t=this;J(t._listeners,((e,i)=>{t.platform.removeEventListener(t,i,e)})),t._listeners={},J(t._responsiveListeners,((e,i)=>{t.platform.removeEventListener(t,i,e)})),t._responsiveListeners=void 0}updateHoverStyle(t,e,i){const n=i?\"set\":\"remove\";let o,s,a,r;for(\"dataset\"===e&&(o=this.getDatasetMeta(t[0].datasetIndex),o.controller[\"_\"+n+\"DatasetHoverStyle\"]()),a=0,r=t.length;a<r;++a){s=t[a];const e=s&&this.getDatasetMeta(s.datasetIndex).controller;e&&e[n+\"HoverStyle\"](s.element,s.datasetIndex,s.index)}}getActiveElements(){return this._active||[]}setActiveElements(t){const e=this,i=e._active||[],n=t.map((({datasetIndex:t,index:i})=>{const n=e.getDatasetMeta(t);if(!n)throw new Error(\"No dataset found at index \"+t);return{datasetIndex:t,element:n.data[i],index:i}}));!tt(n,i)&&(e._active=n,e._updateHoverStyles(n,i))}notifyPlugins(t,e,i){return this._plugins.notify(this,t,e,i)}_updateHoverStyles(t,e,i){const n=this,o=n.options.hover,s=(t,e)=>t.filter((t=>!e.some((e=>t.datasetIndex===e.datasetIndex&&t.index===e.index)))),a=s(e,t),r=i?t:s(t,e);a.length&&n.updateHoverStyle(a,o.mode,!1),r.length&&o.mode&&n.updateHoverStyle(r,o.mode,!0)}_eventHandler(t,e){const i=this,n={event:t,replay:e,cancelable:!0},o=e=>(e.options.events||this.options.events).includes(t.type);if(!1===i.notifyPlugins(\"beforeEvent\",n,o))return;const s=i._handleEvent(t,e);return n.cancelable=!1,i.notifyPlugins(\"afterEvent\",n,o),(s||n.changed)&&i.render(),i}_handleEvent(t,e){const i=this,{_active:n=[],options:o}=i,s=o.hover,a=e;let r=[],l=!1,c=null;return\"mouseout\"!==t.type&&(r=i.getElementsAtEventForMode(t,s.mode,s,a),c=\"click\"===t.type?i._lastEvent:t),i._lastEvent=null,Gt(t,i.chartArea,i._minPadding)&&(Q(o.onHover,[t,r,i],i),\"mouseup\"!==t.type&&\"click\"!==t.type&&\"contextmenu\"!==t.type||Q(o.onClick,[t,r,i],i)),l=!tt(r,n),(l||e)&&(i._active=r,i._updateHoverStyles(r,n,e)),i._lastEvent=c,l}}const eo=()=>J(to.instances,(t=>t._plugins.invalidate())),io=!0;function no(){throw new Error(\"This method is not implemented: Check that a complete date adapter is provided.\")}Object.defineProperties(to,{defaults:{enumerable:io,value:xt},instances:{enumerable:io,value:Qn},overrides:{enumerable:io,value:ft},registry:{enumerable:io,value:An},version:{enumerable:io,value:\"3.3.2\"},getChart:{enumerable:io,value:Jn},register:{enumerable:io,value:(...t)=>{An.add(...t),eo()}},unregister:{enumerable:io,value:(...t)=>{An.remove(...t),eo()}}});class oo{constructor(t){this.options=t||{}}formats(){return no()}parse(t,e){return no()}format(t,e){return no()}add(t,e,i){return no()}diff(t,e,i){return no()}startOf(t,e,i){return no()}endOf(t,e){return no()}}oo.override=function(t){Object.assign(oo.prototype,t)};var so={_date:oo};function ao(t){const e=function(t){if(!t._cache.$bar){const e=t.getMatchingVisibleMetas(\"bar\");let i=[];for(let n=0,o=e.length;n<o;n++)i=i.concat(e[n].controller.getAllParsedValues(t));t._cache.$bar=he(i.sort(((t,e)=>t-e)))}return t._cache.$bar}(t);let i,n,o,s,a=t._length;const r=()=>{32767!==o&&-32768!==o&&(ht(s)&&(a=Math.min(a,Math.abs(o-s)||a)),s=o)};for(i=0,n=e.length;i<n;++i)o=t.getPixelForValue(e[i]),r();for(s=void 0,i=0,n=t.ticks.length;i<n;++i)o=t.getPixelForTick(i),r();return a}function ro(t,e,i,n){return Y(t)?function(t,e,i,n){const o=i.parse(t[0],n),s=i.parse(t[1],n),a=Math.min(o,s),r=Math.max(o,s);let l=a,c=r;Math.abs(a)>Math.abs(r)&&(l=r,c=a),e[i.axis]=c,e._custom={barStart:l,barEnd:c,start:o,end:s,min:a,max:r}}(t,e,i,n):e[i.axis]=i.parse(t,n),e}function lo(t,e,i,n){const o=t.iScale,s=t.vScale,a=o.getLabels(),r=o===s,l=[];let c,h,d,u;for(c=i,h=i+n;c<h;++c)u=e[c],d={},d[o.axis]=r||o.parse(a[c],c),l.push(ro(u,d,s,c));return l}function co(t){return t&&void 0!==t.barStart&&void 0!==t.barEnd}class ho extends Ri{parsePrimitiveData(t,e,i,n){return lo(t,e,i,n)}parseArrayData(t,e,i,n){return lo(t,e,i,n)}parseObjectData(t,e,i,n){const{iScale:o,vScale:s}=t,{xAxisKey:a=\"x\",yAxisKey:r=\"y\"}=this._parsing,l=\"x\"===o.axis?a:r,c=\"x\"===s.axis?a:r,h=[];let d,u,f,g;for(d=i,u=i+n;d<u;++d)g=e[d],f={},f[o.axis]=o.parse(lt(g,l),d),h.push(ro(lt(g,c),f,s,d));return h}updateRangeFromParsed(t,e,i,n){super.updateRangeFromParsed(t,e,i,n);const o=i._custom;o&&e===this._cachedMeta.vScale&&(t.min=Math.min(t.min,o.min),t.max=Math.max(t.max,o.max))}getLabelAndValue(t){const e=this._cachedMeta,{iScale:i,vScale:n}=e,o=this.getParsed(t),s=o._custom,a=co(s)?\"[\"+s.start+\", \"+s.end+\"]\":\"\"+n.getLabelForValue(o[n.axis]);return{label:\"\"+i.getLabelForValue(o[i.axis]),value:a}}initialize(){const t=this;t.enableOptionSharing=!0,super.initialize();t._cachedMeta.stack=t.getDataset().stack}update(t){const e=this._cachedMeta;this.updateElements(e.data,0,e.data.length,t)}updateElements(t,e,i,n){const o=this,s=\"reset\"===n,a=o._cachedMeta.vScale,r=a.getBasePixel(),l=a.isHorizontal(),c=o._getRuler(),h=o.resolveDataElementOptions(e,n),d=o.getSharedOptions(h),u=o.includeOptions(n,d);o.updateSharedOptions(d,n,h);for(let h=e;h<e+i;h++){const e=o.getParsed(h),i=s||$(e[a.axis])?{base:r,head:r}:o._calculateBarValuePixels(h),f=o._calculateBarIndexPixels(h,c),g=(e._stacks||{})[a.axis],p={horizontal:l,base:i.base,enableBorderRadius:!g||co(e._custom)||o.index===g._top||o.index===g._bottom,x:l?i.head:f.center,y:l?f.center:i.head,height:l?f.size:void 0,width:l?void 0:f.size};u&&(p.options=d||o.resolveDataElementOptions(h,n)),o.updateElement(t[h],h,p,n)}}_getStacks(t,e){const i=this._cachedMeta.iScale,n=i.getMatchingVisibleMetas(this._type),o=i.options.stacked,s=n.length,a=[];let r,l;for(r=0;r<s;++r){if(l=n[r],void 0!==e){const t=l.controller.getParsed(e)[l.controller._cachedMeta.vScale.axis];if($(t)||isNaN(t))continue}if((!1===o||-1===a.indexOf(l.stack)||void 0===o&&void 0===l.stack)&&a.push(l.stack),l.index===t)break}return a.length||a.push(void 0),a}_getStackCount(t){return this._getStacks(void 0,t).length}_getStackIndex(t,e,i){const n=this._getStacks(t,i),o=void 0!==e?n.indexOf(e):-1;return-1===o?n.length-1:o}_getRuler(){const t=this,e=t.options,i=t._cachedMeta,n=i.iScale,o=[];let s,a;for(s=0,a=i.data.length;s<a;++s)o.push(n.getPixelForValue(t.getParsed(s)[n.axis],s));const r=e.barThickness;return{min:r||ao(n),pixels:o,start:n._startPixel,end:n._endPixel,stackCount:t._getStackCount(),scale:n,grouped:e.grouped,ratio:r?1:e.categoryPercentage*e.barPercentage}}_calculateBarValuePixels(t){const e=this,{vScale:i,_stacked:n}=e._cachedMeta,{base:o,minBarLength:s}=e.options,a=e.getParsed(t),r=a._custom,l=co(r);let c,h,d=a[i.axis],u=0,f=n?e.applyStack(i,a,n):d;f!==d&&(u=f-d,f=d),l&&(d=r.barStart,f=r.barEnd-r.barStart,0!==d&&Dt(d)!==Dt(r.barEnd)&&(u=0),u+=d);const g=$(o)||l?u:o;let p=i.getPixelForValue(g);c=this.chart.getDataVisibility(t)?i.getPixelForValue(u+f):p,h=c-p,void 0!==s&&Math.abs(h)<s&&(h=h<0?-s:s,0===d&&(p-=h/2),c=p+h);const m=o||0;if(p===i.getPixelForValue(m)){const t=i.getLineWidthForValue(m)/2;h>0?(p+=t,h-=t):h<0&&(p-=t,h+=t)}return{size:h,base:p,head:c,center:c+h/2}}_calculateBarIndexPixels(t,e){const i=this,n=e.scale,o=i.options,s=o.skipNull,a=K(o.maxBarThickness,1/0);let r,l;if(e.grouped){const n=s?i._getStackCount(t):e.stackCount,c=\"flex\"===o.barThickness?function(t,e,i,n){const o=e.pixels,s=o[t];let a=t>0?o[t-1]:null,r=t<o.length-1?o[t+1]:null;const l=i.categoryPercentage;null===a&&(a=s-(null===r?e.end-e.start:r-s)),null===r&&(r=s+s-a);const c=s-(s-Math.min(a,r))/2*l;return{chunk:Math.abs(r-a)/2*l/n,ratio:i.barPercentage,start:c}}(t,e,o,n):function(t,e,i,n){const o=i.barThickness;let s,a;return $(o)?(s=e.min*i.categoryPercentage,a=i.barPercentage):(s=o*n,a=1),{chunk:s/n,ratio:a,start:e.pixels[t]-s/2}}(t,e,o,n),h=i._getStackIndex(i.index,i._cachedMeta.stack,s?t:void 0);r=c.start+c.chunk*h+c.chunk/2,l=Math.min(a,c.chunk*c.ratio)}else r=n.getPixelForValue(i.getParsed(t)[n.axis],t),l=Math.min(a,e.min*e.ratio);return{base:r-l/2,head:r+l/2,center:r,size:l}}draw(){const t=this,e=t.chart,i=t._cachedMeta,n=i.vScale,o=i.data,s=o.length;let a=0;for(Zt(e.ctx,e.chartArea);a<s;++a)null!==t.getParsed(a)[n.axis]&&o[a].draw(t._ctx);Qt(e.ctx)}}ho.id=\"bar\",ho.defaults={datasetElementType:!1,dataElementType:\"bar\",categoryPercentage:.8,barPercentage:.9,grouped:!0,animations:{numbers:{type:\"number\",properties:[\"x\",\"y\",\"base\",\"width\",\"height\"]}}},ho.overrides={interaction:{mode:\"index\"},scales:{_index_:{type:\"category\",offset:!0,grid:{offset:!0}},_value_:{type:\"linear\",beginAtZero:!0}}};class uo extends Ri{initialize(){this.enableOptionSharing=!0,super.initialize()}parseObjectData(t,e,i,n){const{xScale:o,yScale:s}=t,{xAxisKey:a=\"x\",yAxisKey:r=\"y\"}=this._parsing,l=[];let c,h,d;for(c=i,h=i+n;c<h;++c)d=e[c],l.push({x:o.parse(lt(d,a),c),y:s.parse(lt(d,r),c),_custom:d&&d.r&&+d.r});return l}getMaxOverflow(){const{data:t,_parsed:e}=this._cachedMeta;let i=0;for(let n=t.length-1;n>=0;--n)i=Math.max(i,t[n].size()/2,e[n]._custom);return i>0&&i}getLabelAndValue(t){const e=this._cachedMeta,{xScale:i,yScale:n}=e,o=this.getParsed(t),s=i.getLabelForValue(o.x),a=n.getLabelForValue(o.y),r=o._custom;return{label:e.label,value:\"(\"+s+\", \"+a+(r?\", \"+r:\"\")+\")\"}}update(t){const e=this._cachedMeta.data;this.updateElements(e,0,e.length,t)}updateElements(t,e,i,n){const o=this,s=\"reset\"===n,{iScale:a,vScale:r}=o._cachedMeta,l=o.resolveDataElementOptions(e,n),c=o.getSharedOptions(l),h=o.includeOptions(n,c),d=a.axis,u=r.axis;for(let l=e;l<e+i;l++){const e=t[l],i=!s&&o.getParsed(l),c={},f=c[d]=s?a.getPixelForDecimal(.5):a.getPixelForValue(i[d]),g=c[u]=s?r.getBasePixel():r.getPixelForValue(i[u]);c.skip=isNaN(f)||isNaN(g),h&&(c.options=o.resolveDataElementOptions(l,n),s&&(c.options.radius=0)),o.updateElement(e,l,c,n)}o.updateSharedOptions(c,n,l)}resolveDataElementOptions(t,e){const i=this.getParsed(t);let n=super.resolveDataElementOptions(t,e);n.$shared&&(n=Object.assign({},n,{$shared:!1}));const o=n.radius;return\"active\"!==e&&(n.radius=0),n.radius+=K(i&&i._custom,o),n}}uo.id=\"bubble\",uo.defaults={datasetElementType:!1,dataElementType:\"point\",animations:{numbers:{type:\"number\",properties:[\"x\",\"y\",\"borderWidth\",\"radius\"]}}},uo.overrides={scales:{x:{type:\"linear\"},y:{type:\"linear\"}},plugins:{tooltip:{callbacks:{title:()=>\"\"}}}};class fo extends Ri{constructor(t,e){super(t,e),this.enableOptionSharing=!0,this.innerRadius=void 0,this.outerRadius=void 0,this.offsetX=void 0,this.offsetY=void 0}linkScales(){}parse(t,e){const i=this.getDataset().data,n=this._cachedMeta;let o,s;for(o=t,s=t+e;o<s;++o)n._parsed[o]=+i[o]}_getRotation(){return Et(this.options.rotation-90)}_getCircumference(){return Et(this.options.circumference)}_getRotationExtents(){let t=_t,e=-_t;const i=this;for(let n=0;n<i.chart.data.datasets.length;++n)if(i.chart.isDatasetVisible(n)){const o=i.chart.getDatasetMeta(n).controller,s=o._getRotation(),a=o._getCircumference();t=Math.min(t,s),e=Math.max(e,s+a)}return{rotation:t,circumference:e-t}}update(t){const e=this,i=e.chart,{chartArea:n}=i,o=e._cachedMeta,s=o.data,a=e.getMaxBorderWidth()+e.getMaxOffset(s),r=Math.max((Math.min(n.width,n.height)-a)/2,0),l=Math.min(G(e.options.cutout,r),1),c=e._getRingWeight(e.index),{circumference:h,rotation:d}=e._getRotationExtents(),{ratioX:u,ratioY:f,offsetX:g,offsetY:p}=function(t,e,i){let n=1,o=1,s=0,a=0;if(e<_t){const r=t,l=r+e,c=Math.cos(r),h=Math.sin(r),d=Math.cos(l),u=Math.sin(l),f=(t,e,n)=>Ht(t,r,l,!0)?1:Math.max(e,e*i,n,n*i),g=(t,e,n)=>Ht(t,r,l,!0)?-1:Math.min(e,e*i,n,n*i),p=f(0,c,d),m=f(Mt,h,u),x=g(bt,c,d),b=g(bt+Mt,h,u);n=(p-x)/2,o=(m-b)/2,s=-(p+x)/2,a=-(m+b)/2}return{ratioX:n,ratioY:o,offsetX:s,offsetY:a}}(d,h,l),m=(n.width-a)/u,x=(n.height-a)/f,b=Math.max(Math.min(m,x)/2,0),_=Z(e.options.radius,b),y=(_-Math.max(_*l,0))/e._getVisibleDatasetWeightTotal();e.offsetX=g*_,e.offsetY=p*_,o.total=e.calculateTotal(),e.outerRadius=_-y*e._getRingWeightOffset(e.index),e.innerRadius=Math.max(e.outerRadius-y*c,0),e.updateElements(s,0,s.length,t)}_circumference(t,e){const i=this,n=i.options,o=i._cachedMeta,s=i._getCircumference();return e&&n.animation.animateRotate||!this.chart.getDataVisibility(t)||null===o._parsed[t]?0:i.calculateCircumference(o._parsed[t]*s/_t)}updateElements(t,e,i,n){const o=this,s=\"reset\"===n,a=o.chart,r=a.chartArea,l=a.options.animation,c=(r.left+r.right)/2,h=(r.top+r.bottom)/2,d=s&&l.animateScale,u=d?0:o.innerRadius,f=d?0:o.outerRadius,g=o.resolveDataElementOptions(e,n),p=o.getSharedOptions(g),m=o.includeOptions(n,p);let x,b=o._getRotation();for(x=0;x<e;++x)b+=o._circumference(x,s);for(x=e;x<e+i;++x){const e=o._circumference(x,s),i=t[x],a={x:c+o.offsetX,y:h+o.offsetY,startAngle:b,endAngle:b+e,circumference:e,outerRadius:f,innerRadius:u};m&&(a.options=p||o.resolveDataElementOptions(x,n)),b+=e,o.updateElement(i,x,a,n)}o.updateSharedOptions(p,n,g)}calculateTotal(){const t=this._cachedMeta,e=t.data;let i,n=0;for(i=0;i<e.length;i++){const e=t._parsed[i];null!==e&&!isNaN(e)&&this.chart.getDataVisibility(i)&&(n+=Math.abs(e))}return n}calculateCircumference(t){const e=this._cachedMeta.total;return e>0&&!isNaN(t)?_t*(Math.abs(t)/e):0}getLabelAndValue(t){const e=this._cachedMeta,i=this.chart,n=i.data.labels||[],o=zi(e._parsed[t],i.options.locale);return{label:n[t]||\"\",value:o}}getMaxBorderWidth(t){const e=this;let i=0;const n=e.chart;let o,s,a,r,l;if(!t)for(o=0,s=n.data.datasets.length;o<s;++o)if(n.isDatasetVisible(o)){a=n.getDatasetMeta(o),t=a.data,r=a.controller,r!==e&&r.configure();break}if(!t)return 0;for(o=0,s=t.length;o<s;++o)l=r.resolveDataElementOptions(o),\"inner\"!==l.borderAlign&&(i=Math.max(i,l.borderWidth||0,l.hoverBorderWidth||0));return i}getMaxOffset(t){let e=0;for(let i=0,n=t.length;i<n;++i){const t=this.resolveDataElementOptions(i);e=Math.max(e,t.offset||0,t.hoverOffset||0)}return e}_getRingWeightOffset(t){let e=0;for(let i=0;i<t;++i)this.chart.isDatasetVisible(i)&&(e+=this._getRingWeight(i));return e}_getRingWeight(t){return Math.max(K(this.chart.data.datasets[t].weight,1),0)}_getVisibleDatasetWeightTotal(){return this._getRingWeightOffset(this.chart.data.datasets.length)||1}}fo.id=\"doughnut\",fo.defaults={datasetElementType:!1,dataElementType:\"arc\",animation:{animateRotate:!0,animateScale:!1},animations:{numbers:{type:\"number\",properties:[\"circumference\",\"endAngle\",\"innerRadius\",\"outerRadius\",\"startAngle\",\"x\",\"y\",\"offset\",\"borderWidth\"]}},cutout:\"50%\",rotation:0,circumference:360,radius:\"100%\",indexAxis:\"r\"},fo.overrides={aspectRatio:1,plugins:{legend:{labels:{generateLabels(t){const e=t.data;return e.labels.length&&e.datasets.length?e.labels.map(((e,i)=>{const n=t.getDatasetMeta(0).controller.getStyle(i);return{text:e,fillStyle:n.backgroundColor,strokeStyle:n.borderColor,lineWidth:n.borderWidth,hidden:!t.getDataVisibility(i),index:i}})):[]}},onClick(t,e,i){i.chart.toggleDataVisibility(e.index),i.chart.update()}},tooltip:{callbacks:{title:()=>\"\",label(t){let e=t.label;const i=\": \"+t.formattedValue;return Y(e)?(e=e.slice(),e[0]+=i):e+=i,e}}}}};class go extends Ri{initialize(){this.enableOptionSharing=!0,super.initialize()}update(t){const e=this,i=e._cachedMeta,{dataset:n,data:o=[],_dataset:s}=i,a=e.chart._animationsDisabled;let{start:r,count:l}=function(t,e,i){const n=e.length;let o=0,s=n;if(t._sorted){const{iScale:a,_parsed:r}=t,l=a.axis,{min:c,max:h,minDefined:d,maxDefined:u}=a.getUserBounds();d&&(o=Nt(Math.min(oe(r,a.axis,c).lo,i?n:oe(e,l,a.getPixelForValue(c)).lo),0,n-1)),s=u?Nt(Math.max(oe(r,a.axis,h).hi+1,i?0:oe(e,l,a.getPixelForValue(h)).hi+1),o,n)-o:n-o}return{start:o,count:s}}(i,o,a);e._drawStart=r,e._drawCount=l,function(t){const{xScale:e,yScale:i,_scaleRanges:n}=t,o={xmin:e.min,xmax:e.max,ymin:i.min,ymax:i.max};if(!n)return t._scaleRanges=o,!0;const s=n.xmin!==e.min||n.xmax!==e.max||n.ymin!==i.min||n.ymax!==i.max;return Object.assign(n,o),s}(i)&&(r=0,l=o.length),n._decimated=!!s._decimated,n.points=o;const c=e.resolveDatasetElementOptions(t);e.options.showLine||(c.borderWidth=0),c.segment=e.options.segment,e.updateElement(n,void 0,{animated:!a,options:c},t),e.updateElements(o,r,l,t)}updateElements(t,e,i,n){const o=this,s=\"reset\"===n,{iScale:a,vScale:r,_stacked:l}=o._cachedMeta,c=o.resolveDataElementOptions(e,n),h=o.getSharedOptions(c),d=o.includeOptions(n,h),u=a.axis,f=r.axis,g=o.options.spanGaps,p=Tt(g)?g:Number.POSITIVE_INFINITY,m=o.chart._animationsDisabled||s||\"none\"===n;let x=e>0&&o.getParsed(e-1);for(let c=e;c<e+i;++c){const e=t[c],i=o.getParsed(c),g=m?e:{},b=$(i[f]),_=g[u]=a.getPixelForValue(i[u],c),y=g[f]=s||b?r.getBasePixel():r.getPixelForValue(l?o.applyStack(r,i,l):i[f],c);g.skip=isNaN(_)||isNaN(y)||b,g.stop=c>0&&i[u]-x[u]>p,g.parsed=i,d&&(g.options=h||o.resolveDataElementOptions(c,n)),m||o.updateElement(e,c,g,n),x=i}o.updateSharedOptions(h,n,c)}getMaxOverflow(){const t=this,e=t._cachedMeta,i=e.dataset,n=i.options&&i.options.borderWidth||0,o=e.data||[];if(!o.length)return n;const s=o[0].size(t.resolveDataElementOptions(0)),a=o[o.length-1].size(t.resolveDataElementOptions(o.length-1));return Math.max(n,s,a)/2}draw(){const t=this._cachedMeta;t.dataset.updateControlPoints(this.chart.chartArea,t.iScale.axis),super.draw()}}go.id=\"line\",go.defaults={datasetElementType:\"line\",dataElementType:\"point\",showLine:!0,spanGaps:!1},go.overrides={scales:{_index_:{type:\"category\"},_value_:{type:\"linear\"}}};class po extends Ri{constructor(t,e){super(t,e),this.innerRadius=void 0,this.outerRadius=void 0}getLabelAndValue(t){const e=this._cachedMeta,i=this.chart,n=i.data.labels||[],o=zi(e._parsed[t].r,i.options.locale);return{label:n[t]||\"\",value:o}}update(t){const e=this._cachedMeta.data;this._updateRadius(),this.updateElements(e,0,e.length,t)}_updateRadius(){const t=this,e=t.chart,i=e.chartArea,n=e.options,o=Math.min(i.right-i.left,i.bottom-i.top),s=Math.max(o/2,0),a=(s-Math.max(n.cutoutPercentage?s/100*n.cutoutPercentage:1,0))/e.getVisibleDatasetCount();t.outerRadius=s-a*t.index,t.innerRadius=t.outerRadius-a}updateElements(t,e,i,n){const o=this,s=\"reset\"===n,a=o.chart,r=o.getDataset(),l=a.options.animation,c=o._cachedMeta.rScale,h=c.xCenter,d=c.yCenter,u=c.getIndexAngle(0)-.5*bt;let f,g=u;const p=360/o.countVisibleElements();for(f=0;f<e;++f)g+=o._computeAngle(f,n,p);for(f=e;f<e+i;f++){const e=t[f];let i=g,m=g+o._computeAngle(f,n,p),x=a.getDataVisibility(f)?c.getDistanceFromCenterForValue(r.data[f]):0;g=m,s&&(l.animateScale&&(x=0),l.animateRotate&&(i=m=u));const b={x:h,y:d,innerRadius:0,outerRadius:x,startAngle:i,endAngle:m,options:o.resolveDataElementOptions(f,n)};o.updateElement(e,f,b,n)}}countVisibleElements(){const t=this.getDataset(),e=this._cachedMeta;let i=0;return e.data.forEach(((e,n)=>{!isNaN(t.data[n])&&this.chart.getDataVisibility(n)&&i++})),i}_computeAngle(t,e,i){return this.chart.getDataVisibility(t)?Et(this.resolveDataElementOptions(t,e).angle||i):0}}po.id=\"polarArea\",po.defaults={dataElementType:\"arc\",animation:{animateRotate:!0,animateScale:!0},animations:{numbers:{type:\"number\",properties:[\"x\",\"y\",\"startAngle\",\"endAngle\",\"innerRadius\",\"outerRadius\"]}},indexAxis:\"r\",startAngle:0},po.overrides={aspectRatio:1,plugins:{legend:{labels:{generateLabels(t){const e=t.data;return e.labels.length&&e.datasets.length?e.labels.map(((e,i)=>{const n=t.getDatasetMeta(0).controller.getStyle(i);return{text:e,fillStyle:n.backgroundColor,strokeStyle:n.borderColor,lineWidth:n.borderWidth,hidden:!t.getDataVisibility(i),index:i}})):[]}},onClick(t,e,i){i.chart.toggleDataVisibility(e.index),i.chart.update()}},tooltip:{callbacks:{title:()=>\"\",label:t=>t.chart.data.labels[t.dataIndex]+\": \"+t.formattedValue}}},scales:{r:{type:\"radialLinear\",angleLines:{display:!1},beginAtZero:!0,grid:{circular:!0},pointLabels:{display:!1},startAngle:0}}};class mo extends fo{}mo.id=\"pie\",mo.defaults={cutout:0,rotation:0,circumference:360,radius:\"100%\"};class xo extends Ri{getLabelAndValue(t){const e=this._cachedMeta.vScale,i=this.getParsed(t);return{label:e.getLabels()[t],value:\"\"+e.getLabelForValue(i[e.axis])}}update(t){const e=this,i=e._cachedMeta,n=i.dataset,o=i.data||[],s=i.iScale.getLabels();if(n.points=o,\"resize\"!==t){const i=e.resolveDatasetElementOptions(t);e.options.showLine||(i.borderWidth=0);const a={_loop:!0,_fullLoop:s.length===o.length,options:i};e.updateElement(n,void 0,a,t)}e.updateElements(o,0,o.length,t)}updateElements(t,e,i,n){const o=this,s=o.getDataset(),a=o._cachedMeta.rScale,r=\"reset\"===n;for(let l=e;l<e+i;l++){const e=t[l],i=o.resolveDataElementOptions(l,n),c=a.getPointPositionForValue(l,s.data[l]),h=r?a.xCenter:c.x,d=r?a.yCenter:c.y,u={x:h,y:d,angle:c.angle,skip:isNaN(h)||isNaN(d),options:i};o.updateElement(e,l,u,n)}}}xo.id=\"radar\",xo.defaults={datasetElementType:\"line\",dataElementType:\"point\",indexAxis:\"r\",showLine:!0,elements:{line:{fill:\"start\"}}},xo.overrides={aspectRatio:1,scales:{r:{type:\"radialLinear\"}}};class bo extends go{}bo.id=\"scatter\",bo.defaults={showLine:!1,fill:!1},bo.overrides={interaction:{mode:\"point\"},plugins:{tooltip:{callbacks:{title:()=>\"\",label:t=>\"(\"+t.label+\", \"+t.formattedValue+\")\"}}},scales:{x:{type:\"linear\"},y:{type:\"linear\"}}};var _o=Object.freeze({__proto__:null,BarController:ho,BubbleController:uo,DoughnutController:fo,LineController:go,PolarAreaController:po,PieController:mo,RadarController:xo,ScatterController:bo});function yo(t,e,i){const{startAngle:n,pixelMargin:o,x:s,y:a,outerRadius:r,innerRadius:l}=e;let c=o/r;t.beginPath(),t.arc(s,a,r,n-c,i+c),l>o?(c=o/l,t.arc(s,a,l,i+c,n-c,!0)):t.arc(s,a,o,i+Mt,n-Mt),t.closePath(),t.clip()}function vo(t,e,i,n){const o=Re(t.options.borderRadius,[\"outerStart\",\"outerEnd\",\"innerStart\",\"innerEnd\"]);const s=(i-e)/2,a=Math.min(s,n*e/2),r=t=>{const e=(i-Math.min(s,t))*n/2;return Nt(t,0,Math.min(s,e))};return{outerStart:r(o.outerStart),outerEnd:r(o.outerEnd),innerStart:Nt(o.innerStart,0,a),innerEnd:Nt(o.innerEnd,0,a)}}function wo(t,e,i,n){return{x:i+t*Math.cos(e),y:n+t*Math.sin(e)}}function Mo(t,e,i,n){const{x:o,y:s,startAngle:a,pixelMargin:r,innerRadius:l}=e,c=Math.max(e.outerRadius+i-r,0),h=l>0?l+i+r:0,d=n-a,u=(d-Math.max(.001,d*c-i/bt)/c)/2,f=a+u,g=n-u,{outerStart:p,outerEnd:m,innerStart:x,innerEnd:b}=vo(e,h,c,g-f),_=c-p,y=c-m,v=f+p/_,w=g-m/y,M=h+x,k=h+b,S=f+x/M,P=g-b/k;if(t.beginPath(),t.arc(o,s,c,v,w),m>0){const e=wo(y,w,o,s);t.arc(e.x,e.y,m,w,g+Mt)}const D=wo(k,g,o,s);if(t.lineTo(D.x,D.y),b>0){const e=wo(k,P,o,s);t.arc(e.x,e.y,b,g+Mt,P+Math.PI)}if(t.arc(o,s,h,g-b/h,f+x/h,!0),x>0){const e=wo(M,S,o,s);t.arc(e.x,e.y,x,S+Math.PI,f-Mt)}const C=wo(_,f,o,s);if(t.lineTo(C.x,C.y),p>0){const e=wo(_,v,o,s);t.arc(e.x,e.y,p,f-Mt,v)}t.closePath()}function ko(t,e,i,n){const{options:o}=e,s=\"inner\"===o.borderAlign;o.borderWidth&&(s?(t.lineWidth=2*o.borderWidth,t.lineJoin=\"round\"):(t.lineWidth=o.borderWidth,t.lineJoin=\"bevel\"),e.fullCircles&&function(t,e,i){const{x:n,y:o,startAngle:s,pixelMargin:a,fullCircles:r}=e,l=Math.max(e.outerRadius-a,0),c=e.innerRadius+a;let h;for(i&&yo(t,e,s+_t),t.beginPath(),t.arc(n,o,c,s+_t,s,!0),h=0;h<r;++h)t.stroke();for(t.beginPath(),t.arc(n,o,l,s,s+_t),h=0;h<r;++h)t.stroke()}(t,e,s),s&&yo(t,e,n),Mo(t,e,i,n),t.stroke())}class So extends Ei{constructor(t){super(),this.options=void 0,this.circumference=void 0,this.startAngle=void 0,this.endAngle=void 0,this.innerRadius=void 0,this.outerRadius=void 0,this.pixelMargin=0,this.fullCircles=0,t&&Object.assign(this,t)}inRange(t,e,i){const n=this.getProps([\"x\",\"y\"],i),{angle:o,distance:s}=Ft(n,{x:t,y:e}),{startAngle:a,endAngle:r,innerRadius:l,outerRadius:c,circumference:h}=this.getProps([\"startAngle\",\"endAngle\",\"innerRadius\",\"outerRadius\",\"circumference\"],i);return(h>=_t||Ht(o,a,r))&&(s>=l&&s<=c)}getCenterPoint(t){const{x:e,y:i,startAngle:n,endAngle:o,innerRadius:s,outerRadius:a}=this.getProps([\"x\",\"y\",\"startAngle\",\"endAngle\",\"innerRadius\",\"outerRadius\",\"circumference\"],t),r=(n+o)/2,l=(s+a)/2;return{x:e+Math.cos(r)*l,y:i+Math.sin(r)*l}}tooltipPosition(t){return this.getCenterPoint(t)}draw(t){const e=this,{options:i,circumference:n}=e,o=(i.offset||0)/2;if(e.pixelMargin=\"inner\"===i.borderAlign?.33:0,e.fullCircles=n>_t?Math.floor(n/_t):0,0===n||e.innerRadius<0||e.outerRadius<0)return;t.save();let s=0;if(o){s=o/2;const i=(e.startAngle+e.endAngle)/2;t.translate(Math.cos(i)*s,Math.sin(i)*s),e.circumference>=bt&&(s=o)}t.fillStyle=i.backgroundColor,t.strokeStyle=i.borderColor;const a=function(t,e,i){const{fullCircles:n,startAngle:o,circumference:s}=e;let a=e.endAngle;if(n){Mo(t,e,i,o+_t);for(let e=0;e<n;++e)t.fill();isNaN(s)||(a=o+s%_t,s%_t==0&&(a+=_t))}return Mo(t,e,i,a),t.fill(),a}(t,e,s);ko(t,e,s,a),t.restore()}}function Po(t,e,i=e){t.lineCap=K(i.borderCapStyle,e.borderCapStyle),t.setLineDash(K(i.borderDash,e.borderDash)),t.lineDashOffset=K(i.borderDashOffset,e.borderDashOffset),t.lineJoin=K(i.borderJoinStyle,e.borderJoinStyle),t.lineWidth=K(i.borderWidth,e.borderWidth),t.strokeStyle=K(i.borderColor,e.borderColor)}function Do(t,e,i){t.lineTo(i.x,i.y)}function Co(t,e,i={}){const n=t.length,{start:o=0,end:s=n-1}=i,{start:a,end:r}=e,l=Math.max(o,a),c=Math.min(s,r),h=o<a&&s<a||o>r&&s>r;return{count:n,start:l,loop:e.loop,ilen:c<l&&!h?n+c-l:c-l}}function Oo(t,e,i,n){const{points:o,options:s}=e,{count:a,start:r,loop:l,ilen:c}=Co(o,i,n),h=function(t){return t.stepped?Jt:t.tension||\"monotone\"===t.cubicInterpolationMode?te:Do}(s);let d,u,f,{move:g=!0,reverse:p}=n||{};for(d=0;d<=c;++d)u=o[(r+(p?c-d:d))%a],u.skip||(g?(t.moveTo(u.x,u.y),g=!1):h(t,f,u,p,s.stepped),f=u);return l&&(u=o[(r+(p?c:0))%a],h(t,f,u,p,s.stepped)),!!l}function To(t,e,i,n){const o=e.points,{count:s,start:a,ilen:r}=Co(o,i,n),{move:l=!0,reverse:c}=n||{};let h,d,u,f,g,p,m=0,x=0;const b=t=>(a+(c?r-t:t))%s,_=()=>{f!==g&&(t.lineTo(m,g),t.lineTo(m,f),t.lineTo(m,p))};for(l&&(d=o[b(0)],t.moveTo(d.x,d.y)),h=0;h<=r;++h){if(d=o[b(h)],d.skip)continue;const e=d.x,i=d.y,n=0|e;n===u?(i<f?f=i:i>g&&(g=i),m=(x*m+e)/++x):(_(),t.lineTo(e,i),u=n,x=0,f=g=i),p=i}_()}function Ao(t){const e=t.options,i=e.borderDash&&e.borderDash.length;return!(t._decimated||t._loop||e.tension||\"monotone\"===e.cubicInterpolationMode||e.stepped||i)?To:Oo}So.id=\"arc\",So.defaults={borderAlign:\"center\",borderColor:\"#fff\",borderRadius:0,borderWidth:2,offset:0,angle:void 0},So.defaultRoutes={backgroundColor:\"backgroundColor\"};const Lo=\"function\"==typeof Path2D;function Ro(t,e,i,n){Lo&&1===e.segments.length?function(t,e,i,n){let o=e._path;o||(o=e._path=new Path2D,e.path(o,i,n)&&o.closePath()),Po(t,e.options),t.stroke(o)}(t,e,i,n):function(t,e,i,n){const{segments:o,options:s}=e,a=Ao(e);for(const r of o)Po(t,s,r.style),t.beginPath(),a(t,e,r,{start:i,end:i+n-1})&&t.closePath(),t.stroke()}(t,e,i,n)}class Eo extends Ei{constructor(t){super(),this.animated=!0,this.options=void 0,this._loop=void 0,this._fullLoop=void 0,this._path=void 0,this._points=void 0,this._segments=void 0,this._decimated=!1,this._pointsUpdated=!1,t&&Object.assign(this,t)}updateControlPoints(t,e){const i=this,n=i.options;if((n.tension||\"monotone\"===n.cubicInterpolationMode)&&!n.stepped&&!i._pointsUpdated){const o=n.spanGaps?i._loop:i._fullLoop;gn(i._points,n,t,o,e),i._pointsUpdated=!0}}set points(t){const e=this;e._points=t,delete e._segments,delete e._path,e._pointsUpdated=!1}get points(){return this._points}get segments(){return this._segments||(this._segments=Sn(this,this.options.segment))}first(){const t=this.segments,e=this.points;return t.length&&e[t[0].start]}last(){const t=this.segments,e=this.points,i=t.length;return i&&e[t[i-1].end]}interpolate(t,e){const i=this,n=i.options,o=t[e],s=i.points,a=kn(i,{property:e,start:o,end:o});if(!a.length)return;const r=[],l=function(t){return t.stepped?mn:t.tension||\"monotone\"===t.cubicInterpolationMode?xn:pn}(n);let c,h;for(c=0,h=a.length;c<h;++c){const{start:i,end:h}=a[c],d=s[i],u=s[h];if(d===u){r.push(d);continue}const f=l(d,u,Math.abs((o-d[e])/(u[e]-d[e])),n.stepped);f[e]=t[e],r.push(f)}return 1===r.length?r[0]:r}pathSegment(t,e,i){return Ao(this)(t,this,e,i)}path(t,e,i){const n=this,o=n.segments,s=Ao(n);let a=n._loop;e=e||0,i=i||n.points.length-e;for(const r of o)a&=s(t,n,r,{start:e,end:e+i-1});return!!a}draw(t,e,i,n){const o=this,s=o.options||{};(o.points||[]).length&&s.borderWidth&&(t.save(),Ro(t,o,i,n),t.restore(),o.animated&&(o._pointsUpdated=!1,o._path=void 0))}}function Io(t,e,i,n){const o=t.options,{[i]:s}=t.getProps([i],n);return Math.abs(e-s)<o.radius+o.hitRadius}Eo.id=\"line\",Eo.defaults={borderCapStyle:\"butt\",borderDash:[],borderDashOffset:0,borderJoinStyle:\"miter\",borderWidth:3,capBezierPoints:!0,cubicInterpolationMode:\"default\",fill:!1,spanGaps:!1,stepped:!1,tension:0},Eo.defaultRoutes={backgroundColor:\"backgroundColor\",borderColor:\"borderColor\"},Eo.descriptors={_scriptable:!0,_indexable:t=>\"borderDash\"!==t&&\"fill\"!==t};class zo extends Ei{constructor(t){super(),this.options=void 0,this.parsed=void 0,this.skip=void 0,this.stop=void 0,t&&Object.assign(this,t)}inRange(t,e,i){const n=this.options,{x:o,y:s}=this.getProps([\"x\",\"y\"],i);return Math.pow(t-o,2)+Math.pow(e-s,2)<Math.pow(n.hitRadius+n.radius,2)}inXRange(t,e){return Io(this,t,\"x\",e)}inYRange(t,e){return Io(this,t,\"y\",e)}getCenterPoint(t){const{x:e,y:i}=this.getProps([\"x\",\"y\"],t);return{x:e,y:i}}size(t){let e=(t=t||this.options||{}).radius||0;e=Math.max(e,e&&t.hoverRadius||0);return 2*(e+(e&&t.borderWidth||0))}draw(t){const e=this,i=e.options;e.skip||i.radius<.1||(t.strokeStyle=i.borderColor,t.lineWidth=i.borderWidth,t.fillStyle=i.backgroundColor,Kt(t,i,e.x,e.y))}getRange(){const t=this.options||{};return t.radius+t.hitRadius}}function Fo(t,e){const{x:i,y:n,base:o,width:s,height:a}=t.getProps([\"x\",\"y\",\"base\",\"width\",\"height\"],e);let r,l,c,h,d;return t.horizontal?(d=a/2,r=Math.min(i,o),l=Math.max(i,o),c=n-d,h=n+d):(d=s/2,r=i-d,l=i+d,c=Math.min(n,o),h=Math.max(n,o)),{left:r,top:c,right:l,bottom:h}}function Vo(t){let e=t.options.borderSkipped;const i={};return e?(e=t.horizontal?Bo(e,\"left\",\"right\",t.base>t.x):Bo(e,\"bottom\",\"top\",t.base<t.y),i[e]=!0,i):i}function Bo(t,e,i,n){var o,s,a;return n?(a=i,t=Wo(t=(o=t)===(s=e)?a:o===a?s:o,i,e)):t=Wo(t,e,i),t}function Wo(t,e,i){return\"start\"===t?e:\"end\"===t?i:t}function Ho(t,e,i,n){return t?0:Math.max(Math.min(e,n),i)}function No(t){const e=Fo(t),i=e.right-e.left,n=e.bottom-e.top,o=function(t,e,i){const n=t.options.borderWidth,o=Vo(t),s=Ee(n);return{t:Ho(o.top,s.top,0,i),r:Ho(o.right,s.right,0,e),b:Ho(o.bottom,s.bottom,0,i),l:Ho(o.left,s.left,0,e)}}(t,i/2,n/2),s=function(t,e,i){const{enableBorderRadius:n}=t.getProps([\"enableBorderRadius\"]),o=t.options.borderRadius,s=Ie(o),a=Math.min(e,i),r=Vo(t),l=n||U(o);return{topLeft:Ho(!l||r.top||r.left,s.topLeft,0,a),topRight:Ho(!l||r.top||r.right,s.topRight,0,a),bottomLeft:Ho(!l||r.bottom||r.left,s.bottomLeft,0,a),bottomRight:Ho(!l||r.bottom||r.right,s.bottomRight,0,a)}}(t,i/2,n/2);return{outer:{x:e.left,y:e.top,w:i,h:n,radius:s},inner:{x:e.left+o.l,y:e.top+o.t,w:i-o.l-o.r,h:n-o.t-o.b,radius:{topLeft:Math.max(0,s.topLeft-Math.max(o.t,o.l)),topRight:Math.max(0,s.topRight-Math.max(o.t,o.r)),bottomLeft:Math.max(0,s.bottomLeft-Math.max(o.b,o.l)),bottomRight:Math.max(0,s.bottomRight-Math.max(o.b,o.r))}}}}function jo(t,e,i,n){const o=null===e,s=null===i,a=t&&!(o&&s)&&Fo(t,n);return a&&(o||e>=a.left&&e<=a.right)&&(s||i>=a.top&&i<=a.bottom)}function $o(t,e){t.rect(e.x,e.y,e.w,e.h)}zo.id=\"point\",zo.defaults={borderWidth:1,hitRadius:1,hoverBorderWidth:1,hoverRadius:4,pointStyle:\"circle\",radius:3,rotation:0},zo.defaultRoutes={backgroundColor:\"backgroundColor\",borderColor:\"borderColor\"};class Yo extends Ei{constructor(t){super(),this.options=void 0,this.horizontal=void 0,this.base=void 0,this.width=void 0,this.height=void 0,t&&Object.assign(this,t)}draw(t){const e=this.options,{inner:i,outer:n}=No(this),o=(s=n.radius).topLeft||s.topRight||s.bottomLeft||s.bottomRight?ie:$o;var s;t.save(),n.w===i.w&&n.h===i.h||(t.beginPath(),o(t,n),t.clip(),o(t,i),t.fillStyle=e.borderColor,t.fill(\"evenodd\")),t.beginPath(),o(t,i),t.fillStyle=e.backgroundColor,t.fill(),t.restore()}inRange(t,e,i){return jo(this,t,e,i)}inXRange(t,e){return jo(this,t,null,e)}inYRange(t,e){return jo(this,null,t,e)}getCenterPoint(t){const{x:e,y:i,base:n,horizontal:o}=this.getProps([\"x\",\"y\",\"base\",\"horizontal\"],t);return{x:o?(e+n)/2:e,y:o?i:(i+n)/2}}getRange(t){return\"x\"===t?this.width/2:this.height/2}}Yo.id=\"bar\",Yo.defaults={borderSkipped:\"start\",borderWidth:0,borderRadius:0,enableBorderRadius:!0,pointStyle:void 0},Yo.defaultRoutes={backgroundColor:\"backgroundColor\",borderColor:\"borderColor\"};var Uo=Object.freeze({__proto__:null,ArcElement:So,LineElement:Eo,PointElement:zo,BarElement:Yo});function Xo(t){if(t._decimated){const e=t._data;delete t._decimated,delete t._data,Object.defineProperty(t,\"data\",{value:e})}}function qo(t){t.data.datasets.forEach((t=>{Xo(t)}))}var Ko={id:\"decimation\",defaults:{algorithm:\"min-max\",enabled:!1},beforeElementsUpdate:(t,e,i)=>{if(!i.enabled)return void qo(t);const n=t.width;t.data.datasets.forEach(((e,o)=>{const{_data:s,indexAxis:a}=e,r=t.getDatasetMeta(o),l=s||e.data;if(\"y\"===Ve([a,t.options.indexAxis]))return;if(\"line\"!==r.type)return;const c=t.scales[r.xAxisID];if(\"linear\"!==c.type&&\"time\"!==c.type)return;if(t.options.parsing)return;let h,{start:d,count:u}=function(t,e){const i=e.length;let n,o=0;const{iScale:s}=t,{min:a,max:r,minDefined:l,maxDefined:c}=s.getUserBounds();return l&&(o=Nt(oe(e,s.axis,a).lo,0,i-1)),n=c?Nt(oe(e,s.axis,r).hi+1,o,i)-o:i-o,{start:o,count:n}}(r,l);if(u<=4*n)Xo(e);else{switch($(s)&&(e._data=l,delete e.data,Object.defineProperty(e,\"data\",{configurable:!0,enumerable:!0,get:function(){return this._decimated},set:function(t){this._data=t}})),i.algorithm){case\"lttb\":h=function(t,e,i,n,o){const s=o.samples||n;if(s>=i)return t.slice(e,e+i);const a=[],r=(i-2)/(s-2);let l=0;const c=e+i-1;let h,d,u,f,g,p=e;for(a[l++]=t[p],h=0;h<s-2;h++){let n,o=0,s=0;const c=Math.floor((h+1)*r)+1+e,m=Math.min(Math.floor((h+2)*r)+1,i)+e,x=m-c;for(n=c;n<m;n++)o+=t[n].x,s+=t[n].y;o/=x,s/=x;const b=Math.floor(h*r)+1+e,_=Math.floor((h+1)*r)+1+e,{x:y,y:v}=t[p];for(u=f=-1,n=b;n<_;n++)f=.5*Math.abs((y-o)*(t[n].y-v)-(y-t[n].x)*(s-v)),f>u&&(u=f,d=t[n],g=n);a[l++]=d,p=g}return a[l++]=t[c],a}(l,d,u,n,i);break;case\"min-max\":h=function(t,e,i,n){let o,s,a,r,l,c,h,d,u,f,g=0,p=0;const m=[],x=e+i-1,b=t[e].x,_=t[x].x-b;for(o=e;o<e+i;++o){s=t[o],a=(s.x-b)/_*n,r=s.y;const e=0|a;if(e===l)r<u?(u=r,c=o):r>f&&(f=r,h=o),g=(p*g+s.x)/++p;else{const i=o-1;if(!$(c)&&!$(h)){const e=Math.min(c,h),n=Math.max(c,h);e!==d&&e!==i&&m.push({...t[e],x:g}),n!==d&&n!==i&&m.push({...t[n],x:g})}o>0&&i!==d&&m.push(t[i]),m.push(s),l=e,p=0,u=f=r,c=h=d=o}}return m}(l,d,u,n);break;default:throw new Error(`Unsupported decimation algorithm '${i.algorithm}'`)}e._decimated=h}}))},destroy(t){qo(t)}};function Go(t,e,i){const n=function(t){const e=t.options,i=e.fill;let n=K(i&&i.target,i);return void 0===n&&(n=!!e.backgroundColor),!1!==n&&null!==n&&(!0===n?\"origin\":n)}(t);if(U(n))return!isNaN(n.value)&&n;let o=parseFloat(n);return X(o)&&Math.floor(o)===o?(\"-\"!==n[0]&&\"+\"!==n[0]||(o=e+o),!(o===e||o<0||o>=i)&&o):[\"origin\",\"start\",\"end\",\"stack\"].indexOf(n)>=0&&n}class Zo{constructor(t){this.x=t.x,this.y=t.y,this.radius=t.radius}pathSegment(t,e,i){const{x:n,y:o,radius:s}=this;return e=e||{start:0,end:_t},t.arc(n,o,s,e.end,e.start,!0),!i.bounds}interpolate(t){const{x:e,y:i,radius:n}=this,o=t.angle;return{x:e+Math.cos(o)*n,y:i+Math.sin(o)*n,angle:o}}}function Qo(t){return(t.scale||{}).getPointPositionForValue?function(t){const{scale:e,fill:i}=t,n=e.options,o=e.getLabels().length,s=[],a=n.reverse?e.max:e.min,r=n.reverse?e.min:e.max;let l,c,h;if(h=\"start\"===i?a:\"end\"===i?r:U(i)?i.value:e.getBaseValue(),n.grid.circular)return c=e.getPointPositionForValue(0,a),new Zo({x:c.x,y:c.y,radius:e.getDistanceFromCenterForValue(h)});for(l=0;l<o;++l)s.push(e.getPointPositionForValue(l,h));return s}(t):function(t){const{scale:e={},fill:i}=t;let n,o=null;return\"start\"===i?o=e.bottom:\"end\"===i?o=e.top:U(i)?o=e.getPixelForValue(i.value):e.getBasePixel&&(o=e.getBasePixel()),X(o)?(n=e.isHorizontal(),{x:n?o:null,y:n?null:o}):null}(t)}function Jo(t){const{chart:e,scale:i,index:n,line:o}=t,s=[],a=o.segments,r=o.points,l=function(t,e){const i=[],n=t.getSortedVisibleDatasetMetas();for(let t=0;t<n.length;t++){const o=n[t];if(o.index===e)break;ts(o)&&i.unshift(o.dataset)}return i}(e,n);l.push(ns({x:null,y:i.bottom},o));for(let t=0;t<a.length;t++){const e=a[t];for(let t=e.start;t<=e.end;t++)es(s,r[t],l)}return new Eo({points:s,options:{}})}const ts=t=>\"line\"===t.type&&!t.hidden;function es(t,e,i){const n=[];for(let o=0;o<i.length;o++){const s=i[o],{first:a,last:r,point:l}=is(s,e,\"x\");if(!(!l||a&&r))if(a)n.unshift(l);else if(t.push(l),!r)break}t.push(...n)}function is(t,e,i){const n=t.interpolate(e,i);if(!n)return{};const o=n[i],s=t.segments,a=t.points;let r=!1,l=!1;for(let t=0;t<s.length;t++){const e=s[t],n=a[e.start][i],c=a[e.end][i];if(o>=n&&o<=c){r=o===n,l=o===c;break}}return{first:r,last:l,point:n}}function ns(t,e){let i=[],n=!1;return Y(t)?(n=!0,i=t):i=function(t,e){const{x:i=null,y:n=null}=t||{},o=e.points,s=[];return e.segments.forEach((t=>{const e=o[t.start],a=o[t.end];null!==n?(s.push({x:e.x,y:n}),s.push({x:a.x,y:n})):null!==i&&(s.push({x:i,y:e.y}),s.push({x:i,y:a.y}))})),s}(t,e),i.length?new Eo({points:i,options:{tension:0},_loop:n,_fullLoop:n}):null}function os(t,e,i){let n=t[e].fill;const o=[e];let s;if(!i)return n;for(;!1!==n&&-1===o.indexOf(n);){if(!X(n))return n;if(s=t[n],!s)return!1;if(s.visible)return n;o.push(n),n=s.fill}return!1}function ss(t,e,i){t.beginPath(),e.path(t),t.lineTo(e.last().x,i),t.lineTo(e.first().x,i),t.closePath(),t.clip()}function as(t,e,i,n){if(n)return;let o=e[t],s=i[t];return\"angle\"===t&&(o=Wt(o),s=Wt(s)),{property:t,start:o,end:s}}function rs(t,e,i,n){return t&&e?n(t[i],e[i]):t?t[i]:e?e[i]:0}function ls(t,e,i){const{top:n,bottom:o}=e.chart.chartArea,{property:s,start:a,end:r}=i||{};\"x\"===s&&(t.beginPath(),t.rect(a,n,r-a,o-n),t.clip())}function cs(t,e,i,n){const o=e.interpolate(i,n);o&&t.lineTo(o.x,o.y)}function hs(t,e){const{line:i,target:n,property:o,color:s,scale:a}=e,r=function(t,e,i){const n=t.segments,o=t.points,s=e.points,a=[];for(const t of n){const n=as(i,o[t.start],o[t.end],t.loop);if(!e.segments){a.push({source:t,target:n,start:o[t.start],end:o[t.end]});continue}const r=kn(e,n);for(const e of r){const r=as(i,s[e.start],s[e.end],e.loop),l=Mn(t,o,r);for(const t of l)a.push({source:t,target:e,start:{[i]:rs(n,r,\"start\",Math.max)},end:{[i]:rs(n,r,\"end\",Math.min)}})}}return a}(i,n,o);for(const{source:e,target:l,start:c,end:h}of r){const{style:{backgroundColor:r=s}={}}=e;t.save(),t.fillStyle=r,ls(t,a,as(o,c,h)),t.beginPath();const d=!!i.pathSegment(t,e);d?t.closePath():cs(t,n,h,o);const u=!!n.pathSegment(t,l,{move:d,reverse:!0}),f=d&&u;f||cs(t,n,c,o),t.closePath(),t.fill(f?\"evenodd\":\"nonzero\"),t.restore()}}function ds(t,e,i){const n=function(t){const{chart:e,fill:i,line:n}=t;if(X(i))return function(t,e){const i=t.getDatasetMeta(e);return i&&t.isDatasetVisible(e)?i.dataset:null}(e,i);if(\"stack\"===i)return Jo(t);const o=Qo(t);return o instanceof Zo?o:ns(o,n)}(e),{line:o,scale:s,axis:a}=e,r=o.options,l=r.fill,c=r.backgroundColor,{above:h=c,below:d=c}=l||{};n&&o.points.length&&(Zt(t,i),function(t,e){const{line:i,target:n,above:o,below:s,area:a,scale:r}=e,l=i._loop?\"angle\":e.axis;t.save(),\"x\"===l&&s!==o&&(ss(t,n,a.top),hs(t,{line:i,target:n,color:o,scale:r,property:l}),t.restore(),t.save(),ss(t,n,a.bottom)),hs(t,{line:i,target:n,color:s,scale:r,property:l}),t.restore()}(t,{line:o,target:n,above:h,below:d,area:i,scale:s,axis:a}),Qt(t))}var us={id:\"filler\",afterDatasetsUpdate(t,e,i){const n=(t.data.datasets||[]).length,o=[];let s,a,r,l;for(a=0;a<n;++a)s=t.getDatasetMeta(a),r=s.dataset,l=null,r&&r.options&&r instanceof Eo&&(l={visible:t.isDatasetVisible(a),index:a,fill:Go(r,a,n),chart:t,axis:s.controller.options.indexAxis,scale:s.vScale,line:r}),s.$filler=l,o.push(l);for(a=0;a<n;++a)l=o[a],l&&!1!==l.fill&&(l.fill=os(o,a,i.propagate))},beforeDraw(t,e,i){const n=\"beforeDraw\"===i.drawTime,o=t.getSortedVisibleDatasetMetas(),s=t.chartArea;for(let e=o.length-1;e>=0;--e){const i=o[e].$filler;i&&(i.line.updateControlPoints(s,i.axis),n&&ds(t.ctx,i,s))}},beforeDatasetsDraw(t,e,i){if(\"beforeDatasetsDraw\"!==i.drawTime)return;const n=t.getSortedVisibleDatasetMetas();for(let e=n.length-1;e>=0;--e){const i=n[e].$filler;i&&ds(t.ctx,i,t.chartArea)}},beforeDatasetDraw(t,e,i){const n=e.meta.$filler;n&&!1!==n.fill&&\"beforeDatasetDraw\"===i.drawTime&&ds(t.ctx,n,t.chartArea)},defaults:{propagate:!0,drawTime:\"beforeDatasetDraw\"}};const fs=(t,e)=>{let{boxHeight:i=e,boxWidth:n=e}=t;return t.usePointStyle&&(i=Math.min(i,e),n=Math.min(n,e)),{boxWidth:n,boxHeight:i,itemHeight:Math.max(e,i)}};class gs extends Ei{constructor(t){super(),this._added=!1,this.legendHitBoxes=[],this._hoveredItem=null,this.doughnutMode=!1,this.chart=t.chart,this.options=t.options,this.ctx=t.ctx,this.legendItems=void 0,this.columnSizes=void 0,this.lineWidths=void 0,this.maxHeight=void 0,this.maxWidth=void 0,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.height=void 0,this.width=void 0,this._margins=void 0,this.position=void 0,this.weight=void 0,this.fullSize=void 0}update(t,e,i){const n=this;n.maxWidth=t,n.maxHeight=e,n._margins=i,n.setDimensions(),n.buildLabels(),n.fit()}setDimensions(){const t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height)}buildLabels(){const t=this,e=t.options.labels||{};let i=Q(e.generateLabels,[t.chart],t)||[];e.filter&&(i=i.filter((i=>e.filter(i,t.chart.data)))),e.sort&&(i=i.sort(((i,n)=>e.sort(i,n,t.chart.data)))),t.options.reverse&&i.reverse(),t.legendItems=i}fit(){const t=this,{options:e,ctx:i}=t;if(!e.display)return void(t.width=t.height=0);const n=e.labels,o=Fe(n.font),s=o.size,a=t._computeTitleHeight(),{boxWidth:r,itemHeight:l}=fs(n,s);let c,h;i.font=o.string,t.isHorizontal()?(c=t.maxWidth,h=t._fitRows(a,s,r,l)+10):(h=t.maxHeight,c=t._fitCols(a,s,r,l)+10),t.width=Math.min(c,e.maxWidth||t.maxWidth),t.height=Math.min(h,e.maxHeight||t.maxHeight)}_fitRows(t,e,i,n){const o=this,{ctx:s,maxWidth:a,options:{labels:{padding:r}}}=o,l=o.legendHitBoxes=[],c=o.lineWidths=[0],h=n+r;let d=t;s.textAlign=\"left\",s.textBaseline=\"middle\";let u=-1,f=-h;return o.legendItems.forEach(((t,o)=>{const g=i+e/2+s.measureText(t.text).width;(0===o||c[c.length-1]+g+2*r>a)&&(d+=h,c[c.length-(o>0?0:1)]=0,f+=h,u++),l[o]={left:0,top:f,row:u,width:g,height:n},c[c.length-1]+=g+r})),d}_fitCols(t,e,i,n){const o=this,{ctx:s,maxHeight:a,options:{labels:{padding:r}}}=o,l=o.legendHitBoxes=[],c=o.columnSizes=[],h=a-t;let d=r,u=0,f=0,g=0,p=0,m=0;return o.legendItems.forEach(((t,o)=>{const a=i+e/2+s.measureText(t.text).width;o>0&&f+e+2*r>h&&(d+=u+r,c.push({width:u,height:f}),g+=u+r,m++,p=0,u=f=0),u=Math.max(u,a),f+=e+r,l[o]={left:g,top:p,col:m,width:a,height:n},p+=n+r})),d+=u,c.push({width:u,height:f}),d}adjustHitBoxes(){const t=this;if(!t.options.display)return;const e=t._computeTitleHeight(),{legendHitBoxes:i,options:{align:n,labels:{padding:s}}}=t;if(this.isHorizontal()){let a=0,r=o(n,t.left+s,t.right-t.lineWidths[a]);for(const l of i)a!==l.row&&(a=l.row,r=o(n,t.left+s,t.right-t.lineWidths[a])),l.top+=t.top+e+s,l.left=r,r+=l.width+s}else{let a=0,r=o(n,t.top+e+s,t.bottom-t.columnSizes[a].height);for(const l of i)l.col!==a&&(a=l.col,r=o(n,t.top+e+s,t.bottom-t.columnSizes[a].height)),l.top=r,l.left+=t.left+s,r+=l.height+s}}isHorizontal(){return\"top\"===this.options.position||\"bottom\"===this.options.position}draw(){const t=this;if(t.options.display){const e=t.ctx;Zt(e,t),t._draw(),Qt(e)}}_draw(){const t=this,{options:e,columnSizes:i,lineWidths:n,ctx:a}=t,{align:r,labels:l}=e,c=xt.color,h=bn(e.rtl,t.left,t.width),d=Fe(l.font),{color:u,padding:f}=l,g=d.size,p=g/2;let m;t.drawTitle(),a.textAlign=h.textAlign(\"left\"),a.textBaseline=\"middle\",a.lineWidth=.5,a.font=d.string;const{boxWidth:x,boxHeight:b,itemHeight:_}=fs(l,g),y=t.isHorizontal(),v=this._computeTitleHeight();m=y?{x:o(r,t.left+f,t.right-n[0]),y:t.top+f+v,line:0}:{x:t.left+f,y:o(r,t.top+v+f,t.bottom-i[0].height),line:0},_n(t.ctx,e.textDirection);const w=_+f;t.legendItems.forEach(((e,M)=>{a.strokeStyle=e.fontColor||u,a.fillStyle=e.fontColor||u;const k=a.measureText(e.text).width,S=h.textAlign(e.textAlign||(e.textAlign=l.textAlign)),P=x+g/2+k;let D=m.x,C=m.y;h.setWidth(t.width),y?M>0&&D+P+f>t.right&&(C=m.y+=w,m.line++,D=m.x=o(r,t.left+f,t.right-n[m.line])):M>0&&C+w>t.bottom&&(D=m.x=D+i[m.line].width+f,m.line++,C=m.y=o(r,t.top+v+f,t.bottom-i[m.line].height));!function(t,e,i){if(isNaN(x)||x<=0||isNaN(b)||b<0)return;a.save();const n=K(i.lineWidth,1);if(a.fillStyle=K(i.fillStyle,c),a.lineCap=K(i.lineCap,\"butt\"),a.lineDashOffset=K(i.lineDashOffset,0),a.lineJoin=K(i.lineJoin,\"miter\"),a.lineWidth=n,a.strokeStyle=K(i.strokeStyle,c),a.setLineDash(K(i.lineDash,[])),l.usePointStyle){const o={radius:x*Math.SQRT2/2,pointStyle:i.pointStyle,rotation:i.rotation,borderWidth:n},s=h.xPlus(t,x/2);Kt(a,o,s,e+p)}else{const o=e+Math.max((g-b)/2,0),s=h.leftForLtr(t,x),r=Ie(i.borderRadius);a.beginPath(),Object.values(r).some((t=>0!==t))?ie(a,{x:s,y:o,w:x,h:b,radius:r}):a.rect(s,o,x,b),a.fill(),0!==n&&a.stroke()}a.restore()}(h.x(D),C,e),D=s(S,D+x+p,t.right),function(t,e,i){ee(a,i.text,t,e+_/2,d,{strikethrough:i.hidden,textAlign:i.textAlign})}(h.x(D),C,e),y?m.x+=P+f:m.y+=w})),yn(t.ctx,e.textDirection)}drawTitle(){const t=this,e=t.options,i=e.title,s=Fe(i.font),a=ze(i.padding);if(!i.display)return;const r=bn(e.rtl,t.left,t.width),l=t.ctx,c=i.position,h=s.size/2,d=a.top+h;let u,f=t.left,g=t.width;if(this.isHorizontal())g=Math.max(...t.lineWidths),u=t.top+d,f=o(e.align,f,t.right-g);else{const i=t.columnSizes.reduce(((t,e)=>Math.max(t,e.height)),0);u=d+o(e.align,t.top,t.bottom-i-e.labels.padding-t._computeTitleHeight())}const p=o(c,f,f+g);l.textAlign=r.textAlign(n(c)),l.textBaseline=\"middle\",l.strokeStyle=i.color,l.fillStyle=i.color,l.font=s.string,ee(l,i.text,p,u,s)}_computeTitleHeight(){const t=this.options.title,e=Fe(t.font),i=ze(t.padding);return t.display?e.lineHeight+i.height:0}_getLegendItemAt(t,e){const i=this;let n,o,s;if(t>=i.left&&t<=i.right&&e>=i.top&&e<=i.bottom)for(s=i.legendHitBoxes,n=0;n<s.length;++n)if(o=s[n],t>=o.left&&t<=o.left+o.width&&e>=o.top&&e<=o.top+o.height)return i.legendItems[n];return null}handleEvent(t){const e=this,i=e.options;if(!function(t,e){if(\"mousemove\"===t&&(e.onHover||e.onLeave))return!0;if(e.onClick&&(\"click\"===t||\"mouseup\"===t))return!0;return!1}(t.type,i))return;const n=e._getLegendItemAt(t.x,t.y);if(\"mousemove\"===t.type){const a=e._hoveredItem,r=(s=n,null!==(o=a)&&null!==s&&o.datasetIndex===s.datasetIndex&&o.index===s.index);a&&!r&&Q(i.onLeave,[t,a,e],e),e._hoveredItem=n,n&&!r&&Q(i.onHover,[t,n,e],e)}else n&&Q(i.onClick,[t,n,e],e);var o,s}}var ps={id:\"legend\",_element:gs,start(t,e,i){const n=t.legend=new gs({ctx:t.ctx,options:i,chart:t});Ge.configure(t,n,i),Ge.addBox(t,n)},stop(t){Ge.removeBox(t,t.legend),delete t.legend},beforeUpdate(t,e,i){const n=t.legend;Ge.configure(t,n,i),n.options=i},afterUpdate(t){const e=t.legend;e.buildLabels(),e.adjustHitBoxes()},afterEvent(t,e){e.replay||t.legend.handleEvent(e.event)},defaults:{display:!0,position:\"top\",align:\"center\",fullSize:!0,reverse:!1,weight:1e3,onClick(t,e,i){const n=e.datasetIndex,o=i.chart;o.isDatasetVisible(n)?(o.hide(n),e.hidden=!0):(o.show(n),e.hidden=!1)},onHover:null,onLeave:null,labels:{color:t=>t.chart.options.color,boxWidth:40,padding:10,generateLabels(t){const e=t.data.datasets,{labels:{usePointStyle:i,pointStyle:n,textAlign:o,color:s}}=t.legend.options;return t._getSortedDatasetMetas().map((t=>{const a=t.controller.getStyle(i?0:void 0),r=ze(a.borderWidth);return{text:e[t.index].label,fillStyle:a.backgroundColor,fontColor:s,hidden:!t.visible,lineCap:a.borderCapStyle,lineDash:a.borderDash,lineDashOffset:a.borderDashOffset,lineJoin:a.borderJoinStyle,lineWidth:(r.width+r.height)/4,strokeStyle:a.borderColor,pointStyle:n||a.pointStyle,rotation:a.rotation,textAlign:o||a.textAlign,borderRadius:0,datasetIndex:t.index}}),this)}},title:{color:t=>t.chart.options.color,display:!1,position:\"center\",text:\"\"}},descriptors:{_scriptable:t=>!t.startsWith(\"on\"),labels:{_scriptable:t=>![\"generateLabels\",\"filter\",\"sort\"].includes(t)}}};class ms extends Ei{constructor(t){super(),this.chart=t.chart,this.options=t.options,this.ctx=t.ctx,this._padding=void 0,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.width=void 0,this.height=void 0,this.position=void 0,this.weight=void 0,this.fullSize=void 0}update(t,e){const i=this,n=i.options;if(i.left=0,i.top=0,!n.display)return void(i.width=i.height=i.right=i.bottom=0);i.width=i.right=t,i.height=i.bottom=e;const o=Y(n.text)?n.text.length:1;i._padding=ze(n.padding);const s=o*Fe(n.font).lineHeight+i._padding.height;i.isHorizontal()?i.height=s:i.width=s}isHorizontal(){const t=this.options.position;return\"top\"===t||\"bottom\"===t}_drawArgs(t){const{top:e,left:i,bottom:n,right:s,options:a}=this,r=a.align;let l,c,h,d=0;return this.isHorizontal()?(c=o(r,i,s),h=e+t,l=s-i):(\"left\"===a.position?(c=i+t,h=o(r,n,e),d=-.5*bt):(c=s-t,h=o(r,e,n),d=.5*bt),l=n-e),{titleX:c,titleY:h,maxWidth:l,rotation:d}}draw(){const t=this,e=t.ctx,i=t.options;if(!i.display)return;const o=Fe(i.font),s=o.lineHeight/2+t._padding.top,{titleX:a,titleY:r,maxWidth:l,rotation:c}=t._drawArgs(s);ee(e,i.text,0,0,o,{color:i.color,maxWidth:l,rotation:c,textAlign:n(i.align),textBaseline:\"middle\",translation:[a,r]})}}var xs={id:\"title\",_element:ms,start(t,e,i){!function(t,e){const i=new ms({ctx:t.ctx,options:e,chart:t});Ge.configure(t,i,e),Ge.addBox(t,i),t.titleBlock=i}(t,i)},stop(t){const e=t.titleBlock;Ge.removeBox(t,e),delete t.titleBlock},beforeUpdate(t,e,i){const n=t.titleBlock;Ge.configure(t,n,i),n.options=i},defaults:{align:\"center\",display:!1,font:{weight:\"bold\"},fullSize:!0,padding:10,position:\"top\",text:\"\",weight:2e3},defaultRoutes:{color:\"color\"},descriptors:{_scriptable:!0,_indexable:!1}};const bs={average(t){if(!t.length)return!1;let e,i,n=0,o=0,s=0;for(e=0,i=t.length;e<i;++e){const i=t[e].element;if(i&&i.hasValue()){const t=i.tooltipPosition();n+=t.x,o+=t.y,++s}}return{x:n/s,y:o/s}},nearest(t,e){if(!t.length)return!1;let i,n,o,s=e.x,a=e.y,r=Number.POSITIVE_INFINITY;for(i=0,n=t.length;i<n;++i){const n=t[i].element;if(n&&n.hasValue()){const t=Vt(e,n.getCenterPoint());t<r&&(r=t,o=n)}}if(o){const t=o.tooltipPosition();s=t.x,a=t.y}return{x:s,y:a}}};function _s(t,e){return e&&(Y(e)?Array.prototype.push.apply(t,e):t.push(e)),t}function ys(t){return(\"string\"==typeof t||t instanceof String)&&t.indexOf(\"\\n\")>-1?t.split(\"\\n\"):t}function vs(t,e){const{element:i,datasetIndex:n,index:o}=e,s=t.getDatasetMeta(n).controller,{label:a,value:r}=s.getLabelAndValue(o);return{chart:t,label:a,parsed:s.getParsed(o),raw:t.data.datasets[n].data[o],formattedValue:r,dataset:s.getDataset(),dataIndex:o,datasetIndex:n,element:i}}function ws(t,e){const i=t._chart.ctx,{body:n,footer:o,title:s}=t,{boxWidth:a,boxHeight:r}=e,l=Fe(e.bodyFont),c=Fe(e.titleFont),h=Fe(e.footerFont),d=s.length,u=o.length,f=n.length,g=ze(e.padding);let p=g.height,m=0,x=n.reduce(((t,e)=>t+e.before.length+e.lines.length+e.after.length),0);if(x+=t.beforeBody.length+t.afterBody.length,d&&(p+=d*c.lineHeight+(d-1)*e.titleSpacing+e.titleMarginBottom),x){p+=f*(e.displayColors?Math.max(r,l.lineHeight):l.lineHeight)+(x-f)*l.lineHeight+(x-1)*e.bodySpacing}u&&(p+=e.footerMarginTop+u*h.lineHeight+(u-1)*e.footerSpacing);let b=0;const _=function(t){m=Math.max(m,i.measureText(t).width+b)};return i.save(),i.font=c.string,J(t.title,_),i.font=l.string,J(t.beforeBody.concat(t.afterBody),_),b=e.displayColors?a+2:0,J(n,(t=>{J(t.before,_),J(t.lines,_),J(t.after,_)})),b=0,i.font=h.string,J(t.footer,_),i.restore(),m+=g.width,{width:m,height:p}}function Ms(t,e,i,n){const{x:o,width:s}=i,{width:a,chartArea:{left:r,right:l}}=t;let c=\"center\";return\"center\"===n?c=o<=(r+l)/2?\"left\":\"right\":o<=s/2?c=\"left\":o>=a-s/2&&(c=\"right\"),function(t,e,i,n){const{x:o,width:s}=n,a=i.caretSize+i.caretPadding;return\"left\"===t&&o+s+a>e.width||\"right\"===t&&o-s-a<0||void 0}(c,t,e,i)&&(c=\"center\"),c}function ks(t,e,i){const n=e.yAlign||function(t,e){const{y:i,height:n}=e;return i<n/2?\"top\":i>t.height-n/2?\"bottom\":\"center\"}(t,i);return{xAlign:e.xAlign||Ms(t,e,i,n),yAlign:n}}function Ss(t,e,i,n){const{caretSize:o,caretPadding:s,cornerRadius:a}=t,{xAlign:r,yAlign:l}=i,c=o+s,h=a+s;let d=function(t,e){let{x:i,width:n}=t;return\"right\"===e?i-=n:\"center\"===e&&(i-=n/2),i}(e,r);const u=function(t,e,i){let{y:n,height:o}=t;return\"top\"===e?n+=i:n-=\"bottom\"===e?o+i:o/2,n}(e,l,c);return\"center\"===l?\"left\"===r?d+=c:\"right\"===r&&(d-=c):\"left\"===r?d-=h:\"right\"===r&&(d+=h),{x:Nt(d,0,n.width-e.width),y:Nt(u,0,n.height-e.height)}}function Ps(t,e,i){const n=ze(i.padding);return\"center\"===e?t.x+t.width/2:\"right\"===e?t.x+t.width-n.right:t.x+n.left}function Ds(t){return _s([],ys(t))}function Cs(t,e){const i=e&&e.dataset&&e.dataset.tooltip&&e.dataset.tooltip.callbacks;return i?t.override(i):t}class Os extends Ei{constructor(t){super(),this.opacity=0,this._active=[],this._chart=t._chart,this._eventPosition=void 0,this._size=void 0,this._cachedAnimations=void 0,this._tooltipItems=[],this.$animations=void 0,this.$context=void 0,this.options=t.options,this.dataPoints=void 0,this.title=void 0,this.beforeBody=void 0,this.body=void 0,this.afterBody=void 0,this.footer=void 0,this.xAlign=void 0,this.yAlign=void 0,this.x=void 0,this.y=void 0,this.height=void 0,this.width=void 0,this.caretX=void 0,this.caretY=void 0,this.labelColors=void 0,this.labelPointStyles=void 0,this.labelTextColors=void 0}initialize(t){this.options=t,this._cachedAnimations=void 0,this.$context=void 0}_resolveAnimations(){const t=this,e=t._cachedAnimations;if(e)return e;const i=t._chart,n=t.options.setContext(t.getContext()),o=n.enabled&&i.options.animation&&n.animations,s=new vi(t._chart,o);return o._cacheable&&(t._cachedAnimations=Object.freeze(s)),s}getContext(){const t=this;return t.$context||(t.$context=(e=t._chart.getContext(),i=t,n=t._tooltipItems,Object.assign(Object.create(e),{tooltip:i,tooltipItems:n,type:\"tooltip\"})));var e,i,n}getTitle(t,e){const i=this,{callbacks:n}=e,o=n.beforeTitle.apply(i,[t]),s=n.title.apply(i,[t]),a=n.afterTitle.apply(i,[t]);let r=[];return r=_s(r,ys(o)),r=_s(r,ys(s)),r=_s(r,ys(a)),r}getBeforeBody(t,e){return Ds(e.callbacks.beforeBody.apply(this,[t]))}getBody(t,e){const i=this,{callbacks:n}=e,o=[];return J(t,(t=>{const e={before:[],lines:[],after:[]},s=Cs(n,t);_s(e.before,ys(s.beforeLabel.call(i,t))),_s(e.lines,s.label.call(i,t)),_s(e.after,ys(s.afterLabel.call(i,t))),o.push(e)})),o}getAfterBody(t,e){return Ds(e.callbacks.afterBody.apply(this,[t]))}getFooter(t,e){const i=this,{callbacks:n}=e,o=n.beforeFooter.apply(i,[t]),s=n.footer.apply(i,[t]),a=n.afterFooter.apply(i,[t]);let r=[];return r=_s(r,ys(o)),r=_s(r,ys(s)),r=_s(r,ys(a)),r}_createItems(t){const e=this,i=e._active,n=e._chart.data,o=[],s=[],a=[];let r,l,c=[];for(r=0,l=i.length;r<l;++r)c.push(vs(e._chart,i[r]));return t.filter&&(c=c.filter(((e,i,o)=>t.filter(e,i,o,n)))),t.itemSort&&(c=c.sort(((e,i)=>t.itemSort(e,i,n)))),J(c,(i=>{const n=Cs(t.callbacks,i);o.push(n.labelColor.call(e,i)),s.push(n.labelPointStyle.call(e,i)),a.push(n.labelTextColor.call(e,i))})),e.labelColors=o,e.labelPointStyles=s,e.labelTextColors=a,e.dataPoints=c,c}update(t,e){const i=this,n=i.options.setContext(i.getContext()),o=i._active;let s,a=[];if(o.length){const t=bs[n.position].call(i,o,i._eventPosition);a=i._createItems(n),i.title=i.getTitle(a,n),i.beforeBody=i.getBeforeBody(a,n),i.body=i.getBody(a,n),i.afterBody=i.getAfterBody(a,n),i.footer=i.getFooter(a,n);const e=i._size=ws(i,n),r=Object.assign({},t,e),l=ks(i._chart,n,r),c=Ss(n,r,l,i._chart);i.xAlign=l.xAlign,i.yAlign=l.yAlign,s={opacity:1,x:c.x,y:c.y,width:e.width,height:e.height,caretX:t.x,caretY:t.y}}else 0!==i.opacity&&(s={opacity:0});i._tooltipItems=a,i.$context=void 0,s&&i._resolveAnimations().update(i,s),t&&n.external&&n.external.call(i,{chart:i._chart,tooltip:i,replay:e})}drawCaret(t,e,i,n){const o=this.getCaretPosition(t,i,n);e.lineTo(o.x1,o.y1),e.lineTo(o.x2,o.y2),e.lineTo(o.x3,o.y3)}getCaretPosition(t,e,i){const{xAlign:n,yAlign:o}=this,{cornerRadius:s,caretSize:a}=i,{x:r,y:l}=t,{width:c,height:h}=e;let d,u,f,g,p,m;return\"center\"===o?(p=l+h/2,\"left\"===n?(d=r,u=d-a,g=p+a,m=p-a):(d=r+c,u=d+a,g=p-a,m=p+a),f=d):(u=\"left\"===n?r+s+a:\"right\"===n?r+c-s-a:this.caretX,\"top\"===o?(g=l,p=g-a,d=u-a,f=u+a):(g=l+h,p=g+a,d=u+a,f=u-a),m=g),{x1:d,x2:u,x3:f,y1:g,y2:p,y3:m}}drawTitle(t,e,i){const n=this,o=n.title,s=o.length;let a,r,l;if(s){const c=bn(i.rtl,n.x,n.width);for(t.x=Ps(n,i.titleAlign,i),e.textAlign=c.textAlign(i.titleAlign),e.textBaseline=\"middle\",a=Fe(i.titleFont),r=i.titleSpacing,e.fillStyle=i.titleColor,e.font=a.string,l=0;l<s;++l)e.fillText(o[l],c.x(t.x),t.y+a.lineHeight/2),t.y+=a.lineHeight+r,l+1===s&&(t.y+=i.titleMarginBottom-r)}}_drawColorBox(t,e,i,n,o){const s=this,a=s.labelColors[i],r=s.labelPointStyles[i],{boxHeight:l,boxWidth:c}=o,h=Fe(o.bodyFont),d=Ps(s,\"left\",o),u=n.x(d),f=l<h.lineHeight?(h.lineHeight-l)/2:0,g=e.y+f;if(o.usePointStyle){const e={radius:Math.min(c,l)/2,pointStyle:r.pointStyle,rotation:r.rotation,borderWidth:1},i=n.leftForLtr(u,c)+c/2,s=g+l/2;t.strokeStyle=o.multiKeyBackground,t.fillStyle=o.multiKeyBackground,Kt(t,e,i,s),t.strokeStyle=a.borderColor,t.fillStyle=a.backgroundColor,Kt(t,e,i,s)}else{t.lineWidth=a.borderWidth||1,t.strokeStyle=a.borderColor,t.setLineDash(a.borderDash||[]),t.lineDashOffset=a.borderDashOffset||0;const e=n.leftForLtr(u,c),i=n.leftForLtr(n.xPlus(u,1),c-2),s=Ie(a.borderRadius);Object.values(s).some((t=>0!==t))?(t.beginPath(),t.fillStyle=o.multiKeyBackground,ie(t,{x:e,y:g,w:c,h:l,radius:s}),t.fill(),t.stroke(),t.fillStyle=a.backgroundColor,t.beginPath(),ie(t,{x:i,y:g+1,w:c-2,h:l-2,radius:s}),t.fill()):(t.fillStyle=o.multiKeyBackground,t.fillRect(e,g,c,l),t.strokeRect(e,g,c,l),t.fillStyle=a.backgroundColor,t.fillRect(i,g+1,c-2,l-2))}t.fillStyle=s.labelTextColors[i]}drawBody(t,e,i){const n=this,{body:o}=n,{bodySpacing:s,bodyAlign:a,displayColors:r,boxHeight:l,boxWidth:c}=i,h=Fe(i.bodyFont);let d=h.lineHeight,u=0;const f=bn(i.rtl,n.x,n.width),g=function(i){e.fillText(i,f.x(t.x+u),t.y+d/2),t.y+=d+s},p=f.textAlign(a);let m,x,b,_,y,v,w;for(e.textAlign=a,e.textBaseline=\"middle\",e.font=h.string,t.x=Ps(n,p,i),e.fillStyle=i.bodyColor,J(n.beforeBody,g),u=r&&\"right\"!==p?\"center\"===a?c/2+1:c+2:0,_=0,v=o.length;_<v;++_){for(m=o[_],x=n.labelTextColors[_],e.fillStyle=x,J(m.before,g),b=m.lines,r&&b.length&&(n._drawColorBox(e,t,_,f,i),d=Math.max(h.lineHeight,l)),y=0,w=b.length;y<w;++y)g(b[y]),d=h.lineHeight;J(m.after,g)}u=0,d=h.lineHeight,J(n.afterBody,g),t.y-=s}drawFooter(t,e,i){const n=this,o=n.footer,s=o.length;let a,r;if(s){const l=bn(i.rtl,n.x,n.width);for(t.x=Ps(n,i.footerAlign,i),t.y+=i.footerMarginTop,e.textAlign=l.textAlign(i.footerAlign),e.textBaseline=\"middle\",a=Fe(i.footerFont),e.fillStyle=i.footerColor,e.font=a.string,r=0;r<s;++r)e.fillText(o[r],l.x(t.x),t.y+a.lineHeight/2),t.y+=a.lineHeight+i.footerSpacing}}drawBackground(t,e,i,n){const{xAlign:o,yAlign:s}=this,{x:a,y:r}=t,{width:l,height:c}=i,h=n.cornerRadius;e.fillStyle=n.backgroundColor,e.strokeStyle=n.borderColor,e.lineWidth=n.borderWidth,e.beginPath(),e.moveTo(a+h,r),\"top\"===s&&this.drawCaret(t,e,i,n),e.lineTo(a+l-h,r),e.quadraticCurveTo(a+l,r,a+l,r+h),\"center\"===s&&\"right\"===o&&this.drawCaret(t,e,i,n),e.lineTo(a+l,r+c-h),e.quadraticCurveTo(a+l,r+c,a+l-h,r+c),\"bottom\"===s&&this.drawCaret(t,e,i,n),e.lineTo(a+h,r+c),e.quadraticCurveTo(a,r+c,a,r+c-h),\"center\"===s&&\"left\"===o&&this.drawCaret(t,e,i,n),e.lineTo(a,r+h),e.quadraticCurveTo(a,r,a+h,r),e.closePath(),e.fill(),n.borderWidth>0&&e.stroke()}_updateAnimationTarget(t){const e=this,i=e._chart,n=e.$animations,o=n&&n.x,s=n&&n.y;if(o||s){const n=bs[t.position].call(e,e._active,e._eventPosition);if(!n)return;const a=e._size=ws(e,t),r=Object.assign({},n,e._size),l=ks(i,t,r),c=Ss(t,r,l,i);o._to===c.x&&s._to===c.y||(e.xAlign=l.xAlign,e.yAlign=l.yAlign,e.width=a.width,e.height=a.height,e.caretX=n.x,e.caretY=n.y,e._resolveAnimations().update(e,c))}}draw(t){const e=this,i=e.options.setContext(e.getContext());let n=e.opacity;if(!n)return;e._updateAnimationTarget(i);const o={width:e.width,height:e.height},s={x:e.x,y:e.y};n=Math.abs(n)<.001?0:n;const a=ze(i.padding),r=e.title.length||e.beforeBody.length||e.body.length||e.afterBody.length||e.footer.length;i.enabled&&r&&(t.save(),t.globalAlpha=n,e.drawBackground(s,t,o,i),_n(t,i.textDirection),s.y+=a.top,e.drawTitle(s,t,i),e.drawBody(s,t,i),e.drawFooter(s,t,i),yn(t,i.textDirection),t.restore())}getActiveElements(){return this._active||[]}setActiveElements(t,e){const i=this,n=i._active,o=t.map((({datasetIndex:t,index:e})=>{const n=i._chart.getDatasetMeta(t);if(!n)throw new Error(\"Cannot find a dataset at index \"+t);return{datasetIndex:t,element:n.data[e],index:e}})),s=!tt(n,o),a=i._positionChanged(o,e);(s||a)&&(i._active=o,i._eventPosition=e,i.update(!0))}handleEvent(t,e){const i=this,n=i.options,o=i._active||[];let s=!1,a=[];\"mouseout\"!==t.type&&(a=i._chart.getElementsAtEventForMode(t,n.mode,n,e),n.reverse&&a.reverse());const r=i._positionChanged(a,t);return s=e||!tt(a,o)||r,s&&(i._active=a,(n.enabled||n.external)&&(i._eventPosition={x:t.x,y:t.y},i.update(!0,e))),s}_positionChanged(t,e){const{caretX:i,caretY:n,options:o}=this,s=bs[o.position].call(this,t,e);return!1!==s&&(i!==s.x||n!==s.y)}}Os.positioners=bs;var Ts={id:\"tooltip\",_element:Os,positioners:bs,afterInit(t,e,i){i&&(t.tooltip=new Os({_chart:t,options:i}))},beforeUpdate(t,e,i){t.tooltip&&t.tooltip.initialize(i)},reset(t,e,i){t.tooltip&&t.tooltip.initialize(i)},afterDraw(t){const e=t.tooltip,i={tooltip:e};!1!==t.notifyPlugins(\"beforeTooltipDraw\",i)&&(e&&e.draw(t.ctx),t.notifyPlugins(\"afterTooltipDraw\",i))},afterEvent(t,e){if(t.tooltip){const i=e.replay;t.tooltip.handleEvent(e.event,i)&&(e.changed=!0)}},defaults:{enabled:!0,external:null,position:\"average\",backgroundColor:\"rgba(0,0,0,0.8)\",titleColor:\"#fff\",titleFont:{weight:\"bold\"},titleSpacing:2,titleMarginBottom:6,titleAlign:\"left\",bodyColor:\"#fff\",bodySpacing:2,bodyFont:{},bodyAlign:\"left\",footerColor:\"#fff\",footerSpacing:2,footerMarginTop:6,footerFont:{weight:\"bold\"},footerAlign:\"left\",padding:6,caretPadding:2,caretSize:5,cornerRadius:6,boxHeight:(t,e)=>e.bodyFont.size,boxWidth:(t,e)=>e.bodyFont.size,multiKeyBackground:\"#fff\",displayColors:!0,borderColor:\"rgba(0,0,0,0)\",borderWidth:0,animation:{duration:400,easing:\"easeOutQuart\"},animations:{numbers:{type:\"number\",properties:[\"x\",\"y\",\"width\",\"height\",\"caretX\",\"caretY\"]},opacity:{easing:\"linear\",duration:200}},callbacks:{beforeTitle:N,title(t){if(t.length>0){const e=t[0],i=e.chart.data.labels,n=i?i.length:0;if(this&&this.options&&\"dataset\"===this.options.mode)return e.dataset.label||\"\";if(e.label)return e.label;if(n>0&&e.dataIndex<n)return i[e.dataIndex]}return\"\"},afterTitle:N,beforeBody:N,beforeLabel:N,label(t){if(this&&this.options&&\"dataset\"===this.options.mode)return t.label+\": \"+t.formattedValue||t.formattedValue;let e=t.dataset.label||\"\";e&&(e+=\": \");const i=t.formattedValue;return $(i)||(e+=i),e},labelColor(t){const e=t.chart.getDatasetMeta(t.datasetIndex).controller.getStyle(t.dataIndex);return{borderColor:e.borderColor,backgroundColor:e.backgroundColor,borderWidth:e.borderWidth,borderDash:e.borderDash,borderDashOffset:e.borderDashOffset,borderRadius:0}},labelTextColor(){return this.options.bodyColor},labelPointStyle(t){const e=t.chart.getDatasetMeta(t.datasetIndex).controller.getStyle(t.dataIndex);return{pointStyle:e.pointStyle,rotation:e.rotation}},afterLabel:N,afterBody:N,beforeFooter:N,footer:N,afterFooter:N}},defaultRoutes:{bodyFont:\"font\",footerFont:\"font\",titleFont:\"font\"},descriptors:{_scriptable:t=>\"filter\"!==t&&\"itemSort\"!==t&&\"external\"!==t,_indexable:!1,callbacks:{_scriptable:!1,_indexable:!1},animation:{_fallback:!1},animations:{_fallback:\"animation\"}},additionalOptionScopes:[\"interaction\"]},As=Object.freeze({__proto__:null,Decimation:Ko,Filler:us,Legend:ps,Title:xs,Tooltip:Ts});function Ls(t,e,i){const n=t.indexOf(e);if(-1===n)return((t,e,i)=>\"string\"==typeof e?t.push(e)-1:isNaN(e)?null:i)(t,e,i);return n!==t.lastIndexOf(e)?i:n}class Rs extends Xi{constructor(t){super(t),this._startValue=void 0,this._valueRange=0}parse(t,e){if($(t))return null;const i=this.getLabels();return((t,e)=>null===t?null:Nt(Math.round(t),0,e))(e=isFinite(e)&&i[e]===t?e:Ls(i,t,K(e,t)),i.length-1)}determineDataLimits(){const t=this,{minDefined:e,maxDefined:i}=t.getUserBounds();let{min:n,max:o}=t.getMinMax(!0);\"ticks\"===t.options.bounds&&(e||(n=0),i||(o=t.getLabels().length-1)),t.min=n,t.max=o}buildTicks(){const t=this,e=t.min,i=t.max,n=t.options.offset,o=[];let s=t.getLabels();s=0===e&&i===s.length-1?s:s.slice(e,i+1),t._valueRange=Math.max(s.length-(n?0:1),1),t._startValue=t.min-(n?.5:0);for(let t=e;t<=i;t++)o.push({value:t});return o}getLabelForValue(t){const e=this.getLabels();return t>=0&&t<e.length?e[t]:t}configure(){const t=this;super.configure(),t.isHorizontal()||(t._reversePixels=!t._reversePixels)}getPixelForValue(t){const e=this;return\"number\"!=typeof t&&(t=e.parse(t)),null===t?NaN:e.getPixelForDecimal((t-e._startValue)/e._valueRange)}getPixelForTick(t){const e=this.ticks;return t<0||t>e.length-1?null:this.getPixelForValue(e[t].value)}getValueForPixel(t){const e=this;return Math.round(e._startValue+e.getDecimalForPixel(t)*e._valueRange)}getBasePixel(){return this.bottom}}function Es(t,e,{horizontal:i,minRotation:n}){const o=Et(n),s=(i?Math.sin(o):Math.cos(o))||.001,a=.75*e*(\"\"+t).length;return Math.min(e/s,a)}Rs.id=\"category\",Rs.defaults={ticks:{callback:Rs.prototype.getLabelForValue}};class Is extends Xi{constructor(t){super(t),this.start=void 0,this.end=void 0,this._startValue=void 0,this._endValue=void 0,this._valueRange=0}parse(t,e){return $(t)||(\"number\"==typeof t||t instanceof Number)&&!isFinite(+t)?null:+t}handleTickRangeOptions(){const t=this,{beginAtZero:e}=t.options,{minDefined:i,maxDefined:n}=t.getUserBounds();let{min:o,max:s}=t;const a=t=>o=i?o:t,r=t=>s=n?s:t;if(e){const t=Dt(o),e=Dt(s);t<0&&e<0?r(0):t>0&&e>0&&a(0)}o===s&&(r(s+1),e||a(o-1)),t.min=o,t.max=s}getTickLimit(){const t=this,e=t.options.ticks;let i,{maxTicksLimit:n,stepSize:o}=e;return o?i=Math.ceil(t.max/o)-Math.floor(t.min/o)+1:(i=t.computeTickLimit(),n=n||11),n&&(i=Math.min(n,i)),i}computeTickLimit(){return Number.POSITIVE_INFINITY}buildTicks(){const t=this,e=t.options,i=e.ticks;let n=t.getTickLimit();n=Math.max(2,n);const o=function(t,e){const i=[],{bounds:n,step:o,min:s,max:a,precision:r,count:l,maxTicks:c,maxDigits:h,includeBounds:d}=t,u=o||1,f=c-1,{min:g,max:p}=e,m=!$(s),x=!$(a),b=!$(l),_=(p-g)/(h+1);let y,v,w,M,k=Ct((p-g)/f/u)*u;if(k<1e-14&&!m&&!x)return[{value:g},{value:p}];M=Math.ceil(p/k)-Math.floor(g/k),M>f&&(k=Ct(M*k/f/u)*u),$(r)||(y=Math.pow(10,r),k=Math.ceil(k*y)/y),\"ticks\"===n?(v=Math.floor(g/k)*k,w=Math.ceil(p/k)*k):(v=g,w=p),m&&x&&o&&Lt((a-s)/o,k/1e3)?(M=Math.min((a-s)/k,c),k=(a-s)/M,v=s,w=a):b?(v=m?s:v,w=x?a:w,M=l-1,k=(w-v)/M):(M=(w-v)/k,M=At(M,Math.round(M),k/1e3)?Math.round(M):Math.ceil(M));const S=Math.max(zt(k),zt(v));y=Math.pow(10,$(r)?S:r),v=Math.round(v*y)/y,w=Math.round(w*y)/y;let P=0;for(m&&(d&&v!==s?(i.push({value:s}),v<s&&P++,At(Math.round((v+P*k)*y)/y,s,Es(s,_,t))&&P++):v<s&&P++);P<M;++P)i.push({value:Math.round((v+P*k)*y)/y});return x&&d&&w!==a?At(i[i.length-1].value,a,Es(a,_,t))?i[i.length-1].value=a:i.push({value:a}):x&&w!==a||i.push({value:w}),i}({maxTicks:n,bounds:e.bounds,min:e.min,max:e.max,precision:i.precision,step:i.stepSize,count:i.count,maxDigits:t._maxDigits(),horizontal:t.isHorizontal(),minRotation:i.minRotation||0,includeBounds:!1!==i.includeBounds},t._range||t);return\"ticks\"===e.bounds&&Rt(o,t,\"value\"),e.reverse?(o.reverse(),t.start=t.max,t.end=t.min):(t.start=t.min,t.end=t.max),o}configure(){const t=this,e=t.ticks;let i=t.min,n=t.max;if(super.configure(),t.options.offset&&e.length){const t=(n-i)/Math.max(e.length-1,1)/2;i-=t,n+=t}t._startValue=i,t._endValue=n,t._valueRange=n-i}getLabelForValue(t){return zi(t,this.chart.options.locale)}}class zs extends Is{determineDataLimits(){const t=this,{min:e,max:i}=t.getMinMax(!0);t.min=X(e)?e:0,t.max=X(i)?i:1,t.handleTickRangeOptions()}computeTickLimit(){const t=this,e=t.isHorizontal(),i=e?t.width:t.height,n=Et(t.options.ticks.minRotation),o=(e?Math.sin(n):Math.cos(n))||.001,s=t._resolveTickFontOptions(0);return Math.ceil(i/Math.min(40,s.lineHeight/o))}getPixelForValue(t){return null===t?NaN:this.getPixelForDecimal((t-this._startValue)/this._valueRange)}getValueForPixel(t){return this._startValue+this.getDecimalForPixel(t)*this._valueRange}}function Fs(t){return 1===t/Math.pow(10,Math.floor(Pt(t)))}zs.id=\"linear\",zs.defaults={ticks:{callback:Vi.formatters.numeric}};class Vs extends Xi{constructor(t){super(t),this.start=void 0,this.end=void 0,this._startValue=void 0,this._valueRange=0}parse(t,e){const i=Is.prototype.parse.apply(this,[t,e]);if(0!==i)return X(i)&&i>0?i:null;this._zero=!0}determineDataLimits(){const t=this,{min:e,max:i}=t.getMinMax(!0);t.min=X(e)?Math.max(0,e):null,t.max=X(i)?Math.max(0,i):null,t.options.beginAtZero&&(t._zero=!0),t.handleTickRangeOptions()}handleTickRangeOptions(){const t=this,{minDefined:e,maxDefined:i}=t.getUserBounds();let n=t.min,o=t.max;const s=t=>n=e?n:t,a=t=>o=i?o:t,r=(t,e)=>Math.pow(10,Math.floor(Pt(t))+e);n===o&&(n<=0?(s(1),a(10)):(s(r(n,-1)),a(r(o,1)))),n<=0&&s(r(o,-1)),o<=0&&a(r(n,1)),t._zero&&t.min!==t._suggestedMin&&n===r(t.min,0)&&s(r(n,-1)),t.min=n,t.max=o}buildTicks(){const t=this,e=t.options,i=function(t,e){const i=Math.floor(Pt(e.max)),n=Math.ceil(e.max/Math.pow(10,i)),o=[];let s=q(t.min,Math.pow(10,Math.floor(Pt(e.min)))),a=Math.floor(Pt(s)),r=Math.floor(s/Math.pow(10,a)),l=a<0?Math.pow(10,Math.abs(a)):1;do{o.push({value:s,major:Fs(s)}),++r,10===r&&(r=1,++a,l=a>=0?1:l),s=Math.round(r*Math.pow(10,a)*l)/l}while(a<i||a===i&&r<n);const c=q(t.max,s);return o.push({value:c,major:Fs(s)}),o}({min:t._userMin,max:t._userMax},t);return\"ticks\"===e.bounds&&Rt(i,t,\"value\"),e.reverse?(i.reverse(),t.start=t.max,t.end=t.min):(t.start=t.min,t.end=t.max),i}getLabelForValue(t){return void 0===t?\"0\":zi(t,this.chart.options.locale)}configure(){const t=this,e=t.min;super.configure(),t._startValue=Pt(e),t._valueRange=Pt(t.max)-Pt(e)}getPixelForValue(t){const e=this;return void 0!==t&&0!==t||(t=e.min),null===t||isNaN(t)?NaN:e.getPixelForDecimal(t===e.min?0:(Pt(t)-e._startValue)/e._valueRange)}getValueForPixel(t){const e=this,i=e.getDecimalForPixel(t);return Math.pow(10,e._startValue+i*e._valueRange)}}function Bs(t){const e=t.ticks;if(e.display&&t.display){const t=ze(e.backdropPadding);return K(e.font&&e.font.size,xt.font.size)+t.height}return 0}function Ws(t,e,i,n,o){return t===n||t===o?{start:e-i/2,end:e+i/2}:t<n||t>o?{start:e-i,end:e}:{start:e,end:e+i}}function Hs(t){return 0===t||180===t?\"center\":t<180?\"left\":\"right\"}function Ns(t,e,i){90===t||270===t?i.y-=e.h/2:(t>270||t<90)&&(i.y-=e.h)}function js(t,e,i,n){const{ctx:o}=t;if(i)o.arc(t.xCenter,t.yCenter,e,0,_t);else{let i=t.getPointPosition(0,e);o.moveTo(i.x,i.y);for(let s=1;s<n;s++)i=t.getPointPosition(s,e),o.lineTo(i.x,i.y)}}function $s(t){return Tt(t)?t:0}Vs.id=\"logarithmic\",Vs.defaults={ticks:{callback:Vi.formatters.logarithmic,major:{enabled:!0}}};class Ys extends Is{constructor(t){super(t),this.xCenter=void 0,this.yCenter=void 0,this.drawingArea=void 0,this._pointLabels=[],this._pointLabelItems=[]}setDimensions(){const t=this;t.width=t.maxWidth,t.height=t.maxHeight,t.paddingTop=Bs(t.options)/2,t.xCenter=Math.floor(t.width/2),t.yCenter=Math.floor((t.height-t.paddingTop)/2),t.drawingArea=Math.min(t.height-t.paddingTop,t.width)/2}determineDataLimits(){const t=this,{min:e,max:i}=t.getMinMax(!1);t.min=X(e)&&!isNaN(e)?e:0,t.max=X(i)&&!isNaN(i)?i:0,t.handleTickRangeOptions()}computeTickLimit(){return Math.ceil(this.drawingArea/Bs(this.options))}generateTickLabels(t){const e=this;Is.prototype.generateTickLabels.call(e,t),e._pointLabels=e.getLabels().map(((t,i)=>{const n=Q(e.options.pointLabels.callback,[t,i],e);return n||0===n?n:\"\"}))}fit(){const t=this,e=t.options;e.display&&e.pointLabels.display?function(t){const e={l:0,r:t.width,t:0,b:t.height-t.paddingTop},i={};let n,o,s;const a=[],r=[],l=t.getLabels().length;for(n=0;n<l;n++){const l=t.options.pointLabels.setContext(t.getContext(n));r[n]=l.padding,s=t.getPointPosition(n,t.drawingArea+r[n]);const u=Fe(l.font);t.ctx.font=u.string,c=t.ctx,h=u.lineHeight,o=Y(d=t._pointLabels[n])?{w:Ut(c,c.font,d),h:d.length*h}:{w:c.measureText(d).width,h:h},a[n]=o;const f=t.getIndexAngle(n),g=It(f),p=Ws(g,s.x,o.w,0,180),m=Ws(g,s.y,o.h,90,270);p.start<e.l&&(e.l=p.start,i.l=f),p.end>e.r&&(e.r=p.end,i.r=f),m.start<e.t&&(e.t=m.start,i.t=f),m.end>e.b&&(e.b=m.end,i.b=f)}var c,h,d;t._setReductions(t.drawingArea,e,i),t._pointLabelItems=[];const u=t.options,f=Bs(u),g=t.getDistanceFromCenterForValue(u.ticks.reverse?t.min:t.max);for(n=0;n<l;n++){const e=0===n?f/2:0,i=t.getPointPosition(n,g+e+r[n]),o=It(t.getIndexAngle(n)),s=a[n];Ns(o,s,i);const l=Hs(o);let c;c=\"left\"===l?i.x:\"center\"===l?i.x-s.w/2:i.x-s.w;const h=c+s.w;t._pointLabelItems[n]={x:i.x,y:i.y,textAlign:l,left:c,top:i.y,right:h,bottom:i.y+s.h}}}(t):t.setCenterPoint(0,0,0,0)}_setReductions(t,e,i){const n=this;let o=e.l/Math.sin(i.l),s=Math.max(e.r-n.width,0)/Math.sin(i.r),a=-e.t/Math.cos(i.t),r=-Math.max(e.b-(n.height-n.paddingTop),0)/Math.cos(i.b);o=$s(o),s=$s(s),a=$s(a),r=$s(r),n.drawingArea=Math.max(t/2,Math.min(Math.floor(t-(o+s)/2),Math.floor(t-(a+r)/2))),n.setCenterPoint(o,s,a,r)}setCenterPoint(t,e,i,n){const o=this,s=o.width-e-o.drawingArea,a=t+o.drawingArea,r=i+o.drawingArea,l=o.height-o.paddingTop-n-o.drawingArea;o.xCenter=Math.floor((a+s)/2+o.left),o.yCenter=Math.floor((r+l)/2+o.top+o.paddingTop)}getIndexAngle(t){return Wt(t*(_t/this.getLabels().length)+Et(this.options.startAngle||0))}getDistanceFromCenterForValue(t){const e=this;if($(t))return NaN;const i=e.drawingArea/(e.max-e.min);return e.options.reverse?(e.max-t)*i:(t-e.min)*i}getValueForDistanceFromCenter(t){if($(t))return NaN;const e=this,i=t/(e.drawingArea/(e.max-e.min));return e.options.reverse?e.max-i:e.min+i}getPointPosition(t,e){const i=this,n=i.getIndexAngle(t)-Mt;return{x:Math.cos(n)*e+i.xCenter,y:Math.sin(n)*e+i.yCenter,angle:n}}getPointPositionForValue(t,e){return this.getPointPosition(t,this.getDistanceFromCenterForValue(e))}getBasePosition(t){return this.getPointPositionForValue(t||0,this.getBaseValue())}getPointLabelPosition(t){const{left:e,top:i,right:n,bottom:o}=this._pointLabelItems[t];return{left:e,top:i,right:n,bottom:o}}drawBackground(){const t=this,{backgroundColor:e,grid:{circular:i}}=t.options;if(e){const n=t.ctx;n.save(),n.beginPath(),js(t,t.getDistanceFromCenterForValue(t._endValue),i,t.getLabels().length),n.closePath(),n.fillStyle=e,n.fill(),n.restore()}}drawGrid(){const t=this,e=t.ctx,i=t.options,{angleLines:n,grid:o}=i,s=t.getLabels().length;let a,r,l;if(i.pointLabels.display&&function(t,e){const{ctx:i,options:{pointLabels:n}}=t;for(let o=e-1;o>=0;o--){const e=n.setContext(t.getContext(o)),s=Fe(e.font),{x:a,y:r,textAlign:l,left:c,top:h,right:d,bottom:u}=t._pointLabelItems[o],{backdropColor:f}=e;if(!$(f)){const t=ze(e.backdropPadding);i.fillStyle=f,i.fillRect(c-t.left,h-t.top,d-c+t.width,u-h+t.height)}ee(i,t._pointLabels[o],a,r+s.lineHeight/2,s,{color:e.color,textAlign:l,textBaseline:\"middle\"})}}(t,s),o.display&&t.ticks.forEach(((e,i)=>{if(0!==i){r=t.getDistanceFromCenterForValue(e.value);const n=o.setContext(t.getContext(i-1));!function(t,e,i,n){const o=t.ctx,s=e.circular,{color:a,lineWidth:r}=e;!s&&!n||!a||!r||i<0||(o.save(),o.strokeStyle=a,o.lineWidth=r,o.setLineDash(e.borderDash),o.lineDashOffset=e.borderDashOffset,o.beginPath(),js(t,i,s,n),o.closePath(),o.stroke(),o.restore())}(t,n,r,s)}})),n.display){for(e.save(),a=t.getLabels().length-1;a>=0;a--){const o=n.setContext(t.getContext(a)),{color:s,lineWidth:c}=o;c&&s&&(e.lineWidth=c,e.strokeStyle=s,e.setLineDash(o.borderDash),e.lineDashOffset=o.borderDashOffset,r=t.getDistanceFromCenterForValue(i.ticks.reverse?t.min:t.max),l=t.getPointPosition(a,r),e.beginPath(),e.moveTo(t.xCenter,t.yCenter),e.lineTo(l.x,l.y),e.stroke())}e.restore()}}drawBorder(){}drawLabels(){const t=this,e=t.ctx,i=t.options,n=i.ticks;if(!n.display)return;const o=t.getIndexAngle(0);let s,a;e.save(),e.translate(t.xCenter,t.yCenter),e.rotate(o),e.textAlign=\"center\",e.textBaseline=\"middle\",t.ticks.forEach(((o,r)=>{if(0===r&&!i.reverse)return;const l=n.setContext(t.getContext(r)),c=Fe(l.font);if(s=t.getDistanceFromCenterForValue(t.ticks[r].value),l.showLabelBackdrop){a=e.measureText(o.label).width,e.fillStyle=l.backdropColor;const t=ze(l.backdropPadding);e.fillRect(-a/2-t.left,-s-c.size/2-t.top,a+t.width,c.size+t.height)}ee(e,o.label,0,-s,c,{color:l.color})})),e.restore()}drawTitle(){}}Ys.id=\"radialLinear\",Ys.defaults={display:!0,animate:!0,position:\"chartArea\",angleLines:{display:!0,lineWidth:1,borderDash:[],borderDashOffset:0},grid:{circular:!1},startAngle:0,ticks:{showLabelBackdrop:!0,callback:Vi.formatters.numeric},pointLabels:{backdropColor:void 0,backdropPadding:2,display:!0,font:{size:10},callback:t=>t,padding:5}},Ys.defaultRoutes={\"angleLines.color\":\"borderColor\",\"pointLabels.color\":\"color\",\"ticks.color\":\"color\"},Ys.descriptors={angleLines:{_fallback:\"grid\"}};const Us={millisecond:{common:!0,size:1,steps:1e3},second:{common:!0,size:1e3,steps:60},minute:{common:!0,size:6e4,steps:60},hour:{common:!0,size:36e5,steps:24},day:{common:!0,size:864e5,steps:30},week:{common:!1,size:6048e5,steps:4},month:{common:!0,size:2628e6,steps:12},quarter:{common:!1,size:7884e6,steps:4},year:{common:!0,size:3154e7}},Xs=Object.keys(Us);function qs(t,e){return t-e}function Ks(t,e){if($(e))return null;const i=t._adapter,{parser:n,round:o,isoWeekday:s}=t._parseOpts;let a=e;return\"function\"==typeof n&&(a=n(a)),X(a)||(a=\"string\"==typeof n?i.parse(a,n):i.parse(a)),null===a?null:(o&&(a=\"week\"!==o||!Tt(s)&&!0!==s?i.startOf(a,o):i.startOf(a,\"isoWeek\",s)),+a)}function Gs(t,e,i,n){const o=Xs.length;for(let s=Xs.indexOf(t);s<o-1;++s){const t=Us[Xs[s]],o=t.steps?t.steps:Number.MAX_SAFE_INTEGER;if(t.common&&Math.ceil((i-e)/(o*t.size))<=n)return Xs[s]}return Xs[o-1]}function Zs(t,e,i){if(i){if(i.length){const{lo:n,hi:o}=ne(i,e);t[i[n]>=e?i[n]:i[o]]=!0}}else t[e]=!0}function Qs(t,e,i){const n=[],o={},s=e.length;let a,r;for(a=0;a<s;++a)r=e[a],o[r]=a,n.push({value:r,major:!1});return 0!==s&&i?function(t,e,i,n){const o=t._adapter,s=+o.startOf(e[0].value,n),a=e[e.length-1].value;let r,l;for(r=s;r<=a;r=+o.add(r,1,n))l=i[r],l>=0&&(e[l].major=!0);return e}(t,n,o,i):n}class Js extends Xi{constructor(t){super(t),this._cache={data:[],labels:[],all:[]},this._unit=\"day\",this._majorUnit=void 0,this._offsets={},this._normalized=!1,this._parseOpts=void 0}init(t,e){const i=t.time||(t.time={}),n=this._adapter=new so._date(t.adapters.date);st(i.displayFormats,n.formats()),this._parseOpts={parser:i.parser,round:i.round,isoWeekday:i.isoWeekday},super.init(t),this._normalized=e.normalized}parse(t,e){return void 0===t?null:Ks(this,t)}beforeLayout(){super.beforeLayout(),this._cache={data:[],labels:[],all:[]}}determineDataLimits(){const t=this,e=t.options,i=t._adapter,n=e.time.unit||\"day\";let{min:o,max:s,minDefined:a,maxDefined:r}=t.getUserBounds();function l(t){a||isNaN(t.min)||(o=Math.min(o,t.min)),r||isNaN(t.max)||(s=Math.max(s,t.max))}a&&r||(l(t._getLabelBounds()),\"ticks\"===e.bounds&&\"labels\"===e.ticks.source||l(t.getMinMax(!1))),o=X(o)&&!isNaN(o)?o:+i.startOf(Date.now(),n),s=X(s)&&!isNaN(s)?s:+i.endOf(Date.now(),n)+1,t.min=Math.min(o,s-1),t.max=Math.max(o+1,s)}_getLabelBounds(){const t=this.getLabelTimestamps();let e=Number.POSITIVE_INFINITY,i=Number.NEGATIVE_INFINITY;return t.length&&(e=t[0],i=t[t.length-1]),{min:e,max:i}}buildTicks(){const t=this,e=t.options,i=e.time,n=e.ticks,o=\"labels\"===n.source?t.getLabelTimestamps():t._generate();\"ticks\"===e.bounds&&o.length&&(t.min=t._userMin||o[0],t.max=t._userMax||o[o.length-1]);const s=t.min,a=ae(o,s,t.max);return t._unit=i.unit||(n.autoSkip?Gs(i.minUnit,t.min,t.max,t._getLabelCapacity(s)):function(t,e,i,n,o){for(let s=Xs.length-1;s>=Xs.indexOf(i);s--){const i=Xs[s];if(Us[i].common&&t._adapter.diff(o,n,i)>=e-1)return i}return Xs[i?Xs.indexOf(i):0]}(t,a.length,i.minUnit,t.min,t.max)),t._majorUnit=n.major.enabled&&\"year\"!==t._unit?function(t){for(let e=Xs.indexOf(t)+1,i=Xs.length;e<i;++e)if(Us[Xs[e]].common)return Xs[e]}(t._unit):void 0,t.initOffsets(o),e.reverse&&a.reverse(),Qs(t,a,t._majorUnit)}initOffsets(t){const e=this;let i,n,o=0,s=0;e.options.offset&&t.length&&(i=e.getDecimalForValue(t[0]),o=1===t.length?1-i:(e.getDecimalForValue(t[1])-i)/2,n=e.getDecimalForValue(t[t.length-1]),s=1===t.length?n:(n-e.getDecimalForValue(t[t.length-2]))/2);const a=t.length<3?.5:.25;o=Nt(o,0,a),s=Nt(s,0,a),e._offsets={start:o,end:s,factor:1/(o+1+s)}}_generate(){const t=this,e=t._adapter,i=t.min,n=t.max,o=t.options,s=o.time,a=s.unit||Gs(s.minUnit,i,n,t._getLabelCapacity(i)),r=K(s.stepSize,1),l=\"week\"===a&&s.isoWeekday,c=Tt(l)||!0===l,h={};let d,u,f=i;if(c&&(f=+e.startOf(f,\"isoWeek\",l)),f=+e.startOf(f,c?\"day\":a),e.diff(n,i,a)>1e5*r)throw new Error(i+\" and \"+n+\" are too far apart with stepSize of \"+r+\" \"+a);const g=\"data\"===o.ticks.source&&t.getDataTimestamps();for(d=f,u=0;d<n;d=+e.add(d,r,a),u++)Zs(h,d,g);return d!==n&&\"ticks\"!==o.bounds&&1!==u||Zs(h,d,g),Object.keys(h).sort(((t,e)=>t-e)).map((t=>+t))}getLabelForValue(t){const e=this._adapter,i=this.options.time;return i.tooltipFormat?e.format(t,i.tooltipFormat):e.format(t,i.displayFormats.datetime)}_tickFormatFunction(t,e,i,n){const o=this,s=o.options,a=s.time.displayFormats,r=o._unit,l=o._majorUnit,c=r&&a[r],h=l&&a[l],d=i[e],u=l&&h&&d&&d.major,f=o._adapter.format(t,n||(u?h:c)),g=s.ticks.callback;return g?Q(g,[f,e,i],o):f}generateTickLabels(t){let e,i,n;for(e=0,i=t.length;e<i;++e)n=t[e],n.label=this._tickFormatFunction(n.value,e,t)}getDecimalForValue(t){const e=this;return null===t?NaN:(t-e.min)/(e.max-e.min)}getPixelForValue(t){const e=this,i=e._offsets,n=e.getDecimalForValue(t);return e.getPixelForDecimal((i.start+n)*i.factor)}getValueForPixel(t){const e=this,i=e._offsets,n=e.getDecimalForPixel(t)/i.factor-i.end;return e.min+n*(e.max-e.min)}_getLabelSize(t){const e=this,i=e.options.ticks,n=e.ctx.measureText(t).width,o=Et(e.isHorizontal()?i.maxRotation:i.minRotation),s=Math.cos(o),a=Math.sin(o),r=e._resolveTickFontOptions(0).size;return{w:n*s+r*a,h:n*a+r*s}}_getLabelCapacity(t){const e=this,i=e.options.time,n=i.displayFormats,o=n[i.unit]||n.millisecond,s=e._tickFormatFunction(t,0,Qs(e,[t],e._majorUnit),o),a=e._getLabelSize(s),r=Math.floor(e.isHorizontal()?e.width/a.w:e.height/a.h)-1;return r>0?r:1}getDataTimestamps(){const t=this;let e,i,n=t._cache.data||[];if(n.length)return n;const o=t.getMatchingVisibleMetas();if(t._normalized&&o.length)return t._cache.data=o[0].controller.getAllParsedValues(t);for(e=0,i=o.length;e<i;++e)n=n.concat(o[e].controller.getAllParsedValues(t));return t._cache.data=t.normalize(n)}getLabelTimestamps(){const t=this,e=t._cache.labels||[];let i,n;if(e.length)return e;const o=t.getLabels();for(i=0,n=o.length;i<n;++i)e.push(Ks(t,o[i]));return t._cache.labels=t._normalized?e:t.normalize(e)}normalize(t){return he(t.sort(qs))}}function ta(t,e,i){let n,o,s,a;if(i)n=Math.floor(e),o=Math.ceil(e),s=t[n],a=t[o];else{const i=ne(t,e);s=i.lo,a=i.hi,n=t[s],o=t[a]}const r=o-n;return r?s+(a-s)*(e-n)/r:s}Js.id=\"time\",Js.defaults={bounds:\"data\",adapters:{},time:{parser:!1,unit:!1,round:!1,isoWeekday:!1,minUnit:\"millisecond\",displayFormats:{}},ticks:{source:\"auto\",major:{enabled:!1}}};class ea extends Js{constructor(t){super(t),this._table=[],this._maxIndex=void 0}initOffsets(){const t=this,e=t._getTimestampsForTable();t._table=t.buildLookupTable(e),t._maxIndex=t._table.length-1,super.initOffsets(e)}buildLookupTable(t){const{min:e,max:i}=this;if(!t.length)return[{time:e,pos:0},{time:i,pos:1}];const n=[e];let o,s,a;for(o=0,s=t.length;o<s;++o)a=t[o],a>e&&a<i&&n.push(a);return n.push(i),n}_getTimestampsForTable(){const t=this;let e=t._cache.all||[];if(e.length)return e;const i=t.getDataTimestamps(),n=t.getLabelTimestamps();return e=i.length&&n.length?t.normalize(i.concat(n)):i.length?i:n,e=t._cache.all=e,e}getPixelForValue(t,e){const i=this,n=i._offsets,o=i._normalized&&i._maxIndex>0&&!$(e)?e/i._maxIndex:i.getDecimalForValue(t);return i.getPixelForDecimal((n.start+o)*n.factor)}getDecimalForValue(t){return ta(this._table,t)/this._maxIndex}getValueForPixel(t){const e=this,i=e._offsets,n=e.getDecimalForPixel(t)/i.factor-i.end;return ta(e._table,n*this._maxIndex,!0)}}ea.id=\"timeseries\",ea.defaults=Js.defaults;var ia=Object.freeze({__proto__:null,CategoryScale:Rs,LinearScale:zs,LogarithmicScale:Vs,RadialLinearScale:Ys,TimeScale:Js,TimeSeriesScale:ea});return to.register(_o,ia,Uo,As),to.helpers={...On},to._adapters=so,to.Animation=_i,to.Animations=vi,to.animator=a,to.controllers=An.controllers.items,to.DatasetController=Ri,to.Element=Ei,to.elements=Uo,to.Interaction=Oe,to.layouts=Ge,to.platforms=ui,to.Scale=Xi,to.Ticks=Vi,Object.assign(to,_o,ia,Uo,As,ui),to.Chart=to,\"undefined\"!=typeof window&&(window.Chart=to),to}));\n","chartjs/chartjs-adapter-moment.js":"/*!\n  * chartjs-adapter-moment v1.0.0\n  * https://www.chartjs.org\n  * (c) 2021 chartjs-adapter-moment Contributors\n  * Released under the MIT license\n  */\n(function (global, factory) {\ntypeof exports === 'object' && typeof module !== 'undefined' ? factory(require('moment'), require('chart.js')) :\ntypeof define === 'function' && define.amd ? define(['moment', 'chart.js'], factory) :\n(global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.moment, global.Chart));\n}(this, (function (moment, chart_js) { 'use strict';\n\nfunction _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }\n\nvar moment__default = /*#__PURE__*/_interopDefaultLegacy(moment);\n\nconst FORMATS = {\n  datetime: 'MMM D, YYYY, h:mm:ss a',\n  millisecond: 'h:mm:ss.SSS a',\n  second: 'h:mm:ss a',\n  minute: 'h:mm a',\n  hour: 'hA',\n  day: 'MMM D',\n  week: 'll',\n  month: 'MMM YYYY',\n  quarter: '[Q]Q - YYYY',\n  year: 'YYYY'\n};\n\nchart_js._adapters._date.override(typeof moment__default['default'] === 'function' ? {\n  _id: 'moment', // DEBUG ONLY\n\n  formats: function() {\n    return FORMATS;\n  },\n\n  parse: function(value, format) {\n    if (typeof value === 'string' && typeof format === 'string') {\n      value = moment__default['default'](value, format);\n    } else if (!(value instanceof moment__default['default'])) {\n      value = moment__default['default'](value);\n    }\n    return value.isValid() ? value.valueOf() : null;\n  },\n\n  format: function(time, format) {\n    return moment__default['default'](time).format(format);\n  },\n\n  add: function(time, amount, unit) {\n    return moment__default['default'](time).add(amount, unit).valueOf();\n  },\n\n  diff: function(max, min, unit) {\n    return moment__default['default'](max).diff(moment__default['default'](min), unit);\n  },\n\n  startOf: function(time, unit, weekday) {\n    time = moment__default['default'](time);\n    if (unit === 'isoWeek') {\n      weekday = Math.trunc(Math.min(Math.max(0, weekday), 6));\n      return time.isoWeekday(weekday).startOf('day').valueOf();\n    }\n    return time.startOf(unit).valueOf();\n  },\n\n  endOf: function(time, unit) {\n    return moment__default['default'](time).endOf(unit).valueOf();\n  }\n} : {});\n\n})));\n","Magento_Msrp/js/msrp.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'mage/dropdown',\n    'mage/template'\n], function ($, priceUtils, _) {\n    'use strict';\n\n    $.widget('mage.addToCart', {\n        options: {\n            showAddToCart: true,\n            submitUrl: '',\n            cartButtonId: '',\n            singleOpenDropDown: true,\n            dialog: {}, // Options for mage/dropdown\n            dialogDelay: 500, // Delay in ms after resize dropdown shown again\n            origin: '', //Required, type of popup: 'msrp', 'tier' or 'info' popup\n\n            // Selectors\n            cartForm: '.form.map.checkout',\n            msrpLabelId: '#map-popup-msrp',\n            msrpPriceElement: '#map-popup-msrp .price-wrapper',\n            priceLabelId: '#map-popup-price',\n            priceElement: '#map-popup-price .price',\n            mapInfoLinks: '.map-show-info',\n            displayPriceElement: '.old-price.map-old-price .price-wrapper',\n            fallbackPriceElement: '.normal-price.map-fallback-price .price-wrapper',\n            displayPriceContainer: '.old-price.map-old-price',\n            fallbackPriceContainer: '.normal-price.map-fallback-price',\n            popUpAttr: '[data-role=msrp-popup-template]',\n            popupCartButtonId: '#map-popup-button',\n            paypalCheckoutButons: '[data-action=checkout-form-submit]',\n            popupId: '',\n            realPrice: '',\n            isSaleable: '',\n            msrpPrice: '',\n            helpLinkId: '',\n            addToCartButton: '',\n\n            // Text options\n            productName: '',\n            addToCartUrl: ''\n        },\n\n        openDropDown: null,\n        triggerClass: 'dropdown-active',\n\n        popUpOptions: {\n            appendTo: 'body',\n            dialogContentClass: 'active',\n            closeOnMouseLeave: false,\n            autoPosition: true,\n            closeOnClickOutside: false,\n            'dialogClass': 'popup map-popup-wrapper',\n            position: {\n                my: 'left top',\n                collision: 'fit none',\n                at: 'left bottom',\n                within: 'body'\n            },\n            shadowHinter: 'popup popup-pointer'\n        },\n        popupOpened: false,\n        wasOpened: false,\n\n        /**\n         * Creates widget instance\n         *\n         * @private\n         */\n        _create: function () {\n            if (this.options.origin === 'msrp') {\n                this.initMsrpPopup();\n            } else if (this.options.origin === 'info') {\n                this.initInfoPopup();\n            } else if (this.options.origin === 'tier') {\n                this.initTierPopup();\n            }\n            $(this.options.cartButtonId).on('click', this._addToCartSubmit.bind(this));\n            $(document).on('updateMsrpPriceBlock', this.onUpdateMsrpPrice.bind(this));\n            $(this.options.cartForm).on('submit', this._onSubmitForm.bind(this));\n        },\n\n        /**\n         * Init msrp popup\n         *\n         * @private\n         */\n        initMsrpPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $msrpPopup = $(popupDOM.innerHTML.trim());\n\n            $msrpPopup.find(this.options.productIdInput).val(this.options.productId);\n            $('body').append($msrpPopup);\n            $msrpPopup.trigger('contentUpdated');\n\n            $msrpPopup.find('button')\n                .on('click',\n                    this.handleMsrpAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $msrpPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleMsrpPaypalCheckout.bind(this));\n\n            $(this.options.popupId).on('click',\n                this.openPopup.bind(this));\n\n            this.$popup = $msrpPopup;\n        },\n\n        /**\n         * Init info popup\n         *\n         * @private\n         */\n        initInfoPopup: function () {\n            var infoPopupDOM = $('[data-role=msrp-info-template]')[0],\n                $infoPopup = $(infoPopupDOM.innerHTML.trim());\n\n            $('body').append($infoPopup);\n\n            $(this.options.helpLinkId).on('click', function (e) {\n                this.popUpOptions.position.of = $(e.target);\n                $infoPopup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n                this._toggle($infoPopup);\n            }.bind(this));\n\n            this.$popup = $infoPopup;\n        },\n\n        /**\n         * Init tier price popup\n         * @private\n         */\n        initTierPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $tierPopup = $(popupDOM.innerHTML.trim());\n\n            $('body').append($tierPopup);\n            $tierPopup.find(this.options.productIdInput).val(this.options.productId);\n            this.popUpOptions.position.of = $(this.options.helpLinkId);\n\n            $tierPopup.find('button').on('click',\n                this.handleTierAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $tierPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleTierPaypalCheckout.bind(this));\n\n            $(this.options.attr).on('click', function (e) {\n                this.$popup = $tierPopup;\n                this.tierOptions = $(e.target).data('tier-price');\n                this.openPopup(e);\n            }.bind(this));\n        },\n\n        /**\n         * handle 'AddToCart' click on Msrp popup\n         * @param {Object} ev\n         *\n         * @private\n         */\n        handleMsrpAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).trigger('click');\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Msrp popup\n         *\n         * @private\n         */\n        handleMsrpPaypalCheckout: function () {\n            this.closePopup(this.$popup);\n        },\n\n        /**\n         * handle 'AddToCart' click on Tier popup\n         *\n         * @param {Object} ev\n         * @private\n         */\n        handleTierAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton &&\n                this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                $(this.options.addToCartButton).trigger('click');\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Tier popup\n         *\n         * @private\n         */\n        handleTierPaypalCheckout: function () {\n            if (this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * Open and set up popup\n         *\n         * @param {Object} event\n         */\n        openPopup: function (event) {\n            var options = this.tierOptions || this.options;\n\n            this.popUpOptions.position.of = $(event.target);\n\n            if (!this.wasOpened) {\n                this.$popup.find(this.options.msrpLabelId).html(options.msrpPrice);\n                this.$popup.find(this.options.priceLabelId).html(options.realPrice);\n                this.wasOpened = true;\n            }\n            this.$popup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n            this._toggle(this.$popup);\n\n            if (!this.options.isSaleable) {\n                this.$popup.find('form').hide();\n            }\n        },\n\n        /**\n         * Toggle MAP popup visibility\n         *\n         * @param {HTMLElement} $elem\n         * @private\n         */\n        _toggle: function ($elem) {\n            $(document).on('mouseup.msrp touchend.msrp', function (e) {\n                if (!$elem.is(e.target) && $elem.has(e.target).length === 0) {\n                    this.closePopup($elem);\n                }\n            }.bind(this));\n            $(window).on('resize', function () {\n                this.closePopup($elem);\n            }.bind(this));\n        },\n\n        /**\n         * Close MAP information popup\n         *\n         * @param {HTMLElement} $elem\n         */\n        closePopup: function ($elem) {\n            $elem.dropdownDialog('close');\n            $(document).off('mouseup.msrp touchend.msrp');\n        },\n\n        /**\n         * Handler for addToCart action\n         *\n         * @param {Object} e\n         */\n        _addToCartSubmit: function (e) {\n            this.element.trigger('addToCart', this.element);\n\n            if (this.element.data('stop-processing')) {\n                return false;\n            }\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).trigger('click');\n\n                return false;\n            }\n\n            if (this.options.addToCartUrl) {\n                $('.mage-dropdown-dialog > .ui-dialog-content').dropdownDialog('close');\n            }\n\n            e.preventDefault();\n            $(this.options.cartForm).trigger('submit');\n        },\n\n        /**\n         * Call on event updatePrice. Proxy to updateMsrpPrice method.\n         *\n         * @param {Event} event\n         * @param {mixed} priceIndex\n         * @param {Object} prices\n         * @param {Object|undefined} $priceBox\n         */\n        onUpdateMsrpPrice: function onUpdateMsrpPrice(event, priceIndex, prices, $priceBox) {\n\n            var defaultMsrp,\n                defaultPrice,\n                msrpPrice,\n                finalPrice;\n\n            defaultMsrp = _.chain(prices).map(function (price) {\n                return price.msrpPrice.amount;\n            }).reject(function (p) {\n                return p === null;\n            }).max().value();\n\n            defaultPrice = _.chain(prices).map(function (p) {\n                return p.finalPrice.amount;\n            }).min().value();\n\n            if (typeof priceIndex !== 'undefined') {\n                msrpPrice = prices[priceIndex].msrpPrice.amount;\n                finalPrice = prices[priceIndex].finalPrice.amount;\n\n                if (msrpPrice === null || msrpPrice <= finalPrice) {\n                    this.updateNonMsrpPrice(priceUtils.formatPriceLocale(finalPrice), $priceBox);\n                } else {\n                    this.updateMsrpPrice(\n                        priceUtils.formatPriceLocale(finalPrice),\n                        priceUtils.formatPriceLocale(msrpPrice),\n                        false,\n                        $priceBox);\n                }\n            } else {\n                this.updateMsrpPrice(\n                    priceUtils.formatPriceLocale(defaultPrice),\n                    priceUtils.formatPriceLocale(defaultMsrp),\n                    true,\n                    $priceBox);\n            }\n        },\n\n        /**\n         * Update prices for configurable product with MSRP enabled\n         *\n         * @param {String} finalPrice\n         * @param {String} msrpPrice\n         * @param {Boolean} useDefaultPrice\n         * @param {Object|undefined} $priceBox\n         */\n        updateMsrpPrice: function (finalPrice, msrpPrice, useDefaultPrice, $priceBox) {\n            var options = this.tierOptions || this.options;\n\n            $(this.options.fallbackPriceContainer, $priceBox).hide();\n            $(this.options.displayPriceContainer, $priceBox).show();\n            $(this.options.mapInfoLinks, $priceBox).show();\n\n            if (useDefaultPrice || !this.wasOpened) {\n                if (this.$popup) {\n                    this.$popup.find(this.options.msrpLabelId).html(options.msrpPrice);\n                    this.$popup.find(this.options.priceLabelId).html(options.realPrice);\n                }\n\n                $(this.options.displayPriceElement, $priceBox).html(msrpPrice);\n                this.wasOpened = true;\n            }\n\n            if (!useDefaultPrice) {\n                this.$popup.find(this.options.msrpPriceElement).html(msrpPrice);\n                this.$popup.find(this.options.priceElement).html(finalPrice);\n                $(this.options.displayPriceElement, $priceBox).html(msrpPrice);\n            }\n        },\n\n        /**\n         * Display non MAP price for irrelevant products\n         *\n         * @param {String} price\n         * @param {Object|undefined} $priceBox\n         */\n        updateNonMsrpPrice: function (price, $priceBox) {\n            $(this.options.fallbackPriceElement, $priceBox).html(price);\n            $(this.options.displayPriceContainer, $priceBox).hide();\n            $(this.options.mapInfoLinks, $priceBox).hide();\n            $(this.options.fallbackPriceContainer, $priceBox).show();\n        },\n\n        /**\n         * Handler for submit form\n         *\n         * @private\n         */\n        _onSubmitForm: function () {\n            if ($(this.options.cartForm).valid()) {\n                $(this.options.cartButtonId).prop('disabled', true);\n            }\n        }\n\n    });\n\n    return $.mage.addToCart;\n});\n","Magento_Rule/conditions-data-normalizer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    /**\n     * @constructor\n     */\n    var ConditionsDataNormalizer = function () {\n        this.patterns = {\n            validate: /^[a-z0-9_.-][a-z0-9_.-]*(?:\\[(?:\\d*|[a-z0-9_.-]+)\\])*$/i,\n            key: /[a-z0-9_.-]+|(?=\\[\\])/gi,\n            push: /^$/,\n            fixed: /^\\d+$/,\n            named: /^[a-z0-9_.-]+$/i\n        };\n    };\n\n    ConditionsDataNormalizer.prototype = {\n        /**\n         * Will convert an object:\n         * {\n         *   \"foo[bar][1][baz]\": 123,\n         *   \"foo[bar][1][blah]\": 321\n         *   \"foo[bar][1--1][ah]\": 456\n         * }\n         *\n         * to\n         * {\n         *   \"foo\": {\n         *     \"bar\": {\n         *       \"1\": {\n         *         \"baz\": 123,\n         *         \"blah\": 321\n         *       },\n         *       \"1--1\": {\n         *         \"ah\": 456\n         *       }\n         *     }\n         *   }\n         * }\n         */\n        normalize: function normalize(value) {\n            var el, _this = this;\n\n            this.pushes = {};\n            this.data = {};\n\n            _.each(value, function (e, i) {\n                el = {};\n                el[i] = e;\n\n                _this._addPair({\n                    name: i,\n                    value: e\n                });\n            });\n\n            return this.data;\n        },\n\n        /**\n         * @param {Object} base\n         * @param {String} key\n         * @param {String} value\n         * @return {Object}\n         * @private\n         */\n        _build: function build(base, key, value) {\n            base[key] = value;\n\n            return base;\n        },\n\n        /**\n         * @param {Object} root\n         * @param {String} value\n         * @return {*}\n         * @private\n         */\n        _makeObject: function makeObject(root, value) {\n            var keys = root.match(this.patterns.key),\n                k, idx; // nest, nest, ..., nest\n\n            while ((k = keys.pop()) !== undefined) {\n                // foo[]\n                if (this.patterns.push.test(k)) {\n                    idx = this._incrementPush(root.replace(/\\[\\]$/, ''));\n                    value = this._build([], idx, value);\n                } // foo[n]\n                else if (this.patterns.fixed.test(k)) {\n                    value = this._build({}, k, value);\n                } // foo; foo[bar]\n                else if (this.patterns.named.test(k)) {\n                    value = this._build({}, k, value);\n                }\n            }\n\n            return value;\n        },\n\n        /**\n         * @param {String} key\n         * @return {Number}\n         * @private\n         */\n        _incrementPush: function incrementPush(key) {\n            if (this.pushes[key] === undefined) {\n                this.pushes[key] = 0;\n            }\n\n            return this.pushes[key]++;\n        },\n\n        /**\n         * @param {Object} pair\n         * @return {Object}\n         * @private\n         */\n        _addPair: function addPair(pair) {\n            var obj = this._makeObject(pair.name, pair.value);\n\n            if (!this.patterns.validate.test(pair.name)) {\n                return this;\n            }\n\n            this.data = $.extend(true, this.data, obj);\n\n            return this;\n        }\n    };\n\n    return ConditionsDataNormalizer;\n});\n","Magento_Rule/rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate',\n    'prototype'\n], function (jQuery) {\n    'use strict';\n\n    var VarienRulesForm = new Class.create();\n\n    VarienRulesForm.prototype = {\n        initialize: function (parent, newChildUrl) {\n            this.parent = $(parent);\n            this.newChildUrl  = newChildUrl;\n            this.shownElement = null;\n            this.updateElement = null;\n            this.chooserSelectedItems = $H({});\n            this.readOnly = false;\n\n            var elems = this.parent.getElementsByClassName('rule-param');\n\n            for (var i = 0; i < elems.length; i++) {\n                this.initParam(elems[i]);\n            }\n        },\n\n        setReadonly: function (readonly) {\n            this.readOnly = readonly;\n            var elems = this.parent.getElementsByClassName('rule-param-remove');\n\n            for (var i = 0; i < elems.length; i++) {\n                var element = elems[i];\n\n                if (this.readOnly) {\n                    element.hide();\n                } else {\n                    element.show();\n                }\n            }\n\n            var elems = this.parent.getElementsByClassName('rule-param-new-child');\n\n            for (var i = 0; i < elems.length; i++) {\n                var element = elems[i];\n\n                if (this.readOnly) {\n                    element.hide();\n                } else {\n                    element.show();\n                }\n            }\n\n            var elems = this.parent.getElementsByClassName('rule-param');\n\n            for (var i = 0; i < elems.length; i++) {\n                var container = elems[i];\n                var label = Element.down(container, '.label');\n\n                if (label) {\n                    if (this.readOnly) {\n                        label.addClassName('label-disabled');\n                    } else {\n                        label.removeClassName('label-disabled');\n                    }\n                }\n            }\n        },\n\n        initParam: function (container) {\n            container.rulesObject = this;\n            var label = Element.down(container, '.label');\n\n            if (label) {\n                Event.observe(label, 'click', this.showParamInputField.bind(this, container));\n            }\n\n            var elem = Element.down(container, '.element');\n\n            if (elem) {\n                var trig = elem.down('.rule-chooser-trigger');\n\n                if (trig) {\n                    Event.observe(trig, 'click', this.toggleChooser.bind(this, container));\n                }\n\n                var apply = elem.down('.rule-param-apply');\n\n                if (apply) {\n                    Event.observe(apply, 'click', this.hideParamInputField.bind(this, container));\n                } else {\n                    elem = elem.down('.element-value-changer');\n                    elem.container = container;\n\n                    if (!elem.multiple) {\n                        Event.observe(elem, 'change', this.hideParamInputField.bind(this, container));\n\n                        this.changeVisibilityForValueRuleParam(elem);\n\n                    }\n                    Event.observe(elem, 'blur', this.hideParamInputField.bind(this, container));\n                }\n            }\n\n            var remove = Element.down(container, '.rule-param-remove');\n\n            if (remove) {\n                Event.observe(remove, 'click', this.removeRuleEntry.bind(this, container));\n            }\n        },\n\n        showChooserElement: function (chooser) {\n            this.chooserSelectedItems = $H({});\n\n            if (chooser.hasClassName('no-split')) {\n                this.chooserSelectedItems.set(this.updateElement.value, 1);\n            } else {\n                var values = this.updateElement.value.split(','),\n s = '';\n\n                for (var i = 0; i < values.length; i++) {\n                    s = values[i].strip();\n\n                    if (s != '') {\n                        this.chooserSelectedItems.set(s, 1);\n                    }\n                }\n            }\n            new Ajax.Request(chooser.getAttribute('url'), {\n                evalScripts: true,\n                parameters: {\n                    'form_key': FORM_KEY, 'selected[]': this.chooserSelectedItems.keys()\n                },\n                onSuccess: function (transport) {\n                    if (this._processSuccess(transport)) {\n                        jQuery(chooser).html(transport.responseText);\n                        this.showChooserLoaded(chooser, transport);\n                        jQuery(chooser).trigger('contentUpdated');\n                    }\n                }.bind(this),\n                onFailure: this._processFailure.bind(this)\n            });\n        },\n\n        showChooserLoaded: function (chooser, transport) {\n            chooser.style.display = 'block';\n        },\n\n        showChooser: function (container, event) {\n            var chooser = container.up('li');\n\n            if (!chooser) {\n                return;\n            }\n            chooser = chooser.down('.rule-chooser');\n\n            if (!chooser) {\n                return;\n            }\n            this.showChooserElement(chooser);\n        },\n\n        hideChooser: function (container, event) {\n            var chooser = container.up('li');\n\n            if (!chooser) {\n                return;\n            }\n            chooser = chooser.down('.rule-chooser');\n\n            if (!chooser) {\n                return;\n            }\n            chooser.style.display = 'none';\n        },\n\n        toggleChooser: function (container, event) {\n            if (this.readOnly) {\n                return false;\n            }\n\n            var chooser = container.up('li').down('.rule-chooser');\n\n            if (!chooser) {\n                return;\n            }\n\n            if (chooser.style.display == 'block') {\n                chooser.style.display = 'none';\n                this.cleanChooser(container, event);\n            } else {\n                this.showChooserElement(chooser);\n            }\n        },\n\n        cleanChooser: function (container, event) {\n            var chooser = container.up('li').down('.rule-chooser');\n\n            if (!chooser) {\n                return;\n            }\n            chooser.innerHTML = '';\n        },\n\n        showParamInputField: function (container, event) {\n            if (this.readOnly) {\n                return false;\n            }\n\n            if (this.shownElement) {\n                this.hideParamInputField(this.shownElement, event);\n            }\n\n            Element.addClassName(container, 'rule-param-edit');\n            var elemContainer = Element.down(container, '.element');\n\n            var elem = Element.down(elemContainer, 'input.input-text');\n\n            jQuery(elem).trigger('contentUpdated');\n\n            if (elem) {\n                elem.focus();\n\n                if (elem && elem.id && elem.id.match(/__value$/)) {\n                    this.updateElement = elem;\n                }\n\n            }\n\n            var elem = Element.down(elemContainer, '.element-value-changer');\n\n            if (elem) {\n                elem.focus();\n            }\n\n            this.shownElement = container;\n        },\n\n        hideParamInputField: function (container, event) {\n            Element.removeClassName(container, 'rule-param-edit');\n            var label = Element.down(container, '.label'),\n elem;\n\n            if (!container.hasClassName('rule-param-new-child')) {\n                elem = Element.down(container, '.element-value-changer');\n\n                if (elem && elem.options) {\n                    var selectedOptions = [];\n\n                    for (var i = 0; i < elem.options.length; i++) {\n                        if (elem.options[i].selected) {\n                            selectedOptions.push(elem.options[i].text);\n                        }\n                    }\n\n                    var str = selectedOptions.join(', ');\n\n                    label.innerHTML = str != '' ? str : '...';\n                }\n\n                this.changeVisibilityForValueRuleParam(elem);\n\n                elem = Element.down(container, 'input.input-text');\n\n                if (elem) {\n                    var str = elem.value.replace(/(^\\s+|\\s+$)/g, '');\n\n                    elem.value = str;\n\n                    if (str == '') {\n                        str = '...';\n                    } else if (str.length > 30) {\n                        str = str.substr(0, 30) + '...';\n                    }\n                    label.innerHTML = str.escapeHTML();\n                }\n            } else {\n                elem = container.down('.element-value-changer');\n\n                if (elem.value) {\n                    this.addRuleNewChild(elem);\n                }\n                elem.value = '';\n            }\n\n            if (elem && elem.id && elem.id.match(/__value$/)) {\n                this.hideChooser(container, event);\n                this.updateElement = null;\n            }\n\n            this.shownElement = null;\n        },\n\n        changeVisibilityForValueRuleParam: function(elem) {\n            var parsedElementId = elem.id.split('__');\n            if (parsedElementId[2] !== 'operator') {\n                return false;\n            }\n\n            var valueElement = jQuery('#' + parsedElementId[0] + '__' + parsedElementId[1] + '__value');\n\n            if(elem.value === '<=>') {\n                valueElement.closest('.rule-param').hide();\n            } else {\n                valueElement.closest('.rule-param').show();\n            }\n\n            return true;\n        },\n\n        addRuleNewChild: function (elem) {\n            var parent_id = elem.id.replace(/^.*__(.*)__.*$/, '$1');\n            var children_ul_id = elem.id.replace(/__/g, ':').replace(/[^:]*$/, 'children').replace(/:/g, '__');\n            var children_ul = $(this.parent).select('#' + children_ul_id)[0];\n            var max_id = 0,\n i;\n            var children_inputs = Selector.findChildElements(children_ul, $A(['input.hidden']));\n\n            if (children_inputs.length) {\n                children_inputs.each(function (el) {\n                    if (el.id.match(/__type$/)) {\n                        i = 1 * el.id.replace(/^.*__.*?([0-9]+)__.*$/, '$1');\n                        max_id = i > max_id ? i : max_id;\n                    }\n                });\n            }\n            var new_id = parent_id + '--' + (max_id + 1);\n            var new_type = elem.value;\n            var new_elem = document.createElement('LI');\n\n            new_elem.className = 'rule-param-wait';\n            new_elem.innerHTML = jQuery.mage.__('This won\\'t take long . . .');\n            children_ul.insertBefore(new_elem, $(elem).up('li'));\n\n            new Ajax.Request(this.newChildUrl, {\n                evalScripts: true,\n                parameters: {\n                    form_key: FORM_KEY, type: new_type.replace('/', '-'), id: new_id\n                },\n                onComplete: this.onAddNewChildComplete.bind(this, new_elem),\n                onSuccess: function (transport) {\n                    if (this._processSuccess(transport)) {\n                        $(new_elem).update(transport.responseText);\n                    }\n                }.bind(this),\n                onFailure: this._processFailure.bind(this)\n            });\n        },\n\n        _processSuccess: function (transport) {\n            if (transport.responseText.isJSON()) {\n                var response = transport.responseText.evalJSON();\n\n                if (response.error) {\n                    alert(response.message);\n                }\n\n                if (response.ajaxExpired && response.ajaxRedirect) {\n                    setLocation(response.ajaxRedirect);\n                }\n\n                return false;\n            }\n\n            return true;\n        },\n\n        _processFailure: function (transport) {\n            location.href = BASE_URL;\n        },\n\n        onAddNewChildComplete: function (new_elem) {\n            if (this.readOnly) {\n                return false;\n            }\n\n            $(new_elem).removeClassName('rule-param-wait');\n            var elems = new_elem.getElementsByClassName('rule-param');\n\n            for (var i = 0; i < elems.length; i++) {\n                this.initParam(elems[i]);\n            }\n        },\n\n        removeRuleEntry: function (container, event) {\n            var li = Element.up(container, 'li');\n\n            li.parentNode.removeChild(li);\n        },\n\n        chooserGridInit: function (grid) {\n            //grid.reloadParams = {'selected[]':this.chooserSelectedItems.keys()};\n        },\n\n        chooserGridRowInit: function (grid, row) {\n            if (!grid.reloadParams) {\n                grid.reloadParams = {\n                    'selected[]': this.chooserSelectedItems.keys()\n                };\n            }\n        },\n\n        chooserGridRowClick: function (grid, event) {\n            var trElement = Event.findElement(event, 'tr');\n            var isInput = Event.element(event).tagName == 'INPUT';\n\n            if (trElement) {\n                var checkbox = Element.select(trElement, 'input');\n\n                if (checkbox[0]) {\n                    var checked = isInput ? checkbox[0].checked : !checkbox[0].checked;\n\n                    grid.setCheckboxChecked(checkbox[0], checked);\n\n                }\n            }\n        },\n\n        chooserGridCheckboxCheck: function (grid, element, checked) {\n            if (checked) {\n                if (!element.up('th')) {\n                    this.chooserSelectedItems.set(element.value, 1);\n                }\n            } else {\n                this.chooserSelectedItems.unset(element.value);\n            }\n            grid.reloadParams = {\n                'selected[]': this.chooserSelectedItems.keys()\n            };\n            this.updateElement.value = this.chooserSelectedItems.keys().join(', ');\n        }\n    };\n\n    return VarienRulesForm;\n});\n","PayPal_Braintree/js/braintree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/view/utils/dom-observer',\n    'mage/translate',\n    'PayPal_Braintree/js/validator',\n    'braintree',\n    'braintreeHostedFields'\n], function ($, Class, alert, domObserver, $t, validator, client, hostedFields) {\n    'use strict';\n\n    return Class.extend({\n\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            container: 'payment_form_braintree',\n            active: false,\n            scriptLoaded: false,\n            braintree: null,\n            selectedCardType: null,\n            imports: {\n                onActiveChange: 'active'\n            },\n            hostedFieldsInstance: null\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            validator.setConfig(this);\n\n            self.$selector = $('#' + self.selector);\n            this._super()\n                .observe([\n                    'active',\n                    'scriptLoaded',\n                    'selectedCardType'\n                ]);\n\n            // re-init payment method events\n            self.$selector.off('changePaymentMethod.' + this.code)\n                .on('changePaymentMethod.' + this.code, this.changePaymentMethod.bind(this));\n\n            // listen block changes\n            domObserver.get('#' + self.container, function () {\n                if (self.scriptLoaded()) {\n                    self.$selector.off('submit');\n                    self.initBraintree();\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Enable/disable current payment method\n         * @param {Object} event\n         * @param {String} method\n         * @returns {exports.changePaymentMethod}\n         */\n        changePaymentMethod: function (event, method) {\n            this.active(method === this.code);\n            return this;\n        },\n\n        /**\n         * Triggered when payment changed\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                this.$selector.off('submitOrder.braintree');\n                this.$selector.on('submitOrder', function () {\n                    $('#payment_form_braintree').find('[type=\"submit\"]').trigger('click');\n                    $('#edit_form').trigger('realOrder');\n                });\n\n                return;\n            }\n            this.disableEventListeners();\n\n            if (typeof window.order !== 'undefined') {\n                window.order.addExcludedPaymentMethod(this.code);\n            }\n\n            if (!this.clientToken) {\n                this.error($.mage.__('This payment is not available'));\n\n                return;\n            }\n\n            this.enableEventListeners();\n\n            if (!this.scriptLoaded()) {\n                this.initBraintree();\n            }\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        initBraintree: function () {\n            var self = this;\n            this.scriptLoaded(true);\n\n            self.disableEventListeners();\n\n            try {\n                $('body').trigger('processStart');\n\n                client.create({\n                    authorization: self.clientToken\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('Error!', clientErr);\n                        return self.error(response.clientErr);\n                    }\n\n                    hostedFields.create({\n                        client: clientInstance,\n                        fields: self.getHostedFields()\n                    }, function (createErr, hostedFieldsInstance) {\n                        if (createErr) {\n                            self.error($t(createErr));\n                            console.error('Error!', createErr);\n                            return;\n                        }\n\n                        self.hostedFieldsInstance = hostedFieldsInstance;\n                        self.enableEventListeners();\n\n                        $('body').trigger('processStop');\n                    }.bind(this));\n                }.bind(this));\n            } catch (e) {\n                $('body').trigger('processStop');\n                self.error(e.message);\n                console.log(e);\n            }\n        },\n\n        /**\n         * Get hosted fields configuration\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            var self = this,\n                fields = {\n                    number: {\n                        selector: self.getSelector('cc_number'),\n                        placeholder: $t('4111 1111 1111 1111')\n                    },\n                    expirationMonth: {\n                        selector: self.getSelector('cc_exp_month'),\n                        placeholder: $t('MM')\n                    },\n                    expirationYear: {\n                        selector: self.getSelector('cc_exp_year'),\n                        placeholder: $t('YY')\n                    }\n                };\n\n            if (self.useCvv) {\n                fields.cvv = {\n                    selector: self.getSelector('cc_cid'),\n                    placeholder: $t('123')\n                };\n            }\n\n            return fields;\n        },\n\n        /**\n         * Show alert message\n         * @param {String} message\n         */\n        error: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Enable form event listeners\n         */\n        enableEventListeners: function () {\n            this.$selector.on('submitOrder.braintree', this.submitOrder.bind(this));\n        },\n\n        /**\n         * Disable form event listeners\n         */\n        disableEventListeners: function () {\n            this.$selector.off('submitOrder');\n            this.$selector.off('submit');\n        },\n\n        /**\n         * Store payment details\n         * @param {String} nonce\n         */\n        setPaymentDetails: function (nonce) {\n            var $container = $('#' + this.container);\n\n            $container.find('[name=\"payment[payment_method_nonce]\"]').val(nonce);\n        },\n\n        /**\n         * Trigger order submit\n         */\n        submitOrder: function () {\n            this.$selector.validate().form();\n            this.$selector.trigger('afterValidate.beforeSubmit');\n            $('body').trigger('processStop');\n\n            // validate parent form\n            if (this.$selector.validate().errorList.length) {\n                return false;\n            }\n\n            $('body').trigger('processStart');\n            this.tokenizeHostedFields();\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            $('#' + this.selector).trigger('realOrder');\n        },\n\n        /**\n         * Get list of currently available card types\n         * @returns {Array}\n         */\n        getCcAvailableTypes: function () {\n            var types = [],\n                $options = $(this.getSelector('cc_type')).find('option');\n\n            $.map($options, function (option) {\n                types.push($(option).val());\n            });\n\n            return types;\n        },\n\n        /**\n         * Get jQuery selector\n         * @param {String} field\n         * @returns {String}\n         */\n        getSelector: function (field) {\n            return '#' + this.code + '_' + field;\n        },\n\n        tokenizeHostedFields: function () {\n            this.hostedFieldsInstance.tokenize({\n                vault: false // vault or no?\n            }, function (tokenizeErr, payload) {\n                if (tokenizeErr) {\n                    $('body').trigger('processStop');\n                    switch (tokenizeErr.code) {\n                        case 'HOSTED_FIELDS_FIELDS_EMPTY':\n                            // occurs when none of the fields are filled in\n                            this.error($t('Please enter a card number, expiration date and CVV'));\n                            break;\n                        case 'HOSTED_FIELDS_FIELDS_INVALID':\n                            // occurs when certain fields do not pass client side validation\n                            this.error($t('Please correct the problems with the Credit Card fields.'));\n                            console.error('Some fields are invalid:', tokenizeErr.details.invalidFieldKeys);\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_FAIL_ON_DUPLICATE':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the fail on duplicate payment method\n                            //     option is set to true\n                            //   * the card being tokenized has previously been vaulted (with any customer)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.fail_on_duplicate_payment_method\n                            this.error($t('The payment method used, already exists in the user\\'s vault. Please use the vault option instead.'));\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_CVV_VERIFICATION_FAILED':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the verify card option is set to true\n                            //     and you have credit card verification turned on in the Braintree\n                            //     control panel\n                            //   * the cvv does not pass verfication (https://developers.braintreepayments.com/reference/general/testing/#avs-and-cvv/cid-responses)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.verify_card\n                            this.error($t('CVV did not pass verification'));\n                            break;\n                        case 'HOSTED_FIELDS_FAILED_TOKENIZATION':\n                            // occurs for any other tokenization error on the server\n                            this.error($t('There was an issue tokenizing the card. Please check the card is valid.'));\n                            console.error('Tokenization failed server side. Is the card valid?');\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_NETWORK_ERROR':\n                            // occurs when the Braintree gateway cannot be contacted\n                            this.error($t('There was an error connecting to Braintree. Please try again.'));\n                            break;\n                        default:\n                            this.error($t('There was an issue processing the payment. Please try again.'));\n                            console.error('Braintree error', tokenizeErr);\n                            break;\n                    }\n                } else {\n                    this.setPaymentDetails(payload.nonce);\n                    $('#' + this.container).find('[type=\"submit\"]').trigger('click');\n                }\n            }.bind(this));\n        }\n    });\n});\n","PayPal_Braintree/js/virtual.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/view/utils/dom-observer',\n    'mage/translate',\n    'PayPal_Braintree/js/validator',\n    'braintree',\n    'braintreeHostedFields'\n], function ($, Class, alert, domObserver, $t, validator, client, hostedFields) {\n    'use strict';\n\n    return Class.extend({\n\n        defaults: {\n            $container: null,\n            container: 'payment_form_braintree',\n            braintree: null,\n            selectedCardType: null,\n            hostedFieldsInstance: null\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            validator.setConfig(this);\n\n            self.$container = $('#' + self.container);\n            this._super()\n                .observe([\n                    'selectedCardType'\n                ]);\n\n            domObserver.get('#' + self.container, function () {\n                self.initBraintree();\n            });\n\n            return this;\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        initBraintree: function () {\n            var self = this;\n\n            try {\n                $('body').trigger('processStart');\n\n                client.create({\n                    authorization: self.clientToken\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        alert({\n                            content: $t('Please configure your Braintree Payments account in order to use the virtual terminal.')\n                        });\n                        console.error('Error!', clientErr);\n                        return self.error(response.clientErr);\n                    }\n\n                    hostedFields.create({\n                        client: clientInstance,\n                        fields: self.getHostedFields()\n                    }, function (createErr, hostedFieldsInstance) {\n                        if (createErr) {\n                            self.error($t(createErr));\n                            console.error('Error!', createErr);\n                            return;\n                        }\n\n                        self.hostedFieldsInstance = hostedFieldsInstance;\n                        self.$container.on('takePayment', self.submitOrder.bind(self));\n\n                        $('body').trigger('processStop');\n                    }.bind(this));\n                }.bind(this));\n            } catch (e) {\n                $('body').trigger('processStop');\n                self.error(e.message);\n                console.log(e);\n            }\n        },\n\n        /**\n         * Get hosted fields configuration\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            return {\n                number: {\n                    selector: this.getSelector('cc_number'),\n                    placeholder: $t('4111 1111 1111 1111')\n                },\n                expirationMonth: {\n                    selector: this.getSelector('cc_exp_month'),\n                    placeholder: $t('MM')\n                },\n                expirationYear: {\n                    selector: this.getSelector('cc_exp_year'),\n                    placeholder: $t('YY')\n                },\n                cvv: {\n                    selector: this.getSelector('cc_cid'),\n                    placeholder: $t('123')\n                }\n            };\n        },\n\n        /**\n         * Show alert message\n         * @param {String} message\n         */\n        error: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Store payment details\n         * @param {String} nonce\n         */\n        setPaymentDetails: function (nonce) {\n            var $container = $('#' + this.container);\n            $container.find('[name=\"payment_method_nonce\"]').val(nonce);\n        },\n\n        /**\n         * Trigger order submit\n         */\n        submitOrder: function (event) {\n            event.preventDefault();\n\n            this.$container.validate().form();\n            this.$container.trigger('afterValidate.beforeSubmit');\n            $('body').trigger('processStop');\n\n            // validate parent form\n            if (this.$container.validate().errorList.length) {\n                return false;\n            }\n\n            $('body').trigger('processStart');\n            this.tokenizeHostedFields();\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            this.$container.submit();\n        },\n\n        /**\n         * Get list of currently available card types\n         * @returns {Array}\n         */\n        getCcAvailableTypes: function () {\n            var types = [],\n                $options = $(this.getSelector('cc_type')).find('option');\n\n            $.map($options, function (option) {\n                types.push($(option).val());\n            });\n\n            return types;\n        },\n\n        /**\n         * Get jQuery selector\n         * @param {String} field\n         * @returns {String}\n         */\n        getSelector: function (field) {\n            return '#' + this.code + '_' + field;\n        },\n\n        tokenizeHostedFields: function () {\n            this.hostedFieldsInstance.tokenize({\n                vault: false // vault or no?\n            }, function (tokenizeErr, payload) {\n                if (tokenizeErr) {\n                    $('body').trigger('processStop');\n                    switch (tokenizeErr.code) {\n                        case 'HOSTED_FIELDS_FIELDS_EMPTY':\n                            // occurs when none of the fields are filled in\n                            this.error($t('Please enter a card number, expiration date and CVV'));\n                            break;\n                        case 'HOSTED_FIELDS_FIELDS_INVALID':\n                            // occurs when certain fields do not pass client side validation\n                            this.error($t('Please correct the problems with the Credit Card fields.'));\n                            console.error('Some fields are invalid:', tokenizeErr.details.invalidFieldKeys);\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_FAIL_ON_DUPLICATE':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the fail on duplicate payment method\n                            //     option is set to true\n                            //   * the card being tokenized has previously been vaulted (with any customer)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.fail_on_duplicate_payment_method\n                            this.error($t('The payment method used, already exists in the user\\'s vault. Please use the vault option instead.'));\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_CVV_VERIFICATION_FAILED':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the verify card option is set to true\n                            //     and you have credit card verification turned on in the Braintree\n                            //     control panel\n                            //   * the cvv does not pass verfication (https://developers.braintreepayments.com/reference/general/testing/#avs-and-cvv/cid-responses)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.verify_card\n                            this.error($t('CVV did not pass verification'));\n                            break;\n                        case 'HOSTED_FIELDS_FAILED_TOKENIZATION':\n                            // occurs for any other tokenization error on the server\n                            this.error($t('There was an issue tokenizing the card. Please check the card is valid.'));\n                            console.error('Tokenization failed server side. Is the card valid?');\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_NETWORK_ERROR':\n                            // occurs when the Braintree gateway cannot be contacted\n                            this.error($t('There was an error connecting to Braintree. Please try again.'));\n                            break;\n                        default:\n                            this.error($t('There was an issue processing the payment. Please try again.'));\n                            console.error('Braintree error', tokenizeErr);\n                            break;\n                    }\n                } else {\n                    this.setPaymentDetails(payload.nonce);\n                    this.placeOrder();\n                }\n            }.bind(this));\n        }\n    });\n});\n","PayPal_Braintree/js/form-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/paypalStylingPreview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\nrequire([\n    'underscore',\n    'jquery',\n    'domReady!'\n], function (_, $) {\n    'use strict';\n    let buttonIds = [], currentButtonId = '';\n    let location = '', buttonType = '', buttonShow = '', buttonLayout = '', buttonTagline = '', buttonLabel = '', buttonColor = '', buttonShape = '', buttonSize = '';\n    let messagingShow = '', messagingLayout = '', messagingLogo = '', messagingLogoPosition = '', messagingTextColor = '';\n\n    function getCurrentLocationAndButtonType()\n    {\n        location = $('.payment-location').val();\n        buttonType = $('.' + location + '-button-type').val();\n    }\n\n    $(document).ready(function () {\n        getCurrentLocationAndButtonType();\n\n        $('.payment-location').on('change', function (customEvent) {\n            location = $(this).val();\n            buttonType = $('.' + location + '-button-type').val();\n            buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n            buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n            buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n            buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n            buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n            buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n            buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n            updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n\n            // render pay later messages when location changed\n            messagingShow = $('.' + location + '-messaging-show').val();\n            messagingLayout = $('.' + location + '-messaging-layout').val();\n            messagingLogo = $('.' + location + '-messaging-logo').val();\n            messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n            messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n            renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n            customEvent.stopImmediatePropagation();\n        });\n\n        $(\"select\").change(function () {\n            $(document).on('change', '.' + location + '-button-type', function (customEvent) {\n                buttonType = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-show', function (customEvent) {\n                buttonShow = $(this).val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-layout', function (customEvent) {\n                buttonLayout = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-tagline', function (customEvent) {\n                buttonTagline = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-label', function (customEvent) {\n                buttonLabel = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-color', function (customEvent) {\n                buttonColor = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-shape', function (customEvent) {\n                buttonShape = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-size', function (customEvent) {\n                buttonSize = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-show', function (customEvent) {\n                messagingShow = $(this).val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-layout', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $(this).val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-logo', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $(this).val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-logo-position', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $(this).val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-text-color', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $(this).val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n        });\n    });\n\n    /**\n     * Update PayPal, Credit and Pay Later button styling if applicable\n     * @param location\n     * @param buttonType\n     * @param buttonShow\n     * @param buttonLayout\n     * @param buttonTagline\n     * @param buttonLabel\n     * @param buttonColor\n     * @param buttonShape\n     * @param buttonSize\n     */\n    let updatePayPalButtonStyling = function (location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize) {\n        $('.action-braintree-paypal-logo').each(function () {\n            if ($.inArray($(this).attr('id'), buttonIds) === -1) {\n                buttonIds.push($(this).attr('id'));\n            }\n        });\n\n        buttonIds.each(function (id) {\n            let result = id.startsWith(buttonType);\n            if (result === true) {\n                currentButtonId = id;\n            }\n        });\n\n        let currentButtonElement = $('#' + currentButtonId);\n        if (currentButtonElement.length) {\n            let style = {\n                color: buttonColor,\n                shape: buttonShape,\n                size: buttonSize,\n                layout: buttonLayout,\n                label: buttonLabel\n            };\n            style.fundingicons = true;\n            let fundingSource = buttonType;\n\n            if (buttonLayout === 'horizontal') {\n                if (buttonTagline === '1') {\n                    style.tagline = true;\n                } else {\n                    style.tagline = false;\n                }\n            }\n\n            // Render\n            let button = paypal.Buttons({\n                fundingSource: fundingSource,\n                style: style,\n\n                onInit: function (data, actions) {\n                    actions.disable();\n                }\n            });\n            if (!button.isEligible()) {\n                console.log('PayPal button is not eligible');\n                currentButtonElement.parent().remove();\n                return;\n            }\n            if (currentButtonElement.length) {\n                currentButtonElement.empty();\n                if (buttonShow === '1') {\n                    button.render('#' + currentButtonElement.attr('id'));\n                }\n            }\n        }\n    };\n\n    /**\n     * Render and update Pay Later messaging style\n     * @param location\n     * @param messagingShow\n     * @param messagingLayout\n     * @param messagingLogo\n     * @param messagingLogoPosition\n     * @param messagingTextColor\n     */\n    let renderPayLaterMessages = function (location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor) {\n        $('.action-braintree-paypal-message').each(function () {\n            let messageElement = $('#' + $(this).attr('id'));\n\n            let payLaterMessageStyle = {\n                layout: messagingLayout,\n                text: {\n                    color: messagingTextColor\n                },\n                logo: {\n                    type: messagingLogo,\n                    position: messagingLogoPosition\n                }\n            };\n\n            let messageElementId = $(messageElement).attr('id');\n            let messageAmount = $(messageElement).data('pp-amount');\n            let parentElementId = messageElement.closest('tr').attr('id');\n\n            let messages = paypal.Messages({\n                amount: $(messageElement).data('pp-amount'),\n                pageType: location,\n                style: payLaterMessageStyle\n            });\n\n            if (messageElement.length) {\n                if (messagingShow === '1') {\n                    messageElement.remove();\n                    $('#' + parentElementId + ' td.value').append('<div class=\"action-braintree-paypal-message\" id=\"' + messageElementId + '\" data-pp-amount=\"' + messageAmount + '\" data-pp-type=\"' + location + '\" data-messaging-show=\"' + messagingShow + '\" data-messaging-layout=\"' + messagingLayout + '\" data-messaging-logo=\"' + messagingLogo + '\" data-messaging-logo-position=\"' + messagingLogoPosition + '\" data-messaging-text-color=\"' + messagingTextColor + '\"></div>');\n                    messages.render('#' + messageElementId);\n                } else {\n                    messageElement.hide();\n                }\n            }\n        });\n    };\n});\n","PayPal_Braintree/js/paypalButtonPreview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    'braintree',\n    'braintreePayPalCheckout',\n    'domReady!'\n], function (_, $, braintree, paypalCheckout) {\n    'use strict';\n    let buttonIds = [];\n\n    return {\n        events: {\n            onClick: null\n        },\n\n        /**\n         * @param token\n         * @param currency\n         * @param env\n         * @param local\n         */\n        init: function (token, currency, env, local) {\n            buttonIds = [];\n            $('.action-braintree-paypal-logo').each(function () {\n                if (!$(this).hasClass(\"button-loaded\")) {\n                    $(this).addClass('button-loaded');\n                    buttonIds.push($(this).attr('id'));\n                }\n            });\n\n            if (buttonIds.length > 0) {\n                this.loadSDK(token, currency, env, local);\n            }\n        },\n\n        /**\n         * Load Braintree PayPal SDK\n         * @param token\n         * @param currency\n         * @param env\n         * @param local\n         */\n        loadSDK: function (token, currency, env, local) {\n            braintree.create({\n                authorization: token\n            }, function (clientErr, clientInstance) {\n                if (clientErr) {\n                    console.error('paypalCheckout error', clientErr);\n                    return this.showError(\"PayPal Checkout could not be initialized. Please contact the store owner.\");\n                }\n                paypalCheckout.create({\n                    client: clientInstance\n                }, function (err, paypalCheckoutInstance) {\n                    if (typeof paypal !== 'undefined' ) {\n                        this.renderPayPalButtons(buttonIds);\n                        this.renderPayPalMessages();\n                    } else {\n                        var configSDK = {\n                            components: 'buttons,messages,funding-eligibility',\n                            \"enable-funding\": \"paylater\",\n                            currency: currency\n                        };\n                        if (env === 'sandbox' && (local !== '' || local !== 'undefined')) {\n                            configSDK[\"buyer-country\"] = local;\n                        }\n                        paypalCheckoutInstance.loadPayPalSDK(configSDK, function () {\n                            this.renderPayPalButtons(buttonIds);\n                            this.renderPayPalMessages();\n                        }.bind(this));\n                    }\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Render PayPal buttons\n         * @param ids\n         */\n        renderPayPalButtons: function (ids) {\n            _.each(ids, function (id) {\n                this.payPalButton(id);\n            }.bind(this));\n        },\n\n        /**\n         * Render PayPal messages\n         */\n        renderPayPalMessages: function () {\n            $('.action-braintree-paypal-message').each(function () {\n                let messages = paypal.Messages({\n                    amount: $(this).data('pp-amount'),\n                    pageType: $(this).data('pp-type'),\n                    style: {\n                        layout: $(this).data('messaging-layout'),\n                        text: {\n                            color:   $(this).data('messaging-text-color')\n                        },\n                        logo: {\n                            type: $(this).data('messaging-logo'),\n                            position: $(this).data('messaging-logo-position')\n                        }\n                    }\n                });\n\n                if ($('#' + $(this).attr('id')).length && $(this).data('messaging-show')) {\n                    messages.render('#' + $(this).attr('id'));\n                }\n            });\n        },\n\n        /**\n         * @param id\n         */\n        payPalButton: function (id) {\n            let data = $('#' + id);\n            let style = {\n                color: data.data('color'),\n                shape: data.data('shape'),\n                size: data.data('size'),\n                layout: data.data('layout'),\n                label: data.data('label')\n            };\n\n            if (data.data('fundingicons')) {\n                style.fundingicons = data.data('fundingicons');\n            }\n\n            if (data.data('layout') === 'horizontal') {\n                style.tagline = data.data('tagline');\n            }\n\n            // Render\n            var button = paypal.Buttons({\n                fundingSource: data.data('funding'),\n                style: style,\n\n                onInit: function (data, actions) {\n                    actions.disable();\n                }\n            });\n            if (!button.isEligible()) {\n                console.log('PayPal button is not elligible');\n                data.parent().remove();\n                return;\n            }\n            if ($('#' + data.attr('id')).length && data.data('show')) {\n                button.render('#' + data.attr('id'));\n            }\n        },\n    }\n});\n","PayPal_Braintree/js/system.js":"require(['jquery', 'Magento_Ui/js/modal/alert', 'mage/translate', 'domReady!'], function ($, alert, $t) {\n    function disablePayLaterMessages()\n    {\n        let merchantCountry = $('[data-ui-id=\"adminhtml-system-config-field-country-0-select-groups-account-fields-merchant-country-value\"]').val();\n        let payPalCredit = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-fields-braintree-paypal-credit-active-value\"]').val();\n        let cart = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-button-cart-fields-message-cart-enable-value\"]');\n        let product = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-button-checkout-fields-message-checkout-enable-value\"]')\n        let checkout = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-button-productpage-fields-message-productpage-enable-value\"]')\n        let allowedCountries = ['GB', 'FR', 'US', 'DE', 'AU'];\n\n        if($.inArray(merchantCountry, allowedCountries) === -1 || payPalCredit === 1){\n            //hide pay later message\n            cart.val(0).attr('readonly',true).click();\n            product.val(0).attr('readonly',true).click();\n            checkout.val(0).attr('readonly',true).click();\n        }\n        if (merchantCountry) {\n            if ( merchantCountry === 'GB') {\n                merchantCountry = 'UK'\n            }\n            cart.next().find('a').attr('href', cart.next().find('a').attr('href') + merchantCountry.toLowerCase());\n            product.next().find('a').attr('href', product.next().find('a').attr('href') + merchantCountry.toLowerCase());\n            checkout.next().find('a').attr('href', checkout.next().find('a').attr('href') + merchantCountry.toLowerCase());\n        }\n\n    }\n\n    window.braintreeValidator = function (endpoint, environmentId, skip = false) {\n        environmentId = $('[data-ui-id=\"' + environmentId + '\"]').val();\n\n        let merchantId = '', publicId = '', privateId = '';\n\n        if (environmentId === 'sandbox') {\n            merchantId = $('[data-ui-id=\"text-groups-braintree-section-groups-braintree-groups-braintree-required-fields-sandbox-merchant-id-value\"]').val();\n            publicId = $('[data-ui-id=\"password-groups-braintree-section-groups-braintree-groups-braintree-required-fields-sandbox-public-key-value\"]').val();\n            privateId = $('[data-ui-id=\"password-groups-braintree-section-groups-braintree-groups-braintree-required-fields-sandbox-private-key-value\"]').val();\n        } else {\n            merchantId = $('[data-ui-id=\"text-groups-braintree-section-groups-braintree-groups-braintree-required-fields-merchant-id-value\"]').val();\n            publicId = $('[data-ui-id=\"password-groups-braintree-section-groups-braintree-groups-braintree-required-fields-public-key-value\"]').val();\n            privateId = $('[data-ui-id=\"password-groups-braintree-section-groups-braintree-groups-braintree-required-fields-private-key-value\"]').val();\n        }\n\n        /* Remove previous success message if present */\n        if ($(\".braintree-credentials-success-message\")) {\n            $(\".braintree-credentials-success-message\").remove();\n        }\n\n        /* Basic field validation */\n        var errors = [];\n\n        if (!environmentId || environmentId !== 'sandbox' && environmentId !== 'production') {\n            errors.push($t(\"Please select an Environment\"));\n        }\n\n        if (!merchantId) {\n            errors.push($t(\"Please enter a Merchant ID\"));\n        }\n\n        if (!publicId) {\n            errors.push($t('Please enter a Public Key'));\n        }\n\n        if (!privateId) {\n            errors.push($t('Please enter a Private Key'));\n        }\n\n        if (errors.length > 0) {\n            alert({\n                title: $t('Braintree Credential Validation Failed'),\n                content:  errors.join('<br />')\n            });\n            return false;\n        }\n\n        $(this).text($t(\"We're validating your credentials...\")).attr('disabled', true);\n\n        var self = this;\n        $.ajax({\n            type: 'POST',\n            url: endpoint,\n            data: {\n                environment: environmentId,\n                merchant_id: merchantId,\n                public_key: publicId,\n                private_key: privateId\n            },\n            showLoader: true,\n            success: function (result) {\n                if (result.success === 'true') {\n                    if (skip === true) {\n                        $('<div class=\"message message-success braintree-credentials-success-message\">' + $t(\"Your credentials are valid.\") + '</div>').insertAfter($('.paypal-styling-buttons'));\n                    } else {\n                        $('<div class=\"message message-success braintree-credentials-success-message\">' + $t(\"Your credentials are valid.\") + '</div>').insertAfter(self);\n                    }\n                } else {\n                    alert({\n                        title: $t('Braintree Credential Validation Failed'),\n                        content: $t('Your Braintree Credentials could not be validated. Please ensure you have selected the correct environment and entered a valid Merchant ID, Public Key and Private Key.')\n                    });\n                }\n            }\n        }).always(function () {\n            $(self).text($t(\"Validate Credentials\")).attr('disabled', false);\n        });\n    };\n\n    window.applyForAll = function () {\n        let buttonShowStatus = '', buttonLayout = '', buttonTagline = '', buttonLabel = '', buttonColor = '', buttonShape = '', buttonSize = '';\n        let locations = ['checkout', 'productpage', 'cart'], buttonTypes = ['paypal', 'paylater', 'credit'];\n\n        let location = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-fields-payment-location-value\"]').val();\n        let buttonType = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-fields-paypal-location-' + location + '-button-type-value\"]').val();\n        buttonShowStatus = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-show-value\"]').val();\n        buttonLayout = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-layout-value\"]').val();\n        buttonTagline = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-tagline-value\"]').val();\n        buttonLabel = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-label-value\"]').val();\n        buttonColor = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-color-value\"]').val();\n        buttonShape = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-shape-value\"]').val();\n        buttonSize = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-size-value\"]').val();\n\n        // pay later messaging styling field values\n        let messagingShow = $('.' + location + '-messaging-show').val();\n        let messagingLayout = $('.' + location + '-messaging-layout').val();\n        let messagingLogo = $('.' + location + '-messaging-logo').val();\n        let messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n        let messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n        locations.each(function (loc) {\n            buttonTypes.each(function (type) {\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-show-value\"]').val(buttonShowStatus).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-layout-value\"]').val(buttonLayout).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-tagline-value\"]').val(buttonTagline).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-label-value\"]').val(buttonLabel).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-color-value\"]').val(buttonColor).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-shape-value\"]').val(buttonShape).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-size-value\"]').val(buttonSize).click();\n            });\n\n            // apply pay later messaging styling for all locations\n            $('.' + loc + '-messaging-show').val(messagingShow).click();\n            $('.' + loc + '-messaging-layout').val(messagingLayout).click();\n            $('.' + loc + '-messaging-logo').val(messagingLogo).click();\n            $('.' + loc + '-messaging-logo-position').val(messagingLogoPosition).click();\n            $('.' + loc + '-messaging-text-color').val(messagingTextColor).click();\n        });\n        $('#save').click();\n    };\n\n    window.resetAll = function () {\n        let locations = ['checkout', 'productpage', 'cart'], buttonTypes = ['paypal', 'paylater', 'credit'];\n        let buttonShowStatus = 1, buttonLayout = 'horizontal', buttonTagline = 0, buttonLabel = 'paypal', buttonColor = 'gold', buttonShape = 'rect', buttonSize = 'responsive';\n\n        locations.each(function (loc) {\n            buttonTypes.each(function (type) {\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-show-value\"]').val(buttonShowStatus).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-layout-value\"]').val(buttonLayout).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-tagline-value\"]').val(buttonTagline).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-label-value\"]').val(buttonLabel).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-color-value\"]').val(buttonColor).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-shape-value\"]').val(buttonShape).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-size-value\"]').val(buttonSize).click();\n            });\n\n            // reset pay later messaging styling to recommended defaults\n            $('.' + loc + '-messaging-show').val(1).click();\n            $('.' + loc + '-messaging-layout').val('text').click();\n            $('.' + loc + '-messaging-logo').val('inline').click();\n            $('.' + loc + '-messaging-logo-position').val('left').click();\n            $('.' + loc + '-messaging-text-color').val('black').click();\n        });\n        $('#save').click();\n    };\n\n    window.applyButton = function () {\n        let locations = ['checkout', 'productpage', 'cart'], buttonTypes = ['paypal', 'paylater', 'credit'];\n\n        locations.each(function (loc) {\n            buttonTypes.each(function (type) {\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-show-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-layout-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-tagline-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-label-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-color-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-shape-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-size-value\"]').click();\n            });\n\n            // apply pay later messaging styling to current location\n            $('.' + loc + '-messaging-show').click();\n            $('.' + loc + '-messaging-layout').click();\n            $('.' + loc + '-messaging-logo').click();\n            $('.' + loc + '-messaging-logo-position').click();\n            $('.' + loc + '-messaging-text-color').click();\n        });\n        $('#save').click();\n    };\n\n    var locations = ['checkout', 'productpage', 'cart'];\n    hidePaypalSections();\n    $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-fields-payment-location-value\"]').change(function () {\n        hidePaypalSections();\n    });\n    locations.each(function (loc) {\n        $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-'+loc+'-fields-paypal-location-'+loc+'-button-type-value\"]').change(function () {\n            hidePaypalSections();\n        });\n    });\n\n    function hidePaypalSections() {\n        var mainLocation, merchantCountryIndex, mainType;\n        var locations = ['checkout', 'productpage', 'cart'], buttonTypes = ['paypal', 'paylater', 'credit'];\n        mainLocation = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-fields-payment-location-value\"]');\n        if (mainLocation.length < 1) {\n            return false;\n        }\n        merchantCountryIndex = mainLocation.attr('id').split('_')[1];\n        mainType = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-'+mainLocation.val()+'-fields-paypal-location-'+mainLocation.val()+'-button-type-value\"]');\n        locations.each(function (loc) {\n            $('#row_payment_' + merchantCountryIndex + '_braintree_section_braintree_braintree_paypal_styling_button_' + loc).hide();\n            buttonTypes.each(function (type) {\n                $('#row_payment_'+merchantCountryIndex+'_braintree_section_braintree_braintree_paypal_styling_button_'+loc+'_button_location_'+loc+'_type_' + type).hide();\n            });\n        });\n        $('#row_payment_'+merchantCountryIndex+'_braintree_section_braintree_braintree_paypal_styling_button_'+mainLocation.val()+'_button_location_'+mainLocation.val()+'_type_' + mainType.val()).show();\n        $('#row_payment_'+merchantCountryIndex+'_braintree_section_braintree_braintree_paypal_styling_button_' + mainLocation.val()).show();\n    }\n    disablePayLaterMessages();\n});\n","PayPal_Braintree/js/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert'\n], function ($, Class, alert) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            $container: null\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            self.$selector = $('#' + self.selector);\n            self.$container =  $('#' + self.container);\n            self.$selector.on(\n                'setVaultNotActive.' + self.getCode(),\n                function () {\n                    self.$selector.off('submitOrder.' + self.getCode());\n                }\n            );\n            self._super();\n\n            self.initEventHandlers();\n\n            return self;\n        },\n\n        /**\n         * Get payment code\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Init event handlers\n         */\n        initEventHandlers: function () {\n            $(this.$container).find('[name=\"payment[token_switcher]\"]')\n                .on('click', this.selectPaymentMethod.bind(this));\n        },\n\n        /**\n         * Select current payment token\n         */\n        selectPaymentMethod: function () {\n            this.disableEventListeners();\n            this.enableEventListeners();\n        },\n\n        /**\n         * Enable form event listeners\n         */\n        enableEventListeners: function () {\n            this.$selector.on('submitOrder.' + this.getCode(), this.submitOrder.bind(this));\n        },\n\n        /**\n         * Disable form event listeners\n         */\n        disableEventListeners: function () {\n            this.$selector.off('submitOrder');\n        },\n\n        /**\n         * Pre submit for order\n         * @returns {Boolean}\n         */\n        submitOrder: function () {\n            this.$selector.validate().form();\n            this.$selector.trigger('afterValidate.beforeSubmit');\n            $('body').trigger('processStop');\n\n            // validate parent form\n            if (this.$selector.validate().errorList.length) {\n                return false;\n            }\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            this.$selector.trigger('realOrder');\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            $('body').trigger('processStart');\n\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            }).done(function (response) {\n                self.setPaymentDetails(response.paymentMethodNonce);\n                self.placeOrder();\n            }).fail(function (response) {\n                var failed = JSON.parse(response.responseText);\n\n                self.error(failed.message);\n            }).always(function () {\n                $('body').trigger('processStop');\n            });\n        },\n\n        /**\n         * Store payment details\n         * @param {String} nonce\n         */\n        setPaymentDetails: function (nonce) {\n            this.createPublicHashSelector();\n\n            this.$selector.find('[name=\"payment[public_hash]\"]').val(this.publicHash);\n            this.$selector.find('[name=\"payment[payment_method_nonce]\"]').val(nonce).prop('disabled', false);\n        },\n\n        /**\n         * Creates public hash selector\n         */\n        createPublicHashSelector: function () {\n            var $input;\n\n            if (this.$selector.find('[name=\"payment[payment_method_nonce]\"]').size() === 0) {\n                $input = $('<input>').attr(\n                    {\n                        type: 'hidden',\n                        id: this.getNonceSelectorName(),\n                        name: 'payment[payment_method_nonce]'\n                    }\n                );\n\n                $input.appendTo(this.$selector);\n                $input.prop('disabled', false);\n            }\n        },\n\n        /**\n         * Show alert message\n         * @param {String} message\n         */\n        error: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Get selector name for nonce input\n         * @returns {String}\n         */\n        getNonceSelectorName: function () {\n            return 'nonce_' + this.getCode();\n        }\n    });\n});\n","PayPal_Braintree/js/validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        config: {},\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get List of available card types\n         * @returns {*|exports.defaults.availableCardTypes|{}}\n         */\n        getAvailableCardTypes: function () {\n            return this.config.availableCardTypes;\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.config.ccTypesMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        /**\n         * Filter list of available card types\n         * @param {Object} availableTypes\n         * @param {Object} countrySpecificCardTypes\n         * @returns {Object}\n         */\n        collectTypes: function (availableTypes, countrySpecificCardTypes) {\n            var key,\n                filteredTypes = [];\n\n            for (key in availableTypes) {\n                if (_.indexOf(countrySpecificCardTypes, availableTypes[key]) !== -1) {\n                    filteredTypes.push(availableTypes[key]);\n                }\n            }\n\n            return filteredTypes;\n        },\n\n        /**\n         * Get list of card types for country\n         * @param {String} countryId\n         * @returns {*}\n         */\n        getCountrySpecificCardTypes: function (countryId) {\n            if (typeof this.config.countrySpecificCardTypes[countryId] !== 'undefined') {\n                return this.config.countrySpecificCardTypes[countryId];\n            }\n\n            return false;\n        }\n    };\n});\n","PayPal_Braintree/js/grid/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/grid/provider'\n], function (_, Provider) {\n    'use strict';\n\n    return Provider.extend({\n\n        /**\n         * Reload grid\n         * @returns {exports}\n         */\n        reload: function () {\n            if (this.hasFilters()) {\n                this._super();\n\n                return this;\n            }\n\n            this.trigger('reload');\n\n            this.onReload({\n                items: [],\n                totalRecords: 0\n            });\n\n            return this;\n        },\n\n        /**\n         * Has filters checker\n         * @returns {Boolean}\n         */\n        hasFilters: function () {\n            var params = this.params,\n                filters = params.filters || {};\n\n            return _.keys(filters).length > 1;\n        }\n    });\n});\n","MageBig_Shopbybrand/js/browser.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global MediabrowserUtility, FORM_KEY, tinyMceEditors */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'wysiwygAdapter',\n    'Magento_Ui/js/modal/prompt',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'underscore',\n    'Magento_Ui/js/modal/modal',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree',\n    'mage/mage'\n], function ($, wysiwyg, prompt, confirm, alert, _) {\n    MbMediabrowserUtility = {\n        windowId: 'modal_dialog_message',\n        modalLoaded: false,\n        targetElementId: false,\n        pathId: '',\n\n        /**\n         * @return {Number}\n         */\n        getMaxZIndex: function () {\n            var max = 0,\n                cn = document.body.childNodes,\n                i, el, zIndex;\n\n            for (i = 0; i < cn.length; i++) {\n                el = cn[i];\n                zIndex = el.nodeType == 1 ? parseInt(el.style.zIndex, 10) || 0 : 0; //eslint-disable-line eqeqeq\n\n                if (zIndex < 10000) {\n                    max = Math.max(max, zIndex);\n                }\n            }\n\n            return max + 10;\n        },\n\n        /**\n         * @param {*} url\n         * @param {*} width\n         * @param {*} height\n         * @param {*} title\n         * @param {Object} options\n         */\n        openDialog: function(btn, url, width, height, title, options) {\n            this.$btn = $(btn);\n            this.targetParent = $(btn).parents('.admin__field-control').first();\n            this.targetElement = this.targetParent.find('.input-image').first();\n\n            var windowId = this.windowId,\n                content = '<div class=\"popup-window magento_message\" id=\"' + windowId + '\"></div>',\n                self = this;\n\n            if (this.modalLoaded) {\n\n                if (!_.isUndefined(options)) {\n                    this.modal.modal('option', 'closed', options.closed);\n                }\n\n                this.modal.modal('openModal');\n                // this.setTargetElementId(options, url);\n                // this.setPathId(url);\n                $(window).trigger('reload.MediaGallery');\n\n                return;\n            }\n\n            this.modal = $(content).modal($.extend({\n                title:  title || 'Insert File...',\n                modalClass: 'magento',\n                type: 'slide',\n                buttons: []\n            }, options));\n\n            this.modal.modal('openModal');\n\n            $.ajax({\n                url: url,\n                cache: false,\n                type: 'get',\n                context: $('body'),\n                showLoader: true\n\n            }).done(function (data) {\n                self.modal.html(data.replace('\"mediabrowser\"','\"MageBig_Shopbybrand/js/browser\"')).trigger('contentUpdated');\n                this.modalLoaded = true;\n                // this.setTargetElementId(options, url);\n                // this.setPathId(url);\n            }.bind(this));\n\n        },\n\n        /**\n         * Setter for endcoded path id\n         */\n        setPathId: function (url) {\n            this.pathId = url.match(/(&|\\/|%26)current_tree_path(=|\\/)([\\s\\S].*?)(\\/|$)/)[3];\n        },\n\n        /**\n         * Setter for targetElementId property\n         *\n         * @param {Object} options\n         * @param {String} url\n         */\n        setTargetElementId: function (options, url) {\n            this.targetElementId = options && options.targetElementId ?\n                options.targetElementId\n                : url.match(/\\/target_element_id\\/([\\s\\S].*?)\\//)[1];\n        },\n\n        /**\n         * Close dialog.\n         */\n        closeDialog: function () {\n            this.modal.modal('closeModal');\n        }\n    };\n\n    $.widget(\"custom.mbMediabrowser\", {\n        eventPrefix: \"mbMediabrowser\",\n        options: {\n            targetElementId: null,\n            contentsUrl: null,\n            onInsertUrl: null,\n            newFolderUrl: null,\n            deleteFolderUrl: null,\n            deleteFilesUrl: null,\n            headerText: null,\n            tree: null,\n            currentNode: null,\n            storeId: null,\n            showBreadcrumbs: null,\n            hidden: 'no-display'\n        },\n\n        /**\n         * Proxy creation\n         * @protected\n         */\n        _create: function () {\n            this._on({\n                'click [data-row=file]': 'selectFile',\n                'dblclick [data-row=file]': 'insert',\n                'click #new_folder': 'newFolder',\n                'click #delete_folder': 'deleteFolder',\n                'click #delete_files': 'deleteFiles',\n                'click #insert_files': 'insertSelectedFiles',\n                'fileuploaddone': '_uploadDone',\n                'click [data-row=breadcrumb]': 'selectFolder'\n            });\n\n            $(window).on('reload.MediaGallery', $.proxy(this.reload, this));\n            this.activeNode = null;\n            //tree dont use event bubbling\n            this.tree = this.element.find('[data-role=tree]');\n            this.tree.on('select_node.jstree', $.proxy(this._selectNode, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _selectNode: function (event, data) {\n            var node = data.node;\n\n            this.activeNode = node;\n            this.element.find('#delete_files, #insert_files').toggleClass(this.options.hidden, true);\n            this.element.find('#contents').toggleClass(this.options.hidden, false);\n            this.element.find('#delete_folder')\n                .toggleClass(this.options.hidden, node.id === 'root'); //eslint-disable-line eqeqeq\n            this.element.find('#content_header_text')\n                .html(node.id === 'root' ? this.headerText : node.text); //eslint-disable-line eqeqeq\n\n            this.drawBreadcrumbs(data);\n            this.loadFileList(node);\n        },\n\n        /**\n         * @return {*}\n         */\n        reload: function (uploaded) {\n            return this.loadFileList(this.activeNode, uploaded);\n        },\n\n        /**\n         * @param {Object} element\n         * @param {*} value\n         */\n        insertAtCursor: function (element, value) {\n            var sel, startPos, endPos, scrollTop;\n\n            if ('selection' in document) {\n                //For browsers like Internet Explorer\n                element.focus();\n                sel = document.selection.createRange();\n                sel.text = value;\n                element.focus();\n            } else if (element.selectionStart || element.selectionStart == '0') { //eslint-disable-line eqeqeq\n                //For browsers like Firefox and Webkit based\n                startPos = element.selectionStart;\n                endPos = element.selectionEnd;\n                scrollTop = element.scrollTop;\n                element.value = element.value.substring(0, startPos) + value +\n                    element.value.substring(startPos, endPos) + element.value.substring(endPos, element.value.length);\n                element.focus();\n                element.selectionStart = startPos + value.length;\n                element.selectionEnd = startPos + value.length + element.value.substring(startPos, endPos).length;\n                element.scrollTop = scrollTop;\n            } else {\n                element.value += value;\n                element.focus();\n            }\n        },\n\n        /**\n         * @param {Object} node\n         */\n        loadFileList: function (node, uploaded) {\n            var contentBlock = this.element.find('#contents');\n\n            return $.ajax({\n                url: this.options.contentsUrl,\n                type: 'GET',\n                dataType: 'html',\n                data: {\n                    'form_key': FORM_KEY,\n                    node: node.id\n                },\n                context: contentBlock,\n                showLoader: true\n            }).done(function (data) {\n                contentBlock.html(data).trigger('contentUpdated');\n\n                if (uploaded) {\n                    contentBlock.find('.filecnt:last').click();\n                }\n            });\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        selectFolder: function (event) {\n            this.element.find('[data-id=\"' + $(event.currentTarget).data('node').id + '\"]>a').click();\n        },\n\n        /**\n         * Insert selected files.\n         */\n        insertSelectedFiles: function () {\n            this.element.find('[data-row=file].selected').trigger('dblclick');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        selectFile: function (event) {\n            var fileRow = $(event.currentTarget);\n\n            fileRow.toggleClass('selected');\n            this.element.find('[data-row=file]').not(fileRow).removeClass('selected');\n            this.element.find('#delete_files, #insert_files')\n                .toggleClass(this.options.hidden, !fileRow.is('.selected'));\n            fileRow.trigger('selectfile');\n        },\n\n        /**\n         * @private\n         */\n        _uploadDone: function () {\n            this.element.find('.file-row').remove();\n            this.reload(true);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @return {Boolean}\n         */\n        insert: function (event) {\n            var fileRow = $(event.currentTarget),\n                targetEl;\n\n            if (!fileRow.prop('id')) {\n                return false;\n            }\n            targetEl = this.getTargetElement();\n\n            if (!targetEl.length) {\n                MbMediabrowserUtility.closeDialog();\n                throw \"Target element not found for content update\";\n            }\n\n            return $.ajax({\n                url: this.options.onInsertUrl,\n                data: {\n                    filename: fileRow.attr('id'),\n                    node: this.activeNode.id,\n                    store: this.options.storeId,\n                    'as_is': targetEl.is('textarea') ? 1 : 0,\n                    'force_static_path': 1,\n                    'form_key': FORM_KEY\n                },\n                context: this,\n                showLoader: true\n            }).done($.proxy(function(data) {\n                if (typeof data == 'string') {\n                    var img = data;\n                    var src = '';\n                    data = {};\n                    img.gsub(/\\{\\{media(.*?)\\}\\}/i, function (match) {\n                        data.full = match[0];\n                        match[0].gsub(/url=\\\"(.*?)\\\"/, function(url) {\n                            src = url[1];\n                        });\n                        match[0].gsub(/url=\\&quot;(.*?)\\&quot;/, function(url) {\n                            src = url[1];\n                        });\n                        data.short = src;\n                        data.full = MageBig.mediaUrl + data.short;\n                    });\n\n                    if (img.indexOf('/pub/media/') === 0) {\n                        src = img.replace('/pub/media/', '');\n                        data.short = src;\n                        data.full = MageBig.mediaUrl + data.short;\n                    } else if (img.indexOf('/media/') === 0) {\n                        src = img.replace('/media/', '');\n                        data.short = src;\n                        data.full = MageBig.mediaUrl + data.short;\n                    } else {\n                        src = $(img).attr('src');\n                        data.full = src;\n                        data.short = src.replace(MageBig.mediaUrl, \"\");\n                    }\n\n                }\n                if (targetEl.is('textarea')) {\n                    this.insertAtCursor(targetEl.get(0), data.short);\n                } else {\n                    targetEl.val(data.short).trigger('change');\n                }\n\t\t\t\ttargetEl.trigger('change');\n                MbMediabrowserUtility.closeDialog();\n                targetEl.focus();\n                targetEl.parents('.control').find('.attached_image img').attr('src', data.full);\n            }, this));\n        },\n\n        /**\n         * Find document target element in next order:\n         *  in acive file browser opener:\n         *  - input field with ID: \"src\" in opener window\n         *  - input field with ID: \"href\" in opener window\n         *  in document:\n         *  - element with target ID\n         *\n         * return HTMLelement | null\n         */\n        getTargetElement: function() {\n            if (typeof MbMediabrowserUtility.targetElement !== 'undefined') {\n                return MbMediabrowserUtility.targetElement;\n            } else {\n                if (typeof(tinyMCE) != 'undefined' && tinyMCE.get(this.options.targetElementId)) {\n                    var opener = this.getMediaBrowserOpener() || window;\n                    var targetElementId = tinyMceEditors.get(this.options.targetElementId).getMediaBrowserTargetElementId();\n                    return $(opener.document.getElementById(targetElementId));\n                } else {\n                    return $('#' + this.options.targetElementId);\n                }\n            }\n        },\n\n        /**\n         * Return opener Window object if it exists, not closed and editor is active\n         *\n         * return object | null\n         */\n        getMediaBrowserOpener: function() {\n            if (typeof(tinyMCE) != 'undefined'\n                && tinyMCE.get(this.options.targetElementId)\n                && typeof(tinyMceEditors) != 'undefined'\n                && !tinyMceEditors.get(this.options.targetElementId).getMediaBrowserOpener().closed) {\n                return tinyMceEditors.get(this.options.targetElementId).getMediaBrowserOpener();\n            } else {\n                return null;\n            }\n        },\n\n        /**\n         * New folder.\n         */\n        newFolder: function () {\n            var self = this;\n\n            prompt({\n                title: this.options.newFolderPrompt,\n                actions: {\n                    /**\n                     * @param {*} folderName\n                     */\n                    confirm: function (folderName) {\n                        $.ajax({\n                            url: self.options.newFolderUrl,\n                            dataType: 'json',\n                            data: {\n                                name: folderName,\n                                node: self.activeNode.id,\n                                store: self.options.storeId,\n                                'form_key': FORM_KEY\n                            },\n                            context: self.element,\n                            showLoader: true\n                        }).done($.proxy(function (data) {\n                            if (data.error) {\n                                alert({\n                                    content: data.message\n                                });\n                            } else {\n                                self.tree.jstree(\n                                    'refresh',\n                                    self.element.find('[data-id=\"' + self.activeNode.id + '\"]')\n                                );\n                            }\n                        }, this));\n\n                        return true;\n                    }\n                }\n            });\n        },\n\n        /**\n         * Delete folder.\n         */\n        deleteFolder: function () {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteFolderConfirmationMessage,\n                actions: {\n                    /**\n                     * Confirm.\n                     */\n                    confirm: function () {\n                        return $.ajax({\n                            url: self.options.deleteFolderUrl,\n                            dataType: 'json',\n                            data: {\n                                node: self.activeNode.id,\n                                store: self.options.storeId,\n                                'form_key': FORM_KEY\n                            },\n                            context: self.element,\n                            showLoader: true\n                        }).done($.proxy(function(data) {\n                            self.tree.jstree('refresh', self.activeNode.id);\n                        }, this));\n                    },\n\n                    /**\n                     * @return {Boolean}\n                     */\n                    cancel: function () {\n                        return false;\n                    }\n                }\n            });\n        },\n\n        /**\n         * Delete files.\n         */\n        deleteFiles: function () {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteFileConfirmationMessage,\n                actions: {\n                    /**\n                     * Confirm.\n                     */\n                    confirm: function () {\n                        var selectedFiles = self.element.find('[data-row=file].selected'),\n                            ids = selectedFiles.map(function () {\n                                return $(this).attr('id');\n                            }).toArray();\n\n                        return $.ajax({\n                            url: self.options.deleteFilesUrl,\n                            data: {\n                                files: ids,\n                                store: self.options.storeId,\n                                'form_key': FORM_KEY\n                            },\n                            context: self.element,\n                            showLoader: true\n                        }).done($.proxy(function () {\n                            self.reload();\n                        }, this));\n                    },\n\n                    /**\n                     * @return {Boolean}\n                     */\n                    cancel: function () {\n                        return false;\n                    }\n                }\n            });\n        },\n\n        /**\n         * @param {Object} data\n         */\n        drawBreadcrumbs: function (data) {\n            var node, breadcrumbs;\n\n            if (this.element.find('#breadcrumbs').length) {\n                this.element.find('#breadcrumbs').remove();\n            }\n            node = data.node;\n\n            if (node.id === 'root') { //eslint-disable-line eqeqeq\n                return;\n            }\n            breadcrumbs = $('<ul class=\"breadcrumbs\" id=\"breadcrumbs\"></ul>');\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            data.instance.get_path(node).each(function (name, index) {\n                if (index > 0) {\n                    breadcrumbs.append($('<li>\\/</li>')); //eslint-disable-line\n                }\n                breadcrumbs.append($('<li />').attr('data-row', 'breadcrumb').text(name));\n\n            });\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n            breadcrumbs.insertAfter(this.element.find('#content_header'));\n        }\n    });\n\treturn $.custom.mbMediabrowser;\n});\n","Magento_Swatches/js/text.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n *  @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'uiRegistry',\n    'jquery/ui',\n    'prototype',\n    'validation'\n], function (jQuery, mageTemplate, rg) {\n    'use strict';\n\n    return function (config) {\n        var swatchOptionTextDefaultInputType = 'radio',\n            swatchTextOption = {\n                table: $('swatch-text-options-table'),\n                itemCount: 0,\n                totalItems: 0,\n                rendered: 0,\n                isReadOnly: config.isReadOnly,\n                template: mageTemplate('#swatch-text-row-template'),\n\n                /**\n                 * Add option\n                 *\n                 * @param {Object} data\n                 * @param {Object} render\n                 */\n                add: function (data, render) {\n                    var isNewOption = false,\n                        element;\n\n                    if (typeof data.id == 'undefined') {\n                        data = {\n                            'id': 'option_' + this.itemCount,\n                            'sort_order': this.itemCount + 1\n                        };\n                        isNewOption = true;\n                    }\n\n                    if (!data.intype) {\n                        data.intype = swatchOptionTextDefaultInputType;\n                    }\n\n                    element = this.template({\n                        data: data\n                    });\n\n                    if (isNewOption && !this.isReadOnly) {\n                        this.enableNewOptionDeleteButton(data.id);\n                    }\n                    this.itemCount++;\n                    this.totalItems++;\n                    this.elements += element;\n\n                    if (render) {\n                        this.render();\n                    }\n                },\n\n                /**\n                 * Remove option\n                 *\n                 * @param {Object} event\n                 */\n                remove: function (event) {\n                    var element = $(Event.findElement(event, 'tr')),\n                        elementFlags; // !!! Button already have table parent in safari\n\n                    // Safari workaround\n                    element.ancestors().each(function (parentItem) {\n                        if (parentItem.hasClassName('option-row')) {\n                            element = parentItem;\n                            throw $break;\n                        } else if (parentItem.hasClassName('box')) {\n                            throw $break;\n                        }\n                    });\n\n                    if (element) {\n                        elementFlags = element.getElementsByClassName('delete-flag');\n\n                        if (elementFlags[0]) {\n                            elementFlags[0].value = 1;\n                        }\n\n                        element.addClassName('no-display');\n                        element.addClassName('template');\n                        element.hide();\n                        this.totalItems--;\n                        this.updateItemsCountField();\n                    }\n                },\n\n                /**\n                 * Update items count field\n                 */\n                updateItemsCountField: function () {\n                    $('swatch-text-option-count-check').value = this.totalItems > 0 ? '1' : '';\n                },\n\n                /**\n                 * Enable delete button for new option\n                 *\n                 * @param {String} id\n                 */\n                enableNewOptionDeleteButton: function (id) {\n                    $$('#delete_button_swatch_container_' + id + ' button').each(function (button) {\n                        button.enable();\n                        button.removeClassName('disabled');\n                    });\n                },\n\n                /**\n                 * Bind remove button\n                 */\n                bindRemoveButtons: function () {\n                    jQuery('#swatch-text-options-panel').on('click', '.delete-option', this.remove.bind(this));\n                },\n\n                /**\n                 * Render action\n                 */\n                render: function () {\n                    Element.insert($$('[data-role=swatch-text-options-container]')[0], this.elements);\n                    this.elements = '';\n                },\n\n                /**\n                 * Render action with delay (performance fix)\n                 *\n                 * @param {Object} data\n                 * @param {Number} from\n                 * @param {Number} step\n                 * @param {Number} delay\n                 * @returns {Boolean}\n                 */\n                renderWithDelay: function (data, from, step, delay) {\n                    var arrayLength = data.length,\n                        len;\n\n                    for (len = from + step; from < len && from < arrayLength; from++) {\n                        this.add(data[from]);\n                    }\n                    this.render();\n\n                    if (from === arrayLength) {\n                        this.updateItemsCountField();\n                        this.rendered = 1;\n                        jQuery('body').trigger('processStop');\n\n                        return true;\n                    }\n                    setTimeout(this.renderWithDelay.bind(this, data, from, step, delay), delay);\n                },\n\n                /**\n                 * Ignore validate action\n                 */\n                ignoreValidate: function () {\n                    var ignore = '.ignore-validate input, ' +\n                        '.ignore-validate select, ' +\n                        '.ignore-validate textarea';\n\n                    jQuery('#edit_form').data('validator').settings.forceIgnore = ignore;\n                }\n            };\n\n        if ($('add_new_swatch_text_option_button')) {\n            Event.observe(\n                'add_new_swatch_text_option_button',\n                'click',\n                swatchTextOption.add.bind(swatchTextOption, true)\n            );\n        }\n        jQuery('#swatch-text-options-panel').on('render', function () {\n            swatchTextOption.ignoreValidate();\n\n            if (swatchTextOption.rendered) {\n                return false;\n            }\n            jQuery('body').trigger('processStart');\n            swatchTextOption.renderWithDelay(config.attributesData, 0, 100, 300);\n            swatchTextOption.bindRemoveButtons();\n        });\n\n        if (config.isSortable) {\n            jQuery(function ($) {\n                $('[data-role=swatch-text-options-container]').sortable({\n                    distance: 8,\n                    tolerance: 'pointer',\n                    cancel: 'input, button',\n                    axis: 'y',\n\n                    /**\n                     * Update components\n                     */\n                    update: function () {\n                        $('[data-role=swatch-text-options-container] [data-role=order]').each(\n                            function (index, element) {\n                                $(element).val(index + 1);\n                            }\n                        );\n                    }\n                });\n            });\n        }\n\n        jQuery(function () {\n            if (jQuery('#frontend_input').val() !== 'swatch_text') {\n                jQuery('.swatch-text-field-0').removeClass('required-option');\n            }\n        });\n\n        window.swatchTextOption = swatchTextOption;\n        window.swatchOptionTextDefaultInputType = swatchOptionTextDefaultInputType;\n\n        rg.set('swatch-text-options-panel', swatchTextOption);\n    };\n});\n","Magento_Swatches/js/product-attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/prompt',\n    'uiRegistry',\n    'collapsable'\n], function ($, alert, prompt, rg) {\n    'use strict';\n\n    return function (optionConfig) {\n        var activePanelClass = 'selected-type-options',\n            swatchProductAttributes = {\n                frontendInput: $('#frontend_input'),\n                isFilterable: $('#is_filterable'),\n                isFilterableInSearch: $('#is_filterable_in_search'),\n                backendType: $('#backend_type'),\n                usedForSortBy: $('#used_for_sort_by'),\n                frontendClass: $('#frontend_class'),\n                isWysiwygEnabled: $('#is_wysiwyg_enabled'),\n                isHtmlAllowedOnFront: $('#is_html_allowed_on_front'),\n                isRequired: $('#is_required'),\n                isUnique: $('#is_unique'),\n                defaultValueText: $('#default_value_text'),\n                defaultValueTextarea: $('#default_value_textarea'),\n                defaultValueDate: $('#default_value_date'),\n                defaultValueDatetime: $('#default_value_datetime'),\n                defaultValueYesno: $('#default_value_yesno'),\n                isGlobal: $('#is_global'),\n                useProductImageForSwatch: $('#use_product_image_for_swatch'),\n                updateProductPreviewImage: $('#update_product_preview_image'),\n                usedInProductListing: $('#used_in_product_listing'),\n                isVisibleOnFront: $('#is_visible_on_front'),\n                position: $('#position'),\n                attrTabsFront: $('#product_attribute_tabs_front'),\n\n                /**\n                 * @returns {*|jQuery|HTMLElement}\n                 */\n                get tabsFront() {\n                    return this.attrTabsFront.length ? this.attrTabsFront.closest('li') : $('#front_fieldset-wrapper');\n                },\n                selectFields: ['boolean', 'select', 'multiselect', 'price', 'swatch_text', 'swatch_visual'],\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                toggleApplyVisibility: function (select) {\n                    if ($(select).val() === 1) {\n                        $(select).next('select').removeClass('no-display');\n                        $(select).next('select').removeClass('ignore-validate');\n                    } else {\n                        $(select).next('select').addClass('no-display');\n                        $(select).next('select').addClass('ignore-validate');\n                        $(select).next('select option:selected').each(function () {\n                            this.selected = false;\n                        });\n                    }\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                checkOptionsPanelVisibility: function () {\n                    var selectOptionsPanel = $('#manage-options-panel'),\n                        visualOptionsPanel = $('#swatch-visual-options-panel'),\n                        textOptionsPanel = $('#swatch-text-options-panel');\n\n                    this._hidePanel(selectOptionsPanel);\n                    this._hidePanel(visualOptionsPanel);\n                    this._hidePanel(textOptionsPanel);\n\n                    switch (this.frontendInput.val()) {\n                        case 'swatch_visual':\n                            this._showPanel(visualOptionsPanel);\n                            break;\n\n                        case 'swatch_text':\n                            this._showPanel(textOptionsPanel);\n                            break;\n\n                        case 'select':\n                        case 'multiselect':\n                            this._showPanel(selectOptionsPanel);\n                            break;\n                    }\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                bindAttributeInputType: function () {\n                    this.checkOptionsPanelVisibility();\n                    this.switchDefaultValueField();\n\n                    if (!~$.inArray(this.frontendInput.val(), this.selectFields)) {\n                        // not in array\n                        this.isFilterable.selectedIndex = 0;\n                        this._disable(this.isFilterable);\n                        this._disable(this.isFilterableInSearch);\n                    } else {\n                        // in array\n                        this._enable(this.isFilterable);\n                        this._enable(this.isFilterableInSearch);\n                        this.backendType.val('int');\n                    }\n\n                    if (this.frontendInput.val() === 'multiselect' ||\n                        this.frontendInput.val() === 'gallery' ||\n                        this.frontendInput.val() === 'textarea'\n                    ) {\n                        this._disable(this.usedForSortBy);\n                    } else {\n                        this._enable(this.usedForSortBy);\n                    }\n\n                    if (this.frontendInput.val() === 'swatch_text') {\n                        $('.swatch-text-field-0').addClass('required-option');\n                    } else {\n                        $('.swatch-text-field-0').removeClass('required-option');\n                    }\n\n                    this.setRowVisibility(this.isWysiwygEnabled, false);\n                    this.setRowVisibility(this.isHtmlAllowedOnFront, false);\n\n                    switch (this.frontendInput.val()) {\n                        case 'textarea':\n                            this.setRowVisibility(this.isWysiwygEnabled, true);\n\n                            if (this.isWysiwygEnabled.val() === '0') {\n                                this._enable(this.isHtmlAllowedOnFront);\n                            }\n                            this.frontendClass.val('');\n                            this._disable(this.frontendClass);\n                            break;\n\n                        case 'text':\n                            this.setRowVisibility(this.isHtmlAllowedOnFront, true);\n                            this._enable(this.frontendClass);\n                            break;\n\n                        case 'select':\n                        case 'multiselect':\n                            this.setRowVisibility(this.isHtmlAllowedOnFront, true);\n                            this.frontendClass.val('');\n                            this._disable(this.frontendClass);\n                            break;\n                        default:\n                            this.frontendClass.val('');\n                            this._disable(this.frontendClass);\n                    }\n\n                    this.switchIsFilterable();\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                switchIsFilterable: function () {\n                    if (this.isFilterable.selectedIndex === 0) {\n                        this._disable(this.position);\n                    } else {\n                        this._enable(this.position);\n                    }\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                switchDefaultValueField: function () {\n                    var currentValue = this.frontendInput.val(),\n                        defaultValueTextVisibility = false,\n                        defaultValueTextareaVisibility = false,\n                        defaultValueDateVisibility = false,\n                        defaultValueDatetimeVisibility = false,\n                        defaultValueYesnoVisibility = false,\n                        scopeVisibility = true,\n                        useProductImageForSwatch = false,\n                        defaultValueUpdateImage = false,\n                        optionDefaultInputType = '',\n                        isFrontTabHidden = false,\n                        thing = this;\n\n                    if (!this.frontendInput.length) {\n                        return;\n                    }\n\n                    switch (currentValue) {\n                        case 'select':\n                            optionDefaultInputType = 'radio';\n                            break;\n\n                        case 'multiselect':\n                            optionDefaultInputType = 'checkbox';\n                            break;\n\n                        case 'date':\n                            defaultValueDateVisibility = true;\n                            break;\n\n                        case 'datetime':\n                            defaultValueDatetimeVisibility = true;\n                            break;\n\n                        case 'boolean':\n                            defaultValueYesnoVisibility = true;\n                            break;\n\n                        case 'textarea':\n                        case 'texteditor':\n                            defaultValueTextareaVisibility = true;\n                            break;\n\n                        case 'media_image':\n                            defaultValueTextVisibility = false;\n                            break;\n\n                        case 'price':\n                            scopeVisibility = false;\n                            break;\n\n                        case 'swatch_visual':\n                            useProductImageForSwatch = true;\n                            defaultValueUpdateImage = true;\n                            defaultValueTextVisibility = false;\n                            break;\n\n                        case 'swatch_text':\n                            useProductImageForSwatch = false;\n                            defaultValueUpdateImage = true;\n                            defaultValueTextVisibility = false;\n                            break;\n                        default:\n                            defaultValueTextVisibility = true;\n                            break;\n                    }\n\n                    delete optionConfig.hiddenFields['swatch_visual'];\n                    delete optionConfig.hiddenFields['swatch_text'];\n\n                    if (currentValue === 'media_image') {\n                        this.tabsFront.hide();\n                        this.setRowVisibility(this.isRequired, false);\n                        this.setRowVisibility(this.isUnique, false);\n                        this.setRowVisibility(this.frontendClass, false);\n                    } else if (optionConfig.hiddenFields[currentValue]) {\n                        $.each(optionConfig.hiddenFields[currentValue], function (key, option) {\n                            switch (option) {\n                                case '_front_fieldset':\n                                    thing.tabsFront.hide();\n                                    isFrontTabHidden = true;\n                                    break;\n\n                                case '_default_value':\n                                    defaultValueTextVisibility = false;\n                                    defaultValueTextareaVisibility = false;\n                                    defaultValueDateVisibility = false;\n                                    defaultValueDatetimeVisibility = false;\n                                    defaultValueYesnoVisibility = false;\n                                    break;\n\n                                case '_scope':\n                                    scopeVisibility = false;\n                                    break;\n                                default:\n                                    thing.setRowVisibility($('#' + option), false);\n                            }\n                        });\n\n                        if (!isFrontTabHidden) {\n                            thing.tabsFront.show();\n                        }\n\n                    } else {\n                        this.tabsFront.show();\n                        this.showDefaultRows();\n                    }\n\n                    this.setRowVisibility(this.defaultValueText, defaultValueTextVisibility);\n                    this.setRowVisibility(this.defaultValueTextarea, defaultValueTextareaVisibility);\n                    this.setRowVisibility(this.defaultValueDate, defaultValueDateVisibility);\n                    this.setRowVisibility(this.defaultValueDatetime, defaultValueDatetimeVisibility);\n                    this.setRowVisibility(this.defaultValueYesno, defaultValueYesnoVisibility);\n                    this.setRowVisibility(this.isGlobal, scopeVisibility);\n\n                    /* swatch attributes */\n                    this.setRowVisibility(this.useProductImageForSwatch, useProductImageForSwatch);\n                    this.setRowVisibility(this.updateProductPreviewImage, defaultValueUpdateImage);\n\n                    $('input[name=\\'default[]\\']').each(function () {\n                        $(this).attr('type', optionDefaultInputType);\n                    });\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                showDefaultRows: function () {\n                    this.setRowVisibility(this.isRequired, true);\n                    this.setRowVisibility(this.isUnique, true);\n                    this.setRowVisibility(this.frontendClass, true);\n                },\n\n                /**\n                 * @param {Object} el\n                 * @param {Boolean} isVisible\n                 * @this {swatchProductAttributes}\n                 */\n                setRowVisibility: function (el, isVisible) {\n                    if (isVisible) {\n                        el.show();\n                        el.closest('.field').show();\n                    } else {\n                        el.hide();\n                        el.closest('.field').hide();\n                    }\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _disable: function (el) {\n                    el.attr('disabled', 'disabled');\n                },\n\n                /**\n                 * @param {jQuery} el\n                 * @this {swatchProductAttributes}\n                 */\n                _enable: function (el) {\n                    if (!el.attr('readonly')) {\n                        el.prop('disabled', false);\n                    }\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _showPanel: function (el) {\n                    el.closest('.fieldset').show();\n                    el.addClass(activePanelClass);\n                    this._render(el.attr('id'));\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _hidePanel: function (el) {\n                    el.closest('.fieldset').hide();\n                    el.removeClass(activePanelClass);\n                },\n\n                /**\n                 * @param {String} id\n                 * @this {swatchProductAttributes}\n                 */\n                _render: function (id) {\n                    rg.get(id, function () {\n                        $('#' + id).trigger('render');\n                    });\n                },\n\n                /**\n                 * @param {String} promptMessage\n                 * @this {swatchProductAttributes}\n                 */\n                saveAttributeInNewSet: function (promptMessage) {\n\n                    prompt({\n                        content: promptMessage,\n                        actions: {\n\n                            /**\n                             * @param {String} val\n                             * @this {actions}\n                             */\n                            confirm: function (val) {\n                                var rules = ['required-entry', 'validate-no-html-tags'],\n                                    newAttributeSetNameInputId = $('#new_attribute_set_name'),\n                                    editForm = $('#edit_form'),\n                                    newAttributeSetName = val,\n                                    i;\n\n                                if (!newAttributeSetName) {\n                                    return;\n                                }\n\n                                for (i = 0; i < rules.length; i++) {\n                                    if (!$.validator.methods[rules[i]](newAttributeSetName)) {\n                                        alert({\n                                            content: $.validator.messages[rules[i]]\n                                        });\n\n                                        return;\n                                    }\n                                }\n\n                                if (newAttributeSetNameInputId.length) {\n                                    newAttributeSetNameInputId.val(newAttributeSetName);\n                                } else {\n                                    editForm.append(new Element('input', {\n                                            type: 'hidden',\n                                            id: newAttributeSetNameInputId,\n                                            name: 'new_attribute_set_name',\n                                            value: newAttributeSetName\n                                        })\n                                    );\n                                }\n                                // Temporary solution will replaced after refactoring of attributes functionality\n                                editForm.triggerHandler('save');\n                            }\n                        }\n                    });\n                }\n            };\n\n        $(function () {\n            var editForm = $('#edit_form'),\n                swatchVisualPanel = $('#swatch-visual-options-panel'),\n                swatchTextPanel = $('#swatch-text-options-panel'),\n                tableBody = $(),\n                activePanel = $();\n\n            $('#frontend_input').on('change', function () {\n                swatchProductAttributes.bindAttributeInputType();\n            });\n            $('#is_filterable').on('change', function () {\n                swatchProductAttributes.switchIsFilterable();\n            });\n\n            swatchProductAttributes.bindAttributeInputType();\n\n            // @todo: refactor collapsible component\n            $('.attribute-popup .collapse, [data-role=\"advanced_fieldset-content\"]')\n                .collapsable()\n                .collapse('hide');\n\n            editForm.on('beforeSubmit', function () {\n                var optionContainer, optionsValues;\n\n                activePanel = swatchTextPanel.hasClass(activePanelClass) ? swatchTextPanel : swatchVisualPanel;\n                optionContainer = activePanel.find('table tbody');\n\n                if (activePanel.hasClass(activePanelClass)) {\n                    optionsValues = $.map(\n                        optionContainer.find('tr'),\n                        function (row) {\n                            return $(row).find('input, select, textarea').serialize();\n                        }\n                    );\n                    $('<input>')\n                        .attr({\n                            type: 'hidden',\n                            name: 'serialized_options'\n                        })\n                        .val(JSON.stringify(optionsValues))\n                        .prependTo(editForm);\n                }\n\n                tableBody = optionContainer.detach();\n            });\n\n            editForm.on('afterValidate.error highlight.validate', function () {\n                if (activePanel.hasClass(activePanelClass)) {\n                    activePanel.find('table').append(tableBody);\n                    $('input[name=\"serialized_options\"]').remove();\n                }\n            });\n        });\n\n        window.saveAttributeInNewSet = swatchProductAttributes.saveAttributeInNewSet;\n        window.toggleApplyVisibility = swatchProductAttributes.toggleApplyVisibility;\n    };\n});\n","Magento_Swatches/js/swatch-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'mage/smart-keyboard-handler',\n    'mage/translate',\n    'priceUtils',\n    'jquery-ui-modules/widget',\n    'jquery/jquery.parsequery',\n    'mage/validation/validation'\n], function ($, _, mageTemplate, keyboardHandler, $t, priceUtils) {\n    'use strict';\n\n    /**\n     * Extend form validation to support swatch accessibility\n     */\n    $.widget('mage.validation', $.mage.validation, {\n        /**\n         * Handle form with swatches validation. Focus on first invalid swatch block.\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} validation\n         */\n        listenFormValidateHandler: function (event, validation) {\n            var swatchWrapper, firstActive, swatches, swatch, successList, errorList, firstSwatch;\n\n            this._superApply(arguments);\n\n            swatchWrapper = '.swatch-attribute-options';\n            swatches = $(event.target).find(swatchWrapper);\n\n            if (!swatches.length) {\n                return;\n            }\n\n            swatch = '.swatch-attribute';\n            firstActive = $(validation.errorList[0].element || []);\n            successList = validation.successList;\n            errorList = validation.errorList;\n            firstSwatch = $(firstActive).parent(swatch).find(swatchWrapper);\n\n            keyboardHandler.focus(swatches);\n\n            $.each(successList, function (index, item) {\n                $(item).parent(swatch).find(swatchWrapper).attr('aria-invalid', false);\n            });\n\n            $.each(errorList, function (index, item) {\n                $(item.element).parent(swatch).find(swatchWrapper).attr('aria-invalid', true);\n            });\n\n            if (firstSwatch.length) {\n                $(firstSwatch).trigger('focus');\n            }\n        }\n    });\n\n    /**\n     * Render tooltips by attributes (only to up).\n     * Required element attributes:\n     *  - data-option-type (integer, 0-3)\n     *  - data-option-label (string)\n     *  - data-option-tooltip-thumb\n     *  - data-option-tooltip-value\n     *  - data-thumb-width\n     *  - data-thumb-height\n     */\n    $.widget('mage.SwatchRendererTooltip', {\n        options: {\n            delay: 200,                             //how much ms before tooltip to show\n            tooltipClass: 'swatch-option-tooltip'  //configurable, but remember about css\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            var $widget = this,\n                $this = this.element,\n                $element = $('.' + $widget.options.tooltipClass),\n                timer,\n                type = parseInt($this.data('option-type'), 10),\n                label = $this.data('option-label'),\n                thumb = $this.data('option-tooltip-thumb'),\n                value = $this.data('option-tooltip-value'),\n                width = $this.data('thumb-width'),\n                height = $this.data('thumb-height'),\n                $image,\n                $title,\n                $corner;\n\n            if (!$element.length) {\n                $element = $('<div class=\"' +\n                    $widget.options.tooltipClass +\n                    '\"><div class=\"image\"></div><div class=\"title\"></div><div class=\"corner\"></div></div>'\n                );\n                $('body').append($element);\n            }\n\n            $image = $element.find('.image');\n            $title = $element.find('.title');\n            $corner = $element.find('.corner');\n\n            $this.on('mouseenter', function () {\n                if (!$this.hasClass('disabled')) {\n                    timer = setTimeout(\n                        function () {\n                            var leftOpt = null,\n                                leftCorner = 0,\n                                left,\n                                $window;\n\n                            if (type === 2) {\n                                // Image\n                                $image.css({\n                                    'background': 'url(\"' + thumb + '\") no-repeat center', //Background case\n                                    'background-size': 'initial',\n                                    'width': width + 'px',\n                                    'height': height + 'px'\n                                });\n                                $image.show();\n                            } else if (type === 1) {\n                                // Color\n                                $image.css({\n                                    background: value\n                                });\n                                $image.show();\n                            } else if (type === 0 || type === 3) {\n                                // Default\n                                $image.hide();\n                            }\n\n                            $title.text(label);\n\n                            leftOpt = $this.offset().left;\n                            left = leftOpt + $this.width() / 2 - $element.width() / 2;\n                            $window = $(window);\n\n                            // the numbers (5 and 5) is magick constants for offset from left or right page\n                            if (left < 0) {\n                                left = 5;\n                            } else if (left + $element.width() > $window.width()) {\n                                left = $window.width() - $element.width() - 5;\n                            }\n\n                            // the numbers (6,  3 and 18) is magick constants for offset tooltip\n                            leftCorner = 0;\n\n                            if ($element.width() < $this.width()) {\n                                leftCorner = $element.width() / 2 - 3;\n                            } else {\n                                leftCorner = (leftOpt > left ? leftOpt - left : left - leftOpt) + $this.width() / 2 - 6;\n                            }\n\n                            $corner.css({\n                                left: leftCorner\n                            });\n                            $element.css({\n                                left: left,\n                                top: $this.offset().top - $element.height() - $corner.height() - 18\n                            }).show();\n                        },\n                        $widget.options.delay\n                    );\n                }\n            });\n\n            $this.on('mouseleave', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $(document).on('tap', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $this.on('tap', function (event) {\n                event.stopPropagation();\n            });\n        }\n    });\n\n    /**\n     * Render swatch controls with options and use tooltips.\n     * Required two json:\n     *  - jsonConfig (magento's option config)\n     *  - jsonSwatchConfig (swatch's option config)\n     *\n     *  Tuning:\n     *  - numberToShow (show \"more\" button if options are more)\n     *  - onlySwatches (hide selectboxes)\n     *  - moreButtonText (text for \"more\" button)\n     *  - selectorProduct (selector for product container)\n     *  - selectorProductPrice (selector for change price)\n     */\n    $.widget('mage.SwatchRenderer', {\n        options: {\n            classes: {\n                attributeClass: 'swatch-attribute',\n                attributeLabelClass: 'swatch-attribute-label',\n                attributeSelectedOptionLabelClass: 'swatch-attribute-selected-option',\n                attributeOptionsWrapper: 'swatch-attribute-options',\n                attributeInput: 'swatch-input',\n                optionClass: 'swatch-option',\n                selectClass: 'swatch-select',\n                moreButton: 'swatch-more',\n                loader: 'swatch-option-loading'\n            },\n            // option's json config\n            jsonConfig: {},\n\n            // swatch's json config\n            jsonSwatchConfig: {},\n\n            // selector of parental block of prices and swatches (need to know where to seek for price block)\n            selectorProduct: '.product-info-main',\n\n            // selector of price wrapper (need to know where set price)\n            selectorProductPrice: '[data-role=priceBox]',\n\n            //selector of product images gallery wrapper\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n\n            // selector of category product tile wrapper\n            selectorProductTile: '.product-item',\n\n            // number of controls to show (false or zero = show all)\n            numberToShow: false,\n\n            // show only swatch controls\n            onlySwatches: false,\n\n            // enable label for control\n            enableControlLabel: true,\n\n            // control label id\n            controlLabelId: '',\n\n            // text for more button\n            moreButtonText: $t('More'),\n\n            // Callback url for media\n            mediaCallback: '',\n\n            // Local media cache\n            mediaCache: {},\n\n            // Cache for BaseProduct images. Needed when option unset\n            mediaGalleryInitial: [{}],\n\n            // Use ajax to get image data\n            useAjax: false,\n\n            /**\n             * Defines the mechanism of how images of a gallery should be\n             * updated when user switches between configurations of a product.\n             *\n             * As for now value of this option can be either 'replace' or 'prepend'.\n             *\n             * @type {String}\n             */\n            gallerySwitchStrategy: 'replace',\n\n            // whether swatches are rendered in product list or on product page\n            inProductList: false,\n\n            // sly-old-price block selector\n            slyOldPriceSelector: '.sly-old-price',\n\n            // tier prise selectors start\n            tierPriceTemplateSelector: '#tier-prices-template',\n            tierPriceBlockSelector: '[data-role=\"tier-price-block\"]',\n            tierPriceTemplate: '',\n            // tier prise selectors end\n\n            // A price label selector\n            normalPriceLabelSelector: '.product-info-main .normal-price .price-label',\n            qtyInfo: '#qty'\n        },\n\n        /**\n         * Get chosen product\n         *\n         * @returns int|null\n         */\n        getProduct: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) ? products[0] : null;\n        },\n\n        /**\n         * Get chosen product id\n         *\n         * @returns int|null\n         */\n        getProductId: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) && products.length === 1 ? products[0] : null;\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            // Don't render the same set of swatches twice\n            if ($(this.element).attr('data-rendered')) {\n                return;\n            }\n\n            $(this.element).attr('data-rendered', true);\n\n            if (_.isEmpty(this.options.jsonConfig.images)) {\n                this.options.useAjax = true;\n                // creates debounced variant of _LoadProductMedia()\n                // to use it in events handlers instead of _LoadProductMedia()\n                this._debouncedLoadProductMedia = _.debounce(this._LoadProductMedia.bind(this), 500);\n            }\n\n            this.options.tierPriceTemplate = $(this.options.tierPriceTemplateSelector).html();\n\n            if (this.options.jsonConfig !== '' && this.options.jsonSwatchConfig !== '') {\n                // store unsorted attributes\n                this.options.jsonConfig.mappedAttributes = _.clone(this.options.jsonConfig.attributes);\n                this._sortAttributes();\n                this._RenderControls();\n                this._setPreSelectedGallery();\n                $(this.element).trigger('swatch.initialized');\n            } else {\n                console.log('SwatchRenderer: No input data received');\n            }\n        },\n\n        /**\n         * @private\n         */\n        _sortAttributes: function () {\n            this.options.jsonConfig.attributes = _.sortBy(this.options.jsonConfig.attributes, function (attribute) {\n                return parseInt(attribute.position, 10);\n            });\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            var options = this.options,\n                gallery = $('[data-gallery-role=gallery-placeholder]', '.column.main'),\n                productData = this._determineProductData(),\n                $main = productData.isInProductView ?\n                    this.element.parents('.column.main') :\n                    this.element.parents('.product-item-info');\n\n            if (productData.isInProductView) {\n                gallery.data('gallery') ?\n                    this._onGalleryLoaded(gallery) :\n                    gallery.on('gallery:loaded', this._onGalleryLoaded.bind(this, gallery));\n            } else {\n                options.mediaGalleryInitial = [{\n                    'img': $main.find('.product-image-photo').attr('src')\n                }];\n            }\n\n            this.productForm = this.element.parents(this.options.selectorProductTile).find('form:first');\n            this.inProductList = this.productForm.length > 0;\n            $(this.options.qtyInfo).on('input', this._onQtyChanged.bind(this));\n        },\n\n        /**\n         * Determine product id and related data\n         *\n         * @returns {{productId: *, isInProductView: bool}}\n         * @private\n         */\n        _determineProductData: function () {\n            // Check if product is in a list of products.\n            var productId,\n                isInProductView = false;\n\n            productId = this.element.parents('.product-item-details')\n                    .find('.price-box.price-final_price').attr('data-product-id');\n\n            if (!productId) {\n                // Check individual product.\n                productId = $('[name=product]').val();\n                isInProductView = productId > 0;\n            }\n\n            return {\n                productId: productId,\n                isInProductView: isInProductView\n            };\n        },\n\n        /**\n         * Render controls\n         *\n         * @private\n         */\n        _RenderControls: function () {\n            var $widget = this,\n                container = this.element,\n                classes = this.options.classes,\n                chooseText = this.options.jsonConfig.chooseText,\n                showTooltip = this.options.showTooltip;\n\n            $widget.optionsMap = {};\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                var item = this,\n                    controlLabelId = 'option-label-' + item.code + '-' + item.id,\n                    options = $widget._RenderSwatchOptions(item, controlLabelId),\n                    select = $widget._RenderSwatchSelect(item, chooseText),\n                    input = $widget._RenderFormInput(item),\n                    listLabel = '',\n                    label = '';\n\n                // Show only swatch controls\n                if ($widget.options.onlySwatches && !$widget.options.jsonSwatchConfig.hasOwnProperty(item.id)) {\n                    return;\n                }\n\n                if ($widget.options.enableControlLabel) {\n                    label +=\n                        '<span id=\"' + controlLabelId + '\" class=\"' + classes.attributeLabelClass + '\">' +\n                        $('<i></i>').text(item.label).html() +\n                        '</span>' +\n                        '<span class=\"' + classes.attributeSelectedOptionLabelClass + '\"></span>';\n                }\n\n                if ($widget.inProductList) {\n                    $widget.productForm.append(input);\n                    input = '';\n                    listLabel = 'aria-label=\"' + $('<i></i>').text(item.label).html() + '\"';\n                } else {\n                    listLabel = 'aria-labelledby=\"' + controlLabelId + '\"';\n                }\n\n                // Create new control\n                container.append(\n                    '<div class=\"' + classes.attributeClass + ' ' + item.code + '\" ' +\n                         'data-attribute-code=\"' + item.code + '\" ' +\n                         'data-attribute-id=\"' + item.id + '\">' +\n                        label +\n                        '<div aria-activedescendant=\"\" ' +\n                             'tabindex=\"0\" ' +\n                             'aria-invalid=\"false\" ' +\n                             'aria-required=\"true\" ' +\n                             'role=\"listbox\" ' + listLabel +\n                             'class=\"' + classes.attributeOptionsWrapper + ' clearfix\">' +\n                            options + select +\n                        '</div>' + input +\n                    '</div>'\n                );\n\n                $widget.optionsMap[item.id] = {};\n\n                // Aggregate options array to hash (key => value)\n                $.each(item.options, function () {\n                    if (this.products.length > 0) {\n                        $widget.optionsMap[item.id][this.id] = {\n                            price: parseInt(\n                                $widget.options.jsonConfig.optionPrices[this.products[0]].finalPrice.amount,\n                                10\n                            ),\n                            products: this.products\n                        };\n                    }\n                });\n            });\n\n            if (showTooltip === 1) {\n                // Connect Tooltip\n                container\n                    .find('[data-option-type=\"1\"], [data-option-type=\"2\"],' +\n                        ' [data-option-type=\"0\"], [data-option-type=\"3\"]')\n                    .SwatchRendererTooltip();\n            }\n\n            // Hide all elements below more button\n            $('.' + classes.moreButton).nextAll().hide();\n\n            // Handle events like click or change\n            $widget._EventListener();\n\n            // Rewind options\n            $widget._Rewind(container);\n\n            //Emulate click on all swatches from Request\n            $widget._EmulateSelected($.parseQuery());\n            $widget._EmulateSelected($widget._getSelectedAttributes());\n        },\n\n        /**\n         * Render swatch options by part of config\n         *\n         * @param {Object} config\n         * @param {String} controlId\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchOptions: function (config, controlId) {\n            var optionConfig = this.options.jsonSwatchConfig[config.id],\n                optionClass = this.options.classes.optionClass,\n                sizeConfig = this.options.jsonSwatchImageSizeConfig,\n                moreLimit = parseInt(this.options.numberToShow, 10),\n                moreClass = this.options.classes.moreButton,\n                moreText = this.options.moreButtonText,\n                countAttributes = 0,\n                html = '';\n\n            if (!this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            $.each(config.options, function (index) {\n                var id,\n                    type,\n                    value,\n                    thumb,\n                    label,\n                    width,\n                    height,\n                    attr,\n                    swatchImageWidth,\n                    swatchImageHeight;\n\n                if (!optionConfig.hasOwnProperty(this.id)) {\n                    return '';\n                }\n\n                // Add more button\n                if (moreLimit === countAttributes++) {\n                    html += '<a href=\"#\" class=\"' + moreClass + '\"><span>' + moreText + '</span></a>';\n                }\n\n                id = this.id;\n                type = parseInt(optionConfig[id].type, 10);\n                value = optionConfig[id].hasOwnProperty('value') ?\n                    $('<i></i>').text(optionConfig[id].value).html() : '';\n                thumb = optionConfig[id].hasOwnProperty('thumb') ? optionConfig[id].thumb : '';\n                width = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.width : 110;\n                height = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.height : 90;\n                label = this.label ? $('<i></i>').text(this.label).html() : '';\n                attr =\n                    ' id=\"' + controlId + '-item-' + id + '\"' +\n                    ' index=\"' + index + '\"' +\n                    ' aria-checked=\"false\"' +\n                    ' aria-describedby=\"' + controlId + '\"' +\n                    ' tabindex=\"0\"' +\n                    ' data-option-type=\"' + type + '\"' +\n                    ' data-option-id=\"' + id + '\"' +\n                    ' data-option-label=\"' + label + '\"' +\n                    ' aria-label=\"' + label + '\"' +\n                    ' role=\"option\"' +\n                    ' data-thumb-width=\"' + width + '\"' +\n                    ' data-thumb-height=\"' + height + '\"';\n\n                attr += thumb !== '' ? ' data-option-tooltip-thumb=\"' + thumb + '\"' : '';\n                attr += value !== '' ? ' data-option-tooltip-value=\"' + value + '\"' : '';\n\n                swatchImageWidth = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.width : 30;\n                swatchImageHeight = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.height : 20;\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                if (type === 0) {\n                    // Text\n                    html += '<div class=\"' + optionClass + ' text\" ' + attr + '>' + (value ? value : label) +\n                        '</div>';\n                } else if (type === 1) {\n                    // Color\n                    html += '<div class=\"' + optionClass + ' color\" ' + attr +\n                        ' style=\"background: ' + value +\n                        ' no-repeat center; background-size: initial;\">' + '' +\n                        '</div>';\n                } else if (type === 2) {\n                    // Image\n                    html += '<div class=\"' + optionClass + ' image\" ' + attr +\n                        ' style=\"background: url(' + value + ') no-repeat center; background-size: initial;width:' +\n                        swatchImageWidth + 'px; height:' + swatchImageHeight + 'px\">' + '' +\n                        '</div>';\n                } else if (type === 3) {\n                    // Clear\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '></div>';\n                } else {\n                    // Default\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '>' + label + '</div>';\n                }\n            });\n\n            return html;\n        },\n\n        /**\n         * Render select by part of config\n         *\n         * @param {Object} config\n         * @param {String} chooseText\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchSelect: function (config, chooseText) {\n            var html;\n\n            if (this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            html =\n                '<select class=\"' + this.options.classes.selectClass + ' ' + config.code + '\">' +\n                '<option value=\"0\" data-option-id=\"0\">' + chooseText + '</option>';\n\n            $.each(config.options, function () {\n                var label = this.label,\n                    attr = ' value=\"' + this.id + '\" data-option-id=\"' + this.id + '\"';\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                html += '<option ' + attr + '>' + label + '</option>';\n            });\n\n            html += '</select>';\n\n            return html;\n        },\n\n        /**\n         * Input for submit form.\n         * This control shouldn't have \"type=hidden\", \"display: none\" for validation work :(\n         *\n         * @param {Object} config\n         * @private\n         */\n        _RenderFormInput: function (config) {\n            return '<input class=\"' + this.options.classes.attributeInput + ' super-attribute-select\" ' +\n                'name=\"super_attribute[' + config.id + ']\" ' +\n                'type=\"text\" ' +\n                'value=\"\" ' +\n                'data-selector=\"super_attribute[' + config.id + ']\" ' +\n                'data-validate=\"{required: true}\" ' +\n                'aria-required=\"true\" ' +\n                'aria-invalid=\"false\">';\n        },\n\n        /**\n         * Event listener\n         *\n         * @private\n         */\n        _EventListener: function () {\n            var $widget = this,\n                options = this.options.classes,\n                target;\n\n            $widget.element.on('click', '.' + options.optionClass, function () {\n                return $widget._OnClick($(this), $widget);\n            });\n\n            $widget.element.on('change', '.' + options.selectClass, function () {\n                return $widget._OnChange($(this), $widget);\n            });\n\n            $widget.element.on('click', '.' + options.moreButton, function (e) {\n                e.preventDefault();\n\n                return $widget._OnMoreClick($(this));\n            });\n\n            $widget.element.on('keydown', function (e) {\n                if (e.which === 13) {\n                    target = $(e.target);\n\n                    if (target.is('.' + options.optionClass)) {\n                        return $widget._OnClick(target, $widget);\n                    } else if (target.is('.' + options.selectClass)) {\n                        return $widget._OnChange(target, $widget);\n                    } else if (target.is('.' + options.moreButton)) {\n                        e.preventDefault();\n\n                        return $widget._OnMoreClick(target);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Load media gallery using ajax or json config.\n         *\n         * @private\n         */\n        _loadMedia: function () {\n            var $main = this.inProductList ?\n                    this.element.parents('.product-item-info') :\n                    this.element.parents('.column.main'),\n                images;\n\n            if (this.options.useAjax) {\n                this._debouncedLoadProductMedia();\n            }  else {\n                images = this.options.jsonConfig.images[this.getProduct()];\n\n                if (!images) {\n                    images = this.options.mediaGalleryInitial;\n                }\n                this.updateBaseImage(this._sortImages(images), $main, !this.inProductList);\n            }\n        },\n\n        /**\n         * Sorting images array\n         *\n         * @private\n         */\n        _sortImages: function (images) {\n            return _.sortBy(images, function (image) {\n                return parseInt(image.position, 10);\n            });\n        },\n\n        /**\n         * Event for swatch options\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnClick: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                $wrapper = $this.parents('.' + $widget.options.classes.attributeOptionsWrapper),\n                $label = $parent.find('.' + $widget.options.classes.attributeSelectedOptionLabelClass),\n                attributeId = $parent.data('attribute-id'),\n                $input = $parent.find('.' + $widget.options.classes.attributeInput),\n                checkAdditionalData = JSON.parse(this.options.jsonSwatchConfig[attributeId]['additional_data']),\n                $priceBox = $widget.element.parents($widget.options.selectorProduct)\n                    .find(this.options.selectorProductPrice);\n\n            if ($widget.inProductList) {\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n            }\n\n            if ($this.hasClass('disabled')) {\n                return;\n            }\n\n            if ($this.hasClass('selected')) {\n                $parent.removeAttr('data-option-selected').find('.selected').removeClass('selected');\n                $input.val('');\n                $label.text('');\n                $this.attr('aria-checked', false);\n            } else {\n                $parent.attr('data-option-selected', $this.data('option-id')).find('.selected').removeClass('selected');\n                $label.text($this.data('option-label'));\n                $input.val($this.data('option-id'));\n                $input.attr('data-attr-name', this._getAttributeCodeById(attributeId));\n                $this.addClass('selected');\n                $widget._toggleCheckedAttributes($this, $wrapper);\n            }\n\n            $widget._Rebuild();\n\n            if ($priceBox.is(':data(mage-priceBox)')) {\n                $widget._UpdatePrice();\n            }\n\n            $(document).trigger('updateMsrpPriceBlock',\n                [\n                    this._getSelectedOptionPriceIndex(),\n                    $widget.options.jsonConfig.optionPrices,\n                    $priceBox\n                ]);\n\n            if (parseInt(checkAdditionalData['update_product_preview_image'], 10) === 1) {\n                $widget._loadMedia();\n            }\n\n            $input.trigger('change');\n        },\n\n        /**\n         * Get selected option price index\n         *\n         * @return {String|undefined}\n         * @private\n         */\n        _getSelectedOptionPriceIndex: function () {\n            var allowedProduct = this._getAllowedProductWithMinPrice(this._CalcProducts());\n\n            if (_.isEmpty(allowedProduct)) {\n                return undefined;\n            }\n\n            return allowedProduct;\n        },\n\n        /**\n         * Get human readable attribute code (eg. size, color) by it ID from configuration\n         *\n         * @param {Number} attributeId\n         * @returns {*}\n         * @private\n         */\n        _getAttributeCodeById: function (attributeId) {\n            var attribute = this.options.jsonConfig.mappedAttributes[attributeId];\n\n            return attribute ? attribute.code : attributeId;\n        },\n\n        /**\n         * Toggle accessibility attributes\n         *\n         * @param {Object} $this\n         * @param {Object} $wrapper\n         * @private\n         */\n        _toggleCheckedAttributes: function ($this, $wrapper) {\n            $wrapper.attr('aria-activedescendant', $this.attr('id'))\n                    .find('.' + this.options.classes.optionClass).attr('aria-checked', false);\n            $this.attr('aria-checked', true);\n        },\n\n        /**\n         * Event for select\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnChange: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                attributeId = $parent.data('attribute-id'),\n                $input = $parent.find('.' + $widget.options.classes.attributeInput);\n\n            if ($widget.productForm.length > 0) {\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n            }\n\n            if ($this.val() > 0) {\n                $parent.attr('data-option-selected', $this.val());\n                $input.val($this.val());\n            } else {\n                $parent.removeAttr('data-option-selected');\n                $input.val('');\n            }\n\n            $widget._Rebuild();\n            $widget._UpdatePrice();\n            $widget._loadMedia();\n            $input.trigger('change');\n        },\n\n        /**\n         * Event for more switcher\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _OnMoreClick: function ($this) {\n            $this.nextAll().show();\n            $this.trigger('blur').remove();\n        },\n\n        /**\n         * Rewind options for controls\n         *\n         * @private\n         */\n        _Rewind: function (controls) {\n            controls.find('div[data-option-id], option[data-option-id]')\n                .removeClass('disabled')\n                .prop('disabled', false);\n            controls.find('div[data-option-empty], option[data-option-empty]')\n                .attr('disabled', true)\n                .addClass('disabled')\n                .attr('tabindex', '-1');\n        },\n\n        /**\n         * Rebuild container\n         *\n         * @private\n         */\n        _Rebuild: function () {\n            var $widget = this,\n                controls = $widget.element.find('.' + $widget.options.classes.attributeClass + '[data-attribute-id]'),\n                selected = controls.filter('[data-option-selected]');\n\n            // Enable all options\n            $widget._Rewind(controls);\n\n            // done if nothing selected\n            if (selected.length <= 0) {\n                return;\n            }\n\n            // Disable not available options\n            controls.each(function () {\n                var $this = $(this),\n                    id = $this.data('attribute-id'),\n                    products = $widget._CalcProducts(id);\n\n                if (selected.length === 1 && selected.first().data('attribute-id') === id) {\n                    return;\n                }\n\n                $this.find('[data-option-id]').each(function () {\n                    var $element = $(this),\n                        option = $element.data('option-id');\n\n                    if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option) ||\n                        $element.hasClass('selected') ||\n                        $element.is(':selected')) {\n                        return;\n                    }\n\n                    if (_.intersection(products, $widget.optionsMap[id][option].products).length <= 0) {\n                        $element.attr('disabled', true).addClass('disabled');\n                    }\n                });\n            });\n        },\n\n        /**\n         * Get selected product list\n         *\n         * @returns {Array}\n         * @private\n         */\n        _CalcProducts: function ($skipAttributeId) {\n            var $widget = this,\n                selectedOptions = '.' + $widget.options.classes.attributeClass + '[data-option-selected]',\n                products = [];\n\n            // Generate intersection of products\n            $widget.element.find(selectedOptions).each(function () {\n                var id = $(this).data('attribute-id'),\n                    option = $(this).attr('data-option-selected');\n\n                if ($skipAttributeId !== undefined && $skipAttributeId === id) {\n                    return;\n                }\n\n                if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option)) {\n                    return;\n                }\n\n                if (products.length === 0) {\n                    products = $widget.optionsMap[id][option].products;\n                } else {\n                    products = _.intersection(products, $widget.optionsMap[id][option].products);\n                }\n            });\n\n            return products;\n        },\n\n        /**\n         * Update total price\n         *\n         * @private\n         */\n        _UpdatePrice: function () {\n            var $widget = this,\n                $product = $widget.element.parents($widget.options.selectorProduct),\n                $productPrice = $product.find(this.options.selectorProductPrice),\n                result = $widget._getNewPrices(),\n                tierPriceHtml,\n                isShow;\n\n            $productPrice.trigger(\n                'updatePrice',\n                {\n                    'prices': $widget._getPrices(result, $productPrice.priceBox('option').prices)\n                }\n            );\n\n            isShow = typeof result != 'undefined' && result.oldPrice.amount !== result.finalPrice.amount;\n\n            $productPrice.find('span:first').toggleClass('special-price', isShow);\n\n            $product.find(this.options.slyOldPriceSelector)[isShow ? 'show' : 'hide']();\n\n            if (typeof result != 'undefined' && result.tierPrices && result.tierPrices.length) {\n                if (this.options.tierPriceTemplate) {\n                    tierPriceHtml = mageTemplate(\n                        this.options.tierPriceTemplate,\n                        {\n                            'tierPrices': result.tierPrices,\n                            '$t': $t,\n                            'currencyFormat': this.options.jsonConfig.currencyFormat,\n                            'priceUtils': priceUtils\n                        }\n                    );\n                    $(this.options.tierPriceBlockSelector).html(tierPriceHtml).show();\n                }\n            } else {\n                $(this.options.tierPriceBlockSelector).hide();\n            }\n\n            $(this.options.normalPriceLabelSelector).hide();\n\n            _.each($('.' + this.options.classes.attributeOptionsWrapper), function (attribute) {\n                if ($(attribute).find('.' + this.options.classes.optionClass + '.selected').length === 0) {\n                    if ($(attribute).find('.' + this.options.classes.selectClass).length > 0) {\n                        _.each($(attribute).find('.' + this.options.classes.selectClass), function (dropdown) {\n                            if ($(dropdown).val() === '0') {\n                                $(this.options.normalPriceLabelSelector).show();\n                            }\n                        }.bind(this));\n                    } else {\n                        $(this.options.normalPriceLabelSelector).show();\n                    }\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Get new prices for selected options\n         *\n         * @returns {*}\n         * @private\n         */\n        _getNewPrices: function () {\n            var $widget = this,\n                newPrices = $widget.options.jsonConfig.prices,\n                allowedProduct = this._getAllowedProductWithMinPrice(this._CalcProducts());\n\n            if (!_.isEmpty(allowedProduct)) {\n                newPrices = this.options.jsonConfig.optionPrices[allowedProduct];\n            }\n\n            return newPrices;\n        },\n\n        /**\n         * Get prices\n         *\n         * @param {Object} newPrices\n         * @param {Object} displayPrices\n         * @returns {*}\n         * @private\n         */\n        _getPrices: function (newPrices, displayPrices) {\n            var $widget = this;\n\n            if (_.isEmpty(newPrices)) {\n                newPrices = $widget._getNewPrices();\n            }\n            _.each(displayPrices, function (price, code) {\n\n                if (newPrices[code]) {\n                    displayPrices[code].amount = newPrices[code].amount - displayPrices[code].amount;\n                }\n            });\n\n            return displayPrices;\n        },\n\n        /**\n         * Get product with minimum price from selected options.\n         *\n         * @param {Array} allowedProducts\n         * @returns {String}\n         * @private\n         */\n        _getAllowedProductWithMinPrice: function (allowedProducts) {\n            var optionPrices = this.options.jsonConfig.optionPrices,\n                product = {},\n                optionFinalPrice, optionMinPrice;\n\n            _.each(allowedProducts, function (allowedProduct) {\n                optionFinalPrice = parseFloat(optionPrices[allowedProduct].finalPrice.amount);\n\n                if (_.isEmpty(product) || optionFinalPrice < optionMinPrice) {\n                    optionMinPrice = optionFinalPrice;\n                    product = allowedProduct;\n                }\n            }, this);\n\n            return product;\n        },\n\n        /**\n         * Gets all product media and change current to the needed one\n         *\n         * @private\n         */\n        _LoadProductMedia: function () {\n            var $widget = this,\n                $this = $widget.element,\n                productData = this._determineProductData(),\n                mediaCallData,\n                mediaCacheKey,\n\n                /**\n                 * Processes product media data\n                 *\n                 * @param {Object} data\n                 * @returns void\n                 */\n                mediaSuccessCallback = function (data) {\n                    if (!(mediaCacheKey in $widget.options.mediaCache)) {\n                        $widget.options.mediaCache[mediaCacheKey] = data;\n                    }\n                    $widget._ProductMediaCallback($this, data, productData.isInProductView);\n                    setTimeout(function () {\n                        $widget._DisableProductMediaLoader($this);\n                    }, 300);\n                };\n\n            if (!$widget.options.mediaCallback) {\n                return;\n            }\n\n            mediaCallData = {\n                'product_id': this.getProduct()\n            };\n\n            mediaCacheKey = JSON.stringify(mediaCallData);\n\n            if (mediaCacheKey in $widget.options.mediaCache) {\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                mediaSuccessCallback($widget.options.mediaCache[mediaCacheKey]);\n            } else {\n                mediaCallData.isAjax = true;\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                $widget.xhr = $.ajax({\n                    url: $widget.options.mediaCallback,\n                    cache: true,\n                    type: 'GET',\n                    dataType: 'json',\n                    data: mediaCallData,\n                    success: mediaSuccessCallback\n                }).done(function () {\n                    $widget._XhrKiller();\n                });\n            }\n        },\n\n        /**\n         * Enable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _EnableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').length > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .addClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .addClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Disable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _DisableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').length > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .removeClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .removeClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Callback for product media\n         *\n         * @param {Object} $this\n         * @param {String} response\n         * @param {Boolean} isInProductView\n         * @private\n         */\n        _ProductMediaCallback: function ($this, response, isInProductView) {\n            var $main = isInProductView ? $this.parents('.column.main') : $this.parents('.product-item-info'),\n                $widget = this,\n                images = [],\n\n                /**\n                 * Check whether object supported or not\n                 *\n                 * @param {Object} e\n                 * @returns {*|Boolean}\n                 */\n                support = function (e) {\n                    return e.hasOwnProperty('large') && e.hasOwnProperty('medium') && e.hasOwnProperty('small');\n                };\n\n            if (_.size($widget) < 1 || !support(response)) {\n                this.updateBaseImage(this.options.mediaGalleryInitial, $main, isInProductView);\n\n                return;\n            }\n\n            images.push({\n                full: response.large,\n                img: response.medium,\n                thumb: response.small,\n                isMain: true\n            });\n\n            if (response.hasOwnProperty('gallery')) {\n                $.each(response.gallery, function () {\n                    if (!support(this) || response.large === this.large) {\n                        return;\n                    }\n                    images.push({\n                        full: this.large,\n                        img: this.medium,\n                        thumb: this.small\n                    });\n                });\n            }\n\n            this.updateBaseImage(images, $main, isInProductView);\n        },\n\n        /**\n         * Check if images to update are initial and set their type\n         * @param {Array} images\n         */\n        _setImageType: function (images) {\n\n            images.map(function (img) {\n                if (!img.type) {\n                    img.type = 'image';\n                }\n            });\n\n            return images;\n        },\n\n        /**\n         * Update [gallery-placeholder] or [product-image-photo]\n         * @param {Array} images\n         * @param {jQuery} context\n         * @param {Boolean} isInProductView\n         */\n        updateBaseImage: function (images, context, isInProductView) {\n            var justAnImage = images[0],\n                initialImages = this.options.mediaGalleryInitial,\n                imagesToUpdate,\n                gallery = context.find(this.options.mediaGallerySelector).data('gallery'),\n                isInitial;\n\n            if (isInProductView) {\n                if (_.isUndefined(gallery)) {\n                    context.find(this.options.mediaGallerySelector).on('gallery:loaded', function () {\n                        this.updateBaseImage(images, context, isInProductView);\n                    }.bind(this));\n\n                    return;\n                }\n\n                imagesToUpdate = images.length ? this._setImageType($.extend(true, [], images)) : [];\n                isInitial = _.isEqual(imagesToUpdate, initialImages);\n\n                if (this.options.gallerySwitchStrategy === 'prepend' && !isInitial) {\n                    imagesToUpdate = imagesToUpdate.concat(initialImages);\n                }\n\n                imagesToUpdate = this._setImageIndex(imagesToUpdate);\n\n                gallery.updateData(imagesToUpdate);\n                this._addFotoramaVideoEvents(isInitial);\n            } else if (justAnImage && justAnImage.img) {\n                context.find('.product-image-photo').attr('src', justAnImage.img);\n            }\n        },\n\n        /**\n         * Add video events\n         *\n         * @param {Boolean} isInitial\n         * @private\n         */\n        _addFotoramaVideoEvents: function (isInitial) {\n            if (_.isUndefined($.mage.AddFotoramaVideoEvents)) {\n                return;\n            }\n\n            if (isInitial) {\n                $(this.options.mediaGallerySelector).AddFotoramaVideoEvents();\n\n                return;\n            }\n\n            $(this.options.mediaGallerySelector).AddFotoramaVideoEvents({\n                selectedOption: this.getProduct(),\n                dataMergeStrategy: this.options.gallerySwitchStrategy\n            });\n        },\n\n        /**\n         * Set correct indexes for image set.\n         *\n         * @param {Array} images\n         * @private\n         */\n        _setImageIndex: function (images) {\n            var length = images.length,\n                i;\n\n            for (i = 0; length > i; i++) {\n                images[i].i = i + 1;\n            }\n\n            return images;\n        },\n\n        /**\n         * Kill doubled AJAX requests\n         *\n         * @private\n         */\n        _XhrKiller: function () {\n            var $widget = this;\n\n            if ($widget.xhr !== undefined && $widget.xhr !== null) {\n                $widget.xhr.abort();\n                $widget.xhr = null;\n            }\n        },\n\n        /**\n         * Emulate mouse click on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelected: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeCode, optionId) {\n                var elem = this.element.find('.' + this.options.classes.attributeClass +\n                    '[data-attribute-code=\"' + attributeCode + '\"] [data-option-id=\"' + optionId + '\"]'),\n                    parentInput = elem.parent();\n\n                if (elem.hasClass('selected')) {\n                    return;\n                }\n\n                if (parentInput.hasClass(this.options.classes.selectClass)) {\n                    parentInput.val(optionId);\n                    parentInput.trigger('change');\n                } else {\n                    elem.trigger('click');\n                }\n            }, this));\n        },\n\n        /**\n         * Emulate mouse click or selection change on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelectedByAttributeId: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeId, optionId) {\n                var elem = this.element.find('.' + this.options.classes.attributeClass +\n                    '[data-attribute-id=\"' + attributeId + '\"] [data-option-id=\"' + optionId + '\"]'),\n                    parentInput = elem.parent();\n\n                if (elem.hasClass('selected')) {\n                    return;\n                }\n\n                if (parentInput.hasClass(this.options.classes.selectClass)) {\n                    parentInput.val(optionId);\n                    parentInput.trigger('change');\n                } else {\n                    elem.trigger('click');\n                }\n            }, this));\n        },\n\n        /**\n         * Get default options values settings with either URL query parameters\n         * @private\n         */\n        _getSelectedAttributes: function () {\n            var hashIndex = window.location.href.indexOf('#'),\n                selectedAttributes = {},\n                params;\n\n            if (hashIndex !== -1) {\n                params = $.parseQuery(window.location.href.substr(hashIndex + 1));\n\n                selectedAttributes = _.invert(_.mapObject(_.invert(params), function (attributeId) {\n                    var attribute = this.options.jsonConfig.mappedAttributes[attributeId];\n\n                    return attribute ? attribute.code : attributeId;\n                }.bind(this)));\n            }\n\n            return selectedAttributes;\n        },\n\n        /**\n         * Callback which fired after gallery gets initialized.\n         *\n         * @param {HTMLElement} element - DOM element associated with a gallery.\n         */\n        _onGalleryLoaded: function (element) {\n            var galleryObject = element.data('gallery');\n\n            this.options.mediaGalleryInitial = galleryObject.returnCurrentImages();\n        },\n\n        /**\n         * Sets mediaCache for cases when jsonConfig contains preSelectedGallery on layered navigation result pages\n         *\n         * @private\n         */\n        _setPreSelectedGallery: function () {\n            var mediaCallData;\n\n            if (this.options.jsonConfig.preSelectedGallery) {\n                mediaCallData = {\n                    'product_id': this.getProduct()\n                };\n\n                this.options.mediaCache[JSON.stringify(mediaCallData)] = this.options.jsonConfig.preSelectedGallery;\n            }\n        },\n\n        /**\n         * Callback for quantity change event.\n         */\n        _onQtyChanged: function () {\n            var $price = this.element.parents(this.options.selectorProduct)\n                .find(this.options.selectorProductPrice);\n\n            $price.trigger(\n                'updatePrice',\n                {\n                    'prices': this._getPrices(this._getNewPrices(), $price.priceBox('option').prices)\n                }\n            );\n        }\n    });\n\n    return $.mage.SwatchRenderer;\n});\n","Magento_Swatches/js/visual.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'uiRegistry',\n    'jquery/colorpicker/js/colorpicker',\n    'prototype',\n    'jquery/ui',\n    'validation'\n], function (jQuery, mageTemplate, rg) {\n    'use strict';\n\n    return function (config) {\n        var swatchOptionVisualDefaultInputType = 'radio',\n            swatchVisualOption = {\n                table: $('swatch-visual-options-table'),\n                itemCount: 0,\n                totalItems: 0,\n                rendered: 0,\n                isReadOnly: config.isReadOnly,\n                template: mageTemplate('#swatch-visual-row-template'),\n\n                /**\n                 * Add new option using template\n                 *\n                 * @param {Object} data\n                 * @param {Object} render\n                 */\n                add: function (data, render) {\n                    var isNewOption = false,\n                        element;\n\n                    if (typeof data.id == 'undefined') {\n                        data = {\n                            'id': 'option_' + this.itemCount,\n                            'sort_order': this.itemCount + 1,\n                            'empty_class': 'unavailable'\n                        };\n                        isNewOption = true;\n                    } else if (data.defaultswatch0 === '') {\n                        data['empty_class'] = 'unavailable';\n                    }\n\n                    if (!data.intype) {\n                        data.intype = swatchOptionVisualDefaultInputType;\n                    }\n\n                    element = this.template({\n                        data: data\n                    });\n\n                    if (isNewOption && !this.isReadOnly) {\n                        this.enableNewOptionDeleteButton(data.id);\n                    }\n                    this.itemCount++;\n                    this.totalItems++;\n                    this.elements += element;\n\n                    if (render) {\n                        this.render();\n                    }\n                },\n\n                /**\n                 * ColorPicker initialization process\n                 */\n                initColorPicker: function () {\n                    var element = this,\n                        hiddenColorPicker = !jQuery(element).data('colorpickerId');\n\n                    jQuery(this).ColorPicker({\n\n                        /**\n                         * ColorPicker onShow action\n                         */\n                        onShow: function () {\n                            var color = jQuery(element).parent().parent().prev().prev('input').val(),\n                                menu = jQuery(this).parents('.swatch_sub-menu_container');\n\n                            menu.hide();\n                            jQuery(element).ColorPickerSetColor(color);\n                        },\n\n                        /**\n                         * ColorPicker onSubmit action\n                         *\n                         * @param {String} hsb\n                         * @param {String} hex\n                         * @param {String} rgb\n                         * @param {String} el\n                         */\n                        onSubmit: function (hsb, hex, rgb, el) {\n                            var container = jQuery(el).parent().parent().prev();\n\n                            jQuery(el).ColorPickerHide();\n                            container.parent().removeClass('unavailable');\n                            container.prev('input').val('#' + hex);\n                            container.css('background', '#' + hex);\n                        }\n                    });\n\n                    if (hiddenColorPicker) {\n                        jQuery(this).ColorPickerShow();\n                    }\n                },\n\n                /**\n                 * Remove action\n                 *\n                 * @param {Object} event\n                 */\n                remove: function (event) {\n                    var element = $(Event.findElement(event, 'tr')),\n                        elementFlags; // !!! Button already have table parent in safari\n\n                    // Safari workaround\n                    element.ancestors().each(function (parentItem) {\n                        if (parentItem.hasClassName('option-row')) {\n                            element = parentItem;\n                            throw $break;\n                        } else if (parentItem.hasClassName('box')) {\n                            throw $break;\n                        }\n                    });\n\n                    if (element) {\n                        elementFlags = element.getElementsByClassName('delete-flag');\n\n                        if (elementFlags[0]) {\n                            elementFlags[0].value = 1;\n                        }\n\n                        element.addClassName('no-display');\n                        element.addClassName('template');\n                        element.hide();\n                        this.totalItems--;\n                        this.updateItemsCountField();\n                    }\n                },\n\n                /**\n                 * Update items count field\n                 */\n                updateItemsCountField: function () {\n                    $('swatch-visual-option-count-check').value = this.totalItems > 0 ? '1' : '';\n                },\n\n                /**\n                 * Enable delete button for new option\n                 *\n                 * @param {String} id\n                 */\n                enableNewOptionDeleteButton: function (id) {\n                    $$('#delete_button_swatch_container_' + id + ' button').each(function (button) {\n                        button.enable();\n                        button.removeClassName('disabled');\n                    });\n                },\n\n                /**\n                 * Bind remove button\n                 */\n                bindRemoveButtons: function () {\n                    jQuery('#swatch-visual-options-panel').on('click', '.delete-option', this.remove.bind(this));\n                },\n\n                /**\n                 * Render options\n                 */\n                render: function () {\n                    Element.insert($$('[data-role=swatch-visual-options-container]')[0], this.elements);\n                    this.elements = '';\n                },\n\n                /**\n                 * Render elements with delay (performance fix)\n                 *\n                 * @param {Object} data\n                 * @param {Number} from\n                 * @param {Number} step\n                 * @param {Number} delay\n                 * @returns {Boolean}\n                 */\n                renderWithDelay: function (data, from, step, delay) {\n                    var arrayLength = data.length,\n                        len;\n\n                    for (len = from + step; from < len && from < arrayLength; from++) {\n                        this.add(data[from]);\n                    }\n                    this.render();\n\n                    if (from === arrayLength) {\n                        this.updateItemsCountField();\n                        this.rendered = 1;\n                        jQuery('body').trigger('processStop');\n\n                        return true;\n                    }\n                    setTimeout(this.renderWithDelay.bind(this, data, from, step, delay), delay);\n                },\n\n                /**\n                 * Ignore validate action\n                 */\n                ignoreValidate: function () {\n                    var ignore = '.ignore-validate input, ' +\n                        '.ignore-validate select, ' +\n                        '.ignore-validate textarea';\n\n                    jQuery('#edit_form').data('validator').settings.forceIgnore = ignore;\n                }\n            };\n\n        if ($('add_new_swatch_visual_option_button')) {\n            Event.observe(\n                'add_new_swatch_visual_option_button',\n                'click',\n                swatchVisualOption.add.bind(swatchVisualOption, {}, true)\n            );\n        }\n\n        jQuery('#swatch-visual-options-panel').on('render', function () {\n            swatchVisualOption.ignoreValidate();\n\n            if (swatchVisualOption.rendered) {\n                return false;\n            }\n            jQuery('body').trigger('processStart');\n            swatchVisualOption.renderWithDelay(config.attributesData, 0, 100, 300);\n            swatchVisualOption.bindRemoveButtons();\n            jQuery('#swatch-visual-options-panel').on(\n                'click',\n                '.colorpicker_handler',\n                swatchVisualOption.initColorPicker\n            );\n        });\n        jQuery('body').on('click', function (event) {\n            var element = jQuery(event.target);\n\n            if (\n                element.parents('.swatch_sub-menu_container').length === 1 ||\n                element.next('div.swatch_sub-menu_container').length === 1\n            ) {\n                return true;\n            }\n            jQuery('.swatch_sub-menu_container').hide();\n        });\n\n        if (config.isSortable) {\n            jQuery(function ($) {\n                $('[data-role=swatch-visual-options-container]').sortable({\n                    distance: 8,\n                    tolerance: 'pointer',\n                    cancel: 'input, button',\n                    axis: 'y',\n\n                    /**\n                     * Update component\n                     */\n                    update: function () {\n                        $('[data-role=swatch-visual-options-container] [data-role=order]').each(\n                            function (index, element) {\n                                $(element).val(index + 1);\n                            }\n                        );\n                    }\n                });\n            });\n        }\n\n        window.swatchVisualOption = swatchVisualOption;\n        window.swatchOptionVisualDefaultInputType = swatchOptionVisualDefaultInputType;\n\n        rg.set('swatch-visual-options-panel', swatchVisualOption);\n\n        jQuery(function ($) {\n\n            var swatchComponents = {\n\n                /**\n                 * div wrapper for to hide all evement\n                 */\n                wrapper: null,\n\n                /**\n                 * iframe component to perform file upload without page reload\n                 */\n                iframe: null,\n\n                /**\n                 * form component for upload image\n                 */\n                form: null,\n\n                /**\n                 * Input file component for upload image\n                 */\n                inputFile: null,\n\n                /**\n                 * Create swatch component for upload files\n                 *\n                 * @this {swatchComponents}\n                 * @public\n                 */\n                create: function () {\n                    this.wrapper = $('<div>').css({\n                        display: 'none'\n                    }).appendTo($('body'));\n\n                    this.iframe = $('<iframe></iframe>', {\n                        id:  'upload_iframe',\n                        name: 'upload_iframe'\n                    }).appendTo(this.wrapper);\n\n                    this.form = $('<form></form>', {\n                        id: 'swatch_form_image_upload',\n                        name: 'swatch_form_image_upload',\n                        target: 'upload_iframe',\n                        method: 'post',\n                        enctype: 'multipart/form-data',\n                        class: 'ignore-validate',\n                        action: config.uploadActionUrl\n                    }).appendTo(this.wrapper);\n\n                    this.inputFile = $('<input />', {\n                        type: 'file',\n                        name: 'datafile',\n                        class: 'swatch_option_file'\n                    }).appendTo(this.form);\n\n                    $('<input />', {\n                        type: 'hidden',\n                        name: 'form_key',\n                        value: FORM_KEY\n                    }).appendTo(this.form);\n                }\n            };\n\n            /**\n             * Create swatch components\n             */\n            swatchComponents.create();\n\n            /**\n             * Register event for swatch input[type=file] change\n             */\n            swatchComponents.inputFile.change(function () {\n                var container = $('#' + $(this).attr('data-called-by')).parents().eq(2).children('.swatch_window'),\n\n                    /**\n                     * @this {iframe}\n                     */\n                    iframeHandler = function () {\n                        var imageParams = $.parseJSON($(this).contents().find('body').html()),\n                            fullMediaUrl = imageParams['swatch_path'] + imageParams['file_path'];\n\n                        container.prev('input').val(imageParams['file_path']);\n                        container.css({\n                            'background-image': 'url(' + fullMediaUrl + ')',\n                            'background-size': 'cover'\n                        });\n                        container.parent().removeClass('unavailable');\n                    };\n\n                swatchComponents.iframe.off('load');\n                swatchComponents.iframe.load(iframeHandler);\n                swatchComponents.form.submit();\n                $(this).val('');\n            });\n\n            /**\n             * Register event for choose \"upload image\" option\n             */\n            $(document).on('click', '.btn_choose_file_upload', function () {\n                swatchComponents.inputFile.attr('data-called-by', $(this).attr('id'));\n                swatchComponents.inputFile.trigger('click');\n            });\n\n            /**\n             * Register event for remove option\n             */\n            $(document).on('click', '.btn_remove_swatch', function () {\n                var optionPanel = $(this).parents().eq(2);\n\n                optionPanel.children('input').val('');\n                optionPanel.children('.swatch_window').css('background', '');\n\n                optionPanel.addClass('unavailable');\n\n                jQuery('.swatch_sub-menu_container').hide();\n            });\n\n            /**\n             * Toggle color upload chooser\n             */\n            $(document).on('click', '.swatches-visual-col', function () {\n                var currentElement = $(this).find('.swatch_sub-menu_container');\n\n                jQuery('.swatch_sub-menu_container').not(currentElement).hide();\n                currentElement.toggle();\n            });\n        });\n    };\n});\n","Magento_Swatches/js/form/element/swatch-visual.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'mage/template',\n    'uiRegistry',\n    'prototype',\n    'Magento_Ui/js/form/element/abstract',\n    'jquery/colorpicker/js/colorpicker',\n    'jquery/ui'\n], function (_, jQuery, mageTemplate, rg, prototype, Abstract) {\n    'use strict';\n\n    /**\n     * Former implementation.\n     *\n     * @param {*} value\n     * @param {Object} container\n     * @param {String} uploadUrl\n     * @param {String} elementName\n     */\n    function oldCode(value, container, uploadUrl, elementName) {\n        var swatchVisualOption = {\n            itemCount: 0,\n            totalItems: 0,\n            rendered: 0,\n            isReadOnly: false,\n\n            /**\n             * Initialize.\n             */\n            initialize: function () {\n                if (_.isEmpty(value)) {\n                    container.addClassName('unavailable');\n                }\n\n                jQuery(container).on(\n                    'click',\n                    '.colorpicker_handler',\n                    this.initColorPicker\n                );\n            },\n\n            /**\n             * ColorPicker initialization process\n             */\n            initColorPicker: function () {\n                var element = this,\n                    hiddenColorPicker = !jQuery(element).data('colorpickerId');\n\n                jQuery(this).ColorPicker({\n\n                    /**\n                     * ColorPicker onShow action\n                     */\n                    onShow: function () {\n                        var color = jQuery(element).parent().parent().prev().prev('input').val(),\n                            menu = jQuery(this).parents('.swatch_sub-menu_container');\n\n                        menu.hide();\n                        jQuery(element).ColorPickerSetColor(color);\n                    },\n\n                    /**\n                     * ColorPicker onSubmit action\n                     *\n                     * @param {String} hsb\n                     * @param {String} hex\n                     * @param {String} rgb\n                     * @param {String} el\n                     */\n                    onSubmit: function (hsb, hex, rgb, el) {\n                        var localContainer = jQuery(el).parent().parent().prev();\n\n                        jQuery(el).ColorPickerHide();\n                        localContainer.parent().removeClass('unavailable');\n                        localContainer.prev('input').val('#' + hex).trigger('change');\n                        localContainer.css('background', '#' + hex);\n                    }\n                });\n\n                if (hiddenColorPicker) {\n                    jQuery(this).ColorPickerShow();\n                }\n            },\n\n            /**\n             * Remove action\n             *\n             * @param {Object} event\n             */\n            remove: function (event) {\n                var element = $(Event.findElement(event, 'tr')),\n                    elementFlags; // !!! Button already have table parent in safari\n\n                // Safari workaround\n                element.ancestors().each(function (parentItem) {\n                    if (parentItem.hasClassName('option-row')) {\n                        element = parentItem;\n                        throw $break;\n                    } else if (parentItem.hasClassName('box')) {\n                        throw $break;\n                    }\n                });\n\n                if (element) {\n                    elementFlags = element.getElementsByClassName('delete-flag');\n\n                    if (elementFlags[0]) {\n                        elementFlags[0].value = 1;\n                    }\n\n                    element.addClassName('no-display');\n                    element.addClassName('template');\n                    element.hide();\n                    this.totalItems--;\n                    this.updateItemsCountField();\n                }\n            },\n\n            /**\n             * Update items count field\n             */\n            updateItemsCountField: function () {\n                $('swatch-visual-option-count-check').value = this.totalItems > 0 ? '1' : '';\n            }\n        };\n\n        //swatchVisualOption.initColorPicker();\n\n        jQuery('body').on('click', function (event) {\n            var element = jQuery(event.target);\n\n            if (\n                element.parents('.swatch_sub-menu_container').length === 1 ||\n                element.next('div.swatch_sub-menu_container').length === 1\n            ) {\n                return true;\n            }\n            jQuery('.swatch_sub-menu_container').hide();\n        });\n\n        jQuery(function ($) {\n\n            var swatchComponents = {\n\n                /**\n                 * div wrapper for to hide all evement\n                 */\n                wrapper: null,\n\n                /**\n                 * iframe component to perform file upload without page reload\n                 */\n                iframe: null,\n\n                /**\n                 * form component for upload image\n                 */\n                form: null,\n\n                /**\n                 * Input file component for upload image\n                 */\n                inputFile: null,\n\n                /**\n                 * Create swatch component for upload files\n                 *\n                 * @this {swatchComponents}\n                 * @public\n                 */\n                create: function () {\n                    this.wrapper = $('<div>').css({\n                        display: 'none'\n                    }).appendTo($('body'));\n\n                    this.iframe = $('<iframe></iframe>', {\n                        name: 'upload_iframe_' + elementName\n                    }).appendTo(this.wrapper);\n\n                    this.form = $('<form></form>', {\n                        name: 'swatch_form_image_upload_' + elementName,\n                        target: 'upload_iframe_' + elementName,\n                        method: 'post',\n                        enctype: 'multipart/form-data',\n                        class: 'ignore-validate',\n                        action: uploadUrl\n                    }).appendTo(this.wrapper);\n\n                    this.inputFile = $('<input />', {\n                        type: 'file',\n                        name: 'datafile',\n                        class: 'swatch_option_file'\n                    }).appendTo(this.form);\n\n                    $('<input />', {\n                        type: 'hidden',\n                        name: 'form_key',\n                        value: FORM_KEY\n                    }).appendTo(this.form);\n                }\n            };\n\n            swatchVisualOption.initialize();\n\n            /**\n             * Create swatch components\n             */\n            swatchComponents.create();\n\n            /**\n             * Register event for swatch input[type=file] change\n             */\n            swatchComponents.inputFile.change(function () {\n                var localContainer = $('.' + $(this).attr('data-called-by')).parents().eq(2).children('.swatch_window'),\n\n                    /**\n                     * @this {iframe}\n                     */\n                    iframeHandler = function () {\n                        var imageParams = $.parseJSON($(this).contents().find('body').html()),\n                            fullMediaUrl = imageParams['swatch_path'] + imageParams['file_path'];\n\n                        localContainer.prev('input').val(imageParams['file_path']).trigger('change');\n                        localContainer.css({\n                            'background-image': 'url(' + fullMediaUrl + ')',\n                            'background-size': 'cover'\n                        });\n                        localContainer.parent().removeClass('unavailable');\n                    };\n\n                swatchComponents.iframe.off('load');\n                swatchComponents.iframe.load(iframeHandler);\n                swatchComponents.form.submit();\n                $(this).val('');\n            });\n\n            /**\n             * Register event for choose \"upload image\" option\n             */\n            $(container).on('click', '.btn_choose_file_upload', function () {\n                swatchComponents.inputFile.attr('data-called-by', $(this).data('class'));\n                swatchComponents.inputFile.trigger('click');\n            });\n\n            /**\n             * Register event for remove option\n             */\n            $(container).on('click', '.btn_remove_swatch', function () {\n                var optionPanel = $(this).parents().eq(2);\n\n                optionPanel.children('input').val('').trigger('change');\n                optionPanel.children('.swatch_window').css('background', '');\n                optionPanel.addClass('unavailable');\n                jQuery('.swatch_sub-menu_container').hide();\n            });\n\n            /**\n             * Toggle color upload chooser\n             */\n            $(container).on('click', '.swatch_window', function () {\n                jQuery('.swatch_sub-menu_container').hide();\n                $(this).next('div').toggle();\n            });\n        });\n    }\n\n    return Abstract.extend({\n        defaults: {\n            elementId: 0,\n            prefixName: '',\n            prefixElementName: '',\n            elementName: '',\n            value: '',\n            uploadUrl: ''\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.configureDataScope();\n\n            return this;\n        },\n\n        /**\n         * Initialize.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initOldCode()\n                .on('value', this.onChangeColor.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Handler function that execute when color changes.\n         *\n         * @param {String} data - color\n         */\n        onChangeColor: function (data) {\n            if (!data) {\n                jQuery('.' + this.elementName).parent().removeClass('unavailable');\n            }\n        },\n\n        /**\n         * Initialize wrapped former implementation.\n         *\n         * @returns {Object} Chainable.\n         */\n        initOldCode: function () {\n            jQuery.async('.' + this.elementName, this.name, function (elem) {\n                oldCode(this.value(), elem.parentElement, this.uploadUrl, this.elementName);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Configure data scope.\n         */\n        configureDataScope: function () {\n            var recordId, prefixName;\n\n            // Get recordId\n            recordId = this.parentName.split('.').last();\n\n            prefixName = this.dataScopeToHtmlArray(this.prefixName);\n            this.elementName = this.prefixElementName + recordId;\n\n            this.inputName = prefixName + '[' + this.elementName + ']';\n            this.exportDataLink = 'data.' + this.prefixName + '.' + this.elementName;\n            this.exports.value = this.provider + ':' + this.exportDataLink;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this._super();\n\n            this.source.remove(this.exportDataLink);\n        },\n\n        /**\n         * Get HTML array from data scope.\n         *\n         * @param {String} dataScopeString\n         * @returns {String}\n         */\n        dataScopeToHtmlArray: function (dataScopeString) {\n            var dataScopeArray, dataScope, reduceFunction;\n\n            /**\n             * Add new level of nesting.\n             *\n             * @param {String} prev\n             * @param {String} curr\n             * @returns {String}\n             */\n            reduceFunction = function (prev, curr) {\n                return prev + '[' + curr + ']';\n            };\n\n            dataScopeArray = dataScopeString.split('.');\n\n            dataScope = dataScopeArray.shift();\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\n\n            return dataScope;\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/signIn.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_AdobeIms/js/signIn',\n    'Magento_AdobeIms/js/action/authorization',\n    'Magento_Ui/js/modal/confirm'\n], function ($, signIn, auth, confirm) {\n    'use strict';\n\n    return signIn.extend({\n\n        defaults: {\n            userQuota: {},\n            // eslint-disable-next-line max-len\n            dataProvider: 'name = adobe_stock_images_listing.adobe_stock_images_listing_data_source, ns = adobe_stock_images_listing',\n            // eslint-disable-next-line max-len\n            previewProvider: 'name = adobe_stock_images_listing.adobe_stock_images_listing.adobe_stock_images_columns.preview, ns = adobe_stock_images_listing',\n            quotaUrl: 'adobe_stock/license/quota',\n            modules: {\n                source: '${ $.dataProvider }',\n                preview: '${ $.previewProvider }'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super().observe(['userQuota']);\n\n            return this;\n        },\n\n        /**\n         * Login to Adobe\n         *\n         * @return {*}\n         */\n        login: function () {\n            var deferred = $.Deferred();\n\n            if (this.user().isAuthorized) {\n                return deferred.resolve();\n            }\n            auth(this.loginConfig)\n                .then(function (response) {\n                    this.loadUserProfile();\n                    deferred.resolve(response);\n                }.bind(this))\n                .fail(function (error) {\n                    deferred.reject(error);\n                });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Login action with popup on error..\n         */\n        loginClick: function () {\n            this.login().fail(function (error) {\n                this.showLoginErrorPopup(error);\n            }.bind(this));\n        },\n\n        /**\n         * Show popup that user failed to login.\n         */\n        showLoginErrorPopup: function (error) {\n            confirm({\n                title: $.mage.__('Couldn\\'t log you in'),\n                content: error,\n                buttons: [{\n                    text: $.mage.__('Ok'),\n                    class: 'action-primary action-accept'\n                }],\n                actions: {\n\n                    /**\n                       * Close modal\n                       */\n                    confirm: function (event) {\n                        this.closeModal(event);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Logout from adobe account\n         */\n        logout: function () {\n            $.ajax({\n                type: 'POST',\n                url: this.logoutUrl,\n                data: {\n                    'form_key': window.FORM_KEY\n                },\n                dataType: 'json',\n                context: this,\n                showLoader: true,\n                success: function () {\n                    this.user({\n                        isAuthorized: false,\n                        name: '',\n                        email: '',\n                        image: this.defaultProfileImage\n                    });\n                }.bind(this),\n\n                /**\n                 * @param {Object} response\n                 * @returns {String}\n                 */\n                error: function (response) {\n                    return response.message;\n                }\n            });\n        },\n\n        /**\n         * Retrieves full user quota.\n         */\n        getUserQuota: function () {\n            $.ajax({\n                type: 'GET',\n                url: this.quotaUrl,\n                dataType: 'json',\n                context: this,\n\n                /**\n                 * @param {Object} response\n                 * @returns void\n                 */\n                success: function (response) {\n                    this.userQuota(response.result);\n                },\n\n                /**\n                 * @param {Object} response\n                 * @returns {String}\n                 */\n                error: function (response) {\n                    return response.message;\n                }\n            });\n        },\n\n        /**\n         * @inheritdoc\n         */\n        loadUserProfile: function () {\n            $.ajax({\n                type: 'GET',\n                url: this.profileUrl,\n                dataType: 'json',\n                context: this,\n\n                /**\n                 * @param {Object} response\n                 * @returns void\n                 */\n                success: function (response) {\n                    this.user({\n                        isAuthorized: true,\n                        name: response.result.name,\n                        email: response.result.email,\n                        image: response.result.image\n                    });\n                    this.getUserQuota();\n                },\n\n                /**\n                 * @param {Object} response\n                 * @returns {String}\n                 */\n                error: function (response) {\n                    return response.message;\n                }\n            });\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/path-utility.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * Extracts image name from its path\n         *\n         * @param {String} path\n         * @returns {String}\n         */\n        getImageNameFromPath: function (path) {\n            var filePathArray = path.split('/'),\n                imageIndex = filePathArray.length - 1;\n\n            return filePathArray[imageIndex].substring(0, filePathArray[imageIndex].lastIndexOf('.'));\n        },\n\n        /**\n         * Generate meaningful name image file,\n         * allow only alphanumerics, dashes, and underscores\n         *\n         * @param {String} title\n         * @param {Number} id\n         * @return string\n         */\n        generateImageName: function (title, id) {\n            var fileName = title.substring(0, 32)\n                .replace(/[^a-zA-Z0-9_]/g, '-')\n                .replace(/-{2,}/g, '-')\n                .toLowerCase();\n\n            /* If the filename does not contain latin chars, use ID as a filename */\n            return fileName === '-' ? id : fileName;\n        },\n\n        /**\n         * Get image file extension\n         *\n         * @param {String} contentType\n         * @return string\n         */\n        getImageExtension: function (contentType) {\n            return contentType.match(/[^/]{1,4}$/);\n        },\n\n        /**\n         * Create path\n         *\n         * @param {String} directoryPath\n         * @param {String} fileName\n         * @param {String} contentType\n         * @returns {String}\n         */\n        buildPath: function (directoryPath, fileName, contentType) {\n            return directoryPath + '/' + fileName + '.' + this.getImageExtension(contentType);\n        }\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/panel.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'jquery',\n    'mage/translate'\n], function (Element, $, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            containerId: '#adobe-stock-images-search-modal',\n            masonryComponentPath: 'adobe_stock_images_listing.adobe_stock_images_listing.adobe_stock_images_columns',\n            dataSourcePath: 'adobe_stock_images_listing.adobe_stock_images_listing_data_source',\n            modules: {\n                masonry: '${ $.masonryComponentPath }',\n                source: '${ $.dataSourcePath }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            this._super();\n\n            $(this.containerId).modal({\n                type: 'slide',\n                buttons: [],\n                modalClass: 'adobe-stock-modal',\n                title: $t('Adobe Stock')\n            }).on('openModal', function () {\n                this.masonry().setLayoutStylesWhenLoaded();\n            }.bind(this));\n\n            try {\n                $(this.containerId).applyBindings();\n            } catch (e) {\n                //already bounded\n            }\n\n            $(window).on('fileDeleted.mediabrowser', this.reloadGrid.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Update listing data\n         */\n        reloadGrid: function () {\n            this.source().set('params.t', Date.now());\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/media-gallery.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Base64 */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm'\n], function ($, confirm) {\n    'use strict';\n\n    return {\n        jsTreeRootFolderId: 'root',\n        jsTreeFolderNameMaxLength: 20,\n\n        /**\n         * Locate downloaded image in media browser\n         *\n         * @param {String} path\n         */\n        locate: function (path) {\n            var imageFolder = this.selectFolder(path),\n                imageFilename = path.substring(path.lastIndexOf('/') + 1),\n                locatedImage;\n\n            if (imageFolder.length) {\n                locatedImage = $('div[data-row=\"file\"]:has(img[alt=\\\"' + imageFilename + '\\\"])');\n\n                return locatedImage.length ? locatedImage : false;\n            }\n\n            $.ajaxSetup({\n                async: true\n            });\n        },\n\n        /**\n         * Select folder\n         *\n         * @param {String} path\n         */\n        selectFolder: function (path) {\n            var imageFolder,\n                pathId,\n                imagePath = path.replace(/^\\/+/, ''),\n                folderPathParts = imagePath.split('/').slice(0, -1);\n\n            $.ajaxSetup({\n                async: false\n            });\n\n            if (folderPathParts.length > 1) {\n                this.openFolderTree(folderPathParts);\n            }\n\n            pathId = Base64.idEncode(folderPathParts.join('/'));\n            imageFolder = $('.jstree li[data-id=\"' + pathId + '\"]').children('a');\n\n            if (!imageFolder.length) {\n                imageFolder = $('.jstree li[data-id=\"' + this.jsTreeRootFolderId + '\"]')\n                    .children('a');\n            }\n\n            if (imageFolder.length) {\n                imageFolder[0].click();\n            }\n\n            return imageFolder;\n        },\n\n        /**\n         * Show popup that image cannot be located\n         */\n        notLocated: function () {\n            confirm({\n                title: $.mage.__('The image cannot be located'),\n                content: $.mage.__('We cannot find this image in the media gallery.'),\n                buttons: [{\n                    text: $.mage.__('Ok'),\n                    class: 'action-primary',\n                    attr: {},\n\n                    /**\n                     * Close modal on button click\n                     */\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                }]\n            });\n        },\n\n        /**\n         * Open folder Tree\n         *\n         * @param {Array} folderPathParts\n         */\n        openFolderTree: function (folderPathParts) {\n            var i,\n                pathId,\n                openFolderButton,\n                folderPath = '';\n\n            for (i = 0; i < folderPathParts.length - 1; i++) {\n                if (folderPath === '') {\n                    folderPath = folderPathParts[i];\n                } else {\n                    folderPath = folderPath + '/' + folderPathParts[i];\n                }\n                pathId = Base64.idEncode(folderPath);\n                openFolderButton = $('.jstree li[data-id=\"' + pathId + '\"].jstree-closed').children('.jstree-icon');\n\n                if (openFolderButton.length) {\n                    openFolderButton.click();\n                }\n            }\n        }\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/confirmation/license.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/prompt',\n    'text!Magento_AdobeStockImageAdminUi/template/modal/adobe-modal-prompt-content.html'\n], function ($, prompt, adobePromptContentTmpl) {\n    'use strict';\n\n    return function (recordTitle, quotaMessage, isPreviewDownloaded, proposedfileName, fileExtension) {\n        var confirmationContent = $.mage.__('License \"' + recordTitle + '\"'),\n            deferred = $.Deferred(),\n            displayFieldName = !isPreviewDownloaded ? '<b>' + $.mage.__('File Name') + '</b>' : '',\n            content = '<p>' + confirmationContent + '</p><p><b>' + quotaMessage + '</b></p><br>' + displayFieldName,\n            data = {\n                'title': $.mage.__('License Adobe Stock Images?'),\n                'content': content,\n                'visible': !isPreviewDownloaded,\n                'actions': {\n                    /**\n                     * Confirm action\n                     *\n                     * @param {String} fileName\n                     */\n                    confirm: function (fileName) {\n                        deferred.resolve(fileName);\n                    }\n                },\n                'buttons': [{\n                    text: $.mage.__('Cancel'),\n                    class: 'action-secondary action-dismiss',\n\n                    /**\n                     * Close modal\n                     */\n                    click: function () {\n                        this.closeModal();\n                        deferred.reject();\n                    }\n                }, {\n                    text: $.mage.__('Confirm'),\n                    class: 'action-primary action-accept'\n                }]\n\n            };\n\n        prompt({\n            title: data.title,\n            content:  data.content,\n            value: proposedfileName,\n            imageExtension: fileExtension,\n            visible: data.visible,\n            promptContentTmpl: adobePromptContentTmpl,\n            modalClass: 'adobe-stock-save-preview-prompt',\n            validation: true,\n            promptField: '[data-role=\"adobe-stock-image-name-field\"]',\n            validationRules: ['required-entry', 'validate-image-name'],\n            attributesForm: {\n                novalidate: 'novalidate',\n                action: '',\n                onkeydown: 'return event.key != \\'Enter\\';'\n            },\n            attributesField: {\n                name: 'name',\n                'data-validate': '{required:true}',\n                maxlength: '128'\n            },\n            context: this,\n            actions: data.actions,\n            buttons: data.buttons\n        });\n\n        if (!data.visible) {\n            $('.adobe-stock-save-preview-prompt').trigger('focus');\n        }\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/confirmation/buyCredits.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm'\n], function ($, confirm) {\n    'use strict';\n\n    return function (buyCreditsUrl, recordTitle, quotaMessage) {\n        var confirmationContent = $.mage.__('License \"' + recordTitle + '\"'),\n            content = '<p>' + confirmationContent + '</p><p><b>' + quotaMessage + '</b></p><br>';\n\n        confirm({\n            title: $.mage.__('License Adobe Stock Images?'),\n            content: content,\n            buttons: [{\n                text: $.mage.__('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Close modal\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            },{\n                text: $.mage.__('Buy Credits'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Close modal\n                 */\n                click: function () {\n                    window.open(buyCreditsUrl);\n                    this.closeModal();\n                }\n            }]\n        });\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/confirmation/saveLicensed.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/prompt',\n    'text!Magento_AdobeStockImageAdminUi/template/modal/adobe-modal-prompt-content.html'\n], function ($, prompt, adobePromptContentTmpl) {\n    'use strict';\n\n    return function (proposedfileName, fileExtension) {\n        var deferred = $.Deferred(),\n            data = {\n                'title': $.mage.__('Save'),\n                'content': $.mage.__('File Name'),\n                'visible': true,\n                'actions': {\n                    /**\n                     * Resolve with the specified file name\n                     *\n                     * @param {String} fileName\n                     */\n                    confirm: function (fileName) {\n                        deferred.resolve(fileName);\n                    }\n                },\n                'buttons': [\n                    {\n                        text: $.mage.__('Cancel'),\n                        class: 'action-secondary action-dismiss',\n\n                        /**\n                         * Close modal on button click\n                         */\n                        click: function () {\n                            this.closeModal();\n                            deferred.reject();\n                        }\n                    },\n                    {\n                        text: $.mage.__('Confirm'),\n                        class: 'action-primary action-accept'\n                    }\n                ]\n            };\n\n        prompt({\n            title: data.title,\n            content:  data.content,\n            value: proposedfileName,\n            imageExtension: fileExtension,\n            visible: data.visible,\n            promptContentTmpl: adobePromptContentTmpl,\n            modalClass: 'adobe-stock-save-preview-prompt',\n            validation: true,\n            promptField: '[data-role=\"adobe-stock-image-name-field\"]',\n            validationRules: ['required-entry', 'validate-image-name'],\n            attributesForm: {\n                novalidate: 'novalidate',\n                action: '',\n                onkeydown: 'return event.key != \\'Enter\\';'\n            },\n            attributesField: {\n                name: 'name',\n                'data-validate': '{required:true}',\n                maxlength: '128'\n            },\n            context: this,\n            actions: data.actions,\n            buttons: data.buttons\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/confirmation/save.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/prompt',\n    'text!Magento_AdobeStockImageAdminUi/template/modal/adobe-modal-prompt-content.html'\n], function ($, prompt, adobePromptContentTmpl) {\n    'use strict';\n\n    return function (proposedfileName, fileExtension) {\n        var deferred = $.Deferred(),\n            data = {\n                'title': $.mage.__('Save Preview'),\n                'content': $.mage.__('File Name'),\n                'visible': true,\n                'actions': {\n                    /**\n                     * Resolve with the specified file name\n                     *\n                     * @param {String} specifiedFileName\n                     */\n                    confirm: function (specifiedFileName) {\n                        deferred.resolve(specifiedFileName);\n                    }\n                },\n                'buttons': [{\n                    text: $.mage.__('Cancel'),\n                    class: 'action-secondary action-dismiss',\n\n                    /**\n                     * Close modal on button click\n                     */\n                    click: function () {\n                        this.closeModal();\n                        deferred.reject();\n                    }\n                }, {\n                    text: $.mage.__('Confirm'),\n                    class: 'action-primary action-accept'\n                }]\n\n            };\n\n        prompt({\n            title: data.title,\n            content:  data.content,\n            value: proposedfileName,\n            imageExtension: fileExtension,\n            visible: data.visible,\n            promptContentTmpl: adobePromptContentTmpl,\n            modalClass: 'adobe-stock-save-preview-prompt',\n            validation: true,\n            promptField: '[data-role=\"adobe-stock-image-name-field\"]',\n            validationRules: ['required-entry', 'validate-image-name'],\n            attributesForm: {\n                novalidate: 'novalidate',\n                action: '',\n                onkeydown: 'return event.key != \\'Enter\\';'\n            },\n            attributesField: {\n                name: 'name',\n                'data-validate': '{required:true}',\n                maxlength: '128'\n            },\n            context: this,\n            actions: data.actions,\n            buttons: data.buttons\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/validation/validate-image-name.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'jquery/validate'\n], function ($, $t) {\n    'use strict';\n\n    $.validator.addMethod(\n        'validate-image-name', function (value) {\n            return /^[a-zA-Z0-9\\-\\_]+$/i.test(value);\n\n        }, $t('Please name the file using only letters, numbers, underscores and dashes'));\n});\n","Magento_AdobeStockImageAdminUi/js/components/images-grid-sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/paging/sizes',\n    'underscore'\n], function (Sizes, _) {\n    'use strict';\n\n    return Sizes.extend({\n        defaults: {\n            value: 32,\n            minSize: 1,\n            maxSize: 64\n        },\n\n        exports: {\n            value: '${ $.provider }:params.paging.page',\n            options: '${ $.provider }:params.paging.options'\n        },\n\n        sizes: {\n            '32': {\n                value: 32,\n                label: 32\n            },\n            '48': {\n                value: 48,\n                label: 48\n            },\n            '64': {\n                value: 64,\n                label: 64\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        updateArray: function () {\n            if (_.isUndefined(this.options)) {\n                this.options = this.sizes;\n            }\n\n            return this._super();\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/image-preview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'uiLayout',\n    'Magento_Ui/js/grid/columns/image-preview'\n], function ($, layout, imagePreview) {\n    'use strict';\n\n    return imagePreview.extend({\n        defaults: {\n            downloadImagePreviewUrl: 'adobe_stock/preview/download',\n            licenseAndDownloadUrl: 'adobe_stock/license/license',\n            saveLicensedAndDownloadUrl: 'adobe_stock/license/saveLicensed',\n            confirmationUrl: 'adobe_stock/license/confirmation',\n            relatedImagesUrl: 'adobe_stock/preview/relatedimages',\n            buyCreditsUrl: 'https://stock.adobe.com/',\n            mediaGallerySelector: '.media-gallery-modal:has(#search_adobe_stock)',\n            adobeStockModalSelector: '.adobe-search-images-modal',\n            activeMediaGallerySelector: 'aside.modal-slide.adobe-stock-modal._show',\n            modules: {\n                keywords: '${ $.name }_keywords',\n                related: '${ $.name }_related',\n                actions: '${ $.name }_actions'\n            },\n            viewConfig: [\n                {\n                    component: 'Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/keywords',\n                    name: '${ $.name }_keywords'\n                },\n                {\n                    component: 'Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/related',\n                    name: '${ $.name }_related'\n                },\n                {\n                    component: 'Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/actions',\n                    name: '${ $.name }_actions',\n                    provider: '${ $.provider }',\n                    mediaGallery: '${ $.mediaGalleryComponent }',\n                    mediaGalleryName: '${ $.mediaGalleryName }',\n                    mediaGalleryProvider: '${ $.mediaGalleryProvider }',\n                    mediaGallerySortBy: '${ $.mediaGallerySortBy }',\n                    mediaGallerySearchInput: '${ $.mediaGallerySearchInput }',\n                    mediaGalleryListingFilters: '${ $.mediaGalleryListingFilters }',\n                    getMediaGalleryAsset: '${ $.getMediaGalleryAsset }',\n                    imageEditDetailsUrl: '${ $.imageEditDetailsUrl }',\n                    listingPaging: '${ $.listingPaging }'\n                }\n            ],\n            listens: {\n                '${ $.sortByComponentName }:applied': 'hide'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super().initView();\n            $(window).on('fileDeleted.enhancedMediaGallery', this.reloadAdobeGrid.bind(this));\n            $(window).on('folderDeleted.enhancedMediaGallery', this.reloadAdobeGrid.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Get previous button disabled\n         *\n         * @param {Object} record\n         *\n         * @return {Boolean}\n         */\n        cannotViewPrevious: function (record) {\n            return this.related().cannotViewPrevious(record);\n        },\n\n        /**\n         * Get next button disabled\n         *\n         * @param {Object} record\n         *\n         * @return {Boolean}\n         */\n        cannotViewNext: function (record) {\n            return this.related().cannotViewNext(record);\n        },\n\n        /**\n         * Return active adobe gallery selector.\n         */\n        getAdobeModal: function () {\n            return $(this.activeMediaGallerySelector).find(this.adobeStockModalSelector);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        next: function (record) {\n            if (this.related().selectedTab()) {\n                this.related().nextRelated(record);\n\n                return;\n            }\n            this.keywords().hideAllKeywords();\n            this._super(record);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        prev: function (record) {\n            if (this.related().selectedTab()) {\n                this.related().prevRelated(record);\n\n                return;\n            }\n            this.keywords().hideAllKeywords();\n            this._super(record);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        show: function (record) {\n            this.related().selectedTab(null);\n            this.keywords().hideAllKeywords();\n            this.displayedRecord(record);\n            this._super(record);\n            this.related().loadRelatedImages(record);\n        },\n\n        /**\n         * Show related image data in the preview section\n         *\n         * @param {Object} record\n         */\n        showRelated: function (record) {\n            this.keywords().hideAllKeywords();\n            this.displayedRecord(record);\n            this.updateHeight();\n        },\n\n        /**\n         * Returns attributes to display under the preview image\n         *\n         * @returns {*[]}\n         */\n        getDisplayAttributes: function () {\n            if (!this.displayedRecord()) {\n                return [];\n            }\n\n            return [\n                {\n                    name: 'Dimensions',\n                    value: this.displayedRecord().width + ' x ' + this.displayedRecord().height + ' px'\n                },\n                {\n                    name: 'File type',\n                    value: this.displayedRecord()['content_type'].toUpperCase()\n                },\n                {\n                    name: 'Category',\n                    value: this.displayedRecord().category.name || 'None'\n                },\n                {\n                    name: 'File #',\n                    value: this.displayedRecord().id\n                }\n            ];\n        },\n\n        /**\n         * Reload Adobe grid after deleting image\n         */\n        reloadAdobeGrid: function () {\n            this.actions().source().reload({\n                refresh: true\n            });\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/overlay.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/grid/columns/overlay',\n    'Magento_AdobeStockImageAdminUi/js/action/getLicenseStatus'\n], function ($, _, overlay, getLicenseStatus) {\n    'use strict';\n\n    return overlay.extend({\n        defaults: {\n            // eslint-disable-next-line max-len\n            provider: 'name = adobe_stock_images_listing.adobe_stock_images_listing_data_source, ns = adobe_stock_images_listing',\n            loginProvider: 'name = adobe-login, ns = adobe-login',\n            getImagesUrl: 'adobe_stock/license/getlist',\n            licensed: {},\n            modules: {\n                login: '${ $.loginProvider }'\n            },\n            listens: {\n                '${ $.provider }:data.items': 'handleItemsUpdate',\n                '${ $.loginProvider }:user': 'handleUserUpdate'\n            },\n            imports: {\n                rows: '${ $.provider }:data.items'\n            }\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'licensed'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Updates the licensed data when items data is updated.\n         *\n         * @param {Array} items\n         */\n        handleItemsUpdate: function (items) {\n            var ids = this.getIds(items);\n\n            this.updateLicensed(ids);\n        },\n\n        /**\n         * Updates the licensed data when user data is updated.\n         */\n        handleUserUpdate: function () {\n            var ids = this.getIds(this.rows);\n\n            this.updateLicensed(ids);\n        },\n\n        /**\n         * Set Licensed images data.\n         *\n         * @param {Array} ids\n         */\n        updateLicensed: function (ids) {\n            if (!this.isUserAuthorized() || ids.length === 0) {\n                this.licensed({});\n\n                return;\n            }\n\n            getLicenseStatus(this.getImagesUrl, ids).then(function (licensed) {\n                this.licensed(licensed);\n            }.bind(this));\n        },\n\n        /**\n         * Checks if user is logged in and authorized\n         *\n         * @returns {Boolean}\n         */\n        isUserAuthorized: function () {\n            return !_.isUndefined(this.login()) && this.login().user().isAuthorized;\n        },\n\n        /**\n         * Get all ids from items array\n         *\n         * @param {Array} items\n         * @returns {Number[]}\n         */\n        getIds: function (items) {\n            var ids = [];\n\n            items.forEach(function (record) {\n                ids.push(record.id);\n            });\n\n            return ids;\n        },\n\n        /**\n         * Returns top displacement of overlay according to image height\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Object}\n         */\n        getStyles: function (record) {\n            var height = record.styles().height.replace('px', '') - 40;\n\n            return {\n                top: height + 'px'\n            };\n        },\n\n        /**\n         * If overlay should be visible\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isVisible: function (row) {\n            return this.licensed()[row.id];\n        },\n\n        /**\n         * Get overlay label\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getLabel: function (row) {\n            return this.licensed()[row.id] ? 'Licensed' : '';\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/related.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'underscore',\n    'jquery'\n], function (Component, _, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_AdobeStockImageAdminUi/grid/column/preview/related',\n            filterChipsProvider: 'componentType = filters, ns = ${ $.ns }',\n            filterBookmarksSelector: '.admin__data-grid-action-bookmarks',\n            tabImagesLimit: 4,\n            tabsContainerId: '#adobe-stock-tabs',\n            serieFilterValue: '',\n            modelFilterValue: '',\n            selectedTab: null,\n            loader: false,\n            relatedImages: {\n                series: {},\n                model: {}\n            },\n            statefull: {\n                serieFilterValue: true,\n                modelFilterValue: true\n            },\n            modules: {\n                chips: '${ $.chipsProvider }',\n                filterChips: '${ $.filterChipsProvider }',\n                preview: '${ $.parentName }.preview'\n            },\n            exports: {\n                serieFilterValue: '${ $.provider }:params.filters.serie_id',\n                modelFilterValue: '${ $.provider }:params.filters.model_id'\n            }\n        },\n\n        /**\n         * Initializes related component.\n         */\n        initialize: function () {\n            this._super();\n\n            this.filterChips().updateActive();\n\n            return this;\n        },\n\n        /**\n         * Disable keydown event for related content tabs\n         */\n        disableTabsKeyDownEvent: function () {\n            if ($(this.tabsContainerId + ' li[role=tab]').length === 0) {\n                setTimeout(function () {\n                    this.disableTabsKeyDownEvent();\n                }.bind(this), 100);\n            } else {\n                $(this.tabsContainerId + ' li[role=tab]').off('keydown');\n            }\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'serieFilterValue',\n                    'modelFilterValue',\n                    'selectedTab',\n                    'relatedImages',\n                    'loader'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Check if visible container\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        isVisible: function (record) {\n            return this.showSeriesTab(record) && this.showModelTab(record);\n        },\n\n        /**\n         * Get image related image series.s\n         *\n         * @param {Object} record\n         */\n        loadRelatedImages: function (record) {\n            var series = this.getSeries(record),\n                model = this.getModel(record);\n\n            if (series && series.length ||\n                model && model.length\n            ) {\n                return;\n            }\n            $.ajax({\n                type: 'GET',\n                url: this.preview().relatedImagesUrl,\n                dataType: 'json',\n                beforeSend: function () {\n                    this.loader(true);\n                }.bind(this),\n                data: {\n                    'image_id': record.id,\n                    'limit': this.tabImagesLimit\n                }\n            }).done(function (data) {\n                var relatedImages = this.relatedImages();\n\n                this.loader(false);\n                relatedImages.series[record.id] = data.result['same_series'];\n                relatedImages.model[record.id] = data.result['same_model'];\n\n                this.relatedImages(relatedImages);\n                this.preview().updateHeight();\n\n                /* Switch to the model tab if the series tab is hidden */\n                if (relatedImages.series[record.id].length === 0 && relatedImages.model[record.id].length > 0) {\n                    // eslint-disable-next-line jquery-no-input-event-shorthand\n                    $('#adobe-stock-tabs').data().mageTabs.select(1);\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Returns true if the series tab should be show, false otherwise\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        showSeriesTab: function (record) {\n            return typeof this.relatedImages().series[record.id] === 'undefined' ||\n                this.relatedImages().series[record.id].length !== 0;\n        },\n\n        /**\n         * Returns true if the model tab should be show, false otherwise\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        showModelTab: function (record) {\n            return typeof this.relatedImages().model[record.id] === 'undefined' ||\n                this.relatedImages().model[record.id].length !== 0;\n        },\n\n        /**\n         * Returns series to display under the image\n         *\n         * @param {Object} record\n         * @returns {*[]}\n         */\n        getSeries: function (record) {\n            return this.relatedImages().series[record.id] || [];\n        },\n\n        /**\n         * Check if the number of related series image is greater than 4 or not\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        canShowMoreSeriesImages: function (record) {\n            return this.getSeries(record).length >= this.tabImagesLimit;\n        },\n\n        /**\n         * Returns model to display under the image\n         *\n         * @param {Object} record\n         * @returns {*[]}\n         */\n        getModel: function (record) {\n            return this.relatedImages().model[record.id] || [];\n        },\n\n        /**\n         * Check if the number of related model image is greater than 4 or not\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        canShowMoreModelImages: function (record) {\n            return this.getModel(record).length >= this.tabImagesLimit;\n        },\n\n        /**\n         * Filter images from serie_id\n         *\n         * @param {Object} record\n         */\n        seeMoreFromSeries: function (record) {\n            if (this.isSerieFilterApplied(record)) {\n                this.scrollToFilter();\n\n                return;\n            }\n            this.serieFilterValue(record.id);\n            this.applyFilter('serie_id', record.id.toString());\n        },\n\n        /**\n         * Filter images from serie_id\n         *\n         * @param {Object} record\n         */\n        seeMoreFromModel: function (record) {\n            if (this.isModelFilterApplied(record)) {\n                this.scrollToFilter();\n\n                return;\n            }\n            this.modelFilterValue(record.id);\n            this.applyFilter('model_id', record.id.toString());\n        },\n\n        /**\n         * Apply series or model id filter and scroll to top of the page\n         *\n         * @param {String} typeId\n         * @param {String} recordId\n         */\n        applyFilter: function (typeId, recordId) {\n            var data = {};\n\n            data[typeId] = recordId;\n\n            this.filterChips().clear();\n            this.filterChips().setData(data, true);\n            this.filterChips().apply();\n\n            this.scrollToFilter();\n        },\n\n        /**\n         * Checks if the filter is applied\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isSerieFilterApplied: function (record) {\n            return this.filterChips().get('applied')['serie_id'] === record.id.toString();\n        },\n\n        /**\n         * Checks if the filter is applied\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isModelFilterApplied: function (record) {\n            return this.filterChips().get('applied')['model_id'] === record.id.toString();\n        },\n\n        /**\n         * Scrolls user window to the filter bookmarks\n         */\n        scrollToFilter: function () {\n            $(this.preview().adobeStockModalSelector + ' ' + this.filterBookmarksSelector).get(0).scrollIntoView({\n                behavior: 'smooth',\n                block: 'center',\n                inline: 'nearest'\n            });\n        },\n\n        /**\n         * Next related image preview\n         *\n         * @param {Object} record\n         */\n        nextRelated: function (record) {\n            var relatedList = this.selectedTab() === 'series' ? this.getSeries(record) : this.getModel(record),\n                nextRelatedIndex = _.findLastIndex(\n                    relatedList,\n                    {\n                        id: this.preview().displayedRecord().id\n                    }\n                ) + 1,\n                nextRelated = relatedList[nextRelatedIndex];\n\n            if (typeof nextRelated === 'undefined') {\n                return;\n            }\n\n            this.switchImagePreviewToRelatedImage(nextRelated);\n        },\n\n        /**\n         * Previous related preview\n         *\n         * @param {Object} record\n         */\n        prevRelated: function (record) {\n            var relatedList = this.selectedTab() === 'series' ? this.getSeries(record) : this.getModel(record),\n                prevRelatedIndex = _.findLastIndex(\n                    relatedList,\n                    {\n                        id: this.preview().displayedRecord().id\n                    }\n                ) - 1,\n                prevRelated = relatedList[prevRelatedIndex];\n\n            if (typeof prevRelated === 'undefined') {\n                return;\n            }\n\n            this.switchImagePreviewToRelatedImage(prevRelated);\n        },\n\n        /**\n         * Get previous button disabled\n         *\n         * @param {Object} record\n         *\n         * @return {Boolean}\n         */\n        cannotViewPrevious: function (record) {\n            var relatedList, prevRelatedIndex, prevRelated;\n\n            if (!this.selectedTab()) {\n                return false;\n            }\n            relatedList = this.selectedTab() === 'series' ? this.getSeries(record) : this.getModel(record);\n            prevRelatedIndex = _.findLastIndex(\n                relatedList,\n                {\n                    id: this.preview().displayedRecord().id\n                }\n            ) - 1;\n            prevRelated = relatedList[prevRelatedIndex];\n\n            return typeof prevRelated === 'undefined';\n        },\n\n        /**\n         * Get next button disabled\n         *\n         * @param {Object} record\n         *\n         * @return {Boolean}\n         */\n        cannotViewNext: function (record) {\n            var relatedList, nextRelatedIndex, nextRelated;\n\n            if (!this.selectedTab()) {\n                return false;\n            }\n            relatedList = this.selectedTab() === 'series' ? this.getSeries(record) : this.getModel(record);\n            nextRelatedIndex = _.findLastIndex(\n                relatedList,\n                {\n                    id: this.preview().displayedRecord().id\n                }\n            ) + 1;\n            nextRelated = relatedList[nextRelatedIndex];\n\n            return typeof nextRelated === 'undefined';\n        },\n\n        /**\n         * Switch image preview to related image\n         *\n         * @param {Object|null} relatedImage\n         */\n        switchImagePreviewToRelatedImage: function (relatedImage) {\n            if (!relatedImage) {\n                this.selectedTab(null);\n\n                return;\n            }\n\n            if (this.preview().displayedRecord().id === relatedImage.id) {\n                return;\n            }\n\n            this.preview().showRelated(relatedImage);\n        },\n\n        /**\n         * Switch image preview to series image\n         *\n         * @param {Object} record\n         */\n        switchImagePreviewToSeriesImage: function (record) {\n            this.selectedTab('series');\n            this.switchImagePreviewToRelatedImage(record);\n        },\n\n        /**\n         * Switch image preview to model image\n         *\n         * @param {Object} record\n         */\n        switchImagePreviewToModelImage: function (record) {\n            this.selectedTab('model');\n            this.switchImagePreviewToRelatedImage(record);\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/keywords.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'underscore'\n], function (Component, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_AdobeStockImageAdminUi/grid/column/preview/keywords',\n            chipsProvider: 'componentType = filtersChips, ns = ${ $.ns }',\n            defaultKeywordsLimit: 5,\n            keywordsLimit: 5,\n            canViewMoreKeywords: true,\n            modules: {\n                chips: '${ $.chipsProvider }',\n                preview: '${ $.parentName }.preview'\n            }\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'keywordsLimit',\n                    'canViewMoreKeywords'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Returns keywords to display under the attributes image\n         *\n         * @returns {*[]}\n         */\n        getKeywords: function (record) {\n            return record.keywords;\n        },\n\n        /**\n         * Returns keywords limit to show no of keywords\n         */\n        getKeywordsLimit: function () {\n            return this.keywordsLimit();\n        },\n\n        /**\n         * Show all the related keywords\n         */\n        viewAllKeywords: function (record) {\n            this.keywordsLimit(record.keywords.length);\n            this.canViewMoreKeywords(false);\n            this.preview().updateHeight();\n            this.preview().scrollToPreview();\n        },\n\n        /**\n         * Hide all the related keywords\n         */\n        hideAllKeywords: function () {\n            this.keywordsLimit(this.defaultKeywordsLimit);\n            this.canViewMoreKeywords(true);\n        },\n\n        /**\n         * Drop all filters and initiate search on keyword click event\n         */\n        searchByKeyWord: function (keyword) {\n            _.invoke(this.chips().elems(), 'clear');\n            _.invoke(this.chips().elems(), 'apply', keyword);\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'uiRegistry',\n    'jquery',\n    'underscore',\n    'Magento_AdobeStockImageAdminUi/js/action/save',\n    'Magento_AdobeStockImageAdminUi/js/action/savePreview',\n    'Magento_AdobeStockImageAdminUi/js/action/saveLicensed',\n    'Magento_AdobeStockImageAdminUi/js/action/licenseAndSave',\n    'Magento_AdobeStockImageAdminUi/js/action/confirmQuota',\n    'Magento_AdobeStockImageAdminUi/js/media-gallery',\n    'Magento_AdobeStockImageAdminUi/js/confirmation/buyCredits',\n    'Magento_AdobeStockImageAdminUi/js/action/getLicenseStatus',\n    'Magento_Ui/js/modal/alert'\n], function (\n    Component,\n    uiRegistry,\n    $,\n    _,\n    saveAction,\n    savePreviewAction,\n    saveLicensedAction,\n    licenseAndSaveAction,\n    confirmQuotaAction,\n    mediaGallery,\n    buyCreditsConfirmation,\n    getLicenseStatus,\n    uiAlert\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_AdobeStockImageAdminUi/grid/column/preview/actions',\n            loginProvider: 'name = adobe-login, ns = adobe-login',\n            mediaGallerySelector: '.media-gallery-modal:has(#search_adobe_stock)',\n            adobeStockModalSelector: '.adobe-search-images-modal',\n            downloadImagePreviewUrl: 'adobe_stock/preview/download',\n            licenseAndDownloadUrl: 'adobe_stock/license/license',\n            saveLicensedAndDownloadUrl: 'adobe_stock/license/saveLicensed',\n            buyCreditsUrl: 'https://stock.adobe.com/',\n            messageDelay: 5,\n            mediaGallery: '',\n            imageItems: [],\n            messages: [],\n            listens: {\n                '${ $.provider }:data.items': 'updateActions'\n            },\n            modules: {\n                login: '${ $.loginProvider }',\n                preview: '${ $.parentName }.preview',\n                overlay: '${ $.parentName }.overlay',\n                source: '${ $.provider }',\n                imageDirectory: '${ $.mediaGalleryName }',\n                mediaGallerySortBy: '${ $.mediaGallerySortBy }',\n                mediaGallerySearchInput: '${ $.mediaGallerySearchInput }',\n                mediaGalleryListingFilters: '${ $.mediaGalleryListingFilters }',\n                listingPaging: '${ $.listingPaging }'\n            },\n            imports: {\n                imageItems: '${ $.mediaGalleryProvider }:data.items'\n            }\n        },\n\n        /**\n         * Init observable variables\n         *\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'imageItems',\n                    'messages'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Update displayed record data on data source update\n         */\n        updateActions: function () {\n            var displayedRecord = this.preview().displayedRecord(),\n                updatedDisplayedRecord = this.preview().displayedRecord(),\n                records = this.source().data.items,\n                index;\n\n            if (typeof displayedRecord.id === 'undefined') {\n                return;\n            }\n\n            for (index = 0; index < records.length; index++) {\n                if (records[index].id === displayedRecord.id) {\n                    updatedDisplayedRecord = records[index];\n                    break;\n                }\n            }\n\n            this.preview().displayedRecord(updatedDisplayedRecord);\n        },\n\n        /**\n         * Returns is_downloaded flag as observable for given record\n         *\n         * @returns {observable}\n         */\n        isDownloaded: function () {\n            return this.preview().displayedRecord()['is_downloaded'];\n        },\n\n        /**\n         * Is asset licensed in adobe stock in context of currently logged in account\n         *\n         * @returns {observable}\n         */\n        isLicensed: function () {\n            return this.overlay().licensed()[this.preview().displayedRecord().id] && !this.isLicensedLocally();\n        },\n\n        /**\n         * Is licensed version of asset saved locally\n         *\n         * @returns {observable}\n         */\n        isLicensedLocally: function () {\n            return this.preview().displayedRecord()['is_licensed_locally'];\n        },\n\n        /**\n         * Locate downloaded image in media browser\n         */\n        openInMediaGalleryClick: function () {\n            this.preview().getAdobeModal().trigger('closeModal');\n\n            if (!this.isMediaBrowser()) {\n                this.selectImageInNewMediaGalleryBySearch(this.preview().displayedRecord().id);\n            } else {\n                this.selectDisplayedImageForOldMediaGallery(this.preview().displayedRecord().path);\n            }\n        },\n\n        /**\n         * Return adobe stock asset by adobe id\n         *\n         * @param {String} adobeId\n         */\n        getAssetDetails: function (adobeId) {\n            return $.ajax({\n                url: this.getMediaGalleryAsset,\n                data: {\n                    'adobe_id': adobeId\n                },\n                context: this,\n                showLoader: true\n            });\n        },\n\n        /**\n         * Select image in new media gallery via search input\n         *\n         * @param {String} imageId\n         */\n        selectImageInNewMediaGalleryBySearch: function (imageId) {\n            var path;\n\n            this.mediaGalleryListingFilters().clear();\n            this.getAssetDetails(imageId).then(function (assetDetails) {\n                if (assetDetails.length === 0) {\n                    return;\n                }\n                this.mediaGallerySearchInput().apply(assetDetails.title);\n                path = assetDetails.path;\n                path = path.substring(0, path.lastIndexOf('/'));\n\n                if (path !== '') {\n                    this.imageDirectory().locateNode(path);\n                }\n                this.selectRecordFromMediaGalleryProvider(assetDetails.path);\n            }.bind(this));\n\n        },\n\n        /**\n         * Open recently saved image and go to first page\n         */\n        openNewestImage: function () {\n            this.listingPaging().goFirst();\n            this.mediaGallerySortBy().selectDefaultOption();\n        },\n\n        /**\n         * Selects displayed image in media gallery for old gallery\n         */\n        selectDisplayedImageForOldMediaGallery: function (path) {\n            var image = mediaGallery.locate(path);\n\n            image ? image.trigger('click') : mediaGallery.notLocated();\n        },\n\n        /**\n         * Select record by image file name\n         *\n         * @param {String} path\n         */\n        selectRecordFromMediaGalleryProvider: function (path) {\n            var subscription;\n\n            subscription = this.imageItems.subscribe(function (items) {\n                subscription.dispose();\n                items.each(function (item) {\n                    if (item.path === path) {\n                        this.selectRecord(item);\n\n                        return false;\n                    }\n                }.bind(this));\n            }.bind(this));\n\n            setTimeout(function () {\n                subscription.dispose();\n            }, 1500);\n        },\n\n        /**\n         * Set the record as selected\n         *\n         * @param {Object} record\n         */\n        selectRecord: function (record) {\n            uiRegistry.get('name =' + this.mediaGallery).select(record);\n        },\n\n        /**\n         * Save preview click handler\n         */\n        savePreviewClick: function () {\n            var record = this.preview().displayedRecord();\n\n            savePreviewAction(\n                this.preview().downloadImagePreviewUrl,\n                record.id,\n                record.title,\n                record['content_type'],\n                this.getDestinationDirectoryPath()\n            ).then(function (destinationPath) {\n                this.updateDownloadedDisplayedRecord(destinationPath);\n                this.reloadGrid().done(function () {\n                    this.openInMediaGalleryClick();\n                }.bind(this));\n            }.bind(this)).fail(function (error) {\n                if (error) {\n                    this.showErrorMessage(error);\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Update displayed record after downloading\n         *\n         * @param {String} path\n         */\n        updateDownloadedDisplayedRecord: function (path) {\n            var record = this.preview().displayedRecord();\n\n            record['is_downloaded'] = 1;\n\n            if (record.path === '') {\n                record.path = path;\n            }\n\n            this.preview().displayedRecord(record);\n        },\n\n        /**\n         * Update displayed record after licensing\n         *\n         * @param {String} path\n         */\n        updateLicensedDisplayedRecord: function (path) {\n            var record = this.preview().displayedRecord();\n\n            record['is_downloaded'] = 1;\n\n            if (record.path === '') {\n                record.path = path;\n            }\n\n            record['is_licensed'] = 1;\n            record['is_licensed_locally'] = 1;\n\n            this.preview().displayedRecord(record);\n        },\n\n        /**\n         * Get image destination path\n         *\n         * @param {String} fileName\n         * @param {String} contentType\n         * @returns {String}\n         */\n        getDestinationPath: function (fileName, contentType) {\n            return this.getDestinationDirectoryPath() + '/' + fileName + '.' + this.getImageExtension(contentType);\n        },\n\n        /**\n         * Get destination directory path\n         *\n         * @returns {String}\n         */\n        getDestinationDirectoryPath: function () {\n            var activeNodePath,\n                activeNode;\n\n            if (this.isMediaBrowser()) {\n                activeNode = this.getMageMediaBrowserData().activeNode;\n\n                activeNodePath = _.isUndefined(activeNode.original.path) ? '' : activeNode.original.path;\n            } else {\n                activeNodePath = this.imageDirectory().activeNode() || '';\n            }\n\n            return activeNodePath;\n        },\n\n        /**\n         * Reload grid\n         *\n         * @returns {*}\n         */\n        reloadGrid: function () {\n            var provider,\n                dataStorage;\n\n            if (this.isMediaBrowser()) {\n                return this.getMageMediaBrowserData().reload();\n            }\n\n            provider = uiRegistry.get('index = media_gallery_listing_data_source'),\n                dataStorage = provider.storage();\n\n            dataStorage.clearRequests();\n\n            return provider.reload();\n        },\n\n        /**\n         * Get data for media browser\n         *\n         * @returns {Undefined|Object}\n         */\n        getMageMediaBrowserData: function () {\n            return $(this.preview().mediaGallerySelector).data('mageMediabrowser');\n        },\n\n        /**\n         * Is the media browser used in the content of the grid\n         *\n         * @returns {Boolean}\n         */\n        isMediaBrowser: function () {\n            return typeof this.getMageMediaBrowserData() !== 'undefined';\n        },\n\n        /**\n         * Generate meaningful name image file,\n         * allow only alphanumerics, dashes, and underscores\n         *\n         * @param {String} title\n         * @param {Number} id\n         * @return string\n         */\n        generateImageName: function (title, id) {\n            var fileName = title.substring(0, 32)\n                .replace(/[^a-zA-Z0-9_]/g, '-')\n                .replace(/-{2,}/g, '-')\n                .toLowerCase();\n\n            /* If the filename does not contain latin chars, use ID as a filename */\n            return fileName === '-' ? id : fileName;\n        },\n\n        /**\n         * Get image file extension\n         *\n         * @param {String} contentType\n         * @return string\n         */\n        getImageExtension: function (contentType) {\n            return contentType.match(/[^/]{1,4}$/);\n        },\n\n        /**\n         * Get messages\n         *\n         * @return {Array}\n         */\n        getMessages: function () {\n            return this.messages();\n        },\n\n        /**\n         * License click handler\n         */\n        licenseClick: function () {\n            var record = this.preview().displayedRecord();\n\n            this.licenseProcess(\n                record.id,\n                record.title,\n                record.path,\n                record['content_type'],\n                this.isDownloaded()\n            ).then(function (destinationPath) {\n                this.updateLicensedDisplayedRecord(destinationPath);\n                this.login().getUserQuota();\n                this.reloadGrid().done(function () {\n                    this.openInMediaGalleryClick();\n                }.bind(this));\n            }.bind(this)).fail(function (error) {\n                if (error) {\n                    uiAlert({\n                        content: error\n                    });\n                }\n            });\n        },\n\n        /**\n         * Process of license\n         *\n         * @param {Number} id\n         * @param {String} title\n         * @param {String} path\n         * @param {String} contentType\n         * @param {Boolean} isDownloaded\n         * @return {window.Promise}\n         */\n        licenseProcess: function (id, title, path, contentType, isDownloaded) {\n            var deferred = $.Deferred();\n\n            this.login().login()\n                .then(function () {\n                    getLicenseStatus(\n                        this.overlay().getImagesUrl,\n                        [id]\n                    ).then(function (licensedInfo) {\n                        var isLicensed = licensedInfo[id] || false;\n\n                        if (isLicensed) {\n                            saveLicensedAction(\n                                this.preview().saveLicensedAndDownloadUrl,\n                                id,\n                                title,\n                                path,\n                                contentType,\n                                this.getDestinationDirectoryPath()\n                            ).then(function (destinationPath) {\n                                deferred.resolve(destinationPath);\n                            }).fail(function (error) {\n                                deferred.reject(error);\n                            });\n                        } else {\n                            confirmQuotaAction(this.preview().confirmationUrl, id).then(function (data) {\n                                if (data.canLicense === false) {\n                                    buyCreditsConfirmation(\n                                        this.preview().buyCreditsUrl,\n                                        title,\n                                        data.message\n                                    );\n                                } else {\n                                    licenseAndSaveAction(\n                                        this.preview().licenseAndDownloadUrl,\n                                        id,\n                                        title,\n                                        path,\n                                        contentType,\n                                        isDownloaded,\n                                        data.message,\n                                        this.getDestinationDirectoryPath()\n                                    ).then(function (destinationPath) {\n                                        deferred.resolve(destinationPath);\n                                    }).fail(function (error) {\n                                        deferred.reject(error);\n                                    });\n                                }\n                            }.bind(this)).fail(function (error) {\n                                deferred.reject(error);\n                            });\n                        }\n                    }.bind(this)).fail(function (error) {\n                        deferred.reject(error);\n                    });\n                }.bind(this)).fail(function (error) {\n                deferred.reject(error);\n            });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Save licensed click handler\n         */\n        saveLicensedClick: function () {\n            var record = this.preview().displayedRecord();\n\n            if (!this.login().user().isAuthorized) {\n                return;\n            }\n\n            if (!this.isLicensed()) {\n                return;\n            }\n\n            saveLicensedAction(\n                this.preview().saveLicensedAndDownloadUrl,\n                record.id,\n                record.title,\n                record.path,\n                record['content_type'],\n                this.getDestinationDirectoryPath()\n            ).then(function (destinationPath) {\n                this.updateLicensedDisplayedRecord(destinationPath);\n                this.login().getUserQuota();\n                this.reloadGrid().done(function () {\n                    this.openInMediaGalleryClick();\n                }.bind(this));\n            }.bind(this)).fail(function (error) {\n                if (error) {\n                    uiAlert({\n                        content: error\n                    });\n                }\n            });\n        },\n\n        /**\n         * Returns license button title depending on the existing saved preview\n         *\n         * @returns {String}\n         */\n        getLicenseButtonTitle: function () {\n            return this.isDownloaded() ? $.mage.__('License') : $.mage.__('License and Save');\n        },\n\n        /**\n         * Extracts image name from its path\n         *\n         * @param {String} path\n         * @returns {String}\n         */\n        getImageNameFromPath: function (path) {\n            var filePathArray = path.split('/'),\n                imageIndex = filePathArray.length - 1;\n\n            return filePathArray[imageIndex].substring(0, filePathArray[imageIndex].lastIndexOf('.'));\n        },\n\n        /**\n         * Show error message and schedule cleanup\n         *\n         * @param {String} message\n         */\n        showErrorMessage: function (message) {\n            this.messages.push({\n                code: 'error',\n                messageUnsanitizedHtml: message\n            });\n            this.messagesCleanup();\n        },\n\n        /**\n         * Messages cleanup\n         */\n        messagesCleanup: function () {\n            // eslint-disable-next-line no-unused-vars\n            var timerId;\n\n            // eslint-disable-next-line no-unused-vars\n            timerId = setTimeout(function () {\n                clearTimeout(timerId);\n                this.messages.removeAll();\n            }.bind(this), Number(this.messageDelay) * 1000);\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/mediaGallery/grid/columns/licenseImage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_MediaGalleryUi/js/grid/columns/image'\n], function (Image) {\n    'use strict';\n\n    return Image.extend({\n        defaults: {\n            viewConfig: [\n                {\n                    component: 'Magento_AdobeStockImageAdminUi/js/mediaGallery/grid/columns/image/licenseActions',\n                    name: '${ $.name }_actions',\n                    imageModelName: '${ $.name }',\n                    imageDetailsUrl: '${ $.imageDetailsurl }',\n                    imageComponent: '${ $.imageComponent }'\n                }\n            ]\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/mediaGallery/grid/columns/image/licenseActions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_MediaGalleryUi/js/grid/columns/image/actions',\n    'Magento_MediaGalleryUi/js/action/getDetails',\n    'mage/translate'\n], function ($, _, Action, getDetails) {\n    'use strict';\n\n    return Action.extend({\n        defaults: {\n            template: 'Magento_AdobeStockImageAdminUi/mediaGallery/grid/columns/image/licenseActions',\n            licenseAction: {\n                name: 'license',\n                title: $.mage.__('License'),\n                handler: 'licenseImageAction'\n            },\n            modules: {\n                image: '${ $.imageComponent }'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.actionsList.push(this.licenseAction);\n\n            return this;\n        },\n\n        /**\n         * Init observable variables\n         *\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'visible'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * License image\n         *\n         * @param {Object} record\n         */\n        licenseImageAction: function (record) {\n            this.getImageRecord(record.id);\n        },\n\n        /**\n         * Check if image licensed\n         *\n         * @param {Object} record\n         * @param {Object} name\n         */\n        isVisible: function (record, name) {\n            if (name === this.licenseAction.name) {\n                if (_.isUndefined(record.overlay) || record.overlay === '') {\n                    return false;\n                }\n\n                return true;\n            }\n\n            return true;\n        },\n\n        /**\n         * Get image record and start license process\n         *\n         * @param {Number} imageId\n         */\n        getImageRecord: function (imageId) {\n            getDetails(this.imageDetailsUrl, [imageId]).then(function (imageDetails) {\n                var id = imageDetails[imageId]['adobe_stock'][0].value;\n\n                this.image().actions().licenseProcess(\n                    id,\n                    imageDetails[imageId].title,\n                    imageDetails[imageId].path,\n                    imageDetails[imageId]['content_type'],\n                    true\n                ).then(function () {\n                    this.image().actions().login().getUserQuota();\n                    this.imageModel().reloadGrid();\n                    this.imageModel().addMessage('success', $.mage.__('The image has been licensed.'));\n                }.bind(this)).fail(function (error) {\n                    if (error) {\n                        this.imageModel().addMessage('error', error);\n                    }\n                }.bind(this));\n            }.bind(this)).fail(function (message) {\n                this.imageModel().addMessage('error', message);\n            }.bind(this));\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/action/getLicenseStatus.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (requestUrl, ids) {\n        var deferred = $.Deferred();\n\n        $.ajax({\n            type: 'GET',\n            url: requestUrl + '?ids=' + ids.join(','),\n            data: {\n                'form_key': window.FORM_KEY\n            },\n            showLoader: true,\n            dataType: 'json',\n\n            /**\n             * Resolve with the response result\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                deferred.resolve(response.result);\n            },\n\n            /**\n             * Reject with the message from response\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n                var message = response.message;\n\n                if (response.status === 403) {\n                    message = $.mage.__('Your admin role does not have permissions to license an image');\n                }\n\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/savePreview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_AdobeStockImageAdminUi/js/action/save',\n    'Magento_AdobeStockImageAdminUi/js/confirmation/save',\n    'Magento_AdobeStockImageAdminUi/js/path-utility'\n], function ($, saveAction, saveConfirmation, pathUtility) {\n    'use strict';\n\n    return function (requestUrl, id, title, contentType, directoryPath) {\n        var deferred = $.Deferred(),\n            destinationPath;\n\n        saveConfirmation(\n            pathUtility.generateImageName(title, id),\n            pathUtility.getImageExtension(contentType)\n        ).then(function (fileName) {\n            destinationPath = pathUtility.buildPath(directoryPath, fileName, contentType);\n\n            saveAction(\n                requestUrl,\n                id,\n                destinationPath\n            ).then(function () {\n                deferred.resolve(destinationPath);\n            }).fail(function (error) {\n                deferred.reject(error);\n            });\n        }).fail(function (error) {\n            deferred.reject(error);\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/confirmQuota.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (requestUrl, adobeAssetId) {\n        var deferred = $.Deferred();\n\n        $.ajax({\n            type: 'GET',\n            url: requestUrl,\n            dataType: 'json',\n            data: {\n                'media_id': adobeAssetId\n            },\n            showLoader: true,\n\n            /**\n             * Extract the data from the response and resolve\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                deferred.resolve({\n                    canLicense: response.result.canLicense,\n                    message: response.result.message\n                });\n            },\n\n            /**\n             * Extract the error message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n                var message = response.JSON ? response.JSON.message\n                    : $.mage.__('Could not fetch licensing information.');\n\n                if (response.status === 403) {\n                    message = $.mage.__('Your admin role does not have permissions to license an image');\n                }\n\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/saveLicensed.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_AdobeStockImageAdminUi/js/action/save',\n    'Magento_AdobeStockImageAdminUi/js/confirmation/saveLicensed',\n    'Magento_AdobeStockImageAdminUi/js/path-utility'\n], function ($, saveAction, saveLicensedConfirmation, pathUtility) {\n    'use strict';\n\n    return function (requestUrl, id, title, path, contentType, directoryPath) {\n        var imageName = '',\n            destinationPath,\n            deferred = $.Deferred();\n\n        if (path !== '') {\n            imageName = pathUtility.getImageNameFromPath(path);\n            destinationPath = pathUtility.buildPath(directoryPath, imageName, contentType);\n            saveAction(\n                requestUrl,\n                id,\n                destinationPath\n            ).then(function () {\n                deferred.resolve(destinationPath);\n            }).fail(function (message) {\n                deferred.reject(message);\n            });\n\n            return deferred.promise();\n        }\n\n        saveLicensedConfirmation(\n            pathUtility.generateImageName(title, id),\n            pathUtility.getImageExtension(contentType)\n        ).then(function (fileName) {\n            destinationPath = pathUtility.buildPath(directoryPath, fileName, contentType);\n            saveAction(\n                requestUrl,\n                id,\n                destinationPath\n            ).then(function () {\n                deferred.resolve(destinationPath);\n            }).fail(function (message) {\n                deferred.reject(message);\n            });\n        }).fail(function (error) {\n            deferred.reject(error);\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/licenseAndSave.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_AdobeStockImageAdminUi/js/action/save',\n    'Magento_AdobeStockImageAdminUi/js/confirmation/license',\n    'Magento_AdobeStockImageAdminUi/js/path-utility'\n], function ($, saveAction, licenseConfirmation, pathUtility) {\n    'use strict';\n\n    return function (\n        requestUrl,\n        id,\n        title,\n        path,\n        contentType,\n        isDownloaded,\n        quotaMessage,\n        directoryPath\n    ) {\n        var deferred = $.Deferred(),\n            destinationPath;\n\n        licenseConfirmation(\n                title,\n                quotaMessage,\n                isDownloaded,\n                pathUtility.generateImageName(title, id),\n                pathUtility.getImageExtension(contentType)\n            ).then(function (fileName) {\n\n                if (typeof fileName === 'undefined') {\n                    fileName = pathUtility.getImageNameFromPath(path);\n                }\n\n                destinationPath = pathUtility.buildPath(directoryPath, fileName, contentType);\n\n                saveAction(\n                    requestUrl,\n                    id,\n                    destinationPath\n                ).then(function () {\n                    deferred.resolve(destinationPath);\n                }).fail(function (message) {\n                    deferred.reject(message);\n                });\n            }).fail(function (error) {\n                deferred.reject(error);\n            });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/save.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (requestUrl, adobeAssetId, destinationPath) {\n        var deferred = $.Deferred();\n\n        $.ajax({\n            type: 'POST',\n            url: requestUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: {\n                'media_id': adobeAssetId,\n                'destination_path': destinationPath\n            },\n\n            /**\n             * Resolve on success\n             */\n            success: function () {\n                deferred.resolve();\n            },\n\n            /**\n             * Extract the error message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n                var message;\n\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = 'Could not save the asset!';\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_SalesRule/js/form/element/manage-coupon-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (_, uiRegistry, fieldset, async) {\n    'use strict';\n\n    return fieldset.extend({\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Initialize element\n         *\n         * @returns {Abstract} Chainable\n         */\n        initialize: function (elems, position) {\n            var obj = this;\n\n            this._super();\n\n            async.async('#sales-rule-form-tab-coupons', document.getElementById('container'), function (node) {\n                var useAutoGeneration = uiRegistry.get(\n                    'sales_rule_form.sales_rule_form.rule_information.use_auto_generation'\n                );\n\n                useAutoGeneration.on('checked', function () {\n                    obj.enableDisableFields();\n                });\n                obj.enableDisableFields();\n            });\n\n            return this;\n        },\n\n        /*eslint-enable no-unused-vars*/\n        /*eslint-disable lines-around-comment*/\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            /**\n             * \\Magento\\Rule\\Model\\AbstractModel::COUPON_TYPE_AUTO\n             */\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/coupon-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/select'\n], function (_, uiRegistry, select) {\n    'use strict';\n\n    return select.extend({\n\n        /**\n         * Hide fields on coupon tab\n         */\n        onUpdate: function () {\n\n            /* eslint-disable eqeqeq */\n            if (this.value() != this.displayOnlyForCouponType) {\n                uiRegistry.get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation').checked(false);\n            }\n\n            this.enableDisableFields();\n        },\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/apply_to_shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox-toggle-notice'\n], function (Checkbox) {\n    'use strict';\n\n    return Checkbox.extend({\n        defaults: {\n            imports: {\n                toggleDisabled: '${ $.parentName }.simple_action:value'\n            }\n        },\n\n        /**\n         * Toggle element disabled state according to simple action value.\n         *\n         * @param {String} action\n         */\n        toggleDisabled: function (action) {\n            switch (action) {\n                default:\n                    this.disabled(false);\n            }\n\n            if (this.disabled()) {\n                this.checked(false);\n            }\n        }\n    });\n});\n","Magento_Review/js/rating.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('marketing.ratingControl', {\n        options: {\n            colorFilled: '#333',\n            colorUnfilled: '#CCCCCC',\n            colorHover: '#f30'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._labels = this.element.find('label');\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this._labels.on({\n                click: $.proxy(function (e) {\n                    $(e.currentTarget).prev().prop('checked', true);\n                    this._updateRating();\n                }, this),\n\n                hover: $.proxy(function (e) {\n                    this._updateHover($(e.currentTarget), this.options.colorHover);\n                }, this),\n\n                mouseleave: $.proxy(function (e) {\n                    this._updateHover($(e.currentTarget), this.options.colorUnfilled);\n                }, this)\n            });\n\n            this._updateRating();\n        },\n\n        /**\n         * @param {jQuery} elem\n         * @param {String} color\n         * @private\n         */\n        _updateHover: function (elem, color) {\n            elem.nextAll('label').addBack().filter(function () {\n                return !$(this).data('checked');\n            }).css('color', color);\n        },\n\n        /**\n         * @private\n         */\n        _updateRating: function () {\n            var checkedInputs = this.element.find('input[type=\"radio\"]:checked');\n\n            checkedInputs.nextAll('label').addBack().css('color', this.options.colorFilled).data('checked', true);\n            checkedInputs.prevAll('label').css('color', this.options.colorUnfilled).data('checked', false);\n        },\n\n        /**\n         * Remove rating when form reset\n         */\n        removeRating: function () {\n            var checkedInputs = this.element.find('input[type=\"radio\"]');\n\n            checkedInputs.nextAll('label').css('color', this.options.colorUnfilled).data('checked', false);\n        }\n    });\n\n});\n","Magento_Email/js/variables.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Variables, updateElementAtCursor */\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Ui/js/modal/modal',\n    'jquery/ui',\n    'prototype'\n], function (jQuery, $t) {\n    'use strict';\n\n    window.Variables = {\n        textareaElementId: null,\n        variablesContent: null,\n        dialogWindow: null,\n        dialogWindowId: 'variables-chooser',\n        overlayShowEffectOptions: null,\n        overlayHideEffectOptions: null,\n        insertFunction: 'Variables.insertVariable',\n        variablesValue: [],\n\n        /**\n         * @param {*} textareaElementId\n         * @param {Function} insertFunction\n         */\n        init: function (textareaElementId, insertFunction) {\n            if ($(textareaElementId)) {\n                this.textareaElementId = textareaElementId;\n            }\n\n            if (insertFunction) {\n                this.insertFunction = insertFunction;\n            }\n        },\n\n        /**\n         * reset data.\n         */\n        resetData: function () {\n            this.variablesContent = null;\n            this.dialogWindow = null;\n        },\n\n        /**\n         * @param {Object} variables\n         */\n        openVariableChooser: function (variables) {\n            if (this.variablesContent == null && variables) {\n                this.variablesContent = '<ul class=\"insert-variable\">';\n                variables.each(function (variableGroup) {\n                    if (variableGroup.label && variableGroup.value) {\n                        this.variablesContent += '<li><b>' + variableGroup.label.escapeHTML() + '</b></li>';\n                        variableGroup.value.each(function (variable) {\n                            if (variable.value && variable.label) {\n                                this.variablesValue.push(variable.value);\n                                this.variablesContent += '<li>' +\n                                    this.prepareVariableRow(this.variablesValue.length, variable.label) + '</li>';\n                            }\n                        }.bind(this));\n                    }\n                }.bind(this));\n                this.variablesContent += '</ul>';\n            }\n\n            if (this.variablesContent) {\n                this.openDialogWindow(this.variablesContent);\n            }\n        },\n\n        /**\n         * @param {*} variablesContent\n         */\n        openDialogWindow: function (variablesContent) {\n            var windowId = this.dialogWindowId;\n\n            jQuery('<div id=\"' + windowId + '\">' + variablesContent + '</div>').modal({\n                title: $t('Insert Variable...'),\n                type: 'slide',\n                buttons: [],\n\n                /** @inheritdoc */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                }\n            });\n\n            jQuery('#' + windowId).modal('openModal');\n        },\n\n        /**\n         * Close dialog window.\n         */\n        closeDialogWindow: function () {\n            jQuery('#' + this.dialogWindowId).modal('closeModal');\n        },\n\n        /**\n         * @param {Number} index\n         * @param {*} varLabel\n         * @return {String}\n         */\n        prepareVariableRow: function (index, varLabel) {\n            return '<a href=\"#\" onclick=\"' +\n                this.insertFunction +\n                '(' +\n                index +\n                ');return false;\">' +\n                varLabel.escapeHTML() +\n                '</a>';\n        },\n\n        /**\n         * @param {*} variable\n         */\n        insertVariable: function (variable) {\n            var windowId = this.dialogWindowId,\n                textareaElm, scrollPos;\n\n            jQuery('#' + windowId).modal('closeModal');\n            textareaElm = $(this.textareaElementId);\n\n            if (textareaElm) {\n                scrollPos = textareaElm.scrollTop;\n\n                if (!isNaN(variable)) {\n                    updateElementAtCursor(textareaElm, Variables.variablesValue[variable - 1]);\n                } else {\n                    updateElementAtCursor(textareaElm, variable);\n                }\n                textareaElm.focus();\n                textareaElm.scrollTop = scrollPos;\n                jQuery(textareaElm).trigger('change');\n                textareaElm = null;\n            }\n        }\n    };\n\n    window.MagentovariablePlugin = {\n        editor: null,\n        variables: null,\n        textareaId: null,\n\n        /**\n         * @param {*} editor\n         */\n        setEditor: function (editor) {\n            this.editor = editor;\n        },\n\n        /**\n         * @param {String} url\n         * @param {*} textareaId\n         */\n        loadChooser: function (url, textareaId) {\n            this.textareaId = textareaId;\n\n            if (this.variables == null) {\n                new Ajax.Request(url, {\n                    parameters: {},\n                    onComplete: function (transport) {\n                        if (transport.responseText.isJSON()) {\n                            Variables.init(null, 'MagentovariablePlugin.insertVariable');\n                            this.variables = transport.responseText.evalJSON();\n                            this.openChooser(this.variables);\n                        }\n                    }.bind(this)\n                });\n            } else {\n                this.openChooser(this.variables);\n            }\n        },\n\n        /**\n         * @param {*} variables\n         */\n        openChooser: function (variables) {\n            Variables.openVariableChooser(variables);\n        },\n\n        /**\n         * @param {*} value\n         */\n        insertVariable: function (value) {\n            if (this.textareaId) {\n                Variables.init(this.textareaId);\n                Variables.insertVariable(value);\n            } else {\n                Variables.closeDialogWindow();\n                this.editor.execCommand('mceInsertContent', false, value);\n            }\n        }\n    };\n});\n","requirejs/domReady.js":"/**\n * @license RequireJS domReady 2.0.1 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.\n * Available via the MIT or new BSD license.\n * see: http://github.com/requirejs/domReady for details\n */\n/*jslint */\n/*global require: false, define: false, requirejs: false,\n  window: false, clearInterval: false, document: false,\n  self: false, setInterval: false */\n\n\ndefine(function () {\n    'use strict';\n\n    var isTop, testDiv, scrollIntervalId,\n        isBrowser = typeof window !== \"undefined\" && window.document,\n        isPageLoaded = !isBrowser,\n        doc = isBrowser ? document : null,\n        readyCalls = [];\n\n    function runCallbacks(callbacks) {\n        var i;\n        for (i = 0; i < callbacks.length; i += 1) {\n            callbacks[i](doc);\n        }\n    }\n\n    function callReady() {\n        var callbacks = readyCalls;\n\n        if (isPageLoaded) {\n            //Call the DOM ready callbacks\n            if (callbacks.length) {\n                readyCalls = [];\n                runCallbacks(callbacks);\n            }\n        }\n    }\n\n    /**\n     * Sets the page as loaded.\n     */\n    function pageLoaded() {\n        if (!isPageLoaded) {\n            isPageLoaded = true;\n            if (scrollIntervalId) {\n                clearInterval(scrollIntervalId);\n            }\n\n            callReady();\n        }\n    }\n\n    if (isBrowser) {\n        if (document.addEventListener) {\n            //Standards. Hooray! Assumption here that if standards based,\n            //it knows about DOMContentLoaded.\n            document.addEventListener(\"DOMContentLoaded\", pageLoaded, false);\n            window.addEventListener(\"load\", pageLoaded, false);\n        } else if (window.attachEvent) {\n            window.attachEvent(\"onload\", pageLoaded);\n\n            testDiv = document.createElement('div');\n            try {\n                isTop = window.frameElement === null;\n            } catch (e) {}\n\n            //DOMContentLoaded approximation that uses a doScroll, as found by\n            //Diego Perini: http://javascript.nwbox.com/IEContentLoaded/,\n            //but modified by other contributors, including jdalton\n            if (testDiv.doScroll && isTop && window.external) {\n                scrollIntervalId = setInterval(function () {\n                    try {\n                        testDiv.doScroll();\n                        pageLoaded();\n                    } catch (e) {}\n                }, 30);\n            }\n        }\n\n        //Check if document is no longer loading, and if so, just trigger page load\n        //listeners. Latest webkit browsers also use \"interactive\", and\n        //will fire the onDOMContentLoaded before \"interactive\" but not after\n        //entering \"interactive\" or \"complete\". More details:\n        //http://dev.w3.org/html5/spec/the-end.html#the-end\n        //http://stackoverflow.com/questions/3665561/document-readystate-of-interactive-vs-ondomcontentloaded\n        //Hmm, this is more complicated on further use, see \"firing too early\"\n        //bug: https://github.com/requirejs/domReady/issues/1\n        //so removing the || document.readyState === \"interactive\" test.\n        //There is still a window.onload binding that should get fired if\n        //DOMContentLoaded is missed.\n        if (document.readyState !== \"loading\") {\n            // Handle it asynchronously to allow scripts the opportunity to delay ready\n            setTimeout(pageLoaded);\n        }\n    }\n\n    /** START OF PUBLIC API **/\n\n    /**\n     * Registers a callback for DOM ready. If DOM is already ready, the\n     * callback is called immediately.\n     * @param {Function} callback\n     */\n    function domReady(callback) {\n        if (isPageLoaded) {\n            callback(doc);\n        } else {\n            readyCalls.push(callback);\n        }\n        return domReady;\n    }\n\n    domReady.version = '2.0.1';\n\n    /**\n     * Loader Plugin API method\n     */\n    domReady.load = function (name, req, onLoad, config) {\n        if (config.isBuild) {\n            onLoad(null);\n        } else {\n            domReady(onLoad);\n        }\n    };\n\n    /** END OF PUBLIC API **/\n\n    return domReady;\n});\n","Magento_MediaGalleryUi/js/image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/lib/validation/validator',\n    'mage/translate',\n    'jquery/file-uploader'\n], function (Component, $, _, validator, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            imageUploadInputSelector: '#image-uploader-form',\n            directoriesPath: 'media_gallery_listing.media_gallery_listing.media_gallery_directories',\n            actionsPath: 'media_gallery_listing.media_gallery_listing.media_gallery_columns.thumbnail_url',\n            messagesPath: 'media_gallery_listing.media_gallery_listing.messages',\n            imageUploadUrl: '',\n            acceptFileTypes: '',\n            allowedExtensions: '',\n            maxFileSize: '',\n            maxFileNameLength: 90,\n            loader: false,\n            modules: {\n                directories: '${ $.directoriesPath }',\n                actions: '${ $.actionsPath }',\n                mediaGridMessages: '${ $.messagesPath }',\n                sortBy: '${ $.sortByName }',\n                listingPaging: '${ $.listingPagingName }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            this._super().observe(\n                [\n                    'loader',\n                    'count'\n                ]\n            );\n\n            return this;\n        },\n\n        /**\n         * Initializes file upload library\n         */\n        initializeFileUpload: function () {\n            $(this.imageUploadInputSelector).fileupload({\n                url: this.imageUploadUrl,\n                acceptFileTypes: this.acceptFileTypes,\n                allowedExtensions: this.allowedExtensions,\n                maxFileSize: this.maxFileSize,\n\n                /**\n                 * Extending the form data\n                 *\n                 * @param {Object} form\n                 * @returns {Array}\n                 */\n                formData: function (form) {\n                    return form.serializeArray().concat(\n                        [{\n                            name: 'isAjax',\n                            value: true\n                        },\n                        {\n                            name: 'form_key',\n                            value: window.FORM_KEY\n                        },\n                        {\n                            name: 'target_folder',\n                            value: this.getTargetFolder()\n                        }]\n                    );\n                }.bind(this),\n\n                add: function (e, data) {\n                    if (!this.isSizeExceeded(data.files[0]).passed) {\n                        this.addValidationErrorMessage(\n                            $t('Cannot upload \"%1\". File exceeds maximum file size limit.')\n                                .replace('%1', data.files[0].name)\n                        );\n\n                        return;\n                    } else if (!this.isFileNameLengthExceeded(data.files[0]).passed) {\n                        this.addValidationErrorMessage(\n                            $t('Cannot upload \"%1\". Filename is too long, must be 90 characters or less.')\n                                .replace('%1', data.files[0].name)\n                        );\n\n                        return;\n                    }\n\n                    this.showLoader();\n                    this.count(1);\n                    data.submit();\n                }.bind(this),\n\n                stop: function () {\n                    this.openNewestImages();\n                    this.mediaGridMessages().scheduleCleanup();\n                }.bind(this),\n\n                start: function () {\n                    this.mediaGridMessages().clear();\n                }.bind(this),\n\n                done: function (e, data) {\n                    var response = data.jqXHR.responseJSON;\n\n                    if (!response) {\n                        this.showErrorMessage(data, $t('Could not upload the asset.'));\n\n                        return;\n                    }\n\n                    if (!response.success) {\n                        this.showErrorMessage(data, response.message);\n\n                        return;\n                    }\n                    this.showSuccessMessage(data);\n                    this.hideLoader();\n                    this.actions().reloadGrid();\n                }.bind(this)\n            });\n        },\n\n        /**\n         * Add error message after validation error.\n         *\n         * @param {String} message\n         */\n        addValidationErrorMessage: function (message) {\n            this.mediaGridMessages().add('error', message);\n\n            this.count() < 2 || this.mediaGridMessages().scheduleCleanup();\n        },\n\n        /**\n         * Checks if size of provided file exceeds\n         * defined in configuration size limits.\n         *\n         * @param {Object} file - File to be checked.\n         * @returns {Boolean}\n         */\n        isSizeExceeded: function (file) {\n            return validator('validate-max-size', file.size, this.maxFileSize);\n        },\n\n        /**\n         * Checks if name length of provided file exceeds\n         * defined in configuration size limits.\n         *\n         * @param {Object} file - File to be checked.\n         * @returns {Boolean}\n         */\n        isFileNameLengthExceeded: function (file) {\n            return validator('max_text_length', file.name, this.maxFileNameLength);\n        },\n\n        /**\n         * Go to recently uploaded images if at least one uploaded successfully\n         */\n        openNewestImages: function () {\n            this.mediaGridMessages().get().each(function (message) {\n                if (message.code === 'success') {\n                    this.actions().deselectImage();\n                    this.sortBy().selectDefaultOption();\n                    this.listingPaging().goFirst();\n\n                    return false;\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Show error meassages with file name.\n         *\n         * @param {Object} data\n         * @param {String} message\n         */\n        showErrorMessage: function (data, message) {\n            data.files.each(function (file) {\n                this.mediaGridMessages().add(\n                    'error',\n                    file.name + ': ' + $t(message)\n                );\n            }.bind(this));\n\n            this.hideLoader();\n        },\n\n        /**\n         * Show success message, and files counts\n         */\n        showSuccessMessage: function () {\n            this.mediaGridMessages().messages.remove(function (item) {\n                return item.code === 'success';\n            });\n            this.mediaGridMessages().add('success', $t('Assets have been successfully uploaded!'));\n            this.count(this.count() + 1);\n\n        },\n\n        /**\n         * Gets Media Gallery selected folder\n         *\n         * @returns {String}\n         */\n        getTargetFolder: function () {\n\n            if (_.isUndefined(this.directories().activeNode()) ||\n                _.isNull(this.directories().activeNode())) {\n                return '/';\n            }\n\n            return this.directories().activeNode();\n        },\n\n        /**\n         * Shows spinner loader\n         */\n        showLoader: function () {\n            this.loader(true);\n        },\n\n        /**\n         * Hides spinner loader\n         */\n        hideLoader: function () {\n            this.loader(false);\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/container.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'jquery'\n], function (Element, $) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            containerSelector: '.media-gallery-container',\n            masonryComponentPath: 'media_gallery_listing.media_gallery_listing.media_gallery_columns',\n            modules: {\n                masonry: '${ $.masonryComponentPath }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            this._super();\n\n            $(this.containerSelector).applyBindings();\n\n            return this;\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/validation/validate-image-title.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/validate',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.validator.addMethod(\n        'validate-image-title', function (value) {\n            return /^[a-zA-Z0-9\\-\\_\\.\\,\\s]+$/i.test(value);\n\n        }, $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), dots (.), commas(,), ' +\n            'underscores (_), dashes(-) and spaces on this field.'));\n});\n","Magento_MediaGalleryUi/js/validation/validate-image-keyword.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/validate',\n    'mage/translate'\n], function ($, validate, $t) {\n    'use strict';\n\n    $.validator.addMethod(\n        'validate-image-keyword', function (value) {\n            return /^[a-zA-Z0-9\\-\\_\\.\\,]+$|^$/i.test(value);\n\n        }, $t('Please use only letters (a-z or A-Z), numbers (0-9), dots (.), commas(,), ' +\n            'underscores (_) and dashes(-) on this field.'));\n});\n","Magento_MediaGalleryUi/js/validation/validate-image-description.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/validate',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.validator.addMethod(\n        'validate-image-description', function (value) {\n            return /^[a-zA-Z0-9\\-\\_\\.\\,\\n\\s]+$|^$/i.test(value);\n\n        }, $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), ' +\n            'dots (.), commas(,), underscores (_), dashes (-), and spaces on this field.'));\n});\n","Magento_MediaGalleryUi/js/directory/directories.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.g\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'underscore',\n    'Magento_Ui/js/modal/prompt',\n    'Magento_MediaGalleryUi/js/directory/actions/createDirectory',\n    'Magento_MediaGalleryUi/js/directory/actions/deleteDirectory',\n    'mage/translate',\n    'validation'\n], function ($, Component, confirm, uiAlert, _, prompt, createDirectory, deleteDirectory, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            allowedActions: [],\n            directoryTreeSelector: '#media-gallery-directory-tree',\n            deleteButtonSelector: '#delete_folder',\n            createFolderButtonSelector: '#create_folder',\n            messageDelay: 5,\n            selectedFolder: null,\n            messagesName: 'media_gallery_listing.media_gallery_listing.messages',\n            modules: {\n                directoryTree: '${ $.parentName }.media_gallery_directories',\n                messages: '${ $.messagesName }'\n            }\n        },\n\n        /**\n         * Initializes media gallery directories component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super().observe(['selectedFolder']);\n            this._addValidation();\n            this.initEvents();\n\n            return this;\n        },\n\n        /**\n          * Initialize directories events\n          */\n        initEvents: function () {\n            $(this.deleteButtonSelector).on('delete_folder', function () {\n                this.deleteFolder();\n            }.bind(this));\n\n            $(this.createFolderButtonSelector).on('create_folder', function () {\n                this.createFolder();\n            }.bind(this));\n        },\n\n        /**\n         * Show confirmation popup and create folder based on user input\n         */\n        createFolder: function () {\n            this.getPrompt({\n                title: $t('New Folder Name:'),\n                content: '',\n                actions: {\n                    /**\n                     * Confirm action\n                     */\n                    confirm: function (folderName) {\n                        createDirectory(\n                            this.directoryTree().createDirectoryUrl,\n                            [this.getNewFolderPath(folderName)]\n                        ).then(function () {\n                            this.directoryTree().reloadJsTree().then(function () {\n                                this.directoryTree().locateNode(this.getNewFolderPath(folderName));\n                            }.bind(this));\n                        }.bind(this)).fail(function (error) {\n                            uiAlert({\n                                content: error\n                            });\n                        });\n                    }.bind(this)\n                },\n                buttons: [{\n                    text: $t('Cancel'),\n                    class: 'action-secondary action-dismiss',\n\n                    /**\n                     * Close modal\n                     */\n                    click: function () {\n                        this.closeModal();\n                    }\n                }, {\n                    text: $t('Confirm'),\n                    class: 'action-primary action-accept'\n                }]\n            });\n        },\n\n        /**\n         * Return configured path for folder creation.\n         *\n         * @param {String} folderName\n         * @returns {String}\n         */\n        getNewFolderPath: function (folderName) {\n            if (_.isUndefined(this.selectedFolder()) || _.isNull(this.selectedFolder())) {\n                return folderName;\n            }\n\n            return this.selectedFolder() + '/' + folderName;\n        },\n\n        /**\n          * Return configured prompt with input field\n          */\n        getPrompt: function (data) {\n                prompt({\n                    title: $t(data.title),\n                    content:  $t(data.content),\n                    modalClass: 'media-gallery-folder-prompt',\n                    validation: true,\n                    validationRules: ['required-entry', 'validate-filename'],\n                    attributesField: {\n                        name: 'folder_name',\n                        'data-validate': '{required:true, validate-filename}',\n                        maxlength: '128'\n                    },\n                    attributesForm: {\n                        novalidate: 'novalidate',\n                        action: ''\n                    },\n                    context: this,\n                    actions: data.actions,\n                    buttons: data.buttons\n                });\n            },\n\n        /**\n          * Confirmation popup for delete folder action.\n          */\n        deleteFolder: function () {\n            confirm({\n                title: $t('Are you sure you want to delete this folder?'),\n                modalClass: 'delete-folder-confirmation-popup',\n                content: $t('The following folder is going to be deleted: %1')\n                    .replace('%1', this.selectedFolder()),\n                actions: {\n\n                    /**\n                      * Delete folder on button click\n                      */\n                    confirm: function () {\n                        deleteDirectory(\n                            this.directoryTree().deleteDirectoryUrl,\n                            this.selectedFolder()\n                        ).then(function () {\n                            this.directoryTree().removeNode();\n                            this.directoryTree().selectStorageRoot();\n                            $(window).trigger('folderDeleted.enhancedMediaGallery');\n                        }.bind(this)).fail(function (error) {\n                            uiAlert({\n                                content: error\n                            });\n                        });\n                    }.bind(this)\n                }\n            });\n        },\n\n        /**\n         * Set inactive all nodes, adds disable state to Delete Folder Button\n         */\n        setInActive: function () {\n            this.selectedFolder(null);\n            $(this.deleteButtonSelector).attr('disabled', true).addClass('disabled');\n        },\n\n        /**\n         * Set active node, remove disable state from Delete Forlder button\n         *\n         * @param {String} folderId\n         */\n        setActive: function (folderId) {\n            if (!this.allowedActions.includes('delete_folder')) {\n                return;\n            }\n\n            this.selectedFolder(folderId);\n            $(this.deleteButtonSelector).prop('disabled', false).removeClass('disabled');\n        },\n\n        /**\n         * @private\n         */\n        _addValidation: function () {\n            $.validator.addMethod(\n                'validate-filename', function (value) {\n                    return $.mage.isEmptyNoTrim(value) || /^[a-z0-9\\-\\_]+$/si.test(value);\n                },\n                $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), underscore (_) or hyphen (-) in this field. No spaces or other characters are allowed.')); //eslint-disable-line max-len\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/directory/directoryTree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Base64 */\ndefine([\n    'jquery',\n    'uiComponent',\n    'uiLayout',\n    'underscore',\n    'Magento_MediaGalleryUi/js/directory/actions/createDirectory',\n    'jquery/jstree/jquery.jstree',\n    'Magento_Ui/js/lib/view/utils/async',\n    'Magento_MediaGalleryUi/js/directory/directories'\n], function ($, Component, layout, _, createDirectory) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            allowedActions: [],\n            filterChipsProvider: 'componentType = filters, ns = ${ $.ns }',\n            bookmarkProvider: 'componentType = bookmark, ns = ${ $.ns }',\n            directoryTreeSelector: '#media-gallery-directory-tree',\n            getDirectoryTreeUrl: 'media_gallery/directories/gettree',\n            createDirectoryUrl: 'media_gallery/directories/create',\n            deleteDirectoryUrl: 'media_gallery/directories/delete',\n            jsTreeReloaded: null,\n            modules: {\n                bookmarks: '${ $.bookmarkProvider }',\n                directories: '${ $.name }_directories',\n                filterChips: '${ $.filterChipsProvider }'\n            },\n            listens: {\n                '${ $.provider }:params.filters.path': 'updateSelectedDirectory'\n            },\n            viewConfig: [{\n                component: 'Magento_MediaGalleryUi/js/directory/directories',\n                name: '${ $.name }_directories',\n                allowedActions: '${ $.allowedActions }'\n            }]\n        },\n\n        /**\n         * Initializes media gallery directories component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super().observe(['activeNode']).initView();\n\n            $.async(\n                this.directoryTreeSelector,\n                this,\n                function () {\n                    this.initJsTreeEvents();\n                    this.renderDirectoryTree().then(function () {\n                        this.initEvents();\n                    }.bind(this));\n                }.bind(this)\n            );\n\n            return this;\n        },\n\n        /**\n         * Render directory tree component.\n         */\n        renderDirectoryTree: function () {\n            return this.getJsonTree().then(function (data) {\n                this.createFolderIfNotExists(data).then(function (isFolderCreated) {\n                    if (isFolderCreated) {\n                        this.getJsonTree().then(function (newData) {\n                            this.createTree(newData);\n                        }.bind(this));\n                    } else {\n                        this.createTree(data);\n                    }\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Set jstree reloaded\n         *\n         * @param {Boolean} value\n         */\n        setJsTreeReloaded: function (value) {\n            this.jsTreeReloaded = value;\n        },\n\n        /**\n         * Create folder by provided current_tree_path param\n         *\n         * @param {Array} directories\n         */\n        createFolderIfNotExists: function (directories) {\n            var requestedDirectory = this.getRequestedDirectory(),\n                deferred = $.Deferred(),\n                pathArray;\n\n            if (_.isNull(requestedDirectory)) {\n                deferred.resolve(false);\n\n                return deferred.promise();\n            }\n\n            if (this.isDirectoryExist(directories, requestedDirectory)) {\n                deferred.resolve(false);\n\n                return deferred.promise();\n            }\n\n            pathArray = this.convertPathToPathsArray(requestedDirectory);\n\n            $.each(pathArray, function (i, val) {\n                if (this.isDirectoryExist(directories, val)) {\n                    pathArray.splice(i, 1);\n                }\n            }.bind(this));\n\n            createDirectory(\n                this.createDirectoryUrl,\n                pathArray\n            ).then(function () {\n                deferred.resolve(true);\n            });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Verify if directory exists in array\n         *\n         * @param {Array} directories\n         * @param {String} directoryId\n         */\n        isDirectoryExist: function (directories, directoryId) {\n            var found = false;\n\n            /**\n             * Recursive search in array\n             *\n             * @param {Array} data\n             * @param {String} id\n             */\n            function recurse(data, id) {\n                var i;\n\n                for (i = 0; i < data.length; i++) {\n                    if (data[i].id === id) {\n                        found = data[i];\n                        break;\n                    } else if (data[i].children && data[i].children.length) {\n                        recurse(data[i].children, id);\n                    }\n                }\n            }\n\n            recurse(directories, directoryId);\n\n            return found;\n        },\n\n        /**\n         * Convert path string to path array e.g 'path1/path2' -> ['path1', 'path1/path2']\n         *\n         * @param {String} path\n         */\n        convertPathToPathsArray: function (path) {\n            var pathsArray = [],\n                pathString = '',\n                paths = path.split('/');\n\n            $.each(paths, function (i, val) {\n                pathString += i >= 1 ? val : val + '/';\n                pathsArray.push(i >= 1 ? pathString : val);\n            });\n\n            return pathsArray;\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Wait for condition then call provided callback\n         */\n        waitForCondition: function (condition, callback) {\n            if (condition()) {\n                setTimeout(function () {\n                    this.waitForCondition(condition, callback);\n                }.bind(this), 100);\n            } else {\n                callback();\n            }\n        },\n\n        /**\n         * Remove ability to multiple select on nodes\n         */\n        disableMultiselectBehavior: function () {\n            $.jstree.defaults.core.multiple = false;\n        },\n\n        /**\n         *  Handle jstree events\n         */\n        initEvents: function () {\n            this.disableMultiselectBehavior();\n\n            $(window).on('reload.MediaGallery', function () {\n                this.getJsonTree().then(function (data) {\n                    this.createFolderIfNotExists(data).then(function (isCreated) {\n                        if (isCreated) {\n                            this.renderDirectoryTree().then(function () {\n                                this.setJsTreeReloaded(true);\n                                this.initJsTreeEvents();\n                            }.bind(this));\n                        } else {\n                            this.updateSelectedDirectory();\n                        }\n                    }.bind(this));\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Fire event for jstree component\n         */\n        initJsTreeEvents: function () {\n            $(this.directoryTreeSelector).on('select_node.jstree', function (element, data) {\n                this.setActiveNodeFilter(data.node.id);\n                this.setJsTreeReloaded(false);\n            }.bind(this));\n\n            $(this.directoryTreeSelector).on('loaded.jstree', function () {\n                this.updateSelectedDirectory();\n            }.bind(this));\n        },\n\n        /**\n         * Verify directory filter on init event, select folder per directory filter state\n         */\n        updateSelectedDirectory: function () {\n            var currentFilterPath = this.filterChips().filters.path,\n                requestedDirectory = this.getRequestedDirectory(),\n                currentTreePath;\n\n            if (_.isUndefined(currentFilterPath)) {\n                this.clearFiltersHandle();\n\n                return;\n            }\n\n            if (!_.isUndefined(this.bookmarks())) {\n                if (!_.size(this.bookmarks().getViewData(this.bookmarks().defaultIndex))) {\n                    setTimeout(function () {\n                        this.updateSelectedDirectory();\n                    }.bind(this), 500);\n\n                    return;\n                }\n            }\n            currentTreePath = this.isFilterApplied(currentFilterPath) || _.isNull(requestedDirectory) ?\n                currentFilterPath : requestedDirectory;\n\n            if (this.folderExistsInTree(currentTreePath)) {\n                this.locateNode(currentTreePath);\n            } else {\n                this.selectStorageRoot();\n            }\n        },\n\n        /**\n         * Verify if directory exists in folder tree\n         *\n         * @param {String} path\n         */\n        folderExistsInTree: function (path) {\n            if (!_.isUndefined(path)) {\n                return $(this.directoryTreeSelector).jstree('get_node', path);\n            }\n\n            return false;\n        },\n\n        /**\n         * Get requested directory from MediabrowserUtility\n         *\n         * @returns {String|null}\n         */\n        getRequestedDirectory: function () {\n            return !_.isUndefined(window.MediabrowserUtility) && window.MediabrowserUtility.pathId !== '' ?\n                Base64.idDecode(window.MediabrowserUtility.pathId) : null;\n        },\n\n        /**\n         * Check if need to select directory by filters state\n         *\n         * @param {String} currentFilterPath\n         */\n        isFilterApplied: function (currentFilterPath) {\n            return !_.isUndefined(currentFilterPath) && currentFilterPath !== '';\n        },\n\n        /**\n         * Locate and higlight node in jstree by path id.\n         *\n         * @param {String} path\n         */\n        locateNode: function (path) {\n            if ($(this.directoryTreeSelector).jstree('is_selected', path)) {\n                return;\n            }\n            $(this.directoryTreeSelector).jstree('deselect_node',\n                $(this.directoryTreeSelector).jstree('get_selected')\n            );\n            $(this.directoryTreeSelector).jstree('open_node', path);\n            $(this.directoryTreeSelector).jstree('select_node', path, true);\n\n        },\n\n        /**\n         * Clear filters\n         */\n        clearFiltersHandle: function () {\n            $(this.directoryTreeSelector).jstree('deselect_all');\n            this.activeNode(null);\n            this.directories().setInActive();\n        },\n\n        /**\n         * Set active node filter, or deselect if the same node clicked\n         *\n         * @param {String} nodePath\n         */\n        setActiveNodeFilter: function (nodePath) {\n            if (this.activeNode() === nodePath && !this.jsTreeReloaded) {\n                this.selectStorageRoot();\n            } else {\n                this.selectFolder(nodePath);\n            }\n        },\n\n        /**\n         * Remove folders selection -> select storage root\n         */\n        selectStorageRoot: function () {\n            var filters = {},\n                applied = this.filterChips().get('applied');\n\n            $(this.directoryTreeSelector).jstree('deselect_all');\n\n            filters = $.extend(true, filters, applied);\n            delete filters.path;\n            this.filterChips().set('applied', filters);\n            this.activeNode(null);\n            this.waitForCondition(\n                function () {\n                    return _.isUndefined(this.directories());\n                }.bind(this),\n                function () {\n                    this.directories().setInActive();\n                }.bind(this)\n            );\n        },\n\n        /**\n         * Set selected folder\n         *\n         * @param {String} path\n         */\n        selectFolder: function (path) {\n            this.activeNode(path);\n\n            this.waitForCondition(\n                function () {\n                    return _.isUndefined(this.directories());\n                }.bind(this),\n                function () {\n                    this.directories().setActive(path);\n                }.bind(this)\n            );\n\n            this.applyFilter(path);\n        },\n\n        /**\n         * Remove active node from directory tree, and select next\n         */\n        removeNode: function () {\n            $(this.directoryTreeSelector).jstree('delete_node',\n                $(this.directoryTreeSelector).jstree('get_selected')\n            );\n        },\n\n        /**\n         * Apply folder filter by path\n         *\n         * @param {String} path\n         */\n        applyFilter: function (path) {\n            var filters = {},\n                applied = this.filterChips().get('applied');\n\n            filters = $.extend(true, filters, applied);\n            filters.path = path;\n            this.filterChips().set('applied', filters);\n        },\n\n        /**\n         * Reload jstree and update jstree events\n         */\n        reloadJsTree: function () {\n            var deferred = $.Deferred();\n\n            this.getJsonTree().then(function (data) {\n                $(this.directoryTreeSelector).jstree(true).settings.core.data = data;\n                $(this.directoryTreeSelector).jstree(true).refresh(false, true);\n                this.setJsTreeReloaded(true);\n                deferred.resolve();\n            }.bind(this));\n\n            return deferred.promise();\n        },\n\n        /**\n         * Get json data for jstree\n         */\n        getJsonTree: function () {\n            var deferred = $.Deferred();\n\n            $.ajax({\n                url: this.getDirectoryTreeUrl,\n                type: 'GET',\n                dataType: 'json',\n\n                /**\n                 * Success handler for request\n                 *\n                 * @param {Object} data\n                 */\n                success: function (data) {\n                    deferred.resolve(data);\n                },\n\n                /**\n                 * Error handler for request\n                 *\n                 * @param {Object} jqXHR\n                 * @param {String} textStatus\n                 */\n                error: function (jqXHR, textStatus) {\n                    deferred.reject();\n                    throw textStatus;\n                }\n            });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Initialize directory tree\n         *\n         * @param {Array} data\n         */\n        createTree: function (data) {\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            $(this.directoryTreeSelector).jstree({\n                plugins: [],\n                checkbox: {\n                    three_state: false,\n                    cascade: ''\n                },\n                core: {\n                    data: data,\n                    check_callback: true,\n                    themes: {\n                        dots: false\n                    }\n                }\n            });\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/directory/actions/deleteDirectory.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return function (deleteFolderUrl, path) {\n        var deferred = $.Deferred(),\n            message;\n\n        $.ajax({\n            type: 'POST',\n            url: deleteFolderUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: {\n                path: path\n            },\n            context: this,\n\n            /**\n             * Resolve  if delete folder success, reject with response message othervise\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                if (response.success) {\n                    deferred.resolve(response.message);\n\n                    return;\n                }\n\n                deferred.reject(response.message);\n            },\n\n            /**\n             * Extract the message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = $t('Could not delete the directory.');\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/directory/actions/createDirectory.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return function (createFolderUrl, paths) {\n        var deferred = $.Deferred(),\n            message,\n            data = {\n                paths: paths\n            };\n\n        $.ajax({\n            type: 'POST',\n            url: createFolderUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: data,\n            context: this,\n\n            /**\n             * Resolve  if success, reject with response message othervise\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                if (response.success) {\n                    deferred.resolve(response.message);\n\n                    return;\n                }\n\n                deferred.reject(response.message);\n            },\n\n            /**\n             * Extract the message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = $t('Could not create the directory.');\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/grid/masonry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/masonry',\n    'jquery'\n], function (Masonry, $) {\n    'use strict';\n\n    return Masonry.extend({\n        defaults: {\n            modules: {\n                provider: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.initEvents();\n\n            return this;\n        },\n\n        /**\n         * Initialize events\n         */\n        initEvents: function () {\n            $(window).on('folderDeleted.enhancedMediaGallery', this.reloadGrid.bind(this));\n        },\n\n        /**\n         * Reload grid\n         */\n        reloadGrid: function () {\n            var provider = this.provider(),\n                dataStorage = provider.storage();\n\n            dataStorage.clearRequests();\n            provider.reload();\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/sortBy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/sortBy'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            columnIndexMap: {}\n        },\n\n        /**\n         * Prepared sort order options\n         */\n        preparedOptions: function (columns) {\n            var index = 0,\n                sortBy;\n\n            if (columns && columns.length > 0) {\n                columns.map(function (column) {\n                    if (column.sortable === true) {\n                        sortBy = column['sort_by'] || {};\n\n                        if (sortBy.excluded) {\n                            return;\n                        }\n\n                        this.options.push({\n                            value: column.index,\n                            label: column.label,\n                            sortByField: sortBy.field,\n                            sortDirection: sortBy.direction\n                        });\n\n                        this.columnIndexMap[column.index] = index++;\n\n                        this.isVisible(true);\n                    } else {\n                        this.isVisible(false);\n                    }\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Apply changes\n         */\n        applyChanges: function () {\n            var column = this.getColumn(this.selectedOption());\n\n            this.applied({\n                field: column.sortByField || this.selectedOption(),\n                direction: column.sortDirection || this.sorting\n            });\n        },\n\n        /**\n         * Get column by index\n         *\n         * @param {String} optionIndex\n         * @returns {Object}\n         */\n        getColumn: function (optionIndex) {\n            return this.options[this.columnIndexMap[optionIndex]];\n        },\n\n        /**\n         * Select default option\n         */\n        selectDefaultOption: function () {\n            this.selectedOption(this.options[0].value);\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'escaper'\n], function (Element, escaper) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'Magento_MediaGalleryUi/grid/messages',\n            messageDelay: 5,\n            messages: [],\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'messages'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Get messages\n         *\n         * @returns {Array}\n         */\n        get: function () {\n            return this.messages();\n        },\n\n        /**\n         * Add message\n         *\n         * @param {String} type\n         * @param {String} message\n         */\n        add: function (type, message) {\n            this.messages.push({\n                code: type,\n                message: message\n            });\n        },\n\n        /**\n         * Clear messages\n         */\n        clear: function () {\n            this.messages.removeAll();\n        },\n\n        /**\n         * Schedule message cleanup\n         *\n         * @param {Number} delay\n         */\n        scheduleCleanup: function (delay) {\n            // eslint-disable-next-line no-unused-vars\n            var timerId;\n\n            delay = delay || this.messageDelay;\n\n            // eslint-disable-next-line no-unused-vars\n            timerId = setTimeout(function () {\n                clearTimeout(timerId);\n                this.clear();\n            }.bind(this), Number(delay) * 1000);\n        },\n\n        /**\n         * Prepare the given message to be rendered as HTML\n         *\n         * @param {String} message\n         * @return {String}\n         */\n        prepareMessageUnsanitizedHtml: function (message) {\n            return escaper.escapeHtml(message, this.allowedTags);\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/columns/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/grid/columns/column',\n    'uiLayout',\n    'underscore'\n], function ($, Column, layout, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_MediaGalleryUi/grid/columns/image',\n            messageContentSelector: 'ul.messages',\n            mediaGalleryContainerSelector: '.media-gallery-container',\n            deleteImageUrl: 'media_gallery/image/delete',\n            addSelectedBtnSelector: '#add_selected',\n            deleteSelectedBtnSelector: '#delete_selected',\n            gridSelector: '[data-id=\"media-gallery-masonry-grid\"]',\n            selected: null,\n            allowedActions: [],\n            fields: {\n                id: 'id',\n                url: 'url',\n                alt: 'name'\n            },\n            modules: {\n                actions: '${ $.name }_actions',\n                provider: '${ $.provider }',\n                messages: '${ $.messagesName }',\n                massaction: '${ $.massactionComponentName }'\n            },\n            imports: {\n                activeDirectory: '${ $.mediaGalleryDirectoryComponent }:activeNode'\n            },\n            listens: {\n                activeDirectory: 'selectDirectoryHandle',\n                '${ $.massactionComponentName }:massActionMode': 'updateSelected'\n            },\n            viewConfig: [\n                {\n                    component: 'Magento_MediaGalleryUi/js/grid/columns/image/actions',\n                    name: '${ $.name }_actions',\n                    imageModelName: '${ $.name }',\n                    allowedActions: '${ $.allowedActions }'\n                }\n            ]\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.initView();\n            $(window).on('fileDeleted.enhancedMediaGallery', this.reloadMediaGrid.bind(this));\n            $(window).on('reload.MediaGallery', this.reloadGrid.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'selected'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Is massaction mode active.\n         */\n        isMassActionMode: function () {\n            return this.massaction().massActionMode();\n        },\n\n        /**\n         * Returns url to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getUrl: function (record) {\n            return record[this.fields.url];\n        },\n\n        /**\n         * Returns id to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Number}\n         */\n        getId: function (record) {\n            return record[this.fields.id];\n        },\n\n        /**\n         * Update selected items per massaction mode.\n         */\n        updateSelected: function () {\n            this.selected({});\n            this.hideAddSelectedAndDeleteButon();\n        },\n\n        /**\n         * Returns name to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getImageAlt: function (record) {\n            return record[this.fields.alt];\n        },\n\n        /**\n         * Check if the record is currently selected\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Boolean}\n         */\n        isSelected: function (record) {\n            if (_.isNull(this.selected())) {\n                return false;\n            }\n\n            if (this.massaction().massActionMode()) {\n                return this.selected()[record.id];\n            }\n\n            return this.getId(this.selected()) === this.getId(record);\n        },\n\n        /**\n         * Click on image\n         *\n         * @param {Object} record\n         * @param {Boolean} collapsibleOpened\n         */\n        clickOnImage: function (record, collapsibleOpened) {\n            if (!collapsibleOpened) {\n                this.select(record);\n            }\n        },\n\n        /**\n         * Click on three-dots\n         *\n         * @param {Object} record\n         * @param {Boolean} collapsibleOpened\n         */\n        clickOnThreeDots: function (record, collapsibleOpened) {\n            if (!this.isSelected(record) || collapsibleOpened) {\n                this.select(record);\n            }\n        },\n\n        /**\n         * Handle checkbox click.\n         */\n        checkboxClick: function (record) {\n            var items = this.selected();\n\n            if (this.selected()[record.id])  {\n                delete items[record.id];\n                this.selected(items);\n            } else {\n                items[record.id] = record.id;\n                this.selected(items);\n            }\n\n            return true;\n        },\n\n        /**\n         * Set the record as selected\n         */\n        select: function (record) {\n            if (this.massaction().massActionMode()) {\n                return this.checkboxClick(record);\n            }\n\n            this.isSelected(record) ? this.selected(null) : this.selected(record);\n            this.toggleAddSelectedButton();\n\n            return true;\n        },\n\n        /**\n         * Deselect the record\n         */\n        deselectImage: function () {\n            this.selected(null);\n            this.toggleAddSelectedButton();\n        },\n\n        /**\n         * Get the selected record\n         * @returns {Object}\n         */\n        getSelected: function () {\n            return this.selected();\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Toggle add selected button\n         */\n        toggleAddSelectedButton: function () {\n            if (this.selected() === null) {\n                this.hideAddSelectedAndDeleteButon();\n\n                return;\n            }\n\n            if (this.allowedActions.includes('insert')) {\n                $(this.addSelectedBtnSelector).removeClass('no-display');\n            }\n\n            if (this.allowedActions.includes('delete')) {\n                $(this.deleteSelectedBtnSelector).removeClass('no-display');\n            }\n        },\n\n        /**\n         * Hide add selected and Delete button\n         */\n        hideAddSelectedAndDeleteButon: function () {\n            $(this.addSelectedBtnSelector).addClass('no-display');\n            $(this.deleteSelectedBtnSelector).addClass('no-display');\n        },\n\n        /**\n         * @param {jQuery.event} e\n         * @param {Object} data\n         */\n        reloadMediaGrid: function (e, data) {\n            if (data.reload) {\n                this.reloadGrid();\n            }\n\n            if (data.message && data.code) {\n                this.addMessage(data.code, data.message);\n            }\n            this.hideAddSelectedAndDeleteButon();\n        },\n\n        /**\n         * Reload grid\n         */\n        reloadGrid: function () {\n            var provider = this.provider(),\n                dataStorage = provider.storage();\n\n            dataStorage.clearRequests();\n            provider.reload();\n        },\n\n        /**\n         * Add message\n         *\n         * @param {String} code\n         * @param {String} message\n         */\n        addMessage: function (code, message) {\n            this.messages().add(code, message);\n            this.closeContextMenu();\n            this.scrollToMessageContent();\n            this.messages().scheduleCleanup();\n        },\n\n        /**\n         * Listener to select directory event\n         *\n         * @param {String} path\n         */\n        selectDirectoryHandle: function (path) {\n            if (this.selected() &&\n                this.selected().directory !== path  &&\n                !this.massaction().massActionMode()) {\n                this.deselectImage();\n            }\n        },\n\n        /**\n         * Action to close the context menu in media gallery.\n         */\n        closeContextMenu: function () {\n            $(this.gridSelector).trigger('click');\n        },\n\n        /**\n         * Scroll to the top of media gallery page\n         */\n        scrollToMessageContent: function () {\n            var scrollTargetElement = $(this.messageContentSelector),\n                scrollTargetContainer = $(this.mediaGalleryContainerSelector);\n\n            scrollTargetContainer.find(scrollTargetElement).get(0).scrollIntoView({\n                behavior: 'smooth',\n                block: 'center',\n                inline: 'nearest'\n            });\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/columns/image/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_MediaGalleryUi/js/action/deleteImageWithDetailConfirmation',\n    'Magento_MediaGalleryUi/js/grid/columns/image/insertImageAction',\n    'mage/translate',\n    'Magento_Ui/js/lib/view/utils/async'\n], function ($, _, Component, deleteImageWithDetailConfirmation, image, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_MediaGalleryUi/grid/columns/image/actions',\n            mediaGalleryImageDetailsName: 'mediaGalleryImageDetails',\n            mediaGalleryEditDetailsName: 'mediaGalleryEditDetails',\n            allowedActions: [],\n            actionsList: [\n                {\n                    name: 'image-details',\n                    title: $t('View Details'),\n                    classes: 'action-menu-item',\n                    handler: 'viewImageDetails'\n                },\n                {\n                    name: 'edit',\n                    title: $t('Edit'),\n                    classes: 'action-menu-item',\n                    handler: 'editImageDetails'\n                },\n                {\n                    name: 'delete',\n                    title: $t('Delete'),\n                    classes: 'action-menu-item media-gallery-delete-assets',\n                    handler: 'deleteImageAction'\n                }\n            ],\n            modules: {\n                imageModel: '${ $.imageModelName }',\n                mediaGalleryImageDetails: '${ $.mediaGalleryImageDetailsName }',\n                mediaGalleryEditDetails: '${ $.mediaGalleryEditDetailsName }'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.initEvents();\n\n            this.actionsList = this.actionsList.filter(function (item) {\n                return this.allowedActions.includes(item.name);\n            }.bind(this));\n\n            if (!this.allowedActions.includes('delete')) {\n                $.async('.media-gallery-delete-assets', function () {\n                    $('.media-gallery-delete-assets').off('click').addClass('action-disabled');\n                });\n            }\n\n            return this;\n        },\n\n        /**\n         * Initialize image action events\n         */\n        initEvents: function () {\n            $(this.imageModel().addSelectedBtnSelector).on('click', function () {\n                image.insertImage(\n                    this.imageModel().getSelected(),\n                    {\n                        onInsertUrl: this.imageModel().onInsertUrl,\n                        storeId: this.imageModel().storeId\n                    }\n                );\n            }.bind(this));\n            $(this.imageModel().deleteSelectedBtnSelector).on('click', function () {\n                this.deleteImageAction(this.imageModel().selected());\n            }.bind(this));\n\n        },\n\n        /**\n         * Delete image action\n         *\n         * @param {Object} record\n         */\n        deleteImageAction: function (record) {\n            var imageDetailsUrl = this.mediaGalleryImageDetails().imageDetailsUrl,\n                deleteImageUrl = this.imageModel().deleteImageUrl;\n\n            deleteImageWithDetailConfirmation.deleteImageAction([record.id], imageDetailsUrl, deleteImageUrl);\n        },\n\n        /**\n         * View image details\n         *\n         * @param {Object} record\n         */\n        viewImageDetails: function (record) {\n            var recordId = this.imageModel().getId(record);\n\n            this.mediaGalleryImageDetails().showImageDetailsById(recordId);\n        },\n\n        /**\n         * Edit image details\n         *\n         * @param {Object} record\n         */\n        editImageDetails: function (record) {\n            var recordId = this.imageModel().getId(record);\n\n            this.mediaGalleryEditDetails().showEditDetailsPanel(recordId);\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/columns/image/insertImageAction.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY, tinyMceEditors */\ndefine([\n    'jquery',\n    'wysiwygAdapter',\n    'underscore',\n    'mage/translate'\n], function ($, wysiwyg, _, $t) {\n    'use strict';\n\n    return {\n\n        /**\n         * Insert provided image in wysiwyg if enabled, or widget\n         *\n         * @param {Object} record\n         * @param {Object} config\n         * @returns {Boolean}\n         */\n        insertImage: function (record, config) {\n            var targetElement, forceStaticPath;\n\n            if (record === null) {\n                return false;\n            }\n            targetElement = this.getTargetElement(window.MediabrowserUtility.targetElementId);\n\n            if (!targetElement.length) {\n                window.MediabrowserUtility.closeDialog();\n                throw $t('Target element not found for content update');\n            }\n\n            forceStaticPath = typeof targetElement !== 'function' && targetElement.data('force_static_path') ? 1 : 0;\n\n            $.ajax({\n                url: config.onInsertUrl,\n                data: {\n                    filename: record['encoded_id'],\n                    'store_id': config.storeId,\n                    'as_is': typeof targetElement !== 'function' && targetElement.is('textarea') ? 1 : 0,\n                    'force_static_path': forceStaticPath,\n                    'form_key': FORM_KEY\n                },\n                context: this,\n                showLoader: true\n            }).done($.proxy(function (data) {\n                if (typeof targetElement === 'function') {\n                    targetElement(data.content, {text: record['title']});\n                } else if (targetElement.is('textarea')) {\n                    this.insertAtCursor(targetElement.get(0), data.content);\n                    targetElement.focus();\n                    $(targetElement).trigger('change');\n                } else {\n                    targetElement.val(data.content)\n                        .data('size', data.size)\n                        .data('mime-type', data.type)\n                        .trigger('change');\n                }\n            }, this));\n            window.MediabrowserUtility.closeDialog();\n\n            if (typeof targetElement !== 'function') {\n                targetElement.focus();\n                $(targetElement).trigger('change');\n            }\n        },\n\n        /**\n         * Insert image to target instance.\n         *\n         * @param {Object} element\n         * @param {*} value\n         */\n        insertAtCursor: function (element, value) {\n            var sel, startPos, endPos, scrollTop;\n\n            if ('selection' in document) {\n                //For browsers like Internet Explorer\n                element.focus();\n                sel = document.selection.createRange();\n                sel.text = value;\n                element.focus();\n            } else if (element.selectionStart || element.selectionStart == '0') { //eslint-disable-line eqeqeq\n                //For browsers like Firefox and Webkit based\n                startPos = element.selectionStart;\n                endPos = element.selectionEnd;\n                scrollTop = element.scrollTop;\n                element.value = element.value.substring(0, startPos) + value +\n                    element.value.substring(startPos, endPos) + element.value.substring(endPos, element.value.length);\n                element.focus();\n                element.selectionStart = startPos + value.length;\n                element.selectionEnd = startPos + value.length + element.value.substring(startPos, endPos).length;\n                element.scrollTop = scrollTop;\n            } else {\n                element.value += value;\n                element.focus();\n            }\n        },\n\n        /**\n         * Return opener Window object if it exists, not closed and editor is active\n         *\n         * @param {String} targetElementId\n         * return {Object|null}\n         */\n        getMediaBrowserOpener: function (targetElementId) {\n            if (!_.isUndefined(wysiwyg) && wysiwyg.get(targetElementId) && !_.isUndefined(tinyMceEditors)) {\n                return tinyMceEditors.get(targetElementId).getMediaBrowserOpener();\n            }\n\n            return null;\n        },\n\n        /**\n         * Get target element\n         *\n         * @param {String} targetElementId\n         * @returns {*|n.fn.init|jQuery|HTMLElement}\n         */\n        getTargetElement: function (targetElementId) {\n\n            if (!_.isUndefined(wysiwyg) && wysiwyg.get(targetElementId)) {\n                return this.getMediaBrowserOpener(targetElementId) || window;\n            }\n\n            return $('#' + targetElementId);\n        }\n    };\n});\n","Magento_MediaGalleryUi/js/grid/massaction/massactionView.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'mage/translate',\n    'text!Magento_MediaGalleryUi/template/grid/massactions/massactionButtons.html'\n], function ($, Component, $t, massactionButtons) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            gridSelector: '[data-id=\"media-gallery-masonry-grid\"]',\n            standAloneTitle: 'Manage Gallery',\n            slidePanelTitle: 'Media Gallery',\n            defaultTitle: null,\n            are: null,\n            standAloneArea: 'standalone',\n            slidepanelArea: 'slidepanel',\n            massactionButtonsSelector: '.massaction-buttons',\n            buttonsSelectorStandalone: '.page-actions-buttons',\n            buttonsSelectorSlidePanel: '.page-actions.floating-header',\n            buttons: '.page-main-actions :button',\n            massactionModeTitle: $t('Select Images to Delete')\n        },\n\n        /**\n         * Initializes media gallery massaction component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super().observe([\n                'massActionMode'\n            ]);\n\n            return this;\n        },\n\n        /**\n         * Switch massaction view state per active mode.\n         */\n        switchView: function () {\n            this.changePageTitle();\n            this.switchButtons();\n        },\n\n        /**\n         * Hide or show buttons per active mode.\n         */\n        switchButtons: function () {\n            if (this.massActionMode()) {\n                this.activateMassactionButtonView();\n            } else {\n                this.revertButtonsToDefaultView();\n            }\n        },\n\n        /**\n         * Sets buttons to default regular -mode view.\n         */\n        revertButtonsToDefaultView: function () {\n            $(this.buttons).removeClass('no-display');\n            $(this.massactionButtonsSelector).remove();\n        },\n\n        /**\n          * Activate mass action buttons view\n          */\n        activateMassactionButtonView: function () {\n            var buttonsContainer;\n\n            $(this.buttons).addClass('no-display');\n\n            buttonsContainer =  this.area === this.standAloneArea ?\n                this.buttonsSelectorStandalone :\n                this.buttonsSelectorSlidePanel;\n\n            $(buttonsContainer).append(massactionButtons);\n            $(this.massactionButtonsSelector).applyBindings();\n        },\n\n        /**\n         * Change page title per active mode.\n         */\n        changePageTitle: function () {\n            var title = $('h1:contains(' + this.standAloneTitle + ')'),\n                titleSelector;\n\n            if (title.length === 1)  {\n                titleSelector = title;\n                this.area = this.standAloneArea;\n            } else {\n                titleSelector = $('h1:contains(' + this.slidePanelTitle + ')');\n                this.area = this.slidepanelArea;\n            }\n\n            if (this.massActionMode()) {\n                this.defaultTitle = titleSelector.text();\n                titleSelector.text(this.massactionModeTitle);\n            } else {\n                titleSelector = $('h1:contains(' + this.massactionModeTitle + ')');\n                titleSelector.text(this.defaultTitle);\n            }\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/massaction/massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_MediaGalleryUi/js/action/deleteImageWithDetailConfirmation',\n    'uiLayout',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate'\n], function ($, Component, DeleteImages, Layout, _, uiAlert, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            allowedActions: [],\n            deleteButtonSelector: '#delete_selected_massaction',\n            deleteImagesSelector: '#delete_massaction',\n            mediaGalleryImageDetailsName: 'mediaGalleryImageDetails',\n            modules: {\n                massactionView: '${ $.name }_view',\n                imageModel: '${ $.imageModelName }',\n                mediaGalleryImageDetails: '${ $.mediaGalleryImageDetailsName }'\n            },\n            viewConfig: [\n                {\n                    component: 'Magento_MediaGalleryUi/js/grid/massaction/massactionView',\n                    name: '${ $.name }_view'\n                }\n            ],\n            imports: {\n                imageItems: '${ $.mediaGalleryProvider }:data.items'\n            },\n            listens: {\n                imageItems: 'checkButtonVisibility'\n            },\n            exports: {\n                massActionMode: '${ $.name }_view:massActionMode'\n            }\n        },\n\n        /**\n         * Initializes media gallery massaction component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super().observe([\n                'massActionMode'\n            ]);\n            this.initView();\n            this.initEvents();\n\n            return this;\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            Layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Initilize massactions events for media gallery grid.\n         */\n        initEvents: function () {\n            $(window).on('massAction.MediaGallery', function () {\n                if (this.massActionMode()) {\n                    return;\n                }\n                this.imageModel().selected(null);\n                this.massActionMode(true);\n                this.switchMode();\n            }.bind(this));\n\n            $(window).on('terminateMassAction.MediaGallery', function () {\n                if (!this.massActionMode()) {\n                    return;\n                }\n\n                this.massActionMode(false);\n                this.switchMode();\n                this.imageModel().updateSelected();\n            }.bind(this));\n        },\n\n        /**\n         * Return total selected items.\n         */\n        getSelectedCount: function () {\n            if (this.massActionMode() && !_.isNull(this.imageModel().selected())) {\n                return Object.keys(this.imageModel().selected()).length;\n            }\n\n            return 0;\n        },\n\n        /**\n         * If images records less than one, disable \"delete images\" button\n         */\n        checkButtonVisibility: function () {\n            if (!this.allowedActions.includes('delete_assets')) {\n                return;\n            }\n\n            if (this.imageItems.length < 1) {\n                $(this.deleteImagesSelector).addClass('disabled');\n            } else {\n                $(this.deleteImagesSelector).removeClass('disabled');\n            }\n        },\n\n        /**\n         * Switch massaction per current event.\n         */\n        switchMode: function () {\n            this.massactionView().switchView();\n            this.handleDeleteAction();\n        },\n\n        /**\n         * Change Default  behavior of delete image to bulk deletion.\n         */\n        handleDeleteAction: function () {\n            if (this.massActionMode()) {\n                $(this.deleteButtonSelector).on('massDelete.MediaGallery', function () {\n                    if (this.getSelectedCount() < 1) {\n                        uiAlert({\n                            content: $t('You need to select at least one image')\n                        });\n\n                    } else {\n                        DeleteImages.deleteImageAction(\n                            this.imageModel().selected(),\n                            this.mediaGalleryImageDetails().imageDetailsUrl,\n                            this.imageModel().deleteImageUrl\n                        ).then(function (response) {\n                            if (response.status === 'canceled') {\n                                return;\n                            }\n                            $(window).trigger('terminateMassAction.MediaGallery');\n                        });\n                    }\n                }.bind(this));\n            }\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/image/image-actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiElement',\n    'Magento_MediaGalleryUi/js/action/deleteImageWithDetailConfirmation',\n    'Magento_MediaGalleryUi/js/grid/columns/image/insertImageAction',\n    'Magento_MediaGalleryUi/js/action/saveDetails',\n    'mage/validation'\n], function ($, _, Element, deleteImageWithDetailConfirmation, addSelected, saveDetails) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            modalSelector: '',\n            modalWindowSelector: '',\n            mediaGalleryImageDetailsName: 'mediaGalleryImageDetails',\n            mediaGalleryEditDetailsName: 'mediaGalleryEditDetails',\n            template: 'Magento_MediaGalleryUi/image/actions',\n            modules: {\n                imageModel: '${ $.imageModelName }',\n                mediaGalleryImageDetails: '${ $.mediaGalleryImageDetailsName }',\n                mediaGalleryEditDetails: '${ $.mediaGalleryEditDetailsName }'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            $(window).on('fileDeleted.enhancedMediaGallery', this.closeViewDetailsModal.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Close the images details modal\n         */\n        closeModal: function () {\n            var modalElement = $(this.modalSelector),\n                modalWindow = $(this.modalWindowSelector);\n\n            if (!modalWindow.hasClass('_show') || !modalElement.length || _.isUndefined(modalElement.modal)) {\n                return;\n            }\n\n            this.mediaGalleryEditDetails().keywordsSelect().cacheOptions.plain = [];\n            modalElement.modal('closeModal');\n        },\n\n        /**\n         * Opens the image edit panel\n         */\n        editImageAction: function () {\n            var record = this.imageModel().getSelected().id;\n\n            this.mediaGalleryEditDetails().showEditDetailsPanel(record);\n        },\n\n        /**\n         * Delete image action\n         */\n        deleteImageAction: function () {\n            var imageDetailsUrl = this.mediaGalleryImageDetails().imageDetailsUrl,\n                deleteImageUrl = this.imageModel().deleteImageUrl;\n\n            deleteImageWithDetailConfirmation.deleteImageAction(\n                [this.imageModel().getSelected().id],\n                imageDetailsUrl,\n                deleteImageUrl\n            );\n        },\n\n        /**\n         * Save image details action\n         */\n        saveImageDetailsAction: function () {\n            var saveDetailsUrl = this.mediaGalleryEditDetails().saveDetailsUrl,\n                modalElement = $(this.modalSelector),\n                form = modalElement.find('#image-edit-details-form'),\n                imageId = this.imageModel().getSelected().id,\n                keywords = this.mediaGalleryEditDetails().selectedKeywords(),\n                imageDetails = this.mediaGalleryImageDetails(),\n                imageEditDetails = this.mediaGalleryEditDetails();\n\n            if (form.validation('isValid')) {\n                saveDetails(\n                    saveDetailsUrl,\n                    [form.serialize(), $.param({\n                        'keywords': keywords\n                    })].join('&')\n                ).then(function () {\n                    this.closeModal();\n                    this.imageModel().reloadGrid();\n                    imageDetails.removeCached(imageId);\n                    imageEditDetails.removeCached(imageId);\n\n                    if (imageDetails.isActive()) {\n                        imageDetails.showImageDetailsById(imageId);\n                    }\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Add Image\n         */\n        addImage: function () {\n            addSelected.insertImage(\n                this.imageModel().getSelected(),\n                {\n                    onInsertUrl: this.imageModel().onInsertUrl,\n                    storeId: this.imageModel().storeId\n                }\n            );\n            this.closeModal();\n        },\n\n        /**\n         * Close view details modal after confirm deleting image\n         */\n        closeViewDetailsModal: function () {\n            this.closeModal();\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/image/image-details.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_MediaGalleryUi/js/action/getDetails'\n], function ($, _, Component, getDetails) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_MediaGalleryUi/image/image-details',\n            modalSelector: '',\n            modalWindowSelector: '',\n            imageDetailsUrl: '/media_gallery/image/details',\n            images: [],\n            tagListLimit: 7,\n            showAllTags: false,\n            image: null,\n            modules: {\n                mediaGridMessages: '${ $.mediaGridMessages }'\n            }\n        },\n\n        /**\n         * Init observable variables\n         *\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'image',\n                    'showAllTags'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Show image details by ID\n         *\n         * @param {String} imageId\n         */\n        showImageDetailsById: function (imageId) {\n            if (_.isUndefined(this.images[imageId])) {\n                getDetails(this.imageDetailsUrl, [imageId]).then(function (imageDetails) {\n                    this.images[imageId] = imageDetails[imageId];\n                    this.image(this.images[imageId]);\n                    this.openImageDetailsModal();\n                }.bind(this)).fail(function (error) {\n                    this.addMediaGridMessage('error', error);\n                }.bind(this));\n\n                return;\n            }\n\n            if (this.image() && this.image().id === imageId) {\n                this.openImageDetailsModal();\n\n                return;\n            }\n\n            this.image(this.images[imageId]);\n            this.openImageDetailsModal();\n        },\n\n        /**\n         * Open image details popup\n         */\n        openImageDetailsModal: function () {\n            var modalElement = $(this.modalSelector);\n\n            if (!modalElement.length || _.isUndefined(modalElement.modal)) {\n                return;\n            }\n\n            this.showAllTags(false);\n            modalElement.modal('openModal');\n        },\n\n        /**\n         * Close image details popup\n         */\n        closeImageDetailsModal: function () {\n            var modalElement = $(this.modalSelector);\n\n            if (!modalElement.length || _.isUndefined(modalElement.modal)) {\n                return;\n            }\n\n            modalElement.modal('closeModal');\n        },\n\n        /**\n         * Add media grid message\n         *\n         * @param {String} code\n         * @param {String} message\n         */\n        addMediaGridMessage: function (code, message) {\n            this.mediaGridMessages().add(code, message);\n            this.mediaGridMessages().scheduleCleanup();\n        },\n\n        /**\n         * Get tag text\n         *\n         * @param {String} tagText\n         * @param {Number} tagIndex\n         * @return {String}\n         */\n        getTagText: function (tagText, tagIndex) {\n            return tagText + (this.image().tags.length - 1 === tagIndex ? '' : ',');\n        },\n\n        /**\n         * Show all image tags\n         */\n        showMoreImageTags: function () {\n            this.showAllTags(true);\n        },\n\n        /**\n         * Is value an object\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        isArray: function (value) {\n            return _.isArray(value);\n        },\n\n        /**\n         * Is value not empty\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        notEmpty: function (value) {\n            return value.length > 0;\n        },\n\n        /**\n         * Get name and number text for used in link\n         *\n         * @param {Object} item\n         * @returns {String}\n         */\n        getUsedInText: function (item) {\n            return item.name +  '(' + item.number + ')';\n        },\n\n        /**\n         * Get filter url\n         *\n         * @param {String} link\n         */\n        getFilterUrl: function (link) {\n            return link + '?filters[asset_id]=[' + this.image().id + ']';\n        },\n\n        /**\n         * Check if details modal is active\n         * @return {Boolean}\n         */\n        isActive: function () {\n            return $(this.modalWindowSelector).hasClass('_show');\n        },\n\n        /**\n         * Remove image details\n         *\n         * @param {String} id\n         */\n        removeCached: function (id) {\n            delete this.images[id];\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/image/image-edit.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Ui/js/lib/key-codes',\n    'Magento_MediaGalleryUi/js/action/getDetails',\n    'mage/validation'\n], function ($, _, Component, layout, keyCodes, getDetails) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_MediaGalleryUi/image/image-edit',\n            modalSelector: '.media-gallery-edit-image-details-modal',\n            imageEditDetailsUrl: '/media_gallery/image/details',\n            saveDetailsUrl: '/media_gallery/image/saveDetails',\n            images: [],\n            image: null,\n            keywordOptions: [],\n            selectedKeywords: [],\n            newKeyword: '',\n            newKeywordSelector: '#keyword',\n            modules: {\n                mediaGridMessages: '${ $.mediaGridMessages }',\n                keywordsSelect: '${ $.name }_keywords'\n            },\n            viewConfig: [\n                {\n                    component: 'Magento_Ui/js/form/element/ui-select',\n                    name: '${ $.name }_keywords',\n                    template: 'ui/grid/filters/elements/ui-select',\n                    disableLabel: true\n                }\n            ],\n            exports: {\n                keywordOptions: '${ $.name }_keywords:options'\n            },\n            links: {\n                selectedKeywords: '${ $.name }_keywords:value'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super().initView();\n\n            return this;\n        },\n\n        /**\n         * Add a new keyword to select\n         */\n        addKeyword: function () {\n            var options = this.keywordOptions(),\n                selected = this.selectedKeywords(),\n                newKeywordField = $(this.newKeywordSelector);\n\n            newKeywordField.validation();\n\n            if (!newKeywordField.validation('isValid') || this.newKeyword() === '') {\n                return;\n            }\n\n            options.push(this.getOptionForKeyword(this.newKeyword()));\n            selected.push(this.newKeyword());\n            this.newKeyword('');\n\n            this.keywordOptions(options);\n            this.selectedKeywords(selected);\n        },\n\n        /**\n         * Create an option object based on keyword string\n         *\n         * @param {String} keyword\n         * @returns {Object}\n         */\n        getOptionForKeyword: function (keyword) {\n            return {\n                'is_active': 1,\n                level: 1,\n                value: keyword,\n                label: keyword\n            };\n        },\n\n        /**\n         * Convert array of keywords to options format\n         *\n         * @param {Array} tags\n         */\n        setKeywordOptions: function (tags) {\n            var options = [];\n\n            tags.forEach(function (tag) {\n                options.push(this.getOptionForKeyword(tag));\n            }.bind(this));\n\n            this.keywordOptions(options);\n            this.selectedKeywords(tags);\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Init observable variables\n         *\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'image',\n                    'keywordOptions',\n                    'selectedKeywords',\n                    'newKeyword'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Get image details by ID\n         *\n         * @param {String} imageId\n         */\n        showEditDetailsPanel: function (imageId) {\n            if (_.isUndefined(this.images[imageId])) {\n                getDetails(this.imageEditDetailsUrl, [imageId]).then(function (imageDetails) {\n                    this.images[imageId] = imageDetails[imageId];\n                    this.image(this.images[imageId]);\n                    this.openEditImageDetailsModal();\n                }.bind(this)).fail(function (error) {\n                    this.addMediaGridMessage('error', error);\n                }.bind(this));\n\n                return;\n            }\n\n            if (this.image() && this.image().id === imageId) {\n                this.openEditImageDetailsModal();\n\n                return;\n            }\n\n            this.image(this.images[imageId]);\n            this.openEditImageDetailsModal();\n        },\n\n        /**\n         * Open edit image details popup\n         */\n        openEditImageDetailsModal: function () {\n            var modalElement = $(this.modalSelector);\n\n            if (!modalElement.length || _.isUndefined(modalElement.modal)) {\n                return;\n            }\n\n            this.setKeywordOptions(this.image().tags);\n            this.newKeyword('');\n\n            modalElement.modal('openModal');\n        },\n\n        /**\n         * Close image details popup\n         */\n        closeImageDetailsModal: function () {\n            var modalElement = $(this.modalSelector);\n\n            if (!modalElement.length || _.isUndefined(modalElement.modal)) {\n                return;\n            }\n\n            modalElement.modal('closeModal');\n        },\n\n        /**\n         * Add media grid message\n         *\n         * @param {String} code\n         * @param {String} message\n         */\n        addMediaGridMessage: function (code, message) {\n            this.mediaGridMessages().add(code, message);\n            this.mediaGridMessages().scheduleCleanup();\n        },\n\n        /**\n         * Handle Enter key event to save image details\n         *\n         * @param {Object} data\n         * @param {jQuery.Event} event\n         * @returns {Boolean}\n         */\n        handleEnterKey: function (data, event) {\n            var modalElement = $(this.modalSelector),\n                key = keyCodes[event.keyCode];\n\n            if (key === 'enterKey') {\n                event.preventDefault();\n                modalElement.find('.page-action-buttons button.save').trigger('click');\n            }\n\n            return true;\n        },\n\n        /**\n         * Remove cached image details in edit form\n         *\n         * @param {String} id\n         */\n        removeCached: function (id) {\n            delete this.images[id];\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/action/getDetails.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return function (imageDetailsUrl, imageIds) {\n        var deferred = $.Deferred(),\n            message;\n\n        $.ajax({\n            type: 'GET',\n            url: imageDetailsUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: {\n                'ids': imageIds\n            },\n            context: this,\n\n            /**\n             * Resolve with image details if success, reject with response message othervise\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                if (response.success) {\n                    deferred.resolve(response.imageDetails);\n\n                    return;\n                }\n\n                deferred.reject(response.message);\n            },\n\n            /**\n             * Extract the message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = $t('Could not retrieve image details.');\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/action/deleteImages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/url',\n    'Magento_MediaGalleryUi/js/grid/messages',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function ($, _, urlBuilder, messages, confirmation, $t) {\n    'use strict';\n\n    return function (ids, deleteUrl, confirmationContent) {\n        var deferred = $.Deferred(),\n               title = $t('Delete assets'),\n               cancelText = $t('Cancel'),\n               deleteImageText = $t('Delete');\n\n        /**\n         * Send deletion request with redords ids\n         *\n         * @param {Array} recordIds\n         * @param {String} serviceUrl\n         */\n        function sendRequest(recordIds, serviceUrl) {\n\n            $.ajax({\n                type: 'POST',\n                url: serviceUrl,\n                dataType: 'json',\n                showLoader: true,\n                data: {\n                    'form_key': window.FORM_KEY,\n                    'ids': recordIds\n                },\n                context: this,\n\n                /**\n                 * Success handler for deleting image\n                 *\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    var message = !_.isUndefined(response.message) ? response.message : null;\n\n                    if (!response.success) {\n                        message = message || $t('There was an error on attempt to delete the images.');\n                        $(window).trigger('fileDeleted.enhancedMediaGallery', {\n                            reload: false,\n                            message: message,\n                            code: 'error'\n                        });\n\n                        deferred.reject(message);\n                    }\n\n                    message = message || $t('You have successfully removed the images.');\n                    $(window).trigger('fileDeleted.enhancedMediaGallery', {\n                        reload: true,\n                        message: message,\n                        code: 'success'\n                    });\n                    deferred.resolve(message);\n                },\n\n                /**\n                 * Error handler for deleting image\n                 *\n                 * @param {Object} response\n                 */\n                error: function (response) {\n                    var message;\n\n                    if (typeof response.responseJSON === 'undefined' ||\n                        typeof response.responseJSON.message === 'undefined'\n                    ) {\n                        message = $t('There was an error on attempt to delete the image.');\n                    } else {\n                        message = response.responseJSON.message;\n                    }\n\n                    $(window).trigger('fileDeleted.enhancedMediaGallery', {\n                        reload: false,\n                        message: message,\n                        code: 'error'\n                    });\n                    deferred.reject(message);\n                }\n            });\n        }\n\n        confirmation({\n            title: title,\n            modalClass: 'media-gallery-delete-image-action',\n            content: confirmationContent,\n            buttons: [\n                {\n                    text: cancelText,\n                    class: 'action-secondary action-dismiss',\n\n                    /**\n                     * Close modal\n                     */\n                    click: function () {\n                        this.closeModal();\n                        deferred.resolve({\n                            status: 'canceled'\n                        });\n                    }\n                },\n                {\n                    text: deleteImageText,\n                    class: 'action-primary action-accept',\n\n                    /**\n                     * Delete Image and close modal\n                     */\n                    click: function () {\n                        sendRequest(ids, deleteUrl);\n                        this.closeModal();\n                    }\n                }\n            ]\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/action/deleteImageWithDetailConfirmation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_MediaGalleryUi/js/action/getDetails',\n    'Magento_MediaGalleryUi/js/action/deleteImages',\n    'mage/translate'\n], function ($, _, getDetails, deleteImages, $t) {\n    'use strict';\n\n    return {\n\n        /**\n         * Get information about image use\n         *\n         * @param {Array} recordsIds\n         * @param {String} imageDetailsUrl\n         * @param {String} deleteImageUrl\n         */\n        deleteImageAction: function (recordsIds, imageDetailsUrl, deleteImageUrl) {\n            var confirmationContent = $t('%1Are you sure you want to delete \"%2\" image(s)?')\n                .replace('%2', Object.keys(recordsIds).length),\n                deferred = $.Deferred();\n\n            getDetails(imageDetailsUrl, recordsIds).then(function (images) {\n                        confirmationContent = confirmationContent.replace(\n                            '%1',\n                            this.getRecordRelatedContentMessage(images) + ' '\n                        );\n                    }.bind(this)).fail(function () {\n                        confirmationContent = confirmationContent.replace('%1', '');\n                    }).always(function () {\n                        deleteImages(recordsIds, deleteImageUrl, confirmationContent).then(function (status) {\n                            deferred.resolve(status);\n                        }).fail(function (error) {\n                            deferred.reject(error);\n                        });\n                    });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Get information about image use\n         *\n         * @param {Object|String} images\n         * @return {String}\n         */\n        getRecordRelatedContentMessage: function (images) {\n            var usedInMessage = $t('The selected assets are used in the content of the following entities: '),\n                usedIn = {};\n\n            $.each(images, function (key, image) {\n                $.each(image.details, function (sectionIndex, section) {\n                    if (section.title === 'Used In' && _.isObject(section) && !_.isEmpty(section.value)) {\n                        $.each(section.value, function (entityTypeIndex, entityTypeData) {\n                            usedIn[entityTypeData.name] = entityTypeData.name in usedIn ?\n                                usedIn[entityTypeData.name] + entityTypeData.number :\n                                entityTypeData.number;\n                        });\n                    }\n                });\n            });\n\n            if (_.isEmpty(usedIn)) {\n                return '';\n            }\n\n            return usedInMessage + this.usedInObjectToString(usedIn);\n        },\n\n        /**\n         * Fromats usedIn object to string\n         *\n         * @param {Object} usedIn\n         * @return {String}\n         */\n        usedInObjectToString: function (usedIn) {\n            var entities = [];\n\n            $.each(usedIn, function (entityName, number) {\n                entities.push(entityName + '(' + number + ')');\n            });\n\n            return entities.join(', ') + '.';\n        }\n    };\n});\n","Magento_MediaGalleryUi/js/action/saveDetails.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return function (saveImageDetailsUrl, data) {\n        var deferred = $.Deferred(),\n            message;\n\n        $.ajax({\n            type: 'POST',\n            url: saveImageDetailsUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: data,\n\n            /**\n             * Resolve with image details if success, reject with response message otherwise\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                if (response.success) {\n                    deferred.resolve(response.message);\n\n                    return;\n                }\n\n                deferred.reject(response.message);\n            },\n\n            /**\n             * Extract the message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = $t('Could not save image details.');\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_Security/js/confirm-redirect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*eslint-disable no-undef*/\ndefine(\n    ['jquery'],\n    function ($) {\n        'use strict';\n\n        return function (config, element) {\n            $(element).on('click', config, function () {\n                confirmSetLocation(config.message, config.url);\n            });\n        };\n    }\n);\n","Magento_Security/js/escaper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * A loose JavaScript version of Magento\\Framework\\Escaper\n *\n * Due to differences in how XML/HTML is processed in PHP vs JS there are a couple of minor differences in behavior\n * from the PHP counterpart.\n *\n * The first difference is that the default invocation of escapeHtml without allowedTags will double-escape existing\n * entities as the intention of such an invocation is that the input isn't supposed to contain any HTML.\n *\n * The second difference is that escapeHtml will not escape quotes. Since the input is actually being processed by the\n * DOM there is no chance of quotes being mixed with HTML syntax. And, since escapeHtml is not\n * intended to be used with raw injection into a HTML attribute, this is acceptable.\n *\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        neverAllowedElements: ['script', 'img', 'embed', 'iframe', 'video', 'source', 'object', 'audio'],\n        generallyAllowedAttributes: ['id', 'class', 'href', 'title', 'style'],\n        forbiddenAttributesByElement: {\n            a: ['style']\n        },\n\n        /**\n         * Escape a string for safe injection into HTML\n         *\n         * @param {String} data\n         * @param {Array|null} allowedTags\n         * @returns {String}\n         */\n        escapeHtml: function (data, allowedTags) {\n            var domParser = new DOMParser(),\n                fragment = domParser.parseFromString('<div></div>', 'text/html');\n\n            fragment = fragment.body.childNodes[0];\n            allowedTags = typeof allowedTags === 'object' && allowedTags.length ? allowedTags : null;\n\n            if (allowedTags) {\n                fragment.innerHTML = data || '';\n                allowedTags = this._filterProhibitedTags(allowedTags);\n\n                this._removeComments(fragment);\n                this._removeNotAllowedElements(fragment, allowedTags);\n                this._removeNotAllowedAttributes(fragment);\n\n                return fragment.innerHTML;\n            }\n\n            fragment.textContent = data || '';\n\n            return fragment.innerHTML;\n        },\n\n        /**\n         * Remove the always forbidden tags from a list of provided tags\n         *\n         * @param {Array} tags\n         * @returns {Array}\n         * @private\n         */\n        _filterProhibitedTags: function (tags) {\n            return tags.filter(function (n) {\n                return this.neverAllowedElements.indexOf(n) === -1;\n            }.bind(this));\n        },\n\n        /**\n         * Remove comment nodes from the given node\n         *\n         * @param {Node} node\n         * @private\n         */\n        _removeComments: function (node) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_COMMENT,\n                    function () {\n                        return NodeFilter.FILTER_ACCEPT;\n                    },\n                    false\n                ),\n                nodesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                nodesToRemove.push(treeWalker.currentNode);\n            }\n\n            nodesToRemove.forEach(function (nodeToRemove) {\n                nodeToRemove.parentNode.removeChild(nodeToRemove);\n            });\n        },\n\n        /**\n         * Strip the given node of all disallowed tags while permitting any nested text nodes\n         *\n         * @param {Node} node\n         * @param {Array|null} allowedTags\n         * @private\n         */\n        _removeNotAllowedElements: function (node, allowedTags) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_ELEMENT,\n                    function (currentNode) {\n                        return allowedTags.indexOf(currentNode.nodeName.toLowerCase()) === -1 ?\n                            NodeFilter.FILTER_ACCEPT\n                            // SKIP instead of REJECT because REJECT also rejects child nodes\n                            : NodeFilter.FILTER_SKIP;\n                    },\n                false\n                ),\n                nodesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                if (allowedTags.indexOf(treeWalker.currentNode.nodeName.toLowerCase()) === -1) {\n                    nodesToRemove.push(treeWalker.currentNode);\n                }\n            }\n\n            nodesToRemove.forEach(function (nodeToRemove) {\n                nodeToRemove.parentNode.replaceChild(\n                    node.ownerDocument.createTextNode(nodeToRemove.textContent),\n                    nodeToRemove\n                );\n            });\n        },\n\n        /**\n         * Remove any invalid attributes from the given node\n         *\n         * @param {Node} node\n         * @private\n         */\n        _removeNotAllowedAttributes: function (node) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_ELEMENT,\n                    function () {\n                        return NodeFilter.FILTER_ACCEPT;\n                    },\n                false\n                ),\n                i,\n                attribute,\n                nodeName,\n                attributesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                for (i = 0; i < treeWalker.currentNode.attributes.length; i++) {\n                    attribute = treeWalker.currentNode.attributes[i];\n                    nodeName = treeWalker.currentNode.nodeName.toLowerCase();\n\n                    if (this.generallyAllowedAttributes.indexOf(attribute.name) === -1  || // eslint-disable-line max-depth,max-len\n                        this._checkHrefValue(attribute) ||\n                        this.forbiddenAttributesByElement[nodeName] &&\n                        this.forbiddenAttributesByElement[nodeName].indexOf(attribute.name) !== -1\n                    ) {\n                        attributesToRemove.push(attribute);\n                    }\n                }\n            }\n\n            attributesToRemove.forEach(function (attributeToRemove) {\n                attributeToRemove.ownerElement.removeAttribute(attributeToRemove.name);\n            });\n        },\n\n        /**\n         * Check that attribute contains script content\n         *\n         * @param {Object} attribute\n         * @private\n         */\n        _checkHrefValue: function (attribute) {\n            return attribute.nodeName === 'href' && attribute.nodeValue.startsWith('javascript');\n        }\n    };\n});\n","Magento_Security/js/system/config/session-size.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Ui/js/modal/confirm',\n    'domReady!'\n], function ($, $t, confirm) {\n    'use strict';\n\n    return function (config, inputEl) {\n        var $inputEl = $(inputEl);\n\n        $inputEl.on('blur', function () {\n            var inputVal = parseInt($inputEl.val(), 10);\n\n            if (inputVal < 256000) {\n                confirm({\n                    title: $t(config.modalTitleText),\n                    content: $t(config.modalContentBody),\n                    buttons: [{\n                        text: $t('No'),\n                        class: 'action-secondary action-dismiss',\n\n                        /**\n                         * Close modal and trigger 'cancel' action on click\n                         */\n                        click: function (event) {\n                            this.closeModal(event);\n                        }\n                    }, {\n                        text: $t('Yes'),\n                        class: 'action-primary action-accept',\n\n                        /**\n                         * Close modal and trigger 'confirm' action on click\n                         */\n                        click: function (event) {\n                            this.closeModal(event, true);\n                        }\n                    }],\n                    actions: {\n\n                        /**\n                         * Revert back to original value\n                         */\n                        cancel: function () {\n                            $inputEl.val(256000);\n                        }\n                    }\n                });\n            }\n        });\n    };\n});\n","WeltPixel_Backend/jscolor/jscolor.js":"/**\n * jscolor, JavaScript Color Picker\n *\n * @version 1.4.3\n * @license GNU Lesser General Public License, http://www.gnu.org/copyleft/lesser.html\n * @author  Jan Odvarko, http://odvarko.cz\n * @created 2008-06-15\n * @updated 2014-07-16\n * @link    http://jscolor.com\n */\n\n\nvar jscolor = {\n\n\n\tdir : '', // location of jscolor directory (leave empty to autodetect)\n\tbindClass : 'color', // class name\n\tbinding : true, // automatic binding via <input class=\"...\">\n\tpreloading : true, // use image preloading?\n\n\n\tinstall : function() {\n\t\tjscolor.addEvent(window, 'load', jscolor.init);\n\t},\n\n\n\tinit : function() {\n\t\tif(jscolor.binding) {\n\t\t\tjscolor.bind();\n\t\t}\n\t\tif(jscolor.preloading) {\n\t\t\tjscolor.preload();\n\t\t}\n\t},\n\n\n\tgetDir : function() {\n\t\tif(!jscolor.dir) {\n\t\t\tvar detected = jscolor.detectDir();\n\t\t\tjscolor.dir = detected!==false ? detected : 'jscolor/';\n\t\t}\n\t\treturn jscolor.dir;\n\t},\n\n\n\tdetectDir : function() {\n\n\t\treturn document.getElementById('wp_base_url_jscolor').value + '/';\n\n\t\tvar base = location.href;\n\n\t\tvar e = document.getElementsByTagName('base');\n\t\tfor(var i=0; i<e.length; i+=1) {\n\t\t\tif(e[i].href) { base = e[i].href; }\n\t\t}\n\n\t\tvar e = document.getElementsByTagName('script');\n\t\tfor(var i=0; i<e.length; i+=1) {\n\t\t\tif(e[i].src && /(^|\\/)jscolor\\.js([?#].*)?$/i.test(e[i].src)) {\n\t\t\t\tvar src = new jscolor.URI(e[i].src);\n\t\t\t\tvar srcAbs = src.toAbsolute(base);\n\t\t\t\tsrcAbs.path = srcAbs.path.replace(/[^\\/]+$/, ''); // remove filename\n\t\t\t\tsrcAbs.query = null;\n\t\t\t\tsrcAbs.fragment = null;\n\t\t\t\treturn srcAbs.toString();\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t},\n\n\n\tbind : function() {\n\t\tvar matchClass = new RegExp('(^|\\\\s)('+jscolor.bindClass+')(\\\\s*(\\\\{[^}]*\\\\})|\\\\s|$)', 'i');\n\t\tvar e = document.getElementsByTagName('input');\n\t\tfor(var i=0; i<e.length; i+=1) {\n\t\t\tvar m;\n\t\t\tif(!e[i].color && e[i].className && (m = e[i].className.match(matchClass))) {\n\t\t\t\tvar prop = {};\n\t\t\t\tif(m[4]) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tprop = (new Function ('return (' + m[4] + ')'))();\n\t\t\t\t\t} catch(eInvalidProp) {}\n\t\t\t\t}\n\t\t\t\te[i].color = new jscolor.color(e[i], prop);\n\t\t\t}\n\t\t}\n\t},\n\n\n\tpreload : function() {\n\t\tfor(var fn in jscolor.imgRequire) {\n\t\t\tif(jscolor.imgRequire.hasOwnProperty(fn)) {\n\t\t\t\tjscolor.loadImage(fn);\n\t\t\t}\n\t\t}\n\t},\n\n\n\timages : {\n\t\tpad : [ 181, 101 ],\n\t\tsld : [ 16, 101 ],\n\t\tcross : [ 15, 15 ],\n\t\tarrow : [ 7, 11 ]\n\t},\n\n\n\timgRequire : {},\n\timgLoaded : {},\n\n\n\trequireImage : function(filename) {\n\t\tjscolor.imgRequire[filename] = true;\n\t},\n\n\n\tloadImage : function(filename) {\n\t\tif(!jscolor.imgLoaded[filename]) {\n\t\t\tjscolor.imgLoaded[filename] = new Image();\n\t\t\tjscolor.imgLoaded[filename].src = jscolor.getDir()+filename;\n\t\t}\n\t},\n\n\n\tfetchElement : function(mixed) {\n\t\treturn typeof mixed === 'string' ? document.getElementById(mixed) : mixed;\n\t},\n\n\n\taddEvent : function(el, evnt, func) {\n\t\tif(el.addEventListener) {\n\t\t\tel.addEventListener(evnt, func, false);\n\t\t} else if(el.attachEvent) {\n\t\t\tel.attachEvent('on'+evnt, func);\n\t\t}\n\t},\n\n\n\tfireEvent : function(el, evnt) {\n\t\tif(!el) {\n\t\t\treturn;\n\t\t}\n\t\tif(document.createEvent) {\n\t\t\tvar ev = document.createEvent('HTMLEvents');\n\t\t\tev.initEvent(evnt, true, true);\n\t\t\tel.dispatchEvent(ev);\n\t\t} else if(document.createEventObject) {\n\t\t\tvar ev = document.createEventObject();\n\t\t\tel.fireEvent('on'+evnt, ev);\n\t\t} else if(el['on'+evnt]) { // alternatively use the traditional event model (IE5)\n\t\t\tel['on'+evnt]();\n\t\t}\n\t},\n\n\n\tgetElementPos : function(e) {\n\t\tvar e1=e, e2=e;\n\t\tvar x=0, y=0;\n\t\tif(e1.offsetParent) {\n\t\t\tdo {\n\t\t\t\tx += e1.offsetLeft;\n\t\t\t\ty += e1.offsetTop;\n\t\t\t} while(e1 = e1.offsetParent);\n\t\t}\n\t\twhile((e2 = e2.parentNode) && e2.nodeName.toUpperCase() !== 'BODY') {\n\t\t\tx -= e2.scrollLeft;\n\t\t\ty -= e2.scrollTop;\n\t\t}\n\t\treturn [x, y];\n\t},\n\n\n\tgetElementSize : function(e) {\n\t\treturn [e.offsetWidth, e.offsetHeight];\n\t},\n\n\n\tgetRelMousePos : function(e) {\n\t\tvar x = 0, y = 0;\n\t\tif (!e) { e = window.event; }\n\t\tif (typeof e.offsetX === 'number') {\n\t\t\tx = e.offsetX;\n\t\t\ty = e.offsetY;\n\t\t} else if (typeof e.layerX === 'number') {\n\t\t\tx = e.layerX;\n\t\t\ty = e.layerY;\n\t\t}\n\t\treturn { x: x, y: y };\n\t},\n\n\n\tgetViewPos : function() {\n\t\tif(typeof window.pageYOffset === 'number') {\n\t\t\treturn [window.pageXOffset, window.pageYOffset];\n\t\t} else if(document.body && (document.body.scrollLeft || document.body.scrollTop)) {\n\t\t\treturn [document.body.scrollLeft, document.body.scrollTop];\n\t\t} else if(document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {\n\t\t\treturn [document.documentElement.scrollLeft, document.documentElement.scrollTop];\n\t\t} else {\n\t\t\treturn [0, 0];\n\t\t}\n\t},\n\n\n\tgetViewSize : function() {\n\t\tif(typeof window.innerWidth === 'number') {\n\t\t\treturn [window.innerWidth, window.innerHeight];\n\t\t} else if(document.body && (document.body.clientWidth || document.body.clientHeight)) {\n\t\t\treturn [document.body.clientWidth, document.body.clientHeight];\n\t\t} else if(document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight)) {\n\t\t\treturn [document.documentElement.clientWidth, document.documentElement.clientHeight];\n\t\t} else {\n\t\t\treturn [0, 0];\n\t\t}\n\t},\n\n\n\tURI : function(uri) { // See RFC3986\n\n\t\tthis.scheme = null;\n\t\tthis.authority = null;\n\t\tthis.path = '';\n\t\tthis.query = null;\n\t\tthis.fragment = null;\n\n\t\tthis.parse = function(uri) {\n\t\t\tvar m = uri.match(/^(([A-Za-z][0-9A-Za-z+.-]*)(:))?((\\/\\/)([^\\/?#]*))?([^?#]*)((\\?)([^#]*))?((#)(.*))?/);\n\t\t\tthis.scheme = m[3] ? m[2] : null;\n\t\t\tthis.authority = m[5] ? m[6] : null;\n\t\t\tthis.path = m[7];\n\t\t\tthis.query = m[9] ? m[10] : null;\n\t\t\tthis.fragment = m[12] ? m[13] : null;\n\t\t\treturn this;\n\t\t};\n\n\t\tthis.toString = function() {\n\t\t\tvar result = '';\n\t\t\tif(this.scheme !== null) { result = result + this.scheme + ':'; }\n\t\t\tif(this.authority !== null) { result = result + '//' + this.authority; }\n\t\t\tif(this.path !== null) { result = result + this.path; }\n\t\t\tif(this.query !== null) { result = result + '?' + this.query; }\n\t\t\tif(this.fragment !== null) { result = result + '#' + this.fragment; }\n\t\t\treturn result;\n\t\t};\n\n\t\tthis.toAbsolute = function(base) {\n\t\t\tvar base = new jscolor.URI(base);\n\t\t\tvar r = this;\n\t\t\tvar t = new jscolor.URI;\n\n\t\t\tif(base.scheme === null) { return false; }\n\n\t\t\tif(r.scheme !== null && r.scheme.toLowerCase() === base.scheme.toLowerCase()) {\n\t\t\t\tr.scheme = null;\n\t\t\t}\n\n\t\t\tif(r.scheme !== null) {\n\t\t\t\tt.scheme = r.scheme;\n\t\t\t\tt.authority = r.authority;\n\t\t\t\tt.path = removeDotSegments(r.path);\n\t\t\t\tt.query = r.query;\n\t\t\t} else {\n\t\t\t\tif(r.authority !== null) {\n\t\t\t\t\tt.authority = r.authority;\n\t\t\t\t\tt.path = removeDotSegments(r.path);\n\t\t\t\t\tt.query = r.query;\n\t\t\t\t} else {\n\t\t\t\t\tif(r.path === '') {\n\t\t\t\t\t\tt.path = base.path;\n\t\t\t\t\t\tif(r.query !== null) {\n\t\t\t\t\t\t\tt.query = r.query;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tt.query = base.query;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif(r.path.substr(0,1) === '/') {\n\t\t\t\t\t\t\tt.path = removeDotSegments(r.path);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tif(base.authority !== null && base.path === '') {\n\t\t\t\t\t\t\t\tt.path = '/'+r.path;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tt.path = base.path.replace(/[^\\/]+$/,'')+r.path;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tt.path = removeDotSegments(t.path);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tt.query = r.query;\n\t\t\t\t\t}\n\t\t\t\t\tt.authority = base.authority;\n\t\t\t\t}\n\t\t\t\tt.scheme = base.scheme;\n\t\t\t}\n\t\t\tt.fragment = r.fragment;\n\n\t\t\treturn t;\n\t\t};\n\n\t\tfunction removeDotSegments(path) {\n\t\t\tvar out = '';\n\t\t\twhile(path) {\n\t\t\t\tif(path.substr(0,3)==='../' || path.substr(0,2)==='./') {\n\t\t\t\t\tpath = path.replace(/^\\.+/,'').substr(1);\n\t\t\t\t} else if(path.substr(0,3)==='/./' || path==='/.') {\n\t\t\t\t\tpath = '/'+path.substr(3);\n\t\t\t\t} else if(path.substr(0,4)==='/../' || path==='/..') {\n\t\t\t\t\tpath = '/'+path.substr(4);\n\t\t\t\t\tout = out.replace(/\\/?[^\\/]*$/, '');\n\t\t\t\t} else if(path==='.' || path==='..') {\n\t\t\t\t\tpath = '';\n\t\t\t\t} else {\n\t\t\t\t\tvar rm = path.match(/^\\/?[^\\/]*/)[0];\n\t\t\t\t\tpath = path.substr(rm.length);\n\t\t\t\t\tout = out + rm;\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn out;\n\t\t}\n\n\t\tif(uri) {\n\t\t\tthis.parse(uri);\n\t\t}\n\n\t},\n\n\n\t//\n\t// Usage example:\n\t// var myColor = new jscolor.color(myInputElement)\n\t//\n\n\tcolor : function(target, prop) {\n\n\n\t\tthis.required = true; // refuse empty values?\n\t\tthis.adjust = true; // adjust value to uniform notation?\n\t\tthis.hash = false; // prefix color with # symbol?\n\t\tthis.caps = true; // uppercase?\n\t\tthis.slider = true; // show the value/saturation slider?\n\t\tthis.valueElement = target; // value holder\n\t\tthis.styleElement = target; // where to reflect current color\n\t\tthis.onImmediateChange = null; // onchange callback (can be either string or function)\n\t\tthis.hsv = [0, 0, 1]; // read-only  0-6, 0-1, 0-1\n\t\tthis.rgb = [1, 1, 1]; // read-only  0-1, 0-1, 0-1\n\t\tthis.minH = 0; // read-only  0-6\n\t\tthis.maxH = 6; // read-only  0-6\n\t\tthis.minS = 0; // read-only  0-1\n\t\tthis.maxS = 1; // read-only  0-1\n\t\tthis.minV = 0; // read-only  0-1\n\t\tthis.maxV = 1; // read-only  0-1\n\n\t\tthis.pickerOnfocus = true; // display picker on focus?\n\t\tthis.pickerMode = 'HSV'; // HSV | HVS\n\t\tthis.pickerPosition = 'bottom'; // left | right | top | bottom\n\t\tthis.pickerSmartPosition = true; // automatically adjust picker position when necessary\n\t\tthis.pickerButtonHeight = 20; // px\n\t\tthis.pickerClosable = false;\n\t\tthis.pickerCloseText = 'Close';\n\t\tthis.pickerButtonColor = 'ButtonText'; // px\n\t\tthis.pickerFace = 10; // px\n\t\tthis.pickerFaceColor = 'ThreeDFace'; // CSS color\n\t\tthis.pickerBorder = 1; // px\n\t\tthis.pickerBorderColor = 'ThreeDHighlight ThreeDShadow ThreeDShadow ThreeDHighlight'; // CSS color\n\t\tthis.pickerInset = 1; // px\n\t\tthis.pickerInsetColor = 'ThreeDShadow ThreeDHighlight ThreeDHighlight ThreeDShadow'; // CSS color\n\t\tthis.pickerZIndex = 10000;\n\n\n\t\tfor(var p in prop) {\n\t\t\tif(prop.hasOwnProperty(p)) {\n\t\t\t\tthis[p] = prop[p];\n\t\t\t}\n\t\t}\n\n\n\t\tthis.hidePicker = function() {\n\t\t\tif(isPickerOwner()) {\n\t\t\t\tremovePicker();\n\t\t\t}\n\t\t};\n\n\n\t\tthis.showPicker = function() {\n\t\t\tif(!isPickerOwner()) {\n\t\t\t\tvar tp = jscolor.getElementPos(target); // target pos\n\t\t\t\tvar ts = jscolor.getElementSize(target); // target size\n\t\t\t\tvar vp = jscolor.getViewPos(); // view pos\n\t\t\t\tvar vs = jscolor.getViewSize(); // view size\n\t\t\t\tvar ps = getPickerDims(this); // picker size\n\t\t\t\tvar a, b, c;\n\t\t\t\tswitch(this.pickerPosition.toLowerCase()) {\n\t\t\t\t\tcase 'left': a=1; b=0; c=-1; break;\n\t\t\t\t\tcase 'right':a=1; b=0; c=1; break;\n\t\t\t\t\tcase 'top':  a=0; b=1; c=-1; break;\n\t\t\t\t\tdefault:     a=0; b=1; c=1; break;\n\t\t\t\t}\n\t\t\t\tvar l = (ts[b]+ps[b])/2;\n\n\t\t\t\t// picker pos\n\t\t\t\tif (!this.pickerSmartPosition) {\n\t\t\t\t\tvar pp = [\n\t\t\t\t\t\ttp[a],\n\t\t\t\t\t\ttp[b]+ts[b]-l+l*c\n\t\t\t\t\t];\n\t\t\t\t} else {\n\t\t\t\t\tvar pp = [\n\t\t\t\t\t\t-vp[a]+tp[a]+ps[a] > vs[a] ?\n\t\t\t\t\t\t\t(-vp[a]+tp[a]+ts[a]/2 > vs[a]/2 && tp[a]+ts[a]-ps[a] >= 0 ? tp[a]+ts[a]-ps[a] : tp[a]) :\n\t\t\t\t\t\t\ttp[a],\n\t\t\t\t\t\t-vp[b]+tp[b]+ts[b]+ps[b]-l+l*c > vs[b] ?\n\t\t\t\t\t\t\t(-vp[b]+tp[b]+ts[b]/2 > vs[b]/2 && tp[b]+ts[b]-l-l*c >= 0 ? tp[b]+ts[b]-l-l*c : tp[b]+ts[b]-l+l*c) :\n\t\t\t\t\t\t\t(tp[b]+ts[b]-l+l*c >= 0 ? tp[b]+ts[b]-l+l*c : tp[b]+ts[b]-l-l*c)\n\t\t\t\t\t];\n\t\t\t\t}\n\t\t\t\tdrawPicker(pp[a], pp[b]);\n\t\t\t}\n\t\t};\n\n\n\t\tthis.importColor = function() {\n\t\t\tif(!valueElement) {\n\t\t\t\tthis.exportColor();\n\t\t\t} else {\n\t\t\t\tif(!this.adjust) {\n\t\t\t\t\tif(!this.fromString(valueElement.value, leaveValue)) {\n\t\t\t\t\t\tstyleElement.style.backgroundImage = styleElement.jscStyle.backgroundImage;\n\t\t\t\t\t\tstyleElement.style.backgroundColor = styleElement.jscStyle.backgroundColor;\n\t\t\t\t\t\tstyleElement.style.color = styleElement.jscStyle.color;\n\t\t\t\t\t\tthis.exportColor(leaveValue | leaveStyle);\n\t\t\t\t\t}\n\t\t\t\t} else if(!this.required && /^\\s*$/.test(valueElement.value)) {\n\t\t\t\t\tvalueElement.value = '';\n\t\t\t\t\tstyleElement.style.backgroundImage = styleElement.jscStyle.backgroundImage;\n\t\t\t\t\tstyleElement.style.backgroundColor = styleElement.jscStyle.backgroundColor;\n\t\t\t\t\tstyleElement.style.color = styleElement.jscStyle.color;\n\t\t\t\t\tthis.exportColor(leaveValue | leaveStyle);\n\n\t\t\t\t} else if(this.fromString(valueElement.value)) {\n\t\t\t\t\t// OK\n\t\t\t\t} else {\n\t\t\t\t\tthis.exportColor();\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\n\t\tthis.exportColor = function(flags) {\n\t\t\tif(!(flags & leaveValue) && valueElement) {\n\t\t\t\tvar value = this.toString();\n\t\t\t\tif(this.caps) { value = value.toUpperCase(); }\n\t\t\t\tif(this.hash) { value = '#'+value; }\n\t\t\t\tvalueElement.value = value;\n\t\t\t}\n\t\t\tif(!(flags & leaveStyle) && styleElement) {\n\t\t\t\tstyleElement.style.backgroundImage = \"none\";\n\t\t\t\tstyleElement.style.backgroundColor =\n\t\t\t\t\t'#'+this.toString();\n\t\t\t\tstyleElement.style.color =\n\t\t\t\t\t0.213 * this.rgb[0] +\n\t\t\t\t\t0.715 * this.rgb[1] +\n\t\t\t\t\t0.072 * this.rgb[2]\n\t\t\t\t\t< 0.5 ? '#FFF' : '#000';\n\t\t\t}\n\t\t\tif(!(flags & leavePad) && isPickerOwner()) {\n\t\t\t\tredrawPad();\n\t\t\t}\n\t\t\tif(!(flags & leaveSld) && isPickerOwner()) {\n\t\t\t\tredrawSld();\n\t\t\t}\n\t\t};\n\n\n\t\tthis.fromHSV = function(h, s, v, flags) { // null = don't change\n\t\t\tif(h !== null) { h = Math.max(0.0, this.minH, Math.min(6.0, this.maxH, h)); }\n\t\t\tif(s !== null) { s = Math.max(0.0, this.minS, Math.min(1.0, this.maxS, s)); }\n\t\t\tif(v !== null) { v = Math.max(0.0, this.minV, Math.min(1.0, this.maxV, v)); }\n\n\t\t\tthis.rgb = HSV_RGB(\n\t\t\t\th===null ? this.hsv[0] : (this.hsv[0]=h),\n\t\t\t\ts===null ? this.hsv[1] : (this.hsv[1]=s),\n\t\t\t\tv===null ? this.hsv[2] : (this.hsv[2]=v)\n\t\t\t);\n\n\t\t\tthis.exportColor(flags);\n\t\t};\n\n\n\t\tthis.fromRGB = function(r, g, b, flags) { // null = don't change\n\t\t\tif(r !== null) { r = Math.max(0.0, Math.min(1.0, r)); }\n\t\t\tif(g !== null) { g = Math.max(0.0, Math.min(1.0, g)); }\n\t\t\tif(b !== null) { b = Math.max(0.0, Math.min(1.0, b)); }\n\n\t\t\tvar hsv = RGB_HSV(\n\t\t\t\tr===null ? this.rgb[0] : r,\n\t\t\t\tg===null ? this.rgb[1] : g,\n\t\t\t\tb===null ? this.rgb[2] : b\n\t\t\t);\n\t\t\tif(hsv[0] !== null) {\n\t\t\t\tthis.hsv[0] = Math.max(0.0, this.minH, Math.min(6.0, this.maxH, hsv[0]));\n\t\t\t}\n\t\t\tif(hsv[2] !== 0) {\n\t\t\t\tthis.hsv[1] = hsv[1]===null ? null : Math.max(0.0, this.minS, Math.min(1.0, this.maxS, hsv[1]));\n\t\t\t}\n\t\t\tthis.hsv[2] = hsv[2]===null ? null : Math.max(0.0, this.minV, Math.min(1.0, this.maxV, hsv[2]));\n\n\t\t\t// update RGB according to final HSV, as some values might be trimmed\n\t\t\tvar rgb = HSV_RGB(this.hsv[0], this.hsv[1], this.hsv[2]);\n\t\t\tthis.rgb[0] = rgb[0];\n\t\t\tthis.rgb[1] = rgb[1];\n\t\t\tthis.rgb[2] = rgb[2];\n\n\t\t\tthis.exportColor(flags);\n\t\t};\n\n\n\t\tthis.fromString = function(hex, flags) {\n\t\t\tvar m = hex.match(/^\\W*([0-9A-F]{3}([0-9A-F]{3})?)\\W*$/i);\n\t\t\tif(!m) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tif(m[1].length === 6) { // 6-char notation\n\t\t\t\t\tthis.fromRGB(\n\t\t\t\t\t\tparseInt(m[1].substr(0,2),16) / 255,\n\t\t\t\t\t\tparseInt(m[1].substr(2,2),16) / 255,\n\t\t\t\t\t\tparseInt(m[1].substr(4,2),16) / 255,\n\t\t\t\t\t\tflags\n\t\t\t\t\t);\n\t\t\t\t} else { // 3-char notation\n\t\t\t\t\tthis.fromRGB(\n\t\t\t\t\t\tparseInt(m[1].charAt(0)+m[1].charAt(0),16) / 255,\n\t\t\t\t\t\tparseInt(m[1].charAt(1)+m[1].charAt(1),16) / 255,\n\t\t\t\t\t\tparseInt(m[1].charAt(2)+m[1].charAt(2),16) / 255,\n\t\t\t\t\t\tflags\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t}\n\t\t};\n\n\n\t\tthis.toString = function() {\n\t\t\treturn (\n\t\t\t\t(0x100 | Math.round(255*this.rgb[0])).toString(16).substr(1) +\n\t\t\t\t(0x100 | Math.round(255*this.rgb[1])).toString(16).substr(1) +\n\t\t\t\t(0x100 | Math.round(255*this.rgb[2])).toString(16).substr(1)\n\t\t\t);\n\t\t};\n\n\n\t\tfunction RGB_HSV(r, g, b) {\n\t\t\tvar n = Math.min(Math.min(r,g),b);\n\t\t\tvar v = Math.max(Math.max(r,g),b);\n\t\t\tvar m = v - n;\n\t\t\tif(m === 0) { return [ null, 0, v ]; }\n\t\t\tvar h = r===n ? 3+(b-g)/m : (g===n ? 5+(r-b)/m : 1+(g-r)/m);\n\t\t\treturn [ h===6?0:h, m/v, v ];\n\t\t}\n\n\n\t\tfunction HSV_RGB(h, s, v) {\n\t\t\tif(h === null) { return [ v, v, v ]; }\n\t\t\tvar i = Math.floor(h);\n\t\t\tvar f = i%2 ? h-i : 1-(h-i);\n\t\t\tvar m = v * (1 - s);\n\t\t\tvar n = v * (1 - s*f);\n\t\t\tswitch(i) {\n\t\t\t\tcase 6:\n\t\t\t\tcase 0: return [v,n,m];\n\t\t\t\tcase 1: return [n,v,m];\n\t\t\t\tcase 2: return [m,v,n];\n\t\t\t\tcase 3: return [m,n,v];\n\t\t\t\tcase 4: return [n,m,v];\n\t\t\t\tcase 5: return [v,m,n];\n\t\t\t}\n\t\t}\n\n\n\t\tfunction removePicker() {\n\t\t\tdelete jscolor.picker.owner;\n\t\t\tdocument.getElementsByTagName('body')[0].removeChild(jscolor.picker.boxB);\n\t\t}\n\n\n\t\tfunction drawPicker(x, y) {\n\t\t\tif(!jscolor.picker) {\n\t\t\t\tjscolor.picker = {\n\t\t\t\t\tbox : document.createElement('div'),\n\t\t\t\t\tboxB : document.createElement('div'),\n\t\t\t\t\tpad : document.createElement('div'),\n\t\t\t\t\tpadB : document.createElement('div'),\n\t\t\t\t\tpadM : document.createElement('div'),\n\t\t\t\t\tsld : document.createElement('div'),\n\t\t\t\t\tsldB : document.createElement('div'),\n\t\t\t\t\tsldM : document.createElement('div'),\n\t\t\t\t\tbtn : document.createElement('div'),\n\t\t\t\t\tbtnS : document.createElement('span'),\n\t\t\t\t\tbtnT : document.createTextNode(THIS.pickerCloseText)\n\t\t\t\t};\n\t\t\t\tfor(var i=0,segSize=4; i<jscolor.images.sld[1]; i+=segSize) {\n\t\t\t\t\tvar seg = document.createElement('div');\n\t\t\t\t\tseg.style.height = segSize+'px';\n\t\t\t\t\tseg.style.fontSize = '1px';\n\t\t\t\t\tseg.style.lineHeight = '0';\n\t\t\t\t\tjscolor.picker.sld.appendChild(seg);\n\t\t\t\t}\n\t\t\t\tjscolor.picker.sldB.appendChild(jscolor.picker.sld);\n\t\t\t\tjscolor.picker.box.appendChild(jscolor.picker.sldB);\n\t\t\t\tjscolor.picker.box.appendChild(jscolor.picker.sldM);\n\t\t\t\tjscolor.picker.padB.appendChild(jscolor.picker.pad);\n\t\t\t\tjscolor.picker.box.appendChild(jscolor.picker.padB);\n\t\t\t\tjscolor.picker.box.appendChild(jscolor.picker.padM);\n\t\t\t\tjscolor.picker.btnS.appendChild(jscolor.picker.btnT);\n\t\t\t\tjscolor.picker.btn.appendChild(jscolor.picker.btnS);\n\t\t\t\tjscolor.picker.box.appendChild(jscolor.picker.btn);\n\t\t\t\tjscolor.picker.boxB.appendChild(jscolor.picker.box);\n\t\t\t}\n\n\t\t\tvar p = jscolor.picker;\n\n\t\t\t// controls interaction\n\t\t\tp.box.onmouseup =\n\t\t\tp.box.onmouseout = function() { target.focus(); };\n\t\t\tp.box.onmousedown = function() { abortBlur=true; };\n\t\t\tp.box.onmousemove = function(e) {\n\t\t\t\tif (holdPad || holdSld) {\n\t\t\t\t\tholdPad && setPad(e);\n\t\t\t\t\tholdSld && setSld(e);\n\t\t\t\t\tif (document.selection) {\n\t\t\t\t\t\tdocument.selection.empty();\n\t\t\t\t\t} else if (window.getSelection) {\n\t\t\t\t\t\twindow.getSelection().removeAllRanges();\n\t\t\t\t\t}\n\t\t\t\t\tdispatchImmediateChange();\n\t\t\t\t}\n\t\t\t};\n\t\t\tif('ontouchstart' in window) { // if touch device\n\t\t\t\tvar handle_touchmove = function(e) {\n\t\t\t\t\tvar event={\n\t\t\t\t\t\t'offsetX': e.touches[0].pageX-touchOffset.X,\n\t\t\t\t\t\t'offsetY': e.touches[0].pageY-touchOffset.Y\n\t\t\t\t\t};\n\t\t\t\t\tif (holdPad || holdSld) {\n\t\t\t\t\t\tholdPad && setPad(event);\n\t\t\t\t\t\tholdSld && setSld(event);\n\t\t\t\t\t\tdispatchImmediateChange();\n\t\t\t\t\t}\n\t\t\t\t\te.stopPropagation(); // prevent move \"view\" on broswer\n\t\t\t\t\te.preventDefault(); // prevent Default - Android Fix (else android generated only 1-2 touchmove events)\n\t\t\t\t};\n\t\t\t\tp.box.removeEventListener('touchmove', handle_touchmove, false)\n\t\t\t\tp.box.addEventListener('touchmove', handle_touchmove, false)\n\t\t\t}\n\t\t\tp.padM.onmouseup =\n\t\t\tp.padM.onmouseout = function() { if(holdPad) { holdPad=false; jscolor.fireEvent(valueElement,'change'); } };\n\t\t\tp.padM.onmousedown = function(e) {\n\t\t\t\t// if the slider is at the bottom, move it up\n\t\t\t\tswitch(modeID) {\n\t\t\t\t\tcase 0: if (THIS.hsv[2] === 0) { THIS.fromHSV(null, null, 1.0); }; break;\n\t\t\t\t\tcase 1: if (THIS.hsv[1] === 0) { THIS.fromHSV(null, 1.0, null); }; break;\n\t\t\t\t}\n\t\t\t\tholdSld=false;\n\t\t\t\tholdPad=true;\n\t\t\t\tsetPad(e);\n\t\t\t\tdispatchImmediateChange();\n\t\t\t};\n\t\t\tif('ontouchstart' in window) {\n\t\t\t\tp.padM.addEventListener('touchstart', function(e) {\n\t\t\t\t\ttouchOffset={\n\t\t\t\t\t\t'X': e.target.offsetParent.offsetLeft,\n\t\t\t\t\t\t'Y': e.target.offsetParent.offsetTop\n\t\t\t\t\t};\n\t\t\t\t\tthis.onmousedown({\n\t\t\t\t\t\t'offsetX':e.touches[0].pageX-touchOffset.X,\n\t\t\t\t\t\t'offsetY':e.touches[0].pageY-touchOffset.Y\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\t\t\tp.sldM.onmouseup =\n\t\t\tp.sldM.onmouseout = function() { if(holdSld) { holdSld=false; jscolor.fireEvent(valueElement,'change'); } };\n\t\t\tp.sldM.onmousedown = function(e) {\n\t\t\t\tholdPad=false;\n\t\t\t\tholdSld=true;\n\t\t\t\tsetSld(e);\n\t\t\t\tdispatchImmediateChange();\n\t\t\t};\n\t\t\tif('ontouchstart' in window) {\n\t\t\t\tp.sldM.addEventListener('touchstart', function(e) {\n\t\t\t\t\ttouchOffset={\n\t\t\t\t\t\t'X': e.target.offsetParent.offsetLeft,\n\t\t\t\t\t\t'Y': e.target.offsetParent.offsetTop\n\t\t\t\t\t};\n\t\t\t\t\tthis.onmousedown({\n\t\t\t\t\t\t'offsetX':e.touches[0].pageX-touchOffset.X,\n\t\t\t\t\t\t'offsetY':e.touches[0].pageY-touchOffset.Y\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// picker\n\t\t\tvar dims = getPickerDims(THIS);\n\t\t\tp.box.style.width = dims[0] + 'px';\n\t\t\tp.box.style.height = dims[1] + 'px';\n\n\t\t\t// picker border\n\t\t\tp.boxB.style.position = 'absolute';\n\t\t\tp.boxB.style.clear = 'both';\n\t\t\tp.boxB.style.left = x+'px';\n\t\t\tp.boxB.style.top = y+'px';\n\t\t\tp.boxB.style.zIndex = THIS.pickerZIndex;\n\t\t\tp.boxB.style.border = THIS.pickerBorder+'px solid';\n\t\t\tp.boxB.style.borderColor = THIS.pickerBorderColor;\n\t\t\tp.boxB.style.background = THIS.pickerFaceColor;\n\n\t\t\t// pad image\n\t\t\tp.pad.style.width = jscolor.images.pad[0]+'px';\n\t\t\tp.pad.style.height = jscolor.images.pad[1]+'px';\n\n\t\t\t// pad border\n\t\t\tp.padB.style.position = 'absolute';\n\t\t\tp.padB.style.left = THIS.pickerFace+'px';\n\t\t\tp.padB.style.top = THIS.pickerFace+'px';\n\t\t\tp.padB.style.border = THIS.pickerInset+'px solid';\n\t\t\tp.padB.style.borderColor = THIS.pickerInsetColor;\n\n\t\t\t// pad mouse area\n\t\t\tp.padM.style.position = 'absolute';\n\t\t\tp.padM.style.left = '0';\n\t\t\tp.padM.style.top = '0';\n\t\t\tp.padM.style.width = THIS.pickerFace + 2*THIS.pickerInset + jscolor.images.pad[0] + jscolor.images.arrow[0] + 'px';\n\t\t\tp.padM.style.height = p.box.style.height;\n\t\t\tp.padM.style.cursor = 'crosshair';\n\n\t\t\t// slider image\n\t\t\tp.sld.style.overflow = 'hidden';\n\t\t\tp.sld.style.width = jscolor.images.sld[0]+'px';\n\t\t\tp.sld.style.height = jscolor.images.sld[1]+'px';\n\n\t\t\t// slider border\n\t\t\tp.sldB.style.display = THIS.slider ? 'block' : 'none';\n\t\t\tp.sldB.style.position = 'absolute';\n\t\t\tp.sldB.style.right = THIS.pickerFace+'px';\n\t\t\tp.sldB.style.top = THIS.pickerFace+'px';\n\t\t\tp.sldB.style.border = THIS.pickerInset+'px solid';\n\t\t\tp.sldB.style.borderColor = THIS.pickerInsetColor;\n\n\t\t\t// slider mouse area\n\t\t\tp.sldM.style.display = THIS.slider ? 'block' : 'none';\n\t\t\tp.sldM.style.position = 'absolute';\n\t\t\tp.sldM.style.right = '0';\n\t\t\tp.sldM.style.top = '0';\n\t\t\tp.sldM.style.width = jscolor.images.sld[0] + jscolor.images.arrow[0] + THIS.pickerFace + 2*THIS.pickerInset + 'px';\n\t\t\tp.sldM.style.height = p.box.style.height;\n\t\t\ttry {\n\t\t\t\tp.sldM.style.cursor = 'pointer';\n\t\t\t} catch(eOldIE) {\n\t\t\t\tp.sldM.style.cursor = 'hand';\n\t\t\t}\n\n\t\t\t// \"close\" button\n\t\t\tfunction setBtnBorder() {\n\t\t\t\tvar insetColors = THIS.pickerInsetColor.split(/\\s+/);\n\t\t\t\tvar pickerOutsetColor = insetColors.length < 2 ? insetColors[0] : insetColors[1] + ' ' + insetColors[0] + ' ' + insetColors[0] + ' ' + insetColors[1];\n\t\t\t\tp.btn.style.borderColor = pickerOutsetColor;\n\t\t\t}\n\t\t\tp.btn.style.display = THIS.pickerClosable ? 'block' : 'none';\n\t\t\tp.btn.style.position = 'absolute';\n\t\t\tp.btn.style.left = THIS.pickerFace + 'px';\n\t\t\tp.btn.style.bottom = THIS.pickerFace + 'px';\n\t\t\tp.btn.style.padding = '0 15px';\n\t\t\tp.btn.style.height = '18px';\n\t\t\tp.btn.style.border = THIS.pickerInset + 'px solid';\n\t\t\tsetBtnBorder();\n\t\t\tp.btn.style.color = THIS.pickerButtonColor;\n\t\t\tp.btn.style.font = '12px sans-serif';\n\t\t\tp.btn.style.textAlign = 'center';\n\t\t\ttry {\n\t\t\t\tp.btn.style.cursor = 'pointer';\n\t\t\t} catch(eOldIE) {\n\t\t\t\tp.btn.style.cursor = 'hand';\n\t\t\t}\n\t\t\tp.btn.onmousedown = function () {\n\t\t\t\tTHIS.hidePicker();\n\t\t\t};\n\t\t\tp.btnS.style.lineHeight = p.btn.style.height;\n\n\t\t\t// load images in optimal order\n\t\t\tswitch(modeID) {\n\t\t\t\tcase 0: var padImg = 'hs.png'; break;\n\t\t\t\tcase 1: var padImg = 'hv.png'; break;\n\t\t\t}\n\t\t\tp.padM.style.backgroundImage = \"url('\"+jscolor.getDir()+\"cross.gif')\";\n\t\t\tp.padM.style.backgroundRepeat = \"no-repeat\";\n\t\t\tp.sldM.style.backgroundImage = \"url('\"+jscolor.getDir()+\"arrow.gif')\";\n\t\t\tp.sldM.style.backgroundRepeat = \"no-repeat\";\n\t\t\tp.pad.style.backgroundImage = \"url('\"+jscolor.getDir()+padImg+\"')\";\n\t\t\tp.pad.style.backgroundRepeat = \"no-repeat\";\n\t\t\tp.pad.style.backgroundPosition = \"0 0\";\n\n\t\t\t// place pointers\n\t\t\tredrawPad();\n\t\t\tredrawSld();\n\n\t\t\tjscolor.picker.owner = THIS;\n\t\t\tdocument.getElementsByTagName('body')[0].appendChild(p.boxB);\n\t\t}\n\n\n\t\tfunction getPickerDims(o) {\n\t\t\tvar dims = [\n\t\t\t\t2*o.pickerInset + 2*o.pickerFace + jscolor.images.pad[0] +\n\t\t\t\t\t(o.slider ? 2*o.pickerInset + 2*jscolor.images.arrow[0] + jscolor.images.sld[0] : 0),\n\t\t\t\to.pickerClosable ?\n\t\t\t\t\t4*o.pickerInset + 3*o.pickerFace + jscolor.images.pad[1] + o.pickerButtonHeight :\n\t\t\t\t\t2*o.pickerInset + 2*o.pickerFace + jscolor.images.pad[1]\n\t\t\t];\n\t\t\treturn dims;\n\t\t}\n\n\n\t\tfunction redrawPad() {\n\t\t\t// redraw the pad pointer\n\t\t\tswitch(modeID) {\n\t\t\t\tcase 0: var yComponent = 1; break;\n\t\t\t\tcase 1: var yComponent = 2; break;\n\t\t\t}\n\t\t\tvar x = Math.round((THIS.hsv[0]/6) * (jscolor.images.pad[0]-1));\n\t\t\tvar y = Math.round((1-THIS.hsv[yComponent]) * (jscolor.images.pad[1]-1));\n\t\t\tjscolor.picker.padM.style.backgroundPosition =\n\t\t\t\t(THIS.pickerFace+THIS.pickerInset+x - Math.floor(jscolor.images.cross[0]/2)) + 'px ' +\n\t\t\t\t(THIS.pickerFace+THIS.pickerInset+y - Math.floor(jscolor.images.cross[1]/2)) + 'px';\n\n\t\t\t// redraw the slider image\n\t\t\tvar seg = jscolor.picker.sld.childNodes;\n\n\t\t\tswitch(modeID) {\n\t\t\t\tcase 0:\n\t\t\t\t\tvar rgb = HSV_RGB(THIS.hsv[0], THIS.hsv[1], 1);\n\t\t\t\t\tfor(var i=0; i<seg.length; i+=1) {\n\t\t\t\t\t\tseg[i].style.backgroundColor = 'rgb('+\n\t\t\t\t\t\t\t(rgb[0]*(1-i/seg.length)*100)+'%,'+\n\t\t\t\t\t\t\t(rgb[1]*(1-i/seg.length)*100)+'%,'+\n\t\t\t\t\t\t\t(rgb[2]*(1-i/seg.length)*100)+'%)';\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase 1:\n\t\t\t\t\tvar rgb, s, c = [ THIS.hsv[2], 0, 0 ];\n\t\t\t\t\tvar i = Math.floor(THIS.hsv[0]);\n\t\t\t\t\tvar f = i%2 ? THIS.hsv[0]-i : 1-(THIS.hsv[0]-i);\n\t\t\t\t\tswitch(i) {\n\t\t\t\t\t\tcase 6:\n\t\t\t\t\t\tcase 0: rgb=[0,1,2]; break;\n\t\t\t\t\t\tcase 1: rgb=[1,0,2]; break;\n\t\t\t\t\t\tcase 2: rgb=[2,0,1]; break;\n\t\t\t\t\t\tcase 3: rgb=[2,1,0]; break;\n\t\t\t\t\t\tcase 4: rgb=[1,2,0]; break;\n\t\t\t\t\t\tcase 5: rgb=[0,2,1]; break;\n\t\t\t\t\t}\n\t\t\t\t\tfor(var i=0; i<seg.length; i+=1) {\n\t\t\t\t\t\ts = 1 - 1/(seg.length-1)*i;\n\t\t\t\t\t\tc[1] = c[0] * (1 - s*f);\n\t\t\t\t\t\tc[2] = c[0] * (1 - s);\n\t\t\t\t\t\tseg[i].style.backgroundColor = 'rgb('+\n\t\t\t\t\t\t\t(c[rgb[0]]*100)+'%,'+\n\t\t\t\t\t\t\t(c[rgb[1]]*100)+'%,'+\n\t\t\t\t\t\t\t(c[rgb[2]]*100)+'%)';\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\n\n\t\tfunction redrawSld() {\n\t\t\t// redraw the slider pointer\n\t\t\tswitch(modeID) {\n\t\t\t\tcase 0: var yComponent = 2; break;\n\t\t\t\tcase 1: var yComponent = 1; break;\n\t\t\t}\n\t\t\tvar y = Math.round((1-THIS.hsv[yComponent]) * (jscolor.images.sld[1]-1));\n\t\t\tjscolor.picker.sldM.style.backgroundPosition =\n\t\t\t\t'0 ' + (THIS.pickerFace+THIS.pickerInset+y - Math.floor(jscolor.images.arrow[1]/2)) + 'px';\n\t\t}\n\n\n\t\tfunction isPickerOwner() {\n\t\t\treturn jscolor.picker && jscolor.picker.owner === THIS;\n\t\t}\n\n\n\t\tfunction blurTarget() {\n\t\t\tif(valueElement === target) {\n\t\t\t\tTHIS.importColor();\n\t\t\t}\n\t\t\tif(THIS.pickerOnfocus) {\n\t\t\t\tTHIS.hidePicker();\n\t\t\t}\n\t\t}\n\n\n\t\tfunction blurValue() {\n\t\t\tif(valueElement !== target) {\n\t\t\t\tTHIS.importColor();\n\t\t\t}\n\t\t}\n\n\n\t\tfunction setPad(e) {\n\t\t\tvar mpos = jscolor.getRelMousePos(e);\n\t\t\tvar x = mpos.x - THIS.pickerFace - THIS.pickerInset;\n\t\t\tvar y = mpos.y - THIS.pickerFace - THIS.pickerInset;\n\t\t\tswitch(modeID) {\n\t\t\t\tcase 0: THIS.fromHSV(x*(6/(jscolor.images.pad[0]-1)), 1 - y/(jscolor.images.pad[1]-1), null, leaveSld); break;\n\t\t\t\tcase 1: THIS.fromHSV(x*(6/(jscolor.images.pad[0]-1)), null, 1 - y/(jscolor.images.pad[1]-1), leaveSld); break;\n\t\t\t}\n\t\t}\n\n\n\t\tfunction setSld(e) {\n\t\t\tvar mpos = jscolor.getRelMousePos(e);\n\t\t\tvar y = mpos.y - THIS.pickerFace - THIS.pickerInset;\n\t\t\tswitch(modeID) {\n\t\t\t\tcase 0: THIS.fromHSV(null, null, 1 - y/(jscolor.images.sld[1]-1), leavePad); break;\n\t\t\t\tcase 1: THIS.fromHSV(null, 1 - y/(jscolor.images.sld[1]-1), null, leavePad); break;\n\t\t\t}\n\t\t}\n\n\n\t\tfunction dispatchImmediateChange() {\n\t\t\tif (THIS.onImmediateChange) {\n\t\t\t\tvar callback;\n\t\t\t\tif (typeof THIS.onImmediateChange === 'string') {\n\t\t\t\t\tcallback = new Function (THIS.onImmediateChange);\n\t\t\t\t} else {\n\t\t\t\t\tcallback = THIS.onImmediateChange;\n\t\t\t\t}\n\t\t\t\tcallback.call(THIS);\n\t\t\t}\n\t\t}\n\n\n\t\tvar THIS = this;\n\t\tvar modeID = this.pickerMode.toLowerCase()==='hvs' ? 1 : 0;\n\t\tvar abortBlur = false;\n\t\tvar\n\t\t\tvalueElement = jscolor.fetchElement(this.valueElement),\n\t\t\tstyleElement = jscolor.fetchElement(this.styleElement);\n\t\tvar\n\t\t\tholdPad = false,\n\t\t\tholdSld = false,\n\t\t\ttouchOffset = {};\n\t\tvar\n\t\t\tleaveValue = 1<<0,\n\t\t\tleaveStyle = 1<<1,\n\t\t\tleavePad = 1<<2,\n\t\t\tleaveSld = 1<<3;\n\n\t\t// target\n\t\tjscolor.addEvent(target, 'focus', function() {\n\t\t\tif(THIS.pickerOnfocus) { THIS.showPicker(); }\n\t\t});\n\t\tjscolor.addEvent(target, 'blur', function() {\n\t\t\tif(!abortBlur) {\n\t\t\t\twindow.setTimeout(function(){ abortBlur || blurTarget(); abortBlur=false; }, 0);\n\t\t\t} else {\n\t\t\t\tabortBlur = false;\n\t\t\t}\n\t\t});\n\n\t\t// valueElement\n\t\tif(valueElement) {\n\t\t\tvar updateField = function() {\n\t\t\t\tTHIS.fromString(valueElement.value, leaveValue);\n\t\t\t\tdispatchImmediateChange();\n\t\t\t};\n\t\t\tjscolor.addEvent(valueElement, 'keyup', updateField);\n\t\t\tjscolor.addEvent(valueElement, 'input', updateField);\n\t\t\tjscolor.addEvent(valueElement, 'blur', blurValue);\n\t\t\tvalueElement.setAttribute('autocomplete', 'off');\n\t\t}\n\n\t\t// styleElement\n\t\tif(styleElement) {\n\t\t\tstyleElement.jscStyle = {\n\t\t\t\tbackgroundImage : styleElement.style.backgroundImage,\n\t\t\t\tbackgroundColor : styleElement.style.backgroundColor,\n\t\t\t\tcolor : styleElement.style.color\n\t\t\t};\n\t\t}\n\n\t\t// require images\n\t\tswitch(modeID) {\n\t\t\tcase 0: jscolor.requireImage('hs.png'); break;\n\t\t\tcase 1: jscolor.requireImage('hv.png'); break;\n\t\t}\n\t\tjscolor.requireImage('cross.gif');\n\t\tjscolor.requireImage('arrow.gif');\n\n\t\tthis.importColor();\n\t}\n\n};\n\n\njscolor.install();\n","Amasty_Base/vendor/slick/slick.min.js":"/* phpcs:ignoreFile */\n/*\n     _ _      _       _\n ___| (_) ___| | __  (_)___\n/ __| | |/ __| |/ /  | / __|\n\\__ \\ | | (__|   < _ | \\__ \\\n|___/_|_|\\___|_|\\_(_)/ |___/\n                   |__/\n Version: 1.9.0\n  Author: Ken Wheeler\n Website: http://kenwheeler.github.io\n    Docs: http://kenwheeler.github.io/slick\n    Repo: http://github.com/kenwheeler/slick\n  Issues: http://github.com/kenwheeler/slick/issues\n */\n(function(i){\"use strict\";\"function\"==typeof define&&define.amd?define([\"jquery\"],i):\"undefined\"!=typeof exports?module.exports=i(require(\"jquery\")):i(jQuery)})(function(i){\"use strict\";var e=window.Slick||{};e=function(){function e(e,o){var s,n=this;n.defaults={accessibility:!0,adaptiveHeight:!1,appendArrows:i(e),appendDots:i(e),arrows:!0,asNavFor:null,prevArrow:'<button class=\"slick-prev\" aria-label=\"Previous\" type=\"button\">Previous</button>',nextArrow:'<button class=\"slick-next\" aria-label=\"Next\" type=\"button\">Next</button>',autoplay:!1,autoplaySpeed:3e3,centerMode:!1,centerPadding:\"50px\",cssEase:\"ease\",customPaging:function(e,t){return i('<button type=\"button\" />').text(t+1)},dots:!1,dotsClass:\"slick-dots\",draggable:!0,easing:\"linear\",edgeFriction:.35,fade:!1,focusOnSelect:!1,focusOnChange:!1,infinite:!0,initialSlide:0,lazyLoad:\"ondemand\",mobileFirst:!1,pauseOnHover:!0,pauseOnFocus:!0,pauseOnDotsHover:!1,respondTo:\"window\",responsive:null,rows:1,rtl:!1,slide:\"\",slidesPerRow:1,slidesToShow:1,slidesToScroll:1,speed:500,swipe:!0,swipeToSlide:!1,touchMove:!0,touchThreshold:5,useCSS:!0,useTransform:!0,variableWidth:!1,vertical:!1,verticalSwiping:!1,waitForAnimate:!0,zIndex:1e3},n.initials={animating:!1,dragging:!1,autoPlayTimer:null,currentDirection:0,currentLeft:null,currentSlide:0,direction:1,$dots:null,listWidth:null,listHeight:null,loadIndex:0,$nextArrow:null,$prevArrow:null,scrolling:!1,slideCount:null,slideWidth:null,$slideTrack:null,$slides:null,sliding:!1,slideOffset:0,swipeLeft:null,swiping:!1,$list:null,touchObject:{},transformsEnabled:!1,unslicked:!1},i.extend(n,n.initials),n.activeBreakpoint=null,n.animType=null,n.animProp=null,n.breakpoints=[],n.breakpointSettings=[],n.cssTransitions=!1,n.focussed=!1,n.interrupted=!1,n.hidden=\"hidden\",n.paused=!0,n.positionProp=null,n.respondTo=null,n.rowCount=1,n.shouldClick=!0,n.$slider=i(e),n.$slidesCache=null,n.transformType=null,n.transitionType=null,n.visibilityChange=\"visibilitychange\",n.windowWidth=0,n.windowTimer=null,s=i(e).data(\"slick\")||{},n.options=i.extend({},n.defaults,o,s),n.currentSlide=n.options.initialSlide,n.originalSettings=n.options,\"undefined\"!=typeof document.mozHidden?(n.hidden=\"mozHidden\",n.visibilityChange=\"mozvisibilitychange\"):\"undefined\"!=typeof document.webkitHidden&&(n.hidden=\"webkitHidden\",n.visibilityChange=\"webkitvisibilitychange\"),n.autoPlay=i.proxy(n.autoPlay,n),n.autoPlayClear=i.proxy(n.autoPlayClear,n),n.autoPlayIterator=i.proxy(n.autoPlayIterator,n),n.changeSlide=i.proxy(n.changeSlide,n),n.clickHandler=i.proxy(n.clickHandler,n),n.selectHandler=i.proxy(n.selectHandler,n),n.setPosition=i.proxy(n.setPosition,n),n.swipeHandler=i.proxy(n.swipeHandler,n),n.dragHandler=i.proxy(n.dragHandler,n),n.keyHandler=i.proxy(n.keyHandler,n),n.instanceUid=t++,n.htmlExpr=/^(?:\\s*(<[\\w\\W]+>)[^>]*)$/,n.registerBreakpoints(),n.init(!0)}var t=0;return e}(),e.prototype.activateADA=function(){var i=this;i.$slideTrack.find(\".slick-active\").attr({\"aria-hidden\":\"false\"}).find(\"a, input, button, select\").attr({tabindex:\"0\"})},e.prototype.addSlide=e.prototype.slickAdd=function(e,t,o){var s=this;if(\"boolean\"==typeof t)o=t,t=null;else if(t<0||t>=s.slideCount)return!1;s.unload(),\"number\"==typeof t?0===t&&0===s.$slides.length?i(e).appendTo(s.$slideTrack):o?i(e).insertBefore(s.$slides.eq(t)):i(e).insertAfter(s.$slides.eq(t)):o===!0?i(e).prependTo(s.$slideTrack):i(e).appendTo(s.$slideTrack),s.$slides=s.$slideTrack.children(this.options.slide),s.$slideTrack.children(this.options.slide).detach(),s.$slideTrack.append(s.$slides),s.$slides.each(function(e,t){i(t).attr(\"data-slick-index\",e)}),s.$slidesCache=s.$slides,s.reinit()},e.prototype.animateHeight=function(){var i=this;if(1===i.options.slidesToShow&&i.options.adaptiveHeight===!0&&i.options.vertical===!1){var e=i.$slides.eq(i.currentSlide).outerHeight(!0);i.$list.animate({height:e},i.options.speed)}},e.prototype.animateSlide=function(e,t){var o={},s=this;s.animateHeight(),s.options.rtl===!0&&s.options.vertical===!1&&(e=-e),s.transformsEnabled===!1?s.options.vertical===!1?s.$slideTrack.animate({left:e},s.options.speed,s.options.easing,t):s.$slideTrack.animate({top:e},s.options.speed,s.options.easing,t):s.cssTransitions===!1?(s.options.rtl===!0&&(s.currentLeft=-s.currentLeft),i({animStart:s.currentLeft}).animate({animStart:e},{duration:s.options.speed,easing:s.options.easing,step:function(i){i=Math.ceil(i),s.options.vertical===!1?(o[s.animType]=\"translate(\"+i+\"px, 0px)\",s.$slideTrack.css(o)):(o[s.animType]=\"translate(0px,\"+i+\"px)\",s.$slideTrack.css(o))},complete:function(){t&&t.call()}})):(s.applyTransition(),e=Math.ceil(e),s.options.vertical===!1?o[s.animType]=\"translate3d(\"+e+\"px, 0px, 0px)\":o[s.animType]=\"translate3d(0px,\"+e+\"px, 0px)\",s.$slideTrack.css(o),t&&setTimeout(function(){s.disableTransition(),t.call()},s.options.speed))},e.prototype.getNavTarget=function(){var e=this,t=e.options.asNavFor;return t&&null!==t&&(t=i(t).not(e.$slider)),t},e.prototype.asNavFor=function(e){var t=this,o=t.getNavTarget();null!==o&&\"object\"==typeof o&&o.each(function(){var t=i(this).slick(\"getSlick\");t.unslicked||t.slideHandler(e,!0)})},e.prototype.applyTransition=function(i){var e=this,t={};e.options.fade===!1?t[e.transitionType]=e.transformType+\" \"+e.options.speed+\"ms \"+e.options.cssEase:t[e.transitionType]=\"opacity \"+e.options.speed+\"ms \"+e.options.cssEase,e.options.fade===!1?e.$slideTrack.css(t):e.$slides.eq(i).css(t)},e.prototype.autoPlay=function(){var i=this;i.autoPlayClear(),i.slideCount>i.options.slidesToShow&&(i.autoPlayTimer=setInterval(i.autoPlayIterator,i.options.autoplaySpeed))},e.prototype.autoPlayClear=function(){var i=this;i.autoPlayTimer&&clearInterval(i.autoPlayTimer)},e.prototype.autoPlayIterator=function(){var i=this,e=i.currentSlide+i.options.slidesToScroll;i.paused||i.interrupted||i.focussed||(i.options.infinite===!1&&(1===i.direction&&i.currentSlide+1===i.slideCount-1?i.direction=0:0===i.direction&&(e=i.currentSlide-i.options.slidesToScroll,i.currentSlide-1===0&&(i.direction=1))),i.slideHandler(e))},e.prototype.buildArrows=function(){var e=this;e.options.arrows===!0&&(e.$prevArrow=i(e.options.prevArrow).addClass(\"slick-arrow\"),e.$nextArrow=i(e.options.nextArrow).addClass(\"slick-arrow\"),e.slideCount>e.options.slidesToShow?(e.$prevArrow.removeClass(\"slick-hidden\").removeAttr(\"aria-hidden tabindex\"),e.$nextArrow.removeClass(\"slick-hidden\").removeAttr(\"aria-hidden tabindex\"),e.htmlExpr.test(e.options.prevArrow)&&e.$prevArrow.prependTo(e.options.appendArrows),e.htmlExpr.test(e.options.nextArrow)&&e.$nextArrow.appendTo(e.options.appendArrows),e.options.infinite!==!0&&e.$prevArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\")):e.$prevArrow.add(e.$nextArrow).addClass(\"slick-hidden\").attr({\"aria-disabled\":\"true\",tabindex:\"-1\"}))},e.prototype.buildDots=function(){var e,t,o=this;if(o.options.dots===!0&&o.slideCount>o.options.slidesToShow){for(o.$slider.addClass(\"slick-dotted\"),t=i(\"<ul />\").addClass(o.options.dotsClass),e=0;e<=o.getDotCount();e+=1)t.append(i(\"<li />\").append(o.options.customPaging.call(this,o,e)));o.$dots=t.appendTo(o.options.appendDots),o.$dots.find(\"li\").first().addClass(\"slick-active\")}},e.prototype.buildOut=function(){var e=this;e.$slides=e.$slider.children(e.options.slide+\":not(.slick-cloned)\").addClass(\"slick-slide\"),e.slideCount=e.$slides.length,e.$slides.each(function(e,t){i(t).attr(\"data-slick-index\",e).data(\"originalStyling\",i(t).attr(\"style\")||\"\")}),e.$slider.addClass(\"slick-slider\"),e.$slideTrack=0===e.slideCount?i('<div class=\"slick-track\"/>').appendTo(e.$slider):e.$slides.wrapAll('<div class=\"slick-track\"/>').parent(),e.$list=e.$slideTrack.wrap('<div class=\"slick-list\"/>').parent(),e.$slideTrack.css(\"opacity\",0),e.options.centerMode!==!0&&e.options.swipeToSlide!==!0||(e.options.slidesToScroll=1),i(\"img[data-lazy]\",e.$slider).not(\"[src]\").addClass(\"slick-loading\"),e.setupInfinite(),e.buildArrows(),e.buildDots(),e.updateDots(),e.setSlideClasses(\"number\"==typeof e.currentSlide?e.currentSlide:0),e.options.draggable===!0&&e.$list.addClass(\"draggable\")},e.prototype.buildRows=function(){var i,e,t,o,s,n,r,l=this;if(o=document.createDocumentFragment(),n=l.$slider.children(),l.options.rows>0){for(r=l.options.slidesPerRow*l.options.rows,s=Math.ceil(n.length/r),i=0;i<s;i++){var d=document.createElement(\"div\");for(e=0;e<l.options.rows;e++){var a=document.createElement(\"div\");for(t=0;t<l.options.slidesPerRow;t++){var c=i*r+(e*l.options.slidesPerRow+t);n.get(c)&&a.appendChild(n.get(c))}d.appendChild(a)}o.appendChild(d)}l.$slider.empty().append(o),l.$slider.children().children().children().css({width:100/l.options.slidesPerRow+\"%\",display:\"inline-block\"})}},e.prototype.checkResponsive=function(e,t){var o,s,n,r=this,l=!1,d=r.$slider.width(),a=window.innerWidth||i(window).width();if(\"window\"===r.respondTo?n=a:\"slider\"===r.respondTo?n=d:\"min\"===r.respondTo&&(n=Math.min(a,d)),r.options.responsive&&r.options.responsive.length&&null!==r.options.responsive){s=null;for(o in r.breakpoints)r.breakpoints.hasOwnProperty(o)&&(r.originalSettings.mobileFirst===!1?n<r.breakpoints[o]&&(s=r.breakpoints[o]):n>r.breakpoints[o]&&(s=r.breakpoints[o]));null!==s?null!==r.activeBreakpoint?(s!==r.activeBreakpoint||t)&&(r.activeBreakpoint=s,\"unslick\"===r.breakpointSettings[s]?r.unslick(s):(r.options=i.extend({},r.originalSettings,r.breakpointSettings[s]),e===!0&&(r.currentSlide=r.options.initialSlide),r.refresh(e)),l=s):(r.activeBreakpoint=s,\"unslick\"===r.breakpointSettings[s]?r.unslick(s):(r.options=i.extend({},r.originalSettings,r.breakpointSettings[s]),e===!0&&(r.currentSlide=r.options.initialSlide),r.refresh(e)),l=s):null!==r.activeBreakpoint&&(r.activeBreakpoint=null,r.options=r.originalSettings,e===!0&&(r.currentSlide=r.options.initialSlide),r.refresh(e),l=s),e||l===!1||r.$slider.trigger(\"breakpoint\",[r,l])}},e.prototype.changeSlide=function(e,t){var o,s,n,r=this,l=i(e.currentTarget);switch(l.is(\"a\")&&e.preventDefault(),l.is(\"li\")||(l=l.closest(\"li\")),n=r.slideCount%r.options.slidesToScroll!==0,o=n?0:(r.slideCount-r.currentSlide)%r.options.slidesToScroll,e.data.message){case\"previous\":s=0===o?r.options.slidesToScroll:r.options.slidesToShow-o,r.slideCount>r.options.slidesToShow&&r.slideHandler(r.currentSlide-s,!1,t);break;case\"next\":s=0===o?r.options.slidesToScroll:o,r.slideCount>r.options.slidesToShow&&r.slideHandler(r.currentSlide+s,!1,t);break;case\"index\":var d=0===e.data.index?0:e.data.index||l.index()*r.options.slidesToScroll;r.slideHandler(r.checkNavigable(d),!1,t),l.children().trigger(\"focus\");break;default:return}},e.prototype.checkNavigable=function(i){var e,t,o=this;if(e=o.getNavigableIndexes(),t=0,i>e[e.length-1])i=e[e.length-1];else for(var s in e){if(i<e[s]){i=t;break}t=e[s]}return i},e.prototype.cleanUpEvents=function(){var e=this;e.options.dots&&null!==e.$dots&&(i(\"li\",e.$dots).off(\"click.slick\",e.changeSlide).off(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)).off(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1)),e.options.accessibility===!0&&e.$dots.off(\"keydown.slick\",e.keyHandler)),e.$slider.off(\"focus.slick blur.slick\"),e.options.arrows===!0&&e.slideCount>e.options.slidesToShow&&(e.$prevArrow&&e.$prevArrow.off(\"click.slick\",e.changeSlide),e.$nextArrow&&e.$nextArrow.off(\"click.slick\",e.changeSlide),e.options.accessibility===!0&&(e.$prevArrow&&e.$prevArrow.off(\"keydown.slick\",e.keyHandler),e.$nextArrow&&e.$nextArrow.off(\"keydown.slick\",e.keyHandler))),e.$list.off(\"touchstart.slick mousedown.slick\",e.swipeHandler),e.$list.off(\"touchmove.slick mousemove.slick\",e.swipeHandler),e.$list.off(\"touchend.slick mouseup.slick\",e.swipeHandler),e.$list.off(\"touchcancel.slick mouseleave.slick\",e.swipeHandler),e.$list.off(\"click.slick\",e.clickHandler),i(document).off(e.visibilityChange,e.visibility),e.cleanUpSlideEvents(),e.options.accessibility===!0&&e.$list.off(\"keydown.slick\",e.keyHandler),e.options.focusOnSelect===!0&&i(e.$slideTrack).children().off(\"click.slick\",e.selectHandler),i(window).off(\"orientationchange.slick.slick-\"+e.instanceUid,e.orientationChange),i(window).off(\"resize.slick.slick-\"+e.instanceUid,e.resize),i(\"[draggable!=true]\",e.$slideTrack).off(\"dragstart\",e.preventDefault),i(window).off(\"load.slick.slick-\"+e.instanceUid,e.setPosition)},e.prototype.cleanUpSlideEvents=function(){var e=this;e.$list.off(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)),e.$list.off(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1))},e.prototype.cleanUpRows=function(){var i,e=this;e.options.rows>0&&(i=e.$slides.children().children(),i.removeAttr(\"style\"),e.$slider.empty().append(i))},e.prototype.clickHandler=function(i){var e=this;e.shouldClick===!1&&(i.stopImmediatePropagation(),i.stopPropagation(),i.preventDefault())},e.prototype.destroy=function(e){var t=this;t.autoPlayClear(),t.touchObject={},t.cleanUpEvents(),i(\".slick-cloned\",t.$slider).detach(),t.$dots&&t.$dots.remove(),t.$prevArrow&&t.$prevArrow.length&&(t.$prevArrow.removeClass(\"slick-disabled slick-arrow slick-hidden\").removeAttr(\"aria-hidden aria-disabled tabindex\").css(\"display\",\"\"),t.htmlExpr.test(t.options.prevArrow)&&t.$prevArrow.remove()),t.$nextArrow&&t.$nextArrow.length&&(t.$nextArrow.removeClass(\"slick-disabled slick-arrow slick-hidden\").removeAttr(\"aria-hidden aria-disabled tabindex\").css(\"display\",\"\"),t.htmlExpr.test(t.options.nextArrow)&&t.$nextArrow.remove()),t.$slides&&(t.$slides.removeClass(\"slick-slide slick-active slick-center slick-visible slick-current\").removeAttr(\"aria-hidden\").removeAttr(\"data-slick-index\").each(function(){i(this).attr(\"style\",i(this).data(\"originalStyling\"))}),t.$slideTrack.children(this.options.slide).detach(),t.$slideTrack.detach(),t.$list.detach(),t.$slider.append(t.$slides)),t.cleanUpRows(),t.$slider.removeClass(\"slick-slider\"),t.$slider.removeClass(\"slick-initialized\"),t.$slider.removeClass(\"slick-dotted\"),t.unslicked=!0,e||t.$slider.trigger(\"destroy\",[t])},e.prototype.disableTransition=function(i){var e=this,t={};t[e.transitionType]=\"\",e.options.fade===!1?e.$slideTrack.css(t):e.$slides.eq(i).css(t)},e.prototype.fadeSlide=function(i,e){var t=this;t.cssTransitions===!1?(t.$slides.eq(i).css({zIndex:t.options.zIndex}),t.$slides.eq(i).animate({opacity:1},t.options.speed,t.options.easing,e)):(t.applyTransition(i),t.$slides.eq(i).css({opacity:1,zIndex:t.options.zIndex}),e&&setTimeout(function(){t.disableTransition(i),e.call()},t.options.speed))},e.prototype.fadeSlideOut=function(i){var e=this;e.cssTransitions===!1?e.$slides.eq(i).animate({opacity:0,zIndex:e.options.zIndex-2},e.options.speed,e.options.easing):(e.applyTransition(i),e.$slides.eq(i).css({opacity:0,zIndex:e.options.zIndex-2}))},e.prototype.filterSlides=e.prototype.slickFilter=function(i){var e=this;null!==i&&(e.$slidesCache=e.$slides,e.unload(),e.$slideTrack.children(this.options.slide).detach(),e.$slidesCache.filter(i).appendTo(e.$slideTrack),e.reinit())},e.prototype.focusHandler=function(){var e=this;e.$slider.off(\"focus.slick blur.slick\").on(\"focus.slick\",\"*\",function(t){var o=i(this);setTimeout(function(){e.options.pauseOnFocus&&o.is(\":focus\")&&(e.focussed=!0,e.autoPlay())},0)}).on(\"blur.slick\",\"*\",function(t){i(this);e.options.pauseOnFocus&&(e.focussed=!1,e.autoPlay())})},e.prototype.getCurrent=e.prototype.slickCurrentSlide=function(){var i=this;return i.currentSlide},e.prototype.getDotCount=function(){var i=this,e=0,t=0,o=0;if(i.options.infinite===!0)if(i.slideCount<=i.options.slidesToShow)++o;else for(;e<i.slideCount;)++o,e=t+i.options.slidesToScroll,t+=i.options.slidesToScroll<=i.options.slidesToShow?i.options.slidesToScroll:i.options.slidesToShow;else if(i.options.centerMode===!0)o=i.slideCount;else if(i.options.asNavFor)for(;e<i.slideCount;)++o,e=t+i.options.slidesToScroll,t+=i.options.slidesToScroll<=i.options.slidesToShow?i.options.slidesToScroll:i.options.slidesToShow;else o=1+Math.ceil((i.slideCount-i.options.slidesToShow)/i.options.slidesToScroll);return o-1},e.prototype.getLeft=function(i){var e,t,o,s,n=this,r=0;return n.slideOffset=0,t=n.$slides.first().outerHeight(!0),n.options.infinite===!0?(n.slideCount>n.options.slidesToShow&&(n.slideOffset=n.slideWidth*n.options.slidesToShow*-1,s=-1,n.options.vertical===!0&&n.options.centerMode===!0&&(2===n.options.slidesToShow?s=-1.5:1===n.options.slidesToShow&&(s=-2)),r=t*n.options.slidesToShow*s),n.slideCount%n.options.slidesToScroll!==0&&i+n.options.slidesToScroll>n.slideCount&&n.slideCount>n.options.slidesToShow&&(i>n.slideCount?(n.slideOffset=(n.options.slidesToShow-(i-n.slideCount))*n.slideWidth*-1,r=(n.options.slidesToShow-(i-n.slideCount))*t*-1):(n.slideOffset=n.slideCount%n.options.slidesToScroll*n.slideWidth*-1,r=n.slideCount%n.options.slidesToScroll*t*-1))):i+n.options.slidesToShow>n.slideCount&&(n.slideOffset=(i+n.options.slidesToShow-n.slideCount)*n.slideWidth,r=(i+n.options.slidesToShow-n.slideCount)*t),n.slideCount<=n.options.slidesToShow&&(n.slideOffset=0,r=0),n.options.centerMode===!0&&n.slideCount<=n.options.slidesToShow?n.slideOffset=n.slideWidth*Math.floor(n.options.slidesToShow)/2-n.slideWidth*n.slideCount/2:n.options.centerMode===!0&&n.options.infinite===!0?n.slideOffset+=n.slideWidth*Math.floor(n.options.slidesToShow/2)-n.slideWidth:n.options.centerMode===!0&&(n.slideOffset=0,n.slideOffset+=n.slideWidth*Math.floor(n.options.slidesToShow/2)),e=n.options.vertical===!1?i*n.slideWidth*-1+n.slideOffset:i*t*-1+r,n.options.variableWidth===!0&&(o=n.slideCount<=n.options.slidesToShow||n.options.infinite===!1?n.$slideTrack.children(\".slick-slide\").eq(i):n.$slideTrack.children(\".slick-slide\").eq(i+n.options.slidesToShow),e=n.options.rtl===!0?o[0]?(n.$slideTrack.width()-o[0].offsetLeft-o.width())*-1:0:o[0]?o[0].offsetLeft*-1:0,n.options.centerMode===!0&&(o=n.slideCount<=n.options.slidesToShow||n.options.infinite===!1?n.$slideTrack.children(\".slick-slide\").eq(i):n.$slideTrack.children(\".slick-slide\").eq(i+n.options.slidesToShow+1),e=n.options.rtl===!0?o[0]?(n.$slideTrack.width()-o[0].offsetLeft-o.width())*-1:0:o[0]?o[0].offsetLeft*-1:0,e+=(n.$list.width()-o.outerWidth())/2)),e},e.prototype.getOption=e.prototype.slickGetOption=function(i){var e=this;return e.options[i]},e.prototype.getNavigableIndexes=function(){var i,e=this,t=0,o=0,s=[];for(e.options.infinite===!1?i=e.slideCount:(t=e.options.slidesToScroll*-1,o=e.options.slidesToScroll*-1,i=2*e.slideCount);t<i;)s.push(t),t=o+e.options.slidesToScroll,o+=e.options.slidesToScroll<=e.options.slidesToShow?e.options.slidesToScroll:e.options.slidesToShow;return s},e.prototype.getSlick=function(){return this},e.prototype.getSlideCount=function(){var e,t,o,s,n=this;return s=n.options.centerMode===!0?Math.floor(n.$list.width()/2):0,o=n.swipeLeft*-1+s,n.options.swipeToSlide===!0?(n.$slideTrack.find(\".slick-slide\").each(function(e,s){var r,l,d;if(r=i(s).outerWidth(),l=s.offsetLeft,n.options.centerMode!==!0&&(l+=r/2),d=l+r,o<d)return t=s,!1}),e=Math.abs(i(t).attr(\"data-slick-index\")-n.currentSlide)||1):n.options.slidesToScroll},e.prototype.goTo=e.prototype.slickGoTo=function(i,e){var t=this;t.changeSlide({data:{message:\"index\",index:parseInt(i)}},e)},e.prototype.init=function(e){var t=this;i(t.$slider).hasClass(\"slick-initialized\")||(i(t.$slider).addClass(\"slick-initialized\"),t.buildRows(),t.buildOut(),t.setProps(),t.startLoad(),t.loadSlider(),t.initializeEvents(),t.updateArrows(),t.updateDots(),t.checkResponsive(!0),t.focusHandler()),e&&t.$slider.trigger(\"init\",[t]),t.options.accessibility===!0&&t.initADA(),t.options.autoplay&&(t.paused=!1,t.autoPlay())},e.prototype.initADA=function(){var e=this,t=Math.ceil(e.slideCount/e.options.slidesToShow),o=e.getNavigableIndexes().filter(function(i){return i>=0&&i<e.slideCount});e.$slides.add(e.$slideTrack.find(\".slick-cloned\")).attr({\"aria-hidden\":\"true\",tabindex:\"-1\"}).find(\"a, input, button, select\").attr({tabindex:\"-1\"}),null!==e.$dots&&(e.$slides.not(e.$slideTrack.find(\".slick-cloned\")).each(function(t){var s=o.indexOf(t);if(i(this).attr({role:\"tabpanel\",id:\"slick-slide\"+e.instanceUid+t,tabindex:-1}),s!==-1){var n=\"slick-slide-control\"+e.instanceUid+s;i(\"#\"+n).length&&i(this).attr({\"aria-describedby\":n})}}),e.$dots.attr(\"role\",\"tablist\").find(\"li\").each(function(s){var n=o[s];i(this).attr({role:\"presentation\"}),i(this).find(\"button\").first().attr({role:\"tab\",id:\"slick-slide-control\"+e.instanceUid+s,\"aria-controls\":\"slick-slide\"+e.instanceUid+n,\"aria-label\":s+1+\" of \"+t,\"aria-selected\":null,tabindex:\"-1\"})}).eq(e.currentSlide).find(\"button\").attr({\"aria-selected\":\"true\",tabindex:\"0\"}).end());for(var s=e.currentSlide,n=s+e.options.slidesToShow;s<n;s++)e.options.focusOnChange?e.$slides.eq(s).attr({tabindex:\"0\"}):e.$slides.eq(s).removeAttr(\"tabindex\");e.activateADA()},e.prototype.initArrowEvents=function(){var i=this;i.options.arrows===!0&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.off(\"click.slick\").on(\"click.slick\",{message:\"previous\"},i.changeSlide),i.$nextArrow.off(\"click.slick\").on(\"click.slick\",{message:\"next\"},i.changeSlide),i.options.accessibility===!0&&(i.$prevArrow.on(\"keydown.slick\",i.keyHandler),i.$nextArrow.on(\"keydown.slick\",i.keyHandler)))},e.prototype.initDotEvents=function(){var e=this;e.options.dots===!0&&e.slideCount>e.options.slidesToShow&&(i(\"li\",e.$dots).on(\"click.slick\",{message:\"index\"},e.changeSlide),e.options.accessibility===!0&&e.$dots.on(\"keydown.slick\",e.keyHandler)),e.options.dots===!0&&e.options.pauseOnDotsHover===!0&&e.slideCount>e.options.slidesToShow&&i(\"li\",e.$dots).on(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)).on(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1))},e.prototype.initSlideEvents=function(){var e=this;e.options.pauseOnHover&&(e.$list.on(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)),e.$list.on(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1)))},e.prototype.initializeEvents=function(){var e=this;e.initArrowEvents(),e.initDotEvents(),e.initSlideEvents(),e.$list.on(\"touchstart.slick mousedown.slick\",{action:\"start\"},e.swipeHandler),e.$list.on(\"touchmove.slick mousemove.slick\",{action:\"move\"},e.swipeHandler),e.$list.on(\"touchend.slick mouseup.slick\",{action:\"end\"},e.swipeHandler),e.$list.on(\"touchcancel.slick mouseleave.slick\",{action:\"end\"},e.swipeHandler),e.$list.on(\"click.slick\",e.clickHandler),i(document).on(e.visibilityChange,i.proxy(e.visibility,e)),e.options.accessibility===!0&&e.$list.on(\"keydown.slick\",e.keyHandler),e.options.focusOnSelect===!0&&i(e.$slideTrack).children().on(\"click.slick\",e.selectHandler),i(window).on(\"orientationchange.slick.slick-\"+e.instanceUid,i.proxy(e.orientationChange,e)),i(window).on(\"resize.slick.slick-\"+e.instanceUid,i.proxy(e.resize,e)),i(\"[draggable!=true]\",e.$slideTrack).on(\"dragstart\",e.preventDefault),i(window).on(\"load.slick.slick-\"+e.instanceUid,e.setPosition),i(e.setPosition)},e.prototype.initUI=function(){var i=this;i.options.arrows===!0&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.show(),i.$nextArrow.show()),i.options.dots===!0&&i.slideCount>i.options.slidesToShow&&i.$dots.show()},e.prototype.keyHandler=function(i){var e=this;i.target.tagName.match(\"TEXTAREA|INPUT|SELECT\")||(37===i.keyCode&&e.options.accessibility===!0?e.changeSlide({data:{message:e.options.rtl===!0?\"next\":\"previous\"}}):39===i.keyCode&&e.options.accessibility===!0&&e.changeSlide({data:{message:e.options.rtl===!0?\"previous\":\"next\"}}))},e.prototype.lazyLoad=function(){function e(e){i(\"img[data-lazy]\",e).each(function(){var e=i(this),t=i(this).attr(\"data-lazy\"),o=i(this).attr(\"data-srcset\"),s=i(this).attr(\"data-sizes\")||r.$slider.attr(\"data-sizes\"),n=document.createElement(\"img\");n.onload=function(){e.animate({opacity:0},100,function(){o&&(e.attr(\"srcset\",o),s&&e.attr(\"sizes\",s)),e.attr(\"src\",t).animate({opacity:1},200,function(){e.removeAttr(\"data-lazy data-srcset data-sizes\").removeClass(\"slick-loading\")}),r.$slider.trigger(\"lazyLoaded\",[r,e,t])})},n.onerror=function(){e.removeAttr(\"data-lazy\").removeClass(\"slick-loading\").addClass(\"slick-lazyload-error\"),r.$slider.trigger(\"lazyLoadError\",[r,e,t])},n.src=t})}var t,o,s,n,r=this;if(r.options.centerMode===!0?r.options.infinite===!0?(s=r.currentSlide+(r.options.slidesToShow/2+1),n=s+r.options.slidesToShow+2):(s=Math.max(0,r.currentSlide-(r.options.slidesToShow/2+1)),n=2+(r.options.slidesToShow/2+1)+r.currentSlide):(s=r.options.infinite?r.options.slidesToShow+r.currentSlide:r.currentSlide,n=Math.ceil(s+r.options.slidesToShow),r.options.fade===!0&&(s>0&&s--,n<=r.slideCount&&n++)),t=r.$slider.find(\".slick-slide\").slice(s,n),\"anticipated\"===r.options.lazyLoad)for(var l=s-1,d=n,a=r.$slider.find(\".slick-slide\"),c=0;c<r.options.slidesToScroll;c++)l<0&&(l=r.slideCount-1),t=t.add(a.eq(l)),t=t.add(a.eq(d)),l--,d++;e(t),r.slideCount<=r.options.slidesToShow?(o=r.$slider.find(\".slick-slide\"),e(o)):r.currentSlide>=r.slideCount-r.options.slidesToShow?(o=r.$slider.find(\".slick-cloned\").slice(0,r.options.slidesToShow),e(o)):0===r.currentSlide&&(o=r.$slider.find(\".slick-cloned\").slice(r.options.slidesToShow*-1),e(o))},e.prototype.loadSlider=function(){var i=this;i.setPosition(),i.$slideTrack.css({opacity:1}),i.$slider.removeClass(\"slick-loading\"),i.initUI(),\"progressive\"===i.options.lazyLoad&&i.progressiveLazyLoad()},e.prototype.next=e.prototype.slickNext=function(){var i=this;i.changeSlide({data:{message:\"next\"}})},e.prototype.orientationChange=function(){var i=this;i.checkResponsive(),i.setPosition()},e.prototype.pause=e.prototype.slickPause=function(){var i=this;i.autoPlayClear(),i.paused=!0},e.prototype.play=e.prototype.slickPlay=function(){var i=this;i.autoPlay(),i.options.autoplay=!0,i.paused=!1,i.focussed=!1,i.interrupted=!1},e.prototype.postSlide=function(e){var t=this;if(!t.unslicked&&(t.$slider.trigger(\"afterChange\",[t,e]),t.animating=!1,t.slideCount>t.options.slidesToShow&&t.setPosition(),t.swipeLeft=null,t.options.autoplay&&t.autoPlay(),t.options.accessibility===!0&&(t.initADA(),t.options.focusOnChange))){var o=i(t.$slides.get(t.currentSlide));o.attr(\"tabindex\",0).focus()}},e.prototype.prev=e.prototype.slickPrev=function(){var i=this;i.changeSlide({data:{message:\"previous\"}})},e.prototype.preventDefault=function(i){i.preventDefault()},e.prototype.progressiveLazyLoad=function(e){e=e||1;var t,o,s,n,r,l=this,d=i(\"img[data-lazy]\",l.$slider);d.length?(t=d.first(),o=t.attr(\"data-lazy\"),s=t.attr(\"data-srcset\"),n=t.attr(\"data-sizes\")||l.$slider.attr(\"data-sizes\"),r=document.createElement(\"img\"),r.onload=function(){s&&(t.attr(\"srcset\",s),n&&t.attr(\"sizes\",n)),t.attr(\"src\",o).removeAttr(\"data-lazy data-srcset data-sizes\").removeClass(\"slick-loading\"),l.options.adaptiveHeight===!0&&l.setPosition(),l.$slider.trigger(\"lazyLoaded\",[l,t,o]),l.progressiveLazyLoad()},r.onerror=function(){e<3?setTimeout(function(){l.progressiveLazyLoad(e+1)},500):(t.removeAttr(\"data-lazy\").removeClass(\"slick-loading\").addClass(\"slick-lazyload-error\"),l.$slider.trigger(\"lazyLoadError\",[l,t,o]),l.progressiveLazyLoad())},r.src=o):l.$slider.trigger(\"allImagesLoaded\",[l])},e.prototype.refresh=function(e){var t,o,s=this;o=s.slideCount-s.options.slidesToShow,!s.options.infinite&&s.currentSlide>o&&(s.currentSlide=o),s.slideCount<=s.options.slidesToShow&&(s.currentSlide=0),t=s.currentSlide,s.destroy(!0),i.extend(s,s.initials,{currentSlide:t}),s.init(),e||s.changeSlide({data:{message:\"index\",index:t}},!1)},e.prototype.registerBreakpoints=function(){var e,t,o,s=this,n=s.options.responsive||null;if(\"array\"===i.type(n)&&n.length){s.respondTo=s.options.respondTo||\"window\";for(e in n)if(o=s.breakpoints.length-1,n.hasOwnProperty(e)){for(t=n[e].breakpoint;o>=0;)s.breakpoints[o]&&s.breakpoints[o]===t&&s.breakpoints.splice(o,1),o--;s.breakpoints.push(t),s.breakpointSettings[t]=n[e].settings}s.breakpoints.sort(function(i,e){return s.options.mobileFirst?i-e:e-i})}},e.prototype.reinit=function(){var e=this;e.$slides=e.$slideTrack.children(e.options.slide).addClass(\"slick-slide\"),e.slideCount=e.$slides.length,e.currentSlide>=e.slideCount&&0!==e.currentSlide&&(e.currentSlide=e.currentSlide-e.options.slidesToScroll),e.slideCount<=e.options.slidesToShow&&(e.currentSlide=0),e.registerBreakpoints(),e.setProps(),e.setupInfinite(),e.buildArrows(),e.updateArrows(),e.initArrowEvents(),e.buildDots(),e.updateDots(),e.initDotEvents(),e.cleanUpSlideEvents(),e.initSlideEvents(),e.checkResponsive(!1,!0),e.options.focusOnSelect===!0&&i(e.$slideTrack).children().on(\"click.slick\",e.selectHandler),e.setSlideClasses(\"number\"==typeof e.currentSlide?e.currentSlide:0),e.setPosition(),e.focusHandler(),e.paused=!e.options.autoplay,e.autoPlay(),e.$slider.trigger(\"reInit\",[e])},e.prototype.resize=function(){var e=this;i(window).width()!==e.windowWidth&&(clearTimeout(e.windowDelay),e.windowDelay=window.setTimeout(function(){e.windowWidth=i(window).width(),e.checkResponsive(),e.unslicked||e.setPosition()},50))},e.prototype.removeSlide=e.prototype.slickRemove=function(i,e,t){var o=this;return\"boolean\"==typeof i?(e=i,i=e===!0?0:o.slideCount-1):i=e===!0?--i:i,!(o.slideCount<1||i<0||i>o.slideCount-1)&&(o.unload(),t===!0?o.$slideTrack.children().remove():o.$slideTrack.children(this.options.slide).eq(i).remove(),o.$slides=o.$slideTrack.children(this.options.slide),o.$slideTrack.children(this.options.slide).detach(),o.$slideTrack.append(o.$slides),o.$slidesCache=o.$slides,void o.reinit())},e.prototype.setCSS=function(i){var e,t,o=this,s={};o.options.rtl===!0&&(i=-i),e=\"left\"==o.positionProp?Math.ceil(i)+\"px\":\"0px\",t=\"top\"==o.positionProp?Math.ceil(i)+\"px\":\"0px\",s[o.positionProp]=i,o.transformsEnabled===!1?o.$slideTrack.css(s):(s={},o.cssTransitions===!1?(s[o.animType]=\"translate(\"+e+\", \"+t+\")\",o.$slideTrack.css(s)):(s[o.animType]=\"translate3d(\"+e+\", \"+t+\", 0px)\",o.$slideTrack.css(s)))},e.prototype.setDimensions=function(){var i=this;i.options.vertical===!1?i.options.centerMode===!0&&i.$list.css({padding:\"0px \"+i.options.centerPadding}):(i.$list.height(i.$slides.first().outerHeight(!0)*i.options.slidesToShow),i.options.centerMode===!0&&i.$list.css({padding:i.options.centerPadding+\" 0px\"})),i.listWidth=i.$list.width(),i.listHeight=i.$list.height(),i.options.vertical===!1&&i.options.variableWidth===!1?(i.slideWidth=Math.ceil(i.listWidth/i.options.slidesToShow),i.$slideTrack.width(Math.ceil(i.slideWidth*i.$slideTrack.children(\".slick-slide\").length))):i.options.variableWidth===!0?i.$slideTrack.width(5e3*i.slideCount):(i.slideWidth=Math.ceil(i.listWidth),i.$slideTrack.height(Math.ceil(i.$slides.first().outerHeight(!0)*i.$slideTrack.children(\".slick-slide\").length)));var e=i.$slides.first().outerWidth(!0)-i.$slides.first().width();i.options.variableWidth===!1&&i.$slideTrack.children(\".slick-slide\").width(i.slideWidth-e)},e.prototype.setFade=function(){var e,t=this;t.$slides.each(function(o,s){e=t.slideWidth*o*-1,t.options.rtl===!0?i(s).css({position:\"relative\",right:e,top:0,zIndex:t.options.zIndex-2,opacity:0}):i(s).css({position:\"relative\",left:e,top:0,zIndex:t.options.zIndex-2,opacity:0})}),t.$slides.eq(t.currentSlide).css({zIndex:t.options.zIndex-1,opacity:1})},e.prototype.setHeight=function(){var i=this;if(1===i.options.slidesToShow&&i.options.adaptiveHeight===!0&&i.options.vertical===!1){var e=i.$slides.eq(i.currentSlide).outerHeight(!0);i.$list.css(\"height\",e)}},e.prototype.setOption=e.prototype.slickSetOption=function(){var e,t,o,s,n,r=this,l=!1;if(\"object\"===i.type(arguments[0])?(o=arguments[0],l=arguments[1],n=\"multiple\"):\"string\"===i.type(arguments[0])&&(o=arguments[0],s=arguments[1],l=arguments[2],\"responsive\"===arguments[0]&&\"array\"===i.type(arguments[1])?n=\"responsive\":\"undefined\"!=typeof arguments[1]&&(n=\"single\")),\"single\"===n)r.options[o]=s;else if(\"multiple\"===n)i.each(o,function(i,e){r.options[i]=e});else if(\"responsive\"===n)for(t in s)if(\"array\"!==i.type(r.options.responsive))r.options.responsive=[s[t]];else{for(e=r.options.responsive.length-1;e>=0;)r.options.responsive[e].breakpoint===s[t].breakpoint&&r.options.responsive.splice(e,1),e--;r.options.responsive.push(s[t])}l&&(r.unload(),r.reinit())},e.prototype.setPosition=function(){var i=this;i.setDimensions(),i.setHeight(),i.options.fade===!1?i.setCSS(i.getLeft(i.currentSlide)):i.setFade(),i.$slider.trigger(\"setPosition\",[i])},e.prototype.setProps=function(){var i=this,e=document.body.style;i.positionProp=i.options.vertical===!0?\"top\":\"left\",\n    \"top\"===i.positionProp?i.$slider.addClass(\"slick-vertical\"):i.$slider.removeClass(\"slick-vertical\"),void 0===e.WebkitTransition&&void 0===e.MozTransition&&void 0===e.msTransition||i.options.useCSS===!0&&(i.cssTransitions=!0),i.options.fade&&(\"number\"==typeof i.options.zIndex?i.options.zIndex<3&&(i.options.zIndex=3):i.options.zIndex=i.defaults.zIndex),void 0!==e.OTransform&&(i.animType=\"OTransform\",i.transformType=\"-o-transform\",i.transitionType=\"OTransition\",void 0===e.perspectiveProperty&&void 0===e.webkitPerspective&&(i.animType=!1)),void 0!==e.MozTransform&&(i.animType=\"MozTransform\",i.transformType=\"-moz-transform\",i.transitionType=\"MozTransition\",void 0===e.perspectiveProperty&&void 0===e.MozPerspective&&(i.animType=!1)),void 0!==e.webkitTransform&&(i.animType=\"webkitTransform\",i.transformType=\"-webkit-transform\",i.transitionType=\"webkitTransition\",void 0===e.perspectiveProperty&&void 0===e.webkitPerspective&&(i.animType=!1)),void 0!==e.msTransform&&(i.animType=\"msTransform\",i.transformType=\"-ms-transform\",i.transitionType=\"msTransition\",void 0===e.msTransform&&(i.animType=!1)),void 0!==e.transform&&i.animType!==!1&&(i.animType=\"transform\",i.transformType=\"transform\",i.transitionType=\"transition\"),i.transformsEnabled=i.options.useTransform&&null!==i.animType&&i.animType!==!1},e.prototype.setSlideClasses=function(i){var e,t,o,s,n=this;if(t=n.$slider.find(\".slick-slide\").removeClass(\"slick-active slick-center slick-current\").attr(\"aria-hidden\",\"true\"),n.$slides.eq(i).addClass(\"slick-current\"),n.options.centerMode===!0){var r=n.options.slidesToShow%2===0?1:0;e=Math.floor(n.options.slidesToShow/2),n.options.infinite===!0&&(i>=e&&i<=n.slideCount-1-e?n.$slides.slice(i-e+r,i+e+1).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):(o=n.options.slidesToShow+i,t.slice(o-e+1+r,o+e+2).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\")),0===i?t.eq(t.length-1-n.options.slidesToShow).addClass(\"slick-center\"):i===n.slideCount-1&&t.eq(n.options.slidesToShow).addClass(\"slick-center\")),n.$slides.eq(i).addClass(\"slick-center\")}else i>=0&&i<=n.slideCount-n.options.slidesToShow?n.$slides.slice(i,i+n.options.slidesToShow).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):t.length<=n.options.slidesToShow?t.addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):(s=n.slideCount%n.options.slidesToShow,o=n.options.infinite===!0?n.options.slidesToShow+i:i,n.options.slidesToShow==n.options.slidesToScroll&&n.slideCount-i<n.options.slidesToShow?t.slice(o-(n.options.slidesToShow-s),o+s).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):t.slice(o,o+n.options.slidesToShow).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"));\"ondemand\"!==n.options.lazyLoad&&\"anticipated\"!==n.options.lazyLoad||n.lazyLoad()},e.prototype.setupInfinite=function(){var e,t,o,s=this;if(s.options.fade===!0&&(s.options.centerMode=!1),s.options.infinite===!0&&s.options.fade===!1&&(t=null,s.slideCount>s.options.slidesToShow)){for(o=s.options.centerMode===!0?s.options.slidesToShow+1:s.options.slidesToShow,e=s.slideCount;e>s.slideCount-o;e-=1)t=e-1,i(s.$slides[t]).clone(!0).attr(\"id\",\"\").attr(\"data-slick-index\",t-s.slideCount).prependTo(s.$slideTrack).addClass(\"slick-cloned\");for(e=0;e<o+s.slideCount;e+=1)t=e,i(s.$slides[t]).clone(!0).attr(\"id\",\"\").attr(\"data-slick-index\",t+s.slideCount).appendTo(s.$slideTrack).addClass(\"slick-cloned\");s.$slideTrack.find(\".slick-cloned\").find(\"[id]\").each(function(){i(this).attr(\"id\",\"\")})}},e.prototype.interrupt=function(i){var e=this;i||e.autoPlay(),e.interrupted=i},e.prototype.selectHandler=function(e){var t=this,o=i(e.target).is(\".slick-slide\")?i(e.target):i(e.target).parents(\".slick-slide\"),s=parseInt(o.attr(\"data-slick-index\"));return s||(s=0),t.slideCount<=t.options.slidesToShow?void t.slideHandler(s,!1,!0):void t.slideHandler(s)},e.prototype.slideHandler=function(i,e,t){var o,s,n,r,l,d=null,a=this;if(e=e||!1,!(a.animating===!0&&a.options.waitForAnimate===!0||a.options.fade===!0&&a.currentSlide===i))return e===!1&&a.asNavFor(i),o=i,d=a.getLeft(o),r=a.getLeft(a.currentSlide),a.currentLeft=null===a.swipeLeft?r:a.swipeLeft,a.options.infinite===!1&&a.options.centerMode===!1&&(i<0||i>a.getDotCount()*a.options.slidesToScroll)?void(a.options.fade===!1&&(o=a.currentSlide,t!==!0&&a.slideCount>a.options.slidesToShow?a.animateSlide(r,function(){a.postSlide(o)}):a.postSlide(o))):a.options.infinite===!1&&a.options.centerMode===!0&&(i<0||i>a.slideCount-a.options.slidesToScroll)?void(a.options.fade===!1&&(o=a.currentSlide,t!==!0&&a.slideCount>a.options.slidesToShow?a.animateSlide(r,function(){a.postSlide(o)}):a.postSlide(o))):(a.options.autoplay&&clearInterval(a.autoPlayTimer),s=o<0?a.slideCount%a.options.slidesToScroll!==0?a.slideCount-a.slideCount%a.options.slidesToScroll:a.slideCount+o:o>=a.slideCount?a.slideCount%a.options.slidesToScroll!==0?0:o-a.slideCount:o,a.animating=!0,a.$slider.trigger(\"beforeChange\",[a,a.currentSlide,s]),n=a.currentSlide,a.currentSlide=s,a.setSlideClasses(a.currentSlide),a.options.asNavFor&&(l=a.getNavTarget(),l=l.slick(\"getSlick\"),l.slideCount<=l.options.slidesToShow&&l.setSlideClasses(a.currentSlide)),a.updateDots(),a.updateArrows(),a.options.fade===!0?(t!==!0?(a.fadeSlideOut(n),a.fadeSlide(s,function(){a.postSlide(s)})):a.postSlide(s),void a.animateHeight()):void(t!==!0&&a.slideCount>a.options.slidesToShow?a.animateSlide(d,function(){a.postSlide(s)}):a.postSlide(s)))},e.prototype.startLoad=function(){var i=this;i.options.arrows===!0&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.hide(),i.$nextArrow.hide()),i.options.dots===!0&&i.slideCount>i.options.slidesToShow&&i.$dots.hide(),i.$slider.addClass(\"slick-loading\")},e.prototype.swipeDirection=function(){var i,e,t,o,s=this;return i=s.touchObject.startX-s.touchObject.curX,e=s.touchObject.startY-s.touchObject.curY,t=Math.atan2(e,i),o=Math.round(180*t/Math.PI),o<0&&(o=360-Math.abs(o)),o<=45&&o>=0?s.options.rtl===!1?\"left\":\"right\":o<=360&&o>=315?s.options.rtl===!1?\"left\":\"right\":o>=135&&o<=225?s.options.rtl===!1?\"right\":\"left\":s.options.verticalSwiping===!0?o>=35&&o<=135?\"down\":\"up\":\"vertical\"},e.prototype.swipeEnd=function(i){var e,t,o=this;if(o.dragging=!1,o.swiping=!1,o.scrolling)return o.scrolling=!1,!1;if(o.interrupted=!1,o.shouldClick=!(o.touchObject.swipeLength>10),void 0===o.touchObject.curX)return!1;if(o.touchObject.edgeHit===!0&&o.$slider.trigger(\"edge\",[o,o.swipeDirection()]),o.touchObject.swipeLength>=o.touchObject.minSwipe){switch(t=o.swipeDirection()){case\"left\":case\"down\":e=o.options.swipeToSlide?o.checkNavigable(o.currentSlide+o.getSlideCount()):o.currentSlide+o.getSlideCount(),o.currentDirection=0;break;case\"right\":case\"up\":e=o.options.swipeToSlide?o.checkNavigable(o.currentSlide-o.getSlideCount()):o.currentSlide-o.getSlideCount(),o.currentDirection=1}\"vertical\"!=t&&(o.slideHandler(e),o.touchObject={},o.$slider.trigger(\"swipe\",[o,t]))}else o.touchObject.startX!==o.touchObject.curX&&(o.slideHandler(o.currentSlide),o.touchObject={})},e.prototype.swipeHandler=function(i){var e=this;if(!(e.options.swipe===!1||\"ontouchend\"in document&&e.options.swipe===!1||e.options.draggable===!1&&i.type.indexOf(\"mouse\")!==-1))switch(e.touchObject.fingerCount=i.originalEvent&&void 0!==i.originalEvent.touches?i.originalEvent.touches.length:1,e.touchObject.minSwipe=e.listWidth/e.options.touchThreshold,e.options.verticalSwiping===!0&&(e.touchObject.minSwipe=e.listHeight/e.options.touchThreshold),i.data.action){case\"start\":e.swipeStart(i);break;case\"move\":e.swipeMove(i);break;case\"end\":e.swipeEnd(i)}},e.prototype.swipeMove=function(i){var e,t,o,s,n,r,l=this;return n=void 0!==i.originalEvent?i.originalEvent.touches:null,!(!l.dragging||l.scrolling||n&&1!==n.length)&&(e=l.getLeft(l.currentSlide),l.touchObject.curX=void 0!==n?n[0].pageX:i.clientX,l.touchObject.curY=void 0!==n?n[0].pageY:i.clientY,l.touchObject.swipeLength=Math.round(Math.sqrt(Math.pow(l.touchObject.curX-l.touchObject.startX,2))),r=Math.round(Math.sqrt(Math.pow(l.touchObject.curY-l.touchObject.startY,2))),!l.options.verticalSwiping&&!l.swiping&&r>4?(l.scrolling=!0,!1):(l.options.verticalSwiping===!0&&(l.touchObject.swipeLength=r),t=l.swipeDirection(),void 0!==i.originalEvent&&l.touchObject.swipeLength>4&&(l.swiping=!0,i.preventDefault()),s=(l.options.rtl===!1?1:-1)*(l.touchObject.curX>l.touchObject.startX?1:-1),l.options.verticalSwiping===!0&&(s=l.touchObject.curY>l.touchObject.startY?1:-1),o=l.touchObject.swipeLength,l.touchObject.edgeHit=!1,l.options.infinite===!1&&(0===l.currentSlide&&\"right\"===t||l.currentSlide>=l.getDotCount()&&\"left\"===t)&&(o=l.touchObject.swipeLength*l.options.edgeFriction,l.touchObject.edgeHit=!0),l.options.vertical===!1?l.swipeLeft=e+o*s:l.swipeLeft=e+o*(l.$list.height()/l.listWidth)*s,l.options.verticalSwiping===!0&&(l.swipeLeft=e+o*s),l.options.fade!==!0&&l.options.touchMove!==!1&&(l.animating===!0?(l.swipeLeft=null,!1):void l.setCSS(l.swipeLeft))))},e.prototype.swipeStart=function(i){var e,t=this;return t.interrupted=!0,1!==t.touchObject.fingerCount||t.slideCount<=t.options.slidesToShow?(t.touchObject={},!1):(void 0!==i.originalEvent&&void 0!==i.originalEvent.touches&&(e=i.originalEvent.touches[0]),t.touchObject.startX=t.touchObject.curX=void 0!==e?e.pageX:i.clientX,t.touchObject.startY=t.touchObject.curY=void 0!==e?e.pageY:i.clientY,void(t.dragging=!0))},e.prototype.unfilterSlides=e.prototype.slickUnfilter=function(){var i=this;null!==i.$slidesCache&&(i.unload(),i.$slideTrack.children(this.options.slide).detach(),i.$slidesCache.appendTo(i.$slideTrack),i.reinit())},e.prototype.unload=function(){var e=this;i(\".slick-cloned\",e.$slider).remove(),e.$dots&&e.$dots.remove(),e.$prevArrow&&e.htmlExpr.test(e.options.prevArrow)&&e.$prevArrow.remove(),e.$nextArrow&&e.htmlExpr.test(e.options.nextArrow)&&e.$nextArrow.remove(),e.$slides.removeClass(\"slick-slide slick-active slick-visible slick-current\").attr(\"aria-hidden\",\"true\").css(\"width\",\"\")},e.prototype.unslick=function(i){var e=this;e.$slider.trigger(\"unslick\",[e,i]),e.destroy()},e.prototype.updateArrows=function(){var i,e=this;i=Math.floor(e.options.slidesToShow/2),e.options.arrows===!0&&e.slideCount>e.options.slidesToShow&&!e.options.infinite&&(e.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\"),e.$nextArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\"),0===e.currentSlide?(e.$prevArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),e.$nextArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")):e.currentSlide>=e.slideCount-e.options.slidesToShow&&e.options.centerMode===!1?(e.$nextArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),e.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")):e.currentSlide>=e.slideCount-1&&e.options.centerMode===!0&&(e.$nextArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),e.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")))},e.prototype.updateDots=function(){var i=this;null!==i.$dots&&(i.$dots.find(\"li\").removeClass(\"slick-active\").end(),i.$dots.find(\"li\").eq(Math.floor(i.currentSlide/i.options.slidesToScroll)).addClass(\"slick-active\"))},e.prototype.visibility=function(){var i=this;i.options.autoplay&&(document[i.hidden]?i.interrupted=!0:i.interrupted=!1)},i.fn.slick=function(){var i,t,o=this,s=arguments[0],n=Array.prototype.slice.call(arguments,1),r=o.length;for(i=0;i<r;i++)if(\"object\"==typeof s||\"undefined\"==typeof s?o[i].slick=new e(o[i],s):t=o[i].slick[s].apply(o[i].slick,n),\"undefined\"!=typeof t)return t;return o}});\n","Amasty_Base/js/theme.js":"define([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (widget) {\n        $.widget('mage.globalNavigation', widget, {\n            _open: function (e) {\n                var selectors = this.options.selectors,\n                    menuItemSelector = selectors.topLevelItem,\n                    menuItem = $(e.target).closest(menuItemSelector),\n                    subMenu = $(selectors.subMenu, menuItem),\n                    closeBtn = subMenu.find(selectors.closeSubmenuBtn);\n\n                closeBtn.unbind('click');\n                this._super(e);\n\n                /* fix for menu with multiple columns */\n                menuItem.parents('.submenu')\n                    .find(menuItemSelector).not(menuItem)\n                    .removeClass('_show')\n                    .removeClass('_active');\n\n                /* fix for hiding our menu after selecting native */\n                menuItem.parent()\n                    .find(menuItemSelector + '._show').not(menuItem)\n                    .removeClass('_show')\n                    .removeClass('_active');\n            },\n\n            _close: function (e) {\n                var selectors = this.options.selectors,\n                    currentCrossElement = $(e.target),\n                    topLevelItemSelector = selectors.topLevelItem,\n                    menuItem = this.menu.find(topLevelItemSelector + '._show');\n\n                if (currentCrossElement && currentCrossElement.parents('[data-ui-id*=\"menu-amasty\"]').length > 0) {\n                    this.options.selectors.topLevelItem = '.submenu ' + topLevelItemSelector;\n                }\n\n                this._super(e);\n                this.options.selectors.topLevelItem = topLevelItemSelector;\n\n                e.preventDefault();\n                e.stopPropagation();\n                return false;\n            }\n        });\n\n        return $.mage.globalNavigation;\n    }\n});\n","Amasty_Base/js/lib/es6-collections.js":"/* phpcs:ignoreFile */\n\n(function (exports) {'use strict';\n  //shared pointer\n  var i;\n  //shortcuts\n  var defineProperty = Object.defineProperty, is = function(a,b) { return isNaN(a)? isNaN(b): a === b; };\n\n\n  //Polyfill global objects\n  if (typeof WeakMap == 'undefined') {\n    exports.WeakMap = createCollection({\n      // WeakMap#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // WeakMap#clear():\n      clear: sharedClear,\n      // WeakMap#get(key:void*):void*\n      get: sharedGet,\n      // WeakMap#has(key:void*):boolean\n      has: mapHas,\n      // WeakMap#set(key:void*, value:void*):void\n      set: sharedSet\n    }, true);\n  }\n\n  if (typeof Map == 'undefined' || typeof ((new Map).values) !== 'function' || !(new Map).values().next) {\n    exports.Map = createCollection({\n      // WeakMap#delete(key:void*):boolean\n      'delete': sharedDelete,\n      //:was Map#get(key:void*[, d3fault:void*]):void*\n      // Map#has(key:void*):boolean\n      has: mapHas,\n      // Map#get(key:void*):boolean\n      get: sharedGet,\n      // Map#set(key:void*, value:void*):void\n      set: sharedSet,\n      // Map#keys(void):Iterator\n      keys: sharedKeys,\n      // Map#values(void):Iterator\n      values: sharedValues,\n      // Map#entries(void):Iterator\n      entries: mapEntries,\n      // Map#forEach(callback:Function, context:void*):void ==> callback.call(context, key, value, mapObject) === not in specs`\n      forEach: sharedForEach,\n      // Map#clear():\n      clear: sharedClear\n    });\n  }\n\n  if (typeof Set == 'undefined' || typeof ((new Set).values) !== 'function' || !(new Set).values().next) {\n    exports.Set = createCollection({\n      // Set#has(value:void*):boolean\n      has: setHas,\n      // Set#add(value:void*):boolean\n      add: sharedAdd,\n      // Set#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // Set#clear():\n      clear: sharedClear,\n      // Set#keys(void):Iterator\n      keys: sharedValues, // specs actually say \"the same function object as the initial value of the values property\"\n      // Set#values(void):Iterator\n      values: sharedValues,\n      // Set#entries(void):Iterator\n      entries: setEntries,\n      // Set#forEach(callback:Function, context:void*):void ==> callback.call(context, value, index) === not in specs\n      forEach: sharedForEach\n    });\n  }\n\n  if (typeof WeakSet == 'undefined') {\n    exports.WeakSet = createCollection({\n      // WeakSet#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // WeakSet#add(value:void*):boolean\n      add: sharedAdd,\n      // WeakSet#clear():\n      clear: sharedClear,\n      // WeakSet#has(value:void*):boolean\n      has: setHas\n    }, true);\n  }\n\n\n  /**\n   * ES6 collection constructor\n   * @return {Function} a collection class\n   */\n  function createCollection(proto, objectOnly){\n    function Collection(a){\n      if (!this || this.constructor !== Collection) return new Collection(a);\n      this._keys = [];\n      this._values = [];\n      this._itp = []; // iteration pointers\n      this.objectOnly = objectOnly;\n\n      //parse initial iterable argument passed\n      if (a) init.call(this, a);\n    }\n\n    //define size for non object-only collections\n    if (!objectOnly) {\n      defineProperty(proto, 'size', {\n        get: sharedSize\n      });\n    }\n\n    //set prototype\n    proto.constructor = Collection;\n    Collection.prototype = proto;\n\n    return Collection;\n  }\n\n\n  /** parse initial iterable argument passed */\n  function init(a){\n    var i;\n    //init Set argument, like `[1,2,3,{}]`\n    if (this.add)\n      a.forEach(this.add, this);\n    //init Map argument like `[[1,2], [{}, 4]]`\n    else\n      a.forEach(function(a){this.set(a[0],a[1])}, this);\n  }\n\n\n  /** delete */\n  function sharedDelete(key) {\n    if (this.has(key)) {\n      this._keys.splice(i, 1);\n      this._values.splice(i, 1);\n      // update iteration pointers\n      this._itp.forEach(function(p) { if (i < p[0]) p[0]--; });\n    }\n    // Aurora here does it while Canary doesn't\n    return -1 < i;\n  };\n\n  function sharedGet(key) {\n    return this.has(key) ? this._values[i] : undefined;\n  }\n\n  function has(list, key) {\n    if (this.objectOnly && key !== Object(key))\n      throw new TypeError(\"Invalid value used as weak collection key\");\n    //NaN or 0 passed\n    if (key != key || key === 0) for (i = list.length; i-- && !is(list[i], key);){}\n    else i = list.indexOf(key);\n    return -1 < i;\n  }\n\n  function setHas(value) {\n    return has.call(this, this._values, value);\n  }\n\n  function mapHas(value) {\n    return has.call(this, this._keys, value);\n  }\n\n  /** @chainable */\n  function sharedSet(key, value) {\n    this.has(key) ?\n      this._values[i] = value\n      :\n      this._values[this._keys.push(key) - 1] = value\n    ;\n    return this;\n  }\n\n  /** @chainable */\n  function sharedAdd(value) {\n    if (!this.has(value)) this._values.push(value);\n    return this;\n  }\n\n  function sharedClear() {\n    this._values.length = 0;\n  }\n\n  /** keys, values, and iterate related methods */\n  function sharedKeys() {\n    return sharedIterator(this._itp, this._keys);\n  }\n\n  function sharedValues() {\n    return sharedIterator(this._itp, this._values);\n  }\n\n  function mapEntries() {\n    return sharedIterator(this._itp, this._keys, this._values);\n  }\n\n  function setEntries() {\n    return sharedIterator(this._itp, this._values, this._values);\n  }\n\n  function sharedIterator(itp, array, array2) {\n    var p = [0], done = false;\n    itp.push(p);\n    return {\n      next: function() {\n        var v, k = p[0];\n        if (!done && k < array.length) {\n          v = array2 ? [array[k], array2[k]]: array[k];\n          p[0]++;\n        } else {\n          done = true;\n          itp.splice(itp.indexOf(p), 1);\n        }\n        return { done: done, value: v };\n      }\n    };\n  }\n\n  function sharedSize() {\n    return this._values.length;\n  }\n\n  function sharedForEach(callback, context) {\n    var it = this.entries();\n    for (;;) {\n      var r = it.next();\n      if (r.done) break;\n      callback.call(context, r.value[1], r.value[0], this);\n    }\n  }\n\n})(typeof exports != 'undefined' && typeof global != 'undefined' ? global : window );\n","Magento_Checkout/js/model/default-post-code-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Define necessity of using default post code value\n     */\n    var useDefaultPostCode;\n\n    return {\n        /**\n         * Resolve default post code\n         *\n         * @returns {String|null}\n         */\n        resolve: function () {\n            return useDefaultPostCode ?  window.checkoutConfig.defaultPostcode : null;\n        },\n\n        /**\n         * Set state to useDefaultPostCode variable\n         *\n         * @param {Boolean} shouldUseDefaultPostCode\n         * @returns {underscore}\n         */\n        setUseDefaultPostCode: function (shouldUseDefaultPostCode) {\n            useDefaultPostCode = shouldUseDefaultPostCode;\n\n            return this;\n        }\n    };\n});\n","Magento_InventoryShippingAdminUi/js/order/grid/cell/allocated-sources.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryShippingAdminUi/order/grid/cell/allocated-sources-cell.html',\n            itemsToDisplay: 5\n        },\n\n        /**\n         *\n         * @param {Array} record\n         * @returns {Array}\n         */\n        getTooltipData: function (record) {\n            return record[this.index];\n        },\n\n        /**\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getAllocatedSources: function (record) {\n            return this.getTooltipData(record).slice(0, this.itemsToDisplay);\n        }\n    });\n});\n","Magento_InventoryShippingAdminUi/js/form/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/form',\n    'underscore',\n    'mageUtils'\n], function ($, Form, _, utils) {\n    'use strict';\n\n    return Form.extend({\n        defaults: {\n            sourceSelectionUrl: '${ $.sourceSelectionUrl }'\n        },\n\n        /**\n         * Process source selection algorithm\n         *\n         * @param {String} redirect\n         * @param {Object} data\n         */\n        processAlgorithm: function (redirect, data) {\n            var formData = utils.filterFormData(this.source.get('data'));\n\n            data.requestData = [];\n\n            _.each(formData.items, function (item) {\n                data.requestData.push({\n                    orderItem: item.orderItemId,\n                    sku: item.sku,\n                    qty: item.qtyToShip\n                });\n            });\n\n            data.orderId = formData['order_id'];\n            data.websiteId = formData.websiteId;\n            data = utils.serialize(utils.filterFormData(data));\n            data['form_key'] = window.FORM_KEY;\n\n            if (!this.sourceSelectionUrl || this.sourceSelectionUrl === 'undefined') {\n                return $.Deferred.resolve();\n            }\n\n            $('body').trigger('processStart');\n\n            $.ajax({\n                url: this.sourceSelectionUrl,\n                data: data,\n\n                /**\n                 * Success callback.\n                 *\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    var dataItems = this.source.get('data.items');\n\n                    _.each(dataItems, function (item) {\n                        if (response[item.orderItemId]) {\n                            this.source.set('data.items.' + item['record_id'] + '.sources', response[item.orderItemId]);\n                        }\n                    }.bind(this));\n                    this.source.trigger('reInitSources');\n                    this.source.set('data.sourceCodes', response.sourceCodes ? response.sourceCodes : []);\n                }.bind(this),\n\n                /**\n                 * Complete callback.\n                 */\n                complete: function () {\n                    $('body').trigger('processStop');\n                }\n            });\n        }\n    });\n});\n","Magento_InventoryShippingAdminUi/js/form/element/source_code.js":"define([\n    'underscore',\n    'Magento_Ui/js/form/element/select'\n], function (_, select) {\n    'use strict';\n\n    return select.extend({\n        /**\n         * @inheritdoc\n         */\n        setOptions: function (data) {\n            var result = this._super(data);\n\n            if (data.length === 1) {\n                this.value(data[0].value);\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_InventoryShippingAdminUi/js/form/element/qty_to_deduct.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'mageUtils'\n], function (Abstract, utils) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            sourceCode: null,\n            qtyAvailable: 0\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            var path,\n                qtyToShip,\n                isManageStock;\n\n            this._super();\n\n            //TODO: Is it right way?\n            path = utils.getPart(utils.getPart(this.parentScope, -2), -2);\n            qtyToShip = this.source.get(path + '.qtyToShip');\n            isManageStock = this.source.get(path + '.isManageStock');\n\n            this.validation['less-than-equals-to'] = isManageStock ? this.qtyAvailable : qtyToShip;\n\n            return this;\n        },\n\n        /**\n         * Toggle disabled state.\n         *\n         * @param {String} selected\n         */\n        toggleDisable: function (selected) {\n            this.disabled(selected ? selected.toString() !== this.sourceCode : !selected);\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/configurable-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'collapsible',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'domReady!'\n], function ($, productType) {\n    'use strict';\n\n    return {\n        $block: null,\n        hasVariations: null,\n        configurationSectionMessageHandler: (function () {\n            var title = $('[data-role=\"product-create-configuration-info\"]'),\n                buttons = $('[data-action=\"product-create-configuration-buttons\"]'),\n                newText = 'Configurations cannot be created for a standard product with downloadable files.' +\n                ' To create configurations, first remove all downloadable files.',\n                oldText = title.text();\n\n            return function (change) {\n                if (change) {\n                    title.text(newText);\n                    buttons.hide();\n                } else {\n                    title.text(oldText);\n                    buttons.show();\n                }\n            };\n        }()),\n\n        /**\n         * Set element disabled\n         * @param {Object} $element - jquery instance element\n         * @param {Bool} state\n         * @param {Bool} triggerEvent\n         * @private\n         */\n        _setElementDisabled: function ($element, state, triggerEvent) {\n            if (!$element.is('[data-locked]')) {\n                $element.prop('disabled', state);\n\n                if (triggerEvent) {\n                    $element.trigger('change');\n                }\n            }\n        },\n\n        /**\n         * Show\n         */\n        show: function () {\n            this.configurationSectionMessageHandler(false);\n        },\n\n        /**\n         * Hide\n         */\n        hide: function () {\n            this.configurationSectionMessageHandler(true);\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('changeConfigurableTypeProduct', function (event, isConfigurable) {\n                $(document).trigger('setTypeProduct', isConfigurable ?\n                    'configurable' :\n                    productType.type.init === 'configurable' ? 'simple' : productType.type.init\n                );\n            });\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n        },\n\n        /**\n         * Init type\n         * @private\n         */\n        _initType: function () {\n\n            /*var suggestContainer = $('#product-template-suggest-container .action-dropdown > .action-toggle');\n\n\n            if (productType.type.current === 'configurable') {\n                this._setElementDisabled(suggestContainer.addClass('disabled'), true);\n                this._setElementDisabled($('#inventory_qty'), true);\n                this._setElementDisabled($('#inventory_stock_availability'), false);\n                this._setElementDisabled($('#qty'), true, true);\n                this._setElementDisabled($('#quantity_and_stock_status'), false, false);\n            } else {\n                this._setElementDisabled(suggestContainer.removeClass('disabled'), false);\n                this._setElementDisabled($('#inventory_qty'), false);\n                this._setElementDisabled($('#inventory_stock_availability'), true);\n                this._setElementDisabled($('#qty'), false, true);\n            }\n            */\n\n            /*if (['simple', 'virtual', 'configurable'].indexOf(productType.type.current) < 0) {\n                this.hide();\n            } else {\n                this.show();\n            }*/\n\n            this.show();\n        },\n\n        /**\n         * Constructor component\n         * @param {Object} data - this backend data\n         */\n        'Magento_ConfigurableProduct/js/configurable-type-handler': function (data) {\n            this.$block = $(data.blockId + ' input[name=\"attributes[]\"]');\n            this.hasVariations = data.hasVariations;\n\n            //advancedPricingHandler.init();\n            //priceTypeHandler.init();\n\n            /*if (productType.type.init === 'configurable' && !this.hasVariations) {\n                $(document).trigger('setTypeProduct', 'simple');\n            }*/\n            $(document).trigger('setTypeProduct', 'simple');\n\n            this.bindAll();\n            this._initType();\n        }\n    };\n});\n","Magento_ConfigurableProduct/js/configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**************************** CONFIGURABLE PRODUCT **************************/\n/* global Product, optionsPrice */\ndefine([\n    'jquery',\n    'mage/template',\n    'mage/translate',\n    'prototype'\n], function (jQuery, mageTemplate) {\n    'use strict';\n\n    if (typeof Product == 'undefined') {\n        window.Product = {};\n    }\n\n    Product.Config = Class.create();\n    Product.Config.prototype = {\n        /**\n         * Initialize function.\n         *\n         * @param {Object} config\n         */\n        initialize: function (config) {\n            var separatorIndex, paramsStr, urlValues, i, childSettings, prevSetting, nextSetting;\n\n            // Magic preprocessing\n            // TODO MAGETWO-31539\n            config.taxConfig = {\n                showBothPrices: false,\n                inclTaxTitle: jQuery.mage.__('Incl. Tax')\n            };\n\n            this.config     = config;\n            this.taxConfig  = this.config.taxConfig;\n\n            if (config.containerId) {\n                this.settings   = $$('#' + config.containerId + ' ' + '.super-attribute-select');\n            } else {\n                this.settings   = $$('.super-attribute-select');\n            }\n            this.state      = new Hash();\n            this.priceTemplate = mageTemplate(this.config.template);\n            this.prices     = config.prices;\n            this.values     = {};\n\n            // Set default values from config\n            if (config.defaultValues) {\n                this.values = config.defaultValues;\n            }\n\n            // Overwrite defaults by url\n            separatorIndex = window.location.href.indexOf('#');\n\n            if (separatorIndex != -1) { //eslint-disable-line eqeqeq\n                paramsStr = window.location.href.substr(separatorIndex + 1);\n                urlValues = paramsStr.toQueryParams();\n\n                for (i in urlValues) { //eslint-disable-line guard-for-in\n                    this.values[i] = urlValues[i];\n                }\n            }\n\n            // Overwrite defaults by inputs values if needed\n            if (config.inputsInitialized) {\n                this.values = {};\n                this.settings.each(function (element) {\n                    var attributeId;\n\n                    if (element.value) {\n                        attributeId = element.id.replace(/[a-z]*/, '');\n                        this.values[attributeId] = element.value;\n                    }\n                }.bind(this));\n            }\n\n            // Put events to check select reloads\n            this.settings.each(function (element) {\n                Event.observe(element, 'change', this.configure.bind(this));\n            }.bind(this));\n\n            // fill state\n            this.settings.each(function (element) {\n                var attributeId = element.id.replace(/[a-z]*/, '');\n\n                if (attributeId && this.config.attributes[attributeId]) {\n                    element.config = this.config.attributes[attributeId];\n                    element.attributeId = attributeId;\n                    this.state[attributeId] = false;\n                }\n            }.bind(this));\n\n            // Init settings dropdown\n            childSettings = [];\n\n            for (i = this.settings.length - 1; i >= 0; i--) {\n                prevSetting = this.settings[i - 1] ? this.settings[i - 1] : false;\n                nextSetting = this.settings[i + 1] ? this.settings[i + 1] : false;\n\n                if (i === 0) {\n                    this.fillSelect(this.settings[i]);\n                } else {\n                    this.settings[i].disabled = true;\n                }\n                $(this.settings[i]).childSettings = childSettings.clone();\n                $(this.settings[i]).prevSetting   = prevSetting;\n                $(this.settings[i]).nextSetting   = nextSetting;\n                childSettings.push(this.settings[i]);\n            }\n\n            // Set values to inputs\n            this.configureForValues();\n            document.observe('dom:loaded', this.configureForValues.bind(this));\n        },\n\n        /**\n         * Configure for values.\n         */\n        configureForValues: function () {\n            if (this.values) {\n                this.settings.each(function (element) {\n                    var attributeId = element.attributeId;\n\n                    element.value = typeof this.values[attributeId] === 'undefined' ? '' : this.values[attributeId];\n                    this.configureElement(element);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @param {Object} event\n         */\n        configure: function (event) {\n            var element = Event.element(event);\n\n            this.configureElement(element);\n        },\n\n        /**\n         * @param {Object} element\n         */\n        configureElement: function (element) {\n            this.reloadOptionLabels(element);\n\n            if (element.value) {\n                this.state[element.config.id] = element.value;\n\n                if (element.nextSetting) {\n                    element.nextSetting.disabled = false;\n                    this.fillSelect(element.nextSetting);\n                    this.resetChildren(element.nextSetting);\n                }\n            } else {\n                this.resetChildren(element);\n            }\n            this.reloadPrice();\n        },\n\n        /**\n         * @param {Object} element\n         */\n        reloadOptionLabels: function (element) {\n            var selectedPrice = 0,\n                option, i;\n\n            if (element.options[element.selectedIndex] && element.options[element.selectedIndex].config) {\n                option = element.options[element.selectedIndex].config;\n                selectedPrice = parseFloat(this.config.optionPrices[option.allowedProducts[0]].finalPrice.amount);\n            }\n            element.setAttribute('price', selectedPrice);\n\n            for (i = 0; i < element.options.length; i++) {\n                if (element.options[i].config) {\n                    element.options[i].setAttribute('price', selectedPrice);\n                    element.options[i].setAttribute('summarizePrice', 0);\n                    element.options[i].text = this.getOptionLabel(element.options[i].config, selectedPrice);\n                }\n            }\n        },\n\n        /* eslint-disable max-depth */\n        /**\n         * @param {Object} element\n         */\n        resetChildren: function (element) {\n            var i;\n\n            if (element.childSettings) {\n                for (i = 0; i < element.childSettings.length; i++) {\n                    element.childSettings[i].selectedIndex = 0;\n                    element.childSettings[i].disabled = true;\n\n                    if (element.config) {\n                        this.state[element.config.id] = false;\n                    }\n                }\n            }\n        },\n\n        /**\n         * @param {Object} element\n         */\n        fillSelect: function (element) {\n            var attributeId = element.id.replace(/[a-z]*/, ''),\n                options = this.getAttributeOptions(attributeId),\n                prevConfig = false,\n                index = 1,\n                i, j, allowedProducts;\n\n            this.clearSelect(element);\n            element.options[0] = new Option('', '');\n            element.options[0].innerHTML = this.config.chooseText;\n\n            if (element.prevSetting) {\n                prevConfig = element.prevSetting.options[element.prevSetting.selectedIndex];\n            }\n\n            if (options) {\n                for (i = 0; i < options.length; i++) {\n                    allowedProducts = [];\n\n                    if (prevConfig) {\n                        for (j = 0; j < options[i].products.length; j++) {\n                            if (prevConfig.config.allowedProducts &&\n                                prevConfig.config.allowedProducts.indexOf(options[i].products[j]) > -1\n                            ) {\n                                allowedProducts.push(options[i].products[j]);\n                            }\n                        }\n                    } else {\n                        allowedProducts = options[i].products.clone();\n                    }\n\n                    if (allowedProducts.size() > 0) {\n                        options[i].allowedProducts = allowedProducts;\n                        element.options[index] = new Option(this.getOptionLabel(options[i]), options[i].id);\n\n                        if (typeof options[i].price != 'undefined') {\n                            element.options[index].setAttribute('price', options[i].price);\n                        }\n                        element.options[index].config = options[i];\n                        index++;\n                    }\n                }\n            }\n        },\n\n        //eslint-enable max-depth\n        /**\n         * @param {Object} option\n         */\n        getOptionLabel: function (option) {\n            return option.label;\n        },\n\n        /**\n         * @param {*} price\n         * @param {Boolean} showSign\n         * @return {String}\n         */\n        formatPrice: function (price, showSign) {\n            var str = '',\n                roundedPrice;\n\n            price = parseFloat(price);\n\n            if (showSign) {\n                if (price < 0) {\n                    str += '-';\n                    price = -price;\n                } else {\n                    str += '+';\n                }\n            }\n\n            roundedPrice = Number(Math.round(price + 'e+2') + 'e-2').toString();\n\n            if (this.prices && this.prices[roundedPrice]) {\n                str += this.prices[roundedPrice];\n            } else {\n                str += this.priceTemplate({\n                    data: {\n                        price: price.toFixed(2)\n                    }\n                });\n            }\n\n            return str;\n        },\n\n        /**\n         * @param {Object} element\n         */\n        clearSelect: function (element) {\n            var i;\n\n            for (i = element.options.length - 1; i >= 0; i--) {\n                element.remove(i);\n            }\n        },\n\n        /**\n         * @param {*} attributeId\n         * @return {*|undefined}\n         */\n        getAttributeOptions: function (attributeId) {\n            if (this.config.attributes[attributeId]) {\n                return this.config.attributes[attributeId].options;\n            }\n        },\n\n        /**\n         * Reload price.\n         *\n         * @return {undefined|Number}\n         */\n        reloadPrice: function () {\n            var price = 0,\n                oldPrice = 0,\n                inclTaxPrice = 0,\n                exclTaxPrice = 0,\n                i, selected;\n\n            if (this.config.disablePriceReload) {\n                return undefined;\n            }\n\n            for (i = this.settings.length - 1; i >= 0; i--) {\n                selected = this.settings[i].options[this.settings[i].selectedIndex];\n\n                if (selected.config) {\n                    price += parseFloat(selected.config.price);\n                    oldPrice += parseFloat(selected.config.oldPrice);\n                    inclTaxPrice += parseFloat(selected.config.inclTaxPrice);\n                    exclTaxPrice += parseFloat(selected.config.exclTaxPrice);\n                }\n            }\n\n            optionsPrice.changePrice(\n                'config', {\n                    'price': price,\n                    'oldPrice': oldPrice,\n                    'inclTaxPrice': inclTaxPrice,\n                    'exclTaxPrice': exclTaxPrice\n                }\n            );\n            optionsPrice.reload();\n\n            return price;\n        },\n\n        /**\n         * Reload old price.\n         */\n        reloadOldPrice: function () {\n            var price, i, selected;\n\n            if (this.config.disablePriceReload) {\n                return;\n            }\n\n            if ($('old-price-' + this.config.productId)) {\n\n                price = parseFloat(this.config.oldPrice);\n\n                for (i = this.settings.length - 1; i >= 0; i--) {\n                    selected = this.settings[i].options[this.settings[i].selectedIndex];\n\n                    if (selected.config) {\n                        price += parseFloat(selected.config.price);\n                    }\n                }\n\n                if (price < 0) {\n                    price = 0;\n                }\n                price = this.formatPrice(price);\n\n                if ($('old-price-' + this.config.productId)) {\n                    $('old-price-' + this.config.productId).innerHTML = price;\n                }\n\n            }\n        }\n    };\n});\n","Magento_ConfigurableProduct/js/options/price-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'notification',\n    'mage/translate'\n], function ($, productType) {\n    'use strict';\n\n    return {\n        isConfigurable: false,\n        messageInited: false,\n        messageSelector: '[data-role=product-custom-options-content]',\n        isPercentPriceTypeExist: function () {\n            var productOptionsContainer = $('#product_options_container_top');\n\n            return !!productOptionsContainer.length;\n        },\n        showWarning: function () {\n            if (!this.messageInited) {\n                $(this.messageSelector).notification();\n                this.messageInited = true;\n            }\n            this.hideWarning();\n            $(this.messageSelector).notification('add', {\n                message: $.mage.__('Custom options with price type \"percent\" is not available for ' +\n                    'configurable product.'),\n                error: false,\n                messageContainer: this.messageSelector\n            });\n        },\n        hideWarning: function () {\n            $(this.messageSelector).notification('clear');\n        },\n        init: function () {\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n\n            $('#product-edit-form-tabs').on('change', '.opt-type > select', function () {\n                var selected = $('.opt-type > select :selected'),\n                    optGroup = selected.parent().attr('label');\n\n                if (optGroup === 'Select') {\n                    $('#product-edit-form-tabs').on(\n                        'click',\n                        '[data-ui-id=\"admin-product-options-options-box-select-option-type-add-select-row-button\"]',\n                        function () {\n                            this.percentPriceTypeHandler();\n                        }.bind(this)\n                    );\n                } else {\n                    this.percentPriceTypeHandler();\n                }\n            }.bind(this));\n\n            this._initType();\n        },\n        _initType: function () {\n            this.isConfigurable = productType.type.current === 'configurable';\n            if (this.isPercentPriceTypeExist()) {\n                this.percentPriceTypeHandler();\n            }\n        },\n        percentPriceTypeHandler: function () {\n            var priceType = $('[data-attr=\"price-type\"]'),\n                optionPercentPriceType = priceType.find('option[value=\"percent\"]');\n\n            if (this.isConfigurable) {\n                this.showWarning();\n                optionPercentPriceType.hide();\n                optionPercentPriceType.parent().val() === 'percent' ? optionPercentPriceType.parent().val('fixed') : '';\n            } else {\n                $(this.messageSelector).notification();\n                optionPercentPriceType.show();\n                this.hideWarning();\n            }\n        }\n    };\n});\n*/\n","Magento_ConfigurableProduct/js/components/file-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/file-uploader',\n    'underscore'\n], function (Element, _) {\n    'use strict';\n\n    return Element.extend({\n        processedFile: {},\n        actionsListOpened: false,\n        thumbnailUrl: '',\n        thumbnail: null,\n        smallImage: null,\n        defaults: {\n            fileInputName: ''\n        },\n\n        /**\n         * Initialize observables.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(['processedFile', 'actionsListOpened', 'thumbnailUrl', 'thumbnail', 'smallImage']);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        setInitialValue: function () {\n            var value = this.getInitialValue();\n\n            if (!_.isString(value)) {\n                this._super();\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds provided file to the files list.\n         *\n         * @param {Object} file\n         * @returns {Object} Chainable.\n         */\n        addFile: function (file) {\n            this.processedFile(this.processFile(file));\n\n            this.value(this.processedFile().file);\n\n            return this;\n        },\n\n        /**\n         * Toggle actions list.\n         *\n         * @returns {Object} Chainable.\n         */\n        toggleActionsList: function () {\n            if (this.actionsListOpened()) {\n                this.actionsListOpened(false);\n            } else {\n                this.actionsListOpened(true);\n            }\n\n            return this;\n        },\n\n        /**\n         * Close action list.\n         *\n         * @returns {Object} Chainable\n         */\n        closeList: function () {\n            if (this.actionsListOpened()) {\n                this.actionsListOpened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Delete Image\n         *\n         * @returns {Object} Chainable\n         */\n        deleteImage: function () {\n            this.processedFile({});\n            this.value(null);\n            this.thumbnail(null);\n            this.thumbnailUrl(null);\n            this.smallImage(null);\n\n            return this;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/custom-options-price-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Catalog/js/components/custom-options-price-type'\n], function (_, PriceType) {\n    'use strict';\n\n    return PriceType.extend({\n        defaults: {\n            isConfigurable: false,\n            isFiltered: null,\n            defaultOptions: null,\n            filteredOptions: null,\n            bannedOptions: []\n        },\n\n        /**\n         * Updates options.\n         *\n         * @param {Boolean} variationsEmpty\n         * @returns {Boolean}\n         */\n        updateOptions: function (variationsEmpty) {\n            var isFiltered = this.isConfigurable || !variationsEmpty,\n                value;\n\n            if (this.isFiltered !== isFiltered) {\n                value = this.value();\n\n                this.options(isFiltered ? this.getFilteredOptions() : this.getDefaultOptions());\n                this.value(value);\n            }\n\n            return isFiltered;\n        },\n\n        /**\n         * Get default list of options.\n         *\n         * @returns {Array}\n         */\n        getDefaultOptions: function () {\n            if (this.defaultOptions === null) {\n                this.defaultOptions = this.options();\n            }\n\n            return this.defaultOptions;\n        },\n\n        /**\n         * Get filtered list of options.\n         *\n         * @returns {Array}\n         */\n        getFilteredOptions: function () {\n            var defaultOptions;\n\n            if (this.filteredOptions === null) {\n                defaultOptions = this.getDefaultOptions();\n                this.filteredOptions = [];\n\n                _.each(defaultOptions, function (option) {\n                    if (this.bannedOptions.indexOf(option.value) === -1) {\n                        this.filteredOptions.push(option);\n                    }\n                }, this);\n            }\n\n            return this.filteredOptions;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/qty-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                isConfigurable: '!ns = ${ $.ns }, index = configurable-matrix:isEmpty'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            // resolve initial disable state\n            this.handleQtyValue(this.isConfigurable);\n\n            /** important to set this listener in initialize because of a different order of processing.\n             * Do not move to defaults->listens section */\n            this.setListeners({\n                isConfigurable: 'handleQtyValue'\n            });\n\n            return this;\n        },\n\n        /**\n         * Disable and clear Qty if product type changed to configurable\n         *\n         * @param {String} isConfigurable\n         */\n        handleQtyValue: function (isConfigurable) {\n            this.disabled(!!this.isUseDefault() || isConfigurable);\n\n            if (isConfigurable) {\n                this.clear();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/container-configurable-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            listens: {\n                '${ $.provider }:data.is_downloadable': 'handleProductType'\n            },\n            links: {\n                isDownloadable: '${ $.provider }:data.is_downloadable'\n            },\n            modules: {\n                createConfigurableButton: '${$.createConfigurableButton}'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n            this.handleProductType(this.isDownloadable);\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['content']);\n\n            return this;\n        },\n\n        /**\n         * Change content for container and visibility for button\n         *\n         * @param {String} isDownloadable\n         */\n        handleProductType: function (isDownloadable) {\n            if (isDownloadable === '1') {\n                this.content(this.content2);\n\n                if (this.createConfigurableButton()) {\n                    this.createConfigurableButton().visible(false);\n                }\n            } else {\n                this.content(this.content1);\n\n                if (this.createConfigurableButton()) {\n                    this.createConfigurableButton().visible(true);\n                }\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/associated-product-insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/components/insert-listing'\n], function (_, insertListing) {\n    'use strict';\n\n    return insertListing.extend({\n        defaults: {\n            gridInitialized: false,\n            paramsUpdated: false,\n            showMassActionColumn: true,\n            currentProductId: 0,\n            dataScopeAssociatedProduct: 'data.associated_product_ids',\n            typeGrid: '',\n            product: {},\n            rowIndexForChange: undefined,\n            changeProductData: [],\n            modules: {\n                productsProvider: '${ $.productsProvider }',\n                productsColumns: '${ $.productsColumns }',\n                productsMassAction: '${ $.productsMassAction }',\n                modalWithGrid: '${ $.modalWithGrid }',\n                productsFilters: '${ $.productsFilters }'\n            },\n            exports: {\n                externalProviderParams: '${ $.externalProvider }:params'\n            },\n            links: {\n                changeProductData: '${ $.provider }:${ $.changeProductProvider }'\n            },\n            listens: {\n                '${ $.externalProvider }:params': '_setFilters _setVisibilityMassActionColumn',\n                '${ $.productsProvider }:data': '_handleManualGridOpening',\n                '${ $.productsMassAction }:selected': '_handleManualGridSelect'\n            }\n        },\n\n        /**\n         * Initialize observables.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(\n                'changeProductData'\n            );\n\n            return this;\n        },\n\n        /**\n         * Get ids of used products.\n         *\n         * @returns {Array}\n         */\n        getUsedProductIds: function () {\n            var usedProductsIds = this.source.get(this.dataScopeAssociatedProduct);\n\n            return usedProductsIds.slice();\n        },\n\n        /**\n         * Request for render content.\n         *\n         * @returns {Object}\n         */\n        doRender: function (showMassActionColumn, typeGrid) {\n            this.typeGrid = typeGrid;\n            this.showMassActionColumn = showMassActionColumn;\n\n            if (this.gridInitialized) {\n                this.paramsUpdated = false;\n                this.productsFilters().clear();\n                this._setFilters(this.externalProviderParams);\n                this._setVisibilityMassActionColumn();\n            }\n\n            return this.render();\n        },\n\n        /**\n         * Show grid with assigned product.\n         *\n         * @returns {Object}\n         */\n        showGridAssignProduct: function () {\n            this.product = {};\n            this.rowIndexForChange = undefined;\n\n            return this.doRender(true, 'assignProduct');\n        },\n\n        /**\n         * Show grid with changed product.\n         *\n         * @param {String} rowIndex\n         * @param {String} product\n         */\n        showGridChangeProduct: function (rowIndex, product) {\n            this.rowIndexForChange = rowIndex;\n            this.product = product;\n            this.doRender(false, 'changeProduct');\n        },\n\n        /**\n         * Select product.\n         *\n         * @param {String} rowIndex\n         */\n        selectProduct: function (rowIndex) {\n            this.changeProductData({\n                rowIndex: this.rowIndexForChange,\n                product: this.productsProvider().data.items[rowIndex]\n            });\n            this.modalWithGrid().closeModal();\n        },\n\n        /**\n         * Set visibility state for mass action column\n         *\n         * @private\n         */\n        _setVisibilityMassActionColumn: function () {\n            this.productsMassAction(function (massActionComponent) {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = this.showMassActionColumn;\n                }, this);\n                massActionComponent.visible = this.showMassActionColumn;\n            }.bind(this));\n        },\n\n        /**\n         * Set filters.\n         *\n         * @param {Object} params\n         * @private\n         */\n        _setFilters: function (params) {\n            var filterModifier = {},\n                attrCodes,\n                usedProductIds,\n                attributes;\n\n            params = _.omit(params);\n\n            if (!this.paramsUpdated) {\n                this.gridInitialized = true;\n                this.paramsUpdated = true;\n\n                attrCodes = this._getAttributesCodes();\n                usedProductIds = this.getUsedProductIds();\n\n                if (this.currentProductId) {\n                    usedProductIds.push(this.currentProductId);\n                }\n\n                filterModifier['entity_id'] = {\n                    'condition_type': 'nin', value: usedProductIds\n                };\n                attrCodes.each(function (code) {\n                    filterModifier[code] = {\n                        'condition_type': 'notnull'\n                    };\n                });\n\n                if (this.typeGrid === 'changeProduct') {\n                    attributes = JSON.parse(this.product.attributes);\n\n                    filterModifier = _.extend(filterModifier, _.mapObject(attributes, function (value) {\n                        return {\n                            'condition_type': 'eq',\n                            'value': value\n                        };\n                    }));\n\n                    params.filters = attributes;\n                } else {\n                    params.filters = {};\n                }\n\n                params['attributes_codes'] = attrCodes;\n\n                this.set('externalProviderParams', params);\n                this.set('externalFiltersModifier', filterModifier);\n            }\n        },\n\n        /**\n         * Get attribute codes.\n         *\n         * @returns {Array}\n         * @private\n         */\n        _getAttributesCodes: function () {\n            var attrCodes = this.source.get('data.attribute_codes');\n\n            return attrCodes ? attrCodes : [];\n        },\n\n        /**\n         * Get product variations.\n         *\n         * @returns {Array}\n         * @private\n         */\n        _getProductVariations: function () {\n            var matrix = this.source.get('data.configurable-matrix');\n\n            return matrix ? matrix : [];\n        },\n\n        /**\n         * Handle manual grid after opening\n         * @private\n         */\n        _handleManualGridOpening: function (data) {\n            if (data.items.length && this.typeGrid === 'assignProduct') {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = true;\n                });\n\n                this._disableRows(data.items);\n            }\n        },\n\n        /**\n         * Handle manual selection.\n         *\n         * @param {Array} selected\n         * @private\n         */\n        _handleManualGridSelect: function (selected) {\n            var selectedRows,\n                selectedVariationKeys;\n\n            if (this.typeGrid === 'assignProduct') {\n                selectedRows = _.filter(this.productsProvider().data.items, function (row) {\n                    return selected.indexOf(row['entity_id']) !== -1;\n                });\n                selectedVariationKeys = _.values(this._getVariationKeyMap(selectedRows));\n                this._disableRows(this.productsProvider().data.items, selectedVariationKeys, selected);\n            }\n        },\n\n        /**\n         * Disable rows in grid for products with the same variation key\n         *\n         * @param {Array} items\n         * @param {Array} selectedVariationKeys\n         * @param {Array} selected\n         * @private\n         */\n        _disableRows: function (items, selectedVariationKeys, selected) {\n            selectedVariationKeys = selectedVariationKeys === undefined ? [] : selectedVariationKeys;\n            selected = selected === undefined ? [] : selected;\n            this.productsMassAction(function (massaction) {\n                var configurableVariationKeys = _.union(\n                    selectedVariationKeys,\n                    _.pluck(this._getProductVariations(), 'variationKey')\n                    ),\n                    variationKeyMap = this._getVariationKeyMap(items),\n                    rowsForDisable = _.keys(_.pick(\n                        variationKeyMap,\n                        function (variationKey) {\n                            return configurableVariationKeys.indexOf(variationKey) !== -1;\n                        }\n                    ));\n\n                massaction.disabled(_.difference(rowsForDisable, selected));\n            }.bind(this));\n        },\n\n        /**\n         * Get variation key map used in manual grid.\n         *\n         * @param {Array} items\n         * @returns {Array} [{entity_id: variation-key}, ...]\n         * @private\n         */\n        _getVariationKeyMap: function (items) {\n            var variationKeyMap = {};\n\n            _.each(items, function (row) {\n                variationKeyMap[row['entity_id']] = _.values(\n                    _.pick(row, this._getAttributesCodes())\n                ).sort().join('-');\n\n            }, this);\n\n            return variationKeyMap;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/modal-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/modal-component',\n    'uiRegistry',\n    'underscore'\n], function (Modal, registry, _) {\n    'use strict';\n\n    return Modal.extend({\n        defaults: {\n            stepWizard: '',\n            modules: {\n                form: '${ $.formName }'\n            }\n        },\n\n        /**\n         * Open modal\n         */\n        openModal: function () {\n            var stepWizard = {};\n\n            this.form().validate();\n\n            if (this.form().source.get('params.invalid') === false) {\n                stepWizard = registry.get('index = ' + this.stepWizard);\n\n                if (!_.isUndefined(stepWizard)) {\n                    stepWizard.open();\n                }\n\n                this._super();\n            } else {\n                this.form().focusInvalid();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/custom-options-warning.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html'\n], function (Html) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            isConfigurable: false\n        },\n\n        /**\n         * Updates component visibility state.\n         *\n         * @param {Boolean} variationsEmpty\n         * @returns {Boolean}\n         */\n        updateVisibility: function (variationsEmpty) {\n            var isVisible = this.isConfigurable || !variationsEmpty;\n\n            this.visible(isVisible);\n\n            return isVisible;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/dynamic-rows-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows',\n    'jquery'\n], function (_, registry, dynamicRows, $) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            actionsListOpened: false,\n            canEditField: 'canEdit',\n            newProductField: 'newProduct',\n            dataScopeAssociatedProduct: 'data.associated_product_ids',\n            dataProviderFromGrid: '',\n            dataProviderChangeFromGrid: '',\n            insertDataFromGrid: [],\n            changeDataFromGrid: [],\n            dataProviderFromWizard: '',\n            insertDataFromWizard: [],\n            map: null,\n            isEmpty: true,\n            isShowAddProductButton: false,\n            cacheGridData: [],\n            unionInsertData: [],\n            deleteProperty: false,\n            dataLength: 0,\n            identificationProperty: 'id',\n            'attribute_set_id': '',\n            attributesTmp: [],\n            changedFlag: 'was_changed',\n            listens: {\n                'insertDataFromGrid': 'processingInsertDataFromGrid',\n                'insertDataFromWizard': 'processingInsertDataFromWizard',\n                'unionInsertData': 'processingUnionInsertData',\n                'changeDataFromGrid': 'processingChangeDataFromGrid',\n                'isEmpty': 'changeVisibility'\n            },\n            imports: {\n                'attribute_set_id': '${$.provider}:data.product.attribute_set_id'\n            },\n            'exports': {\n                'attribute_set_id': '${$.provider}:data.new-variations-attribute-set-id'\n            },\n            modules: {\n                modalWithGrid: '${ $.modalWithGrid }',\n                gridWithProducts: '${ $.gridWithProducts}'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super()\n                .changeVisibility(this.isEmpty());\n\n            return this;\n        },\n\n        /**\n         * Change visibility\n         *\n         * When isEmpty = true, then visbible = false\n         *\n         * @param {Boolean} isEmpty\n         */\n        changeVisibility: function (isEmpty) {\n            this.visible(!isEmpty);\n        },\n\n        /**\n         * Open modal with grid.\n         *\n         * @param {String} rowIndex\n         */\n        openModalWithGrid: function (rowIndex) {\n            var productSource = this.source.get(this.dataScope + '.' + this.index + '.' + rowIndex),\n                product = {\n                    'id': productSource.id,\n                    'attributes': productSource['configurable_attribute']\n                };\n\n            this.modalWithGrid().openModal();\n            this.gridWithProducts().showGridChangeProduct(rowIndex, product);\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            var tmpArray = [];\n\n            this.recordData.each(function (recordData) {\n                tmpArray.push(recordData);\n            }, this);\n\n            this.unionInsertData(tmpArray);\n\n            return this;\n        },\n\n        /**\n         * Delete record\n         *\n         * @param {Number} index - row index\n         */\n        deleteRecord: function (index) {\n            var tmpArray,\n                lastRecord;\n\n            this.reRender = false;\n            tmpArray = this.getUnionInsertData();\n            tmpArray.splice(index, 1);\n\n            if (!tmpArray.length) {\n                this.attributesTmp = this.source.get('data.attributes');\n                this.source.set('data.attributes', []);\n                this.cacheGridData = [];\n            }\n\n            if (parseInt(this.currentPage(), 10) === this.pages()) {\n                lastRecord =\n                    _.findWhere(this.elems(), {\n                        index: this.startIndex + this.getChildItems().length - 1\n                    }) ||\n                    _.findWhere(this.elems(), {\n                        index: (this.startIndex + this.getChildItems().length - 1).toString()\n                    });\n\n                lastRecord.destroy();\n            }\n\n            this.unionInsertData(tmpArray);\n\n            if (this.pages() < parseInt(this.currentPage(), 10)) {\n                this.currentPage(this.pages());\n            }\n\n            this.reRender = true;\n            this.showSpinner(false);\n        },\n\n        /**\n         * Generate associated products\n         */\n        generateAssociatedProducts: function () {\n            var productsIds = [];\n\n            this.getUnionInsertData().forEach(function (data) {\n                if (data.id !== null) {\n                    productsIds.push(data.id);\n                }\n            });\n\n            this.source.set(this.dataScopeAssociatedProduct, productsIds);\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'insertDataFromGrid', 'unionInsertData', 'isEmpty', 'isShowAddProductButton', 'actionsListOpened'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Get union insert data from source\n         *\n         * @returns {Array}\n         */\n        getUnionInsertData: function () {\n            var source = this.source.get(this.dataScope + '.' + this.index),\n                result = [];\n\n            _.each(source, function (data) {\n                result.push(data);\n            });\n\n            return result;\n        },\n\n        /**\n         * Process union insert data.\n         *\n         * @param {Array} data\n         */\n        processingUnionInsertData: function (data) {\n            var dataCount,\n                elemsCount,\n                tmpData,\n                path,\n                attributeCodes = this.source.get('data.attribute_codes');\n\n            this.isEmpty(data.length === 0);\n            this.isShowAddProductButton(\n                (!attributeCodes || data.length > 0 ? data.length : attributeCodes.length) > 0\n            );\n\n            tmpData = data.slice(this.pageSize * (this.currentPage() - 1),\n                                 this.pageSize * (this.currentPage() - 1) + parseInt(this.pageSize, 10));\n\n            this.source.set(this.dataScope + '.' + this.index, []);\n\n            _.each(tmpData, function (row, index) {\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + index);\n                row.attributes = $('<i></i>').text(row.attributes).html();\n                this.source.set(path, row);\n            }, this);\n\n            this.source.set(this.dataScope + '.' + this.index, data);\n            this.parsePagesData(data);\n\n            // Render\n            dataCount = tmpData.length;\n            elemsCount = this.elems().length;\n\n            if (dataCount > elemsCount) {\n                tmpData.each(function (elemData, index) {\n                    this.addChild(elemData, this.startIndex + index);\n                }, this);\n            } else {\n                for (elemsCount; elemsCount > dataCount; elemsCount--) {\n                    this.elems()[elemsCount - 1].destroy();\n                }\n            }\n\n            this.generateAssociatedProducts();\n        },\n\n        /**\n         * Set initial property to records data\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialProperty: function () {\n            return this;\n        },\n\n        /**\n         * Parsed data\n         *\n         * @param {Array} data - array with data\n         * about selected records\n         */\n        processingInsertDataFromGrid: function (data) {\n            var changes,\n                tmpArray;\n\n            if (!data.length) {\n                return;\n            }\n\n            tmpArray = this.getUnionInsertData();\n\n            changes = this._checkGridData(data);\n            this.cacheGridData = data;\n\n            changes.each(function (changedObject) {\n                var mappedData = this.mappingValue(changedObject);\n\n                mappedData[this.canEditField] = 0;\n                mappedData[this.newProductField] = 0;\n                mappedData.variationKey = this._getVariationKey(changedObject);\n                mappedData['configurable_attribute'] = this._getConfigurableAttribute(changedObject);\n                tmpArray.push(mappedData);\n            }, this);\n\n            // Attributes cannot be changed before regeneration thought wizard\n            if (!this.source.get('data.attributes').length) {\n                this.source.set('data.attributes', this.attributesTmp);\n            }\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         * Process changes from grid.\n         *\n         * @param {Object} data\n         */\n        processingChangeDataFromGrid: function (data) {\n            var tmpArray = this.getUnionInsertData(),\n                mappedData = this.mappingValue(data.product);\n\n            mappedData[this.canEditField] = 0;\n            mappedData[this.newProductField] = 0;\n            mappedData.variationKey = this._getVariationKey(data.product);\n            mappedData['configurable_attribute'] = this._getConfigurableAttribute(data.product);\n            tmpArray[data.rowIndex] = mappedData;\n\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         * Get variation key.\n         *\n         * @param {Object} data\n         * @returns {String}\n         * @private\n         */\n        _getVariationKey: function (data) {\n            var attrCodes = this.source.get('data.attribute_codes'),\n                key = [];\n\n            attrCodes.each(function (code) {\n                key.push(data[code]);\n            });\n\n            return key.sort().join('-');\n        },\n\n        /**\n         * Get configurable attribute.\n         *\n         * @param {Object} data\n         * @returns {String}\n         * @private\n         */\n        _getConfigurableAttribute: function (data) {\n            var attrCodes = this.source.get('data.attribute_codes'),\n                confAttrs = {};\n\n            attrCodes.each(function (code) {\n                confAttrs[code] = data[code];\n            });\n\n            return JSON.stringify(confAttrs);\n        },\n\n        /**\n         * Process data insertion from wizard\n         *\n         * @param {Object} data\n         */\n        processingInsertDataFromWizard: function (data) {\n            var tmpArray = this.getUnionInsertData(),\n                productIdsToDelete = this.source.get(this.dataScopeAssociatedProduct),\n                index,\n                product = {};\n\n            tmpArray = this.unsetArrayItem(\n                tmpArray,\n                {\n                    id: null\n                }\n            );\n\n            _.each(data, function (row) {\n                if (row.productId) {\n                    index = _.indexOf(productIdsToDelete, row.productId);\n\n                    if (index > -1) {\n                        productIdsToDelete.splice(index, 1);\n                        tmpArray = this.unsetArrayItem(\n                            tmpArray,\n                            {\n                                id: row.productId\n                            }\n                        );\n                    }\n                }\n                product = this.getProductData(row);\n\n                product[this.changedFlag] = true;\n                product[this.canEditField] = row.editable;\n                product[this.newProductField] = row.newProduct;\n                tmpArray.push(product);\n            }, this);\n\n            _.each(productIdsToDelete, function (id) {\n                tmpArray = this.unsetArrayItem(\n                    tmpArray,\n                    {\n                        id: id\n                    }\n                );\n            }, this);\n\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         *\n         * @param {Object} row\n         * @returns {Object}\n         */\n        getProductData: function (row) {\n            var product,\n                attributesText = '';\n\n            _.each(row.options, function (attribute) {\n                if (attributesText) {\n                    attributesText += ', ';\n                }\n                attributesText += attribute['attribute_label'] + ': ' + attribute.label;\n            }, this);\n\n            product = {\n                'id': row.productId,\n                'product_link': row.productUrl,\n                'name': $('<i></i>').text(row.name).html(),\n                'sku': row.sku,\n                'status': row.status,\n                'price': row.price,\n                'price_currency': row.priceCurrency,\n                'price_string': row.priceCurrency + row.price,\n                'weight': row.weight,\n                'qty': row.quantity,\n                'variationKey': row.variationKey,\n                'configurable_attribute': row.attribute,\n                'thumbnail_image': row.images.preview,\n                'media_gallery': row['media_gallery'],\n                'swatch_image': row['swatch_image'],\n                'small_image': row['small_image'],\n                image: row.image,\n                'thumbnail': row.thumbnail,\n                'attributes': attributesText\n            };\n\n            return product;\n        },\n\n        /**\n         * Remove array items matching condition.\n         *\n         * @param {Array} data\n         * @param {Object} condition\n         * @returns {Array}\n         */\n        unsetArrayItem: function (data, condition) {\n            var objs = _.where(data, condition);\n\n            _.each(objs, function (obj) {\n                var index = _.indexOf(data, obj);\n\n                if (index > -1) {\n                    data.splice(index, 1);\n                }\n            });\n\n            return data;\n        },\n\n        /**\n         * Check changed records\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                max = cacheLength > curData ? this.cacheGridData : data,\n                changes = [],\n                obj = {};\n\n            max.each(function (record, index) {\n                obj[this.map.id] = record[this.map.id];\n\n                if (!_.where(this.cacheGridData, obj).length) {\n                    changes.push(data[index]);\n                }\n            }, this);\n\n            return changes;\n        },\n\n        /**\n         * Mapped value\n         */\n        mappingValue: function (data) {\n            var result = {};\n\n            _.each(this.map, function (prop, index) {\n                result[index] = data[prop];\n            });\n\n            return result;\n        },\n\n        /**\n         * Toggle actions list.\n         *\n         * @param {Number} rowIndex\n         * @returns {Object} Chainable.\n         */\n        toggleActionsList: function (rowIndex) {\n            var state = false;\n\n            if (rowIndex !== this.actionsListOpened()) {\n                state = rowIndex;\n            }\n            this.actionsListOpened(state);\n\n            return this;\n        },\n\n        /**\n         * Close action list.\n         *\n         * @param {Number} rowIndex\n         * @returns {Object} Chainable\n         */\n        closeList: function (rowIndex) {\n            if (this.actionsListOpened() === rowIndex) {\n                this.actionsListOpened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggle product status.\n         *\n         * @param {Number} rowIndex\n         */\n        toggleStatusProduct: function (rowIndex) {\n            var tmpArray = this.getUnionInsertData(),\n                status = parseInt(tmpArray[rowIndex].status, 10);\n\n            if (status === 1) {\n                tmpArray[rowIndex].status = 2;\n            } else {\n                tmpArray[rowIndex].status = 1;\n            }\n\n            tmpArray[rowIndex][this.changedFlag] = true;\n            this.unionInsertData(tmpArray);\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/price-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, registry, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                isConfigurable: '!ns = ${ $.ns }, index = configurable-matrix:isEmpty'\n            },\n            modules: {\n                createConfigurableButton: '${$.createConfigurableButton}'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            // resolve initial disable state\n            this.handlePriceValue(this.isConfigurable);\n            // add listener to track \"configurable\" type\n            this.setListeners({\n                isConfigurable: 'handlePriceValue'\n            });\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['content']);\n\n            return this;\n        },\n\n        /**\n         * Disable and clear price if product type changed to configurable\n         *\n         * @param {String} isConfigurable\n         */\n        handlePriceValue: function (isConfigurable) {\n            this.disabled(!!this.isUseDefault() || isConfigurable);\n            this.required(!!this.isUseDefault() || !isConfigurable);\n\n            if (isConfigurable) {\n                this.clear();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/variations.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'uiRegistry',\n    'mage/translate'\n], function (Component, $, ko, _, alert, registry, $t) {\n    'use strict';\n\n    /**\n     * @param {*} message\n     * @constructor\n     */\n    function UserException(message) {\n        this.message = message;\n        this.name = 'UserException';\n    }\n    UserException.prototype = Object.create(Error.prototype);\n\n    return Component.extend({\n        defaults: {\n            opened: false,\n            attributes: [],\n            usedAttributes: [],\n            attributeCodes: [],\n            attributesData: {},\n            productMatrix: [],\n            variations: [],\n            formSaveParams: [],\n            productAttributes: [],\n            disabledAttributes: [],\n            fullAttributes: [],\n            rowIndexToEdit: false,\n            productAttributesMap: null,\n            value: [],\n            modules: {\n                associatedProductGrid: '${ $.configurableProductGrid }',\n                wizardButtonElement: '${ $.wizardModalButtonName }',\n                formElement: '${ $.formName }',\n                attributeSetHandlerModal: '${ $.attributeSetHandler }'\n            },\n            imports: {\n                attributeSetName: '${ $.provider }:configurableNewAttributeSetName',\n                attributeSetId: '${ $.provider }:configurableExistingAttributeSetId',\n                attributeSetSelection: '${ $.provider }:configurableAffectedAttributeSet',\n                productPrice: '${ $.provider }:data.product.price'\n            },\n            links: {\n                value: '${ $.provider }:${ $.dataScopeVariations }',\n                usedAttributes: '${ $.provider }:${ $.dataScopeAttributes }',\n                attributesData: '${ $.provider }:${ $.dataScopeAttributesData }',\n                attributeCodes: '${ $.provider }:${ $.dataScopeAttributeCodes }',\n                skeletonAttributeSet: '${ $.provider }:data.new-variations-attribute-set-id'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.changeButtonWizard();\n            this.initProductAttributesMap();\n            this.disableConfigurableAttributes(this.productAttributes);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(\n                'actions opened attributes productMatrix value usedAttributes attributesData attributeCodes'\n            );\n\n            return this;\n        },\n\n        /**\n         * @param {Object} product\n         * @return {Object}\n         * @private\n         */\n        _makeProduct: function (product) {\n            var productId = product['entity_id'] || product.productId || null,\n                attributes = _.pick(product, this.attributes.pluck('code')),\n                options = _.map(attributes, function (option, attribute) {\n                    var oldOptions = _.findWhere(this.attributes(), {\n                            code: attribute\n                        }).options,\n                        result;\n\n                    if (_.isFunction(oldOptions)) {\n                        result = oldOptions.findWhere({\n                            value: option\n                        });\n                    } else {\n                        result = _.findWhere(oldOptions, {\n                            value: option\n                        });\n                    }\n\n                    return result;\n                }.bind(this));\n\n            return {\n                attribute: JSON.stringify(attributes),\n                editable: false,\n                images: {\n                    preview: product['thumbnail_src']\n                },\n                name: product.name || product.sku,\n                options: options,\n                price: parseFloat(Math.round(product.price.replace(/[^\\d.]+/g, '') + 'e+4') + 'e-4').toFixed(4),\n                productId: productId,\n                productUrl: this.buildProductUrl(productId),\n                quantity: product.quantity || null,\n                sku: product.sku,\n                status: product.status === undefined ? 1 : parseInt(product.status, 10),\n                variationKey: this.getVariationKey(options),\n                weight: product.weight || null\n            };\n        },\n\n        /**\n         * @param {String} name\n         * @return {String|Number|Array}\n         */\n        getProductValue: function (name) {\n            name = name.split('/').join('][');\n\n            return $('[name=\"product[' + name + ']\"]:enabled:not(.ignore-validate)', this.productForm).val();\n        },\n\n        /**\n         * @param {Object} data\n         * @param {String} field\n         * @return {String}\n         */\n        getRowId: function (data, field) {\n            var key = data.variationKey;\n\n            return 'variations-matrix-' + key + '-' + field;\n        },\n\n        /**\n         * @param {Object} variation\n         * @param {String} field\n         * @return {String}\n         */\n        getVariationRowName: function (variation, field) {\n            var result;\n\n            if (variation.productId) {\n                result = 'configurations[' + variation.productId + '][' + field.split('/').join('][') + ']';\n            } else {\n                result = 'variations-matrix[' + variation.variationKey + '][' + field.split('/').join('][') + ']';\n            }\n\n            return result;\n        },\n\n        /**\n         * @param {*} variations\n         * @param {*} attributes\n         */\n        render: function (variations, attributes) {\n            this.changeButtonWizard();\n            this.populateVariationMatrix(variations);\n            this.attributes(attributes);\n            this.disableConfigurableAttributes(attributes);\n            this.handleValue(variations);\n            this.handleAttributes();\n        },\n\n        /**\n         * Change button wizard.\n         */\n        changeButtonWizard: function () {\n            if (this.variations.length) {\n                this.wizardButtonElement().title(this.wizardModalButtonTitle);\n            }\n        },\n\n        /**\n         * @param {Array} variations\n         */\n        handleValue: function (variations) {\n            var tmpArray = [];\n\n            _.each(variations, function (variation) {\n                var attributes = _.reduce(variation.options, function (memo, option) {\n                    var attribute = {};\n\n                    attribute[option['attribute_code']] = option.value;\n\n                    return _.extend(memo, attribute);\n                }, {}),\n                    gallery = {\n                        images: {}\n                    },\n                    types = {};\n\n                _.each(variation.images.images, function (image) {\n                    gallery.images[image['file_id']] = {\n                        position: image.position,\n                        file: image.file,\n                        disabled: image.disabled,\n                        label: image.label || ''\n                    };\n                    _.each(image.galleryTypes, function (type) {\n                        types[type] = image.file;\n                    });\n                }, this);\n\n                tmpArray.push(_.extend(variation, types, {\n                    productId: variation.productId || null,\n                    name: variation.name || variation.sku,\n                    priceCurrency: this.currencySymbol,\n                    weight: variation.weight,\n                    attribute: JSON.stringify(attributes),\n                    variationKey: this.getVariationKey(variation.options),\n                    editable: variation.editable === undefined ? 0 : 1,\n                    productUrl: this.buildProductUrl(variation.productId),\n                    status: variation.status === undefined ? 1 : parseInt(variation.status, 10),\n                    newProduct: variation.productId ? 0 : 1,\n                    'media_gallery': gallery\n                }));\n            }, this);\n\n            this.value(tmpArray);\n        },\n\n        /**\n         * Handle attributes.\n         */\n        handleAttributes: function () {\n            var tmpArray = [],\n                codesArray = [],\n                tmpOptions = {},\n                option = {},\n                position = 0,\n                values = {};\n\n            _.each(this.attributes(), function (attribute) {\n                tmpArray.push(attribute.id);\n                codesArray.push(attribute.code);\n                values = {};\n                _.each(attribute.chosen, function (row) {\n                    values[row.value] = {\n                        'include': '1',\n                        'value_index': row.value\n                    };\n                }, this);\n                option = {\n                    'attribute_id': attribute.id,\n                    'code': attribute.code,\n                    'label': attribute.label,\n                    'position': position,\n                    'values': values\n                };\n                tmpOptions[attribute.id] = option;\n                position++;\n            }, this);\n\n            this.attributesData(tmpOptions);\n            this.usedAttributes(tmpArray);\n            this.attributeCodes(codesArray);\n        },\n\n        /**\n         * Get attributes options\n         * @see use in matrix.phtml\n         *\n         * @returns {Array}\n         */\n        getAttributesOptions: function () {\n            return this.showVariations() ? this.productMatrix()[0].options : [];\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        showVariations: function () {\n            return this.productMatrix().length > 0;\n        },\n\n        /**\n         * @param {Array} variations\n         */\n        populateVariationMatrix: function (variations) {\n            this.productMatrix([]);\n            _.each(variations, function (variation) {\n                var attributes = _.reduce(variation.options, function (memo, option) {\n                    var attribute = {};\n\n                    attribute[option['attribute_code']] = option.value;\n\n                    return _.extend(memo, attribute);\n                }, {});\n\n                this.productMatrix.push(_.extend(variation, {\n                    productId: variation.productId || null,\n                    name: variation.name || variation.sku,\n                    weight: variation.weight,\n                    attribute: JSON.stringify(attributes),\n                    variationKey: this.getVariationKey(variation.options),\n                    editable: variation.editable === undefined ? !variation.productId : variation.editable,\n                    productUrl: this.buildProductUrl(variation.productId),\n                    status: variation.status === undefined ? 1 : parseInt(variation.status, 10)\n                }));\n            }, this);\n        },\n\n        /**\n         * @param {*} productId\n         */\n        buildProductUrl: function (productId) {\n            return this.productUrl.replace('%id%', productId);\n        },\n\n        /**\n         * @param {Object} options\n         * @return {String}\n         */\n        getVariationKey: function (options) {\n            return _.pluck(options, 'value').sort().join('-');\n        },\n\n        /**\n         * @param {*} options\n         * @return {*|null}\n         */\n        getProductIdByOptions: function (options) {\n            return this.productAttributesMap[this.getVariationKey(options)] || null;\n        },\n\n        /**\n         * Init product attributes map\n         */\n        initProductAttributesMap: function () {\n            if (this.productAttributesMap === null) {\n                this.productAttributesMap = {};\n                _.each(this.variations, function (product) {\n                    this.productAttributesMap[this.getVariationKey(product.options)] = product.productId;\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @param {Array} attributes\n         */\n        disableConfigurableAttributes: function (attributes) {\n            var element;\n\n            _.each(this.disabledAttributes, function (attribute) {\n                registry.get('inputName = ' + 'product[' + attribute + ']').disabled(false);\n            });\n            this.disabledAttributes = [];\n\n            _.each(attributes, function (attribute) {\n                element = registry.get('inputName = ' + 'product[' + attribute.code + ']');\n\n                if (!_.isUndefined(element)) {\n                    element.disabled(true);\n                    this.disabledAttributes.push(attribute.code);\n                }\n            }, this);\n        },\n\n        /**\n         * Get currency symbol\n         * @returns {String}\n         */\n        getCurrencySymbol: function () {\n            return this.currencySymbol;\n        },\n\n        /**\n         * Chose action for the form save button\n         */\n        saveFormHandler: function () {\n            this.formElement().validate();\n\n            if (this.formElement().source.get('params.invalid') === false) {\n                this.serializeData();\n            }\n\n            if (this.checkForNewAttributes()) {\n                this.formSaveParams = arguments;\n                this.attributeSetHandlerModal().openModal();\n            } else {\n                if (this.validateForm(this.formElement())) {\n                    this.clearOutdatedData();\n                }\n                this.formElement().save(arguments[0], arguments[1]);\n\n                if (this.formElement().source.get('params.invalid')) {\n                    this.unserializeData();\n                }\n            }\n        },\n\n        /**\n         * @param {Object} formElement\n         *\n         * Validates each form element and returns true, if all elements are valid.\n         */\n        validateForm: function (formElement) {\n            formElement.validate();\n\n            return !formElement.additionalInvalid && !formElement.source.get('params.invalid');\n        },\n\n        /**\n         * Serialize data for specific form fields\n         *\n         * Serializes some complex data fields\n         *\n         * Original fields:\n         *   - configurable-matrix;\n         *   - associated_product_ids.\n         *\n         * Serialized fields in request:\n         *   - configurable-matrix-serialized;\n         *   - associated_product_ids_serialized.\n         */\n        serializeData: function () {\n            if (this.source.data['configurable-matrix']) {\n                this.source.data['configurable-matrix-serialized'] =\n                    JSON.stringify(this.source.data['configurable-matrix']);\n            }\n\n            if (this.source.data['associated_product_ids']) {\n                this.source.data['associated_product_ids_serialized'] =\n                    JSON.stringify(this.source.data['associated_product_ids']);\n            }\n        },\n\n        /**\n         * Clear outdated data for specific form fields\n         *\n         * Outdated fields:\n         *   - configurable-matrix;\n         *   - associated_product_ids.\n         */\n        clearOutdatedData: function () {\n            if (this.source.data['configurable-matrix']) {\n                delete this.source.data['configurable-matrix'];\n            }\n\n            if (this.source.data['associated_product_ids']) {\n                delete this.source.data['associated_product_ids'];\n            }\n        },\n\n        /**\n         * Unserialize data for specific form fields\n         *\n         * Unserializes some fields that were serialized this.serializeData\n         */\n        unserializeData: function () {\n            if (this.source.data['configurable-matrix-serialized']) {\n                this.source.data['configurable-matrix'] =\n                    JSON.parse(this.source.data['configurable-matrix-serialized']);\n                delete this.source.data['configurable-matrix-serialized'];\n            }\n\n            if (this.source.data['associated_product_ids_serialized']) {\n                this.source.data['associated_product_ids'] =\n                    JSON.parse(this.source.data['associated_product_ids_serialized']);\n                delete this.source.data['associated_product_ids_serialized'];\n            }\n        },\n\n        /**\n         * Check for newly added attributes\n         * @returns {Boolean}\n         */\n        checkForNewAttributes: function () {\n            var element, newAttributes = false;\n\n            _.each(this.source.get('data.attribute_codes'), function (attribute) {\n                element = registry.get('index = ' + attribute);\n\n                if (_.isUndefined(element)) {\n                    newAttributes = true;\n                }\n            }, this);\n\n            return newAttributes;\n        },\n\n        /**\n         * New attributes handler\n         * @returns {Boolean}\n         */\n        addNewAttributeSetHandler: function () {\n            var chosenAttributeSetOption;\n\n            this.formElement().validate();\n\n            if (this.formElement().source.get('params.invalid') === false) {\n                chosenAttributeSetOption = this.attributeSetSelection;\n\n                if (chosenAttributeSetOption === 'new') {\n                    this.createNewAttributeSet();\n\n                    return false;\n                }\n\n                if (chosenAttributeSetOption === 'existing') {\n                    this.set(\n                        'skeletonAttributeSet',\n                        this.attributeSetId\n                    );\n                }\n\n                this.closeDialogAndProcessForm();\n\n                return true;\n            }\n\n            this.unserializeData();\n\n            return false;\n        },\n\n        /**\n         * Handles new attribute set creation\n         * @returns {Boolean}\n         */\n        createNewAttributeSet: function () {\n            var messageBoxElement = registry.get('index = affectedAttributeSetError');\n\n            messageBoxElement.visible(false);\n\n            $.ajax({\n                type: 'POST',\n                url: this.attributeSetCreationUrl,\n                data: {\n                    gotoEdit: 1,\n                    'attribute_set_name': this.attributeSetName,\n                    'skeleton_set': this.skeletonAttributeSet,\n                    'return_session_messages_only': 1\n                },\n                dataType: 'json',\n                showLoader: true,\n                context: this\n            }).done(function (data) {\n                if (!data.error) {\n                    this.set(\n                        'skeletonAttributeSet',\n                        data.id\n                    );\n                    messageBoxElement.content(data.messages);\n                    messageBoxElement.visible(true);\n                    this.closeDialogAndProcessForm();\n                } else {\n                    messageBoxElement.content(data.messages);\n                    messageBoxElement.visible(true);\n                }\n\n                return false;\n            }).fail(function (xhr) {\n                if (xhr.statusText === 'abort') {\n                    return;\n                }\n\n                alert({\n                    content: $t('Something went wrong.')\n                });\n            });\n\n            return false;\n        },\n\n        /**\n         * Closes attribute set handler modal and process product form\n         */\n        closeDialogAndProcessForm: function () {\n            this.attributeSetHandlerModal().closeModal();\n            this.formElement().save(this.formSaveParams[0], this.formSaveParams[1]);\n        },\n\n        /**\n         * Retrieves product price\n         * @returns {*}\n         */\n        getProductPrice: function () {\n            return this.productPrice;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/product-grid.js":"// jscs:disable requireDotNotation\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_Ui/js/core/app',\n    'underscore',\n    'notification',\n    'mage/translate'\n], function (Component, $, bootstrap, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            productsGridUrl: null,\n            productAttributes: [],\n            productsModal: null,\n            button: '',\n            gridSelector: '[data-grid-id=associated-products-container]',\n            modules: {\n                productsFilter: '${ $.productsFilter }',\n                productsProvider: '${ $.productsProvider }',\n                productsMassAction: '${ $.productsMassAction }',\n                productsColumns: '${ $.productsColumns }',\n                variationsComponent: '${ $.configurableVariations }'\n            },\n            listens: {\n                '${ $.productsProvider }:data': '_showMessageAssociatedGrid _handleManualGridOpening',\n                '${ $.productsMassAction }:selected': '_handleManualGridSelect',\n                '${ $.configurableVariations }:productMatrix': '_showButtonAddManual _switchProductType'\n            }\n        },\n\n        /**\n         * Initialize\n         *\n         * @param {Array} options\n         */\n        initialize: function (options) {\n            this._super(options);\n            this.productsModal = $(this.gridSelector).modal({\n                title: $.mage.__('Select Associated Product'),\n                type: 'slide',\n                buttons: [\n                    {\n                        text: $.mage.__('Cancel'),\n\n                        /** Close modal */\n                        click: function () {\n                            this.closeModal();\n                        }\n                    }, {\n                        text: $.mage.__('Done'),\n                        click: this.close.bind(this, null)\n                    }\n                ]\n            });\n\n            this.productsProvider(function () {\n                this.productsModal.notification();\n            }.bind(this));\n            this.variationsComponent(function (variation) {\n                this._showButtonAddManual(variation.productMatrix());\n            }.bind(this));\n\n            this._initGrid = _.once(this._initGrid);\n            this._switchProductType = _.wrap(this._switchProductType.bind(this), function (func, params) {\n                if (!!params.length !== !!this.init) {\n                    this.init = !!params.length;\n                    func(params);\n                }\n            }.bind(this._switchProductType));\n        },\n\n        /**\n         * Initial observerable\n         * @returns {*}\n         */\n        initObservable: function () {\n            this._super().observe('button');\n\n            return this;\n        },\n\n        /**\n         * init Grid\n         * @private\n         */\n        _initGrid: function (filterData) {\n            $.ajax({\n                type: 'GET',\n                url: this._buildGridUrl(filterData),\n                context: $('body')\n            }).done(function (data) {\n                bootstrap(JSON.parse(data));\n            });\n        },\n\n        /**\n         * Select different product in configurations section\n         * @see configurable_associated_product_listing.xml\n         * @param {Integer} rowIndex\n         */\n        selectProduct: function (rowIndex) {\n            this.close(rowIndex);\n        },\n\n        /**\n         * Open\n         * @param {Object} filterData - filter data\n         * @param {Object|*} filterData.filters - attribute name\n         * @param {Object|*} filterData.filters_modifier - modifier value\n         * @param {String} callbackName\n         * @param {Boolean} showMassActionColumn\n         */\n        open: function (filterData, callbackName, showMassActionColumn) {\n            this.callbackName = callbackName;\n            this.productsMassAction(function (massActionComponent) {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = showMassActionColumn;\n                });\n                massActionComponent.visible = showMassActionColumn;\n            }.bind(this));\n            this._setFilter(filterData);\n            this._initGrid(filterData);\n            this.productsModal.trigger('openModal');\n        },\n\n        /**\n         * Close\n         */\n        close: function (rowIndex) {\n            try {\n                if (this.productsMassAction().selected.getLength()) {\n                    this.variationsComponent()[this.callbackName](this.productsMassAction()\n                        .selected.map(this.getProductById.bind(this)));\n                    this.productsMassAction().deselectAll();\n                } else if (!_.isNull(rowIndex)) {\n                    this.variationsComponent()[this.callbackName]([this.getProductByIndex(rowIndex)]);\n                }\n                this.productsModal.trigger('closeModal');\n            } catch (e) {\n                if (e.name === 'UserException') {\n                    this.productsModal.notification('clear');\n                    this.productsModal.notification('add', {\n                        message: e.message,\n                        messageContainer: this.gridSelector\n                    });\n                } else {\n                    throw e;\n                }\n            }\n        },\n\n        /**\n         * Get product by id\n         * @param {Integer} productId\n         * @returns {*}\n         */\n        getProductById: function (productId) {\n            return _.findWhere(this.productsProvider().data.items, {\n                'entity_id': productId\n            });\n        },\n\n        /**\n         * Get product\n         * @param {Integer} rowIndex\n         * @returns {*}\n         */\n        getProductByIndex: function (rowIndex) {\n            return this.productsProvider().data.items[rowIndex];\n        },\n\n        /**\n         * Build grid url\n         * @private\n         */\n        _buildGridUrl: function (filterData) {\n            var params = '?' + $.param({\n                'filters': filterData.filters,\n                'attributes_codes': this._getAttributesCodes(),\n                'filters_modifier': filterData['filters_modifier']\n            });\n\n            return this.productsGridUrl + params;\n        },\n\n        /**\n         * Show button add manual\n         * @param {Array} variations\n         * @returns {*}\n         * @private\n         */\n        _showButtonAddManual: function (variations) {\n            return this.button(variations.length);\n        },\n\n        /**\n         * @param {Array} variations\n         * @private\n         */\n        _switchProductType: function (variations) {\n            $(document).trigger('changeConfigurableTypeProduct', variations.length);\n        },\n\n        /**\n         * Get attributes codes used for configurable\n         * @private\n         */\n        _getAttributesCodes: function () {\n            return this.variationsComponent().attributes.pluck('code');\n        },\n\n        /**\n         * Show data associated grid\n         * @private\n         */\n        _showMessageAssociatedGrid: function (data) {\n            this.productsModal.notification('clear');\n\n            if (data.items.length) {\n                this.productsModal.notification('add', {\n                    message: $.mage.__('Choose a new product to delete and replace the current product configuration.'),\n                    messageContainer: this.gridSelector\n                });\n            } else {\n                this.productsModal.notification('add', {\n                    message: $.mage.__('For better results, add attributes and attribute values to your products.'),\n                    messageContainer: this.gridSelector\n                });\n            }\n        },\n\n        /**\n         * Show manually grid\n         */\n        showManuallyGrid: function () {\n            var filterModifier = _.mapObject(_.object(this._getAttributesCodes(), []), function () {\n                    return {\n                        'condition_type': 'notnull'\n                    };\n                }),\n                usedProductIds = _.values(this.variationsComponent().productAttributesMap);\n\n            if (usedProductIds && usedProductIds.length > 0) {\n                filterModifier['entity_id'] = {\n                    'condition_type': 'nin', value: usedProductIds\n                };\n            }\n\n            this.open(\n                {\n                    'filters_modifier': filterModifier\n                },\n                'appendProducts',\n                true\n            );\n        },\n\n        /**\n         * Handle manual grid after opening\n         * @private\n         */\n        _handleManualGridOpening: function (data) {\n            if (data.items.length && this.callbackName == 'appendProducts') { //eslint-disable-line eqeqeq\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = true;\n                });\n\n                this._disableRows(data.items);\n            }\n        },\n\n        /**\n         * Disable rows in grid for products with the same variation key\n         *\n         * @param {Array} items\n         * @param {Array} selectedVariationKeys\n         * @param {Array} selected\n         * @private\n         */\n        _disableRows: function (items, selectedVariationKeys, selected) {\n            selectedVariationKeys = selectedVariationKeys === undefined ? [] : selectedVariationKeys;\n            selected = selected === undefined ? [] : selected;\n            this.productsMassAction(function (massaction) {\n                var configurableVariationKeys = _.union(\n                        selectedVariationKeys,\n                        _.pluck(this.variationsComponent().productMatrix(), 'variationKey')\n                    ),\n                    variationKeyMap = this._getVariationKeyMap(items),\n                    rowsForDisable = _.keys(_.pick(\n                        variationKeyMap,\n                        function (variationKey) {\n                            return configurableVariationKeys.indexOf(variationKey) !== -1;\n                        }\n                    ));\n\n                massaction.disabled(_.difference(rowsForDisable, selected));\n            }.bind(this));\n        },\n\n        /**\n         * @private\n         */\n        _handleManualGridSelect: function (selected) {\n            var selectedRows, selectedVariationKeys;\n\n            if (this.callbackName == 'appendProducts') { //eslint-disable-line eqeqeq\n                selectedRows = _.filter(this.productsProvider().data.items, function (row) {\n                    return selected.indexOf(row['entity_id']) !== -1;\n                });\n                selectedVariationKeys = _.values(this._getVariationKeyMap(selectedRows));\n                this._disableRows(this.productsProvider().data.items, selectedVariationKeys, selected);\n            }\n        },\n\n        /**\n         * Get variation key map used in manual grid.\n         *\n         * @param {Object} items\n         * @returns {Array} [{entity_id: variation-key}, ...]\n         * @private\n         */\n        _getVariationKeyMap: function (items) {\n            this._variationKeyMap = {};\n\n            _.each(items, function (row) {\n                this._variationKeyMap[row['entity_id']] = _.values(\n                    _.pick(row, this._getAttributesCodes())\n                ).sort().join('-');\n\n            }, this);\n\n            return this._variationKeyMap;\n        },\n\n        /**\n         * Set filter\n         * @private\n         */\n        _setFilter: function (filterData) {\n            this.productsProvider(function (provider) {\n                provider.params['filters_modifier'] = filterData['filters_modifier'];\n                provider.params['attributes_codes'] = this._getAttributesCodes();\n            }.bind(this));\n\n            this.productsFilter(function (filter) {\n                filter.set('filters', _.extend({\n                    'filters_modifier': filterData['filters_modifier']\n                }, filterData.filters))\n                    .apply();\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY, byteConvert */\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/lib/collapsible',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Catalog/js/product-gallery',\n    'jquery/file-uploader',\n    'mage/translate',\n    'Magento_ConfigurableProduct/js/variations/variations'\n], function (Component, $, ko, _, Collapsible, mageTemplate, alert) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            modules: {\n                variationsComponent: '${ $.variationsComponent }'\n            },\n            countVariations: 0,\n            attributes: [],\n            sections: {},\n            images: null,\n            price: '',\n            quantity: '',\n            notificationMessage: {\n                text: null,\n                error: null\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe('countVariations attributes sections');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n            this.sections({\n                images: {\n                    label: 'images',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable()\n                },\n                price: {\n                    label: 'price',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable(),\n                    currencySymbol: ''\n                },\n                quantity: {\n                    label: 'quantity',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable()\n                }\n            });\n\n            this.variationsComponent(function (variationsComponent) {\n                this.sections().price.currencySymbol = variationsComponent.getCurrencySymbol();\n            }.bind(this));\n\n            /**\n             * Make options sections.\n             */\n            this.makeOptionSections = function () {\n                return {\n                    images: new this.makeImages(null),\n                    price: this.price,\n                    quantity: this.quantity\n                };\n            }.bind(this);\n\n            /**\n             * @param {Object} images\n             * @param {*} typePreview\n             */\n            this.makeImages = function (images, typePreview) {\n                var preview;\n\n                if (!images) {\n                    this.images = [];\n                    this.preview = self.noImage;\n                    this.file = null;\n                } else {\n                    this.images = images;\n                    preview = _.find(this.images, function (image) {\n                        return _.contains(image.galleryTypes, typePreview);\n                    });\n\n                    if (preview) {\n                        this.file = preview.file;\n                        this.preview = preview.url;\n                    } else {\n                        this.file = null;\n                        this.preview = self.noImage;\n                    }\n                }\n            };\n            this.images = new this.makeImages();\n            _.each(this.sections(), function (section) {\n                section.type.subscribe(function () {\n                    this.setWizardNotifyMessageDependOnSectionType();\n                }.bind(this));\n            }, this);\n        },\n        types: ['each', 'single', 'none'],\n\n        /**\n         * Set Wizard notify message depend on section type\n         */\n        setWizardNotifyMessageDependOnSectionType: function () {\n            var flag = false;\n\n            _.each(this.sections(), function (section) {\n                if (section.type() !== 'none') {\n                    flag = true;\n                }\n            }, this);\n\n            if (flag) {\n                this.wizard.setNotificationMessage(\n                    $.mage.__('Choose this option to delete and replace extension data for all past configurations.')\n                );\n            } else {\n                this.wizard.cleanNotificationMessage();\n            }\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.attributes(wizard.data.attributes());\n\n            if (this.mode === 'edit') {\n                this.setWizardNotifyMessageDependOnSectionType();\n            }\n            //fill option section data\n            this.attributes.each(function (attribute) {\n                attribute.chosen.each(function (option) {\n                    option.sections = ko.observable(this.makeOptionSections());\n                }, this);\n            }, this);\n            //reset section.attribute\n            _.each(this.sections(), function (section) {\n                section.attribute(null);\n            });\n\n            this.initCountVariations();\n            this.bindGalleries();\n        },\n\n        /**\n         * Init count variations.\n         */\n        initCountVariations: function () {\n            var variations = this.generateVariation(this.attributes()),\n                newVariations = _.map(variations, function (options) {\n                    return this.variationsComponent().getVariationKey(options);\n                }.bind(this)),\n                existingVariations = _.keys(this.variationsComponent().productAttributesMap);\n\n            this.countVariations(_.difference(newVariations, existingVariations).length);\n        },\n\n        /**\n         * @param {Object} attributes - example [['b1', 'b2'],['a1', 'a2', 'a3'],['c1', 'c2', 'c3'],['d1']]\n         * @returns {*} example [['b1','a1','c1','d1'],['b1','a1','c2','d1']...]\n         */\n        generateVariation: function (attributes) {\n            return _.reduce(attributes, function (matrix, attribute) {\n                var tmp = [];\n\n                _.each(matrix, function (variations) {\n                    _.each(attribute.chosen, function (option) {\n                        option['attribute_code'] = attribute.code;\n                        option['attribute_label'] = attribute.label;\n                        tmp.push(_.union(variations, [option]));\n                    });\n                });\n\n                if (!tmp.length) {\n                    return _.map(attribute.chosen, function (option) {\n                        option['attribute_code'] = attribute.code;\n                        option['attribute_label'] = attribute.label;\n\n                        return [option];\n                    });\n                }\n\n                return tmp;\n            }, []);\n        },\n\n        /**\n         * @param {*} section\n         * @param {Object} options\n         * @return {*}\n         */\n        getSectionValue: function (section, options) {\n            switch (this.sections()[section].type()) {\n                case 'each':\n                    return _.find(this.sections()[section].attribute().chosen, function (chosen) {\n                        return _.find(options, function (option) {\n                            return chosen.id == option.id; //eslint-disable-line eqeqeq\n                        });\n                    }).sections()[section];\n\n                case 'single':\n                    return this.sections()[section].value();\n\n                case 'none':\n                    return this[section];\n            }\n        },\n\n        /**\n         * @param {*} node\n         * @return {Promise|*}\n         */\n        getImageProperty: function (node) {\n            var types = node.find('[data-role=gallery]').productGallery('option').types,\n                images = _.map(node.find('[data-role=image]'), function (image) {\n                    var imageData = $(image).data('imageData'),\n                        positionElement;\n\n                    imageData.galleryTypes = _.pluck(_.filter(types, function (type) {\n                        return type.value === imageData.file;\n                    }), 'code');\n\n                    //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    positionElement =\n                        $(image).find('[name=\"product[media_gallery][images][' + imageData.file_id + '][position]\"]');\n                    //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    if (!_.isEmpty(positionElement.val())) {\n                        imageData.position = positionElement.val();\n                    }\n\n                    return imageData;\n                });\n\n            return _.reject(images, function (image) {\n                return !!image.isRemoved;\n            });\n        },\n\n        /**\n         * Fill images section.\n         */\n        fillImagesSection: function () {\n            switch (this.sections().images.type()) {\n                case 'each':\n                    if (this.sections().images.attribute()) {\n                        this.sections().images.attribute().chosen.each(function (option) {\n                            option.sections().images = new this.makeImages(\n                                this.getImageProperty($('[data-role=step-gallery-option-' + option.id + ']')),\n                                'thumbnail'\n                            );\n                        }, this);\n                    }\n                    break;\n\n                case 'single':\n                    this.sections().images.value(new this.makeImages(\n                        this.getImageProperty($('[data-role=step-gallery-single]')),\n                        'thumbnail'\n                    ));\n                    break;\n\n                default:\n                    this.sections().images.value(new this.makeImages());\n                    break;\n            }\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            this.fillImagesSection();\n            this.validate();\n            this.validateImage();\n            wizard.data.sections = this.sections;\n            wizard.data.sectionHelper = this.getSectionValue.bind(this);\n            wizard.data.variations = this.generateVariation(this.attributes());\n        },\n\n        /**\n         * Validate.\n         */\n        validate: function () {\n            var formValid;\n\n            _.each(this.sections(), function (section) {\n                switch (section.type()) {\n                    case 'each':\n                        if (!section.attribute()) {\n                            throw new Error($.mage.__('Please select attribute for {section} section.')\n                                .replace('{section}', section.label));\n                        }\n                        break;\n\n                    case 'single':\n                        if (!section.value()) {\n                            throw new Error($.mage.__('Please fill in the values for {section} section.')\n                                .replace('{section}', section.label));\n                        }\n                        break;\n                }\n            }, this);\n            formValid = true;\n            _.each($('[data-role=attributes-values-form]'), function (form) {\n                formValid = $(form).valid() && formValid;\n            });\n\n            if (!formValid) {\n                throw new Error($.mage.__('Please fill-in correct values.'));\n            }\n        },\n\n        /**\n         * Validate image.\n         */\n        validateImage: function () {\n            switch (this.sections().images.type()) {\n                case 'each':\n                    _.each(this.sections().images.attribute().chosen, function (option) {\n                        if (!option.sections().images.images.length) {\n                            throw new Error($.mage.__('Please select image(s) for your attribute.'));\n                        }\n                    });\n                    break;\n\n                case 'single':\n                    if (this.sections().images.value().file == null) {\n                        throw new Error($.mage.__('Please choose image(s).'));\n                    }\n                    break;\n            }\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n            this.setWizardNotifyMessageDependOnSectionType();\n        },\n\n        /**\n         * Bind galleries.\n         */\n        bindGalleries: function () {\n            $('[data-role=bulk-step] [data-role=gallery]').each(function (index, element) {\n                var gallery = $(element),\n                    uploadInput = $(gallery.find('[name=image]')),\n                    dropZone = $(gallery).find('.image-placeholder');\n\n                if (!gallery.data('gallery-initialized')) {\n                    gallery.mage('productGallery', {\n                        template: '[data-template=gallery-content]',\n                        dialogTemplate: '.dialog-template',\n                        dialogContainerTmpl: '[data-role=img-dialog-container-tmpl]'\n                    });\n\n                    uploadInput.fileupload({\n                        dataType: 'json',\n                        dropZone: dropZone,\n                        process: [{\n                            action: 'load',\n                            fileTypes: /^image\\/(gif|jpeg|png)$/\n                        }, {\n                            action: 'resize',\n                            maxWidth: 1920,\n                            maxHeight: 1200\n                        }, {\n                            action: 'save'\n                        }],\n                        formData: {\n                            'form_key': FORM_KEY\n                        },\n                        sequentialUploads: true,\n                        acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        add: function (e, data) {\n                            var progressTmpl = mageTemplate('[data-template=uploader]'),\n                                fileSize,\n                                tmpl;\n\n                            $.each(data.files, function (i, file) {\n                                fileSize = typeof file.size == 'undefined' ?\n                                    $.mage.__('We could not detect a size.') :\n                                    byteConvert(file.size);\n\n                                data.fileId = Math.random().toString(33).substr(2, 18);\n\n                                tmpl = progressTmpl({\n                                    data: {\n                                        name: file.name,\n                                        size: fileSize,\n                                        id: data.fileId\n                                    }\n                                });\n\n                                $(tmpl).appendTo(gallery.find('[data-role=uploader]'));\n                            });\n\n                            $(this).fileupload('process', data).done(function () {\n                                data.submit();\n                            });\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        done: function (e, data) {\n                            if (data.result && !data.result.error) {\n                                gallery.trigger('addItem', data.result);\n                            } else {\n                                $('#' + data.fileId)\n                                    .delay(2000)\n                                    .hide('highlight');\n                                alert({\n                                    content: $.mage.__('We don\\'t recognize or support this file extension type.')\n                                });\n                            }\n                            $('#' + data.fileId).remove();\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        progress: function (e, data) {\n                            var progress = parseInt(data.loaded / data.total * 100, 10),\n                                progressSelector = '#' + data.fileId + ' .progressbar-container .progressbar';\n\n                            $(progressSelector).css('width', progress + '%');\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        fail: function (e, data) {\n                            var progressSelector = '#' + data.fileId;\n\n                            $(progressSelector).removeClass('upload-progress').addClass('upload-failure')\n                                .delay(2000)\n                                .hide('highlight')\n                                .remove();\n                        }\n                    });\n                    gallery.data('gallery-initialized', 1);\n                }\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/attributes_values.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'mageUtils',\n    'Magento_Ui/js/lib/collapsible',\n    'mage/translate'\n], function (Component, $, ko, _, utils, Collapsible) {\n    'use strict';\n\n    //connect items with observableArrays\n    ko.bindingHandlers.sortableList = {\n        /** @inheritdoc */\n        init: function (element, valueAccessor) {\n            var list = valueAccessor();\n\n            $(element).sortable({\n                axis: 'y',\n                handle: '[data-role=\"draggable\"]',\n                tolerance: 'pointer',\n\n                /** @inheritdoc */\n                update: function (event, ui) {\n                    var item = ko.contextFor(ui.item[0]).$data,\n                        position = ko.utils.arrayIndexOf(ui.item.parent().children(), ui.item[0]);\n\n                    if (ko.contextFor(ui.item[0]).$index() != position) { //eslint-disable-line eqeqeq\n                        if (position >= 0) {\n                            list.remove(item);\n                            list.splice(position, 0, item);\n                        }\n                        ui.item.remove();\n                    }\n                }\n            });\n        }\n    };\n\n    return Collapsible.extend({\n        defaults: {\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            createOptionsUrl: null,\n            attributes: [],\n            stepInitialized: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.createAttribute = _.wrap(this.createAttribute, function () {\n                var args = _.toArray(arguments),\n                    createAttribute = args.shift();\n\n                return this.doInitSavedOptions(createAttribute.apply(this, args));\n            });\n            this.createAttribute = _.memoize(this.createAttribute.bind(this), _.property('id'));\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(['attributes']);\n\n            return this;\n        },\n\n        /**\n         * Create option.\n         */\n        createOption: function () {\n            // this - current attribute\n            this.options.push({\n                value: 0,\n                label: '',\n                id: utils.uniqueid(),\n                'attribute_id': this.id,\n                'is_new': true\n            });\n        },\n\n        /**\n         * @param {Object} option\n         */\n        saveOption: function (option) {\n            if (this.isValidOption(option)) {\n                this.options.remove(option);\n                this.options.push(option);\n                this.chosenOptions.push(option.id);\n            }\n        },\n\n        /**\n         * @param {Object} newOption\n         * @return boolean\n         */\n        isValidOption: function (newOption) {\n            var duplicatedOptions = [],\n                errorOption,\n                allOptions = [];\n\n            newOption.label = newOption.label.trim();\n\n            if (_.isEmpty(newOption.label)) {\n                return false;\n            }\n\n            _.each(this.options(), function (option) {\n                if (!_.isUndefined(allOptions[option.label]) && newOption.label === option.label) {\n                    duplicatedOptions.push(option);\n                }\n\n                allOptions[option.label] = option.label;\n            });\n\n            if (duplicatedOptions.length) {\n                _.each(duplicatedOptions, function (duplicatedOption) {\n                    errorOption = $('[data-role=\"' + duplicatedOption.id + '\"]');\n                    errorOption.addClass('_error');\n                });\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * @param {Object} option\n         */\n        removeOption: function (option) {\n            this.options.remove(option);\n        },\n\n        /**\n         * @param {String} attribute\n         */\n        removeAttribute: function (attribute) {\n            this.attributes.remove(attribute);\n            this.wizard.setNotificationMessage(\n                $.mage.__('An attribute has been removed. This attribute will no longer appear in your configurations.')\n            );\n        },\n\n        /**\n         * @param {Object} attribute\n         * @param {*} index\n         * @return {Object}\n         */\n        createAttribute: function (attribute, index) {\n            attribute.chosenOptions = ko.observableArray([]);\n            attribute.options = ko.observableArray(_.map(attribute.options, function (option) {\n                option.id = utils.uniqueid();\n\n                return option;\n            }));\n            attribute.opened = ko.observable(this.initialOpened(index));\n            attribute.collapsible = ko.observable(true);\n            attribute.isValidOption = this.isValidOption;\n\n            return attribute;\n        },\n\n        /**\n         * First 3 attribute panels must be open.\n         *\n         * @param {Number} index\n         * @return {Boolean}\n         */\n        initialOpened: function (index) {\n            return index < 3;\n        },\n\n        /**\n         * Save attribute.\n         */\n        saveAttribute: function () {\n            var errorMessage = $.mage.__('Select options for all attributes or remove unused attributes.');\n\n            if (!this.attributes().length) {\n                throw new Error(errorMessage);\n            }\n\n            _.each(this.attributes(), function (attribute) {\n                attribute.chosen = [];\n\n                if (!attribute.chosenOptions.getLength()) {\n                    throw new Error(errorMessage);\n                }\n                _.each(attribute.chosenOptions(), function (id) {\n                    attribute.chosen.push(attribute.options.findWhere({\n                        id: id\n                    }));\n                });\n            });\n        },\n\n        /**\n         * @param {Object} attribute\n         */\n        selectAllAttributes: function (attribute) {\n            this.chosenOptions(_.pluck(attribute.options(), 'id'));\n        },\n\n        /**\n         * @param {Object} attribute\n         */\n        deSelectAllAttributes: function (attribute) {\n            attribute.chosenOptions.removeAll();\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        saveOptions: function () {\n            var newOptions = [];\n\n            _.each(this.attributes(), function (attribute) {\n                _.each(attribute.options(), function (element) {\n                    var option = attribute.options.findWhere({\n                        id: element.id\n                    });\n\n                    if (option['is_new'] === true) {\n                        if (!attribute.isValidOption(option)) {\n                            throw new Error(\n                                $.mage.__('The value of attribute \"\"%1\"\" must be unique')\n                                    .replace('\"%1\"', attribute.label)\n                            );\n                        }\n\n                        newOptions.push(option);\n                    }\n                });\n            });\n\n            if (!newOptions.length) {\n                return false;\n            }\n\n            $.ajax({\n                type: 'POST',\n                url: this.createOptionsUrl,\n                data: {\n                    options: newOptions\n                },\n                showLoader: true\n            }).done(function (savedOptions) {\n                if (savedOptions.error) {\n                    this.notificationMessage.error = savedOptions.error;\n                    this.notificationMessage.text = savedOptions.message;\n\n                    return;\n                }\n\n                _.each(this.attributes(), function (attribute) {\n                    _.each(savedOptions, function (newOptionId, oldOptionId) {\n                        var option = attribute.options.findWhere({\n                            id: oldOptionId\n                        });\n\n                        if (option) {\n                            attribute.options.remove(option);\n                            option['is_new'] = false;\n                            option.value = newOptionId;\n                            attribute.options.push(option);\n                        }\n                    });\n                });\n\n            }.bind(this));\n        },\n\n        /**\n         * @param {*} attributeIds\n         */\n        requestAttributes: function (attributeIds) {\n            $.ajax({\n                type: 'GET',\n                url: this.optionsUrl,\n                data: {\n                    attributes: attributeIds\n                },\n                showLoader: true\n            }).done(function (attributes) {\n                attributes = _.sortBy(attributes, function (attribute) {\n                    return this.wizard.data.attributesIds.indexOf(attribute.id);\n                }.bind(this));\n                this.attributes(_.map(attributes, this.createAttribute));\n            }.bind(this));\n        },\n\n        /**\n         * @param {*} attribute\n         * @return {*}\n         */\n        doInitSavedOptions: function (attribute) {\n            var selectedOptions, selectedOptionsIds, selectedAttribute = _.findWhere(this.initData.attributes, {\n                id: attribute.id\n            });\n\n            if (selectedAttribute) {\n                selectedOptions = _.pluck(selectedAttribute.chosen, 'value');\n                selectedOptionsIds = _.pluck(_.filter(attribute.options(), function (option) {\n                    return _.contains(selectedOptions, option.value);\n                }), 'id');\n                attribute.chosenOptions(selectedOptionsIds);\n                this.initData.attributes = _.without(this.initData.attributes, selectedAttribute);\n            }\n\n            return attribute;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.requestAttributes(wizard.data.attributesIds());\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            this.saveOptions();\n            this.saveAttribute(wizard);\n\n            wizard.data.attributes = this.attributes;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        back: function (wizard) {\n            wizard.data.attributesIds(this.attributes().pluck('id'));\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/select_attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'underscore',\n    'mage/translate'\n], function (Component, $, _) {\n    'use strict';\n\n    /**\n     * @param {Function} provider\n     */\n    var initNewAttributeListener = function (provider) {\n        $('[data-role=product-variations-matrix]').on('add', function () {\n            provider().reload();\n        });\n    };\n\n    return Component.extend({\n        attributesLabels: {},\n        stepInitialized: false,\n        defaults: {\n            modules: {\n                multiselect: '${ $.multiselectName }',\n                attributeProvider: '${ $.providerName }'\n            },\n            listens: {\n                '${ $.multiselectName }:selected': 'doSelectedAttributesLabels',\n                '${ $.multiselectName }:rows': 'doSelectSavedAttributes'\n            },\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            selectedAttributes: []\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.selected = [];\n\n            initNewAttributeListener(this.attributeProvider);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(['selectedAttributes']);\n\n            return this;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.setNotificationMessage();\n        },\n\n        /**\n         * Set notification message.\n         */\n        setNotificationMessage: function () {\n            /*eslint-disable max-len*/\n            var msg = $.mage.__('When you remove or add an attribute, we automatically update all configurations and you will need to recreate current configurations manually.');\n\n            /*eslint-enable max-len*/\n\n            if (this.mode === 'edit') {\n                this.wizard.setNotificationMessage(msg);\n            }\n        },\n\n        /**\n         * Do select saved attributes.\n         */\n        doSelectSavedAttributes: function () {\n            if (this.stepInitialized === false) {\n                this.stepInitialized = true;\n                //cache attributes labels, which can be present on the 2nd page\n                _.each(this.initData.attributes, function (attribute) {\n                    this.attributesLabels[attribute.id] = attribute.label;\n                }.bind(this));\n                this.multiselect().selected(_.pluck(this.initData.attributes, 'id'));\n            }\n        },\n\n        /**\n         * @param {*} selected\n         */\n        doSelectedAttributesLabels: function (selected) {\n            var labels = [];\n\n            this.selected = selected;\n            _.each(selected, function (attributeId) {\n                var attribute;\n\n                if (!this.attributesLabels[attributeId]) {\n                    attribute = _.findWhere(this.multiselect().rows(), {\n                        'attribute_id': attributeId\n                    });\n\n                    if (attribute) {\n                        this.attributesLabels[attribute['attribute_id']] = attribute['frontend_label'];\n                    }\n                }\n                labels.push(this.attributesLabels[attributeId]);\n            }.bind(this));\n            this.selectedAttributes(labels.join(', '));\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            wizard.data.attributesIds = this.multiselect().selected;\n\n            if (!wizard.data.attributesIds() || wizard.data.attributesIds().length === 0) {\n                throw new Error($.mage.__('Please select attribute(s).'));\n            }\n            this.setNotificationMessage();\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/paging/paging',\n    'mage/translate'\n], function (Component, $, ko, _, paging) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            modules: {\n                variationsComponent: '${ $.variationsComponent }',\n                modalComponent: '${ $.modalComponent }',\n                matrixGridComponent: '${ $.matrixGridComponent }'\n            },\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            gridExisting: [],\n            gridNew: [],\n            gridDeleted: [],\n            variationsExisting: [],\n            variationsNew: [],\n            variationsDeleted: [],\n            pagingExisting: paging({\n                name: 'configurableWizard.pagingExisting',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingExisting_sizes'\n                }\n            }),\n            pagingNew: paging({\n                name: 'configurableWizard.pagingNew',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingNew_sizes'\n                }\n            }),\n            pagingDeleted: paging({\n                name: 'configurableWizard.pagingDeleted',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingDeleted_sizes'\n                }\n            }),\n            attributes: [],\n            attributesName: [$.mage.__('Images'), $.mage.__('SKU'), $.mage.__('Quantity'), $.mage.__('Price')],\n            sections: [],\n            gridTemplate: 'Magento_ConfigurableProduct/variations/steps/summary-grid',\n            quantityFieldName: 'quantity'\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            var pagingObservables = {\n                currentNew: ko.getObservable(this.pagingNew, 'current'),\n                currentExisting: ko.getObservable(this.pagingExisting, 'current'),\n                currentDeleted: ko.getObservable(this.pagingDeleted, 'current'),\n                pageSizeNew: ko.getObservable(this.pagingNew, 'pageSize'),\n                pageSizeExisting: ko.getObservable(this.pagingExisting, 'pageSize'),\n                pageSizeDeleted: ko.getObservable(this.pagingDeleted, 'pageSize')\n            };\n\n            this._super().observe('gridExisting gridNew gridDeleted attributes sections');\n            this.gridExisting.columns = ko.observableArray();\n            this.gridNew.columns = ko.observableArray();\n            this.gridDeleted.columns = ko.observableArray();\n\n            _.each(pagingObservables, function (observable) {\n                observable.subscribe(function () {\n                    this.generateGrid();\n                }, this);\n            }, this);\n\n            return this;\n        },\n        nextLabelText: $.mage.__('Generate Products'),\n        variations: [],\n\n        /**\n         * @param {*} variations\n         * @param {Function} getSectionValue\n         */\n        calculate: function (variations, getSectionValue) {\n            var productSku = this.variationsComponent().getProductValue('sku'),\n                productPrice = this.variationsComponent().getProductPrice(),\n                productWeight = this.variationsComponent().getProductValue('weight'),\n                productName = this.variationsComponent().getProductValue('name'),\n                variationsKeys = [],\n                gridExisting = [],\n                gridNew = [],\n                gridDeleted = [],\n                matrixGridData = this.matrixGridComponent() ?\n                    _.indexBy(this.matrixGridComponent().getUnionInsertData(), 'variationKey') : {};\n\n            this.variations = [];\n            _.each(variations, function (options) {\n                var product, images, sku, name, quantity, price, variation,\n                    variationsKey = this.variationsComponent().getVariationKey(options),\n                    productDataFromGrid = matrixGridData[variationsKey] || {},\n                    productDataFromWizard = {},\n                    productId = this.variationsComponent().getProductIdByOptions(options);\n\n                if (productId) {\n                    product = _.findWhere(this.variationsComponent().variations, {\n                        productId: productId\n                    });\n                }\n                images = getSectionValue('images', options);\n                sku = productSku + _.reduce(options, function (memo, option) {\n                    return memo + '-' + option.label;\n                }, '');\n                name = productName + _.reduce(options, function (memo, option) {\n                    return memo + '-' + option.label;\n                }, '');\n                quantity = getSectionValue(this.quantityFieldName, options);\n\n                if (quantity) {\n                    productDataFromWizard[this.quantityFieldName] = quantity;\n                }\n                price = getSectionValue('price', options);\n\n                if (price) {\n                    productDataFromWizard.price = price;\n                }\n\n                if (productId && !images.file) {\n                    images = product.images;\n                }\n                productDataFromGrid = _.pick(\n                    productDataFromGrid,\n                    'sku',\n                    'name',\n                    'weight',\n                    'status',\n                    'price',\n                    'qty'\n                );\n\n                if (productDataFromGrid.hasOwnProperty('qty')) {\n                    productDataFromGrid[this.quantityFieldName] = productDataFromGrid.qty;\n                }\n                delete productDataFromGrid.qty;\n                product = _.pick(\n                    product || {},\n                    'sku',\n                    'name',\n                    'weight',\n                    'status',\n                    'price',\n                    this.quantityFieldName\n                );\n                variation = {\n                    options: options,\n                    images: images,\n                    sku: sku,\n                    name: name,\n                    price: productPrice,\n                    productId: productId,\n                    weight: productWeight,\n                    editable: true\n                };\n                variation[this.quantityFieldName] = quantity;\n                variation = _.extend(variation, product, productDataFromGrid, productDataFromWizard);\n\n                if (productId) {\n                    gridExisting.push(this.prepareRowForGrid(variation));\n                } else {\n                    gridNew.push(this.prepareRowForGrid(variation));\n                }\n                this.variations.push(variation);\n                variationsKeys.push(variationsKey);\n            }, this);\n\n            _.each(_.omit(this.variationsComponent().productAttributesMap, variationsKeys), function (productId) {\n                gridDeleted.push(this.prepareRowForGrid(\n                    _.findWhere(this.variationsComponent().variations, {\n                        productId: productId\n                    })\n                ));\n            }.bind(this));\n\n            this.variationsExisting = gridExisting;\n            this.variationsNew = gridNew;\n            this.variationsDeleted = gridDeleted;\n        },\n\n        /**\n         * Generate grid.\n         */\n        generateGrid: function () {\n            var pageExisting = this.pagingExisting.pageSize * this.pagingExisting.current,\n                pageNew = this.pagingNew.pageSize * this.pagingNew.current,\n                pageDeleted = this.pagingDeleted.pageSize * this.pagingDeleted.current;\n\n            this.pagingExisting.totalRecords = this.variationsExisting.length;\n            this.gridExisting(this.variationsExisting.slice(pageExisting - this.pagingExisting.pageSize, pageExisting));\n\n            this.pagingNew.totalRecords = this.variationsNew.length;\n            this.gridNew(this.variationsNew.slice(pageNew - this.pagingNew.pageSize, pageNew));\n\n            this.pagingDeleted.totalRecords = this.variationsDeleted.length;\n            this.gridDeleted(this.variationsDeleted.slice(pageDeleted - this.pagingDeleted.pageSize, pageDeleted));\n        },\n\n        /**\n         * @param {Object} variation\n         * @return {Array}\n         */\n        prepareRowForGrid: function (variation) {\n            var row = [];\n\n            row.push(_.extend({\n                images: []\n            }, variation.images));\n            row.push(variation.sku);\n            row.push(variation[this.quantityFieldName]);\n            _.each(variation.options, function (option) {\n                row.push(option.label);\n            });\n            row.push(this.variationsComponent().getCurrencySymbol() +  ' ' + variation.price);\n\n            return row;\n        },\n\n        /**\n         * @return {String|*}\n         */\n        getGridTemplate: function () {\n            return this.gridTemplate;\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getGridId: function () {\n            return _.uniqueId('grid_');\n        },\n\n        /**\n         * @param {*} attributes\n         * @return {Array}\n         */\n        getColumnsName: function (attributes) {\n            var columns = this.attributesName.slice(0);\n\n            attributes.each(function (attribute, index) {\n                columns.splice(3 + index, 0, attribute.label);\n            }, this);\n\n            return columns;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.sections(wizard.data.sections());\n            this.attributes(wizard.data.attributes());\n            this.gridNew([]);\n            this.gridExisting([]);\n            this.gridDeleted([]);\n            this.gridExisting.columns(this.getColumnsName(this.wizard.data.attributes));\n            this.gridNew.columns(this.getColumnsName(this.wizard.data.attributes));\n            this.gridDeleted.columns(this.getColumnsName(this.variationsComponent().productAttributes));\n            this.calculate(wizard.data.variations, wizard.data.sectionHelper);\n            this.generateGrid();\n        },\n\n        /**\n         * Force.\n         */\n        force: function () {\n            this.variationsComponent().render(this.variations, this.attributes());\n            this.modalComponent().closeModal();\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/paging/sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/paging/sizes'\n], function (Sizes) {\n    'use strict';\n\n    return Sizes.extend({\n        defaults: {\n            options: {\n                '20': {\n                    value: 20,\n                    label: 20\n                },\n                '30': {\n                    value: 30,\n                    label: 30\n                },\n                '50': {\n                    value: 50,\n                    label: 50\n                }\n            },\n            value: 20\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/qty-validator-changer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            valueUpdate: 'input'\n        },\n\n        /**\n         * Change validator\n         */\n        handleChanges: function (value) {\n            var isDigits = value !== 1;\n\n            this.validation['validate-integer'] = isDigits;\n            this.validation['less-than-equals-to'] = isDigits ? 99999999 : 99999999.9999;\n            this.validate();\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/use-config-settings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (checkbox) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: '',\n            linkedValue: '',\n            disableParent: false,\n            listens: {\n                disabled: 'processState',\n                checked: 'processState onCheckedChanged'\n            },\n            imports: {\n                readOnly: 'ns = ${ $.ns }, index = stock_data:disabled'\n            }\n        },\n\n        /**\n         * @returns {Element}\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig', 'linkedValue', 'disableParent']);\n        },\n\n        /**\n         * Handle checked and disabled changes to calculate disableParent value\n         */\n        processState: function () {\n            this.disableParent(this.checked() || this.readOnly);\n\n            if (this.readOnly) {\n                this.disable();\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onCheckedChanged: function (newChecked) {\n            if (newChecked) {\n                this.linkedValue(this.valueFromConfig());\n            }\n\n            this._super(newChecked);\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/use-config-min-sale-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'underscore',\n    'uiRegistry'\n], function (checkbox, _, registry) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: ''\n        },\n\n        /**\n         * @returns {Element}\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig']);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n            this.onCheckedChanged(this.checked());\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onCheckedChanged: function (newChecked) {\n            var valueFromConfig = this.valueFromConfig();\n\n            if (newChecked && (_.isArray(valueFromConfig) && valueFromConfig.length === 0 || valueFromConfig === 1)) {\n                this.changeVisibleDisabled(this.inputField, true, true, 1);\n            } else if (newChecked && _.isObject(valueFromConfig)) {\n                this.changeVisibleDisabled(this.inputField, false, true, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, true, true, null);\n            } else if (newChecked && _.isNumber(valueFromConfig)) {\n                this.changeVisibleDisabled(this.inputField, true, true, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, false, true, null);\n            } else {\n                this.changeVisibleDisabled(this.inputField, true, this.disabled() || false, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, false, true, null);\n            }\n\n            this._super(newChecked);\n        },\n\n        /**\n         * Change visible and disabled\n         *\n         * @param {String} filter\n         * @param {Boolean} visible\n         * @param {Boolean} disabled\n         * @param {Null|Number} valueFromConfig\n         */\n        changeVisibleDisabled: function (filter, visible, disabled, valueFromConfig) {\n            registry.async(filter)(\n                function (currentComponent) {\n                    var initialValue = currentComponent.initialValue;\n\n                    if (_.isString(initialValue) || initialValue === 0 || valueFromConfig === 1) {\n                        currentComponent.value(1);\n                    } else if (initialValue) {\n                        currentComponent.value(initialValue);\n                    }\n\n                    currentComponent.visible(visible);\n                    currentComponent.disabled(disabled);\n                }\n            );\n        }\n    });\n});\n","js-cookie/js.cookie.js":"/*! js-cookie v3.0.1 | MIT */\n;\n(function (global, factory) {\n    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n        typeof define === 'function' && define.amd ? define(factory) :\n            (global = global || self, (function () {\n                var current = global.Cookies;\n                var exports = global.Cookies = factory();\n                exports.noConflict = function () { global.Cookies = current; return exports; };\n            }()));\n}(this, (function () { 'use strict';\n\n    /* eslint-disable no-var */\n    function assign (target) {\n        for (var i = 1; i < arguments.length; i++) {\n            var source = arguments[i];\n            for (var key in source) {\n                target[key] = source[key];\n            }\n        }\n        return target\n    }\n    /* eslint-enable no-var */\n\n    /* eslint-disable no-var */\n    var defaultConverter = {\n        read: function (value) {\n            if (value[0] === '\"') {\n                value = value.slice(1, -1);\n            }\n            return value.replace(/(%[\\dA-F]{2})+/gi, decodeURIComponent)\n        },\n        write: function (value) {\n            return encodeURIComponent(value).replace(\n                /%(2[346BF]|3[AC-F]|40|5[BDE]|60|7[BCD])/g,\n                decodeURIComponent\n            )\n        }\n    };\n    /* eslint-enable no-var */\n\n    /* eslint-disable no-var */\n\n    function init (converter, defaultAttributes) {\n        function set (key, value, attributes) {\n            if (typeof document === 'undefined') {\n                return\n            }\n\n            attributes = assign({}, defaultAttributes, attributes);\n\n            if (typeof attributes.expires === 'number') {\n                attributes.expires = new Date(Date.now() + attributes.expires * 864e5);\n            }\n            if (attributes.expires) {\n                attributes.expires = attributes.expires.toUTCString();\n            }\n\n            key = encodeURIComponent(key)\n                .replace(/%(2[346B]|5E|60|7C)/g, decodeURIComponent)\n                .replace(/[()]/g, escape);\n\n            var stringifiedAttributes = '';\n            for (var attributeName in attributes) {\n                if (!attributes[attributeName]) {\n                    continue\n                }\n\n                stringifiedAttributes += '; ' + attributeName;\n\n                if (attributes[attributeName] === true) {\n                    continue\n                }\n\n                // Considers RFC 6265 section 5.2:\n                // ...\n                // 3.  If the remaining unparsed-attributes contains a %x3B (\";\")\n                //     character:\n                // Consume the characters of the unparsed-attributes up to,\n                // not including, the first %x3B (\";\") character.\n                // ...\n                stringifiedAttributes += '=' + attributes[attributeName].split(';')[0];\n            }\n\n            return (document.cookie =\n                key + '=' + converter.write(value, key) + stringifiedAttributes)\n        }\n\n        function get (key) {\n            if (typeof document === 'undefined' || (arguments.length && !key)) {\n                return\n            }\n\n            // To prevent the for loop in the first place assign an empty array\n            // in case there are no cookies at all.\n            var cookies = document.cookie ? document.cookie.split('; ') : [];\n            var jar = {};\n            for (var i = 0; i < cookies.length; i++) {\n                var parts = cookies[i].split('=');\n                var value = parts.slice(1).join('=');\n\n                try {\n                    var foundKey = decodeURIComponent(parts[0]);\n                    jar[foundKey] = converter.read(value, foundKey);\n\n                    if (key === foundKey) {\n                        break\n                    }\n                } catch (e) {}\n            }\n\n            return key ? jar[key] : jar\n        }\n\n        return Object.create(\n            {\n                set: set,\n                get: get,\n                remove: function (key, attributes) {\n                    set(\n                        key,\n                        '',\n                        assign({}, attributes, {\n                            expires: -1\n                        })\n                    );\n                },\n                withAttributes: function (attributes) {\n                    return init(this.converter, assign({}, this.attributes, attributes))\n                },\n                withConverter: function (converter) {\n                    return init(assign({}, this.converter, converter), this.attributes)\n                }\n            },\n            {\n                attributes: { value: Object.freeze(defaultAttributes) },\n                converter: { value: Object.freeze(converter) }\n            }\n        )\n    }\n\n    var api = init(defaultConverter, { path: '/' });\n    /* eslint-enable no-var */\n\n    return api;\n\n})));\n","js-cookie/cookie-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'js-cookie/js.cookie'\n], function ($, cookie) {\n    'use strict';\n\n    window.Cookies = window.Cookies || cookie;\n\n    var config = $.cookie = function (key, value, options) {\n        if (value !== undefined) {\n            options = $.extend({}, config.defaults, options);\n\n            return cookie.set(key, value, options);\n        }\n\n        var result = key ? undefined : {},\n            cookies = document.cookie ? document.cookie.split('; ') : [],\n            i;\n\n        for (i = 0; i < cookies.length; i++) {\n            var parts = cookies[i].split('='),\n                name = config.raw ? parts.shift() : decodeURIComponent(parts.shift()),\n                cookieValue = parts.join('=');\n\n            if (key && key === name) {\n                result = decodeURIComponent(cookieValue.replace('/\\\\+/g', ' '));\n                break;\n            }\n\n            if (!key && (cookieValue = decodeURIComponent(cookieValue.replace('/\\\\+/g', ' '))) !== undefined) {\n                result[name] = cookieValue;\n            }\n        }\n\n        return result;\n    };\n\n    config.defaults = {};\n\n    $.removeCookie = function (key, options) {\n        if ($.cookie(key) === undefined) {\n            return false;\n        }\n\n        $.cookie(key, '', $.extend({}, options, { expires: -1 }));\n        return !$.cookie(key);\n    };\n});\n","Solucoes_PriceInstallment/js/main.js":"","Magento_Sitemap/js/form-submit-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).on('save', function () {\n            if ($(this).valid()) {\n                $('body').trigger('processStart');\n            }\n        });\n    };\n});\n","Magento_Catalog/catalog/product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    window.Product = {};\n\n    /**\n     * @param {String} id\n     * @return {*|jQuery|HTMLElement}\n     */\n    function byId(id) {\n        return $('#' + id);\n    }\n\n    /**\n     * @param {String} fieldId\n     */\n    function disableFieldEditMode(fieldId) {\n        var field = byId(fieldId);\n\n        field.prop('disabled', true);\n\n        if (field.next().hasClass('addafter')) {\n            field.parent().addClass('_update-attributes-disabled');\n        }\n\n        if (byId(fieldId + '_hidden').length) {\n            byId(fieldId + '_hidden').prop('disabled', true);\n        }\n    }\n\n    /**\n     * @param {String} fieldId\n     */\n    function enableFieldEditMode(fieldId) {\n        var field = byId(fieldId);\n\n        field.prop('disabled', false);\n\n        if (field.parent().hasClass('_update-attributes-disabled')) {\n            field.parent().removeClass('_update-attributes-disabled');\n        }\n\n        if (byId(fieldId + '_hidden').length) {\n            byId(fieldId + '_hidden').prop('disabled', false);\n        }\n    }\n\n    /**\n     * @param {String} toogleIdentifier\n     * @param {String} fieldId\n     */\n    function toogleFieldEditMode(toogleIdentifier, fieldId) {\n        if ($(toogleIdentifier).is(':checked')) {\n            enableFieldEditMode(fieldId);\n        } else {\n            disableFieldEditMode(fieldId);\n        }\n    }\n\n    /**\n     * On complete disable.\n     */\n    function onCompleteDisableInited() {\n        var item;\n\n        $.each($('[data-disable]'), function () {\n            item = $(this).data('disable');\n            disableFieldEditMode(item);\n        });\n    }\n\n    /**\n     * @param {String} urlKey\n     */\n    function onUrlkeyChanged(urlKey) {\n        var hidden, chbx, oldValue;\n\n        urlKey = byId(urlKey);\n        hidden = urlKey.siblings('input[type=hidden]');\n        chbx = urlKey.siblings('input[type=checkbox]');\n        oldValue = chbx.val();\n\n        chbx.prop('disabled', oldValue === urlKey.val());\n        hidden.prop('disabled', chbx.prop('disabled'));\n    }\n\n    /**\n     * @param {HTMLElement} element\n     */\n    function onCustomUseParentChanged(element) {\n        var useParent, parent;\n\n        element = $(element);\n        useParent = element.val() == 1; //eslint-disable-line eqeqeq\n        parent = element.offsetParent().parent();\n\n        parent.find('input, select, textarea').each(function (i, el) {\n            el = $(el);\n\n            if (element.prop('id') !== el.prop('id')) {\n                el.prop('disabled', useParent);\n            }\n        });\n\n        parent.find('img').each(function (i, el) {\n            if (useParent) {\n                $(el).hide();\n            } else {\n                $(el).show();\n            }\n        });\n    }\n\n    window.onCustomUseParentChanged = onCustomUseParentChanged;\n    window.onUrlkeyChanged = onUrlkeyChanged;\n    window.toogleFieldEditMode = toogleFieldEditMode;\n\n    $(onCompleteDisableInited);\n});\n","Magento_Catalog/catalog/type-events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return {\n        $type: $('#product_type_id'),\n\n        /**\n         * Init\n         */\n        init: function () {\n            this.type = {\n                init: this.$type.val(),\n                current: this.$type.val()\n            };\n\n            this.bindAll();\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('setTypeProduct', function (event, type) {\n                this.setType(type);\n            }.bind(this));\n\n            //direct change type input\n            this.$type.on('change', function () {\n                this.type.current = this.$type.val();\n                this._notifyType();\n            }.bind(this));\n        },\n\n        /**\n         * Set type\n         * @param {String} type - type product (downloadable, simple, virtual ...)\n         * @returns {*}\n         */\n        setType: function (type) {\n            return this.$type.val(type || this.type.init).trigger('change');\n        },\n\n        /**\n         * Notify type\n         * @private\n         */\n        _notifyType: function () {\n            $(document).trigger('changeTypeProduct', this.type);\n        }\n    };\n});\n","Magento_Catalog/catalog/product-attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'jquery/ui',\n    'mage/translate'\n], function ($, _, registry) {\n    'use strict';\n\n    $.widget('mage.productAttributes', {\n        /** @inheritdoc */\n        _create: function () {\n            this._on({\n                'click': '_showPopup'\n            });\n        },\n\n        /**\n         * @private\n         */\n        _initModal: function () {\n            var self = this;\n\n            this.modal = $('<div id=\"create_new_attribute\"></div>').modal({\n                title: $.mage.__('New Attribute'),\n                type: 'slide',\n                buttons: [],\n\n                /** @inheritdoc */\n                opened: function () {\n                    $(this).parent().addClass('modal-content-new-attribute');\n                    self.iframe = $('<iframe id=\"create_new_attribute_container\"></iframe>').attr({\n                        src: self._prepareUrl(),\n                        frameborder: 0\n                    });\n                    self.modal.append(self.iframe);\n                    self._changeIframeSize();\n                    $(window).off().on('resize.modal', _.debounce(self._changeIframeSize.bind(self), 400));\n                },\n\n                /** @inheritdoc */\n                closed: function () {\n                    var doc = self.iframe.get(0).document;\n\n                    if (doc && typeof doc.execCommand === 'function') {\n                        //IE9 break script loading but not execution on iframe removing\n                        doc.execCommand('stop');\n                        self.iframe.remove();\n                    }\n                    self.modal.data('mageModal').modal.remove();\n                    $(window).off('resize.modal');\n                }\n            });\n        },\n\n        /**\n         * @return {Number}\n         * @private\n         */\n        _getHeight: function () {\n            var modal = this.modal.data('mageModal').modal,\n                modalHead = modal.find('header'),\n                modalHeadHeight = modalHead.outerHeight(),\n                modalHeight = modal.outerHeight(),\n                modalContentPadding = this.modal.parent().outerHeight() - this.modal.parent().height();\n\n            return modalHeight - modalHeadHeight - modalContentPadding;\n        },\n\n        /**\n         * @return {Number}\n         * @private\n         */\n        _getWidth: function () {\n            return this.modal.width();\n        },\n\n        /**\n         * @private\n         */\n        _changeIframeSize: function () {\n            this.modal.parent().outerHeight(this._getHeight());\n            this.iframe.outerHeight(this._getHeight());\n            this.iframe.outerWidth(this._getWidth());\n\n        },\n\n        /**\n         * @return {String}\n         * @private\n         */\n        _prepareUrl: function () {\n            var productSource,\n                attributeSetId = '';\n\n            if (this.options.dataProvider) {\n                try {\n                    productSource = registry.get(this.options.dataProvider);\n                    attributeSetId = productSource.data.product['attribute_set_id'];\n                } catch (e) {}\n            }\n\n            return this.options.url +\n                (/\\?/.test(this.options.url) ? '&' : '?') +\n                'set=' + attributeSetId;\n        },\n\n        /**\n         * @private\n         */\n        _showPopup: function () {\n            this._initModal();\n            this.modal.modal('openModal');\n        }\n    });\n\n    return $.mage.productAttributes;\n});\n","Magento_Catalog/catalog/base-image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'jquery/file-uploader',\n    'mage/translate',\n    'mage/backend/notification'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.baseImage', {\n        /**\n         * Button creation\n         * @protected\n         */\n        options: {\n            maxImageUploadCount: 10\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var $container = this.element,\n                imageTmpl = mageTemplate(this.element.find('[data-template=image]').html()),\n                $dropPlaceholder = this.element.find('.image-placeholder'),\n                $galleryContainer = $('#media_gallery_content'),\n                mainClass = 'base-image',\n                maximumImageCount = 5,\n                $fieldCheckBox = $container.closest('[data-attribute-code=image]').find(':checkbox'),\n                isDefaultChecked = $fieldCheckBox.is(':checked'),\n                findElement, updateVisibility;\n\n            if (isDefaultChecked) {\n                $fieldCheckBox.trigger('click');\n            }\n\n            /**\n             * @param {Object} data\n             * @return {HTMLElement}\n             */\n            findElement = function (data) {\n                return $container.find('.image:not(.image-placeholder)').filter(function () {\n                    if (!$(this).data('image')) {\n                        return false;\n                    }\n\n                    return $(this).data('image').file === data.file;\n                }).first();\n            };\n\n            /** Update image visibility. */\n            updateVisibility = function () {\n                var elementsList = $container.find('.image:not(.removed-item)');\n\n                elementsList.each(function (index) {\n                    $(this)[index < maximumImageCount ? 'show' : 'hide']();\n                });\n                $dropPlaceholder[elementsList.length > maximumImageCount ? 'hide' : 'show']();\n            };\n\n            $galleryContainer.on('setImageType', function (event, data) {\n                if (data.type === 'image') {\n                    $container.find('.' + mainClass).removeClass(mainClass);\n\n                    if (data.imageData) {\n                        findElement(data.imageData).addClass(mainClass);\n                    }\n                }\n            });\n\n            $galleryContainer.on('addItem', function (event, data) {\n                var tmpl = imageTmpl({\n                    data: data\n                });\n\n                $(tmpl).data('image', data).insertBefore($dropPlaceholder);\n\n                updateVisibility();\n            });\n\n            $galleryContainer.on('removeItem', function (event, image) {\n                findElement(image).addClass('removed-item').hide();\n                updateVisibility();\n            });\n\n            $galleryContainer.on('moveElement', function (event, data) {\n                var $element = findElement(data.imageData),\n                    $after;\n\n                if (data.position === 0) {\n                    $container.prepend($element);\n                } else {\n                    $after = $container.find('.image').eq(data.position);\n\n                    if (!$element.is($after)) {\n                        $element.insertAfter($after);\n                    }\n                }\n                updateVisibility();\n            });\n\n            $container.on('click', '[data-role=make-base-button]', function (event) {\n                var data;\n\n                event.preventDefault();\n                data = $(event.target).closest('.image').data('image');\n                $galleryContainer.productGallery('setBase', data);\n            });\n\n            $container.on('click', '[data-role=delete-button]', function (event) {\n                event.preventDefault();\n                $galleryContainer.trigger('removeItem', $(event.target).closest('.image').data('image'));\n            });\n\n            $container.sortable({\n                axis: 'x',\n                items: '.image:not(.image-placeholder)',\n                distance: 8,\n                tolerance: 'pointer',\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                stop: function (event, data) {\n                    $galleryContainer.trigger('setPosition', {\n                        imageData: data.item.data('image'),\n                        position: $container.find('.image').index(data.item)\n                    });\n                    $galleryContainer.trigger('resort');\n                }\n            }).disableSelection();\n\n            this.element.find('input[type=\"file\"]').fileupload({\n                dataType: 'json',\n                dropZone: $dropPlaceholder.closest('[data-attribute-code]'),\n                acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n                maxFileSize: this.element.data('maxFileSize'),\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                done: function (event, data) {\n                    $dropPlaceholder.find('.progress-bar').text('').removeClass('in-progress');\n\n                    if (!data.result) {\n                        return;\n                    }\n\n                    if (!data.result.error) {\n                        $galleryContainer.trigger('addItem', data.result);\n                    } else {\n                        alert({\n                            content: $.mage.__('We don\\'t recognize or support this file extension type.')\n                        });\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} data\n                 */\n                change: function (e, data) {\n                    if (data.files.length > this.options.maxImageUploadCount) {\n                        $('body').notification('clear').notification('add', {\n                            error: true,\n                            message: $.mage.__('You can\\'t upload more than ' + this.options.maxImageUploadCount +\n                                ' images in one time'),\n\n                            /**\n                             * @param {*} message\n                             */\n                            insertMethod: function (message) {\n                                $('.page-main-actions').after(message);\n                            }\n                        });\n\n                        return false;\n                    }\n                }.bind(this),\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {*} data\n                 */\n                add: function (event, data) {\n                    $(this).fileupload('process', data).done(function () {\n                        data.submit();\n                    });\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} data\n                 */\n                progress: function (e, data) {\n                    var progress = parseInt(data.loaded / data.total * 100, 10);\n\n                    $dropPlaceholder.find('.progress-bar').addClass('in-progress').text(progress + '%');\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                start: function (event) {\n                    var uploaderContainer = $(event.target).closest('.image-placeholder');\n\n                    uploaderContainer.addClass('loading');\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                stop: function (event) {\n                    var uploaderContainer = $(event.target).closest('.image-placeholder');\n\n                    uploaderContainer.removeClass('loading');\n                }\n            });\n        }\n    });\n\n    return $.mage.baseImage;\n});\n","Magento_Catalog/catalog/apply-to-type-switcher.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events'\n], function ($, productType) {\n    'use strict';\n\n    return {\n\n        /**\n         * Bind event\n         */\n        bindAll: function () {\n            $('[data-form=edit-product] [data-role=tabs]').on(\n                'contentUpdated',\n                this._switchToTypeByApplyAttr.bind(this)\n            );\n\n            $('#product_info_tabs').on(\n                'beforePanelsMove tabscreate tabsactivate',\n                this._switchToTypeByApplyAttr.bind(this)\n            );\n\n            $(document).on('changeTypeProduct', this._switchToTypeByApplyAttr.bind(this));\n        },\n\n        /**\n         * Constructor component\n         */\n        'Magento_Catalog/catalog/apply-to-type-switcher': function () {\n            this.bindAll();\n            this._switchToTypeByApplyAttr();\n        },\n\n        /**\n         * Show/hide elements based on type\n         *\n         * @private\n         */\n        _switchToTypeByApplyAttr: function () {\n            $('[data-apply-to]:not(.removed)').each(function (index, element) {\n                var attrContainer = $(element),\n                    applyTo = attrContainer.data('applyTo') || [],\n                    $inputs = attrContainer.find('select, input, textarea');\n\n                if (applyTo.length === 0 || $.inArray(productType.type.current, applyTo) !== -1) {\n                    attrContainer.removeClass('not-applicable-attribute');\n                    $inputs.removeClass('ignore-validate');\n                } else {\n                    attrContainer.addClass('not-applicable-attribute');\n                    $inputs.addClass('ignore-validate');\n                }\n            });\n        }\n    };\n});\n","Magento_Catalog/catalog/product/attribute/unique-validate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/backend/validation'\n], function (jQuery) {\n    'use strict';\n\n    return function (config) {\n        var msg = '',\n            _config = jQuery.extend({\n                element: null,\n                message: '',\n                uniqueClass: 'required-unique'\n            }, config),\n\n            /** @inheritdoc */\n            messager = function () {\n                return msg;\n            };\n\n        if (typeof _config.element === 'string') {\n            jQuery.validator.addMethod(\n                _config.element,\n\n                function (value, element) {\n                    var inputs = jQuery(element)\n                            .closest('table')\n                            .find('.' + _config.uniqueClass + ':visible'),\n                        valuesHash = {},\n                        isValid = true,\n                        duplicates = [];\n\n                    inputs.each(function (el) {\n                        var inputValue = inputs[el].value;\n\n                        if (typeof valuesHash[inputValue] !== 'undefined') {\n                            isValid = false;\n                            duplicates.push(inputValue);\n                        }\n                        valuesHash[inputValue] = el;\n                    });\n\n                    if (!isValid) {\n                        msg = _config.message + ' (' + duplicates.join(', ') + ')';\n                    }\n\n                    return isValid;\n                },\n\n                messager\n            );\n        }\n    };\n});\n","Magento_Catalog/catalog/product/composite/configure.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async',\n    'jquery/ui',\n    'mage/translate',\n    'prototype',\n    'Magento_Ui/js/modal/modal'\n], function (jQuery) {\n\n    window.ProductConfigure = Class.create();\n\n    ProductConfigure.prototype = {\n\n        listTypes:                  $H({}),\n        current:                    $H({}),\n        itemsFilter:                $H({}),\n        blockWindow:                null,\n        blockForm:                  null,\n        blockFormFields:            null,\n        blockFormAdd:               null,\n        blockFormConfirmed:         null,\n        blockConfirmed:             null,\n        blockIFrame:                null,\n        blockCancelBtn:             null,\n        blockMask:                  null,\n        blockMsg:                   null,\n        blockMsgError:              null,\n        windowHeight:               null,\n        confirmedCurrentId:         null,\n        confirmCallback:            {},\n        cancelCallback:             {},\n        onLoadIFrameCallback:       {},\n        showWindowCallback:         {},\n        beforeSubmitCallback:       {},\n        iFrameJSVarname:            null,\n        _listTypeId:                1,\n\n        /**\n         * Initialize object\n         */\n        initialize: function () {\n            var self = this,\n                popupDialog = jQuery('#product_composite_configure');\n\n            this._initWindowElements();\n            jQuery.async('#product_composite_configure', function (el) {\n                if (el !== popupDialog[0]) {\n                    el = popupDialog[0];\n                }\n                self.dialog = jQuery(el).modal({\n                    title: jQuery.mage.__('Configure Product'),\n                    type: 'slide',\n                    buttons: [{\n                        text: jQuery.mage.__('OK'),\n                        'class': 'action-primary',\n                        click: function () {\n                            self.onConfirmBtn();\n                        }\n                    }],\n                    closed: function () {\n                        self.clean('window');\n                    },\n                });\n            });\n        },\n\n        /**\n         * Initialize window elements\n         */\n        _initWindowElements: function () {\n            this.blockWindow                = $('product_composite_configure');\n            this.blockForm                  = $('product_composite_configure_form');\n            this.blockFormFields            = $('product_composite_configure_form_fields');\n            this.blockFormAdd               = $('product_composite_configure_form_additional');\n            this.blockFormConfirmed         = $('product_composite_configure_form_confirmed');\n            this.blockConfirmed             = $('product_composite_configure_confirmed');\n            this.blockIFrame                = $('product_composite_configure_iframe');\n            this.blockCancelBtn             = $('product_composite_configure_form_cancel');\n            this.blockMsg                   = $('product_composite_configure_messages');\n            this.blockMsgError              = this.blockMsg.select('.message.error div')[0];\n            this.iFrameJSVarname            = this.blockForm.select('input[name=\"as_js_varname\"]')[0].value;\n        },\n\n        /**\n         * Returns next unique list type id\n         */\n        _generateListTypeId: function () {\n            return '_internal_lt_' + this._listTypeId++;\n        },\n\n        /**\n         * Add product list types as scope and their urls\n         * example: addListType('product_to_add', {urlFetch: 'http://magento...'})\n         * example: addListType('wishlist', {urlSubmit: 'http://magento...'})\n         *\n         * @param type types as scope\n         * @param urls obj can be\n         *             - {urlFetch: 'http://magento...'} for fetching configuration fields through ajax\n         *             - {urlConfirm: 'http://magento...'} for submit configured data through iFrame when clicked confirm button\n         *             - {urlSubmit: 'http://magento...'} for submit configured data through iFrame\n         */\n        addListType: function (type, urls) {\n            if ('undefined' == typeof this.listTypes[type]) {\n                this.listTypes[type] = {};\n            }\n            Object.extend(this.listTypes[type], urls);\n\n            return this;\n        },\n\n        /**\n         * Adds complex list type - that is used to submit several list types at once\n         * Only urlSubmit is possible for this list type\n         * example: addComplexListType(['wishlist', 'product_list'], 'http://magento...')\n         *\n         * @param type types as scope\n         * @param urls obj can be\n         *             - {urlSubmit: 'http://magento...'} for submit configured data through iFrame\n         * @return type string\n         */\n        addComplexListType: function (types, urlSubmit) {\n            var type = this._generateListTypeId();\n\n            this.listTypes[type] = {};\n            this.listTypes[type].complexTypes = types;\n            this.listTypes[type].urlSubmit = urlSubmit;\n\n            return type;\n        },\n\n        /**\n         * Add filter of items\n         *\n         * @param listType scope name\n         * @param itemsFilter\n         */\n        addItemsFilter: function (listType, itemsFilter) {\n            if (!listType || !itemsFilter) {\n                return false;\n            }\n\n            if ('undefined' == typeof this.itemsFilter[listType]) {\n                this.itemsFilter[listType] = [];\n            }\n            this.itemsFilter[listType] = this.itemsFilter[listType].concat(itemsFilter);\n\n            return this;\n        },\n\n        /**\n         * Returns id of block where configuration for an item is stored\n         *\n         * @param listType scope name\n         * @param itemId\n         * @return string\n         */\n        _getConfirmedBlockId: function (listType, itemId) {\n            return this.blockConfirmed.id + '[' + listType + '][' + itemId + ']';\n        },\n\n        /**\n         * Checks whether item has some configuration fields\n         *\n         * @param listType scope name\n         * @param itemId\n         * @return bool\n         */\n        itemConfigured: function (listType, itemId) {\n            var confirmedBlockId = this._getConfirmedBlockId(listType, itemId);\n            var itemBlock = $(confirmedBlockId);\n\n            return !!(itemBlock && itemBlock.innerHTML);\n        },\n\n        /**\n         * Show configuration fields of item, if it not found then get it through ajax\n         *\n         * @param listType scope name\n         * @param itemId\n         */\n        showItemConfiguration: function (listType, itemId) {\n            if (!listType || !itemId) {\n                return false;\n            }\n\n            this.initialize();\n            this.current.listType = listType;\n            this.current.itemId = itemId;\n            this.confirmedCurrentId = this._getConfirmedBlockId(listType, itemId);\n\n            if (!this.itemConfigured(listType, itemId)) {\n                this._requestItemConfiguration(listType, itemId);\n            } else {\n                this._processFieldsData('item_restore');\n                this._showWindow();\n            }\n        },\n\n        /**\n         * Get configuration fields of product through ajax and show them\n         *\n         * @param listType scope name\n         * @param itemId\n         */\n        _requestItemConfiguration: function (listType, itemId) {\n            if (!this.listTypes[listType].urlFetch) {\n                return false;\n            }\n            var url = this.listTypes[listType].urlFetch;\n\n            if (url) {\n                new Ajax.Request(url, {\n                    parameters: {\n                        id: itemId\n                    },\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response.isJSON()) {\n                            response = response.evalJSON();\n\n                            if (response.error) {\n                                this.blockMsg.show();\n                                this.blockMsgError.innerHTML = response.message;\n                                if(this.blockCancelBtn) {\n                                    this.blockCancelBtn.hide();\n                                }\n                                this.setConfirmCallback(listType, null);\n                                this._showWindow();\n                            }\n                        } else if (response) {\n                            response += '';\n                            this.blockFormFields.update(response);\n\n                            // Add special div to hold mage data, e.g. scripts to execute on every popup show\n                            var mageData = {};\n                            var scripts = response.extractScripts();\n\n                            mageData.scripts = scripts;\n\n                            var scriptHolder = new Element('div', {\n                                'style': 'display:none'\n                            });\n\n                            scriptHolder.mageData = mageData;\n                            this.blockFormFields.insert(scriptHolder);\n\n                            // Show window\n                            this._showWindow();\n                        }\n                    }.bind(this)\n                });\n            }\n        },\n\n        /**\n         * Triggered on confirm button click\n         * Do submit configured data through iFrame if needed\n         */\n        onConfirmBtn: function () {\n            if (jQuery(this.blockForm).valid()) {\n                if (this.listTypes[this.current.listType].urlConfirm) {\n                    this.submit();\n                } else {\n                    this._processFieldsData('item_confirm');\n                    this._closeWindow();\n\n                    if (Object.isFunction(this.confirmCallback[this.current.listType])) {\n                        this.confirmCallback[this.current.listType]();\n                    }\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Triggered on cancel button click\n         */\n        onCancelBtn: function () {\n            this._closeWindow();\n\n            if (Object.isFunction(this.cancelCallback[this.current.listType])) {\n                this.cancelCallback[this.current.listType]();\n            }\n\n            return this;\n        },\n\n        /**\n         * Submit configured data through iFrame\n         *\n         * @param listType scope name\n         */\n        submit: function (listType) {\n            // prepare data\n            if (listType) {\n                this.current.listType = listType;\n                this.current.itemId = null;\n            }\n            var urlConfirm = this.listTypes[this.current.listType].urlConfirm;\n            var urlSubmit = this.listTypes[this.current.listType].urlSubmit;\n\n            if (!urlConfirm && !urlSubmit) {\n                return false;\n            }\n\n            if (urlConfirm) {\n                this.blockForm.action = urlConfirm;\n                this.addFields([new Element('input', {\n                    type: 'hidden', name: 'id', value: this.current.itemId\n                })]);\n            } else {\n                this.blockForm.action = urlSubmit;\n\n                var complexTypes = this.listTypes[this.current.listType].complexTypes;\n\n                if (complexTypes) {\n                    this.addFields([new Element('input', {\n                        type: 'hidden', name: 'configure_complex_list_types', value: complexTypes.join(',')\n                    })]);\n                }\n\n                this._processFieldsData('current_confirmed_to_form');\n\n                // Disable item controls that duplicate added fields (e.g. sometimes qty controls can intersect)\n                // so they won't be submitted\n                var tagNames = ['input', 'select', 'textarea'];\n\n                var names = {}; // Map of added field names\n\n                for (var i = 0, len = tagNames.length; i < len; i++) {\n                    var tagName = tagNames[i];\n                    var elements = this.blockFormAdd.getElementsByTagName(tagName);\n\n                    for (var index = 0, elLen = elements.length; index < elLen; index++) {\n                        names[elements[index].name] = true;\n                    }\n                }\n\n                for (var i = 0, len = tagNames.length; i < len; i++) {\n                    var tagName = tagNames[i];\n                    var elements = this.block